// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16595){
var state_val_16596 = (state_16595[(1)]);
if((state_val_16596 === (1))){
var state_16595__$1 = state_16595;
var statearr_16597_16611 = state_16595__$1;
(statearr_16597_16611[(2)] = null);

(statearr_16597_16611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16596 === (2))){
var _ = (function (){var statearr_16598 = state_16595;
(statearr_16598[(4)] = cljs.core.cons((5),(state_16595[(4)])));

return statearr_16598;
})();
var inst_16586 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_16595__$1 = state_16595;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16595__$1,(6),inst_16586);
} else {
if((state_val_16596 === (3))){
var inst_16593 = (state_16595[(2)]);
var state_16595__$1 = state_16595;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16595__$1,inst_16593);
} else {
if((state_val_16596 === (4))){
var inst_16580 = (state_16595[(2)]);
var state_16595__$1 = state_16595;
var statearr_16600_16612 = state_16595__$1;
(statearr_16600_16612[(2)] = inst_16580);

(statearr_16600_16612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16596 === (5))){
var _ = (function (){var statearr_16601 = state_16595;
(statearr_16601[(4)] = cljs.core.rest((state_16595[(4)])));

return statearr_16601;
})();
var state_16595__$1 = state_16595;
var ex16599 = (state_16595__$1[(2)]);
var statearr_16602_16613 = state_16595__$1;
(statearr_16602_16613[(5)] = ex16599);


if((ex16599 instanceof Error)){
var statearr_16603_16614 = state_16595__$1;
(statearr_16603_16614[(1)] = (4));

(statearr_16603_16614[(5)] = null);

} else {
throw ex16599;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16596 === (6))){
var inst_16588 = (state_16595[(2)]);
var inst_16589 = fluree.db.util.async.throw_err(inst_16588);
var inst_16590 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_16589);
var _ = (function (){var statearr_16604 = state_16595;
(statearr_16604[(4)] = cljs.core.rest((state_16595[(4)])));

return statearr_16604;
})();
var state_16595__$1 = state_16595;
var statearr_16605_16615 = state_16595__$1;
(statearr_16605_16615[(2)] = inst_16590);

(statearr_16605_16615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0 = (function (){
var statearr_16606 = [null,null,null,null,null,null,null];
(statearr_16606[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__);

(statearr_16606[(1)] = (1));

return statearr_16606;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1 = (function (state_16595){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16595);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16607){var ex__2687__auto__ = e16607;
var statearr_16608_16616 = state_16595;
(statearr_16608_16616[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16595[(4)]))){
var statearr_16609_16617 = state_16595;
(statearr_16609_16617[(1)] = cljs.core.first((state_16595[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16618 = state_16595;
state_16595 = G__16618;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__ = function(state_16595){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1.call(this,state_16595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16610 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16610[(6)] = c__2706__auto__);

return statearr_16610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16650){
var state_val_16651 = (state_16650[(1)]);
if((state_val_16651 === (7))){
var inst_16634 = (state_16650[(7)]);
var inst_16636 = cljs.core.empty_QMARK_(inst_16634);
var inst_16637 = (!(inst_16636));
var state_16650__$1 = state_16650;
var statearr_16652_16676 = state_16650__$1;
(statearr_16652_16676[(2)] = inst_16637);

(statearr_16652_16676[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16651 === (1))){
var state_16650__$1 = state_16650;
var statearr_16653_16677 = state_16650__$1;
(statearr_16653_16677[(2)] = null);

(statearr_16653_16677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16651 === (4))){
var inst_16620 = (state_16650[(2)]);
var state_16650__$1 = state_16650;
var statearr_16654_16678 = state_16650__$1;
(statearr_16654_16678[(2)] = inst_16620);

(statearr_16654_16678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16651 === (6))){
var inst_16634 = (state_16650[(7)]);
var inst_16626 = (state_16650[(8)]);
var inst_16632 = (state_16650[(2)]);
var inst_16633 = fluree.db.util.async.throw_err(inst_16632);
var inst_16634__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16626,inst_16633);
var state_16650__$1 = (function (){var statearr_16655 = state_16650;
(statearr_16655[(7)] = inst_16634__$1);

return statearr_16655;
})();
if(cljs.core.truth_(inst_16634__$1)){
var statearr_16656_16679 = state_16650__$1;
(statearr_16656_16679[(1)] = (7));

} else {
var statearr_16657_16680 = state_16650__$1;
(statearr_16657_16680[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16651 === (3))){
var inst_16648 = (state_16650[(2)]);
var state_16650__$1 = state_16650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16650__$1,inst_16648);
} else {
if((state_val_16651 === (12))){
var inst_16645 = (state_16650[(2)]);
var _ = (function (){var statearr_16658 = state_16650;
(statearr_16658[(4)] = cljs.core.rest((state_16650[(4)])));

return statearr_16658;
})();
var state_16650__$1 = state_16650;
var statearr_16659_16681 = state_16650__$1;
(statearr_16659_16681[(2)] = inst_16645);

(statearr_16659_16681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16651 === (2))){
var _ = (function (){var statearr_16660 = state_16650;
(statearr_16660[(4)] = cljs.core.cons((5),(state_16650[(4)])));

return statearr_16660;
})();
var inst_16626 = (function (){return (function (p1__16619_SHARP_){
return p1__16619_SHARP_.o;
});
})();
var inst_16627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16628 = [pred_id];
var inst_16629 = (new cljs.core.PersistentVector(null,1,(5),inst_16627,inst_16628,null));
var inst_16630 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16629);
var state_16650__$1 = (function (){var statearr_16661 = state_16650;
(statearr_16661[(8)] = inst_16626);

return statearr_16661;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16650__$1,(6),inst_16630);
} else {
if((state_val_16651 === (11))){
var state_16650__$1 = state_16650;
var statearr_16663_16682 = state_16650__$1;
(statearr_16663_16682[(2)] = true);

(statearr_16663_16682[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16651 === (9))){
var inst_16640 = (state_16650[(2)]);
var state_16650__$1 = state_16650;
if(cljs.core.truth_(inst_16640)){
var statearr_16664_16683 = state_16650__$1;
(statearr_16664_16683[(1)] = (10));

} else {
var statearr_16665_16684 = state_16650__$1;
(statearr_16665_16684[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16651 === (5))){
var _ = (function (){var statearr_16666 = state_16650;
(statearr_16666[(4)] = cljs.core.rest((state_16650[(4)])));

return statearr_16666;
})();
var state_16650__$1 = state_16650;
var ex16662 = (state_16650__$1[(2)]);
var statearr_16667_16685 = state_16650__$1;
(statearr_16667_16685[(5)] = ex16662);


if((ex16662 instanceof Error)){
var statearr_16668_16686 = state_16650__$1;
(statearr_16668_16686[(1)] = (4));

(statearr_16668_16686[(5)] = null);

} else {
throw ex16662;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16651 === (10))){
var inst_16634 = (state_16650[(7)]);
var inst_16642 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_16634);
var state_16650__$1 = state_16650;
var statearr_16669_16687 = state_16650__$1;
(statearr_16669_16687[(2)] = inst_16642);

(statearr_16669_16687[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16651 === (8))){
var inst_16634 = (state_16650[(7)]);
var state_16650__$1 = state_16650;
var statearr_16670_16688 = state_16650__$1;
(statearr_16670_16688[(2)] = inst_16634);

(statearr_16670_16688[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_16671 = [null,null,null,null,null,null,null,null,null];
(statearr_16671[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__);

(statearr_16671[(1)] = (1));

return statearr_16671;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1 = (function (state_16650){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16650);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16672){var ex__2687__auto__ = e16672;
var statearr_16673_16689 = state_16650;
(statearr_16673_16689[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16650[(4)]))){
var statearr_16674_16690 = state_16650;
(statearr_16674_16690[(1)] = cljs.core.first((state_16650[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16691 = state_16650;
state_16650 = G__16691;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__ = function(state_16650){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1.call(this,state_16650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16675 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16675[(6)] = c__2706__auto__);

return statearr_16675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16772){
var state_val_16773 = (state_16772[(1)]);
if((state_val_16773 === (7))){
var state_16772__$1 = state_16772;
var statearr_16774_16812 = state_16772__$1;
(statearr_16774_16812[(2)] = flakes);

(statearr_16774_16812[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (20))){
var inst_16729 = (state_16772[(7)]);
var inst_16762 = (state_16772[(2)]);
var inst_16721 = inst_16729;
var inst_16722 = inst_16762;
var state_16772__$1 = (function (){var statearr_16775 = state_16772;
(statearr_16775[(8)] = inst_16721);

(statearr_16775[(9)] = inst_16722);

return statearr_16775;
})();
var statearr_16776_16813 = state_16772__$1;
(statearr_16776_16813[(2)] = null);

(statearr_16776_16813[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (1))){
var state_16772__$1 = state_16772;
var statearr_16777_16814 = state_16772__$1;
(statearr_16777_16814[(2)] = null);

(statearr_16777_16814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (4))){
var inst_16694 = (state_16772[(2)]);
var state_16772__$1 = state_16772;
var statearr_16778_16815 = state_16772__$1;
(statearr_16778_16815[(2)] = inst_16694);

(statearr_16778_16815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (15))){
var inst_16728 = (state_16772[(10)]);
var inst_16746 = inst_16728.o;
var state_16772__$1 = state_16772;
var statearr_16779_16816 = state_16772__$1;
(statearr_16779_16816[(2)] = inst_16746);

(statearr_16779_16816[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (13))){
var inst_16765 = (state_16772[(2)]);
var state_16772__$1 = state_16772;
var statearr_16780_16817 = state_16772__$1;
(statearr_16780_16817[(2)] = inst_16765);

(statearr_16780_16817[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (6))){
var inst_16701 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16772__$1 = state_16772;
var statearr_16781_16818 = state_16772__$1;
(statearr_16781_16818[(2)] = inst_16701);

(statearr_16781_16818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (17))){
var inst_16743 = (state_16772[(2)]);
var inst_16744 = fluree.db.util.async.throw_err(inst_16743);
var state_16772__$1 = state_16772;
var statearr_16782_16819 = state_16772__$1;
(statearr_16782_16819[(2)] = inst_16744);

(statearr_16782_16819[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (3))){
var inst_16770 = (state_16772[(2)]);
var state_16772__$1 = state_16772;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16772__$1,inst_16770);
} else {
if((state_val_16773 === (12))){
var inst_16735 = (state_16772[(11)]);
var inst_16728 = (state_16772[(10)]);
var inst_16733 = inst_16728.p;
var inst_16734 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16733);
var inst_16735__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_16734);
var inst_16736 = inst_16728.op;
var inst_16737 = inst_16736 === false;
var inst_16738 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_16735__$1);
var state_16772__$1 = (function (){var statearr_16783 = state_16772;
(statearr_16783[(12)] = inst_16737);

(statearr_16783[(11)] = inst_16735__$1);

return statearr_16783;
})();
if(inst_16738){
var statearr_16784_16820 = state_16772__$1;
(statearr_16784_16820[(1)] = (14));

} else {
var statearr_16785_16821 = state_16772__$1;
(statearr_16785_16821[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (2))){
var _ = (function (){var statearr_16786 = state_16772;
(statearr_16786[(4)] = cljs.core.cons((5),(state_16772[(4)])));

return statearr_16786;
})();
var state_16772__$1 = state_16772;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16787_16822 = state_16772__$1;
(statearr_16787_16822[(1)] = (6));

} else {
var statearr_16788_16823 = state_16772__$1;
(statearr_16788_16823[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (19))){
var inst_16735 = (state_16772[(11)]);
var inst_16728 = (state_16772[(10)]);
var inst_16722 = (state_16772[(9)]);
var inst_16748 = (state_16772[(13)]);
var inst_16756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16757 = inst_16728.s;
var inst_16758 = [inst_16757,inst_16735,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16759 = (new cljs.core.PersistentVector(null,3,(5),inst_16756,inst_16758,null));
var inst_16760 = cljs.core.assoc_in(inst_16722,inst_16759,inst_16748);
var state_16772__$1 = state_16772;
var statearr_16789_16824 = state_16772__$1;
(statearr_16789_16824[(2)] = inst_16760);

(statearr_16789_16824[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (11))){
var inst_16722 = (state_16772[(9)]);
var state_16772__$1 = state_16772;
var statearr_16791_16825 = state_16772__$1;
(statearr_16791_16825[(2)] = inst_16722);

(statearr_16791_16825[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (9))){
var inst_16721 = (state_16772[(8)]);
var inst_16728 = (state_16772[(10)]);
var inst_16727 = cljs.core.seq(inst_16721);
var inst_16728__$1 = cljs.core.first(inst_16727);
var inst_16729 = cljs.core.next(inst_16727);
var inst_16730 = cljs.core.not(inst_16728__$1);
var state_16772__$1 = (function (){var statearr_16792 = state_16772;
(statearr_16792[(7)] = inst_16729);

(statearr_16792[(10)] = inst_16728__$1);

return statearr_16792;
})();
if(inst_16730){
var statearr_16793_16826 = state_16772__$1;
(statearr_16793_16826[(1)] = (11));

} else {
var statearr_16794_16827 = state_16772__$1;
(statearr_16794_16827[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (5))){
var _ = (function (){var statearr_16795 = state_16772;
(statearr_16795[(4)] = cljs.core.rest((state_16772[(4)])));

return statearr_16795;
})();
var state_16772__$1 = state_16772;
var ex16790 = (state_16772__$1[(2)]);
var statearr_16796_16828 = state_16772__$1;
(statearr_16796_16828[(5)] = ex16790);


if((ex16790 instanceof Error)){
var statearr_16797_16829 = state_16772__$1;
(statearr_16797_16829[(1)] = (4));

(statearr_16797_16829[(5)] = null);

} else {
throw ex16790;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (14))){
var inst_16728 = (state_16772[(10)]);
var inst_16740 = inst_16728.o;
var inst_16741 = fluree.db.query.schema.convert_type_to_kw(inst_16740,db);
var state_16772__$1 = state_16772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16772__$1,(17),inst_16741);
} else {
if((state_val_16773 === (16))){
var inst_16737 = (state_16772[(12)]);
var inst_16748 = (state_16772[(2)]);
var state_16772__$1 = (function (){var statearr_16798 = state_16772;
(statearr_16798[(13)] = inst_16748);

return statearr_16798;
})();
if(cljs.core.truth_(inst_16737)){
var statearr_16799_16830 = state_16772__$1;
(statearr_16799_16830[(1)] = (18));

} else {
var statearr_16800_16831 = state_16772__$1;
(statearr_16800_16831[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (10))){
var inst_16767 = (state_16772[(2)]);
var _ = (function (){var statearr_16801 = state_16772;
(statearr_16801[(4)] = cljs.core.rest((state_16772[(4)])));

return statearr_16801;
})();
var state_16772__$1 = state_16772;
var statearr_16802_16832 = state_16772__$1;
(statearr_16802_16832[(2)] = inst_16767);

(statearr_16802_16832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (18))){
var inst_16735 = (state_16772[(11)]);
var inst_16728 = (state_16772[(10)]);
var inst_16722 = (state_16772[(9)]);
var inst_16748 = (state_16772[(13)]);
var inst_16750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16751 = inst_16728.s;
var inst_16752 = [inst_16751,inst_16735,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16753 = (new cljs.core.PersistentVector(null,3,(5),inst_16750,inst_16752,null));
var inst_16754 = cljs.core.assoc_in(inst_16722,inst_16753,inst_16748);
var state_16772__$1 = state_16772;
var statearr_16803_16833 = state_16772__$1;
(statearr_16803_16833[(2)] = inst_16754);

(statearr_16803_16833[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16773 === (8))){
var inst_16704 = (state_16772[(2)]);
var inst_16705 = cljs.core.PersistentHashSet.EMPTY;
var inst_16706 = cljs.core.vals(tempids);
var inst_16707 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16705,inst_16706);
var inst_16708 = (function (){var pred_flakes = inst_16704;
var is_new_QMARK_ = inst_16707;
return (function (p1__16693_SHARP_,p2__16692_SHARP_){
var f = p2__16692_SHARP_;
return cljs.core.assoc_in(p1__16693_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__16804 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__16804) : is_new_QMARK_.call(null,G__16804));
})()));
});
})();
var inst_16709 = cljs.core.PersistentHashMap.EMPTY;
var inst_16710 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16708,inst_16709,inst_16704);
var inst_16718 = cljs.core.seq(inst_16704);
var inst_16719 = cljs.core.first(inst_16718);
var inst_16720 = cljs.core.next(inst_16718);
var inst_16721 = inst_16704;
var inst_16722 = inst_16710;
var state_16772__$1 = (function (){var statearr_16805 = state_16772;
(statearr_16805[(8)] = inst_16721);

(statearr_16805[(14)] = inst_16719);

(statearr_16805[(9)] = inst_16722);

(statearr_16805[(15)] = inst_16720);

return statearr_16805;
})();
var statearr_16806_16834 = state_16772__$1;
(statearr_16806_16834[(2)] = null);

(statearr_16806_16834[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0 = (function (){
var statearr_16807 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16807[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__);

(statearr_16807[(1)] = (1));

return statearr_16807;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1 = (function (state_16772){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16772);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16808){var ex__2687__auto__ = e16808;
var statearr_16809_16835 = state_16772;
(statearr_16809_16835[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16772[(4)]))){
var statearr_16810_16836 = state_16772;
(statearr_16810_16836[(1)] = cljs.core.first((state_16772[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16837 = state_16772;
state_16772 = G__16837;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__ = function(state_16772){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1.call(this,state_16772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16811 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16811[(6)] = c__2706__auto__);

return statearr_16811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16839 = arguments.length;
switch (G__16839) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16842 = arguments.length;
switch (G__16842) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17154){
var state_val_17155 = (state_17154[(1)]);
if((state_val_17155 === (121))){
var inst_17109 = (state_17154[(7)]);
var state_17154__$1 = state_17154;
var statearr_17156_17349 = state_17154__$1;
(statearr_17156_17349[(2)] = inst_17109);

(statearr_17156_17349[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (65))){
var inst_17008 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_17008)){
var statearr_17157_17350 = state_17154__$1;
(statearr_17157_17350[(1)] = (66));

} else {
var statearr_17158_17351 = state_17154__$1;
(statearr_17158_17351[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (70))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17018 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_17019 = (inst_17014.cljs$core$IFn$_invoke$arity$5 ? inst_17014.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_17018,null) : inst_17014.call(null,cljs.core.PersistentArrayMap,null,3,inst_17018,null));
var inst_17020 = (inst_17014.cljs$core$IFn$_invoke$arity$4 ? inst_17014.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17019,null) : inst_17014.call(null,cljs.core.PersistentHashSet,null,inst_17019,null));
var inst_17021 = (inst_17020.cljs$core$IFn$_invoke$arity$1 ? inst_17020.cljs$core$IFn$_invoke$arity$1(inst_17013) : inst_17020.call(null,inst_17013));
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_17021)){
var statearr_17159_17352 = state_17154__$1;
(statearr_17159_17352[(1)] = (72));

} else {
var statearr_17160_17353 = state_17154__$1;
(statearr_17160_17353[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (62))){
var inst_16998 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17161_17354 = state_17154__$1;
(statearr_17161_17354[(2)] = inst_16998);

(statearr_17161_17354[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (74))){
var inst_17104 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17162_17355 = state_17154__$1;
(statearr_17162_17355[(2)] = inst_17104);

(statearr_17162_17355[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (110))){
var inst_17131 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_17131)){
var statearr_17163_17356 = state_17154__$1;
(statearr_17163_17356[(1)] = (117));

} else {
var statearr_17164_17357 = state_17154__$1;
(statearr_17164_17357[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (7))){
var inst_17149 = (state_17154[(2)]);
var _ = (function (){var statearr_17165 = state_17154;
(statearr_17165[(4)] = cljs.core.rest((state_17154[(4)])));

return statearr_17165;
})();
var state_17154__$1 = state_17154;
var statearr_17166_17358 = state_17154__$1;
(statearr_17166_17358[(2)] = inst_17149);

(statearr_17166_17358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (59))){
var inst_17002 = (state_17154[(10)]);
var inst_16882 = (state_17154[(11)]);
var inst_17001 = (state_17154[(2)]);
var inst_17002__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16882);
var state_17154__$1 = (function (){var statearr_17167 = state_17154;
(statearr_17167[(12)] = inst_17001);

(statearr_17167[(10)] = inst_17002__$1);

return statearr_17167;
})();
if(cljs.core.truth_(inst_17002__$1)){
var statearr_17168_17359 = state_17154__$1;
(statearr_17168_17359[(1)] = (63));

} else {
var statearr_17169_17360 = state_17154__$1;
(statearr_17169_17360[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (86))){
var inst_17044 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17170_17361 = state_17154__$1;
(statearr_17170_17361[(2)] = inst_17044);

(statearr_17170_17361[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (20))){
var inst_16908 = (state_17154[(13)]);
var inst_16882 = (state_17154[(11)]);
var inst_16908__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16882);
var state_17154__$1 = (function (){var statearr_17171 = state_17154;
(statearr_17171[(13)] = inst_16908__$1);

return statearr_17171;
})();
if(cljs.core.truth_(inst_16908__$1)){
var statearr_17172_17362 = state_17154__$1;
(statearr_17172_17362[(1)] = (23));

} else {
var statearr_17173_17363 = state_17154__$1;
(statearr_17173_17363[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (72))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17023 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17013,inst_17014,throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17174_17364 = state_17154__$1;
(statearr_17174_17364[(2)] = inst_17023);

(statearr_17174_17364[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (58))){
var inst_16963 = (state_17154[(14)]);
var state_17154__$1 = state_17154;
var statearr_17175_17365 = state_17154__$1;
(statearr_17175_17365[(2)] = inst_16963);

(statearr_17175_17365[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (60))){
var inst_16870 = (state_17154[(15)]);
var inst_16881 = (state_17154[(16)]);
var inst_16989 = fluree.db.dbproto._p_prop(inst_16870,new cljs.core.Keyword(null,"name","name",1843675177),inst_16881);
var inst_16990 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16989)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16991 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16992 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16993 = cljs.core.PersistentHashMap.fromArrays(inst_16991,inst_16992);
var inst_16994 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16990,inst_16993);
var inst_16995 = (function(){throw inst_16994})();
var state_17154__$1 = state_17154;
var statearr_17176_17366 = state_17154__$1;
(statearr_17176_17366[(2)] = inst_16995);

(statearr_17176_17366[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (27))){
var inst_16911 = (state_17154[(17)]);
var state_17154__$1 = state_17154;
var statearr_17177_17367 = state_17154__$1;
(statearr_17177_17367[(2)] = inst_16911);

(statearr_17177_17367[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (1))){
var state_17154__$1 = state_17154;
var statearr_17178_17368 = state_17154__$1;
(statearr_17178_17368[(2)] = null);

(statearr_17178_17368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (69))){
var inst_17001 = (state_17154[(12)]);
var state_17154__$1 = state_17154;
var statearr_17179_17369 = state_17154__$1;
(statearr_17179_17369[(2)] = inst_17001);

(statearr_17179_17369[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (101))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17082 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17013,inst_17014,throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17180_17370 = state_17154__$1;
(statearr_17180_17370[(2)] = inst_17082);

(statearr_17180_17370[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (24))){
var inst_16908 = (state_17154[(13)]);
var state_17154__$1 = state_17154;
var statearr_17181_17371 = state_17154__$1;
(statearr_17181_17371[(2)] = inst_16908);

(statearr_17181_17371[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (102))){
var inst_17084 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17182_17372 = state_17154__$1;
(statearr_17182_17372[(2)] = inst_17084);

(statearr_17182_17372[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (55))){
var inst_16980 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17183_17373 = state_17154__$1;
(statearr_17183_17373[(2)] = inst_16980);

(statearr_17183_17373[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (85))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17042 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17013,inst_17014,throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17184_17374 = state_17154__$1;
(statearr_17184_17374[(2)] = inst_17042);

(statearr_17184_17374[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (39))){
var inst_16945 = (state_17154[(18)]);
var state_17154__$1 = state_17154;
var statearr_17185_17375 = state_17154__$1;
(statearr_17185_17375[(2)] = inst_16945);

(statearr_17185_17375[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (88))){
var inst_17001 = (state_17154[(12)]);
var state_17154__$1 = state_17154;
var statearr_17186_17376 = state_17154__$1;
(statearr_17186_17376[(2)] = inst_17001);

(statearr_17186_17376[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (46))){
var inst_16964 = (state_17154[(19)]);
var inst_16882 = (state_17154[(11)]);
var inst_16963 = (state_17154[(2)]);
var inst_16964__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16882);
var state_17154__$1 = (function (){var statearr_17187 = state_17154;
(statearr_17187[(14)] = inst_16963);

(statearr_17187[(19)] = inst_16964__$1);

return statearr_17187;
})();
if(cljs.core.truth_(inst_16964__$1)){
var statearr_17188_17377 = state_17154__$1;
(statearr_17188_17377[(1)] = (47));

} else {
var statearr_17189_17378 = state_17154__$1;
(statearr_17189_17378[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (4))){
var inst_16843 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17190_17379 = state_17154__$1;
(statearr_17190_17379[(2)] = inst_16843);

(statearr_17190_17379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (77))){
var inst_17102 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17191_17380 = state_17154__$1;
(statearr_17191_17380[(2)] = inst_17102);

(statearr_17191_17380[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (106))){
var inst_17094 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17192_17381 = state_17154__$1;
(statearr_17192_17381[(2)] = inst_17094);

(statearr_17192_17381[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (119))){
var inst_16880 = (state_17154[(20)]);
var inst_17144 = (state_17154[(2)]);
var inst_16869 = inst_16880;
var inst_16870 = inst_17144;
var state_17154__$1 = (function (){var statearr_17193 = state_17154;
(statearr_17193[(15)] = inst_16870);

(statearr_17193[(21)] = inst_16869);

return statearr_17193;
})();
var statearr_17194_17382 = state_17154__$1;
(statearr_17194_17382[(2)] = null);

(statearr_17194_17382[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (95))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17066 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17067 = (inst_17014.cljs$core$IFn$_invoke$arity$5 ? inst_17014.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_17066,null) : inst_17014.call(null,cljs.core.PersistentArrayMap,null,5,inst_17066,null));
var inst_17068 = (inst_17014.cljs$core$IFn$_invoke$arity$4 ? inst_17014.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17067,null) : inst_17014.call(null,cljs.core.PersistentHashSet,null,inst_17067,null));
var inst_17069 = (inst_17068.cljs$core$IFn$_invoke$arity$1 ? inst_17068.cljs$core$IFn$_invoke$arity$1(inst_17013) : inst_17068.call(null,inst_17013));
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_17069)){
var statearr_17195_17383 = state_17154__$1;
(statearr_17195_17383[(1)] = (96));

} else {
var statearr_17196_17384 = state_17154__$1;
(statearr_17196_17384[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (54))){
var inst_16971 = (state_17154[(22)]);
var state_17154__$1 = state_17154;
var statearr_17197_17385 = state_17154__$1;
(statearr_17197_17385[(2)] = inst_16971);

(statearr_17197_17385[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (92))){
var inst_17001 = (state_17154[(12)]);
var state_17154__$1 = state_17154;
var statearr_17198_17386 = state_17154__$1;
(statearr_17198_17386[(2)] = inst_17001);

(statearr_17198_17386[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (104))){
var inst_17001 = (state_17154[(12)]);
var state_17154__$1 = state_17154;
var statearr_17199_17387 = state_17154__$1;
(statearr_17199_17387[(2)] = inst_17001);

(statearr_17199_17387[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (15))){
var inst_16890 = (state_17154[(23)]);
var state_17154__$1 = state_17154;
var statearr_17200_17388 = state_17154__$1;
(statearr_17200_17388[(2)] = inst_16890);

(statearr_17200_17388[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (48))){
var inst_16964 = (state_17154[(19)]);
var state_17154__$1 = state_17154;
var statearr_17201_17389 = state_17154__$1;
(statearr_17201_17389[(2)] = inst_16964);

(statearr_17201_17389[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (50))){
var inst_16971 = (state_17154[(22)]);
var inst_16882 = (state_17154[(11)]);
var inst_16969 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_16970 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16969);
var inst_16971__$1 = inst_16970 === true;
var state_17154__$1 = (function (){var statearr_17202 = state_17154;
(statearr_17202[(22)] = inst_16971__$1);

return statearr_17202;
})();
if(cljs.core.truth_(inst_16971__$1)){
var statearr_17203_17390 = state_17154__$1;
(statearr_17203_17390[(1)] = (53));

} else {
var statearr_17204_17391 = state_17154__$1;
(statearr_17204_17391[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (116))){
var inst_17125 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17205_17392 = state_17154__$1;
(statearr_17205_17392[(2)] = inst_17125);

(statearr_17205_17392[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (75))){
var inst_17014 = (state_17154[(8)]);
var state_17154__$1 = state_17154;
var G__17206_17393 = inst_17014;
var G__17206_17394__$1 = (((G__17206_17393 instanceof cljs.core.Keyword))?G__17206_17393.fqn:null);
switch (G__17206_17394__$1) {
case "long":
var statearr_17207_17396 = state_17154__$1;
(statearr_17207_17396[(1)] = (79));


break;
case "bigint":
var statearr_17208_17397 = state_17154__$1;
(statearr_17208_17397[(1)] = (83));


break;
case "double":
var statearr_17209_17398 = state_17154__$1;
(statearr_17209_17398[(1)] = (87));


break;
case "float":
var statearr_17210_17399 = state_17154__$1;
(statearr_17210_17399[(1)] = (91));


break;
case "bigdec":
var statearr_17211_17400 = state_17154__$1;
(statearr_17211_17400[(1)] = (95));


break;
case "string":
var statearr_17212_17401 = state_17154__$1;
(statearr_17212_17401[(1)] = (99));


break;
case "instant":
var statearr_17213_17402 = state_17154__$1;
(statearr_17213_17402[(1)] = (103));


break;
default:
var statearr_17214_17403 = state_17154__$1;
(statearr_17214_17403[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (99))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17076 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_17077 = (inst_17014.cljs$core$IFn$_invoke$arity$5 ? inst_17014.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_17076,null) : inst_17014.call(null,cljs.core.PersistentArrayMap,null,5,inst_17076,null));
var inst_17078 = (inst_17014.cljs$core$IFn$_invoke$arity$4 ? inst_17014.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17077,null) : inst_17014.call(null,cljs.core.PersistentHashSet,null,inst_17077,null));
var inst_17079 = (inst_17078.cljs$core$IFn$_invoke$arity$1 ? inst_17078.cljs$core$IFn$_invoke$arity$1(inst_17013) : inst_17078.call(null,inst_17013));
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_17079)){
var statearr_17215_17404 = state_17154__$1;
(statearr_17215_17404[(1)] = (100));

} else {
var statearr_17216_17405 = state_17154__$1;
(statearr_17216_17405[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (21))){
var inst_16906 = (state_17154[(24)]);
var state_17154__$1 = state_17154;
var statearr_17217_17406 = state_17154__$1;
(statearr_17217_17406[(2)] = inst_16906);

(statearr_17217_17406[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (31))){
var inst_16922 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17218_17407 = state_17154__$1;
(statearr_17218_17407[(2)] = inst_16922);

(statearr_17218_17407[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (113))){
var inst_17128 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17219_17408 = state_17154__$1;
(statearr_17219_17408[(2)] = inst_17128);

(statearr_17219_17408[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (32))){
var state_17154__$1 = state_17154;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17220_17409 = state_17154__$1;
(statearr_17220_17409[(1)] = (35));

} else {
var statearr_17221_17410 = state_17154__$1;
(statearr_17221_17410[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (40))){
var inst_16958 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_16958)){
var statearr_17222_17411 = state_17154__$1;
(statearr_17222_17411[(1)] = (44));

} else {
var statearr_17223_17412 = state_17154__$1;
(statearr_17223_17412[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (91))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17056 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17057 = (inst_17014.cljs$core$IFn$_invoke$arity$5 ? inst_17014.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_17056,null) : inst_17014.call(null,cljs.core.PersistentArrayMap,null,3,inst_17056,null));
var inst_17058 = (inst_17014.cljs$core$IFn$_invoke$arity$4 ? inst_17014.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17057,null) : inst_17014.call(null,cljs.core.PersistentHashSet,null,inst_17057,null));
var inst_17059 = (inst_17058.cljs$core$IFn$_invoke$arity$1 ? inst_17058.cljs$core$IFn$_invoke$arity$1(inst_17013) : inst_17058.call(null,inst_17013));
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_17059)){
var statearr_17224_17413 = state_17154__$1;
(statearr_17224_17413[(1)] = (92));

} else {
var statearr_17225_17414 = state_17154__$1;
(statearr_17225_17414[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (117))){
var state_17154__$1 = state_17154;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17226_17415 = state_17154__$1;
(statearr_17226_17415[(1)] = (120));

} else {
var statearr_17227_17416 = state_17154__$1;
(statearr_17227_17416[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (108))){
var inst_17113 = (state_17154[(25)]);
var inst_16882 = (state_17154[(11)]);
var inst_17113__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16882);
var state_17154__$1 = (function (){var statearr_17228 = state_17154;
(statearr_17228[(25)] = inst_17113__$1);

return statearr_17228;
})();
if(cljs.core.truth_(inst_17113__$1)){
var statearr_17229_17417 = state_17154__$1;
(statearr_17229_17417[(1)] = (111));

} else {
var statearr_17230_17418 = state_17154__$1;
(statearr_17230_17418[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (56))){
var inst_16975 = (state_17154[(2)]);
var inst_16976 = fluree.db.util.async.throw_err(inst_16975);
var inst_16977 = cljs.core.not(inst_16976);
var state_17154__$1 = state_17154;
var statearr_17231_17419 = state_17154__$1;
(statearr_17231_17419[(2)] = inst_16977);

(statearr_17231_17419[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (33))){
var inst_16905 = (state_17154[(26)]);
var state_17154__$1 = state_17154;
var statearr_17232_17420 = state_17154__$1;
(statearr_17232_17420[(2)] = inst_16905);

(statearr_17232_17420[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (13))){
var inst_16900 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_16900)){
var statearr_17233_17421 = state_17154__$1;
(statearr_17233_17421[(1)] = (17));

} else {
var statearr_17234_17422 = state_17154__$1;
(statearr_17234_17422[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (22))){
var inst_16931 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_16931)){
var statearr_17235_17423 = state_17154__$1;
(statearr_17235_17423[(1)] = (32));

} else {
var statearr_17236_17424 = state_17154__$1;
(statearr_17236_17424[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (90))){
var inst_17054 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17237_17425 = state_17154__$1;
(statearr_17237_17425[(2)] = inst_17054);

(statearr_17237_17425[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (109))){
var inst_17111 = (state_17154[(27)]);
var state_17154__$1 = state_17154;
var statearr_17238_17426 = state_17154__$1;
(statearr_17238_17426[(2)] = inst_17111);

(statearr_17238_17426[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (36))){
var inst_16905 = (state_17154[(26)]);
var state_17154__$1 = state_17154;
var statearr_17239_17427 = state_17154__$1;
(statearr_17239_17427[(2)] = inst_16905);

(statearr_17239_17427[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (41))){
var inst_16882 = (state_17154[(11)]);
var inst_16950 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_16951 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16950);
var inst_16952 = inst_16951 === true;
var state_17154__$1 = state_17154;
var statearr_17240_17428 = state_17154__$1;
(statearr_17240_17428[(2)] = inst_16952);

(statearr_17240_17428[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (118))){
var inst_17109 = (state_17154[(7)]);
var state_17154__$1 = state_17154;
var statearr_17241_17429 = state_17154__$1;
(statearr_17241_17429[(2)] = inst_17109);

(statearr_17241_17429[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (89))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17052 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17013,inst_17014,throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17242_17430 = state_17154__$1;
(statearr_17242_17430[(2)] = inst_17052);

(statearr_17242_17430[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (100))){
var inst_17001 = (state_17154[(12)]);
var state_17154__$1 = state_17154;
var statearr_17243_17431 = state_17154__$1;
(statearr_17243_17431[(2)] = inst_17001);

(statearr_17243_17431[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (122))){
var inst_17141 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17244_17432 = state_17154__$1;
(statearr_17244_17432[(2)] = inst_17141);

(statearr_17244_17432[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (43))){
var inst_16955 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17245_17433 = state_17154__$1;
(statearr_17245_17433[(2)] = inst_16955);

(statearr_17245_17433[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (61))){
var inst_16963 = (state_17154[(14)]);
var state_17154__$1 = state_17154;
var statearr_17246_17434 = state_17154__$1;
(statearr_17246_17434[(2)] = inst_16963);

(statearr_17246_17434[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (29))){
var inst_16882 = (state_17154[(11)]);
var inst_16917 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_16918 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16917);
var inst_16919 = inst_16918 === true;
var state_17154__$1 = state_17154;
var statearr_17247_17435 = state_17154__$1;
(statearr_17247_17435[(2)] = inst_16919);

(statearr_17247_17435[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (44))){
var inst_16944 = (state_17154[(28)]);
var inst_16960 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16944,"a component","a non-component",throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17248_17436 = state_17154__$1;
(statearr_17248_17436[(2)] = inst_16960);

(statearr_17248_17436[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (93))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17062 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17013,inst_17014,throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17249_17437 = state_17154__$1;
(statearr_17249_17437[(2)] = inst_17062);

(statearr_17249_17437[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (6))){
var inst_16881 = (state_17154[(16)]);
var inst_16869 = (state_17154[(21)]);
var inst_16878 = cljs.core.seq(inst_16869);
var inst_16879 = cljs.core.first(inst_16878);
var inst_16880 = cljs.core.next(inst_16878);
var inst_16881__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16879,(0),null);
var inst_16882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16879,(1),null);
var inst_16883 = cljs.core.not(inst_16881__$1);
var state_17154__$1 = (function (){var statearr_17250 = state_17154;
(statearr_17250[(16)] = inst_16881__$1);

(statearr_17250[(20)] = inst_16880);

(statearr_17250[(11)] = inst_16882);

return statearr_17250;
})();
if(inst_16883){
var statearr_17251_17438 = state_17154__$1;
(statearr_17251_17438[(1)] = (8));

} else {
var statearr_17252_17439 = state_17154__$1;
(statearr_17252_17439[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (111))){
var inst_17117 = (state_17154[(29)]);
var inst_16882 = (state_17154[(11)]);
var inst_17115 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_17116 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_17115);
var inst_17117__$1 = inst_17116 === true;
var state_17154__$1 = (function (){var statearr_17253 = state_17154;
(statearr_17253[(29)] = inst_17117__$1);

return statearr_17253;
})();
if(cljs.core.truth_(inst_17117__$1)){
var statearr_17254_17440 = state_17154__$1;
(statearr_17254_17440[(1)] = (114));

} else {
var statearr_17255_17441 = state_17154__$1;
(statearr_17255_17441[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (28))){
var inst_16925 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17256_17442 = state_17154__$1;
(statearr_17256_17442[(2)] = inst_16925);

(statearr_17256_17442[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (64))){
var inst_17002 = (state_17154[(10)]);
var state_17154__$1 = state_17154;
var statearr_17257_17443 = state_17154__$1;
(statearr_17257_17443[(2)] = inst_17002);

(statearr_17257_17443[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (103))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17086 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17087 = (inst_17014.cljs$core$IFn$_invoke$arity$5 ? inst_17014.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_17086,null) : inst_17014.call(null,cljs.core.PersistentArrayMap,null,2,inst_17086,null));
var inst_17088 = (inst_17014.cljs$core$IFn$_invoke$arity$4 ? inst_17014.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17087,null) : inst_17014.call(null,cljs.core.PersistentHashSet,null,inst_17087,null));
var inst_17089 = (inst_17088.cljs$core$IFn$_invoke$arity$1 ? inst_17088.cljs$core$IFn$_invoke$arity$1(inst_17013) : inst_17088.call(null,inst_17013));
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_17089)){
var statearr_17258_17444 = state_17154__$1;
(statearr_17258_17444[(1)] = (104));

} else {
var statearr_17259_17445 = state_17154__$1;
(statearr_17259_17445[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (51))){
var inst_16967 = (state_17154[(30)]);
var state_17154__$1 = state_17154;
var statearr_17260_17446 = state_17154__$1;
(statearr_17260_17446[(2)] = inst_16967);

(statearr_17260_17446[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (25))){
var inst_16928 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17261_17447 = state_17154__$1;
(statearr_17261_17447[(2)] = inst_16928);

(statearr_17261_17447[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (34))){
var inst_16945 = (state_17154[(18)]);
var inst_16882 = (state_17154[(11)]);
var inst_16944 = (state_17154[(2)]);
var inst_16945__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16882);
var state_17154__$1 = (function (){var statearr_17262 = state_17154;
(statearr_17262[(28)] = inst_16944);

(statearr_17262[(18)] = inst_16945__$1);

return statearr_17262;
})();
if(cljs.core.truth_(inst_16945__$1)){
var statearr_17263_17448 = state_17154__$1;
(statearr_17263_17448[(1)] = (38));

} else {
var statearr_17264_17449 = state_17154__$1;
(statearr_17264_17449[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (17))){
var inst_16870 = (state_17154[(15)]);
var inst_16902 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16870,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17265_17450 = state_17154__$1;
(statearr_17265_17450[(2)] = inst_16902);

(statearr_17265_17450[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (3))){
var inst_17152 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17154__$1,inst_17152);
} else {
if((state_val_17155 === (12))){
var inst_16886 = (state_17154[(31)]);
var state_17154__$1 = state_17154;
var statearr_17266_17451 = state_17154__$1;
(statearr_17266_17451[(2)] = inst_16886);

(statearr_17266_17451[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (2))){
var _ = (function (){var statearr_17267 = state_17154;
(statearr_17267[(4)] = cljs.core.cons((5),(state_17154[(4)])));

return statearr_17267;
})();
var inst_16862 = pred_changes;
var inst_16863 = cljs.core.seq(inst_16862);
var inst_16864 = cljs.core.first(inst_16863);
var inst_16865 = cljs.core.next(inst_16863);
var inst_16866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16864,(0),null);
var inst_16867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16864,(1),null);
var inst_16868 = db;
var inst_16869 = inst_16862;
var inst_16870 = inst_16868;
var state_17154__$1 = (function (){var statearr_17268 = state_17154;
(statearr_17268[(32)] = inst_16865);

(statearr_17268[(33)] = inst_16866);

(statearr_17268[(15)] = inst_16870);

(statearr_17268[(34)] = inst_16867);

(statearr_17268[(21)] = inst_16869);

return statearr_17268;
})();
var statearr_17269_17452 = state_17154__$1;
(statearr_17269_17452[(2)] = null);

(statearr_17269_17452[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (66))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_16882 = (state_17154[(11)]);
var inst_17011 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_17012 = cljs.core.__destructure_map(inst_17011);
var inst_17013__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17012,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_17014__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17012,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_17015 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17014__$1,inst_17013__$1);
var state_17154__$1 = (function (){var statearr_17270 = state_17154;
(statearr_17270[(8)] = inst_17014__$1);

(statearr_17270[(9)] = inst_17013__$1);

return statearr_17270;
})();
if(inst_17015){
var statearr_17271_17453 = state_17154__$1;
(statearr_17271_17453[(1)] = (69));

} else {
var statearr_17272_17454 = state_17154__$1;
(statearr_17272_17454[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (107))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17096 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17013,inst_17014,throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17273_17455 = state_17154__$1;
(statearr_17273_17455[(2)] = inst_17096);

(statearr_17273_17455[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (23))){
var inst_16911 = (state_17154[(17)]);
var inst_16882 = (state_17154[(11)]);
var inst_16910 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_16911__$1 = inst_16910 === true;
var state_17154__$1 = (function (){var statearr_17274 = state_17154;
(statearr_17274[(17)] = inst_16911__$1);

return statearr_17274;
})();
if(cljs.core.truth_(inst_16911__$1)){
var statearr_17275_17456 = state_17154__$1;
(statearr_17275_17456[(1)] = (26));

} else {
var statearr_17276_17457 = state_17154__$1;
(statearr_17276_17457[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (47))){
var inst_16967 = (state_17154[(30)]);
var inst_16882 = (state_17154[(11)]);
var inst_16966 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_16967__$1 = cljs.core.not(inst_16966);
var state_17154__$1 = (function (){var statearr_17277 = state_17154;
(statearr_17277[(30)] = inst_16967__$1);

return statearr_17277;
})();
if(inst_16967__$1){
var statearr_17278_17458 = state_17154__$1;
(statearr_17278_17458[(1)] = (50));

} else {
var statearr_17279_17459 = state_17154__$1;
(statearr_17279_17459[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (35))){
var inst_16934 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16935 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16936 = cljs.core.PersistentHashMap.fromArrays(inst_16934,inst_16935);
var inst_16937 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_16936);
var inst_16938 = (function(){throw inst_16937})();
var state_17154__$1 = state_17154;
var statearr_17280_17460 = state_17154__$1;
(statearr_17280_17460[(2)] = inst_16938);

(statearr_17280_17460[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (82))){
var inst_17034 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17281_17461 = state_17154__$1;
(statearr_17281_17461[(2)] = inst_17034);

(statearr_17281_17461[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (76))){
var state_17154__$1 = state_17154;
var statearr_17282_17462 = state_17154__$1;
(statearr_17282_17462[(2)] = null);

(statearr_17282_17462[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (97))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17072 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17013,inst_17014,throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17283_17463 = state_17154__$1;
(statearr_17283_17463[(2)] = inst_17072);

(statearr_17283_17463[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (19))){
var inst_16906 = (state_17154[(24)]);
var inst_16882 = (state_17154[(11)]);
var inst_16905 = (state_17154[(2)]);
var inst_16906__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16882);
var state_17154__$1 = (function (){var statearr_17284 = state_17154;
(statearr_17284[(24)] = inst_16906__$1);

(statearr_17284[(26)] = inst_16905);

return statearr_17284;
})();
if(cljs.core.truth_(inst_16906__$1)){
var statearr_17285_17464 = state_17154__$1;
(statearr_17285_17464[(1)] = (20));

} else {
var statearr_17286_17465 = state_17154__$1;
(statearr_17286_17465[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (57))){
var state_17154__$1 = state_17154;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17287_17466 = state_17154__$1;
(statearr_17287_17466[(1)] = (60));

} else {
var statearr_17288_17467 = state_17154__$1;
(statearr_17288_17467[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (68))){
var inst_17111 = (state_17154[(27)]);
var inst_16882 = (state_17154[(11)]);
var inst_17109 = (state_17154[(2)]);
var inst_17110 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_17111__$1 = inst_17110 === true;
var state_17154__$1 = (function (){var statearr_17289 = state_17154;
(statearr_17289[(27)] = inst_17111__$1);

(statearr_17289[(7)] = inst_17109);

return statearr_17289;
})();
if(cljs.core.truth_(inst_17111__$1)){
var statearr_17290_17468 = state_17154__$1;
(statearr_17290_17468[(1)] = (108));

} else {
var statearr_17291_17469 = state_17154__$1;
(statearr_17291_17469[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (11))){
var inst_16890 = (state_17154[(23)]);
var inst_16882 = (state_17154[(11)]);
var inst_16888 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_16889 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16888);
var inst_16890__$1 = inst_16889 === false;
var state_17154__$1 = (function (){var statearr_17292 = state_17154;
(statearr_17292[(23)] = inst_16890__$1);

return statearr_17292;
})();
if(cljs.core.truth_(inst_16890__$1)){
var statearr_17293_17470 = state_17154__$1;
(statearr_17293_17470[(1)] = (14));

} else {
var statearr_17294_17471 = state_17154__$1;
(statearr_17294_17471[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (115))){
var inst_17117 = (state_17154[(29)]);
var state_17154__$1 = state_17154;
var statearr_17296_17472 = state_17154__$1;
(statearr_17296_17472[(2)] = inst_17117);

(statearr_17296_17472[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (9))){
var inst_16886 = (state_17154[(31)]);
var inst_16882 = (state_17154[(11)]);
var inst_16886__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16882);
var state_17154__$1 = (function (){var statearr_17297 = state_17154;
(statearr_17297[(31)] = inst_16886__$1);

return statearr_17297;
})();
if(cljs.core.truth_(inst_16886__$1)){
var statearr_17298_17473 = state_17154__$1;
(statearr_17298_17473[(1)] = (11));

} else {
var statearr_17299_17474 = state_17154__$1;
(statearr_17299_17474[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (5))){
var _ = (function (){var statearr_17300 = state_17154;
(statearr_17300[(4)] = cljs.core.rest((state_17154[(4)])));

return statearr_17300;
})();
var state_17154__$1 = state_17154;
var ex17295 = (state_17154__$1[(2)]);
var statearr_17301_17475 = state_17154__$1;
(statearr_17301_17475[(5)] = ex17295);


if((ex17295 instanceof Error)){
var statearr_17302_17476 = state_17154__$1;
(statearr_17302_17476[(1)] = (4));

(statearr_17302_17476[(5)] = null);

} else {
throw ex17295;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (112))){
var inst_17113 = (state_17154[(25)]);
var state_17154__$1 = state_17154;
var statearr_17303_17477 = state_17154__$1;
(statearr_17303_17477[(2)] = inst_17113);

(statearr_17303_17477[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (83))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17036 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17037 = (inst_17014.cljs$core$IFn$_invoke$arity$5 ? inst_17014.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_17036,null) : inst_17014.call(null,cljs.core.PersistentArrayMap,null,3,inst_17036,null));
var inst_17038 = (inst_17014.cljs$core$IFn$_invoke$arity$4 ? inst_17014.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17037,null) : inst_17014.call(null,cljs.core.PersistentHashSet,null,inst_17037,null));
var inst_17039 = (inst_17038.cljs$core$IFn$_invoke$arity$1 ? inst_17038.cljs$core$IFn$_invoke$arity$1(inst_17013) : inst_17038.call(null,inst_17013));
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_17039)){
var statearr_17304_17478 = state_17154__$1;
(statearr_17304_17478[(1)] = (84));

} else {
var statearr_17305_17479 = state_17154__$1;
(statearr_17305_17479[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (14))){
var inst_16882 = (state_17154[(11)]);
var inst_16892 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_16893 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16892);
var inst_16894 = inst_16893 === true;
var state_17154__$1 = state_17154;
var statearr_17306_17480 = state_17154__$1;
(statearr_17306_17480[(2)] = inst_16894);

(statearr_17306_17480[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (45))){
var inst_16944 = (state_17154[(28)]);
var state_17154__$1 = state_17154;
var statearr_17307_17481 = state_17154__$1;
(statearr_17307_17481[(2)] = inst_16944);

(statearr_17307_17481[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (53))){
var inst_16870 = (state_17154[(15)]);
var inst_16881 = (state_17154[(16)]);
var inst_16973 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_16870,inst_16881);
var state_17154__$1 = state_17154;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17154__$1,(56),inst_16973);
} else {
if((state_val_17155 === (78))){
var inst_17099 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17308_17482 = state_17154__$1;
(statearr_17308_17482[(2)] = inst_17099);

(statearr_17308_17482[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (26))){
var inst_16915 = (state_17154[(35)]);
var inst_16882 = (state_17154[(11)]);
var inst_16913 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_16914 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16913);
var inst_16915__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16914);
var state_17154__$1 = (function (){var statearr_17309 = state_17154;
(statearr_17309[(35)] = inst_16915__$1);

return statearr_17309;
})();
if(inst_16915__$1){
var statearr_17310_17483 = state_17154__$1;
(statearr_17310_17483[(1)] = (29));

} else {
var statearr_17311_17484 = state_17154__$1;
(statearr_17311_17484[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (16))){
var inst_16897 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17312_17485 = state_17154__$1;
(statearr_17312_17485[(2)] = inst_16897);

(statearr_17312_17485[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (81))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17032 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17013,inst_17014,throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17313_17486 = state_17154__$1;
(statearr_17313_17486[(2)] = inst_17032);

(statearr_17313_17486[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (120))){
var inst_17134 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17135 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_17136 = cljs.core.PersistentHashMap.fromArrays(inst_17134,inst_17135);
var inst_17137 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_17136);
var inst_17138 = (function(){throw inst_17137})();
var state_17154__$1 = state_17154;
var statearr_17314_17487 = state_17154__$1;
(statearr_17314_17487[(2)] = inst_17138);

(statearr_17314_17487[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (79))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17026 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17027 = (inst_17014.cljs$core$IFn$_invoke$arity$5 ? inst_17014.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_17026,null) : inst_17014.call(null,cljs.core.PersistentArrayMap,null,2,inst_17026,null));
var inst_17028 = (inst_17014.cljs$core$IFn$_invoke$arity$4 ? inst_17014.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17027,null) : inst_17014.call(null,cljs.core.PersistentHashSet,null,inst_17027,null));
var inst_17029 = (inst_17028.cljs$core$IFn$_invoke$arity$1 ? inst_17028.cljs$core$IFn$_invoke$arity$1(inst_17013) : inst_17028.call(null,inst_17013));
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_17029)){
var statearr_17315_17488 = state_17154__$1;
(statearr_17315_17488[(1)] = (80));

} else {
var statearr_17316_17489 = state_17154__$1;
(statearr_17316_17489[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (38))){
var inst_16948 = (state_17154[(36)]);
var inst_16882 = (state_17154[(11)]);
var inst_16947 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_16948__$1 = cljs.core.not(inst_16947);
var state_17154__$1 = (function (){var statearr_17317 = state_17154;
(statearr_17317[(36)] = inst_16948__$1);

return statearr_17317;
})();
if(inst_16948__$1){
var statearr_17318_17490 = state_17154__$1;
(statearr_17318_17490[(1)] = (41));

} else {
var statearr_17319_17491 = state_17154__$1;
(statearr_17319_17491[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (98))){
var inst_17074 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17320_17492 = state_17154__$1;
(statearr_17320_17492[(2)] = inst_17074);

(statearr_17320_17492[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (87))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17046 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17047 = (inst_17014.cljs$core$IFn$_invoke$arity$5 ? inst_17014.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_17046,null) : inst_17014.call(null,cljs.core.PersistentArrayMap,null,3,inst_17046,null));
var inst_17048 = (inst_17014.cljs$core$IFn$_invoke$arity$4 ? inst_17014.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_17047,null) : inst_17014.call(null,cljs.core.PersistentHashSet,null,inst_17047,null));
var inst_17049 = (inst_17048.cljs$core$IFn$_invoke$arity$1 ? inst_17048.cljs$core$IFn$_invoke$arity$1(inst_17013) : inst_17048.call(null,inst_17013));
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_17049)){
var statearr_17321_17493 = state_17154__$1;
(statearr_17321_17493[(1)] = (88));

} else {
var statearr_17322_17494 = state_17154__$1;
(statearr_17322_17494[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (30))){
var inst_16915 = (state_17154[(35)]);
var state_17154__$1 = state_17154;
var statearr_17323_17495 = state_17154__$1;
(statearr_17323_17495[(2)] = inst_16915);

(statearr_17323_17495[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (73))){
var state_17154__$1 = state_17154;
var statearr_17324_17496 = state_17154__$1;
(statearr_17324_17496[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (96))){
var inst_17001 = (state_17154[(12)]);
var state_17154__$1 = state_17154;
var statearr_17326_17497 = state_17154__$1;
(statearr_17326_17497[(2)] = inst_17001);

(statearr_17326_17497[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (10))){
var inst_17147 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17327_17498 = state_17154__$1;
(statearr_17327_17498[(2)] = inst_17147);

(statearr_17327_17498[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (18))){
var inst_16870 = (state_17154[(15)]);
var state_17154__$1 = state_17154;
var statearr_17328_17499 = state_17154__$1;
(statearr_17328_17499[(2)] = inst_16870);

(statearr_17328_17499[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (105))){
var inst_17014 = (state_17154[(8)]);
var inst_17013 = (state_17154[(9)]);
var inst_17092 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_17013,inst_17014,throw_QMARK_);
var state_17154__$1 = state_17154;
var statearr_17329_17500 = state_17154__$1;
(statearr_17329_17500[(2)] = inst_17092);

(statearr_17329_17500[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (52))){
var inst_16983 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17330_17501 = state_17154__$1;
(statearr_17330_17501[(2)] = inst_16983);

(statearr_17330_17501[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (114))){
var inst_16882 = (state_17154[(11)]);
var inst_17119 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_17120 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_17119);
var inst_17121 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_17120);
var inst_17122 = (!(inst_17121));
var state_17154__$1 = state_17154;
var statearr_17331_17502 = state_17154__$1;
(statearr_17331_17502[(2)] = inst_17122);

(statearr_17331_17502[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (67))){
var inst_17001 = (state_17154[(12)]);
var state_17154__$1 = state_17154;
var statearr_17332_17503 = state_17154__$1;
(statearr_17332_17503[(2)] = inst_17001);

(statearr_17332_17503[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (71))){
var inst_17106 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17333_17504 = state_17154__$1;
(statearr_17333_17504[(2)] = inst_17106);

(statearr_17333_17504[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (42))){
var inst_16948 = (state_17154[(36)]);
var state_17154__$1 = state_17154;
var statearr_17334_17505 = state_17154__$1;
(statearr_17334_17505[(2)] = inst_16948);

(statearr_17334_17505[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (80))){
var inst_17001 = (state_17154[(12)]);
var state_17154__$1 = state_17154;
var statearr_17335_17506 = state_17154__$1;
(statearr_17335_17506[(2)] = inst_17001);

(statearr_17335_17506[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (37))){
var inst_16941 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17336_17507 = state_17154__$1;
(statearr_17336_17507[(2)] = inst_16941);

(statearr_17336_17507[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (63))){
var inst_16882 = (state_17154[(11)]);
var inst_17004 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16882);
var inst_17005 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_17004);
var state_17154__$1 = state_17154;
var statearr_17337_17508 = state_17154__$1;
(statearr_17337_17508[(2)] = inst_17005);

(statearr_17337_17508[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (94))){
var inst_17064 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
var statearr_17338_17509 = state_17154__$1;
(statearr_17338_17509[(2)] = inst_17064);

(statearr_17338_17509[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (8))){
var inst_16870 = (state_17154[(15)]);
var state_17154__$1 = state_17154;
var statearr_17339_17510 = state_17154__$1;
(statearr_17339_17510[(2)] = inst_16870);

(statearr_17339_17510[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (49))){
var inst_16986 = (state_17154[(2)]);
var state_17154__$1 = state_17154;
if(cljs.core.truth_(inst_16986)){
var statearr_17340_17511 = state_17154__$1;
(statearr_17340_17511[(1)] = (57));

} else {
var statearr_17341_17512 = state_17154__$1;
(statearr_17341_17512[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17155 === (84))){
var inst_17001 = (state_17154[(12)]);
var state_17154__$1 = state_17154;
var statearr_17342_17513 = state_17154__$1;
(statearr_17342_17513[(2)] = inst_17001);

(statearr_17342_17513[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2684__auto__ = null;
var fluree$db$query$schema$state_machine__2684__auto____0 = (function (){
var statearr_17343 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17343[(0)] = fluree$db$query$schema$state_machine__2684__auto__);

(statearr_17343[(1)] = (1));

return statearr_17343;
});
var fluree$db$query$schema$state_machine__2684__auto____1 = (function (state_17154){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17154);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17344){var ex__2687__auto__ = e17344;
var statearr_17345_17514 = state_17154;
(statearr_17345_17514[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17154[(4)]))){
var statearr_17346_17515 = state_17154;
(statearr_17346_17515[(1)] = cljs.core.first((state_17154[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17516 = state_17154;
state_17154 = G__17516;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2684__auto__ = function(state_17154){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2684__auto____1.call(this,state_17154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2684__auto____0;
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2684__auto____1;
return fluree$db$query$schema$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17347 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17347[(6)] = c__2706__auto__);

return statearr_17347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__17518 = arguments.length;
switch (G__17518) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17542){
var state_val_17543 = (state_17542[(1)]);
if((state_val_17543 === (7))){
var state_17542__$1 = state_17542;
var statearr_17544_17564 = state_17542__$1;
(statearr_17544_17564[(2)] = db);

(statearr_17544_17564[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17543 === (1))){
var state_17542__$1 = state_17542;
var statearr_17545_17565 = state_17542__$1;
(statearr_17545_17565[(2)] = null);

(statearr_17545_17565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17543 === (4))){
var inst_17519 = (state_17542[(2)]);
var state_17542__$1 = state_17542;
var statearr_17546_17566 = state_17542__$1;
(statearr_17546_17566[(2)] = inst_17519);

(statearr_17546_17566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17543 === (6))){
var inst_17528 = (state_17542[(7)]);
var inst_17527 = (state_17542[(2)]);
var inst_17528__$1 = fluree.db.util.async.throw_err(inst_17527);
var inst_17529 = cljs.core.empty_QMARK_(inst_17528__$1);
var state_17542__$1 = (function (){var statearr_17547 = state_17542;
(statearr_17547[(7)] = inst_17528__$1);

return statearr_17547;
})();
if(inst_17529){
var statearr_17548_17567 = state_17542__$1;
(statearr_17548_17567[(1)] = (7));

} else {
var statearr_17549_17568 = state_17542__$1;
(statearr_17549_17568[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17543 === (3))){
var inst_17540 = (state_17542[(2)]);
var state_17542__$1 = state_17542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17542__$1,inst_17540);
} else {
if((state_val_17543 === (2))){
var _ = (function (){var statearr_17551 = state_17542;
(statearr_17551[(4)] = cljs.core.cons((5),(state_17542[(4)])));

return statearr_17551;
})();
var inst_17525 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_17542__$1 = state_17542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17542__$1,(6),inst_17525);
} else {
if((state_val_17543 === (9))){
var inst_17537 = (state_17542[(2)]);
var _ = (function (){var statearr_17552 = state_17542;
(statearr_17552[(4)] = cljs.core.rest((state_17542[(4)])));

return statearr_17552;
})();
var state_17542__$1 = state_17542;
var statearr_17553_17569 = state_17542__$1;
(statearr_17553_17569[(2)] = inst_17537);

(statearr_17553_17569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17543 === (5))){
var _ = (function (){var statearr_17554 = state_17542;
(statearr_17554[(4)] = cljs.core.rest((state_17542[(4)])));

return statearr_17554;
})();
var state_17542__$1 = state_17542;
var ex17550 = (state_17542__$1[(2)]);
var statearr_17555_17570 = state_17542__$1;
(statearr_17555_17570[(5)] = ex17550);


if((ex17550 instanceof Error)){
var statearr_17556_17571 = state_17542__$1;
(statearr_17556_17571[(1)] = (4));

(statearr_17556_17571[(5)] = null);

} else {
throw ex17550;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17543 === (10))){
var inst_17534 = (state_17542[(2)]);
var inst_17535 = fluree.db.util.async.throw_err(inst_17534);
var state_17542__$1 = state_17542;
var statearr_17557_17572 = state_17542__$1;
(statearr_17557_17572[(2)] = inst_17535);

(statearr_17557_17572[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17543 === (8))){
var inst_17528 = (state_17542[(7)]);
var inst_17532 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_17528,db,true);
var state_17542__$1 = state_17542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17542__$1,(10),inst_17532);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2684__auto__ = null;
var fluree$db$query$schema$state_machine__2684__auto____0 = (function (){
var statearr_17558 = [null,null,null,null,null,null,null,null];
(statearr_17558[(0)] = fluree$db$query$schema$state_machine__2684__auto__);

(statearr_17558[(1)] = (1));

return statearr_17558;
});
var fluree$db$query$schema$state_machine__2684__auto____1 = (function (state_17542){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17542);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17559){var ex__2687__auto__ = e17559;
var statearr_17560_17573 = state_17542;
(statearr_17560_17573[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17542[(4)]))){
var statearr_17561_17574 = state_17542;
(statearr_17561_17574[(1)] = cljs.core.first((state_17542[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17575 = state_17542;
state_17542 = G__17575;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2684__auto__ = function(state_17542){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2684__auto____1.call(this,state_17542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2684__auto____0;
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2684__auto____1;
return fluree$db$query$schema$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17562 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17562[(6)] = c__2706__auto__);

return statearr_17562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__17577 = arguments.length;
switch (G__17577) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__17579 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17579,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17579,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17579,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__17582_SHARP_,p2__17583_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17582_SHARP_,p2__17583_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__17584_SHARP_){
var f = p1__17584_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17650){
var state_val_17651 = (state_17650[(1)]);
if((state_val_17651 === (1))){
var state_17650__$1 = state_17650;
var statearr_17652_17670 = state_17650__$1;
(statearr_17652_17670[(2)] = null);

(statearr_17652_17670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17651 === (2))){
var _ = (function (){var statearr_17653 = state_17650;
(statearr_17653[(4)] = cljs.core.cons((5),(state_17650[(4)])));

return statearr_17653;
})();
var inst_17602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17603 = fluree.db.flake.max_subject_id((1));
var inst_17604 = [inst_17603];
var inst_17605 = (new cljs.core.PersistentVector(null,1,(5),inst_17602,inst_17604,null));
var inst_17606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17607 = [(0)];
var inst_17608 = (new cljs.core.PersistentVector(null,1,(5),inst_17606,inst_17607,null));
var inst_17609 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_17605,cljs.core._LT__EQ_,inst_17608);
var state_17650__$1 = state_17650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17650__$1,(6),inst_17609);
} else {
if((state_val_17651 === (3))){
var inst_17648 = (state_17650[(2)]);
var state_17650__$1 = state_17650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17650__$1,inst_17648);
} else {
if((state_val_17651 === (4))){
var inst_17590 = (state_17650[(2)]);
var state_17650__$1 = state_17650;
var statearr_17655_17671 = state_17650__$1;
(statearr_17655_17671[(2)] = inst_17590);

(statearr_17655_17671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17651 === (5))){
var _ = (function (){var statearr_17656 = state_17650;
(statearr_17656[(4)] = cljs.core.rest((state_17650[(4)])));

return statearr_17656;
})();
var state_17650__$1 = state_17650;
var ex17654 = (state_17650__$1[(2)]);
var statearr_17657_17672 = state_17650__$1;
(statearr_17657_17672[(5)] = ex17654);


if((ex17654 instanceof Error)){
var statearr_17658_17673 = state_17650__$1;
(statearr_17658_17673[(1)] = (4));

(statearr_17658_17673[(5)] = null);

} else {
throw ex17654;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17651 === (6))){
var inst_17611 = (state_17650[(2)]);
var inst_17612 = fluree.db.util.async.throw_err(inst_17611);
var inst_17613 = (function (){var schema_flakes = inst_17612;
return (function (p1__17585_SHARP_){
return (p1__17585_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_17614 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17613,inst_17612);
var inst_17615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17614,(0),null);
var inst_17616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17614,(1),null);
var inst_17617 = (function (){var schema_flakes = inst_17612;
var vec__17596 = inst_17614;
var collection_flakes = inst_17615;
var predicate_flakes = inst_17616;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__17588_SHARP_,p2__17587_SHARP_){
var f = p2__17587_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17588_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_17618 = [(-1),"_tx"];
var inst_17619 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17620 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17621 = cljs.core.PersistentHashMap.fromArrays(inst_17619,inst_17620);
var inst_17622 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17623 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17624 = cljs.core.PersistentHashMap.fromArrays(inst_17622,inst_17623);
var inst_17625 = [inst_17621,inst_17624];
var inst_17626 = cljs.core.PersistentHashMap.fromArrays(inst_17618,inst_17625);
var inst_17627 = (function (){var schema_flakes = inst_17612;
var vec__17596 = inst_17614;
var collection_flakes = inst_17615;
var predicate_flakes = inst_17616;
return (function (p1__17586_SHARP_){
return p1__17586_SHARP_.s;
});
})();
var inst_17628 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17627,inst_17615);
var inst_17629 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17617,inst_17626,inst_17628);
var inst_17631 = (function (){var schema_flakes = inst_17612;
var vec__17596 = inst_17614;
var collection_flakes = inst_17615;
var predicate_flakes = inst_17616;
var coll = inst_17629;
return (function (p__17630,pred_flakes){
var vec__17659 = p__17630;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17659,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17659,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__17662 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__17662.cljs$core$IFn$_invoke$arity$1 ? fexpr__17662.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__17662.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_17632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17633 = cljs.core.PersistentHashMap.EMPTY;
var inst_17634 = cljs.core.PersistentHashSet.EMPTY;
var inst_17635 = [inst_17633,inst_17634];
var inst_17636 = (new cljs.core.PersistentVector(null,2,(5),inst_17632,inst_17635,null));
var inst_17637 = (function (){var schema_flakes = inst_17612;
var vec__17596 = inst_17614;
var collection_flakes = inst_17615;
var predicate_flakes = inst_17616;
var coll = inst_17629;
return (function (p1__17589_SHARP_){
return p1__17589_SHARP_.s;
});
})();
var inst_17638 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17637,inst_17616);
var inst_17639 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17631,inst_17636,inst_17638);
var inst_17640 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17639,(0),null);
var inst_17641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17639,(1),null);
var inst_17642 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17643 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17644 = [inst_17643,inst_17629,inst_17640,inst_17641];
var inst_17645 = cljs.core.PersistentHashMap.fromArrays(inst_17642,inst_17644);
var _ = (function (){var statearr_17663 = state_17650;
(statearr_17663[(4)] = cljs.core.rest((state_17650[(4)])));

return statearr_17663;
})();
var state_17650__$1 = state_17650;
var statearr_17664_17674 = state_17650__$1;
(statearr_17664_17674[(2)] = inst_17645);

(statearr_17664_17674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0 = (function (){
var statearr_17665 = [null,null,null,null,null,null,null];
(statearr_17665[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2684__auto__);

(statearr_17665[(1)] = (1));

return statearr_17665;
});
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1 = (function (state_17650){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17650);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17666){var ex__2687__auto__ = e17666;
var statearr_17667_17675 = state_17650;
(statearr_17667_17675[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17650[(4)]))){
var statearr_17668_17676 = state_17650;
(statearr_17668_17676[(1)] = cljs.core.first((state_17650[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17677 = state_17650;
state_17650 = G__17677;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__ = function(state_17650){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1.call(this,state_17650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17669 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17669[(6)] = c__2706__auto__);

return statearr_17669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17719){
var state_val_17720 = (state_17719[(1)]);
if((state_val_17720 === (7))){
var inst_17702 = (state_17719[(2)]);
var inst_17703 = fluree.db.query.schema.flake__GT_pred_map(inst_17702);
var inst_17704 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17705 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17703,(114));
var inst_17706 = cljs.core.boolean$(inst_17705);
var inst_17707 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17703,(110));
var inst_17708 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17703,(117));
var inst_17709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_17708);
var inst_17710 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17703,(111));
var inst_17711 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17703,(115));
var inst_17712 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17703,(112));
var inst_17713 = [inst_17706,inst_17707,inst_17709,inst_17710,inst_17711,inst_17712];
var inst_17714 = cljs.core.PersistentHashMap.fromArrays(inst_17704,inst_17713);
var _ = (function (){var statearr_17721 = state_17719;
(statearr_17721[(4)] = cljs.core.rest((state_17719[(4)])));

return statearr_17721;
})();
var state_17719__$1 = state_17719;
var statearr_17722_17745 = state_17719__$1;
(statearr_17722_17745[(2)] = inst_17714);

(statearr_17722_17745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (1))){
var state_17719__$1 = state_17719;
var statearr_17723_17746 = state_17719__$1;
(statearr_17723_17746[(2)] = null);

(statearr_17723_17746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (4))){
var inst_17678 = (state_17719[(2)]);
var state_17719__$1 = state_17719;
var statearr_17724_17747 = state_17719__$1;
(statearr_17724_17747[(2)] = inst_17678);

(statearr_17724_17747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (6))){
var _ = (function (){var statearr_17725 = state_17719;
(statearr_17725[(4)] = cljs.core.cons((9),(state_17719[(4)])));

return statearr_17725;
})();
var inst_17690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17692 = ["_setting/id","root"];
var inst_17693 = (new cljs.core.PersistentVector(null,2,(5),inst_17691,inst_17692,null));
var inst_17694 = [inst_17693];
var inst_17695 = (new cljs.core.PersistentVector(null,1,(5),inst_17690,inst_17694,null));
var inst_17696 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17695);
var state_17719__$1 = state_17719;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17719__$1,(10),inst_17696);
} else {
if((state_val_17720 === (3))){
var inst_17717 = (state_17719[(2)]);
var state_17719__$1 = state_17719;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17719__$1,inst_17717);
} else {
if((state_val_17720 === (2))){
var _ = (function (){var statearr_17728 = state_17719;
(statearr_17728[(4)] = cljs.core.cons((5),(state_17719[(4)])));

return statearr_17728;
})();
var state_17719__$1 = state_17719;
var statearr_17729_17748 = state_17719__$1;
(statearr_17729_17748[(2)] = null);

(statearr_17729_17748[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (9))){
var _ = (function (){var statearr_17730 = state_17719;
(statearr_17730[(4)] = cljs.core.rest((state_17719[(4)])));

return statearr_17730;
})();
var state_17719__$1 = state_17719;
var ex17726 = (state_17719__$1[(2)]);
var statearr_17731_17749 = state_17719__$1;
(statearr_17731_17749[(5)] = ex17726);


var statearr_17732_17750 = state_17719__$1;
(statearr_17732_17750[(1)] = (8));

(statearr_17732_17750[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (5))){
var _ = (function (){var statearr_17733 = state_17719;
(statearr_17733[(4)] = cljs.core.rest((state_17719[(4)])));

return statearr_17733;
})();
var state_17719__$1 = state_17719;
var ex17727 = (state_17719__$1[(2)]);
var statearr_17734_17751 = state_17719__$1;
(statearr_17734_17751[(5)] = ex17727);


if((ex17727 instanceof Error)){
var statearr_17735_17752 = state_17719__$1;
(statearr_17735_17752[(1)] = (4));

(statearr_17735_17752[(5)] = null);

} else {
throw ex17727;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (10))){
var inst_17698 = (state_17719[(2)]);
var inst_17699 = fluree.db.util.async.throw_err(inst_17698);
var _ = (function (){var statearr_17736 = state_17719;
(statearr_17736[(4)] = cljs.core.rest((state_17719[(4)])));

return statearr_17736;
})();
var state_17719__$1 = state_17719;
var statearr_17737_17753 = state_17719__$1;
(statearr_17737_17753[(2)] = inst_17699);

(statearr_17737_17753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (8))){
var inst_17684 = (state_17719[(2)]);
var state_17719__$1 = (function (){var statearr_17738 = state_17719;
(statearr_17738[(7)] = inst_17684);

return statearr_17738;
})();
var statearr_17739_17754 = state_17719__$1;
(statearr_17739_17754[(2)] = null);

(statearr_17739_17754[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0 = (function (){
var statearr_17740 = [null,null,null,null,null,null,null,null];
(statearr_17740[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2684__auto__);

(statearr_17740[(1)] = (1));

return statearr_17740;
});
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1 = (function (state_17719){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17719);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17741){var ex__2687__auto__ = e17741;
var statearr_17742_17755 = state_17719;
(statearr_17742_17755[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17719[(4)]))){
var statearr_17743_17756 = state_17719;
(statearr_17743_17756[(1)] = cljs.core.first((state_17719[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17757 = state_17719;
state_17719 = G__17757;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__ = function(state_17719){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1.call(this,state_17719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17744 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17744[(6)] = c__2706__auto__);

return statearr_17744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
