// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22912 = arguments.length;
switch (G__22912) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__22913 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__22913) : f.call(null,G__22913));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__22914 = cljs.core._deref(vol);
var G__22915 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22914,G__22915) : f.call(null,G__22914,G__22915));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__22916 = cljs.core._deref(vol);
var G__22917 = arg1;
var G__22918 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__22916,G__22917,G__22918) : f.call(null,G__22916,G__22917,G__22918));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__22919 = cljs.core._deref(vol);
var G__22920 = arg1;
var G__22921 = arg2;
var G__22922 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__22919,G__22920,G__22921,G__22922) : f.call(null,G__22919,G__22920,G__22921,G__22922));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22925 = arguments.length;
switch (G__22925) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22927 = null;
var G__22927__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22927__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22927__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22927 = function(result,flake){
switch(arguments.length){
case 0:
return G__22927__0.call(this);
case 1:
return G__22927__1.call(this,result);
case 2:
return G__22927__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22927.cljs$core$IFn$_invoke$arity$0 = G__22927__0;
G__22927.cljs$core$IFn$_invoke$arity$1 = G__22927__1;
G__22927.cljs$core$IFn$_invoke$arity$2 = G__22927__2;
return G__22927;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22928 = null;
var G__22928__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22928__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22928__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__22928 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22928__0.call(this);
case 1:
return G__22928__1.call(this,result);
case 2:
return G__22928__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22928.cljs$core$IFn$_invoke$arity$0 = G__22928__0;
G__22928.cljs$core$IFn$_invoke$arity$1 = G__22928__1;
G__22928.cljs$core$IFn$_invoke$arity$2 = G__22928__2;
return G__22928;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__22930 = res;
var G__22930__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__22929_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__22929_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22930):G__22930);
var G__22930__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__22930__$1):G__22930__$1);
var G__22930__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__22930__$2):G__22930__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__22930__$3);
} else {
return G__22930__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22934 = arguments.length;
switch (G__22934) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23373){
var state_val_23374 = (state_23373[(1)]);
if((state_val_23374 === (121))){
var inst_23296 = (state_23373[(2)]);
var inst_23297 = fluree.db.util.async.throw_err(inst_23296);
var inst_23298 = cljs.core.seq(inst_23297);
var state_23373__$1 = state_23373;
if(inst_23298){
var statearr_23375_23589 = state_23373__$1;
(statearr_23375_23589[(1)] = (122));

} else {
var statearr_23376_23590 = state_23373__$1;
(statearr_23376_23590[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (65))){
var inst_23089 = (state_23373[(7)]);
var inst_23088 = (state_23373[(2)]);
var inst_23089__$1 = fluree.db.util.async.throw_err(inst_23088);
var inst_23090 = cljs.core.seq(inst_23089__$1);
var state_23373__$1 = (function (){var statearr_23377 = state_23373;
(statearr_23377[(7)] = inst_23089__$1);

return statearr_23377;
})();
if(inst_23090){
var statearr_23378_23591 = state_23373__$1;
(statearr_23378_23591[(1)] = (66));

} else {
var statearr_23379_23592 = state_23373__$1;
(statearr_23379_23592[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (70))){
var inst_23089 = (state_23373[(7)]);
var inst_23100 = cljs.core.count(inst_23089);
var inst_23101 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_23100);
var state_23373__$1 = state_23373;
var statearr_23380_23593 = state_23373__$1;
(statearr_23380_23593[(2)] = inst_23101);

(statearr_23380_23593[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (62))){
var inst_23079 = (state_23373[(8)]);
var inst_23082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23083 = inst_23079.o;
var inst_23084 = [inst_23083];
var inst_23085 = (new cljs.core.PersistentVector(null,1,(5),inst_23082,inst_23084,null));
var inst_23086 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23085);
var state_23373__$1 = state_23373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23373__$1,(65),inst_23086);
} else {
if((state_val_23374 === (74))){
var inst_23073 = (state_23373[(9)]);
var state_23373__$1 = state_23373;
var statearr_23381_23594 = state_23373__$1;
(statearr_23381_23594[(2)] = inst_23073);

(statearr_23381_23594[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (110))){
var inst_23258 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_23259 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_23258);
var inst_23260 = inst_23259 === true;
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_23260)){
var statearr_23382_23595 = state_23373__$1;
(statearr_23382_23595[(1)] = (113));

} else {
var statearr_23383_23596 = state_23373__$1;
(statearr_23383_23596[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (130))){
var inst_23368 = (state_23373[(2)]);
var _ = (function (){var statearr_23384 = state_23373;
(statearr_23384[(4)] = cljs.core.rest((state_23373[(4)])));

return statearr_23384;
})();
var state_23373__$1 = state_23373;
var statearr_23385_23597 = state_23373__$1;
(statearr_23385_23597[(2)] = inst_23368);

(statearr_23385_23597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (128))){
var inst_23343 = (state_23373[(10)]);
var inst_23346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23347 = [acc,inst_23343];
var inst_23348 = (new cljs.core.PersistentVector(null,2,(5),inst_23346,inst_23347,null));
var state_23373__$1 = state_23373;
var statearr_23386_23598 = state_23373__$1;
(statearr_23386_23598[(2)] = inst_23348);

(statearr_23386_23598[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (7))){
var inst_22946 = (state_23373[(11)]);
var state_23373__$1 = state_23373;
var statearr_23387_23599 = state_23373__$1;
(statearr_23387_23599[(2)] = inst_22946);

(statearr_23387_23599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (59))){
var inst_23337 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23388_23600 = state_23373__$1;
(statearr_23388_23600[(2)] = inst_23337);

(statearr_23388_23600[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (86))){
var inst_23167 = (state_23373[(12)]);
var inst_23167__$1 = (state_23373[(2)]);
var state_23373__$1 = (function (){var statearr_23389 = state_23373;
(statearr_23389[(12)] = inst_23167__$1);

return statearr_23389;
})();
if(cljs.core.truth_(inst_23167__$1)){
var statearr_23390_23601 = state_23373__$1;
(statearr_23390_23601[(1)] = (88));

} else {
var statearr_23391_23602 = state_23373__$1;
(statearr_23391_23602[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (20))){
var inst_22987 = (state_23373[(13)]);
var inst_22988 = (state_23373[(14)]);
var inst_22975 = (state_23373[(15)]);
var inst_22986 = (state_23373[(2)]);
var inst_22987__$1 = cljs.core.__destructure_map(inst_22975);
var inst_22988__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22987__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22989 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22987__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22990 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22987__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22991 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22987__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22992 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22987__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22993 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22987__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_23373__$1 = (function (){var statearr_23392 = state_23373;
(statearr_23392[(16)] = inst_22992);

(statearr_23392[(13)] = inst_22987__$1);

(statearr_23392[(14)] = inst_22988__$1);

(statearr_23392[(17)] = inst_22991);

(statearr_23392[(18)] = inst_22986);

(statearr_23392[(19)] = inst_22990);

(statearr_23392[(20)] = inst_22993);

(statearr_23392[(21)] = inst_22989);

return statearr_23392;
})();
if(cljs.core.truth_(inst_22988__$1)){
var statearr_23393_23603 = state_23373__$1;
(statearr_23393_23603[(1)] = (24));

} else {
var statearr_23394_23604 = state_23373__$1;
(statearr_23394_23604[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (72))){
var inst_23098 = (state_23373[(22)]);
var inst_23104 = (state_23373[(2)]);
var inst_23105 = cljs.core.seq(inst_23098);
var state_23373__$1 = (function (){var statearr_23395 = state_23373;
(statearr_23395[(23)] = inst_23104);

return statearr_23395;
})();
if(inst_23105){
var statearr_23396_23605 = state_23373__$1;
(statearr_23396_23605[(1)] = (73));

} else {
var statearr_23397_23606 = state_23373__$1;
(statearr_23397_23606[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (58))){
var inst_22975 = (state_23373[(15)]);
var inst_23120 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22975);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_23120)){
var statearr_23398_23607 = state_23373__$1;
(statearr_23398_23607[(1)] = (76));

} else {
var statearr_23399_23608 = state_23373__$1;
(statearr_23399_23608[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (60))){
var inst_23072 = (state_23373[(24)]);
var inst_23079 = (state_23373[(8)]);
var inst_23078 = cljs.core.seq(inst_23072);
var inst_23079__$1 = cljs.core.first(inst_23078);
var inst_23080 = cljs.core.next(inst_23078);
var state_23373__$1 = (function (){var statearr_23400 = state_23373;
(statearr_23400[(25)] = inst_23080);

(statearr_23400[(8)] = inst_23079__$1);

return statearr_23400;
})();
if(cljs.core.truth_(inst_23079__$1)){
var statearr_23401_23609 = state_23373__$1;
(statearr_23401_23609[(1)] = (62));

} else {
var statearr_23402_23610 = state_23373__$1;
(statearr_23402_23610[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (27))){
var inst_22992 = (state_23373[(16)]);
var inst_22996 = (state_23373[(26)]);
var inst_22996__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22992);
var state_23373__$1 = (function (){var statearr_23403 = state_23373;
(statearr_23403[(26)] = inst_22996__$1);

return statearr_23403;
})();
if(inst_22996__$1){
var statearr_23404_23611 = state_23373__$1;
(statearr_23404_23611[(1)] = (30));

} else {
var statearr_23405_23612 = state_23373__$1;
(statearr_23405_23612[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (1))){
var state_23373__$1 = state_23373;
var statearr_23406_23613 = state_23373__$1;
(statearr_23406_23613[(2)] = null);

(statearr_23406_23613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (69))){
var inst_23094 = (state_23373[(2)]);
var inst_23095 = fluree.db.util.async.throw_err(inst_23094);
var state_23373__$1 = state_23373;
var statearr_23407_23614 = state_23373__$1;
(statearr_23407_23614[(2)] = inst_23095);

(statearr_23407_23614[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (101))){
var inst_23251 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23408_23615 = state_23373__$1;
(statearr_23408_23615[(2)] = inst_23251);

(statearr_23408_23615[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (24))){
var inst_22992 = (state_23373[(16)]);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_22992)){
var statearr_23409_23616 = state_23373__$1;
(statearr_23409_23616[(1)] = (27));

} else {
var statearr_23410_23617 = state_23373__$1;
(statearr_23410_23617[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (102))){
var inst_23223 = (state_23373[(27)]);
var inst_23222 = (state_23373[(2)]);
var inst_23223__$1 = fluree.db.util.async.throw_err(inst_23222);
var inst_23224 = cljs.core.empty_QMARK_(inst_23223__$1);
var state_23373__$1 = (function (){var statearr_23411 = state_23373;
(statearr_23411[(27)] = inst_23223__$1);

return statearr_23411;
})();
if(inst_23224){
var statearr_23412_23618 = state_23373__$1;
(statearr_23412_23618[(1)] = (103));

} else {
var statearr_23413_23619 = state_23373__$1;
(statearr_23413_23619[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (135))){
var state_23373__$1 = state_23373;
var statearr_23414_23620 = state_23373__$1;
(statearr_23414_23620[(2)] = null);

(statearr_23414_23620[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (55))){
var inst_22975 = (state_23373[(15)]);
var inst_23048 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22975);
var state_23373__$1 = state_23373;
var statearr_23415_23621 = state_23373__$1;
(statearr_23415_23621[(2)] = inst_23048);

(statearr_23415_23621[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (85))){
var inst_23142 = (state_23373[(28)]);
var inst_22975 = (state_23373[(15)]);
var inst_23154 = inst_23142.o;
var inst_23155 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22975);
var inst_23156 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_23154,inst_23155);
var state_23373__$1 = state_23373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23373__$1,(87),inst_23156);
} else {
if((state_val_23374 === (39))){
var inst_23023 = (state_23373[(29)]);
var inst_22991 = (state_23373[(17)]);
var inst_23023__$1 = cljs.core.not(inst_22991);
var state_23373__$1 = (function (){var statearr_23416 = state_23373;
(statearr_23416[(29)] = inst_23023__$1);

return statearr_23416;
})();
if(inst_23023__$1){
var statearr_23417_23622 = state_23373__$1;
(statearr_23417_23622[(1)] = (42));

} else {
var statearr_23418_23623 = state_23373__$1;
(statearr_23418_23623[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (88))){
var inst_23136 = (state_23373[(30)]);
var inst_23167 = (state_23373[(12)]);
var inst_23169 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23136,inst_23167);
var state_23373__$1 = state_23373;
var statearr_23419_23624 = state_23373__$1;
(statearr_23419_23624[(2)] = inst_23169);

(statearr_23419_23624[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (46))){
var inst_22990 = (state_23373[(19)]);
var state_23373__$1 = state_23373;
var statearr_23420_23625 = state_23373__$1;
(statearr_23420_23625[(2)] = inst_22990);

(statearr_23420_23625[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (4))){
var inst_22935 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23421_23626 = state_23373__$1;
(statearr_23421_23626[(2)] = inst_22935);

(statearr_23421_23626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (77))){
var inst_23182 = (state_23373[(31)]);
var inst_23182__$1 = componentFollow_QMARK_;
var state_23373__$1 = (function (){var statearr_23422 = state_23373;
(statearr_23422[(31)] = inst_23182__$1);

return statearr_23422;
})();
if(cljs.core.truth_(inst_23182__$1)){
var statearr_23423_23627 = state_23373__$1;
(statearr_23423_23627[(1)] = (91));

} else {
var statearr_23424_23628 = state_23373__$1;
(statearr_23424_23628[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (106))){
var inst_23203 = (state_23373[(32)]);
var inst_23237 = (state_23373[(2)]);
var inst_23238 = fluree.db.util.async.throw_err(inst_23237);
var inst_23239 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23203,inst_23238);
var state_23373__$1 = state_23373;
var statearr_23425_23629 = state_23373__$1;
(statearr_23425_23629[(2)] = inst_23239);

(statearr_23425_23629[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (119))){
var inst_23281 = (state_23373[(33)]);
var inst_23311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23312 = [inst_23281,offset_map];
var inst_23313 = (new cljs.core.PersistentVector(null,2,(5),inst_23311,inst_23312,null));
var state_23373__$1 = state_23373;
var statearr_23426_23630 = state_23373__$1;
(statearr_23426_23630[(2)] = inst_23313);

(statearr_23426_23630[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (95))){
var inst_22989 = (state_23373[(21)]);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_22989)){
var statearr_23427_23631 = state_23373__$1;
(statearr_23427_23631[(1)] = (110));

} else {
var statearr_23428_23632 = state_23373__$1;
(statearr_23428_23632[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (54))){
var inst_23045 = (state_23373[(34)]);
var state_23373__$1 = state_23373;
var statearr_23429_23633 = state_23373__$1;
(statearr_23429_23633[(2)] = inst_23045);

(statearr_23429_23633[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (92))){
var inst_23182 = (state_23373[(31)]);
var state_23373__$1 = state_23373;
var statearr_23430_23634 = state_23373__$1;
(statearr_23430_23634[(2)] = inst_23182);

(statearr_23430_23634[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (104))){
var inst_22945 = (state_23373[(35)]);
var inst_23223 = (state_23373[(27)]);
var inst_23232 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_23233 = [true,inst_22945];
var inst_23234 = cljs.core.PersistentHashMap.fromArrays(inst_23232,inst_23233);
var inst_23235 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23234,inst_23223) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23234,inst_23223));
var state_23373__$1 = state_23373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23373__$1,(106),inst_23235);
} else {
if((state_val_23374 === (15))){
var inst_22945 = (state_23373[(35)]);
var inst_22968 = (state_23373[(36)]);
var inst_22972 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22968,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22945);
var state_23373__$1 = state_23373;
var statearr_23431_23635 = state_23373__$1;
(statearr_23431_23635[(2)] = inst_22972);

(statearr_23431_23635[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (48))){
var inst_23039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23040 = [null,offset_map];
var inst_23041 = (new cljs.core.PersistentVector(null,2,(5),inst_23039,inst_23040,null));
var state_23373__$1 = state_23373;
var statearr_23432_23636 = state_23373__$1;
(statearr_23432_23636[(2)] = inst_23041);

(statearr_23432_23636[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (50))){
var inst_23339 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23433_23637 = state_23373__$1;
(statearr_23433_23637[(2)] = inst_23339);

(statearr_23433_23637[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (116))){
var inst_23280 = (state_23373[(37)]);
var inst_23287 = (state_23373[(38)]);
var inst_23286 = cljs.core.seq(inst_23280);
var inst_23287__$1 = cljs.core.first(inst_23286);
var inst_23288 = cljs.core.next(inst_23286);
var state_23373__$1 = (function (){var statearr_23434 = state_23373;
(statearr_23434[(39)] = inst_23288);

(statearr_23434[(38)] = inst_23287__$1);

return statearr_23434;
})();
if(cljs.core.truth_(inst_23287__$1)){
var statearr_23435_23638 = state_23373__$1;
(statearr_23435_23638[(1)] = (118));

} else {
var statearr_23436_23639 = state_23373__$1;
(statearr_23436_23639[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (75))){
var inst_23080 = (state_23373[(25)]);
var inst_23110 = (state_23373[(2)]);
var inst_23072 = inst_23080;
var inst_23073 = inst_23110;
var state_23373__$1 = (function (){var statearr_23437 = state_23373;
(statearr_23437[(24)] = inst_23072);

(statearr_23437[(9)] = inst_23073);

return statearr_23437;
})();
var statearr_23438_23640 = state_23373__$1;
(statearr_23438_23640[(2)] = null);

(statearr_23438_23640[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (99))){
var inst_22975 = (state_23373[(15)]);
var inst_23209 = (state_23373[(40)]);
var inst_23212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23213 = inst_23209.o;
var inst_23214 = [inst_23213];
var inst_23215 = (new cljs.core.PersistentVector(null,1,(5),inst_23212,inst_23214,null));
var inst_23216 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23217 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22975);
var inst_23218 = [inst_23217];
var inst_23219 = cljs.core.PersistentHashMap.fromArrays(inst_23216,inst_23218);
var inst_23220 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23215,inst_23219);
var state_23373__$1 = state_23373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23373__$1,(102),inst_23220);
} else {
if((state_val_23374 === (21))){
var inst_22979 = (state_23373[(41)]);
var state_23373__$1 = state_23373;
var statearr_23439_23641 = state_23373__$1;
(statearr_23439_23641[(2)] = inst_22979);

(statearr_23439_23641[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (31))){
var inst_22996 = (state_23373[(26)]);
var state_23373__$1 = state_23373;
var statearr_23440_23642 = state_23373__$1;
(statearr_23440_23642[(2)] = inst_22996);

(statearr_23440_23642[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (113))){
var inst_22945 = (state_23373[(35)]);
var inst_22992 = (state_23373[(16)]);
var inst_22987 = (state_23373[(13)]);
var inst_22988 = (state_23373[(14)]);
var inst_22991 = (state_23373[(17)]);
var inst_22986 = (state_23373[(18)]);
var inst_22960 = (state_23373[(42)]);
var inst_22990 = (state_23373[(19)]);
var inst_22975 = (state_23373[(15)]);
var inst_22993 = (state_23373[(20)]);
var inst_22989 = (state_23373[(21)]);
var inst_23262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23263 = (function (){var p = inst_22993;
var pred_spec__$1 = inst_22960;
var orderBy = inst_22991;
var map__22941 = inst_22987;
var multi_QMARK_ = inst_22988;
var limit = inst_22990;
var offset = inst_22992;
var k = inst_22986;
var compact_QMARK_ = inst_22945;
var pred_spec_SINGLEQUOTE_ = inst_22975;
var ref_QMARK_ = inst_22989;
return (function (p1__22931_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__22931_SHARP_.o]);
});
})();
var inst_23264 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_23263,flakes);
var inst_23265 = [inst_23264,offset_map];
var inst_23266 = (new cljs.core.PersistentVector(null,2,(5),inst_23262,inst_23265,null));
var state_23373__$1 = state_23373;
var statearr_23441_23643 = state_23373__$1;
(statearr_23441_23643[(2)] = inst_23266);

(statearr_23441_23643[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (32))){
var inst_23002 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23442_23644 = state_23373__$1;
(statearr_23442_23644[(2)] = inst_23002);

(statearr_23442_23644[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (136))){
var inst_23364 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23443_23645 = state_23373__$1;
(statearr_23443_23645[(2)] = inst_23364);

(statearr_23443_23645[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (40))){
var inst_22988 = (state_23373[(14)]);
var state_23373__$1 = state_23373;
var statearr_23444_23646 = state_23373__$1;
(statearr_23444_23646[(2)] = inst_22988);

(statearr_23444_23646[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (129))){
var inst_22988 = (state_23373[(14)]);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_22988)){
var statearr_23445_23647 = state_23373__$1;
(statearr_23445_23647[(1)] = (131));

} else {
var statearr_23446_23648 = state_23373__$1;
(statearr_23446_23648[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (91))){
var inst_22975 = (state_23373[(15)]);
var inst_23184 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22975);
var state_23373__$1 = state_23373;
var statearr_23447_23649 = state_23373__$1;
(statearr_23447_23649[(2)] = inst_23184);

(statearr_23447_23649[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (117))){
var inst_23317 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23448_23650 = state_23373__$1;
(statearr_23448_23650[(2)] = inst_23317);

(statearr_23448_23650[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (108))){
var state_23373__$1 = state_23373;
var statearr_23449_23651 = state_23373__$1;
(statearr_23449_23651[(2)] = null);

(statearr_23449_23651[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (56))){
var inst_23050 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23450_23652 = state_23373__$1;
(statearr_23450_23652[(2)] = inst_23050);

(statearr_23450_23652[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (33))){
var inst_22993 = (state_23373[(20)]);
var inst_23010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23011 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22993);
var state_23373__$1 = (function (){var statearr_23451 = state_23373;
(statearr_23451[(43)] = inst_23010);

return statearr_23451;
})();
if(cljs.core.truth_(inst_23011)){
var statearr_23452_23653 = state_23373__$1;
(statearr_23452_23653[(1)] = (36));

} else {
var statearr_23453_23654 = state_23373__$1;
(statearr_23453_23654[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (13))){
var inst_22960 = (state_23373[(42)]);
var state_23373__$1 = state_23373;
var statearr_23454_23655 = state_23373__$1;
(statearr_23454_23655[(2)] = inst_22960);

(statearr_23454_23655[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (22))){
var inst_22975 = (state_23373[(15)]);
var inst_22982 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22975);
var state_23373__$1 = state_23373;
var statearr_23455_23656 = state_23373__$1;
(statearr_23455_23656[(2)] = inst_22982);

(statearr_23455_23656[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (90))){
var inst_23143 = (state_23373[(44)]);
var inst_23172 = (state_23373[(2)]);
var inst_23135 = inst_23143;
var inst_23136 = inst_23172;
var state_23373__$1 = (function (){var statearr_23456 = state_23373;
(statearr_23456[(30)] = inst_23136);

(statearr_23456[(45)] = inst_23135);

return statearr_23456;
})();
var statearr_23457_23657 = state_23373__$1;
(statearr_23457_23657[(2)] = null);

(statearr_23457_23657[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (109))){
var inst_23210 = (state_23373[(46)]);
var inst_23241 = (state_23373[(47)]);
var inst_23247 = (state_23373[(2)]);
var inst_23202 = inst_23210;
var inst_23203 = inst_23241;
var state_23373__$1 = (function (){var statearr_23458 = state_23373;
(statearr_23458[(48)] = inst_23202);

(statearr_23458[(49)] = inst_23247);

(statearr_23458[(32)] = inst_23203);

return statearr_23458;
})();
var statearr_23459_23658 = state_23373__$1;
(statearr_23459_23658[(2)] = null);

(statearr_23459_23658[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (36))){
var inst_22993 = (state_23373[(20)]);
var inst_23013 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22993,cljs.core.dec);
var state_23373__$1 = state_23373;
var statearr_23460_23659 = state_23373__$1;
(statearr_23460_23659[(2)] = inst_23013);

(statearr_23460_23659[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (41))){
var inst_23037 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_23037)){
var statearr_23461_23660 = state_23373__$1;
(statearr_23461_23660[(1)] = (48));

} else {
var statearr_23462_23661 = state_23373__$1;
(statearr_23462_23661[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (118))){
var inst_23287 = (state_23373[(38)]);
var inst_23290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23291 = inst_23287.o;
var inst_23292 = [inst_23291];
var inst_23293 = (new cljs.core.PersistentVector(null,1,(5),inst_23290,inst_23292,null));
var inst_23294 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23293);
var state_23373__$1 = state_23373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23373__$1,(121),inst_23294);
} else {
if((state_val_23374 === (89))){
var inst_23136 = (state_23373[(30)]);
var state_23373__$1 = state_23373;
var statearr_23463_23662 = state_23373__$1;
(statearr_23463_23662[(2)] = inst_23136);

(statearr_23463_23662[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (100))){
var inst_23203 = (state_23373[(32)]);
var state_23373__$1 = state_23373;
var statearr_23464_23663 = state_23373__$1;
(statearr_23464_23663[(2)] = inst_23203);

(statearr_23464_23663[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (131))){
var inst_23342 = (state_23373[(50)]);
var inst_23343 = (state_23373[(10)]);
var inst_22986 = (state_23373[(18)]);
var inst_23351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23352 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22986,inst_23342);
var inst_23353 = [inst_23352,inst_23343];
var inst_23354 = (new cljs.core.PersistentVector(null,2,(5),inst_23351,inst_23353,null));
var state_23373__$1 = state_23373;
var statearr_23465_23664 = state_23373__$1;
(statearr_23465_23664[(2)] = inst_23354);

(statearr_23465_23664[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (122))){
var inst_23288 = (state_23373[(39)]);
var inst_23281 = (state_23373[(33)]);
var inst_23287 = (state_23373[(38)]);
var inst_23300 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23301 = inst_23287.o;
var inst_23302 = [inst_23301];
var inst_23303 = cljs.core.PersistentHashMap.fromArrays(inst_23300,inst_23302);
var inst_23304 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23281,inst_23303);
var inst_23280 = inst_23288;
var inst_23281__$1 = inst_23304;
var state_23373__$1 = (function (){var statearr_23466 = state_23373;
(statearr_23466[(33)] = inst_23281__$1);

(statearr_23466[(37)] = inst_23280);

return statearr_23466;
})();
var statearr_23467_23665 = state_23373__$1;
(statearr_23467_23665[(2)] = null);

(statearr_23467_23665[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (43))){
var inst_23023 = (state_23373[(29)]);
var state_23373__$1 = state_23373;
var statearr_23468_23666 = state_23373__$1;
(statearr_23468_23666[(2)] = inst_23023);

(statearr_23468_23666[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (61))){
var inst_23059 = (state_23373[(51)]);
var inst_23116 = (state_23373[(2)]);
var inst_23117 = [inst_23116,offset_map];
var inst_23118 = (new cljs.core.PersistentVector(null,2,(5),inst_23059,inst_23117,null));
var state_23373__$1 = state_23373;
var statearr_23469_23667 = state_23373__$1;
(statearr_23469_23667[(2)] = inst_23118);

(statearr_23469_23667[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (29))){
var inst_23005 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23470_23668 = state_23373__$1;
(statearr_23470_23668[(2)] = inst_23005);

(statearr_23470_23668[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (44))){
var inst_23034 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23471_23669 = state_23373__$1;
(statearr_23471_23669[(2)] = inst_23034);

(statearr_23471_23669[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (93))){
var inst_23187 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_23187)){
var statearr_23472_23670 = state_23373__$1;
(statearr_23472_23670[(1)] = (94));

} else {
var statearr_23473_23671 = state_23373__$1;
(statearr_23473_23671[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (6))){
var inst_22948 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22949 = (inst_22948 == null);
var state_23373__$1 = state_23373;
var statearr_23474_23672 = state_23373__$1;
(statearr_23474_23672[(2)] = inst_22949);

(statearr_23474_23672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (111))){
var state_23373__$1 = state_23373;
var statearr_23475_23673 = state_23373__$1;
(statearr_23475_23673[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (28))){
var inst_22992 = (state_23373[(16)]);
var state_23373__$1 = state_23373;
var statearr_23477_23674 = state_23373__$1;
(statearr_23477_23674[(2)] = inst_22992);

(statearr_23477_23674[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (134))){
var inst_23342 = (state_23373[(50)]);
var inst_23343 = (state_23373[(10)]);
var inst_22986 = (state_23373[(18)]);
var inst_23357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23358 = cljs.core.first(inst_23342);
var inst_23359 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22986,inst_23358);
var inst_23360 = [inst_23359,inst_23343];
var inst_23361 = (new cljs.core.PersistentVector(null,2,(5),inst_23357,inst_23360,null));
var state_23373__$1 = state_23373;
var statearr_23478_23675 = state_23373__$1;
(statearr_23478_23675[(2)] = inst_23361);

(statearr_23478_23675[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (64))){
var inst_23114 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23479_23676 = state_23373__$1;
(statearr_23479_23676[(2)] = inst_23114);

(statearr_23479_23676[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (103))){
var inst_23203 = (state_23373[(32)]);
var inst_23209 = (state_23373[(40)]);
var inst_23226 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23227 = inst_23209.o;
var inst_23228 = [inst_23227];
var inst_23229 = cljs.core.PersistentHashMap.fromArrays(inst_23226,inst_23228);
var inst_23230 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23203,inst_23229);
var state_23373__$1 = state_23373;
var statearr_23480_23677 = state_23373__$1;
(statearr_23480_23677[(2)] = inst_23230);

(statearr_23480_23677[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (51))){
var inst_23045 = (state_23373[(34)]);
var inst_22975 = (state_23373[(15)]);
var inst_23045__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22975);
var state_23373__$1 = (function (){var statearr_23481 = state_23373;
(statearr_23481[(34)] = inst_23045__$1);

return statearr_23481;
})();
if(cljs.core.truth_(inst_23045__$1)){
var statearr_23482_23678 = state_23373__$1;
(statearr_23482_23678[(1)] = (54));

} else {
var statearr_23483_23679 = state_23373__$1;
(statearr_23483_23679[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (25))){
var inst_22988 = (state_23373[(14)]);
var state_23373__$1 = state_23373;
var statearr_23484_23680 = state_23373__$1;
(statearr_23484_23680[(2)] = inst_22988);

(statearr_23484_23680[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (34))){
var inst_22988 = (state_23373[(14)]);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_22988)){
var statearr_23485_23681 = state_23373__$1;
(statearr_23485_23681[(1)] = (39));

} else {
var statearr_23486_23682 = state_23373__$1;
(statearr_23486_23682[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (125))){
var inst_22945 = (state_23373[(35)]);
var inst_22992 = (state_23373[(16)]);
var inst_22987 = (state_23373[(13)]);
var inst_22988 = (state_23373[(14)]);
var inst_22991 = (state_23373[(17)]);
var inst_22986 = (state_23373[(18)]);
var inst_22960 = (state_23373[(42)]);
var inst_22990 = (state_23373[(19)]);
var inst_22975 = (state_23373[(15)]);
var inst_22993 = (state_23373[(20)]);
var inst_22989 = (state_23373[(21)]);
var inst_23322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23323 = (function (){var p = inst_22993;
var pred_spec__$1 = inst_22960;
var orderBy = inst_22991;
var map__22941 = inst_22987;
var multi_QMARK_ = inst_22988;
var limit = inst_22990;
var offset = inst_22992;
var k = inst_22986;
var compact_QMARK_ = inst_22945;
var pred_spec_SINGLEQUOTE_ = inst_22975;
var ref_QMARK_ = inst_22989;
return (function (p1__22932_SHARP_){
return p1__22932_SHARP_.o;
});
})();
var inst_23324 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_23323,flakes);
var inst_23325 = [inst_23324,offset_map];
var inst_23326 = (new cljs.core.PersistentVector(null,2,(5),inst_23322,inst_23325,null));
var state_23373__$1 = state_23373;
var statearr_23487_23683 = state_23373__$1;
(statearr_23487_23683[(2)] = inst_23326);

(statearr_23487_23683[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (17))){
var inst_22976 = (state_23373[(52)]);
var inst_22975 = (state_23373[(15)]);
var inst_22975__$1 = (state_23373[(2)]);
var inst_22976__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22975__$1);
var state_23373__$1 = (function (){var statearr_23488 = state_23373;
(statearr_23488[(52)] = inst_22976__$1);

(statearr_23488[(15)] = inst_22975__$1);

return statearr_23488;
})();
if(cljs.core.truth_(inst_22976__$1)){
var statearr_23489_23684 = state_23373__$1;
(statearr_23489_23684[(1)] = (18));

} else {
var statearr_23490_23685 = state_23373__$1;
(statearr_23490_23685[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (3))){
var inst_23371 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23373__$1,inst_23371);
} else {
if((state_val_23374 === (12))){
var inst_22960 = (state_23373[(42)]);
var inst_22965 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22960,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_23373__$1 = state_23373;
var statearr_23491_23686 = state_23373__$1;
(statearr_23491_23686[(2)] = inst_22965);

(statearr_23491_23686[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (2))){
var inst_22946 = (state_23373[(11)]);
var _ = (function (){var statearr_23492 = state_23373;
(statearr_23492[(4)] = cljs.core.cons((5),(state_23373[(4)])));

return statearr_23492;
})();
var inst_22945 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22946__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_23373__$1 = (function (){var statearr_23493 = state_23373;
(statearr_23493[(35)] = inst_22945);

(statearr_23493[(11)] = inst_22946__$1);

return statearr_23493;
})();
if(cljs.core.truth_(inst_22946__$1)){
var statearr_23494_23687 = state_23373__$1;
(statearr_23494_23687[(1)] = (6));

} else {
var statearr_23495_23688 = state_23373__$1;
(statearr_23495_23688[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (66))){
var inst_23089 = (state_23373[(7)]);
var inst_23058 = (state_23373[(53)]);
var inst_23092 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23058,inst_23089) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23058,inst_23089));
var state_23373__$1 = state_23373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23373__$1,(69),inst_23092);
} else {
if((state_val_23374 === (107))){
var inst_23223 = (state_23373[(27)]);
var inst_23243 = cljs.core.count(inst_23223);
var inst_23244 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_23243);
var state_23373__$1 = state_23373;
var statearr_23496_23689 = state_23373__$1;
(statearr_23496_23689[(2)] = inst_23244);

(statearr_23496_23689[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (23))){
var inst_22984 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23497_23690 = state_23373__$1;
(statearr_23497_23690[(2)] = inst_22984);

(statearr_23497_23690[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (47))){
var inst_23031 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23498_23691 = state_23373__$1;
(statearr_23498_23691[(2)] = inst_23031);

(statearr_23498_23691[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (35))){
var inst_23342 = (state_23373[(50)]);
var inst_23341 = (state_23373[(2)]);
var inst_23342__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23341,(0),null);
var inst_23343 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23341,(1),null);
var inst_23344 = cljs.core.empty_QMARK_(inst_23342__$1);
var state_23373__$1 = (function (){var statearr_23499 = state_23373;
(statearr_23499[(50)] = inst_23342__$1);

(statearr_23499[(10)] = inst_23343);

return statearr_23499;
})();
if(inst_23344){
var statearr_23500_23692 = state_23373__$1;
(statearr_23500_23692[(1)] = (128));

} else {
var statearr_23501_23693 = state_23373__$1;
(statearr_23501_23693[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (127))){
var inst_23329 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23502_23694 = state_23373__$1;
(statearr_23502_23694[(2)] = inst_23329);

(statearr_23502_23694[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (82))){
var inst_23136 = (state_23373[(30)]);
var state_23373__$1 = state_23373;
var statearr_23503_23695 = state_23373__$1;
(statearr_23503_23695[(2)] = inst_23136);

(statearr_23503_23695[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (76))){
var inst_23122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23130 = flakes;
var inst_23131 = cljs.core.seq(inst_23130);
var inst_23132 = cljs.core.first(inst_23131);
var inst_23133 = cljs.core.next(inst_23131);
var inst_23134 = cljs.core.PersistentVector.EMPTY;
var inst_23135 = inst_23130;
var inst_23136 = inst_23134;
var state_23373__$1 = (function (){var statearr_23504 = state_23373;
(statearr_23504[(30)] = inst_23136);

(statearr_23504[(54)] = inst_23133);

(statearr_23504[(45)] = inst_23135);

(statearr_23504[(55)] = inst_23122);

(statearr_23504[(56)] = inst_23132);

return statearr_23504;
})();
var statearr_23505_23696 = state_23373__$1;
(statearr_23505_23696[(2)] = null);

(statearr_23505_23696[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (97))){
var inst_23202 = (state_23373[(48)]);
var inst_23209 = (state_23373[(40)]);
var inst_23208 = cljs.core.seq(inst_23202);
var inst_23209__$1 = cljs.core.first(inst_23208);
var inst_23210 = cljs.core.next(inst_23208);
var state_23373__$1 = (function (){var statearr_23506 = state_23373;
(statearr_23506[(46)] = inst_23210);

(statearr_23506[(40)] = inst_23209__$1);

return statearr_23506;
})();
if(cljs.core.truth_(inst_23209__$1)){
var statearr_23507_23697 = state_23373__$1;
(statearr_23507_23697[(1)] = (99));

} else {
var statearr_23508_23698 = state_23373__$1;
(statearr_23508_23698[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (19))){
var inst_22979 = (state_23373[(41)]);
var inst_22975 = (state_23373[(15)]);
var inst_22979__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22975);
var state_23373__$1 = (function (){var statearr_23509 = state_23373;
(statearr_23509[(41)] = inst_22979__$1);

return statearr_23509;
})();
if(cljs.core.truth_(inst_22979__$1)){
var statearr_23510_23699 = state_23373__$1;
(statearr_23510_23699[(1)] = (21));

} else {
var statearr_23511_23700 = state_23373__$1;
(statearr_23511_23700[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (57))){
var inst_22975 = (state_23373[(15)]);
var inst_23055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23056 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_23057 = (new cljs.core.PersistentVector(null,3,(5),inst_23055,inst_23056,null));
var inst_23058 = cljs.core.select_keys(inst_22975,inst_23057);
var inst_23059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23067 = flakes;
var inst_23068 = cljs.core.seq(inst_23067);
var inst_23069 = cljs.core.first(inst_23068);
var inst_23070 = cljs.core.next(inst_23068);
var inst_23071 = cljs.core.PersistentVector.EMPTY;
var inst_23072 = inst_23067;
var inst_23073 = inst_23071;
var state_23373__$1 = (function (){var statearr_23512 = state_23373;
(statearr_23512[(57)] = inst_23069);

(statearr_23512[(58)] = inst_23070);

(statearr_23512[(24)] = inst_23072);

(statearr_23512[(51)] = inst_23059);

(statearr_23512[(53)] = inst_23058);

(statearr_23512[(9)] = inst_23073);

return statearr_23512;
})();
var statearr_23513_23701 = state_23373__$1;
(statearr_23513_23701[(2)] = null);

(statearr_23513_23701[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (68))){
var inst_23098 = (state_23373[(2)]);
var state_23373__$1 = (function (){var statearr_23514 = state_23373;
(statearr_23514[(22)] = inst_23098);

return statearr_23514;
})();
if(cljs.core.truth_(fuel)){
var statearr_23515_23702 = state_23373__$1;
(statearr_23515_23702[(1)] = (70));

} else {
var statearr_23516_23703 = state_23373__$1;
(statearr_23516_23703[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (11))){
var inst_22960 = (state_23373[(42)]);
var inst_22960__$1 = (state_23373[(2)]);
var inst_22962 = cljs.core.contains_QMARK_(inst_22960__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22963 = (!(inst_22962));
var state_23373__$1 = (function (){var statearr_23517 = state_23373;
(statearr_23517[(42)] = inst_22960__$1);

return statearr_23517;
})();
if(inst_22963){
var statearr_23518_23704 = state_23373__$1;
(statearr_23518_23704[(1)] = (12));

} else {
var statearr_23519_23705 = state_23373__$1;
(statearr_23519_23705[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (115))){
var inst_23319 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23521_23706 = state_23373__$1;
(statearr_23521_23706[(2)] = inst_23319);

(statearr_23521_23706[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (9))){
var inst_22954 = cljs.core.first(flakes);
var inst_22955 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22954);
var inst_22956 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22957 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_22955,inst_22956);
var state_23373__$1 = state_23373;
var statearr_23522_23707 = state_23373__$1;
(statearr_23522_23707[(2)] = inst_22957);

(statearr_23522_23707[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (5))){
var _ = (function (){var statearr_23523 = state_23373;
(statearr_23523[(4)] = cljs.core.rest((state_23373[(4)])));

return statearr_23523;
})();
var state_23373__$1 = state_23373;
var ex23520 = (state_23373__$1[(2)]);
var statearr_23524_23708 = state_23373__$1;
(statearr_23524_23708[(5)] = ex23520);


if((ex23520 instanceof Error)){
var statearr_23525_23709 = state_23373__$1;
(statearr_23525_23709[(1)] = (4));

(statearr_23525_23709[(5)] = null);

} else {
throw ex23520;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (112))){
var inst_23331 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23526_23710 = state_23373__$1;
(statearr_23526_23710[(2)] = inst_23331);

(statearr_23526_23710[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (83))){
var inst_23176 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23527_23711 = state_23373__$1;
(statearr_23527_23711[(2)] = inst_23176);

(statearr_23527_23711[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (14))){
var inst_22960 = (state_23373[(42)]);
var inst_22968 = (state_23373[(2)]);
var inst_22969 = cljs.core.contains_QMARK_(inst_22960,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22970 = (!(inst_22969));
var state_23373__$1 = (function (){var statearr_23528 = state_23373;
(statearr_23528[(36)] = inst_22968);

return statearr_23528;
})();
if(inst_22970){
var statearr_23529_23712 = state_23373__$1;
(statearr_23529_23712[(1)] = (15));

} else {
var statearr_23530_23713 = state_23373__$1;
(statearr_23530_23713[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (45))){
var inst_22986 = (state_23373[(18)]);
var inst_22990 = (state_23373[(19)]);
var inst_23026 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_22986);
var inst_23027 = cljs.core.count(inst_23026);
var inst_23028 = (inst_23027 >= inst_22990);
var state_23373__$1 = state_23373;
var statearr_23531_23714 = state_23373__$1;
(statearr_23531_23714[(2)] = inst_23028);

(statearr_23531_23714[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (53))){
var inst_23053 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_23053)){
var statearr_23532_23715 = state_23373__$1;
(statearr_23532_23715[(1)] = (57));

} else {
var statearr_23533_23716 = state_23373__$1;
(statearr_23533_23716[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (78))){
var inst_23335 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23534_23717 = state_23373__$1;
(statearr_23534_23717[(2)] = inst_23335);

(statearr_23534_23717[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (132))){
var state_23373__$1 = state_23373;
var statearr_23536_23718 = state_23373__$1;
(statearr_23536_23718[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (26))){
var inst_23008 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_23008)){
var statearr_23538_23719 = state_23373__$1;
(statearr_23538_23719[(1)] = (33));

} else {
var statearr_23539_23720 = state_23373__$1;
(statearr_23539_23720[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (123))){
var inst_23288 = (state_23373[(39)]);
var inst_23281 = (state_23373[(33)]);
var tmp23535 = inst_23281;
var inst_23280 = inst_23288;
var inst_23281__$1 = tmp23535;
var state_23373__$1 = (function (){var statearr_23540 = state_23373;
(statearr_23540[(33)] = inst_23281__$1);

(statearr_23540[(37)] = inst_23280);

return statearr_23540;
})();
var statearr_23541_23721 = state_23373__$1;
(statearr_23541_23721[(2)] = null);

(statearr_23541_23721[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (16))){
var inst_22968 = (state_23373[(36)]);
var state_23373__$1 = state_23373;
var statearr_23542_23722 = state_23373__$1;
(statearr_23542_23722[(2)] = inst_22968);

(statearr_23542_23722[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (133))){
var inst_23366 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23543_23723 = state_23373__$1;
(statearr_23543_23723[(2)] = inst_23366);

(statearr_23543_23723[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (81))){
var inst_23142 = (state_23373[(28)]);
var inst_23151 = (state_23373[(59)]);
var inst_22975 = (state_23373[(15)]);
var inst_23145 = cljs.core.deref(cache);
var inst_23146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23147 = inst_23142.o;
var inst_23148 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22975);
var inst_23149 = [inst_23147,inst_23148];
var inst_23150 = (new cljs.core.PersistentVector(null,2,(5),inst_23146,inst_23149,null));
var inst_23151__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23145,inst_23150);
var state_23373__$1 = (function (){var statearr_23544 = state_23373;
(statearr_23544[(59)] = inst_23151__$1);

return statearr_23544;
})();
if(cljs.core.truth_(inst_23151__$1)){
var statearr_23545_23724 = state_23373__$1;
(statearr_23545_23724[(1)] = (84));

} else {
var statearr_23546_23725 = state_23373__$1;
(statearr_23546_23725[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (120))){
var inst_23315 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23547_23726 = state_23373__$1;
(statearr_23547_23726[(2)] = inst_23315);

(statearr_23547_23726[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (79))){
var inst_23142 = (state_23373[(28)]);
var inst_23135 = (state_23373[(45)]);
var inst_23141 = cljs.core.seq(inst_23135);
var inst_23142__$1 = cljs.core.first(inst_23141);
var inst_23143 = cljs.core.next(inst_23141);
var state_23373__$1 = (function (){var statearr_23548 = state_23373;
(statearr_23548[(28)] = inst_23142__$1);

(statearr_23548[(44)] = inst_23143);

return statearr_23548;
})();
if(cljs.core.truth_(inst_23142__$1)){
var statearr_23549_23727 = state_23373__$1;
(statearr_23549_23727[(1)] = (81));

} else {
var statearr_23550_23728 = state_23373__$1;
(statearr_23550_23728[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (38))){
var inst_23010 = (state_23373[(43)]);
var inst_23018 = (state_23373[(2)]);
var inst_23019 = [null,inst_23018];
var inst_23020 = (new cljs.core.PersistentVector(null,2,(5),inst_23010,inst_23019,null));
var state_23373__$1 = state_23373;
var statearr_23551_23729 = state_23373__$1;
(statearr_23551_23729[(2)] = inst_23020);

(statearr_23551_23729[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (126))){
var state_23373__$1 = state_23373;
var statearr_23552_23730 = state_23373__$1;
(statearr_23552_23730[(2)] = null);

(statearr_23552_23730[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (98))){
var inst_23189 = (state_23373[(60)]);
var inst_23253 = (state_23373[(2)]);
var inst_23254 = [inst_23253,offset_map];
var inst_23255 = (new cljs.core.PersistentVector(null,2,(5),inst_23189,inst_23254,null));
var state_23373__$1 = state_23373;
var statearr_23553_23731 = state_23373__$1;
(statearr_23553_23731[(2)] = inst_23255);

(statearr_23553_23731[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (124))){
var inst_23309 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23554_23732 = state_23373__$1;
(statearr_23554_23732[(2)] = inst_23309);

(statearr_23554_23732[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (87))){
var inst_23142 = (state_23373[(28)]);
var inst_22975 = (state_23373[(15)]);
var inst_23158 = (state_23373[(2)]);
var inst_23159 = fluree.db.util.async.throw_err(inst_23158);
var inst_23160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23161 = inst_23142.o;
var inst_23162 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22975);
var inst_23163 = [inst_23161,inst_23162];
var inst_23164 = (new cljs.core.PersistentVector(null,2,(5),inst_23160,inst_23163,null));
var inst_23165 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_23164,inst_23159);
var state_23373__$1 = (function (){var statearr_23555 = state_23373;
(statearr_23555[(61)] = inst_23165);

return statearr_23555;
})();
var statearr_23556_23733 = state_23373__$1;
(statearr_23556_23733[(2)] = inst_23159);

(statearr_23556_23733[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (30))){
var inst_22993 = (state_23373[(20)]);
var inst_22998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22993);
var inst_22999 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22998);
var state_23373__$1 = state_23373;
var statearr_23557_23734 = state_23373__$1;
(statearr_23557_23734[(2)] = inst_22999);

(statearr_23557_23734[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (73))){
var inst_23098 = (state_23373[(22)]);
var inst_23073 = (state_23373[(9)]);
var inst_23107 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23073,inst_23098);
var state_23373__$1 = state_23373;
var statearr_23558_23735 = state_23373__$1;
(statearr_23558_23735[(2)] = inst_23107);

(statearr_23558_23735[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (96))){
var inst_23333 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
var statearr_23559_23736 = state_23373__$1;
(statearr_23559_23736[(2)] = inst_23333);

(statearr_23559_23736[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (10))){
var state_23373__$1 = state_23373;
var statearr_23560_23737 = state_23373__$1;
(statearr_23560_23737[(2)] = pred_spec);

(statearr_23560_23737[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (18))){
var inst_22976 = (state_23373[(52)]);
var state_23373__$1 = state_23373;
var statearr_23561_23738 = state_23373__$1;
(statearr_23561_23738[(2)] = inst_22976);

(statearr_23561_23738[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (105))){
var inst_23241 = (state_23373[(2)]);
var state_23373__$1 = (function (){var statearr_23562 = state_23373;
(statearr_23562[(47)] = inst_23241);

return statearr_23562;
})();
if(cljs.core.truth_(fuel)){
var statearr_23563_23739 = state_23373__$1;
(statearr_23563_23739[(1)] = (107));

} else {
var statearr_23564_23740 = state_23373__$1;
(statearr_23564_23740[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (52))){
var inst_23043 = (state_23373[(62)]);
var state_23373__$1 = state_23373;
var statearr_23565_23741 = state_23373__$1;
(statearr_23565_23741[(2)] = inst_23043);

(statearr_23565_23741[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (114))){
var inst_23275 = flakes;
var inst_23276 = cljs.core.seq(inst_23275);
var inst_23277 = cljs.core.first(inst_23276);
var inst_23278 = cljs.core.next(inst_23276);
var inst_23279 = cljs.core.PersistentVector.EMPTY;
var inst_23280 = inst_23275;
var inst_23281 = inst_23279;
var state_23373__$1 = (function (){var statearr_23566 = state_23373;
(statearr_23566[(63)] = inst_23277);

(statearr_23566[(33)] = inst_23281);

(statearr_23566[(37)] = inst_23280);

(statearr_23566[(64)] = inst_23278);

return statearr_23566;
})();
var statearr_23567_23742 = state_23373__$1;
(statearr_23567_23742[(2)] = null);

(statearr_23567_23742[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (67))){
var state_23373__$1 = state_23373;
var statearr_23568_23743 = state_23373__$1;
(statearr_23568_23743[(2)] = null);

(statearr_23568_23743[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (71))){
var state_23373__$1 = state_23373;
var statearr_23569_23744 = state_23373__$1;
(statearr_23569_23744[(2)] = null);

(statearr_23569_23744[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (42))){
var inst_22990 = (state_23373[(19)]);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_22990)){
var statearr_23570_23745 = state_23373__$1;
(statearr_23570_23745[(1)] = (45));

} else {
var statearr_23571_23746 = state_23373__$1;
(statearr_23571_23746[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (80))){
var inst_23122 = (state_23373[(55)]);
var inst_23178 = (state_23373[(2)]);
var inst_23179 = [inst_23178,offset_map];
var inst_23180 = (new cljs.core.PersistentVector(null,2,(5),inst_23122,inst_23179,null));
var state_23373__$1 = state_23373;
var statearr_23572_23747 = state_23373__$1;
(statearr_23572_23747[(2)] = inst_23180);

(statearr_23572_23747[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (37))){
var inst_22992 = (state_23373[(16)]);
var inst_22993 = (state_23373[(20)]);
var inst_23015 = (inst_22992 - (1));
var inst_23016 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22993,inst_23015);
var state_23373__$1 = state_23373;
var statearr_23573_23748 = state_23373__$1;
(statearr_23573_23748[(2)] = inst_23016);

(statearr_23573_23748[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (63))){
var inst_23073 = (state_23373[(9)]);
var state_23373__$1 = state_23373;
var statearr_23574_23749 = state_23373__$1;
(statearr_23574_23749[(2)] = inst_23073);

(statearr_23574_23749[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (94))){
var inst_23189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23197 = flakes;
var inst_23198 = cljs.core.seq(inst_23197);
var inst_23199 = cljs.core.first(inst_23198);
var inst_23200 = cljs.core.next(inst_23198);
var inst_23201 = cljs.core.PersistentVector.EMPTY;
var inst_23202 = inst_23197;
var inst_23203 = inst_23201;
var state_23373__$1 = (function (){var statearr_23575 = state_23373;
(statearr_23575[(65)] = inst_23200);

(statearr_23575[(60)] = inst_23189);

(statearr_23575[(48)] = inst_23202);

(statearr_23575[(66)] = inst_23199);

(statearr_23575[(32)] = inst_23203);

return statearr_23575;
})();
var statearr_23576_23750 = state_23373__$1;
(statearr_23576_23750[(2)] = null);

(statearr_23576_23750[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (8))){
var inst_22952 = (state_23373[(2)]);
var state_23373__$1 = state_23373;
if(cljs.core.truth_(inst_22952)){
var statearr_23577_23751 = state_23373__$1;
(statearr_23577_23751[(1)] = (9));

} else {
var statearr_23578_23752 = state_23373__$1;
(statearr_23578_23752[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (49))){
var inst_23043 = (state_23373[(62)]);
var inst_23043__$1 = cljs.core.not(recur_QMARK_);
var state_23373__$1 = (function (){var statearr_23579 = state_23373;
(statearr_23579[(62)] = inst_23043__$1);

return statearr_23579;
})();
if(inst_23043__$1){
var statearr_23580_23753 = state_23373__$1;
(statearr_23580_23753[(1)] = (51));

} else {
var statearr_23581_23754 = state_23373__$1;
(statearr_23581_23754[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23374 === (84))){
var inst_23151 = (state_23373[(59)]);
var state_23373__$1 = state_23373;
var statearr_23582_23755 = state_23373__$1;
(statearr_23582_23755[(2)] = inst_23151);

(statearr_23582_23755[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2684__auto__ = null;
var fluree$db$query$fql$state_machine__2684__auto____0 = (function (){
var statearr_23583 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23583[(0)] = fluree$db$query$fql$state_machine__2684__auto__);

(statearr_23583[(1)] = (1));

return statearr_23583;
});
var fluree$db$query$fql$state_machine__2684__auto____1 = (function (state_23373){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23373);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23584){var ex__2687__auto__ = e23584;
var statearr_23585_23756 = state_23373;
(statearr_23585_23756[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23373[(4)]))){
var statearr_23586_23757 = state_23373;
(statearr_23586_23757[(1)] = cljs.core.first((state_23373[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23758 = state_23373;
state_23373 = G__23758;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2684__auto__ = function(state_23373){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2684__auto____1.call(this,state_23373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2684__auto____0;
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2684__auto____1;
return fluree$db$query$fql$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23587 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23587[(6)] = c__2706__auto__);

return statearr_23587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23918){
var state_val_23919 = (state_23918[(1)]);
if((state_val_23919 === (7))){
var inst_23913 = (state_23918[(2)]);
var _ = (function (){var statearr_23920 = state_23918;
(statearr_23920[(4)] = cljs.core.rest((state_23918[(4)])));

return statearr_23920;
})();
var state_23918__$1 = state_23918;
var statearr_23921_24003 = state_23918__$1;
(statearr_23921_24003[(2)] = inst_23913);

(statearr_23921_24003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (20))){
var inst_23840 = (state_23918[(7)]);
var state_23918__$1 = state_23918;
var statearr_23922_24004 = state_23918__$1;
(statearr_23922_24004[(2)] = inst_23840);

(statearr_23922_24004[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (27))){
var inst_23795 = (state_23918[(8)]);
var state_23918__$1 = state_23918;
if(cljs.core.truth_(inst_23795)){
var statearr_23923_24005 = state_23918__$1;
(statearr_23923_24005[(1)] = (29));

} else {
var statearr_23924_24006 = state_23918__$1;
(statearr_23924_24006[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (1))){
var state_23918__$1 = state_23918;
var statearr_23925_24007 = state_23918__$1;
(statearr_23925_24007[(2)] = null);

(statearr_23925_24007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (24))){
var inst_23796 = (state_23918[(9)]);
var state_23918__$1 = state_23918;
var statearr_23926_24008 = state_23918__$1;
(statearr_23926_24008[(2)] = inst_23796);

(statearr_23926_24008[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (39))){
var inst_23832 = (state_23918[(10)]);
var state_23918__$1 = state_23918;
var statearr_23927_24009 = state_23918__$1;
(statearr_23927_24009[(2)] = inst_23832);

(statearr_23927_24009[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (46))){
var inst_23797 = (state_23918[(11)]);
var state_23918__$1 = state_23918;
var statearr_23928_24010 = state_23918__$1;
(statearr_23928_24010[(2)] = inst_23797);

(statearr_23928_24010[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (4))){
var inst_23759 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23929_24011 = state_23918__$1;
(statearr_23929_24011[(2)] = inst_23759);

(statearr_23929_24011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (15))){
var inst_23808 = (state_23918[(12)]);
var inst_23814 = cljs.core.count(inst_23808);
var inst_23815 = fluree.db.query.fql.add_fuel(fuel,inst_23814,max_fuel);
var state_23918__$1 = state_23918;
var statearr_23930_24012 = state_23918__$1;
(statearr_23930_24012[(2)] = inst_23815);

(statearr_23930_24012[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (48))){
var inst_23899 = (state_23918[(13)]);
var inst_23784 = (state_23918[(14)]);
var inst_23777 = (state_23918[(15)]);
var inst_23907 = (state_23918[(2)]);
var inst_23908 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23777,inst_23907,inst_23899);
var inst_23776 = inst_23784;
var inst_23777__$1 = inst_23908;
var state_23918__$1 = (function (){var statearr_23931 = state_23918;
(statearr_23931[(15)] = inst_23777__$1);

(statearr_23931[(16)] = inst_23776);

return statearr_23931;
})();
var statearr_23932_24013 = state_23918__$1;
(statearr_23932_24013[(2)] = null);

(statearr_23932_24013[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (50))){
var inst_23799 = (state_23918[(17)]);
var state_23918__$1 = state_23918;
var statearr_23933_24014 = state_23918__$1;
(statearr_23933_24014[(2)] = inst_23799);

(statearr_23933_24014[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (21))){
var inst_23796 = (state_23918[(9)]);
var state_23918__$1 = state_23918;
if(cljs.core.truth_(inst_23796)){
var statearr_23935_24015 = state_23918__$1;
(statearr_23935_24015[(1)] = (23));

} else {
var statearr_23936_24016 = state_23918__$1;
(statearr_23936_24016[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (31))){
var inst_23856 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
if(cljs.core.truth_(inst_23856)){
var statearr_23937_24017 = state_23918__$1;
(statearr_23937_24017[(1)] = (32));

} else {
var statearr_23938_24018 = state_23918__$1;
(statearr_23938_24018[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (32))){
var inst_23839 = (state_23918[(18)]);
var inst_23832 = (state_23918[(10)]);
var inst_23831 = (state_23918[(19)]);
var inst_23858 = (inst_23831 + (1));
var tmp23934 = inst_23832;
var inst_23830 = inst_23839;
var inst_23831__$1 = inst_23858;
var inst_23832__$1 = tmp23934;
var state_23918__$1 = (function (){var statearr_23939 = state_23918;
(statearr_23939[(10)] = inst_23832__$1);

(statearr_23939[(20)] = inst_23830);

(statearr_23939[(19)] = inst_23831__$1);

return statearr_23939;
})();
var statearr_23940_24019 = state_23918__$1;
(statearr_23940_24019[(2)] = null);

(statearr_23940_24019[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (40))){
var state_23918__$1 = state_23918;
if(cljs.core.truth_(fuel)){
var statearr_23941_24020 = state_23918__$1;
(statearr_23941_24020[(1)] = (42));

} else {
var statearr_23942_24021 = state_23918__$1;
(statearr_23942_24021[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (33))){
var state_23918__$1 = state_23918;
var statearr_23943_24022 = state_23918__$1;
(statearr_23943_24022[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (13))){
var inst_23808 = (state_23918[(12)]);
var state_23918__$1 = state_23918;
var statearr_23945_24023 = state_23918__$1;
(statearr_23945_24023[(2)] = inst_23808);

(statearr_23945_24023[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (22))){
var inst_23849 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
if(cljs.core.truth_(inst_23849)){
var statearr_23946_24024 = state_23918__$1;
(statearr_23946_24024[(1)] = (26));

} else {
var statearr_23947_24025 = state_23918__$1;
(statearr_23947_24025[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (36))){
var state_23918__$1 = state_23918;
var statearr_23948_24026 = state_23918__$1;
(statearr_23948_24026[(2)] = null);

(statearr_23948_24026[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (41))){
var inst_23839 = (state_23918[(18)]);
var inst_23831 = (state_23918[(19)]);
var inst_23888 = (state_23918[(2)]);
var inst_23889 = (inst_23831 + (1));
var inst_23830 = inst_23839;
var inst_23831__$1 = inst_23889;
var inst_23832 = inst_23888;
var state_23918__$1 = (function (){var statearr_23949 = state_23918;
(statearr_23949[(10)] = inst_23832);

(statearr_23949[(20)] = inst_23830);

(statearr_23949[(19)] = inst_23831__$1);

return statearr_23949;
})();
var statearr_23950_24027 = state_23918__$1;
(statearr_23950_24027[(2)] = null);

(statearr_23950_24027[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (43))){
var state_23918__$1 = state_23918;
var statearr_23951_24028 = state_23918__$1;
(statearr_23951_24028[(2)] = null);

(statearr_23951_24028[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (29))){
var inst_23795 = (state_23918[(8)]);
var inst_23831 = (state_23918[(19)]);
var inst_23853 = (inst_23831 < inst_23795);
var state_23918__$1 = state_23918;
var statearr_23952_24029 = state_23918__$1;
(statearr_23952_24029[(2)] = inst_23853);

(statearr_23952_24029[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (44))){
var inst_23868 = (state_23918[(21)]);
var inst_23872 = (state_23918[(22)]);
var inst_23881 = (state_23918[(2)]);
var inst_23882 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23872,inst_23868) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23872,inst_23868));
var state_23918__$1 = (function (){var statearr_23953 = state_23918;
(statearr_23953[(23)] = inst_23881);

return statearr_23953;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23918__$1,(45),inst_23882);
} else {
if((state_val_23919 === (6))){
var inst_23783 = (state_23918[(24)]);
var inst_23776 = (state_23918[(16)]);
var inst_23782 = cljs.core.seq(inst_23776);
var inst_23783__$1 = cljs.core.first(inst_23782);
var inst_23784 = cljs.core.next(inst_23782);
var inst_23785 = cljs.core.not(inst_23783__$1);
var state_23918__$1 = (function (){var statearr_23954 = state_23918;
(statearr_23954[(14)] = inst_23784);

(statearr_23954[(24)] = inst_23783__$1);

return statearr_23954;
})();
if(inst_23785){
var statearr_23955_24030 = state_23918__$1;
(statearr_23955_24030[(1)] = (8));

} else {
var statearr_23956_24031 = state_23918__$1;
(statearr_23956_24031[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (28))){
var inst_23897 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23957_24032 = state_23918__$1;
(statearr_23957_24032[(2)] = inst_23897);

(statearr_23957_24032[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (51))){
var inst_23905 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23958_24033 = state_23918__$1;
(statearr_23958_24033[(2)] = inst_23905);

(statearr_23958_24033[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (25))){
var inst_23847 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23959_24034 = state_23918__$1;
(statearr_23959_24034[(2)] = inst_23847);

(statearr_23959_24034[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (34))){
var inst_23895 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23960_24035 = state_23918__$1;
(statearr_23960_24035[(2)] = inst_23895);

(statearr_23960_24035[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (17))){
var inst_23808 = (state_23918[(12)]);
var inst_23818 = (state_23918[(2)]);
var inst_23826 = cljs.core.seq(inst_23808);
var inst_23827 = cljs.core.first(inst_23826);
var inst_23828 = cljs.core.next(inst_23826);
var inst_23829 = cljs.core.PersistentVector.EMPTY;
var inst_23830 = inst_23808;
var inst_23831 = (0);
var inst_23832 = inst_23829;
var state_23918__$1 = (function (){var statearr_23961 = state_23918;
(statearr_23961[(25)] = inst_23827);

(statearr_23961[(10)] = inst_23832);

(statearr_23961[(26)] = inst_23818);

(statearr_23961[(20)] = inst_23830);

(statearr_23961[(27)] = inst_23828);

(statearr_23961[(19)] = inst_23831);

return statearr_23961;
})();
var statearr_23962_24036 = state_23918__$1;
(statearr_23962_24036[(2)] = null);

(statearr_23962_24036[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (3))){
var inst_23916 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23918__$1,inst_23916);
} else {
if((state_val_23919 === (12))){
var state_23918__$1 = state_23918;
var statearr_23963_24037 = state_23918__$1;
(statearr_23963_24037[(2)] = fuel);

(statearr_23963_24037[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (2))){
var _ = (function (){var statearr_23964 = state_23918;
(statearr_23964[(4)] = cljs.core.cons((5),(state_23918[(4)])));

return statearr_23964;
})();
var inst_23772 = reverse_refs_specs;
var inst_23773 = cljs.core.seq(inst_23772);
var inst_23774 = cljs.core.first(inst_23773);
var inst_23775 = cljs.core.next(inst_23773);
var inst_23776 = inst_23772;
var inst_23777 = null;
var state_23918__$1 = (function (){var statearr_23965 = state_23918;
(statearr_23965[(28)] = inst_23775);

(statearr_23965[(15)] = inst_23777);

(statearr_23965[(29)] = inst_23774);

(statearr_23965[(16)] = inst_23776);

return statearr_23965;
})();
var statearr_23966_24038 = state_23918__$1;
(statearr_23966_24038[(2)] = null);

(statearr_23966_24038[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (23))){
var inst_23796 = (state_23918[(9)]);
var inst_23831 = (state_23918[(19)]);
var inst_23844 = (inst_23831 >= inst_23796);
var state_23918__$1 = state_23918;
var statearr_23967_24039 = state_23918__$1;
(statearr_23967_24039[(2)] = inst_23844);

(statearr_23967_24039[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (47))){
var inst_23798 = (state_23918[(30)]);
var state_23918__$1 = state_23918;
if(cljs.core.truth_(inst_23798)){
var statearr_23968_24040 = state_23918__$1;
(statearr_23968_24040[(1)] = (49));

} else {
var statearr_23969_24041 = state_23918__$1;
(statearr_23969_24041[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (35))){
var inst_23838 = (state_23918[(31)]);
var inst_23862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23863 = [inst_23838];
var inst_23864 = (new cljs.core.PersistentVector(null,1,(5),inst_23862,inst_23863,null));
var inst_23865 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23864);
var state_23918__$1 = state_23918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23918__$1,(38),inst_23865);
} else {
if((state_val_23919 === (19))){
var inst_23797 = (state_23918[(11)]);
var inst_23899 = (state_23918[(2)]);
var state_23918__$1 = (function (){var statearr_23970 = state_23918;
(statearr_23970[(13)] = inst_23899);

return statearr_23970;
})();
if(cljs.core.truth_(inst_23797)){
var statearr_23971_24042 = state_23918__$1;
(statearr_23971_24042[(1)] = (46));

} else {
var statearr_23972_24043 = state_23918__$1;
(statearr_23972_24043[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (11))){
var inst_23808 = (state_23918[(12)]);
var inst_23805 = (state_23918[(2)]);
var inst_23806 = fluree.db.util.async.throw_err(inst_23805);
var inst_23807 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_23806);
var inst_23808__$1 = cljs.core.not_empty(inst_23807);
var state_23918__$1 = (function (){var statearr_23974 = state_23918;
(statearr_23974[(12)] = inst_23808__$1);

return statearr_23974;
})();
if(cljs.core.truth_(inst_23808__$1)){
var statearr_23975_24044 = state_23918__$1;
(statearr_23975_24044[(1)] = (12));

} else {
var statearr_23976_24045 = state_23918__$1;
(statearr_23976_24045[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (9))){
var inst_23783 = (state_23918[(24)]);
var inst_23793 = (state_23918[(32)]);
var inst_23792 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23783,(0),null);
var inst_23793__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23783,(1),null);
var inst_23794 = cljs.core.__destructure_map(inst_23793__$1);
var inst_23795 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23794,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_23796 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23794,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23797 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23794,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23798 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23794,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_23799 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23794,new cljs.core.Keyword(null,"p","p",151049309));
var inst_23800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23801 = [subject_id,inst_23792];
var inst_23802 = (new cljs.core.PersistentVector(null,2,(5),inst_23800,inst_23801,null));
var inst_23803 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_23802);
var state_23918__$1 = (function (){var statearr_23977 = state_23918;
(statearr_23977[(17)] = inst_23799);

(statearr_23977[(8)] = inst_23795);

(statearr_23977[(30)] = inst_23798);

(statearr_23977[(11)] = inst_23797);

(statearr_23977[(32)] = inst_23793__$1);

(statearr_23977[(9)] = inst_23796);

return statearr_23977;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23918__$1,(11),inst_23803);
} else {
if((state_val_23919 === (5))){
var _ = (function (){var statearr_23978 = state_23918;
(statearr_23978[(4)] = cljs.core.rest((state_23918[(4)])));

return statearr_23978;
})();
var state_23918__$1 = state_23918;
var ex23973 = (state_23918__$1[(2)]);
var statearr_23979_24046 = state_23918__$1;
(statearr_23979_24046[(5)] = ex23973);


if((ex23973 instanceof Error)){
var statearr_23980_24047 = state_23918__$1;
(statearr_23980_24047[(1)] = (4));

(statearr_23980_24047[(5)] = null);

} else {
throw ex23973;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (14))){
var inst_23812 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
if(cljs.core.truth_(inst_23812)){
var statearr_23981_24048 = state_23918__$1;
(statearr_23981_24048[(1)] = (15));

} else {
var statearr_23982_24049 = state_23918__$1;
(statearr_23982_24049[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (45))){
var inst_23832 = (state_23918[(10)]);
var inst_23884 = (state_23918[(2)]);
var inst_23885 = fluree.db.util.async.throw_err(inst_23884);
var inst_23886 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23832,inst_23885);
var state_23918__$1 = state_23918;
var statearr_23983_24050 = state_23918__$1;
(statearr_23983_24050[(2)] = inst_23886);

(statearr_23983_24050[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (26))){
var inst_23832 = (state_23918[(10)]);
var state_23918__$1 = state_23918;
var statearr_23984_24051 = state_23918__$1;
(statearr_23984_24051[(2)] = inst_23832);

(statearr_23984_24051[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (16))){
var state_23918__$1 = state_23918;
var statearr_23985_24052 = state_23918__$1;
(statearr_23985_24052[(2)] = null);

(statearr_23985_24052[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (38))){
var inst_23868 = (state_23918[(21)]);
var inst_23793 = (state_23918[(32)]);
var inst_23867 = (state_23918[(2)]);
var inst_23868__$1 = fluree.db.util.async.throw_err(inst_23867);
var inst_23869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23870 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23871 = (new cljs.core.PersistentVector(null,4,(5),inst_23869,inst_23870,null));
var inst_23872 = cljs.core.select_keys(inst_23793,inst_23871);
var inst_23873 = cljs.core.empty_QMARK_(inst_23868__$1);
var state_23918__$1 = (function (){var statearr_23986 = state_23918;
(statearr_23986[(21)] = inst_23868__$1);

(statearr_23986[(22)] = inst_23872);

return statearr_23986;
})();
if(inst_23873){
var statearr_23987_24053 = state_23918__$1;
(statearr_23987_24053[(1)] = (39));

} else {
var statearr_23988_24054 = state_23918__$1;
(statearr_23988_24054[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (30))){
var inst_23795 = (state_23918[(8)]);
var state_23918__$1 = state_23918;
var statearr_23989_24055 = state_23918__$1;
(statearr_23989_24055[(2)] = inst_23795);

(statearr_23989_24055[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (10))){
var inst_23911 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23990_24056 = state_23918__$1;
(statearr_23990_24056[(2)] = inst_23911);

(statearr_23990_24056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (18))){
var inst_23840 = (state_23918[(7)]);
var inst_23838 = (state_23918[(31)]);
var inst_23830 = (state_23918[(20)]);
var inst_23837 = cljs.core.seq(inst_23830);
var inst_23838__$1 = cljs.core.first(inst_23837);
var inst_23839 = cljs.core.next(inst_23837);
var inst_23840__$1 = cljs.core.not(inst_23838__$1);
var state_23918__$1 = (function (){var statearr_23991 = state_23918;
(statearr_23991[(18)] = inst_23839);

(statearr_23991[(7)] = inst_23840__$1);

(statearr_23991[(31)] = inst_23838__$1);

return statearr_23991;
})();
if(inst_23840__$1){
var statearr_23992_24057 = state_23918__$1;
(statearr_23992_24057[(1)] = (20));

} else {
var statearr_23993_24058 = state_23918__$1;
(statearr_23993_24058[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (42))){
var inst_23868 = (state_23918[(21)]);
var inst_23877 = cljs.core.count(inst_23868);
var inst_23878 = fluree.db.query.fql.add_fuel(fuel,inst_23877,max_fuel);
var state_23918__$1 = state_23918;
var statearr_23994_24059 = state_23918__$1;
(statearr_23994_24059[(2)] = inst_23878);

(statearr_23994_24059[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (37))){
var inst_23893 = (state_23918[(2)]);
var state_23918__$1 = state_23918;
var statearr_23995_24060 = state_23918__$1;
(statearr_23995_24060[(2)] = inst_23893);

(statearr_23995_24060[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (8))){
var inst_23777 = (state_23918[(15)]);
var state_23918__$1 = state_23918;
var statearr_23996_24061 = state_23918__$1;
(statearr_23996_24061[(2)] = inst_23777);

(statearr_23996_24061[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23919 === (49))){
var inst_23798 = (state_23918[(30)]);
var state_23918__$1 = state_23918;
var statearr_23997_24062 = state_23918__$1;
(statearr_23997_24062[(2)] = inst_23798);

(statearr_23997_24062[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto____0 = (function (){
var statearr_23998 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23998[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto__);

(statearr_23998[(1)] = (1));

return statearr_23998;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto____1 = (function (state_23918){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23918);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23999){var ex__2687__auto__ = e23999;
var statearr_24000_24063 = state_23918;
(statearr_24000_24063[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23918[(4)]))){
var statearr_24001_24064 = state_23918;
(statearr_24001_24064[(1)] = cljs.core.first((state_23918[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24065 = state_23918;
state_23918 = G__24065;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto__ = function(state_23918){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto____1.call(this,state_23918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24002 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24002[(6)] = c__2706__auto__);

return statearr_24002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__24066 = select_spec;
var map__24066__$1 = cljs.core.__destructure_map(map__24066);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24066__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24066__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24180){
var state_val_24181 = (state_24180[(1)]);
if((state_val_24181 === (7))){
var inst_24092 = flakes;
var inst_24093 = cljs.core.seq(inst_24092);
var inst_24094 = cljs.core.first(inst_24093);
var inst_24095 = cljs.core.next(inst_24093);
var inst_24096 = cljs.core.PersistentVector.EMPTY;
var inst_24097 = inst_24092;
var inst_24098 = (0);
var inst_24099 = inst_24096;
var state_24180__$1 = (function (){var statearr_24182 = state_24180;
(statearr_24182[(7)] = inst_24095);

(statearr_24182[(8)] = inst_24094);

(statearr_24182[(9)] = inst_24099);

(statearr_24182[(10)] = inst_24097);

(statearr_24182[(11)] = inst_24098);

return statearr_24182;
})();
var statearr_24183_24249 = state_24180__$1;
(statearr_24183_24249[(2)] = null);

(statearr_24183_24249[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (20))){
var state_24180__$1 = state_24180;
var statearr_24184_24250 = state_24180__$1;
(statearr_24184_24250[(2)] = results);

(statearr_24184_24250[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (27))){
var state_24180__$1 = state_24180;
var statearr_24185_24251 = state_24180__$1;
(statearr_24185_24251[(2)] = null);

(statearr_24185_24251[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (1))){
var state_24180__$1 = state_24180;
var statearr_24186_24252 = state_24180__$1;
(statearr_24186_24252[(2)] = null);

(statearr_24186_24252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (24))){
var state_24180__$1 = state_24180;
var statearr_24187_24253 = state_24180__$1;
(statearr_24187_24253[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (39))){
var inst_24099 = (state_24180[(9)]);
var inst_24161 = (state_24180[(12)]);
var inst_24106 = (state_24180[(13)]);
var inst_24164 = (state_24180[(2)]);
var inst_24165 = fluree.db.util.async.throw_err(inst_24164);
var inst_24166 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24099,inst_24165);
var inst_24097 = inst_24106;
var inst_24098 = inst_24161;
var inst_24099__$1 = inst_24166;
var state_24180__$1 = (function (){var statearr_24189 = state_24180;
(statearr_24189[(9)] = inst_24099__$1);

(statearr_24189[(10)] = inst_24097);

(statearr_24189[(11)] = inst_24098);

return statearr_24189;
})();
var statearr_24190_24254 = state_24180__$1;
(statearr_24190_24254[(2)] = null);

(statearr_24190_24254[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (4))){
var inst_24067 = (state_24180[(2)]);
var state_24180__$1 = state_24180;
var statearr_24191_24255 = state_24180__$1;
(statearr_24191_24255[(2)] = inst_24067);

(statearr_24191_24255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (15))){
var inst_24080 = (state_24180[(14)]);
var state_24180__$1 = state_24180;
var statearr_24192_24256 = state_24180__$1;
(statearr_24192_24256[(2)] = inst_24080);

(statearr_24192_24256[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (21))){
var inst_24076 = (state_24180[(15)]);
var state_24180__$1 = state_24180;
if(cljs.core.truth_(inst_24076)){
var statearr_24193_24257 = state_24180__$1;
(statearr_24193_24257[(1)] = (23));

} else {
var statearr_24194_24258 = state_24180__$1;
(statearr_24194_24258[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (31))){
var inst_24144 = (state_24180[(16)]);
var state_24180__$1 = state_24180;
var statearr_24195_24259 = state_24180__$1;
(statearr_24195_24259[(2)] = inst_24144);

(statearr_24195_24259[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (32))){
var inst_24136 = (state_24180[(17)]);
var inst_24150 = (state_24180[(2)]);
var state_24180__$1 = (function (){var statearr_24196 = state_24180;
(statearr_24196[(18)] = inst_24150);

return statearr_24196;
})();
if(cljs.core.truth_(inst_24136)){
var statearr_24197_24260 = state_24180__$1;
(statearr_24197_24260[(1)] = (33));

} else {
var statearr_24198_24261 = state_24180__$1;
(statearr_24198_24261[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (33))){
var inst_24136 = (state_24180[(17)]);
var state_24180__$1 = state_24180;
var statearr_24199_24262 = state_24180__$1;
(statearr_24199_24262[(2)] = inst_24136);

(statearr_24199_24262[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (13))){
var inst_24116 = (state_24180[(2)]);
var state_24180__$1 = state_24180;
if(cljs.core.truth_(inst_24116)){
var statearr_24201_24263 = state_24180__$1;
(statearr_24201_24263[(1)] = (17));

} else {
var statearr_24202_24264 = state_24180__$1;
(statearr_24202_24264[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (22))){
var inst_24133 = (state_24180[(2)]);
var state_24180__$1 = state_24180;
var statearr_24203_24265 = state_24180__$1;
(statearr_24203_24265[(2)] = inst_24133);

(statearr_24203_24265[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (36))){
var inst_24099 = (state_24180[(9)]);
var inst_24106 = (state_24180[(13)]);
var inst_24098 = (state_24180[(11)]);
var inst_24158 = (inst_24098 + (1));
var tmp24200 = inst_24099;
var inst_24097 = inst_24106;
var inst_24098__$1 = inst_24158;
var inst_24099__$1 = tmp24200;
var state_24180__$1 = (function (){var statearr_24204 = state_24180;
(statearr_24204[(9)] = inst_24099__$1);

(statearr_24204[(10)] = inst_24097);

(statearr_24204[(11)] = inst_24098__$1);

return statearr_24204;
})();
var statearr_24205_24266 = state_24180__$1;
(statearr_24205_24266[(2)] = null);

(statearr_24205_24266[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (29))){
var inst_24143 = (state_24180[(2)]);
var inst_24144 = fluree.db.util.async.throw_err(inst_24143);
var state_24180__$1 = (function (){var statearr_24206 = state_24180;
(statearr_24206[(16)] = inst_24144);

return statearr_24206;
})();
if(cljs.core.truth_(fuel)){
var statearr_24207_24267 = state_24180__$1;
(statearr_24207_24267[(1)] = (30));

} else {
var statearr_24208_24268 = state_24180__$1;
(statearr_24208_24268[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (6))){
var state_24180__$1 = state_24180;
var statearr_24209_24269 = state_24180__$1;
(statearr_24209_24269[(2)] = results);

(statearr_24209_24269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (28))){
var inst_24129 = (state_24180[(2)]);
var state_24180__$1 = state_24180;
var statearr_24210_24270 = state_24180__$1;
(statearr_24210_24270[(2)] = inst_24129);

(statearr_24210_24270[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (25))){
var inst_24131 = (state_24180[(2)]);
var state_24180__$1 = state_24180;
var statearr_24211_24271 = state_24180__$1;
(statearr_24211_24271[(2)] = inst_24131);

(statearr_24211_24271[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (34))){
var inst_24150 = (state_24180[(18)]);
var inst_24153 = cljs.core.empty_QMARK_(inst_24150);
var state_24180__$1 = state_24180;
var statearr_24212_24272 = state_24180__$1;
(statearr_24212_24272[(2)] = inst_24153);

(statearr_24212_24272[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (17))){
var inst_24099 = (state_24180[(9)]);
var inst_24118 = cljs.core.empty_QMARK_(inst_24099);
var state_24180__$1 = state_24180;
if(inst_24118){
var statearr_24213_24273 = state_24180__$1;
(statearr_24213_24273[(1)] = (20));

} else {
var statearr_24214_24274 = state_24180__$1;
(statearr_24214_24274[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (3))){
var inst_24178 = (state_24180[(2)]);
var state_24180__$1 = state_24180;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24180__$1,inst_24178);
} else {
if((state_val_24181 === (12))){
var inst_24080 = (state_24180[(14)]);
var state_24180__$1 = state_24180;
if(cljs.core.truth_(inst_24080)){
var statearr_24215_24275 = state_24180__$1;
(statearr_24215_24275[(1)] = (14));

} else {
var statearr_24216_24276 = state_24180__$1;
(statearr_24216_24276[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (2))){
var _ = (function (){var statearr_24217 = state_24180;
(statearr_24217[(4)] = cljs.core.cons((5),(state_24180[(4)])));

return statearr_24217;
})();
var inst_24074 = select_spec;
var inst_24075 = cljs.core.__destructure_map(inst_24074);
var inst_24076 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24075,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_24077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24075,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_24078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24075,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_24079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24075,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_24080 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24075,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_24081 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_24082 = (inst_24079 > inst_24081);
var state_24180__$1 = (function (){var statearr_24218 = state_24180;
(statearr_24218[(19)] = inst_24078);

(statearr_24218[(15)] = inst_24076);

(statearr_24218[(20)] = inst_24077);

(statearr_24218[(14)] = inst_24080);

return statearr_24218;
})();
if(cljs.core.truth_(inst_24082)){
var statearr_24219_24277 = state_24180__$1;
(statearr_24219_24277[(1)] = (6));

} else {
var statearr_24220_24278 = state_24180__$1;
(statearr_24220_24278[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (23))){
var inst_24099 = (state_24180[(9)]);
var inst_24077 = (state_24180[(20)]);
var inst_24122 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_24077,inst_24099);
var state_24180__$1 = state_24180;
var statearr_24221_24279 = state_24180__$1;
(statearr_24221_24279[(2)] = inst_24122);

(statearr_24221_24279[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (35))){
var inst_24105 = (state_24180[(21)]);
var inst_24155 = (state_24180[(2)]);
var inst_24156 = fluree.db.query.fql.recur_select_spec(select_spec,inst_24105);
var state_24180__$1 = (function (){var statearr_24222 = state_24180;
(statearr_24222[(22)] = inst_24156);

return statearr_24222;
})();
if(cljs.core.truth_(inst_24155)){
var statearr_24223_24280 = state_24180__$1;
(statearr_24223_24280[(1)] = (36));

} else {
var statearr_24224_24281 = state_24180__$1;
(statearr_24224_24281[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (19))){
var inst_24171 = (state_24180[(2)]);
var state_24180__$1 = state_24180;
var statearr_24225_24282 = state_24180__$1;
(statearr_24225_24282[(2)] = inst_24171);

(statearr_24225_24282[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (11))){
var inst_24107 = (state_24180[(23)]);
var state_24180__$1 = state_24180;
var statearr_24227_24283 = state_24180__$1;
(statearr_24227_24283[(2)] = inst_24107);

(statearr_24227_24283[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (9))){
var inst_24105 = (state_24180[(21)]);
var inst_24097 = (state_24180[(10)]);
var inst_24107 = (state_24180[(23)]);
var inst_24104 = cljs.core.seq(inst_24097);
var inst_24105__$1 = cljs.core.first(inst_24104);
var inst_24106 = cljs.core.next(inst_24104);
var inst_24107__$1 = cljs.core.not(inst_24105__$1);
var state_24180__$1 = (function (){var statearr_24228 = state_24180;
(statearr_24228[(21)] = inst_24105__$1);

(statearr_24228[(23)] = inst_24107__$1);

(statearr_24228[(13)] = inst_24106);

return statearr_24228;
})();
if(inst_24107__$1){
var statearr_24229_24284 = state_24180__$1;
(statearr_24229_24284[(1)] = (11));

} else {
var statearr_24230_24285 = state_24180__$1;
(statearr_24230_24285[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (5))){
var _ = (function (){var statearr_24231 = state_24180;
(statearr_24231[(4)] = cljs.core.rest((state_24180[(4)])));

return statearr_24231;
})();
var state_24180__$1 = state_24180;
var ex24226 = (state_24180__$1[(2)]);
var statearr_24232_24286 = state_24180__$1;
(statearr_24232_24286[(5)] = ex24226);


if((ex24226 instanceof Error)){
var statearr_24233_24287 = state_24180__$1;
(statearr_24233_24287[(1)] = (4));

(statearr_24233_24287[(5)] = null);

} else {
throw ex24226;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (14))){
var inst_24080 = (state_24180[(14)]);
var inst_24098 = (state_24180[(11)]);
var inst_24111 = (inst_24098 < inst_24080);
var state_24180__$1 = state_24180;
var statearr_24234_24288 = state_24180__$1;
(statearr_24234_24288[(2)] = inst_24111);

(statearr_24234_24288[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (26))){
var inst_24099 = (state_24180[(9)]);
var inst_24077 = (state_24180[(20)]);
var inst_24125 = cljs.core.first(inst_24099);
var inst_24126 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_24077,inst_24125);
var state_24180__$1 = state_24180;
var statearr_24235_24289 = state_24180__$1;
(statearr_24235_24289[(2)] = inst_24126);

(statearr_24235_24289[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (16))){
var inst_24114 = (state_24180[(2)]);
var state_24180__$1 = state_24180;
var statearr_24236_24290 = state_24180__$1;
(statearr_24236_24290[(2)] = inst_24114);

(statearr_24236_24290[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (38))){
var inst_24169 = (state_24180[(2)]);
var state_24180__$1 = state_24180;
var statearr_24237_24291 = state_24180__$1;
(statearr_24237_24291[(2)] = inst_24169);

(statearr_24237_24291[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (30))){
var inst_24144 = (state_24180[(16)]);
var inst_24146 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_24147 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_24146,inst_24144);
var state_24180__$1 = state_24180;
var statearr_24238_24292 = state_24180__$1;
(statearr_24238_24292[(2)] = inst_24147);

(statearr_24238_24292[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (10))){
var inst_24173 = (state_24180[(2)]);
var state_24180__$1 = state_24180;
var statearr_24239_24293 = state_24180__$1;
(statearr_24239_24293[(2)] = inst_24173);

(statearr_24239_24293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24181 === (18))){
var inst_24105 = (state_24180[(21)]);
var inst_24078 = (state_24180[(19)]);
var inst_24135 = inst_24105.o;
var inst_24136 = cljs.core.contains_QMARK_(inst_24078,inst_24135);
var inst_24138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24139 = [inst_24135];
var inst_24140 = (new cljs.core.PersistentVector(null,1,(5),inst_24138,inst_24139,null));
var inst_24141 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24140);
var state_24180__$1 = (function (){var statearr_24240 = state_24180;
(statearr_24240[(17)] = inst_24136);

return statearr_24240;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24180__$1,(29),inst_24141);
} else {
if((state_val_24181 === (37))){
var inst_24150 = (state_24180[(18)]);
var inst_24156 = (state_24180[(22)]);
var inst_24098 = (state_24180[(11)]);
var inst_24161 = (inst_24098 + (1));
var inst_24162 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_24156,inst_24150) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_24156,inst_24150));
var state_24180__$1 = (function (){var statearr_24241 = state_24180;
(statearr_24241[(12)] = inst_24161);

return statearr_24241;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24180__$1,(39),inst_24162);
} else {
if((state_val_24181 === (8))){
var inst_24175 = (state_24180[(2)]);
var _ = (function (){var statearr_24242 = state_24180;
(statearr_24242[(4)] = cljs.core.rest((state_24180[(4)])));

return statearr_24242;
})();
var state_24180__$1 = state_24180;
var statearr_24243_24294 = state_24180__$1;
(statearr_24243_24294[(2)] = inst_24175);

(statearr_24243_24294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto____0 = (function (){
var statearr_24244 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24244[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto__);

(statearr_24244[(1)] = (1));

return statearr_24244;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto____1 = (function (state_24180){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24180);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24245){var ex__2687__auto__ = e24245;
var statearr_24246_24295 = state_24180;
(statearr_24246_24295[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24180[(4)]))){
var statearr_24247_24296 = state_24180;
(statearr_24247_24296[(1)] = cljs.core.first((state_24180[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24297 = state_24180;
state_24180 = G__24297;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto__ = function(state_24180){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto____1.call(this,state_24180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24248 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24248[(6)] = c__2706__auto__);

return statearr_24248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24478){
var state_val_24479 = (state_24478[(1)]);
if((state_val_24479 === (7))){
var state_24478__$1 = state_24478;
var statearr_24480_24566 = state_24478__$1;
(statearr_24480_24566[(2)] = null);

(statearr_24480_24566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (20))){
var inst_24336 = cljs.core.PersistentHashMap.EMPTY;
var state_24478__$1 = state_24478;
var statearr_24481_24567 = state_24478__$1;
(statearr_24481_24567[(2)] = inst_24336);

(statearr_24481_24567[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (27))){
var inst_24318 = (state_24478[(7)]);
var inst_24324 = (state_24478[(8)]);
var inst_24354 = (state_24478[(9)]);
var inst_24338 = (state_24478[(10)]);
var inst_24457 = (state_24478[(2)]);
var inst_24458 = (function (){var top_level_subject = inst_24318;
var select_spec = inst_24324;
var base_acc = inst_24338;
var acc_PLUS_refs = inst_24354;
var result = inst_24457;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_24459 = cljs.core.PersistentVector.EMPTY;
var inst_24460 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24324);
var inst_24461 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_24460);
var inst_24462 = cljs.core.vals(inst_24461);
var inst_24463 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24324);
var inst_24464 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_24463);
var inst_24465 = cljs.core.vals(inst_24464);
var inst_24466 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_24462,inst_24465);
var inst_24467 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_24458,inst_24459,inst_24466);
var inst_24469 = (function (){var top_level_subject = inst_24318;
var select_spec = inst_24324;
var base_acc = inst_24338;
var acc_PLUS_refs = inst_24354;
var result = inst_24457;
var sort_preds = inst_24467;
return (function (acc,p__24468){
var vec__24482 = p__24468;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24482,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24482,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24482,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24482,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_24470 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_24469,inst_24457,inst_24467);
var state_24478__$1 = state_24478;
var statearr_24485_24568 = state_24478__$1;
(statearr_24485_24568[(2)] = inst_24470);

(statearr_24485_24568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (1))){
var state_24478__$1 = state_24478;
var statearr_24486_24569 = state_24478__$1;
(statearr_24486_24569[(2)] = null);

(statearr_24486_24569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (24))){
var inst_24354 = (state_24478[(9)]);
var inst_24354__$1 = (state_24478[(2)]);
var inst_24355 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_24356 = cljs.core.PersistentHashMap.EMPTY;
var inst_24357 = inst_24355;
var inst_24358 = inst_24354__$1;
var inst_24359 = inst_24356;
var state_24478__$1 = (function (){var statearr_24487 = state_24478;
(statearr_24487[(11)] = inst_24357);

(statearr_24487[(9)] = inst_24354__$1);

(statearr_24487[(12)] = inst_24358);

(statearr_24487[(13)] = inst_24359);

return statearr_24487;
})();
var statearr_24488_24570 = state_24478__$1;
(statearr_24488_24570[(2)] = null);

(statearr_24488_24570[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (39))){
var inst_24324 = (state_24478[(8)]);
var inst_24374 = (state_24478[(14)]);
var inst_24367 = (state_24478[(15)]);
var inst_24358 = (state_24478[(12)]);
var inst_24403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24404 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_24358,inst_24324,inst_24367,inst_24374,false);
var state_24478__$1 = (function (){var statearr_24489 = state_24478;
(statearr_24489[(16)] = inst_24403);

return statearr_24489;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24478__$1,(42),inst_24404);
} else {
if((state_val_24479 === (46))){
var inst_24367 = (state_24478[(15)]);
var inst_24357 = (state_24478[(11)]);
var inst_24359 = (state_24478[(13)]);
var inst_24421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24422 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24423 = cljs.core.first(inst_24367);
var inst_24424 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_24423);
var inst_24425 = [inst_24424];
var inst_24426 = cljs.core.PersistentHashMap.fromArrays(inst_24422,inst_24425);
var inst_24427 = cljs.core.rest(inst_24357);
var inst_24428 = [inst_24426,inst_24427,inst_24359];
var inst_24429 = (new cljs.core.PersistentVector(null,3,(5),inst_24421,inst_24428,null));
var state_24478__$1 = state_24478;
var statearr_24490_24571 = state_24478__$1;
(statearr_24490_24571[(2)] = inst_24429);

(statearr_24490_24571[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (4))){
var inst_24298 = (state_24478[(2)]);
var state_24478__$1 = state_24478;
var statearr_24491_24572 = state_24478__$1;
(statearr_24491_24572[(2)] = inst_24298);

(statearr_24491_24572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (15))){
var inst_24324 = (state_24478[(8)]);
var inst_24325 = (state_24478[(17)]);
var inst_24324__$1 = (state_24478[(2)]);
var inst_24325__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_24324__$1);
var state_24478__$1 = (function (){var statearr_24492 = state_24478;
(statearr_24492[(8)] = inst_24324__$1);

(statearr_24492[(17)] = inst_24325__$1);

return statearr_24492;
})();
if(cljs.core.truth_(inst_24325__$1)){
var statearr_24493_24573 = state_24478__$1;
(statearr_24493_24573[(1)] = (16));

} else {
var statearr_24494_24574 = state_24478__$1;
(statearr_24494_24574[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (48))){
var inst_24440 = (state_24478[(2)]);
var state_24478__$1 = state_24478;
var statearr_24495_24575 = state_24478__$1;
(statearr_24495_24575[(2)] = inst_24440);

(statearr_24495_24575[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (50))){
var state_24478__$1 = state_24478;
var statearr_24496_24576 = state_24478__$1;
(statearr_24496_24576[(2)] = null);

(statearr_24496_24576[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (21))){
var inst_24324 = (state_24478[(8)]);
var inst_24338 = (state_24478[(2)]);
var inst_24339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24340 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_24341 = (new cljs.core.PersistentVector(null,2,(5),inst_24339,inst_24340,null));
var inst_24342 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_24324,inst_24341);
var state_24478__$1 = (function (){var statearr_24497 = state_24478;
(statearr_24497[(10)] = inst_24338);

return statearr_24497;
})();
if(cljs.core.truth_(inst_24342)){
var statearr_24498_24577 = state_24478__$1;
(statearr_24498_24577[(1)] = (22));

} else {
var statearr_24499_24578 = state_24478__$1;
(statearr_24499_24578[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (31))){
var inst_24367 = (state_24478[(15)]);
var inst_24358 = (state_24478[(12)]);
var inst_24373 = (state_24478[(18)]);
var inst_24377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24378 = fluree.db.query.fql.flake__GT_recur(db,inst_24367,inst_24373,inst_24358,fuel,max_fuel,cache);
var state_24478__$1 = (function (){var statearr_24500 = state_24478;
(statearr_24500[(19)] = inst_24377);

return statearr_24500;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24478__$1,(34),inst_24378);
} else {
if((state_val_24479 === (32))){
var inst_24373 = (state_24478[(18)]);
var state_24478__$1 = state_24478;
if(cljs.core.truth_(inst_24373)){
var statearr_24501_24579 = state_24478__$1;
(statearr_24501_24579[(1)] = (35));

} else {
var statearr_24502_24580 = state_24478__$1;
(statearr_24502_24580[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (40))){
var inst_24324 = (state_24478[(8)]);
var inst_24414 = (state_24478[(20)]);
var inst_24413 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24324);
var inst_24414__$1 = cljs.core.empty_QMARK_(inst_24413);
var state_24478__$1 = (function (){var statearr_24503 = state_24478;
(statearr_24503[(20)] = inst_24414__$1);

return statearr_24503;
})();
if(inst_24414__$1){
var statearr_24504_24581 = state_24478__$1;
(statearr_24504_24581[(1)] = (43));

} else {
var statearr_24505_24582 = state_24478__$1;
(statearr_24505_24582[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (33))){
var inst_24367 = (state_24478[(15)]);
var inst_24446 = (state_24478[(2)]);
var inst_24447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24446,(0),null);
var inst_24448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24446,(1),null);
var inst_24449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24446,(2),null);
var inst_24450 = cljs.core.first(inst_24367);
var inst_24451 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_24450);
var inst_24452 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24447,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_24451);
var inst_24357 = inst_24448;
var inst_24358 = inst_24452;
var inst_24359 = inst_24449;
var state_24478__$1 = (function (){var statearr_24506 = state_24478;
(statearr_24506[(11)] = inst_24357);

(statearr_24506[(12)] = inst_24358);

(statearr_24506[(13)] = inst_24359);

return statearr_24506;
})();
var statearr_24507_24583 = state_24478__$1;
(statearr_24507_24583[(2)] = null);

(statearr_24507_24583[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (13))){
var inst_24318 = (state_24478[(7)]);
var inst_24321 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_24318);
var state_24478__$1 = state_24478;
var statearr_24508_24584 = state_24478__$1;
(statearr_24508_24584[(2)] = inst_24321);

(statearr_24508_24584[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (22))){
var inst_24324 = (state_24478[(8)]);
var inst_24344 = cljs.core.first(flakes);
var inst_24345 = fluree.db.query.fql.s(inst_24344);
var inst_24346 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_24324);
var inst_24347 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_24345,inst_24346);
var state_24478__$1 = state_24478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24478__$1,(25),inst_24347);
} else {
if((state_val_24479 === (36))){
var inst_24324 = (state_24478[(8)]);
var inst_24401 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_24324);
var state_24478__$1 = state_24478;
if(cljs.core.truth_(inst_24401)){
var statearr_24509_24585 = state_24478__$1;
(statearr_24509_24585[(1)] = (39));

} else {
var statearr_24510_24586 = state_24478__$1;
(statearr_24510_24586[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (41))){
var inst_24442 = (state_24478[(2)]);
var state_24478__$1 = state_24478;
var statearr_24511_24587 = state_24478__$1;
(statearr_24511_24587[(2)] = inst_24442);

(statearr_24511_24587[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (43))){
var inst_24324 = (state_24478[(8)]);
var inst_24416 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_24324);
var state_24478__$1 = state_24478;
var statearr_24512_24588 = state_24478__$1;
(statearr_24512_24588[(2)] = inst_24416);

(statearr_24512_24588[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (29))){
var inst_24324 = (state_24478[(8)]);
var inst_24367 = (state_24478[(15)]);
var inst_24357 = (state_24478[(11)]);
var inst_24373 = (state_24478[(18)]);
var inst_24367__$1 = cljs.core.first(inst_24357);
var inst_24368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24369 = cljs.core.first(inst_24367__$1);
var inst_24370 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_24369);
var inst_24371 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_24370];
var inst_24372 = (new cljs.core.PersistentVector(null,3,(5),inst_24368,inst_24371,null));
var inst_24373__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_24324,inst_24372);
var inst_24374 = fluree.db.query.fql.component_follow_QMARK_(inst_24373__$1,inst_24324);
var inst_24375 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_24373__$1);
var state_24478__$1 = (function (){var statearr_24513 = state_24478;
(statearr_24513[(14)] = inst_24374);

(statearr_24513[(15)] = inst_24367__$1);

(statearr_24513[(18)] = inst_24373__$1);

return statearr_24513;
})();
if(cljs.core.truth_(inst_24375)){
var statearr_24514_24589 = state_24478__$1;
(statearr_24514_24589[(1)] = (31));

} else {
var statearr_24515_24590 = state_24478__$1;
(statearr_24515_24590[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (44))){
var inst_24414 = (state_24478[(20)]);
var state_24478__$1 = state_24478;
var statearr_24516_24591 = state_24478__$1;
(statearr_24516_24591[(2)] = inst_24414);

(statearr_24516_24591[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (6))){
var state_24478__$1 = state_24478;
var statearr_24517_24592 = state_24478__$1;
(statearr_24517_24592[(2)] = null);

(statearr_24517_24592[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (28))){
var inst_24358 = (state_24478[(12)]);
var state_24478__$1 = state_24478;
var statearr_24518_24593 = state_24478__$1;
(statearr_24518_24593[(2)] = inst_24358);

(statearr_24518_24593[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (51))){
var inst_24438 = (state_24478[(2)]);
var state_24478__$1 = state_24478;
var statearr_24519_24594 = state_24478__$1;
(statearr_24519_24594[(2)] = inst_24438);

(statearr_24519_24594[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (25))){
var inst_24338 = (state_24478[(10)]);
var inst_24349 = (state_24478[(2)]);
var inst_24350 = fluree.db.util.async.throw_err(inst_24349);
var inst_24351 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_24338,inst_24350], 0));
var state_24478__$1 = state_24478;
var statearr_24520_24595 = state_24478__$1;
(statearr_24520_24595[(2)] = inst_24351);

(statearr_24520_24595[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (34))){
var inst_24357 = (state_24478[(11)]);
var inst_24377 = (state_24478[(19)]);
var inst_24359 = (state_24478[(13)]);
var inst_24380 = (state_24478[(2)]);
var inst_24381 = fluree.db.util.async.throw_err(inst_24380);
var inst_24382 = cljs.core.rest(inst_24357);
var inst_24383 = [inst_24381,inst_24382,inst_24359];
var inst_24384 = (new cljs.core.PersistentVector(null,3,(5),inst_24377,inst_24383,null));
var state_24478__$1 = state_24478;
var statearr_24521_24596 = state_24478__$1;
(statearr_24521_24596[(2)] = inst_24384);

(statearr_24521_24596[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (17))){
var inst_24324 = (state_24478[(8)]);
var inst_24328 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_24324);
var state_24478__$1 = state_24478;
var statearr_24523_24597 = state_24478__$1;
(statearr_24523_24597[(2)] = inst_24328);

(statearr_24523_24597[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (3))){
var inst_24476 = (state_24478[(2)]);
var state_24478__$1 = state_24478;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24478__$1,inst_24476);
} else {
if((state_val_24479 === (12))){
var _ = (function (){var statearr_24524 = state_24478;
(statearr_24524[(4)] = cljs.core.rest((state_24478[(4)])));

return statearr_24524;
})();
var state_24478__$1 = state_24478;
var ex24522 = (state_24478__$1[(2)]);
var statearr_24525_24598 = state_24478__$1;
(statearr_24525_24598[(5)] = ex24522);


var statearr_24526_24599 = state_24478__$1;
(statearr_24526_24599[(1)] = (11));

(statearr_24526_24599[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (2))){
var _ = (function (){var statearr_24527 = state_24478;
(statearr_24527[(4)] = cljs.core.cons((5),(state_24478[(4)])));

return statearr_24527;
})();
var inst_24304 = cljs.core.not_empty(flakes);
var state_24478__$1 = state_24478;
if(cljs.core.truth_(inst_24304)){
var statearr_24528_24600 = state_24478__$1;
(statearr_24528_24600[(1)] = (6));

} else {
var statearr_24529_24601 = state_24478__$1;
(statearr_24529_24601[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (23))){
var inst_24338 = (state_24478[(10)]);
var state_24478__$1 = state_24478;
var statearr_24530_24602 = state_24478__$1;
(statearr_24530_24602[(2)] = inst_24338);

(statearr_24530_24602[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (47))){
var state_24478__$1 = state_24478;
var statearr_24531_24603 = state_24478__$1;
(statearr_24531_24603[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (35))){
var inst_24374 = (state_24478[(14)]);
var inst_24367 = (state_24478[(15)]);
var inst_24358 = (state_24478[(12)]);
var inst_24373 = (state_24478[(18)]);
var inst_24359 = (state_24478[(13)]);
var inst_24390 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_24358,inst_24373,inst_24367,inst_24374,false,inst_24359);
var state_24478__$1 = state_24478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24478__$1,(38),inst_24390);
} else {
if((state_val_24479 === (19))){
var inst_24318 = (state_24478[(7)]);
var inst_24332 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24333 = [inst_24318];
var inst_24334 = cljs.core.PersistentHashMap.fromArrays(inst_24332,inst_24333);
var state_24478__$1 = state_24478;
var statearr_24533_24604 = state_24478__$1;
(statearr_24533_24604[(2)] = inst_24334);

(statearr_24533_24604[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (11))){
var inst_24306 = (state_24478[(2)]);
var inst_24307 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_24306], 0));
var inst_24308 = (function(){throw inst_24306})();
var state_24478__$1 = (function (){var statearr_24535 = state_24478;
(statearr_24535[(21)] = inst_24307);

return statearr_24535;
})();
var statearr_24536_24605 = state_24478__$1;
(statearr_24536_24605[(2)] = inst_24308);

(statearr_24536_24605[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (9))){
var _ = (function (){var statearr_24537 = state_24478;
(statearr_24537[(4)] = cljs.core.cons((12),(state_24478[(4)])));

return statearr_24537;
})();
var inst_24314 = cljs.core.first(flakes);
var inst_24315 = fluree.db.query.fql.s(inst_24314);
var ___$1 = (function (){var statearr_24538 = state_24478;
(statearr_24538[(4)] = cljs.core.rest((state_24478[(4)])));

return statearr_24538;
})();
var state_24478__$1 = state_24478;
var statearr_24539_24606 = state_24478__$1;
(statearr_24539_24606[(2)] = inst_24315);

(statearr_24539_24606[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (5))){
var _ = (function (){var statearr_24540 = state_24478;
(statearr_24540[(4)] = cljs.core.rest((state_24478[(4)])));

return statearr_24540;
})();
var state_24478__$1 = state_24478;
var ex24534 = (state_24478__$1[(2)]);
var statearr_24541_24607 = state_24478__$1;
(statearr_24541_24607[(5)] = ex24534);


if((ex24534 instanceof Error)){
var statearr_24542_24608 = state_24478__$1;
(statearr_24542_24608[(1)] = (4));

(statearr_24542_24608[(5)] = null);

} else {
throw ex24534;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (14))){
var state_24478__$1 = state_24478;
var statearr_24543_24609 = state_24478__$1;
(statearr_24543_24609[(2)] = base_select_spec);

(statearr_24543_24609[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (45))){
var inst_24419 = (state_24478[(2)]);
var state_24478__$1 = state_24478;
if(cljs.core.truth_(inst_24419)){
var statearr_24544_24610 = state_24478__$1;
(statearr_24544_24610[(1)] = (46));

} else {
var statearr_24545_24611 = state_24478__$1;
(statearr_24545_24611[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (26))){
var inst_24357 = (state_24478[(11)]);
var inst_24361 = cljs.core.empty_QMARK_(inst_24357);
var state_24478__$1 = state_24478;
if(inst_24361){
var statearr_24546_24612 = state_24478__$1;
(statearr_24546_24612[(1)] = (28));

} else {
var statearr_24547_24613 = state_24478__$1;
(statearr_24547_24613[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (16))){
var inst_24325 = (state_24478[(17)]);
var state_24478__$1 = state_24478;
var statearr_24548_24614 = state_24478__$1;
(statearr_24548_24614[(2)] = inst_24325);

(statearr_24548_24614[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (38))){
var inst_24357 = (state_24478[(11)]);
var inst_24392 = (state_24478[(2)]);
var inst_24393 = fluree.db.util.async.throw_err(inst_24392);
var inst_24394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24393,(0),null);
var inst_24395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24393,(1),null);
var inst_24396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24397 = cljs.core.rest(inst_24357);
var inst_24398 = [inst_24394,inst_24397,inst_24395];
var inst_24399 = (new cljs.core.PersistentVector(null,3,(5),inst_24396,inst_24398,null));
var state_24478__$1 = state_24478;
var statearr_24549_24615 = state_24478__$1;
(statearr_24549_24615[(2)] = inst_24399);

(statearr_24549_24615[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (30))){
var inst_24455 = (state_24478[(2)]);
var state_24478__$1 = state_24478;
var statearr_24550_24616 = state_24478__$1;
(statearr_24550_24616[(2)] = inst_24455);

(statearr_24550_24616[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (10))){
var inst_24318 = (state_24478[(2)]);
var inst_24319 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_24478__$1 = (function (){var statearr_24551 = state_24478;
(statearr_24551[(7)] = inst_24318);

return statearr_24551;
})();
if(cljs.core.truth_(inst_24319)){
var statearr_24552_24617 = state_24478__$1;
(statearr_24552_24617[(1)] = (13));

} else {
var statearr_24553_24618 = state_24478__$1;
(statearr_24553_24618[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (18))){
var inst_24330 = (state_24478[(2)]);
var state_24478__$1 = state_24478;
if(cljs.core.truth_(inst_24330)){
var statearr_24554_24619 = state_24478__$1;
(statearr_24554_24619[(1)] = (19));

} else {
var statearr_24555_24620 = state_24478__$1;
(statearr_24555_24620[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (42))){
var inst_24357 = (state_24478[(11)]);
var inst_24403 = (state_24478[(16)]);
var inst_24359 = (state_24478[(13)]);
var inst_24406 = (state_24478[(2)]);
var inst_24407 = fluree.db.util.async.throw_err(inst_24406);
var inst_24408 = cljs.core.first(inst_24407);
var inst_24409 = cljs.core.rest(inst_24357);
var inst_24410 = [inst_24408,inst_24409,inst_24359];
var inst_24411 = (new cljs.core.PersistentVector(null,3,(5),inst_24403,inst_24410,null));
var state_24478__$1 = state_24478;
var statearr_24556_24621 = state_24478__$1;
(statearr_24556_24621[(2)] = inst_24411);

(statearr_24556_24621[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (37))){
var inst_24444 = (state_24478[(2)]);
var state_24478__$1 = state_24478;
var statearr_24557_24622 = state_24478__$1;
(statearr_24557_24622[(2)] = inst_24444);

(statearr_24557_24622[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (8))){
var inst_24473 = (state_24478[(2)]);
var _ = (function (){var statearr_24558 = state_24478;
(statearr_24558[(4)] = cljs.core.rest((state_24478[(4)])));

return statearr_24558;
})();
var state_24478__$1 = state_24478;
var statearr_24559_24623 = state_24478__$1;
(statearr_24559_24623[(2)] = inst_24473);

(statearr_24559_24623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24479 === (49))){
var inst_24357 = (state_24478[(11)]);
var inst_24358 = (state_24478[(12)]);
var inst_24359 = (state_24478[(13)]);
var inst_24432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24433 = cljs.core.rest(inst_24357);
var inst_24434 = [inst_24358,inst_24433,inst_24359];
var inst_24435 = (new cljs.core.PersistentVector(null,3,(5),inst_24432,inst_24434,null));
var state_24478__$1 = state_24478;
var statearr_24560_24624 = state_24478__$1;
(statearr_24560_24624[(2)] = inst_24435);

(statearr_24560_24624[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto____0 = (function (){
var statearr_24561 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24561[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto__);

(statearr_24561[(1)] = (1));

return statearr_24561;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto____1 = (function (state_24478){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24478);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24562){var ex__2687__auto__ = e24562;
var statearr_24563_24625 = state_24478;
(statearr_24563_24625[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24478[(4)]))){
var statearr_24564_24626 = state_24478;
(statearr_24564_24626[(1)] = cljs.core.first((state_24478[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24627 = state_24478;
state_24478 = G__24627;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto__ = function(state_24478){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto____1.call(this,state_24478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24565 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24565[(6)] = c__2706__auto__);

return statearr_24565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__24630 = arguments.length;
switch (G__24630) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24672){
var state_val_24673 = (state_24672[(1)]);
if((state_val_24673 === (7))){
var inst_24638 = (state_24672[(7)]);
var state_24672__$1 = state_24672;
var statearr_24674_24704 = state_24672__$1;
(statearr_24674_24704[(2)] = inst_24638);

(statearr_24674_24704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (1))){
var state_24672__$1 = state_24672;
var statearr_24675_24705 = state_24672__$1;
(statearr_24675_24705[(2)] = null);

(statearr_24675_24705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (4))){
var inst_24631 = (state_24672[(2)]);
var state_24672__$1 = state_24672;
var statearr_24676_24706 = state_24672__$1;
(statearr_24676_24706[(2)] = inst_24631);

(statearr_24676_24706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (15))){
var inst_24666 = (state_24672[(2)]);
var inst_24667 = fluree.db.util.async.throw_err(inst_24666);
var _ = (function (){var statearr_24677 = state_24672;
(statearr_24677[(4)] = cljs.core.rest((state_24672[(4)])));

return statearr_24677;
})();
var state_24672__$1 = state_24672;
var statearr_24678_24707 = state_24672__$1;
(statearr_24678_24707[(2)] = inst_24667);

(statearr_24678_24707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (13))){
var inst_24650 = (state_24672[(8)]);
var state_24672__$1 = state_24672;
var statearr_24679_24708 = state_24672__$1;
(statearr_24679_24708[(2)] = inst_24650);

(statearr_24679_24708[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (6))){
var inst_24638 = (state_24672[(7)]);
var inst_24640 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_24641 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24638,inst_24640);
var state_24672__$1 = state_24672;
var statearr_24680_24709 = state_24672__$1;
(statearr_24680_24709[(2)] = inst_24641);

(statearr_24680_24709[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (3))){
var inst_24670 = (state_24672[(2)]);
var state_24672__$1 = state_24672;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24672__$1,inst_24670);
} else {
if((state_val_24673 === (12))){
var inst_24650 = (state_24672[(8)]);
var inst_24652 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_24653 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24650,inst_24652);
var state_24672__$1 = state_24672;
var statearr_24681_24710 = state_24672__$1;
(statearr_24681_24710[(2)] = inst_24653);

(statearr_24681_24710[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (2))){
var _ = (function (){var statearr_24682 = state_24672;
(statearr_24682[(4)] = cljs.core.cons((5),(state_24672[(4)])));

return statearr_24682;
})();
var inst_24638 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_24672__$1 = (function (){var statearr_24683 = state_24672;
(statearr_24683[(7)] = inst_24638);

return statearr_24683;
})();
if(cljs.core.truth_(fuel)){
var statearr_24684_24711 = state_24672__$1;
(statearr_24684_24711[(1)] = (6));

} else {
var statearr_24685_24712 = state_24672__$1;
(statearr_24685_24712[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (11))){
var inst_24650 = (state_24672[(2)]);
var state_24672__$1 = (function (){var statearr_24687 = state_24672;
(statearr_24687[(8)] = inst_24650);

return statearr_24687;
})();
if(cljs.core.truth_(limit)){
var statearr_24688_24713 = state_24672__$1;
(statearr_24688_24713[(1)] = (12));

} else {
var statearr_24689_24714 = state_24672__$1;
(statearr_24689_24714[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (9))){
var inst_24644 = (state_24672[(9)]);
var inst_24646 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_24647 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24644,inst_24646);
var state_24672__$1 = state_24672;
var statearr_24690_24715 = state_24672__$1;
(statearr_24690_24715[(2)] = inst_24647);

(statearr_24690_24715[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (5))){
var _ = (function (){var statearr_24691 = state_24672;
(statearr_24691[(4)] = cljs.core.rest((state_24672[(4)])));

return statearr_24691;
})();
var state_24672__$1 = state_24672;
var ex24686 = (state_24672__$1[(2)]);
var statearr_24692_24716 = state_24672__$1;
(statearr_24692_24716[(5)] = ex24686);


if((ex24686 instanceof Error)){
var statearr_24693_24717 = state_24672__$1;
(statearr_24693_24717[(1)] = (4));

(statearr_24693_24717[(5)] = null);

} else {
throw ex24686;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (14))){
var inst_24656 = (state_24672[(2)]);
var inst_24657 = (function (){return (function (x){
var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__5043__auto__;
}
});
})();
var inst_24658 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_24657);
var inst_24659 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24656,inst_24658);
var inst_24660 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_24659,flakes);
var inst_24661 = cljs.core.PersistentVector.EMPTY;
var inst_24662 = (function (){var xf = inst_24659;
var flakes_by_sub = inst_24660;
return (function (p1__24628_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__24628_SHARP_);
});
})();
var inst_24663 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_24662,inst_24660);
var inst_24664 = fluree.db.util.async.merge_into_QMARK_(inst_24661,inst_24663);
var state_24672__$1 = state_24672;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24672__$1,(15),inst_24664);
} else {
if((state_val_24673 === (10))){
var inst_24644 = (state_24672[(9)]);
var state_24672__$1 = state_24672;
var statearr_24694_24718 = state_24672__$1;
(statearr_24694_24718[(2)] = inst_24644);

(statearr_24694_24718[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24673 === (8))){
var inst_24644 = (state_24672[(2)]);
var state_24672__$1 = (function (){var statearr_24695 = state_24672;
(statearr_24695[(9)] = inst_24644);

return statearr_24695;
})();
if(cljs.core.truth_(offset)){
var statearr_24696_24719 = state_24672__$1;
(statearr_24696_24719[(1)] = (9));

} else {
var statearr_24697_24720 = state_24672__$1;
(statearr_24697_24720[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2684__auto__ = null;
var fluree$db$query$fql$state_machine__2684__auto____0 = (function (){
var statearr_24698 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24698[(0)] = fluree$db$query$fql$state_machine__2684__auto__);

(statearr_24698[(1)] = (1));

return statearr_24698;
});
var fluree$db$query$fql$state_machine__2684__auto____1 = (function (state_24672){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24672);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24699){var ex__2687__auto__ = e24699;
var statearr_24700_24721 = state_24672;
(statearr_24700_24721[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24672[(4)]))){
var statearr_24701_24722 = state_24672;
(statearr_24701_24722[(1)] = cljs.core.first((state_24672[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24723 = state_24672;
state_24672 = G__24723;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2684__auto__ = function(state_24672){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2684__auto____1.call(this,state_24672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2684__auto____0;
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2684__auto____1;
return fluree$db$query$fql$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24702 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24702[(6)] = c__2706__auto__);

return statearr_24702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__24725 = arguments.length;
switch (G__24725) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24811){
var state_val_24812 = (state_24811[(1)]);
if((state_val_24812 === (7))){
var inst_24806 = (state_24811[(2)]);
var _ = (function (){var statearr_24814 = state_24811;
(statearr_24814[(4)] = cljs.core.rest((state_24811[(4)])));

return statearr_24814;
})();
var state_24811__$1 = state_24811;
var statearr_24815_24867 = state_24811__$1;
(statearr_24815_24867[(2)] = inst_24806);

(statearr_24815_24867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (20))){
var inst_24745 = (state_24811[(7)]);
var inst_24746 = (state_24811[(8)]);
var inst_24753 = (state_24811[(9)]);
var inst_24774 = (inst_24745 + (1));
var tmp24813 = inst_24746;
var inst_24744 = inst_24753;
var inst_24745__$1 = inst_24774;
var inst_24746__$1 = tmp24813;
var state_24811__$1 = (function (){var statearr_24816 = state_24811;
(statearr_24816[(7)] = inst_24745__$1);

(statearr_24816[(8)] = inst_24746__$1);

(statearr_24816[(10)] = inst_24744);

return statearr_24816;
})();
var statearr_24817_24868 = state_24811__$1;
(statearr_24817_24868[(2)] = null);

(statearr_24817_24868[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (27))){
var inst_24784 = (state_24811[(11)]);
var inst_24786 = cljs.core.count(inst_24784);
var inst_24787 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24786);
var state_24811__$1 = state_24811;
var statearr_24818_24869 = state_24811__$1;
(statearr_24818_24869[(2)] = inst_24787);

(statearr_24818_24869[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (1))){
var state_24811__$1 = state_24811;
var statearr_24819_24870 = state_24811__$1;
(statearr_24819_24870[(2)] = null);

(statearr_24819_24870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (24))){
var state_24811__$1 = state_24811;
var statearr_24820_24871 = state_24811__$1;
(statearr_24820_24871[(2)] = null);

(statearr_24820_24871[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (4))){
var inst_24726 = (state_24811[(2)]);
var state_24811__$1 = state_24811;
var statearr_24821_24872 = state_24811__$1;
(statearr_24821_24872[(2)] = inst_24726);

(statearr_24821_24872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (15))){
var inst_24767 = (state_24811[(12)]);
var inst_24767__$1 = offset;
var state_24811__$1 = (function (){var statearr_24822 = state_24811;
(statearr_24822[(12)] = inst_24767__$1);

return statearr_24822;
})();
if(cljs.core.truth_(inst_24767__$1)){
var statearr_24823_24873 = state_24811__$1;
(statearr_24823_24873[(1)] = (17));

} else {
var statearr_24824_24874 = state_24811__$1;
(statearr_24824_24874[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (21))){
var state_24811__$1 = state_24811;
var statearr_24825_24875 = state_24811__$1;
(statearr_24825_24875[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (13))){
var inst_24762 = (state_24811[(2)]);
var state_24811__$1 = state_24811;
var statearr_24827_24876 = state_24811__$1;
(statearr_24827_24876[(2)] = inst_24762);

(statearr_24827_24876[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (22))){
var inst_24802 = (state_24811[(2)]);
var state_24811__$1 = state_24811;
var statearr_24828_24877 = state_24811__$1;
(statearr_24828_24877[(2)] = inst_24802);

(statearr_24828_24877[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (29))){
var inst_24745 = (state_24811[(7)]);
var inst_24784 = (state_24811[(11)]);
var inst_24790 = (state_24811[(2)]);
var inst_24791 = (inst_24745 + (1));
var inst_24792 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_24784);
var state_24811__$1 = (function (){var statearr_24829 = state_24811;
(statearr_24829[(13)] = inst_24791);

(statearr_24829[(14)] = inst_24790);

return statearr_24829;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24811__$1,(30),inst_24792);
} else {
if((state_val_24812 === (6))){
var inst_24754 = (state_24811[(15)]);
var inst_24752 = (state_24811[(16)]);
var inst_24744 = (state_24811[(10)]);
var inst_24751 = cljs.core.seq(inst_24744);
var inst_24752__$1 = cljs.core.first(inst_24751);
var inst_24753 = cljs.core.next(inst_24751);
var inst_24754__$1 = (inst_24752__$1 == null);
var state_24811__$1 = (function (){var statearr_24830 = state_24811;
(statearr_24830[(15)] = inst_24754__$1);

(statearr_24830[(9)] = inst_24753);

(statearr_24830[(16)] = inst_24752__$1);

return statearr_24830;
})();
if(cljs.core.truth_(inst_24754__$1)){
var statearr_24831_24878 = state_24811__$1;
(statearr_24831_24878[(1)] = (8));

} else {
var statearr_24832_24879 = state_24811__$1;
(statearr_24832_24879[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (28))){
var state_24811__$1 = state_24811;
var statearr_24833_24880 = state_24811__$1;
(statearr_24833_24880[(2)] = null);

(statearr_24833_24880[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (25))){
var inst_24800 = (state_24811[(2)]);
var state_24811__$1 = state_24811;
var statearr_24834_24881 = state_24811__$1;
(statearr_24834_24881[(2)] = inst_24800);

(statearr_24834_24881[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (17))){
var inst_24745 = (state_24811[(7)]);
var inst_24769 = (inst_24745 < offset);
var state_24811__$1 = state_24811;
var statearr_24835_24882 = state_24811__$1;
(statearr_24835_24882[(2)] = inst_24769);

(statearr_24835_24882[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (3))){
var inst_24809 = (state_24811[(2)]);
var state_24811__$1 = state_24811;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24811__$1,inst_24809);
} else {
if((state_val_24812 === (12))){
var inst_24757 = (state_24811[(17)]);
var state_24811__$1 = state_24811;
var statearr_24836_24883 = state_24811__$1;
(statearr_24836_24883[(2)] = inst_24757);

(statearr_24836_24883[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (2))){
var _ = (function (){var statearr_24837 = state_24811;
(statearr_24837[(4)] = cljs.core.cons((5),(state_24811[(4)])));

return statearr_24837;
})();
var inst_24739 = subjects;
var inst_24740 = cljs.core.seq(inst_24739);
var inst_24741 = cljs.core.first(inst_24740);
var inst_24742 = cljs.core.next(inst_24740);
var inst_24743 = cljs.core.PersistentVector.EMPTY;
var inst_24744 = inst_24739;
var inst_24745 = (0);
var inst_24746 = inst_24743;
var state_24811__$1 = (function (){var statearr_24838 = state_24811;
(statearr_24838[(7)] = inst_24745);

(statearr_24838[(18)] = inst_24741);

(statearr_24838[(8)] = inst_24746);

(statearr_24838[(19)] = inst_24742);

(statearr_24838[(10)] = inst_24744);

return statearr_24838;
})();
var statearr_24839_24884 = state_24811__$1;
(statearr_24839_24884[(2)] = null);

(statearr_24839_24884[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (23))){
var inst_24752 = (state_24811[(16)]);
var inst_24778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24779 = [inst_24752];
var inst_24780 = (new cljs.core.PersistentVector(null,1,(5),inst_24778,inst_24779,null));
var inst_24781 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24780);
var state_24811__$1 = state_24811;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24811__$1,(26),inst_24781);
} else {
if((state_val_24812 === (19))){
var inst_24772 = (state_24811[(2)]);
var state_24811__$1 = state_24811;
if(cljs.core.truth_(inst_24772)){
var statearr_24840_24885 = state_24811__$1;
(statearr_24840_24885[(1)] = (20));

} else {
var statearr_24841_24886 = state_24811__$1;
(statearr_24841_24886[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (11))){
var inst_24745 = (state_24811[(7)]);
var inst_24759 = (inst_24745 > limit);
var state_24811__$1 = state_24811;
var statearr_24843_24887 = state_24811__$1;
(statearr_24843_24887[(2)] = inst_24759);

(statearr_24843_24887[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (9))){
var inst_24757 = (state_24811[(17)]);
var inst_24757__$1 = limit;
var state_24811__$1 = (function (){var statearr_24844 = state_24811;
(statearr_24844[(17)] = inst_24757__$1);

return statearr_24844;
})();
if(cljs.core.truth_(inst_24757__$1)){
var statearr_24845_24888 = state_24811__$1;
(statearr_24845_24888[(1)] = (11));

} else {
var statearr_24846_24889 = state_24811__$1;
(statearr_24846_24889[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (5))){
var _ = (function (){var statearr_24847 = state_24811;
(statearr_24847[(4)] = cljs.core.rest((state_24811[(4)])));

return statearr_24847;
})();
var state_24811__$1 = state_24811;
var ex24842 = (state_24811__$1[(2)]);
var statearr_24848_24890 = state_24811__$1;
(statearr_24848_24890[(5)] = ex24842);


if((ex24842 instanceof Error)){
var statearr_24849_24891 = state_24811__$1;
(statearr_24849_24891[(1)] = (4));

(statearr_24849_24891[(5)] = null);

} else {
throw ex24842;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (14))){
var inst_24746 = (state_24811[(8)]);
var state_24811__$1 = state_24811;
var statearr_24850_24892 = state_24811__$1;
(statearr_24850_24892[(2)] = inst_24746);

(statearr_24850_24892[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (26))){
var inst_24783 = (state_24811[(2)]);
var inst_24784 = fluree.db.util.async.throw_err(inst_24783);
var state_24811__$1 = (function (){var statearr_24851 = state_24811;
(statearr_24851[(11)] = inst_24784);

return statearr_24851;
})();
if(cljs.core.truth_(fuel)){
var statearr_24852_24893 = state_24811__$1;
(statearr_24852_24893[(1)] = (27));

} else {
var statearr_24853_24894 = state_24811__$1;
(statearr_24853_24894[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (16))){
var inst_24804 = (state_24811[(2)]);
var state_24811__$1 = state_24811;
var statearr_24854_24895 = state_24811__$1;
(statearr_24854_24895[(2)] = inst_24804);

(statearr_24854_24895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (30))){
var inst_24746 = (state_24811[(8)]);
var inst_24791 = (state_24811[(13)]);
var inst_24753 = (state_24811[(9)]);
var inst_24794 = (state_24811[(2)]);
var inst_24795 = fluree.db.util.async.throw_err(inst_24794);
var inst_24796 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24746,inst_24795);
var inst_24744 = inst_24753;
var inst_24745 = inst_24791;
var inst_24746__$1 = inst_24796;
var state_24811__$1 = (function (){var statearr_24855 = state_24811;
(statearr_24855[(7)] = inst_24745);

(statearr_24855[(8)] = inst_24746__$1);

(statearr_24855[(10)] = inst_24744);

return statearr_24855;
})();
var statearr_24856_24896 = state_24811__$1;
(statearr_24856_24896[(2)] = null);

(statearr_24856_24896[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (10))){
var inst_24764 = (state_24811[(2)]);
var state_24811__$1 = state_24811;
if(cljs.core.truth_(inst_24764)){
var statearr_24857_24897 = state_24811__$1;
(statearr_24857_24897[(1)] = (14));

} else {
var statearr_24858_24898 = state_24811__$1;
(statearr_24858_24898[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (18))){
var inst_24767 = (state_24811[(12)]);
var state_24811__$1 = state_24811;
var statearr_24859_24899 = state_24811__$1;
(statearr_24859_24899[(2)] = inst_24767);

(statearr_24859_24899[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24812 === (8))){
var inst_24754 = (state_24811[(15)]);
var state_24811__$1 = state_24811;
var statearr_24860_24900 = state_24811__$1;
(statearr_24860_24900[(2)] = inst_24754);

(statearr_24860_24900[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2684__auto__ = null;
var fluree$db$query$fql$state_machine__2684__auto____0 = (function (){
var statearr_24861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24861[(0)] = fluree$db$query$fql$state_machine__2684__auto__);

(statearr_24861[(1)] = (1));

return statearr_24861;
});
var fluree$db$query$fql$state_machine__2684__auto____1 = (function (state_24811){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24811);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24862){var ex__2687__auto__ = e24862;
var statearr_24863_24901 = state_24811;
(statearr_24863_24901[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24811[(4)]))){
var statearr_24864_24902 = state_24811;
(statearr_24864_24902[(1)] = cljs.core.first((state_24811[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24903 = state_24811;
state_24811 = G__24903;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2684__auto__ = function(state_24811){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2684__auto____1.call(this,state_24811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2684__auto____0;
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2684__auto____1;
return fluree$db$query$fql$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24865 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24865[(6)] = c__2706__auto__);

return statearr_24865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24905 = arguments.length;
switch (G__24905) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__24906){
var map__24907 = p__24906;
var map__24907__$1 = cljs.core.__destructure_map(map__24907);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24907__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24907__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25171){
var state_val_25172 = (state_25171[(1)]);
if((state_val_25172 === (65))){
var inst_25134 = (state_25171[(7)]);
var inst_25134__$1 = (state_25171[(2)]);
var state_25171__$1 = (function (){var statearr_25173 = state_25171;
(statearr_25173[(7)] = inst_25134__$1);

return statearr_25173;
})();
if(cljs.core.truth_(inst_25134__$1)){
var statearr_25174_25292 = state_25171__$1;
(statearr_25174_25292[(1)] = (66));

} else {
var statearr_25175_25293 = state_25171__$1;
(statearr_25175_25293[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (70))){
var inst_25137 = (state_25171[(8)]);
var state_25171__$1 = state_25171;
var statearr_25176_25294 = state_25171__$1;
(statearr_25176_25294[(2)] = inst_25137);

(statearr_25176_25294[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (62))){
var inst_25125 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25177_25295 = state_25171__$1;
(statearr_25177_25295[(2)] = inst_25125);

(statearr_25177_25295[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (74))){
var inst_25144 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25178_25296 = state_25171__$1;
(statearr_25178_25296[(2)] = inst_25144);

(statearr_25178_25296[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (7))){
var inst_24920 = (state_25171[(9)]);
var state_25171__$1 = state_25171;
var statearr_25179_25297 = state_25171__$1;
(statearr_25179_25297[(2)] = inst_24920);

(statearr_25179_25297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (59))){
var inst_24949 = (state_25171[(10)]);
var inst_25117 = cljs.core.empty_QMARK_(inst_24949);
var state_25171__$1 = state_25171;
if(inst_25117){
var statearr_25180_25298 = state_25171__$1;
(statearr_25180_25298[(1)] = (60));

} else {
var statearr_25181_25299 = state_25171__$1;
(statearr_25181_25299[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (20))){
var state_25171__$1 = state_25171;
if(cljs.core.truth_(offset)){
var statearr_25182_25300 = state_25171__$1;
(statearr_25182_25300[(1)] = (23));

} else {
var statearr_25183_25301 = state_25171__$1;
(statearr_25183_25301[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (72))){
var inst_25114 = (state_25171[(11)]);
var inst_24934 = (state_25171[(12)]);
var inst_25140 = cljs.core.count(inst_25114);
var inst_25141 = (inst_25140 > inst_24934);
var state_25171__$1 = state_25171;
var statearr_25184_25302 = state_25171__$1;
(statearr_25184_25302[(2)] = inst_25141);

(statearr_25184_25302[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (58))){
var inst_25114 = (state_25171[(11)]);
var inst_24949 = (state_25171[(10)]);
var inst_25115 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24949,inst_25114);
var state_25171__$1 = state_25171;
var statearr_25185_25303 = state_25171__$1;
(statearr_25185_25303[(2)] = inst_25115);

(statearr_25185_25303[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (60))){
var inst_25114 = (state_25171[(11)]);
var inst_24949 = (state_25171[(10)]);
var inst_25119 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24949,inst_25114);
var state_25171__$1 = state_25171;
var statearr_25186_25304 = state_25171__$1;
(statearr_25186_25304[(2)] = inst_25119);

(statearr_25186_25304[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (27))){
var inst_24964 = (state_25171[(13)]);
var state_25171__$1 = state_25171;
var statearr_25187_25305 = state_25171__$1;
(statearr_25187_25305[(2)] = inst_24964);

(statearr_25187_25305[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (1))){
var state_25171__$1 = state_25171;
var statearr_25188_25306 = state_25171__$1;
(statearr_25188_25306[(2)] = null);

(statearr_25188_25306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (69))){
var inst_24934 = (state_25171[(12)]);
var state_25171__$1 = state_25171;
if(cljs.core.truth_(inst_24934)){
var statearr_25189_25307 = state_25171__$1;
(statearr_25189_25307[(1)] = (72));

} else {
var statearr_25190_25308 = state_25171__$1;
(statearr_25190_25308[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (24))){
var inst_24949 = (state_25171[(10)]);
var state_25171__$1 = state_25171;
var statearr_25191_25309 = state_25171__$1;
(statearr_25191_25309[(2)] = inst_24949);

(statearr_25191_25309[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (55))){
var inst_25103 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25192_25310 = state_25171__$1;
(statearr_25192_25310[(2)] = inst_25103);

(statearr_25192_25310[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (39))){
var inst_25111 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25193_25311 = state_25171__$1;
(statearr_25193_25311[(2)] = inst_25111);

(statearr_25193_25311[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (46))){
var inst_24975 = (state_25171[(14)]);
var inst_24993 = (state_25171[(15)]);
var inst_25069 = (inst_24993.cljs$core$IFn$_invoke$arity$2 ? inst_24993.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_24975) : inst_24993.call(null,cljs.core._LT_,inst_24975));
var state_25171__$1 = state_25171;
if(cljs.core.truth_(inst_25069)){
var statearr_25194_25312 = state_25171__$1;
(statearr_25194_25312[(1)] = (49));

} else {
var statearr_25195_25313 = state_25171__$1;
(statearr_25195_25313[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (4))){
var inst_24908 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25196_25314 = state_25171__$1;
(statearr_25196_25314[(2)] = inst_24908);

(statearr_25196_25314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (77))){
var inst_25159 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25197_25315 = state_25171__$1;
(statearr_25197_25315[(2)] = inst_25159);

(statearr_25197_25315[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (54))){
var inst_25101 = cljs.core.PersistentVector.EMPTY;
var state_25171__$1 = state_25171;
var statearr_25198_25316 = state_25171__$1;
(statearr_25198_25316[(2)] = inst_25101);

(statearr_25198_25316[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (15))){
var inst_24919 = (state_25171[(16)]);
var inst_24944 = cljs.core.seq(inst_24919);
var inst_24945 = cljs.core.first(inst_24944);
var inst_24946 = cljs.core.next(inst_24944);
var inst_24947 = cljs.core.PersistentHashSet.EMPTY;
var inst_24948 = inst_24919;
var inst_24949 = inst_24947;
var state_25171__$1 = (function (){var statearr_25199 = state_25171;
(statearr_25199[(17)] = inst_24946);

(statearr_25199[(18)] = inst_24948);

(statearr_25199[(10)] = inst_24949);

(statearr_25199[(19)] = inst_24945);

return statearr_25199;
})();
var statearr_25200_25317 = state_25171__$1;
(statearr_25200_25317[(2)] = null);

(statearr_25200_25317[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (48))){
var inst_25066 = (state_25171[(2)]);
var inst_25067 = fluree.db.util.async.throw_err(inst_25066);
var state_25171__$1 = state_25171;
var statearr_25201_25318 = state_25171__$1;
(statearr_25201_25318[(2)] = inst_25067);

(statearr_25201_25318[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (50))){
var inst_24975 = (state_25171[(14)]);
var inst_24993 = (state_25171[(15)]);
var inst_25085 = (inst_24993.cljs$core$IFn$_invoke$arity$2 ? inst_24993.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_24975) : inst_24993.call(null,cljs.core._LT__EQ_,inst_24975));
var state_25171__$1 = state_25171;
if(cljs.core.truth_(inst_25085)){
var statearr_25202_25319 = state_25171__$1;
(statearr_25202_25319[(1)] = (53));

} else {
var statearr_25203_25320 = state_25171__$1;
(statearr_25203_25320[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (75))){
var state_25171__$1 = state_25171;
if(cljs.core.truth_(offset)){
var statearr_25204_25321 = state_25171__$1;
(statearr_25204_25321[(1)] = (78));

} else {
var statearr_25205_25322 = state_25171__$1;
(statearr_25205_25322[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (21))){
var inst_24955 = (state_25171[(20)]);
var inst_24974 = (state_25171[(21)]);
var inst_24974__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24955,(0),null);
var inst_24975 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24955,(1),null);
var inst_24976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24955,(2),null);
var inst_24977 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_24974__$1);
var inst_24978 = cljs.core.not(inst_24977);
var state_25171__$1 = (function (){var statearr_25206 = state_25171;
(statearr_25206[(22)] = inst_24976);

(statearr_25206[(14)] = inst_24975);

(statearr_25206[(21)] = inst_24974__$1);

return statearr_25206;
})();
if(inst_24978){
var statearr_25207_25323 = state_25171__$1;
(statearr_25207_25323[(1)] = (29));

} else {
var statearr_25208_25324 = state_25171__$1;
(statearr_25208_25324[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (31))){
var inst_24975 = (state_25171[(14)]);
var inst_24993 = (state_25171[(15)]);
var inst_24989 = (state_25171[(2)]);
var inst_24993__$1 = cljs.core.identical_QMARK_;
var inst_24994 = (inst_24993__$1.cljs$core$IFn$_invoke$arity$2 ? inst_24993__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_24975) : inst_24993__$1.call(null,cljs.core.not_EQ_,inst_24975));
var state_25171__$1 = (function (){var statearr_25209 = state_25171;
(statearr_25209[(15)] = inst_24993__$1);

(statearr_25209[(23)] = inst_24989);

return statearr_25209;
})();
if(cljs.core.truth_(inst_24994)){
var statearr_25210_25325 = state_25171__$1;
(statearr_25210_25325[(1)] = (32));

} else {
var statearr_25211_25326 = state_25171__$1;
(statearr_25211_25326[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (32))){
var inst_24976 = (state_25171[(22)]);
var inst_24934 = (state_25171[(12)]);
var inst_24974 = (state_25171[(21)]);
var inst_24996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24997 = [inst_24974,inst_24976];
var inst_24998 = (new cljs.core.PersistentVector(null,2,(5),inst_24996,inst_24997,null));
var inst_24999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25000 = [inst_24974];
var inst_25001 = (new cljs.core.PersistentVector(null,1,(5),inst_24999,inst_25000,null));
var inst_25002 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25003 = [inst_24934];
var inst_25004 = cljs.core.PersistentHashMap.fromArrays(inst_25002,inst_25003);
var inst_25005 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24998,cljs.core._LT__EQ_,inst_25001,inst_25004);
var state_25171__$1 = state_25171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25171__$1,(35),inst_25005);
} else {
if((state_val_25172 === (40))){
var inst_25034 = (state_25171[(2)]);
var inst_25035 = fluree.db.util.async.throw_err(inst_25034);
var state_25171__$1 = state_25171;
var statearr_25212_25327 = state_25171__$1;
(statearr_25212_25327[(2)] = inst_25035);

(statearr_25212_25327[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (56))){
var inst_25098 = (state_25171[(2)]);
var inst_25099 = fluree.db.util.async.throw_err(inst_25098);
var state_25171__$1 = state_25171;
var statearr_25213_25328 = state_25171__$1;
(statearr_25213_25328[(2)] = inst_25099);

(statearr_25213_25328[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (33))){
var inst_24975 = (state_25171[(14)]);
var inst_24993 = (state_25171[(15)]);
var inst_25024 = (inst_24993.cljs$core$IFn$_invoke$arity$2 ? inst_24993.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_24975) : inst_24993.call(null,cljs.core._EQ_,inst_24975));
var state_25171__$1 = state_25171;
if(cljs.core.truth_(inst_25024)){
var statearr_25214_25329 = state_25171__$1;
(statearr_25214_25329[(1)] = (37));

} else {
var statearr_25215_25330 = state_25171__$1;
(statearr_25215_25330[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (13))){
var state_25171__$1 = state_25171;
var statearr_25216_25331 = state_25171__$1;
(statearr_25216_25331[(2)] = limit);

(statearr_25216_25331[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (22))){
var inst_25161 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25217_25332 = state_25171__$1;
(statearr_25217_25332[(2)] = inst_25161);

(statearr_25217_25332[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (36))){
var inst_25008 = (state_25171[(24)]);
var inst_25020 = (state_25171[(2)]);
var inst_25021 = fluree.db.util.async.throw_err(inst_25020);
var inst_25022 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_25008,inst_25021);
var state_25171__$1 = state_25171;
var statearr_25218_25333 = state_25171__$1;
(statearr_25218_25333[(2)] = inst_25022);

(statearr_25218_25333[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (41))){
var inst_24976 = (state_25171[(22)]);
var inst_24934 = (state_25171[(12)]);
var inst_24974 = (state_25171[(21)]);
var inst_25039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25040 = [inst_24974,inst_24976];
var inst_25041 = (new cljs.core.PersistentVector(null,2,(5),inst_25039,inst_25040,null));
var inst_25042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25043 = [inst_24974];
var inst_25044 = (new cljs.core.PersistentVector(null,1,(5),inst_25042,inst_25043,null));
var inst_25045 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25046 = [inst_24934];
var inst_25047 = cljs.core.PersistentHashMap.fromArrays(inst_25045,inst_25046);
var inst_25048 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_25041,cljs.core._LT__EQ_,inst_25044,inst_25047);
var state_25171__$1 = state_25171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25171__$1,(44),inst_25048);
} else {
if((state_val_25172 === (43))){
var inst_25109 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25219_25334 = state_25171__$1;
(statearr_25219_25334[(2)] = inst_25109);

(statearr_25219_25334[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (61))){
var inst_25114 = (state_25171[(11)]);
var inst_24949 = (state_25171[(10)]);
var inst_25121 = cljs.core.PersistentHashSet.EMPTY;
var inst_25122 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25121,inst_25114);
var inst_25123 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_24949,inst_25122);
var state_25171__$1 = state_25171;
var statearr_25220_25335 = state_25171__$1;
(statearr_25220_25335[(2)] = inst_25123);

(statearr_25220_25335[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (29))){
var inst_24974 = (state_25171[(21)]);
var inst_24980 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24974);
var inst_24981 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24980)].join('');
var inst_24982 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24983 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24984 = cljs.core.PersistentHashMap.fromArrays(inst_24982,inst_24983);
var inst_24985 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24981,inst_24984);
var inst_24986 = (function(){throw inst_24985})();
var state_25171__$1 = state_25171;
var statearr_25221_25336 = state_25171__$1;
(statearr_25221_25336[(2)] = inst_24986);

(statearr_25221_25336[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (44))){
var inst_25050 = (state_25171[(2)]);
var inst_25051 = fluree.db.util.async.throw_err(inst_25050);
var state_25171__$1 = state_25171;
var statearr_25222_25337 = state_25171__$1;
(statearr_25222_25337[(2)] = inst_25051);

(statearr_25222_25337[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (6))){
var inst_24918 = (state_25171[(25)]);
var inst_24922 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24918);
var state_25171__$1 = state_25171;
var statearr_25223_25338 = state_25171__$1;
(statearr_25223_25338[(2)] = inst_24922);

(statearr_25223_25338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (28))){
var inst_24969 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25224_25339 = state_25171__$1;
(statearr_25224_25339[(2)] = inst_24969);

(statearr_25224_25339[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (64))){
var inst_25129 = (state_25171[(26)]);
var state_25171__$1 = state_25171;
var statearr_25225_25340 = state_25171__$1;
(statearr_25225_25340[(2)] = inst_25129);

(statearr_25225_25340[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (51))){
var inst_25105 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25226_25341 = state_25171__$1;
(statearr_25226_25341[(2)] = inst_25105);

(statearr_25226_25341[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (25))){
var inst_24964 = (state_25171[(2)]);
var state_25171__$1 = (function (){var statearr_25227 = state_25171;
(statearr_25227[(13)] = inst_24964);

return statearr_25227;
})();
if(cljs.core.truth_(limit)){
var statearr_25228_25342 = state_25171__$1;
(statearr_25228_25342[(1)] = (26));

} else {
var statearr_25229_25343 = state_25171__$1;
(statearr_25229_25343[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (34))){
var inst_24918 = (state_25171[(25)]);
var inst_25113 = (state_25171[(2)]);
var inst_25114 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_25113);
var state_25171__$1 = (function (){var statearr_25230 = state_25171;
(statearr_25230[(11)] = inst_25114);

return statearr_25230;
})();
var G__25231_25344 = inst_24918;
var G__25231_25345__$1 = (((G__25231_25344 instanceof cljs.core.Keyword))?G__25231_25344.fqn:null);
switch (G__25231_25345__$1) {
case "or":
var statearr_25232_25347 = state_25171__$1;
(statearr_25232_25347[(1)] = (58));


break;
case "and":
var statearr_25233_25348 = state_25171__$1;
(statearr_25233_25348[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25231_25345__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (17))){
var inst_25166 = (state_25171[(2)]);
var _ = (function (){var statearr_25234 = state_25171;
(statearr_25234[(4)] = cljs.core.rest((state_25171[(4)])));

return statearr_25234;
})();
var state_25171__$1 = state_25171;
var statearr_25235_25349 = state_25171__$1;
(statearr_25235_25349[(2)] = inst_25166);

(statearr_25235_25349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (3))){
var inst_25169 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25171__$1,inst_25169);
} else {
if((state_val_25172 === (12))){
var inst_24928 = (offset + limit);
var state_25171__$1 = state_25171;
var statearr_25236_25350 = state_25171__$1;
(statearr_25236_25350[(2)] = inst_24928);

(statearr_25236_25350[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (2))){
var inst_24920 = (state_25171[(9)]);
var _ = (function (){var statearr_25237 = state_25171;
(statearr_25237[(4)] = cljs.core.cons((5),(state_25171[(4)])));

return statearr_25237;
})();
var inst_24917 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_24918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24917,(0),null);
var inst_24919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24917,(1),null);
var inst_24920__$1 = limit;
var state_25171__$1 = (function (){var statearr_25238 = state_25171;
(statearr_25238[(25)] = inst_24918);

(statearr_25238[(16)] = inst_24919);

(statearr_25238[(9)] = inst_24920__$1);

return statearr_25238;
})();
if(cljs.core.truth_(inst_24920__$1)){
var statearr_25239_25351 = state_25171__$1;
(statearr_25239_25351[(1)] = (6));

} else {
var statearr_25240_25352 = state_25171__$1;
(statearr_25240_25352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (66))){
var inst_25134 = (state_25171[(7)]);
var state_25171__$1 = state_25171;
var statearr_25241_25353 = state_25171__$1;
(statearr_25241_25353[(2)] = inst_25134);

(statearr_25241_25353[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (23))){
var inst_24949 = (state_25171[(10)]);
var inst_24961 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_24949);
var state_25171__$1 = state_25171;
var statearr_25242_25354 = state_25171__$1;
(statearr_25242_25354[(2)] = inst_24961);

(statearr_25242_25354[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (47))){
var inst_25107 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25243_25355 = state_25171__$1;
(statearr_25243_25355[(2)] = inst_25107);

(statearr_25243_25355[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (35))){
var inst_24976 = (state_25171[(22)]);
var inst_24934 = (state_25171[(12)]);
var inst_24974 = (state_25171[(21)]);
var inst_25007 = (state_25171[(2)]);
var inst_25008 = fluree.db.util.async.throw_err(inst_25007);
var inst_25009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25010 = [inst_24974];
var inst_25011 = (new cljs.core.PersistentVector(null,1,(5),inst_25009,inst_25010,null));
var inst_25012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25013 = [inst_24974,inst_24976];
var inst_25014 = (new cljs.core.PersistentVector(null,2,(5),inst_25012,inst_25013,null));
var inst_25015 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25016 = [inst_24934];
var inst_25017 = cljs.core.PersistentHashMap.fromArrays(inst_25015,inst_25016);
var inst_25018 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_25011,cljs.core._LT_,inst_25014,inst_25017);
var state_25171__$1 = (function (){var statearr_25244 = state_25171;
(statearr_25244[(24)] = inst_25008);

return statearr_25244;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25171__$1,(36),inst_25018);
} else {
if((state_val_25172 === (76))){
var inst_25128 = (state_25171[(27)]);
var inst_24956 = (state_25171[(28)]);
var inst_24948 = inst_24956;
var inst_24949 = inst_25128;
var state_25171__$1 = (function (){var statearr_25245 = state_25171;
(statearr_25245[(18)] = inst_24948);

(statearr_25245[(10)] = inst_24949);

return statearr_25245;
})();
var statearr_25246_25356 = state_25171__$1;
(statearr_25246_25356[(2)] = null);

(statearr_25246_25356[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (19))){
var inst_25163 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25247_25357 = state_25171__$1;
(statearr_25247_25357[(2)] = inst_25163);

(statearr_25247_25357[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (57))){
var inst_24918 = (state_25171[(25)]);
var inst_25129 = (state_25171[(26)]);
var inst_25128 = (state_25171[(2)]);
var inst_25129__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24918);
var state_25171__$1 = (function (){var statearr_25248 = state_25171;
(statearr_25248[(27)] = inst_25128);

(statearr_25248[(26)] = inst_25129__$1);

return statearr_25248;
})();
if(inst_25129__$1){
var statearr_25249_25358 = state_25171__$1;
(statearr_25249_25358[(1)] = (63));

} else {
var statearr_25250_25359 = state_25171__$1;
(statearr_25250_25359[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (68))){
var inst_25149 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
if(cljs.core.truth_(inst_25149)){
var statearr_25251_25360 = state_25171__$1;
(statearr_25251_25360[(1)] = (75));

} else {
var statearr_25252_25361 = state_25171__$1;
(statearr_25252_25361[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (11))){
var inst_24919 = (state_25171[(16)]);
var inst_24934 = (state_25171[(2)]);
var inst_24935 = cljs.core.not_empty(inst_24919);
var state_25171__$1 = (function (){var statearr_25254 = state_25171;
(statearr_25254[(12)] = inst_24934);

return statearr_25254;
})();
if(cljs.core.truth_(inst_24935)){
var statearr_25255_25362 = state_25171__$1;
(statearr_25255_25362[(1)] = (15));

} else {
var statearr_25256_25363 = state_25171__$1;
(statearr_25256_25363[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (9))){
var state_25171__$1 = state_25171;
if(cljs.core.truth_(offset)){
var statearr_25257_25364 = state_25171__$1;
(statearr_25257_25364[(1)] = (12));

} else {
var statearr_25258_25365 = state_25171__$1;
(statearr_25258_25365[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (5))){
var _ = (function (){var statearr_25259 = state_25171;
(statearr_25259[(4)] = cljs.core.rest((state_25171[(4)])));

return statearr_25259;
})();
var state_25171__$1 = state_25171;
var ex25253 = (state_25171__$1[(2)]);
var statearr_25260_25366 = state_25171__$1;
(statearr_25260_25366[(5)] = ex25253);


if((ex25253 instanceof Error)){
var statearr_25261_25367 = state_25171__$1;
(statearr_25261_25367[(1)] = (4));

(statearr_25261_25367[(5)] = null);

} else {
throw ex25253;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (14))){
var inst_24931 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25262_25368 = state_25171__$1;
(statearr_25262_25368[(2)] = inst_24931);

(statearr_25262_25368[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (45))){
var inst_24976 = (state_25171[(22)]);
var inst_24934 = (state_25171[(12)]);
var inst_24974 = (state_25171[(21)]);
var inst_25055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25056 = [inst_24974,inst_24976];
var inst_25057 = (new cljs.core.PersistentVector(null,2,(5),inst_25055,inst_25056,null));
var inst_25058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25059 = [inst_24974];
var inst_25060 = (new cljs.core.PersistentVector(null,1,(5),inst_25058,inst_25059,null));
var inst_25061 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25062 = [inst_24934];
var inst_25063 = cljs.core.PersistentHashMap.fromArrays(inst_25061,inst_25062);
var inst_25064 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_25057,cljs.core._LT__EQ_,inst_25060,inst_25063);
var state_25171__$1 = state_25171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25171__$1,(48),inst_25064);
} else {
if((state_val_25172 === (53))){
var inst_24976 = (state_25171[(22)]);
var inst_24934 = (state_25171[(12)]);
var inst_24974 = (state_25171[(21)]);
var inst_25087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25088 = [inst_24974];
var inst_25089 = (new cljs.core.PersistentVector(null,1,(5),inst_25087,inst_25088,null));
var inst_25090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25091 = [inst_24974,inst_24976];
var inst_25092 = (new cljs.core.PersistentVector(null,2,(5),inst_25090,inst_25091,null));
var inst_25093 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25094 = [inst_24934];
var inst_25095 = cljs.core.PersistentHashMap.fromArrays(inst_25093,inst_25094);
var inst_25096 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_25089,cljs.core._LT__EQ_,inst_25092,inst_25095);
var state_25171__$1 = state_25171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25171__$1,(56),inst_25096);
} else {
if((state_val_25172 === (78))){
var inst_25128 = (state_25171[(27)]);
var inst_25152 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_25128);
var state_25171__$1 = state_25171;
var statearr_25263_25369 = state_25171__$1;
(statearr_25263_25369[(2)] = inst_25152);

(statearr_25263_25369[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (26))){
var inst_24964 = (state_25171[(13)]);
var inst_24966 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_24964);
var state_25171__$1 = state_25171;
var statearr_25264_25370 = state_25171__$1;
(statearr_25264_25370[(2)] = inst_24966);

(statearr_25264_25370[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (16))){
var state_25171__$1 = state_25171;
var statearr_25265_25371 = state_25171__$1;
(statearr_25265_25371[(2)] = null);

(statearr_25265_25371[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (79))){
var inst_25128 = (state_25171[(27)]);
var state_25171__$1 = state_25171;
var statearr_25266_25372 = state_25171__$1;
(statearr_25266_25372[(2)] = inst_25128);

(statearr_25266_25372[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (38))){
var inst_24975 = (state_25171[(14)]);
var inst_24993 = (state_25171[(15)]);
var inst_25037 = (inst_24993.cljs$core$IFn$_invoke$arity$2 ? inst_24993.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_24975) : inst_24993.call(null,cljs.core._GT_,inst_24975));
var state_25171__$1 = state_25171;
if(cljs.core.truth_(inst_25037)){
var statearr_25267_25373 = state_25171__$1;
(statearr_25267_25373[(1)] = (41));

} else {
var statearr_25268_25374 = state_25171__$1;
(statearr_25268_25374[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (30))){
var state_25171__$1 = state_25171;
var statearr_25269_25375 = state_25171__$1;
(statearr_25269_25375[(2)] = null);

(statearr_25269_25375[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (73))){
var inst_24934 = (state_25171[(12)]);
var state_25171__$1 = state_25171;
var statearr_25270_25376 = state_25171__$1;
(statearr_25270_25376[(2)] = inst_24934);

(statearr_25270_25376[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (10))){
var state_25171__$1 = state_25171;
var statearr_25271_25377 = state_25171__$1;
(statearr_25271_25377[(2)] = null);

(statearr_25271_25377[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (18))){
var inst_24955 = (state_25171[(20)]);
var inst_24948 = (state_25171[(18)]);
var inst_24954 = cljs.core.seq(inst_24948);
var inst_24955__$1 = cljs.core.first(inst_24954);
var inst_24956 = cljs.core.next(inst_24954);
var inst_24957 = cljs.core.not(inst_24955__$1);
var state_25171__$1 = (function (){var statearr_25272 = state_25171;
(statearr_25272[(20)] = inst_24955__$1);

(statearr_25272[(28)] = inst_24956);

return statearr_25272;
})();
if(inst_24957){
var statearr_25273_25378 = state_25171__$1;
(statearr_25273_25378[(1)] = (20));

} else {
var statearr_25274_25379 = state_25171__$1;
(statearr_25274_25379[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (52))){
var inst_25082 = (state_25171[(2)]);
var inst_25083 = fluree.db.util.async.throw_err(inst_25082);
var state_25171__$1 = state_25171;
var statearr_25275_25380 = state_25171__$1;
(statearr_25275_25380[(2)] = inst_25083);

(statearr_25275_25380[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (67))){
var inst_24918 = (state_25171[(25)]);
var inst_25137 = (state_25171[(8)]);
var inst_25137__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24918);
var state_25171__$1 = (function (){var statearr_25276 = state_25171;
(statearr_25276[(8)] = inst_25137__$1);

return statearr_25276;
})();
if(inst_25137__$1){
var statearr_25277_25381 = state_25171__$1;
(statearr_25277_25381[(1)] = (69));

} else {
var statearr_25278_25382 = state_25171__$1;
(statearr_25278_25382[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (71))){
var inst_25147 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25279_25383 = state_25171__$1;
(statearr_25279_25383[(2)] = inst_25147);

(statearr_25279_25383[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (42))){
var inst_24975 = (state_25171[(14)]);
var inst_24993 = (state_25171[(15)]);
var inst_25053 = (inst_24993.cljs$core$IFn$_invoke$arity$2 ? inst_24993.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_24975) : inst_24993.call(null,cljs.core._GT__EQ_,inst_24975));
var state_25171__$1 = state_25171;
if(cljs.core.truth_(inst_25053)){
var statearr_25280_25384 = state_25171__$1;
(statearr_25280_25384[(1)] = (45));

} else {
var statearr_25281_25385 = state_25171__$1;
(statearr_25281_25385[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (80))){
var inst_25155 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
var statearr_25282_25386 = state_25171__$1;
(statearr_25282_25386[(2)] = inst_25155);

(statearr_25282_25386[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (37))){
var inst_24976 = (state_25171[(22)]);
var inst_24934 = (state_25171[(12)]);
var inst_24974 = (state_25171[(21)]);
var inst_25026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25027 = [inst_24974,inst_24976];
var inst_25028 = (new cljs.core.PersistentVector(null,2,(5),inst_25026,inst_25027,null));
var inst_25029 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25030 = [inst_24934];
var inst_25031 = cljs.core.PersistentHashMap.fromArrays(inst_25029,inst_25030);
var inst_25032 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_25028,inst_25031);
var state_25171__$1 = state_25171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25171__$1,(40),inst_25032);
} else {
if((state_val_25172 === (63))){
var inst_25128 = (state_25171[(27)]);
var inst_25131 = cljs.core.empty_QMARK_(inst_25128);
var state_25171__$1 = state_25171;
var statearr_25283_25387 = state_25171__$1;
(statearr_25283_25387[(2)] = inst_25131);

(statearr_25283_25387[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (8))){
var inst_24925 = (state_25171[(2)]);
var state_25171__$1 = state_25171;
if(cljs.core.truth_(inst_24925)){
var statearr_25284_25388 = state_25171__$1;
(statearr_25284_25388[(1)] = (9));

} else {
var statearr_25285_25389 = state_25171__$1;
(statearr_25285_25389[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25172 === (49))){
var inst_24976 = (state_25171[(22)]);
var inst_24934 = (state_25171[(12)]);
var inst_24974 = (state_25171[(21)]);
var inst_25071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25072 = [inst_24974];
var inst_25073 = (new cljs.core.PersistentVector(null,1,(5),inst_25071,inst_25072,null));
var inst_25074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25075 = [inst_24974,inst_24976];
var inst_25076 = (new cljs.core.PersistentVector(null,2,(5),inst_25074,inst_25075,null));
var inst_25077 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_25078 = [inst_24934];
var inst_25079 = cljs.core.PersistentHashMap.fromArrays(inst_25077,inst_25078);
var inst_25080 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_25073,cljs.core._LT_,inst_25076,inst_25079);
var state_25171__$1 = state_25171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25171__$1,(52),inst_25080);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2684__auto__ = null;
var fluree$db$query$fql$state_machine__2684__auto____0 = (function (){
var statearr_25286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25286[(0)] = fluree$db$query$fql$state_machine__2684__auto__);

(statearr_25286[(1)] = (1));

return statearr_25286;
});
var fluree$db$query$fql$state_machine__2684__auto____1 = (function (state_25171){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25171);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25287){var ex__2687__auto__ = e25287;
var statearr_25288_25390 = state_25171;
(statearr_25288_25390[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25171[(4)]))){
var statearr_25289_25391 = state_25171;
(statearr_25289_25391[(1)] = cljs.core.first((state_25171[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25392 = state_25171;
state_25171 = G__25392;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2684__auto__ = function(state_25171){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2684__auto____1.call(this,state_25171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2684__auto____0;
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2684__auto____1;
return fluree$db$query$fql$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25290 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25290[(6)] = c__2706__auto__);

return statearr_25290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__5045__auto__ = cljs.core.every_QMARK_((function (p1__25393_SHARP_){
return ((typeof p1__25393_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__25393_SHARP_)));
}),select_smt);
if(or__5045__auto__){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__25394_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__25394_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__25398 = vars;
var vec__25399 = G__25398;
var seq__25400 = cljs.core.seq(vec__25399);
var first__25401 = cljs.core.first(seq__25400);
var seq__25400__$1 = cljs.core.next(seq__25400);
var var$ = first__25401;
var r = seq__25400__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__25398__$1 = G__25398;
var all_vars__$1 = all_vars;
while(true){
var vec__25406 = G__25398__$1;
var seq__25407 = cljs.core.seq(vec__25406);
var first__25408 = cljs.core.first(seq__25407);
var seq__25407__$1 = cljs.core.next(seq__25407);
var var$__$1 = first__25408;
var r__$1 = seq__25407__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__25409 = cljs.core.set(all_vars__$2);
return (fexpr__25409.cljs$core$IFn$_invoke$arity$1 ? fexpr__25409.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__25409.call(null,var$__$1));
})())){
var G__25410 = r__$1;
var G__25411 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__25398__$1 = G__25410;
all_vars__$1 = G__25411;
continue;
} else {
var G__25412 = r__$1;
var G__25413 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__25398__$1 = G__25412;
all_vars__$1 = G__25413;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25448){
var state_val_25449 = (state_25448[(1)]);
if((state_val_25449 === (1))){
var inst_25421 = functionArray;
var inst_25422 = cljs.core.seq(inst_25421);
var inst_25423 = cljs.core.first(inst_25422);
var inst_25424 = cljs.core.next(inst_25422);
var inst_25425 = cljs.core.PersistentVector.EMPTY;
var inst_25426 = inst_25421;
var inst_25427 = inst_25425;
var state_25448__$1 = (function (){var statearr_25450 = state_25448;
(statearr_25450[(7)] = inst_25423);

(statearr_25450[(8)] = inst_25427);

(statearr_25450[(9)] = inst_25424);

(statearr_25450[(10)] = inst_25426);

return statearr_25450;
})();
var statearr_25451_25464 = state_25448__$1;
(statearr_25451_25464[(2)] = null);

(statearr_25451_25464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25449 === (2))){
var inst_25433 = (state_25448[(11)]);
var inst_25426 = (state_25448[(10)]);
var inst_25432 = cljs.core.seq(inst_25426);
var inst_25433__$1 = cljs.core.first(inst_25432);
var inst_25434 = cljs.core.next(inst_25432);
var state_25448__$1 = (function (){var statearr_25452 = state_25448;
(statearr_25452[(11)] = inst_25433__$1);

(statearr_25452[(12)] = inst_25434);

return statearr_25452;
})();
if(cljs.core.truth_(inst_25433__$1)){
var statearr_25453_25465 = state_25448__$1;
(statearr_25453_25465[(1)] = (4));

} else {
var statearr_25454_25466 = state_25448__$1;
(statearr_25454_25466[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25449 === (3))){
var inst_25446 = (state_25448[(2)]);
var state_25448__$1 = state_25448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25448__$1,inst_25446);
} else {
if((state_val_25449 === (4))){
var inst_25433 = (state_25448[(11)]);
var inst_25436 = (inst_25433.cljs$core$IFn$_invoke$arity$1 ? inst_25433.cljs$core$IFn$_invoke$arity$1(tuple) : inst_25433.call(null,tuple));
var state_25448__$1 = state_25448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25448__$1,(7),inst_25436);
} else {
if((state_val_25449 === (5))){
var inst_25427 = (state_25448[(8)]);
var state_25448__$1 = state_25448;
var statearr_25455_25467 = state_25448__$1;
(statearr_25455_25467[(2)] = inst_25427);

(statearr_25455_25467[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25449 === (6))){
var inst_25444 = (state_25448[(2)]);
var state_25448__$1 = state_25448;
var statearr_25456_25468 = state_25448__$1;
(statearr_25456_25468[(2)] = inst_25444);

(statearr_25456_25468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25449 === (7))){
var inst_25427 = (state_25448[(8)]);
var inst_25434 = (state_25448[(12)]);
var inst_25438 = (state_25448[(2)]);
var inst_25439 = fluree.db.util.async.throw_err(inst_25438);
var inst_25440 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25427,inst_25439);
var inst_25426 = inst_25434;
var inst_25427__$1 = inst_25440;
var state_25448__$1 = (function (){var statearr_25457 = state_25448;
(statearr_25457[(8)] = inst_25427__$1);

(statearr_25457[(10)] = inst_25426);

return statearr_25457;
})();
var statearr_25458_25469 = state_25448__$1;
(statearr_25458_25469[(2)] = null);

(statearr_25458_25469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2684__auto____0 = (function (){
var statearr_25459 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25459[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2684__auto__);

(statearr_25459[(1)] = (1));

return statearr_25459;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2684__auto____1 = (function (state_25448){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25448);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25460){var ex__2687__auto__ = e25460;
var statearr_25461_25470 = state_25448;
(statearr_25461_25470[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25448[(4)]))){
var statearr_25462_25471 = state_25448;
(statearr_25462_25471[(1)] = cljs.core.first((state_25448[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25472 = state_25448;
state_25448 = G__25472;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2684__auto__ = function(state_25448){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2684__auto____1.call(this,state_25448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2684__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2684__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25463 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25463[(6)] = c__2706__auto__);

return statearr_25463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__25473){
var vec__25474 = p__25473;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25474,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25474,(1),null);
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25488){
var state_val_25489 = (state_25488[(1)]);
if((state_val_25489 === (1))){
var inst_25477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25478 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_25479 = [query_map,_id,query_opts];
var inst_25480 = cljs.core.PersistentHashMap.fromArrays(inst_25478,inst_25479);
var inst_25481 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_25480) : fluree.db.query.fql.query.call(null,db,inst_25480));
var state_25488__$1 = (function (){var statearr_25490 = state_25488;
(statearr_25490[(7)] = inst_25477);

return statearr_25490;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25488__$1,(2),inst_25481);
} else {
if((state_val_25489 === (2))){
var inst_25477 = (state_25488[(7)]);
var inst_25483 = (state_25488[(2)]);
var inst_25484 = fluree.db.util.async.throw_err(inst_25483);
var inst_25485 = [tuple_index,inst_25484];
var inst_25486 = (new cljs.core.PersistentVector(null,2,(5),inst_25477,inst_25485,null));
var state_25488__$1 = state_25488;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25488__$1,inst_25486);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0 = (function (){
var statearr_25491 = [null,null,null,null,null,null,null,null];
(statearr_25491[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2684__auto__);

(statearr_25491[(1)] = (1));

return statearr_25491;
});
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1 = (function (state_25488){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25488);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25492){var ex__2687__auto__ = e25492;
var statearr_25493_25496 = state_25488;
(statearr_25493_25496[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25488[(4)]))){
var statearr_25494_25497 = state_25488;
(statearr_25494_25497[(1)] = cljs.core.first((state_25488[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25498 = state_25488;
state_25488 = G__25498;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__ = function(state_25488){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1.call(this,state_25488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25495 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25495[(6)] = c__2706__auto__);

return statearr_25495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__25499 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25499,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25499,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25562){
var state_val_25563 = (state_25562[(1)]);
if((state_val_25563 === (7))){
var inst_25557 = (state_25562[(2)]);
var _ = (function (){var statearr_25564 = state_25562;
(statearr_25564[(4)] = cljs.core.rest((state_25562[(4)])));

return statearr_25564;
})();
var state_25562__$1 = state_25562;
var statearr_25565_25656 = state_25562__$1;
(statearr_25565_25656[(2)] = inst_25557);

(statearr_25565_25656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (20))){
var inst_25548 = (state_25562[(2)]);
var state_25562__$1 = state_25562;
var statearr_25566_25657 = state_25562__$1;
(statearr_25566_25657[(2)] = inst_25548);

(statearr_25566_25657[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (1))){
var state_25562__$1 = state_25562;
var statearr_25567_25658 = state_25562__$1;
(statearr_25567_25658[(2)] = null);

(statearr_25567_25658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (4))){
var inst_25504 = (state_25562[(2)]);
var state_25562__$1 = state_25562;
var statearr_25568_25659 = state_25562__$1;
(statearr_25568_25659[(2)] = inst_25504);

(statearr_25568_25659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (15))){
var inst_25524 = (state_25562[(7)]);
var inst_25533 = cljs.core.second(inst_25524);
var inst_25534 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_25533);
var inst_25535 = (inst_25534 > max_fuel);
var state_25562__$1 = state_25562;
if(cljs.core.truth_(inst_25535)){
var statearr_25569_25660 = state_25562__$1;
(statearr_25569_25660[(1)] = (18));

} else {
var statearr_25570_25661 = state_25562__$1;
(statearr_25570_25661[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (13))){
var state_25562__$1 = state_25562;
var statearr_25571_25662 = state_25562__$1;
(statearr_25571_25662[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (6))){
var inst_25512 = (state_25562[(8)]);
var state_25562__$1 = state_25562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25562__$1,(8),inst_25512);
} else {
if((state_val_25563 === (17))){
var inst_25551 = (state_25562[(2)]);
var state_25562__$1 = state_25562;
var statearr_25573_25663 = state_25562__$1;
(statearr_25573_25663[(2)] = inst_25551);

(statearr_25573_25663[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (3))){
var inst_25560 = (state_25562[(2)]);
var state_25562__$1 = state_25562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25562__$1,inst_25560);
} else {
if((state_val_25563 === (12))){
var inst_25513 = (state_25562[(9)]);
var inst_25524 = (state_25562[(7)]);
var inst_25530 = (inst_25513.cljs$core$IFn$_invoke$arity$0 ? inst_25513.cljs$core$IFn$_invoke$arity$0() : inst_25513.call(null));
var state_25562__$1 = (function (){var statearr_25574 = state_25562;
(statearr_25574[(10)] = inst_25530);

return statearr_25574;
})();
var statearr_25575_25664 = state_25562__$1;
(statearr_25575_25664[(2)] = inst_25524);

(statearr_25575_25664[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (2))){
var inst_25513 = (state_25562[(9)]);
var inst_25512 = (state_25562[(8)]);
var _ = (function (){var statearr_25576 = state_25562;
(statearr_25576[(4)] = cljs.core.cons((5),(state_25562[(4)])));

return statearr_25576;
})();
var inst_25510 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_25511 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_25512__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_25513__$1 = (function (){var expandMaps = inst_25510;
var queue_ch = inst_25511;
var res_ch = inst_25512__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_25514 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_25515 = cljs.core.volatile_BANG_((0));
var inst_25516 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25514,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_25515);
var inst_25517 = (function (){var expandMaps = inst_25510;
var queue_ch = inst_25511;
var res_ch = inst_25512__$1;
var stop_BANG_ = inst_25513__$1;
var opts_STAR_ = inst_25516;
return (function (tuple_res,port){
var c__2706__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25609){
var state_val_25610 = (state_25609[(1)]);
if((state_val_25610 === (7))){
var state_25609__$1 = state_25609;
var statearr_25611_25665 = state_25609__$1;
(statearr_25611_25665[(2)] = tuple_res);

(statearr_25611_25665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25610 === (1))){
var state_25609__$1 = state_25609;
var statearr_25612_25666 = state_25609__$1;
(statearr_25612_25666[(2)] = null);

(statearr_25612_25666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25610 === (4))){
var inst_25577 = (state_25609[(2)]);
var inst_25578 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_25577);
var inst_25579 = cljs.core.async.close_BANG_(port);
var state_25609__$1 = (function (){var statearr_25613 = state_25609;
(statearr_25613[(7)] = inst_25578);

return statearr_25613;
})();
var statearr_25614_25667 = state_25609__$1;
(statearr_25614_25667[(2)] = inst_25579);

(statearr_25614_25667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25610 === (6))){
var inst_25586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25587 = [tuple_res];
var inst_25588 = (new cljs.core.PersistentVector(null,1,(5),inst_25586,inst_25587,null));
var state_25609__$1 = state_25609;
var statearr_25615_25668 = state_25609__$1;
(statearr_25615_25668[(2)] = inst_25588);

(statearr_25615_25668[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25610 === (3))){
var inst_25607 = (state_25609[(2)]);
var state_25609__$1 = state_25609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25609__$1,inst_25607);
} else {
if((state_val_25610 === (2))){
var ___$1 = (function (){var statearr_25617 = state_25609;
(statearr_25617[(4)] = cljs.core.cons((5),(state_25609[(4)])));

return statearr_25617;
})();
var state_25609__$1 = state_25609;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_25618_25669 = state_25609__$1;
(statearr_25618_25669[(1)] = (6));

} else {
var statearr_25619_25670 = state_25609__$1;
(statearr_25619_25670[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25610 === (9))){
var inst_25591 = (state_25609[(8)]);
var inst_25593 = (state_25609[(9)]);
var inst_25600 = (state_25609[(2)]);
var inst_25601 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_25591,inst_25600);
var inst_25602 = (inst_25593.cljs$core$IFn$_invoke$arity$1 ? inst_25593.cljs$core$IFn$_invoke$arity$1(inst_25601) : inst_25593.call(null,inst_25601));
var inst_25603 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_25602);
var inst_25604 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_25620 = state_25609;
(statearr_25620[(4)] = cljs.core.rest((state_25609[(4)])));

return statearr_25620;
})();
var state_25609__$1 = (function (){var statearr_25621 = state_25609;
(statearr_25621[(10)] = inst_25603);

return statearr_25621;
})();
var statearr_25622_25671 = state_25609__$1;
(statearr_25622_25671[(2)] = inst_25604);

(statearr_25622_25671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25610 === (5))){
var ___$1 = (function (){var statearr_25623 = state_25609;
(statearr_25623[(4)] = cljs.core.rest((state_25609[(4)])));

return statearr_25623;
})();
var state_25609__$1 = state_25609;
var ex25616 = (state_25609__$1[(2)]);
var statearr_25624_25672 = state_25609__$1;
(statearr_25624_25672[(5)] = ex25616);


var statearr_25625_25673 = state_25609__$1;
(statearr_25625_25673[(1)] = (4));

(statearr_25625_25673[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25610 === (8))){
var inst_25591 = (state_25609[(8)]);
var inst_25591__$1 = (state_25609[(2)]);
var inst_25592 = cljs.core.volatile_BANG_((0));
var inst_25593 = (function (){var tuple_res_SINGLEQUOTE_ = inst_25591__$1;
var query_fuel = inst_25592;
return (function (p1__25503_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__25503_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25503_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_25594 = cljs.core.PersistentVector.EMPTY;
var inst_25595 = (function (){var tuple_res_SINGLEQUOTE_ = inst_25591__$1;
var query_fuel = inst_25592;
return (function (p1__25502_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__25502_SHARP_);
});
})();
var inst_25596 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_25595,expandMaps);
var inst_25597 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_25596);
var inst_25598 = cljs.core.async.into(inst_25594,inst_25597);
var state_25609__$1 = (function (){var statearr_25626 = state_25609;
(statearr_25626[(8)] = inst_25591__$1);

(statearr_25626[(9)] = inst_25593);

return statearr_25626;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25609__$1,(9),inst_25598);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0 = (function (){
var statearr_25627 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25627[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__);

(statearr_25627[(1)] = (1));

return statearr_25627;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1 = (function (state_25609){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25609);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25628){var ex__2687__auto__ = e25628;
var statearr_25629_25674 = state_25609;
(statearr_25629_25674[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25609[(4)]))){
var statearr_25630_25675 = state_25609;
(statearr_25630_25675[(1)] = cljs.core.first((state_25609[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25676 = state_25609;
state_25609 = G__25676;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = function(state_25609){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1.call(this,state_25609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25631 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25631[(6)] = c__2706__auto____$1);

return statearr_25631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto____$1;
});
})();
var inst_25518 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_25511,tuples_res);
var inst_25519 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_25512__$1,inst_25517,inst_25511);
var inst_25520 = cljs.core.PersistentVector.EMPTY;
var inst_25521 = inst_25520;
var state_25562__$1 = (function (){var statearr_25632 = state_25562;
(statearr_25632[(9)] = inst_25513__$1);

(statearr_25632[(8)] = inst_25512__$1);

(statearr_25632[(11)] = inst_25518);

(statearr_25632[(12)] = inst_25521);

(statearr_25632[(13)] = inst_25519);

return statearr_25632;
})();
var statearr_25633_25677 = state_25562__$1;
(statearr_25633_25677[(2)] = null);

(statearr_25633_25677[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (19))){
var inst_25521 = (state_25562[(12)]);
var inst_25524 = (state_25562[(7)]);
var inst_25544 = cljs.core.first(inst_25524);
var inst_25545 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25521,inst_25544);
var inst_25521__$1 = inst_25545;
var state_25562__$1 = (function (){var statearr_25634 = state_25562;
(statearr_25634[(12)] = inst_25521__$1);

return statearr_25634;
})();
var statearr_25635_25678 = state_25562__$1;
(statearr_25635_25678[(2)] = null);

(statearr_25635_25678[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (11))){
var inst_25555 = (state_25562[(2)]);
var state_25562__$1 = state_25562;
var statearr_25637_25679 = state_25562__$1;
(statearr_25637_25679[(2)] = inst_25555);

(statearr_25637_25679[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (9))){
var inst_25521 = (state_25562[(12)]);
var state_25562__$1 = state_25562;
var statearr_25638_25680 = state_25562__$1;
(statearr_25638_25680[(2)] = inst_25521);

(statearr_25638_25680[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (5))){
var _ = (function (){var statearr_25639 = state_25562;
(statearr_25639[(4)] = cljs.core.rest((state_25562[(4)])));

return statearr_25639;
})();
var state_25562__$1 = state_25562;
var ex25636 = (state_25562__$1[(2)]);
var statearr_25640_25681 = state_25562__$1;
(statearr_25640_25681[(5)] = ex25636);


if((ex25636 instanceof Error)){
var statearr_25641_25682 = state_25562__$1;
(statearr_25641_25682[(1)] = (4));

(statearr_25641_25682[(5)] = null);

} else {
throw ex25636;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (14))){
var inst_25553 = (state_25562[(2)]);
var state_25562__$1 = state_25562;
var statearr_25642_25683 = state_25562__$1;
(statearr_25642_25683[(2)] = inst_25553);

(statearr_25642_25683[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (16))){
var state_25562__$1 = state_25562;
var statearr_25643_25684 = state_25562__$1;
(statearr_25643_25684[(2)] = null);

(statearr_25643_25684[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (10))){
var inst_25524 = (state_25562[(7)]);
var inst_25528 = fluree.db.util.core.exception_QMARK_(inst_25524);
var state_25562__$1 = state_25562;
if(inst_25528){
var statearr_25644_25685 = state_25562__$1;
(statearr_25644_25685[(1)] = (12));

} else {
var statearr_25645_25686 = state_25562__$1;
(statearr_25645_25686[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (18))){
var inst_25513 = (state_25562[(9)]);
var inst_25537 = (inst_25513.cljs$core$IFn$_invoke$arity$0 ? inst_25513.cljs$core$IFn$_invoke$arity$0() : inst_25513.call(null));
var inst_25538 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_25539 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25540 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_25541 = cljs.core.PersistentHashMap.fromArrays(inst_25539,inst_25540);
var inst_25542 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25538,inst_25541);
var state_25562__$1 = (function (){var statearr_25646 = state_25562;
(statearr_25646[(14)] = inst_25537);

return statearr_25646;
})();
var statearr_25647_25687 = state_25562__$1;
(statearr_25647_25687[(2)] = inst_25542);

(statearr_25647_25687[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25563 === (8))){
var inst_25524 = (state_25562[(7)]);
var inst_25524__$1 = (state_25562[(2)]);
var inst_25525 = (inst_25524__$1 == null);
var state_25562__$1 = (function (){var statearr_25648 = state_25562;
(statearr_25648[(7)] = inst_25524__$1);

return statearr_25648;
})();
if(cljs.core.truth_(inst_25525)){
var statearr_25649_25688 = state_25562__$1;
(statearr_25649_25688[(1)] = (9));

} else {
var statearr_25650_25689 = state_25562__$1;
(statearr_25650_25689[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0 = (function (){
var statearr_25651 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25651[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__);

(statearr_25651[(1)] = (1));

return statearr_25651;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1 = (function (state_25562){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25562);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25652){var ex__2687__auto__ = e25652;
var statearr_25653_25690 = state_25562;
(statearr_25653_25690[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25562[(4)]))){
var statearr_25654_25691 = state_25562;
(statearr_25654_25691[(1)] = cljs.core.first((state_25562[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25692 = state_25562;
state_25562 = G__25692;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = function(state_25562){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1.call(this,state_25562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25655 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25655[(6)] = c__2706__auto__);

return statearr_25655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__25693 = select;
var map__25693__$1 = cljs.core.__destructure_map(map__25693);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25693__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25693__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25693__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__25696 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25696,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25696,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25696,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__25694_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25694_SHARP_,compare_idx));
}):(function (p1__25695_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25695_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__25701 = arguments.length;
switch (G__25701) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__25702,p__25703,group_limit,opts){
var map__25704 = p__25702;
var map__25704__$1 = cljs.core.__destructure_map(map__25704);
var res = map__25704__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25704__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25705 = p__25703;
var map__25705__$1 = cljs.core.__destructure_map(map__25705);
var select_spec = map__25705__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25705__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25705__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25705__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25705__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25705__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25705__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25705__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25705__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25705__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25705__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25842){
var state_val_25843 = (state_25842[(1)]);
if((state_val_25843 === (7))){
var inst_25712 = (state_25842[(7)]);
var state_25842__$1 = state_25842;
var statearr_25844_25946 = state_25842__$1;
(statearr_25844_25946[(2)] = inst_25712);

(statearr_25844_25946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (59))){
var inst_25835 = (state_25842[(2)]);
var state_25842__$1 = state_25842;
var statearr_25845_25947 = state_25842__$1;
(statearr_25845_25947[(2)] = inst_25835);

(statearr_25845_25947[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (20))){
var inst_25748 = (state_25842[(8)]);
var inst_25751 = (state_25842[(9)]);
var inst_25747 = (state_25842[(2)]);
var inst_25748__$1 = cljs.core.__destructure_map(inst_25747);
var inst_25749 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25748__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25750 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25748__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25751__$1 = offset;
var state_25842__$1 = (function (){var statearr_25846 = state_25842;
(statearr_25846[(8)] = inst_25748__$1);

(statearr_25846[(10)] = inst_25750);

(statearr_25846[(11)] = inst_25749);

(statearr_25846[(9)] = inst_25751__$1);

return statearr_25846;
})();
if(cljs.core.truth_(inst_25751__$1)){
var statearr_25847_25948 = state_25842__$1;
(statearr_25847_25948[(1)] = (21));

} else {
var statearr_25848_25949 = state_25842__$1;
(statearr_25848_25949[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (58))){
var inst_25827 = (state_25842[(12)]);
var state_25842__$1 = state_25842;
var statearr_25849_25950 = state_25842__$1;
(statearr_25849_25950[(2)] = inst_25827);

(statearr_25849_25950[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (60))){
var inst_25831 = (state_25842[(2)]);
var inst_25832 = fluree.db.util.async.throw_err(inst_25831);
var state_25842__$1 = state_25842;
var statearr_25850_25951 = state_25842__$1;
(statearr_25850_25951[(2)] = inst_25832);

(statearr_25850_25951[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (27))){
var inst_25763 = cljs.core.not(inVector_QMARK_);
var state_25842__$1 = state_25842;
var statearr_25851_25952 = state_25842__$1;
(statearr_25851_25952[(2)] = inst_25763);

(statearr_25851_25952[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (1))){
var state_25842__$1 = state_25842;
var statearr_25852_25953 = state_25842__$1;
(statearr_25852_25953[(2)] = null);

(statearr_25852_25953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (24))){
var state_25842__$1 = state_25842;
var statearr_25853_25954 = state_25842__$1;
(statearr_25853_25954[(2)] = offset);

(statearr_25853_25954[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (55))){
var inst_25821 = (state_25842[(13)]);
var state_25842__$1 = state_25842;
var statearr_25854_25955 = state_25842__$1;
(statearr_25854_25955[(2)] = inst_25821);

(statearr_25854_25955[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (39))){
var inst_25789 = (state_25842[(14)]);
var inst_25791 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25792 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25789,inst_25791);
var state_25842__$1 = state_25842;
var statearr_25855_25956 = state_25842__$1;
(statearr_25855_25956[(2)] = inst_25792);

(statearr_25855_25956[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (46))){
var inst_25801 = (state_25842[(15)]);
var state_25842__$1 = state_25842;
var statearr_25856_25957 = state_25842__$1;
(statearr_25856_25957[(2)] = inst_25801);

(statearr_25856_25957[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (4))){
var inst_25706 = (state_25842[(2)]);
var state_25842__$1 = state_25842;
var statearr_25857_25958 = state_25842__$1;
(statearr_25857_25958[(2)] = inst_25706);

(statearr_25857_25958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (54))){
var inst_25821 = (state_25842[(13)]);
var inst_25815 = (state_25842[(16)]);
var inst_25823 = cljs.core.PersistentVector.EMPTY;
var inst_25824 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_25823,inst_25815,inst_25821);
var state_25842__$1 = state_25842;
var statearr_25858_25959 = state_25842__$1;
(statearr_25858_25959[(2)] = inst_25824);

(statearr_25858_25959[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (15))){
var inst_25733 = (state_25842[(17)]);
var inst_25735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25736 = [inst_25733];
var inst_25737 = (new cljs.core.PersistentVector(null,1,(5),inst_25735,inst_25736,null));
var state_25842__$1 = state_25842;
var statearr_25859_25960 = state_25842__$1;
(statearr_25859_25960[(2)] = inst_25737);

(statearr_25859_25960[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (48))){
var inst_25748 = (state_25842[(8)]);
var inst_25807 = (state_25842[(18)]);
var inst_25750 = (state_25842[(10)]);
var inst_25766 = (state_25842[(19)]);
var inst_25749 = (state_25842[(11)]);
var inst_25771 = (state_25842[(20)]);
var inst_25760 = (state_25842[(21)]);
var inst_25809 = (function (){var map__25742 = inst_25748;
var headers = inst_25749;
var tuples = inst_25750;
var offset_SINGLEQUOTE_ = inst_25760;
var single_result_QMARK_ = inst_25766;
var pp_keys = inst_25771;
var G__25772 = inst_25807;
return (function (p1__25699_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__25699_SHARP_);
});
})();
var inst_25810 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25809);
var inst_25811 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25807,inst_25810);
var state_25842__$1 = state_25842;
var statearr_25860_25961 = state_25842__$1;
(statearr_25860_25961[(2)] = inst_25811);

(statearr_25860_25961[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (50))){
var inst_25814 = (state_25842[(2)]);
var inst_25815 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_25814);
var state_25842__$1 = (function (){var statearr_25861 = state_25842;
(statearr_25861[(16)] = inst_25815);

return statearr_25861;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25862_25962 = state_25842__$1;
(statearr_25862_25962[(1)] = (51));

} else {
var statearr_25863_25963 = state_25842__$1;
(statearr_25863_25963[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (21))){
var inst_25753 = cljs.core.not(groupBy);
var state_25842__$1 = state_25842;
var statearr_25864_25964 = state_25842__$1;
(statearr_25864_25964[(2)] = inst_25753);

(statearr_25864_25964[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (31))){
var state_25842__$1 = state_25842;
var statearr_25865_25965 = state_25842__$1;
(statearr_25865_25965[(2)] = null);

(statearr_25865_25965[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (32))){
var inst_25766 = (state_25842[(19)]);
var inst_25749 = (state_25842[(11)]);
var inst_25771 = (state_25842[(2)]);
var inst_25773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25774 = fluree.db.query.fql.select_tuples_fn(inst_25749,vars,select);
var inst_25775 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25774);
var inst_25776 = [inst_25775];
var inst_25777 = (new cljs.core.PersistentVector(null,1,(5),inst_25773,inst_25776,null));
var state_25842__$1 = (function (){var statearr_25866 = state_25842;
(statearr_25866[(22)] = inst_25777);

(statearr_25866[(20)] = inst_25771);

return statearr_25866;
})();
if(cljs.core.truth_(inst_25766)){
var statearr_25867_25966 = state_25842__$1;
(statearr_25867_25966[(1)] = (33));

} else {
var statearr_25868_25967 = state_25842__$1;
(statearr_25868_25967[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (40))){
var inst_25789 = (state_25842[(14)]);
var state_25842__$1 = state_25842;
var statearr_25869_25968 = state_25842__$1;
(statearr_25869_25968[(2)] = inst_25789);

(statearr_25869_25968[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (56))){
var inst_25827 = (state_25842[(2)]);
var state_25842__$1 = (function (){var statearr_25870 = state_25842;
(statearr_25870[(12)] = inst_25827);

return statearr_25870;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25871_25969 = state_25842__$1;
(statearr_25871_25969[(1)] = (57));

} else {
var statearr_25872_25970 = state_25842__$1;
(statearr_25872_25970[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (33))){
var inst_25777 = (state_25842[(22)]);
var inst_25779 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_25780 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25777,inst_25779);
var state_25842__$1 = state_25842;
var statearr_25873_25971 = state_25842__$1;
(statearr_25873_25971[(2)] = inst_25780);

(statearr_25873_25971[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (13))){
var inst_25722 = (state_25842[(23)]);
var state_25842__$1 = state_25842;
var statearr_25874_25972 = state_25842__$1;
(statearr_25874_25972[(2)] = inst_25722);

(statearr_25874_25972[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (22))){
var inst_25751 = (state_25842[(9)]);
var state_25842__$1 = state_25842;
var statearr_25875_25973 = state_25842__$1;
(statearr_25875_25973[(2)] = inst_25751);

(statearr_25875_25973[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (36))){
var inst_25783 = (state_25842[(24)]);
var inst_25785 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_25786 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25783,inst_25785);
var state_25842__$1 = state_25842;
var statearr_25876_25974 = state_25842__$1;
(statearr_25876_25974[(2)] = inst_25786);

(statearr_25876_25974[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (41))){
var inst_25760 = (state_25842[(21)]);
var inst_25795 = (state_25842[(2)]);
var state_25842__$1 = (function (){var statearr_25877 = state_25842;
(statearr_25877[(25)] = inst_25795);

return statearr_25877;
})();
if(cljs.core.truth_(inst_25760)){
var statearr_25878_25975 = state_25842__$1;
(statearr_25878_25975[(1)] = (42));

} else {
var statearr_25879_25976 = state_25842__$1;
(statearr_25879_25976[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (43))){
var inst_25795 = (state_25842[(25)]);
var state_25842__$1 = state_25842;
var statearr_25880_25977 = state_25842__$1;
(statearr_25880_25977[(2)] = inst_25795);

(statearr_25880_25977[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (29))){
var inst_25766 = (state_25842[(2)]);
var state_25842__$1 = (function (){var statearr_25881 = state_25842;
(statearr_25881[(19)] = inst_25766);

return statearr_25881;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25882_25978 = state_25842__$1;
(statearr_25882_25978[(1)] = (30));

} else {
var statearr_25883_25979 = state_25842__$1;
(statearr_25883_25979[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (44))){
var inst_25801 = (state_25842[(2)]);
var state_25842__$1 = (function (){var statearr_25884 = state_25842;
(statearr_25884[(15)] = inst_25801);

return statearr_25884;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25885_25980 = state_25842__$1;
(statearr_25885_25980[(1)] = (45));

} else {
var statearr_25886_25981 = state_25842__$1;
(statearr_25886_25981[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (6))){
var inst_25714 = cljs.core.count(select);
var inst_25715 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_25714);
var state_25842__$1 = state_25842;
var statearr_25887_25982 = state_25842__$1;
(statearr_25887_25982[(2)] = inst_25715);

(statearr_25887_25982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (28))){
var inst_25761 = (state_25842[(26)]);
var state_25842__$1 = state_25842;
var statearr_25888_25983 = state_25842__$1;
(statearr_25888_25983[(2)] = inst_25761);

(statearr_25888_25983[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (51))){
var inst_25750 = (state_25842[(10)]);
var inst_25749 = (state_25842[(11)]);
var inst_25818 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_25749,orderBy,inst_25750);
var state_25842__$1 = state_25842;
var statearr_25889_25984 = state_25842__$1;
(statearr_25889_25984[(2)] = inst_25818);

(statearr_25889_25984[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (25))){
var state_25842__$1 = state_25842;
var statearr_25890_25985 = state_25842__$1;
(statearr_25890_25985[(2)] = null);

(statearr_25890_25985[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (34))){
var inst_25777 = (state_25842[(22)]);
var state_25842__$1 = state_25842;
var statearr_25891_25986 = state_25842__$1;
(statearr_25891_25986[(2)] = inst_25777);

(statearr_25891_25986[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (17))){
var inst_25740 = (state_25842[(2)]);
var state_25842__$1 = state_25842;
var statearr_25892_25987 = state_25842__$1;
(statearr_25892_25987[(2)] = inst_25740);

(statearr_25892_25987[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (3))){
var inst_25840 = (state_25842[(2)]);
var state_25842__$1 = state_25842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25842__$1,inst_25840);
} else {
if((state_val_25843 === (12))){
var inst_25722 = (state_25842[(23)]);
var inst_25724 = cljs.core.first(select);
var inst_25725 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_25724);
var inst_25726 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25725);
var inst_25727 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_25726,(1));
var inst_25728 = [inst_25727];
var inst_25729 = [inst_25722];
var inst_25730 = cljs.core.PersistentHashMap.fromArrays(inst_25728,inst_25729);
var state_25842__$1 = state_25842;
var statearr_25893_25988 = state_25842__$1;
(statearr_25893_25988[(2)] = inst_25730);

(statearr_25893_25988[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (2))){
var inst_25712 = (state_25842[(7)]);
var _ = (function (){var statearr_25894 = state_25842;
(statearr_25894[(4)] = cljs.core.cons((5),(state_25842[(4)])));

return statearr_25894;
})();
var inst_25712__$1 = aggregates;
var state_25842__$1 = (function (){var statearr_25895 = state_25842;
(statearr_25895[(7)] = inst_25712__$1);

return statearr_25895;
})();
if(cljs.core.truth_(inst_25712__$1)){
var statearr_25896_25989 = state_25842__$1;
(statearr_25896_25989[(1)] = (6));

} else {
var statearr_25897_25990 = state_25842__$1;
(statearr_25897_25990[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (23))){
var inst_25756 = (state_25842[(2)]);
var state_25842__$1 = state_25842;
if(cljs.core.truth_(inst_25756)){
var statearr_25898_25991 = state_25842__$1;
(statearr_25898_25991[(1)] = (24));

} else {
var statearr_25899_25992 = state_25842__$1;
(statearr_25899_25992[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (47))){
var inst_25807 = (state_25842[(2)]);
var state_25842__$1 = (function (){var statearr_25900 = state_25842;
(statearr_25900[(18)] = inst_25807);

return statearr_25900;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25901_25993 = state_25842__$1;
(statearr_25901_25993[(1)] = (48));

} else {
var statearr_25902_25994 = state_25842__$1;
(statearr_25902_25994[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (35))){
var inst_25783 = (state_25842[(2)]);
var state_25842__$1 = (function (){var statearr_25903 = state_25842;
(statearr_25903[(24)] = inst_25783);

return statearr_25903;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25904_25995 = state_25842__$1;
(statearr_25904_25995[(1)] = (36));

} else {
var statearr_25905_25996 = state_25842__$1;
(statearr_25905_25996[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (19))){
var state_25842__$1 = state_25842;
var statearr_25906_25997 = state_25842__$1;
(statearr_25906_25997[(2)] = res);

(statearr_25906_25997[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (57))){
var inst_25766 = (state_25842[(19)]);
var inst_25771 = (state_25842[(20)]);
var inst_25827 = (state_25842[(12)]);
var inst_25829 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_25771,inst_25766,db,fuel,max_fuel,opts,(8),inst_25827);
var state_25842__$1 = state_25842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25842__$1,(60),inst_25829);
} else {
if((state_val_25843 === (11))){
var inst_25837 = (state_25842[(2)]);
var _ = (function (){var statearr_25908 = state_25842;
(statearr_25908[(4)] = cljs.core.rest((state_25842[(4)])));

return statearr_25908;
})();
var state_25842__$1 = state_25842;
var statearr_25909_25998 = state_25842__$1;
(statearr_25909_25998[(2)] = inst_25837);

(statearr_25909_25998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (9))){
var inst_25720 = cljs.core.first(aggregates);
var inst_25721 = fluree.db.query.analytical.calculate_aggregate(res,inst_25720);
var inst_25722 = cljs.core.second(inst_25721);
var state_25842__$1 = (function (){var statearr_25910 = state_25842;
(statearr_25910[(23)] = inst_25722);

return statearr_25910;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25911_25999 = state_25842__$1;
(statearr_25911_25999[(1)] = (12));

} else {
var statearr_25912_26000 = state_25842__$1;
(statearr_25912_26000[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (5))){
var _ = (function (){var statearr_25913 = state_25842;
(statearr_25913[(4)] = cljs.core.rest((state_25842[(4)])));

return statearr_25913;
})();
var state_25842__$1 = state_25842;
var ex25907 = (state_25842__$1[(2)]);
var statearr_25914_26001 = state_25842__$1;
(statearr_25914_26001[(5)] = ex25907);


if((ex25907 instanceof Error)){
var statearr_25915_26002 = state_25842__$1;
(statearr_25915_26002[(1)] = (4));

(statearr_25915_26002[(5)] = null);

} else {
throw ex25907;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (14))){
var inst_25733 = (state_25842[(2)]);
var state_25842__$1 = (function (){var statearr_25916 = state_25842;
(statearr_25916[(17)] = inst_25733);

return statearr_25916;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25917_26003 = state_25842__$1;
(statearr_25917_26003[(1)] = (15));

} else {
var statearr_25918_26004 = state_25842__$1;
(statearr_25918_26004[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (45))){
var inst_25801 = (state_25842[(15)]);
var inst_25803 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_25804 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25801,inst_25803);
var state_25842__$1 = state_25842;
var statearr_25919_26005 = state_25842__$1;
(statearr_25919_26005[(2)] = inst_25804);

(statearr_25919_26005[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (53))){
var inst_25821 = (state_25842[(2)]);
var state_25842__$1 = (function (){var statearr_25920 = state_25842;
(statearr_25920[(13)] = inst_25821);

return statearr_25920;
})();
var statearr_25921_26006 = state_25842__$1;
(statearr_25921_26006[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (26))){
var inst_25761 = (state_25842[(26)]);
var inst_25760 = (state_25842[(2)]);
var inst_25761__$1 = cljs.core.not(prettyPrint);
var state_25842__$1 = (function (){var statearr_25923 = state_25842;
(statearr_25923[(26)] = inst_25761__$1);

(statearr_25923[(21)] = inst_25760);

return statearr_25923;
})();
if(inst_25761__$1){
var statearr_25924_26007 = state_25842__$1;
(statearr_25924_26007[(1)] = (27));

} else {
var statearr_25925_26008 = state_25842__$1;
(statearr_25925_26008[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (16))){
var inst_25733 = (state_25842[(17)]);
var state_25842__$1 = state_25842;
var statearr_25926_26009 = state_25842__$1;
(statearr_25926_26009[(2)] = inst_25733);

(statearr_25926_26009[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (38))){
var inst_25789 = (state_25842[(2)]);
var state_25842__$1 = (function (){var statearr_25927 = state_25842;
(statearr_25927[(14)] = inst_25789);

return statearr_25927;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25928_26010 = state_25842__$1;
(statearr_25928_26010[(1)] = (39));

} else {
var statearr_25929_26011 = state_25842__$1;
(statearr_25929_26011[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (30))){
var inst_25768 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_25842__$1 = state_25842;
var statearr_25930_26012 = state_25842__$1;
(statearr_25930_26012[(2)] = inst_25768);

(statearr_25930_26012[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (10))){
var state_25842__$1 = state_25842;
if(cljs.core.truth_(aggregates)){
var statearr_25931_26013 = state_25842__$1;
(statearr_25931_26013[(1)] = (18));

} else {
var statearr_25932_26014 = state_25842__$1;
(statearr_25932_26014[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (18))){
var inst_25744 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_25842__$1 = state_25842;
var statearr_25933_26015 = state_25842__$1;
(statearr_25933_26015[(2)] = inst_25744);

(statearr_25933_26015[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (52))){
var inst_25750 = (state_25842[(10)]);
var state_25842__$1 = state_25842;
var statearr_25934_26016 = state_25842__$1;
(statearr_25934_26016[(2)] = inst_25750);

(statearr_25934_26016[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (42))){
var inst_25795 = (state_25842[(25)]);
var inst_25760 = (state_25842[(21)]);
var inst_25797 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_25760);
var inst_25798 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25795,inst_25797);
var state_25842__$1 = state_25842;
var statearr_25935_26017 = state_25842__$1;
(statearr_25935_26017[(2)] = inst_25798);

(statearr_25935_26017[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (37))){
var inst_25783 = (state_25842[(24)]);
var state_25842__$1 = state_25842;
var statearr_25936_26018 = state_25842__$1;
(statearr_25936_26018[(2)] = inst_25783);

(statearr_25936_26018[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (8))){
var inst_25718 = (state_25842[(2)]);
var state_25842__$1 = state_25842;
if(cljs.core.truth_(inst_25718)){
var statearr_25937_26019 = state_25842__$1;
(statearr_25937_26019[(1)] = (9));

} else {
var statearr_25938_26020 = state_25842__$1;
(statearr_25938_26020[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25843 === (49))){
var inst_25807 = (state_25842[(18)]);
var state_25842__$1 = state_25842;
var statearr_25939_26021 = state_25842__$1;
(statearr_25939_26021[(2)] = inst_25807);

(statearr_25939_26021[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2684__auto__ = null;
var fluree$db$query$fql$state_machine__2684__auto____0 = (function (){
var statearr_25940 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25940[(0)] = fluree$db$query$fql$state_machine__2684__auto__);

(statearr_25940[(1)] = (1));

return statearr_25940;
});
var fluree$db$query$fql$state_machine__2684__auto____1 = (function (state_25842){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25842);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25941){var ex__2687__auto__ = e25941;
var statearr_25942_26022 = state_25842;
(statearr_25942_26022[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25842[(4)]))){
var statearr_25943_26023 = state_25842;
(statearr_25943_26023[(1)] = cljs.core.first((state_25842[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26024 = state_25842;
state_25842 = G__26024;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2684__auto__ = function(state_25842){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2684__auto____1.call(this,state_25842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2684__auto____0;
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2684__auto____1;
return fluree$db$query$fql$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25944 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25944[(6)] = c__2706__auto__);

return statearr_25944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__26027,groupBy){
var map__26028 = p__26027;
var map__26028__$1 = cljs.core.__destructure_map(map__26028);
var res = map__26028__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26028__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26028__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__26029 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26029,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26029,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__26025_SHARP_){
return fluree.db.util.core.index_of(headers,p1__26025_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__26026_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__26026_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__26032 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26032,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26032,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__26035,p__26036,opts){
var map__26037 = p__26035;
var map__26037__$1 = cljs.core.__destructure_map(map__26037);
var res = map__26037__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26037__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26037__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__26038 = p__26036;
var map__26038__$1 = cljs.core.__destructure_map(map__26038);
var select_spec = map__26038__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26038__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26038__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26038__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26038__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26038__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26038__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26038__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26280){
var state_val_26281 = (state_26280[(1)]);
if((state_val_26281 === (65))){
var state_26280__$1 = state_26280;
var statearr_26282_26433 = state_26280__$1;
(statearr_26282_26433[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (70))){
var inst_26201 = (state_26280[(7)]);
var state_26280__$1 = state_26280;
var statearr_26284_26434 = state_26280__$1;
(statearr_26284_26434[(2)] = inst_26201);

(statearr_26284_26434[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (62))){
var state_26280__$1 = state_26280;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_26285_26435 = state_26280__$1;
(statearr_26285_26435[(1)] = (64));

} else {
var statearr_26286_26436 = state_26280__$1;
(statearr_26286_26436[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (74))){
var inst_26117 = (state_26280[(8)]);
var inst_26176 = (state_26280[(9)]);
var inst_26108 = (state_26280[(10)]);
var inst_26209 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26108,inst_26117,inst_26176);
var state_26280__$1 = state_26280;
var statearr_26287_26437 = state_26280__$1;
(statearr_26287_26437[(2)] = inst_26209);

(statearr_26287_26437[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (7))){
var state_26280__$1 = state_26280;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26288_26438 = state_26280__$1;
(statearr_26288_26438[(1)] = (82));

} else {
var statearr_26289_26439 = state_26280__$1;
(statearr_26289_26439[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (59))){
var inst_26106 = (state_26280[(11)]);
var inst_26176 = (state_26280[(9)]);
var inst_26180 = cljs.core.count(inst_26176);
var inst_26181 = (inst_26106 - inst_26180);
var state_26280__$1 = state_26280;
var statearr_26290_26440 = state_26280__$1;
(statearr_26290_26440[(2)] = inst_26181);

(statearr_26290_26440[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (86))){
var state_26280__$1 = state_26280;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_26291_26441 = state_26280__$1;
(statearr_26291_26441[(1)] = (89));

} else {
var statearr_26292_26442 = state_26280__$1;
(statearr_26292_26442[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (20))){
var state_26280__$1 = state_26280;
var statearr_26293_26443 = state_26280__$1;
(statearr_26293_26443[(2)] = (0));

(statearr_26293_26443[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (72))){
var inst_26206 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
if(cljs.core.truth_(inst_26206)){
var statearr_26294_26444 = state_26280__$1;
(statearr_26294_26444[(1)] = (73));

} else {
var statearr_26295_26445 = state_26280__$1;
(statearr_26295_26445[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (58))){
var state_26280__$1 = state_26280;
var statearr_26296_26446 = state_26280__$1;
(statearr_26296_26446[(2)] = null);

(statearr_26296_26446[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (60))){
var inst_26107 = (state_26280[(12)]);
var inst_26183 = (state_26280[(2)]);
var inst_26184 = (inst_26107 <= (0));
var state_26280__$1 = (function (){var statearr_26297 = state_26280;
(statearr_26297[(13)] = inst_26183);

return statearr_26297;
})();
if(cljs.core.truth_(inst_26184)){
var statearr_26298_26447 = state_26280__$1;
(statearr_26298_26447[(1)] = (61));

} else {
var statearr_26299_26448 = state_26280__$1;
(statearr_26299_26448[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (27))){
var inst_26106 = (state_26280[(11)]);
var inst_26130 = (inst_26106 < (1));
var state_26280__$1 = state_26280;
var statearr_26300_26449 = state_26280__$1;
(statearr_26300_26449[(2)] = inst_26130);

(statearr_26300_26449[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (1))){
var state_26280__$1 = state_26280;
var statearr_26301_26450 = state_26280__$1;
(statearr_26301_26450[(2)] = null);

(statearr_26301_26450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (69))){
var inst_26196 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26302_26451 = state_26280__$1;
(statearr_26302_26451[(2)] = inst_26196);

(statearr_26302_26451[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (24))){
var inst_26108 = (state_26280[(10)]);
var state_26280__$1 = state_26280;
var statearr_26303_26452 = state_26280__$1;
(statearr_26303_26452[(2)] = inst_26108);

(statearr_26303_26452[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (55))){
var inst_26166 = (state_26280[(14)]);
var inst_26106 = (state_26280[(11)]);
var inst_26173 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_26106,inst_26166);
var state_26280__$1 = state_26280;
var statearr_26304_26453 = state_26280__$1;
(statearr_26304_26453[(2)] = inst_26173);

(statearr_26304_26453[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (85))){
var inst_26251 = (state_26280[(15)]);
var inst_26250 = (state_26280[(2)]);
var inst_26251__$1 = fluree.db.util.async.throw_err(inst_26250);
var inst_26252 = cljs.core.coll_QMARK_(inst_26251__$1);
var inst_26253 = (!(inst_26252));
var state_26280__$1 = (function (){var statearr_26305 = state_26280;
(statearr_26305[(15)] = inst_26251__$1);

return statearr_26305;
})();
if(inst_26253){
var statearr_26306_26454 = state_26280__$1;
(statearr_26306_26454[(1)] = (86));

} else {
var statearr_26307_26455 = state_26280__$1;
(statearr_26307_26455[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (39))){
var inst_26125 = (state_26280[(16)]);
var inst_26147 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_26148 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_26149 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_26125,inst_26147,inst_26148);
var state_26280__$1 = state_26280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26280__$1,(42),inst_26149);
} else {
if((state_val_26281 === (88))){
var inst_26273 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26308_26456 = state_26280__$1;
(statearr_26308_26456[(2)] = inst_26273);

(statearr_26308_26456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (46))){
var inst_26107 = (state_26280[(12)]);
var inst_26161 = ((0) < inst_26107);
var state_26280__$1 = state_26280;
if(cljs.core.truth_(inst_26161)){
var statearr_26309_26457 = state_26280__$1;
(statearr_26309_26457[(1)] = (49));

} else {
var statearr_26310_26458 = state_26280__$1;
(statearr_26310_26458[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (4))){
var inst_26039 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26311_26459 = state_26280__$1;
(statearr_26311_26459[(2)] = inst_26039);

(statearr_26311_26459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (77))){
var inst_26106 = (state_26280[(11)]);
var inst_26217 = (inst_26106 - (1));
var state_26280__$1 = state_26280;
var statearr_26312_26460 = state_26280__$1;
(statearr_26312_26460[(2)] = inst_26217);

(statearr_26312_26460[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (95))){
var inst_26251 = (state_26280[(15)]);
var state_26280__$1 = state_26280;
var statearr_26313_26461 = state_26280__$1;
(statearr_26313_26461[(2)] = inst_26251);

(statearr_26313_26461[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (54))){
var inst_26171 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
if(cljs.core.truth_(inst_26171)){
var statearr_26314_26462 = state_26280__$1;
(statearr_26314_26462[(1)] = (55));

} else {
var statearr_26315_26463 = state_26280__$1;
(statearr_26315_26463[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (92))){
var inst_26251 = (state_26280[(15)]);
var inst_26264 = cljs.core.first(inst_26251);
var state_26280__$1 = state_26280;
var statearr_26316_26464 = state_26280__$1;
(statearr_26316_26464[(2)] = inst_26264);

(statearr_26316_26464[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (15))){
var inst_26057 = (state_26280[(17)]);
var inst_26065 = (state_26280[(2)]);
var inst_26066 = fluree.db.util.async.throw_err(inst_26065);
var inst_26067 = [inst_26057];
var inst_26068 = [inst_26066];
var inst_26069 = cljs.core.PersistentHashMap.fromArrays(inst_26067,inst_26068);
var state_26280__$1 = state_26280;
var statearr_26317_26465 = state_26280__$1;
(statearr_26317_26465[(2)] = inst_26069);

(statearr_26317_26465[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (48))){
var inst_26229 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26318_26466 = state_26280__$1;
(statearr_26318_26466[(2)] = inst_26229);

(statearr_26318_26466[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (50))){
var inst_26152 = (state_26280[(18)]);
var state_26280__$1 = state_26280;
var statearr_26319_26467 = state_26280__$1;
(statearr_26319_26467[(2)] = inst_26152);

(statearr_26319_26467[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (75))){
var inst_26118 = (state_26280[(19)]);
var inst_26183 = (state_26280[(13)]);
var inst_26121 = (state_26280[(20)]);
var inst_26200 = (state_26280[(21)]);
var inst_26211 = (state_26280[(2)]);
var inst_26104 = inst_26118;
var inst_26105 = inst_26121;
var inst_26106 = inst_26183;
var inst_26107 = inst_26200;
var inst_26108 = inst_26211;
var state_26280__$1 = (function (){var statearr_26320 = state_26280;
(statearr_26320[(22)] = inst_26105);

(statearr_26320[(11)] = inst_26106);

(statearr_26320[(23)] = inst_26104);

(statearr_26320[(12)] = inst_26107);

(statearr_26320[(10)] = inst_26108);

return statearr_26320;
})();
var statearr_26321_26468 = state_26280__$1;
(statearr_26321_26468[(2)] = null);

(statearr_26321_26468[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (21))){
var inst_26089 = (state_26280[(24)]);
var inst_26097 = (state_26280[(25)]);
var inst_26085 = (state_26280[(26)]);
var inst_26102 = (state_26280[(2)]);
var inst_26103 = cljs.core.PersistentHashMap.EMPTY;
var inst_26104 = inst_26085;
var inst_26105 = inst_26089;
var inst_26106 = inst_26097;
var inst_26107 = inst_26102;
var inst_26108 = inst_26103;
var state_26280__$1 = (function (){var statearr_26322 = state_26280;
(statearr_26322[(22)] = inst_26105);

(statearr_26322[(11)] = inst_26106);

(statearr_26322[(23)] = inst_26104);

(statearr_26322[(12)] = inst_26107);

(statearr_26322[(10)] = inst_26108);

return statearr_26322;
})();
var statearr_26323_26469 = state_26280__$1;
(statearr_26323_26469[(2)] = null);

(statearr_26323_26469[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (31))){
var inst_26122 = (state_26280[(27)]);
var inst_26107 = (state_26280[(12)]);
var inst_26136 = (inst_26107 >= inst_26122);
var state_26280__$1 = state_26280;
if(cljs.core.truth_(inst_26136)){
var statearr_26324_26470 = state_26280__$1;
(statearr_26324_26470[(1)] = (33));

} else {
var statearr_26325_26471 = state_26280__$1;
(statearr_26325_26471[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (32))){
var inst_26236 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26326_26472 = state_26280__$1;
(statearr_26326_26472[(2)] = inst_26236);

(statearr_26326_26472[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (40))){
var state_26280__$1 = state_26280;
var statearr_26327_26473 = state_26280__$1;
(statearr_26327_26473[(2)] = null);

(statearr_26327_26473[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (91))){
var inst_26261 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26328_26474 = state_26280__$1;
(statearr_26328_26474[(2)] = inst_26261);

(statearr_26328_26474[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (56))){
var inst_26166 = (state_26280[(14)]);
var state_26280__$1 = state_26280;
var statearr_26329_26475 = state_26280__$1;
(statearr_26329_26475[(2)] = inst_26166);

(statearr_26329_26475[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (33))){
var state_26280__$1 = state_26280;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_26330_26476 = state_26280__$1;
(statearr_26330_26476[(1)] = (36));

} else {
var statearr_26331_26477 = state_26280__$1;
(statearr_26331_26477[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (13))){
var inst_26054 = (state_26280[(28)]);
var inst_26089 = (state_26280[(24)]);
var inst_26085 = (state_26280[(26)]);
var inst_26085__$1 = cljs.core.keys(inst_26054);
var inst_26086 = cljs.core.seq(inst_26085__$1);
var inst_26087 = cljs.core.first(inst_26086);
var inst_26088 = cljs.core.next(inst_26086);
var inst_26089__$1 = cljs.core.vals(inst_26054);
var inst_26090 = cljs.core.seq(inst_26089__$1);
var inst_26091 = cljs.core.first(inst_26090);
var inst_26092 = cljs.core.next(inst_26090);
var inst_26093 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_26280__$1 = (function (){var statearr_26332 = state_26280;
(statearr_26332[(29)] = inst_26091);

(statearr_26332[(24)] = inst_26089__$1);

(statearr_26332[(26)] = inst_26085__$1);

(statearr_26332[(30)] = inst_26088);

(statearr_26332[(31)] = inst_26092);

(statearr_26332[(32)] = inst_26087);

return statearr_26332;
})();
if(inst_26093){
var statearr_26333_26478 = state_26280__$1;
(statearr_26333_26478[(1)] = (16));

} else {
var statearr_26334_26479 = state_26280__$1;
(statearr_26334_26479[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (22))){
var inst_26105 = (state_26280[(22)]);
var inst_26104 = (state_26280[(23)]);
var inst_26116 = cljs.core.seq(inst_26104);
var inst_26117 = cljs.core.first(inst_26116);
var inst_26118 = cljs.core.next(inst_26116);
var inst_26119 = cljs.core.seq(inst_26105);
var inst_26120 = cljs.core.first(inst_26119);
var inst_26121 = cljs.core.next(inst_26119);
var inst_26122 = cljs.core.count(inst_26120);
var inst_26123 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_26124 = [headers,vars,inst_26120];
var inst_26125 = cljs.core.PersistentHashMap.fromArrays(inst_26123,inst_26124);
var inst_26126 = (inst_26120 == null);
var state_26280__$1 = (function (){var statearr_26335 = state_26280;
(statearr_26335[(27)] = inst_26122);

(statearr_26335[(19)] = inst_26118);

(statearr_26335[(8)] = inst_26117);

(statearr_26335[(20)] = inst_26121);

(statearr_26335[(16)] = inst_26125);

return statearr_26335;
})();
if(cljs.core.truth_(inst_26126)){
var statearr_26336_26480 = state_26280__$1;
(statearr_26336_26480[(1)] = (24));

} else {
var statearr_26337_26481 = state_26280__$1;
(statearr_26337_26481[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (90))){
var inst_26251 = (state_26280[(15)]);
var state_26280__$1 = state_26280;
var statearr_26338_26482 = state_26280__$1;
(statearr_26338_26482[(2)] = inst_26251);

(statearr_26338_26482[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (36))){
var inst_26107 = (state_26280[(12)]);
var inst_26139 = (inst_26107 - (1));
var state_26280__$1 = state_26280;
var statearr_26339_26483 = state_26280__$1;
(statearr_26339_26483[(2)] = inst_26139);

(statearr_26339_26483[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (41))){
var inst_26232 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26340_26484 = state_26280__$1;
(statearr_26340_26484[(2)] = inst_26232);

(statearr_26340_26484[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (89))){
var inst_26251 = (state_26280[(15)]);
var inst_26256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26257 = [inst_26251];
var inst_26258 = (new cljs.core.PersistentVector(null,1,(5),inst_26256,inst_26257,null));
var state_26280__$1 = state_26280;
var statearr_26341_26485 = state_26280__$1;
(statearr_26341_26485[(2)] = inst_26258);

(statearr_26341_26485[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (43))){
var inst_26152 = (state_26280[(18)]);
var inst_26155 = cljs.core.seq(inst_26152);
var state_26280__$1 = state_26280;
var statearr_26342_26486 = state_26280__$1;
(statearr_26342_26486[(2)] = inst_26155);

(statearr_26342_26486[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (61))){
var state_26280__$1 = state_26280;
var statearr_26343_26487 = state_26280__$1;
(statearr_26343_26487[(2)] = (0));

(statearr_26343_26487[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (29))){
var inst_26133 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
if(cljs.core.truth_(inst_26133)){
var statearr_26344_26488 = state_26280__$1;
(statearr_26344_26488[(1)] = (30));

} else {
var statearr_26345_26489 = state_26280__$1;
(statearr_26345_26489[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (44))){
var inst_26153 = (state_26280[(33)]);
var state_26280__$1 = state_26280;
var statearr_26346_26490 = state_26280__$1;
(statearr_26346_26490[(2)] = inst_26153);

(statearr_26346_26490[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (93))){
var state_26280__$1 = state_26280;
var statearr_26347_26491 = state_26280__$1;
(statearr_26347_26491[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (6))){
var inst_26046 = (state_26280[(34)]);
var inst_26046__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_26048 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_26280__$1 = (function (){var statearr_26349 = state_26280;
(statearr_26349[(35)] = inst_26048);

(statearr_26349[(34)] = inst_26046__$1);

return statearr_26349;
})();
if(cljs.core.truth_(inst_26046__$1)){
var statearr_26350_26492 = state_26280__$1;
(statearr_26350_26492[(1)] = (9));

} else {
var statearr_26351_26493 = state_26280__$1;
(statearr_26351_26493[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (28))){
var inst_26106 = (state_26280[(11)]);
var state_26280__$1 = state_26280;
var statearr_26352_26494 = state_26280__$1;
(statearr_26352_26494[(2)] = inst_26106);

(statearr_26352_26494[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (64))){
var inst_26107 = (state_26280[(12)]);
var inst_26188 = (inst_26107 - (1));
var state_26280__$1 = state_26280;
var statearr_26353_26495 = state_26280__$1;
(statearr_26353_26495[(2)] = inst_26188);

(statearr_26353_26495[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (51))){
var inst_26106 = (state_26280[(11)]);
var inst_26166 = (state_26280[(2)]);
var state_26280__$1 = (function (){var statearr_26354 = state_26280;
(statearr_26354[(14)] = inst_26166);

return statearr_26354;
})();
if(cljs.core.truth_(inst_26106)){
var statearr_26355_26496 = state_26280__$1;
(statearr_26355_26496[(1)] = (52));

} else {
var statearr_26356_26497 = state_26280__$1;
(statearr_26356_26497[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (25))){
var inst_26106 = (state_26280[(11)]);
var state_26280__$1 = state_26280;
if(cljs.core.truth_(inst_26106)){
var statearr_26357_26498 = state_26280__$1;
(statearr_26357_26498[(1)] = (27));

} else {
var statearr_26358_26499 = state_26280__$1;
(statearr_26358_26499[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (34))){
var state_26280__$1 = state_26280;
var statearr_26359_26500 = state_26280__$1;
(statearr_26359_26500[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (17))){
var state_26280__$1 = state_26280;
var statearr_26361_26501 = state_26280__$1;
(statearr_26361_26501[(2)] = limit);

(statearr_26361_26501[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (3))){
var inst_26278 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26280__$1,inst_26278);
} else {
if((state_val_26281 === (12))){
var inst_26054 = (state_26280[(28)]);
var inst_26056 = cljs.core.keys(inst_26054);
var inst_26057 = cljs.core.first(inst_26056);
var inst_26058 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_26059 = cljs.core.vals(inst_26054);
var inst_26060 = cljs.core.first(inst_26059);
var inst_26061 = [headers,vars,inst_26060];
var inst_26062 = cljs.core.PersistentHashMap.fromArrays(inst_26058,inst_26061);
var inst_26063 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_26062,select_spec,limit,opts);
var state_26280__$1 = (function (){var statearr_26362 = state_26280;
(statearr_26362[(17)] = inst_26057);

return statearr_26362;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26280__$1,(15),inst_26063);
} else {
if((state_val_26281 === (2))){
var _ = (function (){var statearr_26363 = state_26280;
(statearr_26363[(4)] = cljs.core.cons((5),(state_26280[(4)])));

return statearr_26363;
})();
var state_26280__$1 = state_26280;
if(cljs.core.truth_(groupBy)){
var statearr_26364_26502 = state_26280__$1;
(statearr_26364_26502[(1)] = (6));

} else {
var statearr_26365_26503 = state_26280__$1;
(statearr_26365_26503[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (66))){
var inst_26198 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26366_26504 = state_26280__$1;
(statearr_26366_26504[(2)] = inst_26198);

(statearr_26366_26504[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (23))){
var inst_26240 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26367_26505 = state_26280__$1;
(statearr_26367_26505[(2)] = inst_26240);

(statearr_26367_26505[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (47))){
var inst_26106 = (state_26280[(11)]);
var inst_26214 = (inst_26106 == null);
var state_26280__$1 = state_26280;
if(cljs.core.truth_(inst_26214)){
var statearr_26368_26506 = state_26280__$1;
(statearr_26368_26506[(1)] = (76));

} else {
var statearr_26369_26507 = state_26280__$1;
(statearr_26369_26507[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (35))){
var inst_26234 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26370_26508 = state_26280__$1;
(statearr_26370_26508[(2)] = inst_26234);

(statearr_26370_26508[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (82))){
var state_26280__$1 = state_26280;
var statearr_26371_26509 = state_26280__$1;
(statearr_26371_26509[(2)] = (1));

(statearr_26371_26509[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (76))){
var state_26280__$1 = state_26280;
var statearr_26372_26510 = state_26280__$1;
(statearr_26372_26510[(2)] = null);

(statearr_26372_26510[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (97))){
var inst_26269 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26373_26511 = state_26280__$1;
(statearr_26373_26511[(2)] = inst_26269);

(statearr_26373_26511[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (19))){
var inst_26098 = (state_26280[(36)]);
var state_26280__$1 = state_26280;
var statearr_26374_26512 = state_26280__$1;
(statearr_26374_26512[(2)] = inst_26098);

(statearr_26374_26512[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (57))){
var inst_26106 = (state_26280[(11)]);
var inst_26176 = (state_26280[(2)]);
var inst_26177 = (inst_26106 == null);
var state_26280__$1 = (function (){var statearr_26375 = state_26280;
(statearr_26375[(9)] = inst_26176);

return statearr_26375;
})();
if(cljs.core.truth_(inst_26177)){
var statearr_26376_26513 = state_26280__$1;
(statearr_26376_26513[(1)] = (58));

} else {
var statearr_26377_26514 = state_26280__$1;
(statearr_26377_26514[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (68))){
var state_26280__$1 = state_26280;
var statearr_26378_26515 = state_26280__$1;
(statearr_26378_26515[(2)] = null);

(statearr_26378_26515[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (11))){
var inst_26054 = (state_26280[(2)]);
var state_26280__$1 = (function (){var statearr_26380 = state_26280;
(statearr_26380[(28)] = inst_26054);

return statearr_26380;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26381_26516 = state_26280__$1;
(statearr_26381_26516[(1)] = (12));

} else {
var statearr_26382_26517 = state_26280__$1;
(statearr_26382_26517[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (9))){
var inst_26048 = (state_26280[(35)]);
var inst_26046 = (state_26280[(34)]);
var inst_26050 = cljs.core.sorted_map_by(inst_26046);
var inst_26051 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26050,inst_26048);
var state_26280__$1 = state_26280;
var statearr_26383_26518 = state_26280__$1;
(statearr_26383_26518[(2)] = inst_26051);

(statearr_26383_26518[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (5))){
var _ = (function (){var statearr_26384 = state_26280;
(statearr_26384[(4)] = cljs.core.rest((state_26280[(4)])));

return statearr_26384;
})();
var state_26280__$1 = state_26280;
var ex26379 = (state_26280__$1[(2)]);
var statearr_26385_26519 = state_26280__$1;
(statearr_26385_26519[(5)] = ex26379);


if((ex26379 instanceof Error)){
var statearr_26386_26520 = state_26280__$1;
(statearr_26386_26520[(1)] = (4));

(statearr_26386_26520[(5)] = null);

} else {
throw ex26379;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (83))){
var state_26280__$1 = state_26280;
var statearr_26387_26521 = state_26280__$1;
(statearr_26387_26521[(2)] = limit);

(statearr_26387_26521[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (14))){
var inst_26242 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26388_26522 = state_26280__$1;
(statearr_26388_26522[(2)] = inst_26242);

(statearr_26388_26522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (45))){
var inst_26158 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
if(cljs.core.truth_(inst_26158)){
var statearr_26389_26523 = state_26280__$1;
(statearr_26389_26523[(1)] = (46));

} else {
var statearr_26390_26524 = state_26280__$1;
(statearr_26390_26524[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (53))){
var inst_26106 = (state_26280[(11)]);
var state_26280__$1 = state_26280;
var statearr_26391_26525 = state_26280__$1;
(statearr_26391_26525[(2)] = inst_26106);

(statearr_26391_26525[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (78))){
var inst_26107 = (state_26280[(12)]);
var inst_26219 = (state_26280[(2)]);
var inst_26220 = (inst_26107 <= (0));
var state_26280__$1 = (function (){var statearr_26392 = state_26280;
(statearr_26392[(37)] = inst_26219);

return statearr_26392;
})();
if(cljs.core.truth_(inst_26220)){
var statearr_26393_26526 = state_26280__$1;
(statearr_26393_26526[(1)] = (79));

} else {
var statearr_26394_26527 = state_26280__$1;
(statearr_26394_26527[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (26))){
var inst_26238 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26395_26528 = state_26280__$1;
(statearr_26395_26528[(2)] = inst_26238);

(statearr_26395_26528[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (16))){
var state_26280__$1 = state_26280;
var statearr_26396_26529 = state_26280__$1;
(statearr_26396_26529[(2)] = null);

(statearr_26396_26529[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (81))){
var inst_26219 = (state_26280[(37)]);
var inst_26152 = (state_26280[(18)]);
var inst_26118 = (state_26280[(19)]);
var inst_26117 = (state_26280[(8)]);
var inst_26121 = (state_26280[(20)]);
var inst_26108 = (state_26280[(10)]);
var inst_26225 = (state_26280[(2)]);
var inst_26226 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26108,inst_26117,inst_26152);
var inst_26104 = inst_26118;
var inst_26105 = inst_26121;
var inst_26106 = inst_26219;
var inst_26107 = inst_26225;
var inst_26108__$1 = inst_26226;
var state_26280__$1 = (function (){var statearr_26399 = state_26280;
(statearr_26399[(22)] = inst_26105);

(statearr_26399[(11)] = inst_26106);

(statearr_26399[(23)] = inst_26104);

(statearr_26399[(12)] = inst_26107);

(statearr_26399[(10)] = inst_26108__$1);

return statearr_26399;
})();
var statearr_26400_26530 = state_26280__$1;
(statearr_26400_26530[(2)] = null);

(statearr_26400_26530[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (79))){
var state_26280__$1 = state_26280;
var statearr_26401_26531 = state_26280__$1;
(statearr_26401_26531[(2)] = (0));

(statearr_26401_26531[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (38))){
var inst_26118 = (state_26280[(19)]);
var inst_26106 = (state_26280[(11)]);
var inst_26121 = (state_26280[(20)]);
var inst_26108 = (state_26280[(10)]);
var inst_26143 = (state_26280[(2)]);
var tmp26397 = inst_26106;
var tmp26398 = inst_26108;
var inst_26104 = inst_26118;
var inst_26105 = inst_26121;
var inst_26106__$1 = tmp26397;
var inst_26107 = inst_26143;
var inst_26108__$1 = tmp26398;
var state_26280__$1 = (function (){var statearr_26402 = state_26280;
(statearr_26402[(22)] = inst_26105);

(statearr_26402[(11)] = inst_26106__$1);

(statearr_26402[(23)] = inst_26104);

(statearr_26402[(12)] = inst_26107);

(statearr_26402[(10)] = inst_26108__$1);

return statearr_26402;
})();
var statearr_26403_26532 = state_26280__$1;
(statearr_26403_26532[(2)] = null);

(statearr_26403_26532[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (87))){
var state_26280__$1 = state_26280;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26404_26533 = state_26280__$1;
(statearr_26404_26533[(1)] = (92));

} else {
var statearr_26405_26534 = state_26280__$1;
(statearr_26405_26534[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (30))){
var inst_26108 = (state_26280[(10)]);
var state_26280__$1 = state_26280;
var statearr_26406_26535 = state_26280__$1;
(statearr_26406_26535[(2)] = inst_26108);

(statearr_26406_26535[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (73))){
var inst_26108 = (state_26280[(10)]);
var state_26280__$1 = state_26280;
var statearr_26407_26536 = state_26280__$1;
(statearr_26407_26536[(2)] = inst_26108);

(statearr_26407_26536[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (96))){
var state_26280__$1 = state_26280;
var statearr_26408_26537 = state_26280__$1;
(statearr_26408_26537[(2)] = null);

(statearr_26408_26537[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (10))){
var inst_26048 = (state_26280[(35)]);
var state_26280__$1 = state_26280;
var statearr_26409_26538 = state_26280__$1;
(statearr_26409_26538[(2)] = inst_26048);

(statearr_26409_26538[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (18))){
var inst_26098 = (state_26280[(36)]);
var inst_26097 = (state_26280[(2)]);
var inst_26098__$1 = offset;
var state_26280__$1 = (function (){var statearr_26410 = state_26280;
(statearr_26410[(36)] = inst_26098__$1);

(statearr_26410[(25)] = inst_26097);

return statearr_26410;
})();
if(cljs.core.truth_(inst_26098__$1)){
var statearr_26411_26539 = state_26280__$1;
(statearr_26411_26539[(1)] = (19));

} else {
var statearr_26412_26540 = state_26280__$1;
(statearr_26412_26540[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (52))){
var inst_26106 = (state_26280[(11)]);
var inst_26168 = ((0) < inst_26106);
var state_26280__$1 = state_26280;
var statearr_26413_26541 = state_26280__$1;
(statearr_26413_26541[(2)] = inst_26168);

(statearr_26413_26541[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (67))){
var inst_26122 = (state_26280[(27)]);
var inst_26176 = (state_26280[(9)]);
var inst_26107 = (state_26280[(12)]);
var inst_26191 = cljs.core.count(inst_26176);
var inst_26192 = (inst_26122 - inst_26191);
var inst_26193 = (inst_26107 - inst_26192);
var state_26280__$1 = state_26280;
var statearr_26414_26542 = state_26280__$1;
(statearr_26414_26542[(2)] = inst_26193);

(statearr_26414_26542[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (71))){
var inst_26176 = (state_26280[(9)]);
var inst_26204 = cljs.core.empty_QMARK_(inst_26176);
var state_26280__$1 = state_26280;
var statearr_26415_26543 = state_26280__$1;
(statearr_26415_26543[(2)] = inst_26204);

(statearr_26415_26543[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (42))){
var inst_26152 = (state_26280[(18)]);
var inst_26153 = (state_26280[(33)]);
var inst_26151 = (state_26280[(2)]);
var inst_26152__$1 = fluree.db.util.async.throw_err(inst_26151);
var inst_26153__$1 = cljs.core.coll_QMARK_(inst_26152__$1);
var state_26280__$1 = (function (){var statearr_26416 = state_26280;
(statearr_26416[(18)] = inst_26152__$1);

(statearr_26416[(33)] = inst_26153__$1);

return statearr_26416;
})();
if(inst_26153__$1){
var statearr_26417_26544 = state_26280__$1;
(statearr_26417_26544[(1)] = (43));

} else {
var statearr_26418_26545 = state_26280__$1;
(statearr_26418_26545[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (80))){
var inst_26107 = (state_26280[(12)]);
var inst_26223 = (inst_26107 - (1));
var state_26280__$1 = state_26280;
var statearr_26419_26546 = state_26280__$1;
(statearr_26419_26546[(2)] = inst_26223);

(statearr_26419_26546[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (37))){
var inst_26122 = (state_26280[(27)]);
var inst_26107 = (state_26280[(12)]);
var inst_26141 = (inst_26107 - inst_26122);
var state_26280__$1 = state_26280;
var statearr_26420_26547 = state_26280__$1;
(statearr_26420_26547[(2)] = inst_26141);

(statearr_26420_26547[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (63))){
var inst_26176 = (state_26280[(9)]);
var inst_26201 = (state_26280[(7)]);
var inst_26200 = (state_26280[(2)]);
var inst_26201__$1 = (inst_26176 == null);
var state_26280__$1 = (function (){var statearr_26421 = state_26280;
(statearr_26421[(21)] = inst_26200);

(statearr_26421[(7)] = inst_26201__$1);

return statearr_26421;
})();
if(cljs.core.truth_(inst_26201__$1)){
var statearr_26422_26548 = state_26280__$1;
(statearr_26422_26548[(1)] = (70));

} else {
var statearr_26423_26549 = state_26280__$1;
(statearr_26423_26549[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (94))){
var inst_26271 = (state_26280[(2)]);
var state_26280__$1 = state_26280;
var statearr_26424_26550 = state_26280__$1;
(statearr_26424_26550[(2)] = inst_26271);

(statearr_26424_26550[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (8))){
var inst_26275 = (state_26280[(2)]);
var _ = (function (){var statearr_26425 = state_26280;
(statearr_26425[(4)] = cljs.core.rest((state_26280[(4)])));

return statearr_26425;
})();
var state_26280__$1 = state_26280;
var statearr_26426_26551 = state_26280__$1;
(statearr_26426_26551[(2)] = inst_26275);

(statearr_26426_26551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (49))){
var inst_26152 = (state_26280[(18)]);
var inst_26107 = (state_26280[(12)]);
var inst_26163 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_26107,inst_26152);
var state_26280__$1 = state_26280;
var statearr_26427_26552 = state_26280__$1;
(statearr_26427_26552[(2)] = inst_26163);

(statearr_26427_26552[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26281 === (84))){
var inst_26247 = (state_26280[(2)]);
var inst_26248 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_26247,opts);
var state_26280__$1 = state_26280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26280__$1,(85),inst_26248);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0 = (function (){
var statearr_26428 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26428[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__);

(statearr_26428[(1)] = (1));

return statearr_26428;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1 = (function (state_26280){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26280);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26429){var ex__2687__auto__ = e26429;
var statearr_26430_26553 = state_26280;
(statearr_26430_26553[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26280[(4)]))){
var statearr_26431_26554 = state_26280;
(statearr_26431_26554[(1)] = cljs.core.first((state_26280[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26555 = state_26280;
state_26280 = G__26555;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__ = function(state_26280){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1.call(this,state_26280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26432 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26432[(6)] = c__2706__auto__);

return statearr_26432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__26558,opts){
var map__26559 = p__26558;
var map__26559__$1 = cljs.core.__destructure_map(map__26559);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26559__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26559__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26559__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26559__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__5045__auto__ = selectOne;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = select;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__26556_SHARP_){
return cljs.core.contains_QMARK_(p1__26556_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__26557_SHARP_){
return cljs.core.contains_QMARK_(p1__26557_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5804__auto__)){
var orderBy = temp__5804__auto__;
if(cljs.core.truth_((function (){var or__5045__auto__ = typeof orderBy === 'string';
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__5043__auto__){
var G__26561 = cljs.core.first(orderBy);
var fexpr__26560 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__26560.cljs$core$IFn$_invoke$arity$1 ? fexpr__26560.cljs$core$IFn$_invoke$arity$1(G__26561) : fexpr__26560.call(null,G__26561));
} else {
return and__5043__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})(),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__5045__auto__ = selectDistinct;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__26562,p__26563){
var map__26564 = p__26562;
var map__26564__$1 = cljs.core.__destructure_map(map__26564);
var query_map = map__26564__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26564__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__26565 = p__26563;
var map__26565__$1 = cljs.core.__destructure_map(map__26565);
var where_result = map__26565__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26565__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26565__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__26566 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5802__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5802__auto__)){
var index_of = temp__5802__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26566,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26566,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26566,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26599){
var state_val_26600 = (state_26599[(1)]);
if((state_val_26600 === (7))){
var inst_26578 = (state_26599[(7)]);
var state_26599__$1 = state_26599;
var statearr_26601_26624 = state_26599__$1;
(statearr_26601_26624[(2)] = inst_26578);

(statearr_26601_26624[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (1))){
var state_26599__$1 = state_26599;
var statearr_26602_26625 = state_26599__$1;
(statearr_26602_26625[(2)] = null);

(statearr_26602_26625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (4))){
var inst_26569 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
var statearr_26603_26626 = state_26599__$1;
(statearr_26603_26626[(2)] = inst_26569);

(statearr_26603_26626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (13))){
var inst_26588 = (state_26599[(2)]);
var inst_26589 = fluree.db.util.async.throw_err(inst_26588);
var state_26599__$1 = state_26599;
var statearr_26604_26627 = state_26599__$1;
(statearr_26604_26627[(2)] = inst_26589);

(statearr_26604_26627[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (6))){
var inst_26578 = (state_26599[(7)]);
var inst_26577 = (state_26599[(2)]);
var inst_26578__$1 = fluree.db.util.async.throw_err(inst_26577);
var inst_26579 = fluree.db.util.core.exception_QMARK_(inst_26578__$1);
var state_26599__$1 = (function (){var statearr_26605 = state_26599;
(statearr_26605[(7)] = inst_26578__$1);

return statearr_26605;
})();
if(inst_26579){
var statearr_26606_26628 = state_26599__$1;
(statearr_26606_26628[(1)] = (7));

} else {
var statearr_26607_26629 = state_26599__$1;
(statearr_26607_26629[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (3))){
var inst_26597 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26599__$1,inst_26597);
} else {
if((state_val_26600 === (12))){
var inst_26592 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
var statearr_26608_26630 = state_26599__$1;
(statearr_26608_26630[(2)] = inst_26592);

(statearr_26608_26630[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (2))){
var _ = (function (){var statearr_26609 = state_26599;
(statearr_26609[(4)] = cljs.core.cons((5),(state_26599[(4)])));

return statearr_26609;
})();
var inst_26575 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_26599__$1 = state_26599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26599__$1,(6),inst_26575);
} else {
if((state_val_26600 === (11))){
var state_26599__$1 = state_26599;
var statearr_26611_26631 = state_26599__$1;
(statearr_26611_26631[(2)] = null);

(statearr_26611_26631[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (9))){
var inst_26594 = (state_26599[(2)]);
var _ = (function (){var statearr_26612 = state_26599;
(statearr_26612[(4)] = cljs.core.rest((state_26599[(4)])));

return statearr_26612;
})();
var state_26599__$1 = state_26599;
var statearr_26613_26632 = state_26599__$1;
(statearr_26613_26632[(2)] = inst_26594);

(statearr_26613_26632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (5))){
var _ = (function (){var statearr_26614 = state_26599;
(statearr_26614[(4)] = cljs.core.rest((state_26599[(4)])));

return statearr_26614;
})();
var state_26599__$1 = state_26599;
var ex26610 = (state_26599__$1[(2)]);
var statearr_26615_26633 = state_26599__$1;
(statearr_26615_26633[(5)] = ex26610);


if((ex26610 instanceof Error)){
var statearr_26616_26634 = state_26599__$1;
(statearr_26616_26634[(1)] = (4));

(statearr_26616_26634[(5)] = null);

} else {
throw ex26610;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (10))){
var inst_26578 = (state_26599[(7)]);
var inst_26583 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_26578);
var inst_26584 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_26578);
var inst_26585 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_26583,inst_26584,query_map,opts);
var inst_26586 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_26578,inst_26585,opts);
var state_26599__$1 = state_26599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26599__$1,(13),inst_26586);
} else {
if((state_val_26600 === (8))){
var state_26599__$1 = state_26599;
var statearr_26617_26635 = state_26599__$1;
(statearr_26617_26635[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto____0 = (function (){
var statearr_26619 = [null,null,null,null,null,null,null,null];
(statearr_26619[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto__);

(statearr_26619[(1)] = (1));

return statearr_26619;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto____1 = (function (state_26599){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26599);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26620){var ex__2687__auto__ = e26620;
var statearr_26621_26636 = state_26599;
(statearr_26621_26636[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26599[(4)]))){
var statearr_26622_26637 = state_26599;
(statearr_26622_26637[(1)] = cljs.core.first((state_26599[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26638 = state_26599;
state_26599 = G__26638;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto__ = function(state_26599){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto____1.call(this,state_26599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26623 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26623[(6)] = c__2706__auto__);

return statearr_26623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__26639 = query_map;
var map__26639__$1 = cljs.core.__destructure_map(map__26639);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26639__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__26640 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__26640,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__26640;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = max_fuel;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26998){
var state_val_26999 = (state_26998[(1)]);
if((state_val_26999 === (121))){
var inst_26959 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27000_27195 = state_26998__$1;
(statearr_27000_27195[(2)] = inst_26959);

(statearr_27000_27195[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (65))){
var inst_26836 = typeof from === 'string';
var state_26998__$1 = state_26998;
if(cljs.core.truth_(inst_26836)){
var statearr_27001_27196 = state_26998__$1;
(statearr_27001_27196[(1)] = (72));

} else {
var statearr_27002_27197 = state_26998__$1;
(statearr_27002_27197[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (70))){
var inst_26702 = (state_26998[(7)]);
var inst_26704 = (state_26998[(8)]);
var inst_26829 = (state_26998[(2)]);
var inst_26830 = fluree.db.util.async.throw_err(inst_26829);
var inst_26831 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_26704,fuel,max_fuel,inst_26702,inst_26830);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(71),inst_26831);
} else {
if((state_val_26999 === (62))){
var inst_26809 = (state_26998[(9)]);
var state_26998__$1 = state_26998;
var statearr_27003_27198 = state_26998__$1;
(statearr_27003_27198[(2)] = inst_26809);

(statearr_27003_27198[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (74))){
var inst_26965 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27004_27199 = state_26998__$1;
(statearr_27004_27199[(2)] = inst_26965);

(statearr_27004_27199[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (110))){
var inst_26900 = (state_26998[(10)]);
var state_26998__$1 = state_26998;
var statearr_27005_27200 = state_26998__$1;
(statearr_27005_27200[(2)] = inst_26900);

(statearr_27005_27200[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (130))){
var inst_26985 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27006_27201 = state_26998__$1;
(statearr_27006_27201[(2)] = inst_26985);

(statearr_27006_27201[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (128))){
var inst_26976 = (state_26998[(11)]);
var inst_26981 = fluree.db.util.core.exception_QMARK_(inst_26976);
var inst_26982 = (!(inst_26981));
var state_26998__$1 = state_26998;
var statearr_27007_27202 = state_26998__$1;
(statearr_27007_27202[(2)] = inst_26982);

(statearr_27007_27202[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (7))){
var inst_26672 = (state_26998[(12)]);
var inst_26672__$1 = selectOne;
var state_26998__$1 = (function (){var statearr_27008 = state_26998;
(statearr_27008[(12)] = inst_26672__$1);

return statearr_27008;
})();
if(cljs.core.truth_(inst_26672__$1)){
var statearr_27009_27203 = state_26998__$1;
(statearr_27009_27203[(1)] = (9));

} else {
var statearr_27010_27204 = state_26998__$1;
(statearr_27010_27204[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (59))){
var inst_26787 = (state_26998[(13)]);
var inst_26692 = (state_26998[(14)]);
var inst_26702 = (state_26998[(7)]);
var inst_26704 = (state_26998[(8)]);
var inst_26801 = (state_26998[(2)]);
var inst_26802 = fluree.db.util.async.throw_err(inst_26801);
var inst_26803 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_26787,inst_26802);
var inst_26804 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_26704,fuel,max_fuel,inst_26702,inst_26803,inst_26692);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(60),inst_26804);
} else {
if((state_val_26999 === (86))){
var inst_26692 = (state_26998[(14)]);
var inst_26702 = (state_26998[(7)]);
var inst_26694 = (state_26998[(15)]);
var inst_26704 = (state_26998[(8)]);
var inst_26869 = (state_26998[(2)]);
var inst_26870 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_26704,fuel,max_fuel,inst_26702,inst_26869,inst_26692,inst_26694);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(87),inst_26870);
} else {
if((state_val_26999 === (20))){
var inst_26736 = (state_26998[(2)]);
var inst_26737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26736,(0),null);
var inst_26738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26736,(1),null);
var inst_26739 = typeof where === 'string';
var state_26998__$1 = (function (){var statearr_27011 = state_26998;
(statearr_27011[(16)] = inst_26737);

(statearr_27011[(17)] = inst_26738);

return statearr_27011;
})();
if(cljs.core.truth_(inst_26739)){
var statearr_27012_27205 = state_26998__$1;
(statearr_27012_27205[(1)] = (30));

} else {
var statearr_27013_27206 = state_26998__$1;
(statearr_27013_27206[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (72))){
var inst_26691 = (state_26998[(18)]);
var state_26998__$1 = state_26998;
if(cljs.core.truth_(inst_26691)){
var statearr_27014_27207 = state_26998__$1;
(statearr_27014_27207[(1)] = (75));

} else {
var statearr_27015_27208 = state_26998__$1;
(statearr_27015_27208[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (58))){
var inst_26795 = (state_26998[(2)]);
var inst_26796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26797 = [from];
var inst_26798 = (new cljs.core.PersistentVector(null,1,(5),inst_26796,inst_26797,null));
var inst_26799 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26798,inst_26795);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(59),inst_26799);
} else {
if((state_val_26999 === (60))){
var inst_26806 = (state_26998[(2)]);
var inst_26807 = fluree.db.util.async.throw_err(inst_26806);
var state_26998__$1 = state_26998;
var statearr_27016_27209 = state_26998__$1;
(statearr_27016_27209[(2)] = inst_26807);

(statearr_27016_27209[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (27))){
var inst_26721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26722 = [null,null];
var inst_26723 = (new cljs.core.PersistentVector(null,2,(5),inst_26721,inst_26722,null));
var state_26998__$1 = state_26998;
var statearr_27017_27210 = state_26998__$1;
(statearr_27017_27210[(2)] = inst_26723);

(statearr_27017_27210[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (1))){
var state_26998__$1 = state_26998;
var statearr_27018_27211 = state_26998__$1;
(statearr_27018_27211[(2)] = null);

(statearr_27018_27211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (69))){
var inst_26826 = (state_26998[(2)]);
var inst_26827 = fluree.db.query.range._block_or_tx_collection(db,inst_26826);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(70),inst_26827);
} else {
if((state_val_26999 === (101))){
var inst_26932 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27019_27212 = state_26998__$1;
(statearr_27019_27212[(2)] = inst_26932);

(statearr_27019_27212[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (24))){
var inst_26691 = (state_26998[(18)]);
var inst_26716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26717 = [inst_26691,"ASC"];
var inst_26718 = (new cljs.core.PersistentVector(null,2,(5),inst_26716,inst_26717,null));
var state_26998__$1 = state_26998;
var statearr_27020_27213 = state_26998__$1;
(statearr_27020_27213[(2)] = inst_26718);

(statearr_27020_27213[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (102))){
var inst_26906 = (state_26998[(19)]);
var state_26998__$1 = state_26998;
var statearr_27021_27214 = state_26998__$1;
(statearr_27021_27214[(2)] = inst_26906);

(statearr_27021_27214[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (55))){
var inst_26691 = (state_26998[(18)]);
var inst_26787 = (state_26998[(2)]);
var state_26998__$1 = (function (){var statearr_27022 = state_26998;
(statearr_27022[(13)] = inst_26787);

return statearr_27022;
})();
if(cljs.core.truth_(inst_26691)){
var statearr_27023_27215 = state_26998__$1;
(statearr_27023_27215[(1)] = (56));

} else {
var statearr_27024_27216 = state_26998__$1;
(statearr_27024_27216[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (85))){
var inst_26861 = (state_26998[(20)]);
var inst_26865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26866 = [inst_26861];
var inst_26867 = (new cljs.core.PersistentVector(null,1,(5),inst_26865,inst_26866,null));
var state_26998__$1 = state_26998;
var statearr_27025_27217 = state_26998__$1;
(statearr_27025_27217[(2)] = inst_26867);

(statearr_27025_27217[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (39))){
var inst_26692 = (state_26998[(14)]);
var state_26998__$1 = state_26998;
var statearr_27026_27218 = state_26998__$1;
(statearr_27026_27218[(2)] = inst_26692);

(statearr_27026_27218[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (88))){
var inst_26875 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_26998__$1 = state_26998;
var statearr_27027_27219 = state_26998__$1;
(statearr_27027_27219[(2)] = inst_26875);

(statearr_27027_27219[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (46))){
var inst_26772 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
if(cljs.core.truth_(inst_26772)){
var statearr_27028_27220 = state_26998__$1;
(statearr_27028_27220[(1)] = (47));

} else {
var statearr_27029_27221 = state_26998__$1;
(statearr_27029_27221[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (4))){
var inst_26659 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27030_27222 = state_26998__$1;
(statearr_27030_27222[(2)] = inst_26659);

(statearr_27030_27222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (77))){
var inst_26845 = (state_26998[(2)]);
var inst_26846 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_26845);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(78),inst_26846);
} else {
if((state_val_26999 === (106))){
var state_26998__$1 = state_26998;
var statearr_27031_27223 = state_26998__$1;
(statearr_27031_27223[(2)] = null);

(statearr_27031_27223[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (119))){
var inst_26951 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_26952 = ["Invalid 'from' in query:",inst_26951].join('');
var inst_26953 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26954 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26955 = cljs.core.PersistentHashMap.fromArrays(inst_26953,inst_26954);
var inst_26956 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26952,inst_26955);
var state_26998__$1 = state_26998;
var statearr_27032_27224 = state_26998__$1;
(statearr_27032_27224[(2)] = inst_26956);

(statearr_27032_27224[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (95))){
var state_26998__$1 = state_26998;
var statearr_27033_27225 = state_26998__$1;
(statearr_27033_27225[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (54))){
var inst_26781 = (state_26998[(21)]);
var state_26998__$1 = state_26998;
var statearr_27035_27226 = state_26998__$1;
(statearr_27035_27226[(2)] = inst_26781);

(statearr_27035_27226[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (92))){
var inst_26880 = (state_26998[(22)]);
var state_26998__$1 = state_26998;
var statearr_27036_27227 = state_26998__$1;
(statearr_27036_27227[(2)] = inst_26880);

(statearr_27036_27227[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (104))){
var inst_26924 = (state_26998[(23)]);
var inst_26924__$1 = (state_26998[(2)]);
var state_26998__$1 = (function (){var statearr_27037 = state_26998;
(statearr_27037[(23)] = inst_26924__$1);

return statearr_27037;
})();
if(cljs.core.truth_(inst_26924__$1)){
var statearr_27038_27228 = state_26998__$1;
(statearr_27038_27228[(1)] = (109));

} else {
var statearr_27039_27229 = state_26998__$1;
(statearr_27039_27229[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (15))){
var inst_26693 = (state_26998[(24)]);
var inst_26695 = (state_26998[(25)]);
var inst_26699 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26695,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_26693);
var state_26998__$1 = state_26998;
var statearr_27040_27230 = state_26998__$1;
(statearr_27040_27230[(2)] = inst_26699);

(statearr_27040_27230[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (48))){
var inst_26809 = (state_26998[(9)]);
var inst_26809__$1 = typeof from === 'string';
var state_26998__$1 = (function (){var statearr_27041 = state_26998;
(statearr_27041[(9)] = inst_26809__$1);

return statearr_27041;
})();
if(cljs.core.truth_(inst_26809__$1)){
var statearr_27042_27231 = state_26998__$1;
(statearr_27042_27231[(1)] = (61));

} else {
var statearr_27043_27232 = state_26998__$1;
(statearr_27043_27232[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (50))){
var inst_26775 = (state_26998[(26)]);
var inst_26777 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_26778 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_26775,inst_26777);
var state_26998__$1 = state_26998;
var statearr_27044_27233 = state_26998__$1;
(statearr_27044_27233[(2)] = inst_26778);

(statearr_27044_27233[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (116))){
var state_26998__$1 = state_26998;
var statearr_27045_27234 = state_26998__$1;
(statearr_27045_27234[(2)] = null);

(statearr_27045_27234[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (75))){
var inst_26839 = cljs.core.PersistentHashMap.EMPTY;
var state_26998__$1 = state_26998;
var statearr_27046_27235 = state_26998__$1;
(statearr_27046_27235[(2)] = inst_26839);

(statearr_27046_27235[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (99))){
var inst_26900 = (state_26998[(10)]);
var state_26998__$1 = state_26998;
var statearr_27047_27236 = state_26998__$1;
(statearr_27047_27236[(2)] = inst_26900);

(statearr_27047_27236[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (21))){
var inst_26691 = (state_26998[(18)]);
var inst_26708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26709 = cljs.core.second(inst_26691);
var inst_26710 = cljs.core.first(inst_26691);
var inst_26711 = [inst_26709,inst_26710];
var inst_26712 = (new cljs.core.PersistentVector(null,2,(5),inst_26708,inst_26711,null));
var state_26998__$1 = state_26998;
var statearr_27048_27237 = state_26998__$1;
(statearr_27048_27237[(2)] = inst_26712);

(statearr_27048_27237[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (31))){
var inst_26766 = (state_26998[(27)]);
var inst_26766__$1 = typeof from === 'string';
var state_26998__$1 = (function (){var statearr_27049 = state_26998;
(statearr_27049[(27)] = inst_26766__$1);

return statearr_27049;
})();
if(cljs.core.truth_(inst_26766__$1)){
var statearr_27050_27238 = state_26998__$1;
(statearr_27050_27238[(1)] = (44));

} else {
var statearr_27051_27239 = state_26998__$1;
(statearr_27051_27239[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (113))){
var state_26998__$1 = state_26998;
var statearr_27052_27240 = state_26998__$1;
(statearr_27052_27240[(2)] = null);

(statearr_27052_27240[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (32))){
var inst_26737 = (state_26998[(16)]);
var inst_26971 = (state_26998[(2)]);
var state_26998__$1 = (function (){var statearr_27053 = state_26998;
(statearr_27053[(28)] = inst_26971);

return statearr_27053;
})();
if(cljs.core.truth_(inst_26737)){
var statearr_27054_27241 = state_26998__$1;
(statearr_27054_27241[(1)] = (122));

} else {
var statearr_27055_27242 = state_26998__$1;
(statearr_27055_27242[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (40))){
var inst_26691 = (state_26998[(18)]);
var inst_26756 = (state_26998[(2)]);
var state_26998__$1 = (function (){var statearr_27056 = state_26998;
(statearr_27056[(29)] = inst_26756);

return statearr_27056;
})();
if(cljs.core.truth_(inst_26691)){
var statearr_27057_27243 = state_26998__$1;
(statearr_27057_27243[(1)] = (41));

} else {
var statearr_27058_27244 = state_26998__$1;
(statearr_27058_27244[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (129))){
var inst_26979 = (state_26998[(30)]);
var state_26998__$1 = state_26998;
var statearr_27059_27245 = state_26998__$1;
(statearr_27059_27245[(2)] = inst_26979);

(statearr_27059_27245[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (91))){
var inst_26882 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_26998__$1 = state_26998;
var statearr_27060_27246 = state_26998__$1;
(statearr_27060_27246[(2)] = inst_26882);

(statearr_27060_27246[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (117))){
var inst_26694 = (state_26998[(15)]);
var state_26998__$1 = state_26998;
var statearr_27061_27247 = state_26998__$1;
(statearr_27061_27247[(2)] = inst_26694);

(statearr_27061_27247[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (108))){
var inst_26921 = (state_26998[(2)]);
var inst_26922 = fluree.db.util.async.throw_err(inst_26921);
var state_26998__$1 = state_26998;
var statearr_27062_27248 = state_26998__$1;
(statearr_27062_27248[(2)] = inst_26922);

(statearr_27062_27248[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (56))){
var inst_26789 = cljs.core.PersistentHashMap.EMPTY;
var state_26998__$1 = state_26998;
var statearr_27063_27249 = state_26998__$1;
(statearr_27063_27249[(2)] = inst_26789);

(statearr_27063_27249[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (33))){
var state_26998__$1 = state_26998;
var statearr_27064_27250 = state_26998__$1;
(statearr_27064_27250[(2)] = from);

(statearr_27064_27250[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (13))){
var inst_26678 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26679 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26680 = cljs.core.PersistentHashMap.fromArrays(inst_26678,inst_26679);
var inst_26681 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_26680);
var inst_26682 = (function(){throw inst_26681})();
var state_26998__$1 = state_26998;
var statearr_27065_27251 = state_26998__$1;
(statearr_27065_27251[(2)] = inst_26682);

(statearr_27065_27251[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (22))){
var inst_26691 = (state_26998[(18)]);
var inst_26714 = typeof inst_26691 === 'string';
var state_26998__$1 = state_26998;
if(cljs.core.truth_(inst_26714)){
var statearr_27066_27252 = state_26998__$1;
(statearr_27066_27252[(1)] = (24));

} else {
var statearr_27067_27253 = state_26998__$1;
(statearr_27067_27253[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (90))){
var inst_26873 = (state_26998[(31)]);
var inst_26878 = (state_26998[(2)]);
var state_26998__$1 = (function (){var statearr_27068 = state_26998;
(statearr_27068[(32)] = inst_26878);

return statearr_27068;
})();
var statearr_27069_27254 = state_26998__$1;
(statearr_27069_27254[(2)] = inst_26873);

(statearr_27069_27254[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (109))){
var inst_26924 = (state_26998[(23)]);
var inst_26900 = (state_26998[(10)]);
var inst_26926 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26900,inst_26924);
var state_26998__$1 = state_26998;
var statearr_27070_27255 = state_26998__$1;
(statearr_27070_27255[(2)] = inst_26926);

(statearr_27070_27255[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (36))){
var inst_26691 = (state_26998[(18)]);
var inst_26751 = (state_26998[(2)]);
var inst_26752 = fluree.db.util.async.throw_err(inst_26751);
var state_26998__$1 = (function (){var statearr_27071 = state_26998;
(statearr_27071[(33)] = inst_26752);

return statearr_27071;
})();
if(cljs.core.truth_(inst_26691)){
var statearr_27072_27256 = state_26998__$1;
(statearr_27072_27256[(1)] = (38));

} else {
var statearr_27073_27257 = state_26998__$1;
(statearr_27073_27257[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (41))){
var state_26998__$1 = state_26998;
var statearr_27074_27258 = state_26998__$1;
(statearr_27074_27258[(2)] = null);

(statearr_27074_27258[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (118))){
var inst_26940 = (state_26998[(34)]);
var inst_26702 = (state_26998[(7)]);
var inst_26936 = (state_26998[(35)]);
var inst_26704 = (state_26998[(8)]);
var inst_26944 = (state_26998[(2)]);
var inst_26945 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_26704,fuel,max_fuel,inst_26702,inst_26936,inst_26940,inst_26944);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(112),inst_26945);
} else {
if((state_val_26999 === (89))){
var state_26998__$1 = state_26998;
var statearr_27075_27259 = state_26998__$1;
(statearr_27075_27259[(2)] = null);

(statearr_27075_27259[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (100))){
var inst_26906 = (state_26998[(19)]);
var inst_26911 = cljs.core.int_QMARK_(inst_26906);
var state_26998__$1 = state_26998;
if(inst_26911){
var statearr_27076_27260 = state_26998__$1;
(statearr_27076_27260[(1)] = (102));

} else {
var statearr_27077_27261 = state_26998__$1;
(statearr_27077_27261[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (131))){
var inst_26976 = (state_26998[(11)]);
var inst_26990 = cljs.core.first(inst_26976);
var state_26998__$1 = state_26998;
var statearr_27078_27262 = state_26998__$1;
(statearr_27078_27262[(2)] = inst_26990);

(statearr_27078_27262[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (122))){
var inst_26737 = (state_26998[(16)]);
var inst_26692 = (state_26998[(14)]);
var inst_26738 = (state_26998[(17)]);
var inst_26694 = (state_26998[(15)]);
var inst_26971 = (state_26998[(28)]);
var inst_26973 = fluree.db.query.fql.sort_offset_and_limit_res(inst_26737,inst_26738,inst_26694,inst_26692,inst_26971);
var state_26998__$1 = state_26998;
var statearr_27079_27263 = state_26998__$1;
(statearr_27079_27263[(2)] = inst_26973);

(statearr_27079_27263[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (43))){
var inst_26752 = (state_26998[(33)]);
var inst_26702 = (state_26998[(7)]);
var inst_26756 = (state_26998[(29)]);
var inst_26704 = (state_26998[(8)]);
var inst_26760 = (state_26998[(2)]);
var inst_26761 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_26704,fuel,max_fuel,inst_26702,inst_26752,inst_26756,inst_26760);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(37),inst_26761);
} else {
if((state_val_26999 === (61))){
var inst_26811 = ["_tx",null,"_block",null];
var inst_26812 = (new cljs.core.PersistentArrayMap(null,2,inst_26811,null));
var inst_26813 = (new cljs.core.PersistentHashSet(null,inst_26812,null));
var inst_26814 = (inst_26813.cljs$core$IFn$_invoke$arity$1 ? inst_26813.cljs$core$IFn$_invoke$arity$1(from) : inst_26813.call(null,from));
var state_26998__$1 = state_26998;
var statearr_27080_27264 = state_26998__$1;
(statearr_27080_27264[(2)] = inst_26814);

(statearr_27080_27264[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (29))){
var inst_26726 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27081_27265 = state_26998__$1;
(statearr_27081_27265[(2)] = inst_26726);

(statearr_27081_27265[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (44))){
var inst_26768 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_26769 = clojure.string.includes_QMARK_(inst_26768,"/");
var state_26998__$1 = state_26998;
var statearr_27082_27266 = state_26998__$1;
(statearr_27082_27266[(2)] = inst_26769);

(statearr_27082_27266[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (93))){
var inst_26885 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
if(cljs.core.truth_(inst_26885)){
var statearr_27083_27267 = state_26998__$1;
(statearr_27083_27267[(1)] = (94));

} else {
var statearr_27084_27268 = state_26998__$1;
(statearr_27084_27268[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (6))){
var inst_26669 = (state_26998[(36)]);
var state_26998__$1 = state_26998;
var statearr_27085_27269 = state_26998__$1;
(statearr_27085_27269[(2)] = inst_26669);

(statearr_27085_27269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (111))){
var inst_26907 = (state_26998[(37)]);
var inst_26929 = (state_26998[(2)]);
var inst_26899 = inst_26907;
var inst_26900 = inst_26929;
var state_26998__$1 = (function (){var statearr_27086 = state_26998;
(statearr_27086[(38)] = inst_26899);

(statearr_27086[(10)] = inst_26900);

return statearr_27086;
})();
var statearr_27087_27270 = state_26998__$1;
(statearr_27087_27270[(2)] = null);

(statearr_27087_27270[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (28))){
var state_26998__$1 = state_26998;
var statearr_27088_27271 = state_26998__$1;
(statearr_27088_27271[(2)] = null);

(statearr_27088_27271[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (64))){
var inst_26691 = (state_26998[(18)]);
var state_26998__$1 = state_26998;
if(cljs.core.truth_(inst_26691)){
var statearr_27089_27272 = state_26998__$1;
(statearr_27089_27272[(1)] = (67));

} else {
var statearr_27090_27273 = state_26998__$1;
(statearr_27090_27273[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (103))){
var state_26998__$1 = state_26998;
if(cljs.core.truth_(fuel)){
var statearr_27091_27274 = state_26998__$1;
(statearr_27091_27274[(1)] = (105));

} else {
var statearr_27092_27275 = state_26998__$1;
(statearr_27092_27275[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (51))){
var inst_26775 = (state_26998[(26)]);
var state_26998__$1 = state_26998;
var statearr_27093_27276 = state_26998__$1;
(statearr_27093_27276[(2)] = inst_26775);

(statearr_27093_27276[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (25))){
var state_26998__$1 = state_26998;
var statearr_27094_27277 = state_26998__$1;
(statearr_27094_27277[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (34))){
var state_26998__$1 = state_26998;
var statearr_27096_27278 = state_26998__$1;
(statearr_27096_27278[(2)] = null);

(statearr_27096_27278[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (125))){
var inst_26976 = (state_26998[(11)]);
var inst_26979 = (state_26998[(30)]);
var inst_26979__$1 = cljs.core.coll_QMARK_(inst_26976);
var state_26998__$1 = (function (){var statearr_27097 = state_26998;
(statearr_27097[(30)] = inst_26979__$1);

return statearr_27097;
})();
if(inst_26979__$1){
var statearr_27098_27279 = state_26998__$1;
(statearr_27098_27279[(1)] = (128));

} else {
var statearr_27099_27280 = state_26998__$1;
(statearr_27099_27280[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (17))){
var inst_26691 = (state_26998[(18)]);
var inst_26702 = (state_26998[(2)]);
var inst_26703 = cljs.core.PersistentHashMap.EMPTY;
var inst_26704 = cljs.core.volatile_BANG_(inst_26703);
var state_26998__$1 = (function (){var statearr_27100 = state_26998;
(statearr_27100[(7)] = inst_26702);

(statearr_27100[(8)] = inst_26704);

return statearr_27100;
})();
if(cljs.core.truth_(inst_26691)){
var statearr_27101_27281 = state_26998__$1;
(statearr_27101_27281[(1)] = (18));

} else {
var statearr_27102_27282 = state_26998__$1;
(statearr_27102_27282[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (3))){
var inst_26996 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26998__$1,inst_26996);
} else {
if((state_val_26999 === (12))){
var inst_26675 = (state_26998[(39)]);
var state_26998__$1 = state_26998;
var statearr_27103_27283 = state_26998__$1;
(statearr_27103_27283[(2)] = inst_26675);

(statearr_27103_27283[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (2))){
var inst_26669 = (state_26998[(36)]);
var _ = (function (){var statearr_27104 = state_26998;
(statearr_27104[(4)] = cljs.core.cons((5),(state_26998[(4)])));

return statearr_27104;
})();
var inst_26669__$1 = select;
var state_26998__$1 = (function (){var statearr_27105 = state_26998;
(statearr_27105[(36)] = inst_26669__$1);

return statearr_27105;
})();
if(cljs.core.truth_(inst_26669__$1)){
var statearr_27106_27284 = state_26998__$1;
(statearr_27106_27284[(1)] = (6));

} else {
var statearr_27107_27285 = state_26998__$1;
(statearr_27107_27285[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (66))){
var inst_26967 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27108_27286 = state_26998__$1;
(statearr_27108_27286[(2)] = inst_26967);

(statearr_27108_27286[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (107))){
var inst_26906 = (state_26998[(19)]);
var inst_26918 = (state_26998[(2)]);
var inst_26919 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_26906,false);
var state_26998__$1 = (function (){var statearr_27109 = state_26998;
(statearr_27109[(40)] = inst_26918);

return statearr_27109;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(108),inst_26919);
} else {
if((state_val_26999 === (23))){
var inst_26730 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27110_27287 = state_26998__$1;
(statearr_27110_27287[(2)] = inst_26730);

(statearr_27110_27287[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (47))){
var inst_26775 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_26998__$1 = (function (){var statearr_27111 = state_26998;
(statearr_27111[(26)] = inst_26775);

return statearr_27111;
})();
if(cljs.core.truth_(fuel)){
var statearr_27112_27288 = state_26998__$1;
(statearr_27112_27288[(1)] = (50));

} else {
var statearr_27113_27289 = state_26998__$1;
(statearr_27113_27289[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (35))){
var inst_26692 = (state_26998[(14)]);
var inst_26694 = (state_26998[(15)]);
var inst_26745 = (state_26998[(2)]);
var inst_26746 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26747 = [inst_26692,inst_26694];
var inst_26748 = cljs.core.PersistentHashMap.fromArrays(inst_26746,inst_26747);
var inst_26749 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where,inst_26745,inst_26748);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(36),inst_26749);
} else {
if((state_val_26999 === (127))){
var inst_26988 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
if(cljs.core.truth_(inst_26988)){
var statearr_27114_27290 = state_26998__$1;
(statearr_27114_27290[(1)] = (131));

} else {
var statearr_27115_27291 = state_26998__$1;
(statearr_27115_27291[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (82))){
var inst_26963 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27116_27292 = state_26998__$1;
(statearr_27116_27292[(2)] = inst_26963);

(statearr_27116_27292[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (76))){
var inst_26692 = (state_26998[(14)]);
var inst_26694 = (state_26998[(15)]);
var inst_26841 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26842 = [inst_26692,inst_26694];
var inst_26843 = cljs.core.PersistentHashMap.fromArrays(inst_26841,inst_26842);
var state_26998__$1 = state_26998;
var statearr_27117_27293 = state_26998__$1;
(statearr_27117_27293[(2)] = inst_26843);

(statearr_27117_27293[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (97))){
var inst_26906 = (state_26998[(19)]);
var inst_26899 = (state_26998[(38)]);
var inst_26905 = cljs.core.seq(inst_26899);
var inst_26906__$1 = cljs.core.first(inst_26905);
var inst_26907 = cljs.core.next(inst_26905);
var inst_26908 = cljs.core.not(inst_26906__$1);
var state_26998__$1 = (function (){var statearr_27118 = state_26998;
(statearr_27118[(19)] = inst_26906__$1);

(statearr_27118[(37)] = inst_26907);

return statearr_27118;
})();
if(inst_26908){
var statearr_27119_27294 = state_26998__$1;
(statearr_27119_27294[(1)] = (99));

} else {
var statearr_27120_27295 = state_26998__$1;
(statearr_27120_27295[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (19))){
var inst_26732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26733 = [null,null];
var inst_26734 = (new cljs.core.PersistentVector(null,2,(5),inst_26732,inst_26733,null));
var state_26998__$1 = state_26998;
var statearr_27121_27296 = state_26998__$1;
(statearr_27121_27296[(2)] = inst_26734);

(statearr_27121_27296[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (57))){
var inst_26692 = (state_26998[(14)]);
var inst_26694 = (state_26998[(15)]);
var inst_26791 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26792 = [inst_26692,inst_26694];
var inst_26793 = cljs.core.PersistentHashMap.fromArrays(inst_26791,inst_26792);
var state_26998__$1 = state_26998;
var statearr_27122_27297 = state_26998__$1;
(statearr_27122_27297[(2)] = inst_26793);

(statearr_27122_27297[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (68))){
var inst_26692 = (state_26998[(14)]);
var inst_26694 = (state_26998[(15)]);
var inst_26822 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26823 = [inst_26692,inst_26694];
var inst_26824 = cljs.core.PersistentHashMap.fromArrays(inst_26822,inst_26823);
var state_26998__$1 = state_26998;
var statearr_27123_27298 = state_26998__$1;
(statearr_27123_27298[(2)] = inst_26824);

(statearr_27123_27298[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (11))){
var inst_26686 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27124_27299 = state_26998__$1;
(statearr_27124_27299[(2)] = inst_26686);

(statearr_27124_27299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (115))){
var inst_26691 = (state_26998[(18)]);
var inst_26940 = (state_26998[(2)]);
var state_26998__$1 = (function (){var statearr_27126 = state_26998;
(statearr_27126[(34)] = inst_26940);

return statearr_27126;
})();
if(cljs.core.truth_(inst_26691)){
var statearr_27127_27300 = state_26998__$1;
(statearr_27127_27300[(1)] = (116));

} else {
var statearr_27128_27301 = state_26998__$1;
(statearr_27128_27301[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (9))){
var inst_26672 = (state_26998[(12)]);
var state_26998__$1 = state_26998;
var statearr_27129_27302 = state_26998__$1;
(statearr_27129_27302[(2)] = inst_26672);

(statearr_27129_27302[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (5))){
var _ = (function (){var statearr_27130 = state_26998;
(statearr_27130[(4)] = cljs.core.rest((state_26998[(4)])));

return statearr_27130;
})();
var state_26998__$1 = state_26998;
var ex27125 = (state_26998__$1[(2)]);
var statearr_27131_27303 = state_26998__$1;
(statearr_27131_27303[(5)] = ex27125);


if((ex27125 instanceof Error)){
var statearr_27132_27304 = state_26998__$1;
(statearr_27132_27304[(1)] = (4));

(statearr_27132_27304[(5)] = null);

} else {
throw ex27125;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (112))){
var inst_26947 = (state_26998[(2)]);
var inst_26948 = fluree.db.util.async.throw_err(inst_26947);
var state_26998__$1 = state_26998;
var statearr_27133_27305 = state_26998__$1;
(statearr_27133_27305[(2)] = inst_26948);

(statearr_27133_27305[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (83))){
var inst_26861 = (state_26998[(20)]);
var inst_26860 = (state_26998[(2)]);
var inst_26861__$1 = fluree.db.util.async.throw_err(inst_26860);
var inst_26862 = (inst_26861__$1 == null);
var state_26998__$1 = (function (){var statearr_27134 = state_26998;
(statearr_27134[(20)] = inst_26861__$1);

return statearr_27134;
})();
if(cljs.core.truth_(inst_26862)){
var statearr_27135_27306 = state_26998__$1;
(statearr_27135_27306[(1)] = (84));

} else {
var statearr_27136_27307 = state_26998__$1;
(statearr_27136_27307[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (14))){
var inst_26684 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27137_27308 = state_26998__$1;
(statearr_27137_27308[(2)] = inst_26684);

(statearr_27137_27308[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (45))){
var inst_26766 = (state_26998[(27)]);
var state_26998__$1 = state_26998;
var statearr_27138_27309 = state_26998__$1;
(statearr_27138_27309[(2)] = inst_26766);

(statearr_27138_27309[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (53))){
var inst_26781 = (state_26998[(21)]);
var inst_26783 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_26784 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_26781,inst_26783);
var state_26998__$1 = state_26998;
var statearr_27139_27310 = state_26998__$1;
(statearr_27139_27310[(2)] = inst_26784);

(statearr_27139_27310[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (78))){
var inst_26702 = (state_26998[(7)]);
var inst_26704 = (state_26998[(8)]);
var inst_26848 = (state_26998[(2)]);
var inst_26849 = fluree.db.util.async.throw_err(inst_26848);
var inst_26850 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_26704,fuel,max_fuel,inst_26702,inst_26849);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(79),inst_26850);
} else {
if((state_val_26999 === (132))){
var inst_26976 = (state_26998[(11)]);
var state_26998__$1 = state_26998;
var statearr_27140_27311 = state_26998__$1;
(statearr_27140_27311[(2)] = inst_26976);

(statearr_27140_27311[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (26))){
var inst_26728 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27141_27312 = state_26998__$1;
(statearr_27141_27312[(2)] = inst_26728);

(statearr_27141_27312[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (123))){
var inst_26971 = (state_26998[(28)]);
var state_26998__$1 = state_26998;
var statearr_27142_27313 = state_26998__$1;
(statearr_27142_27313[(2)] = inst_26971);

(statearr_27142_27313[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (16))){
var inst_26695 = (state_26998[(25)]);
var state_26998__$1 = state_26998;
var statearr_27143_27314 = state_26998__$1;
(statearr_27143_27314[(2)] = inst_26695);

(statearr_27143_27314[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (133))){
var inst_26993 = (state_26998[(2)]);
var _ = (function (){var statearr_27144 = state_26998;
(statearr_27144[(4)] = cljs.core.rest((state_26998[(4)])));

return statearr_27144;
})();
var state_26998__$1 = state_26998;
var statearr_27145_27315 = state_26998__$1;
(statearr_27145_27315[(2)] = inst_26993);

(statearr_27145_27315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (81))){
var inst_26880 = (state_26998[(22)]);
var inst_26880__$1 = cljs.core.sequential_QMARK_(from);
var state_26998__$1 = (function (){var statearr_27146 = state_26998;
(statearr_27146[(22)] = inst_26880__$1);

return statearr_27146;
})();
if(inst_26880__$1){
var statearr_27147_27316 = state_26998__$1;
(statearr_27147_27316[(1)] = (91));

} else {
var statearr_27148_27317 = state_26998__$1;
(statearr_27148_27317[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (120))){
var state_26998__$1 = state_26998;
var statearr_27149_27318 = state_26998__$1;
(statearr_27149_27318[(2)] = null);

(statearr_27149_27318[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (79))){
var inst_26852 = (state_26998[(2)]);
var inst_26853 = fluree.db.util.async.throw_err(inst_26852);
var state_26998__$1 = state_26998;
var statearr_27150_27319 = state_26998__$1;
(statearr_27150_27319[(2)] = inst_26853);

(statearr_27150_27319[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (38))){
var state_26998__$1 = state_26998;
var statearr_27151_27320 = state_26998__$1;
(statearr_27151_27320[(2)] = null);

(statearr_27151_27320[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (126))){
var inst_26977 = (state_26998[(41)]);
var state_26998__$1 = state_26998;
var statearr_27152_27321 = state_26998__$1;
(statearr_27152_27321[(2)] = inst_26977);

(statearr_27152_27321[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (98))){
var inst_26691 = (state_26998[(18)]);
var inst_26934 = (state_26998[(2)]);
var inst_26935 = cljs.core.PersistentVector.EMPTY;
var inst_26936 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26935,inst_26934);
var state_26998__$1 = (function (){var statearr_27153 = state_26998;
(statearr_27153[(35)] = inst_26936);

return statearr_27153;
})();
if(cljs.core.truth_(inst_26691)){
var statearr_27154_27322 = state_26998__$1;
(statearr_27154_27322[(1)] = (113));

} else {
var statearr_27155_27323 = state_26998__$1;
(statearr_27155_27323[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (124))){
var inst_26977 = (state_26998[(41)]);
var inst_26976 = (state_26998[(2)]);
var inst_26977__$1 = selectOne;
var state_26998__$1 = (function (){var statearr_27156 = state_26998;
(statearr_27156[(11)] = inst_26976);

(statearr_27156[(41)] = inst_26977__$1);

return statearr_27156;
})();
if(cljs.core.truth_(inst_26977__$1)){
var statearr_27157_27324 = state_26998__$1;
(statearr_27157_27324[(1)] = (125));

} else {
var statearr_27158_27325 = state_26998__$1;
(statearr_27158_27325[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (87))){
var inst_26872 = (state_26998[(2)]);
var inst_26873 = fluree.db.util.async.throw_err(inst_26872);
var state_26998__$1 = (function (){var statearr_27159 = state_26998;
(statearr_27159[(31)] = inst_26873);

return statearr_27159;
})();
if(cljs.core.truth_(fuel)){
var statearr_27160_27326 = state_26998__$1;
(statearr_27160_27326[(1)] = (88));

} else {
var statearr_27161_27327 = state_26998__$1;
(statearr_27161_27327[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (30))){
var inst_26741 = typeof from === 'string';
var state_26998__$1 = state_26998;
if(cljs.core.truth_(inst_26741)){
var statearr_27162_27328 = state_26998__$1;
(statearr_27162_27328[(1)] = (33));

} else {
var statearr_27163_27329 = state_26998__$1;
(statearr_27163_27329[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (73))){
var inst_26855 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_26998__$1 = state_26998;
if(inst_26855){
var statearr_27164_27330 = state_26998__$1;
(statearr_27164_27330[(1)] = (80));

} else {
var statearr_27165_27331 = state_26998__$1;
(statearr_27165_27331[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (96))){
var inst_26961 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27166_27332 = state_26998__$1;
(statearr_27166_27332[(2)] = inst_26961);

(statearr_27166_27332[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (10))){
var inst_26675 = (state_26998[(39)]);
var inst_26675__$1 = selectDistinct;
var state_26998__$1 = (function (){var statearr_27167 = state_26998;
(statearr_27167[(39)] = inst_26675__$1);

return statearr_27167;
})();
if(cljs.core.truth_(inst_26675__$1)){
var statearr_27168_27333 = state_26998__$1;
(statearr_27168_27333[(1)] = (12));

} else {
var statearr_27169_27334 = state_26998__$1;
(statearr_27169_27334[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (18))){
var inst_26691 = (state_26998[(18)]);
var inst_26706 = cljs.core.vector_QMARK_(inst_26691);
var state_26998__$1 = state_26998;
if(inst_26706){
var statearr_27170_27335 = state_26998__$1;
(statearr_27170_27335[(1)] = (21));

} else {
var statearr_27171_27336 = state_26998__$1;
(statearr_27171_27336[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (105))){
var inst_26915 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_26998__$1 = state_26998;
var statearr_27172_27337 = state_26998__$1;
(statearr_27172_27337[(2)] = inst_26915);

(statearr_27172_27337[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (52))){
var inst_26781 = (state_26998[(2)]);
var state_26998__$1 = (function (){var statearr_27173 = state_26998;
(statearr_27173[(21)] = inst_26781);

return statearr_27173;
})();
var statearr_27174_27338 = state_26998__$1;
(statearr_27174_27338[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (114))){
var inst_26692 = (state_26998[(14)]);
var state_26998__$1 = state_26998;
var statearr_27176_27339 = state_26998__$1;
(statearr_27176_27339[(2)] = inst_26692);

(statearr_27176_27339[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (67))){
var inst_26820 = cljs.core.PersistentHashMap.EMPTY;
var state_26998__$1 = state_26998;
var statearr_27177_27340 = state_26998__$1;
(statearr_27177_27340[(2)] = inst_26820);

(statearr_27177_27340[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (71))){
var inst_26833 = (state_26998[(2)]);
var inst_26834 = fluree.db.util.async.throw_err(inst_26833);
var state_26998__$1 = state_26998;
var statearr_27178_27341 = state_26998__$1;
(statearr_27178_27341[(2)] = inst_26834);

(statearr_27178_27341[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (42))){
var inst_26694 = (state_26998[(15)]);
var state_26998__$1 = state_26998;
var statearr_27179_27342 = state_26998__$1;
(statearr_27179_27342[(2)] = inst_26694);

(statearr_27179_27342[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (80))){
var inst_26858 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_26998__$1 = state_26998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26998__$1,(83),inst_26858);
} else {
if((state_val_26999 === (37))){
var inst_26763 = (state_26998[(2)]);
var inst_26764 = fluree.db.util.async.throw_err(inst_26763);
var state_26998__$1 = state_26998;
var statearr_27180_27343 = state_26998__$1;
(statearr_27180_27343[(2)] = inst_26764);

(statearr_27180_27343[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (63))){
var inst_26817 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
if(cljs.core.truth_(inst_26817)){
var statearr_27181_27344 = state_26998__$1;
(statearr_27181_27344[(1)] = (64));

} else {
var statearr_27182_27345 = state_26998__$1;
(statearr_27182_27345[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (94))){
var inst_26894 = from;
var inst_26895 = cljs.core.seq(inst_26894);
var inst_26896 = cljs.core.first(inst_26895);
var inst_26897 = cljs.core.next(inst_26895);
var inst_26898 = cljs.core.PersistentVector.EMPTY;
var inst_26899 = inst_26894;
var inst_26900 = inst_26898;
var state_26998__$1 = (function (){var statearr_27183 = state_26998;
(statearr_27183[(42)] = inst_26896);

(statearr_27183[(43)] = inst_26897);

(statearr_27183[(38)] = inst_26899);

(statearr_27183[(10)] = inst_26900);

return statearr_27183;
})();
var statearr_27184_27346 = state_26998__$1;
(statearr_27184_27346[(2)] = null);

(statearr_27184_27346[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (8))){
var inst_26693 = (state_26998[(24)]);
var inst_26688 = (state_26998[(2)]);
var inst_26689 = opts_SINGLEQUOTE_;
var inst_26690 = cljs.core.__destructure_map(inst_26689);
var inst_26691 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26690,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_26692 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26690,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_26693__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26690,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_26694 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26690,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_26695 = fluree.db.query.fql_parser.parse_db(db,inst_26688,opts_SINGLEQUOTE_);
var inst_26696 = (inst_26693__$1 == null);
var inst_26697 = cljs.core.not(inst_26696);
var state_26998__$1 = (function (){var statearr_27185 = state_26998;
(statearr_27185[(24)] = inst_26693__$1);

(statearr_27185[(14)] = inst_26692);

(statearr_27185[(18)] = inst_26691);

(statearr_27185[(25)] = inst_26695);

(statearr_27185[(15)] = inst_26694);

return statearr_27185;
})();
if(inst_26697){
var statearr_27186_27347 = state_26998__$1;
(statearr_27186_27347[(1)] = (15));

} else {
var statearr_27187_27348 = state_26998__$1;
(statearr_27187_27348[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (49))){
var inst_26969 = (state_26998[(2)]);
var state_26998__$1 = state_26998;
var statearr_27188_27349 = state_26998__$1;
(statearr_27188_27349[(2)] = inst_26969);

(statearr_27188_27349[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26999 === (84))){
var state_26998__$1 = state_26998;
var statearr_27189_27350 = state_26998__$1;
(statearr_27189_27350[(2)] = null);

(statearr_27189_27350[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2684__auto____0 = (function (){
var statearr_27190 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27190[(0)] = fluree$db$query$fql$query_$_state_machine__2684__auto__);

(statearr_27190[(1)] = (1));

return statearr_27190;
});
var fluree$db$query$fql$query_$_state_machine__2684__auto____1 = (function (state_26998){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26998);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27191){var ex__2687__auto__ = e27191;
var statearr_27192_27351 = state_26998;
(statearr_27192_27351[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26998[(4)]))){
var statearr_27193_27352 = state_26998;
(statearr_27193_27352[(1)] = cljs.core.first((state_26998[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27353 = state_26998;
state_26998 = G__27353;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2684__auto__ = function(state_26998){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2684__auto____1.call(this,state_26998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2684__auto____0;
fluree$db$query$fql$query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2684__auto____1;
return fluree$db$query$fql$query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27194 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27194[(6)] = c__2706__auto__);

return statearr_27194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}

});
