// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20726_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20726_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__20730 = coll;
var vec__20731 = G__20730;
var seq__20732 = cljs.core.seq(vec__20731);
var first__20733 = cljs.core.first(seq__20732);
var seq__20732__$1 = cljs.core.next(seq__20732);
var clause = first__20733;
var r = seq__20732__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20730__$1 = G__20730;
var res__$1 = res;
while(true){
var vec__20737 = G__20730__$1;
var seq__20738 = cljs.core.seq(vec__20737);
var first__20739 = cljs.core.first(seq__20738);
var seq__20738__$1 = cljs.core.next(seq__20738);
var clause__$1 = first__20739;
var r__$1 = seq__20738__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20740 = r__$1;
var G__20741 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__20730__$1 = G__20740;
res__$1 = G__20741;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__20742){
var map__20743 = p__20742;
var map__20743__$1 = cljs.core.__destructure_map(map__20743);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20743__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__20747 = coll;
var vec__20748 = G__20747;
var seq__20749 = cljs.core.seq(vec__20748);
var first__20750 = cljs.core.first(seq__20749);
var seq__20749__$1 = cljs.core.next(seq__20749);
var clause = first__20750;
var r = seq__20749__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20747__$1 = G__20747;
var res__$1 = res;
while(true){
var vec__20754 = G__20747__$1;
var seq__20755 = cljs.core.seq(vec__20754);
var first__20756 = cljs.core.first(seq__20755);
var seq__20755__$1 = cljs.core.next(seq__20755);
var clause__$1 = first__20756;
var r__$1 = seq__20755__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20757 = r__$1;
var G__20758 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__20747__$1 = G__20757;
res__$1 = G__20758;
continue;
} else {
var G__20759 = r__$1;
var G__20760 = res__$2;
G__20747__$1 = G__20759;
res__$1 = G__20760;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__20764 = coll;
var vec__20765 = G__20764;
var seq__20766 = cljs.core.seq(vec__20765);
var first__20767 = cljs.core.first(seq__20766);
var seq__20766__$1 = cljs.core.next(seq__20766);
var clause = first__20767;
var r = seq__20766__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20764__$1 = G__20764;
var res__$1 = res;
while(true){
var vec__20771 = G__20764__$1;
var seq__20772 = cljs.core.seq(vec__20771);
var first__20773 = cljs.core.first(seq__20772);
var seq__20772__$1 = cljs.core.next(seq__20772);
var clause__$1 = first__20773;
var r__$1 = seq__20772__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20774 = r__$1;
var G__20775 = res__$2;
G__20764__$1 = G__20774;
res__$1 = G__20775;
continue;
} else {
var G__20776 = r__$1;
var G__20777 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__20764__$1 = G__20776;
res__$1 = G__20777;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__20780 = clause;
var G__20780__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__20780):G__20780);
var G__20780__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__20780__$1)
;
var G__20780__$3 = (function (){var fexpr__20781 = (function (p1__20778_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20778_SHARP_)," ."].join('');
});
return fexpr__20781(G__20780__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__20782 = (function (p1__20779_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20779_SHARP_),"}"].join('');
});
return fexpr__20782(G__20780__$3);
} else {
return G__20780__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__20786 = opts;
var map__20786__$1 = cljs.core.__destructure_map(map__20786);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20786__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20786__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20786__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20786__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20786__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20783_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20783_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20784_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__20784_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20785_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__20785_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20800){
var state_val_20801 = (state_20800[(1)]);
if((state_val_20801 === (1))){
var inst_20787 = fluree.db.util.core.url_encode(query);
var inst_20788 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20787)].join('');
var inst_20789 = ["User-Agent","Accept"];
var inst_20790 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_20791 = cljs.core.PersistentHashMap.fromArrays(inst_20789,inst_20790);
var inst_20792 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_20793 = [inst_20791,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_20794 = cljs.core.PersistentHashMap.fromArrays(inst_20792,inst_20793);
var inst_20795 = fluree.db.util.xhttp.get(inst_20788,inst_20794);
var state_20800__$1 = state_20800;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20800__$1,(2),inst_20795);
} else {
if((state_val_20801 === (2))){
var inst_20797 = (state_20800[(2)]);
var inst_20798 = fluree.db.util.async.throw_err(inst_20797);
var state_20800__$1 = state_20800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20800__$1,inst_20798);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0 = (function (){
var statearr_20802 = [null,null,null,null,null,null,null];
(statearr_20802[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__);

(statearr_20802[(1)] = (1));

return statearr_20802;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1 = (function (state_20800){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20800);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20803){var ex__2687__auto__ = e20803;
var statearr_20804_20807 = state_20800;
(statearr_20804_20807[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20800[(4)]))){
var statearr_20805_20808 = state_20800;
(statearr_20805_20808[(1)] = cljs.core.first((state_20800[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20809 = state_20800;
state_20800 = G__20809;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__ = function(state_20800){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1.call(this,state_20800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20806 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20806[(6)] = c__2706__auto__);

return statearr_20806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20827){
var state_val_20828 = (state_20827[(1)]);
if((state_val_20828 === (1))){
var inst_20810 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_20827__$1 = state_20827;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20827__$1,(2),inst_20810);
} else {
if((state_val_20828 === (2))){
var inst_20813 = (state_20827[(7)]);
var inst_20812 = (state_20827[(2)]);
var inst_20813__$1 = fluree.db.util.async.throw_err(inst_20812);
var inst_20814 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_20813__$1);
var inst_20815 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_20814);
var state_20827__$1 = (function (){var statearr_20829 = state_20827;
(statearr_20829[(7)] = inst_20813__$1);

return statearr_20829;
})();
if(inst_20815){
var statearr_20830_20839 = state_20827__$1;
(statearr_20830_20839[(1)] = (3));

} else {
var statearr_20831_20840 = state_20827__$1;
(statearr_20831_20840[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20828 === (3))){
var inst_20813 = (state_20827[(7)]);
var state_20827__$1 = state_20827;
var statearr_20832_20841 = state_20827__$1;
(statearr_20832_20841[(2)] = inst_20813);

(statearr_20832_20841[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20828 === (4))){
var inst_20813 = (state_20827[(7)]);
var inst_20818 = (function (){var body = inst_20813;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_20819 = cljs.core.second(inst_20813);
var inst_20820 = cljs.core.second(inst_20819);
var inst_20821 = cljs.core.first(inst_20820);
var inst_20822 = cljs.core.second(inst_20821);
var inst_20823 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_20818,inst_20822);
var state_20827__$1 = state_20827;
var statearr_20833_20842 = state_20827__$1;
(statearr_20833_20842[(2)] = inst_20823);

(statearr_20833_20842[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20828 === (5))){
var inst_20825 = (state_20827[(2)]);
var state_20827__$1 = state_20827;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20827__$1,inst_20825);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0 = (function (){
var statearr_20834 = [null,null,null,null,null,null,null,null];
(statearr_20834[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__);

(statearr_20834[(1)] = (1));

return statearr_20834;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1 = (function (state_20827){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20827);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20835){var ex__2687__auto__ = e20835;
var statearr_20836_20843 = state_20827;
(statearr_20836_20843[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20827[(4)]))){
var statearr_20837_20844 = state_20827;
(statearr_20837_20844[(1)] = cljs.core.first((state_20827[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20845 = state_20827;
state_20827 = G__20845;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__ = function(state_20827){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1.call(this,state_20827);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20838 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20838[(6)] = c__2706__auto__);

return statearr_20838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20846_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20846_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20847_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20847_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20848_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__20848_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__20848_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__20848_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20894){
var state_val_20895 = (state_20894[(1)]);
if((state_val_20895 === (7))){
var inst_20859 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_20894__$1 = state_20894;
var statearr_20896_20924 = state_20894__$1;
(statearr_20896_20924[(2)] = inst_20859);

(statearr_20896_20924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (1))){
var state_20894__$1 = state_20894;
var statearr_20897_20925 = state_20894__$1;
(statearr_20897_20925[(2)] = null);

(statearr_20897_20925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (4))){
var inst_20849 = (state_20894[(2)]);
var state_20894__$1 = state_20894;
var statearr_20898_20926 = state_20894__$1;
(statearr_20898_20926[(2)] = inst_20849);

(statearr_20898_20926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (15))){
var inst_20867 = (state_20894[(7)]);
var inst_20868 = (state_20894[(8)]);
var inst_20873 = (state_20894[(9)]);
var inst_20878 = (state_20894[(2)]);
var inst_20879 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_20873,(0),inst_20878);
var inst_20880 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20881 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20867);
var inst_20882 = [inst_20868,inst_20881];
var inst_20883 = cljs.core.PersistentHashMap.fromArrays(inst_20880,inst_20882);
var inst_20884 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20879,inst_20883);
var inst_20885 = (function(){throw inst_20884})();
var state_20894__$1 = state_20894;
var statearr_20899_20927 = state_20894__$1;
(statearr_20899_20927[(2)] = inst_20885);

(statearr_20899_20927[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (13))){
var inst_20872 = (state_20894[(10)]);
var state_20894__$1 = state_20894;
var statearr_20900_20928 = state_20894__$1;
(statearr_20900_20928[(2)] = inst_20872);

(statearr_20900_20928[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (6))){
var state_20894__$1 = state_20894;
var statearr_20901_20929 = state_20894__$1;
(statearr_20901_20929[(2)] = null);

(statearr_20901_20929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (3))){
var inst_20892 = (state_20894[(2)]);
var state_20894__$1 = state_20894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20894__$1,inst_20892);
} else {
if((state_val_20895 === (12))){
var inst_20889 = (state_20894[(2)]);
var _ = (function (){var statearr_20902 = state_20894;
(statearr_20902[(4)] = cljs.core.rest((state_20894[(4)])));

return statearr_20902;
})();
var state_20894__$1 = state_20894;
var statearr_20903_20930 = state_20894__$1;
(statearr_20903_20930[(2)] = inst_20889);

(statearr_20903_20930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (2))){
var _ = (function (){var statearr_20904 = state_20894;
(statearr_20904[(4)] = cljs.core.cons((5),(state_20894[(4)])));

return statearr_20904;
})();
var inst_20856 = cljs.core.empty_QMARK_(matching_vars);
var state_20894__$1 = state_20894;
if(inst_20856){
var statearr_20905_20931 = state_20894__$1;
(statearr_20905_20931[(1)] = (6));

} else {
var statearr_20906_20932 = state_20894__$1;
(statearr_20906_20932[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (11))){
var inst_20867 = (state_20894[(7)]);
var inst_20887 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_20867,all_vars);
var state_20894__$1 = state_20894;
var statearr_20908_20933 = state_20894__$1;
(statearr_20908_20933[(2)] = inst_20887);

(statearr_20908_20933[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (9))){
var inst_20867 = (state_20894[(7)]);
var inst_20868 = (state_20894[(8)]);
var inst_20865 = (state_20894[(2)]);
var inst_20866 = fluree.db.util.async.throw_err(inst_20865);
var inst_20867__$1 = cljs.core.__destructure_map(inst_20866);
var inst_20868__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20867__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20869 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20867__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20870 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_20868__$1);
var state_20894__$1 = (function (){var statearr_20909 = state_20894;
(statearr_20909[(7)] = inst_20867__$1);

(statearr_20909[(11)] = inst_20869);

(statearr_20909[(8)] = inst_20868__$1);

return statearr_20909;
})();
if(inst_20870){
var statearr_20910_20934 = state_20894__$1;
(statearr_20910_20934[(1)] = (10));

} else {
var statearr_20911_20935 = state_20894__$1;
(statearr_20911_20935[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (5))){
var _ = (function (){var statearr_20912 = state_20894;
(statearr_20912[(4)] = cljs.core.rest((state_20894[(4)])));

return statearr_20912;
})();
var state_20894__$1 = state_20894;
var ex20907 = (state_20894__$1[(2)]);
var statearr_20913_20936 = state_20894__$1;
(statearr_20913_20936[(5)] = ex20907);


if((ex20907 instanceof Error)){
var statearr_20914_20937 = state_20894__$1;
(statearr_20914_20937[(1)] = (4));

(statearr_20914_20937[(5)] = null);

} else {
throw ex20907;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (14))){
var state_20894__$1 = state_20894;
var statearr_20915_20938 = state_20894__$1;
(statearr_20915_20938[(2)] = (1000));

(statearr_20915_20938[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (10))){
var inst_20867 = (state_20894[(7)]);
var inst_20869 = (state_20894[(11)]);
var inst_20872 = (state_20894[(10)]);
var inst_20872__$1 = cljs.core.count(inst_20869);
var inst_20873 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20867);
var inst_20874 = (inst_20872__$1 < (1000));
var state_20894__$1 = (function (){var statearr_20916 = state_20894;
(statearr_20916[(10)] = inst_20872__$1);

(statearr_20916[(9)] = inst_20873);

return statearr_20916;
})();
if(cljs.core.truth_(inst_20874)){
var statearr_20917_20939 = state_20894__$1;
(statearr_20917_20939[(1)] = (13));

} else {
var statearr_20918_20940 = state_20894__$1;
(statearr_20918_20940[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20895 === (8))){
var inst_20861 = (state_20894[(2)]);
var inst_20862 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_20861,optional_clauses);
var inst_20863 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_20862);
var state_20894__$1 = state_20894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20894__$1,(9),inst_20863);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_20919 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20919[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__);

(statearr_20919[(1)] = (1));

return statearr_20919;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1 = (function (state_20894){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20894);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20920){var ex__2687__auto__ = e20920;
var statearr_20921_20941 = state_20894;
(statearr_20921_20941[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20894[(4)]))){
var statearr_20922_20942 = state_20894;
(statearr_20922_20942[(1)] = cljs.core.first((state_20894[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20943 = state_20894;
state_20894 = G__20943;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__ = function(state_20894){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1.call(this,state_20894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20923 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20923[(6)] = c__2706__auto__);

return statearr_20923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
