// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___54127 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54164){
var state_val_54165 = (state_54164[(1)]);
if((state_val_54165 === (7))){
var inst_54159 = (state_54164[(2)]);
var _ = (function (){var statearr_54166 = state_54164;
(statearr_54166[(4)] = cljs.core.rest((state_54164[(4)])));

return statearr_54166;
})();
var state_54164__$1 = state_54164;
var statearr_54167_54194 = state_54164__$1;
(statearr_54167_54194[(2)] = inst_54159);

(statearr_54167_54194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (1))){
var state_54164__$1 = state_54164;
var statearr_54168_54195 = state_54164__$1;
(statearr_54168_54195[(2)] = null);

(statearr_54168_54195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (4))){
var inst_54128 = (state_54164[(2)]);
var state_54164__$1 = state_54164;
var statearr_54169_54196 = state_54164__$1;
(statearr_54169_54196[(2)] = inst_54128);

(statearr_54169_54196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (13))){
var inst_54155 = (state_54164[(2)]);
var state_54164__$1 = state_54164;
var statearr_54170_54197 = state_54164__$1;
(statearr_54170_54197[(2)] = inst_54155);

(statearr_54170_54197[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (6))){
var inst_54134 = (state_54164[(7)]);
var inst_54136 = (state_54164[(8)]);
var inst_54139 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_54136,inst_54134);
var state_54164__$1 = state_54164;
if(inst_54139){
var statearr_54171_54198 = state_54164__$1;
(statearr_54171_54198[(1)] = (8));

} else {
var statearr_54172_54199 = state_54164__$1;
(statearr_54172_54199[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (3))){
var inst_54162 = (state_54164[(2)]);
var state_54164__$1 = state_54164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54164__$1,inst_54162);
} else {
if((state_val_54165 === (12))){
var inst_54142 = (state_54164[(9)]);
var inst_54137 = (state_54164[(10)]);
var inst_54143 = (state_54164[(11)]);
var inst_54152 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54137,inst_54142);
var inst_54136 = inst_54143;
var inst_54137__$1 = inst_54152;
var state_54164__$1 = (function (){var statearr_54173 = state_54164;
(statearr_54173[(10)] = inst_54137__$1);

(statearr_54173[(8)] = inst_54136);

return statearr_54173;
})();
var statearr_54174_54200 = state_54164__$1;
(statearr_54174_54200[(2)] = null);

(statearr_54174_54200[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (2))){
var _ = (function (){var statearr_54175 = state_54164;
(statearr_54175[(4)] = cljs.core.cons((5),(state_54164[(4)])));

return statearr_54175;
})();
var inst_54134 = cljs.core.count(args);
var inst_54135 = cljs.core.PersistentVector.EMPTY;
var inst_54136 = (0);
var inst_54137 = inst_54135;
var state_54164__$1 = (function (){var statearr_54176 = state_54164;
(statearr_54176[(7)] = inst_54134);

(statearr_54176[(10)] = inst_54137);

(statearr_54176[(8)] = inst_54136);

return statearr_54176;
})();
var statearr_54177_54201 = state_54164__$1;
(statearr_54177_54201[(2)] = null);

(statearr_54177_54201[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (11))){
var inst_54142 = (state_54164[(9)]);
var state_54164__$1 = state_54164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54164__$1,(14),inst_54142);
} else {
if((state_val_54165 === (9))){
var inst_54142 = (state_54164[(9)]);
var inst_54136 = (state_54164[(8)]);
var inst_54142__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(args,inst_54136);
var inst_54143 = (inst_54136 + (1));
var inst_54144 = fluree.db.util.async.channel_QMARK_(inst_54142__$1);
var state_54164__$1 = (function (){var statearr_54179 = state_54164;
(statearr_54179[(9)] = inst_54142__$1);

(statearr_54179[(11)] = inst_54143);

return statearr_54179;
})();
if(inst_54144){
var statearr_54180_54202 = state_54164__$1;
(statearr_54180_54202[(1)] = (11));

} else {
var statearr_54181_54203 = state_54164__$1;
(statearr_54181_54203[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (5))){
var _ = (function (){var statearr_54182 = state_54164;
(statearr_54182[(4)] = cljs.core.rest((state_54164[(4)])));

return statearr_54182;
})();
var state_54164__$1 = state_54164;
var ex54178 = (state_54164__$1[(2)]);
var statearr_54183_54204 = state_54164__$1;
(statearr_54183_54204[(5)] = ex54178);


if((ex54178 instanceof Error)){
var statearr_54184_54205 = state_54164__$1;
(statearr_54184_54205[(1)] = (4));

(statearr_54184_54205[(5)] = null);

} else {
throw ex54178;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (14))){
var inst_54137 = (state_54164[(10)]);
var inst_54143 = (state_54164[(11)]);
var inst_54147 = (state_54164[(2)]);
var inst_54148 = fluree.db.util.async.throw_err(inst_54147);
var inst_54149 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54137,inst_54148);
var inst_54136 = inst_54143;
var inst_54137__$1 = inst_54149;
var state_54164__$1 = (function (){var statearr_54185 = state_54164;
(statearr_54185[(10)] = inst_54137__$1);

(statearr_54185[(8)] = inst_54136);

return statearr_54185;
})();
var statearr_54186_54206 = state_54164__$1;
(statearr_54186_54206[(2)] = null);

(statearr_54186_54206[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (10))){
var inst_54157 = (state_54164[(2)]);
var state_54164__$1 = state_54164;
var statearr_54187_54207 = state_54164__$1;
(statearr_54187_54207[(2)] = inst_54157);

(statearr_54187_54207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54165 === (8))){
var inst_54137 = (state_54164[(10)]);
var state_54164__$1 = state_54164;
var statearr_54188_54208 = state_54164__$1;
(statearr_54188_54208[(2)] = inst_54137);

(statearr_54188_54208[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0 = (function (){
var statearr_54189 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54189[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__);

(statearr_54189[(1)] = (1));

return statearr_54189;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1 = (function (state_54164){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54164);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54190){var ex__2687__auto__ = e54190;
var statearr_54191_54209 = state_54164;
(statearr_54191_54209[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54164[(4)]))){
var statearr_54192_54210 = state_54164;
(statearr_54192_54210[(1)] = cljs.core.first((state_54164[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54211 = state_54164;
state_54164 = G__54211;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__ = function(state_54164){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1.call(this,state_54164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54193 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54193[(6)] = c__2706__auto__);

return statearr_54193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54212 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54212,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54212,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54260){
var state_val_54261 = (state_54260[(1)]);
if((state_val_54261 === (7))){
var state_54260__$1 = state_54260;
var statearr_54262_54291 = state_54260__$1;
(statearr_54262_54291[(2)] = coll);

(statearr_54262_54291[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (1))){
var state_54260__$1 = state_54260;
var statearr_54263_54292 = state_54260__$1;
(statearr_54263_54292[(2)] = null);

(statearr_54263_54292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (4))){
var inst_54215 = (state_54260[(2)]);
var state_54260__$1 = state_54260;
var statearr_54264_54293 = state_54260__$1;
(statearr_54264_54293[(2)] = inst_54215);

(statearr_54264_54293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (15))){
var inst_54234 = (state_54260[(7)]);
var inst_54242 = (state_54260[(2)]);
var inst_54243 = fluree.db.dbfunctions.internal.nth(inst_54234,inst_54242);
var inst_54244 = cljs.core.count(inst_54234);
var inst_54245 = ((9) + inst_54244);
var inst_54246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54247 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54249 = [inst_54234,inst_54242];
var inst_54250 = (new cljs.core.PersistentVector(null,2,(5),inst_54248,inst_54249,null));
var inst_54251 = ["nth",inst_54250,inst_54243];
var inst_54252 = cljs.core.PersistentHashMap.fromArrays(inst_54247,inst_54251);
var inst_54253 = [inst_54252,inst_54245];
var inst_54254 = (new cljs.core.PersistentVector(null,2,(5),inst_54246,inst_54253,null));
var inst_54255 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54254);
var _ = (function (){var statearr_54265 = state_54260;
(statearr_54265[(4)] = cljs.core.rest((state_54260[(4)])));

return statearr_54265;
})();
var state_54260__$1 = (function (){var statearr_54266 = state_54260;
(statearr_54266[(8)] = inst_54255);

return statearr_54266;
})();
var statearr_54267_54294 = state_54260__$1;
(statearr_54267_54294[(2)] = inst_54243);

(statearr_54267_54294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (13))){
var state_54260__$1 = state_54260;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54260__$1,(16),key);
} else {
if((state_val_54261 === (6))){
var state_54260__$1 = state_54260;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54260__$1,(9),coll);
} else {
if((state_val_54261 === (3))){
var inst_54258 = (state_54260[(2)]);
var state_54260__$1 = state_54260;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54260__$1,inst_54258);
} else {
if((state_val_54261 === (12))){
var inst_54234 = (state_54260[(2)]);
var inst_54235 = fluree.db.util.async.channel_QMARK_(key);
var state_54260__$1 = (function (){var statearr_54268 = state_54260;
(statearr_54268[(7)] = inst_54234);

return statearr_54268;
})();
if(inst_54235){
var statearr_54269_54295 = state_54260__$1;
(statearr_54269_54295[(1)] = (13));

} else {
var statearr_54270_54296 = state_54260__$1;
(statearr_54270_54296[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (2))){
var _ = (function (){var statearr_54271 = state_54260;
(statearr_54271[(4)] = cljs.core.cons((5),(state_54260[(4)])));

return statearr_54271;
})();
var inst_54221 = fluree.db.util.async.channel_QMARK_(coll);
var state_54260__$1 = state_54260;
if(inst_54221){
var statearr_54272_54297 = state_54260__$1;
(statearr_54272_54297[(1)] = (6));

} else {
var statearr_54273_54298 = state_54260__$1;
(statearr_54273_54298[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (11))){
var inst_54228 = (state_54260[(9)]);
var state_54260__$1 = state_54260;
var statearr_54275_54299 = state_54260__$1;
(statearr_54275_54299[(2)] = inst_54228);

(statearr_54275_54299[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (9))){
var inst_54224 = (state_54260[(2)]);
var inst_54225 = fluree.db.util.async.throw_err(inst_54224);
var state_54260__$1 = state_54260;
var statearr_54276_54300 = state_54260__$1;
(statearr_54276_54300[(2)] = inst_54225);

(statearr_54276_54300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (5))){
var _ = (function (){var statearr_54277 = state_54260;
(statearr_54277[(4)] = cljs.core.rest((state_54260[(4)])));

return statearr_54277;
})();
var state_54260__$1 = state_54260;
var ex54274 = (state_54260__$1[(2)]);
var statearr_54278_54301 = state_54260__$1;
(statearr_54278_54301[(5)] = ex54274);


if((ex54274 instanceof Error)){
var statearr_54279_54302 = state_54260__$1;
(statearr_54279_54302[(1)] = (4));

(statearr_54279_54302[(5)] = null);

} else {
throw ex54274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (14))){
var state_54260__$1 = state_54260;
var statearr_54280_54303 = state_54260__$1;
(statearr_54280_54303[(2)] = key);

(statearr_54280_54303[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (16))){
var inst_54238 = (state_54260[(2)]);
var inst_54239 = fluree.db.util.async.throw_err(inst_54238);
var state_54260__$1 = state_54260;
var statearr_54281_54304 = state_54260__$1;
(statearr_54281_54304[(2)] = inst_54239);

(statearr_54281_54304[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (10))){
var inst_54228 = (state_54260[(9)]);
var inst_54231 = cljs.core.vec(inst_54228);
var state_54260__$1 = state_54260;
var statearr_54282_54305 = state_54260__$1;
(statearr_54282_54305[(2)] = inst_54231);

(statearr_54282_54305[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54261 === (8))){
var inst_54228 = (state_54260[(9)]);
var inst_54228__$1 = (state_54260[(2)]);
var inst_54229 = cljs.core.set_QMARK_(inst_54228__$1);
var state_54260__$1 = (function (){var statearr_54283 = state_54260;
(statearr_54283[(9)] = inst_54228__$1);

return statearr_54283;
})();
if(inst_54229){
var statearr_54284_54306 = state_54260__$1;
(statearr_54284_54306[(1)] = (10));

} else {
var statearr_54285_54307 = state_54260__$1;
(statearr_54285_54307[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0 = (function (){
var statearr_54286 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54286[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__);

(statearr_54286[(1)] = (1));

return statearr_54286;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1 = (function (state_54260){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54260);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54287){var ex__2687__auto__ = e54287;
var statearr_54288_54308 = state_54260;
(statearr_54288_54308[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54260[(4)]))){
var statearr_54289_54309 = state_54260;
(statearr_54289_54309[(1)] = cljs.core.first((state_54260[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54310 = state_54260;
state_54260 = G__54310;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__ = function(state_54260){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1.call(this,state_54260);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54290 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54290[(6)] = c__2706__auto__);

return statearr_54290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54371){
var state_val_54372 = (state_54371[(1)]);
if((state_val_54372 === (7))){
var state_54371__$1 = state_54371;
var statearr_54373_54407 = state_54371__$1;
(statearr_54373_54407[(2)] = test);

(statearr_54373_54407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (20))){
var inst_54345 = (state_54371[(2)]);
var inst_54346 = fluree.db.util.async.throw_err(inst_54345);
var state_54371__$1 = state_54371;
var statearr_54374_54408 = state_54371__$1;
(statearr_54374_54408[(2)] = inst_54346);

(statearr_54374_54408[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (1))){
var state_54371__$1 = state_54371;
var statearr_54375_54409 = state_54371__$1;
(statearr_54375_54409[(2)] = null);

(statearr_54375_54409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (4))){
var inst_54311 = (state_54371[(2)]);
var state_54371__$1 = state_54371;
var statearr_54376_54410 = state_54371__$1;
(statearr_54376_54410[(2)] = inst_54311);

(statearr_54376_54410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (15))){
var inst_54329 = (state_54371[(7)]);
var inst_54337 = (state_54371[(2)]);
var inst_54338 = [inst_54337,f];
var inst_54339 = (new cljs.core.PersistentVector(null,2,(5),inst_54329,inst_54338,null));
var state_54371__$1 = state_54371;
var statearr_54377_54411 = state_54371__$1;
(statearr_54377_54411[(2)] = inst_54339);

(statearr_54377_54411[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (13))){
var state_54371__$1 = state_54371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54371__$1,(16),t);
} else {
if((state_val_54372 === (6))){
var state_54371__$1 = state_54371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54371__$1,(9),test);
} else {
if((state_val_54372 === (17))){
var state_54371__$1 = state_54371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54371__$1,(20),f);
} else {
if((state_val_54372 === (3))){
var inst_54369 = (state_54371[(2)]);
var state_54371__$1 = state_54371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54371__$1,inst_54369);
} else {
if((state_val_54372 === (12))){
var inst_54327 = (state_54371[(8)]);
var inst_54353 = (state_54371[(2)]);
var inst_54354 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54353,(0),null);
var inst_54355 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54353,(1),null);
var inst_54356 = fluree.db.dbfunctions.internal.if_else(inst_54327,inst_54354,inst_54355);
var inst_54357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54358 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54360 = [inst_54327,inst_54354,inst_54355];
var inst_54361 = (new cljs.core.PersistentVector(null,3,(5),inst_54359,inst_54360,null));
var inst_54362 = ["if-else",inst_54361,inst_54356];
var inst_54363 = cljs.core.PersistentHashMap.fromArrays(inst_54358,inst_54362);
var inst_54364 = [inst_54363,(10)];
var inst_54365 = (new cljs.core.PersistentVector(null,2,(5),inst_54357,inst_54364,null));
var inst_54366 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54365);
var _ = (function (){var statearr_54378 = state_54371;
(statearr_54378[(4)] = cljs.core.rest((state_54371[(4)])));

return statearr_54378;
})();
var state_54371__$1 = (function (){var statearr_54379 = state_54371;
(statearr_54379[(9)] = inst_54366);

return statearr_54379;
})();
var statearr_54380_54412 = state_54371__$1;
(statearr_54380_54412[(2)] = inst_54356);

(statearr_54380_54412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (2))){
var _ = (function (){var statearr_54381 = state_54371;
(statearr_54381[(4)] = cljs.core.cons((5),(state_54371[(4)])));

return statearr_54381;
})();
var inst_54320 = fluree.db.util.async.channel_QMARK_(test);
var state_54371__$1 = state_54371;
if(inst_54320){
var statearr_54382_54413 = state_54371__$1;
(statearr_54382_54413[(1)] = (6));

} else {
var statearr_54383_54414 = state_54371__$1;
(statearr_54383_54414[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (19))){
var inst_54341 = (state_54371[(10)]);
var inst_54349 = (state_54371[(2)]);
var inst_54350 = [f,inst_54349];
var inst_54351 = (new cljs.core.PersistentVector(null,2,(5),inst_54341,inst_54350,null));
var state_54371__$1 = state_54371;
var statearr_54384_54415 = state_54371__$1;
(statearr_54384_54415[(2)] = inst_54351);

(statearr_54384_54415[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (11))){
var inst_54341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54342 = fluree.db.util.async.channel_QMARK_(f);
var state_54371__$1 = (function (){var statearr_54386 = state_54371;
(statearr_54386[(10)] = inst_54341);

return statearr_54386;
})();
if(inst_54342){
var statearr_54387_54416 = state_54371__$1;
(statearr_54387_54416[(1)] = (17));

} else {
var statearr_54388_54417 = state_54371__$1;
(statearr_54388_54417[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (9))){
var inst_54323 = (state_54371[(2)]);
var inst_54324 = fluree.db.util.async.throw_err(inst_54323);
var state_54371__$1 = state_54371;
var statearr_54389_54418 = state_54371__$1;
(statearr_54389_54418[(2)] = inst_54324);

(statearr_54389_54418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (5))){
var _ = (function (){var statearr_54390 = state_54371;
(statearr_54390[(4)] = cljs.core.rest((state_54371[(4)])));

return statearr_54390;
})();
var state_54371__$1 = state_54371;
var ex54385 = (state_54371__$1[(2)]);
var statearr_54391_54419 = state_54371__$1;
(statearr_54391_54419[(5)] = ex54385);


if((ex54385 instanceof Error)){
var statearr_54392_54420 = state_54371__$1;
(statearr_54392_54420[(1)] = (4));

(statearr_54392_54420[(5)] = null);

} else {
throw ex54385;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (14))){
var state_54371__$1 = state_54371;
var statearr_54393_54421 = state_54371__$1;
(statearr_54393_54421[(2)] = t);

(statearr_54393_54421[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (16))){
var inst_54333 = (state_54371[(2)]);
var inst_54334 = fluree.db.util.async.throw_err(inst_54333);
var state_54371__$1 = state_54371;
var statearr_54394_54422 = state_54371__$1;
(statearr_54394_54422[(2)] = inst_54334);

(statearr_54394_54422[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (10))){
var inst_54329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54330 = fluree.db.util.async.channel_QMARK_(t);
var state_54371__$1 = (function (){var statearr_54395 = state_54371;
(statearr_54395[(7)] = inst_54329);

return statearr_54395;
})();
if(inst_54330){
var statearr_54396_54423 = state_54371__$1;
(statearr_54396_54423[(1)] = (13));

} else {
var statearr_54397_54424 = state_54371__$1;
(statearr_54397_54424[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (18))){
var state_54371__$1 = state_54371;
var statearr_54398_54425 = state_54371__$1;
(statearr_54398_54425[(2)] = f);

(statearr_54398_54425[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54372 === (8))){
var inst_54327 = (state_54371[(8)]);
var inst_54327__$1 = (state_54371[(2)]);
var state_54371__$1 = (function (){var statearr_54399 = state_54371;
(statearr_54399[(8)] = inst_54327__$1);

return statearr_54399;
})();
if(cljs.core.truth_(inst_54327__$1)){
var statearr_54400_54426 = state_54371__$1;
(statearr_54400_54426[(1)] = (10));

} else {
var statearr_54401_54427 = state_54371__$1;
(statearr_54401_54427[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0 = (function (){
var statearr_54402 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54402[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__);

(statearr_54402[(1)] = (1));

return statearr_54402;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1 = (function (state_54371){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54371);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54403){var ex__2687__auto__ = e54403;
var statearr_54404_54428 = state_54371;
(statearr_54404_54428[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54371[(4)]))){
var statearr_54405_54429 = state_54371;
(statearr_54405_54429[(1)] = cljs.core.first((state_54371[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54430 = state_54371;
state_54371 = G__54430;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__ = function(state_54371){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1.call(this,state_54371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54406 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54406[(6)] = c__2706__auto__);

return statearr_54406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54460){
var state_val_54461 = (state_54460[(1)]);
if((state_val_54461 === (7))){
var state_54460__$1 = state_54460;
var statearr_54462_54481 = state_54460__$1;
(statearr_54462_54481[(2)] = arg);

(statearr_54462_54481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (1))){
var state_54460__$1 = state_54460;
var statearr_54463_54482 = state_54460__$1;
(statearr_54463_54482[(2)] = null);

(statearr_54463_54482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (4))){
var inst_54431 = (state_54460[(2)]);
var state_54460__$1 = state_54460;
var statearr_54464_54483 = state_54460__$1;
(statearr_54464_54483[(2)] = inst_54431);

(statearr_54464_54483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (6))){
var state_54460__$1 = state_54460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54460__$1,(9),arg);
} else {
if((state_val_54461 === (3))){
var inst_54458 = (state_54460[(2)]);
var state_54460__$1 = state_54460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54460__$1,inst_54458);
} else {
if((state_val_54461 === (2))){
var _ = (function (){var statearr_54466 = state_54460;
(statearr_54466[(4)] = cljs.core.cons((5),(state_54460[(4)])));

return statearr_54466;
})();
var inst_54437 = fluree.db.util.async.channel_QMARK_(arg);
var state_54460__$1 = state_54460;
if(inst_54437){
var statearr_54467_54484 = state_54460__$1;
(statearr_54467_54484[(1)] = (6));

} else {
var statearr_54468_54485 = state_54460__$1;
(statearr_54468_54485[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (9))){
var inst_54440 = (state_54460[(2)]);
var inst_54441 = fluree.db.util.async.throw_err(inst_54440);
var state_54460__$1 = state_54460;
var statearr_54469_54486 = state_54460__$1;
(statearr_54469_54486[(2)] = inst_54441);

(statearr_54469_54486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (5))){
var _ = (function (){var statearr_54470 = state_54460;
(statearr_54470[(4)] = cljs.core.rest((state_54460[(4)])));

return statearr_54470;
})();
var state_54460__$1 = state_54460;
var ex54465 = (state_54460__$1[(2)]);
var statearr_54471_54487 = state_54460__$1;
(statearr_54471_54487[(5)] = ex54465);


if((ex54465 instanceof Error)){
var statearr_54472_54488 = state_54460__$1;
(statearr_54472_54488[(1)] = (4));

(statearr_54472_54488[(5)] = null);

} else {
throw ex54465;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (8))){
var inst_54444 = (state_54460[(2)]);
var inst_54445 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_54444);
var inst_54446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54447 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54449 = [inst_54444];
var inst_54450 = (new cljs.core.PersistentVector(null,1,(5),inst_54448,inst_54449,null));
var inst_54451 = ["nil?",inst_54450,inst_54445];
var inst_54452 = cljs.core.PersistentHashMap.fromArrays(inst_54447,inst_54451);
var inst_54453 = [inst_54452,(10)];
var inst_54454 = (new cljs.core.PersistentVector(null,2,(5),inst_54446,inst_54453,null));
var inst_54455 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54454);
var _ = (function (){var statearr_54473 = state_54460;
(statearr_54473[(4)] = cljs.core.rest((state_54460[(4)])));

return statearr_54473;
})();
var state_54460__$1 = (function (){var statearr_54474 = state_54460;
(statearr_54474[(7)] = inst_54455);

return statearr_54474;
})();
var statearr_54475_54489 = state_54460__$1;
(statearr_54475_54489[(2)] = inst_54445);

(statearr_54475_54489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_54476 = [null,null,null,null,null,null,null,null];
(statearr_54476[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__);

(statearr_54476[(1)] = (1));

return statearr_54476;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1 = (function (state_54460){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54460);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54477){var ex__2687__auto__ = e54477;
var statearr_54478_54490 = state_54460;
(statearr_54478_54490[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54460[(4)]))){
var statearr_54479_54491 = state_54460;
(statearr_54479_54491[(1)] = cljs.core.first((state_54460[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54492 = state_54460;
state_54460 = G__54492;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__ = function(state_54460){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1.call(this,state_54460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54480 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54480[(6)] = c__2706__auto__);

return statearr_54480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54522){
var state_val_54523 = (state_54522[(1)]);
if((state_val_54523 === (7))){
var state_54522__$1 = state_54522;
var statearr_54524_54543 = state_54522__$1;
(statearr_54524_54543[(2)] = arg);

(statearr_54524_54543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54523 === (1))){
var state_54522__$1 = state_54522;
var statearr_54525_54544 = state_54522__$1;
(statearr_54525_54544[(2)] = null);

(statearr_54525_54544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54523 === (4))){
var inst_54493 = (state_54522[(2)]);
var state_54522__$1 = state_54522;
var statearr_54526_54545 = state_54522__$1;
(statearr_54526_54545[(2)] = inst_54493);

(statearr_54526_54545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54523 === (6))){
var state_54522__$1 = state_54522;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54522__$1,(9),arg);
} else {
if((state_val_54523 === (3))){
var inst_54520 = (state_54522[(2)]);
var state_54522__$1 = state_54522;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54522__$1,inst_54520);
} else {
if((state_val_54523 === (2))){
var _ = (function (){var statearr_54528 = state_54522;
(statearr_54528[(4)] = cljs.core.cons((5),(state_54522[(4)])));

return statearr_54528;
})();
var inst_54499 = fluree.db.util.async.channel_QMARK_(arg);
var state_54522__$1 = state_54522;
if(inst_54499){
var statearr_54529_54546 = state_54522__$1;
(statearr_54529_54546[(1)] = (6));

} else {
var statearr_54530_54547 = state_54522__$1;
(statearr_54530_54547[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54523 === (9))){
var inst_54502 = (state_54522[(2)]);
var inst_54503 = fluree.db.util.async.throw_err(inst_54502);
var state_54522__$1 = state_54522;
var statearr_54531_54548 = state_54522__$1;
(statearr_54531_54548[(2)] = inst_54503);

(statearr_54531_54548[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54523 === (5))){
var _ = (function (){var statearr_54532 = state_54522;
(statearr_54532[(4)] = cljs.core.rest((state_54522[(4)])));

return statearr_54532;
})();
var state_54522__$1 = state_54522;
var ex54527 = (state_54522__$1[(2)]);
var statearr_54533_54549 = state_54522__$1;
(statearr_54533_54549[(5)] = ex54527);


if((ex54527 instanceof Error)){
var statearr_54534_54550 = state_54522__$1;
(statearr_54534_54550[(1)] = (4));

(statearr_54534_54550[(5)] = null);

} else {
throw ex54527;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54523 === (8))){
var inst_54506 = (state_54522[(2)]);
var inst_54507 = fluree.db.dbfunctions.internal.not(inst_54506);
var inst_54508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54509 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54511 = [inst_54506];
var inst_54512 = (new cljs.core.PersistentVector(null,1,(5),inst_54510,inst_54511,null));
var inst_54513 = ["not?",inst_54512,inst_54507];
var inst_54514 = cljs.core.PersistentHashMap.fromArrays(inst_54509,inst_54513);
var inst_54515 = [inst_54514,(10)];
var inst_54516 = (new cljs.core.PersistentVector(null,2,(5),inst_54508,inst_54515,null));
var inst_54517 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54516);
var _ = (function (){var statearr_54535 = state_54522;
(statearr_54535[(4)] = cljs.core.rest((state_54522[(4)])));

return statearr_54535;
})();
var state_54522__$1 = (function (){var statearr_54536 = state_54522;
(statearr_54536[(7)] = inst_54517);

return statearr_54536;
})();
var statearr_54537_54551 = state_54522__$1;
(statearr_54537_54551[(2)] = inst_54507);

(statearr_54537_54551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0 = (function (){
var statearr_54538 = [null,null,null,null,null,null,null,null];
(statearr_54538[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__);

(statearr_54538[(1)] = (1));

return statearr_54538;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1 = (function (state_54522){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54522);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54539){var ex__2687__auto__ = e54539;
var statearr_54540_54552 = state_54522;
(statearr_54540_54552[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54522[(4)]))){
var statearr_54541_54553 = state_54522;
(statearr_54541_54553[(1)] = cljs.core.first((state_54522[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54554 = state_54522;
state_54522 = G__54554;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__ = function(state_54522){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1.call(this,state_54522);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54542 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54542[(6)] = c__2706__auto__);

return statearr_54542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54584){
var state_val_54585 = (state_54584[(1)]);
if((state_val_54585 === (7))){
var state_54584__$1 = state_54584;
var statearr_54586_54605 = state_54584__$1;
(statearr_54586_54605[(2)] = arg);

(statearr_54586_54605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54585 === (1))){
var state_54584__$1 = state_54584;
var statearr_54587_54606 = state_54584__$1;
(statearr_54587_54606[(2)] = null);

(statearr_54587_54606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54585 === (4))){
var inst_54555 = (state_54584[(2)]);
var state_54584__$1 = state_54584;
var statearr_54588_54607 = state_54584__$1;
(statearr_54588_54607[(2)] = inst_54555);

(statearr_54588_54607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54585 === (6))){
var state_54584__$1 = state_54584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54584__$1,(9),arg);
} else {
if((state_val_54585 === (3))){
var inst_54582 = (state_54584[(2)]);
var state_54584__$1 = state_54584;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54584__$1,inst_54582);
} else {
if((state_val_54585 === (2))){
var _ = (function (){var statearr_54590 = state_54584;
(statearr_54590[(4)] = cljs.core.cons((5),(state_54584[(4)])));

return statearr_54590;
})();
var inst_54561 = fluree.db.util.async.channel_QMARK_(arg);
var state_54584__$1 = state_54584;
if(inst_54561){
var statearr_54591_54608 = state_54584__$1;
(statearr_54591_54608[(1)] = (6));

} else {
var statearr_54592_54609 = state_54584__$1;
(statearr_54592_54609[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54585 === (9))){
var inst_54564 = (state_54584[(2)]);
var inst_54565 = fluree.db.util.async.throw_err(inst_54564);
var state_54584__$1 = state_54584;
var statearr_54593_54610 = state_54584__$1;
(statearr_54593_54610[(2)] = inst_54565);

(statearr_54593_54610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54585 === (5))){
var _ = (function (){var statearr_54594 = state_54584;
(statearr_54594[(4)] = cljs.core.rest((state_54584[(4)])));

return statearr_54594;
})();
var state_54584__$1 = state_54584;
var ex54589 = (state_54584__$1[(2)]);
var statearr_54595_54611 = state_54584__$1;
(statearr_54595_54611[(5)] = ex54589);


if((ex54589 instanceof Error)){
var statearr_54596_54612 = state_54584__$1;
(statearr_54596_54612[(1)] = (4));

(statearr_54596_54612[(5)] = null);

} else {
throw ex54589;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54585 === (8))){
var inst_54568 = (state_54584[(2)]);
var inst_54569 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_54568);
var inst_54570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54571 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54573 = [inst_54568];
var inst_54574 = (new cljs.core.PersistentVector(null,1,(5),inst_54572,inst_54573,null));
var inst_54575 = ["empty?",inst_54574,inst_54569];
var inst_54576 = cljs.core.PersistentHashMap.fromArrays(inst_54571,inst_54575);
var inst_54577 = [inst_54576,(10)];
var inst_54578 = (new cljs.core.PersistentVector(null,2,(5),inst_54570,inst_54577,null));
var inst_54579 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54578);
var _ = (function (){var statearr_54597 = state_54584;
(statearr_54597[(4)] = cljs.core.rest((state_54584[(4)])));

return statearr_54597;
})();
var state_54584__$1 = (function (){var statearr_54598 = state_54584;
(statearr_54598[(7)] = inst_54579);

return statearr_54598;
})();
var statearr_54599_54613 = state_54584__$1;
(statearr_54599_54613[(2)] = inst_54569);

(statearr_54599_54613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_54600 = [null,null,null,null,null,null,null,null];
(statearr_54600[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__);

(statearr_54600[(1)] = (1));

return statearr_54600;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1 = (function (state_54584){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54584);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54601){var ex__2687__auto__ = e54601;
var statearr_54602_54614 = state_54584;
(statearr_54602_54614[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54584[(4)]))){
var statearr_54603_54615 = state_54584;
(statearr_54603_54615[(1)] = cljs.core.first((state_54584[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54616 = state_54584;
state_54584 = G__54616;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__ = function(state_54584){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1.call(this,state_54584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54604 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54604[(6)] = c__2706__auto__);

return statearr_54604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54661 = arguments.length;
var i__5770__auto___54662 = (0);
while(true){
if((i__5770__auto___54662 < len__5769__auto___54661)){
args__5775__auto__.push((arguments[i__5770__auto___54662]));

var G__54663 = (i__5770__auto___54662 + (1));
i__5770__auto___54662 = G__54663;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54644){
var state_val_54645 = (state_54644[(1)]);
if((state_val_54645 === (1))){
var state_54644__$1 = state_54644;
var statearr_54646_54664 = state_54644__$1;
(statearr_54646_54664[(2)] = null);

(statearr_54646_54664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54645 === (2))){
var _ = (function (){var statearr_54647 = state_54644;
(statearr_54647[(4)] = cljs.core.cons((5),(state_54644[(4)])));

return statearr_54647;
})();
var inst_54625 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54644__$1 = state_54644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54644__$1,(6),inst_54625);
} else {
if((state_val_54645 === (3))){
var inst_54642 = (state_54644[(2)]);
var state_54644__$1 = state_54644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54644__$1,inst_54642);
} else {
if((state_val_54645 === (4))){
var inst_54619 = (state_54644[(2)]);
var state_54644__$1 = state_54644;
var statearr_54649_54665 = state_54644__$1;
(statearr_54649_54665[(2)] = inst_54619);

(statearr_54649_54665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54645 === (5))){
var _ = (function (){var statearr_54650 = state_54644;
(statearr_54650[(4)] = cljs.core.rest((state_54644[(4)])));

return statearr_54650;
})();
var state_54644__$1 = state_54644;
var ex54648 = (state_54644__$1[(2)]);
var statearr_54651_54666 = state_54644__$1;
(statearr_54651_54666[(5)] = ex54648);


if((ex54648 instanceof Error)){
var statearr_54652_54667 = state_54644__$1;
(statearr_54652_54667[(1)] = (4));

(statearr_54652_54667[(5)] = null);

} else {
throw ex54648;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54645 === (6))){
var inst_54627 = (state_54644[(2)]);
var inst_54628 = fluree.db.util.async.throw_err(inst_54627);
var inst_54629 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_54628);
var inst_54630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54631 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54633 = [inst_54628];
var inst_54634 = (new cljs.core.PersistentVector(null,1,(5),inst_54632,inst_54633,null));
var inst_54635 = ["str",inst_54634,inst_54629];
var inst_54636 = cljs.core.PersistentHashMap.fromArrays(inst_54631,inst_54635);
var inst_54637 = [inst_54636,(10)];
var inst_54638 = (new cljs.core.PersistentVector(null,2,(5),inst_54630,inst_54637,null));
var inst_54639 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54638);
var _ = (function (){var statearr_54653 = state_54644;
(statearr_54653[(4)] = cljs.core.rest((state_54644[(4)])));

return statearr_54653;
})();
var state_54644__$1 = (function (){var statearr_54654 = state_54644;
(statearr_54654[(7)] = inst_54639);

return statearr_54654;
})();
var statearr_54655_54668 = state_54644__$1;
(statearr_54655_54668[(2)] = inst_54629);

(statearr_54655_54668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_54656 = [null,null,null,null,null,null,null,null];
(statearr_54656[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_54656[(1)] = (1));

return statearr_54656;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_54644){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54644);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54657){var ex__2687__auto__ = e54657;
var statearr_54658_54669 = state_54644;
(statearr_54658_54669[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54644[(4)]))){
var statearr_54659_54670 = state_54644;
(statearr_54659_54670[(1)] = cljs.core.first((state_54644[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54671 = state_54644;
state_54644 = G__54671;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_54644){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_54644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54660 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54660[(6)] = c__2706__auto__);

return statearr_54660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54617){
var G__54618 = cljs.core.first(seq54617);
var seq54617__$1 = cljs.core.next(seq54617);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54618,seq54617__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54697){
var state_val_54698 = (state_54697[(1)]);
if((state_val_54698 === (1))){
var state_54697__$1 = state_54697;
var statearr_54699_54714 = state_54697__$1;
(statearr_54699_54714[(2)] = null);

(statearr_54699_54714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54698 === (2))){
var _ = (function (){var statearr_54700 = state_54697;
(statearr_54700[(4)] = cljs.core.cons((5),(state_54697[(4)])));

return statearr_54700;
})();
var inst_54678 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54697__$1 = state_54697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54697__$1,(6),inst_54678);
} else {
if((state_val_54698 === (3))){
var inst_54695 = (state_54697[(2)]);
var state_54697__$1 = state_54697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54697__$1,inst_54695);
} else {
if((state_val_54698 === (4))){
var inst_54672 = (state_54697[(2)]);
var state_54697__$1 = state_54697;
var statearr_54702_54715 = state_54697__$1;
(statearr_54702_54715[(2)] = inst_54672);

(statearr_54702_54715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54698 === (5))){
var _ = (function (){var statearr_54703 = state_54697;
(statearr_54703[(4)] = cljs.core.rest((state_54697[(4)])));

return statearr_54703;
})();
var state_54697__$1 = state_54697;
var ex54701 = (state_54697__$1[(2)]);
var statearr_54704_54716 = state_54697__$1;
(statearr_54704_54716[(5)] = ex54701);


if((ex54701 instanceof Error)){
var statearr_54705_54717 = state_54697__$1;
(statearr_54705_54717[(1)] = (4));

(statearr_54705_54717[(5)] = null);

} else {
throw ex54701;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54698 === (6))){
var inst_54680 = (state_54697[(2)]);
var inst_54681 = fluree.db.util.async.throw_err(inst_54680);
var inst_54682 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_54681);
var inst_54683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54684 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54686 = [inst_54681];
var inst_54687 = (new cljs.core.PersistentVector(null,1,(5),inst_54685,inst_54686,null));
var inst_54688 = ["subs",inst_54687,inst_54682];
var inst_54689 = cljs.core.PersistentHashMap.fromArrays(inst_54684,inst_54688);
var inst_54690 = [inst_54689,(30)];
var inst_54691 = (new cljs.core.PersistentVector(null,2,(5),inst_54683,inst_54690,null));
var inst_54692 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54691);
var _ = (function (){var statearr_54706 = state_54697;
(statearr_54706[(4)] = cljs.core.rest((state_54697[(4)])));

return statearr_54706;
})();
var state_54697__$1 = (function (){var statearr_54707 = state_54697;
(statearr_54707[(7)] = inst_54692);

return statearr_54707;
})();
var statearr_54708_54718 = state_54697__$1;
(statearr_54708_54718[(2)] = inst_54682);

(statearr_54708_54718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0 = (function (){
var statearr_54709 = [null,null,null,null,null,null,null,null];
(statearr_54709[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__);

(statearr_54709[(1)] = (1));

return statearr_54709;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1 = (function (state_54697){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54697);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54710){var ex__2687__auto__ = e54710;
var statearr_54711_54719 = state_54697;
(statearr_54711_54719[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54697[(4)]))){
var statearr_54712_54720 = state_54697;
(statearr_54712_54720[(1)] = cljs.core.first((state_54697[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54721 = state_54697;
state_54697 = G__54721;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__ = function(state_54697){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1.call(this,state_54697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54713 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54713[(6)] = c__2706__auto__);

return statearr_54713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54751){
var state_val_54752 = (state_54751[(1)]);
if((state_val_54752 === (7))){
var state_54751__$1 = state_54751;
var statearr_54753_54772 = state_54751__$1;
(statearr_54753_54772[(2)] = str);

(statearr_54753_54772[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54752 === (1))){
var state_54751__$1 = state_54751;
var statearr_54754_54773 = state_54751__$1;
(statearr_54754_54773[(2)] = null);

(statearr_54754_54773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54752 === (4))){
var inst_54722 = (state_54751[(2)]);
var state_54751__$1 = state_54751;
var statearr_54755_54774 = state_54751__$1;
(statearr_54755_54774[(2)] = inst_54722);

(statearr_54755_54774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54752 === (6))){
var state_54751__$1 = state_54751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54751__$1,(9),str);
} else {
if((state_val_54752 === (3))){
var inst_54749 = (state_54751[(2)]);
var state_54751__$1 = state_54751;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54751__$1,inst_54749);
} else {
if((state_val_54752 === (2))){
var _ = (function (){var statearr_54757 = state_54751;
(statearr_54757[(4)] = cljs.core.cons((5),(state_54751[(4)])));

return statearr_54757;
})();
var inst_54728 = fluree.db.util.async.channel_QMARK_(str);
var state_54751__$1 = state_54751;
if(inst_54728){
var statearr_54758_54775 = state_54751__$1;
(statearr_54758_54775[(1)] = (6));

} else {
var statearr_54759_54776 = state_54751__$1;
(statearr_54759_54776[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54752 === (9))){
var inst_54731 = (state_54751[(2)]);
var inst_54732 = fluree.db.util.async.throw_err(inst_54731);
var state_54751__$1 = state_54751;
var statearr_54760_54777 = state_54751__$1;
(statearr_54760_54777[(2)] = inst_54732);

(statearr_54760_54777[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54752 === (5))){
var _ = (function (){var statearr_54761 = state_54751;
(statearr_54761[(4)] = cljs.core.rest((state_54751[(4)])));

return statearr_54761;
})();
var state_54751__$1 = state_54751;
var ex54756 = (state_54751__$1[(2)]);
var statearr_54762_54778 = state_54751__$1;
(statearr_54762_54778[(5)] = ex54756);


if((ex54756 instanceof Error)){
var statearr_54763_54779 = state_54751__$1;
(statearr_54763_54779[(1)] = (4));

(statearr_54763_54779[(5)] = null);

} else {
throw ex54756;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54752 === (8))){
var inst_54735 = (state_54751[(2)]);
var inst_54736 = fluree.db.dbfunctions.internal.lower_case(inst_54735);
var inst_54737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54738 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54740 = [inst_54735];
var inst_54741 = (new cljs.core.PersistentVector(null,1,(5),inst_54739,inst_54740,null));
var inst_54742 = ["lower-case",inst_54741,inst_54736];
var inst_54743 = cljs.core.PersistentHashMap.fromArrays(inst_54738,inst_54742);
var inst_54744 = [inst_54743,(10)];
var inst_54745 = (new cljs.core.PersistentVector(null,2,(5),inst_54737,inst_54744,null));
var inst_54746 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54745);
var _ = (function (){var statearr_54764 = state_54751;
(statearr_54764[(4)] = cljs.core.rest((state_54751[(4)])));

return statearr_54764;
})();
var state_54751__$1 = (function (){var statearr_54765 = state_54751;
(statearr_54765[(7)] = inst_54746);

return statearr_54765;
})();
var statearr_54766_54780 = state_54751__$1;
(statearr_54766_54780[(2)] = inst_54736);

(statearr_54766_54780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0 = (function (){
var statearr_54767 = [null,null,null,null,null,null,null,null];
(statearr_54767[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__);

(statearr_54767[(1)] = (1));

return statearr_54767;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1 = (function (state_54751){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54751);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54768){var ex__2687__auto__ = e54768;
var statearr_54769_54781 = state_54751;
(statearr_54769_54781[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54751[(4)]))){
var statearr_54770_54782 = state_54751;
(statearr_54770_54782[(1)] = cljs.core.first((state_54751[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54783 = state_54751;
state_54751 = G__54783;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__ = function(state_54751){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1.call(this,state_54751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54771 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54771[(6)] = c__2706__auto__);

return statearr_54771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54813){
var state_val_54814 = (state_54813[(1)]);
if((state_val_54814 === (7))){
var state_54813__$1 = state_54813;
var statearr_54815_54834 = state_54813__$1;
(statearr_54815_54834[(2)] = str);

(statearr_54815_54834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54814 === (1))){
var state_54813__$1 = state_54813;
var statearr_54816_54835 = state_54813__$1;
(statearr_54816_54835[(2)] = null);

(statearr_54816_54835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54814 === (4))){
var inst_54784 = (state_54813[(2)]);
var state_54813__$1 = state_54813;
var statearr_54817_54836 = state_54813__$1;
(statearr_54817_54836[(2)] = inst_54784);

(statearr_54817_54836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54814 === (6))){
var state_54813__$1 = state_54813;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54813__$1,(9),str);
} else {
if((state_val_54814 === (3))){
var inst_54811 = (state_54813[(2)]);
var state_54813__$1 = state_54813;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54813__$1,inst_54811);
} else {
if((state_val_54814 === (2))){
var _ = (function (){var statearr_54819 = state_54813;
(statearr_54819[(4)] = cljs.core.cons((5),(state_54813[(4)])));

return statearr_54819;
})();
var inst_54790 = fluree.db.util.async.channel_QMARK_(str);
var state_54813__$1 = state_54813;
if(inst_54790){
var statearr_54820_54837 = state_54813__$1;
(statearr_54820_54837[(1)] = (6));

} else {
var statearr_54821_54838 = state_54813__$1;
(statearr_54821_54838[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54814 === (9))){
var inst_54793 = (state_54813[(2)]);
var inst_54794 = fluree.db.util.async.throw_err(inst_54793);
var state_54813__$1 = state_54813;
var statearr_54822_54839 = state_54813__$1;
(statearr_54822_54839[(2)] = inst_54794);

(statearr_54822_54839[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54814 === (5))){
var _ = (function (){var statearr_54823 = state_54813;
(statearr_54823[(4)] = cljs.core.rest((state_54813[(4)])));

return statearr_54823;
})();
var state_54813__$1 = state_54813;
var ex54818 = (state_54813__$1[(2)]);
var statearr_54824_54840 = state_54813__$1;
(statearr_54824_54840[(5)] = ex54818);


if((ex54818 instanceof Error)){
var statearr_54825_54841 = state_54813__$1;
(statearr_54825_54841[(1)] = (4));

(statearr_54825_54841[(5)] = null);

} else {
throw ex54818;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54814 === (8))){
var inst_54797 = (state_54813[(2)]);
var inst_54798 = fluree.db.dbfunctions.internal.upper_case(inst_54797);
var inst_54799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54800 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54802 = [inst_54797];
var inst_54803 = (new cljs.core.PersistentVector(null,1,(5),inst_54801,inst_54802,null));
var inst_54804 = ["upper-case",inst_54803,inst_54798];
var inst_54805 = cljs.core.PersistentHashMap.fromArrays(inst_54800,inst_54804);
var inst_54806 = [inst_54805,(10)];
var inst_54807 = (new cljs.core.PersistentVector(null,2,(5),inst_54799,inst_54806,null));
var inst_54808 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54807);
var _ = (function (){var statearr_54826 = state_54813;
(statearr_54826[(4)] = cljs.core.rest((state_54813[(4)])));

return statearr_54826;
})();
var state_54813__$1 = (function (){var statearr_54827 = state_54813;
(statearr_54827[(7)] = inst_54808);

return statearr_54827;
})();
var statearr_54828_54842 = state_54813__$1;
(statearr_54828_54842[(2)] = inst_54798);

(statearr_54828_54842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0 = (function (){
var statearr_54829 = [null,null,null,null,null,null,null,null];
(statearr_54829[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__);

(statearr_54829[(1)] = (1));

return statearr_54829;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1 = (function (state_54813){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54813);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54830){var ex__2687__auto__ = e54830;
var statearr_54831_54843 = state_54813;
(statearr_54831_54843[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54813[(4)]))){
var statearr_54832_54844 = state_54813;
(statearr_54832_54844[(1)] = cljs.core.first((state_54813[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54845 = state_54813;
state_54813 = G__54845;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__ = function(state_54813){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1.call(this,state_54813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54833 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54833[(6)] = c__2706__auto__);

return statearr_54833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54847 = arguments.length;
switch (G__54847) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54875){
var state_val_54876 = (state_54875[(1)]);
if((state_val_54876 === (1))){
var state_54875__$1 = state_54875;
var statearr_54877_54893 = state_54875__$1;
(statearr_54877_54893[(2)] = null);

(statearr_54877_54893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54876 === (2))){
var _ = (function (){var statearr_54878 = state_54875;
(statearr_54878[(4)] = cljs.core.cons((5),(state_54875[(4)])));

return statearr_54878;
})();
var inst_54857 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_54875__$1 = state_54875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54875__$1,(6),inst_54857);
} else {
if((state_val_54876 === (3))){
var inst_54873 = (state_54875[(2)]);
var state_54875__$1 = state_54875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54875__$1,inst_54873);
} else {
if((state_val_54876 === (4))){
var inst_54848 = (state_54875[(2)]);
var state_54875__$1 = state_54875;
var statearr_54880_54894 = state_54875__$1;
(statearr_54880_54894[(2)] = inst_54848);

(statearr_54880_54894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54876 === (5))){
var _ = (function (){var statearr_54881 = state_54875;
(statearr_54881[(4)] = cljs.core.rest((state_54875[(4)])));

return statearr_54881;
})();
var state_54875__$1 = state_54875;
var ex54879 = (state_54875__$1[(2)]);
var statearr_54882_54895 = state_54875__$1;
(statearr_54882_54895[(5)] = ex54879);


if((ex54879 instanceof Error)){
var statearr_54883_54896 = state_54875__$1;
(statearr_54883_54896[(1)] = (4));

(statearr_54883_54896[(5)] = null);

} else {
throw ex54879;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54876 === (6))){
var inst_54859 = (state_54875[(2)]);
var inst_54860 = fluree.db.util.async.throw_err(inst_54859);
var inst_54861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54860,(0),null);
var inst_54862 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54860,(1),null);
var inst_54863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54864 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54865 = ["?s","?ctx",inst_54861];
var inst_54866 = cljs.core.PersistentHashMap.fromArrays(inst_54864,inst_54865);
var inst_54867 = ((10) + inst_54862);
var inst_54868 = [inst_54866,inst_54867];
var inst_54869 = (new cljs.core.PersistentVector(null,2,(5),inst_54863,inst_54868,null));
var inst_54870 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54869);
var _ = (function (){var statearr_54884 = state_54875;
(statearr_54884[(4)] = cljs.core.rest((state_54875[(4)])));

return statearr_54884;
})();
var state_54875__$1 = (function (){var statearr_54885 = state_54875;
(statearr_54885[(7)] = inst_54870);

return statearr_54885;
})();
var statearr_54886_54897 = state_54875__$1;
(statearr_54886_54897[(2)] = inst_54861);

(statearr_54886_54897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_54887 = [null,null,null,null,null,null,null,null];
(statearr_54887[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_54887[(1)] = (1));

return statearr_54887;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_54875){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54875);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54888){var ex__2687__auto__ = e54888;
var statearr_54889_54898 = state_54875;
(statearr_54889_54898[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54875[(4)]))){
var statearr_54890_54899 = state_54875;
(statearr_54890_54899[(1)] = cljs.core.first((state_54875[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54900 = state_54875;
state_54875 = G__54900;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_54875){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_54875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54891 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54891[(6)] = c__2706__auto__);

return statearr_54891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54902 = arguments.length;
switch (G__54902) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54940){
var state_val_54941 = (state_54940[(1)]);
if((state_val_54941 === (7))){
var inst_54933 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54940__$1 = state_54940;
var statearr_54942_54962 = state_54940__$1;
(statearr_54942_54962[(2)] = inst_54933);

(statearr_54942_54962[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54941 === (1))){
var state_54940__$1 = state_54940;
var statearr_54943_54963 = state_54940__$1;
(statearr_54943_54963[(2)] = null);

(statearr_54943_54963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54941 === (4))){
var inst_54903 = (state_54940[(2)]);
var state_54940__$1 = state_54940;
var statearr_54944_54964 = state_54940__$1;
(statearr_54944_54964[(2)] = inst_54903);

(statearr_54944_54964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54941 === (6))){
var inst_54914 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_54940__$1 = state_54940;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54940__$1,(10),inst_54914);
} else {
if((state_val_54941 === (3))){
var inst_54938 = (state_54940[(2)]);
var state_54940__$1 = state_54940;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54940__$1,inst_54938);
} else {
if((state_val_54941 === (2))){
var _ = (function (){var statearr_54946 = state_54940;
(statearr_54946[(4)] = cljs.core.cons((5),(state_54940[(4)])));

return statearr_54946;
})();
var inst_54909 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54940__$1 = state_54940;
if(cljs.core.truth_(inst_54909)){
var statearr_54947_54965 = state_54940__$1;
(statearr_54947_54965[(1)] = (6));

} else {
var statearr_54948_54966 = state_54940__$1;
(statearr_54948_54966[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54941 === (9))){
var inst_54920 = (state_54940[(2)]);
var inst_54921 = fluree.db.util.async.throw_err(inst_54920);
var inst_54922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54921,(0),null);
var inst_54923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54921,(1),null);
var inst_54924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54925 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54926 = ["?p","?ctx",inst_54922];
var inst_54927 = cljs.core.PersistentHashMap.fromArrays(inst_54925,inst_54926);
var inst_54928 = ((10) + inst_54923);
var inst_54929 = [inst_54927,inst_54928];
var inst_54930 = (new cljs.core.PersistentVector(null,2,(5),inst_54924,inst_54929,null));
var inst_54931 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54930);
var state_54940__$1 = (function (){var statearr_54949 = state_54940;
(statearr_54949[(7)] = inst_54931);

return statearr_54949;
})();
var statearr_54950_54967 = state_54940__$1;
(statearr_54950_54967[(2)] = inst_54922);

(statearr_54950_54967[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54941 === (5))){
var _ = (function (){var statearr_54951 = state_54940;
(statearr_54951[(4)] = cljs.core.rest((state_54940[(4)])));

return statearr_54951;
})();
var state_54940__$1 = state_54940;
var ex54945 = (state_54940__$1[(2)]);
var statearr_54952_54968 = state_54940__$1;
(statearr_54952_54968[(5)] = ex54945);


if((ex54945 instanceof Error)){
var statearr_54953_54969 = state_54940__$1;
(statearr_54953_54969[(1)] = (4));

(statearr_54953_54969[(5)] = null);

} else {
throw ex54945;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54941 === (10))){
var inst_54916 = (state_54940[(2)]);
var inst_54917 = fluree.db.util.async.throw_err(inst_54916);
var inst_54918 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_54917);
var state_54940__$1 = state_54940;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54940__$1,(9),inst_54918);
} else {
if((state_val_54941 === (8))){
var inst_54935 = (state_54940[(2)]);
var _ = (function (){var statearr_54954 = state_54940;
(statearr_54954[(4)] = cljs.core.rest((state_54940[(4)])));

return statearr_54954;
})();
var state_54940__$1 = state_54940;
var statearr_54955_54970 = state_54940__$1;
(statearr_54955_54970[(2)] = inst_54935);

(statearr_54955_54970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_54956 = [null,null,null,null,null,null,null,null];
(statearr_54956[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_54956[(1)] = (1));

return statearr_54956;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_54940){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54940);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54957){var ex__2687__auto__ = e54957;
var statearr_54958_54971 = state_54940;
(statearr_54958_54971[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54940[(4)]))){
var statearr_54959_54972 = state_54940;
(statearr_54959_54972[(1)] = cljs.core.first((state_54940[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54973 = state_54940;
state_54940 = G__54973;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_54940){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_54940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54960 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54960[(6)] = c__2706__auto__);

return statearr_54960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55022 = arguments.length;
var i__5770__auto___55023 = (0);
while(true){
if((i__5770__auto___55023 < len__5769__auto___55022)){
args__5775__auto__.push((arguments[i__5770__auto___55023]));

var G__55024 = (i__5770__auto___55023 + (1));
i__5770__auto___55023 = G__55024;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55005){
var state_val_55006 = (state_55005[(1)]);
if((state_val_55006 === (1))){
var state_55005__$1 = state_55005;
var statearr_55007_55025 = state_55005__$1;
(statearr_55007_55025[(2)] = null);

(statearr_55007_55025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55006 === (2))){
var _ = (function (){var statearr_55008 = state_55005;
(statearr_55008[(4)] = cljs.core.cons((5),(state_55005[(4)])));

return statearr_55008;
})();
var inst_54982 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55005__$1 = state_55005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55005__$1,(6),inst_54982);
} else {
if((state_val_55006 === (3))){
var inst_55003 = (state_55005[(2)]);
var state_55005__$1 = state_55005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55005__$1,inst_55003);
} else {
if((state_val_55006 === (4))){
var inst_54976 = (state_55005[(2)]);
var state_55005__$1 = state_55005;
var statearr_55010_55026 = state_55005__$1;
(statearr_55010_55026[(2)] = inst_54976);

(statearr_55010_55026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55006 === (5))){
var _ = (function (){var statearr_55011 = state_55005;
(statearr_55011[(4)] = cljs.core.rest((state_55005[(4)])));

return statearr_55011;
})();
var state_55005__$1 = state_55005;
var ex55009 = (state_55005__$1[(2)]);
var statearr_55012_55027 = state_55005__$1;
(statearr_55012_55027[(5)] = ex55009);


if((ex55009 instanceof Error)){
var statearr_55013_55028 = state_55005__$1;
(statearr_55013_55028[(1)] = (4));

(statearr_55013_55028[(5)] = null);

} else {
throw ex55009;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55006 === (6))){
var inst_54984 = (state_55005[(2)]);
var inst_54985 = fluree.db.util.async.throw_err(inst_54984);
var inst_54986 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54985);
var inst_54987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54988 = [inst_54985];
var inst_54989 = (new cljs.core.PersistentVector(null,1,(5),inst_54987,inst_54988,null));
var inst_54990 = cljs.core.count(inst_54989);
var inst_54991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54992 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54994 = [inst_54985];
var inst_54995 = (new cljs.core.PersistentVector(null,1,(5),inst_54993,inst_54994,null));
var inst_54996 = ["and",inst_54995,inst_54986];
var inst_54997 = cljs.core.PersistentHashMap.fromArrays(inst_54992,inst_54996);
var inst_54998 = [inst_54997,inst_54990];
var inst_54999 = (new cljs.core.PersistentVector(null,2,(5),inst_54991,inst_54998,null));
var inst_55000 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54999);
var _ = (function (){var statearr_55014 = state_55005;
(statearr_55014[(4)] = cljs.core.rest((state_55005[(4)])));

return statearr_55014;
})();
var state_55005__$1 = (function (){var statearr_55015 = state_55005;
(statearr_55015[(7)] = inst_55000);

return statearr_55015;
})();
var statearr_55016_55029 = state_55005__$1;
(statearr_55016_55029[(2)] = inst_54986);

(statearr_55016_55029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55017 = [null,null,null,null,null,null,null,null];
(statearr_55017[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55017[(1)] = (1));

return statearr_55017;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55005){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55005);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55018){var ex__2687__auto__ = e55018;
var statearr_55019_55030 = state_55005;
(statearr_55019_55030[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55005[(4)]))){
var statearr_55020_55031 = state_55005;
(statearr_55020_55031[(1)] = cljs.core.first((state_55005[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55032 = state_55005;
state_55005 = G__55032;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55005){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55021 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55021[(6)] = c__2706__auto__);

return statearr_55021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54974){
var G__54975 = cljs.core.first(seq54974);
var seq54974__$1 = cljs.core.next(seq54974);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54975,seq54974__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55081 = arguments.length;
var i__5770__auto___55082 = (0);
while(true){
if((i__5770__auto___55082 < len__5769__auto___55081)){
args__5775__auto__.push((arguments[i__5770__auto___55082]));

var G__55083 = (i__5770__auto___55082 + (1));
i__5770__auto___55082 = G__55083;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55064){
var state_val_55065 = (state_55064[(1)]);
if((state_val_55065 === (1))){
var state_55064__$1 = state_55064;
var statearr_55066_55084 = state_55064__$1;
(statearr_55066_55084[(2)] = null);

(statearr_55066_55084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55065 === (2))){
var _ = (function (){var statearr_55067 = state_55064;
(statearr_55067[(4)] = cljs.core.cons((5),(state_55064[(4)])));

return statearr_55067;
})();
var inst_55041 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55064__$1 = state_55064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55064__$1,(6),inst_55041);
} else {
if((state_val_55065 === (3))){
var inst_55062 = (state_55064[(2)]);
var state_55064__$1 = state_55064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55064__$1,inst_55062);
} else {
if((state_val_55065 === (4))){
var inst_55035 = (state_55064[(2)]);
var state_55064__$1 = state_55064;
var statearr_55069_55085 = state_55064__$1;
(statearr_55069_55085[(2)] = inst_55035);

(statearr_55069_55085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55065 === (5))){
var _ = (function (){var statearr_55070 = state_55064;
(statearr_55070[(4)] = cljs.core.rest((state_55064[(4)])));

return statearr_55070;
})();
var state_55064__$1 = state_55064;
var ex55068 = (state_55064__$1[(2)]);
var statearr_55071_55086 = state_55064__$1;
(statearr_55071_55086[(5)] = ex55068);


if((ex55068 instanceof Error)){
var statearr_55072_55087 = state_55064__$1;
(statearr_55072_55087[(1)] = (4));

(statearr_55072_55087[(5)] = null);

} else {
throw ex55068;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55065 === (6))){
var inst_55043 = (state_55064[(2)]);
var inst_55044 = fluree.db.util.async.throw_err(inst_55043);
var inst_55045 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_55044);
var inst_55046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55047 = [inst_55044];
var inst_55048 = (new cljs.core.PersistentVector(null,1,(5),inst_55046,inst_55047,null));
var inst_55049 = cljs.core.count(inst_55048);
var inst_55050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55051 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55053 = [inst_55044];
var inst_55054 = (new cljs.core.PersistentVector(null,1,(5),inst_55052,inst_55053,null));
var inst_55055 = ["or",inst_55054,inst_55045];
var inst_55056 = cljs.core.PersistentHashMap.fromArrays(inst_55051,inst_55055);
var inst_55057 = [inst_55056,inst_55049];
var inst_55058 = (new cljs.core.PersistentVector(null,2,(5),inst_55050,inst_55057,null));
var inst_55059 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55058);
var _ = (function (){var statearr_55073 = state_55064;
(statearr_55073[(4)] = cljs.core.rest((state_55064[(4)])));

return statearr_55073;
})();
var state_55064__$1 = (function (){var statearr_55074 = state_55064;
(statearr_55074[(7)] = inst_55059);

return statearr_55074;
})();
var statearr_55075_55088 = state_55064__$1;
(statearr_55075_55088[(2)] = inst_55045);

(statearr_55075_55088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55076 = [null,null,null,null,null,null,null,null];
(statearr_55076[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55076[(1)] = (1));

return statearr_55076;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55064){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55064);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55077){var ex__2687__auto__ = e55077;
var statearr_55078_55089 = state_55064;
(statearr_55078_55089[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55064[(4)]))){
var statearr_55079_55090 = state_55064;
(statearr_55079_55090[(1)] = cljs.core.first((state_55064[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55091 = state_55064;
state_55064 = G__55091;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55064){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55080 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55080[(6)] = c__2706__auto__);

return statearr_55080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq55033){
var G__55034 = cljs.core.first(seq55033);
var seq55033__$1 = cljs.core.next(seq55033);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55034,seq55033__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55129){
var state_val_55130 = (state_55129[(1)]);
if((state_val_55130 === (7))){
var inst_55105 = fluree.db.util.async.channel_QMARK_(coll);
var state_55129__$1 = state_55129;
if(inst_55105){
var statearr_55131_55154 = state_55129__$1;
(statearr_55131_55154[(1)] = (10));

} else {
var statearr_55132_55155 = state_55129__$1;
(statearr_55132_55155[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55130 === (1))){
var state_55129__$1 = state_55129;
var statearr_55133_55156 = state_55129__$1;
(statearr_55133_55156[(2)] = null);

(statearr_55133_55156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55130 === (4))){
var inst_55092 = (state_55129[(2)]);
var state_55129__$1 = state_55129;
var statearr_55134_55157 = state_55129__$1;
(statearr_55134_55157[(2)] = inst_55092);

(statearr_55134_55157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55130 === (13))){
var inst_55108 = (state_55129[(2)]);
var inst_55109 = fluree.db.util.async.throw_err(inst_55108);
var state_55129__$1 = state_55129;
var statearr_55135_55158 = state_55129__$1;
(statearr_55135_55158[(2)] = inst_55109);

(statearr_55135_55158[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55130 === (6))){
var inst_55100 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_55129__$1 = state_55129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55129__$1,(9),inst_55100);
} else {
if((state_val_55130 === (3))){
var inst_55127 = (state_55129[(2)]);
var state_55129__$1 = state_55129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55129__$1,inst_55127);
} else {
if((state_val_55130 === (12))){
var inst_55112 = (state_55129[(2)]);
var state_55129__$1 = state_55129;
var statearr_55136_55159 = state_55129__$1;
(statearr_55136_55159[(2)] = inst_55112);

(statearr_55136_55159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55130 === (2))){
var _ = (function (){var statearr_55137 = state_55129;
(statearr_55137[(4)] = cljs.core.cons((5),(state_55129[(4)])));

return statearr_55137;
})();
var inst_55098 = cljs.core.vector_QMARK_(coll);
var state_55129__$1 = state_55129;
if(inst_55098){
var statearr_55138_55160 = state_55129__$1;
(statearr_55138_55160[(1)] = (6));

} else {
var statearr_55139_55161 = state_55129__$1;
(statearr_55139_55161[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55130 === (11))){
var state_55129__$1 = state_55129;
var statearr_55141_55162 = state_55129__$1;
(statearr_55141_55162[(2)] = coll);

(statearr_55141_55162[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55130 === (9))){
var inst_55102 = (state_55129[(2)]);
var inst_55103 = fluree.db.util.async.throw_err(inst_55102);
var state_55129__$1 = state_55129;
var statearr_55142_55163 = state_55129__$1;
(statearr_55142_55163[(2)] = inst_55103);

(statearr_55142_55163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55130 === (5))){
var _ = (function (){var statearr_55143 = state_55129;
(statearr_55143[(4)] = cljs.core.rest((state_55129[(4)])));

return statearr_55143;
})();
var state_55129__$1 = state_55129;
var ex55140 = (state_55129__$1[(2)]);
var statearr_55144_55164 = state_55129__$1;
(statearr_55144_55164[(5)] = ex55140);


if((ex55140 instanceof Error)){
var statearr_55145_55165 = state_55129__$1;
(statearr_55145_55165[(1)] = (4));

(statearr_55145_55165[(5)] = null);

} else {
throw ex55140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55130 === (10))){
var state_55129__$1 = state_55129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55129__$1,(13),coll);
} else {
if((state_val_55130 === (8))){
var inst_55114 = (state_55129[(2)]);
var inst_55115 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_55114);
var inst_55116 = cljs.core.count(inst_55115);
var inst_55117 = ((9) + inst_55116);
var inst_55118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55119 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55120 = ["count",inst_55114,inst_55116];
var inst_55121 = cljs.core.PersistentHashMap.fromArrays(inst_55119,inst_55120);
var inst_55122 = [inst_55121,inst_55117];
var inst_55123 = (new cljs.core.PersistentVector(null,2,(5),inst_55118,inst_55122,null));
var inst_55124 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55123);
var _ = (function (){var statearr_55146 = state_55129;
(statearr_55146[(4)] = cljs.core.rest((state_55129[(4)])));

return statearr_55146;
})();
var state_55129__$1 = (function (){var statearr_55147 = state_55129;
(statearr_55147[(7)] = inst_55124);

return statearr_55147;
})();
var statearr_55148_55166 = state_55129__$1;
(statearr_55148_55166[(2)] = inst_55116);

(statearr_55148_55166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0 = (function (){
var statearr_55149 = [null,null,null,null,null,null,null,null];
(statearr_55149[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__);

(statearr_55149[(1)] = (1));

return statearr_55149;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1 = (function (state_55129){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55129);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55150){var ex__2687__auto__ = e55150;
var statearr_55151_55167 = state_55129;
(statearr_55151_55167[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55129[(4)]))){
var statearr_55152_55168 = state_55129;
(statearr_55152_55168[(1)] = cljs.core.first((state_55129[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55169 = state_55129;
state_55129 = G__55169;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__ = function(state_55129){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1.call(this,state_55129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55153 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55153[(6)] = c__2706__auto__);

return statearr_55153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55219){
var state_val_55220 = (state_55219[(1)]);
if((state_val_55220 === (7))){
var state_55219__$1 = state_55219;
var statearr_55221_55254 = state_55219__$1;
(statearr_55221_55254[(2)] = subject);

(statearr_55221_55254[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (1))){
var state_55219__$1 = state_55219;
var statearr_55222_55255 = state_55219__$1;
(statearr_55222_55255[(2)] = null);

(statearr_55222_55255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (4))){
var inst_55170 = (state_55219[(2)]);
var state_55219__$1 = state_55219;
var statearr_55223_55256 = state_55219__$1;
(statearr_55223_55256[(2)] = inst_55170);

(statearr_55223_55256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (15))){
var inst_55183 = (state_55219[(7)]);
var state_55219__$1 = state_55219;
var statearr_55224_55257 = state_55219__$1;
(statearr_55224_55257[(2)] = inst_55183);

(statearr_55224_55257[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (13))){
var inst_55187 = (state_55219[(2)]);
var inst_55188 = fluree.db.util.async.throw_err(inst_55187);
var state_55219__$1 = state_55219;
var statearr_55225_55258 = state_55219__$1;
(statearr_55225_55258[(2)] = inst_55188);

(statearr_55225_55258[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (6))){
var state_55219__$1 = state_55219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55219__$1,(9),subject);
} else {
if((state_val_55220 === (17))){
var inst_55183 = (state_55219[(7)]);
var inst_55197 = cljs.core.first(inst_55183);
var state_55219__$1 = state_55219;
var statearr_55226_55259 = state_55219__$1;
(statearr_55226_55259[(2)] = inst_55197);

(statearr_55226_55259[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (3))){
var inst_55217 = (state_55219[(2)]);
var state_55219__$1 = state_55219;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55219__$1,inst_55217);
} else {
if((state_val_55220 === (12))){
var inst_55183 = (state_55219[(7)]);
var inst_55191 = (state_55219[(2)]);
var inst_55192 = cljs.core.vector_QMARK_(inst_55183);
var state_55219__$1 = (function (){var statearr_55227 = state_55219;
(statearr_55227[(8)] = inst_55191);

return statearr_55227;
})();
if(inst_55192){
var statearr_55228_55260 = state_55219__$1;
(statearr_55228_55260[(1)] = (14));

} else {
var statearr_55229_55261 = state_55219__$1;
(statearr_55229_55261[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (2))){
var _ = (function (){var statearr_55230 = state_55219;
(statearr_55230[(4)] = cljs.core.cons((5),(state_55219[(4)])));

return statearr_55230;
})();
var inst_55176 = fluree.db.util.async.channel_QMARK_(subject);
var state_55219__$1 = state_55219;
if(inst_55176){
var statearr_55231_55262 = state_55219__$1;
(statearr_55231_55262[(1)] = (6));

} else {
var statearr_55232_55263 = state_55219__$1;
(statearr_55232_55263[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (19))){
var inst_55200 = (state_55219[(2)]);
var state_55219__$1 = state_55219;
var statearr_55233_55264 = state_55219__$1;
(statearr_55233_55264[(2)] = inst_55200);

(statearr_55233_55264[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (11))){
var state_55219__$1 = state_55219;
var statearr_55235_55265 = state_55219__$1;
(statearr_55235_55265[(2)] = pred);

(statearr_55235_55265[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (9))){
var inst_55179 = (state_55219[(2)]);
var inst_55180 = fluree.db.util.async.throw_err(inst_55179);
var state_55219__$1 = state_55219;
var statearr_55236_55266 = state_55219__$1;
(statearr_55236_55266[(2)] = inst_55180);

(statearr_55236_55266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (5))){
var _ = (function (){var statearr_55237 = state_55219;
(statearr_55237[(4)] = cljs.core.rest((state_55219[(4)])));

return statearr_55237;
})();
var state_55219__$1 = state_55219;
var ex55234 = (state_55219__$1[(2)]);
var statearr_55238_55267 = state_55219__$1;
(statearr_55238_55267[(5)] = ex55234);


if((ex55234 instanceof Error)){
var statearr_55239_55268 = state_55219__$1;
(statearr_55239_55268[(1)] = (4));

(statearr_55239_55268[(5)] = null);

} else {
throw ex55234;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (14))){
var inst_55183 = (state_55219[(7)]);
var inst_55194 = cljs.core.count(inst_55183);
var inst_55195 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55194);
var state_55219__$1 = state_55219;
if(inst_55195){
var statearr_55240_55269 = state_55219__$1;
(statearr_55240_55269[(1)] = (17));

} else {
var statearr_55241_55270 = state_55219__$1;
(statearr_55241_55270[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (16))){
var inst_55183 = (state_55219[(7)]);
var inst_55191 = (state_55219[(8)]);
var inst_55203 = (state_55219[(2)]);
var inst_55204 = fluree.db.dbfunctions.internal.get(inst_55203,inst_55191);
var inst_55205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55206 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55208 = [inst_55183,inst_55191];
var inst_55209 = (new cljs.core.PersistentVector(null,2,(5),inst_55207,inst_55208,null));
var inst_55210 = ["get",inst_55209,inst_55204];
var inst_55211 = cljs.core.PersistentHashMap.fromArrays(inst_55206,inst_55210);
var inst_55212 = [inst_55211,(10)];
var inst_55213 = (new cljs.core.PersistentVector(null,2,(5),inst_55205,inst_55212,null));
var inst_55214 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55213);
var _ = (function (){var statearr_55242 = state_55219;
(statearr_55242[(4)] = cljs.core.rest((state_55219[(4)])));

return statearr_55242;
})();
var state_55219__$1 = (function (){var statearr_55243 = state_55219;
(statearr_55243[(9)] = inst_55214);

return statearr_55243;
})();
var statearr_55244_55271 = state_55219__$1;
(statearr_55244_55271[(2)] = inst_55204);

(statearr_55244_55271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (10))){
var state_55219__$1 = state_55219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55219__$1,(13),pred);
} else {
if((state_val_55220 === (18))){
var inst_55183 = (state_55219[(7)]);
var state_55219__$1 = state_55219;
var statearr_55245_55272 = state_55219__$1;
(statearr_55245_55272[(2)] = inst_55183);

(statearr_55245_55272[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55220 === (8))){
var inst_55183 = (state_55219[(2)]);
var inst_55184 = fluree.db.util.async.channel_QMARK_(pred);
var state_55219__$1 = (function (){var statearr_55246 = state_55219;
(statearr_55246[(7)] = inst_55183);

return statearr_55246;
})();
if(inst_55184){
var statearr_55247_55273 = state_55219__$1;
(statearr_55247_55273[(1)] = (10));

} else {
var statearr_55248_55274 = state_55219__$1;
(statearr_55248_55274[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0 = (function (){
var statearr_55249 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55249[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__);

(statearr_55249[(1)] = (1));

return statearr_55249;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1 = (function (state_55219){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55219);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55250){var ex__2687__auto__ = e55250;
var statearr_55251_55275 = state_55219;
(statearr_55251_55275[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55219[(4)]))){
var statearr_55252_55276 = state_55219;
(statearr_55252_55276[(1)] = cljs.core.first((state_55219[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55277 = state_55219;
state_55219 = G__55277;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__ = function(state_55219){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1.call(this,state_55219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55253 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55253[(6)] = c__2706__auto__);

return statearr_55253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55316){
var state_val_55317 = (state_55316[(1)]);
if((state_val_55317 === (7))){
var inst_55284 = (state_55316[(7)]);
var state_55316__$1 = state_55316;
var statearr_55318_55342 = state_55316__$1;
(statearr_55318_55342[(2)] = inst_55284);

(statearr_55318_55342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (1))){
var state_55316__$1 = state_55316;
var statearr_55319_55343 = state_55316__$1;
(statearr_55319_55343[(2)] = null);

(statearr_55319_55343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (4))){
var inst_55278 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
var statearr_55320_55344 = state_55316__$1;
(statearr_55320_55344[(2)] = inst_55278);

(statearr_55320_55344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (6))){
var inst_55286 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55316__$1 = state_55316;
var statearr_55321_55345 = state_55316__$1;
(statearr_55321_55345[(2)] = inst_55286);

(statearr_55321_55345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (3))){
var inst_55314 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55316__$1,inst_55314);
} else {
if((state_val_55317 === (12))){
var inst_55296 = (state_55316[(2)]);
var inst_55297 = fluree.db.util.async.throw_err(inst_55296);
var inst_55298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55297,(0),null);
var inst_55299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55297,(1),null);
var inst_55300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55301 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55302 = ["?pO","?ctx",inst_55298];
var inst_55303 = cljs.core.PersistentHashMap.fromArrays(inst_55301,inst_55302);
var inst_55304 = ((10) + inst_55299);
var inst_55305 = [inst_55303,inst_55304];
var inst_55306 = (new cljs.core.PersistentVector(null,2,(5),inst_55300,inst_55305,null));
var inst_55307 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55306);
var state_55316__$1 = (function (){var statearr_55322 = state_55316;
(statearr_55322[(8)] = inst_55307);

return statearr_55322;
})();
var statearr_55323_55346 = state_55316__$1;
(statearr_55323_55346[(2)] = inst_55298);

(statearr_55323_55346[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (2))){
var inst_55284 = (state_55316[(7)]);
var _ = (function (){var statearr_55324 = state_55316;
(statearr_55324[(4)] = cljs.core.cons((5),(state_55316[(4)])));

return statearr_55324;
})();
var inst_55284__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55316__$1 = (function (){var statearr_55325 = state_55316;
(statearr_55325[(7)] = inst_55284__$1);

return statearr_55325;
})();
if(cljs.core.truth_(inst_55284__$1)){
var statearr_55326_55347 = state_55316__$1;
(statearr_55326_55347[(1)] = (6));

} else {
var statearr_55327_55348 = state_55316__$1;
(statearr_55327_55348[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (11))){
var inst_55311 = (state_55316[(2)]);
var _ = (function (){var statearr_55329 = state_55316;
(statearr_55329[(4)] = cljs.core.rest((state_55316[(4)])));

return statearr_55329;
})();
var state_55316__$1 = state_55316;
var statearr_55330_55349 = state_55316__$1;
(statearr_55330_55349[(2)] = inst_55311);

(statearr_55330_55349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (9))){
var inst_55294 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_55316__$1 = state_55316;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55316__$1,(12),inst_55294);
} else {
if((state_val_55317 === (5))){
var _ = (function (){var statearr_55331 = state_55316;
(statearr_55331[(4)] = cljs.core.rest((state_55316[(4)])));

return statearr_55331;
})();
var state_55316__$1 = state_55316;
var ex55328 = (state_55316__$1[(2)]);
var statearr_55332_55350 = state_55316__$1;
(statearr_55332_55350[(5)] = ex55328);


if((ex55328 instanceof Error)){
var statearr_55333_55351 = state_55316__$1;
(statearr_55333_55351[(1)] = (4));

(statearr_55333_55351[(5)] = null);

} else {
throw ex55328;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (10))){
var inst_55309 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55316__$1 = state_55316;
var statearr_55334_55352 = state_55316__$1;
(statearr_55334_55352[(2)] = inst_55309);

(statearr_55334_55352[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (8))){
var inst_55289 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
if(cljs.core.truth_(inst_55289)){
var statearr_55335_55353 = state_55316__$1;
(statearr_55335_55353[(1)] = (9));

} else {
var statearr_55336_55354 = state_55316__$1;
(statearr_55336_55354[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0 = (function (){
var statearr_55337 = [null,null,null,null,null,null,null,null,null];
(statearr_55337[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__);

(statearr_55337[(1)] = (1));

return statearr_55337;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1 = (function (state_55316){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55316);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55338){var ex__2687__auto__ = e55338;
var statearr_55339_55355 = state_55316;
(statearr_55339_55355[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55316[(4)]))){
var statearr_55340_55356 = state_55316;
(statearr_55340_55356[(1)] = cljs.core.first((state_55316[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55357 = state_55316;
state_55316 = G__55357;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__ = function(state_55316){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1.call(this,state_55316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55341 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55341[(6)] = c__2706__auto__);

return statearr_55341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55409){
var state_val_55410 = (state_55409[(1)]);
if((state_val_55410 === (7))){
var state_55409__$1 = state_55409;
var statearr_55411_55444 = state_55409__$1;
(statearr_55411_55444[(2)] = subject);

(statearr_55411_55444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (1))){
var state_55409__$1 = state_55409;
var statearr_55412_55445 = state_55409__$1;
(statearr_55412_55445[(2)] = null);

(statearr_55412_55445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (4))){
var inst_55358 = (state_55409[(2)]);
var state_55409__$1 = state_55409;
var statearr_55413_55446 = state_55409__$1;
(statearr_55413_55446[(2)] = inst_55358);

(statearr_55413_55446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (15))){
var inst_55371 = (state_55409[(7)]);
var state_55409__$1 = state_55409;
var statearr_55414_55447 = state_55409__$1;
(statearr_55414_55447[(2)] = inst_55371);

(statearr_55414_55447[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (13))){
var inst_55375 = (state_55409[(2)]);
var inst_55376 = fluree.db.util.async.throw_err(inst_55375);
var state_55409__$1 = state_55409;
var statearr_55415_55448 = state_55409__$1;
(statearr_55415_55448[(2)] = inst_55376);

(statearr_55415_55448[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (6))){
var state_55409__$1 = state_55409;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55409__$1,(9),subject);
} else {
if((state_val_55410 === (17))){
var inst_55371 = (state_55409[(7)]);
var inst_55385 = cljs.core.first(inst_55371);
var state_55409__$1 = state_55409;
var statearr_55416_55449 = state_55409__$1;
(statearr_55416_55449[(2)] = inst_55385);

(statearr_55416_55449[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (3))){
var inst_55407 = (state_55409[(2)]);
var state_55409__$1 = state_55409;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55409__$1,inst_55407);
} else {
if((state_val_55410 === (12))){
var inst_55371 = (state_55409[(7)]);
var inst_55379 = (state_55409[(2)]);
var inst_55380 = cljs.core.vector_QMARK_(inst_55371);
var state_55409__$1 = (function (){var statearr_55417 = state_55409;
(statearr_55417[(8)] = inst_55379);

return statearr_55417;
})();
if(inst_55380){
var statearr_55418_55450 = state_55409__$1;
(statearr_55418_55450[(1)] = (14));

} else {
var statearr_55419_55451 = state_55409__$1;
(statearr_55419_55451[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (2))){
var _ = (function (){var statearr_55420 = state_55409;
(statearr_55420[(4)] = cljs.core.cons((5),(state_55409[(4)])));

return statearr_55420;
})();
var inst_55364 = fluree.db.util.async.channel_QMARK_(subject);
var state_55409__$1 = state_55409;
if(inst_55364){
var statearr_55421_55452 = state_55409__$1;
(statearr_55421_55452[(1)] = (6));

} else {
var statearr_55422_55453 = state_55409__$1;
(statearr_55422_55453[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (19))){
var inst_55388 = (state_55409[(2)]);
var state_55409__$1 = state_55409;
var statearr_55423_55454 = state_55409__$1;
(statearr_55423_55454[(2)] = inst_55388);

(statearr_55423_55454[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (11))){
var state_55409__$1 = state_55409;
var statearr_55425_55455 = state_55409__$1;
(statearr_55425_55455[(2)] = path);

(statearr_55425_55455[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (9))){
var inst_55367 = (state_55409[(2)]);
var inst_55368 = fluree.db.util.async.throw_err(inst_55367);
var state_55409__$1 = state_55409;
var statearr_55426_55456 = state_55409__$1;
(statearr_55426_55456[(2)] = inst_55368);

(statearr_55426_55456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (5))){
var _ = (function (){var statearr_55427 = state_55409;
(statearr_55427[(4)] = cljs.core.rest((state_55409[(4)])));

return statearr_55427;
})();
var state_55409__$1 = state_55409;
var ex55424 = (state_55409__$1[(2)]);
var statearr_55428_55457 = state_55409__$1;
(statearr_55428_55457[(5)] = ex55424);


if((ex55424 instanceof Error)){
var statearr_55429_55458 = state_55409__$1;
(statearr_55429_55458[(1)] = (4));

(statearr_55429_55458[(5)] = null);

} else {
throw ex55424;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (14))){
var inst_55371 = (state_55409[(7)]);
var inst_55382 = cljs.core.count(inst_55371);
var inst_55383 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55382);
var state_55409__$1 = state_55409;
if(inst_55383){
var statearr_55430_55459 = state_55409__$1;
(statearr_55430_55459[(1)] = (17));

} else {
var statearr_55431_55460 = state_55409__$1;
(statearr_55431_55460[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (16))){
var inst_55379 = (state_55409[(8)]);
var inst_55371 = (state_55409[(7)]);
var inst_55391 = (state_55409[(2)]);
var inst_55392 = fluree.db.dbfunctions.internal.get_all(inst_55391,inst_55379);
var inst_55393 = cljs.core.count(inst_55379);
var inst_55394 = ((9) + inst_55393);
var inst_55395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55396 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55398 = [inst_55371,inst_55379];
var inst_55399 = (new cljs.core.PersistentVector(null,2,(5),inst_55397,inst_55398,null));
var inst_55400 = ["get-all",inst_55399,inst_55392];
var inst_55401 = cljs.core.PersistentHashMap.fromArrays(inst_55396,inst_55400);
var inst_55402 = [inst_55401,inst_55394];
var inst_55403 = (new cljs.core.PersistentVector(null,2,(5),inst_55395,inst_55402,null));
var inst_55404 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55403);
var _ = (function (){var statearr_55432 = state_55409;
(statearr_55432[(4)] = cljs.core.rest((state_55409[(4)])));

return statearr_55432;
})();
var state_55409__$1 = (function (){var statearr_55433 = state_55409;
(statearr_55433[(9)] = inst_55404);

return statearr_55433;
})();
var statearr_55434_55461 = state_55409__$1;
(statearr_55434_55461[(2)] = inst_55392);

(statearr_55434_55461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (10))){
var state_55409__$1 = state_55409;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55409__$1,(13),path);
} else {
if((state_val_55410 === (18))){
var inst_55371 = (state_55409[(7)]);
var state_55409__$1 = state_55409;
var statearr_55435_55462 = state_55409__$1;
(statearr_55435_55462[(2)] = inst_55371);

(statearr_55435_55462[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55410 === (8))){
var inst_55371 = (state_55409[(2)]);
var inst_55372 = fluree.db.util.async.channel_QMARK_(path);
var state_55409__$1 = (function (){var statearr_55436 = state_55409;
(statearr_55436[(7)] = inst_55371);

return statearr_55436;
})();
if(inst_55372){
var statearr_55437_55463 = state_55409__$1;
(statearr_55437_55463[(1)] = (10));

} else {
var statearr_55438_55464 = state_55409__$1;
(statearr_55438_55464[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0 = (function (){
var statearr_55439 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55439[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__);

(statearr_55439[(1)] = (1));

return statearr_55439;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1 = (function (state_55409){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55409);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55440){var ex__2687__auto__ = e55440;
var statearr_55441_55465 = state_55409;
(statearr_55441_55465[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55409[(4)]))){
var statearr_55442_55466 = state_55409;
(statearr_55442_55466[(1)] = cljs.core.first((state_55409[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55467 = state_55409;
state_55409 = G__55467;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__ = function(state_55409){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1.call(this,state_55409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55443 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55443[(6)] = c__2706__auto__);

return statearr_55443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55506){
var state_val_55507 = (state_55506[(1)]);
if((state_val_55507 === (7))){
var state_55506__$1 = state_55506;
var statearr_55508_55532 = state_55506__$1;
(statearr_55508_55532[(2)] = subject);

(statearr_55508_55532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (1))){
var state_55506__$1 = state_55506;
var statearr_55509_55533 = state_55506__$1;
(statearr_55509_55533[(2)] = null);

(statearr_55509_55533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (4))){
var inst_55468 = (state_55506[(2)]);
var state_55506__$1 = state_55506;
var statearr_55510_55534 = state_55506__$1;
(statearr_55510_55534[(2)] = inst_55468);

(statearr_55510_55534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (13))){
var inst_55485 = (state_55506[(2)]);
var inst_55486 = fluree.db.util.async.throw_err(inst_55485);
var state_55506__$1 = state_55506;
var statearr_55511_55535 = state_55506__$1;
(statearr_55511_55535[(2)] = inst_55486);

(statearr_55511_55535[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (6))){
var state_55506__$1 = state_55506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55506__$1,(9),subject);
} else {
if((state_val_55507 === (3))){
var inst_55504 = (state_55506[(2)]);
var state_55506__$1 = state_55506;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55506__$1,inst_55504);
} else {
if((state_val_55507 === (12))){
var inst_55481 = (state_55506[(7)]);
var inst_55489 = (state_55506[(2)]);
var inst_55490 = fluree.db.dbfunctions.internal.get_in(inst_55481,inst_55489);
var inst_55491 = cljs.core.count(inst_55489);
var inst_55492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55493 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55495 = [inst_55481,inst_55489];
var inst_55496 = (new cljs.core.PersistentVector(null,2,(5),inst_55494,inst_55495,null));
var inst_55497 = ["get-in",inst_55496,inst_55490];
var inst_55498 = cljs.core.PersistentHashMap.fromArrays(inst_55493,inst_55497);
var inst_55499 = [inst_55498,inst_55491];
var inst_55500 = (new cljs.core.PersistentVector(null,2,(5),inst_55492,inst_55499,null));
var inst_55501 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55500);
var _ = (function (){var statearr_55512 = state_55506;
(statearr_55512[(4)] = cljs.core.rest((state_55506[(4)])));

return statearr_55512;
})();
var state_55506__$1 = (function (){var statearr_55513 = state_55506;
(statearr_55513[(8)] = inst_55501);

return statearr_55513;
})();
var statearr_55514_55536 = state_55506__$1;
(statearr_55514_55536[(2)] = inst_55490);

(statearr_55514_55536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (2))){
var _ = (function (){var statearr_55515 = state_55506;
(statearr_55515[(4)] = cljs.core.cons((5),(state_55506[(4)])));

return statearr_55515;
})();
var inst_55474 = fluree.db.util.async.channel_QMARK_(subject);
var state_55506__$1 = state_55506;
if(inst_55474){
var statearr_55516_55537 = state_55506__$1;
(statearr_55516_55537[(1)] = (6));

} else {
var statearr_55517_55538 = state_55506__$1;
(statearr_55517_55538[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (11))){
var state_55506__$1 = state_55506;
var statearr_55519_55539 = state_55506__$1;
(statearr_55519_55539[(2)] = path);

(statearr_55519_55539[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (9))){
var inst_55477 = (state_55506[(2)]);
var inst_55478 = fluree.db.util.async.throw_err(inst_55477);
var state_55506__$1 = state_55506;
var statearr_55520_55540 = state_55506__$1;
(statearr_55520_55540[(2)] = inst_55478);

(statearr_55520_55540[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (5))){
var _ = (function (){var statearr_55521 = state_55506;
(statearr_55521[(4)] = cljs.core.rest((state_55506[(4)])));

return statearr_55521;
})();
var state_55506__$1 = state_55506;
var ex55518 = (state_55506__$1[(2)]);
var statearr_55522_55541 = state_55506__$1;
(statearr_55522_55541[(5)] = ex55518);


if((ex55518 instanceof Error)){
var statearr_55523_55542 = state_55506__$1;
(statearr_55523_55542[(1)] = (4));

(statearr_55523_55542[(5)] = null);

} else {
throw ex55518;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (10))){
var state_55506__$1 = state_55506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55506__$1,(13),path);
} else {
if((state_val_55507 === (8))){
var inst_55481 = (state_55506[(2)]);
var inst_55482 = fluree.db.util.async.channel_QMARK_(path);
var state_55506__$1 = (function (){var statearr_55524 = state_55506;
(statearr_55524[(7)] = inst_55481);

return statearr_55524;
})();
if(inst_55482){
var statearr_55525_55543 = state_55506__$1;
(statearr_55525_55543[(1)] = (10));

} else {
var statearr_55526_55544 = state_55506__$1;
(statearr_55526_55544[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0 = (function (){
var statearr_55527 = [null,null,null,null,null,null,null,null,null];
(statearr_55527[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__);

(statearr_55527[(1)] = (1));

return statearr_55527;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1 = (function (state_55506){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55506);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55528){var ex__2687__auto__ = e55528;
var statearr_55529_55545 = state_55506;
(statearr_55529_55545[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55506[(4)]))){
var statearr_55530_55546 = state_55506;
(statearr_55530_55546[(1)] = cljs.core.first((state_55506[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55547 = state_55506;
state_55506 = G__55547;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__ = function(state_55506){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1.call(this,state_55506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55531 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55531[(6)] = c__2706__auto__);

return statearr_55531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55592){
var state_val_55593 = (state_55592[(1)]);
if((state_val_55593 === (7))){
var state_55592__$1 = state_55592;
var statearr_55594_55623 = state_55592__$1;
(statearr_55594_55623[(2)] = coll);

(statearr_55594_55623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (1))){
var state_55592__$1 = state_55592;
var statearr_55595_55624 = state_55592__$1;
(statearr_55595_55624[(2)] = null);

(statearr_55595_55624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (4))){
var inst_55548 = (state_55592[(2)]);
var state_55592__$1 = state_55592;
var statearr_55596_55625 = state_55592__$1;
(statearr_55596_55625[(2)] = inst_55548);

(statearr_55596_55625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (15))){
var inst_55568 = (state_55592[(7)]);
var inst_55576 = (state_55592[(2)]);
var inst_55577 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_55568,inst_55576);
var inst_55578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55579 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55581 = [inst_55568,inst_55576];
var inst_55582 = (new cljs.core.PersistentVector(null,2,(5),inst_55580,inst_55581,null));
var inst_55583 = ["contains?",inst_55582,inst_55577];
var inst_55584 = cljs.core.PersistentHashMap.fromArrays(inst_55579,inst_55583);
var inst_55585 = [inst_55584,(10)];
var inst_55586 = (new cljs.core.PersistentVector(null,2,(5),inst_55578,inst_55585,null));
var inst_55587 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55586);
var _ = (function (){var statearr_55597 = state_55592;
(statearr_55597[(4)] = cljs.core.rest((state_55592[(4)])));

return statearr_55597;
})();
var state_55592__$1 = (function (){var statearr_55598 = state_55592;
(statearr_55598[(8)] = inst_55587);

return statearr_55598;
})();
var statearr_55599_55626 = state_55592__$1;
(statearr_55599_55626[(2)] = inst_55577);

(statearr_55599_55626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (13))){
var state_55592__$1 = state_55592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55592__$1,(16),key);
} else {
if((state_val_55593 === (6))){
var state_55592__$1 = state_55592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55592__$1,(9),coll);
} else {
if((state_val_55593 === (3))){
var inst_55590 = (state_55592[(2)]);
var state_55592__$1 = state_55592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55592__$1,inst_55590);
} else {
if((state_val_55593 === (12))){
var inst_55568 = (state_55592[(2)]);
var inst_55569 = fluree.db.util.async.channel_QMARK_(key);
var state_55592__$1 = (function (){var statearr_55600 = state_55592;
(statearr_55600[(7)] = inst_55568);

return statearr_55600;
})();
if(inst_55569){
var statearr_55601_55627 = state_55592__$1;
(statearr_55601_55627[(1)] = (13));

} else {
var statearr_55602_55628 = state_55592__$1;
(statearr_55602_55628[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (2))){
var _ = (function (){var statearr_55603 = state_55592;
(statearr_55603[(4)] = cljs.core.cons((5),(state_55592[(4)])));

return statearr_55603;
})();
var inst_55554 = fluree.db.util.async.channel_QMARK_(coll);
var state_55592__$1 = state_55592;
if(inst_55554){
var statearr_55604_55629 = state_55592__$1;
(statearr_55604_55629[(1)] = (6));

} else {
var statearr_55605_55630 = state_55592__$1;
(statearr_55605_55630[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (11))){
var inst_55561 = (state_55592[(9)]);
var inst_55565 = cljs.core.flatten(inst_55561);
var inst_55566 = cljs.core.set(inst_55565);
var state_55592__$1 = state_55592;
var statearr_55607_55631 = state_55592__$1;
(statearr_55607_55631[(2)] = inst_55566);

(statearr_55607_55631[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (9))){
var inst_55557 = (state_55592[(2)]);
var inst_55558 = fluree.db.util.async.throw_err(inst_55557);
var state_55592__$1 = state_55592;
var statearr_55608_55632 = state_55592__$1;
(statearr_55608_55632[(2)] = inst_55558);

(statearr_55608_55632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (5))){
var _ = (function (){var statearr_55609 = state_55592;
(statearr_55609[(4)] = cljs.core.rest((state_55592[(4)])));

return statearr_55609;
})();
var state_55592__$1 = state_55592;
var ex55606 = (state_55592__$1[(2)]);
var statearr_55610_55633 = state_55592__$1;
(statearr_55610_55633[(5)] = ex55606);


if((ex55606 instanceof Error)){
var statearr_55611_55634 = state_55592__$1;
(statearr_55611_55634[(1)] = (4));

(statearr_55611_55634[(5)] = null);

} else {
throw ex55606;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (14))){
var state_55592__$1 = state_55592;
var statearr_55612_55635 = state_55592__$1;
(statearr_55612_55635[(2)] = key);

(statearr_55612_55635[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (16))){
var inst_55572 = (state_55592[(2)]);
var inst_55573 = fluree.db.util.async.throw_err(inst_55572);
var state_55592__$1 = state_55592;
var statearr_55613_55636 = state_55592__$1;
(statearr_55613_55636[(2)] = inst_55573);

(statearr_55613_55636[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (10))){
var inst_55561 = (state_55592[(9)]);
var state_55592__$1 = state_55592;
var statearr_55614_55637 = state_55592__$1;
(statearr_55614_55637[(2)] = inst_55561);

(statearr_55614_55637[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (8))){
var inst_55561 = (state_55592[(9)]);
var inst_55561__$1 = (state_55592[(2)]);
var inst_55562 = cljs.core.set_QMARK_(inst_55561__$1);
var state_55592__$1 = (function (){var statearr_55615 = state_55592;
(statearr_55615[(9)] = inst_55561__$1);

return statearr_55615;
})();
if(inst_55562){
var statearr_55616_55638 = state_55592__$1;
(statearr_55616_55638[(1)] = (10));

} else {
var statearr_55617_55639 = state_55592__$1;
(statearr_55617_55639[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_55618 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55618[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__);

(statearr_55618[(1)] = (1));

return statearr_55618;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1 = (function (state_55592){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55592);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55619){var ex__2687__auto__ = e55619;
var statearr_55620_55640 = state_55592;
(statearr_55620_55640[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55592[(4)]))){
var statearr_55621_55641 = state_55592;
(statearr_55621_55641[(1)] = cljs.core.first((state_55592[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55642 = state_55592;
state_55592 = G__55642;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__ = function(state_55592){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1.call(this,state_55592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55622 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55622[(6)] = c__2706__auto__);

return statearr_55622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55714 = arguments.length;
var i__5770__auto___55715 = (0);
while(true){
if((i__5770__auto___55715 < len__5769__auto___55714)){
args__5775__auto__.push((arguments[i__5770__auto___55715]));

var G__55716 = (i__5770__auto___55715 + (1));
i__5770__auto___55715 = G__55716;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55688){
var state_val_55689 = (state_55688[(1)]);
if((state_val_55689 === (7))){
var inst_55654 = (state_55688[(7)]);
var inst_55658 = cljs.core.first(inst_55654);
var inst_55659 = cljs.core.coll_QMARK_(inst_55658);
var state_55688__$1 = state_55688;
var statearr_55690_55717 = state_55688__$1;
(statearr_55690_55717[(2)] = inst_55659);

(statearr_55690_55717[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55689 === (1))){
var state_55688__$1 = state_55688;
var statearr_55691_55718 = state_55688__$1;
(statearr_55691_55718[(2)] = null);

(statearr_55691_55718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55689 === (4))){
var inst_55645 = (state_55688[(2)]);
var state_55688__$1 = state_55688;
var statearr_55692_55719 = state_55688__$1;
(statearr_55692_55719[(2)] = inst_55645);

(statearr_55692_55719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55689 === (6))){
var inst_55654 = (state_55688[(7)]);
var inst_55656 = (state_55688[(8)]);
var inst_55653 = (state_55688[(2)]);
var inst_55654__$1 = fluree.db.util.async.throw_err(inst_55653);
var inst_55655 = cljs.core.count(inst_55654__$1);
var inst_55656__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55655);
var state_55688__$1 = (function (){var statearr_55693 = state_55688;
(statearr_55693[(7)] = inst_55654__$1);

(statearr_55693[(8)] = inst_55656__$1);

return statearr_55693;
})();
if(inst_55656__$1){
var statearr_55694_55720 = state_55688__$1;
(statearr_55694_55720[(1)] = (7));

} else {
var statearr_55695_55721 = state_55688__$1;
(statearr_55695_55721[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55689 === (3))){
var inst_55686 = (state_55688[(2)]);
var state_55688__$1 = state_55688;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55688__$1,inst_55686);
} else {
if((state_val_55689 === (12))){
var inst_55667 = (state_55688[(2)]);
var inst_55668 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_55667);
var inst_55669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55670 = [inst_55667];
var inst_55671 = (new cljs.core.PersistentVector(null,1,(5),inst_55669,inst_55670,null));
var inst_55672 = cljs.core.count(inst_55671);
var inst_55673 = ((9) + inst_55672);
var inst_55674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55675 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55677 = [inst_55667];
var inst_55678 = (new cljs.core.PersistentVector(null,1,(5),inst_55676,inst_55677,null));
var inst_55679 = ["hash-set",inst_55678,inst_55668];
var inst_55680 = cljs.core.PersistentHashMap.fromArrays(inst_55675,inst_55679);
var inst_55681 = [inst_55680,inst_55673];
var inst_55682 = (new cljs.core.PersistentVector(null,2,(5),inst_55674,inst_55681,null));
var inst_55683 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55682);
var _ = (function (){var statearr_55696 = state_55688;
(statearr_55696[(4)] = cljs.core.rest((state_55688[(4)])));

return statearr_55696;
})();
var state_55688__$1 = (function (){var statearr_55697 = state_55688;
(statearr_55697[(9)] = inst_55683);

return statearr_55697;
})();
var statearr_55698_55722 = state_55688__$1;
(statearr_55698_55722[(2)] = inst_55668);

(statearr_55698_55722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55689 === (2))){
var _ = (function (){var statearr_55699 = state_55688;
(statearr_55699[(4)] = cljs.core.cons((5),(state_55688[(4)])));

return statearr_55699;
})();
var inst_55651 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55688__$1 = state_55688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55688__$1,(6),inst_55651);
} else {
if((state_val_55689 === (11))){
var inst_55654 = (state_55688[(7)]);
var state_55688__$1 = state_55688;
var statearr_55701_55723 = state_55688__$1;
(statearr_55701_55723[(2)] = inst_55654);

(statearr_55701_55723[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55689 === (9))){
var inst_55662 = (state_55688[(2)]);
var state_55688__$1 = state_55688;
if(cljs.core.truth_(inst_55662)){
var statearr_55702_55724 = state_55688__$1;
(statearr_55702_55724[(1)] = (10));

} else {
var statearr_55703_55725 = state_55688__$1;
(statearr_55703_55725[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55689 === (5))){
var _ = (function (){var statearr_55704 = state_55688;
(statearr_55704[(4)] = cljs.core.rest((state_55688[(4)])));

return statearr_55704;
})();
var state_55688__$1 = state_55688;
var ex55700 = (state_55688__$1[(2)]);
var statearr_55705_55726 = state_55688__$1;
(statearr_55705_55726[(5)] = ex55700);


if((ex55700 instanceof Error)){
var statearr_55706_55727 = state_55688__$1;
(statearr_55706_55727[(1)] = (4));

(statearr_55706_55727[(5)] = null);

} else {
throw ex55700;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55689 === (10))){
var inst_55654 = (state_55688[(7)]);
var inst_55664 = cljs.core.first(inst_55654);
var state_55688__$1 = state_55688;
var statearr_55707_55728 = state_55688__$1;
(statearr_55707_55728[(2)] = inst_55664);

(statearr_55707_55728[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55689 === (8))){
var inst_55656 = (state_55688[(8)]);
var state_55688__$1 = state_55688;
var statearr_55708_55729 = state_55688__$1;
(statearr_55708_55729[(2)] = inst_55656);

(statearr_55708_55729[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55709 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55709[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55709[(1)] = (1));

return statearr_55709;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55688){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55688);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55710){var ex__2687__auto__ = e55710;
var statearr_55711_55730 = state_55688;
(statearr_55711_55730[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55688[(4)]))){
var statearr_55712_55731 = state_55688;
(statearr_55712_55731[(1)] = cljs.core.first((state_55688[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55732 = state_55688;
state_55688 = G__55732;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55688){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55713 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55713[(6)] = c__2706__auto__);

return statearr_55713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55643){
var G__55644 = cljs.core.first(seq55643);
var seq55643__$1 = cljs.core.next(seq55643);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55644,seq55643__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55782 = arguments.length;
var i__5770__auto___55783 = (0);
while(true){
if((i__5770__auto___55783 < len__5769__auto___55782)){
args__5775__auto__.push((arguments[i__5770__auto___55783]));

var G__55784 = (i__5770__auto___55783 + (1));
i__5770__auto___55783 = G__55784;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55765){
var state_val_55766 = (state_55765[(1)]);
if((state_val_55766 === (1))){
var state_55765__$1 = state_55765;
var statearr_55767_55785 = state_55765__$1;
(statearr_55767_55785[(2)] = null);

(statearr_55767_55785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55766 === (2))){
var _ = (function (){var statearr_55768 = state_55765;
(statearr_55768[(4)] = cljs.core.cons((5),(state_55765[(4)])));

return statearr_55768;
})();
var inst_55741 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55765__$1 = state_55765;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55765__$1,(6),inst_55741);
} else {
if((state_val_55766 === (3))){
var inst_55763 = (state_55765[(2)]);
var state_55765__$1 = state_55765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55765__$1,inst_55763);
} else {
if((state_val_55766 === (4))){
var inst_55735 = (state_55765[(2)]);
var state_55765__$1 = state_55765;
var statearr_55770_55786 = state_55765__$1;
(statearr_55770_55786[(2)] = inst_55735);

(statearr_55770_55786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55766 === (5))){
var _ = (function (){var statearr_55771 = state_55765;
(statearr_55771[(4)] = cljs.core.rest((state_55765[(4)])));

return statearr_55771;
})();
var state_55765__$1 = state_55765;
var ex55769 = (state_55765__$1[(2)]);
var statearr_55772_55787 = state_55765__$1;
(statearr_55772_55787[(5)] = ex55769);


if((ex55769 instanceof Error)){
var statearr_55773_55788 = state_55765__$1;
(statearr_55773_55788[(1)] = (4));

(statearr_55773_55788[(5)] = null);

} else {
throw ex55769;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55766 === (6))){
var inst_55743 = (state_55765[(2)]);
var inst_55744 = fluree.db.util.async.throw_err(inst_55743);
var inst_55745 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_55744);
var inst_55746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55747 = [inst_55744];
var inst_55748 = (new cljs.core.PersistentVector(null,1,(5),inst_55746,inst_55747,null));
var inst_55749 = cljs.core.count(inst_55748);
var inst_55750 = ((9) + inst_55749);
var inst_55751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55752 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55754 = [inst_55744];
var inst_55755 = (new cljs.core.PersistentVector(null,1,(5),inst_55753,inst_55754,null));
var inst_55756 = ["==",inst_55755,inst_55745];
var inst_55757 = cljs.core.PersistentHashMap.fromArrays(inst_55752,inst_55756);
var inst_55758 = [inst_55757,inst_55750];
var inst_55759 = (new cljs.core.PersistentVector(null,2,(5),inst_55751,inst_55758,null));
var inst_55760 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55759);
var _ = (function (){var statearr_55774 = state_55765;
(statearr_55774[(4)] = cljs.core.rest((state_55765[(4)])));

return statearr_55774;
})();
var state_55765__$1 = (function (){var statearr_55775 = state_55765;
(statearr_55775[(7)] = inst_55760);

return statearr_55775;
})();
var statearr_55776_55789 = state_55765__$1;
(statearr_55776_55789[(2)] = inst_55745);

(statearr_55776_55789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55777 = [null,null,null,null,null,null,null,null];
(statearr_55777[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55777[(1)] = (1));

return statearr_55777;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55765){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55765);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55778){var ex__2687__auto__ = e55778;
var statearr_55779_55790 = state_55765;
(statearr_55779_55790[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55765[(4)]))){
var statearr_55780_55791 = state_55765;
(statearr_55780_55791[(1)] = cljs.core.first((state_55765[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55792 = state_55765;
state_55765 = G__55792;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55765){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55781 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55781[(6)] = c__2706__auto__);

return statearr_55781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55733){
var G__55734 = cljs.core.first(seq55733);
var seq55733__$1 = cljs.core.next(seq55733);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55734,seq55733__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55842 = arguments.length;
var i__5770__auto___55843 = (0);
while(true){
if((i__5770__auto___55843 < len__5769__auto___55842)){
args__5775__auto__.push((arguments[i__5770__auto___55843]));

var G__55844 = (i__5770__auto___55843 + (1));
i__5770__auto___55843 = G__55844;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55825){
var state_val_55826 = (state_55825[(1)]);
if((state_val_55826 === (1))){
var state_55825__$1 = state_55825;
var statearr_55827_55845 = state_55825__$1;
(statearr_55827_55845[(2)] = null);

(statearr_55827_55845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (2))){
var _ = (function (){var statearr_55828 = state_55825;
(statearr_55828[(4)] = cljs.core.cons((5),(state_55825[(4)])));

return statearr_55828;
})();
var inst_55801 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55825__$1 = state_55825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55825__$1,(6),inst_55801);
} else {
if((state_val_55826 === (3))){
var inst_55823 = (state_55825[(2)]);
var state_55825__$1 = state_55825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55825__$1,inst_55823);
} else {
if((state_val_55826 === (4))){
var inst_55795 = (state_55825[(2)]);
var state_55825__$1 = state_55825;
var statearr_55830_55846 = state_55825__$1;
(statearr_55830_55846[(2)] = inst_55795);

(statearr_55830_55846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (5))){
var _ = (function (){var statearr_55831 = state_55825;
(statearr_55831[(4)] = cljs.core.rest((state_55825[(4)])));

return statearr_55831;
})();
var state_55825__$1 = state_55825;
var ex55829 = (state_55825__$1[(2)]);
var statearr_55832_55847 = state_55825__$1;
(statearr_55832_55847[(5)] = ex55829);


if((ex55829 instanceof Error)){
var statearr_55833_55848 = state_55825__$1;
(statearr_55833_55848[(1)] = (4));

(statearr_55833_55848[(5)] = null);

} else {
throw ex55829;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (6))){
var inst_55803 = (state_55825[(2)]);
var inst_55804 = fluree.db.util.async.throw_err(inst_55803);
var inst_55805 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_55804);
var inst_55806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55807 = [inst_55804];
var inst_55808 = (new cljs.core.PersistentVector(null,1,(5),inst_55806,inst_55807,null));
var inst_55809 = cljs.core.count(inst_55808);
var inst_55810 = ((9) + inst_55809);
var inst_55811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55812 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55814 = [inst_55804];
var inst_55815 = (new cljs.core.PersistentVector(null,1,(5),inst_55813,inst_55814,null));
var inst_55816 = [">",inst_55815,inst_55805];
var inst_55817 = cljs.core.PersistentHashMap.fromArrays(inst_55812,inst_55816);
var inst_55818 = [inst_55817,inst_55810];
var inst_55819 = (new cljs.core.PersistentVector(null,2,(5),inst_55811,inst_55818,null));
var inst_55820 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55819);
var _ = (function (){var statearr_55834 = state_55825;
(statearr_55834[(4)] = cljs.core.rest((state_55825[(4)])));

return statearr_55834;
})();
var state_55825__$1 = (function (){var statearr_55835 = state_55825;
(statearr_55835[(7)] = inst_55820);

return statearr_55835;
})();
var statearr_55836_55849 = state_55825__$1;
(statearr_55836_55849[(2)] = inst_55805);

(statearr_55836_55849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55837 = [null,null,null,null,null,null,null,null];
(statearr_55837[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55837[(1)] = (1));

return statearr_55837;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55825){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55825);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55838){var ex__2687__auto__ = e55838;
var statearr_55839_55850 = state_55825;
(statearr_55839_55850[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55825[(4)]))){
var statearr_55840_55851 = state_55825;
(statearr_55840_55851[(1)] = cljs.core.first((state_55825[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55852 = state_55825;
state_55825 = G__55852;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55825){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55841 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55841[(6)] = c__2706__auto__);

return statearr_55841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55793){
var G__55794 = cljs.core.first(seq55793);
var seq55793__$1 = cljs.core.next(seq55793);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55794,seq55793__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55902 = arguments.length;
var i__5770__auto___55903 = (0);
while(true){
if((i__5770__auto___55903 < len__5769__auto___55902)){
args__5775__auto__.push((arguments[i__5770__auto___55903]));

var G__55904 = (i__5770__auto___55903 + (1));
i__5770__auto___55903 = G__55904;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55885){
var state_val_55886 = (state_55885[(1)]);
if((state_val_55886 === (1))){
var state_55885__$1 = state_55885;
var statearr_55887_55905 = state_55885__$1;
(statearr_55887_55905[(2)] = null);

(statearr_55887_55905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (2))){
var _ = (function (){var statearr_55888 = state_55885;
(statearr_55888[(4)] = cljs.core.cons((5),(state_55885[(4)])));

return statearr_55888;
})();
var inst_55861 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55885__$1 = state_55885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55885__$1,(6),inst_55861);
} else {
if((state_val_55886 === (3))){
var inst_55883 = (state_55885[(2)]);
var state_55885__$1 = state_55885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55885__$1,inst_55883);
} else {
if((state_val_55886 === (4))){
var inst_55855 = (state_55885[(2)]);
var state_55885__$1 = state_55885;
var statearr_55890_55906 = state_55885__$1;
(statearr_55890_55906[(2)] = inst_55855);

(statearr_55890_55906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (5))){
var _ = (function (){var statearr_55891 = state_55885;
(statearr_55891[(4)] = cljs.core.rest((state_55885[(4)])));

return statearr_55891;
})();
var state_55885__$1 = state_55885;
var ex55889 = (state_55885__$1[(2)]);
var statearr_55892_55907 = state_55885__$1;
(statearr_55892_55907[(5)] = ex55889);


if((ex55889 instanceof Error)){
var statearr_55893_55908 = state_55885__$1;
(statearr_55893_55908[(1)] = (4));

(statearr_55893_55908[(5)] = null);

} else {
throw ex55889;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (6))){
var inst_55863 = (state_55885[(2)]);
var inst_55864 = fluree.db.util.async.throw_err(inst_55863);
var inst_55865 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_55864);
var inst_55866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55867 = [inst_55864];
var inst_55868 = (new cljs.core.PersistentVector(null,1,(5),inst_55866,inst_55867,null));
var inst_55869 = cljs.core.count(inst_55868);
var inst_55870 = ((9) + inst_55869);
var inst_55871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55872 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55874 = [inst_55864];
var inst_55875 = (new cljs.core.PersistentVector(null,1,(5),inst_55873,inst_55874,null));
var inst_55876 = ["<",inst_55875,inst_55865];
var inst_55877 = cljs.core.PersistentHashMap.fromArrays(inst_55872,inst_55876);
var inst_55878 = [inst_55877,inst_55870];
var inst_55879 = (new cljs.core.PersistentVector(null,2,(5),inst_55871,inst_55878,null));
var inst_55880 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55879);
var _ = (function (){var statearr_55894 = state_55885;
(statearr_55894[(4)] = cljs.core.rest((state_55885[(4)])));

return statearr_55894;
})();
var state_55885__$1 = (function (){var statearr_55895 = state_55885;
(statearr_55895[(7)] = inst_55880);

return statearr_55895;
})();
var statearr_55896_55909 = state_55885__$1;
(statearr_55896_55909[(2)] = inst_55865);

(statearr_55896_55909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55897 = [null,null,null,null,null,null,null,null];
(statearr_55897[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55897[(1)] = (1));

return statearr_55897;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55885){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55885);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55898){var ex__2687__auto__ = e55898;
var statearr_55899_55910 = state_55885;
(statearr_55899_55910[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55885[(4)]))){
var statearr_55900_55911 = state_55885;
(statearr_55900_55911[(1)] = cljs.core.first((state_55885[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55912 = state_55885;
state_55885 = G__55912;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55885){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55901 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55901[(6)] = c__2706__auto__);

return statearr_55901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55853){
var G__55854 = cljs.core.first(seq55853);
var seq55853__$1 = cljs.core.next(seq55853);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55854,seq55853__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55962 = arguments.length;
var i__5770__auto___55963 = (0);
while(true){
if((i__5770__auto___55963 < len__5769__auto___55962)){
args__5775__auto__.push((arguments[i__5770__auto___55963]));

var G__55964 = (i__5770__auto___55963 + (1));
i__5770__auto___55963 = G__55964;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55945){
var state_val_55946 = (state_55945[(1)]);
if((state_val_55946 === (1))){
var state_55945__$1 = state_55945;
var statearr_55947_55965 = state_55945__$1;
(statearr_55947_55965[(2)] = null);

(statearr_55947_55965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55946 === (2))){
var _ = (function (){var statearr_55948 = state_55945;
(statearr_55948[(4)] = cljs.core.cons((5),(state_55945[(4)])));

return statearr_55948;
})();
var inst_55921 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55945__$1 = state_55945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55945__$1,(6),inst_55921);
} else {
if((state_val_55946 === (3))){
var inst_55943 = (state_55945[(2)]);
var state_55945__$1 = state_55945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55945__$1,inst_55943);
} else {
if((state_val_55946 === (4))){
var inst_55915 = (state_55945[(2)]);
var state_55945__$1 = state_55945;
var statearr_55950_55966 = state_55945__$1;
(statearr_55950_55966[(2)] = inst_55915);

(statearr_55950_55966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55946 === (5))){
var _ = (function (){var statearr_55951 = state_55945;
(statearr_55951[(4)] = cljs.core.rest((state_55945[(4)])));

return statearr_55951;
})();
var state_55945__$1 = state_55945;
var ex55949 = (state_55945__$1[(2)]);
var statearr_55952_55967 = state_55945__$1;
(statearr_55952_55967[(5)] = ex55949);


if((ex55949 instanceof Error)){
var statearr_55953_55968 = state_55945__$1;
(statearr_55953_55968[(1)] = (4));

(statearr_55953_55968[(5)] = null);

} else {
throw ex55949;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55946 === (6))){
var inst_55923 = (state_55945[(2)]);
var inst_55924 = fluree.db.util.async.throw_err(inst_55923);
var inst_55925 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_55924);
var inst_55926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55927 = [inst_55924];
var inst_55928 = (new cljs.core.PersistentVector(null,1,(5),inst_55926,inst_55927,null));
var inst_55929 = cljs.core.count(inst_55928);
var inst_55930 = ((9) + inst_55929);
var inst_55931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55932 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55934 = [inst_55924];
var inst_55935 = (new cljs.core.PersistentVector(null,1,(5),inst_55933,inst_55934,null));
var inst_55936 = ["<=",inst_55935,inst_55925];
var inst_55937 = cljs.core.PersistentHashMap.fromArrays(inst_55932,inst_55936);
var inst_55938 = [inst_55937,inst_55930];
var inst_55939 = (new cljs.core.PersistentVector(null,2,(5),inst_55931,inst_55938,null));
var inst_55940 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55939);
var _ = (function (){var statearr_55954 = state_55945;
(statearr_55954[(4)] = cljs.core.rest((state_55945[(4)])));

return statearr_55954;
})();
var state_55945__$1 = (function (){var statearr_55955 = state_55945;
(statearr_55955[(7)] = inst_55940);

return statearr_55955;
})();
var statearr_55956_55969 = state_55945__$1;
(statearr_55956_55969[(2)] = inst_55925);

(statearr_55956_55969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55957 = [null,null,null,null,null,null,null,null];
(statearr_55957[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55957[(1)] = (1));

return statearr_55957;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55945){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55945);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55958){var ex__2687__auto__ = e55958;
var statearr_55959_55970 = state_55945;
(statearr_55959_55970[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55945[(4)]))){
var statearr_55960_55971 = state_55945;
(statearr_55960_55971[(1)] = cljs.core.first((state_55945[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55972 = state_55945;
state_55945 = G__55972;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55945){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55961 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55961[(6)] = c__2706__auto__);

return statearr_55961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55913){
var G__55914 = cljs.core.first(seq55913);
var seq55913__$1 = cljs.core.next(seq55913);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55914,seq55913__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56022 = arguments.length;
var i__5770__auto___56023 = (0);
while(true){
if((i__5770__auto___56023 < len__5769__auto___56022)){
args__5775__auto__.push((arguments[i__5770__auto___56023]));

var G__56024 = (i__5770__auto___56023 + (1));
i__5770__auto___56023 = G__56024;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56005){
var state_val_56006 = (state_56005[(1)]);
if((state_val_56006 === (1))){
var state_56005__$1 = state_56005;
var statearr_56007_56025 = state_56005__$1;
(statearr_56007_56025[(2)] = null);

(statearr_56007_56025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (2))){
var _ = (function (){var statearr_56008 = state_56005;
(statearr_56008[(4)] = cljs.core.cons((5),(state_56005[(4)])));

return statearr_56008;
})();
var inst_55981 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56005__$1 = state_56005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56005__$1,(6),inst_55981);
} else {
if((state_val_56006 === (3))){
var inst_56003 = (state_56005[(2)]);
var state_56005__$1 = state_56005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56005__$1,inst_56003);
} else {
if((state_val_56006 === (4))){
var inst_55975 = (state_56005[(2)]);
var state_56005__$1 = state_56005;
var statearr_56010_56026 = state_56005__$1;
(statearr_56010_56026[(2)] = inst_55975);

(statearr_56010_56026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (5))){
var _ = (function (){var statearr_56011 = state_56005;
(statearr_56011[(4)] = cljs.core.rest((state_56005[(4)])));

return statearr_56011;
})();
var state_56005__$1 = state_56005;
var ex56009 = (state_56005__$1[(2)]);
var statearr_56012_56027 = state_56005__$1;
(statearr_56012_56027[(5)] = ex56009);


if((ex56009 instanceof Error)){
var statearr_56013_56028 = state_56005__$1;
(statearr_56013_56028[(1)] = (4));

(statearr_56013_56028[(5)] = null);

} else {
throw ex56009;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (6))){
var inst_55983 = (state_56005[(2)]);
var inst_55984 = fluree.db.util.async.throw_err(inst_55983);
var inst_55985 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55984);
var inst_55986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55987 = [inst_55984];
var inst_55988 = (new cljs.core.PersistentVector(null,1,(5),inst_55986,inst_55987,null));
var inst_55989 = cljs.core.count(inst_55988);
var inst_55990 = ((9) + inst_55989);
var inst_55991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55992 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55994 = [inst_55984];
var inst_55995 = (new cljs.core.PersistentVector(null,1,(5),inst_55993,inst_55994,null));
var inst_55996 = [">=",inst_55995,inst_55985];
var inst_55997 = cljs.core.PersistentHashMap.fromArrays(inst_55992,inst_55996);
var inst_55998 = [inst_55997,inst_55990];
var inst_55999 = (new cljs.core.PersistentVector(null,2,(5),inst_55991,inst_55998,null));
var inst_56000 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55999);
var _ = (function (){var statearr_56014 = state_56005;
(statearr_56014[(4)] = cljs.core.rest((state_56005[(4)])));

return statearr_56014;
})();
var state_56005__$1 = (function (){var statearr_56015 = state_56005;
(statearr_56015[(7)] = inst_56000);

return statearr_56015;
})();
var statearr_56016_56029 = state_56005__$1;
(statearr_56016_56029[(2)] = inst_55985);

(statearr_56016_56029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56017 = [null,null,null,null,null,null,null,null];
(statearr_56017[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56017[(1)] = (1));

return statearr_56017;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56005){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56005);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56018){var ex__2687__auto__ = e56018;
var statearr_56019_56030 = state_56005;
(statearr_56019_56030[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56005[(4)]))){
var statearr_56020_56031 = state_56005;
(statearr_56020_56031[(1)] = cljs.core.first((state_56005[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56032 = state_56005;
state_56005 = G__56032;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56005){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56021 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56021[(6)] = c__2706__auto__);

return statearr_56021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55973){
var G__55974 = cljs.core.first(seq55973);
var seq55973__$1 = cljs.core.next(seq55973);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55974,seq55973__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56082 = arguments.length;
var i__5770__auto___56083 = (0);
while(true){
if((i__5770__auto___56083 < len__5769__auto___56082)){
args__5775__auto__.push((arguments[i__5770__auto___56083]));

var G__56084 = (i__5770__auto___56083 + (1));
i__5770__auto___56083 = G__56084;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56065){
var state_val_56066 = (state_56065[(1)]);
if((state_val_56066 === (1))){
var state_56065__$1 = state_56065;
var statearr_56067_56085 = state_56065__$1;
(statearr_56067_56085[(2)] = null);

(statearr_56067_56085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56066 === (2))){
var _ = (function (){var statearr_56068 = state_56065;
(statearr_56068[(4)] = cljs.core.cons((5),(state_56065[(4)])));

return statearr_56068;
})();
var inst_56041 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56065__$1 = state_56065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56065__$1,(6),inst_56041);
} else {
if((state_val_56066 === (3))){
var inst_56063 = (state_56065[(2)]);
var state_56065__$1 = state_56065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56065__$1,inst_56063);
} else {
if((state_val_56066 === (4))){
var inst_56035 = (state_56065[(2)]);
var state_56065__$1 = state_56065;
var statearr_56070_56086 = state_56065__$1;
(statearr_56070_56086[(2)] = inst_56035);

(statearr_56070_56086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56066 === (5))){
var _ = (function (){var statearr_56071 = state_56065;
(statearr_56071[(4)] = cljs.core.rest((state_56065[(4)])));

return statearr_56071;
})();
var state_56065__$1 = state_56065;
var ex56069 = (state_56065__$1[(2)]);
var statearr_56072_56087 = state_56065__$1;
(statearr_56072_56087[(5)] = ex56069);


if((ex56069 instanceof Error)){
var statearr_56073_56088 = state_56065__$1;
(statearr_56073_56088[(1)] = (4));

(statearr_56073_56088[(5)] = null);

} else {
throw ex56069;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56066 === (6))){
var inst_56043 = (state_56065[(2)]);
var inst_56044 = fluree.db.util.async.throw_err(inst_56043);
var inst_56045 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_56044);
var inst_56046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56047 = [inst_56044];
var inst_56048 = (new cljs.core.PersistentVector(null,1,(5),inst_56046,inst_56047,null));
var inst_56049 = cljs.core.count(inst_56048);
var inst_56050 = ((9) + inst_56049);
var inst_56051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56052 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56054 = [inst_56044];
var inst_56055 = (new cljs.core.PersistentVector(null,1,(5),inst_56053,inst_56054,null));
var inst_56056 = ["not=",inst_56055,inst_56045];
var inst_56057 = cljs.core.PersistentHashMap.fromArrays(inst_56052,inst_56056);
var inst_56058 = [inst_56057,inst_56050];
var inst_56059 = (new cljs.core.PersistentVector(null,2,(5),inst_56051,inst_56058,null));
var inst_56060 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56059);
var _ = (function (){var statearr_56074 = state_56065;
(statearr_56074[(4)] = cljs.core.rest((state_56065[(4)])));

return statearr_56074;
})();
var state_56065__$1 = (function (){var statearr_56075 = state_56065;
(statearr_56075[(7)] = inst_56060);

return statearr_56075;
})();
var statearr_56076_56089 = state_56065__$1;
(statearr_56076_56089[(2)] = inst_56045);

(statearr_56076_56089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56077 = [null,null,null,null,null,null,null,null];
(statearr_56077[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56077[(1)] = (1));

return statearr_56077;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56065){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56065);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56078){var ex__2687__auto__ = e56078;
var statearr_56079_56090 = state_56065;
(statearr_56079_56090[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56065[(4)]))){
var statearr_56080_56091 = state_56065;
(statearr_56080_56091[(1)] = cljs.core.first((state_56065[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56092 = state_56065;
state_56065 = G__56092;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56065){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56081 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56081[(6)] = c__2706__auto__);

return statearr_56081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq56033){
var G__56034 = cljs.core.first(seq56033);
var seq56033__$1 = cljs.core.next(seq56033);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56034,seq56033__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56142 = arguments.length;
var i__5770__auto___56143 = (0);
while(true){
if((i__5770__auto___56143 < len__5769__auto___56142)){
args__5775__auto__.push((arguments[i__5770__auto___56143]));

var G__56144 = (i__5770__auto___56143 + (1));
i__5770__auto___56143 = G__56144;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56125){
var state_val_56126 = (state_56125[(1)]);
if((state_val_56126 === (1))){
var state_56125__$1 = state_56125;
var statearr_56127_56145 = state_56125__$1;
(statearr_56127_56145[(2)] = null);

(statearr_56127_56145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56126 === (2))){
var _ = (function (){var statearr_56128 = state_56125;
(statearr_56128[(4)] = cljs.core.cons((5),(state_56125[(4)])));

return statearr_56128;
})();
var inst_56101 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56125__$1 = state_56125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56125__$1,(6),inst_56101);
} else {
if((state_val_56126 === (3))){
var inst_56123 = (state_56125[(2)]);
var state_56125__$1 = state_56125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56125__$1,inst_56123);
} else {
if((state_val_56126 === (4))){
var inst_56095 = (state_56125[(2)]);
var state_56125__$1 = state_56125;
var statearr_56130_56146 = state_56125__$1;
(statearr_56130_56146[(2)] = inst_56095);

(statearr_56130_56146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56126 === (5))){
var _ = (function (){var statearr_56131 = state_56125;
(statearr_56131[(4)] = cljs.core.rest((state_56125[(4)])));

return statearr_56131;
})();
var state_56125__$1 = state_56125;
var ex56129 = (state_56125__$1[(2)]);
var statearr_56132_56147 = state_56125__$1;
(statearr_56132_56147[(5)] = ex56129);


if((ex56129 instanceof Error)){
var statearr_56133_56148 = state_56125__$1;
(statearr_56133_56148[(1)] = (4));

(statearr_56133_56148[(5)] = null);

} else {
throw ex56129;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56126 === (6))){
var inst_56103 = (state_56125[(2)]);
var inst_56104 = fluree.db.util.async.throw_err(inst_56103);
var inst_56105 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_56104);
var inst_56106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56107 = [inst_56104];
var inst_56108 = (new cljs.core.PersistentVector(null,1,(5),inst_56106,inst_56107,null));
var inst_56109 = cljs.core.count(inst_56108);
var inst_56110 = ((9) + inst_56109);
var inst_56111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56112 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56114 = [inst_56104];
var inst_56115 = (new cljs.core.PersistentVector(null,1,(5),inst_56113,inst_56114,null));
var inst_56116 = ["max",inst_56115,inst_56105];
var inst_56117 = cljs.core.PersistentHashMap.fromArrays(inst_56112,inst_56116);
var inst_56118 = [inst_56117,inst_56110];
var inst_56119 = (new cljs.core.PersistentVector(null,2,(5),inst_56111,inst_56118,null));
var inst_56120 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56119);
var _ = (function (){var statearr_56134 = state_56125;
(statearr_56134[(4)] = cljs.core.rest((state_56125[(4)])));

return statearr_56134;
})();
var state_56125__$1 = (function (){var statearr_56135 = state_56125;
(statearr_56135[(7)] = inst_56120);

return statearr_56135;
})();
var statearr_56136_56149 = state_56125__$1;
(statearr_56136_56149[(2)] = inst_56105);

(statearr_56136_56149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56137 = [null,null,null,null,null,null,null,null];
(statearr_56137[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56137[(1)] = (1));

return statearr_56137;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56125){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56125);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56138){var ex__2687__auto__ = e56138;
var statearr_56139_56150 = state_56125;
(statearr_56139_56150[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56125[(4)]))){
var statearr_56140_56151 = state_56125;
(statearr_56140_56151[(1)] = cljs.core.first((state_56125[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56152 = state_56125;
state_56125 = G__56152;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56125){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56141 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56141[(6)] = c__2706__auto__);

return statearr_56141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq56093){
var G__56094 = cljs.core.first(seq56093);
var seq56093__$1 = cljs.core.next(seq56093);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56094,seq56093__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56202 = arguments.length;
var i__5770__auto___56203 = (0);
while(true){
if((i__5770__auto___56203 < len__5769__auto___56202)){
args__5775__auto__.push((arguments[i__5770__auto___56203]));

var G__56204 = (i__5770__auto___56203 + (1));
i__5770__auto___56203 = G__56204;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56185){
var state_val_56186 = (state_56185[(1)]);
if((state_val_56186 === (1))){
var state_56185__$1 = state_56185;
var statearr_56187_56205 = state_56185__$1;
(statearr_56187_56205[(2)] = null);

(statearr_56187_56205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56186 === (2))){
var _ = (function (){var statearr_56188 = state_56185;
(statearr_56188[(4)] = cljs.core.cons((5),(state_56185[(4)])));

return statearr_56188;
})();
var inst_56161 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56185__$1 = state_56185;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56185__$1,(6),inst_56161);
} else {
if((state_val_56186 === (3))){
var inst_56183 = (state_56185[(2)]);
var state_56185__$1 = state_56185;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56185__$1,inst_56183);
} else {
if((state_val_56186 === (4))){
var inst_56155 = (state_56185[(2)]);
var state_56185__$1 = state_56185;
var statearr_56190_56206 = state_56185__$1;
(statearr_56190_56206[(2)] = inst_56155);

(statearr_56190_56206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56186 === (5))){
var _ = (function (){var statearr_56191 = state_56185;
(statearr_56191[(4)] = cljs.core.rest((state_56185[(4)])));

return statearr_56191;
})();
var state_56185__$1 = state_56185;
var ex56189 = (state_56185__$1[(2)]);
var statearr_56192_56207 = state_56185__$1;
(statearr_56192_56207[(5)] = ex56189);


if((ex56189 instanceof Error)){
var statearr_56193_56208 = state_56185__$1;
(statearr_56193_56208[(1)] = (4));

(statearr_56193_56208[(5)] = null);

} else {
throw ex56189;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56186 === (6))){
var inst_56163 = (state_56185[(2)]);
var inst_56164 = fluree.db.util.async.throw_err(inst_56163);
var inst_56165 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_56164);
var inst_56166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56167 = [inst_56164];
var inst_56168 = (new cljs.core.PersistentVector(null,1,(5),inst_56166,inst_56167,null));
var inst_56169 = cljs.core.count(inst_56168);
var inst_56170 = ((9) + inst_56169);
var inst_56171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56172 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56174 = [inst_56164];
var inst_56175 = (new cljs.core.PersistentVector(null,1,(5),inst_56173,inst_56174,null));
var inst_56176 = ["min",inst_56175,inst_56165];
var inst_56177 = cljs.core.PersistentHashMap.fromArrays(inst_56172,inst_56176);
var inst_56178 = [inst_56177,inst_56170];
var inst_56179 = (new cljs.core.PersistentVector(null,2,(5),inst_56171,inst_56178,null));
var inst_56180 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56179);
var _ = (function (){var statearr_56194 = state_56185;
(statearr_56194[(4)] = cljs.core.rest((state_56185[(4)])));

return statearr_56194;
})();
var state_56185__$1 = (function (){var statearr_56195 = state_56185;
(statearr_56195[(7)] = inst_56180);

return statearr_56195;
})();
var statearr_56196_56209 = state_56185__$1;
(statearr_56196_56209[(2)] = inst_56165);

(statearr_56196_56209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56197 = [null,null,null,null,null,null,null,null];
(statearr_56197[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56197[(1)] = (1));

return statearr_56197;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56185){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56185);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56198){var ex__2687__auto__ = e56198;
var statearr_56199_56210 = state_56185;
(statearr_56199_56210[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56185[(4)]))){
var statearr_56200_56211 = state_56185;
(statearr_56200_56211[(1)] = cljs.core.first((state_56185[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56212 = state_56185;
state_56185 = G__56212;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56185){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56201 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56201[(6)] = c__2706__auto__);

return statearr_56201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq56153){
var G__56154 = cljs.core.first(seq56153);
var seq56153__$1 = cljs.core.next(seq56153);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56154,seq56153__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__56214 = arguments.length;
switch (G__56214) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56259){
var state_val_56260 = (state_56259[(1)]);
if((state_val_56260 === (7))){
var state_56259__$1 = state_56259;
var statearr_56261_56398 = state_56259__$1;
(statearr_56261_56398[(2)] = query_map);

(statearr_56261_56398[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (1))){
var state_56259__$1 = state_56259;
var statearr_56262_56399 = state_56259__$1;
(statearr_56262_56399[(2)] = null);

(statearr_56262_56399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (4))){
var inst_56215 = (state_56259[(2)]);
var state_56259__$1 = state_56259;
var statearr_56263_56400 = state_56259__$1;
(statearr_56263_56400[(2)] = inst_56215);

(statearr_56263_56400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (13))){
var inst_56237 = (state_56259[(7)]);
var inst_56241 = (state_56259[(2)]);
var inst_56242 = fluree.db.util.async.throw_err(inst_56241);
var inst_56243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56242,(0),null);
var inst_56244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56242,(1),null);
var inst_56245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56246 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56248 = [inst_56237];
var inst_56249 = (new cljs.core.PersistentVector(null,1,(5),inst_56247,inst_56248,null));
var inst_56250 = ["query",inst_56249,inst_56243];
var inst_56251 = cljs.core.PersistentHashMap.fromArrays(inst_56246,inst_56250);
var inst_56252 = [inst_56251,inst_56244];
var inst_56253 = (new cljs.core.PersistentVector(null,2,(5),inst_56245,inst_56252,null));
var inst_56254 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56253);
var _ = (function (){var statearr_56264 = state_56259;
(statearr_56264[(4)] = cljs.core.rest((state_56259[(4)])));

return statearr_56264;
})();
var state_56259__$1 = (function (){var statearr_56265 = state_56259;
(statearr_56265[(8)] = inst_56254);

return statearr_56265;
})();
var statearr_56266_56401 = state_56259__$1;
(statearr_56266_56401[(2)] = inst_56243);

(statearr_56266_56401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (6))){
var state_56259__$1 = state_56259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56259__$1,(9),query_map);
} else {
if((state_val_56260 === (3))){
var inst_56257 = (state_56259[(2)]);
var state_56259__$1 = state_56259;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56259__$1,inst_56257);
} else {
if((state_val_56260 === (12))){
var inst_56237 = (state_56259[(7)]);
var inst_56237__$1 = (state_56259[(2)]);
var inst_56238 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56239 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56238,inst_56237__$1);
var state_56259__$1 = (function (){var statearr_56267 = state_56259;
(statearr_56267[(7)] = inst_56237__$1);

return statearr_56267;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56259__$1,(13),inst_56239);
} else {
if((state_val_56260 === (2))){
var _ = (function (){var statearr_56268 = state_56259;
(statearr_56268[(4)] = cljs.core.cons((5),(state_56259[(4)])));

return statearr_56268;
})();
var inst_56224 = fluree.db.util.async.channel_QMARK_(query_map);
var state_56259__$1 = state_56259;
if(inst_56224){
var statearr_56269_56402 = state_56259__$1;
(statearr_56269_56402[(1)] = (6));

} else {
var statearr_56270_56403 = state_56259__$1;
(statearr_56270_56403[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (11))){
var inst_56231 = (state_56259[(9)]);
var state_56259__$1 = state_56259;
var statearr_56272_56404 = state_56259__$1;
(statearr_56272_56404[(2)] = inst_56231);

(statearr_56272_56404[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (9))){
var inst_56227 = (state_56259[(2)]);
var inst_56228 = fluree.db.util.async.throw_err(inst_56227);
var state_56259__$1 = state_56259;
var statearr_56273_56405 = state_56259__$1;
(statearr_56273_56405[(2)] = inst_56228);

(statearr_56273_56405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (5))){
var _ = (function (){var statearr_56274 = state_56259;
(statearr_56274[(4)] = cljs.core.rest((state_56259[(4)])));

return statearr_56274;
})();
var state_56259__$1 = state_56259;
var ex56271 = (state_56259__$1[(2)]);
var statearr_56275_56406 = state_56259__$1;
(statearr_56275_56406[(5)] = ex56271);


if((ex56271 instanceof Error)){
var statearr_56276_56407 = state_56259__$1;
(statearr_56276_56407[(1)] = (4));

(statearr_56276_56407[(5)] = null);

} else {
throw ex56271;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (10))){
var inst_56231 = (state_56259[(9)]);
var inst_56234 = fluree.db.util.json.parse(inst_56231);
var state_56259__$1 = state_56259;
var statearr_56277_56408 = state_56259__$1;
(statearr_56277_56408[(2)] = inst_56234);

(statearr_56277_56408[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (8))){
var inst_56231 = (state_56259[(9)]);
var inst_56231__$1 = (state_56259[(2)]);
var inst_56232 = typeof inst_56231__$1 === 'string';
var state_56259__$1 = (function (){var statearr_56278 = state_56259;
(statearr_56278[(9)] = inst_56231__$1);

return statearr_56278;
})();
if(cljs.core.truth_(inst_56232)){
var statearr_56279_56409 = state_56259__$1;
(statearr_56279_56409[(1)] = (10));

} else {
var statearr_56280_56410 = state_56259__$1;
(statearr_56280_56410[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56281 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56281[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56281[(1)] = (1));

return statearr_56281;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56259){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56259);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56282){var ex__2687__auto__ = e56282;
var statearr_56283_56411 = state_56259;
(statearr_56283_56411[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56259[(4)]))){
var statearr_56284_56412 = state_56259;
(statearr_56284_56412[(1)] = cljs.core.first((state_56259[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56413 = state_56259;
state_56259 = G__56413;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56259){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56285 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56285[(6)] = c__2706__auto__);

return statearr_56285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56356){
var state_val_56357 = (state_56356[(1)]);
if((state_val_56357 === (7))){
var state_56356__$1 = state_56356;
var statearr_56358_56414 = state_56356__$1;
(statearr_56358_56414[(2)] = select);

(statearr_56358_56414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (20))){
var inst_56326 = (state_56356[(2)]);
var inst_56327 = fluree.db.util.async.channel_QMARK_(limit);
var state_56356__$1 = (function (){var statearr_56359 = state_56356;
(statearr_56359[(7)] = inst_56326);

return statearr_56359;
})();
if(inst_56327){
var statearr_56360_56415 = state_56356__$1;
(statearr_56360_56415[(1)] = (22));

} else {
var statearr_56361_56416 = state_56356__$1;
(statearr_56361_56416[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (1))){
var state_56356__$1 = state_56356;
var statearr_56362_56417 = state_56356__$1;
(statearr_56362_56417[(2)] = null);

(statearr_56362_56417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (24))){
var inst_56302 = (state_56356[(8)]);
var inst_56318 = (state_56356[(9)]);
var inst_56310 = (state_56356[(10)]);
var inst_56326 = (state_56356[(7)]);
var inst_56334 = (state_56356[(2)]);
var inst_56335 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56336 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_56335,inst_56302,inst_56310,inst_56318,inst_56326,inst_56334);
var state_56356__$1 = state_56356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56356__$1,(26),inst_56336);
} else {
if((state_val_56357 === (4))){
var inst_56286 = (state_56356[(2)]);
var state_56356__$1 = state_56356;
var statearr_56363_56418 = state_56356__$1;
(statearr_56363_56418[(2)] = inst_56286);

(statearr_56363_56418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (15))){
var state_56356__$1 = state_56356;
var statearr_56364_56419 = state_56356__$1;
(statearr_56364_56419[(2)] = where);

(statearr_56364_56419[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (21))){
var inst_56322 = (state_56356[(2)]);
var inst_56323 = fluree.db.util.async.throw_err(inst_56322);
var state_56356__$1 = state_56356;
var statearr_56365_56420 = state_56356__$1;
(statearr_56365_56420[(2)] = inst_56323);

(statearr_56365_56420[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (13))){
var inst_56306 = (state_56356[(2)]);
var inst_56307 = fluree.db.util.async.throw_err(inst_56306);
var state_56356__$1 = state_56356;
var statearr_56366_56421 = state_56356__$1;
(statearr_56366_56421[(2)] = inst_56307);

(statearr_56366_56421[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (22))){
var state_56356__$1 = state_56356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56356__$1,(25),limit);
} else {
if((state_val_56357 === (6))){
var state_56356__$1 = state_56356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56356__$1,(9),select);
} else {
if((state_val_56357 === (25))){
var inst_56330 = (state_56356[(2)]);
var inst_56331 = fluree.db.util.async.throw_err(inst_56330);
var state_56356__$1 = state_56356;
var statearr_56367_56422 = state_56356__$1;
(statearr_56367_56422[(2)] = inst_56331);

(statearr_56367_56422[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (17))){
var inst_56314 = (state_56356[(2)]);
var inst_56315 = fluree.db.util.async.throw_err(inst_56314);
var state_56356__$1 = state_56356;
var statearr_56368_56423 = state_56356__$1;
(statearr_56368_56423[(2)] = inst_56315);

(statearr_56368_56423[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (3))){
var inst_56354 = (state_56356[(2)]);
var state_56356__$1 = state_56356;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56356__$1,inst_56354);
} else {
if((state_val_56357 === (12))){
var inst_56310 = (state_56356[(2)]);
var inst_56311 = fluree.db.util.async.channel_QMARK_(where);
var state_56356__$1 = (function (){var statearr_56369 = state_56356;
(statearr_56369[(10)] = inst_56310);

return statearr_56369;
})();
if(inst_56311){
var statearr_56370_56424 = state_56356__$1;
(statearr_56370_56424[(1)] = (14));

} else {
var statearr_56371_56425 = state_56356__$1;
(statearr_56371_56425[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (2))){
var _ = (function (){var statearr_56372 = state_56356;
(statearr_56372[(4)] = cljs.core.cons((5),(state_56356[(4)])));

return statearr_56372;
})();
var inst_56295 = fluree.db.util.async.channel_QMARK_(select);
var state_56356__$1 = state_56356;
if(inst_56295){
var statearr_56373_56426 = state_56356__$1;
(statearr_56373_56426[(1)] = (6));

} else {
var statearr_56374_56427 = state_56356__$1;
(statearr_56374_56427[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (23))){
var state_56356__$1 = state_56356;
var statearr_56375_56428 = state_56356__$1;
(statearr_56375_56428[(2)] = limit);

(statearr_56375_56428[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (19))){
var state_56356__$1 = state_56356;
var statearr_56376_56429 = state_56356__$1;
(statearr_56376_56429[(2)] = block);

(statearr_56376_56429[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (11))){
var state_56356__$1 = state_56356;
var statearr_56378_56430 = state_56356__$1;
(statearr_56378_56430[(2)] = from);

(statearr_56378_56430[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (9))){
var inst_56298 = (state_56356[(2)]);
var inst_56299 = fluree.db.util.async.throw_err(inst_56298);
var state_56356__$1 = state_56356;
var statearr_56379_56431 = state_56356__$1;
(statearr_56379_56431[(2)] = inst_56299);

(statearr_56379_56431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (5))){
var _ = (function (){var statearr_56380 = state_56356;
(statearr_56380[(4)] = cljs.core.rest((state_56356[(4)])));

return statearr_56380;
})();
var state_56356__$1 = state_56356;
var ex56377 = (state_56356__$1[(2)]);
var statearr_56381_56432 = state_56356__$1;
(statearr_56381_56432[(5)] = ex56377);


if((ex56377 instanceof Error)){
var statearr_56382_56433 = state_56356__$1;
(statearr_56382_56433[(1)] = (4));

(statearr_56382_56433[(5)] = null);

} else {
throw ex56377;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (14))){
var state_56356__$1 = state_56356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56356__$1,(17),where);
} else {
if((state_val_56357 === (26))){
var inst_56302 = (state_56356[(8)]);
var inst_56318 = (state_56356[(9)]);
var inst_56310 = (state_56356[(10)]);
var inst_56326 = (state_56356[(7)]);
var inst_56338 = (state_56356[(2)]);
var inst_56339 = fluree.db.util.async.throw_err(inst_56338);
var inst_56340 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56339,(0),null);
var inst_56341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56339,(1),null);
var inst_56342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56343 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56345 = [inst_56302,inst_56310,inst_56318,inst_56326];
var inst_56346 = (new cljs.core.PersistentVector(null,4,(5),inst_56344,inst_56345,null));
var inst_56347 = ["query",inst_56346,inst_56340];
var inst_56348 = cljs.core.PersistentHashMap.fromArrays(inst_56343,inst_56347);
var inst_56349 = [inst_56348,inst_56341];
var inst_56350 = (new cljs.core.PersistentVector(null,2,(5),inst_56342,inst_56349,null));
var inst_56351 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56350);
var _ = (function (){var statearr_56383 = state_56356;
(statearr_56383[(4)] = cljs.core.rest((state_56356[(4)])));

return statearr_56383;
})();
var state_56356__$1 = (function (){var statearr_56384 = state_56356;
(statearr_56384[(11)] = inst_56351);

return statearr_56384;
})();
var statearr_56385_56434 = state_56356__$1;
(statearr_56385_56434[(2)] = inst_56340);

(statearr_56385_56434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (16))){
var inst_56318 = (state_56356[(2)]);
var inst_56319 = fluree.db.util.async.channel_QMARK_(block);
var state_56356__$1 = (function (){var statearr_56386 = state_56356;
(statearr_56386[(9)] = inst_56318);

return statearr_56386;
})();
if(inst_56319){
var statearr_56387_56435 = state_56356__$1;
(statearr_56387_56435[(1)] = (18));

} else {
var statearr_56388_56436 = state_56356__$1;
(statearr_56388_56436[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56357 === (10))){
var state_56356__$1 = state_56356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56356__$1,(13),from);
} else {
if((state_val_56357 === (18))){
var state_56356__$1 = state_56356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56356__$1,(21),block);
} else {
if((state_val_56357 === (8))){
var inst_56302 = (state_56356[(2)]);
var inst_56303 = fluree.db.util.async.channel_QMARK_(from);
var state_56356__$1 = (function (){var statearr_56389 = state_56356;
(statearr_56389[(8)] = inst_56302);

return statearr_56389;
})();
if(inst_56303){
var statearr_56390_56437 = state_56356__$1;
(statearr_56390_56437[(1)] = (10));

} else {
var statearr_56391_56438 = state_56356__$1;
(statearr_56391_56438[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56392 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56392[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56392[(1)] = (1));

return statearr_56392;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56356){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56356);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56393){var ex__2687__auto__ = e56393;
var statearr_56394_56439 = state_56356;
(statearr_56394_56439[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56356[(4)]))){
var statearr_56395_56440 = state_56356;
(statearr_56395_56440[(1)] = cljs.core.first((state_56356[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56441 = state_56356;
state_56356 = G__56441;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56356){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56396 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56396[(6)] = c__2706__auto__);

return statearr_56396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56497){
var state_val_56498 = (state_56497[(1)]);
if((state_val_56498 === (7))){
var state_56497__$1 = state_56497;
var statearr_56499_56530 = state_56497__$1;
(statearr_56499_56530[(2)] = startSubject);

(statearr_56499_56530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (1))){
var state_56497__$1 = state_56497;
var statearr_56500_56531 = state_56497__$1;
(statearr_56500_56531[(2)] = null);

(statearr_56500_56531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (4))){
var inst_56442 = (state_56497[(2)]);
var state_56497__$1 = state_56497;
var statearr_56501_56532 = state_56497__$1;
(statearr_56501_56532[(2)] = inst_56442);

(statearr_56501_56532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (15))){
var inst_56474 = (state_56497[(2)]);
var inst_56475 = fluree.db.util.async.throw_err(inst_56474);
var inst_56476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56475,(0),null);
var inst_56477 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56475,(1),null);
var inst_56478 = cljs.core.empty_QMARK_(inst_56476);
var state_56497__$1 = (function (){var statearr_56502 = state_56497;
(statearr_56502[(7)] = inst_56477);

return statearr_56502;
})();
if(inst_56478){
var statearr_56503_56533 = state_56497__$1;
(statearr_56503_56533[(1)] = (16));

} else {
var statearr_56504_56534 = state_56497__$1;
(statearr_56504_56534[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (13))){
var inst_56462 = (state_56497[(8)]);
var inst_56470 = (state_56497[(9)]);
var inst_56458 = (state_56497[(10)]);
var inst_56470__$1 = (state_56497[(2)]);
var inst_56471 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56472 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_56471,inst_56458,inst_56462,inst_56470__$1);
var state_56497__$1 = (function (){var statearr_56505 = state_56497;
(statearr_56505[(9)] = inst_56470__$1);

return statearr_56505;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56497__$1,(15),inst_56472);
} else {
if((state_val_56498 === (6))){
var state_56497__$1 = state_56497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56497__$1,(9),startSubject);
} else {
if((state_val_56498 === (17))){
var state_56497__$1 = state_56497;
var statearr_56506_56535 = state_56497__$1;
(statearr_56506_56535[(2)] = true);

(statearr_56506_56535[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (3))){
var inst_56495 = (state_56497[(2)]);
var state_56497__$1 = state_56497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56497__$1,inst_56495);
} else {
if((state_val_56498 === (12))){
var state_56497__$1 = state_56497;
var statearr_56507_56536 = state_56497__$1;
(statearr_56507_56536[(2)] = endSubject);

(statearr_56507_56536[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (2))){
var _ = (function (){var statearr_56508 = state_56497;
(statearr_56508[(4)] = cljs.core.cons((5),(state_56497[(4)])));

return statearr_56508;
})();
var inst_56451 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_56497__$1 = state_56497;
if(inst_56451){
var statearr_56509_56537 = state_56497__$1;
(statearr_56509_56537[(1)] = (6));

} else {
var statearr_56510_56538 = state_56497__$1;
(statearr_56510_56538[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (11))){
var state_56497__$1 = state_56497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56497__$1,(14),endSubject);
} else {
if((state_val_56498 === (9))){
var inst_56454 = (state_56497[(2)]);
var inst_56455 = fluree.db.util.async.throw_err(inst_56454);
var state_56497__$1 = state_56497;
var statearr_56512_56539 = state_56497__$1;
(statearr_56512_56539[(2)] = inst_56455);

(statearr_56512_56539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (5))){
var _ = (function (){var statearr_56513 = state_56497;
(statearr_56513[(4)] = cljs.core.rest((state_56497[(4)])));

return statearr_56513;
})();
var state_56497__$1 = state_56497;
var ex56511 = (state_56497__$1[(2)]);
var statearr_56514_56540 = state_56497__$1;
(statearr_56514_56540[(5)] = ex56511);


if((ex56511 instanceof Error)){
var statearr_56515_56541 = state_56497__$1;
(statearr_56515_56541[(1)] = (4));

(statearr_56515_56541[(5)] = null);

} else {
throw ex56511;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (14))){
var inst_56466 = (state_56497[(2)]);
var inst_56467 = fluree.db.util.async.throw_err(inst_56466);
var state_56497__$1 = state_56497;
var statearr_56516_56542 = state_56497__$1;
(statearr_56516_56542[(2)] = inst_56467);

(statearr_56516_56542[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (16))){
var state_56497__$1 = state_56497;
var statearr_56517_56543 = state_56497__$1;
(statearr_56517_56543[(2)] = false);

(statearr_56517_56543[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (10))){
var inst_56461 = (state_56497[(2)]);
var inst_56462 = fluree.db.util.async.throw_err(inst_56461);
var inst_56463 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_56497__$1 = (function (){var statearr_56518 = state_56497;
(statearr_56518[(8)] = inst_56462);

return statearr_56518;
})();
if(inst_56463){
var statearr_56519_56544 = state_56497__$1;
(statearr_56519_56544[(1)] = (11));

} else {
var statearr_56520_56545 = state_56497__$1;
(statearr_56520_56545[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (18))){
var inst_56462 = (state_56497[(8)]);
var inst_56470 = (state_56497[(9)]);
var inst_56477 = (state_56497[(7)]);
var inst_56458 = (state_56497[(10)]);
var inst_56482 = (state_56497[(2)]);
var inst_56483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56484 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56486 = [inst_56458,inst_56462,inst_56470];
var inst_56487 = (new cljs.core.PersistentVector(null,3,(5),inst_56485,inst_56486,null));
var inst_56488 = ["relationship?",inst_56487,inst_56482];
var inst_56489 = cljs.core.PersistentHashMap.fromArrays(inst_56484,inst_56488);
var inst_56490 = [inst_56489,inst_56477];
var inst_56491 = (new cljs.core.PersistentVector(null,2,(5),inst_56483,inst_56490,null));
var inst_56492 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56491);
var _ = (function (){var statearr_56521 = state_56497;
(statearr_56521[(4)] = cljs.core.rest((state_56497[(4)])));

return statearr_56521;
})();
var state_56497__$1 = (function (){var statearr_56522 = state_56497;
(statearr_56522[(11)] = inst_56492);

return statearr_56522;
})();
var statearr_56523_56546 = state_56497__$1;
(statearr_56523_56546[(2)] = inst_56482);

(statearr_56523_56546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56498 === (8))){
var inst_56458 = (state_56497[(2)]);
var inst_56459 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_56497__$1 = (function (){var statearr_56524 = state_56497;
(statearr_56524[(10)] = inst_56458);

return statearr_56524;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56497__$1,(10),inst_56459);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_56525 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56525[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__);

(statearr_56525[(1)] = (1));

return statearr_56525;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1 = (function (state_56497){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56497);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56526){var ex__2687__auto__ = e56526;
var statearr_56527_56547 = state_56497;
(statearr_56527_56547[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56497[(4)]))){
var statearr_56528_56548 = state_56497;
(statearr_56528_56548[(1)] = cljs.core.first((state_56497[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56549 = state_56497;
state_56497 = G__56549;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__ = function(state_56497){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1.call(this,state_56497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56529 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56529[(6)] = c__2706__auto__);

return statearr_56529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56586){
var state_val_56587 = (state_56586[(1)]);
if((state_val_56587 === (7))){
var state_56586__$1 = state_56586;
var statearr_56588_56608 = state_56586__$1;
(statearr_56588_56608[(2)] = pred_name);

(statearr_56588_56608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56587 === (1))){
var state_56586__$1 = state_56586;
var statearr_56589_56609 = state_56586__$1;
(statearr_56589_56609[(2)] = null);

(statearr_56589_56609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56587 === (4))){
var inst_56550 = (state_56586[(2)]);
var state_56586__$1 = state_56586;
var statearr_56590_56610 = state_56586__$1;
(statearr_56590_56610[(2)] = inst_56550);

(statearr_56590_56610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56587 === (6))){
var state_56586__$1 = state_56586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56586__$1,(9),pred_name);
} else {
if((state_val_56587 === (3))){
var inst_56584 = (state_56586[(2)]);
var state_56586__$1 = state_56586;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56586__$1,inst_56584);
} else {
if((state_val_56587 === (2))){
var _ = (function (){var statearr_56592 = state_56586;
(statearr_56592[(4)] = cljs.core.cons((5),(state_56586[(4)])));

return statearr_56592;
})();
var inst_56559 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_56586__$1 = state_56586;
if(inst_56559){
var statearr_56593_56611 = state_56586__$1;
(statearr_56593_56611[(1)] = (6));

} else {
var statearr_56594_56612 = state_56586__$1;
(statearr_56594_56612[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56587 === (9))){
var inst_56562 = (state_56586[(2)]);
var inst_56563 = fluree.db.util.async.throw_err(inst_56562);
var state_56586__$1 = state_56586;
var statearr_56595_56613 = state_56586__$1;
(statearr_56595_56613[(2)] = inst_56563);

(statearr_56595_56613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56587 === (5))){
var _ = (function (){var statearr_56596 = state_56586;
(statearr_56596[(4)] = cljs.core.rest((state_56586[(4)])));

return statearr_56596;
})();
var state_56586__$1 = state_56586;
var ex56591 = (state_56586__$1[(2)]);
var statearr_56597_56614 = state_56586__$1;
(statearr_56597_56614[(5)] = ex56591);


if((ex56591 instanceof Error)){
var statearr_56598_56615 = state_56586__$1;
(statearr_56598_56615[(1)] = (4));

(statearr_56598_56615[(5)] = null);

} else {
throw ex56591;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56587 === (10))){
var inst_56566 = (state_56586[(7)]);
var inst_56570 = (state_56586[(2)]);
var inst_56571 = fluree.db.util.async.throw_err(inst_56570);
var inst_56572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56571,(0),null);
var inst_56573 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56571,(1),null);
var inst_56574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56575 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56576 = ["max-pred-val",inst_56566,inst_56572];
var inst_56577 = cljs.core.PersistentHashMap.fromArrays(inst_56575,inst_56576);
var inst_56578 = (inst_56573 + (10));
var inst_56579 = [inst_56577,inst_56578];
var inst_56580 = (new cljs.core.PersistentVector(null,2,(5),inst_56574,inst_56579,null));
var inst_56581 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56580);
var _ = (function (){var statearr_56599 = state_56586;
(statearr_56599[(4)] = cljs.core.rest((state_56586[(4)])));

return statearr_56599;
})();
var state_56586__$1 = (function (){var statearr_56600 = state_56586;
(statearr_56600[(8)] = inst_56581);

return statearr_56600;
})();
var statearr_56601_56616 = state_56586__$1;
(statearr_56601_56616[(2)] = inst_56572);

(statearr_56601_56616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56587 === (8))){
var inst_56566 = (state_56586[(7)]);
var inst_56566__$1 = (state_56586[(2)]);
var inst_56567 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56568 = fluree.db.dbfunctions.internal.max_pred_val(inst_56567,inst_56566__$1,null);
var state_56586__$1 = (function (){var statearr_56602 = state_56586;
(statearr_56602[(7)] = inst_56566__$1);

return statearr_56602;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56586__$1,(10),inst_56568);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0 = (function (){
var statearr_56603 = [null,null,null,null,null,null,null,null,null];
(statearr_56603[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__);

(statearr_56603[(1)] = (1));

return statearr_56603;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1 = (function (state_56586){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56586);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56604){var ex__2687__auto__ = e56604;
var statearr_56605_56617 = state_56586;
(statearr_56605_56617[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56586[(4)]))){
var statearr_56606_56618 = state_56586;
(statearr_56606_56618[(1)] = cljs.core.first((state_56586[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56619 = state_56586;
state_56586 = G__56619;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__ = function(state_56586){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1.call(this,state_56586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56607 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56607[(6)] = c__2706__auto__);

return statearr_56607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56646){
var state_val_56647 = (state_56646[(1)]);
if((state_val_56647 === (7))){
var state_56646__$1 = state_56646;
var statearr_56648_56667 = state_56646__$1;
(statearr_56648_56667[(2)] = n);

(statearr_56648_56667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56647 === (1))){
var state_56646__$1 = state_56646;
var statearr_56649_56668 = state_56646__$1;
(statearr_56649_56668[(2)] = null);

(statearr_56649_56668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56647 === (4))){
var inst_56620 = (state_56646[(2)]);
var state_56646__$1 = state_56646;
var statearr_56650_56669 = state_56646__$1;
(statearr_56650_56669[(2)] = inst_56620);

(statearr_56650_56669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56647 === (6))){
var state_56646__$1 = state_56646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56646__$1,(9),n);
} else {
if((state_val_56647 === (3))){
var inst_56644 = (state_56646[(2)]);
var state_56646__$1 = state_56646;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56646__$1,inst_56644);
} else {
if((state_val_56647 === (2))){
var _ = (function (){var statearr_56652 = state_56646;
(statearr_56652[(4)] = cljs.core.cons((5),(state_56646[(4)])));

return statearr_56652;
})();
var inst_56626 = fluree.db.util.async.channel_QMARK_(n);
var state_56646__$1 = state_56646;
if(inst_56626){
var statearr_56653_56670 = state_56646__$1;
(statearr_56653_56670[(1)] = (6));

} else {
var statearr_56654_56671 = state_56646__$1;
(statearr_56654_56671[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56647 === (9))){
var inst_56629 = (state_56646[(2)]);
var inst_56630 = fluree.db.util.async.throw_err(inst_56629);
var state_56646__$1 = state_56646;
var statearr_56655_56672 = state_56646__$1;
(statearr_56655_56672[(2)] = inst_56630);

(statearr_56655_56672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56647 === (5))){
var _ = (function (){var statearr_56656 = state_56646;
(statearr_56656[(4)] = cljs.core.rest((state_56646[(4)])));

return statearr_56656;
})();
var state_56646__$1 = state_56646;
var ex56651 = (state_56646__$1[(2)]);
var statearr_56657_56673 = state_56646__$1;
(statearr_56657_56673[(5)] = ex56651);


if((ex56651 instanceof Error)){
var statearr_56658_56674 = state_56646__$1;
(statearr_56658_56674[(1)] = (4));

(statearr_56658_56674[(5)] = null);

} else {
throw ex56651;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56647 === (8))){
var inst_56633 = (state_56646[(2)]);
var inst_56634 = fluree.db.dbfunctions.internal.inc(inst_56633);
var inst_56635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56636 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56637 = ["inc",inst_56633,inst_56634];
var inst_56638 = cljs.core.PersistentHashMap.fromArrays(inst_56636,inst_56637);
var inst_56639 = [inst_56638,(10)];
var inst_56640 = (new cljs.core.PersistentVector(null,2,(5),inst_56635,inst_56639,null));
var inst_56641 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56640);
var _ = (function (){var statearr_56659 = state_56646;
(statearr_56659[(4)] = cljs.core.rest((state_56646[(4)])));

return statearr_56659;
})();
var state_56646__$1 = (function (){var statearr_56660 = state_56646;
(statearr_56660[(7)] = inst_56641);

return statearr_56660;
})();
var statearr_56661_56675 = state_56646__$1;
(statearr_56661_56675[(2)] = inst_56634);

(statearr_56661_56675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0 = (function (){
var statearr_56662 = [null,null,null,null,null,null,null,null];
(statearr_56662[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__);

(statearr_56662[(1)] = (1));

return statearr_56662;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1 = (function (state_56646){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56646);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56663){var ex__2687__auto__ = e56663;
var statearr_56664_56676 = state_56646;
(statearr_56664_56676[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56646[(4)]))){
var statearr_56665_56677 = state_56646;
(statearr_56665_56677[(1)] = cljs.core.first((state_56646[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56678 = state_56646;
state_56646 = G__56678;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__ = function(state_56646){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1.call(this,state_56646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56666 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56666[(6)] = c__2706__auto__);

return statearr_56666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56705){
var state_val_56706 = (state_56705[(1)]);
if((state_val_56706 === (7))){
var state_56705__$1 = state_56705;
var statearr_56707_56726 = state_56705__$1;
(statearr_56707_56726[(2)] = n);

(statearr_56707_56726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56706 === (1))){
var state_56705__$1 = state_56705;
var statearr_56708_56727 = state_56705__$1;
(statearr_56708_56727[(2)] = null);

(statearr_56708_56727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56706 === (4))){
var inst_56679 = (state_56705[(2)]);
var state_56705__$1 = state_56705;
var statearr_56709_56728 = state_56705__$1;
(statearr_56709_56728[(2)] = inst_56679);

(statearr_56709_56728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56706 === (6))){
var state_56705__$1 = state_56705;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56705__$1,(9),n);
} else {
if((state_val_56706 === (3))){
var inst_56703 = (state_56705[(2)]);
var state_56705__$1 = state_56705;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56705__$1,inst_56703);
} else {
if((state_val_56706 === (2))){
var _ = (function (){var statearr_56711 = state_56705;
(statearr_56711[(4)] = cljs.core.cons((5),(state_56705[(4)])));

return statearr_56711;
})();
var inst_56685 = fluree.db.util.async.channel_QMARK_(n);
var state_56705__$1 = state_56705;
if(inst_56685){
var statearr_56712_56729 = state_56705__$1;
(statearr_56712_56729[(1)] = (6));

} else {
var statearr_56713_56730 = state_56705__$1;
(statearr_56713_56730[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56706 === (9))){
var inst_56688 = (state_56705[(2)]);
var inst_56689 = fluree.db.util.async.throw_err(inst_56688);
var state_56705__$1 = state_56705;
var statearr_56714_56731 = state_56705__$1;
(statearr_56714_56731[(2)] = inst_56689);

(statearr_56714_56731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56706 === (5))){
var _ = (function (){var statearr_56715 = state_56705;
(statearr_56715[(4)] = cljs.core.rest((state_56705[(4)])));

return statearr_56715;
})();
var state_56705__$1 = state_56705;
var ex56710 = (state_56705__$1[(2)]);
var statearr_56716_56732 = state_56705__$1;
(statearr_56716_56732[(5)] = ex56710);


if((ex56710 instanceof Error)){
var statearr_56717_56733 = state_56705__$1;
(statearr_56717_56733[(1)] = (4));

(statearr_56717_56733[(5)] = null);

} else {
throw ex56710;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56706 === (8))){
var inst_56692 = (state_56705[(2)]);
var inst_56693 = fluree.db.dbfunctions.internal.dec(inst_56692);
var inst_56694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56695 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56696 = ["dec",inst_56692,inst_56693];
var inst_56697 = cljs.core.PersistentHashMap.fromArrays(inst_56695,inst_56696);
var inst_56698 = [inst_56697,(10)];
var inst_56699 = (new cljs.core.PersistentVector(null,2,(5),inst_56694,inst_56698,null));
var inst_56700 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56699);
var _ = (function (){var statearr_56718 = state_56705;
(statearr_56718[(4)] = cljs.core.rest((state_56705[(4)])));

return statearr_56718;
})();
var state_56705__$1 = (function (){var statearr_56719 = state_56705;
(statearr_56719[(7)] = inst_56700);

return statearr_56719;
})();
var statearr_56720_56734 = state_56705__$1;
(statearr_56720_56734[(2)] = inst_56693);

(statearr_56720_56734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0 = (function (){
var statearr_56721 = [null,null,null,null,null,null,null,null];
(statearr_56721[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__);

(statearr_56721[(1)] = (1));

return statearr_56721;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1 = (function (state_56705){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56705);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56722){var ex__2687__auto__ = e56722;
var statearr_56723_56735 = state_56705;
(statearr_56723_56735[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56705[(4)]))){
var statearr_56724_56736 = state_56705;
(statearr_56724_56736[(1)] = cljs.core.first((state_56705[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56737 = state_56705;
state_56705 = G__56737;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__ = function(state_56705){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1.call(this,state_56705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56725 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56725[(6)] = c__2706__auto__);

return statearr_56725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56787 = arguments.length;
var i__5770__auto___56788 = (0);
while(true){
if((i__5770__auto___56788 < len__5769__auto___56787)){
args__5775__auto__.push((arguments[i__5770__auto___56788]));

var G__56789 = (i__5770__auto___56788 + (1));
i__5770__auto___56788 = G__56789;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56770){
var state_val_56771 = (state_56770[(1)]);
if((state_val_56771 === (1))){
var state_56770__$1 = state_56770;
var statearr_56772_56790 = state_56770__$1;
(statearr_56772_56790[(2)] = null);

(statearr_56772_56790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56771 === (2))){
var _ = (function (){var statearr_56773 = state_56770;
(statearr_56773[(4)] = cljs.core.cons((5),(state_56770[(4)])));

return statearr_56773;
})();
var inst_56746 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56770__$1 = state_56770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56770__$1,(6),inst_56746);
} else {
if((state_val_56771 === (3))){
var inst_56768 = (state_56770[(2)]);
var state_56770__$1 = state_56770;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56770__$1,inst_56768);
} else {
if((state_val_56771 === (4))){
var inst_56740 = (state_56770[(2)]);
var state_56770__$1 = state_56770;
var statearr_56775_56791 = state_56770__$1;
(statearr_56775_56791[(2)] = inst_56740);

(statearr_56775_56791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56771 === (5))){
var _ = (function (){var statearr_56776 = state_56770;
(statearr_56776[(4)] = cljs.core.rest((state_56770[(4)])));

return statearr_56776;
})();
var state_56770__$1 = state_56770;
var ex56774 = (state_56770__$1[(2)]);
var statearr_56777_56792 = state_56770__$1;
(statearr_56777_56792[(5)] = ex56774);


if((ex56774 instanceof Error)){
var statearr_56778_56793 = state_56770__$1;
(statearr_56778_56793[(1)] = (4));

(statearr_56778_56793[(5)] = null);

} else {
throw ex56774;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56771 === (6))){
var inst_56748 = (state_56770[(2)]);
var inst_56749 = fluree.db.util.async.throw_err(inst_56748);
var inst_56750 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_56749);
var inst_56751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56752 = [inst_56749];
var inst_56753 = (new cljs.core.PersistentVector(null,1,(5),inst_56751,inst_56752,null));
var inst_56754 = cljs.core.count(inst_56753);
var inst_56755 = ((9) + inst_56754);
var inst_56756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56757 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56759 = [inst_56749];
var inst_56760 = (new cljs.core.PersistentVector(null,1,(5),inst_56758,inst_56759,null));
var inst_56761 = ["+",inst_56760,inst_56750];
var inst_56762 = cljs.core.PersistentHashMap.fromArrays(inst_56757,inst_56761);
var inst_56763 = [inst_56762,inst_56755];
var inst_56764 = (new cljs.core.PersistentVector(null,2,(5),inst_56756,inst_56763,null));
var inst_56765 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56764);
var _ = (function (){var statearr_56779 = state_56770;
(statearr_56779[(4)] = cljs.core.rest((state_56770[(4)])));

return statearr_56779;
})();
var state_56770__$1 = (function (){var statearr_56780 = state_56770;
(statearr_56780[(7)] = inst_56765);

return statearr_56780;
})();
var statearr_56781_56794 = state_56770__$1;
(statearr_56781_56794[(2)] = inst_56750);

(statearr_56781_56794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56782 = [null,null,null,null,null,null,null,null];
(statearr_56782[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56782[(1)] = (1));

return statearr_56782;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56770){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56770);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56783){var ex__2687__auto__ = e56783;
var statearr_56784_56795 = state_56770;
(statearr_56784_56795[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56770[(4)]))){
var statearr_56785_56796 = state_56770;
(statearr_56785_56796[(1)] = cljs.core.first((state_56770[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56797 = state_56770;
state_56770 = G__56797;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56770){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56786 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56786[(6)] = c__2706__auto__);

return statearr_56786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56738){
var G__56739 = cljs.core.first(seq56738);
var seq56738__$1 = cljs.core.next(seq56738);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56739,seq56738__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56847 = arguments.length;
var i__5770__auto___56848 = (0);
while(true){
if((i__5770__auto___56848 < len__5769__auto___56847)){
args__5775__auto__.push((arguments[i__5770__auto___56848]));

var G__56849 = (i__5770__auto___56848 + (1));
i__5770__auto___56848 = G__56849;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56830){
var state_val_56831 = (state_56830[(1)]);
if((state_val_56831 === (1))){
var state_56830__$1 = state_56830;
var statearr_56832_56850 = state_56830__$1;
(statearr_56832_56850[(2)] = null);

(statearr_56832_56850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56831 === (2))){
var _ = (function (){var statearr_56833 = state_56830;
(statearr_56833[(4)] = cljs.core.cons((5),(state_56830[(4)])));

return statearr_56833;
})();
var inst_56806 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56830__$1 = state_56830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56830__$1,(6),inst_56806);
} else {
if((state_val_56831 === (3))){
var inst_56828 = (state_56830[(2)]);
var state_56830__$1 = state_56830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56830__$1,inst_56828);
} else {
if((state_val_56831 === (4))){
var inst_56800 = (state_56830[(2)]);
var state_56830__$1 = state_56830;
var statearr_56835_56851 = state_56830__$1;
(statearr_56835_56851[(2)] = inst_56800);

(statearr_56835_56851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56831 === (5))){
var _ = (function (){var statearr_56836 = state_56830;
(statearr_56836[(4)] = cljs.core.rest((state_56830[(4)])));

return statearr_56836;
})();
var state_56830__$1 = state_56830;
var ex56834 = (state_56830__$1[(2)]);
var statearr_56837_56852 = state_56830__$1;
(statearr_56837_56852[(5)] = ex56834);


if((ex56834 instanceof Error)){
var statearr_56838_56853 = state_56830__$1;
(statearr_56838_56853[(1)] = (4));

(statearr_56838_56853[(5)] = null);

} else {
throw ex56834;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56831 === (6))){
var inst_56808 = (state_56830[(2)]);
var inst_56809 = fluree.db.util.async.throw_err(inst_56808);
var inst_56810 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_56809);
var inst_56811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56812 = [inst_56809];
var inst_56813 = (new cljs.core.PersistentVector(null,1,(5),inst_56811,inst_56812,null));
var inst_56814 = cljs.core.count(inst_56813);
var inst_56815 = ((9) + inst_56814);
var inst_56816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56817 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56819 = [inst_56809];
var inst_56820 = (new cljs.core.PersistentVector(null,1,(5),inst_56818,inst_56819,null));
var inst_56821 = ["-",inst_56820,inst_56810];
var inst_56822 = cljs.core.PersistentHashMap.fromArrays(inst_56817,inst_56821);
var inst_56823 = [inst_56822,inst_56815];
var inst_56824 = (new cljs.core.PersistentVector(null,2,(5),inst_56816,inst_56823,null));
var inst_56825 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56824);
var _ = (function (){var statearr_56839 = state_56830;
(statearr_56839[(4)] = cljs.core.rest((state_56830[(4)])));

return statearr_56839;
})();
var state_56830__$1 = (function (){var statearr_56840 = state_56830;
(statearr_56840[(7)] = inst_56825);

return statearr_56840;
})();
var statearr_56841_56854 = state_56830__$1;
(statearr_56841_56854[(2)] = inst_56810);

(statearr_56841_56854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56842 = [null,null,null,null,null,null,null,null];
(statearr_56842[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56842[(1)] = (1));

return statearr_56842;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56830){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56830);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56843){var ex__2687__auto__ = e56843;
var statearr_56844_56855 = state_56830;
(statearr_56844_56855[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56830[(4)]))){
var statearr_56845_56856 = state_56830;
(statearr_56845_56856[(1)] = cljs.core.first((state_56830[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56857 = state_56830;
state_56830 = G__56857;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56830){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56846 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56846[(6)] = c__2706__auto__);

return statearr_56846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56798){
var G__56799 = cljs.core.first(seq56798);
var seq56798__$1 = cljs.core.next(seq56798);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56799,seq56798__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56907 = arguments.length;
var i__5770__auto___56908 = (0);
while(true){
if((i__5770__auto___56908 < len__5769__auto___56907)){
args__5775__auto__.push((arguments[i__5770__auto___56908]));

var G__56909 = (i__5770__auto___56908 + (1));
i__5770__auto___56908 = G__56909;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56890){
var state_val_56891 = (state_56890[(1)]);
if((state_val_56891 === (1))){
var state_56890__$1 = state_56890;
var statearr_56892_56910 = state_56890__$1;
(statearr_56892_56910[(2)] = null);

(statearr_56892_56910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56891 === (2))){
var _ = (function (){var statearr_56893 = state_56890;
(statearr_56893[(4)] = cljs.core.cons((5),(state_56890[(4)])));

return statearr_56893;
})();
var inst_56866 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56890__$1 = state_56890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56890__$1,(6),inst_56866);
} else {
if((state_val_56891 === (3))){
var inst_56888 = (state_56890[(2)]);
var state_56890__$1 = state_56890;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56890__$1,inst_56888);
} else {
if((state_val_56891 === (4))){
var inst_56860 = (state_56890[(2)]);
var state_56890__$1 = state_56890;
var statearr_56895_56911 = state_56890__$1;
(statearr_56895_56911[(2)] = inst_56860);

(statearr_56895_56911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56891 === (5))){
var _ = (function (){var statearr_56896 = state_56890;
(statearr_56896[(4)] = cljs.core.rest((state_56890[(4)])));

return statearr_56896;
})();
var state_56890__$1 = state_56890;
var ex56894 = (state_56890__$1[(2)]);
var statearr_56897_56912 = state_56890__$1;
(statearr_56897_56912[(5)] = ex56894);


if((ex56894 instanceof Error)){
var statearr_56898_56913 = state_56890__$1;
(statearr_56898_56913[(1)] = (4));

(statearr_56898_56913[(5)] = null);

} else {
throw ex56894;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56891 === (6))){
var inst_56868 = (state_56890[(2)]);
var inst_56869 = fluree.db.util.async.throw_err(inst_56868);
var inst_56870 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_56869);
var inst_56871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56872 = [inst_56869];
var inst_56873 = (new cljs.core.PersistentVector(null,1,(5),inst_56871,inst_56872,null));
var inst_56874 = cljs.core.count(inst_56873);
var inst_56875 = ((9) + inst_56874);
var inst_56876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56877 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56879 = [inst_56869];
var inst_56880 = (new cljs.core.PersistentVector(null,1,(5),inst_56878,inst_56879,null));
var inst_56881 = ["*",inst_56880,inst_56870];
var inst_56882 = cljs.core.PersistentHashMap.fromArrays(inst_56877,inst_56881);
var inst_56883 = [inst_56882,inst_56875];
var inst_56884 = (new cljs.core.PersistentVector(null,2,(5),inst_56876,inst_56883,null));
var inst_56885 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56884);
var _ = (function (){var statearr_56899 = state_56890;
(statearr_56899[(4)] = cljs.core.rest((state_56890[(4)])));

return statearr_56899;
})();
var state_56890__$1 = (function (){var statearr_56900 = state_56890;
(statearr_56900[(7)] = inst_56885);

return statearr_56900;
})();
var statearr_56901_56914 = state_56890__$1;
(statearr_56901_56914[(2)] = inst_56870);

(statearr_56901_56914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56902 = [null,null,null,null,null,null,null,null];
(statearr_56902[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56902[(1)] = (1));

return statearr_56902;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56890){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56890);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56903){var ex__2687__auto__ = e56903;
var statearr_56904_56915 = state_56890;
(statearr_56904_56915[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56890[(4)]))){
var statearr_56905_56916 = state_56890;
(statearr_56905_56916[(1)] = cljs.core.first((state_56890[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56917 = state_56890;
state_56890 = G__56917;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56890){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56906 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56906[(6)] = c__2706__auto__);

return statearr_56906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56858){
var G__56859 = cljs.core.first(seq56858);
var seq56858__$1 = cljs.core.next(seq56858);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56859,seq56858__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56967 = arguments.length;
var i__5770__auto___56968 = (0);
while(true){
if((i__5770__auto___56968 < len__5769__auto___56967)){
args__5775__auto__.push((arguments[i__5770__auto___56968]));

var G__56969 = (i__5770__auto___56968 + (1));
i__5770__auto___56968 = G__56969;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56950){
var state_val_56951 = (state_56950[(1)]);
if((state_val_56951 === (1))){
var state_56950__$1 = state_56950;
var statearr_56952_56970 = state_56950__$1;
(statearr_56952_56970[(2)] = null);

(statearr_56952_56970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56951 === (2))){
var _ = (function (){var statearr_56953 = state_56950;
(statearr_56953[(4)] = cljs.core.cons((5),(state_56950[(4)])));

return statearr_56953;
})();
var inst_56926 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56950__$1 = state_56950;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56950__$1,(6),inst_56926);
} else {
if((state_val_56951 === (3))){
var inst_56948 = (state_56950[(2)]);
var state_56950__$1 = state_56950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56950__$1,inst_56948);
} else {
if((state_val_56951 === (4))){
var inst_56920 = (state_56950[(2)]);
var state_56950__$1 = state_56950;
var statearr_56955_56971 = state_56950__$1;
(statearr_56955_56971[(2)] = inst_56920);

(statearr_56955_56971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56951 === (5))){
var _ = (function (){var statearr_56956 = state_56950;
(statearr_56956[(4)] = cljs.core.rest((state_56950[(4)])));

return statearr_56956;
})();
var state_56950__$1 = state_56950;
var ex56954 = (state_56950__$1[(2)]);
var statearr_56957_56972 = state_56950__$1;
(statearr_56957_56972[(5)] = ex56954);


if((ex56954 instanceof Error)){
var statearr_56958_56973 = state_56950__$1;
(statearr_56958_56973[(1)] = (4));

(statearr_56958_56973[(5)] = null);

} else {
throw ex56954;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56951 === (6))){
var inst_56928 = (state_56950[(2)]);
var inst_56929 = fluree.db.util.async.throw_err(inst_56928);
var inst_56930 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_56929);
var inst_56931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56932 = [inst_56929];
var inst_56933 = (new cljs.core.PersistentVector(null,1,(5),inst_56931,inst_56932,null));
var inst_56934 = cljs.core.count(inst_56933);
var inst_56935 = ((9) + inst_56934);
var inst_56936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56937 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56939 = [inst_56929];
var inst_56940 = (new cljs.core.PersistentVector(null,1,(5),inst_56938,inst_56939,null));
var inst_56941 = ["/",inst_56940,inst_56930];
var inst_56942 = cljs.core.PersistentHashMap.fromArrays(inst_56937,inst_56941);
var inst_56943 = [inst_56942,inst_56935];
var inst_56944 = (new cljs.core.PersistentVector(null,2,(5),inst_56936,inst_56943,null));
var inst_56945 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56944);
var _ = (function (){var statearr_56959 = state_56950;
(statearr_56959[(4)] = cljs.core.rest((state_56950[(4)])));

return statearr_56959;
})();
var state_56950__$1 = (function (){var statearr_56960 = state_56950;
(statearr_56960[(7)] = inst_56945);

return statearr_56960;
})();
var statearr_56961_56974 = state_56950__$1;
(statearr_56961_56974[(2)] = inst_56930);

(statearr_56961_56974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56962 = [null,null,null,null,null,null,null,null];
(statearr_56962[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56962[(1)] = (1));

return statearr_56962;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56950){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56950);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56963){var ex__2687__auto__ = e56963;
var statearr_56964_56975 = state_56950;
(statearr_56964_56975[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56950[(4)]))){
var statearr_56965_56976 = state_56950;
(statearr_56965_56976[(1)] = cljs.core.first((state_56950[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56977 = state_56950;
state_56950 = G__56977;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56950){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56966 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56966[(6)] = c__2706__auto__);

return statearr_56966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56918){
var G__56919 = cljs.core.first(seq56918);
var seq56918__$1 = cljs.core.next(seq56918);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56919,seq56918__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57015){
var state_val_57016 = (state_57015[(1)]);
if((state_val_57016 === (7))){
var state_57015__$1 = state_57015;
var statearr_57017_57041 = state_57015__$1;
(statearr_57017_57041[(2)] = n);

(statearr_57017_57041[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57016 === (1))){
var state_57015__$1 = state_57015;
var statearr_57018_57042 = state_57015__$1;
(statearr_57018_57042[(2)] = null);

(statearr_57018_57042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57016 === (4))){
var inst_56978 = (state_57015[(2)]);
var state_57015__$1 = state_57015;
var statearr_57019_57043 = state_57015__$1;
(statearr_57019_57043[(2)] = inst_56978);

(statearr_57019_57043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57016 === (13))){
var inst_56995 = (state_57015[(2)]);
var inst_56996 = fluree.db.util.async.throw_err(inst_56995);
var state_57015__$1 = state_57015;
var statearr_57020_57044 = state_57015__$1;
(statearr_57020_57044[(2)] = inst_56996);

(statearr_57020_57044[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57016 === (6))){
var state_57015__$1 = state_57015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57015__$1,(9),n);
} else {
if((state_val_57016 === (3))){
var inst_57013 = (state_57015[(2)]);
var state_57015__$1 = state_57015;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57015__$1,inst_57013);
} else {
if((state_val_57016 === (12))){
var inst_56991 = (state_57015[(7)]);
var inst_56999 = (state_57015[(2)]);
var inst_57000 = fluree.db.dbfunctions.internal.quot(inst_56991,inst_56999);
var inst_57001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57002 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57004 = [inst_56991,inst_56999];
var inst_57005 = (new cljs.core.PersistentVector(null,2,(5),inst_57003,inst_57004,null));
var inst_57006 = ["quot",inst_57005,inst_57000];
var inst_57007 = cljs.core.PersistentHashMap.fromArrays(inst_57002,inst_57006);
var inst_57008 = [inst_57007,(2)];
var inst_57009 = (new cljs.core.PersistentVector(null,2,(5),inst_57001,inst_57008,null));
var inst_57010 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57009);
var _ = (function (){var statearr_57021 = state_57015;
(statearr_57021[(4)] = cljs.core.rest((state_57015[(4)])));

return statearr_57021;
})();
var state_57015__$1 = (function (){var statearr_57022 = state_57015;
(statearr_57022[(8)] = inst_57010);

return statearr_57022;
})();
var statearr_57023_57045 = state_57015__$1;
(statearr_57023_57045[(2)] = inst_57000);

(statearr_57023_57045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57016 === (2))){
var _ = (function (){var statearr_57024 = state_57015;
(statearr_57024[(4)] = cljs.core.cons((5),(state_57015[(4)])));

return statearr_57024;
})();
var inst_56984 = fluree.db.util.async.channel_QMARK_(n);
var state_57015__$1 = state_57015;
if(inst_56984){
var statearr_57025_57046 = state_57015__$1;
(statearr_57025_57046[(1)] = (6));

} else {
var statearr_57026_57047 = state_57015__$1;
(statearr_57026_57047[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57016 === (11))){
var state_57015__$1 = state_57015;
var statearr_57028_57048 = state_57015__$1;
(statearr_57028_57048[(2)] = d);

(statearr_57028_57048[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57016 === (9))){
var inst_56987 = (state_57015[(2)]);
var inst_56988 = fluree.db.util.async.throw_err(inst_56987);
var state_57015__$1 = state_57015;
var statearr_57029_57049 = state_57015__$1;
(statearr_57029_57049[(2)] = inst_56988);

(statearr_57029_57049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57016 === (5))){
var _ = (function (){var statearr_57030 = state_57015;
(statearr_57030[(4)] = cljs.core.rest((state_57015[(4)])));

return statearr_57030;
})();
var state_57015__$1 = state_57015;
var ex57027 = (state_57015__$1[(2)]);
var statearr_57031_57050 = state_57015__$1;
(statearr_57031_57050[(5)] = ex57027);


if((ex57027 instanceof Error)){
var statearr_57032_57051 = state_57015__$1;
(statearr_57032_57051[(1)] = (4));

(statearr_57032_57051[(5)] = null);

} else {
throw ex57027;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57016 === (10))){
var state_57015__$1 = state_57015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57015__$1,(13),d);
} else {
if((state_val_57016 === (8))){
var inst_56991 = (state_57015[(2)]);
var inst_56992 = fluree.db.util.async.channel_QMARK_(d);
var state_57015__$1 = (function (){var statearr_57033 = state_57015;
(statearr_57033[(7)] = inst_56991);

return statearr_57033;
})();
if(inst_56992){
var statearr_57034_57052 = state_57015__$1;
(statearr_57034_57052[(1)] = (10));

} else {
var statearr_57035_57053 = state_57015__$1;
(statearr_57035_57053[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0 = (function (){
var statearr_57036 = [null,null,null,null,null,null,null,null,null];
(statearr_57036[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__);

(statearr_57036[(1)] = (1));

return statearr_57036;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1 = (function (state_57015){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57015);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57037){var ex__2687__auto__ = e57037;
var statearr_57038_57054 = state_57015;
(statearr_57038_57054[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57015[(4)]))){
var statearr_57039_57055 = state_57015;
(statearr_57039_57055[(1)] = cljs.core.first((state_57015[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57056 = state_57015;
state_57015 = G__57056;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__ = function(state_57015){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1.call(this,state_57015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57040 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57040[(6)] = c__2706__auto__);

return statearr_57040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57094){
var state_val_57095 = (state_57094[(1)]);
if((state_val_57095 === (7))){
var state_57094__$1 = state_57094;
var statearr_57096_57120 = state_57094__$1;
(statearr_57096_57120[(2)] = n);

(statearr_57096_57120[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57095 === (1))){
var state_57094__$1 = state_57094;
var statearr_57097_57121 = state_57094__$1;
(statearr_57097_57121[(2)] = null);

(statearr_57097_57121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57095 === (4))){
var inst_57057 = (state_57094[(2)]);
var state_57094__$1 = state_57094;
var statearr_57098_57122 = state_57094__$1;
(statearr_57098_57122[(2)] = inst_57057);

(statearr_57098_57122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57095 === (13))){
var inst_57074 = (state_57094[(2)]);
var inst_57075 = fluree.db.util.async.throw_err(inst_57074);
var state_57094__$1 = state_57094;
var statearr_57099_57123 = state_57094__$1;
(statearr_57099_57123[(2)] = inst_57075);

(statearr_57099_57123[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57095 === (6))){
var state_57094__$1 = state_57094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57094__$1,(9),n);
} else {
if((state_val_57095 === (3))){
var inst_57092 = (state_57094[(2)]);
var state_57094__$1 = state_57094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57094__$1,inst_57092);
} else {
if((state_val_57095 === (12))){
var inst_57070 = (state_57094[(7)]);
var inst_57078 = (state_57094[(2)]);
var inst_57079 = fluree.db.dbfunctions.internal.mod(inst_57070,inst_57078);
var inst_57080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57081 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57083 = [inst_57070,inst_57078];
var inst_57084 = (new cljs.core.PersistentVector(null,2,(5),inst_57082,inst_57083,null));
var inst_57085 = ["mod",inst_57084,inst_57079];
var inst_57086 = cljs.core.PersistentHashMap.fromArrays(inst_57081,inst_57085);
var inst_57087 = [inst_57086,(2)];
var inst_57088 = (new cljs.core.PersistentVector(null,2,(5),inst_57080,inst_57087,null));
var inst_57089 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57088);
var _ = (function (){var statearr_57100 = state_57094;
(statearr_57100[(4)] = cljs.core.rest((state_57094[(4)])));

return statearr_57100;
})();
var state_57094__$1 = (function (){var statearr_57101 = state_57094;
(statearr_57101[(8)] = inst_57089);

return statearr_57101;
})();
var statearr_57102_57124 = state_57094__$1;
(statearr_57102_57124[(2)] = inst_57079);

(statearr_57102_57124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57095 === (2))){
var _ = (function (){var statearr_57103 = state_57094;
(statearr_57103[(4)] = cljs.core.cons((5),(state_57094[(4)])));

return statearr_57103;
})();
var inst_57063 = fluree.db.util.async.channel_QMARK_(n);
var state_57094__$1 = state_57094;
if(inst_57063){
var statearr_57104_57125 = state_57094__$1;
(statearr_57104_57125[(1)] = (6));

} else {
var statearr_57105_57126 = state_57094__$1;
(statearr_57105_57126[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57095 === (11))){
var state_57094__$1 = state_57094;
var statearr_57107_57127 = state_57094__$1;
(statearr_57107_57127[(2)] = d);

(statearr_57107_57127[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57095 === (9))){
var inst_57066 = (state_57094[(2)]);
var inst_57067 = fluree.db.util.async.throw_err(inst_57066);
var state_57094__$1 = state_57094;
var statearr_57108_57128 = state_57094__$1;
(statearr_57108_57128[(2)] = inst_57067);

(statearr_57108_57128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57095 === (5))){
var _ = (function (){var statearr_57109 = state_57094;
(statearr_57109[(4)] = cljs.core.rest((state_57094[(4)])));

return statearr_57109;
})();
var state_57094__$1 = state_57094;
var ex57106 = (state_57094__$1[(2)]);
var statearr_57110_57129 = state_57094__$1;
(statearr_57110_57129[(5)] = ex57106);


if((ex57106 instanceof Error)){
var statearr_57111_57130 = state_57094__$1;
(statearr_57111_57130[(1)] = (4));

(statearr_57111_57130[(5)] = null);

} else {
throw ex57106;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57095 === (10))){
var state_57094__$1 = state_57094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57094__$1,(13),d);
} else {
if((state_val_57095 === (8))){
var inst_57070 = (state_57094[(2)]);
var inst_57071 = fluree.db.util.async.channel_QMARK_(d);
var state_57094__$1 = (function (){var statearr_57112 = state_57094;
(statearr_57112[(7)] = inst_57070);

return statearr_57112;
})();
if(inst_57071){
var statearr_57113_57131 = state_57094__$1;
(statearr_57113_57131[(1)] = (10));

} else {
var statearr_57114_57132 = state_57094__$1;
(statearr_57114_57132[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0 = (function (){
var statearr_57115 = [null,null,null,null,null,null,null,null,null];
(statearr_57115[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__);

(statearr_57115[(1)] = (1));

return statearr_57115;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1 = (function (state_57094){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57094);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57116){var ex__2687__auto__ = e57116;
var statearr_57117_57133 = state_57094;
(statearr_57117_57133[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57094[(4)]))){
var statearr_57118_57134 = state_57094;
(statearr_57118_57134[(1)] = cljs.core.first((state_57094[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57135 = state_57094;
state_57094 = G__57135;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__ = function(state_57094){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1.call(this,state_57094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57119 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57119[(6)] = c__2706__auto__);

return statearr_57119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57173){
var state_val_57174 = (state_57173[(1)]);
if((state_val_57174 === (7))){
var state_57173__$1 = state_57173;
var statearr_57175_57199 = state_57173__$1;
(statearr_57175_57199[(2)] = n);

(statearr_57175_57199[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57174 === (1))){
var state_57173__$1 = state_57173;
var statearr_57176_57200 = state_57173__$1;
(statearr_57176_57200[(2)] = null);

(statearr_57176_57200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57174 === (4))){
var inst_57136 = (state_57173[(2)]);
var state_57173__$1 = state_57173;
var statearr_57177_57201 = state_57173__$1;
(statearr_57177_57201[(2)] = inst_57136);

(statearr_57177_57201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57174 === (13))){
var inst_57153 = (state_57173[(2)]);
var inst_57154 = fluree.db.util.async.throw_err(inst_57153);
var state_57173__$1 = state_57173;
var statearr_57178_57202 = state_57173__$1;
(statearr_57178_57202[(2)] = inst_57154);

(statearr_57178_57202[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57174 === (6))){
var state_57173__$1 = state_57173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57173__$1,(9),n);
} else {
if((state_val_57174 === (3))){
var inst_57171 = (state_57173[(2)]);
var state_57173__$1 = state_57173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57173__$1,inst_57171);
} else {
if((state_val_57174 === (12))){
var inst_57149 = (state_57173[(7)]);
var inst_57157 = (state_57173[(2)]);
var inst_57158 = fluree.db.dbfunctions.internal.rem(inst_57149,inst_57157);
var inst_57159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57160 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57162 = [inst_57149,inst_57157];
var inst_57163 = (new cljs.core.PersistentVector(null,2,(5),inst_57161,inst_57162,null));
var inst_57164 = ["rem",inst_57163,inst_57158];
var inst_57165 = cljs.core.PersistentHashMap.fromArrays(inst_57160,inst_57164);
var inst_57166 = [inst_57165,(2)];
var inst_57167 = (new cljs.core.PersistentVector(null,2,(5),inst_57159,inst_57166,null));
var inst_57168 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57167);
var _ = (function (){var statearr_57179 = state_57173;
(statearr_57179[(4)] = cljs.core.rest((state_57173[(4)])));

return statearr_57179;
})();
var state_57173__$1 = (function (){var statearr_57180 = state_57173;
(statearr_57180[(8)] = inst_57168);

return statearr_57180;
})();
var statearr_57181_57203 = state_57173__$1;
(statearr_57181_57203[(2)] = inst_57158);

(statearr_57181_57203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57174 === (2))){
var _ = (function (){var statearr_57182 = state_57173;
(statearr_57182[(4)] = cljs.core.cons((5),(state_57173[(4)])));

return statearr_57182;
})();
var inst_57142 = fluree.db.util.async.channel_QMARK_(n);
var state_57173__$1 = state_57173;
if(inst_57142){
var statearr_57183_57204 = state_57173__$1;
(statearr_57183_57204[(1)] = (6));

} else {
var statearr_57184_57205 = state_57173__$1;
(statearr_57184_57205[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57174 === (11))){
var state_57173__$1 = state_57173;
var statearr_57186_57206 = state_57173__$1;
(statearr_57186_57206[(2)] = d);

(statearr_57186_57206[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57174 === (9))){
var inst_57145 = (state_57173[(2)]);
var inst_57146 = fluree.db.util.async.throw_err(inst_57145);
var state_57173__$1 = state_57173;
var statearr_57187_57207 = state_57173__$1;
(statearr_57187_57207[(2)] = inst_57146);

(statearr_57187_57207[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57174 === (5))){
var _ = (function (){var statearr_57188 = state_57173;
(statearr_57188[(4)] = cljs.core.rest((state_57173[(4)])));

return statearr_57188;
})();
var state_57173__$1 = state_57173;
var ex57185 = (state_57173__$1[(2)]);
var statearr_57189_57208 = state_57173__$1;
(statearr_57189_57208[(5)] = ex57185);


if((ex57185 instanceof Error)){
var statearr_57190_57209 = state_57173__$1;
(statearr_57190_57209[(1)] = (4));

(statearr_57190_57209[(5)] = null);

} else {
throw ex57185;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57174 === (10))){
var state_57173__$1 = state_57173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57173__$1,(13),d);
} else {
if((state_val_57174 === (8))){
var inst_57149 = (state_57173[(2)]);
var inst_57150 = fluree.db.util.async.channel_QMARK_(d);
var state_57173__$1 = (function (){var statearr_57191 = state_57173;
(statearr_57191[(7)] = inst_57149);

return statearr_57191;
})();
if(inst_57150){
var statearr_57192_57210 = state_57173__$1;
(statearr_57192_57210[(1)] = (10));

} else {
var statearr_57193_57211 = state_57173__$1;
(statearr_57193_57211[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0 = (function (){
var statearr_57194 = [null,null,null,null,null,null,null,null,null];
(statearr_57194[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__);

(statearr_57194[(1)] = (1));

return statearr_57194;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1 = (function (state_57173){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57173);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57195){var ex__2687__auto__ = e57195;
var statearr_57196_57212 = state_57173;
(statearr_57196_57212[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57173[(4)]))){
var statearr_57197_57213 = state_57173;
(statearr_57197_57213[(1)] = cljs.core.first((state_57173[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57214 = state_57173;
state_57173 = G__57214;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__ = function(state_57173){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1.call(this,state_57173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57198 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57198[(6)] = c__2706__auto__);

return statearr_57198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57241){
var state_val_57242 = (state_57241[(1)]);
if((state_val_57242 === (7))){
var state_57241__$1 = state_57241;
var statearr_57243_57262 = state_57241__$1;
(statearr_57243_57262[(2)] = x);

(statearr_57243_57262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (1))){
var state_57241__$1 = state_57241;
var statearr_57244_57263 = state_57241__$1;
(statearr_57244_57263[(2)] = null);

(statearr_57244_57263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (4))){
var inst_57215 = (state_57241[(2)]);
var state_57241__$1 = state_57241;
var statearr_57245_57264 = state_57241__$1;
(statearr_57245_57264[(2)] = inst_57215);

(statearr_57245_57264[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (6))){
var state_57241__$1 = state_57241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57241__$1,(9),x);
} else {
if((state_val_57242 === (3))){
var inst_57239 = (state_57241[(2)]);
var state_57241__$1 = state_57241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57241__$1,inst_57239);
} else {
if((state_val_57242 === (2))){
var _ = (function (){var statearr_57247 = state_57241;
(statearr_57247[(4)] = cljs.core.cons((5),(state_57241[(4)])));

return statearr_57247;
})();
var inst_57221 = fluree.db.util.async.channel_QMARK_(x);
var state_57241__$1 = state_57241;
if(inst_57221){
var statearr_57248_57265 = state_57241__$1;
(statearr_57248_57265[(1)] = (6));

} else {
var statearr_57249_57266 = state_57241__$1;
(statearr_57249_57266[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (9))){
var inst_57224 = (state_57241[(2)]);
var inst_57225 = fluree.db.util.async.throw_err(inst_57224);
var state_57241__$1 = state_57241;
var statearr_57250_57267 = state_57241__$1;
(statearr_57250_57267[(2)] = inst_57225);

(statearr_57250_57267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (5))){
var _ = (function (){var statearr_57251 = state_57241;
(statearr_57251[(4)] = cljs.core.rest((state_57241[(4)])));

return statearr_57251;
})();
var state_57241__$1 = state_57241;
var ex57246 = (state_57241__$1[(2)]);
var statearr_57252_57268 = state_57241__$1;
(statearr_57252_57268[(5)] = ex57246);


if((ex57246 instanceof Error)){
var statearr_57253_57269 = state_57241__$1;
(statearr_57253_57269[(1)] = (4));

(statearr_57253_57269[(5)] = null);

} else {
throw ex57246;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57242 === (8))){
var inst_57228 = (state_57241[(2)]);
var inst_57229 = fluree.db.dbfunctions.internal.boolean$(inst_57228);
var inst_57230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57231 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57232 = ["boolean",inst_57228,inst_57229];
var inst_57233 = cljs.core.PersistentHashMap.fromArrays(inst_57231,inst_57232);
var inst_57234 = [inst_57233,(10)];
var inst_57235 = (new cljs.core.PersistentVector(null,2,(5),inst_57230,inst_57234,null));
var inst_57236 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57235);
var _ = (function (){var statearr_57254 = state_57241;
(statearr_57254[(4)] = cljs.core.rest((state_57241[(4)])));

return statearr_57254;
})();
var state_57241__$1 = (function (){var statearr_57255 = state_57241;
(statearr_57255[(7)] = inst_57236);

return statearr_57255;
})();
var statearr_57256_57270 = state_57241__$1;
(statearr_57256_57270[(2)] = inst_57229);

(statearr_57256_57270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0 = (function (){
var statearr_57257 = [null,null,null,null,null,null,null,null];
(statearr_57257[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__);

(statearr_57257[(1)] = (1));

return statearr_57257;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1 = (function (state_57241){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57241);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57258){var ex__2687__auto__ = e57258;
var statearr_57259_57271 = state_57241;
(statearr_57259_57271[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57241[(4)]))){
var statearr_57260_57272 = state_57241;
(statearr_57260_57272[(1)] = cljs.core.first((state_57241[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57273 = state_57241;
state_57241 = G__57273;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__ = function(state_57241){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1.call(this,state_57241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57261 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57261[(6)] = c__2706__auto__);

return statearr_57261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57311){
var state_val_57312 = (state_57311[(1)]);
if((state_val_57312 === (7))){
var state_57311__$1 = state_57311;
var statearr_57313_57337 = state_57311__$1;
(statearr_57313_57337[(2)] = pattern);

(statearr_57313_57337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57312 === (1))){
var state_57311__$1 = state_57311;
var statearr_57314_57338 = state_57311__$1;
(statearr_57314_57338[(2)] = null);

(statearr_57314_57338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57312 === (4))){
var inst_57274 = (state_57311[(2)]);
var state_57311__$1 = state_57311;
var statearr_57315_57339 = state_57311__$1;
(statearr_57315_57339[(2)] = inst_57274);

(statearr_57315_57339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57312 === (13))){
var inst_57291 = (state_57311[(2)]);
var inst_57292 = fluree.db.util.async.throw_err(inst_57291);
var state_57311__$1 = state_57311;
var statearr_57316_57340 = state_57311__$1;
(statearr_57316_57340[(2)] = inst_57292);

(statearr_57316_57340[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57312 === (6))){
var state_57311__$1 = state_57311;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57311__$1,(9),pattern);
} else {
if((state_val_57312 === (3))){
var inst_57309 = (state_57311[(2)]);
var state_57311__$1 = state_57311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57311__$1,inst_57309);
} else {
if((state_val_57312 === (12))){
var inst_57287 = (state_57311[(7)]);
var inst_57295 = (state_57311[(2)]);
var inst_57296 = fluree.db.dbfunctions.internal.re_find(inst_57287,inst_57295);
var inst_57297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57298 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57300 = [inst_57287,inst_57295];
var inst_57301 = (new cljs.core.PersistentVector(null,2,(5),inst_57299,inst_57300,null));
var inst_57302 = ["re-find",inst_57301,inst_57296];
var inst_57303 = cljs.core.PersistentHashMap.fromArrays(inst_57298,inst_57302);
var inst_57304 = [inst_57303,(10)];
var inst_57305 = (new cljs.core.PersistentVector(null,2,(5),inst_57297,inst_57304,null));
var inst_57306 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57305);
var _ = (function (){var statearr_57317 = state_57311;
(statearr_57317[(4)] = cljs.core.rest((state_57311[(4)])));

return statearr_57317;
})();
var state_57311__$1 = (function (){var statearr_57318 = state_57311;
(statearr_57318[(8)] = inst_57306);

return statearr_57318;
})();
var statearr_57319_57341 = state_57311__$1;
(statearr_57319_57341[(2)] = inst_57296);

(statearr_57319_57341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57312 === (2))){
var _ = (function (){var statearr_57320 = state_57311;
(statearr_57320[(4)] = cljs.core.cons((5),(state_57311[(4)])));

return statearr_57320;
})();
var inst_57280 = fluree.db.util.async.channel_QMARK_(pattern);
var state_57311__$1 = state_57311;
if(inst_57280){
var statearr_57321_57342 = state_57311__$1;
(statearr_57321_57342[(1)] = (6));

} else {
var statearr_57322_57343 = state_57311__$1;
(statearr_57322_57343[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57312 === (11))){
var state_57311__$1 = state_57311;
var statearr_57324_57344 = state_57311__$1;
(statearr_57324_57344[(2)] = string);

(statearr_57324_57344[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57312 === (9))){
var inst_57283 = (state_57311[(2)]);
var inst_57284 = fluree.db.util.async.throw_err(inst_57283);
var state_57311__$1 = state_57311;
var statearr_57325_57345 = state_57311__$1;
(statearr_57325_57345[(2)] = inst_57284);

(statearr_57325_57345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57312 === (5))){
var _ = (function (){var statearr_57326 = state_57311;
(statearr_57326[(4)] = cljs.core.rest((state_57311[(4)])));

return statearr_57326;
})();
var state_57311__$1 = state_57311;
var ex57323 = (state_57311__$1[(2)]);
var statearr_57327_57346 = state_57311__$1;
(statearr_57327_57346[(5)] = ex57323);


if((ex57323 instanceof Error)){
var statearr_57328_57347 = state_57311__$1;
(statearr_57328_57347[(1)] = (4));

(statearr_57328_57347[(5)] = null);

} else {
throw ex57323;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57312 === (10))){
var state_57311__$1 = state_57311;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57311__$1,(13),string);
} else {
if((state_val_57312 === (8))){
var inst_57287 = (state_57311[(2)]);
var inst_57288 = fluree.db.util.async.channel_QMARK_(string);
var state_57311__$1 = (function (){var statearr_57329 = state_57311;
(statearr_57329[(7)] = inst_57287);

return statearr_57329;
})();
if(inst_57288){
var statearr_57330_57348 = state_57311__$1;
(statearr_57330_57348[(1)] = (10));

} else {
var statearr_57331_57349 = state_57311__$1;
(statearr_57331_57349[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0 = (function (){
var statearr_57332 = [null,null,null,null,null,null,null,null,null];
(statearr_57332[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__);

(statearr_57332[(1)] = (1));

return statearr_57332;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1 = (function (state_57311){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57311);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57333){var ex__2687__auto__ = e57333;
var statearr_57334_57350 = state_57311;
(statearr_57334_57350[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57311[(4)]))){
var statearr_57335_57351 = state_57311;
(statearr_57335_57351[(1)] = cljs.core.first((state_57311[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57352 = state_57311;
state_57311 = G__57352;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__ = function(state_57311){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1.call(this,state_57311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57336 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57336[(6)] = c__2706__auto__);

return statearr_57336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57379){
var state_val_57380 = (state_57379[(1)]);
if((state_val_57380 === (7))){
var state_57379__$1 = state_57379;
var statearr_57381_57400 = state_57379__$1;
(statearr_57381_57400[(2)] = email);

(statearr_57381_57400[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57380 === (1))){
var state_57379__$1 = state_57379;
var statearr_57382_57401 = state_57379__$1;
(statearr_57382_57401[(2)] = null);

(statearr_57382_57401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57380 === (4))){
var inst_57353 = (state_57379[(2)]);
var state_57379__$1 = state_57379;
var statearr_57383_57402 = state_57379__$1;
(statearr_57383_57402[(2)] = inst_57353);

(statearr_57383_57402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57380 === (6))){
var state_57379__$1 = state_57379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57379__$1,(9),email);
} else {
if((state_val_57380 === (3))){
var inst_57377 = (state_57379[(2)]);
var state_57379__$1 = state_57379;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57379__$1,inst_57377);
} else {
if((state_val_57380 === (2))){
var _ = (function (){var statearr_57385 = state_57379;
(statearr_57385[(4)] = cljs.core.cons((5),(state_57379[(4)])));

return statearr_57385;
})();
var inst_57359 = fluree.db.util.async.channel_QMARK_(email);
var state_57379__$1 = state_57379;
if(inst_57359){
var statearr_57386_57403 = state_57379__$1;
(statearr_57386_57403[(1)] = (6));

} else {
var statearr_57387_57404 = state_57379__$1;
(statearr_57387_57404[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57380 === (9))){
var inst_57362 = (state_57379[(2)]);
var inst_57363 = fluree.db.util.async.throw_err(inst_57362);
var state_57379__$1 = state_57379;
var statearr_57388_57405 = state_57379__$1;
(statearr_57388_57405[(2)] = inst_57363);

(statearr_57388_57405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57380 === (5))){
var _ = (function (){var statearr_57389 = state_57379;
(statearr_57389[(4)] = cljs.core.rest((state_57379[(4)])));

return statearr_57389;
})();
var state_57379__$1 = state_57379;
var ex57384 = (state_57379__$1[(2)]);
var statearr_57390_57406 = state_57379__$1;
(statearr_57390_57406[(5)] = ex57384);


if((ex57384 instanceof Error)){
var statearr_57391_57407 = state_57379__$1;
(statearr_57391_57407[(1)] = (4));

(statearr_57391_57407[(5)] = null);

} else {
throw ex57384;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57380 === (8))){
var inst_57366 = (state_57379[(2)]);
var inst_57367 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_57366);
var inst_57368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57369 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57370 = ["re-find",inst_57366,inst_57367];
var inst_57371 = cljs.core.PersistentHashMap.fromArrays(inst_57369,inst_57370);
var inst_57372 = [inst_57371,(10)];
var inst_57373 = (new cljs.core.PersistentVector(null,2,(5),inst_57368,inst_57372,null));
var inst_57374 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57373);
var _ = (function (){var statearr_57392 = state_57379;
(statearr_57392[(4)] = cljs.core.rest((state_57379[(4)])));

return statearr_57392;
})();
var state_57379__$1 = (function (){var statearr_57393 = state_57379;
(statearr_57393[(7)] = inst_57374);

return statearr_57393;
})();
var statearr_57394_57408 = state_57379__$1;
(statearr_57394_57408[(2)] = inst_57367);

(statearr_57394_57408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_57395 = [null,null,null,null,null,null,null,null];
(statearr_57395[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__);

(statearr_57395[(1)] = (1));

return statearr_57395;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1 = (function (state_57379){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57379);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57396){var ex__2687__auto__ = e57396;
var statearr_57397_57409 = state_57379;
(statearr_57397_57409[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57379[(4)]))){
var statearr_57398_57410 = state_57379;
(statearr_57398_57410[(1)] = cljs.core.first((state_57379[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57411 = state_57379;
state_57379 = G__57411;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__ = function(state_57379){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1.call(this,state_57379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57399 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57399[(6)] = c__2706__auto__);

return statearr_57399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57458){
var state_val_57459 = (state_57458[(1)]);
if((state_val_57459 === (7))){
var inst_57428 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57458__$1 = state_57458;
if(cljs.core.truth_(inst_57428)){
var statearr_57460_57487 = state_57458__$1;
(statearr_57460_57487[(1)] = (9));

} else {
var statearr_57461_57488 = state_57458__$1;
(statearr_57461_57488[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (1))){
var state_57458__$1 = state_57458;
var statearr_57462_57489 = state_57458__$1;
(statearr_57462_57489[(2)] = null);

(statearr_57462_57489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (4))){
var inst_57412 = (state_57458[(2)]);
var state_57458__$1 = state_57458;
var statearr_57463_57490 = state_57458__$1;
(statearr_57463_57490[(2)] = inst_57412);

(statearr_57463_57490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (15))){
var inst_57439 = (state_57458[(2)]);
var state_57458__$1 = state_57458;
var statearr_57464_57491 = state_57458__$1;
(statearr_57464_57491[(2)] = inst_57439);

(statearr_57464_57491[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (13))){
var inst_57436 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57458__$1 = state_57458;
var statearr_57465_57492 = state_57458__$1;
(statearr_57465_57492[(2)] = inst_57436);

(statearr_57465_57492[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (6))){
var inst_57423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57424 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57425 = [inst_57424,(0)];
var inst_57426 = (new cljs.core.PersistentVector(null,2,(5),inst_57423,inst_57425,null));
var state_57458__$1 = state_57458;
var statearr_57466_57493 = state_57458__$1;
(statearr_57466_57493[(2)] = inst_57426);

(statearr_57466_57493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (3))){
var inst_57456 = (state_57458[(2)]);
var state_57458__$1 = state_57458;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57458__$1,inst_57456);
} else {
if((state_val_57459 === (12))){
var inst_57432 = (state_57458[(2)]);
var inst_57433 = fluree.db.util.async.throw_err(inst_57432);
var state_57458__$1 = state_57458;
var statearr_57467_57494 = state_57458__$1;
(statearr_57467_57494[(2)] = inst_57433);

(statearr_57467_57494[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (2))){
var _ = (function (){var statearr_57468 = state_57458;
(statearr_57468[(4)] = cljs.core.cons((5),(state_57458[(4)])));

return statearr_57468;
})();
var inst_57421 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57458__$1 = state_57458;
if(cljs.core.truth_(inst_57421)){
var statearr_57469_57495 = state_57458__$1;
(statearr_57469_57495[(1)] = (6));

} else {
var statearr_57470_57496 = state_57458__$1;
(statearr_57470_57496[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (11))){
var inst_57441 = (state_57458[(2)]);
var state_57458__$1 = state_57458;
var statearr_57472_57497 = state_57458__$1;
(statearr_57472_57497[(2)] = inst_57441);

(statearr_57472_57497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (9))){
var inst_57430 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_57458__$1 = state_57458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57458__$1,(12),inst_57430);
} else {
if((state_val_57459 === (5))){
var _ = (function (){var statearr_57473 = state_57458;
(statearr_57473[(4)] = cljs.core.rest((state_57458[(4)])));

return statearr_57473;
})();
var state_57458__$1 = state_57458;
var ex57471 = (state_57458__$1[(2)]);
var statearr_57474_57498 = state_57458__$1;
(statearr_57474_57498[(5)] = ex57471);


if((ex57471 instanceof Error)){
var statearr_57475_57499 = state_57458__$1;
(statearr_57475_57499[(1)] = (4));

(statearr_57475_57499[(5)] = null);

} else {
throw ex57471;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (14))){
var state_57458__$1 = state_57458;
var statearr_57476_57500 = state_57458__$1;
(statearr_57476_57500[(2)] = null);

(statearr_57476_57500[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (10))){
var state_57458__$1 = state_57458;
var statearr_57477_57501 = state_57458__$1;
(statearr_57477_57501[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57459 === (8))){
var inst_57443 = (state_57458[(2)]);
var inst_57444 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57443,(0),null);
var inst_57445 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57443,(1),null);
var inst_57446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57447 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57448 = ["?user_id","?ctx",inst_57444];
var inst_57449 = cljs.core.PersistentHashMap.fromArrays(inst_57447,inst_57448);
var inst_57450 = ((10) + inst_57445);
var inst_57451 = [inst_57449,inst_57450];
var inst_57452 = (new cljs.core.PersistentVector(null,2,(5),inst_57446,inst_57451,null));
var inst_57453 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57452);
var _ = (function (){var statearr_57479 = state_57458;
(statearr_57479[(4)] = cljs.core.rest((state_57458[(4)])));

return statearr_57479;
})();
var state_57458__$1 = (function (){var statearr_57480 = state_57458;
(statearr_57480[(7)] = inst_57453);

return statearr_57480;
})();
var statearr_57481_57502 = state_57458__$1;
(statearr_57481_57502[(2)] = inst_57444);

(statearr_57481_57502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0 = (function (){
var statearr_57482 = [null,null,null,null,null,null,null,null];
(statearr_57482[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__);

(statearr_57482[(1)] = (1));

return statearr_57482;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1 = (function (state_57458){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57458);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57483){var ex__2687__auto__ = e57483;
var statearr_57484_57503 = state_57458;
(statearr_57484_57503[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57458[(4)]))){
var statearr_57485_57504 = state_57458;
(statearr_57485_57504[(1)] = cljs.core.first((state_57458[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57505 = state_57458;
state_57458 = G__57505;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__ = function(state_57458){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1.call(this,state_57458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57486 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57486[(6)] = c__2706__auto__);

return statearr_57486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57533){
var state_val_57534 = (state_57533[(1)]);
if((state_val_57534 === (7))){
var inst_57526 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57533__$1 = state_57533;
var statearr_57535_57554 = state_57533__$1;
(statearr_57535_57554[(2)] = inst_57526);

(statearr_57535_57554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57534 === (1))){
var state_57533__$1 = state_57533;
var statearr_57536_57555 = state_57533__$1;
(statearr_57536_57555[(2)] = null);

(statearr_57536_57555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57534 === (4))){
var inst_57506 = (state_57533[(2)]);
var state_57533__$1 = state_57533;
var statearr_57537_57556 = state_57533__$1;
(statearr_57537_57556[(2)] = inst_57506);

(statearr_57537_57556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57534 === (6))){
var inst_57514 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_57533__$1 = state_57533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57533__$1,(9),inst_57514);
} else {
if((state_val_57534 === (3))){
var inst_57531 = (state_57533[(2)]);
var state_57533__$1 = state_57533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57533__$1,inst_57531);
} else {
if((state_val_57534 === (2))){
var _ = (function (){var statearr_57539 = state_57533;
(statearr_57539[(4)] = cljs.core.cons((5),(state_57533[(4)])));

return statearr_57539;
})();
var inst_57512 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57533__$1 = state_57533;
if(cljs.core.truth_(inst_57512)){
var statearr_57540_57557 = state_57533__$1;
(statearr_57540_57557[(1)] = (6));

} else {
var statearr_57541_57558 = state_57533__$1;
(statearr_57541_57558[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57534 === (9))){
var inst_57516 = (state_57533[(2)]);
var inst_57517 = fluree.db.util.async.throw_err(inst_57516);
var inst_57518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57519 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57520 = ["?auth_id","?ctx",inst_57517];
var inst_57521 = cljs.core.PersistentHashMap.fromArrays(inst_57519,inst_57520);
var inst_57522 = [inst_57521,(10)];
var inst_57523 = (new cljs.core.PersistentVector(null,2,(5),inst_57518,inst_57522,null));
var inst_57524 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57523);
var state_57533__$1 = (function (){var statearr_57542 = state_57533;
(statearr_57542[(7)] = inst_57524);

return statearr_57542;
})();
var statearr_57543_57559 = state_57533__$1;
(statearr_57543_57559[(2)] = inst_57517);

(statearr_57543_57559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57534 === (5))){
var _ = (function (){var statearr_57544 = state_57533;
(statearr_57544[(4)] = cljs.core.rest((state_57533[(4)])));

return statearr_57544;
})();
var state_57533__$1 = state_57533;
var ex57538 = (state_57533__$1[(2)]);
var statearr_57545_57560 = state_57533__$1;
(statearr_57545_57560[(5)] = ex57538);


if((ex57538 instanceof Error)){
var statearr_57546_57561 = state_57533__$1;
(statearr_57546_57561[(1)] = (4));

(statearr_57546_57561[(5)] = null);

} else {
throw ex57538;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57534 === (8))){
var inst_57528 = (state_57533[(2)]);
var _ = (function (){var statearr_57547 = state_57533;
(statearr_57547[(4)] = cljs.core.rest((state_57533[(4)])));

return statearr_57547;
})();
var state_57533__$1 = state_57533;
var statearr_57548_57562 = state_57533__$1;
(statearr_57548_57562[(2)] = inst_57528);

(statearr_57548_57562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0 = (function (){
var statearr_57549 = [null,null,null,null,null,null,null,null];
(statearr_57549[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__);

(statearr_57549[(1)] = (1));

return statearr_57549;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1 = (function (state_57533){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57533);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57550){var ex__2687__auto__ = e57550;
var statearr_57551_57563 = state_57533;
(statearr_57551_57563[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57533[(4)]))){
var statearr_57552_57564 = state_57533;
(statearr_57552_57564[(1)] = cljs.core.first((state_57533[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57565 = state_57533;
state_57533 = G__57565;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__ = function(state_57533){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1.call(this,state_57533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57553 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57553[(6)] = c__2706__auto__);

return statearr_57553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57567 = arguments.length;
switch (G__57567) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57609){
var state_val_57610 = (state_57609[(1)]);
if((state_val_57610 === (7))){
var state_57609__$1 = state_57609;
var statearr_57611_57641 = state_57609__$1;
(statearr_57611_57641[(2)] = seed);

(statearr_57611_57641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (1))){
var state_57609__$1 = state_57609;
var statearr_57612_57642 = state_57609__$1;
(statearr_57612_57642[(2)] = null);

(statearr_57612_57642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (4))){
var inst_57568 = (state_57609[(2)]);
var state_57609__$1 = state_57609;
var statearr_57613_57643 = state_57609__$1;
(statearr_57613_57643[(2)] = inst_57568);

(statearr_57613_57643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (15))){
var state_57609__$1 = state_57609;
var statearr_57614_57644 = state_57609__$1;
(statearr_57614_57644[(2)] = (10));

(statearr_57614_57644[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (13))){
var inst_57585 = (state_57609[(2)]);
var inst_57586 = fluree.db.util.async.throw_err(inst_57585);
var state_57609__$1 = state_57609;
var statearr_57615_57645 = state_57609__$1;
(statearr_57615_57645[(2)] = inst_57586);

(statearr_57615_57645[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (6))){
var state_57609__$1 = state_57609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57609__$1,(9),seed);
} else {
if((state_val_57610 === (3))){
var inst_57607 = (state_57609[(2)]);
var state_57609__$1 = state_57609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57609__$1,inst_57607);
} else {
if((state_val_57610 === (12))){
var inst_57589 = (state_57609[(7)]);
var inst_57589__$1 = (state_57609[(2)]);
var state_57609__$1 = (function (){var statearr_57616 = state_57609;
(statearr_57616[(7)] = inst_57589__$1);

return statearr_57616;
})();
if(cljs.core.truth_(inst_57589__$1)){
var statearr_57617_57646 = state_57609__$1;
(statearr_57617_57646[(1)] = (14));

} else {
var statearr_57618_57647 = state_57609__$1;
(statearr_57618_57647[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (2))){
var _ = (function (){var statearr_57619 = state_57609;
(statearr_57619[(4)] = cljs.core.cons((5),(state_57609[(4)])));

return statearr_57619;
})();
var inst_57574 = fluree.db.util.async.channel_QMARK_(seed);
var state_57609__$1 = state_57609;
if(inst_57574){
var statearr_57620_57648 = state_57609__$1;
(statearr_57620_57648[(1)] = (6));

} else {
var statearr_57621_57649 = state_57609__$1;
(statearr_57621_57649[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (11))){
var state_57609__$1 = state_57609;
var statearr_57623_57650 = state_57609__$1;
(statearr_57623_57650[(2)] = max);

(statearr_57623_57650[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (9))){
var inst_57577 = (state_57609[(2)]);
var inst_57578 = fluree.db.util.async.throw_err(inst_57577);
var state_57609__$1 = state_57609;
var statearr_57624_57651 = state_57609__$1;
(statearr_57624_57651[(2)] = inst_57578);

(statearr_57624_57651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (5))){
var _ = (function (){var statearr_57625 = state_57609;
(statearr_57625[(4)] = cljs.core.rest((state_57609[(4)])));

return statearr_57625;
})();
var state_57609__$1 = state_57609;
var ex57622 = (state_57609__$1[(2)]);
var statearr_57626_57652 = state_57609__$1;
(statearr_57626_57652[(5)] = ex57622);


if((ex57622 instanceof Error)){
var statearr_57627_57653 = state_57609__$1;
(statearr_57627_57653[(1)] = (4));

(statearr_57627_57653[(5)] = null);

} else {
throw ex57622;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (14))){
var inst_57589 = (state_57609[(7)]);
var state_57609__$1 = state_57609;
var statearr_57628_57654 = state_57609__$1;
(statearr_57628_57654[(2)] = inst_57589);

(statearr_57628_57654[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (16))){
var inst_57581 = (state_57609[(8)]);
var inst_57593 = (state_57609[(2)]);
var inst_57594 = fluree.db.dbfunctions.internal.rand(inst_57581,inst_57593);
var inst_57595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57596 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57598 = [max,seed];
var inst_57599 = (new cljs.core.PersistentVector(null,2,(5),inst_57597,inst_57598,null));
var inst_57600 = ["rand",inst_57599,inst_57594];
var inst_57601 = cljs.core.PersistentHashMap.fromArrays(inst_57596,inst_57600);
var inst_57602 = [inst_57601,(10)];
var inst_57603 = (new cljs.core.PersistentVector(null,2,(5),inst_57595,inst_57602,null));
var inst_57604 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57603);
var _ = (function (){var statearr_57629 = state_57609;
(statearr_57629[(4)] = cljs.core.rest((state_57609[(4)])));

return statearr_57629;
})();
var state_57609__$1 = (function (){var statearr_57630 = state_57609;
(statearr_57630[(9)] = inst_57604);

return statearr_57630;
})();
var statearr_57631_57655 = state_57609__$1;
(statearr_57631_57655[(2)] = inst_57594);

(statearr_57631_57655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57610 === (10))){
var state_57609__$1 = state_57609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57609__$1,(13),max);
} else {
if((state_val_57610 === (8))){
var inst_57581 = (state_57609[(2)]);
var inst_57582 = fluree.db.util.async.channel_QMARK_(max);
var state_57609__$1 = (function (){var statearr_57632 = state_57609;
(statearr_57632[(8)] = inst_57581);

return statearr_57632;
})();
if(inst_57582){
var statearr_57633_57656 = state_57609__$1;
(statearr_57633_57656[(1)] = (10));

} else {
var statearr_57634_57657 = state_57609__$1;
(statearr_57634_57657[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57635 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57635[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57635[(1)] = (1));

return statearr_57635;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57609){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57609);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57636){var ex__2687__auto__ = e57636;
var statearr_57637_57658 = state_57609;
(statearr_57637_57658[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57609[(4)]))){
var statearr_57638_57659 = state_57609;
(statearr_57638_57659[(1)] = cljs.core.first((state_57609[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57660 = state_57609;
state_57609 = G__57660;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57609){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57639 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57639[(6)] = c__2706__auto__);

return statearr_57639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57681){
var state_val_57682 = (state_57681[(1)]);
if((state_val_57682 === (1))){
var state_57681__$1 = state_57681;
var statearr_57683_57698 = state_57681__$1;
(statearr_57683_57698[(2)] = null);

(statearr_57683_57698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57682 === (2))){
var _ = (function (){var statearr_57684 = state_57681;
(statearr_57684[(4)] = cljs.core.cons((5),(state_57681[(4)])));

return statearr_57684;
})();
var inst_57667 = fluree.db.util.core.random_uuid();
var inst_57668 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57667);
var inst_57669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57670 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57671 = cljs.core.PersistentVector.EMPTY;
var inst_57672 = ["uuid",inst_57671,inst_57668];
var inst_57673 = cljs.core.PersistentHashMap.fromArrays(inst_57670,inst_57672);
var inst_57674 = [inst_57673,(10)];
var inst_57675 = (new cljs.core.PersistentVector(null,2,(5),inst_57669,inst_57674,null));
var inst_57676 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57675);
var ___$1 = (function (){var statearr_57685 = state_57681;
(statearr_57685[(4)] = cljs.core.rest((state_57681[(4)])));

return statearr_57685;
})();
var state_57681__$1 = (function (){var statearr_57686 = state_57681;
(statearr_57686[(7)] = inst_57676);

return statearr_57686;
})();
var statearr_57687_57699 = state_57681__$1;
(statearr_57687_57699[(2)] = inst_57668);

(statearr_57687_57699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57682 === (3))){
var inst_57679 = (state_57681[(2)]);
var state_57681__$1 = state_57681;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57681__$1,inst_57679);
} else {
if((state_val_57682 === (4))){
var inst_57661 = (state_57681[(2)]);
var state_57681__$1 = state_57681;
var statearr_57689_57700 = state_57681__$1;
(statearr_57689_57700[(2)] = inst_57661);

(statearr_57689_57700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57682 === (5))){
var _ = (function (){var statearr_57690 = state_57681;
(statearr_57690[(4)] = cljs.core.rest((state_57681[(4)])));

return statearr_57690;
})();
var state_57681__$1 = state_57681;
var ex57688 = (state_57681__$1[(2)]);
var statearr_57691_57701 = state_57681__$1;
(statearr_57691_57701[(5)] = ex57688);


if((ex57688 instanceof Error)){
var statearr_57692_57702 = state_57681__$1;
(statearr_57692_57702[(1)] = (4));

(statearr_57692_57702[(5)] = null);

} else {
throw ex57688;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0 = (function (){
var statearr_57693 = [null,null,null,null,null,null,null,null];
(statearr_57693[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__);

(statearr_57693[(1)] = (1));

return statearr_57693;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1 = (function (state_57681){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57681);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57694){var ex__2687__auto__ = e57694;
var statearr_57695_57703 = state_57681;
(statearr_57695_57703[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57681[(4)]))){
var statearr_57696_57704 = state_57681;
(statearr_57696_57704[(1)] = cljs.core.first((state_57681[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57705 = state_57681;
state_57681 = G__57705;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__ = function(state_57681){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1.call(this,state_57681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57697 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57697[(6)] = c__2706__auto__);

return statearr_57697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57735){
var state_val_57736 = (state_57735[(1)]);
if((state_val_57736 === (7))){
var state_57735__$1 = state_57735;
var statearr_57737_57756 = state_57735__$1;
(statearr_57737_57756[(2)] = num);

(statearr_57737_57756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (1))){
var state_57735__$1 = state_57735;
var statearr_57738_57757 = state_57735__$1;
(statearr_57738_57757[(2)] = null);

(statearr_57738_57757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (4))){
var inst_57706 = (state_57735[(2)]);
var state_57735__$1 = state_57735;
var statearr_57739_57758 = state_57735__$1;
(statearr_57739_57758[(2)] = inst_57706);

(statearr_57739_57758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (6))){
var state_57735__$1 = state_57735;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57735__$1,(9),num);
} else {
if((state_val_57736 === (3))){
var inst_57733 = (state_57735[(2)]);
var state_57735__$1 = state_57735;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57735__$1,inst_57733);
} else {
if((state_val_57736 === (2))){
var _ = (function (){var statearr_57741 = state_57735;
(statearr_57741[(4)] = cljs.core.cons((5),(state_57735[(4)])));

return statearr_57741;
})();
var inst_57712 = fluree.db.util.async.channel_QMARK_(num);
var state_57735__$1 = state_57735;
if(inst_57712){
var statearr_57742_57759 = state_57735__$1;
(statearr_57742_57759[(1)] = (6));

} else {
var statearr_57743_57760 = state_57735__$1;
(statearr_57743_57760[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (9))){
var inst_57715 = (state_57735[(2)]);
var inst_57716 = fluree.db.util.async.throw_err(inst_57715);
var state_57735__$1 = state_57735;
var statearr_57744_57761 = state_57735__$1;
(statearr_57744_57761[(2)] = inst_57716);

(statearr_57744_57761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (5))){
var _ = (function (){var statearr_57745 = state_57735;
(statearr_57745[(4)] = cljs.core.rest((state_57735[(4)])));

return statearr_57745;
})();
var state_57735__$1 = state_57735;
var ex57740 = (state_57735__$1[(2)]);
var statearr_57746_57762 = state_57735__$1;
(statearr_57746_57762[(5)] = ex57740);


if((ex57740 instanceof Error)){
var statearr_57747_57763 = state_57735__$1;
(statearr_57747_57763[(1)] = (4));

(statearr_57747_57763[(5)] = null);

} else {
throw ex57740;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (8))){
var inst_57719 = (state_57735[(2)]);
var inst_57720 = fluree.db.dbfunctions.internal.ceil(inst_57719);
var inst_57721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57722 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57724 = [fluree.db.dbfunctions.fns.ceil];
var inst_57725 = (new cljs.core.PersistentVector(null,1,(5),inst_57723,inst_57724,null));
var inst_57726 = ["",inst_57725,inst_57720];
var inst_57727 = cljs.core.PersistentHashMap.fromArrays(inst_57722,inst_57726);
var inst_57728 = [inst_57727,(10)];
var inst_57729 = (new cljs.core.PersistentVector(null,2,(5),inst_57721,inst_57728,null));
var inst_57730 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57729);
var _ = (function (){var statearr_57748 = state_57735;
(statearr_57748[(4)] = cljs.core.rest((state_57735[(4)])));

return statearr_57748;
})();
var state_57735__$1 = (function (){var statearr_57749 = state_57735;
(statearr_57749[(7)] = inst_57730);

return statearr_57749;
})();
var statearr_57750_57764 = state_57735__$1;
(statearr_57750_57764[(2)] = inst_57720);

(statearr_57750_57764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0 = (function (){
var statearr_57751 = [null,null,null,null,null,null,null,null];
(statearr_57751[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__);

(statearr_57751[(1)] = (1));

return statearr_57751;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1 = (function (state_57735){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57735);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57752){var ex__2687__auto__ = e57752;
var statearr_57753_57765 = state_57735;
(statearr_57753_57765[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57735[(4)]))){
var statearr_57754_57766 = state_57735;
(statearr_57754_57766[(1)] = cljs.core.first((state_57735[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57767 = state_57735;
state_57735 = G__57767;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__ = function(state_57735){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1.call(this,state_57735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57755 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57755[(6)] = c__2706__auto__);

return statearr_57755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57797){
var state_val_57798 = (state_57797[(1)]);
if((state_val_57798 === (7))){
var state_57797__$1 = state_57797;
var statearr_57799_57818 = state_57797__$1;
(statearr_57799_57818[(2)] = num);

(statearr_57799_57818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57798 === (1))){
var state_57797__$1 = state_57797;
var statearr_57800_57819 = state_57797__$1;
(statearr_57800_57819[(2)] = null);

(statearr_57800_57819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57798 === (4))){
var inst_57768 = (state_57797[(2)]);
var state_57797__$1 = state_57797;
var statearr_57801_57820 = state_57797__$1;
(statearr_57801_57820[(2)] = inst_57768);

(statearr_57801_57820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57798 === (6))){
var state_57797__$1 = state_57797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57797__$1,(9),num);
} else {
if((state_val_57798 === (3))){
var inst_57795 = (state_57797[(2)]);
var state_57797__$1 = state_57797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57797__$1,inst_57795);
} else {
if((state_val_57798 === (2))){
var _ = (function (){var statearr_57803 = state_57797;
(statearr_57803[(4)] = cljs.core.cons((5),(state_57797[(4)])));

return statearr_57803;
})();
var inst_57774 = fluree.db.util.async.channel_QMARK_(num);
var state_57797__$1 = state_57797;
if(inst_57774){
var statearr_57804_57821 = state_57797__$1;
(statearr_57804_57821[(1)] = (6));

} else {
var statearr_57805_57822 = state_57797__$1;
(statearr_57805_57822[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57798 === (9))){
var inst_57777 = (state_57797[(2)]);
var inst_57778 = fluree.db.util.async.throw_err(inst_57777);
var state_57797__$1 = state_57797;
var statearr_57806_57823 = state_57797__$1;
(statearr_57806_57823[(2)] = inst_57778);

(statearr_57806_57823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57798 === (5))){
var _ = (function (){var statearr_57807 = state_57797;
(statearr_57807[(4)] = cljs.core.rest((state_57797[(4)])));

return statearr_57807;
})();
var state_57797__$1 = state_57797;
var ex57802 = (state_57797__$1[(2)]);
var statearr_57808_57824 = state_57797__$1;
(statearr_57808_57824[(5)] = ex57802);


if((ex57802 instanceof Error)){
var statearr_57809_57825 = state_57797__$1;
(statearr_57809_57825[(1)] = (4));

(statearr_57809_57825[(5)] = null);

} else {
throw ex57802;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57798 === (8))){
var inst_57781 = (state_57797[(2)]);
var inst_57782 = fluree.db.dbfunctions.internal.floor(inst_57781);
var inst_57783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57784 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57786 = [fluree.db.dbfunctions.fns.floor];
var inst_57787 = (new cljs.core.PersistentVector(null,1,(5),inst_57785,inst_57786,null));
var inst_57788 = ["",inst_57787,inst_57782];
var inst_57789 = cljs.core.PersistentHashMap.fromArrays(inst_57784,inst_57788);
var inst_57790 = [inst_57789,(10)];
var inst_57791 = (new cljs.core.PersistentVector(null,2,(5),inst_57783,inst_57790,null));
var inst_57792 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57791);
var _ = (function (){var statearr_57810 = state_57797;
(statearr_57810[(4)] = cljs.core.rest((state_57797[(4)])));

return statearr_57810;
})();
var state_57797__$1 = (function (){var statearr_57811 = state_57797;
(statearr_57811[(7)] = inst_57792);

return statearr_57811;
})();
var statearr_57812_57826 = state_57797__$1;
(statearr_57812_57826[(2)] = inst_57782);

(statearr_57812_57826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0 = (function (){
var statearr_57813 = [null,null,null,null,null,null,null,null];
(statearr_57813[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__);

(statearr_57813[(1)] = (1));

return statearr_57813;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1 = (function (state_57797){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57797);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57814){var ex__2687__auto__ = e57814;
var statearr_57815_57827 = state_57797;
(statearr_57815_57827[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57797[(4)]))){
var statearr_57816_57828 = state_57797;
(statearr_57816_57828[(1)] = cljs.core.first((state_57797[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57829 = state_57797;
state_57797 = G__57829;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__ = function(state_57797){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1.call(this,state_57797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57817 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57817[(6)] = c__2706__auto__);

return statearr_57817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57854){
var state_val_57855 = (state_57854[(1)]);
if((state_val_57855 === (1))){
var state_57854__$1 = state_57854;
var statearr_57856_57871 = state_57854__$1;
(statearr_57856_57871[(2)] = null);

(statearr_57856_57871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57855 === (2))){
var _ = (function (){var statearr_57857 = state_57854;
(statearr_57857[(4)] = cljs.core.cons((5),(state_57854[(4)])));

return statearr_57857;
})();
var inst_57836 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_57854__$1 = state_57854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57854__$1,(6),inst_57836);
} else {
if((state_val_57855 === (3))){
var inst_57852 = (state_57854[(2)]);
var state_57854__$1 = state_57854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57854__$1,inst_57852);
} else {
if((state_val_57855 === (4))){
var inst_57830 = (state_57854[(2)]);
var state_57854__$1 = state_57854;
var statearr_57859_57872 = state_57854__$1;
(statearr_57859_57872[(2)] = inst_57830);

(statearr_57859_57872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57855 === (5))){
var _ = (function (){var statearr_57860 = state_57854;
(statearr_57860[(4)] = cljs.core.rest((state_57854[(4)])));

return statearr_57860;
})();
var state_57854__$1 = state_57854;
var ex57858 = (state_57854__$1[(2)]);
var statearr_57861_57873 = state_57854__$1;
(statearr_57861_57873[(5)] = ex57858);


if((ex57858 instanceof Error)){
var statearr_57862_57874 = state_57854__$1;
(statearr_57862_57874[(1)] = (4));

(statearr_57862_57874[(5)] = null);

} else {
throw ex57858;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57855 === (6))){
var inst_57838 = (state_57854[(2)]);
var inst_57839 = fluree.db.util.async.throw_err(inst_57838);
var inst_57840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57841 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57843 = [compare_val,new_val];
var inst_57844 = (new cljs.core.PersistentVector(null,2,(5),inst_57842,inst_57843,null));
var inst_57845 = ["",inst_57844,inst_57839];
var inst_57846 = cljs.core.PersistentHashMap.fromArrays(inst_57841,inst_57845);
var inst_57847 = [inst_57846,(10)];
var inst_57848 = (new cljs.core.PersistentVector(null,2,(5),inst_57840,inst_57847,null));
var inst_57849 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57848);
var _ = (function (){var statearr_57863 = state_57854;
(statearr_57863[(4)] = cljs.core.rest((state_57854[(4)])));

return statearr_57863;
})();
var state_57854__$1 = (function (){var statearr_57864 = state_57854;
(statearr_57864[(7)] = inst_57849);

return statearr_57864;
})();
var statearr_57865_57875 = state_57854__$1;
(statearr_57865_57875[(2)] = inst_57839);

(statearr_57865_57875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0 = (function (){
var statearr_57866 = [null,null,null,null,null,null,null,null];
(statearr_57866[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__);

(statearr_57866[(1)] = (1));

return statearr_57866;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1 = (function (state_57854){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57854);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57867){var ex__2687__auto__ = e57867;
var statearr_57868_57876 = state_57854;
(statearr_57868_57876[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57854[(4)]))){
var statearr_57869_57877 = state_57854;
(statearr_57869_57877[(1)] = cljs.core.first((state_57854[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57878 = state_57854;
state_57854 = G__57878;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__ = function(state_57854){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1.call(this,state_57854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57870 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57870[(6)] = c__2706__auto__);

return statearr_57870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
