// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__63472 = arguments.length;
switch (G__63472) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63514){
var state_val_63515 = (state_63514[(1)]);
if((state_val_63515 === (7))){
var inst_63484 = typeof user === 'string';
var state_63514__$1 = state_63514;
if(cljs.core.truth_(inst_63484)){
var statearr_63516_63545 = state_63514__$1;
(statearr_63516_63545[(1)] = (9));

} else {
var statearr_63517_63546 = state_63514__$1;
(statearr_63517_63546[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (1))){
var state_63514__$1 = state_63514;
var statearr_63518_63547 = state_63514__$1;
(statearr_63518_63547[(2)] = null);

(statearr_63518_63547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (4))){
var inst_63473 = (state_63514[(2)]);
var inst_63474 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63473], 0));
var inst_63475 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63473) : reject.call(null,inst_63473));
var state_63514__$1 = (function (){var statearr_63519 = state_63514;
(statearr_63519[(7)] = inst_63474);

return statearr_63519;
})();
var statearr_63520_63548 = state_63514__$1;
(statearr_63520_63548[(2)] = inst_63475);

(statearr_63520_63548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (15))){
var inst_63503 = (state_63514[(2)]);
var inst_63504 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_63503);
var inst_63505 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63506 = cljs.core.constantly(inst_63504);
var inst_63507 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63505,inst_63506);
var inst_63508 = fluree.db.connection.add_token(conn,inst_63504);
var inst_63509 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_63503) : resolve.call(null,inst_63503));
var _ = (function (){var statearr_63521 = state_63514;
(statearr_63521[(4)] = cljs.core.rest((state_63514[(4)])));

return statearr_63521;
})();
var state_63514__$1 = (function (){var statearr_63522 = state_63514;
(statearr_63522[(8)] = inst_63508);

(statearr_63522[(9)] = inst_63507);

return statearr_63522;
})();
var statearr_63523_63549 = state_63514__$1;
(statearr_63523_63549[(2)] = inst_63509);

(statearr_63523_63549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (13))){
var state_63514__$1 = state_63514;
var statearr_63524_63550 = state_63514__$1;
(statearr_63524_63550[(2)] = null);

(statearr_63524_63550[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (6))){
var state_63514__$1 = state_63514;
var statearr_63525_63551 = state_63514__$1;
(statearr_63525_63551[(2)] = user);

(statearr_63525_63551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (3))){
var inst_63512 = (state_63514[(2)]);
var state_63514__$1 = state_63514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63514__$1,inst_63512);
} else {
if((state_val_63515 === (12))){
var state_63514__$1 = state_63514;
var statearr_63526_63552 = state_63514__$1;
(statearr_63526_63552[(2)] = user);

(statearr_63526_63552[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (2))){
var _ = (function (){var statearr_63527 = state_63514;
(statearr_63527[(4)] = cljs.core.cons((5),(state_63514[(4)])));

return statearr_63527;
})();
var inst_63481 = typeof user === 'number';
var state_63514__$1 = state_63514;
if(cljs.core.truth_(inst_63481)){
var statearr_63528_63553 = state_63514__$1;
(statearr_63528_63553[(1)] = (6));

} else {
var statearr_63529_63554 = state_63514__$1;
(statearr_63529_63554[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (11))){
var inst_63495 = (state_63514[(2)]);
var state_63514__$1 = state_63514;
var statearr_63531_63555 = state_63514__$1;
(statearr_63531_63555[(2)] = inst_63495);

(statearr_63531_63555[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (9))){
var inst_63486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63487 = ["_user/username",user];
var inst_63488 = (new cljs.core.PersistentVector(null,2,(5),inst_63486,inst_63487,null));
var state_63514__$1 = state_63514;
var statearr_63532_63556 = state_63514__$1;
(statearr_63532_63556[(2)] = inst_63488);

(statearr_63532_63556[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (5))){
var _ = (function (){var statearr_63533 = state_63514;
(statearr_63533[(4)] = cljs.core.rest((state_63514[(4)])));

return statearr_63533;
})();
var state_63514__$1 = state_63514;
var ex63530 = (state_63514__$1[(2)]);
var statearr_63534_63557 = state_63514__$1;
(statearr_63534_63557[(5)] = ex63530);


var statearr_63535_63558 = state_63514__$1;
(statearr_63535_63558[(1)] = (4));

(statearr_63535_63558[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (14))){
var inst_63493 = (state_63514[(2)]);
var state_63514__$1 = state_63514;
var statearr_63536_63559 = state_63514__$1;
(statearr_63536_63559[(2)] = inst_63493);

(statearr_63536_63559[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (10))){
var state_63514__$1 = state_63514;
var statearr_63537_63560 = state_63514__$1;
(statearr_63537_63560[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63515 === (8))){
var inst_63497 = (state_63514[(2)]);
var inst_63498 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_63499 = [account,inst_63497,password,expireSeconds,syncTo];
var inst_63500 = cljs.core.PersistentHashMap.fromArrays(inst_63498,inst_63499);
var inst_63501 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_63500);
var state_63514__$1 = state_63514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63514__$1,(15),inst_63501);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_63539 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63539[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_63539[(1)] = (1));

return statearr_63539;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_63514){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_63514);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63540){var ex__2687__auto__ = e63540;
var statearr_63541_63561 = state_63514;
(statearr_63541_63561[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_63514[(4)]))){
var statearr_63542_63562 = state_63514;
(statearr_63542_63562[(1)] = cljs.core.first((state_63514[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63563 = state_63514;
state_63514 = G__63563;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_63514){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_63514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63543 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_63543[(6)] = c__2706__auto__);

return statearr_63543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__63565 = arguments.length;
switch (G__63565) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63574){
var state_val_63575 = (state_63574[(1)]);
if((state_val_63575 === (1))){
var inst_63566 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63568 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_63569 = (new cljs.core.PersistentVector(null,4,(5),inst_63567,inst_63568,null));
var inst_63570 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63566,inst_63569);
var inst_63571 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__63576 = cljs.core.seq(cljs.core.keys(x));
var chunk__63577 = null;
var count__63578 = (0);
var i__63579 = (0);
while(true){
if((i__63579 < count__63578)){
var k = chunk__63577.cljs$core$IIndexed$_nth$arity$2(null,i__63579);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63587 = seq__63576;
var G__63588 = chunk__63577;
var G__63589 = count__63578;
var G__63590 = (i__63579 + (1));
seq__63576 = G__63587;
chunk__63577 = G__63588;
count__63578 = G__63589;
i__63579 = G__63590;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__63576);
if(temp__5804__auto__){
var seq__63576__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63576__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__63576__$1);
var G__63591 = cljs.core.chunk_rest(seq__63576__$1);
var G__63592 = c__5568__auto__;
var G__63593 = cljs.core.count(c__5568__auto__);
var G__63594 = (0);
seq__63576 = G__63591;
chunk__63577 = G__63592;
count__63578 = G__63593;
i__63579 = G__63594;
continue;
} else {
var k = cljs.core.first(seq__63576__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63595 = cljs.core.next(seq__63576__$1);
var G__63596 = null;
var G__63597 = (0);
var G__63598 = (0);
seq__63576 = G__63595;
chunk__63577 = G__63596;
count__63578 = G__63597;
i__63579 = G__63598;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_63572 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63571);
var state_63574__$1 = (function (){var statearr_63580 = state_63574;
(statearr_63580[(7)] = inst_63570);

return statearr_63580;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63574__$1,inst_63572);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_63581 = [null,null,null,null,null,null,null,null];
(statearr_63581[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_63581[(1)] = (1));

return statearr_63581;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_63574){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_63574);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63582){var ex__2687__auto__ = e63582;
var statearr_63583_63599 = state_63574;
(statearr_63583_63599[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_63574[(4)]))){
var statearr_63584_63600 = state_63574;
(statearr_63584_63600[(1)] = cljs.core.first((state_63574[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63601 = state_63574;
state_63574 = G__63601;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_63574){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_63574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63585 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_63585[(6)] = c__2706__auto__);

return statearr_63585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__63603 = arguments.length;
switch (G__63603) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63637){
var state_val_63638 = (state_63637[(1)]);
if((state_val_63638 === (1))){
var state_63637__$1 = state_63637;
var statearr_63639_63660 = state_63637__$1;
(statearr_63639_63660[(2)] = null);

(statearr_63639_63660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63638 === (2))){
var _ = (function (){var statearr_63640 = state_63637;
(statearr_63640[(4)] = cljs.core.cons((5),(state_63637[(4)])));

return statearr_63640;
})();
var inst_63612 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_63613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63614 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_63615 = (new cljs.core.PersistentVector(null,1,(5),inst_63613,inst_63614,null));
var inst_63616 = cljs.core.PersistentHashMap.EMPTY;
var inst_63617 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63616);
var inst_63618 = cljs.core.assoc_in(inst_63612,inst_63615,inst_63617);
var inst_63619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63620 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63621 = (new cljs.core.PersistentVector(null,1,(5),inst_63619,inst_63620,null));
var inst_63622 = cljs.core.PersistentHashMap.EMPTY;
var inst_63623 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63622);
var inst_63624 = cljs.core.assoc_in(inst_63618,inst_63621,inst_63623);
var inst_63625 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63626 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_63624);
var inst_63627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63628 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_63625,null];
var inst_63629 = (new cljs.core.PersistentVector(null,4,(5),inst_63627,inst_63628,null));
var inst_63630 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63626,inst_63629);
var inst_63631 = (function (){var conn = inst_63624;
var pc = inst_63625;
return (function (x){
if((x == null)){
} else {
var seq__63641_63661 = cljs.core.seq(cljs.core.keys(x));
var chunk__63642_63662 = null;
var count__63643_63663 = (0);
var i__63644_63664 = (0);
while(true){
if((i__63644_63664 < count__63643_63663)){
var k_63665 = chunk__63642_63662.cljs$core$IIndexed$_nth$arity$2(null,i__63644_63664);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63665], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63665,null));


var G__63666 = seq__63641_63661;
var G__63667 = chunk__63642_63662;
var G__63668 = count__63643_63663;
var G__63669 = (i__63644_63664 + (1));
seq__63641_63661 = G__63666;
chunk__63642_63662 = G__63667;
count__63643_63663 = G__63668;
i__63644_63664 = G__63669;
continue;
} else {
var temp__5804__auto___63670 = cljs.core.seq(seq__63641_63661);
if(temp__5804__auto___63670){
var seq__63641_63671__$1 = temp__5804__auto___63670;
if(cljs.core.chunked_seq_QMARK_(seq__63641_63671__$1)){
var c__5568__auto___63672 = cljs.core.chunk_first(seq__63641_63671__$1);
var G__63673 = cljs.core.chunk_rest(seq__63641_63671__$1);
var G__63674 = c__5568__auto___63672;
var G__63675 = cljs.core.count(c__5568__auto___63672);
var G__63676 = (0);
seq__63641_63661 = G__63673;
chunk__63642_63662 = G__63674;
count__63643_63663 = G__63675;
i__63644_63664 = G__63676;
continue;
} else {
var k_63677 = cljs.core.first(seq__63641_63671__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63677], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63677,null));


var G__63678 = cljs.core.next(seq__63641_63671__$1);
var G__63679 = null;
var G__63680 = (0);
var G__63681 = (0);
seq__63641_63661 = G__63678;
chunk__63642_63662 = G__63679;
count__63643_63663 = G__63680;
i__63644_63664 = G__63681;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_63632 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63625,inst_63631);
var ___$1 = (function (){var statearr_63645 = state_63637;
(statearr_63645[(4)] = cljs.core.rest((state_63637[(4)])));

return statearr_63645;
})();
var state_63637__$1 = (function (){var statearr_63646 = state_63637;
(statearr_63646[(7)] = inst_63630);

return statearr_63646;
})();
var statearr_63647_63682 = state_63637__$1;
(statearr_63647_63682[(2)] = inst_63632);

(statearr_63647_63682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63638 === (3))){
var inst_63635 = (state_63637[(2)]);
var state_63637__$1 = state_63637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63637__$1,inst_63635);
} else {
if((state_val_63638 === (4))){
var inst_63604 = (state_63637[(2)]);
var inst_63605 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63604], 0));
var inst_63606 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63604) : reject.call(null,inst_63604));
var state_63637__$1 = (function (){var statearr_63649 = state_63637;
(statearr_63649[(8)] = inst_63605);

return statearr_63649;
})();
var statearr_63650_63683 = state_63637__$1;
(statearr_63650_63683[(2)] = inst_63606);

(statearr_63650_63683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63638 === (5))){
var _ = (function (){var statearr_63651 = state_63637;
(statearr_63651[(4)] = cljs.core.rest((state_63637[(4)])));

return statearr_63651;
})();
var state_63637__$1 = state_63637;
var ex63648 = (state_63637__$1[(2)]);
var statearr_63652_63684 = state_63637__$1;
(statearr_63652_63684[(5)] = ex63648);


var statearr_63653_63685 = state_63637__$1;
(statearr_63653_63685[(1)] = (4));

(statearr_63653_63685[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_63654 = [null,null,null,null,null,null,null,null,null];
(statearr_63654[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_63654[(1)] = (1));

return statearr_63654;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_63637){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_63637);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63655){var ex__2687__auto__ = e63655;
var statearr_63656_63686 = state_63637;
(statearr_63656_63686[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_63637[(4)]))){
var statearr_63657_63687 = state_63637;
(statearr_63657_63687[(1)] = cljs.core.first((state_63637[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63688 = state_63637;
state_63637 = G__63688;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_63637){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_63637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63658 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_63658[(6)] = c__2706__auto__);

return statearr_63658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__63690 = arguments.length;
switch (G__63690) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__63692 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63692,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63692,(1),null);
var cb_STAR_ = (function (header,data){
var G__63695 = cljs.core.clj__GT_js(header);
var G__63696 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__63695,G__63696) : callback.call(null,G__63695,G__63696));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__63697 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63697,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63697,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63750){
var state_val_63751 = (state_63750[(1)]);
if((state_val_63751 === (7))){
var inst_63711 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63712 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63713 = cljs.core.PersistentHashMap.fromArrays(inst_63711,inst_63712);
var inst_63714 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63713);
var inst_63715 = (function(){throw inst_63714})();
var state_63750__$1 = state_63750;
var statearr_63752_63784 = state_63750__$1;
(statearr_63752_63784[(2)] = inst_63715);

(statearr_63752_63784[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (1))){
var state_63750__$1 = state_63750;
var statearr_63753_63785 = state_63750__$1;
(statearr_63753_63785[(2)] = null);

(statearr_63753_63785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (4))){
var inst_63700 = (state_63750[(2)]);
var inst_63701 = cljs.core.clj__GT_js(inst_63700);
var inst_63702 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63701) : reject.call(null,inst_63701));
var state_63750__$1 = state_63750;
var statearr_63754_63786 = state_63750__$1;
(statearr_63754_63786[(2)] = inst_63702);

(statearr_63754_63786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (13))){
var inst_63729 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63730 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63731 = cljs.core.PersistentHashMap.fromArrays(inst_63729,inst_63730);
var inst_63732 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_63731);
var inst_63733 = (function(){throw inst_63732})();
var state_63750__$1 = state_63750;
var statearr_63755_63787 = state_63750__$1;
(statearr_63755_63787[(2)] = inst_63733);

(statearr_63755_63787[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (6))){
var state_63750__$1 = state_63750;
var statearr_63756_63788 = state_63750__$1;
(statearr_63756_63788[(2)] = null);

(statearr_63756_63788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (3))){
var inst_63748 = (state_63750[(2)]);
var state_63750__$1 = state_63750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63750__$1,inst_63748);
} else {
if((state_val_63751 === (12))){
var state_63750__$1 = state_63750;
var statearr_63757_63789 = state_63750__$1;
(statearr_63757_63789[(2)] = null);

(statearr_63757_63789[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (2))){
var _ = (function (){var statearr_63758 = state_63750;
(statearr_63758[(4)] = cljs.core.cons((5),(state_63750[(4)])));

return statearr_63758;
})();
var inst_63708 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63750__$1 = state_63750;
if(cljs.core.truth_(inst_63708)){
var statearr_63759_63790 = state_63750__$1;
(statearr_63759_63790[(1)] = (6));

} else {
var statearr_63760_63791 = state_63750__$1;
(statearr_63760_63791[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (11))){
var inst_63726 = (state_63750[(2)]);
var state_63750__$1 = (function (){var statearr_63762 = state_63750;
(statearr_63762[(7)] = inst_63726);

return statearr_63762;
})();
if(cljs.core.truth_(password)){
var statearr_63763_63792 = state_63750__$1;
(statearr_63763_63792[(1)] = (12));

} else {
var statearr_63764_63793 = state_63750__$1;
(statearr_63764_63793[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (9))){
var state_63750__$1 = state_63750;
var statearr_63765_63794 = state_63750__$1;
(statearr_63765_63794[(2)] = null);

(statearr_63765_63794[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (5))){
var _ = (function (){var statearr_63766 = state_63750;
(statearr_63766[(4)] = cljs.core.rest((state_63750[(4)])));

return statearr_63766;
})();
var state_63750__$1 = state_63750;
var ex63761 = (state_63750__$1[(2)]);
var statearr_63767_63795 = state_63750__$1;
(statearr_63767_63795[(5)] = ex63761);


var statearr_63768_63796 = state_63750__$1;
(statearr_63768_63796[(1)] = (4));

(statearr_63768_63796[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (14))){
var inst_63735 = (state_63750[(2)]);
var inst_63736 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_63737 = fluree.db.util.core.without_nils(inst_63736);
var inst_63738 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63739 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63741 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_63737,inst_63738,null];
var inst_63742 = (new cljs.core.PersistentVector(null,4,(5),inst_63740,inst_63741,null));
var inst_63743 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63739,inst_63742);
var inst_63744 = (function (){var _ = inst_63735;
var data = inst_63737;
var pc = inst_63738;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63769 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63769) : reject.call(null,G__63769));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63770 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63770) : reject.call(null,G__63770));
} else {
var G__63771 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63771) : resolve.call(null,G__63771));

}
}
});
})();
var inst_63745 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63738,inst_63744);
var _ = (function (){var statearr_63772 = state_63750;
(statearr_63772[(4)] = cljs.core.rest((state_63750[(4)])));

return statearr_63772;
})();
var state_63750__$1 = (function (){var statearr_63773 = state_63750;
(statearr_63773[(8)] = inst_63743);

return statearr_63773;
})();
var statearr_63774_63797 = state_63750__$1;
(statearr_63774_63797[(2)] = inst_63745);

(statearr_63774_63797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (10))){
var inst_63720 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63721 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63722 = cljs.core.PersistentHashMap.fromArrays(inst_63720,inst_63721);
var inst_63723 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_63722);
var inst_63724 = (function(){throw inst_63723})();
var state_63750__$1 = state_63750;
var statearr_63775_63798 = state_63750__$1;
(statearr_63775_63798[(2)] = inst_63724);

(statearr_63775_63798[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63751 === (8))){
var inst_63717 = (state_63750[(2)]);
var state_63750__$1 = (function (){var statearr_63776 = state_63750;
(statearr_63776[(9)] = inst_63717);

return statearr_63776;
})();
if(cljs.core.truth_(ledger)){
var statearr_63777_63799 = state_63750__$1;
(statearr_63777_63799[(1)] = (9));

} else {
var statearr_63778_63800 = state_63750__$1;
(statearr_63778_63800[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0 = (function (){
var statearr_63779 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63779[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2684__auto__);

(statearr_63779[(1)] = (1));

return statearr_63779;
});
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1 = (function (state_63750){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_63750);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63780){var ex__2687__auto__ = e63780;
var statearr_63781_63801 = state_63750;
(statearr_63781_63801[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_63750[(4)]))){
var statearr_63782_63802 = state_63750;
(statearr_63782_63802[(1)] = cljs.core.first((state_63750[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63803 = state_63750;
state_63750 = G__63803;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = function(state_63750){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1.call(this,state_63750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63783 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_63783[(6)] = c__2706__auto__);

return statearr_63783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__63805 = arguments.length;
switch (G__63805) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63872){
var state_val_63873 = (state_63872[(1)]);
if((state_val_63873 === (7))){
var inst_63817 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63818 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63819 = cljs.core.PersistentHashMap.fromArrays(inst_63817,inst_63818);
var inst_63820 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63819);
var inst_63821 = (function(){throw inst_63820})();
var state_63872__$1 = state_63872;
var statearr_63874_63916 = state_63872__$1;
(statearr_63874_63916[(2)] = inst_63821);

(statearr_63874_63916[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (20))){
var inst_63855 = (state_63872[(2)]);
var inst_63856 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63857 = [ledger,password,user,auth,expire];
var inst_63858 = cljs.core.PersistentHashMap.fromArrays(inst_63856,inst_63857);
var inst_63859 = fluree.db.util.core.without_nils(inst_63858);
var inst_63860 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63861 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63863 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_63859,inst_63860,null];
var inst_63864 = (new cljs.core.PersistentVector(null,4,(5),inst_63862,inst_63863,null));
var inst_63865 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63861,inst_63864);
var inst_63866 = (function (){var _ = inst_63855;
var data = inst_63859;
var pc = inst_63860;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63875 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63875) : reject.call(null,G__63875));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63876 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63876) : reject.call(null,G__63876));
} else {
fluree.db.connection.add_token(conn,result);

var G__63877 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63877) : resolve.call(null,G__63877));

}
}
});
})();
var inst_63867 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63860,inst_63866);
var _ = (function (){var statearr_63878 = state_63872;
(statearr_63878[(4)] = cljs.core.rest((state_63872[(4)])));

return statearr_63878;
})();
var state_63872__$1 = (function (){var statearr_63879 = state_63872;
(statearr_63879[(7)] = inst_63865);

return statearr_63879;
})();
var statearr_63880_63917 = state_63872__$1;
(statearr_63880_63917[(2)] = inst_63867);

(statearr_63880_63917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (1))){
var state_63872__$1 = state_63872;
var statearr_63881_63918 = state_63872__$1;
(statearr_63881_63918[(2)] = null);

(statearr_63881_63918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (4))){
var inst_63806 = (state_63872[(2)]);
var inst_63807 = cljs.core.clj__GT_js(inst_63806);
var inst_63808 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63807) : reject.call(null,inst_63807));
var state_63872__$1 = state_63872;
var statearr_63882_63919 = state_63872__$1;
(statearr_63882_63919[(2)] = inst_63808);

(statearr_63882_63919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (15))){
var inst_63842 = (state_63872[(8)]);
var state_63872__$1 = state_63872;
var statearr_63883_63920 = state_63872__$1;
(statearr_63883_63920[(2)] = inst_63842);

(statearr_63883_63920[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (13))){
var inst_63835 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63836 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63837 = cljs.core.PersistentHashMap.fromArrays(inst_63835,inst_63836);
var inst_63838 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_63837);
var inst_63839 = (function(){throw inst_63838})();
var state_63872__$1 = state_63872;
var statearr_63884_63921 = state_63872__$1;
(statearr_63884_63921[(2)] = inst_63839);

(statearr_63884_63921[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (6))){
var state_63872__$1 = state_63872;
var statearr_63885_63922 = state_63872__$1;
(statearr_63885_63922[(2)] = null);

(statearr_63885_63922[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (17))){
var inst_63846 = (state_63872[(2)]);
var state_63872__$1 = state_63872;
if(cljs.core.truth_(inst_63846)){
var statearr_63886_63923 = state_63872__$1;
(statearr_63886_63923[(1)] = (18));

} else {
var statearr_63887_63924 = state_63872__$1;
(statearr_63887_63924[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (3))){
var inst_63870 = (state_63872[(2)]);
var state_63872__$1 = state_63872;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63872__$1,inst_63870);
} else {
if((state_val_63873 === (12))){
var state_63872__$1 = state_63872;
var statearr_63888_63925 = state_63872__$1;
(statearr_63888_63925[(2)] = null);

(statearr_63888_63925[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (2))){
var _ = (function (){var statearr_63889 = state_63872;
(statearr_63889[(4)] = cljs.core.cons((5),(state_63872[(4)])));

return statearr_63889;
})();
var inst_63814 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63872__$1 = state_63872;
if(cljs.core.truth_(inst_63814)){
var statearr_63890_63926 = state_63872__$1;
(statearr_63890_63926[(1)] = (6));

} else {
var statearr_63891_63927 = state_63872__$1;
(statearr_63891_63927[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (19))){
var inst_63849 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63850 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63851 = cljs.core.PersistentHashMap.fromArrays(inst_63849,inst_63850);
var inst_63852 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_63851);
var inst_63853 = (function(){throw inst_63852})();
var state_63872__$1 = state_63872;
var statearr_63892_63928 = state_63872__$1;
(statearr_63892_63928[(2)] = inst_63853);

(statearr_63892_63928[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (11))){
var inst_63832 = (state_63872[(2)]);
var state_63872__$1 = (function (){var statearr_63894 = state_63872;
(statearr_63894[(9)] = inst_63832);

return statearr_63894;
})();
if(cljs.core.truth_(password)){
var statearr_63895_63929 = state_63872__$1;
(statearr_63895_63929[(1)] = (12));

} else {
var statearr_63896_63930 = state_63872__$1;
(statearr_63896_63930[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (9))){
var state_63872__$1 = state_63872;
var statearr_63897_63931 = state_63872__$1;
(statearr_63897_63931[(2)] = null);

(statearr_63897_63931[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (5))){
var _ = (function (){var statearr_63898 = state_63872;
(statearr_63898[(4)] = cljs.core.rest((state_63872[(4)])));

return statearr_63898;
})();
var state_63872__$1 = state_63872;
var ex63893 = (state_63872__$1[(2)]);
var statearr_63899_63932 = state_63872__$1;
(statearr_63899_63932[(5)] = ex63893);


var statearr_63900_63933 = state_63872__$1;
(statearr_63900_63933[(1)] = (4));

(statearr_63900_63933[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (14))){
var inst_63842 = (state_63872[(8)]);
var inst_63841 = (state_63872[(2)]);
var inst_63842__$1 = user;
var state_63872__$1 = (function (){var statearr_63901 = state_63872;
(statearr_63901[(10)] = inst_63841);

(statearr_63901[(8)] = inst_63842__$1);

return statearr_63901;
})();
if(cljs.core.truth_(inst_63842__$1)){
var statearr_63902_63934 = state_63872__$1;
(statearr_63902_63934[(1)] = (15));

} else {
var statearr_63903_63935 = state_63872__$1;
(statearr_63903_63935[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (16))){
var state_63872__$1 = state_63872;
var statearr_63904_63936 = state_63872__$1;
(statearr_63904_63936[(2)] = auth);

(statearr_63904_63936[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (10))){
var inst_63826 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63827 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63828 = cljs.core.PersistentHashMap.fromArrays(inst_63826,inst_63827);
var inst_63829 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_63828);
var inst_63830 = (function(){throw inst_63829})();
var state_63872__$1 = state_63872;
var statearr_63905_63937 = state_63872__$1;
(statearr_63905_63937[(2)] = inst_63830);

(statearr_63905_63937[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (18))){
var state_63872__$1 = state_63872;
var statearr_63906_63938 = state_63872__$1;
(statearr_63906_63938[(2)] = null);

(statearr_63906_63938[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63873 === (8))){
var inst_63823 = (state_63872[(2)]);
var state_63872__$1 = (function (){var statearr_63907 = state_63872;
(statearr_63907[(11)] = inst_63823);

return statearr_63907;
})();
if(cljs.core.truth_(ledger)){
var statearr_63908_63939 = state_63872__$1;
(statearr_63908_63939[(1)] = (9));

} else {
var statearr_63909_63940 = state_63872__$1;
(statearr_63909_63940[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_63910 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63910[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_63910[(1)] = (1));

return statearr_63910;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_63872){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_63872);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63911){var ex__2687__auto__ = e63911;
var statearr_63912_63941 = state_63872;
(statearr_63912_63941[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_63872[(4)]))){
var statearr_63913_63942 = state_63872;
(statearr_63913_63942[(1)] = cljs.core.first((state_63872[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63943 = state_63872;
state_63872 = G__63943;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_63872){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_63872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63914 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_63914[(6)] = c__2706__auto__);

return statearr_63914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__63945 = arguments.length;
switch (G__63945) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63980){
var state_val_63981 = (state_63980[(1)]);
if((state_val_63981 === (1))){
var state_63980__$1 = state_63980;
var statearr_63982_64004 = state_63980__$1;
(statearr_63982_64004[(2)] = null);

(statearr_63982_64004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63981 === (2))){
var _ = (function (){var statearr_63983 = state_63980;
(statearr_63983[(4)] = cljs.core.cons((5),(state_63980[(4)])));

return statearr_63983;
})();
var inst_63954 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63980__$1 = state_63980;
if(cljs.core.truth_(inst_63954)){
var statearr_63984_64005 = state_63980__$1;
(statearr_63984_64005[(1)] = (6));

} else {
var statearr_63985_64006 = state_63980__$1;
(statearr_63985_64006[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63981 === (3))){
var inst_63978 = (state_63980[(2)]);
var state_63980__$1 = state_63980;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63980__$1,inst_63978);
} else {
if((state_val_63981 === (4))){
var inst_63946 = (state_63980[(2)]);
var inst_63947 = cljs.core.clj__GT_js(inst_63946);
var inst_63948 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63947) : reject.call(null,inst_63947));
var state_63980__$1 = state_63980;
var statearr_63987_64007 = state_63980__$1;
(statearr_63987_64007[(2)] = inst_63948);

(statearr_63987_64007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63981 === (5))){
var _ = (function (){var statearr_63988 = state_63980;
(statearr_63988[(4)] = cljs.core.rest((state_63980[(4)])));

return statearr_63988;
})();
var state_63980__$1 = state_63980;
var ex63986 = (state_63980__$1[(2)]);
var statearr_63989_64008 = state_63980__$1;
(statearr_63989_64008[(5)] = ex63986);


var statearr_63990_64009 = state_63980__$1;
(statearr_63990_64009[(1)] = (4));

(statearr_63990_64009[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63981 === (6))){
var state_63980__$1 = state_63980;
var statearr_63991_64010 = state_63980__$1;
(statearr_63991_64010[(2)] = null);

(statearr_63991_64010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63981 === (7))){
var inst_63957 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63958 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63959 = cljs.core.PersistentHashMap.fromArrays(inst_63957,inst_63958);
var inst_63960 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63959);
var inst_63961 = (function(){throw inst_63960})();
var state_63980__$1 = state_63980;
var statearr_63992_64011 = state_63980__$1;
(statearr_63992_64011[(2)] = inst_63961);

(statearr_63992_64011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63981 === (8))){
var inst_63963 = (state_63980[(2)]);
var inst_63964 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63965 = [jwt,expire];
var inst_63966 = cljs.core.PersistentHashMap.fromArrays(inst_63964,inst_63965);
var inst_63967 = fluree.db.util.core.without_nils(inst_63966);
var inst_63968 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63969 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63971 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_63967,inst_63968,null];
var inst_63972 = (new cljs.core.PersistentVector(null,4,(5),inst_63970,inst_63971,null));
var inst_63973 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63969,inst_63972);
var inst_63974 = (function (){var _ = inst_63963;
var data = inst_63967;
var pc = inst_63968;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63993 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63993) : reject.call(null,G__63993));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__63994 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63994) : resolve.call(null,G__63994));

}
});
})();
var inst_63975 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63968,inst_63974);
var _ = (function (){var statearr_63995 = state_63980;
(statearr_63995[(4)] = cljs.core.rest((state_63980[(4)])));

return statearr_63995;
})();
var state_63980__$1 = (function (){var statearr_63996 = state_63980;
(statearr_63996[(7)] = inst_63973);

return statearr_63996;
})();
var statearr_63997_64012 = state_63980__$1;
(statearr_63997_64012[(2)] = inst_63975);

(statearr_63997_64012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_63998 = [null,null,null,null,null,null,null,null];
(statearr_63998[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_63998[(1)] = (1));

return statearr_63998;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_63980){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_63980);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63999){var ex__2687__auto__ = e63999;
var statearr_64000_64013 = state_63980;
(statearr_64000_64013[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_63980[(4)]))){
var statearr_64001_64014 = state_63980;
(statearr_64001_64014[(1)] = cljs.core.first((state_63980[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64015 = state_63980;
state_63980 = G__64015;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_63980){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_63980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64002 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64002[(6)] = c__2706__auto__);

return statearr_64002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

