// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_.call(null,e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.call(null,"XHTTP Request Error:",e.request);

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__20493 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__20493,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__20493;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__20494 = opts;
var map__20494__$1 = cljs.core.__destructure_map.call(null,map__20494);
var request_timeout = cljs.core.get.call(null,map__20494__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__20494__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__20494__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__20495 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__20495__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__20495,headers):G__20495);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__20495__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__20495__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.call(null,response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true)));
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__20496 = opts;
var map__20496__$1 = cljs.core.__destructure_map.call(null,map__20496);
var request_timeout = cljs.core.get.call(null,map__20496__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__20496__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__20496__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__20496__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__20496__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__20497 = cljs.core.PersistentArrayMap.EMPTY;
var G__20497__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__20497,headers):G__20497);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__20497__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__20497__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__20498 = output_format;
var G__20498__$1 = (((G__20498 instanceof cljs.core.Keyword))?G__20498.fqn:null);
switch (G__20498__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify.call(null,data);

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__20500 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__20500,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__20500;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_20532){
var state_val_20533 = (state_20532[(1)]);
if((state_val_20533 === (7))){
var inst_20528 = (state_20532[(2)]);
var state_20532__$1 = state_20532;
var statearr_20534_20559 = state_20532__$1;
(statearr_20534_20559[(2)] = inst_20528);

(statearr_20534_20559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20533 === (1))){
var state_20532__$1 = state_20532;
var statearr_20535_20560 = state_20532__$1;
(statearr_20535_20560[(2)] = null);

(statearr_20535_20560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20533 === (4))){
var inst_20503 = (state_20532[(7)]);
var inst_20503__$1 = (state_20532[(2)]);
var inst_20504 = (inst_20503__$1 == null);
var state_20532__$1 = (function (){var statearr_20536 = state_20532;
(statearr_20536[(7)] = inst_20503__$1);

return statearr_20536;
})();
if(cljs.core.truth_(inst_20504)){
var statearr_20537_20561 = state_20532__$1;
(statearr_20537_20561[(1)] = (5));

} else {
var statearr_20538_20562 = state_20532__$1;
(statearr_20538_20562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20533 === (6))){
var inst_20503 = (state_20532[(7)]);
var inst_20511 = cljs.core.nth.call(null,inst_20503,(0),null);
var inst_20512 = cljs.core.nth.call(null,inst_20503,(1),null);
var state_20532__$1 = (function (){var statearr_20539 = state_20532;
(statearr_20539[(8)] = inst_20511);

(statearr_20539[(9)] = inst_20512);

return statearr_20539;
})();
var statearr_20540_20563 = state_20532__$1;
(statearr_20540_20563[(2)] = null);

(statearr_20540_20563[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20533 === (3))){
var inst_20530 = (state_20532[(2)]);
var state_20532__$1 = state_20532;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20532__$1,inst_20530);
} else {
if((state_val_20533 === (2))){
var state_20532__$1 = state_20532;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20532__$1,(4),pub_chan);
} else {
if((state_val_20533 === (11))){
var _ = (function (){var statearr_20542 = state_20532;
(statearr_20542[(4)] = cljs.core.rest.call(null,(state_20532[(4)])));

return statearr_20542;
})();
var state_20532__$1 = state_20532;
var ex20541 = (state_20532__$1[(2)]);
var statearr_20543_20564 = state_20532__$1;
(statearr_20543_20564[(5)] = ex20541);


var statearr_20544_20565 = state_20532__$1;
(statearr_20544_20565[(1)] = (10));

(statearr_20544_20565[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20533 === (9))){
var inst_20525 = (state_20532[(2)]);
var state_20532__$1 = (function (){var statearr_20545 = state_20532;
(statearr_20545[(10)] = inst_20525);

return statearr_20545;
})();
var statearr_20546_20566 = state_20532__$1;
(statearr_20546_20566[(2)] = null);

(statearr_20546_20566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20533 === (5))){
var inst_20506 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_20532__$1 = state_20532;
var statearr_20547_20567 = state_20532__$1;
(statearr_20547_20567[(2)] = inst_20506);

(statearr_20547_20567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20533 === (10))){
var inst_20511 = (state_20532[(8)]);
var inst_20512 = (state_20532[(9)]);
var inst_20513 = (state_20532[(2)]);
var inst_20514 = fluree.db.util.log.error.call(null,inst_20513,"Error sending websocket message:",inst_20511);
var inst_20515 = cljs.core.async.put_BANG_.call(null,inst_20512,false);
var state_20532__$1 = (function (){var statearr_20548 = state_20532;
(statearr_20548[(11)] = inst_20514);

return statearr_20548;
})();
var statearr_20549_20568 = state_20532__$1;
(statearr_20549_20568[(2)] = inst_20515);

(statearr_20549_20568[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20533 === (8))){
var inst_20511 = (state_20532[(8)]);
var inst_20512 = (state_20532[(9)]);
var _ = (function (){var statearr_20550 = state_20532;
(statearr_20550[(4)] = cljs.core.cons.call(null,(11),(state_20532[(4)])));

return statearr_20550;
})();
var inst_20521 = ws.send(inst_20511);
var inst_20522 = cljs.core.async.put_BANG_.call(null,inst_20512,true);
var ___$1 = (function (){var statearr_20551 = state_20532;
(statearr_20551[(4)] = cljs.core.rest.call(null,(state_20532[(4)])));

return statearr_20551;
})();
var state_20532__$1 = (function (){var statearr_20552 = state_20532;
(statearr_20552[(12)] = inst_20521);

return statearr_20552;
})();
var statearr_20553_20569 = state_20532__$1;
(statearr_20553_20569[(2)] = inst_20522);

(statearr_20553_20569[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto____0 = (function (){
var statearr_20554 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20554[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto__);

(statearr_20554[(1)] = (1));

return statearr_20554;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto____1 = (function (state_20532){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_20532);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e20555){var ex__2706__auto__ = e20555;
var statearr_20556_20570 = state_20532;
(statearr_20556_20570[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_20532[(4)]))){
var statearr_20557_20571 = state_20532;
(statearr_20557_20571[(1)] = cljs.core.first.call(null,(state_20532[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20572 = state_20532;
state_20532 = G__20572;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto__ = function(state_20532){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto____1.call(this,state_20532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_20558 = f__2726__auto__.call(null);
(statearr_20558[(6)] = c__2725__auto__);

return statearr_20558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__2725__auto___20610 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_20597){
var state_val_20598 = (state_20597[(1)]);
if((state_val_20598 === (1))){
var inst_20576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20577 = [open_QMARK_,timeout_chan];
var inst_20578 = (new cljs.core.PersistentVector(null,2,(5),inst_20576,inst_20577,null));
var state_20597__$1 = state_20597;
return cljs.core.async.ioc_alts_BANG_.call(null,state_20597__$1,(2),inst_20578,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_20598 === (2))){
var inst_20580 = (state_20597[(2)]);
var inst_20581 = cljs.core.nth.call(null,inst_20580,(0),null);
var inst_20582 = cljs.core.nth.call(null,inst_20580,(1),null);
var inst_20583 = cljs.core._EQ_.call(null,inst_20582,timeout_chan);
var state_20597__$1 = (function (){var statearr_20599 = state_20597;
(statearr_20599[(7)] = inst_20581);

return statearr_20599;
})();
if(inst_20583){
var statearr_20600_20611 = state_20597__$1;
(statearr_20600_20611[(1)] = (3));

} else {
var statearr_20601_20612 = state_20597__$1;
(statearr_20601_20612[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20598 === (3))){
var inst_20585 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_20586 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20587 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_20588 = cljs.core.PersistentHashMap.fromArrays(inst_20586,inst_20587);
var inst_20589 = cljs.core.ex_info.call(null,inst_20585,inst_20588);
var inst_20590 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_20589);
var inst_20591 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_20597__$1 = (function (){var statearr_20602 = state_20597;
(statearr_20602[(8)] = inst_20590);

return statearr_20602;
})();
var statearr_20603_20613 = state_20597__$1;
(statearr_20603_20613[(2)] = inst_20591);

(statearr_20603_20613[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20598 === (4))){
var inst_20593 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_20597__$1 = state_20597;
var statearr_20604_20614 = state_20597__$1;
(statearr_20604_20614[(2)] = inst_20593);

(statearr_20604_20614[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20598 === (5))){
var inst_20595 = (state_20597[(2)]);
var state_20597__$1 = state_20597;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20597__$1,inst_20595);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto____0 = (function (){
var statearr_20605 = [null,null,null,null,null,null,null,null,null];
(statearr_20605[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto__);

(statearr_20605[(1)] = (1));

return statearr_20605;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto____1 = (function (state_20597){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_20597);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e20606){var ex__2706__auto__ = e20606;
var statearr_20607_20615 = state_20597;
(statearr_20607_20615[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_20597[(4)]))){
var statearr_20608_20616 = state_20597;
(statearr_20608_20616[(1)] = cljs.core.first.call(null,(state_20597[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20617 = state_20597;
state_20597 = G__20617;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto__ = function(state_20597){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto____1.call(this,state_20597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_20609 = f__2726__auto__.call(null);
(statearr_20609[(6)] = c__2725__auto___20610);

return statearr_20609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
