// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_12231){
var state_val_12232 = (state_12231[(1)]);
if((state_val_12232 === (7))){
var inst_12226 = (state_12231[(2)]);
var _ = (function (){var statearr_12233 = state_12231;
(statearr_12233[(4)] = cljs.core.rest.call(null,(state_12231[(4)])));

return statearr_12233;
})();
var state_12231__$1 = state_12231;
var statearr_12234_12256 = state_12231__$1;
(statearr_12234_12256[(2)] = inst_12226);

(statearr_12234_12256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12232 === (1))){
var state_12231__$1 = state_12231;
var statearr_12235_12257 = state_12231__$1;
(statearr_12235_12257[(2)] = null);

(statearr_12235_12257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12232 === (4))){
var inst_12188 = (state_12231[(2)]);
var state_12231__$1 = state_12231;
var statearr_12236_12258 = state_12231__$1;
(statearr_12236_12258[(2)] = inst_12188);

(statearr_12236_12258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12232 === (6))){
var inst_12206 = (state_12231[(7)]);
var inst_12213 = (state_12231[(8)]);
var inst_12212 = cljs.core.seq.call(null,inst_12206);
var inst_12213__$1 = cljs.core.first.call(null,inst_12212);
var inst_12214 = cljs.core.next.call(null,inst_12212);
var inst_12215 = cljs.core.not.call(null,inst_12213__$1);
var state_12231__$1 = (function (){var statearr_12237 = state_12231;
(statearr_12237[(9)] = inst_12214);

(statearr_12237[(8)] = inst_12213__$1);

return statearr_12237;
})();
if(inst_12215){
var statearr_12238_12259 = state_12231__$1;
(statearr_12238_12259[(1)] = (8));

} else {
var statearr_12239_12260 = state_12231__$1;
(statearr_12239_12260[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12232 === (3))){
var inst_12229 = (state_12231[(2)]);
var state_12231__$1 = state_12231;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12231__$1,inst_12229);
} else {
if((state_val_12232 === (2))){
var _ = (function (){var statearr_12240 = state_12231;
(statearr_12240[(4)] = cljs.core.cons.call(null,(5),(state_12231[(4)])));

return statearr_12240;
})();
var inst_12201 = chs;
var inst_12202 = cljs.core.seq.call(null,inst_12201);
var inst_12203 = cljs.core.first.call(null,inst_12202);
var inst_12204 = cljs.core.next.call(null,inst_12202);
var inst_12205 = coll;
var inst_12206 = inst_12201;
var inst_12207 = inst_12205;
var state_12231__$1 = (function (){var statearr_12241 = state_12231;
(statearr_12241[(10)] = inst_12204);

(statearr_12241[(7)] = inst_12206);

(statearr_12241[(11)] = inst_12207);

(statearr_12241[(12)] = inst_12203);

return statearr_12241;
})();
var statearr_12242_12261 = state_12231__$1;
(statearr_12242_12261[(2)] = null);

(statearr_12242_12261[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12232 === (11))){
var inst_12214 = (state_12231[(9)]);
var inst_12207 = (state_12231[(11)]);
var inst_12219 = (state_12231[(2)]);
var inst_12220 = fluree.db.util.async.throw_err.call(null,inst_12219);
var inst_12221 = cljs.core.conj.call(null,inst_12207,inst_12220);
var inst_12206 = inst_12214;
var inst_12207__$1 = inst_12221;
var state_12231__$1 = (function (){var statearr_12244 = state_12231;
(statearr_12244[(7)] = inst_12206);

(statearr_12244[(11)] = inst_12207__$1);

return statearr_12244;
})();
var statearr_12245_12262 = state_12231__$1;
(statearr_12245_12262[(2)] = null);

(statearr_12245_12262[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12232 === (9))){
var inst_12213 = (state_12231[(8)]);
var state_12231__$1 = state_12231;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12231__$1,(11),inst_12213);
} else {
if((state_val_12232 === (5))){
var _ = (function (){var statearr_12246 = state_12231;
(statearr_12246[(4)] = cljs.core.rest.call(null,(state_12231[(4)])));

return statearr_12246;
})();
var state_12231__$1 = state_12231;
var ex12243 = (state_12231__$1[(2)]);
var statearr_12247_12263 = state_12231__$1;
(statearr_12247_12263[(5)] = ex12243);


var statearr_12248_12264 = state_12231__$1;
(statearr_12248_12264[(1)] = (4));

(statearr_12248_12264[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12232 === (10))){
var inst_12224 = (state_12231[(2)]);
var state_12231__$1 = state_12231;
var statearr_12249_12265 = state_12231__$1;
(statearr_12249_12265[(2)] = inst_12224);

(statearr_12249_12265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12232 === (8))){
var inst_12207 = (state_12231[(11)]);
var state_12231__$1 = state_12231;
var statearr_12250_12266 = state_12231__$1;
(statearr_12250_12266[(2)] = inst_12207);

(statearr_12250_12266[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto____0 = (function (){
var statearr_12251 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12251[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto__);

(statearr_12251[(1)] = (1));

return statearr_12251;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto____1 = (function (state_12231){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_12231);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e12252){var ex__2706__auto__ = e12252;
var statearr_12253_12267 = state_12231;
(statearr_12253_12267[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_12231[(4)]))){
var statearr_12254_12268 = state_12231;
(statearr_12254_12268[(1)] = cljs.core.first.call(null,(state_12231[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12269 = state_12231;
state_12231 = G__12269;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto__ = function(state_12231){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto____1.call(this,state_12231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_12255 = f__2726__auto__.call(null);
(statearr_12255[(6)] = c__2725__auto__);

return statearr_12255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_12295){
var state_val_12296 = (state_12295[(1)]);
if((state_val_12296 === (7))){
var inst_12290 = (state_12295[(2)]);
var _ = (function (){var statearr_12297 = state_12295;
(statearr_12297[(4)] = cljs.core.rest.call(null,(state_12295[(4)])));

return statearr_12297;
})();
var state_12295__$1 = state_12295;
var statearr_12298_12320 = state_12295__$1;
(statearr_12298_12320[(2)] = inst_12290);

(statearr_12298_12320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12296 === (1))){
var state_12295__$1 = state_12295;
var statearr_12299_12321 = state_12295__$1;
(statearr_12299_12321[(2)] = null);

(statearr_12299_12321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12296 === (4))){
var inst_12270 = (state_12295[(2)]);
var state_12295__$1 = state_12295;
var statearr_12300_12322 = state_12295__$1;
(statearr_12300_12322[(2)] = inst_12270);

(statearr_12300_12322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12296 === (6))){
var state_12295__$1 = state_12295;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12295__$1,(8),chan);
} else {
if((state_val_12296 === (3))){
var inst_12293 = (state_12295[(2)]);
var state_12295__$1 = state_12295;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12295__$1,inst_12293);
} else {
if((state_val_12296 === (2))){
var _ = (function (){var statearr_12301 = state_12295;
(statearr_12301[(4)] = cljs.core.cons.call(null,(5),(state_12295[(4)])));

return statearr_12301;
})();
var inst_12276 = coll;
var inst_12277 = inst_12276;
var state_12295__$1 = (function (){var statearr_12302 = state_12295;
(statearr_12302[(7)] = inst_12277);

return statearr_12302;
})();
var statearr_12303_12323 = state_12295__$1;
(statearr_12303_12323[(2)] = null);

(statearr_12303_12323[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12296 === (11))){
var inst_12288 = (state_12295[(2)]);
var state_12295__$1 = state_12295;
var statearr_12305_12324 = state_12295__$1;
(statearr_12305_12324[(2)] = inst_12288);

(statearr_12305_12324[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12296 === (9))){
var inst_12277 = (state_12295[(7)]);
var state_12295__$1 = state_12295;
var statearr_12306_12325 = state_12295__$1;
(statearr_12306_12325[(2)] = inst_12277);

(statearr_12306_12325[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12296 === (5))){
var _ = (function (){var statearr_12307 = state_12295;
(statearr_12307[(4)] = cljs.core.rest.call(null,(state_12295[(4)])));

return statearr_12307;
})();
var state_12295__$1 = state_12295;
var ex12304 = (state_12295__$1[(2)]);
var statearr_12308_12326 = state_12295__$1;
(statearr_12308_12326[(5)] = ex12304);


var statearr_12309_12327 = state_12295__$1;
(statearr_12309_12327[(1)] = (4));

(statearr_12309_12327[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12296 === (10))){
var inst_12281 = (state_12295[(8)]);
var inst_12277 = (state_12295[(7)]);
var inst_12285 = cljs.core.conj.call(null,inst_12277,inst_12281);
var inst_12277__$1 = inst_12285;
var state_12295__$1 = (function (){var statearr_12310 = state_12295;
(statearr_12310[(7)] = inst_12277__$1);

return statearr_12310;
})();
var statearr_12311_12328 = state_12295__$1;
(statearr_12311_12328[(2)] = null);

(statearr_12311_12328[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12296 === (8))){
var inst_12281 = (state_12295[(8)]);
var inst_12280 = (state_12295[(2)]);
var inst_12281__$1 = fluree.db.util.async.throw_err.call(null,inst_12280);
var inst_12282 = (inst_12281__$1 == null);
var state_12295__$1 = (function (){var statearr_12312 = state_12295;
(statearr_12312[(8)] = inst_12281__$1);

return statearr_12312;
})();
if(cljs.core.truth_(inst_12282)){
var statearr_12313_12329 = state_12295__$1;
(statearr_12313_12329[(1)] = (9));

} else {
var statearr_12314_12330 = state_12295__$1;
(statearr_12314_12330[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2703__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2703__auto____0 = (function (){
var statearr_12315 = [null,null,null,null,null,null,null,null,null];
(statearr_12315[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2703__auto__);

(statearr_12315[(1)] = (1));

return statearr_12315;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2703__auto____1 = (function (state_12295){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_12295);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e12316){var ex__2706__auto__ = e12316;
var statearr_12317_12331 = state_12295;
(statearr_12317_12331[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_12295[(4)]))){
var statearr_12318_12332 = state_12295;
(statearr_12318_12332[(1)] = cljs.core.first.call(null,(state_12295[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12333 = state_12295;
state_12295 = G__12333;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2703__auto__ = function(state_12295){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2703__auto____1.call(this,state_12295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2703__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2703__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_12319 = f__2726__auto__.call(null);
(statearr_12319[(6)] = c__2725__auto__);

return statearr_12319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
