// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k28571,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__28575 = k28571;
var G__28575__$1 = (((G__28575 instanceof cljs.core.Keyword))?G__28575.fqn:null);
switch (G__28575__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k28571,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__28576){
var vec__28577 = p__28576;
var k__5367__auto__ = cljs.core.nth.call(null,vec__28577,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__28577,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28570){
var self__ = this;
var G__28570__$1 = this;
return (new cljs.core.RecordIter((0),G__28570__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28572,other28573){
var self__ = this;
var this28572__$1 = this;
return (((!((other28573 == null)))) && ((((this28572__$1.constructor === other28573.constructor)) && (((cljs.core._EQ_.call(null,this28572__$1.conn,other28573.conn)) && (((cljs.core._EQ_.call(null,this28572__$1.network,other28573.network)) && (((cljs.core._EQ_.call(null,this28572__$1.dbid,other28573.dbid)) && (((cljs.core._EQ_.call(null,this28572__$1.db_name,other28573.db_name)) && (((cljs.core._EQ_.call(null,this28572__$1.update_chan,other28573.update_chan)) && (((cljs.core._EQ_.call(null,this28572__$1.transact_chan,other28573.transact_chan)) && (((cljs.core._EQ_.call(null,this28572__$1.state,other28573.state)) && (((cljs.core._EQ_.call(null,this28572__$1.schema_cache,other28573.schema_cache)) && (((cljs.core._EQ_.call(null,this28572__$1.blank_db,other28573.blank_db)) && (((cljs.core._EQ_.call(null,this28572__$1.close,other28573.close)) && (((cljs.core._EQ_.call(null,this28572__$1.id,other28573.id)) && (cljs.core._EQ_.call(null,this28572__$1.__extmap,other28573.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k28571){
var self__ = this;
var this__5350__auto____$1 = this;
var G__28580 = k28571;
var G__28580__$1 = (((G__28580 instanceof cljs.core.Keyword))?G__28580.fqn:null);
switch (G__28580__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k28571);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__28570){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__28581 = cljs.core.keyword_identical_QMARK_;
var expr__28582 = k__5352__auto__;
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__28582))){
return (new fluree.db.session.DbSession(G__28570,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__28582))){
return (new fluree.db.session.DbSession(self__.conn,G__28570,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__28582))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__28570,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__28582))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__28570,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__28582))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__28570,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__28582))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__28570,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__28582))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__28570,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__28582))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__28570,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__28582))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__28570,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__28582))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__28570,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28581.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__28582))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__28570,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__28570),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__28570){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__28570,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__28574){
var extmap__5385__auto__ = (function (){var G__28584 = cljs.core.dissoc.call(null,G__28574,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__28574)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__28584);
} else {
return G__28584;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28574),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28574),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28574),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__28574),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__28574),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__28574),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__28574),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__28574),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__28574),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__28574),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__28574),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__28587 = session;
var map__28587__$1 = cljs.core.__destructure_map.call(null,map__28587);
var network = cljs.core.get.call(null,map__28587__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__28587__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,dbid){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28629){
var state_val_28630 = (state_28629[(1)]);
if((state_val_28630 === (7))){
var inst_28603 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not found on this ledger group."].join('');
var inst_28604 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28605 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28606 = cljs.core.PersistentHashMap.fromArrays(inst_28604,inst_28605);
var inst_28607 = cljs.core.ex_info.call(null,inst_28603,inst_28606);
var inst_28608 = (function(){throw inst_28607})();
var state_28629__$1 = state_28629;
var statearr_28631_28654 = state_28629__$1;
(statearr_28631_28654[(2)] = inst_28608);

(statearr_28631_28654[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (1))){
var state_28629__$1 = state_28629;
var statearr_28632_28655 = state_28629__$1;
(statearr_28632_28655[(2)] = null);

(statearr_28632_28655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (4))){
var inst_28588 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28633_28656 = state_28629__$1;
(statearr_28633_28656[(2)] = inst_28588);

(statearr_28633_28656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (6))){
var inst_28600 = (state_28629[(7)]);
var inst_28599 = (state_28629[(2)]);
var inst_28600__$1 = fluree.db.util.async.throw_err.call(null,inst_28599);
var inst_28601 = cljs.core.empty_QMARK_.call(null,inst_28600__$1);
var state_28629__$1 = (function (){var statearr_28634 = state_28629;
(statearr_28634[(7)] = inst_28600__$1);

return statearr_28634;
})();
if(inst_28601){
var statearr_28635_28657 = state_28629__$1;
(statearr_28635_28657[(1)] = (7));

} else {
var statearr_28636_28658 = state_28629__$1;
(statearr_28636_28658[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (3))){
var inst_28627 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28629__$1,inst_28627);
} else {
if((state_val_28630 === (12))){
var inst_28622 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28637_28659 = state_28629__$1;
(statearr_28637_28659[(2)] = inst_28622);

(statearr_28637_28659[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (2))){
var _ = (function (){var statearr_28638 = state_28629;
(statearr_28638[(4)] = cljs.core.cons.call(null,(5),(state_28629[(4)])));

return statearr_28638;
})();
var inst_28594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28595 = [network,dbid];
var inst_28596 = (new cljs.core.PersistentVector(null,2,(5),inst_28594,inst_28595,null));
var inst_28597 = fluree.db.operations.ledger_info_async.call(null,conn,inst_28596);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28629__$1,(6),inst_28597);
} else {
if((state_val_28630 === (11))){
var inst_28600 = (state_28629[(7)]);
var state_28629__$1 = state_28629;
var statearr_28640_28660 = state_28629__$1;
(statearr_28640_28660[(2)] = inst_28600);

(statearr_28640_28660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (9))){
var inst_28624 = (state_28629[(2)]);
var _ = (function (){var statearr_28641 = state_28629;
(statearr_28641[(4)] = cljs.core.rest.call(null,(state_28629[(4)])));

return statearr_28641;
})();
var state_28629__$1 = state_28629;
var statearr_28642_28661 = state_28629__$1;
(statearr_28642_28661[(2)] = inst_28624);

(statearr_28642_28661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (5))){
var _ = (function (){var statearr_28643 = state_28629;
(statearr_28643[(4)] = cljs.core.rest.call(null,(state_28629[(4)])));

return statearr_28643;
})();
var state_28629__$1 = state_28629;
var ex28639 = (state_28629__$1[(2)]);
var statearr_28644_28662 = state_28629__$1;
(statearr_28644_28662[(5)] = ex28639);


if((ex28639 instanceof Error)){
var statearr_28645_28663 = state_28629__$1;
(statearr_28645_28663[(1)] = (4));

(statearr_28645_28663[(5)] = null);

} else {
throw ex28639;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (10))){
var inst_28600 = (state_28629[(7)]);
var inst_28613 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_28600);
var inst_28614 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28613),"."].join('');
var inst_28615 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28616 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28617 = cljs.core.PersistentHashMap.fromArrays(inst_28615,inst_28616);
var inst_28618 = cljs.core.ex_info.call(null,inst_28614,inst_28617);
var inst_28619 = (function(){throw inst_28618})();
var state_28629__$1 = state_28629;
var statearr_28646_28664 = state_28629__$1;
(statearr_28646_28664[(2)] = inst_28619);

(statearr_28646_28664[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (8))){
var inst_28600 = (state_28629[(7)]);
var inst_28610 = fluree.db.session.ready_QMARK_.call(null,inst_28600);
var inst_28611 = (!(inst_28610));
var state_28629__$1 = state_28629;
if(inst_28611){
var statearr_28647_28665 = state_28629__$1;
(statearr_28647_28665[(1)] = (10));

} else {
var statearr_28648_28666 = state_28629__$1;
(statearr_28648_28666[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2703__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2703__auto____0 = (function (){
var statearr_28649 = [null,null,null,null,null,null,null,null];
(statearr_28649[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2703__auto__);

(statearr_28649[(1)] = (1));

return statearr_28649;
});
var fluree$db$session$load_ledger_info_$_state_machine__2703__auto____1 = (function (state_28629){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28629);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28650){var ex__2706__auto__ = e28650;
var statearr_28651_28667 = state_28629;
(statearr_28651_28667[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28629[(4)]))){
var statearr_28652_28668 = state_28629;
(statearr_28652_28668[(1)] = cljs.core.first.call(null,(state_28629[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28669 = state_28629;
state_28629 = G__28669;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2703__auto__ = function(state_28629){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2703__auto____1.call(this,state_28629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2703__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2703__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28653 = f__2726__auto__.call(null);
(statearr_28653[(6)] = c__2725__auto__);

return statearr_28653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__28670){
var map__28671 = p__28670;
var map__28671__$1 = cljs.core.__destructure_map.call(null,map__28671);
var blank_db = map__28671__$1;
var network = cljs.core.get.call(null,map__28671__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__28671__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28746){
var state_val_28747 = (state_28746[(1)]);
if((state_val_28747 === (7))){
var inst_28689 = (state_28746[(7)]);
var inst_28688 = (state_28746[(2)]);
var inst_28689__$1 = fluree.db.util.async.throw_err.call(null,inst_28688);
var state_28746__$1 = (function (){var statearr_28748 = state_28746;
(statearr_28748[(7)] = inst_28689__$1);

return statearr_28748;
})();
if(cljs.core.truth_(inst_28689__$1)){
var statearr_28749_28784 = state_28746__$1;
(statearr_28749_28784[(1)] = (8));

} else {
var statearr_28750_28785 = state_28746__$1;
(statearr_28750_28785[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (20))){
var inst_28694 = (state_28746[(8)]);
var inst_28727 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28694)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid),"."].join('');
var inst_28728 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28729 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_28730 = cljs.core.PersistentHashMap.fromArrays(inst_28728,inst_28729);
var inst_28731 = cljs.core.ex_info.call(null,inst_28727,inst_28730);
var inst_28732 = (function(){throw inst_28731})();
var state_28746__$1 = state_28746;
var statearr_28751_28786 = state_28746__$1;
(statearr_28751_28786[(2)] = inst_28732);

(statearr_28751_28786[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (1))){
var state_28746__$1 = state_28746;
var statearr_28752_28787 = state_28746__$1;
(statearr_28752_28787[(2)] = null);

(statearr_28752_28787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (4))){
var inst_28672 = (state_28746[(2)]);
var state_28746__$1 = state_28746;
var statearr_28753_28788 = state_28746__$1;
(statearr_28753_28788[(2)] = inst_28672);

(statearr_28753_28788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (15))){
var inst_28736 = (state_28746[(2)]);
var state_28746__$1 = state_28746;
var statearr_28754_28789 = state_28746__$1;
(statearr_28754_28789[(2)] = inst_28736);

(statearr_28754_28789[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (21))){
var inst_28734 = (state_28746[(2)]);
var state_28746__$1 = state_28746;
var statearr_28755_28790 = state_28746__$1;
(statearr_28755_28790[(2)] = inst_28734);

(statearr_28755_28790[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (13))){
var inst_28693 = (state_28746[(9)]);
var inst_28698 = fluree.db.query.schema.schema_map.call(null,inst_28693);
var inst_28699 = fluree.db.query.schema.setting_map.call(null,inst_28693);
var inst_28700 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_28693);
var inst_28701 = cljs.core.swap_BANG_.call(null,inst_28700,cljs.core.empty);
var state_28746__$1 = (function (){var statearr_28756 = state_28746;
(statearr_28756[(10)] = inst_28699);

(statearr_28756[(11)] = inst_28701);

return statearr_28756;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28746__$1,(16),inst_28698);
} else {
if((state_val_28747 === (22))){
var inst_28694 = (state_28746[(8)]);
var inst_28722 = (state_28746[(2)]);
var inst_28723 = fluree.db.util.async.throw_err.call(null,inst_28722);
var inst_28724 = (inst_28694 + (1));
var inst_28693 = inst_28723;
var inst_28694__$1 = inst_28724;
var state_28746__$1 = (function (){var statearr_28757 = state_28746;
(statearr_28757[(8)] = inst_28694__$1);

(statearr_28757[(9)] = inst_28693);

return statearr_28757;
})();
var statearr_28758_28791 = state_28746__$1;
(statearr_28758_28791[(2)] = null);

(statearr_28758_28791[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (6))){
var inst_28681 = (state_28746[(2)]);
var inst_28682 = fluree.db.util.async.throw_err.call(null,inst_28681);
var inst_28683 = cljs.core.__destructure_map.call(null,inst_28682);
var inst_28684 = cljs.core.get.call(null,inst_28683,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28685 = cljs.core.get.call(null,inst_28683,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_28686 = fluree.db.storage.core.reify_db.call(null,conn,network,dbid,blank_db,inst_28685);
var state_28746__$1 = (function (){var statearr_28759 = state_28746;
(statearr_28759[(12)] = inst_28684);

return statearr_28759;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28746__$1,(7),inst_28686);
} else {
if((state_val_28747 === (17))){
var inst_28704 = (state_28746[(13)]);
var inst_28693 = (state_28746[(9)]);
var inst_28706 = (state_28746[(2)]);
var inst_28707 = fluree.db.util.async.throw_err.call(null,inst_28706);
var inst_28708 = cljs.core.assoc.call(null,inst_28693,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_28704,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_28707);
var state_28746__$1 = state_28746;
var statearr_28760_28792 = state_28746__$1;
(statearr_28760_28792[(2)] = inst_28708);

(statearr_28760_28792[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (3))){
var inst_28744 = (state_28746[(2)]);
var state_28746__$1 = state_28746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28746__$1,inst_28744);
} else {
if((state_val_28747 === (12))){
var inst_28738 = (state_28746[(2)]);
var state_28746__$1 = state_28746;
var statearr_28761_28793 = state_28746__$1;
(statearr_28761_28793[(2)] = inst_28738);

(statearr_28761_28793[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (2))){
var _ = (function (){var statearr_28762 = state_28746;
(statearr_28762[(4)] = cljs.core.cons.call(null,(5),(state_28746[(4)])));

return statearr_28762;
})();
var inst_28679 = fluree.db.session.load_ledger_info.call(null,conn,network,dbid);
var state_28746__$1 = state_28746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28746__$1,(6),inst_28679);
} else {
if((state_val_28747 === (19))){
var inst_28713 = (state_28746[(14)]);
var inst_28693 = (state_28746[(9)]);
var inst_28716 = cljs.core.__destructure_map.call(null,inst_28713);
var inst_28717 = cljs.core.get.call(null,inst_28716,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_28718 = cljs.core.get.call(null,inst_28716,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28719 = cljs.core.get.call(null,inst_28716,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_28720 = fluree.db.dbproto._with.call(null,inst_28693,inst_28718,inst_28717);
var state_28746__$1 = (function (){var statearr_28763 = state_28746;
(statearr_28763[(15)] = inst_28719);

return statearr_28763;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28746__$1,(22),inst_28720);
} else {
if((state_val_28747 === (11))){
var inst_28694 = (state_28746[(8)]);
var inst_28684 = (state_28746[(12)]);
var inst_28696 = (inst_28694 > inst_28684);
var state_28746__$1 = state_28746;
if(cljs.core.truth_(inst_28696)){
var statearr_28765_28794 = state_28746__$1;
(statearr_28765_28794[(1)] = (13));

} else {
var statearr_28766_28795 = state_28746__$1;
(statearr_28766_28795[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (9))){
var state_28746__$1 = state_28746;
var statearr_28767_28796 = state_28746__$1;
(statearr_28767_28796[(2)] = null);

(statearr_28767_28796[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (5))){
var _ = (function (){var statearr_28768 = state_28746;
(statearr_28768[(4)] = cljs.core.rest.call(null,(state_28746[(4)])));

return statearr_28768;
})();
var state_28746__$1 = state_28746;
var ex28764 = (state_28746__$1[(2)]);
var statearr_28769_28797 = state_28746__$1;
(statearr_28769_28797[(5)] = ex28764);


if((ex28764 instanceof Error)){
var statearr_28770_28798 = state_28746__$1;
(statearr_28770_28798[(1)] = (4));

(statearr_28770_28798[(5)] = null);

} else {
throw ex28764;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (14))){
var inst_28694 = (state_28746[(8)]);
var inst_28710 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_28694);
var state_28746__$1 = state_28746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28746__$1,(18),inst_28710);
} else {
if((state_val_28747 === (16))){
var inst_28699 = (state_28746[(10)]);
var inst_28703 = (state_28746[(2)]);
var inst_28704 = fluree.db.util.async.throw_err.call(null,inst_28703);
var state_28746__$1 = (function (){var statearr_28771 = state_28746;
(statearr_28771[(13)] = inst_28704);

return statearr_28771;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28746__$1,(17),inst_28699);
} else {
if((state_val_28747 === (10))){
var inst_28741 = (state_28746[(2)]);
var _ = (function (){var statearr_28772 = state_28746;
(statearr_28772[(4)] = cljs.core.rest.call(null,(state_28746[(4)])));

return statearr_28772;
})();
var state_28746__$1 = state_28746;
var statearr_28773_28799 = state_28746__$1;
(statearr_28773_28799[(2)] = inst_28741);

(statearr_28773_28799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (18))){
var inst_28713 = (state_28746[(14)]);
var inst_28712 = (state_28746[(2)]);
var inst_28713__$1 = fluree.db.util.async.throw_err.call(null,inst_28712);
var state_28746__$1 = (function (){var statearr_28774 = state_28746;
(statearr_28774[(14)] = inst_28713__$1);

return statearr_28774;
})();
if(cljs.core.truth_(inst_28713__$1)){
var statearr_28775_28800 = state_28746__$1;
(statearr_28775_28800[(1)] = (19));

} else {
var statearr_28776_28801 = state_28746__$1;
(statearr_28776_28801[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28747 === (8))){
var inst_28689 = (state_28746[(7)]);
var inst_28691 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28689);
var inst_28692 = (inst_28691 + (1));
var inst_28693 = inst_28689;
var inst_28694 = inst_28692;
var state_28746__$1 = (function (){var statearr_28777 = state_28746;
(statearr_28777[(8)] = inst_28694);

(statearr_28777[(9)] = inst_28693);

return statearr_28777;
})();
var statearr_28778_28802 = state_28746__$1;
(statearr_28778_28802[(2)] = null);

(statearr_28778_28802[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2703__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2703__auto____0 = (function (){
var statearr_28779 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28779[(0)] = fluree$db$session$load_current_db_$_state_machine__2703__auto__);

(statearr_28779[(1)] = (1));

return statearr_28779;
});
var fluree$db$session$load_current_db_$_state_machine__2703__auto____1 = (function (state_28746){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28780){var ex__2706__auto__ = e28780;
var statearr_28781_28803 = state_28746;
(statearr_28781_28803[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28746[(4)]))){
var statearr_28782_28804 = state_28746;
(statearr_28782_28804[(1)] = cljs.core.first.call(null,(state_28746[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28805 = state_28746;
state_28746 = G__28805;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2703__auto__ = function(state_28746){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2703__auto____1.call(this,state_28746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2703__auto____0;
fluree$db$session$load_current_db_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2703__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28783 = f__2726__auto__.call(null);
(statearr_28783[(6)] = c__2725__auto__);

return statearr_28783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__28806,old_db_ch,new_db_ch){
var map__28807 = p__28806;
var map__28807__$1 = cljs.core.__destructure_map.call(null,map__28807);
var state = cljs.core.get.call(null,map__28807__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (p__28808){
var map__28809 = p__28808;
var map__28809__$1 = cljs.core.__destructure_map.call(null,map__28809);
var s = map__28809__$1;
var current = cljs.core.get.call(null,map__28809__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.call(null,current,old_db_ch)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__28810){
var map__28811 = p__28810;
var map__28811__$1 = cljs.core.__destructure_map.call(null,map__28811);
var state = cljs.core.get.call(null,map__28811__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__28812){
var map__28813 = p__28812;
var map__28813__$1 = cljs.core.__destructure_map.call(null,map__28813);
var conn = cljs.core.get.call(null,map__28813__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.call(null,map__28813__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.call(null,map__28813__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.call(null);
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2725__auto___28850 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28833){
var state_val_28834 = (state_28833[(1)]);
if((state_val_28834 === (1))){
var state_28833__$1 = state_28833;
var statearr_28835_28851 = state_28833__$1;
(statearr_28835_28851[(2)] = null);

(statearr_28835_28851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (2))){
var _ = (function (){var statearr_28836 = state_28833;
(statearr_28836[(4)] = cljs.core.cons.call(null,(5),(state_28833[(4)])));

return statearr_28836;
})();
var inst_28823 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_28833__$1 = state_28833;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28833__$1,(6),inst_28823);
} else {
if((state_val_28834 === (3))){
var inst_28831 = (state_28833[(2)]);
var state_28833__$1 = state_28833;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28833__$1,inst_28831);
} else {
if((state_val_28834 === (4))){
var inst_28814 = (state_28833[(2)]);
var inst_28815 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_28816 = fluree.db.util.log.error.call(null,inst_28814,"Error reloading db");
var inst_28817 = cljs.core.async.put_BANG_.call(null,db_ch,inst_28814);
var state_28833__$1 = (function (){var statearr_28838 = state_28833;
(statearr_28838[(7)] = inst_28816);

(statearr_28838[(8)] = inst_28815);

return statearr_28838;
})();
var statearr_28839_28852 = state_28833__$1;
(statearr_28839_28852[(2)] = inst_28817);

(statearr_28839_28852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (5))){
var _ = (function (){var statearr_28840 = state_28833;
(statearr_28840[(4)] = cljs.core.rest.call(null,(state_28833[(4)])));

return statearr_28840;
})();
var state_28833__$1 = state_28833;
var ex28837 = (state_28833__$1[(2)]);
var statearr_28841_28853 = state_28833__$1;
(statearr_28841_28853[(5)] = ex28837);


var statearr_28842_28854 = state_28833__$1;
(statearr_28842_28854[(1)] = (4));

(statearr_28842_28854[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28834 === (6))){
var inst_28825 = (state_28833[(2)]);
var inst_28826 = fluree.db.util.async.throw_err.call(null,inst_28825);
var state_28833__$1 = state_28833;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28833__$1,(7),db_ch,inst_28826);
} else {
if((state_val_28834 === (7))){
var inst_28828 = (state_28833[(2)]);
var _ = (function (){var statearr_28843 = state_28833;
(statearr_28843[(4)] = cljs.core.rest.call(null,(state_28833[(4)])));

return statearr_28843;
})();
var state_28833__$1 = state_28833;
var statearr_28844_28855 = state_28833__$1;
(statearr_28844_28855[(2)] = inst_28828);

(statearr_28844_28855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2703__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2703__auto____0 = (function (){
var statearr_28845 = [null,null,null,null,null,null,null,null,null];
(statearr_28845[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2703__auto__);

(statearr_28845[(1)] = (1));

return statearr_28845;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2703__auto____1 = (function (state_28833){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28833);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28846){var ex__2706__auto__ = e28846;
var statearr_28847_28856 = state_28833;
(statearr_28847_28856[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28833[(4)]))){
var statearr_28848_28857 = state_28833;
(statearr_28848_28857[(1)] = cljs.core.first.call(null,(state_28833[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28858 = state_28833;
state_28833 = G__28858;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2703__auto__ = function(state_28833){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2703__auto____1.call(this,state_28833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2703__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2703__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28849 = f__2726__auto__.call(null);
(statearr_28849[(6)] = c__2725__auto___28850);

return statearr_28849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__28860 = arguments.length;
switch (G__28860) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__28861){
var map__28862 = p__28861;
var map__28862__$1 = cljs.core.__destructure_map.call(null,map__28862);
var session = map__28862__$1;
var blank_db = cljs.core.get.call(null,map__28862__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.call(null,session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__28863,blank_db){
var map__28864 = p__28863;
var map__28864__$1 = cljs.core.__destructure_map.call(null,map__28864);
var session = map__28864__$1;
var conn = cljs.core.get.call(null,map__28864__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.call(null,map__28864__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (s){
return cljs.core.update.call(null,cljs.core.assoc.call(null,s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null)),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.call(null);
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (s){
if(cljs.core.not.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.call(null,cur_ch,state_ch)){
var c__2725__auto___28902 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28884){
var state_val_28885 = (state_28884[(1)]);
if((state_val_28885 === (1))){
var state_28884__$1 = state_28884;
var statearr_28886_28903 = state_28884__$1;
(statearr_28886_28903[(2)] = null);

(statearr_28886_28903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28885 === (2))){
var _ = (function (){var statearr_28887 = state_28884;
(statearr_28887[(4)] = cljs.core.cons.call(null,(5),(state_28884[(4)])));

return statearr_28887;
})();
var inst_28874 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_28884__$1 = state_28884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28884__$1,(6),inst_28874);
} else {
if((state_val_28885 === (3))){
var inst_28882 = (state_28884[(2)]);
var state_28884__$1 = state_28884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28884__$1,inst_28882);
} else {
if((state_val_28885 === (4))){
var inst_28865 = (state_28884[(2)]);
var inst_28866 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_28867 = fluree.db.util.log.error.call(null,inst_28865,"Error loading current db");
var inst_28868 = cljs.core.async.put_BANG_.call(null,cur_ch,inst_28865);
var state_28884__$1 = (function (){var statearr_28889 = state_28884;
(statearr_28889[(7)] = inst_28867);

(statearr_28889[(8)] = inst_28866);

return statearr_28889;
})();
var statearr_28890_28904 = state_28884__$1;
(statearr_28890_28904[(2)] = inst_28868);

(statearr_28890_28904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28885 === (5))){
var _ = (function (){var statearr_28891 = state_28884;
(statearr_28891[(4)] = cljs.core.rest.call(null,(state_28884[(4)])));

return statearr_28891;
})();
var state_28884__$1 = state_28884;
var ex28888 = (state_28884__$1[(2)]);
var statearr_28892_28905 = state_28884__$1;
(statearr_28892_28905[(5)] = ex28888);


var statearr_28893_28906 = state_28884__$1;
(statearr_28893_28906[(1)] = (4));

(statearr_28893_28906[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28885 === (6))){
var inst_28876 = (state_28884[(2)]);
var inst_28877 = fluree.db.util.async.throw_err.call(null,inst_28876);
var state_28884__$1 = state_28884;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28884__$1,(7),cur_ch,inst_28877);
} else {
if((state_val_28885 === (7))){
var inst_28879 = (state_28884[(2)]);
var _ = (function (){var statearr_28894 = state_28884;
(statearr_28894[(4)] = cljs.core.rest.call(null,(state_28884[(4)])));

return statearr_28894;
})();
var state_28884__$1 = state_28884;
var statearr_28895_28907 = state_28884__$1;
(statearr_28895_28907[(2)] = inst_28879);

(statearr_28895_28907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2703__auto__ = null;
var fluree$db$session$state_machine__2703__auto____0 = (function (){
var statearr_28896 = [null,null,null,null,null,null,null,null,null];
(statearr_28896[(0)] = fluree$db$session$state_machine__2703__auto__);

(statearr_28896[(1)] = (1));

return statearr_28896;
});
var fluree$db$session$state_machine__2703__auto____1 = (function (state_28884){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28897){var ex__2706__auto__ = e28897;
var statearr_28898_28908 = state_28884;
(statearr_28898_28908[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28884[(4)]))){
var statearr_28899_28909 = state_28884;
(statearr_28899_28909[(1)] = cljs.core.first.call(null,(state_28884[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28910 = state_28884;
state_28884 = G__28910;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$session$state_machine__2703__auto__ = function(state_28884){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2703__auto____1.call(this,state_28884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2703__auto____0;
fluree$db$session$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2703__auto____1;
return fluree$db$session$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28900 = f__2726__auto__.call(null);
(statearr_28900[(6)] = c__2725__auto___28902);

return statearr_28900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28912){
var state_val_28913 = (state_28912[(1)]);
if((state_val_28913 === (1))){
var state_28912__$1 = state_28912;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28912__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2703__auto__ = null;
var fluree$db$session$state_machine__2703__auto____0 = (function (){
var statearr_28914 = [null,null,null,null,null,null,null];
(statearr_28914[(0)] = fluree$db$session$state_machine__2703__auto__);

(statearr_28914[(1)] = (1));

return statearr_28914;
});
var fluree$db$session$state_machine__2703__auto____1 = (function (state_28912){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28912);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e28915){var ex__2706__auto__ = e28915;
var statearr_28916_28919 = state_28912;
(statearr_28916_28919[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28912[(4)]))){
var statearr_28917_28920 = state_28912;
(statearr_28917_28920[(1)] = cljs.core.first.call(null,(state_28912[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28921 = state_28912;
state_28912 = G__28921;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$session$state_machine__2703__auto__ = function(state_28912){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2703__auto____1.call(this,state_28912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2703__auto____0;
fluree$db$session$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2703__auto____1;
return fluree$db$session$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_28918 = f__2726__auto__.call(null);
(statearr_28918[(6)] = c__2725__auto__);

return statearr_28918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__28922){
var map__28923 = p__28922;
var map__28923__$1 = cljs.core.__destructure_map.call(null,map__28923);
var data = map__28923__$1;
var block = cljs.core.get.call(null,map__28923__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__28923__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__28923__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_28982){
var state_val_28983 = (state_28982[(1)]);
if((state_val_28983 === (7))){
var inst_28934 = (state_28982[(7)]);
var inst_28937 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28938 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28939 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28937),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28938),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28934),". No-op."].join('');
var inst_28940 = fluree.db.util.log.info.call(null,inst_28939);
var state_28982__$1 = state_28982;
var statearr_28984_29018 = state_28982__$1;
(statearr_28984_29018[(2)] = inst_28940);

(statearr_28984_29018[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (1))){
var state_28982__$1 = state_28982;
var statearr_28985_29019 = state_28982__$1;
(statearr_28985_29019[(2)] = null);

(statearr_28985_29019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (4))){
var inst_28924 = (state_28982[(2)]);
var state_28982__$1 = state_28982;
var statearr_28986_29020 = state_28982__$1;
(statearr_28986_29020[(2)] = inst_28924);

(statearr_28986_29020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (15))){
var inst_28963 = (state_28982[(2)]);
var state_28982__$1 = state_28982;
var statearr_28987_29021 = state_28982__$1;
(statearr_28987_29021[(2)] = inst_28963);

(statearr_28987_29021[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (13))){
var inst_28954 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_28955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28956 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28957 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28958 = [inst_28956,inst_28957];
var inst_28959 = (new cljs.core.PersistentVector(null,2,(5),inst_28955,inst_28958,null));
var inst_28960 = fluree.db.conn_events.process_event.call(null,inst_28954,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_28959,data);
var state_28982__$1 = state_28982;
var statearr_28988_29022 = state_28982__$1;
(statearr_28988_29022[(2)] = inst_28960);

(statearr_28988_29022[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (6))){
var inst_28934 = (state_28982[(7)]);
var inst_28933 = (state_28982[(8)]);
var inst_28932 = (state_28982[(2)]);
var inst_28933__$1 = fluree.db.util.async.throw_err.call(null,inst_28932);
var inst_28934__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28933__$1);
var inst_28935 = (block <= inst_28934__$1);
var state_28982__$1 = (function (){var statearr_28989 = state_28982;
(statearr_28989[(7)] = inst_28934__$1);

(statearr_28989[(8)] = inst_28933__$1);

return statearr_28989;
})();
if(cljs.core.truth_(inst_28935)){
var statearr_28990_29023 = state_28982__$1;
(statearr_28990_29023[(1)] = (7));

} else {
var statearr_28991_29024 = state_28982__$1;
(statearr_28991_29024[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (17))){
var state_28982__$1 = state_28982;
var statearr_28992_29025 = state_28982__$1;
(statearr_28992_29025[(2)] = null);

(statearr_28992_29025[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (3))){
var inst_28980 = (state_28982[(2)]);
var state_28982__$1 = state_28982;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28982__$1,inst_28980);
} else {
if((state_val_28983 === (12))){
var inst_28975 = (state_28982[(2)]);
var state_28982__$1 = state_28982;
var statearr_28993_29026 = state_28982__$1;
(statearr_28993_29026[(2)] = inst_28975);

(statearr_28993_29026[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (2))){
var inst_28930 = (state_28982[(9)]);
var _ = (function (){var statearr_28994 = state_28982;
(statearr_28994[(4)] = cljs.core.cons.call(null,(5),(state_28982[(4)])));

return statearr_28994;
})();
var inst_28930__$1 = fluree.db.session.current_db.call(null,session);
var state_28982__$1 = (function (){var statearr_28995 = state_28982;
(statearr_28995[(9)] = inst_28930__$1);

return statearr_28995;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28982__$1,(6),inst_28930__$1);
} else {
if((state_val_28983 === (11))){
var state_28982__$1 = state_28982;
var statearr_28997_29027 = state_28982__$1;
(statearr_28997_29027[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (9))){
var inst_28977 = (state_28982[(2)]);
var _ = (function (){var statearr_28999 = state_28982;
(statearr_28999[(4)] = cljs.core.rest.call(null,(state_28982[(4)])));

return statearr_28999;
})();
var state_28982__$1 = state_28982;
var statearr_29000_29028 = state_28982__$1;
(statearr_29000_29028[(2)] = inst_28977);

(statearr_29000_29028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (5))){
var _ = (function (){var statearr_29001 = state_28982;
(statearr_29001[(4)] = cljs.core.rest.call(null,(state_28982[(4)])));

return statearr_29001;
})();
var state_28982__$1 = state_28982;
var ex28996 = (state_28982__$1[(2)]);
var statearr_29002_29029 = state_28982__$1;
(statearr_29002_29029[(5)] = ex28996);


if((ex28996 instanceof Error)){
var statearr_29003_29030 = state_28982__$1;
(statearr_29003_29030[(1)] = (4));

(statearr_29003_29030[(5)] = null);

} else {
throw ex28996;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (14))){
var state_28982__$1 = state_28982;
var statearr_29004_29031 = state_28982__$1;
(statearr_29004_29031[(2)] = null);

(statearr_29004_29031[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (16))){
var inst_28934 = (state_28982[(7)]);
var inst_28966 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28967 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28968 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28966),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28967),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28934),". Forcing a db reload."].join('');
var inst_28969 = fluree.db.util.log.info.call(null,inst_28968);
var inst_28970 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_28982__$1 = (function (){var statearr_29005 = state_28982;
(statearr_29005[(10)] = inst_28969);

return statearr_29005;
})();
var statearr_29006_29032 = state_28982__$1;
(statearr_29006_29032[(2)] = inst_28970);

(statearr_29006_29032[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (10))){
var inst_28934 = (state_28982[(7)]);
var inst_28933 = (state_28982[(8)]);
var inst_28930 = (state_28982[(9)]);
var inst_28945 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28946 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28947 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28945),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28946),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_28948 = fluree.db.util.log.trace.call(null,inst_28947);
var inst_28949 = (function (){var current_db_ch = inst_28930;
var current_db = inst_28933;
var current_block = inst_28934;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,f);
}
});
})();
var inst_28950 = cljs.core.map.call(null,inst_28949,flakes);
var inst_28951 = fluree.db.dbproto._with.call(null,inst_28933,block,inst_28950);
var inst_28952 = fluree.db.session.cas_db_BANG_.call(null,session,inst_28930,inst_28951);
var state_28982__$1 = (function (){var statearr_29007 = state_28982;
(statearr_29007[(11)] = inst_28948);

return statearr_29007;
})();
if(inst_28952){
var statearr_29008_29033 = state_28982__$1;
(statearr_29008_29033[(1)] = (13));

} else {
var statearr_29009_29034 = state_28982__$1;
(statearr_29009_29034[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (18))){
var inst_28973 = (state_28982[(2)]);
var state_28982__$1 = state_28982;
var statearr_29010_29035 = state_28982__$1;
(statearr_29010_29035[(2)] = inst_28973);

(statearr_29010_29035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28983 === (8))){
var inst_28934 = (state_28982[(7)]);
var inst_28942 = ((1) + inst_28934);
var inst_28943 = cljs.core._EQ_.call(null,block,inst_28942);
var state_28982__$1 = state_28982;
if(inst_28943){
var statearr_29011_29036 = state_28982__$1;
(statearr_29011_29036[(1)] = (10));

} else {
var statearr_29012_29037 = state_28982__$1;
(statearr_29012_29037[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2703__auto__ = null;
var fluree$db$session$state_machine__2703__auto____0 = (function (){
var statearr_29013 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29013[(0)] = fluree$db$session$state_machine__2703__auto__);

(statearr_29013[(1)] = (1));

return statearr_29013;
});
var fluree$db$session$state_machine__2703__auto____1 = (function (state_28982){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_28982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e29014){var ex__2706__auto__ = e29014;
var statearr_29015_29038 = state_28982;
(statearr_29015_29038[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_28982[(4)]))){
var statearr_29016_29039 = state_28982;
(statearr_29016_29039[(1)] = cljs.core.first.call(null,(state_28982[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29040 = state_28982;
state_28982 = G__29040;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$session$state_machine__2703__auto__ = function(state_28982){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2703__auto____1.call(this,state_28982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2703__auto____0;
fluree$db$session$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2703__auto____1;
return fluree$db$session$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_29017 = f__2726__auto__.call(null);
(statearr_29017[(6)] = c__2725__auto__);

return statearr_29017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_29047){
var state_val_29048 = (state_29047[(1)]);
if((state_val_29048 === (1))){
var inst_29041 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_29042 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29043 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29044 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29042),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29043)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_29045 = fluree.db.util.log.debug.call(null,inst_29044);
var state_29047__$1 = (function (){var statearr_29049 = state_29047;
(statearr_29049[(7)] = inst_29045);

(statearr_29049[(8)] = inst_29041);

return statearr_29049;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29047__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2703__auto__ = null;
var fluree$db$session$state_machine__2703__auto____0 = (function (){
var statearr_29050 = [null,null,null,null,null,null,null,null,null];
(statearr_29050[(0)] = fluree$db$session$state_machine__2703__auto__);

(statearr_29050[(1)] = (1));

return statearr_29050;
});
var fluree$db$session$state_machine__2703__auto____1 = (function (state_29047){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_29047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e29051){var ex__2706__auto__ = e29051;
var statearr_29052_29055 = state_29047;
(statearr_29052_29055[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_29047[(4)]))){
var statearr_29053_29056 = state_29047;
(statearr_29053_29056[(1)] = cljs.core.first.call(null,(state_29047[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29057 = state_29047;
state_29047 = G__29057;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$session$state_machine__2703__auto__ = function(state_29047){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2703__auto____1.call(this,state_29047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2703__auto____0;
fluree$db$session$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2703__auto____1;
return fluree$db$session$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_29054 = f__2726__auto__.call(null);
(statearr_29054[(6)] = c__2725__auto__);

return statearr_29054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__29059 = arguments.length;
switch (G__29059) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__29060){
var map__29061 = p__29060;
var map__29061__$1 = cljs.core.__destructure_map.call(null,map__29061);
var session = map__29061__$1;
var conn = cljs.core.get.call(null,map__29061__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__29061__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__29061__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__29061__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__29061__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__29061__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__29061__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5802__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_29115){
var state_val_29116 = (state_29115[(1)]);
if((state_val_29116 === (7))){
var inst_29111 = (state_29115[(2)]);
var state_29115__$1 = state_29115;
var statearr_29117_29148 = state_29115__$1;
(statearr_29117_29148[(2)] = inst_29111);

(statearr_29117_29148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (1))){
var state_29115__$1 = state_29115;
var statearr_29118_29149 = state_29115__$1;
(statearr_29118_29149[(2)] = null);

(statearr_29118_29149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (4))){
var inst_29066 = (state_29115[(7)]);
var inst_29065 = (state_29115[(2)]);
var inst_29066__$1 = fluree.db.util.async.throw_err.call(null,inst_29065);
var inst_29067 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_29068 = (inst_29066__$1 == null);
var state_29115__$1 = (function (){var statearr_29119 = state_29115;
(statearr_29119[(8)] = inst_29067);

(statearr_29119[(7)] = inst_29066__$1);

return statearr_29119;
})();
if(cljs.core.truth_(inst_29068)){
var statearr_29120_29150 = state_29115__$1;
(statearr_29120_29150[(1)] = (5));

} else {
var statearr_29121_29151 = state_29115__$1;
(statearr_29121_29151[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (15))){
var inst_29103 = (state_29115[(2)]);
var state_29115__$1 = (function (){var statearr_29122 = state_29115;
(statearr_29122[(9)] = inst_29103);

return statearr_29122;
})();
var statearr_29123_29152 = state_29115__$1;
(statearr_29123_29152[(2)] = null);

(statearr_29123_29152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (13))){
var inst_29107 = (state_29115[(2)]);
var state_29115__$1 = state_29115;
var statearr_29125_29153 = state_29115__$1;
(statearr_29125_29153[(2)] = inst_29107);

(statearr_29125_29153[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (6))){
var inst_29067 = (state_29115[(8)]);
var inst_29073 = (inst_29067 == null);
var state_29115__$1 = state_29115;
if(cljs.core.truth_(inst_29073)){
var statearr_29126_29154 = state_29115__$1;
(statearr_29126_29154[(1)] = (8));

} else {
var statearr_29127_29155 = state_29115__$1;
(statearr_29127_29155[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (17))){
var _ = (function (){var statearr_29128 = state_29115;
(statearr_29128[(4)] = cljs.core.rest.call(null,(state_29115[(4)])));

return statearr_29128;
})();
var state_29115__$1 = state_29115;
var ex29124 = (state_29115__$1[(2)]);
var statearr_29129_29156 = state_29115__$1;
(statearr_29129_29156[(5)] = ex29124);


var statearr_29130_29157 = state_29115__$1;
(statearr_29130_29157[(1)] = (16));

(statearr_29130_29157[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (3))){
var inst_29113 = (state_29115[(2)]);
var state_29115__$1 = state_29115;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29115__$1,inst_29113);
} else {
if((state_val_29116 === (12))){
var state_29115__$1 = state_29115;
var statearr_29131_29158 = state_29115__$1;
(statearr_29131_29158[(2)] = null);

(statearr_29131_29158[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (2))){
var state_29115__$1 = state_29115;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29115__$1,(4),update_chan);
} else {
if((state_val_29116 === (11))){
var state_29115__$1 = state_29115;
var statearr_29132_29159 = state_29115__$1;
(statearr_29132_29159[(2)] = null);

(statearr_29132_29159[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (9))){
var state_29115__$1 = state_29115;
var statearr_29133_29160 = state_29115__$1;
(statearr_29133_29160[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (5))){
var inst_29070 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_29071 = fluree.db.util.log.info.call(null,inst_29070);
var state_29115__$1 = state_29115;
var statearr_29135_29161 = state_29115__$1;
(statearr_29135_29161[(2)] = inst_29071);

(statearr_29135_29161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (14))){
var inst_29067 = (state_29115[(8)]);
var inst_29066 = (state_29115[(7)]);
var _ = (function (){var statearr_29136 = state_29115;
(statearr_29136[(4)] = cljs.core.cons.call(null,(17),(state_29115[(4)])));

return statearr_29136;
})();
var inst_29091 = cljs.core.nth.call(null,inst_29066,(0),null);
var inst_29092 = cljs.core.nth.call(null,inst_29066,(1),null);
var inst_29093 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_29094 = cljs.core.pr_str.call(null,inst_29066);
var inst_29095 = fluree.db.util.core.trunc.call(null,inst_29094,(200));
var inst_29096 = fluree.db.util.log.trace.call(null,inst_29093,inst_29095);
var inst_29097 = fluree.db.session.process_ledger_update.call(null,inst_29067,inst_29091,inst_29092);
var state_29115__$1 = (function (){var statearr_29137 = state_29115;
(statearr_29137[(10)] = inst_29096);

return statearr_29137;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29115__$1,(18),inst_29097);
} else {
if((state_val_29116 === (16))){
var inst_29066 = (state_29115[(7)]);
var inst_29081 = (state_29115[(2)]);
var inst_29082 = fluree.db.util.log.error.call(null,inst_29081,"Exception processing ledger updates for message: ",inst_29066);
var state_29115__$1 = state_29115;
var statearr_29138_29162 = state_29115__$1;
(statearr_29138_29162[(2)] = inst_29082);

(statearr_29138_29162[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (10))){
var inst_29109 = (state_29115[(2)]);
var state_29115__$1 = state_29115;
var statearr_29139_29163 = state_29115__$1;
(statearr_29139_29163[(2)] = inst_29109);

(statearr_29139_29163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (18))){
var inst_29099 = (state_29115[(2)]);
var inst_29100 = fluree.db.util.async.throw_err.call(null,inst_29099);
var _ = (function (){var statearr_29140 = state_29115;
(statearr_29140[(4)] = cljs.core.rest.call(null,(state_29115[(4)])));

return statearr_29140;
})();
var state_29115__$1 = state_29115;
var statearr_29141_29164 = state_29115__$1;
(statearr_29141_29164[(2)] = inst_29100);

(statearr_29141_29164[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29116 === (8))){
var inst_29066 = (state_29115[(7)]);
var inst_29075 = cljs.core.first.call(null,inst_29066);
var inst_29076 = cljs.core.pr_str.call(null,inst_29075);
var inst_29077 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_29076].join('');
var inst_29078 = fluree.db.util.log.warn.call(null,inst_29077);
var state_29115__$1 = state_29115;
var statearr_29142_29165 = state_29115__$1;
(statearr_29142_29165[(2)] = inst_29078);

(statearr_29142_29165[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2703__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2703__auto____0 = (function (){
var statearr_29143 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29143[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2703__auto__);

(statearr_29143[(1)] = (1));

return statearr_29143;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2703__auto____1 = (function (state_29115){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_29115);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e29144){var ex__2706__auto__ = e29144;
var statearr_29145_29166 = state_29115;
(statearr_29145_29166[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_29115[(4)]))){
var statearr_29146_29167 = state_29115;
(statearr_29146_29167[(1)] = cljs.core.first.call(null,(state_29115[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29168 = state_29115;
state_29115 = G__29168;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2703__auto__ = function(state_29115){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2703__auto____1.call(this,state_29115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2703__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2703__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_29147 = f__2726__auto__.call(null);
(statearr_29147[(6)] = c__2725__auto__);

return statearr_29147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__29169){
var map__29170 = p__29169;
var map__29170__$1 = cljs.core.__destructure_map.call(null,map__29170);
var network = cljs.core.get.call(null,map__29170__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__29170__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__29170__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__29170__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__29170__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__29170__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__29170__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__29170__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__29170__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,cljs.core.async.chan.call(null),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null),network,null,conn]));
var current_db_fn = cljs.core.partial.call(null,fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__29174 = block_result;
var map__29174__$1 = cljs.core.__destructure_map.call(null,map__29174);
var block = cljs.core.get.call(null,map__29174__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__29174__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__29174__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__29174__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__29174__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__29175 = tx_result;
var map__29175__$1 = cljs.core.__destructure_map.call(null,map__29175);
var t = cljs.core.get.call(null,map__29175__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__29175__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__29171_SHARP_){
return cljs.core._EQ_.call(null,t,p1__29171_SHARP_.t);
}):(function (p1__29172_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__29172_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__29173_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__29173_SHARP_))){
return cljs.core.nth.call(null,p1__29173_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__29176 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__29176,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__29176,(1),null);
var error = cljs.core.nth.call(null,vec__29176,(2),null);
var message = cljs.core.nth.call(null,vec__29176,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));

var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__29180 = arguments.length;
switch (G__29180) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__29181){
var map__29182 = p__29181;
var map__29182__$1 = cljs.core.__destructure_map.call(null,map__29182);
var state = cljs.core.get.call(null,map__29182__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__29182__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__29182__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__29182__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__29183 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__29183,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__29183,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__29183,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__29186 = cljs.core.seq.call(null,tids);
var chunk__29187 = null;
var count__29188 = (0);
var i__29189 = (0);
while(true){
if((i__29189 < count__29188)){
var tid = cljs.core._nth.call(null,chunk__29187,i__29189);
var temp__5804__auto___29302__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___29302__$1)){
var keyed_callbacks_29303 = temp__5804__auto___29302__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_29304 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__29230_29305 = cljs.core.seq.call(null,keyed_callbacks_29303);
var chunk__29231_29306 = null;
var count__29232_29307 = (0);
var i__29233_29308 = (0);
while(true){
if((i__29233_29308 < count__29232_29307)){
var vec__29242_29309 = cljs.core._nth.call(null,chunk__29231_29306,i__29233_29308);
var k_29310 = cljs.core.nth.call(null,vec__29242_29309,(0),null);
var f_29311 = cljs.core.nth.call(null,vec__29242_29309,(1),null);
try{f_29311.call(null,tx_response_29304);
}catch (e29245){var e_29312 = e29245;
fluree.db.util.log.error.call(null,e_29312,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__29313 = seq__29230_29305;
var G__29314 = chunk__29231_29306;
var G__29315 = count__29232_29307;
var G__29316 = (i__29233_29308 + (1));
seq__29230_29305 = G__29313;
chunk__29231_29306 = G__29314;
count__29232_29307 = G__29315;
i__29233_29308 = G__29316;
continue;
} else {
var temp__5804__auto___29317__$2 = cljs.core.seq.call(null,seq__29230_29305);
if(temp__5804__auto___29317__$2){
var seq__29230_29318__$1 = temp__5804__auto___29317__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29230_29318__$1)){
var c__5568__auto___29319 = cljs.core.chunk_first.call(null,seq__29230_29318__$1);
var G__29320 = cljs.core.chunk_rest.call(null,seq__29230_29318__$1);
var G__29321 = c__5568__auto___29319;
var G__29322 = cljs.core.count.call(null,c__5568__auto___29319);
var G__29323 = (0);
seq__29230_29305 = G__29320;
chunk__29231_29306 = G__29321;
count__29232_29307 = G__29322;
i__29233_29308 = G__29323;
continue;
} else {
var vec__29246_29324 = cljs.core.first.call(null,seq__29230_29318__$1);
var k_29325 = cljs.core.nth.call(null,vec__29246_29324,(0),null);
var f_29326 = cljs.core.nth.call(null,vec__29246_29324,(1),null);
try{f_29326.call(null,tx_response_29304);
}catch (e29249){var e_29327 = e29249;
fluree.db.util.log.error.call(null,e_29327,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__29328 = cljs.core.next.call(null,seq__29230_29318__$1);
var G__29329 = null;
var G__29330 = (0);
var G__29331 = (0);
seq__29230_29305 = G__29328;
chunk__29231_29306 = G__29329;
count__29232_29307 = G__29330;
i__29233_29308 = G__29331;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__29332 = seq__29186;
var G__29333 = chunk__29187;
var G__29334 = count__29188;
var G__29335 = (i__29189 + (1));
seq__29186 = G__29332;
chunk__29187 = G__29333;
count__29188 = G__29334;
i__29189 = G__29335;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__29186);
if(temp__5804__auto____$1){
var seq__29186__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29186__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__29186__$1);
var G__29336 = cljs.core.chunk_rest.call(null,seq__29186__$1);
var G__29337 = c__5568__auto__;
var G__29338 = cljs.core.count.call(null,c__5568__auto__);
var G__29339 = (0);
seq__29186 = G__29336;
chunk__29187 = G__29337;
count__29188 = G__29338;
i__29189 = G__29339;
continue;
} else {
var tid = cljs.core.first.call(null,seq__29186__$1);
var temp__5804__auto___29340__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___29340__$2)){
var keyed_callbacks_29341 = temp__5804__auto___29340__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_29342 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__29250_29343 = cljs.core.seq.call(null,keyed_callbacks_29341);
var chunk__29251_29344 = null;
var count__29252_29345 = (0);
var i__29253_29346 = (0);
while(true){
if((i__29253_29346 < count__29252_29345)){
var vec__29262_29347 = cljs.core._nth.call(null,chunk__29251_29344,i__29253_29346);
var k_29348 = cljs.core.nth.call(null,vec__29262_29347,(0),null);
var f_29349 = cljs.core.nth.call(null,vec__29262_29347,(1),null);
try{f_29349.call(null,tx_response_29342);
}catch (e29265){var e_29350 = e29265;
fluree.db.util.log.error.call(null,e_29350,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__29351 = seq__29250_29343;
var G__29352 = chunk__29251_29344;
var G__29353 = count__29252_29345;
var G__29354 = (i__29253_29346 + (1));
seq__29250_29343 = G__29351;
chunk__29251_29344 = G__29352;
count__29252_29345 = G__29353;
i__29253_29346 = G__29354;
continue;
} else {
var temp__5804__auto___29355__$3 = cljs.core.seq.call(null,seq__29250_29343);
if(temp__5804__auto___29355__$3){
var seq__29250_29356__$1 = temp__5804__auto___29355__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29250_29356__$1)){
var c__5568__auto___29357 = cljs.core.chunk_first.call(null,seq__29250_29356__$1);
var G__29358 = cljs.core.chunk_rest.call(null,seq__29250_29356__$1);
var G__29359 = c__5568__auto___29357;
var G__29360 = cljs.core.count.call(null,c__5568__auto___29357);
var G__29361 = (0);
seq__29250_29343 = G__29358;
chunk__29251_29344 = G__29359;
count__29252_29345 = G__29360;
i__29253_29346 = G__29361;
continue;
} else {
var vec__29266_29362 = cljs.core.first.call(null,seq__29250_29356__$1);
var k_29363 = cljs.core.nth.call(null,vec__29266_29362,(0),null);
var f_29364 = cljs.core.nth.call(null,vec__29266_29362,(1),null);
try{f_29364.call(null,tx_response_29342);
}catch (e29269){var e_29365 = e29269;
fluree.db.util.log.error.call(null,e_29365,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__29366 = cljs.core.next.call(null,seq__29250_29356__$1);
var G__29367 = null;
var G__29368 = (0);
var G__29369 = (0);
seq__29250_29343 = G__29366;
chunk__29251_29344 = G__29367;
count__29252_29345 = G__29368;
i__29253_29346 = G__29369;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__29370 = cljs.core.next.call(null,seq__29186__$1);
var G__29371 = null;
var G__29372 = (0);
var G__29373 = (0);
seq__29186 = G__29370;
chunk__29187 = G__29371;
count__29188 = G__29372;
i__29189 = G__29373;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_29374 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2725__auto___29375 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_29286){
var state_val_29287 = (state_29286[(1)]);
if((state_val_29287 === (1))){
var state_29286__$1 = state_29286;
var statearr_29288_29376 = state_29286__$1;
(statearr_29288_29376[(2)] = null);

(statearr_29288_29376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29287 === (2))){
var inst_29271 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_29286__$1 = state_29286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29286__$1,(4),inst_29271);
} else {
if((state_val_29287 === (3))){
var inst_29284 = (state_29286[(2)]);
var state_29286__$1 = state_29286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29286__$1,inst_29284);
} else {
if((state_val_29287 === (4))){
var inst_29273 = (state_29286[(7)]);
var inst_29273__$1 = (state_29286[(2)]);
var inst_29274 = (inst_29273__$1 == null);
var state_29286__$1 = (function (){var statearr_29289 = state_29286;
(statearr_29289[(7)] = inst_29273__$1);

return statearr_29289;
})();
if(cljs.core.truth_(inst_29274)){
var statearr_29290_29377 = state_29286__$1;
(statearr_29290_29377[(1)] = (5));

} else {
var statearr_29291_29378 = state_29286__$1;
(statearr_29291_29378[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29287 === (5))){
var inst_29276 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_29277 = fluree.db.util.log.info.call(null,inst_29276);
var state_29286__$1 = state_29286;
var statearr_29292_29379 = state_29286__$1;
(statearr_29292_29379[(2)] = inst_29277);

(statearr_29292_29379[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29287 === (6))){
var inst_29273 = (state_29286[(7)]);
var inst_29279 = transact_handler_29374.call(null,conn,inst_29273);
var state_29286__$1 = (function (){var statearr_29293 = state_29286;
(statearr_29293[(8)] = inst_29279);

return statearr_29293;
})();
var statearr_29294_29380 = state_29286__$1;
(statearr_29294_29380[(2)] = null);

(statearr_29294_29380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29287 === (7))){
var inst_29282 = (state_29286[(2)]);
var state_29286__$1 = state_29286;
var statearr_29295_29381 = state_29286__$1;
(statearr_29295_29381[(2)] = inst_29282);

(statearr_29295_29381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2703__auto__ = null;
var fluree$db$session$state_machine__2703__auto____0 = (function (){
var statearr_29296 = [null,null,null,null,null,null,null,null,null];
(statearr_29296[(0)] = fluree$db$session$state_machine__2703__auto__);

(statearr_29296[(1)] = (1));

return statearr_29296;
});
var fluree$db$session$state_machine__2703__auto____1 = (function (state_29286){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_29286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e29297){var ex__2706__auto__ = e29297;
var statearr_29298_29382 = state_29286;
(statearr_29298_29382[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_29286[(4)]))){
var statearr_29299_29383 = state_29286;
(statearr_29299_29383[(1)] = cljs.core.first.call(null,(state_29286[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29384 = state_29286;
state_29286 = G__29384;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$session$state_machine__2703__auto__ = function(state_29286){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2703__auto____1.call(this,state_29286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2703__auto____0;
fluree$db$session$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2703__auto____1;
return fluree$db$session$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_29300 = f__2726__auto__.call(null);
(statearr_29300[(6)] = c__2725__auto___29375);

return statearr_29300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__29387 = arguments.length;
switch (G__29387) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__29388 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__29385_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__29385_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__29388);
} else {
return G__29388;
}
})();
var seq__29389 = cljs.core.seq.call(null,sessions);
var chunk__29390 = null;
var count__29391 = (0);
var i__29392 = (0);
while(true){
if((i__29392 < count__29391)){
var session = cljs.core._nth.call(null,chunk__29390,i__29392);
fluree.db.session.close.call(null,session);


var G__29394 = seq__29389;
var G__29395 = chunk__29390;
var G__29396 = count__29391;
var G__29397 = (i__29392 + (1));
seq__29389 = G__29394;
chunk__29390 = G__29395;
count__29391 = G__29396;
i__29392 = G__29397;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__29389);
if(temp__5804__auto__){
var seq__29389__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29389__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__29389__$1);
var G__29398 = cljs.core.chunk_rest.call(null,seq__29389__$1);
var G__29399 = c__5568__auto__;
var G__29400 = cljs.core.count.call(null,c__5568__auto__);
var G__29401 = (0);
seq__29389 = G__29398;
chunk__29390 = G__29399;
count__29391 = G__29400;
i__29392 = G__29401;
continue;
} else {
var session = cljs.core.first.call(null,seq__29389__$1);
fluree.db.session.close.call(null,session);


var G__29402 = cljs.core.next.call(null,seq__29389__$1);
var G__29403 = null;
var G__29404 = (0);
var G__29405 = (0);
seq__29389 = G__29402;
chunk__29390 = G__29403;
count__29391 = G__29404;
i__29392 = G__29405;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
