// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_16575){
var state_val_16576 = (state_16575[(1)]);
if((state_val_16576 === (1))){
var state_16575__$1 = state_16575;
var statearr_16577_16591 = state_16575__$1;
(statearr_16577_16591[(2)] = null);

(statearr_16577_16591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16576 === (2))){
var _ = (function (){var statearr_16578 = state_16575;
(statearr_16578[(4)] = cljs.core.cons.call(null,(5),(state_16575[(4)])));

return statearr_16578;
})();
var inst_16566 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_16575__$1 = state_16575;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16575__$1,(6),inst_16566);
} else {
if((state_val_16576 === (3))){
var inst_16573 = (state_16575[(2)]);
var state_16575__$1 = state_16575;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16575__$1,inst_16573);
} else {
if((state_val_16576 === (4))){
var inst_16560 = (state_16575[(2)]);
var state_16575__$1 = state_16575;
var statearr_16580_16592 = state_16575__$1;
(statearr_16580_16592[(2)] = inst_16560);

(statearr_16580_16592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16576 === (5))){
var _ = (function (){var statearr_16581 = state_16575;
(statearr_16581[(4)] = cljs.core.rest.call(null,(state_16575[(4)])));

return statearr_16581;
})();
var state_16575__$1 = state_16575;
var ex16579 = (state_16575__$1[(2)]);
var statearr_16582_16593 = state_16575__$1;
(statearr_16582_16593[(5)] = ex16579);


if((ex16579 instanceof Error)){
var statearr_16583_16594 = state_16575__$1;
(statearr_16583_16594[(1)] = (4));

(statearr_16583_16594[(5)] = null);

} else {
throw ex16579;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16576 === (6))){
var inst_16568 = (state_16575[(2)]);
var inst_16569 = fluree.db.util.async.throw_err.call(null,inst_16568);
var inst_16570 = cljs.core.keyword.call(null,inst_16569);
var _ = (function (){var statearr_16584 = state_16575;
(statearr_16584[(4)] = cljs.core.rest.call(null,(state_16575[(4)])));

return statearr_16584;
})();
var state_16575__$1 = state_16575;
var statearr_16585_16595 = state_16575__$1;
(statearr_16585_16595[(2)] = inst_16570);

(statearr_16585_16595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto____0 = (function (){
var statearr_16586 = [null,null,null,null,null,null,null];
(statearr_16586[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto__);

(statearr_16586[(1)] = (1));

return statearr_16586;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto____1 = (function (state_16575){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_16575);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e16587){var ex__2706__auto__ = e16587;
var statearr_16588_16596 = state_16575;
(statearr_16588_16596[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_16575[(4)]))){
var statearr_16589_16597 = state_16575;
(statearr_16589_16597[(1)] = cljs.core.first.call(null,(state_16575[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16598 = state_16575;
state_16575 = G__16598;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto__ = function(state_16575){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto____1.call(this,state_16575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_16590 = f__2726__auto__.call(null);
(statearr_16590[(6)] = c__2725__auto__);

return statearr_16590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_16630){
var state_val_16631 = (state_16630[(1)]);
if((state_val_16631 === (7))){
var inst_16614 = (state_16630[(7)]);
var inst_16616 = cljs.core.empty_QMARK_.call(null,inst_16614);
var inst_16617 = (!(inst_16616));
var state_16630__$1 = state_16630;
var statearr_16632_16656 = state_16630__$1;
(statearr_16632_16656[(2)] = inst_16617);

(statearr_16632_16656[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16631 === (1))){
var state_16630__$1 = state_16630;
var statearr_16633_16657 = state_16630__$1;
(statearr_16633_16657[(2)] = null);

(statearr_16633_16657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16631 === (4))){
var inst_16600 = (state_16630[(2)]);
var state_16630__$1 = state_16630;
var statearr_16634_16658 = state_16630__$1;
(statearr_16634_16658[(2)] = inst_16600);

(statearr_16634_16658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16631 === (6))){
var inst_16614 = (state_16630[(7)]);
var inst_16606 = (state_16630[(8)]);
var inst_16612 = (state_16630[(2)]);
var inst_16613 = fluree.db.util.async.throw_err.call(null,inst_16612);
var inst_16614__$1 = cljs.core.map.call(null,inst_16606,inst_16613);
var state_16630__$1 = (function (){var statearr_16635 = state_16630;
(statearr_16635[(7)] = inst_16614__$1);

return statearr_16635;
})();
if(cljs.core.truth_(inst_16614__$1)){
var statearr_16636_16659 = state_16630__$1;
(statearr_16636_16659[(1)] = (7));

} else {
var statearr_16637_16660 = state_16630__$1;
(statearr_16637_16660[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16631 === (3))){
var inst_16628 = (state_16630[(2)]);
var state_16630__$1 = state_16630;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16630__$1,inst_16628);
} else {
if((state_val_16631 === (12))){
var inst_16625 = (state_16630[(2)]);
var _ = (function (){var statearr_16638 = state_16630;
(statearr_16638[(4)] = cljs.core.rest.call(null,(state_16630[(4)])));

return statearr_16638;
})();
var state_16630__$1 = state_16630;
var statearr_16639_16661 = state_16630__$1;
(statearr_16639_16661[(2)] = inst_16625);

(statearr_16639_16661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16631 === (2))){
var _ = (function (){var statearr_16640 = state_16630;
(statearr_16640[(4)] = cljs.core.cons.call(null,(5),(state_16630[(4)])));

return statearr_16640;
})();
var inst_16606 = (function (){return (function (p1__16599_SHARP_){
return p1__16599_SHARP_.o;
});
})();
var inst_16607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16608 = [pred_id];
var inst_16609 = (new cljs.core.PersistentVector(null,1,(5),inst_16607,inst_16608,null));
var inst_16610 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16609);
var state_16630__$1 = (function (){var statearr_16641 = state_16630;
(statearr_16641[(8)] = inst_16606);

return statearr_16641;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16630__$1,(6),inst_16610);
} else {
if((state_val_16631 === (11))){
var state_16630__$1 = state_16630;
var statearr_16643_16662 = state_16630__$1;
(statearr_16643_16662[(2)] = true);

(statearr_16643_16662[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16631 === (9))){
var inst_16620 = (state_16630[(2)]);
var state_16630__$1 = state_16630;
if(cljs.core.truth_(inst_16620)){
var statearr_16644_16663 = state_16630__$1;
(statearr_16644_16663[(1)] = (10));

} else {
var statearr_16645_16664 = state_16630__$1;
(statearr_16645_16664[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16631 === (5))){
var _ = (function (){var statearr_16646 = state_16630;
(statearr_16646[(4)] = cljs.core.rest.call(null,(state_16630[(4)])));

return statearr_16646;
})();
var state_16630__$1 = state_16630;
var ex16642 = (state_16630__$1[(2)]);
var statearr_16647_16665 = state_16630__$1;
(statearr_16647_16665[(5)] = ex16642);


if((ex16642 instanceof Error)){
var statearr_16648_16666 = state_16630__$1;
(statearr_16648_16666[(1)] = (4));

(statearr_16648_16666[(5)] = null);

} else {
throw ex16642;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16631 === (10))){
var inst_16614 = (state_16630[(7)]);
var inst_16622 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_16614);
var state_16630__$1 = state_16630;
var statearr_16649_16667 = state_16630__$1;
(statearr_16649_16667[(2)] = inst_16622);

(statearr_16649_16667[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16631 === (8))){
var inst_16614 = (state_16630[(7)]);
var state_16630__$1 = state_16630;
var statearr_16650_16668 = state_16630__$1;
(statearr_16650_16668[(2)] = inst_16614);

(statearr_16650_16668[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto____0 = (function (){
var statearr_16651 = [null,null,null,null,null,null,null,null,null];
(statearr_16651[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto__);

(statearr_16651[(1)] = (1));

return statearr_16651;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto____1 = (function (state_16630){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_16630);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e16652){var ex__2706__auto__ = e16652;
var statearr_16653_16669 = state_16630;
(statearr_16653_16669[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_16630[(4)]))){
var statearr_16654_16670 = state_16630;
(statearr_16654_16670[(1)] = cljs.core.first.call(null,(state_16630[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16671 = state_16630;
state_16630 = G__16671;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto__ = function(state_16630){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto____1.call(this,state_16630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_16655 = f__2726__auto__.call(null);
(statearr_16655[(6)] = c__2725__auto__);

return statearr_16655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_16752){
var state_val_16753 = (state_16752[(1)]);
if((state_val_16753 === (7))){
var state_16752__$1 = state_16752;
var statearr_16754_16791 = state_16752__$1;
(statearr_16754_16791[(2)] = flakes);

(statearr_16754_16791[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (20))){
var inst_16709 = (state_16752[(7)]);
var inst_16742 = (state_16752[(2)]);
var inst_16701 = inst_16709;
var inst_16702 = inst_16742;
var state_16752__$1 = (function (){var statearr_16755 = state_16752;
(statearr_16755[(8)] = inst_16701);

(statearr_16755[(9)] = inst_16702);

return statearr_16755;
})();
var statearr_16756_16792 = state_16752__$1;
(statearr_16756_16792[(2)] = null);

(statearr_16756_16792[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (1))){
var state_16752__$1 = state_16752;
var statearr_16757_16793 = state_16752__$1;
(statearr_16757_16793[(2)] = null);

(statearr_16757_16793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (4))){
var inst_16674 = (state_16752[(2)]);
var state_16752__$1 = state_16752;
var statearr_16758_16794 = state_16752__$1;
(statearr_16758_16794[(2)] = inst_16674);

(statearr_16758_16794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (15))){
var inst_16708 = (state_16752[(10)]);
var inst_16726 = inst_16708.o;
var state_16752__$1 = state_16752;
var statearr_16759_16795 = state_16752__$1;
(statearr_16759_16795[(2)] = inst_16726);

(statearr_16759_16795[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (13))){
var inst_16745 = (state_16752[(2)]);
var state_16752__$1 = state_16752;
var statearr_16760_16796 = state_16752__$1;
(statearr_16760_16796[(2)] = inst_16745);

(statearr_16760_16796[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (6))){
var inst_16681 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16752__$1 = state_16752;
var statearr_16761_16797 = state_16752__$1;
(statearr_16761_16797[(2)] = inst_16681);

(statearr_16761_16797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (17))){
var inst_16723 = (state_16752[(2)]);
var inst_16724 = fluree.db.util.async.throw_err.call(null,inst_16723);
var state_16752__$1 = state_16752;
var statearr_16762_16798 = state_16752__$1;
(statearr_16762_16798[(2)] = inst_16724);

(statearr_16762_16798[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (3))){
var inst_16750 = (state_16752[(2)]);
var state_16752__$1 = state_16752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16752__$1,inst_16750);
} else {
if((state_val_16753 === (12))){
var inst_16715 = (state_16752[(11)]);
var inst_16708 = (state_16752[(10)]);
var inst_16713 = inst_16708.p;
var inst_16714 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16713);
var inst_16715__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_16714);
var inst_16716 = inst_16708.op;
var inst_16717 = inst_16716 === false;
var inst_16718 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_16715__$1);
var state_16752__$1 = (function (){var statearr_16763 = state_16752;
(statearr_16763[(12)] = inst_16717);

(statearr_16763[(11)] = inst_16715__$1);

return statearr_16763;
})();
if(inst_16718){
var statearr_16764_16799 = state_16752__$1;
(statearr_16764_16799[(1)] = (14));

} else {
var statearr_16765_16800 = state_16752__$1;
(statearr_16765_16800[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (2))){
var _ = (function (){var statearr_16766 = state_16752;
(statearr_16766[(4)] = cljs.core.cons.call(null,(5),(state_16752[(4)])));

return statearr_16766;
})();
var state_16752__$1 = state_16752;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16767_16801 = state_16752__$1;
(statearr_16767_16801[(1)] = (6));

} else {
var statearr_16768_16802 = state_16752__$1;
(statearr_16768_16802[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (19))){
var inst_16728 = (state_16752[(13)]);
var inst_16715 = (state_16752[(11)]);
var inst_16708 = (state_16752[(10)]);
var inst_16702 = (state_16752[(9)]);
var inst_16736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16737 = inst_16708.s;
var inst_16738 = [inst_16737,inst_16715,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16739 = (new cljs.core.PersistentVector(null,3,(5),inst_16736,inst_16738,null));
var inst_16740 = cljs.core.assoc_in.call(null,inst_16702,inst_16739,inst_16728);
var state_16752__$1 = state_16752;
var statearr_16769_16803 = state_16752__$1;
(statearr_16769_16803[(2)] = inst_16740);

(statearr_16769_16803[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (11))){
var inst_16702 = (state_16752[(9)]);
var state_16752__$1 = state_16752;
var statearr_16771_16804 = state_16752__$1;
(statearr_16771_16804[(2)] = inst_16702);

(statearr_16771_16804[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (9))){
var inst_16701 = (state_16752[(8)]);
var inst_16708 = (state_16752[(10)]);
var inst_16707 = cljs.core.seq.call(null,inst_16701);
var inst_16708__$1 = cljs.core.first.call(null,inst_16707);
var inst_16709 = cljs.core.next.call(null,inst_16707);
var inst_16710 = cljs.core.not.call(null,inst_16708__$1);
var state_16752__$1 = (function (){var statearr_16772 = state_16752;
(statearr_16772[(7)] = inst_16709);

(statearr_16772[(10)] = inst_16708__$1);

return statearr_16772;
})();
if(inst_16710){
var statearr_16773_16805 = state_16752__$1;
(statearr_16773_16805[(1)] = (11));

} else {
var statearr_16774_16806 = state_16752__$1;
(statearr_16774_16806[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (5))){
var _ = (function (){var statearr_16775 = state_16752;
(statearr_16775[(4)] = cljs.core.rest.call(null,(state_16752[(4)])));

return statearr_16775;
})();
var state_16752__$1 = state_16752;
var ex16770 = (state_16752__$1[(2)]);
var statearr_16776_16807 = state_16752__$1;
(statearr_16776_16807[(5)] = ex16770);


if((ex16770 instanceof Error)){
var statearr_16777_16808 = state_16752__$1;
(statearr_16777_16808[(1)] = (4));

(statearr_16777_16808[(5)] = null);

} else {
throw ex16770;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (14))){
var inst_16708 = (state_16752[(10)]);
var inst_16720 = inst_16708.o;
var inst_16721 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_16720,db);
var state_16752__$1 = state_16752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16752__$1,(17),inst_16721);
} else {
if((state_val_16753 === (16))){
var inst_16717 = (state_16752[(12)]);
var inst_16728 = (state_16752[(2)]);
var state_16752__$1 = (function (){var statearr_16778 = state_16752;
(statearr_16778[(13)] = inst_16728);

return statearr_16778;
})();
if(cljs.core.truth_(inst_16717)){
var statearr_16779_16809 = state_16752__$1;
(statearr_16779_16809[(1)] = (18));

} else {
var statearr_16780_16810 = state_16752__$1;
(statearr_16780_16810[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (10))){
var inst_16747 = (state_16752[(2)]);
var _ = (function (){var statearr_16781 = state_16752;
(statearr_16781[(4)] = cljs.core.rest.call(null,(state_16752[(4)])));

return statearr_16781;
})();
var state_16752__$1 = state_16752;
var statearr_16782_16811 = state_16752__$1;
(statearr_16782_16811[(2)] = inst_16747);

(statearr_16782_16811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (18))){
var inst_16728 = (state_16752[(13)]);
var inst_16715 = (state_16752[(11)]);
var inst_16708 = (state_16752[(10)]);
var inst_16702 = (state_16752[(9)]);
var inst_16730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16731 = inst_16708.s;
var inst_16732 = [inst_16731,inst_16715,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16733 = (new cljs.core.PersistentVector(null,3,(5),inst_16730,inst_16732,null));
var inst_16734 = cljs.core.assoc_in.call(null,inst_16702,inst_16733,inst_16728);
var state_16752__$1 = state_16752;
var statearr_16783_16812 = state_16752__$1;
(statearr_16783_16812[(2)] = inst_16734);

(statearr_16783_16812[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16753 === (8))){
var inst_16684 = (state_16752[(2)]);
var inst_16685 = cljs.core.PersistentHashSet.EMPTY;
var inst_16686 = cljs.core.vals.call(null,tempids);
var inst_16687 = cljs.core.into.call(null,inst_16685,inst_16686);
var inst_16688 = (function (){var pred_flakes = inst_16684;
var is_new_QMARK_ = inst_16687;
return (function (p1__16673_SHARP_,p2__16672_SHARP_){
var f = p2__16672_SHARP_;
return cljs.core.assoc_in.call(null,p1__16673_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,f.s)));
});
})();
var inst_16689 = cljs.core.PersistentHashMap.EMPTY;
var inst_16690 = cljs.core.reduce.call(null,inst_16688,inst_16689,inst_16684);
var inst_16698 = cljs.core.seq.call(null,inst_16684);
var inst_16699 = cljs.core.first.call(null,inst_16698);
var inst_16700 = cljs.core.next.call(null,inst_16698);
var inst_16701 = inst_16684;
var inst_16702 = inst_16690;
var state_16752__$1 = (function (){var statearr_16784 = state_16752;
(statearr_16784[(8)] = inst_16701);

(statearr_16784[(14)] = inst_16700);

(statearr_16784[(15)] = inst_16699);

(statearr_16784[(9)] = inst_16702);

return statearr_16784;
})();
var statearr_16785_16813 = state_16752__$1;
(statearr_16785_16813[(2)] = null);

(statearr_16785_16813[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto____0 = (function (){
var statearr_16786 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16786[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto__);

(statearr_16786[(1)] = (1));

return statearr_16786;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto____1 = (function (state_16752){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_16752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e16787){var ex__2706__auto__ = e16787;
var statearr_16788_16814 = state_16752;
(statearr_16788_16814[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_16752[(4)]))){
var statearr_16789_16815 = state_16752;
(statearr_16789_16815[(1)] = cljs.core.first.call(null,(state_16752[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16816 = state_16752;
state_16752 = G__16816;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto__ = function(state_16752){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto____1.call(this,state_16752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_16790 = f__2726__auto__.call(null);
(statearr_16790[(6)] = c__2725__auto__);

return statearr_16790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16818 = arguments.length;
switch (G__16818) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16821 = arguments.length;
switch (G__16821) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_17133){
var state_val_17134 = (state_17133[(1)]);
if((state_val_17134 === (121))){
var inst_17088 = (state_17133[(7)]);
var state_17133__$1 = state_17133;
var statearr_17135_17328 = state_17133__$1;
(statearr_17135_17328[(2)] = inst_17088);

(statearr_17135_17328[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (65))){
var inst_16987 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_16987)){
var statearr_17136_17329 = state_17133__$1;
(statearr_17136_17329[(1)] = (66));

} else {
var statearr_17137_17330 = state_17133__$1;
(statearr_17137_17330[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (70))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_16997 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16998 = inst_16993.call(null,cljs.core.PersistentArrayMap,null,3,inst_16997,null);
var inst_16999 = inst_16993.call(null,cljs.core.PersistentHashSet,null,inst_16998,null);
var inst_17000 = inst_16999.call(null,inst_16992);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_17000)){
var statearr_17138_17331 = state_17133__$1;
(statearr_17138_17331[(1)] = (72));

} else {
var statearr_17139_17332 = state_17133__$1;
(statearr_17139_17332[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (62))){
var inst_16977 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17140_17333 = state_17133__$1;
(statearr_17140_17333[(2)] = inst_16977);

(statearr_17140_17333[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (74))){
var inst_17083 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17141_17334 = state_17133__$1;
(statearr_17141_17334[(2)] = inst_17083);

(statearr_17141_17334[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (110))){
var inst_17110 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_17110)){
var statearr_17142_17335 = state_17133__$1;
(statearr_17142_17335[(1)] = (117));

} else {
var statearr_17143_17336 = state_17133__$1;
(statearr_17143_17336[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (7))){
var inst_17128 = (state_17133[(2)]);
var _ = (function (){var statearr_17144 = state_17133;
(statearr_17144[(4)] = cljs.core.rest.call(null,(state_17133[(4)])));

return statearr_17144;
})();
var state_17133__$1 = state_17133;
var statearr_17145_17337 = state_17133__$1;
(statearr_17145_17337[(2)] = inst_17128);

(statearr_17145_17337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (59))){
var inst_16861 = (state_17133[(10)]);
var inst_16981 = (state_17133[(11)]);
var inst_16980 = (state_17133[(2)]);
var inst_16981__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16861);
var state_17133__$1 = (function (){var statearr_17146 = state_17133;
(statearr_17146[(12)] = inst_16980);

(statearr_17146[(11)] = inst_16981__$1);

return statearr_17146;
})();
if(cljs.core.truth_(inst_16981__$1)){
var statearr_17147_17338 = state_17133__$1;
(statearr_17147_17338[(1)] = (63));

} else {
var statearr_17148_17339 = state_17133__$1;
(statearr_17148_17339[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (86))){
var inst_17023 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17149_17340 = state_17133__$1;
(statearr_17149_17340[(2)] = inst_17023);

(statearr_17149_17340[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (20))){
var inst_16887 = (state_17133[(13)]);
var inst_16861 = (state_17133[(10)]);
var inst_16887__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16861);
var state_17133__$1 = (function (){var statearr_17150 = state_17133;
(statearr_17150[(13)] = inst_16887__$1);

return statearr_17150;
})();
if(cljs.core.truth_(inst_16887__$1)){
var statearr_17151_17341 = state_17133__$1;
(statearr_17151_17341[(1)] = (23));

} else {
var statearr_17152_17342 = state_17133__$1;
(statearr_17152_17342[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (72))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17002 = fluree.db.query.schema.type_error.call(null,inst_16992,inst_16993,throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17153_17343 = state_17133__$1;
(statearr_17153_17343[(2)] = inst_17002);

(statearr_17153_17343[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (58))){
var inst_16942 = (state_17133[(14)]);
var state_17133__$1 = state_17133;
var statearr_17154_17344 = state_17133__$1;
(statearr_17154_17344[(2)] = inst_16942);

(statearr_17154_17344[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (60))){
var inst_16860 = (state_17133[(15)]);
var inst_16849 = (state_17133[(16)]);
var inst_16968 = fluree.db.dbproto._p_prop.call(null,inst_16849,new cljs.core.Keyword(null,"name","name",1843675177),inst_16860);
var inst_16969 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16968)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16970 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16971 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16972 = cljs.core.PersistentHashMap.fromArrays(inst_16970,inst_16971);
var inst_16973 = cljs.core.ex_info.call(null,inst_16969,inst_16972);
var inst_16974 = (function(){throw inst_16973})();
var state_17133__$1 = state_17133;
var statearr_17155_17345 = state_17133__$1;
(statearr_17155_17345[(2)] = inst_16974);

(statearr_17155_17345[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (27))){
var inst_16890 = (state_17133[(17)]);
var state_17133__$1 = state_17133;
var statearr_17156_17346 = state_17133__$1;
(statearr_17156_17346[(2)] = inst_16890);

(statearr_17156_17346[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (1))){
var state_17133__$1 = state_17133;
var statearr_17157_17347 = state_17133__$1;
(statearr_17157_17347[(2)] = null);

(statearr_17157_17347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (69))){
var inst_16980 = (state_17133[(12)]);
var state_17133__$1 = state_17133;
var statearr_17158_17348 = state_17133__$1;
(statearr_17158_17348[(2)] = inst_16980);

(statearr_17158_17348[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (101))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17061 = fluree.db.query.schema.type_error.call(null,inst_16992,inst_16993,throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17159_17349 = state_17133__$1;
(statearr_17159_17349[(2)] = inst_17061);

(statearr_17159_17349[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (24))){
var inst_16887 = (state_17133[(13)]);
var state_17133__$1 = state_17133;
var statearr_17160_17350 = state_17133__$1;
(statearr_17160_17350[(2)] = inst_16887);

(statearr_17160_17350[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (102))){
var inst_17063 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17161_17351 = state_17133__$1;
(statearr_17161_17351[(2)] = inst_17063);

(statearr_17161_17351[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (55))){
var inst_16959 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17162_17352 = state_17133__$1;
(statearr_17162_17352[(2)] = inst_16959);

(statearr_17162_17352[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (85))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17021 = fluree.db.query.schema.type_error.call(null,inst_16992,inst_16993,throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17163_17353 = state_17133__$1;
(statearr_17163_17353[(2)] = inst_17021);

(statearr_17163_17353[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (39))){
var inst_16924 = (state_17133[(18)]);
var state_17133__$1 = state_17133;
var statearr_17164_17354 = state_17133__$1;
(statearr_17164_17354[(2)] = inst_16924);

(statearr_17164_17354[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (88))){
var inst_16980 = (state_17133[(12)]);
var state_17133__$1 = state_17133;
var statearr_17165_17355 = state_17133__$1;
(statearr_17165_17355[(2)] = inst_16980);

(statearr_17165_17355[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (46))){
var inst_16943 = (state_17133[(19)]);
var inst_16861 = (state_17133[(10)]);
var inst_16942 = (state_17133[(2)]);
var inst_16943__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16861);
var state_17133__$1 = (function (){var statearr_17166 = state_17133;
(statearr_17166[(14)] = inst_16942);

(statearr_17166[(19)] = inst_16943__$1);

return statearr_17166;
})();
if(cljs.core.truth_(inst_16943__$1)){
var statearr_17167_17356 = state_17133__$1;
(statearr_17167_17356[(1)] = (47));

} else {
var statearr_17168_17357 = state_17133__$1;
(statearr_17168_17357[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (4))){
var inst_16822 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17169_17358 = state_17133__$1;
(statearr_17169_17358[(2)] = inst_16822);

(statearr_17169_17358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (77))){
var inst_17081 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17170_17359 = state_17133__$1;
(statearr_17170_17359[(2)] = inst_17081);

(statearr_17170_17359[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (106))){
var inst_17073 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17171_17360 = state_17133__$1;
(statearr_17171_17360[(2)] = inst_17073);

(statearr_17171_17360[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (119))){
var inst_16859 = (state_17133[(20)]);
var inst_17123 = (state_17133[(2)]);
var inst_16848 = inst_16859;
var inst_16849 = inst_17123;
var state_17133__$1 = (function (){var statearr_17172 = state_17133;
(statearr_17172[(21)] = inst_16848);

(statearr_17172[(16)] = inst_16849);

return statearr_17172;
})();
var statearr_17173_17361 = state_17133__$1;
(statearr_17173_17361[(2)] = null);

(statearr_17173_17361[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (95))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17045 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17046 = inst_16993.call(null,cljs.core.PersistentArrayMap,null,5,inst_17045,null);
var inst_17047 = inst_16993.call(null,cljs.core.PersistentHashSet,null,inst_17046,null);
var inst_17048 = inst_17047.call(null,inst_16992);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_17048)){
var statearr_17174_17362 = state_17133__$1;
(statearr_17174_17362[(1)] = (96));

} else {
var statearr_17175_17363 = state_17133__$1;
(statearr_17175_17363[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (54))){
var inst_16950 = (state_17133[(22)]);
var state_17133__$1 = state_17133;
var statearr_17176_17364 = state_17133__$1;
(statearr_17176_17364[(2)] = inst_16950);

(statearr_17176_17364[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (92))){
var inst_16980 = (state_17133[(12)]);
var state_17133__$1 = state_17133;
var statearr_17177_17365 = state_17133__$1;
(statearr_17177_17365[(2)] = inst_16980);

(statearr_17177_17365[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (104))){
var inst_16980 = (state_17133[(12)]);
var state_17133__$1 = state_17133;
var statearr_17178_17366 = state_17133__$1;
(statearr_17178_17366[(2)] = inst_16980);

(statearr_17178_17366[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (15))){
var inst_16869 = (state_17133[(23)]);
var state_17133__$1 = state_17133;
var statearr_17179_17367 = state_17133__$1;
(statearr_17179_17367[(2)] = inst_16869);

(statearr_17179_17367[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (48))){
var inst_16943 = (state_17133[(19)]);
var state_17133__$1 = state_17133;
var statearr_17180_17368 = state_17133__$1;
(statearr_17180_17368[(2)] = inst_16943);

(statearr_17180_17368[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (50))){
var inst_16950 = (state_17133[(22)]);
var inst_16861 = (state_17133[(10)]);
var inst_16948 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16949 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16948);
var inst_16950__$1 = inst_16949 === true;
var state_17133__$1 = (function (){var statearr_17181 = state_17133;
(statearr_17181[(22)] = inst_16950__$1);

return statearr_17181;
})();
if(cljs.core.truth_(inst_16950__$1)){
var statearr_17182_17369 = state_17133__$1;
(statearr_17182_17369[(1)] = (53));

} else {
var statearr_17183_17370 = state_17133__$1;
(statearr_17183_17370[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (116))){
var inst_17104 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17184_17371 = state_17133__$1;
(statearr_17184_17371[(2)] = inst_17104);

(statearr_17184_17371[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (75))){
var inst_16993 = (state_17133[(8)]);
var state_17133__$1 = state_17133;
var G__17185_17372 = inst_16993;
var G__17185_17373__$1 = (((G__17185_17372 instanceof cljs.core.Keyword))?G__17185_17372.fqn:null);
switch (G__17185_17373__$1) {
case "long":
var statearr_17186_17375 = state_17133__$1;
(statearr_17186_17375[(1)] = (79));


break;
case "bigint":
var statearr_17187_17376 = state_17133__$1;
(statearr_17187_17376[(1)] = (83));


break;
case "double":
var statearr_17188_17377 = state_17133__$1;
(statearr_17188_17377[(1)] = (87));


break;
case "float":
var statearr_17189_17378 = state_17133__$1;
(statearr_17189_17378[(1)] = (91));


break;
case "bigdec":
var statearr_17190_17379 = state_17133__$1;
(statearr_17190_17379[(1)] = (95));


break;
case "string":
var statearr_17191_17380 = state_17133__$1;
(statearr_17191_17380[(1)] = (99));


break;
case "instant":
var statearr_17192_17381 = state_17133__$1;
(statearr_17192_17381[(1)] = (103));


break;
default:
var statearr_17193_17382 = state_17133__$1;
(statearr_17193_17382[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (99))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17055 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_17056 = inst_16993.call(null,cljs.core.PersistentArrayMap,null,5,inst_17055,null);
var inst_17057 = inst_16993.call(null,cljs.core.PersistentHashSet,null,inst_17056,null);
var inst_17058 = inst_17057.call(null,inst_16992);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_17058)){
var statearr_17194_17383 = state_17133__$1;
(statearr_17194_17383[(1)] = (100));

} else {
var statearr_17195_17384 = state_17133__$1;
(statearr_17195_17384[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (21))){
var inst_16885 = (state_17133[(24)]);
var state_17133__$1 = state_17133;
var statearr_17196_17385 = state_17133__$1;
(statearr_17196_17385[(2)] = inst_16885);

(statearr_17196_17385[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (31))){
var inst_16901 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17197_17386 = state_17133__$1;
(statearr_17197_17386[(2)] = inst_16901);

(statearr_17197_17386[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (113))){
var inst_17107 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17198_17387 = state_17133__$1;
(statearr_17198_17387[(2)] = inst_17107);

(statearr_17198_17387[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (32))){
var state_17133__$1 = state_17133;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17199_17388 = state_17133__$1;
(statearr_17199_17388[(1)] = (35));

} else {
var statearr_17200_17389 = state_17133__$1;
(statearr_17200_17389[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (40))){
var inst_16937 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_16937)){
var statearr_17201_17390 = state_17133__$1;
(statearr_17201_17390[(1)] = (44));

} else {
var statearr_17202_17391 = state_17133__$1;
(statearr_17202_17391[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (91))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17035 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17036 = inst_16993.call(null,cljs.core.PersistentArrayMap,null,3,inst_17035,null);
var inst_17037 = inst_16993.call(null,cljs.core.PersistentHashSet,null,inst_17036,null);
var inst_17038 = inst_17037.call(null,inst_16992);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_17038)){
var statearr_17203_17392 = state_17133__$1;
(statearr_17203_17392[(1)] = (92));

} else {
var statearr_17204_17393 = state_17133__$1;
(statearr_17204_17393[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (117))){
var state_17133__$1 = state_17133;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17205_17394 = state_17133__$1;
(statearr_17205_17394[(1)] = (120));

} else {
var statearr_17206_17395 = state_17133__$1;
(statearr_17206_17395[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (108))){
var inst_16861 = (state_17133[(10)]);
var inst_17092 = (state_17133[(25)]);
var inst_17092__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16861);
var state_17133__$1 = (function (){var statearr_17207 = state_17133;
(statearr_17207[(25)] = inst_17092__$1);

return statearr_17207;
})();
if(cljs.core.truth_(inst_17092__$1)){
var statearr_17208_17396 = state_17133__$1;
(statearr_17208_17396[(1)] = (111));

} else {
var statearr_17209_17397 = state_17133__$1;
(statearr_17209_17397[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (56))){
var inst_16954 = (state_17133[(2)]);
var inst_16955 = fluree.db.util.async.throw_err.call(null,inst_16954);
var inst_16956 = cljs.core.not.call(null,inst_16955);
var state_17133__$1 = state_17133;
var statearr_17210_17398 = state_17133__$1;
(statearr_17210_17398[(2)] = inst_16956);

(statearr_17210_17398[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (33))){
var inst_16884 = (state_17133[(26)]);
var state_17133__$1 = state_17133;
var statearr_17211_17399 = state_17133__$1;
(statearr_17211_17399[(2)] = inst_16884);

(statearr_17211_17399[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (13))){
var inst_16879 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_16879)){
var statearr_17212_17400 = state_17133__$1;
(statearr_17212_17400[(1)] = (17));

} else {
var statearr_17213_17401 = state_17133__$1;
(statearr_17213_17401[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (22))){
var inst_16910 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_16910)){
var statearr_17214_17402 = state_17133__$1;
(statearr_17214_17402[(1)] = (32));

} else {
var statearr_17215_17403 = state_17133__$1;
(statearr_17215_17403[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (90))){
var inst_17033 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17216_17404 = state_17133__$1;
(statearr_17216_17404[(2)] = inst_17033);

(statearr_17216_17404[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (109))){
var inst_17090 = (state_17133[(27)]);
var state_17133__$1 = state_17133;
var statearr_17217_17405 = state_17133__$1;
(statearr_17217_17405[(2)] = inst_17090);

(statearr_17217_17405[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (36))){
var inst_16884 = (state_17133[(26)]);
var state_17133__$1 = state_17133;
var statearr_17218_17406 = state_17133__$1;
(statearr_17218_17406[(2)] = inst_16884);

(statearr_17218_17406[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (41))){
var inst_16861 = (state_17133[(10)]);
var inst_16929 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16930 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16929);
var inst_16931 = inst_16930 === true;
var state_17133__$1 = state_17133;
var statearr_17219_17407 = state_17133__$1;
(statearr_17219_17407[(2)] = inst_16931);

(statearr_17219_17407[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (118))){
var inst_17088 = (state_17133[(7)]);
var state_17133__$1 = state_17133;
var statearr_17220_17408 = state_17133__$1;
(statearr_17220_17408[(2)] = inst_17088);

(statearr_17220_17408[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (89))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17031 = fluree.db.query.schema.type_error.call(null,inst_16992,inst_16993,throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17221_17409 = state_17133__$1;
(statearr_17221_17409[(2)] = inst_17031);

(statearr_17221_17409[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (100))){
var inst_16980 = (state_17133[(12)]);
var state_17133__$1 = state_17133;
var statearr_17222_17410 = state_17133__$1;
(statearr_17222_17410[(2)] = inst_16980);

(statearr_17222_17410[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (122))){
var inst_17120 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17223_17411 = state_17133__$1;
(statearr_17223_17411[(2)] = inst_17120);

(statearr_17223_17411[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (43))){
var inst_16934 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17224_17412 = state_17133__$1;
(statearr_17224_17412[(2)] = inst_16934);

(statearr_17224_17412[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (61))){
var inst_16942 = (state_17133[(14)]);
var state_17133__$1 = state_17133;
var statearr_17225_17413 = state_17133__$1;
(statearr_17225_17413[(2)] = inst_16942);

(statearr_17225_17413[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (29))){
var inst_16861 = (state_17133[(10)]);
var inst_16896 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16897 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16896);
var inst_16898 = inst_16897 === true;
var state_17133__$1 = state_17133;
var statearr_17226_17414 = state_17133__$1;
(statearr_17226_17414[(2)] = inst_16898);

(statearr_17226_17414[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (44))){
var inst_16923 = (state_17133[(28)]);
var inst_16939 = fluree.db.query.schema.type_error.call(null,inst_16923,"a component","a non-component",throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17227_17415 = state_17133__$1;
(statearr_17227_17415[(2)] = inst_16939);

(statearr_17227_17415[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (93))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17041 = fluree.db.query.schema.type_error.call(null,inst_16992,inst_16993,throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17228_17416 = state_17133__$1;
(statearr_17228_17416[(2)] = inst_17041);

(statearr_17228_17416[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (6))){
var inst_16860 = (state_17133[(15)]);
var inst_16848 = (state_17133[(21)]);
var inst_16857 = cljs.core.seq.call(null,inst_16848);
var inst_16858 = cljs.core.first.call(null,inst_16857);
var inst_16859 = cljs.core.next.call(null,inst_16857);
var inst_16860__$1 = cljs.core.nth.call(null,inst_16858,(0),null);
var inst_16861 = cljs.core.nth.call(null,inst_16858,(1),null);
var inst_16862 = cljs.core.not.call(null,inst_16860__$1);
var state_17133__$1 = (function (){var statearr_17229 = state_17133;
(statearr_17229[(15)] = inst_16860__$1);

(statearr_17229[(20)] = inst_16859);

(statearr_17229[(10)] = inst_16861);

return statearr_17229;
})();
if(inst_16862){
var statearr_17230_17417 = state_17133__$1;
(statearr_17230_17417[(1)] = (8));

} else {
var statearr_17231_17418 = state_17133__$1;
(statearr_17231_17418[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (111))){
var inst_17096 = (state_17133[(29)]);
var inst_16861 = (state_17133[(10)]);
var inst_17094 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_17095 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_17094);
var inst_17096__$1 = inst_17095 === true;
var state_17133__$1 = (function (){var statearr_17232 = state_17133;
(statearr_17232[(29)] = inst_17096__$1);

return statearr_17232;
})();
if(cljs.core.truth_(inst_17096__$1)){
var statearr_17233_17419 = state_17133__$1;
(statearr_17233_17419[(1)] = (114));

} else {
var statearr_17234_17420 = state_17133__$1;
(statearr_17234_17420[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (28))){
var inst_16904 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17235_17421 = state_17133__$1;
(statearr_17235_17421[(2)] = inst_16904);

(statearr_17235_17421[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (64))){
var inst_16981 = (state_17133[(11)]);
var state_17133__$1 = state_17133;
var statearr_17236_17422 = state_17133__$1;
(statearr_17236_17422[(2)] = inst_16981);

(statearr_17236_17422[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (103))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17065 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17066 = inst_16993.call(null,cljs.core.PersistentArrayMap,null,2,inst_17065,null);
var inst_17067 = inst_16993.call(null,cljs.core.PersistentHashSet,null,inst_17066,null);
var inst_17068 = inst_17067.call(null,inst_16992);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_17068)){
var statearr_17237_17423 = state_17133__$1;
(statearr_17237_17423[(1)] = (104));

} else {
var statearr_17238_17424 = state_17133__$1;
(statearr_17238_17424[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (51))){
var inst_16946 = (state_17133[(30)]);
var state_17133__$1 = state_17133;
var statearr_17239_17425 = state_17133__$1;
(statearr_17239_17425[(2)] = inst_16946);

(statearr_17239_17425[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (25))){
var inst_16907 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17240_17426 = state_17133__$1;
(statearr_17240_17426[(2)] = inst_16907);

(statearr_17240_17426[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (34))){
var inst_16924 = (state_17133[(18)]);
var inst_16861 = (state_17133[(10)]);
var inst_16923 = (state_17133[(2)]);
var inst_16924__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16861);
var state_17133__$1 = (function (){var statearr_17241 = state_17133;
(statearr_17241[(18)] = inst_16924__$1);

(statearr_17241[(28)] = inst_16923);

return statearr_17241;
})();
if(cljs.core.truth_(inst_16924__$1)){
var statearr_17242_17427 = state_17133__$1;
(statearr_17242_17427[(1)] = (38));

} else {
var statearr_17243_17428 = state_17133__$1;
(statearr_17243_17428[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (17))){
var inst_16849 = (state_17133[(16)]);
var inst_16881 = fluree.db.query.schema.type_error.call(null,inst_16849,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17244_17429 = state_17133__$1;
(statearr_17244_17429[(2)] = inst_16881);

(statearr_17244_17429[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (3))){
var inst_17131 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17133__$1,inst_17131);
} else {
if((state_val_17134 === (12))){
var inst_16865 = (state_17133[(31)]);
var state_17133__$1 = state_17133;
var statearr_17245_17430 = state_17133__$1;
(statearr_17245_17430[(2)] = inst_16865);

(statearr_17245_17430[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (2))){
var _ = (function (){var statearr_17246 = state_17133;
(statearr_17246[(4)] = cljs.core.cons.call(null,(5),(state_17133[(4)])));

return statearr_17246;
})();
var inst_16841 = pred_changes;
var inst_16842 = cljs.core.seq.call(null,inst_16841);
var inst_16843 = cljs.core.first.call(null,inst_16842);
var inst_16844 = cljs.core.next.call(null,inst_16842);
var inst_16845 = cljs.core.nth.call(null,inst_16843,(0),null);
var inst_16846 = cljs.core.nth.call(null,inst_16843,(1),null);
var inst_16847 = db;
var inst_16848 = inst_16841;
var inst_16849 = inst_16847;
var state_17133__$1 = (function (){var statearr_17247 = state_17133;
(statearr_17247[(32)] = inst_16846);

(statearr_17247[(33)] = inst_16845);

(statearr_17247[(21)] = inst_16848);

(statearr_17247[(16)] = inst_16849);

(statearr_17247[(34)] = inst_16844);

return statearr_17247;
})();
var statearr_17248_17431 = state_17133__$1;
(statearr_17248_17431[(2)] = null);

(statearr_17248_17431[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (66))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_16861 = (state_17133[(10)]);
var inst_16990 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16991 = cljs.core.__destructure_map.call(null,inst_16990);
var inst_16992__$1 = cljs.core.get.call(null,inst_16991,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16993__$1 = cljs.core.get.call(null,inst_16991,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16994 = cljs.core._EQ_.call(null,inst_16993__$1,inst_16992__$1);
var state_17133__$1 = (function (){var statearr_17249 = state_17133;
(statearr_17249[(8)] = inst_16993__$1);

(statearr_17249[(9)] = inst_16992__$1);

return statearr_17249;
})();
if(inst_16994){
var statearr_17250_17432 = state_17133__$1;
(statearr_17250_17432[(1)] = (69));

} else {
var statearr_17251_17433 = state_17133__$1;
(statearr_17251_17433[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (107))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17075 = fluree.db.query.schema.type_error.call(null,inst_16992,inst_16993,throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17252_17434 = state_17133__$1;
(statearr_17252_17434[(2)] = inst_17075);

(statearr_17252_17434[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (23))){
var inst_16890 = (state_17133[(17)]);
var inst_16861 = (state_17133[(10)]);
var inst_16889 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16890__$1 = inst_16889 === true;
var state_17133__$1 = (function (){var statearr_17253 = state_17133;
(statearr_17253[(17)] = inst_16890__$1);

return statearr_17253;
})();
if(cljs.core.truth_(inst_16890__$1)){
var statearr_17254_17435 = state_17133__$1;
(statearr_17254_17435[(1)] = (26));

} else {
var statearr_17255_17436 = state_17133__$1;
(statearr_17255_17436[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (47))){
var inst_16946 = (state_17133[(30)]);
var inst_16861 = (state_17133[(10)]);
var inst_16945 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16946__$1 = cljs.core.not.call(null,inst_16945);
var state_17133__$1 = (function (){var statearr_17256 = state_17133;
(statearr_17256[(30)] = inst_16946__$1);

return statearr_17256;
})();
if(inst_16946__$1){
var statearr_17257_17437 = state_17133__$1;
(statearr_17257_17437[(1)] = (50));

} else {
var statearr_17258_17438 = state_17133__$1;
(statearr_17258_17438[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (35))){
var inst_16913 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16914 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16915 = cljs.core.PersistentHashMap.fromArrays(inst_16913,inst_16914);
var inst_16916 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_16915);
var inst_16917 = (function(){throw inst_16916})();
var state_17133__$1 = state_17133;
var statearr_17259_17439 = state_17133__$1;
(statearr_17259_17439[(2)] = inst_16917);

(statearr_17259_17439[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (82))){
var inst_17013 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17260_17440 = state_17133__$1;
(statearr_17260_17440[(2)] = inst_17013);

(statearr_17260_17440[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (76))){
var state_17133__$1 = state_17133;
var statearr_17261_17441 = state_17133__$1;
(statearr_17261_17441[(2)] = null);

(statearr_17261_17441[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (97))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17051 = fluree.db.query.schema.type_error.call(null,inst_16992,inst_16993,throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17262_17442 = state_17133__$1;
(statearr_17262_17442[(2)] = inst_17051);

(statearr_17262_17442[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (19))){
var inst_16861 = (state_17133[(10)]);
var inst_16885 = (state_17133[(24)]);
var inst_16884 = (state_17133[(2)]);
var inst_16885__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16861);
var state_17133__$1 = (function (){var statearr_17263 = state_17133;
(statearr_17263[(26)] = inst_16884);

(statearr_17263[(24)] = inst_16885__$1);

return statearr_17263;
})();
if(cljs.core.truth_(inst_16885__$1)){
var statearr_17264_17443 = state_17133__$1;
(statearr_17264_17443[(1)] = (20));

} else {
var statearr_17265_17444 = state_17133__$1;
(statearr_17265_17444[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (57))){
var state_17133__$1 = state_17133;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17266_17445 = state_17133__$1;
(statearr_17266_17445[(1)] = (60));

} else {
var statearr_17267_17446 = state_17133__$1;
(statearr_17267_17446[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (68))){
var inst_16861 = (state_17133[(10)]);
var inst_17090 = (state_17133[(27)]);
var inst_17088 = (state_17133[(2)]);
var inst_17089 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_17090__$1 = inst_17089 === true;
var state_17133__$1 = (function (){var statearr_17268 = state_17133;
(statearr_17268[(7)] = inst_17088);

(statearr_17268[(27)] = inst_17090__$1);

return statearr_17268;
})();
if(cljs.core.truth_(inst_17090__$1)){
var statearr_17269_17447 = state_17133__$1;
(statearr_17269_17447[(1)] = (108));

} else {
var statearr_17270_17448 = state_17133__$1;
(statearr_17270_17448[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (11))){
var inst_16861 = (state_17133[(10)]);
var inst_16869 = (state_17133[(23)]);
var inst_16867 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16868 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16867);
var inst_16869__$1 = inst_16868 === false;
var state_17133__$1 = (function (){var statearr_17271 = state_17133;
(statearr_17271[(23)] = inst_16869__$1);

return statearr_17271;
})();
if(cljs.core.truth_(inst_16869__$1)){
var statearr_17272_17449 = state_17133__$1;
(statearr_17272_17449[(1)] = (14));

} else {
var statearr_17273_17450 = state_17133__$1;
(statearr_17273_17450[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (115))){
var inst_17096 = (state_17133[(29)]);
var state_17133__$1 = state_17133;
var statearr_17275_17451 = state_17133__$1;
(statearr_17275_17451[(2)] = inst_17096);

(statearr_17275_17451[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (9))){
var inst_16865 = (state_17133[(31)]);
var inst_16861 = (state_17133[(10)]);
var inst_16865__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16861);
var state_17133__$1 = (function (){var statearr_17276 = state_17133;
(statearr_17276[(31)] = inst_16865__$1);

return statearr_17276;
})();
if(cljs.core.truth_(inst_16865__$1)){
var statearr_17277_17452 = state_17133__$1;
(statearr_17277_17452[(1)] = (11));

} else {
var statearr_17278_17453 = state_17133__$1;
(statearr_17278_17453[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (5))){
var _ = (function (){var statearr_17279 = state_17133;
(statearr_17279[(4)] = cljs.core.rest.call(null,(state_17133[(4)])));

return statearr_17279;
})();
var state_17133__$1 = state_17133;
var ex17274 = (state_17133__$1[(2)]);
var statearr_17280_17454 = state_17133__$1;
(statearr_17280_17454[(5)] = ex17274);


if((ex17274 instanceof Error)){
var statearr_17281_17455 = state_17133__$1;
(statearr_17281_17455[(1)] = (4));

(statearr_17281_17455[(5)] = null);

} else {
throw ex17274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (112))){
var inst_17092 = (state_17133[(25)]);
var state_17133__$1 = state_17133;
var statearr_17282_17456 = state_17133__$1;
(statearr_17282_17456[(2)] = inst_17092);

(statearr_17282_17456[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (83))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17015 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17016 = inst_16993.call(null,cljs.core.PersistentArrayMap,null,3,inst_17015,null);
var inst_17017 = inst_16993.call(null,cljs.core.PersistentHashSet,null,inst_17016,null);
var inst_17018 = inst_17017.call(null,inst_16992);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_17018)){
var statearr_17283_17457 = state_17133__$1;
(statearr_17283_17457[(1)] = (84));

} else {
var statearr_17284_17458 = state_17133__$1;
(statearr_17284_17458[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (14))){
var inst_16861 = (state_17133[(10)]);
var inst_16871 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16872 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16871);
var inst_16873 = inst_16872 === true;
var state_17133__$1 = state_17133;
var statearr_17285_17459 = state_17133__$1;
(statearr_17285_17459[(2)] = inst_16873);

(statearr_17285_17459[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (45))){
var inst_16923 = (state_17133[(28)]);
var state_17133__$1 = state_17133;
var statearr_17286_17460 = state_17133__$1;
(statearr_17286_17460[(2)] = inst_16923);

(statearr_17286_17460[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (53))){
var inst_16860 = (state_17133[(15)]);
var inst_16849 = (state_17133[(16)]);
var inst_16952 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_16849,inst_16860);
var state_17133__$1 = state_17133;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17133__$1,(56),inst_16952);
} else {
if((state_val_17134 === (78))){
var inst_17078 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17287_17461 = state_17133__$1;
(statearr_17287_17461[(2)] = inst_17078);

(statearr_17287_17461[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (26))){
var inst_16894 = (state_17133[(35)]);
var inst_16861 = (state_17133[(10)]);
var inst_16892 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16893 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16892);
var inst_16894__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16893);
var state_17133__$1 = (function (){var statearr_17288 = state_17133;
(statearr_17288[(35)] = inst_16894__$1);

return statearr_17288;
})();
if(inst_16894__$1){
var statearr_17289_17462 = state_17133__$1;
(statearr_17289_17462[(1)] = (29));

} else {
var statearr_17290_17463 = state_17133__$1;
(statearr_17290_17463[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (16))){
var inst_16876 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17291_17464 = state_17133__$1;
(statearr_17291_17464[(2)] = inst_16876);

(statearr_17291_17464[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (81))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17011 = fluree.db.query.schema.type_error.call(null,inst_16992,inst_16993,throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17292_17465 = state_17133__$1;
(statearr_17292_17465[(2)] = inst_17011);

(statearr_17292_17465[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (120))){
var inst_17113 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17114 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_17115 = cljs.core.PersistentHashMap.fromArrays(inst_17113,inst_17114);
var inst_17116 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_17115);
var inst_17117 = (function(){throw inst_17116})();
var state_17133__$1 = state_17133;
var statearr_17293_17466 = state_17133__$1;
(statearr_17293_17466[(2)] = inst_17117);

(statearr_17293_17466[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (79))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17005 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17006 = inst_16993.call(null,cljs.core.PersistentArrayMap,null,2,inst_17005,null);
var inst_17007 = inst_16993.call(null,cljs.core.PersistentHashSet,null,inst_17006,null);
var inst_17008 = inst_17007.call(null,inst_16992);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_17008)){
var statearr_17294_17467 = state_17133__$1;
(statearr_17294_17467[(1)] = (80));

} else {
var statearr_17295_17468 = state_17133__$1;
(statearr_17295_17468[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (38))){
var inst_16927 = (state_17133[(36)]);
var inst_16861 = (state_17133[(10)]);
var inst_16926 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16927__$1 = cljs.core.not.call(null,inst_16926);
var state_17133__$1 = (function (){var statearr_17296 = state_17133;
(statearr_17296[(36)] = inst_16927__$1);

return statearr_17296;
})();
if(inst_16927__$1){
var statearr_17297_17469 = state_17133__$1;
(statearr_17297_17469[(1)] = (41));

} else {
var statearr_17298_17470 = state_17133__$1;
(statearr_17298_17470[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (98))){
var inst_17053 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17299_17471 = state_17133__$1;
(statearr_17299_17471[(2)] = inst_17053);

(statearr_17299_17471[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (87))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17025 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17026 = inst_16993.call(null,cljs.core.PersistentArrayMap,null,3,inst_17025,null);
var inst_17027 = inst_16993.call(null,cljs.core.PersistentHashSet,null,inst_17026,null);
var inst_17028 = inst_17027.call(null,inst_16992);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_17028)){
var statearr_17300_17472 = state_17133__$1;
(statearr_17300_17472[(1)] = (88));

} else {
var statearr_17301_17473 = state_17133__$1;
(statearr_17301_17473[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (30))){
var inst_16894 = (state_17133[(35)]);
var state_17133__$1 = state_17133;
var statearr_17302_17474 = state_17133__$1;
(statearr_17302_17474[(2)] = inst_16894);

(statearr_17302_17474[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (73))){
var state_17133__$1 = state_17133;
var statearr_17303_17475 = state_17133__$1;
(statearr_17303_17475[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (96))){
var inst_16980 = (state_17133[(12)]);
var state_17133__$1 = state_17133;
var statearr_17305_17476 = state_17133__$1;
(statearr_17305_17476[(2)] = inst_16980);

(statearr_17305_17476[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (10))){
var inst_17126 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17306_17477 = state_17133__$1;
(statearr_17306_17477[(2)] = inst_17126);

(statearr_17306_17477[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (18))){
var inst_16849 = (state_17133[(16)]);
var state_17133__$1 = state_17133;
var statearr_17307_17478 = state_17133__$1;
(statearr_17307_17478[(2)] = inst_16849);

(statearr_17307_17478[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (105))){
var inst_16993 = (state_17133[(8)]);
var inst_16992 = (state_17133[(9)]);
var inst_17071 = fluree.db.query.schema.type_error.call(null,inst_16992,inst_16993,throw_QMARK_);
var state_17133__$1 = state_17133;
var statearr_17308_17479 = state_17133__$1;
(statearr_17308_17479[(2)] = inst_17071);

(statearr_17308_17479[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (52))){
var inst_16962 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17309_17480 = state_17133__$1;
(statearr_17309_17480[(2)] = inst_16962);

(statearr_17309_17480[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (114))){
var inst_16861 = (state_17133[(10)]);
var inst_17098 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_17099 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_17098);
var inst_17100 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_17099);
var inst_17101 = (!(inst_17100));
var state_17133__$1 = state_17133;
var statearr_17310_17481 = state_17133__$1;
(statearr_17310_17481[(2)] = inst_17101);

(statearr_17310_17481[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (67))){
var inst_16980 = (state_17133[(12)]);
var state_17133__$1 = state_17133;
var statearr_17311_17482 = state_17133__$1;
(statearr_17311_17482[(2)] = inst_16980);

(statearr_17311_17482[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (71))){
var inst_17085 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17312_17483 = state_17133__$1;
(statearr_17312_17483[(2)] = inst_17085);

(statearr_17312_17483[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (42))){
var inst_16927 = (state_17133[(36)]);
var state_17133__$1 = state_17133;
var statearr_17313_17484 = state_17133__$1;
(statearr_17313_17484[(2)] = inst_16927);

(statearr_17313_17484[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (80))){
var inst_16980 = (state_17133[(12)]);
var state_17133__$1 = state_17133;
var statearr_17314_17485 = state_17133__$1;
(statearr_17314_17485[(2)] = inst_16980);

(statearr_17314_17485[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (37))){
var inst_16920 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17315_17486 = state_17133__$1;
(statearr_17315_17486[(2)] = inst_16920);

(statearr_17315_17486[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (63))){
var inst_16861 = (state_17133[(10)]);
var inst_16983 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16861);
var inst_16984 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16983);
var state_17133__$1 = state_17133;
var statearr_17316_17487 = state_17133__$1;
(statearr_17316_17487[(2)] = inst_16984);

(statearr_17316_17487[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (94))){
var inst_17043 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17317_17488 = state_17133__$1;
(statearr_17317_17488[(2)] = inst_17043);

(statearr_17317_17488[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (8))){
var inst_16849 = (state_17133[(16)]);
var state_17133__$1 = state_17133;
var statearr_17318_17489 = state_17133__$1;
(statearr_17318_17489[(2)] = inst_16849);

(statearr_17318_17489[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (49))){
var inst_16965 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
if(cljs.core.truth_(inst_16965)){
var statearr_17319_17490 = state_17133__$1;
(statearr_17319_17490[(1)] = (57));

} else {
var statearr_17320_17491 = state_17133__$1;
(statearr_17320_17491[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (84))){
var inst_16980 = (state_17133[(12)]);
var state_17133__$1 = state_17133;
var statearr_17321_17492 = state_17133__$1;
(statearr_17321_17492[(2)] = inst_16980);

(statearr_17321_17492[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2703__auto__ = null;
var fluree$db$query$schema$state_machine__2703__auto____0 = (function (){
var statearr_17322 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17322[(0)] = fluree$db$query$schema$state_machine__2703__auto__);

(statearr_17322[(1)] = (1));

return statearr_17322;
});
var fluree$db$query$schema$state_machine__2703__auto____1 = (function (state_17133){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_17133);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e17323){var ex__2706__auto__ = e17323;
var statearr_17324_17493 = state_17133;
(statearr_17324_17493[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_17133[(4)]))){
var statearr_17325_17494 = state_17133;
(statearr_17325_17494[(1)] = cljs.core.first.call(null,(state_17133[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17495 = state_17133;
state_17133 = G__17495;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2703__auto__ = function(state_17133){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2703__auto____1.call(this,state_17133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2703__auto____0;
fluree$db$query$schema$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2703__auto____1;
return fluree$db$query$schema$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_17326 = f__2726__auto__.call(null);
(statearr_17326[(6)] = c__2725__auto__);

return statearr_17326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__17497 = arguments.length;
switch (G__17497) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_17521){
var state_val_17522 = (state_17521[(1)]);
if((state_val_17522 === (7))){
var state_17521__$1 = state_17521;
var statearr_17523_17543 = state_17521__$1;
(statearr_17523_17543[(2)] = db);

(statearr_17523_17543[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17522 === (1))){
var state_17521__$1 = state_17521;
var statearr_17524_17544 = state_17521__$1;
(statearr_17524_17544[(2)] = null);

(statearr_17524_17544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17522 === (4))){
var inst_17498 = (state_17521[(2)]);
var state_17521__$1 = state_17521;
var statearr_17525_17545 = state_17521__$1;
(statearr_17525_17545[(2)] = inst_17498);

(statearr_17525_17545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17522 === (6))){
var inst_17507 = (state_17521[(7)]);
var inst_17506 = (state_17521[(2)]);
var inst_17507__$1 = fluree.db.util.async.throw_err.call(null,inst_17506);
var inst_17508 = cljs.core.empty_QMARK_.call(null,inst_17507__$1);
var state_17521__$1 = (function (){var statearr_17526 = state_17521;
(statearr_17526[(7)] = inst_17507__$1);

return statearr_17526;
})();
if(inst_17508){
var statearr_17527_17546 = state_17521__$1;
(statearr_17527_17546[(1)] = (7));

} else {
var statearr_17528_17547 = state_17521__$1;
(statearr_17528_17547[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17522 === (3))){
var inst_17519 = (state_17521[(2)]);
var state_17521__$1 = state_17521;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17521__$1,inst_17519);
} else {
if((state_val_17522 === (2))){
var _ = (function (){var statearr_17530 = state_17521;
(statearr_17530[(4)] = cljs.core.cons.call(null,(5),(state_17521[(4)])));

return statearr_17530;
})();
var inst_17504 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_17521__$1 = state_17521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17521__$1,(6),inst_17504);
} else {
if((state_val_17522 === (9))){
var inst_17516 = (state_17521[(2)]);
var _ = (function (){var statearr_17531 = state_17521;
(statearr_17531[(4)] = cljs.core.rest.call(null,(state_17521[(4)])));

return statearr_17531;
})();
var state_17521__$1 = state_17521;
var statearr_17532_17548 = state_17521__$1;
(statearr_17532_17548[(2)] = inst_17516);

(statearr_17532_17548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17522 === (5))){
var _ = (function (){var statearr_17533 = state_17521;
(statearr_17533[(4)] = cljs.core.rest.call(null,(state_17521[(4)])));

return statearr_17533;
})();
var state_17521__$1 = state_17521;
var ex17529 = (state_17521__$1[(2)]);
var statearr_17534_17549 = state_17521__$1;
(statearr_17534_17549[(5)] = ex17529);


if((ex17529 instanceof Error)){
var statearr_17535_17550 = state_17521__$1;
(statearr_17535_17550[(1)] = (4));

(statearr_17535_17550[(5)] = null);

} else {
throw ex17529;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17522 === (10))){
var inst_17513 = (state_17521[(2)]);
var inst_17514 = fluree.db.util.async.throw_err.call(null,inst_17513);
var state_17521__$1 = state_17521;
var statearr_17536_17551 = state_17521__$1;
(statearr_17536_17551[(2)] = inst_17514);

(statearr_17536_17551[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17522 === (8))){
var inst_17507 = (state_17521[(7)]);
var inst_17511 = fluree.db.query.schema.predicate_change_error.call(null,inst_17507,db,true);
var state_17521__$1 = state_17521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17521__$1,(10),inst_17511);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2703__auto__ = null;
var fluree$db$query$schema$state_machine__2703__auto____0 = (function (){
var statearr_17537 = [null,null,null,null,null,null,null,null];
(statearr_17537[(0)] = fluree$db$query$schema$state_machine__2703__auto__);

(statearr_17537[(1)] = (1));

return statearr_17537;
});
var fluree$db$query$schema$state_machine__2703__auto____1 = (function (state_17521){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_17521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e17538){var ex__2706__auto__ = e17538;
var statearr_17539_17552 = state_17521;
(statearr_17539_17552[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_17521[(4)]))){
var statearr_17540_17553 = state_17521;
(statearr_17540_17553[(1)] = cljs.core.first.call(null,(state_17521[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17554 = state_17521;
state_17521 = G__17554;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2703__auto__ = function(state_17521){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2703__auto____1.call(this,state_17521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2703__auto____0;
fluree$db$query$schema$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2703__auto____1;
return fluree$db$query$schema$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_17541 = f__2726__auto__.call(null);
(statearr_17541[(6)] = c__2725__auto__);

return statearr_17541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__17556 = arguments.length;
switch (G__17556) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__17558 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__17558,(0),null);
var ns = cljs.core.nth.call(null,vec__17558,(1),null);
var name = cljs.core.nth.call(null,vec__17558,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__17561_SHARP_,p2__17562_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17561_SHARP_,p2__17562_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__17563_SHARP_){
var f = p1__17563_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_17629){
var state_val_17630 = (state_17629[(1)]);
if((state_val_17630 === (1))){
var state_17629__$1 = state_17629;
var statearr_17631_17648 = state_17629__$1;
(statearr_17631_17648[(2)] = null);

(statearr_17631_17648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17630 === (2))){
var _ = (function (){var statearr_17632 = state_17629;
(statearr_17632[(4)] = cljs.core.cons.call(null,(5),(state_17629[(4)])));

return statearr_17632;
})();
var inst_17581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17582 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_17583 = [inst_17582];
var inst_17584 = (new cljs.core.PersistentVector(null,1,(5),inst_17581,inst_17583,null));
var inst_17585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17586 = [(0)];
var inst_17587 = (new cljs.core.PersistentVector(null,1,(5),inst_17585,inst_17586,null));
var inst_17588 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_17584,cljs.core._LT__EQ_,inst_17587);
var state_17629__$1 = state_17629;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17629__$1,(6),inst_17588);
} else {
if((state_val_17630 === (3))){
var inst_17627 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17629__$1,inst_17627);
} else {
if((state_val_17630 === (4))){
var inst_17569 = (state_17629[(2)]);
var state_17629__$1 = state_17629;
var statearr_17634_17649 = state_17629__$1;
(statearr_17634_17649[(2)] = inst_17569);

(statearr_17634_17649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17630 === (5))){
var _ = (function (){var statearr_17635 = state_17629;
(statearr_17635[(4)] = cljs.core.rest.call(null,(state_17629[(4)])));

return statearr_17635;
})();
var state_17629__$1 = state_17629;
var ex17633 = (state_17629__$1[(2)]);
var statearr_17636_17650 = state_17629__$1;
(statearr_17636_17650[(5)] = ex17633);


if((ex17633 instanceof Error)){
var statearr_17637_17651 = state_17629__$1;
(statearr_17637_17651[(1)] = (4));

(statearr_17637_17651[(5)] = null);

} else {
throw ex17633;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17630 === (6))){
var inst_17590 = (state_17629[(2)]);
var inst_17591 = fluree.db.util.async.throw_err.call(null,inst_17590);
var inst_17592 = (function (){var schema_flakes = inst_17591;
return (function (p1__17564_SHARP_){
return (p1__17564_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_17593 = cljs.core.partition_by.call(null,inst_17592,inst_17591);
var inst_17594 = cljs.core.nth.call(null,inst_17593,(0),null);
var inst_17595 = cljs.core.nth.call(null,inst_17593,(1),null);
var inst_17596 = (function (){var schema_flakes = inst_17591;
var vec__17575 = inst_17593;
var collection_flakes = inst_17594;
var predicate_flakes = inst_17595;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.call(null,(function (p1__17567_SHARP_,p2__17566_SHARP_){
var f = p2__17566_SHARP_;
return cljs.core.assoc.call(null,p1__17567_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_17597 = [(-1),"_tx"];
var inst_17598 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17599 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17600 = cljs.core.PersistentHashMap.fromArrays(inst_17598,inst_17599);
var inst_17601 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17602 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17603 = cljs.core.PersistentHashMap.fromArrays(inst_17601,inst_17602);
var inst_17604 = [inst_17600,inst_17603];
var inst_17605 = cljs.core.PersistentHashMap.fromArrays(inst_17597,inst_17604);
var inst_17606 = (function (){var schema_flakes = inst_17591;
var vec__17575 = inst_17593;
var collection_flakes = inst_17594;
var predicate_flakes = inst_17595;
return (function (p1__17565_SHARP_){
return p1__17565_SHARP_.s;
});
})();
var inst_17607 = cljs.core.partition_by.call(null,inst_17606,inst_17594);
var inst_17608 = cljs.core.reduce.call(null,inst_17596,inst_17605,inst_17607);
var inst_17610 = (function (){var schema_flakes = inst_17591;
var vec__17575 = inst_17593;
var collection_flakes = inst_17594;
var predicate_flakes = inst_17595;
var coll = inst_17608;
return (function (p__17609,pred_flakes){
var vec__17638 = p__17609;
var pred = cljs.core.nth.call(null,vec__17638,(0),null);
var fullText = cljs.core.nth.call(null,vec__17638,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_17611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17612 = cljs.core.PersistentHashMap.EMPTY;
var inst_17613 = cljs.core.PersistentHashSet.EMPTY;
var inst_17614 = [inst_17612,inst_17613];
var inst_17615 = (new cljs.core.PersistentVector(null,2,(5),inst_17611,inst_17614,null));
var inst_17616 = (function (){var schema_flakes = inst_17591;
var vec__17575 = inst_17593;
var collection_flakes = inst_17594;
var predicate_flakes = inst_17595;
var coll = inst_17608;
return (function (p1__17568_SHARP_){
return p1__17568_SHARP_.s;
});
})();
var inst_17617 = cljs.core.partition_by.call(null,inst_17616,inst_17595);
var inst_17618 = cljs.core.reduce.call(null,inst_17610,inst_17615,inst_17617);
var inst_17619 = cljs.core.nth.call(null,inst_17618,(0),null);
var inst_17620 = cljs.core.nth.call(null,inst_17618,(1),null);
var inst_17621 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17622 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17623 = [inst_17622,inst_17608,inst_17619,inst_17620];
var inst_17624 = cljs.core.PersistentHashMap.fromArrays(inst_17621,inst_17623);
var _ = (function (){var statearr_17641 = state_17629;
(statearr_17641[(4)] = cljs.core.rest.call(null,(state_17629[(4)])));

return statearr_17641;
})();
var state_17629__$1 = state_17629;
var statearr_17642_17652 = state_17629__$1;
(statearr_17642_17652[(2)] = inst_17624);

(statearr_17642_17652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2703__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2703__auto____0 = (function (){
var statearr_17643 = [null,null,null,null,null,null,null];
(statearr_17643[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2703__auto__);

(statearr_17643[(1)] = (1));

return statearr_17643;
});
var fluree$db$query$schema$schema_map_$_state_machine__2703__auto____1 = (function (state_17629){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_17629);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e17644){var ex__2706__auto__ = e17644;
var statearr_17645_17653 = state_17629;
(statearr_17645_17653[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_17629[(4)]))){
var statearr_17646_17654 = state_17629;
(statearr_17646_17654[(1)] = cljs.core.first.call(null,(state_17629[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17655 = state_17629;
state_17629 = G__17655;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2703__auto__ = function(state_17629){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2703__auto____1.call(this,state_17629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2703__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2703__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_17647 = f__2726__auto__.call(null);
(statearr_17647[(6)] = c__2725__auto__);

return statearr_17647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_17697){
var state_val_17698 = (state_17697[(1)]);
if((state_val_17698 === (7))){
var inst_17680 = (state_17697[(2)]);
var inst_17681 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_17680);
var inst_17682 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17683 = cljs.core.get.call(null,inst_17681,(114));
var inst_17684 = cljs.core.boolean$.call(null,inst_17683);
var inst_17685 = cljs.core.get.call(null,inst_17681,(110));
var inst_17686 = cljs.core.get.call(null,inst_17681,(117));
var inst_17687 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_17686);
var inst_17688 = cljs.core.get.call(null,inst_17681,(111));
var inst_17689 = cljs.core.get.call(null,inst_17681,(115));
var inst_17690 = cljs.core.get.call(null,inst_17681,(112));
var inst_17691 = [inst_17684,inst_17685,inst_17687,inst_17688,inst_17689,inst_17690];
var inst_17692 = cljs.core.PersistentHashMap.fromArrays(inst_17682,inst_17691);
var _ = (function (){var statearr_17699 = state_17697;
(statearr_17699[(4)] = cljs.core.rest.call(null,(state_17697[(4)])));

return statearr_17699;
})();
var state_17697__$1 = state_17697;
var statearr_17700_17723 = state_17697__$1;
(statearr_17700_17723[(2)] = inst_17692);

(statearr_17700_17723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (1))){
var state_17697__$1 = state_17697;
var statearr_17701_17724 = state_17697__$1;
(statearr_17701_17724[(2)] = null);

(statearr_17701_17724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (4))){
var inst_17656 = (state_17697[(2)]);
var state_17697__$1 = state_17697;
var statearr_17702_17725 = state_17697__$1;
(statearr_17702_17725[(2)] = inst_17656);

(statearr_17702_17725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (6))){
var _ = (function (){var statearr_17703 = state_17697;
(statearr_17703[(4)] = cljs.core.cons.call(null,(9),(state_17697[(4)])));

return statearr_17703;
})();
var inst_17668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17670 = ["_setting/id","root"];
var inst_17671 = (new cljs.core.PersistentVector(null,2,(5),inst_17669,inst_17670,null));
var inst_17672 = [inst_17671];
var inst_17673 = (new cljs.core.PersistentVector(null,1,(5),inst_17668,inst_17672,null));
var inst_17674 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17673);
var state_17697__$1 = state_17697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17697__$1,(10),inst_17674);
} else {
if((state_val_17698 === (3))){
var inst_17695 = (state_17697[(2)]);
var state_17697__$1 = state_17697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17697__$1,inst_17695);
} else {
if((state_val_17698 === (2))){
var _ = (function (){var statearr_17706 = state_17697;
(statearr_17706[(4)] = cljs.core.cons.call(null,(5),(state_17697[(4)])));

return statearr_17706;
})();
var state_17697__$1 = state_17697;
var statearr_17707_17726 = state_17697__$1;
(statearr_17707_17726[(2)] = null);

(statearr_17707_17726[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (9))){
var _ = (function (){var statearr_17708 = state_17697;
(statearr_17708[(4)] = cljs.core.rest.call(null,(state_17697[(4)])));

return statearr_17708;
})();
var state_17697__$1 = state_17697;
var ex17704 = (state_17697__$1[(2)]);
var statearr_17709_17727 = state_17697__$1;
(statearr_17709_17727[(5)] = ex17704);


var statearr_17710_17728 = state_17697__$1;
(statearr_17710_17728[(1)] = (8));

(statearr_17710_17728[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (5))){
var _ = (function (){var statearr_17711 = state_17697;
(statearr_17711[(4)] = cljs.core.rest.call(null,(state_17697[(4)])));

return statearr_17711;
})();
var state_17697__$1 = state_17697;
var ex17705 = (state_17697__$1[(2)]);
var statearr_17712_17729 = state_17697__$1;
(statearr_17712_17729[(5)] = ex17705);


if((ex17705 instanceof Error)){
var statearr_17713_17730 = state_17697__$1;
(statearr_17713_17730[(1)] = (4));

(statearr_17713_17730[(5)] = null);

} else {
throw ex17705;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (10))){
var inst_17676 = (state_17697[(2)]);
var inst_17677 = fluree.db.util.async.throw_err.call(null,inst_17676);
var _ = (function (){var statearr_17714 = state_17697;
(statearr_17714[(4)] = cljs.core.rest.call(null,(state_17697[(4)])));

return statearr_17714;
})();
var state_17697__$1 = state_17697;
var statearr_17715_17731 = state_17697__$1;
(statearr_17715_17731[(2)] = inst_17677);

(statearr_17715_17731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (8))){
var inst_17662 = (state_17697[(2)]);
var state_17697__$1 = (function (){var statearr_17716 = state_17697;
(statearr_17716[(7)] = inst_17662);

return statearr_17716;
})();
var statearr_17717_17732 = state_17697__$1;
(statearr_17717_17732[(2)] = null);

(statearr_17717_17732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2703__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2703__auto____0 = (function (){
var statearr_17718 = [null,null,null,null,null,null,null,null];
(statearr_17718[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2703__auto__);

(statearr_17718[(1)] = (1));

return statearr_17718;
});
var fluree$db$query$schema$setting_map_$_state_machine__2703__auto____1 = (function (state_17697){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_17697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e17719){var ex__2706__auto__ = e17719;
var statearr_17720_17733 = state_17697;
(statearr_17720_17733[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_17697[(4)]))){
var statearr_17721_17734 = state_17697;
(statearr_17721_17734[(1)] = cljs.core.first.call(null,(state_17697[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17735 = state_17697;
state_17697 = G__17735;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2703__auto__ = function(state_17697){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2703__auto____1.call(this,state_17697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2703__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2703__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_17722 = f__2726__auto__.call(null);
(statearr_17722[(6)] = c__2725__auto__);

return statearr_17722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
