// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__19462 = arguments.length;
switch (G__19462) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__19465 = arguments.length;
switch (G__19465) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2725__auto___19518 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_19496){
var state_val_19497 = (state_19496[(1)]);
if((state_val_19497 === (1))){
var state_19496__$1 = state_19496;
var statearr_19498_19519 = state_19496__$1;
(statearr_19498_19519[(2)] = null);

(statearr_19498_19519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (2))){
var _ = (function (){var statearr_19499 = state_19496;
(statearr_19499[(4)] = cljs.core.cons.call(null,(5),(state_19496[(4)])));

return statearr_19499;
})();
var inst_19473 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_19496__$1 = state_19496;
if(cljs.core.truth_(inst_19473)){
var statearr_19500_19520 = state_19496__$1;
(statearr_19500_19520[(1)] = (6));

} else {
var statearr_19501_19521 = state_19496__$1;
(statearr_19501_19521[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (3))){
var inst_19494 = (state_19496[(2)]);
var state_19496__$1 = state_19496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19496__$1,inst_19494);
} else {
if((state_val_19497 === (4))){
var inst_19466 = (state_19496[(2)]);
var inst_19467 = cljs.core.async.put_BANG_.call(null,pc,inst_19466);
var state_19496__$1 = state_19496;
var statearr_19503_19522 = state_19496__$1;
(statearr_19503_19522[(2)] = inst_19467);

(statearr_19503_19522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (5))){
var _ = (function (){var statearr_19504 = state_19496;
(statearr_19504[(4)] = cljs.core.rest.call(null,(state_19496[(4)])));

return statearr_19504;
})();
var state_19496__$1 = state_19496;
var ex19502 = (state_19496__$1[(2)]);
var statearr_19505_19523 = state_19496__$1;
(statearr_19505_19523[(5)] = ex19502);


var statearr_19506_19524 = state_19496__$1;
(statearr_19506_19524[(1)] = (4));

(statearr_19506_19524[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (6))){
var inst_19475 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19476 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_19477 = cljs.core.PersistentHashMap.fromArrays(inst_19475,inst_19476);
var inst_19478 = cljs.core.ex_info.call(null,"Connection was closed.",inst_19477);
var inst_19479 = (function(){throw inst_19478})();
var state_19496__$1 = state_19496;
var statearr_19507_19525 = state_19496__$1;
(statearr_19507_19525[(2)] = inst_19479);

(statearr_19507_19525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (7))){
var inst_19481 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_19482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19483 = [operation,data,pc,opts];
var inst_19484 = (new cljs.core.PersistentVector(null,4,(5),inst_19482,inst_19483,null));
var inst_19485 = cljs.core.async.put_BANG_.call(null,inst_19481,inst_19484);
var inst_19486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19487 = [operation,data,pc,opts];
var inst_19488 = (new cljs.core.PersistentVector(null,4,(5),inst_19486,inst_19487,null));
var inst_19489 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_19488);
var state_19496__$1 = (function (){var statearr_19508 = state_19496;
(statearr_19508[(7)] = inst_19485);

return statearr_19508;
})();
var statearr_19509_19526 = state_19496__$1;
(statearr_19509_19526[(2)] = inst_19489);

(statearr_19509_19526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (8))){
var inst_19491 = (state_19496[(2)]);
var _ = (function (){var statearr_19510 = state_19496;
(statearr_19510[(4)] = cljs.core.rest.call(null,(state_19496[(4)])));

return statearr_19510;
})();
var state_19496__$1 = state_19496;
var statearr_19511_19527 = state_19496__$1;
(statearr_19511_19527[(2)] = inst_19491);

(statearr_19511_19527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2703__auto__ = null;
var fluree$db$operations$state_machine__2703__auto____0 = (function (){
var statearr_19512 = [null,null,null,null,null,null,null,null];
(statearr_19512[(0)] = fluree$db$operations$state_machine__2703__auto__);

(statearr_19512[(1)] = (1));

return statearr_19512;
});
var fluree$db$operations$state_machine__2703__auto____1 = (function (state_19496){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_19496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e19513){var ex__2706__auto__ = e19513;
var statearr_19514_19528 = state_19496;
(statearr_19514_19528[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_19496[(4)]))){
var statearr_19515_19529 = state_19496;
(statearr_19515_19529[(1)] = cljs.core.first.call(null,(state_19496[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19530 = state_19496;
state_19496 = G__19530;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2703__auto__ = function(state_19496){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2703__auto____1.call(this,state_19496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2703__auto____0;
fluree$db$operations$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2703__auto____1;
return fluree$db$operations$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_19516 = f__2726__auto__.call(null);
(statearr_19516[(6)] = c__2725__auto___19518);

return statearr_19516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__19532 = arguments.length;
switch (G__19532) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__19533){
var map__19534 = p__19533;
var map__19534__$1 = cljs.core.__destructure_map.call(null,map__19534);
var opts = map__19534__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__19534__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__19535 = session;
var map__19535__$1 = cljs.core.__destructure_map.call(null,map__19535);
var dbid = cljs.core.get.call(null,map__19535__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__19535__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__19535__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5775__auto__ = [];
var len__5769__auto___19562 = arguments.length;
var i__5770__auto___19563 = (0);
while(true){
if((i__5770__auto___19563 < len__5769__auto___19562)){
args__5775__auto__.push((arguments[i__5770__auto___19563]));

var G__19564 = (i__5770__auto___19563 + (1));
i__5770__auto___19563 = G__19564;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__19539){
var vec__19540 = p__19539;
var map__19543 = cljs.core.nth.call(null,vec__19540,(0),null);
var map__19543__$1 = cljs.core.__destructure_map.call(null,map__19543);
var toBlock = cljs.core.get.call(null,map__19543__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__19543__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__19540;
var c__2725__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2726__auto__ = (function (){var switch__2702__auto__ = (function (state_19555){
var state_val_19556 = (state_19555[(1)]);
if((state_val_19556 === (1))){
var inst_19545 = session;
var inst_19546 = cljs.core.__destructure_map.call(null,inst_19545);
var inst_19547 = cljs.core.get.call(null,inst_19546,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_19548 = cljs.core.get.call(null,inst_19546,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_19549 = cljs.core.get.call(null,inst_19546,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_19550 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_19551 = [inst_19547,inst_19548,toBlock,toTime];
var inst_19552 = cljs.core.PersistentHashMap.fromArrays(inst_19550,inst_19551);
var inst_19553 = fluree.db.operations.send_operation.call(null,inst_19549,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_19552);
var state_19555__$1 = state_19555;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19555__$1,inst_19553);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2703__auto__ = null;
var fluree$db$operations$state_machine__2703__auto____0 = (function (){
var statearr_19557 = [null,null,null,null,null,null,null];
(statearr_19557[(0)] = fluree$db$operations$state_machine__2703__auto__);

(statearr_19557[(1)] = (1));

return statearr_19557;
});
var fluree$db$operations$state_machine__2703__auto____1 = (function (state_19555){
while(true){
var ret_value__2704__auto__ = (function (){try{while(true){
var result__2705__auto__ = switch__2702__auto__.call(null,state_19555);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2705__auto__;
}
break;
}
}catch (e19558){var ex__2706__auto__ = e19558;
var statearr_19559_19565 = state_19555;
(statearr_19559_19565[(2)] = ex__2706__auto__);


if(cljs.core.seq.call(null,(state_19555[(4)]))){
var statearr_19560_19566 = state_19555;
(statearr_19560_19566[(1)] = cljs.core.first.call(null,(state_19555[(4)])));

} else {
throw ex__2706__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19567 = state_19555;
state_19555 = G__19567;
continue;
} else {
return ret_value__2704__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2703__auto__ = function(state_19555){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2703__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2703__auto____1.call(this,state_19555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2703__auto____0;
fluree$db$operations$state_machine__2703__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2703__auto____1;
return fluree$db$operations$state_machine__2703__auto__;
})()
})();
var state__2727__auto__ = (function (){var statearr_19561 = f__2726__auto__.call(null);
(statearr_19561[(6)] = c__2725__auto__);

return statearr_19561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2727__auto__);
}));

return c__2725__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq19537){
var G__19538 = cljs.core.first.call(null,seq19537);
var seq19537__$1 = cljs.core.next.call(null,seq19537);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19538,seq19537__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__19568 = session;
var map__19568__$1 = cljs.core.__destructure_map.call(null,map__19568);
var network = cljs.core.get.call(null,map__19568__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__19568__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__19568__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__19570 = arguments.length;
switch (G__19570) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__19571 = opts;
var map__19571__$1 = cljs.core.__destructure_map.call(null,map__19571);
var auth = cljs.core.get.call(null,map__19571__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__19571__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsubscribe","unsubscribe",632650147),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
