// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___36933 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_36970){
var state_val_36971 = (state_36970[(1)]);
if((state_val_36971 === (7))){
var inst_36965 = (state_36970[(2)]);
var _ = (function (){var statearr_36972 = state_36970;
(statearr_36972[(4)] = cljs.core.rest.call(null,(state_36970[(4)])));

return statearr_36972;
})();
var state_36970__$1 = state_36970;
var statearr_36973_37000 = state_36970__$1;
(statearr_36973_37000[(2)] = inst_36965);

(statearr_36973_37000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (1))){
var state_36970__$1 = state_36970;
var statearr_36974_37001 = state_36970__$1;
(statearr_36974_37001[(2)] = null);

(statearr_36974_37001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (4))){
var inst_36934 = (state_36970[(2)]);
var state_36970__$1 = state_36970;
var statearr_36975_37002 = state_36970__$1;
(statearr_36975_37002[(2)] = inst_36934);

(statearr_36975_37002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (13))){
var inst_36961 = (state_36970[(2)]);
var state_36970__$1 = state_36970;
var statearr_36976_37003 = state_36970__$1;
(statearr_36976_37003[(2)] = inst_36961);

(statearr_36976_37003[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (6))){
var inst_36940 = (state_36970[(7)]);
var inst_36942 = (state_36970[(8)]);
var inst_36945 = cljs.core._EQ_.call(null,inst_36942,inst_36940);
var state_36970__$1 = state_36970;
if(inst_36945){
var statearr_36977_37004 = state_36970__$1;
(statearr_36977_37004[(1)] = (8));

} else {
var statearr_36978_37005 = state_36970__$1;
(statearr_36978_37005[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (3))){
var inst_36968 = (state_36970[(2)]);
var state_36970__$1 = state_36970;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36970__$1,inst_36968);
} else {
if((state_val_36971 === (12))){
var inst_36943 = (state_36970[(9)]);
var inst_36948 = (state_36970[(10)]);
var inst_36949 = (state_36970[(11)]);
var inst_36958 = cljs.core.conj.call(null,inst_36943,inst_36948);
var inst_36942 = inst_36949;
var inst_36943__$1 = inst_36958;
var state_36970__$1 = (function (){var statearr_36979 = state_36970;
(statearr_36979[(9)] = inst_36943__$1);

(statearr_36979[(8)] = inst_36942);

return statearr_36979;
})();
var statearr_36980_37006 = state_36970__$1;
(statearr_36980_37006[(2)] = null);

(statearr_36980_37006[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (2))){
var _ = (function (){var statearr_36981 = state_36970;
(statearr_36981[(4)] = cljs.core.cons.call(null,(5),(state_36970[(4)])));

return statearr_36981;
})();
var inst_36940 = cljs.core.count.call(null,args);
var inst_36941 = cljs.core.PersistentVector.EMPTY;
var inst_36942 = (0);
var inst_36943 = inst_36941;
var state_36970__$1 = (function (){var statearr_36982 = state_36970;
(statearr_36982[(9)] = inst_36943);

(statearr_36982[(7)] = inst_36940);

(statearr_36982[(8)] = inst_36942);

return statearr_36982;
})();
var statearr_36983_37007 = state_36970__$1;
(statearr_36983_37007[(2)] = null);

(statearr_36983_37007[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (11))){
var inst_36948 = (state_36970[(10)]);
var state_36970__$1 = state_36970;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36970__$1,(14),inst_36948);
} else {
if((state_val_36971 === (9))){
var inst_36948 = (state_36970[(10)]);
var inst_36942 = (state_36970[(8)]);
var inst_36948__$1 = cljs.core.nth.call(null,args,inst_36942);
var inst_36949 = (inst_36942 + (1));
var inst_36950 = fluree.db.util.async.channel_QMARK_.call(null,inst_36948__$1);
var state_36970__$1 = (function (){var statearr_36985 = state_36970;
(statearr_36985[(10)] = inst_36948__$1);

(statearr_36985[(11)] = inst_36949);

return statearr_36985;
})();
if(inst_36950){
var statearr_36986_37008 = state_36970__$1;
(statearr_36986_37008[(1)] = (11));

} else {
var statearr_36987_37009 = state_36970__$1;
(statearr_36987_37009[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (5))){
var _ = (function (){var statearr_36988 = state_36970;
(statearr_36988[(4)] = cljs.core.rest.call(null,(state_36970[(4)])));

return statearr_36988;
})();
var state_36970__$1 = state_36970;
var ex36984 = (state_36970__$1[(2)]);
var statearr_36989_37010 = state_36970__$1;
(statearr_36989_37010[(5)] = ex36984);


if((ex36984 instanceof Error)){
var statearr_36990_37011 = state_36970__$1;
(statearr_36990_37011[(1)] = (4));

(statearr_36990_37011[(5)] = null);

} else {
throw ex36984;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (14))){
var inst_36943 = (state_36970[(9)]);
var inst_36949 = (state_36970[(11)]);
var inst_36953 = (state_36970[(2)]);
var inst_36954 = fluree.db.util.async.throw_err.call(null,inst_36953);
var inst_36955 = cljs.core.conj.call(null,inst_36943,inst_36954);
var inst_36942 = inst_36949;
var inst_36943__$1 = inst_36955;
var state_36970__$1 = (function (){var statearr_36991 = state_36970;
(statearr_36991[(9)] = inst_36943__$1);

(statearr_36991[(8)] = inst_36942);

return statearr_36991;
})();
var statearr_36992_37012 = state_36970__$1;
(statearr_36992_37012[(2)] = null);

(statearr_36992_37012[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (10))){
var inst_36963 = (state_36970[(2)]);
var state_36970__$1 = state_36970;
var statearr_36993_37013 = state_36970__$1;
(statearr_36993_37013[(2)] = inst_36963);

(statearr_36993_37013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36971 === (8))){
var inst_36943 = (state_36970[(9)]);
var state_36970__$1 = state_36970;
var statearr_36994_37014 = state_36970__$1;
(statearr_36994_37014[(2)] = inst_36943);

(statearr_36994_37014[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto____0 = (function (){
var statearr_36995 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36995[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto__);

(statearr_36995[(1)] = (1));

return statearr_36995;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto____1 = (function (state_36970){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_36970);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e36996){var ex__2724__auto__ = e36996;
var statearr_36997_37015 = state_36970;
(statearr_36997_37015[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_36970[(4)]))){
var statearr_36998_37016 = state_36970;
(statearr_36998_37016[(1)] = cljs.core.first.call(null,(state_36970[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37017 = state_36970;
state_36970 = G__37017;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto__ = function(state_36970){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto____1.call(this,state_36970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_36999 = f__2744__auto__.call(null);
(statearr_36999[(6)] = c__2743__auto__);

return statearr_36999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__37018 = entry;
var res = cljs.core.nth.call(null,vec__37018,(0),null);
var cost = cljs.core.nth.call(null,vec__37018,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37066){
var state_val_37067 = (state_37066[(1)]);
if((state_val_37067 === (7))){
var state_37066__$1 = state_37066;
var statearr_37068_37097 = state_37066__$1;
(statearr_37068_37097[(2)] = coll);

(statearr_37068_37097[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (1))){
var state_37066__$1 = state_37066;
var statearr_37069_37098 = state_37066__$1;
(statearr_37069_37098[(2)] = null);

(statearr_37069_37098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (4))){
var inst_37021 = (state_37066[(2)]);
var state_37066__$1 = state_37066;
var statearr_37070_37099 = state_37066__$1;
(statearr_37070_37099[(2)] = inst_37021);

(statearr_37070_37099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (15))){
var inst_37040 = (state_37066[(7)]);
var inst_37048 = (state_37066[(2)]);
var inst_37049 = fluree.db.dbfunctions.internal.nth.call(null,inst_37040,inst_37048);
var inst_37050 = cljs.core.count.call(null,inst_37040);
var inst_37051 = ((9) + inst_37050);
var inst_37052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37053 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37055 = [inst_37040,inst_37048];
var inst_37056 = (new cljs.core.PersistentVector(null,2,(5),inst_37054,inst_37055,null));
var inst_37057 = ["nth",inst_37056,inst_37049];
var inst_37058 = cljs.core.PersistentHashMap.fromArrays(inst_37053,inst_37057);
var inst_37059 = [inst_37058,inst_37051];
var inst_37060 = (new cljs.core.PersistentVector(null,2,(5),inst_37052,inst_37059,null));
var inst_37061 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37060);
var _ = (function (){var statearr_37071 = state_37066;
(statearr_37071[(4)] = cljs.core.rest.call(null,(state_37066[(4)])));

return statearr_37071;
})();
var state_37066__$1 = (function (){var statearr_37072 = state_37066;
(statearr_37072[(8)] = inst_37061);

return statearr_37072;
})();
var statearr_37073_37100 = state_37066__$1;
(statearr_37073_37100[(2)] = inst_37049);

(statearr_37073_37100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (13))){
var state_37066__$1 = state_37066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37066__$1,(16),key);
} else {
if((state_val_37067 === (6))){
var state_37066__$1 = state_37066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37066__$1,(9),coll);
} else {
if((state_val_37067 === (3))){
var inst_37064 = (state_37066[(2)]);
var state_37066__$1 = state_37066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37066__$1,inst_37064);
} else {
if((state_val_37067 === (12))){
var inst_37040 = (state_37066[(2)]);
var inst_37041 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_37066__$1 = (function (){var statearr_37074 = state_37066;
(statearr_37074[(7)] = inst_37040);

return statearr_37074;
})();
if(inst_37041){
var statearr_37075_37101 = state_37066__$1;
(statearr_37075_37101[(1)] = (13));

} else {
var statearr_37076_37102 = state_37066__$1;
(statearr_37076_37102[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (2))){
var _ = (function (){var statearr_37077 = state_37066;
(statearr_37077[(4)] = cljs.core.cons.call(null,(5),(state_37066[(4)])));

return statearr_37077;
})();
var inst_37027 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_37066__$1 = state_37066;
if(inst_37027){
var statearr_37078_37103 = state_37066__$1;
(statearr_37078_37103[(1)] = (6));

} else {
var statearr_37079_37104 = state_37066__$1;
(statearr_37079_37104[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (11))){
var inst_37034 = (state_37066[(9)]);
var state_37066__$1 = state_37066;
var statearr_37081_37105 = state_37066__$1;
(statearr_37081_37105[(2)] = inst_37034);

(statearr_37081_37105[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (9))){
var inst_37030 = (state_37066[(2)]);
var inst_37031 = fluree.db.util.async.throw_err.call(null,inst_37030);
var state_37066__$1 = state_37066;
var statearr_37082_37106 = state_37066__$1;
(statearr_37082_37106[(2)] = inst_37031);

(statearr_37082_37106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (5))){
var _ = (function (){var statearr_37083 = state_37066;
(statearr_37083[(4)] = cljs.core.rest.call(null,(state_37066[(4)])));

return statearr_37083;
})();
var state_37066__$1 = state_37066;
var ex37080 = (state_37066__$1[(2)]);
var statearr_37084_37107 = state_37066__$1;
(statearr_37084_37107[(5)] = ex37080);


if((ex37080 instanceof Error)){
var statearr_37085_37108 = state_37066__$1;
(statearr_37085_37108[(1)] = (4));

(statearr_37085_37108[(5)] = null);

} else {
throw ex37080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (14))){
var state_37066__$1 = state_37066;
var statearr_37086_37109 = state_37066__$1;
(statearr_37086_37109[(2)] = key);

(statearr_37086_37109[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (16))){
var inst_37044 = (state_37066[(2)]);
var inst_37045 = fluree.db.util.async.throw_err.call(null,inst_37044);
var state_37066__$1 = state_37066;
var statearr_37087_37110 = state_37066__$1;
(statearr_37087_37110[(2)] = inst_37045);

(statearr_37087_37110[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (10))){
var inst_37034 = (state_37066[(9)]);
var inst_37037 = cljs.core.vec.call(null,inst_37034);
var state_37066__$1 = state_37066;
var statearr_37088_37111 = state_37066__$1;
(statearr_37088_37111[(2)] = inst_37037);

(statearr_37088_37111[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37067 === (8))){
var inst_37034 = (state_37066[(9)]);
var inst_37034__$1 = (state_37066[(2)]);
var inst_37035 = cljs.core.set_QMARK_.call(null,inst_37034__$1);
var state_37066__$1 = (function (){var statearr_37089 = state_37066;
(statearr_37089[(9)] = inst_37034__$1);

return statearr_37089;
})();
if(inst_37035){
var statearr_37090_37112 = state_37066__$1;
(statearr_37090_37112[(1)] = (10));

} else {
var statearr_37091_37113 = state_37066__$1;
(statearr_37091_37113[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto____0 = (function (){
var statearr_37092 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37092[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto__);

(statearr_37092[(1)] = (1));

return statearr_37092;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto____1 = (function (state_37066){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37093){var ex__2724__auto__ = e37093;
var statearr_37094_37114 = state_37066;
(statearr_37094_37114[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37066[(4)]))){
var statearr_37095_37115 = state_37066;
(statearr_37095_37115[(1)] = cljs.core.first.call(null,(state_37066[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37116 = state_37066;
state_37066 = G__37116;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto__ = function(state_37066){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto____1.call(this,state_37066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37096 = f__2744__auto__.call(null);
(statearr_37096[(6)] = c__2743__auto__);

return statearr_37096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37177){
var state_val_37178 = (state_37177[(1)]);
if((state_val_37178 === (7))){
var state_37177__$1 = state_37177;
var statearr_37179_37213 = state_37177__$1;
(statearr_37179_37213[(2)] = test);

(statearr_37179_37213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (20))){
var inst_37151 = (state_37177[(2)]);
var inst_37152 = fluree.db.util.async.throw_err.call(null,inst_37151);
var state_37177__$1 = state_37177;
var statearr_37180_37214 = state_37177__$1;
(statearr_37180_37214[(2)] = inst_37152);

(statearr_37180_37214[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (1))){
var state_37177__$1 = state_37177;
var statearr_37181_37215 = state_37177__$1;
(statearr_37181_37215[(2)] = null);

(statearr_37181_37215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (4))){
var inst_37117 = (state_37177[(2)]);
var state_37177__$1 = state_37177;
var statearr_37182_37216 = state_37177__$1;
(statearr_37182_37216[(2)] = inst_37117);

(statearr_37182_37216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (15))){
var inst_37135 = (state_37177[(7)]);
var inst_37143 = (state_37177[(2)]);
var inst_37144 = [inst_37143,f];
var inst_37145 = (new cljs.core.PersistentVector(null,2,(5),inst_37135,inst_37144,null));
var state_37177__$1 = state_37177;
var statearr_37183_37217 = state_37177__$1;
(statearr_37183_37217[(2)] = inst_37145);

(statearr_37183_37217[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (13))){
var state_37177__$1 = state_37177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37177__$1,(16),t);
} else {
if((state_val_37178 === (6))){
var state_37177__$1 = state_37177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37177__$1,(9),test);
} else {
if((state_val_37178 === (17))){
var state_37177__$1 = state_37177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37177__$1,(20),f);
} else {
if((state_val_37178 === (3))){
var inst_37175 = (state_37177[(2)]);
var state_37177__$1 = state_37177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37177__$1,inst_37175);
} else {
if((state_val_37178 === (12))){
var inst_37133 = (state_37177[(8)]);
var inst_37159 = (state_37177[(2)]);
var inst_37160 = cljs.core.nth.call(null,inst_37159,(0),null);
var inst_37161 = cljs.core.nth.call(null,inst_37159,(1),null);
var inst_37162 = fluree.db.dbfunctions.internal.if_else.call(null,inst_37133,inst_37160,inst_37161);
var inst_37163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37164 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37166 = [inst_37133,inst_37160,inst_37161];
var inst_37167 = (new cljs.core.PersistentVector(null,3,(5),inst_37165,inst_37166,null));
var inst_37168 = ["if-else",inst_37167,inst_37162];
var inst_37169 = cljs.core.PersistentHashMap.fromArrays(inst_37164,inst_37168);
var inst_37170 = [inst_37169,(10)];
var inst_37171 = (new cljs.core.PersistentVector(null,2,(5),inst_37163,inst_37170,null));
var inst_37172 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37171);
var _ = (function (){var statearr_37184 = state_37177;
(statearr_37184[(4)] = cljs.core.rest.call(null,(state_37177[(4)])));

return statearr_37184;
})();
var state_37177__$1 = (function (){var statearr_37185 = state_37177;
(statearr_37185[(9)] = inst_37172);

return statearr_37185;
})();
var statearr_37186_37218 = state_37177__$1;
(statearr_37186_37218[(2)] = inst_37162);

(statearr_37186_37218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (2))){
var _ = (function (){var statearr_37187 = state_37177;
(statearr_37187[(4)] = cljs.core.cons.call(null,(5),(state_37177[(4)])));

return statearr_37187;
})();
var inst_37126 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_37177__$1 = state_37177;
if(inst_37126){
var statearr_37188_37219 = state_37177__$1;
(statearr_37188_37219[(1)] = (6));

} else {
var statearr_37189_37220 = state_37177__$1;
(statearr_37189_37220[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (19))){
var inst_37147 = (state_37177[(10)]);
var inst_37155 = (state_37177[(2)]);
var inst_37156 = [f,inst_37155];
var inst_37157 = (new cljs.core.PersistentVector(null,2,(5),inst_37147,inst_37156,null));
var state_37177__$1 = state_37177;
var statearr_37190_37221 = state_37177__$1;
(statearr_37190_37221[(2)] = inst_37157);

(statearr_37190_37221[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (11))){
var inst_37147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37148 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_37177__$1 = (function (){var statearr_37192 = state_37177;
(statearr_37192[(10)] = inst_37147);

return statearr_37192;
})();
if(inst_37148){
var statearr_37193_37222 = state_37177__$1;
(statearr_37193_37222[(1)] = (17));

} else {
var statearr_37194_37223 = state_37177__$1;
(statearr_37194_37223[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (9))){
var inst_37129 = (state_37177[(2)]);
var inst_37130 = fluree.db.util.async.throw_err.call(null,inst_37129);
var state_37177__$1 = state_37177;
var statearr_37195_37224 = state_37177__$1;
(statearr_37195_37224[(2)] = inst_37130);

(statearr_37195_37224[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (5))){
var _ = (function (){var statearr_37196 = state_37177;
(statearr_37196[(4)] = cljs.core.rest.call(null,(state_37177[(4)])));

return statearr_37196;
})();
var state_37177__$1 = state_37177;
var ex37191 = (state_37177__$1[(2)]);
var statearr_37197_37225 = state_37177__$1;
(statearr_37197_37225[(5)] = ex37191);


if((ex37191 instanceof Error)){
var statearr_37198_37226 = state_37177__$1;
(statearr_37198_37226[(1)] = (4));

(statearr_37198_37226[(5)] = null);

} else {
throw ex37191;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (14))){
var state_37177__$1 = state_37177;
var statearr_37199_37227 = state_37177__$1;
(statearr_37199_37227[(2)] = t);

(statearr_37199_37227[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (16))){
var inst_37139 = (state_37177[(2)]);
var inst_37140 = fluree.db.util.async.throw_err.call(null,inst_37139);
var state_37177__$1 = state_37177;
var statearr_37200_37228 = state_37177__$1;
(statearr_37200_37228[(2)] = inst_37140);

(statearr_37200_37228[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (10))){
var inst_37135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37136 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_37177__$1 = (function (){var statearr_37201 = state_37177;
(statearr_37201[(7)] = inst_37135);

return statearr_37201;
})();
if(inst_37136){
var statearr_37202_37229 = state_37177__$1;
(statearr_37202_37229[(1)] = (13));

} else {
var statearr_37203_37230 = state_37177__$1;
(statearr_37203_37230[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (18))){
var state_37177__$1 = state_37177;
var statearr_37204_37231 = state_37177__$1;
(statearr_37204_37231[(2)] = f);

(statearr_37204_37231[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37178 === (8))){
var inst_37133 = (state_37177[(8)]);
var inst_37133__$1 = (state_37177[(2)]);
var state_37177__$1 = (function (){var statearr_37205 = state_37177;
(statearr_37205[(8)] = inst_37133__$1);

return statearr_37205;
})();
if(cljs.core.truth_(inst_37133__$1)){
var statearr_37206_37232 = state_37177__$1;
(statearr_37206_37232[(1)] = (10));

} else {
var statearr_37207_37233 = state_37177__$1;
(statearr_37207_37233[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto____0 = (function (){
var statearr_37208 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37208[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto__);

(statearr_37208[(1)] = (1));

return statearr_37208;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto____1 = (function (state_37177){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37209){var ex__2724__auto__ = e37209;
var statearr_37210_37234 = state_37177;
(statearr_37210_37234[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37177[(4)]))){
var statearr_37211_37235 = state_37177;
(statearr_37211_37235[(1)] = cljs.core.first.call(null,(state_37177[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37236 = state_37177;
state_37177 = G__37236;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto__ = function(state_37177){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto____1.call(this,state_37177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37212 = f__2744__auto__.call(null);
(statearr_37212[(6)] = c__2743__auto__);

return statearr_37212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37266){
var state_val_37267 = (state_37266[(1)]);
if((state_val_37267 === (7))){
var state_37266__$1 = state_37266;
var statearr_37268_37287 = state_37266__$1;
(statearr_37268_37287[(2)] = arg);

(statearr_37268_37287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37267 === (1))){
var state_37266__$1 = state_37266;
var statearr_37269_37288 = state_37266__$1;
(statearr_37269_37288[(2)] = null);

(statearr_37269_37288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37267 === (4))){
var inst_37237 = (state_37266[(2)]);
var state_37266__$1 = state_37266;
var statearr_37270_37289 = state_37266__$1;
(statearr_37270_37289[(2)] = inst_37237);

(statearr_37270_37289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37267 === (6))){
var state_37266__$1 = state_37266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37266__$1,(9),arg);
} else {
if((state_val_37267 === (3))){
var inst_37264 = (state_37266[(2)]);
var state_37266__$1 = state_37266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37266__$1,inst_37264);
} else {
if((state_val_37267 === (2))){
var _ = (function (){var statearr_37272 = state_37266;
(statearr_37272[(4)] = cljs.core.cons.call(null,(5),(state_37266[(4)])));

return statearr_37272;
})();
var inst_37243 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_37266__$1 = state_37266;
if(inst_37243){
var statearr_37273_37290 = state_37266__$1;
(statearr_37273_37290[(1)] = (6));

} else {
var statearr_37274_37291 = state_37266__$1;
(statearr_37274_37291[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37267 === (9))){
var inst_37246 = (state_37266[(2)]);
var inst_37247 = fluree.db.util.async.throw_err.call(null,inst_37246);
var state_37266__$1 = state_37266;
var statearr_37275_37292 = state_37266__$1;
(statearr_37275_37292[(2)] = inst_37247);

(statearr_37275_37292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37267 === (5))){
var _ = (function (){var statearr_37276 = state_37266;
(statearr_37276[(4)] = cljs.core.rest.call(null,(state_37266[(4)])));

return statearr_37276;
})();
var state_37266__$1 = state_37266;
var ex37271 = (state_37266__$1[(2)]);
var statearr_37277_37293 = state_37266__$1;
(statearr_37277_37293[(5)] = ex37271);


if((ex37271 instanceof Error)){
var statearr_37278_37294 = state_37266__$1;
(statearr_37278_37294[(1)] = (4));

(statearr_37278_37294[(5)] = null);

} else {
throw ex37271;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37267 === (8))){
var inst_37250 = (state_37266[(2)]);
var inst_37251 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_37250);
var inst_37252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37253 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37255 = [inst_37250];
var inst_37256 = (new cljs.core.PersistentVector(null,1,(5),inst_37254,inst_37255,null));
var inst_37257 = ["nil?",inst_37256,inst_37251];
var inst_37258 = cljs.core.PersistentHashMap.fromArrays(inst_37253,inst_37257);
var inst_37259 = [inst_37258,(10)];
var inst_37260 = (new cljs.core.PersistentVector(null,2,(5),inst_37252,inst_37259,null));
var inst_37261 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37260);
var _ = (function (){var statearr_37279 = state_37266;
(statearr_37279[(4)] = cljs.core.rest.call(null,(state_37266[(4)])));

return statearr_37279;
})();
var state_37266__$1 = (function (){var statearr_37280 = state_37266;
(statearr_37280[(7)] = inst_37261);

return statearr_37280;
})();
var statearr_37281_37295 = state_37266__$1;
(statearr_37281_37295[(2)] = inst_37251);

(statearr_37281_37295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto____0 = (function (){
var statearr_37282 = [null,null,null,null,null,null,null,null];
(statearr_37282[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto__);

(statearr_37282[(1)] = (1));

return statearr_37282;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto____1 = (function (state_37266){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37283){var ex__2724__auto__ = e37283;
var statearr_37284_37296 = state_37266;
(statearr_37284_37296[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37266[(4)]))){
var statearr_37285_37297 = state_37266;
(statearr_37285_37297[(1)] = cljs.core.first.call(null,(state_37266[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37298 = state_37266;
state_37266 = G__37298;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto__ = function(state_37266){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto____1.call(this,state_37266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37286 = f__2744__auto__.call(null);
(statearr_37286[(6)] = c__2743__auto__);

return statearr_37286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37328){
var state_val_37329 = (state_37328[(1)]);
if((state_val_37329 === (7))){
var state_37328__$1 = state_37328;
var statearr_37330_37349 = state_37328__$1;
(statearr_37330_37349[(2)] = arg);

(statearr_37330_37349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (1))){
var state_37328__$1 = state_37328;
var statearr_37331_37350 = state_37328__$1;
(statearr_37331_37350[(2)] = null);

(statearr_37331_37350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (4))){
var inst_37299 = (state_37328[(2)]);
var state_37328__$1 = state_37328;
var statearr_37332_37351 = state_37328__$1;
(statearr_37332_37351[(2)] = inst_37299);

(statearr_37332_37351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (6))){
var state_37328__$1 = state_37328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37328__$1,(9),arg);
} else {
if((state_val_37329 === (3))){
var inst_37326 = (state_37328[(2)]);
var state_37328__$1 = state_37328;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37328__$1,inst_37326);
} else {
if((state_val_37329 === (2))){
var _ = (function (){var statearr_37334 = state_37328;
(statearr_37334[(4)] = cljs.core.cons.call(null,(5),(state_37328[(4)])));

return statearr_37334;
})();
var inst_37305 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_37328__$1 = state_37328;
if(inst_37305){
var statearr_37335_37352 = state_37328__$1;
(statearr_37335_37352[(1)] = (6));

} else {
var statearr_37336_37353 = state_37328__$1;
(statearr_37336_37353[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (9))){
var inst_37308 = (state_37328[(2)]);
var inst_37309 = fluree.db.util.async.throw_err.call(null,inst_37308);
var state_37328__$1 = state_37328;
var statearr_37337_37354 = state_37328__$1;
(statearr_37337_37354[(2)] = inst_37309);

(statearr_37337_37354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (5))){
var _ = (function (){var statearr_37338 = state_37328;
(statearr_37338[(4)] = cljs.core.rest.call(null,(state_37328[(4)])));

return statearr_37338;
})();
var state_37328__$1 = state_37328;
var ex37333 = (state_37328__$1[(2)]);
var statearr_37339_37355 = state_37328__$1;
(statearr_37339_37355[(5)] = ex37333);


if((ex37333 instanceof Error)){
var statearr_37340_37356 = state_37328__$1;
(statearr_37340_37356[(1)] = (4));

(statearr_37340_37356[(5)] = null);

} else {
throw ex37333;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37329 === (8))){
var inst_37312 = (state_37328[(2)]);
var inst_37313 = fluree.db.dbfunctions.internal.not.call(null,inst_37312);
var inst_37314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37315 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37317 = [inst_37312];
var inst_37318 = (new cljs.core.PersistentVector(null,1,(5),inst_37316,inst_37317,null));
var inst_37319 = ["not?",inst_37318,inst_37313];
var inst_37320 = cljs.core.PersistentHashMap.fromArrays(inst_37315,inst_37319);
var inst_37321 = [inst_37320,(10)];
var inst_37322 = (new cljs.core.PersistentVector(null,2,(5),inst_37314,inst_37321,null));
var inst_37323 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37322);
var _ = (function (){var statearr_37341 = state_37328;
(statearr_37341[(4)] = cljs.core.rest.call(null,(state_37328[(4)])));

return statearr_37341;
})();
var state_37328__$1 = (function (){var statearr_37342 = state_37328;
(statearr_37342[(7)] = inst_37323);

return statearr_37342;
})();
var statearr_37343_37357 = state_37328__$1;
(statearr_37343_37357[(2)] = inst_37313);

(statearr_37343_37357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto____0 = (function (){
var statearr_37344 = [null,null,null,null,null,null,null,null];
(statearr_37344[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto__);

(statearr_37344[(1)] = (1));

return statearr_37344;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto____1 = (function (state_37328){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37328);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37345){var ex__2724__auto__ = e37345;
var statearr_37346_37358 = state_37328;
(statearr_37346_37358[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37328[(4)]))){
var statearr_37347_37359 = state_37328;
(statearr_37347_37359[(1)] = cljs.core.first.call(null,(state_37328[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37360 = state_37328;
state_37328 = G__37360;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto__ = function(state_37328){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto____1.call(this,state_37328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37348 = f__2744__auto__.call(null);
(statearr_37348[(6)] = c__2743__auto__);

return statearr_37348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37390){
var state_val_37391 = (state_37390[(1)]);
if((state_val_37391 === (7))){
var state_37390__$1 = state_37390;
var statearr_37392_37411 = state_37390__$1;
(statearr_37392_37411[(2)] = arg);

(statearr_37392_37411[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37391 === (1))){
var state_37390__$1 = state_37390;
var statearr_37393_37412 = state_37390__$1;
(statearr_37393_37412[(2)] = null);

(statearr_37393_37412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37391 === (4))){
var inst_37361 = (state_37390[(2)]);
var state_37390__$1 = state_37390;
var statearr_37394_37413 = state_37390__$1;
(statearr_37394_37413[(2)] = inst_37361);

(statearr_37394_37413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37391 === (6))){
var state_37390__$1 = state_37390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37390__$1,(9),arg);
} else {
if((state_val_37391 === (3))){
var inst_37388 = (state_37390[(2)]);
var state_37390__$1 = state_37390;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37390__$1,inst_37388);
} else {
if((state_val_37391 === (2))){
var _ = (function (){var statearr_37396 = state_37390;
(statearr_37396[(4)] = cljs.core.cons.call(null,(5),(state_37390[(4)])));

return statearr_37396;
})();
var inst_37367 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_37390__$1 = state_37390;
if(inst_37367){
var statearr_37397_37414 = state_37390__$1;
(statearr_37397_37414[(1)] = (6));

} else {
var statearr_37398_37415 = state_37390__$1;
(statearr_37398_37415[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37391 === (9))){
var inst_37370 = (state_37390[(2)]);
var inst_37371 = fluree.db.util.async.throw_err.call(null,inst_37370);
var state_37390__$1 = state_37390;
var statearr_37399_37416 = state_37390__$1;
(statearr_37399_37416[(2)] = inst_37371);

(statearr_37399_37416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37391 === (5))){
var _ = (function (){var statearr_37400 = state_37390;
(statearr_37400[(4)] = cljs.core.rest.call(null,(state_37390[(4)])));

return statearr_37400;
})();
var state_37390__$1 = state_37390;
var ex37395 = (state_37390__$1[(2)]);
var statearr_37401_37417 = state_37390__$1;
(statearr_37401_37417[(5)] = ex37395);


if((ex37395 instanceof Error)){
var statearr_37402_37418 = state_37390__$1;
(statearr_37402_37418[(1)] = (4));

(statearr_37402_37418[(5)] = null);

} else {
throw ex37395;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37391 === (8))){
var inst_37374 = (state_37390[(2)]);
var inst_37375 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_37374);
var inst_37376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37377 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37379 = [inst_37374];
var inst_37380 = (new cljs.core.PersistentVector(null,1,(5),inst_37378,inst_37379,null));
var inst_37381 = ["empty?",inst_37380,inst_37375];
var inst_37382 = cljs.core.PersistentHashMap.fromArrays(inst_37377,inst_37381);
var inst_37383 = [inst_37382,(10)];
var inst_37384 = (new cljs.core.PersistentVector(null,2,(5),inst_37376,inst_37383,null));
var inst_37385 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37384);
var _ = (function (){var statearr_37403 = state_37390;
(statearr_37403[(4)] = cljs.core.rest.call(null,(state_37390[(4)])));

return statearr_37403;
})();
var state_37390__$1 = (function (){var statearr_37404 = state_37390;
(statearr_37404[(7)] = inst_37385);

return statearr_37404;
})();
var statearr_37405_37419 = state_37390__$1;
(statearr_37405_37419[(2)] = inst_37375);

(statearr_37405_37419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto____0 = (function (){
var statearr_37406 = [null,null,null,null,null,null,null,null];
(statearr_37406[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto__);

(statearr_37406[(1)] = (1));

return statearr_37406;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto____1 = (function (state_37390){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37390);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37407){var ex__2724__auto__ = e37407;
var statearr_37408_37420 = state_37390;
(statearr_37408_37420[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37390[(4)]))){
var statearr_37409_37421 = state_37390;
(statearr_37409_37421[(1)] = cljs.core.first.call(null,(state_37390[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37422 = state_37390;
state_37390 = G__37422;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto__ = function(state_37390){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto____1.call(this,state_37390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37410 = f__2744__auto__.call(null);
(statearr_37410[(6)] = c__2743__auto__);

return statearr_37410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37467 = arguments.length;
var i__5770__auto___37468 = (0);
while(true){
if((i__5770__auto___37468 < len__5769__auto___37467)){
args__5775__auto__.push((arguments[i__5770__auto___37468]));

var G__37469 = (i__5770__auto___37468 + (1));
i__5770__auto___37468 = G__37469;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37450){
var state_val_37451 = (state_37450[(1)]);
if((state_val_37451 === (1))){
var state_37450__$1 = state_37450;
var statearr_37452_37470 = state_37450__$1;
(statearr_37452_37470[(2)] = null);

(statearr_37452_37470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37451 === (2))){
var _ = (function (){var statearr_37453 = state_37450;
(statearr_37453[(4)] = cljs.core.cons.call(null,(5),(state_37450[(4)])));

return statearr_37453;
})();
var inst_37431 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_37450__$1 = state_37450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37450__$1,(6),inst_37431);
} else {
if((state_val_37451 === (3))){
var inst_37448 = (state_37450[(2)]);
var state_37450__$1 = state_37450;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37450__$1,inst_37448);
} else {
if((state_val_37451 === (4))){
var inst_37425 = (state_37450[(2)]);
var state_37450__$1 = state_37450;
var statearr_37455_37471 = state_37450__$1;
(statearr_37455_37471[(2)] = inst_37425);

(statearr_37455_37471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37451 === (5))){
var _ = (function (){var statearr_37456 = state_37450;
(statearr_37456[(4)] = cljs.core.rest.call(null,(state_37450[(4)])));

return statearr_37456;
})();
var state_37450__$1 = state_37450;
var ex37454 = (state_37450__$1[(2)]);
var statearr_37457_37472 = state_37450__$1;
(statearr_37457_37472[(5)] = ex37454);


if((ex37454 instanceof Error)){
var statearr_37458_37473 = state_37450__$1;
(statearr_37458_37473[(1)] = (4));

(statearr_37458_37473[(5)] = null);

} else {
throw ex37454;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37451 === (6))){
var inst_37433 = (state_37450[(2)]);
var inst_37434 = fluree.db.util.async.throw_err.call(null,inst_37433);
var inst_37435 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_37434);
var inst_37436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37437 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37439 = [inst_37434];
var inst_37440 = (new cljs.core.PersistentVector(null,1,(5),inst_37438,inst_37439,null));
var inst_37441 = ["str",inst_37440,inst_37435];
var inst_37442 = cljs.core.PersistentHashMap.fromArrays(inst_37437,inst_37441);
var inst_37443 = [inst_37442,(10)];
var inst_37444 = (new cljs.core.PersistentVector(null,2,(5),inst_37436,inst_37443,null));
var inst_37445 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37444);
var _ = (function (){var statearr_37459 = state_37450;
(statearr_37459[(4)] = cljs.core.rest.call(null,(state_37450[(4)])));

return statearr_37459;
})();
var state_37450__$1 = (function (){var statearr_37460 = state_37450;
(statearr_37460[(7)] = inst_37445);

return statearr_37460;
})();
var statearr_37461_37474 = state_37450__$1;
(statearr_37461_37474[(2)] = inst_37435);

(statearr_37461_37474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_37462 = [null,null,null,null,null,null,null,null];
(statearr_37462[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_37462[(1)] = (1));

return statearr_37462;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_37450){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37450);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37463){var ex__2724__auto__ = e37463;
var statearr_37464_37475 = state_37450;
(statearr_37464_37475[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37450[(4)]))){
var statearr_37465_37476 = state_37450;
(statearr_37465_37476[(1)] = cljs.core.first.call(null,(state_37450[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37477 = state_37450;
state_37450 = G__37477;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_37450){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_37450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37466 = f__2744__auto__.call(null);
(statearr_37466[(6)] = c__2743__auto__);

return statearr_37466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq37423){
var G__37424 = cljs.core.first.call(null,seq37423);
var seq37423__$1 = cljs.core.next.call(null,seq37423);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37424,seq37423__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37503){
var state_val_37504 = (state_37503[(1)]);
if((state_val_37504 === (1))){
var state_37503__$1 = state_37503;
var statearr_37505_37520 = state_37503__$1;
(statearr_37505_37520[(2)] = null);

(statearr_37505_37520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37504 === (2))){
var _ = (function (){var statearr_37506 = state_37503;
(statearr_37506[(4)] = cljs.core.cons.call(null,(5),(state_37503[(4)])));

return statearr_37506;
})();
var inst_37484 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_37503__$1 = state_37503;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37503__$1,(6),inst_37484);
} else {
if((state_val_37504 === (3))){
var inst_37501 = (state_37503[(2)]);
var state_37503__$1 = state_37503;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37503__$1,inst_37501);
} else {
if((state_val_37504 === (4))){
var inst_37478 = (state_37503[(2)]);
var state_37503__$1 = state_37503;
var statearr_37508_37521 = state_37503__$1;
(statearr_37508_37521[(2)] = inst_37478);

(statearr_37508_37521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37504 === (5))){
var _ = (function (){var statearr_37509 = state_37503;
(statearr_37509[(4)] = cljs.core.rest.call(null,(state_37503[(4)])));

return statearr_37509;
})();
var state_37503__$1 = state_37503;
var ex37507 = (state_37503__$1[(2)]);
var statearr_37510_37522 = state_37503__$1;
(statearr_37510_37522[(5)] = ex37507);


if((ex37507 instanceof Error)){
var statearr_37511_37523 = state_37503__$1;
(statearr_37511_37523[(1)] = (4));

(statearr_37511_37523[(5)] = null);

} else {
throw ex37507;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37504 === (6))){
var inst_37486 = (state_37503[(2)]);
var inst_37487 = fluree.db.util.async.throw_err.call(null,inst_37486);
var inst_37488 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_37487);
var inst_37489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37490 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37492 = [inst_37487];
var inst_37493 = (new cljs.core.PersistentVector(null,1,(5),inst_37491,inst_37492,null));
var inst_37494 = ["subs",inst_37493,inst_37488];
var inst_37495 = cljs.core.PersistentHashMap.fromArrays(inst_37490,inst_37494);
var inst_37496 = [inst_37495,(30)];
var inst_37497 = (new cljs.core.PersistentVector(null,2,(5),inst_37489,inst_37496,null));
var inst_37498 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37497);
var _ = (function (){var statearr_37512 = state_37503;
(statearr_37512[(4)] = cljs.core.rest.call(null,(state_37503[(4)])));

return statearr_37512;
})();
var state_37503__$1 = (function (){var statearr_37513 = state_37503;
(statearr_37513[(7)] = inst_37498);

return statearr_37513;
})();
var statearr_37514_37524 = state_37503__$1;
(statearr_37514_37524[(2)] = inst_37488);

(statearr_37514_37524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto____0 = (function (){
var statearr_37515 = [null,null,null,null,null,null,null,null];
(statearr_37515[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto__);

(statearr_37515[(1)] = (1));

return statearr_37515;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto____1 = (function (state_37503){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37503);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37516){var ex__2724__auto__ = e37516;
var statearr_37517_37525 = state_37503;
(statearr_37517_37525[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37503[(4)]))){
var statearr_37518_37526 = state_37503;
(statearr_37518_37526[(1)] = cljs.core.first.call(null,(state_37503[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37527 = state_37503;
state_37503 = G__37527;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto__ = function(state_37503){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto____1.call(this,state_37503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37519 = f__2744__auto__.call(null);
(statearr_37519[(6)] = c__2743__auto__);

return statearr_37519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37557){
var state_val_37558 = (state_37557[(1)]);
if((state_val_37558 === (7))){
var state_37557__$1 = state_37557;
var statearr_37559_37578 = state_37557__$1;
(statearr_37559_37578[(2)] = str);

(statearr_37559_37578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37558 === (1))){
var state_37557__$1 = state_37557;
var statearr_37560_37579 = state_37557__$1;
(statearr_37560_37579[(2)] = null);

(statearr_37560_37579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37558 === (4))){
var inst_37528 = (state_37557[(2)]);
var state_37557__$1 = state_37557;
var statearr_37561_37580 = state_37557__$1;
(statearr_37561_37580[(2)] = inst_37528);

(statearr_37561_37580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37558 === (6))){
var state_37557__$1 = state_37557;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37557__$1,(9),str);
} else {
if((state_val_37558 === (3))){
var inst_37555 = (state_37557[(2)]);
var state_37557__$1 = state_37557;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37557__$1,inst_37555);
} else {
if((state_val_37558 === (2))){
var _ = (function (){var statearr_37563 = state_37557;
(statearr_37563[(4)] = cljs.core.cons.call(null,(5),(state_37557[(4)])));

return statearr_37563;
})();
var inst_37534 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_37557__$1 = state_37557;
if(inst_37534){
var statearr_37564_37581 = state_37557__$1;
(statearr_37564_37581[(1)] = (6));

} else {
var statearr_37565_37582 = state_37557__$1;
(statearr_37565_37582[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37558 === (9))){
var inst_37537 = (state_37557[(2)]);
var inst_37538 = fluree.db.util.async.throw_err.call(null,inst_37537);
var state_37557__$1 = state_37557;
var statearr_37566_37583 = state_37557__$1;
(statearr_37566_37583[(2)] = inst_37538);

(statearr_37566_37583[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37558 === (5))){
var _ = (function (){var statearr_37567 = state_37557;
(statearr_37567[(4)] = cljs.core.rest.call(null,(state_37557[(4)])));

return statearr_37567;
})();
var state_37557__$1 = state_37557;
var ex37562 = (state_37557__$1[(2)]);
var statearr_37568_37584 = state_37557__$1;
(statearr_37568_37584[(5)] = ex37562);


if((ex37562 instanceof Error)){
var statearr_37569_37585 = state_37557__$1;
(statearr_37569_37585[(1)] = (4));

(statearr_37569_37585[(5)] = null);

} else {
throw ex37562;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37558 === (8))){
var inst_37541 = (state_37557[(2)]);
var inst_37542 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_37541);
var inst_37543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37544 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37546 = [inst_37541];
var inst_37547 = (new cljs.core.PersistentVector(null,1,(5),inst_37545,inst_37546,null));
var inst_37548 = ["lower-case",inst_37547,inst_37542];
var inst_37549 = cljs.core.PersistentHashMap.fromArrays(inst_37544,inst_37548);
var inst_37550 = [inst_37549,(10)];
var inst_37551 = (new cljs.core.PersistentVector(null,2,(5),inst_37543,inst_37550,null));
var inst_37552 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37551);
var _ = (function (){var statearr_37570 = state_37557;
(statearr_37570[(4)] = cljs.core.rest.call(null,(state_37557[(4)])));

return statearr_37570;
})();
var state_37557__$1 = (function (){var statearr_37571 = state_37557;
(statearr_37571[(7)] = inst_37552);

return statearr_37571;
})();
var statearr_37572_37586 = state_37557__$1;
(statearr_37572_37586[(2)] = inst_37542);

(statearr_37572_37586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto____0 = (function (){
var statearr_37573 = [null,null,null,null,null,null,null,null];
(statearr_37573[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto__);

(statearr_37573[(1)] = (1));

return statearr_37573;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto____1 = (function (state_37557){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37557);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37574){var ex__2724__auto__ = e37574;
var statearr_37575_37587 = state_37557;
(statearr_37575_37587[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37557[(4)]))){
var statearr_37576_37588 = state_37557;
(statearr_37576_37588[(1)] = cljs.core.first.call(null,(state_37557[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37589 = state_37557;
state_37557 = G__37589;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto__ = function(state_37557){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto____1.call(this,state_37557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37577 = f__2744__auto__.call(null);
(statearr_37577[(6)] = c__2743__auto__);

return statearr_37577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37619){
var state_val_37620 = (state_37619[(1)]);
if((state_val_37620 === (7))){
var state_37619__$1 = state_37619;
var statearr_37621_37640 = state_37619__$1;
(statearr_37621_37640[(2)] = str);

(statearr_37621_37640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (1))){
var state_37619__$1 = state_37619;
var statearr_37622_37641 = state_37619__$1;
(statearr_37622_37641[(2)] = null);

(statearr_37622_37641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (4))){
var inst_37590 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
var statearr_37623_37642 = state_37619__$1;
(statearr_37623_37642[(2)] = inst_37590);

(statearr_37623_37642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (6))){
var state_37619__$1 = state_37619;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37619__$1,(9),str);
} else {
if((state_val_37620 === (3))){
var inst_37617 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37619__$1,inst_37617);
} else {
if((state_val_37620 === (2))){
var _ = (function (){var statearr_37625 = state_37619;
(statearr_37625[(4)] = cljs.core.cons.call(null,(5),(state_37619[(4)])));

return statearr_37625;
})();
var inst_37596 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_37619__$1 = state_37619;
if(inst_37596){
var statearr_37626_37643 = state_37619__$1;
(statearr_37626_37643[(1)] = (6));

} else {
var statearr_37627_37644 = state_37619__$1;
(statearr_37627_37644[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (9))){
var inst_37599 = (state_37619[(2)]);
var inst_37600 = fluree.db.util.async.throw_err.call(null,inst_37599);
var state_37619__$1 = state_37619;
var statearr_37628_37645 = state_37619__$1;
(statearr_37628_37645[(2)] = inst_37600);

(statearr_37628_37645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (5))){
var _ = (function (){var statearr_37629 = state_37619;
(statearr_37629[(4)] = cljs.core.rest.call(null,(state_37619[(4)])));

return statearr_37629;
})();
var state_37619__$1 = state_37619;
var ex37624 = (state_37619__$1[(2)]);
var statearr_37630_37646 = state_37619__$1;
(statearr_37630_37646[(5)] = ex37624);


if((ex37624 instanceof Error)){
var statearr_37631_37647 = state_37619__$1;
(statearr_37631_37647[(1)] = (4));

(statearr_37631_37647[(5)] = null);

} else {
throw ex37624;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (8))){
var inst_37603 = (state_37619[(2)]);
var inst_37604 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_37603);
var inst_37605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37606 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37608 = [inst_37603];
var inst_37609 = (new cljs.core.PersistentVector(null,1,(5),inst_37607,inst_37608,null));
var inst_37610 = ["upper-case",inst_37609,inst_37604];
var inst_37611 = cljs.core.PersistentHashMap.fromArrays(inst_37606,inst_37610);
var inst_37612 = [inst_37611,(10)];
var inst_37613 = (new cljs.core.PersistentVector(null,2,(5),inst_37605,inst_37612,null));
var inst_37614 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37613);
var _ = (function (){var statearr_37632 = state_37619;
(statearr_37632[(4)] = cljs.core.rest.call(null,(state_37619[(4)])));

return statearr_37632;
})();
var state_37619__$1 = (function (){var statearr_37633 = state_37619;
(statearr_37633[(7)] = inst_37614);

return statearr_37633;
})();
var statearr_37634_37648 = state_37619__$1;
(statearr_37634_37648[(2)] = inst_37604);

(statearr_37634_37648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto____0 = (function (){
var statearr_37635 = [null,null,null,null,null,null,null,null];
(statearr_37635[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto__);

(statearr_37635[(1)] = (1));

return statearr_37635;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto____1 = (function (state_37619){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37619);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37636){var ex__2724__auto__ = e37636;
var statearr_37637_37649 = state_37619;
(statearr_37637_37649[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37619[(4)]))){
var statearr_37638_37650 = state_37619;
(statearr_37638_37650[(1)] = cljs.core.first.call(null,(state_37619[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37651 = state_37619;
state_37619 = G__37651;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto__ = function(state_37619){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto____1.call(this,state_37619);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37639 = f__2744__auto__.call(null);
(statearr_37639[(6)] = c__2743__auto__);

return statearr_37639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__37653 = arguments.length;
switch (G__37653) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37681){
var state_val_37682 = (state_37681[(1)]);
if((state_val_37682 === (1))){
var state_37681__$1 = state_37681;
var statearr_37683_37699 = state_37681__$1;
(statearr_37683_37699[(2)] = null);

(statearr_37683_37699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37682 === (2))){
var _ = (function (){var statearr_37684 = state_37681;
(statearr_37684[(4)] = cljs.core.cons.call(null,(5),(state_37681[(4)])));

return statearr_37684;
})();
var inst_37663 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_37681__$1 = state_37681;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37681__$1,(6),inst_37663);
} else {
if((state_val_37682 === (3))){
var inst_37679 = (state_37681[(2)]);
var state_37681__$1 = state_37681;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37681__$1,inst_37679);
} else {
if((state_val_37682 === (4))){
var inst_37654 = (state_37681[(2)]);
var state_37681__$1 = state_37681;
var statearr_37686_37700 = state_37681__$1;
(statearr_37686_37700[(2)] = inst_37654);

(statearr_37686_37700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37682 === (5))){
var _ = (function (){var statearr_37687 = state_37681;
(statearr_37687[(4)] = cljs.core.rest.call(null,(state_37681[(4)])));

return statearr_37687;
})();
var state_37681__$1 = state_37681;
var ex37685 = (state_37681__$1[(2)]);
var statearr_37688_37701 = state_37681__$1;
(statearr_37688_37701[(5)] = ex37685);


if((ex37685 instanceof Error)){
var statearr_37689_37702 = state_37681__$1;
(statearr_37689_37702[(1)] = (4));

(statearr_37689_37702[(5)] = null);

} else {
throw ex37685;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37682 === (6))){
var inst_37665 = (state_37681[(2)]);
var inst_37666 = fluree.db.util.async.throw_err.call(null,inst_37665);
var inst_37667 = cljs.core.nth.call(null,inst_37666,(0),null);
var inst_37668 = cljs.core.nth.call(null,inst_37666,(1),null);
var inst_37669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37670 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37671 = ["?s","?ctx",inst_37667];
var inst_37672 = cljs.core.PersistentHashMap.fromArrays(inst_37670,inst_37671);
var inst_37673 = ((10) + inst_37668);
var inst_37674 = [inst_37672,inst_37673];
var inst_37675 = (new cljs.core.PersistentVector(null,2,(5),inst_37669,inst_37674,null));
var inst_37676 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37675);
var _ = (function (){var statearr_37690 = state_37681;
(statearr_37690[(4)] = cljs.core.rest.call(null,(state_37681[(4)])));

return statearr_37690;
})();
var state_37681__$1 = (function (){var statearr_37691 = state_37681;
(statearr_37691[(7)] = inst_37676);

return statearr_37691;
})();
var statearr_37692_37703 = state_37681__$1;
(statearr_37692_37703[(2)] = inst_37667);

(statearr_37692_37703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_37693 = [null,null,null,null,null,null,null,null];
(statearr_37693[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_37693[(1)] = (1));

return statearr_37693;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_37681){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37681);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37694){var ex__2724__auto__ = e37694;
var statearr_37695_37704 = state_37681;
(statearr_37695_37704[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37681[(4)]))){
var statearr_37696_37705 = state_37681;
(statearr_37696_37705[(1)] = cljs.core.first.call(null,(state_37681[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37706 = state_37681;
state_37681 = G__37706;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_37681){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_37681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37697 = f__2744__auto__.call(null);
(statearr_37697[(6)] = c__2743__auto__);

return statearr_37697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__37708 = arguments.length;
switch (G__37708) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37746){
var state_val_37747 = (state_37746[(1)]);
if((state_val_37747 === (7))){
var inst_37739 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_37746__$1 = state_37746;
var statearr_37748_37768 = state_37746__$1;
(statearr_37748_37768[(2)] = inst_37739);

(statearr_37748_37768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37747 === (1))){
var state_37746__$1 = state_37746;
var statearr_37749_37769 = state_37746__$1;
(statearr_37749_37769[(2)] = null);

(statearr_37749_37769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37747 === (4))){
var inst_37709 = (state_37746[(2)]);
var state_37746__$1 = state_37746;
var statearr_37750_37770 = state_37746__$1;
(statearr_37750_37770[(2)] = inst_37709);

(statearr_37750_37770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37747 === (6))){
var inst_37720 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_37746__$1 = state_37746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37746__$1,(10),inst_37720);
} else {
if((state_val_37747 === (3))){
var inst_37744 = (state_37746[(2)]);
var state_37746__$1 = state_37746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37746__$1,inst_37744);
} else {
if((state_val_37747 === (2))){
var _ = (function (){var statearr_37752 = state_37746;
(statearr_37752[(4)] = cljs.core.cons.call(null,(5),(state_37746[(4)])));

return statearr_37752;
})();
var inst_37715 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_37746__$1 = state_37746;
if(cljs.core.truth_(inst_37715)){
var statearr_37753_37771 = state_37746__$1;
(statearr_37753_37771[(1)] = (6));

} else {
var statearr_37754_37772 = state_37746__$1;
(statearr_37754_37772[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37747 === (9))){
var inst_37726 = (state_37746[(2)]);
var inst_37727 = fluree.db.util.async.throw_err.call(null,inst_37726);
var inst_37728 = cljs.core.nth.call(null,inst_37727,(0),null);
var inst_37729 = cljs.core.nth.call(null,inst_37727,(1),null);
var inst_37730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37731 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37732 = ["?p","?ctx",inst_37728];
var inst_37733 = cljs.core.PersistentHashMap.fromArrays(inst_37731,inst_37732);
var inst_37734 = ((10) + inst_37729);
var inst_37735 = [inst_37733,inst_37734];
var inst_37736 = (new cljs.core.PersistentVector(null,2,(5),inst_37730,inst_37735,null));
var inst_37737 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37736);
var state_37746__$1 = (function (){var statearr_37755 = state_37746;
(statearr_37755[(7)] = inst_37737);

return statearr_37755;
})();
var statearr_37756_37773 = state_37746__$1;
(statearr_37756_37773[(2)] = inst_37728);

(statearr_37756_37773[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37747 === (5))){
var _ = (function (){var statearr_37757 = state_37746;
(statearr_37757[(4)] = cljs.core.rest.call(null,(state_37746[(4)])));

return statearr_37757;
})();
var state_37746__$1 = state_37746;
var ex37751 = (state_37746__$1[(2)]);
var statearr_37758_37774 = state_37746__$1;
(statearr_37758_37774[(5)] = ex37751);


if((ex37751 instanceof Error)){
var statearr_37759_37775 = state_37746__$1;
(statearr_37759_37775[(1)] = (4));

(statearr_37759_37775[(5)] = null);

} else {
throw ex37751;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37747 === (10))){
var inst_37722 = (state_37746[(2)]);
var inst_37723 = fluree.db.util.async.throw_err.call(null,inst_37722);
var inst_37724 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_37723);
var state_37746__$1 = state_37746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37746__$1,(9),inst_37724);
} else {
if((state_val_37747 === (8))){
var inst_37741 = (state_37746[(2)]);
var _ = (function (){var statearr_37760 = state_37746;
(statearr_37760[(4)] = cljs.core.rest.call(null,(state_37746[(4)])));

return statearr_37760;
})();
var state_37746__$1 = state_37746;
var statearr_37761_37776 = state_37746__$1;
(statearr_37761_37776[(2)] = inst_37741);

(statearr_37761_37776[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_37762 = [null,null,null,null,null,null,null,null];
(statearr_37762[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_37762[(1)] = (1));

return statearr_37762;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_37746){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37763){var ex__2724__auto__ = e37763;
var statearr_37764_37777 = state_37746;
(statearr_37764_37777[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37746[(4)]))){
var statearr_37765_37778 = state_37746;
(statearr_37765_37778[(1)] = cljs.core.first.call(null,(state_37746[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37779 = state_37746;
state_37746 = G__37779;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_37746){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_37746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37766 = f__2744__auto__.call(null);
(statearr_37766[(6)] = c__2743__auto__);

return statearr_37766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37828 = arguments.length;
var i__5770__auto___37829 = (0);
while(true){
if((i__5770__auto___37829 < len__5769__auto___37828)){
args__5775__auto__.push((arguments[i__5770__auto___37829]));

var G__37830 = (i__5770__auto___37829 + (1));
i__5770__auto___37829 = G__37830;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37811){
var state_val_37812 = (state_37811[(1)]);
if((state_val_37812 === (1))){
var state_37811__$1 = state_37811;
var statearr_37813_37831 = state_37811__$1;
(statearr_37813_37831[(2)] = null);

(statearr_37813_37831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37812 === (2))){
var _ = (function (){var statearr_37814 = state_37811;
(statearr_37814[(4)] = cljs.core.cons.call(null,(5),(state_37811[(4)])));

return statearr_37814;
})();
var inst_37788 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_37811__$1 = state_37811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37811__$1,(6),inst_37788);
} else {
if((state_val_37812 === (3))){
var inst_37809 = (state_37811[(2)]);
var state_37811__$1 = state_37811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37811__$1,inst_37809);
} else {
if((state_val_37812 === (4))){
var inst_37782 = (state_37811[(2)]);
var state_37811__$1 = state_37811;
var statearr_37816_37832 = state_37811__$1;
(statearr_37816_37832[(2)] = inst_37782);

(statearr_37816_37832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37812 === (5))){
var _ = (function (){var statearr_37817 = state_37811;
(statearr_37817[(4)] = cljs.core.rest.call(null,(state_37811[(4)])));

return statearr_37817;
})();
var state_37811__$1 = state_37811;
var ex37815 = (state_37811__$1[(2)]);
var statearr_37818_37833 = state_37811__$1;
(statearr_37818_37833[(5)] = ex37815);


if((ex37815 instanceof Error)){
var statearr_37819_37834 = state_37811__$1;
(statearr_37819_37834[(1)] = (4));

(statearr_37819_37834[(5)] = null);

} else {
throw ex37815;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37812 === (6))){
var inst_37790 = (state_37811[(2)]);
var inst_37791 = fluree.db.util.async.throw_err.call(null,inst_37790);
var inst_37792 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_37791);
var inst_37793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37794 = [inst_37791];
var inst_37795 = (new cljs.core.PersistentVector(null,1,(5),inst_37793,inst_37794,null));
var inst_37796 = cljs.core.count.call(null,inst_37795);
var inst_37797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37798 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37800 = [inst_37791];
var inst_37801 = (new cljs.core.PersistentVector(null,1,(5),inst_37799,inst_37800,null));
var inst_37802 = ["and",inst_37801,inst_37792];
var inst_37803 = cljs.core.PersistentHashMap.fromArrays(inst_37798,inst_37802);
var inst_37804 = [inst_37803,inst_37796];
var inst_37805 = (new cljs.core.PersistentVector(null,2,(5),inst_37797,inst_37804,null));
var inst_37806 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37805);
var _ = (function (){var statearr_37820 = state_37811;
(statearr_37820[(4)] = cljs.core.rest.call(null,(state_37811[(4)])));

return statearr_37820;
})();
var state_37811__$1 = (function (){var statearr_37821 = state_37811;
(statearr_37821[(7)] = inst_37806);

return statearr_37821;
})();
var statearr_37822_37835 = state_37811__$1;
(statearr_37822_37835[(2)] = inst_37792);

(statearr_37822_37835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_37823 = [null,null,null,null,null,null,null,null];
(statearr_37823[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_37823[(1)] = (1));

return statearr_37823;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_37811){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37824){var ex__2724__auto__ = e37824;
var statearr_37825_37836 = state_37811;
(statearr_37825_37836[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37811[(4)]))){
var statearr_37826_37837 = state_37811;
(statearr_37826_37837[(1)] = cljs.core.first.call(null,(state_37811[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37838 = state_37811;
state_37811 = G__37838;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_37811){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_37811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37827 = f__2744__auto__.call(null);
(statearr_37827[(6)] = c__2743__auto__);

return statearr_37827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq37780){
var G__37781 = cljs.core.first.call(null,seq37780);
var seq37780__$1 = cljs.core.next.call(null,seq37780);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37781,seq37780__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37887 = arguments.length;
var i__5770__auto___37888 = (0);
while(true){
if((i__5770__auto___37888 < len__5769__auto___37887)){
args__5775__auto__.push((arguments[i__5770__auto___37888]));

var G__37889 = (i__5770__auto___37888 + (1));
i__5770__auto___37888 = G__37889;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37870){
var state_val_37871 = (state_37870[(1)]);
if((state_val_37871 === (1))){
var state_37870__$1 = state_37870;
var statearr_37872_37890 = state_37870__$1;
(statearr_37872_37890[(2)] = null);

(statearr_37872_37890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37871 === (2))){
var _ = (function (){var statearr_37873 = state_37870;
(statearr_37873[(4)] = cljs.core.cons.call(null,(5),(state_37870[(4)])));

return statearr_37873;
})();
var inst_37847 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_37870__$1 = state_37870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37870__$1,(6),inst_37847);
} else {
if((state_val_37871 === (3))){
var inst_37868 = (state_37870[(2)]);
var state_37870__$1 = state_37870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37870__$1,inst_37868);
} else {
if((state_val_37871 === (4))){
var inst_37841 = (state_37870[(2)]);
var state_37870__$1 = state_37870;
var statearr_37875_37891 = state_37870__$1;
(statearr_37875_37891[(2)] = inst_37841);

(statearr_37875_37891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37871 === (5))){
var _ = (function (){var statearr_37876 = state_37870;
(statearr_37876[(4)] = cljs.core.rest.call(null,(state_37870[(4)])));

return statearr_37876;
})();
var state_37870__$1 = state_37870;
var ex37874 = (state_37870__$1[(2)]);
var statearr_37877_37892 = state_37870__$1;
(statearr_37877_37892[(5)] = ex37874);


if((ex37874 instanceof Error)){
var statearr_37878_37893 = state_37870__$1;
(statearr_37878_37893[(1)] = (4));

(statearr_37878_37893[(5)] = null);

} else {
throw ex37874;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37871 === (6))){
var inst_37849 = (state_37870[(2)]);
var inst_37850 = fluree.db.util.async.throw_err.call(null,inst_37849);
var inst_37851 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_37850);
var inst_37852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37853 = [inst_37850];
var inst_37854 = (new cljs.core.PersistentVector(null,1,(5),inst_37852,inst_37853,null));
var inst_37855 = cljs.core.count.call(null,inst_37854);
var inst_37856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37857 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37859 = [inst_37850];
var inst_37860 = (new cljs.core.PersistentVector(null,1,(5),inst_37858,inst_37859,null));
var inst_37861 = ["or",inst_37860,inst_37851];
var inst_37862 = cljs.core.PersistentHashMap.fromArrays(inst_37857,inst_37861);
var inst_37863 = [inst_37862,inst_37855];
var inst_37864 = (new cljs.core.PersistentVector(null,2,(5),inst_37856,inst_37863,null));
var inst_37865 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37864);
var _ = (function (){var statearr_37879 = state_37870;
(statearr_37879[(4)] = cljs.core.rest.call(null,(state_37870[(4)])));

return statearr_37879;
})();
var state_37870__$1 = (function (){var statearr_37880 = state_37870;
(statearr_37880[(7)] = inst_37865);

return statearr_37880;
})();
var statearr_37881_37894 = state_37870__$1;
(statearr_37881_37894[(2)] = inst_37851);

(statearr_37881_37894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_37882 = [null,null,null,null,null,null,null,null];
(statearr_37882[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_37882[(1)] = (1));

return statearr_37882;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_37870){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37883){var ex__2724__auto__ = e37883;
var statearr_37884_37895 = state_37870;
(statearr_37884_37895[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37870[(4)]))){
var statearr_37885_37896 = state_37870;
(statearr_37885_37896[(1)] = cljs.core.first.call(null,(state_37870[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37897 = state_37870;
state_37870 = G__37897;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_37870){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_37870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37886 = f__2744__auto__.call(null);
(statearr_37886[(6)] = c__2743__auto__);

return statearr_37886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq37839){
var G__37840 = cljs.core.first.call(null,seq37839);
var seq37839__$1 = cljs.core.next.call(null,seq37839);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37840,seq37839__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_37935){
var state_val_37936 = (state_37935[(1)]);
if((state_val_37936 === (7))){
var inst_37911 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_37935__$1 = state_37935;
if(inst_37911){
var statearr_37937_37960 = state_37935__$1;
(statearr_37937_37960[(1)] = (10));

} else {
var statearr_37938_37961 = state_37935__$1;
(statearr_37938_37961[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37936 === (1))){
var state_37935__$1 = state_37935;
var statearr_37939_37962 = state_37935__$1;
(statearr_37939_37962[(2)] = null);

(statearr_37939_37962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37936 === (4))){
var inst_37898 = (state_37935[(2)]);
var state_37935__$1 = state_37935;
var statearr_37940_37963 = state_37935__$1;
(statearr_37940_37963[(2)] = inst_37898);

(statearr_37940_37963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37936 === (13))){
var inst_37914 = (state_37935[(2)]);
var inst_37915 = fluree.db.util.async.throw_err.call(null,inst_37914);
var state_37935__$1 = state_37935;
var statearr_37941_37964 = state_37935__$1;
(statearr_37941_37964[(2)] = inst_37915);

(statearr_37941_37964[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37936 === (6))){
var inst_37906 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_37935__$1 = state_37935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37935__$1,(9),inst_37906);
} else {
if((state_val_37936 === (3))){
var inst_37933 = (state_37935[(2)]);
var state_37935__$1 = state_37935;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37935__$1,inst_37933);
} else {
if((state_val_37936 === (12))){
var inst_37918 = (state_37935[(2)]);
var state_37935__$1 = state_37935;
var statearr_37942_37965 = state_37935__$1;
(statearr_37942_37965[(2)] = inst_37918);

(statearr_37942_37965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37936 === (2))){
var _ = (function (){var statearr_37943 = state_37935;
(statearr_37943[(4)] = cljs.core.cons.call(null,(5),(state_37935[(4)])));

return statearr_37943;
})();
var inst_37904 = cljs.core.vector_QMARK_.call(null,coll);
var state_37935__$1 = state_37935;
if(inst_37904){
var statearr_37944_37966 = state_37935__$1;
(statearr_37944_37966[(1)] = (6));

} else {
var statearr_37945_37967 = state_37935__$1;
(statearr_37945_37967[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37936 === (11))){
var state_37935__$1 = state_37935;
var statearr_37947_37968 = state_37935__$1;
(statearr_37947_37968[(2)] = coll);

(statearr_37947_37968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37936 === (9))){
var inst_37908 = (state_37935[(2)]);
var inst_37909 = fluree.db.util.async.throw_err.call(null,inst_37908);
var state_37935__$1 = state_37935;
var statearr_37948_37969 = state_37935__$1;
(statearr_37948_37969[(2)] = inst_37909);

(statearr_37948_37969[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37936 === (5))){
var _ = (function (){var statearr_37949 = state_37935;
(statearr_37949[(4)] = cljs.core.rest.call(null,(state_37935[(4)])));

return statearr_37949;
})();
var state_37935__$1 = state_37935;
var ex37946 = (state_37935__$1[(2)]);
var statearr_37950_37970 = state_37935__$1;
(statearr_37950_37970[(5)] = ex37946);


if((ex37946 instanceof Error)){
var statearr_37951_37971 = state_37935__$1;
(statearr_37951_37971[(1)] = (4));

(statearr_37951_37971[(5)] = null);

} else {
throw ex37946;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37936 === (10))){
var state_37935__$1 = state_37935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37935__$1,(13),coll);
} else {
if((state_val_37936 === (8))){
var inst_37920 = (state_37935[(2)]);
var inst_37921 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_37920);
var inst_37922 = cljs.core.count.call(null,inst_37921);
var inst_37923 = ((9) + inst_37922);
var inst_37924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37925 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_37926 = ["count",inst_37920,inst_37922];
var inst_37927 = cljs.core.PersistentHashMap.fromArrays(inst_37925,inst_37926);
var inst_37928 = [inst_37927,inst_37923];
var inst_37929 = (new cljs.core.PersistentVector(null,2,(5),inst_37924,inst_37928,null));
var inst_37930 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_37929);
var _ = (function (){var statearr_37952 = state_37935;
(statearr_37952[(4)] = cljs.core.rest.call(null,(state_37935[(4)])));

return statearr_37952;
})();
var state_37935__$1 = (function (){var statearr_37953 = state_37935;
(statearr_37953[(7)] = inst_37930);

return statearr_37953;
})();
var statearr_37954_37972 = state_37935__$1;
(statearr_37954_37972[(2)] = inst_37922);

(statearr_37954_37972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto____0 = (function (){
var statearr_37955 = [null,null,null,null,null,null,null,null];
(statearr_37955[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto__);

(statearr_37955[(1)] = (1));

return statearr_37955;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto____1 = (function (state_37935){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_37935);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e37956){var ex__2724__auto__ = e37956;
var statearr_37957_37973 = state_37935;
(statearr_37957_37973[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_37935[(4)]))){
var statearr_37958_37974 = state_37935;
(statearr_37958_37974[(1)] = cljs.core.first.call(null,(state_37935[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37975 = state_37935;
state_37935 = G__37975;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto__ = function(state_37935){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto____1.call(this,state_37935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_37959 = f__2744__auto__.call(null);
(statearr_37959[(6)] = c__2743__auto__);

return statearr_37959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38025){
var state_val_38026 = (state_38025[(1)]);
if((state_val_38026 === (7))){
var state_38025__$1 = state_38025;
var statearr_38027_38060 = state_38025__$1;
(statearr_38027_38060[(2)] = subject);

(statearr_38027_38060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (1))){
var state_38025__$1 = state_38025;
var statearr_38028_38061 = state_38025__$1;
(statearr_38028_38061[(2)] = null);

(statearr_38028_38061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (4))){
var inst_37976 = (state_38025[(2)]);
var state_38025__$1 = state_38025;
var statearr_38029_38062 = state_38025__$1;
(statearr_38029_38062[(2)] = inst_37976);

(statearr_38029_38062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (15))){
var inst_37989 = (state_38025[(7)]);
var state_38025__$1 = state_38025;
var statearr_38030_38063 = state_38025__$1;
(statearr_38030_38063[(2)] = inst_37989);

(statearr_38030_38063[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (13))){
var inst_37993 = (state_38025[(2)]);
var inst_37994 = fluree.db.util.async.throw_err.call(null,inst_37993);
var state_38025__$1 = state_38025;
var statearr_38031_38064 = state_38025__$1;
(statearr_38031_38064[(2)] = inst_37994);

(statearr_38031_38064[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (6))){
var state_38025__$1 = state_38025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38025__$1,(9),subject);
} else {
if((state_val_38026 === (17))){
var inst_37989 = (state_38025[(7)]);
var inst_38003 = cljs.core.first.call(null,inst_37989);
var state_38025__$1 = state_38025;
var statearr_38032_38065 = state_38025__$1;
(statearr_38032_38065[(2)] = inst_38003);

(statearr_38032_38065[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (3))){
var inst_38023 = (state_38025[(2)]);
var state_38025__$1 = state_38025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38025__$1,inst_38023);
} else {
if((state_val_38026 === (12))){
var inst_37989 = (state_38025[(7)]);
var inst_37997 = (state_38025[(2)]);
var inst_37998 = cljs.core.vector_QMARK_.call(null,inst_37989);
var state_38025__$1 = (function (){var statearr_38033 = state_38025;
(statearr_38033[(8)] = inst_37997);

return statearr_38033;
})();
if(inst_37998){
var statearr_38034_38066 = state_38025__$1;
(statearr_38034_38066[(1)] = (14));

} else {
var statearr_38035_38067 = state_38025__$1;
(statearr_38035_38067[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (2))){
var _ = (function (){var statearr_38036 = state_38025;
(statearr_38036[(4)] = cljs.core.cons.call(null,(5),(state_38025[(4)])));

return statearr_38036;
})();
var inst_37982 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_38025__$1 = state_38025;
if(inst_37982){
var statearr_38037_38068 = state_38025__$1;
(statearr_38037_38068[(1)] = (6));

} else {
var statearr_38038_38069 = state_38025__$1;
(statearr_38038_38069[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (19))){
var inst_38006 = (state_38025[(2)]);
var state_38025__$1 = state_38025;
var statearr_38039_38070 = state_38025__$1;
(statearr_38039_38070[(2)] = inst_38006);

(statearr_38039_38070[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (11))){
var state_38025__$1 = state_38025;
var statearr_38041_38071 = state_38025__$1;
(statearr_38041_38071[(2)] = pred);

(statearr_38041_38071[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (9))){
var inst_37985 = (state_38025[(2)]);
var inst_37986 = fluree.db.util.async.throw_err.call(null,inst_37985);
var state_38025__$1 = state_38025;
var statearr_38042_38072 = state_38025__$1;
(statearr_38042_38072[(2)] = inst_37986);

(statearr_38042_38072[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (5))){
var _ = (function (){var statearr_38043 = state_38025;
(statearr_38043[(4)] = cljs.core.rest.call(null,(state_38025[(4)])));

return statearr_38043;
})();
var state_38025__$1 = state_38025;
var ex38040 = (state_38025__$1[(2)]);
var statearr_38044_38073 = state_38025__$1;
(statearr_38044_38073[(5)] = ex38040);


if((ex38040 instanceof Error)){
var statearr_38045_38074 = state_38025__$1;
(statearr_38045_38074[(1)] = (4));

(statearr_38045_38074[(5)] = null);

} else {
throw ex38040;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (14))){
var inst_37989 = (state_38025[(7)]);
var inst_38000 = cljs.core.count.call(null,inst_37989);
var inst_38001 = cljs.core._EQ_.call(null,(1),inst_38000);
var state_38025__$1 = state_38025;
if(inst_38001){
var statearr_38046_38075 = state_38025__$1;
(statearr_38046_38075[(1)] = (17));

} else {
var statearr_38047_38076 = state_38025__$1;
(statearr_38047_38076[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (16))){
var inst_37997 = (state_38025[(8)]);
var inst_37989 = (state_38025[(7)]);
var inst_38009 = (state_38025[(2)]);
var inst_38010 = fluree.db.dbfunctions.internal.get.call(null,inst_38009,inst_37997);
var inst_38011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38012 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38014 = [inst_37989,inst_37997];
var inst_38015 = (new cljs.core.PersistentVector(null,2,(5),inst_38013,inst_38014,null));
var inst_38016 = ["get",inst_38015,inst_38010];
var inst_38017 = cljs.core.PersistentHashMap.fromArrays(inst_38012,inst_38016);
var inst_38018 = [inst_38017,(10)];
var inst_38019 = (new cljs.core.PersistentVector(null,2,(5),inst_38011,inst_38018,null));
var inst_38020 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38019);
var _ = (function (){var statearr_38048 = state_38025;
(statearr_38048[(4)] = cljs.core.rest.call(null,(state_38025[(4)])));

return statearr_38048;
})();
var state_38025__$1 = (function (){var statearr_38049 = state_38025;
(statearr_38049[(9)] = inst_38020);

return statearr_38049;
})();
var statearr_38050_38077 = state_38025__$1;
(statearr_38050_38077[(2)] = inst_38010);

(statearr_38050_38077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (10))){
var state_38025__$1 = state_38025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38025__$1,(13),pred);
} else {
if((state_val_38026 === (18))){
var inst_37989 = (state_38025[(7)]);
var state_38025__$1 = state_38025;
var statearr_38051_38078 = state_38025__$1;
(statearr_38051_38078[(2)] = inst_37989);

(statearr_38051_38078[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38026 === (8))){
var inst_37989 = (state_38025[(2)]);
var inst_37990 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_38025__$1 = (function (){var statearr_38052 = state_38025;
(statearr_38052[(7)] = inst_37989);

return statearr_38052;
})();
if(inst_37990){
var statearr_38053_38079 = state_38025__$1;
(statearr_38053_38079[(1)] = (10));

} else {
var statearr_38054_38080 = state_38025__$1;
(statearr_38054_38080[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto____0 = (function (){
var statearr_38055 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38055[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto__);

(statearr_38055[(1)] = (1));

return statearr_38055;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto____1 = (function (state_38025){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38056){var ex__2724__auto__ = e38056;
var statearr_38057_38081 = state_38025;
(statearr_38057_38081[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38025[(4)]))){
var statearr_38058_38082 = state_38025;
(statearr_38058_38082[(1)] = cljs.core.first.call(null,(state_38025[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38083 = state_38025;
state_38025 = G__38083;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto__ = function(state_38025){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto____1.call(this,state_38025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38059 = f__2744__auto__.call(null);
(statearr_38059[(6)] = c__2743__auto__);

return statearr_38059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38122){
var state_val_38123 = (state_38122[(1)]);
if((state_val_38123 === (7))){
var inst_38090 = (state_38122[(7)]);
var state_38122__$1 = state_38122;
var statearr_38124_38148 = state_38122__$1;
(statearr_38124_38148[(2)] = inst_38090);

(statearr_38124_38148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38123 === (1))){
var state_38122__$1 = state_38122;
var statearr_38125_38149 = state_38122__$1;
(statearr_38125_38149[(2)] = null);

(statearr_38125_38149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38123 === (4))){
var inst_38084 = (state_38122[(2)]);
var state_38122__$1 = state_38122;
var statearr_38126_38150 = state_38122__$1;
(statearr_38126_38150[(2)] = inst_38084);

(statearr_38126_38150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38123 === (6))){
var inst_38092 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38122__$1 = state_38122;
var statearr_38127_38151 = state_38122__$1;
(statearr_38127_38151[(2)] = inst_38092);

(statearr_38127_38151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38123 === (3))){
var inst_38120 = (state_38122[(2)]);
var state_38122__$1 = state_38122;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38122__$1,inst_38120);
} else {
if((state_val_38123 === (12))){
var inst_38102 = (state_38122[(2)]);
var inst_38103 = fluree.db.util.async.throw_err.call(null,inst_38102);
var inst_38104 = cljs.core.nth.call(null,inst_38103,(0),null);
var inst_38105 = cljs.core.nth.call(null,inst_38103,(1),null);
var inst_38106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38107 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38108 = ["?pO","?ctx",inst_38104];
var inst_38109 = cljs.core.PersistentHashMap.fromArrays(inst_38107,inst_38108);
var inst_38110 = ((10) + inst_38105);
var inst_38111 = [inst_38109,inst_38110];
var inst_38112 = (new cljs.core.PersistentVector(null,2,(5),inst_38106,inst_38111,null));
var inst_38113 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38112);
var state_38122__$1 = (function (){var statearr_38128 = state_38122;
(statearr_38128[(8)] = inst_38113);

return statearr_38128;
})();
var statearr_38129_38152 = state_38122__$1;
(statearr_38129_38152[(2)] = inst_38104);

(statearr_38129_38152[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38123 === (2))){
var inst_38090 = (state_38122[(7)]);
var _ = (function (){var statearr_38130 = state_38122;
(statearr_38130[(4)] = cljs.core.cons.call(null,(5),(state_38122[(4)])));

return statearr_38130;
})();
var inst_38090__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38122__$1 = (function (){var statearr_38131 = state_38122;
(statearr_38131[(7)] = inst_38090__$1);

return statearr_38131;
})();
if(cljs.core.truth_(inst_38090__$1)){
var statearr_38132_38153 = state_38122__$1;
(statearr_38132_38153[(1)] = (6));

} else {
var statearr_38133_38154 = state_38122__$1;
(statearr_38133_38154[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38123 === (11))){
var inst_38117 = (state_38122[(2)]);
var _ = (function (){var statearr_38135 = state_38122;
(statearr_38135[(4)] = cljs.core.rest.call(null,(state_38122[(4)])));

return statearr_38135;
})();
var state_38122__$1 = state_38122;
var statearr_38136_38155 = state_38122__$1;
(statearr_38136_38155[(2)] = inst_38117);

(statearr_38136_38155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38123 === (9))){
var inst_38100 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_38122__$1 = state_38122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38122__$1,(12),inst_38100);
} else {
if((state_val_38123 === (5))){
var _ = (function (){var statearr_38137 = state_38122;
(statearr_38137[(4)] = cljs.core.rest.call(null,(state_38122[(4)])));

return statearr_38137;
})();
var state_38122__$1 = state_38122;
var ex38134 = (state_38122__$1[(2)]);
var statearr_38138_38156 = state_38122__$1;
(statearr_38138_38156[(5)] = ex38134);


if((ex38134 instanceof Error)){
var statearr_38139_38157 = state_38122__$1;
(statearr_38139_38157[(1)] = (4));

(statearr_38139_38157[(5)] = null);

} else {
throw ex38134;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38123 === (10))){
var inst_38115 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_38122__$1 = state_38122;
var statearr_38140_38158 = state_38122__$1;
(statearr_38140_38158[(2)] = inst_38115);

(statearr_38140_38158[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38123 === (8))){
var inst_38095 = (state_38122[(2)]);
var state_38122__$1 = state_38122;
if(cljs.core.truth_(inst_38095)){
var statearr_38141_38159 = state_38122__$1;
(statearr_38141_38159[(1)] = (9));

} else {
var statearr_38142_38160 = state_38122__$1;
(statearr_38142_38160[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto____0 = (function (){
var statearr_38143 = [null,null,null,null,null,null,null,null,null];
(statearr_38143[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto__);

(statearr_38143[(1)] = (1));

return statearr_38143;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto____1 = (function (state_38122){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38144){var ex__2724__auto__ = e38144;
var statearr_38145_38161 = state_38122;
(statearr_38145_38161[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38122[(4)]))){
var statearr_38146_38162 = state_38122;
(statearr_38146_38162[(1)] = cljs.core.first.call(null,(state_38122[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38163 = state_38122;
state_38122 = G__38163;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto__ = function(state_38122){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto____1.call(this,state_38122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38147 = f__2744__auto__.call(null);
(statearr_38147[(6)] = c__2743__auto__);

return statearr_38147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38215){
var state_val_38216 = (state_38215[(1)]);
if((state_val_38216 === (7))){
var state_38215__$1 = state_38215;
var statearr_38217_38250 = state_38215__$1;
(statearr_38217_38250[(2)] = subject);

(statearr_38217_38250[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (1))){
var state_38215__$1 = state_38215;
var statearr_38218_38251 = state_38215__$1;
(statearr_38218_38251[(2)] = null);

(statearr_38218_38251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (4))){
var inst_38164 = (state_38215[(2)]);
var state_38215__$1 = state_38215;
var statearr_38219_38252 = state_38215__$1;
(statearr_38219_38252[(2)] = inst_38164);

(statearr_38219_38252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (15))){
var inst_38177 = (state_38215[(7)]);
var state_38215__$1 = state_38215;
var statearr_38220_38253 = state_38215__$1;
(statearr_38220_38253[(2)] = inst_38177);

(statearr_38220_38253[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (13))){
var inst_38181 = (state_38215[(2)]);
var inst_38182 = fluree.db.util.async.throw_err.call(null,inst_38181);
var state_38215__$1 = state_38215;
var statearr_38221_38254 = state_38215__$1;
(statearr_38221_38254[(2)] = inst_38182);

(statearr_38221_38254[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (6))){
var state_38215__$1 = state_38215;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38215__$1,(9),subject);
} else {
if((state_val_38216 === (17))){
var inst_38177 = (state_38215[(7)]);
var inst_38191 = cljs.core.first.call(null,inst_38177);
var state_38215__$1 = state_38215;
var statearr_38222_38255 = state_38215__$1;
(statearr_38222_38255[(2)] = inst_38191);

(statearr_38222_38255[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (3))){
var inst_38213 = (state_38215[(2)]);
var state_38215__$1 = state_38215;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38215__$1,inst_38213);
} else {
if((state_val_38216 === (12))){
var inst_38177 = (state_38215[(7)]);
var inst_38185 = (state_38215[(2)]);
var inst_38186 = cljs.core.vector_QMARK_.call(null,inst_38177);
var state_38215__$1 = (function (){var statearr_38223 = state_38215;
(statearr_38223[(8)] = inst_38185);

return statearr_38223;
})();
if(inst_38186){
var statearr_38224_38256 = state_38215__$1;
(statearr_38224_38256[(1)] = (14));

} else {
var statearr_38225_38257 = state_38215__$1;
(statearr_38225_38257[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (2))){
var _ = (function (){var statearr_38226 = state_38215;
(statearr_38226[(4)] = cljs.core.cons.call(null,(5),(state_38215[(4)])));

return statearr_38226;
})();
var inst_38170 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_38215__$1 = state_38215;
if(inst_38170){
var statearr_38227_38258 = state_38215__$1;
(statearr_38227_38258[(1)] = (6));

} else {
var statearr_38228_38259 = state_38215__$1;
(statearr_38228_38259[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (19))){
var inst_38194 = (state_38215[(2)]);
var state_38215__$1 = state_38215;
var statearr_38229_38260 = state_38215__$1;
(statearr_38229_38260[(2)] = inst_38194);

(statearr_38229_38260[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (11))){
var state_38215__$1 = state_38215;
var statearr_38231_38261 = state_38215__$1;
(statearr_38231_38261[(2)] = path);

(statearr_38231_38261[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (9))){
var inst_38173 = (state_38215[(2)]);
var inst_38174 = fluree.db.util.async.throw_err.call(null,inst_38173);
var state_38215__$1 = state_38215;
var statearr_38232_38262 = state_38215__$1;
(statearr_38232_38262[(2)] = inst_38174);

(statearr_38232_38262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (5))){
var _ = (function (){var statearr_38233 = state_38215;
(statearr_38233[(4)] = cljs.core.rest.call(null,(state_38215[(4)])));

return statearr_38233;
})();
var state_38215__$1 = state_38215;
var ex38230 = (state_38215__$1[(2)]);
var statearr_38234_38263 = state_38215__$1;
(statearr_38234_38263[(5)] = ex38230);


if((ex38230 instanceof Error)){
var statearr_38235_38264 = state_38215__$1;
(statearr_38235_38264[(1)] = (4));

(statearr_38235_38264[(5)] = null);

} else {
throw ex38230;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (14))){
var inst_38177 = (state_38215[(7)]);
var inst_38188 = cljs.core.count.call(null,inst_38177);
var inst_38189 = cljs.core._EQ_.call(null,(1),inst_38188);
var state_38215__$1 = state_38215;
if(inst_38189){
var statearr_38236_38265 = state_38215__$1;
(statearr_38236_38265[(1)] = (17));

} else {
var statearr_38237_38266 = state_38215__$1;
(statearr_38237_38266[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (16))){
var inst_38185 = (state_38215[(8)]);
var inst_38177 = (state_38215[(7)]);
var inst_38197 = (state_38215[(2)]);
var inst_38198 = fluree.db.dbfunctions.internal.get_all.call(null,inst_38197,inst_38185);
var inst_38199 = cljs.core.count.call(null,inst_38185);
var inst_38200 = ((9) + inst_38199);
var inst_38201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38202 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38204 = [inst_38177,inst_38185];
var inst_38205 = (new cljs.core.PersistentVector(null,2,(5),inst_38203,inst_38204,null));
var inst_38206 = ["get-all",inst_38205,inst_38198];
var inst_38207 = cljs.core.PersistentHashMap.fromArrays(inst_38202,inst_38206);
var inst_38208 = [inst_38207,inst_38200];
var inst_38209 = (new cljs.core.PersistentVector(null,2,(5),inst_38201,inst_38208,null));
var inst_38210 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38209);
var _ = (function (){var statearr_38238 = state_38215;
(statearr_38238[(4)] = cljs.core.rest.call(null,(state_38215[(4)])));

return statearr_38238;
})();
var state_38215__$1 = (function (){var statearr_38239 = state_38215;
(statearr_38239[(9)] = inst_38210);

return statearr_38239;
})();
var statearr_38240_38267 = state_38215__$1;
(statearr_38240_38267[(2)] = inst_38198);

(statearr_38240_38267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (10))){
var state_38215__$1 = state_38215;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38215__$1,(13),path);
} else {
if((state_val_38216 === (18))){
var inst_38177 = (state_38215[(7)]);
var state_38215__$1 = state_38215;
var statearr_38241_38268 = state_38215__$1;
(statearr_38241_38268[(2)] = inst_38177);

(statearr_38241_38268[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38216 === (8))){
var inst_38177 = (state_38215[(2)]);
var inst_38178 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_38215__$1 = (function (){var statearr_38242 = state_38215;
(statearr_38242[(7)] = inst_38177);

return statearr_38242;
})();
if(inst_38178){
var statearr_38243_38269 = state_38215__$1;
(statearr_38243_38269[(1)] = (10));

} else {
var statearr_38244_38270 = state_38215__$1;
(statearr_38244_38270[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto____0 = (function (){
var statearr_38245 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38245[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto__);

(statearr_38245[(1)] = (1));

return statearr_38245;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto____1 = (function (state_38215){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38215);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38246){var ex__2724__auto__ = e38246;
var statearr_38247_38271 = state_38215;
(statearr_38247_38271[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38215[(4)]))){
var statearr_38248_38272 = state_38215;
(statearr_38248_38272[(1)] = cljs.core.first.call(null,(state_38215[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38273 = state_38215;
state_38215 = G__38273;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto__ = function(state_38215){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto____1.call(this,state_38215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38249 = f__2744__auto__.call(null);
(statearr_38249[(6)] = c__2743__auto__);

return statearr_38249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38312){
var state_val_38313 = (state_38312[(1)]);
if((state_val_38313 === (7))){
var state_38312__$1 = state_38312;
var statearr_38314_38338 = state_38312__$1;
(statearr_38314_38338[(2)] = subject);

(statearr_38314_38338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38313 === (1))){
var state_38312__$1 = state_38312;
var statearr_38315_38339 = state_38312__$1;
(statearr_38315_38339[(2)] = null);

(statearr_38315_38339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38313 === (4))){
var inst_38274 = (state_38312[(2)]);
var state_38312__$1 = state_38312;
var statearr_38316_38340 = state_38312__$1;
(statearr_38316_38340[(2)] = inst_38274);

(statearr_38316_38340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38313 === (13))){
var inst_38291 = (state_38312[(2)]);
var inst_38292 = fluree.db.util.async.throw_err.call(null,inst_38291);
var state_38312__$1 = state_38312;
var statearr_38317_38341 = state_38312__$1;
(statearr_38317_38341[(2)] = inst_38292);

(statearr_38317_38341[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38313 === (6))){
var state_38312__$1 = state_38312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38312__$1,(9),subject);
} else {
if((state_val_38313 === (3))){
var inst_38310 = (state_38312[(2)]);
var state_38312__$1 = state_38312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38312__$1,inst_38310);
} else {
if((state_val_38313 === (12))){
var inst_38287 = (state_38312[(7)]);
var inst_38295 = (state_38312[(2)]);
var inst_38296 = fluree.db.dbfunctions.internal.get_in.call(null,inst_38287,inst_38295);
var inst_38297 = cljs.core.count.call(null,inst_38295);
var inst_38298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38299 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38301 = [inst_38287,inst_38295];
var inst_38302 = (new cljs.core.PersistentVector(null,2,(5),inst_38300,inst_38301,null));
var inst_38303 = ["get-in",inst_38302,inst_38296];
var inst_38304 = cljs.core.PersistentHashMap.fromArrays(inst_38299,inst_38303);
var inst_38305 = [inst_38304,inst_38297];
var inst_38306 = (new cljs.core.PersistentVector(null,2,(5),inst_38298,inst_38305,null));
var inst_38307 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38306);
var _ = (function (){var statearr_38318 = state_38312;
(statearr_38318[(4)] = cljs.core.rest.call(null,(state_38312[(4)])));

return statearr_38318;
})();
var state_38312__$1 = (function (){var statearr_38319 = state_38312;
(statearr_38319[(8)] = inst_38307);

return statearr_38319;
})();
var statearr_38320_38342 = state_38312__$1;
(statearr_38320_38342[(2)] = inst_38296);

(statearr_38320_38342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38313 === (2))){
var _ = (function (){var statearr_38321 = state_38312;
(statearr_38321[(4)] = cljs.core.cons.call(null,(5),(state_38312[(4)])));

return statearr_38321;
})();
var inst_38280 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_38312__$1 = state_38312;
if(inst_38280){
var statearr_38322_38343 = state_38312__$1;
(statearr_38322_38343[(1)] = (6));

} else {
var statearr_38323_38344 = state_38312__$1;
(statearr_38323_38344[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38313 === (11))){
var state_38312__$1 = state_38312;
var statearr_38325_38345 = state_38312__$1;
(statearr_38325_38345[(2)] = path);

(statearr_38325_38345[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38313 === (9))){
var inst_38283 = (state_38312[(2)]);
var inst_38284 = fluree.db.util.async.throw_err.call(null,inst_38283);
var state_38312__$1 = state_38312;
var statearr_38326_38346 = state_38312__$1;
(statearr_38326_38346[(2)] = inst_38284);

(statearr_38326_38346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38313 === (5))){
var _ = (function (){var statearr_38327 = state_38312;
(statearr_38327[(4)] = cljs.core.rest.call(null,(state_38312[(4)])));

return statearr_38327;
})();
var state_38312__$1 = state_38312;
var ex38324 = (state_38312__$1[(2)]);
var statearr_38328_38347 = state_38312__$1;
(statearr_38328_38347[(5)] = ex38324);


if((ex38324 instanceof Error)){
var statearr_38329_38348 = state_38312__$1;
(statearr_38329_38348[(1)] = (4));

(statearr_38329_38348[(5)] = null);

} else {
throw ex38324;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38313 === (10))){
var state_38312__$1 = state_38312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38312__$1,(13),path);
} else {
if((state_val_38313 === (8))){
var inst_38287 = (state_38312[(2)]);
var inst_38288 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_38312__$1 = (function (){var statearr_38330 = state_38312;
(statearr_38330[(7)] = inst_38287);

return statearr_38330;
})();
if(inst_38288){
var statearr_38331_38349 = state_38312__$1;
(statearr_38331_38349[(1)] = (10));

} else {
var statearr_38332_38350 = state_38312__$1;
(statearr_38332_38350[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto____0 = (function (){
var statearr_38333 = [null,null,null,null,null,null,null,null,null];
(statearr_38333[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto__);

(statearr_38333[(1)] = (1));

return statearr_38333;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto____1 = (function (state_38312){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38334){var ex__2724__auto__ = e38334;
var statearr_38335_38351 = state_38312;
(statearr_38335_38351[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38312[(4)]))){
var statearr_38336_38352 = state_38312;
(statearr_38336_38352[(1)] = cljs.core.first.call(null,(state_38312[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38353 = state_38312;
state_38312 = G__38353;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto__ = function(state_38312){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto____1.call(this,state_38312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38337 = f__2744__auto__.call(null);
(statearr_38337[(6)] = c__2743__auto__);

return statearr_38337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38398){
var state_val_38399 = (state_38398[(1)]);
if((state_val_38399 === (7))){
var state_38398__$1 = state_38398;
var statearr_38400_38429 = state_38398__$1;
(statearr_38400_38429[(2)] = coll);

(statearr_38400_38429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (1))){
var state_38398__$1 = state_38398;
var statearr_38401_38430 = state_38398__$1;
(statearr_38401_38430[(2)] = null);

(statearr_38401_38430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (4))){
var inst_38354 = (state_38398[(2)]);
var state_38398__$1 = state_38398;
var statearr_38402_38431 = state_38398__$1;
(statearr_38402_38431[(2)] = inst_38354);

(statearr_38402_38431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (15))){
var inst_38374 = (state_38398[(7)]);
var inst_38382 = (state_38398[(2)]);
var inst_38383 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_38374,inst_38382);
var inst_38384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38385 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38387 = [inst_38374,inst_38382];
var inst_38388 = (new cljs.core.PersistentVector(null,2,(5),inst_38386,inst_38387,null));
var inst_38389 = ["contains?",inst_38388,inst_38383];
var inst_38390 = cljs.core.PersistentHashMap.fromArrays(inst_38385,inst_38389);
var inst_38391 = [inst_38390,(10)];
var inst_38392 = (new cljs.core.PersistentVector(null,2,(5),inst_38384,inst_38391,null));
var inst_38393 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38392);
var _ = (function (){var statearr_38403 = state_38398;
(statearr_38403[(4)] = cljs.core.rest.call(null,(state_38398[(4)])));

return statearr_38403;
})();
var state_38398__$1 = (function (){var statearr_38404 = state_38398;
(statearr_38404[(8)] = inst_38393);

return statearr_38404;
})();
var statearr_38405_38432 = state_38398__$1;
(statearr_38405_38432[(2)] = inst_38383);

(statearr_38405_38432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (13))){
var state_38398__$1 = state_38398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38398__$1,(16),key);
} else {
if((state_val_38399 === (6))){
var state_38398__$1 = state_38398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38398__$1,(9),coll);
} else {
if((state_val_38399 === (3))){
var inst_38396 = (state_38398[(2)]);
var state_38398__$1 = state_38398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38398__$1,inst_38396);
} else {
if((state_val_38399 === (12))){
var inst_38374 = (state_38398[(2)]);
var inst_38375 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_38398__$1 = (function (){var statearr_38406 = state_38398;
(statearr_38406[(7)] = inst_38374);

return statearr_38406;
})();
if(inst_38375){
var statearr_38407_38433 = state_38398__$1;
(statearr_38407_38433[(1)] = (13));

} else {
var statearr_38408_38434 = state_38398__$1;
(statearr_38408_38434[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (2))){
var _ = (function (){var statearr_38409 = state_38398;
(statearr_38409[(4)] = cljs.core.cons.call(null,(5),(state_38398[(4)])));

return statearr_38409;
})();
var inst_38360 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_38398__$1 = state_38398;
if(inst_38360){
var statearr_38410_38435 = state_38398__$1;
(statearr_38410_38435[(1)] = (6));

} else {
var statearr_38411_38436 = state_38398__$1;
(statearr_38411_38436[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (11))){
var inst_38367 = (state_38398[(9)]);
var inst_38371 = cljs.core.flatten.call(null,inst_38367);
var inst_38372 = cljs.core.set.call(null,inst_38371);
var state_38398__$1 = state_38398;
var statearr_38413_38437 = state_38398__$1;
(statearr_38413_38437[(2)] = inst_38372);

(statearr_38413_38437[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (9))){
var inst_38363 = (state_38398[(2)]);
var inst_38364 = fluree.db.util.async.throw_err.call(null,inst_38363);
var state_38398__$1 = state_38398;
var statearr_38414_38438 = state_38398__$1;
(statearr_38414_38438[(2)] = inst_38364);

(statearr_38414_38438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (5))){
var _ = (function (){var statearr_38415 = state_38398;
(statearr_38415[(4)] = cljs.core.rest.call(null,(state_38398[(4)])));

return statearr_38415;
})();
var state_38398__$1 = state_38398;
var ex38412 = (state_38398__$1[(2)]);
var statearr_38416_38439 = state_38398__$1;
(statearr_38416_38439[(5)] = ex38412);


if((ex38412 instanceof Error)){
var statearr_38417_38440 = state_38398__$1;
(statearr_38417_38440[(1)] = (4));

(statearr_38417_38440[(5)] = null);

} else {
throw ex38412;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (14))){
var state_38398__$1 = state_38398;
var statearr_38418_38441 = state_38398__$1;
(statearr_38418_38441[(2)] = key);

(statearr_38418_38441[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (16))){
var inst_38378 = (state_38398[(2)]);
var inst_38379 = fluree.db.util.async.throw_err.call(null,inst_38378);
var state_38398__$1 = state_38398;
var statearr_38419_38442 = state_38398__$1;
(statearr_38419_38442[(2)] = inst_38379);

(statearr_38419_38442[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (10))){
var inst_38367 = (state_38398[(9)]);
var state_38398__$1 = state_38398;
var statearr_38420_38443 = state_38398__$1;
(statearr_38420_38443[(2)] = inst_38367);

(statearr_38420_38443[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (8))){
var inst_38367 = (state_38398[(9)]);
var inst_38367__$1 = (state_38398[(2)]);
var inst_38368 = cljs.core.set_QMARK_.call(null,inst_38367__$1);
var state_38398__$1 = (function (){var statearr_38421 = state_38398;
(statearr_38421[(9)] = inst_38367__$1);

return statearr_38421;
})();
if(inst_38368){
var statearr_38422_38444 = state_38398__$1;
(statearr_38422_38444[(1)] = (10));

} else {
var statearr_38423_38445 = state_38398__$1;
(statearr_38423_38445[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto____0 = (function (){
var statearr_38424 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38424[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto__);

(statearr_38424[(1)] = (1));

return statearr_38424;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto____1 = (function (state_38398){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38425){var ex__2724__auto__ = e38425;
var statearr_38426_38446 = state_38398;
(statearr_38426_38446[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38398[(4)]))){
var statearr_38427_38447 = state_38398;
(statearr_38427_38447[(1)] = cljs.core.first.call(null,(state_38398[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38448 = state_38398;
state_38398 = G__38448;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto__ = function(state_38398){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto____1.call(this,state_38398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38428 = f__2744__auto__.call(null);
(statearr_38428[(6)] = c__2743__auto__);

return statearr_38428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38520 = arguments.length;
var i__5770__auto___38521 = (0);
while(true){
if((i__5770__auto___38521 < len__5769__auto___38520)){
args__5775__auto__.push((arguments[i__5770__auto___38521]));

var G__38522 = (i__5770__auto___38521 + (1));
i__5770__auto___38521 = G__38522;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38494){
var state_val_38495 = (state_38494[(1)]);
if((state_val_38495 === (7))){
var inst_38460 = (state_38494[(7)]);
var inst_38464 = cljs.core.first.call(null,inst_38460);
var inst_38465 = cljs.core.coll_QMARK_.call(null,inst_38464);
var state_38494__$1 = state_38494;
var statearr_38496_38523 = state_38494__$1;
(statearr_38496_38523[(2)] = inst_38465);

(statearr_38496_38523[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38495 === (1))){
var state_38494__$1 = state_38494;
var statearr_38497_38524 = state_38494__$1;
(statearr_38497_38524[(2)] = null);

(statearr_38497_38524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38495 === (4))){
var inst_38451 = (state_38494[(2)]);
var state_38494__$1 = state_38494;
var statearr_38498_38525 = state_38494__$1;
(statearr_38498_38525[(2)] = inst_38451);

(statearr_38498_38525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38495 === (6))){
var inst_38460 = (state_38494[(7)]);
var inst_38462 = (state_38494[(8)]);
var inst_38459 = (state_38494[(2)]);
var inst_38460__$1 = fluree.db.util.async.throw_err.call(null,inst_38459);
var inst_38461 = cljs.core.count.call(null,inst_38460__$1);
var inst_38462__$1 = cljs.core._EQ_.call(null,(1),inst_38461);
var state_38494__$1 = (function (){var statearr_38499 = state_38494;
(statearr_38499[(7)] = inst_38460__$1);

(statearr_38499[(8)] = inst_38462__$1);

return statearr_38499;
})();
if(inst_38462__$1){
var statearr_38500_38526 = state_38494__$1;
(statearr_38500_38526[(1)] = (7));

} else {
var statearr_38501_38527 = state_38494__$1;
(statearr_38501_38527[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38495 === (3))){
var inst_38492 = (state_38494[(2)]);
var state_38494__$1 = state_38494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38494__$1,inst_38492);
} else {
if((state_val_38495 === (12))){
var inst_38473 = (state_38494[(2)]);
var inst_38474 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_38473);
var inst_38475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38476 = [inst_38473];
var inst_38477 = (new cljs.core.PersistentVector(null,1,(5),inst_38475,inst_38476,null));
var inst_38478 = cljs.core.count.call(null,inst_38477);
var inst_38479 = ((9) + inst_38478);
var inst_38480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38481 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38483 = [inst_38473];
var inst_38484 = (new cljs.core.PersistentVector(null,1,(5),inst_38482,inst_38483,null));
var inst_38485 = ["hash-set",inst_38484,inst_38474];
var inst_38486 = cljs.core.PersistentHashMap.fromArrays(inst_38481,inst_38485);
var inst_38487 = [inst_38486,inst_38479];
var inst_38488 = (new cljs.core.PersistentVector(null,2,(5),inst_38480,inst_38487,null));
var inst_38489 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38488);
var _ = (function (){var statearr_38502 = state_38494;
(statearr_38502[(4)] = cljs.core.rest.call(null,(state_38494[(4)])));

return statearr_38502;
})();
var state_38494__$1 = (function (){var statearr_38503 = state_38494;
(statearr_38503[(9)] = inst_38489);

return statearr_38503;
})();
var statearr_38504_38528 = state_38494__$1;
(statearr_38504_38528[(2)] = inst_38474);

(statearr_38504_38528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38495 === (2))){
var _ = (function (){var statearr_38505 = state_38494;
(statearr_38505[(4)] = cljs.core.cons.call(null,(5),(state_38494[(4)])));

return statearr_38505;
})();
var inst_38457 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_38494__$1 = state_38494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38494__$1,(6),inst_38457);
} else {
if((state_val_38495 === (11))){
var inst_38460 = (state_38494[(7)]);
var state_38494__$1 = state_38494;
var statearr_38507_38529 = state_38494__$1;
(statearr_38507_38529[(2)] = inst_38460);

(statearr_38507_38529[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38495 === (9))){
var inst_38468 = (state_38494[(2)]);
var state_38494__$1 = state_38494;
if(cljs.core.truth_(inst_38468)){
var statearr_38508_38530 = state_38494__$1;
(statearr_38508_38530[(1)] = (10));

} else {
var statearr_38509_38531 = state_38494__$1;
(statearr_38509_38531[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38495 === (5))){
var _ = (function (){var statearr_38510 = state_38494;
(statearr_38510[(4)] = cljs.core.rest.call(null,(state_38494[(4)])));

return statearr_38510;
})();
var state_38494__$1 = state_38494;
var ex38506 = (state_38494__$1[(2)]);
var statearr_38511_38532 = state_38494__$1;
(statearr_38511_38532[(5)] = ex38506);


if((ex38506 instanceof Error)){
var statearr_38512_38533 = state_38494__$1;
(statearr_38512_38533[(1)] = (4));

(statearr_38512_38533[(5)] = null);

} else {
throw ex38506;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38495 === (10))){
var inst_38460 = (state_38494[(7)]);
var inst_38470 = cljs.core.first.call(null,inst_38460);
var state_38494__$1 = state_38494;
var statearr_38513_38534 = state_38494__$1;
(statearr_38513_38534[(2)] = inst_38470);

(statearr_38513_38534[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38495 === (8))){
var inst_38462 = (state_38494[(8)]);
var state_38494__$1 = state_38494;
var statearr_38514_38535 = state_38494__$1;
(statearr_38514_38535[(2)] = inst_38462);

(statearr_38514_38535[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_38515 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38515[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_38515[(1)] = (1));

return statearr_38515;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_38494){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38516){var ex__2724__auto__ = e38516;
var statearr_38517_38536 = state_38494;
(statearr_38517_38536[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38494[(4)]))){
var statearr_38518_38537 = state_38494;
(statearr_38518_38537[(1)] = cljs.core.first.call(null,(state_38494[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38538 = state_38494;
state_38494 = G__38538;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_38494){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_38494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38519 = f__2744__auto__.call(null);
(statearr_38519[(6)] = c__2743__auto__);

return statearr_38519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq38449){
var G__38450 = cljs.core.first.call(null,seq38449);
var seq38449__$1 = cljs.core.next.call(null,seq38449);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38450,seq38449__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38588 = arguments.length;
var i__5770__auto___38589 = (0);
while(true){
if((i__5770__auto___38589 < len__5769__auto___38588)){
args__5775__auto__.push((arguments[i__5770__auto___38589]));

var G__38590 = (i__5770__auto___38589 + (1));
i__5770__auto___38589 = G__38590;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38571){
var state_val_38572 = (state_38571[(1)]);
if((state_val_38572 === (1))){
var state_38571__$1 = state_38571;
var statearr_38573_38591 = state_38571__$1;
(statearr_38573_38591[(2)] = null);

(statearr_38573_38591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38572 === (2))){
var _ = (function (){var statearr_38574 = state_38571;
(statearr_38574[(4)] = cljs.core.cons.call(null,(5),(state_38571[(4)])));

return statearr_38574;
})();
var inst_38547 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_38571__$1 = state_38571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38571__$1,(6),inst_38547);
} else {
if((state_val_38572 === (3))){
var inst_38569 = (state_38571[(2)]);
var state_38571__$1 = state_38571;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38571__$1,inst_38569);
} else {
if((state_val_38572 === (4))){
var inst_38541 = (state_38571[(2)]);
var state_38571__$1 = state_38571;
var statearr_38576_38592 = state_38571__$1;
(statearr_38576_38592[(2)] = inst_38541);

(statearr_38576_38592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38572 === (5))){
var _ = (function (){var statearr_38577 = state_38571;
(statearr_38577[(4)] = cljs.core.rest.call(null,(state_38571[(4)])));

return statearr_38577;
})();
var state_38571__$1 = state_38571;
var ex38575 = (state_38571__$1[(2)]);
var statearr_38578_38593 = state_38571__$1;
(statearr_38578_38593[(5)] = ex38575);


if((ex38575 instanceof Error)){
var statearr_38579_38594 = state_38571__$1;
(statearr_38579_38594[(1)] = (4));

(statearr_38579_38594[(5)] = null);

} else {
throw ex38575;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38572 === (6))){
var inst_38549 = (state_38571[(2)]);
var inst_38550 = fluree.db.util.async.throw_err.call(null,inst_38549);
var inst_38551 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_38550);
var inst_38552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38553 = [inst_38550];
var inst_38554 = (new cljs.core.PersistentVector(null,1,(5),inst_38552,inst_38553,null));
var inst_38555 = cljs.core.count.call(null,inst_38554);
var inst_38556 = ((9) + inst_38555);
var inst_38557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38558 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38560 = [inst_38550];
var inst_38561 = (new cljs.core.PersistentVector(null,1,(5),inst_38559,inst_38560,null));
var inst_38562 = ["==",inst_38561,inst_38551];
var inst_38563 = cljs.core.PersistentHashMap.fromArrays(inst_38558,inst_38562);
var inst_38564 = [inst_38563,inst_38556];
var inst_38565 = (new cljs.core.PersistentVector(null,2,(5),inst_38557,inst_38564,null));
var inst_38566 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38565);
var _ = (function (){var statearr_38580 = state_38571;
(statearr_38580[(4)] = cljs.core.rest.call(null,(state_38571[(4)])));

return statearr_38580;
})();
var state_38571__$1 = (function (){var statearr_38581 = state_38571;
(statearr_38581[(7)] = inst_38566);

return statearr_38581;
})();
var statearr_38582_38595 = state_38571__$1;
(statearr_38582_38595[(2)] = inst_38551);

(statearr_38582_38595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_38583 = [null,null,null,null,null,null,null,null];
(statearr_38583[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_38583[(1)] = (1));

return statearr_38583;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_38571){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38584){var ex__2724__auto__ = e38584;
var statearr_38585_38596 = state_38571;
(statearr_38585_38596[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38571[(4)]))){
var statearr_38586_38597 = state_38571;
(statearr_38586_38597[(1)] = cljs.core.first.call(null,(state_38571[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38598 = state_38571;
state_38571 = G__38598;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_38571){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_38571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38587 = f__2744__auto__.call(null);
(statearr_38587[(6)] = c__2743__auto__);

return statearr_38587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq38539){
var G__38540 = cljs.core.first.call(null,seq38539);
var seq38539__$1 = cljs.core.next.call(null,seq38539);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38540,seq38539__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38648 = arguments.length;
var i__5770__auto___38649 = (0);
while(true){
if((i__5770__auto___38649 < len__5769__auto___38648)){
args__5775__auto__.push((arguments[i__5770__auto___38649]));

var G__38650 = (i__5770__auto___38649 + (1));
i__5770__auto___38649 = G__38650;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38631){
var state_val_38632 = (state_38631[(1)]);
if((state_val_38632 === (1))){
var state_38631__$1 = state_38631;
var statearr_38633_38651 = state_38631__$1;
(statearr_38633_38651[(2)] = null);

(statearr_38633_38651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38632 === (2))){
var _ = (function (){var statearr_38634 = state_38631;
(statearr_38634[(4)] = cljs.core.cons.call(null,(5),(state_38631[(4)])));

return statearr_38634;
})();
var inst_38607 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_38631__$1 = state_38631;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38631__$1,(6),inst_38607);
} else {
if((state_val_38632 === (3))){
var inst_38629 = (state_38631[(2)]);
var state_38631__$1 = state_38631;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38631__$1,inst_38629);
} else {
if((state_val_38632 === (4))){
var inst_38601 = (state_38631[(2)]);
var state_38631__$1 = state_38631;
var statearr_38636_38652 = state_38631__$1;
(statearr_38636_38652[(2)] = inst_38601);

(statearr_38636_38652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38632 === (5))){
var _ = (function (){var statearr_38637 = state_38631;
(statearr_38637[(4)] = cljs.core.rest.call(null,(state_38631[(4)])));

return statearr_38637;
})();
var state_38631__$1 = state_38631;
var ex38635 = (state_38631__$1[(2)]);
var statearr_38638_38653 = state_38631__$1;
(statearr_38638_38653[(5)] = ex38635);


if((ex38635 instanceof Error)){
var statearr_38639_38654 = state_38631__$1;
(statearr_38639_38654[(1)] = (4));

(statearr_38639_38654[(5)] = null);

} else {
throw ex38635;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38632 === (6))){
var inst_38609 = (state_38631[(2)]);
var inst_38610 = fluree.db.util.async.throw_err.call(null,inst_38609);
var inst_38611 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_38610);
var inst_38612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38613 = [inst_38610];
var inst_38614 = (new cljs.core.PersistentVector(null,1,(5),inst_38612,inst_38613,null));
var inst_38615 = cljs.core.count.call(null,inst_38614);
var inst_38616 = ((9) + inst_38615);
var inst_38617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38618 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38620 = [inst_38610];
var inst_38621 = (new cljs.core.PersistentVector(null,1,(5),inst_38619,inst_38620,null));
var inst_38622 = [">",inst_38621,inst_38611];
var inst_38623 = cljs.core.PersistentHashMap.fromArrays(inst_38618,inst_38622);
var inst_38624 = [inst_38623,inst_38616];
var inst_38625 = (new cljs.core.PersistentVector(null,2,(5),inst_38617,inst_38624,null));
var inst_38626 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38625);
var _ = (function (){var statearr_38640 = state_38631;
(statearr_38640[(4)] = cljs.core.rest.call(null,(state_38631[(4)])));

return statearr_38640;
})();
var state_38631__$1 = (function (){var statearr_38641 = state_38631;
(statearr_38641[(7)] = inst_38626);

return statearr_38641;
})();
var statearr_38642_38655 = state_38631__$1;
(statearr_38642_38655[(2)] = inst_38611);

(statearr_38642_38655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_38643 = [null,null,null,null,null,null,null,null];
(statearr_38643[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_38643[(1)] = (1));

return statearr_38643;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_38631){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38631);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38644){var ex__2724__auto__ = e38644;
var statearr_38645_38656 = state_38631;
(statearr_38645_38656[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38631[(4)]))){
var statearr_38646_38657 = state_38631;
(statearr_38646_38657[(1)] = cljs.core.first.call(null,(state_38631[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38658 = state_38631;
state_38631 = G__38658;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_38631){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_38631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38647 = f__2744__auto__.call(null);
(statearr_38647[(6)] = c__2743__auto__);

return statearr_38647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq38599){
var G__38600 = cljs.core.first.call(null,seq38599);
var seq38599__$1 = cljs.core.next.call(null,seq38599);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38600,seq38599__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38708 = arguments.length;
var i__5770__auto___38709 = (0);
while(true){
if((i__5770__auto___38709 < len__5769__auto___38708)){
args__5775__auto__.push((arguments[i__5770__auto___38709]));

var G__38710 = (i__5770__auto___38709 + (1));
i__5770__auto___38709 = G__38710;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38691){
var state_val_38692 = (state_38691[(1)]);
if((state_val_38692 === (1))){
var state_38691__$1 = state_38691;
var statearr_38693_38711 = state_38691__$1;
(statearr_38693_38711[(2)] = null);

(statearr_38693_38711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38692 === (2))){
var _ = (function (){var statearr_38694 = state_38691;
(statearr_38694[(4)] = cljs.core.cons.call(null,(5),(state_38691[(4)])));

return statearr_38694;
})();
var inst_38667 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_38691__$1 = state_38691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38691__$1,(6),inst_38667);
} else {
if((state_val_38692 === (3))){
var inst_38689 = (state_38691[(2)]);
var state_38691__$1 = state_38691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38691__$1,inst_38689);
} else {
if((state_val_38692 === (4))){
var inst_38661 = (state_38691[(2)]);
var state_38691__$1 = state_38691;
var statearr_38696_38712 = state_38691__$1;
(statearr_38696_38712[(2)] = inst_38661);

(statearr_38696_38712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38692 === (5))){
var _ = (function (){var statearr_38697 = state_38691;
(statearr_38697[(4)] = cljs.core.rest.call(null,(state_38691[(4)])));

return statearr_38697;
})();
var state_38691__$1 = state_38691;
var ex38695 = (state_38691__$1[(2)]);
var statearr_38698_38713 = state_38691__$1;
(statearr_38698_38713[(5)] = ex38695);


if((ex38695 instanceof Error)){
var statearr_38699_38714 = state_38691__$1;
(statearr_38699_38714[(1)] = (4));

(statearr_38699_38714[(5)] = null);

} else {
throw ex38695;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38692 === (6))){
var inst_38669 = (state_38691[(2)]);
var inst_38670 = fluree.db.util.async.throw_err.call(null,inst_38669);
var inst_38671 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_38670);
var inst_38672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38673 = [inst_38670];
var inst_38674 = (new cljs.core.PersistentVector(null,1,(5),inst_38672,inst_38673,null));
var inst_38675 = cljs.core.count.call(null,inst_38674);
var inst_38676 = ((9) + inst_38675);
var inst_38677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38678 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38680 = [inst_38670];
var inst_38681 = (new cljs.core.PersistentVector(null,1,(5),inst_38679,inst_38680,null));
var inst_38682 = ["<",inst_38681,inst_38671];
var inst_38683 = cljs.core.PersistentHashMap.fromArrays(inst_38678,inst_38682);
var inst_38684 = [inst_38683,inst_38676];
var inst_38685 = (new cljs.core.PersistentVector(null,2,(5),inst_38677,inst_38684,null));
var inst_38686 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38685);
var _ = (function (){var statearr_38700 = state_38691;
(statearr_38700[(4)] = cljs.core.rest.call(null,(state_38691[(4)])));

return statearr_38700;
})();
var state_38691__$1 = (function (){var statearr_38701 = state_38691;
(statearr_38701[(7)] = inst_38686);

return statearr_38701;
})();
var statearr_38702_38715 = state_38691__$1;
(statearr_38702_38715[(2)] = inst_38671);

(statearr_38702_38715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_38703 = [null,null,null,null,null,null,null,null];
(statearr_38703[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_38703[(1)] = (1));

return statearr_38703;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_38691){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38704){var ex__2724__auto__ = e38704;
var statearr_38705_38716 = state_38691;
(statearr_38705_38716[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38691[(4)]))){
var statearr_38706_38717 = state_38691;
(statearr_38706_38717[(1)] = cljs.core.first.call(null,(state_38691[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38718 = state_38691;
state_38691 = G__38718;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_38691){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_38691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38707 = f__2744__auto__.call(null);
(statearr_38707[(6)] = c__2743__auto__);

return statearr_38707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq38659){
var G__38660 = cljs.core.first.call(null,seq38659);
var seq38659__$1 = cljs.core.next.call(null,seq38659);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38660,seq38659__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38768 = arguments.length;
var i__5770__auto___38769 = (0);
while(true){
if((i__5770__auto___38769 < len__5769__auto___38768)){
args__5775__auto__.push((arguments[i__5770__auto___38769]));

var G__38770 = (i__5770__auto___38769 + (1));
i__5770__auto___38769 = G__38770;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38751){
var state_val_38752 = (state_38751[(1)]);
if((state_val_38752 === (1))){
var state_38751__$1 = state_38751;
var statearr_38753_38771 = state_38751__$1;
(statearr_38753_38771[(2)] = null);

(statearr_38753_38771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38752 === (2))){
var _ = (function (){var statearr_38754 = state_38751;
(statearr_38754[(4)] = cljs.core.cons.call(null,(5),(state_38751[(4)])));

return statearr_38754;
})();
var inst_38727 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_38751__$1 = state_38751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38751__$1,(6),inst_38727);
} else {
if((state_val_38752 === (3))){
var inst_38749 = (state_38751[(2)]);
var state_38751__$1 = state_38751;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38751__$1,inst_38749);
} else {
if((state_val_38752 === (4))){
var inst_38721 = (state_38751[(2)]);
var state_38751__$1 = state_38751;
var statearr_38756_38772 = state_38751__$1;
(statearr_38756_38772[(2)] = inst_38721);

(statearr_38756_38772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38752 === (5))){
var _ = (function (){var statearr_38757 = state_38751;
(statearr_38757[(4)] = cljs.core.rest.call(null,(state_38751[(4)])));

return statearr_38757;
})();
var state_38751__$1 = state_38751;
var ex38755 = (state_38751__$1[(2)]);
var statearr_38758_38773 = state_38751__$1;
(statearr_38758_38773[(5)] = ex38755);


if((ex38755 instanceof Error)){
var statearr_38759_38774 = state_38751__$1;
(statearr_38759_38774[(1)] = (4));

(statearr_38759_38774[(5)] = null);

} else {
throw ex38755;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38752 === (6))){
var inst_38729 = (state_38751[(2)]);
var inst_38730 = fluree.db.util.async.throw_err.call(null,inst_38729);
var inst_38731 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_38730);
var inst_38732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38733 = [inst_38730];
var inst_38734 = (new cljs.core.PersistentVector(null,1,(5),inst_38732,inst_38733,null));
var inst_38735 = cljs.core.count.call(null,inst_38734);
var inst_38736 = ((9) + inst_38735);
var inst_38737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38738 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38740 = [inst_38730];
var inst_38741 = (new cljs.core.PersistentVector(null,1,(5),inst_38739,inst_38740,null));
var inst_38742 = ["<=",inst_38741,inst_38731];
var inst_38743 = cljs.core.PersistentHashMap.fromArrays(inst_38738,inst_38742);
var inst_38744 = [inst_38743,inst_38736];
var inst_38745 = (new cljs.core.PersistentVector(null,2,(5),inst_38737,inst_38744,null));
var inst_38746 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38745);
var _ = (function (){var statearr_38760 = state_38751;
(statearr_38760[(4)] = cljs.core.rest.call(null,(state_38751[(4)])));

return statearr_38760;
})();
var state_38751__$1 = (function (){var statearr_38761 = state_38751;
(statearr_38761[(7)] = inst_38746);

return statearr_38761;
})();
var statearr_38762_38775 = state_38751__$1;
(statearr_38762_38775[(2)] = inst_38731);

(statearr_38762_38775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_38763 = [null,null,null,null,null,null,null,null];
(statearr_38763[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_38763[(1)] = (1));

return statearr_38763;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_38751){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38764){var ex__2724__auto__ = e38764;
var statearr_38765_38776 = state_38751;
(statearr_38765_38776[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38751[(4)]))){
var statearr_38766_38777 = state_38751;
(statearr_38766_38777[(1)] = cljs.core.first.call(null,(state_38751[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38778 = state_38751;
state_38751 = G__38778;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_38751){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_38751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38767 = f__2744__auto__.call(null);
(statearr_38767[(6)] = c__2743__auto__);

return statearr_38767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq38719){
var G__38720 = cljs.core.first.call(null,seq38719);
var seq38719__$1 = cljs.core.next.call(null,seq38719);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38720,seq38719__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38828 = arguments.length;
var i__5770__auto___38829 = (0);
while(true){
if((i__5770__auto___38829 < len__5769__auto___38828)){
args__5775__auto__.push((arguments[i__5770__auto___38829]));

var G__38830 = (i__5770__auto___38829 + (1));
i__5770__auto___38829 = G__38830;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38811){
var state_val_38812 = (state_38811[(1)]);
if((state_val_38812 === (1))){
var state_38811__$1 = state_38811;
var statearr_38813_38831 = state_38811__$1;
(statearr_38813_38831[(2)] = null);

(statearr_38813_38831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38812 === (2))){
var _ = (function (){var statearr_38814 = state_38811;
(statearr_38814[(4)] = cljs.core.cons.call(null,(5),(state_38811[(4)])));

return statearr_38814;
})();
var inst_38787 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_38811__$1 = state_38811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38811__$1,(6),inst_38787);
} else {
if((state_val_38812 === (3))){
var inst_38809 = (state_38811[(2)]);
var state_38811__$1 = state_38811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38811__$1,inst_38809);
} else {
if((state_val_38812 === (4))){
var inst_38781 = (state_38811[(2)]);
var state_38811__$1 = state_38811;
var statearr_38816_38832 = state_38811__$1;
(statearr_38816_38832[(2)] = inst_38781);

(statearr_38816_38832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38812 === (5))){
var _ = (function (){var statearr_38817 = state_38811;
(statearr_38817[(4)] = cljs.core.rest.call(null,(state_38811[(4)])));

return statearr_38817;
})();
var state_38811__$1 = state_38811;
var ex38815 = (state_38811__$1[(2)]);
var statearr_38818_38833 = state_38811__$1;
(statearr_38818_38833[(5)] = ex38815);


if((ex38815 instanceof Error)){
var statearr_38819_38834 = state_38811__$1;
(statearr_38819_38834[(1)] = (4));

(statearr_38819_38834[(5)] = null);

} else {
throw ex38815;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38812 === (6))){
var inst_38789 = (state_38811[(2)]);
var inst_38790 = fluree.db.util.async.throw_err.call(null,inst_38789);
var inst_38791 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_38790);
var inst_38792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38793 = [inst_38790];
var inst_38794 = (new cljs.core.PersistentVector(null,1,(5),inst_38792,inst_38793,null));
var inst_38795 = cljs.core.count.call(null,inst_38794);
var inst_38796 = ((9) + inst_38795);
var inst_38797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38798 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38800 = [inst_38790];
var inst_38801 = (new cljs.core.PersistentVector(null,1,(5),inst_38799,inst_38800,null));
var inst_38802 = [">=",inst_38801,inst_38791];
var inst_38803 = cljs.core.PersistentHashMap.fromArrays(inst_38798,inst_38802);
var inst_38804 = [inst_38803,inst_38796];
var inst_38805 = (new cljs.core.PersistentVector(null,2,(5),inst_38797,inst_38804,null));
var inst_38806 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38805);
var _ = (function (){var statearr_38820 = state_38811;
(statearr_38820[(4)] = cljs.core.rest.call(null,(state_38811[(4)])));

return statearr_38820;
})();
var state_38811__$1 = (function (){var statearr_38821 = state_38811;
(statearr_38821[(7)] = inst_38806);

return statearr_38821;
})();
var statearr_38822_38835 = state_38811__$1;
(statearr_38822_38835[(2)] = inst_38791);

(statearr_38822_38835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_38823 = [null,null,null,null,null,null,null,null];
(statearr_38823[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_38823[(1)] = (1));

return statearr_38823;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_38811){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38824){var ex__2724__auto__ = e38824;
var statearr_38825_38836 = state_38811;
(statearr_38825_38836[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38811[(4)]))){
var statearr_38826_38837 = state_38811;
(statearr_38826_38837[(1)] = cljs.core.first.call(null,(state_38811[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38838 = state_38811;
state_38811 = G__38838;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_38811){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_38811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38827 = f__2744__auto__.call(null);
(statearr_38827[(6)] = c__2743__auto__);

return statearr_38827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq38779){
var G__38780 = cljs.core.first.call(null,seq38779);
var seq38779__$1 = cljs.core.next.call(null,seq38779);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38780,seq38779__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38888 = arguments.length;
var i__5770__auto___38889 = (0);
while(true){
if((i__5770__auto___38889 < len__5769__auto___38888)){
args__5775__auto__.push((arguments[i__5770__auto___38889]));

var G__38890 = (i__5770__auto___38889 + (1));
i__5770__auto___38889 = G__38890;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38871){
var state_val_38872 = (state_38871[(1)]);
if((state_val_38872 === (1))){
var state_38871__$1 = state_38871;
var statearr_38873_38891 = state_38871__$1;
(statearr_38873_38891[(2)] = null);

(statearr_38873_38891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38872 === (2))){
var _ = (function (){var statearr_38874 = state_38871;
(statearr_38874[(4)] = cljs.core.cons.call(null,(5),(state_38871[(4)])));

return statearr_38874;
})();
var inst_38847 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_38871__$1 = state_38871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38871__$1,(6),inst_38847);
} else {
if((state_val_38872 === (3))){
var inst_38869 = (state_38871[(2)]);
var state_38871__$1 = state_38871;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38871__$1,inst_38869);
} else {
if((state_val_38872 === (4))){
var inst_38841 = (state_38871[(2)]);
var state_38871__$1 = state_38871;
var statearr_38876_38892 = state_38871__$1;
(statearr_38876_38892[(2)] = inst_38841);

(statearr_38876_38892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38872 === (5))){
var _ = (function (){var statearr_38877 = state_38871;
(statearr_38877[(4)] = cljs.core.rest.call(null,(state_38871[(4)])));

return statearr_38877;
})();
var state_38871__$1 = state_38871;
var ex38875 = (state_38871__$1[(2)]);
var statearr_38878_38893 = state_38871__$1;
(statearr_38878_38893[(5)] = ex38875);


if((ex38875 instanceof Error)){
var statearr_38879_38894 = state_38871__$1;
(statearr_38879_38894[(1)] = (4));

(statearr_38879_38894[(5)] = null);

} else {
throw ex38875;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38872 === (6))){
var inst_38849 = (state_38871[(2)]);
var inst_38850 = fluree.db.util.async.throw_err.call(null,inst_38849);
var inst_38851 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_38850);
var inst_38852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38853 = [inst_38850];
var inst_38854 = (new cljs.core.PersistentVector(null,1,(5),inst_38852,inst_38853,null));
var inst_38855 = cljs.core.count.call(null,inst_38854);
var inst_38856 = ((9) + inst_38855);
var inst_38857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38858 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38860 = [inst_38850];
var inst_38861 = (new cljs.core.PersistentVector(null,1,(5),inst_38859,inst_38860,null));
var inst_38862 = ["not=",inst_38861,inst_38851];
var inst_38863 = cljs.core.PersistentHashMap.fromArrays(inst_38858,inst_38862);
var inst_38864 = [inst_38863,inst_38856];
var inst_38865 = (new cljs.core.PersistentVector(null,2,(5),inst_38857,inst_38864,null));
var inst_38866 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38865);
var _ = (function (){var statearr_38880 = state_38871;
(statearr_38880[(4)] = cljs.core.rest.call(null,(state_38871[(4)])));

return statearr_38880;
})();
var state_38871__$1 = (function (){var statearr_38881 = state_38871;
(statearr_38881[(7)] = inst_38866);

return statearr_38881;
})();
var statearr_38882_38895 = state_38871__$1;
(statearr_38882_38895[(2)] = inst_38851);

(statearr_38882_38895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_38883 = [null,null,null,null,null,null,null,null];
(statearr_38883[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_38883[(1)] = (1));

return statearr_38883;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_38871){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38884){var ex__2724__auto__ = e38884;
var statearr_38885_38896 = state_38871;
(statearr_38885_38896[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38871[(4)]))){
var statearr_38886_38897 = state_38871;
(statearr_38886_38897[(1)] = cljs.core.first.call(null,(state_38871[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38898 = state_38871;
state_38871 = G__38898;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_38871){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_38871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38887 = f__2744__auto__.call(null);
(statearr_38887[(6)] = c__2743__auto__);

return statearr_38887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq38839){
var G__38840 = cljs.core.first.call(null,seq38839);
var seq38839__$1 = cljs.core.next.call(null,seq38839);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38840,seq38839__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38948 = arguments.length;
var i__5770__auto___38949 = (0);
while(true){
if((i__5770__auto___38949 < len__5769__auto___38948)){
args__5775__auto__.push((arguments[i__5770__auto___38949]));

var G__38950 = (i__5770__auto___38949 + (1));
i__5770__auto___38949 = G__38950;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38931){
var state_val_38932 = (state_38931[(1)]);
if((state_val_38932 === (1))){
var state_38931__$1 = state_38931;
var statearr_38933_38951 = state_38931__$1;
(statearr_38933_38951[(2)] = null);

(statearr_38933_38951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38932 === (2))){
var _ = (function (){var statearr_38934 = state_38931;
(statearr_38934[(4)] = cljs.core.cons.call(null,(5),(state_38931[(4)])));

return statearr_38934;
})();
var inst_38907 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_38931__$1 = state_38931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38931__$1,(6),inst_38907);
} else {
if((state_val_38932 === (3))){
var inst_38929 = (state_38931[(2)]);
var state_38931__$1 = state_38931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38931__$1,inst_38929);
} else {
if((state_val_38932 === (4))){
var inst_38901 = (state_38931[(2)]);
var state_38931__$1 = state_38931;
var statearr_38936_38952 = state_38931__$1;
(statearr_38936_38952[(2)] = inst_38901);

(statearr_38936_38952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38932 === (5))){
var _ = (function (){var statearr_38937 = state_38931;
(statearr_38937[(4)] = cljs.core.rest.call(null,(state_38931[(4)])));

return statearr_38937;
})();
var state_38931__$1 = state_38931;
var ex38935 = (state_38931__$1[(2)]);
var statearr_38938_38953 = state_38931__$1;
(statearr_38938_38953[(5)] = ex38935);


if((ex38935 instanceof Error)){
var statearr_38939_38954 = state_38931__$1;
(statearr_38939_38954[(1)] = (4));

(statearr_38939_38954[(5)] = null);

} else {
throw ex38935;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38932 === (6))){
var inst_38909 = (state_38931[(2)]);
var inst_38910 = fluree.db.util.async.throw_err.call(null,inst_38909);
var inst_38911 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_38910);
var inst_38912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38913 = [inst_38910];
var inst_38914 = (new cljs.core.PersistentVector(null,1,(5),inst_38912,inst_38913,null));
var inst_38915 = cljs.core.count.call(null,inst_38914);
var inst_38916 = ((9) + inst_38915);
var inst_38917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38918 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38920 = [inst_38910];
var inst_38921 = (new cljs.core.PersistentVector(null,1,(5),inst_38919,inst_38920,null));
var inst_38922 = ["max",inst_38921,inst_38911];
var inst_38923 = cljs.core.PersistentHashMap.fromArrays(inst_38918,inst_38922);
var inst_38924 = [inst_38923,inst_38916];
var inst_38925 = (new cljs.core.PersistentVector(null,2,(5),inst_38917,inst_38924,null));
var inst_38926 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38925);
var _ = (function (){var statearr_38940 = state_38931;
(statearr_38940[(4)] = cljs.core.rest.call(null,(state_38931[(4)])));

return statearr_38940;
})();
var state_38931__$1 = (function (){var statearr_38941 = state_38931;
(statearr_38941[(7)] = inst_38926);

return statearr_38941;
})();
var statearr_38942_38955 = state_38931__$1;
(statearr_38942_38955[(2)] = inst_38911);

(statearr_38942_38955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_38943 = [null,null,null,null,null,null,null,null];
(statearr_38943[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_38943[(1)] = (1));

return statearr_38943;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_38931){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e38944){var ex__2724__auto__ = e38944;
var statearr_38945_38956 = state_38931;
(statearr_38945_38956[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38931[(4)]))){
var statearr_38946_38957 = state_38931;
(statearr_38946_38957[(1)] = cljs.core.first.call(null,(state_38931[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38958 = state_38931;
state_38931 = G__38958;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_38931){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_38931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_38947 = f__2744__auto__.call(null);
(statearr_38947[(6)] = c__2743__auto__);

return statearr_38947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq38899){
var G__38900 = cljs.core.first.call(null,seq38899);
var seq38899__$1 = cljs.core.next.call(null,seq38899);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38900,seq38899__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___39008 = arguments.length;
var i__5770__auto___39009 = (0);
while(true){
if((i__5770__auto___39009 < len__5769__auto___39008)){
args__5775__auto__.push((arguments[i__5770__auto___39009]));

var G__39010 = (i__5770__auto___39009 + (1));
i__5770__auto___39009 = G__39010;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_38991){
var state_val_38992 = (state_38991[(1)]);
if((state_val_38992 === (1))){
var state_38991__$1 = state_38991;
var statearr_38993_39011 = state_38991__$1;
(statearr_38993_39011[(2)] = null);

(statearr_38993_39011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38992 === (2))){
var _ = (function (){var statearr_38994 = state_38991;
(statearr_38994[(4)] = cljs.core.cons.call(null,(5),(state_38991[(4)])));

return statearr_38994;
})();
var inst_38967 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_38991__$1 = state_38991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38991__$1,(6),inst_38967);
} else {
if((state_val_38992 === (3))){
var inst_38989 = (state_38991[(2)]);
var state_38991__$1 = state_38991;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38991__$1,inst_38989);
} else {
if((state_val_38992 === (4))){
var inst_38961 = (state_38991[(2)]);
var state_38991__$1 = state_38991;
var statearr_38996_39012 = state_38991__$1;
(statearr_38996_39012[(2)] = inst_38961);

(statearr_38996_39012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38992 === (5))){
var _ = (function (){var statearr_38997 = state_38991;
(statearr_38997[(4)] = cljs.core.rest.call(null,(state_38991[(4)])));

return statearr_38997;
})();
var state_38991__$1 = state_38991;
var ex38995 = (state_38991__$1[(2)]);
var statearr_38998_39013 = state_38991__$1;
(statearr_38998_39013[(5)] = ex38995);


if((ex38995 instanceof Error)){
var statearr_38999_39014 = state_38991__$1;
(statearr_38999_39014[(1)] = (4));

(statearr_38999_39014[(5)] = null);

} else {
throw ex38995;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38992 === (6))){
var inst_38969 = (state_38991[(2)]);
var inst_38970 = fluree.db.util.async.throw_err.call(null,inst_38969);
var inst_38971 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_38970);
var inst_38972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38973 = [inst_38970];
var inst_38974 = (new cljs.core.PersistentVector(null,1,(5),inst_38972,inst_38973,null));
var inst_38975 = cljs.core.count.call(null,inst_38974);
var inst_38976 = ((9) + inst_38975);
var inst_38977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38978 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_38979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38980 = [inst_38970];
var inst_38981 = (new cljs.core.PersistentVector(null,1,(5),inst_38979,inst_38980,null));
var inst_38982 = ["min",inst_38981,inst_38971];
var inst_38983 = cljs.core.PersistentHashMap.fromArrays(inst_38978,inst_38982);
var inst_38984 = [inst_38983,inst_38976];
var inst_38985 = (new cljs.core.PersistentVector(null,2,(5),inst_38977,inst_38984,null));
var inst_38986 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_38985);
var _ = (function (){var statearr_39000 = state_38991;
(statearr_39000[(4)] = cljs.core.rest.call(null,(state_38991[(4)])));

return statearr_39000;
})();
var state_38991__$1 = (function (){var statearr_39001 = state_38991;
(statearr_39001[(7)] = inst_38986);

return statearr_39001;
})();
var statearr_39002_39015 = state_38991__$1;
(statearr_39002_39015[(2)] = inst_38971);

(statearr_39002_39015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_39003 = [null,null,null,null,null,null,null,null];
(statearr_39003[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_39003[(1)] = (1));

return statearr_39003;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_38991){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_38991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39004){var ex__2724__auto__ = e39004;
var statearr_39005_39016 = state_38991;
(statearr_39005_39016[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_38991[(4)]))){
var statearr_39006_39017 = state_38991;
(statearr_39006_39017[(1)] = cljs.core.first.call(null,(state_38991[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39018 = state_38991;
state_38991 = G__39018;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_38991){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_38991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39007 = f__2744__auto__.call(null);
(statearr_39007[(6)] = c__2743__auto__);

return statearr_39007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq38959){
var G__38960 = cljs.core.first.call(null,seq38959);
var seq38959__$1 = cljs.core.next.call(null,seq38959);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38960,seq38959__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__39020 = arguments.length;
switch (G__39020) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39065){
var state_val_39066 = (state_39065[(1)]);
if((state_val_39066 === (7))){
var state_39065__$1 = state_39065;
var statearr_39067_39204 = state_39065__$1;
(statearr_39067_39204[(2)] = query_map);

(statearr_39067_39204[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39066 === (1))){
var state_39065__$1 = state_39065;
var statearr_39068_39205 = state_39065__$1;
(statearr_39068_39205[(2)] = null);

(statearr_39068_39205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39066 === (4))){
var inst_39021 = (state_39065[(2)]);
var state_39065__$1 = state_39065;
var statearr_39069_39206 = state_39065__$1;
(statearr_39069_39206[(2)] = inst_39021);

(statearr_39069_39206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39066 === (13))){
var inst_39043 = (state_39065[(7)]);
var inst_39047 = (state_39065[(2)]);
var inst_39048 = fluree.db.util.async.throw_err.call(null,inst_39047);
var inst_39049 = cljs.core.nth.call(null,inst_39048,(0),null);
var inst_39050 = cljs.core.nth.call(null,inst_39048,(1),null);
var inst_39051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39052 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39054 = [inst_39043];
var inst_39055 = (new cljs.core.PersistentVector(null,1,(5),inst_39053,inst_39054,null));
var inst_39056 = ["query",inst_39055,inst_39049];
var inst_39057 = cljs.core.PersistentHashMap.fromArrays(inst_39052,inst_39056);
var inst_39058 = [inst_39057,inst_39050];
var inst_39059 = (new cljs.core.PersistentVector(null,2,(5),inst_39051,inst_39058,null));
var inst_39060 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39059);
var _ = (function (){var statearr_39070 = state_39065;
(statearr_39070[(4)] = cljs.core.rest.call(null,(state_39065[(4)])));

return statearr_39070;
})();
var state_39065__$1 = (function (){var statearr_39071 = state_39065;
(statearr_39071[(8)] = inst_39060);

return statearr_39071;
})();
var statearr_39072_39207 = state_39065__$1;
(statearr_39072_39207[(2)] = inst_39049);

(statearr_39072_39207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39066 === (6))){
var state_39065__$1 = state_39065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39065__$1,(9),query_map);
} else {
if((state_val_39066 === (3))){
var inst_39063 = (state_39065[(2)]);
var state_39065__$1 = state_39065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39065__$1,inst_39063);
} else {
if((state_val_39066 === (12))){
var inst_39043 = (state_39065[(7)]);
var inst_39043__$1 = (state_39065[(2)]);
var inst_39044 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39045 = fluree.db.dbfunctions.internal.query.call(null,inst_39044,inst_39043__$1);
var state_39065__$1 = (function (){var statearr_39073 = state_39065;
(statearr_39073[(7)] = inst_39043__$1);

return statearr_39073;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39065__$1,(13),inst_39045);
} else {
if((state_val_39066 === (2))){
var _ = (function (){var statearr_39074 = state_39065;
(statearr_39074[(4)] = cljs.core.cons.call(null,(5),(state_39065[(4)])));

return statearr_39074;
})();
var inst_39030 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_39065__$1 = state_39065;
if(inst_39030){
var statearr_39075_39208 = state_39065__$1;
(statearr_39075_39208[(1)] = (6));

} else {
var statearr_39076_39209 = state_39065__$1;
(statearr_39076_39209[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39066 === (11))){
var inst_39037 = (state_39065[(9)]);
var state_39065__$1 = state_39065;
var statearr_39078_39210 = state_39065__$1;
(statearr_39078_39210[(2)] = inst_39037);

(statearr_39078_39210[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39066 === (9))){
var inst_39033 = (state_39065[(2)]);
var inst_39034 = fluree.db.util.async.throw_err.call(null,inst_39033);
var state_39065__$1 = state_39065;
var statearr_39079_39211 = state_39065__$1;
(statearr_39079_39211[(2)] = inst_39034);

(statearr_39079_39211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39066 === (5))){
var _ = (function (){var statearr_39080 = state_39065;
(statearr_39080[(4)] = cljs.core.rest.call(null,(state_39065[(4)])));

return statearr_39080;
})();
var state_39065__$1 = state_39065;
var ex39077 = (state_39065__$1[(2)]);
var statearr_39081_39212 = state_39065__$1;
(statearr_39081_39212[(5)] = ex39077);


if((ex39077 instanceof Error)){
var statearr_39082_39213 = state_39065__$1;
(statearr_39082_39213[(1)] = (4));

(statearr_39082_39213[(5)] = null);

} else {
throw ex39077;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39066 === (10))){
var inst_39037 = (state_39065[(9)]);
var inst_39040 = fluree.db.util.json.parse.call(null,inst_39037);
var state_39065__$1 = state_39065;
var statearr_39083_39214 = state_39065__$1;
(statearr_39083_39214[(2)] = inst_39040);

(statearr_39083_39214[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39066 === (8))){
var inst_39037 = (state_39065[(9)]);
var inst_39037__$1 = (state_39065[(2)]);
var inst_39038 = typeof inst_39037__$1 === 'string';
var state_39065__$1 = (function (){var statearr_39084 = state_39065;
(statearr_39084[(9)] = inst_39037__$1);

return statearr_39084;
})();
if(cljs.core.truth_(inst_39038)){
var statearr_39085_39215 = state_39065__$1;
(statearr_39085_39215[(1)] = (10));

} else {
var statearr_39086_39216 = state_39065__$1;
(statearr_39086_39216[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_39087 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39087[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_39087[(1)] = (1));

return statearr_39087;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_39065){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39088){var ex__2724__auto__ = e39088;
var statearr_39089_39217 = state_39065;
(statearr_39089_39217[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39065[(4)]))){
var statearr_39090_39218 = state_39065;
(statearr_39090_39218[(1)] = cljs.core.first.call(null,(state_39065[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39219 = state_39065;
state_39065 = G__39219;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_39065){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_39065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39091 = f__2744__auto__.call(null);
(statearr_39091[(6)] = c__2743__auto__);

return statearr_39091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39162){
var state_val_39163 = (state_39162[(1)]);
if((state_val_39163 === (7))){
var state_39162__$1 = state_39162;
var statearr_39164_39220 = state_39162__$1;
(statearr_39164_39220[(2)] = select);

(statearr_39164_39220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (20))){
var inst_39132 = (state_39162[(2)]);
var inst_39133 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_39162__$1 = (function (){var statearr_39165 = state_39162;
(statearr_39165[(7)] = inst_39132);

return statearr_39165;
})();
if(inst_39133){
var statearr_39166_39221 = state_39162__$1;
(statearr_39166_39221[(1)] = (22));

} else {
var statearr_39167_39222 = state_39162__$1;
(statearr_39167_39222[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (1))){
var state_39162__$1 = state_39162;
var statearr_39168_39223 = state_39162__$1;
(statearr_39168_39223[(2)] = null);

(statearr_39168_39223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (24))){
var inst_39108 = (state_39162[(8)]);
var inst_39132 = (state_39162[(7)]);
var inst_39116 = (state_39162[(9)]);
var inst_39124 = (state_39162[(10)]);
var inst_39140 = (state_39162[(2)]);
var inst_39141 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39142 = fluree.db.dbfunctions.internal.query.call(null,inst_39141,inst_39108,inst_39116,inst_39124,inst_39132,inst_39140);
var state_39162__$1 = state_39162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39162__$1,(26),inst_39142);
} else {
if((state_val_39163 === (4))){
var inst_39092 = (state_39162[(2)]);
var state_39162__$1 = state_39162;
var statearr_39169_39224 = state_39162__$1;
(statearr_39169_39224[(2)] = inst_39092);

(statearr_39169_39224[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (15))){
var state_39162__$1 = state_39162;
var statearr_39170_39225 = state_39162__$1;
(statearr_39170_39225[(2)] = where);

(statearr_39170_39225[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (21))){
var inst_39128 = (state_39162[(2)]);
var inst_39129 = fluree.db.util.async.throw_err.call(null,inst_39128);
var state_39162__$1 = state_39162;
var statearr_39171_39226 = state_39162__$1;
(statearr_39171_39226[(2)] = inst_39129);

(statearr_39171_39226[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (13))){
var inst_39112 = (state_39162[(2)]);
var inst_39113 = fluree.db.util.async.throw_err.call(null,inst_39112);
var state_39162__$1 = state_39162;
var statearr_39172_39227 = state_39162__$1;
(statearr_39172_39227[(2)] = inst_39113);

(statearr_39172_39227[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (22))){
var state_39162__$1 = state_39162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39162__$1,(25),limit);
} else {
if((state_val_39163 === (6))){
var state_39162__$1 = state_39162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39162__$1,(9),select);
} else {
if((state_val_39163 === (25))){
var inst_39136 = (state_39162[(2)]);
var inst_39137 = fluree.db.util.async.throw_err.call(null,inst_39136);
var state_39162__$1 = state_39162;
var statearr_39173_39228 = state_39162__$1;
(statearr_39173_39228[(2)] = inst_39137);

(statearr_39173_39228[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (17))){
var inst_39120 = (state_39162[(2)]);
var inst_39121 = fluree.db.util.async.throw_err.call(null,inst_39120);
var state_39162__$1 = state_39162;
var statearr_39174_39229 = state_39162__$1;
(statearr_39174_39229[(2)] = inst_39121);

(statearr_39174_39229[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (3))){
var inst_39160 = (state_39162[(2)]);
var state_39162__$1 = state_39162;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39162__$1,inst_39160);
} else {
if((state_val_39163 === (12))){
var inst_39116 = (state_39162[(2)]);
var inst_39117 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_39162__$1 = (function (){var statearr_39175 = state_39162;
(statearr_39175[(9)] = inst_39116);

return statearr_39175;
})();
if(inst_39117){
var statearr_39176_39230 = state_39162__$1;
(statearr_39176_39230[(1)] = (14));

} else {
var statearr_39177_39231 = state_39162__$1;
(statearr_39177_39231[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (2))){
var _ = (function (){var statearr_39178 = state_39162;
(statearr_39178[(4)] = cljs.core.cons.call(null,(5),(state_39162[(4)])));

return statearr_39178;
})();
var inst_39101 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_39162__$1 = state_39162;
if(inst_39101){
var statearr_39179_39232 = state_39162__$1;
(statearr_39179_39232[(1)] = (6));

} else {
var statearr_39180_39233 = state_39162__$1;
(statearr_39180_39233[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (23))){
var state_39162__$1 = state_39162;
var statearr_39181_39234 = state_39162__$1;
(statearr_39181_39234[(2)] = limit);

(statearr_39181_39234[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (19))){
var state_39162__$1 = state_39162;
var statearr_39182_39235 = state_39162__$1;
(statearr_39182_39235[(2)] = block);

(statearr_39182_39235[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (11))){
var state_39162__$1 = state_39162;
var statearr_39184_39236 = state_39162__$1;
(statearr_39184_39236[(2)] = from);

(statearr_39184_39236[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (9))){
var inst_39104 = (state_39162[(2)]);
var inst_39105 = fluree.db.util.async.throw_err.call(null,inst_39104);
var state_39162__$1 = state_39162;
var statearr_39185_39237 = state_39162__$1;
(statearr_39185_39237[(2)] = inst_39105);

(statearr_39185_39237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (5))){
var _ = (function (){var statearr_39186 = state_39162;
(statearr_39186[(4)] = cljs.core.rest.call(null,(state_39162[(4)])));

return statearr_39186;
})();
var state_39162__$1 = state_39162;
var ex39183 = (state_39162__$1[(2)]);
var statearr_39187_39238 = state_39162__$1;
(statearr_39187_39238[(5)] = ex39183);


if((ex39183 instanceof Error)){
var statearr_39188_39239 = state_39162__$1;
(statearr_39188_39239[(1)] = (4));

(statearr_39188_39239[(5)] = null);

} else {
throw ex39183;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (14))){
var state_39162__$1 = state_39162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39162__$1,(17),where);
} else {
if((state_val_39163 === (26))){
var inst_39108 = (state_39162[(8)]);
var inst_39132 = (state_39162[(7)]);
var inst_39116 = (state_39162[(9)]);
var inst_39124 = (state_39162[(10)]);
var inst_39144 = (state_39162[(2)]);
var inst_39145 = fluree.db.util.async.throw_err.call(null,inst_39144);
var inst_39146 = cljs.core.nth.call(null,inst_39145,(0),null);
var inst_39147 = cljs.core.nth.call(null,inst_39145,(1),null);
var inst_39148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39149 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39151 = [inst_39108,inst_39116,inst_39124,inst_39132];
var inst_39152 = (new cljs.core.PersistentVector(null,4,(5),inst_39150,inst_39151,null));
var inst_39153 = ["query",inst_39152,inst_39146];
var inst_39154 = cljs.core.PersistentHashMap.fromArrays(inst_39149,inst_39153);
var inst_39155 = [inst_39154,inst_39147];
var inst_39156 = (new cljs.core.PersistentVector(null,2,(5),inst_39148,inst_39155,null));
var inst_39157 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39156);
var _ = (function (){var statearr_39189 = state_39162;
(statearr_39189[(4)] = cljs.core.rest.call(null,(state_39162[(4)])));

return statearr_39189;
})();
var state_39162__$1 = (function (){var statearr_39190 = state_39162;
(statearr_39190[(11)] = inst_39157);

return statearr_39190;
})();
var statearr_39191_39240 = state_39162__$1;
(statearr_39191_39240[(2)] = inst_39146);

(statearr_39191_39240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (16))){
var inst_39124 = (state_39162[(2)]);
var inst_39125 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_39162__$1 = (function (){var statearr_39192 = state_39162;
(statearr_39192[(10)] = inst_39124);

return statearr_39192;
})();
if(inst_39125){
var statearr_39193_39241 = state_39162__$1;
(statearr_39193_39241[(1)] = (18));

} else {
var statearr_39194_39242 = state_39162__$1;
(statearr_39194_39242[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39163 === (10))){
var state_39162__$1 = state_39162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39162__$1,(13),from);
} else {
if((state_val_39163 === (18))){
var state_39162__$1 = state_39162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39162__$1,(21),block);
} else {
if((state_val_39163 === (8))){
var inst_39108 = (state_39162[(2)]);
var inst_39109 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_39162__$1 = (function (){var statearr_39195 = state_39162;
(statearr_39195[(8)] = inst_39108);

return statearr_39195;
})();
if(inst_39109){
var statearr_39196_39243 = state_39162__$1;
(statearr_39196_39243[(1)] = (10));

} else {
var statearr_39197_39244 = state_39162__$1;
(statearr_39197_39244[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_39198 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39198[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_39198[(1)] = (1));

return statearr_39198;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_39162){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39162);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39199){var ex__2724__auto__ = e39199;
var statearr_39200_39245 = state_39162;
(statearr_39200_39245[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39162[(4)]))){
var statearr_39201_39246 = state_39162;
(statearr_39201_39246[(1)] = cljs.core.first.call(null,(state_39162[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39247 = state_39162;
state_39162 = G__39247;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_39162){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_39162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39202 = f__2744__auto__.call(null);
(statearr_39202[(6)] = c__2743__auto__);

return statearr_39202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39303){
var state_val_39304 = (state_39303[(1)]);
if((state_val_39304 === (7))){
var state_39303__$1 = state_39303;
var statearr_39305_39336 = state_39303__$1;
(statearr_39305_39336[(2)] = startSubject);

(statearr_39305_39336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (1))){
var state_39303__$1 = state_39303;
var statearr_39306_39337 = state_39303__$1;
(statearr_39306_39337[(2)] = null);

(statearr_39306_39337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (4))){
var inst_39248 = (state_39303[(2)]);
var state_39303__$1 = state_39303;
var statearr_39307_39338 = state_39303__$1;
(statearr_39307_39338[(2)] = inst_39248);

(statearr_39307_39338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (15))){
var inst_39280 = (state_39303[(2)]);
var inst_39281 = fluree.db.util.async.throw_err.call(null,inst_39280);
var inst_39282 = cljs.core.nth.call(null,inst_39281,(0),null);
var inst_39283 = cljs.core.nth.call(null,inst_39281,(1),null);
var inst_39284 = cljs.core.empty_QMARK_.call(null,inst_39282);
var state_39303__$1 = (function (){var statearr_39308 = state_39303;
(statearr_39308[(7)] = inst_39283);

return statearr_39308;
})();
if(inst_39284){
var statearr_39309_39339 = state_39303__$1;
(statearr_39309_39339[(1)] = (16));

} else {
var statearr_39310_39340 = state_39303__$1;
(statearr_39310_39340[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (13))){
var inst_39276 = (state_39303[(8)]);
var inst_39264 = (state_39303[(9)]);
var inst_39268 = (state_39303[(10)]);
var inst_39276__$1 = (state_39303[(2)]);
var inst_39277 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39278 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_39277,inst_39264,inst_39268,inst_39276__$1);
var state_39303__$1 = (function (){var statearr_39311 = state_39303;
(statearr_39311[(8)] = inst_39276__$1);

return statearr_39311;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39303__$1,(15),inst_39278);
} else {
if((state_val_39304 === (6))){
var state_39303__$1 = state_39303;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39303__$1,(9),startSubject);
} else {
if((state_val_39304 === (17))){
var state_39303__$1 = state_39303;
var statearr_39312_39341 = state_39303__$1;
(statearr_39312_39341[(2)] = true);

(statearr_39312_39341[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (3))){
var inst_39301 = (state_39303[(2)]);
var state_39303__$1 = state_39303;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39303__$1,inst_39301);
} else {
if((state_val_39304 === (12))){
var state_39303__$1 = state_39303;
var statearr_39313_39342 = state_39303__$1;
(statearr_39313_39342[(2)] = endSubject);

(statearr_39313_39342[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (2))){
var _ = (function (){var statearr_39314 = state_39303;
(statearr_39314[(4)] = cljs.core.cons.call(null,(5),(state_39303[(4)])));

return statearr_39314;
})();
var inst_39257 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_39303__$1 = state_39303;
if(inst_39257){
var statearr_39315_39343 = state_39303__$1;
(statearr_39315_39343[(1)] = (6));

} else {
var statearr_39316_39344 = state_39303__$1;
(statearr_39316_39344[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (11))){
var state_39303__$1 = state_39303;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39303__$1,(14),endSubject);
} else {
if((state_val_39304 === (9))){
var inst_39260 = (state_39303[(2)]);
var inst_39261 = fluree.db.util.async.throw_err.call(null,inst_39260);
var state_39303__$1 = state_39303;
var statearr_39318_39345 = state_39303__$1;
(statearr_39318_39345[(2)] = inst_39261);

(statearr_39318_39345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (5))){
var _ = (function (){var statearr_39319 = state_39303;
(statearr_39319[(4)] = cljs.core.rest.call(null,(state_39303[(4)])));

return statearr_39319;
})();
var state_39303__$1 = state_39303;
var ex39317 = (state_39303__$1[(2)]);
var statearr_39320_39346 = state_39303__$1;
(statearr_39320_39346[(5)] = ex39317);


if((ex39317 instanceof Error)){
var statearr_39321_39347 = state_39303__$1;
(statearr_39321_39347[(1)] = (4));

(statearr_39321_39347[(5)] = null);

} else {
throw ex39317;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (14))){
var inst_39272 = (state_39303[(2)]);
var inst_39273 = fluree.db.util.async.throw_err.call(null,inst_39272);
var state_39303__$1 = state_39303;
var statearr_39322_39348 = state_39303__$1;
(statearr_39322_39348[(2)] = inst_39273);

(statearr_39322_39348[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (16))){
var state_39303__$1 = state_39303;
var statearr_39323_39349 = state_39303__$1;
(statearr_39323_39349[(2)] = false);

(statearr_39323_39349[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (10))){
var inst_39267 = (state_39303[(2)]);
var inst_39268 = fluree.db.util.async.throw_err.call(null,inst_39267);
var inst_39269 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_39303__$1 = (function (){var statearr_39324 = state_39303;
(statearr_39324[(10)] = inst_39268);

return statearr_39324;
})();
if(inst_39269){
var statearr_39325_39350 = state_39303__$1;
(statearr_39325_39350[(1)] = (11));

} else {
var statearr_39326_39351 = state_39303__$1;
(statearr_39326_39351[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (18))){
var inst_39276 = (state_39303[(8)]);
var inst_39264 = (state_39303[(9)]);
var inst_39283 = (state_39303[(7)]);
var inst_39268 = (state_39303[(10)]);
var inst_39288 = (state_39303[(2)]);
var inst_39289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39290 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39292 = [inst_39264,inst_39268,inst_39276];
var inst_39293 = (new cljs.core.PersistentVector(null,3,(5),inst_39291,inst_39292,null));
var inst_39294 = ["relationship?",inst_39293,inst_39288];
var inst_39295 = cljs.core.PersistentHashMap.fromArrays(inst_39290,inst_39294);
var inst_39296 = [inst_39295,inst_39283];
var inst_39297 = (new cljs.core.PersistentVector(null,2,(5),inst_39289,inst_39296,null));
var inst_39298 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39297);
var _ = (function (){var statearr_39327 = state_39303;
(statearr_39327[(4)] = cljs.core.rest.call(null,(state_39303[(4)])));

return statearr_39327;
})();
var state_39303__$1 = (function (){var statearr_39328 = state_39303;
(statearr_39328[(11)] = inst_39298);

return statearr_39328;
})();
var statearr_39329_39352 = state_39303__$1;
(statearr_39329_39352[(2)] = inst_39288);

(statearr_39329_39352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39304 === (8))){
var inst_39264 = (state_39303[(2)]);
var inst_39265 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_39303__$1 = (function (){var statearr_39330 = state_39303;
(statearr_39330[(9)] = inst_39264);

return statearr_39330;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39303__$1,(10),inst_39265);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto____0 = (function (){
var statearr_39331 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39331[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto__);

(statearr_39331[(1)] = (1));

return statearr_39331;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto____1 = (function (state_39303){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39303);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39332){var ex__2724__auto__ = e39332;
var statearr_39333_39353 = state_39303;
(statearr_39333_39353[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39303[(4)]))){
var statearr_39334_39354 = state_39303;
(statearr_39334_39354[(1)] = cljs.core.first.call(null,(state_39303[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39355 = state_39303;
state_39303 = G__39355;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto__ = function(state_39303){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto____1.call(this,state_39303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39335 = f__2744__auto__.call(null);
(statearr_39335[(6)] = c__2743__auto__);

return statearr_39335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39392){
var state_val_39393 = (state_39392[(1)]);
if((state_val_39393 === (7))){
var state_39392__$1 = state_39392;
var statearr_39394_39414 = state_39392__$1;
(statearr_39394_39414[(2)] = pred_name);

(statearr_39394_39414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39393 === (1))){
var state_39392__$1 = state_39392;
var statearr_39395_39415 = state_39392__$1;
(statearr_39395_39415[(2)] = null);

(statearr_39395_39415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39393 === (4))){
var inst_39356 = (state_39392[(2)]);
var state_39392__$1 = state_39392;
var statearr_39396_39416 = state_39392__$1;
(statearr_39396_39416[(2)] = inst_39356);

(statearr_39396_39416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39393 === (6))){
var state_39392__$1 = state_39392;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39392__$1,(9),pred_name);
} else {
if((state_val_39393 === (3))){
var inst_39390 = (state_39392[(2)]);
var state_39392__$1 = state_39392;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39392__$1,inst_39390);
} else {
if((state_val_39393 === (2))){
var _ = (function (){var statearr_39398 = state_39392;
(statearr_39398[(4)] = cljs.core.cons.call(null,(5),(state_39392[(4)])));

return statearr_39398;
})();
var inst_39365 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_39392__$1 = state_39392;
if(inst_39365){
var statearr_39399_39417 = state_39392__$1;
(statearr_39399_39417[(1)] = (6));

} else {
var statearr_39400_39418 = state_39392__$1;
(statearr_39400_39418[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39393 === (9))){
var inst_39368 = (state_39392[(2)]);
var inst_39369 = fluree.db.util.async.throw_err.call(null,inst_39368);
var state_39392__$1 = state_39392;
var statearr_39401_39419 = state_39392__$1;
(statearr_39401_39419[(2)] = inst_39369);

(statearr_39401_39419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39393 === (5))){
var _ = (function (){var statearr_39402 = state_39392;
(statearr_39402[(4)] = cljs.core.rest.call(null,(state_39392[(4)])));

return statearr_39402;
})();
var state_39392__$1 = state_39392;
var ex39397 = (state_39392__$1[(2)]);
var statearr_39403_39420 = state_39392__$1;
(statearr_39403_39420[(5)] = ex39397);


if((ex39397 instanceof Error)){
var statearr_39404_39421 = state_39392__$1;
(statearr_39404_39421[(1)] = (4));

(statearr_39404_39421[(5)] = null);

} else {
throw ex39397;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39393 === (10))){
var inst_39372 = (state_39392[(7)]);
var inst_39376 = (state_39392[(2)]);
var inst_39377 = fluree.db.util.async.throw_err.call(null,inst_39376);
var inst_39378 = cljs.core.nth.call(null,inst_39377,(0),null);
var inst_39379 = cljs.core.nth.call(null,inst_39377,(1),null);
var inst_39380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39381 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39382 = ["max-pred-val",inst_39372,inst_39378];
var inst_39383 = cljs.core.PersistentHashMap.fromArrays(inst_39381,inst_39382);
var inst_39384 = (inst_39379 + (10));
var inst_39385 = [inst_39383,inst_39384];
var inst_39386 = (new cljs.core.PersistentVector(null,2,(5),inst_39380,inst_39385,null));
var inst_39387 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39386);
var _ = (function (){var statearr_39405 = state_39392;
(statearr_39405[(4)] = cljs.core.rest.call(null,(state_39392[(4)])));

return statearr_39405;
})();
var state_39392__$1 = (function (){var statearr_39406 = state_39392;
(statearr_39406[(8)] = inst_39387);

return statearr_39406;
})();
var statearr_39407_39422 = state_39392__$1;
(statearr_39407_39422[(2)] = inst_39378);

(statearr_39407_39422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39393 === (8))){
var inst_39372 = (state_39392[(7)]);
var inst_39372__$1 = (state_39392[(2)]);
var inst_39373 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39374 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_39373,inst_39372__$1,null);
var state_39392__$1 = (function (){var statearr_39408 = state_39392;
(statearr_39408[(7)] = inst_39372__$1);

return statearr_39408;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39392__$1,(10),inst_39374);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto____0 = (function (){
var statearr_39409 = [null,null,null,null,null,null,null,null,null];
(statearr_39409[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto__);

(statearr_39409[(1)] = (1));

return statearr_39409;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto____1 = (function (state_39392){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39392);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39410){var ex__2724__auto__ = e39410;
var statearr_39411_39423 = state_39392;
(statearr_39411_39423[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39392[(4)]))){
var statearr_39412_39424 = state_39392;
(statearr_39412_39424[(1)] = cljs.core.first.call(null,(state_39392[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39425 = state_39392;
state_39392 = G__39425;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto__ = function(state_39392){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto____1.call(this,state_39392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39413 = f__2744__auto__.call(null);
(statearr_39413[(6)] = c__2743__auto__);

return statearr_39413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39452){
var state_val_39453 = (state_39452[(1)]);
if((state_val_39453 === (7))){
var state_39452__$1 = state_39452;
var statearr_39454_39473 = state_39452__$1;
(statearr_39454_39473[(2)] = n);

(statearr_39454_39473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39453 === (1))){
var state_39452__$1 = state_39452;
var statearr_39455_39474 = state_39452__$1;
(statearr_39455_39474[(2)] = null);

(statearr_39455_39474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39453 === (4))){
var inst_39426 = (state_39452[(2)]);
var state_39452__$1 = state_39452;
var statearr_39456_39475 = state_39452__$1;
(statearr_39456_39475[(2)] = inst_39426);

(statearr_39456_39475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39453 === (6))){
var state_39452__$1 = state_39452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39452__$1,(9),n);
} else {
if((state_val_39453 === (3))){
var inst_39450 = (state_39452[(2)]);
var state_39452__$1 = state_39452;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39452__$1,inst_39450);
} else {
if((state_val_39453 === (2))){
var _ = (function (){var statearr_39458 = state_39452;
(statearr_39458[(4)] = cljs.core.cons.call(null,(5),(state_39452[(4)])));

return statearr_39458;
})();
var inst_39432 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_39452__$1 = state_39452;
if(inst_39432){
var statearr_39459_39476 = state_39452__$1;
(statearr_39459_39476[(1)] = (6));

} else {
var statearr_39460_39477 = state_39452__$1;
(statearr_39460_39477[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39453 === (9))){
var inst_39435 = (state_39452[(2)]);
var inst_39436 = fluree.db.util.async.throw_err.call(null,inst_39435);
var state_39452__$1 = state_39452;
var statearr_39461_39478 = state_39452__$1;
(statearr_39461_39478[(2)] = inst_39436);

(statearr_39461_39478[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39453 === (5))){
var _ = (function (){var statearr_39462 = state_39452;
(statearr_39462[(4)] = cljs.core.rest.call(null,(state_39452[(4)])));

return statearr_39462;
})();
var state_39452__$1 = state_39452;
var ex39457 = (state_39452__$1[(2)]);
var statearr_39463_39479 = state_39452__$1;
(statearr_39463_39479[(5)] = ex39457);


if((ex39457 instanceof Error)){
var statearr_39464_39480 = state_39452__$1;
(statearr_39464_39480[(1)] = (4));

(statearr_39464_39480[(5)] = null);

} else {
throw ex39457;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39453 === (8))){
var inst_39439 = (state_39452[(2)]);
var inst_39440 = fluree.db.dbfunctions.internal.inc.call(null,inst_39439);
var inst_39441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39442 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39443 = ["inc",inst_39439,inst_39440];
var inst_39444 = cljs.core.PersistentHashMap.fromArrays(inst_39442,inst_39443);
var inst_39445 = [inst_39444,(10)];
var inst_39446 = (new cljs.core.PersistentVector(null,2,(5),inst_39441,inst_39445,null));
var inst_39447 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39446);
var _ = (function (){var statearr_39465 = state_39452;
(statearr_39465[(4)] = cljs.core.rest.call(null,(state_39452[(4)])));

return statearr_39465;
})();
var state_39452__$1 = (function (){var statearr_39466 = state_39452;
(statearr_39466[(7)] = inst_39447);

return statearr_39466;
})();
var statearr_39467_39481 = state_39452__$1;
(statearr_39467_39481[(2)] = inst_39440);

(statearr_39467_39481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto____0 = (function (){
var statearr_39468 = [null,null,null,null,null,null,null,null];
(statearr_39468[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto__);

(statearr_39468[(1)] = (1));

return statearr_39468;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto____1 = (function (state_39452){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39452);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39469){var ex__2724__auto__ = e39469;
var statearr_39470_39482 = state_39452;
(statearr_39470_39482[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39452[(4)]))){
var statearr_39471_39483 = state_39452;
(statearr_39471_39483[(1)] = cljs.core.first.call(null,(state_39452[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39484 = state_39452;
state_39452 = G__39484;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto__ = function(state_39452){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto____1.call(this,state_39452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39472 = f__2744__auto__.call(null);
(statearr_39472[(6)] = c__2743__auto__);

return statearr_39472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39511){
var state_val_39512 = (state_39511[(1)]);
if((state_val_39512 === (7))){
var state_39511__$1 = state_39511;
var statearr_39513_39532 = state_39511__$1;
(statearr_39513_39532[(2)] = n);

(statearr_39513_39532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39512 === (1))){
var state_39511__$1 = state_39511;
var statearr_39514_39533 = state_39511__$1;
(statearr_39514_39533[(2)] = null);

(statearr_39514_39533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39512 === (4))){
var inst_39485 = (state_39511[(2)]);
var state_39511__$1 = state_39511;
var statearr_39515_39534 = state_39511__$1;
(statearr_39515_39534[(2)] = inst_39485);

(statearr_39515_39534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39512 === (6))){
var state_39511__$1 = state_39511;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39511__$1,(9),n);
} else {
if((state_val_39512 === (3))){
var inst_39509 = (state_39511[(2)]);
var state_39511__$1 = state_39511;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39511__$1,inst_39509);
} else {
if((state_val_39512 === (2))){
var _ = (function (){var statearr_39517 = state_39511;
(statearr_39517[(4)] = cljs.core.cons.call(null,(5),(state_39511[(4)])));

return statearr_39517;
})();
var inst_39491 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_39511__$1 = state_39511;
if(inst_39491){
var statearr_39518_39535 = state_39511__$1;
(statearr_39518_39535[(1)] = (6));

} else {
var statearr_39519_39536 = state_39511__$1;
(statearr_39519_39536[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39512 === (9))){
var inst_39494 = (state_39511[(2)]);
var inst_39495 = fluree.db.util.async.throw_err.call(null,inst_39494);
var state_39511__$1 = state_39511;
var statearr_39520_39537 = state_39511__$1;
(statearr_39520_39537[(2)] = inst_39495);

(statearr_39520_39537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39512 === (5))){
var _ = (function (){var statearr_39521 = state_39511;
(statearr_39521[(4)] = cljs.core.rest.call(null,(state_39511[(4)])));

return statearr_39521;
})();
var state_39511__$1 = state_39511;
var ex39516 = (state_39511__$1[(2)]);
var statearr_39522_39538 = state_39511__$1;
(statearr_39522_39538[(5)] = ex39516);


if((ex39516 instanceof Error)){
var statearr_39523_39539 = state_39511__$1;
(statearr_39523_39539[(1)] = (4));

(statearr_39523_39539[(5)] = null);

} else {
throw ex39516;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39512 === (8))){
var inst_39498 = (state_39511[(2)]);
var inst_39499 = fluree.db.dbfunctions.internal.dec.call(null,inst_39498);
var inst_39500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39501 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39502 = ["dec",inst_39498,inst_39499];
var inst_39503 = cljs.core.PersistentHashMap.fromArrays(inst_39501,inst_39502);
var inst_39504 = [inst_39503,(10)];
var inst_39505 = (new cljs.core.PersistentVector(null,2,(5),inst_39500,inst_39504,null));
var inst_39506 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39505);
var _ = (function (){var statearr_39524 = state_39511;
(statearr_39524[(4)] = cljs.core.rest.call(null,(state_39511[(4)])));

return statearr_39524;
})();
var state_39511__$1 = (function (){var statearr_39525 = state_39511;
(statearr_39525[(7)] = inst_39506);

return statearr_39525;
})();
var statearr_39526_39540 = state_39511__$1;
(statearr_39526_39540[(2)] = inst_39499);

(statearr_39526_39540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto____0 = (function (){
var statearr_39527 = [null,null,null,null,null,null,null,null];
(statearr_39527[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto__);

(statearr_39527[(1)] = (1));

return statearr_39527;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto____1 = (function (state_39511){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39511);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39528){var ex__2724__auto__ = e39528;
var statearr_39529_39541 = state_39511;
(statearr_39529_39541[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39511[(4)]))){
var statearr_39530_39542 = state_39511;
(statearr_39530_39542[(1)] = cljs.core.first.call(null,(state_39511[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39543 = state_39511;
state_39511 = G__39543;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto__ = function(state_39511){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto____1.call(this,state_39511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39531 = f__2744__auto__.call(null);
(statearr_39531[(6)] = c__2743__auto__);

return statearr_39531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___39593 = arguments.length;
var i__5770__auto___39594 = (0);
while(true){
if((i__5770__auto___39594 < len__5769__auto___39593)){
args__5775__auto__.push((arguments[i__5770__auto___39594]));

var G__39595 = (i__5770__auto___39594 + (1));
i__5770__auto___39594 = G__39595;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39576){
var state_val_39577 = (state_39576[(1)]);
if((state_val_39577 === (1))){
var state_39576__$1 = state_39576;
var statearr_39578_39596 = state_39576__$1;
(statearr_39578_39596[(2)] = null);

(statearr_39578_39596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39577 === (2))){
var _ = (function (){var statearr_39579 = state_39576;
(statearr_39579[(4)] = cljs.core.cons.call(null,(5),(state_39576[(4)])));

return statearr_39579;
})();
var inst_39552 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_39576__$1 = state_39576;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39576__$1,(6),inst_39552);
} else {
if((state_val_39577 === (3))){
var inst_39574 = (state_39576[(2)]);
var state_39576__$1 = state_39576;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39576__$1,inst_39574);
} else {
if((state_val_39577 === (4))){
var inst_39546 = (state_39576[(2)]);
var state_39576__$1 = state_39576;
var statearr_39581_39597 = state_39576__$1;
(statearr_39581_39597[(2)] = inst_39546);

(statearr_39581_39597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39577 === (5))){
var _ = (function (){var statearr_39582 = state_39576;
(statearr_39582[(4)] = cljs.core.rest.call(null,(state_39576[(4)])));

return statearr_39582;
})();
var state_39576__$1 = state_39576;
var ex39580 = (state_39576__$1[(2)]);
var statearr_39583_39598 = state_39576__$1;
(statearr_39583_39598[(5)] = ex39580);


if((ex39580 instanceof Error)){
var statearr_39584_39599 = state_39576__$1;
(statearr_39584_39599[(1)] = (4));

(statearr_39584_39599[(5)] = null);

} else {
throw ex39580;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39577 === (6))){
var inst_39554 = (state_39576[(2)]);
var inst_39555 = fluree.db.util.async.throw_err.call(null,inst_39554);
var inst_39556 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_39555);
var inst_39557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39558 = [inst_39555];
var inst_39559 = (new cljs.core.PersistentVector(null,1,(5),inst_39557,inst_39558,null));
var inst_39560 = cljs.core.count.call(null,inst_39559);
var inst_39561 = ((9) + inst_39560);
var inst_39562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39563 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39565 = [inst_39555];
var inst_39566 = (new cljs.core.PersistentVector(null,1,(5),inst_39564,inst_39565,null));
var inst_39567 = ["+",inst_39566,inst_39556];
var inst_39568 = cljs.core.PersistentHashMap.fromArrays(inst_39563,inst_39567);
var inst_39569 = [inst_39568,inst_39561];
var inst_39570 = (new cljs.core.PersistentVector(null,2,(5),inst_39562,inst_39569,null));
var inst_39571 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39570);
var _ = (function (){var statearr_39585 = state_39576;
(statearr_39585[(4)] = cljs.core.rest.call(null,(state_39576[(4)])));

return statearr_39585;
})();
var state_39576__$1 = (function (){var statearr_39586 = state_39576;
(statearr_39586[(7)] = inst_39571);

return statearr_39586;
})();
var statearr_39587_39600 = state_39576__$1;
(statearr_39587_39600[(2)] = inst_39556);

(statearr_39587_39600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_39588 = [null,null,null,null,null,null,null,null];
(statearr_39588[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_39588[(1)] = (1));

return statearr_39588;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_39576){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39576);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39589){var ex__2724__auto__ = e39589;
var statearr_39590_39601 = state_39576;
(statearr_39590_39601[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39576[(4)]))){
var statearr_39591_39602 = state_39576;
(statearr_39591_39602[(1)] = cljs.core.first.call(null,(state_39576[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39603 = state_39576;
state_39576 = G__39603;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_39576){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_39576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39592 = f__2744__auto__.call(null);
(statearr_39592[(6)] = c__2743__auto__);

return statearr_39592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq39544){
var G__39545 = cljs.core.first.call(null,seq39544);
var seq39544__$1 = cljs.core.next.call(null,seq39544);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39545,seq39544__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___39653 = arguments.length;
var i__5770__auto___39654 = (0);
while(true){
if((i__5770__auto___39654 < len__5769__auto___39653)){
args__5775__auto__.push((arguments[i__5770__auto___39654]));

var G__39655 = (i__5770__auto___39654 + (1));
i__5770__auto___39654 = G__39655;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39636){
var state_val_39637 = (state_39636[(1)]);
if((state_val_39637 === (1))){
var state_39636__$1 = state_39636;
var statearr_39638_39656 = state_39636__$1;
(statearr_39638_39656[(2)] = null);

(statearr_39638_39656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39637 === (2))){
var _ = (function (){var statearr_39639 = state_39636;
(statearr_39639[(4)] = cljs.core.cons.call(null,(5),(state_39636[(4)])));

return statearr_39639;
})();
var inst_39612 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_39636__$1 = state_39636;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39636__$1,(6),inst_39612);
} else {
if((state_val_39637 === (3))){
var inst_39634 = (state_39636[(2)]);
var state_39636__$1 = state_39636;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39636__$1,inst_39634);
} else {
if((state_val_39637 === (4))){
var inst_39606 = (state_39636[(2)]);
var state_39636__$1 = state_39636;
var statearr_39641_39657 = state_39636__$1;
(statearr_39641_39657[(2)] = inst_39606);

(statearr_39641_39657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39637 === (5))){
var _ = (function (){var statearr_39642 = state_39636;
(statearr_39642[(4)] = cljs.core.rest.call(null,(state_39636[(4)])));

return statearr_39642;
})();
var state_39636__$1 = state_39636;
var ex39640 = (state_39636__$1[(2)]);
var statearr_39643_39658 = state_39636__$1;
(statearr_39643_39658[(5)] = ex39640);


if((ex39640 instanceof Error)){
var statearr_39644_39659 = state_39636__$1;
(statearr_39644_39659[(1)] = (4));

(statearr_39644_39659[(5)] = null);

} else {
throw ex39640;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39637 === (6))){
var inst_39614 = (state_39636[(2)]);
var inst_39615 = fluree.db.util.async.throw_err.call(null,inst_39614);
var inst_39616 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_39615);
var inst_39617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39618 = [inst_39615];
var inst_39619 = (new cljs.core.PersistentVector(null,1,(5),inst_39617,inst_39618,null));
var inst_39620 = cljs.core.count.call(null,inst_39619);
var inst_39621 = ((9) + inst_39620);
var inst_39622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39623 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39625 = [inst_39615];
var inst_39626 = (new cljs.core.PersistentVector(null,1,(5),inst_39624,inst_39625,null));
var inst_39627 = ["-",inst_39626,inst_39616];
var inst_39628 = cljs.core.PersistentHashMap.fromArrays(inst_39623,inst_39627);
var inst_39629 = [inst_39628,inst_39621];
var inst_39630 = (new cljs.core.PersistentVector(null,2,(5),inst_39622,inst_39629,null));
var inst_39631 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39630);
var _ = (function (){var statearr_39645 = state_39636;
(statearr_39645[(4)] = cljs.core.rest.call(null,(state_39636[(4)])));

return statearr_39645;
})();
var state_39636__$1 = (function (){var statearr_39646 = state_39636;
(statearr_39646[(7)] = inst_39631);

return statearr_39646;
})();
var statearr_39647_39660 = state_39636__$1;
(statearr_39647_39660[(2)] = inst_39616);

(statearr_39647_39660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_39648 = [null,null,null,null,null,null,null,null];
(statearr_39648[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_39648[(1)] = (1));

return statearr_39648;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_39636){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39636);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39649){var ex__2724__auto__ = e39649;
var statearr_39650_39661 = state_39636;
(statearr_39650_39661[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39636[(4)]))){
var statearr_39651_39662 = state_39636;
(statearr_39651_39662[(1)] = cljs.core.first.call(null,(state_39636[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39663 = state_39636;
state_39636 = G__39663;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_39636){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_39636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39652 = f__2744__auto__.call(null);
(statearr_39652[(6)] = c__2743__auto__);

return statearr_39652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq39604){
var G__39605 = cljs.core.first.call(null,seq39604);
var seq39604__$1 = cljs.core.next.call(null,seq39604);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39605,seq39604__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___39713 = arguments.length;
var i__5770__auto___39714 = (0);
while(true){
if((i__5770__auto___39714 < len__5769__auto___39713)){
args__5775__auto__.push((arguments[i__5770__auto___39714]));

var G__39715 = (i__5770__auto___39714 + (1));
i__5770__auto___39714 = G__39715;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39696){
var state_val_39697 = (state_39696[(1)]);
if((state_val_39697 === (1))){
var state_39696__$1 = state_39696;
var statearr_39698_39716 = state_39696__$1;
(statearr_39698_39716[(2)] = null);

(statearr_39698_39716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39697 === (2))){
var _ = (function (){var statearr_39699 = state_39696;
(statearr_39699[(4)] = cljs.core.cons.call(null,(5),(state_39696[(4)])));

return statearr_39699;
})();
var inst_39672 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_39696__$1 = state_39696;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39696__$1,(6),inst_39672);
} else {
if((state_val_39697 === (3))){
var inst_39694 = (state_39696[(2)]);
var state_39696__$1 = state_39696;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39696__$1,inst_39694);
} else {
if((state_val_39697 === (4))){
var inst_39666 = (state_39696[(2)]);
var state_39696__$1 = state_39696;
var statearr_39701_39717 = state_39696__$1;
(statearr_39701_39717[(2)] = inst_39666);

(statearr_39701_39717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39697 === (5))){
var _ = (function (){var statearr_39702 = state_39696;
(statearr_39702[(4)] = cljs.core.rest.call(null,(state_39696[(4)])));

return statearr_39702;
})();
var state_39696__$1 = state_39696;
var ex39700 = (state_39696__$1[(2)]);
var statearr_39703_39718 = state_39696__$1;
(statearr_39703_39718[(5)] = ex39700);


if((ex39700 instanceof Error)){
var statearr_39704_39719 = state_39696__$1;
(statearr_39704_39719[(1)] = (4));

(statearr_39704_39719[(5)] = null);

} else {
throw ex39700;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39697 === (6))){
var inst_39674 = (state_39696[(2)]);
var inst_39675 = fluree.db.util.async.throw_err.call(null,inst_39674);
var inst_39676 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_39675);
var inst_39677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39678 = [inst_39675];
var inst_39679 = (new cljs.core.PersistentVector(null,1,(5),inst_39677,inst_39678,null));
var inst_39680 = cljs.core.count.call(null,inst_39679);
var inst_39681 = ((9) + inst_39680);
var inst_39682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39683 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39685 = [inst_39675];
var inst_39686 = (new cljs.core.PersistentVector(null,1,(5),inst_39684,inst_39685,null));
var inst_39687 = ["*",inst_39686,inst_39676];
var inst_39688 = cljs.core.PersistentHashMap.fromArrays(inst_39683,inst_39687);
var inst_39689 = [inst_39688,inst_39681];
var inst_39690 = (new cljs.core.PersistentVector(null,2,(5),inst_39682,inst_39689,null));
var inst_39691 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39690);
var _ = (function (){var statearr_39705 = state_39696;
(statearr_39705[(4)] = cljs.core.rest.call(null,(state_39696[(4)])));

return statearr_39705;
})();
var state_39696__$1 = (function (){var statearr_39706 = state_39696;
(statearr_39706[(7)] = inst_39691);

return statearr_39706;
})();
var statearr_39707_39720 = state_39696__$1;
(statearr_39707_39720[(2)] = inst_39676);

(statearr_39707_39720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_39708 = [null,null,null,null,null,null,null,null];
(statearr_39708[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_39708[(1)] = (1));

return statearr_39708;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_39696){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39696);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39709){var ex__2724__auto__ = e39709;
var statearr_39710_39721 = state_39696;
(statearr_39710_39721[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39696[(4)]))){
var statearr_39711_39722 = state_39696;
(statearr_39711_39722[(1)] = cljs.core.first.call(null,(state_39696[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39723 = state_39696;
state_39696 = G__39723;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_39696){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_39696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39712 = f__2744__auto__.call(null);
(statearr_39712[(6)] = c__2743__auto__);

return statearr_39712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq39664){
var G__39665 = cljs.core.first.call(null,seq39664);
var seq39664__$1 = cljs.core.next.call(null,seq39664);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39665,seq39664__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___39773 = arguments.length;
var i__5770__auto___39774 = (0);
while(true){
if((i__5770__auto___39774 < len__5769__auto___39773)){
args__5775__auto__.push((arguments[i__5770__auto___39774]));

var G__39775 = (i__5770__auto___39774 + (1));
i__5770__auto___39774 = G__39775;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39756){
var state_val_39757 = (state_39756[(1)]);
if((state_val_39757 === (1))){
var state_39756__$1 = state_39756;
var statearr_39758_39776 = state_39756__$1;
(statearr_39758_39776[(2)] = null);

(statearr_39758_39776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39757 === (2))){
var _ = (function (){var statearr_39759 = state_39756;
(statearr_39759[(4)] = cljs.core.cons.call(null,(5),(state_39756[(4)])));

return statearr_39759;
})();
var inst_39732 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_39756__$1 = state_39756;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39756__$1,(6),inst_39732);
} else {
if((state_val_39757 === (3))){
var inst_39754 = (state_39756[(2)]);
var state_39756__$1 = state_39756;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39756__$1,inst_39754);
} else {
if((state_val_39757 === (4))){
var inst_39726 = (state_39756[(2)]);
var state_39756__$1 = state_39756;
var statearr_39761_39777 = state_39756__$1;
(statearr_39761_39777[(2)] = inst_39726);

(statearr_39761_39777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39757 === (5))){
var _ = (function (){var statearr_39762 = state_39756;
(statearr_39762[(4)] = cljs.core.rest.call(null,(state_39756[(4)])));

return statearr_39762;
})();
var state_39756__$1 = state_39756;
var ex39760 = (state_39756__$1[(2)]);
var statearr_39763_39778 = state_39756__$1;
(statearr_39763_39778[(5)] = ex39760);


if((ex39760 instanceof Error)){
var statearr_39764_39779 = state_39756__$1;
(statearr_39764_39779[(1)] = (4));

(statearr_39764_39779[(5)] = null);

} else {
throw ex39760;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39757 === (6))){
var inst_39734 = (state_39756[(2)]);
var inst_39735 = fluree.db.util.async.throw_err.call(null,inst_39734);
var inst_39736 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_39735);
var inst_39737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39738 = [inst_39735];
var inst_39739 = (new cljs.core.PersistentVector(null,1,(5),inst_39737,inst_39738,null));
var inst_39740 = cljs.core.count.call(null,inst_39739);
var inst_39741 = ((9) + inst_39740);
var inst_39742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39743 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39745 = [inst_39735];
var inst_39746 = (new cljs.core.PersistentVector(null,1,(5),inst_39744,inst_39745,null));
var inst_39747 = ["/",inst_39746,inst_39736];
var inst_39748 = cljs.core.PersistentHashMap.fromArrays(inst_39743,inst_39747);
var inst_39749 = [inst_39748,inst_39741];
var inst_39750 = (new cljs.core.PersistentVector(null,2,(5),inst_39742,inst_39749,null));
var inst_39751 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39750);
var _ = (function (){var statearr_39765 = state_39756;
(statearr_39765[(4)] = cljs.core.rest.call(null,(state_39756[(4)])));

return statearr_39765;
})();
var state_39756__$1 = (function (){var statearr_39766 = state_39756;
(statearr_39766[(7)] = inst_39751);

return statearr_39766;
})();
var statearr_39767_39780 = state_39756__$1;
(statearr_39767_39780[(2)] = inst_39736);

(statearr_39767_39780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_39768 = [null,null,null,null,null,null,null,null];
(statearr_39768[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_39768[(1)] = (1));

return statearr_39768;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_39756){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39756);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39769){var ex__2724__auto__ = e39769;
var statearr_39770_39781 = state_39756;
(statearr_39770_39781[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39756[(4)]))){
var statearr_39771_39782 = state_39756;
(statearr_39771_39782[(1)] = cljs.core.first.call(null,(state_39756[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39783 = state_39756;
state_39756 = G__39783;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_39756){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_39756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39772 = f__2744__auto__.call(null);
(statearr_39772[(6)] = c__2743__auto__);

return statearr_39772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq39724){
var G__39725 = cljs.core.first.call(null,seq39724);
var seq39724__$1 = cljs.core.next.call(null,seq39724);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39725,seq39724__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39821){
var state_val_39822 = (state_39821[(1)]);
if((state_val_39822 === (7))){
var state_39821__$1 = state_39821;
var statearr_39823_39847 = state_39821__$1;
(statearr_39823_39847[(2)] = n);

(statearr_39823_39847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39822 === (1))){
var state_39821__$1 = state_39821;
var statearr_39824_39848 = state_39821__$1;
(statearr_39824_39848[(2)] = null);

(statearr_39824_39848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39822 === (4))){
var inst_39784 = (state_39821[(2)]);
var state_39821__$1 = state_39821;
var statearr_39825_39849 = state_39821__$1;
(statearr_39825_39849[(2)] = inst_39784);

(statearr_39825_39849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39822 === (13))){
var inst_39801 = (state_39821[(2)]);
var inst_39802 = fluree.db.util.async.throw_err.call(null,inst_39801);
var state_39821__$1 = state_39821;
var statearr_39826_39850 = state_39821__$1;
(statearr_39826_39850[(2)] = inst_39802);

(statearr_39826_39850[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39822 === (6))){
var state_39821__$1 = state_39821;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39821__$1,(9),n);
} else {
if((state_val_39822 === (3))){
var inst_39819 = (state_39821[(2)]);
var state_39821__$1 = state_39821;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39821__$1,inst_39819);
} else {
if((state_val_39822 === (12))){
var inst_39797 = (state_39821[(7)]);
var inst_39805 = (state_39821[(2)]);
var inst_39806 = fluree.db.dbfunctions.internal.quot.call(null,inst_39797,inst_39805);
var inst_39807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39808 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39810 = [inst_39797,inst_39805];
var inst_39811 = (new cljs.core.PersistentVector(null,2,(5),inst_39809,inst_39810,null));
var inst_39812 = ["quot",inst_39811,inst_39806];
var inst_39813 = cljs.core.PersistentHashMap.fromArrays(inst_39808,inst_39812);
var inst_39814 = [inst_39813,(2)];
var inst_39815 = (new cljs.core.PersistentVector(null,2,(5),inst_39807,inst_39814,null));
var inst_39816 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39815);
var _ = (function (){var statearr_39827 = state_39821;
(statearr_39827[(4)] = cljs.core.rest.call(null,(state_39821[(4)])));

return statearr_39827;
})();
var state_39821__$1 = (function (){var statearr_39828 = state_39821;
(statearr_39828[(8)] = inst_39816);

return statearr_39828;
})();
var statearr_39829_39851 = state_39821__$1;
(statearr_39829_39851[(2)] = inst_39806);

(statearr_39829_39851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39822 === (2))){
var _ = (function (){var statearr_39830 = state_39821;
(statearr_39830[(4)] = cljs.core.cons.call(null,(5),(state_39821[(4)])));

return statearr_39830;
})();
var inst_39790 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_39821__$1 = state_39821;
if(inst_39790){
var statearr_39831_39852 = state_39821__$1;
(statearr_39831_39852[(1)] = (6));

} else {
var statearr_39832_39853 = state_39821__$1;
(statearr_39832_39853[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39822 === (11))){
var state_39821__$1 = state_39821;
var statearr_39834_39854 = state_39821__$1;
(statearr_39834_39854[(2)] = d);

(statearr_39834_39854[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39822 === (9))){
var inst_39793 = (state_39821[(2)]);
var inst_39794 = fluree.db.util.async.throw_err.call(null,inst_39793);
var state_39821__$1 = state_39821;
var statearr_39835_39855 = state_39821__$1;
(statearr_39835_39855[(2)] = inst_39794);

(statearr_39835_39855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39822 === (5))){
var _ = (function (){var statearr_39836 = state_39821;
(statearr_39836[(4)] = cljs.core.rest.call(null,(state_39821[(4)])));

return statearr_39836;
})();
var state_39821__$1 = state_39821;
var ex39833 = (state_39821__$1[(2)]);
var statearr_39837_39856 = state_39821__$1;
(statearr_39837_39856[(5)] = ex39833);


if((ex39833 instanceof Error)){
var statearr_39838_39857 = state_39821__$1;
(statearr_39838_39857[(1)] = (4));

(statearr_39838_39857[(5)] = null);

} else {
throw ex39833;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39822 === (10))){
var state_39821__$1 = state_39821;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39821__$1,(13),d);
} else {
if((state_val_39822 === (8))){
var inst_39797 = (state_39821[(2)]);
var inst_39798 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_39821__$1 = (function (){var statearr_39839 = state_39821;
(statearr_39839[(7)] = inst_39797);

return statearr_39839;
})();
if(inst_39798){
var statearr_39840_39858 = state_39821__$1;
(statearr_39840_39858[(1)] = (10));

} else {
var statearr_39841_39859 = state_39821__$1;
(statearr_39841_39859[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto____0 = (function (){
var statearr_39842 = [null,null,null,null,null,null,null,null,null];
(statearr_39842[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto__);

(statearr_39842[(1)] = (1));

return statearr_39842;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto____1 = (function (state_39821){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39821);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39843){var ex__2724__auto__ = e39843;
var statearr_39844_39860 = state_39821;
(statearr_39844_39860[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39821[(4)]))){
var statearr_39845_39861 = state_39821;
(statearr_39845_39861[(1)] = cljs.core.first.call(null,(state_39821[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39862 = state_39821;
state_39821 = G__39862;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto__ = function(state_39821){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto____1.call(this,state_39821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39846 = f__2744__auto__.call(null);
(statearr_39846[(6)] = c__2743__auto__);

return statearr_39846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39900){
var state_val_39901 = (state_39900[(1)]);
if((state_val_39901 === (7))){
var state_39900__$1 = state_39900;
var statearr_39902_39926 = state_39900__$1;
(statearr_39902_39926[(2)] = n);

(statearr_39902_39926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39901 === (1))){
var state_39900__$1 = state_39900;
var statearr_39903_39927 = state_39900__$1;
(statearr_39903_39927[(2)] = null);

(statearr_39903_39927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39901 === (4))){
var inst_39863 = (state_39900[(2)]);
var state_39900__$1 = state_39900;
var statearr_39904_39928 = state_39900__$1;
(statearr_39904_39928[(2)] = inst_39863);

(statearr_39904_39928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39901 === (13))){
var inst_39880 = (state_39900[(2)]);
var inst_39881 = fluree.db.util.async.throw_err.call(null,inst_39880);
var state_39900__$1 = state_39900;
var statearr_39905_39929 = state_39900__$1;
(statearr_39905_39929[(2)] = inst_39881);

(statearr_39905_39929[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39901 === (6))){
var state_39900__$1 = state_39900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39900__$1,(9),n);
} else {
if((state_val_39901 === (3))){
var inst_39898 = (state_39900[(2)]);
var state_39900__$1 = state_39900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39900__$1,inst_39898);
} else {
if((state_val_39901 === (12))){
var inst_39876 = (state_39900[(7)]);
var inst_39884 = (state_39900[(2)]);
var inst_39885 = fluree.db.dbfunctions.internal.mod.call(null,inst_39876,inst_39884);
var inst_39886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39887 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39889 = [inst_39876,inst_39884];
var inst_39890 = (new cljs.core.PersistentVector(null,2,(5),inst_39888,inst_39889,null));
var inst_39891 = ["mod",inst_39890,inst_39885];
var inst_39892 = cljs.core.PersistentHashMap.fromArrays(inst_39887,inst_39891);
var inst_39893 = [inst_39892,(2)];
var inst_39894 = (new cljs.core.PersistentVector(null,2,(5),inst_39886,inst_39893,null));
var inst_39895 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39894);
var _ = (function (){var statearr_39906 = state_39900;
(statearr_39906[(4)] = cljs.core.rest.call(null,(state_39900[(4)])));

return statearr_39906;
})();
var state_39900__$1 = (function (){var statearr_39907 = state_39900;
(statearr_39907[(8)] = inst_39895);

return statearr_39907;
})();
var statearr_39908_39930 = state_39900__$1;
(statearr_39908_39930[(2)] = inst_39885);

(statearr_39908_39930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39901 === (2))){
var _ = (function (){var statearr_39909 = state_39900;
(statearr_39909[(4)] = cljs.core.cons.call(null,(5),(state_39900[(4)])));

return statearr_39909;
})();
var inst_39869 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_39900__$1 = state_39900;
if(inst_39869){
var statearr_39910_39931 = state_39900__$1;
(statearr_39910_39931[(1)] = (6));

} else {
var statearr_39911_39932 = state_39900__$1;
(statearr_39911_39932[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39901 === (11))){
var state_39900__$1 = state_39900;
var statearr_39913_39933 = state_39900__$1;
(statearr_39913_39933[(2)] = d);

(statearr_39913_39933[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39901 === (9))){
var inst_39872 = (state_39900[(2)]);
var inst_39873 = fluree.db.util.async.throw_err.call(null,inst_39872);
var state_39900__$1 = state_39900;
var statearr_39914_39934 = state_39900__$1;
(statearr_39914_39934[(2)] = inst_39873);

(statearr_39914_39934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39901 === (5))){
var _ = (function (){var statearr_39915 = state_39900;
(statearr_39915[(4)] = cljs.core.rest.call(null,(state_39900[(4)])));

return statearr_39915;
})();
var state_39900__$1 = state_39900;
var ex39912 = (state_39900__$1[(2)]);
var statearr_39916_39935 = state_39900__$1;
(statearr_39916_39935[(5)] = ex39912);


if((ex39912 instanceof Error)){
var statearr_39917_39936 = state_39900__$1;
(statearr_39917_39936[(1)] = (4));

(statearr_39917_39936[(5)] = null);

} else {
throw ex39912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39901 === (10))){
var state_39900__$1 = state_39900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39900__$1,(13),d);
} else {
if((state_val_39901 === (8))){
var inst_39876 = (state_39900[(2)]);
var inst_39877 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_39900__$1 = (function (){var statearr_39918 = state_39900;
(statearr_39918[(7)] = inst_39876);

return statearr_39918;
})();
if(inst_39877){
var statearr_39919_39937 = state_39900__$1;
(statearr_39919_39937[(1)] = (10));

} else {
var statearr_39920_39938 = state_39900__$1;
(statearr_39920_39938[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto____0 = (function (){
var statearr_39921 = [null,null,null,null,null,null,null,null,null];
(statearr_39921[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto__);

(statearr_39921[(1)] = (1));

return statearr_39921;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto____1 = (function (state_39900){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e39922){var ex__2724__auto__ = e39922;
var statearr_39923_39939 = state_39900;
(statearr_39923_39939[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39900[(4)]))){
var statearr_39924_39940 = state_39900;
(statearr_39924_39940[(1)] = cljs.core.first.call(null,(state_39900[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39941 = state_39900;
state_39900 = G__39941;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto__ = function(state_39900){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto____1.call(this,state_39900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_39925 = f__2744__auto__.call(null);
(statearr_39925[(6)] = c__2743__auto__);

return statearr_39925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_39979){
var state_val_39980 = (state_39979[(1)]);
if((state_val_39980 === (7))){
var state_39979__$1 = state_39979;
var statearr_39981_40005 = state_39979__$1;
(statearr_39981_40005[(2)] = n);

(statearr_39981_40005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39980 === (1))){
var state_39979__$1 = state_39979;
var statearr_39982_40006 = state_39979__$1;
(statearr_39982_40006[(2)] = null);

(statearr_39982_40006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39980 === (4))){
var inst_39942 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
var statearr_39983_40007 = state_39979__$1;
(statearr_39983_40007[(2)] = inst_39942);

(statearr_39983_40007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39980 === (13))){
var inst_39959 = (state_39979[(2)]);
var inst_39960 = fluree.db.util.async.throw_err.call(null,inst_39959);
var state_39979__$1 = state_39979;
var statearr_39984_40008 = state_39979__$1;
(statearr_39984_40008[(2)] = inst_39960);

(statearr_39984_40008[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39980 === (6))){
var state_39979__$1 = state_39979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39979__$1,(9),n);
} else {
if((state_val_39980 === (3))){
var inst_39977 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39979__$1,inst_39977);
} else {
if((state_val_39980 === (12))){
var inst_39955 = (state_39979[(7)]);
var inst_39963 = (state_39979[(2)]);
var inst_39964 = fluree.db.dbfunctions.internal.rem.call(null,inst_39955,inst_39963);
var inst_39965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39966 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_39967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39968 = [inst_39955,inst_39963];
var inst_39969 = (new cljs.core.PersistentVector(null,2,(5),inst_39967,inst_39968,null));
var inst_39970 = ["rem",inst_39969,inst_39964];
var inst_39971 = cljs.core.PersistentHashMap.fromArrays(inst_39966,inst_39970);
var inst_39972 = [inst_39971,(2)];
var inst_39973 = (new cljs.core.PersistentVector(null,2,(5),inst_39965,inst_39972,null));
var inst_39974 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_39973);
var _ = (function (){var statearr_39985 = state_39979;
(statearr_39985[(4)] = cljs.core.rest.call(null,(state_39979[(4)])));

return statearr_39985;
})();
var state_39979__$1 = (function (){var statearr_39986 = state_39979;
(statearr_39986[(8)] = inst_39974);

return statearr_39986;
})();
var statearr_39987_40009 = state_39979__$1;
(statearr_39987_40009[(2)] = inst_39964);

(statearr_39987_40009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39980 === (2))){
var _ = (function (){var statearr_39988 = state_39979;
(statearr_39988[(4)] = cljs.core.cons.call(null,(5),(state_39979[(4)])));

return statearr_39988;
})();
var inst_39948 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_39979__$1 = state_39979;
if(inst_39948){
var statearr_39989_40010 = state_39979__$1;
(statearr_39989_40010[(1)] = (6));

} else {
var statearr_39990_40011 = state_39979__$1;
(statearr_39990_40011[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39980 === (11))){
var state_39979__$1 = state_39979;
var statearr_39992_40012 = state_39979__$1;
(statearr_39992_40012[(2)] = d);

(statearr_39992_40012[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39980 === (9))){
var inst_39951 = (state_39979[(2)]);
var inst_39952 = fluree.db.util.async.throw_err.call(null,inst_39951);
var state_39979__$1 = state_39979;
var statearr_39993_40013 = state_39979__$1;
(statearr_39993_40013[(2)] = inst_39952);

(statearr_39993_40013[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39980 === (5))){
var _ = (function (){var statearr_39994 = state_39979;
(statearr_39994[(4)] = cljs.core.rest.call(null,(state_39979[(4)])));

return statearr_39994;
})();
var state_39979__$1 = state_39979;
var ex39991 = (state_39979__$1[(2)]);
var statearr_39995_40014 = state_39979__$1;
(statearr_39995_40014[(5)] = ex39991);


if((ex39991 instanceof Error)){
var statearr_39996_40015 = state_39979__$1;
(statearr_39996_40015[(1)] = (4));

(statearr_39996_40015[(5)] = null);

} else {
throw ex39991;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39980 === (10))){
var state_39979__$1 = state_39979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39979__$1,(13),d);
} else {
if((state_val_39980 === (8))){
var inst_39955 = (state_39979[(2)]);
var inst_39956 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_39979__$1 = (function (){var statearr_39997 = state_39979;
(statearr_39997[(7)] = inst_39955);

return statearr_39997;
})();
if(inst_39956){
var statearr_39998_40016 = state_39979__$1;
(statearr_39998_40016[(1)] = (10));

} else {
var statearr_39999_40017 = state_39979__$1;
(statearr_39999_40017[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto____0 = (function (){
var statearr_40000 = [null,null,null,null,null,null,null,null,null];
(statearr_40000[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto__);

(statearr_40000[(1)] = (1));

return statearr_40000;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto____1 = (function (state_39979){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_39979);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40001){var ex__2724__auto__ = e40001;
var statearr_40002_40018 = state_39979;
(statearr_40002_40018[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_39979[(4)]))){
var statearr_40003_40019 = state_39979;
(statearr_40003_40019[(1)] = cljs.core.first.call(null,(state_39979[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40020 = state_39979;
state_39979 = G__40020;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto__ = function(state_39979){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto____1.call(this,state_39979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40004 = f__2744__auto__.call(null);
(statearr_40004[(6)] = c__2743__auto__);

return statearr_40004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_40047){
var state_val_40048 = (state_40047[(1)]);
if((state_val_40048 === (7))){
var state_40047__$1 = state_40047;
var statearr_40049_40068 = state_40047__$1;
(statearr_40049_40068[(2)] = x);

(statearr_40049_40068[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40048 === (1))){
var state_40047__$1 = state_40047;
var statearr_40050_40069 = state_40047__$1;
(statearr_40050_40069[(2)] = null);

(statearr_40050_40069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40048 === (4))){
var inst_40021 = (state_40047[(2)]);
var state_40047__$1 = state_40047;
var statearr_40051_40070 = state_40047__$1;
(statearr_40051_40070[(2)] = inst_40021);

(statearr_40051_40070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40048 === (6))){
var state_40047__$1 = state_40047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40047__$1,(9),x);
} else {
if((state_val_40048 === (3))){
var inst_40045 = (state_40047[(2)]);
var state_40047__$1 = state_40047;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40047__$1,inst_40045);
} else {
if((state_val_40048 === (2))){
var _ = (function (){var statearr_40053 = state_40047;
(statearr_40053[(4)] = cljs.core.cons.call(null,(5),(state_40047[(4)])));

return statearr_40053;
})();
var inst_40027 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_40047__$1 = state_40047;
if(inst_40027){
var statearr_40054_40071 = state_40047__$1;
(statearr_40054_40071[(1)] = (6));

} else {
var statearr_40055_40072 = state_40047__$1;
(statearr_40055_40072[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40048 === (9))){
var inst_40030 = (state_40047[(2)]);
var inst_40031 = fluree.db.util.async.throw_err.call(null,inst_40030);
var state_40047__$1 = state_40047;
var statearr_40056_40073 = state_40047__$1;
(statearr_40056_40073[(2)] = inst_40031);

(statearr_40056_40073[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40048 === (5))){
var _ = (function (){var statearr_40057 = state_40047;
(statearr_40057[(4)] = cljs.core.rest.call(null,(state_40047[(4)])));

return statearr_40057;
})();
var state_40047__$1 = state_40047;
var ex40052 = (state_40047__$1[(2)]);
var statearr_40058_40074 = state_40047__$1;
(statearr_40058_40074[(5)] = ex40052);


if((ex40052 instanceof Error)){
var statearr_40059_40075 = state_40047__$1;
(statearr_40059_40075[(1)] = (4));

(statearr_40059_40075[(5)] = null);

} else {
throw ex40052;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40048 === (8))){
var inst_40034 = (state_40047[(2)]);
var inst_40035 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_40034);
var inst_40036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40037 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_40038 = ["boolean",inst_40034,inst_40035];
var inst_40039 = cljs.core.PersistentHashMap.fromArrays(inst_40037,inst_40038);
var inst_40040 = [inst_40039,(10)];
var inst_40041 = (new cljs.core.PersistentVector(null,2,(5),inst_40036,inst_40040,null));
var inst_40042 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_40041);
var _ = (function (){var statearr_40060 = state_40047;
(statearr_40060[(4)] = cljs.core.rest.call(null,(state_40047[(4)])));

return statearr_40060;
})();
var state_40047__$1 = (function (){var statearr_40061 = state_40047;
(statearr_40061[(7)] = inst_40042);

return statearr_40061;
})();
var statearr_40062_40076 = state_40047__$1;
(statearr_40062_40076[(2)] = inst_40035);

(statearr_40062_40076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto____0 = (function (){
var statearr_40063 = [null,null,null,null,null,null,null,null];
(statearr_40063[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto__);

(statearr_40063[(1)] = (1));

return statearr_40063;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto____1 = (function (state_40047){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_40047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40064){var ex__2724__auto__ = e40064;
var statearr_40065_40077 = state_40047;
(statearr_40065_40077[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_40047[(4)]))){
var statearr_40066_40078 = state_40047;
(statearr_40066_40078[(1)] = cljs.core.first.call(null,(state_40047[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40079 = state_40047;
state_40047 = G__40079;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto__ = function(state_40047){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto____1.call(this,state_40047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40067 = f__2744__auto__.call(null);
(statearr_40067[(6)] = c__2743__auto__);

return statearr_40067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_40117){
var state_val_40118 = (state_40117[(1)]);
if((state_val_40118 === (7))){
var state_40117__$1 = state_40117;
var statearr_40119_40143 = state_40117__$1;
(statearr_40119_40143[(2)] = pattern);

(statearr_40119_40143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40118 === (1))){
var state_40117__$1 = state_40117;
var statearr_40120_40144 = state_40117__$1;
(statearr_40120_40144[(2)] = null);

(statearr_40120_40144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40118 === (4))){
var inst_40080 = (state_40117[(2)]);
var state_40117__$1 = state_40117;
var statearr_40121_40145 = state_40117__$1;
(statearr_40121_40145[(2)] = inst_40080);

(statearr_40121_40145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40118 === (13))){
var inst_40097 = (state_40117[(2)]);
var inst_40098 = fluree.db.util.async.throw_err.call(null,inst_40097);
var state_40117__$1 = state_40117;
var statearr_40122_40146 = state_40117__$1;
(statearr_40122_40146[(2)] = inst_40098);

(statearr_40122_40146[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40118 === (6))){
var state_40117__$1 = state_40117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40117__$1,(9),pattern);
} else {
if((state_val_40118 === (3))){
var inst_40115 = (state_40117[(2)]);
var state_40117__$1 = state_40117;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40117__$1,inst_40115);
} else {
if((state_val_40118 === (12))){
var inst_40093 = (state_40117[(7)]);
var inst_40101 = (state_40117[(2)]);
var inst_40102 = fluree.db.dbfunctions.internal.re_find.call(null,inst_40093,inst_40101);
var inst_40103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40104 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_40105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40106 = [inst_40093,inst_40101];
var inst_40107 = (new cljs.core.PersistentVector(null,2,(5),inst_40105,inst_40106,null));
var inst_40108 = ["re-find",inst_40107,inst_40102];
var inst_40109 = cljs.core.PersistentHashMap.fromArrays(inst_40104,inst_40108);
var inst_40110 = [inst_40109,(10)];
var inst_40111 = (new cljs.core.PersistentVector(null,2,(5),inst_40103,inst_40110,null));
var inst_40112 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_40111);
var _ = (function (){var statearr_40123 = state_40117;
(statearr_40123[(4)] = cljs.core.rest.call(null,(state_40117[(4)])));

return statearr_40123;
})();
var state_40117__$1 = (function (){var statearr_40124 = state_40117;
(statearr_40124[(8)] = inst_40112);

return statearr_40124;
})();
var statearr_40125_40147 = state_40117__$1;
(statearr_40125_40147[(2)] = inst_40102);

(statearr_40125_40147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40118 === (2))){
var _ = (function (){var statearr_40126 = state_40117;
(statearr_40126[(4)] = cljs.core.cons.call(null,(5),(state_40117[(4)])));

return statearr_40126;
})();
var inst_40086 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_40117__$1 = state_40117;
if(inst_40086){
var statearr_40127_40148 = state_40117__$1;
(statearr_40127_40148[(1)] = (6));

} else {
var statearr_40128_40149 = state_40117__$1;
(statearr_40128_40149[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40118 === (11))){
var state_40117__$1 = state_40117;
var statearr_40130_40150 = state_40117__$1;
(statearr_40130_40150[(2)] = string);

(statearr_40130_40150[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40118 === (9))){
var inst_40089 = (state_40117[(2)]);
var inst_40090 = fluree.db.util.async.throw_err.call(null,inst_40089);
var state_40117__$1 = state_40117;
var statearr_40131_40151 = state_40117__$1;
(statearr_40131_40151[(2)] = inst_40090);

(statearr_40131_40151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40118 === (5))){
var _ = (function (){var statearr_40132 = state_40117;
(statearr_40132[(4)] = cljs.core.rest.call(null,(state_40117[(4)])));

return statearr_40132;
})();
var state_40117__$1 = state_40117;
var ex40129 = (state_40117__$1[(2)]);
var statearr_40133_40152 = state_40117__$1;
(statearr_40133_40152[(5)] = ex40129);


if((ex40129 instanceof Error)){
var statearr_40134_40153 = state_40117__$1;
(statearr_40134_40153[(1)] = (4));

(statearr_40134_40153[(5)] = null);

} else {
throw ex40129;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40118 === (10))){
var state_40117__$1 = state_40117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40117__$1,(13),string);
} else {
if((state_val_40118 === (8))){
var inst_40093 = (state_40117[(2)]);
var inst_40094 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_40117__$1 = (function (){var statearr_40135 = state_40117;
(statearr_40135[(7)] = inst_40093);

return statearr_40135;
})();
if(inst_40094){
var statearr_40136_40154 = state_40117__$1;
(statearr_40136_40154[(1)] = (10));

} else {
var statearr_40137_40155 = state_40117__$1;
(statearr_40137_40155[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto____0 = (function (){
var statearr_40138 = [null,null,null,null,null,null,null,null,null];
(statearr_40138[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto__);

(statearr_40138[(1)] = (1));

return statearr_40138;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto____1 = (function (state_40117){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_40117);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40139){var ex__2724__auto__ = e40139;
var statearr_40140_40156 = state_40117;
(statearr_40140_40156[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_40117[(4)]))){
var statearr_40141_40157 = state_40117;
(statearr_40141_40157[(1)] = cljs.core.first.call(null,(state_40117[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40158 = state_40117;
state_40117 = G__40158;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto__ = function(state_40117){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto____1.call(this,state_40117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40142 = f__2744__auto__.call(null);
(statearr_40142[(6)] = c__2743__auto__);

return statearr_40142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_40185){
var state_val_40186 = (state_40185[(1)]);
if((state_val_40186 === (7))){
var state_40185__$1 = state_40185;
var statearr_40187_40206 = state_40185__$1;
(statearr_40187_40206[(2)] = email);

(statearr_40187_40206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40186 === (1))){
var state_40185__$1 = state_40185;
var statearr_40188_40207 = state_40185__$1;
(statearr_40188_40207[(2)] = null);

(statearr_40188_40207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40186 === (4))){
var inst_40159 = (state_40185[(2)]);
var state_40185__$1 = state_40185;
var statearr_40189_40208 = state_40185__$1;
(statearr_40189_40208[(2)] = inst_40159);

(statearr_40189_40208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40186 === (6))){
var state_40185__$1 = state_40185;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40185__$1,(9),email);
} else {
if((state_val_40186 === (3))){
var inst_40183 = (state_40185[(2)]);
var state_40185__$1 = state_40185;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40185__$1,inst_40183);
} else {
if((state_val_40186 === (2))){
var _ = (function (){var statearr_40191 = state_40185;
(statearr_40191[(4)] = cljs.core.cons.call(null,(5),(state_40185[(4)])));

return statearr_40191;
})();
var inst_40165 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_40185__$1 = state_40185;
if(inst_40165){
var statearr_40192_40209 = state_40185__$1;
(statearr_40192_40209[(1)] = (6));

} else {
var statearr_40193_40210 = state_40185__$1;
(statearr_40193_40210[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40186 === (9))){
var inst_40168 = (state_40185[(2)]);
var inst_40169 = fluree.db.util.async.throw_err.call(null,inst_40168);
var state_40185__$1 = state_40185;
var statearr_40194_40211 = state_40185__$1;
(statearr_40194_40211[(2)] = inst_40169);

(statearr_40194_40211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40186 === (5))){
var _ = (function (){var statearr_40195 = state_40185;
(statearr_40195[(4)] = cljs.core.rest.call(null,(state_40185[(4)])));

return statearr_40195;
})();
var state_40185__$1 = state_40185;
var ex40190 = (state_40185__$1[(2)]);
var statearr_40196_40212 = state_40185__$1;
(statearr_40196_40212[(5)] = ex40190);


if((ex40190 instanceof Error)){
var statearr_40197_40213 = state_40185__$1;
(statearr_40197_40213[(1)] = (4));

(statearr_40197_40213[(5)] = null);

} else {
throw ex40190;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40186 === (8))){
var inst_40172 = (state_40185[(2)]);
var inst_40173 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_40172);
var inst_40174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40175 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_40176 = ["re-find",inst_40172,inst_40173];
var inst_40177 = cljs.core.PersistentHashMap.fromArrays(inst_40175,inst_40176);
var inst_40178 = [inst_40177,(10)];
var inst_40179 = (new cljs.core.PersistentVector(null,2,(5),inst_40174,inst_40178,null));
var inst_40180 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_40179);
var _ = (function (){var statearr_40198 = state_40185;
(statearr_40198[(4)] = cljs.core.rest.call(null,(state_40185[(4)])));

return statearr_40198;
})();
var state_40185__$1 = (function (){var statearr_40199 = state_40185;
(statearr_40199[(7)] = inst_40180);

return statearr_40199;
})();
var statearr_40200_40214 = state_40185__$1;
(statearr_40200_40214[(2)] = inst_40173);

(statearr_40200_40214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto____0 = (function (){
var statearr_40201 = [null,null,null,null,null,null,null,null];
(statearr_40201[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto__);

(statearr_40201[(1)] = (1));

return statearr_40201;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto____1 = (function (state_40185){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_40185);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40202){var ex__2724__auto__ = e40202;
var statearr_40203_40215 = state_40185;
(statearr_40203_40215[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_40185[(4)]))){
var statearr_40204_40216 = state_40185;
(statearr_40204_40216[(1)] = cljs.core.first.call(null,(state_40185[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40217 = state_40185;
state_40185 = G__40217;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto__ = function(state_40185){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto____1.call(this,state_40185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40205 = f__2744__auto__.call(null);
(statearr_40205[(6)] = c__2743__auto__);

return statearr_40205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_40264){
var state_val_40265 = (state_40264[(1)]);
if((state_val_40265 === (7))){
var inst_40234 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40264__$1 = state_40264;
if(cljs.core.truth_(inst_40234)){
var statearr_40266_40293 = state_40264__$1;
(statearr_40266_40293[(1)] = (9));

} else {
var statearr_40267_40294 = state_40264__$1;
(statearr_40267_40294[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (1))){
var state_40264__$1 = state_40264;
var statearr_40268_40295 = state_40264__$1;
(statearr_40268_40295[(2)] = null);

(statearr_40268_40295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (4))){
var inst_40218 = (state_40264[(2)]);
var state_40264__$1 = state_40264;
var statearr_40269_40296 = state_40264__$1;
(statearr_40269_40296[(2)] = inst_40218);

(statearr_40269_40296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (15))){
var inst_40245 = (state_40264[(2)]);
var state_40264__$1 = state_40264;
var statearr_40270_40297 = state_40264__$1;
(statearr_40270_40297[(2)] = inst_40245);

(statearr_40270_40297[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (13))){
var inst_40242 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_40264__$1 = state_40264;
var statearr_40271_40298 = state_40264__$1;
(statearr_40271_40298[(2)] = inst_40242);

(statearr_40271_40298[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (6))){
var inst_40229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40230 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40231 = [inst_40230,(0)];
var inst_40232 = (new cljs.core.PersistentVector(null,2,(5),inst_40229,inst_40231,null));
var state_40264__$1 = state_40264;
var statearr_40272_40299 = state_40264__$1;
(statearr_40272_40299[(2)] = inst_40232);

(statearr_40272_40299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (3))){
var inst_40262 = (state_40264[(2)]);
var state_40264__$1 = state_40264;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40264__$1,inst_40262);
} else {
if((state_val_40265 === (12))){
var inst_40238 = (state_40264[(2)]);
var inst_40239 = fluree.db.util.async.throw_err.call(null,inst_40238);
var state_40264__$1 = state_40264;
var statearr_40273_40300 = state_40264__$1;
(statearr_40273_40300[(2)] = inst_40239);

(statearr_40273_40300[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (2))){
var _ = (function (){var statearr_40274 = state_40264;
(statearr_40274[(4)] = cljs.core.cons.call(null,(5),(state_40264[(4)])));

return statearr_40274;
})();
var inst_40227 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40264__$1 = state_40264;
if(cljs.core.truth_(inst_40227)){
var statearr_40275_40301 = state_40264__$1;
(statearr_40275_40301[(1)] = (6));

} else {
var statearr_40276_40302 = state_40264__$1;
(statearr_40276_40302[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (11))){
var inst_40247 = (state_40264[(2)]);
var state_40264__$1 = state_40264;
var statearr_40278_40303 = state_40264__$1;
(statearr_40278_40303[(2)] = inst_40247);

(statearr_40278_40303[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (9))){
var inst_40236 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_40264__$1 = state_40264;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40264__$1,(12),inst_40236);
} else {
if((state_val_40265 === (5))){
var _ = (function (){var statearr_40279 = state_40264;
(statearr_40279[(4)] = cljs.core.rest.call(null,(state_40264[(4)])));

return statearr_40279;
})();
var state_40264__$1 = state_40264;
var ex40277 = (state_40264__$1[(2)]);
var statearr_40280_40304 = state_40264__$1;
(statearr_40280_40304[(5)] = ex40277);


if((ex40277 instanceof Error)){
var statearr_40281_40305 = state_40264__$1;
(statearr_40281_40305[(1)] = (4));

(statearr_40281_40305[(5)] = null);

} else {
throw ex40277;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (14))){
var state_40264__$1 = state_40264;
var statearr_40282_40306 = state_40264__$1;
(statearr_40282_40306[(2)] = null);

(statearr_40282_40306[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (10))){
var state_40264__$1 = state_40264;
var statearr_40283_40307 = state_40264__$1;
(statearr_40283_40307[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40265 === (8))){
var inst_40249 = (state_40264[(2)]);
var inst_40250 = cljs.core.nth.call(null,inst_40249,(0),null);
var inst_40251 = cljs.core.nth.call(null,inst_40249,(1),null);
var inst_40252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40253 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_40254 = ["?user_id","?ctx",inst_40250];
var inst_40255 = cljs.core.PersistentHashMap.fromArrays(inst_40253,inst_40254);
var inst_40256 = ((10) + inst_40251);
var inst_40257 = [inst_40255,inst_40256];
var inst_40258 = (new cljs.core.PersistentVector(null,2,(5),inst_40252,inst_40257,null));
var inst_40259 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_40258);
var _ = (function (){var statearr_40285 = state_40264;
(statearr_40285[(4)] = cljs.core.rest.call(null,(state_40264[(4)])));

return statearr_40285;
})();
var state_40264__$1 = (function (){var statearr_40286 = state_40264;
(statearr_40286[(7)] = inst_40259);

return statearr_40286;
})();
var statearr_40287_40308 = state_40264__$1;
(statearr_40287_40308[(2)] = inst_40250);

(statearr_40287_40308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto____0 = (function (){
var statearr_40288 = [null,null,null,null,null,null,null,null];
(statearr_40288[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto__);

(statearr_40288[(1)] = (1));

return statearr_40288;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto____1 = (function (state_40264){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_40264);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40289){var ex__2724__auto__ = e40289;
var statearr_40290_40309 = state_40264;
(statearr_40290_40309[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_40264[(4)]))){
var statearr_40291_40310 = state_40264;
(statearr_40291_40310[(1)] = cljs.core.first.call(null,(state_40264[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40311 = state_40264;
state_40264 = G__40311;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto__ = function(state_40264){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto____1.call(this,state_40264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40292 = f__2744__auto__.call(null);
(statearr_40292[(6)] = c__2743__auto__);

return statearr_40292;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_40339){
var state_val_40340 = (state_40339[(1)]);
if((state_val_40340 === (7))){
var inst_40332 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_40339__$1 = state_40339;
var statearr_40341_40360 = state_40339__$1;
(statearr_40341_40360[(2)] = inst_40332);

(statearr_40341_40360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40340 === (1))){
var state_40339__$1 = state_40339;
var statearr_40342_40361 = state_40339__$1;
(statearr_40342_40361[(2)] = null);

(statearr_40342_40361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40340 === (4))){
var inst_40312 = (state_40339[(2)]);
var state_40339__$1 = state_40339;
var statearr_40343_40362 = state_40339__$1;
(statearr_40343_40362[(2)] = inst_40312);

(statearr_40343_40362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40340 === (6))){
var inst_40320 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_40339__$1 = state_40339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40339__$1,(9),inst_40320);
} else {
if((state_val_40340 === (3))){
var inst_40337 = (state_40339[(2)]);
var state_40339__$1 = state_40339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40339__$1,inst_40337);
} else {
if((state_val_40340 === (2))){
var _ = (function (){var statearr_40345 = state_40339;
(statearr_40345[(4)] = cljs.core.cons.call(null,(5),(state_40339[(4)])));

return statearr_40345;
})();
var inst_40318 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40339__$1 = state_40339;
if(cljs.core.truth_(inst_40318)){
var statearr_40346_40363 = state_40339__$1;
(statearr_40346_40363[(1)] = (6));

} else {
var statearr_40347_40364 = state_40339__$1;
(statearr_40347_40364[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40340 === (9))){
var inst_40322 = (state_40339[(2)]);
var inst_40323 = fluree.db.util.async.throw_err.call(null,inst_40322);
var inst_40324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40325 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_40326 = ["?auth_id","?ctx",inst_40323];
var inst_40327 = cljs.core.PersistentHashMap.fromArrays(inst_40325,inst_40326);
var inst_40328 = [inst_40327,(10)];
var inst_40329 = (new cljs.core.PersistentVector(null,2,(5),inst_40324,inst_40328,null));
var inst_40330 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_40329);
var state_40339__$1 = (function (){var statearr_40348 = state_40339;
(statearr_40348[(7)] = inst_40330);

return statearr_40348;
})();
var statearr_40349_40365 = state_40339__$1;
(statearr_40349_40365[(2)] = inst_40323);

(statearr_40349_40365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40340 === (5))){
var _ = (function (){var statearr_40350 = state_40339;
(statearr_40350[(4)] = cljs.core.rest.call(null,(state_40339[(4)])));

return statearr_40350;
})();
var state_40339__$1 = state_40339;
var ex40344 = (state_40339__$1[(2)]);
var statearr_40351_40366 = state_40339__$1;
(statearr_40351_40366[(5)] = ex40344);


if((ex40344 instanceof Error)){
var statearr_40352_40367 = state_40339__$1;
(statearr_40352_40367[(1)] = (4));

(statearr_40352_40367[(5)] = null);

} else {
throw ex40344;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40340 === (8))){
var inst_40334 = (state_40339[(2)]);
var _ = (function (){var statearr_40353 = state_40339;
(statearr_40353[(4)] = cljs.core.rest.call(null,(state_40339[(4)])));

return statearr_40353;
})();
var state_40339__$1 = state_40339;
var statearr_40354_40368 = state_40339__$1;
(statearr_40354_40368[(2)] = inst_40334);

(statearr_40354_40368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto____0 = (function (){
var statearr_40355 = [null,null,null,null,null,null,null,null];
(statearr_40355[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto__);

(statearr_40355[(1)] = (1));

return statearr_40355;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto____1 = (function (state_40339){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_40339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40356){var ex__2724__auto__ = e40356;
var statearr_40357_40369 = state_40339;
(statearr_40357_40369[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_40339[(4)]))){
var statearr_40358_40370 = state_40339;
(statearr_40358_40370[(1)] = cljs.core.first.call(null,(state_40339[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40371 = state_40339;
state_40339 = G__40371;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto__ = function(state_40339){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto____1.call(this,state_40339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40359 = f__2744__auto__.call(null);
(statearr_40359[(6)] = c__2743__auto__);

return statearr_40359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__40373 = arguments.length;
switch (G__40373) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_40415){
var state_val_40416 = (state_40415[(1)]);
if((state_val_40416 === (7))){
var state_40415__$1 = state_40415;
var statearr_40417_40447 = state_40415__$1;
(statearr_40417_40447[(2)] = seed);

(statearr_40417_40447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (1))){
var state_40415__$1 = state_40415;
var statearr_40418_40448 = state_40415__$1;
(statearr_40418_40448[(2)] = null);

(statearr_40418_40448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (4))){
var inst_40374 = (state_40415[(2)]);
var state_40415__$1 = state_40415;
var statearr_40419_40449 = state_40415__$1;
(statearr_40419_40449[(2)] = inst_40374);

(statearr_40419_40449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (15))){
var state_40415__$1 = state_40415;
var statearr_40420_40450 = state_40415__$1;
(statearr_40420_40450[(2)] = (10));

(statearr_40420_40450[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (13))){
var inst_40391 = (state_40415[(2)]);
var inst_40392 = fluree.db.util.async.throw_err.call(null,inst_40391);
var state_40415__$1 = state_40415;
var statearr_40421_40451 = state_40415__$1;
(statearr_40421_40451[(2)] = inst_40392);

(statearr_40421_40451[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (6))){
var state_40415__$1 = state_40415;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40415__$1,(9),seed);
} else {
if((state_val_40416 === (3))){
var inst_40413 = (state_40415[(2)]);
var state_40415__$1 = state_40415;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40415__$1,inst_40413);
} else {
if((state_val_40416 === (12))){
var inst_40395 = (state_40415[(7)]);
var inst_40395__$1 = (state_40415[(2)]);
var state_40415__$1 = (function (){var statearr_40422 = state_40415;
(statearr_40422[(7)] = inst_40395__$1);

return statearr_40422;
})();
if(cljs.core.truth_(inst_40395__$1)){
var statearr_40423_40452 = state_40415__$1;
(statearr_40423_40452[(1)] = (14));

} else {
var statearr_40424_40453 = state_40415__$1;
(statearr_40424_40453[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (2))){
var _ = (function (){var statearr_40425 = state_40415;
(statearr_40425[(4)] = cljs.core.cons.call(null,(5),(state_40415[(4)])));

return statearr_40425;
})();
var inst_40380 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_40415__$1 = state_40415;
if(inst_40380){
var statearr_40426_40454 = state_40415__$1;
(statearr_40426_40454[(1)] = (6));

} else {
var statearr_40427_40455 = state_40415__$1;
(statearr_40427_40455[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (11))){
var state_40415__$1 = state_40415;
var statearr_40429_40456 = state_40415__$1;
(statearr_40429_40456[(2)] = max);

(statearr_40429_40456[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (9))){
var inst_40383 = (state_40415[(2)]);
var inst_40384 = fluree.db.util.async.throw_err.call(null,inst_40383);
var state_40415__$1 = state_40415;
var statearr_40430_40457 = state_40415__$1;
(statearr_40430_40457[(2)] = inst_40384);

(statearr_40430_40457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (5))){
var _ = (function (){var statearr_40431 = state_40415;
(statearr_40431[(4)] = cljs.core.rest.call(null,(state_40415[(4)])));

return statearr_40431;
})();
var state_40415__$1 = state_40415;
var ex40428 = (state_40415__$1[(2)]);
var statearr_40432_40458 = state_40415__$1;
(statearr_40432_40458[(5)] = ex40428);


if((ex40428 instanceof Error)){
var statearr_40433_40459 = state_40415__$1;
(statearr_40433_40459[(1)] = (4));

(statearr_40433_40459[(5)] = null);

} else {
throw ex40428;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (14))){
var inst_40395 = (state_40415[(7)]);
var state_40415__$1 = state_40415;
var statearr_40434_40460 = state_40415__$1;
(statearr_40434_40460[(2)] = inst_40395);

(statearr_40434_40460[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (16))){
var inst_40387 = (state_40415[(8)]);
var inst_40399 = (state_40415[(2)]);
var inst_40400 = fluree.db.dbfunctions.internal.rand.call(null,inst_40387,inst_40399);
var inst_40401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40402 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_40403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40404 = [max,seed];
var inst_40405 = (new cljs.core.PersistentVector(null,2,(5),inst_40403,inst_40404,null));
var inst_40406 = ["rand",inst_40405,inst_40400];
var inst_40407 = cljs.core.PersistentHashMap.fromArrays(inst_40402,inst_40406);
var inst_40408 = [inst_40407,(10)];
var inst_40409 = (new cljs.core.PersistentVector(null,2,(5),inst_40401,inst_40408,null));
var inst_40410 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_40409);
var _ = (function (){var statearr_40435 = state_40415;
(statearr_40435[(4)] = cljs.core.rest.call(null,(state_40415[(4)])));

return statearr_40435;
})();
var state_40415__$1 = (function (){var statearr_40436 = state_40415;
(statearr_40436[(9)] = inst_40410);

return statearr_40436;
})();
var statearr_40437_40461 = state_40415__$1;
(statearr_40437_40461[(2)] = inst_40400);

(statearr_40437_40461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40416 === (10))){
var state_40415__$1 = state_40415;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40415__$1,(13),max);
} else {
if((state_val_40416 === (8))){
var inst_40387 = (state_40415[(2)]);
var inst_40388 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_40415__$1 = (function (){var statearr_40438 = state_40415;
(statearr_40438[(8)] = inst_40387);

return statearr_40438;
})();
if(inst_40388){
var statearr_40439_40462 = state_40415__$1;
(statearr_40439_40462[(1)] = (10));

} else {
var statearr_40440_40463 = state_40415__$1;
(statearr_40440_40463[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2721__auto____0 = (function (){
var statearr_40441 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40441[(0)] = fluree$db$dbfunctions$fns$state_machine__2721__auto__);

(statearr_40441[(1)] = (1));

return statearr_40441;
});
var fluree$db$dbfunctions$fns$state_machine__2721__auto____1 = (function (state_40415){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_40415);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40442){var ex__2724__auto__ = e40442;
var statearr_40443_40464 = state_40415;
(statearr_40443_40464[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_40415[(4)]))){
var statearr_40444_40465 = state_40415;
(statearr_40444_40465[(1)] = cljs.core.first.call(null,(state_40415[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40466 = state_40415;
state_40415 = G__40466;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2721__auto__ = function(state_40415){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2721__auto____1.call(this,state_40415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40445 = f__2744__auto__.call(null);
(statearr_40445[(6)] = c__2743__auto__);

return statearr_40445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_40487){
var state_val_40488 = (state_40487[(1)]);
if((state_val_40488 === (1))){
var state_40487__$1 = state_40487;
var statearr_40489_40504 = state_40487__$1;
(statearr_40489_40504[(2)] = null);

(statearr_40489_40504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40488 === (2))){
var _ = (function (){var statearr_40490 = state_40487;
(statearr_40490[(4)] = cljs.core.cons.call(null,(5),(state_40487[(4)])));

return statearr_40490;
})();
var inst_40473 = fluree.db.util.core.random_uuid.call(null);
var inst_40474 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40473);
var inst_40475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40476 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_40477 = cljs.core.PersistentVector.EMPTY;
var inst_40478 = ["uuid",inst_40477,inst_40474];
var inst_40479 = cljs.core.PersistentHashMap.fromArrays(inst_40476,inst_40478);
var inst_40480 = [inst_40479,(10)];
var inst_40481 = (new cljs.core.PersistentVector(null,2,(5),inst_40475,inst_40480,null));
var inst_40482 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_40481);
var ___$1 = (function (){var statearr_40491 = state_40487;
(statearr_40491[(4)] = cljs.core.rest.call(null,(state_40487[(4)])));

return statearr_40491;
})();
var state_40487__$1 = (function (){var statearr_40492 = state_40487;
(statearr_40492[(7)] = inst_40482);

return statearr_40492;
})();
var statearr_40493_40505 = state_40487__$1;
(statearr_40493_40505[(2)] = inst_40474);

(statearr_40493_40505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40488 === (3))){
var inst_40485 = (state_40487[(2)]);
var state_40487__$1 = state_40487;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40487__$1,inst_40485);
} else {
if((state_val_40488 === (4))){
var inst_40467 = (state_40487[(2)]);
var state_40487__$1 = state_40487;
var statearr_40495_40506 = state_40487__$1;
(statearr_40495_40506[(2)] = inst_40467);

(statearr_40495_40506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40488 === (5))){
var _ = (function (){var statearr_40496 = state_40487;
(statearr_40496[(4)] = cljs.core.rest.call(null,(state_40487[(4)])));

return statearr_40496;
})();
var state_40487__$1 = state_40487;
var ex40494 = (state_40487__$1[(2)]);
var statearr_40497_40507 = state_40487__$1;
(statearr_40497_40507[(5)] = ex40494);


if((ex40494 instanceof Error)){
var statearr_40498_40508 = state_40487__$1;
(statearr_40498_40508[(1)] = (4));

(statearr_40498_40508[(5)] = null);

} else {
throw ex40494;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto____0 = (function (){
var statearr_40499 = [null,null,null,null,null,null,null,null];
(statearr_40499[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto__);

(statearr_40499[(1)] = (1));

return statearr_40499;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto____1 = (function (state_40487){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_40487);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40500){var ex__2724__auto__ = e40500;
var statearr_40501_40509 = state_40487;
(statearr_40501_40509[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_40487[(4)]))){
var statearr_40502_40510 = state_40487;
(statearr_40502_40510[(1)] = cljs.core.first.call(null,(state_40487[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40511 = state_40487;
state_40487 = G__40511;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto__ = function(state_40487){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto____1.call(this,state_40487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40503 = f__2744__auto__.call(null);
(statearr_40503[(6)] = c__2743__auto__);

return statearr_40503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_40541){
var state_val_40542 = (state_40541[(1)]);
if((state_val_40542 === (7))){
var state_40541__$1 = state_40541;
var statearr_40543_40562 = state_40541__$1;
(statearr_40543_40562[(2)] = num);

(statearr_40543_40562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40542 === (1))){
var state_40541__$1 = state_40541;
var statearr_40544_40563 = state_40541__$1;
(statearr_40544_40563[(2)] = null);

(statearr_40544_40563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40542 === (4))){
var inst_40512 = (state_40541[(2)]);
var state_40541__$1 = state_40541;
var statearr_40545_40564 = state_40541__$1;
(statearr_40545_40564[(2)] = inst_40512);

(statearr_40545_40564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40542 === (6))){
var state_40541__$1 = state_40541;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40541__$1,(9),num);
} else {
if((state_val_40542 === (3))){
var inst_40539 = (state_40541[(2)]);
var state_40541__$1 = state_40541;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40541__$1,inst_40539);
} else {
if((state_val_40542 === (2))){
var _ = (function (){var statearr_40547 = state_40541;
(statearr_40547[(4)] = cljs.core.cons.call(null,(5),(state_40541[(4)])));

return statearr_40547;
})();
var inst_40518 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_40541__$1 = state_40541;
if(inst_40518){
var statearr_40548_40565 = state_40541__$1;
(statearr_40548_40565[(1)] = (6));

} else {
var statearr_40549_40566 = state_40541__$1;
(statearr_40549_40566[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40542 === (9))){
var inst_40521 = (state_40541[(2)]);
var inst_40522 = fluree.db.util.async.throw_err.call(null,inst_40521);
var state_40541__$1 = state_40541;
var statearr_40550_40567 = state_40541__$1;
(statearr_40550_40567[(2)] = inst_40522);

(statearr_40550_40567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40542 === (5))){
var _ = (function (){var statearr_40551 = state_40541;
(statearr_40551[(4)] = cljs.core.rest.call(null,(state_40541[(4)])));

return statearr_40551;
})();
var state_40541__$1 = state_40541;
var ex40546 = (state_40541__$1[(2)]);
var statearr_40552_40568 = state_40541__$1;
(statearr_40552_40568[(5)] = ex40546);


if((ex40546 instanceof Error)){
var statearr_40553_40569 = state_40541__$1;
(statearr_40553_40569[(1)] = (4));

(statearr_40553_40569[(5)] = null);

} else {
throw ex40546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40542 === (8))){
var inst_40525 = (state_40541[(2)]);
var inst_40526 = fluree.db.dbfunctions.internal.ceil.call(null,inst_40525);
var inst_40527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40528 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_40529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40530 = [fluree.db.dbfunctions.fns.ceil];
var inst_40531 = (new cljs.core.PersistentVector(null,1,(5),inst_40529,inst_40530,null));
var inst_40532 = ["",inst_40531,inst_40526];
var inst_40533 = cljs.core.PersistentHashMap.fromArrays(inst_40528,inst_40532);
var inst_40534 = [inst_40533,(10)];
var inst_40535 = (new cljs.core.PersistentVector(null,2,(5),inst_40527,inst_40534,null));
var inst_40536 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_40535);
var _ = (function (){var statearr_40554 = state_40541;
(statearr_40554[(4)] = cljs.core.rest.call(null,(state_40541[(4)])));

return statearr_40554;
})();
var state_40541__$1 = (function (){var statearr_40555 = state_40541;
(statearr_40555[(7)] = inst_40536);

return statearr_40555;
})();
var statearr_40556_40570 = state_40541__$1;
(statearr_40556_40570[(2)] = inst_40526);

(statearr_40556_40570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto____0 = (function (){
var statearr_40557 = [null,null,null,null,null,null,null,null];
(statearr_40557[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto__);

(statearr_40557[(1)] = (1));

return statearr_40557;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto____1 = (function (state_40541){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_40541);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40558){var ex__2724__auto__ = e40558;
var statearr_40559_40571 = state_40541;
(statearr_40559_40571[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_40541[(4)]))){
var statearr_40560_40572 = state_40541;
(statearr_40560_40572[(1)] = cljs.core.first.call(null,(state_40541[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40573 = state_40541;
state_40541 = G__40573;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto__ = function(state_40541){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto____1.call(this,state_40541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40561 = f__2744__auto__.call(null);
(statearr_40561[(6)] = c__2743__auto__);

return statearr_40561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_40603){
var state_val_40604 = (state_40603[(1)]);
if((state_val_40604 === (7))){
var state_40603__$1 = state_40603;
var statearr_40605_40624 = state_40603__$1;
(statearr_40605_40624[(2)] = num);

(statearr_40605_40624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40604 === (1))){
var state_40603__$1 = state_40603;
var statearr_40606_40625 = state_40603__$1;
(statearr_40606_40625[(2)] = null);

(statearr_40606_40625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40604 === (4))){
var inst_40574 = (state_40603[(2)]);
var state_40603__$1 = state_40603;
var statearr_40607_40626 = state_40603__$1;
(statearr_40607_40626[(2)] = inst_40574);

(statearr_40607_40626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40604 === (6))){
var state_40603__$1 = state_40603;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40603__$1,(9),num);
} else {
if((state_val_40604 === (3))){
var inst_40601 = (state_40603[(2)]);
var state_40603__$1 = state_40603;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40603__$1,inst_40601);
} else {
if((state_val_40604 === (2))){
var _ = (function (){var statearr_40609 = state_40603;
(statearr_40609[(4)] = cljs.core.cons.call(null,(5),(state_40603[(4)])));

return statearr_40609;
})();
var inst_40580 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_40603__$1 = state_40603;
if(inst_40580){
var statearr_40610_40627 = state_40603__$1;
(statearr_40610_40627[(1)] = (6));

} else {
var statearr_40611_40628 = state_40603__$1;
(statearr_40611_40628[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40604 === (9))){
var inst_40583 = (state_40603[(2)]);
var inst_40584 = fluree.db.util.async.throw_err.call(null,inst_40583);
var state_40603__$1 = state_40603;
var statearr_40612_40629 = state_40603__$1;
(statearr_40612_40629[(2)] = inst_40584);

(statearr_40612_40629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40604 === (5))){
var _ = (function (){var statearr_40613 = state_40603;
(statearr_40613[(4)] = cljs.core.rest.call(null,(state_40603[(4)])));

return statearr_40613;
})();
var state_40603__$1 = state_40603;
var ex40608 = (state_40603__$1[(2)]);
var statearr_40614_40630 = state_40603__$1;
(statearr_40614_40630[(5)] = ex40608);


if((ex40608 instanceof Error)){
var statearr_40615_40631 = state_40603__$1;
(statearr_40615_40631[(1)] = (4));

(statearr_40615_40631[(5)] = null);

} else {
throw ex40608;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40604 === (8))){
var inst_40587 = (state_40603[(2)]);
var inst_40588 = fluree.db.dbfunctions.internal.floor.call(null,inst_40587);
var inst_40589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40590 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_40591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40592 = [fluree.db.dbfunctions.fns.floor];
var inst_40593 = (new cljs.core.PersistentVector(null,1,(5),inst_40591,inst_40592,null));
var inst_40594 = ["",inst_40593,inst_40588];
var inst_40595 = cljs.core.PersistentHashMap.fromArrays(inst_40590,inst_40594);
var inst_40596 = [inst_40595,(10)];
var inst_40597 = (new cljs.core.PersistentVector(null,2,(5),inst_40589,inst_40596,null));
var inst_40598 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_40597);
var _ = (function (){var statearr_40616 = state_40603;
(statearr_40616[(4)] = cljs.core.rest.call(null,(state_40603[(4)])));

return statearr_40616;
})();
var state_40603__$1 = (function (){var statearr_40617 = state_40603;
(statearr_40617[(7)] = inst_40598);

return statearr_40617;
})();
var statearr_40618_40632 = state_40603__$1;
(statearr_40618_40632[(2)] = inst_40588);

(statearr_40618_40632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto____0 = (function (){
var statearr_40619 = [null,null,null,null,null,null,null,null];
(statearr_40619[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto__);

(statearr_40619[(1)] = (1));

return statearr_40619;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto____1 = (function (state_40603){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_40603);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40620){var ex__2724__auto__ = e40620;
var statearr_40621_40633 = state_40603;
(statearr_40621_40633[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_40603[(4)]))){
var statearr_40622_40634 = state_40603;
(statearr_40622_40634[(1)] = cljs.core.first.call(null,(state_40603[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40635 = state_40603;
state_40603 = G__40635;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto__ = function(state_40603){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto____1.call(this,state_40603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40623 = f__2744__auto__.call(null);
(statearr_40623[(6)] = c__2743__auto__);

return statearr_40623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_40660){
var state_val_40661 = (state_40660[(1)]);
if((state_val_40661 === (1))){
var state_40660__$1 = state_40660;
var statearr_40662_40677 = state_40660__$1;
(statearr_40662_40677[(2)] = null);

(statearr_40662_40677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40661 === (2))){
var _ = (function (){var statearr_40663 = state_40660;
(statearr_40663[(4)] = cljs.core.cons.call(null,(5),(state_40660[(4)])));

return statearr_40663;
})();
var inst_40642 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_40660__$1 = state_40660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40660__$1,(6),inst_40642);
} else {
if((state_val_40661 === (3))){
var inst_40658 = (state_40660[(2)]);
var state_40660__$1 = state_40660;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40660__$1,inst_40658);
} else {
if((state_val_40661 === (4))){
var inst_40636 = (state_40660[(2)]);
var state_40660__$1 = state_40660;
var statearr_40665_40678 = state_40660__$1;
(statearr_40665_40678[(2)] = inst_40636);

(statearr_40665_40678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40661 === (5))){
var _ = (function (){var statearr_40666 = state_40660;
(statearr_40666[(4)] = cljs.core.rest.call(null,(state_40660[(4)])));

return statearr_40666;
})();
var state_40660__$1 = state_40660;
var ex40664 = (state_40660__$1[(2)]);
var statearr_40667_40679 = state_40660__$1;
(statearr_40667_40679[(5)] = ex40664);


if((ex40664 instanceof Error)){
var statearr_40668_40680 = state_40660__$1;
(statearr_40668_40680[(1)] = (4));

(statearr_40668_40680[(5)] = null);

} else {
throw ex40664;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40661 === (6))){
var inst_40644 = (state_40660[(2)]);
var inst_40645 = fluree.db.util.async.throw_err.call(null,inst_40644);
var inst_40646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40647 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_40648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40649 = [compare_val,new_val];
var inst_40650 = (new cljs.core.PersistentVector(null,2,(5),inst_40648,inst_40649,null));
var inst_40651 = ["",inst_40650,inst_40645];
var inst_40652 = cljs.core.PersistentHashMap.fromArrays(inst_40647,inst_40651);
var inst_40653 = [inst_40652,(10)];
var inst_40654 = (new cljs.core.PersistentVector(null,2,(5),inst_40646,inst_40653,null));
var inst_40655 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_40654);
var _ = (function (){var statearr_40669 = state_40660;
(statearr_40669[(4)] = cljs.core.rest.call(null,(state_40660[(4)])));

return statearr_40669;
})();
var state_40660__$1 = (function (){var statearr_40670 = state_40660;
(statearr_40670[(7)] = inst_40655);

return statearr_40670;
})();
var statearr_40671_40681 = state_40660__$1;
(statearr_40671_40681[(2)] = inst_40645);

(statearr_40671_40681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto____0 = (function (){
var statearr_40672 = [null,null,null,null,null,null,null,null];
(statearr_40672[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto__);

(statearr_40672[(1)] = (1));

return statearr_40672;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto____1 = (function (state_40660){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_40660);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e40673){var ex__2724__auto__ = e40673;
var statearr_40674_40682 = state_40660;
(statearr_40674_40682[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_40660[(4)]))){
var statearr_40675_40683 = state_40660;
(statearr_40675_40683[(1)] = cljs.core.first.call(null,(state_40660[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40684 = state_40660;
state_40660 = G__40684;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto__ = function(state_40660){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto____1.call(this,state_40660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_40676 = f__2744__auto__.call(null);
(statearr_40676[(6)] = c__2743__auto__);

return statearr_40676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
