// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__44760_44929 = cljs.core.seq.call(null,servers);
var chunk__44761_44930 = null;
var count__44762_44931 = (0);
var i__44763_44932 = (0);
while(true){
if((i__44763_44932 < count__44762_44931)){
var server_44933 = cljs.core._nth.call(null,chunk__44761_44930,i__44763_44932);
var healthcheck_uri_44934 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_44933),"/fdb/health"].join('');
var resp_chan_44935 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_44934,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2743__auto___44936 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,c__2743__auto___44936,healthcheck_uri_44934,resp_chan_44935,server_44933){
return (function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = ((function (seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,c__2743__auto___44936,healthcheck_uri_44934,resp_chan_44935,server_44933){
return (function (state_44824){
var state_val_44825 = (state_44824[(1)]);
if((state_val_44825 === (1))){
var state_44824__$1 = state_44824;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44824__$1,(2),resp_chan_44935);
} else {
if((state_val_44825 === (2))){
var inst_44813 = (state_44824[(7)]);
var inst_44813__$1 = (state_44824[(2)]);
var inst_44814 = fluree.db.util.core.exception_QMARK_.call(null,inst_44813__$1);
var state_44824__$1 = (function (){var statearr_44826 = state_44824;
(statearr_44826[(7)] = inst_44813__$1);

return statearr_44826;
})();
if(inst_44814){
var statearr_44827_44937 = state_44824__$1;
(statearr_44827_44937[(1)] = (3));

} else {
var statearr_44828_44938 = state_44824__$1;
(statearr_44828_44938[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44825 === (3))){
var inst_44813 = (state_44824[(7)]);
var inst_44816 = cljs.core.ex_message.call(null,inst_44813);
var inst_44817 = cljs.core.ex_data.call(null,inst_44813);
var inst_44818 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_44816,inst_44817);
var state_44824__$1 = state_44824;
var statearr_44829_44939 = state_44824__$1;
(statearr_44829_44939[(2)] = inst_44818);

(statearr_44829_44939[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44825 === (4))){
var inst_44820 = cljs.core.async.put_BANG_.call(null,promise_chan,server_44933);
var state_44824__$1 = state_44824;
var statearr_44830_44940 = state_44824__$1;
(statearr_44830_44940[(2)] = inst_44820);

(statearr_44830_44940[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44825 === (5))){
var inst_44822 = (state_44824[(2)]);
var state_44824__$1 = state_44824;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44824__$1,inst_44822);
} else {
return null;
}
}
}
}
}
});})(seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,c__2743__auto___44936,healthcheck_uri_44934,resp_chan_44935,server_44933))
;
return ((function (seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,switch__2720__auto__,c__2743__auto___44936,healthcheck_uri_44934,resp_chan_44935,server_44933){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____0 = (function (){
var statearr_44831 = [null,null,null,null,null,null,null,null];
(statearr_44831[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__);

(statearr_44831[(1)] = (1));

return statearr_44831;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____1 = (function (state_44824){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_44824);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e44832){var ex__2724__auto__ = e44832;
var statearr_44833_44941 = state_44824;
(statearr_44833_44941[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_44824[(4)]))){
var statearr_44834_44942 = state_44824;
(statearr_44834_44942[(1)] = cljs.core.first.call(null,(state_44824[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44943 = state_44824;
state_44824 = G__44943;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__ = function(state_44824){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____1.call(this,state_44824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__;
})()
;})(seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,switch__2720__auto__,c__2743__auto___44936,healthcheck_uri_44934,resp_chan_44935,server_44933))
})();
var state__2745__auto__ = (function (){var statearr_44835 = f__2744__auto__.call(null);
(statearr_44835[(6)] = c__2743__auto___44936);

return statearr_44835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
});})(seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,c__2743__auto___44936,healthcheck_uri_44934,resp_chan_44935,server_44933))
);



var G__44944 = seq__44760_44929;
var G__44945 = chunk__44761_44930;
var G__44946 = count__44762_44931;
var G__44947 = (i__44763_44932 + (1));
seq__44760_44929 = G__44944;
chunk__44761_44930 = G__44945;
count__44762_44931 = G__44946;
i__44763_44932 = G__44947;
continue;
} else {
var temp__5804__auto___44948 = cljs.core.seq.call(null,seq__44760_44929);
if(temp__5804__auto___44948){
var seq__44760_44949__$1 = temp__5804__auto___44948;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44760_44949__$1)){
var c__5568__auto___44950 = cljs.core.chunk_first.call(null,seq__44760_44949__$1);
var G__44951 = cljs.core.chunk_rest.call(null,seq__44760_44949__$1);
var G__44952 = c__5568__auto___44950;
var G__44953 = cljs.core.count.call(null,c__5568__auto___44950);
var G__44954 = (0);
seq__44760_44929 = G__44951;
chunk__44761_44930 = G__44952;
count__44762_44931 = G__44953;
i__44763_44932 = G__44954;
continue;
} else {
var server_44955 = cljs.core.first.call(null,seq__44760_44949__$1);
var healthcheck_uri_44956 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_44955),"/fdb/health"].join('');
var resp_chan_44957 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_44956,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2743__auto___44958 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,c__2743__auto___44958,healthcheck_uri_44956,resp_chan_44957,server_44955,seq__44760_44949__$1,temp__5804__auto___44948){
return (function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = ((function (seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,c__2743__auto___44958,healthcheck_uri_44956,resp_chan_44957,server_44955,seq__44760_44949__$1,temp__5804__auto___44948){
return (function (state_44848){
var state_val_44849 = (state_44848[(1)]);
if((state_val_44849 === (1))){
var state_44848__$1 = state_44848;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44848__$1,(2),resp_chan_44957);
} else {
if((state_val_44849 === (2))){
var inst_44837 = (state_44848[(7)]);
var inst_44837__$1 = (state_44848[(2)]);
var inst_44838 = fluree.db.util.core.exception_QMARK_.call(null,inst_44837__$1);
var state_44848__$1 = (function (){var statearr_44850 = state_44848;
(statearr_44850[(7)] = inst_44837__$1);

return statearr_44850;
})();
if(inst_44838){
var statearr_44851_44959 = state_44848__$1;
(statearr_44851_44959[(1)] = (3));

} else {
var statearr_44852_44960 = state_44848__$1;
(statearr_44852_44960[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44849 === (3))){
var inst_44837 = (state_44848[(7)]);
var inst_44840 = cljs.core.ex_message.call(null,inst_44837);
var inst_44841 = cljs.core.ex_data.call(null,inst_44837);
var inst_44842 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_44840,inst_44841);
var state_44848__$1 = state_44848;
var statearr_44853_44961 = state_44848__$1;
(statearr_44853_44961[(2)] = inst_44842);

(statearr_44853_44961[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44849 === (4))){
var inst_44844 = cljs.core.async.put_BANG_.call(null,promise_chan,server_44955);
var state_44848__$1 = state_44848;
var statearr_44854_44962 = state_44848__$1;
(statearr_44854_44962[(2)] = inst_44844);

(statearr_44854_44962[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44849 === (5))){
var inst_44846 = (state_44848[(2)]);
var state_44848__$1 = state_44848;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44848__$1,inst_44846);
} else {
return null;
}
}
}
}
}
});})(seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,c__2743__auto___44958,healthcheck_uri_44956,resp_chan_44957,server_44955,seq__44760_44949__$1,temp__5804__auto___44948))
;
return ((function (seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,switch__2720__auto__,c__2743__auto___44958,healthcheck_uri_44956,resp_chan_44957,server_44955,seq__44760_44949__$1,temp__5804__auto___44948){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____0 = (function (){
var statearr_44855 = [null,null,null,null,null,null,null,null];
(statearr_44855[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__);

(statearr_44855[(1)] = (1));

return statearr_44855;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____1 = (function (state_44848){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_44848);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e44856){var ex__2724__auto__ = e44856;
var statearr_44857_44963 = state_44848;
(statearr_44857_44963[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_44848[(4)]))){
var statearr_44858_44964 = state_44848;
(statearr_44858_44964[(1)] = cljs.core.first.call(null,(state_44848[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44965 = state_44848;
state_44848 = G__44965;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__ = function(state_44848){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____1.call(this,state_44848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__;
})()
;})(seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,switch__2720__auto__,c__2743__auto___44958,healthcheck_uri_44956,resp_chan_44957,server_44955,seq__44760_44949__$1,temp__5804__auto___44948))
})();
var state__2745__auto__ = (function (){var statearr_44859 = f__2744__auto__.call(null);
(statearr_44859[(6)] = c__2743__auto___44958);

return statearr_44859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
});})(seq__44760_44929,chunk__44761_44930,count__44762_44931,i__44763_44932,c__2743__auto___44958,healthcheck_uri_44956,resp_chan_44957,server_44955,seq__44760_44949__$1,temp__5804__auto___44948))
);



var G__44966 = cljs.core.next.call(null,seq__44760_44949__$1);
var G__44967 = null;
var G__44968 = (0);
var G__44969 = (0);
seq__44760_44929 = G__44966;
chunk__44761_44930 = G__44967;
count__44762_44931 = G__44968;
i__44763_44932 = G__44969;
continue;
}
} else {
}
}
break;
}

var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_44903){
var state_val_44904 = (state_44903[(1)]);
if((state_val_44904 === (7))){
var inst_44875 = (state_44903[(7)]);
var inst_44882 = cljs.core._EQ_.call(null,inst_44875,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_44903__$1 = state_44903;
if(inst_44882){
var statearr_44905_44970 = state_44903__$1;
(statearr_44905_44970[(1)] = (9));

} else {
var statearr_44906_44971 = state_44903__$1;
(statearr_44906_44971[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (1))){
var inst_44868 = (state_44903[(8)]);
var inst_44867 = (state_44903[(9)]);
var inst_44867__$1 = promise_chan;
var inst_44868__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_44869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44870 = [inst_44867__$1,inst_44868__$1];
var inst_44871 = (new cljs.core.PersistentVector(null,2,(5),inst_44869,inst_44870,null));
var state_44903__$1 = (function (){var statearr_44907 = state_44903;
(statearr_44907[(8)] = inst_44868__$1);

(statearr_44907[(9)] = inst_44867__$1);

return statearr_44907;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_44903__$1,(2),inst_44871);
} else {
if((state_val_44904 === (4))){
var inst_44868 = (state_44903[(8)]);
var inst_44875 = (state_44903[(7)]);
var inst_44879 = cljs.core._EQ_.call(null,inst_44875,inst_44868);
var state_44903__$1 = state_44903;
if(inst_44879){
var statearr_44908_44972 = state_44903__$1;
(statearr_44908_44972[(1)] = (6));

} else {
var statearr_44909_44973 = state_44903__$1;
(statearr_44909_44973[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (13))){
var state_44903__$1 = state_44903;
var statearr_44910_44974 = state_44903__$1;
(statearr_44910_44974[(2)] = null);

(statearr_44910_44974[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (6))){
var state_44903__$1 = state_44903;
var statearr_44911_44975 = state_44903__$1;
(statearr_44911_44975[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_44911_44975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (3))){
var state_44903__$1 = state_44903;
var statearr_44912_44976 = state_44903__$1;
(statearr_44912_44976[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_44912_44976[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (12))){
var inst_44893 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_44894 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44895 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_44896 = cljs.core.PersistentHashMap.fromArrays(inst_44894,inst_44895);
var inst_44897 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_44896);
var inst_44898 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_44897);
var state_44903__$1 = (function (){var statearr_44913 = state_44903;
(statearr_44913[(10)] = inst_44893);

return statearr_44913;
})();
var statearr_44914_44977 = state_44903__$1;
(statearr_44914_44977[(2)] = inst_44898);

(statearr_44914_44977[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (2))){
var inst_44875 = (state_44903[(7)]);
var inst_44867 = (state_44903[(9)]);
var inst_44873 = (state_44903[(2)]);
var inst_44874 = cljs.core.nth.call(null,inst_44873,(0),null);
var inst_44875__$1 = cljs.core.nth.call(null,inst_44873,(1),null);
var inst_44876 = cljs.core._EQ_.call(null,inst_44875__$1,inst_44867);
var state_44903__$1 = (function (){var statearr_44915 = state_44903;
(statearr_44915[(7)] = inst_44875__$1);

(statearr_44915[(11)] = inst_44874);

return statearr_44915;
})();
if(inst_44876){
var statearr_44916_44978 = state_44903__$1;
(statearr_44916_44978[(1)] = (3));

} else {
var statearr_44917_44979 = state_44903__$1;
(statearr_44917_44979[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (11))){
var inst_44886 = (state_44903[(2)]);
var state_44903__$1 = state_44903;
var statearr_44918_44980 = state_44903__$1;
(statearr_44918_44980[(2)] = inst_44886);

(statearr_44918_44980[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (9))){
var inst_44874 = (state_44903[(11)]);
var state_44903__$1 = state_44903;
var statearr_44919_44981 = state_44903__$1;
(statearr_44919_44981[(2)] = inst_44874);

(statearr_44919_44981[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (5))){
var inst_44890 = (state_44903[(2)]);
var inst_44891 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_44890);
var state_44903__$1 = state_44903;
if(inst_44891){
var statearr_44920_44982 = state_44903__$1;
(statearr_44920_44982[(1)] = (12));

} else {
var statearr_44921_44983 = state_44903__$1;
(statearr_44921_44983[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (14))){
var inst_44901 = (state_44903[(2)]);
var state_44903__$1 = state_44903;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44903__$1,inst_44901);
} else {
if((state_val_44904 === (10))){
var state_44903__$1 = state_44903;
var statearr_44922_44984 = state_44903__$1;
(statearr_44922_44984[(2)] = null);

(statearr_44922_44984[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44904 === (8))){
var inst_44888 = (state_44903[(2)]);
var state_44903__$1 = state_44903;
var statearr_44923_44985 = state_44903__$1;
(statearr_44923_44985[(2)] = inst_44888);

(statearr_44923_44985[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____0 = (function (){
var statearr_44924 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44924[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__);

(statearr_44924[(1)] = (1));

return statearr_44924;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____1 = (function (state_44903){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_44903);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e44925){var ex__2724__auto__ = e44925;
var statearr_44926_44986 = state_44903;
(statearr_44926_44986[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_44903[(4)]))){
var statearr_44927_44987 = state_44903;
(statearr_44927_44987[(1)] = cljs.core.first.call(null,(state_44903[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44988 = state_44903;
state_44903 = G__44988;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__ = function(state_44903){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____1.call(this,state_44903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_44928 = f__2744__auto__.call(null);
(statearr_44928[(6)] = c__2743__auto__);

return statearr_44928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_45032){
var state_val_45033 = (state_45032[(1)]);
if((state_val_45033 === (7))){
var state_45032__$1 = state_45032;
var statearr_45034_45060 = state_45032__$1;
(statearr_45034_45060[(2)] = null);

(statearr_45034_45060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45033 === (1))){
var state_45032__$1 = state_45032;
var statearr_45035_45061 = state_45032__$1;
(statearr_45035_45061[(2)] = null);

(statearr_45035_45061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45033 === (4))){
var inst_44989 = (state_45032[(2)]);
var state_45032__$1 = state_45032;
var statearr_45036_45062 = state_45032__$1;
(statearr_45036_45062[(2)] = inst_44989);

(statearr_45036_45062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45033 === (6))){
var inst_45011 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_45032__$1 = state_45032;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45032__$1,(9),inst_45011);
} else {
if((state_val_45033 === (3))){
var inst_45030 = (state_45032[(2)]);
var state_45032__$1 = state_45032;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45032__$1,inst_45030);
} else {
if((state_val_45033 === (12))){
var inst_45024 = (state_45032[(2)]);
var state_45032__$1 = state_45032;
var statearr_45037_45063 = state_45032__$1;
(statearr_45037_45063[(2)] = inst_45024);

(statearr_45037_45063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45033 === (2))){
var inst_45000 = (state_45032[(7)]);
var inst_44995 = (state_45032[(8)]);
var inst_45005 = (state_45032[(9)]);
var _ = (function (){var statearr_45038 = state_45032;
(statearr_45038[(4)] = cljs.core.cons.call(null,(5),(state_45032[(4)])));

return statearr_45038;
})();
var inst_44995__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_44996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44997 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_44998 = (new cljs.core.PersistentVector(null,2,(5),inst_44996,inst_44997,null));
var inst_44999 = (function (){var lock_id = inst_44995__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_45000__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_44998,inst_44999);
var inst_45001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45002 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_45003 = (new cljs.core.PersistentVector(null,3,(5),inst_45001,inst_45002,null));
var inst_45004 = cljs.core.get_in.call(null,inst_45000__$1,inst_45003);
var inst_45005__$1 = cljs.core._EQ_.call(null,inst_44995__$1,inst_45004);
var inst_45006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45007 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_45008 = (new cljs.core.PersistentVector(null,3,(5),inst_45006,inst_45007,null));
var inst_45009 = cljs.core.get_in.call(null,inst_45000__$1,inst_45008);
var state_45032__$1 = (function (){var statearr_45039 = state_45032;
(statearr_45039[(7)] = inst_45000__$1);

(statearr_45039[(8)] = inst_44995__$1);

(statearr_45039[(10)] = inst_45009);

(statearr_45039[(9)] = inst_45005__$1);

return statearr_45039;
})();
if(inst_45005__$1){
var statearr_45040_45064 = state_45032__$1;
(statearr_45040_45064[(1)] = (6));

} else {
var statearr_45041_45065 = state_45032__$1;
(statearr_45041_45065[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45033 === (11))){
var inst_45009 = (state_45032[(10)]);
var inst_45015 = (state_45032[(11)]);
var inst_45016 = (state_45032[(12)]);
var inst_45022 = fluree.db.util.xhttp.try_socket.call(null,inst_45015,sub_chan,pub_chan,inst_45009,(60000),inst_45016);
var state_45032__$1 = state_45032;
var statearr_45043_45066 = state_45032__$1;
(statearr_45043_45066[(2)] = inst_45022);

(statearr_45043_45066[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45033 === (9))){
var inst_45000 = (state_45032[(7)]);
var inst_44995 = (state_45032[(8)]);
var inst_45009 = (state_45032[(10)]);
var inst_45005 = (state_45032[(9)]);
var inst_45015 = (state_45032[(11)]);
var inst_45013 = (state_45032[(13)]);
var inst_45013__$1 = (state_45032[(2)]);
var inst_45014 = clojure.string.replace.call(null,inst_45013__$1,"http","ws");
var inst_45015__$1 = [inst_45014,"/fdb/ws"].join('');
var inst_45016 = (function (){var lock_id = inst_44995;
var state = inst_45000;
var have_lock_QMARK_ = inst_45005;
var resp_chan = inst_45009;
var healthy_server = inst_45013__$1;
var ws_url = inst_45015__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_45017 = fluree.db.util.core.exception_QMARK_.call(null,inst_45013__$1);
var state_45032__$1 = (function (){var statearr_45044 = state_45032;
(statearr_45044[(11)] = inst_45015__$1);

(statearr_45044[(13)] = inst_45013__$1);

(statearr_45044[(12)] = inst_45016);

return statearr_45044;
})();
if(inst_45017){
var statearr_45045_45067 = state_45032__$1;
(statearr_45045_45067[(1)] = (10));

} else {
var statearr_45046_45068 = state_45032__$1;
(statearr_45046_45068[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45033 === (5))){
var _ = (function (){var statearr_45047 = state_45032;
(statearr_45047[(4)] = cljs.core.rest.call(null,(state_45032[(4)])));

return statearr_45047;
})();
var state_45032__$1 = state_45032;
var ex45042 = (state_45032__$1[(2)]);
var statearr_45048_45069 = state_45032__$1;
(statearr_45048_45069[(5)] = ex45042);


if((ex45042 instanceof Error)){
var statearr_45049_45070 = state_45032__$1;
(statearr_45049_45070[(1)] = (4));

(statearr_45049_45070[(5)] = null);

} else {
throw ex45042;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45033 === (10))){
var inst_45009 = (state_45032[(10)]);
var inst_45013 = (state_45032[(13)]);
var inst_45019 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_45020 = cljs.core.async.put_BANG_.call(null,inst_45009,inst_45013);
var state_45032__$1 = (function (){var statearr_45050 = state_45032;
(statearr_45050[(14)] = inst_45019);

return statearr_45050;
})();
var statearr_45051_45071 = state_45032__$1;
(statearr_45051_45071[(2)] = inst_45020);

(statearr_45051_45071[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45033 === (8))){
var inst_45009 = (state_45032[(10)]);
var inst_45027 = (state_45032[(2)]);
var _ = (function (){var statearr_45052 = state_45032;
(statearr_45052[(4)] = cljs.core.rest.call(null,(state_45032[(4)])));

return statearr_45052;
})();
var state_45032__$1 = (function (){var statearr_45053 = state_45032;
(statearr_45053[(15)] = inst_45027);

return statearr_45053;
})();
var statearr_45054_45072 = state_45032__$1;
(statearr_45054_45072[(2)] = inst_45009);

(statearr_45054_45072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2721__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2721__auto____0 = (function (){
var statearr_45055 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45055[(0)] = fluree$db$connection$establish_socket_$_state_machine__2721__auto__);

(statearr_45055[(1)] = (1));

return statearr_45055;
});
var fluree$db$connection$establish_socket_$_state_machine__2721__auto____1 = (function (state_45032){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_45032);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e45056){var ex__2724__auto__ = e45056;
var statearr_45057_45073 = state_45032;
(statearr_45057_45073[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_45032[(4)]))){
var statearr_45058_45074 = state_45032;
(statearr_45058_45074[(1)] = cljs.core.first.call(null,(state_45032[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45075 = state_45032;
state_45032 = G__45075;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2721__auto__ = function(state_45032){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2721__auto____1.call(this,state_45032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2721__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2721__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_45059 = f__2744__auto__.call(null);
(statearr_45059[(6)] = c__2743__auto__);

return statearr_45059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k45077,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__45081 = k45077;
var G__45081__$1 = (((G__45081 instanceof cljs.core.Keyword))?G__45081.fqn:null);
switch (G__45081__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k45077,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__45082){
var vec__45083 = p__45082;
var k__5367__auto__ = cljs.core.nth.call(null,vec__45083,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__45083,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__45076){
var self__ = this;
var G__45076__$1 = this;
return (new cljs.core.RecordIter((0),G__45076__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (22 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this45078,other45079){
var self__ = this;
var this45078__$1 = this;
return (((!((other45079 == null)))) && ((((this45078__$1.constructor === other45079.constructor)) && (((cljs.core._EQ_.call(null,this45078__$1.id,other45079.id)) && (((cljs.core._EQ_.call(null,this45078__$1.servers,other45079.servers)) && (((cljs.core._EQ_.call(null,this45078__$1.state,other45079.state)) && (((cljs.core._EQ_.call(null,this45078__$1.req_chan,other45079.req_chan)) && (((cljs.core._EQ_.call(null,this45078__$1.sub_chan,other45079.sub_chan)) && (((cljs.core._EQ_.call(null,this45078__$1.pub_chan,other45079.pub_chan)) && (((cljs.core._EQ_.call(null,this45078__$1.group,other45079.group)) && (((cljs.core._EQ_.call(null,this45078__$1.storage_read,other45079.storage_read)) && (((cljs.core._EQ_.call(null,this45078__$1.storage_write,other45079.storage_write)) && (((cljs.core._EQ_.call(null,this45078__$1.object_cache,other45079.object_cache)) && (((cljs.core._EQ_.call(null,this45078__$1.parallelism,other45079.parallelism)) && (((cljs.core._EQ_.call(null,this45078__$1.serializer,other45079.serializer)) && (((cljs.core._EQ_.call(null,this45078__$1.default_network,other45079.default_network)) && (((cljs.core._EQ_.call(null,this45078__$1.transactor_QMARK_,other45079.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this45078__$1.publish,other45079.publish)) && (((cljs.core._EQ_.call(null,this45078__$1.transact_handler,other45079.transact_handler)) && (((cljs.core._EQ_.call(null,this45078__$1.tx_private_key,other45079.tx_private_key)) && (((cljs.core._EQ_.call(null,this45078__$1.tx_key_id,other45079.tx_key_id)) && (((cljs.core._EQ_.call(null,this45078__$1.meta,other45079.meta)) && (((cljs.core._EQ_.call(null,this45078__$1.add_listener,other45079.add_listener)) && (((cljs.core._EQ_.call(null,this45078__$1.remove_listener,other45079.remove_listener)) && (((cljs.core._EQ_.call(null,this45078__$1.close,other45079.close)) && (cljs.core._EQ_.call(null,this45078__$1.__extmap,other45079.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k45077){
var self__ = this;
var this__5350__auto____$1 = this;
var G__45086 = k45077;
var G__45086__$1 = (((G__45086 instanceof cljs.core.Keyword))?G__45086.fqn:null);
switch (G__45086__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k45077);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__45076){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__45087 = cljs.core.keyword_identical_QMARK_;
var expr__45088 = k__5352__auto__;
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__45088))){
return (new fluree.db.connection.Connection(G__45076,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,G__45076,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__45076,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__45076,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__45076,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__45076,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__45076,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__45076,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__45076,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__45076,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__45076,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__45076,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__45076,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__45076,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__45076,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__45076,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__45076,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__45076,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__45076,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__45076,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__45076,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45087.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__45088))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__45076,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__45076),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__45076){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__45076,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__45080){
var extmap__5385__auto__ = (function (){var G__45090 = cljs.core.dissoc.call(null,G__45080,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__45080)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__45090);
} else {
return G__45090;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__45080),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__45080),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__45096 = servers_STAR_;
var vec__45097 = G__45096;
var seq__45098 = cljs.core.seq.call(null,vec__45097);
var first__45099 = cljs.core.first.call(null,seq__45098);
var seq__45098__$1 = cljs.core.next.call(null,seq__45098);
var server = first__45099;
var r = seq__45098__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__45096__$1 = G__45096;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__45103 = G__45096__$1;
var seq__45104 = cljs.core.seq.call(null,vec__45103);
var first__45105 = cljs.core.first.call(null,seq__45104);
var seq__45104__$1 = cljs.core.next.call(null,seq__45104);
var server__$1 = first__45105;
var r__$1 = seq__45104__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__45106 = r__$1;
var G__45107 = is_https_QMARK_;
var G__45108 = result_STAR_;
G__45096__$1 = G__45106;
https_QMARK___$1 = G__45107;
result__$1 = G__45108;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__45109 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__45109 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__45109);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_45138){
var state_val_45139 = (state_45138[(1)]);
if((state_val_45139 === (7))){
var inst_45124 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_45125 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_45126 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_45127 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_45128 = fluree.db.connection.establish_socket.call(null,inst_45124,inst_45125,inst_45126,inst_45127);
var state_45138__$1 = state_45138;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45138__$1,(9),inst_45128);
} else {
if((state_val_45139 === (1))){
var state_45138__$1 = state_45138;
var statearr_45140_45159 = state_45138__$1;
(statearr_45140_45159[(2)] = null);

(statearr_45140_45159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45139 === (4))){
var inst_45110 = (state_45138[(2)]);
var state_45138__$1 = state_45138;
var statearr_45141_45160 = state_45138__$1;
(statearr_45141_45160[(2)] = inst_45110);

(statearr_45141_45160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45139 === (6))){
var inst_45121 = (state_45138[(7)]);
var state_45138__$1 = state_45138;
var statearr_45142_45161 = state_45138__$1;
(statearr_45142_45161[(2)] = inst_45121);

(statearr_45142_45161[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45139 === (3))){
var inst_45136 = (state_45138[(2)]);
var state_45138__$1 = state_45138;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45138__$1,inst_45136);
} else {
if((state_val_45139 === (2))){
var inst_45121 = (state_45138[(7)]);
var _ = (function (){var statearr_45144 = state_45138;
(statearr_45144[(4)] = cljs.core.cons.call(null,(5),(state_45138[(4)])));

return statearr_45144;
})();
var inst_45116 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_45117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45118 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_45119 = [inst_45118,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_45120 = (new cljs.core.PersistentVector(null,3,(5),inst_45117,inst_45119,null));
var inst_45121__$1 = cljs.core.get_in.call(null,inst_45116,inst_45120);
var state_45138__$1 = (function (){var statearr_45145 = state_45138;
(statearr_45145[(7)] = inst_45121__$1);

return statearr_45145;
})();
if(cljs.core.truth_(inst_45121__$1)){
var statearr_45146_45162 = state_45138__$1;
(statearr_45146_45162[(1)] = (6));

} else {
var statearr_45147_45163 = state_45138__$1;
(statearr_45147_45163[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45139 === (9))){
var inst_45130 = (state_45138[(2)]);
var inst_45131 = fluree.db.util.async.throw_err.call(null,inst_45130);
var state_45138__$1 = state_45138;
var statearr_45148_45164 = state_45138__$1;
(statearr_45148_45164[(2)] = inst_45131);

(statearr_45148_45164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45139 === (5))){
var _ = (function (){var statearr_45149 = state_45138;
(statearr_45149[(4)] = cljs.core.rest.call(null,(state_45138[(4)])));

return statearr_45149;
})();
var state_45138__$1 = state_45138;
var ex45143 = (state_45138__$1[(2)]);
var statearr_45150_45165 = state_45138__$1;
(statearr_45150_45165[(5)] = ex45143);


if((ex45143 instanceof Error)){
var statearr_45151_45166 = state_45138__$1;
(statearr_45151_45166[(1)] = (4));

(statearr_45151_45166[(5)] = null);

} else {
throw ex45143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45139 === (8))){
var inst_45133 = (state_45138[(2)]);
var _ = (function (){var statearr_45152 = state_45138;
(statearr_45152[(4)] = cljs.core.rest.call(null,(state_45138[(4)])));

return statearr_45152;
})();
var state_45138__$1 = state_45138;
var statearr_45153_45167 = state_45138__$1;
(statearr_45153_45167[(2)] = inst_45133);

(statearr_45153_45167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2721__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2721__auto____0 = (function (){
var statearr_45154 = [null,null,null,null,null,null,null,null];
(statearr_45154[(0)] = fluree$db$connection$get_socket_$_state_machine__2721__auto__);

(statearr_45154[(1)] = (1));

return statearr_45154;
});
var fluree$db$connection$get_socket_$_state_machine__2721__auto____1 = (function (state_45138){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_45138);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e45155){var ex__2724__auto__ = e45155;
var statearr_45156_45168 = state_45138;
(statearr_45156_45168[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_45138[(4)]))){
var statearr_45157_45169 = state_45138;
(statearr_45157_45169[(1)] = cljs.core.first.call(null,(state_45138[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45170 = state_45138;
state_45138 = G__45170;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2721__auto__ = function(state_45138){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2721__auto____1.call(this,state_45138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2721__auto____0;
fluree$db$connection$get_socket_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2721__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_45158 = f__2744__auto__.call(null);
(statearr_45158[(6)] = c__2743__auto__);

return statearr_45158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e45171){var e = e45171;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_45298){
var state_val_45299 = (state_45298[(1)]);
if((state_val_45299 === (7))){
var inst_45294 = (state_45298[(2)]);
var state_45298__$1 = state_45298;
var statearr_45301_45371 = state_45298__$1;
(statearr_45301_45371[(2)] = inst_45294);

(statearr_45301_45371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (20))){
var _ = (function (){var statearr_45302 = state_45298;
(statearr_45302[(4)] = cljs.core.rest.call(null,(state_45298[(4)])));

return statearr_45302;
})();
var state_45298__$1 = state_45298;
var ex45300 = (state_45298__$1[(2)]);
var statearr_45303_45372 = state_45298__$1;
(statearr_45303_45372[(5)] = ex45300);


var statearr_45304_45373 = state_45298__$1;
(statearr_45304_45373[(1)] = (10));

(statearr_45304_45373[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (27))){
var inst_45286 = (state_45298[(2)]);
var _ = (function (){var statearr_45305 = state_45298;
(statearr_45305[(4)] = cljs.core.rest.call(null,(state_45298[(4)])));

return statearr_45305;
})();
var state_45298__$1 = state_45298;
var statearr_45306_45374 = state_45298__$1;
(statearr_45306_45374[(2)] = inst_45286);

(statearr_45306_45374[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (1))){
var inst_45173 = (0);
var state_45298__$1 = (function (){var statearr_45307 = state_45298;
(statearr_45307[(7)] = inst_45173);

return statearr_45307;
})();
var statearr_45308_45375 = state_45298__$1;
(statearr_45308_45375[(2)] = null);

(statearr_45308_45375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (24))){
var inst_45264 = (state_45298[(8)]);
var inst_45264__$1 = (state_45298[(2)]);
var inst_45265 = inst_45264__$1 === true;
var state_45298__$1 = (function (){var statearr_45309 = state_45298;
(statearr_45309[(8)] = inst_45264__$1);

return statearr_45309;
})();
if(cljs.core.truth_(inst_45265)){
var statearr_45310_45376 = state_45298__$1;
(statearr_45310_45376[(1)] = (25));

} else {
var statearr_45311_45377 = state_45298__$1;
(statearr_45311_45377[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (4))){
var inst_45176 = (state_45298[(9)]);
var inst_45176__$1 = (state_45298[(2)]);
var state_45298__$1 = (function (){var statearr_45312 = state_45298;
(statearr_45312[(9)] = inst_45176__$1);

return statearr_45312;
})();
if(cljs.core.truth_(inst_45176__$1)){
var statearr_45313_45378 = state_45298__$1;
(statearr_45313_45378[(1)] = (5));

} else {
var statearr_45314_45379 = state_45298__$1;
(statearr_45314_45379[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (15))){
var inst_45189 = (state_45298[(10)]);
var state_45298__$1 = state_45298;
var statearr_45315_45380 = state_45298__$1;
(statearr_45315_45380[(2)] = inst_45189);

(statearr_45315_45380[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (21))){
var inst_45220 = (state_45298[(11)]);
var inst_45173 = (state_45298[(7)]);
var inst_45217 = (state_45298[(12)]);
var inst_45212 = (state_45298[(13)]);
var inst_45221 = (state_45298[(14)]);
var inst_45214 = (state_45298[(15)]);
var inst_45213 = (state_45298[(16)]);
var inst_45215 = (state_45298[(17)]);
var inst_45216 = (state_45298[(18)]);
var inst_45176 = (state_45298[(9)]);
var inst_45223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45224 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_45220];
var inst_45225 = (new cljs.core.PersistentVector(null,2,(5),inst_45223,inst_45224,null));
var inst_45226 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_45225,inst_45215);
var inst_45253 = cljs.core.async.chan.call(null,(1));
var inst_45254 = (function (){var resp_chan = inst_45215;
var timeout = inst_45221;
var i = inst_45173;
var data = inst_45214;
var map__45211 = inst_45217;
var _ = inst_45212;
var c__2743__auto____$1 = inst_45253;
var req_id = inst_45220;
var operation = inst_45213;
var msg = inst_45176;
var vec__45208 = inst_45176;
var opts = inst_45216;
return (function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_45251){
var state_val_45252 = (state_45251[(1)]);
if((state_val_45252 === (1))){
var inst_45230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45231 = cljs.core.async.timeout.call(null,timeout);
var inst_45232 = [resp_chan,inst_45231];
var inst_45233 = (new cljs.core.PersistentVector(null,2,(5),inst_45230,inst_45232,null));
var state_45251__$1 = state_45251;
return cljs.core.async.ioc_alts_BANG_.call(null,state_45251__$1,(2),inst_45233);
} else {
if((state_val_45252 === (2))){
var inst_45236 = (state_45251[(7)]);
var inst_45235 = (state_45251[(2)]);
var inst_45236__$1 = cljs.core.nth.call(null,inst_45235,(0),null);
var inst_45237 = cljs.core.nth.call(null,inst_45235,(1),null);
var inst_45238 = (function (){var vec__45227 = inst_45235;
var resp = inst_45236__$1;
var c = inst_45237;
return (function (p1__45172_SHARP_){
return cljs.core.dissoc.call(null,p1__45172_SHARP_,req_id);
});
})();
var inst_45239 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_45238);
var inst_45240 = cljs.core._EQ_.call(null,inst_45237,resp_chan);
var state_45251__$1 = (function (){var statearr_45316 = state_45251;
(statearr_45316[(7)] = inst_45236__$1);

(statearr_45316[(8)] = inst_45239);

return statearr_45316;
})();
if(inst_45240){
var statearr_45317_45381 = state_45251__$1;
(statearr_45317_45381[(1)] = (3));

} else {
var statearr_45318_45382 = state_45251__$1;
(statearr_45318_45382[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45252 === (3))){
var inst_45236 = (state_45251[(7)]);
var state_45251__$1 = state_45251;
var statearr_45319_45383 = state_45251__$1;
(statearr_45319_45383[(2)] = inst_45236);

(statearr_45319_45383[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45252 === (4))){
var inst_45243 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_45244 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_45245 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_45246 = cljs.core.PersistentHashMap.fromArrays(inst_45244,inst_45245);
var inst_45247 = cljs.core.ex_info.call(null,inst_45243,inst_45246);
var state_45251__$1 = state_45251;
var statearr_45320_45384 = state_45251__$1;
(statearr_45320_45384[(2)] = inst_45247);

(statearr_45320_45384[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45252 === (5))){
var inst_45249 = (state_45251[(2)]);
var state_45251__$1 = state_45251;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45251__$1,inst_45249);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2721__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2721__auto____0 = (function (){
var statearr_45321 = [null,null,null,null,null,null,null,null,null];
(statearr_45321[(0)] = fluree$db$connection$msg_producer_$_state_machine__2721__auto__);

(statearr_45321[(1)] = (1));

return statearr_45321;
});
var fluree$db$connection$msg_producer_$_state_machine__2721__auto____1 = (function (state_45251){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_45251);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e45322){var ex__2724__auto__ = e45322;
var statearr_45323_45385 = state_45251;
(statearr_45323_45385[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_45251[(4)]))){
var statearr_45324_45386 = state_45251;
(statearr_45324_45386[(1)] = cljs.core.first.call(null,(state_45251[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45387 = state_45251;
state_45251 = G__45387;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2721__auto__ = function(state_45251){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2721__auto____1.call(this,state_45251);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2721__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2721__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_45325 = f__2744__auto__.call(null);
(statearr_45325[(6)] = c__2743__auto____$1);

return statearr_45325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
});
})();
var inst_45255 = cljs.core.async.impl.dispatch.run.call(null,inst_45254);
var state_45298__$1 = (function (){var statearr_45326 = state_45298;
(statearr_45326[(19)] = inst_45255);

(statearr_45326[(20)] = inst_45226);

return statearr_45326;
})();
var statearr_45327_45388 = state_45298__$1;
(statearr_45327_45388[(2)] = inst_45253);

(statearr_45327_45388[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (31))){
var inst_45274 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_45298__$1 = state_45298;
var statearr_45328_45389 = state_45298__$1;
(statearr_45328_45389[(2)] = inst_45274);

(statearr_45328_45389[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (32))){
var state_45298__$1 = state_45298;
var statearr_45329_45390 = state_45298__$1;
(statearr_45329_45390[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (33))){
var inst_45282 = (state_45298[(2)]);
var state_45298__$1 = state_45298;
var statearr_45331_45391 = state_45298__$1;
(statearr_45331_45391[(2)] = inst_45282);

(statearr_45331_45391[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (13))){
var inst_45189 = (state_45298[(10)]);
var inst_45186 = (state_45298[(2)]);
var inst_45187 = cljs.core.nth.call(null,inst_45186,(0),null);
var inst_45188 = cljs.core.nth.call(null,inst_45186,(1),null);
var inst_45189__$1 = cljs.core.nth.call(null,inst_45186,(2),null);
var state_45298__$1 = (function (){var statearr_45332 = state_45298;
(statearr_45332[(10)] = inst_45189__$1);

(statearr_45332[(21)] = inst_45188);

(statearr_45332[(22)] = inst_45187);

return statearr_45332;
})();
if(cljs.core.truth_(inst_45189__$1)){
var statearr_45333_45392 = state_45298__$1;
(statearr_45333_45392[(1)] = (14));

} else {
var statearr_45334_45393 = state_45298__$1;
(statearr_45334_45393[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (22))){
var state_45298__$1 = state_45298;
var statearr_45335_45394 = state_45298__$1;
(statearr_45335_45394[(2)] = null);

(statearr_45335_45394[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (36))){
var inst_45280 = (state_45298[(2)]);
var state_45298__$1 = state_45298;
var statearr_45336_45395 = state_45298__$1;
(statearr_45336_45395[(2)] = inst_45280);

(statearr_45336_45395[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (29))){
var inst_45264 = (state_45298[(8)]);
var inst_45272 = (inst_45264 == null);
var state_45298__$1 = state_45298;
if(cljs.core.truth_(inst_45272)){
var statearr_45337_45396 = state_45298__$1;
(statearr_45337_45396[(1)] = (31));

} else {
var statearr_45338_45397 = state_45298__$1;
(statearr_45338_45397[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (6))){
var state_45298__$1 = state_45298;
var statearr_45339_45398 = state_45298__$1;
(statearr_45339_45398[(2)] = null);

(statearr_45339_45398[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (28))){
var inst_45264 = (state_45298[(8)]);
var inst_45270 = fluree.db.util.log.error.call(null,inst_45264,"Error processing message in producer.");
var state_45298__$1 = state_45298;
var statearr_45340_45399 = state_45298__$1;
(statearr_45340_45399[(2)] = inst_45270);

(statearr_45340_45399[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (25))){
var state_45298__$1 = state_45298;
var statearr_45341_45400 = state_45298__$1;
(statearr_45341_45400[(2)] = null);

(statearr_45341_45400[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (34))){
var inst_45264 = (state_45298[(8)]);
var inst_45277 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_45264);
var state_45298__$1 = state_45298;
var statearr_45342_45401 = state_45298__$1;
(statearr_45342_45401[(2)] = inst_45277);

(statearr_45342_45401[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (17))){
var inst_45189 = (state_45298[(10)]);
var inst_45178 = (state_45298[(23)]);
var inst_45196 = cljs.core.async.put_BANG_.call(null,inst_45189,inst_45178);
var state_45298__$1 = state_45298;
var statearr_45343_45402 = state_45298__$1;
(statearr_45343_45402[(2)] = inst_45196);

(statearr_45343_45402[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (3))){
var inst_45296 = (state_45298[(2)]);
var state_45298__$1 = state_45298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45298__$1,inst_45296);
} else {
if((state_val_45299 === (12))){
var state_45298__$1 = state_45298;
var statearr_45344_45403 = state_45298__$1;
(statearr_45344_45403[(2)] = null);

(statearr_45344_45403[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (2))){
var state_45298__$1 = state_45298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45298__$1,(4),req_chan);
} else {
if((state_val_45299 === (23))){
var inst_45220 = (state_45298[(11)]);
var inst_45214 = (state_45298[(15)]);
var inst_45213 = (state_45298[(16)]);
var inst_45258 = (state_45298[(2)]);
var inst_45259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45260 = [inst_45213,inst_45220,inst_45214];
var inst_45261 = (new cljs.core.PersistentVector(null,3,(5),inst_45259,inst_45260,null));
var inst_45262 = publish_fn.call(null,conn,inst_45261);
var state_45298__$1 = (function (){var statearr_45345 = state_45298;
(statearr_45345[(24)] = inst_45258);

return statearr_45345;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45298__$1,(24),inst_45262);
} else {
if((state_val_45299 === (35))){
var state_45298__$1 = state_45298;
var statearr_45346_45404 = state_45298__$1;
(statearr_45346_45404[(2)] = null);

(statearr_45346_45404[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (19))){
var inst_45202 = (state_45298[(2)]);
var state_45298__$1 = state_45298;
var statearr_45347_45405 = state_45298__$1;
(statearr_45347_45405[(2)] = inst_45202);

(statearr_45347_45405[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (11))){
var inst_45176 = (state_45298[(9)]);
var state_45298__$1 = state_45298;
var statearr_45348_45406 = state_45298__$1;
(statearr_45348_45406[(2)] = inst_45176);

(statearr_45348_45406[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (9))){
var inst_45173 = (state_45298[(7)]);
var inst_45289 = (state_45298[(2)]);
var inst_45290 = (inst_45173 + (1));
var inst_45173__$1 = inst_45290;
var state_45298__$1 = (function (){var statearr_45349 = state_45298;
(statearr_45349[(7)] = inst_45173__$1);

(statearr_45349[(25)] = inst_45289);

return statearr_45349;
})();
var statearr_45350_45407 = state_45298__$1;
(statearr_45350_45407[(2)] = null);

(statearr_45350_45407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (5))){
var state_45298__$1 = state_45298;
var statearr_45351_45408 = state_45298__$1;
(statearr_45351_45408[(2)] = null);

(statearr_45351_45408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (14))){
var inst_45189 = (state_45298[(10)]);
var inst_45191 = fluree.db.util.async.channel_QMARK_.call(null,inst_45189);
var state_45298__$1 = state_45298;
var statearr_45352_45409 = state_45298__$1;
(statearr_45352_45409[(2)] = inst_45191);

(statearr_45352_45409[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (26))){
var inst_45264 = (state_45298[(8)]);
var inst_45268 = fluree.db.util.core.exception_QMARK_.call(null,inst_45264);
var state_45298__$1 = state_45298;
if(inst_45268){
var statearr_45353_45410 = state_45298__$1;
(statearr_45353_45410[(1)] = (28));

} else {
var statearr_45354_45411 = state_45298__$1;
(statearr_45354_45411[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (16))){
var inst_45194 = (state_45298[(2)]);
var state_45298__$1 = state_45298;
if(cljs.core.truth_(inst_45194)){
var statearr_45355_45412 = state_45298__$1;
(statearr_45355_45412[(1)] = (17));

} else {
var statearr_45356_45413 = state_45298__$1;
(statearr_45356_45413[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (30))){
var inst_45284 = (state_45298[(2)]);
var state_45298__$1 = state_45298;
var statearr_45357_45414 = state_45298__$1;
(statearr_45357_45414[(2)] = inst_45284);

(statearr_45357_45414[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (10))){
var inst_45176 = (state_45298[(9)]);
var inst_45178 = (state_45298[(2)]);
var inst_45182 = cljs.core.sequential_QMARK_.call(null,inst_45176);
var state_45298__$1 = (function (){var statearr_45358 = state_45298;
(statearr_45358[(23)] = inst_45178);

return statearr_45358;
})();
if(inst_45182){
var statearr_45359_45415 = state_45298__$1;
(statearr_45359_45415[(1)] = (11));

} else {
var statearr_45360_45416 = state_45298__$1;
(statearr_45360_45416[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (18))){
var inst_45178 = (state_45298[(23)]);
var inst_45176 = (state_45298[(9)]);
var inst_45198 = cljs.core.pr_str.call(null,inst_45176);
var inst_45199 = ["Error processing ledger request, no valid return channel: ",inst_45198].join('');
var inst_45200 = fluree.db.util.log.error.call(null,inst_45178,inst_45199);
var state_45298__$1 = state_45298;
var statearr_45361_45417 = state_45298__$1;
(statearr_45361_45417[(2)] = inst_45200);

(statearr_45361_45417[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45299 === (8))){
var inst_45217 = (state_45298[(12)]);
var inst_45215 = (state_45298[(17)]);
var inst_45216 = (state_45298[(18)]);
var inst_45176 = (state_45298[(9)]);
var _ = (function (){var statearr_45362 = state_45298;
(statearr_45362[(4)] = cljs.core.cons.call(null,(20),(state_45298[(4)])));

return statearr_45362;
})();
var inst_45212 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_45176);
var inst_45213 = cljs.core.nth.call(null,inst_45176,(0),null);
var inst_45214 = cljs.core.nth.call(null,inst_45176,(1),null);
var inst_45215__$1 = cljs.core.nth.call(null,inst_45176,(2),null);
var inst_45216__$1 = cljs.core.nth.call(null,inst_45176,(3),null);
var inst_45217__$1 = cljs.core.__destructure_map.call(null,inst_45216__$1);
var inst_45218 = fluree.db.util.core.random_uuid.call(null);
var inst_45219 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45218);
var inst_45220 = cljs.core.get.call(null,inst_45217__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_45219);
var inst_45221 = cljs.core.get.call(null,inst_45217__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_45298__$1 = (function (){var statearr_45363 = state_45298;
(statearr_45363[(11)] = inst_45220);

(statearr_45363[(12)] = inst_45217__$1);

(statearr_45363[(13)] = inst_45212);

(statearr_45363[(14)] = inst_45221);

(statearr_45363[(15)] = inst_45214);

(statearr_45363[(16)] = inst_45213);

(statearr_45363[(17)] = inst_45215__$1);

(statearr_45363[(18)] = inst_45216__$1);

return statearr_45363;
})();
if(cljs.core.truth_(inst_45215__$1)){
var statearr_45364_45418 = state_45298__$1;
(statearr_45364_45418[(1)] = (21));

} else {
var statearr_45365_45419 = state_45298__$1;
(statearr_45365_45419[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2721__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2721__auto____0 = (function (){
var statearr_45366 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45366[(0)] = fluree$db$connection$msg_producer_$_state_machine__2721__auto__);

(statearr_45366[(1)] = (1));

return statearr_45366;
});
var fluree$db$connection$msg_producer_$_state_machine__2721__auto____1 = (function (state_45298){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_45298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e45367){var ex__2724__auto__ = e45367;
var statearr_45368_45420 = state_45298;
(statearr_45368_45420[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_45298[(4)]))){
var statearr_45369_45421 = state_45298;
(statearr_45369_45421[(1)] = cljs.core.first.call(null,(state_45298[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45422 = state_45298;
state_45298 = G__45422;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2721__auto__ = function(state_45298){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2721__auto____1.call(this,state_45298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2721__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2721__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_45370 = f__2744__auto__.call(null);
(statearr_45370[(6)] = c__2743__auto__);

return statearr_45370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__45423 = conn;
var map__45423__$1 = cljs.core.__destructure_map.call(null,map__45423);
var sub_chan = cljs.core.get.call(null,map__45423__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_45508){
var state_val_45509 = (state_45508[(1)]);
if((state_val_45509 === (7))){
var inst_45504 = (state_45508[(2)]);
var state_45508__$1 = state_45508;
var statearr_45510_45561 = state_45508__$1;
(statearr_45510_45561[(2)] = inst_45504);

(statearr_45510_45561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (20))){
var inst_45442 = (state_45508[(7)]);
var inst_45456 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_45457 = [inst_45442];
var inst_45458 = cljs.core.PersistentHashMap.fromArrays(inst_45456,inst_45457);
var inst_45459 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_45458);
var state_45508__$1 = state_45508;
var statearr_45511_45562 = state_45508__$1;
(statearr_45511_45562[(2)] = inst_45459);

(statearr_45511_45562[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (27))){
var state_45508__$1 = state_45508;
var statearr_45512_45563 = state_45508__$1;
(statearr_45512_45563[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (1))){
var inst_45424 = (0);
var state_45508__$1 = (function (){var statearr_45514 = state_45508;
(statearr_45514[(8)] = inst_45424);

return statearr_45514;
})();
var statearr_45515_45564 = state_45508__$1;
(statearr_45515_45564[(2)] = null);

(statearr_45515_45564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (24))){
var inst_45435 = (state_45508[(9)]);
var inst_45484 = fluree.db.util.core.exception_QMARK_.call(null,inst_45435);
var state_45508__$1 = state_45508;
if(inst_45484){
var statearr_45516_45565 = state_45508__$1;
(statearr_45516_45565[(1)] = (26));

} else {
var statearr_45517_45566 = state_45508__$1;
(statearr_45517_45566[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (4))){
var inst_45429 = (state_45508[(10)]);
var inst_45434 = (state_45508[(2)]);
var inst_45435 = cljs.core.nth.call(null,inst_45434,(0),null);
var inst_45436 = cljs.core.nth.call(null,inst_45434,(1),null);
var inst_45437 = cljs.core._EQ_.call(null,inst_45436,inst_45429);
var state_45508__$1 = (function (){var statearr_45518 = state_45508;
(statearr_45518[(9)] = inst_45435);

return statearr_45518;
})();
if(inst_45437){
var statearr_45519_45567 = state_45508__$1;
(statearr_45519_45567[(1)] = (5));

} else {
var statearr_45520_45568 = state_45508__$1;
(statearr_45520_45568[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (15))){
var inst_45442 = (state_45508[(7)]);
var inst_45451 = typeof inst_45442 === 'string';
var state_45508__$1 = state_45508;
if(cljs.core.truth_(inst_45451)){
var statearr_45521_45569 = state_45508__$1;
(statearr_45521_45569[(1)] = (17));

} else {
var statearr_45522_45570 = state_45508__$1;
(statearr_45522_45570[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (21))){
var state_45508__$1 = state_45508;
var statearr_45523_45571 = state_45508__$1;
(statearr_45523_45571[(2)] = null);

(statearr_45523_45571[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (31))){
var inst_45498 = (state_45508[(2)]);
var state_45508__$1 = state_45508;
var statearr_45524_45572 = state_45508__$1;
(statearr_45524_45572[(2)] = inst_45498);

(statearr_45524_45572[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (13))){
var inst_45468 = (state_45508[(2)]);
var inst_45469 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_45470 = fluree.db.connection.close_websocket.call(null,inst_45469);
var inst_45471 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_45472 = fluree.db.session.close_all_sessions.call(null,inst_45471);
var state_45508__$1 = (function (){var statearr_45525 = state_45508;
(statearr_45525[(11)] = inst_45468);

(statearr_45525[(12)] = inst_45470);

return statearr_45525;
})();
var statearr_45526_45573 = state_45508__$1;
(statearr_45526_45573[(2)] = inst_45472);

(statearr_45526_45573[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (22))){
var inst_45462 = (state_45508[(2)]);
var state_45508__$1 = state_45508;
var statearr_45527_45574 = state_45508__$1;
(statearr_45527_45574[(2)] = inst_45462);

(statearr_45527_45574[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (29))){
var inst_45435 = (state_45508[(9)]);
var inst_45490 = fluree.db.util.json.parse.call(null,inst_45435);
var inst_45491 = cljs.core.pr_str.call(null,inst_45490);
var inst_45492 = fluree.db.util.log.trace.call(null,"Received message:",inst_45491);
var inst_45493 = fluree.db.util.json.parse.call(null,inst_45435);
var inst_45494 = fluree.db.conn_events.process_events.call(null,conn,inst_45493);
var inst_45424 = (0);
var state_45508__$1 = (function (){var statearr_45528 = state_45508;
(statearr_45528[(13)] = inst_45492);

(statearr_45528[(14)] = inst_45494);

(statearr_45528[(8)] = inst_45424);

return statearr_45528;
})();
var statearr_45529_45575 = state_45508__$1;
(statearr_45529_45575[(2)] = null);

(statearr_45529_45575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (6))){
var inst_45435 = (state_45508[(9)]);
var inst_45480 = (inst_45435 == null);
var state_45508__$1 = state_45508;
if(cljs.core.truth_(inst_45480)){
var statearr_45530_45576 = state_45508__$1;
(statearr_45530_45576[(1)] = (23));

} else {
var statearr_45531_45577 = state_45508__$1;
(statearr_45531_45577[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (28))){
var inst_45500 = (state_45508[(2)]);
var state_45508__$1 = state_45508;
var statearr_45532_45578 = state_45508__$1;
(statearr_45532_45578[(2)] = inst_45500);

(statearr_45532_45578[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (25))){
var inst_45502 = (state_45508[(2)]);
var state_45508__$1 = state_45508;
var statearr_45533_45579 = state_45508__$1;
(statearr_45533_45579[(2)] = inst_45502);

(statearr_45533_45579[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (17))){
var inst_45442 = (state_45508[(7)]);
var inst_45453 = cljs.core.eval.call(null,inst_45442);
var state_45508__$1 = state_45508;
var statearr_45534_45580 = state_45508__$1;
(statearr_45534_45580[(2)] = inst_45453);

(statearr_45534_45580[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (3))){
var inst_45506 = (state_45508[(2)]);
var state_45508__$1 = state_45508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45508__$1,inst_45506);
} else {
if((state_val_45509 === (12))){
var inst_45442 = (state_45508[(7)]);
var inst_45447 = cljs.core.fn_QMARK_.call(null,inst_45442);
var state_45508__$1 = state_45508;
if(inst_45447){
var statearr_45535_45581 = state_45508__$1;
(statearr_45535_45581[(1)] = (14));

} else {
var statearr_45536_45582 = state_45508__$1;
(statearr_45536_45582[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (2))){
var inst_45429 = (state_45508[(10)]);
var inst_45429__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_45430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45431 = [sub_chan,inst_45429__$1];
var inst_45432 = (new cljs.core.PersistentVector(null,2,(5),inst_45430,inst_45431,null));
var state_45508__$1 = (function (){var statearr_45537 = state_45508;
(statearr_45537[(10)] = inst_45429__$1);

return statearr_45537;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_45508__$1,(4),inst_45432);
} else {
if((state_val_45509 === (23))){
var inst_45482 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_45508__$1 = state_45508;
var statearr_45538_45583 = state_45508__$1;
(statearr_45538_45583[(2)] = inst_45482);

(statearr_45538_45583[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (19))){
var inst_45464 = (state_45508[(2)]);
var state_45508__$1 = state_45508;
var statearr_45539_45584 = state_45508__$1;
(statearr_45539_45584[(2)] = inst_45464);

(statearr_45539_45584[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (11))){
var inst_45445 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_45508__$1 = state_45508;
var statearr_45540_45585 = state_45508__$1;
(statearr_45540_45585[(2)] = inst_45445);

(statearr_45540_45585[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (9))){
var inst_45424 = (state_45508[(8)]);
var inst_45474 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_45475 = (inst_45424 + (1));
var inst_45424__$1 = inst_45475;
var state_45508__$1 = (function (){var statearr_45541 = state_45508;
(statearr_45541[(15)] = inst_45474);

(statearr_45541[(8)] = inst_45424__$1);

return statearr_45541;
})();
var statearr_45542_45586 = state_45508__$1;
(statearr_45542_45586[(2)] = null);

(statearr_45542_45586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (5))){
var inst_45424 = (state_45508[(8)]);
var inst_45439 = cljs.core._EQ_.call(null,(2),inst_45424);
var state_45508__$1 = state_45508;
if(inst_45439){
var statearr_45543_45587 = state_45508__$1;
(statearr_45543_45587[(1)] = (8));

} else {
var statearr_45544_45588 = state_45508__$1;
(statearr_45544_45588[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (14))){
var inst_45442 = (state_45508[(7)]);
var inst_45449 = inst_45442.call(null);
var state_45508__$1 = state_45508;
var statearr_45545_45589 = state_45508__$1;
(statearr_45545_45589[(2)] = inst_45449);

(statearr_45545_45589[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (26))){
var inst_45435 = (state_45508[(9)]);
var inst_45486 = fluree.db.util.log.error.call(null,inst_45435);
var inst_45424 = (0);
var state_45508__$1 = (function (){var statearr_45546 = state_45508;
(statearr_45546[(16)] = inst_45486);

(statearr_45546[(8)] = inst_45424);

return statearr_45546;
})();
var statearr_45547_45590 = state_45508__$1;
(statearr_45547_45590[(2)] = null);

(statearr_45547_45590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (16))){
var inst_45466 = (state_45508[(2)]);
var state_45508__$1 = state_45508;
var statearr_45548_45591 = state_45508__$1;
(statearr_45548_45591[(2)] = inst_45466);

(statearr_45548_45591[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (30))){
var state_45508__$1 = state_45508;
var statearr_45549_45592 = state_45508__$1;
(statearr_45549_45592[(2)] = null);

(statearr_45549_45592[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (10))){
var inst_45478 = (state_45508[(2)]);
var state_45508__$1 = state_45508;
var statearr_45550_45593 = state_45508__$1;
(statearr_45550_45593[(2)] = inst_45478);

(statearr_45550_45593[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (18))){
var state_45508__$1 = state_45508;
var statearr_45551_45594 = state_45508__$1;
(statearr_45551_45594[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45509 === (8))){
var inst_45442 = (state_45508[(7)]);
var inst_45441 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_45442__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_45443 = (inst_45442__$1 == null);
var state_45508__$1 = (function (){var statearr_45553 = state_45508;
(statearr_45553[(7)] = inst_45442__$1);

(statearr_45553[(17)] = inst_45441);

return statearr_45553;
})();
if(cljs.core.truth_(inst_45443)){
var statearr_45554_45595 = state_45508__$1;
(statearr_45554_45595[(1)] = (11));

} else {
var statearr_45555_45596 = state_45508__$1;
(statearr_45555_45596[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2721__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2721__auto____0 = (function (){
var statearr_45556 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45556[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2721__auto__);

(statearr_45556[(1)] = (1));

return statearr_45556;
});
var fluree$db$connection$msg_consumer_$_state_machine__2721__auto____1 = (function (state_45508){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_45508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e45557){var ex__2724__auto__ = e45557;
var statearr_45558_45597 = state_45508;
(statearr_45558_45597[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_45508[(4)]))){
var statearr_45559_45598 = state_45508;
(statearr_45559_45598[(1)] = cljs.core.first.call(null,(state_45508[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45599 = state_45508;
state_45508 = G__45599;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2721__auto__ = function(state_45508){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2721__auto____1.call(this,state_45508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2721__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2721__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_45560 = f__2744__auto__.call(null);
(statearr_45560[(6)] = c__2743__auto__);

return statearr_45560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__45601 = arguments.length;
switch (G__45601) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__45602 = opts;
var map__45602__$1 = cljs.core.__destructure_map.call(null,map__45602);
var private$ = cljs.core.get.call(null,map__45602__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__45602__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2743__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_45654){
var state_val_45655 = (state_45654[(1)]);
if((state_val_45655 === (7))){
var inst_45612 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_45613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45614 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_45615 = (new cljs.core.PersistentVector(null,2,(5),inst_45613,inst_45614,null));
var inst_45616 = cljs.core.get_in.call(null,inst_45612,inst_45615);
var state_45654__$1 = state_45654;
var statearr_45656_45687 = state_45654__$1;
(statearr_45656_45687[(2)] = inst_45616);

(statearr_45656_45687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (1))){
var state_45654__$1 = state_45654;
var statearr_45657_45688 = state_45654__$1;
(statearr_45657_45688[(2)] = null);

(statearr_45657_45688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (4))){
var inst_45603 = (state_45654[(2)]);
var state_45654__$1 = state_45654;
var statearr_45658_45689 = state_45654__$1;
(statearr_45658_45689[(2)] = inst_45603);

(statearr_45658_45689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (15))){
var inst_45623 = (state_45654[(7)]);
var inst_45642 = (state_45654[(2)]);
var inst_45643 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_45644 = [(5000),inst_45642,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_45645 = cljs.core.PersistentHashMap.fromArrays(inst_45643,inst_45644);
var inst_45646 = fluree.db.util.xhttp.get.call(null,inst_45623,inst_45645);
var state_45654__$1 = state_45654;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45654__$1,(16),inst_45646);
} else {
if((state_val_45655 === (13))){
var inst_45623 = (state_45654[(7)]);
var inst_45633 = (state_45654[(8)]);
var inst_45635 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_45636 = [inst_45633];
var inst_45637 = cljs.core.PersistentHashMap.fromArrays(inst_45635,inst_45636);
var inst_45638 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_45623,inst_45637,private$);
var inst_45639 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_45638);
var state_45654__$1 = state_45654;
var statearr_45659_45690 = state_45654__$1;
(statearr_45659_45690[(2)] = inst_45639);

(statearr_45659_45690[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (6))){
var inst_45609 = (state_45654[(9)]);
var state_45654__$1 = state_45654;
var statearr_45660_45691 = state_45654__$1;
(statearr_45660_45691[(2)] = inst_45609);

(statearr_45660_45691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (3))){
var inst_45652 = (state_45654[(2)]);
var state_45654__$1 = state_45654;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45654__$1,inst_45652);
} else {
if((state_val_45655 === (12))){
var inst_45633 = (state_45654[(2)]);
var state_45654__$1 = (function (){var statearr_45661 = state_45654;
(statearr_45661[(8)] = inst_45633);

return statearr_45661;
})();
if(cljs.core.truth_(private$)){
var statearr_45662_45692 = state_45654__$1;
(statearr_45662_45692[(1)] = (13));

} else {
var statearr_45663_45693 = state_45654__$1;
(statearr_45663_45693[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (2))){
var inst_45609 = (state_45654[(9)]);
var _ = (function (){var statearr_45664 = state_45654;
(statearr_45664[(4)] = cljs.core.cons.call(null,(5),(state_45654[(4)])));

return statearr_45664;
})();
var inst_45609__$1 = jwt;
var state_45654__$1 = (function (){var statearr_45665 = state_45654;
(statearr_45665[(9)] = inst_45609__$1);

return statearr_45665;
})();
if(cljs.core.truth_(inst_45609__$1)){
var statearr_45666_45694 = state_45654__$1;
(statearr_45666_45694[(1)] = (6));

} else {
var statearr_45667_45695 = state_45654__$1;
(statearr_45667_45695[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (11))){
var inst_45627 = (state_45654[(10)]);
var state_45654__$1 = state_45654;
var statearr_45669_45696 = state_45654__$1;
(statearr_45669_45696[(2)] = inst_45627);

(statearr_45669_45696[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (9))){
var inst_45618 = (state_45654[(11)]);
var inst_45619 = (state_45654[(12)]);
var inst_45622 = (state_45654[(2)]);
var inst_45623 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45622),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45619)].join('');
var inst_45625 = ["Accept"];
var inst_45626 = ["application/json"];
var inst_45627 = cljs.core.PersistentHashMap.fromArrays(inst_45625,inst_45626);
var state_45654__$1 = (function (){var statearr_45670 = state_45654;
(statearr_45670[(7)] = inst_45623);

(statearr_45670[(10)] = inst_45627);

return statearr_45670;
})();
if(cljs.core.truth_(inst_45618)){
var statearr_45671_45697 = state_45654__$1;
(statearr_45671_45697[(1)] = (10));

} else {
var statearr_45672_45698 = state_45654__$1;
(statearr_45672_45698[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (5))){
var _ = (function (){var statearr_45673 = state_45654;
(statearr_45673[(4)] = cljs.core.rest.call(null,(state_45654[(4)])));

return statearr_45673;
})();
var state_45654__$1 = state_45654;
var ex45668 = (state_45654__$1[(2)]);
var statearr_45674_45699 = state_45654__$1;
(statearr_45674_45699[(5)] = ex45668);


if((ex45668 instanceof Error)){
var statearr_45675_45700 = state_45654__$1;
(statearr_45675_45700[(1)] = (4));

(statearr_45675_45700[(5)] = null);

} else {
throw ex45668;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (14))){
var inst_45633 = (state_45654[(8)]);
var state_45654__$1 = state_45654;
var statearr_45676_45701 = state_45654__$1;
(statearr_45676_45701[(2)] = inst_45633);

(statearr_45676_45701[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (16))){
var inst_45648 = (state_45654[(2)]);
var inst_45649 = fluree.db.util.async.throw_err.call(null,inst_45648);
var _ = (function (){var statearr_45677 = state_45654;
(statearr_45677[(4)] = cljs.core.rest.call(null,(state_45654[(4)])));

return statearr_45677;
})();
var state_45654__$1 = state_45654;
var statearr_45678_45702 = state_45654__$1;
(statearr_45678_45702[(2)] = inst_45649);

(statearr_45678_45702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (10))){
var inst_45618 = (state_45654[(11)]);
var inst_45627 = (state_45654[(10)]);
var inst_45629 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45618)].join('');
var inst_45630 = cljs.core.assoc.call(null,inst_45627,"Authorization",inst_45629);
var state_45654__$1 = state_45654;
var statearr_45679_45703 = state_45654__$1;
(statearr_45679_45703[(2)] = inst_45630);

(statearr_45679_45703[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45655 === (8))){
var inst_45618 = (state_45654[(2)]);
var inst_45619 = clojure.string.replace.call(null,k,"_","/");
var inst_45620 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_45654__$1 = (function (){var statearr_45680 = state_45654;
(statearr_45680[(11)] = inst_45618);

(statearr_45680[(12)] = inst_45619);

return statearr_45680;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45654__$1,(9),inst_45620);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2721__auto__ = null;
var fluree$db$connection$state_machine__2721__auto____0 = (function (){
var statearr_45681 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45681[(0)] = fluree$db$connection$state_machine__2721__auto__);

(statearr_45681[(1)] = (1));

return statearr_45681;
});
var fluree$db$connection$state_machine__2721__auto____1 = (function (state_45654){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_45654);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e45682){var ex__2724__auto__ = e45682;
var statearr_45683_45704 = state_45654;
(statearr_45683_45704[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_45654[(4)]))){
var statearr_45684_45705 = state_45654;
(statearr_45684_45705[(1)] = cljs.core.first.call(null,(state_45654[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45706 = state_45654;
state_45654 = G__45706;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2721__auto__ = function(state_45654){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2721__auto____1.call(this,state_45654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2721__auto____0;
fluree$db$connection$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2721__auto____1;
return fluree$db$connection$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_45685 = f__2744__auto__.call(null);
(statearr_45685[(6)] = c__2743__auto__);

return statearr_45685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

return c__2743__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5802__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__45707_SHARP_){
if(cljs.core.truth_(p1__45707_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__45708_SHARP_){
var or__5045__auto__ = p1__45708_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e45709){var e = e45709;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__45710 = opts;
var map__45710__$1 = cljs.core.__destructure_map.call(null,map__45710);
var sub_chan = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__45710__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache.call(null);
} else {
}

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___45751 = arguments.length;
var i__5770__auto___45752 = (0);
while(true){
if((i__5770__auto___45752 < len__5769__auto___45751)){
args__5775__auto__.push((arguments[i__5770__auto___45752]));

var G__45753 = (i__5770__auto___45752 + (1));
i__5770__auto___45752 = G__45753;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__45713){
var vec__45714 = p__45713;
var opts = cljs.core.nth.call(null,vec__45714,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2743__auto___45754 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2744__auto__ = (function (){var switch__2720__auto__ = (function (state_45734){
var state_val_45735 = (state_45734[(1)]);
if((state_val_45735 === (1))){
var inst_45717 = fluree.db.connection.get_socket.call(null,conn);
var state_45734__$1 = state_45734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45734__$1,(2),inst_45717);
} else {
if((state_val_45735 === (2))){
var inst_45719 = (state_45734[(7)]);
var inst_45720 = (state_45734[(8)]);
var inst_45719__$1 = (state_45734[(2)]);
var inst_45720__$1 = (inst_45719__$1 == null);
var state_45734__$1 = (function (){var statearr_45736 = state_45734;
(statearr_45736[(7)] = inst_45719__$1);

(statearr_45736[(8)] = inst_45720__$1);

return statearr_45736;
})();
if(cljs.core.truth_(inst_45720__$1)){
var statearr_45737_45755 = state_45734__$1;
(statearr_45737_45755[(1)] = (3));

} else {
var statearr_45738_45756 = state_45734__$1;
(statearr_45738_45756[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (3))){
var inst_45720 = (state_45734[(8)]);
var state_45734__$1 = state_45734;
var statearr_45739_45757 = state_45734__$1;
(statearr_45739_45757[(2)] = inst_45720);

(statearr_45739_45757[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (4))){
var inst_45719 = (state_45734[(7)]);
var inst_45723 = fluree.db.util.core.exception_QMARK_.call(null,inst_45719);
var state_45734__$1 = state_45734;
var statearr_45740_45758 = state_45734__$1;
(statearr_45740_45758[(2)] = inst_45723);

(statearr_45740_45758[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (5))){
var inst_45725 = (state_45734[(2)]);
var state_45734__$1 = state_45734;
if(cljs.core.truth_(inst_45725)){
var statearr_45741_45759 = state_45734__$1;
(statearr_45741_45759[(1)] = (6));

} else {
var statearr_45742_45760 = state_45734__$1;
(statearr_45742_45760[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (6))){
var inst_45719 = (state_45734[(7)]);
var inst_45727 = fluree.db.util.log.error.call(null,inst_45719,"Cannot establish connection to a healthy server, disconnecting.");
var inst_45728 = cljs.core.async.close_BANG_.call(null,conn);
var state_45734__$1 = (function (){var statearr_45743 = state_45734;
(statearr_45743[(9)] = inst_45727);

return statearr_45743;
})();
var statearr_45744_45761 = state_45734__$1;
(statearr_45744_45761[(2)] = inst_45728);

(statearr_45744_45761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (7))){
var inst_45730 = fluree.db.connection.msg_consumer.call(null,conn);
var state_45734__$1 = state_45734;
var statearr_45745_45762 = state_45734__$1;
(statearr_45745_45762[(2)] = inst_45730);

(statearr_45745_45762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45735 === (8))){
var inst_45732 = (state_45734[(2)]);
var state_45734__$1 = state_45734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45734__$1,inst_45732);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2721__auto__ = null;
var fluree$db$connection$state_machine__2721__auto____0 = (function (){
var statearr_45746 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45746[(0)] = fluree$db$connection$state_machine__2721__auto__);

(statearr_45746[(1)] = (1));

return statearr_45746;
});
var fluree$db$connection$state_machine__2721__auto____1 = (function (state_45734){
while(true){
var ret_value__2722__auto__ = (function (){try{while(true){
var result__2723__auto__ = switch__2720__auto__.call(null,state_45734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2723__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2723__auto__;
}
break;
}
}catch (e45747){var ex__2724__auto__ = e45747;
var statearr_45748_45763 = state_45734;
(statearr_45748_45763[(2)] = ex__2724__auto__);


if(cljs.core.seq.call(null,(state_45734[(4)]))){
var statearr_45749_45764 = state_45734;
(statearr_45749_45764[(1)] = cljs.core.first.call(null,(state_45734[(4)])));

} else {
throw ex__2724__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2722__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45765 = state_45734;
state_45734 = G__45765;
continue;
} else {
return ret_value__2722__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2721__auto__ = function(state_45734){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2721__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2721__auto____1.call(this,state_45734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2721__auto____0;
fluree$db$connection$state_machine__2721__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2721__auto____1;
return fluree$db$connection$state_machine__2721__auto__;
})()
})();
var state__2745__auto__ = (function (){var statearr_45750 = f__2744__auto__.call(null);
(statearr_45750[(6)] = c__2743__auto___45754);

return statearr_45750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2745__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq45711){
var G__45712 = cljs.core.first.call(null,seq45711);
var seq45711__$1 = cljs.core.next.call(null,seq45711);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45712,seq45711__$1);
}));

