// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__66523 = opts_SINGLEQUOTE_;
var map__66523__$1 = cljs.core.__destructure_map(map__66523);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66523__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__66525 = arguments.length;
switch (G__66525) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 * 
 *     Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__66528 = arguments.length;
switch (G__66528) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__66531 = arguments.length;
switch (G__66531) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__66534 = arguments.length;
switch (G__66534) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__66537 = arguments.length;
switch (G__66537) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__66540 = arguments.length;
switch (G__66540) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66549 = arguments.length;
var i__5770__auto___66550 = (0);
while(true){
if((i__5770__auto___66550 < len__5769__auto___66549)){
args__5775__auto__.push((arguments[i__5770__auto___66550]));

var G__66551 = (i__5770__auto___66550 + (1));
i__5770__auto___66550 = G__66551;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__66545){
var vec__66546 = p__66545;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66546,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq66542){
var G__66543 = cljs.core.first(seq66542);
var seq66542__$1 = cljs.core.next(seq66542);
var G__66544 = cljs.core.first(seq66542__$1);
var seq66542__$2 = cljs.core.next(seq66542__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66543,G__66544,seq66542__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66570){
var state_val_66571 = (state_66570[(1)]);
if((state_val_66571 === (1))){
var state_66570__$1 = state_66570;
var statearr_66572_66587 = state_66570__$1;
(statearr_66572_66587[(2)] = null);

(statearr_66572_66587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66571 === (2))){
var _ = (function (){var statearr_66573 = state_66570;
(statearr_66573[(4)] = cljs.core.cons((5),(state_66570[(4)])));

return statearr_66573;
})();
var state_66570__$1 = state_66570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66570__$1,(6),db);
} else {
if((state_val_66571 === (3))){
var inst_66568 = (state_66570[(2)]);
var state_66570__$1 = state_66570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66570__$1,inst_66568);
} else {
if((state_val_66571 === (4))){
var inst_66552 = (state_66570[(2)]);
var inst_66553 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66552], 0));
var inst_66554 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66552) : reject.call(null,inst_66552));
var state_66570__$1 = (function (){var statearr_66575 = state_66570;
(statearr_66575[(7)] = inst_66553);

return statearr_66575;
})();
var statearr_66576_66588 = state_66570__$1;
(statearr_66576_66588[(2)] = inst_66554);

(statearr_66576_66588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66571 === (5))){
var _ = (function (){var statearr_66577 = state_66570;
(statearr_66577[(4)] = cljs.core.rest((state_66570[(4)])));

return statearr_66577;
})();
var state_66570__$1 = state_66570;
var ex66574 = (state_66570__$1[(2)]);
var statearr_66578_66589 = state_66570__$1;
(statearr_66578_66589[(5)] = ex66574);


var statearr_66579_66590 = state_66570__$1;
(statearr_66579_66590[(1)] = (4));

(statearr_66579_66590[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66571 === (6))){
var inst_66561 = (state_66570[(2)]);
var inst_66562 = fluree.db.util.async.throw_err(inst_66561);
var inst_66563 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_66562);
var inst_66564 = cljs.core.clj__GT_js(inst_66563);
var inst_66565 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66564) : resolve.call(null,inst_66564));
var _ = (function (){var statearr_66580 = state_66570;
(statearr_66580[(4)] = cljs.core.rest((state_66570[(4)])));

return statearr_66580;
})();
var state_66570__$1 = state_66570;
var statearr_66581_66591 = state_66570__$1;
(statearr_66581_66591[(2)] = inst_66565);

(statearr_66581_66591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2684__auto__ = null;
var flureedb$db_schema_$_state_machine__2684__auto____0 = (function (){
var statearr_66582 = [null,null,null,null,null,null,null,null];
(statearr_66582[(0)] = flureedb$db_schema_$_state_machine__2684__auto__);

(statearr_66582[(1)] = (1));

return statearr_66582;
});
var flureedb$db_schema_$_state_machine__2684__auto____1 = (function (state_66570){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66570);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66583){var ex__2687__auto__ = e66583;
var statearr_66584_66592 = state_66570;
(statearr_66584_66592[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66570[(4)]))){
var statearr_66585_66593 = state_66570;
(statearr_66585_66593[(1)] = cljs.core.first((state_66570[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66594 = state_66570;
state_66570 = G__66594;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2684__auto__ = function(state_66570){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2684__auto____1.call(this,state_66570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2684__auto____0;
flureedb$db_schema_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2684__auto____1;
return flureedb$db_schema_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66586 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66586[(6)] = c__2706__auto__);

return statearr_66586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__66596 = arguments.length;
switch (G__66596) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66666){
var state_val_66667 = (state_66666[(1)]);
if((state_val_66667 === (7))){
var inst_66609 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66666__$1 = state_66666;
var statearr_66668_66713 = state_66666__$1;
(statearr_66668_66713[(2)] = inst_66609);

(statearr_66668_66713[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (20))){
var inst_66617 = (state_66666[(7)]);
var inst_66641 = (state_66666[(2)]);
var state_66666__$1 = (function (){var statearr_66669 = state_66666;
(statearr_66669[(8)] = inst_66641);

return statearr_66669;
})();
if(cljs.core.truth_(inst_66617)){
var statearr_66670_66714 = state_66666__$1;
(statearr_66670_66714[(1)] = (21));

} else {
var statearr_66671_66715 = state_66666__$1;
(statearr_66671_66715[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (1))){
var state_66666__$1 = state_66666;
var statearr_66672_66716 = state_66666__$1;
(statearr_66672_66716[(2)] = null);

(statearr_66672_66716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (24))){
var inst_66648 = (state_66666[(2)]);
var inst_66649 = fluree.db.util.async.throw_err(inst_66648);
var state_66666__$1 = state_66666;
var statearr_66673_66717 = state_66666__$1;
(statearr_66673_66717[(2)] = inst_66649);

(statearr_66673_66717[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (4))){
var inst_66597 = (state_66666[(2)]);
var inst_66598 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66597], 0));
var inst_66599 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66597) : reject.call(null,inst_66597));
var state_66666__$1 = (function (){var statearr_66674 = state_66666;
(statearr_66674[(9)] = inst_66598);

return statearr_66674;
})();
var statearr_66675_66718 = state_66666__$1;
(statearr_66675_66718[(2)] = inst_66599);

(statearr_66675_66718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (15))){
var inst_66630 = (state_66666[(10)]);
var inst_66632 = fluree.db.util.core.without_nils(inst_66630);
var inst_66633 = fluree.db.util.json.stringify(inst_66632);
var state_66666__$1 = state_66666;
var statearr_66676_66719 = state_66666__$1;
(statearr_66676_66719[(2)] = inst_66633);

(statearr_66676_66719[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (21))){
var inst_66641 = (state_66666[(8)]);
var inst_66636 = (state_66666[(11)]);
var inst_66643 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_66644 = [inst_66636,inst_66641];
var inst_66645 = cljs.core.PersistentHashMap.fromArrays(inst_66643,inst_66644);
var inst_66646 = fluree.db.operations.command_async(conn,inst_66645);
var state_66666__$1 = state_66666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66666__$1,(24),inst_66646);
} else {
if((state_val_66667 === (13))){
var inst_66618 = (state_66666[(12)]);
var inst_66625 = (inst_66618 + (30000));
var state_66666__$1 = state_66666;
var statearr_66677_66720 = state_66666__$1;
(statearr_66677_66720[(2)] = inst_66625);

(statearr_66677_66720[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (22))){
var inst_66630 = (state_66666[(10)]);
var inst_66651 = fluree.db.operations.unsigned_command_async(conn,inst_66630);
var state_66666__$1 = state_66666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66666__$1,(25),inst_66651);
} else {
if((state_val_66667 === (6))){
var state_66666__$1 = state_66666;
var statearr_66678_66721 = state_66666__$1;
(statearr_66678_66721[(2)] = null);

(statearr_66678_66721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (25))){
var inst_66653 = (state_66666[(2)]);
var inst_66654 = fluree.db.util.async.throw_err(inst_66653);
var state_66666__$1 = state_66666;
var statearr_66679_66722 = state_66666__$1;
(statearr_66679_66722[(2)] = inst_66654);

(statearr_66679_66722[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (17))){
var inst_66617 = (state_66666[(7)]);
var inst_66636 = (state_66666[(2)]);
var state_66666__$1 = (function (){var statearr_66680 = state_66666;
(statearr_66680[(11)] = inst_66636);

return statearr_66680;
})();
if(cljs.core.truth_(inst_66617)){
var statearr_66681_66723 = state_66666__$1;
(statearr_66681_66723[(1)] = (18));

} else {
var statearr_66682_66724 = state_66666__$1;
(statearr_66682_66724[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (3))){
var inst_66664 = (state_66666[(2)]);
var state_66666__$1 = state_66666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66666__$1,inst_66664);
} else {
if((state_val_66667 === (12))){
var inst_66615 = (state_66666[(13)]);
var state_66666__$1 = state_66666;
var statearr_66683_66725 = state_66666__$1;
(statearr_66683_66725[(2)] = inst_66615);

(statearr_66683_66725[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (2))){
var _ = (function (){var statearr_66684 = state_66666;
(statearr_66684[(4)] = cljs.core.cons((5),(state_66666[(4)])));

return statearr_66684;
})();
var inst_66606 = (opts == null);
var state_66666__$1 = state_66666;
if(cljs.core.truth_(inst_66606)){
var statearr_66685_66726 = state_66666__$1;
(statearr_66685_66726[(1)] = (6));

} else {
var statearr_66686_66727 = state_66666__$1;
(statearr_66686_66727[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (23))){
var inst_66656 = (state_66666[(2)]);
var inst_66657 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66658 = [(200),inst_66656];
var inst_66659 = cljs.core.PersistentHashMap.fromArrays(inst_66657,inst_66658);
var inst_66660 = cljs.core.clj__GT_js(inst_66659);
var inst_66661 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66660) : resolve.call(null,inst_66660));
var _ = (function (){var statearr_66687 = state_66666;
(statearr_66687[(4)] = cljs.core.rest((state_66666[(4)])));

return statearr_66687;
})();
var state_66666__$1 = state_66666;
var statearr_66688_66728 = state_66666__$1;
(statearr_66688_66728[(2)] = inst_66661);

(statearr_66688_66728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (19))){
var state_66666__$1 = state_66666;
var statearr_66689_66729 = state_66666__$1;
(statearr_66689_66729[(2)] = null);

(statearr_66689_66729[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (11))){
var inst_66615 = (state_66666[(13)]);
var inst_66622 = (state_66666[(2)]);
var state_66666__$1 = (function (){var statearr_66691 = state_66666;
(statearr_66691[(14)] = inst_66622);

return statearr_66691;
})();
if(cljs.core.truth_(inst_66615)){
var statearr_66692_66730 = state_66666__$1;
(statearr_66692_66730[(1)] = (12));

} else {
var statearr_66693_66731 = state_66666__$1;
(statearr_66693_66731[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (9))){
var inst_66614 = (state_66666[(15)]);
var state_66666__$1 = state_66666;
var statearr_66694_66732 = state_66666__$1;
(statearr_66694_66732[(2)] = inst_66614);

(statearr_66694_66732[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (5))){
var _ = (function (){var statearr_66695 = state_66666;
(statearr_66695[(4)] = cljs.core.rest((state_66666[(4)])));

return statearr_66695;
})();
var state_66666__$1 = state_66666;
var ex66690 = (state_66666__$1[(2)]);
var statearr_66696_66733 = state_66666__$1;
(statearr_66696_66733[(5)] = ex66690);


var statearr_66697_66734 = state_66666__$1;
(statearr_66697_66734[(1)] = (4));

(statearr_66697_66734[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (14))){
var inst_66622 = (state_66666[(14)]);
var inst_66617 = (state_66666[(7)]);
var inst_66627 = (state_66666[(2)]);
var inst_66628 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_66629 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_66622,inst_66627];
var inst_66630 = cljs.core.PersistentHashMap.fromArrays(inst_66628,inst_66629);
var state_66666__$1 = (function (){var statearr_66698 = state_66666;
(statearr_66698[(10)] = inst_66630);

return statearr_66698;
})();
if(cljs.core.truth_(inst_66617)){
var statearr_66699_66735 = state_66666__$1;
(statearr_66699_66735[(1)] = (15));

} else {
var statearr_66700_66736 = state_66666__$1;
(statearr_66700_66736[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (16))){
var state_66666__$1 = state_66666;
var statearr_66701_66737 = state_66666__$1;
(statearr_66701_66737[(2)] = null);

(statearr_66701_66737[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (10))){
var inst_66618 = (state_66666[(12)]);
var state_66666__$1 = state_66666;
var statearr_66702_66738 = state_66666__$1;
(statearr_66702_66738[(2)] = inst_66618);

(statearr_66702_66738[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (18))){
var inst_66636 = (state_66666[(11)]);
var inst_66617 = (state_66666[(7)]);
var inst_66638 = fluree.crypto.sign_message(inst_66636,inst_66617);
var state_66666__$1 = state_66666;
var statearr_66703_66739 = state_66666__$1;
(statearr_66703_66739[(2)] = inst_66638);

(statearr_66703_66739[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (8))){
var inst_66614 = (state_66666[(15)]);
var inst_66611 = (state_66666[(2)]);
var inst_66612 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66611);
var inst_66613 = cljs.core.__destructure_map(inst_66611);
var inst_66614__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66613,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_66615 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66613,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_66616 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66613,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_66617 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66613,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_66618 = fluree.db.util.core.current_time_millis();
var state_66666__$1 = (function (){var statearr_66704 = state_66666;
(statearr_66704[(13)] = inst_66615);

(statearr_66704[(16)] = inst_66616);

(statearr_66704[(17)] = inst_66612);

(statearr_66704[(15)] = inst_66614__$1);

(statearr_66704[(7)] = inst_66617);

(statearr_66704[(12)] = inst_66618);

return statearr_66704;
})();
if(cljs.core.truth_(inst_66614__$1)){
var statearr_66705_66740 = state_66666__$1;
(statearr_66705_66740[(1)] = (9));

} else {
var statearr_66706_66741 = state_66666__$1;
(statearr_66706_66741[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_66707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66707[(0)] = flureedb$state_machine__2684__auto__);

(statearr_66707[(1)] = (1));

return statearr_66707;
});
var flureedb$state_machine__2684__auto____1 = (function (state_66666){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66666);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66708){var ex__2687__auto__ = e66708;
var statearr_66709_66742 = state_66666;
(statearr_66709_66742[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66666[(4)]))){
var statearr_66710_66743 = state_66666;
(statearr_66710_66743[(1)] = cljs.core.first((state_66666[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66744 = state_66666;
state_66666 = G__66744;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_66666){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_66666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66711 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66711[(6)] = c__2706__auto__);

return statearr_66711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *    If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66763){
var state_val_66764 = (state_66763[(1)]);
if((state_val_66764 === (1))){
var state_66763__$1 = state_66763;
var statearr_66765_66780 = state_66763__$1;
(statearr_66765_66780[(2)] = null);

(statearr_66765_66780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66764 === (2))){
var _ = (function (){var statearr_66766 = state_66763;
(statearr_66766[(4)] = cljs.core.cons((5),(state_66763[(4)])));

return statearr_66766;
})();
var inst_66753 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_66763__$1 = state_66763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66763__$1,(6),inst_66753);
} else {
if((state_val_66764 === (3))){
var inst_66761 = (state_66763[(2)]);
var state_66763__$1 = state_66763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66763__$1,inst_66761);
} else {
if((state_val_66764 === (4))){
var inst_66745 = (state_66763[(2)]);
var inst_66746 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66745], 0));
var inst_66747 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66745) : reject.call(null,inst_66745));
var state_66763__$1 = (function (){var statearr_66768 = state_66763;
(statearr_66768[(7)] = inst_66746);

return statearr_66768;
})();
var statearr_66769_66781 = state_66763__$1;
(statearr_66769_66781[(2)] = inst_66747);

(statearr_66769_66781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66764 === (5))){
var _ = (function (){var statearr_66770 = state_66763;
(statearr_66770[(4)] = cljs.core.rest((state_66763[(4)])));

return statearr_66770;
})();
var state_66763__$1 = state_66763;
var ex66767 = (state_66763__$1[(2)]);
var statearr_66771_66782 = state_66763__$1;
(statearr_66771_66782[(5)] = ex66767);


var statearr_66772_66783 = state_66763__$1;
(statearr_66772_66783[(1)] = (4));

(statearr_66772_66783[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66764 === (6))){
var inst_66755 = (state_66763[(2)]);
var inst_66756 = fluree.db.util.async.throw_err(inst_66755);
var inst_66757 = cljs.core.clj__GT_js(inst_66756);
var inst_66758 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66757) : resolve.call(null,inst_66757));
var _ = (function (){var statearr_66773 = state_66763;
(statearr_66773[(4)] = cljs.core.rest((state_66763[(4)])));

return statearr_66773;
})();
var state_66763__$1 = state_66763;
var statearr_66774_66784 = state_66763__$1;
(statearr_66774_66784[(2)] = inst_66758);

(statearr_66774_66784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2684__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2684__auto____0 = (function (){
var statearr_66775 = [null,null,null,null,null,null,null,null];
(statearr_66775[(0)] = flureedb$ledger_stats_$_state_machine__2684__auto__);

(statearr_66775[(1)] = (1));

return statearr_66775;
});
var flureedb$ledger_stats_$_state_machine__2684__auto____1 = (function (state_66763){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66763);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66776){var ex__2687__auto__ = e66776;
var statearr_66777_66785 = state_66763;
(statearr_66777_66785[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66763[(4)]))){
var statearr_66778_66786 = state_66763;
(statearr_66778_66786[(1)] = cljs.core.first((state_66763[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66787 = state_66763;
state_66763 = G__66787;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2684__auto__ = function(state_66763){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2684__auto____1.call(this,state_66763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2684__auto____0;
flureedb$ledger_stats_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2684__auto____1;
return flureedb$ledger_stats_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66779 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66779[(6)] = c__2706__auto__);

return statearr_66779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 *     - :jwt         - token for Fluree On-Demand access
 *     
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__66789 = arguments.length;
switch (G__66789) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66913){
var state_val_66914 = (state_66913[(1)]);
if((state_val_66914 === (7))){
var inst_66812 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66913__$1 = state_66913;
var statearr_66915_66985 = state_66913__$1;
(statearr_66915_66985[(2)] = inst_66812);

(statearr_66915_66985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (20))){
var inst_66819 = (state_66913[(7)]);
var inst_66858 = (state_66913[(2)]);
var inst_66859 = fluree.db.util.core.current_time_millis();
var state_66913__$1 = (function (){var statearr_66916 = state_66913;
(statearr_66916[(8)] = inst_66858);

(statearr_66916[(9)] = inst_66859);

return statearr_66916;
})();
if(cljs.core.truth_(inst_66819)){
var statearr_66917_66986 = state_66913__$1;
(statearr_66917_66986[(1)] = (21));

} else {
var statearr_66918_66987 = state_66913__$1;
(statearr_66918_66987[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (27))){
var inst_66872 = (state_66913[(10)]);
var inst_66827 = (state_66913[(11)]);
var inst_66874 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66872,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_66827);
var state_66913__$1 = state_66913;
var statearr_66919_66988 = state_66913__$1;
(statearr_66919_66988[(2)] = inst_66874);

(statearr_66919_66988[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (1))){
var state_66913__$1 = state_66913;
var statearr_66920_66989 = state_66913__$1;
(statearr_66920_66989[(2)] = null);

(statearr_66920_66989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (24))){
var inst_66825 = (state_66913[(12)]);
var state_66913__$1 = state_66913;
var statearr_66921_66990 = state_66913__$1;
(statearr_66921_66990[(2)] = inst_66825);

(statearr_66921_66990[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (39))){
var inst_66895 = (state_66913[(2)]);
var inst_66896 = fluree.db.util.async.throw_err(inst_66895);
var state_66913__$1 = state_66913;
var statearr_66922_66991 = state_66913__$1;
(statearr_66922_66991[(2)] = inst_66896);

(statearr_66922_66991[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (4))){
var inst_66790 = (state_66913[(2)]);
var inst_66791 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66790], 0));
var inst_66792 = cljs.core.ex_data(inst_66790);
var inst_66793 = cljs.core.ex_message(inst_66790);
var inst_66794 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66792,new cljs.core.Keyword(null,"message","message",-406056002),inst_66793);
var inst_66795 = cljs.core.clj__GT_js(inst_66794);
var inst_66796 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66795) : reject.call(null,inst_66795));
var state_66913__$1 = (function (){var statearr_66923 = state_66913;
(statearr_66923[(13)] = inst_66791);

return statearr_66923;
})();
var statearr_66924_66992 = state_66913__$1;
(statearr_66924_66992[(2)] = inst_66796);

(statearr_66924_66992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (15))){
var inst_66848 = (state_66913[(14)]);
var inst_66850 = fluree.db.graphdb.validate_ledger_name(inst_66848,"alias");
var state_66913__$1 = state_66913;
var statearr_66925_66993 = state_66913__$1;
(statearr_66925_66993[(2)] = inst_66850);

(statearr_66925_66993[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (21))){
var inst_66819 = (state_66913[(7)]);
var state_66913__$1 = state_66913;
var statearr_66926_66994 = state_66913__$1;
(statearr_66926_66994[(2)] = inst_66819);

(statearr_66926_66994[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (31))){
var state_66913__$1 = state_66913;
var statearr_66927_66995 = state_66913__$1;
(statearr_66927_66995[(2)] = null);

(statearr_66927_66995[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (32))){
var inst_66821 = (state_66913[(15)]);
var inst_66883 = (state_66913[(2)]);
var state_66913__$1 = (function (){var statearr_66928 = state_66913;
(statearr_66928[(16)] = inst_66883);

return statearr_66928;
})();
if(cljs.core.truth_(inst_66821)){
var statearr_66929_66996 = state_66913__$1;
(statearr_66929_66996[(1)] = (33));

} else {
var statearr_66930_66997 = state_66913__$1;
(statearr_66930_66997[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (40))){
var inst_66900 = (state_66913[(2)]);
var inst_66901 = fluree.db.util.async.throw_err(inst_66900);
var state_66913__$1 = state_66913;
var statearr_66931_66998 = state_66913__$1;
(statearr_66931_66998[(2)] = inst_66901);

(statearr_66931_66998[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (33))){
var inst_66883 = (state_66913[(16)]);
var inst_66821 = (state_66913[(15)]);
var inst_66885 = fluree.crypto.sign_message(inst_66883,inst_66821);
var state_66913__$1 = state_66913;
var statearr_66932_66999 = state_66913__$1;
(statearr_66932_66999[(2)] = inst_66885);

(statearr_66932_66999[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (13))){
var state_66913__$1 = state_66913;
var statearr_66933_67000 = state_66913__$1;
(statearr_66933_67000[(2)] = null);

(statearr_66933_67000[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (22))){
var inst_66859 = (state_66913[(9)]);
var state_66913__$1 = state_66913;
var statearr_66934_67001 = state_66913__$1;
(statearr_66934_67001[(2)] = inst_66859);

(statearr_66934_67001[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (36))){
var inst_66883 = (state_66913[(16)]);
var inst_66888 = (state_66913[(17)]);
var inst_66890 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_66891 = [inst_66883,inst_66888];
var inst_66892 = cljs.core.PersistentHashMap.fromArrays(inst_66890,inst_66891);
var inst_66893 = fluree.db.operations.command_async(conn,inst_66892);
var state_66913__$1 = state_66913;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66913__$1,(39),inst_66893);
} else {
if((state_val_66914 === (29))){
var inst_66821 = (state_66913[(15)]);
var inst_66877 = (state_66913[(2)]);
var state_66913__$1 = (function (){var statearr_66935 = state_66913;
(statearr_66935[(18)] = inst_66877);

return statearr_66935;
})();
if(cljs.core.truth_(inst_66821)){
var statearr_66936_67002 = state_66913__$1;
(statearr_66936_67002[(1)] = (30));

} else {
var statearr_66937_67003 = state_66913__$1;
(statearr_66937_67003[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (6))){
var state_66913__$1 = state_66913;
var statearr_66938_67004 = state_66913__$1;
(statearr_66938_67004[(2)] = null);

(statearr_66938_67004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (28))){
var inst_66872 = (state_66913[(10)]);
var state_66913__$1 = state_66913;
var statearr_66939_67005 = state_66913__$1;
(statearr_66939_67005[(2)] = inst_66872);

(statearr_66939_67005[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (25))){
var inst_66859 = (state_66913[(9)]);
var inst_66866 = (inst_66859 + (30000));
var state_66913__$1 = state_66913;
var statearr_66940_67006 = state_66913__$1;
(statearr_66940_67006[(2)] = inst_66866);

(statearr_66940_67006[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (34))){
var state_66913__$1 = state_66913;
var statearr_66941_67007 = state_66913__$1;
(statearr_66941_67007[(2)] = null);

(statearr_66941_67007[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (17))){
var inst_66829 = (state_66913[(19)]);
var inst_66853 = (state_66913[(2)]);
var state_66913__$1 = (function (){var statearr_66942 = state_66913;
(statearr_66942[(20)] = inst_66853);

return statearr_66942;
})();
if(cljs.core.truth_(inst_66829)){
var statearr_66943_67008 = state_66913__$1;
(statearr_66943_67008[(1)] = (18));

} else {
var statearr_66944_67009 = state_66913__$1;
(statearr_66944_67009[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (3))){
var inst_66911 = (state_66913[(2)]);
var state_66913__$1 = state_66913;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66913__$1,inst_66911);
} else {
if((state_val_66914 === (12))){
var inst_66843 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_66913__$1 = state_66913;
var statearr_66945_67010 = state_66913__$1;
(statearr_66945_67010[(2)] = inst_66843);

(statearr_66945_67010[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (2))){
var _ = (function (){var statearr_66946 = state_66913;
(statearr_66946[(4)] = cljs.core.cons((5),(state_66913[(4)])));

return statearr_66946;
})();
var inst_66809 = (opts == null);
var state_66913__$1 = state_66913;
if(cljs.core.truth_(inst_66809)){
var statearr_66947_67011 = state_66913__$1;
(statearr_66947_67011[(1)] = (6));

} else {
var statearr_66948_67012 = state_66913__$1;
(statearr_66948_67012[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (23))){
var inst_66825 = (state_66913[(12)]);
var inst_66863 = (state_66913[(2)]);
var state_66913__$1 = (function (){var statearr_66949 = state_66913;
(statearr_66949[(21)] = inst_66863);

return statearr_66949;
})();
if(cljs.core.truth_(inst_66825)){
var statearr_66950_67013 = state_66913__$1;
(statearr_66950_67013[(1)] = (24));

} else {
var statearr_66951_67014 = state_66913__$1;
(statearr_66951_67014[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (35))){
var inst_66821 = (state_66913[(15)]);
var inst_66888 = (state_66913[(2)]);
var state_66913__$1 = (function (){var statearr_66952 = state_66913;
(statearr_66952[(17)] = inst_66888);

return statearr_66952;
})();
if(cljs.core.truth_(inst_66821)){
var statearr_66953_67015 = state_66913__$1;
(statearr_66953_67015[(1)] = (36));

} else {
var statearr_66954_67016 = state_66913__$1;
(statearr_66954_67016[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (19))){
var state_66913__$1 = state_66913;
var statearr_66955_67017 = state_66913__$1;
(statearr_66955_67017[(2)] = null);

(statearr_66955_67017[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (11))){
var inst_66832 = (state_66913[(22)]);
var inst_66829 = (state_66913[(19)]);
var inst_66839 = (state_66913[(23)]);
var inst_66839__$1 = (state_66913[(2)]);
var inst_66840 = fluree.db.graphdb.validate_ledger_name(inst_66839__$1,"ledger");
var inst_66841 = fluree.db.graphdb.validate_ledger_name(inst_66832,"network");
var state_66913__$1 = (function (){var statearr_66957 = state_66913;
(statearr_66957[(24)] = inst_66840);

(statearr_66957[(25)] = inst_66841);

(statearr_66957[(23)] = inst_66839__$1);

return statearr_66957;
})();
if(cljs.core.truth_(inst_66829)){
var statearr_66958_67018 = state_66913__$1;
(statearr_66958_67018[(1)] = (12));

} else {
var statearr_66959_67019 = state_66913__$1;
(statearr_66959_67019[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (9))){
var inst_66833 = (state_66913[(26)]);
var inst_66836 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_66833,(1));
var state_66913__$1 = state_66913;
var statearr_66960_67020 = state_66913__$1;
(statearr_66960_67020[(2)] = inst_66836);

(statearr_66960_67020[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (5))){
var _ = (function (){var statearr_66961 = state_66913;
(statearr_66961[(4)] = cljs.core.rest((state_66913[(4)])));

return statearr_66961;
})();
var state_66913__$1 = state_66913;
var ex66956 = (state_66913__$1[(2)]);
var statearr_66962_67021 = state_66913__$1;
(statearr_66962_67021[(5)] = ex66956);


var statearr_66963_67022 = state_66913__$1;
(statearr_66963_67022[(1)] = (4));

(statearr_66963_67022[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (14))){
var inst_66829 = (state_66913[(19)]);
var inst_66846 = (state_66913[(2)]);
var inst_66847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66846,(0),null);
var inst_66848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66846,(1),null);
var state_66913__$1 = (function (){var statearr_66964 = state_66913;
(statearr_66964[(14)] = inst_66848);

(statearr_66964[(27)] = inst_66847);

return statearr_66964;
})();
if(cljs.core.truth_(inst_66829)){
var statearr_66965_67023 = state_66913__$1;
(statearr_66965_67023[(1)] = (15));

} else {
var statearr_66966_67024 = state_66913__$1;
(statearr_66966_67024[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (26))){
var inst_66823 = (state_66913[(28)]);
var inst_66863 = (state_66913[(21)]);
var inst_66832 = (state_66913[(22)]);
var inst_66826 = (state_66913[(29)]);
var inst_66822 = (state_66913[(30)]);
var inst_66830 = (state_66913[(31)]);
var inst_66818 = (state_66913[(32)]);
var inst_66839 = (state_66913[(23)]);
var inst_66820 = (state_66913[(33)]);
var inst_66824 = (state_66913[(34)]);
var inst_66828 = (state_66913[(35)]);
var inst_66858 = (state_66913[(8)]);
var inst_66827 = (state_66913[(11)]);
var inst_66868 = (state_66913[(2)]);
var inst_66869 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_66870 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66832),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66839)].join('');
var inst_66871 = [inst_66870,inst_66823,inst_66824,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_66868,inst_66826,inst_66858,inst_66830,inst_66828,inst_66818,inst_66863,inst_66820,inst_66822];
var inst_66872 = cljs.core.PersistentHashMap.fromArrays(inst_66869,inst_66871);
var state_66913__$1 = (function (){var statearr_66967 = state_66913;
(statearr_66967[(10)] = inst_66872);

return statearr_66967;
})();
if(cljs.core.truth_(inst_66827)){
var statearr_66968_67025 = state_66913__$1;
(statearr_66968_67025[(1)] = (27));

} else {
var statearr_66969_67026 = state_66913__$1;
(statearr_66969_67026[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (16))){
var state_66913__$1 = state_66913;
var statearr_66970_67027 = state_66913__$1;
(statearr_66970_67027[(2)] = null);

(statearr_66970_67027[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (38))){
var inst_66903 = (state_66913[(2)]);
var inst_66904 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66905 = [(200),inst_66903];
var inst_66906 = cljs.core.PersistentHashMap.fromArrays(inst_66904,inst_66905);
var inst_66907 = cljs.core.clj__GT_js(inst_66906);
var inst_66908 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66907) : resolve.call(null,inst_66907));
var _ = (function (){var statearr_66971 = state_66913;
(statearr_66971[(4)] = cljs.core.rest((state_66913[(4)])));

return statearr_66971;
})();
var state_66913__$1 = state_66913;
var statearr_66972_67028 = state_66913__$1;
(statearr_66972_67028[(2)] = inst_66908);

(statearr_66972_67028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (30))){
var inst_66877 = (state_66913[(18)]);
var inst_66879 = fluree.db.util.core.without_nils(inst_66877);
var inst_66880 = fluree.db.util.json.stringify(inst_66879);
var state_66913__$1 = state_66913;
var statearr_66973_67029 = state_66913__$1;
(statearr_66973_67029[(2)] = inst_66880);

(statearr_66973_67029[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (10))){
var inst_66833 = (state_66913[(26)]);
var state_66913__$1 = state_66913;
var statearr_66974_67030 = state_66913__$1;
(statearr_66974_67030[(2)] = inst_66833);

(statearr_66974_67030[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (18))){
var inst_66848 = (state_66913[(14)]);
var inst_66847 = (state_66913[(27)]);
var inst_66855 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66847),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66848)].join('');
var state_66913__$1 = state_66913;
var statearr_66975_67031 = state_66913__$1;
(statearr_66975_67031[(2)] = inst_66855);

(statearr_66975_67031[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (37))){
var inst_66877 = (state_66913[(18)]);
var inst_66898 = fluree.db.operations.unsigned_command_async(conn,inst_66877);
var state_66913__$1 = state_66913;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66913__$1,(40),inst_66898);
} else {
if((state_val_66914 === (8))){
var inst_66833 = (state_66913[(26)]);
var inst_66814 = (state_66913[(2)]);
var inst_66815 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66814);
var inst_66816 = cljs.core.__destructure_map(inst_66814);
var inst_66817 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66816,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_66818 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_66819 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_66820 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_66821 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_66822 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_66823 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_66824 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_66825 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_66826 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_66827 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_66828 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_66829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_66830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66816,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_66831 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_66832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66831,(0),null);
var inst_66833__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66831,(1),null);
var inst_66834 = clojure.string.starts_with_QMARK_(inst_66833__$1,"$");
var state_66913__$1 = (function (){var statearr_66976 = state_66913;
(statearr_66976[(28)] = inst_66823);

(statearr_66976[(15)] = inst_66821);

(statearr_66976[(22)] = inst_66832);

(statearr_66976[(12)] = inst_66825);

(statearr_66976[(29)] = inst_66826);

(statearr_66976[(30)] = inst_66822);

(statearr_66976[(31)] = inst_66830);

(statearr_66976[(19)] = inst_66829);

(statearr_66976[(32)] = inst_66818);

(statearr_66976[(26)] = inst_66833__$1);

(statearr_66976[(33)] = inst_66820);

(statearr_66976[(34)] = inst_66824);

(statearr_66976[(36)] = inst_66815);

(statearr_66976[(35)] = inst_66828);

(statearr_66976[(11)] = inst_66827);

(statearr_66976[(37)] = inst_66817);

(statearr_66976[(7)] = inst_66819);

return statearr_66976;
})();
if(inst_66834){
var statearr_66977_67032 = state_66913__$1;
(statearr_66977_67032[(1)] = (9));

} else {
var statearr_66978_67033 = state_66913__$1;
(statearr_66978_67033[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_66979 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66979[(0)] = flureedb$state_machine__2684__auto__);

(statearr_66979[(1)] = (1));

return statearr_66979;
});
var flureedb$state_machine__2684__auto____1 = (function (state_66913){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66913);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66980){var ex__2687__auto__ = e66980;
var statearr_66981_67034 = state_66913;
(statearr_66981_67034[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66913[(4)]))){
var statearr_66982_67035 = state_66913;
(statearr_66982_67035[(1)] = cljs.core.first((state_66913[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67036 = state_66913;
state_66913 = G__67036;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_66913){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_66913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66983 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66983[(6)] = c__2706__auto__);

return statearr_66983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67056){
var state_val_67057 = (state_67056[(1)]);
if((state_val_67057 === (1))){
var state_67056__$1 = state_67056;
var statearr_67058_67074 = state_67056__$1;
(statearr_67058_67074[(2)] = null);

(statearr_67058_67074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67057 === (2))){
var _ = (function (){var statearr_67059 = state_67056;
(statearr_67059[(4)] = cljs.core.cons((5),(state_67056[(4)])));

return statearr_67059;
})();
var inst_67046 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_67047 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_67056__$1 = (function (){var statearr_67060 = state_67056;
(statearr_67060[(7)] = inst_67046);

return statearr_67060;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67056__$1,(6),inst_67047);
} else {
if((state_val_67057 === (3))){
var inst_67054 = (state_67056[(2)]);
var state_67056__$1 = state_67056;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67056__$1,inst_67054);
} else {
if((state_val_67057 === (4))){
var inst_67037 = (state_67056[(2)]);
var inst_67038 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67037], 0));
var inst_67039 = cljs.core.clj__GT_js(inst_67037);
var inst_67040 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67039) : reject.call(null,inst_67039));
var state_67056__$1 = (function (){var statearr_67062 = state_67056;
(statearr_67062[(8)] = inst_67038);

return statearr_67062;
})();
var statearr_67063_67075 = state_67056__$1;
(statearr_67063_67075[(2)] = inst_67040);

(statearr_67063_67075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67057 === (5))){
var _ = (function (){var statearr_67064 = state_67056;
(statearr_67064[(4)] = cljs.core.rest((state_67056[(4)])));

return statearr_67064;
})();
var state_67056__$1 = state_67056;
var ex67061 = (state_67056__$1[(2)]);
var statearr_67065_67076 = state_67056__$1;
(statearr_67065_67076[(5)] = ex67061);


var statearr_67066_67077 = state_67056__$1;
(statearr_67066_67077[(1)] = (4));

(statearr_67066_67077[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67057 === (6))){
var inst_67049 = (state_67056[(2)]);
var inst_67050 = cljs.core.clj__GT_js(inst_67049);
var inst_67051 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67050) : resolve.call(null,inst_67050));
var _ = (function (){var statearr_67067 = state_67056;
(statearr_67067[(4)] = cljs.core.rest((state_67056[(4)])));

return statearr_67067;
})();
var state_67056__$1 = state_67056;
var statearr_67068_67078 = state_67056__$1;
(statearr_67068_67078[(2)] = inst_67051);

(statearr_67068_67078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2684__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2684__auto____0 = (function (){
var statearr_67069 = [null,null,null,null,null,null,null,null,null];
(statearr_67069[(0)] = flureedb$monitor_tx_$_state_machine__2684__auto__);

(statearr_67069[(1)] = (1));

return statearr_67069;
});
var flureedb$monitor_tx_$_state_machine__2684__auto____1 = (function (state_67056){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67056);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67070){var ex__2687__auto__ = e67070;
var statearr_67071_67079 = state_67056;
(statearr_67071_67079[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67056[(4)]))){
var statearr_67072_67080 = state_67056;
(statearr_67072_67080[(1)] = cljs.core.first((state_67056[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67081 = state_67056;
state_67056 = G__67081;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2684__auto__ = function(state_67056){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2684__auto____1.call(this,state_67056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2684__auto____0;
flureedb$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2684__auto____1;
return flureedb$monitor_tx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67073 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67073[(6)] = c__2706__auto__);

return statearr_67073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 *     - jwt         - token to access Fluree On-Demand
 *     
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__67083 = arguments.length;
switch (G__67083) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67109){
var state_val_67110 = (state_67109[(1)]);
if((state_val_67110 === (7))){
var inst_67095 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67109__$1 = state_67109;
var statearr_67111_67132 = state_67109__$1;
(statearr_67111_67132[(2)] = inst_67095);

(statearr_67111_67132[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (1))){
var state_67109__$1 = state_67109;
var statearr_67112_67133 = state_67109__$1;
(statearr_67112_67133[(2)] = null);

(statearr_67112_67133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (4))){
var inst_67084 = (state_67109[(2)]);
var inst_67085 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67084], 0));
var inst_67086 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67084) : reject.call(null,inst_67084));
var state_67109__$1 = (function (){var statearr_67113 = state_67109;
(statearr_67113[(7)] = inst_67085);

return statearr_67113;
})();
var statearr_67114_67134 = state_67109__$1;
(statearr_67114_67134[(2)] = inst_67086);

(statearr_67114_67134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (6))){
var state_67109__$1 = state_67109;
var statearr_67115_67135 = state_67109__$1;
(statearr_67115_67135[(2)] = null);

(statearr_67115_67135[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (3))){
var inst_67107 = (state_67109[(2)]);
var state_67109__$1 = state_67109;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67109__$1,inst_67107);
} else {
if((state_val_67110 === (2))){
var _ = (function (){var statearr_67117 = state_67109;
(statearr_67117[(4)] = cljs.core.cons((5),(state_67109[(4)])));

return statearr_67117;
})();
var inst_67092 = (opts == null);
var state_67109__$1 = state_67109;
if(cljs.core.truth_(inst_67092)){
var statearr_67118_67136 = state_67109__$1;
(statearr_67118_67136[(1)] = (6));

} else {
var statearr_67119_67137 = state_67109__$1;
(statearr_67119_67137[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (9))){
var inst_67102 = (state_67109[(2)]);
var inst_67103 = cljs.core.clj__GT_js(inst_67102);
var inst_67104 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67103) : resolve.call(null,inst_67103));
var _ = (function (){var statearr_67120 = state_67109;
(statearr_67120[(4)] = cljs.core.rest((state_67109[(4)])));

return statearr_67120;
})();
var state_67109__$1 = state_67109;
var statearr_67121_67138 = state_67109__$1;
(statearr_67121_67138[(2)] = inst_67104);

(statearr_67121_67138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (5))){
var _ = (function (){var statearr_67122 = state_67109;
(statearr_67122[(4)] = cljs.core.rest((state_67109[(4)])));

return statearr_67122;
})();
var state_67109__$1 = state_67109;
var ex67116 = (state_67109__$1[(2)]);
var statearr_67123_67139 = state_67109__$1;
(statearr_67123_67139[(5)] = ex67116);


var statearr_67124_67140 = state_67109__$1;
(statearr_67124_67140[(1)] = (4));

(statearr_67124_67140[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (8))){
var inst_67097 = (state_67109[(2)]);
var inst_67098 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67097);
var inst_67099 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67100 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67099,inst_67097);
var state_67109__$1 = (function (){var statearr_67125 = state_67109;
(statearr_67125[(8)] = inst_67098);

return statearr_67125;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67109__$1,(9),inst_67100);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_67126 = [null,null,null,null,null,null,null,null,null];
(statearr_67126[(0)] = flureedb$state_machine__2684__auto__);

(statearr_67126[(1)] = (1));

return statearr_67126;
});
var flureedb$state_machine__2684__auto____1 = (function (state_67109){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67109);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67127){var ex__2687__auto__ = e67127;
var statearr_67128_67141 = state_67109;
(statearr_67128_67141[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67109[(4)]))){
var statearr_67129_67142 = state_67109;
(statearr_67129_67142[(1)] = cljs.core.first((state_67109[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67143 = state_67109;
state_67109 = G__67143;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_67109){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_67109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67130 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67130[(6)] = c__2706__auto__);

return statearr_67130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *    to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *    :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__67145 = arguments.length;
switch (G__67145) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67174){
var state_val_67175 = (state_67174[(1)]);
if((state_val_67175 === (7))){
var inst_67157 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67174__$1 = state_67174;
var statearr_67176_67197 = state_67174__$1;
(statearr_67176_67197[(2)] = inst_67157);

(statearr_67176_67197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67175 === (1))){
var state_67174__$1 = state_67174;
var statearr_67177_67198 = state_67174__$1;
(statearr_67177_67198[(2)] = null);

(statearr_67177_67198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67175 === (4))){
var inst_67146 = (state_67174[(2)]);
var inst_67147 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67146], 0));
var inst_67148 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67146) : reject.call(null,inst_67146));
var state_67174__$1 = (function (){var statearr_67178 = state_67174;
(statearr_67178[(7)] = inst_67147);

return statearr_67178;
})();
var statearr_67179_67199 = state_67174__$1;
(statearr_67179_67199[(2)] = inst_67148);

(statearr_67179_67199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67175 === (6))){
var state_67174__$1 = state_67174;
var statearr_67180_67200 = state_67174__$1;
(statearr_67180_67200[(2)] = null);

(statearr_67180_67200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67175 === (3))){
var inst_67172 = (state_67174[(2)]);
var state_67174__$1 = state_67174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67174__$1,inst_67172);
} else {
if((state_val_67175 === (2))){
var _ = (function (){var statearr_67182 = state_67174;
(statearr_67182[(4)] = cljs.core.cons((5),(state_67174[(4)])));

return statearr_67182;
})();
var inst_67154 = (opts == null);
var state_67174__$1 = state_67174;
if(cljs.core.truth_(inst_67154)){
var statearr_67183_67201 = state_67174__$1;
(statearr_67183_67201[(1)] = (6));

} else {
var statearr_67184_67202 = state_67174__$1;
(statearr_67184_67202[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67175 === (9))){
var inst_67159 = (state_67174[(8)]);
var inst_67162 = (state_67174[(2)]);
var inst_67163 = fluree.db.util.async.throw_err(inst_67162);
var inst_67164 = fluree.db.query.block.block_range(inst_67163,start,end,inst_67159);
var state_67174__$1 = state_67174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67174__$1,(10),inst_67164);
} else {
if((state_val_67175 === (5))){
var _ = (function (){var statearr_67185 = state_67174;
(statearr_67185[(4)] = cljs.core.rest((state_67174[(4)])));

return statearr_67185;
})();
var state_67174__$1 = state_67174;
var ex67181 = (state_67174__$1[(2)]);
var statearr_67186_67203 = state_67174__$1;
(statearr_67186_67203[(5)] = ex67181);


var statearr_67187_67204 = state_67174__$1;
(statearr_67187_67204[(1)] = (4));

(statearr_67187_67204[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67175 === (10))){
var inst_67166 = (state_67174[(2)]);
var inst_67167 = fluree.db.util.async.throw_err(inst_67166);
var inst_67168 = cljs.core.clj__GT_js(inst_67167);
var inst_67169 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67168) : resolve.call(null,inst_67168));
var _ = (function (){var statearr_67188 = state_67174;
(statearr_67188[(4)] = cljs.core.rest((state_67174[(4)])));

return statearr_67188;
})();
var state_67174__$1 = state_67174;
var statearr_67189_67205 = state_67174__$1;
(statearr_67189_67205[(2)] = inst_67169);

(statearr_67189_67205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67175 === (8))){
var inst_67159 = (state_67174[(8)]);
var inst_67159__$1 = (state_67174[(2)]);
var inst_67160 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67159__$1], 0));
var state_67174__$1 = (function (){var statearr_67190 = state_67174;
(statearr_67190[(8)] = inst_67159__$1);

return statearr_67190;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67174__$1,(9),inst_67160);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_67191 = [null,null,null,null,null,null,null,null,null];
(statearr_67191[(0)] = flureedb$state_machine__2684__auto__);

(statearr_67191[(1)] = (1));

return statearr_67191;
});
var flureedb$state_machine__2684__auto____1 = (function (state_67174){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67174);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67192){var ex__2687__auto__ = e67192;
var statearr_67193_67206 = state_67174;
(statearr_67193_67206[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67174[(4)]))){
var statearr_67194_67207 = state_67174;
(statearr_67194_67207[(1)] = cljs.core.first((state_67174[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67208 = state_67174;
state_67174 = G__67208;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_67174){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_67174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67195 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67195[(6)] = c__2706__auto__);

return statearr_67195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__67210 = arguments.length;
switch (G__67210) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67245){
var state_val_67246 = (state_67245[(1)]);
if((state_val_67246 === (7))){
var inst_67223 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67245__$1 = state_67245;
var statearr_67247_67268 = state_67245__$1;
(statearr_67247_67268[(2)] = inst_67223);

(statearr_67247_67268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (1))){
var state_67245__$1 = state_67245;
var statearr_67248_67269 = state_67245__$1;
(statearr_67248_67269[(2)] = null);

(statearr_67248_67269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (4))){
var inst_67211 = (state_67245[(2)]);
var inst_67212 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67211], 0));
var inst_67213 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67211) : reject.call(null,inst_67211));
var state_67245__$1 = (function (){var statearr_67249 = state_67245;
(statearr_67249[(7)] = inst_67212);

return statearr_67249;
})();
var statearr_67250_67270 = state_67245__$1;
(statearr_67250_67270[(2)] = inst_67213);

(statearr_67250_67270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (6))){
var state_67245__$1 = state_67245;
var statearr_67251_67271 = state_67245__$1;
(statearr_67251_67271[(2)] = null);

(statearr_67251_67271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (3))){
var inst_67243 = (state_67245[(2)]);
var state_67245__$1 = state_67245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67245__$1,inst_67243);
} else {
if((state_val_67246 === (2))){
var _ = (function (){var statearr_67253 = state_67245;
(statearr_67253[(4)] = cljs.core.cons((5),(state_67245[(4)])));

return statearr_67253;
})();
var inst_67220 = (opts == null);
var state_67245__$1 = state_67245;
if(cljs.core.truth_(inst_67220)){
var statearr_67254_67272 = state_67245__$1;
(statearr_67254_67272[(1)] = (6));

} else {
var statearr_67255_67273 = state_67245__$1;
(statearr_67255_67273[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (9))){
var inst_67228 = (state_67245[(8)]);
var inst_67229 = (state_67245[(9)]);
var inst_67225 = (state_67245[(10)]);
var inst_67232 = (state_67245[(2)]);
var inst_67233 = fluree.db.util.async.throw_err(inst_67232);
var inst_67234 = fluree.db.query.block.block_range(inst_67233,inst_67228,inst_67229,inst_67225);
var state_67245__$1 = state_67245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67245__$1,(10),inst_67234);
} else {
if((state_val_67246 === (5))){
var _ = (function (){var statearr_67256 = state_67245;
(statearr_67256[(4)] = cljs.core.rest((state_67245[(4)])));

return statearr_67256;
})();
var state_67245__$1 = state_67245;
var ex67252 = (state_67245__$1[(2)]);
var statearr_67257_67274 = state_67245__$1;
(statearr_67257_67274[(5)] = ex67252);


var statearr_67258_67275 = state_67245__$1;
(statearr_67258_67275[(1)] = (4));

(statearr_67258_67275[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (10))){
var inst_67236 = (state_67245[(2)]);
var inst_67237 = fluree.db.util.async.throw_err(inst_67236);
var inst_67238 = fluree.db.query.range.block_with_tx_data(inst_67237);
var inst_67239 = cljs.core.clj__GT_js(inst_67238);
var inst_67240 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67239) : resolve.call(null,inst_67239));
var _ = (function (){var statearr_67259 = state_67245;
(statearr_67259[(4)] = cljs.core.rest((state_67245[(4)])));

return statearr_67259;
})();
var state_67245__$1 = state_67245;
var statearr_67260_67276 = state_67245__$1;
(statearr_67260_67276[(2)] = inst_67240);

(statearr_67260_67276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (8))){
var inst_67225 = (state_67245[(10)]);
var inst_67225__$1 = (state_67245[(2)]);
var inst_67226 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67227 = cljs.core.__destructure_map(inst_67226);
var inst_67228 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67227,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_67229 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67227,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_67230 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67225__$1], 0));
var state_67245__$1 = (function (){var statearr_67261 = state_67245;
(statearr_67261[(8)] = inst_67228);

(statearr_67261[(9)] = inst_67229);

(statearr_67261[(10)] = inst_67225__$1);

return statearr_67261;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67245__$1,(9),inst_67230);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_67262 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_67262[(0)] = flureedb$state_machine__2684__auto__);

(statearr_67262[(1)] = (1));

return statearr_67262;
});
var flureedb$state_machine__2684__auto____1 = (function (state_67245){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67245);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67263){var ex__2687__auto__ = e67263;
var statearr_67264_67277 = state_67245;
(statearr_67264_67277[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67245[(4)]))){
var statearr_67265_67278 = state_67245;
(statearr_67265_67278[(1)] = cljs.core.first((state_67245[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67279 = state_67245;
state_67245 = G__67279;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_67245){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_67245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67266 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67266[(6)] = c__2706__auto__);

return statearr_67266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__67281 = arguments.length;
switch (G__67281) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67348){
var state_val_67349 = (state_67348[(1)]);
if((state_val_67349 === (7))){
var inst_67294 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67348__$1 = state_67348;
var statearr_67350_67391 = state_67348__$1;
(statearr_67350_67391[(2)] = inst_67294);

(statearr_67350_67391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (20))){
var inst_67290 = (state_67348[(7)]);
var inst_67296 = (state_67348[(8)]);
var inst_67332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67333 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_67334 = (new cljs.core.PersistentVector(null,1,(5),inst_67332,inst_67333,null));
var inst_67335 = cljs.core.assoc_in(inst_67296,inst_67334,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67336 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67290,inst_67335);
var state_67348__$1 = state_67348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67348__$1,(23),inst_67336);
} else {
if((state_val_67349 === (1))){
var state_67348__$1 = state_67348;
var statearr_67351_67392 = state_67348__$1;
(statearr_67351_67392[(2)] = null);

(statearr_67351_67392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (4))){
var inst_67282 = (state_67348[(2)]);
var inst_67283 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67282], 0));
var inst_67284 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67282) : reject.call(null,inst_67282));
var state_67348__$1 = (function (){var statearr_67352 = state_67348;
(statearr_67352[(9)] = inst_67283);

return statearr_67352;
})();
var statearr_67353_67393 = state_67348__$1;
(statearr_67353_67393[(2)] = inst_67284);

(statearr_67353_67393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (15))){
var inst_67320 = (state_67348[(2)]);
var inst_67321 = fluree.db.util.async.throw_err(inst_67320);
var state_67348__$1 = state_67348;
var statearr_67354_67394 = state_67348__$1;
(statearr_67354_67394[(2)] = inst_67321);

(statearr_67354_67394[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (21))){
var inst_67341 = (state_67348[(2)]);
var inst_67342 = cljs.core.clj__GT_js(inst_67341);
var inst_67343 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67342) : resolve.call(null,inst_67342));
var _ = (function (){var statearr_67355 = state_67348;
(statearr_67355[(4)] = cljs.core.rest((state_67348[(4)])));

return statearr_67355;
})();
var state_67348__$1 = state_67348;
var statearr_67356_67395 = state_67348__$1;
(statearr_67356_67395[(2)] = inst_67343);

(statearr_67356_67395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (13))){
var state_67348__$1 = state_67348;
var statearr_67357_67396 = state_67348__$1;
(statearr_67357_67396[(2)] = null);

(statearr_67357_67396[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (22))){
var inst_67329 = (state_67348[(2)]);
var inst_67330 = fluree.db.util.async.throw_err(inst_67329);
var state_67348__$1 = state_67348;
var statearr_67358_67397 = state_67348__$1;
(statearr_67358_67397[(2)] = inst_67330);

(statearr_67358_67397[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (6))){
var state_67348__$1 = state_67348;
var statearr_67359_67398 = state_67348__$1;
(statearr_67359_67398[(2)] = null);

(statearr_67359_67398[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (17))){
var state_67348__$1 = state_67348;
var statearr_67360_67399 = state_67348__$1;
(statearr_67360_67399[(2)] = null);

(statearr_67360_67399[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (3))){
var inst_67346 = (state_67348[(2)]);
var state_67348__$1 = state_67348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67348__$1,inst_67346);
} else {
if((state_val_67349 === (12))){
var inst_67304 = (state_67348[(10)]);
var inst_67308 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_67348__$1 = (function (){var statearr_67361 = state_67348;
(statearr_67361[(11)] = inst_67308);

return statearr_67361;
})();
if(cljs.core.truth_(inst_67304)){
var statearr_67362_67400 = state_67348__$1;
(statearr_67362_67400[(1)] = (16));

} else {
var statearr_67363_67401 = state_67348__$1;
(statearr_67363_67401[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (2))){
var _ = (function (){var statearr_67364 = state_67348;
(statearr_67364[(4)] = cljs.core.cons((5),(state_67348[(4)])));

return statearr_67364;
})();
var inst_67290 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67291 = (opts == null);
var state_67348__$1 = (function (){var statearr_67365 = state_67348;
(statearr_67365[(7)] = inst_67290);

return statearr_67365;
})();
if(cljs.core.truth_(inst_67291)){
var statearr_67366_67402 = state_67348__$1;
(statearr_67366_67402[(1)] = (6));

} else {
var statearr_67367_67403 = state_67348__$1;
(statearr_67367_67403[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (23))){
var inst_67338 = (state_67348[(2)]);
var inst_67339 = fluree.db.util.async.throw_err(inst_67338);
var state_67348__$1 = state_67348;
var statearr_67368_67404 = state_67348__$1;
(statearr_67368_67404[(2)] = inst_67339);

(statearr_67368_67404[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (19))){
var inst_67290 = (state_67348[(7)]);
var inst_67296 = (state_67348[(8)]);
var inst_67324 = (state_67348[(12)]);
var inst_67327 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_67324,inst_67290,inst_67296);
var state_67348__$1 = state_67348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67348__$1,(22),inst_67327);
} else {
if((state_val_67349 === (11))){
var inst_67298 = (state_67348[(13)]);
var inst_67296 = (state_67348[(8)]);
var inst_67304 = (state_67348[(2)]);
var inst_67305 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_67296);
var inst_67306 = (inst_67298 == null);
var state_67348__$1 = (function (){var statearr_67370 = state_67348;
(statearr_67370[(10)] = inst_67304);

(statearr_67370[(14)] = inst_67305);

return statearr_67370;
})();
if(cljs.core.truth_(inst_67306)){
var statearr_67371_67405 = state_67348__$1;
(statearr_67371_67405[(1)] = (12));

} else {
var statearr_67372_67406 = state_67348__$1;
(statearr_67372_67406[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (9))){
var inst_67299 = (state_67348[(15)]);
var state_67348__$1 = state_67348;
var statearr_67373_67407 = state_67348__$1;
(statearr_67373_67407[(2)] = inst_67299);

(statearr_67373_67407[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (5))){
var _ = (function (){var statearr_67374 = state_67348;
(statearr_67374[(4)] = cljs.core.rest((state_67348[(4)])));

return statearr_67374;
})();
var state_67348__$1 = state_67348;
var ex67369 = (state_67348__$1[(2)]);
var statearr_67375_67408 = state_67348__$1;
(statearr_67375_67408[(5)] = ex67369);


var statearr_67376_67409 = state_67348__$1;
(statearr_67376_67409[(1)] = (4));

(statearr_67376_67409[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (14))){
var inst_67298 = (state_67348[(13)]);
var inst_67324 = (state_67348[(2)]);
var inst_67325 = (inst_67298 == null);
var state_67348__$1 = (function (){var statearr_67377 = state_67348;
(statearr_67377[(12)] = inst_67324);

return statearr_67377;
})();
if(cljs.core.truth_(inst_67325)){
var statearr_67378_67410 = state_67348__$1;
(statearr_67378_67410[(1)] = (19));

} else {
var statearr_67379_67411 = state_67348__$1;
(statearr_67379_67411[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (16))){
var inst_67304 = (state_67348[(10)]);
var inst_67310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67311 = ["_auth/id",inst_67304];
var inst_67312 = (new cljs.core.PersistentVector(null,2,(5),inst_67310,inst_67311,null));
var state_67348__$1 = state_67348;
var statearr_67380_67412 = state_67348__$1;
(statearr_67380_67412[(2)] = inst_67312);

(statearr_67380_67412[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (10))){
var inst_67296 = (state_67348[(8)]);
var inst_67302 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_67296);
var state_67348__$1 = state_67348;
var statearr_67381_67413 = state_67348__$1;
(statearr_67381_67413[(2)] = inst_67302);

(statearr_67381_67413[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67349 === (18))){
var inst_67308 = (state_67348[(11)]);
var inst_67305 = (state_67348[(14)]);
var inst_67315 = (state_67348[(2)]);
var inst_67316 = [inst_67315,inst_67305];
var inst_67317 = cljs.core.PersistentHashMap.fromArrays(inst_67308,inst_67316);
var inst_67318 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67317], 0));
var state_67348__$1 = state_67348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67348__$1,(15),inst_67318);
} else {
if((state_val_67349 === (8))){
var inst_67299 = (state_67348[(15)]);
var inst_67296 = (state_67348[(8)]);
var inst_67296__$1 = (state_67348[(2)]);
var inst_67297 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67296__$1);
var inst_67298 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_67296__$1);
var inst_67299__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_67296__$1);
var state_67348__$1 = (function (){var statearr_67382 = state_67348;
(statearr_67382[(15)] = inst_67299__$1);

(statearr_67382[(13)] = inst_67298);

(statearr_67382[(8)] = inst_67296__$1);

(statearr_67382[(16)] = inst_67297);

return statearr_67382;
})();
if(cljs.core.truth_(inst_67299__$1)){
var statearr_67383_67414 = state_67348__$1;
(statearr_67383_67414[(1)] = (9));

} else {
var statearr_67384_67415 = state_67348__$1;
(statearr_67384_67415[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_67385 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67385[(0)] = flureedb$state_machine__2684__auto__);

(statearr_67385[(1)] = (1));

return statearr_67385;
});
var flureedb$state_machine__2684__auto____1 = (function (state_67348){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67348);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67386){var ex__2687__auto__ = e67386;
var statearr_67387_67416 = state_67348;
(statearr_67387_67416[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67348[(4)]))){
var statearr_67388_67417 = state_67348;
(statearr_67388_67417[(1)] = cljs.core.first((state_67348[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67418 = state_67348;
state_67348 = G__67418;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_67348){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_67348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67389 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67389[(6)] = c__2706__auto__);

return statearr_67389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67438){
var state_val_67439 = (state_67438[(1)]);
if((state_val_67439 === (1))){
var state_67438__$1 = state_67438;
var statearr_67440_67455 = state_67438__$1;
(statearr_67440_67455[(2)] = null);

(statearr_67440_67455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67439 === (2))){
var _ = (function (){var statearr_67441 = state_67438;
(statearr_67441[(4)] = cljs.core.cons((5),(state_67438[(4)])));

return statearr_67441;
})();
var inst_67427 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67428 = fluree.db.api.query.history_query_async(sources,inst_67427);
var state_67438__$1 = state_67438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67438__$1,(6),inst_67428);
} else {
if((state_val_67439 === (3))){
var inst_67436 = (state_67438[(2)]);
var state_67438__$1 = state_67438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67438__$1,inst_67436);
} else {
if((state_val_67439 === (4))){
var inst_67419 = (state_67438[(2)]);
var inst_67420 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67419], 0));
var inst_67421 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67419) : reject.call(null,inst_67419));
var state_67438__$1 = (function (){var statearr_67443 = state_67438;
(statearr_67443[(7)] = inst_67420);

return statearr_67443;
})();
var statearr_67444_67456 = state_67438__$1;
(statearr_67444_67456[(2)] = inst_67421);

(statearr_67444_67456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67439 === (5))){
var _ = (function (){var statearr_67445 = state_67438;
(statearr_67445[(4)] = cljs.core.rest((state_67438[(4)])));

return statearr_67445;
})();
var state_67438__$1 = state_67438;
var ex67442 = (state_67438__$1[(2)]);
var statearr_67446_67457 = state_67438__$1;
(statearr_67446_67457[(5)] = ex67442);


var statearr_67447_67458 = state_67438__$1;
(statearr_67447_67458[(1)] = (4));

(statearr_67447_67458[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67439 === (6))){
var inst_67430 = (state_67438[(2)]);
var inst_67431 = fluree.db.util.async.throw_err(inst_67430);
var inst_67432 = cljs.core.clj__GT_js(inst_67431);
var inst_67433 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67432) : resolve.call(null,inst_67432));
var _ = (function (){var statearr_67448 = state_67438;
(statearr_67448[(4)] = cljs.core.rest((state_67438[(4)])));

return statearr_67448;
})();
var state_67438__$1 = state_67438;
var statearr_67449_67459 = state_67438__$1;
(statearr_67449_67459[(2)] = inst_67433);

(statearr_67449_67459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2684__auto__ = null;
var flureedb$history_query_$_state_machine__2684__auto____0 = (function (){
var statearr_67450 = [null,null,null,null,null,null,null,null];
(statearr_67450[(0)] = flureedb$history_query_$_state_machine__2684__auto__);

(statearr_67450[(1)] = (1));

return statearr_67450;
});
var flureedb$history_query_$_state_machine__2684__auto____1 = (function (state_67438){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67438);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67451){var ex__2687__auto__ = e67451;
var statearr_67452_67460 = state_67438;
(statearr_67452_67460[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67438[(4)]))){
var statearr_67453_67461 = state_67438;
(statearr_67453_67461[(1)] = cljs.core.first((state_67438[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67462 = state_67438;
state_67438 = G__67462;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2684__auto__ = function(state_67438){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2684__auto____1.call(this,state_67438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2684__auto____0;
flureedb$history_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2684__auto____1;
return flureedb$history_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67454 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67454[(6)] = c__2706__auto__);

return statearr_67454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67482){
var state_val_67483 = (state_67482[(1)]);
if((state_val_67483 === (1))){
var state_67482__$1 = state_67482;
var statearr_67484_67499 = state_67482__$1;
(statearr_67484_67499[(2)] = null);

(statearr_67484_67499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67483 === (2))){
var _ = (function (){var statearr_67485 = state_67482;
(statearr_67485[(4)] = cljs.core.cons((5),(state_67482[(4)])));

return statearr_67485;
})();
var inst_67471 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67472 = fluree.db.api.query.multi_query_async(sources,inst_67471);
var state_67482__$1 = state_67482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67482__$1,(6),inst_67472);
} else {
if((state_val_67483 === (3))){
var inst_67480 = (state_67482[(2)]);
var state_67482__$1 = state_67482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67482__$1,inst_67480);
} else {
if((state_val_67483 === (4))){
var inst_67463 = (state_67482[(2)]);
var inst_67464 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67463], 0));
var inst_67465 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67463) : reject.call(null,inst_67463));
var state_67482__$1 = (function (){var statearr_67487 = state_67482;
(statearr_67487[(7)] = inst_67464);

return statearr_67487;
})();
var statearr_67488_67500 = state_67482__$1;
(statearr_67488_67500[(2)] = inst_67465);

(statearr_67488_67500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67483 === (5))){
var _ = (function (){var statearr_67489 = state_67482;
(statearr_67489[(4)] = cljs.core.rest((state_67482[(4)])));

return statearr_67489;
})();
var state_67482__$1 = state_67482;
var ex67486 = (state_67482__$1[(2)]);
var statearr_67490_67501 = state_67482__$1;
(statearr_67490_67501[(5)] = ex67486);


var statearr_67491_67502 = state_67482__$1;
(statearr_67491_67502[(1)] = (4));

(statearr_67491_67502[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67483 === (6))){
var inst_67474 = (state_67482[(2)]);
var inst_67475 = fluree.db.util.async.throw_err(inst_67474);
var inst_67476 = cljs.core.clj__GT_js(inst_67475);
var inst_67477 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67476) : resolve.call(null,inst_67476));
var _ = (function (){var statearr_67492 = state_67482;
(statearr_67492[(4)] = cljs.core.rest((state_67482[(4)])));

return statearr_67492;
})();
var state_67482__$1 = state_67482;
var statearr_67493_67503 = state_67482__$1;
(statearr_67493_67503[(2)] = inst_67477);

(statearr_67493_67503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2684__auto__ = null;
var flureedb$multi_query_$_state_machine__2684__auto____0 = (function (){
var statearr_67494 = [null,null,null,null,null,null,null,null];
(statearr_67494[(0)] = flureedb$multi_query_$_state_machine__2684__auto__);

(statearr_67494[(1)] = (1));

return statearr_67494;
});
var flureedb$multi_query_$_state_machine__2684__auto____1 = (function (state_67482){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67482);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67495){var ex__2687__auto__ = e67495;
var statearr_67496_67504 = state_67482;
(statearr_67496_67504[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67482[(4)]))){
var statearr_67497_67505 = state_67482;
(statearr_67497_67505[(1)] = cljs.core.first((state_67482[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67506 = state_67482;
state_67482 = G__67506;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2684__auto__ = function(state_67482){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2684__auto____1.call(this,state_67482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2684__auto____0;
flureedb$multi_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2684__auto____1;
return flureedb$multi_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67498 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67498[(6)] = c__2706__auto__);

return statearr_67498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67526){
var state_val_67527 = (state_67526[(1)]);
if((state_val_67527 === (1))){
var state_67526__$1 = state_67526;
var statearr_67528_67543 = state_67526__$1;
(statearr_67528_67543[(2)] = null);

(statearr_67528_67543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67527 === (2))){
var _ = (function (){var statearr_67529 = state_67526;
(statearr_67529[(4)] = cljs.core.cons((5),(state_67526[(4)])));

return statearr_67529;
})();
var inst_67516 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67517 = fluree.db.api.query.query_async(sources,inst_67516);
var state_67526__$1 = state_67526;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67526__$1,(6),inst_67517);
} else {
if((state_val_67527 === (3))){
var inst_67524 = (state_67526[(2)]);
var state_67526__$1 = state_67526;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67526__$1,inst_67524);
} else {
if((state_val_67527 === (4))){
var inst_67507 = (state_67526[(2)]);
var inst_67508 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67507], 0));
var inst_67509 = cljs.core.clj__GT_js(inst_67507);
var inst_67510 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67509) : reject.call(null,inst_67509));
var state_67526__$1 = (function (){var statearr_67531 = state_67526;
(statearr_67531[(7)] = inst_67508);

return statearr_67531;
})();
var statearr_67532_67544 = state_67526__$1;
(statearr_67532_67544[(2)] = inst_67510);

(statearr_67532_67544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67527 === (5))){
var _ = (function (){var statearr_67533 = state_67526;
(statearr_67533[(4)] = cljs.core.rest((state_67526[(4)])));

return statearr_67533;
})();
var state_67526__$1 = state_67526;
var ex67530 = (state_67526__$1[(2)]);
var statearr_67534_67545 = state_67526__$1;
(statearr_67534_67545[(5)] = ex67530);


var statearr_67535_67546 = state_67526__$1;
(statearr_67535_67546[(1)] = (4));

(statearr_67535_67546[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67527 === (6))){
var inst_67519 = (state_67526[(2)]);
var inst_67520 = cljs.core.clj__GT_js(inst_67519);
var inst_67521 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67520) : resolve.call(null,inst_67520));
var _ = (function (){var statearr_67536 = state_67526;
(statearr_67536[(4)] = cljs.core.rest((state_67526[(4)])));

return statearr_67536;
})();
var state_67526__$1 = state_67526;
var statearr_67537_67547 = state_67526__$1;
(statearr_67537_67547[(2)] = inst_67521);

(statearr_67537_67547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2684__auto__ = null;
var flureedb$query_$_state_machine__2684__auto____0 = (function (){
var statearr_67538 = [null,null,null,null,null,null,null,null];
(statearr_67538[(0)] = flureedb$query_$_state_machine__2684__auto__);

(statearr_67538[(1)] = (1));

return statearr_67538;
});
var flureedb$query_$_state_machine__2684__auto____1 = (function (state_67526){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67526);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67539){var ex__2687__auto__ = e67539;
var statearr_67540_67548 = state_67526;
(statearr_67540_67548[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67526[(4)]))){
var statearr_67541_67549 = state_67526;
(statearr_67541_67549[(1)] = cljs.core.first((state_67526[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67550 = state_67526;
state_67526 = G__67550;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2684__auto__ = function(state_67526){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2684__auto____1.call(this,state_67526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2684__auto____0;
flureedb$query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2684__auto____1;
return flureedb$query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67542 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67542[(6)] = c__2706__auto__);

return statearr_67542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__67552 = arguments.length;
switch (G__67552) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67579){
var state_val_67580 = (state_67579[(1)]);
if((state_val_67580 === (7))){
var inst_67566 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67579__$1 = state_67579;
var statearr_67581_67602 = state_67579__$1;
(statearr_67581_67602[(2)] = inst_67566);

(statearr_67581_67602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67580 === (1))){
var state_67579__$1 = state_67579;
var statearr_67582_67603 = state_67579__$1;
(statearr_67582_67603[(2)] = null);

(statearr_67582_67603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67580 === (4))){
var inst_67553 = (state_67579[(2)]);
var inst_67554 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67553], 0));
var inst_67555 = cljs.core.clj__GT_js(inst_67553);
var inst_67556 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67555) : reject.call(null,inst_67555));
var state_67579__$1 = (function (){var statearr_67583 = state_67579;
(statearr_67583[(7)] = inst_67554);

return statearr_67583;
})();
var statearr_67584_67604 = state_67579__$1;
(statearr_67584_67604[(2)] = inst_67556);

(statearr_67584_67604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67580 === (6))){
var state_67579__$1 = state_67579;
var statearr_67585_67605 = state_67579__$1;
(statearr_67585_67605[(2)] = null);

(statearr_67585_67605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67580 === (3))){
var inst_67577 = (state_67579[(2)]);
var state_67579__$1 = state_67579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67579__$1,inst_67577);
} else {
if((state_val_67580 === (2))){
var _ = (function (){var statearr_67587 = state_67579;
(statearr_67587[(4)] = cljs.core.cons((5),(state_67579[(4)])));

return statearr_67587;
})();
var inst_67562 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67563 = (opts == null);
var state_67579__$1 = (function (){var statearr_67588 = state_67579;
(statearr_67588[(8)] = inst_67562);

return statearr_67588;
})();
if(cljs.core.truth_(inst_67563)){
var statearr_67589_67606 = state_67579__$1;
(statearr_67589_67606[(1)] = (6));

} else {
var statearr_67590_67607 = state_67579__$1;
(statearr_67590_67607[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67580 === (9))){
var inst_67571 = (state_67579[(2)]);
var inst_67572 = fluree.db.util.async.throw_err(inst_67571);
var inst_67573 = cljs.core.clj__GT_js(inst_67572);
var inst_67574 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67573) : resolve.call(null,inst_67573));
var _ = (function (){var statearr_67591 = state_67579;
(statearr_67591[(4)] = cljs.core.rest((state_67579[(4)])));

return statearr_67591;
})();
var state_67579__$1 = state_67579;
var statearr_67592_67608 = state_67579__$1;
(statearr_67592_67608[(2)] = inst_67574);

(statearr_67592_67608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67580 === (5))){
var _ = (function (){var statearr_67593 = state_67579;
(statearr_67593[(4)] = cljs.core.rest((state_67579[(4)])));

return statearr_67593;
})();
var state_67579__$1 = state_67579;
var ex67586 = (state_67579__$1[(2)]);
var statearr_67594_67609 = state_67579__$1;
(statearr_67594_67609[(5)] = ex67586);


var statearr_67595_67610 = state_67579__$1;
(statearr_67595_67610[(1)] = (4));

(statearr_67595_67610[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67580 === (8))){
var inst_67562 = (state_67579[(8)]);
var inst_67568 = (state_67579[(2)]);
var inst_67569 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67562,inst_67568);
var state_67579__$1 = state_67579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67579__$1,(9),inst_67569);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_67596 = [null,null,null,null,null,null,null,null,null];
(statearr_67596[(0)] = flureedb$state_machine__2684__auto__);

(statearr_67596[(1)] = (1));

return statearr_67596;
});
var flureedb$state_machine__2684__auto____1 = (function (state_67579){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67579);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67597){var ex__2687__auto__ = e67597;
var statearr_67598_67611 = state_67579;
(statearr_67598_67611[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67579[(4)]))){
var statearr_67599_67612 = state_67579;
(statearr_67599_67612[(1)] = cljs.core.first((state_67579[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67613 = state_67579;
state_67579 = G__67613;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_67579){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_67579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67600 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67600[(6)] = c__2706__auto__);

return statearr_67600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 * 
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 * 
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
