// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["XHTTP Request Error:",e.request], 0));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__20599 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20599,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__20599;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__20600 = opts;
var map__20600__$1 = cljs.core.__destructure_map(map__20600);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20600__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20600__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20600__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__20601 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__20601__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__20601,headers], 0)):G__20601);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20601__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__20601__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__20602 = opts;
var map__20602__$1 = cljs.core.__destructure_map(map__20602);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20602__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20602__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20602__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20602__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20602__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__20603 = cljs.core.PersistentArrayMap.EMPTY;
var G__20603__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__20603,headers], 0)):G__20603);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20603__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__20603__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__20604 = output_format;
var G__20604__$1 = (((G__20604 instanceof cljs.core.Keyword))?G__20604.fqn:null);
switch (G__20604__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__20606 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20606,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__20606;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20638){
var state_val_20639 = (state_20638[(1)]);
if((state_val_20639 === (7))){
var inst_20634 = (state_20638[(2)]);
var state_20638__$1 = state_20638;
var statearr_20640_20665 = state_20638__$1;
(statearr_20640_20665[(2)] = inst_20634);

(statearr_20640_20665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20639 === (1))){
var state_20638__$1 = state_20638;
var statearr_20641_20666 = state_20638__$1;
(statearr_20641_20666[(2)] = null);

(statearr_20641_20666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20639 === (4))){
var inst_20609 = (state_20638[(7)]);
var inst_20609__$1 = (state_20638[(2)]);
var inst_20610 = (inst_20609__$1 == null);
var state_20638__$1 = (function (){var statearr_20642 = state_20638;
(statearr_20642[(7)] = inst_20609__$1);

return statearr_20642;
})();
if(cljs.core.truth_(inst_20610)){
var statearr_20643_20667 = state_20638__$1;
(statearr_20643_20667[(1)] = (5));

} else {
var statearr_20644_20668 = state_20638__$1;
(statearr_20644_20668[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20639 === (6))){
var inst_20609 = (state_20638[(7)]);
var inst_20617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20609,(0),null);
var inst_20618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20609,(1),null);
var state_20638__$1 = (function (){var statearr_20645 = state_20638;
(statearr_20645[(8)] = inst_20617);

(statearr_20645[(9)] = inst_20618);

return statearr_20645;
})();
var statearr_20646_20669 = state_20638__$1;
(statearr_20646_20669[(2)] = null);

(statearr_20646_20669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20639 === (3))){
var inst_20636 = (state_20638[(2)]);
var state_20638__$1 = state_20638;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20638__$1,inst_20636);
} else {
if((state_val_20639 === (2))){
var state_20638__$1 = state_20638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20638__$1,(4),pub_chan);
} else {
if((state_val_20639 === (11))){
var _ = (function (){var statearr_20648 = state_20638;
(statearr_20648[(4)] = cljs.core.rest((state_20638[(4)])));

return statearr_20648;
})();
var state_20638__$1 = state_20638;
var ex20647 = (state_20638__$1[(2)]);
var statearr_20649_20670 = state_20638__$1;
(statearr_20649_20670[(5)] = ex20647);


var statearr_20650_20671 = state_20638__$1;
(statearr_20650_20671[(1)] = (10));

(statearr_20650_20671[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20639 === (9))){
var inst_20631 = (state_20638[(2)]);
var state_20638__$1 = (function (){var statearr_20651 = state_20638;
(statearr_20651[(10)] = inst_20631);

return statearr_20651;
})();
var statearr_20652_20672 = state_20638__$1;
(statearr_20652_20672[(2)] = null);

(statearr_20652_20672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20639 === (5))){
var inst_20612 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_20638__$1 = state_20638;
var statearr_20653_20673 = state_20638__$1;
(statearr_20653_20673[(2)] = inst_20612);

(statearr_20653_20673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20639 === (10))){
var inst_20617 = (state_20638[(8)]);
var inst_20618 = (state_20638[(9)]);
var inst_20619 = (state_20638[(2)]);
var inst_20620 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_20619,"Error sending websocket message:",inst_20617], 0));
var inst_20621 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_20618,false);
var state_20638__$1 = (function (){var statearr_20654 = state_20638;
(statearr_20654[(11)] = inst_20620);

return statearr_20654;
})();
var statearr_20655_20674 = state_20638__$1;
(statearr_20655_20674[(2)] = inst_20621);

(statearr_20655_20674[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20639 === (8))){
var inst_20617 = (state_20638[(8)]);
var inst_20618 = (state_20638[(9)]);
var _ = (function (){var statearr_20656 = state_20638;
(statearr_20656[(4)] = cljs.core.cons((11),(state_20638[(4)])));

return statearr_20656;
})();
var inst_20627 = ws.send(inst_20617);
var inst_20628 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_20618,true);
var ___$1 = (function (){var statearr_20657 = state_20638;
(statearr_20657[(4)] = cljs.core.rest((state_20638[(4)])));

return statearr_20657;
})();
var state_20638__$1 = (function (){var statearr_20658 = state_20638;
(statearr_20658[(12)] = inst_20627);

return statearr_20658;
})();
var statearr_20659_20675 = state_20638__$1;
(statearr_20659_20675[(2)] = inst_20628);

(statearr_20659_20675[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0 = (function (){
var statearr_20660 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20660[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__);

(statearr_20660[(1)] = (1));

return statearr_20660;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1 = (function (state_20638){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20638);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20661){var ex__2687__auto__ = e20661;
var statearr_20662_20676 = state_20638;
(statearr_20662_20676[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20638[(4)]))){
var statearr_20663_20677 = state_20638;
(statearr_20663_20677[(1)] = cljs.core.first((state_20638[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20678 = state_20638;
state_20638 = G__20678;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__ = function(state_20638){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1.call(this,state_20638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20664 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20664[(6)] = c__2706__auto__);

return statearr_20664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2706__auto___20716 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20703){
var state_val_20704 = (state_20703[(1)]);
if((state_val_20704 === (1))){
var inst_20682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20683 = [open_QMARK_,timeout_chan];
var inst_20684 = (new cljs.core.PersistentVector(null,2,(5),inst_20682,inst_20683,null));
var state_20703__$1 = state_20703;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_20703__$1,(2),inst_20684,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_20704 === (2))){
var inst_20686 = (state_20703[(2)]);
var inst_20687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20686,(0),null);
var inst_20688 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20686,(1),null);
var inst_20689 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20688,timeout_chan);
var state_20703__$1 = (function (){var statearr_20705 = state_20703;
(statearr_20705[(7)] = inst_20687);

return statearr_20705;
})();
if(inst_20689){
var statearr_20706_20717 = state_20703__$1;
(statearr_20706_20717[(1)] = (3));

} else {
var statearr_20707_20718 = state_20703__$1;
(statearr_20707_20718[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20704 === (3))){
var inst_20691 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_20692 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20693 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_20694 = cljs.core.PersistentHashMap.fromArrays(inst_20692,inst_20693);
var inst_20695 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20691,inst_20694);
var inst_20696 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_20695);
var inst_20697 = fluree.db.util.xhttp.close_websocket(ws);
var state_20703__$1 = (function (){var statearr_20708 = state_20703;
(statearr_20708[(8)] = inst_20696);

return statearr_20708;
})();
var statearr_20709_20719 = state_20703__$1;
(statearr_20709_20719[(2)] = inst_20697);

(statearr_20709_20719[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20704 === (4))){
var inst_20699 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_20703__$1 = state_20703;
var statearr_20710_20720 = state_20703__$1;
(statearr_20710_20720[(2)] = inst_20699);

(statearr_20710_20720[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20704 === (5))){
var inst_20701 = (state_20703[(2)]);
var state_20703__$1 = state_20703;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20703__$1,inst_20701);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_20711 = [null,null,null,null,null,null,null,null,null];
(statearr_20711[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__);

(statearr_20711[(1)] = (1));

return statearr_20711;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1 = (function (state_20703){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20703);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20712){var ex__2687__auto__ = e20712;
var statearr_20713_20721 = state_20703;
(statearr_20713_20721[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20703[(4)]))){
var statearr_20714_20722 = state_20703;
(statearr_20714_20722[(1)] = cljs.core.first((state_20703[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20723 = state_20703;
state_20703 = G__20723;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__ = function(state_20703){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1.call(this,state_20703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20715 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20715[(6)] = c__2706__auto___20716);

return statearr_20715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
