// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_12212){
var state_val_12213 = (state_12212[(1)]);
if((state_val_12213 === (7))){
var inst_12207 = (state_12212[(2)]);
var _ = (function (){var statearr_12214 = state_12212;
(statearr_12214[(4)] = cljs.core.rest((state_12212[(4)])));

return statearr_12214;
})();
var state_12212__$1 = state_12212;
var statearr_12215_12237 = state_12212__$1;
(statearr_12215_12237[(2)] = inst_12207);

(statearr_12215_12237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12213 === (1))){
var state_12212__$1 = state_12212;
var statearr_12216_12238 = state_12212__$1;
(statearr_12216_12238[(2)] = null);

(statearr_12216_12238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12213 === (4))){
var inst_12169 = (state_12212[(2)]);
var state_12212__$1 = state_12212;
var statearr_12217_12239 = state_12212__$1;
(statearr_12217_12239[(2)] = inst_12169);

(statearr_12217_12239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12213 === (6))){
var inst_12187 = (state_12212[(7)]);
var inst_12194 = (state_12212[(8)]);
var inst_12193 = cljs.core.seq(inst_12187);
var inst_12194__$1 = cljs.core.first(inst_12193);
var inst_12195 = cljs.core.next(inst_12193);
var inst_12196 = cljs.core.not(inst_12194__$1);
var state_12212__$1 = (function (){var statearr_12218 = state_12212;
(statearr_12218[(8)] = inst_12194__$1);

(statearr_12218[(9)] = inst_12195);

return statearr_12218;
})();
if(inst_12196){
var statearr_12219_12240 = state_12212__$1;
(statearr_12219_12240[(1)] = (8));

} else {
var statearr_12220_12241 = state_12212__$1;
(statearr_12220_12241[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12213 === (3))){
var inst_12210 = (state_12212[(2)]);
var state_12212__$1 = state_12212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12212__$1,inst_12210);
} else {
if((state_val_12213 === (2))){
var _ = (function (){var statearr_12221 = state_12212;
(statearr_12221[(4)] = cljs.core.cons((5),(state_12212[(4)])));

return statearr_12221;
})();
var inst_12182 = chs;
var inst_12183 = cljs.core.seq(inst_12182);
var inst_12184 = cljs.core.first(inst_12183);
var inst_12185 = cljs.core.next(inst_12183);
var inst_12186 = coll;
var inst_12187 = inst_12182;
var inst_12188 = inst_12186;
var state_12212__$1 = (function (){var statearr_12222 = state_12212;
(statearr_12222[(7)] = inst_12187);

(statearr_12222[(10)] = inst_12185);

(statearr_12222[(11)] = inst_12188);

(statearr_12222[(12)] = inst_12184);

return statearr_12222;
})();
var statearr_12223_12242 = state_12212__$1;
(statearr_12223_12242[(2)] = null);

(statearr_12223_12242[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12213 === (11))){
var inst_12188 = (state_12212[(11)]);
var inst_12195 = (state_12212[(9)]);
var inst_12200 = (state_12212[(2)]);
var inst_12201 = fluree.db.util.async.throw_err(inst_12200);
var inst_12202 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12188,inst_12201);
var inst_12187 = inst_12195;
var inst_12188__$1 = inst_12202;
var state_12212__$1 = (function (){var statearr_12225 = state_12212;
(statearr_12225[(7)] = inst_12187);

(statearr_12225[(11)] = inst_12188__$1);

return statearr_12225;
})();
var statearr_12226_12243 = state_12212__$1;
(statearr_12226_12243[(2)] = null);

(statearr_12226_12243[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12213 === (9))){
var inst_12194 = (state_12212[(8)]);
var state_12212__$1 = state_12212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12212__$1,(11),inst_12194);
} else {
if((state_val_12213 === (5))){
var _ = (function (){var statearr_12227 = state_12212;
(statearr_12227[(4)] = cljs.core.rest((state_12212[(4)])));

return statearr_12227;
})();
var state_12212__$1 = state_12212;
var ex12224 = (state_12212__$1[(2)]);
var statearr_12228_12244 = state_12212__$1;
(statearr_12228_12244[(5)] = ex12224);


var statearr_12229_12245 = state_12212__$1;
(statearr_12229_12245[(1)] = (4));

(statearr_12229_12245[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12213 === (10))){
var inst_12205 = (state_12212[(2)]);
var state_12212__$1 = state_12212;
var statearr_12230_12246 = state_12212__$1;
(statearr_12230_12246[(2)] = inst_12205);

(statearr_12230_12246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12213 === (8))){
var inst_12188 = (state_12212[(11)]);
var state_12212__$1 = state_12212;
var statearr_12231_12247 = state_12212__$1;
(statearr_12231_12247[(2)] = inst_12188);

(statearr_12231_12247[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_12232 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12232[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__);

(statearr_12232[(1)] = (1));

return statearr_12232;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____1 = (function (state_12212){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_12212);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e12233){var ex__2687__auto__ = e12233;
var statearr_12234_12248 = state_12212;
(statearr_12234_12248[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_12212[(4)]))){
var statearr_12235_12249 = state_12212;
(statearr_12235_12249[(1)] = cljs.core.first((state_12212[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12250 = state_12212;
state_12212 = G__12250;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__ = function(state_12212){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____1.call(this,state_12212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_12236 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_12236[(6)] = c__2706__auto__);

return statearr_12236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_12276){
var state_val_12277 = (state_12276[(1)]);
if((state_val_12277 === (7))){
var inst_12271 = (state_12276[(2)]);
var _ = (function (){var statearr_12278 = state_12276;
(statearr_12278[(4)] = cljs.core.rest((state_12276[(4)])));

return statearr_12278;
})();
var state_12276__$1 = state_12276;
var statearr_12279_12301 = state_12276__$1;
(statearr_12279_12301[(2)] = inst_12271);

(statearr_12279_12301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12277 === (1))){
var state_12276__$1 = state_12276;
var statearr_12280_12302 = state_12276__$1;
(statearr_12280_12302[(2)] = null);

(statearr_12280_12302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12277 === (4))){
var inst_12251 = (state_12276[(2)]);
var state_12276__$1 = state_12276;
var statearr_12281_12303 = state_12276__$1;
(statearr_12281_12303[(2)] = inst_12251);

(statearr_12281_12303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12277 === (6))){
var state_12276__$1 = state_12276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12276__$1,(8),chan);
} else {
if((state_val_12277 === (3))){
var inst_12274 = (state_12276[(2)]);
var state_12276__$1 = state_12276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12276__$1,inst_12274);
} else {
if((state_val_12277 === (2))){
var _ = (function (){var statearr_12282 = state_12276;
(statearr_12282[(4)] = cljs.core.cons((5),(state_12276[(4)])));

return statearr_12282;
})();
var inst_12257 = coll;
var inst_12258 = inst_12257;
var state_12276__$1 = (function (){var statearr_12283 = state_12276;
(statearr_12283[(7)] = inst_12258);

return statearr_12283;
})();
var statearr_12284_12304 = state_12276__$1;
(statearr_12284_12304[(2)] = null);

(statearr_12284_12304[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12277 === (11))){
var inst_12269 = (state_12276[(2)]);
var state_12276__$1 = state_12276;
var statearr_12286_12305 = state_12276__$1;
(statearr_12286_12305[(2)] = inst_12269);

(statearr_12286_12305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12277 === (9))){
var inst_12258 = (state_12276[(7)]);
var state_12276__$1 = state_12276;
var statearr_12287_12306 = state_12276__$1;
(statearr_12287_12306[(2)] = inst_12258);

(statearr_12287_12306[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12277 === (5))){
var _ = (function (){var statearr_12288 = state_12276;
(statearr_12288[(4)] = cljs.core.rest((state_12276[(4)])));

return statearr_12288;
})();
var state_12276__$1 = state_12276;
var ex12285 = (state_12276__$1[(2)]);
var statearr_12289_12307 = state_12276__$1;
(statearr_12289_12307[(5)] = ex12285);


var statearr_12290_12308 = state_12276__$1;
(statearr_12290_12308[(1)] = (4));

(statearr_12290_12308[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12277 === (10))){
var inst_12262 = (state_12276[(8)]);
var inst_12258 = (state_12276[(7)]);
var inst_12266 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12258,inst_12262);
var inst_12258__$1 = inst_12266;
var state_12276__$1 = (function (){var statearr_12291 = state_12276;
(statearr_12291[(7)] = inst_12258__$1);

return statearr_12291;
})();
var statearr_12292_12309 = state_12276__$1;
(statearr_12292_12309[(2)] = null);

(statearr_12292_12309[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12277 === (8))){
var inst_12262 = (state_12276[(8)]);
var inst_12261 = (state_12276[(2)]);
var inst_12262__$1 = fluree.db.util.async.throw_err(inst_12261);
var inst_12263 = (inst_12262__$1 == null);
var state_12276__$1 = (function (){var statearr_12293 = state_12276;
(statearr_12293[(8)] = inst_12262__$1);

return statearr_12293;
})();
if(cljs.core.truth_(inst_12263)){
var statearr_12294_12310 = state_12276__$1;
(statearr_12294_12310[(1)] = (9));

} else {
var statearr_12295_12311 = state_12276__$1;
(statearr_12295_12311[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_12296 = [null,null,null,null,null,null,null,null,null];
(statearr_12296[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__);

(statearr_12296[(1)] = (1));

return statearr_12296;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____1 = (function (state_12276){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_12276);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e12297){var ex__2687__auto__ = e12297;
var statearr_12298_12312 = state_12276;
(statearr_12298_12312[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_12276[(4)]))){
var statearr_12299_12313 = state_12276;
(statearr_12299_12313[(1)] = cljs.core.first((state_12276[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12314 = state_12276;
state_12276 = G__12314;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__ = function(state_12276){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____1.call(this,state_12276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_12300 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_12300[(6)] = c__2706__auto__);

return statearr_12300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
