// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k28769,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__28773 = k28769;
var G__28773__$1 = (((G__28773 instanceof cljs.core.Keyword))?G__28773.fqn:null);
switch (G__28773__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k28769,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__28774){
var vec__28775 = p__28774;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28775,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28775,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28768){
var self__ = this;
var G__28768__$1 = this;
return (new cljs.core.RecordIter((0),G__28768__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__28778 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__28778(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28770,other28771){
var self__ = this;
var this28770__$1 = this;
return (((!((other28771 == null)))) && ((((this28770__$1.constructor === other28771.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.conn,other28771.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.network,other28771.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.dbid,other28771.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.db_name,other28771.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.update_chan,other28771.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.transact_chan,other28771.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.state,other28771.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.schema_cache,other28771.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.blank_db,other28771.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.close,other28771.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.id,other28771.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28770__$1.__extmap,other28771.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k28769){
var self__ = this;
var this__5350__auto____$1 = this;
var G__28779 = k28769;
var G__28779__$1 = (((G__28779 instanceof cljs.core.Keyword))?G__28779.fqn:null);
switch (G__28779__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k28769);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__28768){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__28780 = cljs.core.keyword_identical_QMARK_;
var expr__28781 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__28783 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__28784 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28783,G__28784) : pred__28780.call(null,G__28783,G__28784));
})())){
return (new fluree.db.session.DbSession(G__28768,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28785 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__28786 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28785,G__28786) : pred__28780.call(null,G__28785,G__28786));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__28768,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28787 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__28788 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28787,G__28788) : pred__28780.call(null,G__28787,G__28788));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__28768,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28789 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__28790 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28789,G__28790) : pred__28780.call(null,G__28789,G__28790));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__28768,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28791 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__28792 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28791,G__28792) : pred__28780.call(null,G__28791,G__28792));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__28768,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28793 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__28794 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28793,G__28794) : pred__28780.call(null,G__28793,G__28794));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__28768,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28795 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__28796 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28795,G__28796) : pred__28780.call(null,G__28795,G__28796));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__28768,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28797 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__28798 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28797,G__28798) : pred__28780.call(null,G__28797,G__28798));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__28768,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28799 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__28800 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28799,G__28800) : pred__28780.call(null,G__28799,G__28800));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__28768,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28801 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__28802 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28801,G__28802) : pred__28780.call(null,G__28801,G__28802));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__28768,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28803 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__28804 = expr__28781;
return (pred__28780.cljs$core$IFn$_invoke$arity$2 ? pred__28780.cljs$core$IFn$_invoke$arity$2(G__28803,G__28804) : pred__28780.call(null,G__28803,G__28804));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__28768,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__28768),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__28768){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__28768,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__28772){
var extmap__5385__auto__ = (function (){var G__28805 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__28772,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__28772)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__28805);
} else {
return G__28805;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28772),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28772),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28772),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__28772),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__28772),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__28772),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__28772),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__28772),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__28772),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__28772),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__28772),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__28808 = session;
var map__28808__$1 = cljs.core.__destructure_map(map__28808);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28808__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28808__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,dbid){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28850){
var state_val_28851 = (state_28850[(1)]);
if((state_val_28851 === (7))){
var inst_28824 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not found on this ledger group."].join('');
var inst_28825 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28826 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28827 = cljs.core.PersistentHashMap.fromArrays(inst_28825,inst_28826);
var inst_28828 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28824,inst_28827);
var inst_28829 = (function(){throw inst_28828})();
var state_28850__$1 = state_28850;
var statearr_28852_28875 = state_28850__$1;
(statearr_28852_28875[(2)] = inst_28829);

(statearr_28852_28875[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28851 === (1))){
var state_28850__$1 = state_28850;
var statearr_28853_28876 = state_28850__$1;
(statearr_28853_28876[(2)] = null);

(statearr_28853_28876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28851 === (4))){
var inst_28809 = (state_28850[(2)]);
var state_28850__$1 = state_28850;
var statearr_28854_28877 = state_28850__$1;
(statearr_28854_28877[(2)] = inst_28809);

(statearr_28854_28877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28851 === (6))){
var inst_28821 = (state_28850[(7)]);
var inst_28820 = (state_28850[(2)]);
var inst_28821__$1 = fluree.db.util.async.throw_err(inst_28820);
var inst_28822 = cljs.core.empty_QMARK_(inst_28821__$1);
var state_28850__$1 = (function (){var statearr_28855 = state_28850;
(statearr_28855[(7)] = inst_28821__$1);

return statearr_28855;
})();
if(inst_28822){
var statearr_28856_28878 = state_28850__$1;
(statearr_28856_28878[(1)] = (7));

} else {
var statearr_28857_28879 = state_28850__$1;
(statearr_28857_28879[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28851 === (3))){
var inst_28848 = (state_28850[(2)]);
var state_28850__$1 = state_28850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28850__$1,inst_28848);
} else {
if((state_val_28851 === (12))){
var inst_28843 = (state_28850[(2)]);
var state_28850__$1 = state_28850;
var statearr_28858_28880 = state_28850__$1;
(statearr_28858_28880[(2)] = inst_28843);

(statearr_28858_28880[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28851 === (2))){
var _ = (function (){var statearr_28859 = state_28850;
(statearr_28859[(4)] = cljs.core.cons((5),(state_28850[(4)])));

return statearr_28859;
})();
var inst_28815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28816 = [network,dbid];
var inst_28817 = (new cljs.core.PersistentVector(null,2,(5),inst_28815,inst_28816,null));
var inst_28818 = fluree.db.operations.ledger_info_async(conn,inst_28817);
var state_28850__$1 = state_28850;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28850__$1,(6),inst_28818);
} else {
if((state_val_28851 === (11))){
var inst_28821 = (state_28850[(7)]);
var state_28850__$1 = state_28850;
var statearr_28861_28881 = state_28850__$1;
(statearr_28861_28881[(2)] = inst_28821);

(statearr_28861_28881[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28851 === (9))){
var inst_28845 = (state_28850[(2)]);
var _ = (function (){var statearr_28862 = state_28850;
(statearr_28862[(4)] = cljs.core.rest((state_28850[(4)])));

return statearr_28862;
})();
var state_28850__$1 = state_28850;
var statearr_28863_28882 = state_28850__$1;
(statearr_28863_28882[(2)] = inst_28845);

(statearr_28863_28882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28851 === (5))){
var _ = (function (){var statearr_28864 = state_28850;
(statearr_28864[(4)] = cljs.core.rest((state_28850[(4)])));

return statearr_28864;
})();
var state_28850__$1 = state_28850;
var ex28860 = (state_28850__$1[(2)]);
var statearr_28865_28883 = state_28850__$1;
(statearr_28865_28883[(5)] = ex28860);


if((ex28860 instanceof Error)){
var statearr_28866_28884 = state_28850__$1;
(statearr_28866_28884[(1)] = (4));

(statearr_28866_28884[(5)] = null);

} else {
throw ex28860;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28851 === (10))){
var inst_28821 = (state_28850[(7)]);
var inst_28834 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_28821);
var inst_28835 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28834),"."].join('');
var inst_28836 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28837 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28838 = cljs.core.PersistentHashMap.fromArrays(inst_28836,inst_28837);
var inst_28839 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28835,inst_28838);
var inst_28840 = (function(){throw inst_28839})();
var state_28850__$1 = state_28850;
var statearr_28867_28885 = state_28850__$1;
(statearr_28867_28885[(2)] = inst_28840);

(statearr_28867_28885[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28851 === (8))){
var inst_28821 = (state_28850[(7)]);
var inst_28831 = fluree.db.session.ready_QMARK_(inst_28821);
var inst_28832 = (!(inst_28831));
var state_28850__$1 = state_28850;
if(inst_28832){
var statearr_28868_28886 = state_28850__$1;
(statearr_28868_28886[(1)] = (10));

} else {
var statearr_28869_28887 = state_28850__$1;
(statearr_28869_28887[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0 = (function (){
var statearr_28870 = [null,null,null,null,null,null,null,null];
(statearr_28870[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2684__auto__);

(statearr_28870[(1)] = (1));

return statearr_28870;
});
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1 = (function (state_28850){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28850);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28871){var ex__2687__auto__ = e28871;
var statearr_28872_28888 = state_28850;
(statearr_28872_28888[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28850[(4)]))){
var statearr_28873_28889 = state_28850;
(statearr_28873_28889[(1)] = cljs.core.first((state_28850[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28890 = state_28850;
state_28850 = G__28890;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__ = function(state_28850){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1.call(this,state_28850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28874 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28874[(6)] = c__2706__auto__);

return statearr_28874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__28891){
var map__28892 = p__28891;
var map__28892__$1 = cljs.core.__destructure_map(map__28892);
var blank_db = map__28892__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28892__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28892__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28967){
var state_val_28968 = (state_28967[(1)]);
if((state_val_28968 === (7))){
var inst_28910 = (state_28967[(7)]);
var inst_28909 = (state_28967[(2)]);
var inst_28910__$1 = fluree.db.util.async.throw_err(inst_28909);
var state_28967__$1 = (function (){var statearr_28969 = state_28967;
(statearr_28969[(7)] = inst_28910__$1);

return statearr_28969;
})();
if(cljs.core.truth_(inst_28910__$1)){
var statearr_28970_29005 = state_28967__$1;
(statearr_28970_29005[(1)] = (8));

} else {
var statearr_28971_29006 = state_28967__$1;
(statearr_28971_29006[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (20))){
var inst_28915 = (state_28967[(8)]);
var inst_28948 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28915)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid),"."].join('');
var inst_28949 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28950 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_28951 = cljs.core.PersistentHashMap.fromArrays(inst_28949,inst_28950);
var inst_28952 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28948,inst_28951);
var inst_28953 = (function(){throw inst_28952})();
var state_28967__$1 = state_28967;
var statearr_28972_29007 = state_28967__$1;
(statearr_28972_29007[(2)] = inst_28953);

(statearr_28972_29007[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (1))){
var state_28967__$1 = state_28967;
var statearr_28973_29008 = state_28967__$1;
(statearr_28973_29008[(2)] = null);

(statearr_28973_29008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (4))){
var inst_28893 = (state_28967[(2)]);
var state_28967__$1 = state_28967;
var statearr_28974_29009 = state_28967__$1;
(statearr_28974_29009[(2)] = inst_28893);

(statearr_28974_29009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (15))){
var inst_28957 = (state_28967[(2)]);
var state_28967__$1 = state_28967;
var statearr_28975_29010 = state_28967__$1;
(statearr_28975_29010[(2)] = inst_28957);

(statearr_28975_29010[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (21))){
var inst_28955 = (state_28967[(2)]);
var state_28967__$1 = state_28967;
var statearr_28976_29011 = state_28967__$1;
(statearr_28976_29011[(2)] = inst_28955);

(statearr_28976_29011[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (13))){
var inst_28914 = (state_28967[(9)]);
var inst_28919 = fluree.db.query.schema.schema_map(inst_28914);
var inst_28920 = fluree.db.query.schema.setting_map(inst_28914);
var inst_28921 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_28914);
var inst_28922 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_28921,cljs.core.empty);
var state_28967__$1 = (function (){var statearr_28977 = state_28967;
(statearr_28977[(10)] = inst_28920);

(statearr_28977[(11)] = inst_28922);

return statearr_28977;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28967__$1,(16),inst_28919);
} else {
if((state_val_28968 === (22))){
var inst_28915 = (state_28967[(8)]);
var inst_28943 = (state_28967[(2)]);
var inst_28944 = fluree.db.util.async.throw_err(inst_28943);
var inst_28945 = (inst_28915 + (1));
var inst_28914 = inst_28944;
var inst_28915__$1 = inst_28945;
var state_28967__$1 = (function (){var statearr_28978 = state_28967;
(statearr_28978[(9)] = inst_28914);

(statearr_28978[(8)] = inst_28915__$1);

return statearr_28978;
})();
var statearr_28979_29012 = state_28967__$1;
(statearr_28979_29012[(2)] = null);

(statearr_28979_29012[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (6))){
var inst_28902 = (state_28967[(2)]);
var inst_28903 = fluree.db.util.async.throw_err(inst_28902);
var inst_28904 = cljs.core.__destructure_map(inst_28903);
var inst_28905 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28904,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28906 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28904,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_28907 = fluree.db.storage.core.reify_db(conn,network,dbid,blank_db,inst_28906);
var state_28967__$1 = (function (){var statearr_28980 = state_28967;
(statearr_28980[(12)] = inst_28905);

return statearr_28980;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28967__$1,(7),inst_28907);
} else {
if((state_val_28968 === (17))){
var inst_28914 = (state_28967[(9)]);
var inst_28925 = (state_28967[(13)]);
var inst_28927 = (state_28967[(2)]);
var inst_28928 = fluree.db.util.async.throw_err(inst_28927);
var inst_28929 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28914,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_28925,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_28928], 0));
var state_28967__$1 = state_28967;
var statearr_28981_29013 = state_28967__$1;
(statearr_28981_29013[(2)] = inst_28929);

(statearr_28981_29013[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (3))){
var inst_28965 = (state_28967[(2)]);
var state_28967__$1 = state_28967;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28967__$1,inst_28965);
} else {
if((state_val_28968 === (12))){
var inst_28959 = (state_28967[(2)]);
var state_28967__$1 = state_28967;
var statearr_28982_29014 = state_28967__$1;
(statearr_28982_29014[(2)] = inst_28959);

(statearr_28982_29014[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (2))){
var _ = (function (){var statearr_28983 = state_28967;
(statearr_28983[(4)] = cljs.core.cons((5),(state_28967[(4)])));

return statearr_28983;
})();
var inst_28900 = fluree.db.session.load_ledger_info(conn,network,dbid);
var state_28967__$1 = state_28967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28967__$1,(6),inst_28900);
} else {
if((state_val_28968 === (19))){
var inst_28934 = (state_28967[(14)]);
var inst_28914 = (state_28967[(9)]);
var inst_28937 = cljs.core.__destructure_map(inst_28934);
var inst_28938 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28937,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_28939 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28937,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28940 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28937,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_28941 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_28914,inst_28939,inst_28938);
var state_28967__$1 = (function (){var statearr_28984 = state_28967;
(statearr_28984[(15)] = inst_28940);

return statearr_28984;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28967__$1,(22),inst_28941);
} else {
if((state_val_28968 === (11))){
var inst_28905 = (state_28967[(12)]);
var inst_28915 = (state_28967[(8)]);
var inst_28917 = (inst_28915 > inst_28905);
var state_28967__$1 = state_28967;
if(cljs.core.truth_(inst_28917)){
var statearr_28986_29015 = state_28967__$1;
(statearr_28986_29015[(1)] = (13));

} else {
var statearr_28987_29016 = state_28967__$1;
(statearr_28987_29016[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (9))){
var state_28967__$1 = state_28967;
var statearr_28988_29017 = state_28967__$1;
(statearr_28988_29017[(2)] = null);

(statearr_28988_29017[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (5))){
var _ = (function (){var statearr_28989 = state_28967;
(statearr_28989[(4)] = cljs.core.rest((state_28967[(4)])));

return statearr_28989;
})();
var state_28967__$1 = state_28967;
var ex28985 = (state_28967__$1[(2)]);
var statearr_28990_29018 = state_28967__$1;
(statearr_28990_29018[(5)] = ex28985);


if((ex28985 instanceof Error)){
var statearr_28991_29019 = state_28967__$1;
(statearr_28991_29019[(1)] = (4));

(statearr_28991_29019[(5)] = null);

} else {
throw ex28985;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (14))){
var inst_28915 = (state_28967[(8)]);
var inst_28931 = fluree.db.storage.core.read_block(conn,network,dbid,inst_28915);
var state_28967__$1 = state_28967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28967__$1,(18),inst_28931);
} else {
if((state_val_28968 === (16))){
var inst_28920 = (state_28967[(10)]);
var inst_28924 = (state_28967[(2)]);
var inst_28925 = fluree.db.util.async.throw_err(inst_28924);
var state_28967__$1 = (function (){var statearr_28992 = state_28967;
(statearr_28992[(13)] = inst_28925);

return statearr_28992;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28967__$1,(17),inst_28920);
} else {
if((state_val_28968 === (10))){
var inst_28962 = (state_28967[(2)]);
var _ = (function (){var statearr_28993 = state_28967;
(statearr_28993[(4)] = cljs.core.rest((state_28967[(4)])));

return statearr_28993;
})();
var state_28967__$1 = state_28967;
var statearr_28994_29020 = state_28967__$1;
(statearr_28994_29020[(2)] = inst_28962);

(statearr_28994_29020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (18))){
var inst_28934 = (state_28967[(14)]);
var inst_28933 = (state_28967[(2)]);
var inst_28934__$1 = fluree.db.util.async.throw_err(inst_28933);
var state_28967__$1 = (function (){var statearr_28995 = state_28967;
(statearr_28995[(14)] = inst_28934__$1);

return statearr_28995;
})();
if(cljs.core.truth_(inst_28934__$1)){
var statearr_28996_29021 = state_28967__$1;
(statearr_28996_29021[(1)] = (19));

} else {
var statearr_28997_29022 = state_28967__$1;
(statearr_28997_29022[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28968 === (8))){
var inst_28910 = (state_28967[(7)]);
var inst_28912 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28910);
var inst_28913 = (inst_28912 + (1));
var inst_28914 = inst_28910;
var inst_28915 = inst_28913;
var state_28967__$1 = (function (){var statearr_28998 = state_28967;
(statearr_28998[(9)] = inst_28914);

(statearr_28998[(8)] = inst_28915);

return statearr_28998;
})();
var statearr_28999_29023 = state_28967__$1;
(statearr_28999_29023[(2)] = null);

(statearr_28999_29023[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2684__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2684__auto____0 = (function (){
var statearr_29000 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29000[(0)] = fluree$db$session$load_current_db_$_state_machine__2684__auto__);

(statearr_29000[(1)] = (1));

return statearr_29000;
});
var fluree$db$session$load_current_db_$_state_machine__2684__auto____1 = (function (state_28967){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28967);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29001){var ex__2687__auto__ = e29001;
var statearr_29002_29024 = state_28967;
(statearr_29002_29024[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28967[(4)]))){
var statearr_29003_29025 = state_28967;
(statearr_29003_29025[(1)] = cljs.core.first((state_28967[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29026 = state_28967;
state_28967 = G__29026;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2684__auto__ = function(state_28967){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2684__auto____1.call(this,state_28967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2684__auto____0;
fluree$db$session$load_current_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2684__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29004 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29004[(6)] = c__2706__auto__);

return statearr_29004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__29027,old_db_ch,new_db_ch){
var map__29028 = p__29027;
var map__29028__$1 = cljs.core.__destructure_map(map__29028);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29028__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p__29029){
var map__29030 = p__29029;
var map__29030__$1 = cljs.core.__destructure_map(map__29030);
var s = map__29030__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29030__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current,old_db_ch)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__29031){
var map__29032 = p__29031;
var map__29032__$1 = cljs.core.__destructure_map(map__29032);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29032__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__29033){
var map__29034 = p__29033;
var map__29034__$1 = cljs.core.__destructure_map(map__29034);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29034__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29034__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29034__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2706__auto___29071 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29054){
var state_val_29055 = (state_29054[(1)]);
if((state_val_29055 === (1))){
var state_29054__$1 = state_29054;
var statearr_29056_29072 = state_29054__$1;
(statearr_29056_29072[(2)] = null);

(statearr_29056_29072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29055 === (2))){
var _ = (function (){var statearr_29057 = state_29054;
(statearr_29057[(4)] = cljs.core.cons((5),(state_29054[(4)])));

return statearr_29057;
})();
var inst_29044 = fluree.db.session.load_current_db(conn,blank_db);
var state_29054__$1 = state_29054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29054__$1,(6),inst_29044);
} else {
if((state_val_29055 === (3))){
var inst_29052 = (state_29054[(2)]);
var state_29054__$1 = state_29054;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29054__$1,inst_29052);
} else {
if((state_val_29055 === (4))){
var inst_29035 = (state_29054[(2)]);
var inst_29036 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_29037 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29035,"Error reloading db"], 0));
var inst_29038 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(db_ch,inst_29035);
var state_29054__$1 = (function (){var statearr_29059 = state_29054;
(statearr_29059[(7)] = inst_29037);

(statearr_29059[(8)] = inst_29036);

return statearr_29059;
})();
var statearr_29060_29073 = state_29054__$1;
(statearr_29060_29073[(2)] = inst_29038);

(statearr_29060_29073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29055 === (5))){
var _ = (function (){var statearr_29061 = state_29054;
(statearr_29061[(4)] = cljs.core.rest((state_29054[(4)])));

return statearr_29061;
})();
var state_29054__$1 = state_29054;
var ex29058 = (state_29054__$1[(2)]);
var statearr_29062_29074 = state_29054__$1;
(statearr_29062_29074[(5)] = ex29058);


var statearr_29063_29075 = state_29054__$1;
(statearr_29063_29075[(1)] = (4));

(statearr_29063_29075[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29055 === (6))){
var inst_29046 = (state_29054[(2)]);
var inst_29047 = fluree.db.util.async.throw_err(inst_29046);
var state_29054__$1 = state_29054;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29054__$1,(7),db_ch,inst_29047);
} else {
if((state_val_29055 === (7))){
var inst_29049 = (state_29054[(2)]);
var _ = (function (){var statearr_29064 = state_29054;
(statearr_29064[(4)] = cljs.core.rest((state_29054[(4)])));

return statearr_29064;
})();
var state_29054__$1 = state_29054;
var statearr_29065_29076 = state_29054__$1;
(statearr_29065_29076[(2)] = inst_29049);

(statearr_29065_29076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0 = (function (){
var statearr_29066 = [null,null,null,null,null,null,null,null,null];
(statearr_29066[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__);

(statearr_29066[(1)] = (1));

return statearr_29066;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1 = (function (state_29054){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29054);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29067){var ex__2687__auto__ = e29067;
var statearr_29068_29077 = state_29054;
(statearr_29068_29077[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29054[(4)]))){
var statearr_29069_29078 = state_29054;
(statearr_29069_29078[(1)] = cljs.core.first((state_29054[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29079 = state_29054;
state_29054 = G__29079;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__ = function(state_29054){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1.call(this,state_29054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29070 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29070[(6)] = c__2706__auto___29071);

return statearr_29070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__29081 = arguments.length;
switch (G__29081) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__29082){
var map__29083 = p__29082;
var map__29083__$1 = cljs.core.__destructure_map(map__29083);
var session = map__29083__$1;
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29083__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2(session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__29084,blank_db){
var map__29085 = p__29084;
var map__29085__$1 = cljs.core.__destructure_map(map__29085);
var session = map__29085__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29085__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29085__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis()),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
if(cljs.core.not(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cur_ch,state_ch)){
var c__2706__auto___29123 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29105){
var state_val_29106 = (state_29105[(1)]);
if((state_val_29106 === (1))){
var state_29105__$1 = state_29105;
var statearr_29107_29124 = state_29105__$1;
(statearr_29107_29124[(2)] = null);

(statearr_29107_29124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29106 === (2))){
var _ = (function (){var statearr_29108 = state_29105;
(statearr_29108[(4)] = cljs.core.cons((5),(state_29105[(4)])));

return statearr_29108;
})();
var inst_29095 = fluree.db.session.load_current_db(conn,blank_db);
var state_29105__$1 = state_29105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29105__$1,(6),inst_29095);
} else {
if((state_val_29106 === (3))){
var inst_29103 = (state_29105[(2)]);
var state_29105__$1 = state_29105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29105__$1,inst_29103);
} else {
if((state_val_29106 === (4))){
var inst_29086 = (state_29105[(2)]);
var inst_29087 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_29088 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29086,"Error loading current db"], 0));
var inst_29089 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cur_ch,inst_29086);
var state_29105__$1 = (function (){var statearr_29110 = state_29105;
(statearr_29110[(7)] = inst_29087);

(statearr_29110[(8)] = inst_29088);

return statearr_29110;
})();
var statearr_29111_29125 = state_29105__$1;
(statearr_29111_29125[(2)] = inst_29089);

(statearr_29111_29125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29106 === (5))){
var _ = (function (){var statearr_29112 = state_29105;
(statearr_29112[(4)] = cljs.core.rest((state_29105[(4)])));

return statearr_29112;
})();
var state_29105__$1 = state_29105;
var ex29109 = (state_29105__$1[(2)]);
var statearr_29113_29126 = state_29105__$1;
(statearr_29113_29126[(5)] = ex29109);


var statearr_29114_29127 = state_29105__$1;
(statearr_29114_29127[(1)] = (4));

(statearr_29114_29127[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29106 === (6))){
var inst_29097 = (state_29105[(2)]);
var inst_29098 = fluree.db.util.async.throw_err(inst_29097);
var state_29105__$1 = state_29105;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29105__$1,(7),cur_ch,inst_29098);
} else {
if((state_val_29106 === (7))){
var inst_29100 = (state_29105[(2)]);
var _ = (function (){var statearr_29115 = state_29105;
(statearr_29115[(4)] = cljs.core.rest((state_29105[(4)])));

return statearr_29115;
})();
var state_29105__$1 = state_29105;
var statearr_29116_29128 = state_29105__$1;
(statearr_29116_29128[(2)] = inst_29100);

(statearr_29116_29128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_29117 = [null,null,null,null,null,null,null,null,null];
(statearr_29117[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_29117[(1)] = (1));

return statearr_29117;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_29105){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29105);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29118){var ex__2687__auto__ = e29118;
var statearr_29119_29129 = state_29105;
(statearr_29119_29129[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29105[(4)]))){
var statearr_29120_29130 = state_29105;
(statearr_29120_29130[(1)] = cljs.core.first((state_29105[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29131 = state_29105;
state_29105 = G__29131;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_29105){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_29105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29121 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29121[(6)] = c__2706__auto___29123);

return statearr_29121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__29132 = cljs.core.get_global_hierarchy;
return (fexpr__29132.cljs$core$IFn$_invoke$arity$0 ? fexpr__29132.cljs$core$IFn$_invoke$arity$0() : fexpr__29132.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29134){
var state_val_29135 = (state_29134[(1)]);
if((state_val_29135 === (1))){
var state_29134__$1 = state_29134;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29134__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_29136 = [null,null,null,null,null,null,null];
(statearr_29136[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_29136[(1)] = (1));

return statearr_29136;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_29134){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29134);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29137){var ex__2687__auto__ = e29137;
var statearr_29138_29141 = state_29134;
(statearr_29138_29141[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29134[(4)]))){
var statearr_29139_29142 = state_29134;
(statearr_29139_29142[(1)] = cljs.core.first((state_29134[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29143 = state_29134;
state_29134 = G__29143;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_29134){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_29134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29140 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29140[(6)] = c__2706__auto__);

return statearr_29140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__29144){
var map__29145 = p__29144;
var map__29145__$1 = cljs.core.__destructure_map(map__29145);
var data = map__29145__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29145__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29145__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29145__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29204){
var state_val_29205 = (state_29204[(1)]);
if((state_val_29205 === (7))){
var inst_29156 = (state_29204[(7)]);
var inst_29159 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29160 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29161 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29159),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29160),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29156),". No-op."].join('');
var inst_29162 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29161], 0));
var state_29204__$1 = state_29204;
var statearr_29206_29244 = state_29204__$1;
(statearr_29206_29244[(2)] = inst_29162);

(statearr_29206_29244[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (1))){
var state_29204__$1 = state_29204;
var statearr_29207_29245 = state_29204__$1;
(statearr_29207_29245[(2)] = null);

(statearr_29207_29245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (4))){
var inst_29146 = (state_29204[(2)]);
var state_29204__$1 = state_29204;
var statearr_29208_29246 = state_29204__$1;
(statearr_29208_29246[(2)] = inst_29146);

(statearr_29208_29246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (15))){
var inst_29185 = (state_29204[(2)]);
var state_29204__$1 = state_29204;
var statearr_29209_29247 = state_29204__$1;
(statearr_29209_29247[(2)] = inst_29185);

(statearr_29209_29247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (13))){
var inst_29176 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_29177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29178 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29179 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29180 = [inst_29178,inst_29179];
var inst_29181 = (new cljs.core.PersistentVector(null,2,(5),inst_29177,inst_29180,null));
var inst_29182 = (function (){var G__29210 = inst_29176;
var G__29211 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__29212 = inst_29181;
var G__29213 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__29210,G__29211,G__29212,G__29213) : fluree.db.conn_events.process_event.call(null,G__29210,G__29211,G__29212,G__29213));
})();
var state_29204__$1 = state_29204;
var statearr_29214_29248 = state_29204__$1;
(statearr_29214_29248[(2)] = inst_29182);

(statearr_29214_29248[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (6))){
var inst_29155 = (state_29204[(8)]);
var inst_29156 = (state_29204[(7)]);
var inst_29154 = (state_29204[(2)]);
var inst_29155__$1 = fluree.db.util.async.throw_err(inst_29154);
var inst_29156__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_29155__$1);
var inst_29157 = (block <= inst_29156__$1);
var state_29204__$1 = (function (){var statearr_29215 = state_29204;
(statearr_29215[(8)] = inst_29155__$1);

(statearr_29215[(7)] = inst_29156__$1);

return statearr_29215;
})();
if(cljs.core.truth_(inst_29157)){
var statearr_29216_29249 = state_29204__$1;
(statearr_29216_29249[(1)] = (7));

} else {
var statearr_29217_29250 = state_29204__$1;
(statearr_29217_29250[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (17))){
var state_29204__$1 = state_29204;
var statearr_29218_29251 = state_29204__$1;
(statearr_29218_29251[(2)] = null);

(statearr_29218_29251[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (3))){
var inst_29202 = (state_29204[(2)]);
var state_29204__$1 = state_29204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29204__$1,inst_29202);
} else {
if((state_val_29205 === (12))){
var inst_29197 = (state_29204[(2)]);
var state_29204__$1 = state_29204;
var statearr_29219_29252 = state_29204__$1;
(statearr_29219_29252[(2)] = inst_29197);

(statearr_29219_29252[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (2))){
var inst_29152 = (state_29204[(9)]);
var _ = (function (){var statearr_29220 = state_29204;
(statearr_29220[(4)] = cljs.core.cons((5),(state_29204[(4)])));

return statearr_29220;
})();
var inst_29152__$1 = fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
var state_29204__$1 = (function (){var statearr_29221 = state_29204;
(statearr_29221[(9)] = inst_29152__$1);

return statearr_29221;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29204__$1,(6),inst_29152__$1);
} else {
if((state_val_29205 === (11))){
var state_29204__$1 = state_29204;
var statearr_29223_29253 = state_29204__$1;
(statearr_29223_29253[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (9))){
var inst_29199 = (state_29204[(2)]);
var _ = (function (){var statearr_29225 = state_29204;
(statearr_29225[(4)] = cljs.core.rest((state_29204[(4)])));

return statearr_29225;
})();
var state_29204__$1 = state_29204;
var statearr_29226_29254 = state_29204__$1;
(statearr_29226_29254[(2)] = inst_29199);

(statearr_29226_29254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (5))){
var _ = (function (){var statearr_29227 = state_29204;
(statearr_29227[(4)] = cljs.core.rest((state_29204[(4)])));

return statearr_29227;
})();
var state_29204__$1 = state_29204;
var ex29222 = (state_29204__$1[(2)]);
var statearr_29228_29255 = state_29204__$1;
(statearr_29228_29255[(5)] = ex29222);


if((ex29222 instanceof Error)){
var statearr_29229_29256 = state_29204__$1;
(statearr_29229_29256[(1)] = (4));

(statearr_29229_29256[(5)] = null);

} else {
throw ex29222;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (14))){
var state_29204__$1 = state_29204;
var statearr_29230_29257 = state_29204__$1;
(statearr_29230_29257[(2)] = null);

(statearr_29230_29257[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (16))){
var inst_29156 = (state_29204[(7)]);
var inst_29188 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29189 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29190 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29188),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29189),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29156),". Forcing a db reload."].join('');
var inst_29191 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29190], 0));
var inst_29192 = fluree.db.session.reload_db_BANG_(session);
var state_29204__$1 = (function (){var statearr_29231 = state_29204;
(statearr_29231[(10)] = inst_29191);

return statearr_29231;
})();
var statearr_29232_29258 = state_29204__$1;
(statearr_29232_29258[(2)] = inst_29192);

(statearr_29232_29258[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (10))){
var inst_29155 = (state_29204[(8)]);
var inst_29152 = (state_29204[(9)]);
var inst_29156 = (state_29204[(7)]);
var inst_29167 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29168 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29169 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29167),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29168),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_29170 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29169], 0));
var inst_29171 = (function (){var current_db_ch = inst_29152;
var current_db = inst_29155;
var current_block = inst_29156;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(f);
}
});
})();
var inst_29172 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_29171,flakes);
var inst_29173 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_29155,block,inst_29172);
var inst_29174 = fluree.db.session.cas_db_BANG_(session,inst_29152,inst_29173);
var state_29204__$1 = (function (){var statearr_29233 = state_29204;
(statearr_29233[(11)] = inst_29170);

return statearr_29233;
})();
if(inst_29174){
var statearr_29234_29259 = state_29204__$1;
(statearr_29234_29259[(1)] = (13));

} else {
var statearr_29235_29260 = state_29204__$1;
(statearr_29235_29260[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (18))){
var inst_29195 = (state_29204[(2)]);
var state_29204__$1 = state_29204;
var statearr_29236_29261 = state_29204__$1;
(statearr_29236_29261[(2)] = inst_29195);

(statearr_29236_29261[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29205 === (8))){
var inst_29156 = (state_29204[(7)]);
var inst_29164 = ((1) + inst_29156);
var inst_29165 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_29164);
var state_29204__$1 = state_29204;
if(inst_29165){
var statearr_29237_29262 = state_29204__$1;
(statearr_29237_29262[(1)] = (10));

} else {
var statearr_29238_29263 = state_29204__$1;
(statearr_29238_29263[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_29239 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29239[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_29239[(1)] = (1));

return statearr_29239;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_29204){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29204);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29240){var ex__2687__auto__ = e29240;
var statearr_29241_29264 = state_29204;
(statearr_29241_29264[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29204[(4)]))){
var statearr_29242_29265 = state_29204;
(statearr_29242_29265[(1)] = cljs.core.first((state_29204[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29266 = state_29204;
state_29204 = G__29266;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_29204){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_29204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29243 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29243[(6)] = c__2706__auto__);

return statearr_29243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29273){
var state_val_29274 = (state_29273[(1)]);
if((state_val_29274 === (1))){
var inst_29267 = fluree.db.session.clear_db_BANG_(session);
var inst_29268 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29269 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29270 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29268),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29269)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_29271 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29270], 0));
var state_29273__$1 = (function (){var statearr_29275 = state_29273;
(statearr_29275[(7)] = inst_29267);

(statearr_29275[(8)] = inst_29271);

return statearr_29275;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29273__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_29276 = [null,null,null,null,null,null,null,null,null];
(statearr_29276[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_29276[(1)] = (1));

return statearr_29276;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_29273){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29273);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29277){var ex__2687__auto__ = e29277;
var statearr_29278_29281 = state_29273;
(statearr_29278_29281[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29273[(4)]))){
var statearr_29279_29282 = state_29273;
(statearr_29279_29282[(1)] = cljs.core.first((state_29273[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29283 = state_29273;
state_29273 = G__29283;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_29273){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_29273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29280 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29280[(6)] = c__2706__auto__);

return statearr_29280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__29285 = arguments.length;
switch (G__29285) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__29286){
var map__29287 = p__29286;
var map__29287__$1 = cljs.core.__destructure_map(map__29287);
var session = map__29287__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29287__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29287__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29287__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29287__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29287__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29287__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29287__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__29288_29291 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__29288_29291.cljs$core$IFn$_invoke$arity$3 ? fexpr__29288_29291.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__29288_29291.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__29289_29292 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__29289_29292.cljs$core$IFn$_invoke$arity$0 ? fexpr__29289_29292.cljs$core$IFn$_invoke$arity$0() : fexpr__29289_29292.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5802__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29345){
var state_val_29346 = (state_29345[(1)]);
if((state_val_29346 === (7))){
var inst_29341 = (state_29345[(2)]);
var state_29345__$1 = state_29345;
var statearr_29347_29378 = state_29345__$1;
(statearr_29347_29378[(2)] = inst_29341);

(statearr_29347_29378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (1))){
var state_29345__$1 = state_29345;
var statearr_29348_29379 = state_29345__$1;
(statearr_29348_29379[(2)] = null);

(statearr_29348_29379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (4))){
var inst_29296 = (state_29345[(7)]);
var inst_29295 = (state_29345[(2)]);
var inst_29296__$1 = fluree.db.util.async.throw_err(inst_29295);
var inst_29297 = fluree.db.session.from_cache(network,ledger_id);
var inst_29298 = (inst_29296__$1 == null);
var state_29345__$1 = (function (){var statearr_29349 = state_29345;
(statearr_29349[(7)] = inst_29296__$1);

(statearr_29349[(8)] = inst_29297);

return statearr_29349;
})();
if(cljs.core.truth_(inst_29298)){
var statearr_29350_29380 = state_29345__$1;
(statearr_29350_29380[(1)] = (5));

} else {
var statearr_29351_29381 = state_29345__$1;
(statearr_29351_29381[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (15))){
var inst_29333 = (state_29345[(2)]);
var state_29345__$1 = (function (){var statearr_29352 = state_29345;
(statearr_29352[(9)] = inst_29333);

return statearr_29352;
})();
var statearr_29353_29382 = state_29345__$1;
(statearr_29353_29382[(2)] = null);

(statearr_29353_29382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (13))){
var inst_29337 = (state_29345[(2)]);
var state_29345__$1 = state_29345;
var statearr_29355_29383 = state_29345__$1;
(statearr_29355_29383[(2)] = inst_29337);

(statearr_29355_29383[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (6))){
var inst_29297 = (state_29345[(8)]);
var inst_29303 = (inst_29297 == null);
var state_29345__$1 = state_29345;
if(cljs.core.truth_(inst_29303)){
var statearr_29356_29384 = state_29345__$1;
(statearr_29356_29384[(1)] = (8));

} else {
var statearr_29357_29385 = state_29345__$1;
(statearr_29357_29385[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (17))){
var _ = (function (){var statearr_29358 = state_29345;
(statearr_29358[(4)] = cljs.core.rest((state_29345[(4)])));

return statearr_29358;
})();
var state_29345__$1 = state_29345;
var ex29354 = (state_29345__$1[(2)]);
var statearr_29359_29386 = state_29345__$1;
(statearr_29359_29386[(5)] = ex29354);


var statearr_29360_29387 = state_29345__$1;
(statearr_29360_29387[(1)] = (16));

(statearr_29360_29387[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (3))){
var inst_29343 = (state_29345[(2)]);
var state_29345__$1 = state_29345;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29345__$1,inst_29343);
} else {
if((state_val_29346 === (12))){
var state_29345__$1 = state_29345;
var statearr_29361_29388 = state_29345__$1;
(statearr_29361_29388[(2)] = null);

(statearr_29361_29388[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (2))){
var state_29345__$1 = state_29345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29345__$1,(4),update_chan);
} else {
if((state_val_29346 === (11))){
var state_29345__$1 = state_29345;
var statearr_29362_29389 = state_29345__$1;
(statearr_29362_29389[(2)] = null);

(statearr_29362_29389[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (9))){
var state_29345__$1 = state_29345;
var statearr_29363_29390 = state_29345__$1;
(statearr_29363_29390[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (5))){
var inst_29300 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_29301 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29300], 0));
var state_29345__$1 = state_29345;
var statearr_29365_29391 = state_29345__$1;
(statearr_29365_29391[(2)] = inst_29301);

(statearr_29365_29391[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (14))){
var inst_29296 = (state_29345[(7)]);
var inst_29297 = (state_29345[(8)]);
var _ = (function (){var statearr_29366 = state_29345;
(statearr_29366[(4)] = cljs.core.cons((17),(state_29345[(4)])));

return statearr_29366;
})();
var inst_29321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29296,(0),null);
var inst_29322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29296,(1),null);
var inst_29323 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_29324 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29296], 0));
var inst_29325 = fluree.db.util.core.trunc(inst_29324,(200));
var inst_29326 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29323,inst_29325], 0));
var inst_29327 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_29297,inst_29321,inst_29322) : fluree.db.session.process_ledger_update.call(null,inst_29297,inst_29321,inst_29322));
var state_29345__$1 = (function (){var statearr_29367 = state_29345;
(statearr_29367[(10)] = inst_29326);

return statearr_29367;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29345__$1,(18),inst_29327);
} else {
if((state_val_29346 === (16))){
var inst_29296 = (state_29345[(7)]);
var inst_29311 = (state_29345[(2)]);
var inst_29312 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29311,"Exception processing ledger updates for message: ",inst_29296], 0));
var state_29345__$1 = state_29345;
var statearr_29368_29392 = state_29345__$1;
(statearr_29368_29392[(2)] = inst_29312);

(statearr_29368_29392[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (10))){
var inst_29339 = (state_29345[(2)]);
var state_29345__$1 = state_29345;
var statearr_29369_29393 = state_29345__$1;
(statearr_29369_29393[(2)] = inst_29339);

(statearr_29369_29393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (18))){
var inst_29329 = (state_29345[(2)]);
var inst_29330 = fluree.db.util.async.throw_err(inst_29329);
var _ = (function (){var statearr_29370 = state_29345;
(statearr_29370[(4)] = cljs.core.rest((state_29345[(4)])));

return statearr_29370;
})();
var state_29345__$1 = state_29345;
var statearr_29371_29394 = state_29345__$1;
(statearr_29371_29394[(2)] = inst_29330);

(statearr_29371_29394[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29346 === (8))){
var inst_29296 = (state_29345[(7)]);
var inst_29305 = cljs.core.first(inst_29296);
var inst_29306 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29305], 0));
var inst_29307 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_29306].join('');
var inst_29308 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29307], 0));
var state_29345__$1 = state_29345;
var statearr_29372_29395 = state_29345__$1;
(statearr_29372_29395[(2)] = inst_29308);

(statearr_29372_29395[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0 = (function (){
var statearr_29373 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29373[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__);

(statearr_29373[(1)] = (1));

return statearr_29373;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1 = (function (state_29345){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29345);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29374){var ex__2687__auto__ = e29374;
var statearr_29375_29396 = state_29345;
(statearr_29375_29396[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29345[(4)]))){
var statearr_29376_29397 = state_29345;
(statearr_29376_29397[(1)] = cljs.core.first((state_29345[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29398 = state_29345;
state_29345 = G__29398;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__ = function(state_29345){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1.call(this,state_29345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29377 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29377[(6)] = c__2706__auto__);

return statearr_29377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__29399){
var map__29400 = p__29399;
var map__29400__$1 = cljs.core.__destructure_map(map__29400);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29400__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29400__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29400__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29400__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29400__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29400__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29400__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29400__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29400__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null),network,null,conn]));
var current_db_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__29404 = block_result;
var map__29404__$1 = cljs.core.__destructure_map(map__29404);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29404__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29404__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29404__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29404__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29404__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__29405 = tx_result;
var map__29405__$1 = cljs.core.__destructure_map(map__29405);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29405__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29405__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__29401_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__29401_SHARP_.t);
}):(function (p1__29402_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__29402_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__29403_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__29403_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__29403_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__29406 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29406,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29406,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29406,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29406,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));

var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__29410 = arguments.length;
switch (G__29410) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__29411){
var map__29412 = p__29411;
var map__29412__$1 = cljs.core.__destructure_map(map__29412);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29412__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29412__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29412__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29412__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__29413 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29413,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29413,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29413,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__29417_29537 = network;
var G__29418_29538 = ledger_id;
var G__29419_29539 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__29420_29540 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__29421 = cljs.core.seq(tids);
var chunk__29422 = null;
var count__29423 = (0);
var i__29424 = (0);
while(true){
if((i__29424 < count__29423)){
var tid = chunk__29422.cljs$core$IIndexed$_nth$arity$2(null,i__29424);
var temp__5804__auto___29542__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___29542__$1)){
var keyed_callbacks_29543 = temp__5804__auto___29542__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_29544 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__29465_29545 = cljs.core.seq(keyed_callbacks_29543);
var chunk__29466_29546 = null;
var count__29467_29547 = (0);
var i__29468_29548 = (0);
while(true){
if((i__29468_29548 < count__29467_29547)){
var vec__29477_29549 = chunk__29466_29546.cljs$core$IIndexed$_nth$arity$2(null,i__29468_29548);
var k_29550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29477_29549,(0),null);
var f_29551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29477_29549,(1),null);
try{(f_29551.cljs$core$IFn$_invoke$arity$1 ? f_29551.cljs$core$IFn$_invoke$arity$1(tx_response_29544) : f_29551.call(null,tx_response_29544));
}catch (e29480){var e_29552 = e29480;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_29552,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__29553 = seq__29465_29545;
var G__29554 = chunk__29466_29546;
var G__29555 = count__29467_29547;
var G__29556 = (i__29468_29548 + (1));
seq__29465_29545 = G__29553;
chunk__29466_29546 = G__29554;
count__29467_29547 = G__29555;
i__29468_29548 = G__29556;
continue;
} else {
var temp__5804__auto___29557__$2 = cljs.core.seq(seq__29465_29545);
if(temp__5804__auto___29557__$2){
var seq__29465_29558__$1 = temp__5804__auto___29557__$2;
if(cljs.core.chunked_seq_QMARK_(seq__29465_29558__$1)){
var c__5568__auto___29559 = cljs.core.chunk_first(seq__29465_29558__$1);
var G__29560 = cljs.core.chunk_rest(seq__29465_29558__$1);
var G__29561 = c__5568__auto___29559;
var G__29562 = cljs.core.count(c__5568__auto___29559);
var G__29563 = (0);
seq__29465_29545 = G__29560;
chunk__29466_29546 = G__29561;
count__29467_29547 = G__29562;
i__29468_29548 = G__29563;
continue;
} else {
var vec__29481_29564 = cljs.core.first(seq__29465_29558__$1);
var k_29565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29481_29564,(0),null);
var f_29566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29481_29564,(1),null);
try{(f_29566.cljs$core$IFn$_invoke$arity$1 ? f_29566.cljs$core$IFn$_invoke$arity$1(tx_response_29544) : f_29566.call(null,tx_response_29544));
}catch (e29484){var e_29567 = e29484;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_29567,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__29568 = cljs.core.next(seq__29465_29558__$1);
var G__29569 = null;
var G__29570 = (0);
var G__29571 = (0);
seq__29465_29545 = G__29568;
chunk__29466_29546 = G__29569;
count__29467_29547 = G__29570;
i__29468_29548 = G__29571;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__29572 = seq__29421;
var G__29573 = chunk__29422;
var G__29574 = count__29423;
var G__29575 = (i__29424 + (1));
seq__29421 = G__29572;
chunk__29422 = G__29573;
count__29423 = G__29574;
i__29424 = G__29575;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq(seq__29421);
if(temp__5804__auto____$1){
var seq__29421__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__29421__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__29421__$1);
var G__29576 = cljs.core.chunk_rest(seq__29421__$1);
var G__29577 = c__5568__auto__;
var G__29578 = cljs.core.count(c__5568__auto__);
var G__29579 = (0);
seq__29421 = G__29576;
chunk__29422 = G__29577;
count__29423 = G__29578;
i__29424 = G__29579;
continue;
} else {
var tid = cljs.core.first(seq__29421__$1);
var temp__5804__auto___29580__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___29580__$2)){
var keyed_callbacks_29581 = temp__5804__auto___29580__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_29582 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__29485_29583 = cljs.core.seq(keyed_callbacks_29581);
var chunk__29486_29584 = null;
var count__29487_29585 = (0);
var i__29488_29586 = (0);
while(true){
if((i__29488_29586 < count__29487_29585)){
var vec__29497_29587 = chunk__29486_29584.cljs$core$IIndexed$_nth$arity$2(null,i__29488_29586);
var k_29588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29497_29587,(0),null);
var f_29589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29497_29587,(1),null);
try{(f_29589.cljs$core$IFn$_invoke$arity$1 ? f_29589.cljs$core$IFn$_invoke$arity$1(tx_response_29582) : f_29589.call(null,tx_response_29582));
}catch (e29500){var e_29590 = e29500;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_29590,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__29591 = seq__29485_29583;
var G__29592 = chunk__29486_29584;
var G__29593 = count__29487_29585;
var G__29594 = (i__29488_29586 + (1));
seq__29485_29583 = G__29591;
chunk__29486_29584 = G__29592;
count__29487_29585 = G__29593;
i__29488_29586 = G__29594;
continue;
} else {
var temp__5804__auto___29595__$3 = cljs.core.seq(seq__29485_29583);
if(temp__5804__auto___29595__$3){
var seq__29485_29596__$1 = temp__5804__auto___29595__$3;
if(cljs.core.chunked_seq_QMARK_(seq__29485_29596__$1)){
var c__5568__auto___29597 = cljs.core.chunk_first(seq__29485_29596__$1);
var G__29598 = cljs.core.chunk_rest(seq__29485_29596__$1);
var G__29599 = c__5568__auto___29597;
var G__29600 = cljs.core.count(c__5568__auto___29597);
var G__29601 = (0);
seq__29485_29583 = G__29598;
chunk__29486_29584 = G__29599;
count__29487_29585 = G__29600;
i__29488_29586 = G__29601;
continue;
} else {
var vec__29501_29602 = cljs.core.first(seq__29485_29596__$1);
var k_29603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29501_29602,(0),null);
var f_29604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29501_29602,(1),null);
try{(f_29604.cljs$core$IFn$_invoke$arity$1 ? f_29604.cljs$core$IFn$_invoke$arity$1(tx_response_29582) : f_29604.call(null,tx_response_29582));
}catch (e29504){var e_29605 = e29504;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_29605,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__29606 = cljs.core.next(seq__29485_29596__$1);
var G__29607 = null;
var G__29608 = (0);
var G__29609 = (0);
seq__29485_29583 = G__29606;
chunk__29486_29584 = G__29607;
count__29487_29585 = G__29608;
i__29488_29586 = G__29609;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__29610 = cljs.core.next(seq__29421__$1);
var G__29611 = null;
var G__29612 = (0);
var G__29613 = (0);
seq__29421 = G__29610;
chunk__29422 = G__29611;
count__29423 = G__29612;
i__29424 = G__29613;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__29416_29541 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__29416_29541.cljs$core$IFn$_invoke$arity$4 ? fexpr__29416_29541.cljs$core$IFn$_invoke$arity$4(G__29417_29537,G__29418_29538,G__29419_29539,G__29420_29540) : fexpr__29416_29541.call(null,G__29417_29537,G__29418_29538,G__29419_29539,G__29420_29540));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_29614 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2706__auto___29615 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29521){
var state_val_29522 = (state_29521[(1)]);
if((state_val_29522 === (1))){
var state_29521__$1 = state_29521;
var statearr_29523_29616 = state_29521__$1;
(statearr_29523_29616[(2)] = null);

(statearr_29523_29616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29522 === (2))){
var inst_29506 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_29521__$1 = state_29521;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29521__$1,(4),inst_29506);
} else {
if((state_val_29522 === (3))){
var inst_29519 = (state_29521[(2)]);
var state_29521__$1 = state_29521;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29521__$1,inst_29519);
} else {
if((state_val_29522 === (4))){
var inst_29508 = (state_29521[(7)]);
var inst_29508__$1 = (state_29521[(2)]);
var inst_29509 = (inst_29508__$1 == null);
var state_29521__$1 = (function (){var statearr_29524 = state_29521;
(statearr_29524[(7)] = inst_29508__$1);

return statearr_29524;
})();
if(cljs.core.truth_(inst_29509)){
var statearr_29525_29617 = state_29521__$1;
(statearr_29525_29617[(1)] = (5));

} else {
var statearr_29526_29618 = state_29521__$1;
(statearr_29526_29618[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29522 === (5))){
var inst_29511 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_29512 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29511], 0));
var state_29521__$1 = state_29521;
var statearr_29527_29619 = state_29521__$1;
(statearr_29527_29619[(2)] = inst_29512);

(statearr_29527_29619[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29522 === (6))){
var inst_29508 = (state_29521[(7)]);
var inst_29514 = (transact_handler_29614.cljs$core$IFn$_invoke$arity$2 ? transact_handler_29614.cljs$core$IFn$_invoke$arity$2(conn,inst_29508) : transact_handler_29614.call(null,conn,inst_29508));
var state_29521__$1 = (function (){var statearr_29528 = state_29521;
(statearr_29528[(8)] = inst_29514);

return statearr_29528;
})();
var statearr_29529_29620 = state_29521__$1;
(statearr_29529_29620[(2)] = null);

(statearr_29529_29620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29522 === (7))){
var inst_29517 = (state_29521[(2)]);
var state_29521__$1 = state_29521;
var statearr_29530_29621 = state_29521__$1;
(statearr_29530_29621[(2)] = inst_29517);

(statearr_29530_29621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_29531 = [null,null,null,null,null,null,null,null,null];
(statearr_29531[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_29531[(1)] = (1));

return statearr_29531;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_29521){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29521);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29532){var ex__2687__auto__ = e29532;
var statearr_29533_29622 = state_29521;
(statearr_29533_29622[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29521[(4)]))){
var statearr_29534_29623 = state_29521;
(statearr_29534_29623[(1)] = cljs.core.first((state_29521[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29624 = state_29521;
state_29521 = G__29624;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_29521){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_29521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29535 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29535[(6)] = c__2706__auto___29615);

return statearr_29535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__29627 = arguments.length;
switch (G__29627) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__29628 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__29625_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__29625_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__29628);
} else {
return G__29628;
}
})();
var seq__29629 = cljs.core.seq(sessions);
var chunk__29630 = null;
var count__29631 = (0);
var i__29632 = (0);
while(true){
if((i__29632 < count__29631)){
var session = chunk__29630.cljs$core$IIndexed$_nth$arity$2(null,i__29632);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__29634 = seq__29629;
var G__29635 = chunk__29630;
var G__29636 = count__29631;
var G__29637 = (i__29632 + (1));
seq__29629 = G__29634;
chunk__29630 = G__29635;
count__29631 = G__29636;
i__29632 = G__29637;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__29629);
if(temp__5804__auto__){
var seq__29629__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29629__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__29629__$1);
var G__29638 = cljs.core.chunk_rest(seq__29629__$1);
var G__29639 = c__5568__auto__;
var G__29640 = cljs.core.count(c__5568__auto__);
var G__29641 = (0);
seq__29629 = G__29638;
chunk__29630 = G__29639;
count__29631 = G__29640;
i__29632 = G__29641;
continue;
} else {
var session = cljs.core.first(seq__29629__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__29642 = cljs.core.next(seq__29629__$1);
var G__29643 = null;
var G__29644 = (0);
var G__29645 = (0);
seq__29629 = G__29642;
chunk__29630 = G__29643;
count__29631 = G__29644;
i__29632 = G__29645;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
