// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29651 = arguments.length;
var i__5770__auto___29652 = (0);
while(true){
if((i__5770__auto___29652 < len__5769__auto___29651)){
args__5775__auto__.push((arguments[i__5770__auto___29652]));

var G__29653 = (i__5770__auto___29652 + (1));
i__5770__auto___29652 = G__29653;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq29648){
var G__29649 = cljs.core.first(seq29648);
var seq29648__$1 = cljs.core.next(seq29648);
var G__29650 = cljs.core.first(seq29648__$1);
var seq29648__$2 = cljs.core.next(seq29648__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29649,G__29650,seq29648__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e29654){var e = e29654;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e29655){var e = e29655;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e29656){var e = e29656;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e29657){var e = e29657;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e29658){var e = e29658;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29661 = arguments.length;
var i__5770__auto___29662 = (0);
while(true){
if((i__5770__auto___29662 < len__5769__auto___29661)){
args__5775__auto__.push((arguments[i__5770__auto___29662]));

var G__29663 = (i__5770__auto___29662 + (1));
i__5770__auto___29662 = G__29663;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e29660){var e = e29660;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq29659){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29659));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29666 = arguments.length;
var i__5770__auto___29667 = (0);
while(true){
if((i__5770__auto___29667 < len__5769__auto___29666)){
args__5775__auto__.push((arguments[i__5770__auto___29667]));

var G__29668 = (i__5770__auto___29667 + (1));
i__5770__auto___29667 = G__29668;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e29665){var e = e29665;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq29664){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29664));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e29669){var e = e29669;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29672 = arguments.length;
var i__5770__auto___29673 = (0);
while(true){
if((i__5770__auto___29673 < len__5769__auto___29672)){
args__5775__auto__.push((arguments[i__5770__auto___29673]));

var G__29674 = (i__5770__auto___29673 + (1));
i__5770__auto___29673 = G__29674;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e29671){var e = e29671;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq29670){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29670));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29677 = arguments.length;
var i__5770__auto___29678 = (0);
while(true){
if((i__5770__auto___29678 < len__5769__auto___29677)){
args__5775__auto__.push((arguments[i__5770__auto___29678]));

var G__29679 = (i__5770__auto___29678 + (1));
i__5770__auto___29678 = G__29679;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e29676){var e = e29676;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq29675){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29675));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e29680){var e = e29680;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e29681){var e = e29681;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29684 = arguments.length;
var i__5770__auto___29685 = (0);
while(true){
if((i__5770__auto___29685 < len__5769__auto___29684)){
args__5775__auto__.push((arguments[i__5770__auto___29685]));

var G__29686 = (i__5770__auto___29685 + (1));
i__5770__auto___29685 = G__29686;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e29683){var e = e29683;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq29682){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29682));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29689 = arguments.length;
var i__5770__auto___29690 = (0);
while(true){
if((i__5770__auto___29690 < len__5769__auto___29689)){
args__5775__auto__.push((arguments[i__5770__auto___29690]));

var G__29691 = (i__5770__auto___29690 + (1));
i__5770__auto___29690 = G__29691;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e29688){var e = e29688;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq29687){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29687));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29694 = arguments.length;
var i__5770__auto___29695 = (0);
while(true){
if((i__5770__auto___29695 < len__5769__auto___29694)){
args__5775__auto__.push((arguments[i__5770__auto___29695]));

var G__29696 = (i__5770__auto___29695 + (1));
i__5770__auto___29695 = G__29696;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e29693){var e = e29693;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq29692){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29692));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29699 = arguments.length;
var i__5770__auto___29700 = (0);
while(true){
if((i__5770__auto___29700 < len__5769__auto___29699)){
args__5775__auto__.push((arguments[i__5770__auto___29700]));

var G__29701 = (i__5770__auto___29700 + (1));
i__5770__auto___29700 = G__29701;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e29698){var e = e29698;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq29697){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29697));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29704 = arguments.length;
var i__5770__auto___29705 = (0);
while(true){
if((i__5770__auto___29705 < len__5769__auto___29704)){
args__5775__auto__.push((arguments[i__5770__auto___29705]));

var G__29706 = (i__5770__auto___29705 + (1));
i__5770__auto___29705 = G__29706;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e29703){var e = e29703;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq29702){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29702));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29709 = arguments.length;
var i__5770__auto___29710 = (0);
while(true){
if((i__5770__auto___29710 < len__5769__auto___29709)){
args__5775__auto__.push((arguments[i__5770__auto___29710]));

var G__29711 = (i__5770__auto___29710 + (1));
i__5770__auto___29710 = G__29711;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e29708){var e = e29708;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq29707){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29707));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29714 = arguments.length;
var i__5770__auto___29715 = (0);
while(true){
if((i__5770__auto___29715 < len__5769__auto___29714)){
args__5775__auto__.push((arguments[i__5770__auto___29715]));

var G__29716 = (i__5770__auto___29715 + (1));
i__5770__auto___29715 = G__29716;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e29713){var e = e29713;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq29712){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29712));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__29718 = arguments.length;
switch (G__29718) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29746){
var state_val_29747 = (state_29746[(1)]);
if((state_val_29747 === (7))){
var inst_29731 = (state_29746[(7)]);
var inst_29734 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29731,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_29746__$1 = state_29746;
var statearr_29748_29834 = state_29746__$1;
(statearr_29748_29834[(2)] = inst_29734);

(statearr_29748_29834[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29747 === (1))){
var state_29746__$1 = state_29746;
var statearr_29749_29835 = state_29746__$1;
(statearr_29749_29835[(2)] = null);

(statearr_29749_29835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29747 === (4))){
var inst_29719 = (state_29746[(2)]);
var state_29746__$1 = state_29746;
var statearr_29750_29836 = state_29746__$1;
(statearr_29750_29836[(2)] = inst_29719);

(statearr_29750_29836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29747 === (6))){
var inst_29731 = (state_29746[(7)]);
var inst_29731__$1 = (state_29746[(2)]);
var inst_29732 = fluree.db.util.core.exception_QMARK_(inst_29731__$1);
var state_29746__$1 = (function (){var statearr_29751 = state_29746;
(statearr_29751[(7)] = inst_29731__$1);

return statearr_29751;
})();
if(inst_29732){
var statearr_29752_29837 = state_29746__$1;
(statearr_29752_29837[(1)] = (7));

} else {
var statearr_29753_29838 = state_29746__$1;
(statearr_29753_29838[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29747 === (3))){
var inst_29744 = (state_29746[(2)]);
var state_29746__$1 = state_29746;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29746__$1,inst_29744);
} else {
if((state_val_29747 === (2))){
var inst_29725 = (state_29746[(8)]);
var _ = (function (){var statearr_29755 = state_29746;
(statearr_29755[(4)] = cljs.core.cons((5),(state_29746[(4)])));

return statearr_29755;
})();
var inst_29725__$1 = cljs.core.volatile_BANG_((0));
var inst_29726 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_29727 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_29726,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_29725__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_29728 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_29727);
var inst_29729 = fluree.db.query.fql.query(db,inst_29728);
var state_29746__$1 = (function (){var statearr_29756 = state_29746;
(statearr_29756[(8)] = inst_29725__$1);

return statearr_29756;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29746__$1,(6),inst_29729);
} else {
if((state_val_29747 === (9))){
var inst_29741 = (state_29746[(2)]);
var _ = (function (){var statearr_29757 = state_29746;
(statearr_29757[(4)] = cljs.core.rest((state_29746[(4)])));

return statearr_29757;
})();
var state_29746__$1 = state_29746;
var statearr_29758_29839 = state_29746__$1;
(statearr_29758_29839[(2)] = inst_29741);

(statearr_29758_29839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29747 === (5))){
var _ = (function (){var statearr_29759 = state_29746;
(statearr_29759[(4)] = cljs.core.rest((state_29746[(4)])));

return statearr_29759;
})();
var state_29746__$1 = state_29746;
var ex29754 = (state_29746__$1[(2)]);
var statearr_29760_29840 = state_29746__$1;
(statearr_29760_29840[(5)] = ex29754);


if((ex29754 instanceof Error)){
var statearr_29761_29841 = state_29746__$1;
(statearr_29761_29841[(1)] = (4));

(statearr_29761_29841[(5)] = null);

} else {
throw ex29754;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29747 === (8))){
var inst_29725 = (state_29746[(8)]);
var inst_29731 = (state_29746[(7)]);
var inst_29736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29737 = cljs.core.deref(inst_29725);
var inst_29738 = [inst_29731,inst_29737];
var inst_29739 = (new cljs.core.PersistentVector(null,2,(5),inst_29736,inst_29738,null));
var state_29746__$1 = state_29746;
var statearr_29762_29842 = state_29746__$1;
(statearr_29762_29842[(2)] = inst_29739);

(statearr_29762_29842[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_29763 = [null,null,null,null,null,null,null,null,null];
(statearr_29763[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_29763[(1)] = (1));

return statearr_29763;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_29746){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29746);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29764){var ex__2687__auto__ = e29764;
var statearr_29765_29843 = state_29746;
(statearr_29765_29843[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29746[(4)]))){
var statearr_29766_29844 = state_29746;
(statearr_29766_29844[(1)] = cljs.core.first((state_29746[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29845 = state_29746;
state_29746 = G__29845;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_29746){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_29746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29767 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29767[(6)] = c__2706__auto__);

return statearr_29767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29812){
var state_val_29813 = (state_29812[(1)]);
if((state_val_29813 === (7))){
var inst_29798 = (state_29812[(2)]);
var inst_29799 = fluree.db.query.fql.query(db,inst_29798);
var state_29812__$1 = state_29812;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29812__$1,(8),inst_29799);
} else {
if((state_val_29813 === (1))){
var inst_29768 = typeof select === 'string';
var state_29812__$1 = state_29812;
if(cljs.core.truth_(inst_29768)){
var statearr_29814_29846 = state_29812__$1;
(statearr_29814_29846[(1)] = (2));

} else {
var statearr_29815_29847 = state_29812__$1;
(statearr_29815_29847[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29813 === (4))){
var inst_29781 = (state_29812[(7)]);
var inst_29774 = (state_29812[(8)]);
var inst_29773 = (state_29812[(2)]);
var inst_29774__$1 = cljs.core.volatile_BANG_((0));
var inst_29775 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29776 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_29777 = [inst_29774__$1,(100000)];
var inst_29778 = cljs.core.PersistentHashMap.fromArrays(inst_29776,inst_29777);
var inst_29779 = [inst_29773,from,where,block,limit,inst_29778];
var inst_29780 = cljs.core.PersistentHashMap.fromArrays(inst_29775,inst_29779);
var inst_29781__$1 = fluree.db.util.core.without_nils(inst_29780);
var inst_29782 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29781__$1);
var inst_29783 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29781__$1);
var inst_29784 = cljs.core.first(inst_29783);
var inst_29785 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29784], 0));
var inst_29786 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_29785);
var inst_29787 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29781__$1);
var inst_29788 = cljs.core.last(inst_29787);
var inst_29789 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29788], 0));
var inst_29790 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_29789);
var inst_29791 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29782,inst_29786,inst_29790], 0));
var state_29812__$1 = (function (){var statearr_29816 = state_29812;
(statearr_29816[(7)] = inst_29781__$1);

(statearr_29816[(8)] = inst_29774__$1);

return statearr_29816;
})();
if(cljs.core.truth_(inst_29791)){
var statearr_29817_29848 = state_29812__$1;
(statearr_29817_29848[(1)] = (5));

} else {
var statearr_29818_29849 = state_29812__$1;
(statearr_29818_29849[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29813 === (6))){
var inst_29781 = (state_29812[(7)]);
var state_29812__$1 = state_29812;
var statearr_29819_29850 = state_29812__$1;
(statearr_29819_29850[(2)] = inst_29781);

(statearr_29819_29850[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29813 === (3))){
var state_29812__$1 = state_29812;
var statearr_29820_29851 = state_29812__$1;
(statearr_29820_29851[(2)] = select);

(statearr_29820_29851[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29813 === (2))){
var inst_29770 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_29812__$1 = state_29812;
var statearr_29821_29852 = state_29812__$1;
(statearr_29821_29852[(2)] = inst_29770);

(statearr_29821_29852[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29813 === (11))){
var inst_29810 = (state_29812[(2)]);
var state_29812__$1 = state_29812;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29812__$1,inst_29810);
} else {
if((state_val_29813 === (9))){
var inst_29801 = (state_29812[(9)]);
var state_29812__$1 = state_29812;
var statearr_29822_29853 = state_29812__$1;
(statearr_29822_29853[(2)] = inst_29801);

(statearr_29822_29853[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29813 === (5))){
var inst_29781 = (state_29812[(7)]);
var inst_29793 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29781);
var inst_29794 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_29793);
var inst_29795 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29781,new cljs.core.Keyword(null,"where","where",-2044795965),inst_29794);
var state_29812__$1 = state_29812;
var statearr_29823_29854 = state_29812__$1;
(statearr_29823_29854[(2)] = inst_29795);

(statearr_29823_29854[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29813 === (10))){
var inst_29801 = (state_29812[(9)]);
var inst_29774 = (state_29812[(8)]);
var inst_29805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29806 = cljs.core.deref(inst_29774);
var inst_29807 = [inst_29801,inst_29806];
var inst_29808 = (new cljs.core.PersistentVector(null,2,(5),inst_29805,inst_29807,null));
var state_29812__$1 = state_29812;
var statearr_29824_29855 = state_29812__$1;
(statearr_29824_29855[(2)] = inst_29808);

(statearr_29824_29855[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29813 === (8))){
var inst_29801 = (state_29812[(9)]);
var inst_29801__$1 = (state_29812[(2)]);
var inst_29802 = fluree.db.util.core.exception_QMARK_(inst_29801__$1);
var state_29812__$1 = (function (){var statearr_29825 = state_29812;
(statearr_29825[(9)] = inst_29801__$1);

return statearr_29825;
})();
if(inst_29802){
var statearr_29826_29856 = state_29812__$1;
(statearr_29826_29856[(1)] = (9));

} else {
var statearr_29827_29857 = state_29812__$1;
(statearr_29827_29857[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_29828 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29828[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_29828[(1)] = (1));

return statearr_29828;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_29812){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29812);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29829){var ex__2687__auto__ = e29829;
var statearr_29830_29858 = state_29812;
(statearr_29830_29858[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29812[(4)]))){
var statearr_29831_29859 = state_29812;
(statearr_29831_29859[(1)] = cljs.core.first((state_29812[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29860 = state_29812;
state_29812 = G__29860;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_29812){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_29812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29832 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29832[(6)] = c__2706__auto__);

return statearr_29832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__29864 = path;
var vec__29865 = G__29864;
var seq__29866 = cljs.core.seq(vec__29865);
var first__29867 = cljs.core.first(seq__29866);
var seq__29866__$1 = cljs.core.next(seq__29866);
var var$ = first__29867;
var r = seq__29866__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__29864__$1 = G__29864;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__29871 = G__29864__$1;
var seq__29872 = cljs.core.seq(vec__29871);
var first__29873 = cljs.core.first(seq__29872);
var seq__29872__$1 = cljs.core.next(seq__29872);
var var$__$1 = first__29873;
var r__$1 = seq__29872__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__29874 = r__$1;
var G__29875 = n__$2;
var G__29876 = next_clauses;
G__29864__$1 = G__29874;
n__$1 = G__29875;
where_clauses__$1 = G__29876;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__29877 = r__$1;
var G__29878 = next_n;
var G__29879 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__29864__$1 = G__29877;
n__$1 = G__29878;
where_clauses__$1 = G__29879;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29916){
var state_val_29917 = (state_29916[(1)]);
if((state_val_29917 === (7))){
var inst_29889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29890 = [path];
var inst_29891 = (new cljs.core.PersistentVector(null,1,(5),inst_29889,inst_29890,null));
var state_29916__$1 = state_29916;
var statearr_29918_29946 = state_29916__$1;
(statearr_29918_29946[(2)] = inst_29891);

(statearr_29918_29946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (1))){
var state_29916__$1 = state_29916;
var statearr_29919_29947 = state_29916__$1;
(statearr_29919_29947[(2)] = null);

(statearr_29919_29947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (4))){
var inst_29880 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
var statearr_29920_29948 = state_29916__$1;
(statearr_29920_29948[(2)] = inst_29880);

(statearr_29920_29948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (13))){
var inst_29907 = (state_29916[(2)]);
var inst_29908 = fluree.db.util.async.throw_err(inst_29907);
var _ = (function (){var statearr_29921 = state_29916;
(statearr_29921[(4)] = cljs.core.rest((state_29916[(4)])));

return statearr_29921;
})();
var state_29916__$1 = state_29916;
var statearr_29922_29949 = state_29916__$1;
(statearr_29922_29949[(2)] = inst_29908);

(statearr_29922_29949[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (6))){
var state_29916__$1 = state_29916;
var statearr_29924_29950 = state_29916__$1;
(statearr_29924_29950[(2)] = path);

(statearr_29924_29950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (3))){
var inst_29914 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29916__$1,inst_29914);
} else {
if((state_val_29917 === (12))){
var _ = (function (){var statearr_29925 = state_29916;
(statearr_29925[(4)] = cljs.core.rest((state_29916[(4)])));

return statearr_29925;
})();
var state_29916__$1 = state_29916;
var ex29923 = (state_29916__$1[(2)]);
var statearr_29926_29951 = state_29916__$1;
(statearr_29926_29951[(5)] = ex29923);


var statearr_29927_29952 = state_29916__$1;
(statearr_29927_29952[(1)] = (11));

(statearr_29927_29952[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (2))){
var _ = (function (){var statearr_29928 = state_29916;
(statearr_29928[(4)] = cljs.core.cons((5),(state_29916[(4)])));

return statearr_29928;
})();
var inst_29886 = cljs.core.vector_QMARK_(path);
var state_29916__$1 = state_29916;
if(inst_29886){
var statearr_29929_29953 = state_29916__$1;
(statearr_29929_29953[(1)] = (6));

} else {
var statearr_29930_29954 = state_29916__$1;
(statearr_29930_29954[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (11))){
var inst_29893 = (state_29916[(7)]);
var inst_29898 = (state_29916[(2)]);
var inst_29899 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29898,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_29893,endSubject], 0));
var state_29916__$1 = state_29916;
var statearr_29932_29955 = state_29916__$1;
(statearr_29932_29955[(2)] = inst_29899);

(statearr_29932_29955[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (9))){
var inst_29897 = (state_29916[(8)]);
var _ = (function (){var statearr_29933 = state_29916;
(statearr_29933[(4)] = cljs.core.cons((12),(state_29916[(4)])));

return statearr_29933;
})();
var inst_29905 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_29897);
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29916__$1,(13),inst_29905);
} else {
if((state_val_29917 === (5))){
var _ = (function (){var statearr_29934 = state_29916;
(statearr_29934[(4)] = cljs.core.rest((state_29916[(4)])));

return statearr_29934;
})();
var state_29916__$1 = state_29916;
var ex29931 = (state_29916__$1[(2)]);
var statearr_29935_29956 = state_29916__$1;
(statearr_29935_29956[(5)] = ex29931);


if((ex29931 instanceof Error)){
var statearr_29936_29957 = state_29916__$1;
(statearr_29936_29957[(1)] = (4));

(statearr_29936_29957[(5)] = null);

} else {
throw ex29931;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (10))){
var inst_29911 = (state_29916[(2)]);
var _ = (function (){var statearr_29937 = state_29916;
(statearr_29937[(4)] = cljs.core.rest((state_29916[(4)])));

return statearr_29937;
})();
var state_29916__$1 = state_29916;
var statearr_29938_29958 = state_29916__$1;
(statearr_29938_29958[(2)] = inst_29911);

(statearr_29938_29958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (8))){
var inst_29893 = (state_29916[(7)]);
var inst_29893__$1 = (state_29916[(2)]);
var inst_29894 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_29893__$1,endSubject);
var inst_29895 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_29896 = ["?var1",inst_29894];
var inst_29897 = cljs.core.PersistentHashMap.fromArrays(inst_29895,inst_29896);
var state_29916__$1 = (function (){var statearr_29939 = state_29916;
(statearr_29939[(8)] = inst_29897);

(statearr_29939[(7)] = inst_29893__$1);

return statearr_29939;
})();
var statearr_29940_29959 = state_29916__$1;
(statearr_29940_29959[(2)] = null);

(statearr_29940_29959[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_29941 = [null,null,null,null,null,null,null,null,null];
(statearr_29941[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__);

(statearr_29941[(1)] = (1));

return statearr_29941;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1 = (function (state_29916){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29916);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29942){var ex__2687__auto__ = e29942;
var statearr_29943_29960 = state_29916;
(statearr_29943_29960[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29916[(4)]))){
var statearr_29944_29961 = state_29916;
(statearr_29944_29961[(1)] = cljs.core.first((state_29916[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29962 = state_29916;
state_29916 = G__29962;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__ = function(state_29916){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1.call(this,state_29916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29945 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29945[(6)] = c__2706__auto__);

return statearr_29945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e29963){var e = e29963;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e29964){var e = e29964;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e29965){var e = e29965;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e29966){var e = e29966;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29969 = arguments.length;
var i__5770__auto___29970 = (0);
while(true){
if((i__5770__auto___29970 < len__5769__auto___29969)){
args__5775__auto__.push((arguments[i__5770__auto___29970]));

var G__29971 = (i__5770__auto___29970 + (1));
i__5770__auto___29970 = G__29971;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e29968){var e = e29968;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq29967){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29967));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29974 = arguments.length;
var i__5770__auto___29975 = (0);
while(true){
if((i__5770__auto___29975 < len__5769__auto___29974)){
args__5775__auto__.push((arguments[i__5770__auto___29975]));

var G__29976 = (i__5770__auto___29975 + (1));
i__5770__auto___29975 = G__29976;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e29973){var e = e29973;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq29972){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29972));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29979 = arguments.length;
var i__5770__auto___29980 = (0);
while(true){
if((i__5770__auto___29980 < len__5769__auto___29979)){
args__5775__auto__.push((arguments[i__5770__auto___29980]));

var G__29981 = (i__5770__auto___29980 + (1));
i__5770__auto___29980 = G__29981;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e29978){var e = e29978;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq29977){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29977));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29984 = arguments.length;
var i__5770__auto___29985 = (0);
while(true){
if((i__5770__auto___29985 < len__5769__auto___29984)){
args__5775__auto__.push((arguments[i__5770__auto___29985]));

var G__29986 = (i__5770__auto___29985 + (1));
i__5770__auto___29985 = G__29986;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e29983){var e = e29983;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq29982){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29982));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e29987){var e = e29987;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e29988){var e = e29988;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e29989){var e = e29989;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e29990){var e = e29990;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e29991){var e = e29991;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__29997 = path;
var vec__29998 = G__29997;
var seq__29999 = cljs.core.seq(vec__29998);
var first__30000 = cljs.core.first(seq__29999);
var seq__29999__$1 = cljs.core.next(seq__29999);
var pred = first__30000;
var r = seq__29999__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__29997__$1 = G__29997;
var subjects__$1 = subjects;
while(true){
var vec__30004 = G__29997__$1;
var seq__30005 = cljs.core.seq(vec__30004);
var first__30006 = cljs.core.first(seq__30005);
var seq__30005__$1 = cljs.core.next(seq__30005);
var pred__$1 = first__30006;
var r__$1 = seq__30005__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__29997__$1,subjects__$1,vec__30004,seq__30005,first__30006,seq__30005__$1,pred__$1,r__$1,subjects__$2,G__29997,vec__29998,seq__29999,first__30000,seq__29999__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__29997__$1,subjects__$1,vec__30004,seq__30005,first__30006,seq__30005__$1,pred__$1,r__$1,subjects__$2,G__29997,vec__29998,seq__29999,first__30000,seq__29999__$1,pred,r,subjects){
return (function (p1__29992_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__29992_SHARP_,pred__$1);
});})(G__29997__$1,subjects__$1,vec__30004,seq__30005,first__30006,seq__30005__$1,pred__$1,r__$1,subjects__$2,G__29997,vec__29998,seq__29999,first__30000,seq__29999__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__29997__$1,subjects__$1,vec__30004,seq__30005,first__30006,seq__30005__$1,pred__$1,r__$1,subjects__$2,G__29997,vec__29998,seq__29999,first__30000,seq__29999__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__30007 = r__$1;
var G__30008 = next_subjects;
G__29997__$1 = G__30007;
subjects__$1 = G__30008;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e29993){var e = e29993;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e30009){var e = e30009;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e30010){var e = e30010;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___30013 = arguments.length;
var i__5770__auto___30014 = (0);
while(true){
if((i__5770__auto___30014 < len__5769__auto___30013)){
args__5775__auto__.push((arguments[i__5770__auto___30014]));

var G__30015 = (i__5770__auto___30014 + (1));
i__5770__auto___30014 = G__30015;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e30012){var e = e30012;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq30011){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30011));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e30016){var e = e30016;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___30019 = arguments.length;
var i__5770__auto___30020 = (0);
while(true){
if((i__5770__auto___30020 < len__5769__auto___30019)){
args__5775__auto__.push((arguments[i__5770__auto___30020]));

var G__30021 = (i__5770__auto___30020 + (1));
i__5770__auto___30020 = G__30021;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e30018){var e = e30018;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq30017){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30017));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e30022){var e = e30022;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_30079){
var state_val_30080 = (state_30079[(1)]);
if((state_val_30080 === (7))){
var inst_30025 = (state_30079[(2)]);
var state_30079__$1 = state_30079;
var statearr_30081_30115 = state_30079__$1;
(statearr_30081_30115[(2)] = inst_30025);

(statearr_30081_30115[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (1))){
var state_30079__$1 = state_30079;
var statearr_30082_30116 = state_30079__$1;
(statearr_30082_30116[(2)] = null);

(statearr_30082_30116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (4))){
var inst_30024 = (state_30079[(2)]);
var state_30079__$1 = (function (){var statearr_30083 = state_30079;
(statearr_30083[(7)] = inst_30024);

return statearr_30083;
})();
var statearr_30084_30117 = state_30079__$1;
(statearr_30084_30117[(2)] = null);

(statearr_30084_30117[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (15))){
var inst_30060 = (state_30079[(8)]);
var inst_30050 = (state_30079[(9)]);
var inst_30047 = (state_30079[(10)]);
var inst_30049 = (state_30079[(11)]);
var inst_30059 = (state_30079[(12)]);
var inst_30062 = (state_30079[(13)]);
var inst_30066 = (function (){var db = inst_30047;
var prevT = inst_30049;
var db_SINGLEQUOTE_ = inst_30050;
var prev_vals = inst_30059;
var fuel = inst_30060;
var G__30061 = inst_30062;
return (function (p1__30023_SHARP_){
var f = p1__30023_SHARP_;
return f.o;
});
})();
var inst_30067 = (inst_30066.cljs$core$IFn$_invoke$arity$1 ? inst_30066.cljs$core$IFn$_invoke$arity$1(inst_30062) : inst_30066.call(null,inst_30062));
var state_30079__$1 = state_30079;
var statearr_30085_30118 = state_30079__$1;
(statearr_30085_30118[(2)] = inst_30067);

(statearr_30085_30118[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (13))){
var inst_30059 = (state_30079[(12)]);
var inst_30062 = (state_30079[(13)]);
var inst_30058 = (state_30079[(2)]);
var inst_30059__$1 = fluree.db.util.async.throw_err(inst_30058);
var inst_30060 = fluree.db.dbfunctions.internal.count(inst_30059__$1);
var inst_30062__$1 = cljs.core.first(inst_30059__$1);
var inst_30063 = (inst_30062__$1 == null);
var state_30079__$1 = (function (){var statearr_30086 = state_30079;
(statearr_30086[(8)] = inst_30060);

(statearr_30086[(12)] = inst_30059__$1);

(statearr_30086[(13)] = inst_30062__$1);

return statearr_30086;
})();
if(cljs.core.truth_(inst_30063)){
var statearr_30087_30119 = state_30079__$1;
(statearr_30087_30119[(1)] = (14));

} else {
var statearr_30088_30120 = state_30079__$1;
(statearr_30088_30120[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (6))){
var inst_30034 = (state_30079[(2)]);
var state_30079__$1 = state_30079;
var statearr_30089_30121 = state_30079__$1;
(statearr_30089_30121[(2)] = inst_30034);

(statearr_30089_30121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (3))){
var inst_30077 = (state_30079[(2)]);
var state_30079__$1 = state_30079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30079__$1,inst_30077);
} else {
if((state_val_30080 === (12))){
var inst_30074 = (state_30079[(2)]);
var _ = (function (){var statearr_30090 = state_30079;
(statearr_30090[(4)] = cljs.core.rest((state_30079[(4)])));

return statearr_30090;
})();
var state_30079__$1 = state_30079;
var statearr_30091_30122 = state_30079__$1;
(statearr_30091_30122[(2)] = inst_30074);

(statearr_30091_30122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (2))){
var _ = (function (){var statearr_30093 = state_30079;
(statearr_30093[(4)] = cljs.core.cons((9),(state_30079[(4)])));

return statearr_30093;
})();
var inst_30040 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30041 = typeof inst_30040 === 'string';
var state_30079__$1 = state_30079;
if(cljs.core.truth_(inst_30041)){
var statearr_30094_30123 = state_30079__$1;
(statearr_30094_30123[(1)] = (10));

} else {
var statearr_30095_30124 = state_30079__$1;
(statearr_30095_30124[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (11))){
var inst_30050 = (state_30079[(9)]);
var inst_30047 = (state_30079[(10)]);
var inst_30049 = (state_30079[(11)]);
var inst_30047__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30048 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_30047__$1);
var inst_30049__$1 = fluree.db.dbfunctions.internal.inc(inst_30048);
var inst_30050__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_30047__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_30049__$1);
var inst_30051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30052 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30053 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30054 = [inst_30052,inst_30053];
var inst_30055 = (new cljs.core.PersistentVector(null,2,(5),inst_30051,inst_30054,null));
var inst_30056 = fluree.db.dbproto._search(inst_30050__$1,inst_30055);
var state_30079__$1 = (function (){var statearr_30096 = state_30079;
(statearr_30096[(9)] = inst_30050__$1);

(statearr_30096[(10)] = inst_30047__$1);

(statearr_30096[(11)] = inst_30049__$1);

return statearr_30096;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30079__$1,(13),inst_30056);
} else {
if((state_val_30080 === (9))){
var _ = (function (){var statearr_30097 = state_30079;
(statearr_30097[(4)] = cljs.core.rest((state_30079[(4)])));

return statearr_30097;
})();
var state_30079__$1 = state_30079;
var ex30092 = (state_30079__$1[(2)]);
var statearr_30098_30125 = state_30079__$1;
(statearr_30098_30125[(5)] = ex30092);


var statearr_30099_30126 = state_30079__$1;
(statearr_30099_30126[(1)] = (4));

(statearr_30099_30126[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (5))){
var inst_30024 = (state_30079[(7)]);
var _ = (function (){var statearr_30100 = state_30079;
(statearr_30100[(4)] = cljs.core.cons((8),(state_30079[(4)])));

return statearr_30100;
})();
var inst_30031 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_30024,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_30101 = state_30079;
(statearr_30101[(4)] = cljs.core.rest((state_30079[(4)])));

return statearr_30101;
})();
var state_30079__$1 = state_30079;
var statearr_30102_30127 = state_30079__$1;
(statearr_30102_30127[(2)] = inst_30031);

(statearr_30102_30127[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (14))){
var state_30079__$1 = state_30079;
var statearr_30103_30128 = state_30079__$1;
(statearr_30103_30128[(2)] = null);

(statearr_30103_30128[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (16))){
var inst_30060 = (state_30079[(8)]);
var inst_30069 = (state_30079[(2)]);
var inst_30070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30071 = [inst_30069,inst_30060];
var inst_30072 = (new cljs.core.PersistentVector(null,2,(5),inst_30070,inst_30071,null));
var state_30079__$1 = state_30079;
var statearr_30105_30129 = state_30079__$1;
(statearr_30105_30129[(2)] = inst_30072);

(statearr_30105_30129[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (10))){
var inst_30043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30044 = [null,(0)];
var inst_30045 = (new cljs.core.PersistentVector(null,2,(5),inst_30043,inst_30044,null));
var state_30079__$1 = state_30079;
var statearr_30106_30130 = state_30079__$1;
(statearr_30106_30130[(2)] = inst_30045);

(statearr_30106_30130[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30080 === (8))){
var _ = (function (){var statearr_30107 = state_30079;
(statearr_30107[(4)] = cljs.core.rest((state_30079[(4)])));

return statearr_30107;
})();
var state_30079__$1 = state_30079;
var ex30104 = (state_30079__$1[(2)]);
var statearr_30108_30131 = state_30079__$1;
(statearr_30108_30131[(5)] = ex30104);


var statearr_30109_30132 = state_30079__$1;
(statearr_30109_30132[(1)] = (7));

(statearr_30109_30132[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0 = (function (){
var statearr_30110 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30110[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__);

(statearr_30110[(1)] = (1));

return statearr_30110;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1 = (function (state_30079){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_30079);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e30111){var ex__2687__auto__ = e30111;
var statearr_30112_30133 = state_30079;
(statearr_30112_30133[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_30079[(4)]))){
var statearr_30113_30134 = state_30079;
(statearr_30113_30134[(1)] = cljs.core.first((state_30079[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30135 = state_30079;
state_30079 = G__30135;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__ = function(state_30079){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1.call(this,state_30079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_30114 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_30114[(6)] = c__2706__auto__);

return statearr_30114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_30187){
var state_val_30188 = (state_30187[(1)]);
if((state_val_30188 === (7))){
var inst_30137 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
var statearr_30189_30218 = state_30187__$1;
(statearr_30189_30218[(2)] = inst_30137);

(statearr_30189_30218[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (1))){
var state_30187__$1 = state_30187;
var statearr_30190_30219 = state_30187__$1;
(statearr_30190_30219[(2)] = null);

(statearr_30190_30219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (4))){
var inst_30136 = (state_30187[(2)]);
var state_30187__$1 = (function (){var statearr_30191 = state_30187;
(statearr_30191[(7)] = inst_30136);

return statearr_30191;
})();
var statearr_30192_30220 = state_30187__$1;
(statearr_30192_30220[(2)] = null);

(statearr_30192_30220[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (13))){
var inst_30182 = (state_30187[(2)]);
var _ = (function (){var statearr_30193 = state_30187;
(statearr_30193[(4)] = cljs.core.rest((state_30187[(4)])));

return statearr_30193;
})();
var state_30187__$1 = state_30187;
var statearr_30194_30221 = state_30187__$1;
(statearr_30194_30221[(2)] = inst_30182);

(statearr_30194_30221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (6))){
var inst_30146 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
var statearr_30195_30222 = state_30187__$1;
(statearr_30195_30222[(2)] = inst_30146);

(statearr_30195_30222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (3))){
var inst_30185 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30187__$1,inst_30185);
} else {
if((state_val_30188 === (12))){
var inst_30169 = (state_30187[(8)]);
var inst_30178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30179 = [null,inst_30169];
var inst_30180 = (new cljs.core.PersistentVector(null,2,(5),inst_30178,inst_30179,null));
var state_30187__$1 = state_30187;
var statearr_30196_30223 = state_30187__$1;
(statearr_30196_30223[(2)] = inst_30180);

(statearr_30196_30223[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (2))){
var _ = (function (){var statearr_30198 = state_30187;
(statearr_30198[(4)] = cljs.core.cons((9),(state_30187[(4)])));

return statearr_30198;
})();
var inst_30155 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30158 = [null,pred_name,"?o"];
var inst_30159 = (new cljs.core.PersistentVector(null,3,(5),inst_30157,inst_30158,null));
var inst_30160 = [inst_30159];
var inst_30161 = (new cljs.core.PersistentVector(null,1,(5),inst_30156,inst_30160,null));
var inst_30162 = ["?o",inst_30161,opts];
var inst_30163 = cljs.core.PersistentHashMap.fromArrays(inst_30155,inst_30162);
var inst_30164 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_30163);
var state_30187__$1 = state_30187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30187__$1,(10),inst_30164);
} else {
if((state_val_30188 === (11))){
var inst_30169 = (state_30187[(8)]);
var inst_30168 = (state_30187[(9)]);
var inst_30173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30174 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_30168);
var inst_30175 = [inst_30174,inst_30169];
var inst_30176 = (new cljs.core.PersistentVector(null,2,(5),inst_30173,inst_30175,null));
var state_30187__$1 = state_30187;
var statearr_30199_30224 = state_30187__$1;
(statearr_30199_30224[(2)] = inst_30176);

(statearr_30199_30224[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (9))){
var _ = (function (){var statearr_30200 = state_30187;
(statearr_30200[(4)] = cljs.core.rest((state_30187[(4)])));

return statearr_30200;
})();
var state_30187__$1 = state_30187;
var ex30197 = (state_30187__$1[(2)]);
var statearr_30201_30225 = state_30187__$1;
(statearr_30201_30225[(5)] = ex30197);


var statearr_30202_30226 = state_30187__$1;
(statearr_30202_30226[(1)] = (4));

(statearr_30202_30226[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (5))){
var inst_30136 = (state_30187[(7)]);
var _ = (function (){var statearr_30204 = state_30187;
(statearr_30204[(4)] = cljs.core.cons((8),(state_30187[(4)])));

return statearr_30204;
})();
var inst_30143 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_30136,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_30205 = state_30187;
(statearr_30205[(4)] = cljs.core.rest((state_30187[(4)])));

return statearr_30205;
})();
var state_30187__$1 = state_30187;
var statearr_30206_30227 = state_30187__$1;
(statearr_30206_30227[(2)] = inst_30143);

(statearr_30206_30227[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (10))){
var inst_30168 = (state_30187[(9)]);
var inst_30166 = (state_30187[(2)]);
var inst_30167 = fluree.db.util.async.throw_err(inst_30166);
var inst_30168__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30167,(0),null);
var inst_30169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30167,(1),null);
var inst_30170 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_30168__$1);
var inst_30171 = cljs.core.not(inst_30170);
var state_30187__$1 = (function (){var statearr_30207 = state_30187;
(statearr_30207[(8)] = inst_30169);

(statearr_30207[(9)] = inst_30168__$1);

return statearr_30207;
})();
if(inst_30171){
var statearr_30208_30228 = state_30187__$1;
(statearr_30208_30228[(1)] = (11));

} else {
var statearr_30209_30229 = state_30187__$1;
(statearr_30209_30229[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (8))){
var _ = (function (){var statearr_30210 = state_30187;
(statearr_30210[(4)] = cljs.core.rest((state_30187[(4)])));

return statearr_30210;
})();
var state_30187__$1 = state_30187;
var ex30203 = (state_30187__$1[(2)]);
var statearr_30211_30230 = state_30187__$1;
(statearr_30211_30230[(5)] = ex30203);


var statearr_30212_30231 = state_30187__$1;
(statearr_30212_30231[(1)] = (7));

(statearr_30212_30231[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0 = (function (){
var statearr_30213 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30213[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__);

(statearr_30213[(1)] = (1));

return statearr_30213;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1 = (function (state_30187){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_30187);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e30214){var ex__2687__auto__ = e30214;
var statearr_30215_30232 = state_30187;
(statearr_30215_30232[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_30187[(4)]))){
var statearr_30216_30233 = state_30187;
(statearr_30216_30233[(1)] = cljs.core.first((state_30187[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30234 = state_30187;
state_30187 = G__30234;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__ = function(state_30187){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1.call(this,state_30187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_30217 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_30217[(6)] = c__2706__auto__);

return statearr_30217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e30235){var e = e30235;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__30237 = arguments.length;
switch (G__30237) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_30307){
var state_val_30308 = (state_30307[(1)]);
if((state_val_30308 === (7))){
var inst_30239 = (state_30307[(2)]);
var state_30307__$1 = state_30307;
var statearr_30309_30353 = state_30307__$1;
(statearr_30309_30353[(2)] = inst_30239);

(statearr_30309_30353[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (20))){
var inst_30283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30284 = ["*"];
var inst_30285 = (new cljs.core.PersistentVector(null,1,(5),inst_30283,inst_30284,null));
var state_30307__$1 = state_30307;
var statearr_30310_30354 = state_30307__$1;
(statearr_30310_30354[(2)] = inst_30285);

(statearr_30310_30354[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (1))){
var state_30307__$1 = state_30307;
var statearr_30311_30355 = state_30307__$1;
(statearr_30311_30355[(2)] = null);

(statearr_30311_30355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (4))){
var inst_30238 = (state_30307[(2)]);
var state_30307__$1 = (function (){var statearr_30312 = state_30307;
(statearr_30312[(7)] = inst_30238);

return statearr_30312;
})();
var statearr_30313_30356 = state_30307__$1;
(statearr_30313_30356[(2)] = null);

(statearr_30313_30356[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (15))){
var inst_30302 = (state_30307[(2)]);
var _ = (function (){var statearr_30314 = state_30307;
(statearr_30314[(4)] = cljs.core.rest((state_30307[(4)])));

return statearr_30314;
})();
var state_30307__$1 = state_30307;
var statearr_30315_30357 = state_30307__$1;
(statearr_30315_30357[(2)] = inst_30302);

(statearr_30315_30357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (21))){
var inst_30266 = (state_30307[(8)]);
var inst_30273 = (state_30307[(9)]);
var inst_30287 = (state_30307[(2)]);
var inst_30288 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30289 = cljs.core.PersistentHashMap.EMPTY;
var inst_30290 = [inst_30287,inst_30273,inst_30289];
var inst_30291 = cljs.core.PersistentHashMap.fromArrays(inst_30288,inst_30290);
var inst_30292 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_30266,inst_30291);
var state_30307__$1 = state_30307;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30307__$1,(22),inst_30292);
} else {
if((state_val_30308 === (13))){
var inst_30261 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30307__$1 = state_30307;
var statearr_30316_30358 = state_30307__$1;
(statearr_30316_30358[(2)] = inst_30261);

(statearr_30316_30358[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (22))){
var inst_30294 = (state_30307[(2)]);
var inst_30295 = fluree.db.util.async.throw_err(inst_30294);
var inst_30296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30295,(0),null);
var inst_30297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30295,(1),null);
var inst_30298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30299 = [inst_30296,inst_30297];
var inst_30300 = (new cljs.core.PersistentVector(null,2,(5),inst_30298,inst_30299,null));
var state_30307__$1 = state_30307;
var statearr_30317_30359 = state_30307__$1;
(statearr_30317_30359[(2)] = inst_30300);

(statearr_30317_30359[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (6))){
var inst_30248 = (state_30307[(2)]);
var state_30307__$1 = state_30307;
var statearr_30318_30360 = state_30307__$1;
(statearr_30318_30360[(2)] = inst_30248);

(statearr_30318_30360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (17))){
var inst_30270 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30271 = fluree.db.dbfunctions.internal.get(inst_30270,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_30307__$1 = state_30307;
var statearr_30319_30361 = state_30307__$1;
(statearr_30319_30361[(2)] = inst_30271);

(statearr_30319_30361[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (3))){
var inst_30305 = (state_30307[(2)]);
var state_30307__$1 = state_30307;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30307__$1,inst_30305);
} else {
if((state_val_30308 === (12))){
var inst_30259 = (state_30307[(2)]);
var state_30307__$1 = state_30307;
if(cljs.core.truth_(inst_30259)){
var statearr_30320_30362 = state_30307__$1;
(statearr_30320_30362[(1)] = (13));

} else {
var statearr_30321_30363 = state_30307__$1;
(statearr_30321_30363[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (2))){
var inst_30254 = (state_30307[(10)]);
var _ = (function (){var statearr_30322 = state_30307;
(statearr_30322[(4)] = cljs.core.cons((9),(state_30307[(4)])));

return statearr_30322;
})();
var inst_30254__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30307__$1 = (function (){var statearr_30323 = state_30307;
(statearr_30323[(10)] = inst_30254__$1);

return statearr_30323;
})();
if(cljs.core.truth_(inst_30254__$1)){
var statearr_30324_30364 = state_30307__$1;
(statearr_30324_30364[(1)] = (10));

} else {
var statearr_30325_30365 = state_30307__$1;
(statearr_30325_30365[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (19))){
var inst_30275 = cljs.core.PersistentVector.EMPTY;
var inst_30276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30277 = ["*"];
var inst_30278 = (new cljs.core.PersistentVector(null,1,(5),inst_30276,inst_30277,null));
var inst_30279 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_30280 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_30278,inst_30279);
var inst_30281 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30275,inst_30280);
var state_30307__$1 = state_30307;
var statearr_30327_30366 = state_30307__$1;
(statearr_30327_30366[(2)] = inst_30281);

(statearr_30327_30366[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (11))){
var inst_30254 = (state_30307[(10)]);
var state_30307__$1 = state_30307;
var statearr_30328_30367 = state_30307__$1;
(statearr_30328_30367[(2)] = inst_30254);

(statearr_30328_30367[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (9))){
var _ = (function (){var statearr_30329 = state_30307;
(statearr_30329[(4)] = cljs.core.rest((state_30307[(4)])));

return statearr_30329;
})();
var state_30307__$1 = state_30307;
var ex30326 = (state_30307__$1[(2)]);
var statearr_30330_30368 = state_30307__$1;
(statearr_30330_30368[(5)] = ex30326);


var statearr_30331_30369 = state_30307__$1;
(statearr_30331_30369[(1)] = (4));

(statearr_30331_30369[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (5))){
var inst_30238 = (state_30307[(7)]);
var _ = (function (){var statearr_30332 = state_30307;
(statearr_30332[(4)] = cljs.core.cons((8),(state_30307[(4)])));

return statearr_30332;
})();
var inst_30245 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_30238,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_30333 = state_30307;
(statearr_30333[(4)] = cljs.core.rest((state_30307[(4)])));

return statearr_30333;
})();
var state_30307__$1 = state_30307;
var statearr_30334_30370 = state_30307__$1;
(statearr_30334_30370[(2)] = inst_30245);

(statearr_30334_30370[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (14))){
var inst_30267 = (state_30307[(11)]);
var inst_30266 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30267__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30307__$1 = (function (){var statearr_30335 = state_30307;
(statearr_30335[(8)] = inst_30266);

(statearr_30335[(11)] = inst_30267__$1);

return statearr_30335;
})();
if(cljs.core.truth_(inst_30267__$1)){
var statearr_30336_30371 = state_30307__$1;
(statearr_30336_30371[(1)] = (16));

} else {
var statearr_30337_30372 = state_30307__$1;
(statearr_30337_30372[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (16))){
var inst_30267 = (state_30307[(11)]);
var state_30307__$1 = state_30307;
var statearr_30338_30373 = state_30307__$1;
(statearr_30338_30373[(2)] = inst_30267);

(statearr_30338_30373[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (10))){
var inst_30256 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_30307__$1 = state_30307;
var statearr_30340_30374 = state_30307__$1;
(statearr_30340_30374[(2)] = inst_30256);

(statearr_30340_30374[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (18))){
var inst_30273 = (state_30307[(2)]);
var state_30307__$1 = (function (){var statearr_30341 = state_30307;
(statearr_30341[(9)] = inst_30273);

return statearr_30341;
})();
if(cljs.core.truth_(additional_params)){
var statearr_30342_30375 = state_30307__$1;
(statearr_30342_30375[(1)] = (19));

} else {
var statearr_30343_30376 = state_30307__$1;
(statearr_30343_30376[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30308 === (8))){
var _ = (function (){var statearr_30344 = state_30307;
(statearr_30344[(4)] = cljs.core.rest((state_30307[(4)])));

return statearr_30344;
})();
var state_30307__$1 = state_30307;
var ex30339 = (state_30307__$1[(2)]);
var statearr_30345_30377 = state_30307__$1;
(statearr_30345_30377[(5)] = ex30339);


var statearr_30346_30378 = state_30307__$1;
(statearr_30346_30378[(1)] = (7));

(statearr_30346_30378[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_30347 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30347[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_30347[(1)] = (1));

return statearr_30347;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_30307){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_30307);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e30348){var ex__2687__auto__ = e30348;
var statearr_30349_30379 = state_30307;
(statearr_30349_30379[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_30307[(4)]))){
var statearr_30350_30380 = state_30307;
(statearr_30350_30380[(1)] = cljs.core.first((state_30307[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30381 = state_30307;
state_30307 = G__30381;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_30307){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_30307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_30351 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_30351[(6)] = c__2706__auto__);

return statearr_30351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__30383 = arguments.length;
switch (G__30383) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_30427){
var state_val_30428 = (state_30427[(1)]);
if((state_val_30428 === (7))){
var inst_30405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30406 = ["*"];
var inst_30407 = (new cljs.core.PersistentVector(null,1,(5),inst_30405,inst_30406,null));
var state_30427__$1 = state_30427;
var statearr_30429_30449 = state_30427__$1;
(statearr_30429_30449[(2)] = inst_30407);

(statearr_30429_30449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30428 === (1))){
var state_30427__$1 = state_30427;
var statearr_30430_30450 = state_30427__$1;
(statearr_30430_30450[(2)] = null);

(statearr_30430_30450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30428 === (4))){
var inst_30384 = (state_30427[(2)]);
var inst_30385 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_30384,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_30427__$1 = state_30427;
var statearr_30431_30451 = state_30427__$1;
(statearr_30431_30451[(2)] = inst_30385);

(statearr_30431_30451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30428 === (6))){
var inst_30397 = cljs.core.PersistentVector.EMPTY;
var inst_30398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30399 = ["*"];
var inst_30400 = (new cljs.core.PersistentVector(null,1,(5),inst_30398,inst_30399,null));
var inst_30401 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_30402 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_30400,inst_30401);
var inst_30403 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30397,inst_30402);
var state_30427__$1 = state_30427;
var statearr_30432_30452 = state_30427__$1;
(statearr_30432_30452[(2)] = inst_30403);

(statearr_30432_30452[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30428 === (3))){
var inst_30425 = (state_30427[(2)]);
var state_30427__$1 = state_30427;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30427__$1,inst_30425);
} else {
if((state_val_30428 === (2))){
var _ = (function (){var statearr_30434 = state_30427;
(statearr_30434[(4)] = cljs.core.cons((5),(state_30427[(4)])));

return statearr_30434;
})();
var inst_30394 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30395 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30427__$1 = (function (){var statearr_30435 = state_30427;
(statearr_30435[(7)] = inst_30394);

(statearr_30435[(8)] = inst_30395);

return statearr_30435;
})();
if(cljs.core.truth_(additional_params)){
var statearr_30436_30453 = state_30427__$1;
(statearr_30436_30453[(1)] = (6));

} else {
var statearr_30437_30454 = state_30427__$1;
(statearr_30437_30454[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30428 === (9))){
var inst_30416 = (state_30427[(2)]);
var inst_30417 = fluree.db.util.async.throw_err(inst_30416);
var inst_30418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30417,(0),null);
var inst_30419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30417,(1),null);
var inst_30420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30421 = [inst_30418,inst_30419];
var inst_30422 = (new cljs.core.PersistentVector(null,2,(5),inst_30420,inst_30421,null));
var _ = (function (){var statearr_30438 = state_30427;
(statearr_30438[(4)] = cljs.core.rest((state_30427[(4)])));

return statearr_30438;
})();
var state_30427__$1 = state_30427;
var statearr_30439_30455 = state_30427__$1;
(statearr_30439_30455[(2)] = inst_30422);

(statearr_30439_30455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30428 === (5))){
var _ = (function (){var statearr_30440 = state_30427;
(statearr_30440[(4)] = cljs.core.rest((state_30427[(4)])));

return statearr_30440;
})();
var state_30427__$1 = state_30427;
var ex30433 = (state_30427__$1[(2)]);
var statearr_30441_30456 = state_30427__$1;
(statearr_30441_30456[(5)] = ex30433);


var statearr_30442_30457 = state_30427__$1;
(statearr_30442_30457[(1)] = (4));

(statearr_30442_30457[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30428 === (8))){
var inst_30394 = (state_30427[(7)]);
var inst_30395 = (state_30427[(8)]);
var inst_30409 = (state_30427[(2)]);
var inst_30410 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30411 = cljs.core.PersistentHashMap.EMPTY;
var inst_30412 = [inst_30409,inst_30395,inst_30411];
var inst_30413 = cljs.core.PersistentHashMap.fromArrays(inst_30410,inst_30412);
var inst_30414 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_30394,inst_30413);
var state_30427__$1 = state_30427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30427__$1,(9),inst_30414);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_30443 = [null,null,null,null,null,null,null,null,null];
(statearr_30443[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_30443[(1)] = (1));

return statearr_30443;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_30427){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_30427);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e30444){var ex__2687__auto__ = e30444;
var statearr_30445_30458 = state_30427;
(statearr_30445_30458[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_30427[(4)]))){
var statearr_30446_30459 = state_30427;
(statearr_30446_30459[(1)] = cljs.core.first((state_30427[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30460 = state_30427;
state_30427 = G__30460;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_30427){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_30427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_30447 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_30447[(6)] = c__2706__auto__);

return statearr_30447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_30504){
var state_val_30505 = (state_30504[(1)]);
if((state_val_30505 === (1))){
var state_30504__$1 = state_30504;
var statearr_30506_30520 = state_30504__$1;
(statearr_30506_30520[(2)] = null);

(statearr_30506_30520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (2))){
var _ = (function (){var statearr_30507 = state_30504;
(statearr_30507[(4)] = cljs.core.cons((5),(state_30504[(4)])));

return statearr_30507;
})();
var inst_30471 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30473 = ["_user/_auth"];
var inst_30474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30475 = ["*"];
var inst_30476 = (new cljs.core.PersistentVector(null,1,(5),inst_30474,inst_30475,null));
var inst_30477 = [inst_30476];
var inst_30478 = cljs.core.PersistentHashMap.fromArrays(inst_30473,inst_30477);
var inst_30479 = [inst_30478];
var inst_30480 = (new cljs.core.PersistentVector(null,1,(5),inst_30472,inst_30479,null));
var inst_30481 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30482 = cljs.core.PersistentHashMap.EMPTY;
var inst_30483 = [inst_30480,inst_30481,inst_30482];
var inst_30484 = cljs.core.PersistentHashMap.fromArrays(inst_30471,inst_30483);
var inst_30485 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30486 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_30485,inst_30484);
var state_30504__$1 = state_30504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30504__$1,(6),inst_30486);
} else {
if((state_val_30505 === (3))){
var inst_30502 = (state_30504[(2)]);
var state_30504__$1 = state_30504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30504__$1,inst_30502);
} else {
if((state_val_30505 === (4))){
var inst_30461 = (state_30504[(2)]);
var inst_30462 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_30461,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_30504__$1 = state_30504;
var statearr_30509_30521 = state_30504__$1;
(statearr_30509_30521[(2)] = inst_30462);

(statearr_30509_30521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (5))){
var _ = (function (){var statearr_30510 = state_30504;
(statearr_30510[(4)] = cljs.core.rest((state_30504[(4)])));

return statearr_30510;
})();
var state_30504__$1 = state_30504;
var ex30508 = (state_30504__$1[(2)]);
var statearr_30511_30522 = state_30504__$1;
(statearr_30511_30522[(5)] = ex30508);


var statearr_30512_30523 = state_30504__$1;
(statearr_30512_30523[(1)] = (4));

(statearr_30512_30523[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (6))){
var inst_30488 = (state_30504[(2)]);
var inst_30489 = fluree.db.util.async.throw_err(inst_30488);
var inst_30490 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30489,(0),null);
var inst_30491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30489,(1),null);
var inst_30492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30493 = ["_user/_auth","_id"];
var inst_30494 = (new cljs.core.PersistentVector(null,2,(5),inst_30492,inst_30493,null));
var inst_30495 = fluree.db.dbfunctions.internal.get_in(inst_30490,inst_30494);
var inst_30496 = cljs.core.first(inst_30495);
var inst_30497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30498 = [inst_30496,inst_30491];
var inst_30499 = (new cljs.core.PersistentVector(null,2,(5),inst_30497,inst_30498,null));
var _ = (function (){var statearr_30513 = state_30504;
(statearr_30513[(4)] = cljs.core.rest((state_30504[(4)])));

return statearr_30513;
})();
var state_30504__$1 = state_30504;
var statearr_30514_30524 = state_30504__$1;
(statearr_30514_30524[(2)] = inst_30499);

(statearr_30514_30524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0 = (function (){
var statearr_30515 = [null,null,null,null,null,null,null];
(statearr_30515[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__);

(statearr_30515[(1)] = (1));

return statearr_30515;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1 = (function (state_30504){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_30504);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e30516){var ex__2687__auto__ = e30516;
var statearr_30517_30525 = state_30504;
(statearr_30517_30525[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_30504[(4)]))){
var statearr_30518_30526 = state_30504;
(statearr_30518_30526[(1)] = cljs.core.first((state_30504[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30527 = state_30504;
state_30504 = G__30527;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__ = function(state_30504){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1.call(this,state_30504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_30519 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_30519[(6)] = c__2706__auto__);

return statearr_30519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_30544){
var state_val_30545 = (state_30544[(1)]);
if((state_val_30545 === (1))){
var state_30544__$1 = state_30544;
var statearr_30546_30560 = state_30544__$1;
(statearr_30546_30560[(2)] = null);

(statearr_30546_30560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30545 === (2))){
var _ = (function (){var statearr_30547 = state_30544;
(statearr_30547[(4)] = cljs.core.cons((5),(state_30544[(4)])));

return statearr_30547;
})();
var inst_30534 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30535 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30536 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_30535,inst_30534);
var state_30544__$1 = state_30544;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30544__$1,(6),inst_30536);
} else {
if((state_val_30545 === (3))){
var inst_30542 = (state_30544[(2)]);
var state_30544__$1 = state_30544;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30544__$1,inst_30542);
} else {
if((state_val_30545 === (4))){
var inst_30528 = (state_30544[(2)]);
var state_30544__$1 = state_30544;
var statearr_30549_30561 = state_30544__$1;
(statearr_30549_30561[(2)] = inst_30528);

(statearr_30549_30561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30545 === (5))){
var _ = (function (){var statearr_30550 = state_30544;
(statearr_30550[(4)] = cljs.core.rest((state_30544[(4)])));

return statearr_30550;
})();
var state_30544__$1 = state_30544;
var ex30548 = (state_30544__$1[(2)]);
var statearr_30551_30562 = state_30544__$1;
(statearr_30551_30562[(5)] = ex30548);


if((ex30548 instanceof Error)){
var statearr_30552_30563 = state_30544__$1;
(statearr_30552_30563[(1)] = (4));

(statearr_30552_30563[(5)] = null);

} else {
throw ex30548;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30545 === (6))){
var inst_30538 = (state_30544[(2)]);
var inst_30539 = fluree.db.util.async.throw_err(inst_30538);
var _ = (function (){var statearr_30553 = state_30544;
(statearr_30553[(4)] = cljs.core.rest((state_30544[(4)])));

return statearr_30553;
})();
var state_30544__$1 = state_30544;
var statearr_30554_30564 = state_30544__$1;
(statearr_30554_30564[(2)] = inst_30539);

(statearr_30554_30564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0 = (function (){
var statearr_30555 = [null,null,null,null,null,null,null];
(statearr_30555[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__);

(statearr_30555[(1)] = (1));

return statearr_30555;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1 = (function (state_30544){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_30544);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e30556){var ex__2687__auto__ = e30556;
var statearr_30557_30565 = state_30544;
(statearr_30557_30565[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_30544[(4)]))){
var statearr_30558_30566 = state_30544;
(statearr_30558_30566[(1)] = cljs.core.first((state_30544[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30567 = state_30544;
state_30544 = G__30567;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__ = function(state_30544){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1.call(this,state_30544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_30559 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_30559[(6)] = c__2706__auto__);

return statearr_30559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__30568_SHARP_){
return p1__30568_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30569_SHARP_){
return p1__30569_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e30570){var e = e30570;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__30571_SHARP_){
return p1__30571_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30572_SHARP_){
return p1__30572_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e30573){var e = e30573;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__30575 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__30575);
})() | (0));
return num;
}catch (e30574){var e = e30574;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_30655){
var state_val_30656 = (state_30655[(1)]);
if((state_val_30656 === (7))){
var inst_30594 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_30595 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30596 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30597 = cljs.core.PersistentHashMap.fromArrays(inst_30595,inst_30596);
var inst_30598 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30594,inst_30597);
var inst_30599 = (function(){throw inst_30598})();
var state_30655__$1 = state_30655;
var statearr_30657_30692 = state_30655__$1;
(statearr_30657_30692[(2)] = inst_30599);

(statearr_30657_30692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (1))){
var state_30655__$1 = state_30655;
var statearr_30658_30693 = state_30655__$1;
(statearr_30658_30693[(2)] = null);

(statearr_30658_30693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (4))){
var inst_30576 = (state_30655[(2)]);
var state_30655__$1 = state_30655;
var statearr_30659_30694 = state_30655__$1;
(statearr_30659_30694[(2)] = inst_30576);

(statearr_30659_30694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (15))){
var inst_30639 = (state_30655[(7)]);
var inst_30635 = (state_30655[(2)]);
var inst_30636 = fluree.db.util.async.throw_err(inst_30635);
var inst_30637 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30636,(0),null);
var inst_30638 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30636,(1),null);
var inst_30639__$1 = cljs.core.first(inst_30637);
var inst_30640 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30639__$1,compare_val);
var state_30655__$1 = (function (){var statearr_30660 = state_30655;
(statearr_30660[(7)] = inst_30639__$1);

(statearr_30660[(8)] = inst_30638);

return statearr_30660;
})();
if(inst_30640){
var statearr_30661_30695 = state_30655__$1;
(statearr_30661_30695[(1)] = (16));

} else {
var statearr_30662_30696 = state_30655__$1;
(statearr_30662_30696[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (13))){
var state_30655__$1 = state_30655;
var statearr_30663_30697 = state_30655__$1;
(statearr_30663_30697[(2)] = null);

(statearr_30663_30697[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (6))){
var state_30655__$1 = state_30655;
var statearr_30664_30698 = state_30655__$1;
(statearr_30664_30698[(2)] = null);

(statearr_30664_30698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (17))){
var inst_30639 = (state_30655[(7)]);
var inst_30643 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30639)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_30644 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30645 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30646 = cljs.core.PersistentHashMap.fromArrays(inst_30644,inst_30645);
var inst_30647 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30643,inst_30646);
var inst_30648 = (function(){throw inst_30647})();
var state_30655__$1 = state_30655;
var statearr_30665_30699 = state_30655__$1;
(statearr_30665_30699[(2)] = inst_30648);

(statearr_30665_30699[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (3))){
var inst_30653 = (state_30655[(2)]);
var state_30655__$1 = state_30655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30655__$1,inst_30653);
} else {
if((state_val_30656 === (12))){
var inst_30591 = (state_30655[(9)]);
var inst_30614 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_30591], 0));
var inst_30615 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30616 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30617 = cljs.core.PersistentHashMap.fromArrays(inst_30615,inst_30616);
var inst_30618 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30614,inst_30617);
var inst_30619 = (function(){throw inst_30618})();
var state_30655__$1 = state_30655;
var statearr_30666_30700 = state_30655__$1;
(statearr_30666_30700[(2)] = inst_30619);

(statearr_30666_30700[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (2))){
var inst_30588 = (state_30655[(10)]);
var inst_30590 = (state_30655[(11)]);
var inst_30589 = (state_30655[(12)]);
var _ = (function (){var statearr_30667 = state_30655;
(statearr_30667[(4)] = cljs.core.cons((5),(state_30655[(4)])));

return statearr_30667;
})();
var inst_30586 = _QMARK_ctx;
var inst_30587 = cljs.core.__destructure_map(inst_30586);
var inst_30588__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30587,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_30589__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30587,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_30590__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30587,new cljs.core.Keyword(null,"db","db",993250759));
var inst_30591 = fluree.db.dbproto._p_prop(inst_30590__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_30589__$1);
var state_30655__$1 = (function (){var statearr_30668 = state_30655;
(statearr_30668[(10)] = inst_30588__$1);

(statearr_30668[(9)] = inst_30591);

(statearr_30668[(11)] = inst_30590__$1);

(statearr_30668[(12)] = inst_30589__$1);

return statearr_30668;
})();
if(cljs.core.truth_(inst_30588__$1)){
var statearr_30669_30701 = state_30655__$1;
(statearr_30669_30701[(1)] = (6));

} else {
var statearr_30670_30702 = state_30655__$1;
(statearr_30670_30702[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (11))){
var inst_30590 = (state_30655[(11)]);
var inst_30589 = (state_30655[(12)]);
var inst_30611 = (state_30655[(2)]);
var inst_30612 = fluree.db.dbproto._p_prop(inst_30590,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_30589);
var state_30655__$1 = (function (){var statearr_30672 = state_30655;
(statearr_30672[(13)] = inst_30611);

return statearr_30672;
})();
if(cljs.core.truth_(inst_30612)){
var statearr_30673_30703 = state_30655__$1;
(statearr_30673_30703[(1)] = (12));

} else {
var statearr_30674_30704 = state_30655__$1;
(statearr_30674_30704[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (9))){
var state_30655__$1 = state_30655;
var statearr_30675_30705 = state_30655__$1;
(statearr_30675_30705[(2)] = null);

(statearr_30675_30705[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (5))){
var _ = (function (){var statearr_30676 = state_30655;
(statearr_30676[(4)] = cljs.core.rest((state_30655[(4)])));

return statearr_30676;
})();
var state_30655__$1 = state_30655;
var ex30671 = (state_30655__$1[(2)]);
var statearr_30677_30706 = state_30655__$1;
(statearr_30677_30706[(5)] = ex30671);


if((ex30671 instanceof Error)){
var statearr_30678_30707 = state_30655__$1;
(statearr_30678_30707[(1)] = (4));

(statearr_30678_30707[(5)] = null);

} else {
throw ex30671;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (14))){
var inst_30588 = (state_30655[(10)]);
var inst_30591 = (state_30655[(9)]);
var inst_30590 = (state_30655[(11)]);
var inst_30622 = (state_30655[(2)]);
var inst_30623 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30626 = [inst_30588,inst_30591,"?current-val"];
var inst_30627 = (new cljs.core.PersistentVector(null,3,(5),inst_30625,inst_30626,null));
var inst_30628 = [inst_30627];
var inst_30629 = (new cljs.core.PersistentVector(null,1,(5),inst_30624,inst_30628,null));
var inst_30630 = cljs.core.PersistentHashMap.EMPTY;
var inst_30631 = ["?current-val",inst_30629,inst_30630];
var inst_30632 = cljs.core.PersistentHashMap.fromArrays(inst_30623,inst_30631);
var inst_30633 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_30590,inst_30632);
var state_30655__$1 = (function (){var statearr_30679 = state_30655;
(statearr_30679[(14)] = inst_30622);

return statearr_30679;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30655__$1,(15),inst_30633);
} else {
if((state_val_30656 === (16))){
var state_30655__$1 = state_30655;
var statearr_30680_30708 = state_30655__$1;
(statearr_30680_30708[(2)] = new_val);

(statearr_30680_30708[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (10))){
var inst_30604 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_30605 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30606 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30607 = cljs.core.PersistentHashMap.fromArrays(inst_30605,inst_30606);
var inst_30608 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30604,inst_30607);
var inst_30609 = (function(){throw inst_30608})();
var state_30655__$1 = state_30655;
var statearr_30681_30709 = state_30655__$1;
(statearr_30681_30709[(2)] = inst_30609);

(statearr_30681_30709[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (18))){
var inst_30650 = (state_30655[(2)]);
var _ = (function (){var statearr_30682 = state_30655;
(statearr_30682[(4)] = cljs.core.rest((state_30655[(4)])));

return statearr_30682;
})();
var state_30655__$1 = state_30655;
var statearr_30683_30710 = state_30655__$1;
(statearr_30683_30710[(2)] = inst_30650);

(statearr_30683_30710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30656 === (8))){
var inst_30591 = (state_30655[(9)]);
var inst_30601 = (state_30655[(2)]);
var state_30655__$1 = (function (){var statearr_30684 = state_30655;
(statearr_30684[(15)] = inst_30601);

return statearr_30684;
})();
if(cljs.core.truth_(inst_30591)){
var statearr_30685_30711 = state_30655__$1;
(statearr_30685_30711[(1)] = (9));

} else {
var statearr_30686_30712 = state_30655__$1;
(statearr_30686_30712[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0 = (function (){
var statearr_30687 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30687[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__);

(statearr_30687[(1)] = (1));

return statearr_30687;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1 = (function (state_30655){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_30655);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e30688){var ex__2687__auto__ = e30688;
var statearr_30689_30713 = state_30655;
(statearr_30689_30713[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_30655[(4)]))){
var statearr_30690_30714 = state_30655;
(statearr_30690_30714[(1)] = cljs.core.first((state_30655[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30715 = state_30655;
state_30655 = G__30715;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__ = function(state_30655){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1.call(this,state_30655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_30691 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_30691[(6)] = c__2706__auto__);

return statearr_30691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
