// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["XHTTP Request Error:",e.request], 0));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__20642 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20642,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__20642;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__20643 = opts;
var map__20643__$1 = cljs.core.__destructure_map(map__20643);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20643__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20643__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20643__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__20644 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__20644__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__20644,headers], 0)):G__20644);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20644__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__20644__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__20645 = opts;
var map__20645__$1 = cljs.core.__destructure_map(map__20645);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20645__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20645__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20645__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20645__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20645__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__20646 = cljs.core.PersistentArrayMap.EMPTY;
var G__20646__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__20646,headers], 0)):G__20646);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20646__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__20646__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__20647 = output_format;
var G__20647__$1 = (((G__20647 instanceof cljs.core.Keyword))?G__20647.fqn:null);
switch (G__20647__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__20649 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20649,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__20649;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20681){
var state_val_20682 = (state_20681[(1)]);
if((state_val_20682 === (7))){
var inst_20677 = (state_20681[(2)]);
var state_20681__$1 = state_20681;
var statearr_20683_20708 = state_20681__$1;
(statearr_20683_20708[(2)] = inst_20677);

(statearr_20683_20708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20682 === (1))){
var state_20681__$1 = state_20681;
var statearr_20684_20709 = state_20681__$1;
(statearr_20684_20709[(2)] = null);

(statearr_20684_20709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20682 === (4))){
var inst_20652 = (state_20681[(7)]);
var inst_20652__$1 = (state_20681[(2)]);
var inst_20653 = (inst_20652__$1 == null);
var state_20681__$1 = (function (){var statearr_20685 = state_20681;
(statearr_20685[(7)] = inst_20652__$1);

return statearr_20685;
})();
if(cljs.core.truth_(inst_20653)){
var statearr_20686_20710 = state_20681__$1;
(statearr_20686_20710[(1)] = (5));

} else {
var statearr_20687_20711 = state_20681__$1;
(statearr_20687_20711[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20682 === (6))){
var inst_20652 = (state_20681[(7)]);
var inst_20660 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20652,(0),null);
var inst_20661 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20652,(1),null);
var state_20681__$1 = (function (){var statearr_20688 = state_20681;
(statearr_20688[(8)] = inst_20660);

(statearr_20688[(9)] = inst_20661);

return statearr_20688;
})();
var statearr_20689_20712 = state_20681__$1;
(statearr_20689_20712[(2)] = null);

(statearr_20689_20712[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20682 === (3))){
var inst_20679 = (state_20681[(2)]);
var state_20681__$1 = state_20681;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20681__$1,inst_20679);
} else {
if((state_val_20682 === (2))){
var state_20681__$1 = state_20681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20681__$1,(4),pub_chan);
} else {
if((state_val_20682 === (11))){
var _ = (function (){var statearr_20691 = state_20681;
(statearr_20691[(4)] = cljs.core.rest((state_20681[(4)])));

return statearr_20691;
})();
var state_20681__$1 = state_20681;
var ex20690 = (state_20681__$1[(2)]);
var statearr_20692_20713 = state_20681__$1;
(statearr_20692_20713[(5)] = ex20690);


var statearr_20693_20714 = state_20681__$1;
(statearr_20693_20714[(1)] = (10));

(statearr_20693_20714[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20682 === (9))){
var inst_20674 = (state_20681[(2)]);
var state_20681__$1 = (function (){var statearr_20694 = state_20681;
(statearr_20694[(10)] = inst_20674);

return statearr_20694;
})();
var statearr_20695_20715 = state_20681__$1;
(statearr_20695_20715[(2)] = null);

(statearr_20695_20715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20682 === (5))){
var inst_20655 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_20681__$1 = state_20681;
var statearr_20696_20716 = state_20681__$1;
(statearr_20696_20716[(2)] = inst_20655);

(statearr_20696_20716[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20682 === (10))){
var inst_20660 = (state_20681[(8)]);
var inst_20661 = (state_20681[(9)]);
var inst_20662 = (state_20681[(2)]);
var inst_20663 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_20662,"Error sending websocket message:",inst_20660], 0));
var inst_20664 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_20661,false);
var state_20681__$1 = (function (){var statearr_20697 = state_20681;
(statearr_20697[(11)] = inst_20663);

return statearr_20697;
})();
var statearr_20698_20717 = state_20681__$1;
(statearr_20698_20717[(2)] = inst_20664);

(statearr_20698_20717[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20682 === (8))){
var inst_20660 = (state_20681[(8)]);
var inst_20661 = (state_20681[(9)]);
var _ = (function (){var statearr_20699 = state_20681;
(statearr_20699[(4)] = cljs.core.cons((11),(state_20681[(4)])));

return statearr_20699;
})();
var inst_20670 = ws.send(inst_20660);
var inst_20671 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_20661,true);
var ___$1 = (function (){var statearr_20700 = state_20681;
(statearr_20700[(4)] = cljs.core.rest((state_20681[(4)])));

return statearr_20700;
})();
var state_20681__$1 = (function (){var statearr_20701 = state_20681;
(statearr_20701[(12)] = inst_20670);

return statearr_20701;
})();
var statearr_20702_20718 = state_20681__$1;
(statearr_20702_20718[(2)] = inst_20671);

(statearr_20702_20718[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0 = (function (){
var statearr_20703 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20703[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__);

(statearr_20703[(1)] = (1));

return statearr_20703;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1 = (function (state_20681){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20681);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20704){var ex__2730__auto__ = e20704;
var statearr_20705_20719 = state_20681;
(statearr_20705_20719[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20681[(4)]))){
var statearr_20706_20720 = state_20681;
(statearr_20706_20720[(1)] = cljs.core.first((state_20681[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20721 = state_20681;
state_20681 = G__20721;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = function(state_20681){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1.call(this,state_20681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20707 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20707[(6)] = c__2749__auto__);

return statearr_20707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2749__auto___20759 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20746){
var state_val_20747 = (state_20746[(1)]);
if((state_val_20747 === (1))){
var inst_20725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20726 = [open_QMARK_,timeout_chan];
var inst_20727 = (new cljs.core.PersistentVector(null,2,(5),inst_20725,inst_20726,null));
var state_20746__$1 = state_20746;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_20746__$1,(2),inst_20727,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_20747 === (2))){
var inst_20729 = (state_20746[(2)]);
var inst_20730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20729,(0),null);
var inst_20731 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20729,(1),null);
var inst_20732 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20731,timeout_chan);
var state_20746__$1 = (function (){var statearr_20748 = state_20746;
(statearr_20748[(7)] = inst_20730);

return statearr_20748;
})();
if(inst_20732){
var statearr_20749_20760 = state_20746__$1;
(statearr_20749_20760[(1)] = (3));

} else {
var statearr_20750_20761 = state_20746__$1;
(statearr_20750_20761[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20747 === (3))){
var inst_20734 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_20735 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20736 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_20737 = cljs.core.PersistentHashMap.fromArrays(inst_20735,inst_20736);
var inst_20738 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20734,inst_20737);
var inst_20739 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_20738);
var inst_20740 = fluree.db.util.xhttp.close_websocket(ws);
var state_20746__$1 = (function (){var statearr_20751 = state_20746;
(statearr_20751[(8)] = inst_20739);

return statearr_20751;
})();
var statearr_20752_20762 = state_20746__$1;
(statearr_20752_20762[(2)] = inst_20740);

(statearr_20752_20762[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20747 === (4))){
var inst_20742 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_20746__$1 = state_20746;
var statearr_20753_20763 = state_20746__$1;
(statearr_20753_20763[(2)] = inst_20742);

(statearr_20753_20763[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20747 === (5))){
var inst_20744 = (state_20746[(2)]);
var state_20746__$1 = state_20746;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20746__$1,inst_20744);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_20754 = [null,null,null,null,null,null,null,null,null];
(statearr_20754[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__);

(statearr_20754[(1)] = (1));

return statearr_20754;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1 = (function (state_20746){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20746);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20755){var ex__2730__auto__ = e20755;
var statearr_20756_20764 = state_20746;
(statearr_20756_20764[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20746[(4)]))){
var statearr_20757_20765 = state_20746;
(statearr_20757_20765[(1)] = cljs.core.first((state_20746[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20766 = state_20746;
state_20746 = G__20766;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = function(state_20746){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1.call(this,state_20746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20758 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20758[(6)] = c__2749__auto___20759);

return statearr_20758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
