// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k28799,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__28803 = k28799;
var G__28803__$1 = (((G__28803 instanceof cljs.core.Keyword))?G__28803.fqn:null);
switch (G__28803__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k28799,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__28804){
var vec__28805 = p__28804;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28805,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28805,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28798){
var self__ = this;
var G__28798__$1 = this;
return (new cljs.core.RecordIter((0),G__28798__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__28808 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__28808(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28800,other28801){
var self__ = this;
var this28800__$1 = this;
return (((!((other28801 == null)))) && ((((this28800__$1.constructor === other28801.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.conn,other28801.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.network,other28801.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.dbid,other28801.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.db_name,other28801.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.update_chan,other28801.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.transact_chan,other28801.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.state,other28801.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.schema_cache,other28801.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.blank_db,other28801.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.close,other28801.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.id,other28801.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28800__$1.__extmap,other28801.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k28799){
var self__ = this;
var this__5350__auto____$1 = this;
var G__28809 = k28799;
var G__28809__$1 = (((G__28809 instanceof cljs.core.Keyword))?G__28809.fqn:null);
switch (G__28809__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k28799);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__28798){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__28810 = cljs.core.keyword_identical_QMARK_;
var expr__28811 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__28813 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__28814 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28813,G__28814) : pred__28810.call(null,G__28813,G__28814));
})())){
return (new fluree.db.session.DbSession(G__28798,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28815 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__28816 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28815,G__28816) : pred__28810.call(null,G__28815,G__28816));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__28798,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28817 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__28818 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28817,G__28818) : pred__28810.call(null,G__28817,G__28818));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__28798,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28819 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__28820 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28819,G__28820) : pred__28810.call(null,G__28819,G__28820));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__28798,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28821 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__28822 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28821,G__28822) : pred__28810.call(null,G__28821,G__28822));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__28798,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28823 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__28824 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28823,G__28824) : pred__28810.call(null,G__28823,G__28824));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__28798,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28825 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__28826 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28825,G__28826) : pred__28810.call(null,G__28825,G__28826));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__28798,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28827 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__28828 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28827,G__28828) : pred__28810.call(null,G__28827,G__28828));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__28798,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28829 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__28830 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28829,G__28830) : pred__28810.call(null,G__28829,G__28830));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__28798,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28831 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__28832 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28831,G__28832) : pred__28810.call(null,G__28831,G__28832));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__28798,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28833 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__28834 = expr__28811;
return (pred__28810.cljs$core$IFn$_invoke$arity$2 ? pred__28810.cljs$core$IFn$_invoke$arity$2(G__28833,G__28834) : pred__28810.call(null,G__28833,G__28834));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__28798,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__28798),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__28798){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__28798,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__28802){
var extmap__5385__auto__ = (function (){var G__28835 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__28802,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__28802)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__28835);
} else {
return G__28835;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28802),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28802),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28802),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__28802),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__28802),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__28802),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__28802),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__28802),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__28802),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__28802),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__28802),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__28838 = session;
var map__28838__$1 = cljs.core.__destructure_map(map__28838);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28838__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28838__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,dbid){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28880){
var state_val_28881 = (state_28880[(1)]);
if((state_val_28881 === (7))){
var inst_28854 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not found on this ledger group."].join('');
var inst_28855 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28856 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28857 = cljs.core.PersistentHashMap.fromArrays(inst_28855,inst_28856);
var inst_28858 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28854,inst_28857);
var inst_28859 = (function(){throw inst_28858})();
var state_28880__$1 = state_28880;
var statearr_28882_28905 = state_28880__$1;
(statearr_28882_28905[(2)] = inst_28859);

(statearr_28882_28905[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (1))){
var state_28880__$1 = state_28880;
var statearr_28883_28906 = state_28880__$1;
(statearr_28883_28906[(2)] = null);

(statearr_28883_28906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (4))){
var inst_28839 = (state_28880[(2)]);
var state_28880__$1 = state_28880;
var statearr_28884_28907 = state_28880__$1;
(statearr_28884_28907[(2)] = inst_28839);

(statearr_28884_28907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (6))){
var inst_28851 = (state_28880[(7)]);
var inst_28850 = (state_28880[(2)]);
var inst_28851__$1 = fluree.db.util.async.throw_err(inst_28850);
var inst_28852 = cljs.core.empty_QMARK_(inst_28851__$1);
var state_28880__$1 = (function (){var statearr_28885 = state_28880;
(statearr_28885[(7)] = inst_28851__$1);

return statearr_28885;
})();
if(inst_28852){
var statearr_28886_28908 = state_28880__$1;
(statearr_28886_28908[(1)] = (7));

} else {
var statearr_28887_28909 = state_28880__$1;
(statearr_28887_28909[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (3))){
var inst_28878 = (state_28880[(2)]);
var state_28880__$1 = state_28880;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28880__$1,inst_28878);
} else {
if((state_val_28881 === (12))){
var inst_28873 = (state_28880[(2)]);
var state_28880__$1 = state_28880;
var statearr_28888_28910 = state_28880__$1;
(statearr_28888_28910[(2)] = inst_28873);

(statearr_28888_28910[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (2))){
var _ = (function (){var statearr_28889 = state_28880;
(statearr_28889[(4)] = cljs.core.cons((5),(state_28880[(4)])));

return statearr_28889;
})();
var inst_28845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28846 = [network,dbid];
var inst_28847 = (new cljs.core.PersistentVector(null,2,(5),inst_28845,inst_28846,null));
var inst_28848 = fluree.db.operations.ledger_info_async(conn,inst_28847);
var state_28880__$1 = state_28880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28880__$1,(6),inst_28848);
} else {
if((state_val_28881 === (11))){
var inst_28851 = (state_28880[(7)]);
var state_28880__$1 = state_28880;
var statearr_28891_28911 = state_28880__$1;
(statearr_28891_28911[(2)] = inst_28851);

(statearr_28891_28911[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (9))){
var inst_28875 = (state_28880[(2)]);
var _ = (function (){var statearr_28892 = state_28880;
(statearr_28892[(4)] = cljs.core.rest((state_28880[(4)])));

return statearr_28892;
})();
var state_28880__$1 = state_28880;
var statearr_28893_28912 = state_28880__$1;
(statearr_28893_28912[(2)] = inst_28875);

(statearr_28893_28912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (5))){
var _ = (function (){var statearr_28894 = state_28880;
(statearr_28894[(4)] = cljs.core.rest((state_28880[(4)])));

return statearr_28894;
})();
var state_28880__$1 = state_28880;
var ex28890 = (state_28880__$1[(2)]);
var statearr_28895_28913 = state_28880__$1;
(statearr_28895_28913[(5)] = ex28890);


if((ex28890 instanceof Error)){
var statearr_28896_28914 = state_28880__$1;
(statearr_28896_28914[(1)] = (4));

(statearr_28896_28914[(5)] = null);

} else {
throw ex28890;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (10))){
var inst_28851 = (state_28880[(7)]);
var inst_28864 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_28851);
var inst_28865 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28864),"."].join('');
var inst_28866 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28867 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28868 = cljs.core.PersistentHashMap.fromArrays(inst_28866,inst_28867);
var inst_28869 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28865,inst_28868);
var inst_28870 = (function(){throw inst_28869})();
var state_28880__$1 = state_28880;
var statearr_28897_28915 = state_28880__$1;
(statearr_28897_28915[(2)] = inst_28870);

(statearr_28897_28915[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (8))){
var inst_28851 = (state_28880[(7)]);
var inst_28861 = fluree.db.session.ready_QMARK_(inst_28851);
var inst_28862 = (!(inst_28861));
var state_28880__$1 = state_28880;
if(inst_28862){
var statearr_28898_28916 = state_28880__$1;
(statearr_28898_28916[(1)] = (10));

} else {
var statearr_28899_28917 = state_28880__$1;
(statearr_28899_28917[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2727__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2727__auto____0 = (function (){
var statearr_28900 = [null,null,null,null,null,null,null,null];
(statearr_28900[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2727__auto__);

(statearr_28900[(1)] = (1));

return statearr_28900;
});
var fluree$db$session$load_ledger_info_$_state_machine__2727__auto____1 = (function (state_28880){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28880);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28901){var ex__2730__auto__ = e28901;
var statearr_28902_28918 = state_28880;
(statearr_28902_28918[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28880[(4)]))){
var statearr_28903_28919 = state_28880;
(statearr_28903_28919[(1)] = cljs.core.first((state_28880[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28920 = state_28880;
state_28880 = G__28920;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2727__auto__ = function(state_28880){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2727__auto____1.call(this,state_28880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2727__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2727__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28904 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28904[(6)] = c__2749__auto__);

return statearr_28904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__28921){
var map__28922 = p__28921;
var map__28922__$1 = cljs.core.__destructure_map(map__28922);
var blank_db = map__28922__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28922__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28922__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28997){
var state_val_28998 = (state_28997[(1)]);
if((state_val_28998 === (7))){
var inst_28940 = (state_28997[(7)]);
var inst_28939 = (state_28997[(2)]);
var inst_28940__$1 = fluree.db.util.async.throw_err(inst_28939);
var state_28997__$1 = (function (){var statearr_28999 = state_28997;
(statearr_28999[(7)] = inst_28940__$1);

return statearr_28999;
})();
if(cljs.core.truth_(inst_28940__$1)){
var statearr_29000_29035 = state_28997__$1;
(statearr_29000_29035[(1)] = (8));

} else {
var statearr_29001_29036 = state_28997__$1;
(statearr_29001_29036[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (20))){
var inst_28945 = (state_28997[(8)]);
var inst_28978 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28945)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid),"."].join('');
var inst_28979 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28980 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_28981 = cljs.core.PersistentHashMap.fromArrays(inst_28979,inst_28980);
var inst_28982 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28978,inst_28981);
var inst_28983 = (function(){throw inst_28982})();
var state_28997__$1 = state_28997;
var statearr_29002_29037 = state_28997__$1;
(statearr_29002_29037[(2)] = inst_28983);

(statearr_29002_29037[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (1))){
var state_28997__$1 = state_28997;
var statearr_29003_29038 = state_28997__$1;
(statearr_29003_29038[(2)] = null);

(statearr_29003_29038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (4))){
var inst_28923 = (state_28997[(2)]);
var state_28997__$1 = state_28997;
var statearr_29004_29039 = state_28997__$1;
(statearr_29004_29039[(2)] = inst_28923);

(statearr_29004_29039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (15))){
var inst_28987 = (state_28997[(2)]);
var state_28997__$1 = state_28997;
var statearr_29005_29040 = state_28997__$1;
(statearr_29005_29040[(2)] = inst_28987);

(statearr_29005_29040[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (21))){
var inst_28985 = (state_28997[(2)]);
var state_28997__$1 = state_28997;
var statearr_29006_29041 = state_28997__$1;
(statearr_29006_29041[(2)] = inst_28985);

(statearr_29006_29041[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (13))){
var inst_28944 = (state_28997[(9)]);
var inst_28949 = fluree.db.query.schema.schema_map(inst_28944);
var inst_28950 = fluree.db.query.schema.setting_map(inst_28944);
var inst_28951 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_28944);
var inst_28952 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_28951,cljs.core.empty);
var state_28997__$1 = (function (){var statearr_29007 = state_28997;
(statearr_29007[(10)] = inst_28952);

(statearr_29007[(11)] = inst_28950);

return statearr_29007;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28997__$1,(16),inst_28949);
} else {
if((state_val_28998 === (22))){
var inst_28945 = (state_28997[(8)]);
var inst_28973 = (state_28997[(2)]);
var inst_28974 = fluree.db.util.async.throw_err(inst_28973);
var inst_28975 = (inst_28945 + (1));
var inst_28944 = inst_28974;
var inst_28945__$1 = inst_28975;
var state_28997__$1 = (function (){var statearr_29008 = state_28997;
(statearr_29008[(8)] = inst_28945__$1);

(statearr_29008[(9)] = inst_28944);

return statearr_29008;
})();
var statearr_29009_29042 = state_28997__$1;
(statearr_29009_29042[(2)] = null);

(statearr_29009_29042[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (6))){
var inst_28932 = (state_28997[(2)]);
var inst_28933 = fluree.db.util.async.throw_err(inst_28932);
var inst_28934 = cljs.core.__destructure_map(inst_28933);
var inst_28935 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28934,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28936 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28934,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_28937 = fluree.db.storage.core.reify_db(conn,network,dbid,blank_db,inst_28936);
var state_28997__$1 = (function (){var statearr_29010 = state_28997;
(statearr_29010[(12)] = inst_28935);

return statearr_29010;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28997__$1,(7),inst_28937);
} else {
if((state_val_28998 === (17))){
var inst_28955 = (state_28997[(13)]);
var inst_28944 = (state_28997[(9)]);
var inst_28957 = (state_28997[(2)]);
var inst_28958 = fluree.db.util.async.throw_err(inst_28957);
var inst_28959 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28944,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_28955,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_28958], 0));
var state_28997__$1 = state_28997;
var statearr_29011_29043 = state_28997__$1;
(statearr_29011_29043[(2)] = inst_28959);

(statearr_29011_29043[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (3))){
var inst_28995 = (state_28997[(2)]);
var state_28997__$1 = state_28997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28997__$1,inst_28995);
} else {
if((state_val_28998 === (12))){
var inst_28989 = (state_28997[(2)]);
var state_28997__$1 = state_28997;
var statearr_29012_29044 = state_28997__$1;
(statearr_29012_29044[(2)] = inst_28989);

(statearr_29012_29044[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (2))){
var _ = (function (){var statearr_29013 = state_28997;
(statearr_29013[(4)] = cljs.core.cons((5),(state_28997[(4)])));

return statearr_29013;
})();
var inst_28930 = fluree.db.session.load_ledger_info(conn,network,dbid);
var state_28997__$1 = state_28997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28997__$1,(6),inst_28930);
} else {
if((state_val_28998 === (19))){
var inst_28964 = (state_28997[(14)]);
var inst_28944 = (state_28997[(9)]);
var inst_28967 = cljs.core.__destructure_map(inst_28964);
var inst_28968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28967,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_28969 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28967,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28967,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_28971 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_28944,inst_28969,inst_28968);
var state_28997__$1 = (function (){var statearr_29014 = state_28997;
(statearr_29014[(15)] = inst_28970);

return statearr_29014;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28997__$1,(22),inst_28971);
} else {
if((state_val_28998 === (11))){
var inst_28935 = (state_28997[(12)]);
var inst_28945 = (state_28997[(8)]);
var inst_28947 = (inst_28945 > inst_28935);
var state_28997__$1 = state_28997;
if(cljs.core.truth_(inst_28947)){
var statearr_29016_29045 = state_28997__$1;
(statearr_29016_29045[(1)] = (13));

} else {
var statearr_29017_29046 = state_28997__$1;
(statearr_29017_29046[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (9))){
var state_28997__$1 = state_28997;
var statearr_29018_29047 = state_28997__$1;
(statearr_29018_29047[(2)] = null);

(statearr_29018_29047[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (5))){
var _ = (function (){var statearr_29019 = state_28997;
(statearr_29019[(4)] = cljs.core.rest((state_28997[(4)])));

return statearr_29019;
})();
var state_28997__$1 = state_28997;
var ex29015 = (state_28997__$1[(2)]);
var statearr_29020_29048 = state_28997__$1;
(statearr_29020_29048[(5)] = ex29015);


if((ex29015 instanceof Error)){
var statearr_29021_29049 = state_28997__$1;
(statearr_29021_29049[(1)] = (4));

(statearr_29021_29049[(5)] = null);

} else {
throw ex29015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (14))){
var inst_28945 = (state_28997[(8)]);
var inst_28961 = fluree.db.storage.core.read_block(conn,network,dbid,inst_28945);
var state_28997__$1 = state_28997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28997__$1,(18),inst_28961);
} else {
if((state_val_28998 === (16))){
var inst_28950 = (state_28997[(11)]);
var inst_28954 = (state_28997[(2)]);
var inst_28955 = fluree.db.util.async.throw_err(inst_28954);
var state_28997__$1 = (function (){var statearr_29022 = state_28997;
(statearr_29022[(13)] = inst_28955);

return statearr_29022;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28997__$1,(17),inst_28950);
} else {
if((state_val_28998 === (10))){
var inst_28992 = (state_28997[(2)]);
var _ = (function (){var statearr_29023 = state_28997;
(statearr_29023[(4)] = cljs.core.rest((state_28997[(4)])));

return statearr_29023;
})();
var state_28997__$1 = state_28997;
var statearr_29024_29050 = state_28997__$1;
(statearr_29024_29050[(2)] = inst_28992);

(statearr_29024_29050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (18))){
var inst_28964 = (state_28997[(14)]);
var inst_28963 = (state_28997[(2)]);
var inst_28964__$1 = fluree.db.util.async.throw_err(inst_28963);
var state_28997__$1 = (function (){var statearr_29025 = state_28997;
(statearr_29025[(14)] = inst_28964__$1);

return statearr_29025;
})();
if(cljs.core.truth_(inst_28964__$1)){
var statearr_29026_29051 = state_28997__$1;
(statearr_29026_29051[(1)] = (19));

} else {
var statearr_29027_29052 = state_28997__$1;
(statearr_29027_29052[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28998 === (8))){
var inst_28940 = (state_28997[(7)]);
var inst_28942 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28940);
var inst_28943 = (inst_28942 + (1));
var inst_28944 = inst_28940;
var inst_28945 = inst_28943;
var state_28997__$1 = (function (){var statearr_29028 = state_28997;
(statearr_29028[(8)] = inst_28945);

(statearr_29028[(9)] = inst_28944);

return statearr_29028;
})();
var statearr_29029_29053 = state_28997__$1;
(statearr_29029_29053[(2)] = null);

(statearr_29029_29053[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2727__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2727__auto____0 = (function (){
var statearr_29030 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29030[(0)] = fluree$db$session$load_current_db_$_state_machine__2727__auto__);

(statearr_29030[(1)] = (1));

return statearr_29030;
});
var fluree$db$session$load_current_db_$_state_machine__2727__auto____1 = (function (state_28997){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28997);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29031){var ex__2730__auto__ = e29031;
var statearr_29032_29054 = state_28997;
(statearr_29032_29054[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28997[(4)]))){
var statearr_29033_29055 = state_28997;
(statearr_29033_29055[(1)] = cljs.core.first((state_28997[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29056 = state_28997;
state_28997 = G__29056;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2727__auto__ = function(state_28997){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2727__auto____1.call(this,state_28997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2727__auto____0;
fluree$db$session$load_current_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2727__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29034 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29034[(6)] = c__2749__auto__);

return statearr_29034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__29057,old_db_ch,new_db_ch){
var map__29058 = p__29057;
var map__29058__$1 = cljs.core.__destructure_map(map__29058);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29058__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p__29059){
var map__29060 = p__29059;
var map__29060__$1 = cljs.core.__destructure_map(map__29060);
var s = map__29060__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29060__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current,old_db_ch)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__29061){
var map__29062 = p__29061;
var map__29062__$1 = cljs.core.__destructure_map(map__29062);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29062__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__29063){
var map__29064 = p__29063;
var map__29064__$1 = cljs.core.__destructure_map(map__29064);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29064__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29064__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29064__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2749__auto___29101 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29084){
var state_val_29085 = (state_29084[(1)]);
if((state_val_29085 === (1))){
var state_29084__$1 = state_29084;
var statearr_29086_29102 = state_29084__$1;
(statearr_29086_29102[(2)] = null);

(statearr_29086_29102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29085 === (2))){
var _ = (function (){var statearr_29087 = state_29084;
(statearr_29087[(4)] = cljs.core.cons((5),(state_29084[(4)])));

return statearr_29087;
})();
var inst_29074 = fluree.db.session.load_current_db(conn,blank_db);
var state_29084__$1 = state_29084;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29084__$1,(6),inst_29074);
} else {
if((state_val_29085 === (3))){
var inst_29082 = (state_29084[(2)]);
var state_29084__$1 = state_29084;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29084__$1,inst_29082);
} else {
if((state_val_29085 === (4))){
var inst_29065 = (state_29084[(2)]);
var inst_29066 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_29067 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29065,"Error reloading db"], 0));
var inst_29068 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(db_ch,inst_29065);
var state_29084__$1 = (function (){var statearr_29089 = state_29084;
(statearr_29089[(7)] = inst_29067);

(statearr_29089[(8)] = inst_29066);

return statearr_29089;
})();
var statearr_29090_29103 = state_29084__$1;
(statearr_29090_29103[(2)] = inst_29068);

(statearr_29090_29103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29085 === (5))){
var _ = (function (){var statearr_29091 = state_29084;
(statearr_29091[(4)] = cljs.core.rest((state_29084[(4)])));

return statearr_29091;
})();
var state_29084__$1 = state_29084;
var ex29088 = (state_29084__$1[(2)]);
var statearr_29092_29104 = state_29084__$1;
(statearr_29092_29104[(5)] = ex29088);


var statearr_29093_29105 = state_29084__$1;
(statearr_29093_29105[(1)] = (4));

(statearr_29093_29105[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29085 === (6))){
var inst_29076 = (state_29084[(2)]);
var inst_29077 = fluree.db.util.async.throw_err(inst_29076);
var state_29084__$1 = state_29084;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29084__$1,(7),db_ch,inst_29077);
} else {
if((state_val_29085 === (7))){
var inst_29079 = (state_29084[(2)]);
var _ = (function (){var statearr_29094 = state_29084;
(statearr_29094[(4)] = cljs.core.rest((state_29084[(4)])));

return statearr_29094;
})();
var state_29084__$1 = state_29084;
var statearr_29095_29106 = state_29084__$1;
(statearr_29095_29106[(2)] = inst_29079);

(statearr_29095_29106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____0 = (function (){
var statearr_29096 = [null,null,null,null,null,null,null,null,null];
(statearr_29096[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__);

(statearr_29096[(1)] = (1));

return statearr_29096;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____1 = (function (state_29084){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29084);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29097){var ex__2730__auto__ = e29097;
var statearr_29098_29107 = state_29084;
(statearr_29098_29107[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29084[(4)]))){
var statearr_29099_29108 = state_29084;
(statearr_29099_29108[(1)] = cljs.core.first((state_29084[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29109 = state_29084;
state_29084 = G__29109;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__ = function(state_29084){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____1.call(this,state_29084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29100 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29100[(6)] = c__2749__auto___29101);

return statearr_29100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__29111 = arguments.length;
switch (G__29111) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__29112){
var map__29113 = p__29112;
var map__29113__$1 = cljs.core.__destructure_map(map__29113);
var session = map__29113__$1;
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29113__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2(session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__29114,blank_db){
var map__29115 = p__29114;
var map__29115__$1 = cljs.core.__destructure_map(map__29115);
var session = map__29115__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29115__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29115__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis()),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
if(cljs.core.not(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cur_ch,state_ch)){
var c__2749__auto___29153 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29135){
var state_val_29136 = (state_29135[(1)]);
if((state_val_29136 === (1))){
var state_29135__$1 = state_29135;
var statearr_29137_29154 = state_29135__$1;
(statearr_29137_29154[(2)] = null);

(statearr_29137_29154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29136 === (2))){
var _ = (function (){var statearr_29138 = state_29135;
(statearr_29138[(4)] = cljs.core.cons((5),(state_29135[(4)])));

return statearr_29138;
})();
var inst_29125 = fluree.db.session.load_current_db(conn,blank_db);
var state_29135__$1 = state_29135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29135__$1,(6),inst_29125);
} else {
if((state_val_29136 === (3))){
var inst_29133 = (state_29135[(2)]);
var state_29135__$1 = state_29135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29135__$1,inst_29133);
} else {
if((state_val_29136 === (4))){
var inst_29116 = (state_29135[(2)]);
var inst_29117 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_29118 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29116,"Error loading current db"], 0));
var inst_29119 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cur_ch,inst_29116);
var state_29135__$1 = (function (){var statearr_29140 = state_29135;
(statearr_29140[(7)] = inst_29118);

(statearr_29140[(8)] = inst_29117);

return statearr_29140;
})();
var statearr_29141_29155 = state_29135__$1;
(statearr_29141_29155[(2)] = inst_29119);

(statearr_29141_29155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29136 === (5))){
var _ = (function (){var statearr_29142 = state_29135;
(statearr_29142[(4)] = cljs.core.rest((state_29135[(4)])));

return statearr_29142;
})();
var state_29135__$1 = state_29135;
var ex29139 = (state_29135__$1[(2)]);
var statearr_29143_29156 = state_29135__$1;
(statearr_29143_29156[(5)] = ex29139);


var statearr_29144_29157 = state_29135__$1;
(statearr_29144_29157[(1)] = (4));

(statearr_29144_29157[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29136 === (6))){
var inst_29127 = (state_29135[(2)]);
var inst_29128 = fluree.db.util.async.throw_err(inst_29127);
var state_29135__$1 = state_29135;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29135__$1,(7),cur_ch,inst_29128);
} else {
if((state_val_29136 === (7))){
var inst_29130 = (state_29135[(2)]);
var _ = (function (){var statearr_29145 = state_29135;
(statearr_29145[(4)] = cljs.core.rest((state_29135[(4)])));

return statearr_29145;
})();
var state_29135__$1 = state_29135;
var statearr_29146_29158 = state_29135__$1;
(statearr_29146_29158[(2)] = inst_29130);

(statearr_29146_29158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_29147 = [null,null,null,null,null,null,null,null,null];
(statearr_29147[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_29147[(1)] = (1));

return statearr_29147;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_29135){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29135);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29148){var ex__2730__auto__ = e29148;
var statearr_29149_29159 = state_29135;
(statearr_29149_29159[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29135[(4)]))){
var statearr_29150_29160 = state_29135;
(statearr_29150_29160[(1)] = cljs.core.first((state_29135[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29161 = state_29135;
state_29135 = G__29161;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_29135){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_29135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29151 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29151[(6)] = c__2749__auto___29153);

return statearr_29151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__29162 = cljs.core.get_global_hierarchy;
return (fexpr__29162.cljs$core$IFn$_invoke$arity$0 ? fexpr__29162.cljs$core$IFn$_invoke$arity$0() : fexpr__29162.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29164){
var state_val_29165 = (state_29164[(1)]);
if((state_val_29165 === (1))){
var state_29164__$1 = state_29164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29164__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_29166 = [null,null,null,null,null,null,null];
(statearr_29166[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_29166[(1)] = (1));

return statearr_29166;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_29164){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29164);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29167){var ex__2730__auto__ = e29167;
var statearr_29168_29171 = state_29164;
(statearr_29168_29171[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29164[(4)]))){
var statearr_29169_29172 = state_29164;
(statearr_29169_29172[(1)] = cljs.core.first((state_29164[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29173 = state_29164;
state_29164 = G__29173;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_29164){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_29164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29170 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29170[(6)] = c__2749__auto__);

return statearr_29170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__29174){
var map__29175 = p__29174;
var map__29175__$1 = cljs.core.__destructure_map(map__29175);
var data = map__29175__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29175__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29175__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29175__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29234){
var state_val_29235 = (state_29234[(1)]);
if((state_val_29235 === (7))){
var inst_29186 = (state_29234[(7)]);
var inst_29189 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29190 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29191 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29189),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29190),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29186),". No-op."].join('');
var inst_29192 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29191], 0));
var state_29234__$1 = state_29234;
var statearr_29236_29274 = state_29234__$1;
(statearr_29236_29274[(2)] = inst_29192);

(statearr_29236_29274[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (1))){
var state_29234__$1 = state_29234;
var statearr_29237_29275 = state_29234__$1;
(statearr_29237_29275[(2)] = null);

(statearr_29237_29275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (4))){
var inst_29176 = (state_29234[(2)]);
var state_29234__$1 = state_29234;
var statearr_29238_29276 = state_29234__$1;
(statearr_29238_29276[(2)] = inst_29176);

(statearr_29238_29276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (15))){
var inst_29215 = (state_29234[(2)]);
var state_29234__$1 = state_29234;
var statearr_29239_29277 = state_29234__$1;
(statearr_29239_29277[(2)] = inst_29215);

(statearr_29239_29277[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (13))){
var inst_29206 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_29207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29208 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29209 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29210 = [inst_29208,inst_29209];
var inst_29211 = (new cljs.core.PersistentVector(null,2,(5),inst_29207,inst_29210,null));
var inst_29212 = (function (){var G__29240 = inst_29206;
var G__29241 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__29242 = inst_29211;
var G__29243 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__29240,G__29241,G__29242,G__29243) : fluree.db.conn_events.process_event.call(null,G__29240,G__29241,G__29242,G__29243));
})();
var state_29234__$1 = state_29234;
var statearr_29244_29278 = state_29234__$1;
(statearr_29244_29278[(2)] = inst_29212);

(statearr_29244_29278[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (6))){
var inst_29186 = (state_29234[(7)]);
var inst_29185 = (state_29234[(8)]);
var inst_29184 = (state_29234[(2)]);
var inst_29185__$1 = fluree.db.util.async.throw_err(inst_29184);
var inst_29186__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_29185__$1);
var inst_29187 = (block <= inst_29186__$1);
var state_29234__$1 = (function (){var statearr_29245 = state_29234;
(statearr_29245[(7)] = inst_29186__$1);

(statearr_29245[(8)] = inst_29185__$1);

return statearr_29245;
})();
if(cljs.core.truth_(inst_29187)){
var statearr_29246_29279 = state_29234__$1;
(statearr_29246_29279[(1)] = (7));

} else {
var statearr_29247_29280 = state_29234__$1;
(statearr_29247_29280[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (17))){
var state_29234__$1 = state_29234;
var statearr_29248_29281 = state_29234__$1;
(statearr_29248_29281[(2)] = null);

(statearr_29248_29281[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (3))){
var inst_29232 = (state_29234[(2)]);
var state_29234__$1 = state_29234;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29234__$1,inst_29232);
} else {
if((state_val_29235 === (12))){
var inst_29227 = (state_29234[(2)]);
var state_29234__$1 = state_29234;
var statearr_29249_29282 = state_29234__$1;
(statearr_29249_29282[(2)] = inst_29227);

(statearr_29249_29282[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (2))){
var inst_29182 = (state_29234[(9)]);
var _ = (function (){var statearr_29250 = state_29234;
(statearr_29250[(4)] = cljs.core.cons((5),(state_29234[(4)])));

return statearr_29250;
})();
var inst_29182__$1 = fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
var state_29234__$1 = (function (){var statearr_29251 = state_29234;
(statearr_29251[(9)] = inst_29182__$1);

return statearr_29251;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29234__$1,(6),inst_29182__$1);
} else {
if((state_val_29235 === (11))){
var state_29234__$1 = state_29234;
var statearr_29253_29283 = state_29234__$1;
(statearr_29253_29283[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (9))){
var inst_29229 = (state_29234[(2)]);
var _ = (function (){var statearr_29255 = state_29234;
(statearr_29255[(4)] = cljs.core.rest((state_29234[(4)])));

return statearr_29255;
})();
var state_29234__$1 = state_29234;
var statearr_29256_29284 = state_29234__$1;
(statearr_29256_29284[(2)] = inst_29229);

(statearr_29256_29284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (5))){
var _ = (function (){var statearr_29257 = state_29234;
(statearr_29257[(4)] = cljs.core.rest((state_29234[(4)])));

return statearr_29257;
})();
var state_29234__$1 = state_29234;
var ex29252 = (state_29234__$1[(2)]);
var statearr_29258_29285 = state_29234__$1;
(statearr_29258_29285[(5)] = ex29252);


if((ex29252 instanceof Error)){
var statearr_29259_29286 = state_29234__$1;
(statearr_29259_29286[(1)] = (4));

(statearr_29259_29286[(5)] = null);

} else {
throw ex29252;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (14))){
var state_29234__$1 = state_29234;
var statearr_29260_29287 = state_29234__$1;
(statearr_29260_29287[(2)] = null);

(statearr_29260_29287[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (16))){
var inst_29186 = (state_29234[(7)]);
var inst_29218 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29219 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29220 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29218),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29219),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29186),". Forcing a db reload."].join('');
var inst_29221 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29220], 0));
var inst_29222 = fluree.db.session.reload_db_BANG_(session);
var state_29234__$1 = (function (){var statearr_29261 = state_29234;
(statearr_29261[(10)] = inst_29221);

return statearr_29261;
})();
var statearr_29262_29288 = state_29234__$1;
(statearr_29262_29288[(2)] = inst_29222);

(statearr_29262_29288[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (10))){
var inst_29182 = (state_29234[(9)]);
var inst_29186 = (state_29234[(7)]);
var inst_29185 = (state_29234[(8)]);
var inst_29197 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29198 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29199 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29197),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29198),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_29200 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29199], 0));
var inst_29201 = (function (){var current_db_ch = inst_29182;
var current_db = inst_29185;
var current_block = inst_29186;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(f);
}
});
})();
var inst_29202 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_29201,flakes);
var inst_29203 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_29185,block,inst_29202);
var inst_29204 = fluree.db.session.cas_db_BANG_(session,inst_29182,inst_29203);
var state_29234__$1 = (function (){var statearr_29263 = state_29234;
(statearr_29263[(11)] = inst_29200);

return statearr_29263;
})();
if(inst_29204){
var statearr_29264_29289 = state_29234__$1;
(statearr_29264_29289[(1)] = (13));

} else {
var statearr_29265_29290 = state_29234__$1;
(statearr_29265_29290[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (18))){
var inst_29225 = (state_29234[(2)]);
var state_29234__$1 = state_29234;
var statearr_29266_29291 = state_29234__$1;
(statearr_29266_29291[(2)] = inst_29225);

(statearr_29266_29291[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29235 === (8))){
var inst_29186 = (state_29234[(7)]);
var inst_29194 = ((1) + inst_29186);
var inst_29195 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_29194);
var state_29234__$1 = state_29234;
if(inst_29195){
var statearr_29267_29292 = state_29234__$1;
(statearr_29267_29292[(1)] = (10));

} else {
var statearr_29268_29293 = state_29234__$1;
(statearr_29268_29293[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_29269 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29269[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_29269[(1)] = (1));

return statearr_29269;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_29234){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29234);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29270){var ex__2730__auto__ = e29270;
var statearr_29271_29294 = state_29234;
(statearr_29271_29294[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29234[(4)]))){
var statearr_29272_29295 = state_29234;
(statearr_29272_29295[(1)] = cljs.core.first((state_29234[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29296 = state_29234;
state_29234 = G__29296;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_29234){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_29234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29273 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29273[(6)] = c__2749__auto__);

return statearr_29273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29303){
var state_val_29304 = (state_29303[(1)]);
if((state_val_29304 === (1))){
var inst_29297 = fluree.db.session.clear_db_BANG_(session);
var inst_29298 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_29299 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_29300 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29298),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29299)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_29301 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29300], 0));
var state_29303__$1 = (function (){var statearr_29305 = state_29303;
(statearr_29305[(7)] = inst_29301);

(statearr_29305[(8)] = inst_29297);

return statearr_29305;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29303__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_29306 = [null,null,null,null,null,null,null,null,null];
(statearr_29306[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_29306[(1)] = (1));

return statearr_29306;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_29303){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29303);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29307){var ex__2730__auto__ = e29307;
var statearr_29308_29311 = state_29303;
(statearr_29308_29311[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29303[(4)]))){
var statearr_29309_29312 = state_29303;
(statearr_29309_29312[(1)] = cljs.core.first((state_29303[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29313 = state_29303;
state_29303 = G__29313;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_29303){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_29303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29310 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29310[(6)] = c__2749__auto__);

return statearr_29310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__29315 = arguments.length;
switch (G__29315) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__29316){
var map__29317 = p__29316;
var map__29317__$1 = cljs.core.__destructure_map(map__29317);
var session = map__29317__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29317__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29317__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29317__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29317__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29317__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29317__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29317__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__29318_29321 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__29318_29321.cljs$core$IFn$_invoke$arity$3 ? fexpr__29318_29321.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__29318_29321.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__29319_29322 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__29319_29322.cljs$core$IFn$_invoke$arity$0 ? fexpr__29319_29322.cljs$core$IFn$_invoke$arity$0() : fexpr__29319_29322.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5802__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29375){
var state_val_29376 = (state_29375[(1)]);
if((state_val_29376 === (7))){
var inst_29371 = (state_29375[(2)]);
var state_29375__$1 = state_29375;
var statearr_29377_29408 = state_29375__$1;
(statearr_29377_29408[(2)] = inst_29371);

(statearr_29377_29408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (1))){
var state_29375__$1 = state_29375;
var statearr_29378_29409 = state_29375__$1;
(statearr_29378_29409[(2)] = null);

(statearr_29378_29409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (4))){
var inst_29326 = (state_29375[(7)]);
var inst_29325 = (state_29375[(2)]);
var inst_29326__$1 = fluree.db.util.async.throw_err(inst_29325);
var inst_29327 = fluree.db.session.from_cache(network,ledger_id);
var inst_29328 = (inst_29326__$1 == null);
var state_29375__$1 = (function (){var statearr_29379 = state_29375;
(statearr_29379[(8)] = inst_29327);

(statearr_29379[(7)] = inst_29326__$1);

return statearr_29379;
})();
if(cljs.core.truth_(inst_29328)){
var statearr_29380_29410 = state_29375__$1;
(statearr_29380_29410[(1)] = (5));

} else {
var statearr_29381_29411 = state_29375__$1;
(statearr_29381_29411[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (15))){
var inst_29363 = (state_29375[(2)]);
var state_29375__$1 = (function (){var statearr_29382 = state_29375;
(statearr_29382[(9)] = inst_29363);

return statearr_29382;
})();
var statearr_29383_29412 = state_29375__$1;
(statearr_29383_29412[(2)] = null);

(statearr_29383_29412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (13))){
var inst_29367 = (state_29375[(2)]);
var state_29375__$1 = state_29375;
var statearr_29385_29413 = state_29375__$1;
(statearr_29385_29413[(2)] = inst_29367);

(statearr_29385_29413[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (6))){
var inst_29327 = (state_29375[(8)]);
var inst_29333 = (inst_29327 == null);
var state_29375__$1 = state_29375;
if(cljs.core.truth_(inst_29333)){
var statearr_29386_29414 = state_29375__$1;
(statearr_29386_29414[(1)] = (8));

} else {
var statearr_29387_29415 = state_29375__$1;
(statearr_29387_29415[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (17))){
var _ = (function (){var statearr_29388 = state_29375;
(statearr_29388[(4)] = cljs.core.rest((state_29375[(4)])));

return statearr_29388;
})();
var state_29375__$1 = state_29375;
var ex29384 = (state_29375__$1[(2)]);
var statearr_29389_29416 = state_29375__$1;
(statearr_29389_29416[(5)] = ex29384);


var statearr_29390_29417 = state_29375__$1;
(statearr_29390_29417[(1)] = (16));

(statearr_29390_29417[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (3))){
var inst_29373 = (state_29375[(2)]);
var state_29375__$1 = state_29375;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29375__$1,inst_29373);
} else {
if((state_val_29376 === (12))){
var state_29375__$1 = state_29375;
var statearr_29391_29418 = state_29375__$1;
(statearr_29391_29418[(2)] = null);

(statearr_29391_29418[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (2))){
var state_29375__$1 = state_29375;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29375__$1,(4),update_chan);
} else {
if((state_val_29376 === (11))){
var state_29375__$1 = state_29375;
var statearr_29392_29419 = state_29375__$1;
(statearr_29392_29419[(2)] = null);

(statearr_29392_29419[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (9))){
var state_29375__$1 = state_29375;
var statearr_29393_29420 = state_29375__$1;
(statearr_29393_29420[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (5))){
var inst_29330 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_29331 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29330], 0));
var state_29375__$1 = state_29375;
var statearr_29395_29421 = state_29375__$1;
(statearr_29395_29421[(2)] = inst_29331);

(statearr_29395_29421[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (14))){
var inst_29327 = (state_29375[(8)]);
var inst_29326 = (state_29375[(7)]);
var _ = (function (){var statearr_29396 = state_29375;
(statearr_29396[(4)] = cljs.core.cons((17),(state_29375[(4)])));

return statearr_29396;
})();
var inst_29351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29326,(0),null);
var inst_29352 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29326,(1),null);
var inst_29353 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_29354 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29326], 0));
var inst_29355 = fluree.db.util.core.trunc(inst_29354,(200));
var inst_29356 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29353,inst_29355], 0));
var inst_29357 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_29327,inst_29351,inst_29352) : fluree.db.session.process_ledger_update.call(null,inst_29327,inst_29351,inst_29352));
var state_29375__$1 = (function (){var statearr_29397 = state_29375;
(statearr_29397[(10)] = inst_29356);

return statearr_29397;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29375__$1,(18),inst_29357);
} else {
if((state_val_29376 === (16))){
var inst_29326 = (state_29375[(7)]);
var inst_29341 = (state_29375[(2)]);
var inst_29342 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29341,"Exception processing ledger updates for message: ",inst_29326], 0));
var state_29375__$1 = state_29375;
var statearr_29398_29422 = state_29375__$1;
(statearr_29398_29422[(2)] = inst_29342);

(statearr_29398_29422[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (10))){
var inst_29369 = (state_29375[(2)]);
var state_29375__$1 = state_29375;
var statearr_29399_29423 = state_29375__$1;
(statearr_29399_29423[(2)] = inst_29369);

(statearr_29399_29423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (18))){
var inst_29359 = (state_29375[(2)]);
var inst_29360 = fluree.db.util.async.throw_err(inst_29359);
var _ = (function (){var statearr_29400 = state_29375;
(statearr_29400[(4)] = cljs.core.rest((state_29375[(4)])));

return statearr_29400;
})();
var state_29375__$1 = state_29375;
var statearr_29401_29424 = state_29375__$1;
(statearr_29401_29424[(2)] = inst_29360);

(statearr_29401_29424[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29376 === (8))){
var inst_29326 = (state_29375[(7)]);
var inst_29335 = cljs.core.first(inst_29326);
var inst_29336 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29335], 0));
var inst_29337 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_29336].join('');
var inst_29338 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29337], 0));
var state_29375__$1 = state_29375;
var statearr_29402_29425 = state_29375__$1;
(statearr_29402_29425[(2)] = inst_29338);

(statearr_29402_29425[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0 = (function (){
var statearr_29403 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29403[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__);

(statearr_29403[(1)] = (1));

return statearr_29403;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1 = (function (state_29375){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29375);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29404){var ex__2730__auto__ = e29404;
var statearr_29405_29426 = state_29375;
(statearr_29405_29426[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29375[(4)]))){
var statearr_29406_29427 = state_29375;
(statearr_29406_29427[(1)] = cljs.core.first((state_29375[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29428 = state_29375;
state_29375 = G__29428;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__ = function(state_29375){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1.call(this,state_29375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29407 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29407[(6)] = c__2749__auto__);

return statearr_29407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__29429){
var map__29430 = p__29429;
var map__29430__$1 = cljs.core.__destructure_map(map__29430);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29430__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29430__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29430__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29430__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29430__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29430__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29430__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29430__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29430__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null),network,null,conn]));
var current_db_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__29434 = block_result;
var map__29434__$1 = cljs.core.__destructure_map(map__29434);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29434__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29434__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29434__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29434__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29434__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__29435 = tx_result;
var map__29435__$1 = cljs.core.__destructure_map(map__29435);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29435__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29435__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__29431_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__29431_SHARP_.t);
}):(function (p1__29432_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__29432_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__29433_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__29433_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__29433_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__29436 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29436,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29436,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29436,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29436,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));

var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__29440 = arguments.length;
switch (G__29440) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__29441){
var map__29442 = p__29441;
var map__29442__$1 = cljs.core.__destructure_map(map__29442);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29442__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29442__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29442__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29442__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__29443 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29443,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29443,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29443,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__29447_29567 = network;
var G__29448_29568 = ledger_id;
var G__29449_29569 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__29450_29570 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__29451 = cljs.core.seq(tids);
var chunk__29452 = null;
var count__29453 = (0);
var i__29454 = (0);
while(true){
if((i__29454 < count__29453)){
var tid = chunk__29452.cljs$core$IIndexed$_nth$arity$2(null,i__29454);
var temp__5804__auto___29572__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___29572__$1)){
var keyed_callbacks_29573 = temp__5804__auto___29572__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_29574 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__29495_29575 = cljs.core.seq(keyed_callbacks_29573);
var chunk__29496_29576 = null;
var count__29497_29577 = (0);
var i__29498_29578 = (0);
while(true){
if((i__29498_29578 < count__29497_29577)){
var vec__29507_29579 = chunk__29496_29576.cljs$core$IIndexed$_nth$arity$2(null,i__29498_29578);
var k_29580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29507_29579,(0),null);
var f_29581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29507_29579,(1),null);
try{(f_29581.cljs$core$IFn$_invoke$arity$1 ? f_29581.cljs$core$IFn$_invoke$arity$1(tx_response_29574) : f_29581.call(null,tx_response_29574));
}catch (e29510){var e_29582 = e29510;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_29582,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__29583 = seq__29495_29575;
var G__29584 = chunk__29496_29576;
var G__29585 = count__29497_29577;
var G__29586 = (i__29498_29578 + (1));
seq__29495_29575 = G__29583;
chunk__29496_29576 = G__29584;
count__29497_29577 = G__29585;
i__29498_29578 = G__29586;
continue;
} else {
var temp__5804__auto___29587__$2 = cljs.core.seq(seq__29495_29575);
if(temp__5804__auto___29587__$2){
var seq__29495_29588__$1 = temp__5804__auto___29587__$2;
if(cljs.core.chunked_seq_QMARK_(seq__29495_29588__$1)){
var c__5568__auto___29589 = cljs.core.chunk_first(seq__29495_29588__$1);
var G__29590 = cljs.core.chunk_rest(seq__29495_29588__$1);
var G__29591 = c__5568__auto___29589;
var G__29592 = cljs.core.count(c__5568__auto___29589);
var G__29593 = (0);
seq__29495_29575 = G__29590;
chunk__29496_29576 = G__29591;
count__29497_29577 = G__29592;
i__29498_29578 = G__29593;
continue;
} else {
var vec__29511_29594 = cljs.core.first(seq__29495_29588__$1);
var k_29595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29511_29594,(0),null);
var f_29596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29511_29594,(1),null);
try{(f_29596.cljs$core$IFn$_invoke$arity$1 ? f_29596.cljs$core$IFn$_invoke$arity$1(tx_response_29574) : f_29596.call(null,tx_response_29574));
}catch (e29514){var e_29597 = e29514;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_29597,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__29598 = cljs.core.next(seq__29495_29588__$1);
var G__29599 = null;
var G__29600 = (0);
var G__29601 = (0);
seq__29495_29575 = G__29598;
chunk__29496_29576 = G__29599;
count__29497_29577 = G__29600;
i__29498_29578 = G__29601;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__29602 = seq__29451;
var G__29603 = chunk__29452;
var G__29604 = count__29453;
var G__29605 = (i__29454 + (1));
seq__29451 = G__29602;
chunk__29452 = G__29603;
count__29453 = G__29604;
i__29454 = G__29605;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq(seq__29451);
if(temp__5804__auto____$1){
var seq__29451__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__29451__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__29451__$1);
var G__29606 = cljs.core.chunk_rest(seq__29451__$1);
var G__29607 = c__5568__auto__;
var G__29608 = cljs.core.count(c__5568__auto__);
var G__29609 = (0);
seq__29451 = G__29606;
chunk__29452 = G__29607;
count__29453 = G__29608;
i__29454 = G__29609;
continue;
} else {
var tid = cljs.core.first(seq__29451__$1);
var temp__5804__auto___29610__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___29610__$2)){
var keyed_callbacks_29611 = temp__5804__auto___29610__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_29612 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__29515_29613 = cljs.core.seq(keyed_callbacks_29611);
var chunk__29516_29614 = null;
var count__29517_29615 = (0);
var i__29518_29616 = (0);
while(true){
if((i__29518_29616 < count__29517_29615)){
var vec__29527_29617 = chunk__29516_29614.cljs$core$IIndexed$_nth$arity$2(null,i__29518_29616);
var k_29618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29527_29617,(0),null);
var f_29619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29527_29617,(1),null);
try{(f_29619.cljs$core$IFn$_invoke$arity$1 ? f_29619.cljs$core$IFn$_invoke$arity$1(tx_response_29612) : f_29619.call(null,tx_response_29612));
}catch (e29530){var e_29620 = e29530;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_29620,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__29621 = seq__29515_29613;
var G__29622 = chunk__29516_29614;
var G__29623 = count__29517_29615;
var G__29624 = (i__29518_29616 + (1));
seq__29515_29613 = G__29621;
chunk__29516_29614 = G__29622;
count__29517_29615 = G__29623;
i__29518_29616 = G__29624;
continue;
} else {
var temp__5804__auto___29625__$3 = cljs.core.seq(seq__29515_29613);
if(temp__5804__auto___29625__$3){
var seq__29515_29626__$1 = temp__5804__auto___29625__$3;
if(cljs.core.chunked_seq_QMARK_(seq__29515_29626__$1)){
var c__5568__auto___29627 = cljs.core.chunk_first(seq__29515_29626__$1);
var G__29628 = cljs.core.chunk_rest(seq__29515_29626__$1);
var G__29629 = c__5568__auto___29627;
var G__29630 = cljs.core.count(c__5568__auto___29627);
var G__29631 = (0);
seq__29515_29613 = G__29628;
chunk__29516_29614 = G__29629;
count__29517_29615 = G__29630;
i__29518_29616 = G__29631;
continue;
} else {
var vec__29531_29632 = cljs.core.first(seq__29515_29626__$1);
var k_29633 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29531_29632,(0),null);
var f_29634 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29531_29632,(1),null);
try{(f_29634.cljs$core$IFn$_invoke$arity$1 ? f_29634.cljs$core$IFn$_invoke$arity$1(tx_response_29612) : f_29634.call(null,tx_response_29612));
}catch (e29534){var e_29635 = e29534;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_29635,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__29636 = cljs.core.next(seq__29515_29626__$1);
var G__29637 = null;
var G__29638 = (0);
var G__29639 = (0);
seq__29515_29613 = G__29636;
chunk__29516_29614 = G__29637;
count__29517_29615 = G__29638;
i__29518_29616 = G__29639;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__29640 = cljs.core.next(seq__29451__$1);
var G__29641 = null;
var G__29642 = (0);
var G__29643 = (0);
seq__29451 = G__29640;
chunk__29452 = G__29641;
count__29453 = G__29642;
i__29454 = G__29643;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__29446_29571 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__29446_29571.cljs$core$IFn$_invoke$arity$4 ? fexpr__29446_29571.cljs$core$IFn$_invoke$arity$4(G__29447_29567,G__29448_29568,G__29449_29569,G__29450_29570) : fexpr__29446_29571.call(null,G__29447_29567,G__29448_29568,G__29449_29569,G__29450_29570));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_29644 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2749__auto___29645 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29551){
var state_val_29552 = (state_29551[(1)]);
if((state_val_29552 === (1))){
var state_29551__$1 = state_29551;
var statearr_29553_29646 = state_29551__$1;
(statearr_29553_29646[(2)] = null);

(statearr_29553_29646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29552 === (2))){
var inst_29536 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_29551__$1 = state_29551;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29551__$1,(4),inst_29536);
} else {
if((state_val_29552 === (3))){
var inst_29549 = (state_29551[(2)]);
var state_29551__$1 = state_29551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29551__$1,inst_29549);
} else {
if((state_val_29552 === (4))){
var inst_29538 = (state_29551[(7)]);
var inst_29538__$1 = (state_29551[(2)]);
var inst_29539 = (inst_29538__$1 == null);
var state_29551__$1 = (function (){var statearr_29554 = state_29551;
(statearr_29554[(7)] = inst_29538__$1);

return statearr_29554;
})();
if(cljs.core.truth_(inst_29539)){
var statearr_29555_29647 = state_29551__$1;
(statearr_29555_29647[(1)] = (5));

} else {
var statearr_29556_29648 = state_29551__$1;
(statearr_29556_29648[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29552 === (5))){
var inst_29541 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_29542 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29541], 0));
var state_29551__$1 = state_29551;
var statearr_29557_29649 = state_29551__$1;
(statearr_29557_29649[(2)] = inst_29542);

(statearr_29557_29649[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29552 === (6))){
var inst_29538 = (state_29551[(7)]);
var inst_29544 = (transact_handler_29644.cljs$core$IFn$_invoke$arity$2 ? transact_handler_29644.cljs$core$IFn$_invoke$arity$2(conn,inst_29538) : transact_handler_29644.call(null,conn,inst_29538));
var state_29551__$1 = (function (){var statearr_29558 = state_29551;
(statearr_29558[(8)] = inst_29544);

return statearr_29558;
})();
var statearr_29559_29650 = state_29551__$1;
(statearr_29559_29650[(2)] = null);

(statearr_29559_29650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29552 === (7))){
var inst_29547 = (state_29551[(2)]);
var state_29551__$1 = state_29551;
var statearr_29560_29651 = state_29551__$1;
(statearr_29560_29651[(2)] = inst_29547);

(statearr_29560_29651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_29561 = [null,null,null,null,null,null,null,null,null];
(statearr_29561[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_29561[(1)] = (1));

return statearr_29561;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_29551){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29551);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29562){var ex__2730__auto__ = e29562;
var statearr_29563_29652 = state_29551;
(statearr_29563_29652[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29551[(4)]))){
var statearr_29564_29653 = state_29551;
(statearr_29564_29653[(1)] = cljs.core.first((state_29551[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29654 = state_29551;
state_29551 = G__29654;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_29551){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_29551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29565 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29565[(6)] = c__2749__auto___29645);

return statearr_29565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__29657 = arguments.length;
switch (G__29657) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__29658 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__29655_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__29655_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__29658);
} else {
return G__29658;
}
})();
var seq__29659 = cljs.core.seq(sessions);
var chunk__29660 = null;
var count__29661 = (0);
var i__29662 = (0);
while(true){
if((i__29662 < count__29661)){
var session = chunk__29660.cljs$core$IIndexed$_nth$arity$2(null,i__29662);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__29664 = seq__29659;
var G__29665 = chunk__29660;
var G__29666 = count__29661;
var G__29667 = (i__29662 + (1));
seq__29659 = G__29664;
chunk__29660 = G__29665;
count__29661 = G__29666;
i__29662 = G__29667;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__29659);
if(temp__5804__auto__){
var seq__29659__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29659__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__29659__$1);
var G__29668 = cljs.core.chunk_rest(seq__29659__$1);
var G__29669 = c__5568__auto__;
var G__29670 = cljs.core.count(c__5568__auto__);
var G__29671 = (0);
seq__29659 = G__29668;
chunk__29660 = G__29669;
count__29661 = G__29670;
i__29662 = G__29671;
continue;
} else {
var session = cljs.core.first(seq__29659__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__29672 = cljs.core.next(seq__29659__$1);
var G__29673 = null;
var G__29674 = (0);
var G__29675 = (0);
seq__29659 = G__29672;
chunk__29660 = G__29673;
count__29661 = G__29674;
i__29662 = G__29675;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
