// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___54091 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54142){
var state_val_54143 = (state_54142[(1)]);
if((state_val_54143 === (7))){
var inst_54137 = (state_54142[(2)]);
var _ = (function (){var statearr_54144 = state_54142;
(statearr_54144[(4)] = cljs.core.rest((state_54142[(4)])));

return statearr_54144;
})();
var state_54142__$1 = state_54142;
var statearr_54145_54172 = state_54142__$1;
(statearr_54145_54172[(2)] = inst_54137);

(statearr_54145_54172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (1))){
var state_54142__$1 = state_54142;
var statearr_54146_54173 = state_54142__$1;
(statearr_54146_54173[(2)] = null);

(statearr_54146_54173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (4))){
var inst_54092 = (state_54142[(2)]);
var state_54142__$1 = state_54142;
var statearr_54147_54174 = state_54142__$1;
(statearr_54147_54174[(2)] = inst_54092);

(statearr_54147_54174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (13))){
var inst_54133 = (state_54142[(2)]);
var state_54142__$1 = state_54142;
var statearr_54148_54175 = state_54142__$1;
(statearr_54148_54175[(2)] = inst_54133);

(statearr_54148_54175[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (6))){
var inst_54117 = (state_54142[(7)]);
var inst_54110 = (state_54142[(8)]);
var inst_54116 = cljs.core.seq(inst_54110);
var inst_54117__$1 = cljs.core.first(inst_54116);
var inst_54118 = cljs.core.next(inst_54116);
var inst_54119 = cljs.core.not(inst_54117__$1);
var state_54142__$1 = (function (){var statearr_54149 = state_54142;
(statearr_54149[(7)] = inst_54117__$1);

(statearr_54149[(9)] = inst_54118);

return statearr_54149;
})();
if(inst_54119){
var statearr_54150_54176 = state_54142__$1;
(statearr_54150_54176[(1)] = (8));

} else {
var statearr_54151_54177 = state_54142__$1;
(statearr_54151_54177[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (3))){
var inst_54140 = (state_54142[(2)]);
var state_54142__$1 = state_54142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54142__$1,inst_54140);
} else {
if((state_val_54143 === (12))){
var inst_54117 = (state_54142[(7)]);
var inst_54118 = (state_54142[(9)]);
var inst_54111 = (state_54142[(10)]);
var inst_54130 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54111,inst_54117);
var inst_54110 = inst_54118;
var inst_54111__$1 = inst_54130;
var state_54142__$1 = (function (){var statearr_54152 = state_54142;
(statearr_54152[(10)] = inst_54111__$1);

(statearr_54152[(8)] = inst_54110);

return statearr_54152;
})();
var statearr_54153_54178 = state_54142__$1;
(statearr_54153_54178[(2)] = null);

(statearr_54153_54178[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (2))){
var _ = (function (){var statearr_54154 = state_54142;
(statearr_54154[(4)] = cljs.core.cons((5),(state_54142[(4)])));

return statearr_54154;
})();
var inst_54105 = args;
var inst_54106 = cljs.core.seq(inst_54105);
var inst_54107 = cljs.core.first(inst_54106);
var inst_54108 = cljs.core.next(inst_54106);
var inst_54109 = cljs.core.PersistentVector.EMPTY;
var inst_54110 = inst_54105;
var inst_54111 = inst_54109;
var state_54142__$1 = (function (){var statearr_54155 = state_54142;
(statearr_54155[(11)] = inst_54107);

(statearr_54155[(12)] = inst_54108);

(statearr_54155[(10)] = inst_54111);

(statearr_54155[(8)] = inst_54110);

return statearr_54155;
})();
var statearr_54156_54179 = state_54142__$1;
(statearr_54156_54179[(2)] = null);

(statearr_54156_54179[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (11))){
var inst_54117 = (state_54142[(7)]);
var state_54142__$1 = state_54142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54142__$1,(14),inst_54117);
} else {
if((state_val_54143 === (9))){
var inst_54117 = (state_54142[(7)]);
var inst_54122 = fluree.db.util.async.channel_QMARK_(inst_54117);
var state_54142__$1 = state_54142;
if(inst_54122){
var statearr_54158_54180 = state_54142__$1;
(statearr_54158_54180[(1)] = (11));

} else {
var statearr_54159_54181 = state_54142__$1;
(statearr_54159_54181[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (5))){
var _ = (function (){var statearr_54160 = state_54142;
(statearr_54160[(4)] = cljs.core.rest((state_54142[(4)])));

return statearr_54160;
})();
var state_54142__$1 = state_54142;
var ex54157 = (state_54142__$1[(2)]);
var statearr_54161_54182 = state_54142__$1;
(statearr_54161_54182[(5)] = ex54157);


if((ex54157 instanceof Error)){
var statearr_54162_54183 = state_54142__$1;
(statearr_54162_54183[(1)] = (4));

(statearr_54162_54183[(5)] = null);

} else {
throw ex54157;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (14))){
var inst_54118 = (state_54142[(9)]);
var inst_54111 = (state_54142[(10)]);
var inst_54125 = (state_54142[(2)]);
var inst_54126 = fluree.db.util.async.throw_err(inst_54125);
var inst_54127 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54111,inst_54126);
var inst_54110 = inst_54118;
var inst_54111__$1 = inst_54127;
var state_54142__$1 = (function (){var statearr_54163 = state_54142;
(statearr_54163[(10)] = inst_54111__$1);

(statearr_54163[(8)] = inst_54110);

return statearr_54163;
})();
var statearr_54164_54184 = state_54142__$1;
(statearr_54164_54184[(2)] = null);

(statearr_54164_54184[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (10))){
var inst_54135 = (state_54142[(2)]);
var state_54142__$1 = state_54142;
var statearr_54165_54185 = state_54142__$1;
(statearr_54165_54185[(2)] = inst_54135);

(statearr_54165_54185[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54143 === (8))){
var inst_54111 = (state_54142[(10)]);
var state_54142__$1 = state_54142;
var statearr_54166_54186 = state_54142__$1;
(statearr_54166_54186[(2)] = inst_54111);

(statearr_54166_54186[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0 = (function (){
var statearr_54167 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54167[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__);

(statearr_54167[(1)] = (1));

return statearr_54167;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1 = (function (state_54142){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54142);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54168){var ex__2730__auto__ = e54168;
var statearr_54169_54187 = state_54142;
(statearr_54169_54187[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54142[(4)]))){
var statearr_54170_54188 = state_54142;
(statearr_54170_54188[(1)] = cljs.core.first((state_54142[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54189 = state_54142;
state_54142 = G__54189;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = function(state_54142){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1.call(this,state_54142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54171 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54171[(6)] = c__2749__auto__);

return statearr_54171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54190 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54190,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54190,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54238){
var state_val_54239 = (state_54238[(1)]);
if((state_val_54239 === (7))){
var state_54238__$1 = state_54238;
var statearr_54240_54269 = state_54238__$1;
(statearr_54240_54269[(2)] = coll);

(statearr_54240_54269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (1))){
var state_54238__$1 = state_54238;
var statearr_54241_54270 = state_54238__$1;
(statearr_54241_54270[(2)] = null);

(statearr_54241_54270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (4))){
var inst_54193 = (state_54238[(2)]);
var state_54238__$1 = state_54238;
var statearr_54242_54271 = state_54238__$1;
(statearr_54242_54271[(2)] = inst_54193);

(statearr_54242_54271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (15))){
var inst_54212 = (state_54238[(7)]);
var inst_54220 = (state_54238[(2)]);
var inst_54221 = fluree.db.dbfunctions.internal.nth(inst_54212,inst_54220);
var inst_54222 = cljs.core.count(inst_54212);
var inst_54223 = ((9) + inst_54222);
var inst_54224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54225 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54227 = [inst_54212,inst_54220];
var inst_54228 = (new cljs.core.PersistentVector(null,2,(5),inst_54226,inst_54227,null));
var inst_54229 = ["nth",inst_54228,inst_54221];
var inst_54230 = cljs.core.PersistentHashMap.fromArrays(inst_54225,inst_54229);
var inst_54231 = [inst_54230,inst_54223];
var inst_54232 = (new cljs.core.PersistentVector(null,2,(5),inst_54224,inst_54231,null));
var inst_54233 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54232);
var _ = (function (){var statearr_54243 = state_54238;
(statearr_54243[(4)] = cljs.core.rest((state_54238[(4)])));

return statearr_54243;
})();
var state_54238__$1 = (function (){var statearr_54244 = state_54238;
(statearr_54244[(8)] = inst_54233);

return statearr_54244;
})();
var statearr_54245_54272 = state_54238__$1;
(statearr_54245_54272[(2)] = inst_54221);

(statearr_54245_54272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (13))){
var state_54238__$1 = state_54238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54238__$1,(16),key);
} else {
if((state_val_54239 === (6))){
var state_54238__$1 = state_54238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54238__$1,(9),coll);
} else {
if((state_val_54239 === (3))){
var inst_54236 = (state_54238[(2)]);
var state_54238__$1 = state_54238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54238__$1,inst_54236);
} else {
if((state_val_54239 === (12))){
var inst_54212 = (state_54238[(2)]);
var inst_54213 = fluree.db.util.async.channel_QMARK_(key);
var state_54238__$1 = (function (){var statearr_54246 = state_54238;
(statearr_54246[(7)] = inst_54212);

return statearr_54246;
})();
if(inst_54213){
var statearr_54247_54273 = state_54238__$1;
(statearr_54247_54273[(1)] = (13));

} else {
var statearr_54248_54274 = state_54238__$1;
(statearr_54248_54274[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (2))){
var _ = (function (){var statearr_54249 = state_54238;
(statearr_54249[(4)] = cljs.core.cons((5),(state_54238[(4)])));

return statearr_54249;
})();
var inst_54199 = fluree.db.util.async.channel_QMARK_(coll);
var state_54238__$1 = state_54238;
if(inst_54199){
var statearr_54250_54275 = state_54238__$1;
(statearr_54250_54275[(1)] = (6));

} else {
var statearr_54251_54276 = state_54238__$1;
(statearr_54251_54276[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (11))){
var inst_54206 = (state_54238[(9)]);
var state_54238__$1 = state_54238;
var statearr_54253_54277 = state_54238__$1;
(statearr_54253_54277[(2)] = inst_54206);

(statearr_54253_54277[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (9))){
var inst_54202 = (state_54238[(2)]);
var inst_54203 = fluree.db.util.async.throw_err(inst_54202);
var state_54238__$1 = state_54238;
var statearr_54254_54278 = state_54238__$1;
(statearr_54254_54278[(2)] = inst_54203);

(statearr_54254_54278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (5))){
var _ = (function (){var statearr_54255 = state_54238;
(statearr_54255[(4)] = cljs.core.rest((state_54238[(4)])));

return statearr_54255;
})();
var state_54238__$1 = state_54238;
var ex54252 = (state_54238__$1[(2)]);
var statearr_54256_54279 = state_54238__$1;
(statearr_54256_54279[(5)] = ex54252);


if((ex54252 instanceof Error)){
var statearr_54257_54280 = state_54238__$1;
(statearr_54257_54280[(1)] = (4));

(statearr_54257_54280[(5)] = null);

} else {
throw ex54252;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (14))){
var state_54238__$1 = state_54238;
var statearr_54258_54281 = state_54238__$1;
(statearr_54258_54281[(2)] = key);

(statearr_54258_54281[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (16))){
var inst_54216 = (state_54238[(2)]);
var inst_54217 = fluree.db.util.async.throw_err(inst_54216);
var state_54238__$1 = state_54238;
var statearr_54259_54282 = state_54238__$1;
(statearr_54259_54282[(2)] = inst_54217);

(statearr_54259_54282[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (10))){
var inst_54206 = (state_54238[(9)]);
var inst_54209 = cljs.core.vec(inst_54206);
var state_54238__$1 = state_54238;
var statearr_54260_54283 = state_54238__$1;
(statearr_54260_54283[(2)] = inst_54209);

(statearr_54260_54283[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54239 === (8))){
var inst_54206 = (state_54238[(9)]);
var inst_54206__$1 = (state_54238[(2)]);
var inst_54207 = cljs.core.set_QMARK_(inst_54206__$1);
var state_54238__$1 = (function (){var statearr_54261 = state_54238;
(statearr_54261[(9)] = inst_54206__$1);

return statearr_54261;
})();
if(inst_54207){
var statearr_54262_54284 = state_54238__$1;
(statearr_54262_54284[(1)] = (10));

} else {
var statearr_54263_54285 = state_54238__$1;
(statearr_54263_54285[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0 = (function (){
var statearr_54264 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54264[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__);

(statearr_54264[(1)] = (1));

return statearr_54264;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1 = (function (state_54238){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54238);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54265){var ex__2730__auto__ = e54265;
var statearr_54266_54286 = state_54238;
(statearr_54266_54286[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54238[(4)]))){
var statearr_54267_54287 = state_54238;
(statearr_54267_54287[(1)] = cljs.core.first((state_54238[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54288 = state_54238;
state_54238 = G__54288;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = function(state_54238){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1.call(this,state_54238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54268 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54268[(6)] = c__2749__auto__);

return statearr_54268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54349){
var state_val_54350 = (state_54349[(1)]);
if((state_val_54350 === (7))){
var state_54349__$1 = state_54349;
var statearr_54351_54385 = state_54349__$1;
(statearr_54351_54385[(2)] = test);

(statearr_54351_54385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (20))){
var inst_54323 = (state_54349[(2)]);
var inst_54324 = fluree.db.util.async.throw_err(inst_54323);
var state_54349__$1 = state_54349;
var statearr_54352_54386 = state_54349__$1;
(statearr_54352_54386[(2)] = inst_54324);

(statearr_54352_54386[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (1))){
var state_54349__$1 = state_54349;
var statearr_54353_54387 = state_54349__$1;
(statearr_54353_54387[(2)] = null);

(statearr_54353_54387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (4))){
var inst_54289 = (state_54349[(2)]);
var state_54349__$1 = state_54349;
var statearr_54354_54388 = state_54349__$1;
(statearr_54354_54388[(2)] = inst_54289);

(statearr_54354_54388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (15))){
var inst_54307 = (state_54349[(7)]);
var inst_54315 = (state_54349[(2)]);
var inst_54316 = [inst_54315,f];
var inst_54317 = (new cljs.core.PersistentVector(null,2,(5),inst_54307,inst_54316,null));
var state_54349__$1 = state_54349;
var statearr_54355_54389 = state_54349__$1;
(statearr_54355_54389[(2)] = inst_54317);

(statearr_54355_54389[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (13))){
var state_54349__$1 = state_54349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54349__$1,(16),t);
} else {
if((state_val_54350 === (6))){
var state_54349__$1 = state_54349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54349__$1,(9),test);
} else {
if((state_val_54350 === (17))){
var state_54349__$1 = state_54349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54349__$1,(20),f);
} else {
if((state_val_54350 === (3))){
var inst_54347 = (state_54349[(2)]);
var state_54349__$1 = state_54349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54349__$1,inst_54347);
} else {
if((state_val_54350 === (12))){
var inst_54305 = (state_54349[(8)]);
var inst_54331 = (state_54349[(2)]);
var inst_54332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54331,(0),null);
var inst_54333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54331,(1),null);
var inst_54334 = fluree.db.dbfunctions.internal.if_else(inst_54305,inst_54332,inst_54333);
var inst_54335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54336 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54338 = [inst_54305,inst_54332,inst_54333];
var inst_54339 = (new cljs.core.PersistentVector(null,3,(5),inst_54337,inst_54338,null));
var inst_54340 = ["if-else",inst_54339,inst_54334];
var inst_54341 = cljs.core.PersistentHashMap.fromArrays(inst_54336,inst_54340);
var inst_54342 = [inst_54341,(10)];
var inst_54343 = (new cljs.core.PersistentVector(null,2,(5),inst_54335,inst_54342,null));
var inst_54344 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54343);
var _ = (function (){var statearr_54356 = state_54349;
(statearr_54356[(4)] = cljs.core.rest((state_54349[(4)])));

return statearr_54356;
})();
var state_54349__$1 = (function (){var statearr_54357 = state_54349;
(statearr_54357[(9)] = inst_54344);

return statearr_54357;
})();
var statearr_54358_54390 = state_54349__$1;
(statearr_54358_54390[(2)] = inst_54334);

(statearr_54358_54390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (2))){
var _ = (function (){var statearr_54359 = state_54349;
(statearr_54359[(4)] = cljs.core.cons((5),(state_54349[(4)])));

return statearr_54359;
})();
var inst_54298 = fluree.db.util.async.channel_QMARK_(test);
var state_54349__$1 = state_54349;
if(inst_54298){
var statearr_54360_54391 = state_54349__$1;
(statearr_54360_54391[(1)] = (6));

} else {
var statearr_54361_54392 = state_54349__$1;
(statearr_54361_54392[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (19))){
var inst_54319 = (state_54349[(10)]);
var inst_54327 = (state_54349[(2)]);
var inst_54328 = [f,inst_54327];
var inst_54329 = (new cljs.core.PersistentVector(null,2,(5),inst_54319,inst_54328,null));
var state_54349__$1 = state_54349;
var statearr_54362_54393 = state_54349__$1;
(statearr_54362_54393[(2)] = inst_54329);

(statearr_54362_54393[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (11))){
var inst_54319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54320 = fluree.db.util.async.channel_QMARK_(f);
var state_54349__$1 = (function (){var statearr_54364 = state_54349;
(statearr_54364[(10)] = inst_54319);

return statearr_54364;
})();
if(inst_54320){
var statearr_54365_54394 = state_54349__$1;
(statearr_54365_54394[(1)] = (17));

} else {
var statearr_54366_54395 = state_54349__$1;
(statearr_54366_54395[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (9))){
var inst_54301 = (state_54349[(2)]);
var inst_54302 = fluree.db.util.async.throw_err(inst_54301);
var state_54349__$1 = state_54349;
var statearr_54367_54396 = state_54349__$1;
(statearr_54367_54396[(2)] = inst_54302);

(statearr_54367_54396[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (5))){
var _ = (function (){var statearr_54368 = state_54349;
(statearr_54368[(4)] = cljs.core.rest((state_54349[(4)])));

return statearr_54368;
})();
var state_54349__$1 = state_54349;
var ex54363 = (state_54349__$1[(2)]);
var statearr_54369_54397 = state_54349__$1;
(statearr_54369_54397[(5)] = ex54363);


if((ex54363 instanceof Error)){
var statearr_54370_54398 = state_54349__$1;
(statearr_54370_54398[(1)] = (4));

(statearr_54370_54398[(5)] = null);

} else {
throw ex54363;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (14))){
var state_54349__$1 = state_54349;
var statearr_54371_54399 = state_54349__$1;
(statearr_54371_54399[(2)] = t);

(statearr_54371_54399[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (16))){
var inst_54311 = (state_54349[(2)]);
var inst_54312 = fluree.db.util.async.throw_err(inst_54311);
var state_54349__$1 = state_54349;
var statearr_54372_54400 = state_54349__$1;
(statearr_54372_54400[(2)] = inst_54312);

(statearr_54372_54400[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (10))){
var inst_54307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54308 = fluree.db.util.async.channel_QMARK_(t);
var state_54349__$1 = (function (){var statearr_54373 = state_54349;
(statearr_54373[(7)] = inst_54307);

return statearr_54373;
})();
if(inst_54308){
var statearr_54374_54401 = state_54349__$1;
(statearr_54374_54401[(1)] = (13));

} else {
var statearr_54375_54402 = state_54349__$1;
(statearr_54375_54402[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (18))){
var state_54349__$1 = state_54349;
var statearr_54376_54403 = state_54349__$1;
(statearr_54376_54403[(2)] = f);

(statearr_54376_54403[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (8))){
var inst_54305 = (state_54349[(8)]);
var inst_54305__$1 = (state_54349[(2)]);
var state_54349__$1 = (function (){var statearr_54377 = state_54349;
(statearr_54377[(8)] = inst_54305__$1);

return statearr_54377;
})();
if(cljs.core.truth_(inst_54305__$1)){
var statearr_54378_54404 = state_54349__$1;
(statearr_54378_54404[(1)] = (10));

} else {
var statearr_54379_54405 = state_54349__$1;
(statearr_54379_54405[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0 = (function (){
var statearr_54380 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54380[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__);

(statearr_54380[(1)] = (1));

return statearr_54380;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1 = (function (state_54349){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54349);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54381){var ex__2730__auto__ = e54381;
var statearr_54382_54406 = state_54349;
(statearr_54382_54406[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54349[(4)]))){
var statearr_54383_54407 = state_54349;
(statearr_54383_54407[(1)] = cljs.core.first((state_54349[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54408 = state_54349;
state_54349 = G__54408;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = function(state_54349){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1.call(this,state_54349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54384 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54384[(6)] = c__2749__auto__);

return statearr_54384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54438){
var state_val_54439 = (state_54438[(1)]);
if((state_val_54439 === (7))){
var state_54438__$1 = state_54438;
var statearr_54440_54459 = state_54438__$1;
(statearr_54440_54459[(2)] = arg);

(statearr_54440_54459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54439 === (1))){
var state_54438__$1 = state_54438;
var statearr_54441_54460 = state_54438__$1;
(statearr_54441_54460[(2)] = null);

(statearr_54441_54460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54439 === (4))){
var inst_54409 = (state_54438[(2)]);
var state_54438__$1 = state_54438;
var statearr_54442_54461 = state_54438__$1;
(statearr_54442_54461[(2)] = inst_54409);

(statearr_54442_54461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54439 === (6))){
var state_54438__$1 = state_54438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54438__$1,(9),arg);
} else {
if((state_val_54439 === (3))){
var inst_54436 = (state_54438[(2)]);
var state_54438__$1 = state_54438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54438__$1,inst_54436);
} else {
if((state_val_54439 === (2))){
var _ = (function (){var statearr_54444 = state_54438;
(statearr_54444[(4)] = cljs.core.cons((5),(state_54438[(4)])));

return statearr_54444;
})();
var inst_54415 = fluree.db.util.async.channel_QMARK_(arg);
var state_54438__$1 = state_54438;
if(inst_54415){
var statearr_54445_54462 = state_54438__$1;
(statearr_54445_54462[(1)] = (6));

} else {
var statearr_54446_54463 = state_54438__$1;
(statearr_54446_54463[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54439 === (9))){
var inst_54418 = (state_54438[(2)]);
var inst_54419 = fluree.db.util.async.throw_err(inst_54418);
var state_54438__$1 = state_54438;
var statearr_54447_54464 = state_54438__$1;
(statearr_54447_54464[(2)] = inst_54419);

(statearr_54447_54464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54439 === (5))){
var _ = (function (){var statearr_54448 = state_54438;
(statearr_54448[(4)] = cljs.core.rest((state_54438[(4)])));

return statearr_54448;
})();
var state_54438__$1 = state_54438;
var ex54443 = (state_54438__$1[(2)]);
var statearr_54449_54465 = state_54438__$1;
(statearr_54449_54465[(5)] = ex54443);


if((ex54443 instanceof Error)){
var statearr_54450_54466 = state_54438__$1;
(statearr_54450_54466[(1)] = (4));

(statearr_54450_54466[(5)] = null);

} else {
throw ex54443;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54439 === (8))){
var inst_54422 = (state_54438[(2)]);
var inst_54423 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_54422);
var inst_54424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54425 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54427 = [inst_54422];
var inst_54428 = (new cljs.core.PersistentVector(null,1,(5),inst_54426,inst_54427,null));
var inst_54429 = ["nil?",inst_54428,inst_54423];
var inst_54430 = cljs.core.PersistentHashMap.fromArrays(inst_54425,inst_54429);
var inst_54431 = [inst_54430,(10)];
var inst_54432 = (new cljs.core.PersistentVector(null,2,(5),inst_54424,inst_54431,null));
var inst_54433 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54432);
var _ = (function (){var statearr_54451 = state_54438;
(statearr_54451[(4)] = cljs.core.rest((state_54438[(4)])));

return statearr_54451;
})();
var state_54438__$1 = (function (){var statearr_54452 = state_54438;
(statearr_54452[(7)] = inst_54433);

return statearr_54452;
})();
var statearr_54453_54467 = state_54438__$1;
(statearr_54453_54467[(2)] = inst_54423);

(statearr_54453_54467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_54454 = [null,null,null,null,null,null,null,null];
(statearr_54454[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__);

(statearr_54454[(1)] = (1));

return statearr_54454;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1 = (function (state_54438){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54438);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54455){var ex__2730__auto__ = e54455;
var statearr_54456_54468 = state_54438;
(statearr_54456_54468[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54438[(4)]))){
var statearr_54457_54469 = state_54438;
(statearr_54457_54469[(1)] = cljs.core.first((state_54438[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54470 = state_54438;
state_54438 = G__54470;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = function(state_54438){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1.call(this,state_54438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54458 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54458[(6)] = c__2749__auto__);

return statearr_54458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54500){
var state_val_54501 = (state_54500[(1)]);
if((state_val_54501 === (7))){
var state_54500__$1 = state_54500;
var statearr_54502_54521 = state_54500__$1;
(statearr_54502_54521[(2)] = arg);

(statearr_54502_54521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54501 === (1))){
var state_54500__$1 = state_54500;
var statearr_54503_54522 = state_54500__$1;
(statearr_54503_54522[(2)] = null);

(statearr_54503_54522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54501 === (4))){
var inst_54471 = (state_54500[(2)]);
var state_54500__$1 = state_54500;
var statearr_54504_54523 = state_54500__$1;
(statearr_54504_54523[(2)] = inst_54471);

(statearr_54504_54523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54501 === (6))){
var state_54500__$1 = state_54500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54500__$1,(9),arg);
} else {
if((state_val_54501 === (3))){
var inst_54498 = (state_54500[(2)]);
var state_54500__$1 = state_54500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54500__$1,inst_54498);
} else {
if((state_val_54501 === (2))){
var _ = (function (){var statearr_54506 = state_54500;
(statearr_54506[(4)] = cljs.core.cons((5),(state_54500[(4)])));

return statearr_54506;
})();
var inst_54477 = fluree.db.util.async.channel_QMARK_(arg);
var state_54500__$1 = state_54500;
if(inst_54477){
var statearr_54507_54524 = state_54500__$1;
(statearr_54507_54524[(1)] = (6));

} else {
var statearr_54508_54525 = state_54500__$1;
(statearr_54508_54525[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54501 === (9))){
var inst_54480 = (state_54500[(2)]);
var inst_54481 = fluree.db.util.async.throw_err(inst_54480);
var state_54500__$1 = state_54500;
var statearr_54509_54526 = state_54500__$1;
(statearr_54509_54526[(2)] = inst_54481);

(statearr_54509_54526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54501 === (5))){
var _ = (function (){var statearr_54510 = state_54500;
(statearr_54510[(4)] = cljs.core.rest((state_54500[(4)])));

return statearr_54510;
})();
var state_54500__$1 = state_54500;
var ex54505 = (state_54500__$1[(2)]);
var statearr_54511_54527 = state_54500__$1;
(statearr_54511_54527[(5)] = ex54505);


if((ex54505 instanceof Error)){
var statearr_54512_54528 = state_54500__$1;
(statearr_54512_54528[(1)] = (4));

(statearr_54512_54528[(5)] = null);

} else {
throw ex54505;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54501 === (8))){
var inst_54484 = (state_54500[(2)]);
var inst_54485 = fluree.db.dbfunctions.internal.not(inst_54484);
var inst_54486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54487 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54489 = [inst_54484];
var inst_54490 = (new cljs.core.PersistentVector(null,1,(5),inst_54488,inst_54489,null));
var inst_54491 = ["not?",inst_54490,inst_54485];
var inst_54492 = cljs.core.PersistentHashMap.fromArrays(inst_54487,inst_54491);
var inst_54493 = [inst_54492,(10)];
var inst_54494 = (new cljs.core.PersistentVector(null,2,(5),inst_54486,inst_54493,null));
var inst_54495 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54494);
var _ = (function (){var statearr_54513 = state_54500;
(statearr_54513[(4)] = cljs.core.rest((state_54500[(4)])));

return statearr_54513;
})();
var state_54500__$1 = (function (){var statearr_54514 = state_54500;
(statearr_54514[(7)] = inst_54495);

return statearr_54514;
})();
var statearr_54515_54529 = state_54500__$1;
(statearr_54515_54529[(2)] = inst_54485);

(statearr_54515_54529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0 = (function (){
var statearr_54516 = [null,null,null,null,null,null,null,null];
(statearr_54516[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__);

(statearr_54516[(1)] = (1));

return statearr_54516;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1 = (function (state_54500){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54500);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54517){var ex__2730__auto__ = e54517;
var statearr_54518_54530 = state_54500;
(statearr_54518_54530[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54500[(4)]))){
var statearr_54519_54531 = state_54500;
(statearr_54519_54531[(1)] = cljs.core.first((state_54500[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54532 = state_54500;
state_54500 = G__54532;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = function(state_54500){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1.call(this,state_54500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54520 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54520[(6)] = c__2749__auto__);

return statearr_54520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54562){
var state_val_54563 = (state_54562[(1)]);
if((state_val_54563 === (7))){
var state_54562__$1 = state_54562;
var statearr_54564_54583 = state_54562__$1;
(statearr_54564_54583[(2)] = arg);

(statearr_54564_54583[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54563 === (1))){
var state_54562__$1 = state_54562;
var statearr_54565_54584 = state_54562__$1;
(statearr_54565_54584[(2)] = null);

(statearr_54565_54584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54563 === (4))){
var inst_54533 = (state_54562[(2)]);
var state_54562__$1 = state_54562;
var statearr_54566_54585 = state_54562__$1;
(statearr_54566_54585[(2)] = inst_54533);

(statearr_54566_54585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54563 === (6))){
var state_54562__$1 = state_54562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54562__$1,(9),arg);
} else {
if((state_val_54563 === (3))){
var inst_54560 = (state_54562[(2)]);
var state_54562__$1 = state_54562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54562__$1,inst_54560);
} else {
if((state_val_54563 === (2))){
var _ = (function (){var statearr_54568 = state_54562;
(statearr_54568[(4)] = cljs.core.cons((5),(state_54562[(4)])));

return statearr_54568;
})();
var inst_54539 = fluree.db.util.async.channel_QMARK_(arg);
var state_54562__$1 = state_54562;
if(inst_54539){
var statearr_54569_54586 = state_54562__$1;
(statearr_54569_54586[(1)] = (6));

} else {
var statearr_54570_54587 = state_54562__$1;
(statearr_54570_54587[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54563 === (9))){
var inst_54542 = (state_54562[(2)]);
var inst_54543 = fluree.db.util.async.throw_err(inst_54542);
var state_54562__$1 = state_54562;
var statearr_54571_54588 = state_54562__$1;
(statearr_54571_54588[(2)] = inst_54543);

(statearr_54571_54588[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54563 === (5))){
var _ = (function (){var statearr_54572 = state_54562;
(statearr_54572[(4)] = cljs.core.rest((state_54562[(4)])));

return statearr_54572;
})();
var state_54562__$1 = state_54562;
var ex54567 = (state_54562__$1[(2)]);
var statearr_54573_54589 = state_54562__$1;
(statearr_54573_54589[(5)] = ex54567);


if((ex54567 instanceof Error)){
var statearr_54574_54590 = state_54562__$1;
(statearr_54574_54590[(1)] = (4));

(statearr_54574_54590[(5)] = null);

} else {
throw ex54567;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54563 === (8))){
var inst_54546 = (state_54562[(2)]);
var inst_54547 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_54546);
var inst_54548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54549 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54551 = [inst_54546];
var inst_54552 = (new cljs.core.PersistentVector(null,1,(5),inst_54550,inst_54551,null));
var inst_54553 = ["empty?",inst_54552,inst_54547];
var inst_54554 = cljs.core.PersistentHashMap.fromArrays(inst_54549,inst_54553);
var inst_54555 = [inst_54554,(10)];
var inst_54556 = (new cljs.core.PersistentVector(null,2,(5),inst_54548,inst_54555,null));
var inst_54557 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54556);
var _ = (function (){var statearr_54575 = state_54562;
(statearr_54575[(4)] = cljs.core.rest((state_54562[(4)])));

return statearr_54575;
})();
var state_54562__$1 = (function (){var statearr_54576 = state_54562;
(statearr_54576[(7)] = inst_54557);

return statearr_54576;
})();
var statearr_54577_54591 = state_54562__$1;
(statearr_54577_54591[(2)] = inst_54547);

(statearr_54577_54591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_54578 = [null,null,null,null,null,null,null,null];
(statearr_54578[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__);

(statearr_54578[(1)] = (1));

return statearr_54578;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1 = (function (state_54562){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54562);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54579){var ex__2730__auto__ = e54579;
var statearr_54580_54592 = state_54562;
(statearr_54580_54592[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54562[(4)]))){
var statearr_54581_54593 = state_54562;
(statearr_54581_54593[(1)] = cljs.core.first((state_54562[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54594 = state_54562;
state_54562 = G__54594;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = function(state_54562){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1.call(this,state_54562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54582 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54582[(6)] = c__2749__auto__);

return statearr_54582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54639 = arguments.length;
var i__5770__auto___54640 = (0);
while(true){
if((i__5770__auto___54640 < len__5769__auto___54639)){
args__5775__auto__.push((arguments[i__5770__auto___54640]));

var G__54641 = (i__5770__auto___54640 + (1));
i__5770__auto___54640 = G__54641;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54622){
var state_val_54623 = (state_54622[(1)]);
if((state_val_54623 === (1))){
var state_54622__$1 = state_54622;
var statearr_54624_54642 = state_54622__$1;
(statearr_54624_54642[(2)] = null);

(statearr_54624_54642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54623 === (2))){
var _ = (function (){var statearr_54625 = state_54622;
(statearr_54625[(4)] = cljs.core.cons((5),(state_54622[(4)])));

return statearr_54625;
})();
var inst_54603 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54622__$1 = state_54622;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54622__$1,(6),inst_54603);
} else {
if((state_val_54623 === (3))){
var inst_54620 = (state_54622[(2)]);
var state_54622__$1 = state_54622;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54622__$1,inst_54620);
} else {
if((state_val_54623 === (4))){
var inst_54597 = (state_54622[(2)]);
var state_54622__$1 = state_54622;
var statearr_54627_54643 = state_54622__$1;
(statearr_54627_54643[(2)] = inst_54597);

(statearr_54627_54643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54623 === (5))){
var _ = (function (){var statearr_54628 = state_54622;
(statearr_54628[(4)] = cljs.core.rest((state_54622[(4)])));

return statearr_54628;
})();
var state_54622__$1 = state_54622;
var ex54626 = (state_54622__$1[(2)]);
var statearr_54629_54644 = state_54622__$1;
(statearr_54629_54644[(5)] = ex54626);


if((ex54626 instanceof Error)){
var statearr_54630_54645 = state_54622__$1;
(statearr_54630_54645[(1)] = (4));

(statearr_54630_54645[(5)] = null);

} else {
throw ex54626;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54623 === (6))){
var inst_54605 = (state_54622[(2)]);
var inst_54606 = fluree.db.util.async.throw_err(inst_54605);
var inst_54607 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_54606);
var inst_54608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54609 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54611 = [inst_54606];
var inst_54612 = (new cljs.core.PersistentVector(null,1,(5),inst_54610,inst_54611,null));
var inst_54613 = ["str",inst_54612,inst_54607];
var inst_54614 = cljs.core.PersistentHashMap.fromArrays(inst_54609,inst_54613);
var inst_54615 = [inst_54614,(10)];
var inst_54616 = (new cljs.core.PersistentVector(null,2,(5),inst_54608,inst_54615,null));
var inst_54617 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54616);
var _ = (function (){var statearr_54631 = state_54622;
(statearr_54631[(4)] = cljs.core.rest((state_54622[(4)])));

return statearr_54631;
})();
var state_54622__$1 = (function (){var statearr_54632 = state_54622;
(statearr_54632[(7)] = inst_54617);

return statearr_54632;
})();
var statearr_54633_54646 = state_54622__$1;
(statearr_54633_54646[(2)] = inst_54607);

(statearr_54633_54646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54634 = [null,null,null,null,null,null,null,null];
(statearr_54634[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54634[(1)] = (1));

return statearr_54634;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54622){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54622);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54635){var ex__2730__auto__ = e54635;
var statearr_54636_54647 = state_54622;
(statearr_54636_54647[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54622[(4)]))){
var statearr_54637_54648 = state_54622;
(statearr_54637_54648[(1)] = cljs.core.first((state_54622[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54649 = state_54622;
state_54622 = G__54649;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54622){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54638 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54638[(6)] = c__2749__auto__);

return statearr_54638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54595){
var G__54596 = cljs.core.first(seq54595);
var seq54595__$1 = cljs.core.next(seq54595);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54596,seq54595__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54675){
var state_val_54676 = (state_54675[(1)]);
if((state_val_54676 === (1))){
var state_54675__$1 = state_54675;
var statearr_54677_54692 = state_54675__$1;
(statearr_54677_54692[(2)] = null);

(statearr_54677_54692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54676 === (2))){
var _ = (function (){var statearr_54678 = state_54675;
(statearr_54678[(4)] = cljs.core.cons((5),(state_54675[(4)])));

return statearr_54678;
})();
var inst_54656 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54675__$1 = state_54675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54675__$1,(6),inst_54656);
} else {
if((state_val_54676 === (3))){
var inst_54673 = (state_54675[(2)]);
var state_54675__$1 = state_54675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54675__$1,inst_54673);
} else {
if((state_val_54676 === (4))){
var inst_54650 = (state_54675[(2)]);
var state_54675__$1 = state_54675;
var statearr_54680_54693 = state_54675__$1;
(statearr_54680_54693[(2)] = inst_54650);

(statearr_54680_54693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54676 === (5))){
var _ = (function (){var statearr_54681 = state_54675;
(statearr_54681[(4)] = cljs.core.rest((state_54675[(4)])));

return statearr_54681;
})();
var state_54675__$1 = state_54675;
var ex54679 = (state_54675__$1[(2)]);
var statearr_54682_54694 = state_54675__$1;
(statearr_54682_54694[(5)] = ex54679);


if((ex54679 instanceof Error)){
var statearr_54683_54695 = state_54675__$1;
(statearr_54683_54695[(1)] = (4));

(statearr_54683_54695[(5)] = null);

} else {
throw ex54679;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54676 === (6))){
var inst_54658 = (state_54675[(2)]);
var inst_54659 = fluree.db.util.async.throw_err(inst_54658);
var inst_54660 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_54659);
var inst_54661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54662 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54664 = [inst_54659];
var inst_54665 = (new cljs.core.PersistentVector(null,1,(5),inst_54663,inst_54664,null));
var inst_54666 = ["subs",inst_54665,inst_54660];
var inst_54667 = cljs.core.PersistentHashMap.fromArrays(inst_54662,inst_54666);
var inst_54668 = [inst_54667,(30)];
var inst_54669 = (new cljs.core.PersistentVector(null,2,(5),inst_54661,inst_54668,null));
var inst_54670 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54669);
var _ = (function (){var statearr_54684 = state_54675;
(statearr_54684[(4)] = cljs.core.rest((state_54675[(4)])));

return statearr_54684;
})();
var state_54675__$1 = (function (){var statearr_54685 = state_54675;
(statearr_54685[(7)] = inst_54670);

return statearr_54685;
})();
var statearr_54686_54696 = state_54675__$1;
(statearr_54686_54696[(2)] = inst_54660);

(statearr_54686_54696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0 = (function (){
var statearr_54687 = [null,null,null,null,null,null,null,null];
(statearr_54687[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__);

(statearr_54687[(1)] = (1));

return statearr_54687;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1 = (function (state_54675){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54675);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54688){var ex__2730__auto__ = e54688;
var statearr_54689_54697 = state_54675;
(statearr_54689_54697[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54675[(4)]))){
var statearr_54690_54698 = state_54675;
(statearr_54690_54698[(1)] = cljs.core.first((state_54675[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54699 = state_54675;
state_54675 = G__54699;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = function(state_54675){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1.call(this,state_54675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54691 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54691[(6)] = c__2749__auto__);

return statearr_54691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54729){
var state_val_54730 = (state_54729[(1)]);
if((state_val_54730 === (7))){
var state_54729__$1 = state_54729;
var statearr_54731_54750 = state_54729__$1;
(statearr_54731_54750[(2)] = str);

(statearr_54731_54750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54730 === (1))){
var state_54729__$1 = state_54729;
var statearr_54732_54751 = state_54729__$1;
(statearr_54732_54751[(2)] = null);

(statearr_54732_54751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54730 === (4))){
var inst_54700 = (state_54729[(2)]);
var state_54729__$1 = state_54729;
var statearr_54733_54752 = state_54729__$1;
(statearr_54733_54752[(2)] = inst_54700);

(statearr_54733_54752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54730 === (6))){
var state_54729__$1 = state_54729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54729__$1,(9),str);
} else {
if((state_val_54730 === (3))){
var inst_54727 = (state_54729[(2)]);
var state_54729__$1 = state_54729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54729__$1,inst_54727);
} else {
if((state_val_54730 === (2))){
var _ = (function (){var statearr_54735 = state_54729;
(statearr_54735[(4)] = cljs.core.cons((5),(state_54729[(4)])));

return statearr_54735;
})();
var inst_54706 = fluree.db.util.async.channel_QMARK_(str);
var state_54729__$1 = state_54729;
if(inst_54706){
var statearr_54736_54753 = state_54729__$1;
(statearr_54736_54753[(1)] = (6));

} else {
var statearr_54737_54754 = state_54729__$1;
(statearr_54737_54754[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54730 === (9))){
var inst_54709 = (state_54729[(2)]);
var inst_54710 = fluree.db.util.async.throw_err(inst_54709);
var state_54729__$1 = state_54729;
var statearr_54738_54755 = state_54729__$1;
(statearr_54738_54755[(2)] = inst_54710);

(statearr_54738_54755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54730 === (5))){
var _ = (function (){var statearr_54739 = state_54729;
(statearr_54739[(4)] = cljs.core.rest((state_54729[(4)])));

return statearr_54739;
})();
var state_54729__$1 = state_54729;
var ex54734 = (state_54729__$1[(2)]);
var statearr_54740_54756 = state_54729__$1;
(statearr_54740_54756[(5)] = ex54734);


if((ex54734 instanceof Error)){
var statearr_54741_54757 = state_54729__$1;
(statearr_54741_54757[(1)] = (4));

(statearr_54741_54757[(5)] = null);

} else {
throw ex54734;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54730 === (8))){
var inst_54713 = (state_54729[(2)]);
var inst_54714 = fluree.db.dbfunctions.internal.lower_case(inst_54713);
var inst_54715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54716 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54718 = [inst_54713];
var inst_54719 = (new cljs.core.PersistentVector(null,1,(5),inst_54717,inst_54718,null));
var inst_54720 = ["lower-case",inst_54719,inst_54714];
var inst_54721 = cljs.core.PersistentHashMap.fromArrays(inst_54716,inst_54720);
var inst_54722 = [inst_54721,(10)];
var inst_54723 = (new cljs.core.PersistentVector(null,2,(5),inst_54715,inst_54722,null));
var inst_54724 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54723);
var _ = (function (){var statearr_54742 = state_54729;
(statearr_54742[(4)] = cljs.core.rest((state_54729[(4)])));

return statearr_54742;
})();
var state_54729__$1 = (function (){var statearr_54743 = state_54729;
(statearr_54743[(7)] = inst_54724);

return statearr_54743;
})();
var statearr_54744_54758 = state_54729__$1;
(statearr_54744_54758[(2)] = inst_54714);

(statearr_54744_54758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0 = (function (){
var statearr_54745 = [null,null,null,null,null,null,null,null];
(statearr_54745[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__);

(statearr_54745[(1)] = (1));

return statearr_54745;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1 = (function (state_54729){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54729);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54746){var ex__2730__auto__ = e54746;
var statearr_54747_54759 = state_54729;
(statearr_54747_54759[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54729[(4)]))){
var statearr_54748_54760 = state_54729;
(statearr_54748_54760[(1)] = cljs.core.first((state_54729[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54761 = state_54729;
state_54729 = G__54761;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = function(state_54729){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1.call(this,state_54729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54749 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54749[(6)] = c__2749__auto__);

return statearr_54749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54791){
var state_val_54792 = (state_54791[(1)]);
if((state_val_54792 === (7))){
var state_54791__$1 = state_54791;
var statearr_54793_54812 = state_54791__$1;
(statearr_54793_54812[(2)] = str);

(statearr_54793_54812[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54792 === (1))){
var state_54791__$1 = state_54791;
var statearr_54794_54813 = state_54791__$1;
(statearr_54794_54813[(2)] = null);

(statearr_54794_54813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54792 === (4))){
var inst_54762 = (state_54791[(2)]);
var state_54791__$1 = state_54791;
var statearr_54795_54814 = state_54791__$1;
(statearr_54795_54814[(2)] = inst_54762);

(statearr_54795_54814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54792 === (6))){
var state_54791__$1 = state_54791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54791__$1,(9),str);
} else {
if((state_val_54792 === (3))){
var inst_54789 = (state_54791[(2)]);
var state_54791__$1 = state_54791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54791__$1,inst_54789);
} else {
if((state_val_54792 === (2))){
var _ = (function (){var statearr_54797 = state_54791;
(statearr_54797[(4)] = cljs.core.cons((5),(state_54791[(4)])));

return statearr_54797;
})();
var inst_54768 = fluree.db.util.async.channel_QMARK_(str);
var state_54791__$1 = state_54791;
if(inst_54768){
var statearr_54798_54815 = state_54791__$1;
(statearr_54798_54815[(1)] = (6));

} else {
var statearr_54799_54816 = state_54791__$1;
(statearr_54799_54816[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54792 === (9))){
var inst_54771 = (state_54791[(2)]);
var inst_54772 = fluree.db.util.async.throw_err(inst_54771);
var state_54791__$1 = state_54791;
var statearr_54800_54817 = state_54791__$1;
(statearr_54800_54817[(2)] = inst_54772);

(statearr_54800_54817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54792 === (5))){
var _ = (function (){var statearr_54801 = state_54791;
(statearr_54801[(4)] = cljs.core.rest((state_54791[(4)])));

return statearr_54801;
})();
var state_54791__$1 = state_54791;
var ex54796 = (state_54791__$1[(2)]);
var statearr_54802_54818 = state_54791__$1;
(statearr_54802_54818[(5)] = ex54796);


if((ex54796 instanceof Error)){
var statearr_54803_54819 = state_54791__$1;
(statearr_54803_54819[(1)] = (4));

(statearr_54803_54819[(5)] = null);

} else {
throw ex54796;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54792 === (8))){
var inst_54775 = (state_54791[(2)]);
var inst_54776 = fluree.db.dbfunctions.internal.upper_case(inst_54775);
var inst_54777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54778 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54780 = [inst_54775];
var inst_54781 = (new cljs.core.PersistentVector(null,1,(5),inst_54779,inst_54780,null));
var inst_54782 = ["upper-case",inst_54781,inst_54776];
var inst_54783 = cljs.core.PersistentHashMap.fromArrays(inst_54778,inst_54782);
var inst_54784 = [inst_54783,(10)];
var inst_54785 = (new cljs.core.PersistentVector(null,2,(5),inst_54777,inst_54784,null));
var inst_54786 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54785);
var _ = (function (){var statearr_54804 = state_54791;
(statearr_54804[(4)] = cljs.core.rest((state_54791[(4)])));

return statearr_54804;
})();
var state_54791__$1 = (function (){var statearr_54805 = state_54791;
(statearr_54805[(7)] = inst_54786);

return statearr_54805;
})();
var statearr_54806_54820 = state_54791__$1;
(statearr_54806_54820[(2)] = inst_54776);

(statearr_54806_54820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0 = (function (){
var statearr_54807 = [null,null,null,null,null,null,null,null];
(statearr_54807[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__);

(statearr_54807[(1)] = (1));

return statearr_54807;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1 = (function (state_54791){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54791);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54808){var ex__2730__auto__ = e54808;
var statearr_54809_54821 = state_54791;
(statearr_54809_54821[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54791[(4)]))){
var statearr_54810_54822 = state_54791;
(statearr_54810_54822[(1)] = cljs.core.first((state_54791[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54823 = state_54791;
state_54791 = G__54823;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = function(state_54791){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1.call(this,state_54791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54811 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54811[(6)] = c__2749__auto__);

return statearr_54811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54825 = arguments.length;
switch (G__54825) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54853){
var state_val_54854 = (state_54853[(1)]);
if((state_val_54854 === (1))){
var state_54853__$1 = state_54853;
var statearr_54855_54871 = state_54853__$1;
(statearr_54855_54871[(2)] = null);

(statearr_54855_54871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54854 === (2))){
var _ = (function (){var statearr_54856 = state_54853;
(statearr_54856[(4)] = cljs.core.cons((5),(state_54853[(4)])));

return statearr_54856;
})();
var inst_54835 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_54853__$1 = state_54853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54853__$1,(6),inst_54835);
} else {
if((state_val_54854 === (3))){
var inst_54851 = (state_54853[(2)]);
var state_54853__$1 = state_54853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54853__$1,inst_54851);
} else {
if((state_val_54854 === (4))){
var inst_54826 = (state_54853[(2)]);
var state_54853__$1 = state_54853;
var statearr_54858_54872 = state_54853__$1;
(statearr_54858_54872[(2)] = inst_54826);

(statearr_54858_54872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54854 === (5))){
var _ = (function (){var statearr_54859 = state_54853;
(statearr_54859[(4)] = cljs.core.rest((state_54853[(4)])));

return statearr_54859;
})();
var state_54853__$1 = state_54853;
var ex54857 = (state_54853__$1[(2)]);
var statearr_54860_54873 = state_54853__$1;
(statearr_54860_54873[(5)] = ex54857);


if((ex54857 instanceof Error)){
var statearr_54861_54874 = state_54853__$1;
(statearr_54861_54874[(1)] = (4));

(statearr_54861_54874[(5)] = null);

} else {
throw ex54857;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54854 === (6))){
var inst_54837 = (state_54853[(2)]);
var inst_54838 = fluree.db.util.async.throw_err(inst_54837);
var inst_54839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54838,(0),null);
var inst_54840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54838,(1),null);
var inst_54841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54842 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54843 = ["?s","?ctx",inst_54839];
var inst_54844 = cljs.core.PersistentHashMap.fromArrays(inst_54842,inst_54843);
var inst_54845 = ((10) + inst_54840);
var inst_54846 = [inst_54844,inst_54845];
var inst_54847 = (new cljs.core.PersistentVector(null,2,(5),inst_54841,inst_54846,null));
var inst_54848 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54847);
var _ = (function (){var statearr_54862 = state_54853;
(statearr_54862[(4)] = cljs.core.rest((state_54853[(4)])));

return statearr_54862;
})();
var state_54853__$1 = (function (){var statearr_54863 = state_54853;
(statearr_54863[(7)] = inst_54848);

return statearr_54863;
})();
var statearr_54864_54875 = state_54853__$1;
(statearr_54864_54875[(2)] = inst_54839);

(statearr_54864_54875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54865 = [null,null,null,null,null,null,null,null];
(statearr_54865[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54865[(1)] = (1));

return statearr_54865;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54853){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54853);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54866){var ex__2730__auto__ = e54866;
var statearr_54867_54876 = state_54853;
(statearr_54867_54876[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54853[(4)]))){
var statearr_54868_54877 = state_54853;
(statearr_54868_54877[(1)] = cljs.core.first((state_54853[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54878 = state_54853;
state_54853 = G__54878;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54853){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54869 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54869[(6)] = c__2749__auto__);

return statearr_54869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54880 = arguments.length;
switch (G__54880) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54918){
var state_val_54919 = (state_54918[(1)]);
if((state_val_54919 === (7))){
var inst_54911 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54918__$1 = state_54918;
var statearr_54920_54940 = state_54918__$1;
(statearr_54920_54940[(2)] = inst_54911);

(statearr_54920_54940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (1))){
var state_54918__$1 = state_54918;
var statearr_54921_54941 = state_54918__$1;
(statearr_54921_54941[(2)] = null);

(statearr_54921_54941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (4))){
var inst_54881 = (state_54918[(2)]);
var state_54918__$1 = state_54918;
var statearr_54922_54942 = state_54918__$1;
(statearr_54922_54942[(2)] = inst_54881);

(statearr_54922_54942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (6))){
var inst_54892 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_54918__$1 = state_54918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54918__$1,(10),inst_54892);
} else {
if((state_val_54919 === (3))){
var inst_54916 = (state_54918[(2)]);
var state_54918__$1 = state_54918;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54918__$1,inst_54916);
} else {
if((state_val_54919 === (2))){
var _ = (function (){var statearr_54924 = state_54918;
(statearr_54924[(4)] = cljs.core.cons((5),(state_54918[(4)])));

return statearr_54924;
})();
var inst_54887 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54918__$1 = state_54918;
if(cljs.core.truth_(inst_54887)){
var statearr_54925_54943 = state_54918__$1;
(statearr_54925_54943[(1)] = (6));

} else {
var statearr_54926_54944 = state_54918__$1;
(statearr_54926_54944[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (9))){
var inst_54898 = (state_54918[(2)]);
var inst_54899 = fluree.db.util.async.throw_err(inst_54898);
var inst_54900 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54899,(0),null);
var inst_54901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54899,(1),null);
var inst_54902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54903 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54904 = ["?p","?ctx",inst_54900];
var inst_54905 = cljs.core.PersistentHashMap.fromArrays(inst_54903,inst_54904);
var inst_54906 = ((10) + inst_54901);
var inst_54907 = [inst_54905,inst_54906];
var inst_54908 = (new cljs.core.PersistentVector(null,2,(5),inst_54902,inst_54907,null));
var inst_54909 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54908);
var state_54918__$1 = (function (){var statearr_54927 = state_54918;
(statearr_54927[(7)] = inst_54909);

return statearr_54927;
})();
var statearr_54928_54945 = state_54918__$1;
(statearr_54928_54945[(2)] = inst_54900);

(statearr_54928_54945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (5))){
var _ = (function (){var statearr_54929 = state_54918;
(statearr_54929[(4)] = cljs.core.rest((state_54918[(4)])));

return statearr_54929;
})();
var state_54918__$1 = state_54918;
var ex54923 = (state_54918__$1[(2)]);
var statearr_54930_54946 = state_54918__$1;
(statearr_54930_54946[(5)] = ex54923);


if((ex54923 instanceof Error)){
var statearr_54931_54947 = state_54918__$1;
(statearr_54931_54947[(1)] = (4));

(statearr_54931_54947[(5)] = null);

} else {
throw ex54923;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (10))){
var inst_54894 = (state_54918[(2)]);
var inst_54895 = fluree.db.util.async.throw_err(inst_54894);
var inst_54896 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_54895);
var state_54918__$1 = state_54918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54918__$1,(9),inst_54896);
} else {
if((state_val_54919 === (8))){
var inst_54913 = (state_54918[(2)]);
var _ = (function (){var statearr_54932 = state_54918;
(statearr_54932[(4)] = cljs.core.rest((state_54918[(4)])));

return statearr_54932;
})();
var state_54918__$1 = state_54918;
var statearr_54933_54948 = state_54918__$1;
(statearr_54933_54948[(2)] = inst_54913);

(statearr_54933_54948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54934 = [null,null,null,null,null,null,null,null];
(statearr_54934[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54934[(1)] = (1));

return statearr_54934;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54918){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54918);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54935){var ex__2730__auto__ = e54935;
var statearr_54936_54949 = state_54918;
(statearr_54936_54949[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54918[(4)]))){
var statearr_54937_54950 = state_54918;
(statearr_54937_54950[(1)] = cljs.core.first((state_54918[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54951 = state_54918;
state_54918 = G__54951;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54918){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54938 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54938[(6)] = c__2749__auto__);

return statearr_54938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55000 = arguments.length;
var i__5770__auto___55001 = (0);
while(true){
if((i__5770__auto___55001 < len__5769__auto___55000)){
args__5775__auto__.push((arguments[i__5770__auto___55001]));

var G__55002 = (i__5770__auto___55001 + (1));
i__5770__auto___55001 = G__55002;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54983){
var state_val_54984 = (state_54983[(1)]);
if((state_val_54984 === (1))){
var state_54983__$1 = state_54983;
var statearr_54985_55003 = state_54983__$1;
(statearr_54985_55003[(2)] = null);

(statearr_54985_55003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (2))){
var _ = (function (){var statearr_54986 = state_54983;
(statearr_54986[(4)] = cljs.core.cons((5),(state_54983[(4)])));

return statearr_54986;
})();
var inst_54960 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54983__$1 = state_54983;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54983__$1,(6),inst_54960);
} else {
if((state_val_54984 === (3))){
var inst_54981 = (state_54983[(2)]);
var state_54983__$1 = state_54983;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54983__$1,inst_54981);
} else {
if((state_val_54984 === (4))){
var inst_54954 = (state_54983[(2)]);
var state_54983__$1 = state_54983;
var statearr_54988_55004 = state_54983__$1;
(statearr_54988_55004[(2)] = inst_54954);

(statearr_54988_55004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (5))){
var _ = (function (){var statearr_54989 = state_54983;
(statearr_54989[(4)] = cljs.core.rest((state_54983[(4)])));

return statearr_54989;
})();
var state_54983__$1 = state_54983;
var ex54987 = (state_54983__$1[(2)]);
var statearr_54990_55005 = state_54983__$1;
(statearr_54990_55005[(5)] = ex54987);


if((ex54987 instanceof Error)){
var statearr_54991_55006 = state_54983__$1;
(statearr_54991_55006[(1)] = (4));

(statearr_54991_55006[(5)] = null);

} else {
throw ex54987;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (6))){
var inst_54962 = (state_54983[(2)]);
var inst_54963 = fluree.db.util.async.throw_err(inst_54962);
var inst_54964 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54963);
var inst_54965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54966 = [inst_54963];
var inst_54967 = (new cljs.core.PersistentVector(null,1,(5),inst_54965,inst_54966,null));
var inst_54968 = cljs.core.count(inst_54967);
var inst_54969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54970 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54972 = [inst_54963];
var inst_54973 = (new cljs.core.PersistentVector(null,1,(5),inst_54971,inst_54972,null));
var inst_54974 = ["and",inst_54973,inst_54964];
var inst_54975 = cljs.core.PersistentHashMap.fromArrays(inst_54970,inst_54974);
var inst_54976 = [inst_54975,inst_54968];
var inst_54977 = (new cljs.core.PersistentVector(null,2,(5),inst_54969,inst_54976,null));
var inst_54978 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54977);
var _ = (function (){var statearr_54992 = state_54983;
(statearr_54992[(4)] = cljs.core.rest((state_54983[(4)])));

return statearr_54992;
})();
var state_54983__$1 = (function (){var statearr_54993 = state_54983;
(statearr_54993[(7)] = inst_54978);

return statearr_54993;
})();
var statearr_54994_55007 = state_54983__$1;
(statearr_54994_55007[(2)] = inst_54964);

(statearr_54994_55007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54995 = [null,null,null,null,null,null,null,null];
(statearr_54995[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54995[(1)] = (1));

return statearr_54995;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54983){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54983);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54996){var ex__2730__auto__ = e54996;
var statearr_54997_55008 = state_54983;
(statearr_54997_55008[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54983[(4)]))){
var statearr_54998_55009 = state_54983;
(statearr_54998_55009[(1)] = cljs.core.first((state_54983[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55010 = state_54983;
state_54983 = G__55010;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54983){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54999 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54999[(6)] = c__2749__auto__);

return statearr_54999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54952){
var G__54953 = cljs.core.first(seq54952);
var seq54952__$1 = cljs.core.next(seq54952);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54953,seq54952__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55059 = arguments.length;
var i__5770__auto___55060 = (0);
while(true){
if((i__5770__auto___55060 < len__5769__auto___55059)){
args__5775__auto__.push((arguments[i__5770__auto___55060]));

var G__55061 = (i__5770__auto___55060 + (1));
i__5770__auto___55060 = G__55061;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55042){
var state_val_55043 = (state_55042[(1)]);
if((state_val_55043 === (1))){
var state_55042__$1 = state_55042;
var statearr_55044_55062 = state_55042__$1;
(statearr_55044_55062[(2)] = null);

(statearr_55044_55062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55043 === (2))){
var _ = (function (){var statearr_55045 = state_55042;
(statearr_55045[(4)] = cljs.core.cons((5),(state_55042[(4)])));

return statearr_55045;
})();
var inst_55019 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55042__$1 = state_55042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55042__$1,(6),inst_55019);
} else {
if((state_val_55043 === (3))){
var inst_55040 = (state_55042[(2)]);
var state_55042__$1 = state_55042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55042__$1,inst_55040);
} else {
if((state_val_55043 === (4))){
var inst_55013 = (state_55042[(2)]);
var state_55042__$1 = state_55042;
var statearr_55047_55063 = state_55042__$1;
(statearr_55047_55063[(2)] = inst_55013);

(statearr_55047_55063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55043 === (5))){
var _ = (function (){var statearr_55048 = state_55042;
(statearr_55048[(4)] = cljs.core.rest((state_55042[(4)])));

return statearr_55048;
})();
var state_55042__$1 = state_55042;
var ex55046 = (state_55042__$1[(2)]);
var statearr_55049_55064 = state_55042__$1;
(statearr_55049_55064[(5)] = ex55046);


if((ex55046 instanceof Error)){
var statearr_55050_55065 = state_55042__$1;
(statearr_55050_55065[(1)] = (4));

(statearr_55050_55065[(5)] = null);

} else {
throw ex55046;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55043 === (6))){
var inst_55021 = (state_55042[(2)]);
var inst_55022 = fluree.db.util.async.throw_err(inst_55021);
var inst_55023 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_55022);
var inst_55024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55025 = [inst_55022];
var inst_55026 = (new cljs.core.PersistentVector(null,1,(5),inst_55024,inst_55025,null));
var inst_55027 = cljs.core.count(inst_55026);
var inst_55028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55029 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55031 = [inst_55022];
var inst_55032 = (new cljs.core.PersistentVector(null,1,(5),inst_55030,inst_55031,null));
var inst_55033 = ["or",inst_55032,inst_55023];
var inst_55034 = cljs.core.PersistentHashMap.fromArrays(inst_55029,inst_55033);
var inst_55035 = [inst_55034,inst_55027];
var inst_55036 = (new cljs.core.PersistentVector(null,2,(5),inst_55028,inst_55035,null));
var inst_55037 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55036);
var _ = (function (){var statearr_55051 = state_55042;
(statearr_55051[(4)] = cljs.core.rest((state_55042[(4)])));

return statearr_55051;
})();
var state_55042__$1 = (function (){var statearr_55052 = state_55042;
(statearr_55052[(7)] = inst_55037);

return statearr_55052;
})();
var statearr_55053_55066 = state_55042__$1;
(statearr_55053_55066[(2)] = inst_55023);

(statearr_55053_55066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55054 = [null,null,null,null,null,null,null,null];
(statearr_55054[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55054[(1)] = (1));

return statearr_55054;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55042){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55042);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55055){var ex__2730__auto__ = e55055;
var statearr_55056_55067 = state_55042;
(statearr_55056_55067[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55042[(4)]))){
var statearr_55057_55068 = state_55042;
(statearr_55057_55068[(1)] = cljs.core.first((state_55042[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55069 = state_55042;
state_55042 = G__55069;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55042){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55058 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55058[(6)] = c__2749__auto__);

return statearr_55058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq55011){
var G__55012 = cljs.core.first(seq55011);
var seq55011__$1 = cljs.core.next(seq55011);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55012,seq55011__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55107){
var state_val_55108 = (state_55107[(1)]);
if((state_val_55108 === (7))){
var inst_55083 = fluree.db.util.async.channel_QMARK_(coll);
var state_55107__$1 = state_55107;
if(inst_55083){
var statearr_55109_55132 = state_55107__$1;
(statearr_55109_55132[(1)] = (10));

} else {
var statearr_55110_55133 = state_55107__$1;
(statearr_55110_55133[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (1))){
var state_55107__$1 = state_55107;
var statearr_55111_55134 = state_55107__$1;
(statearr_55111_55134[(2)] = null);

(statearr_55111_55134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (4))){
var inst_55070 = (state_55107[(2)]);
var state_55107__$1 = state_55107;
var statearr_55112_55135 = state_55107__$1;
(statearr_55112_55135[(2)] = inst_55070);

(statearr_55112_55135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (13))){
var inst_55086 = (state_55107[(2)]);
var inst_55087 = fluree.db.util.async.throw_err(inst_55086);
var state_55107__$1 = state_55107;
var statearr_55113_55136 = state_55107__$1;
(statearr_55113_55136[(2)] = inst_55087);

(statearr_55113_55136[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (6))){
var inst_55078 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_55107__$1 = state_55107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55107__$1,(9),inst_55078);
} else {
if((state_val_55108 === (3))){
var inst_55105 = (state_55107[(2)]);
var state_55107__$1 = state_55107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55107__$1,inst_55105);
} else {
if((state_val_55108 === (12))){
var inst_55090 = (state_55107[(2)]);
var state_55107__$1 = state_55107;
var statearr_55114_55137 = state_55107__$1;
(statearr_55114_55137[(2)] = inst_55090);

(statearr_55114_55137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (2))){
var _ = (function (){var statearr_55115 = state_55107;
(statearr_55115[(4)] = cljs.core.cons((5),(state_55107[(4)])));

return statearr_55115;
})();
var inst_55076 = cljs.core.vector_QMARK_(coll);
var state_55107__$1 = state_55107;
if(inst_55076){
var statearr_55116_55138 = state_55107__$1;
(statearr_55116_55138[(1)] = (6));

} else {
var statearr_55117_55139 = state_55107__$1;
(statearr_55117_55139[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (11))){
var state_55107__$1 = state_55107;
var statearr_55119_55140 = state_55107__$1;
(statearr_55119_55140[(2)] = coll);

(statearr_55119_55140[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (9))){
var inst_55080 = (state_55107[(2)]);
var inst_55081 = fluree.db.util.async.throw_err(inst_55080);
var state_55107__$1 = state_55107;
var statearr_55120_55141 = state_55107__$1;
(statearr_55120_55141[(2)] = inst_55081);

(statearr_55120_55141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (5))){
var _ = (function (){var statearr_55121 = state_55107;
(statearr_55121[(4)] = cljs.core.rest((state_55107[(4)])));

return statearr_55121;
})();
var state_55107__$1 = state_55107;
var ex55118 = (state_55107__$1[(2)]);
var statearr_55122_55142 = state_55107__$1;
(statearr_55122_55142[(5)] = ex55118);


if((ex55118 instanceof Error)){
var statearr_55123_55143 = state_55107__$1;
(statearr_55123_55143[(1)] = (4));

(statearr_55123_55143[(5)] = null);

} else {
throw ex55118;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55108 === (10))){
var state_55107__$1 = state_55107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55107__$1,(13),coll);
} else {
if((state_val_55108 === (8))){
var inst_55092 = (state_55107[(2)]);
var inst_55093 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_55092);
var inst_55094 = cljs.core.count(inst_55093);
var inst_55095 = ((9) + inst_55094);
var inst_55096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55097 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55098 = ["count",inst_55092,inst_55094];
var inst_55099 = cljs.core.PersistentHashMap.fromArrays(inst_55097,inst_55098);
var inst_55100 = [inst_55099,inst_55095];
var inst_55101 = (new cljs.core.PersistentVector(null,2,(5),inst_55096,inst_55100,null));
var inst_55102 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55101);
var _ = (function (){var statearr_55124 = state_55107;
(statearr_55124[(4)] = cljs.core.rest((state_55107[(4)])));

return statearr_55124;
})();
var state_55107__$1 = (function (){var statearr_55125 = state_55107;
(statearr_55125[(7)] = inst_55102);

return statearr_55125;
})();
var statearr_55126_55144 = state_55107__$1;
(statearr_55126_55144[(2)] = inst_55094);

(statearr_55126_55144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0 = (function (){
var statearr_55127 = [null,null,null,null,null,null,null,null];
(statearr_55127[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__);

(statearr_55127[(1)] = (1));

return statearr_55127;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1 = (function (state_55107){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55107);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55128){var ex__2730__auto__ = e55128;
var statearr_55129_55145 = state_55107;
(statearr_55129_55145[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55107[(4)]))){
var statearr_55130_55146 = state_55107;
(statearr_55130_55146[(1)] = cljs.core.first((state_55107[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55147 = state_55107;
state_55107 = G__55147;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = function(state_55107){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1.call(this,state_55107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55131 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55131[(6)] = c__2749__auto__);

return statearr_55131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55197){
var state_val_55198 = (state_55197[(1)]);
if((state_val_55198 === (7))){
var state_55197__$1 = state_55197;
var statearr_55199_55232 = state_55197__$1;
(statearr_55199_55232[(2)] = subject);

(statearr_55199_55232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (1))){
var state_55197__$1 = state_55197;
var statearr_55200_55233 = state_55197__$1;
(statearr_55200_55233[(2)] = null);

(statearr_55200_55233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (4))){
var inst_55148 = (state_55197[(2)]);
var state_55197__$1 = state_55197;
var statearr_55201_55234 = state_55197__$1;
(statearr_55201_55234[(2)] = inst_55148);

(statearr_55201_55234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (15))){
var inst_55161 = (state_55197[(7)]);
var state_55197__$1 = state_55197;
var statearr_55202_55235 = state_55197__$1;
(statearr_55202_55235[(2)] = inst_55161);

(statearr_55202_55235[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (13))){
var inst_55165 = (state_55197[(2)]);
var inst_55166 = fluree.db.util.async.throw_err(inst_55165);
var state_55197__$1 = state_55197;
var statearr_55203_55236 = state_55197__$1;
(statearr_55203_55236[(2)] = inst_55166);

(statearr_55203_55236[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (6))){
var state_55197__$1 = state_55197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55197__$1,(9),subject);
} else {
if((state_val_55198 === (17))){
var inst_55161 = (state_55197[(7)]);
var inst_55175 = cljs.core.first(inst_55161);
var state_55197__$1 = state_55197;
var statearr_55204_55237 = state_55197__$1;
(statearr_55204_55237[(2)] = inst_55175);

(statearr_55204_55237[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (3))){
var inst_55195 = (state_55197[(2)]);
var state_55197__$1 = state_55197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55197__$1,inst_55195);
} else {
if((state_val_55198 === (12))){
var inst_55161 = (state_55197[(7)]);
var inst_55169 = (state_55197[(2)]);
var inst_55170 = cljs.core.vector_QMARK_(inst_55161);
var state_55197__$1 = (function (){var statearr_55205 = state_55197;
(statearr_55205[(8)] = inst_55169);

return statearr_55205;
})();
if(inst_55170){
var statearr_55206_55238 = state_55197__$1;
(statearr_55206_55238[(1)] = (14));

} else {
var statearr_55207_55239 = state_55197__$1;
(statearr_55207_55239[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (2))){
var _ = (function (){var statearr_55208 = state_55197;
(statearr_55208[(4)] = cljs.core.cons((5),(state_55197[(4)])));

return statearr_55208;
})();
var inst_55154 = fluree.db.util.async.channel_QMARK_(subject);
var state_55197__$1 = state_55197;
if(inst_55154){
var statearr_55209_55240 = state_55197__$1;
(statearr_55209_55240[(1)] = (6));

} else {
var statearr_55210_55241 = state_55197__$1;
(statearr_55210_55241[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (19))){
var inst_55178 = (state_55197[(2)]);
var state_55197__$1 = state_55197;
var statearr_55211_55242 = state_55197__$1;
(statearr_55211_55242[(2)] = inst_55178);

(statearr_55211_55242[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (11))){
var state_55197__$1 = state_55197;
var statearr_55213_55243 = state_55197__$1;
(statearr_55213_55243[(2)] = pred);

(statearr_55213_55243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (9))){
var inst_55157 = (state_55197[(2)]);
var inst_55158 = fluree.db.util.async.throw_err(inst_55157);
var state_55197__$1 = state_55197;
var statearr_55214_55244 = state_55197__$1;
(statearr_55214_55244[(2)] = inst_55158);

(statearr_55214_55244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (5))){
var _ = (function (){var statearr_55215 = state_55197;
(statearr_55215[(4)] = cljs.core.rest((state_55197[(4)])));

return statearr_55215;
})();
var state_55197__$1 = state_55197;
var ex55212 = (state_55197__$1[(2)]);
var statearr_55216_55245 = state_55197__$1;
(statearr_55216_55245[(5)] = ex55212);


if((ex55212 instanceof Error)){
var statearr_55217_55246 = state_55197__$1;
(statearr_55217_55246[(1)] = (4));

(statearr_55217_55246[(5)] = null);

} else {
throw ex55212;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (14))){
var inst_55161 = (state_55197[(7)]);
var inst_55172 = cljs.core.count(inst_55161);
var inst_55173 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55172);
var state_55197__$1 = state_55197;
if(inst_55173){
var statearr_55218_55247 = state_55197__$1;
(statearr_55218_55247[(1)] = (17));

} else {
var statearr_55219_55248 = state_55197__$1;
(statearr_55219_55248[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (16))){
var inst_55169 = (state_55197[(8)]);
var inst_55161 = (state_55197[(7)]);
var inst_55181 = (state_55197[(2)]);
var inst_55182 = fluree.db.dbfunctions.internal.get(inst_55181,inst_55169);
var inst_55183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55184 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55186 = [inst_55161,inst_55169];
var inst_55187 = (new cljs.core.PersistentVector(null,2,(5),inst_55185,inst_55186,null));
var inst_55188 = ["get",inst_55187,inst_55182];
var inst_55189 = cljs.core.PersistentHashMap.fromArrays(inst_55184,inst_55188);
var inst_55190 = [inst_55189,(10)];
var inst_55191 = (new cljs.core.PersistentVector(null,2,(5),inst_55183,inst_55190,null));
var inst_55192 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55191);
var _ = (function (){var statearr_55220 = state_55197;
(statearr_55220[(4)] = cljs.core.rest((state_55197[(4)])));

return statearr_55220;
})();
var state_55197__$1 = (function (){var statearr_55221 = state_55197;
(statearr_55221[(9)] = inst_55192);

return statearr_55221;
})();
var statearr_55222_55249 = state_55197__$1;
(statearr_55222_55249[(2)] = inst_55182);

(statearr_55222_55249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (10))){
var state_55197__$1 = state_55197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55197__$1,(13),pred);
} else {
if((state_val_55198 === (18))){
var inst_55161 = (state_55197[(7)]);
var state_55197__$1 = state_55197;
var statearr_55223_55250 = state_55197__$1;
(statearr_55223_55250[(2)] = inst_55161);

(statearr_55223_55250[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55198 === (8))){
var inst_55161 = (state_55197[(2)]);
var inst_55162 = fluree.db.util.async.channel_QMARK_(pred);
var state_55197__$1 = (function (){var statearr_55224 = state_55197;
(statearr_55224[(7)] = inst_55161);

return statearr_55224;
})();
if(inst_55162){
var statearr_55225_55251 = state_55197__$1;
(statearr_55225_55251[(1)] = (10));

} else {
var statearr_55226_55252 = state_55197__$1;
(statearr_55226_55252[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0 = (function (){
var statearr_55227 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55227[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__);

(statearr_55227[(1)] = (1));

return statearr_55227;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1 = (function (state_55197){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55197);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55228){var ex__2730__auto__ = e55228;
var statearr_55229_55253 = state_55197;
(statearr_55229_55253[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55197[(4)]))){
var statearr_55230_55254 = state_55197;
(statearr_55230_55254[(1)] = cljs.core.first((state_55197[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55255 = state_55197;
state_55197 = G__55255;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = function(state_55197){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1.call(this,state_55197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55231 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55231[(6)] = c__2749__auto__);

return statearr_55231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55294){
var state_val_55295 = (state_55294[(1)]);
if((state_val_55295 === (7))){
var inst_55262 = (state_55294[(7)]);
var state_55294__$1 = state_55294;
var statearr_55296_55320 = state_55294__$1;
(statearr_55296_55320[(2)] = inst_55262);

(statearr_55296_55320[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55295 === (1))){
var state_55294__$1 = state_55294;
var statearr_55297_55321 = state_55294__$1;
(statearr_55297_55321[(2)] = null);

(statearr_55297_55321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55295 === (4))){
var inst_55256 = (state_55294[(2)]);
var state_55294__$1 = state_55294;
var statearr_55298_55322 = state_55294__$1;
(statearr_55298_55322[(2)] = inst_55256);

(statearr_55298_55322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55295 === (6))){
var inst_55264 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55294__$1 = state_55294;
var statearr_55299_55323 = state_55294__$1;
(statearr_55299_55323[(2)] = inst_55264);

(statearr_55299_55323[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55295 === (3))){
var inst_55292 = (state_55294[(2)]);
var state_55294__$1 = state_55294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55294__$1,inst_55292);
} else {
if((state_val_55295 === (12))){
var inst_55274 = (state_55294[(2)]);
var inst_55275 = fluree.db.util.async.throw_err(inst_55274);
var inst_55276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55275,(0),null);
var inst_55277 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55275,(1),null);
var inst_55278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55279 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55280 = ["?pO","?ctx",inst_55276];
var inst_55281 = cljs.core.PersistentHashMap.fromArrays(inst_55279,inst_55280);
var inst_55282 = ((10) + inst_55277);
var inst_55283 = [inst_55281,inst_55282];
var inst_55284 = (new cljs.core.PersistentVector(null,2,(5),inst_55278,inst_55283,null));
var inst_55285 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55284);
var state_55294__$1 = (function (){var statearr_55300 = state_55294;
(statearr_55300[(8)] = inst_55285);

return statearr_55300;
})();
var statearr_55301_55324 = state_55294__$1;
(statearr_55301_55324[(2)] = inst_55276);

(statearr_55301_55324[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55295 === (2))){
var inst_55262 = (state_55294[(7)]);
var _ = (function (){var statearr_55302 = state_55294;
(statearr_55302[(4)] = cljs.core.cons((5),(state_55294[(4)])));

return statearr_55302;
})();
var inst_55262__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55294__$1 = (function (){var statearr_55303 = state_55294;
(statearr_55303[(7)] = inst_55262__$1);

return statearr_55303;
})();
if(cljs.core.truth_(inst_55262__$1)){
var statearr_55304_55325 = state_55294__$1;
(statearr_55304_55325[(1)] = (6));

} else {
var statearr_55305_55326 = state_55294__$1;
(statearr_55305_55326[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55295 === (11))){
var inst_55289 = (state_55294[(2)]);
var _ = (function (){var statearr_55307 = state_55294;
(statearr_55307[(4)] = cljs.core.rest((state_55294[(4)])));

return statearr_55307;
})();
var state_55294__$1 = state_55294;
var statearr_55308_55327 = state_55294__$1;
(statearr_55308_55327[(2)] = inst_55289);

(statearr_55308_55327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55295 === (9))){
var inst_55272 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_55294__$1 = state_55294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55294__$1,(12),inst_55272);
} else {
if((state_val_55295 === (5))){
var _ = (function (){var statearr_55309 = state_55294;
(statearr_55309[(4)] = cljs.core.rest((state_55294[(4)])));

return statearr_55309;
})();
var state_55294__$1 = state_55294;
var ex55306 = (state_55294__$1[(2)]);
var statearr_55310_55328 = state_55294__$1;
(statearr_55310_55328[(5)] = ex55306);


if((ex55306 instanceof Error)){
var statearr_55311_55329 = state_55294__$1;
(statearr_55311_55329[(1)] = (4));

(statearr_55311_55329[(5)] = null);

} else {
throw ex55306;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55295 === (10))){
var inst_55287 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55294__$1 = state_55294;
var statearr_55312_55330 = state_55294__$1;
(statearr_55312_55330[(2)] = inst_55287);

(statearr_55312_55330[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55295 === (8))){
var inst_55267 = (state_55294[(2)]);
var state_55294__$1 = state_55294;
if(cljs.core.truth_(inst_55267)){
var statearr_55313_55331 = state_55294__$1;
(statearr_55313_55331[(1)] = (9));

} else {
var statearr_55314_55332 = state_55294__$1;
(statearr_55314_55332[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_55315 = [null,null,null,null,null,null,null,null,null];
(statearr_55315[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_55315[(1)] = (1));

return statearr_55315;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_55294){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55294);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55316){var ex__2730__auto__ = e55316;
var statearr_55317_55333 = state_55294;
(statearr_55317_55333[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55294[(4)]))){
var statearr_55318_55334 = state_55294;
(statearr_55318_55334[(1)] = cljs.core.first((state_55294[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55335 = state_55294;
state_55294 = G__55335;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = function(state_55294){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_55294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55319 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55319[(6)] = c__2749__auto__);

return statearr_55319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55387){
var state_val_55388 = (state_55387[(1)]);
if((state_val_55388 === (7))){
var state_55387__$1 = state_55387;
var statearr_55389_55422 = state_55387__$1;
(statearr_55389_55422[(2)] = subject);

(statearr_55389_55422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (1))){
var state_55387__$1 = state_55387;
var statearr_55390_55423 = state_55387__$1;
(statearr_55390_55423[(2)] = null);

(statearr_55390_55423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (4))){
var inst_55336 = (state_55387[(2)]);
var state_55387__$1 = state_55387;
var statearr_55391_55424 = state_55387__$1;
(statearr_55391_55424[(2)] = inst_55336);

(statearr_55391_55424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (15))){
var inst_55349 = (state_55387[(7)]);
var state_55387__$1 = state_55387;
var statearr_55392_55425 = state_55387__$1;
(statearr_55392_55425[(2)] = inst_55349);

(statearr_55392_55425[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (13))){
var inst_55353 = (state_55387[(2)]);
var inst_55354 = fluree.db.util.async.throw_err(inst_55353);
var state_55387__$1 = state_55387;
var statearr_55393_55426 = state_55387__$1;
(statearr_55393_55426[(2)] = inst_55354);

(statearr_55393_55426[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (6))){
var state_55387__$1 = state_55387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55387__$1,(9),subject);
} else {
if((state_val_55388 === (17))){
var inst_55349 = (state_55387[(7)]);
var inst_55363 = cljs.core.first(inst_55349);
var state_55387__$1 = state_55387;
var statearr_55394_55427 = state_55387__$1;
(statearr_55394_55427[(2)] = inst_55363);

(statearr_55394_55427[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (3))){
var inst_55385 = (state_55387[(2)]);
var state_55387__$1 = state_55387;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55387__$1,inst_55385);
} else {
if((state_val_55388 === (12))){
var inst_55349 = (state_55387[(7)]);
var inst_55357 = (state_55387[(2)]);
var inst_55358 = cljs.core.vector_QMARK_(inst_55349);
var state_55387__$1 = (function (){var statearr_55395 = state_55387;
(statearr_55395[(8)] = inst_55357);

return statearr_55395;
})();
if(inst_55358){
var statearr_55396_55428 = state_55387__$1;
(statearr_55396_55428[(1)] = (14));

} else {
var statearr_55397_55429 = state_55387__$1;
(statearr_55397_55429[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (2))){
var _ = (function (){var statearr_55398 = state_55387;
(statearr_55398[(4)] = cljs.core.cons((5),(state_55387[(4)])));

return statearr_55398;
})();
var inst_55342 = fluree.db.util.async.channel_QMARK_(subject);
var state_55387__$1 = state_55387;
if(inst_55342){
var statearr_55399_55430 = state_55387__$1;
(statearr_55399_55430[(1)] = (6));

} else {
var statearr_55400_55431 = state_55387__$1;
(statearr_55400_55431[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (19))){
var inst_55366 = (state_55387[(2)]);
var state_55387__$1 = state_55387;
var statearr_55401_55432 = state_55387__$1;
(statearr_55401_55432[(2)] = inst_55366);

(statearr_55401_55432[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (11))){
var state_55387__$1 = state_55387;
var statearr_55403_55433 = state_55387__$1;
(statearr_55403_55433[(2)] = path);

(statearr_55403_55433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (9))){
var inst_55345 = (state_55387[(2)]);
var inst_55346 = fluree.db.util.async.throw_err(inst_55345);
var state_55387__$1 = state_55387;
var statearr_55404_55434 = state_55387__$1;
(statearr_55404_55434[(2)] = inst_55346);

(statearr_55404_55434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (5))){
var _ = (function (){var statearr_55405 = state_55387;
(statearr_55405[(4)] = cljs.core.rest((state_55387[(4)])));

return statearr_55405;
})();
var state_55387__$1 = state_55387;
var ex55402 = (state_55387__$1[(2)]);
var statearr_55406_55435 = state_55387__$1;
(statearr_55406_55435[(5)] = ex55402);


if((ex55402 instanceof Error)){
var statearr_55407_55436 = state_55387__$1;
(statearr_55407_55436[(1)] = (4));

(statearr_55407_55436[(5)] = null);

} else {
throw ex55402;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (14))){
var inst_55349 = (state_55387[(7)]);
var inst_55360 = cljs.core.count(inst_55349);
var inst_55361 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55360);
var state_55387__$1 = state_55387;
if(inst_55361){
var statearr_55408_55437 = state_55387__$1;
(statearr_55408_55437[(1)] = (17));

} else {
var statearr_55409_55438 = state_55387__$1;
(statearr_55409_55438[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (16))){
var inst_55357 = (state_55387[(8)]);
var inst_55349 = (state_55387[(7)]);
var inst_55369 = (state_55387[(2)]);
var inst_55370 = fluree.db.dbfunctions.internal.get_all(inst_55369,inst_55357);
var inst_55371 = cljs.core.count(inst_55357);
var inst_55372 = ((9) + inst_55371);
var inst_55373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55374 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55376 = [inst_55349,inst_55357];
var inst_55377 = (new cljs.core.PersistentVector(null,2,(5),inst_55375,inst_55376,null));
var inst_55378 = ["get-all",inst_55377,inst_55370];
var inst_55379 = cljs.core.PersistentHashMap.fromArrays(inst_55374,inst_55378);
var inst_55380 = [inst_55379,inst_55372];
var inst_55381 = (new cljs.core.PersistentVector(null,2,(5),inst_55373,inst_55380,null));
var inst_55382 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55381);
var _ = (function (){var statearr_55410 = state_55387;
(statearr_55410[(4)] = cljs.core.rest((state_55387[(4)])));

return statearr_55410;
})();
var state_55387__$1 = (function (){var statearr_55411 = state_55387;
(statearr_55411[(9)] = inst_55382);

return statearr_55411;
})();
var statearr_55412_55439 = state_55387__$1;
(statearr_55412_55439[(2)] = inst_55370);

(statearr_55412_55439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (10))){
var state_55387__$1 = state_55387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55387__$1,(13),path);
} else {
if((state_val_55388 === (18))){
var inst_55349 = (state_55387[(7)]);
var state_55387__$1 = state_55387;
var statearr_55413_55440 = state_55387__$1;
(statearr_55413_55440[(2)] = inst_55349);

(statearr_55413_55440[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (8))){
var inst_55349 = (state_55387[(2)]);
var inst_55350 = fluree.db.util.async.channel_QMARK_(path);
var state_55387__$1 = (function (){var statearr_55414 = state_55387;
(statearr_55414[(7)] = inst_55349);

return statearr_55414;
})();
if(inst_55350){
var statearr_55415_55441 = state_55387__$1;
(statearr_55415_55441[(1)] = (10));

} else {
var statearr_55416_55442 = state_55387__$1;
(statearr_55416_55442[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0 = (function (){
var statearr_55417 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55417[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__);

(statearr_55417[(1)] = (1));

return statearr_55417;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1 = (function (state_55387){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55387);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55418){var ex__2730__auto__ = e55418;
var statearr_55419_55443 = state_55387;
(statearr_55419_55443[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55387[(4)]))){
var statearr_55420_55444 = state_55387;
(statearr_55420_55444[(1)] = cljs.core.first((state_55387[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55445 = state_55387;
state_55387 = G__55445;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = function(state_55387){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1.call(this,state_55387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55421 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55421[(6)] = c__2749__auto__);

return statearr_55421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55484){
var state_val_55485 = (state_55484[(1)]);
if((state_val_55485 === (7))){
var state_55484__$1 = state_55484;
var statearr_55486_55510 = state_55484__$1;
(statearr_55486_55510[(2)] = subject);

(statearr_55486_55510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55485 === (1))){
var state_55484__$1 = state_55484;
var statearr_55487_55511 = state_55484__$1;
(statearr_55487_55511[(2)] = null);

(statearr_55487_55511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55485 === (4))){
var inst_55446 = (state_55484[(2)]);
var state_55484__$1 = state_55484;
var statearr_55488_55512 = state_55484__$1;
(statearr_55488_55512[(2)] = inst_55446);

(statearr_55488_55512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55485 === (13))){
var inst_55463 = (state_55484[(2)]);
var inst_55464 = fluree.db.util.async.throw_err(inst_55463);
var state_55484__$1 = state_55484;
var statearr_55489_55513 = state_55484__$1;
(statearr_55489_55513[(2)] = inst_55464);

(statearr_55489_55513[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55485 === (6))){
var state_55484__$1 = state_55484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55484__$1,(9),subject);
} else {
if((state_val_55485 === (3))){
var inst_55482 = (state_55484[(2)]);
var state_55484__$1 = state_55484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55484__$1,inst_55482);
} else {
if((state_val_55485 === (12))){
var inst_55459 = (state_55484[(7)]);
var inst_55467 = (state_55484[(2)]);
var inst_55468 = fluree.db.dbfunctions.internal.get_in(inst_55459,inst_55467);
var inst_55469 = cljs.core.count(inst_55467);
var inst_55470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55471 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55473 = [inst_55459,inst_55467];
var inst_55474 = (new cljs.core.PersistentVector(null,2,(5),inst_55472,inst_55473,null));
var inst_55475 = ["get-in",inst_55474,inst_55468];
var inst_55476 = cljs.core.PersistentHashMap.fromArrays(inst_55471,inst_55475);
var inst_55477 = [inst_55476,inst_55469];
var inst_55478 = (new cljs.core.PersistentVector(null,2,(5),inst_55470,inst_55477,null));
var inst_55479 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55478);
var _ = (function (){var statearr_55490 = state_55484;
(statearr_55490[(4)] = cljs.core.rest((state_55484[(4)])));

return statearr_55490;
})();
var state_55484__$1 = (function (){var statearr_55491 = state_55484;
(statearr_55491[(8)] = inst_55479);

return statearr_55491;
})();
var statearr_55492_55514 = state_55484__$1;
(statearr_55492_55514[(2)] = inst_55468);

(statearr_55492_55514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55485 === (2))){
var _ = (function (){var statearr_55493 = state_55484;
(statearr_55493[(4)] = cljs.core.cons((5),(state_55484[(4)])));

return statearr_55493;
})();
var inst_55452 = fluree.db.util.async.channel_QMARK_(subject);
var state_55484__$1 = state_55484;
if(inst_55452){
var statearr_55494_55515 = state_55484__$1;
(statearr_55494_55515[(1)] = (6));

} else {
var statearr_55495_55516 = state_55484__$1;
(statearr_55495_55516[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55485 === (11))){
var state_55484__$1 = state_55484;
var statearr_55497_55517 = state_55484__$1;
(statearr_55497_55517[(2)] = path);

(statearr_55497_55517[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55485 === (9))){
var inst_55455 = (state_55484[(2)]);
var inst_55456 = fluree.db.util.async.throw_err(inst_55455);
var state_55484__$1 = state_55484;
var statearr_55498_55518 = state_55484__$1;
(statearr_55498_55518[(2)] = inst_55456);

(statearr_55498_55518[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55485 === (5))){
var _ = (function (){var statearr_55499 = state_55484;
(statearr_55499[(4)] = cljs.core.rest((state_55484[(4)])));

return statearr_55499;
})();
var state_55484__$1 = state_55484;
var ex55496 = (state_55484__$1[(2)]);
var statearr_55500_55519 = state_55484__$1;
(statearr_55500_55519[(5)] = ex55496);


if((ex55496 instanceof Error)){
var statearr_55501_55520 = state_55484__$1;
(statearr_55501_55520[(1)] = (4));

(statearr_55501_55520[(5)] = null);

} else {
throw ex55496;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55485 === (10))){
var state_55484__$1 = state_55484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55484__$1,(13),path);
} else {
if((state_val_55485 === (8))){
var inst_55459 = (state_55484[(2)]);
var inst_55460 = fluree.db.util.async.channel_QMARK_(path);
var state_55484__$1 = (function (){var statearr_55502 = state_55484;
(statearr_55502[(7)] = inst_55459);

return statearr_55502;
})();
if(inst_55460){
var statearr_55503_55521 = state_55484__$1;
(statearr_55503_55521[(1)] = (10));

} else {
var statearr_55504_55522 = state_55484__$1;
(statearr_55504_55522[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0 = (function (){
var statearr_55505 = [null,null,null,null,null,null,null,null,null];
(statearr_55505[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__);

(statearr_55505[(1)] = (1));

return statearr_55505;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1 = (function (state_55484){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55484);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55506){var ex__2730__auto__ = e55506;
var statearr_55507_55523 = state_55484;
(statearr_55507_55523[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55484[(4)]))){
var statearr_55508_55524 = state_55484;
(statearr_55508_55524[(1)] = cljs.core.first((state_55484[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55525 = state_55484;
state_55484 = G__55525;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = function(state_55484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1.call(this,state_55484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55509 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55509[(6)] = c__2749__auto__);

return statearr_55509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55570){
var state_val_55571 = (state_55570[(1)]);
if((state_val_55571 === (7))){
var state_55570__$1 = state_55570;
var statearr_55572_55601 = state_55570__$1;
(statearr_55572_55601[(2)] = coll);

(statearr_55572_55601[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (1))){
var state_55570__$1 = state_55570;
var statearr_55573_55602 = state_55570__$1;
(statearr_55573_55602[(2)] = null);

(statearr_55573_55602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (4))){
var inst_55526 = (state_55570[(2)]);
var state_55570__$1 = state_55570;
var statearr_55574_55603 = state_55570__$1;
(statearr_55574_55603[(2)] = inst_55526);

(statearr_55574_55603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (15))){
var inst_55546 = (state_55570[(7)]);
var inst_55554 = (state_55570[(2)]);
var inst_55555 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_55546,inst_55554);
var inst_55556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55557 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55559 = [inst_55546,inst_55554];
var inst_55560 = (new cljs.core.PersistentVector(null,2,(5),inst_55558,inst_55559,null));
var inst_55561 = ["contains?",inst_55560,inst_55555];
var inst_55562 = cljs.core.PersistentHashMap.fromArrays(inst_55557,inst_55561);
var inst_55563 = [inst_55562,(10)];
var inst_55564 = (new cljs.core.PersistentVector(null,2,(5),inst_55556,inst_55563,null));
var inst_55565 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55564);
var _ = (function (){var statearr_55575 = state_55570;
(statearr_55575[(4)] = cljs.core.rest((state_55570[(4)])));

return statearr_55575;
})();
var state_55570__$1 = (function (){var statearr_55576 = state_55570;
(statearr_55576[(8)] = inst_55565);

return statearr_55576;
})();
var statearr_55577_55604 = state_55570__$1;
(statearr_55577_55604[(2)] = inst_55555);

(statearr_55577_55604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (13))){
var state_55570__$1 = state_55570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55570__$1,(16),key);
} else {
if((state_val_55571 === (6))){
var state_55570__$1 = state_55570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55570__$1,(9),coll);
} else {
if((state_val_55571 === (3))){
var inst_55568 = (state_55570[(2)]);
var state_55570__$1 = state_55570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55570__$1,inst_55568);
} else {
if((state_val_55571 === (12))){
var inst_55546 = (state_55570[(2)]);
var inst_55547 = fluree.db.util.async.channel_QMARK_(key);
var state_55570__$1 = (function (){var statearr_55578 = state_55570;
(statearr_55578[(7)] = inst_55546);

return statearr_55578;
})();
if(inst_55547){
var statearr_55579_55605 = state_55570__$1;
(statearr_55579_55605[(1)] = (13));

} else {
var statearr_55580_55606 = state_55570__$1;
(statearr_55580_55606[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (2))){
var _ = (function (){var statearr_55581 = state_55570;
(statearr_55581[(4)] = cljs.core.cons((5),(state_55570[(4)])));

return statearr_55581;
})();
var inst_55532 = fluree.db.util.async.channel_QMARK_(coll);
var state_55570__$1 = state_55570;
if(inst_55532){
var statearr_55582_55607 = state_55570__$1;
(statearr_55582_55607[(1)] = (6));

} else {
var statearr_55583_55608 = state_55570__$1;
(statearr_55583_55608[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (11))){
var inst_55539 = (state_55570[(9)]);
var inst_55543 = cljs.core.flatten(inst_55539);
var inst_55544 = cljs.core.set(inst_55543);
var state_55570__$1 = state_55570;
var statearr_55585_55609 = state_55570__$1;
(statearr_55585_55609[(2)] = inst_55544);

(statearr_55585_55609[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (9))){
var inst_55535 = (state_55570[(2)]);
var inst_55536 = fluree.db.util.async.throw_err(inst_55535);
var state_55570__$1 = state_55570;
var statearr_55586_55610 = state_55570__$1;
(statearr_55586_55610[(2)] = inst_55536);

(statearr_55586_55610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (5))){
var _ = (function (){var statearr_55587 = state_55570;
(statearr_55587[(4)] = cljs.core.rest((state_55570[(4)])));

return statearr_55587;
})();
var state_55570__$1 = state_55570;
var ex55584 = (state_55570__$1[(2)]);
var statearr_55588_55611 = state_55570__$1;
(statearr_55588_55611[(5)] = ex55584);


if((ex55584 instanceof Error)){
var statearr_55589_55612 = state_55570__$1;
(statearr_55589_55612[(1)] = (4));

(statearr_55589_55612[(5)] = null);

} else {
throw ex55584;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (14))){
var state_55570__$1 = state_55570;
var statearr_55590_55613 = state_55570__$1;
(statearr_55590_55613[(2)] = key);

(statearr_55590_55613[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (16))){
var inst_55550 = (state_55570[(2)]);
var inst_55551 = fluree.db.util.async.throw_err(inst_55550);
var state_55570__$1 = state_55570;
var statearr_55591_55614 = state_55570__$1;
(statearr_55591_55614[(2)] = inst_55551);

(statearr_55591_55614[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (10))){
var inst_55539 = (state_55570[(9)]);
var state_55570__$1 = state_55570;
var statearr_55592_55615 = state_55570__$1;
(statearr_55592_55615[(2)] = inst_55539);

(statearr_55592_55615[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55571 === (8))){
var inst_55539 = (state_55570[(9)]);
var inst_55539__$1 = (state_55570[(2)]);
var inst_55540 = cljs.core.set_QMARK_(inst_55539__$1);
var state_55570__$1 = (function (){var statearr_55593 = state_55570;
(statearr_55593[(9)] = inst_55539__$1);

return statearr_55593;
})();
if(inst_55540){
var statearr_55594_55616 = state_55570__$1;
(statearr_55594_55616[(1)] = (10));

} else {
var statearr_55595_55617 = state_55570__$1;
(statearr_55595_55617[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_55596 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55596[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__);

(statearr_55596[(1)] = (1));

return statearr_55596;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1 = (function (state_55570){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55570);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55597){var ex__2730__auto__ = e55597;
var statearr_55598_55618 = state_55570;
(statearr_55598_55618[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55570[(4)]))){
var statearr_55599_55619 = state_55570;
(statearr_55599_55619[(1)] = cljs.core.first((state_55570[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55620 = state_55570;
state_55570 = G__55620;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = function(state_55570){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1.call(this,state_55570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55600 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55600[(6)] = c__2749__auto__);

return statearr_55600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55692 = arguments.length;
var i__5770__auto___55693 = (0);
while(true){
if((i__5770__auto___55693 < len__5769__auto___55692)){
args__5775__auto__.push((arguments[i__5770__auto___55693]));

var G__55694 = (i__5770__auto___55693 + (1));
i__5770__auto___55693 = G__55694;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55666){
var state_val_55667 = (state_55666[(1)]);
if((state_val_55667 === (7))){
var inst_55632 = (state_55666[(7)]);
var inst_55636 = cljs.core.first(inst_55632);
var inst_55637 = cljs.core.coll_QMARK_(inst_55636);
var state_55666__$1 = state_55666;
var statearr_55668_55695 = state_55666__$1;
(statearr_55668_55695[(2)] = inst_55637);

(statearr_55668_55695[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55667 === (1))){
var state_55666__$1 = state_55666;
var statearr_55669_55696 = state_55666__$1;
(statearr_55669_55696[(2)] = null);

(statearr_55669_55696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55667 === (4))){
var inst_55623 = (state_55666[(2)]);
var state_55666__$1 = state_55666;
var statearr_55670_55697 = state_55666__$1;
(statearr_55670_55697[(2)] = inst_55623);

(statearr_55670_55697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55667 === (6))){
var inst_55632 = (state_55666[(7)]);
var inst_55634 = (state_55666[(8)]);
var inst_55631 = (state_55666[(2)]);
var inst_55632__$1 = fluree.db.util.async.throw_err(inst_55631);
var inst_55633 = cljs.core.count(inst_55632__$1);
var inst_55634__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55633);
var state_55666__$1 = (function (){var statearr_55671 = state_55666;
(statearr_55671[(7)] = inst_55632__$1);

(statearr_55671[(8)] = inst_55634__$1);

return statearr_55671;
})();
if(inst_55634__$1){
var statearr_55672_55698 = state_55666__$1;
(statearr_55672_55698[(1)] = (7));

} else {
var statearr_55673_55699 = state_55666__$1;
(statearr_55673_55699[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55667 === (3))){
var inst_55664 = (state_55666[(2)]);
var state_55666__$1 = state_55666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55666__$1,inst_55664);
} else {
if((state_val_55667 === (12))){
var inst_55645 = (state_55666[(2)]);
var inst_55646 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_55645);
var inst_55647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55648 = [inst_55645];
var inst_55649 = (new cljs.core.PersistentVector(null,1,(5),inst_55647,inst_55648,null));
var inst_55650 = cljs.core.count(inst_55649);
var inst_55651 = ((9) + inst_55650);
var inst_55652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55653 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55655 = [inst_55645];
var inst_55656 = (new cljs.core.PersistentVector(null,1,(5),inst_55654,inst_55655,null));
var inst_55657 = ["hash-set",inst_55656,inst_55646];
var inst_55658 = cljs.core.PersistentHashMap.fromArrays(inst_55653,inst_55657);
var inst_55659 = [inst_55658,inst_55651];
var inst_55660 = (new cljs.core.PersistentVector(null,2,(5),inst_55652,inst_55659,null));
var inst_55661 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55660);
var _ = (function (){var statearr_55674 = state_55666;
(statearr_55674[(4)] = cljs.core.rest((state_55666[(4)])));

return statearr_55674;
})();
var state_55666__$1 = (function (){var statearr_55675 = state_55666;
(statearr_55675[(9)] = inst_55661);

return statearr_55675;
})();
var statearr_55676_55700 = state_55666__$1;
(statearr_55676_55700[(2)] = inst_55646);

(statearr_55676_55700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55667 === (2))){
var _ = (function (){var statearr_55677 = state_55666;
(statearr_55677[(4)] = cljs.core.cons((5),(state_55666[(4)])));

return statearr_55677;
})();
var inst_55629 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55666__$1 = state_55666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55666__$1,(6),inst_55629);
} else {
if((state_val_55667 === (11))){
var inst_55632 = (state_55666[(7)]);
var state_55666__$1 = state_55666;
var statearr_55679_55701 = state_55666__$1;
(statearr_55679_55701[(2)] = inst_55632);

(statearr_55679_55701[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55667 === (9))){
var inst_55640 = (state_55666[(2)]);
var state_55666__$1 = state_55666;
if(cljs.core.truth_(inst_55640)){
var statearr_55680_55702 = state_55666__$1;
(statearr_55680_55702[(1)] = (10));

} else {
var statearr_55681_55703 = state_55666__$1;
(statearr_55681_55703[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55667 === (5))){
var _ = (function (){var statearr_55682 = state_55666;
(statearr_55682[(4)] = cljs.core.rest((state_55666[(4)])));

return statearr_55682;
})();
var state_55666__$1 = state_55666;
var ex55678 = (state_55666__$1[(2)]);
var statearr_55683_55704 = state_55666__$1;
(statearr_55683_55704[(5)] = ex55678);


if((ex55678 instanceof Error)){
var statearr_55684_55705 = state_55666__$1;
(statearr_55684_55705[(1)] = (4));

(statearr_55684_55705[(5)] = null);

} else {
throw ex55678;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55667 === (10))){
var inst_55632 = (state_55666[(7)]);
var inst_55642 = cljs.core.first(inst_55632);
var state_55666__$1 = state_55666;
var statearr_55685_55706 = state_55666__$1;
(statearr_55685_55706[(2)] = inst_55642);

(statearr_55685_55706[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55667 === (8))){
var inst_55634 = (state_55666[(8)]);
var state_55666__$1 = state_55666;
var statearr_55686_55707 = state_55666__$1;
(statearr_55686_55707[(2)] = inst_55634);

(statearr_55686_55707[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55687 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55687[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55687[(1)] = (1));

return statearr_55687;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55666){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55666);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55688){var ex__2730__auto__ = e55688;
var statearr_55689_55708 = state_55666;
(statearr_55689_55708[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55666[(4)]))){
var statearr_55690_55709 = state_55666;
(statearr_55690_55709[(1)] = cljs.core.first((state_55666[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55710 = state_55666;
state_55666 = G__55710;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55666){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55691 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55691[(6)] = c__2749__auto__);

return statearr_55691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55621){
var G__55622 = cljs.core.first(seq55621);
var seq55621__$1 = cljs.core.next(seq55621);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55622,seq55621__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55760 = arguments.length;
var i__5770__auto___55761 = (0);
while(true){
if((i__5770__auto___55761 < len__5769__auto___55760)){
args__5775__auto__.push((arguments[i__5770__auto___55761]));

var G__55762 = (i__5770__auto___55761 + (1));
i__5770__auto___55761 = G__55762;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55743){
var state_val_55744 = (state_55743[(1)]);
if((state_val_55744 === (1))){
var state_55743__$1 = state_55743;
var statearr_55745_55763 = state_55743__$1;
(statearr_55745_55763[(2)] = null);

(statearr_55745_55763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55744 === (2))){
var _ = (function (){var statearr_55746 = state_55743;
(statearr_55746[(4)] = cljs.core.cons((5),(state_55743[(4)])));

return statearr_55746;
})();
var inst_55719 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55743__$1 = state_55743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55743__$1,(6),inst_55719);
} else {
if((state_val_55744 === (3))){
var inst_55741 = (state_55743[(2)]);
var state_55743__$1 = state_55743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55743__$1,inst_55741);
} else {
if((state_val_55744 === (4))){
var inst_55713 = (state_55743[(2)]);
var state_55743__$1 = state_55743;
var statearr_55748_55764 = state_55743__$1;
(statearr_55748_55764[(2)] = inst_55713);

(statearr_55748_55764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55744 === (5))){
var _ = (function (){var statearr_55749 = state_55743;
(statearr_55749[(4)] = cljs.core.rest((state_55743[(4)])));

return statearr_55749;
})();
var state_55743__$1 = state_55743;
var ex55747 = (state_55743__$1[(2)]);
var statearr_55750_55765 = state_55743__$1;
(statearr_55750_55765[(5)] = ex55747);


if((ex55747 instanceof Error)){
var statearr_55751_55766 = state_55743__$1;
(statearr_55751_55766[(1)] = (4));

(statearr_55751_55766[(5)] = null);

} else {
throw ex55747;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55744 === (6))){
var inst_55721 = (state_55743[(2)]);
var inst_55722 = fluree.db.util.async.throw_err(inst_55721);
var inst_55723 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_55722);
var inst_55724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55725 = [inst_55722];
var inst_55726 = (new cljs.core.PersistentVector(null,1,(5),inst_55724,inst_55725,null));
var inst_55727 = cljs.core.count(inst_55726);
var inst_55728 = ((9) + inst_55727);
var inst_55729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55730 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55732 = [inst_55722];
var inst_55733 = (new cljs.core.PersistentVector(null,1,(5),inst_55731,inst_55732,null));
var inst_55734 = ["==",inst_55733,inst_55723];
var inst_55735 = cljs.core.PersistentHashMap.fromArrays(inst_55730,inst_55734);
var inst_55736 = [inst_55735,inst_55728];
var inst_55737 = (new cljs.core.PersistentVector(null,2,(5),inst_55729,inst_55736,null));
var inst_55738 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55737);
var _ = (function (){var statearr_55752 = state_55743;
(statearr_55752[(4)] = cljs.core.rest((state_55743[(4)])));

return statearr_55752;
})();
var state_55743__$1 = (function (){var statearr_55753 = state_55743;
(statearr_55753[(7)] = inst_55738);

return statearr_55753;
})();
var statearr_55754_55767 = state_55743__$1;
(statearr_55754_55767[(2)] = inst_55723);

(statearr_55754_55767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55755 = [null,null,null,null,null,null,null,null];
(statearr_55755[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55755[(1)] = (1));

return statearr_55755;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55743){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55743);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55756){var ex__2730__auto__ = e55756;
var statearr_55757_55768 = state_55743;
(statearr_55757_55768[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55743[(4)]))){
var statearr_55758_55769 = state_55743;
(statearr_55758_55769[(1)] = cljs.core.first((state_55743[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55770 = state_55743;
state_55743 = G__55770;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55743){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55759 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55759[(6)] = c__2749__auto__);

return statearr_55759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55711){
var G__55712 = cljs.core.first(seq55711);
var seq55711__$1 = cljs.core.next(seq55711);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55712,seq55711__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55820 = arguments.length;
var i__5770__auto___55821 = (0);
while(true){
if((i__5770__auto___55821 < len__5769__auto___55820)){
args__5775__auto__.push((arguments[i__5770__auto___55821]));

var G__55822 = (i__5770__auto___55821 + (1));
i__5770__auto___55821 = G__55822;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55803){
var state_val_55804 = (state_55803[(1)]);
if((state_val_55804 === (1))){
var state_55803__$1 = state_55803;
var statearr_55805_55823 = state_55803__$1;
(statearr_55805_55823[(2)] = null);

(statearr_55805_55823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55804 === (2))){
var _ = (function (){var statearr_55806 = state_55803;
(statearr_55806[(4)] = cljs.core.cons((5),(state_55803[(4)])));

return statearr_55806;
})();
var inst_55779 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55803__$1 = state_55803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55803__$1,(6),inst_55779);
} else {
if((state_val_55804 === (3))){
var inst_55801 = (state_55803[(2)]);
var state_55803__$1 = state_55803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55803__$1,inst_55801);
} else {
if((state_val_55804 === (4))){
var inst_55773 = (state_55803[(2)]);
var state_55803__$1 = state_55803;
var statearr_55808_55824 = state_55803__$1;
(statearr_55808_55824[(2)] = inst_55773);

(statearr_55808_55824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55804 === (5))){
var _ = (function (){var statearr_55809 = state_55803;
(statearr_55809[(4)] = cljs.core.rest((state_55803[(4)])));

return statearr_55809;
})();
var state_55803__$1 = state_55803;
var ex55807 = (state_55803__$1[(2)]);
var statearr_55810_55825 = state_55803__$1;
(statearr_55810_55825[(5)] = ex55807);


if((ex55807 instanceof Error)){
var statearr_55811_55826 = state_55803__$1;
(statearr_55811_55826[(1)] = (4));

(statearr_55811_55826[(5)] = null);

} else {
throw ex55807;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55804 === (6))){
var inst_55781 = (state_55803[(2)]);
var inst_55782 = fluree.db.util.async.throw_err(inst_55781);
var inst_55783 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_55782);
var inst_55784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55785 = [inst_55782];
var inst_55786 = (new cljs.core.PersistentVector(null,1,(5),inst_55784,inst_55785,null));
var inst_55787 = cljs.core.count(inst_55786);
var inst_55788 = ((9) + inst_55787);
var inst_55789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55790 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55792 = [inst_55782];
var inst_55793 = (new cljs.core.PersistentVector(null,1,(5),inst_55791,inst_55792,null));
var inst_55794 = [">",inst_55793,inst_55783];
var inst_55795 = cljs.core.PersistentHashMap.fromArrays(inst_55790,inst_55794);
var inst_55796 = [inst_55795,inst_55788];
var inst_55797 = (new cljs.core.PersistentVector(null,2,(5),inst_55789,inst_55796,null));
var inst_55798 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55797);
var _ = (function (){var statearr_55812 = state_55803;
(statearr_55812[(4)] = cljs.core.rest((state_55803[(4)])));

return statearr_55812;
})();
var state_55803__$1 = (function (){var statearr_55813 = state_55803;
(statearr_55813[(7)] = inst_55798);

return statearr_55813;
})();
var statearr_55814_55827 = state_55803__$1;
(statearr_55814_55827[(2)] = inst_55783);

(statearr_55814_55827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55815 = [null,null,null,null,null,null,null,null];
(statearr_55815[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55815[(1)] = (1));

return statearr_55815;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55803){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55803);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55816){var ex__2730__auto__ = e55816;
var statearr_55817_55828 = state_55803;
(statearr_55817_55828[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55803[(4)]))){
var statearr_55818_55829 = state_55803;
(statearr_55818_55829[(1)] = cljs.core.first((state_55803[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55830 = state_55803;
state_55803 = G__55830;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55803){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55819 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55819[(6)] = c__2749__auto__);

return statearr_55819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55771){
var G__55772 = cljs.core.first(seq55771);
var seq55771__$1 = cljs.core.next(seq55771);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55772,seq55771__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55880 = arguments.length;
var i__5770__auto___55881 = (0);
while(true){
if((i__5770__auto___55881 < len__5769__auto___55880)){
args__5775__auto__.push((arguments[i__5770__auto___55881]));

var G__55882 = (i__5770__auto___55881 + (1));
i__5770__auto___55881 = G__55882;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55863){
var state_val_55864 = (state_55863[(1)]);
if((state_val_55864 === (1))){
var state_55863__$1 = state_55863;
var statearr_55865_55883 = state_55863__$1;
(statearr_55865_55883[(2)] = null);

(statearr_55865_55883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55864 === (2))){
var _ = (function (){var statearr_55866 = state_55863;
(statearr_55866[(4)] = cljs.core.cons((5),(state_55863[(4)])));

return statearr_55866;
})();
var inst_55839 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55863__$1 = state_55863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55863__$1,(6),inst_55839);
} else {
if((state_val_55864 === (3))){
var inst_55861 = (state_55863[(2)]);
var state_55863__$1 = state_55863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55863__$1,inst_55861);
} else {
if((state_val_55864 === (4))){
var inst_55833 = (state_55863[(2)]);
var state_55863__$1 = state_55863;
var statearr_55868_55884 = state_55863__$1;
(statearr_55868_55884[(2)] = inst_55833);

(statearr_55868_55884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55864 === (5))){
var _ = (function (){var statearr_55869 = state_55863;
(statearr_55869[(4)] = cljs.core.rest((state_55863[(4)])));

return statearr_55869;
})();
var state_55863__$1 = state_55863;
var ex55867 = (state_55863__$1[(2)]);
var statearr_55870_55885 = state_55863__$1;
(statearr_55870_55885[(5)] = ex55867);


if((ex55867 instanceof Error)){
var statearr_55871_55886 = state_55863__$1;
(statearr_55871_55886[(1)] = (4));

(statearr_55871_55886[(5)] = null);

} else {
throw ex55867;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55864 === (6))){
var inst_55841 = (state_55863[(2)]);
var inst_55842 = fluree.db.util.async.throw_err(inst_55841);
var inst_55843 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_55842);
var inst_55844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55845 = [inst_55842];
var inst_55846 = (new cljs.core.PersistentVector(null,1,(5),inst_55844,inst_55845,null));
var inst_55847 = cljs.core.count(inst_55846);
var inst_55848 = ((9) + inst_55847);
var inst_55849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55850 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55852 = [inst_55842];
var inst_55853 = (new cljs.core.PersistentVector(null,1,(5),inst_55851,inst_55852,null));
var inst_55854 = ["<",inst_55853,inst_55843];
var inst_55855 = cljs.core.PersistentHashMap.fromArrays(inst_55850,inst_55854);
var inst_55856 = [inst_55855,inst_55848];
var inst_55857 = (new cljs.core.PersistentVector(null,2,(5),inst_55849,inst_55856,null));
var inst_55858 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55857);
var _ = (function (){var statearr_55872 = state_55863;
(statearr_55872[(4)] = cljs.core.rest((state_55863[(4)])));

return statearr_55872;
})();
var state_55863__$1 = (function (){var statearr_55873 = state_55863;
(statearr_55873[(7)] = inst_55858);

return statearr_55873;
})();
var statearr_55874_55887 = state_55863__$1;
(statearr_55874_55887[(2)] = inst_55843);

(statearr_55874_55887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55875 = [null,null,null,null,null,null,null,null];
(statearr_55875[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55875[(1)] = (1));

return statearr_55875;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55863){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55863);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55876){var ex__2730__auto__ = e55876;
var statearr_55877_55888 = state_55863;
(statearr_55877_55888[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55863[(4)]))){
var statearr_55878_55889 = state_55863;
(statearr_55878_55889[(1)] = cljs.core.first((state_55863[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55890 = state_55863;
state_55863 = G__55890;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55863){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55879 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55879[(6)] = c__2749__auto__);

return statearr_55879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55831){
var G__55832 = cljs.core.first(seq55831);
var seq55831__$1 = cljs.core.next(seq55831);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55832,seq55831__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55940 = arguments.length;
var i__5770__auto___55941 = (0);
while(true){
if((i__5770__auto___55941 < len__5769__auto___55940)){
args__5775__auto__.push((arguments[i__5770__auto___55941]));

var G__55942 = (i__5770__auto___55941 + (1));
i__5770__auto___55941 = G__55942;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55923){
var state_val_55924 = (state_55923[(1)]);
if((state_val_55924 === (1))){
var state_55923__$1 = state_55923;
var statearr_55925_55943 = state_55923__$1;
(statearr_55925_55943[(2)] = null);

(statearr_55925_55943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55924 === (2))){
var _ = (function (){var statearr_55926 = state_55923;
(statearr_55926[(4)] = cljs.core.cons((5),(state_55923[(4)])));

return statearr_55926;
})();
var inst_55899 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55923__$1 = state_55923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55923__$1,(6),inst_55899);
} else {
if((state_val_55924 === (3))){
var inst_55921 = (state_55923[(2)]);
var state_55923__$1 = state_55923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55923__$1,inst_55921);
} else {
if((state_val_55924 === (4))){
var inst_55893 = (state_55923[(2)]);
var state_55923__$1 = state_55923;
var statearr_55928_55944 = state_55923__$1;
(statearr_55928_55944[(2)] = inst_55893);

(statearr_55928_55944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55924 === (5))){
var _ = (function (){var statearr_55929 = state_55923;
(statearr_55929[(4)] = cljs.core.rest((state_55923[(4)])));

return statearr_55929;
})();
var state_55923__$1 = state_55923;
var ex55927 = (state_55923__$1[(2)]);
var statearr_55930_55945 = state_55923__$1;
(statearr_55930_55945[(5)] = ex55927);


if((ex55927 instanceof Error)){
var statearr_55931_55946 = state_55923__$1;
(statearr_55931_55946[(1)] = (4));

(statearr_55931_55946[(5)] = null);

} else {
throw ex55927;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55924 === (6))){
var inst_55901 = (state_55923[(2)]);
var inst_55902 = fluree.db.util.async.throw_err(inst_55901);
var inst_55903 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_55902);
var inst_55904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55905 = [inst_55902];
var inst_55906 = (new cljs.core.PersistentVector(null,1,(5),inst_55904,inst_55905,null));
var inst_55907 = cljs.core.count(inst_55906);
var inst_55908 = ((9) + inst_55907);
var inst_55909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55910 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55912 = [inst_55902];
var inst_55913 = (new cljs.core.PersistentVector(null,1,(5),inst_55911,inst_55912,null));
var inst_55914 = ["<=",inst_55913,inst_55903];
var inst_55915 = cljs.core.PersistentHashMap.fromArrays(inst_55910,inst_55914);
var inst_55916 = [inst_55915,inst_55908];
var inst_55917 = (new cljs.core.PersistentVector(null,2,(5),inst_55909,inst_55916,null));
var inst_55918 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55917);
var _ = (function (){var statearr_55932 = state_55923;
(statearr_55932[(4)] = cljs.core.rest((state_55923[(4)])));

return statearr_55932;
})();
var state_55923__$1 = (function (){var statearr_55933 = state_55923;
(statearr_55933[(7)] = inst_55918);

return statearr_55933;
})();
var statearr_55934_55947 = state_55923__$1;
(statearr_55934_55947[(2)] = inst_55903);

(statearr_55934_55947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55935 = [null,null,null,null,null,null,null,null];
(statearr_55935[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55935[(1)] = (1));

return statearr_55935;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55923){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55923);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55936){var ex__2730__auto__ = e55936;
var statearr_55937_55948 = state_55923;
(statearr_55937_55948[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55923[(4)]))){
var statearr_55938_55949 = state_55923;
(statearr_55938_55949[(1)] = cljs.core.first((state_55923[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55950 = state_55923;
state_55923 = G__55950;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55923){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55939 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55939[(6)] = c__2749__auto__);

return statearr_55939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55891){
var G__55892 = cljs.core.first(seq55891);
var seq55891__$1 = cljs.core.next(seq55891);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55892,seq55891__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56000 = arguments.length;
var i__5770__auto___56001 = (0);
while(true){
if((i__5770__auto___56001 < len__5769__auto___56000)){
args__5775__auto__.push((arguments[i__5770__auto___56001]));

var G__56002 = (i__5770__auto___56001 + (1));
i__5770__auto___56001 = G__56002;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55983){
var state_val_55984 = (state_55983[(1)]);
if((state_val_55984 === (1))){
var state_55983__$1 = state_55983;
var statearr_55985_56003 = state_55983__$1;
(statearr_55985_56003[(2)] = null);

(statearr_55985_56003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55984 === (2))){
var _ = (function (){var statearr_55986 = state_55983;
(statearr_55986[(4)] = cljs.core.cons((5),(state_55983[(4)])));

return statearr_55986;
})();
var inst_55959 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55983__$1 = state_55983;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55983__$1,(6),inst_55959);
} else {
if((state_val_55984 === (3))){
var inst_55981 = (state_55983[(2)]);
var state_55983__$1 = state_55983;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55983__$1,inst_55981);
} else {
if((state_val_55984 === (4))){
var inst_55953 = (state_55983[(2)]);
var state_55983__$1 = state_55983;
var statearr_55988_56004 = state_55983__$1;
(statearr_55988_56004[(2)] = inst_55953);

(statearr_55988_56004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55984 === (5))){
var _ = (function (){var statearr_55989 = state_55983;
(statearr_55989[(4)] = cljs.core.rest((state_55983[(4)])));

return statearr_55989;
})();
var state_55983__$1 = state_55983;
var ex55987 = (state_55983__$1[(2)]);
var statearr_55990_56005 = state_55983__$1;
(statearr_55990_56005[(5)] = ex55987);


if((ex55987 instanceof Error)){
var statearr_55991_56006 = state_55983__$1;
(statearr_55991_56006[(1)] = (4));

(statearr_55991_56006[(5)] = null);

} else {
throw ex55987;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55984 === (6))){
var inst_55961 = (state_55983[(2)]);
var inst_55962 = fluree.db.util.async.throw_err(inst_55961);
var inst_55963 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55962);
var inst_55964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55965 = [inst_55962];
var inst_55966 = (new cljs.core.PersistentVector(null,1,(5),inst_55964,inst_55965,null));
var inst_55967 = cljs.core.count(inst_55966);
var inst_55968 = ((9) + inst_55967);
var inst_55969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55970 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55972 = [inst_55962];
var inst_55973 = (new cljs.core.PersistentVector(null,1,(5),inst_55971,inst_55972,null));
var inst_55974 = [">=",inst_55973,inst_55963];
var inst_55975 = cljs.core.PersistentHashMap.fromArrays(inst_55970,inst_55974);
var inst_55976 = [inst_55975,inst_55968];
var inst_55977 = (new cljs.core.PersistentVector(null,2,(5),inst_55969,inst_55976,null));
var inst_55978 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55977);
var _ = (function (){var statearr_55992 = state_55983;
(statearr_55992[(4)] = cljs.core.rest((state_55983[(4)])));

return statearr_55992;
})();
var state_55983__$1 = (function (){var statearr_55993 = state_55983;
(statearr_55993[(7)] = inst_55978);

return statearr_55993;
})();
var statearr_55994_56007 = state_55983__$1;
(statearr_55994_56007[(2)] = inst_55963);

(statearr_55994_56007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55995 = [null,null,null,null,null,null,null,null];
(statearr_55995[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55995[(1)] = (1));

return statearr_55995;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55983){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55983);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55996){var ex__2730__auto__ = e55996;
var statearr_55997_56008 = state_55983;
(statearr_55997_56008[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55983[(4)]))){
var statearr_55998_56009 = state_55983;
(statearr_55998_56009[(1)] = cljs.core.first((state_55983[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56010 = state_55983;
state_55983 = G__56010;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55983){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55999 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55999[(6)] = c__2749__auto__);

return statearr_55999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55951){
var G__55952 = cljs.core.first(seq55951);
var seq55951__$1 = cljs.core.next(seq55951);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55952,seq55951__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56060 = arguments.length;
var i__5770__auto___56061 = (0);
while(true){
if((i__5770__auto___56061 < len__5769__auto___56060)){
args__5775__auto__.push((arguments[i__5770__auto___56061]));

var G__56062 = (i__5770__auto___56061 + (1));
i__5770__auto___56061 = G__56062;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56043){
var state_val_56044 = (state_56043[(1)]);
if((state_val_56044 === (1))){
var state_56043__$1 = state_56043;
var statearr_56045_56063 = state_56043__$1;
(statearr_56045_56063[(2)] = null);

(statearr_56045_56063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56044 === (2))){
var _ = (function (){var statearr_56046 = state_56043;
(statearr_56046[(4)] = cljs.core.cons((5),(state_56043[(4)])));

return statearr_56046;
})();
var inst_56019 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56043__$1 = state_56043;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56043__$1,(6),inst_56019);
} else {
if((state_val_56044 === (3))){
var inst_56041 = (state_56043[(2)]);
var state_56043__$1 = state_56043;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56043__$1,inst_56041);
} else {
if((state_val_56044 === (4))){
var inst_56013 = (state_56043[(2)]);
var state_56043__$1 = state_56043;
var statearr_56048_56064 = state_56043__$1;
(statearr_56048_56064[(2)] = inst_56013);

(statearr_56048_56064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56044 === (5))){
var _ = (function (){var statearr_56049 = state_56043;
(statearr_56049[(4)] = cljs.core.rest((state_56043[(4)])));

return statearr_56049;
})();
var state_56043__$1 = state_56043;
var ex56047 = (state_56043__$1[(2)]);
var statearr_56050_56065 = state_56043__$1;
(statearr_56050_56065[(5)] = ex56047);


if((ex56047 instanceof Error)){
var statearr_56051_56066 = state_56043__$1;
(statearr_56051_56066[(1)] = (4));

(statearr_56051_56066[(5)] = null);

} else {
throw ex56047;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56044 === (6))){
var inst_56021 = (state_56043[(2)]);
var inst_56022 = fluree.db.util.async.throw_err(inst_56021);
var inst_56023 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_56022);
var inst_56024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56025 = [inst_56022];
var inst_56026 = (new cljs.core.PersistentVector(null,1,(5),inst_56024,inst_56025,null));
var inst_56027 = cljs.core.count(inst_56026);
var inst_56028 = ((9) + inst_56027);
var inst_56029 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56030 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56032 = [inst_56022];
var inst_56033 = (new cljs.core.PersistentVector(null,1,(5),inst_56031,inst_56032,null));
var inst_56034 = ["not=",inst_56033,inst_56023];
var inst_56035 = cljs.core.PersistentHashMap.fromArrays(inst_56030,inst_56034);
var inst_56036 = [inst_56035,inst_56028];
var inst_56037 = (new cljs.core.PersistentVector(null,2,(5),inst_56029,inst_56036,null));
var inst_56038 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56037);
var _ = (function (){var statearr_56052 = state_56043;
(statearr_56052[(4)] = cljs.core.rest((state_56043[(4)])));

return statearr_56052;
})();
var state_56043__$1 = (function (){var statearr_56053 = state_56043;
(statearr_56053[(7)] = inst_56038);

return statearr_56053;
})();
var statearr_56054_56067 = state_56043__$1;
(statearr_56054_56067[(2)] = inst_56023);

(statearr_56054_56067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56055 = [null,null,null,null,null,null,null,null];
(statearr_56055[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56055[(1)] = (1));

return statearr_56055;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56043){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56043);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56056){var ex__2730__auto__ = e56056;
var statearr_56057_56068 = state_56043;
(statearr_56057_56068[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56043[(4)]))){
var statearr_56058_56069 = state_56043;
(statearr_56058_56069[(1)] = cljs.core.first((state_56043[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56070 = state_56043;
state_56043 = G__56070;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56043){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56059 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56059[(6)] = c__2749__auto__);

return statearr_56059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq56011){
var G__56012 = cljs.core.first(seq56011);
var seq56011__$1 = cljs.core.next(seq56011);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56012,seq56011__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56120 = arguments.length;
var i__5770__auto___56121 = (0);
while(true){
if((i__5770__auto___56121 < len__5769__auto___56120)){
args__5775__auto__.push((arguments[i__5770__auto___56121]));

var G__56122 = (i__5770__auto___56121 + (1));
i__5770__auto___56121 = G__56122;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56103){
var state_val_56104 = (state_56103[(1)]);
if((state_val_56104 === (1))){
var state_56103__$1 = state_56103;
var statearr_56105_56123 = state_56103__$1;
(statearr_56105_56123[(2)] = null);

(statearr_56105_56123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56104 === (2))){
var _ = (function (){var statearr_56106 = state_56103;
(statearr_56106[(4)] = cljs.core.cons((5),(state_56103[(4)])));

return statearr_56106;
})();
var inst_56079 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56103__$1 = state_56103;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56103__$1,(6),inst_56079);
} else {
if((state_val_56104 === (3))){
var inst_56101 = (state_56103[(2)]);
var state_56103__$1 = state_56103;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56103__$1,inst_56101);
} else {
if((state_val_56104 === (4))){
var inst_56073 = (state_56103[(2)]);
var state_56103__$1 = state_56103;
var statearr_56108_56124 = state_56103__$1;
(statearr_56108_56124[(2)] = inst_56073);

(statearr_56108_56124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56104 === (5))){
var _ = (function (){var statearr_56109 = state_56103;
(statearr_56109[(4)] = cljs.core.rest((state_56103[(4)])));

return statearr_56109;
})();
var state_56103__$1 = state_56103;
var ex56107 = (state_56103__$1[(2)]);
var statearr_56110_56125 = state_56103__$1;
(statearr_56110_56125[(5)] = ex56107);


if((ex56107 instanceof Error)){
var statearr_56111_56126 = state_56103__$1;
(statearr_56111_56126[(1)] = (4));

(statearr_56111_56126[(5)] = null);

} else {
throw ex56107;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56104 === (6))){
var inst_56081 = (state_56103[(2)]);
var inst_56082 = fluree.db.util.async.throw_err(inst_56081);
var inst_56083 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_56082);
var inst_56084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56085 = [inst_56082];
var inst_56086 = (new cljs.core.PersistentVector(null,1,(5),inst_56084,inst_56085,null));
var inst_56087 = cljs.core.count(inst_56086);
var inst_56088 = ((9) + inst_56087);
var inst_56089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56090 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56092 = [inst_56082];
var inst_56093 = (new cljs.core.PersistentVector(null,1,(5),inst_56091,inst_56092,null));
var inst_56094 = ["max",inst_56093,inst_56083];
var inst_56095 = cljs.core.PersistentHashMap.fromArrays(inst_56090,inst_56094);
var inst_56096 = [inst_56095,inst_56088];
var inst_56097 = (new cljs.core.PersistentVector(null,2,(5),inst_56089,inst_56096,null));
var inst_56098 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56097);
var _ = (function (){var statearr_56112 = state_56103;
(statearr_56112[(4)] = cljs.core.rest((state_56103[(4)])));

return statearr_56112;
})();
var state_56103__$1 = (function (){var statearr_56113 = state_56103;
(statearr_56113[(7)] = inst_56098);

return statearr_56113;
})();
var statearr_56114_56127 = state_56103__$1;
(statearr_56114_56127[(2)] = inst_56083);

(statearr_56114_56127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56115 = [null,null,null,null,null,null,null,null];
(statearr_56115[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56115[(1)] = (1));

return statearr_56115;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56103){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56103);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56116){var ex__2730__auto__ = e56116;
var statearr_56117_56128 = state_56103;
(statearr_56117_56128[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56103[(4)]))){
var statearr_56118_56129 = state_56103;
(statearr_56118_56129[(1)] = cljs.core.first((state_56103[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56130 = state_56103;
state_56103 = G__56130;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56103){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56119 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56119[(6)] = c__2749__auto__);

return statearr_56119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq56071){
var G__56072 = cljs.core.first(seq56071);
var seq56071__$1 = cljs.core.next(seq56071);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56072,seq56071__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56180 = arguments.length;
var i__5770__auto___56181 = (0);
while(true){
if((i__5770__auto___56181 < len__5769__auto___56180)){
args__5775__auto__.push((arguments[i__5770__auto___56181]));

var G__56182 = (i__5770__auto___56181 + (1));
i__5770__auto___56181 = G__56182;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56163){
var state_val_56164 = (state_56163[(1)]);
if((state_val_56164 === (1))){
var state_56163__$1 = state_56163;
var statearr_56165_56183 = state_56163__$1;
(statearr_56165_56183[(2)] = null);

(statearr_56165_56183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (2))){
var _ = (function (){var statearr_56166 = state_56163;
(statearr_56166[(4)] = cljs.core.cons((5),(state_56163[(4)])));

return statearr_56166;
})();
var inst_56139 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56163__$1 = state_56163;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56163__$1,(6),inst_56139);
} else {
if((state_val_56164 === (3))){
var inst_56161 = (state_56163[(2)]);
var state_56163__$1 = state_56163;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56163__$1,inst_56161);
} else {
if((state_val_56164 === (4))){
var inst_56133 = (state_56163[(2)]);
var state_56163__$1 = state_56163;
var statearr_56168_56184 = state_56163__$1;
(statearr_56168_56184[(2)] = inst_56133);

(statearr_56168_56184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (5))){
var _ = (function (){var statearr_56169 = state_56163;
(statearr_56169[(4)] = cljs.core.rest((state_56163[(4)])));

return statearr_56169;
})();
var state_56163__$1 = state_56163;
var ex56167 = (state_56163__$1[(2)]);
var statearr_56170_56185 = state_56163__$1;
(statearr_56170_56185[(5)] = ex56167);


if((ex56167 instanceof Error)){
var statearr_56171_56186 = state_56163__$1;
(statearr_56171_56186[(1)] = (4));

(statearr_56171_56186[(5)] = null);

} else {
throw ex56167;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (6))){
var inst_56141 = (state_56163[(2)]);
var inst_56142 = fluree.db.util.async.throw_err(inst_56141);
var inst_56143 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_56142);
var inst_56144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56145 = [inst_56142];
var inst_56146 = (new cljs.core.PersistentVector(null,1,(5),inst_56144,inst_56145,null));
var inst_56147 = cljs.core.count(inst_56146);
var inst_56148 = ((9) + inst_56147);
var inst_56149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56150 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56152 = [inst_56142];
var inst_56153 = (new cljs.core.PersistentVector(null,1,(5),inst_56151,inst_56152,null));
var inst_56154 = ["min",inst_56153,inst_56143];
var inst_56155 = cljs.core.PersistentHashMap.fromArrays(inst_56150,inst_56154);
var inst_56156 = [inst_56155,inst_56148];
var inst_56157 = (new cljs.core.PersistentVector(null,2,(5),inst_56149,inst_56156,null));
var inst_56158 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56157);
var _ = (function (){var statearr_56172 = state_56163;
(statearr_56172[(4)] = cljs.core.rest((state_56163[(4)])));

return statearr_56172;
})();
var state_56163__$1 = (function (){var statearr_56173 = state_56163;
(statearr_56173[(7)] = inst_56158);

return statearr_56173;
})();
var statearr_56174_56187 = state_56163__$1;
(statearr_56174_56187[(2)] = inst_56143);

(statearr_56174_56187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56175 = [null,null,null,null,null,null,null,null];
(statearr_56175[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56175[(1)] = (1));

return statearr_56175;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56163){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56163);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56176){var ex__2730__auto__ = e56176;
var statearr_56177_56188 = state_56163;
(statearr_56177_56188[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56163[(4)]))){
var statearr_56178_56189 = state_56163;
(statearr_56178_56189[(1)] = cljs.core.first((state_56163[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56190 = state_56163;
state_56163 = G__56190;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56163){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56179 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56179[(6)] = c__2749__auto__);

return statearr_56179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq56131){
var G__56132 = cljs.core.first(seq56131);
var seq56131__$1 = cljs.core.next(seq56131);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56132,seq56131__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__56192 = arguments.length;
switch (G__56192) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56237){
var state_val_56238 = (state_56237[(1)]);
if((state_val_56238 === (7))){
var state_56237__$1 = state_56237;
var statearr_56239_56376 = state_56237__$1;
(statearr_56239_56376[(2)] = query_map);

(statearr_56239_56376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56238 === (1))){
var state_56237__$1 = state_56237;
var statearr_56240_56377 = state_56237__$1;
(statearr_56240_56377[(2)] = null);

(statearr_56240_56377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56238 === (4))){
var inst_56193 = (state_56237[(2)]);
var state_56237__$1 = state_56237;
var statearr_56241_56378 = state_56237__$1;
(statearr_56241_56378[(2)] = inst_56193);

(statearr_56241_56378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56238 === (13))){
var inst_56215 = (state_56237[(7)]);
var inst_56219 = (state_56237[(2)]);
var inst_56220 = fluree.db.util.async.throw_err(inst_56219);
var inst_56221 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56220,(0),null);
var inst_56222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56220,(1),null);
var inst_56223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56224 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56226 = [inst_56215];
var inst_56227 = (new cljs.core.PersistentVector(null,1,(5),inst_56225,inst_56226,null));
var inst_56228 = ["query",inst_56227,inst_56221];
var inst_56229 = cljs.core.PersistentHashMap.fromArrays(inst_56224,inst_56228);
var inst_56230 = [inst_56229,inst_56222];
var inst_56231 = (new cljs.core.PersistentVector(null,2,(5),inst_56223,inst_56230,null));
var inst_56232 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56231);
var _ = (function (){var statearr_56242 = state_56237;
(statearr_56242[(4)] = cljs.core.rest((state_56237[(4)])));

return statearr_56242;
})();
var state_56237__$1 = (function (){var statearr_56243 = state_56237;
(statearr_56243[(8)] = inst_56232);

return statearr_56243;
})();
var statearr_56244_56379 = state_56237__$1;
(statearr_56244_56379[(2)] = inst_56221);

(statearr_56244_56379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56238 === (6))){
var state_56237__$1 = state_56237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56237__$1,(9),query_map);
} else {
if((state_val_56238 === (3))){
var inst_56235 = (state_56237[(2)]);
var state_56237__$1 = state_56237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56237__$1,inst_56235);
} else {
if((state_val_56238 === (12))){
var inst_56215 = (state_56237[(7)]);
var inst_56215__$1 = (state_56237[(2)]);
var inst_56216 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56217 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56216,inst_56215__$1);
var state_56237__$1 = (function (){var statearr_56245 = state_56237;
(statearr_56245[(7)] = inst_56215__$1);

return statearr_56245;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56237__$1,(13),inst_56217);
} else {
if((state_val_56238 === (2))){
var _ = (function (){var statearr_56246 = state_56237;
(statearr_56246[(4)] = cljs.core.cons((5),(state_56237[(4)])));

return statearr_56246;
})();
var inst_56202 = fluree.db.util.async.channel_QMARK_(query_map);
var state_56237__$1 = state_56237;
if(inst_56202){
var statearr_56247_56380 = state_56237__$1;
(statearr_56247_56380[(1)] = (6));

} else {
var statearr_56248_56381 = state_56237__$1;
(statearr_56248_56381[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56238 === (11))){
var inst_56209 = (state_56237[(9)]);
var state_56237__$1 = state_56237;
var statearr_56250_56382 = state_56237__$1;
(statearr_56250_56382[(2)] = inst_56209);

(statearr_56250_56382[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56238 === (9))){
var inst_56205 = (state_56237[(2)]);
var inst_56206 = fluree.db.util.async.throw_err(inst_56205);
var state_56237__$1 = state_56237;
var statearr_56251_56383 = state_56237__$1;
(statearr_56251_56383[(2)] = inst_56206);

(statearr_56251_56383[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56238 === (5))){
var _ = (function (){var statearr_56252 = state_56237;
(statearr_56252[(4)] = cljs.core.rest((state_56237[(4)])));

return statearr_56252;
})();
var state_56237__$1 = state_56237;
var ex56249 = (state_56237__$1[(2)]);
var statearr_56253_56384 = state_56237__$1;
(statearr_56253_56384[(5)] = ex56249);


if((ex56249 instanceof Error)){
var statearr_56254_56385 = state_56237__$1;
(statearr_56254_56385[(1)] = (4));

(statearr_56254_56385[(5)] = null);

} else {
throw ex56249;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56238 === (10))){
var inst_56209 = (state_56237[(9)]);
var inst_56212 = fluree.db.util.json.parse(inst_56209);
var state_56237__$1 = state_56237;
var statearr_56255_56386 = state_56237__$1;
(statearr_56255_56386[(2)] = inst_56212);

(statearr_56255_56386[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56238 === (8))){
var inst_56209 = (state_56237[(9)]);
var inst_56209__$1 = (state_56237[(2)]);
var inst_56210 = typeof inst_56209__$1 === 'string';
var state_56237__$1 = (function (){var statearr_56256 = state_56237;
(statearr_56256[(9)] = inst_56209__$1);

return statearr_56256;
})();
if(cljs.core.truth_(inst_56210)){
var statearr_56257_56387 = state_56237__$1;
(statearr_56257_56387[(1)] = (10));

} else {
var statearr_56258_56388 = state_56237__$1;
(statearr_56258_56388[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56259 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56259[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56259[(1)] = (1));

return statearr_56259;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56237){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56237);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56260){var ex__2730__auto__ = e56260;
var statearr_56261_56389 = state_56237;
(statearr_56261_56389[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56237[(4)]))){
var statearr_56262_56390 = state_56237;
(statearr_56262_56390[(1)] = cljs.core.first((state_56237[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56391 = state_56237;
state_56237 = G__56391;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56237){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56263 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56263[(6)] = c__2749__auto__);

return statearr_56263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56334){
var state_val_56335 = (state_56334[(1)]);
if((state_val_56335 === (7))){
var state_56334__$1 = state_56334;
var statearr_56336_56392 = state_56334__$1;
(statearr_56336_56392[(2)] = select);

(statearr_56336_56392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (20))){
var inst_56304 = (state_56334[(2)]);
var inst_56305 = fluree.db.util.async.channel_QMARK_(limit);
var state_56334__$1 = (function (){var statearr_56337 = state_56334;
(statearr_56337[(7)] = inst_56304);

return statearr_56337;
})();
if(inst_56305){
var statearr_56338_56393 = state_56334__$1;
(statearr_56338_56393[(1)] = (22));

} else {
var statearr_56339_56394 = state_56334__$1;
(statearr_56339_56394[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (1))){
var state_56334__$1 = state_56334;
var statearr_56340_56395 = state_56334__$1;
(statearr_56340_56395[(2)] = null);

(statearr_56340_56395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (24))){
var inst_56304 = (state_56334[(7)]);
var inst_56296 = (state_56334[(8)]);
var inst_56288 = (state_56334[(9)]);
var inst_56280 = (state_56334[(10)]);
var inst_56312 = (state_56334[(2)]);
var inst_56313 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56314 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_56313,inst_56280,inst_56288,inst_56296,inst_56304,inst_56312);
var state_56334__$1 = state_56334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56334__$1,(26),inst_56314);
} else {
if((state_val_56335 === (4))){
var inst_56264 = (state_56334[(2)]);
var state_56334__$1 = state_56334;
var statearr_56341_56396 = state_56334__$1;
(statearr_56341_56396[(2)] = inst_56264);

(statearr_56341_56396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (15))){
var state_56334__$1 = state_56334;
var statearr_56342_56397 = state_56334__$1;
(statearr_56342_56397[(2)] = where);

(statearr_56342_56397[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (21))){
var inst_56300 = (state_56334[(2)]);
var inst_56301 = fluree.db.util.async.throw_err(inst_56300);
var state_56334__$1 = state_56334;
var statearr_56343_56398 = state_56334__$1;
(statearr_56343_56398[(2)] = inst_56301);

(statearr_56343_56398[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (13))){
var inst_56284 = (state_56334[(2)]);
var inst_56285 = fluree.db.util.async.throw_err(inst_56284);
var state_56334__$1 = state_56334;
var statearr_56344_56399 = state_56334__$1;
(statearr_56344_56399[(2)] = inst_56285);

(statearr_56344_56399[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (22))){
var state_56334__$1 = state_56334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56334__$1,(25),limit);
} else {
if((state_val_56335 === (6))){
var state_56334__$1 = state_56334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56334__$1,(9),select);
} else {
if((state_val_56335 === (25))){
var inst_56308 = (state_56334[(2)]);
var inst_56309 = fluree.db.util.async.throw_err(inst_56308);
var state_56334__$1 = state_56334;
var statearr_56345_56400 = state_56334__$1;
(statearr_56345_56400[(2)] = inst_56309);

(statearr_56345_56400[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (17))){
var inst_56292 = (state_56334[(2)]);
var inst_56293 = fluree.db.util.async.throw_err(inst_56292);
var state_56334__$1 = state_56334;
var statearr_56346_56401 = state_56334__$1;
(statearr_56346_56401[(2)] = inst_56293);

(statearr_56346_56401[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (3))){
var inst_56332 = (state_56334[(2)]);
var state_56334__$1 = state_56334;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56334__$1,inst_56332);
} else {
if((state_val_56335 === (12))){
var inst_56288 = (state_56334[(2)]);
var inst_56289 = fluree.db.util.async.channel_QMARK_(where);
var state_56334__$1 = (function (){var statearr_56347 = state_56334;
(statearr_56347[(9)] = inst_56288);

return statearr_56347;
})();
if(inst_56289){
var statearr_56348_56402 = state_56334__$1;
(statearr_56348_56402[(1)] = (14));

} else {
var statearr_56349_56403 = state_56334__$1;
(statearr_56349_56403[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (2))){
var _ = (function (){var statearr_56350 = state_56334;
(statearr_56350[(4)] = cljs.core.cons((5),(state_56334[(4)])));

return statearr_56350;
})();
var inst_56273 = fluree.db.util.async.channel_QMARK_(select);
var state_56334__$1 = state_56334;
if(inst_56273){
var statearr_56351_56404 = state_56334__$1;
(statearr_56351_56404[(1)] = (6));

} else {
var statearr_56352_56405 = state_56334__$1;
(statearr_56352_56405[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (23))){
var state_56334__$1 = state_56334;
var statearr_56353_56406 = state_56334__$1;
(statearr_56353_56406[(2)] = limit);

(statearr_56353_56406[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (19))){
var state_56334__$1 = state_56334;
var statearr_56354_56407 = state_56334__$1;
(statearr_56354_56407[(2)] = block);

(statearr_56354_56407[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (11))){
var state_56334__$1 = state_56334;
var statearr_56356_56408 = state_56334__$1;
(statearr_56356_56408[(2)] = from);

(statearr_56356_56408[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (9))){
var inst_56276 = (state_56334[(2)]);
var inst_56277 = fluree.db.util.async.throw_err(inst_56276);
var state_56334__$1 = state_56334;
var statearr_56357_56409 = state_56334__$1;
(statearr_56357_56409[(2)] = inst_56277);

(statearr_56357_56409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (5))){
var _ = (function (){var statearr_56358 = state_56334;
(statearr_56358[(4)] = cljs.core.rest((state_56334[(4)])));

return statearr_56358;
})();
var state_56334__$1 = state_56334;
var ex56355 = (state_56334__$1[(2)]);
var statearr_56359_56410 = state_56334__$1;
(statearr_56359_56410[(5)] = ex56355);


if((ex56355 instanceof Error)){
var statearr_56360_56411 = state_56334__$1;
(statearr_56360_56411[(1)] = (4));

(statearr_56360_56411[(5)] = null);

} else {
throw ex56355;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (14))){
var state_56334__$1 = state_56334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56334__$1,(17),where);
} else {
if((state_val_56335 === (26))){
var inst_56304 = (state_56334[(7)]);
var inst_56296 = (state_56334[(8)]);
var inst_56288 = (state_56334[(9)]);
var inst_56280 = (state_56334[(10)]);
var inst_56316 = (state_56334[(2)]);
var inst_56317 = fluree.db.util.async.throw_err(inst_56316);
var inst_56318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56317,(0),null);
var inst_56319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56317,(1),null);
var inst_56320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56321 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56323 = [inst_56280,inst_56288,inst_56296,inst_56304];
var inst_56324 = (new cljs.core.PersistentVector(null,4,(5),inst_56322,inst_56323,null));
var inst_56325 = ["query",inst_56324,inst_56318];
var inst_56326 = cljs.core.PersistentHashMap.fromArrays(inst_56321,inst_56325);
var inst_56327 = [inst_56326,inst_56319];
var inst_56328 = (new cljs.core.PersistentVector(null,2,(5),inst_56320,inst_56327,null));
var inst_56329 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56328);
var _ = (function (){var statearr_56361 = state_56334;
(statearr_56361[(4)] = cljs.core.rest((state_56334[(4)])));

return statearr_56361;
})();
var state_56334__$1 = (function (){var statearr_56362 = state_56334;
(statearr_56362[(11)] = inst_56329);

return statearr_56362;
})();
var statearr_56363_56412 = state_56334__$1;
(statearr_56363_56412[(2)] = inst_56318);

(statearr_56363_56412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (16))){
var inst_56296 = (state_56334[(2)]);
var inst_56297 = fluree.db.util.async.channel_QMARK_(block);
var state_56334__$1 = (function (){var statearr_56364 = state_56334;
(statearr_56364[(8)] = inst_56296);

return statearr_56364;
})();
if(inst_56297){
var statearr_56365_56413 = state_56334__$1;
(statearr_56365_56413[(1)] = (18));

} else {
var statearr_56366_56414 = state_56334__$1;
(statearr_56366_56414[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (10))){
var state_56334__$1 = state_56334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56334__$1,(13),from);
} else {
if((state_val_56335 === (18))){
var state_56334__$1 = state_56334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56334__$1,(21),block);
} else {
if((state_val_56335 === (8))){
var inst_56280 = (state_56334[(2)]);
var inst_56281 = fluree.db.util.async.channel_QMARK_(from);
var state_56334__$1 = (function (){var statearr_56367 = state_56334;
(statearr_56367[(10)] = inst_56280);

return statearr_56367;
})();
if(inst_56281){
var statearr_56368_56415 = state_56334__$1;
(statearr_56368_56415[(1)] = (10));

} else {
var statearr_56369_56416 = state_56334__$1;
(statearr_56369_56416[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56370 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56370[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56370[(1)] = (1));

return statearr_56370;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56334){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56334);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56371){var ex__2730__auto__ = e56371;
var statearr_56372_56417 = state_56334;
(statearr_56372_56417[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56334[(4)]))){
var statearr_56373_56418 = state_56334;
(statearr_56373_56418[(1)] = cljs.core.first((state_56334[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56419 = state_56334;
state_56334 = G__56419;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56334){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56374 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56374[(6)] = c__2749__auto__);

return statearr_56374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56475){
var state_val_56476 = (state_56475[(1)]);
if((state_val_56476 === (7))){
var state_56475__$1 = state_56475;
var statearr_56477_56508 = state_56475__$1;
(statearr_56477_56508[(2)] = startSubject);

(statearr_56477_56508[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (1))){
var state_56475__$1 = state_56475;
var statearr_56478_56509 = state_56475__$1;
(statearr_56478_56509[(2)] = null);

(statearr_56478_56509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (4))){
var inst_56420 = (state_56475[(2)]);
var state_56475__$1 = state_56475;
var statearr_56479_56510 = state_56475__$1;
(statearr_56479_56510[(2)] = inst_56420);

(statearr_56479_56510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (15))){
var inst_56452 = (state_56475[(2)]);
var inst_56453 = fluree.db.util.async.throw_err(inst_56452);
var inst_56454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56453,(0),null);
var inst_56455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56453,(1),null);
var inst_56456 = cljs.core.empty_QMARK_(inst_56454);
var state_56475__$1 = (function (){var statearr_56480 = state_56475;
(statearr_56480[(7)] = inst_56455);

return statearr_56480;
})();
if(inst_56456){
var statearr_56481_56511 = state_56475__$1;
(statearr_56481_56511[(1)] = (16));

} else {
var statearr_56482_56512 = state_56475__$1;
(statearr_56482_56512[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (13))){
var inst_56436 = (state_56475[(8)]);
var inst_56440 = (state_56475[(9)]);
var inst_56448 = (state_56475[(10)]);
var inst_56448__$1 = (state_56475[(2)]);
var inst_56449 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56450 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_56449,inst_56436,inst_56440,inst_56448__$1);
var state_56475__$1 = (function (){var statearr_56483 = state_56475;
(statearr_56483[(10)] = inst_56448__$1);

return statearr_56483;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56475__$1,(15),inst_56450);
} else {
if((state_val_56476 === (6))){
var state_56475__$1 = state_56475;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56475__$1,(9),startSubject);
} else {
if((state_val_56476 === (17))){
var state_56475__$1 = state_56475;
var statearr_56484_56513 = state_56475__$1;
(statearr_56484_56513[(2)] = true);

(statearr_56484_56513[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (3))){
var inst_56473 = (state_56475[(2)]);
var state_56475__$1 = state_56475;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56475__$1,inst_56473);
} else {
if((state_val_56476 === (12))){
var state_56475__$1 = state_56475;
var statearr_56485_56514 = state_56475__$1;
(statearr_56485_56514[(2)] = endSubject);

(statearr_56485_56514[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (2))){
var _ = (function (){var statearr_56486 = state_56475;
(statearr_56486[(4)] = cljs.core.cons((5),(state_56475[(4)])));

return statearr_56486;
})();
var inst_56429 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_56475__$1 = state_56475;
if(inst_56429){
var statearr_56487_56515 = state_56475__$1;
(statearr_56487_56515[(1)] = (6));

} else {
var statearr_56488_56516 = state_56475__$1;
(statearr_56488_56516[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (11))){
var state_56475__$1 = state_56475;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56475__$1,(14),endSubject);
} else {
if((state_val_56476 === (9))){
var inst_56432 = (state_56475[(2)]);
var inst_56433 = fluree.db.util.async.throw_err(inst_56432);
var state_56475__$1 = state_56475;
var statearr_56490_56517 = state_56475__$1;
(statearr_56490_56517[(2)] = inst_56433);

(statearr_56490_56517[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (5))){
var _ = (function (){var statearr_56491 = state_56475;
(statearr_56491[(4)] = cljs.core.rest((state_56475[(4)])));

return statearr_56491;
})();
var state_56475__$1 = state_56475;
var ex56489 = (state_56475__$1[(2)]);
var statearr_56492_56518 = state_56475__$1;
(statearr_56492_56518[(5)] = ex56489);


if((ex56489 instanceof Error)){
var statearr_56493_56519 = state_56475__$1;
(statearr_56493_56519[(1)] = (4));

(statearr_56493_56519[(5)] = null);

} else {
throw ex56489;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (14))){
var inst_56444 = (state_56475[(2)]);
var inst_56445 = fluree.db.util.async.throw_err(inst_56444);
var state_56475__$1 = state_56475;
var statearr_56494_56520 = state_56475__$1;
(statearr_56494_56520[(2)] = inst_56445);

(statearr_56494_56520[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (16))){
var state_56475__$1 = state_56475;
var statearr_56495_56521 = state_56475__$1;
(statearr_56495_56521[(2)] = false);

(statearr_56495_56521[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (10))){
var inst_56439 = (state_56475[(2)]);
var inst_56440 = fluree.db.util.async.throw_err(inst_56439);
var inst_56441 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_56475__$1 = (function (){var statearr_56496 = state_56475;
(statearr_56496[(9)] = inst_56440);

return statearr_56496;
})();
if(inst_56441){
var statearr_56497_56522 = state_56475__$1;
(statearr_56497_56522[(1)] = (11));

} else {
var statearr_56498_56523 = state_56475__$1;
(statearr_56498_56523[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (18))){
var inst_56436 = (state_56475[(8)]);
var inst_56440 = (state_56475[(9)]);
var inst_56455 = (state_56475[(7)]);
var inst_56448 = (state_56475[(10)]);
var inst_56460 = (state_56475[(2)]);
var inst_56461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56462 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56464 = [inst_56436,inst_56440,inst_56448];
var inst_56465 = (new cljs.core.PersistentVector(null,3,(5),inst_56463,inst_56464,null));
var inst_56466 = ["relationship?",inst_56465,inst_56460];
var inst_56467 = cljs.core.PersistentHashMap.fromArrays(inst_56462,inst_56466);
var inst_56468 = [inst_56467,inst_56455];
var inst_56469 = (new cljs.core.PersistentVector(null,2,(5),inst_56461,inst_56468,null));
var inst_56470 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56469);
var _ = (function (){var statearr_56499 = state_56475;
(statearr_56499[(4)] = cljs.core.rest((state_56475[(4)])));

return statearr_56499;
})();
var state_56475__$1 = (function (){var statearr_56500 = state_56475;
(statearr_56500[(11)] = inst_56470);

return statearr_56500;
})();
var statearr_56501_56524 = state_56475__$1;
(statearr_56501_56524[(2)] = inst_56460);

(statearr_56501_56524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56476 === (8))){
var inst_56436 = (state_56475[(2)]);
var inst_56437 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_56475__$1 = (function (){var statearr_56502 = state_56475;
(statearr_56502[(8)] = inst_56436);

return statearr_56502;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56475__$1,(10),inst_56437);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_56503 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56503[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_56503[(1)] = (1));

return statearr_56503;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_56475){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56475);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56504){var ex__2730__auto__ = e56504;
var statearr_56505_56525 = state_56475;
(statearr_56505_56525[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56475[(4)]))){
var statearr_56506_56526 = state_56475;
(statearr_56506_56526[(1)] = cljs.core.first((state_56475[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56527 = state_56475;
state_56475 = G__56527;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = function(state_56475){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_56475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56507 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56507[(6)] = c__2749__auto__);

return statearr_56507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56564){
var state_val_56565 = (state_56564[(1)]);
if((state_val_56565 === (7))){
var state_56564__$1 = state_56564;
var statearr_56566_56586 = state_56564__$1;
(statearr_56566_56586[(2)] = pred_name);

(statearr_56566_56586[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56565 === (1))){
var state_56564__$1 = state_56564;
var statearr_56567_56587 = state_56564__$1;
(statearr_56567_56587[(2)] = null);

(statearr_56567_56587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56565 === (4))){
var inst_56528 = (state_56564[(2)]);
var state_56564__$1 = state_56564;
var statearr_56568_56588 = state_56564__$1;
(statearr_56568_56588[(2)] = inst_56528);

(statearr_56568_56588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56565 === (6))){
var state_56564__$1 = state_56564;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56564__$1,(9),pred_name);
} else {
if((state_val_56565 === (3))){
var inst_56562 = (state_56564[(2)]);
var state_56564__$1 = state_56564;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56564__$1,inst_56562);
} else {
if((state_val_56565 === (2))){
var _ = (function (){var statearr_56570 = state_56564;
(statearr_56570[(4)] = cljs.core.cons((5),(state_56564[(4)])));

return statearr_56570;
})();
var inst_56537 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_56564__$1 = state_56564;
if(inst_56537){
var statearr_56571_56589 = state_56564__$1;
(statearr_56571_56589[(1)] = (6));

} else {
var statearr_56572_56590 = state_56564__$1;
(statearr_56572_56590[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56565 === (9))){
var inst_56540 = (state_56564[(2)]);
var inst_56541 = fluree.db.util.async.throw_err(inst_56540);
var state_56564__$1 = state_56564;
var statearr_56573_56591 = state_56564__$1;
(statearr_56573_56591[(2)] = inst_56541);

(statearr_56573_56591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56565 === (5))){
var _ = (function (){var statearr_56574 = state_56564;
(statearr_56574[(4)] = cljs.core.rest((state_56564[(4)])));

return statearr_56574;
})();
var state_56564__$1 = state_56564;
var ex56569 = (state_56564__$1[(2)]);
var statearr_56575_56592 = state_56564__$1;
(statearr_56575_56592[(5)] = ex56569);


if((ex56569 instanceof Error)){
var statearr_56576_56593 = state_56564__$1;
(statearr_56576_56593[(1)] = (4));

(statearr_56576_56593[(5)] = null);

} else {
throw ex56569;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56565 === (10))){
var inst_56544 = (state_56564[(7)]);
var inst_56548 = (state_56564[(2)]);
var inst_56549 = fluree.db.util.async.throw_err(inst_56548);
var inst_56550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56549,(0),null);
var inst_56551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56549,(1),null);
var inst_56552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56553 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56554 = ["max-pred-val",inst_56544,inst_56550];
var inst_56555 = cljs.core.PersistentHashMap.fromArrays(inst_56553,inst_56554);
var inst_56556 = (inst_56551 + (10));
var inst_56557 = [inst_56555,inst_56556];
var inst_56558 = (new cljs.core.PersistentVector(null,2,(5),inst_56552,inst_56557,null));
var inst_56559 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56558);
var _ = (function (){var statearr_56577 = state_56564;
(statearr_56577[(4)] = cljs.core.rest((state_56564[(4)])));

return statearr_56577;
})();
var state_56564__$1 = (function (){var statearr_56578 = state_56564;
(statearr_56578[(8)] = inst_56559);

return statearr_56578;
})();
var statearr_56579_56594 = state_56564__$1;
(statearr_56579_56594[(2)] = inst_56550);

(statearr_56579_56594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56565 === (8))){
var inst_56544 = (state_56564[(7)]);
var inst_56544__$1 = (state_56564[(2)]);
var inst_56545 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56546 = fluree.db.dbfunctions.internal.max_pred_val(inst_56545,inst_56544__$1,null);
var state_56564__$1 = (function (){var statearr_56580 = state_56564;
(statearr_56580[(7)] = inst_56544__$1);

return statearr_56580;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56564__$1,(10),inst_56546);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_56581 = [null,null,null,null,null,null,null,null,null];
(statearr_56581[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__);

(statearr_56581[(1)] = (1));

return statearr_56581;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1 = (function (state_56564){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56564);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56582){var ex__2730__auto__ = e56582;
var statearr_56583_56595 = state_56564;
(statearr_56583_56595[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56564[(4)]))){
var statearr_56584_56596 = state_56564;
(statearr_56584_56596[(1)] = cljs.core.first((state_56564[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56597 = state_56564;
state_56564 = G__56597;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = function(state_56564){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1.call(this,state_56564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56585 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56585[(6)] = c__2749__auto__);

return statearr_56585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56624){
var state_val_56625 = (state_56624[(1)]);
if((state_val_56625 === (7))){
var state_56624__$1 = state_56624;
var statearr_56626_56645 = state_56624__$1;
(statearr_56626_56645[(2)] = n);

(statearr_56626_56645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56625 === (1))){
var state_56624__$1 = state_56624;
var statearr_56627_56646 = state_56624__$1;
(statearr_56627_56646[(2)] = null);

(statearr_56627_56646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56625 === (4))){
var inst_56598 = (state_56624[(2)]);
var state_56624__$1 = state_56624;
var statearr_56628_56647 = state_56624__$1;
(statearr_56628_56647[(2)] = inst_56598);

(statearr_56628_56647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56625 === (6))){
var state_56624__$1 = state_56624;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56624__$1,(9),n);
} else {
if((state_val_56625 === (3))){
var inst_56622 = (state_56624[(2)]);
var state_56624__$1 = state_56624;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56624__$1,inst_56622);
} else {
if((state_val_56625 === (2))){
var _ = (function (){var statearr_56630 = state_56624;
(statearr_56630[(4)] = cljs.core.cons((5),(state_56624[(4)])));

return statearr_56630;
})();
var inst_56604 = fluree.db.util.async.channel_QMARK_(n);
var state_56624__$1 = state_56624;
if(inst_56604){
var statearr_56631_56648 = state_56624__$1;
(statearr_56631_56648[(1)] = (6));

} else {
var statearr_56632_56649 = state_56624__$1;
(statearr_56632_56649[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56625 === (9))){
var inst_56607 = (state_56624[(2)]);
var inst_56608 = fluree.db.util.async.throw_err(inst_56607);
var state_56624__$1 = state_56624;
var statearr_56633_56650 = state_56624__$1;
(statearr_56633_56650[(2)] = inst_56608);

(statearr_56633_56650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56625 === (5))){
var _ = (function (){var statearr_56634 = state_56624;
(statearr_56634[(4)] = cljs.core.rest((state_56624[(4)])));

return statearr_56634;
})();
var state_56624__$1 = state_56624;
var ex56629 = (state_56624__$1[(2)]);
var statearr_56635_56651 = state_56624__$1;
(statearr_56635_56651[(5)] = ex56629);


if((ex56629 instanceof Error)){
var statearr_56636_56652 = state_56624__$1;
(statearr_56636_56652[(1)] = (4));

(statearr_56636_56652[(5)] = null);

} else {
throw ex56629;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56625 === (8))){
var inst_56611 = (state_56624[(2)]);
var inst_56612 = fluree.db.dbfunctions.internal.inc(inst_56611);
var inst_56613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56614 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56615 = ["inc",inst_56611,inst_56612];
var inst_56616 = cljs.core.PersistentHashMap.fromArrays(inst_56614,inst_56615);
var inst_56617 = [inst_56616,(10)];
var inst_56618 = (new cljs.core.PersistentVector(null,2,(5),inst_56613,inst_56617,null));
var inst_56619 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56618);
var _ = (function (){var statearr_56637 = state_56624;
(statearr_56637[(4)] = cljs.core.rest((state_56624[(4)])));

return statearr_56637;
})();
var state_56624__$1 = (function (){var statearr_56638 = state_56624;
(statearr_56638[(7)] = inst_56619);

return statearr_56638;
})();
var statearr_56639_56653 = state_56624__$1;
(statearr_56639_56653[(2)] = inst_56612);

(statearr_56639_56653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0 = (function (){
var statearr_56640 = [null,null,null,null,null,null,null,null];
(statearr_56640[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__);

(statearr_56640[(1)] = (1));

return statearr_56640;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1 = (function (state_56624){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56624);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56641){var ex__2730__auto__ = e56641;
var statearr_56642_56654 = state_56624;
(statearr_56642_56654[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56624[(4)]))){
var statearr_56643_56655 = state_56624;
(statearr_56643_56655[(1)] = cljs.core.first((state_56624[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56656 = state_56624;
state_56624 = G__56656;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = function(state_56624){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1.call(this,state_56624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56644 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56644[(6)] = c__2749__auto__);

return statearr_56644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56683){
var state_val_56684 = (state_56683[(1)]);
if((state_val_56684 === (7))){
var state_56683__$1 = state_56683;
var statearr_56685_56704 = state_56683__$1;
(statearr_56685_56704[(2)] = n);

(statearr_56685_56704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56684 === (1))){
var state_56683__$1 = state_56683;
var statearr_56686_56705 = state_56683__$1;
(statearr_56686_56705[(2)] = null);

(statearr_56686_56705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56684 === (4))){
var inst_56657 = (state_56683[(2)]);
var state_56683__$1 = state_56683;
var statearr_56687_56706 = state_56683__$1;
(statearr_56687_56706[(2)] = inst_56657);

(statearr_56687_56706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56684 === (6))){
var state_56683__$1 = state_56683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56683__$1,(9),n);
} else {
if((state_val_56684 === (3))){
var inst_56681 = (state_56683[(2)]);
var state_56683__$1 = state_56683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56683__$1,inst_56681);
} else {
if((state_val_56684 === (2))){
var _ = (function (){var statearr_56689 = state_56683;
(statearr_56689[(4)] = cljs.core.cons((5),(state_56683[(4)])));

return statearr_56689;
})();
var inst_56663 = fluree.db.util.async.channel_QMARK_(n);
var state_56683__$1 = state_56683;
if(inst_56663){
var statearr_56690_56707 = state_56683__$1;
(statearr_56690_56707[(1)] = (6));

} else {
var statearr_56691_56708 = state_56683__$1;
(statearr_56691_56708[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56684 === (9))){
var inst_56666 = (state_56683[(2)]);
var inst_56667 = fluree.db.util.async.throw_err(inst_56666);
var state_56683__$1 = state_56683;
var statearr_56692_56709 = state_56683__$1;
(statearr_56692_56709[(2)] = inst_56667);

(statearr_56692_56709[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56684 === (5))){
var _ = (function (){var statearr_56693 = state_56683;
(statearr_56693[(4)] = cljs.core.rest((state_56683[(4)])));

return statearr_56693;
})();
var state_56683__$1 = state_56683;
var ex56688 = (state_56683__$1[(2)]);
var statearr_56694_56710 = state_56683__$1;
(statearr_56694_56710[(5)] = ex56688);


if((ex56688 instanceof Error)){
var statearr_56695_56711 = state_56683__$1;
(statearr_56695_56711[(1)] = (4));

(statearr_56695_56711[(5)] = null);

} else {
throw ex56688;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56684 === (8))){
var inst_56670 = (state_56683[(2)]);
var inst_56671 = fluree.db.dbfunctions.internal.dec(inst_56670);
var inst_56672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56673 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56674 = ["dec",inst_56670,inst_56671];
var inst_56675 = cljs.core.PersistentHashMap.fromArrays(inst_56673,inst_56674);
var inst_56676 = [inst_56675,(10)];
var inst_56677 = (new cljs.core.PersistentVector(null,2,(5),inst_56672,inst_56676,null));
var inst_56678 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56677);
var _ = (function (){var statearr_56696 = state_56683;
(statearr_56696[(4)] = cljs.core.rest((state_56683[(4)])));

return statearr_56696;
})();
var state_56683__$1 = (function (){var statearr_56697 = state_56683;
(statearr_56697[(7)] = inst_56678);

return statearr_56697;
})();
var statearr_56698_56712 = state_56683__$1;
(statearr_56698_56712[(2)] = inst_56671);

(statearr_56698_56712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0 = (function (){
var statearr_56699 = [null,null,null,null,null,null,null,null];
(statearr_56699[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__);

(statearr_56699[(1)] = (1));

return statearr_56699;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1 = (function (state_56683){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56683);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56700){var ex__2730__auto__ = e56700;
var statearr_56701_56713 = state_56683;
(statearr_56701_56713[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56683[(4)]))){
var statearr_56702_56714 = state_56683;
(statearr_56702_56714[(1)] = cljs.core.first((state_56683[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56715 = state_56683;
state_56683 = G__56715;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = function(state_56683){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1.call(this,state_56683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56703 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56703[(6)] = c__2749__auto__);

return statearr_56703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56765 = arguments.length;
var i__5770__auto___56766 = (0);
while(true){
if((i__5770__auto___56766 < len__5769__auto___56765)){
args__5775__auto__.push((arguments[i__5770__auto___56766]));

var G__56767 = (i__5770__auto___56766 + (1));
i__5770__auto___56766 = G__56767;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56748){
var state_val_56749 = (state_56748[(1)]);
if((state_val_56749 === (1))){
var state_56748__$1 = state_56748;
var statearr_56750_56768 = state_56748__$1;
(statearr_56750_56768[(2)] = null);

(statearr_56750_56768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56749 === (2))){
var _ = (function (){var statearr_56751 = state_56748;
(statearr_56751[(4)] = cljs.core.cons((5),(state_56748[(4)])));

return statearr_56751;
})();
var inst_56724 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56748__$1 = state_56748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56748__$1,(6),inst_56724);
} else {
if((state_val_56749 === (3))){
var inst_56746 = (state_56748[(2)]);
var state_56748__$1 = state_56748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56748__$1,inst_56746);
} else {
if((state_val_56749 === (4))){
var inst_56718 = (state_56748[(2)]);
var state_56748__$1 = state_56748;
var statearr_56753_56769 = state_56748__$1;
(statearr_56753_56769[(2)] = inst_56718);

(statearr_56753_56769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56749 === (5))){
var _ = (function (){var statearr_56754 = state_56748;
(statearr_56754[(4)] = cljs.core.rest((state_56748[(4)])));

return statearr_56754;
})();
var state_56748__$1 = state_56748;
var ex56752 = (state_56748__$1[(2)]);
var statearr_56755_56770 = state_56748__$1;
(statearr_56755_56770[(5)] = ex56752);


if((ex56752 instanceof Error)){
var statearr_56756_56771 = state_56748__$1;
(statearr_56756_56771[(1)] = (4));

(statearr_56756_56771[(5)] = null);

} else {
throw ex56752;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56749 === (6))){
var inst_56726 = (state_56748[(2)]);
var inst_56727 = fluree.db.util.async.throw_err(inst_56726);
var inst_56728 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_56727);
var inst_56729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56730 = [inst_56727];
var inst_56731 = (new cljs.core.PersistentVector(null,1,(5),inst_56729,inst_56730,null));
var inst_56732 = cljs.core.count(inst_56731);
var inst_56733 = ((9) + inst_56732);
var inst_56734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56735 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56737 = [inst_56727];
var inst_56738 = (new cljs.core.PersistentVector(null,1,(5),inst_56736,inst_56737,null));
var inst_56739 = ["+",inst_56738,inst_56728];
var inst_56740 = cljs.core.PersistentHashMap.fromArrays(inst_56735,inst_56739);
var inst_56741 = [inst_56740,inst_56733];
var inst_56742 = (new cljs.core.PersistentVector(null,2,(5),inst_56734,inst_56741,null));
var inst_56743 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56742);
var _ = (function (){var statearr_56757 = state_56748;
(statearr_56757[(4)] = cljs.core.rest((state_56748[(4)])));

return statearr_56757;
})();
var state_56748__$1 = (function (){var statearr_56758 = state_56748;
(statearr_56758[(7)] = inst_56743);

return statearr_56758;
})();
var statearr_56759_56772 = state_56748__$1;
(statearr_56759_56772[(2)] = inst_56728);

(statearr_56759_56772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56760 = [null,null,null,null,null,null,null,null];
(statearr_56760[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56760[(1)] = (1));

return statearr_56760;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56748){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56748);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56761){var ex__2730__auto__ = e56761;
var statearr_56762_56773 = state_56748;
(statearr_56762_56773[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56748[(4)]))){
var statearr_56763_56774 = state_56748;
(statearr_56763_56774[(1)] = cljs.core.first((state_56748[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56775 = state_56748;
state_56748 = G__56775;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56748){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56764 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56764[(6)] = c__2749__auto__);

return statearr_56764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56716){
var G__56717 = cljs.core.first(seq56716);
var seq56716__$1 = cljs.core.next(seq56716);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56717,seq56716__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56825 = arguments.length;
var i__5770__auto___56826 = (0);
while(true){
if((i__5770__auto___56826 < len__5769__auto___56825)){
args__5775__auto__.push((arguments[i__5770__auto___56826]));

var G__56827 = (i__5770__auto___56826 + (1));
i__5770__auto___56826 = G__56827;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56808){
var state_val_56809 = (state_56808[(1)]);
if((state_val_56809 === (1))){
var state_56808__$1 = state_56808;
var statearr_56810_56828 = state_56808__$1;
(statearr_56810_56828[(2)] = null);

(statearr_56810_56828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (2))){
var _ = (function (){var statearr_56811 = state_56808;
(statearr_56811[(4)] = cljs.core.cons((5),(state_56808[(4)])));

return statearr_56811;
})();
var inst_56784 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56808__$1,(6),inst_56784);
} else {
if((state_val_56809 === (3))){
var inst_56806 = (state_56808[(2)]);
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56808__$1,inst_56806);
} else {
if((state_val_56809 === (4))){
var inst_56778 = (state_56808[(2)]);
var state_56808__$1 = state_56808;
var statearr_56813_56829 = state_56808__$1;
(statearr_56813_56829[(2)] = inst_56778);

(statearr_56813_56829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (5))){
var _ = (function (){var statearr_56814 = state_56808;
(statearr_56814[(4)] = cljs.core.rest((state_56808[(4)])));

return statearr_56814;
})();
var state_56808__$1 = state_56808;
var ex56812 = (state_56808__$1[(2)]);
var statearr_56815_56830 = state_56808__$1;
(statearr_56815_56830[(5)] = ex56812);


if((ex56812 instanceof Error)){
var statearr_56816_56831 = state_56808__$1;
(statearr_56816_56831[(1)] = (4));

(statearr_56816_56831[(5)] = null);

} else {
throw ex56812;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (6))){
var inst_56786 = (state_56808[(2)]);
var inst_56787 = fluree.db.util.async.throw_err(inst_56786);
var inst_56788 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_56787);
var inst_56789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56790 = [inst_56787];
var inst_56791 = (new cljs.core.PersistentVector(null,1,(5),inst_56789,inst_56790,null));
var inst_56792 = cljs.core.count(inst_56791);
var inst_56793 = ((9) + inst_56792);
var inst_56794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56795 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56797 = [inst_56787];
var inst_56798 = (new cljs.core.PersistentVector(null,1,(5),inst_56796,inst_56797,null));
var inst_56799 = ["-",inst_56798,inst_56788];
var inst_56800 = cljs.core.PersistentHashMap.fromArrays(inst_56795,inst_56799);
var inst_56801 = [inst_56800,inst_56793];
var inst_56802 = (new cljs.core.PersistentVector(null,2,(5),inst_56794,inst_56801,null));
var inst_56803 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56802);
var _ = (function (){var statearr_56817 = state_56808;
(statearr_56817[(4)] = cljs.core.rest((state_56808[(4)])));

return statearr_56817;
})();
var state_56808__$1 = (function (){var statearr_56818 = state_56808;
(statearr_56818[(7)] = inst_56803);

return statearr_56818;
})();
var statearr_56819_56832 = state_56808__$1;
(statearr_56819_56832[(2)] = inst_56788);

(statearr_56819_56832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56820 = [null,null,null,null,null,null,null,null];
(statearr_56820[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56820[(1)] = (1));

return statearr_56820;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56808){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56808);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56821){var ex__2730__auto__ = e56821;
var statearr_56822_56833 = state_56808;
(statearr_56822_56833[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56808[(4)]))){
var statearr_56823_56834 = state_56808;
(statearr_56823_56834[(1)] = cljs.core.first((state_56808[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56835 = state_56808;
state_56808 = G__56835;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56808){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56824 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56824[(6)] = c__2749__auto__);

return statearr_56824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56776){
var G__56777 = cljs.core.first(seq56776);
var seq56776__$1 = cljs.core.next(seq56776);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56777,seq56776__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56885 = arguments.length;
var i__5770__auto___56886 = (0);
while(true){
if((i__5770__auto___56886 < len__5769__auto___56885)){
args__5775__auto__.push((arguments[i__5770__auto___56886]));

var G__56887 = (i__5770__auto___56886 + (1));
i__5770__auto___56886 = G__56887;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56868){
var state_val_56869 = (state_56868[(1)]);
if((state_val_56869 === (1))){
var state_56868__$1 = state_56868;
var statearr_56870_56888 = state_56868__$1;
(statearr_56870_56888[(2)] = null);

(statearr_56870_56888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (2))){
var _ = (function (){var statearr_56871 = state_56868;
(statearr_56871[(4)] = cljs.core.cons((5),(state_56868[(4)])));

return statearr_56871;
})();
var inst_56844 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56868__$1 = state_56868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56868__$1,(6),inst_56844);
} else {
if((state_val_56869 === (3))){
var inst_56866 = (state_56868[(2)]);
var state_56868__$1 = state_56868;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56868__$1,inst_56866);
} else {
if((state_val_56869 === (4))){
var inst_56838 = (state_56868[(2)]);
var state_56868__$1 = state_56868;
var statearr_56873_56889 = state_56868__$1;
(statearr_56873_56889[(2)] = inst_56838);

(statearr_56873_56889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (5))){
var _ = (function (){var statearr_56874 = state_56868;
(statearr_56874[(4)] = cljs.core.rest((state_56868[(4)])));

return statearr_56874;
})();
var state_56868__$1 = state_56868;
var ex56872 = (state_56868__$1[(2)]);
var statearr_56875_56890 = state_56868__$1;
(statearr_56875_56890[(5)] = ex56872);


if((ex56872 instanceof Error)){
var statearr_56876_56891 = state_56868__$1;
(statearr_56876_56891[(1)] = (4));

(statearr_56876_56891[(5)] = null);

} else {
throw ex56872;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (6))){
var inst_56846 = (state_56868[(2)]);
var inst_56847 = fluree.db.util.async.throw_err(inst_56846);
var inst_56848 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_56847);
var inst_56849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56850 = [inst_56847];
var inst_56851 = (new cljs.core.PersistentVector(null,1,(5),inst_56849,inst_56850,null));
var inst_56852 = cljs.core.count(inst_56851);
var inst_56853 = ((9) + inst_56852);
var inst_56854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56855 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56857 = [inst_56847];
var inst_56858 = (new cljs.core.PersistentVector(null,1,(5),inst_56856,inst_56857,null));
var inst_56859 = ["*",inst_56858,inst_56848];
var inst_56860 = cljs.core.PersistentHashMap.fromArrays(inst_56855,inst_56859);
var inst_56861 = [inst_56860,inst_56853];
var inst_56862 = (new cljs.core.PersistentVector(null,2,(5),inst_56854,inst_56861,null));
var inst_56863 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56862);
var _ = (function (){var statearr_56877 = state_56868;
(statearr_56877[(4)] = cljs.core.rest((state_56868[(4)])));

return statearr_56877;
})();
var state_56868__$1 = (function (){var statearr_56878 = state_56868;
(statearr_56878[(7)] = inst_56863);

return statearr_56878;
})();
var statearr_56879_56892 = state_56868__$1;
(statearr_56879_56892[(2)] = inst_56848);

(statearr_56879_56892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56880 = [null,null,null,null,null,null,null,null];
(statearr_56880[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56880[(1)] = (1));

return statearr_56880;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56868){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56868);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56881){var ex__2730__auto__ = e56881;
var statearr_56882_56893 = state_56868;
(statearr_56882_56893[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56868[(4)]))){
var statearr_56883_56894 = state_56868;
(statearr_56883_56894[(1)] = cljs.core.first((state_56868[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56895 = state_56868;
state_56868 = G__56895;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56868){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56884 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56884[(6)] = c__2749__auto__);

return statearr_56884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56836){
var G__56837 = cljs.core.first(seq56836);
var seq56836__$1 = cljs.core.next(seq56836);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56837,seq56836__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56945 = arguments.length;
var i__5770__auto___56946 = (0);
while(true){
if((i__5770__auto___56946 < len__5769__auto___56945)){
args__5775__auto__.push((arguments[i__5770__auto___56946]));

var G__56947 = (i__5770__auto___56946 + (1));
i__5770__auto___56946 = G__56947;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56928){
var state_val_56929 = (state_56928[(1)]);
if((state_val_56929 === (1))){
var state_56928__$1 = state_56928;
var statearr_56930_56948 = state_56928__$1;
(statearr_56930_56948[(2)] = null);

(statearr_56930_56948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56929 === (2))){
var _ = (function (){var statearr_56931 = state_56928;
(statearr_56931[(4)] = cljs.core.cons((5),(state_56928[(4)])));

return statearr_56931;
})();
var inst_56904 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56928__$1 = state_56928;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56928__$1,(6),inst_56904);
} else {
if((state_val_56929 === (3))){
var inst_56926 = (state_56928[(2)]);
var state_56928__$1 = state_56928;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56928__$1,inst_56926);
} else {
if((state_val_56929 === (4))){
var inst_56898 = (state_56928[(2)]);
var state_56928__$1 = state_56928;
var statearr_56933_56949 = state_56928__$1;
(statearr_56933_56949[(2)] = inst_56898);

(statearr_56933_56949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56929 === (5))){
var _ = (function (){var statearr_56934 = state_56928;
(statearr_56934[(4)] = cljs.core.rest((state_56928[(4)])));

return statearr_56934;
})();
var state_56928__$1 = state_56928;
var ex56932 = (state_56928__$1[(2)]);
var statearr_56935_56950 = state_56928__$1;
(statearr_56935_56950[(5)] = ex56932);


if((ex56932 instanceof Error)){
var statearr_56936_56951 = state_56928__$1;
(statearr_56936_56951[(1)] = (4));

(statearr_56936_56951[(5)] = null);

} else {
throw ex56932;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56929 === (6))){
var inst_56906 = (state_56928[(2)]);
var inst_56907 = fluree.db.util.async.throw_err(inst_56906);
var inst_56908 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_56907);
var inst_56909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56910 = [inst_56907];
var inst_56911 = (new cljs.core.PersistentVector(null,1,(5),inst_56909,inst_56910,null));
var inst_56912 = cljs.core.count(inst_56911);
var inst_56913 = ((9) + inst_56912);
var inst_56914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56915 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56917 = [inst_56907];
var inst_56918 = (new cljs.core.PersistentVector(null,1,(5),inst_56916,inst_56917,null));
var inst_56919 = ["/",inst_56918,inst_56908];
var inst_56920 = cljs.core.PersistentHashMap.fromArrays(inst_56915,inst_56919);
var inst_56921 = [inst_56920,inst_56913];
var inst_56922 = (new cljs.core.PersistentVector(null,2,(5),inst_56914,inst_56921,null));
var inst_56923 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56922);
var _ = (function (){var statearr_56937 = state_56928;
(statearr_56937[(4)] = cljs.core.rest((state_56928[(4)])));

return statearr_56937;
})();
var state_56928__$1 = (function (){var statearr_56938 = state_56928;
(statearr_56938[(7)] = inst_56923);

return statearr_56938;
})();
var statearr_56939_56952 = state_56928__$1;
(statearr_56939_56952[(2)] = inst_56908);

(statearr_56939_56952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56940 = [null,null,null,null,null,null,null,null];
(statearr_56940[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56940[(1)] = (1));

return statearr_56940;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56928){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56928);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56941){var ex__2730__auto__ = e56941;
var statearr_56942_56953 = state_56928;
(statearr_56942_56953[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56928[(4)]))){
var statearr_56943_56954 = state_56928;
(statearr_56943_56954[(1)] = cljs.core.first((state_56928[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56955 = state_56928;
state_56928 = G__56955;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56928){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56944 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56944[(6)] = c__2749__auto__);

return statearr_56944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56896){
var G__56897 = cljs.core.first(seq56896);
var seq56896__$1 = cljs.core.next(seq56896);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56897,seq56896__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56993){
var state_val_56994 = (state_56993[(1)]);
if((state_val_56994 === (7))){
var state_56993__$1 = state_56993;
var statearr_56995_57019 = state_56993__$1;
(statearr_56995_57019[(2)] = n);

(statearr_56995_57019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56994 === (1))){
var state_56993__$1 = state_56993;
var statearr_56996_57020 = state_56993__$1;
(statearr_56996_57020[(2)] = null);

(statearr_56996_57020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56994 === (4))){
var inst_56956 = (state_56993[(2)]);
var state_56993__$1 = state_56993;
var statearr_56997_57021 = state_56993__$1;
(statearr_56997_57021[(2)] = inst_56956);

(statearr_56997_57021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56994 === (13))){
var inst_56973 = (state_56993[(2)]);
var inst_56974 = fluree.db.util.async.throw_err(inst_56973);
var state_56993__$1 = state_56993;
var statearr_56998_57022 = state_56993__$1;
(statearr_56998_57022[(2)] = inst_56974);

(statearr_56998_57022[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56994 === (6))){
var state_56993__$1 = state_56993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56993__$1,(9),n);
} else {
if((state_val_56994 === (3))){
var inst_56991 = (state_56993[(2)]);
var state_56993__$1 = state_56993;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56993__$1,inst_56991);
} else {
if((state_val_56994 === (12))){
var inst_56969 = (state_56993[(7)]);
var inst_56977 = (state_56993[(2)]);
var inst_56978 = fluree.db.dbfunctions.internal.quot(inst_56969,inst_56977);
var inst_56979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56980 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56982 = [inst_56969,inst_56977];
var inst_56983 = (new cljs.core.PersistentVector(null,2,(5),inst_56981,inst_56982,null));
var inst_56984 = ["quot",inst_56983,inst_56978];
var inst_56985 = cljs.core.PersistentHashMap.fromArrays(inst_56980,inst_56984);
var inst_56986 = [inst_56985,(2)];
var inst_56987 = (new cljs.core.PersistentVector(null,2,(5),inst_56979,inst_56986,null));
var inst_56988 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56987);
var _ = (function (){var statearr_56999 = state_56993;
(statearr_56999[(4)] = cljs.core.rest((state_56993[(4)])));

return statearr_56999;
})();
var state_56993__$1 = (function (){var statearr_57000 = state_56993;
(statearr_57000[(8)] = inst_56988);

return statearr_57000;
})();
var statearr_57001_57023 = state_56993__$1;
(statearr_57001_57023[(2)] = inst_56978);

(statearr_57001_57023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56994 === (2))){
var _ = (function (){var statearr_57002 = state_56993;
(statearr_57002[(4)] = cljs.core.cons((5),(state_56993[(4)])));

return statearr_57002;
})();
var inst_56962 = fluree.db.util.async.channel_QMARK_(n);
var state_56993__$1 = state_56993;
if(inst_56962){
var statearr_57003_57024 = state_56993__$1;
(statearr_57003_57024[(1)] = (6));

} else {
var statearr_57004_57025 = state_56993__$1;
(statearr_57004_57025[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56994 === (11))){
var state_56993__$1 = state_56993;
var statearr_57006_57026 = state_56993__$1;
(statearr_57006_57026[(2)] = d);

(statearr_57006_57026[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56994 === (9))){
var inst_56965 = (state_56993[(2)]);
var inst_56966 = fluree.db.util.async.throw_err(inst_56965);
var state_56993__$1 = state_56993;
var statearr_57007_57027 = state_56993__$1;
(statearr_57007_57027[(2)] = inst_56966);

(statearr_57007_57027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56994 === (5))){
var _ = (function (){var statearr_57008 = state_56993;
(statearr_57008[(4)] = cljs.core.rest((state_56993[(4)])));

return statearr_57008;
})();
var state_56993__$1 = state_56993;
var ex57005 = (state_56993__$1[(2)]);
var statearr_57009_57028 = state_56993__$1;
(statearr_57009_57028[(5)] = ex57005);


if((ex57005 instanceof Error)){
var statearr_57010_57029 = state_56993__$1;
(statearr_57010_57029[(1)] = (4));

(statearr_57010_57029[(5)] = null);

} else {
throw ex57005;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56994 === (10))){
var state_56993__$1 = state_56993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56993__$1,(13),d);
} else {
if((state_val_56994 === (8))){
var inst_56969 = (state_56993[(2)]);
var inst_56970 = fluree.db.util.async.channel_QMARK_(d);
var state_56993__$1 = (function (){var statearr_57011 = state_56993;
(statearr_57011[(7)] = inst_56969);

return statearr_57011;
})();
if(inst_56970){
var statearr_57012_57030 = state_56993__$1;
(statearr_57012_57030[(1)] = (10));

} else {
var statearr_57013_57031 = state_56993__$1;
(statearr_57013_57031[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0 = (function (){
var statearr_57014 = [null,null,null,null,null,null,null,null,null];
(statearr_57014[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__);

(statearr_57014[(1)] = (1));

return statearr_57014;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1 = (function (state_56993){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56993);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57015){var ex__2730__auto__ = e57015;
var statearr_57016_57032 = state_56993;
(statearr_57016_57032[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56993[(4)]))){
var statearr_57017_57033 = state_56993;
(statearr_57017_57033[(1)] = cljs.core.first((state_56993[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57034 = state_56993;
state_56993 = G__57034;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = function(state_56993){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1.call(this,state_56993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57018 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57018[(6)] = c__2749__auto__);

return statearr_57018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57072){
var state_val_57073 = (state_57072[(1)]);
if((state_val_57073 === (7))){
var state_57072__$1 = state_57072;
var statearr_57074_57098 = state_57072__$1;
(statearr_57074_57098[(2)] = n);

(statearr_57074_57098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57073 === (1))){
var state_57072__$1 = state_57072;
var statearr_57075_57099 = state_57072__$1;
(statearr_57075_57099[(2)] = null);

(statearr_57075_57099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57073 === (4))){
var inst_57035 = (state_57072[(2)]);
var state_57072__$1 = state_57072;
var statearr_57076_57100 = state_57072__$1;
(statearr_57076_57100[(2)] = inst_57035);

(statearr_57076_57100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57073 === (13))){
var inst_57052 = (state_57072[(2)]);
var inst_57053 = fluree.db.util.async.throw_err(inst_57052);
var state_57072__$1 = state_57072;
var statearr_57077_57101 = state_57072__$1;
(statearr_57077_57101[(2)] = inst_57053);

(statearr_57077_57101[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57073 === (6))){
var state_57072__$1 = state_57072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57072__$1,(9),n);
} else {
if((state_val_57073 === (3))){
var inst_57070 = (state_57072[(2)]);
var state_57072__$1 = state_57072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57072__$1,inst_57070);
} else {
if((state_val_57073 === (12))){
var inst_57048 = (state_57072[(7)]);
var inst_57056 = (state_57072[(2)]);
var inst_57057 = fluree.db.dbfunctions.internal.mod(inst_57048,inst_57056);
var inst_57058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57059 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57061 = [inst_57048,inst_57056];
var inst_57062 = (new cljs.core.PersistentVector(null,2,(5),inst_57060,inst_57061,null));
var inst_57063 = ["mod",inst_57062,inst_57057];
var inst_57064 = cljs.core.PersistentHashMap.fromArrays(inst_57059,inst_57063);
var inst_57065 = [inst_57064,(2)];
var inst_57066 = (new cljs.core.PersistentVector(null,2,(5),inst_57058,inst_57065,null));
var inst_57067 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57066);
var _ = (function (){var statearr_57078 = state_57072;
(statearr_57078[(4)] = cljs.core.rest((state_57072[(4)])));

return statearr_57078;
})();
var state_57072__$1 = (function (){var statearr_57079 = state_57072;
(statearr_57079[(8)] = inst_57067);

return statearr_57079;
})();
var statearr_57080_57102 = state_57072__$1;
(statearr_57080_57102[(2)] = inst_57057);

(statearr_57080_57102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57073 === (2))){
var _ = (function (){var statearr_57081 = state_57072;
(statearr_57081[(4)] = cljs.core.cons((5),(state_57072[(4)])));

return statearr_57081;
})();
var inst_57041 = fluree.db.util.async.channel_QMARK_(n);
var state_57072__$1 = state_57072;
if(inst_57041){
var statearr_57082_57103 = state_57072__$1;
(statearr_57082_57103[(1)] = (6));

} else {
var statearr_57083_57104 = state_57072__$1;
(statearr_57083_57104[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57073 === (11))){
var state_57072__$1 = state_57072;
var statearr_57085_57105 = state_57072__$1;
(statearr_57085_57105[(2)] = d);

(statearr_57085_57105[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57073 === (9))){
var inst_57044 = (state_57072[(2)]);
var inst_57045 = fluree.db.util.async.throw_err(inst_57044);
var state_57072__$1 = state_57072;
var statearr_57086_57106 = state_57072__$1;
(statearr_57086_57106[(2)] = inst_57045);

(statearr_57086_57106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57073 === (5))){
var _ = (function (){var statearr_57087 = state_57072;
(statearr_57087[(4)] = cljs.core.rest((state_57072[(4)])));

return statearr_57087;
})();
var state_57072__$1 = state_57072;
var ex57084 = (state_57072__$1[(2)]);
var statearr_57088_57107 = state_57072__$1;
(statearr_57088_57107[(5)] = ex57084);


if((ex57084 instanceof Error)){
var statearr_57089_57108 = state_57072__$1;
(statearr_57089_57108[(1)] = (4));

(statearr_57089_57108[(5)] = null);

} else {
throw ex57084;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57073 === (10))){
var state_57072__$1 = state_57072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57072__$1,(13),d);
} else {
if((state_val_57073 === (8))){
var inst_57048 = (state_57072[(2)]);
var inst_57049 = fluree.db.util.async.channel_QMARK_(d);
var state_57072__$1 = (function (){var statearr_57090 = state_57072;
(statearr_57090[(7)] = inst_57048);

return statearr_57090;
})();
if(inst_57049){
var statearr_57091_57109 = state_57072__$1;
(statearr_57091_57109[(1)] = (10));

} else {
var statearr_57092_57110 = state_57072__$1;
(statearr_57092_57110[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0 = (function (){
var statearr_57093 = [null,null,null,null,null,null,null,null,null];
(statearr_57093[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__);

(statearr_57093[(1)] = (1));

return statearr_57093;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1 = (function (state_57072){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57072);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57094){var ex__2730__auto__ = e57094;
var statearr_57095_57111 = state_57072;
(statearr_57095_57111[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57072[(4)]))){
var statearr_57096_57112 = state_57072;
(statearr_57096_57112[(1)] = cljs.core.first((state_57072[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57113 = state_57072;
state_57072 = G__57113;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = function(state_57072){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1.call(this,state_57072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57097 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57097[(6)] = c__2749__auto__);

return statearr_57097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57151){
var state_val_57152 = (state_57151[(1)]);
if((state_val_57152 === (7))){
var state_57151__$1 = state_57151;
var statearr_57153_57177 = state_57151__$1;
(statearr_57153_57177[(2)] = n);

(statearr_57153_57177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57152 === (1))){
var state_57151__$1 = state_57151;
var statearr_57154_57178 = state_57151__$1;
(statearr_57154_57178[(2)] = null);

(statearr_57154_57178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57152 === (4))){
var inst_57114 = (state_57151[(2)]);
var state_57151__$1 = state_57151;
var statearr_57155_57179 = state_57151__$1;
(statearr_57155_57179[(2)] = inst_57114);

(statearr_57155_57179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57152 === (13))){
var inst_57131 = (state_57151[(2)]);
var inst_57132 = fluree.db.util.async.throw_err(inst_57131);
var state_57151__$1 = state_57151;
var statearr_57156_57180 = state_57151__$1;
(statearr_57156_57180[(2)] = inst_57132);

(statearr_57156_57180[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57152 === (6))){
var state_57151__$1 = state_57151;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57151__$1,(9),n);
} else {
if((state_val_57152 === (3))){
var inst_57149 = (state_57151[(2)]);
var state_57151__$1 = state_57151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57151__$1,inst_57149);
} else {
if((state_val_57152 === (12))){
var inst_57127 = (state_57151[(7)]);
var inst_57135 = (state_57151[(2)]);
var inst_57136 = fluree.db.dbfunctions.internal.rem(inst_57127,inst_57135);
var inst_57137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57138 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57140 = [inst_57127,inst_57135];
var inst_57141 = (new cljs.core.PersistentVector(null,2,(5),inst_57139,inst_57140,null));
var inst_57142 = ["rem",inst_57141,inst_57136];
var inst_57143 = cljs.core.PersistentHashMap.fromArrays(inst_57138,inst_57142);
var inst_57144 = [inst_57143,(2)];
var inst_57145 = (new cljs.core.PersistentVector(null,2,(5),inst_57137,inst_57144,null));
var inst_57146 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57145);
var _ = (function (){var statearr_57157 = state_57151;
(statearr_57157[(4)] = cljs.core.rest((state_57151[(4)])));

return statearr_57157;
})();
var state_57151__$1 = (function (){var statearr_57158 = state_57151;
(statearr_57158[(8)] = inst_57146);

return statearr_57158;
})();
var statearr_57159_57181 = state_57151__$1;
(statearr_57159_57181[(2)] = inst_57136);

(statearr_57159_57181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57152 === (2))){
var _ = (function (){var statearr_57160 = state_57151;
(statearr_57160[(4)] = cljs.core.cons((5),(state_57151[(4)])));

return statearr_57160;
})();
var inst_57120 = fluree.db.util.async.channel_QMARK_(n);
var state_57151__$1 = state_57151;
if(inst_57120){
var statearr_57161_57182 = state_57151__$1;
(statearr_57161_57182[(1)] = (6));

} else {
var statearr_57162_57183 = state_57151__$1;
(statearr_57162_57183[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57152 === (11))){
var state_57151__$1 = state_57151;
var statearr_57164_57184 = state_57151__$1;
(statearr_57164_57184[(2)] = d);

(statearr_57164_57184[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57152 === (9))){
var inst_57123 = (state_57151[(2)]);
var inst_57124 = fluree.db.util.async.throw_err(inst_57123);
var state_57151__$1 = state_57151;
var statearr_57165_57185 = state_57151__$1;
(statearr_57165_57185[(2)] = inst_57124);

(statearr_57165_57185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57152 === (5))){
var _ = (function (){var statearr_57166 = state_57151;
(statearr_57166[(4)] = cljs.core.rest((state_57151[(4)])));

return statearr_57166;
})();
var state_57151__$1 = state_57151;
var ex57163 = (state_57151__$1[(2)]);
var statearr_57167_57186 = state_57151__$1;
(statearr_57167_57186[(5)] = ex57163);


if((ex57163 instanceof Error)){
var statearr_57168_57187 = state_57151__$1;
(statearr_57168_57187[(1)] = (4));

(statearr_57168_57187[(5)] = null);

} else {
throw ex57163;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57152 === (10))){
var state_57151__$1 = state_57151;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57151__$1,(13),d);
} else {
if((state_val_57152 === (8))){
var inst_57127 = (state_57151[(2)]);
var inst_57128 = fluree.db.util.async.channel_QMARK_(d);
var state_57151__$1 = (function (){var statearr_57169 = state_57151;
(statearr_57169[(7)] = inst_57127);

return statearr_57169;
})();
if(inst_57128){
var statearr_57170_57188 = state_57151__$1;
(statearr_57170_57188[(1)] = (10));

} else {
var statearr_57171_57189 = state_57151__$1;
(statearr_57171_57189[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0 = (function (){
var statearr_57172 = [null,null,null,null,null,null,null,null,null];
(statearr_57172[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__);

(statearr_57172[(1)] = (1));

return statearr_57172;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1 = (function (state_57151){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57151);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57173){var ex__2730__auto__ = e57173;
var statearr_57174_57190 = state_57151;
(statearr_57174_57190[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57151[(4)]))){
var statearr_57175_57191 = state_57151;
(statearr_57175_57191[(1)] = cljs.core.first((state_57151[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57192 = state_57151;
state_57151 = G__57192;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = function(state_57151){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1.call(this,state_57151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57176 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57176[(6)] = c__2749__auto__);

return statearr_57176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57219){
var state_val_57220 = (state_57219[(1)]);
if((state_val_57220 === (7))){
var state_57219__$1 = state_57219;
var statearr_57221_57240 = state_57219__$1;
(statearr_57221_57240[(2)] = x);

(statearr_57221_57240[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57220 === (1))){
var state_57219__$1 = state_57219;
var statearr_57222_57241 = state_57219__$1;
(statearr_57222_57241[(2)] = null);

(statearr_57222_57241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57220 === (4))){
var inst_57193 = (state_57219[(2)]);
var state_57219__$1 = state_57219;
var statearr_57223_57242 = state_57219__$1;
(statearr_57223_57242[(2)] = inst_57193);

(statearr_57223_57242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57220 === (6))){
var state_57219__$1 = state_57219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57219__$1,(9),x);
} else {
if((state_val_57220 === (3))){
var inst_57217 = (state_57219[(2)]);
var state_57219__$1 = state_57219;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57219__$1,inst_57217);
} else {
if((state_val_57220 === (2))){
var _ = (function (){var statearr_57225 = state_57219;
(statearr_57225[(4)] = cljs.core.cons((5),(state_57219[(4)])));

return statearr_57225;
})();
var inst_57199 = fluree.db.util.async.channel_QMARK_(x);
var state_57219__$1 = state_57219;
if(inst_57199){
var statearr_57226_57243 = state_57219__$1;
(statearr_57226_57243[(1)] = (6));

} else {
var statearr_57227_57244 = state_57219__$1;
(statearr_57227_57244[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57220 === (9))){
var inst_57202 = (state_57219[(2)]);
var inst_57203 = fluree.db.util.async.throw_err(inst_57202);
var state_57219__$1 = state_57219;
var statearr_57228_57245 = state_57219__$1;
(statearr_57228_57245[(2)] = inst_57203);

(statearr_57228_57245[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57220 === (5))){
var _ = (function (){var statearr_57229 = state_57219;
(statearr_57229[(4)] = cljs.core.rest((state_57219[(4)])));

return statearr_57229;
})();
var state_57219__$1 = state_57219;
var ex57224 = (state_57219__$1[(2)]);
var statearr_57230_57246 = state_57219__$1;
(statearr_57230_57246[(5)] = ex57224);


if((ex57224 instanceof Error)){
var statearr_57231_57247 = state_57219__$1;
(statearr_57231_57247[(1)] = (4));

(statearr_57231_57247[(5)] = null);

} else {
throw ex57224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57220 === (8))){
var inst_57206 = (state_57219[(2)]);
var inst_57207 = fluree.db.dbfunctions.internal.boolean$(inst_57206);
var inst_57208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57209 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57210 = ["boolean",inst_57206,inst_57207];
var inst_57211 = cljs.core.PersistentHashMap.fromArrays(inst_57209,inst_57210);
var inst_57212 = [inst_57211,(10)];
var inst_57213 = (new cljs.core.PersistentVector(null,2,(5),inst_57208,inst_57212,null));
var inst_57214 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57213);
var _ = (function (){var statearr_57232 = state_57219;
(statearr_57232[(4)] = cljs.core.rest((state_57219[(4)])));

return statearr_57232;
})();
var state_57219__$1 = (function (){var statearr_57233 = state_57219;
(statearr_57233[(7)] = inst_57214);

return statearr_57233;
})();
var statearr_57234_57248 = state_57219__$1;
(statearr_57234_57248[(2)] = inst_57207);

(statearr_57234_57248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0 = (function (){
var statearr_57235 = [null,null,null,null,null,null,null,null];
(statearr_57235[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__);

(statearr_57235[(1)] = (1));

return statearr_57235;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1 = (function (state_57219){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57219);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57236){var ex__2730__auto__ = e57236;
var statearr_57237_57249 = state_57219;
(statearr_57237_57249[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57219[(4)]))){
var statearr_57238_57250 = state_57219;
(statearr_57238_57250[(1)] = cljs.core.first((state_57219[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57251 = state_57219;
state_57219 = G__57251;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = function(state_57219){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1.call(this,state_57219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57239 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57239[(6)] = c__2749__auto__);

return statearr_57239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57289){
var state_val_57290 = (state_57289[(1)]);
if((state_val_57290 === (7))){
var state_57289__$1 = state_57289;
var statearr_57291_57315 = state_57289__$1;
(statearr_57291_57315[(2)] = pattern);

(statearr_57291_57315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57290 === (1))){
var state_57289__$1 = state_57289;
var statearr_57292_57316 = state_57289__$1;
(statearr_57292_57316[(2)] = null);

(statearr_57292_57316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57290 === (4))){
var inst_57252 = (state_57289[(2)]);
var state_57289__$1 = state_57289;
var statearr_57293_57317 = state_57289__$1;
(statearr_57293_57317[(2)] = inst_57252);

(statearr_57293_57317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57290 === (13))){
var inst_57269 = (state_57289[(2)]);
var inst_57270 = fluree.db.util.async.throw_err(inst_57269);
var state_57289__$1 = state_57289;
var statearr_57294_57318 = state_57289__$1;
(statearr_57294_57318[(2)] = inst_57270);

(statearr_57294_57318[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57290 === (6))){
var state_57289__$1 = state_57289;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57289__$1,(9),pattern);
} else {
if((state_val_57290 === (3))){
var inst_57287 = (state_57289[(2)]);
var state_57289__$1 = state_57289;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57289__$1,inst_57287);
} else {
if((state_val_57290 === (12))){
var inst_57265 = (state_57289[(7)]);
var inst_57273 = (state_57289[(2)]);
var inst_57274 = fluree.db.dbfunctions.internal.re_find(inst_57265,inst_57273);
var inst_57275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57276 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57278 = [inst_57265,inst_57273];
var inst_57279 = (new cljs.core.PersistentVector(null,2,(5),inst_57277,inst_57278,null));
var inst_57280 = ["re-find",inst_57279,inst_57274];
var inst_57281 = cljs.core.PersistentHashMap.fromArrays(inst_57276,inst_57280);
var inst_57282 = [inst_57281,(10)];
var inst_57283 = (new cljs.core.PersistentVector(null,2,(5),inst_57275,inst_57282,null));
var inst_57284 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57283);
var _ = (function (){var statearr_57295 = state_57289;
(statearr_57295[(4)] = cljs.core.rest((state_57289[(4)])));

return statearr_57295;
})();
var state_57289__$1 = (function (){var statearr_57296 = state_57289;
(statearr_57296[(8)] = inst_57284);

return statearr_57296;
})();
var statearr_57297_57319 = state_57289__$1;
(statearr_57297_57319[(2)] = inst_57274);

(statearr_57297_57319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57290 === (2))){
var _ = (function (){var statearr_57298 = state_57289;
(statearr_57298[(4)] = cljs.core.cons((5),(state_57289[(4)])));

return statearr_57298;
})();
var inst_57258 = fluree.db.util.async.channel_QMARK_(pattern);
var state_57289__$1 = state_57289;
if(inst_57258){
var statearr_57299_57320 = state_57289__$1;
(statearr_57299_57320[(1)] = (6));

} else {
var statearr_57300_57321 = state_57289__$1;
(statearr_57300_57321[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57290 === (11))){
var state_57289__$1 = state_57289;
var statearr_57302_57322 = state_57289__$1;
(statearr_57302_57322[(2)] = string);

(statearr_57302_57322[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57290 === (9))){
var inst_57261 = (state_57289[(2)]);
var inst_57262 = fluree.db.util.async.throw_err(inst_57261);
var state_57289__$1 = state_57289;
var statearr_57303_57323 = state_57289__$1;
(statearr_57303_57323[(2)] = inst_57262);

(statearr_57303_57323[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57290 === (5))){
var _ = (function (){var statearr_57304 = state_57289;
(statearr_57304[(4)] = cljs.core.rest((state_57289[(4)])));

return statearr_57304;
})();
var state_57289__$1 = state_57289;
var ex57301 = (state_57289__$1[(2)]);
var statearr_57305_57324 = state_57289__$1;
(statearr_57305_57324[(5)] = ex57301);


if((ex57301 instanceof Error)){
var statearr_57306_57325 = state_57289__$1;
(statearr_57306_57325[(1)] = (4));

(statearr_57306_57325[(5)] = null);

} else {
throw ex57301;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57290 === (10))){
var state_57289__$1 = state_57289;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57289__$1,(13),string);
} else {
if((state_val_57290 === (8))){
var inst_57265 = (state_57289[(2)]);
var inst_57266 = fluree.db.util.async.channel_QMARK_(string);
var state_57289__$1 = (function (){var statearr_57307 = state_57289;
(statearr_57307[(7)] = inst_57265);

return statearr_57307;
})();
if(inst_57266){
var statearr_57308_57326 = state_57289__$1;
(statearr_57308_57326[(1)] = (10));

} else {
var statearr_57309_57327 = state_57289__$1;
(statearr_57309_57327[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0 = (function (){
var statearr_57310 = [null,null,null,null,null,null,null,null,null];
(statearr_57310[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__);

(statearr_57310[(1)] = (1));

return statearr_57310;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1 = (function (state_57289){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57289);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57311){var ex__2730__auto__ = e57311;
var statearr_57312_57328 = state_57289;
(statearr_57312_57328[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57289[(4)]))){
var statearr_57313_57329 = state_57289;
(statearr_57313_57329[(1)] = cljs.core.first((state_57289[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57330 = state_57289;
state_57289 = G__57330;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = function(state_57289){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1.call(this,state_57289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57314 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57314[(6)] = c__2749__auto__);

return statearr_57314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57357){
var state_val_57358 = (state_57357[(1)]);
if((state_val_57358 === (7))){
var state_57357__$1 = state_57357;
var statearr_57359_57378 = state_57357__$1;
(statearr_57359_57378[(2)] = email);

(statearr_57359_57378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57358 === (1))){
var state_57357__$1 = state_57357;
var statearr_57360_57379 = state_57357__$1;
(statearr_57360_57379[(2)] = null);

(statearr_57360_57379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57358 === (4))){
var inst_57331 = (state_57357[(2)]);
var state_57357__$1 = state_57357;
var statearr_57361_57380 = state_57357__$1;
(statearr_57361_57380[(2)] = inst_57331);

(statearr_57361_57380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57358 === (6))){
var state_57357__$1 = state_57357;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57357__$1,(9),email);
} else {
if((state_val_57358 === (3))){
var inst_57355 = (state_57357[(2)]);
var state_57357__$1 = state_57357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57357__$1,inst_57355);
} else {
if((state_val_57358 === (2))){
var _ = (function (){var statearr_57363 = state_57357;
(statearr_57363[(4)] = cljs.core.cons((5),(state_57357[(4)])));

return statearr_57363;
})();
var inst_57337 = fluree.db.util.async.channel_QMARK_(email);
var state_57357__$1 = state_57357;
if(inst_57337){
var statearr_57364_57381 = state_57357__$1;
(statearr_57364_57381[(1)] = (6));

} else {
var statearr_57365_57382 = state_57357__$1;
(statearr_57365_57382[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57358 === (9))){
var inst_57340 = (state_57357[(2)]);
var inst_57341 = fluree.db.util.async.throw_err(inst_57340);
var state_57357__$1 = state_57357;
var statearr_57366_57383 = state_57357__$1;
(statearr_57366_57383[(2)] = inst_57341);

(statearr_57366_57383[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57358 === (5))){
var _ = (function (){var statearr_57367 = state_57357;
(statearr_57367[(4)] = cljs.core.rest((state_57357[(4)])));

return statearr_57367;
})();
var state_57357__$1 = state_57357;
var ex57362 = (state_57357__$1[(2)]);
var statearr_57368_57384 = state_57357__$1;
(statearr_57368_57384[(5)] = ex57362);


if((ex57362 instanceof Error)){
var statearr_57369_57385 = state_57357__$1;
(statearr_57369_57385[(1)] = (4));

(statearr_57369_57385[(5)] = null);

} else {
throw ex57362;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57358 === (8))){
var inst_57344 = (state_57357[(2)]);
var inst_57345 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_57344);
var inst_57346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57347 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57348 = ["re-find",inst_57344,inst_57345];
var inst_57349 = cljs.core.PersistentHashMap.fromArrays(inst_57347,inst_57348);
var inst_57350 = [inst_57349,(10)];
var inst_57351 = (new cljs.core.PersistentVector(null,2,(5),inst_57346,inst_57350,null));
var inst_57352 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57351);
var _ = (function (){var statearr_57370 = state_57357;
(statearr_57370[(4)] = cljs.core.rest((state_57357[(4)])));

return statearr_57370;
})();
var state_57357__$1 = (function (){var statearr_57371 = state_57357;
(statearr_57371[(7)] = inst_57352);

return statearr_57371;
})();
var statearr_57372_57386 = state_57357__$1;
(statearr_57372_57386[(2)] = inst_57345);

(statearr_57372_57386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_57373 = [null,null,null,null,null,null,null,null];
(statearr_57373[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__);

(statearr_57373[(1)] = (1));

return statearr_57373;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1 = (function (state_57357){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57357);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57374){var ex__2730__auto__ = e57374;
var statearr_57375_57387 = state_57357;
(statearr_57375_57387[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57357[(4)]))){
var statearr_57376_57388 = state_57357;
(statearr_57376_57388[(1)] = cljs.core.first((state_57357[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57389 = state_57357;
state_57357 = G__57389;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = function(state_57357){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1.call(this,state_57357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57377 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57377[(6)] = c__2749__auto__);

return statearr_57377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57436){
var state_val_57437 = (state_57436[(1)]);
if((state_val_57437 === (7))){
var inst_57406 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57436__$1 = state_57436;
if(cljs.core.truth_(inst_57406)){
var statearr_57438_57465 = state_57436__$1;
(statearr_57438_57465[(1)] = (9));

} else {
var statearr_57439_57466 = state_57436__$1;
(statearr_57439_57466[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (1))){
var state_57436__$1 = state_57436;
var statearr_57440_57467 = state_57436__$1;
(statearr_57440_57467[(2)] = null);

(statearr_57440_57467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (4))){
var inst_57390 = (state_57436[(2)]);
var state_57436__$1 = state_57436;
var statearr_57441_57468 = state_57436__$1;
(statearr_57441_57468[(2)] = inst_57390);

(statearr_57441_57468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (15))){
var inst_57417 = (state_57436[(2)]);
var state_57436__$1 = state_57436;
var statearr_57442_57469 = state_57436__$1;
(statearr_57442_57469[(2)] = inst_57417);

(statearr_57442_57469[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (13))){
var inst_57414 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57436__$1 = state_57436;
var statearr_57443_57470 = state_57436__$1;
(statearr_57443_57470[(2)] = inst_57414);

(statearr_57443_57470[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (6))){
var inst_57401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57402 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57403 = [inst_57402,(0)];
var inst_57404 = (new cljs.core.PersistentVector(null,2,(5),inst_57401,inst_57403,null));
var state_57436__$1 = state_57436;
var statearr_57444_57471 = state_57436__$1;
(statearr_57444_57471[(2)] = inst_57404);

(statearr_57444_57471[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (3))){
var inst_57434 = (state_57436[(2)]);
var state_57436__$1 = state_57436;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57436__$1,inst_57434);
} else {
if((state_val_57437 === (12))){
var inst_57410 = (state_57436[(2)]);
var inst_57411 = fluree.db.util.async.throw_err(inst_57410);
var state_57436__$1 = state_57436;
var statearr_57445_57472 = state_57436__$1;
(statearr_57445_57472[(2)] = inst_57411);

(statearr_57445_57472[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (2))){
var _ = (function (){var statearr_57446 = state_57436;
(statearr_57446[(4)] = cljs.core.cons((5),(state_57436[(4)])));

return statearr_57446;
})();
var inst_57399 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57436__$1 = state_57436;
if(cljs.core.truth_(inst_57399)){
var statearr_57447_57473 = state_57436__$1;
(statearr_57447_57473[(1)] = (6));

} else {
var statearr_57448_57474 = state_57436__$1;
(statearr_57448_57474[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (11))){
var inst_57419 = (state_57436[(2)]);
var state_57436__$1 = state_57436;
var statearr_57450_57475 = state_57436__$1;
(statearr_57450_57475[(2)] = inst_57419);

(statearr_57450_57475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (9))){
var inst_57408 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_57436__$1 = state_57436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57436__$1,(12),inst_57408);
} else {
if((state_val_57437 === (5))){
var _ = (function (){var statearr_57451 = state_57436;
(statearr_57451[(4)] = cljs.core.rest((state_57436[(4)])));

return statearr_57451;
})();
var state_57436__$1 = state_57436;
var ex57449 = (state_57436__$1[(2)]);
var statearr_57452_57476 = state_57436__$1;
(statearr_57452_57476[(5)] = ex57449);


if((ex57449 instanceof Error)){
var statearr_57453_57477 = state_57436__$1;
(statearr_57453_57477[(1)] = (4));

(statearr_57453_57477[(5)] = null);

} else {
throw ex57449;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (14))){
var state_57436__$1 = state_57436;
var statearr_57454_57478 = state_57436__$1;
(statearr_57454_57478[(2)] = null);

(statearr_57454_57478[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (10))){
var state_57436__$1 = state_57436;
var statearr_57455_57479 = state_57436__$1;
(statearr_57455_57479[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57437 === (8))){
var inst_57421 = (state_57436[(2)]);
var inst_57422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57421,(0),null);
var inst_57423 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57421,(1),null);
var inst_57424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57425 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57426 = ["?user_id","?ctx",inst_57422];
var inst_57427 = cljs.core.PersistentHashMap.fromArrays(inst_57425,inst_57426);
var inst_57428 = ((10) + inst_57423);
var inst_57429 = [inst_57427,inst_57428];
var inst_57430 = (new cljs.core.PersistentVector(null,2,(5),inst_57424,inst_57429,null));
var inst_57431 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57430);
var _ = (function (){var statearr_57457 = state_57436;
(statearr_57457[(4)] = cljs.core.rest((state_57436[(4)])));

return statearr_57457;
})();
var state_57436__$1 = (function (){var statearr_57458 = state_57436;
(statearr_57458[(7)] = inst_57431);

return statearr_57458;
})();
var statearr_57459_57480 = state_57436__$1;
(statearr_57459_57480[(2)] = inst_57422);

(statearr_57459_57480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0 = (function (){
var statearr_57460 = [null,null,null,null,null,null,null,null];
(statearr_57460[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__);

(statearr_57460[(1)] = (1));

return statearr_57460;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1 = (function (state_57436){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57436);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57461){var ex__2730__auto__ = e57461;
var statearr_57462_57481 = state_57436;
(statearr_57462_57481[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57436[(4)]))){
var statearr_57463_57482 = state_57436;
(statearr_57463_57482[(1)] = cljs.core.first((state_57436[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57483 = state_57436;
state_57436 = G__57483;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = function(state_57436){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1.call(this,state_57436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57464 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57464[(6)] = c__2749__auto__);

return statearr_57464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57511){
var state_val_57512 = (state_57511[(1)]);
if((state_val_57512 === (7))){
var inst_57504 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57511__$1 = state_57511;
var statearr_57513_57532 = state_57511__$1;
(statearr_57513_57532[(2)] = inst_57504);

(statearr_57513_57532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (1))){
var state_57511__$1 = state_57511;
var statearr_57514_57533 = state_57511__$1;
(statearr_57514_57533[(2)] = null);

(statearr_57514_57533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (4))){
var inst_57484 = (state_57511[(2)]);
var state_57511__$1 = state_57511;
var statearr_57515_57534 = state_57511__$1;
(statearr_57515_57534[(2)] = inst_57484);

(statearr_57515_57534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (6))){
var inst_57492 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_57511__$1 = state_57511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57511__$1,(9),inst_57492);
} else {
if((state_val_57512 === (3))){
var inst_57509 = (state_57511[(2)]);
var state_57511__$1 = state_57511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57511__$1,inst_57509);
} else {
if((state_val_57512 === (2))){
var _ = (function (){var statearr_57517 = state_57511;
(statearr_57517[(4)] = cljs.core.cons((5),(state_57511[(4)])));

return statearr_57517;
})();
var inst_57490 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57511__$1 = state_57511;
if(cljs.core.truth_(inst_57490)){
var statearr_57518_57535 = state_57511__$1;
(statearr_57518_57535[(1)] = (6));

} else {
var statearr_57519_57536 = state_57511__$1;
(statearr_57519_57536[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (9))){
var inst_57494 = (state_57511[(2)]);
var inst_57495 = fluree.db.util.async.throw_err(inst_57494);
var inst_57496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57497 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57498 = ["?auth_id","?ctx",inst_57495];
var inst_57499 = cljs.core.PersistentHashMap.fromArrays(inst_57497,inst_57498);
var inst_57500 = [inst_57499,(10)];
var inst_57501 = (new cljs.core.PersistentVector(null,2,(5),inst_57496,inst_57500,null));
var inst_57502 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57501);
var state_57511__$1 = (function (){var statearr_57520 = state_57511;
(statearr_57520[(7)] = inst_57502);

return statearr_57520;
})();
var statearr_57521_57537 = state_57511__$1;
(statearr_57521_57537[(2)] = inst_57495);

(statearr_57521_57537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (5))){
var _ = (function (){var statearr_57522 = state_57511;
(statearr_57522[(4)] = cljs.core.rest((state_57511[(4)])));

return statearr_57522;
})();
var state_57511__$1 = state_57511;
var ex57516 = (state_57511__$1[(2)]);
var statearr_57523_57538 = state_57511__$1;
(statearr_57523_57538[(5)] = ex57516);


if((ex57516 instanceof Error)){
var statearr_57524_57539 = state_57511__$1;
(statearr_57524_57539[(1)] = (4));

(statearr_57524_57539[(5)] = null);

} else {
throw ex57516;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (8))){
var inst_57506 = (state_57511[(2)]);
var _ = (function (){var statearr_57525 = state_57511;
(statearr_57525[(4)] = cljs.core.rest((state_57511[(4)])));

return statearr_57525;
})();
var state_57511__$1 = state_57511;
var statearr_57526_57540 = state_57511__$1;
(statearr_57526_57540[(2)] = inst_57506);

(statearr_57526_57540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_57527 = [null,null,null,null,null,null,null,null];
(statearr_57527[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_57527[(1)] = (1));

return statearr_57527;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_57511){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57511);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57528){var ex__2730__auto__ = e57528;
var statearr_57529_57541 = state_57511;
(statearr_57529_57541[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57511[(4)]))){
var statearr_57530_57542 = state_57511;
(statearr_57530_57542[(1)] = cljs.core.first((state_57511[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57543 = state_57511;
state_57511 = G__57543;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_57511){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_57511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57531 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57531[(6)] = c__2749__auto__);

return statearr_57531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57545 = arguments.length;
switch (G__57545) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57587){
var state_val_57588 = (state_57587[(1)]);
if((state_val_57588 === (7))){
var state_57587__$1 = state_57587;
var statearr_57589_57619 = state_57587__$1;
(statearr_57589_57619[(2)] = seed);

(statearr_57589_57619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (1))){
var state_57587__$1 = state_57587;
var statearr_57590_57620 = state_57587__$1;
(statearr_57590_57620[(2)] = null);

(statearr_57590_57620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (4))){
var inst_57546 = (state_57587[(2)]);
var state_57587__$1 = state_57587;
var statearr_57591_57621 = state_57587__$1;
(statearr_57591_57621[(2)] = inst_57546);

(statearr_57591_57621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (15))){
var state_57587__$1 = state_57587;
var statearr_57592_57622 = state_57587__$1;
(statearr_57592_57622[(2)] = (10));

(statearr_57592_57622[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (13))){
var inst_57563 = (state_57587[(2)]);
var inst_57564 = fluree.db.util.async.throw_err(inst_57563);
var state_57587__$1 = state_57587;
var statearr_57593_57623 = state_57587__$1;
(statearr_57593_57623[(2)] = inst_57564);

(statearr_57593_57623[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (6))){
var state_57587__$1 = state_57587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57587__$1,(9),seed);
} else {
if((state_val_57588 === (3))){
var inst_57585 = (state_57587[(2)]);
var state_57587__$1 = state_57587;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57587__$1,inst_57585);
} else {
if((state_val_57588 === (12))){
var inst_57567 = (state_57587[(7)]);
var inst_57567__$1 = (state_57587[(2)]);
var state_57587__$1 = (function (){var statearr_57594 = state_57587;
(statearr_57594[(7)] = inst_57567__$1);

return statearr_57594;
})();
if(cljs.core.truth_(inst_57567__$1)){
var statearr_57595_57624 = state_57587__$1;
(statearr_57595_57624[(1)] = (14));

} else {
var statearr_57596_57625 = state_57587__$1;
(statearr_57596_57625[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (2))){
var _ = (function (){var statearr_57597 = state_57587;
(statearr_57597[(4)] = cljs.core.cons((5),(state_57587[(4)])));

return statearr_57597;
})();
var inst_57552 = fluree.db.util.async.channel_QMARK_(seed);
var state_57587__$1 = state_57587;
if(inst_57552){
var statearr_57598_57626 = state_57587__$1;
(statearr_57598_57626[(1)] = (6));

} else {
var statearr_57599_57627 = state_57587__$1;
(statearr_57599_57627[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (11))){
var state_57587__$1 = state_57587;
var statearr_57601_57628 = state_57587__$1;
(statearr_57601_57628[(2)] = max);

(statearr_57601_57628[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (9))){
var inst_57555 = (state_57587[(2)]);
var inst_57556 = fluree.db.util.async.throw_err(inst_57555);
var state_57587__$1 = state_57587;
var statearr_57602_57629 = state_57587__$1;
(statearr_57602_57629[(2)] = inst_57556);

(statearr_57602_57629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (5))){
var _ = (function (){var statearr_57603 = state_57587;
(statearr_57603[(4)] = cljs.core.rest((state_57587[(4)])));

return statearr_57603;
})();
var state_57587__$1 = state_57587;
var ex57600 = (state_57587__$1[(2)]);
var statearr_57604_57630 = state_57587__$1;
(statearr_57604_57630[(5)] = ex57600);


if((ex57600 instanceof Error)){
var statearr_57605_57631 = state_57587__$1;
(statearr_57605_57631[(1)] = (4));

(statearr_57605_57631[(5)] = null);

} else {
throw ex57600;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (14))){
var inst_57567 = (state_57587[(7)]);
var state_57587__$1 = state_57587;
var statearr_57606_57632 = state_57587__$1;
(statearr_57606_57632[(2)] = inst_57567);

(statearr_57606_57632[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (16))){
var inst_57559 = (state_57587[(8)]);
var inst_57571 = (state_57587[(2)]);
var inst_57572 = fluree.db.dbfunctions.internal.rand(inst_57559,inst_57571);
var inst_57573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57574 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57576 = [max,seed];
var inst_57577 = (new cljs.core.PersistentVector(null,2,(5),inst_57575,inst_57576,null));
var inst_57578 = ["rand",inst_57577,inst_57572];
var inst_57579 = cljs.core.PersistentHashMap.fromArrays(inst_57574,inst_57578);
var inst_57580 = [inst_57579,(10)];
var inst_57581 = (new cljs.core.PersistentVector(null,2,(5),inst_57573,inst_57580,null));
var inst_57582 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57581);
var _ = (function (){var statearr_57607 = state_57587;
(statearr_57607[(4)] = cljs.core.rest((state_57587[(4)])));

return statearr_57607;
})();
var state_57587__$1 = (function (){var statearr_57608 = state_57587;
(statearr_57608[(9)] = inst_57582);

return statearr_57608;
})();
var statearr_57609_57633 = state_57587__$1;
(statearr_57609_57633[(2)] = inst_57572);

(statearr_57609_57633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57588 === (10))){
var state_57587__$1 = state_57587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57587__$1,(13),max);
} else {
if((state_val_57588 === (8))){
var inst_57559 = (state_57587[(2)]);
var inst_57560 = fluree.db.util.async.channel_QMARK_(max);
var state_57587__$1 = (function (){var statearr_57610 = state_57587;
(statearr_57610[(8)] = inst_57559);

return statearr_57610;
})();
if(inst_57560){
var statearr_57611_57634 = state_57587__$1;
(statearr_57611_57634[(1)] = (10));

} else {
var statearr_57612_57635 = state_57587__$1;
(statearr_57612_57635[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_57613 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57613[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_57613[(1)] = (1));

return statearr_57613;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_57587){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57587);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57614){var ex__2730__auto__ = e57614;
var statearr_57615_57636 = state_57587;
(statearr_57615_57636[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57587[(4)]))){
var statearr_57616_57637 = state_57587;
(statearr_57616_57637[(1)] = cljs.core.first((state_57587[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57638 = state_57587;
state_57587 = G__57638;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_57587){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_57587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57617 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57617[(6)] = c__2749__auto__);

return statearr_57617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57659){
var state_val_57660 = (state_57659[(1)]);
if((state_val_57660 === (1))){
var state_57659__$1 = state_57659;
var statearr_57661_57676 = state_57659__$1;
(statearr_57661_57676[(2)] = null);

(statearr_57661_57676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57660 === (2))){
var _ = (function (){var statearr_57662 = state_57659;
(statearr_57662[(4)] = cljs.core.cons((5),(state_57659[(4)])));

return statearr_57662;
})();
var inst_57645 = fluree.db.util.core.random_uuid();
var inst_57646 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57645);
var inst_57647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57648 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57649 = cljs.core.PersistentVector.EMPTY;
var inst_57650 = ["uuid",inst_57649,inst_57646];
var inst_57651 = cljs.core.PersistentHashMap.fromArrays(inst_57648,inst_57650);
var inst_57652 = [inst_57651,(10)];
var inst_57653 = (new cljs.core.PersistentVector(null,2,(5),inst_57647,inst_57652,null));
var inst_57654 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57653);
var ___$1 = (function (){var statearr_57663 = state_57659;
(statearr_57663[(4)] = cljs.core.rest((state_57659[(4)])));

return statearr_57663;
})();
var state_57659__$1 = (function (){var statearr_57664 = state_57659;
(statearr_57664[(7)] = inst_57654);

return statearr_57664;
})();
var statearr_57665_57677 = state_57659__$1;
(statearr_57665_57677[(2)] = inst_57646);

(statearr_57665_57677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57660 === (3))){
var inst_57657 = (state_57659[(2)]);
var state_57659__$1 = state_57659;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57659__$1,inst_57657);
} else {
if((state_val_57660 === (4))){
var inst_57639 = (state_57659[(2)]);
var state_57659__$1 = state_57659;
var statearr_57667_57678 = state_57659__$1;
(statearr_57667_57678[(2)] = inst_57639);

(statearr_57667_57678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57660 === (5))){
var _ = (function (){var statearr_57668 = state_57659;
(statearr_57668[(4)] = cljs.core.rest((state_57659[(4)])));

return statearr_57668;
})();
var state_57659__$1 = state_57659;
var ex57666 = (state_57659__$1[(2)]);
var statearr_57669_57679 = state_57659__$1;
(statearr_57669_57679[(5)] = ex57666);


if((ex57666 instanceof Error)){
var statearr_57670_57680 = state_57659__$1;
(statearr_57670_57680[(1)] = (4));

(statearr_57670_57680[(5)] = null);

} else {
throw ex57666;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0 = (function (){
var statearr_57671 = [null,null,null,null,null,null,null,null];
(statearr_57671[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__);

(statearr_57671[(1)] = (1));

return statearr_57671;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1 = (function (state_57659){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57659);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57672){var ex__2730__auto__ = e57672;
var statearr_57673_57681 = state_57659;
(statearr_57673_57681[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57659[(4)]))){
var statearr_57674_57682 = state_57659;
(statearr_57674_57682[(1)] = cljs.core.first((state_57659[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57683 = state_57659;
state_57659 = G__57683;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = function(state_57659){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1.call(this,state_57659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57675 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57675[(6)] = c__2749__auto__);

return statearr_57675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57713){
var state_val_57714 = (state_57713[(1)]);
if((state_val_57714 === (7))){
var state_57713__$1 = state_57713;
var statearr_57715_57734 = state_57713__$1;
(statearr_57715_57734[(2)] = num);

(statearr_57715_57734[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57714 === (1))){
var state_57713__$1 = state_57713;
var statearr_57716_57735 = state_57713__$1;
(statearr_57716_57735[(2)] = null);

(statearr_57716_57735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57714 === (4))){
var inst_57684 = (state_57713[(2)]);
var state_57713__$1 = state_57713;
var statearr_57717_57736 = state_57713__$1;
(statearr_57717_57736[(2)] = inst_57684);

(statearr_57717_57736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57714 === (6))){
var state_57713__$1 = state_57713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57713__$1,(9),num);
} else {
if((state_val_57714 === (3))){
var inst_57711 = (state_57713[(2)]);
var state_57713__$1 = state_57713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57713__$1,inst_57711);
} else {
if((state_val_57714 === (2))){
var _ = (function (){var statearr_57719 = state_57713;
(statearr_57719[(4)] = cljs.core.cons((5),(state_57713[(4)])));

return statearr_57719;
})();
var inst_57690 = fluree.db.util.async.channel_QMARK_(num);
var state_57713__$1 = state_57713;
if(inst_57690){
var statearr_57720_57737 = state_57713__$1;
(statearr_57720_57737[(1)] = (6));

} else {
var statearr_57721_57738 = state_57713__$1;
(statearr_57721_57738[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57714 === (9))){
var inst_57693 = (state_57713[(2)]);
var inst_57694 = fluree.db.util.async.throw_err(inst_57693);
var state_57713__$1 = state_57713;
var statearr_57722_57739 = state_57713__$1;
(statearr_57722_57739[(2)] = inst_57694);

(statearr_57722_57739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57714 === (5))){
var _ = (function (){var statearr_57723 = state_57713;
(statearr_57723[(4)] = cljs.core.rest((state_57713[(4)])));

return statearr_57723;
})();
var state_57713__$1 = state_57713;
var ex57718 = (state_57713__$1[(2)]);
var statearr_57724_57740 = state_57713__$1;
(statearr_57724_57740[(5)] = ex57718);


if((ex57718 instanceof Error)){
var statearr_57725_57741 = state_57713__$1;
(statearr_57725_57741[(1)] = (4));

(statearr_57725_57741[(5)] = null);

} else {
throw ex57718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57714 === (8))){
var inst_57697 = (state_57713[(2)]);
var inst_57698 = fluree.db.dbfunctions.internal.ceil(inst_57697);
var inst_57699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57700 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57702 = [fluree.db.dbfunctions.fns.ceil];
var inst_57703 = (new cljs.core.PersistentVector(null,1,(5),inst_57701,inst_57702,null));
var inst_57704 = ["",inst_57703,inst_57698];
var inst_57705 = cljs.core.PersistentHashMap.fromArrays(inst_57700,inst_57704);
var inst_57706 = [inst_57705,(10)];
var inst_57707 = (new cljs.core.PersistentVector(null,2,(5),inst_57699,inst_57706,null));
var inst_57708 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57707);
var _ = (function (){var statearr_57726 = state_57713;
(statearr_57726[(4)] = cljs.core.rest((state_57713[(4)])));

return statearr_57726;
})();
var state_57713__$1 = (function (){var statearr_57727 = state_57713;
(statearr_57727[(7)] = inst_57708);

return statearr_57727;
})();
var statearr_57728_57742 = state_57713__$1;
(statearr_57728_57742[(2)] = inst_57698);

(statearr_57728_57742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0 = (function (){
var statearr_57729 = [null,null,null,null,null,null,null,null];
(statearr_57729[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__);

(statearr_57729[(1)] = (1));

return statearr_57729;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1 = (function (state_57713){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57713);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57730){var ex__2730__auto__ = e57730;
var statearr_57731_57743 = state_57713;
(statearr_57731_57743[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57713[(4)]))){
var statearr_57732_57744 = state_57713;
(statearr_57732_57744[(1)] = cljs.core.first((state_57713[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57745 = state_57713;
state_57713 = G__57745;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = function(state_57713){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1.call(this,state_57713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57733 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57733[(6)] = c__2749__auto__);

return statearr_57733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57775){
var state_val_57776 = (state_57775[(1)]);
if((state_val_57776 === (7))){
var state_57775__$1 = state_57775;
var statearr_57777_57796 = state_57775__$1;
(statearr_57777_57796[(2)] = num);

(statearr_57777_57796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57776 === (1))){
var state_57775__$1 = state_57775;
var statearr_57778_57797 = state_57775__$1;
(statearr_57778_57797[(2)] = null);

(statearr_57778_57797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57776 === (4))){
var inst_57746 = (state_57775[(2)]);
var state_57775__$1 = state_57775;
var statearr_57779_57798 = state_57775__$1;
(statearr_57779_57798[(2)] = inst_57746);

(statearr_57779_57798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57776 === (6))){
var state_57775__$1 = state_57775;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57775__$1,(9),num);
} else {
if((state_val_57776 === (3))){
var inst_57773 = (state_57775[(2)]);
var state_57775__$1 = state_57775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57775__$1,inst_57773);
} else {
if((state_val_57776 === (2))){
var _ = (function (){var statearr_57781 = state_57775;
(statearr_57781[(4)] = cljs.core.cons((5),(state_57775[(4)])));

return statearr_57781;
})();
var inst_57752 = fluree.db.util.async.channel_QMARK_(num);
var state_57775__$1 = state_57775;
if(inst_57752){
var statearr_57782_57799 = state_57775__$1;
(statearr_57782_57799[(1)] = (6));

} else {
var statearr_57783_57800 = state_57775__$1;
(statearr_57783_57800[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57776 === (9))){
var inst_57755 = (state_57775[(2)]);
var inst_57756 = fluree.db.util.async.throw_err(inst_57755);
var state_57775__$1 = state_57775;
var statearr_57784_57801 = state_57775__$1;
(statearr_57784_57801[(2)] = inst_57756);

(statearr_57784_57801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57776 === (5))){
var _ = (function (){var statearr_57785 = state_57775;
(statearr_57785[(4)] = cljs.core.rest((state_57775[(4)])));

return statearr_57785;
})();
var state_57775__$1 = state_57775;
var ex57780 = (state_57775__$1[(2)]);
var statearr_57786_57802 = state_57775__$1;
(statearr_57786_57802[(5)] = ex57780);


if((ex57780 instanceof Error)){
var statearr_57787_57803 = state_57775__$1;
(statearr_57787_57803[(1)] = (4));

(statearr_57787_57803[(5)] = null);

} else {
throw ex57780;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57776 === (8))){
var inst_57759 = (state_57775[(2)]);
var inst_57760 = fluree.db.dbfunctions.internal.floor(inst_57759);
var inst_57761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57762 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57764 = [fluree.db.dbfunctions.fns.floor];
var inst_57765 = (new cljs.core.PersistentVector(null,1,(5),inst_57763,inst_57764,null));
var inst_57766 = ["",inst_57765,inst_57760];
var inst_57767 = cljs.core.PersistentHashMap.fromArrays(inst_57762,inst_57766);
var inst_57768 = [inst_57767,(10)];
var inst_57769 = (new cljs.core.PersistentVector(null,2,(5),inst_57761,inst_57768,null));
var inst_57770 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57769);
var _ = (function (){var statearr_57788 = state_57775;
(statearr_57788[(4)] = cljs.core.rest((state_57775[(4)])));

return statearr_57788;
})();
var state_57775__$1 = (function (){var statearr_57789 = state_57775;
(statearr_57789[(7)] = inst_57770);

return statearr_57789;
})();
var statearr_57790_57804 = state_57775__$1;
(statearr_57790_57804[(2)] = inst_57760);

(statearr_57790_57804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0 = (function (){
var statearr_57791 = [null,null,null,null,null,null,null,null];
(statearr_57791[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__);

(statearr_57791[(1)] = (1));

return statearr_57791;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1 = (function (state_57775){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57775);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57792){var ex__2730__auto__ = e57792;
var statearr_57793_57805 = state_57775;
(statearr_57793_57805[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57775[(4)]))){
var statearr_57794_57806 = state_57775;
(statearr_57794_57806[(1)] = cljs.core.first((state_57775[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57807 = state_57775;
state_57775 = G__57807;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = function(state_57775){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1.call(this,state_57775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57795 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57795[(6)] = c__2749__auto__);

return statearr_57795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57832){
var state_val_57833 = (state_57832[(1)]);
if((state_val_57833 === (1))){
var state_57832__$1 = state_57832;
var statearr_57834_57849 = state_57832__$1;
(statearr_57834_57849[(2)] = null);

(statearr_57834_57849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57833 === (2))){
var _ = (function (){var statearr_57835 = state_57832;
(statearr_57835[(4)] = cljs.core.cons((5),(state_57832[(4)])));

return statearr_57835;
})();
var inst_57814 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_57832__$1 = state_57832;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57832__$1,(6),inst_57814);
} else {
if((state_val_57833 === (3))){
var inst_57830 = (state_57832[(2)]);
var state_57832__$1 = state_57832;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57832__$1,inst_57830);
} else {
if((state_val_57833 === (4))){
var inst_57808 = (state_57832[(2)]);
var state_57832__$1 = state_57832;
var statearr_57837_57850 = state_57832__$1;
(statearr_57837_57850[(2)] = inst_57808);

(statearr_57837_57850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57833 === (5))){
var _ = (function (){var statearr_57838 = state_57832;
(statearr_57838[(4)] = cljs.core.rest((state_57832[(4)])));

return statearr_57838;
})();
var state_57832__$1 = state_57832;
var ex57836 = (state_57832__$1[(2)]);
var statearr_57839_57851 = state_57832__$1;
(statearr_57839_57851[(5)] = ex57836);


if((ex57836 instanceof Error)){
var statearr_57840_57852 = state_57832__$1;
(statearr_57840_57852[(1)] = (4));

(statearr_57840_57852[(5)] = null);

} else {
throw ex57836;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57833 === (6))){
var inst_57816 = (state_57832[(2)]);
var inst_57817 = fluree.db.util.async.throw_err(inst_57816);
var inst_57818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57819 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57821 = [compare_val,new_val];
var inst_57822 = (new cljs.core.PersistentVector(null,2,(5),inst_57820,inst_57821,null));
var inst_57823 = ["",inst_57822,inst_57817];
var inst_57824 = cljs.core.PersistentHashMap.fromArrays(inst_57819,inst_57823);
var inst_57825 = [inst_57824,(10)];
var inst_57826 = (new cljs.core.PersistentVector(null,2,(5),inst_57818,inst_57825,null));
var inst_57827 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57826);
var _ = (function (){var statearr_57841 = state_57832;
(statearr_57841[(4)] = cljs.core.rest((state_57832[(4)])));

return statearr_57841;
})();
var state_57832__$1 = (function (){var statearr_57842 = state_57832;
(statearr_57842[(7)] = inst_57827);

return statearr_57842;
})();
var statearr_57843_57853 = state_57832__$1;
(statearr_57843_57853[(2)] = inst_57817);

(statearr_57843_57853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_57844 = [null,null,null,null,null,null,null,null];
(statearr_57844[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__);

(statearr_57844[(1)] = (1));

return statearr_57844;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1 = (function (state_57832){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57832);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57845){var ex__2730__auto__ = e57845;
var statearr_57846_57854 = state_57832;
(statearr_57846_57854[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57832[(4)]))){
var statearr_57847_57855 = state_57832;
(statearr_57847_57855[(1)] = cljs.core.first((state_57832[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57856 = state_57832;
state_57832 = G__57856;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = function(state_57832){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1.call(this,state_57832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57848 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57848[(6)] = c__2749__auto__);

return statearr_57848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
