// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__63997 = arguments.length;
switch (G__63997) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___64036 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64018){
var state_val_64019 = (state_64018[(1)]);
if((state_val_64019 === (1))){
var state_64018__$1 = state_64018;
var statearr_64020_64037 = state_64018__$1;
(statearr_64020_64037[(2)] = null);

(statearr_64020_64037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64019 === (2))){
var _ = (function (){var statearr_64021 = state_64018;
(statearr_64021[(4)] = cljs.core.cons((5),(state_64018[(4)])));

return statearr_64021;
})();
var inst_64004 = fluree.db.session.db(conn,ledger,null);
var state_64018__$1 = state_64018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64018__$1,(7),inst_64004);
} else {
if((state_val_64019 === (3))){
var inst_64014 = (state_64018[(2)]);
var inst_64015 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64014);
var inst_64016 = cljs.core.async.close_BANG_(pc);
var state_64018__$1 = (function (){var statearr_64023 = state_64018;
(statearr_64023[(7)] = inst_64015);

return statearr_64023;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64018__$1,inst_64016);
} else {
if((state_val_64019 === (4))){
var inst_63998 = (state_64018[(2)]);
var state_64018__$1 = state_64018;
var statearr_64024_64038 = state_64018__$1;
(statearr_64024_64038[(2)] = inst_63998);

(statearr_64024_64038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64019 === (5))){
var _ = (function (){var statearr_64025 = state_64018;
(statearr_64025[(4)] = cljs.core.rest((state_64018[(4)])));

return statearr_64025;
})();
var state_64018__$1 = state_64018;
var ex64022 = (state_64018__$1[(2)]);
var statearr_64026_64039 = state_64018__$1;
(statearr_64026_64039[(5)] = ex64022);


var statearr_64027_64040 = state_64018__$1;
(statearr_64027_64040[(1)] = (4));

(statearr_64027_64040[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64019 === (6))){
var inst_64010 = (state_64018[(2)]);
var inst_64011 = fluree.db.util.async.throw_err(inst_64010);
var _ = (function (){var statearr_64028 = state_64018;
(statearr_64028[(4)] = cljs.core.rest((state_64018[(4)])));

return statearr_64028;
})();
var state_64018__$1 = state_64018;
var statearr_64029_64041 = state_64018__$1;
(statearr_64029_64041[(2)] = inst_64011);

(statearr_64029_64041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64019 === (7))){
var inst_64006 = (state_64018[(2)]);
var inst_64007 = fluree.db.util.async.throw_err(inst_64006);
var inst_64008 = fluree.db.time_travel.as_of_block(inst_64007,block);
var state_64018__$1 = state_64018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64018__$1,(6),inst_64008);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_64030 = [null,null,null,null,null,null,null,null];
(statearr_64030[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_64030[(1)] = (1));

return statearr_64030;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_64018){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64018);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64031){var ex__2730__auto__ = e64031;
var statearr_64032_64042 = state_64018;
(statearr_64032_64042[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64018[(4)]))){
var statearr_64033_64043 = state_64018;
(statearr_64033_64043[(1)] = cljs.core.first((state_64018[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64044 = state_64018;
state_64018 = G__64044;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_64018){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_64018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64034 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64034[(6)] = c__2749__auto___64036);

return statearr_64034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64085){
var state_val_64086 = (state_64085[(1)]);
if((state_val_64086 === (7))){
var inst_64054 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64085__$1 = state_64085;
if(inst_64054){
var statearr_64087_64118 = state_64085__$1;
(statearr_64087_64118[(1)] = (9));

} else {
var statearr_64088_64119 = state_64085__$1;
(statearr_64088_64119[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (1))){
var state_64085__$1 = state_64085;
var statearr_64089_64120 = state_64085__$1;
(statearr_64089_64120[(2)] = null);

(statearr_64089_64120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (4))){
var inst_64045 = (state_64085[(2)]);
var state_64085__$1 = state_64085;
var statearr_64090_64121 = state_64085__$1;
(statearr_64090_64121[(2)] = inst_64045);

(statearr_64090_64121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (15))){
var inst_64062 = (state_64085[(7)]);
var inst_64061 = (state_64085[(2)]);
var inst_64062__$1 = fluree.db.util.async.throw_err(inst_64061);
var state_64085__$1 = (function (){var statearr_64091 = state_64085;
(statearr_64091[(7)] = inst_64062__$1);

return statearr_64091;
})();
if(cljs.core.truth_(inst_64062__$1)){
var statearr_64092_64122 = state_64085__$1;
(statearr_64092_64122[(1)] = (16));

} else {
var statearr_64093_64123 = state_64085__$1;
(statearr_64093_64123[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (13))){
var state_64085__$1 = state_64085;
var statearr_64094_64124 = state_64085__$1;
(statearr_64094_64124[(2)] = null);

(statearr_64094_64124[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (6))){
var state_64085__$1 = state_64085;
var statearr_64095_64125 = state_64085__$1;
(statearr_64095_64125[(2)] = db);

(statearr_64095_64125[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (17))){
var inst_64066 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64067 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64068 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64069 = cljs.core.PersistentHashMap.fromArrays(inst_64067,inst_64068);
var inst_64070 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64066,inst_64069);
var inst_64071 = (function(){throw inst_64070})();
var state_64085__$1 = state_64085;
var statearr_64096_64126 = state_64085__$1;
(statearr_64096_64126[(2)] = inst_64071);

(statearr_64096_64126[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (3))){
var inst_64083 = (state_64085[(2)]);
var state_64085__$1 = state_64085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64085__$1,inst_64083);
} else {
if((state_val_64086 === (12))){
var inst_64059 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64085__$1 = state_64085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64085__$1,(15),inst_64059);
} else {
if((state_val_64086 === (2))){
var _ = (function (){var statearr_64097 = state_64085;
(statearr_64097[(4)] = cljs.core.cons((5),(state_64085[(4)])));

return statearr_64097;
})();
var inst_64051 = cljs.core.not(auth);
var state_64085__$1 = state_64085;
if(inst_64051){
var statearr_64098_64127 = state_64085__$1;
(statearr_64098_64127[(1)] = (6));

} else {
var statearr_64099_64128 = state_64085__$1;
(statearr_64099_64128[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (11))){
var inst_64078 = (state_64085[(2)]);
var state_64085__$1 = state_64085;
var statearr_64101_64129 = state_64085__$1;
(statearr_64101_64129[(2)] = inst_64078);

(statearr_64101_64129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (9))){
var inst_64056 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_64085__$1 = state_64085;
var statearr_64102_64130 = state_64085__$1;
(statearr_64102_64130[(2)] = inst_64056);

(statearr_64102_64130[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (5))){
var _ = (function (){var statearr_64103 = state_64085;
(statearr_64103[(4)] = cljs.core.rest((state_64085[(4)])));

return statearr_64103;
})();
var state_64085__$1 = state_64085;
var ex64100 = (state_64085__$1[(2)]);
var statearr_64104_64131 = state_64085__$1;
(statearr_64104_64131[(5)] = ex64100);


if((ex64100 instanceof Error)){
var statearr_64105_64132 = state_64085__$1;
(statearr_64105_64132[(1)] = (4));

(statearr_64105_64132[(5)] = null);

} else {
throw ex64100;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (14))){
var inst_64076 = (state_64085[(2)]);
var state_64085__$1 = state_64085;
var statearr_64106_64133 = state_64085__$1;
(statearr_64106_64133[(2)] = inst_64076);

(statearr_64106_64133[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (16))){
var inst_64062 = (state_64085[(7)]);
var inst_64064 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64062);
var state_64085__$1 = state_64085;
var statearr_64107_64134 = state_64085__$1;
(statearr_64107_64134[(2)] = inst_64064);

(statearr_64107_64134[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (10))){
var state_64085__$1 = state_64085;
var statearr_64108_64135 = state_64085__$1;
(statearr_64108_64135[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (18))){
var inst_64073 = (state_64085[(2)]);
var state_64085__$1 = state_64085;
var statearr_64110_64136 = state_64085__$1;
(statearr_64110_64136[(2)] = inst_64073);

(statearr_64110_64136[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64086 === (8))){
var inst_64080 = (state_64085[(2)]);
var _ = (function (){var statearr_64111 = state_64085;
(statearr_64111[(4)] = cljs.core.rest((state_64085[(4)])));

return statearr_64111;
})();
var state_64085__$1 = state_64085;
var statearr_64112_64137 = state_64085__$1;
(statearr_64112_64137[(2)] = inst_64080);

(statearr_64112_64137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_64113 = [null,null,null,null,null,null,null,null];
(statearr_64113[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_64113[(1)] = (1));

return statearr_64113;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_64085){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64085);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64114){var ex__2730__auto__ = e64114;
var statearr_64115_64138 = state_64085;
(statearr_64115_64138[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64085[(4)]))){
var statearr_64116_64139 = state_64085;
(statearr_64116_64139[(1)] = cljs.core.first((state_64085[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64140 = state_64085;
state_64085 = G__64140;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_64085){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_64085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64117 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64117[(6)] = c__2749__auto__);

return statearr_64117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64204){
var state_val_64205 = (state_64204[(1)]);
if((state_val_64205 === (7))){
var inst_64150 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64204__$1 = state_64204;
if(inst_64150){
var statearr_64206_64255 = state_64204__$1;
(statearr_64206_64255[(1)] = (9));

} else {
var statearr_64207_64256 = state_64204__$1;
(statearr_64207_64256[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (20))){
var inst_64174 = (state_64204[(7)]);
var state_64204__$1 = state_64204;
if(cljs.core.truth_(inst_64174)){
var statearr_64208_64257 = state_64204__$1;
(statearr_64208_64257[(1)] = (22));

} else {
var statearr_64209_64258 = state_64204__$1;
(statearr_64209_64258[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (27))){
var state_64204__$1 = state_64204;
var statearr_64210_64259 = state_64204__$1;
(statearr_64210_64259[(2)] = null);

(statearr_64210_64259[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (1))){
var state_64204__$1 = state_64204;
var statearr_64211_64260 = state_64204__$1;
(statearr_64211_64260[(2)] = null);

(statearr_64211_64260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (24))){
var inst_64188 = (state_64204[(2)]);
var state_64204__$1 = state_64204;
var statearr_64212_64261 = state_64204__$1;
(statearr_64212_64261[(2)] = inst_64188);

(statearr_64212_64261[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (4))){
var inst_64141 = (state_64204[(2)]);
var state_64204__$1 = state_64204;
var statearr_64213_64262 = state_64204__$1;
(statearr_64213_64262[(2)] = inst_64141);

(statearr_64213_64262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (15))){
var inst_64157 = (state_64204[(8)]);
var inst_64156 = (state_64204[(2)]);
var inst_64157__$1 = fluree.db.util.async.throw_err(inst_64156);
var state_64204__$1 = (function (){var statearr_64214 = state_64204;
(statearr_64214[(8)] = inst_64157__$1);

return statearr_64214;
})();
if(cljs.core.truth_(inst_64157__$1)){
var statearr_64215_64263 = state_64204__$1;
(statearr_64215_64263[(1)] = (16));

} else {
var statearr_64216_64264 = state_64204__$1;
(statearr_64216_64264[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (21))){
var inst_64190 = (state_64204[(9)]);
var inst_64190__$1 = (state_64204[(2)]);
var state_64204__$1 = (function (){var statearr_64217 = state_64204;
(statearr_64217[(9)] = inst_64190__$1);

return statearr_64217;
})();
if(cljs.core.truth_(inst_64190__$1)){
var statearr_64218_64265 = state_64204__$1;
(statearr_64218_64265[(1)] = (29));

} else {
var statearr_64219_64266 = state_64204__$1;
(statearr_64219_64266[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (31))){
var inst_64190 = (state_64204[(9)]);
var inst_64174 = (state_64204[(7)]);
var inst_64198 = (state_64204[(2)]);
var inst_64199 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64174,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_64190,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_64198], 0));
var _ = (function (){var statearr_64220 = state_64204;
(statearr_64220[(4)] = cljs.core.rest((state_64204[(4)])));

return statearr_64220;
})();
var state_64204__$1 = state_64204;
var statearr_64221_64267 = state_64204__$1;
(statearr_64221_64267[(2)] = inst_64199);

(statearr_64221_64267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (32))){
var inst_64194 = (state_64204[(2)]);
var inst_64195 = fluree.db.util.async.throw_err(inst_64194);
var state_64204__$1 = state_64204;
var statearr_64222_64268 = state_64204__$1;
(statearr_64222_64268[(2)] = inst_64195);

(statearr_64222_64268[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (13))){
var state_64204__$1 = state_64204;
var statearr_64223_64269 = state_64204__$1;
(statearr_64223_64269[(2)] = null);

(statearr_64223_64269[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (22))){
var inst_64174 = (state_64204[(7)]);
var inst_64178 = fluree.db.auth.roles(db,inst_64174);
var state_64204__$1 = state_64204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64204__$1,(25),inst_64178);
} else {
if((state_val_64205 === (29))){
var inst_64190 = (state_64204[(9)]);
var inst_64192 = fluree.db.permissions.permission_map(db,inst_64190,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_64204__$1 = state_64204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64204__$1,(32),inst_64192);
} else {
if((state_val_64205 === (6))){
var state_64204__$1 = state_64204;
var statearr_64224_64270 = state_64204__$1;
(statearr_64224_64270[(2)] = null);

(statearr_64224_64270[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (28))){
var inst_64186 = (state_64204[(2)]);
var state_64204__$1 = state_64204;
var statearr_64225_64271 = state_64204__$1;
(statearr_64225_64271[(2)] = inst_64186);

(statearr_64225_64271[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (25))){
var inst_64180 = (state_64204[(2)]);
var inst_64181 = fluree.db.util.async.throw_err(inst_64180);
var state_64204__$1 = state_64204;
var statearr_64226_64272 = state_64204__$1;
(statearr_64226_64272[(2)] = inst_64181);

(statearr_64226_64272[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (17))){
var inst_64160 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64161 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64162 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64163 = cljs.core.PersistentHashMap.fromArrays(inst_64161,inst_64162);
var inst_64164 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64160,inst_64163);
var inst_64165 = (function(){throw inst_64164})();
var state_64204__$1 = state_64204;
var statearr_64227_64273 = state_64204__$1;
(statearr_64227_64273[(2)] = inst_64165);

(statearr_64227_64273[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (3))){
var inst_64202 = (state_64204[(2)]);
var state_64204__$1 = state_64204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64204__$1,inst_64202);
} else {
if((state_val_64205 === (12))){
var inst_64154 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64204__$1 = state_64204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64204__$1,(15),inst_64154);
} else {
if((state_val_64205 === (2))){
var _ = (function (){var statearr_64228 = state_64204;
(statearr_64228[(4)] = cljs.core.cons((5),(state_64204[(4)])));

return statearr_64228;
})();
var inst_64147 = (auth == null);
var state_64204__$1 = state_64204;
if(cljs.core.truth_(inst_64147)){
var statearr_64229_64274 = state_64204__$1;
(statearr_64229_64274[(1)] = (6));

} else {
var statearr_64230_64275 = state_64204__$1;
(statearr_64230_64275[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (23))){
var state_64204__$1 = state_64204;
var statearr_64231_64276 = state_64204__$1;
(statearr_64231_64276[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (19))){
var state_64204__$1 = state_64204;
var statearr_64233_64277 = state_64204__$1;
(statearr_64233_64277[(2)] = roles);

(statearr_64233_64277[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (11))){
var inst_64172 = (state_64204[(2)]);
var state_64204__$1 = state_64204;
var statearr_64235_64278 = state_64204__$1;
(statearr_64235_64278[(2)] = inst_64172);

(statearr_64235_64278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (9))){
var state_64204__$1 = state_64204;
var statearr_64236_64279 = state_64204__$1;
(statearr_64236_64279[(2)] = (0));

(statearr_64236_64279[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (5))){
var _ = (function (){var statearr_64237 = state_64204;
(statearr_64237[(4)] = cljs.core.rest((state_64204[(4)])));

return statearr_64237;
})();
var state_64204__$1 = state_64204;
var ex64234 = (state_64204__$1[(2)]);
var statearr_64238_64280 = state_64204__$1;
(statearr_64238_64280[(5)] = ex64234);


if((ex64234 instanceof Error)){
var statearr_64239_64281 = state_64204__$1;
(statearr_64239_64281[(1)] = (4));

(statearr_64239_64281[(5)] = null);

} else {
throw ex64234;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (14))){
var inst_64170 = (state_64204[(2)]);
var state_64204__$1 = state_64204;
var statearr_64240_64282 = state_64204__$1;
(statearr_64240_64282[(2)] = inst_64170);

(statearr_64240_64282[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (26))){
var state_64204__$1 = state_64204;
var statearr_64241_64283 = state_64204__$1;
(statearr_64241_64283[(2)] = null);

(statearr_64241_64283[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (16))){
var inst_64157 = (state_64204[(8)]);
var state_64204__$1 = state_64204;
var statearr_64242_64284 = state_64204__$1;
(statearr_64242_64284[(2)] = inst_64157);

(statearr_64242_64284[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (30))){
var state_64204__$1 = state_64204;
var statearr_64243_64285 = state_64204__$1;
(statearr_64243_64285[(2)] = null);

(statearr_64243_64285[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (10))){
var state_64204__$1 = state_64204;
if(cljs.core.truth_(auth)){
var statearr_64244_64286 = state_64204__$1;
(statearr_64244_64286[(1)] = (12));

} else {
var statearr_64245_64287 = state_64204__$1;
(statearr_64245_64287[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (18))){
var inst_64167 = (state_64204[(2)]);
var state_64204__$1 = state_64204;
var statearr_64246_64288 = state_64204__$1;
(statearr_64246_64288[(2)] = inst_64167);

(statearr_64246_64288[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64205 === (8))){
var inst_64174 = (state_64204[(2)]);
var state_64204__$1 = (function (){var statearr_64247 = state_64204;
(statearr_64247[(7)] = inst_64174);

return statearr_64247;
})();
if(cljs.core.truth_(roles)){
var statearr_64248_64289 = state_64204__$1;
(statearr_64248_64289[(1)] = (19));

} else {
var statearr_64249_64290 = state_64204__$1;
(statearr_64249_64290[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_64250 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64250[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_64250[(1)] = (1));

return statearr_64250;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_64204){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64204);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64251){var ex__2730__auto__ = e64251;
var statearr_64252_64291 = state_64204;
(statearr_64252_64291[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64204[(4)]))){
var statearr_64253_64292 = state_64204;
(statearr_64253_64292[(1)] = cljs.core.first((state_64204[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64293 = state_64204;
state_64204 = G__64293;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_64204){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_64204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64254 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64254[(6)] = c__2749__auto__);

return statearr_64254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__64294 = db;
var map__64294__$1 = cljs.core.__destructure_map(map__64294);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64294__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64294__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64294__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64301){
var state_val_64302 = (state_64301[(1)]);
if((state_val_64302 === (1))){
var inst_64295 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64296 = fluree.db.session.db(conn,inst_64295,null);
var state_64301__$1 = state_64301;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64301__$1,(2),inst_64296);
} else {
if((state_val_64302 === (2))){
var inst_64298 = (state_64301[(2)]);
var inst_64299 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64298);
var state_64301__$1 = state_64301;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64301__$1,inst_64299);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_64303 = [null,null,null,null,null,null,null];
(statearr_64303[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_64303[(1)] = (1));

return statearr_64303;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_64301){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64301);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64304){var ex__2730__auto__ = e64304;
var statearr_64305_64332 = state_64301;
(statearr_64305_64332[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64301[(4)]))){
var statearr_64306_64333 = state_64301;
(statearr_64306_64333[(1)] = cljs.core.first((state_64301[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64334 = state_64301;
state_64301 = G__64334;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_64301){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_64301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64307 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64307[(6)] = c__2749__auto__);

return statearr_64307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64320){
var state_val_64321 = (state_64320[(1)]);
if((state_val_64321 === (1))){
var inst_64308 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64309 = fluree.db.session.db(conn,inst_64308,null);
var state_64320__$1 = state_64320;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64320__$1,(2),inst_64309);
} else {
if((state_val_64321 === (2))){
var inst_64311 = (state_64320[(7)]);
var inst_64311__$1 = (state_64320[(2)]);
var inst_64312 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64311__$1);
var inst_64313 = newer_block_QMARK_(inst_64312);
var state_64320__$1 = (function (){var statearr_64322 = state_64320;
(statearr_64322[(7)] = inst_64311__$1);

return statearr_64322;
})();
if(inst_64313){
var statearr_64323_64335 = state_64320__$1;
(statearr_64323_64335[(1)] = (3));

} else {
var statearr_64324_64336 = state_64320__$1;
(statearr_64324_64336[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (3))){
var inst_64311 = (state_64320[(7)]);
var inst_64315 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64311);
var state_64320__$1 = state_64320;
var statearr_64325_64337 = state_64320__$1;
(statearr_64325_64337[(2)] = inst_64315);

(statearr_64325_64337[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (4))){
var state_64320__$1 = state_64320;
var statearr_64326_64338 = state_64320__$1;
(statearr_64326_64338[(2)] = null);

(statearr_64326_64338[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (5))){
var inst_64318 = (state_64320[(2)]);
var state_64320__$1 = state_64320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64320__$1,inst_64318);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_64327 = [null,null,null,null,null,null,null,null];
(statearr_64327[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_64327[(1)] = (1));

return statearr_64327;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_64320){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64320);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64328){var ex__2730__auto__ = e64328;
var statearr_64329_64339 = state_64320;
(statearr_64329_64339[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64320[(4)]))){
var statearr_64330_64340 = state_64320;
(statearr_64330_64340[(1)] = cljs.core.first((state_64320[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64341 = state_64320;
state_64320 = G__64341;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_64320){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_64320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64331 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64331[(6)] = c__2749__auto__);

return statearr_64331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__64342 = db;
var map__64342__$1 = cljs.core.__destructure_map(map__64342);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64342__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64342__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64342__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___64418 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64392){
var state_val_64393 = (state_64392[(1)]);
if((state_val_64393 === (7))){
var inst_64358 = (state_64392[(7)]);
var inst_64369 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64358,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_64392__$1 = state_64392;
if(inst_64369){
var statearr_64394_64419 = state_64392__$1;
(statearr_64394_64419[(1)] = (9));

} else {
var statearr_64395_64420 = state_64392__$1;
(statearr_64395_64420[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (1))){
var inst_64351 = (state_64392[(8)]);
var inst_64343 = (state_64392[(9)]);
var inst_64343__$1 = cljs.core.async.timeout(timeout);
var inst_64351__$1 = res_port;
var inst_64352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64353 = [inst_64343__$1,inst_64351__$1];
var inst_64354 = (new cljs.core.PersistentVector(null,2,(5),inst_64352,inst_64353,null));
var state_64392__$1 = (function (){var statearr_64396 = state_64392;
(statearr_64396[(8)] = inst_64351__$1);

(statearr_64396[(9)] = inst_64343__$1);

return statearr_64396;
})();
return cljs.core.async.ioc_alts_BANG_(state_64392__$1,(2),inst_64354);
} else {
if((state_val_64393 === (4))){
var inst_64351 = (state_64392[(8)]);
var inst_64358 = (state_64392[(7)]);
var inst_64362 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64358,inst_64351);
var state_64392__$1 = state_64392;
if(inst_64362){
var statearr_64397_64421 = state_64392__$1;
(statearr_64397_64421[(1)] = (6));

} else {
var statearr_64398_64422 = state_64392__$1;
(statearr_64398_64422[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (13))){
var inst_64377 = (state_64392[(10)]);
var inst_64388 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64377);
var state_64392__$1 = state_64392;
var statearr_64399_64423 = state_64392__$1;
(statearr_64399_64423[(2)] = inst_64388);

(statearr_64399_64423[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (6))){
var inst_64356 = (state_64392[(11)]);
var inst_64367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64356,(0),null);
var state_64392__$1 = state_64392;
var statearr_64400_64424 = state_64392__$1;
(statearr_64400_64424[(2)] = inst_64367);

(statearr_64400_64424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (3))){
var state_64392__$1 = state_64392;
var statearr_64401_64425 = state_64392__$1;
(statearr_64401_64425[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_64401_64425[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (12))){
var inst_64381 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_64382 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64383 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_64384 = cljs.core.PersistentHashMap.fromArrays(inst_64382,inst_64383);
var inst_64385 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64381,inst_64384);
var inst_64386 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64385);
var state_64392__$1 = state_64392;
var statearr_64402_64426 = state_64392__$1;
(statearr_64402_64426[(2)] = inst_64386);

(statearr_64402_64426[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (2))){
var inst_64358 = (state_64392[(7)]);
var inst_64356 = (state_64392[(11)]);
var inst_64343 = (state_64392[(9)]);
var inst_64356__$1 = (state_64392[(2)]);
var inst_64357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64356__$1,(0),null);
var inst_64358__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64356__$1,(1),null);
var inst_64359 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64358__$1,inst_64343);
var state_64392__$1 = (function (){var statearr_64403 = state_64392;
(statearr_64403[(7)] = inst_64358__$1);

(statearr_64403[(11)] = inst_64356__$1);

(statearr_64403[(12)] = inst_64357);

return statearr_64403;
})();
if(inst_64359){
var statearr_64404_64427 = state_64392__$1;
(statearr_64404_64427[(1)] = (3));

} else {
var statearr_64405_64428 = state_64392__$1;
(statearr_64405_64428[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (11))){
var inst_64373 = (state_64392[(2)]);
var state_64392__$1 = state_64392;
var statearr_64406_64429 = state_64392__$1;
(statearr_64406_64429[(2)] = inst_64373);

(statearr_64406_64429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (9))){
var inst_64357 = (state_64392[(12)]);
var state_64392__$1 = state_64392;
var statearr_64407_64430 = state_64392__$1;
(statearr_64407_64430[(2)] = inst_64357);

(statearr_64407_64430[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (5))){
var inst_64377 = (state_64392[(10)]);
var inst_64377__$1 = (state_64392[(2)]);
var inst_64378 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_64379 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_64377__$1);
var state_64392__$1 = (function (){var statearr_64408 = state_64392;
(statearr_64408[(10)] = inst_64377__$1);

(statearr_64408[(13)] = inst_64378);

return statearr_64408;
})();
if(inst_64379){
var statearr_64409_64431 = state_64392__$1;
(statearr_64409_64431[(1)] = (12));

} else {
var statearr_64410_64432 = state_64392__$1;
(statearr_64410_64432[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (14))){
var inst_64390 = (state_64392[(2)]);
var state_64392__$1 = state_64392;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64392__$1,inst_64390);
} else {
if((state_val_64393 === (10))){
var state_64392__$1 = state_64392;
var statearr_64411_64433 = state_64392__$1;
(statearr_64411_64433[(2)] = null);

(statearr_64411_64433[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64393 === (8))){
var inst_64375 = (state_64392[(2)]);
var state_64392__$1 = state_64392;
var statearr_64412_64434 = state_64392__$1;
(statearr_64412_64434[(2)] = inst_64375);

(statearr_64412_64434[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_64413 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64413[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_64413[(1)] = (1));

return statearr_64413;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_64392){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64392);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64414){var ex__2730__auto__ = e64414;
var statearr_64415_64435 = state_64392;
(statearr_64415_64435[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64392[(4)]))){
var statearr_64416_64436 = state_64392;
(statearr_64416_64436[(1)] = cljs.core.first((state_64392[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64437 = state_64392;
state_64392 = G__64437;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_64392){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_64392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64417 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64417[(6)] = c__2749__auto___64418);

return statearr_64417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__64439 = arguments.length;
switch (G__64439) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__64440){
var map__64441 = p__64440;
var map__64441__$1 = cljs.core.__destructure_map(map__64441);
var opts = map__64441__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64441__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64441__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64441__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64441__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64441__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___64530 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64492){
var state_val_64493 = (state_64492[(1)]);
if((state_val_64493 === (7))){
var inst_64454 = (state_64492[(7)]);
var inst_64456 = fluree.db.api.ledger.syncTo_db(inst_64454,syncTo,syncTimeout);
var state_64492__$1 = state_64492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64492__$1,(10),inst_64456);
} else {
if((state_val_64493 === (20))){
var inst_64478 = (state_64492[(8)]);
var state_64492__$1 = state_64492;
var statearr_64494_64531 = state_64492__$1;
(statearr_64494_64531[(2)] = inst_64478);

(statearr_64494_64531[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (1))){
var state_64492__$1 = state_64492;
var statearr_64495_64532 = state_64492__$1;
(statearr_64495_64532[(2)] = null);

(statearr_64495_64532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (4))){
var inst_64442 = (state_64492[(2)]);
var inst_64443 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64442);
var inst_64444 = cljs.core.async.close_BANG_(pc);
var state_64492__$1 = (function (){var statearr_64496 = state_64492;
(statearr_64496[(9)] = inst_64443);

return statearr_64496;
})();
var statearr_64497_64533 = state_64492__$1;
(statearr_64497_64533[(2)] = inst_64444);

(statearr_64497_64533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (15))){
var inst_64470 = (state_64492[(10)]);
var inst_64472 = fluree.db.api.ledger.add_db_permissions(inst_64470,auth,roles);
var state_64492__$1 = state_64492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64492__$1,(18),inst_64472);
} else {
if((state_val_64493 === (21))){
var inst_64486 = (state_64492[(2)]);
var inst_64487 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64486);
var _ = (function (){var statearr_64498 = state_64492;
(statearr_64498[(4)] = cljs.core.rest((state_64492[(4)])));

return statearr_64498;
})();
var state_64492__$1 = state_64492;
var statearr_64499_64534 = state_64492__$1;
(statearr_64499_64534[(2)] = inst_64487);

(statearr_64499_64534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (13))){
var inst_64470 = (state_64492[(2)]);
var state_64492__$1 = (function (){var statearr_64500 = state_64492;
(statearr_64500[(10)] = inst_64470);

return statearr_64500;
})();
if(cljs.core.truth_(roles)){
var statearr_64501_64535 = state_64492__$1;
(statearr_64501_64535[(1)] = (15));

} else {
var statearr_64502_64536 = state_64492__$1;
(statearr_64502_64536[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (22))){
var inst_64482 = (state_64492[(2)]);
var inst_64483 = fluree.db.util.async.throw_err(inst_64482);
var state_64492__$1 = state_64492;
var statearr_64503_64537 = state_64492__$1;
(statearr_64503_64537[(2)] = inst_64483);

(statearr_64503_64537[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (6))){
var inst_64453 = (state_64492[(2)]);
var inst_64454 = fluree.db.util.async.throw_err(inst_64453);
var state_64492__$1 = (function (){var statearr_64504 = state_64492;
(statearr_64504[(7)] = inst_64454);

return statearr_64504;
})();
if(cljs.core.truth_(syncTo)){
var statearr_64505_64538 = state_64492__$1;
(statearr_64505_64538[(1)] = (7));

} else {
var statearr_64506_64539 = state_64492__$1;
(statearr_64506_64539[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (17))){
var inst_64478 = (state_64492[(2)]);
var state_64492__$1 = (function (){var statearr_64507 = state_64492;
(statearr_64507[(8)] = inst_64478);

return statearr_64507;
})();
if(cljs.core.truth_(auth)){
var statearr_64508_64540 = state_64492__$1;
(statearr_64508_64540[(1)] = (19));

} else {
var statearr_64509_64541 = state_64492__$1;
(statearr_64509_64541[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (3))){
var inst_64490 = (state_64492[(2)]);
var state_64492__$1 = state_64492;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64492__$1,inst_64490);
} else {
if((state_val_64493 === (12))){
var inst_64462 = (state_64492[(11)]);
var state_64492__$1 = state_64492;
var statearr_64510_64542 = state_64492__$1;
(statearr_64510_64542[(2)] = inst_64462);

(statearr_64510_64542[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (2))){
var _ = (function (){var statearr_64511 = state_64492;
(statearr_64511[(4)] = cljs.core.cons((5),(state_64492[(4)])));

return statearr_64511;
})();
var inst_64451 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_64492__$1 = state_64492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64492__$1,(6),inst_64451);
} else {
if((state_val_64493 === (19))){
var inst_64478 = (state_64492[(8)]);
var inst_64480 = fluree.db.api.ledger.add_db_permissions(inst_64478,auth,roles);
var state_64492__$1 = state_64492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64492__$1,(22),inst_64480);
} else {
if((state_val_64493 === (11))){
var inst_64462 = (state_64492[(11)]);
var inst_64464 = fluree.db.time_travel.as_of_block(inst_64462,block);
var state_64492__$1 = state_64492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64492__$1,(14),inst_64464);
} else {
if((state_val_64493 === (9))){
var inst_64462 = (state_64492[(2)]);
var state_64492__$1 = (function (){var statearr_64513 = state_64492;
(statearr_64513[(11)] = inst_64462);

return statearr_64513;
})();
if(cljs.core.truth_(block)){
var statearr_64514_64543 = state_64492__$1;
(statearr_64514_64543[(1)] = (11));

} else {
var statearr_64515_64544 = state_64492__$1;
(statearr_64515_64544[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (5))){
var _ = (function (){var statearr_64516 = state_64492;
(statearr_64516[(4)] = cljs.core.rest((state_64492[(4)])));

return statearr_64516;
})();
var state_64492__$1 = state_64492;
var ex64512 = (state_64492__$1[(2)]);
var statearr_64517_64545 = state_64492__$1;
(statearr_64517_64545[(5)] = ex64512);


var statearr_64518_64546 = state_64492__$1;
(statearr_64518_64546[(1)] = (4));

(statearr_64518_64546[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (14))){
var inst_64466 = (state_64492[(2)]);
var inst_64467 = fluree.db.util.async.throw_err(inst_64466);
var state_64492__$1 = state_64492;
var statearr_64519_64547 = state_64492__$1;
(statearr_64519_64547[(2)] = inst_64467);

(statearr_64519_64547[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (16))){
var inst_64470 = (state_64492[(10)]);
var state_64492__$1 = state_64492;
var statearr_64520_64548 = state_64492__$1;
(statearr_64520_64548[(2)] = inst_64470);

(statearr_64520_64548[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (10))){
var inst_64458 = (state_64492[(2)]);
var inst_64459 = fluree.db.util.async.throw_err(inst_64458);
var state_64492__$1 = state_64492;
var statearr_64521_64549 = state_64492__$1;
(statearr_64521_64549[(2)] = inst_64459);

(statearr_64521_64549[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (18))){
var inst_64474 = (state_64492[(2)]);
var inst_64475 = fluree.db.util.async.throw_err(inst_64474);
var state_64492__$1 = state_64492;
var statearr_64522_64550 = state_64492__$1;
(statearr_64522_64550[(2)] = inst_64475);

(statearr_64522_64550[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64493 === (8))){
var inst_64454 = (state_64492[(7)]);
var state_64492__$1 = state_64492;
var statearr_64523_64551 = state_64492__$1;
(statearr_64523_64551[(2)] = inst_64454);

(statearr_64523_64551[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_64524 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64524[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_64524[(1)] = (1));

return statearr_64524;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_64492){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64492);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64525){var ex__2730__auto__ = e64525;
var statearr_64526_64552 = state_64492;
(statearr_64526_64552[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64492[(4)]))){
var statearr_64527_64553 = state_64492;
(statearr_64527_64553[(1)] = cljs.core.first((state_64492[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64554 = state_64492;
state_64492 = G__64554;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_64492){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_64492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64528 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64528[(6)] = c__2749__auto___64530);

return statearr_64528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

