// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_12274){
var state_val_12275 = (state_12274[(1)]);
if((state_val_12275 === (7))){
var inst_12269 = (state_12274[(2)]);
var _ = (function (){var statearr_12276 = state_12274;
(statearr_12276[(4)] = cljs.core.rest.call(null,(state_12274[(4)])));

return statearr_12276;
})();
var state_12274__$1 = state_12274;
var statearr_12277_12299 = state_12274__$1;
(statearr_12277_12299[(2)] = inst_12269);

(statearr_12277_12299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12275 === (1))){
var state_12274__$1 = state_12274;
var statearr_12278_12300 = state_12274__$1;
(statearr_12278_12300[(2)] = null);

(statearr_12278_12300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12275 === (4))){
var inst_12231 = (state_12274[(2)]);
var state_12274__$1 = state_12274;
var statearr_12279_12301 = state_12274__$1;
(statearr_12279_12301[(2)] = inst_12231);

(statearr_12279_12301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12275 === (6))){
var inst_12256 = (state_12274[(7)]);
var inst_12249 = (state_12274[(8)]);
var inst_12255 = cljs.core.seq.call(null,inst_12249);
var inst_12256__$1 = cljs.core.first.call(null,inst_12255);
var inst_12257 = cljs.core.next.call(null,inst_12255);
var inst_12258 = cljs.core.not.call(null,inst_12256__$1);
var state_12274__$1 = (function (){var statearr_12280 = state_12274;
(statearr_12280[(7)] = inst_12256__$1);

(statearr_12280[(9)] = inst_12257);

return statearr_12280;
})();
if(inst_12258){
var statearr_12281_12302 = state_12274__$1;
(statearr_12281_12302[(1)] = (8));

} else {
var statearr_12282_12303 = state_12274__$1;
(statearr_12282_12303[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12275 === (3))){
var inst_12272 = (state_12274[(2)]);
var state_12274__$1 = state_12274;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12274__$1,inst_12272);
} else {
if((state_val_12275 === (2))){
var _ = (function (){var statearr_12283 = state_12274;
(statearr_12283[(4)] = cljs.core.cons.call(null,(5),(state_12274[(4)])));

return statearr_12283;
})();
var inst_12244 = chs;
var inst_12245 = cljs.core.seq.call(null,inst_12244);
var inst_12246 = cljs.core.first.call(null,inst_12245);
var inst_12247 = cljs.core.next.call(null,inst_12245);
var inst_12248 = coll;
var inst_12249 = inst_12244;
var inst_12250 = inst_12248;
var state_12274__$1 = (function (){var statearr_12284 = state_12274;
(statearr_12284[(10)] = inst_12246);

(statearr_12284[(11)] = inst_12247);

(statearr_12284[(8)] = inst_12249);

(statearr_12284[(12)] = inst_12250);

return statearr_12284;
})();
var statearr_12285_12304 = state_12274__$1;
(statearr_12285_12304[(2)] = null);

(statearr_12285_12304[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12275 === (11))){
var inst_12257 = (state_12274[(9)]);
var inst_12250 = (state_12274[(12)]);
var inst_12262 = (state_12274[(2)]);
var inst_12263 = fluree.db.util.async.throw_err.call(null,inst_12262);
var inst_12264 = cljs.core.conj.call(null,inst_12250,inst_12263);
var inst_12249 = inst_12257;
var inst_12250__$1 = inst_12264;
var state_12274__$1 = (function (){var statearr_12287 = state_12274;
(statearr_12287[(8)] = inst_12249);

(statearr_12287[(12)] = inst_12250__$1);

return statearr_12287;
})();
var statearr_12288_12305 = state_12274__$1;
(statearr_12288_12305[(2)] = null);

(statearr_12288_12305[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12275 === (9))){
var inst_12256 = (state_12274[(7)]);
var state_12274__$1 = state_12274;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12274__$1,(11),inst_12256);
} else {
if((state_val_12275 === (5))){
var _ = (function (){var statearr_12289 = state_12274;
(statearr_12289[(4)] = cljs.core.rest.call(null,(state_12274[(4)])));

return statearr_12289;
})();
var state_12274__$1 = state_12274;
var ex12286 = (state_12274__$1[(2)]);
var statearr_12290_12306 = state_12274__$1;
(statearr_12290_12306[(5)] = ex12286);


var statearr_12291_12307 = state_12274__$1;
(statearr_12291_12307[(1)] = (4));

(statearr_12291_12307[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12275 === (10))){
var inst_12267 = (state_12274[(2)]);
var state_12274__$1 = state_12274;
var statearr_12292_12308 = state_12274__$1;
(statearr_12292_12308[(2)] = inst_12267);

(statearr_12292_12308[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12275 === (8))){
var inst_12250 = (state_12274[(12)]);
var state_12274__$1 = state_12274;
var statearr_12293_12309 = state_12274__$1;
(statearr_12293_12309[(2)] = inst_12250);

(statearr_12293_12309[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_12294 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12294[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__);

(statearr_12294[(1)] = (1));

return statearr_12294;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1 = (function (state_12274){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_12274);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e12295){var ex__2749__auto__ = e12295;
var statearr_12296_12310 = state_12274;
(statearr_12296_12310[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_12274[(4)]))){
var statearr_12297_12311 = state_12274;
(statearr_12297_12311[(1)] = cljs.core.first.call(null,(state_12274[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12312 = state_12274;
state_12274 = G__12312;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__ = function(state_12274){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1.call(this,state_12274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_12298 = f__2769__auto__.call(null);
(statearr_12298[(6)] = c__2768__auto__);

return statearr_12298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_12338){
var state_val_12339 = (state_12338[(1)]);
if((state_val_12339 === (7))){
var inst_12333 = (state_12338[(2)]);
var _ = (function (){var statearr_12340 = state_12338;
(statearr_12340[(4)] = cljs.core.rest.call(null,(state_12338[(4)])));

return statearr_12340;
})();
var state_12338__$1 = state_12338;
var statearr_12341_12363 = state_12338__$1;
(statearr_12341_12363[(2)] = inst_12333);

(statearr_12341_12363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12339 === (1))){
var state_12338__$1 = state_12338;
var statearr_12342_12364 = state_12338__$1;
(statearr_12342_12364[(2)] = null);

(statearr_12342_12364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12339 === (4))){
var inst_12313 = (state_12338[(2)]);
var state_12338__$1 = state_12338;
var statearr_12343_12365 = state_12338__$1;
(statearr_12343_12365[(2)] = inst_12313);

(statearr_12343_12365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12339 === (6))){
var state_12338__$1 = state_12338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12338__$1,(8),chan);
} else {
if((state_val_12339 === (3))){
var inst_12336 = (state_12338[(2)]);
var state_12338__$1 = state_12338;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12338__$1,inst_12336);
} else {
if((state_val_12339 === (2))){
var _ = (function (){var statearr_12344 = state_12338;
(statearr_12344[(4)] = cljs.core.cons.call(null,(5),(state_12338[(4)])));

return statearr_12344;
})();
var inst_12319 = coll;
var inst_12320 = inst_12319;
var state_12338__$1 = (function (){var statearr_12345 = state_12338;
(statearr_12345[(7)] = inst_12320);

return statearr_12345;
})();
var statearr_12346_12366 = state_12338__$1;
(statearr_12346_12366[(2)] = null);

(statearr_12346_12366[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12339 === (11))){
var inst_12331 = (state_12338[(2)]);
var state_12338__$1 = state_12338;
var statearr_12348_12367 = state_12338__$1;
(statearr_12348_12367[(2)] = inst_12331);

(statearr_12348_12367[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12339 === (9))){
var inst_12320 = (state_12338[(7)]);
var state_12338__$1 = state_12338;
var statearr_12349_12368 = state_12338__$1;
(statearr_12349_12368[(2)] = inst_12320);

(statearr_12349_12368[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12339 === (5))){
var _ = (function (){var statearr_12350 = state_12338;
(statearr_12350[(4)] = cljs.core.rest.call(null,(state_12338[(4)])));

return statearr_12350;
})();
var state_12338__$1 = state_12338;
var ex12347 = (state_12338__$1[(2)]);
var statearr_12351_12369 = state_12338__$1;
(statearr_12351_12369[(5)] = ex12347);


var statearr_12352_12370 = state_12338__$1;
(statearr_12352_12370[(1)] = (4));

(statearr_12352_12370[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12339 === (10))){
var inst_12320 = (state_12338[(7)]);
var inst_12324 = (state_12338[(8)]);
var inst_12328 = cljs.core.conj.call(null,inst_12320,inst_12324);
var inst_12320__$1 = inst_12328;
var state_12338__$1 = (function (){var statearr_12353 = state_12338;
(statearr_12353[(7)] = inst_12320__$1);

return statearr_12353;
})();
var statearr_12354_12371 = state_12338__$1;
(statearr_12354_12371[(2)] = null);

(statearr_12354_12371[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12339 === (8))){
var inst_12324 = (state_12338[(8)]);
var inst_12323 = (state_12338[(2)]);
var inst_12324__$1 = fluree.db.util.async.throw_err.call(null,inst_12323);
var inst_12325 = (inst_12324__$1 == null);
var state_12338__$1 = (function (){var statearr_12355 = state_12338;
(statearr_12355[(8)] = inst_12324__$1);

return statearr_12355;
})();
if(cljs.core.truth_(inst_12325)){
var statearr_12356_12372 = state_12338__$1;
(statearr_12356_12372[(1)] = (9));

} else {
var statearr_12357_12373 = state_12338__$1;
(statearr_12357_12373[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_12358 = [null,null,null,null,null,null,null,null,null];
(statearr_12358[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__);

(statearr_12358[(1)] = (1));

return statearr_12358;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1 = (function (state_12338){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_12338);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e12359){var ex__2749__auto__ = e12359;
var statearr_12360_12374 = state_12338;
(statearr_12360_12374[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_12338[(4)]))){
var statearr_12361_12375 = state_12338;
(statearr_12361_12375[(1)] = cljs.core.first.call(null,(state_12338[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12376 = state_12338;
state_12338 = G__12376;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__ = function(state_12338){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1.call(this,state_12338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_12362 = f__2769__auto__.call(null);
(statearr_12362[(6)] = c__2768__auto__);

return statearr_12362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
