// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.sql');
goog.require('cljs.core');
goog.require('fluree.db.query.sql.template');
goog.require('clojure.string');
goog.require('fluree.db.util.cljs_shim');
goog.require('instaparse.core');
/**
 * SQL grammar in instaparse compatible BNF format loaded at compile time so it's
 *   available to cljs and js artifacts.
 */
fluree.db.query.sql.inline_grammar = "direct-select-statement ::= query-expression [ <space> order-by-clause ] [ <space> limit-clause ] [ <space> offset-clause ]\n\nquery-expression   ::=  non-join-query-expression | joined-table\n\nselect ::= 'select' | 'SELECT'\n\nquery-specification ::=\n                select <space> [set-quantifier <space>] select-list <space> table-expression\n\ndistinct = 'distinct' | 'DISTINCT'\nall = 'all' | 'ALL'\nset-quantifier ::= distinct | all\n\ntable-expression ::= from-clause [ <space> where-clause ] [ <space> group-by-clause ] [ <space> having-clause ]\n\nfrom ::= 'from' | 'FROM'\nfrom-clause ::= from <space> table-reference [ { comma <space> table-reference } ]\n\norder-by ::= 'order by' | 'ORDER BY'\norder-by-clause ::= order-by <space> sort-specification-list\n\nlimit ::= 'limit' | 'LIMIT'\nlimit-clause ::= limit <space> unsigned-integer\n\noffset ::= 'offset' | 'OFFSET'\noffset-clause ::= offset <space> unsigned-integer\n\nwhere ::= 'where' | 'WHERE'\nwhere-clause ::=  where <space> search-condition\n\ngroup-by ::= 'group by' | 'GROUP BY'\ngroup-by-clause ::=  group-by <space> grouping-column-reference-list\n\ngrouping-column-reference-list ::=\n                grouping-column-reference [ { comma <space> grouping-column-reference } + ]\n\ngrouping-column-reference ::= column-reference [ <space> collate-clause ]\n\nhaving ::= 'having' | 'HAVING'\nhaving-clause ::= having <space> search-condition\n\nselect-list ::= asterisk | select-list-element [ { comma [ <space> ] select-list-element } ]\n\nselect-list-element ::= derived-column | (qualifier <period> asterisk)\n\nqualifier ::= table-name / correlation-name\n\ntable-name ::= qualified-name |  qualified-local-table-name\n\nqualified-name ::= [ schema-name <period> ] qualified-identifier { qualified-identifier }\n\nas ::= 'as' | 'AS'\nas-clause ::= [ as <space> ] column-name\n\nderived-column ::= value-expression [ <space> as-clause ]\n\nvalue-expression ::= numeric-value-expression | string-value-expression | datetime-value-expression | interval-value-expression\n\n<value-expression-primary> ::=\n                unsigned-value-specification / column-reference / set-function-specification (* | scalar-subquery | case-expression | left-paren value-expression right-paren | cast-specification *)\n\ncount ::= 'count' | 'COUNT'\navg ::= 'avg' | 'AVG'\nmax ::= 'max' | 'MAX'\nmin ::= 'min' | 'MIN'\nsum ::= 'sum' | 'SUM'\n\nset-function-specification ::=\n                           count [ <space> ] <left-paren> asterisk <right-paren>\n                           | general-set-function\n\ngeneral-set-function ::= set-function-type [ <space> ] <left-paren> [ set-quantifier <space> ] value-expression <right-paren>\n\nset-function-type ::= avg | max | min | sum | count\n\n<datetime-value-expression>   ::=\n                 datetime-term\n        |\t interval-value-expression    plus-sign    datetime-term\n        |\t datetime-value-expression    plus-sign    interval-term\n        |\t datetime-value-expression    minus-sign    interval-term\n\n <datetime-term>   ::=  datetime-factor\n\n <datetime-factor>   ::=  datetime-primary   [  time-zone   ]\n\n <datetime-primary>   ::=  value-expression-primary   |  datetime-value-function\n\n datetime-value-function   ::=\n                 current-date-value-function\n        |\t current-time-value-function\n        |\t current-timestamp-value-function\n\ncurrent-date ::= 'current_date' | 'CURRENT_DATE'\ncurrent-date-value-function   ::= current-date\n\ncurrent-time ::= 'current_time' | 'CURRENT_TIME'\ncurrent-time-value-function   ::=  current-time [  left-paren    time-precision    right-paren   ]\n\ncurrent-timestamp ::= 'current_timestamp' | 'CURRENT_TIMESTAMP'\ncurrent-timestamp-value-function   ::=  current-timestamp [  left-paren    timestamp-precision    right-paren   ]\n\nat ::= 'at' | 'AT'\ntime-zone   ::= at time-zone-specifier\n\nlocal ::= 'local' | 'LOCAL'\ntime-zone ::= 'time zone' | 'TIME ZONE'\ntime-zone-specifier   ::= local | time-zone interval-value-expression\n\n <interval-term>   ::=\n                 interval-factor\n        |\t interval-term-2    asterisk    factor\n        |\t interval-term-2    solidus    factor\n        |\t term    asterisk    interval-factor\n\n <interval-factor>   ::= [  sign   ]  interval-primary\n\n <interval-primary>   ::=  value-expression-primary   [  interval-qualifier   ]\n\n <interval-term-2>   ::=  interval-term\n\n <interval-value-expression>   ::=\n                 interval-term\n        |\t interval-value-expression-1    plus-sign    interval-term-1\n        |\t interval-value-expression-1    minus-sign    interval-term-1\n        |\t left-paren    datetime-value-expression    minus-sign    datetime-term    right-paren    interval-qualifier\n\n <interval-value-expression-1>   ::=  interval-value-expression\n\n <interval-term-1>   ::=  interval-term\n\n <string-value-expression>   ::=  character-value-expression   |  bit-value-expression\n\n <character-value-expression>   ::=  concatenation   |  character-factor\n\n <concatenation>   ::=  character-value-expression    concatenation-operator    character-factor\n\n <character-factor>   ::=  character-primary   [  collate-clause   ]\n\ncollate ::= 'collate' | 'COLLATE'\ncollate-clause ::= collate <space> collation-name\n\n collation-name ::=  qualified-name\n\n <character-primary>   ::=  value-expression-primary   |  string-value-function\n\n string-value-function   ::=  character-value-function   |  bit-value-function\n\n character-value-function   ::=\n             character-substring-function\n        |    fold\n        |    form-of-use-conversion\n        |    character-translation\n        |    trim-function\n\n\ntrim ::= 'trim' | 'TRIM'\ntrim-function   ::= trim left-paren    trim-operands    right-paren\n\n trim-operands   ::= [ [  trim-specification   ] [  trim-character   ] 'FROM' ]  trim-source\n\n\n trim-specification   ::= 'LEADING' | 'TRAILING' | 'BOTH'\n\n trim-character   ::=  character-value-expression\n\n trim-source   ::=  character-value-expression\n\n character-translation   ::=\n                'TRANSLATE'  left-paren    character-value-expression   'USING'  translation-name    right-paren\n\n translation-name   ::=  qualified-name\n\n form-of-use-conversion   ::=\n                'CONVERT'  left-paren    character-value-expression   'USING'  form-of-use-conversion-name    right-paren\n\n form-of-use-conversion-name   ::=  qualified-name\n\n fold   ::= { 'UPPER' | 'LOWER' }  left-paren    character-value-expression    right-paren\n\n character-substring-function   ::=\n                'SUBSTRING'  left-paren    character-value-expression   'FROM'  start-position   [ 'FOR'  string-length   ]  right-paren\n\n start-position   ::=  numeric-value-expression\n\n string-length   ::=  numeric-value-expression\n\n bit-value-function   ::=  bit-substring-function\n\n bit-substring-function   ::=\n                'SUBSTRING'  left-paren    bit-value-expression   'FROM'  start-position   [ 'FOR'  string-length   ]  right-paren\n\n bit-value-expression   ::=  bit-concatenation   |  bit-factor\n\n bit-concatenation   ::=  bit-value-expression    concatenation-operator    bit-factor\n\n bit-factor   ::=  bit-primary\n\n bit-primary   ::=  value-expression-primary   |  string-value-function\n\n<numeric-value-expression> ::=\n                term\n        |    numeric-value-expression    plus-sign    term\n        |    numeric-value-expression    minus-sign    term\n\n<term> ::=\n                factor\n        |   term asterisk factor\n        |   term solidus factor\n\n<factor> ::= [  sign   ] numeric-primary\n\n <sign>   ::=  plus-sign   |  minus-sign\n\n<numeric-primary> ::= value-expression-primary (* |  numeric-value-function   *)\n\ncolumn-reference ::= [ qualifier <period> ] ( column-name | subject-placeholder )\n\ncase-expression   ::=  case-abbreviation   |  case-specification\n\nnullif ::= 'nullif' | 'NULLIF'\ncoalesce ::= 'coalesce' | 'COALESCE'\ncase-abbreviation   ::=  nullif <space> left-paren value-expression comma <space> value-expression right-paren\n                    | coalesce <space> left-paren value-expression { comma <space> value-expression } right-paren\n\ncase-specification   ::=  simple-case   |  searched-case\n\ncase ::= 'case' | 'CASE'\nend ::= 'end' | 'END'\nsimple-case ::= case <space> case-operand\n                        { simple-when-clause  }\n                        [  else-clause   ]\n                        end\n\nwhen ::= 'when' | 'WHEN'\nthen ::= 'then' | 'THEN'\nsimple-when-clause   ::= when <space> when-operand <space> then <space> result\n\n when-operand   ::=  value-expression\n\n case-operand   ::=  value-expression\n\ncase ::= 'case' | 'CASE'\n searched-case   ::=\n                case <space>\n                { searched-when-clause <space> }\n                [ else-clause <space> ]\n                end\n\nelse ::= 'else' | 'ELSE'\nelse-clause   ::= else <space> result\n\nwhen ::= 'when' | 'WHEN'\nthen ::= 'then' | 'THEN'\nsearched-when-clause   ::= when <space> search-condition <space> then <space>  result\n\nor ::= 'or' | 'OR'\nsearch-condition   ::=\n          boolean-term\n          | search-condition <space> or <space> boolean-term\n\nand ::= 'and' | 'AND'\nboolean-term   ::=\n          boolean-factor\n          | boolean-term  <space> and <space> boolean-factor\n\nnot ::= 'not' | 'NOT'\nboolean-factor   ::= [ not <space>]  boolean-test\n\nis ::= 'is' | 'IS'\nboolean-test   ::=  boolean-primary   [ <space> is [ <space> not ] <space> truth-value   ]\n\nboolean-primary   ::=  predicate   |  (left-paren    search-condition    right-paren )\n\npredicate   ::= comparison-predicate | between-predicate | in-predicate | like-predicate | null-predicate | quantified-comparison-predicate | exists-predicate | match-predicate | overlaps-predicate\n\ncomparison-predicate   ::=  row-value-constructor  <space>  comp-op  <space>  row-value-constructor\n\ncomp-op   ::=\n             equals-operator\n        |    not-equals-operator\n        |    less-than-operator\n        |    greater-than-operator\n        |    less-than-or-equals-operator\n        |    greater-than-or-equals-operator\n\nbetween ::= 'between' | 'BETWEEN'\nbetween-predicate ::= row-value-constructor <space> [ not <space> ] between <space> row-value-constructor <space> and <space> row-value-constructor\n\nin ::= 'in' | 'IN'\nin-predicate ::= row-value-constructor <space> [ not <space> ] in <space> in-predicate-value\n\n in-predicate-value ::= table-subquery | left-paren [ <space> ] in-value-list [ <space> ] right-paren\n\n in-value-list ::= value-expression { comma [ <space> ] value-expression }  +\n\n like-predicate ::= match-value [ not ] 'LIKE' pattern [ 'ESCAPE' escape-character ]\n\n match-value ::= character-value-expression\n\n pattern ::= character-value-expression\n\n escape-character ::= character-value-expression\n\nnull ::= 'null' | 'NULL'\nnull-predicate ::= row-value-constructor <space> 'IS' <space> [ not <space> ] null\n\n quantified-comparison-predicate ::= row-value-constructor comp-op quantifier table-subquery\n\n quantifier ::= all | some\n\n some ::= 'some' | 'SOME' | 'any' | 'ANY'\n\nexists ::= 'exists' | 'EXISTS'\nexists-predicate ::= exists <space> table-subquery\n\nunique ::= 'unique' | 'UNIQUE'\nunique-predicate ::= unique <space> table-subquery\n\n match-predicate ::= row-value-constructor 'MATCH' [ 'UNIQUE' ] [ 'PARTIAL' | 'FULL' ] table-subquery\n\n overlaps-predicate ::= row-value-constructor-1 'OVERLAPS' row-value-constructor-2\n\n row-value-constructor-1 ::= row-value-constructor\n\n row-value-constructor-2 ::= row-value-constructor\n\ntrue ::= 'true' | 'TRUE'\nfalse ::= 'false' | 'FALSE'\nunknown ::= 'unknown' | 'UNKNOWN'\ntruth-value   ::= true | false | unknown\n\n row-value-constructor   ::=\n             row-value-constructor-element\n        |    (left-paren    row-value-constructor-list    right-paren)\n        |    row-subquery\n\n row-subquery   ::=  subquery\n\n subquery   ::=  left-paren query-expression right-paren\n\n joined-table   ::=\n             qualified-join\n        |    cross-join\n        |    left-paren joined-table right-paren\n\njoin ::= 'join' | 'JOIN'\nnatural ::= 'natural' | 'NATURAL'\nqualified-join   ::= table-reference <space> [ natural <space> ] [ join-type <space> ] join <space> table-reference [ <space> join-specification ]\n\ncross ::= 'cross' | 'CROSS'\ncross-join ::= table-reference <space> cross <space> join <space> table-reference\n\n table-reference ::= table-name | joined-table | ( derived-table <space> correlation-specification )\n\n derived-table   ::=  table-subquery\n\n table-subquery   ::=  subquery\n\n join-specification ::=  join-condition | named-columns-join\n\non ::= 'on' | 'ON'\njoin-condition ::= on <space> search-condition\n\nusing ::= 'using' | 'USING'\nnamed-columns-join ::= using <space> left-paren join-column-list right-paren\n\njoin-column-list   ::=  column-name-list\n\ncorrelation-specification   ::= [ as <space> ]  correlation-name [ <space> left-paren derived-column-list right-paren ]\n\nderived-column-list   ::=  column-name-list\n\ninner ::= 'inner' | 'INNER'\nunion ::= 'union' | 'UNION'\njoin-type   ::=\n          inner\n        | outer-join-type [ <space> 'OUTER' ]\n        | union\n\nleft ::= 'left' | 'LEFT'\nright ::= 'right' | 'RIGHT'\nfull ::= 'full' | 'FULL'\nouter-join-type ::= left | right | full\n\nexcept ::= 'except' | 'EXCEPT'\nnon-join-query-expression   ::=\n                 non-join-query-term\n                 | query-expression union [ <space> all ] [ <space> corresponding-spec ] <space> query-term\n                 | query-expression except [ <space> all ] [ <space> corresponding-spec ] <space> query-term\n\nintersect ::= 'intersect' | 'INTERSECT'\nnon-join-query-term   ::=\n                 non-join-query-primary\n                 | query-term <space> intersect [ <space> all ] [ <space> corresponding-spec ]  <space> query-primary\n\nquery-primary   ::=  non-join-query-primary   |  joined-table\n\ncorresponding ::= 'corresponding' | 'CORRESPONDING'\ncorresponding-spec ::= corresponding <space> [ 'BY'  left-paren    corresponding-column-list    right-paren   ]\n\n corresponding-column-list   ::=  column-name-list\n\n column-name-list ::= column-name [ { comma <space> column-name }]\n\n non-join-query-primary ::= simple-table |  left-paren non-join-query-expression right-paren\n\n simple-table ::=\n                 query-specification\n        |\t table-value-constructor\n        |\t explicit-table\n\nvalues ::= 'values' | 'VALUES'\ntable-value-constructor ::= values <space> table-value-constructor-list\n\ntable-value-constructor-list ::=  row-value-constructor [ { comma <space> row-value-constructor } ]\n\ntable ::= 'table' | 'TABLE'\nexplicit-table ::= table <space> table-name\n\nquery-term ::= non-join-query-term | joined-table\n\nrow-value-constructor-list   ::=  row-value-constructor-element   [ {  comma <space> row-value-constructor-element   } ]\n\nrow-value-constructor-element   ::=\n             value-expression\n        |    null-specification\n        |    default-specification\n\n sort-specification-list ::= sort-specification [ { comma <space> sort-specification } + ]\n\n sort-specification ::= sort-key [ <space> collate-clause ] [ <space> ordering-specification ]\n\n sort-key ::= column-name (* | unsigned-integer *)\n\nasc ::= 'asc' | 'ASC'\ndesc ::= 'desc' | 'DESC'\nordering-specification ::= asc | desc\n\n result   ::=  result-expression   | null\n\n result-expression   ::=  value-expression\n\n cast-specification   ::= 'CAST'  left-paren    cast-operand   'AS'  cast-target    right-paren\n\n cast-operand   ::=  value-expression   | null\n\n cast-target   ::=  domain-name   |   data-type\n\n data-type   ::=\n     character-string-type   [ 'CHARACTER SET'  character-set-specification   ]\n        |\t national-character-string-type\n        |\t bit-string-type\n        |\t numeric-type\n        |\t datetime-type\n        |\t interval-type\n\n datetime-type   ::=\n                'DATE'\n        |   'TIME' [  left-paren    time-precision    right-paren   ] [ 'WITH TIME ZONE' ]\n        |   'TIMESTAMP' [  left-paren    timestamp-precision    right-paren   ] [ 'WITH TIME ZONE' ]\n\n time-precision   ::=  time-fractional-seconds-precision\n\n time-fractional-seconds-precision   ::=  unsigned-integer\n\n timestamp-precision   ::=  time-fractional-seconds-precision\n\n interval-type   ::= 'INTERVAL'  interval-qualifier\n\n numeric-type   ::=\n                 exact-numeric-type\n        |\t approximate-numeric-type\n\n exact-numeric-type   ::=\n                'NUMERIC' [  left-paren    precision   [  comma    scale   ]  right-paren   ]\n        |       'DECIMAL' [  left-paren    precision   [  comma    scale   ]  right-paren   ]\n        |       'DEC' [  left-paren    precision   [  comma    scale   ]  right-paren   ]\n        |\t'INTEGER'\n        |\t'INT'\n        |\t'SMALLINT'\n\n scale   ::=  unsigned-integer\n\n approximate-numeric-type   ::=\n                'FLOAT' [  left-paren    precision    right-paren   ]\n        |\t'REAL'\n        |\t'DOUBLE PRECISION'\n\n precision   ::=  unsigned-integer\n\n character-string-type   ::=\n                'CHARACTER' [  left-paren    length    right-paren   ]\n        |\t'CHAR' [  left-paren    length    right-paren   ]\n        |\t'CHARACTER VARYING' [  left-paren    length    right-paren   ]\n        |\t'CHAR VARYING' [  left-paren    length    right-paren   ]\n        |\t'VARCHAR' [  left-paren    length    right-paren   ]\n\n\n national-character-string-type   ::=\n                'NATIONAL CHARACTER' [  left-paren    length    right-paren   ]\n        |\t'NATIONAL CHAR' [  left-paren    length    right-paren   ]\n        |\t'NCHAR' [  left-paren    length    right-paren   ]\n        |\t'NATIONAL CHARACTER VARYING' [  left-paren    length    right-paren   ]\n        |\t'NATIONAL CHAR VARYING' [  left-paren    length    right-paren   ]\n        |\t'NCHAR VARYING' [  left-paren    length    right-paren   ]\n\n bit-string-type   ::=\n                'BIT' [  left-paren    length    right-paren   ]\n        |\t'BIT VARYING' [  left-paren    length    right-paren   ]\n\n length   ::=  unsigned-integer\n\n domain-name   ::=  qualified-name\n\nunsigned-value-specification ::= unsigned-literal | general-value-specification\n\nunsigned-literal ::= unsigned-numeric-literal | general-literal\n\n unsigned-numeric-literal   ::=\n                 exact-numeric-literal\n        |\t approximate-numeric-literal\n\n approximate-numeric-literal   ::=\n                 mantissa   'E'  exponent\n\n mantissa   ::=  exact-numeric-literal\n\n exponent   ::=  signed-integer\n\n signed-integer   ::= [  sign   ]  unsigned-integer\n\n exact-numeric-literal   ::=\n                 unsigned-integer   [  period   [  unsigned-integer   ] ]\n        |\t period    unsigned-integer\n\n general-literal   ::=\n                 character-string-literal\n        |\t national-character-string-literal\n        |\t bit-string-literal\n        |\t hex-string-literal\n        |\t datetime-literal\n        |\t interval-literal\n\n character-string-literal  ::=\n        [ introducer character-set-specification ] quote [ { character-representation } ] quote [ { { separator  } quote [ { character-representation } ] quote } ]\n\n national-character-string-literal   ::=\n                'N'  quote   [ { character-representation  } ]  quote   [ { { separator   }  quote   [ { character-representation  } ]  quote   } ]\n\n character-representation   ::=  nonquote-character   |  quote-symbol\n\n quote-symbol ::= quote quote\n\n bit-string-literal   ::=\n                'B'  quote   [ { bit  } ]  quote   [ { { separator  }  quote   [ { bit  } ]  quote   }  ]\n\n bit   ::= '0' | '1'\n\n hex-string-literal   ::=\n                'X'  quote   [ { hexit  } ]  quote   [ { { separator  }  quote   [ { hexit  } ]  quote   } ]\n\n hexit   ::=  digit   | 'A' | 'B' | 'C' | 'D' | 'E' | 'F' | 'a' | 'b' | 'c' | 'd' | 'e' | 'f'\n\n separator   ::= {  comment   |  space   |  newline   }\n\n comment   ::=  comment-introducer   [ { comment-character  } ]  newline\n\n comment-introducer   ::=  minus-sign   minus-sign   [{ minus-sign  } ]\n\n comment-character   ::=  nonquote-character   |  quote\n\n nonquote-character   ::= sql-language-character | nonquote-nondoublequote-special-character | double-quote\n\n newline   ::= '!!'\n\n datetime-literal   ::=\n                 date-literal\n        |\t time-literal\n        |\t timestamp-literal\n\n date-literal   ::= 'DATE'  date-string\n\n time-literal   ::= 'TIME'  time-string\n\n timestamp-literal   ::= 'TIMESTAMP'  timestamp-string\n\n time-zone-interval   ::=  sign    hours-value    colon    minutes-value\n\n timestamp-string   ::=  quote    date-value    space    time-value   [  time-zone-interval   ]  quote\n\n date-string   ::=  quote    date-value    quote\n\n date-value   ::=  years-value    minus-sign    months-value    minus-sign    days-value\n\n time-string   ::=  quote    time-value   [  time-zone-interval   ]  quote\n\n time-value   ::=  hours-value    colon    minutes-value    colon    seconds-value\n\n interval-literal   ::= 'INTERVAL' [  sign   ]  interval-string    interval-qualifier\n\n interval-string   ::=  quote   {  year-month-literal   |  day-time-literal   }  quote\n\n year-month-literal   ::=\n                 years-value\n        |\t[  years-value    minus-sign   ]  months-value\n\n months-value   ::=  datetime-value\n\n days-value   ::=  datetime-value\n\n years-value   ::=  datetime-value\n\n datetime-value   ::=  unsigned-integer\n\n day-time-literal   ::=  day-time-interval   |  time-interval\n\n day-time-interval   ::=\n                 days-value   [  space    hours-value   [  colon    minutes-value   [  colon    seconds-value   ] ] ]\n\n time-interval   ::=\n                 hours-value   [  colon    minutes-value   [  colon    seconds-value   ] ]\n        |\t minutes-value   [  colon    seconds-value   ]\n        |\t seconds-value\n\n hours-value   ::=  datetime-value\n\n minutes-value   ::=  datetime-value\n\n seconds-value   ::=  seconds-integer-value   [  period   [  seconds-fraction   ] ]\n\n seconds-integer-value   ::=  unsigned-integer\n\n seconds-fraction   ::=  unsigned-integer\n\n interval-qualifier   ::=\n                 start-field   'TO'  end-field\n        |    single-datetime-field\n\n single-datetime-field   ::=\n                 non-second-datetime-field   [  left-paren    interval-leading-field-precision    right-paren   ]\n        |   'SECOND' [  left-paren    interval-leading-field-precision   [  comma    left-paren    interval-fractional-seconds-precision   ]  right-paren   ]\n\n start-field   ::=\n                 non-second-datetime-field   [  left-paren    interval-leading-field-precision    right-paren   ]\n\n non-second-datetime-field   ::= 'YEAR' | 'MONTH' | 'DAY' | 'HOUR' | 'MINUTE'\n\n interval-leading-field-precision   ::=  unsigned-integer\n\n end-field   ::=\n                 non-second-datetime-field\n        |   'SECOND' [  left-paren    interval-fractional-seconds-precision    right-paren   ]\n\n interval-fractional-seconds-precision   ::=  unsigned-integer\n\n unsigned-integer   ::= digit { digit }\n\n general-value-specification   ::=\n             parameter-specification\n        |    dynamic-parameter-specification\n        |    variable-specification\n        |   'USER'\n        |   'CURRENT_USER'\n        |   'SESSION_USER'\n        |   'SYSTEM_USER'\n        |   'VALUE'\n\n parameter-specification   ::=  parameter-name   [  indicator-parameter   ]\n\n parameter-name   ::=  colon    identifier\n\n indicator-parameter   ::= [ 'INDICATOR' ]  parameter-name\n\n dynamic-parameter-specification   ::=  question-mark\n\n variable-specification   ::=  embedded-variable-name   [  indicator-variable   ]\n\n embedded-variable-name   ::=  colon   host-identifier\n\n host-identifier   ::=\n                 Ada-host-identifier\n        |\t C-host-identifier\n        |\t Cobol-host-identifier\n        |\t Fortran-host-identifier\n        |\t MUMPS-host-identifier\n        |\t Pascal-host-identifier\n        |\t PL-I-host-identifier\n\n Ada-host-identifier   ::= '!!'\n\n C-host-identifier   ::= '!!'\n\n Cobol-host-identifier   ::= '!!'\n\n Fortran-host-identifier   ::= '!!'\n\n MUMPS-host-identifier   ::= '!!'\n\n Pascal-host-identifier   ::= '!!'\n\n PL-I-host-identifier   ::= '!!'\n\n indicator-variable   ::= [ 'INDICATOR' ]  embedded-variable-name\n\n character-set-specification   ::=\n                 standard-character-repertoire-name\n        |\t implementation-defined-character-repertoire-name\n        |\t user-defined-character-repertoire-name\n        |\t standard-universal-character-form-of-use-name\n        |\t implementation-defined-universal-character-form-of-use-name\n\n implementation-defined-character-repertoire-name   ::=  character-set-name\n\n user-defined-character-repertoire-name   ::=  character-set-name\n\n standard-universal-character-form-of-use-name   ::=  character-set-name\n\n implementation-defined-universal-character-form-of-use-name   ::=  character-set-name\n\n standard-character-repertoire-name   ::=  character-set-name\n\n qualified-local-table-name   ::= 'MODULE'  period    local-table-name\n\n local-table-name   ::=  qualified-identifier\n\n character-set-name   ::= [  schema-name    period   ]  sql-language-identifier\n\n column-name   ::=  identifier\n\n correlation-name   ::=  identifier\n\n <qualified-identifier>   ::= identifier\n\n identifier ::= [ introducer character-set-specification ] actual-identifier\n\n <actual-identifier>   ::= regular-identifier | delimited-identifier\n\n <regular-identifier>   ::= identifier-body\n\n<identifier-body> ::= identifier-start [ {  underscore   | identifier-part } ]\n\n<identifier-part> ::= identifier-start |  digit\n\n\n(* An  identifier start   is any character in the Unicode General Category\nclasses \"Lu\", \"Ll\", \"Lt\", \"Lm\", \"Lo\", or \"Nl\".\n\nNOTE 58 \u2014 The Unicode General Category classes \"Lu\", \"Ll\", \"Lt\", \"Lm\", \"Lo\", and\n\"Nl\" are assigned to Unicode characters that are, respectively, upper-case\nletters, lower-case letters, title-case letters, modifier letters, other\nletters, and letter numbers.\n*)\n\n<identifier-start> ::= sql-language-identifier\n\n delimited-identifier ::= double-quote delimited-identifier-body double-quote\n\n delimited-identifier-body   ::= { delimited-identifier-part }\n\n delimited-identifier-part   ::=  nondoublequote-character   |  doublequote-symbol\n\n nondoublequote-character   ::= sql-language-character | nonquote-nondoublequote-special-character | quote\n\n doublequote-symbol   ::=  double-quote   double-quote\n\n schema-name   ::= [  catalog-name    period   ]  unqualified-schema-name\n\n unqualified-schema-name   ::=  identifier\n\n catalog-name   ::=  identifier\n\n introducer   ::=  underscore\n\n sql-language-identifier ::=\n                 sql-language-identifier-start [ { underscore | sql-language-identifier-part } ]\n\n null-specification   ::= null\n\n default-specification   ::= 'DEFAULT'\n\n not-equals-operator   ::= '<>'\n\n greater-than-or-equals-operator   ::= '>='\n\n less-than-or-equals-operator   ::= '<='\n\n concatenation-operator   ::= '||'\n\n double-period   ::= '..'\n\n sql-language-identifier-start   ::=  simple-Latin-letter\n\n sql-language-identifier-part   ::=  simple-Latin-letter   |  digit\n\n<sql-language-character> ::=\n                 simple-Latin-letter\n        |\t digit\n\n<simple-Latin-letter> ::=\n                simple-Latin-upper-case-letter\n        |\t simple-Latin-lower-case-letter\n\n<simple-Latin-upper-case-letter> ::=\n        'A' | 'B' | 'C' | 'D' | 'E' | 'F' | 'G' | 'H' | 'I' | 'J' | 'K' | 'L' | 'M' | 'N' | 'O' | 'P' | 'Q' | 'R' | 'S' | 'T' | 'U' | 'V' | 'W' | 'X' | 'Y' | 'Z'\n\n <simple-Latin-lower-case-letter>  ::=\n        'a' | 'b' | 'c' | 'd' | 'e' | 'f' | 'g' | 'h' | 'i' | 'j' | 'k' | 'l' | 'm' | 'n' | 'o' | 'p' | 'q' | 'r' | 's' | 't' | 'u' | 'v' | 'w' | 'x' | 'y' | 'z'\n\n <digit>   ::=\n        '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9'\n\n <nonquote-nondoublequote-special-character> ::=\n                 percent\n        |\t ampersand\n        |\t left-paren\n        |\t right-paren\n        |\t plus-sign\n        |\t comma\n        |\t minus-sign\n        |\t period\n        |\t solidus\n        |\t colon\n        |\t semicolon\n        |\t less-than-operator\n        |\t greater-than-operator\n        |\t equals-operator\n        |\t question-mark\n        |\t underscore\n        |\t vertical-bar\n\n <sql-special-character>   ::=\n                 (* space  | asterisk  | *)\n                 nonquote-nondoublequote-special-character\n        |        double-quote\n        |\t quote\n\n(* space was one of !! See Syntax Rules *)\n <space>   ::= #\"[\\x20\\x09\\x0D\\x0A]*\\#[^\\n]*\\n*[\\x20\\x09\\x0D\\x0A]*|[\\x20\\x09\\x0D\\x0A]\" { #\"[\\x20\\x09\\x0D\\x0A]*\\#[^\\n]*\\n*[\\x20\\x09\\x0D\\x0A]*|[\\x20\\x09\\x0D\\x0A]\"}\n\n double-quote   ::= '\"'\n\n percent   ::= '%'\n\n ampersand   ::= '&'\n\n quote   ::= \"'\"\n\n <left-paren>   ::= <'('>\n\n <right-paren>   ::= <')'>\n\nasterisk ::= '*'\n\n plus-sign   ::= '+'\n\n <comma>   ::= <','>\n\n minus-sign   ::= '-'\n\n period   ::= '.'\n\n solidus   ::= '/'\n\n colon   ::= ':'\n\n semicolon   ::= ';'\n\n less-than-operator   ::= '<'\n\n equals-operator   ::= '='\n\n greater-than-operator   ::= '>'\n\n question-mark   ::= '?'\n\n underscore   ::= '_'\n\n vertical-bar   ::= '|'\n\n sql-embedded-language-character   ::=  left-bracket   |  right-bracket\n\n left-bracket   ::= '['\n\n right-bracket   ::= ']'\n\nsubject-placeholder ::= '$'  { sql-language-character }\n";
fluree.db.query.sql.sql = instaparse.core.parser.call(null,fluree.db.query.sql.inline_grammar,new cljs.core.Keyword(null,"input-format","input-format",-422703481),new cljs.core.Keyword(null,"ebnf","ebnf",31967825));
fluree.db.query.sql.rule_tag = (function fluree$db$query$sql$rule_tag(r){
return cljs.core.first.call(null,r);
});
fluree.db.query.sql.rule_QMARK_ = (function fluree$db$query$sql$rule_QMARK_(elt){
return ((cljs.core.sequential_QMARK_.call(null,elt)) && ((fluree.db.query.sql.rule_tag.call(null,elt) instanceof cljs.core.Keyword)));
});
/**
 * Keyword rule tags representing the SQL reserved words
 */
fluree.db.query.sql.reserved_words = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 54, [new cljs.core.Keyword(null,"exists","exists",1312597120),null,new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"having","having",-399543166),null,new cljs.core.Keyword(null,"current-time","current-time",-1609407134),null,new cljs.core.Keyword(null,"true","true",-1114210334),null,new cljs.core.Keyword(null,"except","except",1116893347),null,new cljs.core.Keyword(null,"where","where",-2044795965),null,new cljs.core.Keyword(null,"desc","desc",2093485764),null,new cljs.core.Keyword(null,"full","full",436801220),null,new cljs.core.Keyword(null,"table","table",-564943036),null,new cljs.core.Keyword(null,"limit","limit",-1355822363),null,new cljs.core.Keyword(null,"group-by","group-by",-379139802),null,new cljs.core.Keyword(null,"else","else",-1508377146),null,new cljs.core.Keyword(null,"when","when",-576417306),null,new cljs.core.Keyword(null,"is","is",369128998),null,new cljs.core.Keyword(null,"unknown","unknown",-935977881),null,new cljs.core.Keyword(null,"offset","offset",296498311),null,new cljs.core.Keyword(null,"current-timestamp","current-timestamp",-863384792),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"asc","asc",356854569),null,new cljs.core.Keyword(null,"or","or",235744169),null,new cljs.core.Keyword(null,"natural","natural",722422122),null,new cljs.core.Keyword(null,"some","some",-1951079573),null,new cljs.core.Keyword(null,"between","between",1131099276),null,new cljs.core.Keyword(null,"not","not",-595976884),null,new cljs.core.Keyword(null,"coalesce","coalesce",654622029),null,new cljs.core.Keyword(null,"false","false",1277713805),null,new cljs.core.Keyword(null,"corresponding","corresponding",-419371155),null,new cljs.core.Keyword(null,"all","all",892129742),null,new cljs.core.Keyword(null,"distinct","distinct",-1788879121),null,new cljs.core.Keyword(null,"nullif","nullif",1992193233),null,new cljs.core.Keyword(null,"inner","inner",-1383171215),null,new cljs.core.Keyword(null,"null","null",-180137709),null,new cljs.core.Keyword(null,"from","from",1815293044),null,new cljs.core.Keyword(null,"case","case",1143702196),null,new cljs.core.Keyword(null,"values","values",372645556),null,new cljs.core.Keyword(null,"at","at",1476951349),null,new cljs.core.Keyword(null,"order-by","order-by",1527318070),null,new cljs.core.Keyword(null,"then","then",460598070),null,new cljs.core.Keyword(null,"current-date","current-date",-1728476105),null,new cljs.core.Keyword(null,"and","and",-971899817),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"trim","trim",774319767),null,new cljs.core.Keyword(null,"intersect","intersect",-2039792392),null,new cljs.core.Keyword(null,"on","on",173873944),null,new cljs.core.Keyword(null,"end","end",-268185958),null,new cljs.core.Keyword(null,"using","using",1948623036),null,new cljs.core.Keyword(null,"local","local",-1497766724),null,new cljs.core.Keyword(null,"cross","cross",194557789),null,new cljs.core.Keyword(null,"collate","collate",-850477218),null,new cljs.core.Keyword(null,"join","join",-758861890),null,new cljs.core.Keyword(null,"select","select",1147833503),null,new cljs.core.Keyword(null,"in","in",-1531184865),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null);
/**
 * Hierarchy of SQL BNF rule name keywords for parsing equivalence
 */
fluree.db.query.sql.rules = (function (){var derive_all = (function (hier,coll,kw){
return cljs.core.reduce.call(null,(function (h,elt){
return cljs.core.derive.call(null,h,elt,kw);
}),hier,coll);
});
return derive_all.call(null,cljs.core.derive.call(null,cljs.core.derive.call(null,cljs.core.make_hierarchy.call(null),new cljs.core.Keyword(null,"column-name","column-name",551523580),new cljs.core.Keyword("fluree.db.query.sql","string","fluree.db.query.sql/string",-1821610577)),new cljs.core.Keyword(null,"character-string-literal","character-string-literal",1862087833),new cljs.core.Keyword("fluree.db.query.sql","string","fluree.db.query.sql/string",-1821610577)),fluree.db.query.sql.reserved_words,new cljs.core.Keyword("fluree.db.query.sql","reserved","fluree.db.query.sql/reserved",-406183946));
})();
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.query !== 'undefined') && (typeof fluree.db.query.sql !== 'undefined') && (typeof fluree.db.query.sql.rule_parser !== 'undefined')){
} else {
/**
 * Parse SQL BNF rules depending on their type. Returns a function whose return
 *   chain will eventually contain the parsed rule after repeated execution.
 */
fluree.db.query.sql.rule_parser = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),new cljs.core.Var(function(){return fluree.db.query.sql.rules;},new cljs.core.Symbol("fluree.db.query.sql","rules","fluree.db.query.sql/rules",-2026785496,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"fluree.db.query.sql","fluree.db.query.sql",2086354823,null),new cljs.core.Symbol(null,"rules","rules",-1455523403,null),"/Users/wmorgan/dev/fluree/db-1.x/src/fluree/db/query/sql.cljc",11,1,45,45,cljs.core.List.EMPTY,"Hierarchy of SQL BNF rule name keywords for parsing equivalence",(cljs.core.truth_(fluree.db.query.sql.rules)?fluree.db.query.sql.rules.cljs$lang$test:null)]))], null),new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.query.sql","rule-parser"),fluree.db.query.sql.rule_tag,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
/**
 * Uses `trampoline` to allow for mutual recursion without consuming call stack
 *   space when executing the rule parser on deeply nested rule trees.
 */
fluree.db.query.sql.parse_rule = (function fluree$db$query$sql$parse_rule(r){
return cljs.core.trampoline.call(null,fluree.db.query.sql.rule_parser.call(null,r));
});
fluree.db.query.sql.parse_element = (function fluree$db$query$sql$parse_element(e){
if(fluree.db.query.sql.rule_QMARK_.call(null,e)){
return fluree.db.query.sql.parse_rule.call(null,e);
} else {
return e;
}
});
fluree.db.query.sql.parse_all = (function fluree$db$query$sql$parse_all(elts){
return cljs.core.mapcat.call(null,fluree.db.query.sql.parse_element,elts);
});
fluree.db.query.sql.parse_into_map = (function fluree$db$query$sql$parse_into_map(elts){
return cljs.core.reduce_kv.call(null,(function (rules,tag,lst){
return cljs.core.assoc.call(null,rules,tag,fluree.db.query.sql.parse_all.call(null,lst));
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.group_by.call(null,fluree.db.query.sql.rule_tag,elts));
});
/**
 * Function to merge parsed (sub) query trees
 */
fluree.db.query.sql.merge_parsed = cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.into);
/**
 * Returns a function that, when executed, returns the argument supplied to this
 *   function, `v`, wrapped in a vector if `v` is a rule or scalar, or it returns
 *   `v` itself if `v` is a list of rules or scalars. Used for mutually recursive
 *   parse function's return values in conjunction with `trampoline` to conserve
 *   call-stack space.
 */
fluree.db.query.sql.bounce = (function fluree$db$query$sql$bounce(v){
if(((cljs.core.sequential_QMARK_.call(null,v)) && ((!(fluree.db.query.sql.rule_QMARK_.call(null,v)))))){
return cljs.core.constantly.call(null,v);
} else {
return cljs.core.constantly.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null));
}
});
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__67529){
var vec__67530 = p__67529;
var seq__67531 = cljs.core.seq.call(null,vec__67530);
var first__67532 = cljs.core.first.call(null,seq__67531);
var seq__67531__$1 = cljs.core.next.call(null,seq__67531);
var _ = first__67532;
var rst = seq__67531__$1;
return fluree.db.query.sql.bounce.call(null,fluree.db.query.sql.parse_all.call(null,rst));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword("fluree.db.query.sql","reserved","fluree.db.query.sql/reserved",-406183946),(function (p__67533){
var vec__67534 = p__67533;
var seq__67535 = cljs.core.seq.call(null,vec__67534);
var first__67536 = cljs.core.first.call(null,seq__67535);
var seq__67535__$1 = cljs.core.next.call(null,seq__67535);
var _ = first__67536;
var words = seq__67535__$1;
return fluree.db.query.sql.bounce.call(null,clojure.string.upper_case.call(null,clojure.string.join.call(null," ",cljs.core.flatten.call(null,cljs.core.map.call(null,fluree.db.query.sql.parse_element,words)))));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"unsigned-integer","unsigned-integer",-1383322016),(function (p__67537){
var vec__67538 = p__67537;
var seq__67539 = cljs.core.seq.call(null,vec__67538);
var first__67540 = cljs.core.first.call(null,seq__67539);
var seq__67539__$1 = cljs.core.next.call(null,seq__67539);
var _ = first__67540;
var rst = seq__67539__$1;
return fluree.db.query.sql.bounce.call(null,Number.parseInt(cljs.core.apply.call(null,cljs.core.str,fluree.db.query.sql.parse_all.call(null,rst))));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"double-quote","double-quote",-2005961393),(function (_){
return fluree.db.query.sql.bounce.call(null,"\"");
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword("fluree.db.query.sql","string","fluree.db.query.sql/string",-1821610577),(function (p__67541){
var vec__67542 = p__67541;
var seq__67543 = cljs.core.seq.call(null,vec__67542);
var first__67544 = cljs.core.first.call(null,seq__67543);
var seq__67543__$1 = cljs.core.next.call(null,seq__67543);
var _ = first__67544;
var rst = seq__67543__$1;
return fluree.db.query.sql.bounce.call(null,cljs.core.apply.call(null,cljs.core.str,cljs.core.remove.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["'",null], null), null),fluree.db.query.sql.parse_all.call(null,rst))));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"qualifier","qualifier",125841738),(function (p__67545){
var vec__67546 = p__67545;
var _ = cljs.core.nth.call(null,vec__67546,(0),null);
var q = cljs.core.nth.call(null,vec__67546,(1),null);
return fluree.db.query.sql.bounce.call(null,new cljs.core.Keyword("fluree.db.query.sql","coll","fluree.db.query.sql/coll",-2009692976).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,fluree.db.query.sql.parse_element.call(null,q))));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"subject-placeholder","subject-placeholder",418110445),(function (p__67549){
var vec__67550 = p__67549;
var seq__67551 = cljs.core.seq.call(null,vec__67550);
var first__67552 = cljs.core.first.call(null,seq__67551);
var seq__67551__$1 = cljs.core.next.call(null,seq__67551);
var _ = first__67552;
var first__67552__$1 = cljs.core.first.call(null,seq__67551__$1);
var seq__67551__$2 = cljs.core.next.call(null,seq__67551__$1);
var ___$1 = first__67552__$1;
var rst = seq__67551__$2;
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583),fluree.db.query.sql.template.combine_str.call(null,fluree.db.query.sql.template.collection_var,cljs.core.apply.call(null,cljs.core.str,fluree.db.query.sql.parse_all.call(null,rst)))], null));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"unsigned-value-specification","unsigned-value-specification",557106234),(function (p__67553){
var vec__67554 = p__67553;
var _ = cljs.core.nth.call(null,vec__67554,(0),null);
var v = cljs.core.nth.call(null,vec__67554,(1),null);
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583),cljs.core.first.call(null,fluree.db.query.sql.parse_element.call(null,v))], null));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"column-reference","column-reference",1468145582),(function (p__67557){
var vec__67558 = p__67557;
var seq__67559 = cljs.core.seq.call(null,vec__67558);
var first__67560 = cljs.core.first.call(null,seq__67559);
var seq__67559__$1 = cljs.core.next.call(null,seq__67559);
var _ = first__67560;
var rst = seq__67559__$1;
var parse_map = fluree.db.query.sql.parse_into_map.call(null,rst);
var pred = (function (){var G__67561 = parse_map;
var G__67561__$1 = (((G__67561 == null))?null:new cljs.core.Keyword(null,"column-name","column-name",551523580).cljs$core$IFn$_invoke$arity$1(G__67561));
var G__67561__$2 = (((G__67561__$1 == null))?null:cljs.core.first.call(null,G__67561__$1));
if((G__67561__$2 == null)){
return null;
} else {
return fluree.db.query.sql.template.field__GT_predicate_template.call(null,G__67561__$2);
}
})();
var subject = (function (){var G__67562 = parse_map;
var G__67562__$1 = (((G__67562 == null))?null:new cljs.core.Keyword(null,"subject-placeholder","subject-placeholder",418110445).cljs$core$IFn$_invoke$arity$1(G__67562));
if((G__67562__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__67562__$1);
}
})();
var coll = cljs.core.first.call(null,new cljs.core.Keyword(null,"qualifier","qualifier",125841738).cljs$core$IFn$_invoke$arity$1(parse_map));
var G__67563 = (function (){var or__5045__auto__ = subject;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fluree.db.query.sql","subj","fluree.db.query.sql/subj",1384024107),fluree.db.query.sql.template.collection_var,new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374),pred], null);
}
})();
var G__67563__$1 = (cljs.core.truth_(coll)?fluree.db.query.sql.template.fill_in_collection.call(null,coll,G__67563):G__67563);
return fluree.db.query.sql.bounce.call(null,G__67563__$1);

}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"set-quantifier","set-quantifier",1324787250),(function (p__67564){
var vec__67565 = p__67564;
var _ = cljs.core.nth.call(null,vec__67565,(0),null);
var q = cljs.core.nth.call(null,vec__67565,(1),null);
var quantifier = cljs.core.first.call(null,fluree.db.query.sql.parse_element.call(null,q));
var k = ((cljs.core._EQ_.call(null,quantifier,"DISTINCT"))?new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872):new cljs.core.Keyword(null,"select","select",1147833503));
return fluree.db.query.sql.bounce.call(null,k);
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"asterisk","asterisk",1372170530),(function (_){
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fluree.db.query.sql","select","fluree.db.query.sql/select",1785250074),cljs.core.PersistentArrayMap.createAsIfByAssoc([fluree.db.query.sql.template.collection_var,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["*"], null)])], null));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"set-function-type","set-function-type",1559033290),(function (p__67568){
var vec__67569 = p__67568;
var _ = cljs.core.nth.call(null,vec__67569,(0),null);
var t = cljs.core.nth.call(null,vec__67569,(1),null);
return fluree.db.query.sql.bounce.call(null,cljs.core.name.call(null,fluree.db.query.sql.rule_tag.call(null,t)));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"general-set-function","general-set-function",-194821850),(function (p__67572){
var vec__67573 = p__67572;
var seq__67574 = cljs.core.seq.call(null,vec__67573);
var first__67575 = cljs.core.first.call(null,seq__67574);
var seq__67574__$1 = cljs.core.next.call(null,seq__67574);
var _ = first__67575;
var rst = seq__67574__$1;
var parse_map = fluree.db.query.sql.parse_into_map.call(null,rst);
var func = cljs.core.first.call(null,new cljs.core.Keyword(null,"set-function-type","set-function-type",1559033290).cljs$core$IFn$_invoke$arity$1(parse_map));
var val_exp = cljs.core.first.call(null,new cljs.core.Keyword(null,"value-expression","value-expression",764059486).cljs$core$IFn$_invoke$arity$1(parse_map));
var subj = (function (){var or__5045__auto__ = new cljs.core.Keyword("fluree.db.query.sql","subj","fluree.db.query.sql/subj",1384024107).cljs$core$IFn$_invoke$arity$1(val_exp);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.query.sql.template.collection_var;
}
})();
var pred = new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(val_exp);
var val = fluree.db.query.sql.template.build_var.call(null,pred);
var distinct_QMARK_ = cljs.core._EQ_.call(null,cljs.core.first.call(null,new cljs.core.Keyword(null,"set-quantifier","set-quantifier",1324787250).cljs$core$IFn$_invoke$arity$1(parse_map)),new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var G__67576 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fluree.db.query.sql","subj","fluree.db.query.sql/subj",1384024107),subj,new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374),pred,new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583),val], null);
var G__67576__$1 = ((distinct_QMARK_)?cljs.core.update.call(null,G__67576,new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583),cljs.core.partial.call(null,fluree.db.query.sql.template.build_fn_call,"distinct")):G__67576);
return fluree.db.query.sql.bounce.call(null,cljs.core.update.call(null,G__67576__$1,new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583),cljs.core.partial.call(null,fluree.db.query.sql.template.build_fn_call,func)));

}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"select-list-element","select-list-element",-2141257288),(function (p__67577){
var vec__67578 = p__67577;
var seq__67579 = cljs.core.seq.call(null,vec__67578);
var first__67580 = cljs.core.first.call(null,seq__67579);
var seq__67579__$1 = cljs.core.next.call(null,seq__67579);
var _ = first__67580;
var rst = seq__67579__$1;
var parse_map = fluree.db.query.sql.parse_into_map.call(null,rst);
var map__67581 = cljs.core.first.call(null,new cljs.core.Keyword(null,"derived-column","derived-column",-729398047).cljs$core$IFn$_invoke$arity$1(parse_map));
var map__67581__$1 = cljs.core.__destructure_map.call(null,map__67581);
var subj = cljs.core.get.call(null,map__67581__$1,new cljs.core.Keyword("fluree.db.query.sql","subj","fluree.db.query.sql/subj",1384024107));
var pred = cljs.core.get.call(null,map__67581__$1,new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374));
var obj = cljs.core.get.call(null,map__67581__$1,new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583));
var pred_var = (function (){var G__67582 = pred;
if((G__67582 == null)){
return null;
} else {
return fluree.db.query.sql.template.build_var.call(null,G__67582);
}
})();
var selected = (function (){var or__5045__auto__ = obj;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return pred_var;
}
})();
var triple = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [subj,pred,pred_var], null);
var G__67583 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fluree.db.query.sql","select","fluree.db.query.sql/select",1785250074),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected], null)], null);
var G__67583__$1 = (cljs.core.truth_(fluree.db.query.sql.template.predicate_QMARK_.call(null,pred))?cljs.core.assoc.call(null,G__67583,new cljs.core.Keyword("fluree.db.query.sql","where","fluree.db.query.sql/where",-1742951614),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [triple], null)):G__67583);
return fluree.db.query.sql.bounce.call(null,G__67583__$1);

}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"select-list","select-list",249623177),(function (p__67584){
var vec__67585 = p__67584;
var seq__67586 = cljs.core.seq.call(null,vec__67585);
var first__67587 = cljs.core.first.call(null,seq__67586);
var seq__67586__$1 = cljs.core.next.call(null,seq__67586);
var _ = first__67587;
var rst = seq__67586__$1;
return fluree.db.query.sql.bounce.call(null,cljs.core.apply.call(null,fluree.db.query.sql.merge_parsed,fluree.db.query.sql.parse_all.call(null,rst)));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"between-predicate","between-predicate",-395771025),(function (p__67588){
var vec__67589 = p__67588;
var seq__67590 = cljs.core.seq.call(null,vec__67589);
var first__67591 = cljs.core.first.call(null,seq__67590);
var seq__67590__$1 = cljs.core.next.call(null,seq__67590);
var _ = first__67591;
var rst = seq__67590__$1;
var parsed = fluree.db.query.sql.parse_all.call(null,rst);
var vec__67592 = cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["NOT",null,"AND",null,"BETWEEN",null], null), null)),parsed);
var col = cljs.core.nth.call(null,vec__67592,(0),null);
var l = cljs.core.nth.call(null,vec__67592,(1),null);
var u = cljs.core.nth.call(null,vec__67592,(2),null);
var pred = new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(col);
var lower = new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583).cljs$core$IFn$_invoke$arity$1(l);
var upper = new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583).cljs$core$IFn$_invoke$arity$1(u);
var field_var = fluree.db.query.sql.template.build_var.call(null,pred);
var selector = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,pred,field_var], null);
var refinement = (cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["NOT",null], null), null),parsed))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"union","union",2142937499),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.build_fn_call.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<",field_var,lower], null))], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.build_fn_call.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">",field_var,upper], null))], null)], null)], null)], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.build_fn_call.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=",field_var,lower], null)),fluree.db.query.sql.template.build_fn_call.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<=",field_var,upper], null))], null)], null));
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector,refinement], null));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"comparison-predicate","comparison-predicate",-1657333660),(function (p__67595){
var vec__67596 = p__67595;
var seq__67597 = cljs.core.seq.call(null,vec__67596);
var first__67598 = cljs.core.first.call(null,seq__67597);
var seq__67597__$1 = cljs.core.next.call(null,seq__67597);
var _ = first__67598;
var rst = seq__67597__$1;
var parse_map = fluree.db.query.sql.parse_into_map.call(null,rst);
var comp = cljs.core.first.call(null,new cljs.core.Keyword(null,"comp-op","comp-op",-146757825).cljs$core$IFn$_invoke$arity$1(parse_map));
var vec__67599 = new cljs.core.Keyword(null,"row-value-constructor","row-value-constructor",-1746609364).cljs$core$IFn$_invoke$arity$1(parse_map);
var left = cljs.core.nth.call(null,vec__67599,(0),null);
var right = cljs.core.nth.call(null,vec__67599,(1),null);
return fluree.db.query.sql.bounce.call(null,(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["=",null], null), null).call(null,comp))?(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583).cljs$core$IFn$_invoke$arity$1(left);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583).cljs$core$IFn$_invoke$arity$1(right);
}
})())?(function (){var map__67602 = cljs.core.merge.call(null,left,right);
var map__67602__$1 = cljs.core.__destructure_map.call(null,map__67602);
var subj = cljs.core.get.call(null,map__67602__$1,new cljs.core.Keyword("fluree.db.query.sql","subj","fluree.db.query.sql/subj",1384024107));
var pred = cljs.core.get.call(null,map__67602__$1,new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374));
var obj = cljs.core.get.call(null,map__67602__$1,new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583));
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [subj,pred,obj], null)], null);
})():(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(left);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(right);
} else {
return and__5043__auto__;
}
})())?(function (){var v = fluree.db.query.sql.template.build_var.call(null,new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(right));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.query.sql","subj","fluree.db.query.sql/subj",1384024107).cljs$core$IFn$_invoke$arity$1(right),new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(right),v], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.query.sql","subj","fluree.db.query.sql/subj",1384024107).cljs$core$IFn$_invoke$arity$1(left),new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(left),v], null)], null);
})():null)):(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["<",null,">",null], null), null).call(null,comp))?(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(left);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583).cljs$core$IFn$_invoke$arity$1(right);
} else {
return and__5043__auto__;
}
})())?(function (){var pred = new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(left);
var obj = new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583).cljs$core$IFn$_invoke$arity$1(right);
var comp_SINGLEQUOTE_ = cljs.core.apply.call(null,cljs.core.str,new cljs.core.Keyword(null,"comp-op","comp-op",-146757825).cljs$core$IFn$_invoke$arity$1(parse_map));
var field_var = fluree.db.query.sql.template.build_var.call(null,pred);
var filter_fn = fluree.db.query.sql.template.build_fn_call.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp_SINGLEQUOTE_,field_var,obj], null));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,pred,field_var], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [filter_fn], null)], null)], null);
})():null):null)));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"in-predicate","in-predicate",-649164367),(function (p__67603){
var vec__67604 = p__67603;
var seq__67605 = cljs.core.seq.call(null,vec__67604);
var first__67606 = cljs.core.first.call(null,seq__67605);
var seq__67605__$1 = cljs.core.next.call(null,seq__67605);
var _ = first__67606;
var rst = seq__67605__$1;
var parse_map = fluree.db.query.sql.parse_into_map.call(null,rst);
var pred = new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"row-value-constructor","row-value-constructor",-1746609364).cljs$core$IFn$_invoke$arity$1(parse_map)));
var field_var = fluree.db.query.sql.template.build_var.call(null,pred);
var selector = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,pred,field_var], null);
var not_QMARK_ = cljs.core.contains_QMARK_.call(null,parse_map,new cljs.core.Keyword(null,"not","not",-595976884));
var filter_pred = ((not_QMARK_)?"not=":"=");
var filter_junc = ((not_QMARK_)?"and":"or");
var filter_clauses = clojure.string.join.call(null," ",cljs.core.map.call(null,(function (v){
return fluree.db.query.sql.template.build_fn_call.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [filter_pred,field_var,v], null));
}),cljs.core.map.call(null,new cljs.core.Keyword("fluree.db.query.sql","obj","fluree.db.query.sql/obj",612856583),new cljs.core.Keyword(null,"in-predicate-value","in-predicate-value",1739512494).cljs$core$IFn$_invoke$arity$1(parse_map))));
var filter_func = ["(",filter_junc," ",filter_clauses,")"].join('');
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"filter","filter",-948537934),filter_func], null)], null));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"null-predicate","null-predicate",-123832000),(function (p__67607){
var vec__67608 = p__67607;
var seq__67609 = cljs.core.seq.call(null,vec__67608);
var first__67610 = cljs.core.first.call(null,seq__67609);
var seq__67609__$1 = cljs.core.next.call(null,seq__67609);
var _ = first__67610;
var rst = seq__67609__$1;
var parsed = fluree.db.query.sql.parse_all.call(null,rst);
var pred = new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,parsed));
var field_var = fluree.db.query.sql.template.build_var.call(null,pred);
if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["NOT",null], null), null),parsed))){
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,pred,field_var], null)], null));
} else {
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,"rdf:type",fluree.db.query.sql.template.collection], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"optional","optional",2053951509),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,pred,field_var], null)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.build_fn_call.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["nil?",field_var], null))], null)], null)], null));
}
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"boolean-term","boolean-term",1391756842),(function (p__67611){
var vec__67612 = p__67611;
var seq__67613 = cljs.core.seq.call(null,vec__67612);
var first__67614 = cljs.core.first.call(null,seq__67613);
var seq__67613__$1 = cljs.core.next.call(null,seq__67613);
var _ = first__67614;
var rst = seq__67613__$1;
return fluree.db.query.sql.bounce.call(null,fluree.db.query.sql.parse_all.call(null,cljs.core.filter.call(null,(function (r){
return cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),fluree.db.query.sql.rule_tag.call(null,r));
}),rst)));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"search-condition","search-condition",-858789941),(function (p__67615){
var vec__67616 = p__67615;
var seq__67617 = cljs.core.seq.call(null,vec__67616);
var first__67618 = cljs.core.first.call(null,seq__67617);
var seq__67617__$1 = cljs.core.next.call(null,seq__67617);
var _ = first__67618;
var rst = seq__67617__$1;
var parsed = fluree.db.query.sql.parse_all.call(null,rst);
if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["OR",null], null), null),parsed))){
var vec__67619 = cljs.core.split_with.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["OR",null], null), null)),parsed);
var front = cljs.core.nth.call(null,vec__67619,(0),null);
var back = cljs.core.nth.call(null,vec__67619,(1),null);
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"union","union",2142937499),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vec.call(null,front),cljs.core.vec.call(null,cljs.core.rest.call(null,back))], null)], null));
} else {
return fluree.db.query.sql.bounce.call(null,parsed);
}
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"table-name","table-name",-2117866341),(function (p__67622){
var vec__67623 = p__67622;
var seq__67624 = cljs.core.seq.call(null,vec__67623);
var first__67625 = cljs.core.first.call(null,seq__67624);
var seq__67624__$1 = cljs.core.next.call(null,seq__67624);
var _ = first__67625;
var rst = seq__67624__$1;
var parsed_name = cljs.core.apply.call(null,cljs.core.str,fluree.db.query.sql.parse_all.call(null,rst));
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fluree.db.query.sql","coll","fluree.db.query.sql/coll",-2009692976),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [parsed_name], null)], null));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"from-clause","from-clause",919750613),(function (p__67626){
var vec__67627 = p__67626;
var seq__67628 = cljs.core.seq.call(null,vec__67627);
var first__67629 = cljs.core.first.call(null,seq__67628);
var seq__67628__$1 = cljs.core.next.call(null,seq__67628);
var _ = first__67629;
var first__67629__$1 = cljs.core.first.call(null,seq__67628__$1);
var seq__67628__$2 = cljs.core.next.call(null,seq__67628__$1);
var ___$1 = first__67629__$1;
var rst = seq__67628__$2;
return fluree.db.query.sql.bounce.call(null,cljs.core.apply.call(null,fluree.db.query.sql.merge_parsed,fluree.db.query.sql.parse_all.call(null,rst)));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"where-clause","where-clause",-616820922),(function (p__67630){
var vec__67631 = p__67630;
var seq__67632 = cljs.core.seq.call(null,vec__67631);
var first__67633 = cljs.core.first.call(null,seq__67632);
var seq__67632__$1 = cljs.core.next.call(null,seq__67632);
var _ = first__67633;
var first__67633__$1 = cljs.core.first.call(null,seq__67632__$1);
var seq__67632__$2 = cljs.core.next.call(null,seq__67632__$1);
var ___$1 = first__67633__$1;
var rst = seq__67632__$2;
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fluree.db.query.sql","where","fluree.db.query.sql/where",-1742951614),cljs.core.vec.call(null,fluree.db.query.sql.parse_all.call(null,rst))], null));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"group-by-clause","group-by-clause",-716480033),(function (p__67634){
var vec__67635 = p__67634;
var seq__67636 = cljs.core.seq.call(null,vec__67635);
var first__67637 = cljs.core.first.call(null,seq__67636);
var seq__67636__$1 = cljs.core.next.call(null,seq__67636);
var _ = first__67637;
var first__67637__$1 = cljs.core.first.call(null,seq__67636__$1);
var seq__67636__$2 = cljs.core.next.call(null,seq__67636__$1);
var ___$1 = first__67637__$1;
var rst = seq__67636__$2;
return fluree.db.query.sql.bounce.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,fluree.db.query.sql.template.build_var,new cljs.core.Keyword("fluree.db.query.sql","pred","fluree.db.query.sql/pred",-1663014374)),fluree.db.query.sql.parse_all.call(null,rst)));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"table-expression","table-expression",1991072411),(function (p__67638){
var vec__67639 = p__67638;
var seq__67640 = cljs.core.seq.call(null,vec__67639);
var first__67641 = cljs.core.first.call(null,seq__67640);
var seq__67640__$1 = cljs.core.next.call(null,seq__67640);
var _ = first__67641;
var rst = seq__67640__$1;
var parse_map = fluree.db.query.sql.parse_into_map.call(null,rst);
var from_clause = cljs.core.first.call(null,new cljs.core.Keyword(null,"from-clause","from-clause",919750613).cljs$core$IFn$_invoke$arity$1(parse_map));
var where_clause = (function (){var or__5045__auto__ = (function (){var G__67642 = parse_map;
var G__67642__$1 = (((G__67642 == null))?null:new cljs.core.Keyword(null,"where-clause","where-clause",-616820922).cljs$core$IFn$_invoke$arity$1(G__67642));
if((G__67642__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__67642__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fluree.db.query.sql","where","fluree.db.query.sql/where",-1742951614),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sql.template.collection_var,"rdf:type",fluree.db.query.sql.template.collection], null)], null)], null);
}
})();
var grouping = cljs.core.vec.call(null,new cljs.core.Keyword(null,"group-by-clause","group-by-clause",-716480033).cljs$core$IFn$_invoke$arity$1(parse_map));
var from = cljs.core.first.call(null,new cljs.core.Keyword("fluree.db.query.sql","coll","fluree.db.query.sql/coll",-2009692976).cljs$core$IFn$_invoke$arity$1(from_clause));
return fluree.db.query.sql.bounce.call(null,fluree.db.query.sql.template.fill_in_collection.call(null,from,cljs.core.assoc.call(null,fluree.db.query.sql.merge_parsed.call(null,from_clause,where_clause),new cljs.core.Keyword("fluree.db.query.sql","group","fluree.db.query.sql/group",280479143),grouping)));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"query-specification","query-specification",973994903),(function (p__67643){
var vec__67644 = p__67643;
var seq__67645 = cljs.core.seq.call(null,vec__67644);
var first__67646 = cljs.core.first.call(null,seq__67645);
var seq__67645__$1 = cljs.core.next.call(null,seq__67645);
var _ = first__67646;
var first__67646__$1 = cljs.core.first.call(null,seq__67645__$1);
var seq__67645__$2 = cljs.core.next.call(null,seq__67645__$1);
var ___$1 = first__67646__$1;
var rst = seq__67645__$2;
var parse_map = fluree.db.query.sql.parse_into_map.call(null,rst);
var select_key = (function (){var or__5045__auto__ = cljs.core.first.call(null,new cljs.core.Keyword(null,"set-quantifier","set-quantifier",1324787250).cljs$core$IFn$_invoke$arity$1(parse_map));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"select","select",1147833503);
}
})();
var table_expr = cljs.core.first.call(null,new cljs.core.Keyword(null,"table-expression","table-expression",1991072411).cljs$core$IFn$_invoke$arity$1(parse_map));
var select_list = cljs.core.first.call(null,new cljs.core.Keyword(null,"select-list","select-list",249623177).cljs$core$IFn$_invoke$arity$1(parse_map));
var map__67647 = fluree.db.query.sql.merge_parsed.call(null,table_expr,select_list);
var map__67647__$1 = cljs.core.__destructure_map.call(null,map__67647);
var coll = cljs.core.get.call(null,map__67647__$1,new cljs.core.Keyword("fluree.db.query.sql","coll","fluree.db.query.sql/coll",-2009692976));
var select = cljs.core.get.call(null,map__67647__$1,new cljs.core.Keyword("fluree.db.query.sql","select","fluree.db.query.sql/select",1785250074));
var where = cljs.core.get.call(null,map__67647__$1,new cljs.core.Keyword("fluree.db.query.sql","where","fluree.db.query.sql/where",-1742951614));
var group = cljs.core.get.call(null,map__67647__$1,new cljs.core.Keyword("fluree.db.query.sql","group","fluree.db.query.sql/group",280479143));
var from = cljs.core.first.call(null,coll);
var G__67648 = cljs.core.PersistentArrayMap.createAsIfByAssoc([select_key,fluree.db.query.sql.template.fill_in_collection.call(null,from,select),new cljs.core.Keyword(null,"where","where",-2044795965),fluree.db.query.sql.template.fill_in_collection.call(null,from,where),new cljs.core.Keyword("fluree.db.query.sql","coll","fluree.db.query.sql/coll",-2009692976),coll]);
var G__67648__$1 = ((cljs.core.seq.call(null,group))?cljs.core.assoc.call(null,G__67648,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),group], null)):G__67648);
return fluree.db.query.sql.bounce.call(null,G__67648__$1);

}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"join-condition","join-condition",-671331604),(function (p__67649){
var vec__67650 = p__67649;
var seq__67651 = cljs.core.seq.call(null,vec__67650);
var first__67652 = cljs.core.first.call(null,seq__67651);
var seq__67651__$1 = cljs.core.next.call(null,seq__67651);
var _ = first__67652;
var first__67652__$1 = cljs.core.first.call(null,seq__67651__$1);
var seq__67651__$2 = cljs.core.next.call(null,seq__67651__$1);
var ___$1 = first__67652__$1;
var rst = seq__67651__$2;
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fluree.db.query.sql","where","fluree.db.query.sql/where",-1742951614),cljs.core.vec.call(null,fluree.db.query.sql.parse_all.call(null,rst))], null));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"outer-join-type","outer-join-type",-1726499710),(function (p__67653){
var vec__67654 = p__67653;
var _ = cljs.core.nth.call(null,vec__67654,(0),null);
var t = cljs.core.nth.call(null,vec__67654,(1),null);
return fluree.db.query.sql.bounce.call(null,(function (){var G__67657 = t;
switch (G__67657) {
case "LEFT":
return new cljs.core.Keyword("fluree.db.query.sql","left","fluree.db.query.sql/left",-164385820);

break;
case "RIGHT":
return new cljs.core.Keyword("fluree.db.query.sql","right","fluree.db.query.sql/right",251653020);

break;
case "FULL":
return new cljs.core.Keyword("fluree.db.query.sql","full","fluree.db.query.sql/full",805782593);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67657)].join('')));

}
})());
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"join-type","join-type",168703387),(function (p__67659){
var vec__67660 = p__67659;
var seq__67661 = cljs.core.seq.call(null,vec__67660);
var first__67662 = cljs.core.first.call(null,seq__67661);
var seq__67661__$1 = cljs.core.next.call(null,seq__67661);
var _ = first__67662;
var first__67662__$1 = cljs.core.first.call(null,seq__67661__$1);
var seq__67661__$2 = cljs.core.next.call(null,seq__67661__$1);
var t = first__67662__$1;
var rst = seq__67661__$2;
return fluree.db.query.sql.bounce.call(null,(function (){var G__67663 = t;
switch (G__67663) {
case "INNER":
return new cljs.core.Keyword("fluree.db.query.sql","inner","fluree.db.query.sql/inner",395103734);

break;
case "UNION":
return new cljs.core.Keyword("fluree.db.query.sql","union","fluree.db.query.sql/union",-1447234528);

break;
default:
return fluree.db.query.sql.parse_element.call(null,t);

}
})());
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"named-columns-join","named-columns-join",-579623361),(function (p__67665){
var vec__67666 = p__67665;
var seq__67667 = cljs.core.seq.call(null,vec__67666);
var first__67668 = cljs.core.first.call(null,seq__67667);
var seq__67667__$1 = cljs.core.next.call(null,seq__67667);
var _ = first__67668;
var first__67668__$1 = cljs.core.first.call(null,seq__67667__$1);
var seq__67667__$2 = cljs.core.next.call(null,seq__67667__$1);
var ___$1 = first__67668__$1;
var rst = seq__67667__$2;
return fluree.db.query.sql.bounce.call(null,fluree.db.query.sql.parse_all.call(null,rst));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"qualified-join","qualified-join",771500450),(function (p__67669){
var vec__67670 = p__67669;
var seq__67671 = cljs.core.seq.call(null,vec__67670);
var first__67672 = cljs.core.first.call(null,seq__67671);
var seq__67671__$1 = cljs.core.next.call(null,seq__67671);
var _ = first__67672;
var rst = seq__67671__$1;
var parse_map = fluree.db.query.sql.parse_into_map.call(null,cljs.core.filter.call(null,fluree.db.query.sql.rule_QMARK_,rst));
var spec = cljs.core.apply.call(null,fluree.db.query.sql.merge_parsed,new cljs.core.Keyword(null,"join-specification","join-specification",-1809470085).cljs$core$IFn$_invoke$arity$1(parse_map));
var join_ref = cljs.core.apply.call(null,fluree.db.query.sql.merge_parsed,spec,new cljs.core.Keyword(null,"table-reference","table-reference",-891602787).cljs$core$IFn$_invoke$arity$1(parse_map));
var join_type = (function (){var or__5045__auto__ = cljs.core.first.call(null,new cljs.core.Keyword(null,"join-type","join-type",168703387).cljs$core$IFn$_invoke$arity$1(parse_map));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("fluree.db.query.sql","inner","fluree.db.query.sql/inner",395103734);
}
})();
return fluree.db.query.sql.bounce.call(null,(function (){var G__67673 = join_type;
var G__67673__$1 = (((G__67673 instanceof cljs.core.Keyword))?G__67673.fqn:null);
switch (G__67673__$1) {
case "fluree.db.query.sql/inner":
return join_ref;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67673__$1)].join('')));

}
})());
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"sort-specification","sort-specification",126952777),(function (p__67675){
var vec__67676 = p__67675;
var seq__67677 = cljs.core.seq.call(null,vec__67676);
var first__67678 = cljs.core.first.call(null,seq__67677);
var seq__67677__$1 = cljs.core.next.call(null,seq__67677);
var _ = first__67678;
var rst = seq__67677__$1;
var parse_map = fluree.db.query.sql.parse_into_map.call(null,rst);
var pred = fluree.db.query.sql.template.field__GT_predicate_template.call(null,cljs.core.first.call(null,new cljs.core.Keyword(null,"sort-key","sort-key",1285844623).cljs$core$IFn$_invoke$arity$1(parse_map)));
var temp__5802__auto__ = (function (){var G__67679 = parse_map;
var G__67679__$1 = (((G__67679 == null))?null:new cljs.core.Keyword(null,"ordering-specification","ordering-specification",1480676887).cljs$core$IFn$_invoke$arity$1(G__67679));
if((G__67679__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__67679__$1);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var order = temp__5802__auto__;
return fluree.db.query.sql.bounce.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [order,pred], null)], null));
} else {
return fluree.db.query.sql.bounce.call(null,pred);
}
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"order-by-clause","order-by-clause",1342730150),(function (p__67680){
var vec__67681 = p__67680;
var seq__67682 = cljs.core.seq.call(null,vec__67681);
var first__67683 = cljs.core.first.call(null,seq__67682);
var seq__67682__$1 = cljs.core.next.call(null,seq__67682);
var _ = first__67683;
var first__67683__$1 = cljs.core.first.call(null,seq__67682__$1);
var seq__67682__$2 = cljs.core.next.call(null,seq__67682__$1);
var ___$1 = first__67683__$1;
var rst = seq__67682__$2;
return fluree.db.query.sql.bounce.call(null,fluree.db.query.sql.parse_all.call(null,rst));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"limit-clause","limit-clause",731019479),(function (p__67684){
var vec__67685 = p__67684;
var _ = cljs.core.nth.call(null,vec__67685,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__67685,(1),null);
var lim = cljs.core.nth.call(null,vec__67685,(2),null);
return fluree.db.query.sql.bounce.call(null,fluree.db.query.sql.parse_rule.call(null,lim));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"offset-clause","offset-clause",-82027621),(function (p__67688){
var vec__67689 = p__67688;
var _ = cljs.core.nth.call(null,vec__67689,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__67689,(1),null);
var ofst = cljs.core.nth.call(null,vec__67689,(2),null);
return fluree.db.query.sql.bounce.call(null,fluree.db.query.sql.parse_rule.call(null,ofst));
}));
cljs.core._add_method.call(null,fluree.db.query.sql.rule_parser,new cljs.core.Keyword(null,"direct-select-statement","direct-select-statement",1011570264),(function (p__67692){
var vec__67693 = p__67692;
var seq__67694 = cljs.core.seq.call(null,vec__67693);
var first__67695 = cljs.core.first.call(null,seq__67694);
var seq__67694__$1 = cljs.core.next.call(null,seq__67694);
var _ = first__67695;
var rst = seq__67694__$1;
var parse_map = fluree.db.query.sql.parse_into_map.call(null,rst);
var map__67696 = cljs.core.first.call(null,new cljs.core.Keyword(null,"query-expression","query-expression",1380420534).cljs$core$IFn$_invoke$arity$1(parse_map));
var map__67696__$1 = cljs.core.__destructure_map.call(null,map__67696);
var query = map__67696__$1;
var coll = cljs.core.get.call(null,map__67696__$1,new cljs.core.Keyword("fluree.db.query.sql","coll","fluree.db.query.sql/coll",-2009692976));
var ordering = (function (){var G__67697 = parse_map;
var G__67697__$1 = (((G__67697 == null))?null:new cljs.core.Keyword(null,"order-by-clause","order-by-clause",1342730150).cljs$core$IFn$_invoke$arity$1(G__67697));
var G__67697__$2 = (((G__67697__$1 == null))?null:cljs.core.first.call(null,G__67697__$1));
if((G__67697__$2 == null)){
return null;
} else {
return fluree.db.query.sql.template.fill_in_collection.call(null,cljs.core.first.call(null,coll),G__67697__$2);
}
})();
var limit = (function (){var G__67698 = parse_map;
var G__67698__$1 = (((G__67698 == null))?null:new cljs.core.Keyword(null,"limit-clause","limit-clause",731019479).cljs$core$IFn$_invoke$arity$1(G__67698));
if((G__67698__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__67698__$1);
}
})();
var offset = (function (){var G__67699 = parse_map;
var G__67699__$1 = (((G__67699 == null))?null:new cljs.core.Keyword(null,"offset-clause","offset-clause",-82027621).cljs$core$IFn$_invoke$arity$1(G__67699));
if((G__67699__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__67699__$1);
}
})();
var G__67700 = query;
var G__67700__$1 = (cljs.core.truth_(ordering)?cljs.core.assoc_in.call(null,G__67700,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793)], null),ordering):G__67700);
var G__67700__$2 = (cljs.core.truth_(limit)?cljs.core.assoc_in.call(null,G__67700__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"limit","limit",-1355822363)], null),limit):G__67700__$1);
var G__67700__$3 = (cljs.core.truth_(offset)?cljs.core.assoc_in.call(null,G__67700__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"offset","offset",296498311)], null),offset):G__67700__$2);
return fluree.db.query.sql.bounce.call(null,G__67700__$3);

}));
fluree.db.query.sql.parse = (function fluree$db$query$sql$parse(q){
return cljs.core.select_keys.call(null,cljs.core.first.call(null,fluree.db.query.sql.parse_rule.call(null,fluree.db.query.sql.sql.call(null,clojure.string.trim.call(null,q)))),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872),new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"prefixes","prefixes",1192472197),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"opts","opts",155075701)], null));
});
