// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16618){
var state_val_16619 = (state_16618[(1)]);
if((state_val_16619 === (1))){
var state_16618__$1 = state_16618;
var statearr_16620_16634 = state_16618__$1;
(statearr_16620_16634[(2)] = null);

(statearr_16620_16634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16619 === (2))){
var _ = (function (){var statearr_16621 = state_16618;
(statearr_16621[(4)] = cljs.core.cons.call(null,(5),(state_16618[(4)])));

return statearr_16621;
})();
var inst_16609 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_16618__$1 = state_16618;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16618__$1,(6),inst_16609);
} else {
if((state_val_16619 === (3))){
var inst_16616 = (state_16618[(2)]);
var state_16618__$1 = state_16618;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16618__$1,inst_16616);
} else {
if((state_val_16619 === (4))){
var inst_16603 = (state_16618[(2)]);
var state_16618__$1 = state_16618;
var statearr_16623_16635 = state_16618__$1;
(statearr_16623_16635[(2)] = inst_16603);

(statearr_16623_16635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16619 === (5))){
var _ = (function (){var statearr_16624 = state_16618;
(statearr_16624[(4)] = cljs.core.rest.call(null,(state_16618[(4)])));

return statearr_16624;
})();
var state_16618__$1 = state_16618;
var ex16622 = (state_16618__$1[(2)]);
var statearr_16625_16636 = state_16618__$1;
(statearr_16625_16636[(5)] = ex16622);


if((ex16622 instanceof Error)){
var statearr_16626_16637 = state_16618__$1;
(statearr_16626_16637[(1)] = (4));

(statearr_16626_16637[(5)] = null);

} else {
throw ex16622;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16619 === (6))){
var inst_16611 = (state_16618[(2)]);
var inst_16612 = fluree.db.util.async.throw_err.call(null,inst_16611);
var inst_16613 = cljs.core.keyword.call(null,inst_16612);
var _ = (function (){var statearr_16627 = state_16618;
(statearr_16627[(4)] = cljs.core.rest.call(null,(state_16618[(4)])));

return statearr_16627;
})();
var state_16618__$1 = state_16618;
var statearr_16628_16638 = state_16618__$1;
(statearr_16628_16638[(2)] = inst_16613);

(statearr_16628_16638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0 = (function (){
var statearr_16629 = [null,null,null,null,null,null,null];
(statearr_16629[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__);

(statearr_16629[(1)] = (1));

return statearr_16629;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1 = (function (state_16618){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16618);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16630){var ex__2749__auto__ = e16630;
var statearr_16631_16639 = state_16618;
(statearr_16631_16639[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16618[(4)]))){
var statearr_16632_16640 = state_16618;
(statearr_16632_16640[(1)] = cljs.core.first.call(null,(state_16618[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16641 = state_16618;
state_16618 = G__16641;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__ = function(state_16618){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1.call(this,state_16618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16633 = f__2769__auto__.call(null);
(statearr_16633[(6)] = c__2768__auto__);

return statearr_16633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16673){
var state_val_16674 = (state_16673[(1)]);
if((state_val_16674 === (7))){
var inst_16657 = (state_16673[(7)]);
var inst_16659 = cljs.core.empty_QMARK_.call(null,inst_16657);
var inst_16660 = (!(inst_16659));
var state_16673__$1 = state_16673;
var statearr_16675_16699 = state_16673__$1;
(statearr_16675_16699[(2)] = inst_16660);

(statearr_16675_16699[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16674 === (1))){
var state_16673__$1 = state_16673;
var statearr_16676_16700 = state_16673__$1;
(statearr_16676_16700[(2)] = null);

(statearr_16676_16700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16674 === (4))){
var inst_16643 = (state_16673[(2)]);
var state_16673__$1 = state_16673;
var statearr_16677_16701 = state_16673__$1;
(statearr_16677_16701[(2)] = inst_16643);

(statearr_16677_16701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16674 === (6))){
var inst_16649 = (state_16673[(8)]);
var inst_16657 = (state_16673[(7)]);
var inst_16655 = (state_16673[(2)]);
var inst_16656 = fluree.db.util.async.throw_err.call(null,inst_16655);
var inst_16657__$1 = cljs.core.map.call(null,inst_16649,inst_16656);
var state_16673__$1 = (function (){var statearr_16678 = state_16673;
(statearr_16678[(7)] = inst_16657__$1);

return statearr_16678;
})();
if(cljs.core.truth_(inst_16657__$1)){
var statearr_16679_16702 = state_16673__$1;
(statearr_16679_16702[(1)] = (7));

} else {
var statearr_16680_16703 = state_16673__$1;
(statearr_16680_16703[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16674 === (3))){
var inst_16671 = (state_16673[(2)]);
var state_16673__$1 = state_16673;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16673__$1,inst_16671);
} else {
if((state_val_16674 === (12))){
var inst_16668 = (state_16673[(2)]);
var _ = (function (){var statearr_16681 = state_16673;
(statearr_16681[(4)] = cljs.core.rest.call(null,(state_16673[(4)])));

return statearr_16681;
})();
var state_16673__$1 = state_16673;
var statearr_16682_16704 = state_16673__$1;
(statearr_16682_16704[(2)] = inst_16668);

(statearr_16682_16704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16674 === (2))){
var _ = (function (){var statearr_16683 = state_16673;
(statearr_16683[(4)] = cljs.core.cons.call(null,(5),(state_16673[(4)])));

return statearr_16683;
})();
var inst_16649 = (function (){return (function (p1__16642_SHARP_){
return p1__16642_SHARP_.o;
});
})();
var inst_16650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16651 = [pred_id];
var inst_16652 = (new cljs.core.PersistentVector(null,1,(5),inst_16650,inst_16651,null));
var inst_16653 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16652);
var state_16673__$1 = (function (){var statearr_16684 = state_16673;
(statearr_16684[(8)] = inst_16649);

return statearr_16684;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16673__$1,(6),inst_16653);
} else {
if((state_val_16674 === (11))){
var state_16673__$1 = state_16673;
var statearr_16686_16705 = state_16673__$1;
(statearr_16686_16705[(2)] = true);

(statearr_16686_16705[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16674 === (9))){
var inst_16663 = (state_16673[(2)]);
var state_16673__$1 = state_16673;
if(cljs.core.truth_(inst_16663)){
var statearr_16687_16706 = state_16673__$1;
(statearr_16687_16706[(1)] = (10));

} else {
var statearr_16688_16707 = state_16673__$1;
(statearr_16688_16707[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16674 === (5))){
var _ = (function (){var statearr_16689 = state_16673;
(statearr_16689[(4)] = cljs.core.rest.call(null,(state_16673[(4)])));

return statearr_16689;
})();
var state_16673__$1 = state_16673;
var ex16685 = (state_16673__$1[(2)]);
var statearr_16690_16708 = state_16673__$1;
(statearr_16690_16708[(5)] = ex16685);


if((ex16685 instanceof Error)){
var statearr_16691_16709 = state_16673__$1;
(statearr_16691_16709[(1)] = (4));

(statearr_16691_16709[(5)] = null);

} else {
throw ex16685;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16674 === (10))){
var inst_16657 = (state_16673[(7)]);
var inst_16665 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_16657);
var state_16673__$1 = state_16673;
var statearr_16692_16710 = state_16673__$1;
(statearr_16692_16710[(2)] = inst_16665);

(statearr_16692_16710[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16674 === (8))){
var inst_16657 = (state_16673[(7)]);
var state_16673__$1 = state_16673;
var statearr_16693_16711 = state_16673__$1;
(statearr_16693_16711[(2)] = inst_16657);

(statearr_16693_16711[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_16694 = [null,null,null,null,null,null,null,null,null];
(statearr_16694[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__);

(statearr_16694[(1)] = (1));

return statearr_16694;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1 = (function (state_16673){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16695){var ex__2749__auto__ = e16695;
var statearr_16696_16712 = state_16673;
(statearr_16696_16712[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16673[(4)]))){
var statearr_16697_16713 = state_16673;
(statearr_16697_16713[(1)] = cljs.core.first.call(null,(state_16673[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16714 = state_16673;
state_16673 = G__16714;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__ = function(state_16673){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1.call(this,state_16673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16698 = f__2769__auto__.call(null);
(statearr_16698[(6)] = c__2768__auto__);

return statearr_16698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16795){
var state_val_16796 = (state_16795[(1)]);
if((state_val_16796 === (7))){
var state_16795__$1 = state_16795;
var statearr_16797_16834 = state_16795__$1;
(statearr_16797_16834[(2)] = flakes);

(statearr_16797_16834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (20))){
var inst_16752 = (state_16795[(7)]);
var inst_16785 = (state_16795[(2)]);
var inst_16744 = inst_16752;
var inst_16745 = inst_16785;
var state_16795__$1 = (function (){var statearr_16798 = state_16795;
(statearr_16798[(8)] = inst_16744);

(statearr_16798[(9)] = inst_16745);

return statearr_16798;
})();
var statearr_16799_16835 = state_16795__$1;
(statearr_16799_16835[(2)] = null);

(statearr_16799_16835[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (1))){
var state_16795__$1 = state_16795;
var statearr_16800_16836 = state_16795__$1;
(statearr_16800_16836[(2)] = null);

(statearr_16800_16836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (4))){
var inst_16717 = (state_16795[(2)]);
var state_16795__$1 = state_16795;
var statearr_16801_16837 = state_16795__$1;
(statearr_16801_16837[(2)] = inst_16717);

(statearr_16801_16837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (15))){
var inst_16751 = (state_16795[(10)]);
var inst_16769 = inst_16751.o;
var state_16795__$1 = state_16795;
var statearr_16802_16838 = state_16795__$1;
(statearr_16802_16838[(2)] = inst_16769);

(statearr_16802_16838[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (13))){
var inst_16788 = (state_16795[(2)]);
var state_16795__$1 = state_16795;
var statearr_16803_16839 = state_16795__$1;
(statearr_16803_16839[(2)] = inst_16788);

(statearr_16803_16839[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (6))){
var inst_16724 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16795__$1 = state_16795;
var statearr_16804_16840 = state_16795__$1;
(statearr_16804_16840[(2)] = inst_16724);

(statearr_16804_16840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (17))){
var inst_16766 = (state_16795[(2)]);
var inst_16767 = fluree.db.util.async.throw_err.call(null,inst_16766);
var state_16795__$1 = state_16795;
var statearr_16805_16841 = state_16795__$1;
(statearr_16805_16841[(2)] = inst_16767);

(statearr_16805_16841[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (3))){
var inst_16793 = (state_16795[(2)]);
var state_16795__$1 = state_16795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16795__$1,inst_16793);
} else {
if((state_val_16796 === (12))){
var inst_16758 = (state_16795[(11)]);
var inst_16751 = (state_16795[(10)]);
var inst_16756 = inst_16751.p;
var inst_16757 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16756);
var inst_16758__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_16757);
var inst_16759 = inst_16751.op;
var inst_16760 = inst_16759 === false;
var inst_16761 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_16758__$1);
var state_16795__$1 = (function (){var statearr_16806 = state_16795;
(statearr_16806[(12)] = inst_16760);

(statearr_16806[(11)] = inst_16758__$1);

return statearr_16806;
})();
if(inst_16761){
var statearr_16807_16842 = state_16795__$1;
(statearr_16807_16842[(1)] = (14));

} else {
var statearr_16808_16843 = state_16795__$1;
(statearr_16808_16843[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (2))){
var _ = (function (){var statearr_16809 = state_16795;
(statearr_16809[(4)] = cljs.core.cons.call(null,(5),(state_16795[(4)])));

return statearr_16809;
})();
var state_16795__$1 = state_16795;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16810_16844 = state_16795__$1;
(statearr_16810_16844[(1)] = (6));

} else {
var statearr_16811_16845 = state_16795__$1;
(statearr_16811_16845[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (19))){
var inst_16745 = (state_16795[(9)]);
var inst_16758 = (state_16795[(11)]);
var inst_16771 = (state_16795[(13)]);
var inst_16751 = (state_16795[(10)]);
var inst_16779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16780 = inst_16751.s;
var inst_16781 = [inst_16780,inst_16758,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16782 = (new cljs.core.PersistentVector(null,3,(5),inst_16779,inst_16781,null));
var inst_16783 = cljs.core.assoc_in.call(null,inst_16745,inst_16782,inst_16771);
var state_16795__$1 = state_16795;
var statearr_16812_16846 = state_16795__$1;
(statearr_16812_16846[(2)] = inst_16783);

(statearr_16812_16846[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (11))){
var inst_16745 = (state_16795[(9)]);
var state_16795__$1 = state_16795;
var statearr_16814_16847 = state_16795__$1;
(statearr_16814_16847[(2)] = inst_16745);

(statearr_16814_16847[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (9))){
var inst_16744 = (state_16795[(8)]);
var inst_16751 = (state_16795[(10)]);
var inst_16750 = cljs.core.seq.call(null,inst_16744);
var inst_16751__$1 = cljs.core.first.call(null,inst_16750);
var inst_16752 = cljs.core.next.call(null,inst_16750);
var inst_16753 = cljs.core.not.call(null,inst_16751__$1);
var state_16795__$1 = (function (){var statearr_16815 = state_16795;
(statearr_16815[(10)] = inst_16751__$1);

(statearr_16815[(7)] = inst_16752);

return statearr_16815;
})();
if(inst_16753){
var statearr_16816_16848 = state_16795__$1;
(statearr_16816_16848[(1)] = (11));

} else {
var statearr_16817_16849 = state_16795__$1;
(statearr_16817_16849[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (5))){
var _ = (function (){var statearr_16818 = state_16795;
(statearr_16818[(4)] = cljs.core.rest.call(null,(state_16795[(4)])));

return statearr_16818;
})();
var state_16795__$1 = state_16795;
var ex16813 = (state_16795__$1[(2)]);
var statearr_16819_16850 = state_16795__$1;
(statearr_16819_16850[(5)] = ex16813);


if((ex16813 instanceof Error)){
var statearr_16820_16851 = state_16795__$1;
(statearr_16820_16851[(1)] = (4));

(statearr_16820_16851[(5)] = null);

} else {
throw ex16813;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (14))){
var inst_16751 = (state_16795[(10)]);
var inst_16763 = inst_16751.o;
var inst_16764 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_16763,db);
var state_16795__$1 = state_16795;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16795__$1,(17),inst_16764);
} else {
if((state_val_16796 === (16))){
var inst_16760 = (state_16795[(12)]);
var inst_16771 = (state_16795[(2)]);
var state_16795__$1 = (function (){var statearr_16821 = state_16795;
(statearr_16821[(13)] = inst_16771);

return statearr_16821;
})();
if(cljs.core.truth_(inst_16760)){
var statearr_16822_16852 = state_16795__$1;
(statearr_16822_16852[(1)] = (18));

} else {
var statearr_16823_16853 = state_16795__$1;
(statearr_16823_16853[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (10))){
var inst_16790 = (state_16795[(2)]);
var _ = (function (){var statearr_16824 = state_16795;
(statearr_16824[(4)] = cljs.core.rest.call(null,(state_16795[(4)])));

return statearr_16824;
})();
var state_16795__$1 = state_16795;
var statearr_16825_16854 = state_16795__$1;
(statearr_16825_16854[(2)] = inst_16790);

(statearr_16825_16854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (18))){
var inst_16745 = (state_16795[(9)]);
var inst_16758 = (state_16795[(11)]);
var inst_16771 = (state_16795[(13)]);
var inst_16751 = (state_16795[(10)]);
var inst_16773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16774 = inst_16751.s;
var inst_16775 = [inst_16774,inst_16758,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16776 = (new cljs.core.PersistentVector(null,3,(5),inst_16773,inst_16775,null));
var inst_16777 = cljs.core.assoc_in.call(null,inst_16745,inst_16776,inst_16771);
var state_16795__$1 = state_16795;
var statearr_16826_16855 = state_16795__$1;
(statearr_16826_16855[(2)] = inst_16777);

(statearr_16826_16855[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16796 === (8))){
var inst_16727 = (state_16795[(2)]);
var inst_16728 = cljs.core.PersistentHashSet.EMPTY;
var inst_16729 = cljs.core.vals.call(null,tempids);
var inst_16730 = cljs.core.into.call(null,inst_16728,inst_16729);
var inst_16731 = (function (){var pred_flakes = inst_16727;
var is_new_QMARK_ = inst_16730;
return (function (p1__16716_SHARP_,p2__16715_SHARP_){
var f = p2__16715_SHARP_;
return cljs.core.assoc_in.call(null,p1__16716_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,f.s)));
});
})();
var inst_16732 = cljs.core.PersistentHashMap.EMPTY;
var inst_16733 = cljs.core.reduce.call(null,inst_16731,inst_16732,inst_16727);
var inst_16741 = cljs.core.seq.call(null,inst_16727);
var inst_16742 = cljs.core.first.call(null,inst_16741);
var inst_16743 = cljs.core.next.call(null,inst_16741);
var inst_16744 = inst_16727;
var inst_16745 = inst_16733;
var state_16795__$1 = (function (){var statearr_16827 = state_16795;
(statearr_16827[(8)] = inst_16744);

(statearr_16827[(9)] = inst_16745);

(statearr_16827[(14)] = inst_16743);

(statearr_16827[(15)] = inst_16742);

return statearr_16827;
})();
var statearr_16828_16856 = state_16795__$1;
(statearr_16828_16856[(2)] = null);

(statearr_16828_16856[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0 = (function (){
var statearr_16829 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16829[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__);

(statearr_16829[(1)] = (1));

return statearr_16829;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1 = (function (state_16795){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16830){var ex__2749__auto__ = e16830;
var statearr_16831_16857 = state_16795;
(statearr_16831_16857[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16795[(4)]))){
var statearr_16832_16858 = state_16795;
(statearr_16832_16858[(1)] = cljs.core.first.call(null,(state_16795[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16859 = state_16795;
state_16795 = G__16859;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__ = function(state_16795){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1.call(this,state_16795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16833 = f__2769__auto__.call(null);
(statearr_16833[(6)] = c__2768__auto__);

return statearr_16833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16861 = arguments.length;
switch (G__16861) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16864 = arguments.length;
switch (G__16864) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17176){
var state_val_17177 = (state_17176[(1)]);
if((state_val_17177 === (121))){
var inst_17131 = (state_17176[(7)]);
var state_17176__$1 = state_17176;
var statearr_17178_17371 = state_17176__$1;
(statearr_17178_17371[(2)] = inst_17131);

(statearr_17178_17371[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (65))){
var inst_17030 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17030)){
var statearr_17179_17372 = state_17176__$1;
(statearr_17179_17372[(1)] = (66));

} else {
var statearr_17180_17373 = state_17176__$1;
(statearr_17180_17373[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (70))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17040 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_17041 = inst_17036.call(null,cljs.core.PersistentArrayMap,null,3,inst_17040,null);
var inst_17042 = inst_17036.call(null,cljs.core.PersistentHashSet,null,inst_17041,null);
var inst_17043 = inst_17042.call(null,inst_17035);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17043)){
var statearr_17181_17374 = state_17176__$1;
(statearr_17181_17374[(1)] = (72));

} else {
var statearr_17182_17375 = state_17176__$1;
(statearr_17182_17375[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (62))){
var inst_17020 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17183_17376 = state_17176__$1;
(statearr_17183_17376[(2)] = inst_17020);

(statearr_17183_17376[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (74))){
var inst_17126 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17184_17377 = state_17176__$1;
(statearr_17184_17377[(2)] = inst_17126);

(statearr_17184_17377[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (110))){
var inst_17153 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17153)){
var statearr_17185_17378 = state_17176__$1;
(statearr_17185_17378[(1)] = (117));

} else {
var statearr_17186_17379 = state_17176__$1;
(statearr_17186_17379[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (7))){
var inst_17171 = (state_17176[(2)]);
var _ = (function (){var statearr_17187 = state_17176;
(statearr_17187[(4)] = cljs.core.rest.call(null,(state_17176[(4)])));

return statearr_17187;
})();
var state_17176__$1 = state_17176;
var statearr_17188_17380 = state_17176__$1;
(statearr_17188_17380[(2)] = inst_17171);

(statearr_17188_17380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (59))){
var inst_16904 = (state_17176[(10)]);
var inst_17024 = (state_17176[(11)]);
var inst_17023 = (state_17176[(2)]);
var inst_17024__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16904);
var state_17176__$1 = (function (){var statearr_17189 = state_17176;
(statearr_17189[(12)] = inst_17023);

(statearr_17189[(11)] = inst_17024__$1);

return statearr_17189;
})();
if(cljs.core.truth_(inst_17024__$1)){
var statearr_17190_17381 = state_17176__$1;
(statearr_17190_17381[(1)] = (63));

} else {
var statearr_17191_17382 = state_17176__$1;
(statearr_17191_17382[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (86))){
var inst_17066 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17192_17383 = state_17176__$1;
(statearr_17192_17383[(2)] = inst_17066);

(statearr_17192_17383[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (20))){
var inst_16930 = (state_17176[(13)]);
var inst_16904 = (state_17176[(10)]);
var inst_16930__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16904);
var state_17176__$1 = (function (){var statearr_17193 = state_17176;
(statearr_17193[(13)] = inst_16930__$1);

return statearr_17193;
})();
if(cljs.core.truth_(inst_16930__$1)){
var statearr_17194_17384 = state_17176__$1;
(statearr_17194_17384[(1)] = (23));

} else {
var statearr_17195_17385 = state_17176__$1;
(statearr_17195_17385[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (72))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17045 = fluree.db.query.schema.type_error.call(null,inst_17035,inst_17036,throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17196_17386 = state_17176__$1;
(statearr_17196_17386[(2)] = inst_17045);

(statearr_17196_17386[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (58))){
var inst_16985 = (state_17176[(14)]);
var state_17176__$1 = state_17176;
var statearr_17197_17387 = state_17176__$1;
(statearr_17197_17387[(2)] = inst_16985);

(statearr_17197_17387[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (60))){
var inst_16892 = (state_17176[(15)]);
var inst_16903 = (state_17176[(16)]);
var inst_17011 = fluree.db.dbproto._p_prop.call(null,inst_16892,new cljs.core.Keyword(null,"name","name",1843675177),inst_16903);
var inst_17012 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17011)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_17013 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17014 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_17015 = cljs.core.PersistentHashMap.fromArrays(inst_17013,inst_17014);
var inst_17016 = cljs.core.ex_info.call(null,inst_17012,inst_17015);
var inst_17017 = (function(){throw inst_17016})();
var state_17176__$1 = state_17176;
var statearr_17198_17388 = state_17176__$1;
(statearr_17198_17388[(2)] = inst_17017);

(statearr_17198_17388[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (27))){
var inst_16933 = (state_17176[(17)]);
var state_17176__$1 = state_17176;
var statearr_17199_17389 = state_17176__$1;
(statearr_17199_17389[(2)] = inst_16933);

(statearr_17199_17389[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (1))){
var state_17176__$1 = state_17176;
var statearr_17200_17390 = state_17176__$1;
(statearr_17200_17390[(2)] = null);

(statearr_17200_17390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (69))){
var inst_17023 = (state_17176[(12)]);
var state_17176__$1 = state_17176;
var statearr_17201_17391 = state_17176__$1;
(statearr_17201_17391[(2)] = inst_17023);

(statearr_17201_17391[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (101))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17104 = fluree.db.query.schema.type_error.call(null,inst_17035,inst_17036,throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17202_17392 = state_17176__$1;
(statearr_17202_17392[(2)] = inst_17104);

(statearr_17202_17392[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (24))){
var inst_16930 = (state_17176[(13)]);
var state_17176__$1 = state_17176;
var statearr_17203_17393 = state_17176__$1;
(statearr_17203_17393[(2)] = inst_16930);

(statearr_17203_17393[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (102))){
var inst_17106 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17204_17394 = state_17176__$1;
(statearr_17204_17394[(2)] = inst_17106);

(statearr_17204_17394[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (55))){
var inst_17002 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17205_17395 = state_17176__$1;
(statearr_17205_17395[(2)] = inst_17002);

(statearr_17205_17395[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (85))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17064 = fluree.db.query.schema.type_error.call(null,inst_17035,inst_17036,throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17206_17396 = state_17176__$1;
(statearr_17206_17396[(2)] = inst_17064);

(statearr_17206_17396[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (39))){
var inst_16967 = (state_17176[(18)]);
var state_17176__$1 = state_17176;
var statearr_17207_17397 = state_17176__$1;
(statearr_17207_17397[(2)] = inst_16967);

(statearr_17207_17397[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (88))){
var inst_17023 = (state_17176[(12)]);
var state_17176__$1 = state_17176;
var statearr_17208_17398 = state_17176__$1;
(statearr_17208_17398[(2)] = inst_17023);

(statearr_17208_17398[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (46))){
var inst_16986 = (state_17176[(19)]);
var inst_16904 = (state_17176[(10)]);
var inst_16985 = (state_17176[(2)]);
var inst_16986__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16904);
var state_17176__$1 = (function (){var statearr_17209 = state_17176;
(statearr_17209[(14)] = inst_16985);

(statearr_17209[(19)] = inst_16986__$1);

return statearr_17209;
})();
if(cljs.core.truth_(inst_16986__$1)){
var statearr_17210_17399 = state_17176__$1;
(statearr_17210_17399[(1)] = (47));

} else {
var statearr_17211_17400 = state_17176__$1;
(statearr_17211_17400[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (4))){
var inst_16865 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17212_17401 = state_17176__$1;
(statearr_17212_17401[(2)] = inst_16865);

(statearr_17212_17401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (77))){
var inst_17124 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17213_17402 = state_17176__$1;
(statearr_17213_17402[(2)] = inst_17124);

(statearr_17213_17402[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (106))){
var inst_17116 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17214_17403 = state_17176__$1;
(statearr_17214_17403[(2)] = inst_17116);

(statearr_17214_17403[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (119))){
var inst_16902 = (state_17176[(20)]);
var inst_17166 = (state_17176[(2)]);
var inst_16891 = inst_16902;
var inst_16892 = inst_17166;
var state_17176__$1 = (function (){var statearr_17215 = state_17176;
(statearr_17215[(15)] = inst_16892);

(statearr_17215[(21)] = inst_16891);

return statearr_17215;
})();
var statearr_17216_17404 = state_17176__$1;
(statearr_17216_17404[(2)] = null);

(statearr_17216_17404[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (95))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17088 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17089 = inst_17036.call(null,cljs.core.PersistentArrayMap,null,5,inst_17088,null);
var inst_17090 = inst_17036.call(null,cljs.core.PersistentHashSet,null,inst_17089,null);
var inst_17091 = inst_17090.call(null,inst_17035);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17091)){
var statearr_17217_17405 = state_17176__$1;
(statearr_17217_17405[(1)] = (96));

} else {
var statearr_17218_17406 = state_17176__$1;
(statearr_17218_17406[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (54))){
var inst_16993 = (state_17176[(22)]);
var state_17176__$1 = state_17176;
var statearr_17219_17407 = state_17176__$1;
(statearr_17219_17407[(2)] = inst_16993);

(statearr_17219_17407[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (92))){
var inst_17023 = (state_17176[(12)]);
var state_17176__$1 = state_17176;
var statearr_17220_17408 = state_17176__$1;
(statearr_17220_17408[(2)] = inst_17023);

(statearr_17220_17408[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (104))){
var inst_17023 = (state_17176[(12)]);
var state_17176__$1 = state_17176;
var statearr_17221_17409 = state_17176__$1;
(statearr_17221_17409[(2)] = inst_17023);

(statearr_17221_17409[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (15))){
var inst_16912 = (state_17176[(23)]);
var state_17176__$1 = state_17176;
var statearr_17222_17410 = state_17176__$1;
(statearr_17222_17410[(2)] = inst_16912);

(statearr_17222_17410[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (48))){
var inst_16986 = (state_17176[(19)]);
var state_17176__$1 = state_17176;
var statearr_17223_17411 = state_17176__$1;
(statearr_17223_17411[(2)] = inst_16986);

(statearr_17223_17411[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (50))){
var inst_16993 = (state_17176[(22)]);
var inst_16904 = (state_17176[(10)]);
var inst_16991 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_16992 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16991);
var inst_16993__$1 = inst_16992 === true;
var state_17176__$1 = (function (){var statearr_17224 = state_17176;
(statearr_17224[(22)] = inst_16993__$1);

return statearr_17224;
})();
if(cljs.core.truth_(inst_16993__$1)){
var statearr_17225_17412 = state_17176__$1;
(statearr_17225_17412[(1)] = (53));

} else {
var statearr_17226_17413 = state_17176__$1;
(statearr_17226_17413[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (116))){
var inst_17147 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17227_17414 = state_17176__$1;
(statearr_17227_17414[(2)] = inst_17147);

(statearr_17227_17414[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (75))){
var inst_17036 = (state_17176[(8)]);
var state_17176__$1 = state_17176;
var G__17228_17415 = inst_17036;
var G__17228_17416__$1 = (((G__17228_17415 instanceof cljs.core.Keyword))?G__17228_17415.fqn:null);
switch (G__17228_17416__$1) {
case "long":
var statearr_17229_17418 = state_17176__$1;
(statearr_17229_17418[(1)] = (79));


break;
case "bigint":
var statearr_17230_17419 = state_17176__$1;
(statearr_17230_17419[(1)] = (83));


break;
case "double":
var statearr_17231_17420 = state_17176__$1;
(statearr_17231_17420[(1)] = (87));


break;
case "float":
var statearr_17232_17421 = state_17176__$1;
(statearr_17232_17421[(1)] = (91));


break;
case "bigdec":
var statearr_17233_17422 = state_17176__$1;
(statearr_17233_17422[(1)] = (95));


break;
case "string":
var statearr_17234_17423 = state_17176__$1;
(statearr_17234_17423[(1)] = (99));


break;
case "instant":
var statearr_17235_17424 = state_17176__$1;
(statearr_17235_17424[(1)] = (103));


break;
default:
var statearr_17236_17425 = state_17176__$1;
(statearr_17236_17425[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (99))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17098 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_17099 = inst_17036.call(null,cljs.core.PersistentArrayMap,null,5,inst_17098,null);
var inst_17100 = inst_17036.call(null,cljs.core.PersistentHashSet,null,inst_17099,null);
var inst_17101 = inst_17100.call(null,inst_17035);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17101)){
var statearr_17237_17426 = state_17176__$1;
(statearr_17237_17426[(1)] = (100));

} else {
var statearr_17238_17427 = state_17176__$1;
(statearr_17238_17427[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (21))){
var inst_16928 = (state_17176[(24)]);
var state_17176__$1 = state_17176;
var statearr_17239_17428 = state_17176__$1;
(statearr_17239_17428[(2)] = inst_16928);

(statearr_17239_17428[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (31))){
var inst_16944 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17240_17429 = state_17176__$1;
(statearr_17240_17429[(2)] = inst_16944);

(statearr_17240_17429[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (113))){
var inst_17150 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17241_17430 = state_17176__$1;
(statearr_17241_17430[(2)] = inst_17150);

(statearr_17241_17430[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (32))){
var state_17176__$1 = state_17176;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17242_17431 = state_17176__$1;
(statearr_17242_17431[(1)] = (35));

} else {
var statearr_17243_17432 = state_17176__$1;
(statearr_17243_17432[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (40))){
var inst_16980 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_16980)){
var statearr_17244_17433 = state_17176__$1;
(statearr_17244_17433[(1)] = (44));

} else {
var statearr_17245_17434 = state_17176__$1;
(statearr_17245_17434[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (91))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17078 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17079 = inst_17036.call(null,cljs.core.PersistentArrayMap,null,3,inst_17078,null);
var inst_17080 = inst_17036.call(null,cljs.core.PersistentHashSet,null,inst_17079,null);
var inst_17081 = inst_17080.call(null,inst_17035);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17081)){
var statearr_17246_17435 = state_17176__$1;
(statearr_17246_17435[(1)] = (92));

} else {
var statearr_17247_17436 = state_17176__$1;
(statearr_17247_17436[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (117))){
var state_17176__$1 = state_17176;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17248_17437 = state_17176__$1;
(statearr_17248_17437[(1)] = (120));

} else {
var statearr_17249_17438 = state_17176__$1;
(statearr_17249_17438[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (108))){
var inst_17135 = (state_17176[(25)]);
var inst_16904 = (state_17176[(10)]);
var inst_17135__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16904);
var state_17176__$1 = (function (){var statearr_17250 = state_17176;
(statearr_17250[(25)] = inst_17135__$1);

return statearr_17250;
})();
if(cljs.core.truth_(inst_17135__$1)){
var statearr_17251_17439 = state_17176__$1;
(statearr_17251_17439[(1)] = (111));

} else {
var statearr_17252_17440 = state_17176__$1;
(statearr_17252_17440[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (56))){
var inst_16997 = (state_17176[(2)]);
var inst_16998 = fluree.db.util.async.throw_err.call(null,inst_16997);
var inst_16999 = cljs.core.not.call(null,inst_16998);
var state_17176__$1 = state_17176;
var statearr_17253_17441 = state_17176__$1;
(statearr_17253_17441[(2)] = inst_16999);

(statearr_17253_17441[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (33))){
var inst_16927 = (state_17176[(26)]);
var state_17176__$1 = state_17176;
var statearr_17254_17442 = state_17176__$1;
(statearr_17254_17442[(2)] = inst_16927);

(statearr_17254_17442[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (13))){
var inst_16922 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_16922)){
var statearr_17255_17443 = state_17176__$1;
(statearr_17255_17443[(1)] = (17));

} else {
var statearr_17256_17444 = state_17176__$1;
(statearr_17256_17444[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (22))){
var inst_16953 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_16953)){
var statearr_17257_17445 = state_17176__$1;
(statearr_17257_17445[(1)] = (32));

} else {
var statearr_17258_17446 = state_17176__$1;
(statearr_17258_17446[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (90))){
var inst_17076 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17259_17447 = state_17176__$1;
(statearr_17259_17447[(2)] = inst_17076);

(statearr_17259_17447[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (109))){
var inst_17133 = (state_17176[(27)]);
var state_17176__$1 = state_17176;
var statearr_17260_17448 = state_17176__$1;
(statearr_17260_17448[(2)] = inst_17133);

(statearr_17260_17448[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (36))){
var inst_16927 = (state_17176[(26)]);
var state_17176__$1 = state_17176;
var statearr_17261_17449 = state_17176__$1;
(statearr_17261_17449[(2)] = inst_16927);

(statearr_17261_17449[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (41))){
var inst_16904 = (state_17176[(10)]);
var inst_16972 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_16973 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16972);
var inst_16974 = inst_16973 === true;
var state_17176__$1 = state_17176;
var statearr_17262_17450 = state_17176__$1;
(statearr_17262_17450[(2)] = inst_16974);

(statearr_17262_17450[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (118))){
var inst_17131 = (state_17176[(7)]);
var state_17176__$1 = state_17176;
var statearr_17263_17451 = state_17176__$1;
(statearr_17263_17451[(2)] = inst_17131);

(statearr_17263_17451[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (89))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17074 = fluree.db.query.schema.type_error.call(null,inst_17035,inst_17036,throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17264_17452 = state_17176__$1;
(statearr_17264_17452[(2)] = inst_17074);

(statearr_17264_17452[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (100))){
var inst_17023 = (state_17176[(12)]);
var state_17176__$1 = state_17176;
var statearr_17265_17453 = state_17176__$1;
(statearr_17265_17453[(2)] = inst_17023);

(statearr_17265_17453[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (122))){
var inst_17163 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17266_17454 = state_17176__$1;
(statearr_17266_17454[(2)] = inst_17163);

(statearr_17266_17454[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (43))){
var inst_16977 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17267_17455 = state_17176__$1;
(statearr_17267_17455[(2)] = inst_16977);

(statearr_17267_17455[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (61))){
var inst_16985 = (state_17176[(14)]);
var state_17176__$1 = state_17176;
var statearr_17268_17456 = state_17176__$1;
(statearr_17268_17456[(2)] = inst_16985);

(statearr_17268_17456[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (29))){
var inst_16904 = (state_17176[(10)]);
var inst_16939 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_16940 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16939);
var inst_16941 = inst_16940 === true;
var state_17176__$1 = state_17176;
var statearr_17269_17457 = state_17176__$1;
(statearr_17269_17457[(2)] = inst_16941);

(statearr_17269_17457[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (44))){
var inst_16966 = (state_17176[(28)]);
var inst_16982 = fluree.db.query.schema.type_error.call(null,inst_16966,"a component","a non-component",throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17270_17458 = state_17176__$1;
(statearr_17270_17458[(2)] = inst_16982);

(statearr_17270_17458[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (93))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17084 = fluree.db.query.schema.type_error.call(null,inst_17035,inst_17036,throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17271_17459 = state_17176__$1;
(statearr_17271_17459[(2)] = inst_17084);

(statearr_17271_17459[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (6))){
var inst_16891 = (state_17176[(21)]);
var inst_16903 = (state_17176[(16)]);
var inst_16900 = cljs.core.seq.call(null,inst_16891);
var inst_16901 = cljs.core.first.call(null,inst_16900);
var inst_16902 = cljs.core.next.call(null,inst_16900);
var inst_16903__$1 = cljs.core.nth.call(null,inst_16901,(0),null);
var inst_16904 = cljs.core.nth.call(null,inst_16901,(1),null);
var inst_16905 = cljs.core.not.call(null,inst_16903__$1);
var state_17176__$1 = (function (){var statearr_17272 = state_17176;
(statearr_17272[(10)] = inst_16904);

(statearr_17272[(20)] = inst_16902);

(statearr_17272[(16)] = inst_16903__$1);

return statearr_17272;
})();
if(inst_16905){
var statearr_17273_17460 = state_17176__$1;
(statearr_17273_17460[(1)] = (8));

} else {
var statearr_17274_17461 = state_17176__$1;
(statearr_17274_17461[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (111))){
var inst_17139 = (state_17176[(29)]);
var inst_16904 = (state_17176[(10)]);
var inst_17137 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_17138 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_17137);
var inst_17139__$1 = inst_17138 === true;
var state_17176__$1 = (function (){var statearr_17275 = state_17176;
(statearr_17275[(29)] = inst_17139__$1);

return statearr_17275;
})();
if(cljs.core.truth_(inst_17139__$1)){
var statearr_17276_17462 = state_17176__$1;
(statearr_17276_17462[(1)] = (114));

} else {
var statearr_17277_17463 = state_17176__$1;
(statearr_17277_17463[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (28))){
var inst_16947 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17278_17464 = state_17176__$1;
(statearr_17278_17464[(2)] = inst_16947);

(statearr_17278_17464[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (64))){
var inst_17024 = (state_17176[(11)]);
var state_17176__$1 = state_17176;
var statearr_17279_17465 = state_17176__$1;
(statearr_17279_17465[(2)] = inst_17024);

(statearr_17279_17465[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (103))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17108 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17109 = inst_17036.call(null,cljs.core.PersistentArrayMap,null,2,inst_17108,null);
var inst_17110 = inst_17036.call(null,cljs.core.PersistentHashSet,null,inst_17109,null);
var inst_17111 = inst_17110.call(null,inst_17035);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17111)){
var statearr_17280_17466 = state_17176__$1;
(statearr_17280_17466[(1)] = (104));

} else {
var statearr_17281_17467 = state_17176__$1;
(statearr_17281_17467[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (51))){
var inst_16989 = (state_17176[(30)]);
var state_17176__$1 = state_17176;
var statearr_17282_17468 = state_17176__$1;
(statearr_17282_17468[(2)] = inst_16989);

(statearr_17282_17468[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (25))){
var inst_16950 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17283_17469 = state_17176__$1;
(statearr_17283_17469[(2)] = inst_16950);

(statearr_17283_17469[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (34))){
var inst_16967 = (state_17176[(18)]);
var inst_16904 = (state_17176[(10)]);
var inst_16966 = (state_17176[(2)]);
var inst_16967__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16904);
var state_17176__$1 = (function (){var statearr_17284 = state_17176;
(statearr_17284[(18)] = inst_16967__$1);

(statearr_17284[(28)] = inst_16966);

return statearr_17284;
})();
if(cljs.core.truth_(inst_16967__$1)){
var statearr_17285_17470 = state_17176__$1;
(statearr_17285_17470[(1)] = (38));

} else {
var statearr_17286_17471 = state_17176__$1;
(statearr_17286_17471[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (17))){
var inst_16892 = (state_17176[(15)]);
var inst_16924 = fluree.db.query.schema.type_error.call(null,inst_16892,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17287_17472 = state_17176__$1;
(statearr_17287_17472[(2)] = inst_16924);

(statearr_17287_17472[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (3))){
var inst_17174 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17176__$1,inst_17174);
} else {
if((state_val_17177 === (12))){
var inst_16908 = (state_17176[(31)]);
var state_17176__$1 = state_17176;
var statearr_17288_17473 = state_17176__$1;
(statearr_17288_17473[(2)] = inst_16908);

(statearr_17288_17473[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (2))){
var _ = (function (){var statearr_17289 = state_17176;
(statearr_17289[(4)] = cljs.core.cons.call(null,(5),(state_17176[(4)])));

return statearr_17289;
})();
var inst_16884 = pred_changes;
var inst_16885 = cljs.core.seq.call(null,inst_16884);
var inst_16886 = cljs.core.first.call(null,inst_16885);
var inst_16887 = cljs.core.next.call(null,inst_16885);
var inst_16888 = cljs.core.nth.call(null,inst_16886,(0),null);
var inst_16889 = cljs.core.nth.call(null,inst_16886,(1),null);
var inst_16890 = db;
var inst_16891 = inst_16884;
var inst_16892 = inst_16890;
var state_17176__$1 = (function (){var statearr_17290 = state_17176;
(statearr_17290[(32)] = inst_16889);

(statearr_17290[(33)] = inst_16887);

(statearr_17290[(15)] = inst_16892);

(statearr_17290[(34)] = inst_16888);

(statearr_17290[(21)] = inst_16891);

return statearr_17290;
})();
var statearr_17291_17474 = state_17176__$1;
(statearr_17291_17474[(2)] = null);

(statearr_17291_17474[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (66))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_16904 = (state_17176[(10)]);
var inst_17033 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_17034 = cljs.core.__destructure_map.call(null,inst_17033);
var inst_17035__$1 = cljs.core.get.call(null,inst_17034,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_17036__$1 = cljs.core.get.call(null,inst_17034,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_17037 = cljs.core._EQ_.call(null,inst_17036__$1,inst_17035__$1);
var state_17176__$1 = (function (){var statearr_17292 = state_17176;
(statearr_17292[(8)] = inst_17036__$1);

(statearr_17292[(9)] = inst_17035__$1);

return statearr_17292;
})();
if(inst_17037){
var statearr_17293_17475 = state_17176__$1;
(statearr_17293_17475[(1)] = (69));

} else {
var statearr_17294_17476 = state_17176__$1;
(statearr_17294_17476[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (107))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17118 = fluree.db.query.schema.type_error.call(null,inst_17035,inst_17036,throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17295_17477 = state_17176__$1;
(statearr_17295_17477[(2)] = inst_17118);

(statearr_17295_17477[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (23))){
var inst_16933 = (state_17176[(17)]);
var inst_16904 = (state_17176[(10)]);
var inst_16932 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_16933__$1 = inst_16932 === true;
var state_17176__$1 = (function (){var statearr_17296 = state_17176;
(statearr_17296[(17)] = inst_16933__$1);

return statearr_17296;
})();
if(cljs.core.truth_(inst_16933__$1)){
var statearr_17297_17478 = state_17176__$1;
(statearr_17297_17478[(1)] = (26));

} else {
var statearr_17298_17479 = state_17176__$1;
(statearr_17298_17479[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (47))){
var inst_16989 = (state_17176[(30)]);
var inst_16904 = (state_17176[(10)]);
var inst_16988 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_16989__$1 = cljs.core.not.call(null,inst_16988);
var state_17176__$1 = (function (){var statearr_17299 = state_17176;
(statearr_17299[(30)] = inst_16989__$1);

return statearr_17299;
})();
if(inst_16989__$1){
var statearr_17300_17480 = state_17176__$1;
(statearr_17300_17480[(1)] = (50));

} else {
var statearr_17301_17481 = state_17176__$1;
(statearr_17301_17481[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (35))){
var inst_16956 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16957 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16958 = cljs.core.PersistentHashMap.fromArrays(inst_16956,inst_16957);
var inst_16959 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_16958);
var inst_16960 = (function(){throw inst_16959})();
var state_17176__$1 = state_17176;
var statearr_17302_17482 = state_17176__$1;
(statearr_17302_17482[(2)] = inst_16960);

(statearr_17302_17482[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (82))){
var inst_17056 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17303_17483 = state_17176__$1;
(statearr_17303_17483[(2)] = inst_17056);

(statearr_17303_17483[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (76))){
var state_17176__$1 = state_17176;
var statearr_17304_17484 = state_17176__$1;
(statearr_17304_17484[(2)] = null);

(statearr_17304_17484[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (97))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17094 = fluree.db.query.schema.type_error.call(null,inst_17035,inst_17036,throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17305_17485 = state_17176__$1;
(statearr_17305_17485[(2)] = inst_17094);

(statearr_17305_17485[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (19))){
var inst_16928 = (state_17176[(24)]);
var inst_16904 = (state_17176[(10)]);
var inst_16927 = (state_17176[(2)]);
var inst_16928__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16904);
var state_17176__$1 = (function (){var statearr_17306 = state_17176;
(statearr_17306[(24)] = inst_16928__$1);

(statearr_17306[(26)] = inst_16927);

return statearr_17306;
})();
if(cljs.core.truth_(inst_16928__$1)){
var statearr_17307_17486 = state_17176__$1;
(statearr_17307_17486[(1)] = (20));

} else {
var statearr_17308_17487 = state_17176__$1;
(statearr_17308_17487[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (57))){
var state_17176__$1 = state_17176;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_17309_17488 = state_17176__$1;
(statearr_17309_17488[(1)] = (60));

} else {
var statearr_17310_17489 = state_17176__$1;
(statearr_17310_17489[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (68))){
var inst_17133 = (state_17176[(27)]);
var inst_16904 = (state_17176[(10)]);
var inst_17131 = (state_17176[(2)]);
var inst_17132 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_17133__$1 = inst_17132 === true;
var state_17176__$1 = (function (){var statearr_17311 = state_17176;
(statearr_17311[(7)] = inst_17131);

(statearr_17311[(27)] = inst_17133__$1);

return statearr_17311;
})();
if(cljs.core.truth_(inst_17133__$1)){
var statearr_17312_17490 = state_17176__$1;
(statearr_17312_17490[(1)] = (108));

} else {
var statearr_17313_17491 = state_17176__$1;
(statearr_17313_17491[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (11))){
var inst_16912 = (state_17176[(23)]);
var inst_16904 = (state_17176[(10)]);
var inst_16910 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_16911 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16910);
var inst_16912__$1 = inst_16911 === false;
var state_17176__$1 = (function (){var statearr_17314 = state_17176;
(statearr_17314[(23)] = inst_16912__$1);

return statearr_17314;
})();
if(cljs.core.truth_(inst_16912__$1)){
var statearr_17315_17492 = state_17176__$1;
(statearr_17315_17492[(1)] = (14));

} else {
var statearr_17316_17493 = state_17176__$1;
(statearr_17316_17493[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (115))){
var inst_17139 = (state_17176[(29)]);
var state_17176__$1 = state_17176;
var statearr_17318_17494 = state_17176__$1;
(statearr_17318_17494[(2)] = inst_17139);

(statearr_17318_17494[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (9))){
var inst_16904 = (state_17176[(10)]);
var inst_16908 = (state_17176[(31)]);
var inst_16908__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16904);
var state_17176__$1 = (function (){var statearr_17319 = state_17176;
(statearr_17319[(31)] = inst_16908__$1);

return statearr_17319;
})();
if(cljs.core.truth_(inst_16908__$1)){
var statearr_17320_17495 = state_17176__$1;
(statearr_17320_17495[(1)] = (11));

} else {
var statearr_17321_17496 = state_17176__$1;
(statearr_17321_17496[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (5))){
var _ = (function (){var statearr_17322 = state_17176;
(statearr_17322[(4)] = cljs.core.rest.call(null,(state_17176[(4)])));

return statearr_17322;
})();
var state_17176__$1 = state_17176;
var ex17317 = (state_17176__$1[(2)]);
var statearr_17323_17497 = state_17176__$1;
(statearr_17323_17497[(5)] = ex17317);


if((ex17317 instanceof Error)){
var statearr_17324_17498 = state_17176__$1;
(statearr_17324_17498[(1)] = (4));

(statearr_17324_17498[(5)] = null);

} else {
throw ex17317;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (112))){
var inst_17135 = (state_17176[(25)]);
var state_17176__$1 = state_17176;
var statearr_17325_17499 = state_17176__$1;
(statearr_17325_17499[(2)] = inst_17135);

(statearr_17325_17499[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (83))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17058 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17059 = inst_17036.call(null,cljs.core.PersistentArrayMap,null,3,inst_17058,null);
var inst_17060 = inst_17036.call(null,cljs.core.PersistentHashSet,null,inst_17059,null);
var inst_17061 = inst_17060.call(null,inst_17035);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17061)){
var statearr_17326_17500 = state_17176__$1;
(statearr_17326_17500[(1)] = (84));

} else {
var statearr_17327_17501 = state_17176__$1;
(statearr_17327_17501[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (14))){
var inst_16904 = (state_17176[(10)]);
var inst_16914 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_16915 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16914);
var inst_16916 = inst_16915 === true;
var state_17176__$1 = state_17176;
var statearr_17328_17502 = state_17176__$1;
(statearr_17328_17502[(2)] = inst_16916);

(statearr_17328_17502[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (45))){
var inst_16966 = (state_17176[(28)]);
var state_17176__$1 = state_17176;
var statearr_17329_17503 = state_17176__$1;
(statearr_17329_17503[(2)] = inst_16966);

(statearr_17329_17503[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (53))){
var inst_16892 = (state_17176[(15)]);
var inst_16903 = (state_17176[(16)]);
var inst_16995 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_16892,inst_16903);
var state_17176__$1 = state_17176;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17176__$1,(56),inst_16995);
} else {
if((state_val_17177 === (78))){
var inst_17121 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17330_17504 = state_17176__$1;
(statearr_17330_17504[(2)] = inst_17121);

(statearr_17330_17504[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (26))){
var inst_16937 = (state_17176[(35)]);
var inst_16904 = (state_17176[(10)]);
var inst_16935 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_16936 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16935);
var inst_16937__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16936);
var state_17176__$1 = (function (){var statearr_17331 = state_17176;
(statearr_17331[(35)] = inst_16937__$1);

return statearr_17331;
})();
if(inst_16937__$1){
var statearr_17332_17505 = state_17176__$1;
(statearr_17332_17505[(1)] = (29));

} else {
var statearr_17333_17506 = state_17176__$1;
(statearr_17333_17506[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (16))){
var inst_16919 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17334_17507 = state_17176__$1;
(statearr_17334_17507[(2)] = inst_16919);

(statearr_17334_17507[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (81))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17054 = fluree.db.query.schema.type_error.call(null,inst_17035,inst_17036,throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17335_17508 = state_17176__$1;
(statearr_17335_17508[(2)] = inst_17054);

(statearr_17335_17508[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (120))){
var inst_17156 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17157 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_17158 = cljs.core.PersistentHashMap.fromArrays(inst_17156,inst_17157);
var inst_17159 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_17158);
var inst_17160 = (function(){throw inst_17159})();
var state_17176__$1 = state_17176;
var statearr_17336_17509 = state_17176__$1;
(statearr_17336_17509[(2)] = inst_17160);

(statearr_17336_17509[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (79))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17048 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_17049 = inst_17036.call(null,cljs.core.PersistentArrayMap,null,2,inst_17048,null);
var inst_17050 = inst_17036.call(null,cljs.core.PersistentHashSet,null,inst_17049,null);
var inst_17051 = inst_17050.call(null,inst_17035);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17051)){
var statearr_17337_17510 = state_17176__$1;
(statearr_17337_17510[(1)] = (80));

} else {
var statearr_17338_17511 = state_17176__$1;
(statearr_17338_17511[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (38))){
var inst_16970 = (state_17176[(36)]);
var inst_16904 = (state_17176[(10)]);
var inst_16969 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_16970__$1 = cljs.core.not.call(null,inst_16969);
var state_17176__$1 = (function (){var statearr_17339 = state_17176;
(statearr_17339[(36)] = inst_16970__$1);

return statearr_17339;
})();
if(inst_16970__$1){
var statearr_17340_17512 = state_17176__$1;
(statearr_17340_17512[(1)] = (41));

} else {
var statearr_17341_17513 = state_17176__$1;
(statearr_17341_17513[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (98))){
var inst_17096 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17342_17514 = state_17176__$1;
(statearr_17342_17514[(2)] = inst_17096);

(statearr_17342_17514[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (87))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17068 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_17069 = inst_17036.call(null,cljs.core.PersistentArrayMap,null,3,inst_17068,null);
var inst_17070 = inst_17036.call(null,cljs.core.PersistentHashSet,null,inst_17069,null);
var inst_17071 = inst_17070.call(null,inst_17035);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17071)){
var statearr_17343_17515 = state_17176__$1;
(statearr_17343_17515[(1)] = (88));

} else {
var statearr_17344_17516 = state_17176__$1;
(statearr_17344_17516[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (30))){
var inst_16937 = (state_17176[(35)]);
var state_17176__$1 = state_17176;
var statearr_17345_17517 = state_17176__$1;
(statearr_17345_17517[(2)] = inst_16937);

(statearr_17345_17517[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (73))){
var state_17176__$1 = state_17176;
var statearr_17346_17518 = state_17176__$1;
(statearr_17346_17518[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (96))){
var inst_17023 = (state_17176[(12)]);
var state_17176__$1 = state_17176;
var statearr_17348_17519 = state_17176__$1;
(statearr_17348_17519[(2)] = inst_17023);

(statearr_17348_17519[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (10))){
var inst_17169 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17349_17520 = state_17176__$1;
(statearr_17349_17520[(2)] = inst_17169);

(statearr_17349_17520[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (18))){
var inst_16892 = (state_17176[(15)]);
var state_17176__$1 = state_17176;
var statearr_17350_17521 = state_17176__$1;
(statearr_17350_17521[(2)] = inst_16892);

(statearr_17350_17521[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (105))){
var inst_17036 = (state_17176[(8)]);
var inst_17035 = (state_17176[(9)]);
var inst_17114 = fluree.db.query.schema.type_error.call(null,inst_17035,inst_17036,throw_QMARK_);
var state_17176__$1 = state_17176;
var statearr_17351_17522 = state_17176__$1;
(statearr_17351_17522[(2)] = inst_17114);

(statearr_17351_17522[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (52))){
var inst_17005 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17352_17523 = state_17176__$1;
(statearr_17352_17523[(2)] = inst_17005);

(statearr_17352_17523[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (114))){
var inst_16904 = (state_17176[(10)]);
var inst_17141 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_17142 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_17141);
var inst_17143 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_17142);
var inst_17144 = (!(inst_17143));
var state_17176__$1 = state_17176;
var statearr_17353_17524 = state_17176__$1;
(statearr_17353_17524[(2)] = inst_17144);

(statearr_17353_17524[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (67))){
var inst_17023 = (state_17176[(12)]);
var state_17176__$1 = state_17176;
var statearr_17354_17525 = state_17176__$1;
(statearr_17354_17525[(2)] = inst_17023);

(statearr_17354_17525[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (71))){
var inst_17128 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17355_17526 = state_17176__$1;
(statearr_17355_17526[(2)] = inst_17128);

(statearr_17355_17526[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (42))){
var inst_16970 = (state_17176[(36)]);
var state_17176__$1 = state_17176;
var statearr_17356_17527 = state_17176__$1;
(statearr_17356_17527[(2)] = inst_16970);

(statearr_17356_17527[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (80))){
var inst_17023 = (state_17176[(12)]);
var state_17176__$1 = state_17176;
var statearr_17357_17528 = state_17176__$1;
(statearr_17357_17528[(2)] = inst_17023);

(statearr_17357_17528[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (37))){
var inst_16963 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17358_17529 = state_17176__$1;
(statearr_17358_17529[(2)] = inst_16963);

(statearr_17358_17529[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (63))){
var inst_16904 = (state_17176[(10)]);
var inst_17026 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16904);
var inst_17027 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_17026);
var state_17176__$1 = state_17176;
var statearr_17359_17530 = state_17176__$1;
(statearr_17359_17530[(2)] = inst_17027);

(statearr_17359_17530[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (94))){
var inst_17086 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17360_17531 = state_17176__$1;
(statearr_17360_17531[(2)] = inst_17086);

(statearr_17360_17531[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (8))){
var inst_16892 = (state_17176[(15)]);
var state_17176__$1 = state_17176;
var statearr_17361_17532 = state_17176__$1;
(statearr_17361_17532[(2)] = inst_16892);

(statearr_17361_17532[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (49))){
var inst_17008 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
if(cljs.core.truth_(inst_17008)){
var statearr_17362_17533 = state_17176__$1;
(statearr_17362_17533[(1)] = (57));

} else {
var statearr_17363_17534 = state_17176__$1;
(statearr_17363_17534[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (84))){
var inst_17023 = (state_17176[(12)]);
var state_17176__$1 = state_17176;
var statearr_17364_17535 = state_17176__$1;
(statearr_17364_17535[(2)] = inst_17023);

(statearr_17364_17535[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2746__auto__ = null;
var fluree$db$query$schema$state_machine__2746__auto____0 = (function (){
var statearr_17365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17365[(0)] = fluree$db$query$schema$state_machine__2746__auto__);

(statearr_17365[(1)] = (1));

return statearr_17365;
});
var fluree$db$query$schema$state_machine__2746__auto____1 = (function (state_17176){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17176);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17366){var ex__2749__auto__ = e17366;
var statearr_17367_17536 = state_17176;
(statearr_17367_17536[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17176[(4)]))){
var statearr_17368_17537 = state_17176;
(statearr_17368_17537[(1)] = cljs.core.first.call(null,(state_17176[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17538 = state_17176;
state_17176 = G__17538;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2746__auto__ = function(state_17176){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2746__auto____1.call(this,state_17176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2746__auto____0;
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2746__auto____1;
return fluree$db$query$schema$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17369 = f__2769__auto__.call(null);
(statearr_17369[(6)] = c__2768__auto__);

return statearr_17369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__17540 = arguments.length;
switch (G__17540) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17564){
var state_val_17565 = (state_17564[(1)]);
if((state_val_17565 === (7))){
var state_17564__$1 = state_17564;
var statearr_17566_17586 = state_17564__$1;
(statearr_17566_17586[(2)] = db);

(statearr_17566_17586[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17565 === (1))){
var state_17564__$1 = state_17564;
var statearr_17567_17587 = state_17564__$1;
(statearr_17567_17587[(2)] = null);

(statearr_17567_17587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17565 === (4))){
var inst_17541 = (state_17564[(2)]);
var state_17564__$1 = state_17564;
var statearr_17568_17588 = state_17564__$1;
(statearr_17568_17588[(2)] = inst_17541);

(statearr_17568_17588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17565 === (6))){
var inst_17550 = (state_17564[(7)]);
var inst_17549 = (state_17564[(2)]);
var inst_17550__$1 = fluree.db.util.async.throw_err.call(null,inst_17549);
var inst_17551 = cljs.core.empty_QMARK_.call(null,inst_17550__$1);
var state_17564__$1 = (function (){var statearr_17569 = state_17564;
(statearr_17569[(7)] = inst_17550__$1);

return statearr_17569;
})();
if(inst_17551){
var statearr_17570_17589 = state_17564__$1;
(statearr_17570_17589[(1)] = (7));

} else {
var statearr_17571_17590 = state_17564__$1;
(statearr_17571_17590[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17565 === (3))){
var inst_17562 = (state_17564[(2)]);
var state_17564__$1 = state_17564;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17564__$1,inst_17562);
} else {
if((state_val_17565 === (2))){
var _ = (function (){var statearr_17573 = state_17564;
(statearr_17573[(4)] = cljs.core.cons.call(null,(5),(state_17564[(4)])));

return statearr_17573;
})();
var inst_17547 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_17564__$1 = state_17564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17564__$1,(6),inst_17547);
} else {
if((state_val_17565 === (9))){
var inst_17559 = (state_17564[(2)]);
var _ = (function (){var statearr_17574 = state_17564;
(statearr_17574[(4)] = cljs.core.rest.call(null,(state_17564[(4)])));

return statearr_17574;
})();
var state_17564__$1 = state_17564;
var statearr_17575_17591 = state_17564__$1;
(statearr_17575_17591[(2)] = inst_17559);

(statearr_17575_17591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17565 === (5))){
var _ = (function (){var statearr_17576 = state_17564;
(statearr_17576[(4)] = cljs.core.rest.call(null,(state_17564[(4)])));

return statearr_17576;
})();
var state_17564__$1 = state_17564;
var ex17572 = (state_17564__$1[(2)]);
var statearr_17577_17592 = state_17564__$1;
(statearr_17577_17592[(5)] = ex17572);


if((ex17572 instanceof Error)){
var statearr_17578_17593 = state_17564__$1;
(statearr_17578_17593[(1)] = (4));

(statearr_17578_17593[(5)] = null);

} else {
throw ex17572;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17565 === (10))){
var inst_17556 = (state_17564[(2)]);
var inst_17557 = fluree.db.util.async.throw_err.call(null,inst_17556);
var state_17564__$1 = state_17564;
var statearr_17579_17594 = state_17564__$1;
(statearr_17579_17594[(2)] = inst_17557);

(statearr_17579_17594[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17565 === (8))){
var inst_17550 = (state_17564[(7)]);
var inst_17554 = fluree.db.query.schema.predicate_change_error.call(null,inst_17550,db,true);
var state_17564__$1 = state_17564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17564__$1,(10),inst_17554);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2746__auto__ = null;
var fluree$db$query$schema$state_machine__2746__auto____0 = (function (){
var statearr_17580 = [null,null,null,null,null,null,null,null];
(statearr_17580[(0)] = fluree$db$query$schema$state_machine__2746__auto__);

(statearr_17580[(1)] = (1));

return statearr_17580;
});
var fluree$db$query$schema$state_machine__2746__auto____1 = (function (state_17564){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17581){var ex__2749__auto__ = e17581;
var statearr_17582_17595 = state_17564;
(statearr_17582_17595[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17564[(4)]))){
var statearr_17583_17596 = state_17564;
(statearr_17583_17596[(1)] = cljs.core.first.call(null,(state_17564[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17597 = state_17564;
state_17564 = G__17597;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2746__auto__ = function(state_17564){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2746__auto____1.call(this,state_17564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2746__auto____0;
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2746__auto____1;
return fluree$db$query$schema$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17584 = f__2769__auto__.call(null);
(statearr_17584[(6)] = c__2768__auto__);

return statearr_17584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__17599 = arguments.length;
switch (G__17599) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__17601 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__17601,(0),null);
var ns = cljs.core.nth.call(null,vec__17601,(1),null);
var name = cljs.core.nth.call(null,vec__17601,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__17604_SHARP_,p2__17605_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17604_SHARP_,p2__17605_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__17606_SHARP_){
var f = p1__17606_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17672){
var state_val_17673 = (state_17672[(1)]);
if((state_val_17673 === (1))){
var state_17672__$1 = state_17672;
var statearr_17674_17691 = state_17672__$1;
(statearr_17674_17691[(2)] = null);

(statearr_17674_17691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17673 === (2))){
var _ = (function (){var statearr_17675 = state_17672;
(statearr_17675[(4)] = cljs.core.cons.call(null,(5),(state_17672[(4)])));

return statearr_17675;
})();
var inst_17624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17625 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_17626 = [inst_17625];
var inst_17627 = (new cljs.core.PersistentVector(null,1,(5),inst_17624,inst_17626,null));
var inst_17628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17629 = [(0)];
var inst_17630 = (new cljs.core.PersistentVector(null,1,(5),inst_17628,inst_17629,null));
var inst_17631 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_17627,cljs.core._LT__EQ_,inst_17630);
var state_17672__$1 = state_17672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17672__$1,(6),inst_17631);
} else {
if((state_val_17673 === (3))){
var inst_17670 = (state_17672[(2)]);
var state_17672__$1 = state_17672;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17672__$1,inst_17670);
} else {
if((state_val_17673 === (4))){
var inst_17612 = (state_17672[(2)]);
var state_17672__$1 = state_17672;
var statearr_17677_17692 = state_17672__$1;
(statearr_17677_17692[(2)] = inst_17612);

(statearr_17677_17692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17673 === (5))){
var _ = (function (){var statearr_17678 = state_17672;
(statearr_17678[(4)] = cljs.core.rest.call(null,(state_17672[(4)])));

return statearr_17678;
})();
var state_17672__$1 = state_17672;
var ex17676 = (state_17672__$1[(2)]);
var statearr_17679_17693 = state_17672__$1;
(statearr_17679_17693[(5)] = ex17676);


if((ex17676 instanceof Error)){
var statearr_17680_17694 = state_17672__$1;
(statearr_17680_17694[(1)] = (4));

(statearr_17680_17694[(5)] = null);

} else {
throw ex17676;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17673 === (6))){
var inst_17633 = (state_17672[(2)]);
var inst_17634 = fluree.db.util.async.throw_err.call(null,inst_17633);
var inst_17635 = (function (){var schema_flakes = inst_17634;
return (function (p1__17607_SHARP_){
return (p1__17607_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_17636 = cljs.core.partition_by.call(null,inst_17635,inst_17634);
var inst_17637 = cljs.core.nth.call(null,inst_17636,(0),null);
var inst_17638 = cljs.core.nth.call(null,inst_17636,(1),null);
var inst_17639 = (function (){var schema_flakes = inst_17634;
var vec__17618 = inst_17636;
var collection_flakes = inst_17637;
var predicate_flakes = inst_17638;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.call(null,(function (p1__17610_SHARP_,p2__17609_SHARP_){
var f = p2__17609_SHARP_;
return cljs.core.assoc.call(null,p1__17610_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_17640 = [(-1),"_tx"];
var inst_17641 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17642 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17643 = cljs.core.PersistentHashMap.fromArrays(inst_17641,inst_17642);
var inst_17644 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17645 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17646 = cljs.core.PersistentHashMap.fromArrays(inst_17644,inst_17645);
var inst_17647 = [inst_17643,inst_17646];
var inst_17648 = cljs.core.PersistentHashMap.fromArrays(inst_17640,inst_17647);
var inst_17649 = (function (){var schema_flakes = inst_17634;
var vec__17618 = inst_17636;
var collection_flakes = inst_17637;
var predicate_flakes = inst_17638;
return (function (p1__17608_SHARP_){
return p1__17608_SHARP_.s;
});
})();
var inst_17650 = cljs.core.partition_by.call(null,inst_17649,inst_17637);
var inst_17651 = cljs.core.reduce.call(null,inst_17639,inst_17648,inst_17650);
var inst_17653 = (function (){var schema_flakes = inst_17634;
var vec__17618 = inst_17636;
var collection_flakes = inst_17637;
var predicate_flakes = inst_17638;
var coll = inst_17651;
return (function (p__17652,pred_flakes){
var vec__17681 = p__17652;
var pred = cljs.core.nth.call(null,vec__17681,(0),null);
var fullText = cljs.core.nth.call(null,vec__17681,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_17654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17655 = cljs.core.PersistentHashMap.EMPTY;
var inst_17656 = cljs.core.PersistentHashSet.EMPTY;
var inst_17657 = [inst_17655,inst_17656];
var inst_17658 = (new cljs.core.PersistentVector(null,2,(5),inst_17654,inst_17657,null));
var inst_17659 = (function (){var schema_flakes = inst_17634;
var vec__17618 = inst_17636;
var collection_flakes = inst_17637;
var predicate_flakes = inst_17638;
var coll = inst_17651;
return (function (p1__17611_SHARP_){
return p1__17611_SHARP_.s;
});
})();
var inst_17660 = cljs.core.partition_by.call(null,inst_17659,inst_17638);
var inst_17661 = cljs.core.reduce.call(null,inst_17653,inst_17658,inst_17660);
var inst_17662 = cljs.core.nth.call(null,inst_17661,(0),null);
var inst_17663 = cljs.core.nth.call(null,inst_17661,(1),null);
var inst_17664 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17665 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17666 = [inst_17665,inst_17651,inst_17662,inst_17663];
var inst_17667 = cljs.core.PersistentHashMap.fromArrays(inst_17664,inst_17666);
var _ = (function (){var statearr_17684 = state_17672;
(statearr_17684[(4)] = cljs.core.rest.call(null,(state_17672[(4)])));

return statearr_17684;
})();
var state_17672__$1 = state_17672;
var statearr_17685_17695 = state_17672__$1;
(statearr_17685_17695[(2)] = inst_17667);

(statearr_17685_17695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0 = (function (){
var statearr_17686 = [null,null,null,null,null,null,null];
(statearr_17686[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2746__auto__);

(statearr_17686[(1)] = (1));

return statearr_17686;
});
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1 = (function (state_17672){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17687){var ex__2749__auto__ = e17687;
var statearr_17688_17696 = state_17672;
(statearr_17688_17696[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17672[(4)]))){
var statearr_17689_17697 = state_17672;
(statearr_17689_17697[(1)] = cljs.core.first.call(null,(state_17672[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17698 = state_17672;
state_17672 = G__17698;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__ = function(state_17672){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1.call(this,state_17672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17690 = f__2769__auto__.call(null);
(statearr_17690[(6)] = c__2768__auto__);

return statearr_17690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17740){
var state_val_17741 = (state_17740[(1)]);
if((state_val_17741 === (7))){
var inst_17723 = (state_17740[(2)]);
var inst_17724 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_17723);
var inst_17725 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17726 = cljs.core.get.call(null,inst_17724,(114));
var inst_17727 = cljs.core.boolean$.call(null,inst_17726);
var inst_17728 = cljs.core.get.call(null,inst_17724,(110));
var inst_17729 = cljs.core.get.call(null,inst_17724,(117));
var inst_17730 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_17729);
var inst_17731 = cljs.core.get.call(null,inst_17724,(111));
var inst_17732 = cljs.core.get.call(null,inst_17724,(115));
var inst_17733 = cljs.core.get.call(null,inst_17724,(112));
var inst_17734 = [inst_17727,inst_17728,inst_17730,inst_17731,inst_17732,inst_17733];
var inst_17735 = cljs.core.PersistentHashMap.fromArrays(inst_17725,inst_17734);
var _ = (function (){var statearr_17742 = state_17740;
(statearr_17742[(4)] = cljs.core.rest.call(null,(state_17740[(4)])));

return statearr_17742;
})();
var state_17740__$1 = state_17740;
var statearr_17743_17766 = state_17740__$1;
(statearr_17743_17766[(2)] = inst_17735);

(statearr_17743_17766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17741 === (1))){
var state_17740__$1 = state_17740;
var statearr_17744_17767 = state_17740__$1;
(statearr_17744_17767[(2)] = null);

(statearr_17744_17767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17741 === (4))){
var inst_17699 = (state_17740[(2)]);
var state_17740__$1 = state_17740;
var statearr_17745_17768 = state_17740__$1;
(statearr_17745_17768[(2)] = inst_17699);

(statearr_17745_17768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17741 === (6))){
var _ = (function (){var statearr_17746 = state_17740;
(statearr_17746[(4)] = cljs.core.cons.call(null,(9),(state_17740[(4)])));

return statearr_17746;
})();
var inst_17711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17713 = ["_setting/id","root"];
var inst_17714 = (new cljs.core.PersistentVector(null,2,(5),inst_17712,inst_17713,null));
var inst_17715 = [inst_17714];
var inst_17716 = (new cljs.core.PersistentVector(null,1,(5),inst_17711,inst_17715,null));
var inst_17717 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17716);
var state_17740__$1 = state_17740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17740__$1,(10),inst_17717);
} else {
if((state_val_17741 === (3))){
var inst_17738 = (state_17740[(2)]);
var state_17740__$1 = state_17740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17740__$1,inst_17738);
} else {
if((state_val_17741 === (2))){
var _ = (function (){var statearr_17749 = state_17740;
(statearr_17749[(4)] = cljs.core.cons.call(null,(5),(state_17740[(4)])));

return statearr_17749;
})();
var state_17740__$1 = state_17740;
var statearr_17750_17769 = state_17740__$1;
(statearr_17750_17769[(2)] = null);

(statearr_17750_17769[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17741 === (9))){
var _ = (function (){var statearr_17751 = state_17740;
(statearr_17751[(4)] = cljs.core.rest.call(null,(state_17740[(4)])));

return statearr_17751;
})();
var state_17740__$1 = state_17740;
var ex17747 = (state_17740__$1[(2)]);
var statearr_17752_17770 = state_17740__$1;
(statearr_17752_17770[(5)] = ex17747);


var statearr_17753_17771 = state_17740__$1;
(statearr_17753_17771[(1)] = (8));

(statearr_17753_17771[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17741 === (5))){
var _ = (function (){var statearr_17754 = state_17740;
(statearr_17754[(4)] = cljs.core.rest.call(null,(state_17740[(4)])));

return statearr_17754;
})();
var state_17740__$1 = state_17740;
var ex17748 = (state_17740__$1[(2)]);
var statearr_17755_17772 = state_17740__$1;
(statearr_17755_17772[(5)] = ex17748);


if((ex17748 instanceof Error)){
var statearr_17756_17773 = state_17740__$1;
(statearr_17756_17773[(1)] = (4));

(statearr_17756_17773[(5)] = null);

} else {
throw ex17748;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17741 === (10))){
var inst_17719 = (state_17740[(2)]);
var inst_17720 = fluree.db.util.async.throw_err.call(null,inst_17719);
var _ = (function (){var statearr_17757 = state_17740;
(statearr_17757[(4)] = cljs.core.rest.call(null,(state_17740[(4)])));

return statearr_17757;
})();
var state_17740__$1 = state_17740;
var statearr_17758_17774 = state_17740__$1;
(statearr_17758_17774[(2)] = inst_17720);

(statearr_17758_17774[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17741 === (8))){
var inst_17705 = (state_17740[(2)]);
var state_17740__$1 = (function (){var statearr_17759 = state_17740;
(statearr_17759[(7)] = inst_17705);

return statearr_17759;
})();
var statearr_17760_17775 = state_17740__$1;
(statearr_17760_17775[(2)] = null);

(statearr_17760_17775[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0 = (function (){
var statearr_17761 = [null,null,null,null,null,null,null,null];
(statearr_17761[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2746__auto__);

(statearr_17761[(1)] = (1));

return statearr_17761;
});
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1 = (function (state_17740){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17762){var ex__2749__auto__ = e17762;
var statearr_17763_17776 = state_17740;
(statearr_17763_17776[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17740[(4)]))){
var statearr_17764_17777 = state_17740;
(statearr_17764_17777[(1)] = cljs.core.first.call(null,(state_17740[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17778 = state_17740;
state_17740 = G__17778;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__ = function(state_17740){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1.call(this,state_17740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17765 = f__2769__auto__.call(null);
(statearr_17765[(6)] = c__2768__auto__);

return statearr_17765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
