// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (((cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14555 = match;
var p1 = cljs.core.nth.call(null,vec__14555,(0),null);
var p2 = cljs.core.nth.call(null,vec__14555,(1),null);
var p3 = cljs.core.nth.call(null,vec__14555,(2),null);
var t = cljs.core.nth.call(null,vec__14555,(3),null);
var op = cljs.core.nth.call(null,vec__14555,(4),null);
var m = cljs.core.nth.call(null,vec__14555,(5),null);
var G__14558 = idx;
var G__14558__$1 = (((G__14558 instanceof cljs.core.Keyword))?G__14558.fqn:null);
switch (G__14558__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14558__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14560 = idx;
var G__14560__$1 = (((G__14560 instanceof cljs.core.Keyword))?G__14560.fqn:null);
switch (G__14560__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14560__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14562 = idx;
var G__14562__$1 = (((G__14562 instanceof cljs.core.Keyword))?G__14562.fqn:null);
switch (G__14562__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14562__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__14565 = arguments.length;
switch (G__14565) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14566 = (function (){var pred__14569 = cljs.core.identical_QMARK_;
var expr__14570 = test;
if(cljs.core.truth_(pred__14569.call(null,cljs.core._EQ_,expr__14570))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14569.call(null,cljs.core._LT_,expr__14570))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__14569.call(null,cljs.core._LT__EQ_,expr__14570))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14569.call(null,cljs.core._GT_,expr__14570))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__14569.call(null,cljs.core._GT__EQ_,expr__14570))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14570)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__14566,(0),null);
var start_match = cljs.core.nth.call(null,vec__14566,(1),null);
var end_test = cljs.core.nth.call(null,vec__14566,(2),null);
var end_match = cljs.core.nth.call(null,vec__14566,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14809){
var state_val_14810 = (state_14809[(1)]);
if((state_val_14810 === (65))){
var inst_14724 = (state_14809[(7)]);
var inst_14780 = (state_14809[(8)]);
var inst_14780__$1 = (state_14809[(2)]);
var inst_14781 = cljs.core.count.call(null,inst_14780__$1);
var state_14809__$1 = (function (){var statearr_14811 = state_14809;
(statearr_14811[(9)] = inst_14781);

(statearr_14811[(8)] = inst_14780__$1);

return statearr_14811;
})();
if(cljs.core.truth_(inst_14724)){
var statearr_14812_14949 = state_14809__$1;
(statearr_14812_14949[(1)] = (81));

} else {
var statearr_14813_14950 = state_14809__$1;
(statearr_14813_14950[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (70))){
var inst_14755 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
if(cljs.core.truth_(inst_14755)){
var statearr_14814_14951 = state_14809__$1;
(statearr_14814_14951[(1)] = (71));

} else {
var statearr_14815_14952 = state_14809__$1;
(statearr_14815_14952[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (62))){
var inst_14708 = (state_14809[(10)]);
var inst_14694 = (state_14809[(11)]);
var inst_14723 = (state_14809[(2)]);
var inst_14724 = fluree.db.dbproto._rhs.call(null,inst_14708);
var state_14809__$1 = (function (){var statearr_14816 = state_14809;
(statearr_14816[(7)] = inst_14724);

(statearr_14816[(12)] = inst_14723);

return statearr_14816;
})();
if(cljs.core.truth_(inst_14694)){
var statearr_14817_14953 = state_14809__$1;
(statearr_14817_14953[(1)] = (63));

} else {
var statearr_14818_14954 = state_14809__$1;
(statearr_14818_14954[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (74))){
var inst_14748 = (state_14809[(13)]);
var inst_14762 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_14748);
var state_14809__$1 = state_14809;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14809__$1,(77),inst_14762);
} else {
if((state_val_14810 === (7))){
var inst_14585 = (state_14809[(14)]);
var state_14809__$1 = state_14809;
var statearr_14819_14955 = state_14809__$1;
(statearr_14819_14955[(2)] = inst_14585);

(statearr_14819_14955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (59))){
var inst_14715 = (state_14809[(15)]);
var inst_14670 = (state_14809[(16)]);
var inst_14671 = (state_14809[(17)]);
var inst_14714 = (state_14809[(2)]);
var inst_14715__$1 = fluree.db.util.async.throw_err.call(null,inst_14714);
var inst_14716 = fluree.db.flake.subrange.call(null,inst_14715__$1,start_test,inst_14670,end_test,inst_14671);
var inst_14717 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_14670,inst_14671);
var state_14809__$1 = (function (){var statearr_14820 = state_14809;
(statearr_14820[(15)] = inst_14715__$1);

(statearr_14820[(18)] = inst_14716);

return statearr_14820;
})();
if(inst_14717){
var statearr_14821_14956 = state_14809__$1;
(statearr_14821_14956[(1)] = (60));

} else {
var statearr_14822_14957 = state_14809__$1;
(statearr_14822_14957[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (86))){
var inst_14789 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
var statearr_14823_14958 = state_14809__$1;
(statearr_14823_14958[(2)] = inst_14789);

(statearr_14823_14958[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (20))){
var inst_14634 = (state_14809[(19)]);
var inst_14586 = (state_14809[(20)]);
var inst_14633 = (state_14809[(2)]);
var inst_14634__$1 = (inst_14586 == null);
var state_14809__$1 = (function (){var statearr_14824 = state_14809;
(statearr_14824[(21)] = inst_14633);

(statearr_14824[(19)] = inst_14634__$1);

return statearr_14824;
})();
if(cljs.core.truth_(inst_14634__$1)){
var statearr_14825_14959 = state_14809__$1;
(statearr_14825_14959[(1)] = (22));

} else {
var statearr_14826_14960 = state_14809__$1;
(statearr_14826_14960[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (72))){
var inst_14741 = (state_14809[(22)]);
var inst_14759 = (inst_14741 + (1));
var inst_14760 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14809__$1 = (function (){var statearr_14827 = state_14809;
(statearr_14827[(23)] = inst_14759);

return statearr_14827;
})();
if(cljs.core.truth_(inst_14760)){
var statearr_14828_14961 = state_14809__$1;
(statearr_14828_14961[(1)] = (74));

} else {
var statearr_14829_14962 = state_14809__$1;
(statearr_14829_14962[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (58))){
var inst_14804 = (state_14809[(2)]);
var _ = (function (){var statearr_14830 = state_14809;
(statearr_14830[(4)] = cljs.core.rest.call(null,(state_14809[(4)])));

return statearr_14830;
})();
var state_14809__$1 = state_14809;
var statearr_14831_14963 = state_14809__$1;
(statearr_14831_14963[(2)] = inst_14804);

(statearr_14831_14963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (60))){
var inst_14624 = (state_14809[(24)]);
var inst_14589 = (state_14809[(25)]);
var inst_14596 = (state_14809[(26)]);
var inst_14642 = (state_14809[(27)]);
var inst_14688 = (state_14809[(28)]);
var inst_14588 = (state_14809[(29)]);
var inst_14669 = (state_14809[(30)]);
var inst_14595 = (state_14809[(31)]);
var inst_14709 = (state_14809[(32)]);
var inst_14606 = (state_14809[(33)]);
var inst_14703 = (state_14809[(34)]);
var inst_14715 = (state_14809[(15)]);
var inst_14633 = (state_14809[(21)]);
var inst_14615 = (state_14809[(35)]);
var inst_14584 = (state_14809[(36)]);
var inst_14670 = (state_14809[(16)]);
var inst_14677 = (state_14809[(37)]);
var inst_14676 = (state_14809[(38)]);
var inst_14681 = (state_14809[(39)]);
var inst_14687 = (state_14809[(40)]);
var inst_14698 = (state_14809[(41)]);
var inst_14660 = (state_14809[(42)]);
var inst_14708 = (state_14809[(10)]);
var inst_14651 = (state_14809[(43)]);
var inst_14710 = (state_14809[(44)]);
var inst_14591 = (state_14809[(45)]);
var inst_14671 = (state_14809[(17)]);
var inst_14694 = (state_14809[(11)]);
var inst_14716 = (state_14809[(18)]);
var inst_14719 = (function (){var no_filter_QMARK_ = inst_14694;
var next_node = inst_14708;
var flakes = inst_14715;
var vec__14578 = inst_14584;
var s1 = inst_14606;
var o2 = inst_14633;
var t1 = inst_14588;
var i = inst_14709;
var m1 = inst_14660;
var root_node = inst_14703;
var to_t = inst_14688;
var s2 = inst_14615;
var p2 = inst_14651;
var permissions = inst_14677;
var limit = inst_14676;
var start_flake = inst_14670;
var acc = inst_14710;
var t2 = inst_14595;
var op1 = inst_14589;
var o1 = inst_14624;
var end_flake = inst_14671;
var base_result = inst_14716;
var p1 = inst_14642;
var vec__14581 = inst_14591;
var idx_compare = inst_14681;
var op2 = inst_14596;
var from_t = inst_14687;
var m2 = inst_14669;
var novelty = inst_14698;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_14720 = cljs.core.reduce.call(null,inst_14719,inst_14716,inst_14716);
var state_14809__$1 = state_14809;
var statearr_14832_14964 = state_14809__$1;
(statearr_14832_14964[(2)] = inst_14720);

(statearr_14832_14964[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (27))){
var inst_14643 = (state_14809[(46)]);
var inst_14593 = (state_14809[(47)]);
var inst_14642 = (state_14809[(2)]);
var inst_14643__$1 = (inst_14593 == null);
var state_14809__$1 = (function (){var statearr_14833 = state_14809;
(statearr_14833[(27)] = inst_14642);

(statearr_14833[(46)] = inst_14643__$1);

return statearr_14833;
})();
if(cljs.core.truth_(inst_14643__$1)){
var statearr_14834_14965 = state_14809__$1;
(statearr_14834_14965[(1)] = (28));

} else {
var statearr_14835_14966 = state_14809__$1;
(statearr_14835_14966[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (1))){
var state_14809__$1 = state_14809;
var statearr_14836_14967 = state_14809__$1;
(statearr_14836_14967[(2)] = null);

(statearr_14836_14967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (69))){
var inst_14741 = (state_14809[(22)]);
var inst_14676 = (state_14809[(38)]);
var inst_14753 = (inst_14741 > inst_14676);
var state_14809__$1 = state_14809;
var statearr_14837_14968 = state_14809__$1;
(statearr_14837_14968[(2)] = inst_14753);

(statearr_14837_14968[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (24))){
var inst_14638 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
if(cljs.core.truth_(inst_14638)){
var statearr_14838_14969 = state_14809__$1;
(statearr_14838_14969[(1)] = (25));

} else {
var statearr_14839_14970 = state_14809__$1;
(statearr_14839_14970[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (55))){
var inst_14703 = (state_14809[(34)]);
var inst_14670 = (state_14809[(16)]);
var inst_14702 = (state_14809[(2)]);
var inst_14703__$1 = fluree.db.util.async.throw_err.call(null,inst_14702);
var inst_14704 = fluree.db.dbproto._lookup_leaf.call(null,inst_14703__$1,inst_14670);
var state_14809__$1 = (function (){var statearr_14840 = state_14809;
(statearr_14840[(34)] = inst_14703__$1);

return statearr_14840;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14809__$1,(56),inst_14704);
} else {
if((state_val_14810 === (85))){
var inst_14784 = (state_14809[(48)]);
var state_14809__$1 = state_14809;
var statearr_14841_14971 = state_14809__$1;
(statearr_14841_14971[(2)] = inst_14784);

(statearr_14841_14971[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (39))){
var inst_14658 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
var statearr_14842_14972 = state_14809__$1;
(statearr_14842_14972[(2)] = inst_14658);

(statearr_14842_14972[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (88))){
var inst_14724 = (state_14809[(7)]);
var inst_14703 = (state_14809[(34)]);
var inst_14796 = fluree.db.dbproto._lookup_leaf.call(null,inst_14703,inst_14724);
var state_14809__$1 = state_14809;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14809__$1,(90),inst_14796);
} else {
if((state_val_14810 === (46))){
var inst_14672 = (state_14809[(49)]);
var state_14809__$1 = state_14809;
var statearr_14843_14973 = state_14809__$1;
(statearr_14843_14973[(2)] = inst_14672);

(statearr_14843_14973[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (4))){
var inst_14572 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
var statearr_14844_14974 = state_14809__$1;
(statearr_14844_14974[(2)] = inst_14572);

(statearr_14844_14974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (77))){
var inst_14764 = (state_14809[(2)]);
var inst_14765 = fluree.db.util.async.throw_err.call(null,inst_14764);
var state_14809__$1 = state_14809;
if(cljs.core.truth_(inst_14765)){
var statearr_14845_14975 = state_14809__$1;
(statearr_14845_14975[(1)] = (78));

} else {
var statearr_14846_14976 = state_14809__$1;
(statearr_14846_14976[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (54))){
var inst_14694 = (state_14809[(2)]);
var inst_14695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14696 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14697 = (new cljs.core.PersistentVector(null,2,(5),inst_14695,inst_14696,null));
var inst_14698 = cljs.core.get_in.call(null,db,inst_14697);
var inst_14699 = cljs.core.get.call(null,db,idx);
var inst_14700 = fluree.db.dbproto._resolve.call(null,inst_14699);
var state_14809__$1 = (function (){var statearr_14847 = state_14809;
(statearr_14847[(41)] = inst_14698);

(statearr_14847[(11)] = inst_14694);

return statearr_14847;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14809__$1,(55),inst_14700);
} else {
if((state_val_14810 === (15))){
var inst_14587 = (state_14809[(50)]);
var state_14809__$1 = state_14809;
var statearr_14848_14977 = state_14809__$1;
(statearr_14848_14977[(2)] = inst_14587);

(statearr_14848_14977[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (48))){
var inst_14682 = (state_14809[(51)]);
var inst_14676 = (state_14809[(2)]);
var inst_14677 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14679 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14680 = (new cljs.core.PersistentVector(null,3,(5),inst_14678,inst_14679,null));
var inst_14681 = cljs.core.get_in.call(null,db,inst_14680);
var inst_14682__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_14809__$1 = (function (){var statearr_14849 = state_14809;
(statearr_14849[(37)] = inst_14677);

(statearr_14849[(38)] = inst_14676);

(statearr_14849[(39)] = inst_14681);

(statearr_14849[(51)] = inst_14682__$1);

return statearr_14849;
})();
if(cljs.core.truth_(inst_14682__$1)){
var statearr_14850_14978 = state_14809__$1;
(statearr_14850_14978[(1)] = (49));

} else {
var statearr_14851_14979 = state_14809__$1;
(statearr_14851_14979[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (50))){
var inst_14685 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_14809__$1 = state_14809;
var statearr_14852_14980 = state_14809__$1;
(statearr_14852_14980[(2)] = inst_14685);

(statearr_14852_14980[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (75))){
var inst_14742 = (state_14809[(52)]);
var state_14809__$1 = state_14809;
var statearr_14853_14981 = state_14809__$1;
(statearr_14853_14981[(2)] = inst_14742);

(statearr_14853_14981[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (21))){
var inst_14629 = (state_14809[(2)]);
var inst_14630 = fluree.db.util.async.throw_err.call(null,inst_14629);
var state_14809__$1 = state_14809;
var statearr_14854_14982 = state_14809__$1;
(statearr_14854_14982[(2)] = inst_14630);

(statearr_14854_14982[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (31))){
var state_14809__$1 = state_14809;
var statearr_14855_14983 = state_14809__$1;
(statearr_14855_14983[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14855_14983[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (32))){
var inst_14593 = (state_14809[(47)]);
var state_14809__$1 = state_14809;
var statearr_14856_14984 = state_14809__$1;
(statearr_14856_14984[(2)] = inst_14593);

(statearr_14856_14984[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (40))){
var inst_14597 = (state_14809[(53)]);
var state_14809__$1 = state_14809;
var statearr_14857_14985 = state_14809__$1;
(statearr_14857_14985[(2)] = inst_14597);

(statearr_14857_14985[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (56))){
var inst_14706 = (state_14809[(2)]);
var inst_14707 = fluree.db.util.async.throw_err.call(null,inst_14706);
var inst_14708 = inst_14707;
var inst_14709 = (0);
var inst_14710 = null;
var state_14809__$1 = (function (){var statearr_14858 = state_14809;
(statearr_14858[(32)] = inst_14709);

(statearr_14858[(10)] = inst_14708);

(statearr_14858[(44)] = inst_14710);

return statearr_14858;
})();
var statearr_14859_14986 = state_14809__$1;
(statearr_14859_14986[(2)] = null);

(statearr_14859_14986[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (33))){
var inst_14590 = (state_14809[(54)]);
var inst_14651 = (state_14809[(2)]);
var state_14809__$1 = (function (){var statearr_14860 = state_14809;
(statearr_14860[(43)] = inst_14651);

return statearr_14860;
})();
if(cljs.core.truth_(inst_14590)){
var statearr_14861_14987 = state_14809__$1;
(statearr_14861_14987[(1)] = (34));

} else {
var statearr_14862_14988 = state_14809__$1;
(statearr_14862_14988[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (13))){
var inst_14611 = (state_14809[(2)]);
var inst_14612 = fluree.db.util.async.throw_err.call(null,inst_14611);
var state_14809__$1 = state_14809;
var statearr_14863_14989 = state_14809__$1;
(statearr_14863_14989[(2)] = inst_14612);

(statearr_14863_14989[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (22))){
var inst_14624 = (state_14809[(24)]);
var state_14809__$1 = state_14809;
var statearr_14864_14990 = state_14809__$1;
(statearr_14864_14990[(2)] = inst_14624);

(statearr_14864_14990[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (90))){
var inst_14781 = (state_14809[(9)]);
var inst_14780 = (state_14809[(8)]);
var inst_14798 = (state_14809[(2)]);
var inst_14799 = fluree.db.util.async.throw_err.call(null,inst_14798);
var inst_14708 = inst_14799;
var inst_14709 = inst_14781;
var inst_14710 = inst_14780;
var state_14809__$1 = (function (){var statearr_14865 = state_14809;
(statearr_14865[(32)] = inst_14709);

(statearr_14865[(10)] = inst_14708);

(statearr_14865[(44)] = inst_14710);

return statearr_14865;
})();
var statearr_14866_14991 = state_14809__$1;
(statearr_14866_14991[(2)] = null);

(statearr_14866_14991[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (36))){
var inst_14597 = (state_14809[(53)]);
var inst_14660 = (state_14809[(2)]);
var state_14809__$1 = (function (){var statearr_14867 = state_14809;
(statearr_14867[(42)] = inst_14660);

return statearr_14867;
})();
if(cljs.core.truth_(inst_14597)){
var statearr_14868_14992 = state_14809__$1;
(statearr_14868_14992[(1)] = (40));

} else {
var statearr_14869_14993 = state_14809__$1;
(statearr_14869_14993[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (41))){
var inst_14663 = (cljs.core._LT__EQ_ === end_test);
var state_14809__$1 = state_14809;
if(cljs.core.truth_(inst_14663)){
var statearr_14870_14994 = state_14809__$1;
(statearr_14870_14994[(1)] = (43));

} else {
var statearr_14871_14995 = state_14809__$1;
(statearr_14871_14995[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (89))){
var inst_14802 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
var statearr_14872_14996 = state_14809__$1;
(statearr_14872_14996[(2)] = inst_14802);

(statearr_14872_14996[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (43))){
var state_14809__$1 = state_14809;
var statearr_14873_14997 = state_14809__$1;
(statearr_14873_14997[(2)] = (2147483647));

(statearr_14873_14997[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (61))){
var inst_14716 = (state_14809[(18)]);
var state_14809__$1 = state_14809;
var statearr_14874_14998 = state_14809__$1;
(statearr_14874_14998[(2)] = inst_14716);

(statearr_14874_14998[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (29))){
var inst_14643 = (state_14809[(46)]);
var state_14809__$1 = state_14809;
var statearr_14875_14999 = state_14809__$1;
(statearr_14875_14999[(2)] = inst_14643);

(statearr_14875_14999[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (44))){
var state_14809__$1 = state_14809;
var statearr_14876_15000 = state_14809__$1;
(statearr_14876_15000[(2)] = fluree.db.util.core.min_integer);

(statearr_14876_15000[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (6))){
var inst_14585 = (state_14809[(14)]);
var inst_14600 = fluree.db.dbproto._subid.call(null,db,inst_14585);
var state_14809__$1 = state_14809;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14809__$1,(9),inst_14600);
} else {
if((state_val_14810 === (28))){
var inst_14633 = (state_14809[(21)]);
var state_14809__$1 = state_14809;
var statearr_14877_15001 = state_14809__$1;
(statearr_14877_15001[(2)] = inst_14633);

(statearr_14877_15001[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (64))){
var inst_14709 = (state_14809[(32)]);
var inst_14723 = (state_14809[(12)]);
var inst_14737 = cljs.core.seq.call(null,inst_14723);
var inst_14738 = cljs.core.first.call(null,inst_14737);
var inst_14739 = cljs.core.next.call(null,inst_14737);
var inst_14740 = inst_14723;
var inst_14741 = inst_14709;
var inst_14742 = inst_14723;
var state_14809__$1 = (function (){var statearr_14878 = state_14809;
(statearr_14878[(55)] = inst_14740);

(statearr_14878[(52)] = inst_14742);

(statearr_14878[(22)] = inst_14741);

(statearr_14878[(56)] = inst_14738);

(statearr_14878[(57)] = inst_14739);

return statearr_14878;
})();
var statearr_14879_15002 = state_14809__$1;
(statearr_14879_15002[(2)] = null);

(statearr_14879_15002[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (51))){
var inst_14687 = (state_14809[(2)]);
var inst_14688 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_14689 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14809__$1 = (function (){var statearr_14880 = state_14809;
(statearr_14880[(28)] = inst_14688);

(statearr_14880[(40)] = inst_14687);

return statearr_14880;
})();
if(cljs.core.truth_(inst_14689)){
var statearr_14881_15003 = state_14809__$1;
(statearr_14881_15003[(1)] = (52));

} else {
var statearr_14882_15004 = state_14809__$1;
(statearr_14882_15004[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (25))){
var state_14809__$1 = state_14809;
var statearr_14883_15005 = state_14809__$1;
(statearr_14883_15005[(2)] = (-1));

(statearr_14883_15005[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (34))){
var inst_14590 = (state_14809[(54)]);
var state_14809__$1 = state_14809;
var statearr_14884_15006 = state_14809__$1;
(statearr_14884_15006[(2)] = inst_14590);

(statearr_14884_15006[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (17))){
var inst_14620 = (state_14809[(2)]);
var inst_14621 = fluree.db.util.async.throw_err.call(null,inst_14620);
var state_14809__$1 = state_14809;
var statearr_14885_15007 = state_14809__$1;
(statearr_14885_15007[(2)] = inst_14621);

(statearr_14885_15007[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (3))){
var inst_14807 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14809__$1,inst_14807);
} else {
if((state_val_14810 === (12))){
var inst_14587 = (state_14809[(50)]);
var inst_14615 = (state_14809[(2)]);
var inst_14616 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14587);
var state_14809__$1 = (function (){var statearr_14886 = state_14809;
(statearr_14886[(35)] = inst_14615);

return statearr_14886;
})();
if(inst_14616){
var statearr_14887_15008 = state_14809__$1;
(statearr_14887_15008[(1)] = (14));

} else {
var statearr_14888_15009 = state_14809__$1;
(statearr_14888_15009[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (2))){
var inst_14584 = (state_14809[(36)]);
var inst_14591 = (state_14809[(45)]);
var inst_14585 = (state_14809[(14)]);
var _ = (function (){var statearr_14889 = state_14809;
(statearr_14889[(4)] = cljs.core.cons.call(null,(5),(state_14809[(4)])));

return statearr_14889;
})();
var inst_14584__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_14585__$1 = cljs.core.nth.call(null,inst_14584__$1,(0),null);
var inst_14586 = cljs.core.nth.call(null,inst_14584__$1,(1),null);
var inst_14587 = cljs.core.nth.call(null,inst_14584__$1,(2),null);
var inst_14588 = cljs.core.nth.call(null,inst_14584__$1,(3),null);
var inst_14589 = cljs.core.nth.call(null,inst_14584__$1,(4),null);
var inst_14590 = cljs.core.nth.call(null,inst_14584__$1,(5),null);
var inst_14591__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_14592 = cljs.core.nth.call(null,inst_14591__$1,(0),null);
var inst_14593 = cljs.core.nth.call(null,inst_14591__$1,(1),null);
var inst_14594 = cljs.core.nth.call(null,inst_14591__$1,(2),null);
var inst_14595 = cljs.core.nth.call(null,inst_14591__$1,(3),null);
var inst_14596 = cljs.core.nth.call(null,inst_14591__$1,(4),null);
var inst_14597 = cljs.core.nth.call(null,inst_14591__$1,(5),null);
var inst_14598 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14585__$1);
var state_14809__$1 = (function (){var statearr_14890 = state_14809;
(statearr_14890[(25)] = inst_14589);

(statearr_14890[(26)] = inst_14596);

(statearr_14890[(58)] = inst_14592);

(statearr_14890[(29)] = inst_14588);

(statearr_14890[(50)] = inst_14587);

(statearr_14890[(31)] = inst_14595);

(statearr_14890[(53)] = inst_14597);

(statearr_14890[(36)] = inst_14584__$1);

(statearr_14890[(54)] = inst_14590);

(statearr_14890[(59)] = inst_14594);

(statearr_14890[(47)] = inst_14593);

(statearr_14890[(45)] = inst_14591__$1);

(statearr_14890[(20)] = inst_14586);

(statearr_14890[(14)] = inst_14585__$1);

return statearr_14890;
})();
if(inst_14598){
var statearr_14891_15010 = state_14809__$1;
(statearr_14891_15010[(1)] = (6));

} else {
var statearr_14892_15011 = state_14809__$1;
(statearr_14892_15011[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (66))){
var inst_14740 = (state_14809[(55)]);
var inst_14750 = (state_14809[(60)]);
var inst_14748 = (state_14809[(13)]);
var inst_14747 = cljs.core.seq.call(null,inst_14740);
var inst_14748__$1 = cljs.core.first.call(null,inst_14747);
var inst_14749 = cljs.core.next.call(null,inst_14747);
var inst_14750__$1 = (inst_14748__$1 == null);
var state_14809__$1 = (function (){var statearr_14893 = state_14809;
(statearr_14893[(60)] = inst_14750__$1);

(statearr_14893[(61)] = inst_14749);

(statearr_14893[(13)] = inst_14748__$1);

return statearr_14893;
})();
if(cljs.core.truth_(inst_14750__$1)){
var statearr_14894_15012 = state_14809__$1;
(statearr_14894_15012[(1)] = (68));

} else {
var statearr_14895_15013 = state_14809__$1;
(statearr_14895_15013[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (23))){
var inst_14634 = (state_14809[(19)]);
var state_14809__$1 = state_14809;
var statearr_14896_15014 = state_14809__$1;
(statearr_14896_15014[(2)] = inst_14634);

(statearr_14896_15014[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (47))){
var state_14809__$1 = state_14809;
var statearr_14897_15015 = state_14809__$1;
(statearr_14897_15015[(2)] = fluree.db.util.core.max_long);

(statearr_14897_15015[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (35))){
var inst_14654 = (cljs.core._GT__EQ_ === start_test);
var state_14809__$1 = state_14809;
if(cljs.core.truth_(inst_14654)){
var statearr_14898_15016 = state_14809__$1;
(statearr_14898_15016[(1)] = (37));

} else {
var statearr_14899_15017 = state_14809__$1;
(statearr_14899_15017[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (82))){
var inst_14724 = (state_14809[(7)]);
var state_14809__$1 = state_14809;
var statearr_14900_15018 = state_14809__$1;
(statearr_14900_15018[(2)] = inst_14724);

(statearr_14900_15018[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (76))){
var inst_14759 = (state_14809[(23)]);
var inst_14749 = (state_14809[(61)]);
var inst_14773 = (state_14809[(2)]);
var inst_14740 = inst_14749;
var inst_14741 = inst_14759;
var inst_14742 = inst_14773;
var state_14809__$1 = (function (){var statearr_14901 = state_14809;
(statearr_14901[(55)] = inst_14740);

(statearr_14901[(52)] = inst_14742);

(statearr_14901[(22)] = inst_14741);

return statearr_14901;
})();
var statearr_14902_15019 = state_14809__$1;
(statearr_14902_15019[(2)] = null);

(statearr_14902_15019[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (19))){
var inst_14594 = (state_14809[(59)]);
var state_14809__$1 = state_14809;
var statearr_14903_15020 = state_14809__$1;
(statearr_14903_15020[(2)] = inst_14594);

(statearr_14903_15020[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (57))){
var inst_14688 = (state_14809[(28)]);
var inst_14687 = (state_14809[(40)]);
var inst_14698 = (state_14809[(41)]);
var inst_14708 = (state_14809[(10)]);
var inst_14712 = fluree.db.dbproto._resolve_history_range.call(null,inst_14708,inst_14687,inst_14688,inst_14698);
var state_14809__$1 = state_14809;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14809__$1,(59),inst_14712);
} else {
if((state_val_14810 === (68))){
var inst_14750 = (state_14809[(60)]);
var state_14809__$1 = state_14809;
var statearr_14904_15021 = state_14809__$1;
(statearr_14904_15021[(2)] = inst_14750);

(statearr_14904_15021[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (11))){
var inst_14592 = (state_14809[(58)]);
var state_14809__$1 = state_14809;
var statearr_14906_15022 = state_14809__$1;
(statearr_14906_15022[(2)] = inst_14592);

(statearr_14906_15022[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (9))){
var inst_14602 = (state_14809[(2)]);
var inst_14603 = fluree.db.util.async.throw_err.call(null,inst_14602);
var state_14809__$1 = state_14809;
var statearr_14907_15023 = state_14809__$1;
(statearr_14907_15023[(2)] = inst_14603);

(statearr_14907_15023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (5))){
var _ = (function (){var statearr_14908 = state_14809;
(statearr_14908[(4)] = cljs.core.rest.call(null,(state_14809[(4)])));

return statearr_14908;
})();
var state_14809__$1 = state_14809;
var ex14905 = (state_14809__$1[(2)]);
var statearr_14909_15024 = state_14809__$1;
(statearr_14909_15024[(5)] = ex14905);


if((ex14905 instanceof Error)){
var statearr_14910_15025 = state_14809__$1;
(statearr_14910_15025[(1)] = (4));

(statearr_14910_15025[(5)] = null);

} else {
throw ex14905;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (83))){
var inst_14792 = (state_14809[(2)]);
var inst_14793 = cljs.core.not.call(null,inst_14792);
var state_14809__$1 = state_14809;
if(inst_14793){
var statearr_14911_15026 = state_14809__$1;
(statearr_14911_15026[(1)] = (87));

} else {
var statearr_14912_15027 = state_14809__$1;
(statearr_14912_15027[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (14))){
var inst_14587 = (state_14809[(50)]);
var inst_14618 = fluree.db.dbproto._subid.call(null,db,inst_14587);
var state_14809__$1 = state_14809;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14809__$1,(17),inst_14618);
} else {
if((state_val_14810 === (45))){
var inst_14667 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
var statearr_14913_15028 = state_14809__$1;
(statearr_14913_15028[(2)] = inst_14667);

(statearr_14913_15028[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (53))){
var state_14809__$1 = state_14809;
var statearr_14914_15029 = state_14809__$1;
(statearr_14914_15029[(2)] = true);

(statearr_14914_15029[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (78))){
var inst_14742 = (state_14809[(52)]);
var state_14809__$1 = state_14809;
var statearr_14915_15030 = state_14809__$1;
(statearr_14915_15030[(2)] = inst_14742);

(statearr_14915_15030[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (26))){
var inst_14586 = (state_14809[(20)]);
var state_14809__$1 = state_14809;
var statearr_14916_15031 = state_14809__$1;
(statearr_14916_15031[(2)] = inst_14586);

(statearr_14916_15031[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (16))){
var inst_14594 = (state_14809[(59)]);
var inst_14624 = (state_14809[(2)]);
var inst_14625 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14594);
var state_14809__$1 = (function (){var statearr_14917 = state_14809;
(statearr_14917[(24)] = inst_14624);

return statearr_14917;
})();
if(inst_14625){
var statearr_14918_15032 = state_14809__$1;
(statearr_14918_15032[(1)] = (18));

} else {
var statearr_14919_15033 = state_14809__$1;
(statearr_14919_15033[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (81))){
var inst_14724 = (state_14809[(7)]);
var inst_14681 = (state_14809[(39)]);
var inst_14671 = (state_14809[(17)]);
var inst_14784 = (state_14809[(48)]);
var inst_14783 = inst_14681.call(null,inst_14724,inst_14671);
var inst_14784__$1 = (inst_14783 < (0));
var state_14809__$1 = (function (){var statearr_14920 = state_14809;
(statearr_14920[(48)] = inst_14784__$1);

return statearr_14920;
})();
if(cljs.core.truth_(inst_14784__$1)){
var statearr_14921_15034 = state_14809__$1;
(statearr_14921_15034[(1)] = (84));

} else {
var statearr_14922_15035 = state_14809__$1;
(statearr_14922_15035[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (79))){
var inst_14742 = (state_14809[(52)]);
var inst_14748 = (state_14809[(13)]);
var inst_14768 = cljs.core.disj.call(null,inst_14742,inst_14748);
var state_14809__$1 = state_14809;
var statearr_14923_15036 = state_14809__$1;
(statearr_14923_15036[(2)] = inst_14768);

(statearr_14923_15036[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (38))){
var state_14809__$1 = state_14809;
var statearr_14924_15037 = state_14809__$1;
(statearr_14924_15037[(2)] = (2147483647));

(statearr_14924_15037[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (87))){
var inst_14780 = (state_14809[(8)]);
var state_14809__$1 = state_14809;
var statearr_14925_15038 = state_14809__$1;
(statearr_14925_15038[(2)] = inst_14780);

(statearr_14925_15038[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (30))){
var inst_14647 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
if(cljs.core.truth_(inst_14647)){
var statearr_14926_15039 = state_14809__$1;
(statearr_14926_15039[(1)] = (31));

} else {
var statearr_14927_15040 = state_14809__$1;
(statearr_14927_15040[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (73))){
var inst_14776 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
var statearr_14928_15041 = state_14809__$1;
(statearr_14928_15041[(2)] = inst_14776);

(statearr_14928_15041[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (10))){
var inst_14592 = (state_14809[(58)]);
var inst_14609 = fluree.db.dbproto._subid.call(null,db,inst_14592);
var state_14809__$1 = state_14809;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14809__$1,(13),inst_14609);
} else {
if((state_val_14810 === (18))){
var inst_14594 = (state_14809[(59)]);
var inst_14627 = fluree.db.dbproto._subid.call(null,db,inst_14594);
var state_14809__$1 = state_14809;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14809__$1,(21),inst_14627);
} else {
if((state_val_14810 === (52))){
var inst_14642 = (state_14809[(27)]);
var inst_14606 = (state_14809[(33)]);
var inst_14615 = (state_14809[(35)]);
var inst_14677 = (state_14809[(37)]);
var inst_14651 = (state_14809[(43)]);
var inst_14691 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_14677,inst_14606,inst_14615,inst_14642,inst_14651);
var state_14809__$1 = state_14809;
var statearr_14929_15042 = state_14809__$1;
(statearr_14929_15042[(2)] = inst_14691);

(statearr_14929_15042[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (67))){
var inst_14778 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
var statearr_14930_15043 = state_14809__$1;
(statearr_14930_15043[(2)] = inst_14778);

(statearr_14930_15043[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (71))){
var inst_14742 = (state_14809[(52)]);
var inst_14710 = (state_14809[(44)]);
var inst_14757 = cljs.core.into.call(null,inst_14742,inst_14710);
var state_14809__$1 = state_14809;
var statearr_14931_15044 = state_14809__$1;
(statearr_14931_15044[(2)] = inst_14757);

(statearr_14931_15044[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (42))){
var inst_14624 = (state_14809[(24)]);
var inst_14589 = (state_14809[(25)]);
var inst_14596 = (state_14809[(26)]);
var inst_14642 = (state_14809[(27)]);
var inst_14588 = (state_14809[(29)]);
var inst_14669 = (state_14809[(30)]);
var inst_14595 = (state_14809[(31)]);
var inst_14606 = (state_14809[(33)]);
var inst_14633 = (state_14809[(21)]);
var inst_14615 = (state_14809[(35)]);
var inst_14672 = (state_14809[(49)]);
var inst_14660 = (state_14809[(42)]);
var inst_14651 = (state_14809[(43)]);
var inst_14669__$1 = (state_14809[(2)]);
var inst_14670 = fluree.db.flake.__GT_Flake.call(null,inst_14606,inst_14642,inst_14624,inst_14588,inst_14589,inst_14660);
var inst_14671 = fluree.db.flake.__GT_Flake.call(null,inst_14615,inst_14651,inst_14633,inst_14595,inst_14596,inst_14669__$1);
var inst_14672__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_14809__$1 = (function (){var statearr_14932 = state_14809;
(statearr_14932[(30)] = inst_14669__$1);

(statearr_14932[(16)] = inst_14670);

(statearr_14932[(49)] = inst_14672__$1);

(statearr_14932[(17)] = inst_14671);

return statearr_14932;
})();
if(cljs.core.truth_(inst_14672__$1)){
var statearr_14933_15045 = state_14809__$1;
(statearr_14933_15045[(1)] = (46));

} else {
var statearr_14934_15046 = state_14809__$1;
(statearr_14934_15046[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (80))){
var inst_14770 = (state_14809[(2)]);
var state_14809__$1 = state_14809;
var statearr_14935_15047 = state_14809__$1;
(statearr_14935_15047[(2)] = inst_14770);

(statearr_14935_15047[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (37))){
var state_14809__$1 = state_14809;
var statearr_14936_15048 = state_14809__$1;
(statearr_14936_15048[(2)] = fluree.db.util.core.min_integer);

(statearr_14936_15048[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (63))){
var inst_14709 = (state_14809[(32)]);
var inst_14676 = (state_14809[(38)]);
var inst_14723 = (state_14809[(12)]);
var inst_14710 = (state_14809[(44)]);
var inst_14726 = (inst_14676 - inst_14709);
var inst_14727 = fluree.db.flake.take.call(null,inst_14726,inst_14723);
var inst_14728 = cljs.core.into.call(null,inst_14727,inst_14710);
var state_14809__$1 = state_14809;
var statearr_14937_15049 = state_14809__$1;
(statearr_14937_15049[(2)] = inst_14728);

(statearr_14937_15049[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (8))){
var inst_14592 = (state_14809[(58)]);
var inst_14606 = (state_14809[(2)]);
var inst_14607 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14592);
var state_14809__$1 = (function (){var statearr_14938 = state_14809;
(statearr_14938[(33)] = inst_14606);

return statearr_14938;
})();
if(inst_14607){
var statearr_14939_15050 = state_14809__$1;
(statearr_14939_15050[(1)] = (10));

} else {
var statearr_14940_15051 = state_14809__$1;
(statearr_14940_15051[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (49))){
var inst_14682 = (state_14809[(51)]);
var state_14809__$1 = state_14809;
var statearr_14941_15052 = state_14809__$1;
(statearr_14941_15052[(2)] = inst_14682);

(statearr_14941_15052[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14810 === (84))){
var inst_14781 = (state_14809[(9)]);
var inst_14676 = (state_14809[(38)]);
var inst_14786 = (inst_14781 < inst_14676);
var state_14809__$1 = state_14809;
var statearr_14942_15053 = state_14809__$1;
(statearr_14942_15053[(2)] = inst_14786);

(statearr_14942_15053[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_14943 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14943[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_14943[(1)] = (1));

return statearr_14943;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_14809){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14809);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14944){var ex__2749__auto__ = e14944;
var statearr_14945_15054 = state_14809;
(statearr_14945_15054[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14809[(4)]))){
var statearr_14946_15055 = state_14809;
(statearr_14946_15055[(1)] = cljs.core.first.call(null,(state_14809[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15056 = state_14809;
state_14809 = G__15056;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_14809){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_14809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14947 = f__2769__auto__.call(null);
(statearr_14947[(6)] = c__2768__auto__);

return statearr_14947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15131){
var state_val_15132 = (state_15131[(1)]);
if((state_val_15132 === (7))){
var inst_15126 = (state_15131[(2)]);
var _ = (function (){var statearr_15133 = state_15131;
(statearr_15133[(4)] = cljs.core.rest.call(null,(state_15131[(4)])));

return statearr_15133;
})();
var state_15131__$1 = state_15131;
var statearr_15134_15174 = state_15131__$1;
(statearr_15134_15174[(2)] = inst_15126);

(statearr_15134_15174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (20))){
var inst_15108 = (state_15131[(2)]);
var inst_15109 = fluree.db.util.async.throw_err.call(null,inst_15108);
var state_15131__$1 = state_15131;
var statearr_15135_15175 = state_15131__$1;
(statearr_15135_15175[(2)] = inst_15109);

(statearr_15135_15175[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (1))){
var state_15131__$1 = state_15131;
var statearr_15136_15176 = state_15131__$1;
(statearr_15136_15176[(2)] = null);

(statearr_15136_15176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (4))){
var inst_15057 = (state_15131[(2)]);
var state_15131__$1 = state_15131;
var statearr_15137_15177 = state_15131__$1;
(statearr_15137_15177[(2)] = inst_15057);

(statearr_15137_15177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (15))){
var inst_15104 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_15131__$1 = state_15131;
if(cljs.core.truth_(inst_15104)){
var statearr_15138_15178 = state_15131__$1;
(statearr_15138_15178[(1)] = (17));

} else {
var statearr_15139_15179 = state_15131__$1;
(statearr_15139_15179[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (21))){
var state_15131__$1 = state_15131;
var statearr_15140_15180 = state_15131__$1;
(statearr_15140_15180[(2)] = (0));

(statearr_15140_15180[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (13))){
var inst_15096 = (state_15131[(2)]);
var state_15131__$1 = state_15131;
var statearr_15141_15181 = state_15131__$1;
(statearr_15141_15181[(2)] = inst_15096);

(statearr_15141_15181[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (22))){
var state_15131__$1 = state_15131;
var statearr_15142_15182 = state_15131__$1;
(statearr_15142_15182[(2)] = (1));

(statearr_15142_15182[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (6))){
var inst_15088 = (state_15131[(7)]);
var inst_15086 = (state_15131[(8)]);
var inst_15077 = (state_15131[(9)]);
var inst_15085 = cljs.core.seq.call(null,inst_15077);
var inst_15086__$1 = cljs.core.first.call(null,inst_15085);
var inst_15087 = cljs.core.next.call(null,inst_15085);
var inst_15088__$1 = (inst_15086__$1 == null);
var state_15131__$1 = (function (){var statearr_15143 = state_15131;
(statearr_15143[(10)] = inst_15087);

(statearr_15143[(7)] = inst_15088__$1);

(statearr_15143[(8)] = inst_15086__$1);

return statearr_15143;
})();
if(cljs.core.truth_(inst_15088__$1)){
var statearr_15144_15183 = state_15131__$1;
(statearr_15144_15183[(1)] = (8));

} else {
var statearr_15145_15184 = state_15131__$1;
(statearr_15145_15184[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (17))){
var inst_15086 = (state_15131[(8)]);
var inst_15106 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,inst_15086);
var state_15131__$1 = state_15131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15131__$1,(20),inst_15106);
} else {
if((state_val_15132 === (3))){
var inst_15129 = (state_15131[(2)]);
var state_15131__$1 = state_15131;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15131__$1,inst_15129);
} else {
if((state_val_15132 === (12))){
var inst_15079 = (state_15131[(11)]);
var inst_15094 = (inst_15079 >= subject_limit);
var state_15131__$1 = state_15131;
var statearr_15146_15185 = state_15131__$1;
(statearr_15146_15185[(2)] = inst_15094);

(statearr_15146_15185[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (2))){
var _ = (function (){var statearr_15147 = state_15131;
(statearr_15147[(4)] = cljs.core.cons.call(null,(5),(state_15131[(4)])));

return statearr_15147;
})();
var inst_15070 = subject_groups;
var inst_15071 = cljs.core.seq.call(null,inst_15070);
var inst_15072 = cljs.core.first.call(null,inst_15071);
var inst_15073 = cljs.core.next.call(null,inst_15071);
var inst_15074 = flake_start;
var inst_15075 = subject_start;
var inst_15076 = cljs.core.PersistentVector.EMPTY;
var inst_15077 = inst_15070;
var inst_15078 = inst_15074;
var inst_15079 = inst_15075;
var inst_15080 = inst_15076;
var state_15131__$1 = (function (){var statearr_15148 = state_15131;
(statearr_15148[(12)] = inst_15078);

(statearr_15148[(13)] = inst_15072);

(statearr_15148[(11)] = inst_15079);

(statearr_15148[(14)] = inst_15073);

(statearr_15148[(15)] = inst_15080);

(statearr_15148[(9)] = inst_15077);

return statearr_15148;
})();
var statearr_15149_15186 = state_15131__$1;
(statearr_15149_15186[(2)] = null);

(statearr_15149_15186[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (23))){
var inst_15087 = (state_15131[(10)]);
var inst_15078 = (state_15131[(12)]);
var inst_15079 = (state_15131[(11)]);
var inst_15112 = (state_15131[(16)]);
var inst_15080 = (state_15131[(15)]);
var inst_15113 = (state_15131[(17)]);
var inst_15118 = (state_15131[(2)]);
var inst_15119 = (inst_15078 + inst_15113);
var inst_15120 = (inst_15079 + inst_15118);
var inst_15121 = cljs.core.into.call(null,inst_15080,inst_15112);
var inst_15077 = inst_15087;
var inst_15078__$1 = inst_15119;
var inst_15079__$1 = inst_15120;
var inst_15080__$1 = inst_15121;
var state_15131__$1 = (function (){var statearr_15150 = state_15131;
(statearr_15150[(12)] = inst_15078__$1);

(statearr_15150[(11)] = inst_15079__$1);

(statearr_15150[(15)] = inst_15080__$1);

(statearr_15150[(9)] = inst_15077);

return statearr_15150;
})();
var statearr_15151_15187 = state_15131__$1;
(statearr_15151_15187[(2)] = null);

(statearr_15151_15187[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (19))){
var inst_15112 = (state_15131[(16)]);
var inst_15113 = (state_15131[(17)]);
var inst_15112__$1 = (state_15131[(2)]);
var inst_15113__$1 = cljs.core.count.call(null,inst_15112__$1);
var inst_15114 = cljs.core._EQ_.call(null,(0),inst_15113__$1);
var state_15131__$1 = (function (){var statearr_15152 = state_15131;
(statearr_15152[(16)] = inst_15112__$1);

(statearr_15152[(17)] = inst_15113__$1);

return statearr_15152;
})();
if(inst_15114){
var statearr_15153_15188 = state_15131__$1;
(statearr_15153_15188[(1)] = (21));

} else {
var statearr_15154_15189 = state_15131__$1;
(statearr_15154_15189[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (11))){
var inst_15091 = (state_15131[(18)]);
var state_15131__$1 = state_15131;
var statearr_15156_15190 = state_15131__$1;
(statearr_15156_15190[(2)] = inst_15091);

(statearr_15156_15190[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (9))){
var inst_15078 = (state_15131[(12)]);
var inst_15091 = (state_15131[(18)]);
var inst_15091__$1 = (inst_15078 >= flake_limit);
var state_15131__$1 = (function (){var statearr_15157 = state_15131;
(statearr_15157[(18)] = inst_15091__$1);

return statearr_15157;
})();
if(cljs.core.truth_(inst_15091__$1)){
var statearr_15158_15191 = state_15131__$1;
(statearr_15158_15191[(1)] = (11));

} else {
var statearr_15159_15192 = state_15131__$1;
(statearr_15159_15192[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (5))){
var _ = (function (){var statearr_15160 = state_15131;
(statearr_15160[(4)] = cljs.core.rest.call(null,(state_15131[(4)])));

return statearr_15160;
})();
var state_15131__$1 = state_15131;
var ex15155 = (state_15131__$1[(2)]);
var statearr_15161_15193 = state_15131__$1;
(statearr_15161_15193[(5)] = ex15155);


if((ex15155 instanceof Error)){
var statearr_15162_15194 = state_15131__$1;
(statearr_15162_15194[(1)] = (4));

(statearr_15162_15194[(5)] = null);

} else {
throw ex15155;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (14))){
var inst_15078 = (state_15131[(12)]);
var inst_15079 = (state_15131[(11)]);
var inst_15080 = (state_15131[(15)]);
var inst_15100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15101 = [inst_15078,inst_15079,inst_15080];
var inst_15102 = (new cljs.core.PersistentVector(null,3,(5),inst_15100,inst_15101,null));
var state_15131__$1 = state_15131;
var statearr_15163_15195 = state_15131__$1;
(statearr_15163_15195[(2)] = inst_15102);

(statearr_15163_15195[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (16))){
var inst_15124 = (state_15131[(2)]);
var state_15131__$1 = state_15131;
var statearr_15164_15196 = state_15131__$1;
(statearr_15164_15196[(2)] = inst_15124);

(statearr_15164_15196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (10))){
var inst_15098 = (state_15131[(2)]);
var state_15131__$1 = state_15131;
if(cljs.core.truth_(inst_15098)){
var statearr_15165_15197 = state_15131__$1;
(statearr_15165_15197[(1)] = (14));

} else {
var statearr_15166_15198 = state_15131__$1;
(statearr_15166_15198[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (18))){
var inst_15086 = (state_15131[(8)]);
var state_15131__$1 = state_15131;
var statearr_15167_15199 = state_15131__$1;
(statearr_15167_15199[(2)] = inst_15086);

(statearr_15167_15199[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15132 === (8))){
var inst_15088 = (state_15131[(7)]);
var state_15131__$1 = state_15131;
var statearr_15168_15200 = state_15131__$1;
(statearr_15168_15200[(2)] = inst_15088);

(statearr_15168_15200[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____0 = (function (){
var statearr_15169 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15169[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__);

(statearr_15169[(1)] = (1));

return statearr_15169;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____1 = (function (state_15131){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15131);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15170){var ex__2749__auto__ = e15170;
var statearr_15171_15201 = state_15131;
(statearr_15171_15201[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15131[(4)]))){
var statearr_15172_15202 = state_15131;
(statearr_15172_15202[(1)] = cljs.core.first.call(null,(state_15131[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15203 = state_15131;
state_15131 = G__15203;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__ = function(state_15131){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____1.call(this,state_15131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15173 = f__2769__auto__.call(null);
(statearr_15173[(6)] = c__2768__auto__);

return statearr_15173;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15249){
var state_val_15250 = (state_15249[(1)]);
if((state_val_15250 === (7))){
var state_15249__$1 = state_15249;
var statearr_15251_15289 = state_15249__$1;
(statearr_15251_15289[(2)] = null);

(statearr_15251_15289[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (20))){
var inst_15235 = (state_15249[(2)]);
var inst_15236 = fluree.db.util.async.throw_err.call(null,inst_15235);
var inst_15214 = inst_15236;
var state_15249__$1 = (function (){var statearr_15252 = state_15249;
(statearr_15252[(7)] = inst_15214);

return statearr_15252;
})();
var statearr_15253_15290 = state_15249__$1;
(statearr_15253_15290[(2)] = null);

(statearr_15253_15290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (1))){
var state_15249__$1 = state_15249;
var statearr_15254_15291 = state_15249__$1;
(statearr_15254_15291[(2)] = null);

(statearr_15254_15291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (4))){
var inst_15204 = (state_15249[(2)]);
var state_15249__$1 = state_15249;
var statearr_15255_15292 = state_15249__$1;
(statearr_15255_15292[(2)] = inst_15204);

(statearr_15255_15292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (15))){
var inst_15231 = (state_15249[(8)]);
var inst_15214 = (state_15249[(7)]);
var inst_15231__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_15214);
var state_15249__$1 = (function (){var statearr_15256 = state_15249;
(statearr_15256[(8)] = inst_15231__$1);

return statearr_15256;
})();
if(cljs.core.truth_(inst_15231__$1)){
var statearr_15257_15293 = state_15249__$1;
(statearr_15257_15293[(1)] = (17));

} else {
var statearr_15258_15294 = state_15249__$1;
(statearr_15258_15294[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (13))){
var inst_15224 = (state_15249[(2)]);
var inst_15225 = fluree.db.util.async.throw_err.call(null,inst_15224);
var _ = (function (){var statearr_15259 = state_15249;
(statearr_15259[(4)] = cljs.core.rest.call(null,(state_15249[(4)])));

return statearr_15259;
})();
var state_15249__$1 = state_15249;
var statearr_15260_15295 = state_15249__$1;
(statearr_15260_15295[(2)] = inst_15225);

(statearr_15260_15295[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (6))){
var inst_15212 = (state_15249[(2)]);
var inst_15213 = fluree.db.util.async.throw_err.call(null,inst_15212);
var inst_15214 = inst_15213;
var state_15249__$1 = (function (){var statearr_15261 = state_15249;
(statearr_15261[(7)] = inst_15214);

return statearr_15261;
})();
var statearr_15262_15296 = state_15249__$1;
(statearr_15262_15296[(2)] = null);

(statearr_15262_15296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (17))){
var inst_15231 = (state_15249[(8)]);
var inst_15233 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_15231);
var state_15249__$1 = state_15249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15249__$1,(20),inst_15233);
} else {
if((state_val_15250 === (3))){
var inst_15247 = (state_15249[(2)]);
var state_15249__$1 = state_15249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15249__$1,inst_15247);
} else {
if((state_val_15250 === (12))){
var _ = (function (){var statearr_15264 = state_15249;
(statearr_15264[(4)] = cljs.core.rest.call(null,(state_15249[(4)])));

return statearr_15264;
})();
var state_15249__$1 = state_15249;
var ex15263 = (state_15249__$1[(2)]);
var statearr_15265_15297 = state_15249__$1;
(statearr_15265_15297[(5)] = ex15263);


var statearr_15266_15298 = state_15249__$1;
(statearr_15266_15298[(1)] = (11));

(statearr_15266_15298[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (2))){
var _ = (function (){var statearr_15267 = state_15249;
(statearr_15267[(4)] = cljs.core.cons.call(null,(5),(state_15249[(4)])));

return statearr_15267;
})();
var inst_15210 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_15249__$1 = state_15249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15249__$1,(6),inst_15210);
} else {
if((state_val_15250 === (19))){
var inst_15240 = (state_15249[(2)]);
var state_15249__$1 = state_15249;
var statearr_15268_15299 = state_15249__$1;
(statearr_15268_15299[(2)] = inst_15240);

(statearr_15268_15299[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (11))){
var inst_15216 = (state_15249[(2)]);
var state_15249__$1 = (function (){var statearr_15270 = state_15249;
(statearr_15270[(9)] = inst_15216);

return statearr_15270;
})();
var statearr_15271_15300 = state_15249__$1;
(statearr_15271_15300[(2)] = null);

(statearr_15271_15300[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (9))){
var inst_15214 = (state_15249[(7)]);
var _ = (function (){var statearr_15272 = state_15249;
(statearr_15272[(4)] = cljs.core.cons.call(null,(12),(state_15249[(4)])));

return statearr_15272;
})();
var inst_15222 = fluree.db.dbproto._resolve_to_t.call(null,inst_15214,t,novelty,fast_forward_db_QMARK_);
var state_15249__$1 = state_15249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15249__$1,(13),inst_15222);
} else {
if((state_val_15250 === (5))){
var _ = (function (){var statearr_15273 = state_15249;
(statearr_15273[(4)] = cljs.core.rest.call(null,(state_15249[(4)])));

return statearr_15273;
})();
var state_15249__$1 = state_15249;
var ex15269 = (state_15249__$1[(2)]);
var statearr_15274_15301 = state_15249__$1;
(statearr_15274_15301[(5)] = ex15269);


if((ex15269 instanceof Error)){
var statearr_15275_15302 = state_15249__$1;
(statearr_15275_15302[(1)] = (4));

(statearr_15275_15302[(5)] = null);

} else {
throw ex15269;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (14))){
var inst_15228 = (state_15249[(10)]);
var state_15249__$1 = state_15249;
var statearr_15276_15303 = state_15249__$1;
(statearr_15276_15303[(2)] = inst_15228);

(statearr_15276_15303[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (16))){
var inst_15242 = (state_15249[(2)]);
var state_15249__$1 = state_15249;
var statearr_15277_15304 = state_15249__$1;
(statearr_15277_15304[(2)] = inst_15242);

(statearr_15277_15304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (10))){
var inst_15228 = (state_15249[(10)]);
var inst_15228__$1 = (state_15249[(2)]);
var state_15249__$1 = (function (){var statearr_15278 = state_15249;
(statearr_15278[(10)] = inst_15228__$1);

return statearr_15278;
})();
if(cljs.core.truth_(inst_15228__$1)){
var statearr_15279_15305 = state_15249__$1;
(statearr_15279_15305[(1)] = (14));

} else {
var statearr_15280_15306 = state_15249__$1;
(statearr_15280_15306[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (18))){
var state_15249__$1 = state_15249;
var statearr_15281_15307 = state_15249__$1;
(statearr_15281_15307[(2)] = null);

(statearr_15281_15307[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15250 === (8))){
var inst_15244 = (state_15249[(2)]);
var _ = (function (){var statearr_15282 = state_15249;
(statearr_15282[(4)] = cljs.core.rest.call(null,(state_15249[(4)])));

return statearr_15282;
})();
var state_15249__$1 = state_15249;
var statearr_15283_15308 = state_15249__$1;
(statearr_15283_15308[(2)] = inst_15244);

(statearr_15283_15308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____0 = (function (){
var statearr_15284 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15284[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__);

(statearr_15284[(1)] = (1));

return statearr_15284;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____1 = (function (state_15249){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15285){var ex__2749__auto__ = e15285;
var statearr_15286_15309 = state_15249;
(statearr_15286_15309[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15249[(4)]))){
var statearr_15287_15310 = state_15249;
(statearr_15287_15310[(1)] = cljs.core.first.call(null,(state_15249[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15311 = state_15249;
state_15249 = G__15311;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__ = function(state_15249){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____1.call(this,state_15249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15288 = f__2769__auto__.call(null);
(statearr_15288[(6)] = c__2768__auto__);

return statearr_15288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15318 = arguments.length;
switch (G__15318) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15319 = (function (){var pred__15322 = cljs.core.identical_QMARK_;
var expr__15323 = test;
if(cljs.core.truth_(pred__15322.call(null,cljs.core._EQ_,expr__15323))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__15322.call(null,cljs.core._LT_,expr__15323))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__15322.call(null,cljs.core._LT__EQ_,expr__15323))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__15322.call(null,cljs.core._GT_,expr__15323))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__15322.call(null,cljs.core._GT__EQ_,expr__15323))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15323)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__15319,(0),null);
var start_match = cljs.core.nth.call(null,vec__15319,(1),null);
var end_test = cljs.core.nth.call(null,vec__15319,(2),null);
var end_match = cljs.core.nth.call(null,vec__15319,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15695){
var state_val_15696 = (state_15695[(1)]);
if((state_val_15696 === (121))){
var inst_15651 = (state_15695[(7)]);
var state_15695__$1 = state_15695;
var statearr_15697_15890 = state_15695__$1;
(statearr_15697_15890[(2)] = inst_15651);

(statearr_15697_15890[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (65))){
var inst_15503 = (state_15695[(8)]);
var inst_15509 = (state_15695[(2)]);
var state_15695__$1 = (function (){var statearr_15698 = state_15695;
(statearr_15698[(9)] = inst_15509);

return statearr_15698;
})();
if(cljs.core.truth_(inst_15503)){
var statearr_15699_15891 = state_15695__$1;
(statearr_15699_15891[(1)] = (66));

} else {
var statearr_15700_15892 = state_15695__$1;
(statearr_15700_15892[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (70))){
var inst_15687 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15701_15893 = state_15695__$1;
(statearr_15701_15893[(2)] = inst_15687);

(statearr_15701_15893[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (62))){
var inst_15502 = (state_15695[(2)]);
var inst_15503 = fluree.db.util.async.throw_err.call(null,inst_15502);
var inst_15504 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_15695__$1 = (function (){var statearr_15702 = state_15695;
(statearr_15702[(8)] = inst_15503);

return statearr_15702;
})();
if(cljs.core.truth_(inst_15504)){
var statearr_15703_15894 = state_15695__$1;
(statearr_15703_15894[(1)] = (63));

} else {
var statearr_15704_15895 = state_15695__$1;
(statearr_15704_15895[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (74))){
var inst_15453 = (state_15695[(10)]);
var inst_15417 = (state_15695[(11)]);
var inst_15512 = (state_15695[(12)]);
var inst_15473 = (state_15695[(13)]);
var inst_15361 = (state_15695[(14)]);
var inst_15444 = (state_15695[(15)]);
var inst_15413 = (state_15695[(16)]);
var inst_15475 = (state_15695[(17)]);
var inst_15362 = (state_15695[(18)]);
var inst_15357 = (state_15695[(19)]);
var inst_15522 = (state_15695[(20)]);
var inst_15530 = (state_15695[(21)]);
var inst_15514 = (state_15695[(22)]);
var inst_15509 = (state_15695[(9)]);
var inst_15515 = (state_15695[(23)]);
var inst_15488 = (state_15695[(24)]);
var inst_15381 = (state_15695[(25)]);
var inst_15484 = (state_15695[(26)]);
var inst_15499 = (state_15695[(27)]);
var inst_15372 = (state_15695[(28)]);
var inst_15360 = (state_15695[(29)]);
var inst_15483 = (state_15695[(30)]);
var inst_15350 = (state_15695[(31)]);
var inst_15493 = (state_15695[(32)]);
var inst_15476 = (state_15695[(33)]);
var inst_15513 = (state_15695[(34)]);
var inst_15516 = (state_15695[(35)]);
var inst_15471 = (state_15695[(36)]);
var inst_15414 = (state_15695[(37)]);
var inst_15462 = (state_15695[(38)]);
var inst_15426 = (state_15695[(39)]);
var inst_15494 = (state_15695[(40)]);
var inst_15472 = (state_15695[(41)]);
var inst_15489 = (state_15695[(42)]);
var inst_15345 = (state_15695[(43)]);
var inst_15503 = (state_15695[(8)]);
var inst_15352 = (state_15695[(44)]);
var inst_15482 = (state_15695[(45)]);
var inst_15356 = (state_15695[(46)]);
var inst_15435 = (state_15695[(47)]);
var inst_15349 = (state_15695[(48)]);
var inst_15532 = (function (){var no_filter_QMARK_ = inst_15509;
var t = inst_15489;
var max_limit_QMARK_ = inst_15483;
var next_node = inst_15512;
var fast_forward_db_QMARK_ = inst_15494;
var G__15523 = inst_15530;
var s1 = inst_15372;
var o2 = inst_15435;
var t1 = inst_15349;
var predicate_fn = inst_15362;
var i = inst_15514;
var m1 = inst_15462;
var root_node = inst_15499;
var s2 = inst_15381;
var p2 = inst_15453;
var permissions = inst_15484;
var limit = inst_15482;
var start_flake = inst_15472;
var flake_limit = inst_15476;
var offset = inst_15513;
var vec__15338 = inst_15413;
var acc = inst_15516;
var t2 = inst_15356;
var op1 = inst_15350;
var o1 = inst_15426;
var end_flake = inst_15473;
var base_result = inst_15522;
var s = inst_15515;
var node_start = inst_15503;
var p1 = inst_15444;
var vec__15334 = inst_15352;
var subject_fn = inst_15361;
var map__15344 = inst_15475;
var object_fn = inst_15417;
var vec__15331 = inst_15345;
var idx_compare = inst_15488;
var map__15337 = inst_15360;
var vec__15341 = inst_15414;
var op2 = inst_15357;
var m2 = inst_15471;
var novelty = inst_15493;
return (function (p1__15313_SHARP_){
return subject_fn.call(null,p1__15313_SHARP_.s);
});
})();
var inst_15533 = cljs.core.filter.call(null,inst_15532,inst_15530);
var state_15695__$1 = state_15695;
var statearr_15705_15896 = state_15695__$1;
(statearr_15705_15896[(2)] = inst_15533);

(statearr_15705_15896[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (110))){
var inst_15664 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15706_15897 = state_15695__$1;
(statearr_15706_15897[(2)] = inst_15664);

(statearr_15706_15897[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (7))){
var inst_15346 = (state_15695[(49)]);
var state_15695__$1 = state_15695;
var statearr_15707_15898 = state_15695__$1;
(statearr_15707_15898[(2)] = inst_15346);

(statearr_15707_15898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (59))){
var state_15695__$1 = state_15695;
var statearr_15708_15899 = state_15695__$1;
(statearr_15708_15899[(2)] = fluree.db.util.core.max_long);

(statearr_15708_15899[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (86))){
var inst_15509 = (state_15695[(9)]);
var state_15695__$1 = state_15695;
var statearr_15709_15900 = state_15695__$1;
(statearr_15709_15900[(2)] = inst_15509);

(statearr_15709_15900[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (20))){
var state_15695__$1 = state_15695;
var statearr_15710_15901 = state_15695__$1;
(statearr_15710_15901[(2)] = null);

(statearr_15710_15901[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (72))){
var inst_15522 = (state_15695[(20)]);
var state_15695__$1 = state_15695;
var statearr_15711_15902 = state_15695__$1;
(statearr_15711_15902[(2)] = inst_15522);

(statearr_15711_15902[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (58))){
var inst_15477 = (state_15695[(50)]);
var state_15695__$1 = state_15695;
var statearr_15712_15903 = state_15695__$1;
(statearr_15712_15903[(2)] = inst_15477);

(statearr_15712_15903[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (60))){
var inst_15482 = (state_15695[(45)]);
var inst_15482__$1 = (state_15695[(2)]);
var inst_15483 = cljs.core._EQ_.call(null,inst_15482__$1,fluree.db.util.core.max_long);
var inst_15484 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_15485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15486 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_15487 = (new cljs.core.PersistentVector(null,3,(5),inst_15485,inst_15486,null));
var inst_15488 = cljs.core.get_in.call(null,db,inst_15487);
var inst_15489 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_15490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15491 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_15492 = (new cljs.core.PersistentVector(null,2,(5),inst_15490,inst_15491,null));
var inst_15493 = cljs.core.get_in.call(null,db,inst_15492);
var inst_15494 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_15495 = cljs.core.get.call(null,db,idx);
var inst_15496 = fluree.db.dbproto._resolve.call(null,inst_15495);
var state_15695__$1 = (function (){var statearr_15713 = state_15695;
(statearr_15713[(24)] = inst_15488);

(statearr_15713[(26)] = inst_15484);

(statearr_15713[(30)] = inst_15483);

(statearr_15713[(32)] = inst_15493);

(statearr_15713[(40)] = inst_15494);

(statearr_15713[(42)] = inst_15489);

(statearr_15713[(45)] = inst_15482__$1);

return statearr_15713;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15695__$1,(61),inst_15496);
} else {
if((state_val_15696 === (27))){
var inst_15415 = (state_15695[(51)]);
var state_15695__$1 = state_15695;
var statearr_15714_15904 = state_15695__$1;
(statearr_15714_15904[(2)] = inst_15415);

(statearr_15714_15904[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (1))){
var state_15695__$1 = state_15695;
var statearr_15715_15905 = state_15695__$1;
(statearr_15715_15905[(2)] = null);

(statearr_15715_15905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (69))){
var inst_15512 = (state_15695[(12)]);
var inst_15473 = (state_15695[(13)]);
var inst_15472 = (state_15695[(41)]);
var inst_15521 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_15512);
var inst_15522 = fluree.db.flake.subrange.call(null,inst_15521,start_test,inst_15472,end_test,inst_15473);
var inst_15524 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_15472,inst_15473);
var state_15695__$1 = (function (){var statearr_15716 = state_15695;
(statearr_15716[(20)] = inst_15522);

return statearr_15716;
})();
if(inst_15524){
var statearr_15717_15906 = state_15695__$1;
(statearr_15717_15906[(1)] = (71));

} else {
var statearr_15718_15907 = state_15695__$1;
(statearr_15718_15907[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (101))){
var inst_15610 = (state_15695[(52)]);
var inst_15476 = (state_15695[(33)]);
var inst_15609 = (state_15695[(53)]);
var inst_15608 = (state_15695[(54)]);
var inst_15613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15614 = (inst_15610 - inst_15476);
var inst_15615 = (inst_15609 - inst_15614);
var inst_15616 = cljs.core.take.call(null,inst_15615,inst_15608);
var inst_15617 = [inst_15476,inst_15616];
var inst_15618 = (new cljs.core.PersistentVector(null,2,(5),inst_15613,inst_15617,null));
var state_15695__$1 = state_15695;
var statearr_15719_15908 = state_15695__$1;
(statearr_15719_15908[(2)] = inst_15618);

(statearr_15719_15908[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (24))){
var inst_15361 = (state_15695[(14)]);
var inst_15348 = (state_15695[(55)]);
var inst_15363 = (state_15695[(56)]);
var inst_15362 = (state_15695[(18)]);
var inst_15357 = (state_15695[(19)]);
var inst_15354 = (state_15695[(57)]);
var inst_15355 = (state_15695[(58)]);
var inst_15381 = (state_15695[(25)]);
var inst_15358 = (state_15695[(59)]);
var inst_15372 = (state_15695[(28)]);
var inst_15360 = (state_15695[(29)]);
var inst_15350 = (state_15695[(31)]);
var inst_15395 = (state_15695[(60)]);
var inst_15345 = (state_15695[(43)]);
var inst_15351 = (state_15695[(61)]);
var inst_15352 = (state_15695[(44)]);
var inst_15356 = (state_15695[(46)]);
var inst_15347 = (state_15695[(62)]);
var inst_15349 = (state_15695[(48)]);
var inst_15405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15407 = [null,null];
var inst_15408 = (new cljs.core.PersistentVector(null,2,(5),inst_15406,inst_15407,null));
var inst_15409 = (function (){var bool = inst_15395;
var s1 = inst_15372;
var o2 = inst_15355;
var t1 = inst_15349;
var predicate_fn = inst_15362;
var m1 = inst_15351;
var s2 = inst_15381;
var p2 = inst_15354;
var t2 = inst_15356;
var op1 = inst_15350;
var o1 = inst_15348;
var p1 = inst_15347;
var vec__15334 = inst_15352;
var subject_fn = inst_15361;
var temp__5806__auto__ = inst_15395;
var object_fn = inst_15363;
var vec__15331 = inst_15345;
var map__15337 = inst_15360;
var op2 = inst_15357;
var m2 = inst_15358;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_15410 = [inst_15408,inst_15409];
var inst_15411 = (new cljs.core.PersistentVector(null,2,(5),inst_15405,inst_15410,null));
var state_15695__$1 = state_15695;
var statearr_15720_15909 = state_15695__$1;
(statearr_15720_15909[(2)] = inst_15411);

(statearr_15720_15909[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (102))){
var inst_15610 = (state_15695[(52)]);
var inst_15608 = (state_15695[(54)]);
var inst_15620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15621 = [inst_15610,inst_15608];
var inst_15622 = (new cljs.core.PersistentVector(null,2,(5),inst_15620,inst_15621,null));
var state_15695__$1 = state_15695;
var statearr_15721_15910 = state_15695__$1;
(statearr_15721_15910[(2)] = inst_15622);

(statearr_15721_15910[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (55))){
var state_15695__$1 = state_15695;
var statearr_15722_15911 = state_15695__$1;
(statearr_15722_15911[(2)] = (2147483647));

(statearr_15722_15911[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (85))){
var inst_15558 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
if(cljs.core.truth_(inst_15558)){
var statearr_15723_15912 = state_15695__$1;
(statearr_15723_15912[(1)] = (89));

} else {
var statearr_15724_15913 = state_15695__$1;
(statearr_15724_15913[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (39))){
var inst_15354 = (state_15695[(57)]);
var inst_15445 = (state_15695[(63)]);
var inst_15444 = (state_15695[(2)]);
var inst_15445__$1 = (inst_15354 == null);
var state_15695__$1 = (function (){var statearr_15725 = state_15695;
(statearr_15725[(15)] = inst_15444);

(statearr_15725[(63)] = inst_15445__$1);

return statearr_15725;
})();
if(cljs.core.truth_(inst_15445__$1)){
var statearr_15726_15914 = state_15695__$1;
(statearr_15726_15914[(1)] = (40));

} else {
var statearr_15727_15915 = state_15695__$1;
(statearr_15727_15915[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (88))){
var inst_15555 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15728_15916 = state_15695__$1;
(statearr_15728_15916[(2)] = inst_15555);

(statearr_15728_15916[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (46))){
var inst_15351 = (state_15695[(61)]);
var state_15695__$1 = state_15695;
var statearr_15729_15917 = state_15695__$1;
(statearr_15729_15917[(2)] = inst_15351);

(statearr_15729_15917[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (4))){
var inst_15325 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15730_15918 = state_15695__$1;
(statearr_15730_15918[(2)] = inst_15325);

(statearr_15730_15918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (77))){
var inst_15453 = (state_15695[(10)]);
var inst_15417 = (state_15695[(11)]);
var inst_15512 = (state_15695[(12)]);
var inst_15473 = (state_15695[(13)]);
var inst_15361 = (state_15695[(14)]);
var inst_15444 = (state_15695[(15)]);
var inst_15413 = (state_15695[(16)]);
var inst_15475 = (state_15695[(17)]);
var inst_15536 = (state_15695[(64)]);
var inst_15362 = (state_15695[(18)]);
var inst_15357 = (state_15695[(19)]);
var inst_15522 = (state_15695[(20)]);
var inst_15514 = (state_15695[(22)]);
var inst_15509 = (state_15695[(9)]);
var inst_15515 = (state_15695[(23)]);
var inst_15488 = (state_15695[(24)]);
var inst_15381 = (state_15695[(25)]);
var inst_15484 = (state_15695[(26)]);
var inst_15499 = (state_15695[(27)]);
var inst_15372 = (state_15695[(28)]);
var inst_15360 = (state_15695[(29)]);
var inst_15483 = (state_15695[(30)]);
var inst_15350 = (state_15695[(31)]);
var inst_15493 = (state_15695[(32)]);
var inst_15476 = (state_15695[(33)]);
var inst_15513 = (state_15695[(34)]);
var inst_15516 = (state_15695[(35)]);
var inst_15471 = (state_15695[(36)]);
var inst_15414 = (state_15695[(37)]);
var inst_15462 = (state_15695[(38)]);
var inst_15426 = (state_15695[(39)]);
var inst_15494 = (state_15695[(40)]);
var inst_15472 = (state_15695[(41)]);
var inst_15489 = (state_15695[(42)]);
var inst_15345 = (state_15695[(43)]);
var inst_15503 = (state_15695[(8)]);
var inst_15352 = (state_15695[(44)]);
var inst_15482 = (state_15695[(45)]);
var inst_15356 = (state_15695[(46)]);
var inst_15435 = (state_15695[(47)]);
var inst_15349 = (state_15695[(48)]);
var inst_15538 = (function (){var no_filter_QMARK_ = inst_15509;
var t = inst_15489;
var max_limit_QMARK_ = inst_15483;
var next_node = inst_15512;
var fast_forward_db_QMARK_ = inst_15494;
var G__15523 = inst_15536;
var s1 = inst_15372;
var o2 = inst_15435;
var t1 = inst_15349;
var predicate_fn = inst_15362;
var i = inst_15514;
var m1 = inst_15462;
var root_node = inst_15499;
var s2 = inst_15381;
var p2 = inst_15453;
var permissions = inst_15484;
var limit = inst_15482;
var start_flake = inst_15472;
var flake_limit = inst_15476;
var offset = inst_15513;
var vec__15338 = inst_15413;
var acc = inst_15516;
var t2 = inst_15356;
var op1 = inst_15350;
var o1 = inst_15426;
var end_flake = inst_15473;
var base_result = inst_15522;
var s = inst_15515;
var node_start = inst_15503;
var p1 = inst_15444;
var vec__15334 = inst_15352;
var subject_fn = inst_15361;
var map__15344 = inst_15475;
var object_fn = inst_15417;
var vec__15331 = inst_15345;
var idx_compare = inst_15488;
var map__15337 = inst_15360;
var vec__15341 = inst_15414;
var op2 = inst_15357;
var m2 = inst_15471;
var novelty = inst_15493;
return (function (p1__15314_SHARP_){
return predicate_fn.call(null,p1__15314_SHARP_.p);
});
})();
var inst_15539 = cljs.core.filter.call(null,inst_15538,inst_15536);
var state_15695__$1 = state_15695;
var statearr_15731_15919 = state_15695__$1;
(statearr_15731_15919[(2)] = inst_15539);

(statearr_15731_15919[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (106))){
var inst_15549 = (state_15695[(65)]);
var state_15695__$1 = state_15695;
var statearr_15732_15920 = state_15695__$1;
(statearr_15732_15920[(2)] = inst_15549);

(statearr_15732_15920[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (119))){
var inst_15667 = (state_15695[(66)]);
var state_15695__$1 = state_15695;
var statearr_15733_15921 = state_15695__$1;
(statearr_15733_15921[(2)] = inst_15667);

(statearr_15733_15921[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (95))){
var inst_15515 = (state_15695[(23)]);
var inst_15591 = (state_15695[(67)]);
var inst_15592 = (state_15695[(68)]);
var inst_15590 = (state_15695[(69)]);
var inst_15582 = (state_15695[(70)]);
var inst_15482 = (state_15695[(45)]);
var inst_15590__$1 = cljs.core.count.call(null,inst_15582);
var inst_15591__$1 = (inst_15515 + inst_15590__$1);
var inst_15592__$1 = (inst_15591__$1 - inst_15482);
var inst_15593 = cljs.core.pos_int_QMARK_.call(null,inst_15592__$1);
var state_15695__$1 = (function (){var statearr_15734 = state_15695;
(statearr_15734[(67)] = inst_15591__$1);

(statearr_15734[(68)] = inst_15592__$1);

(statearr_15734[(69)] = inst_15590__$1);

return statearr_15734;
})();
if(inst_15593){
var statearr_15735_15922 = state_15695__$1;
(statearr_15735_15922[(1)] = (98));

} else {
var statearr_15736_15923 = state_15695__$1;
(statearr_15736_15923[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (54))){
var inst_15453 = (state_15695[(10)]);
var inst_15444 = (state_15695[(15)]);
var inst_15475 = (state_15695[(17)]);
var inst_15357 = (state_15695[(19)]);
var inst_15381 = (state_15695[(25)]);
var inst_15372 = (state_15695[(28)]);
var inst_15350 = (state_15695[(31)]);
var inst_15471 = (state_15695[(36)]);
var inst_15462 = (state_15695[(38)]);
var inst_15426 = (state_15695[(39)]);
var inst_15477 = (state_15695[(50)]);
var inst_15356 = (state_15695[(46)]);
var inst_15435 = (state_15695[(47)]);
var inst_15349 = (state_15695[(48)]);
var inst_15471__$1 = (state_15695[(2)]);
var inst_15472 = fluree.db.flake.__GT_Flake.call(null,inst_15372,inst_15444,inst_15426,inst_15349,inst_15350,inst_15462);
var inst_15473 = fluree.db.flake.__GT_Flake.call(null,inst_15381,inst_15453,inst_15435,inst_15356,inst_15357,inst_15471__$1);
var inst_15474 = opts;
var inst_15475__$1 = cljs.core.__destructure_map.call(null,inst_15474);
var inst_15476 = cljs.core.get.call(null,inst_15475__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_15477__$1 = cljs.core.get.call(null,inst_15475__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_15478 = cljs.core.get.call(null,inst_15475__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_15695__$1 = (function (){var statearr_15737 = state_15695;
(statearr_15737[(13)] = inst_15473);

(statearr_15737[(71)] = inst_15478);

(statearr_15737[(17)] = inst_15475__$1);

(statearr_15737[(33)] = inst_15476);

(statearr_15737[(36)] = inst_15471__$1);

(statearr_15737[(41)] = inst_15472);

(statearr_15737[(50)] = inst_15477__$1);

return statearr_15737;
})();
if(cljs.core.truth_(inst_15477__$1)){
var statearr_15738_15924 = state_15695__$1;
(statearr_15738_15924[(1)] = (58));

} else {
var statearr_15739_15925 = state_15695__$1;
(statearr_15739_15925[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (92))){
var inst_15514 = (state_15695[(22)]);
var inst_15515 = (state_15695[(23)]);
var inst_15513 = (state_15695[(34)]);
var inst_15516 = (state_15695[(35)]);
var inst_15571 = (state_15695[(72)]);
var inst_15574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15575 = (inst_15513 - inst_15571);
var inst_15576 = [inst_15575,inst_15514,inst_15515,inst_15516];
var inst_15577 = (new cljs.core.PersistentVector(null,4,(5),inst_15574,inst_15576,null));
var state_15695__$1 = state_15695;
var statearr_15740_15926 = state_15695__$1;
(statearr_15740_15926[(2)] = inst_15577);

(statearr_15740_15926[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (104))){
var inst_15633 = (state_15695[(2)]);
var inst_15634 = fluree.db.util.async.throw_err.call(null,inst_15633);
var state_15695__$1 = state_15695;
var statearr_15741_15927 = state_15695__$1;
(statearr_15741_15927[(2)] = inst_15634);

(statearr_15741_15927[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (15))){
var inst_15355 = (state_15695[(58)]);
var inst_15385 = cljs.core.boolean_QMARK_.call(null,inst_15355);
var state_15695__$1 = state_15695;
if(inst_15385){
var statearr_15742_15928 = state_15695__$1;
(statearr_15742_15928[(1)] = (17));

} else {
var statearr_15743_15929 = state_15695__$1;
(statearr_15743_15929[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (48))){
var inst_15358 = (state_15695[(59)]);
var inst_15462 = (state_15695[(2)]);
var state_15695__$1 = (function (){var statearr_15744 = state_15695;
(statearr_15744[(38)] = inst_15462);

return statearr_15744;
})();
if(cljs.core.truth_(inst_15358)){
var statearr_15745_15930 = state_15695__$1;
(statearr_15745_15930[(1)] = (52));

} else {
var statearr_15746_15931 = state_15695__$1;
(statearr_15746_15931[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (50))){
var state_15695__$1 = state_15695;
var statearr_15747_15932 = state_15695__$1;
(statearr_15747_15932[(2)] = (2147483647));

(statearr_15747_15932[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (116))){
var inst_15667 = (state_15695[(66)]);
var inst_15675 = (state_15695[(2)]);
var state_15695__$1 = (function (){var statearr_15748 = state_15695;
(statearr_15748[(73)] = inst_15675);

return statearr_15748;
})();
if(cljs.core.truth_(inst_15667)){
var statearr_15749_15933 = state_15695__$1;
(statearr_15749_15933[(1)] = (118));

} else {
var statearr_15750_15934 = state_15695__$1;
(statearr_15750_15934[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (75))){
var inst_15530 = (state_15695[(21)]);
var state_15695__$1 = state_15695;
var statearr_15751_15935 = state_15695__$1;
(statearr_15751_15935[(2)] = inst_15530);

(statearr_15751_15935[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (99))){
var inst_15591 = (state_15695[(67)]);
var inst_15600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15601 = [inst_15591,inst_15591];
var inst_15602 = (new cljs.core.PersistentVector(null,2,(5),inst_15600,inst_15601,null));
var state_15695__$1 = state_15695;
var statearr_15752_15936 = state_15695__$1;
(statearr_15752_15936[(2)] = inst_15602);

(statearr_15752_15936[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (21))){
var state_15695__$1 = state_15695;
var statearr_15753_15937 = state_15695__$1;
(statearr_15753_15937[(2)] = null);

(statearr_15753_15937[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (31))){
var inst_15416 = (state_15695[(74)]);
var state_15695__$1 = state_15695;
var statearr_15754_15938 = state_15695__$1;
(statearr_15754_15938[(2)] = inst_15416);

(statearr_15754_15938[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (113))){
var inst_15661 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15755_15939 = state_15695__$1;
(statearr_15755_15939[(2)] = inst_15661);

(statearr_15755_15939[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (32))){
var inst_15436 = (state_15695[(75)]);
var inst_15347 = (state_15695[(62)]);
var inst_15435 = (state_15695[(2)]);
var inst_15436__$1 = (inst_15347 == null);
var state_15695__$1 = (function (){var statearr_15756 = state_15695;
(statearr_15756[(75)] = inst_15436__$1);

(statearr_15756[(47)] = inst_15435);

return statearr_15756;
})();
if(cljs.core.truth_(inst_15436__$1)){
var statearr_15757_15940 = state_15695__$1;
(statearr_15757_15940[(1)] = (34));

} else {
var statearr_15758_15941 = state_15695__$1;
(statearr_15758_15941[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (40))){
var inst_15435 = (state_15695[(47)]);
var state_15695__$1 = state_15695;
var statearr_15759_15942 = state_15695__$1;
(statearr_15759_15942[(2)] = inst_15435);

(statearr_15759_15942[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (91))){
var inst_15549 = (state_15695[(65)]);
var inst_15647 = (state_15695[(2)]);
var inst_15648 = cljs.core.nth.call(null,inst_15647,(0),null);
var inst_15649 = cljs.core.nth.call(null,inst_15647,(1),null);
var inst_15650 = cljs.core.nth.call(null,inst_15647,(2),null);
var inst_15651 = cljs.core.nth.call(null,inst_15647,(3),null);
var state_15695__$1 = (function (){var statearr_15760 = state_15695;
(statearr_15760[(7)] = inst_15651);

(statearr_15760[(76)] = inst_15649);

(statearr_15760[(77)] = inst_15648);

(statearr_15760[(78)] = inst_15650);

return statearr_15760;
})();
if(cljs.core.truth_(inst_15549)){
var statearr_15761_15943 = state_15695__$1;
(statearr_15761_15943[(1)] = (105));

} else {
var statearr_15762_15944 = state_15695__$1;
(statearr_15762_15944[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (117))){
var inst_15671 = (state_15695[(2)]);
var inst_15672 = fluree.db.util.async.throw_err.call(null,inst_15671);
var state_15695__$1 = state_15695;
var statearr_15763_15945 = state_15695__$1;
(statearr_15763_15945[(2)] = inst_15672);

(statearr_15763_15945[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (108))){
var inst_15656 = (state_15695[(79)]);
var inst_15476 = (state_15695[(33)]);
var inst_15649 = (state_15695[(76)]);
var inst_15656__$1 = (inst_15649 < inst_15476);
var state_15695__$1 = (function (){var statearr_15764 = state_15695;
(statearr_15764[(79)] = inst_15656__$1);

return statearr_15764;
})();
if(cljs.core.truth_(inst_15656__$1)){
var statearr_15765_15946 = state_15695__$1;
(statearr_15765_15946[(1)] = (111));

} else {
var statearr_15766_15947 = state_15695__$1;
(statearr_15766_15947[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (56))){
var state_15695__$1 = state_15695;
var statearr_15767_15948 = state_15695__$1;
(statearr_15767_15948[(2)] = fluree.db.util.core.min_integer);

(statearr_15767_15948[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (33))){
var inst_15431 = (state_15695[(2)]);
var inst_15432 = fluree.db.util.async.throw_err.call(null,inst_15431);
var state_15695__$1 = state_15695;
var statearr_15768_15949 = state_15695__$1;
(statearr_15768_15949[(2)] = inst_15432);

(statearr_15768_15949[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (13))){
var inst_15377 = (state_15695[(2)]);
var inst_15378 = fluree.db.util.async.throw_err.call(null,inst_15377);
var state_15695__$1 = state_15695;
var statearr_15769_15950 = state_15695__$1;
(statearr_15769_15950[(2)] = inst_15378);

(statearr_15769_15950[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (22))){
var inst_15391 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15770_15951 = state_15695__$1;
(statearr_15770_15951[(2)] = inst_15391);

(statearr_15770_15951[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (90))){
var inst_15453 = (state_15695[(10)]);
var inst_15417 = (state_15695[(11)]);
var inst_15512 = (state_15695[(12)]);
var inst_15473 = (state_15695[(13)]);
var inst_15361 = (state_15695[(14)]);
var inst_15444 = (state_15695[(15)]);
var inst_15413 = (state_15695[(16)]);
var inst_15475 = (state_15695[(17)]);
var inst_15362 = (state_15695[(18)]);
var inst_15357 = (state_15695[(19)]);
var inst_15522 = (state_15695[(20)]);
var inst_15514 = (state_15695[(22)]);
var inst_15509 = (state_15695[(9)]);
var inst_15515 = (state_15695[(23)]);
var inst_15488 = (state_15695[(24)]);
var inst_15381 = (state_15695[(25)]);
var inst_15484 = (state_15695[(26)]);
var inst_15499 = (state_15695[(27)]);
var inst_15372 = (state_15695[(28)]);
var inst_15360 = (state_15695[(29)]);
var inst_15483 = (state_15695[(30)]);
var inst_15350 = (state_15695[(31)]);
var inst_15493 = (state_15695[(32)]);
var inst_15476 = (state_15695[(33)]);
var inst_15513 = (state_15695[(34)]);
var inst_15516 = (state_15695[(35)]);
var inst_15571 = (state_15695[(72)]);
var inst_15471 = (state_15695[(36)]);
var inst_15414 = (state_15695[(37)]);
var inst_15462 = (state_15695[(38)]);
var inst_15426 = (state_15695[(39)]);
var inst_15548 = (state_15695[(80)]);
var inst_15494 = (state_15695[(40)]);
var inst_15549 = (state_15695[(65)]);
var inst_15472 = (state_15695[(41)]);
var inst_15489 = (state_15695[(42)]);
var inst_15345 = (state_15695[(43)]);
var inst_15503 = (state_15695[(8)]);
var inst_15352 = (state_15695[(44)]);
var inst_15482 = (state_15695[(45)]);
var inst_15356 = (state_15695[(46)]);
var inst_15435 = (state_15695[(47)]);
var inst_15349 = (state_15695[(48)]);
var inst_15570 = (state_15695[(81)]);
var inst_15569 = (function (){var no_filter_QMARK_ = inst_15509;
var base_result_SINGLEQUOTE_ = inst_15548;
var t = inst_15489;
var max_limit_QMARK_ = inst_15483;
var next_node = inst_15512;
var fast_forward_db_QMARK_ = inst_15494;
var s1 = inst_15372;
var o2 = inst_15435;
var t1 = inst_15349;
var predicate_fn = inst_15362;
var i = inst_15514;
var rhs = inst_15549;
var m1 = inst_15462;
var root_node = inst_15499;
var s2 = inst_15381;
var p2 = inst_15453;
var permissions = inst_15484;
var limit = inst_15482;
var start_flake = inst_15472;
var flake_limit = inst_15476;
var offset = inst_15513;
var vec__15338 = inst_15413;
var acc = inst_15516;
var t2 = inst_15356;
var op1 = inst_15350;
var o1 = inst_15426;
var end_flake = inst_15473;
var base_result = inst_15522;
var s = inst_15515;
var node_start = inst_15503;
var p1 = inst_15444;
var vec__15334 = inst_15352;
var subject_fn = inst_15361;
var map__15344 = inst_15475;
var object_fn = inst_15417;
var vec__15331 = inst_15345;
var idx_compare = inst_15488;
var map__15337 = inst_15360;
var vec__15341 = inst_15414;
var op2 = inst_15357;
var m2 = inst_15471;
var novelty = inst_15493;
return (function (p1__15316_SHARP_){
return p1__15316_SHARP_.s;
});
})();
var inst_15570__$1 = cljs.core.partition_by.call(null,inst_15569,inst_15548);
var inst_15571__$1 = cljs.core.count.call(null,inst_15570__$1);
var inst_15572 = (inst_15513 > inst_15571__$1);
var state_15695__$1 = (function (){var statearr_15771 = state_15695;
(statearr_15771[(72)] = inst_15571__$1);

(statearr_15771[(81)] = inst_15570__$1);

return statearr_15771;
})();
if(cljs.core.truth_(inst_15572)){
var statearr_15772_15952 = state_15695__$1;
(statearr_15772_15952[(1)] = (92));

} else {
var statearr_15773_15953 = state_15695__$1;
(statearr_15773_15953[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (109))){
var inst_15654 = (state_15695[(82)]);
var state_15695__$1 = state_15695;
var statearr_15774_15954 = state_15695__$1;
(statearr_15774_15954[(2)] = inst_15654);

(statearr_15774_15954[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (36))){
var inst_15440 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
if(cljs.core.truth_(inst_15440)){
var statearr_15775_15955 = state_15695__$1;
(statearr_15775_15955[(1)] = (37));

} else {
var statearr_15776_15956 = state_15695__$1;
(statearr_15776_15956[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (41))){
var inst_15445 = (state_15695[(63)]);
var state_15695__$1 = state_15695;
var statearr_15777_15957 = state_15695__$1;
(statearr_15777_15957[(2)] = inst_15445);

(statearr_15777_15957[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (118))){
var inst_15675 = (state_15695[(73)]);
var state_15695__$1 = state_15695;
var statearr_15778_15958 = state_15695__$1;
(statearr_15778_15958[(2)] = inst_15675);

(statearr_15778_15958[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (89))){
var inst_15514 = (state_15695[(22)]);
var inst_15515 = (state_15695[(23)]);
var inst_15476 = (state_15695[(33)]);
var inst_15516 = (state_15695[(35)]);
var inst_15548 = (state_15695[(80)]);
var inst_15560 = cljs.core.count.call(null,inst_15548);
var inst_15561 = (inst_15476 - inst_15514);
var inst_15562 = cljs.core.take.call(null,inst_15561,inst_15548);
var inst_15563 = cljs.core.into.call(null,inst_15516,inst_15562);
var inst_15564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15565 = (inst_15514 + inst_15560);
var inst_15566 = [(0),inst_15565,inst_15515,inst_15563];
var inst_15567 = (new cljs.core.PersistentVector(null,4,(5),inst_15564,inst_15566,null));
var state_15695__$1 = state_15695;
var statearr_15779_15959 = state_15695__$1;
(statearr_15779_15959[(2)] = inst_15567);

(statearr_15779_15959[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (100))){
var inst_15610 = (state_15695[(52)]);
var inst_15514 = (state_15695[(22)]);
var inst_15476 = (state_15695[(33)]);
var inst_15609 = (state_15695[(53)]);
var inst_15582 = (state_15695[(70)]);
var inst_15608 = (state_15695[(54)]);
var inst_15604 = (state_15695[(2)]);
var inst_15605 = cljs.core.nth.call(null,inst_15604,(0),null);
var inst_15606 = cljs.core.nth.call(null,inst_15604,(1),null);
var inst_15607 = cljs.core.take.call(null,inst_15606,inst_15582);
var inst_15608__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_15607);
var inst_15609__$1 = cljs.core.count.call(null,inst_15608__$1);
var inst_15610__$1 = (inst_15514 + inst_15609__$1);
var inst_15611 = (inst_15610__$1 > inst_15476);
var state_15695__$1 = (function (){var statearr_15780 = state_15695;
(statearr_15780[(52)] = inst_15610__$1);

(statearr_15780[(53)] = inst_15609__$1);

(statearr_15780[(83)] = inst_15605);

(statearr_15780[(54)] = inst_15608__$1);

return statearr_15780;
})();
if(cljs.core.truth_(inst_15611)){
var statearr_15781_15960 = state_15695__$1;
(statearr_15781_15960[(1)] = (101));

} else {
var statearr_15782_15961 = state_15695__$1;
(statearr_15782_15961[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (122))){
var inst_15675 = (state_15695[(73)]);
var inst_15651 = (state_15695[(7)]);
var inst_15649 = (state_15695[(76)]);
var inst_15648 = (state_15695[(77)]);
var inst_15650 = (state_15695[(78)]);
var inst_15512 = inst_15675;
var inst_15513 = inst_15648;
var inst_15514 = inst_15649;
var inst_15515 = inst_15650;
var inst_15516 = inst_15651;
var state_15695__$1 = (function (){var statearr_15783 = state_15695;
(statearr_15783[(12)] = inst_15512);

(statearr_15783[(22)] = inst_15514);

(statearr_15783[(23)] = inst_15515);

(statearr_15783[(34)] = inst_15513);

(statearr_15783[(35)] = inst_15516);

return statearr_15783;
})();
var statearr_15784_15962 = state_15695__$1;
(statearr_15784_15962[(2)] = null);

(statearr_15784_15962[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (43))){
var state_15695__$1 = state_15695;
var statearr_15785_15963 = state_15695__$1;
(statearr_15785_15963[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_15785_15963[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (61))){
var inst_15499 = (state_15695[(27)]);
var inst_15493 = (state_15695[(32)]);
var inst_15494 = (state_15695[(40)]);
var inst_15472 = (state_15695[(41)]);
var inst_15489 = (state_15695[(42)]);
var inst_15498 = (state_15695[(2)]);
var inst_15499__$1 = fluree.db.util.async.throw_err.call(null,inst_15498);
var inst_15500 = fluree.db.query.range.find_next_valid_node.call(null,inst_15499__$1,inst_15472,inst_15489,inst_15493,inst_15494);
var state_15695__$1 = (function (){var statearr_15786 = state_15695;
(statearr_15786[(27)] = inst_15499__$1);

return statearr_15786;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15695__$1,(62),inst_15500);
} else {
if((state_val_15696 === (29))){
var inst_15422 = (state_15695[(2)]);
var inst_15423 = fluree.db.util.async.throw_err.call(null,inst_15422);
var state_15695__$1 = state_15695;
var statearr_15787_15964 = state_15695__$1;
(statearr_15787_15964[(2)] = inst_15423);

(statearr_15787_15964[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (44))){
var inst_15354 = (state_15695[(57)]);
var state_15695__$1 = state_15695;
var statearr_15788_15965 = state_15695__$1;
(statearr_15788_15965[(2)] = inst_15354);

(statearr_15788_15965[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (93))){
var inst_15509 = (state_15695[(9)]);
var inst_15513 = (state_15695[(34)]);
var inst_15570 = (state_15695[(81)]);
var inst_15582 = cljs.core.drop.call(null,inst_15513,inst_15570);
var state_15695__$1 = (function (){var statearr_15789 = state_15695;
(statearr_15789[(70)] = inst_15582);

return statearr_15789;
})();
if(cljs.core.truth_(inst_15509)){
var statearr_15790_15966 = state_15695__$1;
(statearr_15790_15966[(1)] = (95));

} else {
var statearr_15791_15967 = state_15695__$1;
(statearr_15791_15967[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (6))){
var inst_15346 = (state_15695[(49)]);
var inst_15366 = fluree.db.dbproto._subid.call(null,db,inst_15346);
var state_15695__$1 = state_15695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15695__$1,(9),inst_15366);
} else {
if((state_val_15696 === (111))){
var inst_15650 = (state_15695[(78)]);
var inst_15482 = (state_15695[(45)]);
var inst_15658 = (inst_15650 < inst_15482);
var state_15695__$1 = state_15695;
var statearr_15792_15968 = state_15695__$1;
(statearr_15792_15968[(2)] = inst_15658);

(statearr_15792_15968[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (28))){
var inst_15416 = (state_15695[(74)]);
var inst_15426 = (state_15695[(2)]);
var inst_15427 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_15416);
var state_15695__$1 = (function (){var statearr_15793 = state_15695;
(statearr_15793[(39)] = inst_15426);

return statearr_15793;
})();
if(inst_15427){
var statearr_15794_15969 = state_15695__$1;
(statearr_15794_15969[(1)] = (30));

} else {
var statearr_15795_15970 = state_15695__$1;
(statearr_15795_15970[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (64))){
var state_15695__$1 = state_15695;
var statearr_15796_15971 = state_15695__$1;
(statearr_15796_15971[(2)] = true);

(statearr_15796_15971[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (103))){
var inst_15605 = (state_15695[(83)]);
var inst_15624 = (state_15695[(2)]);
var inst_15625 = cljs.core.nth.call(null,inst_15624,(0),null);
var inst_15626 = cljs.core.nth.call(null,inst_15624,(1),null);
var inst_15627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15628 = [inst_15625,inst_15605,inst_15626];
var inst_15629 = (new cljs.core.PersistentVector(null,3,(5),inst_15627,inst_15628,null));
var state_15695__$1 = state_15695;
var statearr_15797_15972 = state_15695__$1;
(statearr_15797_15972[(2)] = inst_15629);

(statearr_15797_15972[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (51))){
var inst_15460 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15798_15973 = state_15695__$1;
(statearr_15798_15973[(2)] = inst_15460);

(statearr_15798_15973[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (25))){
var inst_15413 = (state_15695[(16)]);
var inst_15415 = (state_15695[(51)]);
var inst_15414 = (state_15695[(37)]);
var inst_15413__$1 = (state_15695[(2)]);
var inst_15414__$1 = cljs.core.nth.call(null,inst_15413__$1,(0),null);
var inst_15415__$1 = cljs.core.nth.call(null,inst_15414__$1,(0),null);
var inst_15416 = cljs.core.nth.call(null,inst_15414__$1,(1),null);
var inst_15417 = cljs.core.nth.call(null,inst_15413__$1,(1),null);
var inst_15418 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_15415__$1);
var state_15695__$1 = (function (){var statearr_15799 = state_15695;
(statearr_15799[(11)] = inst_15417);

(statearr_15799[(74)] = inst_15416);

(statearr_15799[(16)] = inst_15413__$1);

(statearr_15799[(51)] = inst_15415__$1);

(statearr_15799[(37)] = inst_15414__$1);

return statearr_15799;
})();
if(inst_15418){
var statearr_15800_15974 = state_15695__$1;
(statearr_15800_15974[(1)] = (26));

} else {
var statearr_15801_15975 = state_15695__$1;
(statearr_15801_15975[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (34))){
var inst_15426 = (state_15695[(39)]);
var state_15695__$1 = state_15695;
var statearr_15802_15976 = state_15695__$1;
(statearr_15802_15976[(2)] = inst_15426);

(statearr_15802_15976[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (17))){
var inst_15355 = (state_15695[(58)]);
var state_15695__$1 = state_15695;
var statearr_15803_15977 = state_15695__$1;
(statearr_15803_15977[(2)] = inst_15355);

(statearr_15803_15977[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (3))){
var inst_15693 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15695__$1,inst_15693);
} else {
if((state_val_15696 === (12))){
var inst_15348 = (state_15695[(55)]);
var inst_15381 = (state_15695[(2)]);
var inst_15382 = cljs.core.boolean_QMARK_.call(null,inst_15348);
var state_15695__$1 = (function (){var statearr_15804 = state_15695;
(statearr_15804[(25)] = inst_15381);

return statearr_15804;
})();
if(inst_15382){
var statearr_15805_15978 = state_15695__$1;
(statearr_15805_15978[(1)] = (14));

} else {
var statearr_15806_15979 = state_15695__$1;
(statearr_15806_15979[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (2))){
var inst_15360 = (state_15695[(29)]);
var inst_15345 = (state_15695[(43)]);
var inst_15346 = (state_15695[(49)]);
var inst_15352 = (state_15695[(44)]);
var _ = (function (){var statearr_15807 = state_15695;
(statearr_15807[(4)] = cljs.core.cons.call(null,(5),(state_15695[(4)])));

return statearr_15807;
})();
var inst_15345__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_15346__$1 = cljs.core.nth.call(null,inst_15345__$1,(0),null);
var inst_15347 = cljs.core.nth.call(null,inst_15345__$1,(1),null);
var inst_15348 = cljs.core.nth.call(null,inst_15345__$1,(2),null);
var inst_15349 = cljs.core.nth.call(null,inst_15345__$1,(3),null);
var inst_15350 = cljs.core.nth.call(null,inst_15345__$1,(4),null);
var inst_15351 = cljs.core.nth.call(null,inst_15345__$1,(5),null);
var inst_15352__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_15353 = cljs.core.nth.call(null,inst_15352__$1,(0),null);
var inst_15354 = cljs.core.nth.call(null,inst_15352__$1,(1),null);
var inst_15355 = cljs.core.nth.call(null,inst_15352__$1,(2),null);
var inst_15356 = cljs.core.nth.call(null,inst_15352__$1,(3),null);
var inst_15357 = cljs.core.nth.call(null,inst_15352__$1,(4),null);
var inst_15358 = cljs.core.nth.call(null,inst_15352__$1,(5),null);
var inst_15359 = opts;
var inst_15360__$1 = cljs.core.__destructure_map.call(null,inst_15359);
var inst_15361 = cljs.core.get.call(null,inst_15360__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_15362 = cljs.core.get.call(null,inst_15360__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_15363 = cljs.core.get.call(null,inst_15360__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_15364 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_15346__$1);
var state_15695__$1 = (function (){var statearr_15808 = state_15695;
(statearr_15808[(14)] = inst_15361);

(statearr_15808[(84)] = inst_15353);

(statearr_15808[(55)] = inst_15348);

(statearr_15808[(56)] = inst_15363);

(statearr_15808[(18)] = inst_15362);

(statearr_15808[(19)] = inst_15357);

(statearr_15808[(57)] = inst_15354);

(statearr_15808[(58)] = inst_15355);

(statearr_15808[(59)] = inst_15358);

(statearr_15808[(29)] = inst_15360__$1);

(statearr_15808[(31)] = inst_15350);

(statearr_15808[(43)] = inst_15345__$1);

(statearr_15808[(61)] = inst_15351);

(statearr_15808[(49)] = inst_15346__$1);

(statearr_15808[(44)] = inst_15352__$1);

(statearr_15808[(46)] = inst_15356);

(statearr_15808[(62)] = inst_15347);

(statearr_15808[(48)] = inst_15349);

return statearr_15808;
})();
if(inst_15364){
var statearr_15809_15980 = state_15695__$1;
(statearr_15809_15980[(1)] = (6));

} else {
var statearr_15810_15981 = state_15695__$1;
(statearr_15810_15981[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (66))){
var inst_15478 = (state_15695[(71)]);
var inst_15503 = (state_15695[(8)]);
var inst_15511 = cljs.core.PersistentVector.EMPTY;
var inst_15512 = inst_15503;
var inst_15513 = inst_15478;
var inst_15514 = (0);
var inst_15515 = (0);
var inst_15516 = inst_15511;
var state_15695__$1 = (function (){var statearr_15811 = state_15695;
(statearr_15811[(12)] = inst_15512);

(statearr_15811[(22)] = inst_15514);

(statearr_15811[(23)] = inst_15515);

(statearr_15811[(34)] = inst_15513);

(statearr_15811[(35)] = inst_15516);

return statearr_15811;
})();
var statearr_15812_15982 = state_15695__$1;
(statearr_15812_15982[(2)] = null);

(statearr_15812_15982[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (107))){
var inst_15667 = (state_15695[(66)]);
var inst_15667__$1 = (state_15695[(2)]);
var state_15695__$1 = (function (){var statearr_15813 = state_15695;
(statearr_15813[(66)] = inst_15667__$1);

return statearr_15813;
})();
if(cljs.core.truth_(inst_15667__$1)){
var statearr_15814_15983 = state_15695__$1;
(statearr_15814_15983[(1)] = (114));

} else {
var statearr_15815_15984 = state_15695__$1;
(statearr_15815_15984[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (23))){
var inst_15348 = (state_15695[(55)]);
var inst_15363 = (state_15695[(56)]);
var inst_15355 = (state_15695[(58)]);
var inst_15398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15400 = [inst_15348,inst_15355];
var inst_15401 = (new cljs.core.PersistentVector(null,2,(5),inst_15399,inst_15400,null));
var inst_15402 = [inst_15401,inst_15363];
var inst_15403 = (new cljs.core.PersistentVector(null,2,(5),inst_15398,inst_15402,null));
var state_15695__$1 = state_15695;
var statearr_15816_15985 = state_15695__$1;
(statearr_15816_15985[(2)] = inst_15403);

(statearr_15816_15985[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (47))){
var inst_15456 = (cljs.core._GT__EQ_ === start_test);
var state_15695__$1 = state_15695;
if(cljs.core.truth_(inst_15456)){
var statearr_15817_15986 = state_15695__$1;
(statearr_15817_15986[(1)] = (49));

} else {
var statearr_15818_15987 = state_15695__$1;
(statearr_15818_15987[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (35))){
var inst_15436 = (state_15695[(75)]);
var state_15695__$1 = state_15695;
var statearr_15819_15988 = state_15695__$1;
(statearr_15819_15988[(2)] = inst_15436);

(statearr_15819_15988[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (82))){
var inst_15512 = (state_15695[(12)]);
var inst_15483 = (state_15695[(30)]);
var inst_15548 = (state_15695[(2)]);
var inst_15549 = fluree.db.dbproto._rhs.call(null,inst_15512);
var state_15695__$1 = (function (){var statearr_15820 = state_15695;
(statearr_15820[(80)] = inst_15548);

(statearr_15820[(65)] = inst_15549);

return statearr_15820;
})();
if(cljs.core.truth_(inst_15483)){
var statearr_15821_15989 = state_15695__$1;
(statearr_15821_15989[(1)] = (83));

} else {
var statearr_15822_15990 = state_15695__$1;
(statearr_15822_15990[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (76))){
var inst_15362 = (state_15695[(18)]);
var inst_15536 = (state_15695[(2)]);
var state_15695__$1 = (function (){var statearr_15823 = state_15695;
(statearr_15823[(64)] = inst_15536);

return statearr_15823;
})();
if(cljs.core.truth_(inst_15362)){
var statearr_15824_15991 = state_15695__$1;
(statearr_15824_15991[(1)] = (77));

} else {
var statearr_15825_15992 = state_15695__$1;
(statearr_15825_15992[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (97))){
var inst_15516 = (state_15695[(35)]);
var inst_15636 = (state_15695[(2)]);
var inst_15637 = cljs.core.nth.call(null,inst_15636,(0),null);
var inst_15638 = cljs.core.nth.call(null,inst_15636,(1),null);
var inst_15639 = cljs.core.nth.call(null,inst_15636,(2),null);
var inst_15640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15641 = cljs.core.into.call(null,inst_15516,inst_15639);
var inst_15642 = [(0),inst_15637,inst_15638,inst_15641];
var inst_15643 = (new cljs.core.PersistentVector(null,4,(5),inst_15640,inst_15642,null));
var state_15695__$1 = state_15695;
var statearr_15826_15993 = state_15695__$1;
(statearr_15826_15993[(2)] = inst_15643);

(statearr_15826_15993[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (19))){
var inst_15393 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15827_15994 = state_15695__$1;
(statearr_15827_15994[(2)] = inst_15393);

(statearr_15827_15994[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (57))){
var inst_15469 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15828_15995 = state_15695__$1;
(statearr_15828_15995[(2)] = inst_15469);

(statearr_15828_15995[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (68))){
var inst_15690 = (state_15695[(2)]);
var _ = (function (){var statearr_15829 = state_15695;
(statearr_15829[(4)] = cljs.core.rest.call(null,(state_15695[(4)])));

return statearr_15829;
})();
var state_15695__$1 = state_15695;
var statearr_15830_15996 = state_15695__$1;
(statearr_15830_15996[(2)] = inst_15690);

(statearr_15830_15996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (11))){
var inst_15353 = (state_15695[(84)]);
var state_15695__$1 = state_15695;
var statearr_15831_15997 = state_15695__$1;
(statearr_15831_15997[(2)] = inst_15353);

(statearr_15831_15997[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (115))){
var state_15695__$1 = state_15695;
var statearr_15833_15998 = state_15695__$1;
(statearr_15833_15998[(2)] = null);

(statearr_15833_15998[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (9))){
var inst_15368 = (state_15695[(2)]);
var inst_15369 = fluree.db.util.async.throw_err.call(null,inst_15368);
var state_15695__$1 = state_15695;
var statearr_15834_15999 = state_15695__$1;
(statearr_15834_15999[(2)] = inst_15369);

(statearr_15834_15999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (5))){
var _ = (function (){var statearr_15835 = state_15695;
(statearr_15835[(4)] = cljs.core.rest.call(null,(state_15695[(4)])));

return statearr_15835;
})();
var state_15695__$1 = state_15695;
var ex15832 = (state_15695__$1[(2)]);
var statearr_15836_16000 = state_15695__$1;
(statearr_15836_16000[(5)] = ex15832);


if((ex15832 instanceof Error)){
var statearr_15837_16001 = state_15695__$1;
(statearr_15837_16001[(1)] = (4));

(statearr_15837_16001[(5)] = null);

} else {
throw ex15832;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (112))){
var inst_15656 = (state_15695[(79)]);
var state_15695__$1 = state_15695;
var statearr_15838_16002 = state_15695__$1;
(statearr_15838_16002[(2)] = inst_15656);

(statearr_15838_16002[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (83))){
var inst_15551 = (state_15695[(85)]);
var inst_15513 = (state_15695[(34)]);
var inst_15551__$1 = cljs.core._EQ_.call(null,(0),inst_15513);
var state_15695__$1 = (function (){var statearr_15839 = state_15695;
(statearr_15839[(85)] = inst_15551__$1);

return statearr_15839;
})();
if(inst_15551__$1){
var statearr_15840_16003 = state_15695__$1;
(statearr_15840_16003[(1)] = (86));

} else {
var statearr_15841_16004 = state_15695__$1;
(statearr_15841_16004[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (14))){
var inst_15348 = (state_15695[(55)]);
var state_15695__$1 = state_15695;
var statearr_15842_16005 = state_15695__$1;
(statearr_15842_16005[(2)] = inst_15348);

(statearr_15842_16005[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (45))){
var inst_15351 = (state_15695[(61)]);
var inst_15453 = (state_15695[(2)]);
var state_15695__$1 = (function (){var statearr_15843 = state_15695;
(statearr_15843[(10)] = inst_15453);

return statearr_15843;
})();
if(cljs.core.truth_(inst_15351)){
var statearr_15844_16006 = state_15695__$1;
(statearr_15844_16006[(1)] = (46));

} else {
var statearr_15845_16007 = state_15695__$1;
(statearr_15845_16007[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (53))){
var inst_15465 = (cljs.core._LT__EQ_ === end_test);
var state_15695__$1 = state_15695;
if(cljs.core.truth_(inst_15465)){
var statearr_15846_16008 = state_15695__$1;
(statearr_15846_16008[(1)] = (55));

} else {
var statearr_15847_16009 = state_15695__$1;
(statearr_15847_16009[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (78))){
var inst_15536 = (state_15695[(64)]);
var state_15695__$1 = state_15695;
var statearr_15848_16010 = state_15695__$1;
(statearr_15848_16010[(2)] = inst_15536);

(statearr_15848_16010[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (26))){
var inst_15415 = (state_15695[(51)]);
var inst_15420 = fluree.db.dbproto._subid.call(null,db,inst_15415);
var state_15695__$1 = state_15695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15695__$1,(29),inst_15420);
} else {
if((state_val_15696 === (123))){
var inst_15685 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15849_16011 = state_15695__$1;
(statearr_15849_16011[(2)] = inst_15685);

(statearr_15849_16011[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (16))){
var inst_15395 = (state_15695[(60)]);
var inst_15395__$1 = (state_15695[(2)]);
var inst_15396 = (inst_15395__$1 == null);
var state_15695__$1 = (function (){var statearr_15850 = state_15695;
(statearr_15850[(60)] = inst_15395__$1);

return statearr_15850;
})();
if(cljs.core.truth_(inst_15396)){
var statearr_15851_16012 = state_15695__$1;
(statearr_15851_16012[(1)] = (23));

} else {
var statearr_15852_16013 = state_15695__$1;
(statearr_15852_16013[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (81))){
var inst_15542 = (state_15695[(86)]);
var state_15695__$1 = state_15695;
var statearr_15853_16014 = state_15695__$1;
(statearr_15853_16014[(2)] = inst_15542);

(statearr_15853_16014[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (120))){
var inst_15679 = (state_15695[(2)]);
var inst_15680 = cljs.core.not.call(null,inst_15679);
var state_15695__$1 = state_15695;
if(inst_15680){
var statearr_15854_16015 = state_15695__$1;
(statearr_15854_16015[(1)] = (121));

} else {
var statearr_15855_16016 = state_15695__$1;
(statearr_15855_16016[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (79))){
var inst_15417 = (state_15695[(11)]);
var inst_15542 = (state_15695[(2)]);
var state_15695__$1 = (function (){var statearr_15856 = state_15695;
(statearr_15856[(86)] = inst_15542);

return statearr_15856;
})();
if(cljs.core.truth_(inst_15417)){
var statearr_15857_16017 = state_15695__$1;
(statearr_15857_16017[(1)] = (80));

} else {
var statearr_15858_16018 = state_15695__$1;
(statearr_15858_16018[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (38))){
var inst_15347 = (state_15695[(62)]);
var state_15695__$1 = state_15695;
var statearr_15859_16019 = state_15695__$1;
(statearr_15859_16019[(2)] = inst_15347);

(statearr_15859_16019[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (98))){
var inst_15592 = (state_15695[(68)]);
var inst_15590 = (state_15695[(69)]);
var inst_15482 = (state_15695[(45)]);
var inst_15595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15596 = (inst_15590 - inst_15592);
var inst_15597 = [inst_15482,inst_15596];
var inst_15598 = (new cljs.core.PersistentVector(null,2,(5),inst_15595,inst_15597,null));
var state_15695__$1 = state_15695;
var statearr_15860_16020 = state_15695__$1;
(statearr_15860_16020[(2)] = inst_15598);

(statearr_15860_16020[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (87))){
var inst_15551 = (state_15695[(85)]);
var state_15695__$1 = state_15695;
var statearr_15861_16021 = state_15695__$1;
(statearr_15861_16021[(2)] = inst_15551);

(statearr_15861_16021[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (30))){
var inst_15416 = (state_15695[(74)]);
var inst_15429 = fluree.db.dbproto._subid.call(null,db,inst_15416);
var state_15695__$1 = state_15695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15695__$1,(33),inst_15429);
} else {
if((state_val_15696 === (73))){
var inst_15361 = (state_15695[(14)]);
var inst_15530 = (state_15695[(2)]);
var state_15695__$1 = (function (){var statearr_15862 = state_15695;
(statearr_15862[(21)] = inst_15530);

return statearr_15862;
})();
if(cljs.core.truth_(inst_15361)){
var statearr_15863_16022 = state_15695__$1;
(statearr_15863_16022[(1)] = (74));

} else {
var statearr_15864_16023 = state_15695__$1;
(statearr_15864_16023[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (96))){
var inst_15514 = (state_15695[(22)]);
var inst_15515 = (state_15695[(23)]);
var inst_15476 = (state_15695[(33)]);
var inst_15582 = (state_15695[(70)]);
var inst_15482 = (state_15695[(45)]);
var inst_15631 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_15582,inst_15514,inst_15515,inst_15476,inst_15482);
var state_15695__$1 = state_15695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15695__$1,(104),inst_15631);
} else {
if((state_val_15696 === (10))){
var inst_15353 = (state_15695[(84)]);
var inst_15375 = fluree.db.dbproto._subid.call(null,db,inst_15353);
var state_15695__$1 = state_15695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15695__$1,(13),inst_15375);
} else {
if((state_val_15696 === (18))){
var state_15695__$1 = state_15695;
var statearr_15865_16024 = state_15695__$1;
(statearr_15865_16024[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (105))){
var inst_15473 = (state_15695[(13)]);
var inst_15654 = (state_15695[(82)]);
var inst_15488 = (state_15695[(24)]);
var inst_15549 = (state_15695[(65)]);
var inst_15653 = inst_15488.call(null,inst_15549,inst_15473);
var inst_15654__$1 = (inst_15653 < (0));
var state_15695__$1 = (function (){var statearr_15867 = state_15695;
(statearr_15867[(82)] = inst_15654__$1);

return statearr_15867;
})();
if(cljs.core.truth_(inst_15654__$1)){
var statearr_15868_16025 = state_15695__$1;
(statearr_15868_16025[(1)] = (108));

} else {
var statearr_15869_16026 = state_15695__$1;
(statearr_15869_16026[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (52))){
var inst_15358 = (state_15695[(59)]);
var state_15695__$1 = state_15695;
var statearr_15870_16027 = state_15695__$1;
(statearr_15870_16027[(2)] = inst_15358);

(statearr_15870_16027[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (114))){
var inst_15499 = (state_15695[(27)]);
var inst_15493 = (state_15695[(32)]);
var inst_15494 = (state_15695[(40)]);
var inst_15549 = (state_15695[(65)]);
var inst_15489 = (state_15695[(42)]);
var inst_15669 = fluree.db.query.range.find_next_valid_node.call(null,inst_15499,inst_15549,inst_15489,inst_15493,inst_15494);
var state_15695__$1 = state_15695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15695__$1,(117),inst_15669);
} else {
if((state_val_15696 === (67))){
var state_15695__$1 = state_15695;
var statearr_15871_16028 = state_15695__$1;
(statearr_15871_16028[(2)] = null);

(statearr_15871_16028[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (71))){
var inst_15453 = (state_15695[(10)]);
var inst_15417 = (state_15695[(11)]);
var inst_15512 = (state_15695[(12)]);
var inst_15473 = (state_15695[(13)]);
var inst_15361 = (state_15695[(14)]);
var inst_15444 = (state_15695[(15)]);
var inst_15413 = (state_15695[(16)]);
var inst_15475 = (state_15695[(17)]);
var inst_15362 = (state_15695[(18)]);
var inst_15357 = (state_15695[(19)]);
var inst_15522 = (state_15695[(20)]);
var inst_15514 = (state_15695[(22)]);
var inst_15509 = (state_15695[(9)]);
var inst_15515 = (state_15695[(23)]);
var inst_15488 = (state_15695[(24)]);
var inst_15381 = (state_15695[(25)]);
var inst_15484 = (state_15695[(26)]);
var inst_15499 = (state_15695[(27)]);
var inst_15372 = (state_15695[(28)]);
var inst_15360 = (state_15695[(29)]);
var inst_15483 = (state_15695[(30)]);
var inst_15350 = (state_15695[(31)]);
var inst_15493 = (state_15695[(32)]);
var inst_15476 = (state_15695[(33)]);
var inst_15513 = (state_15695[(34)]);
var inst_15516 = (state_15695[(35)]);
var inst_15471 = (state_15695[(36)]);
var inst_15414 = (state_15695[(37)]);
var inst_15462 = (state_15695[(38)]);
var inst_15426 = (state_15695[(39)]);
var inst_15494 = (state_15695[(40)]);
var inst_15472 = (state_15695[(41)]);
var inst_15489 = (state_15695[(42)]);
var inst_15345 = (state_15695[(43)]);
var inst_15503 = (state_15695[(8)]);
var inst_15352 = (state_15695[(44)]);
var inst_15482 = (state_15695[(45)]);
var inst_15356 = (state_15695[(46)]);
var inst_15435 = (state_15695[(47)]);
var inst_15349 = (state_15695[(48)]);
var inst_15526 = (function (){var no_filter_QMARK_ = inst_15509;
var t = inst_15489;
var max_limit_QMARK_ = inst_15483;
var next_node = inst_15512;
var fast_forward_db_QMARK_ = inst_15494;
var G__15523 = inst_15522;
var s1 = inst_15372;
var o2 = inst_15435;
var t1 = inst_15349;
var predicate_fn = inst_15362;
var i = inst_15514;
var m1 = inst_15462;
var root_node = inst_15499;
var s2 = inst_15381;
var p2 = inst_15453;
var permissions = inst_15484;
var limit = inst_15482;
var start_flake = inst_15472;
var flake_limit = inst_15476;
var offset = inst_15513;
var vec__15338 = inst_15413;
var acc = inst_15516;
var t2 = inst_15356;
var op1 = inst_15350;
var o1 = inst_15426;
var end_flake = inst_15473;
var base_result = inst_15522;
var s = inst_15515;
var node_start = inst_15503;
var p1 = inst_15444;
var vec__15334 = inst_15352;
var subject_fn = inst_15361;
var map__15344 = inst_15475;
var object_fn = inst_15417;
var vec__15331 = inst_15345;
var idx_compare = inst_15488;
var map__15337 = inst_15360;
var vec__15341 = inst_15414;
var op2 = inst_15357;
var m2 = inst_15471;
var novelty = inst_15493;
return (function (p1__15312_SHARP_){
return cljs.core._EQ_.call(null,p1__15312_SHARP_.o,start_flake.o);
});
})();
var inst_15527 = cljs.core.filter.call(null,inst_15526,inst_15522);
var state_15695__$1 = state_15695;
var statearr_15872_16029 = state_15695__$1;
(statearr_15872_16029[(2)] = inst_15527);

(statearr_15872_16029[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (42))){
var inst_15449 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
if(cljs.core.truth_(inst_15449)){
var statearr_15873_16030 = state_15695__$1;
(statearr_15873_16030[(1)] = (43));

} else {
var statearr_15874_16031 = state_15695__$1;
(statearr_15874_16031[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (80))){
var inst_15453 = (state_15695[(10)]);
var inst_15417 = (state_15695[(11)]);
var inst_15512 = (state_15695[(12)]);
var inst_15473 = (state_15695[(13)]);
var inst_15361 = (state_15695[(14)]);
var inst_15444 = (state_15695[(15)]);
var inst_15413 = (state_15695[(16)]);
var inst_15475 = (state_15695[(17)]);
var inst_15362 = (state_15695[(18)]);
var inst_15357 = (state_15695[(19)]);
var inst_15522 = (state_15695[(20)]);
var inst_15514 = (state_15695[(22)]);
var inst_15509 = (state_15695[(9)]);
var inst_15515 = (state_15695[(23)]);
var inst_15488 = (state_15695[(24)]);
var inst_15381 = (state_15695[(25)]);
var inst_15484 = (state_15695[(26)]);
var inst_15499 = (state_15695[(27)]);
var inst_15372 = (state_15695[(28)]);
var inst_15542 = (state_15695[(86)]);
var inst_15360 = (state_15695[(29)]);
var inst_15483 = (state_15695[(30)]);
var inst_15350 = (state_15695[(31)]);
var inst_15493 = (state_15695[(32)]);
var inst_15476 = (state_15695[(33)]);
var inst_15513 = (state_15695[(34)]);
var inst_15516 = (state_15695[(35)]);
var inst_15471 = (state_15695[(36)]);
var inst_15414 = (state_15695[(37)]);
var inst_15462 = (state_15695[(38)]);
var inst_15426 = (state_15695[(39)]);
var inst_15494 = (state_15695[(40)]);
var inst_15472 = (state_15695[(41)]);
var inst_15489 = (state_15695[(42)]);
var inst_15345 = (state_15695[(43)]);
var inst_15503 = (state_15695[(8)]);
var inst_15352 = (state_15695[(44)]);
var inst_15482 = (state_15695[(45)]);
var inst_15356 = (state_15695[(46)]);
var inst_15435 = (state_15695[(47)]);
var inst_15349 = (state_15695[(48)]);
var inst_15544 = (function (){var no_filter_QMARK_ = inst_15509;
var t = inst_15489;
var max_limit_QMARK_ = inst_15483;
var next_node = inst_15512;
var fast_forward_db_QMARK_ = inst_15494;
var G__15523 = inst_15542;
var s1 = inst_15372;
var o2 = inst_15435;
var t1 = inst_15349;
var predicate_fn = inst_15362;
var i = inst_15514;
var m1 = inst_15462;
var root_node = inst_15499;
var s2 = inst_15381;
var p2 = inst_15453;
var permissions = inst_15484;
var limit = inst_15482;
var start_flake = inst_15472;
var flake_limit = inst_15476;
var offset = inst_15513;
var vec__15338 = inst_15413;
var acc = inst_15516;
var t2 = inst_15356;
var op1 = inst_15350;
var o1 = inst_15426;
var end_flake = inst_15473;
var base_result = inst_15522;
var s = inst_15515;
var node_start = inst_15503;
var p1 = inst_15444;
var vec__15334 = inst_15352;
var subject_fn = inst_15361;
var map__15344 = inst_15475;
var object_fn = inst_15417;
var vec__15331 = inst_15345;
var idx_compare = inst_15488;
var map__15337 = inst_15360;
var vec__15341 = inst_15414;
var op2 = inst_15357;
var m2 = inst_15471;
var novelty = inst_15493;
return (function (p1__15315_SHARP_){
return object_fn.call(null,p1__15315_SHARP_.o);
});
})();
var inst_15545 = cljs.core.filter.call(null,inst_15544,inst_15542);
var state_15695__$1 = state_15695;
var statearr_15875_16032 = state_15695__$1;
(statearr_15875_16032[(2)] = inst_15545);

(statearr_15875_16032[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (37))){
var state_15695__$1 = state_15695;
var statearr_15876_16033 = state_15695__$1;
(statearr_15876_16033[(2)] = (-1));

(statearr_15876_16033[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (63))){
var inst_15453 = (state_15695[(10)]);
var inst_15444 = (state_15695[(15)]);
var inst_15381 = (state_15695[(25)]);
var inst_15484 = (state_15695[(26)]);
var inst_15372 = (state_15695[(28)]);
var inst_15506 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_15484,inst_15372,inst_15381,inst_15444,inst_15453);
var state_15695__$1 = state_15695;
var statearr_15877_16034 = state_15695__$1;
(statearr_15877_16034[(2)] = inst_15506);

(statearr_15877_16034[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (94))){
var inst_15645 = (state_15695[(2)]);
var state_15695__$1 = state_15695;
var statearr_15878_16035 = state_15695__$1;
(statearr_15878_16035[(2)] = inst_15645);

(statearr_15878_16035[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (8))){
var inst_15353 = (state_15695[(84)]);
var inst_15372 = (state_15695[(2)]);
var inst_15373 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_15353);
var state_15695__$1 = (function (){var statearr_15879 = state_15695;
(statearr_15879[(28)] = inst_15372);

return statearr_15879;
})();
if(inst_15373){
var statearr_15880_16036 = state_15695__$1;
(statearr_15880_16036[(1)] = (10));

} else {
var statearr_15881_16037 = state_15695__$1;
(statearr_15881_16037[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (49))){
var state_15695__$1 = state_15695;
var statearr_15882_16038 = state_15695__$1;
(statearr_15882_16038[(2)] = fluree.db.util.core.min_integer);

(statearr_15882_16038[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15696 === (84))){
var inst_15483 = (state_15695[(30)]);
var state_15695__$1 = state_15695;
var statearr_15883_16039 = state_15695__$1;
(statearr_15883_16039[(2)] = inst_15483);

(statearr_15883_16039[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15884 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15884[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15884[(1)] = (1));

return statearr_15884;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15695){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15885){var ex__2749__auto__ = e15885;
var statearr_15886_16040 = state_15695;
(statearr_15886_16040[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15695[(4)]))){
var statearr_15887_16041 = state_15695;
(statearr_15887_16041[(1)] = cljs.core.first.call(null,(state_15695[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16042 = state_15695;
state_15695 = G__16042;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15695){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15888 = f__2769__auto__.call(null);
(statearr_15888[(6)] = c__2768__auto__);

return statearr_15888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16098){
var state_val_16099 = (state_16098[(1)]);
if((state_val_16099 === (7))){
var inst_16072 = (state_16098[(7)]);
var inst_16062 = (state_16098[(8)]);
var inst_16070 = fluree.db.flake.Flake__GT_parts.call(null,inst_16062);
var inst_16071 = cljs.core.nth.call(null,inst_16070,(0),null);
var inst_16072__$1 = cljs.core.nth.call(null,inst_16070,(1),null);
var inst_16073 = cljs.core.nth.call(null,inst_16070,(2),null);
var inst_16074 = cljs.core.nth.call(null,inst_16070,(3),null);
var inst_16075 = cljs.core.nth.call(null,inst_16070,(4),null);
var inst_16076 = cljs.core.nth.call(null,inst_16070,(5),null);
var inst_16077 = fluree.db.dbproto._tag.call(null,db,inst_16073,inst_16072__$1);
var state_16098__$1 = (function (){var statearr_16100 = state_16098;
(statearr_16100[(7)] = inst_16072__$1);

(statearr_16100[(9)] = inst_16071);

(statearr_16100[(10)] = inst_16076);

(statearr_16100[(11)] = inst_16074);

(statearr_16100[(12)] = inst_16075);

return statearr_16100;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16098__$1,(10),inst_16077);
} else {
if((state_val_16099 === (1))){
var inst_16050 = flakes;
var inst_16051 = cljs.core.seq.call(null,inst_16050);
var inst_16052 = cljs.core.first.call(null,inst_16051);
var inst_16053 = cljs.core.next.call(null,inst_16051);
var inst_16054 = cljs.core.PersistentVector.EMPTY;
var inst_16055 = inst_16050;
var inst_16056 = inst_16054;
var state_16098__$1 = (function (){var statearr_16101 = state_16098;
(statearr_16101[(13)] = inst_16055);

(statearr_16101[(14)] = inst_16053);

(statearr_16101[(15)] = inst_16052);

(statearr_16101[(16)] = inst_16056);

return statearr_16101;
})();
var statearr_16102_16120 = state_16098__$1;
(statearr_16102_16120[(2)] = null);

(statearr_16102_16120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16099 === (4))){
var inst_16062 = (state_16098[(8)]);
var inst_16065 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_16062);
var state_16098__$1 = state_16098;
if(inst_16065){
var statearr_16103_16121 = state_16098__$1;
(statearr_16103_16121[(1)] = (7));

} else {
var statearr_16104_16122 = state_16098__$1;
(statearr_16104_16122[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16099 === (6))){
var inst_16094 = (state_16098[(2)]);
var state_16098__$1 = state_16098;
var statearr_16105_16123 = state_16098__$1;
(statearr_16105_16123[(2)] = inst_16094);

(statearr_16105_16123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16099 === (3))){
var inst_16096 = (state_16098[(2)]);
var state_16098__$1 = state_16098;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16098__$1,inst_16096);
} else {
if((state_val_16099 === (2))){
var inst_16062 = (state_16098[(8)]);
var inst_16055 = (state_16098[(13)]);
var inst_16061 = cljs.core.seq.call(null,inst_16055);
var inst_16062__$1 = cljs.core.first.call(null,inst_16061);
var inst_16063 = cljs.core.next.call(null,inst_16061);
var state_16098__$1 = (function (){var statearr_16106 = state_16098;
(statearr_16106[(8)] = inst_16062__$1);

(statearr_16106[(17)] = inst_16063);

return statearr_16106;
})();
if(cljs.core.truth_(inst_16062__$1)){
var statearr_16107_16124 = state_16098__$1;
(statearr_16107_16124[(1)] = (4));

} else {
var statearr_16108_16125 = state_16098__$1;
(statearr_16108_16125[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16099 === (9))){
var inst_16091 = (state_16098[(2)]);
var state_16098__$1 = state_16098;
var statearr_16109_16126 = state_16098__$1;
(statearr_16109_16126[(2)] = inst_16091);

(statearr_16109_16126[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16099 === (5))){
var inst_16056 = (state_16098[(16)]);
var state_16098__$1 = state_16098;
var statearr_16110_16127 = state_16098__$1;
(statearr_16110_16127[(2)] = inst_16056);

(statearr_16110_16127[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16099 === (10))){
var inst_16072 = (state_16098[(7)]);
var inst_16071 = (state_16098[(9)]);
var inst_16076 = (state_16098[(10)]);
var inst_16074 = (state_16098[(11)]);
var inst_16075 = (state_16098[(12)]);
var inst_16063 = (state_16098[(17)]);
var inst_16056 = (state_16098[(16)]);
var inst_16079 = (state_16098[(2)]);
var inst_16080 = fluree.db.util.async.throw_err.call(null,inst_16079);
var inst_16081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16082 = [inst_16071,inst_16072,inst_16080,inst_16074,inst_16075,inst_16076];
var inst_16083 = (new cljs.core.PersistentVector(null,6,(5),inst_16081,inst_16082,null));
var inst_16084 = fluree.db.flake.parts__GT_Flake.call(null,inst_16083);
var inst_16085 = cljs.core.conj.call(null,inst_16056,inst_16084);
var inst_16055 = inst_16063;
var inst_16056__$1 = inst_16085;
var state_16098__$1 = (function (){var statearr_16111 = state_16098;
(statearr_16111[(13)] = inst_16055);

(statearr_16111[(16)] = inst_16056__$1);

return statearr_16111;
})();
var statearr_16112_16128 = state_16098__$1;
(statearr_16112_16128[(2)] = null);

(statearr_16112_16128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16099 === (8))){
var inst_16062 = (state_16098[(8)]);
var inst_16063 = (state_16098[(17)]);
var inst_16056 = (state_16098[(16)]);
var inst_16088 = cljs.core.conj.call(null,inst_16056,inst_16062);
var inst_16055 = inst_16063;
var inst_16056__$1 = inst_16088;
var state_16098__$1 = (function (){var statearr_16113 = state_16098;
(statearr_16113[(13)] = inst_16055);

(statearr_16113[(16)] = inst_16056__$1);

return statearr_16113;
})();
var statearr_16114_16129 = state_16098__$1;
(statearr_16114_16129[(2)] = null);

(statearr_16114_16129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0 = (function (){
var statearr_16115 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16115[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__);

(statearr_16115[(1)] = (1));

return statearr_16115;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1 = (function (state_16098){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16116){var ex__2749__auto__ = e16116;
var statearr_16117_16130 = state_16098;
(statearr_16117_16130[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16098[(4)]))){
var statearr_16118_16131 = state_16098;
(statearr_16118_16131[(1)] = cljs.core.first.call(null,(state_16098[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16132 = state_16098;
state_16098 = G__16132;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__ = function(state_16098){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1.call(this,state_16098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16119 = f__2769__auto__.call(null);
(statearr_16119[(6)] = c__2768__auto__);

return statearr_16119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__16134 = arguments.length;
switch (G__16134) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16304){
var state_val_16305 = (state_16304[(1)]);
if((state_val_16305 === (65))){
var state_16304__$1 = state_16304;
var statearr_16306_16406 = state_16304__$1;
(statearr_16306_16406[(2)] = null);

(statearr_16306_16406[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (70))){
var inst_16299 = (state_16304[(2)]);
var _ = (function (){var statearr_16307 = state_16304;
(statearr_16307[(4)] = cljs.core.rest.call(null,(state_16304[(4)])));

return statearr_16307;
})();
var state_16304__$1 = state_16304;
var statearr_16308_16407 = state_16304__$1;
(statearr_16308_16407[(2)] = inst_16299);

(statearr_16308_16407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (62))){
var inst_16285 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16309_16408 = state_16304__$1;
(statearr_16309_16408[(2)] = inst_16285);

(statearr_16309_16408[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (7))){
var state_16304__$1 = state_16304;
var statearr_16310_16409 = state_16304__$1;
(statearr_16310_16409[(2)] = false);

(statearr_16310_16409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (59))){
var inst_16259 = (state_16304[(2)]);
var inst_16260 = fluree.db.util.async.throw_err.call(null,inst_16259);
var state_16304__$1 = state_16304;
var statearr_16311_16410 = state_16304__$1;
(statearr_16311_16410[(2)] = inst_16260);

(statearr_16311_16410[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (20))){
var state_16304__$1 = state_16304;
var statearr_16312_16411 = state_16304__$1;
(statearr_16312_16411[(2)] = null);

(statearr_16312_16411[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (58))){
var inst_16249 = (state_16304[(2)]);
var inst_16250 = fluree.db.util.async.throw_err.call(null,inst_16249);
var inst_16251 = cljs.core.take.call(null,(1),inst_16250);
var state_16304__$1 = state_16304;
var statearr_16313_16412 = state_16304__$1;
(statearr_16313_16412[(2)] = inst_16251);

(statearr_16313_16412[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (60))){
var inst_16146 = (state_16304[(7)]);
var inst_16148 = (state_16304[(8)]);
var inst_16145 = (state_16304[(9)]);
var inst_16185 = (state_16304[(10)]);
var inst_16265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16266 = [inst_16146,inst_16145,inst_16185,inst_16148];
var inst_16267 = (new cljs.core.PersistentVector(null,4,(5),inst_16265,inst_16266,null));
var inst_16268 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16267,opts);
var state_16304__$1 = state_16304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16304__$1,(63),inst_16268);
} else {
if((state_val_16305 === (27))){
var inst_16196 = (state_16304[(11)]);
var inst_16185 = (state_16304[(10)]);
var inst_16196__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_16185);
var state_16304__$1 = (function (){var statearr_16314 = state_16304;
(statearr_16314[(11)] = inst_16196__$1);

return statearr_16314;
})();
if(inst_16196__$1){
var statearr_16315_16413 = state_16304__$1;
(statearr_16315_16413[(1)] = (30));

} else {
var statearr_16316_16414 = state_16304__$1;
(statearr_16316_16414[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (1))){
var state_16304__$1 = state_16304;
var statearr_16317_16415 = state_16304__$1;
(statearr_16317_16415[(2)] = null);

(statearr_16317_16415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (69))){
var inst_16291 = (state_16304[(12)]);
var state_16304__$1 = state_16304;
var statearr_16318_16416 = state_16304__$1;
(statearr_16318_16416[(2)] = inst_16291);

(statearr_16318_16416[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (24))){
var inst_16146 = (state_16304[(7)]);
var state_16304__$1 = state_16304;
if(cljs.core.truth_(inst_16146)){
var statearr_16319_16417 = state_16304__$1;
(statearr_16319_16417[(1)] = (27));

} else {
var statearr_16320_16418 = state_16304__$1;
(statearr_16320_16418[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (55))){
var inst_16185 = (state_16304[(10)]);
var inst_16243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16244 = [inst_16185];
var inst_16245 = (new cljs.core.PersistentVector(null,1,(5),inst_16243,inst_16244,null));
var inst_16246 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_16247 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16245,inst_16246);
var state_16304__$1 = state_16304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16304__$1,(58),inst_16247);
} else {
if((state_val_16305 === (39))){
var inst_16216 = (state_16304[(2)]);
var inst_16217 = fluree.db.util.async.throw_err.call(null,inst_16216);
var state_16304__$1 = state_16304;
var statearr_16321_16419 = state_16304__$1;
(statearr_16321_16419[(2)] = inst_16217);

(statearr_16321_16419[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (46))){
var inst_16229 = (state_16304[(13)]);
var inst_16229__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_16304__$1 = (function (){var statearr_16322 = state_16304;
(statearr_16322[(13)] = inst_16229__$1);

return statearr_16322;
})();
if(cljs.core.truth_(inst_16229__$1)){
var statearr_16323_16420 = state_16304__$1;
(statearr_16323_16420[(1)] = (49));

} else {
var statearr_16324_16421 = state_16304__$1;
(statearr_16324_16421[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (4))){
var inst_16135 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16325_16422 = state_16304__$1;
(statearr_16325_16422[(2)] = inst_16135);

(statearr_16325_16422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (54))){
var inst_16241 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
if(cljs.core.truth_(inst_16241)){
var statearr_16326_16423 = state_16304__$1;
(statearr_16326_16423[(1)] = (55));

} else {
var statearr_16327_16424 = state_16304__$1;
(statearr_16327_16424[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (15))){
var inst_16147 = (state_16304[(14)]);
var inst_16166 = fluree.db.dbproto._tag_id.call(null,db,inst_16147);
var state_16304__$1 = state_16304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16304__$1,(18),inst_16166);
} else {
if((state_val_16305 === (48))){
var inst_16287 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16328_16425 = state_16304__$1;
(statearr_16328_16425[(2)] = inst_16287);

(statearr_16328_16425[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (50))){
var inst_16155 = (state_16304[(15)]);
var inst_16146 = (state_16304[(7)]);
var inst_16229 = (state_16304[(13)]);
var inst_16149 = (state_16304[(16)]);
var inst_16148 = (state_16304[(8)]);
var inst_16160 = (state_16304[(17)]);
var inst_16145 = (state_16304[(9)]);
var inst_16144 = (state_16304[(18)]);
var inst_16185 = (state_16304[(10)]);
var inst_16233 = (function (){var t = inst_16148;
var temp__5802__auto__ = inst_16229;
var p = inst_16146;
var idx_predicate_QMARK_ = inst_16149;
var vec__16141 = inst_16144;
var o = inst_16185;
var tag_predicate_QMARK_ = inst_16155;
var s = inst_16145;
var o_coerce_QMARK_ = inst_16160;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_16304__$1 = state_16304;
var statearr_16329_16426 = state_16304__$1;
(statearr_16329_16426[(2)] = inst_16233);

(statearr_16329_16426[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (21))){
var inst_16181 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16330_16427 = state_16304__$1;
(statearr_16330_16427[(2)] = inst_16181);

(statearr_16330_16427[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (31))){
var inst_16196 = (state_16304[(11)]);
var state_16304__$1 = state_16304;
var statearr_16331_16428 = state_16304__$1;
(statearr_16331_16428[(2)] = inst_16196);

(statearr_16331_16428[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (32))){
var inst_16206 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16332_16429 = state_16304__$1;
(statearr_16332_16429[(2)] = inst_16206);

(statearr_16332_16429[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (40))){
var inst_16220 = (state_16304[(19)]);
var inst_16149 = (state_16304[(16)]);
var inst_16220__$1 = cljs.core.not.call(null,inst_16149);
var state_16304__$1 = (function (){var statearr_16333 = state_16304;
(statearr_16333[(19)] = inst_16220__$1);

return statearr_16333;
})();
if(inst_16220__$1){
var statearr_16334_16430 = state_16304__$1;
(statearr_16334_16430[(1)] = (43));

} else {
var statearr_16335_16431 = state_16304__$1;
(statearr_16335_16431[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (56))){
var inst_16146 = (state_16304[(7)]);
var inst_16148 = (state_16304[(8)]);
var inst_16145 = (state_16304[(9)]);
var inst_16235 = (state_16304[(20)]);
var inst_16253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16254 = [inst_16146,inst_16145,null,inst_16148];
var inst_16255 = (new cljs.core.PersistentVector(null,4,(5),inst_16253,inst_16254,null));
var inst_16256 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_16235);
var inst_16257 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16255,inst_16256);
var state_16304__$1 = state_16304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16304__$1,(59),inst_16257);
} else {
if((state_val_16305 === (33))){
var inst_16185 = (state_16304[(10)]);
var inst_16199 = cljs.core.fn_QMARK_.call(null,inst_16185);
var inst_16200 = (!(inst_16199));
var state_16304__$1 = state_16304;
var statearr_16336_16432 = state_16304__$1;
(statearr_16336_16432[(2)] = inst_16200);

(statearr_16336_16432[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (13))){
var inst_16147 = (state_16304[(14)]);
var inst_16164 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_16147);
var state_16304__$1 = state_16304;
if(cljs.core.truth_(inst_16164)){
var statearr_16337_16433 = state_16304__$1;
(statearr_16337_16433[(1)] = (15));

} else {
var statearr_16338_16434 = state_16304__$1;
(statearr_16338_16434[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (22))){
var inst_16177 = (state_16304[(2)]);
var inst_16178 = fluree.db.util.async.throw_err.call(null,inst_16177);
var state_16304__$1 = state_16304;
var statearr_16339_16435 = state_16304__$1;
(statearr_16339_16435[(2)] = inst_16178);

(statearr_16339_16435[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (36))){
var inst_16146 = (state_16304[(7)]);
var inst_16148 = (state_16304[(8)]);
var inst_16145 = (state_16304[(9)]);
var inst_16185 = (state_16304[(10)]);
var inst_16211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16212 = [inst_16146,inst_16185,inst_16145,inst_16148];
var inst_16213 = (new cljs.core.PersistentVector(null,4,(5),inst_16211,inst_16212,null));
var inst_16214 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_16213,opts);
var state_16304__$1 = state_16304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16304__$1,(39),inst_16214);
} else {
if((state_val_16305 === (41))){
var inst_16146 = (state_16304[(7)]);
var state_16304__$1 = state_16304;
var statearr_16340_16436 = state_16304__$1;
(statearr_16340_16436[(2)] = inst_16146);

(statearr_16340_16436[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (43))){
var inst_16185 = (state_16304[(10)]);
var state_16304__$1 = state_16304;
var statearr_16341_16437 = state_16304__$1;
(statearr_16341_16437[(2)] = inst_16185);

(statearr_16341_16437[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (61))){
var inst_16185 = (state_16304[(10)]);
var state_16304__$1 = state_16304;
if(cljs.core.truth_(inst_16185)){
var statearr_16342_16438 = state_16304__$1;
(statearr_16342_16438[(1)] = (64));

} else {
var statearr_16343_16439 = state_16304__$1;
(statearr_16343_16439[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (29))){
var inst_16209 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
if(cljs.core.truth_(inst_16209)){
var statearr_16344_16440 = state_16304__$1;
(statearr_16344_16440[(1)] = (36));

} else {
var statearr_16345_16441 = state_16304__$1;
(statearr_16345_16441[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (44))){
var inst_16220 = (state_16304[(19)]);
var state_16304__$1 = state_16304;
var statearr_16346_16442 = state_16304__$1;
(statearr_16346_16442[(2)] = inst_16220);

(statearr_16346_16442[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (6))){
var inst_16146 = (state_16304[(7)]);
var inst_16151 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_16146);
var inst_16152 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_16151);
var state_16304__$1 = state_16304;
var statearr_16347_16443 = state_16304__$1;
(statearr_16347_16443[(2)] = inst_16152);

(statearr_16347_16443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (28))){
var inst_16146 = (state_16304[(7)]);
var state_16304__$1 = state_16304;
var statearr_16348_16444 = state_16304__$1;
(statearr_16348_16444[(2)] = inst_16146);

(statearr_16348_16444[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (64))){
var inst_16146 = (state_16304[(7)]);
var inst_16148 = (state_16304[(8)]);
var inst_16145 = (state_16304[(9)]);
var inst_16185 = (state_16304[(10)]);
var inst_16274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16275 = [inst_16185,inst_16146,inst_16145,inst_16148];
var inst_16276 = (new cljs.core.PersistentVector(null,4,(5),inst_16274,inst_16275,null));
var inst_16277 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_16276,opts);
var state_16304__$1 = state_16304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16304__$1,(67),inst_16277);
} else {
if((state_val_16305 === (51))){
var inst_16146 = (state_16304[(7)]);
var inst_16236 = (state_16304[(21)]);
var inst_16235 = (state_16304[(2)]);
var inst_16236__$1 = cljs.core._EQ_.call(null,"_id",inst_16146);
var state_16304__$1 = (function (){var statearr_16349 = state_16304;
(statearr_16349[(20)] = inst_16235);

(statearr_16349[(21)] = inst_16236__$1);

return statearr_16349;
})();
if(inst_16236__$1){
var statearr_16350_16445 = state_16304__$1;
(statearr_16350_16445[(1)] = (52));

} else {
var statearr_16351_16446 = state_16304__$1;
(statearr_16351_16446[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (25))){
var inst_16155 = (state_16304[(15)]);
var inst_16291 = (state_16304[(2)]);
var state_16304__$1 = (function (){var statearr_16352 = state_16304;
(statearr_16352[(12)] = inst_16291);

return statearr_16352;
})();
if(cljs.core.truth_(inst_16155)){
var statearr_16353_16447 = state_16304__$1;
(statearr_16353_16447[(1)] = (68));

} else {
var statearr_16354_16448 = state_16304__$1;
(statearr_16354_16448[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (34))){
var inst_16149 = (state_16304[(16)]);
var state_16304__$1 = state_16304;
var statearr_16355_16449 = state_16304__$1;
(statearr_16355_16449[(2)] = inst_16149);

(statearr_16355_16449[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (17))){
var inst_16183 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16356_16450 = state_16304__$1;
(statearr_16356_16450[(2)] = inst_16183);

(statearr_16356_16450[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (3))){
var inst_16302 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16304__$1,inst_16302);
} else {
if((state_val_16305 === (12))){
var inst_16147 = (state_16304[(14)]);
var state_16304__$1 = state_16304;
var statearr_16357_16451 = state_16304__$1;
(statearr_16357_16451[(2)] = inst_16147);

(statearr_16357_16451[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (2))){
var inst_16146 = (state_16304[(7)]);
var inst_16144 = (state_16304[(18)]);
var _ = (function (){var statearr_16358 = state_16304;
(statearr_16358[(4)] = cljs.core.cons.call(null,(5),(state_16304[(4)])));

return statearr_16358;
})();
var inst_16144__$1 = fparts;
var inst_16145 = cljs.core.nth.call(null,inst_16144__$1,(0),null);
var inst_16146__$1 = cljs.core.nth.call(null,inst_16144__$1,(1),null);
var inst_16147 = cljs.core.nth.call(null,inst_16144__$1,(2),null);
var inst_16148 = cljs.core.nth.call(null,inst_16144__$1,(3),null);
var inst_16149 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_16146__$1);
var state_16304__$1 = (function (){var statearr_16359 = state_16304;
(statearr_16359[(7)] = inst_16146__$1);

(statearr_16359[(16)] = inst_16149);

(statearr_16359[(8)] = inst_16148);

(statearr_16359[(9)] = inst_16145);

(statearr_16359[(18)] = inst_16144__$1);

(statearr_16359[(14)] = inst_16147);

return statearr_16359;
})();
if(cljs.core.truth_(inst_16146__$1)){
var statearr_16360_16452 = state_16304__$1;
(statearr_16360_16452[(1)] = (6));

} else {
var statearr_16361_16453 = state_16304__$1;
(statearr_16361_16453[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (66))){
var inst_16283 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16362_16454 = state_16304__$1;
(statearr_16362_16454[(2)] = inst_16283);

(statearr_16362_16454[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (23))){
var inst_16146 = (state_16304[(7)]);
var inst_16148 = (state_16304[(8)]);
var inst_16145 = (state_16304[(9)]);
var inst_16185 = (state_16304[(10)]);
var inst_16187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16188 = [inst_16145,inst_16146,inst_16185,inst_16148];
var inst_16189 = (new cljs.core.PersistentVector(null,4,(5),inst_16187,inst_16188,null));
var inst_16190 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16189,opts);
var state_16304__$1 = state_16304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16304__$1,(26),inst_16190);
} else {
if((state_val_16305 === (47))){
var inst_16146 = (state_16304[(7)]);
var state_16304__$1 = state_16304;
if(cljs.core.truth_(inst_16146)){
var statearr_16363_16455 = state_16304__$1;
(statearr_16363_16455[(1)] = (60));

} else {
var statearr_16364_16456 = state_16304__$1;
(statearr_16364_16456[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (35))){
var inst_16203 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16365_16457 = state_16304__$1;
(statearr_16365_16457[(2)] = inst_16203);

(statearr_16365_16457[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (19))){
var inst_16146 = (state_16304[(7)]);
var inst_16147 = (state_16304[(14)]);
var inst_16173 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16146);
var inst_16174 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16173),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16147)].join('');
var inst_16175 = fluree.db.dbproto._tag_id.call(null,db,inst_16174);
var state_16304__$1 = state_16304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16304__$1,(22),inst_16175);
} else {
if((state_val_16305 === (57))){
var inst_16262 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16366_16458 = state_16304__$1;
(statearr_16366_16458[(2)] = inst_16262);

(statearr_16366_16458[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (68))){
var inst_16291 = (state_16304[(12)]);
var inst_16293 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_16291);
var state_16304__$1 = state_16304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16304__$1,(71),inst_16293);
} else {
if((state_val_16305 === (11))){
var inst_16160 = (state_16304[(17)]);
var inst_16160__$1 = (state_16304[(2)]);
var inst_16161 = cljs.core.not.call(null,inst_16160__$1);
var state_16304__$1 = (function (){var statearr_16368 = state_16304;
(statearr_16368[(17)] = inst_16160__$1);

return statearr_16368;
})();
if(inst_16161){
var statearr_16369_16459 = state_16304__$1;
(statearr_16369_16459[(1)] = (12));

} else {
var statearr_16370_16460 = state_16304__$1;
(statearr_16370_16460[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (9))){
var inst_16147 = (state_16304[(14)]);
var inst_16157 = typeof inst_16147 === 'string';
var state_16304__$1 = state_16304;
var statearr_16371_16461 = state_16304__$1;
(statearr_16371_16461[(2)] = inst_16157);

(statearr_16371_16461[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (5))){
var _ = (function (){var statearr_16372 = state_16304;
(statearr_16372[(4)] = cljs.core.rest.call(null,(state_16304[(4)])));

return statearr_16372;
})();
var state_16304__$1 = state_16304;
var ex16367 = (state_16304__$1[(2)]);
var statearr_16373_16462 = state_16304__$1;
(statearr_16373_16462[(5)] = ex16367);


if((ex16367 instanceof Error)){
var statearr_16374_16463 = state_16304__$1;
(statearr_16374_16463[(1)] = (4));

(statearr_16374_16463[(5)] = null);

} else {
throw ex16367;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (14))){
var inst_16145 = (state_16304[(9)]);
var inst_16185 = (state_16304[(2)]);
var state_16304__$1 = (function (){var statearr_16375 = state_16304;
(statearr_16375[(10)] = inst_16185);

return statearr_16375;
})();
if(cljs.core.truth_(inst_16145)){
var statearr_16376_16464 = state_16304__$1;
(statearr_16376_16464[(1)] = (23));

} else {
var statearr_16377_16465 = state_16304__$1;
(statearr_16377_16465[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (45))){
var inst_16224 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16378_16466 = state_16304__$1;
(statearr_16378_16466[(2)] = inst_16224);

(statearr_16378_16466[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (53))){
var inst_16236 = (state_16304[(21)]);
var state_16304__$1 = state_16304;
var statearr_16379_16467 = state_16304__$1;
(statearr_16379_16467[(2)] = inst_16236);

(statearr_16379_16467[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (26))){
var inst_16192 = (state_16304[(2)]);
var inst_16193 = fluree.db.util.async.throw_err.call(null,inst_16192);
var state_16304__$1 = state_16304;
var statearr_16380_16468 = state_16304__$1;
(statearr_16380_16468[(2)] = inst_16193);

(statearr_16380_16468[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (16))){
var inst_16147 = (state_16304[(14)]);
var inst_16171 = typeof inst_16147 === 'string';
var state_16304__$1 = state_16304;
if(cljs.core.truth_(inst_16171)){
var statearr_16381_16469 = state_16304__$1;
(statearr_16381_16469[(1)] = (19));

} else {
var statearr_16382_16470 = state_16304__$1;
(statearr_16382_16470[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (38))){
var inst_16289 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
var statearr_16383_16471 = state_16304__$1;
(statearr_16383_16471[(2)] = inst_16289);

(statearr_16383_16471[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (30))){
var inst_16149 = (state_16304[(16)]);
var state_16304__$1 = state_16304;
if(cljs.core.truth_(inst_16149)){
var statearr_16384_16472 = state_16304__$1;
(statearr_16384_16472[(1)] = (33));

} else {
var statearr_16385_16473 = state_16304__$1;
(statearr_16385_16473[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (10))){
var inst_16155 = (state_16304[(15)]);
var state_16304__$1 = state_16304;
var statearr_16386_16474 = state_16304__$1;
(statearr_16386_16474[(2)] = inst_16155);

(statearr_16386_16474[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (18))){
var inst_16168 = (state_16304[(2)]);
var inst_16169 = fluree.db.util.async.throw_err.call(null,inst_16168);
var state_16304__$1 = state_16304;
var statearr_16387_16475 = state_16304__$1;
(statearr_16387_16475[(2)] = inst_16169);

(statearr_16387_16475[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (52))){
var inst_16185 = (state_16304[(10)]);
var inst_16238 = cljs.core.int_QMARK_.call(null,inst_16185);
var state_16304__$1 = state_16304;
var statearr_16388_16476 = state_16304__$1;
(statearr_16388_16476[(2)] = inst_16238);

(statearr_16388_16476[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (67))){
var inst_16279 = (state_16304[(2)]);
var inst_16280 = fluree.db.util.async.throw_err.call(null,inst_16279);
var state_16304__$1 = state_16304;
var statearr_16389_16477 = state_16304__$1;
(statearr_16389_16477[(2)] = inst_16280);

(statearr_16389_16477[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (71))){
var inst_16295 = (state_16304[(2)]);
var inst_16296 = fluree.db.util.async.throw_err.call(null,inst_16295);
var state_16304__$1 = state_16304;
var statearr_16390_16478 = state_16304__$1;
(statearr_16390_16478[(2)] = inst_16296);

(statearr_16390_16478[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (42))){
var inst_16227 = (state_16304[(2)]);
var state_16304__$1 = state_16304;
if(cljs.core.truth_(inst_16227)){
var statearr_16391_16479 = state_16304__$1;
(statearr_16391_16479[(1)] = (46));

} else {
var statearr_16392_16480 = state_16304__$1;
(statearr_16392_16480[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (37))){
var inst_16146 = (state_16304[(7)]);
var state_16304__$1 = state_16304;
if(cljs.core.truth_(inst_16146)){
var statearr_16393_16481 = state_16304__$1;
(statearr_16393_16481[(1)] = (40));

} else {
var statearr_16394_16482 = state_16304__$1;
(statearr_16394_16482[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (63))){
var inst_16270 = (state_16304[(2)]);
var inst_16271 = fluree.db.util.async.throw_err.call(null,inst_16270);
var state_16304__$1 = state_16304;
var statearr_16395_16483 = state_16304__$1;
(statearr_16395_16483[(2)] = inst_16271);

(statearr_16395_16483[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (8))){
var inst_16155 = (state_16304[(15)]);
var inst_16155__$1 = (state_16304[(2)]);
var state_16304__$1 = (function (){var statearr_16396 = state_16304;
(statearr_16396[(15)] = inst_16155__$1);

return statearr_16396;
})();
if(cljs.core.truth_(inst_16155__$1)){
var statearr_16397_16484 = state_16304__$1;
(statearr_16397_16484[(1)] = (9));

} else {
var statearr_16398_16485 = state_16304__$1;
(statearr_16398_16485[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16305 === (49))){
var inst_16155 = (state_16304[(15)]);
var inst_16146 = (state_16304[(7)]);
var inst_16229 = (state_16304[(13)]);
var inst_16149 = (state_16304[(16)]);
var inst_16148 = (state_16304[(8)]);
var inst_16160 = (state_16304[(17)]);
var inst_16145 = (state_16304[(9)]);
var inst_16144 = (state_16304[(18)]);
var inst_16185 = (state_16304[(10)]);
var inst_16231 = (function (){var obj_fn = inst_16229;
var t = inst_16148;
var temp__5802__auto__ = inst_16229;
var p = inst_16146;
var idx_predicate_QMARK_ = inst_16149;
var vec__16141 = inst_16144;
var o = inst_16185;
var tag_predicate_QMARK_ = inst_16155;
var s = inst_16145;
var o_coerce_QMARK_ = inst_16160;
return (function (x){
var and__5043__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_16304__$1 = state_16304;
var statearr_16399_16486 = state_16304__$1;
(statearr_16399_16486[(2)] = inst_16231);

(statearr_16399_16486[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_16400 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16400[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_16400[(1)] = (1));

return statearr_16400;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_16304){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16304);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16401){var ex__2749__auto__ = e16401;
var statearr_16402_16487 = state_16304;
(statearr_16402_16487[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16304[(4)]))){
var statearr_16403_16488 = state_16304;
(statearr_16403_16488[(1)] = cljs.core.first.call(null,(state_16304[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16489 = state_16304;
state_16304 = G__16489;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_16304){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_16304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16404 = f__2769__auto__.call(null);
(statearr_16404[(6)] = c__2768__auto__);

return statearr_16404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__16491 = arguments.length;
switch (G__16491) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16526){
var state_val_16527 = (state_16526[(1)]);
if((state_val_16527 === (7))){
var inst_16513 = cljs.core.pr_str.call(null,name);
var inst_16514 = ["Invalid collection name: ",inst_16513].join('');
var inst_16515 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16516 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_16517 = cljs.core.PersistentHashMap.fromArrays(inst_16515,inst_16516);
var inst_16518 = cljs.core.ex_info.call(null,inst_16514,inst_16517);
var inst_16519 = (function(){throw inst_16518})();
var state_16526__$1 = state_16526;
var statearr_16528_16548 = state_16526__$1;
(statearr_16528_16548[(2)] = inst_16519);

(statearr_16528_16548[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (1))){
var state_16526__$1 = state_16526;
var statearr_16529_16549 = state_16526__$1;
(statearr_16529_16549[(2)] = null);

(statearr_16529_16549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (4))){
var inst_16492 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
var statearr_16530_16550 = state_16526__$1;
(statearr_16530_16550[(2)] = inst_16492);

(statearr_16530_16550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (6))){
var inst_16498 = (state_16526[(7)]);
var inst_16500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16501 = fluree.db.flake.max_subject_id.call(null,inst_16498);
var inst_16502 = [inst_16501];
var inst_16503 = (new cljs.core.PersistentVector(null,1,(5),inst_16500,inst_16502,null));
var inst_16504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16505 = fluree.db.flake.min_subject_id.call(null,inst_16498);
var inst_16506 = [inst_16505];
var inst_16507 = (new cljs.core.PersistentVector(null,1,(5),inst_16504,inst_16506,null));
var inst_16508 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16503,cljs.core._LT__EQ_,inst_16507,opts);
var state_16526__$1 = state_16526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16526__$1,(9),inst_16508);
} else {
if((state_val_16527 === (3))){
var inst_16524 = (state_16526[(2)]);
var state_16526__$1 = state_16526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16526__$1,inst_16524);
} else {
if((state_val_16527 === (2))){
var inst_16498 = (state_16526[(7)]);
var _ = (function (){var statearr_16532 = state_16526;
(statearr_16532[(4)] = cljs.core.cons.call(null,(5),(state_16526[(4)])));

return statearr_16532;
})();
var inst_16498__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_16526__$1 = (function (){var statearr_16533 = state_16526;
(statearr_16533[(7)] = inst_16498__$1);

return statearr_16533;
})();
if(cljs.core.truth_(inst_16498__$1)){
var statearr_16534_16551 = state_16526__$1;
(statearr_16534_16551[(1)] = (6));

} else {
var statearr_16535_16552 = state_16526__$1;
(statearr_16535_16552[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (9))){
var inst_16510 = (state_16526[(2)]);
var inst_16511 = fluree.db.util.async.throw_err.call(null,inst_16510);
var state_16526__$1 = state_16526;
var statearr_16536_16553 = state_16526__$1;
(statearr_16536_16553[(2)] = inst_16511);

(statearr_16536_16553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (5))){
var _ = (function (){var statearr_16537 = state_16526;
(statearr_16537[(4)] = cljs.core.rest.call(null,(state_16526[(4)])));

return statearr_16537;
})();
var state_16526__$1 = state_16526;
var ex16531 = (state_16526__$1[(2)]);
var statearr_16538_16554 = state_16526__$1;
(statearr_16538_16554[(5)] = ex16531);


var statearr_16539_16555 = state_16526__$1;
(statearr_16539_16555[(1)] = (4));

(statearr_16539_16555[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16527 === (8))){
var inst_16521 = (state_16526[(2)]);
var _ = (function (){var statearr_16540 = state_16526;
(statearr_16540[(4)] = cljs.core.rest.call(null,(state_16526[(4)])));

return statearr_16540;
})();
var state_16526__$1 = state_16526;
var statearr_16541_16556 = state_16526__$1;
(statearr_16541_16556[(2)] = inst_16521);

(statearr_16541_16556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_16542 = [null,null,null,null,null,null,null,null];
(statearr_16542[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_16542[(1)] = (1));

return statearr_16542;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_16526){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16543){var ex__2749__auto__ = e16543;
var statearr_16544_16557 = state_16526;
(statearr_16544_16557[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16526[(4)]))){
var statearr_16545_16558 = state_16526;
(statearr_16545_16558[(1)] = cljs.core.first.call(null,(state_16526[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16559 = state_16526;
state_16526 = G__16559;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_16526){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_16526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16546 = f__2769__auto__.call(null);
(statearr_16546[(6)] = c__2768__auto__);

return statearr_16546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__16563 = flakes;
var vec__16564 = G__16563;
var seq__16565 = cljs.core.seq.call(null,vec__16564);
var first__16566 = cljs.core.first.call(null,seq__16565);
var seq__16565__$1 = cljs.core.next.call(null,seq__16565);
var flake_SINGLEQUOTE_ = first__16566;
var r = seq__16565__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16563__$1 = G__16563;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16572 = G__16563__$1;
var seq__16573 = cljs.core.seq.call(null,vec__16572);
var first__16574 = cljs.core.first.call(null,seq__16573);
var seq__16573__$1 = cljs.core.next.call(null,seq__16573);
var flake_SINGLEQUOTE___$1 = first__16574;
var r__$1 = seq__16573__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e16576){var e = e16576;
return null;
}})();
var map__16575 = cmd_map;
var map__16575__$1 = cljs.core.__destructure_map.call(null,map__16575);
var type = cljs.core.get.call(null,map__16575__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__16575__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__16575__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__16575__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__16575__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__16575__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__16577 = r__$1;
var G__16578 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__16563__$1 = G__16577;
result_STAR___$1 = G__16578;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__16587 = blocks;
var vec__16588 = G__16587;
var seq__16589 = cljs.core.seq.call(null,vec__16588);
var first__16590 = cljs.core.first.call(null,seq__16589);
var seq__16589__$1 = cljs.core.next.call(null,seq__16589);
var block_SINGLEQUOTE_ = first__16590;
var r = seq__16589__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16587__$1 = G__16587;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16595 = G__16587__$1;
var seq__16596 = cljs.core.seq.call(null,vec__16595);
var first__16597 = cljs.core.first.call(null,seq__16596);
var seq__16596__$1 = cljs.core.next.call(null,seq__16596);
var block_SINGLEQUOTE___$1 = first__16597;
var r__$1 = seq__16596__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__16598 = block_SINGLEQUOTE___$1;
var map__16598__$1 = cljs.core.__destructure_map.call(null,map__16598);
var block = cljs.core.get.call(null,map__16598__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__16598__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__16598__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__16587__$1,result_STAR___$1,map__16598,map__16598__$1,block,t,flakes,vec__16595,seq__16596,first__16597,seq__16596__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16587,vec__16588,seq__16589,first__16590,seq__16589__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16579_SHARP_){
var f = p1__16579_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__16587__$1,result_STAR___$1,map__16598,map__16598__$1,block,t,flakes,vec__16595,seq__16596,first__16597,seq__16596__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16587,vec__16588,seq__16589,first__16590,seq__16589__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__16587__$1,result_STAR___$1,map__16598,map__16598__$1,block,t,flakes,prev_hash,vec__16595,seq__16596,first__16597,seq__16596__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16587,vec__16588,seq__16589,first__16590,seq__16589__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16580_SHARP_){
var f = p1__16580_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__16587__$1,result_STAR___$1,map__16598,map__16598__$1,block,t,flakes,prev_hash,vec__16595,seq__16596,first__16597,seq__16596__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16587,vec__16588,seq__16589,first__16590,seq__16589__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__16587__$1,result_STAR___$1,map__16598,map__16598__$1,block,t,flakes,prev_hash,hash,vec__16595,seq__16596,first__16597,seq__16596__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16587,vec__16588,seq__16589,first__16590,seq__16589__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16581_SHARP_){
var f = p1__16581_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__16587__$1,result_STAR___$1,map__16598,map__16598__$1,block,t,flakes,prev_hash,hash,vec__16595,seq__16596,first__16597,seq__16596__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16587,vec__16588,seq__16589,first__16590,seq__16589__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__16587__$1,result_STAR___$1,map__16598,map__16598__$1,block,t,flakes,prev_hash,hash,instant,vec__16595,seq__16596,first__16597,seq__16596__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16587,vec__16588,seq__16589,first__16590,seq__16589__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16582_SHARP_){
var f = p1__16582_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__16587__$1,result_STAR___$1,map__16598,map__16598__$1,block,t,flakes,prev_hash,hash,instant,vec__16595,seq__16596,first__16597,seq__16596__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16587,vec__16588,seq__16589,first__16590,seq__16589__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__16587__$1,result_STAR___$1,map__16598,map__16598__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16595,seq__16596,first__16597,seq__16596__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16587,vec__16588,seq__16589,first__16590,seq__16589__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16583_SHARP_){
return cljs.core._EQ_.call(null,p1__16583_SHARP_.p,(106));
});})(G__16587__$1,result_STAR___$1,map__16598,map__16598__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16595,seq__16596,first__16597,seq__16596__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16587,vec__16588,seq__16589,first__16590,seq__16589__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__16599 = r__$1;
var G__16600 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__16587__$1 = G__16599;
result_STAR___$1 = G__16600;
continue;
}
break;
}
});
