// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22804 = arguments.length;
switch (G__22804) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22807 = arguments.length;
switch (G__22807) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22809 = null;
var G__22809__0 = (function (){
return xf.call(null);
});
var G__22809__1 = (function (result){
return xf.call(null,result);
});
var G__22809__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22809 = function(result,flake){
switch(arguments.length){
case 0:
return G__22809__0.call(this);
case 1:
return G__22809__1.call(this,result);
case 2:
return G__22809__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22809.cljs$core$IFn$_invoke$arity$0 = G__22809__0;
G__22809.cljs$core$IFn$_invoke$arity$1 = G__22809__1;
G__22809.cljs$core$IFn$_invoke$arity$2 = G__22809__2;
return G__22809;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22810 = null;
var G__22810__0 = (function (){
return xf.call(null);
});
var G__22810__1 = (function (result){
return xf.call(null,result);
});
var G__22810__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,cljs.core.count.call(null,flakes));

return xf.call(null,result,flakes);
});
G__22810 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22810__0.call(this);
case 1:
return G__22810__1.call(this,result);
case 2:
return G__22810__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22810.cljs$core$IFn$_invoke$arity$0 = G__22810__0;
G__22810.cljs$core$IFn$_invoke$arity$1 = G__22810__1;
G__22810.cljs$core$IFn$_invoke$arity$2 = G__22810__2;
return G__22810;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__22812 = res;
var G__22812__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__22811_SHARP_){
return cljs.core.get.call(null,p1__22811_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22812):G__22812);
var G__22812__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__22812__$1):G__22812__$1);
var G__22812__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__22812__$2):G__22812__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__22812__$3);
} else {
return G__22812__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22816 = arguments.length;
switch (G__22816) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23255){
var state_val_23256 = (state_23255[(1)]);
if((state_val_23256 === (121))){
var inst_23178 = (state_23255[(2)]);
var inst_23179 = fluree.db.util.async.throw_err.call(null,inst_23178);
var inst_23180 = cljs.core.seq.call(null,inst_23179);
var state_23255__$1 = state_23255;
if(inst_23180){
var statearr_23257_23471 = state_23255__$1;
(statearr_23257_23471[(1)] = (122));

} else {
var statearr_23258_23472 = state_23255__$1;
(statearr_23258_23472[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (65))){
var inst_22971 = (state_23255[(7)]);
var inst_22970 = (state_23255[(2)]);
var inst_22971__$1 = fluree.db.util.async.throw_err.call(null,inst_22970);
var inst_22972 = cljs.core.seq.call(null,inst_22971__$1);
var state_23255__$1 = (function (){var statearr_23259 = state_23255;
(statearr_23259[(7)] = inst_22971__$1);

return statearr_23259;
})();
if(inst_22972){
var statearr_23260_23473 = state_23255__$1;
(statearr_23260_23473[(1)] = (66));

} else {
var statearr_23261_23474 = state_23255__$1;
(statearr_23261_23474[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (70))){
var inst_22971 = (state_23255[(7)]);
var inst_22982 = cljs.core.count.call(null,inst_22971);
var inst_22983 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22982);
var state_23255__$1 = state_23255;
var statearr_23262_23475 = state_23255__$1;
(statearr_23262_23475[(2)] = inst_22983);

(statearr_23262_23475[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (62))){
var inst_22961 = (state_23255[(8)]);
var inst_22964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22965 = inst_22961.o;
var inst_22966 = [inst_22965];
var inst_22967 = (new cljs.core.PersistentVector(null,1,(5),inst_22964,inst_22966,null));
var inst_22968 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22967);
var state_23255__$1 = state_23255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23255__$1,(65),inst_22968);
} else {
if((state_val_23256 === (74))){
var inst_22955 = (state_23255[(9)]);
var state_23255__$1 = state_23255;
var statearr_23263_23476 = state_23255__$1;
(statearr_23263_23476[(2)] = inst_22955);

(statearr_23263_23476[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (110))){
var inst_23140 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_23141 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_23140);
var inst_23142 = inst_23141 === true;
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_23142)){
var statearr_23264_23477 = state_23255__$1;
(statearr_23264_23477[(1)] = (113));

} else {
var statearr_23265_23478 = state_23255__$1;
(statearr_23265_23478[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (130))){
var inst_23250 = (state_23255[(2)]);
var _ = (function (){var statearr_23266 = state_23255;
(statearr_23266[(4)] = cljs.core.rest.call(null,(state_23255[(4)])));

return statearr_23266;
})();
var state_23255__$1 = state_23255;
var statearr_23267_23479 = state_23255__$1;
(statearr_23267_23479[(2)] = inst_23250);

(statearr_23267_23479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (128))){
var inst_23225 = (state_23255[(10)]);
var inst_23228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23229 = [acc,inst_23225];
var inst_23230 = (new cljs.core.PersistentVector(null,2,(5),inst_23228,inst_23229,null));
var state_23255__$1 = state_23255;
var statearr_23268_23480 = state_23255__$1;
(statearr_23268_23480[(2)] = inst_23230);

(statearr_23268_23480[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (7))){
var inst_22828 = (state_23255[(11)]);
var state_23255__$1 = state_23255;
var statearr_23269_23481 = state_23255__$1;
(statearr_23269_23481[(2)] = inst_22828);

(statearr_23269_23481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (59))){
var inst_23219 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23270_23482 = state_23255__$1;
(statearr_23270_23482[(2)] = inst_23219);

(statearr_23270_23482[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (86))){
var inst_23049 = (state_23255[(12)]);
var inst_23049__$1 = (state_23255[(2)]);
var state_23255__$1 = (function (){var statearr_23271 = state_23255;
(statearr_23271[(12)] = inst_23049__$1);

return statearr_23271;
})();
if(cljs.core.truth_(inst_23049__$1)){
var statearr_23272_23483 = state_23255__$1;
(statearr_23272_23483[(1)] = (88));

} else {
var statearr_23273_23484 = state_23255__$1;
(statearr_23273_23484[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (20))){
var inst_22870 = (state_23255[(13)]);
var inst_22869 = (state_23255[(14)]);
var inst_22857 = (state_23255[(15)]);
var inst_22868 = (state_23255[(2)]);
var inst_22869__$1 = cljs.core.__destructure_map.call(null,inst_22857);
var inst_22870__$1 = cljs.core.get.call(null,inst_22869__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22871 = cljs.core.get.call(null,inst_22869__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22872 = cljs.core.get.call(null,inst_22869__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22873 = cljs.core.get.call(null,inst_22869__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22874 = cljs.core.get.call(null,inst_22869__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22875 = cljs.core.get.call(null,inst_22869__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_23255__$1 = (function (){var statearr_23274 = state_23255;
(statearr_23274[(13)] = inst_22870__$1);

(statearr_23274[(14)] = inst_22869__$1);

(statearr_23274[(16)] = inst_22874);

(statearr_23274[(17)] = inst_22868);

(statearr_23274[(18)] = inst_22873);

(statearr_23274[(19)] = inst_22871);

(statearr_23274[(20)] = inst_22875);

(statearr_23274[(21)] = inst_22872);

return statearr_23274;
})();
if(cljs.core.truth_(inst_22870__$1)){
var statearr_23275_23485 = state_23255__$1;
(statearr_23275_23485[(1)] = (24));

} else {
var statearr_23276_23486 = state_23255__$1;
(statearr_23276_23486[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (72))){
var inst_22980 = (state_23255[(22)]);
var inst_22986 = (state_23255[(2)]);
var inst_22987 = cljs.core.seq.call(null,inst_22980);
var state_23255__$1 = (function (){var statearr_23277 = state_23255;
(statearr_23277[(23)] = inst_22986);

return statearr_23277;
})();
if(inst_22987){
var statearr_23278_23487 = state_23255__$1;
(statearr_23278_23487[(1)] = (73));

} else {
var statearr_23279_23488 = state_23255__$1;
(statearr_23279_23488[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (58))){
var inst_22857 = (state_23255[(15)]);
var inst_23002 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22857);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_23002)){
var statearr_23280_23489 = state_23255__$1;
(statearr_23280_23489[(1)] = (76));

} else {
var statearr_23281_23490 = state_23255__$1;
(statearr_23281_23490[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (60))){
var inst_22961 = (state_23255[(8)]);
var inst_22954 = (state_23255[(24)]);
var inst_22960 = cljs.core.seq.call(null,inst_22954);
var inst_22961__$1 = cljs.core.first.call(null,inst_22960);
var inst_22962 = cljs.core.next.call(null,inst_22960);
var state_23255__$1 = (function (){var statearr_23282 = state_23255;
(statearr_23282[(8)] = inst_22961__$1);

(statearr_23282[(25)] = inst_22962);

return statearr_23282;
})();
if(cljs.core.truth_(inst_22961__$1)){
var statearr_23283_23491 = state_23255__$1;
(statearr_23283_23491[(1)] = (62));

} else {
var statearr_23284_23492 = state_23255__$1;
(statearr_23284_23492[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (27))){
var inst_22874 = (state_23255[(16)]);
var inst_22878 = (state_23255[(26)]);
var inst_22878__$1 = cljs.core.not_EQ_.call(null,(0),inst_22874);
var state_23255__$1 = (function (){var statearr_23285 = state_23255;
(statearr_23285[(26)] = inst_22878__$1);

return statearr_23285;
})();
if(inst_22878__$1){
var statearr_23286_23493 = state_23255__$1;
(statearr_23286_23493[(1)] = (30));

} else {
var statearr_23287_23494 = state_23255__$1;
(statearr_23287_23494[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (1))){
var state_23255__$1 = state_23255;
var statearr_23288_23495 = state_23255__$1;
(statearr_23288_23495[(2)] = null);

(statearr_23288_23495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (69))){
var inst_22976 = (state_23255[(2)]);
var inst_22977 = fluree.db.util.async.throw_err.call(null,inst_22976);
var state_23255__$1 = state_23255;
var statearr_23289_23496 = state_23255__$1;
(statearr_23289_23496[(2)] = inst_22977);

(statearr_23289_23496[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (101))){
var inst_23133 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23290_23497 = state_23255__$1;
(statearr_23290_23497[(2)] = inst_23133);

(statearr_23290_23497[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (24))){
var inst_22874 = (state_23255[(16)]);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_22874)){
var statearr_23291_23498 = state_23255__$1;
(statearr_23291_23498[(1)] = (27));

} else {
var statearr_23292_23499 = state_23255__$1;
(statearr_23292_23499[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (102))){
var inst_23105 = (state_23255[(27)]);
var inst_23104 = (state_23255[(2)]);
var inst_23105__$1 = fluree.db.util.async.throw_err.call(null,inst_23104);
var inst_23106 = cljs.core.empty_QMARK_.call(null,inst_23105__$1);
var state_23255__$1 = (function (){var statearr_23293 = state_23255;
(statearr_23293[(27)] = inst_23105__$1);

return statearr_23293;
})();
if(inst_23106){
var statearr_23294_23500 = state_23255__$1;
(statearr_23294_23500[(1)] = (103));

} else {
var statearr_23295_23501 = state_23255__$1;
(statearr_23295_23501[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (135))){
var state_23255__$1 = state_23255;
var statearr_23296_23502 = state_23255__$1;
(statearr_23296_23502[(2)] = null);

(statearr_23296_23502[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (55))){
var inst_22857 = (state_23255[(15)]);
var inst_22930 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22857);
var state_23255__$1 = state_23255;
var statearr_23297_23503 = state_23255__$1;
(statearr_23297_23503[(2)] = inst_22930);

(statearr_23297_23503[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (85))){
var inst_23024 = (state_23255[(28)]);
var inst_22857 = (state_23255[(15)]);
var inst_23036 = inst_23024.o;
var inst_23037 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22857);
var inst_23038 = fluree.db.dbproto._tag.call(null,db,inst_23036,inst_23037);
var state_23255__$1 = state_23255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23255__$1,(87),inst_23038);
} else {
if((state_val_23256 === (39))){
var inst_22905 = (state_23255[(29)]);
var inst_22873 = (state_23255[(18)]);
var inst_22905__$1 = cljs.core.not.call(null,inst_22873);
var state_23255__$1 = (function (){var statearr_23298 = state_23255;
(statearr_23298[(29)] = inst_22905__$1);

return statearr_23298;
})();
if(inst_22905__$1){
var statearr_23299_23504 = state_23255__$1;
(statearr_23299_23504[(1)] = (42));

} else {
var statearr_23300_23505 = state_23255__$1;
(statearr_23300_23505[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (88))){
var inst_23049 = (state_23255[(12)]);
var inst_23018 = (state_23255[(30)]);
var inst_23051 = cljs.core.conj.call(null,inst_23018,inst_23049);
var state_23255__$1 = state_23255;
var statearr_23301_23506 = state_23255__$1;
(statearr_23301_23506[(2)] = inst_23051);

(statearr_23301_23506[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (46))){
var inst_22872 = (state_23255[(21)]);
var state_23255__$1 = state_23255;
var statearr_23302_23507 = state_23255__$1;
(statearr_23302_23507[(2)] = inst_22872);

(statearr_23302_23507[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (4))){
var inst_22817 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23303_23508 = state_23255__$1;
(statearr_23303_23508[(2)] = inst_22817);

(statearr_23303_23508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (77))){
var inst_23064 = (state_23255[(31)]);
var inst_23064__$1 = componentFollow_QMARK_;
var state_23255__$1 = (function (){var statearr_23304 = state_23255;
(statearr_23304[(31)] = inst_23064__$1);

return statearr_23304;
})();
if(cljs.core.truth_(inst_23064__$1)){
var statearr_23305_23509 = state_23255__$1;
(statearr_23305_23509[(1)] = (91));

} else {
var statearr_23306_23510 = state_23255__$1;
(statearr_23306_23510[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (106))){
var inst_23085 = (state_23255[(32)]);
var inst_23119 = (state_23255[(2)]);
var inst_23120 = fluree.db.util.async.throw_err.call(null,inst_23119);
var inst_23121 = cljs.core.conj.call(null,inst_23085,inst_23120);
var state_23255__$1 = state_23255;
var statearr_23307_23511 = state_23255__$1;
(statearr_23307_23511[(2)] = inst_23121);

(statearr_23307_23511[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (119))){
var inst_23163 = (state_23255[(33)]);
var inst_23193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23194 = [inst_23163,offset_map];
var inst_23195 = (new cljs.core.PersistentVector(null,2,(5),inst_23193,inst_23194,null));
var state_23255__$1 = state_23255;
var statearr_23308_23512 = state_23255__$1;
(statearr_23308_23512[(2)] = inst_23195);

(statearr_23308_23512[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (95))){
var inst_22871 = (state_23255[(19)]);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_22871)){
var statearr_23309_23513 = state_23255__$1;
(statearr_23309_23513[(1)] = (110));

} else {
var statearr_23310_23514 = state_23255__$1;
(statearr_23310_23514[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (54))){
var inst_22927 = (state_23255[(34)]);
var state_23255__$1 = state_23255;
var statearr_23311_23515 = state_23255__$1;
(statearr_23311_23515[(2)] = inst_22927);

(statearr_23311_23515[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (92))){
var inst_23064 = (state_23255[(31)]);
var state_23255__$1 = state_23255;
var statearr_23312_23516 = state_23255__$1;
(statearr_23312_23516[(2)] = inst_23064);

(statearr_23312_23516[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (104))){
var inst_22827 = (state_23255[(35)]);
var inst_23105 = (state_23255[(27)]);
var inst_23114 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_23115 = [true,inst_22827];
var inst_23116 = cljs.core.PersistentHashMap.fromArrays(inst_23114,inst_23115);
var inst_23117 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23116,inst_23105);
var state_23255__$1 = state_23255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23255__$1,(106),inst_23117);
} else {
if((state_val_23256 === (15))){
var inst_22850 = (state_23255[(36)]);
var inst_22827 = (state_23255[(35)]);
var inst_22854 = cljs.core.assoc.call(null,inst_22850,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22827);
var state_23255__$1 = state_23255;
var statearr_23313_23517 = state_23255__$1;
(statearr_23313_23517[(2)] = inst_22854);

(statearr_23313_23517[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (48))){
var inst_22921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22922 = [null,offset_map];
var inst_22923 = (new cljs.core.PersistentVector(null,2,(5),inst_22921,inst_22922,null));
var state_23255__$1 = state_23255;
var statearr_23314_23518 = state_23255__$1;
(statearr_23314_23518[(2)] = inst_22923);

(statearr_23314_23518[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (50))){
var inst_23221 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23315_23519 = state_23255__$1;
(statearr_23315_23519[(2)] = inst_23221);

(statearr_23315_23519[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (116))){
var inst_23162 = (state_23255[(37)]);
var inst_23169 = (state_23255[(38)]);
var inst_23168 = cljs.core.seq.call(null,inst_23162);
var inst_23169__$1 = cljs.core.first.call(null,inst_23168);
var inst_23170 = cljs.core.next.call(null,inst_23168);
var state_23255__$1 = (function (){var statearr_23316 = state_23255;
(statearr_23316[(38)] = inst_23169__$1);

(statearr_23316[(39)] = inst_23170);

return statearr_23316;
})();
if(cljs.core.truth_(inst_23169__$1)){
var statearr_23317_23520 = state_23255__$1;
(statearr_23317_23520[(1)] = (118));

} else {
var statearr_23318_23521 = state_23255__$1;
(statearr_23318_23521[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (75))){
var inst_22962 = (state_23255[(25)]);
var inst_22992 = (state_23255[(2)]);
var inst_22954 = inst_22962;
var inst_22955 = inst_22992;
var state_23255__$1 = (function (){var statearr_23319 = state_23255;
(statearr_23319[(24)] = inst_22954);

(statearr_23319[(9)] = inst_22955);

return statearr_23319;
})();
var statearr_23320_23522 = state_23255__$1;
(statearr_23320_23522[(2)] = null);

(statearr_23320_23522[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (99))){
var inst_23091 = (state_23255[(40)]);
var inst_22857 = (state_23255[(15)]);
var inst_23094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23095 = inst_23091.o;
var inst_23096 = [inst_23095];
var inst_23097 = (new cljs.core.PersistentVector(null,1,(5),inst_23094,inst_23096,null));
var inst_23098 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23099 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22857);
var inst_23100 = [inst_23099];
var inst_23101 = cljs.core.PersistentHashMap.fromArrays(inst_23098,inst_23100);
var inst_23102 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23097,inst_23101);
var state_23255__$1 = state_23255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23255__$1,(102),inst_23102);
} else {
if((state_val_23256 === (21))){
var inst_22861 = (state_23255[(41)]);
var state_23255__$1 = state_23255;
var statearr_23321_23523 = state_23255__$1;
(statearr_23321_23523[(2)] = inst_22861);

(statearr_23321_23523[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (31))){
var inst_22878 = (state_23255[(26)]);
var state_23255__$1 = state_23255;
var statearr_23322_23524 = state_23255__$1;
(statearr_23322_23524[(2)] = inst_22878);

(statearr_23322_23524[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (113))){
var inst_22870 = (state_23255[(13)]);
var inst_22842 = (state_23255[(42)]);
var inst_22869 = (state_23255[(14)]);
var inst_22874 = (state_23255[(16)]);
var inst_22868 = (state_23255[(17)]);
var inst_22873 = (state_23255[(18)]);
var inst_22871 = (state_23255[(19)]);
var inst_22857 = (state_23255[(15)]);
var inst_22827 = (state_23255[(35)]);
var inst_22875 = (state_23255[(20)]);
var inst_22872 = (state_23255[(21)]);
var inst_23144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23145 = (function (){var p = inst_22875;
var pred_spec__$1 = inst_22842;
var orderBy = inst_22873;
var multi_QMARK_ = inst_22870;
var limit = inst_22872;
var offset = inst_22874;
var k = inst_22868;
var compact_QMARK_ = inst_22827;
var map__22823 = inst_22869;
var pred_spec_SINGLEQUOTE_ = inst_22857;
var ref_QMARK_ = inst_22871;
return (function (p1__22813_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__22813_SHARP_.o]);
});
})();
var inst_23146 = cljs.core.mapv.call(null,inst_23145,flakes);
var inst_23147 = [inst_23146,offset_map];
var inst_23148 = (new cljs.core.PersistentVector(null,2,(5),inst_23144,inst_23147,null));
var state_23255__$1 = state_23255;
var statearr_23323_23525 = state_23255__$1;
(statearr_23323_23525[(2)] = inst_23148);

(statearr_23323_23525[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (32))){
var inst_22884 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23324_23526 = state_23255__$1;
(statearr_23324_23526[(2)] = inst_22884);

(statearr_23324_23526[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (136))){
var inst_23246 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23325_23527 = state_23255__$1;
(statearr_23325_23527[(2)] = inst_23246);

(statearr_23325_23527[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (40))){
var inst_22870 = (state_23255[(13)]);
var state_23255__$1 = state_23255;
var statearr_23326_23528 = state_23255__$1;
(statearr_23326_23528[(2)] = inst_22870);

(statearr_23326_23528[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (129))){
var inst_22870 = (state_23255[(13)]);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_22870)){
var statearr_23327_23529 = state_23255__$1;
(statearr_23327_23529[(1)] = (131));

} else {
var statearr_23328_23530 = state_23255__$1;
(statearr_23328_23530[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (91))){
var inst_22857 = (state_23255[(15)]);
var inst_23066 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22857);
var state_23255__$1 = state_23255;
var statearr_23329_23531 = state_23255__$1;
(statearr_23329_23531[(2)] = inst_23066);

(statearr_23329_23531[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (117))){
var inst_23199 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23330_23532 = state_23255__$1;
(statearr_23330_23532[(2)] = inst_23199);

(statearr_23330_23532[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (108))){
var state_23255__$1 = state_23255;
var statearr_23331_23533 = state_23255__$1;
(statearr_23331_23533[(2)] = null);

(statearr_23331_23533[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (56))){
var inst_22932 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23332_23534 = state_23255__$1;
(statearr_23332_23534[(2)] = inst_22932);

(statearr_23332_23534[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (33))){
var inst_22875 = (state_23255[(20)]);
var inst_22892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22893 = cljs.core.get.call(null,offset_map,inst_22875);
var state_23255__$1 = (function (){var statearr_23333 = state_23255;
(statearr_23333[(43)] = inst_22892);

return statearr_23333;
})();
if(cljs.core.truth_(inst_22893)){
var statearr_23334_23535 = state_23255__$1;
(statearr_23334_23535[(1)] = (36));

} else {
var statearr_23335_23536 = state_23255__$1;
(statearr_23335_23536[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (13))){
var inst_22842 = (state_23255[(42)]);
var state_23255__$1 = state_23255;
var statearr_23336_23537 = state_23255__$1;
(statearr_23336_23537[(2)] = inst_22842);

(statearr_23336_23537[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (22))){
var inst_22857 = (state_23255[(15)]);
var inst_22864 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22857);
var state_23255__$1 = state_23255;
var statearr_23337_23538 = state_23255__$1;
(statearr_23337_23538[(2)] = inst_22864);

(statearr_23337_23538[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (90))){
var inst_23025 = (state_23255[(44)]);
var inst_23054 = (state_23255[(2)]);
var inst_23017 = inst_23025;
var inst_23018 = inst_23054;
var state_23255__$1 = (function (){var statearr_23338 = state_23255;
(statearr_23338[(45)] = inst_23017);

(statearr_23338[(30)] = inst_23018);

return statearr_23338;
})();
var statearr_23339_23539 = state_23255__$1;
(statearr_23339_23539[(2)] = null);

(statearr_23339_23539[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (109))){
var inst_23092 = (state_23255[(46)]);
var inst_23123 = (state_23255[(47)]);
var inst_23129 = (state_23255[(2)]);
var inst_23084 = inst_23092;
var inst_23085 = inst_23123;
var state_23255__$1 = (function (){var statearr_23340 = state_23255;
(statearr_23340[(32)] = inst_23085);

(statearr_23340[(48)] = inst_23084);

(statearr_23340[(49)] = inst_23129);

return statearr_23340;
})();
var statearr_23341_23540 = state_23255__$1;
(statearr_23341_23540[(2)] = null);

(statearr_23341_23540[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (36))){
var inst_22875 = (state_23255[(20)]);
var inst_22895 = cljs.core.update.call(null,offset_map,inst_22875,cljs.core.dec);
var state_23255__$1 = state_23255;
var statearr_23342_23541 = state_23255__$1;
(statearr_23342_23541[(2)] = inst_22895);

(statearr_23342_23541[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (41))){
var inst_22919 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_22919)){
var statearr_23343_23542 = state_23255__$1;
(statearr_23343_23542[(1)] = (48));

} else {
var statearr_23344_23543 = state_23255__$1;
(statearr_23344_23543[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (118))){
var inst_23169 = (state_23255[(38)]);
var inst_23172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23173 = inst_23169.o;
var inst_23174 = [inst_23173];
var inst_23175 = (new cljs.core.PersistentVector(null,1,(5),inst_23172,inst_23174,null));
var inst_23176 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23175);
var state_23255__$1 = state_23255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23255__$1,(121),inst_23176);
} else {
if((state_val_23256 === (89))){
var inst_23018 = (state_23255[(30)]);
var state_23255__$1 = state_23255;
var statearr_23345_23544 = state_23255__$1;
(statearr_23345_23544[(2)] = inst_23018);

(statearr_23345_23544[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (100))){
var inst_23085 = (state_23255[(32)]);
var state_23255__$1 = state_23255;
var statearr_23346_23545 = state_23255__$1;
(statearr_23346_23545[(2)] = inst_23085);

(statearr_23346_23545[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (131))){
var inst_23224 = (state_23255[(50)]);
var inst_23225 = (state_23255[(10)]);
var inst_22868 = (state_23255[(17)]);
var inst_23233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23234 = cljs.core.assoc.call(null,acc,inst_22868,inst_23224);
var inst_23235 = [inst_23234,inst_23225];
var inst_23236 = (new cljs.core.PersistentVector(null,2,(5),inst_23233,inst_23235,null));
var state_23255__$1 = state_23255;
var statearr_23347_23546 = state_23255__$1;
(statearr_23347_23546[(2)] = inst_23236);

(statearr_23347_23546[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (122))){
var inst_23169 = (state_23255[(38)]);
var inst_23170 = (state_23255[(39)]);
var inst_23163 = (state_23255[(33)]);
var inst_23182 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23183 = inst_23169.o;
var inst_23184 = [inst_23183];
var inst_23185 = cljs.core.PersistentHashMap.fromArrays(inst_23182,inst_23184);
var inst_23186 = cljs.core.conj.call(null,inst_23163,inst_23185);
var inst_23162 = inst_23170;
var inst_23163__$1 = inst_23186;
var state_23255__$1 = (function (){var statearr_23348 = state_23255;
(statearr_23348[(37)] = inst_23162);

(statearr_23348[(33)] = inst_23163__$1);

return statearr_23348;
})();
var statearr_23349_23547 = state_23255__$1;
(statearr_23349_23547[(2)] = null);

(statearr_23349_23547[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (43))){
var inst_22905 = (state_23255[(29)]);
var state_23255__$1 = state_23255;
var statearr_23350_23548 = state_23255__$1;
(statearr_23350_23548[(2)] = inst_22905);

(statearr_23350_23548[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (61))){
var inst_22941 = (state_23255[(51)]);
var inst_22998 = (state_23255[(2)]);
var inst_22999 = [inst_22998,offset_map];
var inst_23000 = (new cljs.core.PersistentVector(null,2,(5),inst_22941,inst_22999,null));
var state_23255__$1 = state_23255;
var statearr_23351_23549 = state_23255__$1;
(statearr_23351_23549[(2)] = inst_23000);

(statearr_23351_23549[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (29))){
var inst_22887 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23352_23550 = state_23255__$1;
(statearr_23352_23550[(2)] = inst_22887);

(statearr_23352_23550[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (44))){
var inst_22916 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23353_23551 = state_23255__$1;
(statearr_23353_23551[(2)] = inst_22916);

(statearr_23353_23551[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (93))){
var inst_23069 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_23069)){
var statearr_23354_23552 = state_23255__$1;
(statearr_23354_23552[(1)] = (94));

} else {
var statearr_23355_23553 = state_23255__$1;
(statearr_23355_23553[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (6))){
var inst_22830 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22831 = (inst_22830 == null);
var state_23255__$1 = state_23255;
var statearr_23356_23554 = state_23255__$1;
(statearr_23356_23554[(2)] = inst_22831);

(statearr_23356_23554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (111))){
var state_23255__$1 = state_23255;
var statearr_23357_23555 = state_23255__$1;
(statearr_23357_23555[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (28))){
var inst_22874 = (state_23255[(16)]);
var state_23255__$1 = state_23255;
var statearr_23359_23556 = state_23255__$1;
(statearr_23359_23556[(2)] = inst_22874);

(statearr_23359_23556[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (134))){
var inst_23224 = (state_23255[(50)]);
var inst_23225 = (state_23255[(10)]);
var inst_22868 = (state_23255[(17)]);
var inst_23239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23240 = cljs.core.first.call(null,inst_23224);
var inst_23241 = cljs.core.assoc.call(null,acc,inst_22868,inst_23240);
var inst_23242 = [inst_23241,inst_23225];
var inst_23243 = (new cljs.core.PersistentVector(null,2,(5),inst_23239,inst_23242,null));
var state_23255__$1 = state_23255;
var statearr_23360_23557 = state_23255__$1;
(statearr_23360_23557[(2)] = inst_23243);

(statearr_23360_23557[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (64))){
var inst_22996 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23361_23558 = state_23255__$1;
(statearr_23361_23558[(2)] = inst_22996);

(statearr_23361_23558[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (103))){
var inst_23085 = (state_23255[(32)]);
var inst_23091 = (state_23255[(40)]);
var inst_23108 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23109 = inst_23091.o;
var inst_23110 = [inst_23109];
var inst_23111 = cljs.core.PersistentHashMap.fromArrays(inst_23108,inst_23110);
var inst_23112 = cljs.core.conj.call(null,inst_23085,inst_23111);
var state_23255__$1 = state_23255;
var statearr_23362_23559 = state_23255__$1;
(statearr_23362_23559[(2)] = inst_23112);

(statearr_23362_23559[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (51))){
var inst_22927 = (state_23255[(34)]);
var inst_22857 = (state_23255[(15)]);
var inst_22927__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22857);
var state_23255__$1 = (function (){var statearr_23363 = state_23255;
(statearr_23363[(34)] = inst_22927__$1);

return statearr_23363;
})();
if(cljs.core.truth_(inst_22927__$1)){
var statearr_23364_23560 = state_23255__$1;
(statearr_23364_23560[(1)] = (54));

} else {
var statearr_23365_23561 = state_23255__$1;
(statearr_23365_23561[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (25))){
var inst_22870 = (state_23255[(13)]);
var state_23255__$1 = state_23255;
var statearr_23366_23562 = state_23255__$1;
(statearr_23366_23562[(2)] = inst_22870);

(statearr_23366_23562[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (34))){
var inst_22870 = (state_23255[(13)]);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_22870)){
var statearr_23367_23563 = state_23255__$1;
(statearr_23367_23563[(1)] = (39));

} else {
var statearr_23368_23564 = state_23255__$1;
(statearr_23368_23564[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (125))){
var inst_22870 = (state_23255[(13)]);
var inst_22842 = (state_23255[(42)]);
var inst_22869 = (state_23255[(14)]);
var inst_22874 = (state_23255[(16)]);
var inst_22868 = (state_23255[(17)]);
var inst_22873 = (state_23255[(18)]);
var inst_22871 = (state_23255[(19)]);
var inst_22857 = (state_23255[(15)]);
var inst_22827 = (state_23255[(35)]);
var inst_22875 = (state_23255[(20)]);
var inst_22872 = (state_23255[(21)]);
var inst_23204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23205 = (function (){var p = inst_22875;
var pred_spec__$1 = inst_22842;
var orderBy = inst_22873;
var multi_QMARK_ = inst_22870;
var limit = inst_22872;
var offset = inst_22874;
var k = inst_22868;
var compact_QMARK_ = inst_22827;
var map__22823 = inst_22869;
var pred_spec_SINGLEQUOTE_ = inst_22857;
var ref_QMARK_ = inst_22871;
return (function (p1__22814_SHARP_){
return p1__22814_SHARP_.o;
});
})();
var inst_23206 = cljs.core.mapv.call(null,inst_23205,flakes);
var inst_23207 = [inst_23206,offset_map];
var inst_23208 = (new cljs.core.PersistentVector(null,2,(5),inst_23204,inst_23207,null));
var state_23255__$1 = state_23255;
var statearr_23369_23565 = state_23255__$1;
(statearr_23369_23565[(2)] = inst_23208);

(statearr_23369_23565[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (17))){
var inst_22858 = (state_23255[(52)]);
var inst_22857 = (state_23255[(15)]);
var inst_22857__$1 = (state_23255[(2)]);
var inst_22858__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22857__$1);
var state_23255__$1 = (function (){var statearr_23370 = state_23255;
(statearr_23370[(52)] = inst_22858__$1);

(statearr_23370[(15)] = inst_22857__$1);

return statearr_23370;
})();
if(cljs.core.truth_(inst_22858__$1)){
var statearr_23371_23566 = state_23255__$1;
(statearr_23371_23566[(1)] = (18));

} else {
var statearr_23372_23567 = state_23255__$1;
(statearr_23372_23567[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (3))){
var inst_23253 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23255__$1,inst_23253);
} else {
if((state_val_23256 === (12))){
var inst_22842 = (state_23255[(42)]);
var inst_22847 = cljs.core.assoc.call(null,inst_22842,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_23255__$1 = state_23255;
var statearr_23373_23568 = state_23255__$1;
(statearr_23373_23568[(2)] = inst_22847);

(statearr_23373_23568[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (2))){
var inst_22828 = (state_23255[(11)]);
var _ = (function (){var statearr_23374 = state_23255;
(statearr_23374[(4)] = cljs.core.cons.call(null,(5),(state_23255[(4)])));

return statearr_23374;
})();
var inst_22827 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22828__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_23255__$1 = (function (){var statearr_23375 = state_23255;
(statearr_23375[(11)] = inst_22828__$1);

(statearr_23375[(35)] = inst_22827);

return statearr_23375;
})();
if(cljs.core.truth_(inst_22828__$1)){
var statearr_23376_23569 = state_23255__$1;
(statearr_23376_23569[(1)] = (6));

} else {
var statearr_23377_23570 = state_23255__$1;
(statearr_23377_23570[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (66))){
var inst_22971 = (state_23255[(7)]);
var inst_22940 = (state_23255[(53)]);
var inst_22974 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22940,inst_22971);
var state_23255__$1 = state_23255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23255__$1,(69),inst_22974);
} else {
if((state_val_23256 === (107))){
var inst_23105 = (state_23255[(27)]);
var inst_23125 = cljs.core.count.call(null,inst_23105);
var inst_23126 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_23125);
var state_23255__$1 = state_23255;
var statearr_23378_23571 = state_23255__$1;
(statearr_23378_23571[(2)] = inst_23126);

(statearr_23378_23571[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (23))){
var inst_22866 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23379_23572 = state_23255__$1;
(statearr_23379_23572[(2)] = inst_22866);

(statearr_23379_23572[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (47))){
var inst_22913 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23380_23573 = state_23255__$1;
(statearr_23380_23573[(2)] = inst_22913);

(statearr_23380_23573[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (35))){
var inst_23224 = (state_23255[(50)]);
var inst_23223 = (state_23255[(2)]);
var inst_23224__$1 = cljs.core.nth.call(null,inst_23223,(0),null);
var inst_23225 = cljs.core.nth.call(null,inst_23223,(1),null);
var inst_23226 = cljs.core.empty_QMARK_.call(null,inst_23224__$1);
var state_23255__$1 = (function (){var statearr_23381 = state_23255;
(statearr_23381[(50)] = inst_23224__$1);

(statearr_23381[(10)] = inst_23225);

return statearr_23381;
})();
if(inst_23226){
var statearr_23382_23574 = state_23255__$1;
(statearr_23382_23574[(1)] = (128));

} else {
var statearr_23383_23575 = state_23255__$1;
(statearr_23383_23575[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (127))){
var inst_23211 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23384_23576 = state_23255__$1;
(statearr_23384_23576[(2)] = inst_23211);

(statearr_23384_23576[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (82))){
var inst_23018 = (state_23255[(30)]);
var state_23255__$1 = state_23255;
var statearr_23385_23577 = state_23255__$1;
(statearr_23385_23577[(2)] = inst_23018);

(statearr_23385_23577[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (76))){
var inst_23004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23012 = flakes;
var inst_23013 = cljs.core.seq.call(null,inst_23012);
var inst_23014 = cljs.core.first.call(null,inst_23013);
var inst_23015 = cljs.core.next.call(null,inst_23013);
var inst_23016 = cljs.core.PersistentVector.EMPTY;
var inst_23017 = inst_23012;
var inst_23018 = inst_23016;
var state_23255__$1 = (function (){var statearr_23386 = state_23255;
(statearr_23386[(54)] = inst_23004);

(statearr_23386[(45)] = inst_23017);

(statearr_23386[(55)] = inst_23014);

(statearr_23386[(30)] = inst_23018);

(statearr_23386[(56)] = inst_23015);

return statearr_23386;
})();
var statearr_23387_23578 = state_23255__$1;
(statearr_23387_23578[(2)] = null);

(statearr_23387_23578[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (97))){
var inst_23091 = (state_23255[(40)]);
var inst_23084 = (state_23255[(48)]);
var inst_23090 = cljs.core.seq.call(null,inst_23084);
var inst_23091__$1 = cljs.core.first.call(null,inst_23090);
var inst_23092 = cljs.core.next.call(null,inst_23090);
var state_23255__$1 = (function (){var statearr_23388 = state_23255;
(statearr_23388[(40)] = inst_23091__$1);

(statearr_23388[(46)] = inst_23092);

return statearr_23388;
})();
if(cljs.core.truth_(inst_23091__$1)){
var statearr_23389_23579 = state_23255__$1;
(statearr_23389_23579[(1)] = (99));

} else {
var statearr_23390_23580 = state_23255__$1;
(statearr_23390_23580[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (19))){
var inst_22857 = (state_23255[(15)]);
var inst_22861 = (state_23255[(41)]);
var inst_22861__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22857);
var state_23255__$1 = (function (){var statearr_23391 = state_23255;
(statearr_23391[(41)] = inst_22861__$1);

return statearr_23391;
})();
if(cljs.core.truth_(inst_22861__$1)){
var statearr_23392_23581 = state_23255__$1;
(statearr_23392_23581[(1)] = (21));

} else {
var statearr_23393_23582 = state_23255__$1;
(statearr_23393_23582[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (57))){
var inst_22857 = (state_23255[(15)]);
var inst_22937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22938 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22939 = (new cljs.core.PersistentVector(null,3,(5),inst_22937,inst_22938,null));
var inst_22940 = cljs.core.select_keys.call(null,inst_22857,inst_22939);
var inst_22941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22949 = flakes;
var inst_22950 = cljs.core.seq.call(null,inst_22949);
var inst_22951 = cljs.core.first.call(null,inst_22950);
var inst_22952 = cljs.core.next.call(null,inst_22950);
var inst_22953 = cljs.core.PersistentVector.EMPTY;
var inst_22954 = inst_22949;
var inst_22955 = inst_22953;
var state_23255__$1 = (function (){var statearr_23394 = state_23255;
(statearr_23394[(57)] = inst_22952);

(statearr_23394[(24)] = inst_22954);

(statearr_23394[(58)] = inst_22951);

(statearr_23394[(9)] = inst_22955);

(statearr_23394[(53)] = inst_22940);

(statearr_23394[(51)] = inst_22941);

return statearr_23394;
})();
var statearr_23395_23583 = state_23255__$1;
(statearr_23395_23583[(2)] = null);

(statearr_23395_23583[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (68))){
var inst_22980 = (state_23255[(2)]);
var state_23255__$1 = (function (){var statearr_23396 = state_23255;
(statearr_23396[(22)] = inst_22980);

return statearr_23396;
})();
if(cljs.core.truth_(fuel)){
var statearr_23397_23584 = state_23255__$1;
(statearr_23397_23584[(1)] = (70));

} else {
var statearr_23398_23585 = state_23255__$1;
(statearr_23398_23585[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (11))){
var inst_22842 = (state_23255[(42)]);
var inst_22842__$1 = (state_23255[(2)]);
var inst_22844 = cljs.core.contains_QMARK_.call(null,inst_22842__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22845 = (!(inst_22844));
var state_23255__$1 = (function (){var statearr_23399 = state_23255;
(statearr_23399[(42)] = inst_22842__$1);

return statearr_23399;
})();
if(inst_22845){
var statearr_23400_23586 = state_23255__$1;
(statearr_23400_23586[(1)] = (12));

} else {
var statearr_23401_23587 = state_23255__$1;
(statearr_23401_23587[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (115))){
var inst_23201 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23403_23588 = state_23255__$1;
(statearr_23403_23588[(2)] = inst_23201);

(statearr_23403_23588[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (9))){
var inst_22836 = cljs.core.first.call(null,flakes);
var inst_22837 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22836);
var inst_22838 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22839 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_22837,inst_22838);
var state_23255__$1 = state_23255;
var statearr_23404_23589 = state_23255__$1;
(statearr_23404_23589[(2)] = inst_22839);

(statearr_23404_23589[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (5))){
var _ = (function (){var statearr_23405 = state_23255;
(statearr_23405[(4)] = cljs.core.rest.call(null,(state_23255[(4)])));

return statearr_23405;
})();
var state_23255__$1 = state_23255;
var ex23402 = (state_23255__$1[(2)]);
var statearr_23406_23590 = state_23255__$1;
(statearr_23406_23590[(5)] = ex23402);


if((ex23402 instanceof Error)){
var statearr_23407_23591 = state_23255__$1;
(statearr_23407_23591[(1)] = (4));

(statearr_23407_23591[(5)] = null);

} else {
throw ex23402;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (112))){
var inst_23213 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23408_23592 = state_23255__$1;
(statearr_23408_23592[(2)] = inst_23213);

(statearr_23408_23592[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (83))){
var inst_23058 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23409_23593 = state_23255__$1;
(statearr_23409_23593[(2)] = inst_23058);

(statearr_23409_23593[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (14))){
var inst_22842 = (state_23255[(42)]);
var inst_22850 = (state_23255[(2)]);
var inst_22851 = cljs.core.contains_QMARK_.call(null,inst_22842,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22852 = (!(inst_22851));
var state_23255__$1 = (function (){var statearr_23410 = state_23255;
(statearr_23410[(36)] = inst_22850);

return statearr_23410;
})();
if(inst_22852){
var statearr_23411_23594 = state_23255__$1;
(statearr_23411_23594[(1)] = (15));

} else {
var statearr_23412_23595 = state_23255__$1;
(statearr_23412_23595[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (45))){
var inst_22868 = (state_23255[(17)]);
var inst_22872 = (state_23255[(21)]);
var inst_22908 = cljs.core.get.call(null,acc,inst_22868);
var inst_22909 = cljs.core.count.call(null,inst_22908);
var inst_22910 = (inst_22909 >= inst_22872);
var state_23255__$1 = state_23255;
var statearr_23413_23596 = state_23255__$1;
(statearr_23413_23596[(2)] = inst_22910);

(statearr_23413_23596[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (53))){
var inst_22935 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_22935)){
var statearr_23414_23597 = state_23255__$1;
(statearr_23414_23597[(1)] = (57));

} else {
var statearr_23415_23598 = state_23255__$1;
(statearr_23415_23598[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (78))){
var inst_23217 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23416_23599 = state_23255__$1;
(statearr_23416_23599[(2)] = inst_23217);

(statearr_23416_23599[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (132))){
var state_23255__$1 = state_23255;
var statearr_23418_23600 = state_23255__$1;
(statearr_23418_23600[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (26))){
var inst_22890 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_22890)){
var statearr_23420_23601 = state_23255__$1;
(statearr_23420_23601[(1)] = (33));

} else {
var statearr_23421_23602 = state_23255__$1;
(statearr_23421_23602[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (123))){
var inst_23170 = (state_23255[(39)]);
var inst_23163 = (state_23255[(33)]);
var tmp23417 = inst_23163;
var inst_23162 = inst_23170;
var inst_23163__$1 = tmp23417;
var state_23255__$1 = (function (){var statearr_23422 = state_23255;
(statearr_23422[(37)] = inst_23162);

(statearr_23422[(33)] = inst_23163__$1);

return statearr_23422;
})();
var statearr_23423_23603 = state_23255__$1;
(statearr_23423_23603[(2)] = null);

(statearr_23423_23603[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (16))){
var inst_22850 = (state_23255[(36)]);
var state_23255__$1 = state_23255;
var statearr_23424_23604 = state_23255__$1;
(statearr_23424_23604[(2)] = inst_22850);

(statearr_23424_23604[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (133))){
var inst_23248 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23425_23605 = state_23255__$1;
(statearr_23425_23605[(2)] = inst_23248);

(statearr_23425_23605[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (81))){
var inst_23033 = (state_23255[(59)]);
var inst_23024 = (state_23255[(28)]);
var inst_22857 = (state_23255[(15)]);
var inst_23027 = cljs.core.deref.call(null,cache);
var inst_23028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23029 = inst_23024.o;
var inst_23030 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22857);
var inst_23031 = [inst_23029,inst_23030];
var inst_23032 = (new cljs.core.PersistentVector(null,2,(5),inst_23028,inst_23031,null));
var inst_23033__$1 = cljs.core.get.call(null,inst_23027,inst_23032);
var state_23255__$1 = (function (){var statearr_23426 = state_23255;
(statearr_23426[(59)] = inst_23033__$1);

return statearr_23426;
})();
if(cljs.core.truth_(inst_23033__$1)){
var statearr_23427_23606 = state_23255__$1;
(statearr_23427_23606[(1)] = (84));

} else {
var statearr_23428_23607 = state_23255__$1;
(statearr_23428_23607[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (120))){
var inst_23197 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23429_23608 = state_23255__$1;
(statearr_23429_23608[(2)] = inst_23197);

(statearr_23429_23608[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (79))){
var inst_23017 = (state_23255[(45)]);
var inst_23024 = (state_23255[(28)]);
var inst_23023 = cljs.core.seq.call(null,inst_23017);
var inst_23024__$1 = cljs.core.first.call(null,inst_23023);
var inst_23025 = cljs.core.next.call(null,inst_23023);
var state_23255__$1 = (function (){var statearr_23430 = state_23255;
(statearr_23430[(28)] = inst_23024__$1);

(statearr_23430[(44)] = inst_23025);

return statearr_23430;
})();
if(cljs.core.truth_(inst_23024__$1)){
var statearr_23431_23609 = state_23255__$1;
(statearr_23431_23609[(1)] = (81));

} else {
var statearr_23432_23610 = state_23255__$1;
(statearr_23432_23610[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (38))){
var inst_22892 = (state_23255[(43)]);
var inst_22900 = (state_23255[(2)]);
var inst_22901 = [null,inst_22900];
var inst_22902 = (new cljs.core.PersistentVector(null,2,(5),inst_22892,inst_22901,null));
var state_23255__$1 = state_23255;
var statearr_23433_23611 = state_23255__$1;
(statearr_23433_23611[(2)] = inst_22902);

(statearr_23433_23611[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (126))){
var state_23255__$1 = state_23255;
var statearr_23434_23612 = state_23255__$1;
(statearr_23434_23612[(2)] = null);

(statearr_23434_23612[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (98))){
var inst_23071 = (state_23255[(60)]);
var inst_23135 = (state_23255[(2)]);
var inst_23136 = [inst_23135,offset_map];
var inst_23137 = (new cljs.core.PersistentVector(null,2,(5),inst_23071,inst_23136,null));
var state_23255__$1 = state_23255;
var statearr_23435_23613 = state_23255__$1;
(statearr_23435_23613[(2)] = inst_23137);

(statearr_23435_23613[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (124))){
var inst_23191 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23436_23614 = state_23255__$1;
(statearr_23436_23614[(2)] = inst_23191);

(statearr_23436_23614[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (87))){
var inst_23024 = (state_23255[(28)]);
var inst_22857 = (state_23255[(15)]);
var inst_23040 = (state_23255[(2)]);
var inst_23041 = fluree.db.util.async.throw_err.call(null,inst_23040);
var inst_23042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23043 = inst_23024.o;
var inst_23044 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22857);
var inst_23045 = [inst_23043,inst_23044];
var inst_23046 = (new cljs.core.PersistentVector(null,2,(5),inst_23042,inst_23045,null));
var inst_23047 = fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_23046,inst_23041);
var state_23255__$1 = (function (){var statearr_23437 = state_23255;
(statearr_23437[(61)] = inst_23047);

return statearr_23437;
})();
var statearr_23438_23615 = state_23255__$1;
(statearr_23438_23615[(2)] = inst_23041);

(statearr_23438_23615[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (30))){
var inst_22875 = (state_23255[(20)]);
var inst_22880 = cljs.core.get.call(null,offset_map,inst_22875);
var inst_22881 = cljs.core.not_EQ_.call(null,(0),inst_22880);
var state_23255__$1 = state_23255;
var statearr_23439_23616 = state_23255__$1;
(statearr_23439_23616[(2)] = inst_22881);

(statearr_23439_23616[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (73))){
var inst_22980 = (state_23255[(22)]);
var inst_22955 = (state_23255[(9)]);
var inst_22989 = cljs.core.conj.call(null,inst_22955,inst_22980);
var state_23255__$1 = state_23255;
var statearr_23440_23617 = state_23255__$1;
(statearr_23440_23617[(2)] = inst_22989);

(statearr_23440_23617[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (96))){
var inst_23215 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
var statearr_23441_23618 = state_23255__$1;
(statearr_23441_23618[(2)] = inst_23215);

(statearr_23441_23618[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (10))){
var state_23255__$1 = state_23255;
var statearr_23442_23619 = state_23255__$1;
(statearr_23442_23619[(2)] = pred_spec);

(statearr_23442_23619[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (18))){
var inst_22858 = (state_23255[(52)]);
var state_23255__$1 = state_23255;
var statearr_23443_23620 = state_23255__$1;
(statearr_23443_23620[(2)] = inst_22858);

(statearr_23443_23620[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (105))){
var inst_23123 = (state_23255[(2)]);
var state_23255__$1 = (function (){var statearr_23444 = state_23255;
(statearr_23444[(47)] = inst_23123);

return statearr_23444;
})();
if(cljs.core.truth_(fuel)){
var statearr_23445_23621 = state_23255__$1;
(statearr_23445_23621[(1)] = (107));

} else {
var statearr_23446_23622 = state_23255__$1;
(statearr_23446_23622[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (52))){
var inst_22925 = (state_23255[(62)]);
var state_23255__$1 = state_23255;
var statearr_23447_23623 = state_23255__$1;
(statearr_23447_23623[(2)] = inst_22925);

(statearr_23447_23623[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (114))){
var inst_23157 = flakes;
var inst_23158 = cljs.core.seq.call(null,inst_23157);
var inst_23159 = cljs.core.first.call(null,inst_23158);
var inst_23160 = cljs.core.next.call(null,inst_23158);
var inst_23161 = cljs.core.PersistentVector.EMPTY;
var inst_23162 = inst_23157;
var inst_23163 = inst_23161;
var state_23255__$1 = (function (){var statearr_23448 = state_23255;
(statearr_23448[(63)] = inst_23159);

(statearr_23448[(37)] = inst_23162);

(statearr_23448[(64)] = inst_23160);

(statearr_23448[(33)] = inst_23163);

return statearr_23448;
})();
var statearr_23449_23624 = state_23255__$1;
(statearr_23449_23624[(2)] = null);

(statearr_23449_23624[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (67))){
var state_23255__$1 = state_23255;
var statearr_23450_23625 = state_23255__$1;
(statearr_23450_23625[(2)] = null);

(statearr_23450_23625[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (71))){
var state_23255__$1 = state_23255;
var statearr_23451_23626 = state_23255__$1;
(statearr_23451_23626[(2)] = null);

(statearr_23451_23626[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (42))){
var inst_22872 = (state_23255[(21)]);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_22872)){
var statearr_23452_23627 = state_23255__$1;
(statearr_23452_23627[(1)] = (45));

} else {
var statearr_23453_23628 = state_23255__$1;
(statearr_23453_23628[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (80))){
var inst_23004 = (state_23255[(54)]);
var inst_23060 = (state_23255[(2)]);
var inst_23061 = [inst_23060,offset_map];
var inst_23062 = (new cljs.core.PersistentVector(null,2,(5),inst_23004,inst_23061,null));
var state_23255__$1 = state_23255;
var statearr_23454_23629 = state_23255__$1;
(statearr_23454_23629[(2)] = inst_23062);

(statearr_23454_23629[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (37))){
var inst_22874 = (state_23255[(16)]);
var inst_22875 = (state_23255[(20)]);
var inst_22897 = (inst_22874 - (1));
var inst_22898 = cljs.core.assoc.call(null,offset_map,inst_22875,inst_22897);
var state_23255__$1 = state_23255;
var statearr_23455_23630 = state_23255__$1;
(statearr_23455_23630[(2)] = inst_22898);

(statearr_23455_23630[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (63))){
var inst_22955 = (state_23255[(9)]);
var state_23255__$1 = state_23255;
var statearr_23456_23631 = state_23255__$1;
(statearr_23456_23631[(2)] = inst_22955);

(statearr_23456_23631[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (94))){
var inst_23071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23079 = flakes;
var inst_23080 = cljs.core.seq.call(null,inst_23079);
var inst_23081 = cljs.core.first.call(null,inst_23080);
var inst_23082 = cljs.core.next.call(null,inst_23080);
var inst_23083 = cljs.core.PersistentVector.EMPTY;
var inst_23084 = inst_23079;
var inst_23085 = inst_23083;
var state_23255__$1 = (function (){var statearr_23457 = state_23255;
(statearr_23457[(65)] = inst_23081);

(statearr_23457[(32)] = inst_23085);

(statearr_23457[(66)] = inst_23082);

(statearr_23457[(48)] = inst_23084);

(statearr_23457[(60)] = inst_23071);

return statearr_23457;
})();
var statearr_23458_23632 = state_23255__$1;
(statearr_23458_23632[(2)] = null);

(statearr_23458_23632[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (8))){
var inst_22834 = (state_23255[(2)]);
var state_23255__$1 = state_23255;
if(cljs.core.truth_(inst_22834)){
var statearr_23459_23633 = state_23255__$1;
(statearr_23459_23633[(1)] = (9));

} else {
var statearr_23460_23634 = state_23255__$1;
(statearr_23460_23634[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (49))){
var inst_22925 = (state_23255[(62)]);
var inst_22925__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_23255__$1 = (function (){var statearr_23461 = state_23255;
(statearr_23461[(62)] = inst_22925__$1);

return statearr_23461;
})();
if(inst_22925__$1){
var statearr_23462_23635 = state_23255__$1;
(statearr_23462_23635[(1)] = (51));

} else {
var statearr_23463_23636 = state_23255__$1;
(statearr_23463_23636[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23256 === (84))){
var inst_23033 = (state_23255[(59)]);
var state_23255__$1 = state_23255;
var statearr_23464_23637 = state_23255__$1;
(statearr_23464_23637[(2)] = inst_23033);

(statearr_23464_23637[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_23465 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23465[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_23465[(1)] = (1));

return statearr_23465;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_23255){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23255);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23466){var ex__2749__auto__ = e23466;
var statearr_23467_23638 = state_23255;
(statearr_23467_23638[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23255[(4)]))){
var statearr_23468_23639 = state_23255;
(statearr_23468_23639[(1)] = cljs.core.first.call(null,(state_23255[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23640 = state_23255;
state_23255 = G__23640;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_23255){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_23255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23469 = f__2769__auto__.call(null);
(statearr_23469[(6)] = c__2768__auto__);

return statearr_23469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23800){
var state_val_23801 = (state_23800[(1)]);
if((state_val_23801 === (7))){
var inst_23795 = (state_23800[(2)]);
var _ = (function (){var statearr_23802 = state_23800;
(statearr_23802[(4)] = cljs.core.rest.call(null,(state_23800[(4)])));

return statearr_23802;
})();
var state_23800__$1 = state_23800;
var statearr_23803_23885 = state_23800__$1;
(statearr_23803_23885[(2)] = inst_23795);

(statearr_23803_23885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (20))){
var inst_23722 = (state_23800[(7)]);
var state_23800__$1 = state_23800;
var statearr_23804_23886 = state_23800__$1;
(statearr_23804_23886[(2)] = inst_23722);

(statearr_23804_23886[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (27))){
var inst_23677 = (state_23800[(8)]);
var state_23800__$1 = state_23800;
if(cljs.core.truth_(inst_23677)){
var statearr_23805_23887 = state_23800__$1;
(statearr_23805_23887[(1)] = (29));

} else {
var statearr_23806_23888 = state_23800__$1;
(statearr_23806_23888[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (1))){
var state_23800__$1 = state_23800;
var statearr_23807_23889 = state_23800__$1;
(statearr_23807_23889[(2)] = null);

(statearr_23807_23889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (24))){
var inst_23678 = (state_23800[(9)]);
var state_23800__$1 = state_23800;
var statearr_23808_23890 = state_23800__$1;
(statearr_23808_23890[(2)] = inst_23678);

(statearr_23808_23890[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (39))){
var inst_23714 = (state_23800[(10)]);
var state_23800__$1 = state_23800;
var statearr_23809_23891 = state_23800__$1;
(statearr_23809_23891[(2)] = inst_23714);

(statearr_23809_23891[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (46))){
var inst_23679 = (state_23800[(11)]);
var state_23800__$1 = state_23800;
var statearr_23810_23892 = state_23800__$1;
(statearr_23810_23892[(2)] = inst_23679);

(statearr_23810_23892[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (4))){
var inst_23641 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
var statearr_23811_23893 = state_23800__$1;
(statearr_23811_23893[(2)] = inst_23641);

(statearr_23811_23893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (15))){
var inst_23690 = (state_23800[(12)]);
var inst_23696 = cljs.core.count.call(null,inst_23690);
var inst_23697 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_23696,max_fuel);
var state_23800__$1 = state_23800;
var statearr_23812_23894 = state_23800__$1;
(statearr_23812_23894[(2)] = inst_23697);

(statearr_23812_23894[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (48))){
var inst_23781 = (state_23800[(13)]);
var inst_23659 = (state_23800[(14)]);
var inst_23666 = (state_23800[(15)]);
var inst_23789 = (state_23800[(2)]);
var inst_23790 = cljs.core.assoc.call(null,inst_23659,inst_23789,inst_23781);
var inst_23658 = inst_23666;
var inst_23659__$1 = inst_23790;
var state_23800__$1 = (function (){var statearr_23813 = state_23800;
(statearr_23813[(16)] = inst_23658);

(statearr_23813[(14)] = inst_23659__$1);

return statearr_23813;
})();
var statearr_23814_23895 = state_23800__$1;
(statearr_23814_23895[(2)] = null);

(statearr_23814_23895[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (50))){
var inst_23681 = (state_23800[(17)]);
var state_23800__$1 = state_23800;
var statearr_23815_23896 = state_23800__$1;
(statearr_23815_23896[(2)] = inst_23681);

(statearr_23815_23896[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (21))){
var inst_23678 = (state_23800[(9)]);
var state_23800__$1 = state_23800;
if(cljs.core.truth_(inst_23678)){
var statearr_23817_23897 = state_23800__$1;
(statearr_23817_23897[(1)] = (23));

} else {
var statearr_23818_23898 = state_23800__$1;
(statearr_23818_23898[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (31))){
var inst_23738 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
if(cljs.core.truth_(inst_23738)){
var statearr_23819_23899 = state_23800__$1;
(statearr_23819_23899[(1)] = (32));

} else {
var statearr_23820_23900 = state_23800__$1;
(statearr_23820_23900[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (32))){
var inst_23721 = (state_23800[(18)]);
var inst_23714 = (state_23800[(10)]);
var inst_23713 = (state_23800[(19)]);
var inst_23740 = (inst_23713 + (1));
var tmp23816 = inst_23714;
var inst_23712 = inst_23721;
var inst_23713__$1 = inst_23740;
var inst_23714__$1 = tmp23816;
var state_23800__$1 = (function (){var statearr_23821 = state_23800;
(statearr_23821[(10)] = inst_23714__$1);

(statearr_23821[(20)] = inst_23712);

(statearr_23821[(19)] = inst_23713__$1);

return statearr_23821;
})();
var statearr_23822_23901 = state_23800__$1;
(statearr_23822_23901[(2)] = null);

(statearr_23822_23901[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (40))){
var state_23800__$1 = state_23800;
if(cljs.core.truth_(fuel)){
var statearr_23823_23902 = state_23800__$1;
(statearr_23823_23902[(1)] = (42));

} else {
var statearr_23824_23903 = state_23800__$1;
(statearr_23824_23903[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (33))){
var state_23800__$1 = state_23800;
var statearr_23825_23904 = state_23800__$1;
(statearr_23825_23904[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (13))){
var inst_23690 = (state_23800[(12)]);
var state_23800__$1 = state_23800;
var statearr_23827_23905 = state_23800__$1;
(statearr_23827_23905[(2)] = inst_23690);

(statearr_23827_23905[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (22))){
var inst_23731 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
if(cljs.core.truth_(inst_23731)){
var statearr_23828_23906 = state_23800__$1;
(statearr_23828_23906[(1)] = (26));

} else {
var statearr_23829_23907 = state_23800__$1;
(statearr_23829_23907[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (36))){
var state_23800__$1 = state_23800;
var statearr_23830_23908 = state_23800__$1;
(statearr_23830_23908[(2)] = null);

(statearr_23830_23908[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (41))){
var inst_23721 = (state_23800[(18)]);
var inst_23713 = (state_23800[(19)]);
var inst_23770 = (state_23800[(2)]);
var inst_23771 = (inst_23713 + (1));
var inst_23712 = inst_23721;
var inst_23713__$1 = inst_23771;
var inst_23714 = inst_23770;
var state_23800__$1 = (function (){var statearr_23831 = state_23800;
(statearr_23831[(10)] = inst_23714);

(statearr_23831[(20)] = inst_23712);

(statearr_23831[(19)] = inst_23713__$1);

return statearr_23831;
})();
var statearr_23832_23909 = state_23800__$1;
(statearr_23832_23909[(2)] = null);

(statearr_23832_23909[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (43))){
var state_23800__$1 = state_23800;
var statearr_23833_23910 = state_23800__$1;
(statearr_23833_23910[(2)] = null);

(statearr_23833_23910[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (29))){
var inst_23677 = (state_23800[(8)]);
var inst_23713 = (state_23800[(19)]);
var inst_23735 = (inst_23713 < inst_23677);
var state_23800__$1 = state_23800;
var statearr_23834_23911 = state_23800__$1;
(statearr_23834_23911[(2)] = inst_23735);

(statearr_23834_23911[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (44))){
var inst_23750 = (state_23800[(21)]);
var inst_23754 = (state_23800[(22)]);
var inst_23763 = (state_23800[(2)]);
var inst_23764 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23754,inst_23750);
var state_23800__$1 = (function (){var statearr_23835 = state_23800;
(statearr_23835[(23)] = inst_23763);

return statearr_23835;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23800__$1,(45),inst_23764);
} else {
if((state_val_23801 === (6))){
var inst_23658 = (state_23800[(16)]);
var inst_23665 = (state_23800[(24)]);
var inst_23664 = cljs.core.seq.call(null,inst_23658);
var inst_23665__$1 = cljs.core.first.call(null,inst_23664);
var inst_23666 = cljs.core.next.call(null,inst_23664);
var inst_23667 = cljs.core.not.call(null,inst_23665__$1);
var state_23800__$1 = (function (){var statearr_23836 = state_23800;
(statearr_23836[(24)] = inst_23665__$1);

(statearr_23836[(15)] = inst_23666);

return statearr_23836;
})();
if(inst_23667){
var statearr_23837_23912 = state_23800__$1;
(statearr_23837_23912[(1)] = (8));

} else {
var statearr_23838_23913 = state_23800__$1;
(statearr_23838_23913[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (28))){
var inst_23779 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
var statearr_23839_23914 = state_23800__$1;
(statearr_23839_23914[(2)] = inst_23779);

(statearr_23839_23914[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (51))){
var inst_23787 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
var statearr_23840_23915 = state_23800__$1;
(statearr_23840_23915[(2)] = inst_23787);

(statearr_23840_23915[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (25))){
var inst_23729 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
var statearr_23841_23916 = state_23800__$1;
(statearr_23841_23916[(2)] = inst_23729);

(statearr_23841_23916[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (34))){
var inst_23777 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
var statearr_23842_23917 = state_23800__$1;
(statearr_23842_23917[(2)] = inst_23777);

(statearr_23842_23917[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (17))){
var inst_23690 = (state_23800[(12)]);
var inst_23700 = (state_23800[(2)]);
var inst_23708 = cljs.core.seq.call(null,inst_23690);
var inst_23709 = cljs.core.first.call(null,inst_23708);
var inst_23710 = cljs.core.next.call(null,inst_23708);
var inst_23711 = cljs.core.PersistentVector.EMPTY;
var inst_23712 = inst_23690;
var inst_23713 = (0);
var inst_23714 = inst_23711;
var state_23800__$1 = (function (){var statearr_23843 = state_23800;
(statearr_23843[(25)] = inst_23700);

(statearr_23843[(26)] = inst_23710);

(statearr_23843[(27)] = inst_23709);

(statearr_23843[(10)] = inst_23714);

(statearr_23843[(20)] = inst_23712);

(statearr_23843[(19)] = inst_23713);

return statearr_23843;
})();
var statearr_23844_23918 = state_23800__$1;
(statearr_23844_23918[(2)] = null);

(statearr_23844_23918[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (3))){
var inst_23798 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23800__$1,inst_23798);
} else {
if((state_val_23801 === (12))){
var state_23800__$1 = state_23800;
var statearr_23845_23919 = state_23800__$1;
(statearr_23845_23919[(2)] = fuel);

(statearr_23845_23919[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (2))){
var _ = (function (){var statearr_23846 = state_23800;
(statearr_23846[(4)] = cljs.core.cons.call(null,(5),(state_23800[(4)])));

return statearr_23846;
})();
var inst_23654 = reverse_refs_specs;
var inst_23655 = cljs.core.seq.call(null,inst_23654);
var inst_23656 = cljs.core.first.call(null,inst_23655);
var inst_23657 = cljs.core.next.call(null,inst_23655);
var inst_23658 = inst_23654;
var inst_23659 = null;
var state_23800__$1 = (function (){var statearr_23847 = state_23800;
(statearr_23847[(28)] = inst_23656);

(statearr_23847[(16)] = inst_23658);

(statearr_23847[(14)] = inst_23659);

(statearr_23847[(29)] = inst_23657);

return statearr_23847;
})();
var statearr_23848_23920 = state_23800__$1;
(statearr_23848_23920[(2)] = null);

(statearr_23848_23920[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (23))){
var inst_23678 = (state_23800[(9)]);
var inst_23713 = (state_23800[(19)]);
var inst_23726 = (inst_23713 >= inst_23678);
var state_23800__$1 = state_23800;
var statearr_23849_23921 = state_23800__$1;
(statearr_23849_23921[(2)] = inst_23726);

(statearr_23849_23921[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (47))){
var inst_23680 = (state_23800[(30)]);
var state_23800__$1 = state_23800;
if(cljs.core.truth_(inst_23680)){
var statearr_23850_23922 = state_23800__$1;
(statearr_23850_23922[(1)] = (49));

} else {
var statearr_23851_23923 = state_23800__$1;
(statearr_23851_23923[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (35))){
var inst_23720 = (state_23800[(31)]);
var inst_23744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23745 = [inst_23720];
var inst_23746 = (new cljs.core.PersistentVector(null,1,(5),inst_23744,inst_23745,null));
var inst_23747 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23746);
var state_23800__$1 = state_23800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23800__$1,(38),inst_23747);
} else {
if((state_val_23801 === (19))){
var inst_23679 = (state_23800[(11)]);
var inst_23781 = (state_23800[(2)]);
var state_23800__$1 = (function (){var statearr_23852 = state_23800;
(statearr_23852[(13)] = inst_23781);

return statearr_23852;
})();
if(cljs.core.truth_(inst_23679)){
var statearr_23853_23924 = state_23800__$1;
(statearr_23853_23924[(1)] = (46));

} else {
var statearr_23854_23925 = state_23800__$1;
(statearr_23854_23925[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (11))){
var inst_23690 = (state_23800[(12)]);
var inst_23687 = (state_23800[(2)]);
var inst_23688 = fluree.db.util.async.throw_err.call(null,inst_23687);
var inst_23689 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_23688);
var inst_23690__$1 = cljs.core.not_empty.call(null,inst_23689);
var state_23800__$1 = (function (){var statearr_23856 = state_23800;
(statearr_23856[(12)] = inst_23690__$1);

return statearr_23856;
})();
if(cljs.core.truth_(inst_23690__$1)){
var statearr_23857_23926 = state_23800__$1;
(statearr_23857_23926[(1)] = (12));

} else {
var statearr_23858_23927 = state_23800__$1;
(statearr_23858_23927[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (9))){
var inst_23675 = (state_23800[(32)]);
var inst_23665 = (state_23800[(24)]);
var inst_23674 = cljs.core.nth.call(null,inst_23665,(0),null);
var inst_23675__$1 = cljs.core.nth.call(null,inst_23665,(1),null);
var inst_23676 = cljs.core.__destructure_map.call(null,inst_23675__$1);
var inst_23677 = cljs.core.get.call(null,inst_23676,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_23678 = cljs.core.get.call(null,inst_23676,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23679 = cljs.core.get.call(null,inst_23676,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23680 = cljs.core.get.call(null,inst_23676,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_23681 = cljs.core.get.call(null,inst_23676,new cljs.core.Keyword(null,"p","p",151049309));
var inst_23682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23683 = [subject_id,inst_23674];
var inst_23684 = (new cljs.core.PersistentVector(null,2,(5),inst_23682,inst_23683,null));
var inst_23685 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_23684);
var state_23800__$1 = (function (){var statearr_23859 = state_23800;
(statearr_23859[(11)] = inst_23679);

(statearr_23859[(9)] = inst_23678);

(statearr_23859[(32)] = inst_23675__$1);

(statearr_23859[(17)] = inst_23681);

(statearr_23859[(8)] = inst_23677);

(statearr_23859[(30)] = inst_23680);

return statearr_23859;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23800__$1,(11),inst_23685);
} else {
if((state_val_23801 === (5))){
var _ = (function (){var statearr_23860 = state_23800;
(statearr_23860[(4)] = cljs.core.rest.call(null,(state_23800[(4)])));

return statearr_23860;
})();
var state_23800__$1 = state_23800;
var ex23855 = (state_23800__$1[(2)]);
var statearr_23861_23928 = state_23800__$1;
(statearr_23861_23928[(5)] = ex23855);


if((ex23855 instanceof Error)){
var statearr_23862_23929 = state_23800__$1;
(statearr_23862_23929[(1)] = (4));

(statearr_23862_23929[(5)] = null);

} else {
throw ex23855;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (14))){
var inst_23694 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
if(cljs.core.truth_(inst_23694)){
var statearr_23863_23930 = state_23800__$1;
(statearr_23863_23930[(1)] = (15));

} else {
var statearr_23864_23931 = state_23800__$1;
(statearr_23864_23931[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (45))){
var inst_23714 = (state_23800[(10)]);
var inst_23766 = (state_23800[(2)]);
var inst_23767 = fluree.db.util.async.throw_err.call(null,inst_23766);
var inst_23768 = cljs.core.conj.call(null,inst_23714,inst_23767);
var state_23800__$1 = state_23800;
var statearr_23865_23932 = state_23800__$1;
(statearr_23865_23932[(2)] = inst_23768);

(statearr_23865_23932[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (26))){
var inst_23714 = (state_23800[(10)]);
var state_23800__$1 = state_23800;
var statearr_23866_23933 = state_23800__$1;
(statearr_23866_23933[(2)] = inst_23714);

(statearr_23866_23933[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (16))){
var state_23800__$1 = state_23800;
var statearr_23867_23934 = state_23800__$1;
(statearr_23867_23934[(2)] = null);

(statearr_23867_23934[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (38))){
var inst_23750 = (state_23800[(21)]);
var inst_23675 = (state_23800[(32)]);
var inst_23749 = (state_23800[(2)]);
var inst_23750__$1 = fluree.db.util.async.throw_err.call(null,inst_23749);
var inst_23751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23752 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23753 = (new cljs.core.PersistentVector(null,4,(5),inst_23751,inst_23752,null));
var inst_23754 = cljs.core.select_keys.call(null,inst_23675,inst_23753);
var inst_23755 = cljs.core.empty_QMARK_.call(null,inst_23750__$1);
var state_23800__$1 = (function (){var statearr_23868 = state_23800;
(statearr_23868[(21)] = inst_23750__$1);

(statearr_23868[(22)] = inst_23754);

return statearr_23868;
})();
if(inst_23755){
var statearr_23869_23935 = state_23800__$1;
(statearr_23869_23935[(1)] = (39));

} else {
var statearr_23870_23936 = state_23800__$1;
(statearr_23870_23936[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (30))){
var inst_23677 = (state_23800[(8)]);
var state_23800__$1 = state_23800;
var statearr_23871_23937 = state_23800__$1;
(statearr_23871_23937[(2)] = inst_23677);

(statearr_23871_23937[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (10))){
var inst_23793 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
var statearr_23872_23938 = state_23800__$1;
(statearr_23872_23938[(2)] = inst_23793);

(statearr_23872_23938[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (18))){
var inst_23722 = (state_23800[(7)]);
var inst_23720 = (state_23800[(31)]);
var inst_23712 = (state_23800[(20)]);
var inst_23719 = cljs.core.seq.call(null,inst_23712);
var inst_23720__$1 = cljs.core.first.call(null,inst_23719);
var inst_23721 = cljs.core.next.call(null,inst_23719);
var inst_23722__$1 = cljs.core.not.call(null,inst_23720__$1);
var state_23800__$1 = (function (){var statearr_23873 = state_23800;
(statearr_23873[(7)] = inst_23722__$1);

(statearr_23873[(18)] = inst_23721);

(statearr_23873[(31)] = inst_23720__$1);

return statearr_23873;
})();
if(inst_23722__$1){
var statearr_23874_23939 = state_23800__$1;
(statearr_23874_23939[(1)] = (20));

} else {
var statearr_23875_23940 = state_23800__$1;
(statearr_23875_23940[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (42))){
var inst_23750 = (state_23800[(21)]);
var inst_23759 = cljs.core.count.call(null,inst_23750);
var inst_23760 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_23759,max_fuel);
var state_23800__$1 = state_23800;
var statearr_23876_23941 = state_23800__$1;
(statearr_23876_23941[(2)] = inst_23760);

(statearr_23876_23941[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (37))){
var inst_23775 = (state_23800[(2)]);
var state_23800__$1 = state_23800;
var statearr_23877_23942 = state_23800__$1;
(statearr_23877_23942[(2)] = inst_23775);

(statearr_23877_23942[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (8))){
var inst_23659 = (state_23800[(14)]);
var state_23800__$1 = state_23800;
var statearr_23878_23943 = state_23800__$1;
(statearr_23878_23943[(2)] = inst_23659);

(statearr_23878_23943[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23801 === (49))){
var inst_23680 = (state_23800[(30)]);
var state_23800__$1 = state_23800;
var statearr_23879_23944 = state_23800__$1;
(statearr_23879_23944[(2)] = inst_23680);

(statearr_23879_23944[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____0 = (function (){
var statearr_23880 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23880[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__);

(statearr_23880[(1)] = (1));

return statearr_23880;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____1 = (function (state_23800){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23800);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23881){var ex__2749__auto__ = e23881;
var statearr_23882_23945 = state_23800;
(statearr_23882_23945[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23800[(4)]))){
var statearr_23883_23946 = state_23800;
(statearr_23883_23946[(1)] = cljs.core.first.call(null,(state_23800[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23947 = state_23800;
state_23800 = G__23947;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__ = function(state_23800){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____1.call(this,state_23800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23884 = f__2769__auto__.call(null);
(statearr_23884[(6)] = c__2768__auto__);

return statearr_23884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23948 = select_spec;
var map__23948__$1 = cljs.core.__destructure_map.call(null,map__23948);
var recur_seen = cljs.core.get.call(null,map__23948__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__23948__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24062){
var state_val_24063 = (state_24062[(1)]);
if((state_val_24063 === (7))){
var inst_23974 = flakes;
var inst_23975 = cljs.core.seq.call(null,inst_23974);
var inst_23976 = cljs.core.first.call(null,inst_23975);
var inst_23977 = cljs.core.next.call(null,inst_23975);
var inst_23978 = cljs.core.PersistentVector.EMPTY;
var inst_23979 = inst_23974;
var inst_23980 = (0);
var inst_23981 = inst_23978;
var state_24062__$1 = (function (){var statearr_24064 = state_24062;
(statearr_24064[(7)] = inst_23980);

(statearr_24064[(8)] = inst_23979);

(statearr_24064[(9)] = inst_23977);

(statearr_24064[(10)] = inst_23976);

(statearr_24064[(11)] = inst_23981);

return statearr_24064;
})();
var statearr_24065_24131 = state_24062__$1;
(statearr_24065_24131[(2)] = null);

(statearr_24065_24131[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (20))){
var state_24062__$1 = state_24062;
var statearr_24066_24132 = state_24062__$1;
(statearr_24066_24132[(2)] = results);

(statearr_24066_24132[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (27))){
var state_24062__$1 = state_24062;
var statearr_24067_24133 = state_24062__$1;
(statearr_24067_24133[(2)] = null);

(statearr_24067_24133[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (1))){
var state_24062__$1 = state_24062;
var statearr_24068_24134 = state_24062__$1;
(statearr_24068_24134[(2)] = null);

(statearr_24068_24134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (24))){
var state_24062__$1 = state_24062;
var statearr_24069_24135 = state_24062__$1;
(statearr_24069_24135[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (39))){
var inst_23988 = (state_24062[(12)]);
var inst_24043 = (state_24062[(13)]);
var inst_23981 = (state_24062[(11)]);
var inst_24046 = (state_24062[(2)]);
var inst_24047 = fluree.db.util.async.throw_err.call(null,inst_24046);
var inst_24048 = cljs.core.conj.call(null,inst_23981,inst_24047);
var inst_23979 = inst_23988;
var inst_23980 = inst_24043;
var inst_23981__$1 = inst_24048;
var state_24062__$1 = (function (){var statearr_24071 = state_24062;
(statearr_24071[(7)] = inst_23980);

(statearr_24071[(8)] = inst_23979);

(statearr_24071[(11)] = inst_23981__$1);

return statearr_24071;
})();
var statearr_24072_24136 = state_24062__$1;
(statearr_24072_24136[(2)] = null);

(statearr_24072_24136[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (4))){
var inst_23949 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
var statearr_24073_24137 = state_24062__$1;
(statearr_24073_24137[(2)] = inst_23949);

(statearr_24073_24137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (15))){
var inst_23962 = (state_24062[(14)]);
var state_24062__$1 = state_24062;
var statearr_24074_24138 = state_24062__$1;
(statearr_24074_24138[(2)] = inst_23962);

(statearr_24074_24138[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (21))){
var inst_23958 = (state_24062[(15)]);
var state_24062__$1 = state_24062;
if(cljs.core.truth_(inst_23958)){
var statearr_24075_24139 = state_24062__$1;
(statearr_24075_24139[(1)] = (23));

} else {
var statearr_24076_24140 = state_24062__$1;
(statearr_24076_24140[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (31))){
var inst_24026 = (state_24062[(16)]);
var state_24062__$1 = state_24062;
var statearr_24077_24141 = state_24062__$1;
(statearr_24077_24141[(2)] = inst_24026);

(statearr_24077_24141[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (32))){
var inst_24018 = (state_24062[(17)]);
var inst_24032 = (state_24062[(2)]);
var state_24062__$1 = (function (){var statearr_24078 = state_24062;
(statearr_24078[(18)] = inst_24032);

return statearr_24078;
})();
if(cljs.core.truth_(inst_24018)){
var statearr_24079_24142 = state_24062__$1;
(statearr_24079_24142[(1)] = (33));

} else {
var statearr_24080_24143 = state_24062__$1;
(statearr_24080_24143[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (33))){
var inst_24018 = (state_24062[(17)]);
var state_24062__$1 = state_24062;
var statearr_24081_24144 = state_24062__$1;
(statearr_24081_24144[(2)] = inst_24018);

(statearr_24081_24144[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (13))){
var inst_23998 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
if(cljs.core.truth_(inst_23998)){
var statearr_24083_24145 = state_24062__$1;
(statearr_24083_24145[(1)] = (17));

} else {
var statearr_24084_24146 = state_24062__$1;
(statearr_24084_24146[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (22))){
var inst_24015 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
var statearr_24085_24147 = state_24062__$1;
(statearr_24085_24147[(2)] = inst_24015);

(statearr_24085_24147[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (36))){
var inst_23988 = (state_24062[(12)]);
var inst_23980 = (state_24062[(7)]);
var inst_23981 = (state_24062[(11)]);
var inst_24040 = (inst_23980 + (1));
var tmp24082 = inst_23981;
var inst_23979 = inst_23988;
var inst_23980__$1 = inst_24040;
var inst_23981__$1 = tmp24082;
var state_24062__$1 = (function (){var statearr_24086 = state_24062;
(statearr_24086[(7)] = inst_23980__$1);

(statearr_24086[(8)] = inst_23979);

(statearr_24086[(11)] = inst_23981__$1);

return statearr_24086;
})();
var statearr_24087_24148 = state_24062__$1;
(statearr_24087_24148[(2)] = null);

(statearr_24087_24148[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (29))){
var inst_24025 = (state_24062[(2)]);
var inst_24026 = fluree.db.util.async.throw_err.call(null,inst_24025);
var state_24062__$1 = (function (){var statearr_24088 = state_24062;
(statearr_24088[(16)] = inst_24026);

return statearr_24088;
})();
if(cljs.core.truth_(fuel)){
var statearr_24089_24149 = state_24062__$1;
(statearr_24089_24149[(1)] = (30));

} else {
var statearr_24090_24150 = state_24062__$1;
(statearr_24090_24150[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (6))){
var state_24062__$1 = state_24062;
var statearr_24091_24151 = state_24062__$1;
(statearr_24091_24151[(2)] = results);

(statearr_24091_24151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (28))){
var inst_24011 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
var statearr_24092_24152 = state_24062__$1;
(statearr_24092_24152[(2)] = inst_24011);

(statearr_24092_24152[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (25))){
var inst_24013 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
var statearr_24093_24153 = state_24062__$1;
(statearr_24093_24153[(2)] = inst_24013);

(statearr_24093_24153[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (34))){
var inst_24032 = (state_24062[(18)]);
var inst_24035 = cljs.core.empty_QMARK_.call(null,inst_24032);
var state_24062__$1 = state_24062;
var statearr_24094_24154 = state_24062__$1;
(statearr_24094_24154[(2)] = inst_24035);

(statearr_24094_24154[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (17))){
var inst_23981 = (state_24062[(11)]);
var inst_24000 = cljs.core.empty_QMARK_.call(null,inst_23981);
var state_24062__$1 = state_24062;
if(inst_24000){
var statearr_24095_24155 = state_24062__$1;
(statearr_24095_24155[(1)] = (20));

} else {
var statearr_24096_24156 = state_24062__$1;
(statearr_24096_24156[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (3))){
var inst_24060 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24062__$1,inst_24060);
} else {
if((state_val_24063 === (12))){
var inst_23962 = (state_24062[(14)]);
var state_24062__$1 = state_24062;
if(cljs.core.truth_(inst_23962)){
var statearr_24097_24157 = state_24062__$1;
(statearr_24097_24157[(1)] = (14));

} else {
var statearr_24098_24158 = state_24062__$1;
(statearr_24098_24158[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (2))){
var _ = (function (){var statearr_24099 = state_24062;
(statearr_24099[(4)] = cljs.core.cons.call(null,(5),(state_24062[(4)])));

return statearr_24099;
})();
var inst_23956 = select_spec;
var inst_23957 = cljs.core.__destructure_map.call(null,inst_23956);
var inst_23958 = cljs.core.get.call(null,inst_23957,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23959 = cljs.core.get.call(null,inst_23957,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23960 = cljs.core.get.call(null,inst_23957,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23961 = cljs.core.get.call(null,inst_23957,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23962 = cljs.core.get.call(null,inst_23957,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23963 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_23964 = (inst_23961 > inst_23963);
var state_24062__$1 = (function (){var statearr_24100 = state_24062;
(statearr_24100[(19)] = inst_23959);

(statearr_24100[(15)] = inst_23958);

(statearr_24100[(20)] = inst_23960);

(statearr_24100[(14)] = inst_23962);

return statearr_24100;
})();
if(cljs.core.truth_(inst_23964)){
var statearr_24101_24159 = state_24062__$1;
(statearr_24101_24159[(1)] = (6));

} else {
var statearr_24102_24160 = state_24062__$1;
(statearr_24102_24160[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (23))){
var inst_23959 = (state_24062[(19)]);
var inst_23981 = (state_24062[(11)]);
var inst_24004 = cljs.core.assoc.call(null,results,inst_23959,inst_23981);
var state_24062__$1 = state_24062;
var statearr_24103_24161 = state_24062__$1;
(statearr_24103_24161[(2)] = inst_24004);

(statearr_24103_24161[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (35))){
var inst_23987 = (state_24062[(21)]);
var inst_24037 = (state_24062[(2)]);
var inst_24038 = fluree.db.query.fql.recur_select_spec.call(null,select_spec,inst_23987);
var state_24062__$1 = (function (){var statearr_24104 = state_24062;
(statearr_24104[(22)] = inst_24038);

return statearr_24104;
})();
if(cljs.core.truth_(inst_24037)){
var statearr_24105_24162 = state_24062__$1;
(statearr_24105_24162[(1)] = (36));

} else {
var statearr_24106_24163 = state_24062__$1;
(statearr_24106_24163[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (19))){
var inst_24053 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
var statearr_24107_24164 = state_24062__$1;
(statearr_24107_24164[(2)] = inst_24053);

(statearr_24107_24164[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (11))){
var inst_23989 = (state_24062[(23)]);
var state_24062__$1 = state_24062;
var statearr_24109_24165 = state_24062__$1;
(statearr_24109_24165[(2)] = inst_23989);

(statearr_24109_24165[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (9))){
var inst_23987 = (state_24062[(21)]);
var inst_23979 = (state_24062[(8)]);
var inst_23989 = (state_24062[(23)]);
var inst_23986 = cljs.core.seq.call(null,inst_23979);
var inst_23987__$1 = cljs.core.first.call(null,inst_23986);
var inst_23988 = cljs.core.next.call(null,inst_23986);
var inst_23989__$1 = cljs.core.not.call(null,inst_23987__$1);
var state_24062__$1 = (function (){var statearr_24110 = state_24062;
(statearr_24110[(21)] = inst_23987__$1);

(statearr_24110[(12)] = inst_23988);

(statearr_24110[(23)] = inst_23989__$1);

return statearr_24110;
})();
if(inst_23989__$1){
var statearr_24111_24166 = state_24062__$1;
(statearr_24111_24166[(1)] = (11));

} else {
var statearr_24112_24167 = state_24062__$1;
(statearr_24112_24167[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (5))){
var _ = (function (){var statearr_24113 = state_24062;
(statearr_24113[(4)] = cljs.core.rest.call(null,(state_24062[(4)])));

return statearr_24113;
})();
var state_24062__$1 = state_24062;
var ex24108 = (state_24062__$1[(2)]);
var statearr_24114_24168 = state_24062__$1;
(statearr_24114_24168[(5)] = ex24108);


if((ex24108 instanceof Error)){
var statearr_24115_24169 = state_24062__$1;
(statearr_24115_24169[(1)] = (4));

(statearr_24115_24169[(5)] = null);

} else {
throw ex24108;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (14))){
var inst_23980 = (state_24062[(7)]);
var inst_23962 = (state_24062[(14)]);
var inst_23993 = (inst_23980 < inst_23962);
var state_24062__$1 = state_24062;
var statearr_24116_24170 = state_24062__$1;
(statearr_24116_24170[(2)] = inst_23993);

(statearr_24116_24170[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (26))){
var inst_23959 = (state_24062[(19)]);
var inst_23981 = (state_24062[(11)]);
var inst_24007 = cljs.core.first.call(null,inst_23981);
var inst_24008 = cljs.core.assoc.call(null,results,inst_23959,inst_24007);
var state_24062__$1 = state_24062;
var statearr_24117_24171 = state_24062__$1;
(statearr_24117_24171[(2)] = inst_24008);

(statearr_24117_24171[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (16))){
var inst_23996 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
var statearr_24118_24172 = state_24062__$1;
(statearr_24118_24172[(2)] = inst_23996);

(statearr_24118_24172[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (38))){
var inst_24051 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
var statearr_24119_24173 = state_24062__$1;
(statearr_24119_24173[(2)] = inst_24051);

(statearr_24119_24173[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (30))){
var inst_24026 = (state_24062[(16)]);
var inst_24028 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_24029 = cljs.core.sequence.call(null,inst_24028,inst_24026);
var state_24062__$1 = state_24062;
var statearr_24120_24174 = state_24062__$1;
(statearr_24120_24174[(2)] = inst_24029);

(statearr_24120_24174[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (10))){
var inst_24055 = (state_24062[(2)]);
var state_24062__$1 = state_24062;
var statearr_24121_24175 = state_24062__$1;
(statearr_24121_24175[(2)] = inst_24055);

(statearr_24121_24175[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24063 === (18))){
var inst_23987 = (state_24062[(21)]);
var inst_23960 = (state_24062[(20)]);
var inst_24017 = inst_23987.o;
var inst_24018 = cljs.core.contains_QMARK_.call(null,inst_23960,inst_24017);
var inst_24020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24021 = [inst_24017];
var inst_24022 = (new cljs.core.PersistentVector(null,1,(5),inst_24020,inst_24021,null));
var inst_24023 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24022);
var state_24062__$1 = (function (){var statearr_24122 = state_24062;
(statearr_24122[(17)] = inst_24018);

return statearr_24122;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24062__$1,(29),inst_24023);
} else {
if((state_val_24063 === (37))){
var inst_23980 = (state_24062[(7)]);
var inst_24032 = (state_24062[(18)]);
var inst_24038 = (state_24062[(22)]);
var inst_24043 = (inst_23980 + (1));
var inst_24044 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_24038,inst_24032);
var state_24062__$1 = (function (){var statearr_24123 = state_24062;
(statearr_24123[(13)] = inst_24043);

return statearr_24123;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24062__$1,(39),inst_24044);
} else {
if((state_val_24063 === (8))){
var inst_24057 = (state_24062[(2)]);
var _ = (function (){var statearr_24124 = state_24062;
(statearr_24124[(4)] = cljs.core.rest.call(null,(state_24062[(4)])));

return statearr_24124;
})();
var state_24062__$1 = state_24062;
var statearr_24125_24176 = state_24062__$1;
(statearr_24125_24176[(2)] = inst_24057);

(statearr_24125_24176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_24126 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24126[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__);

(statearr_24126[(1)] = (1));

return statearr_24126;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____1 = (function (state_24062){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24127){var ex__2749__auto__ = e24127;
var statearr_24128_24177 = state_24062;
(statearr_24128_24177[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24062[(4)]))){
var statearr_24129_24178 = state_24062;
(statearr_24129_24178[(1)] = cljs.core.first.call(null,(state_24062[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24179 = state_24062;
state_24062 = G__24179;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__ = function(state_24062){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____1.call(this,state_24062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24130 = f__2769__auto__.call(null);
(statearr_24130[(6)] = c__2768__auto__);

return statearr_24130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24360){
var state_val_24361 = (state_24360[(1)]);
if((state_val_24361 === (7))){
var state_24360__$1 = state_24360;
var statearr_24362_24448 = state_24360__$1;
(statearr_24362_24448[(2)] = null);

(statearr_24362_24448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (20))){
var inst_24218 = cljs.core.PersistentHashMap.EMPTY;
var state_24360__$1 = state_24360;
var statearr_24363_24449 = state_24360__$1;
(statearr_24363_24449[(2)] = inst_24218);

(statearr_24363_24449[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (27))){
var inst_24206 = (state_24360[(7)]);
var inst_24220 = (state_24360[(8)]);
var inst_24236 = (state_24360[(9)]);
var inst_24200 = (state_24360[(10)]);
var inst_24339 = (state_24360[(2)]);
var inst_24340 = (function (){var top_level_subject = inst_24200;
var select_spec = inst_24206;
var base_acc = inst_24220;
var acc_PLUS_refs = inst_24236;
var result = inst_24339;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_24341 = cljs.core.PersistentVector.EMPTY;
var inst_24342 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24206);
var inst_24343 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_24342);
var inst_24344 = cljs.core.vals.call(null,inst_24343);
var inst_24345 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24206);
var inst_24346 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_24345);
var inst_24347 = cljs.core.vals.call(null,inst_24346);
var inst_24348 = cljs.core.concat.call(null,inst_24344,inst_24347);
var inst_24349 = cljs.core.reduce.call(null,inst_24340,inst_24341,inst_24348);
var inst_24351 = (function (){var top_level_subject = inst_24200;
var select_spec = inst_24206;
var base_acc = inst_24220;
var acc_PLUS_refs = inst_24236;
var result = inst_24339;
var sort_preds = inst_24349;
return (function (acc,p__24350){
var vec__24364 = p__24350;
var selectPred = cljs.core.nth.call(null,vec__24364,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__24364,(1),null);
var sortPred = cljs.core.nth.call(null,vec__24364,(2),null);
var limit = cljs.core.nth.call(null,vec__24364,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_24352 = cljs.core.reduce.call(null,inst_24351,inst_24339,inst_24349);
var state_24360__$1 = state_24360;
var statearr_24367_24450 = state_24360__$1;
(statearr_24367_24450[(2)] = inst_24352);

(statearr_24367_24450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (1))){
var state_24360__$1 = state_24360;
var statearr_24368_24451 = state_24360__$1;
(statearr_24368_24451[(2)] = null);

(statearr_24368_24451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (24))){
var inst_24236 = (state_24360[(9)]);
var inst_24236__$1 = (state_24360[(2)]);
var inst_24237 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_24238 = cljs.core.PersistentHashMap.EMPTY;
var inst_24239 = inst_24237;
var inst_24240 = inst_24236__$1;
var inst_24241 = inst_24238;
var state_24360__$1 = (function (){var statearr_24369 = state_24360;
(statearr_24369[(11)] = inst_24240);

(statearr_24369[(9)] = inst_24236__$1);

(statearr_24369[(12)] = inst_24239);

(statearr_24369[(13)] = inst_24241);

return statearr_24369;
})();
var statearr_24370_24452 = state_24360__$1;
(statearr_24370_24452[(2)] = null);

(statearr_24370_24452[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (39))){
var inst_24240 = (state_24360[(11)]);
var inst_24206 = (state_24360[(7)]);
var inst_24249 = (state_24360[(14)]);
var inst_24256 = (state_24360[(15)]);
var inst_24285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24286 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_24240,inst_24206,inst_24249,inst_24256,false);
var state_24360__$1 = (function (){var statearr_24371 = state_24360;
(statearr_24371[(16)] = inst_24285);

return statearr_24371;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24360__$1,(42),inst_24286);
} else {
if((state_val_24361 === (46))){
var inst_24239 = (state_24360[(12)]);
var inst_24241 = (state_24360[(13)]);
var inst_24249 = (state_24360[(14)]);
var inst_24303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24304 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24305 = cljs.core.first.call(null,inst_24249);
var inst_24306 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_24305);
var inst_24307 = [inst_24306];
var inst_24308 = cljs.core.PersistentHashMap.fromArrays(inst_24304,inst_24307);
var inst_24309 = cljs.core.rest.call(null,inst_24239);
var inst_24310 = [inst_24308,inst_24309,inst_24241];
var inst_24311 = (new cljs.core.PersistentVector(null,3,(5),inst_24303,inst_24310,null));
var state_24360__$1 = state_24360;
var statearr_24372_24453 = state_24360__$1;
(statearr_24372_24453[(2)] = inst_24311);

(statearr_24372_24453[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (4))){
var inst_24180 = (state_24360[(2)]);
var state_24360__$1 = state_24360;
var statearr_24373_24454 = state_24360__$1;
(statearr_24373_24454[(2)] = inst_24180);

(statearr_24373_24454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (15))){
var inst_24206 = (state_24360[(7)]);
var inst_24207 = (state_24360[(17)]);
var inst_24206__$1 = (state_24360[(2)]);
var inst_24207__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_24206__$1);
var state_24360__$1 = (function (){var statearr_24374 = state_24360;
(statearr_24374[(7)] = inst_24206__$1);

(statearr_24374[(17)] = inst_24207__$1);

return statearr_24374;
})();
if(cljs.core.truth_(inst_24207__$1)){
var statearr_24375_24455 = state_24360__$1;
(statearr_24375_24455[(1)] = (16));

} else {
var statearr_24376_24456 = state_24360__$1;
(statearr_24376_24456[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (48))){
var inst_24322 = (state_24360[(2)]);
var state_24360__$1 = state_24360;
var statearr_24377_24457 = state_24360__$1;
(statearr_24377_24457[(2)] = inst_24322);

(statearr_24377_24457[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (50))){
var state_24360__$1 = state_24360;
var statearr_24378_24458 = state_24360__$1;
(statearr_24378_24458[(2)] = null);

(statearr_24378_24458[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (21))){
var inst_24206 = (state_24360[(7)]);
var inst_24220 = (state_24360[(2)]);
var inst_24221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24222 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_24223 = (new cljs.core.PersistentVector(null,2,(5),inst_24221,inst_24222,null));
var inst_24224 = cljs.core.get_in.call(null,inst_24206,inst_24223);
var state_24360__$1 = (function (){var statearr_24379 = state_24360;
(statearr_24379[(8)] = inst_24220);

return statearr_24379;
})();
if(cljs.core.truth_(inst_24224)){
var statearr_24380_24459 = state_24360__$1;
(statearr_24380_24459[(1)] = (22));

} else {
var statearr_24381_24460 = state_24360__$1;
(statearr_24381_24460[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (31))){
var inst_24240 = (state_24360[(11)]);
var inst_24255 = (state_24360[(18)]);
var inst_24249 = (state_24360[(14)]);
var inst_24259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24260 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_24249,inst_24255,inst_24240,fuel,max_fuel,cache);
var state_24360__$1 = (function (){var statearr_24382 = state_24360;
(statearr_24382[(19)] = inst_24259);

return statearr_24382;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24360__$1,(34),inst_24260);
} else {
if((state_val_24361 === (32))){
var inst_24255 = (state_24360[(18)]);
var state_24360__$1 = state_24360;
if(cljs.core.truth_(inst_24255)){
var statearr_24383_24461 = state_24360__$1;
(statearr_24383_24461[(1)] = (35));

} else {
var statearr_24384_24462 = state_24360__$1;
(statearr_24384_24462[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (40))){
var inst_24206 = (state_24360[(7)]);
var inst_24296 = (state_24360[(20)]);
var inst_24295 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_24206);
var inst_24296__$1 = cljs.core.empty_QMARK_.call(null,inst_24295);
var state_24360__$1 = (function (){var statearr_24385 = state_24360;
(statearr_24385[(20)] = inst_24296__$1);

return statearr_24385;
})();
if(inst_24296__$1){
var statearr_24386_24463 = state_24360__$1;
(statearr_24386_24463[(1)] = (43));

} else {
var statearr_24387_24464 = state_24360__$1;
(statearr_24387_24464[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (33))){
var inst_24249 = (state_24360[(14)]);
var inst_24328 = (state_24360[(2)]);
var inst_24329 = cljs.core.nth.call(null,inst_24328,(0),null);
var inst_24330 = cljs.core.nth.call(null,inst_24328,(1),null);
var inst_24331 = cljs.core.nth.call(null,inst_24328,(2),null);
var inst_24332 = cljs.core.first.call(null,inst_24249);
var inst_24333 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_24332);
var inst_24334 = cljs.core.assoc.call(null,inst_24329,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_24333);
var inst_24239 = inst_24330;
var inst_24240 = inst_24334;
var inst_24241 = inst_24331;
var state_24360__$1 = (function (){var statearr_24388 = state_24360;
(statearr_24388[(11)] = inst_24240);

(statearr_24388[(12)] = inst_24239);

(statearr_24388[(13)] = inst_24241);

return statearr_24388;
})();
var statearr_24389_24465 = state_24360__$1;
(statearr_24389_24465[(2)] = null);

(statearr_24389_24465[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (13))){
var inst_24200 = (state_24360[(10)]);
var inst_24203 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_24200);
var state_24360__$1 = state_24360;
var statearr_24390_24466 = state_24360__$1;
(statearr_24390_24466[(2)] = inst_24203);

(statearr_24390_24466[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (22))){
var inst_24206 = (state_24360[(7)]);
var inst_24226 = cljs.core.first.call(null,flakes);
var inst_24227 = fluree.db.query.fql.s.call(null,inst_24226);
var inst_24228 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_24206);
var inst_24229 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_24227,inst_24228);
var state_24360__$1 = state_24360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24360__$1,(25),inst_24229);
} else {
if((state_val_24361 === (36))){
var inst_24206 = (state_24360[(7)]);
var inst_24283 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_24206);
var state_24360__$1 = state_24360;
if(cljs.core.truth_(inst_24283)){
var statearr_24391_24467 = state_24360__$1;
(statearr_24391_24467[(1)] = (39));

} else {
var statearr_24392_24468 = state_24360__$1;
(statearr_24392_24468[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (41))){
var inst_24324 = (state_24360[(2)]);
var state_24360__$1 = state_24360;
var statearr_24393_24469 = state_24360__$1;
(statearr_24393_24469[(2)] = inst_24324);

(statearr_24393_24469[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (43))){
var inst_24206 = (state_24360[(7)]);
var inst_24298 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_24206);
var state_24360__$1 = state_24360;
var statearr_24394_24470 = state_24360__$1;
(statearr_24394_24470[(2)] = inst_24298);

(statearr_24394_24470[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (29))){
var inst_24206 = (state_24360[(7)]);
var inst_24255 = (state_24360[(18)]);
var inst_24239 = (state_24360[(12)]);
var inst_24249 = (state_24360[(14)]);
var inst_24249__$1 = cljs.core.first.call(null,inst_24239);
var inst_24250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24251 = cljs.core.first.call(null,inst_24249__$1);
var inst_24252 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_24251);
var inst_24253 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_24252];
var inst_24254 = (new cljs.core.PersistentVector(null,3,(5),inst_24250,inst_24253,null));
var inst_24255__$1 = cljs.core.get_in.call(null,inst_24206,inst_24254);
var inst_24256 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_24255__$1,inst_24206);
var inst_24257 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_24255__$1);
var state_24360__$1 = (function (){var statearr_24395 = state_24360;
(statearr_24395[(18)] = inst_24255__$1);

(statearr_24395[(14)] = inst_24249__$1);

(statearr_24395[(15)] = inst_24256);

return statearr_24395;
})();
if(cljs.core.truth_(inst_24257)){
var statearr_24396_24471 = state_24360__$1;
(statearr_24396_24471[(1)] = (31));

} else {
var statearr_24397_24472 = state_24360__$1;
(statearr_24397_24472[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (44))){
var inst_24296 = (state_24360[(20)]);
var state_24360__$1 = state_24360;
var statearr_24398_24473 = state_24360__$1;
(statearr_24398_24473[(2)] = inst_24296);

(statearr_24398_24473[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (6))){
var state_24360__$1 = state_24360;
var statearr_24399_24474 = state_24360__$1;
(statearr_24399_24474[(2)] = null);

(statearr_24399_24474[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (28))){
var inst_24240 = (state_24360[(11)]);
var state_24360__$1 = state_24360;
var statearr_24400_24475 = state_24360__$1;
(statearr_24400_24475[(2)] = inst_24240);

(statearr_24400_24475[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (51))){
var inst_24320 = (state_24360[(2)]);
var state_24360__$1 = state_24360;
var statearr_24401_24476 = state_24360__$1;
(statearr_24401_24476[(2)] = inst_24320);

(statearr_24401_24476[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (25))){
var inst_24220 = (state_24360[(8)]);
var inst_24231 = (state_24360[(2)]);
var inst_24232 = fluree.db.util.async.throw_err.call(null,inst_24231);
var inst_24233 = cljs.core.merge.call(null,inst_24220,inst_24232);
var state_24360__$1 = state_24360;
var statearr_24402_24477 = state_24360__$1;
(statearr_24402_24477[(2)] = inst_24233);

(statearr_24402_24477[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (34))){
var inst_24259 = (state_24360[(19)]);
var inst_24239 = (state_24360[(12)]);
var inst_24241 = (state_24360[(13)]);
var inst_24262 = (state_24360[(2)]);
var inst_24263 = fluree.db.util.async.throw_err.call(null,inst_24262);
var inst_24264 = cljs.core.rest.call(null,inst_24239);
var inst_24265 = [inst_24263,inst_24264,inst_24241];
var inst_24266 = (new cljs.core.PersistentVector(null,3,(5),inst_24259,inst_24265,null));
var state_24360__$1 = state_24360;
var statearr_24403_24478 = state_24360__$1;
(statearr_24403_24478[(2)] = inst_24266);

(statearr_24403_24478[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (17))){
var inst_24206 = (state_24360[(7)]);
var inst_24210 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_24206);
var state_24360__$1 = state_24360;
var statearr_24405_24479 = state_24360__$1;
(statearr_24405_24479[(2)] = inst_24210);

(statearr_24405_24479[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (3))){
var inst_24358 = (state_24360[(2)]);
var state_24360__$1 = state_24360;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24360__$1,inst_24358);
} else {
if((state_val_24361 === (12))){
var _ = (function (){var statearr_24406 = state_24360;
(statearr_24406[(4)] = cljs.core.rest.call(null,(state_24360[(4)])));

return statearr_24406;
})();
var state_24360__$1 = state_24360;
var ex24404 = (state_24360__$1[(2)]);
var statearr_24407_24480 = state_24360__$1;
(statearr_24407_24480[(5)] = ex24404);


var statearr_24408_24481 = state_24360__$1;
(statearr_24408_24481[(1)] = (11));

(statearr_24408_24481[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (2))){
var _ = (function (){var statearr_24409 = state_24360;
(statearr_24409[(4)] = cljs.core.cons.call(null,(5),(state_24360[(4)])));

return statearr_24409;
})();
var inst_24186 = cljs.core.not_empty.call(null,flakes);
var state_24360__$1 = state_24360;
if(cljs.core.truth_(inst_24186)){
var statearr_24410_24482 = state_24360__$1;
(statearr_24410_24482[(1)] = (6));

} else {
var statearr_24411_24483 = state_24360__$1;
(statearr_24411_24483[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (23))){
var inst_24220 = (state_24360[(8)]);
var state_24360__$1 = state_24360;
var statearr_24412_24484 = state_24360__$1;
(statearr_24412_24484[(2)] = inst_24220);

(statearr_24412_24484[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (47))){
var state_24360__$1 = state_24360;
var statearr_24413_24485 = state_24360__$1;
(statearr_24413_24485[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (35))){
var inst_24240 = (state_24360[(11)]);
var inst_24255 = (state_24360[(18)]);
var inst_24241 = (state_24360[(13)]);
var inst_24249 = (state_24360[(14)]);
var inst_24256 = (state_24360[(15)]);
var inst_24272 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_24240,inst_24255,inst_24249,inst_24256,false,inst_24241);
var state_24360__$1 = state_24360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24360__$1,(38),inst_24272);
} else {
if((state_val_24361 === (19))){
var inst_24200 = (state_24360[(10)]);
var inst_24214 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24215 = [inst_24200];
var inst_24216 = cljs.core.PersistentHashMap.fromArrays(inst_24214,inst_24215);
var state_24360__$1 = state_24360;
var statearr_24415_24486 = state_24360__$1;
(statearr_24415_24486[(2)] = inst_24216);

(statearr_24415_24486[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (11))){
var inst_24188 = (state_24360[(2)]);
var inst_24189 = fluree.db.util.log.error.call(null,inst_24188);
var inst_24190 = (function(){throw inst_24188})();
var state_24360__$1 = (function (){var statearr_24417 = state_24360;
(statearr_24417[(21)] = inst_24189);

return statearr_24417;
})();
var statearr_24418_24487 = state_24360__$1;
(statearr_24418_24487[(2)] = inst_24190);

(statearr_24418_24487[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (9))){
var _ = (function (){var statearr_24419 = state_24360;
(statearr_24419[(4)] = cljs.core.cons.call(null,(12),(state_24360[(4)])));

return statearr_24419;
})();
var inst_24196 = cljs.core.first.call(null,flakes);
var inst_24197 = fluree.db.query.fql.s.call(null,inst_24196);
var ___$1 = (function (){var statearr_24420 = state_24360;
(statearr_24420[(4)] = cljs.core.rest.call(null,(state_24360[(4)])));

return statearr_24420;
})();
var state_24360__$1 = state_24360;
var statearr_24421_24488 = state_24360__$1;
(statearr_24421_24488[(2)] = inst_24197);

(statearr_24421_24488[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (5))){
var _ = (function (){var statearr_24422 = state_24360;
(statearr_24422[(4)] = cljs.core.rest.call(null,(state_24360[(4)])));

return statearr_24422;
})();
var state_24360__$1 = state_24360;
var ex24416 = (state_24360__$1[(2)]);
var statearr_24423_24489 = state_24360__$1;
(statearr_24423_24489[(5)] = ex24416);


if((ex24416 instanceof Error)){
var statearr_24424_24490 = state_24360__$1;
(statearr_24424_24490[(1)] = (4));

(statearr_24424_24490[(5)] = null);

} else {
throw ex24416;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (14))){
var state_24360__$1 = state_24360;
var statearr_24425_24491 = state_24360__$1;
(statearr_24425_24491[(2)] = base_select_spec);

(statearr_24425_24491[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (45))){
var inst_24301 = (state_24360[(2)]);
var state_24360__$1 = state_24360;
if(cljs.core.truth_(inst_24301)){
var statearr_24426_24492 = state_24360__$1;
(statearr_24426_24492[(1)] = (46));

} else {
var statearr_24427_24493 = state_24360__$1;
(statearr_24427_24493[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (26))){
var inst_24239 = (state_24360[(12)]);
var inst_24243 = cljs.core.empty_QMARK_.call(null,inst_24239);
var state_24360__$1 = state_24360;
if(inst_24243){
var statearr_24428_24494 = state_24360__$1;
(statearr_24428_24494[(1)] = (28));

} else {
var statearr_24429_24495 = state_24360__$1;
(statearr_24429_24495[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (16))){
var inst_24207 = (state_24360[(17)]);
var state_24360__$1 = state_24360;
var statearr_24430_24496 = state_24360__$1;
(statearr_24430_24496[(2)] = inst_24207);

(statearr_24430_24496[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (38))){
var inst_24239 = (state_24360[(12)]);
var inst_24274 = (state_24360[(2)]);
var inst_24275 = fluree.db.util.async.throw_err.call(null,inst_24274);
var inst_24276 = cljs.core.nth.call(null,inst_24275,(0),null);
var inst_24277 = cljs.core.nth.call(null,inst_24275,(1),null);
var inst_24278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24279 = cljs.core.rest.call(null,inst_24239);
var inst_24280 = [inst_24276,inst_24279,inst_24277];
var inst_24281 = (new cljs.core.PersistentVector(null,3,(5),inst_24278,inst_24280,null));
var state_24360__$1 = state_24360;
var statearr_24431_24497 = state_24360__$1;
(statearr_24431_24497[(2)] = inst_24281);

(statearr_24431_24497[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (30))){
var inst_24337 = (state_24360[(2)]);
var state_24360__$1 = state_24360;
var statearr_24432_24498 = state_24360__$1;
(statearr_24432_24498[(2)] = inst_24337);

(statearr_24432_24498[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (10))){
var inst_24200 = (state_24360[(2)]);
var inst_24201 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_24360__$1 = (function (){var statearr_24433 = state_24360;
(statearr_24433[(10)] = inst_24200);

return statearr_24433;
})();
if(cljs.core.truth_(inst_24201)){
var statearr_24434_24499 = state_24360__$1;
(statearr_24434_24499[(1)] = (13));

} else {
var statearr_24435_24500 = state_24360__$1;
(statearr_24435_24500[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (18))){
var inst_24212 = (state_24360[(2)]);
var state_24360__$1 = state_24360;
if(cljs.core.truth_(inst_24212)){
var statearr_24436_24501 = state_24360__$1;
(statearr_24436_24501[(1)] = (19));

} else {
var statearr_24437_24502 = state_24360__$1;
(statearr_24437_24502[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (42))){
var inst_24285 = (state_24360[(16)]);
var inst_24239 = (state_24360[(12)]);
var inst_24241 = (state_24360[(13)]);
var inst_24288 = (state_24360[(2)]);
var inst_24289 = fluree.db.util.async.throw_err.call(null,inst_24288);
var inst_24290 = cljs.core.first.call(null,inst_24289);
var inst_24291 = cljs.core.rest.call(null,inst_24239);
var inst_24292 = [inst_24290,inst_24291,inst_24241];
var inst_24293 = (new cljs.core.PersistentVector(null,3,(5),inst_24285,inst_24292,null));
var state_24360__$1 = state_24360;
var statearr_24438_24503 = state_24360__$1;
(statearr_24438_24503[(2)] = inst_24293);

(statearr_24438_24503[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (37))){
var inst_24326 = (state_24360[(2)]);
var state_24360__$1 = state_24360;
var statearr_24439_24504 = state_24360__$1;
(statearr_24439_24504[(2)] = inst_24326);

(statearr_24439_24504[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (8))){
var inst_24355 = (state_24360[(2)]);
var _ = (function (){var statearr_24440 = state_24360;
(statearr_24440[(4)] = cljs.core.rest.call(null,(state_24360[(4)])));

return statearr_24440;
})();
var state_24360__$1 = state_24360;
var statearr_24441_24505 = state_24360__$1;
(statearr_24441_24505[(2)] = inst_24355);

(statearr_24441_24505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24361 === (49))){
var inst_24240 = (state_24360[(11)]);
var inst_24239 = (state_24360[(12)]);
var inst_24241 = (state_24360[(13)]);
var inst_24314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24315 = cljs.core.rest.call(null,inst_24239);
var inst_24316 = [inst_24240,inst_24315,inst_24241];
var inst_24317 = (new cljs.core.PersistentVector(null,3,(5),inst_24314,inst_24316,null));
var state_24360__$1 = state_24360;
var statearr_24442_24506 = state_24360__$1;
(statearr_24442_24506[(2)] = inst_24317);

(statearr_24442_24506[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____0 = (function (){
var statearr_24443 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24443[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__);

(statearr_24443[(1)] = (1));

return statearr_24443;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____1 = (function (state_24360){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24360);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24444){var ex__2749__auto__ = e24444;
var statearr_24445_24507 = state_24360;
(statearr_24445_24507[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24360[(4)]))){
var statearr_24446_24508 = state_24360;
(statearr_24446_24508[(1)] = cljs.core.first.call(null,(state_24360[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24509 = state_24360;
state_24360 = G__24509;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__ = function(state_24360){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____1.call(this,state_24360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24447 = f__2769__auto__.call(null);
(statearr_24447[(6)] = c__2768__auto__);

return statearr_24447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__24512 = arguments.length;
switch (G__24512) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24554){
var state_val_24555 = (state_24554[(1)]);
if((state_val_24555 === (7))){
var inst_24520 = (state_24554[(7)]);
var state_24554__$1 = state_24554;
var statearr_24556_24586 = state_24554__$1;
(statearr_24556_24586[(2)] = inst_24520);

(statearr_24556_24586[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (1))){
var state_24554__$1 = state_24554;
var statearr_24557_24587 = state_24554__$1;
(statearr_24557_24587[(2)] = null);

(statearr_24557_24587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (4))){
var inst_24513 = (state_24554[(2)]);
var state_24554__$1 = state_24554;
var statearr_24558_24588 = state_24554__$1;
(statearr_24558_24588[(2)] = inst_24513);

(statearr_24558_24588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (15))){
var inst_24548 = (state_24554[(2)]);
var inst_24549 = fluree.db.util.async.throw_err.call(null,inst_24548);
var _ = (function (){var statearr_24559 = state_24554;
(statearr_24559[(4)] = cljs.core.rest.call(null,(state_24554[(4)])));

return statearr_24559;
})();
var state_24554__$1 = state_24554;
var statearr_24560_24589 = state_24554__$1;
(statearr_24560_24589[(2)] = inst_24549);

(statearr_24560_24589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (13))){
var inst_24532 = (state_24554[(8)]);
var state_24554__$1 = state_24554;
var statearr_24561_24590 = state_24554__$1;
(statearr_24561_24590[(2)] = inst_24532);

(statearr_24561_24590[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (6))){
var inst_24520 = (state_24554[(7)]);
var inst_24522 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_24523 = cljs.core.comp.call(null,inst_24520,inst_24522);
var state_24554__$1 = state_24554;
var statearr_24562_24591 = state_24554__$1;
(statearr_24562_24591[(2)] = inst_24523);

(statearr_24562_24591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (3))){
var inst_24552 = (state_24554[(2)]);
var state_24554__$1 = state_24554;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24554__$1,inst_24552);
} else {
if((state_val_24555 === (12))){
var inst_24532 = (state_24554[(8)]);
var inst_24534 = cljs.core.take.call(null,limit);
var inst_24535 = cljs.core.comp.call(null,inst_24532,inst_24534);
var state_24554__$1 = state_24554;
var statearr_24563_24592 = state_24554__$1;
(statearr_24563_24592[(2)] = inst_24535);

(statearr_24563_24592[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (2))){
var _ = (function (){var statearr_24564 = state_24554;
(statearr_24564[(4)] = cljs.core.cons.call(null,(5),(state_24554[(4)])));

return statearr_24564;
})();
var inst_24520 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_24554__$1 = (function (){var statearr_24565 = state_24554;
(statearr_24565[(7)] = inst_24520);

return statearr_24565;
})();
if(cljs.core.truth_(fuel)){
var statearr_24566_24593 = state_24554__$1;
(statearr_24566_24593[(1)] = (6));

} else {
var statearr_24567_24594 = state_24554__$1;
(statearr_24567_24594[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (11))){
var inst_24532 = (state_24554[(2)]);
var state_24554__$1 = (function (){var statearr_24569 = state_24554;
(statearr_24569[(8)] = inst_24532);

return statearr_24569;
})();
if(cljs.core.truth_(limit)){
var statearr_24570_24595 = state_24554__$1;
(statearr_24570_24595[(1)] = (12));

} else {
var statearr_24571_24596 = state_24554__$1;
(statearr_24571_24596[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (9))){
var inst_24526 = (state_24554[(9)]);
var inst_24528 = cljs.core.drop.call(null,offset);
var inst_24529 = cljs.core.comp.call(null,inst_24526,inst_24528);
var state_24554__$1 = state_24554;
var statearr_24572_24597 = state_24554__$1;
(statearr_24572_24597[(2)] = inst_24529);

(statearr_24572_24597[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (5))){
var _ = (function (){var statearr_24573 = state_24554;
(statearr_24573[(4)] = cljs.core.rest.call(null,(state_24554[(4)])));

return statearr_24573;
})();
var state_24554__$1 = state_24554;
var ex24568 = (state_24554__$1[(2)]);
var statearr_24574_24598 = state_24554__$1;
(statearr_24574_24598[(5)] = ex24568);


if((ex24568 instanceof Error)){
var statearr_24575_24599 = state_24554__$1;
(statearr_24575_24599[(1)] = (4));

(statearr_24575_24599[(5)] = null);

} else {
throw ex24568;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (14))){
var inst_24538 = (state_24554[(2)]);
var inst_24539 = (function (){return (function (x){
var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__5043__auto__;
}
});
})();
var inst_24540 = cljs.core.halt_when.call(null,inst_24539);
var inst_24541 = cljs.core.comp.call(null,inst_24538,inst_24540);
var inst_24542 = cljs.core.sequence.call(null,inst_24541,flakes);
var inst_24543 = cljs.core.PersistentVector.EMPTY;
var inst_24544 = (function (){var xf = inst_24541;
var flakes_by_sub = inst_24542;
return (function (p1__24510_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__24510_SHARP_);
});
})();
var inst_24545 = cljs.core.map.call(null,inst_24544,inst_24542);
var inst_24546 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_24543,inst_24545);
var state_24554__$1 = state_24554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24554__$1,(15),inst_24546);
} else {
if((state_val_24555 === (10))){
var inst_24526 = (state_24554[(9)]);
var state_24554__$1 = state_24554;
var statearr_24576_24600 = state_24554__$1;
(statearr_24576_24600[(2)] = inst_24526);

(statearr_24576_24600[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24555 === (8))){
var inst_24526 = (state_24554[(2)]);
var state_24554__$1 = (function (){var statearr_24577 = state_24554;
(statearr_24577[(9)] = inst_24526);

return statearr_24577;
})();
if(cljs.core.truth_(offset)){
var statearr_24578_24601 = state_24554__$1;
(statearr_24578_24601[(1)] = (9));

} else {
var statearr_24579_24602 = state_24554__$1;
(statearr_24579_24602[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_24580 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24580[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_24580[(1)] = (1));

return statearr_24580;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_24554){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24554);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24581){var ex__2749__auto__ = e24581;
var statearr_24582_24603 = state_24554;
(statearr_24582_24603[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24554[(4)]))){
var statearr_24583_24604 = state_24554;
(statearr_24583_24604[(1)] = cljs.core.first.call(null,(state_24554[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24605 = state_24554;
state_24554 = G__24605;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_24554){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_24554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24584 = f__2769__auto__.call(null);
(statearr_24584[(6)] = c__2768__auto__);

return statearr_24584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__24607 = arguments.length;
switch (G__24607) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24693){
var state_val_24694 = (state_24693[(1)]);
if((state_val_24694 === (7))){
var inst_24688 = (state_24693[(2)]);
var _ = (function (){var statearr_24696 = state_24693;
(statearr_24696[(4)] = cljs.core.rest.call(null,(state_24693[(4)])));

return statearr_24696;
})();
var state_24693__$1 = state_24693;
var statearr_24697_24749 = state_24693__$1;
(statearr_24697_24749[(2)] = inst_24688);

(statearr_24697_24749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (20))){
var inst_24628 = (state_24693[(7)]);
var inst_24627 = (state_24693[(8)]);
var inst_24635 = (state_24693[(9)]);
var inst_24656 = (inst_24627 + (1));
var tmp24695 = inst_24628;
var inst_24626 = inst_24635;
var inst_24627__$1 = inst_24656;
var inst_24628__$1 = tmp24695;
var state_24693__$1 = (function (){var statearr_24698 = state_24693;
(statearr_24698[(7)] = inst_24628__$1);

(statearr_24698[(8)] = inst_24627__$1);

(statearr_24698[(10)] = inst_24626);

return statearr_24698;
})();
var statearr_24699_24750 = state_24693__$1;
(statearr_24699_24750[(2)] = null);

(statearr_24699_24750[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (27))){
var inst_24666 = (state_24693[(11)]);
var inst_24668 = cljs.core.count.call(null,inst_24666);
var inst_24669 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_24668);
var state_24693__$1 = state_24693;
var statearr_24700_24751 = state_24693__$1;
(statearr_24700_24751[(2)] = inst_24669);

(statearr_24700_24751[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (1))){
var state_24693__$1 = state_24693;
var statearr_24701_24752 = state_24693__$1;
(statearr_24701_24752[(2)] = null);

(statearr_24701_24752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (24))){
var state_24693__$1 = state_24693;
var statearr_24702_24753 = state_24693__$1;
(statearr_24702_24753[(2)] = null);

(statearr_24702_24753[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (4))){
var inst_24608 = (state_24693[(2)]);
var state_24693__$1 = state_24693;
var statearr_24703_24754 = state_24693__$1;
(statearr_24703_24754[(2)] = inst_24608);

(statearr_24703_24754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (15))){
var inst_24649 = (state_24693[(12)]);
var inst_24649__$1 = offset;
var state_24693__$1 = (function (){var statearr_24704 = state_24693;
(statearr_24704[(12)] = inst_24649__$1);

return statearr_24704;
})();
if(cljs.core.truth_(inst_24649__$1)){
var statearr_24705_24755 = state_24693__$1;
(statearr_24705_24755[(1)] = (17));

} else {
var statearr_24706_24756 = state_24693__$1;
(statearr_24706_24756[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (21))){
var state_24693__$1 = state_24693;
var statearr_24707_24757 = state_24693__$1;
(statearr_24707_24757[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (13))){
var inst_24644 = (state_24693[(2)]);
var state_24693__$1 = state_24693;
var statearr_24709_24758 = state_24693__$1;
(statearr_24709_24758[(2)] = inst_24644);

(statearr_24709_24758[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (22))){
var inst_24684 = (state_24693[(2)]);
var state_24693__$1 = state_24693;
var statearr_24710_24759 = state_24693__$1;
(statearr_24710_24759[(2)] = inst_24684);

(statearr_24710_24759[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (29))){
var inst_24627 = (state_24693[(8)]);
var inst_24666 = (state_24693[(11)]);
var inst_24672 = (state_24693[(2)]);
var inst_24673 = (inst_24627 + (1));
var inst_24674 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,inst_24666);
var state_24693__$1 = (function (){var statearr_24711 = state_24693;
(statearr_24711[(13)] = inst_24672);

(statearr_24711[(14)] = inst_24673);

return statearr_24711;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24693__$1,(30),inst_24674);
} else {
if((state_val_24694 === (6))){
var inst_24636 = (state_24693[(15)]);
var inst_24634 = (state_24693[(16)]);
var inst_24626 = (state_24693[(10)]);
var inst_24633 = cljs.core.seq.call(null,inst_24626);
var inst_24634__$1 = cljs.core.first.call(null,inst_24633);
var inst_24635 = cljs.core.next.call(null,inst_24633);
var inst_24636__$1 = (inst_24634__$1 == null);
var state_24693__$1 = (function (){var statearr_24712 = state_24693;
(statearr_24712[(15)] = inst_24636__$1);

(statearr_24712[(16)] = inst_24634__$1);

(statearr_24712[(9)] = inst_24635);

return statearr_24712;
})();
if(cljs.core.truth_(inst_24636__$1)){
var statearr_24713_24760 = state_24693__$1;
(statearr_24713_24760[(1)] = (8));

} else {
var statearr_24714_24761 = state_24693__$1;
(statearr_24714_24761[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (28))){
var state_24693__$1 = state_24693;
var statearr_24715_24762 = state_24693__$1;
(statearr_24715_24762[(2)] = null);

(statearr_24715_24762[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (25))){
var inst_24682 = (state_24693[(2)]);
var state_24693__$1 = state_24693;
var statearr_24716_24763 = state_24693__$1;
(statearr_24716_24763[(2)] = inst_24682);

(statearr_24716_24763[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (17))){
var inst_24627 = (state_24693[(8)]);
var inst_24651 = (inst_24627 < offset);
var state_24693__$1 = state_24693;
var statearr_24717_24764 = state_24693__$1;
(statearr_24717_24764[(2)] = inst_24651);

(statearr_24717_24764[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (3))){
var inst_24691 = (state_24693[(2)]);
var state_24693__$1 = state_24693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24693__$1,inst_24691);
} else {
if((state_val_24694 === (12))){
var inst_24639 = (state_24693[(17)]);
var state_24693__$1 = state_24693;
var statearr_24718_24765 = state_24693__$1;
(statearr_24718_24765[(2)] = inst_24639);

(statearr_24718_24765[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (2))){
var _ = (function (){var statearr_24719 = state_24693;
(statearr_24719[(4)] = cljs.core.cons.call(null,(5),(state_24693[(4)])));

return statearr_24719;
})();
var inst_24621 = subjects;
var inst_24622 = cljs.core.seq.call(null,inst_24621);
var inst_24623 = cljs.core.first.call(null,inst_24622);
var inst_24624 = cljs.core.next.call(null,inst_24622);
var inst_24625 = cljs.core.PersistentVector.EMPTY;
var inst_24626 = inst_24621;
var inst_24627 = (0);
var inst_24628 = inst_24625;
var state_24693__$1 = (function (){var statearr_24720 = state_24693;
(statearr_24720[(7)] = inst_24628);

(statearr_24720[(18)] = inst_24623);

(statearr_24720[(8)] = inst_24627);

(statearr_24720[(10)] = inst_24626);

(statearr_24720[(19)] = inst_24624);

return statearr_24720;
})();
var statearr_24721_24766 = state_24693__$1;
(statearr_24721_24766[(2)] = null);

(statearr_24721_24766[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (23))){
var inst_24634 = (state_24693[(16)]);
var inst_24660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24661 = [inst_24634];
var inst_24662 = (new cljs.core.PersistentVector(null,1,(5),inst_24660,inst_24661,null));
var inst_24663 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24662);
var state_24693__$1 = state_24693;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24693__$1,(26),inst_24663);
} else {
if((state_val_24694 === (19))){
var inst_24654 = (state_24693[(2)]);
var state_24693__$1 = state_24693;
if(cljs.core.truth_(inst_24654)){
var statearr_24722_24767 = state_24693__$1;
(statearr_24722_24767[(1)] = (20));

} else {
var statearr_24723_24768 = state_24693__$1;
(statearr_24723_24768[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (11))){
var inst_24627 = (state_24693[(8)]);
var inst_24641 = (inst_24627 > limit);
var state_24693__$1 = state_24693;
var statearr_24725_24769 = state_24693__$1;
(statearr_24725_24769[(2)] = inst_24641);

(statearr_24725_24769[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (9))){
var inst_24639 = (state_24693[(17)]);
var inst_24639__$1 = limit;
var state_24693__$1 = (function (){var statearr_24726 = state_24693;
(statearr_24726[(17)] = inst_24639__$1);

return statearr_24726;
})();
if(cljs.core.truth_(inst_24639__$1)){
var statearr_24727_24770 = state_24693__$1;
(statearr_24727_24770[(1)] = (11));

} else {
var statearr_24728_24771 = state_24693__$1;
(statearr_24728_24771[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (5))){
var _ = (function (){var statearr_24729 = state_24693;
(statearr_24729[(4)] = cljs.core.rest.call(null,(state_24693[(4)])));

return statearr_24729;
})();
var state_24693__$1 = state_24693;
var ex24724 = (state_24693__$1[(2)]);
var statearr_24730_24772 = state_24693__$1;
(statearr_24730_24772[(5)] = ex24724);


if((ex24724 instanceof Error)){
var statearr_24731_24773 = state_24693__$1;
(statearr_24731_24773[(1)] = (4));

(statearr_24731_24773[(5)] = null);

} else {
throw ex24724;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (14))){
var inst_24628 = (state_24693[(7)]);
var state_24693__$1 = state_24693;
var statearr_24732_24774 = state_24693__$1;
(statearr_24732_24774[(2)] = inst_24628);

(statearr_24732_24774[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (26))){
var inst_24665 = (state_24693[(2)]);
var inst_24666 = fluree.db.util.async.throw_err.call(null,inst_24665);
var state_24693__$1 = (function (){var statearr_24733 = state_24693;
(statearr_24733[(11)] = inst_24666);

return statearr_24733;
})();
if(cljs.core.truth_(fuel)){
var statearr_24734_24775 = state_24693__$1;
(statearr_24734_24775[(1)] = (27));

} else {
var statearr_24735_24776 = state_24693__$1;
(statearr_24735_24776[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (16))){
var inst_24686 = (state_24693[(2)]);
var state_24693__$1 = state_24693;
var statearr_24736_24777 = state_24693__$1;
(statearr_24736_24777[(2)] = inst_24686);

(statearr_24736_24777[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (30))){
var inst_24628 = (state_24693[(7)]);
var inst_24673 = (state_24693[(14)]);
var inst_24635 = (state_24693[(9)]);
var inst_24676 = (state_24693[(2)]);
var inst_24677 = fluree.db.util.async.throw_err.call(null,inst_24676);
var inst_24678 = cljs.core.conj.call(null,inst_24628,inst_24677);
var inst_24626 = inst_24635;
var inst_24627 = inst_24673;
var inst_24628__$1 = inst_24678;
var state_24693__$1 = (function (){var statearr_24737 = state_24693;
(statearr_24737[(7)] = inst_24628__$1);

(statearr_24737[(8)] = inst_24627);

(statearr_24737[(10)] = inst_24626);

return statearr_24737;
})();
var statearr_24738_24778 = state_24693__$1;
(statearr_24738_24778[(2)] = null);

(statearr_24738_24778[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (10))){
var inst_24646 = (state_24693[(2)]);
var state_24693__$1 = state_24693;
if(cljs.core.truth_(inst_24646)){
var statearr_24739_24779 = state_24693__$1;
(statearr_24739_24779[(1)] = (14));

} else {
var statearr_24740_24780 = state_24693__$1;
(statearr_24740_24780[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (18))){
var inst_24649 = (state_24693[(12)]);
var state_24693__$1 = state_24693;
var statearr_24741_24781 = state_24693__$1;
(statearr_24741_24781[(2)] = inst_24649);

(statearr_24741_24781[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24694 === (8))){
var inst_24636 = (state_24693[(15)]);
var state_24693__$1 = state_24693;
var statearr_24742_24782 = state_24693__$1;
(statearr_24742_24782[(2)] = inst_24636);

(statearr_24742_24782[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_24743 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24743[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_24743[(1)] = (1));

return statearr_24743;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_24693){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24744){var ex__2749__auto__ = e24744;
var statearr_24745_24783 = state_24693;
(statearr_24745_24783[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24693[(4)]))){
var statearr_24746_24784 = state_24693;
(statearr_24746_24784[(1)] = cljs.core.first.call(null,(state_24693[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24785 = state_24693;
state_24693 = G__24785;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_24693){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_24693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24747 = f__2769__auto__.call(null);
(statearr_24747[(6)] = c__2768__auto__);

return statearr_24747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24787 = arguments.length;
switch (G__24787) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__24788){
var map__24789 = p__24788;
var map__24789__$1 = cljs.core.__destructure_map.call(null,map__24789);
var limit = cljs.core.get.call(null,map__24789__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24789__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25053){
var state_val_25054 = (state_25053[(1)]);
if((state_val_25054 === (65))){
var inst_25016 = (state_25053[(7)]);
var inst_25016__$1 = (state_25053[(2)]);
var state_25053__$1 = (function (){var statearr_25055 = state_25053;
(statearr_25055[(7)] = inst_25016__$1);

return statearr_25055;
})();
if(cljs.core.truth_(inst_25016__$1)){
var statearr_25056_25174 = state_25053__$1;
(statearr_25056_25174[(1)] = (66));

} else {
var statearr_25057_25175 = state_25053__$1;
(statearr_25057_25175[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (70))){
var inst_25019 = (state_25053[(8)]);
var state_25053__$1 = state_25053;
var statearr_25058_25176 = state_25053__$1;
(statearr_25058_25176[(2)] = inst_25019);

(statearr_25058_25176[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (62))){
var inst_25007 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25059_25177 = state_25053__$1;
(statearr_25059_25177[(2)] = inst_25007);

(statearr_25059_25177[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (74))){
var inst_25026 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25060_25178 = state_25053__$1;
(statearr_25060_25178[(2)] = inst_25026);

(statearr_25060_25178[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (7))){
var inst_24802 = (state_25053[(9)]);
var state_25053__$1 = state_25053;
var statearr_25061_25179 = state_25053__$1;
(statearr_25061_25179[(2)] = inst_24802);

(statearr_25061_25179[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (59))){
var inst_24831 = (state_25053[(10)]);
var inst_24999 = cljs.core.empty_QMARK_.call(null,inst_24831);
var state_25053__$1 = state_25053;
if(inst_24999){
var statearr_25062_25180 = state_25053__$1;
(statearr_25062_25180[(1)] = (60));

} else {
var statearr_25063_25181 = state_25053__$1;
(statearr_25063_25181[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (20))){
var state_25053__$1 = state_25053;
if(cljs.core.truth_(offset)){
var statearr_25064_25182 = state_25053__$1;
(statearr_25064_25182[(1)] = (23));

} else {
var statearr_25065_25183 = state_25053__$1;
(statearr_25065_25183[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (72))){
var inst_24816 = (state_25053[(11)]);
var inst_24996 = (state_25053[(12)]);
var inst_25022 = cljs.core.count.call(null,inst_24996);
var inst_25023 = (inst_25022 > inst_24816);
var state_25053__$1 = state_25053;
var statearr_25066_25184 = state_25053__$1;
(statearr_25066_25184[(2)] = inst_25023);

(statearr_25066_25184[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (58))){
var inst_24831 = (state_25053[(10)]);
var inst_24996 = (state_25053[(12)]);
var inst_24997 = cljs.core.into.call(null,inst_24831,inst_24996);
var state_25053__$1 = state_25053;
var statearr_25067_25185 = state_25053__$1;
(statearr_25067_25185[(2)] = inst_24997);

(statearr_25067_25185[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (60))){
var inst_24831 = (state_25053[(10)]);
var inst_24996 = (state_25053[(12)]);
var inst_25001 = cljs.core.into.call(null,inst_24831,inst_24996);
var state_25053__$1 = state_25053;
var statearr_25068_25186 = state_25053__$1;
(statearr_25068_25186[(2)] = inst_25001);

(statearr_25068_25186[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (27))){
var inst_24846 = (state_25053[(13)]);
var state_25053__$1 = state_25053;
var statearr_25069_25187 = state_25053__$1;
(statearr_25069_25187[(2)] = inst_24846);

(statearr_25069_25187[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (1))){
var state_25053__$1 = state_25053;
var statearr_25070_25188 = state_25053__$1;
(statearr_25070_25188[(2)] = null);

(statearr_25070_25188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (69))){
var inst_24816 = (state_25053[(11)]);
var state_25053__$1 = state_25053;
if(cljs.core.truth_(inst_24816)){
var statearr_25071_25189 = state_25053__$1;
(statearr_25071_25189[(1)] = (72));

} else {
var statearr_25072_25190 = state_25053__$1;
(statearr_25072_25190[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (24))){
var inst_24831 = (state_25053[(10)]);
var state_25053__$1 = state_25053;
var statearr_25073_25191 = state_25053__$1;
(statearr_25073_25191[(2)] = inst_24831);

(statearr_25073_25191[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (55))){
var inst_24985 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25074_25192 = state_25053__$1;
(statearr_25074_25192[(2)] = inst_24985);

(statearr_25074_25192[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (39))){
var inst_24993 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25075_25193 = state_25053__$1;
(statearr_25075_25193[(2)] = inst_24993);

(statearr_25075_25193[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (46))){
var inst_24875 = (state_25053[(14)]);
var inst_24857 = (state_25053[(15)]);
var inst_24951 = inst_24875.call(null,cljs.core._LT_,inst_24857);
var state_25053__$1 = state_25053;
if(cljs.core.truth_(inst_24951)){
var statearr_25076_25194 = state_25053__$1;
(statearr_25076_25194[(1)] = (49));

} else {
var statearr_25077_25195 = state_25053__$1;
(statearr_25077_25195[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (4))){
var inst_24790 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25078_25196 = state_25053__$1;
(statearr_25078_25196[(2)] = inst_24790);

(statearr_25078_25196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (77))){
var inst_25041 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25079_25197 = state_25053__$1;
(statearr_25079_25197[(2)] = inst_25041);

(statearr_25079_25197[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (54))){
var inst_24983 = cljs.core.PersistentVector.EMPTY;
var state_25053__$1 = state_25053;
var statearr_25080_25198 = state_25053__$1;
(statearr_25080_25198[(2)] = inst_24983);

(statearr_25080_25198[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (15))){
var inst_24801 = (state_25053[(16)]);
var inst_24826 = cljs.core.seq.call(null,inst_24801);
var inst_24827 = cljs.core.first.call(null,inst_24826);
var inst_24828 = cljs.core.next.call(null,inst_24826);
var inst_24829 = cljs.core.PersistentHashSet.EMPTY;
var inst_24830 = inst_24801;
var inst_24831 = inst_24829;
var state_25053__$1 = (function (){var statearr_25081 = state_25053;
(statearr_25081[(17)] = inst_24827);

(statearr_25081[(10)] = inst_24831);

(statearr_25081[(18)] = inst_24828);

(statearr_25081[(19)] = inst_24830);

return statearr_25081;
})();
var statearr_25082_25199 = state_25053__$1;
(statearr_25082_25199[(2)] = null);

(statearr_25082_25199[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (48))){
var inst_24948 = (state_25053[(2)]);
var inst_24949 = fluree.db.util.async.throw_err.call(null,inst_24948);
var state_25053__$1 = state_25053;
var statearr_25083_25200 = state_25053__$1;
(statearr_25083_25200[(2)] = inst_24949);

(statearr_25083_25200[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (50))){
var inst_24875 = (state_25053[(14)]);
var inst_24857 = (state_25053[(15)]);
var inst_24967 = inst_24875.call(null,cljs.core._LT__EQ_,inst_24857);
var state_25053__$1 = state_25053;
if(cljs.core.truth_(inst_24967)){
var statearr_25084_25201 = state_25053__$1;
(statearr_25084_25201[(1)] = (53));

} else {
var statearr_25085_25202 = state_25053__$1;
(statearr_25085_25202[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (75))){
var state_25053__$1 = state_25053;
if(cljs.core.truth_(offset)){
var statearr_25086_25203 = state_25053__$1;
(statearr_25086_25203[(1)] = (78));

} else {
var statearr_25087_25204 = state_25053__$1;
(statearr_25087_25204[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (21))){
var inst_24856 = (state_25053[(20)]);
var inst_24837 = (state_25053[(21)]);
var inst_24856__$1 = cljs.core.nth.call(null,inst_24837,(0),null);
var inst_24857 = cljs.core.nth.call(null,inst_24837,(1),null);
var inst_24858 = cljs.core.nth.call(null,inst_24837,(2),null);
var inst_24859 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_24856__$1);
var inst_24860 = cljs.core.not.call(null,inst_24859);
var state_25053__$1 = (function (){var statearr_25088 = state_25053;
(statearr_25088[(22)] = inst_24858);

(statearr_25088[(20)] = inst_24856__$1);

(statearr_25088[(15)] = inst_24857);

return statearr_25088;
})();
if(inst_24860){
var statearr_25089_25205 = state_25053__$1;
(statearr_25089_25205[(1)] = (29));

} else {
var statearr_25090_25206 = state_25053__$1;
(statearr_25090_25206[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (31))){
var inst_24875 = (state_25053[(14)]);
var inst_24857 = (state_25053[(15)]);
var inst_24871 = (state_25053[(2)]);
var inst_24875__$1 = cljs.core.identical_QMARK_;
var inst_24876 = inst_24875__$1.call(null,cljs.core.not_EQ_,inst_24857);
var state_25053__$1 = (function (){var statearr_25091 = state_25053;
(statearr_25091[(14)] = inst_24875__$1);

(statearr_25091[(23)] = inst_24871);

return statearr_25091;
})();
if(cljs.core.truth_(inst_24876)){
var statearr_25092_25207 = state_25053__$1;
(statearr_25092_25207[(1)] = (32));

} else {
var statearr_25093_25208 = state_25053__$1;
(statearr_25093_25208[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (32))){
var inst_24816 = (state_25053[(11)]);
var inst_24858 = (state_25053[(22)]);
var inst_24856 = (state_25053[(20)]);
var inst_24878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24879 = [inst_24856,inst_24858];
var inst_24880 = (new cljs.core.PersistentVector(null,2,(5),inst_24878,inst_24879,null));
var inst_24881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24882 = [inst_24856];
var inst_24883 = (new cljs.core.PersistentVector(null,1,(5),inst_24881,inst_24882,null));
var inst_24884 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24885 = [inst_24816];
var inst_24886 = cljs.core.PersistentHashMap.fromArrays(inst_24884,inst_24885);
var inst_24887 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24880,cljs.core._LT__EQ_,inst_24883,inst_24886);
var state_25053__$1 = state_25053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25053__$1,(35),inst_24887);
} else {
if((state_val_25054 === (40))){
var inst_24916 = (state_25053[(2)]);
var inst_24917 = fluree.db.util.async.throw_err.call(null,inst_24916);
var state_25053__$1 = state_25053;
var statearr_25094_25209 = state_25053__$1;
(statearr_25094_25209[(2)] = inst_24917);

(statearr_25094_25209[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (56))){
var inst_24980 = (state_25053[(2)]);
var inst_24981 = fluree.db.util.async.throw_err.call(null,inst_24980);
var state_25053__$1 = state_25053;
var statearr_25095_25210 = state_25053__$1;
(statearr_25095_25210[(2)] = inst_24981);

(statearr_25095_25210[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (33))){
var inst_24875 = (state_25053[(14)]);
var inst_24857 = (state_25053[(15)]);
var inst_24906 = inst_24875.call(null,cljs.core._EQ_,inst_24857);
var state_25053__$1 = state_25053;
if(cljs.core.truth_(inst_24906)){
var statearr_25096_25211 = state_25053__$1;
(statearr_25096_25211[(1)] = (37));

} else {
var statearr_25097_25212 = state_25053__$1;
(statearr_25097_25212[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (13))){
var state_25053__$1 = state_25053;
var statearr_25098_25213 = state_25053__$1;
(statearr_25098_25213[(2)] = limit);

(statearr_25098_25213[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (22))){
var inst_25043 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25099_25214 = state_25053__$1;
(statearr_25099_25214[(2)] = inst_25043);

(statearr_25099_25214[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (36))){
var inst_24890 = (state_25053[(24)]);
var inst_24902 = (state_25053[(2)]);
var inst_24903 = fluree.db.util.async.throw_err.call(null,inst_24902);
var inst_24904 = cljs.core.concat.call(null,inst_24890,inst_24903);
var state_25053__$1 = state_25053;
var statearr_25100_25215 = state_25053__$1;
(statearr_25100_25215[(2)] = inst_24904);

(statearr_25100_25215[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (41))){
var inst_24816 = (state_25053[(11)]);
var inst_24858 = (state_25053[(22)]);
var inst_24856 = (state_25053[(20)]);
var inst_24921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24922 = [inst_24856,inst_24858];
var inst_24923 = (new cljs.core.PersistentVector(null,2,(5),inst_24921,inst_24922,null));
var inst_24924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24925 = [inst_24856];
var inst_24926 = (new cljs.core.PersistentVector(null,1,(5),inst_24924,inst_24925,null));
var inst_24927 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24928 = [inst_24816];
var inst_24929 = cljs.core.PersistentHashMap.fromArrays(inst_24927,inst_24928);
var inst_24930 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24923,cljs.core._LT__EQ_,inst_24926,inst_24929);
var state_25053__$1 = state_25053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25053__$1,(44),inst_24930);
} else {
if((state_val_25054 === (43))){
var inst_24991 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25101_25216 = state_25053__$1;
(statearr_25101_25216[(2)] = inst_24991);

(statearr_25101_25216[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (61))){
var inst_24831 = (state_25053[(10)]);
var inst_24996 = (state_25053[(12)]);
var inst_25003 = cljs.core.PersistentHashSet.EMPTY;
var inst_25004 = cljs.core.into.call(null,inst_25003,inst_24996);
var inst_25005 = clojure.set.intersection.call(null,inst_24831,inst_25004);
var state_25053__$1 = state_25053;
var statearr_25102_25217 = state_25053__$1;
(statearr_25102_25217[(2)] = inst_25005);

(statearr_25102_25217[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (29))){
var inst_24856 = (state_25053[(20)]);
var inst_24862 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24856);
var inst_24863 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24862)].join('');
var inst_24864 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24865 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24866 = cljs.core.PersistentHashMap.fromArrays(inst_24864,inst_24865);
var inst_24867 = cljs.core.ex_info.call(null,inst_24863,inst_24866);
var inst_24868 = (function(){throw inst_24867})();
var state_25053__$1 = state_25053;
var statearr_25103_25218 = state_25053__$1;
(statearr_25103_25218[(2)] = inst_24868);

(statearr_25103_25218[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (44))){
var inst_24932 = (state_25053[(2)]);
var inst_24933 = fluree.db.util.async.throw_err.call(null,inst_24932);
var state_25053__$1 = state_25053;
var statearr_25104_25219 = state_25053__$1;
(statearr_25104_25219[(2)] = inst_24933);

(statearr_25104_25219[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (6))){
var inst_24800 = (state_25053[(25)]);
var inst_24804 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24800);
var state_25053__$1 = state_25053;
var statearr_25105_25220 = state_25053__$1;
(statearr_25105_25220[(2)] = inst_24804);

(statearr_25105_25220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (28))){
var inst_24851 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25106_25221 = state_25053__$1;
(statearr_25106_25221[(2)] = inst_24851);

(statearr_25106_25221[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (64))){
var inst_25011 = (state_25053[(26)]);
var state_25053__$1 = state_25053;
var statearr_25107_25222 = state_25053__$1;
(statearr_25107_25222[(2)] = inst_25011);

(statearr_25107_25222[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (51))){
var inst_24987 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25108_25223 = state_25053__$1;
(statearr_25108_25223[(2)] = inst_24987);

(statearr_25108_25223[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (25))){
var inst_24846 = (state_25053[(2)]);
var state_25053__$1 = (function (){var statearr_25109 = state_25053;
(statearr_25109[(13)] = inst_24846);

return statearr_25109;
})();
if(cljs.core.truth_(limit)){
var statearr_25110_25224 = state_25053__$1;
(statearr_25110_25224[(1)] = (26));

} else {
var statearr_25111_25225 = state_25053__$1;
(statearr_25111_25225[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (34))){
var inst_24800 = (state_25053[(25)]);
var inst_24995 = (state_25053[(2)]);
var inst_24996 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_24995);
var state_25053__$1 = (function (){var statearr_25112 = state_25053;
(statearr_25112[(12)] = inst_24996);

return statearr_25112;
})();
var G__25113_25226 = inst_24800;
var G__25113_25227__$1 = (((G__25113_25226 instanceof cljs.core.Keyword))?G__25113_25226.fqn:null);
switch (G__25113_25227__$1) {
case "or":
var statearr_25114_25229 = state_25053__$1;
(statearr_25114_25229[(1)] = (58));


break;
case "and":
var statearr_25115_25230 = state_25053__$1;
(statearr_25115_25230[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25113_25227__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (17))){
var inst_25048 = (state_25053[(2)]);
var _ = (function (){var statearr_25116 = state_25053;
(statearr_25116[(4)] = cljs.core.rest.call(null,(state_25053[(4)])));

return statearr_25116;
})();
var state_25053__$1 = state_25053;
var statearr_25117_25231 = state_25053__$1;
(statearr_25117_25231[(2)] = inst_25048);

(statearr_25117_25231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (3))){
var inst_25051 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25053__$1,inst_25051);
} else {
if((state_val_25054 === (12))){
var inst_24810 = (offset + limit);
var state_25053__$1 = state_25053;
var statearr_25118_25232 = state_25053__$1;
(statearr_25118_25232[(2)] = inst_24810);

(statearr_25118_25232[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (2))){
var inst_24802 = (state_25053[(9)]);
var _ = (function (){var statearr_25119 = state_25053;
(statearr_25119[(4)] = cljs.core.cons.call(null,(5),(state_25053[(4)])));

return statearr_25119;
})();
var inst_24799 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_24800 = cljs.core.nth.call(null,inst_24799,(0),null);
var inst_24801 = cljs.core.nth.call(null,inst_24799,(1),null);
var inst_24802__$1 = limit;
var state_25053__$1 = (function (){var statearr_25120 = state_25053;
(statearr_25120[(9)] = inst_24802__$1);

(statearr_25120[(25)] = inst_24800);

(statearr_25120[(16)] = inst_24801);

return statearr_25120;
})();
if(cljs.core.truth_(inst_24802__$1)){
var statearr_25121_25233 = state_25053__$1;
(statearr_25121_25233[(1)] = (6));

} else {
var statearr_25122_25234 = state_25053__$1;
(statearr_25122_25234[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (66))){
var inst_25016 = (state_25053[(7)]);
var state_25053__$1 = state_25053;
var statearr_25123_25235 = state_25053__$1;
(statearr_25123_25235[(2)] = inst_25016);

(statearr_25123_25235[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (23))){
var inst_24831 = (state_25053[(10)]);
var inst_24843 = cljs.core.drop.call(null,offset,inst_24831);
var state_25053__$1 = state_25053;
var statearr_25124_25236 = state_25053__$1;
(statearr_25124_25236[(2)] = inst_24843);

(statearr_25124_25236[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (47))){
var inst_24989 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25125_25237 = state_25053__$1;
(statearr_25125_25237[(2)] = inst_24989);

(statearr_25125_25237[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (35))){
var inst_24816 = (state_25053[(11)]);
var inst_24858 = (state_25053[(22)]);
var inst_24856 = (state_25053[(20)]);
var inst_24889 = (state_25053[(2)]);
var inst_24890 = fluree.db.util.async.throw_err.call(null,inst_24889);
var inst_24891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24892 = [inst_24856];
var inst_24893 = (new cljs.core.PersistentVector(null,1,(5),inst_24891,inst_24892,null));
var inst_24894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24895 = [inst_24856,inst_24858];
var inst_24896 = (new cljs.core.PersistentVector(null,2,(5),inst_24894,inst_24895,null));
var inst_24897 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24898 = [inst_24816];
var inst_24899 = cljs.core.PersistentHashMap.fromArrays(inst_24897,inst_24898);
var inst_24900 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24893,cljs.core._LT_,inst_24896,inst_24899);
var state_25053__$1 = (function (){var statearr_25126 = state_25053;
(statearr_25126[(24)] = inst_24890);

return statearr_25126;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25053__$1,(36),inst_24900);
} else {
if((state_val_25054 === (76))){
var inst_25010 = (state_25053[(27)]);
var inst_24838 = (state_25053[(28)]);
var inst_24830 = inst_24838;
var inst_24831 = inst_25010;
var state_25053__$1 = (function (){var statearr_25127 = state_25053;
(statearr_25127[(10)] = inst_24831);

(statearr_25127[(19)] = inst_24830);

return statearr_25127;
})();
var statearr_25128_25238 = state_25053__$1;
(statearr_25128_25238[(2)] = null);

(statearr_25128_25238[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (19))){
var inst_25045 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25129_25239 = state_25053__$1;
(statearr_25129_25239[(2)] = inst_25045);

(statearr_25129_25239[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (57))){
var inst_24800 = (state_25053[(25)]);
var inst_25011 = (state_25053[(26)]);
var inst_25010 = (state_25053[(2)]);
var inst_25011__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24800);
var state_25053__$1 = (function (){var statearr_25130 = state_25053;
(statearr_25130[(27)] = inst_25010);

(statearr_25130[(26)] = inst_25011__$1);

return statearr_25130;
})();
if(inst_25011__$1){
var statearr_25131_25240 = state_25053__$1;
(statearr_25131_25240[(1)] = (63));

} else {
var statearr_25132_25241 = state_25053__$1;
(statearr_25132_25241[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (68))){
var inst_25031 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
if(cljs.core.truth_(inst_25031)){
var statearr_25133_25242 = state_25053__$1;
(statearr_25133_25242[(1)] = (75));

} else {
var statearr_25134_25243 = state_25053__$1;
(statearr_25134_25243[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (11))){
var inst_24801 = (state_25053[(16)]);
var inst_24816 = (state_25053[(2)]);
var inst_24817 = cljs.core.not_empty.call(null,inst_24801);
var state_25053__$1 = (function (){var statearr_25136 = state_25053;
(statearr_25136[(11)] = inst_24816);

return statearr_25136;
})();
if(cljs.core.truth_(inst_24817)){
var statearr_25137_25244 = state_25053__$1;
(statearr_25137_25244[(1)] = (15));

} else {
var statearr_25138_25245 = state_25053__$1;
(statearr_25138_25245[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (9))){
var state_25053__$1 = state_25053;
if(cljs.core.truth_(offset)){
var statearr_25139_25246 = state_25053__$1;
(statearr_25139_25246[(1)] = (12));

} else {
var statearr_25140_25247 = state_25053__$1;
(statearr_25140_25247[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (5))){
var _ = (function (){var statearr_25141 = state_25053;
(statearr_25141[(4)] = cljs.core.rest.call(null,(state_25053[(4)])));

return statearr_25141;
})();
var state_25053__$1 = state_25053;
var ex25135 = (state_25053__$1[(2)]);
var statearr_25142_25248 = state_25053__$1;
(statearr_25142_25248[(5)] = ex25135);


if((ex25135 instanceof Error)){
var statearr_25143_25249 = state_25053__$1;
(statearr_25143_25249[(1)] = (4));

(statearr_25143_25249[(5)] = null);

} else {
throw ex25135;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (14))){
var inst_24813 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25144_25250 = state_25053__$1;
(statearr_25144_25250[(2)] = inst_24813);

(statearr_25144_25250[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (45))){
var inst_24816 = (state_25053[(11)]);
var inst_24858 = (state_25053[(22)]);
var inst_24856 = (state_25053[(20)]);
var inst_24937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24938 = [inst_24856,inst_24858];
var inst_24939 = (new cljs.core.PersistentVector(null,2,(5),inst_24937,inst_24938,null));
var inst_24940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24941 = [inst_24856];
var inst_24942 = (new cljs.core.PersistentVector(null,1,(5),inst_24940,inst_24941,null));
var inst_24943 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24944 = [inst_24816];
var inst_24945 = cljs.core.PersistentHashMap.fromArrays(inst_24943,inst_24944);
var inst_24946 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24939,cljs.core._LT__EQ_,inst_24942,inst_24945);
var state_25053__$1 = state_25053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25053__$1,(48),inst_24946);
} else {
if((state_val_25054 === (53))){
var inst_24816 = (state_25053[(11)]);
var inst_24858 = (state_25053[(22)]);
var inst_24856 = (state_25053[(20)]);
var inst_24969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24970 = [inst_24856];
var inst_24971 = (new cljs.core.PersistentVector(null,1,(5),inst_24969,inst_24970,null));
var inst_24972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24973 = [inst_24856,inst_24858];
var inst_24974 = (new cljs.core.PersistentVector(null,2,(5),inst_24972,inst_24973,null));
var inst_24975 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24976 = [inst_24816];
var inst_24977 = cljs.core.PersistentHashMap.fromArrays(inst_24975,inst_24976);
var inst_24978 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24971,cljs.core._LT__EQ_,inst_24974,inst_24977);
var state_25053__$1 = state_25053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25053__$1,(56),inst_24978);
} else {
if((state_val_25054 === (78))){
var inst_25010 = (state_25053[(27)]);
var inst_25034 = cljs.core.drop.call(null,offset,inst_25010);
var state_25053__$1 = state_25053;
var statearr_25145_25251 = state_25053__$1;
(statearr_25145_25251[(2)] = inst_25034);

(statearr_25145_25251[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (26))){
var inst_24846 = (state_25053[(13)]);
var inst_24848 = cljs.core.take.call(null,limit,inst_24846);
var state_25053__$1 = state_25053;
var statearr_25146_25252 = state_25053__$1;
(statearr_25146_25252[(2)] = inst_24848);

(statearr_25146_25252[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (16))){
var state_25053__$1 = state_25053;
var statearr_25147_25253 = state_25053__$1;
(statearr_25147_25253[(2)] = null);

(statearr_25147_25253[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (79))){
var inst_25010 = (state_25053[(27)]);
var state_25053__$1 = state_25053;
var statearr_25148_25254 = state_25053__$1;
(statearr_25148_25254[(2)] = inst_25010);

(statearr_25148_25254[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (38))){
var inst_24875 = (state_25053[(14)]);
var inst_24857 = (state_25053[(15)]);
var inst_24919 = inst_24875.call(null,cljs.core._GT_,inst_24857);
var state_25053__$1 = state_25053;
if(cljs.core.truth_(inst_24919)){
var statearr_25149_25255 = state_25053__$1;
(statearr_25149_25255[(1)] = (41));

} else {
var statearr_25150_25256 = state_25053__$1;
(statearr_25150_25256[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (30))){
var state_25053__$1 = state_25053;
var statearr_25151_25257 = state_25053__$1;
(statearr_25151_25257[(2)] = null);

(statearr_25151_25257[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (73))){
var inst_24816 = (state_25053[(11)]);
var state_25053__$1 = state_25053;
var statearr_25152_25258 = state_25053__$1;
(statearr_25152_25258[(2)] = inst_24816);

(statearr_25152_25258[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (10))){
var state_25053__$1 = state_25053;
var statearr_25153_25259 = state_25053__$1;
(statearr_25153_25259[(2)] = null);

(statearr_25153_25259[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (18))){
var inst_24837 = (state_25053[(21)]);
var inst_24830 = (state_25053[(19)]);
var inst_24836 = cljs.core.seq.call(null,inst_24830);
var inst_24837__$1 = cljs.core.first.call(null,inst_24836);
var inst_24838 = cljs.core.next.call(null,inst_24836);
var inst_24839 = cljs.core.not.call(null,inst_24837__$1);
var state_25053__$1 = (function (){var statearr_25154 = state_25053;
(statearr_25154[(21)] = inst_24837__$1);

(statearr_25154[(28)] = inst_24838);

return statearr_25154;
})();
if(inst_24839){
var statearr_25155_25260 = state_25053__$1;
(statearr_25155_25260[(1)] = (20));

} else {
var statearr_25156_25261 = state_25053__$1;
(statearr_25156_25261[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (52))){
var inst_24964 = (state_25053[(2)]);
var inst_24965 = fluree.db.util.async.throw_err.call(null,inst_24964);
var state_25053__$1 = state_25053;
var statearr_25157_25262 = state_25053__$1;
(statearr_25157_25262[(2)] = inst_24965);

(statearr_25157_25262[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (67))){
var inst_25019 = (state_25053[(8)]);
var inst_24800 = (state_25053[(25)]);
var inst_25019__$1 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24800);
var state_25053__$1 = (function (){var statearr_25158 = state_25053;
(statearr_25158[(8)] = inst_25019__$1);

return statearr_25158;
})();
if(inst_25019__$1){
var statearr_25159_25263 = state_25053__$1;
(statearr_25159_25263[(1)] = (69));

} else {
var statearr_25160_25264 = state_25053__$1;
(statearr_25160_25264[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (71))){
var inst_25029 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25161_25265 = state_25053__$1;
(statearr_25161_25265[(2)] = inst_25029);

(statearr_25161_25265[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (42))){
var inst_24875 = (state_25053[(14)]);
var inst_24857 = (state_25053[(15)]);
var inst_24935 = inst_24875.call(null,cljs.core._GT__EQ_,inst_24857);
var state_25053__$1 = state_25053;
if(cljs.core.truth_(inst_24935)){
var statearr_25162_25266 = state_25053__$1;
(statearr_25162_25266[(1)] = (45));

} else {
var statearr_25163_25267 = state_25053__$1;
(statearr_25163_25267[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (80))){
var inst_25037 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
var statearr_25164_25268 = state_25053__$1;
(statearr_25164_25268[(2)] = inst_25037);

(statearr_25164_25268[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (37))){
var inst_24816 = (state_25053[(11)]);
var inst_24858 = (state_25053[(22)]);
var inst_24856 = (state_25053[(20)]);
var inst_24908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24909 = [inst_24856,inst_24858];
var inst_24910 = (new cljs.core.PersistentVector(null,2,(5),inst_24908,inst_24909,null));
var inst_24911 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24912 = [inst_24816];
var inst_24913 = cljs.core.PersistentHashMap.fromArrays(inst_24911,inst_24912);
var inst_24914 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_24910,inst_24913);
var state_25053__$1 = state_25053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25053__$1,(40),inst_24914);
} else {
if((state_val_25054 === (63))){
var inst_25010 = (state_25053[(27)]);
var inst_25013 = cljs.core.empty_QMARK_.call(null,inst_25010);
var state_25053__$1 = state_25053;
var statearr_25165_25269 = state_25053__$1;
(statearr_25165_25269[(2)] = inst_25013);

(statearr_25165_25269[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (8))){
var inst_24807 = (state_25053[(2)]);
var state_25053__$1 = state_25053;
if(cljs.core.truth_(inst_24807)){
var statearr_25166_25270 = state_25053__$1;
(statearr_25166_25270[(1)] = (9));

} else {
var statearr_25167_25271 = state_25053__$1;
(statearr_25167_25271[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25054 === (49))){
var inst_24816 = (state_25053[(11)]);
var inst_24858 = (state_25053[(22)]);
var inst_24856 = (state_25053[(20)]);
var inst_24953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24954 = [inst_24856];
var inst_24955 = (new cljs.core.PersistentVector(null,1,(5),inst_24953,inst_24954,null));
var inst_24956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24957 = [inst_24856,inst_24858];
var inst_24958 = (new cljs.core.PersistentVector(null,2,(5),inst_24956,inst_24957,null));
var inst_24959 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24960 = [inst_24816];
var inst_24961 = cljs.core.PersistentHashMap.fromArrays(inst_24959,inst_24960);
var inst_24962 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24955,cljs.core._LT_,inst_24958,inst_24961);
var state_25053__$1 = state_25053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25053__$1,(52),inst_24962);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_25168 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25168[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_25168[(1)] = (1));

return statearr_25168;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_25053){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25053);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25169){var ex__2749__auto__ = e25169;
var statearr_25170_25272 = state_25053;
(statearr_25170_25272[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25053[(4)]))){
var statearr_25171_25273 = state_25053;
(statearr_25171_25273[(1)] = cljs.core.first.call(null,(state_25053[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25274 = state_25053;
state_25053 = G__25274;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_25053){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_25053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25172 = f__2769__auto__.call(null);
(statearr_25172[(6)] = c__2768__auto__);

return statearr_25172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__5045__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__25275_SHARP_){
return ((typeof p1__25275_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__25275_SHARP_)));
}),select_smt);
if(or__5045__auto__){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__25276_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__25276_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__25280 = vars;
var vec__25281 = G__25280;
var seq__25282 = cljs.core.seq.call(null,vec__25281);
var first__25283 = cljs.core.first.call(null,seq__25282);
var seq__25282__$1 = cljs.core.next.call(null,seq__25282);
var var$ = first__25283;
var r = seq__25282__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__25280__$1 = G__25280;
var all_vars__$1 = all_vars;
while(true){
var vec__25287 = G__25280__$1;
var seq__25288 = cljs.core.seq.call(null,vec__25287);
var first__25289 = cljs.core.first.call(null,seq__25288);
var seq__25288__$1 = cljs.core.next.call(null,seq__25288);
var var$__$1 = first__25289;
var r__$1 = seq__25288__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__25290 = r__$1;
var G__25291 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__25280__$1 = G__25290;
all_vars__$1 = G__25291;
continue;
} else {
var G__25292 = r__$1;
var G__25293 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__25280__$1 = G__25292;
all_vars__$1 = G__25293;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25328){
var state_val_25329 = (state_25328[(1)]);
if((state_val_25329 === (1))){
var inst_25301 = functionArray;
var inst_25302 = cljs.core.seq.call(null,inst_25301);
var inst_25303 = cljs.core.first.call(null,inst_25302);
var inst_25304 = cljs.core.next.call(null,inst_25302);
var inst_25305 = cljs.core.PersistentVector.EMPTY;
var inst_25306 = inst_25301;
var inst_25307 = inst_25305;
var state_25328__$1 = (function (){var statearr_25330 = state_25328;
(statearr_25330[(7)] = inst_25307);

(statearr_25330[(8)] = inst_25304);

(statearr_25330[(9)] = inst_25306);

(statearr_25330[(10)] = inst_25303);

return statearr_25330;
})();
var statearr_25331_25344 = state_25328__$1;
(statearr_25331_25344[(2)] = null);

(statearr_25331_25344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25329 === (2))){
var inst_25306 = (state_25328[(9)]);
var inst_25313 = (state_25328[(11)]);
var inst_25312 = cljs.core.seq.call(null,inst_25306);
var inst_25313__$1 = cljs.core.first.call(null,inst_25312);
var inst_25314 = cljs.core.next.call(null,inst_25312);
var state_25328__$1 = (function (){var statearr_25332 = state_25328;
(statearr_25332[(12)] = inst_25314);

(statearr_25332[(11)] = inst_25313__$1);

return statearr_25332;
})();
if(cljs.core.truth_(inst_25313__$1)){
var statearr_25333_25345 = state_25328__$1;
(statearr_25333_25345[(1)] = (4));

} else {
var statearr_25334_25346 = state_25328__$1;
(statearr_25334_25346[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25329 === (3))){
var inst_25326 = (state_25328[(2)]);
var state_25328__$1 = state_25328;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25328__$1,inst_25326);
} else {
if((state_val_25329 === (4))){
var inst_25313 = (state_25328[(11)]);
var inst_25316 = inst_25313.call(null,tuple);
var state_25328__$1 = state_25328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25328__$1,(7),inst_25316);
} else {
if((state_val_25329 === (5))){
var inst_25307 = (state_25328[(7)]);
var state_25328__$1 = state_25328;
var statearr_25335_25347 = state_25328__$1;
(statearr_25335_25347[(2)] = inst_25307);

(statearr_25335_25347[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25329 === (6))){
var inst_25324 = (state_25328[(2)]);
var state_25328__$1 = state_25328;
var statearr_25336_25348 = state_25328__$1;
(statearr_25336_25348[(2)] = inst_25324);

(statearr_25336_25348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25329 === (7))){
var inst_25307 = (state_25328[(7)]);
var inst_25314 = (state_25328[(12)]);
var inst_25318 = (state_25328[(2)]);
var inst_25319 = fluree.db.util.async.throw_err.call(null,inst_25318);
var inst_25320 = cljs.core.conj.call(null,inst_25307,inst_25319);
var inst_25306 = inst_25314;
var inst_25307__$1 = inst_25320;
var state_25328__$1 = (function (){var statearr_25337 = state_25328;
(statearr_25337[(7)] = inst_25307__$1);

(statearr_25337[(9)] = inst_25306);

return statearr_25337;
})();
var statearr_25338_25349 = state_25328__$1;
(statearr_25338_25349[(2)] = null);

(statearr_25338_25349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____0 = (function (){
var statearr_25339 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25339[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__);

(statearr_25339[(1)] = (1));

return statearr_25339;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____1 = (function (state_25328){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25328);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25340){var ex__2749__auto__ = e25340;
var statearr_25341_25350 = state_25328;
(statearr_25341_25350[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25328[(4)]))){
var statearr_25342_25351 = state_25328;
(statearr_25342_25351[(1)] = cljs.core.first.call(null,(state_25328[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25352 = state_25328;
state_25328 = G__25352;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__ = function(state_25328){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____1.call(this,state_25328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2746__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25343 = f__2769__auto__.call(null);
(statearr_25343[(6)] = c__2768__auto__);

return statearr_25343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__25353){
var vec__25354 = p__25353;
var tuple_index = cljs.core.nth.call(null,vec__25354,(0),null);
var query_map = cljs.core.nth.call(null,vec__25354,(1),null);
var temp__5804__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25368){
var state_val_25369 = (state_25368[(1)]);
if((state_val_25369 === (1))){
var inst_25357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25358 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_25359 = [query_map,_id,query_opts];
var inst_25360 = cljs.core.PersistentHashMap.fromArrays(inst_25358,inst_25359);
var inst_25361 = fluree.db.query.fql.query.call(null,db,inst_25360);
var state_25368__$1 = (function (){var statearr_25370 = state_25368;
(statearr_25370[(7)] = inst_25357);

return statearr_25370;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25368__$1,(2),inst_25361);
} else {
if((state_val_25369 === (2))){
var inst_25357 = (state_25368[(7)]);
var inst_25363 = (state_25368[(2)]);
var inst_25364 = fluree.db.util.async.throw_err.call(null,inst_25363);
var inst_25365 = [tuple_index,inst_25364];
var inst_25366 = (new cljs.core.PersistentVector(null,2,(5),inst_25357,inst_25365,null));
var state_25368__$1 = state_25368;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25368__$1,inst_25366);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0 = (function (){
var statearr_25371 = [null,null,null,null,null,null,null,null];
(statearr_25371[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2746__auto__);

(statearr_25371[(1)] = (1));

return statearr_25371;
});
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1 = (function (state_25368){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25372){var ex__2749__auto__ = e25372;
var statearr_25373_25376 = state_25368;
(statearr_25373_25376[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25368[(4)]))){
var statearr_25374_25377 = state_25368;
(statearr_25374_25377[(1)] = cljs.core.first.call(null,(state_25368[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25378 = state_25368;
state_25368 = G__25378;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = function(state_25368){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1.call(this,state_25368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25375 = f__2769__auto__.call(null);
(statearr_25375[(6)] = c__2768__auto__);

return statearr_25375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__25379 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__25379,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__25379,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25442){
var state_val_25443 = (state_25442[(1)]);
if((state_val_25443 === (7))){
var inst_25437 = (state_25442[(2)]);
var _ = (function (){var statearr_25444 = state_25442;
(statearr_25444[(4)] = cljs.core.rest.call(null,(state_25442[(4)])));

return statearr_25444;
})();
var state_25442__$1 = state_25442;
var statearr_25445_25536 = state_25442__$1;
(statearr_25445_25536[(2)] = inst_25437);

(statearr_25445_25536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (20))){
var inst_25428 = (state_25442[(2)]);
var state_25442__$1 = state_25442;
var statearr_25446_25537 = state_25442__$1;
(statearr_25446_25537[(2)] = inst_25428);

(statearr_25446_25537[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (1))){
var state_25442__$1 = state_25442;
var statearr_25447_25538 = state_25442__$1;
(statearr_25447_25538[(2)] = null);

(statearr_25447_25538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (4))){
var inst_25384 = (state_25442[(2)]);
var state_25442__$1 = state_25442;
var statearr_25448_25539 = state_25442__$1;
(statearr_25448_25539[(2)] = inst_25384);

(statearr_25448_25539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (15))){
var inst_25404 = (state_25442[(7)]);
var inst_25413 = cljs.core.second.call(null,inst_25404);
var inst_25414 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_25413);
var inst_25415 = (inst_25414 > max_fuel);
var state_25442__$1 = state_25442;
if(cljs.core.truth_(inst_25415)){
var statearr_25449_25540 = state_25442__$1;
(statearr_25449_25540[(1)] = (18));

} else {
var statearr_25450_25541 = state_25442__$1;
(statearr_25450_25541[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (13))){
var state_25442__$1 = state_25442;
var statearr_25451_25542 = state_25442__$1;
(statearr_25451_25542[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (6))){
var inst_25392 = (state_25442[(8)]);
var state_25442__$1 = state_25442;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25442__$1,(8),inst_25392);
} else {
if((state_val_25443 === (17))){
var inst_25431 = (state_25442[(2)]);
var state_25442__$1 = state_25442;
var statearr_25453_25543 = state_25442__$1;
(statearr_25453_25543[(2)] = inst_25431);

(statearr_25453_25543[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (3))){
var inst_25440 = (state_25442[(2)]);
var state_25442__$1 = state_25442;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25442__$1,inst_25440);
} else {
if((state_val_25443 === (12))){
var inst_25404 = (state_25442[(7)]);
var inst_25393 = (state_25442[(9)]);
var inst_25410 = inst_25393.call(null);
var state_25442__$1 = (function (){var statearr_25454 = state_25442;
(statearr_25454[(10)] = inst_25410);

return statearr_25454;
})();
var statearr_25455_25544 = state_25442__$1;
(statearr_25455_25544[(2)] = inst_25404);

(statearr_25455_25544[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (2))){
var inst_25392 = (state_25442[(8)]);
var inst_25393 = (state_25442[(9)]);
var _ = (function (){var statearr_25456 = state_25442;
(statearr_25456[(4)] = cljs.core.cons.call(null,(5),(state_25442[(4)])));

return statearr_25456;
})();
var inst_25390 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_25391 = cljs.core.async.chan.call(null);
var inst_25392__$1 = cljs.core.async.chan.call(null);
var inst_25393__$1 = (function (){var expandMaps = inst_25390;
var queue_ch = inst_25391;
var res_ch = inst_25392__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_25394 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_25395 = cljs.core.volatile_BANG_.call(null,(0));
var inst_25396 = cljs.core.assoc.call(null,inst_25394,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_25395);
var inst_25397 = (function (){var expandMaps = inst_25390;
var queue_ch = inst_25391;
var res_ch = inst_25392__$1;
var stop_BANG_ = inst_25393__$1;
var opts_STAR_ = inst_25396;
return (function (tuple_res,port){
var c__2768__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25489){
var state_val_25490 = (state_25489[(1)]);
if((state_val_25490 === (7))){
var state_25489__$1 = state_25489;
var statearr_25491_25545 = state_25489__$1;
(statearr_25491_25545[(2)] = tuple_res);

(statearr_25491_25545[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (1))){
var state_25489__$1 = state_25489;
var statearr_25492_25546 = state_25489__$1;
(statearr_25492_25546[(2)] = null);

(statearr_25492_25546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (4))){
var inst_25457 = (state_25489[(2)]);
var inst_25458 = cljs.core.async.put_BANG_.call(null,port,inst_25457);
var inst_25459 = cljs.core.async.close_BANG_.call(null,port);
var state_25489__$1 = (function (){var statearr_25493 = state_25489;
(statearr_25493[(7)] = inst_25458);

return statearr_25493;
})();
var statearr_25494_25547 = state_25489__$1;
(statearr_25494_25547[(2)] = inst_25459);

(statearr_25494_25547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (6))){
var inst_25466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25467 = [tuple_res];
var inst_25468 = (new cljs.core.PersistentVector(null,1,(5),inst_25466,inst_25467,null));
var state_25489__$1 = state_25489;
var statearr_25495_25548 = state_25489__$1;
(statearr_25495_25548[(2)] = inst_25468);

(statearr_25495_25548[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (3))){
var inst_25487 = (state_25489[(2)]);
var state_25489__$1 = state_25489;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25489__$1,inst_25487);
} else {
if((state_val_25490 === (2))){
var ___$1 = (function (){var statearr_25497 = state_25489;
(statearr_25497[(4)] = cljs.core.cons.call(null,(5),(state_25489[(4)])));

return statearr_25497;
})();
var state_25489__$1 = state_25489;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_25498_25549 = state_25489__$1;
(statearr_25498_25549[(1)] = (6));

} else {
var statearr_25499_25550 = state_25489__$1;
(statearr_25499_25550[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (9))){
var inst_25471 = (state_25489[(8)]);
var inst_25473 = (state_25489[(9)]);
var inst_25480 = (state_25489[(2)]);
var inst_25481 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_25471,inst_25480);
var inst_25482 = inst_25473.call(null,inst_25481);
var inst_25483 = cljs.core.async.put_BANG_.call(null,port,inst_25482);
var inst_25484 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_25500 = state_25489;
(statearr_25500[(4)] = cljs.core.rest.call(null,(state_25489[(4)])));

return statearr_25500;
})();
var state_25489__$1 = (function (){var statearr_25501 = state_25489;
(statearr_25501[(10)] = inst_25483);

return statearr_25501;
})();
var statearr_25502_25551 = state_25489__$1;
(statearr_25502_25551[(2)] = inst_25484);

(statearr_25502_25551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (5))){
var ___$1 = (function (){var statearr_25503 = state_25489;
(statearr_25503[(4)] = cljs.core.rest.call(null,(state_25489[(4)])));

return statearr_25503;
})();
var state_25489__$1 = state_25489;
var ex25496 = (state_25489__$1[(2)]);
var statearr_25504_25552 = state_25489__$1;
(statearr_25504_25552[(5)] = ex25496);


var statearr_25505_25553 = state_25489__$1;
(statearr_25505_25553[(1)] = (4));

(statearr_25505_25553[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (8))){
var inst_25471 = (state_25489[(8)]);
var inst_25471__$1 = (state_25489[(2)]);
var inst_25472 = cljs.core.volatile_BANG_.call(null,(0));
var inst_25473 = (function (){var tuple_res_SINGLEQUOTE_ = inst_25471__$1;
var query_fuel = inst_25472;
return (function (p1__25383_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__25383_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25383_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_25474 = cljs.core.PersistentVector.EMPTY;
var inst_25475 = (function (){var tuple_res_SINGLEQUOTE_ = inst_25471__$1;
var query_fuel = inst_25472;
return (function (p1__25382_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__25382_SHARP_);
});
})();
var inst_25476 = cljs.core.keep.call(null,inst_25475,expandMaps);
var inst_25477 = cljs.core.async.merge.call(null,inst_25476);
var inst_25478 = cljs.core.async.into.call(null,inst_25474,inst_25477);
var state_25489__$1 = (function (){var statearr_25506 = state_25489;
(statearr_25506[(8)] = inst_25471__$1);

(statearr_25506[(9)] = inst_25473);

return statearr_25506;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25489__$1,(9),inst_25478);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_25507 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25507[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_25507[(1)] = (1));

return statearr_25507;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_25489){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25508){var ex__2749__auto__ = e25508;
var statearr_25509_25554 = state_25489;
(statearr_25509_25554[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25489[(4)]))){
var statearr_25510_25555 = state_25489;
(statearr_25510_25555[(1)] = cljs.core.first.call(null,(state_25489[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25556 = state_25489;
state_25489 = G__25556;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_25489){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_25489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25511 = f__2769__auto__.call(null);
(statearr_25511[(6)] = c__2768__auto____$1);

return statearr_25511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto____$1;
});
})();
var inst_25398 = cljs.core.async.onto_chan_BANG_.call(null,inst_25391,tuples_res);
var inst_25399 = cljs.core.async.pipeline_async.call(null,parallelism,inst_25392__$1,inst_25397,inst_25391);
var inst_25400 = cljs.core.PersistentVector.EMPTY;
var inst_25401 = inst_25400;
var state_25442__$1 = (function (){var statearr_25512 = state_25442;
(statearr_25512[(11)] = inst_25399);

(statearr_25512[(8)] = inst_25392__$1);

(statearr_25512[(12)] = inst_25398);

(statearr_25512[(9)] = inst_25393__$1);

(statearr_25512[(13)] = inst_25401);

return statearr_25512;
})();
var statearr_25513_25557 = state_25442__$1;
(statearr_25513_25557[(2)] = null);

(statearr_25513_25557[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (19))){
var inst_25404 = (state_25442[(7)]);
var inst_25401 = (state_25442[(13)]);
var inst_25424 = cljs.core.first.call(null,inst_25404);
var inst_25425 = cljs.core.conj.call(null,inst_25401,inst_25424);
var inst_25401__$1 = inst_25425;
var state_25442__$1 = (function (){var statearr_25514 = state_25442;
(statearr_25514[(13)] = inst_25401__$1);

return statearr_25514;
})();
var statearr_25515_25558 = state_25442__$1;
(statearr_25515_25558[(2)] = null);

(statearr_25515_25558[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (11))){
var inst_25435 = (state_25442[(2)]);
var state_25442__$1 = state_25442;
var statearr_25517_25559 = state_25442__$1;
(statearr_25517_25559[(2)] = inst_25435);

(statearr_25517_25559[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (9))){
var inst_25401 = (state_25442[(13)]);
var state_25442__$1 = state_25442;
var statearr_25518_25560 = state_25442__$1;
(statearr_25518_25560[(2)] = inst_25401);

(statearr_25518_25560[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (5))){
var _ = (function (){var statearr_25519 = state_25442;
(statearr_25519[(4)] = cljs.core.rest.call(null,(state_25442[(4)])));

return statearr_25519;
})();
var state_25442__$1 = state_25442;
var ex25516 = (state_25442__$1[(2)]);
var statearr_25520_25561 = state_25442__$1;
(statearr_25520_25561[(5)] = ex25516);


if((ex25516 instanceof Error)){
var statearr_25521_25562 = state_25442__$1;
(statearr_25521_25562[(1)] = (4));

(statearr_25521_25562[(5)] = null);

} else {
throw ex25516;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (14))){
var inst_25433 = (state_25442[(2)]);
var state_25442__$1 = state_25442;
var statearr_25522_25563 = state_25442__$1;
(statearr_25522_25563[(2)] = inst_25433);

(statearr_25522_25563[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (16))){
var state_25442__$1 = state_25442;
var statearr_25523_25564 = state_25442__$1;
(statearr_25523_25564[(2)] = null);

(statearr_25523_25564[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (10))){
var inst_25404 = (state_25442[(7)]);
var inst_25408 = fluree.db.util.core.exception_QMARK_.call(null,inst_25404);
var state_25442__$1 = state_25442;
if(inst_25408){
var statearr_25524_25565 = state_25442__$1;
(statearr_25524_25565[(1)] = (12));

} else {
var statearr_25525_25566 = state_25442__$1;
(statearr_25525_25566[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (18))){
var inst_25393 = (state_25442[(9)]);
var inst_25417 = inst_25393.call(null);
var inst_25418 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_25419 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25420 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_25421 = cljs.core.PersistentHashMap.fromArrays(inst_25419,inst_25420);
var inst_25422 = cljs.core.ex_info.call(null,inst_25418,inst_25421);
var state_25442__$1 = (function (){var statearr_25526 = state_25442;
(statearr_25526[(14)] = inst_25417);

return statearr_25526;
})();
var statearr_25527_25567 = state_25442__$1;
(statearr_25527_25567[(2)] = inst_25422);

(statearr_25527_25567[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25443 === (8))){
var inst_25404 = (state_25442[(7)]);
var inst_25404__$1 = (state_25442[(2)]);
var inst_25405 = (inst_25404__$1 == null);
var state_25442__$1 = (function (){var statearr_25528 = state_25442;
(statearr_25528[(7)] = inst_25404__$1);

return statearr_25528;
})();
if(cljs.core.truth_(inst_25405)){
var statearr_25529_25568 = state_25442__$1;
(statearr_25529_25568[(1)] = (9));

} else {
var statearr_25530_25569 = state_25442__$1;
(statearr_25530_25569[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_25531 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25531[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_25531[(1)] = (1));

return statearr_25531;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_25442){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25442);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25532){var ex__2749__auto__ = e25532;
var statearr_25533_25570 = state_25442;
(statearr_25533_25570[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25442[(4)]))){
var statearr_25534_25571 = state_25442;
(statearr_25534_25571[(1)] = cljs.core.first.call(null,(state_25442[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25572 = state_25442;
state_25442 = G__25572;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_25442){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_25442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25535 = f__2769__auto__.call(null);
(statearr_25535[(6)] = c__2768__auto__);

return statearr_25535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__25573 = select;
var map__25573__$1 = cljs.core.__destructure_map.call(null,map__25573);
var as = cljs.core.get.call(null,map__25573__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__25573__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__25573__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__25576 = orderBy;
var order = cljs.core.nth.call(null,vec__25576,(0),null);
var var$ = cljs.core.nth.call(null,vec__25576,(1),null);
var option = cljs.core.nth.call(null,vec__25576,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__25574_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__25574_SHARP_,compare_idx));
}):(function (p1__25575_SHARP_){
return cljs.core.nth.call(null,p1__25575_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__25581 = arguments.length;
switch (G__25581) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__25582,p__25583,group_limit,opts){
var map__25584 = p__25582;
var map__25584__$1 = cljs.core.__destructure_map.call(null,map__25584);
var res = map__25584__$1;
var vars = cljs.core.get.call(null,map__25584__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25585 = p__25583;
var map__25585__$1 = cljs.core.__destructure_map.call(null,map__25585);
var select_spec = map__25585__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__25585__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__25585__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__25585__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__25585__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__25585__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25585__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__25585__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__25585__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25585__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__25585__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25722){
var state_val_25723 = (state_25722[(1)]);
if((state_val_25723 === (7))){
var inst_25592 = (state_25722[(7)]);
var state_25722__$1 = state_25722;
var statearr_25724_25826 = state_25722__$1;
(statearr_25724_25826[(2)] = inst_25592);

(statearr_25724_25826[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (59))){
var inst_25715 = (state_25722[(2)]);
var state_25722__$1 = state_25722;
var statearr_25725_25827 = state_25722__$1;
(statearr_25725_25827[(2)] = inst_25715);

(statearr_25725_25827[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (20))){
var inst_25631 = (state_25722[(8)]);
var inst_25628 = (state_25722[(9)]);
var inst_25627 = (state_25722[(2)]);
var inst_25628__$1 = cljs.core.__destructure_map.call(null,inst_25627);
var inst_25629 = cljs.core.get.call(null,inst_25628__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25630 = cljs.core.get.call(null,inst_25628__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25631__$1 = offset;
var state_25722__$1 = (function (){var statearr_25726 = state_25722;
(statearr_25726[(8)] = inst_25631__$1);

(statearr_25726[(9)] = inst_25628__$1);

(statearr_25726[(10)] = inst_25629);

(statearr_25726[(11)] = inst_25630);

return statearr_25726;
})();
if(cljs.core.truth_(inst_25631__$1)){
var statearr_25727_25828 = state_25722__$1;
(statearr_25727_25828[(1)] = (21));

} else {
var statearr_25728_25829 = state_25722__$1;
(statearr_25728_25829[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (58))){
var inst_25707 = (state_25722[(12)]);
var state_25722__$1 = state_25722;
var statearr_25729_25830 = state_25722__$1;
(statearr_25729_25830[(2)] = inst_25707);

(statearr_25729_25830[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (60))){
var inst_25711 = (state_25722[(2)]);
var inst_25712 = fluree.db.util.async.throw_err.call(null,inst_25711);
var state_25722__$1 = state_25722;
var statearr_25730_25831 = state_25722__$1;
(statearr_25730_25831[(2)] = inst_25712);

(statearr_25730_25831[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (27))){
var inst_25643 = cljs.core.not.call(null,inVector_QMARK_);
var state_25722__$1 = state_25722;
var statearr_25731_25832 = state_25722__$1;
(statearr_25731_25832[(2)] = inst_25643);

(statearr_25731_25832[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (1))){
var state_25722__$1 = state_25722;
var statearr_25732_25833 = state_25722__$1;
(statearr_25732_25833[(2)] = null);

(statearr_25732_25833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (24))){
var state_25722__$1 = state_25722;
var statearr_25733_25834 = state_25722__$1;
(statearr_25733_25834[(2)] = offset);

(statearr_25733_25834[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (55))){
var inst_25701 = (state_25722[(13)]);
var state_25722__$1 = state_25722;
var statearr_25734_25835 = state_25722__$1;
(statearr_25734_25835[(2)] = inst_25701);

(statearr_25734_25835[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (39))){
var inst_25669 = (state_25722[(14)]);
var inst_25671 = cljs.core.distinct.call(null);
var inst_25672 = cljs.core.conj.call(null,inst_25669,inst_25671);
var state_25722__$1 = state_25722;
var statearr_25735_25836 = state_25722__$1;
(statearr_25735_25836[(2)] = inst_25672);

(statearr_25735_25836[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (46))){
var inst_25681 = (state_25722[(15)]);
var state_25722__$1 = state_25722;
var statearr_25736_25837 = state_25722__$1;
(statearr_25736_25837[(2)] = inst_25681);

(statearr_25736_25837[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (4))){
var inst_25586 = (state_25722[(2)]);
var state_25722__$1 = state_25722;
var statearr_25737_25838 = state_25722__$1;
(statearr_25737_25838[(2)] = inst_25586);

(statearr_25737_25838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (54))){
var inst_25701 = (state_25722[(13)]);
var inst_25695 = (state_25722[(16)]);
var inst_25703 = cljs.core.PersistentVector.EMPTY;
var inst_25704 = cljs.core.into.call(null,inst_25703,inst_25695,inst_25701);
var state_25722__$1 = state_25722;
var statearr_25738_25839 = state_25722__$1;
(statearr_25738_25839[(2)] = inst_25704);

(statearr_25738_25839[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (15))){
var inst_25613 = (state_25722[(17)]);
var inst_25615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25616 = [inst_25613];
var inst_25617 = (new cljs.core.PersistentVector(null,1,(5),inst_25615,inst_25616,null));
var state_25722__$1 = state_25722;
var statearr_25739_25840 = state_25722__$1;
(statearr_25739_25840[(2)] = inst_25617);

(statearr_25739_25840[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (48))){
var inst_25640 = (state_25722[(18)]);
var inst_25628 = (state_25722[(9)]);
var inst_25651 = (state_25722[(19)]);
var inst_25629 = (state_25722[(10)]);
var inst_25646 = (state_25722[(20)]);
var inst_25630 = (state_25722[(11)]);
var inst_25687 = (state_25722[(21)]);
var inst_25689 = (function (){var map__25622 = inst_25628;
var headers = inst_25629;
var tuples = inst_25630;
var offset_SINGLEQUOTE_ = inst_25640;
var single_result_QMARK_ = inst_25646;
var pp_keys = inst_25651;
var G__25652 = inst_25687;
return (function (p1__25579_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__25579_SHARP_);
});
})();
var inst_25690 = cljs.core.map.call(null,inst_25689);
var inst_25691 = cljs.core.conj.call(null,inst_25687,inst_25690);
var state_25722__$1 = state_25722;
var statearr_25740_25841 = state_25722__$1;
(statearr_25740_25841[(2)] = inst_25691);

(statearr_25740_25841[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (50))){
var inst_25694 = (state_25722[(2)]);
var inst_25695 = cljs.core.apply.call(null,cljs.core.comp,inst_25694);
var state_25722__$1 = (function (){var statearr_25741 = state_25722;
(statearr_25741[(16)] = inst_25695);

return statearr_25741;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25742_25842 = state_25722__$1;
(statearr_25742_25842[(1)] = (51));

} else {
var statearr_25743_25843 = state_25722__$1;
(statearr_25743_25843[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (21))){
var inst_25633 = cljs.core.not.call(null,groupBy);
var state_25722__$1 = state_25722;
var statearr_25744_25844 = state_25722__$1;
(statearr_25744_25844[(2)] = inst_25633);

(statearr_25744_25844[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (31))){
var state_25722__$1 = state_25722;
var statearr_25745_25845 = state_25722__$1;
(statearr_25745_25845[(2)] = null);

(statearr_25745_25845[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (32))){
var inst_25629 = (state_25722[(10)]);
var inst_25646 = (state_25722[(20)]);
var inst_25651 = (state_25722[(2)]);
var inst_25653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25654 = fluree.db.query.fql.select_tuples_fn.call(null,inst_25629,vars,select);
var inst_25655 = cljs.core.map.call(null,inst_25654);
var inst_25656 = [inst_25655];
var inst_25657 = (new cljs.core.PersistentVector(null,1,(5),inst_25653,inst_25656,null));
var state_25722__$1 = (function (){var statearr_25746 = state_25722;
(statearr_25746[(19)] = inst_25651);

(statearr_25746[(22)] = inst_25657);

return statearr_25746;
})();
if(cljs.core.truth_(inst_25646)){
var statearr_25747_25846 = state_25722__$1;
(statearr_25747_25846[(1)] = (33));

} else {
var statearr_25748_25847 = state_25722__$1;
(statearr_25748_25847[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (40))){
var inst_25669 = (state_25722[(14)]);
var state_25722__$1 = state_25722;
var statearr_25749_25848 = state_25722__$1;
(statearr_25749_25848[(2)] = inst_25669);

(statearr_25749_25848[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (56))){
var inst_25707 = (state_25722[(2)]);
var state_25722__$1 = (function (){var statearr_25750 = state_25722;
(statearr_25750[(12)] = inst_25707);

return statearr_25750;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25751_25849 = state_25722__$1;
(statearr_25751_25849[(1)] = (57));

} else {
var statearr_25752_25850 = state_25722__$1;
(statearr_25752_25850[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (33))){
var inst_25657 = (state_25722[(22)]);
var inst_25659 = cljs.core.map.call(null,cljs.core.first);
var inst_25660 = cljs.core.conj.call(null,inst_25657,inst_25659);
var state_25722__$1 = state_25722;
var statearr_25753_25851 = state_25722__$1;
(statearr_25753_25851[(2)] = inst_25660);

(statearr_25753_25851[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (13))){
var inst_25602 = (state_25722[(23)]);
var state_25722__$1 = state_25722;
var statearr_25754_25852 = state_25722__$1;
(statearr_25754_25852[(2)] = inst_25602);

(statearr_25754_25852[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (22))){
var inst_25631 = (state_25722[(8)]);
var state_25722__$1 = state_25722;
var statearr_25755_25853 = state_25722__$1;
(statearr_25755_25853[(2)] = inst_25631);

(statearr_25755_25853[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (36))){
var inst_25663 = (state_25722[(24)]);
var inst_25665 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_25666 = cljs.core.conj.call(null,inst_25663,inst_25665);
var state_25722__$1 = state_25722;
var statearr_25756_25854 = state_25722__$1;
(statearr_25756_25854[(2)] = inst_25666);

(statearr_25756_25854[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (41))){
var inst_25640 = (state_25722[(18)]);
var inst_25675 = (state_25722[(2)]);
var state_25722__$1 = (function (){var statearr_25757 = state_25722;
(statearr_25757[(25)] = inst_25675);

return statearr_25757;
})();
if(cljs.core.truth_(inst_25640)){
var statearr_25758_25855 = state_25722__$1;
(statearr_25758_25855[(1)] = (42));

} else {
var statearr_25759_25856 = state_25722__$1;
(statearr_25759_25856[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (43))){
var inst_25675 = (state_25722[(25)]);
var state_25722__$1 = state_25722;
var statearr_25760_25857 = state_25722__$1;
(statearr_25760_25857[(2)] = inst_25675);

(statearr_25760_25857[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (29))){
var inst_25646 = (state_25722[(2)]);
var state_25722__$1 = (function (){var statearr_25761 = state_25722;
(statearr_25761[(20)] = inst_25646);

return statearr_25761;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25762_25858 = state_25722__$1;
(statearr_25762_25858[(1)] = (30));

} else {
var statearr_25763_25859 = state_25722__$1;
(statearr_25763_25859[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (44))){
var inst_25681 = (state_25722[(2)]);
var state_25722__$1 = (function (){var statearr_25764 = state_25722;
(statearr_25764[(15)] = inst_25681);

return statearr_25764;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25765_25860 = state_25722__$1;
(statearr_25765_25860[(1)] = (45));

} else {
var statearr_25766_25861 = state_25722__$1;
(statearr_25766_25861[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (6))){
var inst_25594 = cljs.core.count.call(null,select);
var inst_25595 = cljs.core._EQ_.call(null,(1),inst_25594);
var state_25722__$1 = state_25722;
var statearr_25767_25862 = state_25722__$1;
(statearr_25767_25862[(2)] = inst_25595);

(statearr_25767_25862[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (28))){
var inst_25641 = (state_25722[(26)]);
var state_25722__$1 = state_25722;
var statearr_25768_25863 = state_25722__$1;
(statearr_25768_25863[(2)] = inst_25641);

(statearr_25768_25863[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (51))){
var inst_25629 = (state_25722[(10)]);
var inst_25630 = (state_25722[(11)]);
var inst_25698 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_25629,orderBy,inst_25630);
var state_25722__$1 = state_25722;
var statearr_25769_25864 = state_25722__$1;
(statearr_25769_25864[(2)] = inst_25698);

(statearr_25769_25864[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (25))){
var state_25722__$1 = state_25722;
var statearr_25770_25865 = state_25722__$1;
(statearr_25770_25865[(2)] = null);

(statearr_25770_25865[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (34))){
var inst_25657 = (state_25722[(22)]);
var state_25722__$1 = state_25722;
var statearr_25771_25866 = state_25722__$1;
(statearr_25771_25866[(2)] = inst_25657);

(statearr_25771_25866[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (17))){
var inst_25620 = (state_25722[(2)]);
var state_25722__$1 = state_25722;
var statearr_25772_25867 = state_25722__$1;
(statearr_25772_25867[(2)] = inst_25620);

(statearr_25772_25867[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (3))){
var inst_25720 = (state_25722[(2)]);
var state_25722__$1 = state_25722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25722__$1,inst_25720);
} else {
if((state_val_25723 === (12))){
var inst_25602 = (state_25722[(23)]);
var inst_25604 = cljs.core.first.call(null,select);
var inst_25605 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_25604);
var inst_25606 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25605);
var inst_25607 = cljs.core.subs.call(null,inst_25606,(1));
var inst_25608 = [inst_25607];
var inst_25609 = [inst_25602];
var inst_25610 = cljs.core.PersistentHashMap.fromArrays(inst_25608,inst_25609);
var state_25722__$1 = state_25722;
var statearr_25773_25868 = state_25722__$1;
(statearr_25773_25868[(2)] = inst_25610);

(statearr_25773_25868[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (2))){
var inst_25592 = (state_25722[(7)]);
var _ = (function (){var statearr_25774 = state_25722;
(statearr_25774[(4)] = cljs.core.cons.call(null,(5),(state_25722[(4)])));

return statearr_25774;
})();
var inst_25592__$1 = aggregates;
var state_25722__$1 = (function (){var statearr_25775 = state_25722;
(statearr_25775[(7)] = inst_25592__$1);

return statearr_25775;
})();
if(cljs.core.truth_(inst_25592__$1)){
var statearr_25776_25869 = state_25722__$1;
(statearr_25776_25869[(1)] = (6));

} else {
var statearr_25777_25870 = state_25722__$1;
(statearr_25777_25870[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (23))){
var inst_25636 = (state_25722[(2)]);
var state_25722__$1 = state_25722;
if(cljs.core.truth_(inst_25636)){
var statearr_25778_25871 = state_25722__$1;
(statearr_25778_25871[(1)] = (24));

} else {
var statearr_25779_25872 = state_25722__$1;
(statearr_25779_25872[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (47))){
var inst_25687 = (state_25722[(2)]);
var state_25722__$1 = (function (){var statearr_25780 = state_25722;
(statearr_25780[(21)] = inst_25687);

return statearr_25780;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25781_25873 = state_25722__$1;
(statearr_25781_25873[(1)] = (48));

} else {
var statearr_25782_25874 = state_25722__$1;
(statearr_25782_25874[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (35))){
var inst_25663 = (state_25722[(2)]);
var state_25722__$1 = (function (){var statearr_25783 = state_25722;
(statearr_25783[(24)] = inst_25663);

return statearr_25783;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25784_25875 = state_25722__$1;
(statearr_25784_25875[(1)] = (36));

} else {
var statearr_25785_25876 = state_25722__$1;
(statearr_25785_25876[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (19))){
var state_25722__$1 = state_25722;
var statearr_25786_25877 = state_25722__$1;
(statearr_25786_25877[(2)] = res);

(statearr_25786_25877[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (57))){
var inst_25651 = (state_25722[(19)]);
var inst_25646 = (state_25722[(20)]);
var inst_25707 = (state_25722[(12)]);
var inst_25709 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_25651,inst_25646,db,fuel,max_fuel,opts,(8),inst_25707);
var state_25722__$1 = state_25722;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25722__$1,(60),inst_25709);
} else {
if((state_val_25723 === (11))){
var inst_25717 = (state_25722[(2)]);
var _ = (function (){var statearr_25788 = state_25722;
(statearr_25788[(4)] = cljs.core.rest.call(null,(state_25722[(4)])));

return statearr_25788;
})();
var state_25722__$1 = state_25722;
var statearr_25789_25878 = state_25722__$1;
(statearr_25789_25878[(2)] = inst_25717);

(statearr_25789_25878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (9))){
var inst_25600 = cljs.core.first.call(null,aggregates);
var inst_25601 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_25600);
var inst_25602 = cljs.core.second.call(null,inst_25601);
var state_25722__$1 = (function (){var statearr_25790 = state_25722;
(statearr_25790[(23)] = inst_25602);

return statearr_25790;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25791_25879 = state_25722__$1;
(statearr_25791_25879[(1)] = (12));

} else {
var statearr_25792_25880 = state_25722__$1;
(statearr_25792_25880[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (5))){
var _ = (function (){var statearr_25793 = state_25722;
(statearr_25793[(4)] = cljs.core.rest.call(null,(state_25722[(4)])));

return statearr_25793;
})();
var state_25722__$1 = state_25722;
var ex25787 = (state_25722__$1[(2)]);
var statearr_25794_25881 = state_25722__$1;
(statearr_25794_25881[(5)] = ex25787);


if((ex25787 instanceof Error)){
var statearr_25795_25882 = state_25722__$1;
(statearr_25795_25882[(1)] = (4));

(statearr_25795_25882[(5)] = null);

} else {
throw ex25787;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (14))){
var inst_25613 = (state_25722[(2)]);
var state_25722__$1 = (function (){var statearr_25796 = state_25722;
(statearr_25796[(17)] = inst_25613);

return statearr_25796;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25797_25883 = state_25722__$1;
(statearr_25797_25883[(1)] = (15));

} else {
var statearr_25798_25884 = state_25722__$1;
(statearr_25798_25884[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (45))){
var inst_25681 = (state_25722[(15)]);
var inst_25683 = cljs.core.take.call(null,group_limit);
var inst_25684 = cljs.core.conj.call(null,inst_25681,inst_25683);
var state_25722__$1 = state_25722;
var statearr_25799_25885 = state_25722__$1;
(statearr_25799_25885[(2)] = inst_25684);

(statearr_25799_25885[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (53))){
var inst_25701 = (state_25722[(2)]);
var state_25722__$1 = (function (){var statearr_25800 = state_25722;
(statearr_25800[(13)] = inst_25701);

return statearr_25800;
})();
var statearr_25801_25886 = state_25722__$1;
(statearr_25801_25886[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (26))){
var inst_25641 = (state_25722[(26)]);
var inst_25640 = (state_25722[(2)]);
var inst_25641__$1 = cljs.core.not.call(null,prettyPrint);
var state_25722__$1 = (function (){var statearr_25803 = state_25722;
(statearr_25803[(18)] = inst_25640);

(statearr_25803[(26)] = inst_25641__$1);

return statearr_25803;
})();
if(inst_25641__$1){
var statearr_25804_25887 = state_25722__$1;
(statearr_25804_25887[(1)] = (27));

} else {
var statearr_25805_25888 = state_25722__$1;
(statearr_25805_25888[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (16))){
var inst_25613 = (state_25722[(17)]);
var state_25722__$1 = state_25722;
var statearr_25806_25889 = state_25722__$1;
(statearr_25806_25889[(2)] = inst_25613);

(statearr_25806_25889[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (38))){
var inst_25669 = (state_25722[(2)]);
var state_25722__$1 = (function (){var statearr_25807 = state_25722;
(statearr_25807[(14)] = inst_25669);

return statearr_25807;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25808_25890 = state_25722__$1;
(statearr_25808_25890[(1)] = (39));

} else {
var statearr_25809_25891 = state_25722__$1;
(statearr_25809_25891[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (30))){
var inst_25648 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_25722__$1 = state_25722;
var statearr_25810_25892 = state_25722__$1;
(statearr_25810_25892[(2)] = inst_25648);

(statearr_25810_25892[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (10))){
var state_25722__$1 = state_25722;
if(cljs.core.truth_(aggregates)){
var statearr_25811_25893 = state_25722__$1;
(statearr_25811_25893[(1)] = (18));

} else {
var statearr_25812_25894 = state_25722__$1;
(statearr_25812_25894[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (18))){
var inst_25624 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_25722__$1 = state_25722;
var statearr_25813_25895 = state_25722__$1;
(statearr_25813_25895[(2)] = inst_25624);

(statearr_25813_25895[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (52))){
var inst_25630 = (state_25722[(11)]);
var state_25722__$1 = state_25722;
var statearr_25814_25896 = state_25722__$1;
(statearr_25814_25896[(2)] = inst_25630);

(statearr_25814_25896[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (42))){
var inst_25640 = (state_25722[(18)]);
var inst_25675 = (state_25722[(25)]);
var inst_25677 = cljs.core.drop.call(null,inst_25640);
var inst_25678 = cljs.core.conj.call(null,inst_25675,inst_25677);
var state_25722__$1 = state_25722;
var statearr_25815_25897 = state_25722__$1;
(statearr_25815_25897[(2)] = inst_25678);

(statearr_25815_25897[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (37))){
var inst_25663 = (state_25722[(24)]);
var state_25722__$1 = state_25722;
var statearr_25816_25898 = state_25722__$1;
(statearr_25816_25898[(2)] = inst_25663);

(statearr_25816_25898[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (8))){
var inst_25598 = (state_25722[(2)]);
var state_25722__$1 = state_25722;
if(cljs.core.truth_(inst_25598)){
var statearr_25817_25899 = state_25722__$1;
(statearr_25817_25899[(1)] = (9));

} else {
var statearr_25818_25900 = state_25722__$1;
(statearr_25818_25900[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25723 === (49))){
var inst_25687 = (state_25722[(21)]);
var state_25722__$1 = state_25722;
var statearr_25819_25901 = state_25722__$1;
(statearr_25819_25901[(2)] = inst_25687);

(statearr_25819_25901[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_25820 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25820[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_25820[(1)] = (1));

return statearr_25820;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_25722){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25821){var ex__2749__auto__ = e25821;
var statearr_25822_25902 = state_25722;
(statearr_25822_25902[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25722[(4)]))){
var statearr_25823_25903 = state_25722;
(statearr_25823_25903[(1)] = cljs.core.first.call(null,(state_25722[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25904 = state_25722;
state_25722 = G__25904;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_25722){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_25722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25824 = f__2769__auto__.call(null);
(statearr_25824[(6)] = c__2768__auto__);

return statearr_25824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25907,groupBy){
var map__25908 = p__25907;
var map__25908__$1 = cljs.core.__destructure_map.call(null,map__25908);
var res = map__25908__$1;
var headers = cljs.core.get.call(null,map__25908__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25908__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25909 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__25909,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__25909,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__25905_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__25905_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__25906_SHARP_){
return cljs.core.nth.call(null,tuple,p1__25906_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25912 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__25912,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__25912,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25915,p__25916,opts){
var map__25917 = p__25915;
var map__25917__$1 = cljs.core.__destructure_map.call(null,map__25917);
var res = map__25917__$1;
var headers = cljs.core.get.call(null,map__25917__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__25917__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25918 = p__25916;
var map__25918__$1 = cljs.core.__destructure_map.call(null,map__25918);
var select_spec = map__25918__$1;
var groupBy = cljs.core.get.call(null,map__25918__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__25918__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__25918__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__25918__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25918__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__25918__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__25918__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26160){
var state_val_26161 = (state_26160[(1)]);
if((state_val_26161 === (65))){
var state_26160__$1 = state_26160;
var statearr_26162_26313 = state_26160__$1;
(statearr_26162_26313[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (70))){
var inst_26081 = (state_26160[(7)]);
var state_26160__$1 = state_26160;
var statearr_26164_26314 = state_26160__$1;
(statearr_26164_26314[(2)] = inst_26081);

(statearr_26164_26314[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (62))){
var state_26160__$1 = state_26160;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_26165_26315 = state_26160__$1;
(statearr_26165_26315[(1)] = (64));

} else {
var statearr_26166_26316 = state_26160__$1;
(statearr_26166_26316[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (74))){
var inst_25988 = (state_26160[(8)]);
var inst_25997 = (state_26160[(9)]);
var inst_26056 = (state_26160[(10)]);
var inst_26089 = cljs.core.assoc.call(null,inst_25988,inst_25997,inst_26056);
var state_26160__$1 = state_26160;
var statearr_26167_26317 = state_26160__$1;
(statearr_26167_26317[(2)] = inst_26089);

(statearr_26167_26317[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (7))){
var state_26160__$1 = state_26160;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26168_26318 = state_26160__$1;
(statearr_26168_26318[(1)] = (82));

} else {
var statearr_26169_26319 = state_26160__$1;
(statearr_26169_26319[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (59))){
var inst_26056 = (state_26160[(10)]);
var inst_25986 = (state_26160[(11)]);
var inst_26060 = cljs.core.count.call(null,inst_26056);
var inst_26061 = (inst_25986 - inst_26060);
var state_26160__$1 = state_26160;
var statearr_26170_26320 = state_26160__$1;
(statearr_26170_26320[(2)] = inst_26061);

(statearr_26170_26320[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (86))){
var state_26160__$1 = state_26160;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_26171_26321 = state_26160__$1;
(statearr_26171_26321[(1)] = (89));

} else {
var statearr_26172_26322 = state_26160__$1;
(statearr_26172_26322[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (20))){
var state_26160__$1 = state_26160;
var statearr_26173_26323 = state_26160__$1;
(statearr_26173_26323[(2)] = (0));

(statearr_26173_26323[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (72))){
var inst_26086 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
if(cljs.core.truth_(inst_26086)){
var statearr_26174_26324 = state_26160__$1;
(statearr_26174_26324[(1)] = (73));

} else {
var statearr_26175_26325 = state_26160__$1;
(statearr_26175_26325[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (58))){
var state_26160__$1 = state_26160;
var statearr_26176_26326 = state_26160__$1;
(statearr_26176_26326[(2)] = null);

(statearr_26176_26326[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (60))){
var inst_25987 = (state_26160[(12)]);
var inst_26063 = (state_26160[(2)]);
var inst_26064 = (inst_25987 <= (0));
var state_26160__$1 = (function (){var statearr_26177 = state_26160;
(statearr_26177[(13)] = inst_26063);

return statearr_26177;
})();
if(cljs.core.truth_(inst_26064)){
var statearr_26178_26327 = state_26160__$1;
(statearr_26178_26327[(1)] = (61));

} else {
var statearr_26179_26328 = state_26160__$1;
(statearr_26179_26328[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (27))){
var inst_25986 = (state_26160[(11)]);
var inst_26010 = (inst_25986 < (1));
var state_26160__$1 = state_26160;
var statearr_26180_26329 = state_26160__$1;
(statearr_26180_26329[(2)] = inst_26010);

(statearr_26180_26329[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (1))){
var state_26160__$1 = state_26160;
var statearr_26181_26330 = state_26160__$1;
(statearr_26181_26330[(2)] = null);

(statearr_26181_26330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (69))){
var inst_26076 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26182_26331 = state_26160__$1;
(statearr_26182_26331[(2)] = inst_26076);

(statearr_26182_26331[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (24))){
var inst_25988 = (state_26160[(8)]);
var state_26160__$1 = state_26160;
var statearr_26183_26332 = state_26160__$1;
(statearr_26183_26332[(2)] = inst_25988);

(statearr_26183_26332[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (55))){
var inst_25986 = (state_26160[(11)]);
var inst_26046 = (state_26160[(14)]);
var inst_26053 = cljs.core.take.call(null,inst_25986,inst_26046);
var state_26160__$1 = state_26160;
var statearr_26184_26333 = state_26160__$1;
(statearr_26184_26333[(2)] = inst_26053);

(statearr_26184_26333[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (85))){
var inst_26131 = (state_26160[(15)]);
var inst_26130 = (state_26160[(2)]);
var inst_26131__$1 = fluree.db.util.async.throw_err.call(null,inst_26130);
var inst_26132 = cljs.core.coll_QMARK_.call(null,inst_26131__$1);
var inst_26133 = (!(inst_26132));
var state_26160__$1 = (function (){var statearr_26185 = state_26160;
(statearr_26185[(15)] = inst_26131__$1);

return statearr_26185;
})();
if(inst_26133){
var statearr_26186_26334 = state_26160__$1;
(statearr_26186_26334[(1)] = (86));

} else {
var statearr_26187_26335 = state_26160__$1;
(statearr_26187_26335[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (39))){
var inst_26005 = (state_26160[(16)]);
var inst_26027 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_26028 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_26029 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_26005,inst_26027,inst_26028);
var state_26160__$1 = state_26160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26160__$1,(42),inst_26029);
} else {
if((state_val_26161 === (88))){
var inst_26153 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26188_26336 = state_26160__$1;
(statearr_26188_26336[(2)] = inst_26153);

(statearr_26188_26336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (46))){
var inst_25987 = (state_26160[(12)]);
var inst_26041 = ((0) < inst_25987);
var state_26160__$1 = state_26160;
if(cljs.core.truth_(inst_26041)){
var statearr_26189_26337 = state_26160__$1;
(statearr_26189_26337[(1)] = (49));

} else {
var statearr_26190_26338 = state_26160__$1;
(statearr_26190_26338[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (4))){
var inst_25919 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26191_26339 = state_26160__$1;
(statearr_26191_26339[(2)] = inst_25919);

(statearr_26191_26339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (77))){
var inst_25986 = (state_26160[(11)]);
var inst_26097 = (inst_25986 - (1));
var state_26160__$1 = state_26160;
var statearr_26192_26340 = state_26160__$1;
(statearr_26192_26340[(2)] = inst_26097);

(statearr_26192_26340[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (95))){
var inst_26131 = (state_26160[(15)]);
var state_26160__$1 = state_26160;
var statearr_26193_26341 = state_26160__$1;
(statearr_26193_26341[(2)] = inst_26131);

(statearr_26193_26341[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (54))){
var inst_26051 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
if(cljs.core.truth_(inst_26051)){
var statearr_26194_26342 = state_26160__$1;
(statearr_26194_26342[(1)] = (55));

} else {
var statearr_26195_26343 = state_26160__$1;
(statearr_26195_26343[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (92))){
var inst_26131 = (state_26160[(15)]);
var inst_26144 = cljs.core.first.call(null,inst_26131);
var state_26160__$1 = state_26160;
var statearr_26196_26344 = state_26160__$1;
(statearr_26196_26344[(2)] = inst_26144);

(statearr_26196_26344[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (15))){
var inst_25937 = (state_26160[(17)]);
var inst_25945 = (state_26160[(2)]);
var inst_25946 = fluree.db.util.async.throw_err.call(null,inst_25945);
var inst_25947 = [inst_25937];
var inst_25948 = [inst_25946];
var inst_25949 = cljs.core.PersistentHashMap.fromArrays(inst_25947,inst_25948);
var state_26160__$1 = state_26160;
var statearr_26197_26345 = state_26160__$1;
(statearr_26197_26345[(2)] = inst_25949);

(statearr_26197_26345[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (48))){
var inst_26109 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26198_26346 = state_26160__$1;
(statearr_26198_26346[(2)] = inst_26109);

(statearr_26198_26346[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (50))){
var inst_26032 = (state_26160[(18)]);
var state_26160__$1 = state_26160;
var statearr_26199_26347 = state_26160__$1;
(statearr_26199_26347[(2)] = inst_26032);

(statearr_26199_26347[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (75))){
var inst_26001 = (state_26160[(19)]);
var inst_26080 = (state_26160[(20)]);
var inst_25998 = (state_26160[(21)]);
var inst_26063 = (state_26160[(13)]);
var inst_26091 = (state_26160[(2)]);
var inst_25984 = inst_25998;
var inst_25985 = inst_26001;
var inst_25986 = inst_26063;
var inst_25987 = inst_26080;
var inst_25988 = inst_26091;
var state_26160__$1 = (function (){var statearr_26200 = state_26160;
(statearr_26200[(8)] = inst_25988);

(statearr_26200[(22)] = inst_25984);

(statearr_26200[(23)] = inst_25985);

(statearr_26200[(11)] = inst_25986);

(statearr_26200[(12)] = inst_25987);

return statearr_26200;
})();
var statearr_26201_26348 = state_26160__$1;
(statearr_26201_26348[(2)] = null);

(statearr_26201_26348[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (21))){
var inst_25969 = (state_26160[(24)]);
var inst_25965 = (state_26160[(25)]);
var inst_25977 = (state_26160[(26)]);
var inst_25982 = (state_26160[(2)]);
var inst_25983 = cljs.core.PersistentHashMap.EMPTY;
var inst_25984 = inst_25965;
var inst_25985 = inst_25969;
var inst_25986 = inst_25977;
var inst_25987 = inst_25982;
var inst_25988 = inst_25983;
var state_26160__$1 = (function (){var statearr_26202 = state_26160;
(statearr_26202[(8)] = inst_25988);

(statearr_26202[(22)] = inst_25984);

(statearr_26202[(23)] = inst_25985);

(statearr_26202[(11)] = inst_25986);

(statearr_26202[(12)] = inst_25987);

return statearr_26202;
})();
var statearr_26203_26349 = state_26160__$1;
(statearr_26203_26349[(2)] = null);

(statearr_26203_26349[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (31))){
var inst_26002 = (state_26160[(27)]);
var inst_25987 = (state_26160[(12)]);
var inst_26016 = (inst_25987 >= inst_26002);
var state_26160__$1 = state_26160;
if(cljs.core.truth_(inst_26016)){
var statearr_26204_26350 = state_26160__$1;
(statearr_26204_26350[(1)] = (33));

} else {
var statearr_26205_26351 = state_26160__$1;
(statearr_26205_26351[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (32))){
var inst_26116 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26206_26352 = state_26160__$1;
(statearr_26206_26352[(2)] = inst_26116);

(statearr_26206_26352[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (40))){
var state_26160__$1 = state_26160;
var statearr_26207_26353 = state_26160__$1;
(statearr_26207_26353[(2)] = null);

(statearr_26207_26353[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (91))){
var inst_26141 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26208_26354 = state_26160__$1;
(statearr_26208_26354[(2)] = inst_26141);

(statearr_26208_26354[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (56))){
var inst_26046 = (state_26160[(14)]);
var state_26160__$1 = state_26160;
var statearr_26209_26355 = state_26160__$1;
(statearr_26209_26355[(2)] = inst_26046);

(statearr_26209_26355[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (33))){
var state_26160__$1 = state_26160;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_26210_26356 = state_26160__$1;
(statearr_26210_26356[(1)] = (36));

} else {
var statearr_26211_26357 = state_26160__$1;
(statearr_26211_26357[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (13))){
var inst_25969 = (state_26160[(24)]);
var inst_25934 = (state_26160[(28)]);
var inst_25965 = (state_26160[(25)]);
var inst_25965__$1 = cljs.core.keys.call(null,inst_25934);
var inst_25966 = cljs.core.seq.call(null,inst_25965__$1);
var inst_25967 = cljs.core.first.call(null,inst_25966);
var inst_25968 = cljs.core.next.call(null,inst_25966);
var inst_25969__$1 = cljs.core.vals.call(null,inst_25934);
var inst_25970 = cljs.core.seq.call(null,inst_25969__$1);
var inst_25971 = cljs.core.first.call(null,inst_25970);
var inst_25972 = cljs.core.next.call(null,inst_25970);
var inst_25973 = cljs.core._EQ_.call(null,(0),limit);
var state_26160__$1 = (function (){var statearr_26212 = state_26160;
(statearr_26212[(24)] = inst_25969__$1);

(statearr_26212[(29)] = inst_25968);

(statearr_26212[(30)] = inst_25972);

(statearr_26212[(31)] = inst_25967);

(statearr_26212[(25)] = inst_25965__$1);

(statearr_26212[(32)] = inst_25971);

return statearr_26212;
})();
if(inst_25973){
var statearr_26213_26358 = state_26160__$1;
(statearr_26213_26358[(1)] = (16));

} else {
var statearr_26214_26359 = state_26160__$1;
(statearr_26214_26359[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (22))){
var inst_25984 = (state_26160[(22)]);
var inst_25985 = (state_26160[(23)]);
var inst_25996 = cljs.core.seq.call(null,inst_25984);
var inst_25997 = cljs.core.first.call(null,inst_25996);
var inst_25998 = cljs.core.next.call(null,inst_25996);
var inst_25999 = cljs.core.seq.call(null,inst_25985);
var inst_26000 = cljs.core.first.call(null,inst_25999);
var inst_26001 = cljs.core.next.call(null,inst_25999);
var inst_26002 = cljs.core.count.call(null,inst_26000);
var inst_26003 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_26004 = [headers,vars,inst_26000];
var inst_26005 = cljs.core.PersistentHashMap.fromArrays(inst_26003,inst_26004);
var inst_26006 = (inst_26000 == null);
var state_26160__$1 = (function (){var statearr_26215 = state_26160;
(statearr_26215[(19)] = inst_26001);

(statearr_26215[(16)] = inst_26005);

(statearr_26215[(9)] = inst_25997);

(statearr_26215[(27)] = inst_26002);

(statearr_26215[(21)] = inst_25998);

return statearr_26215;
})();
if(cljs.core.truth_(inst_26006)){
var statearr_26216_26360 = state_26160__$1;
(statearr_26216_26360[(1)] = (24));

} else {
var statearr_26217_26361 = state_26160__$1;
(statearr_26217_26361[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (90))){
var inst_26131 = (state_26160[(15)]);
var state_26160__$1 = state_26160;
var statearr_26218_26362 = state_26160__$1;
(statearr_26218_26362[(2)] = inst_26131);

(statearr_26218_26362[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (36))){
var inst_25987 = (state_26160[(12)]);
var inst_26019 = (inst_25987 - (1));
var state_26160__$1 = state_26160;
var statearr_26219_26363 = state_26160__$1;
(statearr_26219_26363[(2)] = inst_26019);

(statearr_26219_26363[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (41))){
var inst_26112 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26220_26364 = state_26160__$1;
(statearr_26220_26364[(2)] = inst_26112);

(statearr_26220_26364[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (89))){
var inst_26131 = (state_26160[(15)]);
var inst_26136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26137 = [inst_26131];
var inst_26138 = (new cljs.core.PersistentVector(null,1,(5),inst_26136,inst_26137,null));
var state_26160__$1 = state_26160;
var statearr_26221_26365 = state_26160__$1;
(statearr_26221_26365[(2)] = inst_26138);

(statearr_26221_26365[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (43))){
var inst_26032 = (state_26160[(18)]);
var inst_26035 = cljs.core.seq.call(null,inst_26032);
var state_26160__$1 = state_26160;
var statearr_26222_26366 = state_26160__$1;
(statearr_26222_26366[(2)] = inst_26035);

(statearr_26222_26366[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (61))){
var state_26160__$1 = state_26160;
var statearr_26223_26367 = state_26160__$1;
(statearr_26223_26367[(2)] = (0));

(statearr_26223_26367[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (29))){
var inst_26013 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
if(cljs.core.truth_(inst_26013)){
var statearr_26224_26368 = state_26160__$1;
(statearr_26224_26368[(1)] = (30));

} else {
var statearr_26225_26369 = state_26160__$1;
(statearr_26225_26369[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (44))){
var inst_26033 = (state_26160[(33)]);
var state_26160__$1 = state_26160;
var statearr_26226_26370 = state_26160__$1;
(statearr_26226_26370[(2)] = inst_26033);

(statearr_26226_26370[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (93))){
var state_26160__$1 = state_26160;
var statearr_26227_26371 = state_26160__$1;
(statearr_26227_26371[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (6))){
var inst_25926 = (state_26160[(34)]);
var inst_25926__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_25928 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_26160__$1 = (function (){var statearr_26229 = state_26160;
(statearr_26229[(34)] = inst_25926__$1);

(statearr_26229[(35)] = inst_25928);

return statearr_26229;
})();
if(cljs.core.truth_(inst_25926__$1)){
var statearr_26230_26372 = state_26160__$1;
(statearr_26230_26372[(1)] = (9));

} else {
var statearr_26231_26373 = state_26160__$1;
(statearr_26231_26373[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (28))){
var inst_25986 = (state_26160[(11)]);
var state_26160__$1 = state_26160;
var statearr_26232_26374 = state_26160__$1;
(statearr_26232_26374[(2)] = inst_25986);

(statearr_26232_26374[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (64))){
var inst_25987 = (state_26160[(12)]);
var inst_26068 = (inst_25987 - (1));
var state_26160__$1 = state_26160;
var statearr_26233_26375 = state_26160__$1;
(statearr_26233_26375[(2)] = inst_26068);

(statearr_26233_26375[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (51))){
var inst_25986 = (state_26160[(11)]);
var inst_26046 = (state_26160[(2)]);
var state_26160__$1 = (function (){var statearr_26234 = state_26160;
(statearr_26234[(14)] = inst_26046);

return statearr_26234;
})();
if(cljs.core.truth_(inst_25986)){
var statearr_26235_26376 = state_26160__$1;
(statearr_26235_26376[(1)] = (52));

} else {
var statearr_26236_26377 = state_26160__$1;
(statearr_26236_26377[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (25))){
var inst_25986 = (state_26160[(11)]);
var state_26160__$1 = state_26160;
if(cljs.core.truth_(inst_25986)){
var statearr_26237_26378 = state_26160__$1;
(statearr_26237_26378[(1)] = (27));

} else {
var statearr_26238_26379 = state_26160__$1;
(statearr_26238_26379[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (34))){
var state_26160__$1 = state_26160;
var statearr_26239_26380 = state_26160__$1;
(statearr_26239_26380[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (17))){
var state_26160__$1 = state_26160;
var statearr_26241_26381 = state_26160__$1;
(statearr_26241_26381[(2)] = limit);

(statearr_26241_26381[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (3))){
var inst_26158 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26160__$1,inst_26158);
} else {
if((state_val_26161 === (12))){
var inst_25934 = (state_26160[(28)]);
var inst_25936 = cljs.core.keys.call(null,inst_25934);
var inst_25937 = cljs.core.first.call(null,inst_25936);
var inst_25938 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25939 = cljs.core.vals.call(null,inst_25934);
var inst_25940 = cljs.core.first.call(null,inst_25939);
var inst_25941 = [headers,vars,inst_25940];
var inst_25942 = cljs.core.PersistentHashMap.fromArrays(inst_25938,inst_25941);
var inst_25943 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25942,select_spec,limit,opts);
var state_26160__$1 = (function (){var statearr_26242 = state_26160;
(statearr_26242[(17)] = inst_25937);

return statearr_26242;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26160__$1,(15),inst_25943);
} else {
if((state_val_26161 === (2))){
var _ = (function (){var statearr_26243 = state_26160;
(statearr_26243[(4)] = cljs.core.cons.call(null,(5),(state_26160[(4)])));

return statearr_26243;
})();
var state_26160__$1 = state_26160;
if(cljs.core.truth_(groupBy)){
var statearr_26244_26382 = state_26160__$1;
(statearr_26244_26382[(1)] = (6));

} else {
var statearr_26245_26383 = state_26160__$1;
(statearr_26245_26383[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (66))){
var inst_26078 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26246_26384 = state_26160__$1;
(statearr_26246_26384[(2)] = inst_26078);

(statearr_26246_26384[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (23))){
var inst_26120 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26247_26385 = state_26160__$1;
(statearr_26247_26385[(2)] = inst_26120);

(statearr_26247_26385[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (47))){
var inst_25986 = (state_26160[(11)]);
var inst_26094 = (inst_25986 == null);
var state_26160__$1 = state_26160;
if(cljs.core.truth_(inst_26094)){
var statearr_26248_26386 = state_26160__$1;
(statearr_26248_26386[(1)] = (76));

} else {
var statearr_26249_26387 = state_26160__$1;
(statearr_26249_26387[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (35))){
var inst_26114 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26250_26388 = state_26160__$1;
(statearr_26250_26388[(2)] = inst_26114);

(statearr_26250_26388[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (82))){
var state_26160__$1 = state_26160;
var statearr_26251_26389 = state_26160__$1;
(statearr_26251_26389[(2)] = (1));

(statearr_26251_26389[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (76))){
var state_26160__$1 = state_26160;
var statearr_26252_26390 = state_26160__$1;
(statearr_26252_26390[(2)] = null);

(statearr_26252_26390[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (97))){
var inst_26149 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26253_26391 = state_26160__$1;
(statearr_26253_26391[(2)] = inst_26149);

(statearr_26253_26391[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (19))){
var inst_25978 = (state_26160[(36)]);
var state_26160__$1 = state_26160;
var statearr_26254_26392 = state_26160__$1;
(statearr_26254_26392[(2)] = inst_25978);

(statearr_26254_26392[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (57))){
var inst_25986 = (state_26160[(11)]);
var inst_26056 = (state_26160[(2)]);
var inst_26057 = (inst_25986 == null);
var state_26160__$1 = (function (){var statearr_26255 = state_26160;
(statearr_26255[(10)] = inst_26056);

return statearr_26255;
})();
if(cljs.core.truth_(inst_26057)){
var statearr_26256_26393 = state_26160__$1;
(statearr_26256_26393[(1)] = (58));

} else {
var statearr_26257_26394 = state_26160__$1;
(statearr_26257_26394[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (68))){
var state_26160__$1 = state_26160;
var statearr_26258_26395 = state_26160__$1;
(statearr_26258_26395[(2)] = null);

(statearr_26258_26395[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (11))){
var inst_25934 = (state_26160[(2)]);
var state_26160__$1 = (function (){var statearr_26260 = state_26160;
(statearr_26260[(28)] = inst_25934);

return statearr_26260;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26261_26396 = state_26160__$1;
(statearr_26261_26396[(1)] = (12));

} else {
var statearr_26262_26397 = state_26160__$1;
(statearr_26262_26397[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (9))){
var inst_25926 = (state_26160[(34)]);
var inst_25928 = (state_26160[(35)]);
var inst_25930 = cljs.core.sorted_map_by.call(null,inst_25926);
var inst_25931 = cljs.core.into.call(null,inst_25930,inst_25928);
var state_26160__$1 = state_26160;
var statearr_26263_26398 = state_26160__$1;
(statearr_26263_26398[(2)] = inst_25931);

(statearr_26263_26398[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (5))){
var _ = (function (){var statearr_26264 = state_26160;
(statearr_26264[(4)] = cljs.core.rest.call(null,(state_26160[(4)])));

return statearr_26264;
})();
var state_26160__$1 = state_26160;
var ex26259 = (state_26160__$1[(2)]);
var statearr_26265_26399 = state_26160__$1;
(statearr_26265_26399[(5)] = ex26259);


if((ex26259 instanceof Error)){
var statearr_26266_26400 = state_26160__$1;
(statearr_26266_26400[(1)] = (4));

(statearr_26266_26400[(5)] = null);

} else {
throw ex26259;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (83))){
var state_26160__$1 = state_26160;
var statearr_26267_26401 = state_26160__$1;
(statearr_26267_26401[(2)] = limit);

(statearr_26267_26401[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (14))){
var inst_26122 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26268_26402 = state_26160__$1;
(statearr_26268_26402[(2)] = inst_26122);

(statearr_26268_26402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (45))){
var inst_26038 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
if(cljs.core.truth_(inst_26038)){
var statearr_26269_26403 = state_26160__$1;
(statearr_26269_26403[(1)] = (46));

} else {
var statearr_26270_26404 = state_26160__$1;
(statearr_26270_26404[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (53))){
var inst_25986 = (state_26160[(11)]);
var state_26160__$1 = state_26160;
var statearr_26271_26405 = state_26160__$1;
(statearr_26271_26405[(2)] = inst_25986);

(statearr_26271_26405[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (78))){
var inst_25987 = (state_26160[(12)]);
var inst_26099 = (state_26160[(2)]);
var inst_26100 = (inst_25987 <= (0));
var state_26160__$1 = (function (){var statearr_26272 = state_26160;
(statearr_26272[(37)] = inst_26099);

return statearr_26272;
})();
if(cljs.core.truth_(inst_26100)){
var statearr_26273_26406 = state_26160__$1;
(statearr_26273_26406[(1)] = (79));

} else {
var statearr_26274_26407 = state_26160__$1;
(statearr_26274_26407[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (26))){
var inst_26118 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26275_26408 = state_26160__$1;
(statearr_26275_26408[(2)] = inst_26118);

(statearr_26275_26408[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (16))){
var state_26160__$1 = state_26160;
var statearr_26276_26409 = state_26160__$1;
(statearr_26276_26409[(2)] = null);

(statearr_26276_26409[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (81))){
var inst_26001 = (state_26160[(19)]);
var inst_25988 = (state_26160[(8)]);
var inst_25997 = (state_26160[(9)]);
var inst_26099 = (state_26160[(37)]);
var inst_26032 = (state_26160[(18)]);
var inst_25998 = (state_26160[(21)]);
var inst_26105 = (state_26160[(2)]);
var inst_26106 = cljs.core.assoc.call(null,inst_25988,inst_25997,inst_26032);
var inst_25984 = inst_25998;
var inst_25985 = inst_26001;
var inst_25986 = inst_26099;
var inst_25987 = inst_26105;
var inst_25988__$1 = inst_26106;
var state_26160__$1 = (function (){var statearr_26279 = state_26160;
(statearr_26279[(8)] = inst_25988__$1);

(statearr_26279[(22)] = inst_25984);

(statearr_26279[(23)] = inst_25985);

(statearr_26279[(11)] = inst_25986);

(statearr_26279[(12)] = inst_25987);

return statearr_26279;
})();
var statearr_26280_26410 = state_26160__$1;
(statearr_26280_26410[(2)] = null);

(statearr_26280_26410[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (79))){
var state_26160__$1 = state_26160;
var statearr_26281_26411 = state_26160__$1;
(statearr_26281_26411[(2)] = (0));

(statearr_26281_26411[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (38))){
var inst_26001 = (state_26160[(19)]);
var inst_25988 = (state_26160[(8)]);
var inst_25986 = (state_26160[(11)]);
var inst_25998 = (state_26160[(21)]);
var inst_26023 = (state_26160[(2)]);
var tmp26277 = inst_25988;
var tmp26278 = inst_25986;
var inst_25984 = inst_25998;
var inst_25985 = inst_26001;
var inst_25986__$1 = tmp26278;
var inst_25987 = inst_26023;
var inst_25988__$1 = tmp26277;
var state_26160__$1 = (function (){var statearr_26282 = state_26160;
(statearr_26282[(8)] = inst_25988__$1);

(statearr_26282[(22)] = inst_25984);

(statearr_26282[(23)] = inst_25985);

(statearr_26282[(11)] = inst_25986__$1);

(statearr_26282[(12)] = inst_25987);

return statearr_26282;
})();
var statearr_26283_26412 = state_26160__$1;
(statearr_26283_26412[(2)] = null);

(statearr_26283_26412[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (87))){
var state_26160__$1 = state_26160;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_26284_26413 = state_26160__$1;
(statearr_26284_26413[(1)] = (92));

} else {
var statearr_26285_26414 = state_26160__$1;
(statearr_26285_26414[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (30))){
var inst_25988 = (state_26160[(8)]);
var state_26160__$1 = state_26160;
var statearr_26286_26415 = state_26160__$1;
(statearr_26286_26415[(2)] = inst_25988);

(statearr_26286_26415[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (73))){
var inst_25988 = (state_26160[(8)]);
var state_26160__$1 = state_26160;
var statearr_26287_26416 = state_26160__$1;
(statearr_26287_26416[(2)] = inst_25988);

(statearr_26287_26416[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (96))){
var state_26160__$1 = state_26160;
var statearr_26288_26417 = state_26160__$1;
(statearr_26288_26417[(2)] = null);

(statearr_26288_26417[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (10))){
var inst_25928 = (state_26160[(35)]);
var state_26160__$1 = state_26160;
var statearr_26289_26418 = state_26160__$1;
(statearr_26289_26418[(2)] = inst_25928);

(statearr_26289_26418[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (18))){
var inst_25978 = (state_26160[(36)]);
var inst_25977 = (state_26160[(2)]);
var inst_25978__$1 = offset;
var state_26160__$1 = (function (){var statearr_26290 = state_26160;
(statearr_26290[(36)] = inst_25978__$1);

(statearr_26290[(26)] = inst_25977);

return statearr_26290;
})();
if(cljs.core.truth_(inst_25978__$1)){
var statearr_26291_26419 = state_26160__$1;
(statearr_26291_26419[(1)] = (19));

} else {
var statearr_26292_26420 = state_26160__$1;
(statearr_26292_26420[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (52))){
var inst_25986 = (state_26160[(11)]);
var inst_26048 = ((0) < inst_25986);
var state_26160__$1 = state_26160;
var statearr_26293_26421 = state_26160__$1;
(statearr_26293_26421[(2)] = inst_26048);

(statearr_26293_26421[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (67))){
var inst_26056 = (state_26160[(10)]);
var inst_26002 = (state_26160[(27)]);
var inst_25987 = (state_26160[(12)]);
var inst_26071 = cljs.core.count.call(null,inst_26056);
var inst_26072 = (inst_26002 - inst_26071);
var inst_26073 = (inst_25987 - inst_26072);
var state_26160__$1 = state_26160;
var statearr_26294_26422 = state_26160__$1;
(statearr_26294_26422[(2)] = inst_26073);

(statearr_26294_26422[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (71))){
var inst_26056 = (state_26160[(10)]);
var inst_26084 = cljs.core.empty_QMARK_.call(null,inst_26056);
var state_26160__$1 = state_26160;
var statearr_26295_26423 = state_26160__$1;
(statearr_26295_26423[(2)] = inst_26084);

(statearr_26295_26423[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (42))){
var inst_26032 = (state_26160[(18)]);
var inst_26033 = (state_26160[(33)]);
var inst_26031 = (state_26160[(2)]);
var inst_26032__$1 = fluree.db.util.async.throw_err.call(null,inst_26031);
var inst_26033__$1 = cljs.core.coll_QMARK_.call(null,inst_26032__$1);
var state_26160__$1 = (function (){var statearr_26296 = state_26160;
(statearr_26296[(18)] = inst_26032__$1);

(statearr_26296[(33)] = inst_26033__$1);

return statearr_26296;
})();
if(inst_26033__$1){
var statearr_26297_26424 = state_26160__$1;
(statearr_26297_26424[(1)] = (43));

} else {
var statearr_26298_26425 = state_26160__$1;
(statearr_26298_26425[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (80))){
var inst_25987 = (state_26160[(12)]);
var inst_26103 = (inst_25987 - (1));
var state_26160__$1 = state_26160;
var statearr_26299_26426 = state_26160__$1;
(statearr_26299_26426[(2)] = inst_26103);

(statearr_26299_26426[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (37))){
var inst_26002 = (state_26160[(27)]);
var inst_25987 = (state_26160[(12)]);
var inst_26021 = (inst_25987 - inst_26002);
var state_26160__$1 = state_26160;
var statearr_26300_26427 = state_26160__$1;
(statearr_26300_26427[(2)] = inst_26021);

(statearr_26300_26427[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (63))){
var inst_26056 = (state_26160[(10)]);
var inst_26081 = (state_26160[(7)]);
var inst_26080 = (state_26160[(2)]);
var inst_26081__$1 = (inst_26056 == null);
var state_26160__$1 = (function (){var statearr_26301 = state_26160;
(statearr_26301[(7)] = inst_26081__$1);

(statearr_26301[(20)] = inst_26080);

return statearr_26301;
})();
if(cljs.core.truth_(inst_26081__$1)){
var statearr_26302_26428 = state_26160__$1;
(statearr_26302_26428[(1)] = (70));

} else {
var statearr_26303_26429 = state_26160__$1;
(statearr_26303_26429[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (94))){
var inst_26151 = (state_26160[(2)]);
var state_26160__$1 = state_26160;
var statearr_26304_26430 = state_26160__$1;
(statearr_26304_26430[(2)] = inst_26151);

(statearr_26304_26430[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (8))){
var inst_26155 = (state_26160[(2)]);
var _ = (function (){var statearr_26305 = state_26160;
(statearr_26305[(4)] = cljs.core.rest.call(null,(state_26160[(4)])));

return statearr_26305;
})();
var state_26160__$1 = state_26160;
var statearr_26306_26431 = state_26160__$1;
(statearr_26306_26431[(2)] = inst_26155);

(statearr_26306_26431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (49))){
var inst_26032 = (state_26160[(18)]);
var inst_25987 = (state_26160[(12)]);
var inst_26043 = cljs.core.drop.call(null,inst_25987,inst_26032);
var state_26160__$1 = state_26160;
var statearr_26307_26432 = state_26160__$1;
(statearr_26307_26432[(2)] = inst_26043);

(statearr_26307_26432[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26161 === (84))){
var inst_26127 = (state_26160[(2)]);
var inst_26128 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_26127,opts);
var state_26160__$1 = state_26160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26160__$1,(85),inst_26128);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0 = (function (){
var statearr_26308 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26308[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__);

(statearr_26308[(1)] = (1));

return statearr_26308;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1 = (function (state_26160){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26309){var ex__2749__auto__ = e26309;
var statearr_26310_26433 = state_26160;
(statearr_26310_26433[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26160[(4)]))){
var statearr_26311_26434 = state_26160;
(statearr_26311_26434[(1)] = cljs.core.first.call(null,(state_26160[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26435 = state_26160;
state_26160 = G__26435;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = function(state_26160){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1.call(this,state_26160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26312 = f__2769__auto__.call(null);
(statearr_26312[(6)] = c__2768__auto__);

return statearr_26312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__26438,opts){
var map__26439 = p__26438;
var map__26439__$1 = cljs.core.__destructure_map.call(null,map__26439);
var selectOne = cljs.core.get.call(null,map__26439__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__26439__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__26439__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__26439__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__5045__auto__ = selectOne;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = select;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__26436_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__26436_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__26437_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__26437_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5804__auto__)){
var orderBy = temp__5804__auto__;
if(cljs.core.truth_((function (){var or__5045__auto__ = typeof orderBy === 'string';
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = cljs.core.vector_QMARK_.call(null,orderBy);
if(and__5043__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return and__5043__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})(),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__5045__auto__ = selectDistinct;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__26440,p__26441){
var map__26442 = p__26440;
var map__26442__$1 = cljs.core.__destructure_map.call(null,map__26442);
var query_map = map__26442__$1;
var construct = cljs.core.get.call(null,map__26442__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__26443 = p__26441;
var map__26443__$1 = cljs.core.__destructure_map.call(null,map__26443);
var where_result = map__26443__$1;
var headers = cljs.core.get.call(null,map__26443__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__26443__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__26444 = cljs.core.map.call(null,(function (construct_item){
var temp__5802__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5802__auto__)){
var index_of = temp__5802__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__26444,(0),null);
var fn2 = cljs.core.nth.call(null,vec__26444,(1),null);
var fn3 = cljs.core.nth.call(null,vec__26444,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26477){
var state_val_26478 = (state_26477[(1)]);
if((state_val_26478 === (7))){
var inst_26456 = (state_26477[(7)]);
var state_26477__$1 = state_26477;
var statearr_26479_26502 = state_26477__$1;
(statearr_26479_26502[(2)] = inst_26456);

(statearr_26479_26502[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26478 === (1))){
var state_26477__$1 = state_26477;
var statearr_26480_26503 = state_26477__$1;
(statearr_26480_26503[(2)] = null);

(statearr_26480_26503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26478 === (4))){
var inst_26447 = (state_26477[(2)]);
var state_26477__$1 = state_26477;
var statearr_26481_26504 = state_26477__$1;
(statearr_26481_26504[(2)] = inst_26447);

(statearr_26481_26504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26478 === (13))){
var inst_26466 = (state_26477[(2)]);
var inst_26467 = fluree.db.util.async.throw_err.call(null,inst_26466);
var state_26477__$1 = state_26477;
var statearr_26482_26505 = state_26477__$1;
(statearr_26482_26505[(2)] = inst_26467);

(statearr_26482_26505[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26478 === (6))){
var inst_26456 = (state_26477[(7)]);
var inst_26455 = (state_26477[(2)]);
var inst_26456__$1 = fluree.db.util.async.throw_err.call(null,inst_26455);
var inst_26457 = fluree.db.util.core.exception_QMARK_.call(null,inst_26456__$1);
var state_26477__$1 = (function (){var statearr_26483 = state_26477;
(statearr_26483[(7)] = inst_26456__$1);

return statearr_26483;
})();
if(inst_26457){
var statearr_26484_26506 = state_26477__$1;
(statearr_26484_26506[(1)] = (7));

} else {
var statearr_26485_26507 = state_26477__$1;
(statearr_26485_26507[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26478 === (3))){
var inst_26475 = (state_26477[(2)]);
var state_26477__$1 = state_26477;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26477__$1,inst_26475);
} else {
if((state_val_26478 === (12))){
var inst_26470 = (state_26477[(2)]);
var state_26477__$1 = state_26477;
var statearr_26486_26508 = state_26477__$1;
(statearr_26486_26508[(2)] = inst_26470);

(statearr_26486_26508[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26478 === (2))){
var _ = (function (){var statearr_26487 = state_26477;
(statearr_26487[(4)] = cljs.core.cons.call(null,(5),(state_26477[(4)])));

return statearr_26487;
})();
var inst_26453 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_26477__$1 = state_26477;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26477__$1,(6),inst_26453);
} else {
if((state_val_26478 === (11))){
var state_26477__$1 = state_26477;
var statearr_26489_26509 = state_26477__$1;
(statearr_26489_26509[(2)] = null);

(statearr_26489_26509[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26478 === (9))){
var inst_26472 = (state_26477[(2)]);
var _ = (function (){var statearr_26490 = state_26477;
(statearr_26490[(4)] = cljs.core.rest.call(null,(state_26477[(4)])));

return statearr_26490;
})();
var state_26477__$1 = state_26477;
var statearr_26491_26510 = state_26477__$1;
(statearr_26491_26510[(2)] = inst_26472);

(statearr_26491_26510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26478 === (5))){
var _ = (function (){var statearr_26492 = state_26477;
(statearr_26492[(4)] = cljs.core.rest.call(null,(state_26477[(4)])));

return statearr_26492;
})();
var state_26477__$1 = state_26477;
var ex26488 = (state_26477__$1[(2)]);
var statearr_26493_26511 = state_26477__$1;
(statearr_26493_26511[(5)] = ex26488);


if((ex26488 instanceof Error)){
var statearr_26494_26512 = state_26477__$1;
(statearr_26494_26512[(1)] = (4));

(statearr_26494_26512[(5)] = null);

} else {
throw ex26488;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26478 === (10))){
var inst_26456 = (state_26477[(7)]);
var inst_26461 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_26456);
var inst_26462 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_26456);
var inst_26463 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_26461,inst_26462,query_map,opts);
var inst_26464 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_26456,inst_26463,opts);
var state_26477__$1 = state_26477;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26477__$1,(13),inst_26464);
} else {
if((state_val_26478 === (8))){
var state_26477__$1 = state_26477;
var statearr_26495_26513 = state_26477__$1;
(statearr_26495_26513[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0 = (function (){
var statearr_26497 = [null,null,null,null,null,null,null,null];
(statearr_26497[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__);

(statearr_26497[(1)] = (1));

return statearr_26497;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1 = (function (state_26477){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26477);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26498){var ex__2749__auto__ = e26498;
var statearr_26499_26514 = state_26477;
(statearr_26499_26514[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26477[(4)]))){
var statearr_26500_26515 = state_26477;
(statearr_26500_26515[(1)] = cljs.core.first.call(null,(state_26477[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26516 = state_26477;
state_26477 = G__26516;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__ = function(state_26477){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1.call(this,state_26477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26501 = f__2769__auto__.call(null);
(statearr_26501[(6)] = c__2768__auto__);

return statearr_26501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

var map__26517 = query_map;
var map__26517__$1 = cljs.core.__destructure_map.call(null,map__26517);
var select = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__26517__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__26518 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.call(null,G__26518,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__26518;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = max_fuel;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26874){
var state_val_26875 = (state_26874[(1)]);
if((state_val_26875 === (121))){
var inst_26835 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26876_27071 = state_26874__$1;
(statearr_26876_27071[(2)] = inst_26835);

(statearr_26876_27071[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (65))){
var inst_26712 = typeof from === 'string';
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26712)){
var statearr_26877_27072 = state_26874__$1;
(statearr_26877_27072[(1)] = (72));

} else {
var statearr_26878_27073 = state_26874__$1;
(statearr_26878_27073[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (70))){
var inst_26580 = (state_26874[(7)]);
var inst_26578 = (state_26874[(8)]);
var inst_26705 = (state_26874[(2)]);
var inst_26706 = fluree.db.util.async.throw_err.call(null,inst_26705);
var inst_26707 = fluree.db.query.fql.flake_select.call(null,db,inst_26580,fuel,max_fuel,inst_26578,inst_26706);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(71),inst_26707);
} else {
if((state_val_26875 === (62))){
var inst_26685 = (state_26874[(9)]);
var state_26874__$1 = state_26874;
var statearr_26879_27074 = state_26874__$1;
(statearr_26879_27074[(2)] = inst_26685);

(statearr_26879_27074[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (74))){
var inst_26841 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26880_27075 = state_26874__$1;
(statearr_26880_27075[(2)] = inst_26841);

(statearr_26880_27075[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (110))){
var inst_26776 = (state_26874[(10)]);
var state_26874__$1 = state_26874;
var statearr_26881_27076 = state_26874__$1;
(statearr_26881_27076[(2)] = inst_26776);

(statearr_26881_27076[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (130))){
var inst_26861 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26882_27077 = state_26874__$1;
(statearr_26882_27077[(2)] = inst_26861);

(statearr_26882_27077[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (128))){
var inst_26852 = (state_26874[(11)]);
var inst_26857 = fluree.db.util.core.exception_QMARK_.call(null,inst_26852);
var inst_26858 = (!(inst_26857));
var state_26874__$1 = state_26874;
var statearr_26883_27078 = state_26874__$1;
(statearr_26883_27078[(2)] = inst_26858);

(statearr_26883_27078[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (7))){
var inst_26548 = (state_26874[(12)]);
var inst_26548__$1 = selectOne;
var state_26874__$1 = (function (){var statearr_26884 = state_26874;
(statearr_26884[(12)] = inst_26548__$1);

return statearr_26884;
})();
if(cljs.core.truth_(inst_26548__$1)){
var statearr_26885_27079 = state_26874__$1;
(statearr_26885_27079[(1)] = (9));

} else {
var statearr_26886_27080 = state_26874__$1;
(statearr_26886_27080[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (59))){
var inst_26580 = (state_26874[(7)]);
var inst_26663 = (state_26874[(13)]);
var inst_26578 = (state_26874[(8)]);
var inst_26568 = (state_26874[(14)]);
var inst_26677 = (state_26874[(2)]);
var inst_26678 = fluree.db.util.async.throw_err.call(null,inst_26677);
var inst_26679 = cljs.core.sequence.call(null,inst_26663,inst_26678);
var inst_26680 = fluree.db.query.fql.subject_select.call(null,db,inst_26580,fuel,max_fuel,inst_26578,inst_26679,inst_26568);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(60),inst_26680);
} else {
if((state_val_26875 === (86))){
var inst_26580 = (state_26874[(7)]);
var inst_26578 = (state_26874[(8)]);
var inst_26568 = (state_26874[(14)]);
var inst_26570 = (state_26874[(15)]);
var inst_26745 = (state_26874[(2)]);
var inst_26746 = fluree.db.query.fql.subject_select.call(null,db,inst_26580,fuel,max_fuel,inst_26578,inst_26745,inst_26568,inst_26570);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(87),inst_26746);
} else {
if((state_val_26875 === (20))){
var inst_26612 = (state_26874[(2)]);
var inst_26613 = cljs.core.nth.call(null,inst_26612,(0),null);
var inst_26614 = cljs.core.nth.call(null,inst_26612,(1),null);
var inst_26615 = typeof where === 'string';
var state_26874__$1 = (function (){var statearr_26887 = state_26874;
(statearr_26887[(16)] = inst_26614);

(statearr_26887[(17)] = inst_26613);

return statearr_26887;
})();
if(cljs.core.truth_(inst_26615)){
var statearr_26888_27081 = state_26874__$1;
(statearr_26888_27081[(1)] = (30));

} else {
var statearr_26889_27082 = state_26874__$1;
(statearr_26889_27082[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (72))){
var inst_26567 = (state_26874[(18)]);
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26567)){
var statearr_26890_27083 = state_26874__$1;
(statearr_26890_27083[(1)] = (75));

} else {
var statearr_26891_27084 = state_26874__$1;
(statearr_26891_27084[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (58))){
var inst_26671 = (state_26874[(2)]);
var inst_26672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26673 = [from];
var inst_26674 = (new cljs.core.PersistentVector(null,1,(5),inst_26672,inst_26673,null));
var inst_26675 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26674,inst_26671);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(59),inst_26675);
} else {
if((state_val_26875 === (60))){
var inst_26682 = (state_26874[(2)]);
var inst_26683 = fluree.db.util.async.throw_err.call(null,inst_26682);
var state_26874__$1 = state_26874;
var statearr_26892_27085 = state_26874__$1;
(statearr_26892_27085[(2)] = inst_26683);

(statearr_26892_27085[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (27))){
var inst_26597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26598 = [null,null];
var inst_26599 = (new cljs.core.PersistentVector(null,2,(5),inst_26597,inst_26598,null));
var state_26874__$1 = state_26874;
var statearr_26893_27086 = state_26874__$1;
(statearr_26893_27086[(2)] = inst_26599);

(statearr_26893_27086[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (1))){
var state_26874__$1 = state_26874;
var statearr_26894_27087 = state_26874__$1;
(statearr_26894_27087[(2)] = null);

(statearr_26894_27087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (69))){
var inst_26702 = (state_26874[(2)]);
var inst_26703 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_26702);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(70),inst_26703);
} else {
if((state_val_26875 === (101))){
var inst_26808 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26895_27088 = state_26874__$1;
(statearr_26895_27088[(2)] = inst_26808);

(statearr_26895_27088[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (24))){
var inst_26567 = (state_26874[(18)]);
var inst_26592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26593 = [inst_26567,"ASC"];
var inst_26594 = (new cljs.core.PersistentVector(null,2,(5),inst_26592,inst_26593,null));
var state_26874__$1 = state_26874;
var statearr_26896_27089 = state_26874__$1;
(statearr_26896_27089[(2)] = inst_26594);

(statearr_26896_27089[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (102))){
var inst_26782 = (state_26874[(19)]);
var state_26874__$1 = state_26874;
var statearr_26897_27090 = state_26874__$1;
(statearr_26897_27090[(2)] = inst_26782);

(statearr_26897_27090[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (55))){
var inst_26567 = (state_26874[(18)]);
var inst_26663 = (state_26874[(2)]);
var state_26874__$1 = (function (){var statearr_26898 = state_26874;
(statearr_26898[(13)] = inst_26663);

return statearr_26898;
})();
if(cljs.core.truth_(inst_26567)){
var statearr_26899_27091 = state_26874__$1;
(statearr_26899_27091[(1)] = (56));

} else {
var statearr_26900_27092 = state_26874__$1;
(statearr_26900_27092[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (85))){
var inst_26737 = (state_26874[(20)]);
var inst_26741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26742 = [inst_26737];
var inst_26743 = (new cljs.core.PersistentVector(null,1,(5),inst_26741,inst_26742,null));
var state_26874__$1 = state_26874;
var statearr_26901_27093 = state_26874__$1;
(statearr_26901_27093[(2)] = inst_26743);

(statearr_26901_27093[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (39))){
var inst_26568 = (state_26874[(14)]);
var state_26874__$1 = state_26874;
var statearr_26902_27094 = state_26874__$1;
(statearr_26902_27094[(2)] = inst_26568);

(statearr_26902_27094[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (88))){
var inst_26751 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_26874__$1 = state_26874;
var statearr_26903_27095 = state_26874__$1;
(statearr_26903_27095[(2)] = inst_26751);

(statearr_26903_27095[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (46))){
var inst_26648 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26648)){
var statearr_26904_27096 = state_26874__$1;
(statearr_26904_27096[(1)] = (47));

} else {
var statearr_26905_27097 = state_26874__$1;
(statearr_26905_27097[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (4))){
var inst_26535 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26906_27098 = state_26874__$1;
(statearr_26906_27098[(2)] = inst_26535);

(statearr_26906_27098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (77))){
var inst_26721 = (state_26874[(2)]);
var inst_26722 = fluree.db.query.range.collection.call(null,db,from,inst_26721);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(78),inst_26722);
} else {
if((state_val_26875 === (106))){
var state_26874__$1 = state_26874;
var statearr_26907_27099 = state_26874__$1;
(statearr_26907_27099[(2)] = null);

(statearr_26907_27099[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (119))){
var inst_26827 = cljs.core.pr_str.call(null,query_map);
var inst_26828 = ["Invalid 'from' in query:",inst_26827].join('');
var inst_26829 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26830 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26831 = cljs.core.PersistentHashMap.fromArrays(inst_26829,inst_26830);
var inst_26832 = cljs.core.ex_info.call(null,inst_26828,inst_26831);
var state_26874__$1 = state_26874;
var statearr_26908_27100 = state_26874__$1;
(statearr_26908_27100[(2)] = inst_26832);

(statearr_26908_27100[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (95))){
var state_26874__$1 = state_26874;
var statearr_26909_27101 = state_26874__$1;
(statearr_26909_27101[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (54))){
var inst_26657 = (state_26874[(21)]);
var state_26874__$1 = state_26874;
var statearr_26911_27102 = state_26874__$1;
(statearr_26911_27102[(2)] = inst_26657);

(statearr_26911_27102[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (92))){
var inst_26756 = (state_26874[(22)]);
var state_26874__$1 = state_26874;
var statearr_26912_27103 = state_26874__$1;
(statearr_26912_27103[(2)] = inst_26756);

(statearr_26912_27103[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (104))){
var inst_26800 = (state_26874[(23)]);
var inst_26800__$1 = (state_26874[(2)]);
var state_26874__$1 = (function (){var statearr_26913 = state_26874;
(statearr_26913[(23)] = inst_26800__$1);

return statearr_26913;
})();
if(cljs.core.truth_(inst_26800__$1)){
var statearr_26914_27104 = state_26874__$1;
(statearr_26914_27104[(1)] = (109));

} else {
var statearr_26915_27105 = state_26874__$1;
(statearr_26915_27105[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (15))){
var inst_26569 = (state_26874[(24)]);
var inst_26571 = (state_26874[(25)]);
var inst_26575 = cljs.core.assoc.call(null,inst_26571,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_26569);
var state_26874__$1 = state_26874;
var statearr_26916_27106 = state_26874__$1;
(statearr_26916_27106[(2)] = inst_26575);

(statearr_26916_27106[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (48))){
var inst_26685 = (state_26874[(9)]);
var inst_26685__$1 = typeof from === 'string';
var state_26874__$1 = (function (){var statearr_26917 = state_26874;
(statearr_26917[(9)] = inst_26685__$1);

return statearr_26917;
})();
if(cljs.core.truth_(inst_26685__$1)){
var statearr_26918_27107 = state_26874__$1;
(statearr_26918_27107[(1)] = (61));

} else {
var statearr_26919_27108 = state_26874__$1;
(statearr_26919_27108[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (50))){
var inst_26651 = (state_26874[(26)]);
var inst_26653 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_26654 = cljs.core.comp.call(null,inst_26651,inst_26653);
var state_26874__$1 = state_26874;
var statearr_26920_27109 = state_26874__$1;
(statearr_26920_27109[(2)] = inst_26654);

(statearr_26920_27109[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (116))){
var state_26874__$1 = state_26874;
var statearr_26921_27110 = state_26874__$1;
(statearr_26921_27110[(2)] = null);

(statearr_26921_27110[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (75))){
var inst_26715 = cljs.core.PersistentHashMap.EMPTY;
var state_26874__$1 = state_26874;
var statearr_26922_27111 = state_26874__$1;
(statearr_26922_27111[(2)] = inst_26715);

(statearr_26922_27111[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (99))){
var inst_26776 = (state_26874[(10)]);
var state_26874__$1 = state_26874;
var statearr_26923_27112 = state_26874__$1;
(statearr_26923_27112[(2)] = inst_26776);

(statearr_26923_27112[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (21))){
var inst_26567 = (state_26874[(18)]);
var inst_26584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26585 = cljs.core.second.call(null,inst_26567);
var inst_26586 = cljs.core.first.call(null,inst_26567);
var inst_26587 = [inst_26585,inst_26586];
var inst_26588 = (new cljs.core.PersistentVector(null,2,(5),inst_26584,inst_26587,null));
var state_26874__$1 = state_26874;
var statearr_26924_27113 = state_26874__$1;
(statearr_26924_27113[(2)] = inst_26588);

(statearr_26924_27113[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (31))){
var inst_26642 = (state_26874[(27)]);
var inst_26642__$1 = typeof from === 'string';
var state_26874__$1 = (function (){var statearr_26925 = state_26874;
(statearr_26925[(27)] = inst_26642__$1);

return statearr_26925;
})();
if(cljs.core.truth_(inst_26642__$1)){
var statearr_26926_27114 = state_26874__$1;
(statearr_26926_27114[(1)] = (44));

} else {
var statearr_26927_27115 = state_26874__$1;
(statearr_26927_27115[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (113))){
var state_26874__$1 = state_26874;
var statearr_26928_27116 = state_26874__$1;
(statearr_26928_27116[(2)] = null);

(statearr_26928_27116[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (32))){
var inst_26613 = (state_26874[(17)]);
var inst_26847 = (state_26874[(2)]);
var state_26874__$1 = (function (){var statearr_26929 = state_26874;
(statearr_26929[(28)] = inst_26847);

return statearr_26929;
})();
if(cljs.core.truth_(inst_26613)){
var statearr_26930_27117 = state_26874__$1;
(statearr_26930_27117[(1)] = (122));

} else {
var statearr_26931_27118 = state_26874__$1;
(statearr_26931_27118[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (40))){
var inst_26567 = (state_26874[(18)]);
var inst_26632 = (state_26874[(2)]);
var state_26874__$1 = (function (){var statearr_26932 = state_26874;
(statearr_26932[(29)] = inst_26632);

return statearr_26932;
})();
if(cljs.core.truth_(inst_26567)){
var statearr_26933_27119 = state_26874__$1;
(statearr_26933_27119[(1)] = (41));

} else {
var statearr_26934_27120 = state_26874__$1;
(statearr_26934_27120[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (129))){
var inst_26855 = (state_26874[(30)]);
var state_26874__$1 = state_26874;
var statearr_26935_27121 = state_26874__$1;
(statearr_26935_27121[(2)] = inst_26855);

(statearr_26935_27121[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (91))){
var inst_26758 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var state_26874__$1 = state_26874;
var statearr_26936_27122 = state_26874__$1;
(statearr_26936_27122[(2)] = inst_26758);

(statearr_26936_27122[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (117))){
var inst_26570 = (state_26874[(15)]);
var state_26874__$1 = state_26874;
var statearr_26937_27123 = state_26874__$1;
(statearr_26937_27123[(2)] = inst_26570);

(statearr_26937_27123[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (108))){
var inst_26797 = (state_26874[(2)]);
var inst_26798 = fluree.db.util.async.throw_err.call(null,inst_26797);
var state_26874__$1 = state_26874;
var statearr_26938_27124 = state_26874__$1;
(statearr_26938_27124[(2)] = inst_26798);

(statearr_26938_27124[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (56))){
var inst_26665 = cljs.core.PersistentHashMap.EMPTY;
var state_26874__$1 = state_26874;
var statearr_26939_27125 = state_26874__$1;
(statearr_26939_27125[(2)] = inst_26665);

(statearr_26939_27125[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (33))){
var state_26874__$1 = state_26874;
var statearr_26940_27126 = state_26874__$1;
(statearr_26940_27126[(2)] = from);

(statearr_26940_27126[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (13))){
var inst_26554 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26555 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26556 = cljs.core.PersistentHashMap.fromArrays(inst_26554,inst_26555);
var inst_26557 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_26556);
var inst_26558 = (function(){throw inst_26557})();
var state_26874__$1 = state_26874;
var statearr_26941_27127 = state_26874__$1;
(statearr_26941_27127[(2)] = inst_26558);

(statearr_26941_27127[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (22))){
var inst_26567 = (state_26874[(18)]);
var inst_26590 = typeof inst_26567 === 'string';
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26590)){
var statearr_26942_27128 = state_26874__$1;
(statearr_26942_27128[(1)] = (24));

} else {
var statearr_26943_27129 = state_26874__$1;
(statearr_26943_27129[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (90))){
var inst_26749 = (state_26874[(31)]);
var inst_26754 = (state_26874[(2)]);
var state_26874__$1 = (function (){var statearr_26944 = state_26874;
(statearr_26944[(32)] = inst_26754);

return statearr_26944;
})();
var statearr_26945_27130 = state_26874__$1;
(statearr_26945_27130[(2)] = inst_26749);

(statearr_26945_27130[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (109))){
var inst_26776 = (state_26874[(10)]);
var inst_26800 = (state_26874[(23)]);
var inst_26802 = cljs.core.conj.call(null,inst_26776,inst_26800);
var state_26874__$1 = state_26874;
var statearr_26946_27131 = state_26874__$1;
(statearr_26946_27131[(2)] = inst_26802);

(statearr_26946_27131[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (36))){
var inst_26567 = (state_26874[(18)]);
var inst_26627 = (state_26874[(2)]);
var inst_26628 = fluree.db.util.async.throw_err.call(null,inst_26627);
var state_26874__$1 = (function (){var statearr_26947 = state_26874;
(statearr_26947[(33)] = inst_26628);

return statearr_26947;
})();
if(cljs.core.truth_(inst_26567)){
var statearr_26948_27132 = state_26874__$1;
(statearr_26948_27132[(1)] = (38));

} else {
var statearr_26949_27133 = state_26874__$1;
(statearr_26949_27133[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (41))){
var state_26874__$1 = state_26874;
var statearr_26950_27134 = state_26874__$1;
(statearr_26950_27134[(2)] = null);

(statearr_26950_27134[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (118))){
var inst_26580 = (state_26874[(7)]);
var inst_26816 = (state_26874[(34)]);
var inst_26812 = (state_26874[(35)]);
var inst_26578 = (state_26874[(8)]);
var inst_26820 = (state_26874[(2)]);
var inst_26821 = fluree.db.query.fql.subject_select.call(null,db,inst_26580,fuel,max_fuel,inst_26578,inst_26812,inst_26816,inst_26820);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(112),inst_26821);
} else {
if((state_val_26875 === (89))){
var state_26874__$1 = state_26874;
var statearr_26951_27135 = state_26874__$1;
(statearr_26951_27135[(2)] = null);

(statearr_26951_27135[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (100))){
var inst_26782 = (state_26874[(19)]);
var inst_26787 = cljs.core.int_QMARK_.call(null,inst_26782);
var state_26874__$1 = state_26874;
if(inst_26787){
var statearr_26952_27136 = state_26874__$1;
(statearr_26952_27136[(1)] = (102));

} else {
var statearr_26953_27137 = state_26874__$1;
(statearr_26953_27137[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (131))){
var inst_26852 = (state_26874[(11)]);
var inst_26866 = cljs.core.first.call(null,inst_26852);
var state_26874__$1 = state_26874;
var statearr_26954_27138 = state_26874__$1;
(statearr_26954_27138[(2)] = inst_26866);

(statearr_26954_27138[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (122))){
var inst_26847 = (state_26874[(28)]);
var inst_26614 = (state_26874[(16)]);
var inst_26613 = (state_26874[(17)]);
var inst_26568 = (state_26874[(14)]);
var inst_26570 = (state_26874[(15)]);
var inst_26849 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_26613,inst_26614,inst_26570,inst_26568,inst_26847);
var state_26874__$1 = state_26874;
var statearr_26955_27139 = state_26874__$1;
(statearr_26955_27139[(2)] = inst_26849);

(statearr_26955_27139[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (43))){
var inst_26580 = (state_26874[(7)]);
var inst_26628 = (state_26874[(33)]);
var inst_26632 = (state_26874[(29)]);
var inst_26578 = (state_26874[(8)]);
var inst_26636 = (state_26874[(2)]);
var inst_26637 = fluree.db.query.fql.subject_select.call(null,db,inst_26580,fuel,max_fuel,inst_26578,inst_26628,inst_26632,inst_26636);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(37),inst_26637);
} else {
if((state_val_26875 === (61))){
var inst_26687 = ["_tx",null,"_block",null];
var inst_26688 = (new cljs.core.PersistentArrayMap(null,2,inst_26687,null));
var inst_26689 = (new cljs.core.PersistentHashSet(null,inst_26688,null));
var inst_26690 = inst_26689.call(null,from);
var state_26874__$1 = state_26874;
var statearr_26956_27140 = state_26874__$1;
(statearr_26956_27140[(2)] = inst_26690);

(statearr_26956_27140[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (29))){
var inst_26602 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26957_27141 = state_26874__$1;
(statearr_26957_27141[(2)] = inst_26602);

(statearr_26957_27141[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (44))){
var inst_26644 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_26645 = clojure.string.includes_QMARK_.call(null,inst_26644,"/");
var state_26874__$1 = state_26874;
var statearr_26958_27142 = state_26874__$1;
(statearr_26958_27142[(2)] = inst_26645);

(statearr_26958_27142[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (93))){
var inst_26761 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26761)){
var statearr_26959_27143 = state_26874__$1;
(statearr_26959_27143[(1)] = (94));

} else {
var statearr_26960_27144 = state_26874__$1;
(statearr_26960_27144[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (6))){
var inst_26545 = (state_26874[(36)]);
var state_26874__$1 = state_26874;
var statearr_26961_27145 = state_26874__$1;
(statearr_26961_27145[(2)] = inst_26545);

(statearr_26961_27145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (111))){
var inst_26783 = (state_26874[(37)]);
var inst_26805 = (state_26874[(2)]);
var inst_26775 = inst_26783;
var inst_26776 = inst_26805;
var state_26874__$1 = (function (){var statearr_26962 = state_26874;
(statearr_26962[(10)] = inst_26776);

(statearr_26962[(38)] = inst_26775);

return statearr_26962;
})();
var statearr_26963_27146 = state_26874__$1;
(statearr_26963_27146[(2)] = null);

(statearr_26963_27146[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (28))){
var state_26874__$1 = state_26874;
var statearr_26964_27147 = state_26874__$1;
(statearr_26964_27147[(2)] = null);

(statearr_26964_27147[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (64))){
var inst_26567 = (state_26874[(18)]);
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26567)){
var statearr_26965_27148 = state_26874__$1;
(statearr_26965_27148[(1)] = (67));

} else {
var statearr_26966_27149 = state_26874__$1;
(statearr_26966_27149[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (103))){
var state_26874__$1 = state_26874;
if(cljs.core.truth_(fuel)){
var statearr_26967_27150 = state_26874__$1;
(statearr_26967_27150[(1)] = (105));

} else {
var statearr_26968_27151 = state_26874__$1;
(statearr_26968_27151[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (51))){
var inst_26651 = (state_26874[(26)]);
var state_26874__$1 = state_26874;
var statearr_26969_27152 = state_26874__$1;
(statearr_26969_27152[(2)] = inst_26651);

(statearr_26969_27152[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (25))){
var state_26874__$1 = state_26874;
var statearr_26970_27153 = state_26874__$1;
(statearr_26970_27153[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (34))){
var state_26874__$1 = state_26874;
var statearr_26972_27154 = state_26874__$1;
(statearr_26972_27154[(2)] = null);

(statearr_26972_27154[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (125))){
var inst_26855 = (state_26874[(30)]);
var inst_26852 = (state_26874[(11)]);
var inst_26855__$1 = cljs.core.coll_QMARK_.call(null,inst_26852);
var state_26874__$1 = (function (){var statearr_26973 = state_26874;
(statearr_26973[(30)] = inst_26855__$1);

return statearr_26973;
})();
if(inst_26855__$1){
var statearr_26974_27155 = state_26874__$1;
(statearr_26974_27155[(1)] = (128));

} else {
var statearr_26975_27156 = state_26874__$1;
(statearr_26975_27156[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (17))){
var inst_26567 = (state_26874[(18)]);
var inst_26578 = (state_26874[(2)]);
var inst_26579 = cljs.core.PersistentHashMap.EMPTY;
var inst_26580 = cljs.core.volatile_BANG_.call(null,inst_26579);
var state_26874__$1 = (function (){var statearr_26976 = state_26874;
(statearr_26976[(7)] = inst_26580);

(statearr_26976[(8)] = inst_26578);

return statearr_26976;
})();
if(cljs.core.truth_(inst_26567)){
var statearr_26977_27157 = state_26874__$1;
(statearr_26977_27157[(1)] = (18));

} else {
var statearr_26978_27158 = state_26874__$1;
(statearr_26978_27158[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (3))){
var inst_26872 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26874__$1,inst_26872);
} else {
if((state_val_26875 === (12))){
var inst_26551 = (state_26874[(39)]);
var state_26874__$1 = state_26874;
var statearr_26979_27159 = state_26874__$1;
(statearr_26979_27159[(2)] = inst_26551);

(statearr_26979_27159[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (2))){
var inst_26545 = (state_26874[(36)]);
var _ = (function (){var statearr_26980 = state_26874;
(statearr_26980[(4)] = cljs.core.cons.call(null,(5),(state_26874[(4)])));

return statearr_26980;
})();
var inst_26545__$1 = select;
var state_26874__$1 = (function (){var statearr_26981 = state_26874;
(statearr_26981[(36)] = inst_26545__$1);

return statearr_26981;
})();
if(cljs.core.truth_(inst_26545__$1)){
var statearr_26982_27160 = state_26874__$1;
(statearr_26982_27160[(1)] = (6));

} else {
var statearr_26983_27161 = state_26874__$1;
(statearr_26983_27161[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (66))){
var inst_26843 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26984_27162 = state_26874__$1;
(statearr_26984_27162[(2)] = inst_26843);

(statearr_26984_27162[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (107))){
var inst_26782 = (state_26874[(19)]);
var inst_26794 = (state_26874[(2)]);
var inst_26795 = fluree.db.dbproto._subid.call(null,db,inst_26782,false);
var state_26874__$1 = (function (){var statearr_26985 = state_26874;
(statearr_26985[(40)] = inst_26794);

return statearr_26985;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(108),inst_26795);
} else {
if((state_val_26875 === (23))){
var inst_26606 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26986_27163 = state_26874__$1;
(statearr_26986_27163[(2)] = inst_26606);

(statearr_26986_27163[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (47))){
var inst_26651 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_26874__$1 = (function (){var statearr_26987 = state_26874;
(statearr_26987[(26)] = inst_26651);

return statearr_26987;
})();
if(cljs.core.truth_(fuel)){
var statearr_26988_27164 = state_26874__$1;
(statearr_26988_27164[(1)] = (50));

} else {
var statearr_26989_27165 = state_26874__$1;
(statearr_26989_27165[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (35))){
var inst_26568 = (state_26874[(14)]);
var inst_26570 = (state_26874[(15)]);
var inst_26621 = (state_26874[(2)]);
var inst_26622 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26623 = [inst_26568,inst_26570];
var inst_26624 = cljs.core.PersistentHashMap.fromArrays(inst_26622,inst_26623);
var inst_26625 = fluree.db.query.fql.where_filter.call(null,db,where,inst_26621,inst_26624);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(36),inst_26625);
} else {
if((state_val_26875 === (127))){
var inst_26864 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26864)){
var statearr_26990_27166 = state_26874__$1;
(statearr_26990_27166[(1)] = (131));

} else {
var statearr_26991_27167 = state_26874__$1;
(statearr_26991_27167[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (82))){
var inst_26839 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26992_27168 = state_26874__$1;
(statearr_26992_27168[(2)] = inst_26839);

(statearr_26992_27168[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (76))){
var inst_26568 = (state_26874[(14)]);
var inst_26570 = (state_26874[(15)]);
var inst_26717 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26718 = [inst_26568,inst_26570];
var inst_26719 = cljs.core.PersistentHashMap.fromArrays(inst_26717,inst_26718);
var state_26874__$1 = state_26874;
var statearr_26993_27169 = state_26874__$1;
(statearr_26993_27169[(2)] = inst_26719);

(statearr_26993_27169[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (97))){
var inst_26782 = (state_26874[(19)]);
var inst_26775 = (state_26874[(38)]);
var inst_26781 = cljs.core.seq.call(null,inst_26775);
var inst_26782__$1 = cljs.core.first.call(null,inst_26781);
var inst_26783 = cljs.core.next.call(null,inst_26781);
var inst_26784 = cljs.core.not.call(null,inst_26782__$1);
var state_26874__$1 = (function (){var statearr_26994 = state_26874;
(statearr_26994[(37)] = inst_26783);

(statearr_26994[(19)] = inst_26782__$1);

return statearr_26994;
})();
if(inst_26784){
var statearr_26995_27170 = state_26874__$1;
(statearr_26995_27170[(1)] = (99));

} else {
var statearr_26996_27171 = state_26874__$1;
(statearr_26996_27171[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (19))){
var inst_26608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26609 = [null,null];
var inst_26610 = (new cljs.core.PersistentVector(null,2,(5),inst_26608,inst_26609,null));
var state_26874__$1 = state_26874;
var statearr_26997_27172 = state_26874__$1;
(statearr_26997_27172[(2)] = inst_26610);

(statearr_26997_27172[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (57))){
var inst_26568 = (state_26874[(14)]);
var inst_26570 = (state_26874[(15)]);
var inst_26667 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26668 = [inst_26568,inst_26570];
var inst_26669 = cljs.core.PersistentHashMap.fromArrays(inst_26667,inst_26668);
var state_26874__$1 = state_26874;
var statearr_26998_27173 = state_26874__$1;
(statearr_26998_27173[(2)] = inst_26669);

(statearr_26998_27173[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (68))){
var inst_26568 = (state_26874[(14)]);
var inst_26570 = (state_26874[(15)]);
var inst_26698 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26699 = [inst_26568,inst_26570];
var inst_26700 = cljs.core.PersistentHashMap.fromArrays(inst_26698,inst_26699);
var state_26874__$1 = state_26874;
var statearr_26999_27174 = state_26874__$1;
(statearr_26999_27174[(2)] = inst_26700);

(statearr_26999_27174[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (11))){
var inst_26562 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_27000_27175 = state_26874__$1;
(statearr_27000_27175[(2)] = inst_26562);

(statearr_27000_27175[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (115))){
var inst_26567 = (state_26874[(18)]);
var inst_26816 = (state_26874[(2)]);
var state_26874__$1 = (function (){var statearr_27002 = state_26874;
(statearr_27002[(34)] = inst_26816);

return statearr_27002;
})();
if(cljs.core.truth_(inst_26567)){
var statearr_27003_27176 = state_26874__$1;
(statearr_27003_27176[(1)] = (116));

} else {
var statearr_27004_27177 = state_26874__$1;
(statearr_27004_27177[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (9))){
var inst_26548 = (state_26874[(12)]);
var state_26874__$1 = state_26874;
var statearr_27005_27178 = state_26874__$1;
(statearr_27005_27178[(2)] = inst_26548);

(statearr_27005_27178[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (5))){
var _ = (function (){var statearr_27006 = state_26874;
(statearr_27006[(4)] = cljs.core.rest.call(null,(state_26874[(4)])));

return statearr_27006;
})();
var state_26874__$1 = state_26874;
var ex27001 = (state_26874__$1[(2)]);
var statearr_27007_27179 = state_26874__$1;
(statearr_27007_27179[(5)] = ex27001);


if((ex27001 instanceof Error)){
var statearr_27008_27180 = state_26874__$1;
(statearr_27008_27180[(1)] = (4));

(statearr_27008_27180[(5)] = null);

} else {
throw ex27001;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (112))){
var inst_26823 = (state_26874[(2)]);
var inst_26824 = fluree.db.util.async.throw_err.call(null,inst_26823);
var state_26874__$1 = state_26874;
var statearr_27009_27181 = state_26874__$1;
(statearr_27009_27181[(2)] = inst_26824);

(statearr_27009_27181[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (83))){
var inst_26737 = (state_26874[(20)]);
var inst_26736 = (state_26874[(2)]);
var inst_26737__$1 = fluree.db.util.async.throw_err.call(null,inst_26736);
var inst_26738 = (inst_26737__$1 == null);
var state_26874__$1 = (function (){var statearr_27010 = state_26874;
(statearr_27010[(20)] = inst_26737__$1);

return statearr_27010;
})();
if(cljs.core.truth_(inst_26738)){
var statearr_27011_27182 = state_26874__$1;
(statearr_27011_27182[(1)] = (84));

} else {
var statearr_27012_27183 = state_26874__$1;
(statearr_27012_27183[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (14))){
var inst_26560 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_27013_27184 = state_26874__$1;
(statearr_27013_27184[(2)] = inst_26560);

(statearr_27013_27184[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (45))){
var inst_26642 = (state_26874[(27)]);
var state_26874__$1 = state_26874;
var statearr_27014_27185 = state_26874__$1;
(statearr_27014_27185[(2)] = inst_26642);

(statearr_27014_27185[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (53))){
var inst_26657 = (state_26874[(21)]);
var inst_26659 = cljs.core.distinct.call(null);
var inst_26660 = cljs.core.comp.call(null,inst_26657,inst_26659);
var state_26874__$1 = state_26874;
var statearr_27015_27186 = state_26874__$1;
(statearr_27015_27186[(2)] = inst_26660);

(statearr_27015_27186[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (78))){
var inst_26580 = (state_26874[(7)]);
var inst_26578 = (state_26874[(8)]);
var inst_26724 = (state_26874[(2)]);
var inst_26725 = fluree.db.util.async.throw_err.call(null,inst_26724);
var inst_26726 = fluree.db.query.fql.flake_select.call(null,db,inst_26580,fuel,max_fuel,inst_26578,inst_26725);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(79),inst_26726);
} else {
if((state_val_26875 === (132))){
var inst_26852 = (state_26874[(11)]);
var state_26874__$1 = state_26874;
var statearr_27016_27187 = state_26874__$1;
(statearr_27016_27187[(2)] = inst_26852);

(statearr_27016_27187[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (26))){
var inst_26604 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_27017_27188 = state_26874__$1;
(statearr_27017_27188[(2)] = inst_26604);

(statearr_27017_27188[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (123))){
var inst_26847 = (state_26874[(28)]);
var state_26874__$1 = state_26874;
var statearr_27018_27189 = state_26874__$1;
(statearr_27018_27189[(2)] = inst_26847);

(statearr_27018_27189[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (16))){
var inst_26571 = (state_26874[(25)]);
var state_26874__$1 = state_26874;
var statearr_27019_27190 = state_26874__$1;
(statearr_27019_27190[(2)] = inst_26571);

(statearr_27019_27190[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (133))){
var inst_26869 = (state_26874[(2)]);
var _ = (function (){var statearr_27020 = state_26874;
(statearr_27020[(4)] = cljs.core.rest.call(null,(state_26874[(4)])));

return statearr_27020;
})();
var state_26874__$1 = state_26874;
var statearr_27021_27191 = state_26874__$1;
(statearr_27021_27191[(2)] = inst_26869);

(statearr_27021_27191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (81))){
var inst_26756 = (state_26874[(22)]);
var inst_26756__$1 = cljs.core.sequential_QMARK_.call(null,from);
var state_26874__$1 = (function (){var statearr_27022 = state_26874;
(statearr_27022[(22)] = inst_26756__$1);

return statearr_27022;
})();
if(inst_26756__$1){
var statearr_27023_27192 = state_26874__$1;
(statearr_27023_27192[(1)] = (91));

} else {
var statearr_27024_27193 = state_26874__$1;
(statearr_27024_27193[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (120))){
var state_26874__$1 = state_26874;
var statearr_27025_27194 = state_26874__$1;
(statearr_27025_27194[(2)] = null);

(statearr_27025_27194[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (79))){
var inst_26728 = (state_26874[(2)]);
var inst_26729 = fluree.db.util.async.throw_err.call(null,inst_26728);
var state_26874__$1 = state_26874;
var statearr_27026_27195 = state_26874__$1;
(statearr_27026_27195[(2)] = inst_26729);

(statearr_27026_27195[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (38))){
var state_26874__$1 = state_26874;
var statearr_27027_27196 = state_26874__$1;
(statearr_27027_27196[(2)] = null);

(statearr_27027_27196[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (126))){
var inst_26853 = (state_26874[(41)]);
var state_26874__$1 = state_26874;
var statearr_27028_27197 = state_26874__$1;
(statearr_27028_27197[(2)] = inst_26853);

(statearr_27028_27197[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (98))){
var inst_26567 = (state_26874[(18)]);
var inst_26810 = (state_26874[(2)]);
var inst_26811 = cljs.core.PersistentVector.EMPTY;
var inst_26812 = cljs.core.into.call(null,inst_26811,inst_26810);
var state_26874__$1 = (function (){var statearr_27029 = state_26874;
(statearr_27029[(35)] = inst_26812);

return statearr_27029;
})();
if(cljs.core.truth_(inst_26567)){
var statearr_27030_27198 = state_26874__$1;
(statearr_27030_27198[(1)] = (113));

} else {
var statearr_27031_27199 = state_26874__$1;
(statearr_27031_27199[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (124))){
var inst_26853 = (state_26874[(41)]);
var inst_26852 = (state_26874[(2)]);
var inst_26853__$1 = selectOne;
var state_26874__$1 = (function (){var statearr_27032 = state_26874;
(statearr_27032[(41)] = inst_26853__$1);

(statearr_27032[(11)] = inst_26852);

return statearr_27032;
})();
if(cljs.core.truth_(inst_26853__$1)){
var statearr_27033_27200 = state_26874__$1;
(statearr_27033_27200[(1)] = (125));

} else {
var statearr_27034_27201 = state_26874__$1;
(statearr_27034_27201[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (87))){
var inst_26748 = (state_26874[(2)]);
var inst_26749 = fluree.db.util.async.throw_err.call(null,inst_26748);
var state_26874__$1 = (function (){var statearr_27035 = state_26874;
(statearr_27035[(31)] = inst_26749);

return statearr_27035;
})();
if(cljs.core.truth_(fuel)){
var statearr_27036_27202 = state_26874__$1;
(statearr_27036_27202[(1)] = (88));

} else {
var statearr_27037_27203 = state_26874__$1;
(statearr_27037_27203[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (30))){
var inst_26617 = typeof from === 'string';
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26617)){
var statearr_27038_27204 = state_26874__$1;
(statearr_27038_27204[(1)] = (33));

} else {
var statearr_27039_27205 = state_26874__$1;
(statearr_27039_27205[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (73))){
var inst_26731 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_26874__$1 = state_26874;
if(inst_26731){
var statearr_27040_27206 = state_26874__$1;
(statearr_27040_27206[(1)] = (80));

} else {
var statearr_27041_27207 = state_26874__$1;
(statearr_27041_27207[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (96))){
var inst_26837 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_27042_27208 = state_26874__$1;
(statearr_27042_27208[(2)] = inst_26837);

(statearr_27042_27208[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (10))){
var inst_26551 = (state_26874[(39)]);
var inst_26551__$1 = selectDistinct;
var state_26874__$1 = (function (){var statearr_27043 = state_26874;
(statearr_27043[(39)] = inst_26551__$1);

return statearr_27043;
})();
if(cljs.core.truth_(inst_26551__$1)){
var statearr_27044_27209 = state_26874__$1;
(statearr_27044_27209[(1)] = (12));

} else {
var statearr_27045_27210 = state_26874__$1;
(statearr_27045_27210[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (18))){
var inst_26567 = (state_26874[(18)]);
var inst_26582 = cljs.core.vector_QMARK_.call(null,inst_26567);
var state_26874__$1 = state_26874;
if(inst_26582){
var statearr_27046_27211 = state_26874__$1;
(statearr_27046_27211[(1)] = (21));

} else {
var statearr_27047_27212 = state_26874__$1;
(statearr_27047_27212[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (105))){
var inst_26791 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_26874__$1 = state_26874;
var statearr_27048_27213 = state_26874__$1;
(statearr_27048_27213[(2)] = inst_26791);

(statearr_27048_27213[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (52))){
var inst_26657 = (state_26874[(2)]);
var state_26874__$1 = (function (){var statearr_27049 = state_26874;
(statearr_27049[(21)] = inst_26657);

return statearr_27049;
})();
var statearr_27050_27214 = state_26874__$1;
(statearr_27050_27214[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (114))){
var inst_26568 = (state_26874[(14)]);
var state_26874__$1 = state_26874;
var statearr_27052_27215 = state_26874__$1;
(statearr_27052_27215[(2)] = inst_26568);

(statearr_27052_27215[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (67))){
var inst_26696 = cljs.core.PersistentHashMap.EMPTY;
var state_26874__$1 = state_26874;
var statearr_27053_27216 = state_26874__$1;
(statearr_27053_27216[(2)] = inst_26696);

(statearr_27053_27216[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (71))){
var inst_26709 = (state_26874[(2)]);
var inst_26710 = fluree.db.util.async.throw_err.call(null,inst_26709);
var state_26874__$1 = state_26874;
var statearr_27054_27217 = state_26874__$1;
(statearr_27054_27217[(2)] = inst_26710);

(statearr_27054_27217[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (42))){
var inst_26570 = (state_26874[(15)]);
var state_26874__$1 = state_26874;
var statearr_27055_27218 = state_26874__$1;
(statearr_27055_27218[(2)] = inst_26570);

(statearr_27055_27218[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (80))){
var inst_26734 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(83),inst_26734);
} else {
if((state_val_26875 === (37))){
var inst_26639 = (state_26874[(2)]);
var inst_26640 = fluree.db.util.async.throw_err.call(null,inst_26639);
var state_26874__$1 = state_26874;
var statearr_27056_27219 = state_26874__$1;
(statearr_27056_27219[(2)] = inst_26640);

(statearr_27056_27219[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (63))){
var inst_26693 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26693)){
var statearr_27057_27220 = state_26874__$1;
(statearr_27057_27220[(1)] = (64));

} else {
var statearr_27058_27221 = state_26874__$1;
(statearr_27058_27221[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (94))){
var inst_26770 = from;
var inst_26771 = cljs.core.seq.call(null,inst_26770);
var inst_26772 = cljs.core.first.call(null,inst_26771);
var inst_26773 = cljs.core.next.call(null,inst_26771);
var inst_26774 = cljs.core.PersistentVector.EMPTY;
var inst_26775 = inst_26770;
var inst_26776 = inst_26774;
var state_26874__$1 = (function (){var statearr_27059 = state_26874;
(statearr_27059[(10)] = inst_26776);

(statearr_27059[(42)] = inst_26772);

(statearr_27059[(43)] = inst_26773);

(statearr_27059[(38)] = inst_26775);

return statearr_27059;
})();
var statearr_27060_27222 = state_26874__$1;
(statearr_27060_27222[(2)] = null);

(statearr_27060_27222[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (8))){
var inst_26569 = (state_26874[(24)]);
var inst_26564 = (state_26874[(2)]);
var inst_26565 = opts_SINGLEQUOTE_;
var inst_26566 = cljs.core.__destructure_map.call(null,inst_26565);
var inst_26567 = cljs.core.get.call(null,inst_26566,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_26568 = cljs.core.get.call(null,inst_26566,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_26569__$1 = cljs.core.get.call(null,inst_26566,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_26570 = cljs.core.get.call(null,inst_26566,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_26571 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_26564,opts_SINGLEQUOTE_);
var inst_26572 = (inst_26569__$1 == null);
var inst_26573 = cljs.core.not.call(null,inst_26572);
var state_26874__$1 = (function (){var statearr_27061 = state_26874;
(statearr_27061[(24)] = inst_26569__$1);

(statearr_27061[(18)] = inst_26567);

(statearr_27061[(25)] = inst_26571);

(statearr_27061[(14)] = inst_26568);

(statearr_27061[(15)] = inst_26570);

return statearr_27061;
})();
if(inst_26573){
var statearr_27062_27223 = state_26874__$1;
(statearr_27062_27223[(1)] = (15));

} else {
var statearr_27063_27224 = state_26874__$1;
(statearr_27063_27224[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (49))){
var inst_26845 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_27064_27225 = state_26874__$1;
(statearr_27064_27225[(2)] = inst_26845);

(statearr_27064_27225[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (84))){
var state_26874__$1 = state_26874;
var statearr_27065_27226 = state_26874__$1;
(statearr_27065_27226[(2)] = null);

(statearr_27065_27226[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2746__auto____0 = (function (){
var statearr_27066 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27066[(0)] = fluree$db$query$fql$query_$_state_machine__2746__auto__);

(statearr_27066[(1)] = (1));

return statearr_27066;
});
var fluree$db$query$fql$query_$_state_machine__2746__auto____1 = (function (state_26874){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26874);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27067){var ex__2749__auto__ = e27067;
var statearr_27068_27227 = state_26874;
(statearr_27068_27227[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26874[(4)]))){
var statearr_27069_27228 = state_26874;
(statearr_27069_27228[(1)] = cljs.core.first.call(null,(state_26874[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27229 = state_26874;
state_26874 = G__27229;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2746__auto__ = function(state_26874){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2746__auto____1.call(this,state_26874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2746__auto____0;
fluree$db$query$fql$query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27070 = f__2769__auto__.call(null);
(statearr_27070[(6)] = c__2768__auto__);

return statearr_27070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}

});
