// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__20663_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20663_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__20667 = coll;
var vec__20668 = G__20667;
var seq__20669 = cljs.core.seq.call(null,vec__20668);
var first__20670 = cljs.core.first.call(null,seq__20669);
var seq__20669__$1 = cljs.core.next.call(null,seq__20669);
var clause = first__20670;
var r = seq__20669__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20667__$1 = G__20667;
var res__$1 = res;
while(true){
var vec__20674 = G__20667__$1;
var seq__20675 = cljs.core.seq.call(null,vec__20674);
var first__20676 = cljs.core.first.call(null,seq__20675);
var seq__20675__$1 = cljs.core.next.call(null,seq__20675);
var clause__$1 = first__20676;
var r__$1 = seq__20675__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__20677 = r__$1;
var G__20678 = cljs.core.conj.call(null,res__$2,clause__$1);
G__20667__$1 = G__20677;
res__$1 = G__20678;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__20679){
var map__20680 = p__20679;
var map__20680__$1 = cljs.core.__destructure_map.call(null,map__20680);
var optional = cljs.core.get.call(null,map__20680__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__20684 = coll;
var vec__20685 = G__20684;
var seq__20686 = cljs.core.seq.call(null,vec__20685);
var first__20687 = cljs.core.first.call(null,seq__20686);
var seq__20686__$1 = cljs.core.next.call(null,seq__20686);
var clause = first__20687;
var r = seq__20686__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20684__$1 = G__20684;
var res__$1 = res;
while(true){
var vec__20691 = G__20684__$1;
var seq__20692 = cljs.core.seq.call(null,vec__20691);
var first__20693 = cljs.core.first.call(null,seq__20692);
var seq__20692__$1 = cljs.core.next.call(null,seq__20692);
var clause__$1 = first__20693;
var r__$1 = seq__20692__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__20694 = r__$1;
var G__20695 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__20684__$1 = G__20694;
res__$1 = G__20695;
continue;
} else {
var G__20696 = r__$1;
var G__20697 = res__$2;
G__20684__$1 = G__20696;
res__$1 = G__20697;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__20701 = coll;
var vec__20702 = G__20701;
var seq__20703 = cljs.core.seq.call(null,vec__20702);
var first__20704 = cljs.core.first.call(null,seq__20703);
var seq__20703__$1 = cljs.core.next.call(null,seq__20703);
var clause = first__20704;
var r = seq__20703__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__20701__$1 = G__20701;
var res__$1 = res;
while(true){
var vec__20708 = G__20701__$1;
var seq__20709 = cljs.core.seq.call(null,vec__20708);
var first__20710 = cljs.core.first.call(null,seq__20709);
var seq__20709__$1 = cljs.core.next.call(null,seq__20709);
var clause__$1 = first__20710;
var r__$1 = seq__20709__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__20711 = r__$1;
var G__20712 = res__$2;
G__20701__$1 = G__20711;
res__$1 = G__20712;
continue;
} else {
var G__20713 = r__$1;
var G__20714 = cljs.core.conj.call(null,res__$2,clause__$1);
G__20701__$1 = G__20713;
res__$1 = G__20714;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__20717 = clause;
var G__20717__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__20717):G__20717);
var G__20717__$2 = clojure.string.join.call(null," ",G__20717__$1)
;
var G__20717__$3 = (function (p1__20715_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20715_SHARP_)," ."].join('');
}).call(null,G__20717__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__20716_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20716_SHARP_),"}"].join('');
}).call(null,G__20717__$3);
} else {
return G__20717__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__20721 = opts;
var map__20721__$1 = cljs.core.__destructure_map.call(null,map__20721);
var limit = cljs.core.get.call(null,map__20721__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__20721__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__20721__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__20721__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__20721__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__20718_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20718_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__20719_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__20719_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__20720_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__20720_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20735){
var state_val_20736 = (state_20735[(1)]);
if((state_val_20736 === (1))){
var inst_20722 = fluree.db.util.core.url_encode.call(null,query);
var inst_20723 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20722)].join('');
var inst_20724 = ["User-Agent","Accept"];
var inst_20725 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_20726 = cljs.core.PersistentHashMap.fromArrays(inst_20724,inst_20725);
var inst_20727 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_20728 = [inst_20726,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_20729 = cljs.core.PersistentHashMap.fromArrays(inst_20727,inst_20728);
var inst_20730 = fluree.db.util.xhttp.get.call(null,inst_20723,inst_20729);
var state_20735__$1 = state_20735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20735__$1,(2),inst_20730);
} else {
if((state_val_20736 === (2))){
var inst_20732 = (state_20735[(2)]);
var inst_20733 = fluree.db.util.async.throw_err.call(null,inst_20732);
var state_20735__$1 = state_20735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20735__$1,inst_20733);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_20737 = [null,null,null,null,null,null,null];
(statearr_20737[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__);

(statearr_20737[(1)] = (1));

return statearr_20737;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1 = (function (state_20735){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20738){var ex__2749__auto__ = e20738;
var statearr_20739_20742 = state_20735;
(statearr_20739_20742[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20735[(4)]))){
var statearr_20740_20743 = state_20735;
(statearr_20740_20743[(1)] = cljs.core.first.call(null,(state_20735[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20744 = state_20735;
state_20735 = G__20744;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = function(state_20735){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1.call(this,state_20735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20741 = f__2769__auto__.call(null);
(statearr_20741[(6)] = c__2768__auto__);

return statearr_20741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20762){
var state_val_20763 = (state_20762[(1)]);
if((state_val_20763 === (1))){
var inst_20745 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_20762__$1 = state_20762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20762__$1,(2),inst_20745);
} else {
if((state_val_20763 === (2))){
var inst_20748 = (state_20762[(7)]);
var inst_20747 = (state_20762[(2)]);
var inst_20748__$1 = fluree.db.util.async.throw_err.call(null,inst_20747);
var inst_20749 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_20748__$1);
var inst_20750 = cljs.core.not_EQ_.call(null,(200),inst_20749);
var state_20762__$1 = (function (){var statearr_20764 = state_20762;
(statearr_20764[(7)] = inst_20748__$1);

return statearr_20764;
})();
if(inst_20750){
var statearr_20765_20774 = state_20762__$1;
(statearr_20765_20774[(1)] = (3));

} else {
var statearr_20766_20775 = state_20762__$1;
(statearr_20766_20775[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20763 === (3))){
var inst_20748 = (state_20762[(7)]);
var state_20762__$1 = state_20762;
var statearr_20767_20776 = state_20762__$1;
(statearr_20767_20776[(2)] = inst_20748);

(statearr_20767_20776[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20763 === (4))){
var inst_20748 = (state_20762[(7)]);
var inst_20753 = (function (){var body = inst_20748;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_20754 = cljs.core.second.call(null,inst_20748);
var inst_20755 = cljs.core.second.call(null,inst_20754);
var inst_20756 = cljs.core.first.call(null,inst_20755);
var inst_20757 = cljs.core.second.call(null,inst_20756);
var inst_20758 = cljs.core.mapv.call(null,inst_20753,inst_20757);
var state_20762__$1 = state_20762;
var statearr_20768_20777 = state_20762__$1;
(statearr_20768_20777[(2)] = inst_20758);

(statearr_20768_20777[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20763 === (5))){
var inst_20760 = (state_20762[(2)]);
var state_20762__$1 = state_20762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20762__$1,inst_20760);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_20769 = [null,null,null,null,null,null,null,null];
(statearr_20769[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__);

(statearr_20769[(1)] = (1));

return statearr_20769;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1 = (function (state_20762){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20770){var ex__2749__auto__ = e20770;
var statearr_20771_20778 = state_20762;
(statearr_20771_20778[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20762[(4)]))){
var statearr_20772_20779 = state_20762;
(statearr_20772_20779[(1)] = cljs.core.first.call(null,(state_20762[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20780 = state_20762;
state_20762 = G__20780;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = function(state_20762){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1.call(this,state_20762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20773 = f__2769__auto__.call(null);
(statearr_20773[(6)] = c__2768__auto__);

return statearr_20773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__20781_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20781_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__20782_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20782_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__20783_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__20783_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20829){
var state_val_20830 = (state_20829[(1)]);
if((state_val_20830 === (7))){
var inst_20794 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_20829__$1 = state_20829;
var statearr_20831_20859 = state_20829__$1;
(statearr_20831_20859[(2)] = inst_20794);

(statearr_20831_20859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (1))){
var state_20829__$1 = state_20829;
var statearr_20832_20860 = state_20829__$1;
(statearr_20832_20860[(2)] = null);

(statearr_20832_20860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (4))){
var inst_20784 = (state_20829[(2)]);
var state_20829__$1 = state_20829;
var statearr_20833_20861 = state_20829__$1;
(statearr_20833_20861[(2)] = inst_20784);

(statearr_20833_20861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (15))){
var inst_20802 = (state_20829[(7)]);
var inst_20803 = (state_20829[(8)]);
var inst_20808 = (state_20829[(9)]);
var inst_20813 = (state_20829[(2)]);
var inst_20814 = cljs.core.subs.call(null,inst_20808,(0),inst_20813);
var inst_20815 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20816 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20802);
var inst_20817 = [inst_20803,inst_20816];
var inst_20818 = cljs.core.PersistentHashMap.fromArrays(inst_20815,inst_20817);
var inst_20819 = cljs.core.ex_info.call(null,inst_20814,inst_20818);
var inst_20820 = (function(){throw inst_20819})();
var state_20829__$1 = state_20829;
var statearr_20834_20862 = state_20829__$1;
(statearr_20834_20862[(2)] = inst_20820);

(statearr_20834_20862[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (13))){
var inst_20807 = (state_20829[(10)]);
var state_20829__$1 = state_20829;
var statearr_20835_20863 = state_20829__$1;
(statearr_20835_20863[(2)] = inst_20807);

(statearr_20835_20863[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (6))){
var state_20829__$1 = state_20829;
var statearr_20836_20864 = state_20829__$1;
(statearr_20836_20864[(2)] = null);

(statearr_20836_20864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (3))){
var inst_20827 = (state_20829[(2)]);
var state_20829__$1 = state_20829;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20829__$1,inst_20827);
} else {
if((state_val_20830 === (12))){
var inst_20824 = (state_20829[(2)]);
var _ = (function (){var statearr_20837 = state_20829;
(statearr_20837[(4)] = cljs.core.rest.call(null,(state_20829[(4)])));

return statearr_20837;
})();
var state_20829__$1 = state_20829;
var statearr_20838_20865 = state_20829__$1;
(statearr_20838_20865[(2)] = inst_20824);

(statearr_20838_20865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (2))){
var _ = (function (){var statearr_20839 = state_20829;
(statearr_20839[(4)] = cljs.core.cons.call(null,(5),(state_20829[(4)])));

return statearr_20839;
})();
var inst_20791 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_20829__$1 = state_20829;
if(inst_20791){
var statearr_20840_20866 = state_20829__$1;
(statearr_20840_20866[(1)] = (6));

} else {
var statearr_20841_20867 = state_20829__$1;
(statearr_20841_20867[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (11))){
var inst_20802 = (state_20829[(7)]);
var inst_20822 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_20802,all_vars);
var state_20829__$1 = state_20829;
var statearr_20843_20868 = state_20829__$1;
(statearr_20843_20868[(2)] = inst_20822);

(statearr_20843_20868[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (9))){
var inst_20802 = (state_20829[(7)]);
var inst_20803 = (state_20829[(8)]);
var inst_20800 = (state_20829[(2)]);
var inst_20801 = fluree.db.util.async.throw_err.call(null,inst_20800);
var inst_20802__$1 = cljs.core.__destructure_map.call(null,inst_20801);
var inst_20803__$1 = cljs.core.get.call(null,inst_20802__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20804 = cljs.core.get.call(null,inst_20802__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20805 = cljs.core._EQ_.call(null,(400),inst_20803__$1);
var state_20829__$1 = (function (){var statearr_20844 = state_20829;
(statearr_20844[(7)] = inst_20802__$1);

(statearr_20844[(8)] = inst_20803__$1);

(statearr_20844[(11)] = inst_20804);

return statearr_20844;
})();
if(inst_20805){
var statearr_20845_20869 = state_20829__$1;
(statearr_20845_20869[(1)] = (10));

} else {
var statearr_20846_20870 = state_20829__$1;
(statearr_20846_20870[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (5))){
var _ = (function (){var statearr_20847 = state_20829;
(statearr_20847[(4)] = cljs.core.rest.call(null,(state_20829[(4)])));

return statearr_20847;
})();
var state_20829__$1 = state_20829;
var ex20842 = (state_20829__$1[(2)]);
var statearr_20848_20871 = state_20829__$1;
(statearr_20848_20871[(5)] = ex20842);


if((ex20842 instanceof Error)){
var statearr_20849_20872 = state_20829__$1;
(statearr_20849_20872[(1)] = (4));

(statearr_20849_20872[(5)] = null);

} else {
throw ex20842;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (14))){
var state_20829__$1 = state_20829;
var statearr_20850_20873 = state_20829__$1;
(statearr_20850_20873[(2)] = (1000));

(statearr_20850_20873[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (10))){
var inst_20802 = (state_20829[(7)]);
var inst_20807 = (state_20829[(10)]);
var inst_20804 = (state_20829[(11)]);
var inst_20807__$1 = cljs.core.count.call(null,inst_20804);
var inst_20808 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20802);
var inst_20809 = (inst_20807__$1 < (1000));
var state_20829__$1 = (function (){var statearr_20851 = state_20829;
(statearr_20851[(10)] = inst_20807__$1);

(statearr_20851[(9)] = inst_20808);

return statearr_20851;
})();
if(cljs.core.truth_(inst_20809)){
var statearr_20852_20874 = state_20829__$1;
(statearr_20852_20874[(1)] = (13));

} else {
var statearr_20853_20875 = state_20829__$1;
(statearr_20853_20875[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20830 === (8))){
var inst_20796 = (state_20829[(2)]);
var inst_20797 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_20796,optional_clauses);
var inst_20798 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_20797);
var state_20829__$1 = state_20829;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20829__$1,(9),inst_20798);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20854 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20854[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__);

(statearr_20854[(1)] = (1));

return statearr_20854;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1 = (function (state_20829){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20829);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20855){var ex__2749__auto__ = e20855;
var statearr_20856_20876 = state_20829;
(statearr_20856_20876[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20829[(4)]))){
var statearr_20857_20877 = state_20829;
(statearr_20857_20877[(1)] = cljs.core.first.call(null,(state_20829[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20878 = state_20829;
state_20829 = G__20878;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = function(state_20829){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1.call(this,state_20829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20858 = f__2769__auto__.call(null);
(statearr_20858[(6)] = c__2768__auto__);

return statearr_20858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
