// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e20881){var e = e20881;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__20882_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__20882_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__20882_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__20882_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20883_SHARP_){
return cljs.core.conj.call(null,p1__20883_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20884_SHARP_){
return cljs.core.conj.call(null,p1__20884_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20889 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__20889,(0),null);
var _ = cljs.core.nth.call(null,vec__20889,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20885_SHARP_){
return cljs.core.conj.call(null,p1__20885_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__5043__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__20892 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__20892,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__20892,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20886_SHARP_){
return cljs.core.conj.call(null,p1__20886_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20887_SHARP_){
return cljs.core.conj.call(null,p1__20887_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20888_SHARP_){
return cljs.core.conj.call(null,p1__20888_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__20895_SHARP_){
return cljs.core.nth.call(null,array,p1__20895_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5802__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20898,optional_QMARK_,fuel,max_fuel){
var map__20899 = p__20898;
var map__20899__$1 = cljs.core.__destructure_map.call(null,map__20899);
var res = map__20899__$1;
var vars = cljs.core.get.call(null,map__20899__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20965){
var state_val_20966 = (state_20965[(1)]);
if((state_val_20966 === (7))){
var inst_20954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20955 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_20956 = cljs.core.conj.call(null,inst_20955,clause);
var inst_20957 = [null,inst_20956];
var inst_20958 = (new cljs.core.PersistentVector(null,2,(5),inst_20954,inst_20957,null));
var state_20965__$1 = state_20965;
var statearr_20967_20995 = state_20965__$1;
(statearr_20967_20995[(2)] = inst_20958);

(statearr_20967_20995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (1))){
var state_20965__$1 = state_20965;
var statearr_20968_20996 = state_20965__$1;
(statearr_20968_20996[(2)] = null);

(statearr_20968_20996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (4))){
var inst_20900 = (state_20965[(2)]);
var state_20965__$1 = state_20965;
var statearr_20969_20997 = state_20965__$1;
(statearr_20969_20997[(2)] = inst_20900);

(statearr_20969_20997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (15))){
var inst_20943 = (state_20965[(2)]);
var inst_20944 = fluree.db.util.async.throw_err.call(null,inst_20943);
var inst_20945 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20944);
var inst_20946 = cljs.core.count.call(null,inst_20945);
var inst_20947 = fluree.db.query.analytical.add_fuel.call(null,inst_20946,fuel,max_fuel);
var inst_20948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20949 = [inst_20944,r];
var inst_20950 = (new cljs.core.PersistentVector(null,2,(5),inst_20948,inst_20949,null));
var state_20965__$1 = (function (){var statearr_20970 = state_20965;
(statearr_20970[(7)] = inst_20947);

return statearr_20970;
})();
var statearr_20971_20998 = state_20965__$1;
(statearr_20971_20998[(2)] = inst_20950);

(statearr_20971_20998[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (13))){
var inst_20909 = (state_20965[(8)]);
var inst_20922 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20923 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_20922);
var inst_20924 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20909);
var inst_20925 = cljs.core.apply.call(null,cljs.core.concat,inst_20924);
var inst_20926 = cljs.core.set.call(null,inst_20925);
var inst_20927 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20923);
var inst_20928 = cljs.core.apply.call(null,cljs.core.concat,inst_20927);
var inst_20929 = cljs.core.into.call(null,inst_20926,inst_20928);
var inst_20930 = (function (){var all_wd = inst_20909;
var optional = inst_20923;
var all_wd_vars = inst_20926;
var all_vars = inst_20929;
return (function (p1__20896_SHARP_){
return all_vars.call(null,p1__20896_SHARP_);
});
})();
var inst_20931 = cljs.core.keys.call(null,vars);
var inst_20932 = cljs.core.map.call(null,inst_20930,inst_20931);
var inst_20933 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_20932);
var inst_20934 = cljs.core.set.call(null,inst_20933);
var inst_20935 = (function (){var all_wd = inst_20909;
var optional = inst_20923;
var all_wd_vars = inst_20926;
var all_vars = inst_20929;
var intersecting_vars = inst_20934;
return (function (p1__20897_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__20897_SHARP_);
});
})();
var inst_20936 = cljs.core.map.call(null,inst_20935,inst_20909);
var inst_20937 = cljs.core.apply.call(null,cljs.core.concat,inst_20936);
var inst_20938 = fluree.db.query.analytical.select_from_tuples.call(null,inst_20937,res);
var inst_20939 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_20909,inst_20934,vars);
var inst_20940 = cljs.core.remove.call(null,inst_20934,inst_20929);
var inst_20941 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_20939,inst_20937,inst_20938,inst_20940,inst_20923);
var state_20965__$1 = state_20965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20965__$1,(15),inst_20941);
} else {
if((state_val_20966 === (6))){
var inst_20910 = (state_20965[(9)]);
var inst_20908 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20909 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_20908);
var inst_20910__$1 = optional_QMARK_;
var state_20965__$1 = (function (){var statearr_20972 = state_20965;
(statearr_20972[(9)] = inst_20910__$1);

(statearr_20972[(8)] = inst_20909);

return statearr_20972;
})();
if(cljs.core.truth_(inst_20910__$1)){
var statearr_20973_20999 = state_20965__$1;
(statearr_20973_20999[(1)] = (9));

} else {
var statearr_20974_21000 = state_20965__$1;
(statearr_20974_21000[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (3))){
var inst_20963 = (state_20965[(2)]);
var state_20965__$1 = state_20965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20965__$1,inst_20963);
} else {
if((state_val_20966 === (12))){
var inst_20918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20919 = [null,r];
var inst_20920 = (new cljs.core.PersistentVector(null,2,(5),inst_20918,inst_20919,null));
var state_20965__$1 = state_20965;
var statearr_20975_21001 = state_20965__$1;
(statearr_20975_21001[(2)] = inst_20920);

(statearr_20975_21001[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (2))){
var _ = (function (){var statearr_20976 = state_20965;
(statearr_20976[(4)] = cljs.core.cons.call(null,(5),(state_20965[(4)])));

return statearr_20976;
})();
var inst_20906 = (r == null);
var state_20965__$1 = state_20965;
if(cljs.core.truth_(inst_20906)){
var statearr_20977_21002 = state_20965__$1;
(statearr_20977_21002[(1)] = (6));

} else {
var statearr_20978_21003 = state_20965__$1;
(statearr_20978_21003[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (11))){
var inst_20916 = (state_20965[(2)]);
var state_20965__$1 = state_20965;
if(cljs.core.truth_(inst_20916)){
var statearr_20980_21004 = state_20965__$1;
(statearr_20980_21004[(1)] = (12));

} else {
var statearr_20981_21005 = state_20965__$1;
(statearr_20981_21005[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (9))){
var inst_20909 = (state_20965[(8)]);
var inst_20912 = cljs.core.empty_QMARK_.call(null,inst_20909);
var inst_20913 = (!(inst_20912));
var state_20965__$1 = state_20965;
var statearr_20982_21006 = state_20965__$1;
(statearr_20982_21006[(2)] = inst_20913);

(statearr_20982_21006[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (5))){
var _ = (function (){var statearr_20983 = state_20965;
(statearr_20983[(4)] = cljs.core.rest.call(null,(state_20965[(4)])));

return statearr_20983;
})();
var state_20965__$1 = state_20965;
var ex20979 = (state_20965__$1[(2)]);
var statearr_20984_21007 = state_20965__$1;
(statearr_20984_21007[(5)] = ex20979);


if((ex20979 instanceof Error)){
var statearr_20985_21008 = state_20965__$1;
(statearr_20985_21008[(1)] = (4));

(statearr_20985_21008[(5)] = null);

} else {
throw ex20979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (14))){
var inst_20952 = (state_20965[(2)]);
var state_20965__$1 = state_20965;
var statearr_20986_21009 = state_20965__$1;
(statearr_20986_21009[(2)] = inst_20952);

(statearr_20986_21009[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (10))){
var inst_20910 = (state_20965[(9)]);
var state_20965__$1 = state_20965;
var statearr_20987_21010 = state_20965__$1;
(statearr_20987_21010[(2)] = inst_20910);

(statearr_20987_21010[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20966 === (8))){
var inst_20960 = (state_20965[(2)]);
var _ = (function (){var statearr_20988 = state_20965;
(statearr_20988[(4)] = cljs.core.rest.call(null,(state_20965[(4)])));

return statearr_20988;
})();
var state_20965__$1 = state_20965;
var statearr_20989_21011 = state_20965__$1;
(statearr_20989_21011[(2)] = inst_20960);

(statearr_20989_21011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20990 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20990[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__);

(statearr_20990[(1)] = (1));

return statearr_20990;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20965){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20991){var ex__2749__auto__ = e20991;
var statearr_20992_21012 = state_20965;
(statearr_20992_21012[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20965[(4)]))){
var statearr_20993_21013 = state_20965;
(statearr_20993_21013[(1)] = cljs.core.first.call(null,(state_20965[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21014 = state_20965;
state_20965 = G__21014;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = function(state_20965){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20994 = f__2769__auto__.call(null);
(statearr_20994[(6)] = c__2768__auto__);

return statearr_20994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__21016 = arguments.length;
switch (G__21016) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21110){
var state_val_21111 = (state_21110[(1)]);
if((state_val_21111 === (7))){
var inst_21023 = (state_21110[(7)]);
var inst_21033 = clojure.string.starts_with_QMARK_.call(null,inst_21023,"$fdb");
var state_21110__$1 = state_21110;
if(inst_21033){
var statearr_21112_21161 = state_21110__$1;
(statearr_21112_21161[(1)] = (9));

} else {
var statearr_21113_21162 = state_21110__$1;
(statearr_21113_21162[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (20))){
var state_21110__$1 = state_21110;
var statearr_21114_21163 = state_21110__$1;
(statearr_21114_21163[(2)] = null);

(statearr_21114_21163[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (27))){
var inst_21073 = (state_21110[(8)]);
var state_21110__$1 = state_21110;
var statearr_21115_21164 = state_21110__$1;
(statearr_21115_21164[(2)] = inst_21073);

(statearr_21115_21164[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (1))){
var state_21110__$1 = state_21110;
var statearr_21116_21165 = state_21110__$1;
(statearr_21116_21165[(2)] = null);

(statearr_21116_21165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (24))){
var inst_21096 = (state_21110[(2)]);
var state_21110__$1 = state_21110;
var statearr_21117_21166 = state_21110__$1;
(statearr_21117_21166[(2)] = inst_21096);

(statearr_21117_21166[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (4))){
var inst_21017 = (state_21110[(2)]);
var state_21110__$1 = state_21110;
var statearr_21118_21167 = state_21110__$1;
(statearr_21118_21167[(2)] = inst_21017);

(statearr_21118_21167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (15))){
var inst_21040 = (state_21110[(9)]);
var inst_21046 = (state_21110[(2)]);
var inst_21047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21048 = cljs.core.PersistentVector.EMPTY;
var inst_21049 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_21050 = cljs.core.into.call(null,inst_21048,inst_21049);
var inst_21051 = [inst_21040,inst_21050];
var inst_21052 = (new cljs.core.PersistentVector(null,2,(5),inst_21047,inst_21051,null));
var state_21110__$1 = (function (){var statearr_21119 = state_21110;
(statearr_21119[(10)] = inst_21046);

return statearr_21119;
})();
var statearr_21120_21168 = state_21110__$1;
(statearr_21120_21168[(2)] = inst_21052);

(statearr_21120_21168[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (21))){
var inst_21099 = (state_21110[(2)]);
var state_21110__$1 = state_21110;
var statearr_21121_21169 = state_21110__$1;
(statearr_21121_21169[(2)] = inst_21099);

(statearr_21121_21169[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (13))){
var inst_21040 = (state_21110[(9)]);
var inst_21043 = (function(){throw inst_21040})();
var state_21110__$1 = state_21110;
var statearr_21122_21170 = state_21110__$1;
(statearr_21122_21170[(2)] = inst_21043);

(statearr_21122_21170[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (22))){
var inst_21064 = (state_21110[(11)]);
var inst_21062 = (state_21110[(12)]);
var inst_21066 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_21062);
var inst_21067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21068 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_21064];
var inst_21069 = (new cljs.core.PersistentVector(null,2,(5),inst_21067,inst_21068,null));
var inst_21070 = cljs.core.get_in.call(null,opts,inst_21069);
var state_21110__$1 = (function (){var statearr_21123 = state_21110;
(statearr_21123[(13)] = inst_21066);

return statearr_21123;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21110__$1,(25),inst_21070);
} else {
if((state_val_21111 === (29))){
var inst_21077 = (state_21110[(2)]);
var inst_21078 = fluree.db.util.async.throw_err.call(null,inst_21077);
var state_21110__$1 = state_21110;
var statearr_21124_21171 = state_21110__$1;
(statearr_21124_21171[(2)] = inst_21078);

(statearr_21124_21171[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (6))){
var inst_21026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21027 = cljs.core.PersistentVector.EMPTY;
var inst_21028 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_21029 = cljs.core.into.call(null,inst_21027,inst_21028);
var inst_21030 = [db,inst_21029];
var inst_21031 = (new cljs.core.PersistentVector(null,2,(5),inst_21026,inst_21030,null));
var state_21110__$1 = state_21110;
var statearr_21125_21172 = state_21110__$1;
(statearr_21125_21172[(2)] = inst_21031);

(statearr_21125_21172[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (28))){
var inst_21081 = (state_21110[(2)]);
var inst_21082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21083 = cljs.core.PersistentVector.EMPTY;
var inst_21084 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_21085 = cljs.core.into.call(null,inst_21083,inst_21084);
var inst_21086 = [inst_21081,inst_21085];
var inst_21087 = (new cljs.core.PersistentVector(null,2,(5),inst_21082,inst_21086,null));
var state_21110__$1 = state_21110;
var statearr_21126_21173 = state_21110__$1;
(statearr_21126_21173[(2)] = inst_21087);

(statearr_21126_21173[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (25))){
var inst_21066 = (state_21110[(13)]);
var inst_21072 = (state_21110[(2)]);
var inst_21073 = fluree.db.util.async.throw_err.call(null,inst_21072);
var state_21110__$1 = (function (){var statearr_21127 = state_21110;
(statearr_21127[(8)] = inst_21073);

return statearr_21127;
})();
if(cljs.core.truth_(inst_21066)){
var statearr_21128_21174 = state_21110__$1;
(statearr_21128_21174[(1)] = (26));

} else {
var statearr_21129_21175 = state_21110__$1;
(statearr_21129_21175[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (17))){
var state_21110__$1 = state_21110;
var statearr_21130_21176 = state_21110__$1;
(statearr_21130_21176[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (3))){
var inst_21108 = (state_21110[(2)]);
var state_21110__$1 = state_21110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21110__$1,inst_21108);
} else {
if((state_val_21111 === (12))){
var inst_21040 = (state_21110[(9)]);
var inst_21039 = (state_21110[(2)]);
var inst_21040__$1 = fluree.db.util.async.throw_err.call(null,inst_21039);
var inst_21041 = fluree.db.util.core.exception_QMARK_.call(null,inst_21040__$1);
var state_21110__$1 = (function (){var statearr_21132 = state_21110;
(statearr_21132[(9)] = inst_21040__$1);

return statearr_21132;
})();
if(inst_21041){
var statearr_21133_21177 = state_21110__$1;
(statearr_21133_21177[(1)] = (13));

} else {
var statearr_21134_21178 = state_21110__$1;
(statearr_21134_21178[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (2))){
var inst_21023 = (state_21110[(7)]);
var _ = (function (){var statearr_21135 = state_21110;
(statearr_21135[(4)] = cljs.core.cons.call(null,(5),(state_21110[(4)])));

return statearr_21135;
})();
var inst_21023__$1 = cljs.core.first.call(null,clause);
var inst_21024 = cljs.core._EQ_.call(null,"$fdb",inst_21023__$1);
var state_21110__$1 = (function (){var statearr_21136 = state_21110;
(statearr_21136[(7)] = inst_21023__$1);

return statearr_21136;
})();
if(inst_21024){
var statearr_21137_21179 = state_21110__$1;
(statearr_21137_21179[(1)] = (6));

} else {
var statearr_21138_21180 = state_21110__$1;
(statearr_21138_21180[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (23))){
var inst_21023 = (state_21110[(7)]);
var inst_21089 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21023)," is not supported in Fluree"].join('');
var inst_21090 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21091 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21092 = cljs.core.PersistentHashMap.fromArrays(inst_21090,inst_21091);
var inst_21093 = cljs.core.ex_info.call(null,inst_21089,inst_21092);
var inst_21094 = (function(){throw inst_21093})();
var state_21110__$1 = state_21110;
var statearr_21139_21181 = state_21110__$1;
(statearr_21139_21181[(2)] = inst_21094);

(statearr_21139_21181[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (19))){
var inst_21064 = (state_21110[(11)]);
var inst_21023 = (state_21110[(7)]);
var inst_21061 = fluree.db.query.analytical.isolate_source_name.call(null,inst_21023);
var inst_21062 = fluree.db.query.analytical.isolate_source_block.call(null,inst_21023);
var inst_21063 = cljs.core.keyword.call(null,inst_21061);
var inst_21064__$1 = cljs.core.get.call(null,prefixes,inst_21063);
var state_21110__$1 = (function (){var statearr_21140 = state_21110;
(statearr_21140[(11)] = inst_21064__$1);

(statearr_21140[(12)] = inst_21062);

return statearr_21140;
})();
if(cljs.core.truth_(inst_21064__$1)){
var statearr_21141_21182 = state_21110__$1;
(statearr_21141_21182[(1)] = (22));

} else {
var statearr_21142_21183 = state_21110__$1;
(statearr_21142_21183[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (11))){
var inst_21103 = (state_21110[(2)]);
var state_21110__$1 = state_21110;
var statearr_21144_21184 = state_21110__$1;
(statearr_21144_21184[(2)] = inst_21103);

(statearr_21144_21184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (9))){
var inst_21023 = (state_21110[(7)]);
var inst_21035 = cljs.core.subs.call(null,inst_21023,(4));
var inst_21036 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_21035);
var inst_21037 = fluree.db.time_travel.as_of_block.call(null,db,inst_21036);
var state_21110__$1 = state_21110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21110__$1,(12),inst_21037);
} else {
if((state_val_21111 === (5))){
var _ = (function (){var statearr_21145 = state_21110;
(statearr_21145[(4)] = cljs.core.rest.call(null,(state_21110[(4)])));

return statearr_21145;
})();
var state_21110__$1 = state_21110;
var ex21143 = (state_21110__$1[(2)]);
var statearr_21146_21185 = state_21110__$1;
(statearr_21146_21185[(5)] = ex21143);


if((ex21143 instanceof Error)){
var statearr_21147_21186 = state_21110__$1;
(statearr_21147_21186[(1)] = (4));

(statearr_21147_21186[(5)] = null);

} else {
throw ex21143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (14))){
var state_21110__$1 = state_21110;
var statearr_21148_21187 = state_21110__$1;
(statearr_21148_21187[(2)] = null);

(statearr_21148_21187[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (26))){
var inst_21073 = (state_21110[(8)]);
var inst_21066 = (state_21110[(13)]);
var inst_21075 = fluree.db.time_travel.as_of_block.call(null,inst_21073,inst_21066);
var state_21110__$1 = state_21110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21110__$1,(29),inst_21075);
} else {
if((state_val_21111 === (16))){
var inst_21056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21057 = ["$wd",clause];
var inst_21058 = (new cljs.core.PersistentVector(null,2,(5),inst_21056,inst_21057,null));
var state_21110__$1 = state_21110;
var statearr_21149_21188 = state_21110__$1;
(statearr_21149_21188[(2)] = inst_21058);

(statearr_21149_21188[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (10))){
var inst_21023 = (state_21110[(7)]);
var inst_21054 = cljs.core._EQ_.call(null,"$wd",inst_21023);
var state_21110__$1 = state_21110;
if(inst_21054){
var statearr_21150_21189 = state_21110__$1;
(statearr_21150_21189[(1)] = (16));

} else {
var statearr_21151_21190 = state_21110__$1;
(statearr_21151_21190[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (18))){
var inst_21101 = (state_21110[(2)]);
var state_21110__$1 = state_21110;
var statearr_21152_21191 = state_21110__$1;
(statearr_21152_21191[(2)] = inst_21101);

(statearr_21152_21191[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21111 === (8))){
var inst_21105 = (state_21110[(2)]);
var _ = (function (){var statearr_21153 = state_21110;
(statearr_21153[(4)] = cljs.core.rest.call(null,(state_21110[(4)])));

return statearr_21153;
})();
var state_21110__$1 = state_21110;
var statearr_21154_21192 = state_21110__$1;
(statearr_21154_21192[(2)] = inst_21105);

(statearr_21154_21192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_21155 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21155[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_21155[(1)] = (1));

return statearr_21155;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_21110){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21156){var ex__2749__auto__ = e21156;
var statearr_21157_21193 = state_21110;
(statearr_21157_21193[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21110[(4)]))){
var statearr_21158_21194 = state_21110;
(statearr_21158_21194[(1)] = cljs.core.first.call(null,(state_21110[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21195 = state_21110;
state_21110 = G__21195;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_21110){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_21110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21159 = f__2769__auto__.call(null);
(statearr_21159[(6)] = c__2768__auto__);

return statearr_21159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__21196){
var vec__21197 = p__21196;
var sub = cljs.core.nth.call(null,vec__21197,(0),null);
var obj = cljs.core.nth.call(null,vec__21197,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__21200_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__21200_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__21204 = subjects;
var vec__21205 = G__21204;
var seq__21206 = cljs.core.seq.call(null,vec__21205);
var first__21207 = cljs.core.first.call(null,seq__21206);
var seq__21206__$1 = cljs.core.next.call(null,seq__21206);
var subject = first__21207;
var r = seq__21206__$1;
var acc = expanded_map;
var G__21204__$1 = G__21204;
var acc__$1 = acc;
while(true){
var vec__21211 = G__21204__$1;
var seq__21212 = cljs.core.seq.call(null,vec__21211);
var first__21213 = cljs.core.first.call(null,seq__21212);
var seq__21212__$1 = cljs.core.next.call(null,seq__21212);
var subject__$1 = first__21213;
var r__$1 = seq__21212__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__21214 = r__$1;
var G__21215 = acc__$2;
G__21204__$1 = G__21214;
acc__$1 = G__21215;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__21204__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__21211,seq__21212,first__21213,seq__21212__$1,subject__$1,r__$1,acc__$2,G__21204,vec__21205,seq__21206,first__21207,seq__21206__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__21204__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21211,seq__21212,first__21213,seq__21212__$1,subject__$1,r__$1,acc__$2,G__21204,vec__21205,seq__21206,first__21207,seq__21206__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__21204__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21211,seq__21212,first__21213,seq__21212__$1,subject__$1,r__$1,acc__$2,G__21204,vec__21205,seq__21206,first__21207,seq__21206__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__21204__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21211,seq__21212,first__21213,seq__21212__$1,subject__$1,r__$1,acc__$2,G__21204,vec__21205,seq__21206,first__21207,seq__21206__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__21204__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__21211,seq__21212,first__21213,seq__21212__$1,subject__$1,r__$1,acc__$2,G__21204,vec__21205,seq__21206,first__21207,seq__21206__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__21204__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__21211,seq__21212,first__21213,seq__21212__$1,subject__$1,r__$1,acc__$2,G__21204,vec__21205,seq__21206,first__21207,seq__21206__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__21216 = r__$1;
var G__21217 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__21204__$1 = G__21216;
acc__$1 = G__21217;
continue;
} else {
var G__21218 = subjects;
var G__21219 = acc_STAR_;
G__21204__$1 = G__21218;
acc__$1 = G__21219;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__21220_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__21220_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21311){
var state_val_21312 = (state_21311[(1)]);
if((state_val_21312 === (7))){
var state_21311__$1 = state_21311;
var statearr_21313_21359 = state_21311__$1;
(statearr_21313_21359[(2)] = (100));

(statearr_21313_21359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (20))){
var inst_21260 = (state_21311[(7)]);
var state_21311__$1 = state_21311;
var statearr_21314_21360 = state_21311__$1;
(statearr_21314_21360[(2)] = inst_21260);

(statearr_21314_21360[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (1))){
var state_21311__$1 = state_21311;
var statearr_21315_21361 = state_21311__$1;
(statearr_21315_21361[(2)] = null);

(statearr_21315_21361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (24))){
var inst_21297 = (state_21311[(8)]);
var inst_21232 = (state_21311[(9)]);
var inst_21298 = (state_21311[(10)]);
var inst_21299 = (state_21311[(11)]);
var inst_21302 = (function (){var max_depth = inst_21232;
var recur_map__$1 = inst_21298;
var subjects = inst_21297;
var tuples = inst_21299;
return (function (p1__21221_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__21221_SHARP_)],null));
});
})();
var inst_21303 = cljs.core.map.call(null,inst_21302,inst_21299);
var inst_21304 = cljs.core.distinct.call(null,inst_21303);
var state_21311__$1 = state_21311;
var statearr_21316_21362 = state_21311__$1;
(statearr_21316_21362[(2)] = inst_21304);

(statearr_21316_21362[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (4))){
var inst_21222 = (state_21311[(2)]);
var state_21311__$1 = state_21311;
var statearr_21317_21363 = state_21311__$1;
(statearr_21317_21363[(2)] = inst_21222);

(statearr_21317_21363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (15))){
var inst_21245 = (state_21311[(12)]);
var inst_21256 = cljs.core.PersistentVector.EMPTY;
var inst_21257 = cljs.core.seq.call(null,inst_21245);
var inst_21258 = cljs.core.first.call(null,inst_21257);
var inst_21259 = cljs.core.next.call(null,inst_21257);
var inst_21260 = inst_21256;
var inst_21261 = inst_21245;
var state_21311__$1 = (function (){var statearr_21318 = state_21311;
(statearr_21318[(13)] = inst_21261);

(statearr_21318[(14)] = inst_21259);

(statearr_21318[(15)] = inst_21258);

(statearr_21318[(7)] = inst_21260);

return statearr_21318;
})();
var statearr_21319_21364 = state_21311__$1;
(statearr_21319_21364[(2)] = null);

(statearr_21319_21364[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (21))){
var inst_21281 = (state_21311[(2)]);
var state_21311__$1 = state_21311;
var statearr_21320_21365 = state_21311__$1;
(statearr_21320_21365[(2)] = inst_21281);

(statearr_21320_21365[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (13))){
var inst_21294 = (state_21311[(2)]);
var state_21311__$1 = state_21311;
var statearr_21321_21366 = state_21311__$1;
(statearr_21321_21366[(2)] = inst_21294);

(statearr_21321_21366[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (22))){
var inst_21268 = (state_21311[(16)]);
var inst_21260 = (state_21311[(7)]);
var inst_21275 = (state_21311[(2)]);
var inst_21276 = fluree.db.util.async.throw_err.call(null,inst_21275);
var inst_21277 = cljs.core.concat.call(null,inst_21260,inst_21276);
var inst_21260__$1 = inst_21277;
var inst_21261 = inst_21268;
var state_21311__$1 = (function (){var statearr_21322 = state_21311;
(statearr_21322[(13)] = inst_21261);

(statearr_21322[(7)] = inst_21260__$1);

return statearr_21322;
})();
var statearr_21323_21367 = state_21311__$1;
(statearr_21323_21367[(2)] = null);

(statearr_21323_21367[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (6))){
var inst_21228 = (state_21311[(17)]);
var state_21311__$1 = state_21311;
var statearr_21324_21368 = state_21311__$1;
(statearr_21324_21368[(2)] = inst_21228);

(statearr_21324_21368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (25))){
var inst_21306 = (state_21311[(2)]);
var _ = (function (){var statearr_21325 = state_21311;
(statearr_21325[(4)] = cljs.core.rest.call(null,(state_21311[(4)])));

return statearr_21325;
})();
var state_21311__$1 = state_21311;
var statearr_21326_21369 = state_21311__$1;
(statearr_21326_21369[(2)] = inst_21306);

(statearr_21326_21369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (17))){
var inst_21261 = (state_21311[(13)]);
var inst_21267 = (state_21311[(18)]);
var inst_21266 = cljs.core.seq.call(null,inst_21261);
var inst_21267__$1 = cljs.core.first.call(null,inst_21266);
var inst_21268 = cljs.core.next.call(null,inst_21266);
var state_21311__$1 = (function (){var statearr_21327 = state_21311;
(statearr_21327[(16)] = inst_21268);

(statearr_21327[(18)] = inst_21267__$1);

return statearr_21327;
})();
if(cljs.core.truth_(inst_21267__$1)){
var statearr_21328_21370 = state_21311__$1;
(statearr_21328_21370[(1)] = (19));

} else {
var statearr_21329_21371 = state_21311__$1;
(statearr_21329_21371[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (3))){
var inst_21309 = (state_21311[(2)]);
var state_21311__$1 = state_21311;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21311__$1,inst_21309);
} else {
if((state_val_21312 === (12))){
var inst_21245 = (state_21311[(12)]);
var inst_21234 = (state_21311[(19)]);
var inst_21240 = cljs.core.vals.call(null,inst_21234);
var inst_21241 = cljs.core.flatten.call(null,inst_21240);
var inst_21242 = cljs.core.set.call(null,inst_21241);
var inst_21243 = cljs.core.keys.call(null,inst_21234);
var inst_21244 = cljs.core.set.call(null,inst_21243);
var inst_21245__$1 = clojure.set.difference.call(null,inst_21242,inst_21244);
var inst_21246 = cljs.core.empty_QMARK_.call(null,inst_21245__$1);
var state_21311__$1 = (function (){var statearr_21330 = state_21311;
(statearr_21330[(12)] = inst_21245__$1);

return statearr_21330;
})();
if(inst_21246){
var statearr_21331_21372 = state_21311__$1;
(statearr_21331_21372[(1)] = (14));

} else {
var statearr_21332_21373 = state_21311__$1;
(statearr_21332_21373[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (2))){
var inst_21228 = (state_21311[(17)]);
var _ = (function (){var statearr_21333 = state_21311;
(statearr_21333[(4)] = cljs.core.cons.call(null,(5),(state_21311[(4)])));

return statearr_21333;
})();
var inst_21228__$1 = depth;
var state_21311__$1 = (function (){var statearr_21334 = state_21311;
(statearr_21334[(17)] = inst_21228__$1);

return statearr_21334;
})();
if(cljs.core.truth_(inst_21228__$1)){
var statearr_21335_21374 = state_21311__$1;
(statearr_21335_21374[(1)] = (6));

} else {
var statearr_21336_21375 = state_21311__$1;
(statearr_21336_21375[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (23))){
var inst_21299 = (state_21311[(11)]);
var state_21311__$1 = state_21311;
var statearr_21337_21376 = state_21311__$1;
(statearr_21337_21376[(2)] = inst_21299);

(statearr_21337_21376[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (19))){
var inst_21267 = (state_21311[(18)]);
var inst_21270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21271 = [inst_21267,predicate];
var inst_21272 = (new cljs.core.PersistentVector(null,2,(5),inst_21270,inst_21271,null));
var inst_21273 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21272);
var state_21311__$1 = state_21311;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21311__$1,(22),inst_21273);
} else {
if((state_val_21312 === (11))){
var inst_21234 = (state_21311[(19)]);
var state_21311__$1 = state_21311;
var statearr_21339_21377 = state_21311__$1;
(statearr_21339_21377[(2)] = inst_21234);

(statearr_21339_21377[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (9))){
var inst_21232 = (state_21311[(9)]);
var inst_21235 = (state_21311[(20)]);
var inst_21237 = (inst_21235 >= inst_21232);
var state_21311__$1 = state_21311;
if(cljs.core.truth_(inst_21237)){
var statearr_21340_21378 = state_21311__$1;
(statearr_21340_21378[(1)] = (11));

} else {
var statearr_21341_21379 = state_21311__$1;
(statearr_21341_21379[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (5))){
var _ = (function (){var statearr_21342 = state_21311;
(statearr_21342[(4)] = cljs.core.rest.call(null,(state_21311[(4)])));

return statearr_21342;
})();
var state_21311__$1 = state_21311;
var ex21338 = (state_21311__$1[(2)]);
var statearr_21343_21380 = state_21311__$1;
(statearr_21343_21380[(5)] = ex21338);


if((ex21338 instanceof Error)){
var statearr_21344_21381 = state_21311__$1;
(statearr_21344_21381[(1)] = (4));

(statearr_21344_21381[(5)] = null);

} else {
throw ex21338;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (14))){
var inst_21234 = (state_21311[(19)]);
var state_21311__$1 = state_21311;
var statearr_21345_21382 = state_21311__$1;
(statearr_21345_21382[(2)] = inst_21234);

(statearr_21345_21382[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (16))){
var inst_21292 = (state_21311[(2)]);
var state_21311__$1 = state_21311;
var statearr_21346_21383 = state_21311__$1;
(statearr_21346_21383[(2)] = inst_21292);

(statearr_21346_21383[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (10))){
var inst_21297 = (state_21311[(8)]);
var inst_21298 = (state_21311[(10)]);
var inst_21296 = (state_21311[(2)]);
var inst_21297__$1 = cljs.core.keys.call(null,inst_21296);
var inst_21298__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_21297__$1,inst_21296);
var inst_21299 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_21297__$1,inst_21298__$1);
var state_21311__$1 = (function (){var statearr_21347 = state_21311;
(statearr_21347[(8)] = inst_21297__$1);

(statearr_21347[(10)] = inst_21298__$1);

(statearr_21347[(11)] = inst_21299);

return statearr_21347;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_21348_21384 = state_21311__$1;
(statearr_21348_21384[(1)] = (23));

} else {
var statearr_21349_21385 = state_21311__$1;
(statearr_21349_21385[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (18))){
var inst_21235 = (state_21311[(20)]);
var inst_21234 = (state_21311[(19)]);
var inst_21283 = (state_21311[(2)]);
var inst_21284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21285 = [(0),(2)];
var inst_21286 = (new cljs.core.PersistentVector(null,2,(5),inst_21284,inst_21285,null));
var inst_21287 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_21286,inst_21283);
var inst_21288 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_21234,inst_21287);
var inst_21289 = (inst_21235 + (1));
var inst_21234__$1 = inst_21288;
var inst_21235__$1 = inst_21289;
var state_21311__$1 = (function (){var statearr_21350 = state_21311;
(statearr_21350[(20)] = inst_21235__$1);

(statearr_21350[(19)] = inst_21234__$1);

return statearr_21350;
})();
var statearr_21351_21386 = state_21311__$1;
(statearr_21351_21386[(2)] = null);

(statearr_21351_21386[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21312 === (8))){
var inst_21232 = (state_21311[(2)]);
var inst_21233 = recur_map;
var inst_21234 = inst_21233;
var inst_21235 = (1);
var state_21311__$1 = (function (){var statearr_21352 = state_21311;
(statearr_21352[(9)] = inst_21232);

(statearr_21352[(20)] = inst_21235);

(statearr_21352[(19)] = inst_21234);

return statearr_21352;
})();
var statearr_21353_21387 = state_21311__$1;
(statearr_21353_21387[(2)] = null);

(statearr_21353_21387[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_21354 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21354[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__);

(statearr_21354[(1)] = (1));

return statearr_21354;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1 = (function (state_21311){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21311);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21355){var ex__2749__auto__ = e21355;
var statearr_21356_21388 = state_21311;
(statearr_21356_21388[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21311[(4)]))){
var statearr_21357_21389 = state_21311;
(statearr_21357_21389[(1)] = cljs.core.first.call(null,(state_21311[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21390 = state_21311;
state_21311 = G__21390;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = function(state_21311){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1.call(this,state_21311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21358 = f__2769__auto__.call(null);
(statearr_21358[(6)] = c__2768__auto__);

return statearr_21358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__21391,clause,fuel,max_fuel){
var map__21392 = p__21391;
var map__21392__$1 = cljs.core.__destructure_map.call(null,map__21392);
var res = map__21392__$1;
var headers = cljs.core.get.call(null,map__21392__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__21392__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__21392__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21503){
var state_val_21504 = (state_21503[(1)]);
if((state_val_21504 === (7))){
var inst_21409 = (state_21503[(7)]);
var state_21503__$1 = state_21503;
var statearr_21505_21558 = state_21503__$1;
(statearr_21505_21558[(2)] = inst_21409);

(statearr_21505_21558[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (20))){
var inst_21437 = (state_21503[(8)]);
var inst_21468 = typeof inst_21437 === 'number';
var state_21503__$1 = state_21503;
if(cljs.core.truth_(inst_21468)){
var statearr_21506_21559 = state_21503__$1;
(statearr_21506_21559[(1)] = (22));

} else {
var statearr_21507_21560 = state_21503__$1;
(statearr_21507_21560[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (27))){
var inst_21483 = (state_21503[(2)]);
var state_21503__$1 = state_21503;
var statearr_21508_21561 = state_21503__$1;
(statearr_21508_21561[(2)] = inst_21483);

(statearr_21508_21561[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (1))){
var state_21503__$1 = state_21503;
var statearr_21509_21562 = state_21503__$1;
(statearr_21509_21562[(2)] = null);

(statearr_21509_21562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (24))){
var inst_21485 = (state_21503[(2)]);
var state_21503__$1 = state_21503;
var statearr_21510_21563 = state_21503__$1;
(statearr_21510_21563[(2)] = inst_21485);

(statearr_21510_21563[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (4))){
var inst_21393 = (state_21503[(2)]);
var state_21503__$1 = state_21503;
var statearr_21511_21564 = state_21503__$1;
(statearr_21511_21564[(2)] = inst_21393);

(statearr_21511_21564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (15))){
var inst_21451 = (state_21503[(2)]);
var inst_21452 = cljs.core.nth.call(null,clause,(2));
var inst_21453 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_21452);
var state_21503__$1 = (function (){var statearr_21512 = state_21503;
(statearr_21512[(9)] = inst_21451);

return statearr_21512;
})();
if(cljs.core.truth_(inst_21453)){
var statearr_21513_21565 = state_21503__$1;
(statearr_21513_21565[(1)] = (16));

} else {
var statearr_21514_21566 = state_21503__$1;
(statearr_21514_21566[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (21))){
var inst_21440 = (state_21503[(10)]);
var inst_21439 = (state_21503[(11)]);
var inst_21410 = (state_21503[(12)]);
var inst_21487 = (state_21503[(2)]);
var inst_21488 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_21440,inst_21487,inst_21410,inst_21439);
var state_21503__$1 = state_21503;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21503__$1,(28),inst_21488);
} else {
if((state_val_21504 === (13))){
var inst_21419 = (state_21503[(13)]);
var inst_21443 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21419)].join('');
var inst_21444 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21445 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21446 = cljs.core.PersistentHashMap.fromArrays(inst_21444,inst_21445);
var inst_21447 = cljs.core.ex_info.call(null,inst_21443,inst_21446);
var inst_21448 = (function(){throw inst_21447})();
var state_21503__$1 = state_21503;
var statearr_21515_21567 = state_21503__$1;
(statearr_21515_21567[(2)] = inst_21448);

(statearr_21515_21567[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (22))){
var inst_21437 = (state_21503[(8)]);
var inst_21435 = (state_21503[(14)]);
var inst_21470 = cljs.core.PersistentHashMap.EMPTY;
var inst_21471 = cljs.core.flatten.call(null,inst_21435);
var inst_21472 = cljs.core.assoc.call(null,inst_21470,inst_21437,inst_21471);
var state_21503__$1 = state_21503;
var statearr_21516_21568 = state_21503__$1;
(statearr_21516_21568[(2)] = inst_21472);

(statearr_21516_21568[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (6))){
var inst_21421 = (state_21503[(15)]);
var state_21503__$1 = state_21503;
var statearr_21517_21569 = state_21503__$1;
(statearr_21517_21569[(2)] = inst_21421);

(statearr_21517_21569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (28))){
var inst_21490 = (state_21503[(2)]);
var inst_21491 = fluree.db.util.async.throw_err.call(null,inst_21490);
var state_21503__$1 = state_21503;
var statearr_21518_21570 = state_21503__$1;
(statearr_21518_21570[(2)] = inst_21491);

(statearr_21518_21570[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (25))){
var inst_21431 = (state_21503[(16)]);
var inst_21435 = (state_21503[(14)]);
var inst_21476 = cljs.core.PersistentHashMap.EMPTY;
var inst_21477 = cljs.core.first.call(null,inst_21431);
var inst_21478 = cljs.core.first.call(null,inst_21477);
var inst_21479 = cljs.core.flatten.call(null,inst_21435);
var inst_21480 = cljs.core.assoc.call(null,inst_21476,inst_21478,inst_21479);
var state_21503__$1 = state_21503;
var statearr_21519_21571 = state_21503__$1;
(statearr_21519_21571[(2)] = inst_21480);

(statearr_21519_21571[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (17))){
var inst_21419 = (state_21503[(13)]);
var inst_21456 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21419)].join('');
var inst_21457 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21458 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21459 = cljs.core.PersistentHashMap.fromArrays(inst_21457,inst_21458);
var inst_21460 = cljs.core.ex_info.call(null,inst_21456,inst_21459);
var inst_21461 = (function(){throw inst_21460})();
var state_21503__$1 = state_21503;
var statearr_21520_21572 = state_21503__$1;
(statearr_21520_21572[(2)] = inst_21461);

(statearr_21520_21572[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (3))){
var inst_21501 = (state_21503[(2)]);
var state_21503__$1 = state_21503;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21503__$1,inst_21501);
} else {
if((state_val_21504 === (12))){
var inst_21406 = (state_21503[(17)]);
var inst_21494 = (state_21503[(2)]);
var inst_21495 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_21496 = cljs.core.keys.call(null,inst_21406);
var inst_21497 = [inst_21496,vars,inst_21494];
var inst_21498 = cljs.core.PersistentHashMap.fromArrays(inst_21495,inst_21497);
var _ = (function (){var statearr_21521 = state_21503;
(statearr_21521[(4)] = cljs.core.rest.call(null,(state_21503[(4)])));

return statearr_21521;
})();
var state_21503__$1 = state_21503;
var statearr_21522_21573 = state_21503__$1;
(statearr_21522_21573[(2)] = inst_21498);

(statearr_21522_21573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (2))){
var inst_21406 = (state_21503[(17)]);
var inst_21410 = (state_21503[(12)]);
var inst_21409 = (state_21503[(7)]);
var inst_21421 = (state_21503[(15)]);
var _ = (function (){var statearr_21523 = state_21503;
(statearr_21523[(4)] = cljs.core.cons.call(null,(5),(state_21503[(4)])));

return statearr_21523;
})();
var inst_21403 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_21404 = cljs.core.__destructure_map.call(null,inst_21403);
var inst_21405 = cljs.core.get.call(null,inst_21404,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_21406__$1 = cljs.core.get.call(null,inst_21404,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_21407 = cljs.core.get.call(null,inst_21404,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_21408 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_21409__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_21407);
var inst_21410__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_21407);
var inst_21412 = (function (){var map__21399 = inst_21404;
var search = inst_21405;
var rel = inst_21406__$1;
var opts = inst_21407;
var common_keys = inst_21408;
var object_fn = inst_21409__$1;
var recur_depth = inst_21410__$1;
return (function (p__21411,common_key){
var vec__21524 = p__21411;
var acc = cljs.core.nth.call(null,vec__21524,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__21524,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__21527 = cljs.core._EQ_;
var expr__21528 = idx_of;
if(cljs.core.truth_(pred__21527.call(null,(0),expr__21528))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__21527.call(null,(1),expr__21528))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__21527.call(null,(2),expr__21528))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__21528)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_21413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21414 = cljs.core.PersistentHashMap.EMPTY;
var inst_21415 = [inst_21414,inst_21405];
var inst_21416 = (new cljs.core.PersistentVector(null,2,(5),inst_21413,inst_21415,null));
var inst_21417 = cljs.core.reduce.call(null,inst_21412,inst_21416,inst_21408);
var inst_21418 = cljs.core.nth.call(null,inst_21417,(0),null);
var inst_21419 = cljs.core.nth.call(null,inst_21417,(1),null);
var inst_21420 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_21421__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_21418);
var state_21503__$1 = (function (){var statearr_21530 = state_21503;
(statearr_21530[(17)] = inst_21406__$1);

(statearr_21530[(18)] = inst_21420);

(statearr_21530[(12)] = inst_21410__$1);

(statearr_21530[(7)] = inst_21409__$1);

(statearr_21530[(15)] = inst_21421__$1);

(statearr_21530[(13)] = inst_21419);

return statearr_21530;
})();
if(cljs.core.truth_(inst_21421__$1)){
var statearr_21531_21574 = state_21503__$1;
(statearr_21531_21574[(1)] = (6));

} else {
var statearr_21532_21575 = state_21503__$1;
(statearr_21532_21575[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (23))){
var inst_21437 = (state_21503[(8)]);
var inst_21474 = cljs.core.coll_QMARK_.call(null,inst_21437);
var state_21503__$1 = state_21503;
if(inst_21474){
var statearr_21533_21576 = state_21503__$1;
(statearr_21533_21576[(1)] = (25));

} else {
var statearr_21534_21577 = state_21503__$1;
(statearr_21534_21577[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (19))){
var inst_21435 = (state_21503[(14)]);
var inst_21465 = cljs.core.PersistentHashMap.EMPTY;
var inst_21466 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_21465,inst_21435);
var state_21503__$1 = state_21503;
var statearr_21535_21578 = state_21503__$1;
(statearr_21535_21578[(2)] = inst_21466);

(statearr_21535_21578[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (11))){
var inst_21435 = (state_21503[(14)]);
var state_21503__$1 = state_21503;
var statearr_21537_21579 = state_21503__$1;
(statearr_21537_21579[(2)] = inst_21435);

(statearr_21537_21579[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (9))){
var inst_21406 = (state_21503[(17)]);
var inst_21431 = (state_21503[(16)]);
var inst_21410 = (state_21503[(12)]);
var inst_21430 = (state_21503[(2)]);
var inst_21431__$1 = fluree.db.util.async.throw_err.call(null,inst_21430);
var inst_21432 = cljs.core.count.call(null,inst_21431__$1);
var inst_21433 = fluree.db.query.analytical.add_fuel.call(null,inst_21432,fuel,max_fuel);
var inst_21434 = cljs.core.vals.call(null,inst_21406);
var inst_21435 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_21434,inst_21431__$1);
var state_21503__$1 = (function (){var statearr_21538 = state_21503;
(statearr_21538[(16)] = inst_21431__$1);

(statearr_21538[(19)] = inst_21433);

(statearr_21538[(14)] = inst_21435);

return statearr_21538;
})();
if(cljs.core.truth_(inst_21410)){
var statearr_21539_21580 = state_21503__$1;
(statearr_21539_21580[(1)] = (10));

} else {
var statearr_21540_21581 = state_21503__$1;
(statearr_21540_21581[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (5))){
var _ = (function (){var statearr_21541 = state_21503;
(statearr_21541[(4)] = cljs.core.rest.call(null,(state_21503[(4)])));

return statearr_21541;
})();
var state_21503__$1 = state_21503;
var ex21536 = (state_21503__$1[(2)]);
var statearr_21542_21582 = state_21503__$1;
(statearr_21542_21582[(5)] = ex21536);


if((ex21536 instanceof Error)){
var statearr_21543_21583 = state_21503__$1;
(statearr_21543_21583[(1)] = (4));

(statearr_21543_21583[(5)] = null);

} else {
throw ex21536;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (14))){
var state_21503__$1 = state_21503;
var statearr_21544_21584 = state_21503__$1;
(statearr_21544_21584[(2)] = null);

(statearr_21544_21584[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (26))){
var state_21503__$1 = state_21503;
var statearr_21545_21585 = state_21503__$1;
(statearr_21545_21585[(2)] = null);

(statearr_21545_21585[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (16))){
var state_21503__$1 = state_21503;
var statearr_21546_21586 = state_21503__$1;
(statearr_21546_21586[(2)] = null);

(statearr_21546_21586[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (10))){
var inst_21440 = (state_21503[(10)]);
var inst_21419 = (state_21503[(13)]);
var inst_21437 = cljs.core.first.call(null,inst_21419);
var inst_21438 = cljs.core.first.call(null,clause);
var inst_21439 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_21438);
var inst_21440__$1 = cljs.core.nth.call(null,inst_21419,(1));
var inst_21441 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_21440__$1);
var state_21503__$1 = (function (){var statearr_21547 = state_21503;
(statearr_21547[(10)] = inst_21440__$1);

(statearr_21547[(11)] = inst_21439);

(statearr_21547[(8)] = inst_21437);

return statearr_21547;
})();
if(cljs.core.truth_(inst_21441)){
var statearr_21548_21587 = state_21503__$1;
(statearr_21548_21587[(1)] = (13));

} else {
var statearr_21549_21588 = state_21503__$1;
(statearr_21549_21588[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (18))){
var inst_21439 = (state_21503[(11)]);
var inst_21463 = (state_21503[(2)]);
var state_21503__$1 = (function (){var statearr_21550 = state_21503;
(statearr_21550[(20)] = inst_21463);

return statearr_21550;
})();
if(cljs.core.truth_(inst_21439)){
var statearr_21551_21589 = state_21503__$1;
(statearr_21551_21589[(1)] = (19));

} else {
var statearr_21552_21590 = state_21503__$1;
(statearr_21552_21590[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21504 === (8))){
var inst_21420 = (state_21503[(18)]);
var inst_21419 = (state_21503[(13)]);
var inst_21425 = (state_21503[(2)]);
var inst_21426 = [inst_21425];
var inst_21427 = cljs.core.PersistentHashMap.fromArrays(inst_21420,inst_21426);
var inst_21428 = fluree.db.query.range.search.call(null,db,inst_21419,inst_21427);
var state_21503__$1 = state_21503;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21503__$1,(9),inst_21428);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_21553 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21553[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_21553[(1)] = (1));

return statearr_21553;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_21503){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21503);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21554){var ex__2749__auto__ = e21554;
var statearr_21555_21591 = state_21503;
(statearr_21555_21591[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21503[(4)]))){
var statearr_21556_21592 = state_21503;
(statearr_21556_21592[(1)] = cljs.core.first.call(null,(state_21503[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21593 = state_21503;
state_21503 = G__21593;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = function(state_21503){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_21503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21557 = f__2769__auto__.call(null);
(statearr_21557[(6)] = c__2768__auto__);

return statearr_21557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__21594,res,clause){
var map__21595 = p__21594;
var map__21595__$1 = cljs.core.__destructure_map.call(null,map__21595);
var db = map__21595__$1;
var conn = cljs.core.get.call(null,map__21595__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__21595__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__21595__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21704){
var state_val_21705 = (state_21704[(1)]);
if((state_val_21705 === (7))){
var inst_21604 = (state_21704[(7)]);
var state_21704__$1 = state_21704;
var statearr_21706_21747 = state_21704__$1;
(statearr_21706_21747[(2)] = inst_21604);

(statearr_21706_21747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (20))){
var state_21704__$1 = state_21704;
var statearr_21707_21748 = state_21704__$1;
(statearr_21707_21748[(2)] = null);

(statearr_21707_21748[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (1))){
var state_21704__$1 = state_21704;
var statearr_21708_21749 = state_21704__$1;
(statearr_21708_21749[(2)] = null);

(statearr_21708_21749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (24))){
var inst_21606 = (state_21704[(8)]);
var inst_21677 = (state_21704[(2)]);
var inst_21678 = fluree.db.flake.sid__GT_cid.call(null,inst_21677);
var inst_21679 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_21678);
var inst_21680 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21682 = [inst_21606];
var inst_21683 = (new cljs.core.PersistentVector(null,1,(5),inst_21681,inst_21682,null));
var inst_21684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21686 = [inst_21679];
var inst_21687 = (new cljs.core.PersistentVector(null,1,(5),inst_21685,inst_21686,null));
var inst_21688 = [inst_21687];
var inst_21689 = (new cljs.core.PersistentVector(null,1,(5),inst_21684,inst_21688,null));
var inst_21690 = cljs.core.PersistentHashMap.EMPTY;
var inst_21691 = [inst_21683,inst_21689,inst_21690];
var inst_21692 = cljs.core.PersistentHashMap.fromArrays(inst_21680,inst_21691);
var state_21704__$1 = state_21704;
var statearr_21709_21750 = state_21704__$1;
(statearr_21709_21750[(2)] = inst_21692);

(statearr_21709_21750[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (4))){
var inst_21597 = (state_21704[(2)]);
var state_21704__$1 = state_21704;
var statearr_21710_21751 = state_21704__$1;
(statearr_21710_21751[(2)] = inst_21597);

(statearr_21710_21751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (15))){
var inst_21604 = (state_21704[(7)]);
var inst_21606 = (state_21704[(8)]);
var inst_21625 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_21626 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21628 = [inst_21604];
var inst_21629 = (new cljs.core.PersistentVector(null,1,(5),inst_21627,inst_21628,null));
var inst_21630 = (function (){var subject_var = inst_21604;
var object_var = inst_21606;
var min_sid = inst_21625;
var max_sid = (0);
return (function (p1__21596_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__21596_SHARP_);
});
})();
var inst_21631 = cljs.core.range.call(null,inst_21625,(0));
var inst_21632 = cljs.core.map.call(null,inst_21630,inst_21631);
var inst_21633 = cljs.core.PersistentHashMap.EMPTY;
var inst_21634 = [inst_21629,inst_21632,inst_21633];
var inst_21635 = cljs.core.PersistentHashMap.fromArrays(inst_21626,inst_21634);
var state_21704__$1 = state_21704;
var statearr_21711_21752 = state_21704__$1;
(statearr_21711_21752[(2)] = inst_21635);

(statearr_21711_21752[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (21))){
var inst_21695 = (state_21704[(2)]);
var state_21704__$1 = state_21704;
var statearr_21712_21753 = state_21704__$1;
(statearr_21712_21753[(2)] = inst_21695);

(statearr_21712_21753[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (13))){
var inst_21606 = (state_21704[(8)]);
var state_21704__$1 = state_21704;
if(cljs.core.truth_(inst_21606)){
var statearr_21713_21754 = state_21704__$1;
(statearr_21713_21754[(1)] = (19));

} else {
var statearr_21714_21755 = state_21704__$1;
(statearr_21714_21755[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (22))){
var inst_21668 = (state_21704[(9)]);
var state_21704__$1 = state_21704;
var statearr_21715_21756 = state_21704__$1;
(statearr_21715_21756[(2)] = inst_21668);

(statearr_21715_21756[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (6))){
var inst_21606 = (state_21704[(8)]);
var state_21704__$1 = state_21704;
var statearr_21716_21757 = state_21704__$1;
(statearr_21716_21757[(2)] = inst_21606);

(statearr_21716_21757[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (25))){
var inst_21674 = (state_21704[(2)]);
var inst_21675 = fluree.db.util.async.throw_err.call(null,inst_21674);
var state_21704__$1 = state_21704;
var statearr_21717_21758 = state_21704__$1;
(statearr_21717_21758[(2)] = inst_21675);

(statearr_21717_21758[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (17))){
var inst_21665 = (state_21704[(2)]);
var state_21704__$1 = state_21704;
var statearr_21718_21759 = state_21704__$1;
(statearr_21718_21759[(2)] = inst_21665);

(statearr_21718_21759[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (3))){
var inst_21702 = (state_21704[(2)]);
var state_21704__$1 = state_21704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21704__$1,inst_21702);
} else {
if((state_val_21705 === (12))){
var inst_21619 = ["_tx",null,"_block",null];
var inst_21620 = (new cljs.core.PersistentArrayMap(null,2,inst_21619,null));
var inst_21621 = (new cljs.core.PersistentHashSet(null,inst_21620,null));
var inst_21622 = cljs.core.last.call(null,clause);
var inst_21623 = inst_21621.call(null,inst_21622);
var state_21704__$1 = state_21704;
if(cljs.core.truth_(inst_21623)){
var statearr_21719_21760 = state_21704__$1;
(statearr_21719_21760[(1)] = (15));

} else {
var statearr_21720_21761 = state_21704__$1;
(statearr_21720_21761[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (2))){
var inst_21604 = (state_21704[(7)]);
var _ = (function (){var statearr_21721 = state_21704;
(statearr_21721[(4)] = cljs.core.cons.call(null,(5),(state_21704[(4)])));

return statearr_21721;
})();
var inst_21603 = cljs.core.first.call(null,clause);
var inst_21604__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_21603);
var inst_21605 = cljs.core.last.call(null,clause);
var inst_21606 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_21605);
var state_21704__$1 = (function (){var statearr_21722 = state_21704;
(statearr_21722[(7)] = inst_21604__$1);

(statearr_21722[(8)] = inst_21606);

return statearr_21722;
})();
if(cljs.core.truth_(inst_21604__$1)){
var statearr_21723_21762 = state_21704__$1;
(statearr_21723_21762[(1)] = (6));

} else {
var statearr_21724_21763 = state_21704__$1;
(statearr_21724_21763[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (23))){
var inst_21668 = (state_21704[(9)]);
var inst_21672 = fluree.db.dbproto._subid.call(null,db,inst_21668);
var state_21704__$1 = state_21704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21704__$1,(25),inst_21672);
} else {
if((state_val_21705 === (19))){
var inst_21668 = (state_21704[(9)]);
var inst_21668__$1 = cljs.core.first.call(null,clause);
var inst_21669 = typeof inst_21668__$1 === 'number';
var state_21704__$1 = (function (){var statearr_21725 = state_21704;
(statearr_21725[(9)] = inst_21668__$1);

return statearr_21725;
})();
if(cljs.core.truth_(inst_21669)){
var statearr_21726_21764 = state_21704__$1;
(statearr_21726_21764[(1)] = (22));

} else {
var statearr_21727_21765 = state_21704__$1;
(statearr_21727_21765[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (11))){
var inst_21699 = (state_21704[(2)]);
var _ = (function (){var statearr_21729 = state_21704;
(statearr_21729[(4)] = cljs.core.rest.call(null,(state_21704[(4)])));

return statearr_21729;
})();
var state_21704__$1 = state_21704;
var statearr_21730_21766 = state_21704__$1;
(statearr_21730_21766[(2)] = inst_21699);

(statearr_21730_21766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (9))){
var inst_21612 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21613 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21614 = cljs.core.PersistentHashMap.fromArrays(inst_21612,inst_21613);
var inst_21615 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_21614);
var inst_21616 = (function(){throw inst_21615})();
var state_21704__$1 = state_21704;
var statearr_21731_21767 = state_21704__$1;
(statearr_21731_21767[(2)] = inst_21616);

(statearr_21731_21767[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (5))){
var _ = (function (){var statearr_21732 = state_21704;
(statearr_21732[(4)] = cljs.core.rest.call(null,(state_21704[(4)])));

return statearr_21732;
})();
var state_21704__$1 = state_21704;
var ex21728 = (state_21704__$1[(2)]);
var statearr_21733_21768 = state_21704__$1;
(statearr_21733_21768[(5)] = ex21728);


if((ex21728 instanceof Error)){
var statearr_21734_21769 = state_21704__$1;
(statearr_21734_21769[(1)] = (4));

(statearr_21734_21769[(5)] = null);

} else {
throw ex21728;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (14))){
var inst_21697 = (state_21704[(2)]);
var state_21704__$1 = state_21704;
var statearr_21735_21770 = state_21704__$1;
(statearr_21735_21770[(2)] = inst_21697);

(statearr_21735_21770[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (16))){
var inst_21640 = (state_21704[(10)]);
var inst_21638 = (state_21704[(11)]);
var inst_21641 = (state_21704[(12)]);
var inst_21637 = cljs.core.last.call(null,clause);
var inst_21638__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_21637);
var inst_21639 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_21640__$1 = cljs.core.get.call(null,inst_21639,inst_21638__$1);
var inst_21641__$1 = fluree.db.flake.min_subject_id.call(null,inst_21638__$1);
var inst_21642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21643 = [inst_21640__$1];
var inst_21644 = (new cljs.core.PersistentVector(null,1,(5),inst_21642,inst_21643,null));
var inst_21645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21646 = [inst_21641__$1];
var inst_21647 = (new cljs.core.PersistentVector(null,1,(5),inst_21645,inst_21646,null));
var inst_21648 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_21644,cljs.core._LT__EQ_,inst_21647);
var state_21704__$1 = (function (){var statearr_21736 = state_21704;
(statearr_21736[(10)] = inst_21640__$1);

(statearr_21736[(11)] = inst_21638__$1);

(statearr_21736[(12)] = inst_21641__$1);

return statearr_21736;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21704__$1,(18),inst_21648);
} else {
if((state_val_21705 === (10))){
var inst_21604 = (state_21704[(7)]);
var state_21704__$1 = state_21704;
if(cljs.core.truth_(inst_21604)){
var statearr_21737_21771 = state_21704__$1;
(statearr_21737_21771[(1)] = (12));

} else {
var statearr_21738_21772 = state_21704__$1;
(statearr_21738_21772[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (18))){
var inst_21640 = (state_21704[(10)]);
var inst_21604 = (state_21704[(7)]);
var inst_21606 = (state_21704[(8)]);
var inst_21638 = (state_21704[(11)]);
var inst_21641 = (state_21704[(12)]);
var inst_21650 = (state_21704[(2)]);
var inst_21651 = fluree.db.util.async.throw_err.call(null,inst_21650);
var inst_21652 = (function (){var subject_var = inst_21604;
var object_var = inst_21606;
var partition = inst_21638;
var max_sid = inst_21640;
var min_sid = inst_21641;
var flakes = inst_21651;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_21653 = cljs.core.map.call(null,inst_21652);
var inst_21654 = cljs.core.distinct.call(null);
var inst_21655 = cljs.core.comp.call(null,inst_21653,inst_21654);
var inst_21656 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21658 = [inst_21604];
var inst_21659 = (new cljs.core.PersistentVector(null,1,(5),inst_21657,inst_21658,null));
var inst_21660 = cljs.core.sequence.call(null,inst_21655,inst_21651);
var inst_21661 = cljs.core.PersistentHashMap.EMPTY;
var inst_21662 = [inst_21659,inst_21660,inst_21661];
var inst_21663 = cljs.core.PersistentHashMap.fromArrays(inst_21656,inst_21662);
var state_21704__$1 = state_21704;
var statearr_21739_21773 = state_21704__$1;
(statearr_21739_21773[(2)] = inst_21663);

(statearr_21739_21773[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21705 === (8))){
var inst_21610 = (state_21704[(2)]);
var state_21704__$1 = state_21704;
if(cljs.core.truth_(inst_21610)){
var statearr_21740_21774 = state_21704__$1;
(statearr_21740_21774[(1)] = (9));

} else {
var statearr_21741_21775 = state_21704__$1;
(statearr_21741_21775[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_21742 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21742[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__);

(statearr_21742[(1)] = (1));

return statearr_21742;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1 = (function (state_21704){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21743){var ex__2749__auto__ = e21743;
var statearr_21744_21776 = state_21704;
(statearr_21744_21776[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21704[(4)]))){
var statearr_21745_21777 = state_21704;
(statearr_21745_21777[(1)] = cljs.core.first.call(null,(state_21704[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21778 = state_21704;
state_21704 = G__21778;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = function(state_21704){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1.call(this,state_21704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21746 = f__2769__auto__.call(null);
(statearr_21746[(6)] = c__2768__auto__);

return statearr_21746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__21784 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__21784 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__21784;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__21785(s__21786){
return (new cljs.core.LazySeq(null,(function (){
var s__21786__$1 = s__21786;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__21786__$1);
if(temp__5804__auto__){
var s__21786__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21786__$2)){
var c__5521__auto__ = cljs.core.chunk_first.call(null,s__21786__$2);
var size__5522__auto__ = cljs.core.count.call(null,c__5521__auto__);
var b__21788 = cljs.core.chunk_buffer.call(null,size__5522__auto__);
if((function (){var i__21787 = (0);
while(true){
if((i__21787 < size__5522__auto__)){
var x = cljs.core._nth.call(null,c__5521__auto__,i__21787);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__21788,(delta * delta));

var G__21789 = (i__21787 + (1));
i__21787 = G__21789;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21788),fluree$db$query$analytical$variance_$_iter__21785.call(null,cljs.core.chunk_rest.call(null,s__21786__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21788),null);
}
} else {
var x = cljs.core.first.call(null,s__21786__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__21785.call(null,cljs.core.rest.call(null,s__21786__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__21790 = null;
var G__21790__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__21790__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21790 = function(n,coll){
switch(arguments.length){
case 1:
return G__21790__1.call(this,n);
case 2:
return G__21790__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21790.cljs$core$IFn$_invoke$arity$1 = G__21790__1;
G__21790.cljs$core$IFn$_invoke$arity$2 = G__21790__2;
return G__21790;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21791 = null;
var G__21791__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__21791__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21791 = function(n,coll){
switch(arguments.length){
case 1:
return G__21791__1.call(this,n);
case 2:
return G__21791__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21791.cljs$core$IFn$_invoke$arity$1 = G__21791__1;
G__21791.cljs$core$IFn$_invoke$arity$2 = G__21791__2;
return G__21791;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21792 = null;
var G__21792__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__21792__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__21792 = function(n,coll){
switch(arguments.length){
case 1:
return G__21792__1.call(this,n);
case 2:
return G__21792__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21792.cljs$core$IFn$_invoke$arity$1 = G__21792__1;
G__21792.cljs$core$IFn$_invoke$arity$2 = G__21792__2;
return G__21792;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__21793 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__21793,(0),null);
var arg = cljs.core.nth.call(null,vec__21793,(1),null);
var var$ = cljs.core.nth.call(null,vec__21793,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21796 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__21796,(0),null);
var variable = cljs.core.nth.call(null,vec__21796,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__21799 = agg;
var map__21799__$1 = cljs.core.__destructure_map.call(null,map__21799);
var variable = cljs.core.get.call(null,map__21799__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__21799__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__21799__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__21801 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__21801,(0),null);
var agg_result = cljs.core.nth.call(null,vec__21801,(1),null);
var map__21804 = res__$1;
var map__21804__$1 = cljs.core.__destructure_map.call(null,map__21804);
var headers = cljs.core.get.call(null,map__21804__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__21804__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21800_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__21800_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__21805_SHARP_){
return cljs.core.nth.call(null,tuple,p1__21805_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__21806_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__21806_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.call(null,(function (p1__21807_SHARP_,p2__21808_SHARP_){
return cljs.core.conj.call(null,p1__21807_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__21808_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__21809_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__21809_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__21812,row,b_tuple){
var vec__21813 = p__21812;
var acc = cljs.core.nth.call(null,vec__21813,(0),null);
var b_rows = cljs.core.nth.call(null,vec__21813,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__21810_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__21810_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__21811_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__21811_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__21816_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21816_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__21817_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21817_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__21819_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__21819_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__21818_SHARP_){
return cljs.core.range.call(null,(0),p1__21818_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__21820_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21820_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__21821_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21821_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__21822_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21822_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__21824_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__21824_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__21823_SHARP_){
return cljs.core.range.call(null,(0),p1__21823_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__21825_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21825_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__21827 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__21827,(0),null);
var _ = cljs.core.nth.call(null,vec__21827,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__21826_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__21826_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__21832 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__21832,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__21832,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__21830_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__21830_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__21831_SHARP_){
return cljs.core.nth.call(null,clause,p1__21831_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21835,filters,optional_QMARK_){
var map__21836 = p__21835;
var map__21836__$1 = cljs.core.__destructure_map.call(null,map__21836);
var tuple_map = map__21836__$1;
var headers = cljs.core.get.call(null,map__21836__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__21836__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__21836__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21837 = clause;
var k = cljs.core.nth.call(null,vec__21837,(0),null);
var v = cljs.core.nth.call(null,vec__21837,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21840 = res;
var map__21840__$1 = cljs.core.__destructure_map.call(null,map__21840);
var headers = cljs.core.get.call(null,map__21840__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__21840__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5802__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21896){
var state_val_21897 = (state_21896[(1)]);
if((state_val_21897 === (7))){
var inst_21870 = (state_21896[(7)]);
var inst_21868 = (state_21896[(2)]);
var inst_21869 = fluree.db.util.async.throw_err.call(null,inst_21868);
var inst_21870__$1 = cljs.core.nth.call(null,inst_21869,(0),null);
var inst_21871 = cljs.core.nth.call(null,inst_21869,(1),null);
var inst_21872 = (inst_21870__$1 == null);
var state_21896__$1 = (function (){var statearr_21898 = state_21896;
(statearr_21898[(8)] = inst_21871);

(statearr_21898[(7)] = inst_21870__$1);

return statearr_21898;
})();
if(cljs.core.truth_(inst_21872)){
var statearr_21899_21928 = state_21896__$1;
(statearr_21899_21928[(1)] = (8));

} else {
var statearr_21900_21929 = state_21896__$1;
(statearr_21900_21929[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (1))){
var inst_21848 = optional_clauses;
var inst_21849 = cljs.core.seq.call(null,inst_21848);
var inst_21850 = cljs.core.first.call(null,inst_21849);
var inst_21851 = cljs.core.next.call(null,inst_21849);
var inst_21852 = where_tuples;
var inst_21853 = inst_21848;
var inst_21854 = inst_21852;
var state_21896__$1 = (function (){var statearr_21901 = state_21896;
(statearr_21901[(9)] = inst_21851);

(statearr_21901[(10)] = inst_21850);

(statearr_21901[(11)] = inst_21853);

(statearr_21901[(12)] = inst_21854);

return statearr_21901;
})();
var statearr_21902_21930 = state_21896__$1;
(statearr_21902_21930[(2)] = null);

(statearr_21902_21930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (4))){
var inst_21861 = (state_21896[(13)]);
var inst_21860 = (state_21896[(14)]);
var inst_21854 = (state_21896[(12)]);
var inst_21866 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21854,inst_21860,inst_21861,true,fuel,max_fuel,opts);
var state_21896__$1 = state_21896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21896__$1,(7),inst_21866);
} else {
if((state_val_21897 === (15))){
var state_21896__$1 = state_21896;
var statearr_21903_21931 = state_21896__$1;
(statearr_21903_21931[(2)] = null);

(statearr_21903_21931[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (13))){
var inst_21887 = (state_21896[(2)]);
var state_21896__$1 = state_21896;
var statearr_21904_21932 = state_21896__$1;
(statearr_21904_21932[(2)] = inst_21887);

(statearr_21904_21932[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (6))){
var inst_21892 = (state_21896[(2)]);
var state_21896__$1 = state_21896;
var statearr_21905_21933 = state_21896__$1;
(statearr_21905_21933[(2)] = inst_21892);

(statearr_21905_21933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (3))){
var inst_21894 = (state_21896[(2)]);
var state_21896__$1 = state_21896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21896__$1,inst_21894);
} else {
if((state_val_21897 === (12))){
var state_21896__$1 = state_21896;
var statearr_21906_21934 = state_21896__$1;
(statearr_21906_21934[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (2))){
var inst_21860 = (state_21896[(14)]);
var inst_21853 = (state_21896[(11)]);
var inst_21859 = cljs.core.seq.call(null,inst_21853);
var inst_21860__$1 = cljs.core.first.call(null,inst_21859);
var inst_21861 = cljs.core.next.call(null,inst_21859);
var state_21896__$1 = (function (){var statearr_21908 = state_21896;
(statearr_21908[(13)] = inst_21861);

(statearr_21908[(14)] = inst_21860__$1);

return statearr_21908;
})();
if(cljs.core.truth_(inst_21860__$1)){
var statearr_21909_21935 = state_21896__$1;
(statearr_21909_21935[(1)] = (4));

} else {
var statearr_21910_21936 = state_21896__$1;
(statearr_21910_21936[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (11))){
var inst_21871 = (state_21896[(8)]);
var inst_21870 = (state_21896[(7)]);
var inst_21853 = inst_21871;
var inst_21854 = inst_21870;
var state_21896__$1 = (function (){var statearr_21911 = state_21896;
(statearr_21911[(11)] = inst_21853);

(statearr_21911[(12)] = inst_21854);

return statearr_21911;
})();
var statearr_21912_21937 = state_21896__$1;
(statearr_21912_21937[(2)] = null);

(statearr_21912_21937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (9))){
var inst_21860 = (state_21896[(14)]);
var inst_21876 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21860);
var state_21896__$1 = state_21896;
if(cljs.core.truth_(inst_21876)){
var statearr_21913_21938 = state_21896__$1;
(statearr_21913_21938[(1)] = (11));

} else {
var statearr_21914_21939 = state_21896__$1;
(statearr_21914_21939[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (5))){
var inst_21854 = (state_21896[(12)]);
var state_21896__$1 = state_21896;
var statearr_21915_21940 = state_21896__$1;
(statearr_21915_21940[(2)] = inst_21854);

(statearr_21915_21940[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (14))){
var inst_21871 = (state_21896[(8)]);
var inst_21870 = (state_21896[(7)]);
var inst_21854 = (state_21896[(12)]);
var inst_21881 = fluree.db.query.analytical.left_outer_join.call(null,inst_21854,inst_21870);
var inst_21853 = inst_21871;
var inst_21854__$1 = inst_21881;
var state_21896__$1 = (function (){var statearr_21916 = state_21896;
(statearr_21916[(11)] = inst_21853);

(statearr_21916[(12)] = inst_21854__$1);

return statearr_21916;
})();
var statearr_21917_21941 = state_21896__$1;
(statearr_21917_21941[(2)] = null);

(statearr_21917_21941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (16))){
var inst_21885 = (state_21896[(2)]);
var state_21896__$1 = state_21896;
var statearr_21919_21942 = state_21896__$1;
(statearr_21919_21942[(2)] = inst_21885);

(statearr_21919_21942[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (10))){
var inst_21889 = (state_21896[(2)]);
var state_21896__$1 = state_21896;
var statearr_21920_21943 = state_21896__$1;
(statearr_21920_21943[(2)] = inst_21889);

(statearr_21920_21943[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21897 === (8))){
var inst_21871 = (state_21896[(8)]);
var inst_21854 = (state_21896[(12)]);
var tmp21918 = inst_21854;
var inst_21853 = inst_21871;
var inst_21854__$1 = tmp21918;
var state_21896__$1 = (function (){var statearr_21921 = state_21896;
(statearr_21921[(11)] = inst_21853);

(statearr_21921[(12)] = inst_21854__$1);

return statearr_21921;
})();
var statearr_21922_21944 = state_21896__$1;
(statearr_21922_21944[(2)] = null);

(statearr_21922_21944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0 = (function (){
var statearr_21923 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21923[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__);

(statearr_21923[(1)] = (1));

return statearr_21923;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1 = (function (state_21896){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21924){var ex__2749__auto__ = e21924;
var statearr_21925_21945 = state_21896;
(statearr_21925_21945[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21896[(4)]))){
var statearr_21926_21946 = state_21896;
(statearr_21926_21946[(1)] = cljs.core.first.call(null,(state_21896[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21947 = state_21896;
state_21896 = G__21947;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = function(state_21896){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1.call(this,state_21896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21927 = f__2769__auto__.call(null);
(statearr_21927[(6)] = c__2768__auto__);

return statearr_21927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__21949){
var vec__21950 = p__21949;
var var_name = cljs.core.nth.call(null,vec__21950,(0),null);
var var_val = cljs.core.nth.call(null,vec__21950,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21948_SHARP_){
return cljs.core.conj.call(null,p1__21948_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21954,p__21955,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21956 = p__21954;
var map__21956__$1 = cljs.core.__destructure_map.call(null,map__21956);
var q_map = map__21956__$1;
var prefixes = cljs.core.get.call(null,map__21956__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21957 = p__21955;
var map__21957__$1 = cljs.core.__destructure_map.call(null,map__21957);
var res = map__21957__$1;
var vars = cljs.core.get.call(null,map__21957__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22194){
var state_val_22195 = (state_22194[(1)]);
if((state_val_22195 === (65))){
var inst_22143 = (state_22194[(7)]);
var inst_22144 = (state_22194[(8)]);
var inst_22155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22156 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_22143,res,inst_22144);
var inst_22157 = [inst_22156,r];
var inst_22158 = (new cljs.core.PersistentVector(null,2,(5),inst_22155,inst_22157,null));
var state_22194__$1 = state_22194;
var statearr_22196_22301 = state_22194__$1;
(statearr_22196_22301[(2)] = inst_22158);

(statearr_22196_22301[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (70))){
var inst_22170 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22197_22302 = state_22194__$1;
(statearr_22197_22302[(2)] = inst_22170);

(statearr_22197_22302[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (62))){
var inst_22144 = (state_22194[(8)]);
var inst_22152 = cljs.core.second.call(null,inst_22144);
var inst_22153 = clojure.string.starts_with_QMARK_.call(null,inst_22152,"fullText:");
var state_22194__$1 = state_22194;
if(inst_22153){
var statearr_22198_22303 = state_22194__$1;
(statearr_22198_22303[(1)] = (65));

} else {
var statearr_22199_22304 = state_22194__$1;
(statearr_22199_22304[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (7))){
var inst_22063 = (state_22194[(9)]);
var inst_22062 = cljs.core.count.call(null,clause);
var inst_22063__$1 = cljs.core._EQ_.call(null,(3),inst_22062);
var state_22194__$1 = (function (){var statearr_22200 = state_22194;
(statearr_22200[(9)] = inst_22063__$1);

return statearr_22200;
})();
if(inst_22063__$1){
var statearr_22201_22305 = state_22194__$1;
(statearr_22201_22305[(1)] = (31));

} else {
var statearr_22202_22306 = state_22194__$1;
(statearr_22202_22306[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (59))){
var inst_22177 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22203_22307 = state_22194__$1;
(statearr_22203_22307[(2)] = inst_22177);

(statearr_22203_22307[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (20))){
var inst_22026 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22204_22308 = state_22194__$1;
(statearr_22204_22308[(2)] = inst_22026);

(statearr_22204_22308[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (58))){
var state_22194__$1 = state_22194;
var statearr_22205_22309 = state_22194__$1;
(statearr_22205_22309[(2)] = null);

(statearr_22205_22309[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (60))){
var inst_22143 = (state_22194[(7)]);
var inst_22141 = (state_22194[(2)]);
var inst_22142 = fluree.db.util.async.throw_err.call(null,inst_22141);
var inst_22143__$1 = cljs.core.nth.call(null,inst_22142,(0),null);
var inst_22144 = cljs.core.nth.call(null,inst_22142,(1),null);
var inst_22145 = cljs.core._EQ_.call(null,"$wd",inst_22143__$1);
var state_22194__$1 = (function (){var statearr_22206 = state_22194;
(statearr_22206[(7)] = inst_22143__$1);

(statearr_22206[(8)] = inst_22144);

return statearr_22206;
})();
if(inst_22145){
var statearr_22207_22310 = state_22194__$1;
(statearr_22207_22310[(1)] = (61));

} else {
var statearr_22208_22311 = state_22194__$1;
(statearr_22208_22311[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (27))){
var inst_22056 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22209_22312 = state_22194__$1;
(statearr_22209_22312[(2)] = inst_22056);

(statearr_22209_22312[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (1))){
var state_22194__$1 = state_22194;
var statearr_22210_22313 = state_22194__$1;
(statearr_22210_22313[(2)] = null);

(statearr_22210_22313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (69))){
var state_22194__$1 = state_22194;
var statearr_22211_22314 = state_22194__$1;
(statearr_22211_22314[(2)] = null);

(statearr_22211_22314[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (24))){
var inst_22020 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22212_22315 = state_22194__$1;
(statearr_22212_22315[(2)] = inst_22020);

(statearr_22212_22315[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (55))){
var inst_22126 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_22127 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22128 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_22129 = cljs.core.PersistentHashMap.fromArrays(inst_22127,inst_22128);
var inst_22130 = cljs.core.ex_info.call(null,inst_22126,inst_22129);
var inst_22131 = (function(){throw inst_22130})();
var state_22194__$1 = state_22194;
var statearr_22213_22316 = state_22194__$1;
(statearr_22213_22316[(2)] = inst_22131);

(statearr_22213_22316[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (39))){
var inst_22083 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
if(cljs.core.truth_(inst_22083)){
var statearr_22214_22317 = state_22194__$1;
(statearr_22214_22317[(1)] = (40));

} else {
var statearr_22215_22318 = state_22194__$1;
(statearr_22215_22318[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (46))){
var inst_22183 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22216_22319 = state_22194__$1;
(statearr_22216_22319[(2)] = inst_22183);

(statearr_22216_22319[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (4))){
var inst_21958 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22217_22320 = state_22194__$1;
(statearr_22217_22320[(2)] = inst_21958);

(statearr_22217_22320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (54))){
var inst_22119 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_22120 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22121 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_22122 = cljs.core.PersistentHashMap.fromArrays(inst_22120,inst_22121);
var inst_22123 = cljs.core.ex_info.call(null,inst_22119,inst_22122);
var inst_22124 = (function(){throw inst_22123})();
var state_22194__$1 = state_22194;
var statearr_22218_22321 = state_22194__$1;
(statearr_22218_22321[(2)] = inst_22124);

(statearr_22218_22321[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (15))){
var inst_22058 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22219_22322 = state_22194__$1;
(statearr_22219_22322[(2)] = inst_22058);

(statearr_22219_22322[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (48))){
var inst_22107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22108 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_22109 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_22108);
var inst_22110 = [inst_22109,r];
var inst_22111 = (new cljs.core.PersistentVector(null,2,(5),inst_22107,inst_22110,null));
var state_22194__$1 = state_22194;
var statearr_22220_22323 = state_22194__$1;
(statearr_22220_22323[(2)] = inst_22111);

(statearr_22220_22323[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (50))){
var inst_22181 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22221_22324 = state_22194__$1;
(statearr_22221_22324[(2)] = inst_22181);

(statearr_22221_22324[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (21))){
var inst_21992 = (state_22194[(10)]);
var inst_21996 = (state_22194[(11)]);
var inst_21971 = (state_22194[(12)]);
var inst_21994 = (state_22194[(13)]);
var inst_22003 = (state_22194[(14)]);
var inst_21997 = (state_22194[(15)]);
var inst_21967 = (state_22194[(16)]);
var inst_21995 = (state_22194[(17)]);
var inst_22004 = (state_22194[(18)]);
var inst_22008 = (state_22194[(2)]);
var inst_22009 = fluree.db.util.async.throw_err.call(null,inst_22008);
var inst_22010 = (function (){var new_res = inst_22009;
var rest = inst_22004;
var G__21988 = inst_21996;
var tuples = inst_21997;
var vec__21999 = inst_21996;
var first__21991 = inst_21994;
var seq__22000 = inst_22004;
var vec__21989 = inst_21992;
var first__22001 = inst_22003;
var seq__21990 = inst_21995;
var pred__21968 = inst_21971;
var segment_type = inst_21967;
var expr__21969 = inst_21967;
var clause_group = inst_22003;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_22011 = cljs.core.keys.call(null,vars);
var inst_22012 = cljs.core.reduce.call(null,inst_22010,inst_22009,inst_22011);
var inst_22013 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_22012);
var state_22194__$1 = (function (){var statearr_22222 = state_22194;
(statearr_22222[(19)] = inst_22013);

return statearr_22222;
})();
if(cljs.core.truth_(inst_21997)){
var statearr_22223_22325 = state_22194__$1;
(statearr_22223_22325[(1)] = (22));

} else {
var statearr_22224_22326 = state_22194__$1;
(statearr_22224_22326[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (31))){
var inst_22065 = cljs.core.second.call(null,clause);
var inst_22066 = clojure.string.starts_with_QMARK_.call(null,inst_22065,"fullText:");
var state_22194__$1 = state_22194;
var statearr_22225_22327 = state_22194__$1;
(statearr_22225_22327[(2)] = inst_22066);

(statearr_22225_22327[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (32))){
var inst_22063 = (state_22194[(9)]);
var state_22194__$1 = state_22194;
var statearr_22226_22328 = state_22194__$1;
(statearr_22226_22328[(2)] = inst_22063);

(statearr_22226_22328[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (40))){
var inst_22085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22086 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_22194__$1 = (function (){var statearr_22227 = state_22194;
(statearr_22227[(20)] = inst_22085);

return statearr_22227;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22194__$1,(43),inst_22086);
} else {
if((state_val_22195 === (56))){
var inst_22133 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22228_22329 = state_22194__$1;
(statearr_22228_22329[(2)] = inst_22133);

(statearr_22228_22329[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (33))){
var inst_22069 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
if(cljs.core.truth_(inst_22069)){
var statearr_22229_22330 = state_22194__$1;
(statearr_22229_22330[(1)] = (34));

} else {
var statearr_22230_22331 = state_22194__$1;
(statearr_22230_22331[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (13))){
var inst_21992 = (state_22194[(10)]);
var inst_21992__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21993 = cljs.core.seq.call(null,inst_21992__$1);
var inst_21994 = cljs.core.first.call(null,inst_21993);
var inst_21995 = cljs.core.next.call(null,inst_21993);
var inst_21996 = inst_21992__$1;
var inst_21997 = null;
var state_22194__$1 = (function (){var statearr_22231 = state_22194;
(statearr_22231[(10)] = inst_21992__$1);

(statearr_22231[(11)] = inst_21996);

(statearr_22231[(13)] = inst_21994);

(statearr_22231[(15)] = inst_21997);

(statearr_22231[(17)] = inst_21995);

return statearr_22231;
})();
var statearr_22232_22332 = state_22194__$1;
(statearr_22232_22332[(2)] = null);

(statearr_22232_22332[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (22))){
var inst_22013 = (state_22194[(19)]);
var inst_21997 = (state_22194[(15)]);
var inst_22004 = (state_22194[(18)]);
var inst_22015 = fluree.db.query.union.results.call(null,inst_21997,inst_22013);
var inst_21996 = inst_22004;
var inst_21997__$1 = inst_22015;
var state_22194__$1 = (function (){var statearr_22233 = state_22194;
(statearr_22233[(11)] = inst_21996);

(statearr_22233[(15)] = inst_21997__$1);

return statearr_22233;
})();
var statearr_22234_22333 = state_22194__$1;
(statearr_22234_22333[(2)] = null);

(statearr_22234_22333[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (36))){
var inst_22187 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22235_22334 = state_22194__$1;
(statearr_22235_22334[(2)] = inst_22187);

(statearr_22235_22334[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (41))){
var inst_22093 = cljs.core.count.call(null,clause);
var inst_22094 = cljs.core._EQ_.call(null,(3),inst_22093);
var state_22194__$1 = state_22194;
if(inst_22094){
var statearr_22236_22335 = state_22194__$1;
(statearr_22236_22335[(1)] = (44));

} else {
var statearr_22237_22336 = state_22194__$1;
(statearr_22237_22336[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (43))){
var inst_22085 = (state_22194[(20)]);
var inst_22088 = (state_22194[(2)]);
var inst_22089 = fluree.db.util.async.throw_err.call(null,inst_22088);
var inst_22090 = [inst_22089,r];
var inst_22091 = (new cljs.core.PersistentVector(null,2,(5),inst_22085,inst_22090,null));
var state_22194__$1 = state_22194;
var statearr_22238_22337 = state_22194__$1;
(statearr_22238_22337[(2)] = inst_22091);

(statearr_22238_22337[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (61))){
var inst_22144 = (state_22194[(8)]);
var inst_22147 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_22144,r,res,optional_QMARK_,fuel,max_fuel);
var state_22194__$1 = state_22194;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22194__$1,(64),inst_22147);
} else {
if((state_val_22195 === (29))){
var inst_21967 = (state_22194[(16)]);
var inst_22050 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21967)].join('');
var inst_22051 = (new Error(inst_22050));
var inst_22052 = (function(){throw inst_22051})();
var state_22194__$1 = state_22194;
var statearr_22239_22338 = state_22194__$1;
(statearr_22239_22338[(2)] = inst_22052);

(statearr_22239_22338[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (44))){
var inst_22096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22097 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_22194__$1 = (function (){var statearr_22240 = state_22194;
(statearr_22240[(21)] = inst_22096);

return statearr_22240;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22194__$1,(47),inst_22097);
} else {
if((state_val_22195 === (6))){
var inst_21971 = (state_22194[(12)]);
var inst_21967 = (state_22194[(16)]);
var inst_21966 = cljs.core.keys.call(null,clause);
var inst_21967__$1 = cljs.core.first.call(null,inst_21966);
var inst_21971__$1 = cljs.core._EQ_;
var inst_21972 = inst_21971__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_21967__$1);
var state_22194__$1 = (function (){var statearr_22241 = state_22194;
(statearr_22241[(12)] = inst_21971__$1);

(statearr_22241[(16)] = inst_21967__$1);

return statearr_22241;
})();
if(cljs.core.truth_(inst_21972)){
var statearr_22242_22339 = state_22194__$1;
(statearr_22242_22339[(1)] = (9));

} else {
var statearr_22243_22340 = state_22194__$1;
(statearr_22243_22340[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (28))){
var inst_22044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22045 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22046 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_22045,optional_QMARK_);
var inst_22047 = [inst_22046,r];
var inst_22048 = (new cljs.core.PersistentVector(null,2,(5),inst_22044,inst_22047,null));
var state_22194__$1 = state_22194;
var statearr_22244_22341 = state_22194__$1;
(statearr_22244_22341[(2)] = inst_22048);

(statearr_22244_22341[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (64))){
var inst_22149 = (state_22194[(2)]);
var inst_22150 = fluree.db.util.async.throw_err.call(null,inst_22149);
var state_22194__$1 = state_22194;
var statearr_22245_22342 = state_22194__$1;
(statearr_22245_22342[(2)] = inst_22150);

(statearr_22245_22342[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (51))){
var inst_22116 = cljs.core.first.call(null,clause);
var inst_22117 = cljs.core.sequential_QMARK_.call(null,inst_22116);
var state_22194__$1 = state_22194;
if(inst_22117){
var statearr_22246_22343 = state_22194__$1;
(statearr_22246_22343[(1)] = (54));

} else {
var statearr_22247_22344 = state_22194__$1;
(statearr_22247_22344[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (25))){
var inst_21971 = (state_22194[(12)]);
var inst_21967 = (state_22194[(16)]);
var inst_22032 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_22033 = (function (){var segment_type = inst_21967;
var pred__21968 = inst_21971;
var expr__21969 = inst_21967;
var bindings = inst_22032;
return (function (p1__21953_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__21953_SHARP_);
});
})();
var inst_22034 = cljs.core.map.call(null,inst_22033,inst_22032);
var inst_22035 = cljs.core.PersistentHashMap.EMPTY;
var inst_22036 = cljs.core.into.call(null,inst_22035,inst_22034);
var inst_22037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22038 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_22036);
var inst_22039 = [inst_22038,r];
var inst_22040 = (new cljs.core.PersistentVector(null,2,(5),inst_22037,inst_22039,null));
var state_22194__$1 = state_22194;
var statearr_22248_22345 = state_22194__$1;
(statearr_22248_22345[(2)] = inst_22040);

(statearr_22248_22345[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (34))){
var inst_22071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22072 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_22073 = [inst_22072,r];
var inst_22074 = (new cljs.core.PersistentVector(null,2,(5),inst_22071,inst_22073,null));
var state_22194__$1 = state_22194;
var statearr_22249_22346 = state_22194__$1;
(statearr_22249_22346[(2)] = inst_22074);

(statearr_22249_22346[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (17))){
var inst_22028 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22250_22347 = state_22194__$1;
(statearr_22250_22347[(2)] = inst_22028);

(statearr_22250_22347[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (3))){
var inst_22192 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22194__$1,inst_22192);
} else {
if((state_val_22195 === (12))){
var inst_21974 = (state_22194[(22)]);
var inst_21978 = (state_22194[(2)]);
var inst_21979 = fluree.db.util.async.throw_err.call(null,inst_21978);
var inst_21980 = [inst_21979,r];
var inst_21981 = (new cljs.core.PersistentVector(null,2,(5),inst_21974,inst_21980,null));
var state_22194__$1 = state_22194;
var statearr_22251_22348 = state_22194__$1;
(statearr_22251_22348[(2)] = inst_21981);

(statearr_22251_22348[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (2))){
var _ = (function (){var statearr_22252 = state_22194;
(statearr_22252[(4)] = cljs.core.cons.call(null,(5),(state_22194[(4)])));

return statearr_22252;
})();
var inst_21964 = cljs.core.map_QMARK_.call(null,clause);
var state_22194__$1 = state_22194;
if(inst_21964){
var statearr_22253_22349 = state_22194__$1;
(statearr_22253_22349[(1)] = (6));

} else {
var statearr_22254_22350 = state_22194__$1;
(statearr_22254_22350[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (66))){
var state_22194__$1 = state_22194;
var statearr_22255_22351 = state_22194__$1;
(statearr_22255_22351[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (23))){
var inst_22013 = (state_22194[(19)]);
var inst_22004 = (state_22194[(18)]);
var inst_21996 = inst_22004;
var inst_21997 = inst_22013;
var state_22194__$1 = (function (){var statearr_22257 = state_22194;
(statearr_22257[(11)] = inst_21996);

(statearr_22257[(15)] = inst_21997);

return statearr_22257;
})();
var statearr_22258_22352 = state_22194__$1;
(statearr_22258_22352[(2)] = null);

(statearr_22258_22352[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (47))){
var inst_22096 = (state_22194[(21)]);
var inst_22099 = (state_22194[(2)]);
var inst_22100 = fluree.db.util.async.throw_err.call(null,inst_22099);
var inst_22101 = [inst_22100,r];
var inst_22102 = (new cljs.core.PersistentVector(null,2,(5),inst_22096,inst_22101,null));
var state_22194__$1 = state_22194;
var statearr_22259_22353 = state_22194__$1;
(statearr_22259_22353[(2)] = inst_22102);

(statearr_22259_22353[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (35))){
var inst_22077 = (state_22194[(23)]);
var inst_22076 = cljs.core.count.call(null,clause);
var inst_22077__$1 = cljs.core._EQ_.call(null,(3),inst_22076);
var state_22194__$1 = (function (){var statearr_22260 = state_22194;
(statearr_22260[(23)] = inst_22077__$1);

return statearr_22260;
})();
if(inst_22077__$1){
var statearr_22261_22354 = state_22194__$1;
(statearr_22261_22354[(1)] = (37));

} else {
var statearr_22262_22355 = state_22194__$1;
(statearr_22262_22355[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (19))){
var inst_21997 = (state_22194[(15)]);
var inst_22022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22023 = [inst_21997,r];
var inst_22024 = (new cljs.core.PersistentVector(null,2,(5),inst_22022,inst_22023,null));
var state_22194__$1 = state_22194;
var statearr_22263_22356 = state_22194__$1;
(statearr_22263_22356[(2)] = inst_22024);

(statearr_22263_22356[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (57))){
var inst_22139 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_22194__$1 = state_22194;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22194__$1,(60),inst_22139);
} else {
if((state_val_22195 === (68))){
var inst_22143 = (state_22194[(7)]);
var inst_22144 = (state_22194[(8)]);
var inst_22161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22162 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_22143,res,inst_22144,fuel,max_fuel);
var state_22194__$1 = (function (){var statearr_22264 = state_22194;
(statearr_22264[(24)] = inst_22161);

return statearr_22264;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22194__$1,(71),inst_22162);
} else {
if((state_val_22195 === (11))){
var inst_22060 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22266_22357 = state_22194__$1;
(statearr_22266_22357[(2)] = inst_22060);

(statearr_22266_22357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (9))){
var inst_21974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21975 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21976 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21975,res,fuel,max_fuel,opts);
var state_22194__$1 = (function (){var statearr_22267 = state_22194;
(statearr_22267[(22)] = inst_21974);

return statearr_22267;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22194__$1,(12),inst_21976);
} else {
if((state_val_22195 === (5))){
var _ = (function (){var statearr_22268 = state_22194;
(statearr_22268[(4)] = cljs.core.rest.call(null,(state_22194[(4)])));

return statearr_22268;
})();
var state_22194__$1 = state_22194;
var ex22265 = (state_22194__$1[(2)]);
var statearr_22269_22358 = state_22194__$1;
(statearr_22269_22358[(5)] = ex22265);


if((ex22265 instanceof Error)){
var statearr_22270_22359 = state_22194__$1;
(statearr_22270_22359[(1)] = (4));

(statearr_22270_22359[(5)] = null);

} else {
throw ex22265;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (14))){
var inst_21971 = (state_22194[(12)]);
var inst_21967 = (state_22194[(16)]);
var inst_22030 = inst_21971.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_21967);
var state_22194__$1 = state_22194;
if(cljs.core.truth_(inst_22030)){
var statearr_22271_22360 = state_22194__$1;
(statearr_22271_22360[(1)] = (25));

} else {
var statearr_22272_22361 = state_22194__$1;
(statearr_22272_22361[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (45))){
var inst_22104 = cljs.core.count.call(null,clause);
var inst_22105 = cljs.core._EQ_.call(null,(2),inst_22104);
var state_22194__$1 = state_22194;
if(inst_22105){
var statearr_22273_22362 = state_22194__$1;
(statearr_22273_22362[(1)] = (48));

} else {
var statearr_22274_22363 = state_22194__$1;
(statearr_22274_22363[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (53))){
var inst_22179 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22275_22364 = state_22194__$1;
(statearr_22275_22364[(2)] = inst_22179);

(statearr_22275_22364[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (26))){
var inst_21971 = (state_22194[(12)]);
var inst_21967 = (state_22194[(16)]);
var inst_22042 = inst_21971.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_21967);
var state_22194__$1 = state_22194;
if(cljs.core.truth_(inst_22042)){
var statearr_22276_22365 = state_22194__$1;
(statearr_22276_22365[(1)] = (28));

} else {
var statearr_22277_22366 = state_22194__$1;
(statearr_22277_22366[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (16))){
var inst_21996 = (state_22194[(11)]);
var inst_22003 = (state_22194[(14)]);
var inst_22002 = cljs.core.seq.call(null,inst_21996);
var inst_22003__$1 = cljs.core.first.call(null,inst_22002);
var inst_22004 = cljs.core.next.call(null,inst_22002);
var state_22194__$1 = (function (){var statearr_22278 = state_22194;
(statearr_22278[(14)] = inst_22003__$1);

(statearr_22278[(18)] = inst_22004);

return statearr_22278;
})();
if(cljs.core.truth_(inst_22003__$1)){
var statearr_22279_22367 = state_22194__$1;
(statearr_22279_22367[(1)] = (18));

} else {
var statearr_22280_22368 = state_22194__$1;
(statearr_22280_22368[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (38))){
var inst_22077 = (state_22194[(23)]);
var state_22194__$1 = state_22194;
var statearr_22281_22369 = state_22194__$1;
(statearr_22281_22369[(2)] = inst_22077);

(statearr_22281_22369[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (30))){
var inst_22054 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22282_22370 = state_22194__$1;
(statearr_22282_22370[(2)] = inst_22054);

(statearr_22282_22370[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (10))){
var inst_21971 = (state_22194[(12)]);
var inst_21967 = (state_22194[(16)]);
var inst_21983 = inst_21971.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_21967);
var state_22194__$1 = state_22194;
if(cljs.core.truth_(inst_21983)){
var statearr_22283_22371 = state_22194__$1;
(statearr_22283_22371[(1)] = (13));

} else {
var statearr_22284_22372 = state_22194__$1;
(statearr_22284_22372[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (18))){
var inst_22003 = (state_22194[(14)]);
var inst_22006 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_22003,q_map,vars,fuel,max_fuel,opts);
var state_22194__$1 = state_22194;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22194__$1,(21),inst_22006);
} else {
if((state_val_22195 === (52))){
var state_22194__$1 = state_22194;
var statearr_22285_22373 = state_22194__$1;
(statearr_22285_22373[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (67))){
var inst_22172 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22287_22374 = state_22194__$1;
(statearr_22287_22374[(2)] = inst_22172);

(statearr_22287_22374[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (71))){
var inst_22161 = (state_22194[(24)]);
var inst_22164 = (state_22194[(2)]);
var inst_22165 = fluree.db.util.async.throw_err.call(null,inst_22164);
var inst_22166 = [inst_22165,r];
var inst_22167 = (new cljs.core.PersistentVector(null,2,(5),inst_22161,inst_22166,null));
var state_22194__$1 = state_22194;
var statearr_22288_22375 = state_22194__$1;
(statearr_22288_22375[(2)] = inst_22167);

(statearr_22288_22375[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (42))){
var inst_22185 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22289_22376 = state_22194__$1;
(statearr_22289_22376[(2)] = inst_22185);

(statearr_22289_22376[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (37))){
var inst_22079 = cljs.core.second.call(null,clause);
var inst_22080 = cljs.core._EQ_.call(null,inst_22079,"rdf:type");
var state_22194__$1 = state_22194;
var statearr_22290_22377 = state_22194__$1;
(statearr_22290_22377[(2)] = inst_22080);

(statearr_22290_22377[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (63))){
var inst_22174 = (state_22194[(2)]);
var state_22194__$1 = state_22194;
var statearr_22291_22378 = state_22194__$1;
(statearr_22291_22378[(2)] = inst_22174);

(statearr_22291_22378[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (8))){
var inst_22189 = (state_22194[(2)]);
var _ = (function (){var statearr_22292 = state_22194;
(statearr_22292[(4)] = cljs.core.rest.call(null,(state_22194[(4)])));

return statearr_22292;
})();
var state_22194__$1 = state_22194;
var statearr_22293_22379 = state_22194__$1;
(statearr_22293_22379[(2)] = inst_22189);

(statearr_22293_22379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22195 === (49))){
var inst_22113 = cljs.core.count.call(null,clause);
var inst_22114 = cljs.core._EQ_.call(null,(1),inst_22113);
var state_22194__$1 = state_22194;
if(inst_22114){
var statearr_22294_22380 = state_22194__$1;
(statearr_22294_22380[(1)] = (51));

} else {
var statearr_22295_22381 = state_22194__$1;
(statearr_22295_22381[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_22296 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22296[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_22296[(1)] = (1));

return statearr_22296;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_22194){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22194);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22297){var ex__2749__auto__ = e22297;
var statearr_22298_22382 = state_22194;
(statearr_22298_22382[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22194[(4)]))){
var statearr_22299_22383 = state_22194;
(statearr_22299_22383[(1)] = cljs.core.first.call(null,(state_22194[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22384 = state_22194;
state_22194 = G__22384;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = function(state_22194){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_22194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22300 = f__2769__auto__.call(null);
(statearr_22300[(6)] = c__2768__auto__);

return statearr_22300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__22386 = arguments.length;
switch (G__22386) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22466){
var state_val_22467 = (state_22466[(1)]);
if((state_val_22467 === (7))){
var inst_22461 = (state_22466[(2)]);
var _ = (function (){var statearr_22468 = state_22466;
(statearr_22468[(4)] = cljs.core.rest.call(null,(state_22466[(4)])));

return statearr_22468;
})();
var state_22466__$1 = state_22466;
var statearr_22469_22517 = state_22466__$1;
(statearr_22469_22517[(2)] = inst_22461);

(statearr_22469_22517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (20))){
var inst_22426 = (state_22466[(7)]);
var inst_22438 = (state_22466[(2)]);
var inst_22408 = inst_22426;
var inst_22409 = inst_22438;
var state_22466__$1 = (function (){var statearr_22470 = state_22466;
(statearr_22470[(8)] = inst_22408);

(statearr_22470[(9)] = inst_22409);

return statearr_22470;
})();
var statearr_22471_22518 = state_22466__$1;
(statearr_22471_22518[(2)] = null);

(statearr_22471_22518[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (1))){
var state_22466__$1 = state_22466;
var statearr_22472_22519 = state_22466__$1;
(statearr_22472_22519[(2)] = null);

(statearr_22472_22519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (24))){
var inst_22409 = (state_22466[(9)]);
var inst_22425 = (state_22466[(10)]);
var inst_22426 = (state_22466[(7)]);
var inst_22446 = fluree.db.query.analytical.inner_join.call(null,inst_22409,inst_22425);
var inst_22408 = inst_22426;
var inst_22409__$1 = inst_22446;
var state_22466__$1 = (function (){var statearr_22473 = state_22466;
(statearr_22473[(8)] = inst_22408);

(statearr_22473[(9)] = inst_22409__$1);

return statearr_22473;
})();
var statearr_22474_22520 = state_22466__$1;
(statearr_22474_22520[(2)] = null);

(statearr_22474_22520[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (4))){
var inst_22387 = (state_22466[(2)]);
var state_22466__$1 = state_22466;
var statearr_22476_22521 = state_22466__$1;
(statearr_22476_22521[(2)] = inst_22387);

(statearr_22476_22521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (15))){
var inst_22425 = (state_22466[(10)]);
var state_22466__$1 = state_22466;
if(cljs.core.truth_(inst_22425)){
var statearr_22477_22522 = state_22466__$1;
(statearr_22477_22522[(1)] = (18));

} else {
var statearr_22478_22523 = state_22466__$1;
(statearr_22478_22523[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (21))){
var inst_22409 = (state_22466[(9)]);
var inst_22426 = (state_22466[(7)]);
var tmp22475 = inst_22409;
var inst_22408 = inst_22426;
var inst_22409__$1 = tmp22475;
var state_22466__$1 = (function (){var statearr_22479 = state_22466;
(statearr_22479[(8)] = inst_22408);

(statearr_22479[(9)] = inst_22409__$1);

return statearr_22479;
})();
var statearr_22480_22524 = state_22466__$1;
(statearr_22480_22524[(2)] = null);

(statearr_22480_22524[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (13))){
var inst_22409 = (state_22466[(9)]);
var inst_22432 = cljs.core.dissoc.call(null,inst_22409,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_22433 = cljs.core.empty_QMARK_.call(null,inst_22432);
var state_22466__$1 = state_22466;
if(inst_22433){
var statearr_22481_22525 = state_22466__$1;
(statearr_22481_22525[(1)] = (15));

} else {
var statearr_22482_22526 = state_22466__$1;
(statearr_22482_22526[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (22))){
var state_22466__$1 = state_22466;
var statearr_22483_22527 = state_22466__$1;
(statearr_22483_22527[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (6))){
var inst_22408 = (state_22466[(8)]);
var inst_22415 = (state_22466[(11)]);
var inst_22414 = cljs.core.seq.call(null,inst_22408);
var inst_22415__$1 = cljs.core.first.call(null,inst_22414);
var inst_22416 = cljs.core.next.call(null,inst_22414);
var state_22466__$1 = (function (){var statearr_22485 = state_22466;
(statearr_22485[(12)] = inst_22416);

(statearr_22485[(11)] = inst_22415__$1);

return statearr_22485;
})();
if(cljs.core.truth_(inst_22415__$1)){
var statearr_22486_22528 = state_22466__$1;
(statearr_22486_22528[(1)] = (8));

} else {
var statearr_22487_22529 = state_22466__$1;
(statearr_22487_22529[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (25))){
var state_22466__$1 = state_22466;
var statearr_22488_22530 = state_22466__$1;
(statearr_22488_22530[(2)] = null);

(statearr_22488_22530[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (17))){
var inst_22454 = (state_22466[(2)]);
var state_22466__$1 = state_22466;
var statearr_22489_22531 = state_22466__$1;
(statearr_22489_22531[(2)] = inst_22454);

(statearr_22489_22531[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (3))){
var inst_22464 = (state_22466[(2)]);
var state_22466__$1 = state_22466;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22466__$1,inst_22464);
} else {
if((state_val_22467 === (12))){
var inst_22425 = (state_22466[(10)]);
var inst_22426 = (state_22466[(7)]);
var inst_22408 = inst_22426;
var inst_22409 = inst_22425;
var state_22466__$1 = (function (){var statearr_22490 = state_22466;
(statearr_22490[(8)] = inst_22408);

(statearr_22490[(9)] = inst_22409);

return statearr_22490;
})();
var statearr_22491_22532 = state_22466__$1;
(statearr_22491_22532[(2)] = null);

(statearr_22491_22532[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (2))){
var _ = (function (){var statearr_22492 = state_22466;
(statearr_22492[(4)] = cljs.core.cons.call(null,(5),(state_22466[(4)])));

return statearr_22492;
})();
var inst_22400 = where;
var inst_22401 = cljs.core.seq.call(null,inst_22400);
var inst_22402 = cljs.core.first.call(null,inst_22401);
var inst_22403 = cljs.core.next.call(null,inst_22401);
var inst_22404 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_22405 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_22406 = [inst_22405];
var inst_22407 = cljs.core.PersistentHashMap.fromArrays(inst_22404,inst_22406);
var inst_22408 = inst_22400;
var inst_22409 = inst_22407;
var state_22466__$1 = (function (){var statearr_22493 = state_22466;
(statearr_22493[(13)] = inst_22403);

(statearr_22493[(8)] = inst_22408);

(statearr_22493[(9)] = inst_22409);

(statearr_22493[(14)] = inst_22402);

return statearr_22493;
})();
var statearr_22494_22533 = state_22466__$1;
(statearr_22494_22533[(2)] = null);

(statearr_22494_22533[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (23))){
var inst_22452 = (state_22466[(2)]);
var state_22466__$1 = state_22466;
var statearr_22495_22534 = state_22466__$1;
(statearr_22495_22534[(2)] = inst_22452);

(statearr_22495_22534[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (19))){
var inst_22409 = (state_22466[(9)]);
var state_22466__$1 = state_22466;
var statearr_22496_22535 = state_22466__$1;
(statearr_22496_22535[(2)] = inst_22409);

(statearr_22496_22535[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (11))){
var inst_22415 = (state_22466[(11)]);
var inst_22423 = (state_22466[(2)]);
var inst_22424 = fluree.db.util.async.throw_err.call(null,inst_22423);
var inst_22425 = cljs.core.nth.call(null,inst_22424,(0),null);
var inst_22426 = cljs.core.nth.call(null,inst_22424,(1),null);
var inst_22427 = cljs.core.count.call(null,inst_22415);
var inst_22428 = cljs.core._EQ_.call(null,(2),inst_22427);
var state_22466__$1 = (function (){var statearr_22498 = state_22466;
(statearr_22498[(10)] = inst_22425);

(statearr_22498[(7)] = inst_22426);

return statearr_22498;
})();
if(inst_22428){
var statearr_22499_22536 = state_22466__$1;
(statearr_22499_22536[(1)] = (12));

} else {
var statearr_22500_22537 = state_22466__$1;
(statearr_22500_22537[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (9))){
var inst_22409 = (state_22466[(9)]);
var state_22466__$1 = state_22466;
var statearr_22501_22538 = state_22466__$1;
(statearr_22501_22538[(2)] = inst_22409);

(statearr_22501_22538[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (5))){
var _ = (function (){var statearr_22502 = state_22466;
(statearr_22502[(4)] = cljs.core.rest.call(null,(state_22466[(4)])));

return statearr_22502;
})();
var state_22466__$1 = state_22466;
var ex22497 = (state_22466__$1[(2)]);
var statearr_22503_22539 = state_22466__$1;
(statearr_22503_22539[(5)] = ex22497);


if((ex22497 instanceof Error)){
var statearr_22504_22540 = state_22466__$1;
(statearr_22504_22540[(1)] = (4));

(statearr_22504_22540[(5)] = null);

} else {
throw ex22497;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (14))){
var inst_22456 = (state_22466[(2)]);
var state_22466__$1 = state_22466;
var statearr_22505_22541 = state_22466__$1;
(statearr_22505_22541[(2)] = inst_22456);

(statearr_22505_22541[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (26))){
var inst_22450 = (state_22466[(2)]);
var state_22466__$1 = state_22466;
var statearr_22506_22542 = state_22466__$1;
(statearr_22506_22542[(2)] = inst_22450);

(statearr_22506_22542[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (16))){
var inst_22425 = (state_22466[(10)]);
var inst_22441 = (inst_22425 == null);
var state_22466__$1 = state_22466;
if(cljs.core.truth_(inst_22441)){
var statearr_22507_22543 = state_22466__$1;
(statearr_22507_22543[(1)] = (21));

} else {
var statearr_22508_22544 = state_22466__$1;
(statearr_22508_22544[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (10))){
var inst_22459 = (state_22466[(2)]);
var state_22466__$1 = state_22466;
var statearr_22509_22545 = state_22466__$1;
(statearr_22509_22545[(2)] = inst_22459);

(statearr_22509_22545[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (18))){
var inst_22425 = (state_22466[(10)]);
var state_22466__$1 = state_22466;
var statearr_22510_22546 = state_22466__$1;
(statearr_22510_22546[(2)] = inst_22425);

(statearr_22510_22546[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22467 === (8))){
var inst_22416 = (state_22466[(12)]);
var inst_22409 = (state_22466[(9)]);
var inst_22415 = (state_22466[(11)]);
var inst_22421 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_22409,inst_22415,inst_22416,false,fuel,max_fuel,opts);
var state_22466__$1 = state_22466;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22466__$1,(11),inst_22421);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_22511 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22511[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_22511[(1)] = (1));

return statearr_22511;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_22466){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22466);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22512){var ex__2749__auto__ = e22512;
var statearr_22513_22547 = state_22466;
(statearr_22513_22547[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22466[(4)]))){
var statearr_22514_22548 = state_22466;
(statearr_22514_22548[(1)] = cljs.core.first.call(null,(state_22466[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22549 = state_22466;
state_22466 = G__22549;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_22466){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_22466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22515 = f__2769__auto__.call(null);
(statearr_22515[(6)] = c__2768__auto__);

return statearr_22515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22584){
var state_val_22585 = (state_22584[(1)]);
if((state_val_22585 === (7))){
var inst_22561 = (state_22584[(7)]);
var inst_22566 = (state_22584[(8)]);
var inst_22568 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_22561,inst_22566,fuel,max_fuel,opts);
var state_22584__$1 = state_22584;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22584__$1,(10),inst_22568);
} else {
if((state_val_22585 === (1))){
var state_22584__$1 = state_22584;
var statearr_22586_22611 = state_22584__$1;
(statearr_22586_22611[(2)] = null);

(statearr_22586_22611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22585 === (4))){
var inst_22550 = (state_22584[(2)]);
var state_22584__$1 = state_22584;
var statearr_22587_22612 = state_22584__$1;
(statearr_22587_22612[(2)] = inst_22550);

(statearr_22587_22612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22585 === (13))){
var inst_22579 = (state_22584[(2)]);
var _ = (function (){var statearr_22588 = state_22584;
(statearr_22588[(4)] = cljs.core.rest.call(null,(state_22584[(4)])));

return statearr_22588;
})();
var state_22584__$1 = state_22584;
var statearr_22589_22613 = state_22584__$1;
(statearr_22589_22613[(2)] = inst_22579);

(statearr_22589_22613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22585 === (6))){
var inst_22561 = (state_22584[(7)]);
var inst_22565 = (state_22584[(2)]);
var inst_22566 = fluree.db.util.async.throw_err.call(null,inst_22565);
var state_22584__$1 = (function (){var statearr_22590 = state_22584;
(statearr_22590[(8)] = inst_22566);

return statearr_22590;
})();
if(cljs.core.truth_(inst_22561)){
var statearr_22591_22614 = state_22584__$1;
(statearr_22591_22614[(1)] = (7));

} else {
var statearr_22592_22615 = state_22584__$1;
(statearr_22592_22615[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22585 === (3))){
var inst_22582 = (state_22584[(2)]);
var state_22584__$1 = state_22584;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22584__$1,inst_22582);
} else {
if((state_val_22585 === (12))){
var inst_22574 = (state_22584[(9)]);
var state_22584__$1 = state_22584;
var statearr_22593_22616 = state_22584__$1;
(statearr_22593_22616[(2)] = inst_22574);

(statearr_22593_22616[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22585 === (2))){
var _ = (function (){var statearr_22594 = state_22584;
(statearr_22594[(4)] = cljs.core.cons.call(null,(5),(state_22584[(4)])));

return statearr_22594;
})();
var inst_22557 = q_map;
var inst_22558 = cljs.core.__destructure_map.call(null,inst_22557);
var inst_22559 = cljs.core.get.call(null,inst_22558,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_22560 = cljs.core.get.call(null,inst_22558,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_22561 = cljs.core.get.call(null,inst_22558,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_22562 = cljs.core.get.call(null,inst_22558,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_22563 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_22560,q_map,inst_22559,fuel,max_fuel,opts);
var state_22584__$1 = (function (){var statearr_22595 = state_22584;
(statearr_22595[(7)] = inst_22561);

(statearr_22595[(10)] = inst_22562);

return statearr_22595;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22584__$1,(6),inst_22563);
} else {
if((state_val_22585 === (11))){
var inst_22574 = (state_22584[(9)]);
var inst_22562 = (state_22584[(10)]);
var inst_22576 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_22574,inst_22562,null);
var state_22584__$1 = state_22584;
var statearr_22597_22617 = state_22584__$1;
(statearr_22597_22617[(2)] = inst_22576);

(statearr_22597_22617[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22585 === (9))){
var inst_22562 = (state_22584[(10)]);
var inst_22574 = (state_22584[(2)]);
var state_22584__$1 = (function (){var statearr_22598 = state_22584;
(statearr_22598[(9)] = inst_22574);

return statearr_22598;
})();
if(cljs.core.truth_(inst_22562)){
var statearr_22599_22618 = state_22584__$1;
(statearr_22599_22618[(1)] = (11));

} else {
var statearr_22600_22619 = state_22584__$1;
(statearr_22600_22619[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22585 === (5))){
var _ = (function (){var statearr_22601 = state_22584;
(statearr_22601[(4)] = cljs.core.rest.call(null,(state_22584[(4)])));

return statearr_22601;
})();
var state_22584__$1 = state_22584;
var ex22596 = (state_22584__$1[(2)]);
var statearr_22602_22620 = state_22584__$1;
(statearr_22602_22620[(5)] = ex22596);


if((ex22596 instanceof Error)){
var statearr_22603_22621 = state_22584__$1;
(statearr_22603_22621[(1)] = (4));

(statearr_22603_22621[(5)] = null);

} else {
throw ex22596;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22585 === (10))){
var inst_22570 = (state_22584[(2)]);
var inst_22571 = fluree.db.util.async.throw_err.call(null,inst_22570);
var state_22584__$1 = state_22584;
var statearr_22604_22622 = state_22584__$1;
(statearr_22604_22622[(2)] = inst_22571);

(statearr_22604_22622[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22585 === (8))){
var inst_22566 = (state_22584[(8)]);
var state_22584__$1 = state_22584;
var statearr_22605_22623 = state_22584__$1;
(statearr_22605_22623[(2)] = inst_22566);

(statearr_22605_22623[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2746__auto____0 = (function (){
var statearr_22606 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22606[(0)] = fluree$db$query$analytical$q_$_state_machine__2746__auto__);

(statearr_22606[(1)] = (1));

return statearr_22606;
});
var fluree$db$query$analytical$q_$_state_machine__2746__auto____1 = (function (state_22584){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22584);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22607){var ex__2749__auto__ = e22607;
var statearr_22608_22624 = state_22584;
(statearr_22608_22624[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22584[(4)]))){
var statearr_22609_22625 = state_22584;
(statearr_22609_22625[(1)] = cljs.core.first.call(null,(state_22584[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22626 = state_22584;
state_22584 = G__22626;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2746__auto__ = function(state_22584){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____1.call(this,state_22584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2746__auto____0;
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22610 = f__2769__auto__.call(null);
(statearr_22610[(6)] = c__2768__auto__);

return statearr_22610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
