// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__19505 = arguments.length;
switch (G__19505) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__19508 = arguments.length;
switch (G__19508) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___19561 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19539){
var state_val_19540 = (state_19539[(1)]);
if((state_val_19540 === (1))){
var state_19539__$1 = state_19539;
var statearr_19541_19562 = state_19539__$1;
(statearr_19541_19562[(2)] = null);

(statearr_19541_19562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (2))){
var _ = (function (){var statearr_19542 = state_19539;
(statearr_19542[(4)] = cljs.core.cons.call(null,(5),(state_19539[(4)])));

return statearr_19542;
})();
var inst_19516 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_19539__$1 = state_19539;
if(cljs.core.truth_(inst_19516)){
var statearr_19543_19563 = state_19539__$1;
(statearr_19543_19563[(1)] = (6));

} else {
var statearr_19544_19564 = state_19539__$1;
(statearr_19544_19564[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (3))){
var inst_19537 = (state_19539[(2)]);
var state_19539__$1 = state_19539;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19539__$1,inst_19537);
} else {
if((state_val_19540 === (4))){
var inst_19509 = (state_19539[(2)]);
var inst_19510 = cljs.core.async.put_BANG_.call(null,pc,inst_19509);
var state_19539__$1 = state_19539;
var statearr_19546_19565 = state_19539__$1;
(statearr_19546_19565[(2)] = inst_19510);

(statearr_19546_19565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (5))){
var _ = (function (){var statearr_19547 = state_19539;
(statearr_19547[(4)] = cljs.core.rest.call(null,(state_19539[(4)])));

return statearr_19547;
})();
var state_19539__$1 = state_19539;
var ex19545 = (state_19539__$1[(2)]);
var statearr_19548_19566 = state_19539__$1;
(statearr_19548_19566[(5)] = ex19545);


var statearr_19549_19567 = state_19539__$1;
(statearr_19549_19567[(1)] = (4));

(statearr_19549_19567[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (6))){
var inst_19518 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19519 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_19520 = cljs.core.PersistentHashMap.fromArrays(inst_19518,inst_19519);
var inst_19521 = cljs.core.ex_info.call(null,"Connection was closed.",inst_19520);
var inst_19522 = (function(){throw inst_19521})();
var state_19539__$1 = state_19539;
var statearr_19550_19568 = state_19539__$1;
(statearr_19550_19568[(2)] = inst_19522);

(statearr_19550_19568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (7))){
var inst_19524 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_19525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19526 = [operation,data,pc,opts];
var inst_19527 = (new cljs.core.PersistentVector(null,4,(5),inst_19525,inst_19526,null));
var inst_19528 = cljs.core.async.put_BANG_.call(null,inst_19524,inst_19527);
var inst_19529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19530 = [operation,data,pc,opts];
var inst_19531 = (new cljs.core.PersistentVector(null,4,(5),inst_19529,inst_19530,null));
var inst_19532 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_19531);
var state_19539__$1 = (function (){var statearr_19551 = state_19539;
(statearr_19551[(7)] = inst_19528);

return statearr_19551;
})();
var statearr_19552_19569 = state_19539__$1;
(statearr_19552_19569[(2)] = inst_19532);

(statearr_19552_19569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (8))){
var inst_19534 = (state_19539[(2)]);
var _ = (function (){var statearr_19553 = state_19539;
(statearr_19553[(4)] = cljs.core.rest.call(null,(state_19539[(4)])));

return statearr_19553;
})();
var state_19539__$1 = state_19539;
var statearr_19554_19570 = state_19539__$1;
(statearr_19554_19570[(2)] = inst_19534);

(statearr_19554_19570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2746__auto__ = null;
var fluree$db$operations$state_machine__2746__auto____0 = (function (){
var statearr_19555 = [null,null,null,null,null,null,null,null];
(statearr_19555[(0)] = fluree$db$operations$state_machine__2746__auto__);

(statearr_19555[(1)] = (1));

return statearr_19555;
});
var fluree$db$operations$state_machine__2746__auto____1 = (function (state_19539){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19539);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19556){var ex__2749__auto__ = e19556;
var statearr_19557_19571 = state_19539;
(statearr_19557_19571[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19539[(4)]))){
var statearr_19558_19572 = state_19539;
(statearr_19558_19572[(1)] = cljs.core.first.call(null,(state_19539[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19573 = state_19539;
state_19539 = G__19573;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2746__auto__ = function(state_19539){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2746__auto____1.call(this,state_19539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2746__auto____0;
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2746__auto____1;
return fluree$db$operations$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19559 = f__2769__auto__.call(null);
(statearr_19559[(6)] = c__2768__auto___19561);

return statearr_19559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__19575 = arguments.length;
switch (G__19575) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__19576){
var map__19577 = p__19576;
var map__19577__$1 = cljs.core.__destructure_map.call(null,map__19577);
var opts = map__19577__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__19577__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__19578 = session;
var map__19578__$1 = cljs.core.__destructure_map.call(null,map__19578);
var dbid = cljs.core.get.call(null,map__19578__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__19578__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__19578__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5775__auto__ = [];
var len__5769__auto___19605 = arguments.length;
var i__5770__auto___19606 = (0);
while(true){
if((i__5770__auto___19606 < len__5769__auto___19605)){
args__5775__auto__.push((arguments[i__5770__auto___19606]));

var G__19607 = (i__5770__auto___19606 + (1));
i__5770__auto___19606 = G__19607;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__19582){
var vec__19583 = p__19582;
var map__19586 = cljs.core.nth.call(null,vec__19583,(0),null);
var map__19586__$1 = cljs.core.__destructure_map.call(null,map__19586);
var toBlock = cljs.core.get.call(null,map__19586__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__19586__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__19583;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19598){
var state_val_19599 = (state_19598[(1)]);
if((state_val_19599 === (1))){
var inst_19588 = session;
var inst_19589 = cljs.core.__destructure_map.call(null,inst_19588);
var inst_19590 = cljs.core.get.call(null,inst_19589,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_19591 = cljs.core.get.call(null,inst_19589,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_19592 = cljs.core.get.call(null,inst_19589,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_19593 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_19594 = [inst_19590,inst_19591,toBlock,toTime];
var inst_19595 = cljs.core.PersistentHashMap.fromArrays(inst_19593,inst_19594);
var inst_19596 = fluree.db.operations.send_operation.call(null,inst_19592,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_19595);
var state_19598__$1 = state_19598;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19598__$1,inst_19596);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2746__auto__ = null;
var fluree$db$operations$state_machine__2746__auto____0 = (function (){
var statearr_19600 = [null,null,null,null,null,null,null];
(statearr_19600[(0)] = fluree$db$operations$state_machine__2746__auto__);

(statearr_19600[(1)] = (1));

return statearr_19600;
});
var fluree$db$operations$state_machine__2746__auto____1 = (function (state_19598){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19598);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19601){var ex__2749__auto__ = e19601;
var statearr_19602_19608 = state_19598;
(statearr_19602_19608[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19598[(4)]))){
var statearr_19603_19609 = state_19598;
(statearr_19603_19609[(1)] = cljs.core.first.call(null,(state_19598[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19610 = state_19598;
state_19598 = G__19610;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2746__auto__ = function(state_19598){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2746__auto____1.call(this,state_19598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2746__auto____0;
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2746__auto____1;
return fluree$db$operations$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19604 = f__2769__auto__.call(null);
(statearr_19604[(6)] = c__2768__auto__);

return statearr_19604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq19580){
var G__19581 = cljs.core.first.call(null,seq19580);
var seq19580__$1 = cljs.core.next.call(null,seq19580);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19581,seq19580__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__19611 = session;
var map__19611__$1 = cljs.core.__destructure_map.call(null,map__19611);
var network = cljs.core.get.call(null,map__19611__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__19611__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__19611__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__19613 = arguments.length;
switch (G__19613) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__19614 = opts;
var map__19614__$1 = cljs.core.__destructure_map.call(null,map__19614);
var auth = cljs.core.get.call(null,map__19614__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__19614__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
