// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__63127 = arguments.length;
switch (G__63127) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63169){
var state_val_63170 = (state_63169[(1)]);
if((state_val_63170 === (7))){
var inst_63139 = typeof user === 'string';
var state_63169__$1 = state_63169;
if(cljs.core.truth_(inst_63139)){
var statearr_63171_63200 = state_63169__$1;
(statearr_63171_63200[(1)] = (9));

} else {
var statearr_63172_63201 = state_63169__$1;
(statearr_63172_63201[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (1))){
var state_63169__$1 = state_63169;
var statearr_63173_63202 = state_63169__$1;
(statearr_63173_63202[(2)] = null);

(statearr_63173_63202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (4))){
var inst_63128 = (state_63169[(2)]);
var inst_63129 = fluree.db.util.log.error.call(null,inst_63128);
var inst_63130 = reject.call(null,inst_63128);
var state_63169__$1 = (function (){var statearr_63174 = state_63169;
(statearr_63174[(7)] = inst_63129);

return statearr_63174;
})();
var statearr_63175_63203 = state_63169__$1;
(statearr_63175_63203[(2)] = inst_63130);

(statearr_63175_63203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (15))){
var inst_63158 = (state_63169[(2)]);
var inst_63159 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_63158);
var inst_63160 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63161 = cljs.core.constantly.call(null,inst_63159);
var inst_63162 = cljs.core.swap_BANG_.call(null,inst_63160,inst_63161);
var inst_63163 = fluree.db.connection.add_token.call(null,conn,inst_63159);
var inst_63164 = resolve.call(null,inst_63158);
var _ = (function (){var statearr_63176 = state_63169;
(statearr_63176[(4)] = cljs.core.rest.call(null,(state_63169[(4)])));

return statearr_63176;
})();
var state_63169__$1 = (function (){var statearr_63177 = state_63169;
(statearr_63177[(8)] = inst_63162);

(statearr_63177[(9)] = inst_63163);

return statearr_63177;
})();
var statearr_63178_63204 = state_63169__$1;
(statearr_63178_63204[(2)] = inst_63164);

(statearr_63178_63204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (13))){
var state_63169__$1 = state_63169;
var statearr_63179_63205 = state_63169__$1;
(statearr_63179_63205[(2)] = null);

(statearr_63179_63205[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (6))){
var state_63169__$1 = state_63169;
var statearr_63180_63206 = state_63169__$1;
(statearr_63180_63206[(2)] = user);

(statearr_63180_63206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (3))){
var inst_63167 = (state_63169[(2)]);
var state_63169__$1 = state_63169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63169__$1,inst_63167);
} else {
if((state_val_63170 === (12))){
var state_63169__$1 = state_63169;
var statearr_63181_63207 = state_63169__$1;
(statearr_63181_63207[(2)] = user);

(statearr_63181_63207[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (2))){
var _ = (function (){var statearr_63182 = state_63169;
(statearr_63182[(4)] = cljs.core.cons.call(null,(5),(state_63169[(4)])));

return statearr_63182;
})();
var inst_63136 = typeof user === 'number';
var state_63169__$1 = state_63169;
if(cljs.core.truth_(inst_63136)){
var statearr_63183_63208 = state_63169__$1;
(statearr_63183_63208[(1)] = (6));

} else {
var statearr_63184_63209 = state_63169__$1;
(statearr_63184_63209[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (11))){
var inst_63150 = (state_63169[(2)]);
var state_63169__$1 = state_63169;
var statearr_63186_63210 = state_63169__$1;
(statearr_63186_63210[(2)] = inst_63150);

(statearr_63186_63210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (9))){
var inst_63141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63142 = ["_user/username",user];
var inst_63143 = (new cljs.core.PersistentVector(null,2,(5),inst_63141,inst_63142,null));
var state_63169__$1 = state_63169;
var statearr_63187_63211 = state_63169__$1;
(statearr_63187_63211[(2)] = inst_63143);

(statearr_63187_63211[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (5))){
var _ = (function (){var statearr_63188 = state_63169;
(statearr_63188[(4)] = cljs.core.rest.call(null,(state_63169[(4)])));

return statearr_63188;
})();
var state_63169__$1 = state_63169;
var ex63185 = (state_63169__$1[(2)]);
var statearr_63189_63212 = state_63169__$1;
(statearr_63189_63212[(5)] = ex63185);


var statearr_63190_63213 = state_63169__$1;
(statearr_63190_63213[(1)] = (4));

(statearr_63190_63213[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (14))){
var inst_63148 = (state_63169[(2)]);
var state_63169__$1 = state_63169;
var statearr_63191_63214 = state_63169__$1;
(statearr_63191_63214[(2)] = inst_63148);

(statearr_63191_63214[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (10))){
var state_63169__$1 = state_63169;
var statearr_63192_63215 = state_63169__$1;
(statearr_63192_63215[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63170 === (8))){
var inst_63152 = (state_63169[(2)]);
var inst_63153 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_63154 = [account,inst_63152,password,expireSeconds,syncTo];
var inst_63155 = cljs.core.PersistentHashMap.fromArrays(inst_63153,inst_63154);
var inst_63156 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_63155);
var state_63169__$1 = state_63169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63169__$1,(15),inst_63156);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_63194 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63194[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_63194[(1)] = (1));

return statearr_63194;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_63169){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63195){var ex__2749__auto__ = e63195;
var statearr_63196_63216 = state_63169;
(statearr_63196_63216[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63169[(4)]))){
var statearr_63197_63217 = state_63169;
(statearr_63197_63217[(1)] = cljs.core.first.call(null,(state_63169[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63218 = state_63169;
state_63169 = G__63218;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_63169){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_63169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63198 = f__2769__auto__.call(null);
(statearr_63198[(6)] = c__2768__auto__);

return statearr_63198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__63220 = arguments.length;
switch (G__63220) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63229){
var state_val_63230 = (state_63229[(1)]);
if((state_val_63230 === (1))){
var inst_63221 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63223 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_63224 = (new cljs.core.PersistentVector(null,4,(5),inst_63222,inst_63223,null));
var inst_63225 = cljs.core.async.put_BANG_.call(null,inst_63221,inst_63224);
var inst_63226 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__63231 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__63232 = null;
var count__63233 = (0);
var i__63234 = (0);
while(true){
if((i__63234 < count__63233)){
var k = cljs.core._nth.call(null,chunk__63232,i__63234);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__63242 = seq__63231;
var G__63243 = chunk__63232;
var G__63244 = count__63233;
var G__63245 = (i__63234 + (1));
seq__63231 = G__63242;
chunk__63232 = G__63243;
count__63233 = G__63244;
i__63234 = G__63245;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__63231);
if(temp__5804__auto__){
var seq__63231__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63231__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__63231__$1);
var G__63246 = cljs.core.chunk_rest.call(null,seq__63231__$1);
var G__63247 = c__5568__auto__;
var G__63248 = cljs.core.count.call(null,c__5568__auto__);
var G__63249 = (0);
seq__63231 = G__63246;
chunk__63232 = G__63247;
count__63233 = G__63248;
i__63234 = G__63249;
continue;
} else {
var k = cljs.core.first.call(null,seq__63231__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__63250 = cljs.core.next.call(null,seq__63231__$1);
var G__63251 = null;
var G__63252 = (0);
var G__63253 = (0);
seq__63231 = G__63250;
chunk__63232 = G__63251;
count__63233 = G__63252;
i__63234 = G__63253;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_63227 = cljs.core.async.take_BANG_.call(null,pc,inst_63226);
var state_63229__$1 = (function (){var statearr_63235 = state_63229;
(statearr_63235[(7)] = inst_63225);

return statearr_63235;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63229__$1,inst_63227);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_63236 = [null,null,null,null,null,null,null,null];
(statearr_63236[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_63236[(1)] = (1));

return statearr_63236;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_63229){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63237){var ex__2749__auto__ = e63237;
var statearr_63238_63254 = state_63229;
(statearr_63238_63254[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63229[(4)]))){
var statearr_63239_63255 = state_63229;
(statearr_63239_63255[(1)] = cljs.core.first.call(null,(state_63229[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63256 = state_63229;
state_63229 = G__63256;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_63229){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_63229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63240 = f__2769__auto__.call(null);
(statearr_63240[(6)] = c__2768__auto__);

return statearr_63240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__63258 = arguments.length;
switch (G__63258) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63292){
var state_val_63293 = (state_63292[(1)]);
if((state_val_63293 === (1))){
var state_63292__$1 = state_63292;
var statearr_63294_63315 = state_63292__$1;
(statearr_63294_63315[(2)] = null);

(statearr_63294_63315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63293 === (2))){
var _ = (function (){var statearr_63295 = state_63292;
(statearr_63295[(4)] = cljs.core.cons.call(null,(5),(state_63292[(4)])));

return statearr_63295;
})();
var inst_63267 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_63268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63269 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_63270 = (new cljs.core.PersistentVector(null,1,(5),inst_63268,inst_63269,null));
var inst_63271 = cljs.core.PersistentHashMap.EMPTY;
var inst_63272 = cljs.core.atom.call(null,inst_63271);
var inst_63273 = cljs.core.assoc_in.call(null,inst_63267,inst_63270,inst_63272);
var inst_63274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63275 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63276 = (new cljs.core.PersistentVector(null,1,(5),inst_63274,inst_63275,null));
var inst_63277 = cljs.core.PersistentHashMap.EMPTY;
var inst_63278 = cljs.core.atom.call(null,inst_63277);
var inst_63279 = cljs.core.assoc_in.call(null,inst_63273,inst_63276,inst_63278);
var inst_63280 = cljs.core.async.promise_chan.call(null);
var inst_63281 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_63279);
var inst_63282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63283 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_63280,null];
var inst_63284 = (new cljs.core.PersistentVector(null,4,(5),inst_63282,inst_63283,null));
var inst_63285 = cljs.core.async.put_BANG_.call(null,inst_63281,inst_63284);
var inst_63286 = (function (){var conn = inst_63279;
var pc = inst_63280;
return (function (x){
if((x == null)){
} else {
var seq__63296_63316 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__63297_63317 = null;
var count__63298_63318 = (0);
var i__63299_63319 = (0);
while(true){
if((i__63299_63319 < count__63298_63318)){
var k_63320 = cljs.core._nth.call(null,chunk__63297_63317,i__63299_63319);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63320], null),cljs.core.get.call(null,x,k_63320,null));


var G__63321 = seq__63296_63316;
var G__63322 = chunk__63297_63317;
var G__63323 = count__63298_63318;
var G__63324 = (i__63299_63319 + (1));
seq__63296_63316 = G__63321;
chunk__63297_63317 = G__63322;
count__63298_63318 = G__63323;
i__63299_63319 = G__63324;
continue;
} else {
var temp__5804__auto___63325 = cljs.core.seq.call(null,seq__63296_63316);
if(temp__5804__auto___63325){
var seq__63296_63326__$1 = temp__5804__auto___63325;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63296_63326__$1)){
var c__5568__auto___63327 = cljs.core.chunk_first.call(null,seq__63296_63326__$1);
var G__63328 = cljs.core.chunk_rest.call(null,seq__63296_63326__$1);
var G__63329 = c__5568__auto___63327;
var G__63330 = cljs.core.count.call(null,c__5568__auto___63327);
var G__63331 = (0);
seq__63296_63316 = G__63328;
chunk__63297_63317 = G__63329;
count__63298_63318 = G__63330;
i__63299_63319 = G__63331;
continue;
} else {
var k_63332 = cljs.core.first.call(null,seq__63296_63326__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63332], null),cljs.core.get.call(null,x,k_63332,null));


var G__63333 = cljs.core.next.call(null,seq__63296_63326__$1);
var G__63334 = null;
var G__63335 = (0);
var G__63336 = (0);
seq__63296_63316 = G__63333;
chunk__63297_63317 = G__63334;
count__63298_63318 = G__63335;
i__63299_63319 = G__63336;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_63287 = cljs.core.async.take_BANG_.call(null,inst_63280,inst_63286);
var ___$1 = (function (){var statearr_63300 = state_63292;
(statearr_63300[(4)] = cljs.core.rest.call(null,(state_63292[(4)])));

return statearr_63300;
})();
var state_63292__$1 = (function (){var statearr_63301 = state_63292;
(statearr_63301[(7)] = inst_63285);

return statearr_63301;
})();
var statearr_63302_63337 = state_63292__$1;
(statearr_63302_63337[(2)] = inst_63287);

(statearr_63302_63337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63293 === (3))){
var inst_63290 = (state_63292[(2)]);
var state_63292__$1 = state_63292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63292__$1,inst_63290);
} else {
if((state_val_63293 === (4))){
var inst_63259 = (state_63292[(2)]);
var inst_63260 = fluree.db.util.log.error.call(null,inst_63259);
var inst_63261 = reject.call(null,inst_63259);
var state_63292__$1 = (function (){var statearr_63304 = state_63292;
(statearr_63304[(8)] = inst_63260);

return statearr_63304;
})();
var statearr_63305_63338 = state_63292__$1;
(statearr_63305_63338[(2)] = inst_63261);

(statearr_63305_63338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63293 === (5))){
var _ = (function (){var statearr_63306 = state_63292;
(statearr_63306[(4)] = cljs.core.rest.call(null,(state_63292[(4)])));

return statearr_63306;
})();
var state_63292__$1 = state_63292;
var ex63303 = (state_63292__$1[(2)]);
var statearr_63307_63339 = state_63292__$1;
(statearr_63307_63339[(5)] = ex63303);


var statearr_63308_63340 = state_63292__$1;
(statearr_63308_63340[(1)] = (4));

(statearr_63308_63340[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_63309 = [null,null,null,null,null,null,null,null,null];
(statearr_63309[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_63309[(1)] = (1));

return statearr_63309;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_63292){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63310){var ex__2749__auto__ = e63310;
var statearr_63311_63341 = state_63292;
(statearr_63311_63341[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63292[(4)]))){
var statearr_63312_63342 = state_63292;
(statearr_63312_63342[(1)] = cljs.core.first.call(null,(state_63292[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63343 = state_63292;
state_63292 = G__63343;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_63292){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_63292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63313 = f__2769__auto__.call(null);
(statearr_63313[(6)] = c__2768__auto__);

return statearr_63313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__63345 = arguments.length;
switch (G__63345) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__63347 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__63347,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__63347,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__63350 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__63350,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__63350,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63403){
var state_val_63404 = (state_63403[(1)]);
if((state_val_63404 === (7))){
var inst_63364 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63365 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63366 = cljs.core.PersistentHashMap.fromArrays(inst_63364,inst_63365);
var inst_63367 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_63366);
var inst_63368 = (function(){throw inst_63367})();
var state_63403__$1 = state_63403;
var statearr_63405_63434 = state_63403__$1;
(statearr_63405_63434[(2)] = inst_63368);

(statearr_63405_63434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (1))){
var state_63403__$1 = state_63403;
var statearr_63406_63435 = state_63403__$1;
(statearr_63406_63435[(2)] = null);

(statearr_63406_63435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (4))){
var inst_63353 = (state_63403[(2)]);
var inst_63354 = cljs.core.clj__GT_js.call(null,inst_63353);
var inst_63355 = reject.call(null,inst_63354);
var state_63403__$1 = state_63403;
var statearr_63407_63436 = state_63403__$1;
(statearr_63407_63436[(2)] = inst_63355);

(statearr_63407_63436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (13))){
var inst_63382 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63383 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63384 = cljs.core.PersistentHashMap.fromArrays(inst_63382,inst_63383);
var inst_63385 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_63384);
var inst_63386 = (function(){throw inst_63385})();
var state_63403__$1 = state_63403;
var statearr_63408_63437 = state_63403__$1;
(statearr_63408_63437[(2)] = inst_63386);

(statearr_63408_63437[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (6))){
var state_63403__$1 = state_63403;
var statearr_63409_63438 = state_63403__$1;
(statearr_63409_63438[(2)] = null);

(statearr_63409_63438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (3))){
var inst_63401 = (state_63403[(2)]);
var state_63403__$1 = state_63403;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63403__$1,inst_63401);
} else {
if((state_val_63404 === (12))){
var state_63403__$1 = state_63403;
var statearr_63410_63439 = state_63403__$1;
(statearr_63410_63439[(2)] = null);

(statearr_63410_63439[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (2))){
var _ = (function (){var statearr_63411 = state_63403;
(statearr_63411[(4)] = cljs.core.cons.call(null,(5),(state_63403[(4)])));

return statearr_63411;
})();
var inst_63361 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_63403__$1 = state_63403;
if(cljs.core.truth_(inst_63361)){
var statearr_63412_63440 = state_63403__$1;
(statearr_63412_63440[(1)] = (6));

} else {
var statearr_63413_63441 = state_63403__$1;
(statearr_63413_63441[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (11))){
var inst_63379 = (state_63403[(2)]);
var state_63403__$1 = (function (){var statearr_63415 = state_63403;
(statearr_63415[(7)] = inst_63379);

return statearr_63415;
})();
if(cljs.core.truth_(password)){
var statearr_63416_63442 = state_63403__$1;
(statearr_63416_63442[(1)] = (12));

} else {
var statearr_63417_63443 = state_63403__$1;
(statearr_63417_63443[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (9))){
var state_63403__$1 = state_63403;
var statearr_63418_63444 = state_63403__$1;
(statearr_63418_63444[(2)] = null);

(statearr_63418_63444[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (5))){
var _ = (function (){var statearr_63419 = state_63403;
(statearr_63419[(4)] = cljs.core.rest.call(null,(state_63403[(4)])));

return statearr_63419;
})();
var state_63403__$1 = state_63403;
var ex63414 = (state_63403__$1[(2)]);
var statearr_63420_63445 = state_63403__$1;
(statearr_63420_63445[(5)] = ex63414);


var statearr_63421_63446 = state_63403__$1;
(statearr_63421_63446[(1)] = (4));

(statearr_63421_63446[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (14))){
var inst_63388 = (state_63403[(2)]);
var inst_63389 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_63390 = fluree.db.util.core.without_nils.call(null,inst_63389);
var inst_63391 = cljs.core.async.promise_chan.call(null);
var inst_63392 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63394 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_63390,inst_63391,null];
var inst_63395 = (new cljs.core.PersistentVector(null,4,(5),inst_63393,inst_63394,null));
var inst_63396 = cljs.core.async.put_BANG_.call(null,inst_63392,inst_63395);
var inst_63397 = (function (){var _ = inst_63388;
var data = inst_63390;
var pc = inst_63391;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_63398 = cljs.core.async.take_BANG_.call(null,inst_63391,inst_63397);
var _ = (function (){var statearr_63422 = state_63403;
(statearr_63422[(4)] = cljs.core.rest.call(null,(state_63403[(4)])));

return statearr_63422;
})();
var state_63403__$1 = (function (){var statearr_63423 = state_63403;
(statearr_63423[(8)] = inst_63396);

return statearr_63423;
})();
var statearr_63424_63447 = state_63403__$1;
(statearr_63424_63447[(2)] = inst_63398);

(statearr_63424_63447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (10))){
var inst_63373 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63374 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63375 = cljs.core.PersistentHashMap.fromArrays(inst_63373,inst_63374);
var inst_63376 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_63375);
var inst_63377 = (function(){throw inst_63376})();
var state_63403__$1 = state_63403;
var statearr_63425_63448 = state_63403__$1;
(statearr_63425_63448[(2)] = inst_63377);

(statearr_63425_63448[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63404 === (8))){
var inst_63370 = (state_63403[(2)]);
var state_63403__$1 = (function (){var statearr_63426 = state_63403;
(statearr_63426[(9)] = inst_63370);

return statearr_63426;
})();
if(cljs.core.truth_(ledger)){
var statearr_63427_63449 = state_63403__$1;
(statearr_63427_63449[(1)] = (9));

} else {
var statearr_63428_63450 = state_63403__$1;
(statearr_63428_63450[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0 = (function (){
var statearr_63429 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63429[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2746__auto__);

(statearr_63429[(1)] = (1));

return statearr_63429;
});
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1 = (function (state_63403){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63403);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63430){var ex__2749__auto__ = e63430;
var statearr_63431_63451 = state_63403;
(statearr_63431_63451[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63403[(4)]))){
var statearr_63432_63452 = state_63403;
(statearr_63432_63452[(1)] = cljs.core.first.call(null,(state_63403[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63453 = state_63403;
state_63403 = G__63453;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = function(state_63403){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1.call(this,state_63403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63433 = f__2769__auto__.call(null);
(statearr_63433[(6)] = c__2768__auto__);

return statearr_63433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__63455 = arguments.length;
switch (G__63455) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63522){
var state_val_63523 = (state_63522[(1)]);
if((state_val_63523 === (7))){
var inst_63467 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63468 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63469 = cljs.core.PersistentHashMap.fromArrays(inst_63467,inst_63468);
var inst_63470 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_63469);
var inst_63471 = (function(){throw inst_63470})();
var state_63522__$1 = state_63522;
var statearr_63524_63563 = state_63522__$1;
(statearr_63524_63563[(2)] = inst_63471);

(statearr_63524_63563[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (20))){
var inst_63505 = (state_63522[(2)]);
var inst_63506 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63507 = [ledger,password,user,auth,expire];
var inst_63508 = cljs.core.PersistentHashMap.fromArrays(inst_63506,inst_63507);
var inst_63509 = fluree.db.util.core.without_nils.call(null,inst_63508);
var inst_63510 = cljs.core.async.promise_chan.call(null);
var inst_63511 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63513 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_63509,inst_63510,null];
var inst_63514 = (new cljs.core.PersistentVector(null,4,(5),inst_63512,inst_63513,null));
var inst_63515 = cljs.core.async.put_BANG_.call(null,inst_63511,inst_63514);
var inst_63516 = (function (){var _ = inst_63505;
var data = inst_63509;
var pc = inst_63510;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_63517 = cljs.core.async.take_BANG_.call(null,inst_63510,inst_63516);
var _ = (function (){var statearr_63525 = state_63522;
(statearr_63525[(4)] = cljs.core.rest.call(null,(state_63522[(4)])));

return statearr_63525;
})();
var state_63522__$1 = (function (){var statearr_63526 = state_63522;
(statearr_63526[(7)] = inst_63515);

return statearr_63526;
})();
var statearr_63527_63564 = state_63522__$1;
(statearr_63527_63564[(2)] = inst_63517);

(statearr_63527_63564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (1))){
var state_63522__$1 = state_63522;
var statearr_63528_63565 = state_63522__$1;
(statearr_63528_63565[(2)] = null);

(statearr_63528_63565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (4))){
var inst_63456 = (state_63522[(2)]);
var inst_63457 = cljs.core.clj__GT_js.call(null,inst_63456);
var inst_63458 = reject.call(null,inst_63457);
var state_63522__$1 = state_63522;
var statearr_63529_63566 = state_63522__$1;
(statearr_63529_63566[(2)] = inst_63458);

(statearr_63529_63566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (15))){
var inst_63492 = (state_63522[(8)]);
var state_63522__$1 = state_63522;
var statearr_63530_63567 = state_63522__$1;
(statearr_63530_63567[(2)] = inst_63492);

(statearr_63530_63567[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (13))){
var inst_63485 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63486 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63487 = cljs.core.PersistentHashMap.fromArrays(inst_63485,inst_63486);
var inst_63488 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_63487);
var inst_63489 = (function(){throw inst_63488})();
var state_63522__$1 = state_63522;
var statearr_63531_63568 = state_63522__$1;
(statearr_63531_63568[(2)] = inst_63489);

(statearr_63531_63568[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (6))){
var state_63522__$1 = state_63522;
var statearr_63532_63569 = state_63522__$1;
(statearr_63532_63569[(2)] = null);

(statearr_63532_63569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (17))){
var inst_63496 = (state_63522[(2)]);
var state_63522__$1 = state_63522;
if(cljs.core.truth_(inst_63496)){
var statearr_63533_63570 = state_63522__$1;
(statearr_63533_63570[(1)] = (18));

} else {
var statearr_63534_63571 = state_63522__$1;
(statearr_63534_63571[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (3))){
var inst_63520 = (state_63522[(2)]);
var state_63522__$1 = state_63522;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63522__$1,inst_63520);
} else {
if((state_val_63523 === (12))){
var state_63522__$1 = state_63522;
var statearr_63535_63572 = state_63522__$1;
(statearr_63535_63572[(2)] = null);

(statearr_63535_63572[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (2))){
var _ = (function (){var statearr_63536 = state_63522;
(statearr_63536[(4)] = cljs.core.cons.call(null,(5),(state_63522[(4)])));

return statearr_63536;
})();
var inst_63464 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_63522__$1 = state_63522;
if(cljs.core.truth_(inst_63464)){
var statearr_63537_63573 = state_63522__$1;
(statearr_63537_63573[(1)] = (6));

} else {
var statearr_63538_63574 = state_63522__$1;
(statearr_63538_63574[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (19))){
var inst_63499 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63500 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63501 = cljs.core.PersistentHashMap.fromArrays(inst_63499,inst_63500);
var inst_63502 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_63501);
var inst_63503 = (function(){throw inst_63502})();
var state_63522__$1 = state_63522;
var statearr_63539_63575 = state_63522__$1;
(statearr_63539_63575[(2)] = inst_63503);

(statearr_63539_63575[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (11))){
var inst_63482 = (state_63522[(2)]);
var state_63522__$1 = (function (){var statearr_63541 = state_63522;
(statearr_63541[(9)] = inst_63482);

return statearr_63541;
})();
if(cljs.core.truth_(password)){
var statearr_63542_63576 = state_63522__$1;
(statearr_63542_63576[(1)] = (12));

} else {
var statearr_63543_63577 = state_63522__$1;
(statearr_63543_63577[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (9))){
var state_63522__$1 = state_63522;
var statearr_63544_63578 = state_63522__$1;
(statearr_63544_63578[(2)] = null);

(statearr_63544_63578[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (5))){
var _ = (function (){var statearr_63545 = state_63522;
(statearr_63545[(4)] = cljs.core.rest.call(null,(state_63522[(4)])));

return statearr_63545;
})();
var state_63522__$1 = state_63522;
var ex63540 = (state_63522__$1[(2)]);
var statearr_63546_63579 = state_63522__$1;
(statearr_63546_63579[(5)] = ex63540);


var statearr_63547_63580 = state_63522__$1;
(statearr_63547_63580[(1)] = (4));

(statearr_63547_63580[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (14))){
var inst_63492 = (state_63522[(8)]);
var inst_63491 = (state_63522[(2)]);
var inst_63492__$1 = user;
var state_63522__$1 = (function (){var statearr_63548 = state_63522;
(statearr_63548[(8)] = inst_63492__$1);

(statearr_63548[(10)] = inst_63491);

return statearr_63548;
})();
if(cljs.core.truth_(inst_63492__$1)){
var statearr_63549_63581 = state_63522__$1;
(statearr_63549_63581[(1)] = (15));

} else {
var statearr_63550_63582 = state_63522__$1;
(statearr_63550_63582[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (16))){
var state_63522__$1 = state_63522;
var statearr_63551_63583 = state_63522__$1;
(statearr_63551_63583[(2)] = auth);

(statearr_63551_63583[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (10))){
var inst_63476 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63477 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63478 = cljs.core.PersistentHashMap.fromArrays(inst_63476,inst_63477);
var inst_63479 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_63478);
var inst_63480 = (function(){throw inst_63479})();
var state_63522__$1 = state_63522;
var statearr_63552_63584 = state_63522__$1;
(statearr_63552_63584[(2)] = inst_63480);

(statearr_63552_63584[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (18))){
var state_63522__$1 = state_63522;
var statearr_63553_63585 = state_63522__$1;
(statearr_63553_63585[(2)] = null);

(statearr_63553_63585[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63523 === (8))){
var inst_63473 = (state_63522[(2)]);
var state_63522__$1 = (function (){var statearr_63554 = state_63522;
(statearr_63554[(11)] = inst_63473);

return statearr_63554;
})();
if(cljs.core.truth_(ledger)){
var statearr_63555_63586 = state_63522__$1;
(statearr_63555_63586[(1)] = (9));

} else {
var statearr_63556_63587 = state_63522__$1;
(statearr_63556_63587[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_63557 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63557[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_63557[(1)] = (1));

return statearr_63557;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_63522){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63522);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63558){var ex__2749__auto__ = e63558;
var statearr_63559_63588 = state_63522;
(statearr_63559_63588[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63522[(4)]))){
var statearr_63560_63589 = state_63522;
(statearr_63560_63589[(1)] = cljs.core.first.call(null,(state_63522[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63590 = state_63522;
state_63522 = G__63590;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_63522){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_63522);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63561 = f__2769__auto__.call(null);
(statearr_63561[(6)] = c__2768__auto__);

return statearr_63561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__63592 = arguments.length;
switch (G__63592) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63627){
var state_val_63628 = (state_63627[(1)]);
if((state_val_63628 === (1))){
var state_63627__$1 = state_63627;
var statearr_63629_63649 = state_63627__$1;
(statearr_63629_63649[(2)] = null);

(statearr_63629_63649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63628 === (2))){
var _ = (function (){var statearr_63630 = state_63627;
(statearr_63630[(4)] = cljs.core.cons.call(null,(5),(state_63627[(4)])));

return statearr_63630;
})();
var inst_63601 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_63627__$1 = state_63627;
if(cljs.core.truth_(inst_63601)){
var statearr_63631_63650 = state_63627__$1;
(statearr_63631_63650[(1)] = (6));

} else {
var statearr_63632_63651 = state_63627__$1;
(statearr_63632_63651[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63628 === (3))){
var inst_63625 = (state_63627[(2)]);
var state_63627__$1 = state_63627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63627__$1,inst_63625);
} else {
if((state_val_63628 === (4))){
var inst_63593 = (state_63627[(2)]);
var inst_63594 = cljs.core.clj__GT_js.call(null,inst_63593);
var inst_63595 = reject.call(null,inst_63594);
var state_63627__$1 = state_63627;
var statearr_63634_63652 = state_63627__$1;
(statearr_63634_63652[(2)] = inst_63595);

(statearr_63634_63652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63628 === (5))){
var _ = (function (){var statearr_63635 = state_63627;
(statearr_63635[(4)] = cljs.core.rest.call(null,(state_63627[(4)])));

return statearr_63635;
})();
var state_63627__$1 = state_63627;
var ex63633 = (state_63627__$1[(2)]);
var statearr_63636_63653 = state_63627__$1;
(statearr_63636_63653[(5)] = ex63633);


var statearr_63637_63654 = state_63627__$1;
(statearr_63637_63654[(1)] = (4));

(statearr_63637_63654[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63628 === (6))){
var state_63627__$1 = state_63627;
var statearr_63638_63655 = state_63627__$1;
(statearr_63638_63655[(2)] = null);

(statearr_63638_63655[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63628 === (7))){
var inst_63604 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63605 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63606 = cljs.core.PersistentHashMap.fromArrays(inst_63604,inst_63605);
var inst_63607 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_63606);
var inst_63608 = (function(){throw inst_63607})();
var state_63627__$1 = state_63627;
var statearr_63639_63656 = state_63627__$1;
(statearr_63639_63656[(2)] = inst_63608);

(statearr_63639_63656[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63628 === (8))){
var inst_63610 = (state_63627[(2)]);
var inst_63611 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63612 = [jwt,expire];
var inst_63613 = cljs.core.PersistentHashMap.fromArrays(inst_63611,inst_63612);
var inst_63614 = fluree.db.util.core.without_nils.call(null,inst_63613);
var inst_63615 = cljs.core.async.promise_chan.call(null);
var inst_63616 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63618 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_63614,inst_63615,null];
var inst_63619 = (new cljs.core.PersistentVector(null,4,(5),inst_63617,inst_63618,null));
var inst_63620 = cljs.core.async.put_BANG_.call(null,inst_63616,inst_63619);
var inst_63621 = (function (){var _ = inst_63610;
var data = inst_63614;
var pc = inst_63615;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_63622 = cljs.core.async.take_BANG_.call(null,inst_63615,inst_63621);
var _ = (function (){var statearr_63640 = state_63627;
(statearr_63640[(4)] = cljs.core.rest.call(null,(state_63627[(4)])));

return statearr_63640;
})();
var state_63627__$1 = (function (){var statearr_63641 = state_63627;
(statearr_63641[(7)] = inst_63620);

return statearr_63641;
})();
var statearr_63642_63657 = state_63627__$1;
(statearr_63642_63657[(2)] = inst_63622);

(statearr_63642_63657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_63643 = [null,null,null,null,null,null,null,null];
(statearr_63643[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_63643[(1)] = (1));

return statearr_63643;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_63627){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63644){var ex__2749__auto__ = e63644;
var statearr_63645_63658 = state_63627;
(statearr_63645_63658[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63627[(4)]))){
var statearr_63646_63659 = state_63627;
(statearr_63646_63659[(1)] = cljs.core.first.call(null,(state_63627[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63660 = state_63627;
state_63627 = G__63660;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_63627){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_63627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63647 = f__2769__auto__.call(null);
(statearr_63647[(6)] = c__2768__auto__);

return statearr_63647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

