// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63734 = arguments.length;
var i__5770__auto___63735 = (0);
while(true){
if((i__5770__auto___63735 < len__5769__auto___63734)){
args__5775__auto__.push((arguments[i__5770__auto___63735]));

var G__63736 = (i__5770__auto___63735 + (1));
i__5770__auto___63735 = G__63736;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__63666){
var vec__63667 = p__63666;
var opts = cljs.core.nth.call(null,vec__63667,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___63737 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63711){
var state_val_63712 = (state_63711[(1)]);
if((state_val_63712 === (7))){
var inst_63688 = (state_63711[(7)]);
var inst_63697 = (state_63711[(8)]);
var inst_63699 = fluree.db.time_travel.as_of_block.call(null,inst_63697,inst_63688);
var state_63711__$1 = state_63711;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63711__$1,(10),inst_63699);
} else {
if((state_val_63712 === (1))){
var state_63711__$1 = state_63711;
var statearr_63713_63738 = state_63711__$1;
(statearr_63713_63738[(2)] = null);

(statearr_63713_63738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63712 === (4))){
var inst_63670 = (state_63711[(2)]);
var inst_63671 = fluree.db.util.log.error.call(null,inst_63670);
var inst_63672 = cljs.core.async.put_BANG_.call(null,pc,inst_63670);
var inst_63673 = cljs.core.async.close_BANG_.call(null,pc);
var state_63711__$1 = (function (){var statearr_63714 = state_63711;
(statearr_63714[(9)] = inst_63672);

(statearr_63714[(10)] = inst_63671);

return statearr_63714;
})();
var statearr_63715_63739 = state_63711__$1;
(statearr_63715_63739[(2)] = inst_63673);

(statearr_63715_63739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63712 === (6))){
var inst_63692 = (state_63711[(11)]);
var inst_63688 = (state_63711[(7)]);
var inst_63691 = (state_63711[(12)]);
var inst_63695 = (state_63711[(2)]);
var inst_63696 = fluree.db.util.async.throw_err.call(null,inst_63695);
var inst_63697 = cljs.core.assoc.call(null,inst_63696,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_63691,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_63692);
var state_63711__$1 = (function (){var statearr_63716 = state_63711;
(statearr_63716[(8)] = inst_63697);

return statearr_63716;
})();
if(cljs.core.truth_(inst_63688)){
var statearr_63717_63740 = state_63711__$1;
(statearr_63717_63740[(1)] = (7));

} else {
var statearr_63718_63741 = state_63711__$1;
(statearr_63718_63741[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63712 === (3))){
var inst_63709 = (state_63711[(2)]);
var state_63711__$1 = state_63711;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63711__$1,inst_63709);
} else {
if((state_val_63712 === (2))){
var _ = (function (){var statearr_63720 = state_63711;
(statearr_63720[(4)] = cljs.core.cons.call(null,(5),(state_63711[(4)])));

return statearr_63720;
})();
var inst_63683 = opts;
var inst_63684 = cljs.core.__destructure_map.call(null,inst_63683);
var inst_63685 = cljs.core.get.call(null,inst_63684,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_63686 = cljs.core.get.call(null,inst_63684,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_63687 = cljs.core.get.call(null,inst_63684,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_63688 = cljs.core.get.call(null,inst_63684,new cljs.core.Keyword(null,"block","block",664686210));
var inst_63689 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_63690 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_63691 = cljs.core.nth.call(null,inst_63690,(0),null);
var inst_63692 = cljs.core.nth.call(null,inst_63690,(1),null);
var inst_63693 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_63711__$1 = (function (){var statearr_63721 = state_63711;
(statearr_63721[(13)] = inst_63687);

(statearr_63721[(14)] = inst_63686);

(statearr_63721[(11)] = inst_63692);

(statearr_63721[(15)] = inst_63689);

(statearr_63721[(7)] = inst_63688);

(statearr_63721[(16)] = inst_63685);

(statearr_63721[(12)] = inst_63691);

return statearr_63721;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63711__$1,(6),inst_63693);
} else {
if((state_val_63712 === (9))){
var inst_63705 = (state_63711[(2)]);
var inst_63706 = cljs.core.async.put_BANG_.call(null,pc,inst_63705);
var _ = (function (){var statearr_63722 = state_63711;
(statearr_63722[(4)] = cljs.core.rest.call(null,(state_63711[(4)])));

return statearr_63722;
})();
var state_63711__$1 = state_63711;
var statearr_63723_63742 = state_63711__$1;
(statearr_63723_63742[(2)] = inst_63706);

(statearr_63723_63742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63712 === (5))){
var _ = (function (){var statearr_63724 = state_63711;
(statearr_63724[(4)] = cljs.core.rest.call(null,(state_63711[(4)])));

return statearr_63724;
})();
var state_63711__$1 = state_63711;
var ex63719 = (state_63711__$1[(2)]);
var statearr_63725_63743 = state_63711__$1;
(statearr_63725_63743[(5)] = ex63719);


var statearr_63726_63744 = state_63711__$1;
(statearr_63726_63744[(1)] = (4));

(statearr_63726_63744[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63712 === (10))){
var inst_63701 = (state_63711[(2)]);
var inst_63702 = fluree.db.util.async.throw_err.call(null,inst_63701);
var state_63711__$1 = state_63711;
var statearr_63727_63745 = state_63711__$1;
(statearr_63727_63745[(2)] = inst_63702);

(statearr_63727_63745[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63712 === (8))){
var inst_63697 = (state_63711[(8)]);
var state_63711__$1 = state_63711;
var statearr_63728_63746 = state_63711__$1;
(statearr_63728_63746[(2)] = inst_63697);

(statearr_63728_63746[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_63729 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63729[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_63729[(1)] = (1));

return statearr_63729;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_63711){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63711);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63730){var ex__2749__auto__ = e63730;
var statearr_63731_63747 = state_63711;
(statearr_63731_63747[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63711[(4)]))){
var statearr_63732_63748 = state_63711;
(statearr_63732_63748[(1)] = cljs.core.first.call(null,(state_63711[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63749 = state_63711;
state_63711 = G__63749;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_63711){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_63711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63733 = f__2769__auto__.call(null);
(statearr_63733[(6)] = c__2768__auto___63737);

return statearr_63733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq63663){
var G__63664 = cljs.core.first.call(null,seq63663);
var seq63663__$1 = cljs.core.next.call(null,seq63663);
var G__63665 = cljs.core.first.call(null,seq63663__$1);
var seq63663__$2 = cljs.core.next.call(null,seq63663__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63664,G__63665,seq63663__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__63751 = arguments.length;
switch (G__63751) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63877){
var state_val_63878 = (state_63877[(1)]);
if((state_val_63878 === (7))){
var inst_63767 = (state_63877[(7)]);
var inst_63777 = (state_63877[(8)]);
var inst_63779 = fluree.db.time_travel.as_of_block.call(null,inst_63777,inst_63767);
var state_63877__$1 = state_63877;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63877__$1,(10),inst_63779);
} else {
if((state_val_63878 === (20))){
var inst_63771 = (state_63877[(9)]);
var state_63877__$1 = state_63877;
var statearr_63879_63959 = state_63877__$1;
(statearr_63879_63959[(2)] = inst_63771);

(statearr_63879_63959[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (27))){
var inst_63765 = (state_63877[(10)]);
var state_63877__$1 = state_63877;
var statearr_63880_63960 = state_63877__$1;
(statearr_63880_63960[(2)] = inst_63765);

(statearr_63880_63960[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (1))){
var state_63877__$1 = state_63877;
var statearr_63881_63961 = state_63877__$1;
(statearr_63881_63961[(2)] = null);

(statearr_63881_63961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (24))){
var inst_63774 = (state_63877[(11)]);
var state_63877__$1 = state_63877;
if(cljs.core.truth_(inst_63774)){
var statearr_63882_63962 = state_63877__$1;
(statearr_63882_63962[(1)] = (26));

} else {
var statearr_63883_63963 = state_63877__$1;
(statearr_63883_63963[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (39))){
var inst_63839 = (state_63877[(12)]);
var inst_63842 = cljs.core.ex_data.call(null,inst_63839);
var inst_63843 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63844 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_63842);
var inst_63845 = cljs.core.ex_message.call(null,inst_63839);
var inst_63846 = [inst_63844,inst_63845,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63847 = cljs.core.PersistentHashMap.fromArrays(inst_63843,inst_63846);
var state_63877__$1 = state_63877;
var statearr_63884_63964 = state_63877__$1;
(statearr_63884_63964[(2)] = inst_63847);

(statearr_63884_63964[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (46))){
var inst_63839 = (state_63877[(12)]);
var state_63877__$1 = state_63877;
var statearr_63885_63965 = state_63877__$1;
(statearr_63885_63965[(2)] = inst_63839);

(statearr_63885_63965[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (4))){
var inst_63752 = (state_63877[(2)]);
var inst_63753 = fluree.db.util.log.error.call(null,inst_63752);
var inst_63754 = cljs.core.ex_data.call(null,inst_63752);
var inst_63755 = cljs.core.ex_message.call(null,inst_63752);
var inst_63756 = cljs.core.assoc.call(null,inst_63754,new cljs.core.Keyword(null,"message","message",-406056002),inst_63755);
var state_63877__$1 = (function (){var statearr_63886 = state_63877;
(statearr_63886[(13)] = inst_63753);

return statearr_63886;
})();
var statearr_63887_63966 = state_63877__$1;
(statearr_63887_63966[(2)] = inst_63756);

(statearr_63887_63966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (15))){
var state_63877__$1 = state_63877;
var statearr_63888_63967 = state_63877__$1;
(statearr_63888_63967[(2)] = (1000000));

(statearr_63888_63967[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (48))){
var inst_63839 = (state_63877[(12)]);
var state_63877__$1 = state_63877;
var statearr_63889_63968 = state_63877__$1;
(statearr_63889_63968[(2)] = inst_63839);

(statearr_63889_63968[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (50))){
var inst_63866 = (state_63877[(2)]);
var state_63877__$1 = state_63877;
var statearr_63890_63969 = state_63877__$1;
(statearr_63890_63969[(2)] = inst_63866);

(statearr_63890_63969[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (21))){
var inst_63770 = (state_63877[(14)]);
var state_63877__$1 = state_63877;
if(cljs.core.truth_(inst_63770)){
var statearr_63891_63970 = state_63877__$1;
(statearr_63891_63970[(1)] = (23));

} else {
var statearr_63892_63971 = state_63877__$1;
(statearr_63892_63971[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (31))){
var inst_63828 = (state_63877[(2)]);
var inst_63829 = cljs.core.not.call(null,inst_63828);
var state_63877__$1 = state_63877;
if(inst_63829){
var statearr_63893_63972 = state_63877__$1;
(statearr_63893_63972[(1)] = (35));

} else {
var statearr_63894_63973 = state_63877__$1;
(statearr_63894_63973[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (32))){
var inst_63772 = (state_63877[(15)]);
var state_63877__$1 = state_63877;
var statearr_63895_63974 = state_63877__$1;
(statearr_63895_63974[(2)] = inst_63772);

(statearr_63895_63974[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (40))){
var inst_63802 = (state_63877[(16)]);
var state_63877__$1 = state_63877;
if(cljs.core.truth_(inst_63802)){
var statearr_63896_63975 = state_63877__$1;
(statearr_63896_63975[(1)] = (42));

} else {
var statearr_63897_63976 = state_63877__$1;
(statearr_63897_63976[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (33))){
var inst_63768 = (state_63877[(17)]);
var state_63877__$1 = state_63877;
var statearr_63898_63977 = state_63877__$1;
(statearr_63898_63977[(2)] = inst_63768);

(statearr_63898_63977[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (13))){
var inst_63773 = (state_63877[(18)]);
var inst_63797 = (state_63877[(19)]);
var inst_63795 = (state_63877[(2)]);
var inst_63796 = cljs.core.volatile_BANG_.call(null,(0));
var inst_63797__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_63773);
var state_63877__$1 = (function (){var statearr_63899 = state_63877;
(statearr_63899[(20)] = inst_63796);

(statearr_63899[(19)] = inst_63797__$1);

(statearr_63899[(21)] = inst_63795);

return statearr_63899;
})();
if(cljs.core.truth_(inst_63797__$1)){
var statearr_63900_63978 = state_63877__$1;
(statearr_63900_63978[(1)] = (14));

} else {
var statearr_63901_63979 = state_63877__$1;
(statearr_63901_63979[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (22))){
var inst_63818 = (state_63877[(2)]);
var state_63877__$1 = state_63877;
var statearr_63902_63980 = state_63877__$1;
(statearr_63902_63980[(2)] = inst_63818);

(statearr_63902_63980[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (36))){
var inst_63785 = (state_63877[(22)]);
var inst_63804 = (state_63877[(23)]);
var inst_63835 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_63804);
var inst_63836 = fluree.db.query.fql.query.call(null,inst_63785,inst_63835);
var state_63877__$1 = state_63877;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63877__$1,(38),inst_63836);
} else {
if((state_val_63878 === (41))){
var inst_63870 = (state_63877[(2)]);
var state_63877__$1 = state_63877;
var statearr_63903_63981 = state_63877__$1;
(statearr_63903_63981[(2)] = inst_63870);

(statearr_63903_63981[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (43))){
var state_63877__$1 = state_63877;
var statearr_63904_63982 = state_63877__$1;
(statearr_63904_63982[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (29))){
var inst_63772 = (state_63877[(15)]);
var state_63877__$1 = state_63877;
if(cljs.core.truth_(inst_63772)){
var statearr_63906_63983 = state_63877__$1;
(statearr_63906_63983[(1)] = (32));

} else {
var statearr_63907_63984 = state_63877__$1;
(statearr_63907_63984[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (44))){
var inst_63868 = (state_63877[(2)]);
var state_63877__$1 = state_63877;
var statearr_63908_63985 = state_63877__$1;
(statearr_63908_63985[(2)] = inst_63868);

(statearr_63908_63985[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (6))){
var inst_63767 = (state_63877[(7)]);
var inst_63776 = (state_63877[(2)]);
var inst_63777 = fluree.db.util.async.throw_err.call(null,inst_63776);
var state_63877__$1 = (function (){var statearr_63909 = state_63877;
(statearr_63909[(8)] = inst_63777);

return statearr_63909;
})();
if(cljs.core.truth_(inst_63767)){
var statearr_63910_63986 = state_63877__$1;
(statearr_63910_63986[(1)] = (7));

} else {
var statearr_63911_63987 = state_63877__$1;
(statearr_63911_63987[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (28))){
var inst_63814 = (state_63877[(2)]);
var state_63877__$1 = state_63877;
var statearr_63912_63988 = state_63877__$1;
(statearr_63912_63988[(2)] = inst_63814);

(statearr_63912_63988[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (25))){
var inst_63816 = (state_63877[(2)]);
var state_63877__$1 = state_63877;
var statearr_63913_63989 = state_63877__$1;
(statearr_63913_63989[(2)] = inst_63816);

(statearr_63913_63989[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (34))){
var inst_63825 = (state_63877[(2)]);
var state_63877__$1 = state_63877;
var statearr_63914_63990 = state_63877__$1;
(statearr_63914_63990[(2)] = inst_63825);

(statearr_63914_63990[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (17))){
var inst_63766 = (state_63877[(24)]);
var state_63877__$1 = state_63877;
var statearr_63915_63991 = state_63877__$1;
(statearr_63915_63991[(2)] = inst_63766);

(statearr_63915_63991[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (3))){
var inst_63875 = (state_63877[(2)]);
var state_63877__$1 = state_63877;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63877__$1,inst_63875);
} else {
if((state_val_63878 === (12))){
var inst_63793 = cljs.core.PersistentHashMap.EMPTY;
var state_63877__$1 = state_63877;
var statearr_63916_63992 = state_63877__$1;
(statearr_63916_63992[(2)] = inst_63793);

(statearr_63916_63992[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (2))){
var _ = (function (){var statearr_63917 = state_63877;
(statearr_63917[(4)] = cljs.core.cons.call(null,(5),(state_63877[(4)])));

return statearr_63917;
})();
var inst_63763 = query_map;
var inst_63764 = cljs.core.__destructure_map.call(null,inst_63763);
var inst_63765 = cljs.core.get.call(null,inst_63764,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_63766 = cljs.core.get.call(null,inst_63764,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_63767 = cljs.core.get.call(null,inst_63764,new cljs.core.Keyword(null,"block","block",664686210));
var inst_63768 = cljs.core.get.call(null,inst_63764,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_63769 = cljs.core.get.call(null,inst_63764,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_63770 = cljs.core.get.call(null,inst_63764,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_63771 = cljs.core.get.call(null,inst_63764,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_63772 = cljs.core.get.call(null,inst_63764,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_63773 = cljs.core.get.call(null,inst_63764,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_63774 = cljs.core.get.call(null,inst_63764,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_63877__$1 = (function (){var statearr_63918 = state_63877;
(statearr_63918[(18)] = inst_63773);

(statearr_63918[(9)] = inst_63771);

(statearr_63918[(14)] = inst_63770);

(statearr_63918[(7)] = inst_63767);

(statearr_63918[(15)] = inst_63772);

(statearr_63918[(25)] = inst_63769);

(statearr_63918[(10)] = inst_63765);

(statearr_63918[(17)] = inst_63768);

(statearr_63918[(11)] = inst_63774);

(statearr_63918[(24)] = inst_63766);

return statearr_63918;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63877__$1,(6),sources);
} else {
if((state_val_63878 === (23))){
var inst_63770 = (state_63877[(14)]);
var state_63877__$1 = state_63877;
var statearr_63919_63993 = state_63877__$1;
(statearr_63919_63993[(2)] = inst_63770);

(statearr_63919_63993[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (47))){
var inst_63785 = (state_63877[(22)]);
var inst_63796 = (state_63877[(20)]);
var inst_63850 = (state_63877[(26)]);
var inst_63803 = (state_63877[(27)]);
var inst_63856 = (state_63877[(2)]);
var inst_63857 = cljs.core.deref.call(null,inst_63796);
var inst_63858 = fluree.db.util.core.response_time_formatted.call(null,inst_63803);
var inst_63859 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_63785);
var inst_63860 = [(200),inst_63856,inst_63857,inst_63858,inst_63859];
var inst_63861 = cljs.core.PersistentHashMap.fromArrays(inst_63850,inst_63860);
var state_63877__$1 = state_63877;
var statearr_63920_63994 = state_63877__$1;
(statearr_63920_63994[(2)] = inst_63861);

(statearr_63920_63994[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (35))){
var inst_63831 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63832 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63833 = cljs.core.PersistentHashMap.fromArrays(inst_63831,inst_63832);
var state_63877__$1 = state_63877;
var statearr_63921_63995 = state_63877__$1;
(statearr_63921_63995[(2)] = inst_63833);

(statearr_63921_63995[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (19))){
var inst_63820 = (state_63877[(28)]);
var inst_63820__$1 = (state_63877[(2)]);
var state_63877__$1 = (function (){var statearr_63922 = state_63877;
(statearr_63922[(28)] = inst_63820__$1);

return statearr_63922;
})();
if(cljs.core.truth_(inst_63820__$1)){
var statearr_63923_63996 = state_63877__$1;
(statearr_63923_63996[(1)] = (29));

} else {
var statearr_63924_63997 = state_63877__$1;
(statearr_63924_63997[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (11))){
var inst_63785 = (state_63877[(22)]);
var inst_63769 = (state_63877[(25)]);
var inst_63786 = (state_63877[(29)]);
var inst_63788 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_63785);
var inst_63789 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_63786);
var inst_63790 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_63785);
var inst_63791 = fluree.db.api_js.get_sources.call(null,inst_63786,inst_63788,inst_63789,inst_63790,inst_63769,db_fn);
var state_63877__$1 = state_63877;
var statearr_63926_63998 = state_63877__$1;
(statearr_63926_63998[(2)] = inst_63791);

(statearr_63926_63998[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (9))){
var inst_63785 = (state_63877[(22)]);
var inst_63769 = (state_63877[(25)]);
var inst_63785__$1 = (state_63877[(2)]);
var inst_63786 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_63785__$1);
var state_63877__$1 = (function (){var statearr_63927 = state_63877;
(statearr_63927[(22)] = inst_63785__$1);

(statearr_63927[(29)] = inst_63786);

return statearr_63927;
})();
if(cljs.core.truth_(inst_63769)){
var statearr_63928_63999 = state_63877__$1;
(statearr_63928_63999[(1)] = (11));

} else {
var statearr_63929_64000 = state_63877__$1;
(statearr_63929_64000[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (5))){
var _ = (function (){var statearr_63930 = state_63877;
(statearr_63930[(4)] = cljs.core.rest.call(null,(state_63877[(4)])));

return statearr_63930;
})();
var state_63877__$1 = state_63877;
var ex63925 = (state_63877__$1[(2)]);
var statearr_63931_64001 = state_63877__$1;
(statearr_63931_64001[(5)] = ex63925);


var statearr_63932_64002 = state_63877__$1;
(statearr_63932_64002[(1)] = (4));

(statearr_63932_64002[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (14))){
var inst_63797 = (state_63877[(19)]);
var state_63877__$1 = state_63877;
var statearr_63933_64003 = state_63877__$1;
(statearr_63933_64003[(2)] = inst_63797);

(statearr_63933_64003[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (45))){
var inst_63839 = (state_63877[(12)]);
var inst_63853 = cljs.core.doall.call(null,inst_63839);
var state_63877__$1 = state_63877;
var statearr_63934_64004 = state_63877__$1;
(statearr_63934_64004[(2)] = inst_63853);

(statearr_63934_64004[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (26))){
var inst_63774 = (state_63877[(11)]);
var state_63877__$1 = state_63877;
var statearr_63935_64005 = state_63877__$1;
(statearr_63935_64005[(2)] = inst_63774);

(statearr_63935_64005[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (16))){
var inst_63773 = (state_63877[(18)]);
var inst_63796 = (state_63877[(20)]);
var inst_63795 = (state_63877[(21)]);
var inst_63766 = (state_63877[(24)]);
var inst_63801 = (state_63877[(2)]);
var inst_63802 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_63773);
var inst_63803 = fluree.db.util.core.current_time_millis.call(null);
var inst_63804 = cljs.core.assoc.call(null,inst_63773,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_63795,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_63801,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_63796);
var state_63877__$1 = (function (){var statearr_63936 = state_63877;
(statearr_63936[(16)] = inst_63802);

(statearr_63936[(23)] = inst_63804);

(statearr_63936[(27)] = inst_63803);

return statearr_63936;
})();
if(cljs.core.truth_(inst_63766)){
var statearr_63937_64006 = state_63877__$1;
(statearr_63937_64006[(1)] = (17));

} else {
var statearr_63938_64007 = state_63877__$1;
(statearr_63938_64007[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (38))){
var inst_63839 = (state_63877[(12)]);
var inst_63838 = (state_63877[(2)]);
var inst_63839__$1 = fluree.db.util.async.throw_err.call(null,inst_63838);
var inst_63840 = (inst_63839__$1 instanceof cljs.core.ExceptionInfo);
var state_63877__$1 = (function (){var statearr_63939 = state_63877;
(statearr_63939[(12)] = inst_63839__$1);

return statearr_63939;
})();
if(cljs.core.truth_(inst_63840)){
var statearr_63940_64008 = state_63877__$1;
(statearr_63940_64008[(1)] = (39));

} else {
var statearr_63941_64009 = state_63877__$1;
(statearr_63941_64009[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (30))){
var inst_63820 = (state_63877[(28)]);
var state_63877__$1 = state_63877;
var statearr_63942_64010 = state_63877__$1;
(statearr_63942_64010[(2)] = inst_63820);

(statearr_63942_64010[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (10))){
var inst_63781 = (state_63877[(2)]);
var inst_63782 = fluree.db.util.async.throw_err.call(null,inst_63781);
var state_63877__$1 = state_63877;
var statearr_63943_64011 = state_63877__$1;
(statearr_63943_64011[(2)] = inst_63782);

(statearr_63943_64011[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (18))){
var inst_63771 = (state_63877[(9)]);
var state_63877__$1 = state_63877;
if(cljs.core.truth_(inst_63771)){
var statearr_63944_64012 = state_63877__$1;
(statearr_63944_64012[(1)] = (20));

} else {
var statearr_63945_64013 = state_63877__$1;
(statearr_63945_64013[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (42))){
var inst_63839 = (state_63877[(12)]);
var inst_63850 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_63851 = cljs.core.sequential_QMARK_.call(null,inst_63839);
var state_63877__$1 = (function (){var statearr_63946 = state_63877;
(statearr_63946[(26)] = inst_63850);

return statearr_63946;
})();
if(inst_63851){
var statearr_63947_64014 = state_63877__$1;
(statearr_63947_64014[(1)] = (45));

} else {
var statearr_63948_64015 = state_63877__$1;
(statearr_63948_64015[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (37))){
var inst_63872 = (state_63877[(2)]);
var _ = (function (){var statearr_63949 = state_63877;
(statearr_63949[(4)] = cljs.core.rest.call(null,(state_63877[(4)])));

return statearr_63949;
})();
var state_63877__$1 = state_63877;
var statearr_63950_64016 = state_63877__$1;
(statearr_63950_64016[(2)] = inst_63872);

(statearr_63950_64016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (8))){
var inst_63777 = (state_63877[(8)]);
var state_63877__$1 = state_63877;
var statearr_63951_64017 = state_63877__$1;
(statearr_63951_64017[(2)] = inst_63777);

(statearr_63951_64017[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63878 === (49))){
var state_63877__$1 = state_63877;
var statearr_63952_64018 = state_63877__$1;
(statearr_63952_64018[(2)] = null);

(statearr_63952_64018[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_63953 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63953[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_63953[(1)] = (1));

return statearr_63953;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_63877){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63877);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63954){var ex__2749__auto__ = e63954;
var statearr_63955_64019 = state_63877;
(statearr_63955_64019[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63877[(4)]))){
var statearr_63956_64020 = state_63877;
(statearr_63956_64020[(1)] = cljs.core.first.call(null,(state_63877[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64021 = state_63877;
state_63877 = G__64021;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_63877){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_63877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63957 = f__2769__auto__.call(null);
(statearr_63957[(6)] = c__2768__auto__);

return statearr_63957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__64022_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__64022_SHARP_);
}));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64044){
var state_val_64045 = (state_64044[(1)]);
if((state_val_64045 === (1))){
var inst_64026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64027 = [resp_chan,timeout_chan];
var inst_64028 = (new cljs.core.PersistentVector(null,2,(5),inst_64026,inst_64027,null));
var state_64044__$1 = state_64044;
return cljs.core.async.ioc_alts_BANG_.call(null,state_64044__$1,(2),inst_64028);
} else {
if((state_val_64045 === (2))){
var inst_64030 = (state_64044[(2)]);
var inst_64031 = cljs.core.nth.call(null,inst_64030,(0),null);
var inst_64032 = cljs.core.nth.call(null,inst_64030,(1),null);
var inst_64033 = cljs.core._EQ_.call(null,timeout_chan,inst_64032);
var state_64044__$1 = (function (){var statearr_64046 = state_64044;
(statearr_64046[(7)] = inst_64031);

return statearr_64046;
})();
if(inst_64033){
var statearr_64047_64057 = state_64044__$1;
(statearr_64047_64057[(1)] = (3));

} else {
var statearr_64048_64058 = state_64044__$1;
(statearr_64048_64058[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64045 === (3))){
var inst_64035 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_64036 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64037 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_64038 = [tid,(408),inst_64037];
var inst_64039 = cljs.core.PersistentHashMap.fromArrays(inst_64036,inst_64038);
var state_64044__$1 = (function (){var statearr_64049 = state_64044;
(statearr_64049[(8)] = inst_64035);

return statearr_64049;
})();
var statearr_64050_64059 = state_64044__$1;
(statearr_64050_64059[(2)] = inst_64039);

(statearr_64050_64059[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64045 === (4))){
var inst_64031 = (state_64044[(7)]);
var state_64044__$1 = state_64044;
var statearr_64051_64060 = state_64044__$1;
(statearr_64051_64060[(2)] = inst_64031);

(statearr_64051_64060[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64045 === (5))){
var inst_64042 = (state_64044[(2)]);
var state_64044__$1 = state_64044;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64044__$1,inst_64042);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0 = (function (){
var statearr_64052 = [null,null,null,null,null,null,null,null,null];
(statearr_64052[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__);

(statearr_64052[(1)] = (1));

return statearr_64052;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1 = (function (state_64044){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64044);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64053){var ex__2749__auto__ = e64053;
var statearr_64054_64061 = state_64044;
(statearr_64054_64061[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64044[(4)]))){
var statearr_64055_64062 = state_64044;
(statearr_64055_64062[(1)] = cljs.core.first.call(null,(state_64044[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64063 = state_64044;
state_64044 = G__64063;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = function(state_64044){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1.call(this,state_64044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64056 = f__2769__auto__.call(null);
(statearr_64056[(6)] = c__2768__auto__);

return statearr_64056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__64065 = arguments.length;
switch (G__64065) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__64066 = opts;
var map__64066__$1 = cljs.core.__destructure_map.call(null,map__64066);
var auth = cljs.core.get.call(null,map__64066__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__64066__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__64066__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__64066__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__64067 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__64067,(0),null);
var authority = cljs.core.nth.call(null,vec__64067,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e64070){var e = e64070;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__64073 = arguments.length;
switch (G__64073) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64139){
var state_val_64140 = (state_64139[(1)]);
if((state_val_64140 === (7))){
var inst_64092 = (state_64139[(7)]);
var inst_64093 = (state_64139[(8)]);
var inst_64090 = (state_64139[(9)]);
var inst_64094 = (state_64139[(10)]);
var inst_64095 = (state_64139[(11)]);
var inst_64108 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_64109 = [ledger,txn,inst_64090,inst_64092,inst_64093,inst_64094,inst_64095];
var inst_64110 = cljs.core.PersistentHashMap.fromArrays(inst_64108,inst_64109);
var inst_64111 = fluree.db.util.core.without_nils.call(null,inst_64110);
var inst_64112 = fluree.db.operations.transact_async.call(null,conn,inst_64111);
var state_64139__$1 = state_64139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64139__$1,(13),inst_64112);
} else {
if((state_val_64140 === (20))){
var inst_64130 = (state_64139[(2)]);
var state_64139__$1 = state_64139;
var statearr_64141_64177 = state_64139__$1;
(statearr_64141_64177[(2)] = inst_64130);

(statearr_64141_64177[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (1))){
var state_64139__$1 = state_64139;
var statearr_64142_64178 = state_64139__$1;
(statearr_64142_64178[(2)] = null);

(statearr_64142_64178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (4))){
var inst_64074 = (state_64139[(2)]);
var inst_64075 = fluree.db.util.log.error.call(null,inst_64074);
var inst_64076 = cljs.core.ex_data.call(null,inst_64074);
var inst_64077 = cljs.core.ex_message.call(null,inst_64074);
var inst_64078 = cljs.core.assoc.call(null,inst_64076,new cljs.core.Keyword(null,"message","message",-406056002),inst_64077);
var state_64139__$1 = (function (){var statearr_64143 = state_64139;
(statearr_64143[(12)] = inst_64075);

return statearr_64143;
})();
var statearr_64144_64179 = state_64139__$1;
(statearr_64144_64179[(2)] = inst_64078);

(statearr_64144_64179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (15))){
var inst_64114 = (state_64139[(13)]);
var inst_64089 = (state_64139[(14)]);
var inst_64117 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_64114,inst_64089);
var state_64139__$1 = state_64139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64139__$1,(17),inst_64117);
} else {
if((state_val_64140 === (13))){
var inst_64088 = (state_64139[(15)]);
var inst_64114 = (state_64139[(2)]);
var state_64139__$1 = (function (){var statearr_64145 = state_64139;
(statearr_64145[(13)] = inst_64114);

return statearr_64145;
})();
if(cljs.core.truth_(inst_64088)){
var statearr_64146_64180 = state_64139__$1;
(statearr_64146_64180[(1)] = (14));

} else {
var statearr_64147_64181 = state_64139__$1;
(statearr_64147_64181[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (6))){
var inst_64087 = (state_64139[(16)]);
var inst_64088 = (state_64139[(15)]);
var inst_64097 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_64087,opts);
var inst_64098 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_64097);
var inst_64099 = fluree.db.operations.command_async.call(null,conn,inst_64097);
var state_64139__$1 = (function (){var statearr_64148 = state_64139;
(statearr_64148[(17)] = inst_64098);

(statearr_64148[(18)] = inst_64099);

return statearr_64148;
})();
if(cljs.core.truth_(inst_64088)){
var statearr_64149_64182 = state_64139__$1;
(statearr_64149_64182[(1)] = (9));

} else {
var statearr_64150_64183 = state_64139__$1;
(statearr_64150_64183[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (17))){
var inst_64119 = (state_64139[(19)]);
var inst_64119__$1 = (state_64139[(2)]);
var inst_64120 = (inst_64119__$1 instanceof cljs.core.ExceptionInfo);
var state_64139__$1 = (function (){var statearr_64151 = state_64139;
(statearr_64151[(19)] = inst_64119__$1);

return statearr_64151;
})();
if(cljs.core.truth_(inst_64120)){
var statearr_64152_64184 = state_64139__$1;
(statearr_64152_64184[(1)] = (18));

} else {
var statearr_64153_64185 = state_64139__$1;
(statearr_64153_64185[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (3))){
var inst_64137 = (state_64139[(2)]);
var state_64139__$1 = state_64139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64139__$1,inst_64137);
} else {
if((state_val_64140 === (12))){
var inst_64104 = (state_64139[(2)]);
var state_64139__$1 = state_64139;
var statearr_64154_64186 = state_64139__$1;
(statearr_64154_64186[(2)] = inst_64104);

(statearr_64154_64186[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (2))){
var inst_64087 = (state_64139[(16)]);
var _ = (function (){var statearr_64155 = state_64139;
(statearr_64155[(4)] = cljs.core.cons.call(null,(5),(state_64139[(4)])));

return statearr_64155;
})();
var inst_64085 = opts;
var inst_64086 = cljs.core.__destructure_map.call(null,inst_64085);
var inst_64087__$1 = cljs.core.get.call(null,inst_64086,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_64088 = cljs.core.get.call(null,inst_64086,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_64089 = cljs.core.get.call(null,inst_64086,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_64090 = cljs.core.get.call(null,inst_64086,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64091 = fluree.db.util.core.current_time_millis.call(null);
var inst_64092 = cljs.core.get.call(null,inst_64086,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_64091);
var inst_64093 = cljs.core.get.call(null,inst_64086,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_64094 = cljs.core.get.call(null,inst_64086,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_64095 = cljs.core.get.call(null,inst_64086,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_64139__$1 = (function (){var statearr_64156 = state_64139;
(statearr_64156[(7)] = inst_64092);

(statearr_64156[(16)] = inst_64087__$1);

(statearr_64156[(8)] = inst_64093);

(statearr_64156[(15)] = inst_64088);

(statearr_64156[(9)] = inst_64090);

(statearr_64156[(10)] = inst_64094);

(statearr_64156[(14)] = inst_64089);

(statearr_64156[(11)] = inst_64095);

return statearr_64156;
})();
if(cljs.core.truth_(inst_64087__$1)){
var statearr_64157_64187 = state_64139__$1;
(statearr_64157_64187[(1)] = (6));

} else {
var statearr_64158_64188 = state_64139__$1;
(statearr_64158_64188[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (19))){
var inst_64119 = (state_64139[(19)]);
var state_64139__$1 = state_64139;
var statearr_64159_64189 = state_64139__$1;
(statearr_64159_64189[(2)] = inst_64119);

(statearr_64159_64189[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (11))){
var inst_64106 = (state_64139[(2)]);
var state_64139__$1 = state_64139;
var statearr_64161_64190 = state_64139__$1;
(statearr_64161_64190[(2)] = inst_64106);

(statearr_64161_64190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (9))){
var inst_64099 = (state_64139[(18)]);
var state_64139__$1 = state_64139;
var statearr_64162_64191 = state_64139__$1;
(statearr_64162_64191[(2)] = inst_64099);

(statearr_64162_64191[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (5))){
var _ = (function (){var statearr_64163 = state_64139;
(statearr_64163[(4)] = cljs.core.rest.call(null,(state_64139[(4)])));

return statearr_64163;
})();
var state_64139__$1 = state_64139;
var ex64160 = (state_64139__$1[(2)]);
var statearr_64164_64192 = state_64139__$1;
(statearr_64164_64192[(5)] = ex64160);


var statearr_64165_64193 = state_64139__$1;
(statearr_64165_64193[(1)] = (4));

(statearr_64165_64193[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (14))){
var inst_64114 = (state_64139[(13)]);
var state_64139__$1 = state_64139;
var statearr_64166_64194 = state_64139__$1;
(statearr_64166_64194[(2)] = inst_64114);

(statearr_64166_64194[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (16))){
var inst_64132 = (state_64139[(2)]);
var state_64139__$1 = state_64139;
var statearr_64167_64195 = state_64139__$1;
(statearr_64167_64195[(2)] = inst_64132);

(statearr_64167_64195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (10))){
var inst_64098 = (state_64139[(17)]);
var inst_64089 = (state_64139[(14)]);
var inst_64102 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_64098,inst_64089);
var state_64139__$1 = state_64139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64139__$1,(12),inst_64102);
} else {
if((state_val_64140 === (18))){
var inst_64119 = (state_64139[(19)]);
var inst_64122 = cljs.core.ex_data.call(null,inst_64119);
var inst_64123 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64124 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64122);
var inst_64125 = cljs.core.ex_message.call(null,inst_64119);
var inst_64126 = [inst_64124,inst_64125,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_64127 = cljs.core.PersistentHashMap.fromArrays(inst_64123,inst_64126);
var state_64139__$1 = state_64139;
var statearr_64168_64196 = state_64139__$1;
(statearr_64168_64196[(2)] = inst_64127);

(statearr_64168_64196[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64140 === (8))){
var inst_64134 = (state_64139[(2)]);
var _ = (function (){var statearr_64169 = state_64139;
(statearr_64169[(4)] = cljs.core.rest.call(null,(state_64139[(4)])));

return statearr_64169;
})();
var state_64139__$1 = state_64139;
var statearr_64170_64197 = state_64139__$1;
(statearr_64170_64197[(2)] = inst_64134);

(statearr_64170_64197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_64171 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64171[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_64171[(1)] = (1));

return statearr_64171;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_64139){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64172){var ex__2749__auto__ = e64172;
var statearr_64173_64198 = state_64139;
(statearr_64173_64198[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64139[(4)]))){
var statearr_64174_64199 = state_64139;
(statearr_64174_64199[(1)] = cljs.core.first.call(null,(state_64139[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64200 = state_64139;
state_64139 = G__64200;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_64139){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_64139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64175 = f__2769__auto__.call(null);
(statearr_64175[(6)] = c__2768__auto__);

return statearr_64175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64202 = arguments.length;
var i__5770__auto___64203 = (0);
while(true){
if((i__5770__auto___64203 < len__5769__auto___64202)){
args__5775__auto__.push((arguments[i__5770__auto___64203]));

var G__64204 = (i__5770__auto___64203 + (1));
i__5770__auto___64203 = G__64204;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq64201){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq64201));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64235){
var state_val_64236 = (state_64235[(1)]);
if((state_val_64236 === (1))){
var inst_64205 = cljs.core.first.call(null,flakes);
var inst_64206 = cljs.core.rest.call(null,flakes);
var inst_64207 = cljs.core.PersistentVector.EMPTY;
var inst_64208 = inst_64205;
var inst_64209 = inst_64206;
var inst_64210 = inst_64207;
var state_64235__$1 = (function (){var statearr_64237 = state_64235;
(statearr_64237[(7)] = inst_64210);

(statearr_64237[(8)] = inst_64208);

(statearr_64237[(9)] = inst_64209);

return statearr_64237;
})();
var statearr_64238_64251 = state_64235__$1;
(statearr_64238_64251[(2)] = null);

(statearr_64238_64251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64236 === (2))){
var inst_64208 = (state_64235[(8)]);
var inst_64212 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_64213 = cljs.core.PersistentHashMap.EMPTY;
var inst_64214 = [true,inst_64213];
var inst_64215 = cljs.core.PersistentHashMap.fromArrays(inst_64212,inst_64214);
var inst_64216 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_64215,inst_64208);
var state_64235__$1 = state_64235;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64235__$1,(4),inst_64216);
} else {
if((state_val_64236 === (3))){
var inst_64233 = (state_64235[(2)]);
var state_64235__$1 = state_64235;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64235__$1,inst_64233);
} else {
if((state_val_64236 === (4))){
var inst_64210 = (state_64235[(7)]);
var inst_64209 = (state_64235[(9)]);
var inst_64218 = (state_64235[(2)]);
var inst_64219 = fluree.db.util.async.throw_err.call(null,inst_64218);
var inst_64220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64221 = [inst_64219];
var inst_64222 = (new cljs.core.PersistentVector(null,1,(5),inst_64220,inst_64221,null));
var inst_64223 = cljs.core.concat.call(null,inst_64210,inst_64222);
var inst_64224 = cljs.core.first.call(null,inst_64209);
var state_64235__$1 = (function (){var statearr_64239 = state_64235;
(statearr_64239[(10)] = inst_64223);

return statearr_64239;
})();
if(cljs.core.truth_(inst_64224)){
var statearr_64240_64252 = state_64235__$1;
(statearr_64240_64252[(1)] = (5));

} else {
var statearr_64241_64253 = state_64235__$1;
(statearr_64241_64253[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64236 === (5))){
var inst_64209 = (state_64235[(9)]);
var inst_64223 = (state_64235[(10)]);
var inst_64226 = cljs.core.first.call(null,inst_64209);
var inst_64227 = cljs.core.rest.call(null,inst_64209);
var inst_64208 = inst_64226;
var inst_64209__$1 = inst_64227;
var inst_64210 = inst_64223;
var state_64235__$1 = (function (){var statearr_64242 = state_64235;
(statearr_64242[(7)] = inst_64210);

(statearr_64242[(8)] = inst_64208);

(statearr_64242[(9)] = inst_64209__$1);

return statearr_64242;
})();
var statearr_64243_64254 = state_64235__$1;
(statearr_64243_64254[(2)] = null);

(statearr_64243_64254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64236 === (6))){
var inst_64223 = (state_64235[(10)]);
var state_64235__$1 = state_64235;
var statearr_64244_64255 = state_64235__$1;
(statearr_64244_64255[(2)] = inst_64223);

(statearr_64244_64255[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64236 === (7))){
var inst_64231 = (state_64235[(2)]);
var state_64235__$1 = state_64235;
var statearr_64245_64256 = state_64235__$1;
(statearr_64245_64256[(2)] = inst_64231);

(statearr_64245_64256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_64246 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64246[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__);

(statearr_64246[(1)] = (1));

return statearr_64246;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1 = (function (state_64235){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64235);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64247){var ex__2749__auto__ = e64247;
var statearr_64248_64257 = state_64235;
(statearr_64248_64257[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64235[(4)]))){
var statearr_64249_64258 = state_64235;
(statearr_64249_64258[(1)] = cljs.core.first.call(null,(state_64235[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64259 = state_64235;
state_64235 = G__64259;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = function(state_64235){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1.call(this,state_64235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64250 = f__2769__auto__.call(null);
(statearr_64250[(6)] = c__2768__auto__);

return statearr_64250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64327){
var state_val_64328 = (state_64327[(1)]);
if((state_val_64328 === (7))){
var inst_64287 = (state_64327[(2)]);
var inst_64288 = fluree.db.util.async.throw_err.call(null,inst_64287);
var state_64327__$1 = state_64327;
var statearr_64329_64355 = state_64327__$1;
(statearr_64329_64355[(2)] = inst_64288);

(statearr_64329_64355[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (1))){
var inst_64264 = cljs.core.volatile_BANG_.call(null,(0));
var inst_64265 = cljs.core.PersistentHashMap.EMPTY;
var inst_64266 = cljs.core.volatile_BANG_.call(null,inst_64265);
var inst_64267 = cljs.core.first.call(null,resp);
var inst_64268 = cljs.core.rest.call(null,resp);
var inst_64269 = cljs.core.PersistentVector.EMPTY;
var inst_64270 = inst_64264;
var inst_64271 = inst_64266;
var inst_64272 = inst_64267;
var inst_64273 = inst_64268;
var inst_64274 = inst_64269;
var state_64327__$1 = (function (){var statearr_64330 = state_64327;
(statearr_64330[(7)] = inst_64271);

(statearr_64330[(8)] = inst_64272);

(statearr_64330[(9)] = inst_64274);

(statearr_64330[(10)] = inst_64270);

(statearr_64330[(11)] = inst_64273);

return statearr_64330;
})();
var statearr_64331_64356 = state_64327__$1;
(statearr_64331_64356[(2)] = null);

(statearr_64331_64356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (4))){
var inst_64271 = (state_64327[(7)]);
var inst_64276 = (state_64327[(12)]);
var inst_64278 = (state_64327[(13)]);
var inst_64272 = (state_64327[(8)]);
var inst_64274 = (state_64327[(9)]);
var inst_64270 = (state_64327[(10)]);
var inst_64273 = (state_64327[(11)]);
var inst_64282 = (function (){var fuel = inst_64270;
var cache = inst_64271;
var curr_block = inst_64272;
var rest_blocks = inst_64273;
var acc = inst_64274;
var flakes = inst_64276;
var asserted = inst_64278;
return (function (p1__64261_SHARP_){
return p1__64261_SHARP_.s;
});
})();
var inst_64283 = cljs.core.group_by.call(null,inst_64282,inst_64278);
var inst_64284 = cljs.core.vals.call(null,inst_64283);
var inst_64285 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_64271,inst_64270,inst_64284);
var state_64327__$1 = state_64327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64327__$1,(7),inst_64285);
} else {
if((state_val_64328 === (13))){
var inst_64315 = (state_64327[(14)]);
var state_64327__$1 = state_64327;
var statearr_64332_64357 = state_64327__$1;
(statearr_64332_64357[(2)] = inst_64315);

(statearr_64332_64357[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (6))){
var inst_64271 = (state_64327[(7)]);
var inst_64293 = (state_64327[(15)]);
var inst_64291 = (state_64327[(16)]);
var inst_64276 = (state_64327[(12)]);
var inst_64278 = (state_64327[(13)]);
var inst_64272 = (state_64327[(8)]);
var inst_64274 = (state_64327[(9)]);
var inst_64270 = (state_64327[(10)]);
var inst_64273 = (state_64327[(11)]);
var inst_64291__$1 = (state_64327[(2)]);
var inst_64292 = (function (){var fuel = inst_64270;
var cache = inst_64271;
var curr_block = inst_64272;
var rest_blocks = inst_64273;
var acc = inst_64274;
var flakes = inst_64276;
var asserted = inst_64278;
var asserted_SINGLEQUOTE_ = inst_64291__$1;
return (function (p1__64262_SHARP_){
return p1__64262_SHARP_.op === false;
});
})();
var inst_64293__$1 = cljs.core.filter.call(null,inst_64292,inst_64276);
var inst_64294 = cljs.core.empty_QMARK_.call(null,inst_64293__$1);
var inst_64295 = (!(inst_64294));
var state_64327__$1 = (function (){var statearr_64335 = state_64327;
(statearr_64335[(15)] = inst_64293__$1);

(statearr_64335[(16)] = inst_64291__$1);

return statearr_64335;
})();
if(inst_64295){
var statearr_64336_64358 = state_64327__$1;
(statearr_64336_64358[(1)] = (8));

} else {
var statearr_64337_64359 = state_64327__$1;
(statearr_64337_64359[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (3))){
var inst_64325 = (state_64327[(2)]);
var state_64327__$1 = state_64327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64327__$1,inst_64325);
} else {
if((state_val_64328 === (12))){
var inst_64271 = (state_64327[(7)]);
var inst_64270 = (state_64327[(10)]);
var inst_64315 = (state_64327[(14)]);
var inst_64273 = (state_64327[(11)]);
var inst_64318 = cljs.core.first.call(null,inst_64273);
var inst_64319 = cljs.core.rest.call(null,inst_64273);
var tmp64333 = inst_64271;
var tmp64334 = inst_64270;
var inst_64270__$1 = tmp64334;
var inst_64271__$1 = tmp64333;
var inst_64272 = inst_64318;
var inst_64273__$1 = inst_64319;
var inst_64274 = inst_64315;
var state_64327__$1 = (function (){var statearr_64338 = state_64327;
(statearr_64338[(7)] = inst_64271__$1);

(statearr_64338[(8)] = inst_64272);

(statearr_64338[(9)] = inst_64274);

(statearr_64338[(10)] = inst_64270__$1);

(statearr_64338[(11)] = inst_64273__$1);

return statearr_64338;
})();
var statearr_64339_64360 = state_64327__$1;
(statearr_64339_64360[(2)] = null);

(statearr_64339_64360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (2))){
var inst_64271 = (state_64327[(7)]);
var inst_64276 = (state_64327[(12)]);
var inst_64278 = (state_64327[(13)]);
var inst_64272 = (state_64327[(8)]);
var inst_64274 = (state_64327[(9)]);
var inst_64270 = (state_64327[(10)]);
var inst_64273 = (state_64327[(11)]);
var inst_64276__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_64272);
var inst_64277 = (function (){var fuel = inst_64270;
var cache = inst_64271;
var curr_block = inst_64272;
var rest_blocks = inst_64273;
var acc = inst_64274;
var flakes = inst_64276__$1;
return (function (p1__64260_SHARP_){
return p1__64260_SHARP_.op;
});
})();
var inst_64278__$1 = cljs.core.filter.call(null,inst_64277,inst_64276__$1);
var inst_64279 = cljs.core.empty_QMARK_.call(null,inst_64278__$1);
var inst_64280 = (!(inst_64279));
var state_64327__$1 = (function (){var statearr_64340 = state_64327;
(statearr_64340[(12)] = inst_64276__$1);

(statearr_64340[(13)] = inst_64278__$1);

return statearr_64340;
})();
if(inst_64280){
var statearr_64341_64361 = state_64327__$1;
(statearr_64341_64361[(1)] = (4));

} else {
var statearr_64342_64362 = state_64327__$1;
(statearr_64342_64362[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (11))){
var inst_64303 = (state_64327[(2)]);
var inst_64304 = fluree.db.util.async.throw_err.call(null,inst_64303);
var state_64327__$1 = state_64327;
var statearr_64343_64363 = state_64327__$1;
(statearr_64343_64363[(2)] = inst_64304);

(statearr_64343_64363[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (9))){
var state_64327__$1 = state_64327;
var statearr_64344_64364 = state_64327__$1;
(statearr_64344_64364[(2)] = null);

(statearr_64344_64364[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (5))){
var state_64327__$1 = state_64327;
var statearr_64345_64365 = state_64327__$1;
(statearr_64345_64365[(2)] = null);

(statearr_64345_64365[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (14))){
var inst_64323 = (state_64327[(2)]);
var state_64327__$1 = state_64327;
var statearr_64346_64366 = state_64327__$1;
(statearr_64346_64366[(2)] = inst_64323);

(statearr_64346_64366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (10))){
var inst_64291 = (state_64327[(16)]);
var inst_64272 = (state_64327[(8)]);
var inst_64274 = (state_64327[(9)]);
var inst_64273 = (state_64327[(11)]);
var inst_64307 = (state_64327[(2)]);
var inst_64308 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_64309 = [inst_64291,inst_64307];
var inst_64310 = cljs.core.PersistentHashMap.fromArrays(inst_64308,inst_64309);
var inst_64311 = cljs.core.assoc.call(null,inst_64272,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_64310);
var inst_64312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64313 = [inst_64311];
var inst_64314 = (new cljs.core.PersistentVector(null,1,(5),inst_64312,inst_64313,null));
var inst_64315 = cljs.core.concat.call(null,inst_64274,inst_64314);
var inst_64316 = cljs.core.first.call(null,inst_64273);
var state_64327__$1 = (function (){var statearr_64347 = state_64327;
(statearr_64347[(14)] = inst_64315);

return statearr_64347;
})();
if(cljs.core.truth_(inst_64316)){
var statearr_64348_64367 = state_64327__$1;
(statearr_64348_64367[(1)] = (12));

} else {
var statearr_64349_64368 = state_64327__$1;
(statearr_64349_64368[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64328 === (8))){
var inst_64271 = (state_64327[(7)]);
var inst_64293 = (state_64327[(15)]);
var inst_64291 = (state_64327[(16)]);
var inst_64276 = (state_64327[(12)]);
var inst_64278 = (state_64327[(13)]);
var inst_64272 = (state_64327[(8)]);
var inst_64274 = (state_64327[(9)]);
var inst_64270 = (state_64327[(10)]);
var inst_64273 = (state_64327[(11)]);
var inst_64297 = (function (){var flakes = inst_64276;
var rest_blocks = inst_64273;
var curr_block = inst_64272;
var asserted_SINGLEQUOTE_ = inst_64291;
var acc = inst_64274;
var fuel = inst_64270;
var cache = inst_64271;
var retracted = inst_64293;
var asserted = inst_64278;
return (function (p1__64263_SHARP_){
return p1__64263_SHARP_.s;
});
})();
var inst_64298 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_64293);
var inst_64299 = cljs.core.group_by.call(null,inst_64297,inst_64298);
var inst_64300 = cljs.core.vals.call(null,inst_64299);
var inst_64301 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_64271,inst_64270,inst_64300);
var state_64327__$1 = state_64327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64327__$1,(11),inst_64301);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_64350 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64350[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_64350[(1)] = (1));

return statearr_64350;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_64327){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64351){var ex__2749__auto__ = e64351;
var statearr_64352_64369 = state_64327;
(statearr_64352_64369[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64327[(4)]))){
var statearr_64353_64370 = state_64327;
(statearr_64353_64370[(1)] = cljs.core.first.call(null,(state_64327[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64371 = state_64327;
state_64327 = G__64371;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_64327){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_64327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64354 = f__2769__auto__.call(null);
(statearr_64354[(6)] = c__2768__auto__);

return statearr_64354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64471){
var state_val_64472 = (state_64471[(1)]);
if((state_val_64472 === (7))){
var inst_64436 = (state_64471[(7)]);
var inst_64443 = (state_64471[(8)]);
var inst_64442 = cljs.core.seq.call(null,inst_64436);
var inst_64443__$1 = cljs.core.first.call(null,inst_64442);
var inst_64444 = cljs.core.next.call(null,inst_64442);
var state_64471__$1 = (function (){var statearr_64473 = state_64471;
(statearr_64473[(9)] = inst_64444);

(statearr_64473[(8)] = inst_64443__$1);

return statearr_64473;
})();
if(cljs.core.truth_(inst_64443__$1)){
var statearr_64474_64511 = state_64471__$1;
(statearr_64474_64511[(1)] = (9));

} else {
var statearr_64475_64512 = state_64471__$1;
(statearr_64475_64512[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64472 === (1))){
var state_64471__$1 = state_64471;
var statearr_64476_64513 = state_64471__$1;
(statearr_64476_64513[(2)] = null);

(statearr_64476_64513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64472 === (4))){
var inst_64373 = (state_64471[(2)]);
var state_64471__$1 = state_64471;
var statearr_64477_64514 = state_64471__$1;
(statearr_64477_64514[(2)] = inst_64373);

(statearr_64477_64514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64472 === (6))){
var inst_64422 = (state_64471[(2)]);
var inst_64423 = fluree.db.util.async.throw_err.call(null,inst_64422);
var inst_64431 = resp;
var inst_64432 = cljs.core.seq.call(null,inst_64431);
var inst_64433 = cljs.core.first.call(null,inst_64432);
var inst_64434 = cljs.core.next.call(null,inst_64432);
var inst_64435 = cljs.core.PersistentHashMap.EMPTY;
var inst_64436 = inst_64431;
var inst_64437 = inst_64435;
var state_64471__$1 = (function (){var statearr_64478 = state_64471;
(statearr_64478[(10)] = inst_64433);

(statearr_64478[(11)] = inst_64423);

(statearr_64478[(7)] = inst_64436);

(statearr_64478[(12)] = inst_64434);

(statearr_64478[(13)] = inst_64437);

return statearr_64478;
})();
var statearr_64479_64515 = state_64471__$1;
(statearr_64479_64515[(2)] = null);

(statearr_64479_64515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64472 === (3))){
var inst_64469 = (state_64471[(2)]);
var state_64471__$1 = state_64471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64471__$1,inst_64469);
} else {
if((state_val_64472 === (2))){
var _ = (function (){var statearr_64480 = state_64471;
(statearr_64480[(4)] = cljs.core.cons.call(null,(5),(state_64471[(4)])));

return statearr_64480;
})();
var inst_64379 = (function (){return (function (p1__64372_SHARP_){
return p1__64372_SHARP_.t;
});
})();
var inst_64380 = cljs.core.map.call(null,inst_64379,resp);
var inst_64381 = cljs.core.set.call(null,inst_64380);
var inst_64418 = cljs.core.async.chan.call(null,(1));
var inst_64419 = (function (){var ts = inst_64381;
var c__2768__auto____$1 = inst_64418;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64416){
var state_val_64417 = (state_64416[(1)]);
if((state_val_64417 === (1))){
var inst_64389 = ts;
var inst_64390 = cljs.core.seq.call(null,inst_64389);
var inst_64391 = cljs.core.first.call(null,inst_64390);
var inst_64392 = cljs.core.next.call(null,inst_64390);
var inst_64393 = cljs.core.PersistentHashMap.EMPTY;
var inst_64394 = inst_64389;
var inst_64395 = inst_64393;
var state_64416__$1 = (function (){var statearr_64481 = state_64416;
(statearr_64481[(7)] = inst_64394);

(statearr_64481[(8)] = inst_64391);

(statearr_64481[(9)] = inst_64392);

(statearr_64481[(10)] = inst_64395);

return statearr_64481;
})();
var statearr_64482_64516 = state_64416__$1;
(statearr_64482_64516[(2)] = null);

(statearr_64482_64516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (2))){
var inst_64401 = (state_64416[(11)]);
var inst_64394 = (state_64416[(7)]);
var inst_64400 = cljs.core.seq.call(null,inst_64394);
var inst_64401__$1 = cljs.core.first.call(null,inst_64400);
var inst_64402 = cljs.core.next.call(null,inst_64400);
var state_64416__$1 = (function (){var statearr_64483 = state_64416;
(statearr_64483[(11)] = inst_64401__$1);

(statearr_64483[(12)] = inst_64402);

return statearr_64483;
})();
if(cljs.core.truth_(inst_64401__$1)){
var statearr_64484_64517 = state_64416__$1;
(statearr_64484_64517[(1)] = (4));

} else {
var statearr_64485_64518 = state_64416__$1;
(statearr_64485_64518[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (3))){
var inst_64414 = (state_64416[(2)]);
var state_64416__$1 = state_64416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64416__$1,inst_64414);
} else {
if((state_val_64417 === (4))){
var inst_64401 = (state_64416[(11)]);
var inst_64404 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_64401);
var state_64416__$1 = state_64416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64416__$1,(7),inst_64404);
} else {
if((state_val_64417 === (5))){
var inst_64395 = (state_64416[(10)]);
var state_64416__$1 = state_64416;
var statearr_64486_64519 = state_64416__$1;
(statearr_64486_64519[(2)] = inst_64395);

(statearr_64486_64519[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (6))){
var inst_64412 = (state_64416[(2)]);
var state_64416__$1 = state_64416;
var statearr_64487_64520 = state_64416__$1;
(statearr_64487_64520[(2)] = inst_64412);

(statearr_64487_64520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64417 === (7))){
var inst_64401 = (state_64416[(11)]);
var inst_64402 = (state_64416[(12)]);
var inst_64395 = (state_64416[(10)]);
var inst_64406 = (state_64416[(2)]);
var inst_64407 = fluree.db.util.async.throw_err.call(null,inst_64406);
var inst_64408 = cljs.core.assoc.call(null,inst_64395,inst_64401,inst_64407);
var inst_64394 = inst_64402;
var inst_64395__$1 = inst_64408;
var state_64416__$1 = (function (){var statearr_64488 = state_64416;
(statearr_64488[(7)] = inst_64394);

(statearr_64488[(10)] = inst_64395__$1);

return statearr_64488;
})();
var statearr_64489_64521 = state_64416__$1;
(statearr_64489_64521[(2)] = null);

(statearr_64489_64521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_64490 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64490[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_64490[(1)] = (1));

return statearr_64490;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_64416){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64491){var ex__2749__auto__ = e64491;
var statearr_64492_64522 = state_64416;
(statearr_64492_64522[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64416[(4)]))){
var statearr_64493_64523 = state_64416;
(statearr_64493_64523[(1)] = cljs.core.first.call(null,(state_64416[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64524 = state_64416;
state_64416 = G__64524;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_64416){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_64416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64494 = f__2769__auto__.call(null);
(statearr_64494[(6)] = c__2768__auto____$1);

return statearr_64494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_64420 = cljs.core.async.impl.dispatch.run.call(null,inst_64419);
var state_64471__$1 = (function (){var statearr_64495 = state_64471;
(statearr_64495[(14)] = inst_64420);

return statearr_64495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64471__$1,(6),inst_64418);
} else {
if((state_val_64472 === (11))){
var inst_64463 = (state_64471[(2)]);
var state_64471__$1 = state_64471;
var statearr_64497_64525 = state_64471__$1;
(statearr_64497_64525[(2)] = inst_64463);

(statearr_64497_64525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64472 === (9))){
var inst_64444 = (state_64471[(9)]);
var inst_64423 = (state_64471[(11)]);
var inst_64437 = (state_64471[(13)]);
var inst_64443 = (state_64471[(8)]);
var inst_64446 = inst_64443.t;
var inst_64447 = cljs.core.get.call(null,inst_64423,inst_64446);
var inst_64448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64449 = [inst_64447,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64450 = (new cljs.core.PersistentVector(null,2,(5),inst_64448,inst_64449,null));
var inst_64451 = cljs.core.assoc_in.call(null,inst_64437,inst_64450,inst_64447);
var inst_64452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64453 = [inst_64447,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_64454 = (new cljs.core.PersistentVector(null,2,(5),inst_64452,inst_64453,null));
var inst_64455 = cljs.core.update_in.call(null,inst_64451,inst_64454,cljs.core.conj,inst_64443);
var inst_64456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64457 = [inst_64447,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_64458 = (new cljs.core.PersistentVector(null,2,(5),inst_64456,inst_64457,null));
var inst_64459 = cljs.core.update_in.call(null,inst_64455,inst_64458,fluree.db.api_js.min_safe,inst_64446);
var inst_64436 = inst_64444;
var inst_64437__$1 = inst_64459;
var state_64471__$1 = (function (){var statearr_64498 = state_64471;
(statearr_64498[(7)] = inst_64436);

(statearr_64498[(13)] = inst_64437__$1);

return statearr_64498;
})();
var statearr_64499_64526 = state_64471__$1;
(statearr_64499_64526[(2)] = null);

(statearr_64499_64526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64472 === (5))){
var _ = (function (){var statearr_64500 = state_64471;
(statearr_64500[(4)] = cljs.core.rest.call(null,(state_64471[(4)])));

return statearr_64500;
})();
var state_64471__$1 = state_64471;
var ex64496 = (state_64471__$1[(2)]);
var statearr_64501_64527 = state_64471__$1;
(statearr_64501_64527[(5)] = ex64496);


if((ex64496 instanceof Error)){
var statearr_64502_64528 = state_64471__$1;
(statearr_64502_64528[(1)] = (4));

(statearr_64502_64528[(5)] = null);

} else {
throw ex64496;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64472 === (10))){
var inst_64437 = (state_64471[(13)]);
var state_64471__$1 = state_64471;
var statearr_64503_64529 = state_64471__$1;
(statearr_64503_64529[(2)] = inst_64437);

(statearr_64503_64529[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64472 === (8))){
var inst_64465 = (state_64471[(2)]);
var inst_64466 = cljs.core.vals.call(null,inst_64465);
var _ = (function (){var statearr_64504 = state_64471;
(statearr_64504[(4)] = cljs.core.rest.call(null,(state_64471[(4)])));

return statearr_64504;
})();
var state_64471__$1 = state_64471;
var statearr_64505_64530 = state_64471__$1;
(statearr_64505_64530[(2)] = inst_64466);

(statearr_64505_64530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_64506 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64506[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_64506[(1)] = (1));

return statearr_64506;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_64471){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64507){var ex__2749__auto__ = e64507;
var statearr_64508_64531 = state_64471;
(statearr_64508_64531[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64471[(4)]))){
var statearr_64509_64532 = state_64471;
(statearr_64509_64532[(1)] = cljs.core.first.call(null,(state_64471[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64533 = state_64471;
state_64471 = G__64533;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_64471){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_64471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64510 = f__2769__auto__.call(null);
(statearr_64510[(6)] = c__2768__auto__);

return statearr_64510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64678){
var state_val_64679 = (state_64678[(1)]);
if((state_val_64679 === (7))){
var inst_64558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64559 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64560 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64561 = [inst_64559,inst_64560];
var inst_64562 = (new cljs.core.PersistentVector(null,2,(5),inst_64558,inst_64561,null));
var state_64678__$1 = state_64678;
var statearr_64680_64751 = state_64678__$1;
(statearr_64680_64751[(2)] = inst_64562);

(statearr_64680_64751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (20))){
var inst_64588 = (state_64678[(7)]);
var state_64678__$1 = state_64678;
var statearr_64681_64752 = state_64678__$1;
(statearr_64681_64752[(2)] = inst_64588);

(statearr_64681_64752[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (27))){
var state_64678__$1 = state_64678;
var statearr_64682_64753 = state_64678__$1;
(statearr_64682_64753[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (1))){
var state_64678__$1 = state_64678;
var statearr_64684_64754 = state_64678__$1;
(statearr_64684_64754[(2)] = null);

(statearr_64684_64754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (24))){
var inst_64587 = (state_64678[(8)]);
var state_64678__$1 = state_64678;
if(cljs.core.truth_(inst_64587)){
var statearr_64685_64755 = state_64678__$1;
(statearr_64685_64755[(1)] = (26));

} else {
var statearr_64686_64756 = state_64678__$1;
(statearr_64686_64756[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (39))){
var inst_64634 = (state_64678[(9)]);
var inst_64633 = (state_64678[(10)]);
var inst_64659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64660 = [inst_64633,inst_64634];
var inst_64661 = (new cljs.core.PersistentVector(null,2,(5),inst_64659,inst_64660,null));
var state_64678__$1 = state_64678;
var statearr_64687_64757 = state_64678__$1;
(statearr_64687_64757[(2)] = inst_64661);

(statearr_64687_64757[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (4))){
var inst_64534 = (state_64678[(2)]);
var inst_64535 = fluree.db.util.log.error.call(null,inst_64534);
var inst_64536 = cljs.core.ex_data.call(null,inst_64534);
var inst_64537 = cljs.core.ex_message.call(null,inst_64534);
var inst_64538 = cljs.core.assoc.call(null,inst_64536,new cljs.core.Keyword(null,"message","message",-406056002),inst_64537);
var state_64678__$1 = (function (){var statearr_64688 = state_64678;
(statearr_64688[(11)] = inst_64535);

return statearr_64688;
})();
var statearr_64689_64758 = state_64678__$1;
(statearr_64689_64758[(2)] = inst_64538);

(statearr_64689_64758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (15))){
var inst_64572 = (state_64678[(12)]);
var inst_64567 = (state_64678[(13)]);
var inst_64581 = (state_64678[(2)]);
var inst_64582 = [inst_64572,inst_64581];
var inst_64583 = (new cljs.core.PersistentVector(null,2,(5),inst_64567,inst_64582,null));
var state_64678__$1 = state_64678;
var statearr_64690_64759 = state_64678__$1;
(statearr_64690_64759[(2)] = inst_64583);

(statearr_64690_64759[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (21))){
var inst_64587 = (state_64678[(8)]);
var state_64678__$1 = state_64678;
var statearr_64691_64760 = state_64678__$1;
(statearr_64691_64760[(2)] = inst_64587);

(statearr_64691_64760[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (31))){
var inst_64628 = (state_64678[(2)]);
var state_64678__$1 = state_64678;
var statearr_64692_64761 = state_64678__$1;
(statearr_64692_64761[(2)] = inst_64628);

(statearr_64692_64761[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (32))){
var inst_64634 = (state_64678[(9)]);
var inst_64637 = cljs.core.pos_int_QMARK_.call(null,inst_64634);
var state_64678__$1 = state_64678;
var statearr_64693_64762 = state_64678__$1;
(statearr_64693_64762[(2)] = inst_64637);

(statearr_64693_64762[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (40))){
var inst_64665 = (state_64678[(14)]);
var inst_64589 = (state_64678[(15)]);
var inst_64663 = (state_64678[(2)]);
var inst_64664 = cljs.core.nth.call(null,inst_64663,(0),null);
var inst_64665__$1 = cljs.core.nth.call(null,inst_64663,(1),null);
var inst_64666 = (inst_64665__$1 > inst_64589);
var state_64678__$1 = (function (){var statearr_64694 = state_64678;
(statearr_64694[(16)] = inst_64664);

(statearr_64694[(14)] = inst_64665__$1);

return statearr_64694;
})();
if(cljs.core.truth_(inst_64666)){
var statearr_64695_64763 = state_64678__$1;
(statearr_64695_64763[(1)] = (41));

} else {
var statearr_64696_64764 = state_64678__$1;
(statearr_64696_64764[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (33))){
var inst_64635 = (state_64678[(17)]);
var state_64678__$1 = state_64678;
var statearr_64697_64765 = state_64678__$1;
(statearr_64697_64765[(2)] = inst_64635);

(statearr_64697_64765[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (13))){
var inst_64573 = (state_64678[(18)]);
var inst_64575 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_64573);
var state_64678__$1 = state_64678;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64678__$1,(16),inst_64575);
} else {
if((state_val_64679 === (22))){
var inst_64606 = (state_64678[(2)]);
var state_64678__$1 = state_64678;
if(cljs.core.truth_(inst_64606)){
var statearr_64698_64766 = state_64678__$1;
(statearr_64698_64766[(1)] = (23));

} else {
var statearr_64699_64767 = state_64678__$1;
(statearr_64699_64767[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (36))){
var state_64678__$1 = state_64678;
var statearr_64700_64768 = state_64678__$1;
(statearr_64700_64768[(2)] = null);

(statearr_64700_64768[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (41))){
var inst_64589 = (state_64678[(15)]);
var state_64678__$1 = state_64678;
var statearr_64701_64769 = state_64678__$1;
(statearr_64701_64769[(2)] = inst_64589);

(statearr_64701_64769[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (43))){
var inst_64664 = (state_64678[(16)]);
var inst_64670 = (state_64678[(2)]);
var inst_64671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64672 = [inst_64664,inst_64670];
var inst_64673 = (new cljs.core.PersistentVector(null,2,(5),inst_64671,inst_64672,null));
var _ = (function (){var statearr_64702 = state_64678;
(statearr_64702[(4)] = cljs.core.rest.call(null,(state_64678[(4)])));

return statearr_64702;
})();
var state_64678__$1 = state_64678;
var statearr_64703_64770 = state_64678__$1;
(statearr_64703_64770[(2)] = inst_64673);

(statearr_64703_64770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (29))){
var inst_64564 = (state_64678[(19)]);
var inst_64619 = cljs.core.pr_str.call(null,inst_64564);
var inst_64620 = ["Invalid block range provided: ",inst_64619].join('');
var inst_64621 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64622 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64623 = cljs.core.PersistentHashMap.fromArrays(inst_64621,inst_64622);
var inst_64624 = cljs.core.ex_info.call(null,inst_64620,inst_64623);
var inst_64625 = (function(){throw inst_64624})();
var state_64678__$1 = state_64678;
var statearr_64704_64771 = state_64678__$1;
(statearr_64704_64771[(2)] = inst_64625);

(statearr_64704_64771[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (6))){
var inst_64556 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_64678__$1 = state_64678;
var statearr_64705_64772 = state_64678__$1;
(statearr_64705_64772[(2)] = inst_64556);

(statearr_64705_64772[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (28))){
var inst_64630 = (state_64678[(2)]);
var state_64678__$1 = state_64678;
var statearr_64706_64773 = state_64678__$1;
(statearr_64706_64773[(2)] = inst_64630);

(statearr_64706_64773[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (25))){
var inst_64635 = (state_64678[(17)]);
var inst_64633 = (state_64678[(10)]);
var inst_64632 = (state_64678[(2)]);
var inst_64633__$1 = cljs.core.nth.call(null,inst_64632,(0),null);
var inst_64634 = cljs.core.nth.call(null,inst_64632,(1),null);
var inst_64635__$1 = cljs.core.pos_int_QMARK_.call(null,inst_64633__$1);
var state_64678__$1 = (function (){var statearr_64707 = state_64678;
(statearr_64707[(17)] = inst_64635__$1);

(statearr_64707[(9)] = inst_64634);

(statearr_64707[(10)] = inst_64633__$1);

return statearr_64707;
})();
if(inst_64635__$1){
var statearr_64708_64774 = state_64678__$1;
(statearr_64708_64774[(1)] = (32));

} else {
var statearr_64709_64775 = state_64678__$1;
(statearr_64709_64775[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (34))){
var inst_64640 = (state_64678[(2)]);
var inst_64641 = cljs.core.not.call(null,inst_64640);
var state_64678__$1 = state_64678;
if(inst_64641){
var statearr_64710_64776 = state_64678__$1;
(statearr_64710_64776[(1)] = (35));

} else {
var statearr_64711_64777 = state_64678__$1;
(statearr_64711_64777[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (17))){
var inst_64587 = (state_64678[(8)]);
var inst_64589 = (state_64678[(15)]);
var inst_64592 = cljs.core.pr_str.call(null,inst_64587);
var inst_64593 = cljs.core.pr_str.call(null,inst_64589);
var inst_64594 = ["Start block is out of range for this ledger. Start block provided: ",inst_64592,". Database block: ",inst_64593].join('');
var inst_64595 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64596 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64597 = cljs.core.PersistentHashMap.fromArrays(inst_64595,inst_64596);
var inst_64598 = cljs.core.ex_info.call(null,inst_64594,inst_64597);
var inst_64599 = (function(){throw inst_64598})();
var state_64678__$1 = state_64678;
var statearr_64712_64778 = state_64678__$1;
(statearr_64712_64778[(2)] = inst_64599);

(statearr_64712_64778[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (3))){
var inst_64676 = (state_64678[(2)]);
var state_64678__$1 = state_64678;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64678__$1,inst_64676);
} else {
if((state_val_64679 === (12))){
var inst_64573 = (state_64678[(18)]);
var inst_64564 = (state_64678[(19)]);
var inst_64571 = (state_64678[(2)]);
var inst_64572 = fluree.db.util.async.throw_err.call(null,inst_64571);
var inst_64573__$1 = cljs.core.second.call(null,inst_64564);
var state_64678__$1 = (function (){var statearr_64713 = state_64678;
(statearr_64713[(18)] = inst_64573__$1);

(statearr_64713[(12)] = inst_64572);

return statearr_64713;
})();
if(cljs.core.truth_(inst_64573__$1)){
var statearr_64714_64779 = state_64678__$1;
(statearr_64714_64779[(1)] = (13));

} else {
var statearr_64715_64780 = state_64678__$1;
(statearr_64715_64780[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (2))){
var _ = (function (){var statearr_64716 = state_64678;
(statearr_64716[(4)] = cljs.core.cons.call(null,(5),(state_64678[(4)])));

return statearr_64716;
})();
var inst_64553 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64554 = cljs.core.sequential_QMARK_.call(null,inst_64553);
var state_64678__$1 = state_64678;
if(inst_64554){
var statearr_64717_64781 = state_64678__$1;
(statearr_64717_64781[(1)] = (6));

} else {
var statearr_64718_64782 = state_64678__$1;
(statearr_64718_64782[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (23))){
var inst_64588 = (state_64678[(7)]);
var inst_64587 = (state_64678[(8)]);
var inst_64608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64609 = [inst_64587,inst_64588];
var inst_64610 = (new cljs.core.PersistentVector(null,2,(5),inst_64608,inst_64609,null));
var state_64678__$1 = state_64678;
var statearr_64719_64783 = state_64678__$1;
(statearr_64719_64783[(2)] = inst_64610);

(statearr_64719_64783[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (35))){
var inst_64564 = (state_64678[(19)]);
var inst_64643 = cljs.core.pr_str.call(null,inst_64564);
var inst_64644 = ["Invalid block range provided: ",inst_64643].join('');
var inst_64645 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64646 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64647 = cljs.core.PersistentHashMap.fromArrays(inst_64645,inst_64646);
var inst_64648 = cljs.core.ex_info.call(null,inst_64644,inst_64647);
var inst_64649 = (function(){throw inst_64648})();
var state_64678__$1 = state_64678;
var statearr_64720_64784 = state_64678__$1;
(statearr_64720_64784[(2)] = inst_64649);

(statearr_64720_64784[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (19))){
var inst_64587 = (state_64678[(8)]);
var inst_64602 = (state_64678[(2)]);
var state_64678__$1 = (function (){var statearr_64721 = state_64678;
(statearr_64721[(20)] = inst_64602);

return statearr_64721;
})();
if(cljs.core.truth_(inst_64587)){
var statearr_64722_64785 = state_64678__$1;
(statearr_64722_64785[(1)] = (20));

} else {
var statearr_64723_64786 = state_64678__$1;
(statearr_64723_64786[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (11))){
var inst_64587 = (state_64678[(8)]);
var inst_64589 = (state_64678[(15)]);
var inst_64586 = (state_64678[(2)]);
var inst_64587__$1 = cljs.core.nth.call(null,inst_64586,(0),null);
var inst_64588 = cljs.core.nth.call(null,inst_64586,(1),null);
var inst_64589__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64590 = (inst_64587__$1 > inst_64589__$1);
var state_64678__$1 = (function (){var statearr_64725 = state_64678;
(statearr_64725[(7)] = inst_64588);

(statearr_64725[(8)] = inst_64587__$1);

(statearr_64725[(15)] = inst_64589__$1);

return statearr_64725;
})();
if(cljs.core.truth_(inst_64590)){
var statearr_64726_64787 = state_64678__$1;
(statearr_64726_64787[(1)] = (17));

} else {
var statearr_64727_64788 = state_64678__$1;
(statearr_64727_64788[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (9))){
var inst_64564 = (state_64678[(19)]);
var inst_64567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64568 = cljs.core.first.call(null,inst_64564);
var inst_64569 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_64568);
var state_64678__$1 = (function (){var statearr_64728 = state_64678;
(statearr_64728[(13)] = inst_64567);

return statearr_64728;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64678__$1,(12),inst_64569);
} else {
if((state_val_64679 === (5))){
var _ = (function (){var statearr_64729 = state_64678;
(statearr_64729[(4)] = cljs.core.rest.call(null,(state_64678[(4)])));

return statearr_64729;
})();
var state_64678__$1 = state_64678;
var ex64724 = (state_64678__$1[(2)]);
var statearr_64730_64789 = state_64678__$1;
(statearr_64730_64789[(5)] = ex64724);


var statearr_64731_64790 = state_64678__$1;
(statearr_64731_64790[(1)] = (4));

(statearr_64731_64790[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (14))){
var state_64678__$1 = state_64678;
var statearr_64732_64791 = state_64678__$1;
(statearr_64732_64791[(2)] = null);

(statearr_64732_64791[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (26))){
var inst_64587 = (state_64678[(8)]);
var inst_64613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64614 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64615 = [inst_64587,inst_64614];
var inst_64616 = (new cljs.core.PersistentVector(null,2,(5),inst_64613,inst_64615,null));
var state_64678__$1 = state_64678;
var statearr_64733_64792 = state_64678__$1;
(statearr_64733_64792[(2)] = inst_64616);

(statearr_64733_64792[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (16))){
var inst_64577 = (state_64678[(2)]);
var inst_64578 = fluree.db.util.async.throw_err.call(null,inst_64577);
var state_64678__$1 = state_64678;
var statearr_64734_64793 = state_64678__$1;
(statearr_64734_64793[(2)] = inst_64578);

(statearr_64734_64793[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (38))){
var inst_64634 = (state_64678[(9)]);
var inst_64633 = (state_64678[(10)]);
var inst_64655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64656 = [inst_64634,inst_64633];
var inst_64657 = (new cljs.core.PersistentVector(null,2,(5),inst_64655,inst_64656,null));
var state_64678__$1 = state_64678;
var statearr_64735_64794 = state_64678__$1;
(statearr_64735_64794[(2)] = inst_64657);

(statearr_64735_64794[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (30))){
var state_64678__$1 = state_64678;
var statearr_64736_64795 = state_64678__$1;
(statearr_64736_64795[(2)] = null);

(statearr_64736_64795[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (10))){
var inst_64564 = (state_64678[(19)]);
var state_64678__$1 = state_64678;
var statearr_64737_64796 = state_64678__$1;
(statearr_64737_64796[(2)] = inst_64564);

(statearr_64737_64796[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (18))){
var state_64678__$1 = state_64678;
var statearr_64738_64797 = state_64678__$1;
(statearr_64738_64797[(2)] = null);

(statearr_64738_64797[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (42))){
var inst_64665 = (state_64678[(14)]);
var state_64678__$1 = state_64678;
var statearr_64739_64798 = state_64678__$1;
(statearr_64739_64798[(2)] = inst_64665);

(statearr_64739_64798[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (37))){
var inst_64634 = (state_64678[(9)]);
var inst_64633 = (state_64678[(10)]);
var inst_64652 = (state_64678[(2)]);
var inst_64653 = (inst_64634 < inst_64633);
var state_64678__$1 = (function (){var statearr_64740 = state_64678;
(statearr_64740[(21)] = inst_64652);

return statearr_64740;
})();
if(cljs.core.truth_(inst_64653)){
var statearr_64741_64799 = state_64678__$1;
(statearr_64741_64799[(1)] = (38));

} else {
var statearr_64742_64800 = state_64678__$1;
(statearr_64742_64800[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64679 === (8))){
var inst_64564 = (state_64678[(19)]);
var inst_64564__$1 = (state_64678[(2)]);
var inst_64565 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_64564__$1);
var state_64678__$1 = (function (){var statearr_64743 = state_64678;
(statearr_64743[(19)] = inst_64564__$1);

return statearr_64743;
})();
if(cljs.core.truth_(inst_64565)){
var statearr_64744_64801 = state_64678__$1;
(statearr_64744_64801[(1)] = (9));

} else {
var statearr_64745_64802 = state_64678__$1;
(statearr_64745_64802[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_64746 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64746[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__);

(statearr_64746[(1)] = (1));

return statearr_64746;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_64678){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64678);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64747){var ex__2749__auto__ = e64747;
var statearr_64748_64803 = state_64678;
(statearr_64748_64803[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64678[(4)]))){
var statearr_64749_64804 = state_64678;
(statearr_64749_64804[(1)] = cljs.core.first.call(null,(state_64678[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64805 = state_64678;
state_64678 = G__64805;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = function(state_64678){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_64678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64750 = f__2769__auto__.call(null);
(statearr_64750[(6)] = c__2768__auto__);

return statearr_64750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__64807 = arguments.length;
switch (G__64807) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64898){
var state_val_64899 = (state_64898[(1)]);
if((state_val_64899 === (7))){
var inst_64830 = (state_64898[(7)]);
var inst_64833 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_64830);
var state_64898__$1 = state_64898;
var statearr_64900_64951 = state_64898__$1;
(statearr_64900_64951[(2)] = inst_64833);

(statearr_64900_64951[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (20))){
var inst_64869 = (state_64898[(8)]);
var inst_64872 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_64869);
var state_64898__$1 = state_64898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64898__$1,(23),inst_64872);
} else {
if((state_val_64899 === (27))){
var inst_64878 = (state_64898[(9)]);
var inst_64884 = cljs.core.doall.call(null,inst_64878);
var state_64898__$1 = state_64898;
var statearr_64901_64952 = state_64898__$1;
(statearr_64901_64952[(2)] = inst_64884);

(statearr_64901_64952[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (1))){
var state_64898__$1 = state_64898;
var statearr_64902_64953 = state_64898__$1;
(statearr_64902_64953[(2)] = null);

(statearr_64902_64953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (24))){
var inst_64878 = (state_64898[(9)]);
var inst_64881 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_64882 = cljs.core.sequential_QMARK_.call(null,inst_64878);
var state_64898__$1 = (function (){var statearr_64903 = state_64898;
(statearr_64903[(10)] = inst_64881);

return statearr_64903;
})();
if(inst_64882){
var statearr_64904_64954 = state_64898__$1;
(statearr_64904_64954[(1)] = (27));

} else {
var statearr_64905_64955 = state_64898__$1;
(statearr_64905_64955[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (4))){
var inst_64808 = (state_64898[(2)]);
var inst_64809 = fluree.db.util.log.error.call(null,inst_64808);
var inst_64810 = cljs.core.ex_data.call(null,inst_64808);
var inst_64811 = cljs.core.ex_message.call(null,inst_64808);
var inst_64812 = cljs.core.assoc.call(null,inst_64810,new cljs.core.Keyword(null,"message","message",-406056002),inst_64811);
var state_64898__$1 = (function (){var statearr_64906 = state_64898;
(statearr_64906[(11)] = inst_64809);

return statearr_64906;
})();
var statearr_64907_64956 = state_64898__$1;
(statearr_64907_64956[(2)] = inst_64812);

(statearr_64907_64956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (15))){
var inst_64830 = (state_64898[(7)]);
var inst_64843 = (state_64898[(2)]);
var inst_64844 = cljs.core.ex_info.call(null,inst_64843,inst_64830);
var inst_64845 = (function(){throw inst_64844})();
var state_64898__$1 = state_64898;
var statearr_64908_64957 = state_64898__$1;
(statearr_64908_64957[(2)] = inst_64845);

(statearr_64908_64957[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (21))){
var inst_64869 = (state_64898[(8)]);
var state_64898__$1 = state_64898;
var statearr_64909_64958 = state_64898__$1;
(statearr_64909_64958[(2)] = inst_64869);

(statearr_64909_64958[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (13))){
var inst_64838 = (state_64898[(12)]);
var state_64898__$1 = state_64898;
var statearr_64910_64959 = state_64898__$1;
(statearr_64910_64959[(2)] = inst_64838);

(statearr_64910_64959[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (22))){
var inst_64878 = (state_64898[(2)]);
var inst_64879 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_64898__$1 = (function (){var statearr_64911 = state_64898;
(statearr_64911[(9)] = inst_64878);

return statearr_64911;
})();
if(cljs.core.truth_(inst_64879)){
var statearr_64912_64960 = state_64898__$1;
(statearr_64912_64960[(1)] = (24));

} else {
var statearr_64913_64961 = state_64898__$1;
(statearr_64913_64961[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (29))){
var inst_64881 = (state_64898[(10)]);
var inst_64822 = (state_64898[(13)]);
var inst_64887 = (state_64898[(2)]);
var inst_64888 = fluree.db.util.core.response_time_formatted.call(null,inst_64822);
var inst_64889 = [(200),inst_64887,(100),inst_64888];
var inst_64890 = cljs.core.PersistentHashMap.fromArrays(inst_64881,inst_64889);
var state_64898__$1 = state_64898;
var statearr_64914_64962 = state_64898__$1;
(statearr_64914_64962[(2)] = inst_64890);

(statearr_64914_64962[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (6))){
var inst_64830 = (state_64898[(7)]);
var inst_64831 = (state_64898[(14)]);
var inst_64829 = (state_64898[(2)]);
var inst_64830__$1 = fluree.db.util.async.throw_err.call(null,inst_64829);
var inst_64831__$1 = cljs.core.map_QMARK_.call(null,inst_64830__$1);
var state_64898__$1 = (function (){var statearr_64915 = state_64898;
(statearr_64915[(7)] = inst_64830__$1);

(statearr_64915[(14)] = inst_64831__$1);

return statearr_64915;
})();
if(inst_64831__$1){
var statearr_64916_64963 = state_64898__$1;
(statearr_64916_64963[(1)] = (7));

} else {
var statearr_64917_64964 = state_64898__$1;
(statearr_64917_64964[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (28))){
var inst_64878 = (state_64898[(9)]);
var state_64898__$1 = state_64898;
var statearr_64918_64965 = state_64898__$1;
(statearr_64918_64965[(2)] = inst_64878);

(statearr_64918_64965[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (25))){
var inst_64878 = (state_64898[(9)]);
var state_64898__$1 = state_64898;
var statearr_64919_64966 = state_64898__$1;
(statearr_64919_64966[(2)] = inst_64878);

(statearr_64919_64966[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (17))){
var inst_64861 = cljs.core.pr_str.call(null,query_map);
var inst_64862 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_64861].join('');
var inst_64863 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64864 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64865 = cljs.core.PersistentHashMap.fromArrays(inst_64863,inst_64864);
var inst_64866 = cljs.core.ex_info.call(null,inst_64862,inst_64865);
var inst_64867 = (function(){throw inst_64866})();
var state_64898__$1 = state_64898;
var statearr_64920_64967 = state_64898__$1;
(statearr_64920_64967[(2)] = inst_64867);

(statearr_64920_64967[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (3))){
var inst_64896 = (state_64898[(2)]);
var state_64898__$1 = state_64898;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64898__$1,inst_64896);
} else {
if((state_val_64899 === (12))){
var inst_64830 = (state_64898[(7)]);
var inst_64848 = (state_64898[(2)]);
var inst_64849 = cljs.core.nth.call(null,inst_64830,(0),null);
var inst_64850 = cljs.core.nth.call(null,inst_64830,(1),null);
var inst_64851 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_64852 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_64853 = cljs.core.keys.call(null,inst_64852);
var inst_64854 = cljs.core._EQ_.call(null,inst_64851,inst_64853);
var state_64898__$1 = (function (){var statearr_64921 = state_64898;
(statearr_64921[(15)] = inst_64849);

(statearr_64921[(16)] = inst_64850);

(statearr_64921[(17)] = inst_64848);

return statearr_64921;
})();
if(inst_64854){
var statearr_64922_64968 = state_64898__$1;
(statearr_64922_64968[(1)] = (16));

} else {
var statearr_64923_64969 = state_64898__$1;
(statearr_64923_64969[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (2))){
var _ = (function (){var statearr_64924 = state_64898;
(statearr_64924[(4)] = cljs.core.cons.call(null,(5),(state_64898[(4)])));

return statearr_64924;
})();
var inst_64822 = fluree.db.util.core.current_time_millis.call(null);
var inst_64823 = db;
var inst_64824 = cljs.core.__destructure_map.call(null,inst_64823);
var inst_64825 = cljs.core.get.call(null,inst_64824,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_64826 = cljs.core.get.call(null,inst_64824,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_64827 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_64898__$1 = (function (){var statearr_64925 = state_64898;
(statearr_64925[(18)] = inst_64825);

(statearr_64925[(13)] = inst_64822);

(statearr_64925[(19)] = inst_64826);

return statearr_64925;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64898__$1,(6),inst_64827);
} else {
if((state_val_64899 === (23))){
var inst_64874 = (state_64898[(2)]);
var inst_64875 = fluree.db.util.async.throw_err.call(null,inst_64874);
var state_64898__$1 = state_64898;
var statearr_64926_64970 = state_64898__$1;
(statearr_64926_64970[(2)] = inst_64875);

(statearr_64926_64970[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (19))){
var inst_64858 = (state_64898[(2)]);
var inst_64859 = fluree.db.util.async.throw_err.call(null,inst_64858);
var state_64898__$1 = state_64898;
var statearr_64927_64971 = state_64898__$1;
(statearr_64927_64971[(2)] = inst_64859);

(statearr_64927_64971[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (11))){
var state_64898__$1 = state_64898;
var statearr_64929_64972 = state_64898__$1;
(statearr_64929_64972[(2)] = null);

(statearr_64929_64972[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (9))){
var inst_64836 = (state_64898[(2)]);
var state_64898__$1 = state_64898;
if(cljs.core.truth_(inst_64836)){
var statearr_64930_64973 = state_64898__$1;
(statearr_64930_64973[(1)] = (10));

} else {
var statearr_64931_64974 = state_64898__$1;
(statearr_64931_64974[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (5))){
var _ = (function (){var statearr_64932 = state_64898;
(statearr_64932[(4)] = cljs.core.rest.call(null,(state_64898[(4)])));

return statearr_64932;
})();
var state_64898__$1 = state_64898;
var ex64928 = (state_64898__$1[(2)]);
var statearr_64933_64975 = state_64898__$1;
(statearr_64933_64975[(5)] = ex64928);


var statearr_64934_64976 = state_64898__$1;
(statearr_64934_64976[(1)] = (4));

(statearr_64934_64976[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (14))){
var inst_64825 = (state_64898[(18)]);
var inst_64826 = (state_64898[(19)]);
var inst_64841 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64825),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64826)].join('');
var state_64898__$1 = state_64898;
var statearr_64935_64977 = state_64898__$1;
(statearr_64935_64977[(2)] = inst_64841);

(statearr_64935_64977[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (26))){
var inst_64893 = (state_64898[(2)]);
var _ = (function (){var statearr_64936 = state_64898;
(statearr_64936[(4)] = cljs.core.rest.call(null,(state_64898[(4)])));

return statearr_64936;
})();
var state_64898__$1 = state_64898;
var statearr_64937_64978 = state_64898__$1;
(statearr_64937_64978[(2)] = inst_64893);

(statearr_64937_64978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (16))){
var inst_64849 = (state_64898[(15)]);
var inst_64850 = (state_64898[(16)]);
var inst_64856 = fluree.db.query.block.block_range.call(null,db,inst_64849,inst_64850,opts);
var state_64898__$1 = state_64898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64898__$1,(19),inst_64856);
} else {
if((state_val_64899 === (10))){
var inst_64838 = (state_64898[(12)]);
var inst_64830 = (state_64898[(7)]);
var inst_64838__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_64830);
var state_64898__$1 = (function (){var statearr_64938 = state_64898;
(statearr_64938[(12)] = inst_64838__$1);

return statearr_64938;
})();
if(cljs.core.truth_(inst_64838__$1)){
var statearr_64939_64979 = state_64898__$1;
(statearr_64939_64979[(1)] = (13));

} else {
var statearr_64940_64980 = state_64898__$1;
(statearr_64940_64980[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (18))){
var inst_64869 = (state_64898[(2)]);
var inst_64870 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_64898__$1 = (function (){var statearr_64941 = state_64898;
(statearr_64941[(8)] = inst_64869);

return statearr_64941;
})();
if(cljs.core.truth_(inst_64870)){
var statearr_64942_64981 = state_64898__$1;
(statearr_64942_64981[(1)] = (20));

} else {
var statearr_64943_64982 = state_64898__$1;
(statearr_64943_64982[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64899 === (8))){
var inst_64831 = (state_64898[(14)]);
var state_64898__$1 = state_64898;
var statearr_64944_64983 = state_64898__$1;
(statearr_64944_64983[(2)] = inst_64831);

(statearr_64944_64983[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_64945 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64945[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_64945[(1)] = (1));

return statearr_64945;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_64898){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64898);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64946){var ex__2749__auto__ = e64946;
var statearr_64947_64984 = state_64898;
(statearr_64947_64984[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64898[(4)]))){
var statearr_64948_64985 = state_64898;
(statearr_64948_64985[(1)] = cljs.core.first.call(null,(state_64898[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64986 = state_64898;
state_64898 = G__64986;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_64898){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_64898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64949 = f__2769__auto__.call(null);
(statearr_64949[(6)] = c__2768__auto__);

return statearr_64949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__64988 = arguments.length;
switch (G__64988) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65183){
var state_val_65184 = (state_65183[(1)]);
if((state_val_65184 === (62))){
var inst_65181 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65183__$1,inst_65181);
} else {
if((state_val_65184 === (7))){
var inst_65009 = (state_65183[(7)]);
var inst_65019 = cljs.core.not_EQ_.call(null,(1),inst_65009);
var state_65183__$1 = state_65183;
var statearr_65185_65276 = state_65183__$1;
(statearr_65185_65276[(2)] = inst_65019);

(statearr_65185_65276[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (59))){
var inst_65169 = (state_65183[(2)]);
var inst_65170 = fluree.db.util.async.throw_err.call(null,inst_65169);
var state_65183__$1 = state_65183;
var statearr_65186_65277 = state_65183__$1;
(statearr_65186_65277[(2)] = inst_65170);

(statearr_65186_65277[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (20))){
var inst_65085 = (state_65183[(8)]);
var inst_65077 = (state_65183[(9)]);
var inst_65077__$1 = (state_65183[(2)]);
var inst_65078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65079 = cljs.core.get.call(null,inst_65077__$1,(0));
var inst_65080 = cljs.core.get.call(null,inst_65077__$1,(1));
var inst_65081 = cljs.core.get.call(null,inst_65077__$1,(2));
var inst_65082 = cljs.core.get.call(null,inst_65077__$1,(3));
var inst_65083 = [inst_65079,inst_65080,inst_65081,inst_65082];
var inst_65084 = (new cljs.core.PersistentVector(null,4,(5),inst_65078,inst_65083,null));
var inst_65085__$1 = cljs.core.nth.call(null,inst_65084,(0),null);
var inst_65086 = cljs.core.nth.call(null,inst_65084,(1),null);
var inst_65087 = cljs.core.nth.call(null,inst_65084,(2),null);
var inst_65088 = cljs.core.nth.call(null,inst_65084,(3),null);
var inst_65089 = (inst_65085__$1 == null);
var inst_65090 = cljs.core.not.call(null,inst_65089);
var state_65183__$1 = (function (){var statearr_65187 = state_65183;
(statearr_65187[(10)] = inst_65087);

(statearr_65187[(11)] = inst_65086);

(statearr_65187[(8)] = inst_65085__$1);

(statearr_65187[(12)] = inst_65088);

(statearr_65187[(9)] = inst_65077__$1);

return statearr_65187;
})();
if(inst_65090){
var statearr_65188_65278 = state_65183__$1;
(statearr_65188_65278[(1)] = (30));

} else {
var statearr_65189_65279 = state_65183__$1;
(statearr_65189_65279[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (58))){
var inst_65017 = (state_65183[(13)]);
var inst_65173 = (state_65183[(2)]);
var state_65183__$1 = (function (){var statearr_65190 = state_65183;
(statearr_65190[(14)] = inst_65173);

return statearr_65190;
})();
if(cljs.core.truth_(inst_65017)){
var statearr_65191_65280 = state_65183__$1;
(statearr_65191_65280[(1)] = (60));

} else {
var statearr_65192_65281 = state_65183__$1;
(statearr_65192_65281[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (60))){
var inst_65161 = (state_65183[(15)]);
var inst_65173 = (state_65183[(14)]);
var inst_65175 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_65176 = cljs.core.count.call(null,inst_65161);
var inst_65177 = [inst_65173,inst_65176,(200)];
var inst_65178 = cljs.core.PersistentHashMap.fromArrays(inst_65175,inst_65177);
var state_65183__$1 = state_65183;
var statearr_65193_65282 = state_65183__$1;
(statearr_65193_65282[(2)] = inst_65178);

(statearr_65193_65282[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (27))){
var inst_64996 = (state_65183[(16)]);
var inst_65065 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64996)].join('');
var inst_65066 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65067 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65068 = cljs.core.PersistentHashMap.fromArrays(inst_65066,inst_65067);
var inst_65069 = cljs.core.ex_info.call(null,inst_65065,inst_65068);
var inst_65070 = (function(){throw inst_65069})();
var state_65183__$1 = state_65183;
var statearr_65194_65283 = state_65183__$1;
(statearr_65194_65283[(2)] = inst_65070);

(statearr_65194_65283[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (1))){
var inst_64993 = query_map;
var inst_64994 = cljs.core.__destructure_map.call(null,inst_64993);
var inst_64995 = cljs.core.get.call(null,inst_64994,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64996 = cljs.core.get.call(null,inst_64994,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_64997 = cljs.core.get.call(null,inst_64994,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_65183__$1 = (function (){var statearr_65195 = state_65183;
(statearr_65195[(17)] = inst_64995);

(statearr_65195[(16)] = inst_64996);

(statearr_65195[(18)] = inst_64997);

return statearr_65195;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65183__$1,(2),sources);
} else {
if((state_val_65184 === (24))){
var inst_64996 = (state_65183[(16)]);
var inst_65054 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64996)].join('');
var inst_65055 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65056 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65057 = cljs.core.PersistentHashMap.fromArrays(inst_65055,inst_65056);
var inst_65058 = cljs.core.ex_info.call(null,inst_65054,inst_65057);
var inst_65059 = (function(){throw inst_65058})();
var state_65183__$1 = state_65183;
var statearr_65196_65284 = state_65183__$1;
(statearr_65196_65284[(2)] = inst_65059);

(statearr_65196_65284[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (55))){
var inst_64997 = (state_65183[(18)]);
var inst_65164 = (state_65183[(2)]);
var inst_65165 = fluree.db.util.async.throw_err.call(null,inst_65164);
var state_65183__$1 = (function (){var statearr_65197 = state_65183;
(statearr_65197[(19)] = inst_65165);

return statearr_65197;
})();
if(cljs.core.truth_(inst_64997)){
var statearr_65198_65285 = state_65183__$1;
(statearr_65198_65285[(1)] = (56));

} else {
var statearr_65199_65286 = state_65183__$1;
(statearr_65199_65286[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (39))){
var inst_65087 = (state_65183[(10)]);
var inst_65086 = (state_65183[(11)]);
var inst_65085 = (state_65183[(8)]);
var inst_65088 = (state_65183[(12)]);
var inst_65109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65111 = [inst_65086,inst_65085,inst_65087,inst_65088];
var inst_65112 = (new cljs.core.PersistentVector(null,4,(5),inst_65110,inst_65111,null));
var inst_65113 = [inst_65112,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_65114 = (new cljs.core.PersistentVector(null,2,(5),inst_65109,inst_65113,null));
var state_65183__$1 = state_65183;
var statearr_65200_65287 = state_65183__$1;
(statearr_65200_65287[(2)] = inst_65114);

(statearr_65200_65287[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (46))){
var inst_65119 = (state_65183[(20)]);
var state_65183__$1 = state_65183;
var statearr_65201_65288 = state_65183__$1;
(statearr_65201_65288[(2)] = inst_65119);

(statearr_65201_65288[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (4))){
var state_65183__$1 = state_65183;
var statearr_65202_65289 = state_65183__$1;
(statearr_65202_65289[(2)] = null);

(statearr_65202_65289[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (54))){
var inst_65161 = (state_65183[(15)]);
var inst_65000 = (state_65183[(21)]);
var inst_65160 = (state_65183[(2)]);
var inst_65161__$1 = fluree.db.util.async.throw_err.call(null,inst_65160);
var inst_65162 = fluree.db.api_js.format_history_resp.call(null,inst_65000,inst_65161__$1);
var state_65183__$1 = (function (){var statearr_65203 = state_65183;
(statearr_65203[(15)] = inst_65161__$1);

return statearr_65203;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65183__$1,(55),inst_65162);
} else {
if((state_val_65184 === (15))){
var inst_65000 = (state_65183[(21)]);
var inst_65041 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65000);
var state_65183__$1 = state_65183;
var statearr_65204_65290 = state_65183__$1;
(statearr_65204_65290[(2)] = inst_65041);

(statearr_65204_65290[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (48))){
var inst_65087 = (state_65183[(10)]);
var inst_65086 = (state_65183[(11)]);
var inst_65085 = (state_65183[(8)]);
var inst_65088 = (state_65183[(12)]);
var inst_65130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65132 = [inst_65086,inst_65087,inst_65085,inst_65088];
var inst_65133 = (new cljs.core.PersistentVector(null,4,(5),inst_65131,inst_65132,null));
var inst_65134 = [inst_65133,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_65135 = (new cljs.core.PersistentVector(null,2,(5),inst_65130,inst_65134,null));
var state_65183__$1 = state_65183;
var statearr_65205_65291 = state_65183__$1;
(statearr_65205_65291[(2)] = inst_65135);

(statearr_65205_65291[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (50))){
var inst_65148 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
var statearr_65206_65292 = state_65183__$1;
(statearr_65206_65292[(2)] = inst_65148);

(statearr_65206_65292[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (21))){
var inst_64996 = (state_65183[(16)]);
var inst_65052 = cljs.core.empty_QMARK_.call(null,inst_64996);
var state_65183__$1 = state_65183;
if(inst_65052){
var statearr_65207_65293 = state_65183__$1;
(statearr_65207_65293[(1)] = (24));

} else {
var statearr_65208_65294 = state_65183__$1;
(statearr_65208_65294[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (31))){
var inst_65096 = (state_65183[(22)]);
var inst_65085 = (state_65183[(8)]);
var inst_65096__$1 = (inst_65085 == null);
var state_65183__$1 = (function (){var statearr_65209 = state_65183;
(statearr_65209[(22)] = inst_65096__$1);

return statearr_65209;
})();
if(cljs.core.truth_(inst_65096__$1)){
var statearr_65210_65295 = state_65183__$1;
(statearr_65210_65295[(1)] = (33));

} else {
var statearr_65211_65296 = state_65183__$1;
(statearr_65211_65296[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (32))){
var inst_65043 = (state_65183[(23)]);
var inst_65033 = (state_65183[(24)]);
var inst_65000 = (state_65183[(21)]);
var inst_65152 = (state_65183[(2)]);
var inst_65153 = cljs.core.nth.call(null,inst_65152,(0),null);
var inst_65154 = cljs.core.nth.call(null,inst_65152,(1),null);
var inst_65155 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_65156 = [inst_65033,inst_65043];
var inst_65157 = cljs.core.PersistentHashMap.fromArrays(inst_65155,inst_65156);
var inst_65158 = fluree.db.query.range.time_range.call(null,inst_65000,inst_65154,cljs.core._EQ_,inst_65153,inst_65157);
var state_65183__$1 = state_65183;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65183__$1,(54),inst_65158);
} else {
if((state_val_65184 === (40))){
var inst_65085 = (state_65183[(8)]);
var inst_65116 = (state_65183[(25)]);
var inst_65116__$1 = (inst_65085 == null);
var state_65183__$1 = (function (){var statearr_65212 = state_65183;
(statearr_65212[(25)] = inst_65116__$1);

return statearr_65212;
})();
if(cljs.core.truth_(inst_65116__$1)){
var statearr_65213_65297 = state_65183__$1;
(statearr_65213_65297[(1)] = (42));

} else {
var statearr_65214_65298 = state_65183__$1;
(statearr_65214_65298[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (56))){
var inst_65165 = (state_65183[(19)]);
var inst_65000 = (state_65183[(21)]);
var inst_65167 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_65000,inst_65165);
var state_65183__$1 = state_65183;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65183__$1,(59),inst_65167);
} else {
if((state_val_65184 === (33))){
var inst_65099 = (state_65183[(26)]);
var inst_65086 = (state_65183[(11)]);
var inst_65098 = (inst_65086 == null);
var inst_65099__$1 = cljs.core.not.call(null,inst_65098);
var state_65183__$1 = (function (){var statearr_65215 = state_65183;
(statearr_65215[(26)] = inst_65099__$1);

return statearr_65215;
})();
if(inst_65099__$1){
var statearr_65216_65299 = state_65183__$1;
(statearr_65216_65299[(1)] = (36));

} else {
var statearr_65217_65300 = state_65183__$1;
(statearr_65217_65300[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (13))){
var inst_65027 = (state_65183[(2)]);
var inst_65028 = fluree.db.util.async.throw_err.call(null,inst_65027);
var inst_65029 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65028);
var inst_65030 = (inst_65029 - (1));
var state_65183__$1 = state_65183;
var statearr_65218_65301 = state_65183__$1;
(statearr_65218_65301[(2)] = inst_65030);

(statearr_65218_65301[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (22))){
var state_65183__$1 = state_65183;
var statearr_65219_65302 = state_65183__$1;
(statearr_65219_65302[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (36))){
var inst_65087 = (state_65183[(10)]);
var inst_65101 = (inst_65087 == null);
var state_65183__$1 = state_65183;
var statearr_65221_65303 = state_65183__$1;
(statearr_65221_65303[(2)] = inst_65101);

(statearr_65221_65303[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (41))){
var inst_65150 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
var statearr_65222_65304 = state_65183__$1;
(statearr_65222_65304[(2)] = inst_65150);

(statearr_65222_65304[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (43))){
var inst_65116 = (state_65183[(25)]);
var state_65183__$1 = state_65183;
var statearr_65223_65305 = state_65183__$1;
(statearr_65223_65305[(2)] = inst_65116);

(statearr_65223_65305[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (61))){
var inst_65173 = (state_65183[(14)]);
var state_65183__$1 = state_65183;
var statearr_65224_65306 = state_65183__$1;
(statearr_65224_65306[(2)] = inst_65173);

(statearr_65224_65306[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (29))){
var inst_65073 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
var statearr_65225_65307 = state_65183__$1;
(statearr_65225_65307[(2)] = inst_65073);

(statearr_65225_65307[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (44))){
var inst_65128 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
if(cljs.core.truth_(inst_65128)){
var statearr_65226_65308 = state_65183__$1;
(statearr_65226_65308[(1)] = (48));

} else {
var statearr_65227_65309 = state_65183__$1;
(statearr_65227_65309[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (6))){
var inst_65004 = (state_65183[(2)]);
var inst_65005 = fluree.db.util.async.throw_err.call(null,inst_65004);
var state_65183__$1 = state_65183;
var statearr_65228_65310 = state_65183__$1;
(statearr_65228_65310[(2)] = inst_65005);

(statearr_65228_65310[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (28))){
var state_65183__$1 = state_65183;
var statearr_65229_65311 = state_65183__$1;
(statearr_65229_65311[(2)] = null);

(statearr_65229_65311[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (51))){
var inst_64996 = (state_65183[(16)]);
var inst_65138 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64996)].join('');
var inst_65139 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65140 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65141 = cljs.core.PersistentHashMap.fromArrays(inst_65139,inst_65140);
var inst_65142 = cljs.core.ex_info.call(null,inst_65138,inst_65141);
var inst_65143 = (function(){throw inst_65142})();
var state_65183__$1 = state_65183;
var statearr_65230_65312 = state_65183__$1;
(statearr_65230_65312[(2)] = inst_65143);

(statearr_65230_65312[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (25))){
var inst_64996 = (state_65183[(16)]);
var state_65183__$1 = state_65183;
var statearr_65231_65313 = state_65183__$1;
(statearr_65231_65313[(2)] = inst_64996);

(statearr_65231_65313[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (34))){
var inst_65096 = (state_65183[(22)]);
var state_65183__$1 = state_65183;
var statearr_65232_65314 = state_65183__$1;
(statearr_65232_65314[(2)] = inst_65096);

(statearr_65232_65314[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (17))){
var inst_65037 = (state_65183[(2)]);
var inst_65038 = fluree.db.util.async.throw_err.call(null,inst_65037);
var inst_65039 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65038);
var state_65183__$1 = state_65183;
var statearr_65233_65315 = state_65183__$1;
(statearr_65233_65315[(2)] = inst_65039);

(statearr_65233_65315[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (3))){
var inst_65000 = (state_65183[(21)]);
var inst_65002 = fluree.db.api_js.resolve_block_range.call(null,inst_65000,query_map);
var state_65183__$1 = state_65183;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65183__$1,(6),inst_65002);
} else {
if((state_val_65184 === (12))){
var inst_65010 = (state_65183[(27)]);
var inst_65033 = (state_65183[(2)]);
var state_65183__$1 = (function (){var statearr_65234 = state_65183;
(statearr_65234[(24)] = inst_65033);

return statearr_65234;
})();
if(cljs.core.truth_(inst_65010)){
var statearr_65235_65316 = state_65183__$1;
(statearr_65235_65316[(1)] = (14));

} else {
var statearr_65236_65317 = state_65183__$1;
(statearr_65236_65317[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (2))){
var inst_64995 = (state_65183[(17)]);
var inst_64999 = (state_65183[(2)]);
var inst_65000 = fluree.db.util.async.throw_err.call(null,inst_64999);
var state_65183__$1 = (function (){var statearr_65237 = state_65183;
(statearr_65237[(21)] = inst_65000);

return statearr_65237;
})();
if(cljs.core.truth_(inst_64995)){
var statearr_65238_65318 = state_65183__$1;
(statearr_65238_65318[(1)] = (3));

} else {
var statearr_65239_65319 = state_65183__$1;
(statearr_65239_65319[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (23))){
var inst_65075 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
var statearr_65240_65320 = state_65183__$1;
(statearr_65240_65320[(2)] = inst_65075);

(statearr_65240_65320[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (47))){
var inst_65125 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
var statearr_65241_65321 = state_65183__$1;
(statearr_65241_65321[(2)] = inst_65125);

(statearr_65241_65321[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (35))){
var inst_65107 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
if(cljs.core.truth_(inst_65107)){
var statearr_65242_65322 = state_65183__$1;
(statearr_65242_65322[(1)] = (39));

} else {
var statearr_65243_65323 = state_65183__$1;
(statearr_65243_65323[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (19))){
var inst_64996 = (state_65183[(16)]);
var inst_65050 = cljs.core.sequential_QMARK_.call(null,inst_64996);
var state_65183__$1 = state_65183;
if(inst_65050){
var statearr_65244_65324 = state_65183__$1;
(statearr_65244_65324[(1)] = (21));

} else {
var statearr_65245_65325 = state_65183__$1;
(statearr_65245_65325[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (57))){
var inst_65165 = (state_65183[(19)]);
var state_65183__$1 = state_65183;
var statearr_65246_65326 = state_65183__$1;
(statearr_65246_65326[(2)] = inst_65165);

(statearr_65246_65326[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (11))){
var state_65183__$1 = state_65183;
var statearr_65247_65327 = state_65183__$1;
(statearr_65247_65327[(2)] = (-1));

(statearr_65247_65327[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (9))){
var inst_65022 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
if(cljs.core.truth_(inst_65022)){
var statearr_65248_65328 = state_65183__$1;
(statearr_65248_65328[(1)] = (10));

} else {
var statearr_65249_65329 = state_65183__$1;
(statearr_65249_65329[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (5))){
var inst_65009 = (state_65183[(7)]);
var inst_65008 = (state_65183[(2)]);
var inst_65009__$1 = cljs.core.nth.call(null,inst_65008,(0),null);
var inst_65010 = cljs.core.nth.call(null,inst_65008,(1),null);
var inst_65017 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65183__$1 = (function (){var statearr_65250 = state_65183;
(statearr_65250[(13)] = inst_65017);

(statearr_65250[(7)] = inst_65009__$1);

(statearr_65250[(27)] = inst_65010);

return statearr_65250;
})();
if(cljs.core.truth_(inst_65009__$1)){
var statearr_65251_65330 = state_65183__$1;
(statearr_65251_65330[(1)] = (7));

} else {
var statearr_65252_65331 = state_65183__$1;
(statearr_65252_65331[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (14))){
var inst_65000 = (state_65183[(21)]);
var inst_65010 = (state_65183[(27)]);
var inst_65035 = fluree.db.time_travel.as_of_block.call(null,inst_65000,inst_65010);
var state_65183__$1 = state_65183;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65183__$1,(17),inst_65035);
} else {
if((state_val_65184 === (45))){
var inst_65087 = (state_65183[(10)]);
var inst_65121 = (inst_65087 == null);
var inst_65122 = cljs.core.not.call(null,inst_65121);
var state_65183__$1 = state_65183;
var statearr_65253_65332 = state_65183__$1;
(statearr_65253_65332[(2)] = inst_65122);

(statearr_65253_65332[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (53))){
var inst_65146 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
var statearr_65254_65333 = state_65183__$1;
(statearr_65254_65333[(2)] = inst_65146);

(statearr_65254_65333[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (26))){
var inst_65062 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
var statearr_65255_65334 = state_65183__$1;
(statearr_65255_65334[(2)] = inst_65062);

(statearr_65255_65334[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (16))){
var inst_64996 = (state_65183[(16)]);
var inst_65043 = (state_65183[(2)]);
var inst_65044 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_64996);
var state_65183__$1 = (function (){var statearr_65256 = state_65183;
(statearr_65256[(23)] = inst_65043);

return statearr_65256;
})();
if(inst_65044){
var statearr_65257_65335 = state_65183__$1;
(statearr_65257_65335[(1)] = (18));

} else {
var statearr_65258_65336 = state_65183__$1;
(statearr_65258_65336[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (38))){
var inst_65104 = (state_65183[(2)]);
var state_65183__$1 = state_65183;
var statearr_65259_65337 = state_65183__$1;
(statearr_65259_65337[(2)] = inst_65104);

(statearr_65259_65337[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (30))){
var inst_65077 = (state_65183[(9)]);
var inst_65092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65093 = [inst_65077,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_65094 = (new cljs.core.PersistentVector(null,2,(5),inst_65092,inst_65093,null));
var state_65183__$1 = state_65183;
var statearr_65260_65338 = state_65183__$1;
(statearr_65260_65338[(2)] = inst_65094);

(statearr_65260_65338[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (10))){
var inst_65000 = (state_65183[(21)]);
var inst_65009 = (state_65183[(7)]);
var inst_65024 = (inst_65009 - (1));
var inst_65025 = fluree.db.time_travel.as_of_block.call(null,inst_65000,inst_65024);
var state_65183__$1 = state_65183;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65183__$1,(13),inst_65025);
} else {
if((state_val_65184 === (18))){
var inst_64996 = (state_65183[(16)]);
var inst_65046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65047 = [inst_64996];
var inst_65048 = (new cljs.core.PersistentVector(null,1,(5),inst_65046,inst_65047,null));
var state_65183__$1 = state_65183;
var statearr_65261_65339 = state_65183__$1;
(statearr_65261_65339[(2)] = inst_65048);

(statearr_65261_65339[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (52))){
var state_65183__$1 = state_65183;
var statearr_65262_65340 = state_65183__$1;
(statearr_65262_65340[(2)] = null);

(statearr_65262_65340[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (42))){
var inst_65086 = (state_65183[(11)]);
var inst_65119 = (state_65183[(20)]);
var inst_65118 = (inst_65086 == null);
var inst_65119__$1 = cljs.core.not.call(null,inst_65118);
var state_65183__$1 = (function (){var statearr_65263 = state_65183;
(statearr_65263[(20)] = inst_65119__$1);

return statearr_65263;
})();
if(inst_65119__$1){
var statearr_65264_65341 = state_65183__$1;
(statearr_65264_65341[(1)] = (45));

} else {
var statearr_65265_65342 = state_65183__$1;
(statearr_65265_65342[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (37))){
var inst_65099 = (state_65183[(26)]);
var state_65183__$1 = state_65183;
var statearr_65266_65343 = state_65183__$1;
(statearr_65266_65343[(2)] = inst_65099);

(statearr_65266_65343[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (8))){
var inst_65009 = (state_65183[(7)]);
var state_65183__$1 = state_65183;
var statearr_65267_65344 = state_65183__$1;
(statearr_65267_65344[(2)] = inst_65009);

(statearr_65267_65344[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65184 === (49))){
var state_65183__$1 = state_65183;
var statearr_65268_65345 = state_65183__$1;
(statearr_65268_65345[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_65270 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65270[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_65270[(1)] = (1));

return statearr_65270;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_65183){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65183);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65271){var ex__2749__auto__ = e65271;
var statearr_65272_65346 = state_65183;
(statearr_65272_65346[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65183[(4)]))){
var statearr_65273_65347 = state_65183;
(statearr_65273_65347[(1)] = cljs.core.first.call(null,(state_65183[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65348 = state_65183;
state_65183 = G__65348;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_65183){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_65183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65274 = f__2769__auto__.call(null);
(statearr_65274[(6)] = c__2768__auto__);

return statearr_65274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__65356 = arguments.length;
switch (G__65356) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__65349_SHARP_){
return cljs.core.dissoc.call(null,p1__65349_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65445){
var state_val_65446 = (state_65445[(1)]);
if((state_val_65446 === (7))){
var inst_65402 = (state_65445[(7)]);
var inst_65399 = (state_65445[(8)]);
var inst_65396 = (state_65445[(9)]);
var inst_65406 = (state_65445[(10)]);
var inst_65412 = (function (){var responses = inst_65396;
var responses_STAR_ = inst_65399;
var statuses = inst_65402;
var fuel = inst_65406;
return (function (p1__65352_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__65352_SHARP_);
});
})();
var inst_65413 = cljs.core.some.call(null,inst_65412,inst_65402);
var state_65445__$1 = state_65445;
if(cljs.core.truth_(inst_65413)){
var statearr_65447_65495 = state_65445__$1;
(statearr_65447_65495[(1)] = (9));

} else {
var statearr_65448_65496 = state_65445__$1;
(statearr_65448_65496[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (20))){
var inst_65440 = (state_65445[(2)]);
var state_65445__$1 = state_65445;
var statearr_65449_65497 = state_65445__$1;
(statearr_65449_65497[(2)] = inst_65440);

(statearr_65449_65497[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (1))){
var inst_65391 = cljs.core.async.chan.call(null,(1));
var inst_65392 = (function (){var c__2768__auto____$1 = inst_65391;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65389){
var state_val_65390 = (state_65389[(1)]);
if((state_val_65390 === (1))){
var inst_65357 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_65358 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_65359 = cljs.core.assoc.call(null,inst_65358,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_65360 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_65361 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_65362 = cljs.core.PersistentHashMap.EMPTY;
var inst_65363 = inst_65357;
var inst_65364 = inst_65359;
var inst_65365 = inst_65360;
var inst_65366 = inst_65361;
var inst_65367 = inst_65362;
var state_65389__$1 = (function (){var statearr_65450 = state_65389;
(statearr_65450[(7)] = inst_65363);

(statearr_65450[(8)] = inst_65366);

(statearr_65450[(9)] = inst_65365);

(statearr_65450[(10)] = inst_65364);

(statearr_65450[(11)] = inst_65367);

return statearr_65450;
})();
var statearr_65451_65498 = state_65389__$1;
(statearr_65451_65498[(2)] = null);

(statearr_65451_65498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65390 === (2))){
var inst_65364 = (state_65389[(10)]);
var inst_65369 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_65364);
var inst_65370 = cljs.core.merge.call(null,opts,inst_65369);
var inst_65371 = cljs.core.assoc.call(null,inst_65364,new cljs.core.Keyword(null,"opts","opts",155075701),inst_65370);
var inst_65372 = fluree.db.api_js.query_async.call(null,db,inst_65371,db_fn);
var state_65389__$1 = state_65389;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65389__$1,(4),inst_65372);
} else {
if((state_val_65390 === (3))){
var inst_65387 = (state_65389[(2)]);
var state_65389__$1 = state_65389;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65389__$1,inst_65387);
} else {
if((state_val_65390 === (4))){
var inst_65363 = (state_65389[(7)]);
var inst_65365 = (state_65389[(9)]);
var inst_65367 = (state_65389[(11)]);
var inst_65374 = (state_65389[(2)]);
var inst_65375 = cljs.core.assoc.call(null,inst_65367,inst_65363,inst_65374);
var inst_65376 = cljs.core.first.call(null,inst_65365);
var state_65389__$1 = (function (){var statearr_65452 = state_65389;
(statearr_65452[(12)] = inst_65375);

return statearr_65452;
})();
if(cljs.core.truth_(inst_65376)){
var statearr_65453_65499 = state_65389__$1;
(statearr_65453_65499[(1)] = (5));

} else {
var statearr_65454_65500 = state_65389__$1;
(statearr_65454_65500[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65390 === (5))){
var inst_65366 = (state_65389[(8)]);
var inst_65365 = (state_65389[(9)]);
var inst_65375 = (state_65389[(12)]);
var inst_65378 = cljs.core.first.call(null,inst_65365);
var inst_65379 = cljs.core.first.call(null,inst_65366);
var inst_65380 = cljs.core.rest.call(null,inst_65365);
var inst_65381 = cljs.core.rest.call(null,inst_65366);
var inst_65363 = inst_65378;
var inst_65364 = inst_65379;
var inst_65365__$1 = inst_65380;
var inst_65366__$1 = inst_65381;
var inst_65367 = inst_65375;
var state_65389__$1 = (function (){var statearr_65455 = state_65389;
(statearr_65455[(7)] = inst_65363);

(statearr_65455[(8)] = inst_65366__$1);

(statearr_65455[(9)] = inst_65365__$1);

(statearr_65455[(10)] = inst_65364);

(statearr_65455[(11)] = inst_65367);

return statearr_65455;
})();
var statearr_65456_65501 = state_65389__$1;
(statearr_65456_65501[(2)] = null);

(statearr_65456_65501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65390 === (6))){
var inst_65375 = (state_65389[(12)]);
var state_65389__$1 = state_65389;
var statearr_65457_65502 = state_65389__$1;
(statearr_65457_65502[(2)] = inst_65375);

(statearr_65457_65502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65390 === (7))){
var inst_65385 = (state_65389[(2)]);
var state_65389__$1 = state_65389;
var statearr_65458_65503 = state_65389__$1;
(statearr_65458_65503[(2)] = inst_65385);

(statearr_65458_65503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_65459 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65459[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_65459[(1)] = (1));

return statearr_65459;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_65389){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65389);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65460){var ex__2749__auto__ = e65460;
var statearr_65461_65504 = state_65389;
(statearr_65461_65504[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65389[(4)]))){
var statearr_65462_65505 = state_65389;
(statearr_65462_65505[(1)] = cljs.core.first.call(null,(state_65389[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65506 = state_65389;
state_65389 = G__65506;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_65389){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_65389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65463 = f__2769__auto__.call(null);
(statearr_65463[(6)] = c__2768__auto____$1);

return statearr_65463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_65393 = cljs.core.async.impl.dispatch.run.call(null,inst_65392);
var state_65445__$1 = (function (){var statearr_65464 = state_65445;
(statearr_65464[(11)] = inst_65393);

return statearr_65464;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65445__$1,(2),inst_65391);
} else {
if((state_val_65446 === (4))){
var inst_65396 = (state_65445[(9)]);
var state_65445__$1 = state_65445;
var statearr_65465_65507 = state_65445__$1;
(statearr_65465_65507[(2)] = inst_65396);

(statearr_65465_65507[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (15))){
var state_65445__$1 = state_65445;
var statearr_65466_65508 = state_65445__$1;
(statearr_65466_65508[(2)] = (400));

(statearr_65466_65508[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (13))){
var state_65445__$1 = state_65445;
var statearr_65467_65509 = state_65445__$1;
(statearr_65467_65509[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (6))){
var inst_65402 = (state_65445[(7)]);
var inst_65410 = cljs.core.first.call(null,inst_65402);
var state_65445__$1 = state_65445;
var statearr_65469_65510 = state_65445__$1;
(statearr_65469_65510[(2)] = inst_65410);

(statearr_65469_65510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (17))){
var inst_65423 = (state_65445[(2)]);
var state_65445__$1 = state_65445;
var statearr_65470_65511 = state_65445__$1;
(statearr_65470_65511[(2)] = inst_65423);

(statearr_65470_65511[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (3))){
var inst_65402 = (state_65445[(7)]);
var inst_65399 = (state_65445[(8)]);
var inst_65396 = (state_65445[(9)]);
var inst_65406 = (state_65445[(10)]);
var inst_65401 = cljs.core.vals.call(null,inst_65396);
var inst_65402__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65401);
var inst_65403 = (function (){var responses = inst_65396;
var responses_STAR_ = inst_65399;
var statuses = inst_65402__$1;
return (function (p1__65350_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__65350_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_65404 = cljs.core.vals.call(null,inst_65396);
var inst_65405 = cljs.core.map.call(null,inst_65403,inst_65404);
var inst_65406__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_65405);
var inst_65407 = (function (){var responses = inst_65396;
var responses_STAR_ = inst_65399;
var statuses = inst_65402__$1;
var fuel = inst_65406__$1;
return (function (p1__65351_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__65351_SHARP_);
});
})();
var inst_65408 = cljs.core.every_QMARK_.call(null,inst_65407,inst_65402__$1);
var state_65445__$1 = (function (){var statearr_65471 = state_65445;
(statearr_65471[(7)] = inst_65402__$1);

(statearr_65471[(10)] = inst_65406__$1);

return statearr_65471;
})();
if(inst_65408){
var statearr_65472_65512 = state_65445__$1;
(statearr_65472_65512[(1)] = (6));

} else {
var statearr_65473_65513 = state_65445__$1;
(statearr_65473_65513[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (12))){
var state_65445__$1 = state_65445;
var statearr_65474_65514 = state_65445__$1;
(statearr_65474_65514[(2)] = (500));

(statearr_65474_65514[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (2))){
var inst_65396 = (state_65445[(9)]);
var inst_65395 = (state_65445[(2)]);
var inst_65396__$1 = fluree.db.util.async.throw_err.call(null,inst_65395);
var inst_65397 = (function (){var responses = inst_65396__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_65398 = cljs.core.PersistentHashMap.EMPTY;
var inst_65399 = cljs.core.reduce_kv.call(null,inst_65397,inst_65398,inst_65396__$1);
var state_65445__$1 = (function (){var statearr_65475 = state_65445;
(statearr_65475[(8)] = inst_65399);

(statearr_65475[(9)] = inst_65396__$1);

return statearr_65475;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_65476_65515 = state_65445__$1;
(statearr_65476_65515[(1)] = (3));

} else {
var statearr_65477_65516 = state_65445__$1;
(statearr_65477_65516[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (19))){
var inst_65429 = (state_65445[(12)]);
var inst_65399 = (state_65445[(8)]);
var inst_65406 = (state_65445[(10)]);
var inst_65438 = cljs.core.assoc.call(null,inst_65399,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65429,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65406);
var state_65445__$1 = state_65445;
var statearr_65478_65517 = state_65445__$1;
(statearr_65478_65517[(2)] = inst_65438);

(statearr_65478_65517[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (11))){
var inst_65427 = (state_65445[(2)]);
var state_65445__$1 = state_65445;
var statearr_65479_65518 = state_65445__$1;
(statearr_65479_65518[(2)] = inst_65427);

(statearr_65479_65518[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (9))){
var state_65445__$1 = state_65445;
var statearr_65480_65519 = state_65445__$1;
(statearr_65480_65519[(2)] = (207));

(statearr_65480_65519[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (5))){
var inst_65443 = (state_65445[(2)]);
var state_65445__$1 = state_65445;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65445__$1,inst_65443);
} else {
if((state_val_65446 === (14))){
var inst_65425 = (state_65445[(2)]);
var state_65445__$1 = state_65445;
var statearr_65481_65520 = state_65445__$1;
(statearr_65481_65520[(2)] = inst_65425);

(statearr_65481_65520[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (16))){
var state_65445__$1 = state_65445;
var statearr_65482_65521 = state_65445__$1;
(statearr_65482_65521[(2)] = null);

(statearr_65482_65521[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (10))){
var inst_65402 = (state_65445[(7)]);
var inst_65399 = (state_65445[(8)]);
var inst_65396 = (state_65445[(9)]);
var inst_65406 = (state_65445[(10)]);
var inst_65416 = (function (){var responses = inst_65396;
var responses_STAR_ = inst_65399;
var statuses = inst_65402;
var fuel = inst_65406;
return (function (p1__65353_SHARP_){
return ((499) < p1__65353_SHARP_);
});
})();
var inst_65417 = cljs.core.some.call(null,inst_65416,inst_65402);
var state_65445__$1 = state_65445;
if(cljs.core.truth_(inst_65417)){
var statearr_65483_65522 = state_65445__$1;
(statearr_65483_65522[(1)] = (12));

} else {
var statearr_65484_65523 = state_65445__$1;
(statearr_65484_65523[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (18))){
var inst_65429 = (state_65445[(12)]);
var inst_65399 = (state_65445[(8)]);
var inst_65406 = (state_65445[(10)]);
var inst_65434 = (state_65445[(13)]);
var inst_65436 = cljs.core.assoc.call(null,inst_65399,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65429,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65406,new cljs.core.Keyword(null,"block","block",664686210),inst_65434);
var state_65445__$1 = state_65445;
var statearr_65485_65524 = state_65445__$1;
(statearr_65485_65524[(2)] = inst_65436);

(statearr_65485_65524[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65446 === (8))){
var inst_65429 = (state_65445[(12)]);
var inst_65402 = (state_65445[(7)]);
var inst_65399 = (state_65445[(8)]);
var inst_65396 = (state_65445[(9)]);
var inst_65406 = (state_65445[(10)]);
var inst_65434 = (state_65445[(13)]);
var inst_65429__$1 = (state_65445[(2)]);
var inst_65430 = (function (){var responses = inst_65396;
var responses_STAR_ = inst_65399;
var statuses = inst_65402;
var fuel = inst_65406;
var status = inst_65429__$1;
return (function (p1__65354_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__65354_SHARP_));
});
})();
var inst_65431 = cljs.core.vals.call(null,inst_65396);
var inst_65432 = cljs.core.filter.call(null,inst_65430,inst_65431);
var inst_65433 = cljs.core.first.call(null,inst_65432);
var inst_65434__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_65433);
var state_65445__$1 = (function (){var statearr_65486 = state_65445;
(statearr_65486[(12)] = inst_65429__$1);

(statearr_65486[(13)] = inst_65434__$1);

return statearr_65486;
})();
if(cljs.core.truth_(inst_65434__$1)){
var statearr_65487_65525 = state_65445__$1;
(statearr_65487_65525[(1)] = (18));

} else {
var statearr_65488_65526 = state_65445__$1;
(statearr_65488_65526[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_65489 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65489[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_65489[(1)] = (1));

return statearr_65489;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_65445){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65490){var ex__2749__auto__ = e65490;
var statearr_65491_65527 = state_65445;
(statearr_65491_65527[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65445[(4)]))){
var statearr_65492_65528 = state_65445;
(statearr_65492_65528[(1)] = cljs.core.first.call(null,(state_65445[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65529 = state_65445;
state_65445 = G__65529;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_65445){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_65445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65493 = f__2769__auto__.call(null);
(statearr_65493[(6)] = c__2768__auto__);

return statearr_65493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__65531 = arguments.length;
switch (G__65531) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__65532 = opts;
var map__65532__$1 = cljs.core.__destructure_map.call(null,map__65532);
var auth = cljs.core.get.call(null,map__65532__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__65532__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__65532__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__65532__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__65533 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__65533,(0),null);
var authority = cljs.core.nth.call(null,vec__65533,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e65536){var e = e65536;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__65539 = arguments.length;
switch (G__65539) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65570){
var state_val_65571 = (state_65570[(1)]);
if((state_val_65571 === (7))){
var state_65570__$1 = state_65570;
var statearr_65572_65593 = state_65570__$1;
(statearr_65572_65593[(2)] = opts);

(statearr_65572_65593[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65571 === (1))){
var state_65570__$1 = state_65570;
var statearr_65573_65594 = state_65570__$1;
(statearr_65573_65594[(2)] = null);

(statearr_65573_65594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65571 === (4))){
var inst_65540 = (state_65570[(2)]);
var inst_65541 = fluree.db.util.log.error.call(null,inst_65540);
var inst_65542 = cljs.core.ex_data.call(null,inst_65540);
var inst_65543 = cljs.core.ex_message.call(null,inst_65540);
var inst_65544 = cljs.core.assoc.call(null,inst_65542,new cljs.core.Keyword(null,"message","message",-406056002),inst_65543);
var state_65570__$1 = (function (){var statearr_65574 = state_65570;
(statearr_65574[(7)] = inst_65541);

return statearr_65574;
})();
var statearr_65575_65595 = state_65570__$1;
(statearr_65575_65595[(2)] = inst_65544);

(statearr_65575_65595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65571 === (6))){
var inst_65554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65555 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_65556 = (new cljs.core.PersistentVector(null,1,(5),inst_65554,inst_65555,null));
var inst_65557 = cljs.core.assoc_in.call(null,opts,inst_65556,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65570__$1 = state_65570;
var statearr_65576_65596 = state_65570__$1;
(statearr_65576_65596[(2)] = inst_65557);

(statearr_65576_65596[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65571 === (3))){
var inst_65568 = (state_65570[(2)]);
var state_65570__$1 = state_65570;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65570__$1,inst_65568);
} else {
if((state_val_65571 === (2))){
var _ = (function (){var statearr_65578 = state_65570;
(statearr_65578[(4)] = cljs.core.cons.call(null,(5),(state_65570[(4)])));

return statearr_65578;
})();
var inst_65550 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65551 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65552 = (inst_65551 == null);
var state_65570__$1 = (function (){var statearr_65579 = state_65570;
(statearr_65579[(8)] = inst_65550);

return statearr_65579;
})();
if(cljs.core.truth_(inst_65552)){
var statearr_65580_65597 = state_65570__$1;
(statearr_65580_65597[(1)] = (6));

} else {
var statearr_65581_65598 = state_65570__$1;
(statearr_65581_65598[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65571 === (9))){
var inst_65564 = (state_65570[(2)]);
var inst_65565 = fluree.db.util.async.throw_err.call(null,inst_65564);
var _ = (function (){var statearr_65582 = state_65570;
(statearr_65582[(4)] = cljs.core.rest.call(null,(state_65570[(4)])));

return statearr_65582;
})();
var state_65570__$1 = state_65570;
var statearr_65583_65599 = state_65570__$1;
(statearr_65583_65599[(2)] = inst_65565);

(statearr_65583_65599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65571 === (5))){
var _ = (function (){var statearr_65584 = state_65570;
(statearr_65584[(4)] = cljs.core.rest.call(null,(state_65570[(4)])));

return statearr_65584;
})();
var state_65570__$1 = state_65570;
var ex65577 = (state_65570__$1[(2)]);
var statearr_65585_65600 = state_65570__$1;
(statearr_65585_65600[(5)] = ex65577);


var statearr_65586_65601 = state_65570__$1;
(statearr_65586_65601[(1)] = (4));

(statearr_65586_65601[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65571 === (8))){
var inst_65550 = (state_65570[(8)]);
var inst_65560 = (state_65570[(2)]);
var inst_65561 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_65550,inst_65560);
var inst_65562 = fluree.db.operations.command_async.call(null,conn,inst_65561);
var state_65570__$1 = state_65570;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65570__$1,(9),inst_65562);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_65587 = [null,null,null,null,null,null,null,null,null];
(statearr_65587[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_65587[(1)] = (1));

return statearr_65587;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_65570){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65570);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65588){var ex__2749__auto__ = e65588;
var statearr_65589_65602 = state_65570;
(statearr_65589_65602[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65570[(4)]))){
var statearr_65590_65603 = state_65570;
(statearr_65590_65603[(1)] = cljs.core.first.call(null,(state_65570[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65604 = state_65570;
state_65570 = G__65604;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_65570){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_65570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65591 = f__2769__auto__.call(null);
(statearr_65591[(6)] = c__2768__auto__);

return statearr_65591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

