// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__59972 = arguments.length;
switch (G__59972) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___60120 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60059){
var state_val_60060 = (state_60059[(1)]);
if((state_val_60060 === (7))){
var inst_59990 = (state_60059[(7)]);
var inst_59993 = cljs.core.not_EQ_.call(null,(0),inst_59990);
var state_60059__$1 = state_60059;
var statearr_60061_60121 = state_60059__$1;
(statearr_60061_60121[(2)] = inst_59993);

(statearr_60061_60121[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (20))){
var inst_59985 = (state_60059[(8)]);
var inst_60014 = (state_60059[(9)]);
var inst_60018 = fluree.db.auth.roles.call(null,inst_59985,inst_60014);
var state_60059__$1 = state_60059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60059__$1,(23),inst_60018);
} else {
if((state_val_60060 === (27))){
var inst_59985 = (state_60059[(8)]);
var inst_60033 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60034 = fluree.db.time_travel.as_of_block.call(null,inst_59985,inst_60033);
var state_60059__$1 = state_60059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60059__$1,(30),inst_60034);
} else {
if((state_val_60060 === (1))){
var state_60059__$1 = state_60059;
var statearr_60062_60122 = state_60059__$1;
(statearr_60062_60122[(2)] = null);

(statearr_60062_60122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (24))){
var inst_59985 = (state_60059[(8)]);
var inst_60026 = (state_60059[(10)]);
var inst_60028 = fluree.db.permissions.permission_map.call(null,inst_59985,inst_60026,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_60059__$1 = state_60059;
var statearr_60063_60123 = state_60059__$1;
(statearr_60063_60123[(2)] = inst_60028);

(statearr_60063_60123[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (4))){
var inst_59973 = (state_60059[(2)]);
var inst_59974 = cljs.core.async.put_BANG_.call(null,pc,inst_59973);
var inst_59975 = cljs.core.async.close_BANG_.call(null,pc);
var state_60059__$1 = (function (){var statearr_60064 = state_60059;
(statearr_60064[(11)] = inst_59974);

return statearr_60064;
})();
var statearr_60065_60124 = state_60059__$1;
(statearr_60065_60124[(2)] = inst_59975);

(statearr_60065_60124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (15))){
var inst_59990 = (state_60059[(7)]);
var inst_60004 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_59990)," unknown."].join('');
var inst_60005 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60006 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_60007 = cljs.core.PersistentHashMap.fromArrays(inst_60005,inst_60006);
var inst_60008 = cljs.core.ex_info.call(null,inst_60004,inst_60007);
var inst_60009 = (function(){throw inst_60008})();
var state_60059__$1 = state_60059;
var statearr_60066_60125 = state_60059__$1;
(statearr_60066_60125[(2)] = inst_60009);

(statearr_60066_60125[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (21))){
var state_60059__$1 = state_60059;
var statearr_60067_60126 = state_60059__$1;
(statearr_60067_60126[(2)] = null);

(statearr_60067_60126[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (31))){
var inst_59990 = (state_60059[(7)]);
var inst_60040 = (state_60059[(12)]);
var inst_60042 = cljs.core.assoc.call(null,inst_60040,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_59990);
var state_60059__$1 = state_60059;
var statearr_60068_60127 = state_60059__$1;
(statearr_60068_60127[(2)] = inst_60042);

(statearr_60068_60127[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (32))){
var inst_60040 = (state_60059[(12)]);
var state_60059__$1 = state_60059;
var statearr_60069_60128 = state_60059__$1;
(statearr_60069_60128[(2)] = inst_60040);

(statearr_60069_60128[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (33))){
var inst_60026 = (state_60059[(10)]);
var inst_60045 = (state_60059[(2)]);
var state_60059__$1 = (function (){var statearr_60070 = state_60059;
(statearr_60070[(13)] = inst_60045);

return statearr_60070;
})();
if(cljs.core.truth_(inst_60026)){
var statearr_60071_60129 = state_60059__$1;
(statearr_60071_60129[(1)] = (34));

} else {
var statearr_60072_60130 = state_60059__$1;
(statearr_60072_60130[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (13))){
var inst_60001 = (state_60059[(14)]);
var inst_60000 = (state_60059[(2)]);
var inst_60001__$1 = fluree.db.util.async.throw_err.call(null,inst_60000);
var state_60059__$1 = (function (){var statearr_60073 = state_60059;
(statearr_60073[(14)] = inst_60001__$1);

return statearr_60073;
})();
if(cljs.core.truth_(inst_60001__$1)){
var statearr_60074_60131 = state_60059__$1;
(statearr_60074_60131[(1)] = (14));

} else {
var statearr_60075_60132 = state_60059__$1;
(statearr_60075_60132[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (22))){
var inst_60024 = (state_60059[(2)]);
var state_60059__$1 = state_60059;
var statearr_60076_60133 = state_60059__$1;
(statearr_60076_60133[(2)] = inst_60024);

(statearr_60076_60133[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (36))){
var inst_60053 = (state_60059[(2)]);
var inst_60054 = cljs.core.async.put_BANG_.call(null,pc,inst_60053);
var _ = (function (){var statearr_60077 = state_60059;
(statearr_60077[(4)] = cljs.core.rest.call(null,(state_60059[(4)])));

return statearr_60077;
})();
var state_60059__$1 = state_60059;
var statearr_60078_60134 = state_60059__$1;
(statearr_60078_60134[(2)] = inst_60054);

(statearr_60078_60134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (29))){
var inst_59990 = (state_60059[(7)]);
var inst_60040 = (state_60059[(2)]);
var state_60059__$1 = (function (){var statearr_60079 = state_60059;
(statearr_60079[(12)] = inst_60040);

return statearr_60079;
})();
if(cljs.core.truth_(inst_59990)){
var statearr_60080_60135 = state_60059__$1;
(statearr_60080_60135[(1)] = (31));

} else {
var statearr_60081_60136 = state_60059__$1;
(statearr_60081_60136[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (6))){
var inst_59990 = (state_60059[(7)]);
var inst_59984 = (state_60059[(2)]);
var inst_59985 = fluree.db.util.async.throw_err.call(null,inst_59984);
var inst_59986 = opts;
var inst_59987 = cljs.core.__destructure_map.call(null,inst_59986);
var inst_59988 = cljs.core.get.call(null,inst_59987,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_59989 = cljs.core.get.call(null,inst_59987,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_59990__$1 = cljs.core.get.call(null,inst_59987,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_59991 = cljs.core.get.call(null,inst_59987,new cljs.core.Keyword(null,"block","block",664686210));
var state_60059__$1 = (function (){var statearr_60082 = state_60059;
(statearr_60082[(8)] = inst_59985);

(statearr_60082[(15)] = inst_59988);

(statearr_60082[(16)] = inst_59989);

(statearr_60082[(17)] = inst_59991);

(statearr_60082[(7)] = inst_59990__$1);

return statearr_60082;
})();
if(cljs.core.truth_(inst_59990__$1)){
var statearr_60083_60137 = state_60059__$1;
(statearr_60083_60137[(1)] = (7));

} else {
var statearr_60084_60138 = state_60059__$1;
(statearr_60084_60138[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (28))){
var inst_59985 = (state_60059[(8)]);
var state_60059__$1 = state_60059;
var statearr_60085_60139 = state_60059__$1;
(statearr_60085_60139[(2)] = inst_59985);

(statearr_60085_60139[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (25))){
var state_60059__$1 = state_60059;
var statearr_60086_60140 = state_60059__$1;
(statearr_60086_60140[(2)] = null);

(statearr_60086_60140[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (34))){
var inst_60031 = (state_60059[(18)]);
var state_60059__$1 = state_60059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60059__$1,(37),inst_60031);
} else {
if((state_val_60060 === (17))){
var inst_59988 = (state_60059[(15)]);
var state_60059__$1 = state_60059;
var statearr_60087_60141 = state_60059__$1;
(statearr_60087_60141[(2)] = inst_59988);

(statearr_60087_60141[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (3))){
var inst_60057 = (state_60059[(2)]);
var state_60059__$1 = state_60059;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60059__$1,inst_60057);
} else {
if((state_val_60060 === (12))){
var inst_59988 = (state_60059[(15)]);
var inst_60014 = (state_60059[(2)]);
var state_60059__$1 = (function (){var statearr_60088 = state_60059;
(statearr_60088[(9)] = inst_60014);

return statearr_60088;
})();
if(cljs.core.truth_(inst_59988)){
var statearr_60089_60142 = state_60059__$1;
(statearr_60089_60142[(1)] = (17));

} else {
var statearr_60090_60143 = state_60059__$1;
(statearr_60090_60143[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (2))){
var _ = (function (){var statearr_60091 = state_60059;
(statearr_60091[(4)] = cljs.core.cons.call(null,(5),(state_60059[(4)])));

return statearr_60091;
})();
var inst_59982 = fluree.db.session.db.call(null,conn,ledger,null);
var state_60059__$1 = state_60059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60059__$1,(6),inst_59982);
} else {
if((state_val_60060 === (23))){
var inst_60020 = (state_60059[(2)]);
var inst_60021 = fluree.db.util.async.throw_err.call(null,inst_60020);
var state_60059__$1 = state_60059;
var statearr_60092_60144 = state_60059__$1;
(statearr_60092_60144[(2)] = inst_60021);

(statearr_60092_60144[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (35))){
var inst_60045 = (state_60059[(13)]);
var state_60059__$1 = state_60059;
var statearr_60093_60145 = state_60059__$1;
(statearr_60093_60145[(2)] = inst_60045);

(statearr_60093_60145[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (19))){
var inst_60026 = (state_60059[(10)]);
var inst_60026__$1 = (state_60059[(2)]);
var state_60059__$1 = (function (){var statearr_60094 = state_60059;
(statearr_60094[(10)] = inst_60026__$1);

return statearr_60094;
})();
if(cljs.core.truth_(inst_60026__$1)){
var statearr_60095_60146 = state_60059__$1;
(statearr_60095_60146[(1)] = (24));

} else {
var statearr_60096_60147 = state_60059__$1;
(statearr_60096_60147[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (11))){
var state_60059__$1 = state_60059;
var statearr_60098_60148 = state_60059__$1;
(statearr_60098_60148[(2)] = null);

(statearr_60098_60148[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (9))){
var inst_59996 = (state_60059[(2)]);
var state_60059__$1 = state_60059;
if(cljs.core.truth_(inst_59996)){
var statearr_60099_60149 = state_60059__$1;
(statearr_60099_60149[(1)] = (10));

} else {
var statearr_60100_60150 = state_60059__$1;
(statearr_60100_60150[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (5))){
var _ = (function (){var statearr_60101 = state_60059;
(statearr_60101[(4)] = cljs.core.rest.call(null,(state_60059[(4)])));

return statearr_60101;
})();
var state_60059__$1 = state_60059;
var ex60097 = (state_60059__$1[(2)]);
var statearr_60102_60151 = state_60059__$1;
(statearr_60102_60151[(5)] = ex60097);


var statearr_60103_60152 = state_60059__$1;
(statearr_60103_60152[(1)] = (4));

(statearr_60103_60152[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (14))){
var inst_60001 = (state_60059[(14)]);
var state_60059__$1 = state_60059;
var statearr_60104_60153 = state_60059__$1;
(statearr_60104_60153[(2)] = inst_60001);

(statearr_60104_60153[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (26))){
var inst_59991 = (state_60059[(17)]);
var inst_60031 = (state_60059[(2)]);
var state_60059__$1 = (function (){var statearr_60105 = state_60059;
(statearr_60105[(18)] = inst_60031);

return statearr_60105;
})();
if(cljs.core.truth_(inst_59991)){
var statearr_60106_60154 = state_60059__$1;
(statearr_60106_60154[(1)] = (27));

} else {
var statearr_60107_60155 = state_60059__$1;
(statearr_60107_60155[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (16))){
var inst_60011 = (state_60059[(2)]);
var state_60059__$1 = state_60059;
var statearr_60108_60156 = state_60059__$1;
(statearr_60108_60156[(2)] = inst_60011);

(statearr_60108_60156[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (30))){
var inst_60036 = (state_60059[(2)]);
var inst_60037 = fluree.db.util.async.throw_err.call(null,inst_60036);
var state_60059__$1 = state_60059;
var statearr_60109_60157 = state_60059__$1;
(statearr_60109_60157[(2)] = inst_60037);

(statearr_60109_60157[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (10))){
var inst_59985 = (state_60059[(8)]);
var inst_59990 = (state_60059[(7)]);
var inst_59998 = fluree.db.dbproto._subid.call(null,inst_59985,inst_59990);
var state_60059__$1 = state_60059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60059__$1,(13),inst_59998);
} else {
if((state_val_60060 === (18))){
var inst_60014 = (state_60059[(9)]);
var state_60059__$1 = state_60059;
if(cljs.core.truth_(inst_60014)){
var statearr_60110_60158 = state_60059__$1;
(statearr_60110_60158[(1)] = (20));

} else {
var statearr_60111_60159 = state_60059__$1;
(statearr_60111_60159[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (37))){
var inst_60045 = (state_60059[(13)]);
var inst_60048 = (state_60059[(2)]);
var inst_60049 = fluree.db.util.async.throw_err.call(null,inst_60048);
var inst_60050 = cljs.core.assoc.call(null,inst_60045,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_60049);
var state_60059__$1 = state_60059;
var statearr_60112_60160 = state_60059__$1;
(statearr_60112_60160[(2)] = inst_60050);

(statearr_60112_60160[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60060 === (8))){
var inst_59990 = (state_60059[(7)]);
var state_60059__$1 = state_60059;
var statearr_60113_60161 = state_60059__$1;
(statearr_60113_60161[(2)] = inst_59990);

(statearr_60113_60161[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2746__auto__ = null;
var fluree$db$api$query$state_machine__2746__auto____0 = (function (){
var statearr_60114 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60114[(0)] = fluree$db$api$query$state_machine__2746__auto__);

(statearr_60114[(1)] = (1));

return statearr_60114;
});
var fluree$db$api$query$state_machine__2746__auto____1 = (function (state_60059){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60059);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e60115){var ex__2749__auto__ = e60115;
var statearr_60116_60162 = state_60059;
(statearr_60116_60162[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60059[(4)]))){
var statearr_60117_60163 = state_60059;
(statearr_60117_60163[(1)] = cljs.core.first.call(null,(state_60059[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60164 = state_60059;
state_60059 = G__60164;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2746__auto__ = function(state_60059){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2746__auto____1.call(this,state_60059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2746__auto____0;
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2746__auto____1;
return fluree$db$api$query$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_60118 = f__2769__auto__.call(null);
(statearr_60118[(6)] = c__2768__auto___60120);

return statearr_60118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60305){
var state_val_60306 = (state_60305[(1)]);
if((state_val_60306 === (7))){
var inst_60185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60186 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60187 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60188 = [inst_60186,inst_60187];
var inst_60189 = (new cljs.core.PersistentVector(null,2,(5),inst_60185,inst_60188,null));
var state_60305__$1 = state_60305;
var statearr_60307_60377 = state_60305__$1;
(statearr_60307_60377[(2)] = inst_60189);

(statearr_60307_60377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (20))){
var inst_60215 = (state_60305[(7)]);
var state_60305__$1 = state_60305;
var statearr_60308_60378 = state_60305__$1;
(statearr_60308_60378[(2)] = inst_60215);

(statearr_60308_60378[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (27))){
var state_60305__$1 = state_60305;
var statearr_60309_60379 = state_60305__$1;
(statearr_60309_60379[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (1))){
var state_60305__$1 = state_60305;
var statearr_60311_60380 = state_60305__$1;
(statearr_60311_60380[(2)] = null);

(statearr_60311_60380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (24))){
var inst_60214 = (state_60305[(8)]);
var state_60305__$1 = state_60305;
if(cljs.core.truth_(inst_60214)){
var statearr_60312_60381 = state_60305__$1;
(statearr_60312_60381[(1)] = (26));

} else {
var statearr_60313_60382 = state_60305__$1;
(statearr_60313_60382[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (39))){
var inst_60261 = (state_60305[(9)]);
var inst_60260 = (state_60305[(10)]);
var inst_60286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60287 = [inst_60260,inst_60261];
var inst_60288 = (new cljs.core.PersistentVector(null,2,(5),inst_60286,inst_60287,null));
var state_60305__$1 = state_60305;
var statearr_60314_60383 = state_60305__$1;
(statearr_60314_60383[(2)] = inst_60288);

(statearr_60314_60383[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (4))){
var inst_60165 = (state_60305[(2)]);
var state_60305__$1 = state_60305;
var statearr_60315_60384 = state_60305__$1;
(statearr_60315_60384[(2)] = inst_60165);

(statearr_60315_60384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (15))){
var inst_60194 = (state_60305[(11)]);
var inst_60199 = (state_60305[(12)]);
var inst_60208 = (state_60305[(2)]);
var inst_60209 = [inst_60199,inst_60208];
var inst_60210 = (new cljs.core.PersistentVector(null,2,(5),inst_60194,inst_60209,null));
var state_60305__$1 = state_60305;
var statearr_60316_60385 = state_60305__$1;
(statearr_60316_60385[(2)] = inst_60210);

(statearr_60316_60385[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (21))){
var inst_60214 = (state_60305[(8)]);
var state_60305__$1 = state_60305;
var statearr_60317_60386 = state_60305__$1;
(statearr_60317_60386[(2)] = inst_60214);

(statearr_60317_60386[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (31))){
var inst_60255 = (state_60305[(2)]);
var state_60305__$1 = state_60305;
var statearr_60318_60387 = state_60305__$1;
(statearr_60318_60387[(2)] = inst_60255);

(statearr_60318_60387[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (32))){
var inst_60261 = (state_60305[(9)]);
var inst_60264 = cljs.core.pos_int_QMARK_.call(null,inst_60261);
var state_60305__$1 = state_60305;
var statearr_60319_60388 = state_60305__$1;
(statearr_60319_60388[(2)] = inst_60264);

(statearr_60319_60388[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (40))){
var inst_60216 = (state_60305[(13)]);
var inst_60292 = (state_60305[(14)]);
var inst_60290 = (state_60305[(2)]);
var inst_60291 = cljs.core.nth.call(null,inst_60290,(0),null);
var inst_60292__$1 = cljs.core.nth.call(null,inst_60290,(1),null);
var inst_60293 = (inst_60292__$1 > inst_60216);
var state_60305__$1 = (function (){var statearr_60320 = state_60305;
(statearr_60320[(15)] = inst_60291);

(statearr_60320[(14)] = inst_60292__$1);

return statearr_60320;
})();
if(cljs.core.truth_(inst_60293)){
var statearr_60321_60389 = state_60305__$1;
(statearr_60321_60389[(1)] = (41));

} else {
var statearr_60322_60390 = state_60305__$1;
(statearr_60322_60390[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (33))){
var inst_60262 = (state_60305[(16)]);
var state_60305__$1 = state_60305;
var statearr_60323_60391 = state_60305__$1;
(statearr_60323_60391[(2)] = inst_60262);

(statearr_60323_60391[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (13))){
var inst_60200 = (state_60305[(17)]);
var inst_60202 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_60200);
var state_60305__$1 = state_60305;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60305__$1,(16),inst_60202);
} else {
if((state_val_60306 === (22))){
var inst_60233 = (state_60305[(2)]);
var state_60305__$1 = state_60305;
if(cljs.core.truth_(inst_60233)){
var statearr_60324_60392 = state_60305__$1;
(statearr_60324_60392[(1)] = (23));

} else {
var statearr_60325_60393 = state_60305__$1;
(statearr_60325_60393[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (36))){
var state_60305__$1 = state_60305;
var statearr_60326_60394 = state_60305__$1;
(statearr_60326_60394[(2)] = null);

(statearr_60326_60394[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (41))){
var inst_60216 = (state_60305[(13)]);
var state_60305__$1 = state_60305;
var statearr_60327_60395 = state_60305__$1;
(statearr_60327_60395[(2)] = inst_60216);

(statearr_60327_60395[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (43))){
var inst_60291 = (state_60305[(15)]);
var inst_60297 = (state_60305[(2)]);
var inst_60298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60299 = [inst_60291,inst_60297];
var inst_60300 = (new cljs.core.PersistentVector(null,2,(5),inst_60298,inst_60299,null));
var _ = (function (){var statearr_60328 = state_60305;
(statearr_60328[(4)] = cljs.core.rest.call(null,(state_60305[(4)])));

return statearr_60328;
})();
var state_60305__$1 = state_60305;
var statearr_60329_60396 = state_60305__$1;
(statearr_60329_60396[(2)] = inst_60300);

(statearr_60329_60396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (29))){
var inst_60191 = (state_60305[(18)]);
var inst_60246 = cljs.core.pr_str.call(null,inst_60191);
var inst_60247 = ["Invalid block range provided: ",inst_60246].join('');
var inst_60248 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60249 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60250 = cljs.core.PersistentHashMap.fromArrays(inst_60248,inst_60249);
var inst_60251 = cljs.core.ex_info.call(null,inst_60247,inst_60250);
var inst_60252 = (function(){throw inst_60251})();
var state_60305__$1 = state_60305;
var statearr_60330_60397 = state_60305__$1;
(statearr_60330_60397[(2)] = inst_60252);

(statearr_60330_60397[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (6))){
var inst_60183 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60305__$1 = state_60305;
var statearr_60331_60398 = state_60305__$1;
(statearr_60331_60398[(2)] = inst_60183);

(statearr_60331_60398[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (28))){
var inst_60257 = (state_60305[(2)]);
var state_60305__$1 = state_60305;
var statearr_60332_60399 = state_60305__$1;
(statearr_60332_60399[(2)] = inst_60257);

(statearr_60332_60399[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (25))){
var inst_60262 = (state_60305[(16)]);
var inst_60260 = (state_60305[(10)]);
var inst_60259 = (state_60305[(2)]);
var inst_60260__$1 = cljs.core.nth.call(null,inst_60259,(0),null);
var inst_60261 = cljs.core.nth.call(null,inst_60259,(1),null);
var inst_60262__$1 = cljs.core.pos_int_QMARK_.call(null,inst_60260__$1);
var state_60305__$1 = (function (){var statearr_60333 = state_60305;
(statearr_60333[(16)] = inst_60262__$1);

(statearr_60333[(9)] = inst_60261);

(statearr_60333[(10)] = inst_60260__$1);

return statearr_60333;
})();
if(inst_60262__$1){
var statearr_60334_60400 = state_60305__$1;
(statearr_60334_60400[(1)] = (32));

} else {
var statearr_60335_60401 = state_60305__$1;
(statearr_60335_60401[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (34))){
var inst_60267 = (state_60305[(2)]);
var inst_60268 = cljs.core.not.call(null,inst_60267);
var state_60305__$1 = state_60305;
if(inst_60268){
var statearr_60336_60402 = state_60305__$1;
(statearr_60336_60402[(1)] = (35));

} else {
var statearr_60337_60403 = state_60305__$1;
(statearr_60337_60403[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (17))){
var inst_60216 = (state_60305[(13)]);
var inst_60214 = (state_60305[(8)]);
var inst_60219 = cljs.core.pr_str.call(null,inst_60214);
var inst_60220 = cljs.core.pr_str.call(null,inst_60216);
var inst_60221 = ["Start block is out of range for this ledger. Start block provided: ",inst_60219,". Database block: ",inst_60220].join('');
var inst_60222 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60223 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60224 = cljs.core.PersistentHashMap.fromArrays(inst_60222,inst_60223);
var inst_60225 = cljs.core.ex_info.call(null,inst_60221,inst_60224);
var inst_60226 = (function(){throw inst_60225})();
var state_60305__$1 = state_60305;
var statearr_60338_60404 = state_60305__$1;
(statearr_60338_60404[(2)] = inst_60226);

(statearr_60338_60404[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (3))){
var inst_60303 = (state_60305[(2)]);
var state_60305__$1 = state_60305;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60305__$1,inst_60303);
} else {
if((state_val_60306 === (12))){
var inst_60200 = (state_60305[(17)]);
var inst_60191 = (state_60305[(18)]);
var inst_60198 = (state_60305[(2)]);
var inst_60199 = fluree.db.util.async.throw_err.call(null,inst_60198);
var inst_60200__$1 = cljs.core.second.call(null,inst_60191);
var state_60305__$1 = (function (){var statearr_60339 = state_60305;
(statearr_60339[(17)] = inst_60200__$1);

(statearr_60339[(12)] = inst_60199);

return statearr_60339;
})();
if(cljs.core.truth_(inst_60200__$1)){
var statearr_60340_60405 = state_60305__$1;
(statearr_60340_60405[(1)] = (13));

} else {
var statearr_60341_60406 = state_60305__$1;
(statearr_60341_60406[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (2))){
var _ = (function (){var statearr_60342 = state_60305;
(statearr_60342[(4)] = cljs.core.cons.call(null,(5),(state_60305[(4)])));

return statearr_60342;
})();
var inst_60180 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60181 = cljs.core.sequential_QMARK_.call(null,inst_60180);
var state_60305__$1 = state_60305;
if(inst_60181){
var statearr_60343_60407 = state_60305__$1;
(statearr_60343_60407[(1)] = (6));

} else {
var statearr_60344_60408 = state_60305__$1;
(statearr_60344_60408[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (23))){
var inst_60215 = (state_60305[(7)]);
var inst_60214 = (state_60305[(8)]);
var inst_60235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60236 = [inst_60214,inst_60215];
var inst_60237 = (new cljs.core.PersistentVector(null,2,(5),inst_60235,inst_60236,null));
var state_60305__$1 = state_60305;
var statearr_60345_60409 = state_60305__$1;
(statearr_60345_60409[(2)] = inst_60237);

(statearr_60345_60409[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (35))){
var inst_60191 = (state_60305[(18)]);
var inst_60270 = cljs.core.pr_str.call(null,inst_60191);
var inst_60271 = ["Invalid block range provided: ",inst_60270].join('');
var inst_60272 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60273 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60274 = cljs.core.PersistentHashMap.fromArrays(inst_60272,inst_60273);
var inst_60275 = cljs.core.ex_info.call(null,inst_60271,inst_60274);
var inst_60276 = (function(){throw inst_60275})();
var state_60305__$1 = state_60305;
var statearr_60346_60410 = state_60305__$1;
(statearr_60346_60410[(2)] = inst_60276);

(statearr_60346_60410[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (19))){
var inst_60214 = (state_60305[(8)]);
var inst_60229 = (state_60305[(2)]);
var state_60305__$1 = (function (){var statearr_60347 = state_60305;
(statearr_60347[(19)] = inst_60229);

return statearr_60347;
})();
if(cljs.core.truth_(inst_60214)){
var statearr_60348_60411 = state_60305__$1;
(statearr_60348_60411[(1)] = (20));

} else {
var statearr_60349_60412 = state_60305__$1;
(statearr_60349_60412[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (11))){
var inst_60216 = (state_60305[(13)]);
var inst_60214 = (state_60305[(8)]);
var inst_60213 = (state_60305[(2)]);
var inst_60214__$1 = cljs.core.nth.call(null,inst_60213,(0),null);
var inst_60215 = cljs.core.nth.call(null,inst_60213,(1),null);
var inst_60216__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60217 = (inst_60214__$1 > inst_60216__$1);
var state_60305__$1 = (function (){var statearr_60351 = state_60305;
(statearr_60351[(13)] = inst_60216__$1);

(statearr_60351[(7)] = inst_60215);

(statearr_60351[(8)] = inst_60214__$1);

return statearr_60351;
})();
if(cljs.core.truth_(inst_60217)){
var statearr_60352_60413 = state_60305__$1;
(statearr_60352_60413[(1)] = (17));

} else {
var statearr_60353_60414 = state_60305__$1;
(statearr_60353_60414[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (9))){
var inst_60191 = (state_60305[(18)]);
var inst_60194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60195 = cljs.core.first.call(null,inst_60191);
var inst_60196 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_60195);
var state_60305__$1 = (function (){var statearr_60354 = state_60305;
(statearr_60354[(11)] = inst_60194);

return statearr_60354;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60305__$1,(12),inst_60196);
} else {
if((state_val_60306 === (5))){
var _ = (function (){var statearr_60355 = state_60305;
(statearr_60355[(4)] = cljs.core.rest.call(null,(state_60305[(4)])));

return statearr_60355;
})();
var state_60305__$1 = state_60305;
var ex60350 = (state_60305__$1[(2)]);
var statearr_60356_60415 = state_60305__$1;
(statearr_60356_60415[(5)] = ex60350);


if((ex60350 instanceof Error)){
var statearr_60357_60416 = state_60305__$1;
(statearr_60357_60416[(1)] = (4));

(statearr_60357_60416[(5)] = null);

} else {
throw ex60350;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (14))){
var state_60305__$1 = state_60305;
var statearr_60358_60417 = state_60305__$1;
(statearr_60358_60417[(2)] = null);

(statearr_60358_60417[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (26))){
var inst_60214 = (state_60305[(8)]);
var inst_60240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60241 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60242 = [inst_60214,inst_60241];
var inst_60243 = (new cljs.core.PersistentVector(null,2,(5),inst_60240,inst_60242,null));
var state_60305__$1 = state_60305;
var statearr_60359_60418 = state_60305__$1;
(statearr_60359_60418[(2)] = inst_60243);

(statearr_60359_60418[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (16))){
var inst_60204 = (state_60305[(2)]);
var inst_60205 = fluree.db.util.async.throw_err.call(null,inst_60204);
var state_60305__$1 = state_60305;
var statearr_60360_60419 = state_60305__$1;
(statearr_60360_60419[(2)] = inst_60205);

(statearr_60360_60419[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (38))){
var inst_60261 = (state_60305[(9)]);
var inst_60260 = (state_60305[(10)]);
var inst_60282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60283 = [inst_60261,inst_60260];
var inst_60284 = (new cljs.core.PersistentVector(null,2,(5),inst_60282,inst_60283,null));
var state_60305__$1 = state_60305;
var statearr_60361_60420 = state_60305__$1;
(statearr_60361_60420[(2)] = inst_60284);

(statearr_60361_60420[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (30))){
var state_60305__$1 = state_60305;
var statearr_60362_60421 = state_60305__$1;
(statearr_60362_60421[(2)] = null);

(statearr_60362_60421[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (10))){
var inst_60191 = (state_60305[(18)]);
var state_60305__$1 = state_60305;
var statearr_60363_60422 = state_60305__$1;
(statearr_60363_60422[(2)] = inst_60191);

(statearr_60363_60422[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (18))){
var state_60305__$1 = state_60305;
var statearr_60364_60423 = state_60305__$1;
(statearr_60364_60423[(2)] = null);

(statearr_60364_60423[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (42))){
var inst_60292 = (state_60305[(14)]);
var state_60305__$1 = state_60305;
var statearr_60365_60424 = state_60305__$1;
(statearr_60365_60424[(2)] = inst_60292);

(statearr_60365_60424[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (37))){
var inst_60261 = (state_60305[(9)]);
var inst_60260 = (state_60305[(10)]);
var inst_60279 = (state_60305[(2)]);
var inst_60280 = (inst_60261 < inst_60260);
var state_60305__$1 = (function (){var statearr_60366 = state_60305;
(statearr_60366[(20)] = inst_60279);

return statearr_60366;
})();
if(cljs.core.truth_(inst_60280)){
var statearr_60367_60425 = state_60305__$1;
(statearr_60367_60425[(1)] = (38));

} else {
var statearr_60368_60426 = state_60305__$1;
(statearr_60368_60426[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60306 === (8))){
var inst_60191 = (state_60305[(18)]);
var inst_60191__$1 = (state_60305[(2)]);
var inst_60192 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_60191__$1);
var state_60305__$1 = (function (){var statearr_60369 = state_60305;
(statearr_60369[(18)] = inst_60191__$1);

return statearr_60369;
})();
if(cljs.core.truth_(inst_60192)){
var statearr_60370_60427 = state_60305__$1;
(statearr_60370_60427[(1)] = (9));

} else {
var statearr_60371_60428 = state_60305__$1;
(statearr_60371_60428[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_60372 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60372[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__);

(statearr_60372[(1)] = (1));

return statearr_60372;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_60305){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60305);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e60373){var ex__2749__auto__ = e60373;
var statearr_60374_60429 = state_60305;
(statearr_60374_60429[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60305[(4)]))){
var statearr_60375_60430 = state_60305;
(statearr_60375_60430[(1)] = cljs.core.first.call(null,(state_60305[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60431 = state_60305;
state_60305 = G__60431;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = function(state_60305){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_60305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_60376 = f__2769__auto__.call(null);
(statearr_60376[(6)] = c__2768__auto__);

return statearr_60376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60581){
var state_val_60582 = (state_60581[(1)]);
if((state_val_60582 === (7))){
var inst_60493 = (state_60581[(2)]);
var inst_60494 = cljs.core.nth.call(null,inst_60493,(0),null);
var inst_60495 = cljs.core.nth.call(null,inst_60493,(1),null);
var inst_60503 = cljs.core.vals.call(null,inst_60495);
var inst_60504 = cljs.core.seq.call(null,inst_60503);
var inst_60505 = cljs.core.first.call(null,inst_60504);
var inst_60506 = cljs.core.next.call(null,inst_60504);
var inst_60507 = cljs.core.PersistentVector.EMPTY;
var inst_60508 = inst_60503;
var inst_60509 = inst_60507;
var state_60581__$1 = (function (){var statearr_60583 = state_60581;
(statearr_60583[(7)] = inst_60508);

(statearr_60583[(8)] = inst_60505);

(statearr_60583[(9)] = inst_60506);

(statearr_60583[(10)] = inst_60509);

(statearr_60583[(11)] = inst_60494);

return statearr_60583;
})();
var statearr_60584_60637 = state_60581__$1;
(statearr_60584_60637[(2)] = null);

(statearr_60584_60637[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (20))){
var inst_60515 = (state_60581[(12)]);
var inst_60520 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60521 = cljs.core.PersistentHashMap.EMPTY;
var inst_60522 = [true,inst_60521];
var inst_60523 = cljs.core.PersistentHashMap.fromArrays(inst_60520,inst_60522);
var inst_60524 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_60523,inst_60515);
var state_60581__$1 = state_60581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60581__$1,(22),inst_60524);
} else {
if((state_val_60582 === (27))){
var inst_60569 = (state_60581[(2)]);
var state_60581__$1 = state_60581;
var statearr_60585_60638 = state_60581__$1;
(statearr_60585_60638[(2)] = inst_60569);

(statearr_60585_60638[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (1))){
var state_60581__$1 = state_60581;
var statearr_60586_60639 = state_60581__$1;
(statearr_60586_60639[(2)] = null);

(statearr_60586_60639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (24))){
var inst_60533 = (state_60581[(13)]);
var inst_60571 = (state_60581[(2)]);
var inst_60572 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_60573 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60574 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60575 = [inst_60573,inst_60574,inst_60533,inst_60571];
var inst_60576 = cljs.core.PersistentHashMap.fromArrays(inst_60572,inst_60575);
var _ = (function (){var statearr_60588 = state_60581;
(statearr_60588[(4)] = cljs.core.rest.call(null,(state_60581[(4)])));

return statearr_60588;
})();
var state_60581__$1 = state_60581;
var statearr_60589_60640 = state_60581__$1;
(statearr_60589_60640[(2)] = inst_60576);

(statearr_60589_60640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (4))){
var inst_60434 = (state_60581[(2)]);
var state_60581__$1 = state_60581;
var statearr_60590_60641 = state_60581__$1;
(statearr_60590_60641[(2)] = inst_60434);

(statearr_60590_60641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (15))){
var inst_60450 = (state_60581[(14)]);
var inst_60458 = (state_60581[(15)]);
var inst_60479 = (state_60581[(16)]);
var inst_60453 = (state_60581[(17)]);
var inst_60472 = (state_60581[(18)]);
var inst_60464 = (state_60581[(19)]);
var inst_60456 = (state_60581[(20)]);
var inst_60465 = (state_60581[(21)]);
var inst_60474 = (state_60581[(22)]);
var inst_60457 = (state_60581[(23)]);
var inst_60452 = (state_60581[(24)]);
var inst_60485 = (function (){var subject = inst_60472;
var flake = inst_60464;
var vec__60447 = inst_60450;
var first__60462 = inst_60464;
var r = inst_60465;
var asserted_subjects = inst_60457;
var seq__60448 = inst_60453;
var flake_SINGLEQUOTE_ = inst_60479;
var retracted_subjects = inst_60458;
var G__60446 = inst_60456;
var first__60449 = inst_60452;
var asserted_QMARK_ = inst_60474;
var vec__60460 = inst_60456;
var seq__60461 = inst_60465;
return (function (p1__60433_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__60433_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60486 = cljs.core.update.call(null,inst_60458,inst_60472,inst_60485);
var tmp60587 = inst_60457;
var inst_60456__$1 = inst_60465;
var inst_60457__$1 = tmp60587;
var inst_60458__$1 = inst_60486;
var state_60581__$1 = (function (){var statearr_60591 = state_60581;
(statearr_60591[(15)] = inst_60458__$1);

(statearr_60591[(20)] = inst_60456__$1);

(statearr_60591[(23)] = inst_60457__$1);

return statearr_60591;
})();
var statearr_60592_60642 = state_60581__$1;
(statearr_60592_60642[(2)] = null);

(statearr_60592_60642[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (21))){
var inst_60531 = (state_60581[(2)]);
var state_60581__$1 = state_60581;
var statearr_60593_60643 = state_60581__$1;
(statearr_60593_60643[(2)] = inst_60531);

(statearr_60593_60643[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (13))){
var inst_60474 = (state_60581[(22)]);
var inst_60479 = (state_60581[(2)]);
var state_60581__$1 = (function (){var statearr_60594 = state_60581;
(statearr_60594[(16)] = inst_60479);

return statearr_60594;
})();
if(cljs.core.truth_(inst_60474)){
var statearr_60595_60644 = state_60581__$1;
(statearr_60595_60644[(1)] = (14));

} else {
var statearr_60596_60645 = state_60581__$1;
(statearr_60596_60645[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (22))){
var inst_60509 = (state_60581[(10)]);
var inst_60516 = (state_60581[(25)]);
var inst_60526 = (state_60581[(2)]);
var inst_60527 = fluree.db.util.async.throw_err.call(null,inst_60526);
var inst_60528 = cljs.core.conj.call(null,inst_60509,inst_60527);
var inst_60508 = inst_60516;
var inst_60509__$1 = inst_60528;
var state_60581__$1 = (function (){var statearr_60597 = state_60581;
(statearr_60597[(7)] = inst_60508);

(statearr_60597[(10)] = inst_60509__$1);

return statearr_60597;
})();
var statearr_60598_60646 = state_60581__$1;
(statearr_60598_60646[(2)] = null);

(statearr_60598_60646[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (6))){
var inst_60464 = (state_60581[(19)]);
var inst_60456 = (state_60581[(20)]);
var inst_60463 = cljs.core.seq.call(null,inst_60456);
var inst_60464__$1 = cljs.core.first.call(null,inst_60463);
var inst_60465 = cljs.core.next.call(null,inst_60463);
var inst_60466 = cljs.core.not.call(null,inst_60464__$1);
var state_60581__$1 = (function (){var statearr_60599 = state_60581;
(statearr_60599[(19)] = inst_60464__$1);

(statearr_60599[(21)] = inst_60465);

return statearr_60599;
})();
if(inst_60466){
var statearr_60600_60647 = state_60581__$1;
(statearr_60600_60647[(1)] = (8));

} else {
var statearr_60601_60648 = state_60581__$1;
(statearr_60601_60648[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (28))){
var inst_60547 = (state_60581[(26)]);
var inst_60554 = (state_60581[(27)]);
var inst_60564 = (state_60581[(2)]);
var inst_60565 = fluree.db.util.async.throw_err.call(null,inst_60564);
var inst_60566 = cljs.core.conj.call(null,inst_60547,inst_60565);
var inst_60546 = inst_60554;
var inst_60547__$1 = inst_60566;
var state_60581__$1 = (function (){var statearr_60602 = state_60581;
(statearr_60602[(26)] = inst_60547__$1);

(statearr_60602[(28)] = inst_60546);

return statearr_60602;
})();
var statearr_60603_60649 = state_60581__$1;
(statearr_60603_60649[(2)] = null);

(statearr_60603_60649[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (25))){
var inst_60547 = (state_60581[(26)]);
var state_60581__$1 = state_60581;
var statearr_60604_60650 = state_60581__$1;
(statearr_60604_60650[(2)] = inst_60547);

(statearr_60604_60650[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (17))){
var inst_60508 = (state_60581[(7)]);
var inst_60515 = (state_60581[(12)]);
var inst_60514 = cljs.core.seq.call(null,inst_60508);
var inst_60515__$1 = cljs.core.first.call(null,inst_60514);
var inst_60516 = cljs.core.next.call(null,inst_60514);
var inst_60517 = cljs.core.not.call(null,inst_60515__$1);
var state_60581__$1 = (function (){var statearr_60605 = state_60581;
(statearr_60605[(12)] = inst_60515__$1);

(statearr_60605[(25)] = inst_60516);

return statearr_60605;
})();
if(inst_60517){
var statearr_60606_60651 = state_60581__$1;
(statearr_60606_60651[(1)] = (19));

} else {
var statearr_60607_60652 = state_60581__$1;
(statearr_60607_60652[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (3))){
var inst_60579 = (state_60581[(2)]);
var state_60581__$1 = state_60581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60581__$1,inst_60579);
} else {
if((state_val_60582 === (12))){
var inst_60464 = (state_60581[(19)]);
var inst_60477 = fluree.db.flake.flip_flake.call(null,inst_60464);
var state_60581__$1 = state_60581;
var statearr_60608_60653 = state_60581__$1;
(statearr_60608_60653[(2)] = inst_60477);

(statearr_60608_60653[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (2))){
var inst_60450 = (state_60581[(14)]);
var _ = (function (){var statearr_60609 = state_60581;
(statearr_60609[(4)] = cljs.core.cons.call(null,(5),(state_60581[(4)])));

return statearr_60609;
})();
var inst_60450__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60451 = cljs.core.seq.call(null,inst_60450__$1);
var inst_60452 = cljs.core.first.call(null,inst_60451);
var inst_60453 = cljs.core.next.call(null,inst_60451);
var inst_60454 = cljs.core.PersistentHashMap.EMPTY;
var inst_60455 = cljs.core.PersistentHashMap.EMPTY;
var inst_60456 = inst_60450__$1;
var inst_60457 = inst_60454;
var inst_60458 = inst_60455;
var state_60581__$1 = (function (){var statearr_60610 = state_60581;
(statearr_60610[(14)] = inst_60450__$1);

(statearr_60610[(15)] = inst_60458);

(statearr_60610[(17)] = inst_60453);

(statearr_60610[(20)] = inst_60456);

(statearr_60610[(23)] = inst_60457);

(statearr_60610[(24)] = inst_60452);

return statearr_60610;
})();
var statearr_60611_60654 = state_60581__$1;
(statearr_60611_60654[(2)] = null);

(statearr_60611_60654[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (23))){
var inst_60546 = (state_60581[(28)]);
var inst_60553 = (state_60581[(29)]);
var inst_60552 = cljs.core.seq.call(null,inst_60546);
var inst_60553__$1 = cljs.core.first.call(null,inst_60552);
var inst_60554 = cljs.core.next.call(null,inst_60552);
var inst_60555 = cljs.core.not.call(null,inst_60553__$1);
var state_60581__$1 = (function (){var statearr_60612 = state_60581;
(statearr_60612[(29)] = inst_60553__$1);

(statearr_60612[(27)] = inst_60554);

return statearr_60612;
})();
if(inst_60555){
var statearr_60613_60655 = state_60581__$1;
(statearr_60613_60655[(1)] = (25));

} else {
var statearr_60614_60656 = state_60581__$1;
(statearr_60614_60656[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (19))){
var inst_60509 = (state_60581[(10)]);
var state_60581__$1 = state_60581;
var statearr_60615_60657 = state_60581__$1;
(statearr_60615_60657[(2)] = inst_60509);

(statearr_60615_60657[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (11))){
var inst_60464 = (state_60581[(19)]);
var state_60581__$1 = state_60581;
var statearr_60617_60658 = state_60581__$1;
(statearr_60617_60658[(2)] = inst_60464);

(statearr_60617_60658[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (9))){
var inst_60464 = (state_60581[(19)]);
var inst_60474 = (state_60581[(22)]);
var inst_60472 = inst_60464.s;
var inst_60473 = inst_60464.op;
var inst_60474__$1 = inst_60473 === true;
var state_60581__$1 = (function (){var statearr_60619 = state_60581;
(statearr_60619[(18)] = inst_60472);

(statearr_60619[(22)] = inst_60474__$1);

return statearr_60619;
})();
if(cljs.core.truth_(inst_60474__$1)){
var statearr_60620_60659 = state_60581__$1;
(statearr_60620_60659[(1)] = (11));

} else {
var statearr_60621_60660 = state_60581__$1;
(statearr_60621_60660[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (5))){
var _ = (function (){var statearr_60622 = state_60581;
(statearr_60622[(4)] = cljs.core.rest.call(null,(state_60581[(4)])));

return statearr_60622;
})();
var state_60581__$1 = state_60581;
var ex60616 = (state_60581__$1[(2)]);
var statearr_60623_60661 = state_60581__$1;
(statearr_60623_60661[(5)] = ex60616);


if((ex60616 instanceof Error)){
var statearr_60624_60662 = state_60581__$1;
(statearr_60624_60662[(1)] = (4));

(statearr_60624_60662[(5)] = null);

} else {
throw ex60616;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (14))){
var inst_60450 = (state_60581[(14)]);
var inst_60458 = (state_60581[(15)]);
var inst_60479 = (state_60581[(16)]);
var inst_60453 = (state_60581[(17)]);
var inst_60472 = (state_60581[(18)]);
var inst_60464 = (state_60581[(19)]);
var inst_60456 = (state_60581[(20)]);
var inst_60465 = (state_60581[(21)]);
var inst_60474 = (state_60581[(22)]);
var inst_60457 = (state_60581[(23)]);
var inst_60452 = (state_60581[(24)]);
var inst_60481 = (function (){var subject = inst_60472;
var flake = inst_60464;
var vec__60447 = inst_60450;
var first__60462 = inst_60464;
var r = inst_60465;
var asserted_subjects = inst_60457;
var seq__60448 = inst_60453;
var flake_SINGLEQUOTE_ = inst_60479;
var retracted_subjects = inst_60458;
var G__60446 = inst_60456;
var first__60449 = inst_60452;
var asserted_QMARK_ = inst_60474;
var vec__60460 = inst_60456;
var seq__60461 = inst_60465;
return (function (p1__60432_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__60432_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60482 = cljs.core.update.call(null,inst_60457,inst_60472,inst_60481);
var tmp60618 = inst_60458;
var inst_60456__$1 = inst_60465;
var inst_60457__$1 = inst_60482;
var inst_60458__$1 = tmp60618;
var state_60581__$1 = (function (){var statearr_60625 = state_60581;
(statearr_60625[(15)] = inst_60458__$1);

(statearr_60625[(20)] = inst_60456__$1);

(statearr_60625[(23)] = inst_60457__$1);

return statearr_60625;
})();
var statearr_60626_60663 = state_60581__$1;
(statearr_60626_60663[(2)] = null);

(statearr_60626_60663[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (26))){
var inst_60553 = (state_60581[(29)]);
var inst_60558 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60559 = cljs.core.PersistentHashMap.EMPTY;
var inst_60560 = [true,inst_60559];
var inst_60561 = cljs.core.PersistentHashMap.fromArrays(inst_60558,inst_60560);
var inst_60562 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_60561,inst_60553);
var state_60581__$1 = state_60581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60581__$1,(28),inst_60562);
} else {
if((state_val_60582 === (16))){
var inst_60489 = (state_60581[(2)]);
var state_60581__$1 = state_60581;
var statearr_60627_60664 = state_60581__$1;
(statearr_60627_60664[(2)] = inst_60489);

(statearr_60627_60664[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (10))){
var inst_60491 = (state_60581[(2)]);
var state_60581__$1 = state_60581;
var statearr_60628_60665 = state_60581__$1;
(statearr_60628_60665[(2)] = inst_60491);

(statearr_60628_60665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (18))){
var inst_60494 = (state_60581[(11)]);
var inst_60533 = (state_60581[(2)]);
var inst_60541 = cljs.core.vals.call(null,inst_60494);
var inst_60542 = cljs.core.seq.call(null,inst_60541);
var inst_60543 = cljs.core.first.call(null,inst_60542);
var inst_60544 = cljs.core.next.call(null,inst_60542);
var inst_60545 = cljs.core.PersistentVector.EMPTY;
var inst_60546 = inst_60541;
var inst_60547 = inst_60545;
var state_60581__$1 = (function (){var statearr_60629 = state_60581;
(statearr_60629[(26)] = inst_60547);

(statearr_60629[(28)] = inst_60546);

(statearr_60629[(30)] = inst_60544);

(statearr_60629[(31)] = inst_60543);

(statearr_60629[(13)] = inst_60533);

return statearr_60629;
})();
var statearr_60630_60666 = state_60581__$1;
(statearr_60630_60666[(2)] = null);

(statearr_60630_60666[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60582 === (8))){
var inst_60458 = (state_60581[(15)]);
var inst_60457 = (state_60581[(23)]);
var inst_60468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60469 = [inst_60457,inst_60458];
var inst_60470 = (new cljs.core.PersistentVector(null,2,(5),inst_60468,inst_60469,null));
var state_60581__$1 = state_60581;
var statearr_60631_60667 = state_60581__$1;
(statearr_60631_60667[(2)] = inst_60470);

(statearr_60631_60667[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_60632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60632[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_60632[(1)] = (1));

return statearr_60632;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_60581){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e60633){var ex__2749__auto__ = e60633;
var statearr_60634_60668 = state_60581;
(statearr_60634_60668[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60581[(4)]))){
var statearr_60635_60669 = state_60581;
(statearr_60635_60669[(1)] = cljs.core.first.call(null,(state_60581[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60670 = state_60581;
state_60581 = G__60670;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_60581){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_60581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_60636 = f__2769__auto__.call(null);
(statearr_60636[(6)] = c__2768__auto__);

return statearr_60636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60702){
var state_val_60703 = (state_60702[(1)]);
if((state_val_60703 === (1))){
var inst_60671 = cljs.core.volatile_BANG_.call(null,(0));
var inst_60672 = cljs.core.PersistentHashMap.EMPTY;
var inst_60673 = cljs.core.volatile_BANG_.call(null,inst_60672);
var inst_60674 = cljs.core.first.call(null,resp);
var inst_60675 = cljs.core.rest.call(null,resp);
var inst_60676 = cljs.core.PersistentVector.EMPTY;
var inst_60677 = inst_60671;
var inst_60678 = inst_60673;
var inst_60679 = inst_60674;
var inst_60680 = inst_60675;
var inst_60681 = inst_60676;
var state_60702__$1 = (function (){var statearr_60704 = state_60702;
(statearr_60704[(7)] = inst_60679);

(statearr_60704[(8)] = inst_60681);

(statearr_60704[(9)] = inst_60678);

(statearr_60704[(10)] = inst_60677);

(statearr_60704[(11)] = inst_60680);

return statearr_60704;
})();
var statearr_60705_60720 = state_60702__$1;
(statearr_60705_60720[(2)] = null);

(statearr_60705_60720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60703 === (2))){
var inst_60679 = (state_60702[(7)]);
var inst_60678 = (state_60702[(9)]);
var inst_60677 = (state_60702[(10)]);
var inst_60683 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_60679,inst_60678,inst_60677);
var state_60702__$1 = state_60702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60702__$1,(4),inst_60683);
} else {
if((state_val_60703 === (3))){
var inst_60700 = (state_60702[(2)]);
var state_60702__$1 = state_60702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60702__$1,inst_60700);
} else {
if((state_val_60703 === (4))){
var inst_60681 = (state_60702[(8)]);
var inst_60680 = (state_60702[(11)]);
var inst_60685 = (state_60702[(2)]);
var inst_60686 = fluree.db.util.async.throw_err.call(null,inst_60685);
var inst_60687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60688 = [inst_60686];
var inst_60689 = (new cljs.core.PersistentVector(null,1,(5),inst_60687,inst_60688,null));
var inst_60690 = cljs.core.concat.call(null,inst_60681,inst_60689);
var inst_60691 = cljs.core.first.call(null,inst_60680);
var state_60702__$1 = (function (){var statearr_60708 = state_60702;
(statearr_60708[(12)] = inst_60690);

return statearr_60708;
})();
if(cljs.core.truth_(inst_60691)){
var statearr_60709_60721 = state_60702__$1;
(statearr_60709_60721[(1)] = (5));

} else {
var statearr_60710_60722 = state_60702__$1;
(statearr_60710_60722[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60703 === (5))){
var inst_60678 = (state_60702[(9)]);
var inst_60677 = (state_60702[(10)]);
var inst_60680 = (state_60702[(11)]);
var inst_60690 = (state_60702[(12)]);
var inst_60693 = cljs.core.first.call(null,inst_60680);
var inst_60694 = cljs.core.rest.call(null,inst_60680);
var tmp60706 = inst_60678;
var tmp60707 = inst_60677;
var inst_60677__$1 = tmp60707;
var inst_60678__$1 = tmp60706;
var inst_60679 = inst_60693;
var inst_60680__$1 = inst_60694;
var inst_60681 = inst_60690;
var state_60702__$1 = (function (){var statearr_60711 = state_60702;
(statearr_60711[(7)] = inst_60679);

(statearr_60711[(8)] = inst_60681);

(statearr_60711[(9)] = inst_60678__$1);

(statearr_60711[(10)] = inst_60677__$1);

(statearr_60711[(11)] = inst_60680__$1);

return statearr_60711;
})();
var statearr_60712_60723 = state_60702__$1;
(statearr_60712_60723[(2)] = null);

(statearr_60712_60723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60703 === (6))){
var inst_60690 = (state_60702[(12)]);
var state_60702__$1 = state_60702;
var statearr_60713_60724 = state_60702__$1;
(statearr_60713_60724[(2)] = inst_60690);

(statearr_60713_60724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60703 === (7))){
var inst_60698 = (state_60702[(2)]);
var state_60702__$1 = state_60702;
var statearr_60714_60725 = state_60702__$1;
(statearr_60714_60725[(2)] = inst_60698);

(statearr_60714_60725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_60715 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60715[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__);

(statearr_60715[(1)] = (1));

return statearr_60715;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1 = (function (state_60702){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e60716){var ex__2749__auto__ = e60716;
var statearr_60717_60726 = state_60702;
(statearr_60717_60726[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60702[(4)]))){
var statearr_60718_60727 = state_60702;
(statearr_60718_60727[(1)] = cljs.core.first.call(null,(state_60702[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60728 = state_60702;
state_60702 = G__60728;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = function(state_60702){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1.call(this,state_60702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_60719 = f__2769__auto__.call(null);
(statearr_60719[(6)] = c__2768__auto__);

return statearr_60719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__60730 = arguments.length;
switch (G__60730) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__60732){
var map__60733 = p__60732;
var map__60733__$1 = cljs.core.__destructure_map.call(null,map__60733);
var query = map__60733__$1;
var opts = cljs.core.get.call(null,map__60733__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60818){
var state_val_60819 = (state_60818[(1)]);
if((state_val_60819 === (7))){
var inst_60744 = (state_60818[(7)]);
var inst_60748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60749 = ["_auth/id",inst_60744];
var inst_60750 = (new cljs.core.PersistentVector(null,2,(5),inst_60748,inst_60749,null));
var state_60818__$1 = state_60818;
var statearr_60820_60864 = state_60818__$1;
(statearr_60820_60864[(2)] = inst_60750);

(statearr_60820_60864[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (20))){
var inst_60798 = (state_60818[(2)]);
var inst_60799 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_60818__$1 = (function (){var statearr_60821 = state_60818;
(statearr_60821[(8)] = inst_60798);

return statearr_60821;
})();
if(cljs.core.truth_(inst_60799)){
var statearr_60822_60865 = state_60818__$1;
(statearr_60822_60865[(1)] = (22));

} else {
var statearr_60823_60866 = state_60818__$1;
(statearr_60823_60866[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (27))){
var inst_60801 = (state_60818[(9)]);
var inst_60745 = (state_60818[(10)]);
var inst_60807 = (state_60818[(2)]);
var inst_60808 = fluree.db.util.core.response_time_formatted.call(null,inst_60745);
var inst_60809 = [(200),inst_60807,(100),inst_60808];
var inst_60810 = cljs.core.PersistentHashMap.fromArrays(inst_60801,inst_60809);
var state_60818__$1 = state_60818;
var statearr_60824_60867 = state_60818__$1;
(statearr_60824_60867[(2)] = inst_60810);

(statearr_60824_60867[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (1))){
var state_60818__$1 = state_60818;
var statearr_60825_60868 = state_60818__$1;
(statearr_60825_60868[(2)] = null);

(statearr_60825_60868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (24))){
var inst_60813 = (state_60818[(2)]);
var _ = (function (){var statearr_60826 = state_60818;
(statearr_60826[(4)] = cljs.core.rest.call(null,(state_60818[(4)])));

return statearr_60826;
})();
var state_60818__$1 = state_60818;
var statearr_60827_60869 = state_60818__$1;
(statearr_60827_60869[(2)] = inst_60813);

(statearr_60827_60869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (4))){
var inst_60734 = (state_60818[(2)]);
var state_60818__$1 = state_60818;
var statearr_60828_60870 = state_60818__$1;
(statearr_60828_60870[(2)] = inst_60734);

(statearr_60828_60870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (15))){
var inst_60785 = (state_60818[(11)]);
var state_60818__$1 = state_60818;
var statearr_60829_60871 = state_60818__$1;
(statearr_60829_60871[(2)] = inst_60785);

(statearr_60829_60871[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (21))){
var inst_60794 = (state_60818[(2)]);
var inst_60795 = fluree.db.util.async.throw_err.call(null,inst_60794);
var state_60818__$1 = state_60818;
var statearr_60830_60872 = state_60818__$1;
(statearr_60830_60872[(2)] = inst_60795);

(statearr_60830_60872[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (13))){
var inst_60743 = (state_60818[(12)]);
var inst_60785 = (state_60818[(11)]);
var inst_60784 = (state_60818[(2)]);
var inst_60785__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_60743);
var state_60818__$1 = (function (){var statearr_60831 = state_60818;
(statearr_60831[(13)] = inst_60784);

(statearr_60831[(11)] = inst_60785__$1);

return statearr_60831;
})();
if(cljs.core.truth_(inst_60785__$1)){
var statearr_60832_60873 = state_60818__$1;
(statearr_60832_60873[(1)] = (15));

} else {
var statearr_60833_60874 = state_60818__$1;
(statearr_60833_60874[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (22))){
var inst_60798 = (state_60818[(8)]);
var inst_60801 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60802 = cljs.core.sequential_QMARK_.call(null,inst_60798);
var state_60818__$1 = (function (){var statearr_60834 = state_60818;
(statearr_60834[(9)] = inst_60801);

return statearr_60834;
})();
if(inst_60802){
var statearr_60835_60875 = state_60818__$1;
(statearr_60835_60875[(1)] = (25));

} else {
var statearr_60836_60876 = state_60818__$1;
(statearr_60836_60876[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (6))){
var inst_60759 = (state_60818[(14)]);
var inst_60743 = (state_60818[(12)]);
var inst_60758 = (state_60818[(2)]);
var inst_60759__$1 = fluree.db.util.async.throw_err.call(null,inst_60758);
var inst_60760 = fluree.db.api.query.resolve_block_range.call(null,inst_60759__$1,inst_60743);
var state_60818__$1 = (function (){var statearr_60837 = state_60818;
(statearr_60837[(14)] = inst_60759__$1);

return statearr_60837;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60818__$1,(10),inst_60760);
} else {
if((state_val_60819 === (25))){
var inst_60798 = (state_60818[(8)]);
var inst_60804 = cljs.core.doall.call(null,inst_60798);
var state_60818__$1 = state_60818;
var statearr_60838_60877 = state_60818__$1;
(statearr_60838_60877[(2)] = inst_60804);

(statearr_60838_60877[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (17))){
var inst_60790 = (state_60818[(2)]);
var state_60818__$1 = state_60818;
if(cljs.core.truth_(inst_60790)){
var statearr_60839_60878 = state_60818__$1;
(statearr_60839_60878[(1)] = (18));

} else {
var statearr_60840_60879 = state_60818__$1;
(statearr_60840_60879[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (3))){
var inst_60816 = (state_60818[(2)]);
var state_60818__$1 = state_60818;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60818__$1,inst_60816);
} else {
if((state_val_60819 === (12))){
var inst_60743 = (state_60818[(12)]);
var inst_60776 = cljs.core.pr_str.call(null,inst_60743);
var inst_60777 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_60776].join('');
var inst_60778 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60779 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60780 = cljs.core.PersistentHashMap.fromArrays(inst_60778,inst_60779);
var inst_60781 = cljs.core.ex_info.call(null,inst_60777,inst_60780);
var inst_60782 = (function(){throw inst_60781})();
var state_60818__$1 = state_60818;
var statearr_60841_60880 = state_60818__$1;
(statearr_60841_60880[(2)] = inst_60782);

(statearr_60841_60880[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (2))){
var inst_60744 = (state_60818[(7)]);
var _ = (function (){var statearr_60842 = state_60818;
(statearr_60842[(4)] = cljs.core.cons.call(null,(5),(state_60818[(4)])));

return statearr_60842;
})();
var inst_60743 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60744__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60745 = fluree.db.util.core.current_time_millis.call(null);
var inst_60746 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_60818__$1 = (function (){var statearr_60843 = state_60818;
(statearr_60843[(15)] = inst_60746);

(statearr_60843[(12)] = inst_60743);

(statearr_60843[(10)] = inst_60745);

(statearr_60843[(7)] = inst_60744__$1);

return statearr_60843;
})();
if(cljs.core.truth_(inst_60744__$1)){
var statearr_60844_60881 = state_60818__$1;
(statearr_60844_60881[(1)] = (7));

} else {
var statearr_60845_60882 = state_60818__$1;
(statearr_60845_60882[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (23))){
var inst_60798 = (state_60818[(8)]);
var state_60818__$1 = state_60818;
var statearr_60846_60883 = state_60818__$1;
(statearr_60846_60883[(2)] = inst_60798);

(statearr_60846_60883[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (19))){
var inst_60784 = (state_60818[(13)]);
var state_60818__$1 = state_60818;
var statearr_60847_60884 = state_60818__$1;
(statearr_60847_60884[(2)] = inst_60784);

(statearr_60847_60884[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (11))){
var inst_60759 = (state_60818[(14)]);
var inst_60765 = (state_60818[(16)]);
var inst_60764 = (state_60818[(17)]);
var inst_60771 = fluree.db.api.query.block_range.call(null,inst_60759,inst_60764,inst_60765,opts);
var state_60818__$1 = state_60818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60818__$1,(14),inst_60771);
} else {
if((state_val_60819 === (9))){
var inst_60746 = (state_60818[(15)]);
var inst_60753 = (state_60818[(2)]);
var inst_60754 = [inst_60753];
var inst_60755 = cljs.core.PersistentHashMap.fromArrays(inst_60746,inst_60754);
var inst_60756 = fluree.db.api.query.db.call(null,conn,ledger,inst_60755);
var state_60818__$1 = state_60818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60818__$1,(6),inst_60756);
} else {
if((state_val_60819 === (5))){
var _ = (function (){var statearr_60849 = state_60818;
(statearr_60849[(4)] = cljs.core.rest.call(null,(state_60818[(4)])));

return statearr_60849;
})();
var state_60818__$1 = state_60818;
var ex60848 = (state_60818__$1[(2)]);
var statearr_60850_60885 = state_60818__$1;
(statearr_60850_60885[(5)] = ex60848);


if((ex60848 instanceof Error)){
var statearr_60851_60886 = state_60818__$1;
(statearr_60851_60886[(1)] = (4));

(statearr_60851_60886[(5)] = null);

} else {
throw ex60848;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (14))){
var inst_60773 = (state_60818[(2)]);
var inst_60774 = fluree.db.util.async.throw_err.call(null,inst_60773);
var state_60818__$1 = state_60818;
var statearr_60852_60887 = state_60818__$1;
(statearr_60852_60887[(2)] = inst_60774);

(statearr_60852_60887[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (26))){
var inst_60798 = (state_60818[(8)]);
var state_60818__$1 = state_60818;
var statearr_60853_60888 = state_60818__$1;
(statearr_60853_60888[(2)] = inst_60798);

(statearr_60853_60888[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (16))){
var inst_60743 = (state_60818[(12)]);
var inst_60788 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_60743);
var state_60818__$1 = state_60818;
var statearr_60854_60889 = state_60818__$1;
(statearr_60854_60889[(2)] = inst_60788);

(statearr_60854_60889[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (10))){
var inst_60743 = (state_60818[(12)]);
var inst_60762 = (state_60818[(2)]);
var inst_60763 = fluree.db.util.async.throw_err.call(null,inst_60762);
var inst_60764 = cljs.core.nth.call(null,inst_60763,(0),null);
var inst_60765 = cljs.core.nth.call(null,inst_60763,(1),null);
var inst_60766 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_60767 = cljs.core.dissoc.call(null,inst_60743,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_60768 = cljs.core.keys.call(null,inst_60767);
var inst_60769 = cljs.core._EQ_.call(null,inst_60766,inst_60768);
var state_60818__$1 = (function (){var statearr_60855 = state_60818;
(statearr_60855[(16)] = inst_60765);

(statearr_60855[(17)] = inst_60764);

return statearr_60855;
})();
if(inst_60769){
var statearr_60856_60890 = state_60818__$1;
(statearr_60856_60890[(1)] = (11));

} else {
var statearr_60857_60891 = state_60818__$1;
(statearr_60857_60891[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60819 === (18))){
var inst_60759 = (state_60818[(14)]);
var inst_60784 = (state_60818[(13)]);
var inst_60792 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_60759,inst_60784);
var state_60818__$1 = state_60818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60818__$1,(21),inst_60792);
} else {
if((state_val_60819 === (8))){
var state_60818__$1 = state_60818;
var statearr_60858_60892 = state_60818__$1;
(statearr_60858_60892[(2)] = null);

(statearr_60858_60892[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_60859 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60859[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2746__auto__);

(statearr_60859[(1)] = (1));

return statearr_60859;
});
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1 = (function (state_60818){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60818);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e60860){var ex__2749__auto__ = e60860;
var statearr_60861_60893 = state_60818;
(statearr_60861_60893[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60818[(4)]))){
var statearr_60862_60894 = state_60818;
(statearr_60862_60894[(1)] = cljs.core.first.call(null,(state_60818[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60895 = state_60818;
state_60818 = G__60895;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = function(state_60818){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1.call(this,state_60818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_60863 = f__2769__auto__.call(null);
(statearr_60863[(6)] = c__2768__auto__);

return statearr_60863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__60896 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__60896,(0),null);
var p = cljs.core.nth.call(null,vec__60896,(1),null);
var o = cljs.core.nth.call(null,vec__60896,(2),null);
var t = cljs.core.nth.call(null,vec__60896,(3),null);
var vec__60899 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__60899,(0),null);
var idx = cljs.core.nth.call(null,vec__60899,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__60902 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__60902,(0),null);
var id = cljs.core.nth.call(null,vec__60902,(1),null);
var or__5045__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___60906 = arguments.length;
var i__5770__auto___60907 = (0);
while(true){
if((i__5770__auto___60907 < len__5769__auto___60906)){
args__5775__auto__.push((arguments[i__5770__auto___60907]));

var G__60908 = (i__5770__auto___60907 + (1));
i__5770__auto___60907 = G__60908;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq60905){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq60905));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61104){
var state_val_61105 = (state_61104[(1)]);
if((state_val_61105 === (7))){
var inst_61024 = (state_61104[(7)]);
var inst_61031 = (state_61104[(8)]);
var inst_61030 = cljs.core.seq.call(null,inst_61024);
var inst_61031__$1 = cljs.core.first.call(null,inst_61030);
var inst_61032 = cljs.core.next.call(null,inst_61030);
var state_61104__$1 = (function (){var statearr_61106 = state_61104;
(statearr_61106[(9)] = inst_61032);

(statearr_61106[(8)] = inst_61031__$1);

return statearr_61106;
})();
if(cljs.core.truth_(inst_61031__$1)){
var statearr_61107_61207 = state_61104__$1;
(statearr_61107_61207[(1)] = (9));

} else {
var statearr_61108_61208 = state_61104__$1;
(statearr_61108_61208[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (20))){
var inst_61094 = (state_61104[(2)]);
var state_61104__$1 = state_61104;
var statearr_61109_61209 = state_61104__$1;
(statearr_61109_61209[(2)] = inst_61094);

(statearr_61109_61209[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (27))){
var inst_61049 = (state_61104[(10)]);
var inst_61052 = (state_61104[(11)]);
var inst_61070 = (state_61104[(12)]);
var inst_61072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61073 = [inst_61052,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_61074 = (new cljs.core.PersistentVector(null,2,(5),inst_61072,inst_61073,null));
var inst_61075 = cljs.core.update_in.call(null,inst_61070,inst_61074,fluree.db.api.query.min_safe,inst_61049);
var state_61104__$1 = state_61104;
var statearr_61110_61210 = state_61104__$1;
(statearr_61110_61210[(2)] = inst_61075);

(statearr_61110_61210[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (1))){
var state_61104__$1 = state_61104;
var statearr_61111_61211 = state_61104__$1;
(statearr_61111_61211[(2)] = null);

(statearr_61111_61211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (24))){
var inst_61052 = (state_61104[(11)]);
var inst_61062 = (state_61104[(13)]);
var inst_61031 = (state_61104[(8)]);
var inst_61064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61065 = [inst_61052,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_61066 = (new cljs.core.PersistentVector(null,2,(5),inst_61064,inst_61065,null));
var inst_61067 = cljs.core.update_in.call(null,inst_61062,inst_61066,cljs.core.conj,inst_61031);
var state_61104__$1 = state_61104;
var statearr_61113_61212 = state_61104__$1;
(statearr_61113_61212[(2)] = inst_61067);

(statearr_61113_61212[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (4))){
var inst_60910 = (state_61104[(2)]);
var state_61104__$1 = state_61104;
var statearr_61114_61213 = state_61104__$1;
(statearr_61114_61213[(2)] = inst_60910);

(statearr_61114_61213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (15))){
var inst_61025 = (state_61104[(14)]);
var inst_61032 = (state_61104[(9)]);
var tmp61112 = inst_61025;
var inst_61024 = inst_61032;
var inst_61025__$1 = tmp61112;
var state_61104__$1 = (function (){var statearr_61115 = state_61104;
(statearr_61115[(14)] = inst_61025__$1);

(statearr_61115[(7)] = inst_61024);

return statearr_61115;
})();
var statearr_61116_61214 = state_61104__$1;
(statearr_61116_61214[(2)] = null);

(statearr_61116_61214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (21))){
var inst_61052 = (state_61104[(11)]);
var inst_61025 = (state_61104[(14)]);
var inst_61056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61057 = [inst_61052,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61058 = (new cljs.core.PersistentVector(null,2,(5),inst_61056,inst_61057,null));
var inst_61059 = cljs.core.assoc_in.call(null,inst_61025,inst_61058,inst_61052);
var state_61104__$1 = state_61104;
var statearr_61117_61215 = state_61104__$1;
(statearr_61117_61215[(2)] = inst_61059);

(statearr_61117_61215[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (31))){
var inst_61078 = (state_61104[(15)]);
var state_61104__$1 = state_61104;
var statearr_61118_61216 = state_61104__$1;
(statearr_61118_61216[(2)] = inst_61078);

(statearr_61118_61216[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (32))){
var inst_61032 = (state_61104[(9)]);
var inst_61086 = (state_61104[(2)]);
var inst_61024 = inst_61032;
var inst_61025 = inst_61086;
var state_61104__$1 = (function (){var statearr_61119 = state_61104;
(statearr_61119[(14)] = inst_61025);

(statearr_61119[(7)] = inst_61024);

return statearr_61119;
})();
var statearr_61120_61217 = state_61104__$1;
(statearr_61120_61217[(2)] = null);

(statearr_61120_61217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (33))){
var inst_61025 = (state_61104[(14)]);
var state_61104__$1 = state_61104;
var statearr_61121_61218 = state_61104__$1;
(statearr_61121_61218[(2)] = inst_61025);

(statearr_61121_61218[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (13))){
var inst_61034 = (state_61104[(16)]);
var state_61104__$1 = state_61104;
var statearr_61122_61219 = state_61104__$1;
(statearr_61122_61219[(2)] = inst_61034);

(statearr_61122_61219[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (22))){
var inst_61025 = (state_61104[(14)]);
var state_61104__$1 = state_61104;
var statearr_61123_61220 = state_61104__$1;
(statearr_61123_61220[(2)] = inst_61025);

(statearr_61123_61220[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (29))){
var inst_61078 = (state_61104[(2)]);
var state_61104__$1 = (function (){var statearr_61124 = state_61104;
(statearr_61124[(15)] = inst_61078);

return statearr_61124;
})();
if(cljs.core.truth_(show_auth)){
var statearr_61125_61221 = state_61104__$1;
(statearr_61125_61221[(1)] = (30));

} else {
var statearr_61126_61222 = state_61104__$1;
(statearr_61126_61222[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (6))){
var inst_61010 = (state_61104[(2)]);
var inst_61011 = fluree.db.util.async.throw_err.call(null,inst_61010);
var inst_61019 = resp;
var inst_61020 = cljs.core.seq.call(null,inst_61019);
var inst_61021 = cljs.core.first.call(null,inst_61020);
var inst_61022 = cljs.core.next.call(null,inst_61020);
var inst_61023 = cljs.core.PersistentHashMap.EMPTY;
var inst_61024 = inst_61019;
var inst_61025 = inst_61023;
var state_61104__$1 = (function (){var statearr_61127 = state_61104;
(statearr_61127[(17)] = inst_61021);

(statearr_61127[(14)] = inst_61025);

(statearr_61127[(18)] = inst_61022);

(statearr_61127[(7)] = inst_61024);

(statearr_61127[(19)] = inst_61011);

return statearr_61127;
})();
var statearr_61128_61223 = state_61104__$1;
(statearr_61128_61223[(2)] = null);

(statearr_61128_61223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (28))){
var inst_61070 = (state_61104[(12)]);
var state_61104__$1 = state_61104;
var statearr_61129_61224 = state_61104__$1;
(statearr_61129_61224[(2)] = inst_61070);

(statearr_61129_61224[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (25))){
var inst_61062 = (state_61104[(13)]);
var state_61104__$1 = state_61104;
var statearr_61130_61225 = state_61104__$1;
(statearr_61130_61225[(2)] = inst_61062);

(statearr_61130_61225[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (34))){
var state_61104__$1 = state_61104;
var statearr_61131_61226 = state_61104__$1;
(statearr_61131_61226[(2)] = null);

(statearr_61131_61226[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (17))){
var inst_61096 = (state_61104[(2)]);
var state_61104__$1 = state_61104;
var statearr_61132_61227 = state_61104__$1;
(statearr_61132_61227[(2)] = inst_61096);

(statearr_61132_61227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (3))){
var inst_61102 = (state_61104[(2)]);
var state_61104__$1 = state_61104;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61104__$1,inst_61102);
} else {
if((state_val_61105 === (12))){
var inst_61031 = (state_61104[(8)]);
var inst_61011 = (state_61104[(19)]);
var inst_61036 = fluree.db.api.query.auth_match.call(null,auth,inst_61011,inst_61031);
var inst_61037 = cljs.core.not.call(null,inst_61036);
var state_61104__$1 = state_61104;
var statearr_61133_61228 = state_61104__$1;
(statearr_61133_61228[(2)] = inst_61037);

(statearr_61133_61228[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (2))){
var _ = (function (){var statearr_61134 = state_61104;
(statearr_61134[(4)] = cljs.core.cons.call(null,(5),(state_61104[(4)])));

return statearr_61134;
})();
var inst_60916 = (function (){return (function (p1__60909_SHARP_){
return p1__60909_SHARP_.t;
});
})();
var inst_60917 = cljs.core.map.call(null,inst_60916,resp);
var inst_60918 = cljs.core.set.call(null,inst_60917);
var inst_61006 = cljs.core.async.chan.call(null,(1));
var inst_61007 = (function (){var ts = inst_60918;
var c__2768__auto____$1 = inst_61006;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61004){
var state_val_61005 = (state_61004[(1)]);
if((state_val_61005 === (7))){
var inst_60938 = (state_61004[(7)]);
var inst_60950 = (state_61004[(8)]);
var inst_60944 = (state_61004[(9)]);
var inst_60932 = (state_61004[(10)]);
var inst_60943 = (state_61004[(2)]);
var inst_60944__$1 = fluree.db.util.async.throw_err.call(null,inst_60943);
var inst_60946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60947 = [inst_60938,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60948 = (new cljs.core.PersistentVector(null,2,(5),inst_60946,inst_60947,null));
var inst_60949 = cljs.core.assoc_in.call(null,inst_60932,inst_60948,inst_60944__$1);
var inst_60950__$1 = auth;
var state_61004__$1 = (function (){var statearr_61135 = state_61004;
(statearr_61135[(8)] = inst_60950__$1);

(statearr_61135[(11)] = inst_60949);

(statearr_61135[(9)] = inst_60944__$1);

return statearr_61135;
})();
if(cljs.core.truth_(inst_60950__$1)){
var statearr_61136_61229 = state_61004__$1;
(statearr_61136_61229[(1)] = (8));

} else {
var statearr_61137_61230 = state_61004__$1;
(statearr_61137_61230[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (1))){
var inst_60926 = (state_61004[(12)]);
var inst_60926__$1 = ts;
var inst_60927 = cljs.core.seq.call(null,inst_60926__$1);
var inst_60928 = cljs.core.first.call(null,inst_60927);
var inst_60929 = cljs.core.next.call(null,inst_60927);
var inst_60930 = cljs.core.PersistentHashMap.EMPTY;
var inst_60931 = inst_60926__$1;
var inst_60932 = inst_60930;
var state_61004__$1 = (function (){var statearr_61138 = state_61004;
(statearr_61138[(13)] = inst_60928);

(statearr_61138[(14)] = inst_60931);

(statearr_61138[(12)] = inst_60926__$1);

(statearr_61138[(15)] = inst_60929);

(statearr_61138[(10)] = inst_60932);

return statearr_61138;
})();
var statearr_61139_61231 = state_61004__$1;
(statearr_61139_61231[(2)] = null);

(statearr_61139_61231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (4))){
var inst_60938 = (state_61004[(7)]);
var inst_60941 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_60938);
var state_61004__$1 = state_61004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61004__$1,(7),inst_60941);
} else {
if((state_val_61005 === (13))){
var inst_60939 = (state_61004[(16)]);
var inst_60996 = (state_61004[(2)]);
var inst_60931 = inst_60939;
var inst_60932 = inst_60996;
var state_61004__$1 = (function (){var statearr_61140 = state_61004;
(statearr_61140[(14)] = inst_60931);

(statearr_61140[(10)] = inst_60932);

return statearr_61140;
})();
var statearr_61141_61232 = state_61004__$1;
(statearr_61141_61232[(2)] = null);

(statearr_61141_61232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (6))){
var inst_61000 = (state_61004[(2)]);
var state_61004__$1 = state_61004;
var statearr_61142_61233 = state_61004__$1;
(statearr_61142_61233[(2)] = inst_61000);

(statearr_61142_61233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (3))){
var inst_61002 = (state_61004[(2)]);
var state_61004__$1 = state_61004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61004__$1,inst_61002);
} else {
if((state_val_61005 === (12))){
var inst_60949 = (state_61004[(11)]);
var state_61004__$1 = state_61004;
var statearr_61143_61234 = state_61004__$1;
(statearr_61143_61234[(2)] = inst_60949);

(statearr_61143_61234[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (2))){
var inst_60938 = (state_61004[(7)]);
var inst_60931 = (state_61004[(14)]);
var inst_60937 = cljs.core.seq.call(null,inst_60931);
var inst_60938__$1 = cljs.core.first.call(null,inst_60937);
var inst_60939 = cljs.core.next.call(null,inst_60937);
var state_61004__$1 = (function (){var statearr_61144 = state_61004;
(statearr_61144[(7)] = inst_60938__$1);

(statearr_61144[(16)] = inst_60939);

return statearr_61144;
})();
if(cljs.core.truth_(inst_60938__$1)){
var statearr_61145_61235 = state_61004__$1;
(statearr_61145_61235[(1)] = (4));

} else {
var statearr_61146_61236 = state_61004__$1;
(statearr_61146_61236[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (11))){
var inst_60938 = (state_61004[(7)]);
var inst_60928 = (state_61004[(13)]);
var inst_60931 = (state_61004[(14)]);
var inst_60926 = (state_61004[(12)]);
var inst_60949 = (state_61004[(11)]);
var inst_60929 = (state_61004[(15)]);
var inst_60944 = (state_61004[(9)]);
var inst_60939 = (state_61004[(16)]);
var inst_60932 = (state_61004[(10)]);
var inst_60956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60957 = [inst_60938,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60958 = (new cljs.core.PersistentVector(null,2,(5),inst_60956,inst_60957,null));
var inst_60971 = cljs.core.async.chan.call(null,(1));
var inst_60972 = (function (){var t = inst_60938;
var seq__60935 = inst_60939;
var first__60936 = inst_60938;
var first__60925 = inst_60928;
var block = inst_60944;
var r = inst_60939;
var acc = inst_60932;
var seq__60924 = inst_60929;
var vec__60934 = inst_60931;
var vec__60923 = inst_60926;
var c__2768__auto____$2 = inst_60971;
var G__60945 = inst_60949;
var G__60922 = inst_60931;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_60969){
var state_val_60970 = (state_60969[(1)]);
if((state_val_60970 === (1))){
var state_60969__$1 = state_60969;
var statearr_61147_61237 = state_60969__$1;
(statearr_61147_61237[(2)] = null);

(statearr_61147_61237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60970 === (2))){
var ___$1 = (function (){var statearr_61148 = state_60969;
(statearr_61148[(4)] = cljs.core.cons.call(null,(5),(state_60969[(4)])));

return statearr_61148;
})();
var ___$2 = (function (){var statearr_61149 = state_60969;
(statearr_61149[(4)] = cljs.core.rest.call(null,(state_60969[(4)])));

return statearr_61149;
})();
var state_60969__$1 = state_60969;
var statearr_61150_61238 = state_60969__$1;
(statearr_61150_61238[(2)] = db);

(statearr_61150_61238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60970 === (3))){
var inst_60967 = (state_60969[(2)]);
var state_60969__$1 = state_60969;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60969__$1,inst_60967);
} else {
if((state_val_60970 === (4))){
var inst_60959 = (state_60969[(2)]);
var state_60969__$1 = state_60969;
var statearr_61152_61239 = state_60969__$1;
(statearr_61152_61239[(2)] = inst_60959);

(statearr_61152_61239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60970 === (5))){
var ___$1 = (function (){var statearr_61153 = state_60969;
(statearr_61153[(4)] = cljs.core.rest.call(null,(state_60969[(4)])));

return statearr_61153;
})();
var state_60969__$1 = state_60969;
var ex61151 = (state_60969__$1[(2)]);
var statearr_61154_61240 = state_60969__$1;
(statearr_61154_61240[(5)] = ex61151);


if((ex61151 instanceof Error)){
var statearr_61155_61241 = state_60969__$1;
(statearr_61155_61241[(1)] = (4));

(statearr_61155_61241[(5)] = null);

} else {
throw ex61151;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_61156 = [null,null,null,null,null,null,null];
(statearr_61156[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_61156[(1)] = (1));

return statearr_61156;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_60969){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_60969);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61157){var ex__2749__auto__ = e61157;
var statearr_61158_61242 = state_60969;
(statearr_61158_61242[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_60969[(4)]))){
var statearr_61159_61243 = state_60969;
(statearr_61159_61243[(1)] = cljs.core.first.call(null,(state_60969[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61244 = state_60969;
state_60969 = G__61244;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_60969){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_60969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61160 = f__2769__auto__.call(null);
(statearr_61160[(6)] = c__2768__auto____$2);

return statearr_61160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_60973 = cljs.core.async.impl.dispatch.run.call(null,inst_60972);
var inst_60974 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_60975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60976 = ["?auth","?id"];
var inst_60977 = (new cljs.core.PersistentVector(null,2,(5),inst_60975,inst_60976,null));
var inst_60978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60980 = [inst_60938,"_tx/auth","?auth"];
var inst_60981 = (new cljs.core.PersistentVector(null,3,(5),inst_60979,inst_60980,null));
var inst_60982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60983 = ["?auth","_auth/id","?id"];
var inst_60984 = (new cljs.core.PersistentVector(null,3,(5),inst_60982,inst_60983,null));
var inst_60985 = [inst_60981,inst_60984];
var inst_60986 = (new cljs.core.PersistentVector(null,2,(5),inst_60978,inst_60985,null));
var inst_60987 = [inst_60977,inst_60986];
var inst_60988 = cljs.core.PersistentHashMap.fromArrays(inst_60974,inst_60987);
var inst_60989 = fluree.db.api.query.query_async.call(null,inst_60971,inst_60988);
var state_61004__$1 = (function (){var statearr_61161 = state_61004;
(statearr_61161[(17)] = inst_60973);

(statearr_61161[(18)] = inst_60958);

return statearr_61161;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61004__$1,(14),inst_60989);
} else {
if((state_val_61005 === (9))){
var state_61004__$1 = state_61004;
var statearr_61162_61245 = state_61004__$1;
(statearr_61162_61245[(2)] = show_auth);

(statearr_61162_61245[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (5))){
var inst_60932 = (state_61004[(10)]);
var state_61004__$1 = state_61004;
var statearr_61163_61246 = state_61004__$1;
(statearr_61163_61246[(2)] = inst_60932);

(statearr_61163_61246[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (14))){
var inst_60958 = (state_61004[(18)]);
var inst_60949 = (state_61004[(11)]);
var inst_60991 = (state_61004[(2)]);
var inst_60992 = fluree.db.util.async.throw_err.call(null,inst_60991);
var inst_60993 = cljs.core.assoc_in.call(null,inst_60949,inst_60958,inst_60992);
var state_61004__$1 = state_61004;
var statearr_61164_61247 = state_61004__$1;
(statearr_61164_61247[(2)] = inst_60993);

(statearr_61164_61247[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (10))){
var inst_60954 = (state_61004[(2)]);
var state_61004__$1 = state_61004;
if(cljs.core.truth_(inst_60954)){
var statearr_61165_61248 = state_61004__$1;
(statearr_61165_61248[(1)] = (11));

} else {
var statearr_61166_61249 = state_61004__$1;
(statearr_61166_61249[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61005 === (8))){
var inst_60950 = (state_61004[(8)]);
var state_61004__$1 = state_61004;
var statearr_61167_61250 = state_61004__$1;
(statearr_61167_61250[(2)] = inst_60950);

(statearr_61167_61250[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_61168 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61168[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_61168[(1)] = (1));

return statearr_61168;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_61004){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61169){var ex__2749__auto__ = e61169;
var statearr_61170_61251 = state_61004;
(statearr_61170_61251[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61004[(4)]))){
var statearr_61171_61252 = state_61004;
(statearr_61171_61252[(1)] = cljs.core.first.call(null,(state_61004[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61253 = state_61004;
state_61004 = G__61253;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_61004){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_61004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61172 = f__2769__auto__.call(null);
(statearr_61172[(6)] = c__2768__auto____$1);

return statearr_61172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_61008 = cljs.core.async.impl.dispatch.run.call(null,inst_61007);
var state_61104__$1 = (function (){var statearr_61173 = state_61104;
(statearr_61173[(20)] = inst_61008);

return statearr_61173;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61104__$1,(6),inst_61006);
} else {
if((state_val_61105 === (23))){
var inst_61062 = (state_61104[(2)]);
var state_61104__$1 = (function (){var statearr_61174 = state_61104;
(statearr_61174[(13)] = inst_61062);

return statearr_61174;
})();
var statearr_61175_61254 = state_61104__$1;
(statearr_61175_61254[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (35))){
var inst_61092 = (state_61104[(2)]);
var state_61104__$1 = state_61104;
var statearr_61177_61255 = state_61104__$1;
(statearr_61177_61255[(2)] = inst_61092);

(statearr_61177_61255[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (19))){
var state_61104__$1 = state_61104;
var statearr_61178_61256 = state_61104__$1;
(statearr_61178_61256[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (11))){
var inst_61043 = (state_61104[(2)]);
var state_61104__$1 = state_61104;
if(cljs.core.truth_(inst_61043)){
var statearr_61181_61257 = state_61104__$1;
(statearr_61181_61257[(1)] = (15));

} else {
var statearr_61182_61258 = state_61104__$1;
(statearr_61182_61258[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (9))){
var inst_61034 = (state_61104[(16)]);
var inst_61034__$1 = auth;
var state_61104__$1 = (function (){var statearr_61183 = state_61104;
(statearr_61183[(16)] = inst_61034__$1);

return statearr_61183;
})();
if(cljs.core.truth_(inst_61034__$1)){
var statearr_61184_61259 = state_61104__$1;
(statearr_61184_61259[(1)] = (12));

} else {
var statearr_61185_61260 = state_61104__$1;
(statearr_61185_61260[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (5))){
var _ = (function (){var statearr_61186 = state_61104;
(statearr_61186[(4)] = cljs.core.rest.call(null,(state_61104[(4)])));

return statearr_61186;
})();
var state_61104__$1 = state_61104;
var ex61180 = (state_61104__$1[(2)]);
var statearr_61187_61261 = state_61104__$1;
(statearr_61187_61261[(5)] = ex61180);


if((ex61180 instanceof Error)){
var statearr_61188_61262 = state_61104__$1;
(statearr_61188_61262[(1)] = (4));

(statearr_61188_61262[(5)] = null);

} else {
throw ex61180;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (14))){
var inst_61040 = (state_61104[(2)]);
var state_61104__$1 = state_61104;
var statearr_61189_61263 = state_61104__$1;
(statearr_61189_61263[(2)] = inst_61040);

(statearr_61189_61263[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (26))){
var inst_61070 = (state_61104[(2)]);
var state_61104__$1 = (function (){var statearr_61190 = state_61104;
(statearr_61190[(12)] = inst_61070);

return statearr_61190;
})();
var statearr_61191_61264 = state_61104__$1;
(statearr_61191_61264[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (16))){
var inst_61031 = (state_61104[(8)]);
var state_61104__$1 = state_61104;
if(cljs.core.truth_(inst_61031)){
var statearr_61193_61265 = state_61104__$1;
(statearr_61193_61265[(1)] = (18));

} else {
var statearr_61194_61266 = state_61104__$1;
(statearr_61194_61266[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (30))){
var inst_61052 = (state_61104[(11)]);
var inst_61078 = (state_61104[(15)]);
var inst_61053 = (state_61104[(21)]);
var inst_61080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61081 = [inst_61052,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61082 = (new cljs.core.PersistentVector(null,2,(5),inst_61080,inst_61081,null));
var inst_61083 = cljs.core.assoc_in.call(null,inst_61078,inst_61082,inst_61053);
var state_61104__$1 = state_61104;
var statearr_61195_61267 = state_61104__$1;
(statearr_61195_61267[(2)] = inst_61083);

(statearr_61195_61267[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (10))){
var inst_61031 = (state_61104[(8)]);
var state_61104__$1 = state_61104;
var statearr_61196_61268 = state_61104__$1;
(statearr_61196_61268[(2)] = inst_61031);

(statearr_61196_61268[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (18))){
var inst_61049 = (state_61104[(10)]);
var inst_61031 = (state_61104[(8)]);
var inst_61011 = (state_61104[(19)]);
var inst_61049__$1 = inst_61031.t;
var inst_61050 = cljs.core.get.call(null,inst_61011,inst_61049__$1);
var inst_61051 = cljs.core.__destructure_map.call(null,inst_61050);
var inst_61052 = cljs.core.get.call(null,inst_61051,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61053 = cljs.core.get.call(null,inst_61051,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_61104__$1 = (function (){var statearr_61197 = state_61104;
(statearr_61197[(10)] = inst_61049__$1);

(statearr_61197[(11)] = inst_61052);

(statearr_61197[(21)] = inst_61053);

return statearr_61197;
})();
var statearr_61198_61269 = state_61104__$1;
(statearr_61198_61269[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (8))){
var inst_61098 = (state_61104[(2)]);
var inst_61099 = cljs.core.vals.call(null,inst_61098);
var _ = (function (){var statearr_61200 = state_61104;
(statearr_61200[(4)] = cljs.core.rest.call(null,(state_61104[(4)])));

return statearr_61200;
})();
var state_61104__$1 = state_61104;
var statearr_61201_61270 = state_61104__$1;
(statearr_61201_61270[(2)] = inst_61099);

(statearr_61201_61270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_61202 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61202[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_61202[(1)] = (1));

return statearr_61202;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_61104){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61203){var ex__2749__auto__ = e61203;
var statearr_61204_61271 = state_61104;
(statearr_61204_61271[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61104[(4)]))){
var statearr_61205_61272 = state_61104;
(statearr_61205_61272[(1)] = cljs.core.first.call(null,(state_61104[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61273 = state_61104;
state_61104 = G__61273;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_61104){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_61104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61206 = f__2769__auto__.call(null);
(statearr_61206[(6)] = c__2768__auto__);

return statearr_61206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61400){
var state_val_61401 = (state_61400[(1)]);
if((state_val_61401 === (7))){
var inst_61296 = (state_61400[(7)]);
var inst_61298 = fluree.db.api.query.resolve_block_range.call(null,inst_61296,query_map);
var state_61400__$1 = state_61400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61400__$1,(10),inst_61298);
} else {
if((state_val_61401 === (20))){
var inst_61325 = (state_61400[(2)]);
var inst_61326 = fluree.db.util.async.throw_err.call(null,inst_61325);
var inst_61327 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61326);
var inst_61328 = (inst_61327 - (1));
var state_61400__$1 = state_61400;
var statearr_61402_61465 = state_61400__$1;
(statearr_61402_61465[(2)] = inst_61328);

(statearr_61402_61465[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (27))){
var state_61400__$1 = state_61400;
var statearr_61403_61466 = state_61400__$1;
(statearr_61403_61466[(2)] = null);

(statearr_61403_61466[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (1))){
var state_61400__$1 = state_61400;
var statearr_61404_61467 = state_61400__$1;
(statearr_61404_61467[(2)] = null);

(statearr_61404_61467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (24))){
var inst_61335 = (state_61400[(2)]);
var inst_61336 = fluree.db.util.async.throw_err.call(null,inst_61335);
var inst_61337 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61336);
var state_61400__$1 = state_61400;
var statearr_61405_61468 = state_61400__$1;
(statearr_61405_61468[(2)] = inst_61337);

(statearr_61405_61468[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (39))){
var inst_61372 = (state_61400[(2)]);
var inst_61373 = fluree.db.util.async.throw_err.call(null,inst_61372);
var state_61400__$1 = state_61400;
var statearr_61406_61469 = state_61400__$1;
(statearr_61406_61469[(2)] = inst_61373);

(statearr_61406_61469[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (4))){
var inst_61274 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
var statearr_61407_61470 = state_61400__$1;
(statearr_61407_61470[(2)] = inst_61274);

(statearr_61407_61470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (15))){
var inst_61305 = (state_61400[(8)]);
var state_61400__$1 = state_61400;
var statearr_61408_61471 = state_61400__$1;
(statearr_61408_61471[(2)] = inst_61305);

(statearr_61408_61471[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (21))){
var inst_61306 = (state_61400[(9)]);
var inst_61296 = (state_61400[(7)]);
var inst_61333 = fluree.db.time_travel.as_of_block.call(null,inst_61296,inst_61306);
var state_61400__$1 = state_61400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61400__$1,(24),inst_61333);
} else {
if((state_val_61401 === (31))){
var inst_61290 = (state_61400[(10)]);
var state_61400__$1 = state_61400;
var statearr_61409_61472 = state_61400__$1;
(statearr_61409_61472[(2)] = inst_61290);

(statearr_61409_61472[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (32))){
var inst_61356 = (state_61400[(11)]);
var inst_61296 = (state_61400[(7)]);
var inst_61351 = (state_61400[(12)]);
var inst_61360 = (state_61400[(2)]);
var inst_61361 = fluree.db.api.query.format_history_resp.call(null,inst_61296,inst_61351,inst_61356,inst_61360);
var state_61400__$1 = state_61400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61400__$1,(29),inst_61361);
} else {
if((state_val_61401 === (40))){
var inst_61377 = (state_61400[(13)]);
var inst_61351 = (state_61400[(12)]);
var inst_61379 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_61380 = cljs.core.count.call(null,inst_61351);
var inst_61381 = [inst_61377,inst_61380,(200)];
var inst_61382 = cljs.core.PersistentHashMap.fromArrays(inst_61379,inst_61381);
var state_61400__$1 = state_61400;
var statearr_61410_61473 = state_61400__$1;
(statearr_61410_61473[(2)] = inst_61382);

(statearr_61410_61473[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (33))){
var inst_61289 = (state_61400[(14)]);
var state_61400__$1 = state_61400;
var statearr_61411_61474 = state_61400__$1;
(statearr_61411_61474[(2)] = inst_61289);

(statearr_61411_61474[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (13))){
var inst_61395 = (state_61400[(2)]);
var _ = (function (){var statearr_61412 = state_61400;
(statearr_61412[(4)] = cljs.core.rest.call(null,(state_61400[(4)])));

return statearr_61412;
})();
var state_61400__$1 = state_61400;
var statearr_61413_61475 = state_61400__$1;
(statearr_61413_61475[(2)] = inst_61395);

(statearr_61413_61475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (22))){
var inst_61296 = (state_61400[(7)]);
var inst_61339 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61296);
var state_61400__$1 = state_61400;
var statearr_61414_61476 = state_61400__$1;
(statearr_61414_61476[(2)] = inst_61339);

(statearr_61414_61476[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (36))){
var inst_61296 = (state_61400[(7)]);
var inst_61364 = (state_61400[(15)]);
var inst_61370 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_61296,inst_61364);
var state_61400__$1 = state_61400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61400__$1,(39),inst_61370);
} else {
if((state_val_61401 === (41))){
var inst_61377 = (state_61400[(13)]);
var state_61400__$1 = state_61400;
var statearr_61415_61477 = state_61400__$1;
(statearr_61415_61477[(2)] = inst_61377);

(statearr_61415_61477[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (29))){
var inst_61289 = (state_61400[(14)]);
var inst_61363 = (state_61400[(2)]);
var inst_61364 = fluree.db.util.async.throw_err.call(null,inst_61363);
var state_61400__$1 = (function (){var statearr_61416 = state_61400;
(statearr_61416[(15)] = inst_61364);

return statearr_61416;
})();
if(cljs.core.truth_(inst_61289)){
var statearr_61417_61478 = state_61400__$1;
(statearr_61417_61478[(1)] = (33));

} else {
var statearr_61418_61479 = state_61400__$1;
(statearr_61418_61479[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (6))){
var inst_61286 = (state_61400[(16)]);
var inst_61295 = (state_61400[(2)]);
var inst_61296 = fluree.db.util.async.throw_err.call(null,inst_61295);
var state_61400__$1 = (function (){var statearr_61419 = state_61400;
(statearr_61419[(7)] = inst_61296);

return statearr_61419;
})();
if(cljs.core.truth_(inst_61286)){
var statearr_61420_61480 = state_61400__$1;
(statearr_61420_61480[(1)] = (7));

} else {
var statearr_61421_61481 = state_61400__$1;
(statearr_61421_61481[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (28))){
var inst_61291 = (state_61400[(17)]);
var inst_61356 = (state_61400[(2)]);
var state_61400__$1 = (function (){var statearr_61422 = state_61400;
(statearr_61422[(11)] = inst_61356);

return statearr_61422;
})();
if(cljs.core.truth_(inst_61291)){
var statearr_61423_61482 = state_61400__$1;
(statearr_61423_61482[(1)] = (30));

} else {
var statearr_61424_61483 = state_61400__$1;
(statearr_61424_61483[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (25))){
var inst_61292 = (state_61400[(18)]);
var inst_61350 = (state_61400[(2)]);
var inst_61351 = fluree.db.util.async.throw_err.call(null,inst_61350);
var state_61400__$1 = (function (){var statearr_61425 = state_61400;
(statearr_61425[(12)] = inst_61351);

return statearr_61425;
})();
if(cljs.core.truth_(inst_61292)){
var statearr_61426_61484 = state_61400__$1;
(statearr_61426_61484[(1)] = (26));

} else {
var statearr_61427_61485 = state_61400__$1;
(statearr_61427_61485[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (34))){
var inst_61288 = (state_61400[(19)]);
var state_61400__$1 = state_61400;
var statearr_61428_61486 = state_61400__$1;
(statearr_61428_61486[(2)] = inst_61288);

(statearr_61428_61486[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (17))){
var inst_61296 = (state_61400[(7)]);
var inst_61305 = (state_61400[(8)]);
var inst_61322 = (inst_61305 - (1));
var inst_61323 = fluree.db.time_travel.as_of_block.call(null,inst_61296,inst_61322);
var state_61400__$1 = state_61400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61400__$1,(20),inst_61323);
} else {
if((state_val_61401 === (3))){
var inst_61398 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61400__$1,inst_61398);
} else {
if((state_val_61401 === (12))){
var inst_61387 = cljs.core.pr_str.call(null,query_map);
var inst_61388 = ["History query not properly formatted. Provided ",inst_61387].join('');
var inst_61389 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61390 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61391 = cljs.core.PersistentHashMap.fromArrays(inst_61389,inst_61390);
var inst_61392 = cljs.core.ex_info.call(null,inst_61388,inst_61391);
var inst_61393 = (function(){throw inst_61392})();
var state_61400__$1 = state_61400;
var statearr_61429_61487 = state_61400__$1;
(statearr_61429_61487[(2)] = inst_61393);

(statearr_61429_61487[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (2))){
var _ = (function (){var statearr_61430 = state_61400;
(statearr_61430[(4)] = cljs.core.cons.call(null,(5),(state_61400[(4)])));

return statearr_61430;
})();
var inst_61284 = query_map;
var inst_61285 = cljs.core.__destructure_map.call(null,inst_61284);
var inst_61286 = cljs.core.get.call(null,inst_61285,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61287 = cljs.core.get.call(null,inst_61285,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61288 = cljs.core.get.call(null,inst_61285,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_61289 = cljs.core.get.call(null,inst_61285,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_61290 = cljs.core.get.call(null,inst_61285,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_61291 = cljs.core.get.call(null,inst_61285,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_61292 = cljs.core.get.call(null,inst_61285,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_61293 = cljs.core.get.call(null,inst_61285,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_61400__$1 = (function (){var statearr_61431 = state_61400;
(statearr_61431[(10)] = inst_61290);

(statearr_61431[(20)] = inst_61287);

(statearr_61431[(21)] = inst_61293);

(statearr_61431[(17)] = inst_61291);

(statearr_61431[(16)] = inst_61286);

(statearr_61431[(14)] = inst_61289);

(statearr_61431[(18)] = inst_61292);

(statearr_61431[(19)] = inst_61288);

return statearr_61431;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61400__$1,(6),sources);
} else {
if((state_val_61401 === (23))){
var inst_61287 = (state_61400[(20)]);
var inst_61296 = (state_61400[(7)]);
var inst_61331 = (state_61400[(22)]);
var inst_61341 = (state_61400[(2)]);
var inst_61342 = fluree.db.api.query.get_history_pattern.call(null,inst_61287);
var inst_61343 = cljs.core.nth.call(null,inst_61342,(0),null);
var inst_61344 = cljs.core.nth.call(null,inst_61342,(1),null);
var inst_61345 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_61346 = [inst_61331,inst_61341];
var inst_61347 = cljs.core.PersistentHashMap.fromArrays(inst_61345,inst_61346);
var inst_61348 = fluree.db.query.range.time_range.call(null,inst_61296,inst_61344,cljs.core._EQ_,inst_61343,inst_61347);
var state_61400__$1 = state_61400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61400__$1,(25),inst_61348);
} else {
if((state_val_61401 === (35))){
var inst_61368 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
if(cljs.core.truth_(inst_61368)){
var statearr_61432_61488 = state_61400__$1;
(statearr_61432_61488[(1)] = (36));

} else {
var statearr_61433_61489 = state_61400__$1;
(statearr_61433_61489[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (19))){
var inst_61306 = (state_61400[(9)]);
var inst_61331 = (state_61400[(2)]);
var state_61400__$1 = (function (){var statearr_61434 = state_61400;
(statearr_61434[(22)] = inst_61331);

return statearr_61434;
})();
if(cljs.core.truth_(inst_61306)){
var statearr_61435_61490 = state_61400__$1;
(statearr_61435_61490[(1)] = (21));

} else {
var statearr_61436_61491 = state_61400__$1;
(statearr_61436_61491[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (11))){
var inst_61293 = (state_61400[(21)]);
var inst_61305 = (state_61400[(8)]);
var inst_61315 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61293);
var state_61400__$1 = (function (){var statearr_61438 = state_61400;
(statearr_61438[(23)] = inst_61315);

return statearr_61438;
})();
if(cljs.core.truth_(inst_61305)){
var statearr_61439_61492 = state_61400__$1;
(statearr_61439_61492[(1)] = (14));

} else {
var statearr_61440_61493 = state_61400__$1;
(statearr_61440_61493[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (9))){
var inst_61304 = (state_61400[(2)]);
var inst_61305 = cljs.core.nth.call(null,inst_61304,(0),null);
var inst_61306 = cljs.core.nth.call(null,inst_61304,(1),null);
var inst_61307 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61308 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61309 = cljs.core.keys.call(null,inst_61308);
var inst_61310 = cljs.core._EQ_.call(null,inst_61307,inst_61309);
var state_61400__$1 = (function (){var statearr_61441 = state_61400;
(statearr_61441[(9)] = inst_61306);

(statearr_61441[(8)] = inst_61305);

return statearr_61441;
})();
if(inst_61310){
var statearr_61442_61494 = state_61400__$1;
(statearr_61442_61494[(1)] = (11));

} else {
var statearr_61443_61495 = state_61400__$1;
(statearr_61443_61495[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (5))){
var _ = (function (){var statearr_61444 = state_61400;
(statearr_61444[(4)] = cljs.core.rest.call(null,(state_61400[(4)])));

return statearr_61444;
})();
var state_61400__$1 = state_61400;
var ex61437 = (state_61400__$1[(2)]);
var statearr_61445_61496 = state_61400__$1;
(statearr_61445_61496[(5)] = ex61437);


if((ex61437 instanceof Error)){
var statearr_61446_61497 = state_61400__$1;
(statearr_61446_61497[(1)] = (4));

(statearr_61446_61497[(5)] = null);

} else {
throw ex61437;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (14))){
var inst_61305 = (state_61400[(8)]);
var inst_61317 = cljs.core.not_EQ_.call(null,(1),inst_61305);
var state_61400__$1 = state_61400;
var statearr_61447_61498 = state_61400__$1;
(statearr_61447_61498[(2)] = inst_61317);

(statearr_61447_61498[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (26))){
var inst_61292 = (state_61400[(18)]);
var inst_61353 = cljs.core.set.call(null,inst_61292);
var state_61400__$1 = state_61400;
var statearr_61448_61499 = state_61400__$1;
(statearr_61448_61499[(2)] = inst_61353);

(statearr_61448_61499[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (16))){
var inst_61320 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
if(cljs.core.truth_(inst_61320)){
var statearr_61449_61500 = state_61400__$1;
(statearr_61449_61500[(1)] = (17));

} else {
var statearr_61450_61501 = state_61400__$1;
(statearr_61450_61501[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (38))){
var inst_61315 = (state_61400[(23)]);
var inst_61377 = (state_61400[(2)]);
var state_61400__$1 = (function (){var statearr_61451 = state_61400;
(statearr_61451[(13)] = inst_61377);

return statearr_61451;
})();
if(cljs.core.truth_(inst_61315)){
var statearr_61452_61502 = state_61400__$1;
(statearr_61452_61502[(1)] = (40));

} else {
var statearr_61453_61503 = state_61400__$1;
(statearr_61453_61503[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (30))){
var inst_61291 = (state_61400[(17)]);
var state_61400__$1 = state_61400;
var statearr_61454_61504 = state_61400__$1;
(statearr_61454_61504[(2)] = inst_61291);

(statearr_61454_61504[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (10))){
var inst_61300 = (state_61400[(2)]);
var inst_61301 = fluree.db.util.async.throw_err.call(null,inst_61300);
var state_61400__$1 = state_61400;
var statearr_61455_61505 = state_61400__$1;
(statearr_61455_61505[(2)] = inst_61301);

(statearr_61455_61505[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (18))){
var state_61400__$1 = state_61400;
var statearr_61456_61506 = state_61400__$1;
(statearr_61456_61506[(2)] = (-1));

(statearr_61456_61506[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (42))){
var inst_61385 = (state_61400[(2)]);
var state_61400__$1 = state_61400;
var statearr_61457_61507 = state_61400__$1;
(statearr_61457_61507[(2)] = inst_61385);

(statearr_61457_61507[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (37))){
var inst_61364 = (state_61400[(15)]);
var inst_61375 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_61364);
var state_61400__$1 = state_61400;
var statearr_61458_61508 = state_61400__$1;
(statearr_61458_61508[(2)] = inst_61375);

(statearr_61458_61508[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61401 === (8))){
var state_61400__$1 = state_61400;
var statearr_61459_61509 = state_61400__$1;
(statearr_61459_61509[(2)] = null);

(statearr_61459_61509[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_61460 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61460[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2746__auto__);

(statearr_61460[(1)] = (1));

return statearr_61460;
});
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1 = (function (state_61400){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61461){var ex__2749__auto__ = e61461;
var statearr_61462_61510 = state_61400;
(statearr_61462_61510[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61400[(4)]))){
var statearr_61463_61511 = state_61400;
(statearr_61463_61511[(1)] = cljs.core.first.call(null,(state_61400[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61512 = state_61400;
state_61400 = G__61512;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = function(state_61400){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1.call(this,state_61400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61464 = f__2769__auto__.call(null);
(statearr_61464[(6)] = c__2768__auto__);

return statearr_61464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61645){
var state_val_61646 = (state_61645[(1)]);
if((state_val_61646 === (7))){
var inst_61542 = cljs.core.pr_str.call(null,flureeQL);
var inst_61543 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_61542].join('');
var inst_61544 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61545 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61546 = cljs.core.PersistentHashMap.fromArrays(inst_61544,inst_61545);
var inst_61547 = cljs.core.ex_info.call(null,inst_61543,inst_61546);
var inst_61548 = (function(){throw inst_61547})();
var state_61645__$1 = state_61645;
var statearr_61647_61726 = state_61645__$1;
(statearr_61647_61726[(2)] = inst_61548);

(statearr_61647_61726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (20))){
var inst_61580 = (state_61645[(2)]);
var state_61645__$1 = state_61645;
if(cljs.core.truth_(inst_61580)){
var statearr_61648_61727 = state_61645__$1;
(statearr_61648_61727[(1)] = (21));

} else {
var statearr_61649_61728 = state_61645__$1;
(statearr_61649_61728[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (27))){
var inst_61524 = (state_61645[(7)]);
var state_61645__$1 = state_61645;
var statearr_61650_61729 = state_61645__$1;
(statearr_61650_61729[(2)] = inst_61524);

(statearr_61650_61729[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (1))){
var state_61645__$1 = state_61645;
var statearr_61651_61730 = state_61645__$1;
(statearr_61651_61730[(2)] = null);

(statearr_61651_61730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (24))){
var inst_61586 = (state_61645[(8)]);
var state_61645__$1 = state_61645;
var statearr_61652_61731 = state_61645__$1;
(statearr_61652_61731[(2)] = inst_61586);

(statearr_61652_61731[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (39))){
var inst_61530 = (state_61645[(9)]);
var state_61645__$1 = state_61645;
if(cljs.core.truth_(inst_61530)){
var statearr_61653_61732 = state_61645__$1;
(statearr_61653_61732[(1)] = (42));

} else {
var statearr_61654_61733 = state_61645__$1;
(statearr_61654_61733[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (46))){
var inst_61618 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61619 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61620 = cljs.core.PersistentHashMap.fromArrays(inst_61618,inst_61619);
var inst_61621 = cljs.core.ex_info.call(null,"Invalid query.",inst_61620);
var inst_61622 = (function(){throw inst_61621})();
var state_61645__$1 = state_61645;
var statearr_61655_61734 = state_61645__$1;
(statearr_61655_61734[(2)] = inst_61622);

(statearr_61655_61734[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (4))){
var inst_61514 = (state_61645[(2)]);
var state_61645__$1 = state_61645;
var statearr_61656_61735 = state_61645__$1;
(statearr_61656_61735[(2)] = inst_61514);

(statearr_61656_61735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (15))){
var inst_61527 = (state_61645[(10)]);
var inst_61565 = (state_61645[(11)]);
var inst_61567 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_61565);
var inst_61568 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_61565);
var inst_61569 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_61565);
var inst_61570 = fluree.db.api.query.get_sources.call(null,inst_61567,inst_61568,inst_61569,inst_61527);
var state_61645__$1 = state_61645;
var statearr_61657_61736 = state_61645__$1;
(statearr_61657_61736[(2)] = inst_61570);

(statearr_61657_61736[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (48))){
var inst_61575 = (state_61645[(12)]);
var inst_61629 = (state_61645[(2)]);
var inst_61630 = fluree.db.util.async.throw_err.call(null,inst_61629);
var state_61645__$1 = (function (){var statearr_61658 = state_61645;
(statearr_61658[(13)] = inst_61630);

return statearr_61658;
})();
if(cljs.core.truth_(inst_61575)){
var statearr_61659_61737 = state_61645__$1;
(statearr_61659_61737[(1)] = (49));

} else {
var statearr_61660_61738 = state_61645__$1;
(statearr_61660_61738[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (50))){
var inst_61630 = (state_61645[(13)]);
var state_61645__$1 = state_61645;
var statearr_61661_61739 = state_61645__$1;
(statearr_61661_61739[(2)] = inst_61630);

(statearr_61661_61739[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (21))){
var inst_61582 = cljs.core.volatile_BANG_.call(null,(0));
var state_61645__$1 = state_61645;
var statearr_61662_61740 = state_61645__$1;
(statearr_61662_61740[(2)] = inst_61582);

(statearr_61662_61740[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (31))){
var inst_61528 = (state_61645[(14)]);
var state_61645__$1 = state_61645;
if(cljs.core.truth_(inst_61528)){
var statearr_61663_61741 = state_61645__$1;
(statearr_61663_61741[(1)] = (33));

} else {
var statearr_61664_61742 = state_61645__$1;
(statearr_61664_61742[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (32))){
var inst_61605 = (state_61645[(2)]);
var state_61645__$1 = state_61645;
var statearr_61665_61743 = state_61645__$1;
(statearr_61665_61743[(2)] = inst_61605);

(statearr_61665_61743[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (40))){
var inst_61607 = (state_61645[(15)]);
var state_61645__$1 = state_61645;
var statearr_61666_61744 = state_61645__$1;
(statearr_61666_61744[(2)] = inst_61607);

(statearr_61666_61744[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (33))){
var inst_61528 = (state_61645[(14)]);
var state_61645__$1 = state_61645;
var statearr_61667_61745 = state_61645__$1;
(statearr_61667_61745[(2)] = inst_61528);

(statearr_61667_61745[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (13))){
var inst_61525 = (state_61645[(16)]);
var inst_61554 = (state_61645[(2)]);
var inst_61555 = fluree.db.util.async.throw_err.call(null,inst_61554);
var inst_61556 = fluree.db.time_travel.as_of_block.call(null,inst_61555,inst_61525);
var state_61645__$1 = state_61645;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61645__$1,(12),inst_61556);
} else {
if((state_val_61646 === (22))){
var state_61645__$1 = state_61645;
var statearr_61668_61746 = state_61645__$1;
(statearr_61668_61746[(2)] = null);

(statearr_61668_61746[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (36))){
var inst_61532 = (state_61645[(17)]);
var state_61645__$1 = state_61645;
var statearr_61669_61747 = state_61645__$1;
(statearr_61669_61747[(2)] = inst_61532);

(statearr_61669_61747[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (41))){
var inst_61615 = (state_61645[(2)]);
var state_61645__$1 = state_61645;
if(cljs.core.truth_(inst_61615)){
var statearr_61670_61748 = state_61645__$1;
(statearr_61670_61748[(1)] = (45));

} else {
var statearr_61671_61749 = state_61645__$1;
(statearr_61671_61749[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (43))){
var inst_61526 = (state_61645[(18)]);
var state_61645__$1 = state_61645;
var statearr_61672_61750 = state_61645__$1;
(statearr_61672_61750[(2)] = inst_61526);

(statearr_61672_61750[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (29))){
var inst_61607 = (state_61645[(15)]);
var inst_61607__$1 = (state_61645[(2)]);
var state_61645__$1 = (function (){var statearr_61673 = state_61645;
(statearr_61673[(15)] = inst_61607__$1);

return statearr_61673;
})();
if(cljs.core.truth_(inst_61607__$1)){
var statearr_61674_61751 = state_61645__$1;
(statearr_61674_61751[(1)] = (39));

} else {
var statearr_61675_61752 = state_61645__$1;
(statearr_61675_61752[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (44))){
var inst_61612 = (state_61645[(2)]);
var state_61645__$1 = state_61645;
var statearr_61676_61753 = state_61645__$1;
(statearr_61676_61753[(2)] = inst_61612);

(statearr_61676_61753[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (6))){
var state_61645__$1 = state_61645;
var statearr_61677_61754 = state_61645__$1;
(statearr_61677_61754[(2)] = null);

(statearr_61677_61754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (28))){
var inst_61529 = (state_61645[(19)]);
var state_61645__$1 = state_61645;
if(cljs.core.truth_(inst_61529)){
var statearr_61678_61755 = state_61645__$1;
(statearr_61678_61755[(1)] = (30));

} else {
var statearr_61679_61756 = state_61645__$1;
(statearr_61679_61756[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (51))){
var inst_61640 = (state_61645[(2)]);
var _ = (function (){var statearr_61680 = state_61645;
(statearr_61680[(4)] = cljs.core.rest.call(null,(state_61645[(4)])));

return statearr_61680;
})();
var state_61645__$1 = state_61645;
var statearr_61681_61757 = state_61645__$1;
(statearr_61681_61757[(2)] = inst_61640);

(statearr_61681_61757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (25))){
var state_61645__$1 = state_61645;
var statearr_61682_61758 = state_61645__$1;
(statearr_61682_61758[(2)] = (1000000));

(statearr_61682_61758[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (34))){
var inst_61532 = (state_61645[(17)]);
var state_61645__$1 = state_61645;
if(cljs.core.truth_(inst_61532)){
var statearr_61683_61759 = state_61645__$1;
(statearr_61683_61759[(1)] = (36));

} else {
var statearr_61684_61760 = state_61645__$1;
(statearr_61684_61760[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (17))){
var inst_61576 = (state_61645[(20)]);
var inst_61531 = (state_61645[(21)]);
var inst_61574 = (state_61645[(2)]);
var inst_61575 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61531);
var inst_61576__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61531);
var state_61645__$1 = (function (){var statearr_61685 = state_61645;
(statearr_61685[(12)] = inst_61575);

(statearr_61685[(20)] = inst_61576__$1);

(statearr_61685[(22)] = inst_61574);

return statearr_61685;
})();
if(cljs.core.truth_(inst_61576__$1)){
var statearr_61686_61761 = state_61645__$1;
(statearr_61686_61761[(1)] = (18));

} else {
var statearr_61687_61762 = state_61645__$1;
(statearr_61687_61762[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (3))){
var inst_61643 = (state_61645[(2)]);
var state_61645__$1 = state_61645;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61645__$1,inst_61643);
} else {
if((state_val_61646 === (12))){
var inst_61558 = (state_61645[(2)]);
var inst_61559 = fluree.db.util.async.throw_err.call(null,inst_61558);
var state_61645__$1 = state_61645;
var statearr_61688_61763 = state_61645__$1;
(statearr_61688_61763[(2)] = inst_61559);

(statearr_61688_61763[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (2))){
var inst_61527 = (state_61645[(10)]);
var inst_61532 = (state_61645[(17)]);
var inst_61525 = (state_61645[(16)]);
var inst_61526 = (state_61645[(18)]);
var inst_61529 = (state_61645[(19)]);
var inst_61523 = (state_61645[(23)]);
var inst_61524 = (state_61645[(7)]);
var inst_61528 = (state_61645[(14)]);
var inst_61530 = (state_61645[(9)]);
var inst_61531 = (state_61645[(21)]);
var _ = (function (){var statearr_61689 = state_61645;
(statearr_61689[(4)] = cljs.core.cons.call(null,(5),(state_61645[(4)])));

return statearr_61689;
})();
var inst_61521 = flureeQL;
var inst_61522 = cljs.core.__destructure_map.call(null,inst_61521);
var inst_61523__$1 = cljs.core.get.call(null,inst_61522,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_61524__$1 = cljs.core.get.call(null,inst_61522,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_61525__$1 = cljs.core.get.call(null,inst_61522,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61526__$1 = cljs.core.get.call(null,inst_61522,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_61527__$1 = cljs.core.get.call(null,inst_61522,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_61528__$1 = cljs.core.get.call(null,inst_61522,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_61529__$1 = cljs.core.get.call(null,inst_61522,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_61530__$1 = cljs.core.get.call(null,inst_61522,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_61531__$1 = cljs.core.get.call(null,inst_61522,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61532__$1 = cljs.core.get.call(null,inst_61522,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_61533 = (function (){var construct = inst_61523__$1;
var select = inst_61524__$1;
var block = inst_61525__$1;
var where = inst_61526__$1;
var map__61520 = inst_61522;
var prefixes = inst_61527__$1;
var selectDistinct = inst_61528__$1;
var selectOne = inst_61529__$1;
var from = inst_61530__$1;
var opts = inst_61531__$1;
var selectReduced = inst_61532__$1;
return (function (p1__61513_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__61513_SHARP_);
});
})();
var inst_61534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61535 = [inst_61524__$1,inst_61529__$1,inst_61528__$1,inst_61532__$1];
var inst_61536 = (new cljs.core.PersistentVector(null,4,(5),inst_61534,inst_61535,null));
var inst_61537 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_61536);
var inst_61538 = cljs.core.count.call(null,inst_61537);
var inst_61539 = inst_61533.call(null,inst_61538);
var state_61645__$1 = (function (){var statearr_61690 = state_61645;
(statearr_61690[(10)] = inst_61527__$1);

(statearr_61690[(17)] = inst_61532__$1);

(statearr_61690[(16)] = inst_61525__$1);

(statearr_61690[(18)] = inst_61526__$1);

(statearr_61690[(19)] = inst_61529__$1);

(statearr_61690[(23)] = inst_61523__$1);

(statearr_61690[(7)] = inst_61524__$1);

(statearr_61690[(14)] = inst_61528__$1);

(statearr_61690[(9)] = inst_61530__$1);

(statearr_61690[(21)] = inst_61531__$1);

return statearr_61690;
})();
if(cljs.core.truth_(inst_61539)){
var statearr_61691_61764 = state_61645__$1;
(statearr_61691_61764[(1)] = (6));

} else {
var statearr_61692_61765 = state_61645__$1;
(statearr_61692_61765[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (23))){
var inst_61586 = (state_61645[(8)]);
var inst_61531 = (state_61645[(21)]);
var inst_61585 = (state_61645[(2)]);
var inst_61586__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61531);
var state_61645__$1 = (function (){var statearr_61693 = state_61645;
(statearr_61693[(8)] = inst_61586__$1);

(statearr_61693[(24)] = inst_61585);

return statearr_61693;
})();
if(cljs.core.truth_(inst_61586__$1)){
var statearr_61694_61766 = state_61645__$1;
(statearr_61694_61766[(1)] = (24));

} else {
var statearr_61695_61767 = state_61645__$1;
(statearr_61695_61767[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (47))){
var inst_61591 = (state_61645[(25)]);
var inst_61565 = (state_61645[(11)]);
var inst_61624 = (state_61645[(2)]);
var inst_61625 = fluree.db.util.core.current_time_millis.call(null);
var inst_61626 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_61591);
var inst_61627 = fluree.db.query.fql.query.call(null,inst_61565,inst_61626);
var state_61645__$1 = (function (){var statearr_61696 = state_61645;
(statearr_61696[(26)] = inst_61625);

(statearr_61696[(27)] = inst_61624);

return statearr_61696;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61645__$1,(48),inst_61627);
} else {
if((state_val_61646 === (35))){
var inst_61603 = (state_61645[(2)]);
var state_61645__$1 = state_61645;
var statearr_61697_61768 = state_61645__$1;
(statearr_61697_61768[(2)] = inst_61603);

(statearr_61697_61768[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (19))){
var inst_61575 = (state_61645[(12)]);
var state_61645__$1 = state_61645;
var statearr_61698_61769 = state_61645__$1;
(statearr_61698_61769[(2)] = inst_61575);

(statearr_61698_61769[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (11))){
var inst_61527 = (state_61645[(10)]);
var inst_61565 = (state_61645[(2)]);
var state_61645__$1 = (function (){var statearr_61700 = state_61645;
(statearr_61700[(11)] = inst_61565);

return statearr_61700;
})();
if(cljs.core.truth_(inst_61527)){
var statearr_61701_61770 = state_61645__$1;
(statearr_61701_61770[(1)] = (15));

} else {
var statearr_61702_61771 = state_61645__$1;
(statearr_61702_61771[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (9))){
var inst_61551 = (state_61645[(28)]);
var state_61645__$1 = state_61645;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61645__$1,(13),inst_61551);
} else {
if((state_val_61646 === (5))){
var _ = (function (){var statearr_61703 = state_61645;
(statearr_61703[(4)] = cljs.core.rest.call(null,(state_61645[(4)])));

return statearr_61703;
})();
var state_61645__$1 = state_61645;
var ex61699 = (state_61645__$1[(2)]);
var statearr_61704_61772 = state_61645__$1;
(statearr_61704_61772[(5)] = ex61699);


if((ex61699 instanceof Error)){
var statearr_61705_61773 = state_61645__$1;
(statearr_61705_61773[(1)] = (4));

(statearr_61705_61773[(5)] = null);

} else {
throw ex61699;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (14))){
var inst_61562 = (state_61645[(2)]);
var inst_61563 = fluree.db.util.async.throw_err.call(null,inst_61562);
var state_61645__$1 = state_61645;
var statearr_61706_61774 = state_61645__$1;
(statearr_61706_61774[(2)] = inst_61563);

(statearr_61706_61774[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (45))){
var state_61645__$1 = state_61645;
var statearr_61707_61775 = state_61645__$1;
(statearr_61707_61775[(2)] = null);

(statearr_61707_61775[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (26))){
var inst_61574 = (state_61645[(22)]);
var inst_61524 = (state_61645[(7)]);
var inst_61585 = (state_61645[(24)]);
var inst_61531 = (state_61645[(21)]);
var inst_61590 = (state_61645[(2)]);
var inst_61591 = cljs.core.assoc.call(null,inst_61531,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_61574,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_61590,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_61585);
var state_61645__$1 = (function (){var statearr_61708 = state_61645;
(statearr_61708[(25)] = inst_61591);

return statearr_61708;
})();
if(cljs.core.truth_(inst_61524)){
var statearr_61709_61776 = state_61645__$1;
(statearr_61709_61776[(1)] = (27));

} else {
var statearr_61710_61777 = state_61645__$1;
(statearr_61710_61777[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (16))){
var inst_61572 = cljs.core.PersistentHashMap.EMPTY;
var state_61645__$1 = state_61645;
var statearr_61711_61778 = state_61645__$1;
(statearr_61711_61778[(2)] = inst_61572);

(statearr_61711_61778[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (38))){
var inst_61601 = (state_61645[(2)]);
var state_61645__$1 = state_61645;
var statearr_61712_61779 = state_61645__$1;
(statearr_61712_61779[(2)] = inst_61601);

(statearr_61712_61779[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (30))){
var inst_61529 = (state_61645[(19)]);
var state_61645__$1 = state_61645;
var statearr_61713_61780 = state_61645__$1;
(statearr_61713_61780[(2)] = inst_61529);

(statearr_61713_61780[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (10))){
var inst_61551 = (state_61645[(28)]);
var state_61645__$1 = state_61645;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61645__$1,(14),inst_61551);
} else {
if((state_val_61646 === (18))){
var inst_61576 = (state_61645[(20)]);
var state_61645__$1 = state_61645;
var statearr_61714_61781 = state_61645__$1;
(statearr_61714_61781[(2)] = inst_61576);

(statearr_61714_61781[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (42))){
var inst_61530 = (state_61645[(9)]);
var state_61645__$1 = state_61645;
var statearr_61715_61782 = state_61645__$1;
(statearr_61715_61782[(2)] = inst_61530);

(statearr_61715_61782[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (37))){
var inst_61523 = (state_61645[(23)]);
var state_61645__$1 = state_61645;
var statearr_61716_61783 = state_61645__$1;
(statearr_61716_61783[(2)] = inst_61523);

(statearr_61716_61783[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (8))){
var inst_61525 = (state_61645[(16)]);
var inst_61550 = (state_61645[(2)]);
var inst_61551 = sources;
var state_61645__$1 = (function (){var statearr_61717 = state_61645;
(statearr_61717[(29)] = inst_61550);

(statearr_61717[(28)] = inst_61551);

return statearr_61717;
})();
if(cljs.core.truth_(inst_61525)){
var statearr_61718_61784 = state_61645__$1;
(statearr_61718_61784[(1)] = (9));

} else {
var statearr_61719_61785 = state_61645__$1;
(statearr_61719_61785[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61646 === (49))){
var inst_61625 = (state_61645[(26)]);
var inst_61565 = (state_61645[(11)]);
var inst_61585 = (state_61645[(24)]);
var inst_61630 = (state_61645[(13)]);
var inst_61632 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61633 = cljs.core.deref.call(null,inst_61585);
var inst_61634 = fluree.db.util.core.response_time_formatted.call(null,inst_61625);
var inst_61635 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_61565);
var inst_61636 = [(200),inst_61630,inst_61633,inst_61634,inst_61635];
var inst_61637 = cljs.core.PersistentHashMap.fromArrays(inst_61632,inst_61636);
var state_61645__$1 = state_61645;
var statearr_61720_61786 = state_61645__$1;
(statearr_61720_61786[(2)] = inst_61637);

(statearr_61720_61786[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_61721 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61721[(0)] = fluree$db$api$query$query_async_$_state_machine__2746__auto__);

(statearr_61721[(1)] = (1));

return statearr_61721;
});
var fluree$db$api$query$query_async_$_state_machine__2746__auto____1 = (function (state_61645){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61645);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61722){var ex__2749__auto__ = e61722;
var statearr_61723_61787 = state_61645;
(statearr_61723_61787[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61645[(4)]))){
var statearr_61724_61788 = state_61645;
(statearr_61724_61788[(1)] = cljs.core.first.call(null,(state_61645[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61789 = state_61645;
state_61645 = G__61789;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2746__auto__ = function(state_61645){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____1.call(this,state_61645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61725 = f__2769__auto__.call(null);
(statearr_61725[(6)] = c__2768__auto__);

return statearr_61725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61930){
var state_val_61931 = (state_61930[(1)]);
if((state_val_61931 === (7))){
var inst_61925 = (state_61930[(2)]);
var _ = (function (){var statearr_61932 = state_61930;
(statearr_61932[(4)] = cljs.core.rest.call(null,(state_61930[(4)])));

return statearr_61932;
})();
var state_61930__$1 = state_61930;
var statearr_61933_62009 = state_61930__$1;
(statearr_61933_62009[(2)] = inst_61925);

(statearr_61933_62009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (20))){
var inst_61897 = (state_61930[(2)]);
var state_61930__$1 = state_61930;
var statearr_61934_62010 = state_61930__$1;
(statearr_61934_62010[(2)] = inst_61897);

(statearr_61934_62010[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (27))){
var inst_61877 = (state_61930[(7)]);
var state_61930__$1 = state_61930;
var statearr_61935_62011 = state_61930__$1;
(statearr_61935_62011[(2)] = inst_61877);

(statearr_61935_62011[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (1))){
var state_61930__$1 = state_61930;
var statearr_61936_62012 = state_61930__$1;
(statearr_61936_62012[(2)] = null);

(statearr_61936_62012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (24))){
var inst_61874 = (state_61930[(8)]);
var state_61930__$1 = state_61930;
var statearr_61937_62013 = state_61930__$1;
(statearr_61937_62013[(2)] = inst_61874);

(statearr_61937_62013[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (39))){
var inst_61864 = (state_61930[(9)]);
var inst_61842 = (state_61930[(10)]);
var inst_61831 = (state_61930[(11)]);
var inst_61908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61909 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_61842];
var inst_61910 = (new cljs.core.PersistentVector(null,2,(5),inst_61908,inst_61909,null));
var inst_61911 = cljs.core.assoc_in.call(null,inst_61831,inst_61910,inst_61864);
var state_61930__$1 = state_61930;
var statearr_61938_62014 = state_61930__$1;
(statearr_61938_62014[(2)] = inst_61911);

(statearr_61938_62014[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (4))){
var inst_61790 = (state_61930[(2)]);
var state_61930__$1 = state_61930;
var statearr_61939_62015 = state_61930__$1;
(statearr_61939_62015[(2)] = inst_61790);

(statearr_61939_62015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (15))){
var inst_61864 = (state_61930[(9)]);
var inst_61829 = (state_61930[(12)]);
var inst_61867 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_61864);
var inst_61868 = (inst_61829 == null);
var state_61930__$1 = (function (){var statearr_61940 = state_61930;
(statearr_61940[(13)] = inst_61867);

return statearr_61940;
})();
if(cljs.core.truth_(inst_61868)){
var statearr_61941_62016 = state_61930__$1;
(statearr_61941_62016[(1)] = (18));

} else {
var statearr_61942_62017 = state_61930__$1;
(statearr_61942_62017[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (21))){
var inst_61867 = (state_61930[(13)]);
var state_61930__$1 = state_61930;
var statearr_61943_62018 = state_61930__$1;
(statearr_61943_62018[(2)] = inst_61867);

(statearr_61943_62018[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (31))){
var state_61930__$1 = state_61930;
var statearr_61944_62019 = state_61930__$1;
(statearr_61944_62019[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (32))){
var inst_61893 = (state_61930[(2)]);
var state_61930__$1 = state_61930;
var statearr_61946_62020 = state_61930__$1;
(statearr_61946_62020[(2)] = inst_61893);

(statearr_61946_62020[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (40))){
var inst_61862 = (state_61930[(14)]);
var state_61930__$1 = state_61930;
if(cljs.core.truth_(inst_61862)){
var statearr_61947_62021 = state_61930__$1;
(statearr_61947_62021[(1)] = (42));

} else {
var statearr_61948_62022 = state_61930__$1;
(statearr_61948_62022[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (33))){
var inst_61867 = (state_61930[(13)]);
var inst_61829 = (state_61930[(12)]);
var inst_61888 = ((inst_61867 > inst_61829) ? inst_61867 : inst_61829);
var state_61930__$1 = state_61930;
var statearr_61949_62023 = state_61930__$1;
(statearr_61949_62023[(2)] = inst_61888);

(statearr_61949_62023[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (13))){
var inst_61853 = (state_61930[(2)]);
var state_61930__$1 = state_61930;
var statearr_61950_62024 = state_61930__$1;
(statearr_61950_62024[(2)] = inst_61853);

(statearr_61950_62024[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (22))){
var inst_61874 = (state_61930[(8)]);
var inst_61867 = (state_61930[(13)]);
var inst_61874__$1 = cljs.core._EQ_.call(null,(200),inst_61867);
var state_61930__$1 = (function (){var statearr_61951 = state_61930;
(statearr_61951[(8)] = inst_61874__$1);

return statearr_61951;
})();
if(inst_61874__$1){
var statearr_61952_62025 = state_61930__$1;
(statearr_61952_62025[(1)] = (24));

} else {
var statearr_61953_62026 = state_61930__$1;
(statearr_61953_62026[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (36))){
var inst_61830 = (state_61930[(15)]);
var inst_61864 = (state_61930[(9)]);
var inst_61902 = cljs.core.get.call(null,inst_61864,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_61903 = (inst_61830 + inst_61902);
var state_61930__$1 = state_61930;
var statearr_61954_62027 = state_61930__$1;
(statearr_61954_62027[(2)] = inst_61903);

(statearr_61954_62027[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (41))){
var inst_61906 = (state_61930[(16)]);
var inst_61900 = (state_61930[(17)]);
var inst_61841 = (state_61930[(18)]);
var inst_61920 = (state_61930[(2)]);
var inst_61828 = inst_61841;
var inst_61829 = inst_61900;
var inst_61830 = inst_61906;
var inst_61831 = inst_61920;
var state_61930__$1 = (function (){var statearr_61955 = state_61930;
(statearr_61955[(15)] = inst_61830);

(statearr_61955[(19)] = inst_61828);

(statearr_61955[(11)] = inst_61831);

(statearr_61955[(12)] = inst_61829);

return statearr_61955;
})();
var statearr_61956_62028 = state_61930__$1;
(statearr_61956_62028[(2)] = null);

(statearr_61956_62028[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (43))){
var inst_61864 = (state_61930[(9)]);
var state_61930__$1 = state_61930;
var statearr_61957_62029 = state_61930__$1;
(statearr_61957_62029[(2)] = inst_61864);

(statearr_61957_62029[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (29))){
var inst_61882 = (state_61930[(2)]);
var state_61930__$1 = state_61930;
var statearr_61958_62030 = state_61930__$1;
(statearr_61958_62030[(2)] = inst_61882);

(statearr_61958_62030[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (44))){
var inst_61842 = (state_61930[(10)]);
var inst_61831 = (state_61930[(11)]);
var inst_61917 = (state_61930[(2)]);
var inst_61918 = cljs.core.assoc.call(null,inst_61831,inst_61842,inst_61917);
var state_61930__$1 = state_61930;
var statearr_61959_62031 = state_61930__$1;
(statearr_61959_62031[(2)] = inst_61918);

(statearr_61959_62031[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (6))){
var inst_61828 = (state_61930[(19)]);
var inst_61843 = (state_61930[(20)]);
var inst_61839 = cljs.core.seq.call(null,inst_61828);
var inst_61840 = cljs.core.first.call(null,inst_61839);
var inst_61841 = cljs.core.next.call(null,inst_61839);
var inst_61842 = cljs.core.nth.call(null,inst_61840,(0),null);
var inst_61843__$1 = cljs.core.nth.call(null,inst_61840,(1),null);
var inst_61844 = (inst_61843__$1 == null);
var state_61930__$1 = (function (){var statearr_61960 = state_61930;
(statearr_61960[(18)] = inst_61841);

(statearr_61960[(20)] = inst_61843__$1);

(statearr_61960[(10)] = inst_61842);

return statearr_61960;
})();
if(cljs.core.truth_(inst_61844)){
var statearr_61961_62032 = state_61930__$1;
(statearr_61961_62032[(1)] = (8));

} else {
var statearr_61962_62033 = state_61930__$1;
(statearr_61962_62033[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (28))){
var inst_61829 = (state_61930[(12)]);
var inst_61880 = cljs.core._EQ_.call(null,(207),inst_61829);
var state_61930__$1 = state_61930;
var statearr_61963_62034 = state_61930__$1;
(statearr_61963_62034[(2)] = inst_61880);

(statearr_61963_62034[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (25))){
var inst_61877 = (state_61930[(7)]);
var inst_61829 = (state_61930[(12)]);
var inst_61877__$1 = cljs.core._EQ_.call(null,(200),inst_61829);
var state_61930__$1 = (function (){var statearr_61964 = state_61930;
(statearr_61964[(7)] = inst_61877__$1);

return statearr_61964;
})();
if(inst_61877__$1){
var statearr_61965_62035 = state_61930__$1;
(statearr_61965_62035[(1)] = (27));

} else {
var statearr_61966_62036 = state_61930__$1;
(statearr_61966_62036[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (34))){
var state_61930__$1 = state_61930;
var statearr_61967_62037 = state_61930__$1;
(statearr_61967_62037[(2)] = null);

(statearr_61967_62037[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (17))){
var inst_61861 = (state_61930[(21)]);
var inst_61900 = (state_61930[(2)]);
var state_61930__$1 = (function (){var statearr_61968 = state_61930;
(statearr_61968[(17)] = inst_61900);

return statearr_61968;
})();
if(cljs.core.truth_(inst_61861)){
var statearr_61969_62038 = state_61930__$1;
(statearr_61969_62038[(1)] = (36));

} else {
var statearr_61970_62039 = state_61930__$1;
(statearr_61970_62039[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (3))){
var inst_61928 = (state_61930[(2)]);
var state_61930__$1 = state_61930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61930__$1,inst_61928);
} else {
if((state_val_61931 === (12))){
var inst_61831 = (state_61930[(11)]);
var state_61930__$1 = state_61930;
var statearr_61971_62040 = state_61930__$1;
(statearr_61971_62040[(2)] = inst_61831);

(statearr_61971_62040[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (2))){
var inst_61800 = (state_61930[(22)]);
var inst_61805 = (state_61930[(23)]);
var inst_61804 = (state_61930[(24)]);
var _ = (function (){var statearr_61972 = state_61930;
(statearr_61972[(4)] = cljs.core.cons.call(null,(5),(state_61930[(4)])));

return statearr_61972;
})();
var inst_61796 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_61797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61798 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_61799 = (new cljs.core.PersistentVector(null,2,(5),inst_61797,inst_61798,null));
var inst_61800__$1 = cljs.core.get_in.call(null,flureeQL,inst_61799);
var inst_61801 = (function (){var global_block = inst_61796;
var global_meta_QMARK_ = inst_61800__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_61802 = cljs.core.PersistentHashMap.EMPTY;
var inst_61803 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_61804__$1 = cljs.core.reduce_kv.call(null,inst_61801,inst_61802,inst_61803);
var inst_61805__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_61807 = (function (){var global_block = inst_61796;
var global_meta_QMARK_ = inst_61800__$1;
var queries = inst_61804__$1;
var start_time = inst_61805__$1;
return (function (p__61806){
var vec__61973 = p__61806;
var alias = cljs.core.nth.call(null,vec__61973,(0),null);
var q = cljs.core.nth.call(null,vec__61973,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_61808 = cljs.core.map.call(null,inst_61807,inst_61804__$1);
var inst_61822 = cljs.core.seq.call(null,inst_61808);
var inst_61823 = cljs.core.first.call(null,inst_61822);
var inst_61824 = cljs.core.next.call(null,inst_61822);
var inst_61825 = cljs.core.nth.call(null,inst_61823,(0),null);
var inst_61826 = cljs.core.nth.call(null,inst_61823,(1),null);
var inst_61827 = cljs.core.PersistentHashMap.EMPTY;
var inst_61828 = inst_61808;
var inst_61829 = null;
var inst_61830 = (0);
var inst_61831 = inst_61827;
var state_61930__$1 = (function (){var statearr_61976 = state_61930;
(statearr_61976[(25)] = inst_61826);

(statearr_61976[(26)] = inst_61824);

(statearr_61976[(27)] = inst_61825);

(statearr_61976[(15)] = inst_61830);

(statearr_61976[(19)] = inst_61828);

(statearr_61976[(22)] = inst_61800__$1);

(statearr_61976[(23)] = inst_61805__$1);

(statearr_61976[(24)] = inst_61804__$1);

(statearr_61976[(11)] = inst_61831);

(statearr_61976[(12)] = inst_61829);

return statearr_61976;
})();
var statearr_61977_62041 = state_61930__$1;
(statearr_61977_62041[(2)] = null);

(statearr_61977_62041[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (23))){
var inst_61895 = (state_61930[(2)]);
var state_61930__$1 = state_61930;
var statearr_61978_62042 = state_61930__$1;
(statearr_61978_62042[(2)] = inst_61895);

(statearr_61978_62042[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (35))){
var inst_61891 = (state_61930[(2)]);
var state_61930__$1 = state_61930;
var statearr_61979_62043 = state_61930__$1;
(statearr_61979_62043[(2)] = inst_61891);

(statearr_61979_62043[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (19))){
var inst_61867 = (state_61930[(13)]);
var inst_61829 = (state_61930[(12)]);
var inst_61871 = cljs.core._EQ_.call(null,inst_61829,inst_61867);
var state_61930__$1 = state_61930;
if(inst_61871){
var statearr_61980_62044 = state_61930__$1;
(statearr_61980_62044[(1)] = (21));

} else {
var statearr_61981_62045 = state_61930__$1;
(statearr_61981_62045[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (11))){
var inst_61830 = (state_61930[(15)]);
var inst_61805 = (state_61930[(23)]);
var inst_61831 = (state_61930[(11)]);
var inst_61829 = (state_61930[(12)]);
var inst_61847 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61848 = fluree.db.util.core.response_time_formatted.call(null,inst_61805);
var inst_61849 = [inst_61831,inst_61830,inst_61829,inst_61848];
var inst_61850 = cljs.core.PersistentHashMap.fromArrays(inst_61847,inst_61849);
var state_61930__$1 = state_61930;
var statearr_61983_62046 = state_61930__$1;
(statearr_61983_62046[(2)] = inst_61850);

(statearr_61983_62046[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (9))){
var inst_61843 = (state_61930[(20)]);
var inst_61842 = (state_61930[(10)]);
var inst_61804 = (state_61930[(24)]);
var inst_61856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61857 = [inst_61842,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_61858 = (new cljs.core.PersistentVector(null,2,(5),inst_61856,inst_61857,null));
var inst_61859 = cljs.core.get_in.call(null,inst_61804,inst_61858);
var inst_61860 = cljs.core.__destructure_map.call(null,inst_61859);
var inst_61861 = cljs.core.get.call(null,inst_61860,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_61862 = cljs.core.get.call(null,inst_61860,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_61930__$1 = (function (){var statearr_61984 = state_61930;
(statearr_61984[(14)] = inst_61862);

(statearr_61984[(21)] = inst_61861);

return statearr_61984;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61930__$1,(14),inst_61843);
} else {
if((state_val_61931 === (5))){
var _ = (function (){var statearr_61985 = state_61930;
(statearr_61985[(4)] = cljs.core.rest.call(null,(state_61930[(4)])));

return statearr_61985;
})();
var state_61930__$1 = state_61930;
var ex61982 = (state_61930__$1[(2)]);
var statearr_61986_62047 = state_61930__$1;
(statearr_61986_62047[(5)] = ex61982);


var statearr_61987_62048 = state_61930__$1;
(statearr_61987_62048[(1)] = (4));

(statearr_61987_62048[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (14))){
var inst_61864 = (state_61930[(9)]);
var inst_61861 = (state_61930[(21)]);
var inst_61864__$1 = (state_61930[(2)]);
var inst_61865 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_61864__$1);
var state_61930__$1 = (function (){var statearr_61988 = state_61930;
(statearr_61988[(9)] = inst_61864__$1);

(statearr_61988[(28)] = inst_61865);

return statearr_61988;
})();
if(cljs.core.truth_(inst_61861)){
var statearr_61989_62049 = state_61930__$1;
(statearr_61989_62049[(1)] = (15));

} else {
var statearr_61990_62050 = state_61930__$1;
(statearr_61990_62050[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (26))){
var inst_61884 = (state_61930[(2)]);
var state_61930__$1 = state_61930;
if(cljs.core.truth_(inst_61884)){
var statearr_61991_62051 = state_61930__$1;
(statearr_61991_62051[(1)] = (30));

} else {
var statearr_61992_62052 = state_61930__$1;
(statearr_61992_62052[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (16))){
var state_61930__$1 = state_61930;
var statearr_61993_62053 = state_61930__$1;
(statearr_61993_62053[(2)] = null);

(statearr_61993_62053[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (38))){
var inst_61865 = (state_61930[(28)]);
var inst_61906 = (state_61930[(2)]);
var state_61930__$1 = (function (){var statearr_61994 = state_61930;
(statearr_61994[(16)] = inst_61906);

return statearr_61994;
})();
if(cljs.core.truth_(inst_61865)){
var statearr_61995_62054 = state_61930__$1;
(statearr_61995_62054[(1)] = (39));

} else {
var statearr_61996_62055 = state_61930__$1;
(statearr_61996_62055[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (30))){
var state_61930__$1 = state_61930;
var statearr_61997_62056 = state_61930__$1;
(statearr_61997_62056[(2)] = (207));

(statearr_61997_62056[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (10))){
var inst_61923 = (state_61930[(2)]);
var state_61930__$1 = state_61930;
var statearr_61998_62057 = state_61930__$1;
(statearr_61998_62057[(2)] = inst_61923);

(statearr_61998_62057[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (18))){
var inst_61867 = (state_61930[(13)]);
var state_61930__$1 = state_61930;
var statearr_61999_62058 = state_61930__$1;
(statearr_61999_62058[(2)] = inst_61867);

(statearr_61999_62058[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (42))){
var inst_61864 = (state_61930[(9)]);
var inst_61914 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_61864);
var state_61930__$1 = state_61930;
var statearr_62000_62059 = state_61930__$1;
(statearr_62000_62059[(2)] = inst_61914);

(statearr_62000_62059[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (37))){
var state_61930__$1 = state_61930;
var statearr_62001_62060 = state_61930__$1;
(statearr_62001_62060[(2)] = null);

(statearr_62001_62060[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61931 === (8))){
var inst_61800 = (state_61930[(22)]);
var state_61930__$1 = state_61930;
if(cljs.core.truth_(inst_61800)){
var statearr_62002_62061 = state_61930__$1;
(statearr_62002_62061[(1)] = (11));

} else {
var statearr_62003_62062 = state_61930__$1;
(statearr_62003_62062[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_62004 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62004[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__);

(statearr_62004[(1)] = (1));

return statearr_62004;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1 = (function (state_61930){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62005){var ex__2749__auto__ = e62005;
var statearr_62006_62063 = state_61930;
(statearr_62006_62063[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61930[(4)]))){
var statearr_62007_62064 = state_61930;
(statearr_62007_62064[(1)] = cljs.core.first.call(null,(state_61930[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62065 = state_61930;
state_61930 = G__62065;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = function(state_61930){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1.call(this,state_61930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62008 = f__2769__auto__.call(null);
(statearr_62008[(6)] = c__2768__auto__);

return statearr_62008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__62066 = query_type;
var G__62066__$1 = (((G__62066 instanceof cljs.core.Keyword))?G__62066.fqn:null);
switch (G__62066__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__62066__$1)].join('')));

}
});
