// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__67847 = arguments.length;
switch (G__67847) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___67886 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67868){
var state_val_67869 = (state_67868[(1)]);
if((state_val_67869 === (1))){
var state_67868__$1 = state_67868;
var statearr_67870_67887 = state_67868__$1;
(statearr_67870_67887[(2)] = null);

(statearr_67870_67887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67869 === (2))){
var _ = (function (){var statearr_67871 = state_67868;
(statearr_67871[(4)] = cljs.core.cons.call(null,(5),(state_67868[(4)])));

return statearr_67871;
})();
var inst_67854 = fluree.db.session.db.call(null,conn,ledger,null);
var state_67868__$1 = state_67868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67868__$1,(7),inst_67854);
} else {
if((state_val_67869 === (3))){
var inst_67864 = (state_67868[(2)]);
var inst_67865 = cljs.core.async.put_BANG_.call(null,pc,inst_67864);
var inst_67866 = cljs.core.async.close_BANG_.call(null,pc);
var state_67868__$1 = (function (){var statearr_67873 = state_67868;
(statearr_67873[(7)] = inst_67865);

return statearr_67873;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67868__$1,inst_67866);
} else {
if((state_val_67869 === (4))){
var inst_67848 = (state_67868[(2)]);
var state_67868__$1 = state_67868;
var statearr_67874_67888 = state_67868__$1;
(statearr_67874_67888[(2)] = inst_67848);

(statearr_67874_67888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67869 === (5))){
var _ = (function (){var statearr_67875 = state_67868;
(statearr_67875[(4)] = cljs.core.rest.call(null,(state_67868[(4)])));

return statearr_67875;
})();
var state_67868__$1 = state_67868;
var ex67872 = (state_67868__$1[(2)]);
var statearr_67876_67889 = state_67868__$1;
(statearr_67876_67889[(5)] = ex67872);


var statearr_67877_67890 = state_67868__$1;
(statearr_67877_67890[(1)] = (4));

(statearr_67877_67890[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67869 === (6))){
var inst_67860 = (state_67868[(2)]);
var inst_67861 = fluree.db.util.async.throw_err.call(null,inst_67860);
var _ = (function (){var statearr_67878 = state_67868;
(statearr_67878[(4)] = cljs.core.rest.call(null,(state_67868[(4)])));

return statearr_67878;
})();
var state_67868__$1 = state_67868;
var statearr_67879_67891 = state_67868__$1;
(statearr_67879_67891[(2)] = inst_67861);

(statearr_67879_67891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67869 === (7))){
var inst_67856 = (state_67868[(2)]);
var inst_67857 = fluree.db.util.async.throw_err.call(null,inst_67856);
var inst_67858 = fluree.db.time_travel.as_of_block.call(null,inst_67857,block);
var state_67868__$1 = state_67868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67868__$1,(6),inst_67858);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_67880 = [null,null,null,null,null,null,null,null];
(statearr_67880[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_67880[(1)] = (1));

return statearr_67880;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_67868){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67881){var ex__2749__auto__ = e67881;
var statearr_67882_67892 = state_67868;
(statearr_67882_67892[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67868[(4)]))){
var statearr_67883_67893 = state_67868;
(statearr_67883_67893[(1)] = cljs.core.first.call(null,(state_67868[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67894 = state_67868;
state_67868 = G__67894;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_67868){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_67868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67884 = f__2769__auto__.call(null);
(statearr_67884[(6)] = c__2768__auto___67886);

return statearr_67884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67935){
var state_val_67936 = (state_67935[(1)]);
if((state_val_67936 === (7))){
var inst_67904 = cljs.core._EQ_.call(null,(0),auth);
var state_67935__$1 = state_67935;
if(inst_67904){
var statearr_67937_67968 = state_67935__$1;
(statearr_67937_67968[(1)] = (9));

} else {
var statearr_67938_67969 = state_67935__$1;
(statearr_67938_67969[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (1))){
var state_67935__$1 = state_67935;
var statearr_67939_67970 = state_67935__$1;
(statearr_67939_67970[(2)] = null);

(statearr_67939_67970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (4))){
var inst_67895 = (state_67935[(2)]);
var state_67935__$1 = state_67935;
var statearr_67940_67971 = state_67935__$1;
(statearr_67940_67971[(2)] = inst_67895);

(statearr_67940_67971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (15))){
var inst_67912 = (state_67935[(7)]);
var inst_67911 = (state_67935[(2)]);
var inst_67912__$1 = fluree.db.util.async.throw_err.call(null,inst_67911);
var state_67935__$1 = (function (){var statearr_67941 = state_67935;
(statearr_67941[(7)] = inst_67912__$1);

return statearr_67941;
})();
if(cljs.core.truth_(inst_67912__$1)){
var statearr_67942_67972 = state_67935__$1;
(statearr_67942_67972[(1)] = (16));

} else {
var statearr_67943_67973 = state_67935__$1;
(statearr_67943_67973[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (13))){
var state_67935__$1 = state_67935;
var statearr_67944_67974 = state_67935__$1;
(statearr_67944_67974[(2)] = null);

(statearr_67944_67974[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (6))){
var state_67935__$1 = state_67935;
var statearr_67945_67975 = state_67935__$1;
(statearr_67945_67975[(2)] = db);

(statearr_67945_67975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (17))){
var inst_67916 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_67917 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67918 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_67919 = cljs.core.PersistentHashMap.fromArrays(inst_67917,inst_67918);
var inst_67920 = cljs.core.ex_info.call(null,inst_67916,inst_67919);
var inst_67921 = (function(){throw inst_67920})();
var state_67935__$1 = state_67935;
var statearr_67946_67976 = state_67935__$1;
(statearr_67946_67976[(2)] = inst_67921);

(statearr_67946_67976[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (3))){
var inst_67933 = (state_67935[(2)]);
var state_67935__$1 = state_67935;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67935__$1,inst_67933);
} else {
if((state_val_67936 === (12))){
var inst_67909 = fluree.db.dbproto._subid.call(null,db,auth);
var state_67935__$1 = state_67935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67935__$1,(15),inst_67909);
} else {
if((state_val_67936 === (2))){
var _ = (function (){var statearr_67947 = state_67935;
(statearr_67947[(4)] = cljs.core.cons.call(null,(5),(state_67935[(4)])));

return statearr_67947;
})();
var inst_67901 = cljs.core.not.call(null,auth);
var state_67935__$1 = state_67935;
if(inst_67901){
var statearr_67948_67977 = state_67935__$1;
(statearr_67948_67977[(1)] = (6));

} else {
var statearr_67949_67978 = state_67935__$1;
(statearr_67949_67978[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (11))){
var inst_67928 = (state_67935[(2)]);
var state_67935__$1 = state_67935;
var statearr_67951_67979 = state_67935__$1;
(statearr_67951_67979[(2)] = inst_67928);

(statearr_67951_67979[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (9))){
var inst_67906 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_67935__$1 = state_67935;
var statearr_67952_67980 = state_67935__$1;
(statearr_67952_67980[(2)] = inst_67906);

(statearr_67952_67980[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (5))){
var _ = (function (){var statearr_67953 = state_67935;
(statearr_67953[(4)] = cljs.core.rest.call(null,(state_67935[(4)])));

return statearr_67953;
})();
var state_67935__$1 = state_67935;
var ex67950 = (state_67935__$1[(2)]);
var statearr_67954_67981 = state_67935__$1;
(statearr_67954_67981[(5)] = ex67950);


if((ex67950 instanceof Error)){
var statearr_67955_67982 = state_67935__$1;
(statearr_67955_67982[(1)] = (4));

(statearr_67955_67982[(5)] = null);

} else {
throw ex67950;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (14))){
var inst_67926 = (state_67935[(2)]);
var state_67935__$1 = state_67935;
var statearr_67956_67983 = state_67935__$1;
(statearr_67956_67983[(2)] = inst_67926);

(statearr_67956_67983[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (16))){
var inst_67912 = (state_67935[(7)]);
var inst_67914 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_67912);
var state_67935__$1 = state_67935;
var statearr_67957_67984 = state_67935__$1;
(statearr_67957_67984[(2)] = inst_67914);

(statearr_67957_67984[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (10))){
var state_67935__$1 = state_67935;
var statearr_67958_67985 = state_67935__$1;
(statearr_67958_67985[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (18))){
var inst_67923 = (state_67935[(2)]);
var state_67935__$1 = state_67935;
var statearr_67960_67986 = state_67935__$1;
(statearr_67960_67986[(2)] = inst_67923);

(statearr_67960_67986[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67936 === (8))){
var inst_67930 = (state_67935[(2)]);
var _ = (function (){var statearr_67961 = state_67935;
(statearr_67961[(4)] = cljs.core.rest.call(null,(state_67935[(4)])));

return statearr_67961;
})();
var state_67935__$1 = state_67935;
var statearr_67962_67987 = state_67935__$1;
(statearr_67962_67987[(2)] = inst_67930);

(statearr_67962_67987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0 = (function (){
var statearr_67963 = [null,null,null,null,null,null,null,null];
(statearr_67963[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__);

(statearr_67963[(1)] = (1));

return statearr_67963;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1 = (function (state_67935){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67935);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67964){var ex__2749__auto__ = e67964;
var statearr_67965_67988 = state_67935;
(statearr_67965_67988[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67935[(4)]))){
var statearr_67966_67989 = state_67935;
(statearr_67966_67989[(1)] = cljs.core.first.call(null,(state_67935[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67990 = state_67935;
state_67935 = G__67990;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = function(state_67935){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1.call(this,state_67935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67967 = f__2769__auto__.call(null);
(statearr_67967[(6)] = c__2768__auto__);

return statearr_67967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68054){
var state_val_68055 = (state_68054[(1)]);
if((state_val_68055 === (7))){
var inst_68000 = cljs.core._EQ_.call(null,(0),auth);
var state_68054__$1 = state_68054;
if(inst_68000){
var statearr_68056_68105 = state_68054__$1;
(statearr_68056_68105[(1)] = (9));

} else {
var statearr_68057_68106 = state_68054__$1;
(statearr_68057_68106[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (20))){
var inst_68024 = (state_68054[(7)]);
var state_68054__$1 = state_68054;
if(cljs.core.truth_(inst_68024)){
var statearr_68058_68107 = state_68054__$1;
(statearr_68058_68107[(1)] = (22));

} else {
var statearr_68059_68108 = state_68054__$1;
(statearr_68059_68108[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (27))){
var state_68054__$1 = state_68054;
var statearr_68060_68109 = state_68054__$1;
(statearr_68060_68109[(2)] = null);

(statearr_68060_68109[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (1))){
var state_68054__$1 = state_68054;
var statearr_68061_68110 = state_68054__$1;
(statearr_68061_68110[(2)] = null);

(statearr_68061_68110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (24))){
var inst_68038 = (state_68054[(2)]);
var state_68054__$1 = state_68054;
var statearr_68062_68111 = state_68054__$1;
(statearr_68062_68111[(2)] = inst_68038);

(statearr_68062_68111[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (4))){
var inst_67991 = (state_68054[(2)]);
var state_68054__$1 = state_68054;
var statearr_68063_68112 = state_68054__$1;
(statearr_68063_68112[(2)] = inst_67991);

(statearr_68063_68112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (15))){
var inst_68007 = (state_68054[(8)]);
var inst_68006 = (state_68054[(2)]);
var inst_68007__$1 = fluree.db.util.async.throw_err.call(null,inst_68006);
var state_68054__$1 = (function (){var statearr_68064 = state_68054;
(statearr_68064[(8)] = inst_68007__$1);

return statearr_68064;
})();
if(cljs.core.truth_(inst_68007__$1)){
var statearr_68065_68113 = state_68054__$1;
(statearr_68065_68113[(1)] = (16));

} else {
var statearr_68066_68114 = state_68054__$1;
(statearr_68066_68114[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (21))){
var inst_68040 = (state_68054[(9)]);
var inst_68040__$1 = (state_68054[(2)]);
var state_68054__$1 = (function (){var statearr_68067 = state_68054;
(statearr_68067[(9)] = inst_68040__$1);

return statearr_68067;
})();
if(cljs.core.truth_(inst_68040__$1)){
var statearr_68068_68115 = state_68054__$1;
(statearr_68068_68115[(1)] = (29));

} else {
var statearr_68069_68116 = state_68054__$1;
(statearr_68069_68116[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (31))){
var inst_68040 = (state_68054[(9)]);
var inst_68024 = (state_68054[(7)]);
var inst_68048 = (state_68054[(2)]);
var inst_68049 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_68024,new cljs.core.Keyword(null,"roles","roles",143379530),inst_68040,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_68048);
var _ = (function (){var statearr_68070 = state_68054;
(statearr_68070[(4)] = cljs.core.rest.call(null,(state_68054[(4)])));

return statearr_68070;
})();
var state_68054__$1 = state_68054;
var statearr_68071_68117 = state_68054__$1;
(statearr_68071_68117[(2)] = inst_68049);

(statearr_68071_68117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (32))){
var inst_68044 = (state_68054[(2)]);
var inst_68045 = fluree.db.util.async.throw_err.call(null,inst_68044);
var state_68054__$1 = state_68054;
var statearr_68072_68118 = state_68054__$1;
(statearr_68072_68118[(2)] = inst_68045);

(statearr_68072_68118[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (13))){
var state_68054__$1 = state_68054;
var statearr_68073_68119 = state_68054__$1;
(statearr_68073_68119[(2)] = null);

(statearr_68073_68119[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (22))){
var inst_68024 = (state_68054[(7)]);
var inst_68028 = fluree.db.auth.roles.call(null,db,inst_68024);
var state_68054__$1 = state_68054;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68054__$1,(25),inst_68028);
} else {
if((state_val_68055 === (29))){
var inst_68040 = (state_68054[(9)]);
var inst_68042 = fluree.db.permissions.permission_map.call(null,db,inst_68040,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_68054__$1 = state_68054;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68054__$1,(32),inst_68042);
} else {
if((state_val_68055 === (6))){
var state_68054__$1 = state_68054;
var statearr_68074_68120 = state_68054__$1;
(statearr_68074_68120[(2)] = null);

(statearr_68074_68120[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (28))){
var inst_68036 = (state_68054[(2)]);
var state_68054__$1 = state_68054;
var statearr_68075_68121 = state_68054__$1;
(statearr_68075_68121[(2)] = inst_68036);

(statearr_68075_68121[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (25))){
var inst_68030 = (state_68054[(2)]);
var inst_68031 = fluree.db.util.async.throw_err.call(null,inst_68030);
var state_68054__$1 = state_68054;
var statearr_68076_68122 = state_68054__$1;
(statearr_68076_68122[(2)] = inst_68031);

(statearr_68076_68122[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (17))){
var inst_68010 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_68011 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68012 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_68013 = cljs.core.PersistentHashMap.fromArrays(inst_68011,inst_68012);
var inst_68014 = cljs.core.ex_info.call(null,inst_68010,inst_68013);
var inst_68015 = (function(){throw inst_68014})();
var state_68054__$1 = state_68054;
var statearr_68077_68123 = state_68054__$1;
(statearr_68077_68123[(2)] = inst_68015);

(statearr_68077_68123[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (3))){
var inst_68052 = (state_68054[(2)]);
var state_68054__$1 = state_68054;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68054__$1,inst_68052);
} else {
if((state_val_68055 === (12))){
var inst_68004 = fluree.db.dbproto._subid.call(null,db,auth);
var state_68054__$1 = state_68054;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68054__$1,(15),inst_68004);
} else {
if((state_val_68055 === (2))){
var _ = (function (){var statearr_68078 = state_68054;
(statearr_68078[(4)] = cljs.core.cons.call(null,(5),(state_68054[(4)])));

return statearr_68078;
})();
var inst_67997 = (auth == null);
var state_68054__$1 = state_68054;
if(cljs.core.truth_(inst_67997)){
var statearr_68079_68124 = state_68054__$1;
(statearr_68079_68124[(1)] = (6));

} else {
var statearr_68080_68125 = state_68054__$1;
(statearr_68080_68125[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (23))){
var state_68054__$1 = state_68054;
var statearr_68081_68126 = state_68054__$1;
(statearr_68081_68126[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (19))){
var state_68054__$1 = state_68054;
var statearr_68083_68127 = state_68054__$1;
(statearr_68083_68127[(2)] = roles);

(statearr_68083_68127[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (11))){
var inst_68022 = (state_68054[(2)]);
var state_68054__$1 = state_68054;
var statearr_68085_68128 = state_68054__$1;
(statearr_68085_68128[(2)] = inst_68022);

(statearr_68085_68128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (9))){
var state_68054__$1 = state_68054;
var statearr_68086_68129 = state_68054__$1;
(statearr_68086_68129[(2)] = (0));

(statearr_68086_68129[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (5))){
var _ = (function (){var statearr_68087 = state_68054;
(statearr_68087[(4)] = cljs.core.rest.call(null,(state_68054[(4)])));

return statearr_68087;
})();
var state_68054__$1 = state_68054;
var ex68084 = (state_68054__$1[(2)]);
var statearr_68088_68130 = state_68054__$1;
(statearr_68088_68130[(5)] = ex68084);


if((ex68084 instanceof Error)){
var statearr_68089_68131 = state_68054__$1;
(statearr_68089_68131[(1)] = (4));

(statearr_68089_68131[(5)] = null);

} else {
throw ex68084;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (14))){
var inst_68020 = (state_68054[(2)]);
var state_68054__$1 = state_68054;
var statearr_68090_68132 = state_68054__$1;
(statearr_68090_68132[(2)] = inst_68020);

(statearr_68090_68132[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (26))){
var state_68054__$1 = state_68054;
var statearr_68091_68133 = state_68054__$1;
(statearr_68091_68133[(2)] = null);

(statearr_68091_68133[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (16))){
var inst_68007 = (state_68054[(8)]);
var state_68054__$1 = state_68054;
var statearr_68092_68134 = state_68054__$1;
(statearr_68092_68134[(2)] = inst_68007);

(statearr_68092_68134[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (30))){
var state_68054__$1 = state_68054;
var statearr_68093_68135 = state_68054__$1;
(statearr_68093_68135[(2)] = null);

(statearr_68093_68135[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (10))){
var state_68054__$1 = state_68054;
if(cljs.core.truth_(auth)){
var statearr_68094_68136 = state_68054__$1;
(statearr_68094_68136[(1)] = (12));

} else {
var statearr_68095_68137 = state_68054__$1;
(statearr_68095_68137[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (18))){
var inst_68017 = (state_68054[(2)]);
var state_68054__$1 = state_68054;
var statearr_68096_68138 = state_68054__$1;
(statearr_68096_68138[(2)] = inst_68017);

(statearr_68096_68138[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68055 === (8))){
var inst_68024 = (state_68054[(2)]);
var state_68054__$1 = (function (){var statearr_68097 = state_68054;
(statearr_68097[(7)] = inst_68024);

return statearr_68097;
})();
if(cljs.core.truth_(roles)){
var statearr_68098_68139 = state_68054__$1;
(statearr_68098_68139[(1)] = (19));

} else {
var statearr_68099_68140 = state_68054__$1;
(statearr_68099_68140[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0 = (function (){
var statearr_68100 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68100[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__);

(statearr_68100[(1)] = (1));

return statearr_68100;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1 = (function (state_68054){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68054);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68101){var ex__2749__auto__ = e68101;
var statearr_68102_68141 = state_68054;
(statearr_68102_68141[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68054[(4)]))){
var statearr_68103_68142 = state_68054;
(statearr_68103_68142[(1)] = cljs.core.first.call(null,(state_68054[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68143 = state_68054;
state_68054 = G__68143;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = function(state_68054){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1.call(this,state_68054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68104 = f__2769__auto__.call(null);
(statearr_68104[(6)] = c__2768__auto__);

return statearr_68104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__68144 = db;
var map__68144__$1 = cljs.core.__destructure_map.call(null,map__68144);
var conn = cljs.core.get.call(null,map__68144__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__68144__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__68144__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.call(null,"NEW EVENT:",cljs.core.pr_str.call(null,evt),cljs.core.pr_str.call(null,data));

if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68151){
var state_val_68152 = (state_68151[(1)]);
if((state_val_68152 === (1))){
var inst_68145 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_68146 = fluree.db.session.db.call(null,conn,inst_68145,null);
var state_68151__$1 = state_68151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68151__$1,(2),inst_68146);
} else {
if((state_val_68152 === (2))){
var inst_68148 = (state_68151[(2)]);
var inst_68149 = cljs.core.async.put_BANG_.call(null,resp_port,inst_68148);
var state_68151__$1 = state_68151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68151__$1,inst_68149);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_68153 = [null,null,null,null,null,null,null];
(statearr_68153[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_68153[(1)] = (1));

return statearr_68153;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_68151){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68154){var ex__2749__auto__ = e68154;
var statearr_68155_68182 = state_68151;
(statearr_68155_68182[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68151[(4)]))){
var statearr_68156_68183 = state_68151;
(statearr_68156_68183[(1)] = cljs.core.first.call(null,(state_68151[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68184 = state_68151;
state_68151 = G__68184;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_68151){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_68151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68157 = f__2769__auto__.call(null);
(statearr_68157[(6)] = c__2768__auto__);

return statearr_68157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,dbid,listen_id,event_fn);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68170){
var state_val_68171 = (state_68170[(1)]);
if((state_val_68171 === (1))){
var inst_68158 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_68159 = fluree.db.session.db.call(null,conn,inst_68158,null);
var state_68170__$1 = state_68170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68170__$1,(2),inst_68159);
} else {
if((state_val_68171 === (2))){
var inst_68161 = (state_68170[(7)]);
var inst_68161__$1 = (state_68170[(2)]);
var inst_68162 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_68161__$1);
var inst_68163 = newer_block_QMARK_.call(null,inst_68162);
var state_68170__$1 = (function (){var statearr_68172 = state_68170;
(statearr_68172[(7)] = inst_68161__$1);

return statearr_68172;
})();
if(inst_68163){
var statearr_68173_68185 = state_68170__$1;
(statearr_68173_68185[(1)] = (3));

} else {
var statearr_68174_68186 = state_68170__$1;
(statearr_68174_68186[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68171 === (3))){
var inst_68161 = (state_68170[(7)]);
var inst_68165 = cljs.core.async.put_BANG_.call(null,resp_port,inst_68161);
var state_68170__$1 = state_68170;
var statearr_68175_68187 = state_68170__$1;
(statearr_68175_68187[(2)] = inst_68165);

(statearr_68175_68187[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68171 === (4))){
var state_68170__$1 = state_68170;
var statearr_68176_68188 = state_68170__$1;
(statearr_68176_68188[(2)] = null);

(statearr_68176_68188[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68171 === (5))){
var inst_68168 = (state_68170[(2)]);
var state_68170__$1 = state_68170;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68170__$1,inst_68168);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_68177 = [null,null,null,null,null,null,null,null];
(statearr_68177[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_68177[(1)] = (1));

return statearr_68177;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_68170){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68170);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68178){var ex__2749__auto__ = e68178;
var statearr_68179_68189 = state_68170;
(statearr_68179_68189[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68170[(4)]))){
var statearr_68180_68190 = state_68170;
(statearr_68180_68190[(1)] = cljs.core.first.call(null,(state_68170[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68191 = state_68170;
state_68170 = G__68191;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_68170){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_68170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68181 = f__2769__auto__.call(null);
(statearr_68181[(6)] = c__2768__auto__);

return statearr_68181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__68192 = db;
var map__68192__$1 = cljs.core.__destructure_map.call(null,map__68192);
var conn = cljs.core.get.call(null,map__68192__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__68192__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__68192__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2768__auto___68268 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68242){
var state_val_68243 = (state_68242[(1)]);
if((state_val_68243 === (7))){
var inst_68208 = (state_68242[(7)]);
var inst_68219 = cljs.core._EQ_.call(null,inst_68208,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_68242__$1 = state_68242;
if(inst_68219){
var statearr_68244_68269 = state_68242__$1;
(statearr_68244_68269[(1)] = (9));

} else {
var statearr_68245_68270 = state_68242__$1;
(statearr_68245_68270[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (1))){
var inst_68193 = (state_68242[(8)]);
var inst_68201 = (state_68242[(9)]);
var inst_68193__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_68201__$1 = res_port;
var inst_68202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68203 = [inst_68193__$1,inst_68201__$1];
var inst_68204 = (new cljs.core.PersistentVector(null,2,(5),inst_68202,inst_68203,null));
var state_68242__$1 = (function (){var statearr_68246 = state_68242;
(statearr_68246[(8)] = inst_68193__$1);

(statearr_68246[(9)] = inst_68201__$1);

return statearr_68246;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_68242__$1,(2),inst_68204);
} else {
if((state_val_68243 === (4))){
var inst_68201 = (state_68242[(9)]);
var inst_68208 = (state_68242[(7)]);
var inst_68212 = cljs.core._EQ_.call(null,inst_68208,inst_68201);
var state_68242__$1 = state_68242;
if(inst_68212){
var statearr_68247_68271 = state_68242__$1;
(statearr_68247_68271[(1)] = (6));

} else {
var statearr_68248_68272 = state_68242__$1;
(statearr_68248_68272[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (13))){
var inst_68227 = (state_68242[(10)]);
var inst_68238 = cljs.core.async.put_BANG_.call(null,pc,inst_68227);
var state_68242__$1 = state_68242;
var statearr_68249_68273 = state_68242__$1;
(statearr_68249_68273[(2)] = inst_68238);

(statearr_68249_68273[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (6))){
var inst_68206 = (state_68242[(11)]);
var inst_68217 = cljs.core.nth.call(null,inst_68206,(0),null);
var state_68242__$1 = state_68242;
var statearr_68250_68274 = state_68242__$1;
(statearr_68250_68274[(2)] = inst_68217);

(statearr_68250_68274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (3))){
var state_68242__$1 = state_68242;
var statearr_68251_68275 = state_68242__$1;
(statearr_68251_68275[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_68251_68275[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (12))){
var inst_68231 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_68232 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68233 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_68234 = cljs.core.PersistentHashMap.fromArrays(inst_68232,inst_68233);
var inst_68235 = cljs.core.ex_info.call(null,inst_68231,inst_68234);
var inst_68236 = cljs.core.async.put_BANG_.call(null,pc,inst_68235);
var state_68242__$1 = state_68242;
var statearr_68252_68276 = state_68242__$1;
(statearr_68252_68276[(2)] = inst_68236);

(statearr_68252_68276[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (2))){
var inst_68206 = (state_68242[(11)]);
var inst_68193 = (state_68242[(8)]);
var inst_68208 = (state_68242[(7)]);
var inst_68206__$1 = (state_68242[(2)]);
var inst_68207 = cljs.core.nth.call(null,inst_68206__$1,(0),null);
var inst_68208__$1 = cljs.core.nth.call(null,inst_68206__$1,(1),null);
var inst_68209 = cljs.core._EQ_.call(null,inst_68208__$1,inst_68193);
var state_68242__$1 = (function (){var statearr_68253 = state_68242;
(statearr_68253[(11)] = inst_68206__$1);

(statearr_68253[(12)] = inst_68207);

(statearr_68253[(7)] = inst_68208__$1);

return statearr_68253;
})();
if(inst_68209){
var statearr_68254_68277 = state_68242__$1;
(statearr_68254_68277[(1)] = (3));

} else {
var statearr_68255_68278 = state_68242__$1;
(statearr_68255_68278[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (11))){
var inst_68223 = (state_68242[(2)]);
var state_68242__$1 = state_68242;
var statearr_68256_68279 = state_68242__$1;
(statearr_68256_68279[(2)] = inst_68223);

(statearr_68256_68279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (9))){
var inst_68207 = (state_68242[(12)]);
var state_68242__$1 = state_68242;
var statearr_68257_68280 = state_68242__$1;
(statearr_68257_68280[(2)] = inst_68207);

(statearr_68257_68280[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (5))){
var inst_68227 = (state_68242[(10)]);
var inst_68227__$1 = (state_68242[(2)]);
var inst_68228 = fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);
var inst_68229 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_68227__$1);
var state_68242__$1 = (function (){var statearr_68258 = state_68242;
(statearr_68258[(13)] = inst_68228);

(statearr_68258[(10)] = inst_68227__$1);

return statearr_68258;
})();
if(inst_68229){
var statearr_68259_68281 = state_68242__$1;
(statearr_68259_68281[(1)] = (12));

} else {
var statearr_68260_68282 = state_68242__$1;
(statearr_68260_68282[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (14))){
var inst_68240 = (state_68242[(2)]);
var state_68242__$1 = state_68242;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68242__$1,inst_68240);
} else {
if((state_val_68243 === (10))){
var state_68242__$1 = state_68242;
var statearr_68261_68283 = state_68242__$1;
(statearr_68261_68283[(2)] = null);

(statearr_68261_68283[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68243 === (8))){
var inst_68225 = (state_68242[(2)]);
var state_68242__$1 = state_68242;
var statearr_68262_68284 = state_68242__$1;
(statearr_68262_68284[(2)] = inst_68225);

(statearr_68262_68284[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0 = (function (){
var statearr_68263 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68263[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__);

(statearr_68263[(1)] = (1));

return statearr_68263;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1 = (function (state_68242){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68242);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68264){var ex__2749__auto__ = e68264;
var statearr_68265_68285 = state_68242;
(statearr_68265_68285[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68242[(4)]))){
var statearr_68266_68286 = state_68242;
(statearr_68266_68286[(1)] = cljs.core.first.call(null,(state_68242[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68287 = state_68242;
state_68242 = G__68287;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = function(state_68242){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1.call(this,state_68242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68267 = f__2769__auto__.call(null);
(statearr_68267[(6)] = c__2768__auto___68268);

return statearr_68267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__68289 = arguments.length;
switch (G__68289) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__68290){
var map__68291 = p__68290;
var map__68291__$1 = cljs.core.__destructure_map.call(null,map__68291);
var opts = map__68291__$1;
var roles = cljs.core.get.call(null,map__68291__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__68291__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__68291__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__68291__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__68291__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2768__auto___68380 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68342){
var state_val_68343 = (state_68342[(1)]);
if((state_val_68343 === (7))){
var inst_68304 = (state_68342[(7)]);
var inst_68306 = fluree.db.api.ledger.syncTo_db.call(null,inst_68304,syncTo,syncTimeout);
var state_68342__$1 = state_68342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68342__$1,(10),inst_68306);
} else {
if((state_val_68343 === (20))){
var inst_68328 = (state_68342[(8)]);
var state_68342__$1 = state_68342;
var statearr_68344_68381 = state_68342__$1;
(statearr_68344_68381[(2)] = inst_68328);

(statearr_68344_68381[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (1))){
var state_68342__$1 = state_68342;
var statearr_68345_68382 = state_68342__$1;
(statearr_68345_68382[(2)] = null);

(statearr_68345_68382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (4))){
var inst_68292 = (state_68342[(2)]);
var inst_68293 = cljs.core.async.put_BANG_.call(null,pc,inst_68292);
var inst_68294 = cljs.core.async.close_BANG_.call(null,pc);
var state_68342__$1 = (function (){var statearr_68346 = state_68342;
(statearr_68346[(9)] = inst_68293);

return statearr_68346;
})();
var statearr_68347_68383 = state_68342__$1;
(statearr_68347_68383[(2)] = inst_68294);

(statearr_68347_68383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (15))){
var inst_68320 = (state_68342[(10)]);
var inst_68322 = fluree.db.api.ledger.add_db_permissions.call(null,inst_68320,auth,roles);
var state_68342__$1 = state_68342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68342__$1,(18),inst_68322);
} else {
if((state_val_68343 === (21))){
var inst_68336 = (state_68342[(2)]);
var inst_68337 = cljs.core.async.put_BANG_.call(null,pc,inst_68336);
var _ = (function (){var statearr_68348 = state_68342;
(statearr_68348[(4)] = cljs.core.rest.call(null,(state_68342[(4)])));

return statearr_68348;
})();
var state_68342__$1 = state_68342;
var statearr_68349_68384 = state_68342__$1;
(statearr_68349_68384[(2)] = inst_68337);

(statearr_68349_68384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (13))){
var inst_68320 = (state_68342[(2)]);
var state_68342__$1 = (function (){var statearr_68350 = state_68342;
(statearr_68350[(10)] = inst_68320);

return statearr_68350;
})();
if(cljs.core.truth_(roles)){
var statearr_68351_68385 = state_68342__$1;
(statearr_68351_68385[(1)] = (15));

} else {
var statearr_68352_68386 = state_68342__$1;
(statearr_68352_68386[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (22))){
var inst_68332 = (state_68342[(2)]);
var inst_68333 = fluree.db.util.async.throw_err.call(null,inst_68332);
var state_68342__$1 = state_68342;
var statearr_68353_68387 = state_68342__$1;
(statearr_68353_68387[(2)] = inst_68333);

(statearr_68353_68387[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (6))){
var inst_68303 = (state_68342[(2)]);
var inst_68304 = fluree.db.util.async.throw_err.call(null,inst_68303);
var state_68342__$1 = (function (){var statearr_68354 = state_68342;
(statearr_68354[(7)] = inst_68304);

return statearr_68354;
})();
if(cljs.core.truth_(syncTo)){
var statearr_68355_68388 = state_68342__$1;
(statearr_68355_68388[(1)] = (7));

} else {
var statearr_68356_68389 = state_68342__$1;
(statearr_68356_68389[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (17))){
var inst_68328 = (state_68342[(2)]);
var state_68342__$1 = (function (){var statearr_68357 = state_68342;
(statearr_68357[(8)] = inst_68328);

return statearr_68357;
})();
if(cljs.core.truth_(auth)){
var statearr_68358_68390 = state_68342__$1;
(statearr_68358_68390[(1)] = (19));

} else {
var statearr_68359_68391 = state_68342__$1;
(statearr_68359_68391[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (3))){
var inst_68340 = (state_68342[(2)]);
var state_68342__$1 = state_68342;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68342__$1,inst_68340);
} else {
if((state_val_68343 === (12))){
var inst_68312 = (state_68342[(11)]);
var state_68342__$1 = state_68342;
var statearr_68360_68392 = state_68342__$1;
(statearr_68360_68392[(2)] = inst_68312);

(statearr_68360_68392[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (2))){
var _ = (function (){var statearr_68361 = state_68342;
(statearr_68361[(4)] = cljs.core.cons.call(null,(5),(state_68342[(4)])));

return statearr_68361;
})();
var inst_68301 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_68342__$1 = state_68342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68342__$1,(6),inst_68301);
} else {
if((state_val_68343 === (19))){
var inst_68328 = (state_68342[(8)]);
var inst_68330 = fluree.db.api.ledger.add_db_permissions.call(null,inst_68328,auth,roles);
var state_68342__$1 = state_68342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68342__$1,(22),inst_68330);
} else {
if((state_val_68343 === (11))){
var inst_68312 = (state_68342[(11)]);
var inst_68314 = fluree.db.time_travel.as_of_block.call(null,inst_68312,block);
var state_68342__$1 = state_68342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68342__$1,(14),inst_68314);
} else {
if((state_val_68343 === (9))){
var inst_68312 = (state_68342[(2)]);
var state_68342__$1 = (function (){var statearr_68363 = state_68342;
(statearr_68363[(11)] = inst_68312);

return statearr_68363;
})();
if(cljs.core.truth_(block)){
var statearr_68364_68393 = state_68342__$1;
(statearr_68364_68393[(1)] = (11));

} else {
var statearr_68365_68394 = state_68342__$1;
(statearr_68365_68394[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (5))){
var _ = (function (){var statearr_68366 = state_68342;
(statearr_68366[(4)] = cljs.core.rest.call(null,(state_68342[(4)])));

return statearr_68366;
})();
var state_68342__$1 = state_68342;
var ex68362 = (state_68342__$1[(2)]);
var statearr_68367_68395 = state_68342__$1;
(statearr_68367_68395[(5)] = ex68362);


var statearr_68368_68396 = state_68342__$1;
(statearr_68368_68396[(1)] = (4));

(statearr_68368_68396[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (14))){
var inst_68316 = (state_68342[(2)]);
var inst_68317 = fluree.db.util.async.throw_err.call(null,inst_68316);
var state_68342__$1 = state_68342;
var statearr_68369_68397 = state_68342__$1;
(statearr_68369_68397[(2)] = inst_68317);

(statearr_68369_68397[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (16))){
var inst_68320 = (state_68342[(10)]);
var state_68342__$1 = state_68342;
var statearr_68370_68398 = state_68342__$1;
(statearr_68370_68398[(2)] = inst_68320);

(statearr_68370_68398[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (10))){
var inst_68308 = (state_68342[(2)]);
var inst_68309 = fluree.db.util.async.throw_err.call(null,inst_68308);
var state_68342__$1 = state_68342;
var statearr_68371_68399 = state_68342__$1;
(statearr_68371_68399[(2)] = inst_68309);

(statearr_68371_68399[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (18))){
var inst_68324 = (state_68342[(2)]);
var inst_68325 = fluree.db.util.async.throw_err.call(null,inst_68324);
var state_68342__$1 = state_68342;
var statearr_68372_68400 = state_68342__$1;
(statearr_68372_68400[(2)] = inst_68325);

(statearr_68372_68400[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68343 === (8))){
var inst_68304 = (state_68342[(7)]);
var state_68342__$1 = state_68342;
var statearr_68373_68401 = state_68342__$1;
(statearr_68373_68401[(2)] = inst_68304);

(statearr_68373_68401[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_68374 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68374[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_68374[(1)] = (1));

return statearr_68374;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_68342){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68342);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68375){var ex__2749__auto__ = e68375;
var statearr_68376_68402 = state_68342;
(statearr_68376_68402[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68342[(4)]))){
var statearr_68377_68403 = state_68342;
(statearr_68377_68403[(1)] = cljs.core.first.call(null,(state_68342[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68404 = state_68342;
state_68342 = G__68404;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_68342){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_68342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68378 = f__2769__auto__.call(null);
(statearr_68378[(6)] = c__2768__auto___68380);

return statearr_68378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

