// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__6603 = s;
var map__6603__$1 = cljs.core.__destructure_map.call(null,map__6603);
var name = cljs.core.get.call(null,map__6603__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__6603__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__6605 = info;
var map__6606 = G__6605;
var map__6606__$1 = cljs.core.__destructure_map.call(null,map__6606);
var shadow = cljs.core.get.call(null,map__6606__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__6605__$1 = G__6605;
while(true){
var d__$2 = d__$1;
var map__6608 = G__6605__$1;
var map__6608__$1 = cljs.core.__destructure_map.call(null,map__6608);
var shadow__$1 = cljs.core.get.call(null,map__6608__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__6609 = (d__$2 + (1));
var G__6610 = shadow__$1;
d__$1 = G__6609;
G__6605__$1 = G__6610;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__6611){
var map__6612 = p__6611;
var map__6612__$1 = cljs.core.__destructure_map.call(null,map__6612);
var name_var = map__6612__$1;
var name = cljs.core.get.call(null,map__6612__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__6612__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__6613 = info;
var map__6613__$1 = cljs.core.__destructure_map.call(null,map__6613);
var ns = cljs.core.get.call(null,map__6613__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__6613__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.call(null,reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__6615 = arguments.length;
switch (G__6615) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11790,11790,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)])).call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__6617 = cp;
switch (G__6617) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__6619_6623 = cljs.core.seq.call(null,s);
var chunk__6620_6624 = null;
var count__6621_6625 = (0);
var i__6622_6626 = (0);
while(true){
if((i__6622_6626 < count__6621_6625)){
var c_6627 = cljs.core._nth.call(null,chunk__6620_6624,i__6622_6626);
sb.append(cljs.compiler.escape_char.call(null,c_6627));


var G__6628 = seq__6619_6623;
var G__6629 = chunk__6620_6624;
var G__6630 = count__6621_6625;
var G__6631 = (i__6622_6626 + (1));
seq__6619_6623 = G__6628;
chunk__6620_6624 = G__6629;
count__6621_6625 = G__6630;
i__6622_6626 = G__6631;
continue;
} else {
var temp__5804__auto___6632 = cljs.core.seq.call(null,seq__6619_6623);
if(temp__5804__auto___6632){
var seq__6619_6633__$1 = temp__5804__auto___6632;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6619_6633__$1)){
var c__5568__auto___6634 = cljs.core.chunk_first.call(null,seq__6619_6633__$1);
var G__6635 = cljs.core.chunk_rest.call(null,seq__6619_6633__$1);
var G__6636 = c__5568__auto___6634;
var G__6637 = cljs.core.count.call(null,c__5568__auto___6634);
var G__6638 = (0);
seq__6619_6623 = G__6635;
chunk__6620_6624 = G__6636;
count__6621_6625 = G__6637;
i__6622_6626 = G__6638;
continue;
} else {
var c_6639 = cljs.core.first.call(null,seq__6619_6633__$1);
sb.append(cljs.compiler.escape_char.call(null,c_6639));


var G__6640 = cljs.core.next.call(null,seq__6619_6633__$1);
var G__6641 = null;
var G__6642 = (0);
var G__6643 = (0);
seq__6619_6623 = G__6640;
chunk__6620_6624 = G__6641;
count__6621_6625 = G__6642;
i__6622_6626 = G__6643;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__6644_6647 = ast;
var map__6644_6648__$1 = cljs.core.__destructure_map.call(null,map__6644_6647);
var env_6649 = cljs.core.get.call(null,map__6644_6648__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_6649))){
var map__6645_6650 = env_6649;
var map__6645_6651__$1 = cljs.core.__destructure_map.call(null,map__6645_6650);
var line_6652 = cljs.core.get.call(null,map__6645_6651__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_6653 = cljs.core.get.call(null,map__6645_6651__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__6646 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.assoc.call(null,G__6646,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__6646;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_6652 - (1))], null),cljs.core.fnil.call(null,(function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_6653)?(column_6653 - (1)):(0))], null),cljs.core.fnil.call(null,(function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__6662 = arguments.length;
switch (G__6662) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___6669 = arguments.length;
var i__5770__auto___6670 = (0);
while(true){
if((i__5770__auto___6670 < len__5769__auto___6669)){
args_arr__5794__auto__.push((arguments[i__5770__auto___6670]));

var G__6671 = (i__5770__auto___6670 + (1));
i__5770__auto___6670 = G__6671;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5795__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,a)){
cljs.compiler.emit.call(null,a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,a)){
cljs.core.apply.call(null,cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
a.call(null);
} else {
var s_6672 = (function (){var G__6663 = a;
if((!(typeof a === 'string'))){
return G__6663.toString();
} else {
return G__6663;
}
})();
var temp__5808__auto___6673 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5808__auto___6673 == null)){
} else {
var sm_data_6674 = temp__5808__auto___6673;
cljs.core.swap_BANG_.call(null,sm_data_6674,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__6654_SHARP_){
return (p1__6654_SHARP_ + s_6672.length);
}));
}

cljs.core.print.call(null,s_6672);

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

return cljs.compiler.emits.call(null,b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler.emits.call(null,c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler.emits.call(null,d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler.emits.call(null,e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6664 = cljs.core.seq.call(null,xs);
var chunk__6665 = null;
var count__6666 = (0);
var i__6667 = (0);
while(true){
if((i__6667 < count__6666)){
var x = cljs.core._nth.call(null,chunk__6665,i__6667);
cljs.compiler.emits.call(null,x);


var G__6675 = seq__6664;
var G__6676 = chunk__6665;
var G__6677 = count__6666;
var G__6678 = (i__6667 + (1));
seq__6664 = G__6675;
chunk__6665 = G__6676;
count__6666 = G__6677;
i__6667 = G__6678;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__6664);
if(temp__5804__auto__){
var seq__6664__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6664__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__6664__$1);
var G__6679 = cljs.core.chunk_rest.call(null,seq__6664__$1);
var G__6680 = c__5568__auto__;
var G__6681 = cljs.core.count.call(null,c__5568__auto__);
var G__6682 = (0);
seq__6664 = G__6679;
chunk__6665 = G__6680;
count__6666 = G__6681;
i__6667 = G__6682;
continue;
} else {
var x = cljs.core.first.call(null,seq__6664__$1);
cljs.compiler.emits.call(null,x);


var G__6683 = cljs.core.next.call(null,seq__6664__$1);
var G__6684 = null;
var G__6685 = (0);
var G__6686 = (0);
seq__6664 = G__6683;
chunk__6665 = G__6684;
count__6666 = G__6685;
i__6667 = G__6686;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq6656){
var G__6657 = cljs.core.first.call(null,seq6656);
var seq6656__$1 = cljs.core.next.call(null,seq6656);
var G__6658 = cljs.core.first.call(null,seq6656__$1);
var seq6656__$2 = cljs.core.next.call(null,seq6656__$1);
var G__6659 = cljs.core.first.call(null,seq6656__$2);
var seq6656__$3 = cljs.core.next.call(null,seq6656__$2);
var G__6660 = cljs.core.first.call(null,seq6656__$3);
var seq6656__$4 = cljs.core.next.call(null,seq6656__$3);
var G__6661 = cljs.core.first.call(null,seq6656__$4);
var seq6656__$5 = cljs.core.next.call(null,seq6656__$4);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6657,G__6658,G__6659,G__6660,G__6661,seq6656__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__6687){
var map__6688 = p__6687;
var map__6688__$1 = cljs.core.__destructure_map.call(null,map__6688);
var m = map__6688__$1;
var gen_line = cljs.core.get.call(null,map__6688__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6696 = arguments.length;
switch (G__6696) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___6702 = arguments.length;
var i__5770__auto___6703 = (0);
while(true){
if((i__5770__auto___6703 < len__5769__auto___6702)){
args_arr__5794__auto__.push((arguments[i__5770__auto___6703]));

var G__6704 = (i__5770__auto___6703 + (1));
i__5770__auto___6703 = G__6704;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5795__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.call(null,a);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6697_6705 = cljs.core.seq.call(null,xs);
var chunk__6698_6706 = null;
var count__6699_6707 = (0);
var i__6700_6708 = (0);
while(true){
if((i__6700_6708 < count__6699_6707)){
var x_6709 = cljs.core._nth.call(null,chunk__6698_6706,i__6700_6708);
cljs.compiler.emits.call(null,x_6709);


var G__6710 = seq__6697_6705;
var G__6711 = chunk__6698_6706;
var G__6712 = count__6699_6707;
var G__6713 = (i__6700_6708 + (1));
seq__6697_6705 = G__6710;
chunk__6698_6706 = G__6711;
count__6699_6707 = G__6712;
i__6700_6708 = G__6713;
continue;
} else {
var temp__5804__auto___6714 = cljs.core.seq.call(null,seq__6697_6705);
if(temp__5804__auto___6714){
var seq__6697_6715__$1 = temp__5804__auto___6714;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6697_6715__$1)){
var c__5568__auto___6716 = cljs.core.chunk_first.call(null,seq__6697_6715__$1);
var G__6717 = cljs.core.chunk_rest.call(null,seq__6697_6715__$1);
var G__6718 = c__5568__auto___6716;
var G__6719 = cljs.core.count.call(null,c__5568__auto___6716);
var G__6720 = (0);
seq__6697_6705 = G__6717;
chunk__6698_6706 = G__6718;
count__6699_6707 = G__6719;
i__6700_6708 = G__6720;
continue;
} else {
var x_6721 = cljs.core.first.call(null,seq__6697_6715__$1);
cljs.compiler.emits.call(null,x_6721);


var G__6722 = cljs.core.next.call(null,seq__6697_6715__$1);
var G__6723 = null;
var G__6724 = (0);
var G__6725 = (0);
seq__6697_6705 = G__6722;
chunk__6698_6706 = G__6723;
count__6699_6707 = G__6724;
i__6700_6708 = G__6725;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln.call(null);
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq6690){
var G__6691 = cljs.core.first.call(null,seq6690);
var seq6690__$1 = cljs.core.next.call(null,seq6690);
var G__6692 = cljs.core.first.call(null,seq6690__$1);
var seq6690__$2 = cljs.core.next.call(null,seq6690__$1);
var G__6693 = cljs.core.first.call(null,seq6690__$2);
var seq6690__$3 = cljs.core.next.call(null,seq6690__$2);
var G__6694 = cljs.core.first.call(null,seq6690__$3);
var seq6690__$4 = cljs.core.next.call(null,seq6690__$3);
var G__6695 = cljs.core.first.call(null,seq6690__$4);
var seq6690__$5 = cljs.core.next.call(null,seq6690__$4);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6691,G__6692,G__6693,G__6694,G__6695,seq6690__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__5690__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__6726_6730 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__6727_6731 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__6728_6732 = true;
var _STAR_print_fn_STAR__temp_val__6729_6733 = (function (x__5691__auto__){
return sb__5690__auto__.append(x__5691__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__6728_6732);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__6729_6733);

try{cljs.compiler.emit.call(null,expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__6727_6731);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__6726_6730);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__5690__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,x)){
return cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.core.record_QMARK_.call(null,x)){
var vec__6734 = cljs.analyzer.record_ns_PLUS_name.call(null,x);
var ns = cljs.core.nth.call(null,vec__6734,(0),null);
var name = cljs.core.nth.call(null,vec__6734,(1),null);
return cljs.compiler.emit_record_value.call(null,ns,name,(function (){
return cljs.compiler.emit_constant.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,x));
}));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,x)){
return cljs.compiler.emit_map.call(null,cljs.core.keys.call(null,x),cljs.core.vals.call(null,x),cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_.call(null,x)){
return cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_.call(null,x)){
return cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
return cljs.compiler.emit_constant_STAR_.call(null,x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta.call(null,cljs.core.meta.call(null,v));
if((!((cljs.core.seq.call(null,m) == null)))){
return cljs.compiler.emit_with_meta.call(null,(function (){
return cljs.compiler.emit_constant_no_meta.call(null,v);
}),(function (){
return cljs.compiler.emit_constant_no_meta.call(null,m);
}));
} else {
return cljs.compiler.emit_constant_no_meta.call(null,v);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.call(null,cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
if((((x === (0))) && ((((1) / x) < (0))))){
return cljs.compiler.emits.call(null,"(-0)");
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__6737 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.call(null,vec__6737,(0),null);
var flags = cljs.core.nth.call(null,vec__6737,(1),null);
var pattern = cljs.core.nth.call(null,vec__6737,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Keyword,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Symbol,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.call(null,cljs.core.map_indexed.call(null,(function (i,m){
if(cljs.core.even_QMARK_.call(null,i)){
return cljs.compiler.emit_constant.call(null,m);
} else {
return cljs.compiler.emits.call(null,m);
}
}),cljs.compiler.comma_sep.call(null,cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.call(null,"new Date(",inst_ms,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Date,(function (date){
return cljs.compiler.emit_inst.call(null,date.getTime());
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_.call(null,items)){
return cljs.compiler.emit_js_object.call(null,items,(function (p1__6740_SHARP_){
return (function (){
return cljs.compiler.emit_constant.call(null,p1__6740_SHARP_);
});
}));
} else {
return cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__6742){
var map__6743 = p__6742;
var map__6743__$1 = cljs.core.__destructure_map.call(null,map__6743);
var ast = map__6743__$1;
var info = cljs.core.get.call(null,map__6743__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__6743__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__6743__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5802__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5802__auto__)){
var const_expr = temp__5802__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__6744 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__6744__$1 = cljs.core.__destructure_map.call(null,map__6744);
var cenv = map__6744__$1;
var options = cljs.core.get.call(null,map__6744__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__5045__auto__ = js_module_name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__6745 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.namespace.call(null,var_name) == null)));
} else {
return and__5043__auto__;
}
})())){
return clojure.set.difference.call(null,G__6745,cljs.analyzer.es5_allowed);
} else {
return G__6745;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__5045__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__6746 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__6746,reserved);
} else {
return G__6746;
}
})();
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__6747_6748 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__6747_6749__$1 = (((G__6747_6748 instanceof cljs.core.Keyword))?G__6747_6748.fqn:null);
switch (G__6747_6749__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__5043__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__6751){
var map__6752 = p__6751;
var map__6752__$1 = cljs.core.__destructure_map.call(null,map__6752);
var arg = map__6752__$1;
var env = cljs.core.get.call(null,map__6752__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__6752__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__6752__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__6752__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__6753 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__6753__$1 = cljs.core.__destructure_map.call(null,map__6753);
var name = cljs.core.get.call(null,map__6753__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__6754){
var map__6755 = p__6754;
var map__6755__$1 = cljs.core.__destructure_map.call(null,map__6755);
var expr = cljs.core.get.call(null,map__6755__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__6755__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__6755__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_with_meta.call(null,expr,meta);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6756_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6756_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count.call(null,keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count.call(null,keys) === (0))){
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(distinct_keys_QMARK_.call(null,keys))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",comma_sep.call(null,keys),"],[",comma_sep.call(null,vals),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__6757){
var map__6758 = p__6757;
var map__6758__$1 = cljs.core.__destructure_map.call(null,map__6758);
var env = cljs.core.get.call(null,map__6758__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__6758__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6758__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_map.call(null,keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.call(null,"cljs.core.list(",comma_sep.call(null,items),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count.call(null,items);
if((cnt < (32))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",comma_sep.call(null,items),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",comma_sep.call(null,items),"], true)");
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__6759){
var map__6760 = p__6759;
var map__6760__$1 = cljs.core.__destructure_map.call(null,map__6760);
var items = cljs.core.get.call(null,map__6760__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6760__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_vector.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6761_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6761_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count.call(null,items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(distinct_constants_QMARK_.call(null,items))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",comma_sep.call(null,items),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__6762){
var map__6763 = p__6762;
var map__6763__$1 = cljs.core.__destructure_map.call(null,map__6763);
var items = cljs.core.get.call(null,map__6763__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6763__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_set.call(null,items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.call(null,"({");

var temp__5804__auto___6786 = cljs.core.seq.call(null,items);
if(temp__5804__auto___6786){
var items_6787__$1 = temp__5804__auto___6786;
var vec__6764_6788 = items_6787__$1;
var seq__6765_6789 = cljs.core.seq.call(null,vec__6764_6788);
var first__6766_6790 = cljs.core.first.call(null,seq__6765_6789);
var seq__6765_6791__$1 = cljs.core.next.call(null,seq__6765_6789);
var vec__6767_6792 = first__6766_6790;
var k_6793 = cljs.core.nth.call(null,vec__6767_6792,(0),null);
var v_6794 = cljs.core.nth.call(null,vec__6767_6792,(1),null);
var r_6795 = seq__6765_6791__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_6793),"\": ",emit_js_object_val.call(null,v_6794));

var seq__6770_6796 = cljs.core.seq.call(null,r_6795);
var chunk__6771_6797 = null;
var count__6772_6798 = (0);
var i__6773_6799 = (0);
while(true){
if((i__6773_6799 < count__6772_6798)){
var vec__6780_6800 = cljs.core._nth.call(null,chunk__6771_6797,i__6773_6799);
var k_6801__$1 = cljs.core.nth.call(null,vec__6780_6800,(0),null);
var v_6802__$1 = cljs.core.nth.call(null,vec__6780_6800,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6801__$1),"\": ",emit_js_object_val.call(null,v_6802__$1));


var G__6803 = seq__6770_6796;
var G__6804 = chunk__6771_6797;
var G__6805 = count__6772_6798;
var G__6806 = (i__6773_6799 + (1));
seq__6770_6796 = G__6803;
chunk__6771_6797 = G__6804;
count__6772_6798 = G__6805;
i__6773_6799 = G__6806;
continue;
} else {
var temp__5804__auto___6807__$1 = cljs.core.seq.call(null,seq__6770_6796);
if(temp__5804__auto___6807__$1){
var seq__6770_6808__$1 = temp__5804__auto___6807__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6770_6808__$1)){
var c__5568__auto___6809 = cljs.core.chunk_first.call(null,seq__6770_6808__$1);
var G__6810 = cljs.core.chunk_rest.call(null,seq__6770_6808__$1);
var G__6811 = c__5568__auto___6809;
var G__6812 = cljs.core.count.call(null,c__5568__auto___6809);
var G__6813 = (0);
seq__6770_6796 = G__6810;
chunk__6771_6797 = G__6811;
count__6772_6798 = G__6812;
i__6773_6799 = G__6813;
continue;
} else {
var vec__6783_6814 = cljs.core.first.call(null,seq__6770_6808__$1);
var k_6815__$1 = cljs.core.nth.call(null,vec__6783_6814,(0),null);
var v_6816__$1 = cljs.core.nth.call(null,vec__6783_6814,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6815__$1),"\": ",emit_js_object_val.call(null,v_6816__$1));


var G__6817 = cljs.core.next.call(null,seq__6770_6808__$1);
var G__6818 = null;
var G__6819 = (0);
var G__6820 = (0);
seq__6770_6796 = G__6817;
chunk__6771_6797 = G__6818;
count__6772_6798 = G__6819;
i__6773_6799 = G__6820;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.call(null,"[",comma_sep.call(null,items),"]");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__6821){
var map__6822 = p__6821;
var map__6822__$1 = cljs.core.__destructure_map.call(null,map__6822);
var keys = cljs.core.get.call(null,map__6822__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6822__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.call(null,map__6822__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_object.call(null,cljs.core.map.call(null,cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__6823){
var map__6824 = p__6823;
var map__6824__$1 = cljs.core.__destructure_map.call(null,map__6824);
var items = cljs.core.get.call(null,map__6824__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6824__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_array.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__6825){
var map__6826 = p__6825;
var map__6826__$1 = cljs.core.__destructure_map.call(null,map__6826);
var expr = cljs.core.get.call(null,map__6826__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__6827){
var map__6828 = p__6827;
var map__6828__$1 = cljs.core.__destructure_map.call(null,map__6828);
var form = cljs.core.get.call(null,map__6828__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__6828__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__6829 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6829__$1 = cljs.core.__destructure_map.call(null,map__6829);
var op = cljs.core.get.call(null,map__6829__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6829__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6829__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__5045__auto__ = (function (){var and__5043__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__5043__auto__){
var and__5043__auto____$1 = form;
if(cljs.core.truth_(and__5043__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__6830 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6830__$1 = cljs.core.__destructure_map.call(null,map__6830);
var op = cljs.core.get.call(null,map__6830__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6830__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6830__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__5045__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__5045__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__6831){
var map__6832 = p__6831;
var map__6832__$1 = cljs.core.__destructure_map.call(null,map__6832);
var test = cljs.core.get.call(null,map__6832__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__6832__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__6832__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__6832__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__6832__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__5045__auto__ = unchecked;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__6833){
var map__6834 = p__6833;
var map__6834__$1 = cljs.core.__destructure_map.call(null,map__6834);
var v = cljs.core.get.call(null,map__6834__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.call(null,map__6834__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.call(null,map__6834__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__6834__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__6835_6863 = cljs.core.seq.call(null,nodes);
var chunk__6836_6864 = null;
var count__6837_6865 = (0);
var i__6838_6866 = (0);
while(true){
if((i__6838_6866 < count__6837_6865)){
var map__6851_6867 = cljs.core._nth.call(null,chunk__6836_6864,i__6838_6866);
var map__6851_6868__$1 = cljs.core.__destructure_map.call(null,map__6851_6867);
var ts_6869 = cljs.core.get.call(null,map__6851_6868__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6852_6870 = cljs.core.get.call(null,map__6851_6868__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6852_6871__$1 = cljs.core.__destructure_map.call(null,map__6852_6870);
var then_6872 = cljs.core.get.call(null,map__6852_6871__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6853_6873 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6869));
var chunk__6854_6874 = null;
var count__6855_6875 = (0);
var i__6856_6876 = (0);
while(true){
if((i__6856_6876 < count__6855_6875)){
var test_6877 = cljs.core._nth.call(null,chunk__6854_6874,i__6856_6876);
cljs.compiler.emitln.call(null,"case ",test_6877,":");


var G__6878 = seq__6853_6873;
var G__6879 = chunk__6854_6874;
var G__6880 = count__6855_6875;
var G__6881 = (i__6856_6876 + (1));
seq__6853_6873 = G__6878;
chunk__6854_6874 = G__6879;
count__6855_6875 = G__6880;
i__6856_6876 = G__6881;
continue;
} else {
var temp__5804__auto___6882 = cljs.core.seq.call(null,seq__6853_6873);
if(temp__5804__auto___6882){
var seq__6853_6883__$1 = temp__5804__auto___6882;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6853_6883__$1)){
var c__5568__auto___6884 = cljs.core.chunk_first.call(null,seq__6853_6883__$1);
var G__6885 = cljs.core.chunk_rest.call(null,seq__6853_6883__$1);
var G__6886 = c__5568__auto___6884;
var G__6887 = cljs.core.count.call(null,c__5568__auto___6884);
var G__6888 = (0);
seq__6853_6873 = G__6885;
chunk__6854_6874 = G__6886;
count__6855_6875 = G__6887;
i__6856_6876 = G__6888;
continue;
} else {
var test_6889 = cljs.core.first.call(null,seq__6853_6883__$1);
cljs.compiler.emitln.call(null,"case ",test_6889,":");


var G__6890 = cljs.core.next.call(null,seq__6853_6883__$1);
var G__6891 = null;
var G__6892 = (0);
var G__6893 = (0);
seq__6853_6873 = G__6890;
chunk__6854_6874 = G__6891;
count__6855_6875 = G__6892;
i__6856_6876 = G__6893;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6872);
} else {
cljs.compiler.emitln.call(null,then_6872);
}

cljs.compiler.emitln.call(null,"break;");


var G__6894 = seq__6835_6863;
var G__6895 = chunk__6836_6864;
var G__6896 = count__6837_6865;
var G__6897 = (i__6838_6866 + (1));
seq__6835_6863 = G__6894;
chunk__6836_6864 = G__6895;
count__6837_6865 = G__6896;
i__6838_6866 = G__6897;
continue;
} else {
var temp__5804__auto___6898 = cljs.core.seq.call(null,seq__6835_6863);
if(temp__5804__auto___6898){
var seq__6835_6899__$1 = temp__5804__auto___6898;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6835_6899__$1)){
var c__5568__auto___6900 = cljs.core.chunk_first.call(null,seq__6835_6899__$1);
var G__6901 = cljs.core.chunk_rest.call(null,seq__6835_6899__$1);
var G__6902 = c__5568__auto___6900;
var G__6903 = cljs.core.count.call(null,c__5568__auto___6900);
var G__6904 = (0);
seq__6835_6863 = G__6901;
chunk__6836_6864 = G__6902;
count__6837_6865 = G__6903;
i__6838_6866 = G__6904;
continue;
} else {
var map__6857_6905 = cljs.core.first.call(null,seq__6835_6899__$1);
var map__6857_6906__$1 = cljs.core.__destructure_map.call(null,map__6857_6905);
var ts_6907 = cljs.core.get.call(null,map__6857_6906__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6858_6908 = cljs.core.get.call(null,map__6857_6906__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6858_6909__$1 = cljs.core.__destructure_map.call(null,map__6858_6908);
var then_6910 = cljs.core.get.call(null,map__6858_6909__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6859_6911 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6907));
var chunk__6860_6912 = null;
var count__6861_6913 = (0);
var i__6862_6914 = (0);
while(true){
if((i__6862_6914 < count__6861_6913)){
var test_6915 = cljs.core._nth.call(null,chunk__6860_6912,i__6862_6914);
cljs.compiler.emitln.call(null,"case ",test_6915,":");


var G__6916 = seq__6859_6911;
var G__6917 = chunk__6860_6912;
var G__6918 = count__6861_6913;
var G__6919 = (i__6862_6914 + (1));
seq__6859_6911 = G__6916;
chunk__6860_6912 = G__6917;
count__6861_6913 = G__6918;
i__6862_6914 = G__6919;
continue;
} else {
var temp__5804__auto___6920__$1 = cljs.core.seq.call(null,seq__6859_6911);
if(temp__5804__auto___6920__$1){
var seq__6859_6921__$1 = temp__5804__auto___6920__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6859_6921__$1)){
var c__5568__auto___6922 = cljs.core.chunk_first.call(null,seq__6859_6921__$1);
var G__6923 = cljs.core.chunk_rest.call(null,seq__6859_6921__$1);
var G__6924 = c__5568__auto___6922;
var G__6925 = cljs.core.count.call(null,c__5568__auto___6922);
var G__6926 = (0);
seq__6859_6911 = G__6923;
chunk__6860_6912 = G__6924;
count__6861_6913 = G__6925;
i__6862_6914 = G__6926;
continue;
} else {
var test_6927 = cljs.core.first.call(null,seq__6859_6921__$1);
cljs.compiler.emitln.call(null,"case ",test_6927,":");


var G__6928 = cljs.core.next.call(null,seq__6859_6921__$1);
var G__6929 = null;
var G__6930 = (0);
var G__6931 = (0);
seq__6859_6911 = G__6928;
chunk__6860_6912 = G__6929;
count__6861_6913 = G__6930;
i__6862_6914 = G__6931;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6910);
} else {
cljs.compiler.emitln.call(null,then_6910);
}

cljs.compiler.emitln.call(null,"break;");


var G__6932 = cljs.core.next.call(null,seq__6835_6899__$1);
var G__6933 = null;
var G__6934 = (0);
var G__6935 = (0);
seq__6835_6863 = G__6932;
chunk__6836_6864 = G__6933;
count__6837_6865 = G__6934;
i__6838_6866 = G__6935;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__6936){
var map__6937 = p__6936;
var map__6937__$1 = cljs.core.__destructure_map.call(null,map__6937);
var throw$ = cljs.core.get.call(null,map__6937__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.call(null,map__6937__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__6939 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__6939,(0),null);
var rstr = cljs.core.nth.call(null,vec__6939,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,(function (p1__6938_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6938_SHARP_);
}),clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__6942 = ["function(",clojure.string.join.call(null,",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__6942,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__6942;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",clojure.string.join.call(null,"|",cljs.core.map.call(null,(function (p1__6943_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6943_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__6944 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6945 = cljs.core.seq.call(null,vec__6944);
var first__6946 = cljs.core.first.call(null,seq__6945);
var seq__6945__$1 = cljs.core.next.call(null,seq__6945);
var p = first__6946;
var first__6946__$1 = cljs.core.first.call(null,seq__6945__$1);
var seq__6945__$2 = cljs.core.next.call(null,seq__6945__$1);
var ts = first__6946__$1;
var first__6946__$2 = cljs.core.first.call(null,seq__6945__$2);
var seq__6945__$3 = cljs.core.next.call(null,seq__6945__$2);
var n = first__6946__$2;
var xs = seq__6945__$3;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__6947 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6948 = cljs.core.seq.call(null,vec__6947);
var first__6949 = cljs.core.first.call(null,seq__6948);
var seq__6948__$1 = cljs.core.next.call(null,seq__6948);
var p = first__6949;
var first__6949__$1 = cljs.core.first.call(null,seq__6948__$1);
var seq__6948__$2 = cljs.core.next.call(null,seq__6948__$1);
var ts = first__6949__$1;
var xs = seq__6948__$2;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__6952 = arguments.length;
switch (G__6952) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__6960 = cljs.core.map.call(null,(function (p1__6950_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__6950_SHARP_);
} else {
return p1__6950_SHARP_;
}
}),clojure.string.split_lines.call(null,e));
var seq__6961 = cljs.core.seq.call(null,vec__6960);
var first__6962 = cljs.core.first.call(null,seq__6961);
var seq__6961__$1 = cljs.core.next.call(null,seq__6961);
var x = first__6962;
var ys = seq__6961__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__6963 = cljs.core.seq.call(null,ys);
var chunk__6964 = null;
var count__6965 = (0);
var i__6966 = (0);
while(true){
if((i__6966 < count__6965)){
var next_line = cljs.core._nth.call(null,chunk__6964,i__6966);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6972 = seq__6963;
var G__6973 = chunk__6964;
var G__6974 = count__6965;
var G__6975 = (i__6966 + (1));
seq__6963 = G__6972;
chunk__6964 = G__6973;
count__6965 = G__6974;
i__6966 = G__6975;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__6963);
if(temp__5804__auto__){
var seq__6963__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6963__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__6963__$1);
var G__6976 = cljs.core.chunk_rest.call(null,seq__6963__$1);
var G__6977 = c__5568__auto__;
var G__6978 = cljs.core.count.call(null,c__5568__auto__);
var G__6979 = (0);
seq__6963 = G__6976;
chunk__6964 = G__6977;
count__6965 = G__6978;
i__6966 = G__6979;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__6963__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6980 = cljs.core.next.call(null,seq__6963__$1);
var G__6981 = null;
var G__6982 = (0);
var G__6983 = (0);
seq__6963 = G__6980;
chunk__6964 = G__6981;
count__6965 = G__6982;
i__6966 = G__6983;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__6967_6984 = cljs.core.seq.call(null,docs__$2);
var chunk__6968_6985 = null;
var count__6969_6986 = (0);
var i__6970_6987 = (0);
while(true){
if((i__6970_6987 < count__6969_6986)){
var e_6988 = cljs.core._nth.call(null,chunk__6968_6985,i__6970_6987);
if(cljs.core.truth_(e_6988)){
print_comment_lines.call(null,e_6988);
} else {
}


var G__6989 = seq__6967_6984;
var G__6990 = chunk__6968_6985;
var G__6991 = count__6969_6986;
var G__6992 = (i__6970_6987 + (1));
seq__6967_6984 = G__6989;
chunk__6968_6985 = G__6990;
count__6969_6986 = G__6991;
i__6970_6987 = G__6992;
continue;
} else {
var temp__5804__auto___6993 = cljs.core.seq.call(null,seq__6967_6984);
if(temp__5804__auto___6993){
var seq__6967_6994__$1 = temp__5804__auto___6993;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6967_6994__$1)){
var c__5568__auto___6995 = cljs.core.chunk_first.call(null,seq__6967_6994__$1);
var G__6996 = cljs.core.chunk_rest.call(null,seq__6967_6994__$1);
var G__6997 = c__5568__auto___6995;
var G__6998 = cljs.core.count.call(null,c__5568__auto___6995);
var G__6999 = (0);
seq__6967_6984 = G__6996;
chunk__6968_6985 = G__6997;
count__6969_6986 = G__6998;
i__6970_6987 = G__6999;
continue;
} else {
var e_7000 = cljs.core.first.call(null,seq__6967_6994__$1);
if(cljs.core.truth_(e_7000)){
print_comment_lines.call(null,e_7000);
} else {
}


var G__7001 = cljs.core.next.call(null,seq__6967_6994__$1);
var G__7002 = null;
var G__7003 = (0);
var G__7004 = (0);
seq__6967_6984 = G__7001;
chunk__6968_6985 = G__7002;
count__6969_6986 = G__7003;
i__6970_6987 = G__7004;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__5043__auto__ = cljs.core.some.call(null,(function (p1__7006_SHARP_){
return goog.string.startsWith(p1__7006_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = opts;
if(cljs.core.truth_(and__5043__auto____$1)){
var and__5043__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__5043__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_.call(null,define)){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__7007){
var map__7008 = p__7007;
var map__7008__$1 = cljs.core.__destructure_map.call(null,map__7008);
var doc = cljs.core.get.call(null,map__7008__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__7008__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.call(null,map__7008__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.call(null,map__7008__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.call(null,map__7008__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.call(null,map__7008__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__7008__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.call(null,map__7008__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.call(null,map__7008__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.call(null,map__7008__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__5045__auto__ = init;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,(cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5802__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5802__auto__)){
var define = temp__5802__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return test;
} else {
return and__5043__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__7009){
var map__7010 = p__7009;
var map__7010__$1 = cljs.core.__destructure_map.call(null,map__7010);
var name = cljs.core.get.call(null,map__7010__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7010__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7010__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__7011_7035 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__7012_7036 = null;
var count__7013_7037 = (0);
var i__7014_7038 = (0);
while(true){
if((i__7014_7038 < count__7013_7037)){
var vec__7021_7039 = cljs.core._nth.call(null,chunk__7012_7036,i__7014_7038);
var i_7040 = cljs.core.nth.call(null,vec__7021_7039,(0),null);
var param_7041 = cljs.core.nth.call(null,vec__7021_7039,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_7041);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__7042 = seq__7011_7035;
var G__7043 = chunk__7012_7036;
var G__7044 = count__7013_7037;
var G__7045 = (i__7014_7038 + (1));
seq__7011_7035 = G__7042;
chunk__7012_7036 = G__7043;
count__7013_7037 = G__7044;
i__7014_7038 = G__7045;
continue;
} else {
var temp__5804__auto___7046 = cljs.core.seq.call(null,seq__7011_7035);
if(temp__5804__auto___7046){
var seq__7011_7047__$1 = temp__5804__auto___7046;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7011_7047__$1)){
var c__5568__auto___7048 = cljs.core.chunk_first.call(null,seq__7011_7047__$1);
var G__7049 = cljs.core.chunk_rest.call(null,seq__7011_7047__$1);
var G__7050 = c__5568__auto___7048;
var G__7051 = cljs.core.count.call(null,c__5568__auto___7048);
var G__7052 = (0);
seq__7011_7035 = G__7049;
chunk__7012_7036 = G__7050;
count__7013_7037 = G__7051;
i__7014_7038 = G__7052;
continue;
} else {
var vec__7024_7053 = cljs.core.first.call(null,seq__7011_7047__$1);
var i_7054 = cljs.core.nth.call(null,vec__7024_7053,(0),null);
var param_7055 = cljs.core.nth.call(null,vec__7024_7053,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_7055);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__7056 = cljs.core.next.call(null,seq__7011_7047__$1);
var G__7057 = null;
var G__7058 = (0);
var G__7059 = (0);
seq__7011_7035 = G__7056;
chunk__7012_7036 = G__7057;
count__7013_7037 = G__7058;
i__7014_7038 = G__7059;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__7027_7060 = cljs.core.seq.call(null,params);
var chunk__7028_7061 = null;
var count__7029_7062 = (0);
var i__7030_7063 = (0);
while(true){
if((i__7030_7063 < count__7029_7062)){
var param_7064 = cljs.core._nth.call(null,chunk__7028_7061,i__7030_7063);
cljs.compiler.emit.call(null,param_7064);

if(cljs.core._EQ_.call(null,param_7064,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7065 = seq__7027_7060;
var G__7066 = chunk__7028_7061;
var G__7067 = count__7029_7062;
var G__7068 = (i__7030_7063 + (1));
seq__7027_7060 = G__7065;
chunk__7028_7061 = G__7066;
count__7029_7062 = G__7067;
i__7030_7063 = G__7068;
continue;
} else {
var temp__5804__auto___7069 = cljs.core.seq.call(null,seq__7027_7060);
if(temp__5804__auto___7069){
var seq__7027_7070__$1 = temp__5804__auto___7069;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7027_7070__$1)){
var c__5568__auto___7071 = cljs.core.chunk_first.call(null,seq__7027_7070__$1);
var G__7072 = cljs.core.chunk_rest.call(null,seq__7027_7070__$1);
var G__7073 = c__5568__auto___7071;
var G__7074 = cljs.core.count.call(null,c__5568__auto___7071);
var G__7075 = (0);
seq__7027_7060 = G__7072;
chunk__7028_7061 = G__7073;
count__7029_7062 = G__7074;
i__7030_7063 = G__7075;
continue;
} else {
var param_7076 = cljs.core.first.call(null,seq__7027_7070__$1);
cljs.compiler.emit.call(null,param_7076);

if(cljs.core._EQ_.call(null,param_7076,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7077 = cljs.core.next.call(null,seq__7027_7070__$1);
var G__7078 = null;
var G__7079 = (0);
var G__7080 = (0);
seq__7027_7060 = G__7077;
chunk__7028_7061 = G__7078;
count__7029_7062 = G__7079;
i__7030_7063 = G__7080;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__7031_7081 = cljs.core.seq.call(null,params);
var chunk__7032_7082 = null;
var count__7033_7083 = (0);
var i__7034_7084 = (0);
while(true){
if((i__7034_7084 < count__7033_7083)){
var param_7085 = cljs.core._nth.call(null,chunk__7032_7082,i__7034_7084);
cljs.compiler.emit.call(null,param_7085);

if(cljs.core._EQ_.call(null,param_7085,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7086 = seq__7031_7081;
var G__7087 = chunk__7032_7082;
var G__7088 = count__7033_7083;
var G__7089 = (i__7034_7084 + (1));
seq__7031_7081 = G__7086;
chunk__7032_7082 = G__7087;
count__7033_7083 = G__7088;
i__7034_7084 = G__7089;
continue;
} else {
var temp__5804__auto___7090 = cljs.core.seq.call(null,seq__7031_7081);
if(temp__5804__auto___7090){
var seq__7031_7091__$1 = temp__5804__auto___7090;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7031_7091__$1)){
var c__5568__auto___7092 = cljs.core.chunk_first.call(null,seq__7031_7091__$1);
var G__7093 = cljs.core.chunk_rest.call(null,seq__7031_7091__$1);
var G__7094 = c__5568__auto___7092;
var G__7095 = cljs.core.count.call(null,c__5568__auto___7092);
var G__7096 = (0);
seq__7031_7081 = G__7093;
chunk__7032_7082 = G__7094;
count__7033_7083 = G__7095;
i__7034_7084 = G__7096;
continue;
} else {
var param_7097 = cljs.core.first.call(null,seq__7031_7091__$1);
cljs.compiler.emit.call(null,param_7097);

if(cljs.core._EQ_.call(null,param_7097,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7098 = cljs.core.next.call(null,seq__7031_7091__$1);
var G__7099 = null;
var G__7100 = (0);
var G__7101 = (0);
seq__7031_7081 = G__7098;
chunk__7032_7082 = G__7099;
count__7033_7083 = G__7100;
i__7034_7084 = G__7101;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__7102 = cljs.core.seq.call(null,params);
var chunk__7103 = null;
var count__7104 = (0);
var i__7105 = (0);
while(true){
if((i__7105 < count__7104)){
var param = cljs.core._nth.call(null,chunk__7103,i__7105);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7106 = seq__7102;
var G__7107 = chunk__7103;
var G__7108 = count__7104;
var G__7109 = (i__7105 + (1));
seq__7102 = G__7106;
chunk__7103 = G__7107;
count__7104 = G__7108;
i__7105 = G__7109;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__7102);
if(temp__5804__auto__){
var seq__7102__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7102__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__7102__$1);
var G__7110 = cljs.core.chunk_rest.call(null,seq__7102__$1);
var G__7111 = c__5568__auto__;
var G__7112 = cljs.core.count.call(null,c__5568__auto__);
var G__7113 = (0);
seq__7102 = G__7110;
chunk__7103 = G__7111;
count__7104 = G__7112;
i__7105 = G__7113;
continue;
} else {
var param = cljs.core.first.call(null,seq__7102__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7114 = cljs.core.next.call(null,seq__7102__$1);
var G__7115 = null;
var G__7116 = (0);
var G__7117 = (0);
seq__7102 = G__7114;
chunk__7103 = G__7115;
count__7104 = G__7116;
i__7105 = G__7117;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__7118){
var map__7119 = p__7118;
var map__7119__$1 = cljs.core.__destructure_map.call(null,map__7119);
var expr = cljs.core.get.call(null,map__7119__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.call(null,map__7119__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__7119__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7119__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7119__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__7119__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__7120){
var map__7121 = p__7120;
var map__7121__$1 = cljs.core.__destructure_map.call(null,map__7121);
var f = map__7121__$1;
var expr = cljs.core.get.call(null,map__7121__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.call(null,map__7121__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.call(null,map__7121__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.call(null,map__7121__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__7121__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7121__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7121__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__7121__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_7130__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7131 = cljs.compiler.munge.call(null,name_7130__$1);
var delegate_name_7132 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7131),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_7132," = function (");

var seq__7122_7133 = cljs.core.seq.call(null,params);
var chunk__7123_7134 = null;
var count__7124_7135 = (0);
var i__7125_7136 = (0);
while(true){
if((i__7125_7136 < count__7124_7135)){
var param_7137 = cljs.core._nth.call(null,chunk__7123_7134,i__7125_7136);
cljs.compiler.emit.call(null,param_7137);

if(cljs.core._EQ_.call(null,param_7137,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7138 = seq__7122_7133;
var G__7139 = chunk__7123_7134;
var G__7140 = count__7124_7135;
var G__7141 = (i__7125_7136 + (1));
seq__7122_7133 = G__7138;
chunk__7123_7134 = G__7139;
count__7124_7135 = G__7140;
i__7125_7136 = G__7141;
continue;
} else {
var temp__5804__auto___7142 = cljs.core.seq.call(null,seq__7122_7133);
if(temp__5804__auto___7142){
var seq__7122_7143__$1 = temp__5804__auto___7142;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7122_7143__$1)){
var c__5568__auto___7144 = cljs.core.chunk_first.call(null,seq__7122_7143__$1);
var G__7145 = cljs.core.chunk_rest.call(null,seq__7122_7143__$1);
var G__7146 = c__5568__auto___7144;
var G__7147 = cljs.core.count.call(null,c__5568__auto___7144);
var G__7148 = (0);
seq__7122_7133 = G__7145;
chunk__7123_7134 = G__7146;
count__7124_7135 = G__7147;
i__7125_7136 = G__7148;
continue;
} else {
var param_7149 = cljs.core.first.call(null,seq__7122_7143__$1);
cljs.compiler.emit.call(null,param_7149);

if(cljs.core._EQ_.call(null,param_7149,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7150 = cljs.core.next.call(null,seq__7122_7143__$1);
var G__7151 = null;
var G__7152 = (0);
var G__7153 = (0);
seq__7122_7133 = G__7150;
chunk__7123_7134 = G__7151;
count__7124_7135 = G__7152;
i__7125_7136 = G__7153;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_7131," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_7154 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_7154,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_7132,".call(this,");

var seq__7126_7155 = cljs.core.seq.call(null,params);
var chunk__7127_7156 = null;
var count__7128_7157 = (0);
var i__7129_7158 = (0);
while(true){
if((i__7129_7158 < count__7128_7157)){
var param_7159 = cljs.core._nth.call(null,chunk__7127_7156,i__7129_7158);
cljs.compiler.emit.call(null,param_7159);

if(cljs.core._EQ_.call(null,param_7159,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7160 = seq__7126_7155;
var G__7161 = chunk__7127_7156;
var G__7162 = count__7128_7157;
var G__7163 = (i__7129_7158 + (1));
seq__7126_7155 = G__7160;
chunk__7127_7156 = G__7161;
count__7128_7157 = G__7162;
i__7129_7158 = G__7163;
continue;
} else {
var temp__5804__auto___7164 = cljs.core.seq.call(null,seq__7126_7155);
if(temp__5804__auto___7164){
var seq__7126_7165__$1 = temp__5804__auto___7164;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7126_7165__$1)){
var c__5568__auto___7166 = cljs.core.chunk_first.call(null,seq__7126_7165__$1);
var G__7167 = cljs.core.chunk_rest.call(null,seq__7126_7165__$1);
var G__7168 = c__5568__auto___7166;
var G__7169 = cljs.core.count.call(null,c__5568__auto___7166);
var G__7170 = (0);
seq__7126_7155 = G__7167;
chunk__7127_7156 = G__7168;
count__7128_7157 = G__7169;
i__7129_7158 = G__7170;
continue;
} else {
var param_7171 = cljs.core.first.call(null,seq__7126_7165__$1);
cljs.compiler.emit.call(null,param_7171);

if(cljs.core._EQ_.call(null,param_7171,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7172 = cljs.core.next.call(null,seq__7126_7165__$1);
var G__7173 = null;
var G__7174 = (0);
var G__7175 = (0);
seq__7126_7155 = G__7172;
chunk__7127_7156 = G__7173;
count__7128_7157 = G__7174;
i__7129_7158 = G__7175;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_7131,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_7131,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_7130__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_7131,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_7132,";");

cljs.compiler.emitln.call(null,"return ",mname_7131,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7179){
var map__7180 = p__7179;
var map__7180__$1 = cljs.core.__destructure_map.call(null,map__7180);
var variadic = cljs.core.get.call(null,map__7180__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.call(null,map__7180__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__7180__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__7180__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__7180__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.call(null,map__7180__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.call(null,map__7180__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.call(null,map__7180__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,(function (p1__7176_SHARP_){
var and__5043__auto__ = p1__7176_SHARP_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7176_SHARP_));
} else {
return and__5043__auto__;
}
}),recur_frames));
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,recur_params,(cljs.core.truth_((function (){var or__5045__auto__ = in_loop;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.seq.call(null,recur_params);
}
})())?cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets):null))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7232__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7233 = cljs.compiler.munge.call(null,name_7232__$1);
var maxparams_7234 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7235 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7233),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7236 = cljs.core.sort_by.call(null,(function (p1__7177_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__7177_SHARP_)));
}),cljs.core.seq.call(null,mmap_7235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_7233," = null;");

var seq__7181_7237 = cljs.core.seq.call(null,ms_7236);
var chunk__7182_7238 = null;
var count__7183_7239 = (0);
var i__7184_7240 = (0);
while(true){
if((i__7184_7240 < count__7183_7239)){
var vec__7191_7241 = cljs.core._nth.call(null,chunk__7182_7238,i__7184_7240);
var n_7242 = cljs.core.nth.call(null,vec__7191_7241,(0),null);
var meth_7243 = cljs.core.nth.call(null,vec__7191_7241,(1),null);
cljs.compiler.emits.call(null,"var ",n_7242," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7243))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7243);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7243);
}

cljs.compiler.emitln.call(null,";");


var G__7244 = seq__7181_7237;
var G__7245 = chunk__7182_7238;
var G__7246 = count__7183_7239;
var G__7247 = (i__7184_7240 + (1));
seq__7181_7237 = G__7244;
chunk__7182_7238 = G__7245;
count__7183_7239 = G__7246;
i__7184_7240 = G__7247;
continue;
} else {
var temp__5804__auto___7248 = cljs.core.seq.call(null,seq__7181_7237);
if(temp__5804__auto___7248){
var seq__7181_7249__$1 = temp__5804__auto___7248;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7181_7249__$1)){
var c__5568__auto___7250 = cljs.core.chunk_first.call(null,seq__7181_7249__$1);
var G__7251 = cljs.core.chunk_rest.call(null,seq__7181_7249__$1);
var G__7252 = c__5568__auto___7250;
var G__7253 = cljs.core.count.call(null,c__5568__auto___7250);
var G__7254 = (0);
seq__7181_7237 = G__7251;
chunk__7182_7238 = G__7252;
count__7183_7239 = G__7253;
i__7184_7240 = G__7254;
continue;
} else {
var vec__7194_7255 = cljs.core.first.call(null,seq__7181_7249__$1);
var n_7256 = cljs.core.nth.call(null,vec__7194_7255,(0),null);
var meth_7257 = cljs.core.nth.call(null,vec__7194_7255,(1),null);
cljs.compiler.emits.call(null,"var ",n_7256," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7257))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7257);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7257);
}

cljs.compiler.emitln.call(null,";");


var G__7258 = cljs.core.next.call(null,seq__7181_7249__$1);
var G__7259 = null;
var G__7260 = (0);
var G__7261 = (0);
seq__7181_7237 = G__7258;
chunk__7182_7238 = G__7259;
count__7183_7239 = G__7260;
i__7184_7240 = G__7261;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_7233," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_7234),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7234)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_7234));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__7197_7262 = cljs.core.seq.call(null,ms_7236);
var chunk__7198_7263 = null;
var count__7199_7264 = (0);
var i__7200_7265 = (0);
while(true){
if((i__7200_7265 < count__7199_7264)){
var vec__7207_7266 = cljs.core._nth.call(null,chunk__7198_7263,i__7200_7265);
var n_7267 = cljs.core.nth.call(null,vec__7207_7266,(0),null);
var meth_7268 = cljs.core.nth.call(null,vec__7207_7266,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7268))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7269 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7269," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7270 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7269," = new cljs.core.IndexedSeq(",a_7270,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7267,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7234)),(((cljs.core.count.call(null,maxparams_7234) > (1)))?", ":null),restarg_7269,");");
} else {
var pcnt_7271 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7268));
cljs.compiler.emitln.call(null,"case ",pcnt_7271,":");

cljs.compiler.emitln.call(null,"return ",n_7267,".call(this",(((pcnt_7271 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7271,maxparams_7234)),null,(1),null)),(2),null))),");");
}


var G__7272 = seq__7197_7262;
var G__7273 = chunk__7198_7263;
var G__7274 = count__7199_7264;
var G__7275 = (i__7200_7265 + (1));
seq__7197_7262 = G__7272;
chunk__7198_7263 = G__7273;
count__7199_7264 = G__7274;
i__7200_7265 = G__7275;
continue;
} else {
var temp__5804__auto___7276 = cljs.core.seq.call(null,seq__7197_7262);
if(temp__5804__auto___7276){
var seq__7197_7277__$1 = temp__5804__auto___7276;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7197_7277__$1)){
var c__5568__auto___7278 = cljs.core.chunk_first.call(null,seq__7197_7277__$1);
var G__7279 = cljs.core.chunk_rest.call(null,seq__7197_7277__$1);
var G__7280 = c__5568__auto___7278;
var G__7281 = cljs.core.count.call(null,c__5568__auto___7278);
var G__7282 = (0);
seq__7197_7262 = G__7279;
chunk__7198_7263 = G__7280;
count__7199_7264 = G__7281;
i__7200_7265 = G__7282;
continue;
} else {
var vec__7210_7283 = cljs.core.first.call(null,seq__7197_7277__$1);
var n_7284 = cljs.core.nth.call(null,vec__7210_7283,(0),null);
var meth_7285 = cljs.core.nth.call(null,vec__7210_7283,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7285))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7286 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7286," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7287 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7286," = new cljs.core.IndexedSeq(",a_7287,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7284,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7234)),(((cljs.core.count.call(null,maxparams_7234) > (1)))?", ":null),restarg_7286,");");
} else {
var pcnt_7288 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7285));
cljs.compiler.emitln.call(null,"case ",pcnt_7288,":");

cljs.compiler.emitln.call(null,"return ",n_7284,".call(this",(((pcnt_7288 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7288,maxparams_7234)),null,(1),null)),(2),null))),");");
}


var G__7289 = cljs.core.next.call(null,seq__7197_7277__$1);
var G__7290 = null;
var G__7291 = (0);
var G__7292 = (0);
seq__7197_7262 = G__7289;
chunk__7198_7263 = G__7290;
count__7199_7264 = G__7291;
i__7200_7265 = G__7292;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_7293 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_7236)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_7293,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_7233,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_7233,".cljs$lang$applyTo = ",cljs.core.some.call(null,(function (p1__7178_SHARP_){
var vec__7213 = p1__7178_SHARP_;
var n = cljs.core.nth.call(null,vec__7213,(0),null);
var m = cljs.core.nth.call(null,vec__7213,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7236),".cljs$lang$applyTo;");
} else {
}

var seq__7216_7294 = cljs.core.seq.call(null,ms_7236);
var chunk__7217_7295 = null;
var count__7218_7296 = (0);
var i__7219_7297 = (0);
while(true){
if((i__7219_7297 < count__7218_7296)){
var vec__7226_7298 = cljs.core._nth.call(null,chunk__7217_7295,i__7219_7297);
var n_7299 = cljs.core.nth.call(null,vec__7226_7298,(0),null);
var meth_7300 = cljs.core.nth.call(null,vec__7226_7298,(1),null);
var c_7301 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7300));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7300))){
cljs.compiler.emitln.call(null,mname_7233,".cljs$core$IFn$_invoke$arity$variadic = ",n_7299,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7233,".cljs$core$IFn$_invoke$arity$",c_7301," = ",n_7299,";");
}


var G__7302 = seq__7216_7294;
var G__7303 = chunk__7217_7295;
var G__7304 = count__7218_7296;
var G__7305 = (i__7219_7297 + (1));
seq__7216_7294 = G__7302;
chunk__7217_7295 = G__7303;
count__7218_7296 = G__7304;
i__7219_7297 = G__7305;
continue;
} else {
var temp__5804__auto___7306 = cljs.core.seq.call(null,seq__7216_7294);
if(temp__5804__auto___7306){
var seq__7216_7307__$1 = temp__5804__auto___7306;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7216_7307__$1)){
var c__5568__auto___7308 = cljs.core.chunk_first.call(null,seq__7216_7307__$1);
var G__7309 = cljs.core.chunk_rest.call(null,seq__7216_7307__$1);
var G__7310 = c__5568__auto___7308;
var G__7311 = cljs.core.count.call(null,c__5568__auto___7308);
var G__7312 = (0);
seq__7216_7294 = G__7309;
chunk__7217_7295 = G__7310;
count__7218_7296 = G__7311;
i__7219_7297 = G__7312;
continue;
} else {
var vec__7229_7313 = cljs.core.first.call(null,seq__7216_7307__$1);
var n_7314 = cljs.core.nth.call(null,vec__7229_7313,(0),null);
var meth_7315 = cljs.core.nth.call(null,vec__7229_7313,(1),null);
var c_7316 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7315));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7315))){
cljs.compiler.emitln.call(null,mname_7233,".cljs$core$IFn$_invoke$arity$variadic = ",n_7314,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7233,".cljs$core$IFn$_invoke$arity$",c_7316," = ",n_7314,";");
}


var G__7317 = cljs.core.next.call(null,seq__7216_7307__$1);
var G__7318 = null;
var G__7319 = (0);
var G__7320 = (0);
seq__7216_7294 = G__7317;
chunk__7217_7295 = G__7318;
count__7218_7296 = G__7319;
i__7219_7297 = G__7320;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_7233,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7321){
var map__7322 = p__7321;
var map__7322__$1 = cljs.core.__destructure_map.call(null,map__7322);
var statements = cljs.core.get.call(null,map__7322__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__7322__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__7322__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__7323_7327 = cljs.core.seq.call(null,statements);
var chunk__7324_7328 = null;
var count__7325_7329 = (0);
var i__7326_7330 = (0);
while(true){
if((i__7326_7330 < count__7325_7329)){
var s_7331 = cljs.core._nth.call(null,chunk__7324_7328,i__7326_7330);
cljs.compiler.emitln.call(null,s_7331);


var G__7332 = seq__7323_7327;
var G__7333 = chunk__7324_7328;
var G__7334 = count__7325_7329;
var G__7335 = (i__7326_7330 + (1));
seq__7323_7327 = G__7332;
chunk__7324_7328 = G__7333;
count__7325_7329 = G__7334;
i__7326_7330 = G__7335;
continue;
} else {
var temp__5804__auto___7336 = cljs.core.seq.call(null,seq__7323_7327);
if(temp__5804__auto___7336){
var seq__7323_7337__$1 = temp__5804__auto___7336;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7323_7337__$1)){
var c__5568__auto___7338 = cljs.core.chunk_first.call(null,seq__7323_7337__$1);
var G__7339 = cljs.core.chunk_rest.call(null,seq__7323_7337__$1);
var G__7340 = c__5568__auto___7338;
var G__7341 = cljs.core.count.call(null,c__5568__auto___7338);
var G__7342 = (0);
seq__7323_7327 = G__7339;
chunk__7324_7328 = G__7340;
count__7325_7329 = G__7341;
i__7326_7330 = G__7342;
continue;
} else {
var s_7343 = cljs.core.first.call(null,seq__7323_7337__$1);
cljs.compiler.emitln.call(null,s_7343);


var G__7344 = cljs.core.next.call(null,seq__7323_7337__$1);
var G__7345 = null;
var G__7346 = (0);
var G__7347 = (0);
seq__7323_7327 = G__7344;
chunk__7324_7328 = G__7345;
count__7325_7329 = G__7346;
i__7326_7330 = G__7347;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7348){
var map__7349 = p__7348;
var map__7349__$1 = cljs.core.__destructure_map.call(null,map__7349);
var try$ = cljs.core.get.call(null,map__7349__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.call(null,map__7349__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.call(null,map__7349__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__7349__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__7349__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote.call(null,finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7350,is_loop){
var map__7351 = p__7350;
var map__7351__$1 = cljs.core.__destructure_map.call(null,map__7351);
var expr = cljs.core.get.call(null,map__7351__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7351__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7351__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7352_7362 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7353_7363 = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,(function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7353_7363);

try{var seq__7354_7364 = cljs.core.seq.call(null,bindings);
var chunk__7355_7365 = null;
var count__7356_7366 = (0);
var i__7357_7367 = (0);
while(true){
if((i__7357_7367 < count__7356_7366)){
var map__7360_7368 = cljs.core._nth.call(null,chunk__7355_7365,i__7357_7367);
var map__7360_7369__$1 = cljs.core.__destructure_map.call(null,map__7360_7368);
var binding_7370 = map__7360_7369__$1;
var init_7371 = cljs.core.get.call(null,map__7360_7369__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7370);

cljs.compiler.emitln.call(null," = ",init_7371,";");


var G__7372 = seq__7354_7364;
var G__7373 = chunk__7355_7365;
var G__7374 = count__7356_7366;
var G__7375 = (i__7357_7367 + (1));
seq__7354_7364 = G__7372;
chunk__7355_7365 = G__7373;
count__7356_7366 = G__7374;
i__7357_7367 = G__7375;
continue;
} else {
var temp__5804__auto___7376 = cljs.core.seq.call(null,seq__7354_7364);
if(temp__5804__auto___7376){
var seq__7354_7377__$1 = temp__5804__auto___7376;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7354_7377__$1)){
var c__5568__auto___7378 = cljs.core.chunk_first.call(null,seq__7354_7377__$1);
var G__7379 = cljs.core.chunk_rest.call(null,seq__7354_7377__$1);
var G__7380 = c__5568__auto___7378;
var G__7381 = cljs.core.count.call(null,c__5568__auto___7378);
var G__7382 = (0);
seq__7354_7364 = G__7379;
chunk__7355_7365 = G__7380;
count__7356_7366 = G__7381;
i__7357_7367 = G__7382;
continue;
} else {
var map__7361_7383 = cljs.core.first.call(null,seq__7354_7377__$1);
var map__7361_7384__$1 = cljs.core.__destructure_map.call(null,map__7361_7383);
var binding_7385 = map__7361_7384__$1;
var init_7386 = cljs.core.get.call(null,map__7361_7384__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7385);

cljs.compiler.emitln.call(null," = ",init_7386,";");


var G__7387 = cljs.core.next.call(null,seq__7354_7377__$1);
var G__7388 = null;
var G__7389 = (0);
var G__7390 = (0);
seq__7354_7364 = G__7387;
chunk__7355_7365 = G__7388;
count__7356_7366 = G__7389;
i__7357_7367 = G__7390;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7352_7362);
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7391){
var map__7392 = p__7391;
var map__7392__$1 = cljs.core.__destructure_map.call(null,map__7392);
var frame = cljs.core.get.call(null,map__7392__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__7392__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__7392__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__5636__auto___7393 = cljs.core.count.call(null,exprs);
var i_7394 = (0);
while(true){
if((i_7394 < n__5636__auto___7393)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_7394)," = ",exprs.call(null,i_7394),";");

var G__7395 = (i_7394 + (1));
i_7394 = G__7395;
continue;
} else {
}
break;
}

var n__5636__auto___7396 = cljs.core.count.call(null,exprs);
var i_7397 = (0);
while(true){
if((i_7397 < n__5636__auto___7396)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_7397))," = ",temps.call(null,i_7397),";");

var G__7398 = (i_7397 + (1));
i_7397 = G__7398;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7399){
var map__7400 = p__7399;
var map__7400__$1 = cljs.core.__destructure_map.call(null,map__7400);
var expr = cljs.core.get.call(null,map__7400__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7400__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7400__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__7401_7409 = cljs.core.seq.call(null,bindings);
var chunk__7402_7410 = null;
var count__7403_7411 = (0);
var i__7404_7412 = (0);
while(true){
if((i__7404_7412 < count__7403_7411)){
var map__7407_7413 = cljs.core._nth.call(null,chunk__7402_7410,i__7404_7412);
var map__7407_7414__$1 = cljs.core.__destructure_map.call(null,map__7407_7413);
var binding_7415 = map__7407_7414__$1;
var init_7416 = cljs.core.get.call(null,map__7407_7414__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7415)," = ",init_7416,";");


var G__7417 = seq__7401_7409;
var G__7418 = chunk__7402_7410;
var G__7419 = count__7403_7411;
var G__7420 = (i__7404_7412 + (1));
seq__7401_7409 = G__7417;
chunk__7402_7410 = G__7418;
count__7403_7411 = G__7419;
i__7404_7412 = G__7420;
continue;
} else {
var temp__5804__auto___7421 = cljs.core.seq.call(null,seq__7401_7409);
if(temp__5804__auto___7421){
var seq__7401_7422__$1 = temp__5804__auto___7421;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7401_7422__$1)){
var c__5568__auto___7423 = cljs.core.chunk_first.call(null,seq__7401_7422__$1);
var G__7424 = cljs.core.chunk_rest.call(null,seq__7401_7422__$1);
var G__7425 = c__5568__auto___7423;
var G__7426 = cljs.core.count.call(null,c__5568__auto___7423);
var G__7427 = (0);
seq__7401_7409 = G__7424;
chunk__7402_7410 = G__7425;
count__7403_7411 = G__7426;
i__7404_7412 = G__7427;
continue;
} else {
var map__7408_7428 = cljs.core.first.call(null,seq__7401_7422__$1);
var map__7408_7429__$1 = cljs.core.__destructure_map.call(null,map__7408_7428);
var binding_7430 = map__7408_7429__$1;
var init_7431 = cljs.core.get.call(null,map__7408_7429__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7430)," = ",init_7431,";");


var G__7432 = cljs.core.next.call(null,seq__7401_7422__$1);
var G__7433 = null;
var G__7434 = (0);
var G__7435 = (0);
seq__7401_7409 = G__7432;
chunk__7402_7410 = G__7433;
count__7403_7411 = G__7434;
i__7404_7412 = G__7435;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7438){
var map__7439 = p__7438;
var map__7439__$1 = cljs.core.__destructure_map.call(null,map__7439);
var expr = map__7439__$1;
var f = cljs.core.get.call(null,map__7439__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.call(null,map__7439__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7439__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__5043__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__5043__auto__ = protocol;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = tag;
if(cljs.core.truth_(and__5043__auto____$1)){
var or__5045__auto__ = (function (){var and__5043__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto____$2)){
var and__5043__auto____$3 = protocol;
if(cljs.core.truth_(and__5043__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__5043__auto____$3;
}
} else {
return and__5043__auto____$2;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto____$2 = (function (){var or__5045__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__5043__auto____$2)){
var or__5045__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
var and__5043__auto____$3 = (!(cljs.core.set_QMARK_.call(null,tag)));
if(and__5043__auto____$3){
var and__5043__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null).call(null,tag));
if(and__5043__auto____$4){
var temp__5804__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,cljs.core.vary_meta.call(null,tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5804__auto__)){
var ps = temp__5804__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__5043__auto____$4;
}
} else {
return and__5043__auto____$3;
}
}
} else {
return and__5043__auto____$2;
}
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null).call(null,first_arg_tag))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag.call(null,env,f);
var js_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__5045__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = (function (){var temp__5804__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5804__auto__)){
var ns_str = temp__5804__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__5045__auto__){
return or__5045__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote.call(null,f);
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7440 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (arity > mfa);
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7436_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7436_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7437_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7437_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__7440,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__7440,(1),null);
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"(!(",cljs.core.first.call(null,args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.call(null,"((",cljs.core.first.call(null,args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7443 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_7443,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7444 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_7444,args)),(((mfa_7444 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_7444,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1));
} else {
return and__5043__auto__;
}
})())){
var fprop_7445 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.call(null,"(",f__$1,fprop_7445," ? ",f__$1,fprop_7445,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_7445," ? ",f__$1,fprop_7445,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7446){
var map__7447 = p__7446;
var map__7447__$1 = cljs.core.__destructure_map.call(null,map__7447);
var ctor = cljs.core.get.call(null,map__7447__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.call(null,map__7447__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7447__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7448){
var map__7449 = p__7448;
var map__7449__$1 = cljs.core.__destructure_map.call(null,map__7449);
var target = cljs.core.get.call(null,map__7449__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__7449__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__7449__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(",target," = ",val,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.call(null,sublib,/\./);
return cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (p1__7450_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7450_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__7451 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__7451,(0),null);
var sublib = cljs.core.nth.call(null,vec__7451,(1),null);
return cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib)," = goog.global",cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.call(null,cljs.core.name.call(null,(function (){var or__5045__auto__ = cljs.core.get.call(null,global_exports,cljs.core.symbol.call(null,lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,global_exports,cljs.core.name.call(null,lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.compiler.sublib_select.call(null,sublib),";");
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7454 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__7454__$1 = cljs.core.__destructure_map.call(null,map__7454);
var options = cljs.core.get.call(null,map__7454__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__7454__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7455 = options;
var map__7455__$1 = cljs.core.__destructure_map.call(null,map__7455);
var target = cljs.core.get.call(null,map__7455__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.call(null,map__7455__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.call(null,map__7455__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7456 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7462 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7462__$1 = cljs.core.__destructure_map.call(null,map__7462);
var node_libs = cljs.core.get.call(null,map__7462__$1,true);
var libs_to_load = cljs.core.get.call(null,map__7462__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__7456,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__7456,(1),null);
var vec__7459 = (function (){var map__7463 = cljs.core.group_by.call(null,cljs.analyzer.goog_module_dep_QMARK_,libs_to_load);
var map__7463__$1 = cljs.core.__destructure_map.call(null,map__7463);
var goog_modules = cljs.core.get.call(null,map__7463__$1,true);
var libs_to_load__$1 = cljs.core.get.call(null,map__7463__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goog_modules,libs_to_load__$1], null);
})();
var goog_modules = cljs.core.nth.call(null,vec__7459,(0),null);
var libs_to_load__$1 = cljs.core.nth.call(null,vec__7459,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load__$1);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7464_7508 = cljs.core.seq.call(null,libs_to_load__$1);
var chunk__7465_7509 = null;
var count__7466_7510 = (0);
var i__7467_7511 = (0);
while(true){
if((i__7467_7511 < count__7466_7510)){
var lib_7512 = cljs.core._nth.call(null,chunk__7465_7509,i__7467_7511);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7512)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7512),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7512),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7512),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7512),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7512,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7512),"');");
}

}
}
}


var G__7513 = seq__7464_7508;
var G__7514 = chunk__7465_7509;
var G__7515 = count__7466_7510;
var G__7516 = (i__7467_7511 + (1));
seq__7464_7508 = G__7513;
chunk__7465_7509 = G__7514;
count__7466_7510 = G__7515;
i__7467_7511 = G__7516;
continue;
} else {
var temp__5804__auto___7517 = cljs.core.seq.call(null,seq__7464_7508);
if(temp__5804__auto___7517){
var seq__7464_7518__$1 = temp__5804__auto___7517;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7464_7518__$1)){
var c__5568__auto___7519 = cljs.core.chunk_first.call(null,seq__7464_7518__$1);
var G__7520 = cljs.core.chunk_rest.call(null,seq__7464_7518__$1);
var G__7521 = c__5568__auto___7519;
var G__7522 = cljs.core.count.call(null,c__5568__auto___7519);
var G__7523 = (0);
seq__7464_7508 = G__7520;
chunk__7465_7509 = G__7521;
count__7466_7510 = G__7522;
i__7467_7511 = G__7523;
continue;
} else {
var lib_7524 = cljs.core.first.call(null,seq__7464_7518__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7524)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7524),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7524),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7524),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7524),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7524,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7524),"');");
}

}
}
}


var G__7525 = cljs.core.next.call(null,seq__7464_7518__$1);
var G__7526 = null;
var G__7527 = (0);
var G__7528 = (0);
seq__7464_7508 = G__7525;
chunk__7465_7509 = G__7526;
count__7466_7510 = G__7527;
i__7467_7511 = G__7528;
continue;
}
} else {
}
}
break;
}

var seq__7468_7529 = cljs.core.seq.call(null,node_libs);
var chunk__7469_7530 = null;
var count__7470_7531 = (0);
var i__7471_7532 = (0);
while(true){
if((i__7471_7532 < count__7470_7531)){
var lib_7533 = cljs.core._nth.call(null,chunk__7469_7530,i__7471_7532);
var vec__7478_7534 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7533);
var lib_SINGLEQUOTE__7535 = cljs.core.nth.call(null,vec__7478_7534,(0),null);
var sublib_7536 = cljs.core.nth.call(null,vec__7478_7534,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_7533)," = require('",lib_SINGLEQUOTE__7535,"')",cljs.compiler.sublib_select.call(null,sublib_7536),";");


var G__7537 = seq__7468_7529;
var G__7538 = chunk__7469_7530;
var G__7539 = count__7470_7531;
var G__7540 = (i__7471_7532 + (1));
seq__7468_7529 = G__7537;
chunk__7469_7530 = G__7538;
count__7470_7531 = G__7539;
i__7471_7532 = G__7540;
continue;
} else {
var temp__5804__auto___7541 = cljs.core.seq.call(null,seq__7468_7529);
if(temp__5804__auto___7541){
var seq__7468_7542__$1 = temp__5804__auto___7541;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7468_7542__$1)){
var c__5568__auto___7543 = cljs.core.chunk_first.call(null,seq__7468_7542__$1);
var G__7544 = cljs.core.chunk_rest.call(null,seq__7468_7542__$1);
var G__7545 = c__5568__auto___7543;
var G__7546 = cljs.core.count.call(null,c__5568__auto___7543);
var G__7547 = (0);
seq__7468_7529 = G__7544;
chunk__7469_7530 = G__7545;
count__7470_7531 = G__7546;
i__7471_7532 = G__7547;
continue;
} else {
var lib_7548 = cljs.core.first.call(null,seq__7468_7542__$1);
var vec__7481_7549 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7548);
var lib_SINGLEQUOTE__7550 = cljs.core.nth.call(null,vec__7481_7549,(0),null);
var sublib_7551 = cljs.core.nth.call(null,vec__7481_7549,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_7548)," = require('",lib_SINGLEQUOTE__7550,"')",cljs.compiler.sublib_select.call(null,sublib_7551),";");


var G__7552 = cljs.core.next.call(null,seq__7468_7542__$1);
var G__7553 = null;
var G__7554 = (0);
var G__7555 = (0);
seq__7468_7529 = G__7552;
chunk__7469_7530 = G__7553;
count__7470_7531 = G__7554;
i__7471_7532 = G__7555;
continue;
}
} else {
}
}
break;
}

var seq__7484_7556 = cljs.core.seq.call(null,goog_modules);
var chunk__7485_7557 = null;
var count__7486_7558 = (0);
var i__7487_7559 = (0);
while(true){
if((i__7487_7559 < count__7486_7558)){
var lib_7560 = cljs.core._nth.call(null,chunk__7485_7557,i__7487_7559);
var vec__7494_7561 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7560);
var lib_SINGLEQUOTE__7562 = cljs.core.nth.call(null,vec__7494_7561,(0),null);
var sublib_7563 = cljs.core.nth.call(null,vec__7494_7561,(1),null);
cljs.compiler.emitln.call(null,"goog.require('",lib_SINGLEQUOTE__7562,"');");

cljs.compiler.emitln.call(null,"goog.scope(function(){");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_goog_module_lib.call(null,lib_7560)," = goog.module.get('",lib_SINGLEQUOTE__7562,"')",cljs.compiler.sublib_select.call(null,sublib_7563),";");

cljs.compiler.emitln.call(null,"});");


var G__7564 = seq__7484_7556;
var G__7565 = chunk__7485_7557;
var G__7566 = count__7486_7558;
var G__7567 = (i__7487_7559 + (1));
seq__7484_7556 = G__7564;
chunk__7485_7557 = G__7565;
count__7486_7558 = G__7566;
i__7487_7559 = G__7567;
continue;
} else {
var temp__5804__auto___7568 = cljs.core.seq.call(null,seq__7484_7556);
if(temp__5804__auto___7568){
var seq__7484_7569__$1 = temp__5804__auto___7568;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7484_7569__$1)){
var c__5568__auto___7570 = cljs.core.chunk_first.call(null,seq__7484_7569__$1);
var G__7571 = cljs.core.chunk_rest.call(null,seq__7484_7569__$1);
var G__7572 = c__5568__auto___7570;
var G__7573 = cljs.core.count.call(null,c__5568__auto___7570);
var G__7574 = (0);
seq__7484_7556 = G__7571;
chunk__7485_7557 = G__7572;
count__7486_7558 = G__7573;
i__7487_7559 = G__7574;
continue;
} else {
var lib_7575 = cljs.core.first.call(null,seq__7484_7569__$1);
var vec__7497_7576 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7575);
var lib_SINGLEQUOTE__7577 = cljs.core.nth.call(null,vec__7497_7576,(0),null);
var sublib_7578 = cljs.core.nth.call(null,vec__7497_7576,(1),null);
cljs.compiler.emitln.call(null,"goog.require('",lib_SINGLEQUOTE__7577,"');");

cljs.compiler.emitln.call(null,"goog.scope(function(){");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_goog_module_lib.call(null,lib_7575)," = goog.module.get('",lib_SINGLEQUOTE__7577,"')",cljs.compiler.sublib_select.call(null,sublib_7578),";");

cljs.compiler.emitln.call(null,"});");


var G__7579 = cljs.core.next.call(null,seq__7484_7569__$1);
var G__7580 = null;
var G__7581 = (0);
var G__7582 = (0);
seq__7484_7556 = G__7579;
chunk__7485_7557 = G__7580;
count__7486_7558 = G__7581;
i__7487_7559 = G__7582;
continue;
}
} else {
}
}
break;
}

var seq__7500_7583 = cljs.core.seq.call(null,global_exports_libs);
var chunk__7501_7584 = null;
var count__7502_7585 = (0);
var i__7503_7586 = (0);
while(true){
if((i__7503_7586 < count__7502_7585)){
var lib_7587 = cljs.core._nth.call(null,chunk__7501_7584,i__7503_7586);
var map__7506_7588 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7587))));
var map__7506_7589__$1 = cljs.core.__destructure_map.call(null,map__7506_7588);
var global_exports_7590 = cljs.core.get.call(null,map__7506_7589__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_7590,lib_7587);


var G__7591 = seq__7500_7583;
var G__7592 = chunk__7501_7584;
var G__7593 = count__7502_7585;
var G__7594 = (i__7503_7586 + (1));
seq__7500_7583 = G__7591;
chunk__7501_7584 = G__7592;
count__7502_7585 = G__7593;
i__7503_7586 = G__7594;
continue;
} else {
var temp__5804__auto___7595 = cljs.core.seq.call(null,seq__7500_7583);
if(temp__5804__auto___7595){
var seq__7500_7596__$1 = temp__5804__auto___7595;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7500_7596__$1)){
var c__5568__auto___7597 = cljs.core.chunk_first.call(null,seq__7500_7596__$1);
var G__7598 = cljs.core.chunk_rest.call(null,seq__7500_7596__$1);
var G__7599 = c__5568__auto___7597;
var G__7600 = cljs.core.count.call(null,c__5568__auto___7597);
var G__7601 = (0);
seq__7500_7583 = G__7598;
chunk__7501_7584 = G__7599;
count__7502_7585 = G__7600;
i__7503_7586 = G__7601;
continue;
} else {
var lib_7602 = cljs.core.first.call(null,seq__7500_7596__$1);
var map__7507_7603 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7602))));
var map__7507_7604__$1 = cljs.core.__destructure_map.call(null,map__7507_7603);
var global_exports_7605 = cljs.core.get.call(null,map__7507_7604__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_7605,lib_7602);


var G__7606 = cljs.core.next.call(null,seq__7500_7596__$1);
var G__7607 = null;
var G__7608 = (0);
var G__7609 = (0);
seq__7500_7583 = G__7606;
chunk__7501_7584 = G__7607;
count__7502_7585 = G__7608;
i__7503_7586 = G__7609;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__7610){
var map__7611 = p__7610;
var map__7611__$1 = cljs.core.__destructure_map.call(null,map__7611);
var name = cljs.core.get.call(null,map__7611__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__7611__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__7611__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__7611__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__7611__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__7611__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__7611__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"'nil';");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__7612){
var map__7613 = p__7612;
var map__7613__$1 = cljs.core.__destructure_map.call(null,map__7613);
var name = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__7613__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__7614){
var map__7615 = p__7614;
var map__7615__$1 = cljs.core.__destructure_map.call(null,map__7615);
var t = cljs.core.get.call(null,map__7615__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7615__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7615__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7615__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7615__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7616_7640 = cljs.core.seq.call(null,protocols);
var chunk__7617_7641 = null;
var count__7618_7642 = (0);
var i__7619_7643 = (0);
while(true){
if((i__7619_7643 < count__7618_7642)){
var protocol_7644 = cljs.core._nth.call(null,chunk__7617_7641,i__7619_7643);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7644)),"}");


var G__7645 = seq__7616_7640;
var G__7646 = chunk__7617_7641;
var G__7647 = count__7618_7642;
var G__7648 = (i__7619_7643 + (1));
seq__7616_7640 = G__7645;
chunk__7617_7641 = G__7646;
count__7618_7642 = G__7647;
i__7619_7643 = G__7648;
continue;
} else {
var temp__5804__auto___7649 = cljs.core.seq.call(null,seq__7616_7640);
if(temp__5804__auto___7649){
var seq__7616_7650__$1 = temp__5804__auto___7649;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7616_7650__$1)){
var c__5568__auto___7651 = cljs.core.chunk_first.call(null,seq__7616_7650__$1);
var G__7652 = cljs.core.chunk_rest.call(null,seq__7616_7650__$1);
var G__7653 = c__5568__auto___7651;
var G__7654 = cljs.core.count.call(null,c__5568__auto___7651);
var G__7655 = (0);
seq__7616_7640 = G__7652;
chunk__7617_7641 = G__7653;
count__7618_7642 = G__7654;
i__7619_7643 = G__7655;
continue;
} else {
var protocol_7656 = cljs.core.first.call(null,seq__7616_7650__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7656)),"}");


var G__7657 = cljs.core.next.call(null,seq__7616_7650__$1);
var G__7658 = null;
var G__7659 = (0);
var G__7660 = (0);
seq__7616_7640 = G__7657;
chunk__7617_7641 = G__7658;
count__7618_7642 = G__7659;
i__7619_7643 = G__7660;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7620_7661 = cljs.core.seq.call(null,fields__$1);
var chunk__7621_7662 = null;
var count__7622_7663 = (0);
var i__7623_7664 = (0);
while(true){
if((i__7623_7664 < count__7622_7663)){
var fld_7665 = cljs.core._nth.call(null,chunk__7621_7662,i__7623_7664);
cljs.compiler.emitln.call(null,"this.",fld_7665," = ",fld_7665,";");


var G__7666 = seq__7620_7661;
var G__7667 = chunk__7621_7662;
var G__7668 = count__7622_7663;
var G__7669 = (i__7623_7664 + (1));
seq__7620_7661 = G__7666;
chunk__7621_7662 = G__7667;
count__7622_7663 = G__7668;
i__7623_7664 = G__7669;
continue;
} else {
var temp__5804__auto___7670 = cljs.core.seq.call(null,seq__7620_7661);
if(temp__5804__auto___7670){
var seq__7620_7671__$1 = temp__5804__auto___7670;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7620_7671__$1)){
var c__5568__auto___7672 = cljs.core.chunk_first.call(null,seq__7620_7671__$1);
var G__7673 = cljs.core.chunk_rest.call(null,seq__7620_7671__$1);
var G__7674 = c__5568__auto___7672;
var G__7675 = cljs.core.count.call(null,c__5568__auto___7672);
var G__7676 = (0);
seq__7620_7661 = G__7673;
chunk__7621_7662 = G__7674;
count__7622_7663 = G__7675;
i__7623_7664 = G__7676;
continue;
} else {
var fld_7677 = cljs.core.first.call(null,seq__7620_7671__$1);
cljs.compiler.emitln.call(null,"this.",fld_7677," = ",fld_7677,";");


var G__7678 = cljs.core.next.call(null,seq__7620_7671__$1);
var G__7679 = null;
var G__7680 = (0);
var G__7681 = (0);
seq__7620_7661 = G__7678;
chunk__7621_7662 = G__7679;
count__7622_7663 = G__7680;
i__7623_7664 = G__7681;
continue;
}
} else {
}
}
break;
}

var seq__7624_7682 = cljs.core.seq.call(null,pmasks);
var chunk__7625_7683 = null;
var count__7626_7684 = (0);
var i__7627_7685 = (0);
while(true){
if((i__7627_7685 < count__7626_7684)){
var vec__7634_7686 = cljs.core._nth.call(null,chunk__7625_7683,i__7627_7685);
var pno_7687 = cljs.core.nth.call(null,vec__7634_7686,(0),null);
var pmask_7688 = cljs.core.nth.call(null,vec__7634_7686,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7687,"$ = ",pmask_7688,";");


var G__7689 = seq__7624_7682;
var G__7690 = chunk__7625_7683;
var G__7691 = count__7626_7684;
var G__7692 = (i__7627_7685 + (1));
seq__7624_7682 = G__7689;
chunk__7625_7683 = G__7690;
count__7626_7684 = G__7691;
i__7627_7685 = G__7692;
continue;
} else {
var temp__5804__auto___7693 = cljs.core.seq.call(null,seq__7624_7682);
if(temp__5804__auto___7693){
var seq__7624_7694__$1 = temp__5804__auto___7693;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7624_7694__$1)){
var c__5568__auto___7695 = cljs.core.chunk_first.call(null,seq__7624_7694__$1);
var G__7696 = cljs.core.chunk_rest.call(null,seq__7624_7694__$1);
var G__7697 = c__5568__auto___7695;
var G__7698 = cljs.core.count.call(null,c__5568__auto___7695);
var G__7699 = (0);
seq__7624_7682 = G__7696;
chunk__7625_7683 = G__7697;
count__7626_7684 = G__7698;
i__7627_7685 = G__7699;
continue;
} else {
var vec__7637_7700 = cljs.core.first.call(null,seq__7624_7694__$1);
var pno_7701 = cljs.core.nth.call(null,vec__7637_7700,(0),null);
var pmask_7702 = cljs.core.nth.call(null,vec__7637_7700,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7701,"$ = ",pmask_7702,";");


var G__7703 = cljs.core.next.call(null,seq__7624_7694__$1);
var G__7704 = null;
var G__7705 = (0);
var G__7706 = (0);
seq__7624_7682 = G__7703;
chunk__7625_7683 = G__7704;
count__7626_7684 = G__7705;
i__7627_7685 = G__7706;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__7707){
var map__7708 = p__7707;
var map__7708__$1 = cljs.core.__destructure_map.call(null,map__7708);
var t = cljs.core.get.call(null,map__7708__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7708__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7708__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7708__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7708__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7709_7733 = cljs.core.seq.call(null,protocols);
var chunk__7710_7734 = null;
var count__7711_7735 = (0);
var i__7712_7736 = (0);
while(true){
if((i__7712_7736 < count__7711_7735)){
var protocol_7737 = cljs.core._nth.call(null,chunk__7710_7734,i__7712_7736);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7737)),"}");


var G__7738 = seq__7709_7733;
var G__7739 = chunk__7710_7734;
var G__7740 = count__7711_7735;
var G__7741 = (i__7712_7736 + (1));
seq__7709_7733 = G__7738;
chunk__7710_7734 = G__7739;
count__7711_7735 = G__7740;
i__7712_7736 = G__7741;
continue;
} else {
var temp__5804__auto___7742 = cljs.core.seq.call(null,seq__7709_7733);
if(temp__5804__auto___7742){
var seq__7709_7743__$1 = temp__5804__auto___7742;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7709_7743__$1)){
var c__5568__auto___7744 = cljs.core.chunk_first.call(null,seq__7709_7743__$1);
var G__7745 = cljs.core.chunk_rest.call(null,seq__7709_7743__$1);
var G__7746 = c__5568__auto___7744;
var G__7747 = cljs.core.count.call(null,c__5568__auto___7744);
var G__7748 = (0);
seq__7709_7733 = G__7745;
chunk__7710_7734 = G__7746;
count__7711_7735 = G__7747;
i__7712_7736 = G__7748;
continue;
} else {
var protocol_7749 = cljs.core.first.call(null,seq__7709_7743__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7749)),"}");


var G__7750 = cljs.core.next.call(null,seq__7709_7743__$1);
var G__7751 = null;
var G__7752 = (0);
var G__7753 = (0);
seq__7709_7733 = G__7750;
chunk__7710_7734 = G__7751;
count__7711_7735 = G__7752;
i__7712_7736 = G__7753;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7713_7754 = cljs.core.seq.call(null,fields__$1);
var chunk__7714_7755 = null;
var count__7715_7756 = (0);
var i__7716_7757 = (0);
while(true){
if((i__7716_7757 < count__7715_7756)){
var fld_7758 = cljs.core._nth.call(null,chunk__7714_7755,i__7716_7757);
cljs.compiler.emitln.call(null,"this.",fld_7758," = ",fld_7758,";");


var G__7759 = seq__7713_7754;
var G__7760 = chunk__7714_7755;
var G__7761 = count__7715_7756;
var G__7762 = (i__7716_7757 + (1));
seq__7713_7754 = G__7759;
chunk__7714_7755 = G__7760;
count__7715_7756 = G__7761;
i__7716_7757 = G__7762;
continue;
} else {
var temp__5804__auto___7763 = cljs.core.seq.call(null,seq__7713_7754);
if(temp__5804__auto___7763){
var seq__7713_7764__$1 = temp__5804__auto___7763;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7713_7764__$1)){
var c__5568__auto___7765 = cljs.core.chunk_first.call(null,seq__7713_7764__$1);
var G__7766 = cljs.core.chunk_rest.call(null,seq__7713_7764__$1);
var G__7767 = c__5568__auto___7765;
var G__7768 = cljs.core.count.call(null,c__5568__auto___7765);
var G__7769 = (0);
seq__7713_7754 = G__7766;
chunk__7714_7755 = G__7767;
count__7715_7756 = G__7768;
i__7716_7757 = G__7769;
continue;
} else {
var fld_7770 = cljs.core.first.call(null,seq__7713_7764__$1);
cljs.compiler.emitln.call(null,"this.",fld_7770," = ",fld_7770,";");


var G__7771 = cljs.core.next.call(null,seq__7713_7764__$1);
var G__7772 = null;
var G__7773 = (0);
var G__7774 = (0);
seq__7713_7754 = G__7771;
chunk__7714_7755 = G__7772;
count__7715_7756 = G__7773;
i__7716_7757 = G__7774;
continue;
}
} else {
}
}
break;
}

var seq__7717_7775 = cljs.core.seq.call(null,pmasks);
var chunk__7718_7776 = null;
var count__7719_7777 = (0);
var i__7720_7778 = (0);
while(true){
if((i__7720_7778 < count__7719_7777)){
var vec__7727_7779 = cljs.core._nth.call(null,chunk__7718_7776,i__7720_7778);
var pno_7780 = cljs.core.nth.call(null,vec__7727_7779,(0),null);
var pmask_7781 = cljs.core.nth.call(null,vec__7727_7779,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7780,"$ = ",pmask_7781,";");


var G__7782 = seq__7717_7775;
var G__7783 = chunk__7718_7776;
var G__7784 = count__7719_7777;
var G__7785 = (i__7720_7778 + (1));
seq__7717_7775 = G__7782;
chunk__7718_7776 = G__7783;
count__7719_7777 = G__7784;
i__7720_7778 = G__7785;
continue;
} else {
var temp__5804__auto___7786 = cljs.core.seq.call(null,seq__7717_7775);
if(temp__5804__auto___7786){
var seq__7717_7787__$1 = temp__5804__auto___7786;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7717_7787__$1)){
var c__5568__auto___7788 = cljs.core.chunk_first.call(null,seq__7717_7787__$1);
var G__7789 = cljs.core.chunk_rest.call(null,seq__7717_7787__$1);
var G__7790 = c__5568__auto___7788;
var G__7791 = cljs.core.count.call(null,c__5568__auto___7788);
var G__7792 = (0);
seq__7717_7775 = G__7789;
chunk__7718_7776 = G__7790;
count__7719_7777 = G__7791;
i__7720_7778 = G__7792;
continue;
} else {
var vec__7730_7793 = cljs.core.first.call(null,seq__7717_7787__$1);
var pno_7794 = cljs.core.nth.call(null,vec__7730_7793,(0),null);
var pmask_7795 = cljs.core.nth.call(null,vec__7730_7793,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7794,"$ = ",pmask_7795,";");


var G__7796 = cljs.core.next.call(null,seq__7717_7787__$1);
var G__7797 = null;
var G__7798 = (0);
var G__7799 = (0);
seq__7717_7775 = G__7796;
chunk__7718_7776 = G__7797;
count__7719_7777 = G__7798;
i__7720_7778 = G__7799;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__7800){
var map__7801 = p__7800;
var map__7801__$1 = cljs.core.__destructure_map.call(null,map__7801);
var target = cljs.core.get.call(null,map__7801__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__7801__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__7801__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__7801__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7801__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__7802){
var map__7803 = p__7802;
var map__7803__$1 = cljs.core.__destructure_map.call(null,map__7803);
var op = cljs.core.get.call(null,map__7803__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__7803__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__7803__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__7803__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__7803__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__5043__auto__ = code;
if(cljs.core.truth_(and__5043__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__5043__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__9256__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__7808 = cljs.core.seq.call(null,table);
var chunk__7809 = null;
var count__7810 = (0);
var i__7811 = (0);
while(true){
if((i__7811 < count__7810)){
var vec__7818 = cljs.core._nth.call(null,chunk__7809,i__7811);
var sym = cljs.core.nth.call(null,vec__7818,(0),null);
var value = cljs.core.nth.call(null,vec__7818,(1),null);
var ns_7824 = cljs.core.namespace.call(null,sym);
var name_7825 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7826 = seq__7808;
var G__7827 = chunk__7809;
var G__7828 = count__7810;
var G__7829 = (i__7811 + (1));
seq__7808 = G__7826;
chunk__7809 = G__7827;
count__7810 = G__7828;
i__7811 = G__7829;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__7808);
if(temp__5804__auto__){
var seq__7808__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7808__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__7808__$1);
var G__7830 = cljs.core.chunk_rest.call(null,seq__7808__$1);
var G__7831 = c__5568__auto__;
var G__7832 = cljs.core.count.call(null,c__5568__auto__);
var G__7833 = (0);
seq__7808 = G__7830;
chunk__7809 = G__7831;
count__7810 = G__7832;
i__7811 = G__7833;
continue;
} else {
var vec__7821 = cljs.core.first.call(null,seq__7808__$1);
var sym = cljs.core.nth.call(null,vec__7821,(0),null);
var value = cljs.core.nth.call(null,vec__7821,(1),null);
var ns_7834 = cljs.core.namespace.call(null,sym);
var name_7835 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7836 = cljs.core.next.call(null,seq__7808__$1);
var G__7837 = null;
var G__7838 = (0);
var G__7839 = (0);
seq__7808 = G__7836;
chunk__7809 = G__7837;
count__7810 = G__7838;
i__7811 = G__7839;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__7841 = arguments.length;
switch (G__7841) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs.call(null):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_7846 = cljs.core.first.call(null,ks);
var vec__7842_7847 = cljs.core.conj.call(null,prefix,k_7846);
var top_7848 = cljs.core.nth.call(null,vec__7842_7847,(0),null);
var prefix_SINGLEQUOTE__7849 = vec__7842_7847;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_7846)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__7849) == null)))){
if((!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_7848)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_7848)))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7849)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_7848);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7849)),";");
}
} else {
}

var m_7850 = cljs.core.get.call(null,externs,k_7846);
if(cljs.core.empty_QMARK_.call(null,m_7850)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__7849,m_7850,top_level,known_externs);
}

var G__7851 = cljs.core.next.call(null,ks);
ks = G__7851;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

