// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_12255){
var state_val_12256 = (state_12255[(1)]);
if((state_val_12256 === (7))){
var inst_12250 = (state_12255[(2)]);
var _ = (function (){var statearr_12257 = state_12255;
(statearr_12257[(4)] = cljs.core.rest((state_12255[(4)])));

return statearr_12257;
})();
var state_12255__$1 = state_12255;
var statearr_12258_12280 = state_12255__$1;
(statearr_12258_12280[(2)] = inst_12250);

(statearr_12258_12280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12256 === (1))){
var state_12255__$1 = state_12255;
var statearr_12259_12281 = state_12255__$1;
(statearr_12259_12281[(2)] = null);

(statearr_12259_12281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12256 === (4))){
var inst_12212 = (state_12255[(2)]);
var state_12255__$1 = state_12255;
var statearr_12260_12282 = state_12255__$1;
(statearr_12260_12282[(2)] = inst_12212);

(statearr_12260_12282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12256 === (6))){
var inst_12237 = (state_12255[(7)]);
var inst_12230 = (state_12255[(8)]);
var inst_12236 = cljs.core.seq(inst_12230);
var inst_12237__$1 = cljs.core.first(inst_12236);
var inst_12238 = cljs.core.next(inst_12236);
var inst_12239 = cljs.core.not(inst_12237__$1);
var state_12255__$1 = (function (){var statearr_12261 = state_12255;
(statearr_12261[(9)] = inst_12238);

(statearr_12261[(7)] = inst_12237__$1);

return statearr_12261;
})();
if(inst_12239){
var statearr_12262_12283 = state_12255__$1;
(statearr_12262_12283[(1)] = (8));

} else {
var statearr_12263_12284 = state_12255__$1;
(statearr_12263_12284[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12256 === (3))){
var inst_12253 = (state_12255[(2)]);
var state_12255__$1 = state_12255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12255__$1,inst_12253);
} else {
if((state_val_12256 === (2))){
var _ = (function (){var statearr_12264 = state_12255;
(statearr_12264[(4)] = cljs.core.cons((5),(state_12255[(4)])));

return statearr_12264;
})();
var inst_12225 = chs;
var inst_12226 = cljs.core.seq(inst_12225);
var inst_12227 = cljs.core.first(inst_12226);
var inst_12228 = cljs.core.next(inst_12226);
var inst_12229 = coll;
var inst_12230 = inst_12225;
var inst_12231 = inst_12229;
var state_12255__$1 = (function (){var statearr_12265 = state_12255;
(statearr_12265[(10)] = inst_12227);

(statearr_12265[(11)] = inst_12228);

(statearr_12265[(8)] = inst_12230);

(statearr_12265[(12)] = inst_12231);

return statearr_12265;
})();
var statearr_12266_12285 = state_12255__$1;
(statearr_12266_12285[(2)] = null);

(statearr_12266_12285[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12256 === (11))){
var inst_12238 = (state_12255[(9)]);
var inst_12231 = (state_12255[(12)]);
var inst_12243 = (state_12255[(2)]);
var inst_12244 = fluree.db.util.async.throw_err(inst_12243);
var inst_12245 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12231,inst_12244);
var inst_12230 = inst_12238;
var inst_12231__$1 = inst_12245;
var state_12255__$1 = (function (){var statearr_12268 = state_12255;
(statearr_12268[(8)] = inst_12230);

(statearr_12268[(12)] = inst_12231__$1);

return statearr_12268;
})();
var statearr_12269_12286 = state_12255__$1;
(statearr_12269_12286[(2)] = null);

(statearr_12269_12286[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12256 === (9))){
var inst_12237 = (state_12255[(7)]);
var state_12255__$1 = state_12255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12255__$1,(11),inst_12237);
} else {
if((state_val_12256 === (5))){
var _ = (function (){var statearr_12270 = state_12255;
(statearr_12270[(4)] = cljs.core.rest((state_12255[(4)])));

return statearr_12270;
})();
var state_12255__$1 = state_12255;
var ex12267 = (state_12255__$1[(2)]);
var statearr_12271_12287 = state_12255__$1;
(statearr_12271_12287[(5)] = ex12267);


var statearr_12272_12288 = state_12255__$1;
(statearr_12272_12288[(1)] = (4));

(statearr_12272_12288[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12256 === (10))){
var inst_12248 = (state_12255[(2)]);
var state_12255__$1 = state_12255;
var statearr_12273_12289 = state_12255__$1;
(statearr_12273_12289[(2)] = inst_12248);

(statearr_12273_12289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12256 === (8))){
var inst_12231 = (state_12255[(12)]);
var state_12255__$1 = state_12255;
var statearr_12274_12290 = state_12255__$1;
(statearr_12274_12290[(2)] = inst_12231);

(statearr_12274_12290[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_12275 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12275[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__);

(statearr_12275[(1)] = (1));

return statearr_12275;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1 = (function (state_12255){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_12255);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e12276){var ex__2730__auto__ = e12276;
var statearr_12277_12291 = state_12255;
(statearr_12277_12291[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_12255[(4)]))){
var statearr_12278_12292 = state_12255;
(statearr_12278_12292[(1)] = cljs.core.first((state_12255[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12293 = state_12255;
state_12255 = G__12293;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__ = function(state_12255){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1.call(this,state_12255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_12279 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_12279[(6)] = c__2749__auto__);

return statearr_12279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_12319){
var state_val_12320 = (state_12319[(1)]);
if((state_val_12320 === (7))){
var inst_12314 = (state_12319[(2)]);
var _ = (function (){var statearr_12321 = state_12319;
(statearr_12321[(4)] = cljs.core.rest((state_12319[(4)])));

return statearr_12321;
})();
var state_12319__$1 = state_12319;
var statearr_12322_12344 = state_12319__$1;
(statearr_12322_12344[(2)] = inst_12314);

(statearr_12322_12344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12320 === (1))){
var state_12319__$1 = state_12319;
var statearr_12323_12345 = state_12319__$1;
(statearr_12323_12345[(2)] = null);

(statearr_12323_12345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12320 === (4))){
var inst_12294 = (state_12319[(2)]);
var state_12319__$1 = state_12319;
var statearr_12324_12346 = state_12319__$1;
(statearr_12324_12346[(2)] = inst_12294);

(statearr_12324_12346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12320 === (6))){
var state_12319__$1 = state_12319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12319__$1,(8),chan);
} else {
if((state_val_12320 === (3))){
var inst_12317 = (state_12319[(2)]);
var state_12319__$1 = state_12319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12319__$1,inst_12317);
} else {
if((state_val_12320 === (2))){
var _ = (function (){var statearr_12325 = state_12319;
(statearr_12325[(4)] = cljs.core.cons((5),(state_12319[(4)])));

return statearr_12325;
})();
var inst_12300 = coll;
var inst_12301 = inst_12300;
var state_12319__$1 = (function (){var statearr_12326 = state_12319;
(statearr_12326[(7)] = inst_12301);

return statearr_12326;
})();
var statearr_12327_12347 = state_12319__$1;
(statearr_12327_12347[(2)] = null);

(statearr_12327_12347[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12320 === (11))){
var inst_12312 = (state_12319[(2)]);
var state_12319__$1 = state_12319;
var statearr_12329_12348 = state_12319__$1;
(statearr_12329_12348[(2)] = inst_12312);

(statearr_12329_12348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12320 === (9))){
var inst_12301 = (state_12319[(7)]);
var state_12319__$1 = state_12319;
var statearr_12330_12349 = state_12319__$1;
(statearr_12330_12349[(2)] = inst_12301);

(statearr_12330_12349[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12320 === (5))){
var _ = (function (){var statearr_12331 = state_12319;
(statearr_12331[(4)] = cljs.core.rest((state_12319[(4)])));

return statearr_12331;
})();
var state_12319__$1 = state_12319;
var ex12328 = (state_12319__$1[(2)]);
var statearr_12332_12350 = state_12319__$1;
(statearr_12332_12350[(5)] = ex12328);


var statearr_12333_12351 = state_12319__$1;
(statearr_12333_12351[(1)] = (4));

(statearr_12333_12351[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12320 === (10))){
var inst_12305 = (state_12319[(8)]);
var inst_12301 = (state_12319[(7)]);
var inst_12309 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12301,inst_12305);
var inst_12301__$1 = inst_12309;
var state_12319__$1 = (function (){var statearr_12334 = state_12319;
(statearr_12334[(7)] = inst_12301__$1);

return statearr_12334;
})();
var statearr_12335_12352 = state_12319__$1;
(statearr_12335_12352[(2)] = null);

(statearr_12335_12352[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12320 === (8))){
var inst_12305 = (state_12319[(8)]);
var inst_12304 = (state_12319[(2)]);
var inst_12305__$1 = fluree.db.util.async.throw_err(inst_12304);
var inst_12306 = (inst_12305__$1 == null);
var state_12319__$1 = (function (){var statearr_12336 = state_12319;
(statearr_12336[(8)] = inst_12305__$1);

return statearr_12336;
})();
if(cljs.core.truth_(inst_12306)){
var statearr_12337_12353 = state_12319__$1;
(statearr_12337_12353[(1)] = (9));

} else {
var statearr_12338_12354 = state_12319__$1;
(statearr_12338_12354[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_12339 = [null,null,null,null,null,null,null,null,null];
(statearr_12339[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__);

(statearr_12339[(1)] = (1));

return statearr_12339;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1 = (function (state_12319){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_12319);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e12340){var ex__2730__auto__ = e12340;
var statearr_12341_12355 = state_12319;
(statearr_12341_12355[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_12319[(4)]))){
var statearr_12342_12356 = state_12319;
(statearr_12342_12356[(1)] = cljs.core.first((state_12319[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12357 = state_12319;
state_12319 = G__12357;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__ = function(state_12319){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1.call(this,state_12319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_12343 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_12343[(6)] = c__2749__auto__);

return statearr_12343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
