// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18073){
var state_val_18074 = (state_18073[(1)]);
if((state_val_18074 === (7))){
var inst_18062 = (state_18073[(7)]);
var inst_18064 = fluree.db.storage.core.serde(conn);
var inst_18065 = fluree.db.serde.protocol._deserialize_block(inst_18064,inst_18062);
var state_18073__$1 = state_18073;
var statearr_18075_18094 = state_18073__$1;
(statearr_18075_18094[(2)] = inst_18065);

(statearr_18075_18094[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18074 === (1))){
var state_18073__$1 = state_18073;
var statearr_18076_18095 = state_18073__$1;
(statearr_18076_18095[(2)] = null);

(statearr_18076_18095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18074 === (4))){
var inst_18052 = (state_18073[(2)]);
var state_18073__$1 = state_18073;
var statearr_18077_18096 = state_18073__$1;
(statearr_18077_18096[(2)] = inst_18052);

(statearr_18077_18096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18074 === (6))){
var inst_18062 = (state_18073[(7)]);
var inst_18061 = (state_18073[(2)]);
var inst_18062__$1 = fluree.db.util.async.throw_err(inst_18061);
var state_18073__$1 = (function (){var statearr_18078 = state_18073;
(statearr_18078[(7)] = inst_18062__$1);

return statearr_18078;
})();
if(cljs.core.truth_(inst_18062__$1)){
var statearr_18079_18097 = state_18073__$1;
(statearr_18079_18097[(1)] = (7));

} else {
var statearr_18080_18098 = state_18073__$1;
(statearr_18080_18098[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18074 === (3))){
var inst_18071 = (state_18073[(2)]);
var state_18073__$1 = state_18073;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18073__$1,inst_18071);
} else {
if((state_val_18074 === (2))){
var _ = (function (){var statearr_18082 = state_18073;
(statearr_18082[(4)] = cljs.core.cons((5),(state_18073[(4)])));

return statearr_18082;
})();
var inst_18058 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_18059 = fluree.db.storage.core.storage_read(conn,inst_18058);
var state_18073__$1 = state_18073;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18073__$1,(6),inst_18059);
} else {
if((state_val_18074 === (9))){
var inst_18068 = (state_18073[(2)]);
var _ = (function (){var statearr_18083 = state_18073;
(statearr_18083[(4)] = cljs.core.rest((state_18073[(4)])));

return statearr_18083;
})();
var state_18073__$1 = state_18073;
var statearr_18084_18099 = state_18073__$1;
(statearr_18084_18099[(2)] = inst_18068);

(statearr_18084_18099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18074 === (5))){
var _ = (function (){var statearr_18085 = state_18073;
(statearr_18085[(4)] = cljs.core.rest((state_18073[(4)])));

return statearr_18085;
})();
var state_18073__$1 = state_18073;
var ex18081 = (state_18073__$1[(2)]);
var statearr_18086_18100 = state_18073__$1;
(statearr_18086_18100[(5)] = ex18081);


if((ex18081 instanceof Error)){
var statearr_18087_18101 = state_18073__$1;
(statearr_18087_18101[(1)] = (4));

(statearr_18087_18101[(5)] = null);

} else {
throw ex18081;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18074 === (8))){
var state_18073__$1 = state_18073;
var statearr_18088_18102 = state_18073__$1;
(statearr_18088_18102[(2)] = null);

(statearr_18088_18102[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____0 = (function (){
var statearr_18089 = [null,null,null,null,null,null,null,null];
(statearr_18089[(0)] = fluree$db$storage$core$read_block_$_state_machine__2727__auto__);

(statearr_18089[(1)] = (1));

return statearr_18089;
});
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____1 = (function (state_18073){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18073);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18090){var ex__2730__auto__ = e18090;
var statearr_18091_18103 = state_18073;
(statearr_18091_18103[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18073[(4)]))){
var statearr_18092_18104 = state_18073;
(statearr_18092_18104[(1)] = cljs.core.first((state_18073[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18105 = state_18073;
state_18073 = G__18105;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = function(state_18073){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____1.call(this,state_18073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18093 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18093[(6)] = c__2749__auto__);

return statearr_18093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18128){
var state_val_18129 = (state_18128[(1)]);
if((state_val_18129 === (7))){
var inst_18117 = (state_18128[(7)]);
var inst_18119 = fluree.db.storage.core.serde(conn);
var inst_18120 = fluree.db.serde.protocol._deserialize_block(inst_18119,inst_18117);
var state_18128__$1 = state_18128;
var statearr_18130_18149 = state_18128__$1;
(statearr_18130_18149[(2)] = inst_18120);

(statearr_18130_18149[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (1))){
var state_18128__$1 = state_18128;
var statearr_18131_18150 = state_18128__$1;
(statearr_18131_18150[(2)] = null);

(statearr_18131_18150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (4))){
var inst_18106 = (state_18128[(2)]);
var state_18128__$1 = state_18128;
var statearr_18132_18151 = state_18128__$1;
(statearr_18132_18151[(2)] = inst_18106);

(statearr_18132_18151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (6))){
var inst_18117 = (state_18128[(7)]);
var inst_18116 = (state_18128[(2)]);
var inst_18117__$1 = fluree.db.util.async.throw_err(inst_18116);
var state_18128__$1 = (function (){var statearr_18133 = state_18128;
(statearr_18133[(7)] = inst_18117__$1);

return statearr_18133;
})();
if(cljs.core.truth_(inst_18117__$1)){
var statearr_18134_18152 = state_18128__$1;
(statearr_18134_18152[(1)] = (7));

} else {
var statearr_18135_18153 = state_18128__$1;
(statearr_18135_18153[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (3))){
var inst_18126 = (state_18128[(2)]);
var state_18128__$1 = state_18128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18128__$1,inst_18126);
} else {
if((state_val_18129 === (2))){
var _ = (function (){var statearr_18137 = state_18128;
(statearr_18137[(4)] = cljs.core.cons((5),(state_18128[(4)])));

return statearr_18137;
})();
var inst_18112 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_18113 = [inst_18112,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_18114 = fluree.db.storage.core.storage_read(conn,inst_18113);
var state_18128__$1 = state_18128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18128__$1,(6),inst_18114);
} else {
if((state_val_18129 === (9))){
var inst_18123 = (state_18128[(2)]);
var _ = (function (){var statearr_18138 = state_18128;
(statearr_18138[(4)] = cljs.core.rest((state_18128[(4)])));

return statearr_18138;
})();
var state_18128__$1 = state_18128;
var statearr_18139_18154 = state_18128__$1;
(statearr_18139_18154[(2)] = inst_18123);

(statearr_18139_18154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (5))){
var _ = (function (){var statearr_18140 = state_18128;
(statearr_18140[(4)] = cljs.core.rest((state_18128[(4)])));

return statearr_18140;
})();
var state_18128__$1 = state_18128;
var ex18136 = (state_18128__$1[(2)]);
var statearr_18141_18155 = state_18128__$1;
(statearr_18141_18155[(5)] = ex18136);


if((ex18136 instanceof Error)){
var statearr_18142_18156 = state_18128__$1;
(statearr_18142_18156[(1)] = (4));

(statearr_18142_18156[(5)] = null);

} else {
throw ex18136;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18129 === (8))){
var state_18128__$1 = state_18128;
var statearr_18143_18157 = state_18128__$1;
(statearr_18143_18157[(2)] = null);

(statearr_18143_18157[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_18144 = [null,null,null,null,null,null,null,null];
(statearr_18144[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__);

(statearr_18144[(1)] = (1));

return statearr_18144;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1 = (function (state_18128){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18128);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18145){var ex__2730__auto__ = e18145;
var statearr_18146_18158 = state_18128;
(statearr_18146_18158[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18128[(4)]))){
var statearr_18147_18159 = state_18128;
(statearr_18147_18159[(1)] = cljs.core.first((state_18128[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18160 = state_18128;
state_18128 = G__18160;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = function(state_18128){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1.call(this,state_18128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18148 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18148[(6)] = c__2749__auto__);

return statearr_18148;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18184){
var state_val_18185 = (state_18184[(1)]);
if((state_val_18185 === (1))){
var state_18184__$1 = state_18184;
var statearr_18186_18200 = state_18184__$1;
(statearr_18186_18200[(2)] = null);

(statearr_18186_18200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18185 === (2))){
var _ = (function (){var statearr_18187 = state_18184;
(statearr_18187[(4)] = cljs.core.cons((5),(state_18184[(4)])));

return statearr_18187;
})();
var inst_18167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18168 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_18169 = (new cljs.core.PersistentVector(null,3,(5),inst_18167,inst_18168,null));
var inst_18170 = cljs.core.select_keys(block_data,inst_18169);
var inst_18171 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_18170);
var inst_18172 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_18171);
var inst_18173 = [inst_18172,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_18174 = fluree.db.storage.core.serde(conn);
var inst_18175 = fluree.db.serde.protocol._serialize_block(inst_18174,inst_18170);
var inst_18176 = fluree.db.storage.core.storage_write(conn,inst_18173,inst_18175);
var state_18184__$1 = state_18184;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18184__$1,(6),inst_18176);
} else {
if((state_val_18185 === (3))){
var inst_18182 = (state_18184[(2)]);
var state_18184__$1 = state_18184;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18184__$1,inst_18182);
} else {
if((state_val_18185 === (4))){
var inst_18161 = (state_18184[(2)]);
var state_18184__$1 = state_18184;
var statearr_18189_18201 = state_18184__$1;
(statearr_18189_18201[(2)] = inst_18161);

(statearr_18189_18201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18185 === (5))){
var _ = (function (){var statearr_18190 = state_18184;
(statearr_18190[(4)] = cljs.core.rest((state_18184[(4)])));

return statearr_18190;
})();
var state_18184__$1 = state_18184;
var ex18188 = (state_18184__$1[(2)]);
var statearr_18191_18202 = state_18184__$1;
(statearr_18191_18202[(5)] = ex18188);


if((ex18188 instanceof Error)){
var statearr_18192_18203 = state_18184__$1;
(statearr_18192_18203[(1)] = (4));

(statearr_18192_18203[(5)] = null);

} else {
throw ex18188;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18185 === (6))){
var inst_18178 = (state_18184[(2)]);
var inst_18179 = fluree.db.util.async.throw_err(inst_18178);
var _ = (function (){var statearr_18193 = state_18184;
(statearr_18193[(4)] = cljs.core.rest((state_18184[(4)])));

return statearr_18193;
})();
var state_18184__$1 = state_18184;
var statearr_18194_18204 = state_18184__$1;
(statearr_18194_18204[(2)] = inst_18179);

(statearr_18194_18204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_18195 = [null,null,null,null,null,null,null];
(statearr_18195[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__);

(statearr_18195[(1)] = (1));

return statearr_18195;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1 = (function (state_18184){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18184);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18196){var ex__2730__auto__ = e18196;
var statearr_18197_18205 = state_18184;
(statearr_18197_18205[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18184[(4)]))){
var statearr_18198_18206 = state_18184;
(statearr_18198_18206[(1)] = cljs.core.first((state_18184[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18207 = state_18184;
state_18184 = G__18207;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = function(state_18184){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1.call(this,state_18184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18199 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18199[(6)] = c__2749__auto__);

return statearr_18199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18230){
var state_val_18231 = (state_18230[(1)]);
if((state_val_18231 === (1))){
var state_18230__$1 = state_18230;
var statearr_18232_18246 = state_18230__$1;
(statearr_18232_18246[(2)] = null);

(statearr_18232_18246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18231 === (2))){
var _ = (function (){var statearr_18233 = state_18230;
(statearr_18233[(4)] = cljs.core.cons((5),(state_18230[(4)])));

return statearr_18233;
})();
var inst_18214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18215 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_18216 = (new cljs.core.PersistentVector(null,3,(5),inst_18214,inst_18215,null));
var inst_18217 = cljs.core.select_keys(block_data,inst_18216);
var inst_18218 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_18217);
var inst_18219 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_18218);
var inst_18220 = fluree.db.storage.core.serde(conn);
var inst_18221 = fluree.db.serde.protocol._serialize_block(inst_18220,inst_18217);
var inst_18222 = fluree.db.storage.core.storage_write(conn,inst_18219,inst_18221);
var state_18230__$1 = state_18230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18230__$1,(6),inst_18222);
} else {
if((state_val_18231 === (3))){
var inst_18228 = (state_18230[(2)]);
var state_18230__$1 = state_18230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18230__$1,inst_18228);
} else {
if((state_val_18231 === (4))){
var inst_18208 = (state_18230[(2)]);
var state_18230__$1 = state_18230;
var statearr_18235_18247 = state_18230__$1;
(statearr_18235_18247[(2)] = inst_18208);

(statearr_18235_18247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18231 === (5))){
var _ = (function (){var statearr_18236 = state_18230;
(statearr_18236[(4)] = cljs.core.rest((state_18230[(4)])));

return statearr_18236;
})();
var state_18230__$1 = state_18230;
var ex18234 = (state_18230__$1[(2)]);
var statearr_18237_18248 = state_18230__$1;
(statearr_18237_18248[(5)] = ex18234);


if((ex18234 instanceof Error)){
var statearr_18238_18249 = state_18230__$1;
(statearr_18238_18249[(1)] = (4));

(statearr_18238_18249[(5)] = null);

} else {
throw ex18234;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18231 === (6))){
var inst_18224 = (state_18230[(2)]);
var inst_18225 = fluree.db.util.async.throw_err(inst_18224);
var _ = (function (){var statearr_18239 = state_18230;
(statearr_18239[(4)] = cljs.core.rest((state_18230[(4)])));

return statearr_18239;
})();
var state_18230__$1 = state_18230;
var statearr_18240_18250 = state_18230__$1;
(statearr_18240_18250[(2)] = inst_18225);

(statearr_18240_18250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____0 = (function (){
var statearr_18241 = [null,null,null,null,null,null,null];
(statearr_18241[(0)] = fluree$db$storage$core$write_block_$_state_machine__2727__auto__);

(statearr_18241[(1)] = (1));

return statearr_18241;
});
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____1 = (function (state_18230){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18230);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18242){var ex__2730__auto__ = e18242;
var statearr_18243_18251 = state_18230;
(statearr_18243_18251[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18230[(4)]))){
var statearr_18244_18252 = state_18230;
(statearr_18244_18252[(1)] = cljs.core.first((state_18230[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18253 = state_18230;
state_18230 = G__18253;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = function(state_18230){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____1.call(this,state_18230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18245 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18245[(6)] = c__2749__auto__);

return statearr_18245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18273){
var state_val_18274 = (state_18273[(1)]);
if((state_val_18274 === (1))){
var state_18273__$1 = state_18273;
var statearr_18275_18289 = state_18273__$1;
(statearr_18275_18289[(2)] = null);

(statearr_18275_18289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18274 === (2))){
var _ = (function (){var statearr_18276 = state_18273;
(statearr_18276[(4)] = cljs.core.cons((5),(state_18273[(4)])));

return statearr_18276;
})();
var inst_18260 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_18261 = [history,next_his_key];
var inst_18262 = cljs.core.PersistentHashMap.fromArrays(inst_18260,inst_18261);
var inst_18263 = fluree.db.storage.core.serde(conn);
var inst_18264 = fluree.db.serde.protocol._serialize_leaf(inst_18263,inst_18262);
var inst_18265 = fluree.db.storage.core.storage_write(conn,his_key,inst_18264);
var state_18273__$1 = state_18273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18273__$1,(6),inst_18265);
} else {
if((state_val_18274 === (3))){
var inst_18271 = (state_18273[(2)]);
var state_18273__$1 = state_18273;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18273__$1,inst_18271);
} else {
if((state_val_18274 === (4))){
var inst_18254 = (state_18273[(2)]);
var state_18273__$1 = state_18273;
var statearr_18278_18290 = state_18273__$1;
(statearr_18278_18290[(2)] = inst_18254);

(statearr_18278_18290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18274 === (5))){
var _ = (function (){var statearr_18279 = state_18273;
(statearr_18279[(4)] = cljs.core.rest((state_18273[(4)])));

return statearr_18279;
})();
var state_18273__$1 = state_18273;
var ex18277 = (state_18273__$1[(2)]);
var statearr_18280_18291 = state_18273__$1;
(statearr_18280_18291[(5)] = ex18277);


if((ex18277 instanceof Error)){
var statearr_18281_18292 = state_18273__$1;
(statearr_18281_18292[(1)] = (4));

(statearr_18281_18292[(5)] = null);

} else {
throw ex18277;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18274 === (6))){
var inst_18267 = (state_18273[(2)]);
var inst_18268 = fluree.db.util.async.throw_err(inst_18267);
var _ = (function (){var statearr_18282 = state_18273;
(statearr_18282[(4)] = cljs.core.rest((state_18273[(4)])));

return statearr_18282;
})();
var state_18273__$1 = state_18273;
var statearr_18283_18293 = state_18273__$1;
(statearr_18283_18293[(2)] = inst_18268);

(statearr_18283_18293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2727__auto____0 = (function (){
var statearr_18284 = [null,null,null,null,null,null,null];
(statearr_18284[(0)] = fluree$db$storage$core$write_history_$_state_machine__2727__auto__);

(statearr_18284[(1)] = (1));

return statearr_18284;
});
var fluree$db$storage$core$write_history_$_state_machine__2727__auto____1 = (function (state_18273){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18273);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18285){var ex__2730__auto__ = e18285;
var statearr_18286_18294 = state_18273;
(statearr_18286_18294[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18273[(4)]))){
var statearr_18287_18295 = state_18273;
(statearr_18287_18295[(1)] = cljs.core.first((state_18273[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18296 = state_18273;
state_18273 = G__18296;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2727__auto__ = function(state_18273){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2727__auto____1.call(this,state_18273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18288 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18288[(6)] = c__2749__auto__);

return statearr_18288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18322){
var state_val_18323 = (state_18322[(1)]);
if((state_val_18323 === (1))){
var state_18322__$1 = state_18322;
var statearr_18324_18341 = state_18322__$1;
(statearr_18324_18341[(2)] = null);

(statearr_18324_18341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18323 === (2))){
var inst_18303 = (state_18322[(7)]);
var _ = (function (){var statearr_18325 = state_18322;
(statearr_18325[(4)] = cljs.core.cons((5),(state_18322[(4)])));

return statearr_18325;
})();
var inst_18303__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_18304 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18303__$1),"-his"].join('');
var inst_18305 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_18306 = [flakes,inst_18304];
var inst_18307 = cljs.core.PersistentHashMap.fromArrays(inst_18305,inst_18306);
var inst_18308 = fluree.db.storage.core.serde(conn);
var inst_18309 = fluree.db.serde.protocol._serialize_leaf(inst_18308,inst_18307);
var inst_18310 = fluree.db.storage.core.write_history(conn,history,inst_18304,null);
var inst_18311 = fluree.db.storage.core.storage_write(conn,inst_18303__$1,inst_18309);
var state_18322__$1 = (function (){var statearr_18326 = state_18322;
(statearr_18326[(8)] = inst_18311);

(statearr_18326[(7)] = inst_18303__$1);

return statearr_18326;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18322__$1,(6),inst_18310);
} else {
if((state_val_18323 === (3))){
var inst_18320 = (state_18322[(2)]);
var state_18322__$1 = state_18322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18322__$1,inst_18320);
} else {
if((state_val_18323 === (4))){
var inst_18297 = (state_18322[(2)]);
var state_18322__$1 = state_18322;
var statearr_18328_18342 = state_18322__$1;
(statearr_18328_18342[(2)] = inst_18297);

(statearr_18328_18342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18323 === (5))){
var _ = (function (){var statearr_18329 = state_18322;
(statearr_18329[(4)] = cljs.core.rest((state_18322[(4)])));

return statearr_18329;
})();
var state_18322__$1 = state_18322;
var ex18327 = (state_18322__$1[(2)]);
var statearr_18330_18343 = state_18322__$1;
(statearr_18330_18343[(5)] = ex18327);


if((ex18327 instanceof Error)){
var statearr_18331_18344 = state_18322__$1;
(statearr_18331_18344[(1)] = (4));

(statearr_18331_18344[(5)] = null);

} else {
throw ex18327;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18323 === (6))){
var inst_18311 = (state_18322[(8)]);
var inst_18313 = (state_18322[(2)]);
var inst_18314 = fluree.db.util.async.throw_err(inst_18313);
var state_18322__$1 = (function (){var statearr_18332 = state_18322;
(statearr_18332[(9)] = inst_18314);

return statearr_18332;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18322__$1,(7),inst_18311);
} else {
if((state_val_18323 === (7))){
var inst_18303 = (state_18322[(7)]);
var inst_18316 = (state_18322[(2)]);
var inst_18317 = fluree.db.util.async.throw_err(inst_18316);
var _ = (function (){var statearr_18333 = state_18322;
(statearr_18333[(4)] = cljs.core.rest((state_18322[(4)])));

return statearr_18333;
})();
var state_18322__$1 = (function (){var statearr_18334 = state_18322;
(statearr_18334[(10)] = inst_18317);

return statearr_18334;
})();
var statearr_18335_18345 = state_18322__$1;
(statearr_18335_18345[(2)] = inst_18303);

(statearr_18335_18345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_18336 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18336[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__);

(statearr_18336[(1)] = (1));

return statearr_18336;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____1 = (function (state_18322){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18322);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18337){var ex__2730__auto__ = e18337;
var statearr_18338_18346 = state_18322;
(statearr_18338_18346[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18322[(4)]))){
var statearr_18339_18347 = state_18322;
(statearr_18339_18347[(1)] = cljs.core.first((state_18322[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18348 = state_18322;
state_18322 = G__18348;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__ = function(state_18322){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____1.call(this,state_18322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18340 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18340[(6)] = c__2749__auto__);

return statearr_18340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18365){
var state_val_18366 = (state_18365[(1)]);
if((state_val_18366 === (1))){
var state_18365__$1 = state_18365;
var statearr_18367_18382 = state_18365__$1;
(statearr_18367_18382[(2)] = null);

(statearr_18367_18382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18366 === (2))){
var _ = (function (){var statearr_18368 = state_18365;
(statearr_18368[(4)] = cljs.core.cons((5),(state_18365[(4)])));

return statearr_18368;
})();
var inst_18355 = fluree.db.storage.core.serde(conn);
var inst_18356 = fluree.db.serde.protocol._serialize_branch(inst_18355,data);
var inst_18357 = fluree.db.storage.core.storage_write(conn,key,inst_18356);
var state_18365__$1 = state_18365;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18365__$1,(6),inst_18357);
} else {
if((state_val_18366 === (3))){
var inst_18363 = (state_18365[(2)]);
var state_18365__$1 = state_18365;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18365__$1,inst_18363);
} else {
if((state_val_18366 === (4))){
var inst_18349 = (state_18365[(2)]);
var state_18365__$1 = state_18365;
var statearr_18370_18383 = state_18365__$1;
(statearr_18370_18383[(2)] = inst_18349);

(statearr_18370_18383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18366 === (5))){
var _ = (function (){var statearr_18371 = state_18365;
(statearr_18371[(4)] = cljs.core.rest((state_18365[(4)])));

return statearr_18371;
})();
var state_18365__$1 = state_18365;
var ex18369 = (state_18365__$1[(2)]);
var statearr_18372_18384 = state_18365__$1;
(statearr_18372_18384[(5)] = ex18369);


if((ex18369 instanceof Error)){
var statearr_18373_18385 = state_18365__$1;
(statearr_18373_18385[(1)] = (4));

(statearr_18373_18385[(5)] = null);

} else {
throw ex18369;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18366 === (6))){
var inst_18359 = (state_18365[(2)]);
var inst_18360 = fluree.db.util.async.throw_err(inst_18359);
var _ = (function (){var statearr_18374 = state_18365;
(statearr_18374[(4)] = cljs.core.rest((state_18365[(4)])));

return statearr_18374;
})();
var state_18365__$1 = (function (){var statearr_18375 = state_18365;
(statearr_18375[(7)] = inst_18360);

return statearr_18375;
})();
var statearr_18376_18386 = state_18365__$1;
(statearr_18376_18386[(2)] = key);

(statearr_18376_18386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0 = (function (){
var statearr_18377 = [null,null,null,null,null,null,null,null];
(statearr_18377[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__);

(statearr_18377[(1)] = (1));

return statearr_18377;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1 = (function (state_18365){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18365);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18378){var ex__2730__auto__ = e18378;
var statearr_18379_18387 = state_18365;
(statearr_18379_18387[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18365[(4)]))){
var statearr_18380_18388 = state_18365;
(statearr_18380_18388[(1)] = cljs.core.first((state_18365[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18389 = state_18365;
state_18365 = G__18389;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = function(state_18365){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1.call(this,state_18365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18381 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18381[(6)] = c__2749__auto__);

return statearr_18381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__18390_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__18390_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__18391){
var map__18392 = p__18391;
var map__18392__$1 = cljs.core.__destructure_map(map__18392);
var progress = map__18392__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18392__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18420){
var state_val_18421 = (state_18420[(1)]);
if((state_val_18421 === (1))){
var state_18420__$1 = state_18420;
var statearr_18422_18438 = state_18420__$1;
(statearr_18422_18438[(2)] = null);

(statearr_18422_18438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18421 === (2))){
var inst_18406 = (state_18420[(7)]);
var _ = (function (){var statearr_18423 = state_18420;
(statearr_18423[(4)] = cljs.core.cons((5),(state_18420[(4)])));

return statearr_18423;
})();
var inst_18400 = db;
var inst_18401 = cljs.core.__destructure_map(inst_18400);
var inst_18402 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18401,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18403 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18401,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18404 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18401,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18405 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18401,new cljs.core.Keyword(null,"block","block",664686210));
var inst_18406__$1 = fluree.db.storage.core.ledger_garbage_key(inst_18403,inst_18404,inst_18405);
var inst_18407 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_18408 = [inst_18404,inst_18405,garbage];
var inst_18409 = cljs.core.PersistentHashMap.fromArrays(inst_18407,inst_18408);
var inst_18410 = fluree.db.storage.core.serde(inst_18402);
var inst_18411 = fluree.db.serde.protocol._serialize_garbage(inst_18410,inst_18409);
var inst_18412 = fluree.db.storage.core.storage_write(inst_18402,inst_18406__$1,inst_18411);
var state_18420__$1 = (function (){var statearr_18424 = state_18420;
(statearr_18424[(7)] = inst_18406__$1);

return statearr_18424;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18420__$1,(6),inst_18412);
} else {
if((state_val_18421 === (3))){
var inst_18418 = (state_18420[(2)]);
var state_18420__$1 = state_18420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18420__$1,inst_18418);
} else {
if((state_val_18421 === (4))){
var inst_18393 = (state_18420[(2)]);
var state_18420__$1 = state_18420;
var statearr_18426_18439 = state_18420__$1;
(statearr_18426_18439[(2)] = inst_18393);

(statearr_18426_18439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18421 === (5))){
var _ = (function (){var statearr_18427 = state_18420;
(statearr_18427[(4)] = cljs.core.rest((state_18420[(4)])));

return statearr_18427;
})();
var state_18420__$1 = state_18420;
var ex18425 = (state_18420__$1[(2)]);
var statearr_18428_18440 = state_18420__$1;
(statearr_18428_18440[(5)] = ex18425);


if((ex18425 instanceof Error)){
var statearr_18429_18441 = state_18420__$1;
(statearr_18429_18441[(1)] = (4));

(statearr_18429_18441[(5)] = null);

} else {
throw ex18425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18421 === (6))){
var inst_18406 = (state_18420[(7)]);
var inst_18414 = (state_18420[(2)]);
var inst_18415 = fluree.db.util.async.throw_err(inst_18414);
var _ = (function (){var statearr_18430 = state_18420;
(statearr_18430[(4)] = cljs.core.rest((state_18420[(4)])));

return statearr_18430;
})();
var state_18420__$1 = (function (){var statearr_18431 = state_18420;
(statearr_18431[(8)] = inst_18415);

return statearr_18431;
})();
var statearr_18432_18442 = state_18420__$1;
(statearr_18432_18442[(2)] = inst_18406);

(statearr_18432_18442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_18433 = [null,null,null,null,null,null,null,null,null];
(statearr_18433[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__);

(statearr_18433[(1)] = (1));

return statearr_18433;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1 = (function (state_18420){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18420);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18434){var ex__2730__auto__ = e18434;
var statearr_18435_18443 = state_18420;
(statearr_18435_18443[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18420[(4)]))){
var statearr_18436_18444 = state_18420;
(statearr_18436_18444[(1)] = cljs.core.first((state_18420[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18445 = state_18420;
state_18420 = G__18445;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = function(state_18420){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1.call(this,state_18420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18437 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18437[(6)] = c__2749__auto__);

return statearr_18437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__18447 = arguments.length;
switch (G__18447) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18503){
var state_val_18504 = (state_18503[(1)]);
if((state_val_18504 === (7))){
var state_18503__$1 = state_18503;
var statearr_18505_18531 = state_18503__$1;
(statearr_18505_18531[(2)] = (0));

(statearr_18505_18531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18504 === (1))){
var state_18503__$1 = state_18503;
var statearr_18506_18532 = state_18503__$1;
(statearr_18506_18532[(2)] = null);

(statearr_18506_18532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18504 === (4))){
var inst_18448 = (state_18503[(2)]);
var state_18503__$1 = state_18503;
var statearr_18507_18533 = state_18503__$1;
(statearr_18507_18533[(2)] = inst_18448);

(statearr_18507_18533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18504 === (6))){
var inst_18473 = (state_18503[(7)]);
var state_18503__$1 = state_18503;
var statearr_18508_18534 = state_18503__$1;
(statearr_18508_18534[(2)] = inst_18473);

(statearr_18508_18534[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18504 === (3))){
var inst_18501 = (state_18503[(2)]);
var state_18503__$1 = state_18503;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18503__$1,inst_18501);
} else {
if((state_val_18504 === (12))){
var inst_18470 = (state_18503[(8)]);
var inst_18497 = (state_18503[(2)]);
var inst_18498 = fluree.db.util.async.throw_err(inst_18497);
var _ = (function (){var statearr_18509 = state_18503;
(statearr_18509[(4)] = cljs.core.rest((state_18503[(4)])));

return statearr_18509;
})();
var state_18503__$1 = (function (){var statearr_18510 = state_18503;
(statearr_18510[(9)] = inst_18498);

return statearr_18510;
})();
var statearr_18511_18535 = state_18503__$1;
(statearr_18511_18535[(2)] = inst_18470);

(statearr_18511_18535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18504 === (2))){
var inst_18461 = (state_18503[(10)]);
var inst_18473 = (state_18503[(7)]);
var inst_18465 = (state_18503[(11)]);
var inst_18463 = (state_18503[(12)]);
var _ = (function (){var statearr_18512 = state_18503;
(statearr_18512[(4)] = cljs.core.cons((5),(state_18503[(4)])));

return statearr_18512;
})();
var inst_18455 = db;
var inst_18456 = cljs.core.__destructure_map(inst_18455);
var inst_18457 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18458 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_18459 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_18460 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_18461__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_18462 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18463__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"block","block",664686210));
var inst_18464 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_18465__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18466 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_18467 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_18468 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_18469 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18456,new cljs.core.Keyword(null,"post","post",269697687));
var inst_18470 = fluree.db.storage.core.ledger_root_key(inst_18457,inst_18465__$1,inst_18463__$1);
var inst_18471 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_18472 = fluree.db.storage.core.child_data(inst_18464);
var inst_18473__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_18461__$1);
var state_18503__$1 = (function (){var statearr_18513 = state_18503;
(statearr_18513[(13)] = inst_18462);

(statearr_18513[(14)] = inst_18469);

(statearr_18513[(10)] = inst_18461__$1);

(statearr_18513[(7)] = inst_18473__$1);

(statearr_18513[(15)] = inst_18471);

(statearr_18513[(11)] = inst_18465__$1);

(statearr_18513[(16)] = inst_18472);

(statearr_18513[(17)] = inst_18458);

(statearr_18513[(18)] = inst_18468);

(statearr_18513[(19)] = inst_18467);

(statearr_18513[(20)] = inst_18459);

(statearr_18513[(12)] = inst_18463__$1);

(statearr_18513[(8)] = inst_18470);

(statearr_18513[(21)] = inst_18466);

(statearr_18513[(22)] = inst_18460);

return statearr_18513;
})();
if(cljs.core.truth_(inst_18473__$1)){
var statearr_18514_18536 = state_18503__$1;
(statearr_18514_18536[(1)] = (6));

} else {
var statearr_18515_18537 = state_18503__$1;
(statearr_18515_18537[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18504 === (11))){
var inst_18462 = (state_18503[(13)]);
var inst_18477 = (state_18503[(23)]);
var inst_18469 = (state_18503[(14)]);
var inst_18461 = (state_18503[(10)]);
var inst_18471 = (state_18503[(15)]);
var inst_18465 = (state_18503[(11)]);
var inst_18472 = (state_18503[(16)]);
var inst_18458 = (state_18503[(17)]);
var inst_18468 = (state_18503[(18)]);
var inst_18467 = (state_18503[(19)]);
var inst_18459 = (state_18503[(20)]);
var inst_18463 = (state_18503[(12)]);
var inst_18470 = (state_18503[(8)]);
var inst_18460 = (state_18503[(22)]);
var inst_18482 = (state_18503[(2)]);
var inst_18483 = fluree.db.storage.core.child_data(inst_18467);
var inst_18484 = fluree.db.storage.core.child_data(inst_18469);
var inst_18485 = fluree.db.util.core.current_time_millis();
var inst_18486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18487 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_18488 = (new cljs.core.PersistentVector(null,2,(5),inst_18486,inst_18487,null));
var inst_18489 = cljs.core.select_keys(inst_18461,inst_18488);
var inst_18490 = fluree.db.storage.core.child_data(inst_18460);
var inst_18491 = [inst_18463,inst_18472,inst_18465,inst_18477,inst_18482,inst_18483,inst_18484,inst_18458,inst_18485,inst_18459,inst_18468,inst_18489,inst_18490];
var inst_18492 = cljs.core.PersistentHashMap.fromArrays(inst_18471,inst_18491);
var inst_18493 = fluree.db.storage.core.serde(inst_18462);
var inst_18494 = fluree.db.serde.protocol._serialize_db_root(inst_18493,inst_18492);
var inst_18495 = fluree.db.storage.core.storage_write(inst_18462,inst_18470,inst_18494);
var state_18503__$1 = state_18503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18503__$1,(12),inst_18495);
} else {
if((state_val_18504 === (9))){
var inst_18478 = (state_18503[(24)]);
var state_18503__$1 = state_18503;
var statearr_18517_18538 = state_18503__$1;
(statearr_18517_18538[(2)] = inst_18478);

(statearr_18517_18538[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18504 === (5))){
var _ = (function (){var statearr_18518 = state_18503;
(statearr_18518[(4)] = cljs.core.rest((state_18503[(4)])));

return statearr_18518;
})();
var state_18503__$1 = state_18503;
var ex18516 = (state_18503__$1[(2)]);
var statearr_18519_18539 = state_18503__$1;
(statearr_18519_18539[(5)] = ex18516);


if((ex18516 instanceof Error)){
var statearr_18520_18540 = state_18503__$1;
(statearr_18520_18540[(1)] = (4));

(statearr_18520_18540[(5)] = null);

} else {
throw ex18516;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18504 === (10))){
var inst_18466 = (state_18503[(21)]);
var state_18503__$1 = state_18503;
var statearr_18521_18541 = state_18503__$1;
(statearr_18521_18541[(2)] = inst_18466);

(statearr_18521_18541[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18504 === (8))){
var inst_18478 = (state_18503[(24)]);
var inst_18477 = (state_18503[(2)]);
var inst_18478__$1 = custom_ecount;
var state_18503__$1 = (function (){var statearr_18522 = state_18503;
(statearr_18522[(23)] = inst_18477);

(statearr_18522[(24)] = inst_18478__$1);

return statearr_18522;
})();
if(cljs.core.truth_(inst_18478__$1)){
var statearr_18523_18542 = state_18503__$1;
(statearr_18523_18542[(1)] = (9));

} else {
var statearr_18524_18543 = state_18503__$1;
(statearr_18524_18543[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_18525 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18525[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_18525[(1)] = (1));

return statearr_18525;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_18503){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18503);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18526){var ex__2730__auto__ = e18526;
var statearr_18527_18544 = state_18503;
(statearr_18527_18544[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18503[(4)]))){
var statearr_18528_18545 = state_18503;
(statearr_18528_18545[(1)] = cljs.core.first((state_18503[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18546 = state_18503;
state_18503 = G__18546;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_18503){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_18503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18529 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18529[(6)] = c__2749__auto__);

return statearr_18529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___18605 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18579){
var state_val_18580 = (state_18579[(1)]);
if((state_val_18580 === (7))){
var inst_18559 = (state_18579[(7)]);
var state_18579__$1 = state_18579;
var statearr_18581_18606 = state_18579__$1;
(statearr_18581_18606[(2)] = inst_18559);

(statearr_18581_18606[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18580 === (1))){
var state_18579__$1 = state_18579;
var statearr_18582_18607 = state_18579__$1;
(statearr_18582_18607[(2)] = null);

(statearr_18582_18607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18580 === (4))){
var inst_18547 = (state_18579[(2)]);
var inst_18548 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18549 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18547);
var inst_18550 = cljs.core.async.close_BANG_(return_ch);
var state_18579__$1 = (function (){var statearr_18583 = state_18579;
(statearr_18583[(8)] = inst_18549);

(statearr_18583[(9)] = inst_18548);

return statearr_18583;
})();
var statearr_18584_18608 = state_18579__$1;
(statearr_18584_18608[(2)] = inst_18550);

(statearr_18584_18608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18580 === (6))){
var inst_18559 = (state_18579[(7)]);
var inst_18558 = (state_18579[(10)]);
var inst_18558__$1 = (state_18579[(2)]);
var inst_18559__$1 = (inst_18558__$1 == null);
var state_18579__$1 = (function (){var statearr_18585 = state_18579;
(statearr_18585[(7)] = inst_18559__$1);

(statearr_18585[(10)] = inst_18558__$1);

return statearr_18585;
})();
if(cljs.core.truth_(inst_18559__$1)){
var statearr_18586_18609 = state_18579__$1;
(statearr_18586_18609[(1)] = (7));

} else {
var statearr_18587_18610 = state_18579__$1;
(statearr_18587_18610[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18580 === (3))){
var inst_18577 = (state_18579[(2)]);
var state_18579__$1 = state_18579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18579__$1,inst_18577);
} else {
if((state_val_18580 === (12))){
var inst_18574 = (state_18579[(2)]);
var _ = (function (){var statearr_18588 = state_18579;
(statearr_18588[(4)] = cljs.core.rest((state_18579[(4)])));

return statearr_18588;
})();
var state_18579__$1 = state_18579;
var statearr_18589_18611 = state_18579__$1;
(statearr_18589_18611[(2)] = inst_18574);

(statearr_18589_18611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18580 === (2))){
var _ = (function (){var statearr_18590 = state_18579;
(statearr_18590[(4)] = cljs.core.cons((5),(state_18579[(4)])));

return statearr_18590;
})();
var inst_18556 = fluree.db.storage.core.storage_read(conn,key);
var state_18579__$1 = state_18579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18579__$1,(6),inst_18556);
} else {
if((state_val_18580 === (11))){
var inst_18558 = (state_18579[(10)]);
var inst_18568 = fluree.db.storage.core.serde(conn);
var inst_18569 = fluree.db.serde.protocol._deserialize_leaf(inst_18568,inst_18558);
var inst_18570 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_18569);
var inst_18571 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_18570);
var inst_18572 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18571);
var state_18579__$1 = state_18579;
var statearr_18592_18612 = state_18579__$1;
(statearr_18592_18612[(2)] = inst_18572);

(statearr_18592_18612[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18580 === (9))){
var inst_18564 = (state_18579[(2)]);
var state_18579__$1 = state_18579;
if(cljs.core.truth_(inst_18564)){
var statearr_18593_18613 = state_18579__$1;
(statearr_18593_18613[(1)] = (10));

} else {
var statearr_18594_18614 = state_18579__$1;
(statearr_18594_18614[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18580 === (5))){
var _ = (function (){var statearr_18595 = state_18579;
(statearr_18595[(4)] = cljs.core.rest((state_18579[(4)])));

return statearr_18595;
})();
var state_18579__$1 = state_18579;
var ex18591 = (state_18579__$1[(2)]);
var statearr_18596_18615 = state_18579__$1;
(statearr_18596_18615[(5)] = ex18591);


var statearr_18597_18616 = state_18579__$1;
(statearr_18597_18616[(1)] = (4));

(statearr_18597_18616[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18580 === (10))){
var inst_18566 = cljs.core.async.close_BANG_(return_ch);
var state_18579__$1 = state_18579;
var statearr_18598_18617 = state_18579__$1;
(statearr_18598_18617[(2)] = inst_18566);

(statearr_18598_18617[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18580 === (8))){
var inst_18558 = (state_18579[(10)]);
var inst_18562 = (inst_18558 instanceof Error);
var state_18579__$1 = state_18579;
var statearr_18599_18618 = state_18579__$1;
(statearr_18599_18618[(2)] = inst_18562);

(statearr_18599_18618[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2727__auto____0 = (function (){
var statearr_18600 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18600[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2727__auto__);

(statearr_18600[(1)] = (1));

return statearr_18600;
});
var fluree$db$storage$core$reify_history_$_state_machine__2727__auto____1 = (function (state_18579){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18579);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18601){var ex__2730__auto__ = e18601;
var statearr_18602_18619 = state_18579;
(statearr_18602_18619[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18579[(4)]))){
var statearr_18603_18620 = state_18579;
(statearr_18603_18620[(1)] = cljs.core.first((state_18579[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18621 = state_18579;
state_18579 = G__18621;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2727__auto__ = function(state_18579){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2727__auto____1.call(this,state_18579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18604 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18604[(6)] = c__2749__auto___18605);

return statearr_18604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__18623 = arguments.length;
switch (G__18623) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___18735 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18686){
var state_val_18687 = (state_18686[(1)]);
if((state_val_18687 === (7))){
var state_18686__$1 = state_18686;
var statearr_18688_18736 = state_18686__$1;
(statearr_18688_18736[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_18688_18736[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (20))){
var inst_18665 = cljs.core.PersistentVector.EMPTY;
var state_18686__$1 = state_18686;
var statearr_18689_18737 = state_18686__$1;
(statearr_18689_18737[(2)] = inst_18665);

(statearr_18689_18737[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (1))){
var state_18686__$1 = state_18686;
var statearr_18690_18738 = state_18686__$1;
(statearr_18690_18738[(2)] = null);

(statearr_18690_18738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (24))){
var state_18686__$1 = state_18686;
var statearr_18691_18739 = state_18686__$1;
(statearr_18691_18739[(2)] = null);

(statearr_18691_18739[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (4))){
var inst_18626 = (state_18686[(2)]);
var inst_18627 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18628 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_18626);
var inst_18629 = cljs.core.async.close_BANG_(result_ch);
var state_18686__$1 = (function (){var statearr_18692 = state_18686;
(statearr_18692[(7)] = inst_18628);

(statearr_18692[(8)] = inst_18627);

return statearr_18692;
})();
var statearr_18693_18740 = state_18686__$1;
(statearr_18693_18740[(2)] = inst_18629);

(statearr_18693_18740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (15))){
var inst_18651 = (state_18686[(2)]);
var state_18686__$1 = state_18686;
var statearr_18694_18741 = state_18686__$1;
(statearr_18694_18741[(2)] = inst_18651);

(statearr_18694_18741[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (21))){
var inst_18639 = (state_18686[(9)]);
var inst_18655 = (state_18686[(10)]);
var inst_18640 = (state_18686[(11)]);
var inst_18638 = (state_18686[(12)]);
var inst_18668 = (state_18686[(13)]);
var inst_18675 = (state_18686[(2)]);
var inst_18676 = (function (){var base_node = inst_18638;
var first_flake = inst_18639;
var node_t = inst_18640;
var source = inst_18655;
var coll = inst_18668;
var conj_QMARK_ = inst_18675;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__18696 = f.p;
var fexpr__18695 = (function (){var or__5045__auto__ = remove_preds;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__18695.cljs$core$IFn$_invoke$arity$1 ? fexpr__18695.cljs$core$IFn$_invoke$arity$1(G__18696) : fexpr__18695.call(null,G__18696));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_18677 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_18638);
var inst_18678 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_18676,inst_18677,inst_18668);
var inst_18679 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_18678);
var inst_18680 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18638,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18679);
var inst_18681 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_18680);
var _ = (function (){var statearr_18697 = state_18686;
(statearr_18697[(4)] = cljs.core.rest((state_18686[(4)])));

return statearr_18697;
})();
var state_18686__$1 = state_18686;
var statearr_18698_18742 = state_18686__$1;
(statearr_18698_18742[(2)] = inst_18681);

(statearr_18698_18742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (13))){
var state_18686__$1 = state_18686;
var statearr_18699_18743 = state_18686__$1;
(statearr_18699_18743[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_18699_18743[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (22))){
var inst_18639 = (state_18686[(9)]);
var inst_18655 = (state_18686[(10)]);
var inst_18640 = (state_18686[(11)]);
var inst_18638 = (state_18686[(12)]);
var inst_18668 = (state_18686[(13)]);
var inst_18669 = (function (){var base_node = inst_18638;
var first_flake = inst_18639;
var node_t = inst_18640;
var source = inst_18655;
var coll = inst_18668;
return (function (f){
return f.op === true;
});
})();
var state_18686__$1 = state_18686;
var statearr_18700_18744 = state_18686__$1;
(statearr_18700_18744[(2)] = inst_18669);

(statearr_18700_18744[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (6))){
var inst_18640 = (state_18686[(11)]);
var inst_18638 = (state_18686[(12)]);
var inst_18637 = (state_18686[(2)]);
var inst_18638__$1 = fluree.db.util.async.throw_err(inst_18637);
var inst_18639 = fluree.db.dbproto._first_flake(inst_18638__$1);
var inst_18640__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_18638__$1);
var inst_18641 = (inst_18640__$1 > t);
var state_18686__$1 = (function (){var statearr_18701 = state_18686;
(statearr_18701[(9)] = inst_18639);

(statearr_18701[(11)] = inst_18640__$1);

(statearr_18701[(12)] = inst_18638__$1);

return statearr_18701;
})();
if(cljs.core.truth_(inst_18641)){
var statearr_18702_18745 = state_18686__$1;
(statearr_18702_18745[(1)] = (7));

} else {
var statearr_18703_18746 = state_18686__$1;
(statearr_18703_18746[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (17))){
var inst_18639 = (state_18686[(9)]);
var inst_18656 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_18639,rhs,leftmost_QMARK_,t);
var state_18686__$1 = state_18686;
var statearr_18704_18747 = state_18686__$1;
(statearr_18704_18747[(2)] = inst_18656);

(statearr_18704_18747[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (3))){
var inst_18684 = (state_18686[(2)]);
var state_18686__$1 = state_18686;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18686__$1,inst_18684);
} else {
if((state_val_18687 === (12))){
var inst_18653 = (state_18686[(2)]);
var state_18686__$1 = state_18686;
var statearr_18705_18748 = state_18686__$1;
(statearr_18705_18748[(2)] = inst_18653);

(statearr_18705_18748[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (2))){
var _ = (function (){var statearr_18706 = state_18686;
(statearr_18706[(4)] = cljs.core.cons((5),(state_18686[(4)])));

return statearr_18706;
})();
var inst_18635 = fluree.db.dbproto._resolve(node);
var state_18686__$1 = state_18686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18686__$1,(6),inst_18635);
} else {
if((state_val_18687 === (23))){
var inst_18639 = (state_18686[(9)]);
var inst_18655 = (state_18686[(10)]);
var inst_18640 = (state_18686[(11)]);
var inst_18638 = (state_18686[(12)]);
var inst_18668 = (state_18686[(13)]);
var inst_18671 = (function (){var base_node = inst_18638;
var first_flake = inst_18639;
var node_t = inst_18640;
var source = inst_18655;
var coll = inst_18668;
return (function (f){
return f.op === false;
});
})();
var state_18686__$1 = state_18686;
var statearr_18707_18749 = state_18686__$1;
(statearr_18707_18749[(2)] = inst_18671);

(statearr_18707_18749[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (19))){
var inst_18658 = (state_18686[(14)]);
var inst_18661 = (state_18686[(2)]);
var inst_18662 = fluree.db.util.async.throw_err(inst_18661);
var inst_18663 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_18658,inst_18662);
var state_18686__$1 = state_18686;
var statearr_18708_18750 = state_18686__$1;
(statearr_18708_18750[(2)] = inst_18663);

(statearr_18708_18750[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (11))){
var inst_18640 = (state_18686[(11)]);
var inst_18647 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18640,t);
var state_18686__$1 = state_18686;
if(inst_18647){
var statearr_18710_18751 = state_18686__$1;
(statearr_18710_18751[(1)] = (13));

} else {
var statearr_18711_18752 = state_18686__$1;
(statearr_18711_18752[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (9))){
var inst_18655 = (state_18686[(10)]);
var inst_18655__$1 = (state_18686[(2)]);
var state_18686__$1 = (function (){var statearr_18712 = state_18686;
(statearr_18712[(10)] = inst_18655__$1);

return statearr_18712;
})();
var G__18713_18753 = inst_18655__$1;
var G__18713_18754__$1 = (((G__18713_18753 instanceof cljs.core.Keyword))?G__18713_18753.fqn:null);
switch (G__18713_18754__$1) {
case "novelty":
var statearr_18714_18756 = state_18686__$1;
(statearr_18714_18756[(1)] = (17));


break;
case "history":
var statearr_18715_18757 = state_18686__$1;
(statearr_18715_18757[(1)] = (18));


break;
case "none":
var statearr_18716_18758 = state_18686__$1;
(statearr_18716_18758[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18713_18754__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (5))){
var _ = (function (){var statearr_18717 = state_18686;
(statearr_18717[(4)] = cljs.core.rest((state_18686[(4)])));

return statearr_18717;
})();
var state_18686__$1 = state_18686;
var ex18709 = (state_18686__$1[(2)]);
var statearr_18718_18759 = state_18686__$1;
(statearr_18718_18759[(5)] = ex18709);


var statearr_18719_18760 = state_18686__$1;
(statearr_18719_18760[(1)] = (4));

(statearr_18719_18760[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (14))){
var state_18686__$1 = state_18686;
var statearr_18720_18761 = state_18686__$1;
(statearr_18720_18761[(2)] = null);

(statearr_18720_18761[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (16))){
var inst_18655 = (state_18686[(10)]);
var inst_18668 = (state_18686[(2)]);
var state_18686__$1 = (function (){var statearr_18721 = state_18686;
(statearr_18721[(13)] = inst_18668);

return statearr_18721;
})();
var G__18722_18762 = inst_18655;
var G__18722_18763__$1 = (((G__18722_18762 instanceof cljs.core.Keyword))?G__18722_18762.fqn:null);
switch (G__18722_18763__$1) {
case "novelty":
var statearr_18723_18765 = state_18686__$1;
(statearr_18723_18765[(1)] = (22));


break;
case "history":
var statearr_18724_18766 = state_18686__$1;
(statearr_18724_18766[(1)] = (23));


break;
case "none":
var statearr_18725_18767 = state_18686__$1;
(statearr_18725_18767[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18722_18763__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (10))){
var state_18686__$1 = state_18686;
var statearr_18726_18768 = state_18686__$1;
(statearr_18726_18768[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_18726_18768[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18687 === (18))){
var inst_18639 = (state_18686[(9)]);
var inst_18655 = (state_18686[(10)]);
var inst_18640 = (state_18686[(11)]);
var inst_18638 = (state_18686[(12)]);
var inst_18658 = (function (){var base_node = inst_18638;
var first_flake = inst_18639;
var node_t = inst_18640;
var source = inst_18655;
return (function (p1__18625_SHARP_){
return (p1__18625_SHARP_.t <= t);
});
})();
var inst_18659 = fluree.db.dbproto._resolve_history(node);
var state_18686__$1 = (function (){var statearr_18727 = state_18686;
(statearr_18727[(14)] = inst_18658);

return statearr_18727;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18686__$1,(19),inst_18659);
} else {
if((state_val_18687 === (8))){
var inst_18640 = (state_18686[(11)]);
var inst_18644 = (inst_18640 < t);
var state_18686__$1 = state_18686;
if(cljs.core.truth_(inst_18644)){
var statearr_18728_18769 = state_18686__$1;
(statearr_18728_18769[(1)] = (10));

} else {
var statearr_18729_18770 = state_18686__$1;
(statearr_18729_18770[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____0 = (function (){
var statearr_18730 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18730[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__);

(statearr_18730[(1)] = (1));

return statearr_18730;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____1 = (function (state_18686){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18686);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18731){var ex__2730__auto__ = e18731;
var statearr_18732_18771 = state_18686;
(statearr_18732_18771[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18686[(4)]))){
var statearr_18733_18772 = state_18686;
(statearr_18733_18772[(1)] = cljs.core.first((state_18686[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18773 = state_18686;
state_18686 = G__18773;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__ = function(state_18686){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____1.call(this,state_18686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2727__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18734 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18734[(6)] = c__2749__auto___18735);

return statearr_18734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18833){
var state_val_18834 = (state_18833[(1)]);
if((state_val_18834 === (7))){
var inst_18784 = (state_18833[(7)]);
var inst_18788 = (inst_18784 <= from_t);
var state_18833__$1 = state_18833;
var statearr_18835_18875 = state_18833__$1;
(statearr_18835_18875[(2)] = inst_18788);

(statearr_18835_18875[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (20))){
var inst_18818 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_18819 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18818)].join('');
var inst_18820 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18821 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_18822 = cljs.core.PersistentHashMap.fromArrays(inst_18820,inst_18821);
var inst_18823 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18819,inst_18822);
var inst_18824 = (function(){throw inst_18823})();
var state_18833__$1 = state_18833;
var statearr_18836_18876 = state_18833__$1;
(statearr_18836_18876[(2)] = inst_18824);

(statearr_18836_18876[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (1))){
var state_18833__$1 = state_18833;
var statearr_18837_18877 = state_18833__$1;
(statearr_18837_18877[(2)] = null);

(statearr_18837_18877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (4))){
var inst_18776 = (state_18833[(2)]);
var inst_18777 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_18776], 0));
var inst_18778 = (function(){throw inst_18776})();
var state_18833__$1 = (function (){var statearr_18838 = state_18833;
(statearr_18838[(8)] = inst_18777);

return statearr_18838;
})();
var statearr_18839_18878 = state_18833__$1;
(statearr_18839_18878[(2)] = inst_18778);

(statearr_18839_18878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (15))){
var inst_18803 = (state_18833[(2)]);
var state_18833__$1 = (function (){var statearr_18840 = state_18833;
(statearr_18840[(9)] = inst_18803);

return statearr_18840;
})();
if(cljs.core.truth_(from_t)){
var statearr_18841_18879 = state_18833__$1;
(statearr_18841_18879[(1)] = (16));

} else {
var statearr_18842_18880 = state_18833__$1;
(statearr_18842_18880[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (21))){
var inst_18813 = (state_18833[(10)]);
var inst_18814 = (state_18833[(11)]);
var inst_18812 = (state_18833[(12)]);
var inst_18826 = (state_18833[(2)]);
var inst_18827 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_18813,inst_18814,leftmost_QMARK_,to_t);
var inst_18828 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18827,inst_18812);
var _ = (function (){var statearr_18843 = state_18833;
(statearr_18843[(4)] = cljs.core.rest((state_18833[(4)])));

return statearr_18843;
})();
var state_18833__$1 = (function (){var statearr_18844 = state_18833;
(statearr_18844[(13)] = inst_18826);

return statearr_18844;
})();
var statearr_18845_18881 = state_18833__$1;
(statearr_18845_18881[(2)] = inst_18828);

(statearr_18845_18881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (13))){
var inst_18796 = (state_18833[(14)]);
var inst_18784 = (state_18833[(7)]);
var inst_18799 = (function (){var node_t = inst_18784;
var G__18792 = inst_18796;
return (function (p1__18774_SHARP_){
return (p1__18774_SHARP_.t < to_t);
});
})();
var inst_18800 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_18799,inst_18796);
var state_18833__$1 = state_18833;
var statearr_18846_18882 = state_18833__$1;
(statearr_18846_18882[(2)] = inst_18800);

(statearr_18846_18882[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (6))){
var inst_18785 = (state_18833[(15)]);
var state_18833__$1 = state_18833;
var statearr_18847_18883 = state_18833__$1;
(statearr_18847_18883[(2)] = inst_18785);

(statearr_18847_18883[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (17))){
var inst_18803 = (state_18833[(9)]);
var state_18833__$1 = state_18833;
var statearr_18848_18884 = state_18833__$1;
(statearr_18848_18884[(2)] = inst_18803);

(statearr_18848_18884[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (3))){
var inst_18831 = (state_18833[(2)]);
var state_18833__$1 = state_18833;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18833__$1,inst_18831);
} else {
if((state_val_18834 === (12))){
var inst_18784 = (state_18833[(7)]);
var inst_18795 = (state_18833[(2)]);
var inst_18796 = fluree.db.util.async.throw_err(inst_18795);
var inst_18797 = (to_t > inst_18784);
var state_18833__$1 = (function (){var statearr_18849 = state_18833;
(statearr_18849[(14)] = inst_18796);

return statearr_18849;
})();
if(cljs.core.truth_(inst_18797)){
var statearr_18850_18885 = state_18833__$1;
(statearr_18850_18885[(1)] = (13));

} else {
var statearr_18851_18886 = state_18833__$1;
(statearr_18851_18886[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (2))){
var inst_18785 = (state_18833[(15)]);
var _ = (function (){var statearr_18852 = state_18833;
(statearr_18852[(4)] = cljs.core.cons((5),(state_18833[(4)])));

return statearr_18852;
})();
var inst_18784 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_18785__$1 = (from_t == null);
var state_18833__$1 = (function (){var statearr_18853 = state_18833;
(statearr_18853[(15)] = inst_18785__$1);

(statearr_18853[(7)] = inst_18784);

return statearr_18853;
})();
if(cljs.core.truth_(inst_18785__$1)){
var statearr_18854_18887 = state_18833__$1;
(statearr_18854_18887[(1)] = (6));

} else {
var statearr_18855_18888 = state_18833__$1;
(statearr_18855_18888[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (19))){
var state_18833__$1 = state_18833;
var statearr_18856_18889 = state_18833__$1;
(statearr_18856_18889[(2)] = null);

(statearr_18856_18889[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (11))){
var inst_18812 = (state_18833[(2)]);
var inst_18813 = fluree.db.dbproto._first_flake(node);
var inst_18814 = fluree.db.dbproto._rhs(node);
var inst_18815 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_18833__$1 = (function (){var statearr_18858 = state_18833;
(statearr_18858[(10)] = inst_18813);

(statearr_18858[(11)] = inst_18814);

(statearr_18858[(12)] = inst_18812);

return statearr_18858;
})();
if(cljs.core.truth_(inst_18815)){
var statearr_18859_18890 = state_18833__$1;
(statearr_18859_18890[(1)] = (19));

} else {
var statearr_18860_18891 = state_18833__$1;
(statearr_18860_18891[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (9))){
var inst_18793 = fluree.db.dbproto._resolve_history(node);
var state_18833__$1 = state_18833;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18833__$1,(12),inst_18793);
} else {
if((state_val_18834 === (5))){
var _ = (function (){var statearr_18861 = state_18833;
(statearr_18861[(4)] = cljs.core.rest((state_18833[(4)])));

return statearr_18861;
})();
var state_18833__$1 = state_18833;
var ex18857 = (state_18833__$1[(2)]);
var statearr_18862_18892 = state_18833__$1;
(statearr_18862_18892[(5)] = ex18857);


var statearr_18863_18893 = state_18833__$1;
(statearr_18863_18893[(1)] = (4));

(statearr_18863_18893[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (14))){
var inst_18796 = (state_18833[(14)]);
var state_18833__$1 = state_18833;
var statearr_18864_18894 = state_18833__$1;
(statearr_18864_18894[(2)] = inst_18796);

(statearr_18864_18894[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (16))){
var inst_18803 = (state_18833[(9)]);
var inst_18784 = (state_18833[(7)]);
var inst_18805 = (function (){var node_t = inst_18784;
var G__18792 = inst_18803;
return (function (p1__18775_SHARP_){
return (p1__18775_SHARP_.t <= from_t);
});
})();
var inst_18806 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_18805,inst_18803);
var state_18833__$1 = state_18833;
var statearr_18865_18895 = state_18833__$1;
(statearr_18865_18895[(2)] = inst_18806);

(statearr_18865_18895[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (10))){
var state_18833__$1 = state_18833;
var statearr_18866_18896 = state_18833__$1;
(statearr_18866_18896[(2)] = null);

(statearr_18866_18896[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (18))){
var inst_18809 = (state_18833[(2)]);
var state_18833__$1 = state_18833;
var statearr_18867_18897 = state_18833__$1;
(statearr_18867_18897[(2)] = inst_18809);

(statearr_18867_18897[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18834 === (8))){
var inst_18790 = (state_18833[(2)]);
var state_18833__$1 = state_18833;
if(cljs.core.truth_(inst_18790)){
var statearr_18868_18898 = state_18833__$1;
(statearr_18868_18898[(1)] = (9));

} else {
var statearr_18869_18899 = state_18833__$1;
(statearr_18869_18899[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____0 = (function (){
var statearr_18870 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18870[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__);

(statearr_18870[(1)] = (1));

return statearr_18870;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____1 = (function (state_18833){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18833);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18871){var ex__2730__auto__ = e18871;
var statearr_18872_18900 = state_18833;
(statearr_18872_18900[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18833[(4)]))){
var statearr_18873_18901 = state_18833;
(statearr_18873_18901[(1)] = cljs.core.first((state_18833[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18902 = state_18833;
state_18833 = G__18902;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__ = function(state_18833){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____1.call(this,state_18833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18874 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18874[(6)] = c__2749__auto__);

return statearr_18874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__5045__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__18903_18913 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18904_18914 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18903_18913,G__18904_18914) : object_cache.call(null,G__18903_18913,G__18904_18914));

var G__18905 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18906 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18907 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18908 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18907,G__18908) : object_cache.call(null,G__18907,G__18908));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18905,G__18906) : object_cache.call(null,G__18905,G__18906));
} else {
var G__18909 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18910 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18911 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18912 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18911,G__18912) : object_cache.call(null,G__18911,G__18912));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18909,G__18910) : object_cache.call(null,G__18909,G__18910));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18935){
var state_val_18936 = (state_18935[(1)]);
if((state_val_18936 === (7))){
var inst_18924 = (state_18935[(7)]);
var inst_18926 = fluree.db.storage.core.serde(conn);
var inst_18927 = fluree.db.serde.protocol._deserialize_branch(inst_18926,inst_18924);
var state_18935__$1 = state_18935;
var statearr_18937_18956 = state_18935__$1;
(statearr_18937_18956[(2)] = inst_18927);

(statearr_18937_18956[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (1))){
var state_18935__$1 = state_18935;
var statearr_18938_18957 = state_18935__$1;
(statearr_18938_18957[(2)] = null);

(statearr_18938_18957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (4))){
var inst_18915 = (state_18935[(2)]);
var state_18935__$1 = state_18935;
var statearr_18939_18958 = state_18935__$1;
(statearr_18939_18958[(2)] = inst_18915);

(statearr_18939_18958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (6))){
var inst_18924 = (state_18935[(7)]);
var inst_18923 = (state_18935[(2)]);
var inst_18924__$1 = fluree.db.util.async.throw_err(inst_18923);
var state_18935__$1 = (function (){var statearr_18940 = state_18935;
(statearr_18940[(7)] = inst_18924__$1);

return statearr_18940;
})();
if(cljs.core.truth_(inst_18924__$1)){
var statearr_18941_18959 = state_18935__$1;
(statearr_18941_18959[(1)] = (7));

} else {
var statearr_18942_18960 = state_18935__$1;
(statearr_18942_18960[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (3))){
var inst_18933 = (state_18935[(2)]);
var state_18935__$1 = state_18935;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18935__$1,inst_18933);
} else {
if((state_val_18936 === (2))){
var _ = (function (){var statearr_18944 = state_18935;
(statearr_18944[(4)] = cljs.core.cons((5),(state_18935[(4)])));

return statearr_18944;
})();
var inst_18921 = fluree.db.storage.core.storage_read(conn,key);
var state_18935__$1 = state_18935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18935__$1,(6),inst_18921);
} else {
if((state_val_18936 === (9))){
var inst_18930 = (state_18935[(2)]);
var _ = (function (){var statearr_18945 = state_18935;
(statearr_18945[(4)] = cljs.core.rest((state_18935[(4)])));

return statearr_18945;
})();
var state_18935__$1 = state_18935;
var statearr_18946_18961 = state_18935__$1;
(statearr_18946_18961[(2)] = inst_18930);

(statearr_18946_18961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (5))){
var _ = (function (){var statearr_18947 = state_18935;
(statearr_18947[(4)] = cljs.core.rest((state_18935[(4)])));

return statearr_18947;
})();
var state_18935__$1 = state_18935;
var ex18943 = (state_18935__$1[(2)]);
var statearr_18948_18962 = state_18935__$1;
(statearr_18948_18962[(5)] = ex18943);


if((ex18943 instanceof Error)){
var statearr_18949_18963 = state_18935__$1;
(statearr_18949_18963[(1)] = (4));

(statearr_18949_18963[(5)] = null);

} else {
throw ex18943;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (8))){
var state_18935__$1 = state_18935;
var statearr_18950_18964 = state_18935__$1;
(statearr_18950_18964[(2)] = null);

(statearr_18950_18964[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0 = (function (){
var statearr_18951 = [null,null,null,null,null,null,null,null];
(statearr_18951[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2727__auto__);

(statearr_18951[(1)] = (1));

return statearr_18951;
});
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1 = (function (state_18935){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18935);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18952){var ex__2730__auto__ = e18952;
var statearr_18953_18965 = state_18935;
(statearr_18953_18965[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18935[(4)]))){
var statearr_18954_18966 = state_18935;
(statearr_18954_18966[(1)] = cljs.core.first((state_18935[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18967 = state_18935;
state_18935 = G__18967;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = function(state_18935){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1.call(this,state_18935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18955 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18955[(6)] = c__2749__auto__);

return statearr_18955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___19046 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19018){
var state_val_19019 = (state_19018[(1)]);
if((state_val_19019 === (7))){
var inst_18985 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18986 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18987 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18988 = cljs.core.PersistentHashMap.fromArrays(inst_18986,inst_18987);
var inst_18989 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18985,inst_18988);
var inst_18990 = (function(){throw inst_18989})();
var state_19018__$1 = state_19018;
var statearr_19020_19047 = state_19018__$1;
(statearr_19020_19047[(2)] = inst_18990);

(statearr_19020_19047[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (1))){
var state_19018__$1 = state_19018;
var statearr_19021_19048 = state_19018__$1;
(statearr_19021_19048[(2)] = null);

(statearr_19021_19048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (4))){
var inst_18968 = (state_19018[(2)]);
var inst_18969 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18970 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18968);
var inst_18971 = cljs.core.async.close_BANG_(return_ch);
var state_19018__$1 = (function (){var statearr_19022 = state_19018;
(statearr_19022[(7)] = inst_18969);

(statearr_19022[(8)] = inst_18970);

return statearr_19022;
})();
var statearr_19023_19049 = state_19018__$1;
(statearr_19023_19049[(2)] = inst_18971);

(statearr_19023_19049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (6))){
var inst_18982 = (state_19018[(9)]);
var inst_18981 = (state_19018[(2)]);
var inst_18982__$1 = fluree.db.util.async.throw_err(inst_18981);
var inst_18983 = (inst_18982__$1 == null);
var state_19018__$1 = (function (){var statearr_19024 = state_19018;
(statearr_19024[(9)] = inst_18982__$1);

return statearr_19024;
})();
if(cljs.core.truth_(inst_18983)){
var statearr_19025_19050 = state_19018__$1;
(statearr_19025_19050[(1)] = (7));

} else {
var statearr_19026_19051 = state_19018__$1;
(statearr_19026_19051[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (3))){
var inst_19016 = (state_19018[(2)]);
var state_19018__$1 = state_19018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19018__$1,inst_19016);
} else {
if((state_val_19019 === (12))){
var inst_18982 = (state_19018[(9)]);
var inst_18999 = (state_19018[(2)]);
var inst_19000 = cljs.core.__destructure_map(inst_18982);
var inst_19001 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19000,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_19002 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19000,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_19003 = config;
var inst_19004 = cljs.core.__destructure_map(inst_19003);
var inst_19005 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19004,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_19007 = (function (){var data = inst_18982;
var _ = inst_18999;
var map__18977 = inst_19000;
var children = inst_19001;
var rhs = inst_19002;
var map__18978 = inst_19004;
var comparator = inst_19005;
return (function (idx,p__19006){
var map__19027 = p__19006;
var map__19027__$1 = cljs.core.__destructure_map(map__19027);
var child = map__19027__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19027__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19027__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19027__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19027__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19027__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (idx === (0));
} else {
return and__5043__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_19008 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_19007,inst_19001);
var inst_19009 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_19008);
var inst_19010 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_19009,inst_19008);
var inst_19011 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_19005,inst_19010);
var inst_19012 = fluree.db.index.__GT_IndexNode(block,t,inst_19002,inst_19011,config,leftmost_QMARK_);
var inst_19013 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_19012);
var _ = (function (){var statearr_19028 = state_19018;
(statearr_19028[(4)] = cljs.core.rest((state_19018[(4)])));

return statearr_19028;
})();
var state_19018__$1 = state_19018;
var statearr_19029_19052 = state_19018__$1;
(statearr_19029_19052[(2)] = inst_19013);

(statearr_19029_19052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (2))){
var _ = (function (){var statearr_19030 = state_19018;
(statearr_19030[(4)] = cljs.core.cons((5),(state_19018[(4)])));

return statearr_19030;
})();
var inst_18979 = fluree.db.storage.core.read_branch(conn,key);
var state_19018__$1 = state_19018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19018__$1,(6),inst_18979);
} else {
if((state_val_19019 === (11))){
var state_19018__$1 = state_19018;
var statearr_19032_19053 = state_19018__$1;
(statearr_19032_19053[(2)] = null);

(statearr_19032_19053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (9))){
var inst_18982 = (state_19018[(9)]);
var inst_18993 = (state_19018[(2)]);
var inst_18994 = fluree.db.util.core.exception_QMARK_(inst_18982);
var state_19018__$1 = (function (){var statearr_19033 = state_19018;
(statearr_19033[(10)] = inst_18993);

return statearr_19033;
})();
if(inst_18994){
var statearr_19034_19054 = state_19018__$1;
(statearr_19034_19054[(1)] = (10));

} else {
var statearr_19035_19055 = state_19018__$1;
(statearr_19035_19055[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (5))){
var _ = (function (){var statearr_19036 = state_19018;
(statearr_19036[(4)] = cljs.core.rest((state_19018[(4)])));

return statearr_19036;
})();
var state_19018__$1 = state_19018;
var ex19031 = (state_19018__$1[(2)]);
var statearr_19037_19056 = state_19018__$1;
(statearr_19037_19056[(5)] = ex19031);


var statearr_19038_19057 = state_19018__$1;
(statearr_19038_19057[(1)] = (4));

(statearr_19038_19057[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (10))){
var inst_18982 = (state_19018[(9)]);
var inst_18996 = (function(){throw inst_18982})();
var state_19018__$1 = state_19018;
var statearr_19039_19058 = state_19018__$1;
(statearr_19039_19058[(2)] = inst_18996);

(statearr_19039_19058[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19019 === (8))){
var state_19018__$1 = state_19018;
var statearr_19040_19059 = state_19018__$1;
(statearr_19040_19059[(2)] = null);

(statearr_19040_19059[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____0 = (function (){
var statearr_19041 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19041[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__);

(statearr_19041[(1)] = (1));

return statearr_19041;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____1 = (function (state_19018){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19018);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19042){var ex__2730__auto__ = e19042;
var statearr_19043_19060 = state_19018;
(statearr_19043_19060[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19018[(4)]))){
var statearr_19044_19061 = state_19018;
(statearr_19044_19061[(1)] = cljs.core.first((state_19018[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19062 = state_19018;
state_19018 = G__19062;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__ = function(state_19018){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____1.call(this,state_19018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19045 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19045[(6)] = c__2749__auto___19046);

return statearr_19045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19083){
var state_val_19084 = (state_19083[(1)]);
if((state_val_19084 === (7))){
var state_19083__$1 = state_19083;
var statearr_19085_19105 = state_19083__$1;
(statearr_19085_19105[(2)] = null);

(statearr_19085_19105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19084 === (1))){
var state_19083__$1 = state_19083;
var statearr_19086_19106 = state_19083__$1;
(statearr_19086_19106[(2)] = null);

(statearr_19086_19106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19084 === (4))){
var inst_19063 = (state_19083[(2)]);
var state_19083__$1 = state_19083;
var statearr_19087_19107 = state_19083__$1;
(statearr_19087_19107[(2)] = inst_19063);

(statearr_19087_19107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19084 === (6))){
var inst_19069 = (state_19083[(7)]);
var inst_19071 = fluree.db.storage.core.serde(conn);
var state_19083__$1 = (function (){var statearr_19088 = state_19083;
(statearr_19088[(8)] = inst_19071);

return statearr_19088;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19083__$1,(9),inst_19069);
} else {
if((state_val_19084 === (3))){
var inst_19081 = (state_19083[(2)]);
var state_19083__$1 = state_19083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19083__$1,inst_19081);
} else {
if((state_val_19084 === (2))){
var inst_19069 = (state_19083[(7)]);
var _ = (function (){var statearr_19090 = state_19083;
(statearr_19090[(4)] = cljs.core.cons((5),(state_19083[(4)])));

return statearr_19090;
})();
var inst_19069__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_19083__$1 = (function (){var statearr_19091 = state_19083;
(statearr_19091[(7)] = inst_19069__$1);

return statearr_19091;
})();
if(cljs.core.truth_(inst_19069__$1)){
var statearr_19092_19108 = state_19083__$1;
(statearr_19092_19108[(1)] = (6));

} else {
var statearr_19093_19109 = state_19083__$1;
(statearr_19093_19109[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19084 === (9))){
var inst_19071 = (state_19083[(8)]);
var inst_19073 = (state_19083[(2)]);
var inst_19074 = fluree.db.util.async.throw_err(inst_19073);
var inst_19075 = fluree.db.serde.protocol._deserialize_leaf(inst_19071,inst_19074);
var state_19083__$1 = state_19083;
var statearr_19094_19110 = state_19083__$1;
(statearr_19094_19110[(2)] = inst_19075);

(statearr_19094_19110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19084 === (5))){
var _ = (function (){var statearr_19095 = state_19083;
(statearr_19095[(4)] = cljs.core.rest((state_19083[(4)])));

return statearr_19095;
})();
var state_19083__$1 = state_19083;
var ex19089 = (state_19083__$1[(2)]);
var statearr_19096_19111 = state_19083__$1;
(statearr_19096_19111[(5)] = ex19089);


if((ex19089 instanceof Error)){
var statearr_19097_19112 = state_19083__$1;
(statearr_19097_19112[(1)] = (4));

(statearr_19097_19112[(5)] = null);

} else {
throw ex19089;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19084 === (8))){
var inst_19078 = (state_19083[(2)]);
var _ = (function (){var statearr_19098 = state_19083;
(statearr_19098[(4)] = cljs.core.rest((state_19083[(4)])));

return statearr_19098;
})();
var state_19083__$1 = state_19083;
var statearr_19099_19113 = state_19083__$1;
(statearr_19099_19113[(2)] = inst_19078);

(statearr_19099_19113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_19100 = [null,null,null,null,null,null,null,null,null];
(statearr_19100[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__);

(statearr_19100[(1)] = (1));

return statearr_19100;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1 = (function (state_19083){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19083);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19101){var ex__2730__auto__ = e19101;
var statearr_19102_19114 = state_19083;
(statearr_19102_19114[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19083[(4)]))){
var statearr_19103_19115 = state_19083;
(statearr_19103_19115[(1)] = cljs.core.first((state_19083[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19116 = state_19083;
state_19083 = G__19116;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = function(state_19083){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1.call(this,state_19083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19104 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19104[(6)] = c__2749__auto__);

return statearr_19104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___19189 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19161){
var state_val_19162 = (state_19161[(1)]);
if((state_val_19162 === (7))){
var inst_19133 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_19134 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19135 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_19136 = cljs.core.PersistentHashMap.fromArrays(inst_19134,inst_19135);
var inst_19137 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19133,inst_19136);
var inst_19138 = (function(){throw inst_19137})();
var state_19161__$1 = state_19161;
var statearr_19163_19190 = state_19161__$1;
(statearr_19163_19190[(2)] = inst_19138);

(statearr_19163_19190[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19162 === (1))){
var state_19161__$1 = state_19161;
var statearr_19164_19191 = state_19161__$1;
(statearr_19164_19191[(2)] = null);

(statearr_19164_19191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19162 === (4))){
var inst_19117 = (state_19161[(2)]);
var inst_19118 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_19119 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_19117);
var inst_19120 = cljs.core.async.close_BANG_(return_ch);
var state_19161__$1 = (function (){var statearr_19165 = state_19161;
(statearr_19165[(7)] = inst_19118);

(statearr_19165[(8)] = inst_19119);

return statearr_19165;
})();
var statearr_19166_19192 = state_19161__$1;
(statearr_19166_19192[(2)] = inst_19120);

(statearr_19166_19192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19162 === (6))){
var inst_19130 = (state_19161[(9)]);
var inst_19130__$1 = (state_19161[(2)]);
var inst_19131 = (inst_19130__$1 == null);
var state_19161__$1 = (function (){var statearr_19167 = state_19161;
(statearr_19167[(9)] = inst_19130__$1);

return statearr_19167;
})();
if(cljs.core.truth_(inst_19131)){
var statearr_19168_19193 = state_19161__$1;
(statearr_19168_19193[(1)] = (7));

} else {
var statearr_19169_19194 = state_19161__$1;
(statearr_19169_19194[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19162 === (3))){
var inst_19159 = (state_19161[(2)]);
var state_19161__$1 = state_19161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19161__$1,inst_19159);
} else {
if((state_val_19162 === (12))){
var inst_19130 = (state_19161[(9)]);
var inst_19147 = (state_19161[(2)]);
var inst_19148 = cljs.core.__destructure_map(inst_19130);
var inst_19149 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19148,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_19150 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19148,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_19151 = config;
var inst_19152 = cljs.core.__destructure_map(inst_19151);
var inst_19153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19152,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_19154 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_19153,inst_19149);
var inst_19155 = fluree.db.index.data_node(block,t,inst_19154,rhs,config);
var inst_19156 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_19155);
var _ = (function (){var statearr_19170 = state_19161;
(statearr_19170[(4)] = cljs.core.rest((state_19161[(4)])));

return statearr_19170;
})();
var state_19161__$1 = (function (){var statearr_19171 = state_19161;
(statearr_19171[(10)] = inst_19150);

(statearr_19171[(11)] = inst_19147);

return statearr_19171;
})();
var statearr_19172_19195 = state_19161__$1;
(statearr_19172_19195[(2)] = inst_19156);

(statearr_19172_19195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19162 === (2))){
var _ = (function (){var statearr_19173 = state_19161;
(statearr_19173[(4)] = cljs.core.cons((5),(state_19161[(4)])));

return statearr_19173;
})();
var inst_19128 = fluree.db.storage.core.read_leaf(conn,key);
var state_19161__$1 = state_19161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19161__$1,(6),inst_19128);
} else {
if((state_val_19162 === (11))){
var state_19161__$1 = state_19161;
var statearr_19175_19196 = state_19161__$1;
(statearr_19175_19196[(2)] = null);

(statearr_19175_19196[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19162 === (9))){
var inst_19130 = (state_19161[(9)]);
var inst_19141 = (state_19161[(2)]);
var inst_19142 = fluree.db.util.core.exception_QMARK_(inst_19130);
var state_19161__$1 = (function (){var statearr_19176 = state_19161;
(statearr_19176[(12)] = inst_19141);

return statearr_19176;
})();
if(inst_19142){
var statearr_19177_19197 = state_19161__$1;
(statearr_19177_19197[(1)] = (10));

} else {
var statearr_19178_19198 = state_19161__$1;
(statearr_19178_19198[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19162 === (5))){
var _ = (function (){var statearr_19179 = state_19161;
(statearr_19179[(4)] = cljs.core.rest((state_19161[(4)])));

return statearr_19179;
})();
var state_19161__$1 = state_19161;
var ex19174 = (state_19161__$1[(2)]);
var statearr_19180_19199 = state_19161__$1;
(statearr_19180_19199[(5)] = ex19174);


var statearr_19181_19200 = state_19161__$1;
(statearr_19181_19200[(1)] = (4));

(statearr_19181_19200[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19162 === (10))){
var inst_19130 = (state_19161[(9)]);
var inst_19144 = (function(){throw inst_19130})();
var state_19161__$1 = state_19161;
var statearr_19182_19201 = state_19161__$1;
(statearr_19182_19201[(2)] = inst_19144);

(statearr_19182_19201[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19162 === (8))){
var state_19161__$1 = state_19161;
var statearr_19183_19202 = state_19161__$1;
(statearr_19183_19202[(2)] = null);

(statearr_19183_19202[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_19184 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19184[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__);

(statearr_19184[(1)] = (1));

return statearr_19184;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____1 = (function (state_19161){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19161);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19185){var ex__2730__auto__ = e19185;
var statearr_19186_19203 = state_19161;
(statearr_19186_19203[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19161[(4)]))){
var statearr_19187_19204 = state_19161;
(statearr_19187_19204[(1)] = cljs.core.first((state_19161[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19205 = state_19161;
state_19161 = G__19205;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__ = function(state_19161){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____1.call(this,state_19161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19188 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19188[(6)] = c__2749__auto___19189);

return statearr_19188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k19207,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__19211 = k19207;
var G__19211__$1 = (((G__19211 instanceof cljs.core.Keyword))?G__19211.fqn:null);
switch (G__19211__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k19207,else__5346__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__19212){
var vec__19213 = p__19212;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19213,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19213,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19206){
var self__ = this;
var G__19206__$1 = this;
return (new cljs.core.RecordIter((0),G__19206__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__19216 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__19217 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__19218 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__19219 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__19218,G__19219) : object_cache.call(null,G__19218,G__19219));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__19220 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__19221 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__19220,G__19221) : object_cache.call(null,G__19220,G__19221));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__19216,G__19217) : object_cache.call(null,G__19216,G__19217));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__19222 = history_id;
var G__19223 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__19222,G__19223) : object_cache.call(null,G__19222,G__19223));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__19224 = (function (coll__5340__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__19224(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this19208,other19209){
var self__ = this;
var this19208__$1 = this;
return (((!((other19209 == null)))) && ((((this19208__$1.constructor === other19209.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.conn,other19209.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.config,other19209.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.network,other19209.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.dbid,other19209.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.id,other19209.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.leaf,other19209.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.first,other19209.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.rhs,other19209.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.size,other19209.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.block,other19209.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.t,other19209.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.tt_id,other19209.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.leftmost_QMARK_,other19209.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.tempid,other19209.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this19208__$1.__extmap,other19209.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k19207){
var self__ = this;
var this__5350__auto____$1 = this;
var G__19225 = k19207;
var G__19225__$1 = (((G__19225 instanceof cljs.core.Keyword))?G__19225.fqn:null);
switch (G__19225__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k19207);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__19206){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__19226 = cljs.core.keyword_identical_QMARK_;
var expr__19227 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__19229 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__19230 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19229,G__19230) : pred__19226.call(null,G__19229,G__19230));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__19206,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19231 = new cljs.core.Keyword(null,"config","config",994861415);
var G__19232 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19231,G__19232) : pred__19226.call(null,G__19231,G__19232));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__19206,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19233 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__19234 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19233,G__19234) : pred__19226.call(null,G__19233,G__19234));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__19206,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19235 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__19236 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19235,G__19236) : pred__19226.call(null,G__19235,G__19236));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__19206,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19237 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__19238 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19237,G__19238) : pred__19226.call(null,G__19237,G__19238));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__19206,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19239 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__19240 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19239,G__19240) : pred__19226.call(null,G__19239,G__19240));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__19206,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19241 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__19242 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19241,G__19242) : pred__19226.call(null,G__19241,G__19242));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__19206,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19243 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__19244 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19243,G__19244) : pred__19226.call(null,G__19243,G__19244));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__19206,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19245 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__19246 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19245,G__19246) : pred__19226.call(null,G__19245,G__19246));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__19206,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19247 = new cljs.core.Keyword(null,"block","block",664686210);
var G__19248 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19247,G__19248) : pred__19226.call(null,G__19247,G__19248));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__19206,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19249 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__19250 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19249,G__19250) : pred__19226.call(null,G__19249,G__19250));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__19206,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19251 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__19252 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19251,G__19252) : pred__19226.call(null,G__19251,G__19252));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__19206,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19253 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__19254 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19253,G__19254) : pred__19226.call(null,G__19253,G__19254));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__19206,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__19255 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__19256 = expr__19227;
return (pred__19226.cljs$core$IFn$_invoke$arity$2 ? pred__19226.cljs$core$IFn$_invoke$arity$2(G__19255,G__19256) : pred__19226.call(null,G__19255,G__19256));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__19206,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__19206),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__19206){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__19206,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__19210){
var extmap__5385__auto__ = (function (){var G__19257 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__19210,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__19210)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__19257);
} else {
return G__19257;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__19210),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__19210),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__19260 = blank_db;
var map__19260__$1 = cljs.core.__destructure_map(map__19260);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19260__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19260__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19260__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__19261 = root_data;
var map__19261__$1 = cljs.core.__destructure_map(map__19261);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19261__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19261__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19261__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19261__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19283){
var state_val_19284 = (state_19283[(1)]);
if((state_val_19284 === (7))){
var state_19283__$1 = state_19283;
var statearr_19285_19305 = state_19283__$1;
(statearr_19285_19305[(2)] = null);

(statearr_19285_19305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (1))){
var state_19283__$1 = state_19283;
var statearr_19286_19306 = state_19283__$1;
(statearr_19286_19306[(2)] = null);

(statearr_19286_19306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (4))){
var inst_19262 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19287_19307 = state_19283__$1;
(statearr_19287_19307[(2)] = inst_19262);

(statearr_19287_19307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (6))){
var inst_19269 = (state_19283[(7)]);
var inst_19271 = fluree.db.storage.core.serde(conn);
var state_19283__$1 = (function (){var statearr_19288 = state_19283;
(statearr_19288[(8)] = inst_19271);

return statearr_19288;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19283__$1,(9),inst_19269);
} else {
if((state_val_19284 === (3))){
var inst_19281 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19283__$1,inst_19281);
} else {
if((state_val_19284 === (2))){
var inst_19269 = (state_19283[(7)]);
var _ = (function (){var statearr_19290 = state_19283;
(statearr_19290[(4)] = cljs.core.cons((5),(state_19283[(4)])));

return statearr_19290;
})();
var inst_19268 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_19269__$1 = fluree.db.storage.core.storage_read(conn,inst_19268);
var state_19283__$1 = (function (){var statearr_19291 = state_19283;
(statearr_19291[(7)] = inst_19269__$1);

return statearr_19291;
})();
if(cljs.core.truth_(inst_19269__$1)){
var statearr_19292_19308 = state_19283__$1;
(statearr_19292_19308[(1)] = (6));

} else {
var statearr_19293_19309 = state_19283__$1;
(statearr_19293_19309[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (9))){
var inst_19271 = (state_19283[(8)]);
var inst_19273 = (state_19283[(2)]);
var inst_19274 = fluree.db.util.async.throw_err(inst_19273);
var inst_19275 = fluree.db.serde.protocol._deserialize_garbage(inst_19271,inst_19274);
var state_19283__$1 = state_19283;
var statearr_19294_19310 = state_19283__$1;
(statearr_19294_19310[(2)] = inst_19275);

(statearr_19294_19310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (5))){
var _ = (function (){var statearr_19295 = state_19283;
(statearr_19295[(4)] = cljs.core.rest((state_19283[(4)])));

return statearr_19295;
})();
var state_19283__$1 = state_19283;
var ex19289 = (state_19283__$1[(2)]);
var statearr_19296_19311 = state_19283__$1;
(statearr_19296_19311[(5)] = ex19289);


if((ex19289 instanceof Error)){
var statearr_19297_19312 = state_19283__$1;
(statearr_19297_19312[(1)] = (4));

(statearr_19297_19312[(5)] = null);

} else {
throw ex19289;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (8))){
var inst_19278 = (state_19283[(2)]);
var _ = (function (){var statearr_19298 = state_19283;
(statearr_19298[(4)] = cljs.core.rest((state_19283[(4)])));

return statearr_19298;
})();
var state_19283__$1 = state_19283;
var statearr_19299_19313 = state_19283__$1;
(statearr_19299_19313[(2)] = inst_19278);

(statearr_19299_19313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_19300 = [null,null,null,null,null,null,null,null,null];
(statearr_19300[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__);

(statearr_19300[(1)] = (1));

return statearr_19300;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1 = (function (state_19283){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19283);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19301){var ex__2730__auto__ = e19301;
var statearr_19302_19314 = state_19283;
(statearr_19302_19314[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19283[(4)]))){
var statearr_19303_19315 = state_19283;
(statearr_19303_19315[(1)] = cljs.core.first((state_19283[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19316 = state_19283;
state_19283 = G__19316;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = function(state_19283){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1.call(this,state_19283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19304 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19304[(6)] = c__2749__auto__);

return statearr_19304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19338){
var state_val_19339 = (state_19338[(1)]);
if((state_val_19339 === (7))){
var inst_19327 = (state_19338[(7)]);
var inst_19329 = fluree.db.storage.core.serde(conn);
var inst_19330 = fluree.db.serde.protocol._deserialize_db_root(inst_19329,inst_19327);
var state_19338__$1 = state_19338;
var statearr_19340_19359 = state_19338__$1;
(statearr_19340_19359[(2)] = inst_19330);

(statearr_19340_19359[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19339 === (1))){
var state_19338__$1 = state_19338;
var statearr_19341_19360 = state_19338__$1;
(statearr_19341_19360[(2)] = null);

(statearr_19341_19360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19339 === (4))){
var inst_19317 = (state_19338[(2)]);
var state_19338__$1 = state_19338;
var statearr_19342_19361 = state_19338__$1;
(statearr_19342_19361[(2)] = inst_19317);

(statearr_19342_19361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19339 === (6))){
var inst_19327 = (state_19338[(7)]);
var inst_19326 = (state_19338[(2)]);
var inst_19327__$1 = fluree.db.util.async.throw_err(inst_19326);
var state_19338__$1 = (function (){var statearr_19343 = state_19338;
(statearr_19343[(7)] = inst_19327__$1);

return statearr_19343;
})();
if(cljs.core.truth_(inst_19327__$1)){
var statearr_19344_19362 = state_19338__$1;
(statearr_19344_19362[(1)] = (7));

} else {
var statearr_19345_19363 = state_19338__$1;
(statearr_19345_19363[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19339 === (3))){
var inst_19336 = (state_19338[(2)]);
var state_19338__$1 = state_19338;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19338__$1,inst_19336);
} else {
if((state_val_19339 === (2))){
var _ = (function (){var statearr_19347 = state_19338;
(statearr_19347[(4)] = cljs.core.cons((5),(state_19338[(4)])));

return statearr_19347;
})();
var inst_19323 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_19324 = fluree.db.storage.core.storage_read(conn,inst_19323);
var state_19338__$1 = state_19338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19338__$1,(6),inst_19324);
} else {
if((state_val_19339 === (9))){
var inst_19333 = (state_19338[(2)]);
var _ = (function (){var statearr_19348 = state_19338;
(statearr_19348[(4)] = cljs.core.rest((state_19338[(4)])));

return statearr_19348;
})();
var state_19338__$1 = state_19338;
var statearr_19349_19364 = state_19338__$1;
(statearr_19349_19364[(2)] = inst_19333);

(statearr_19349_19364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19339 === (5))){
var _ = (function (){var statearr_19350 = state_19338;
(statearr_19350[(4)] = cljs.core.rest((state_19338[(4)])));

return statearr_19350;
})();
var state_19338__$1 = state_19338;
var ex19346 = (state_19338__$1[(2)]);
var statearr_19351_19365 = state_19338__$1;
(statearr_19351_19365[(5)] = ex19346);


if((ex19346 instanceof Error)){
var statearr_19352_19366 = state_19338__$1;
(statearr_19352_19366[(1)] = (4));

(statearr_19352_19366[(5)] = null);

} else {
throw ex19346;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19339 === (8))){
var state_19338__$1 = state_19338;
var statearr_19353_19367 = state_19338__$1;
(statearr_19353_19367[(2)] = null);

(statearr_19353_19367[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0 = (function (){
var statearr_19354 = [null,null,null,null,null,null,null,null];
(statearr_19354[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__);

(statearr_19354[(1)] = (1));

return statearr_19354;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1 = (function (state_19338){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19338);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19355){var ex__2730__auto__ = e19355;
var statearr_19356_19368 = state_19338;
(statearr_19356_19368[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19338[(4)]))){
var statearr_19357_19369 = state_19338;
(statearr_19357_19369[(1)] = cljs.core.first((state_19338[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19370 = state_19338;
state_19338 = G__19370;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = function(state_19338){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1.call(this,state_19338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19358 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19358[(6)] = c__2749__auto__);

return statearr_19358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19406){
var state_val_19407 = (state_19406[(1)]);
if((state_val_19407 === (7))){
var inst_19380 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_19381 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19382 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_19383 = cljs.core.PersistentHashMap.fromArrays(inst_19381,inst_19382);
var inst_19384 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19380,inst_19383);
var inst_19385 = (function(){throw inst_19384})();
var state_19406__$1 = state_19406;
var statearr_19408_19430 = state_19406__$1;
(statearr_19408_19430[(2)] = inst_19385);

(statearr_19408_19430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19407 === (1))){
var state_19406__$1 = state_19406;
var statearr_19409_19431 = state_19406__$1;
(statearr_19409_19431[(2)] = null);

(statearr_19409_19431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19407 === (4))){
var inst_19371 = (state_19406[(2)]);
var state_19406__$1 = state_19406;
var statearr_19410_19432 = state_19406__$1;
(statearr_19410_19432[(2)] = inst_19371);

(statearr_19410_19432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19407 === (6))){
var state_19406__$1 = state_19406;
var statearr_19411_19433 = state_19406__$1;
(statearr_19411_19433[(2)] = null);

(statearr_19411_19433[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19407 === (3))){
var inst_19404 = (state_19406[(2)]);
var state_19406__$1 = state_19406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19406__$1,inst_19404);
} else {
if((state_val_19407 === (2))){
var inst_19377 = (state_19406[(7)]);
var _ = (function (){var statearr_19412 = state_19406;
(statearr_19412[(4)] = cljs.core.cons((5),(state_19406[(4)])));

return statearr_19412;
})();
var inst_19377__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_19406__$1 = (function (){var statearr_19413 = state_19406;
(statearr_19413[(7)] = inst_19377__$1);

return statearr_19413;
})();
if(cljs.core.truth_(inst_19377__$1)){
var statearr_19414_19434 = state_19406__$1;
(statearr_19414_19434[(1)] = (6));

} else {
var statearr_19415_19435 = state_19406__$1;
(statearr_19415_19435[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19407 === (11))){
var inst_19396 = (state_19406[(8)]);
var inst_19399 = (state_19406[(2)]);
var inst_19400 = fluree.db.util.async.throw_err(inst_19399);
var inst_19401 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_19396,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_19400);
var _ = (function (){var statearr_19417 = state_19406;
(statearr_19417[(4)] = cljs.core.rest((state_19406[(4)])));

return statearr_19417;
})();
var state_19406__$1 = state_19406;
var statearr_19418_19436 = state_19406__$1;
(statearr_19418_19436[(2)] = inst_19401);

(statearr_19418_19436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19407 === (9))){
var inst_19391 = (state_19406[(9)]);
var inst_19389 = (state_19406[(2)]);
var inst_19390 = fluree.db.util.async.throw_err(inst_19389);
var inst_19391__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_19390);
var inst_19392 = fluree.db.query.schema.schema_map(inst_19391__$1);
var state_19406__$1 = (function (){var statearr_19419 = state_19406;
(statearr_19419[(9)] = inst_19391__$1);

return statearr_19419;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19406__$1,(10),inst_19392);
} else {
if((state_val_19407 === (5))){
var _ = (function (){var statearr_19420 = state_19406;
(statearr_19420[(4)] = cljs.core.rest((state_19406[(4)])));

return statearr_19420;
})();
var state_19406__$1 = state_19406;
var ex19416 = (state_19406__$1[(2)]);
var statearr_19421_19437 = state_19406__$1;
(statearr_19421_19437[(5)] = ex19416);


if((ex19416 instanceof Error)){
var statearr_19422_19438 = state_19406__$1;
(statearr_19422_19438[(1)] = (4));

(statearr_19422_19438[(5)] = null);

} else {
throw ex19416;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19407 === (10))){
var inst_19391 = (state_19406[(9)]);
var inst_19396 = (state_19406[(8)]);
var inst_19394 = (state_19406[(2)]);
var inst_19395 = fluree.db.util.async.throw_err(inst_19394);
var inst_19396__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_19391,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_19395);
var inst_19397 = fluree.db.query.schema.setting_map(inst_19396__$1);
var state_19406__$1 = (function (){var statearr_19423 = state_19406;
(statearr_19423[(8)] = inst_19396__$1);

return statearr_19423;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19406__$1,(11),inst_19397);
} else {
if((state_val_19407 === (8))){
var inst_19377 = (state_19406[(7)]);
var inst_19387 = (state_19406[(2)]);
var state_19406__$1 = (function (){var statearr_19424 = state_19406;
(statearr_19424[(10)] = inst_19387);

return statearr_19424;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19406__$1,(9),inst_19377);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0 = (function (){
var statearr_19425 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19425[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2727__auto__);

(statearr_19425[(1)] = (1));

return statearr_19425;
});
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1 = (function (state_19406){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19406);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19426){var ex__2730__auto__ = e19426;
var statearr_19427_19439 = state_19406;
(statearr_19427_19439[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19406[(4)]))){
var statearr_19428_19440 = state_19406;
(statearr_19428_19440[(1)] = cljs.core.first((state_19406[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19441 = state_19406;
state_19406 = G__19441;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = function(state_19406){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1.call(this,state_19406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19429 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19429[(6)] = c__2749__auto__);

return statearr_19429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__19443 = arguments.length;
switch (G__19443) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19496){
var state_val_19497 = (state_19496[(1)]);
if((state_val_19497 === (7))){
var inst_19453 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_19454 = (new Error(inst_19453));
var inst_19455 = (function(){throw inst_19454})();
var state_19496__$1 = state_19496;
var statearr_19498_19538 = state_19496__$1;
(statearr_19498_19538[(2)] = inst_19455);

(statearr_19498_19538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (20))){
var inst_19487 = (state_19496[(2)]);
var state_19496__$1 = state_19496;
var statearr_19499_19539 = state_19496__$1;
(statearr_19499_19539[(2)] = inst_19487);

(statearr_19499_19539[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (1))){
var state_19496__$1 = state_19496;
var statearr_19500_19540 = state_19496__$1;
(statearr_19500_19540[(2)] = null);

(statearr_19500_19540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (4))){
var inst_19444 = (state_19496[(2)]);
var state_19496__$1 = state_19496;
var statearr_19501_19541 = state_19496__$1;
(statearr_19501_19541[(2)] = inst_19444);

(statearr_19501_19541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (15))){
var inst_19462 = (state_19496[(7)]);
var state_19496__$1 = state_19496;
var statearr_19502_19542 = state_19496__$1;
(statearr_19502_19542[(2)] = inst_19462);

(statearr_19502_19542[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (21))){
var inst_19466 = (state_19496[(8)]);
var inst_19461 = (state_19496[(9)]);
var inst_19462 = (state_19496[(7)]);
var inst_19480 = (inst_19461 + (1));
var inst_19481 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19462,inst_19466);
var inst_19461__$1 = inst_19480;
var inst_19462__$1 = inst_19481;
var state_19496__$1 = (function (){var statearr_19503 = state_19496;
(statearr_19503[(9)] = inst_19461__$1);

(statearr_19503[(7)] = inst_19462__$1);

return statearr_19503;
})();
var statearr_19504_19543 = state_19496__$1;
(statearr_19504_19543[(2)] = null);

(statearr_19504_19543[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (13))){
var inst_19466 = (state_19496[(8)]);
var inst_19470 = (inst_19466 instanceof Error);
var state_19496__$1 = state_19496;
var statearr_19505_19544 = state_19496__$1;
(statearr_19505_19544[(2)] = inst_19470);

(statearr_19505_19544[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (22))){
var state_19496__$1 = state_19496;
var statearr_19506_19545 = state_19496__$1;
(statearr_19506_19545[(2)] = null);

(statearr_19506_19545[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (6))){
var state_19496__$1 = state_19496;
var statearr_19507_19546 = state_19496__$1;
(statearr_19507_19546[(2)] = null);

(statearr_19507_19546[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (17))){
var inst_19489 = (state_19496[(2)]);
var state_19496__$1 = state_19496;
var statearr_19508_19547 = state_19496__$1;
(statearr_19508_19547[(2)] = inst_19489);

(statearr_19508_19547[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (3))){
var inst_19494 = (state_19496[(2)]);
var state_19496__$1 = state_19496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19496__$1,inst_19494);
} else {
if((state_val_19497 === (12))){
var inst_19467 = (state_19496[(10)]);
var state_19496__$1 = state_19496;
var statearr_19509_19548 = state_19496__$1;
(statearr_19509_19548[(2)] = inst_19467);

(statearr_19509_19548[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (2))){
var _ = (function (){var statearr_19510 = state_19496;
(statearr_19510[(4)] = cljs.core.cons((5),(state_19496[(4)])));

return statearr_19510;
})();
var inst_19450 = (end >= start);
var state_19496__$1 = state_19496;
if(cljs.core.truth_(inst_19450)){
var statearr_19511_19549 = state_19496__$1;
(statearr_19511_19549[(1)] = (6));

} else {
var statearr_19512_19550 = state_19496__$1;
(statearr_19512_19550[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (23))){
var inst_19485 = (state_19496[(2)]);
var state_19496__$1 = state_19496;
var statearr_19513_19551 = state_19496__$1;
(statearr_19513_19551[(2)] = inst_19485);

(statearr_19513_19551[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (19))){
var state_19496__$1 = state_19496;
var statearr_19514_19552 = state_19496__$1;
(statearr_19514_19552[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (11))){
var inst_19467 = (state_19496[(10)]);
var inst_19466 = (state_19496[(8)]);
var inst_19466__$1 = (state_19496[(2)]);
var inst_19467__$1 = (inst_19466__$1 == null);
var state_19496__$1 = (function (){var statearr_19517 = state_19496;
(statearr_19517[(10)] = inst_19467__$1);

(statearr_19517[(8)] = inst_19466__$1);

return statearr_19517;
})();
if(cljs.core.truth_(inst_19467__$1)){
var statearr_19518_19553 = state_19496__$1;
(statearr_19518_19553[(1)] = (12));

} else {
var statearr_19519_19554 = state_19496__$1;
(statearr_19519_19554[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (9))){
var inst_19461 = (state_19496[(9)]);
var inst_19464 = fluree.db.storage.core.read_block(conn,network,dbid,inst_19461);
var state_19496__$1 = state_19496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19496__$1,(11),inst_19464);
} else {
if((state_val_19497 === (5))){
var _ = (function (){var statearr_19520 = state_19496;
(statearr_19520[(4)] = cljs.core.rest((state_19496[(4)])));

return statearr_19520;
})();
var state_19496__$1 = state_19496;
var ex19516 = (state_19496__$1[(2)]);
var statearr_19521_19555 = state_19496__$1;
(statearr_19521_19555[(5)] = ex19516);


if((ex19516 instanceof Error)){
var statearr_19522_19556 = state_19496__$1;
(statearr_19522_19556[(1)] = (4));

(statearr_19522_19556[(5)] = null);

} else {
throw ex19516;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (14))){
var inst_19472 = (state_19496[(2)]);
var state_19496__$1 = state_19496;
if(cljs.core.truth_(inst_19472)){
var statearr_19523_19557 = state_19496__$1;
(statearr_19523_19557[(1)] = (15));

} else {
var statearr_19524_19558 = state_19496__$1;
(statearr_19524_19558[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (16))){
var inst_19461 = (state_19496[(9)]);
var inst_19475 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19461,end);
var state_19496__$1 = state_19496;
if(inst_19475){
var statearr_19525_19559 = state_19496__$1;
(statearr_19525_19559[(1)] = (18));

} else {
var statearr_19526_19560 = state_19496__$1;
(statearr_19526_19560[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (10))){
var inst_19491 = (state_19496[(2)]);
var _ = (function (){var statearr_19527 = state_19496;
(statearr_19527[(4)] = cljs.core.rest((state_19496[(4)])));

return statearr_19527;
})();
var state_19496__$1 = state_19496;
var statearr_19528_19561 = state_19496__$1;
(statearr_19528_19561[(2)] = inst_19491);

(statearr_19528_19561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (18))){
var inst_19466 = (state_19496[(8)]);
var inst_19462 = (state_19496[(7)]);
var inst_19477 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19462,inst_19466);
var state_19496__$1 = state_19496;
var statearr_19529_19562 = state_19496__$1;
(statearr_19529_19562[(2)] = inst_19477);

(statearr_19529_19562[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19497 === (8))){
var inst_19457 = (state_19496[(2)]);
var inst_19458 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_19459 = start;
var inst_19460 = cljs.core.PersistentVector.EMPTY;
var inst_19461 = inst_19459;
var inst_19462 = inst_19460;
var state_19496__$1 = (function (){var statearr_19530 = state_19496;
(statearr_19530[(11)] = inst_19457);

(statearr_19530[(12)] = inst_19458);

(statearr_19530[(9)] = inst_19461);

(statearr_19530[(7)] = inst_19462);

return statearr_19530;
})();
var statearr_19531_19563 = state_19496__$1;
(statearr_19531_19563[(2)] = null);

(statearr_19531_19563[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_19532 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19532[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_19532[(1)] = (1));

return statearr_19532;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_19496){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19496);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19533){var ex__2730__auto__ = e19533;
var statearr_19534_19564 = state_19496;
(statearr_19534_19564[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19496[(4)]))){
var statearr_19535_19565 = state_19496;
(statearr_19535_19565[(1)] = cljs.core.first((state_19496[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19566 = state_19496;
state_19496 = G__19566;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_19496){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_19496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19536 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19536[(6)] = c__2749__auto__);

return statearr_19536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19582){
var state_val_19583 = (state_19582[(1)]);
if((state_val_19583 === (1))){
var state_19582__$1 = state_19582;
var statearr_19584_19598 = state_19582__$1;
(statearr_19584_19598[(2)] = null);

(statearr_19584_19598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19583 === (2))){
var _ = (function (){var statearr_19585 = state_19582;
(statearr_19585[(4)] = cljs.core.cons((5),(state_19582[(4)])));

return statearr_19585;
})();
var inst_19573 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_19582__$1 = state_19582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19582__$1,(6),inst_19573);
} else {
if((state_val_19583 === (3))){
var inst_19580 = (state_19582[(2)]);
var state_19582__$1 = state_19582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19582__$1,inst_19580);
} else {
if((state_val_19583 === (4))){
var inst_19567 = (state_19582[(2)]);
var state_19582__$1 = state_19582;
var statearr_19587_19599 = state_19582__$1;
(statearr_19587_19599[(2)] = inst_19567);

(statearr_19587_19599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19583 === (5))){
var _ = (function (){var statearr_19588 = state_19582;
(statearr_19588[(4)] = cljs.core.rest((state_19582[(4)])));

return statearr_19588;
})();
var state_19582__$1 = state_19582;
var ex19586 = (state_19582__$1[(2)]);
var statearr_19589_19600 = state_19582__$1;
(statearr_19589_19600[(5)] = ex19586);


if((ex19586 instanceof Error)){
var statearr_19590_19601 = state_19582__$1;
(statearr_19590_19601[(1)] = (4));

(statearr_19590_19601[(5)] = null);

} else {
throw ex19586;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19583 === (6))){
var inst_19575 = (state_19582[(2)]);
var inst_19576 = fluree.db.util.async.throw_err(inst_19575);
var inst_19577 = cljs.core.first(inst_19576);
var _ = (function (){var statearr_19591 = state_19582;
(statearr_19591[(4)] = cljs.core.rest((state_19582[(4)])));

return statearr_19591;
})();
var state_19582__$1 = state_19582;
var statearr_19592_19602 = state_19582__$1;
(statearr_19592_19602[(2)] = inst_19577);

(statearr_19592_19602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2727__auto____0 = (function (){
var statearr_19593 = [null,null,null,null,null,null,null];
(statearr_19593[(0)] = fluree$db$storage$core$block_$_state_machine__2727__auto__);

(statearr_19593[(1)] = (1));

return statearr_19593;
});
var fluree$db$storage$core$block_$_state_machine__2727__auto____1 = (function (state_19582){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19582);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19594){var ex__2730__auto__ = e19594;
var statearr_19595_19603 = state_19582;
(statearr_19595_19603[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19582[(4)]))){
var statearr_19596_19604 = state_19582;
(statearr_19596_19604[(1)] = cljs.core.first((state_19582[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19605 = state_19582;
state_19582 = G__19605;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2727__auto__ = function(state_19582){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2727__auto____1.call(this,state_19582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2727__auto____0;
fluree$db$storage$core$block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19597 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19597[(6)] = c__2749__auto__);

return statearr_19597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
