// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64067 = arguments.length;
var i__5770__auto___64068 = (0);
while(true){
if((i__5770__auto___64068 < len__5769__auto___64067)){
args__5775__auto__.push((arguments[i__5770__auto___64068]));

var G__64069 = (i__5770__auto___64068 + (1));
i__5770__auto___64068 = G__64069;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__63999){
var vec__64000 = p__63999;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64000,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___64070 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64044){
var state_val_64045 = (state_64044[(1)]);
if((state_val_64045 === (7))){
var inst_64021 = (state_64044[(7)]);
var inst_64030 = (state_64044[(8)]);
var inst_64032 = fluree.db.time_travel.as_of_block(inst_64030,inst_64021);
var state_64044__$1 = state_64044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64044__$1,(10),inst_64032);
} else {
if((state_val_64045 === (1))){
var state_64044__$1 = state_64044;
var statearr_64046_64071 = state_64044__$1;
(statearr_64046_64071[(2)] = null);

(statearr_64046_64071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64045 === (4))){
var inst_64003 = (state_64044[(2)]);
var inst_64004 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64003], 0));
var inst_64005 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64003);
var inst_64006 = cljs.core.async.close_BANG_(pc);
var state_64044__$1 = (function (){var statearr_64047 = state_64044;
(statearr_64047[(9)] = inst_64004);

(statearr_64047[(10)] = inst_64005);

return statearr_64047;
})();
var statearr_64048_64072 = state_64044__$1;
(statearr_64048_64072[(2)] = inst_64006);

(statearr_64048_64072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64045 === (6))){
var inst_64024 = (state_64044[(11)]);
var inst_64021 = (state_64044[(7)]);
var inst_64025 = (state_64044[(12)]);
var inst_64028 = (state_64044[(2)]);
var inst_64029 = fluree.db.util.async.throw_err(inst_64028);
var inst_64030 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64029,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_64024,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_64025], 0));
var state_64044__$1 = (function (){var statearr_64049 = state_64044;
(statearr_64049[(8)] = inst_64030);

return statearr_64049;
})();
if(cljs.core.truth_(inst_64021)){
var statearr_64050_64073 = state_64044__$1;
(statearr_64050_64073[(1)] = (7));

} else {
var statearr_64051_64074 = state_64044__$1;
(statearr_64051_64074[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64045 === (3))){
var inst_64042 = (state_64044[(2)]);
var state_64044__$1 = state_64044;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64044__$1,inst_64042);
} else {
if((state_val_64045 === (2))){
var _ = (function (){var statearr_64053 = state_64044;
(statearr_64053[(4)] = cljs.core.cons((5),(state_64044[(4)])));

return statearr_64053;
})();
var inst_64016 = opts;
var inst_64017 = cljs.core.__destructure_map(inst_64016);
var inst_64018 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64017,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_64019 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64017,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_64020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64017,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64021 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64017,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64022 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_64023 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_64024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64023,(0),null);
var inst_64025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64023,(1),null);
var inst_64026 = fluree.db.session.db(conn,ledger,opts);
var state_64044__$1 = (function (){var statearr_64054 = state_64044;
(statearr_64054[(13)] = inst_64018);

(statearr_64054[(11)] = inst_64024);

(statearr_64054[(14)] = inst_64020);

(statearr_64054[(15)] = inst_64019);

(statearr_64054[(7)] = inst_64021);

(statearr_64054[(12)] = inst_64025);

(statearr_64054[(16)] = inst_64022);

return statearr_64054;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64044__$1,(6),inst_64026);
} else {
if((state_val_64045 === (9))){
var inst_64038 = (state_64044[(2)]);
var inst_64039 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64038);
var _ = (function (){var statearr_64055 = state_64044;
(statearr_64055[(4)] = cljs.core.rest((state_64044[(4)])));

return statearr_64055;
})();
var state_64044__$1 = state_64044;
var statearr_64056_64075 = state_64044__$1;
(statearr_64056_64075[(2)] = inst_64039);

(statearr_64056_64075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64045 === (5))){
var _ = (function (){var statearr_64057 = state_64044;
(statearr_64057[(4)] = cljs.core.rest((state_64044[(4)])));

return statearr_64057;
})();
var state_64044__$1 = state_64044;
var ex64052 = (state_64044__$1[(2)]);
var statearr_64058_64076 = state_64044__$1;
(statearr_64058_64076[(5)] = ex64052);


var statearr_64059_64077 = state_64044__$1;
(statearr_64059_64077[(1)] = (4));

(statearr_64059_64077[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64045 === (10))){
var inst_64034 = (state_64044[(2)]);
var inst_64035 = fluree.db.util.async.throw_err(inst_64034);
var state_64044__$1 = state_64044;
var statearr_64060_64078 = state_64044__$1;
(statearr_64060_64078[(2)] = inst_64035);

(statearr_64060_64078[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64045 === (8))){
var inst_64030 = (state_64044[(8)]);
var state_64044__$1 = state_64044;
var statearr_64061_64079 = state_64044__$1;
(statearr_64061_64079[(2)] = inst_64030);

(statearr_64061_64079[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_64062 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64062[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_64062[(1)] = (1));

return statearr_64062;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_64044){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64044);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64063){var ex__2730__auto__ = e64063;
var statearr_64064_64080 = state_64044;
(statearr_64064_64080[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64044[(4)]))){
var statearr_64065_64081 = state_64044;
(statearr_64065_64081[(1)] = cljs.core.first((state_64044[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64082 = state_64044;
state_64044 = G__64082;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_64044){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_64044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64066 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64066[(6)] = c__2749__auto___64070);

return statearr_64066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq63996){
var G__63997 = cljs.core.first(seq63996);
var seq63996__$1 = cljs.core.next(seq63996);
var G__63998 = cljs.core.first(seq63996__$1);
var seq63996__$2 = cljs.core.next(seq63996__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63997,G__63998,seq63996__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__64084 = arguments.length;
switch (G__64084) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64210){
var state_val_64211 = (state_64210[(1)]);
if((state_val_64211 === (7))){
var inst_64100 = (state_64210[(7)]);
var inst_64110 = (state_64210[(8)]);
var inst_64112 = fluree.db.time_travel.as_of_block(inst_64110,inst_64100);
var state_64210__$1 = state_64210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64210__$1,(10),inst_64112);
} else {
if((state_val_64211 === (20))){
var inst_64104 = (state_64210[(9)]);
var state_64210__$1 = state_64210;
var statearr_64212_64292 = state_64210__$1;
(statearr_64212_64292[(2)] = inst_64104);

(statearr_64212_64292[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (27))){
var inst_64098 = (state_64210[(10)]);
var state_64210__$1 = state_64210;
var statearr_64213_64293 = state_64210__$1;
(statearr_64213_64293[(2)] = inst_64098);

(statearr_64213_64293[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (1))){
var state_64210__$1 = state_64210;
var statearr_64214_64294 = state_64210__$1;
(statearr_64214_64294[(2)] = null);

(statearr_64214_64294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (24))){
var inst_64107 = (state_64210[(11)]);
var state_64210__$1 = state_64210;
if(cljs.core.truth_(inst_64107)){
var statearr_64215_64295 = state_64210__$1;
(statearr_64215_64295[(1)] = (26));

} else {
var statearr_64216_64296 = state_64210__$1;
(statearr_64216_64296[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (39))){
var inst_64172 = (state_64210[(12)]);
var inst_64175 = cljs.core.ex_data(inst_64172);
var inst_64176 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64177 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64175);
var inst_64178 = cljs.core.ex_message(inst_64172);
var inst_64179 = [inst_64177,inst_64178,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64180 = cljs.core.PersistentHashMap.fromArrays(inst_64176,inst_64179);
var state_64210__$1 = state_64210;
var statearr_64217_64297 = state_64210__$1;
(statearr_64217_64297[(2)] = inst_64180);

(statearr_64217_64297[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (46))){
var inst_64172 = (state_64210[(12)]);
var state_64210__$1 = state_64210;
var statearr_64218_64298 = state_64210__$1;
(statearr_64218_64298[(2)] = inst_64172);

(statearr_64218_64298[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (4))){
var inst_64085 = (state_64210[(2)]);
var inst_64086 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64085], 0));
var inst_64087 = cljs.core.ex_data(inst_64085);
var inst_64088 = cljs.core.ex_message(inst_64085);
var inst_64089 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64087,new cljs.core.Keyword(null,"message","message",-406056002),inst_64088);
var state_64210__$1 = (function (){var statearr_64219 = state_64210;
(statearr_64219[(13)] = inst_64086);

return statearr_64219;
})();
var statearr_64220_64299 = state_64210__$1;
(statearr_64220_64299[(2)] = inst_64089);

(statearr_64220_64299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (15))){
var state_64210__$1 = state_64210;
var statearr_64221_64300 = state_64210__$1;
(statearr_64221_64300[(2)] = (1000000));

(statearr_64221_64300[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (48))){
var inst_64172 = (state_64210[(12)]);
var state_64210__$1 = state_64210;
var statearr_64222_64301 = state_64210__$1;
(statearr_64222_64301[(2)] = inst_64172);

(statearr_64222_64301[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (50))){
var inst_64199 = (state_64210[(2)]);
var state_64210__$1 = state_64210;
var statearr_64223_64302 = state_64210__$1;
(statearr_64223_64302[(2)] = inst_64199);

(statearr_64223_64302[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (21))){
var inst_64103 = (state_64210[(14)]);
var state_64210__$1 = state_64210;
if(cljs.core.truth_(inst_64103)){
var statearr_64224_64303 = state_64210__$1;
(statearr_64224_64303[(1)] = (23));

} else {
var statearr_64225_64304 = state_64210__$1;
(statearr_64225_64304[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (31))){
var inst_64161 = (state_64210[(2)]);
var inst_64162 = cljs.core.not(inst_64161);
var state_64210__$1 = state_64210;
if(inst_64162){
var statearr_64226_64305 = state_64210__$1;
(statearr_64226_64305[(1)] = (35));

} else {
var statearr_64227_64306 = state_64210__$1;
(statearr_64227_64306[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (32))){
var inst_64105 = (state_64210[(15)]);
var state_64210__$1 = state_64210;
var statearr_64228_64307 = state_64210__$1;
(statearr_64228_64307[(2)] = inst_64105);

(statearr_64228_64307[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (40))){
var inst_64135 = (state_64210[(16)]);
var state_64210__$1 = state_64210;
if(cljs.core.truth_(inst_64135)){
var statearr_64229_64308 = state_64210__$1;
(statearr_64229_64308[(1)] = (42));

} else {
var statearr_64230_64309 = state_64210__$1;
(statearr_64230_64309[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (33))){
var inst_64101 = (state_64210[(17)]);
var state_64210__$1 = state_64210;
var statearr_64231_64310 = state_64210__$1;
(statearr_64231_64310[(2)] = inst_64101);

(statearr_64231_64310[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (13))){
var inst_64130 = (state_64210[(18)]);
var inst_64106 = (state_64210[(19)]);
var inst_64128 = (state_64210[(2)]);
var inst_64129 = cljs.core.volatile_BANG_((0));
var inst_64130__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_64106);
var state_64210__$1 = (function (){var statearr_64232 = state_64210;
(statearr_64232[(18)] = inst_64130__$1);

(statearr_64232[(20)] = inst_64128);

(statearr_64232[(21)] = inst_64129);

return statearr_64232;
})();
if(cljs.core.truth_(inst_64130__$1)){
var statearr_64233_64311 = state_64210__$1;
(statearr_64233_64311[(1)] = (14));

} else {
var statearr_64234_64312 = state_64210__$1;
(statearr_64234_64312[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (22))){
var inst_64151 = (state_64210[(2)]);
var state_64210__$1 = state_64210;
var statearr_64235_64313 = state_64210__$1;
(statearr_64235_64313[(2)] = inst_64151);

(statearr_64235_64313[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (36))){
var inst_64137 = (state_64210[(22)]);
var inst_64118 = (state_64210[(23)]);
var inst_64168 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64137);
var inst_64169 = fluree.db.query.fql.query(inst_64118,inst_64168);
var state_64210__$1 = state_64210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64210__$1,(38),inst_64169);
} else {
if((state_val_64211 === (41))){
var inst_64203 = (state_64210[(2)]);
var state_64210__$1 = state_64210;
var statearr_64236_64314 = state_64210__$1;
(statearr_64236_64314[(2)] = inst_64203);

(statearr_64236_64314[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (43))){
var state_64210__$1 = state_64210;
var statearr_64237_64315 = state_64210__$1;
(statearr_64237_64315[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (29))){
var inst_64105 = (state_64210[(15)]);
var state_64210__$1 = state_64210;
if(cljs.core.truth_(inst_64105)){
var statearr_64239_64316 = state_64210__$1;
(statearr_64239_64316[(1)] = (32));

} else {
var statearr_64240_64317 = state_64210__$1;
(statearr_64240_64317[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (44))){
var inst_64201 = (state_64210[(2)]);
var state_64210__$1 = state_64210;
var statearr_64241_64318 = state_64210__$1;
(statearr_64241_64318[(2)] = inst_64201);

(statearr_64241_64318[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (6))){
var inst_64100 = (state_64210[(7)]);
var inst_64109 = (state_64210[(2)]);
var inst_64110 = fluree.db.util.async.throw_err(inst_64109);
var state_64210__$1 = (function (){var statearr_64242 = state_64210;
(statearr_64242[(8)] = inst_64110);

return statearr_64242;
})();
if(cljs.core.truth_(inst_64100)){
var statearr_64243_64319 = state_64210__$1;
(statearr_64243_64319[(1)] = (7));

} else {
var statearr_64244_64320 = state_64210__$1;
(statearr_64244_64320[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (28))){
var inst_64147 = (state_64210[(2)]);
var state_64210__$1 = state_64210;
var statearr_64245_64321 = state_64210__$1;
(statearr_64245_64321[(2)] = inst_64147);

(statearr_64245_64321[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (25))){
var inst_64149 = (state_64210[(2)]);
var state_64210__$1 = state_64210;
var statearr_64246_64322 = state_64210__$1;
(statearr_64246_64322[(2)] = inst_64149);

(statearr_64246_64322[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (34))){
var inst_64158 = (state_64210[(2)]);
var state_64210__$1 = state_64210;
var statearr_64247_64323 = state_64210__$1;
(statearr_64247_64323[(2)] = inst_64158);

(statearr_64247_64323[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (17))){
var inst_64099 = (state_64210[(24)]);
var state_64210__$1 = state_64210;
var statearr_64248_64324 = state_64210__$1;
(statearr_64248_64324[(2)] = inst_64099);

(statearr_64248_64324[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (3))){
var inst_64208 = (state_64210[(2)]);
var state_64210__$1 = state_64210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64210__$1,inst_64208);
} else {
if((state_val_64211 === (12))){
var inst_64126 = cljs.core.PersistentHashMap.EMPTY;
var state_64210__$1 = state_64210;
var statearr_64249_64325 = state_64210__$1;
(statearr_64249_64325[(2)] = inst_64126);

(statearr_64249_64325[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (2))){
var _ = (function (){var statearr_64250 = state_64210;
(statearr_64250[(4)] = cljs.core.cons((5),(state_64210[(4)])));

return statearr_64250;
})();
var inst_64096 = query_map;
var inst_64097 = cljs.core.__destructure_map(inst_64096);
var inst_64098 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64097,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_64099 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64097,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_64100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64097,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64101 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64097,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_64102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64097,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_64103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64097,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_64104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64097,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_64105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64097,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_64106 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64097,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_64107 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64097,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_64210__$1 = (function (){var statearr_64251 = state_64210;
(statearr_64251[(7)] = inst_64100);

(statearr_64251[(10)] = inst_64098);

(statearr_64251[(24)] = inst_64099);

(statearr_64251[(11)] = inst_64107);

(statearr_64251[(9)] = inst_64104);

(statearr_64251[(25)] = inst_64102);

(statearr_64251[(19)] = inst_64106);

(statearr_64251[(15)] = inst_64105);

(statearr_64251[(14)] = inst_64103);

(statearr_64251[(17)] = inst_64101);

return statearr_64251;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64210__$1,(6),sources);
} else {
if((state_val_64211 === (23))){
var inst_64103 = (state_64210[(14)]);
var state_64210__$1 = state_64210;
var statearr_64252_64326 = state_64210__$1;
(statearr_64252_64326[(2)] = inst_64103);

(statearr_64252_64326[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (47))){
var inst_64118 = (state_64210[(23)]);
var inst_64183 = (state_64210[(26)]);
var inst_64129 = (state_64210[(21)]);
var inst_64136 = (state_64210[(27)]);
var inst_64189 = (state_64210[(2)]);
var inst_64190 = cljs.core.deref(inst_64129);
var inst_64191 = fluree.db.util.core.response_time_formatted(inst_64136);
var inst_64192 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64118);
var inst_64193 = [(200),inst_64189,inst_64190,inst_64191,inst_64192];
var inst_64194 = cljs.core.PersistentHashMap.fromArrays(inst_64183,inst_64193);
var state_64210__$1 = state_64210;
var statearr_64253_64327 = state_64210__$1;
(statearr_64253_64327[(2)] = inst_64194);

(statearr_64253_64327[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (35))){
var inst_64164 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64165 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64166 = cljs.core.PersistentHashMap.fromArrays(inst_64164,inst_64165);
var state_64210__$1 = state_64210;
var statearr_64254_64328 = state_64210__$1;
(statearr_64254_64328[(2)] = inst_64166);

(statearr_64254_64328[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (19))){
var inst_64153 = (state_64210[(28)]);
var inst_64153__$1 = (state_64210[(2)]);
var state_64210__$1 = (function (){var statearr_64255 = state_64210;
(statearr_64255[(28)] = inst_64153__$1);

return statearr_64255;
})();
if(cljs.core.truth_(inst_64153__$1)){
var statearr_64256_64329 = state_64210__$1;
(statearr_64256_64329[(1)] = (29));

} else {
var statearr_64257_64330 = state_64210__$1;
(statearr_64257_64330[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (11))){
var inst_64102 = (state_64210[(25)]);
var inst_64118 = (state_64210[(23)]);
var inst_64119 = (state_64210[(29)]);
var inst_64121 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_64118);
var inst_64122 = fluree.db.connection_js.open_api_QMARK_(inst_64119);
var inst_64123 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_64118);
var inst_64124 = fluree.db.api_js.get_sources(inst_64119,inst_64121,inst_64122,inst_64123,inst_64102,db_fn);
var state_64210__$1 = state_64210;
var statearr_64259_64331 = state_64210__$1;
(statearr_64259_64331[(2)] = inst_64124);

(statearr_64259_64331[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (9))){
var inst_64102 = (state_64210[(25)]);
var inst_64118 = (state_64210[(23)]);
var inst_64118__$1 = (state_64210[(2)]);
var inst_64119 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_64118__$1);
var state_64210__$1 = (function (){var statearr_64260 = state_64210;
(statearr_64260[(23)] = inst_64118__$1);

(statearr_64260[(29)] = inst_64119);

return statearr_64260;
})();
if(cljs.core.truth_(inst_64102)){
var statearr_64261_64332 = state_64210__$1;
(statearr_64261_64332[(1)] = (11));

} else {
var statearr_64262_64333 = state_64210__$1;
(statearr_64262_64333[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (5))){
var _ = (function (){var statearr_64263 = state_64210;
(statearr_64263[(4)] = cljs.core.rest((state_64210[(4)])));

return statearr_64263;
})();
var state_64210__$1 = state_64210;
var ex64258 = (state_64210__$1[(2)]);
var statearr_64264_64334 = state_64210__$1;
(statearr_64264_64334[(5)] = ex64258);


var statearr_64265_64335 = state_64210__$1;
(statearr_64265_64335[(1)] = (4));

(statearr_64265_64335[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (14))){
var inst_64130 = (state_64210[(18)]);
var state_64210__$1 = state_64210;
var statearr_64266_64336 = state_64210__$1;
(statearr_64266_64336[(2)] = inst_64130);

(statearr_64266_64336[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (45))){
var inst_64172 = (state_64210[(12)]);
var inst_64186 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_64172);
var state_64210__$1 = state_64210;
var statearr_64267_64337 = state_64210__$1;
(statearr_64267_64337[(2)] = inst_64186);

(statearr_64267_64337[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (26))){
var inst_64107 = (state_64210[(11)]);
var state_64210__$1 = state_64210;
var statearr_64268_64338 = state_64210__$1;
(statearr_64268_64338[(2)] = inst_64107);

(statearr_64268_64338[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (16))){
var inst_64099 = (state_64210[(24)]);
var inst_64106 = (state_64210[(19)]);
var inst_64128 = (state_64210[(20)]);
var inst_64129 = (state_64210[(21)]);
var inst_64134 = (state_64210[(2)]);
var inst_64135 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_64106);
var inst_64136 = fluree.db.util.core.current_time_millis();
var inst_64137 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64106,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_64128,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_64134,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64129], 0));
var state_64210__$1 = (function (){var statearr_64269 = state_64210;
(statearr_64269[(22)] = inst_64137);

(statearr_64269[(27)] = inst_64136);

(statearr_64269[(16)] = inst_64135);

return statearr_64269;
})();
if(cljs.core.truth_(inst_64099)){
var statearr_64270_64339 = state_64210__$1;
(statearr_64270_64339[(1)] = (17));

} else {
var statearr_64271_64340 = state_64210__$1;
(statearr_64271_64340[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (38))){
var inst_64172 = (state_64210[(12)]);
var inst_64171 = (state_64210[(2)]);
var inst_64172__$1 = fluree.db.util.async.throw_err(inst_64171);
var inst_64173 = (inst_64172__$1 instanceof cljs.core.ExceptionInfo);
var state_64210__$1 = (function (){var statearr_64272 = state_64210;
(statearr_64272[(12)] = inst_64172__$1);

return statearr_64272;
})();
if(cljs.core.truth_(inst_64173)){
var statearr_64273_64341 = state_64210__$1;
(statearr_64273_64341[(1)] = (39));

} else {
var statearr_64274_64342 = state_64210__$1;
(statearr_64274_64342[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (30))){
var inst_64153 = (state_64210[(28)]);
var state_64210__$1 = state_64210;
var statearr_64275_64343 = state_64210__$1;
(statearr_64275_64343[(2)] = inst_64153);

(statearr_64275_64343[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (10))){
var inst_64114 = (state_64210[(2)]);
var inst_64115 = fluree.db.util.async.throw_err(inst_64114);
var state_64210__$1 = state_64210;
var statearr_64276_64344 = state_64210__$1;
(statearr_64276_64344[(2)] = inst_64115);

(statearr_64276_64344[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (18))){
var inst_64104 = (state_64210[(9)]);
var state_64210__$1 = state_64210;
if(cljs.core.truth_(inst_64104)){
var statearr_64277_64345 = state_64210__$1;
(statearr_64277_64345[(1)] = (20));

} else {
var statearr_64278_64346 = state_64210__$1;
(statearr_64278_64346[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (42))){
var inst_64172 = (state_64210[(12)]);
var inst_64183 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64184 = cljs.core.sequential_QMARK_(inst_64172);
var state_64210__$1 = (function (){var statearr_64279 = state_64210;
(statearr_64279[(26)] = inst_64183);

return statearr_64279;
})();
if(inst_64184){
var statearr_64280_64347 = state_64210__$1;
(statearr_64280_64347[(1)] = (45));

} else {
var statearr_64281_64348 = state_64210__$1;
(statearr_64281_64348[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (37))){
var inst_64205 = (state_64210[(2)]);
var _ = (function (){var statearr_64282 = state_64210;
(statearr_64282[(4)] = cljs.core.rest((state_64210[(4)])));

return statearr_64282;
})();
var state_64210__$1 = state_64210;
var statearr_64283_64349 = state_64210__$1;
(statearr_64283_64349[(2)] = inst_64205);

(statearr_64283_64349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (8))){
var inst_64110 = (state_64210[(8)]);
var state_64210__$1 = state_64210;
var statearr_64284_64350 = state_64210__$1;
(statearr_64284_64350[(2)] = inst_64110);

(statearr_64284_64350[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64211 === (49))){
var state_64210__$1 = state_64210;
var statearr_64285_64351 = state_64210__$1;
(statearr_64285_64351[(2)] = null);

(statearr_64285_64351[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_64286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64286[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_64286[(1)] = (1));

return statearr_64286;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_64210){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64210);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64287){var ex__2730__auto__ = e64287;
var statearr_64288_64352 = state_64210;
(statearr_64288_64352[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64210[(4)]))){
var statearr_64289_64353 = state_64210;
(statearr_64289_64353[(1)] = cljs.core.first((state_64210[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64354 = state_64210;
state_64210 = G__64354;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_64210){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_64210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64290 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64290[(6)] = c__2749__auto__);

return statearr_64290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__64355_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__64355_SHARP_);
}));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64377){
var state_val_64378 = (state_64377[(1)]);
if((state_val_64378 === (1))){
var inst_64359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64360 = [resp_chan,timeout_chan];
var inst_64361 = (new cljs.core.PersistentVector(null,2,(5),inst_64359,inst_64360,null));
var state_64377__$1 = state_64377;
return cljs.core.async.ioc_alts_BANG_(state_64377__$1,(2),inst_64361);
} else {
if((state_val_64378 === (2))){
var inst_64363 = (state_64377[(2)]);
var inst_64364 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64363,(0),null);
var inst_64365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64363,(1),null);
var inst_64366 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_64365);
var state_64377__$1 = (function (){var statearr_64379 = state_64377;
(statearr_64379[(7)] = inst_64364);

return statearr_64379;
})();
if(inst_64366){
var statearr_64380_64390 = state_64377__$1;
(statearr_64380_64390[(1)] = (3));

} else {
var statearr_64381_64391 = state_64377__$1;
(statearr_64381_64391[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64378 === (3))){
var inst_64368 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_64369 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64370 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_64371 = [tid,(408),inst_64370];
var inst_64372 = cljs.core.PersistentHashMap.fromArrays(inst_64369,inst_64371);
var state_64377__$1 = (function (){var statearr_64382 = state_64377;
(statearr_64382[(8)] = inst_64368);

return statearr_64382;
})();
var statearr_64383_64392 = state_64377__$1;
(statearr_64383_64392[(2)] = inst_64372);

(statearr_64383_64392[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64378 === (4))){
var inst_64364 = (state_64377[(7)]);
var state_64377__$1 = state_64377;
var statearr_64384_64393 = state_64377__$1;
(statearr_64384_64393[(2)] = inst_64364);

(statearr_64384_64393[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64378 === (5))){
var inst_64375 = (state_64377[(2)]);
var state_64377__$1 = state_64377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64377__$1,inst_64375);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_64385 = [null,null,null,null,null,null,null,null,null];
(statearr_64385[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__);

(statearr_64385[(1)] = (1));

return statearr_64385;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1 = (function (state_64377){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64377);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64386){var ex__2730__auto__ = e64386;
var statearr_64387_64394 = state_64377;
(statearr_64387_64394[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64377[(4)]))){
var statearr_64388_64395 = state_64377;
(statearr_64388_64395[(1)] = cljs.core.first((state_64377[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64396 = state_64377;
state_64377 = G__64396;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = function(state_64377){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1.call(this,state_64377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64389 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64389[(6)] = c__2749__auto__);

return statearr_64389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__64398 = arguments.length;
switch (G__64398) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__64399 = opts;
var map__64399__$1 = cljs.core.__destructure_map(map__64399);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64399__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64399__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64399__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64399__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__64400 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64400,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64400,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e64403){var e = e64403;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__64406 = arguments.length;
switch (G__64406) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64472){
var state_val_64473 = (state_64472[(1)]);
if((state_val_64473 === (7))){
var inst_64426 = (state_64472[(7)]);
var inst_64427 = (state_64472[(8)]);
var inst_64423 = (state_64472[(9)]);
var inst_64425 = (state_64472[(10)]);
var inst_64428 = (state_64472[(11)]);
var inst_64441 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_64442 = [ledger,txn,inst_64423,inst_64425,inst_64426,inst_64427,inst_64428];
var inst_64443 = cljs.core.PersistentHashMap.fromArrays(inst_64441,inst_64442);
var inst_64444 = fluree.db.util.core.without_nils(inst_64443);
var inst_64445 = fluree.db.operations.transact_async(conn,inst_64444);
var state_64472__$1 = state_64472;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64472__$1,(13),inst_64445);
} else {
if((state_val_64473 === (20))){
var inst_64463 = (state_64472[(2)]);
var state_64472__$1 = state_64472;
var statearr_64474_64510 = state_64472__$1;
(statearr_64474_64510[(2)] = inst_64463);

(statearr_64474_64510[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (1))){
var state_64472__$1 = state_64472;
var statearr_64475_64511 = state_64472__$1;
(statearr_64475_64511[(2)] = null);

(statearr_64475_64511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (4))){
var inst_64407 = (state_64472[(2)]);
var inst_64408 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64407], 0));
var inst_64409 = cljs.core.ex_data(inst_64407);
var inst_64410 = cljs.core.ex_message(inst_64407);
var inst_64411 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64409,new cljs.core.Keyword(null,"message","message",-406056002),inst_64410);
var state_64472__$1 = (function (){var statearr_64476 = state_64472;
(statearr_64476[(12)] = inst_64408);

return statearr_64476;
})();
var statearr_64477_64512 = state_64472__$1;
(statearr_64477_64512[(2)] = inst_64411);

(statearr_64477_64512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (15))){
var inst_64422 = (state_64472[(13)]);
var inst_64447 = (state_64472[(14)]);
var inst_64450 = fluree.db.api_js.monitor_tx(conn,ledger,inst_64447,inst_64422);
var state_64472__$1 = state_64472;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64472__$1,(17),inst_64450);
} else {
if((state_val_64473 === (13))){
var inst_64421 = (state_64472[(15)]);
var inst_64447 = (state_64472[(2)]);
var state_64472__$1 = (function (){var statearr_64478 = state_64472;
(statearr_64478[(14)] = inst_64447);

return statearr_64478;
})();
if(cljs.core.truth_(inst_64421)){
var statearr_64479_64513 = state_64472__$1;
(statearr_64479_64513[(1)] = (14));

} else {
var statearr_64480_64514 = state_64472__$1;
(statearr_64480_64514[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (6))){
var inst_64421 = (state_64472[(15)]);
var inst_64420 = (state_64472[(16)]);
var inst_64430 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_64420,opts);
var inst_64431 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_64430);
var inst_64432 = fluree.db.operations.command_async(conn,inst_64430);
var state_64472__$1 = (function (){var statearr_64481 = state_64472;
(statearr_64481[(17)] = inst_64431);

(statearr_64481[(18)] = inst_64432);

return statearr_64481;
})();
if(cljs.core.truth_(inst_64421)){
var statearr_64482_64515 = state_64472__$1;
(statearr_64482_64515[(1)] = (9));

} else {
var statearr_64483_64516 = state_64472__$1;
(statearr_64483_64516[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (17))){
var inst_64452 = (state_64472[(19)]);
var inst_64452__$1 = (state_64472[(2)]);
var inst_64453 = (inst_64452__$1 instanceof cljs.core.ExceptionInfo);
var state_64472__$1 = (function (){var statearr_64484 = state_64472;
(statearr_64484[(19)] = inst_64452__$1);

return statearr_64484;
})();
if(cljs.core.truth_(inst_64453)){
var statearr_64485_64517 = state_64472__$1;
(statearr_64485_64517[(1)] = (18));

} else {
var statearr_64486_64518 = state_64472__$1;
(statearr_64486_64518[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (3))){
var inst_64470 = (state_64472[(2)]);
var state_64472__$1 = state_64472;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64472__$1,inst_64470);
} else {
if((state_val_64473 === (12))){
var inst_64437 = (state_64472[(2)]);
var state_64472__$1 = state_64472;
var statearr_64487_64519 = state_64472__$1;
(statearr_64487_64519[(2)] = inst_64437);

(statearr_64487_64519[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (2))){
var inst_64420 = (state_64472[(16)]);
var _ = (function (){var statearr_64488 = state_64472;
(statearr_64488[(4)] = cljs.core.cons((5),(state_64472[(4)])));

return statearr_64488;
})();
var inst_64418 = opts;
var inst_64419 = cljs.core.__destructure_map(inst_64418);
var inst_64420__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64419,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_64421 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64419,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_64422 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_64419,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_64423 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64419,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64424 = fluree.db.util.core.current_time_millis();
var inst_64425 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_64419,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_64424);
var inst_64426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64419,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_64427 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64419,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_64428 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64419,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_64472__$1 = (function (){var statearr_64489 = state_64472;
(statearr_64489[(13)] = inst_64422);

(statearr_64489[(7)] = inst_64426);

(statearr_64489[(8)] = inst_64427);

(statearr_64489[(15)] = inst_64421);

(statearr_64489[(9)] = inst_64423);

(statearr_64489[(16)] = inst_64420__$1);

(statearr_64489[(10)] = inst_64425);

(statearr_64489[(11)] = inst_64428);

return statearr_64489;
})();
if(cljs.core.truth_(inst_64420__$1)){
var statearr_64490_64520 = state_64472__$1;
(statearr_64490_64520[(1)] = (6));

} else {
var statearr_64491_64521 = state_64472__$1;
(statearr_64491_64521[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (19))){
var inst_64452 = (state_64472[(19)]);
var state_64472__$1 = state_64472;
var statearr_64492_64522 = state_64472__$1;
(statearr_64492_64522[(2)] = inst_64452);

(statearr_64492_64522[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (11))){
var inst_64439 = (state_64472[(2)]);
var state_64472__$1 = state_64472;
var statearr_64494_64523 = state_64472__$1;
(statearr_64494_64523[(2)] = inst_64439);

(statearr_64494_64523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (9))){
var inst_64432 = (state_64472[(18)]);
var state_64472__$1 = state_64472;
var statearr_64495_64524 = state_64472__$1;
(statearr_64495_64524[(2)] = inst_64432);

(statearr_64495_64524[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (5))){
var _ = (function (){var statearr_64496 = state_64472;
(statearr_64496[(4)] = cljs.core.rest((state_64472[(4)])));

return statearr_64496;
})();
var state_64472__$1 = state_64472;
var ex64493 = (state_64472__$1[(2)]);
var statearr_64497_64525 = state_64472__$1;
(statearr_64497_64525[(5)] = ex64493);


var statearr_64498_64526 = state_64472__$1;
(statearr_64498_64526[(1)] = (4));

(statearr_64498_64526[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (14))){
var inst_64447 = (state_64472[(14)]);
var state_64472__$1 = state_64472;
var statearr_64499_64527 = state_64472__$1;
(statearr_64499_64527[(2)] = inst_64447);

(statearr_64499_64527[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (16))){
var inst_64465 = (state_64472[(2)]);
var state_64472__$1 = state_64472;
var statearr_64500_64528 = state_64472__$1;
(statearr_64500_64528[(2)] = inst_64465);

(statearr_64500_64528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (10))){
var inst_64431 = (state_64472[(17)]);
var inst_64422 = (state_64472[(13)]);
var inst_64435 = fluree.db.api_js.monitor_tx(conn,ledger,inst_64431,inst_64422);
var state_64472__$1 = state_64472;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64472__$1,(12),inst_64435);
} else {
if((state_val_64473 === (18))){
var inst_64452 = (state_64472[(19)]);
var inst_64455 = cljs.core.ex_data(inst_64452);
var inst_64456 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64457 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64455);
var inst_64458 = cljs.core.ex_message(inst_64452);
var inst_64459 = [inst_64457,inst_64458,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_64460 = cljs.core.PersistentHashMap.fromArrays(inst_64456,inst_64459);
var state_64472__$1 = state_64472;
var statearr_64501_64529 = state_64472__$1;
(statearr_64501_64529[(2)] = inst_64460);

(statearr_64501_64529[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (8))){
var inst_64467 = (state_64472[(2)]);
var _ = (function (){var statearr_64502 = state_64472;
(statearr_64502[(4)] = cljs.core.rest((state_64472[(4)])));

return statearr_64502;
})();
var state_64472__$1 = state_64472;
var statearr_64503_64530 = state_64472__$1;
(statearr_64503_64530[(2)] = inst_64467);

(statearr_64503_64530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_64504 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64504[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_64504[(1)] = (1));

return statearr_64504;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_64472){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64472);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64505){var ex__2730__auto__ = e64505;
var statearr_64506_64531 = state_64472;
(statearr_64506_64531[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64472[(4)]))){
var statearr_64507_64532 = state_64472;
(statearr_64507_64532[(1)] = cljs.core.first((state_64472[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64533 = state_64472;
state_64472 = G__64533;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_64472){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_64472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64508 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64508[(6)] = c__2749__auto__);

return statearr_64508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64535 = arguments.length;
var i__5770__auto___64536 = (0);
while(true){
if((i__5770__auto___64536 < len__5769__auto___64535)){
args__5775__auto__.push((arguments[i__5770__auto___64536]));

var G__64537 = (i__5770__auto___64536 + (1));
i__5770__auto___64536 = G__64537;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq64534){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq64534));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64568){
var state_val_64569 = (state_64568[(1)]);
if((state_val_64569 === (1))){
var inst_64538 = cljs.core.first(flakes);
var inst_64539 = cljs.core.rest(flakes);
var inst_64540 = cljs.core.PersistentVector.EMPTY;
var inst_64541 = inst_64538;
var inst_64542 = inst_64539;
var inst_64543 = inst_64540;
var state_64568__$1 = (function (){var statearr_64570 = state_64568;
(statearr_64570[(7)] = inst_64542);

(statearr_64570[(8)] = inst_64543);

(statearr_64570[(9)] = inst_64541);

return statearr_64570;
})();
var statearr_64571_64584 = state_64568__$1;
(statearr_64571_64584[(2)] = null);

(statearr_64571_64584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64569 === (2))){
var inst_64541 = (state_64568[(9)]);
var inst_64545 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_64546 = cljs.core.PersistentHashMap.EMPTY;
var inst_64547 = [true,inst_64546];
var inst_64548 = cljs.core.PersistentHashMap.fromArrays(inst_64545,inst_64547);
var inst_64549 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_64548,inst_64541);
var state_64568__$1 = state_64568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64568__$1,(4),inst_64549);
} else {
if((state_val_64569 === (3))){
var inst_64566 = (state_64568[(2)]);
var state_64568__$1 = state_64568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64568__$1,inst_64566);
} else {
if((state_val_64569 === (4))){
var inst_64542 = (state_64568[(7)]);
var inst_64543 = (state_64568[(8)]);
var inst_64551 = (state_64568[(2)]);
var inst_64552 = fluree.db.util.async.throw_err(inst_64551);
var inst_64553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64554 = [inst_64552];
var inst_64555 = (new cljs.core.PersistentVector(null,1,(5),inst_64553,inst_64554,null));
var inst_64556 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_64543,inst_64555);
var inst_64557 = cljs.core.first(inst_64542);
var state_64568__$1 = (function (){var statearr_64572 = state_64568;
(statearr_64572[(10)] = inst_64556);

return statearr_64572;
})();
if(cljs.core.truth_(inst_64557)){
var statearr_64573_64585 = state_64568__$1;
(statearr_64573_64585[(1)] = (5));

} else {
var statearr_64574_64586 = state_64568__$1;
(statearr_64574_64586[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64569 === (5))){
var inst_64556 = (state_64568[(10)]);
var inst_64542 = (state_64568[(7)]);
var inst_64559 = cljs.core.first(inst_64542);
var inst_64560 = cljs.core.rest(inst_64542);
var inst_64541 = inst_64559;
var inst_64542__$1 = inst_64560;
var inst_64543 = inst_64556;
var state_64568__$1 = (function (){var statearr_64575 = state_64568;
(statearr_64575[(7)] = inst_64542__$1);

(statearr_64575[(8)] = inst_64543);

(statearr_64575[(9)] = inst_64541);

return statearr_64575;
})();
var statearr_64576_64587 = state_64568__$1;
(statearr_64576_64587[(2)] = null);

(statearr_64576_64587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64569 === (6))){
var inst_64556 = (state_64568[(10)]);
var state_64568__$1 = state_64568;
var statearr_64577_64588 = state_64568__$1;
(statearr_64577_64588[(2)] = inst_64556);

(statearr_64577_64588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64569 === (7))){
var inst_64564 = (state_64568[(2)]);
var state_64568__$1 = state_64568;
var statearr_64578_64589 = state_64568__$1;
(statearr_64578_64589[(2)] = inst_64564);

(statearr_64578_64589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_64579 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64579[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__);

(statearr_64579[(1)] = (1));

return statearr_64579;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1 = (function (state_64568){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64568);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64580){var ex__2730__auto__ = e64580;
var statearr_64581_64590 = state_64568;
(statearr_64581_64590[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64568[(4)]))){
var statearr_64582_64591 = state_64568;
(statearr_64582_64591[(1)] = cljs.core.first((state_64568[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64592 = state_64568;
state_64568 = G__64592;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = function(state_64568){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1.call(this,state_64568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64583 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64583[(6)] = c__2749__auto__);

return statearr_64583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64660){
var state_val_64661 = (state_64660[(1)]);
if((state_val_64661 === (7))){
var inst_64620 = (state_64660[(2)]);
var inst_64621 = fluree.db.util.async.throw_err(inst_64620);
var state_64660__$1 = state_64660;
var statearr_64662_64688 = state_64660__$1;
(statearr_64662_64688[(2)] = inst_64621);

(statearr_64662_64688[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (1))){
var inst_64597 = cljs.core.volatile_BANG_((0));
var inst_64598 = cljs.core.PersistentHashMap.EMPTY;
var inst_64599 = cljs.core.volatile_BANG_(inst_64598);
var inst_64600 = cljs.core.first(resp);
var inst_64601 = cljs.core.rest(resp);
var inst_64602 = cljs.core.PersistentVector.EMPTY;
var inst_64603 = inst_64597;
var inst_64604 = inst_64599;
var inst_64605 = inst_64600;
var inst_64606 = inst_64601;
var inst_64607 = inst_64602;
var state_64660__$1 = (function (){var statearr_64663 = state_64660;
(statearr_64663[(7)] = inst_64603);

(statearr_64663[(8)] = inst_64606);

(statearr_64663[(9)] = inst_64607);

(statearr_64663[(10)] = inst_64604);

(statearr_64663[(11)] = inst_64605);

return statearr_64663;
})();
var statearr_64664_64689 = state_64660__$1;
(statearr_64664_64689[(2)] = null);

(statearr_64664_64689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (4))){
var inst_64609 = (state_64660[(12)]);
var inst_64611 = (state_64660[(13)]);
var inst_64603 = (state_64660[(7)]);
var inst_64606 = (state_64660[(8)]);
var inst_64607 = (state_64660[(9)]);
var inst_64604 = (state_64660[(10)]);
var inst_64605 = (state_64660[(11)]);
var inst_64615 = (function (){var fuel = inst_64603;
var cache = inst_64604;
var curr_block = inst_64605;
var rest_blocks = inst_64606;
var acc = inst_64607;
var flakes = inst_64609;
var asserted = inst_64611;
return (function (p1__64594_SHARP_){
return p1__64594_SHARP_.s;
});
})();
var inst_64616 = cljs.core.group_by(inst_64615,inst_64611);
var inst_64617 = cljs.core.vals(inst_64616);
var inst_64618 = fluree.db.api_js.format_flake_groups_pretty(db,inst_64604,inst_64603,inst_64617);
var state_64660__$1 = state_64660;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64660__$1,(7),inst_64618);
} else {
if((state_val_64661 === (13))){
var inst_64648 = (state_64660[(14)]);
var state_64660__$1 = state_64660;
var statearr_64665_64690 = state_64660__$1;
(statearr_64665_64690[(2)] = inst_64648);

(statearr_64665_64690[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (6))){
var inst_64609 = (state_64660[(12)]);
var inst_64624 = (state_64660[(15)]);
var inst_64611 = (state_64660[(13)]);
var inst_64603 = (state_64660[(7)]);
var inst_64606 = (state_64660[(8)]);
var inst_64607 = (state_64660[(9)]);
var inst_64604 = (state_64660[(10)]);
var inst_64626 = (state_64660[(16)]);
var inst_64605 = (state_64660[(11)]);
var inst_64624__$1 = (state_64660[(2)]);
var inst_64625 = (function (){var fuel = inst_64603;
var cache = inst_64604;
var curr_block = inst_64605;
var rest_blocks = inst_64606;
var acc = inst_64607;
var flakes = inst_64609;
var asserted = inst_64611;
var asserted_SINGLEQUOTE_ = inst_64624__$1;
return (function (p1__64595_SHARP_){
return p1__64595_SHARP_.op === false;
});
})();
var inst_64626__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_64625,inst_64609);
var inst_64627 = cljs.core.empty_QMARK_(inst_64626__$1);
var inst_64628 = (!(inst_64627));
var state_64660__$1 = (function (){var statearr_64668 = state_64660;
(statearr_64668[(15)] = inst_64624__$1);

(statearr_64668[(16)] = inst_64626__$1);

return statearr_64668;
})();
if(inst_64628){
var statearr_64669_64691 = state_64660__$1;
(statearr_64669_64691[(1)] = (8));

} else {
var statearr_64670_64692 = state_64660__$1;
(statearr_64670_64692[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (3))){
var inst_64658 = (state_64660[(2)]);
var state_64660__$1 = state_64660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64660__$1,inst_64658);
} else {
if((state_val_64661 === (12))){
var inst_64603 = (state_64660[(7)]);
var inst_64606 = (state_64660[(8)]);
var inst_64604 = (state_64660[(10)]);
var inst_64648 = (state_64660[(14)]);
var inst_64651 = cljs.core.first(inst_64606);
var inst_64652 = cljs.core.rest(inst_64606);
var tmp64666 = inst_64603;
var tmp64667 = inst_64604;
var inst_64603__$1 = tmp64666;
var inst_64604__$1 = tmp64667;
var inst_64605 = inst_64651;
var inst_64606__$1 = inst_64652;
var inst_64607 = inst_64648;
var state_64660__$1 = (function (){var statearr_64671 = state_64660;
(statearr_64671[(7)] = inst_64603__$1);

(statearr_64671[(8)] = inst_64606__$1);

(statearr_64671[(9)] = inst_64607);

(statearr_64671[(10)] = inst_64604__$1);

(statearr_64671[(11)] = inst_64605);

return statearr_64671;
})();
var statearr_64672_64693 = state_64660__$1;
(statearr_64672_64693[(2)] = null);

(statearr_64672_64693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (2))){
var inst_64609 = (state_64660[(12)]);
var inst_64611 = (state_64660[(13)]);
var inst_64603 = (state_64660[(7)]);
var inst_64606 = (state_64660[(8)]);
var inst_64607 = (state_64660[(9)]);
var inst_64604 = (state_64660[(10)]);
var inst_64605 = (state_64660[(11)]);
var inst_64609__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_64605);
var inst_64610 = (function (){var fuel = inst_64603;
var cache = inst_64604;
var curr_block = inst_64605;
var rest_blocks = inst_64606;
var acc = inst_64607;
var flakes = inst_64609__$1;
return (function (p1__64593_SHARP_){
return p1__64593_SHARP_.op;
});
})();
var inst_64611__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_64610,inst_64609__$1);
var inst_64612 = cljs.core.empty_QMARK_(inst_64611__$1);
var inst_64613 = (!(inst_64612));
var state_64660__$1 = (function (){var statearr_64673 = state_64660;
(statearr_64673[(12)] = inst_64609__$1);

(statearr_64673[(13)] = inst_64611__$1);

return statearr_64673;
})();
if(inst_64613){
var statearr_64674_64694 = state_64660__$1;
(statearr_64674_64694[(1)] = (4));

} else {
var statearr_64675_64695 = state_64660__$1;
(statearr_64675_64695[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (11))){
var inst_64636 = (state_64660[(2)]);
var inst_64637 = fluree.db.util.async.throw_err(inst_64636);
var state_64660__$1 = state_64660;
var statearr_64676_64696 = state_64660__$1;
(statearr_64676_64696[(2)] = inst_64637);

(statearr_64676_64696[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (9))){
var state_64660__$1 = state_64660;
var statearr_64677_64697 = state_64660__$1;
(statearr_64677_64697[(2)] = null);

(statearr_64677_64697[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (5))){
var state_64660__$1 = state_64660;
var statearr_64678_64698 = state_64660__$1;
(statearr_64678_64698[(2)] = null);

(statearr_64678_64698[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (14))){
var inst_64656 = (state_64660[(2)]);
var state_64660__$1 = state_64660;
var statearr_64679_64699 = state_64660__$1;
(statearr_64679_64699[(2)] = inst_64656);

(statearr_64679_64699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (10))){
var inst_64624 = (state_64660[(15)]);
var inst_64606 = (state_64660[(8)]);
var inst_64607 = (state_64660[(9)]);
var inst_64605 = (state_64660[(11)]);
var inst_64640 = (state_64660[(2)]);
var inst_64641 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_64642 = [inst_64624,inst_64640];
var inst_64643 = cljs.core.PersistentHashMap.fromArrays(inst_64641,inst_64642);
var inst_64644 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64605,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_64643);
var inst_64645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64646 = [inst_64644];
var inst_64647 = (new cljs.core.PersistentVector(null,1,(5),inst_64645,inst_64646,null));
var inst_64648 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_64607,inst_64647);
var inst_64649 = cljs.core.first(inst_64606);
var state_64660__$1 = (function (){var statearr_64680 = state_64660;
(statearr_64680[(14)] = inst_64648);

return statearr_64680;
})();
if(cljs.core.truth_(inst_64649)){
var statearr_64681_64700 = state_64660__$1;
(statearr_64681_64700[(1)] = (12));

} else {
var statearr_64682_64701 = state_64660__$1;
(statearr_64682_64701[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64661 === (8))){
var inst_64609 = (state_64660[(12)]);
var inst_64624 = (state_64660[(15)]);
var inst_64611 = (state_64660[(13)]);
var inst_64603 = (state_64660[(7)]);
var inst_64606 = (state_64660[(8)]);
var inst_64607 = (state_64660[(9)]);
var inst_64604 = (state_64660[(10)]);
var inst_64626 = (state_64660[(16)]);
var inst_64605 = (state_64660[(11)]);
var inst_64630 = (function (){var flakes = inst_64609;
var rest_blocks = inst_64606;
var curr_block = inst_64605;
var asserted_SINGLEQUOTE_ = inst_64624;
var acc = inst_64607;
var fuel = inst_64603;
var cache = inst_64604;
var retracted = inst_64626;
var asserted = inst_64611;
return (function (p1__64596_SHARP_){
return p1__64596_SHARP_.s;
});
})();
var inst_64631 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_64626);
var inst_64632 = cljs.core.group_by(inst_64630,inst_64631);
var inst_64633 = cljs.core.vals(inst_64632);
var inst_64634 = fluree.db.api_js.format_flake_groups_pretty(db,inst_64604,inst_64603,inst_64633);
var state_64660__$1 = state_64660;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64660__$1,(11),inst_64634);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_64683 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64683[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_64683[(1)] = (1));

return statearr_64683;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_64660){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64660);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64684){var ex__2730__auto__ = e64684;
var statearr_64685_64702 = state_64660;
(statearr_64685_64702[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64660[(4)]))){
var statearr_64686_64703 = state_64660;
(statearr_64686_64703[(1)] = cljs.core.first((state_64660[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64704 = state_64660;
state_64660 = G__64704;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_64660){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_64660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64687 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64687[(6)] = c__2749__auto__);

return statearr_64687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64804){
var state_val_64805 = (state_64804[(1)]);
if((state_val_64805 === (7))){
var inst_64769 = (state_64804[(7)]);
var inst_64776 = (state_64804[(8)]);
var inst_64775 = cljs.core.seq(inst_64769);
var inst_64776__$1 = cljs.core.first(inst_64775);
var inst_64777 = cljs.core.next(inst_64775);
var state_64804__$1 = (function (){var statearr_64806 = state_64804;
(statearr_64806[(8)] = inst_64776__$1);

(statearr_64806[(9)] = inst_64777);

return statearr_64806;
})();
if(cljs.core.truth_(inst_64776__$1)){
var statearr_64807_64844 = state_64804__$1;
(statearr_64807_64844[(1)] = (9));

} else {
var statearr_64808_64845 = state_64804__$1;
(statearr_64808_64845[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64805 === (1))){
var state_64804__$1 = state_64804;
var statearr_64809_64846 = state_64804__$1;
(statearr_64809_64846[(2)] = null);

(statearr_64809_64846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64805 === (4))){
var inst_64706 = (state_64804[(2)]);
var state_64804__$1 = state_64804;
var statearr_64810_64847 = state_64804__$1;
(statearr_64810_64847[(2)] = inst_64706);

(statearr_64810_64847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64805 === (6))){
var inst_64755 = (state_64804[(2)]);
var inst_64756 = fluree.db.util.async.throw_err(inst_64755);
var inst_64764 = resp;
var inst_64765 = cljs.core.seq(inst_64764);
var inst_64766 = cljs.core.first(inst_64765);
var inst_64767 = cljs.core.next(inst_64765);
var inst_64768 = cljs.core.PersistentHashMap.EMPTY;
var inst_64769 = inst_64764;
var inst_64770 = inst_64768;
var state_64804__$1 = (function (){var statearr_64811 = state_64804;
(statearr_64811[(10)] = inst_64756);

(statearr_64811[(11)] = inst_64766);

(statearr_64811[(7)] = inst_64769);

(statearr_64811[(12)] = inst_64767);

(statearr_64811[(13)] = inst_64770);

return statearr_64811;
})();
var statearr_64812_64848 = state_64804__$1;
(statearr_64812_64848[(2)] = null);

(statearr_64812_64848[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64805 === (3))){
var inst_64802 = (state_64804[(2)]);
var state_64804__$1 = state_64804;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64804__$1,inst_64802);
} else {
if((state_val_64805 === (2))){
var _ = (function (){var statearr_64813 = state_64804;
(statearr_64813[(4)] = cljs.core.cons((5),(state_64804[(4)])));

return statearr_64813;
})();
var inst_64712 = (function (){return (function (p1__64705_SHARP_){
return p1__64705_SHARP_.t;
});
})();
var inst_64713 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_64712,resp);
var inst_64714 = cljs.core.set(inst_64713);
var inst_64751 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_64752 = (function (){var ts = inst_64714;
var c__2749__auto____$1 = inst_64751;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64749){
var state_val_64750 = (state_64749[(1)]);
if((state_val_64750 === (1))){
var inst_64722 = ts;
var inst_64723 = cljs.core.seq(inst_64722);
var inst_64724 = cljs.core.first(inst_64723);
var inst_64725 = cljs.core.next(inst_64723);
var inst_64726 = cljs.core.PersistentHashMap.EMPTY;
var inst_64727 = inst_64722;
var inst_64728 = inst_64726;
var state_64749__$1 = (function (){var statearr_64814 = state_64749;
(statearr_64814[(7)] = inst_64728);

(statearr_64814[(8)] = inst_64724);

(statearr_64814[(9)] = inst_64727);

(statearr_64814[(10)] = inst_64725);

return statearr_64814;
})();
var statearr_64815_64849 = state_64749__$1;
(statearr_64815_64849[(2)] = null);

(statearr_64815_64849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64750 === (2))){
var inst_64734 = (state_64749[(11)]);
var inst_64727 = (state_64749[(9)]);
var inst_64733 = cljs.core.seq(inst_64727);
var inst_64734__$1 = cljs.core.first(inst_64733);
var inst_64735 = cljs.core.next(inst_64733);
var state_64749__$1 = (function (){var statearr_64816 = state_64749;
(statearr_64816[(11)] = inst_64734__$1);

(statearr_64816[(12)] = inst_64735);

return statearr_64816;
})();
if(cljs.core.truth_(inst_64734__$1)){
var statearr_64817_64850 = state_64749__$1;
(statearr_64817_64850[(1)] = (4));

} else {
var statearr_64818_64851 = state_64749__$1;
(statearr_64818_64851[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64750 === (3))){
var inst_64747 = (state_64749[(2)]);
var state_64749__$1 = state_64749;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64749__$1,inst_64747);
} else {
if((state_val_64750 === (4))){
var inst_64734 = (state_64749[(11)]);
var inst_64737 = fluree.db.time_travel.non_border_t_to_block(db,inst_64734);
var state_64749__$1 = state_64749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64749__$1,(7),inst_64737);
} else {
if((state_val_64750 === (5))){
var inst_64728 = (state_64749[(7)]);
var state_64749__$1 = state_64749;
var statearr_64819_64852 = state_64749__$1;
(statearr_64819_64852[(2)] = inst_64728);

(statearr_64819_64852[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64750 === (6))){
var inst_64745 = (state_64749[(2)]);
var state_64749__$1 = state_64749;
var statearr_64820_64853 = state_64749__$1;
(statearr_64820_64853[(2)] = inst_64745);

(statearr_64820_64853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64750 === (7))){
var inst_64734 = (state_64749[(11)]);
var inst_64728 = (state_64749[(7)]);
var inst_64735 = (state_64749[(12)]);
var inst_64739 = (state_64749[(2)]);
var inst_64740 = fluree.db.util.async.throw_err(inst_64739);
var inst_64741 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64728,inst_64734,inst_64740);
var inst_64727 = inst_64735;
var inst_64728__$1 = inst_64741;
var state_64749__$1 = (function (){var statearr_64821 = state_64749;
(statearr_64821[(7)] = inst_64728__$1);

(statearr_64821[(9)] = inst_64727);

return statearr_64821;
})();
var statearr_64822_64854 = state_64749__$1;
(statearr_64822_64854[(2)] = null);

(statearr_64822_64854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_64823 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64823[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_64823[(1)] = (1));

return statearr_64823;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_64749){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64749);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64824){var ex__2730__auto__ = e64824;
var statearr_64825_64855 = state_64749;
(statearr_64825_64855[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64749[(4)]))){
var statearr_64826_64856 = state_64749;
(statearr_64826_64856[(1)] = cljs.core.first((state_64749[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64857 = state_64749;
state_64749 = G__64857;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_64749){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_64749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64827 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64827[(6)] = c__2749__auto____$1);

return statearr_64827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_64753 = cljs.core.async.impl.dispatch.run(inst_64752);
var state_64804__$1 = (function (){var statearr_64828 = state_64804;
(statearr_64828[(14)] = inst_64753);

return statearr_64828;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64804__$1,(6),inst_64751);
} else {
if((state_val_64805 === (11))){
var inst_64796 = (state_64804[(2)]);
var state_64804__$1 = state_64804;
var statearr_64830_64858 = state_64804__$1;
(statearr_64830_64858[(2)] = inst_64796);

(statearr_64830_64858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64805 === (9))){
var inst_64756 = (state_64804[(10)]);
var inst_64776 = (state_64804[(8)]);
var inst_64770 = (state_64804[(13)]);
var inst_64777 = (state_64804[(9)]);
var inst_64779 = inst_64776.t;
var inst_64780 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64756,inst_64779);
var inst_64781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64782 = [inst_64780,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64783 = (new cljs.core.PersistentVector(null,2,(5),inst_64781,inst_64782,null));
var inst_64784 = cljs.core.assoc_in(inst_64770,inst_64783,inst_64780);
var inst_64785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64786 = [inst_64780,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_64787 = (new cljs.core.PersistentVector(null,2,(5),inst_64785,inst_64786,null));
var inst_64788 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_64784,inst_64787,cljs.core.conj,inst_64776);
var inst_64789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64790 = [inst_64780,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_64791 = (new cljs.core.PersistentVector(null,2,(5),inst_64789,inst_64790,null));
var inst_64792 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_64788,inst_64791,fluree.db.api_js.min_safe,inst_64779);
var inst_64769 = inst_64777;
var inst_64770__$1 = inst_64792;
var state_64804__$1 = (function (){var statearr_64831 = state_64804;
(statearr_64831[(7)] = inst_64769);

(statearr_64831[(13)] = inst_64770__$1);

return statearr_64831;
})();
var statearr_64832_64859 = state_64804__$1;
(statearr_64832_64859[(2)] = null);

(statearr_64832_64859[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64805 === (5))){
var _ = (function (){var statearr_64833 = state_64804;
(statearr_64833[(4)] = cljs.core.rest((state_64804[(4)])));

return statearr_64833;
})();
var state_64804__$1 = state_64804;
var ex64829 = (state_64804__$1[(2)]);
var statearr_64834_64860 = state_64804__$1;
(statearr_64834_64860[(5)] = ex64829);


if((ex64829 instanceof Error)){
var statearr_64835_64861 = state_64804__$1;
(statearr_64835_64861[(1)] = (4));

(statearr_64835_64861[(5)] = null);

} else {
throw ex64829;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64805 === (10))){
var inst_64770 = (state_64804[(13)]);
var state_64804__$1 = state_64804;
var statearr_64836_64862 = state_64804__$1;
(statearr_64836_64862[(2)] = inst_64770);

(statearr_64836_64862[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64805 === (8))){
var inst_64798 = (state_64804[(2)]);
var inst_64799 = cljs.core.vals(inst_64798);
var _ = (function (){var statearr_64837 = state_64804;
(statearr_64837[(4)] = cljs.core.rest((state_64804[(4)])));

return statearr_64837;
})();
var state_64804__$1 = state_64804;
var statearr_64838_64863 = state_64804__$1;
(statearr_64838_64863[(2)] = inst_64799);

(statearr_64838_64863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_64839 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64839[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_64839[(1)] = (1));

return statearr_64839;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_64804){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64804);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64840){var ex__2730__auto__ = e64840;
var statearr_64841_64864 = state_64804;
(statearr_64841_64864[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64804[(4)]))){
var statearr_64842_64865 = state_64804;
(statearr_64842_64865[(1)] = cljs.core.first((state_64804[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64866 = state_64804;
state_64804 = G__64866;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_64804){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_64804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64843 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64843[(6)] = c__2749__auto__);

return statearr_64843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65011){
var state_val_65012 = (state_65011[(1)]);
if((state_val_65012 === (7))){
var inst_64891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64892 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64893 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64894 = [inst_64892,inst_64893];
var inst_64895 = (new cljs.core.PersistentVector(null,2,(5),inst_64891,inst_64894,null));
var state_65011__$1 = state_65011;
var statearr_65013_65084 = state_65011__$1;
(statearr_65013_65084[(2)] = inst_64895);

(statearr_65013_65084[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (20))){
var inst_64921 = (state_65011[(7)]);
var state_65011__$1 = state_65011;
var statearr_65014_65085 = state_65011__$1;
(statearr_65014_65085[(2)] = inst_64921);

(statearr_65014_65085[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (27))){
var state_65011__$1 = state_65011;
var statearr_65015_65086 = state_65011__$1;
(statearr_65015_65086[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (1))){
var state_65011__$1 = state_65011;
var statearr_65017_65087 = state_65011__$1;
(statearr_65017_65087[(2)] = null);

(statearr_65017_65087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (24))){
var inst_64920 = (state_65011[(8)]);
var state_65011__$1 = state_65011;
if(cljs.core.truth_(inst_64920)){
var statearr_65018_65088 = state_65011__$1;
(statearr_65018_65088[(1)] = (26));

} else {
var statearr_65019_65089 = state_65011__$1;
(statearr_65019_65089[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (39))){
var inst_64966 = (state_65011[(9)]);
var inst_64967 = (state_65011[(10)]);
var inst_64992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64993 = [inst_64966,inst_64967];
var inst_64994 = (new cljs.core.PersistentVector(null,2,(5),inst_64992,inst_64993,null));
var state_65011__$1 = state_65011;
var statearr_65020_65090 = state_65011__$1;
(statearr_65020_65090[(2)] = inst_64994);

(statearr_65020_65090[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (4))){
var inst_64867 = (state_65011[(2)]);
var inst_64868 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64867], 0));
var inst_64869 = cljs.core.ex_data(inst_64867);
var inst_64870 = cljs.core.ex_message(inst_64867);
var inst_64871 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64869,new cljs.core.Keyword(null,"message","message",-406056002),inst_64870);
var state_65011__$1 = (function (){var statearr_65021 = state_65011;
(statearr_65021[(11)] = inst_64868);

return statearr_65021;
})();
var statearr_65022_65091 = state_65011__$1;
(statearr_65022_65091[(2)] = inst_64871);

(statearr_65022_65091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (15))){
var inst_64905 = (state_65011[(12)]);
var inst_64900 = (state_65011[(13)]);
var inst_64914 = (state_65011[(2)]);
var inst_64915 = [inst_64905,inst_64914];
var inst_64916 = (new cljs.core.PersistentVector(null,2,(5),inst_64900,inst_64915,null));
var state_65011__$1 = state_65011;
var statearr_65023_65092 = state_65011__$1;
(statearr_65023_65092[(2)] = inst_64916);

(statearr_65023_65092[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (21))){
var inst_64920 = (state_65011[(8)]);
var state_65011__$1 = state_65011;
var statearr_65024_65093 = state_65011__$1;
(statearr_65024_65093[(2)] = inst_64920);

(statearr_65024_65093[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (31))){
var inst_64961 = (state_65011[(2)]);
var state_65011__$1 = state_65011;
var statearr_65025_65094 = state_65011__$1;
(statearr_65025_65094[(2)] = inst_64961);

(statearr_65025_65094[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (32))){
var inst_64967 = (state_65011[(10)]);
var inst_64970 = cljs.core.pos_int_QMARK_(inst_64967);
var state_65011__$1 = state_65011;
var statearr_65026_65095 = state_65011__$1;
(statearr_65026_65095[(2)] = inst_64970);

(statearr_65026_65095[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (40))){
var inst_64922 = (state_65011[(14)]);
var inst_64998 = (state_65011[(15)]);
var inst_64996 = (state_65011[(2)]);
var inst_64997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64996,(0),null);
var inst_64998__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64996,(1),null);
var inst_64999 = (inst_64998__$1 > inst_64922);
var state_65011__$1 = (function (){var statearr_65027 = state_65011;
(statearr_65027[(16)] = inst_64997);

(statearr_65027[(15)] = inst_64998__$1);

return statearr_65027;
})();
if(cljs.core.truth_(inst_64999)){
var statearr_65028_65096 = state_65011__$1;
(statearr_65028_65096[(1)] = (41));

} else {
var statearr_65029_65097 = state_65011__$1;
(statearr_65029_65097[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (33))){
var inst_64968 = (state_65011[(17)]);
var state_65011__$1 = state_65011;
var statearr_65030_65098 = state_65011__$1;
(statearr_65030_65098[(2)] = inst_64968);

(statearr_65030_65098[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (13))){
var inst_64906 = (state_65011[(18)]);
var inst_64908 = fluree.db.time_travel.block_to_int_format(db,inst_64906);
var state_65011__$1 = state_65011;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65011__$1,(16),inst_64908);
} else {
if((state_val_65012 === (22))){
var inst_64939 = (state_65011[(2)]);
var state_65011__$1 = state_65011;
if(cljs.core.truth_(inst_64939)){
var statearr_65031_65099 = state_65011__$1;
(statearr_65031_65099[(1)] = (23));

} else {
var statearr_65032_65100 = state_65011__$1;
(statearr_65032_65100[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (36))){
var state_65011__$1 = state_65011;
var statearr_65033_65101 = state_65011__$1;
(statearr_65033_65101[(2)] = null);

(statearr_65033_65101[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (41))){
var inst_64922 = (state_65011[(14)]);
var state_65011__$1 = state_65011;
var statearr_65034_65102 = state_65011__$1;
(statearr_65034_65102[(2)] = inst_64922);

(statearr_65034_65102[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (43))){
var inst_64997 = (state_65011[(16)]);
var inst_65003 = (state_65011[(2)]);
var inst_65004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65005 = [inst_64997,inst_65003];
var inst_65006 = (new cljs.core.PersistentVector(null,2,(5),inst_65004,inst_65005,null));
var _ = (function (){var statearr_65035 = state_65011;
(statearr_65035[(4)] = cljs.core.rest((state_65011[(4)])));

return statearr_65035;
})();
var state_65011__$1 = state_65011;
var statearr_65036_65103 = state_65011__$1;
(statearr_65036_65103[(2)] = inst_65006);

(statearr_65036_65103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (29))){
var inst_64897 = (state_65011[(19)]);
var inst_64952 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64897], 0));
var inst_64953 = ["Invalid block range provided: ",inst_64952].join('');
var inst_64954 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64955 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64956 = cljs.core.PersistentHashMap.fromArrays(inst_64954,inst_64955);
var inst_64957 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64953,inst_64956);
var inst_64958 = (function(){throw inst_64957})();
var state_65011__$1 = state_65011;
var statearr_65037_65104 = state_65011__$1;
(statearr_65037_65104[(2)] = inst_64958);

(statearr_65037_65104[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (6))){
var inst_64889 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65011__$1 = state_65011;
var statearr_65038_65105 = state_65011__$1;
(statearr_65038_65105[(2)] = inst_64889);

(statearr_65038_65105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (28))){
var inst_64963 = (state_65011[(2)]);
var state_65011__$1 = state_65011;
var statearr_65039_65106 = state_65011__$1;
(statearr_65039_65106[(2)] = inst_64963);

(statearr_65039_65106[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (25))){
var inst_64966 = (state_65011[(9)]);
var inst_64968 = (state_65011[(17)]);
var inst_64965 = (state_65011[(2)]);
var inst_64966__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64965,(0),null);
var inst_64967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64965,(1),null);
var inst_64968__$1 = cljs.core.pos_int_QMARK_(inst_64966__$1);
var state_65011__$1 = (function (){var statearr_65040 = state_65011;
(statearr_65040[(9)] = inst_64966__$1);

(statearr_65040[(17)] = inst_64968__$1);

(statearr_65040[(10)] = inst_64967);

return statearr_65040;
})();
if(inst_64968__$1){
var statearr_65041_65107 = state_65011__$1;
(statearr_65041_65107[(1)] = (32));

} else {
var statearr_65042_65108 = state_65011__$1;
(statearr_65042_65108[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (34))){
var inst_64973 = (state_65011[(2)]);
var inst_64974 = cljs.core.not(inst_64973);
var state_65011__$1 = state_65011;
if(inst_64974){
var statearr_65043_65109 = state_65011__$1;
(statearr_65043_65109[(1)] = (35));

} else {
var statearr_65044_65110 = state_65011__$1;
(statearr_65044_65110[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (17))){
var inst_64920 = (state_65011[(8)]);
var inst_64922 = (state_65011[(14)]);
var inst_64925 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64920], 0));
var inst_64926 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64922], 0));
var inst_64927 = ["Start block is out of range for this ledger. Start block provided: ",inst_64925,". Database block: ",inst_64926].join('');
var inst_64928 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64929 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64930 = cljs.core.PersistentHashMap.fromArrays(inst_64928,inst_64929);
var inst_64931 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64927,inst_64930);
var inst_64932 = (function(){throw inst_64931})();
var state_65011__$1 = state_65011;
var statearr_65045_65111 = state_65011__$1;
(statearr_65045_65111[(2)] = inst_64932);

(statearr_65045_65111[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (3))){
var inst_65009 = (state_65011[(2)]);
var state_65011__$1 = state_65011;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65011__$1,inst_65009);
} else {
if((state_val_65012 === (12))){
var inst_64906 = (state_65011[(18)]);
var inst_64897 = (state_65011[(19)]);
var inst_64904 = (state_65011[(2)]);
var inst_64905 = fluree.db.util.async.throw_err(inst_64904);
var inst_64906__$1 = cljs.core.second(inst_64897);
var state_65011__$1 = (function (){var statearr_65046 = state_65011;
(statearr_65046[(12)] = inst_64905);

(statearr_65046[(18)] = inst_64906__$1);

return statearr_65046;
})();
if(cljs.core.truth_(inst_64906__$1)){
var statearr_65047_65112 = state_65011__$1;
(statearr_65047_65112[(1)] = (13));

} else {
var statearr_65048_65113 = state_65011__$1;
(statearr_65048_65113[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (2))){
var _ = (function (){var statearr_65049 = state_65011;
(statearr_65049[(4)] = cljs.core.cons((5),(state_65011[(4)])));

return statearr_65049;
})();
var inst_64886 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64887 = cljs.core.sequential_QMARK_(inst_64886);
var state_65011__$1 = state_65011;
if(inst_64887){
var statearr_65050_65114 = state_65011__$1;
(statearr_65050_65114[(1)] = (6));

} else {
var statearr_65051_65115 = state_65011__$1;
(statearr_65051_65115[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (23))){
var inst_64920 = (state_65011[(8)]);
var inst_64921 = (state_65011[(7)]);
var inst_64941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64942 = [inst_64920,inst_64921];
var inst_64943 = (new cljs.core.PersistentVector(null,2,(5),inst_64941,inst_64942,null));
var state_65011__$1 = state_65011;
var statearr_65052_65116 = state_65011__$1;
(statearr_65052_65116[(2)] = inst_64943);

(statearr_65052_65116[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (35))){
var inst_64897 = (state_65011[(19)]);
var inst_64976 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64897], 0));
var inst_64977 = ["Invalid block range provided: ",inst_64976].join('');
var inst_64978 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64979 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64980 = cljs.core.PersistentHashMap.fromArrays(inst_64978,inst_64979);
var inst_64981 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64977,inst_64980);
var inst_64982 = (function(){throw inst_64981})();
var state_65011__$1 = state_65011;
var statearr_65053_65117 = state_65011__$1;
(statearr_65053_65117[(2)] = inst_64982);

(statearr_65053_65117[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (19))){
var inst_64920 = (state_65011[(8)]);
var inst_64935 = (state_65011[(2)]);
var state_65011__$1 = (function (){var statearr_65054 = state_65011;
(statearr_65054[(20)] = inst_64935);

return statearr_65054;
})();
if(cljs.core.truth_(inst_64920)){
var statearr_65055_65118 = state_65011__$1;
(statearr_65055_65118[(1)] = (20));

} else {
var statearr_65056_65119 = state_65011__$1;
(statearr_65056_65119[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (11))){
var inst_64920 = (state_65011[(8)]);
var inst_64922 = (state_65011[(14)]);
var inst_64919 = (state_65011[(2)]);
var inst_64920__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64919,(0),null);
var inst_64921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64919,(1),null);
var inst_64922__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64923 = (inst_64920__$1 > inst_64922__$1);
var state_65011__$1 = (function (){var statearr_65058 = state_65011;
(statearr_65058[(8)] = inst_64920__$1);

(statearr_65058[(14)] = inst_64922__$1);

(statearr_65058[(7)] = inst_64921);

return statearr_65058;
})();
if(cljs.core.truth_(inst_64923)){
var statearr_65059_65120 = state_65011__$1;
(statearr_65059_65120[(1)] = (17));

} else {
var statearr_65060_65121 = state_65011__$1;
(statearr_65060_65121[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (9))){
var inst_64897 = (state_65011[(19)]);
var inst_64900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64901 = cljs.core.first(inst_64897);
var inst_64902 = fluree.db.time_travel.block_to_int_format(db,inst_64901);
var state_65011__$1 = (function (){var statearr_65061 = state_65011;
(statearr_65061[(13)] = inst_64900);

return statearr_65061;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65011__$1,(12),inst_64902);
} else {
if((state_val_65012 === (5))){
var _ = (function (){var statearr_65062 = state_65011;
(statearr_65062[(4)] = cljs.core.rest((state_65011[(4)])));

return statearr_65062;
})();
var state_65011__$1 = state_65011;
var ex65057 = (state_65011__$1[(2)]);
var statearr_65063_65122 = state_65011__$1;
(statearr_65063_65122[(5)] = ex65057);


var statearr_65064_65123 = state_65011__$1;
(statearr_65064_65123[(1)] = (4));

(statearr_65064_65123[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (14))){
var state_65011__$1 = state_65011;
var statearr_65065_65124 = state_65011__$1;
(statearr_65065_65124[(2)] = null);

(statearr_65065_65124[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (26))){
var inst_64920 = (state_65011[(8)]);
var inst_64946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64947 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64948 = [inst_64920,inst_64947];
var inst_64949 = (new cljs.core.PersistentVector(null,2,(5),inst_64946,inst_64948,null));
var state_65011__$1 = state_65011;
var statearr_65066_65125 = state_65011__$1;
(statearr_65066_65125[(2)] = inst_64949);

(statearr_65066_65125[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (16))){
var inst_64910 = (state_65011[(2)]);
var inst_64911 = fluree.db.util.async.throw_err(inst_64910);
var state_65011__$1 = state_65011;
var statearr_65067_65126 = state_65011__$1;
(statearr_65067_65126[(2)] = inst_64911);

(statearr_65067_65126[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (38))){
var inst_64966 = (state_65011[(9)]);
var inst_64967 = (state_65011[(10)]);
var inst_64988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64989 = [inst_64967,inst_64966];
var inst_64990 = (new cljs.core.PersistentVector(null,2,(5),inst_64988,inst_64989,null));
var state_65011__$1 = state_65011;
var statearr_65068_65127 = state_65011__$1;
(statearr_65068_65127[(2)] = inst_64990);

(statearr_65068_65127[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (30))){
var state_65011__$1 = state_65011;
var statearr_65069_65128 = state_65011__$1;
(statearr_65069_65128[(2)] = null);

(statearr_65069_65128[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (10))){
var inst_64897 = (state_65011[(19)]);
var state_65011__$1 = state_65011;
var statearr_65070_65129 = state_65011__$1;
(statearr_65070_65129[(2)] = inst_64897);

(statearr_65070_65129[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (18))){
var state_65011__$1 = state_65011;
var statearr_65071_65130 = state_65011__$1;
(statearr_65071_65130[(2)] = null);

(statearr_65071_65130[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (42))){
var inst_64998 = (state_65011[(15)]);
var state_65011__$1 = state_65011;
var statearr_65072_65131 = state_65011__$1;
(statearr_65072_65131[(2)] = inst_64998);

(statearr_65072_65131[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (37))){
var inst_64966 = (state_65011[(9)]);
var inst_64967 = (state_65011[(10)]);
var inst_64985 = (state_65011[(2)]);
var inst_64986 = (inst_64967 < inst_64966);
var state_65011__$1 = (function (){var statearr_65073 = state_65011;
(statearr_65073[(21)] = inst_64985);

return statearr_65073;
})();
if(cljs.core.truth_(inst_64986)){
var statearr_65074_65132 = state_65011__$1;
(statearr_65074_65132[(1)] = (38));

} else {
var statearr_65075_65133 = state_65011__$1;
(statearr_65075_65133[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65012 === (8))){
var inst_64897 = (state_65011[(19)]);
var inst_64897__$1 = (state_65011[(2)]);
var inst_64898 = cljs.core.some(cljs.core.string_QMARK_,inst_64897__$1);
var state_65011__$1 = (function (){var statearr_65076 = state_65011;
(statearr_65076[(19)] = inst_64897__$1);

return statearr_65076;
})();
if(cljs.core.truth_(inst_64898)){
var statearr_65077_65134 = state_65011__$1;
(statearr_65077_65134[(1)] = (9));

} else {
var statearr_65078_65135 = state_65011__$1;
(statearr_65078_65135[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_65079 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65079[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__);

(statearr_65079[(1)] = (1));

return statearr_65079;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_65011){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65011);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65080){var ex__2730__auto__ = e65080;
var statearr_65081_65136 = state_65011;
(statearr_65081_65136[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65011[(4)]))){
var statearr_65082_65137 = state_65011;
(statearr_65082_65137[(1)] = cljs.core.first((state_65011[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65138 = state_65011;
state_65011 = G__65138;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = function(state_65011){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_65011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65083 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65083[(6)] = c__2749__auto__);

return statearr_65083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__65140 = arguments.length;
switch (G__65140) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65231){
var state_val_65232 = (state_65231[(1)]);
if((state_val_65232 === (7))){
var inst_65163 = (state_65231[(7)]);
var inst_65166 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_65163);
var state_65231__$1 = state_65231;
var statearr_65233_65284 = state_65231__$1;
(statearr_65233_65284[(2)] = inst_65166);

(statearr_65233_65284[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (20))){
var inst_65202 = (state_65231[(8)]);
var inst_65205 = fluree.db.api_js.format_block_resp_pretty(db,inst_65202);
var state_65231__$1 = state_65231;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65231__$1,(23),inst_65205);
} else {
if((state_val_65232 === (27))){
var inst_65211 = (state_65231[(9)]);
var inst_65217 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_65211);
var state_65231__$1 = state_65231;
var statearr_65234_65285 = state_65231__$1;
(statearr_65234_65285[(2)] = inst_65217);

(statearr_65234_65285[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (1))){
var state_65231__$1 = state_65231;
var statearr_65235_65286 = state_65231__$1;
(statearr_65235_65286[(2)] = null);

(statearr_65235_65286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (24))){
var inst_65211 = (state_65231[(9)]);
var inst_65214 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_65215 = cljs.core.sequential_QMARK_(inst_65211);
var state_65231__$1 = (function (){var statearr_65236 = state_65231;
(statearr_65236[(10)] = inst_65214);

return statearr_65236;
})();
if(inst_65215){
var statearr_65237_65287 = state_65231__$1;
(statearr_65237_65287[(1)] = (27));

} else {
var statearr_65238_65288 = state_65231__$1;
(statearr_65238_65288[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (4))){
var inst_65141 = (state_65231[(2)]);
var inst_65142 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65141], 0));
var inst_65143 = cljs.core.ex_data(inst_65141);
var inst_65144 = cljs.core.ex_message(inst_65141);
var inst_65145 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65143,new cljs.core.Keyword(null,"message","message",-406056002),inst_65144);
var state_65231__$1 = (function (){var statearr_65239 = state_65231;
(statearr_65239[(11)] = inst_65142);

return statearr_65239;
})();
var statearr_65240_65289 = state_65231__$1;
(statearr_65240_65289[(2)] = inst_65145);

(statearr_65240_65289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (15))){
var inst_65163 = (state_65231[(7)]);
var inst_65176 = (state_65231[(2)]);
var inst_65177 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65176,inst_65163);
var inst_65178 = (function(){throw inst_65177})();
var state_65231__$1 = state_65231;
var statearr_65241_65290 = state_65231__$1;
(statearr_65241_65290[(2)] = inst_65178);

(statearr_65241_65290[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (21))){
var inst_65202 = (state_65231[(8)]);
var state_65231__$1 = state_65231;
var statearr_65242_65291 = state_65231__$1;
(statearr_65242_65291[(2)] = inst_65202);

(statearr_65242_65291[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (13))){
var inst_65171 = (state_65231[(12)]);
var state_65231__$1 = state_65231;
var statearr_65243_65292 = state_65231__$1;
(statearr_65243_65292[(2)] = inst_65171);

(statearr_65243_65292[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (22))){
var inst_65211 = (state_65231[(2)]);
var inst_65212 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65231__$1 = (function (){var statearr_65244 = state_65231;
(statearr_65244[(9)] = inst_65211);

return statearr_65244;
})();
if(cljs.core.truth_(inst_65212)){
var statearr_65245_65293 = state_65231__$1;
(statearr_65245_65293[(1)] = (24));

} else {
var statearr_65246_65294 = state_65231__$1;
(statearr_65246_65294[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (29))){
var inst_65155 = (state_65231[(13)]);
var inst_65214 = (state_65231[(10)]);
var inst_65220 = (state_65231[(2)]);
var inst_65221 = fluree.db.util.core.response_time_formatted(inst_65155);
var inst_65222 = [(200),inst_65220,(100),inst_65221];
var inst_65223 = cljs.core.PersistentHashMap.fromArrays(inst_65214,inst_65222);
var state_65231__$1 = state_65231;
var statearr_65247_65295 = state_65231__$1;
(statearr_65247_65295[(2)] = inst_65223);

(statearr_65247_65295[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (6))){
var inst_65163 = (state_65231[(7)]);
var inst_65164 = (state_65231[(14)]);
var inst_65162 = (state_65231[(2)]);
var inst_65163__$1 = fluree.db.util.async.throw_err(inst_65162);
var inst_65164__$1 = cljs.core.map_QMARK_(inst_65163__$1);
var state_65231__$1 = (function (){var statearr_65248 = state_65231;
(statearr_65248[(7)] = inst_65163__$1);

(statearr_65248[(14)] = inst_65164__$1);

return statearr_65248;
})();
if(inst_65164__$1){
var statearr_65249_65296 = state_65231__$1;
(statearr_65249_65296[(1)] = (7));

} else {
var statearr_65250_65297 = state_65231__$1;
(statearr_65250_65297[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (28))){
var inst_65211 = (state_65231[(9)]);
var state_65231__$1 = state_65231;
var statearr_65251_65298 = state_65231__$1;
(statearr_65251_65298[(2)] = inst_65211);

(statearr_65251_65298[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (25))){
var inst_65211 = (state_65231[(9)]);
var state_65231__$1 = state_65231;
var statearr_65252_65299 = state_65231__$1;
(statearr_65252_65299[(2)] = inst_65211);

(statearr_65252_65299[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (17))){
var inst_65194 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_65195 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_65194].join('');
var inst_65196 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65197 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65198 = cljs.core.PersistentHashMap.fromArrays(inst_65196,inst_65197);
var inst_65199 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65195,inst_65198);
var inst_65200 = (function(){throw inst_65199})();
var state_65231__$1 = state_65231;
var statearr_65253_65300 = state_65231__$1;
(statearr_65253_65300[(2)] = inst_65200);

(statearr_65253_65300[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (3))){
var inst_65229 = (state_65231[(2)]);
var state_65231__$1 = state_65231;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65231__$1,inst_65229);
} else {
if((state_val_65232 === (12))){
var inst_65163 = (state_65231[(7)]);
var inst_65181 = (state_65231[(2)]);
var inst_65182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65163,(0),null);
var inst_65183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65163,(1),null);
var inst_65184 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_65185 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_65186 = cljs.core.keys(inst_65185);
var inst_65187 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65184,inst_65186);
var state_65231__$1 = (function (){var statearr_65254 = state_65231;
(statearr_65254[(15)] = inst_65181);

(statearr_65254[(16)] = inst_65182);

(statearr_65254[(17)] = inst_65183);

return statearr_65254;
})();
if(inst_65187){
var statearr_65255_65301 = state_65231__$1;
(statearr_65255_65301[(1)] = (16));

} else {
var statearr_65256_65302 = state_65231__$1;
(statearr_65256_65302[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (2))){
var _ = (function (){var statearr_65257 = state_65231;
(statearr_65257[(4)] = cljs.core.cons((5),(state_65231[(4)])));

return statearr_65257;
})();
var inst_65155 = fluree.db.util.core.current_time_millis();
var inst_65156 = db;
var inst_65157 = cljs.core.__destructure_map(inst_65156);
var inst_65158 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65157,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_65159 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65157,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_65160 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_65231__$1 = (function (){var statearr_65258 = state_65231;
(statearr_65258[(18)] = inst_65159);

(statearr_65258[(13)] = inst_65155);

(statearr_65258[(19)] = inst_65158);

return statearr_65258;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65231__$1,(6),inst_65160);
} else {
if((state_val_65232 === (23))){
var inst_65207 = (state_65231[(2)]);
var inst_65208 = fluree.db.util.async.throw_err(inst_65207);
var state_65231__$1 = state_65231;
var statearr_65259_65303 = state_65231__$1;
(statearr_65259_65303[(2)] = inst_65208);

(statearr_65259_65303[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (19))){
var inst_65191 = (state_65231[(2)]);
var inst_65192 = fluree.db.util.async.throw_err(inst_65191);
var state_65231__$1 = state_65231;
var statearr_65260_65304 = state_65231__$1;
(statearr_65260_65304[(2)] = inst_65192);

(statearr_65260_65304[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (11))){
var state_65231__$1 = state_65231;
var statearr_65262_65305 = state_65231__$1;
(statearr_65262_65305[(2)] = null);

(statearr_65262_65305[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (9))){
var inst_65169 = (state_65231[(2)]);
var state_65231__$1 = state_65231;
if(cljs.core.truth_(inst_65169)){
var statearr_65263_65306 = state_65231__$1;
(statearr_65263_65306[(1)] = (10));

} else {
var statearr_65264_65307 = state_65231__$1;
(statearr_65264_65307[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (5))){
var _ = (function (){var statearr_65265 = state_65231;
(statearr_65265[(4)] = cljs.core.rest((state_65231[(4)])));

return statearr_65265;
})();
var state_65231__$1 = state_65231;
var ex65261 = (state_65231__$1[(2)]);
var statearr_65266_65308 = state_65231__$1;
(statearr_65266_65308[(5)] = ex65261);


var statearr_65267_65309 = state_65231__$1;
(statearr_65267_65309[(1)] = (4));

(statearr_65267_65309[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (14))){
var inst_65159 = (state_65231[(18)]);
var inst_65158 = (state_65231[(19)]);
var inst_65174 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65158),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65159)].join('');
var state_65231__$1 = state_65231;
var statearr_65268_65310 = state_65231__$1;
(statearr_65268_65310[(2)] = inst_65174);

(statearr_65268_65310[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (26))){
var inst_65226 = (state_65231[(2)]);
var _ = (function (){var statearr_65269 = state_65231;
(statearr_65269[(4)] = cljs.core.rest((state_65231[(4)])));

return statearr_65269;
})();
var state_65231__$1 = state_65231;
var statearr_65270_65311 = state_65231__$1;
(statearr_65270_65311[(2)] = inst_65226);

(statearr_65270_65311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (16))){
var inst_65182 = (state_65231[(16)]);
var inst_65183 = (state_65231[(17)]);
var inst_65189 = fluree.db.query.block.block_range(db,inst_65182,inst_65183,opts);
var state_65231__$1 = state_65231;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65231__$1,(19),inst_65189);
} else {
if((state_val_65232 === (10))){
var inst_65163 = (state_65231[(7)]);
var inst_65171 = (state_65231[(12)]);
var inst_65171__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_65163);
var state_65231__$1 = (function (){var statearr_65271 = state_65231;
(statearr_65271[(12)] = inst_65171__$1);

return statearr_65271;
})();
if(cljs.core.truth_(inst_65171__$1)){
var statearr_65272_65312 = state_65231__$1;
(statearr_65272_65312[(1)] = (13));

} else {
var statearr_65273_65313 = state_65231__$1;
(statearr_65273_65313[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (18))){
var inst_65202 = (state_65231[(2)]);
var inst_65203 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65231__$1 = (function (){var statearr_65274 = state_65231;
(statearr_65274[(8)] = inst_65202);

return statearr_65274;
})();
if(cljs.core.truth_(inst_65203)){
var statearr_65275_65314 = state_65231__$1;
(statearr_65275_65314[(1)] = (20));

} else {
var statearr_65276_65315 = state_65231__$1;
(statearr_65276_65315[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65232 === (8))){
var inst_65164 = (state_65231[(14)]);
var state_65231__$1 = state_65231;
var statearr_65277_65316 = state_65231__$1;
(statearr_65277_65316[(2)] = inst_65164);

(statearr_65277_65316[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_65278 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65278[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_65278[(1)] = (1));

return statearr_65278;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_65231){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65231);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65279){var ex__2730__auto__ = e65279;
var statearr_65280_65317 = state_65231;
(statearr_65280_65317[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65231[(4)]))){
var statearr_65281_65318 = state_65231;
(statearr_65281_65318[(1)] = cljs.core.first((state_65231[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65319 = state_65231;
state_65231 = G__65319;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_65231){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_65231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65282 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65282[(6)] = c__2749__auto__);

return statearr_65282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__65321 = arguments.length;
switch (G__65321) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65516){
var state_val_65517 = (state_65516[(1)]);
if((state_val_65517 === (62))){
var inst_65514 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65516__$1,inst_65514);
} else {
if((state_val_65517 === (7))){
var inst_65342 = (state_65516[(7)]);
var inst_65352 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65342);
var state_65516__$1 = state_65516;
var statearr_65518_65609 = state_65516__$1;
(statearr_65518_65609[(2)] = inst_65352);

(statearr_65518_65609[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (59))){
var inst_65502 = (state_65516[(2)]);
var inst_65503 = fluree.db.util.async.throw_err(inst_65502);
var state_65516__$1 = state_65516;
var statearr_65519_65610 = state_65516__$1;
(statearr_65519_65610[(2)] = inst_65503);

(statearr_65519_65610[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (20))){
var inst_65410 = (state_65516[(8)]);
var inst_65418 = (state_65516[(9)]);
var inst_65410__$1 = (state_65516[(2)]);
var inst_65411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65410__$1,(0));
var inst_65413 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65410__$1,(1));
var inst_65414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65410__$1,(2));
var inst_65415 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65410__$1,(3));
var inst_65416 = [inst_65412,inst_65413,inst_65414,inst_65415];
var inst_65417 = (new cljs.core.PersistentVector(null,4,(5),inst_65411,inst_65416,null));
var inst_65418__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65417,(0),null);
var inst_65419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65417,(1),null);
var inst_65420 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65417,(2),null);
var inst_65421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65417,(3),null);
var inst_65422 = (inst_65418__$1 == null);
var inst_65423 = cljs.core.not(inst_65422);
var state_65516__$1 = (function (){var statearr_65520 = state_65516;
(statearr_65520[(10)] = inst_65421);

(statearr_65520[(11)] = inst_65419);

(statearr_65520[(8)] = inst_65410__$1);

(statearr_65520[(12)] = inst_65420);

(statearr_65520[(9)] = inst_65418__$1);

return statearr_65520;
})();
if(inst_65423){
var statearr_65521_65611 = state_65516__$1;
(statearr_65521_65611[(1)] = (30));

} else {
var statearr_65522_65612 = state_65516__$1;
(statearr_65522_65612[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (58))){
var inst_65350 = (state_65516[(13)]);
var inst_65506 = (state_65516[(2)]);
var state_65516__$1 = (function (){var statearr_65523 = state_65516;
(statearr_65523[(14)] = inst_65506);

return statearr_65523;
})();
if(cljs.core.truth_(inst_65350)){
var statearr_65524_65613 = state_65516__$1;
(statearr_65524_65613[(1)] = (60));

} else {
var statearr_65525_65614 = state_65516__$1;
(statearr_65525_65614[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (60))){
var inst_65506 = (state_65516[(14)]);
var inst_65494 = (state_65516[(15)]);
var inst_65508 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_65509 = cljs.core.count(inst_65494);
var inst_65510 = [inst_65506,inst_65509,(200)];
var inst_65511 = cljs.core.PersistentHashMap.fromArrays(inst_65508,inst_65510);
var state_65516__$1 = state_65516;
var statearr_65526_65615 = state_65516__$1;
(statearr_65526_65615[(2)] = inst_65511);

(statearr_65526_65615[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (27))){
var inst_65329 = (state_65516[(16)]);
var inst_65398 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65329)].join('');
var inst_65399 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65400 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65401 = cljs.core.PersistentHashMap.fromArrays(inst_65399,inst_65400);
var inst_65402 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65398,inst_65401);
var inst_65403 = (function(){throw inst_65402})();
var state_65516__$1 = state_65516;
var statearr_65527_65616 = state_65516__$1;
(statearr_65527_65616[(2)] = inst_65403);

(statearr_65527_65616[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (1))){
var inst_65326 = query_map;
var inst_65327 = cljs.core.__destructure_map(inst_65326);
var inst_65328 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65327,new cljs.core.Keyword(null,"block","block",664686210));
var inst_65329 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65327,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_65330 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65327,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_65516__$1 = (function (){var statearr_65528 = state_65516;
(statearr_65528[(16)] = inst_65329);

(statearr_65528[(17)] = inst_65328);

(statearr_65528[(18)] = inst_65330);

return statearr_65528;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65516__$1,(2),sources);
} else {
if((state_val_65517 === (24))){
var inst_65329 = (state_65516[(16)]);
var inst_65387 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65329)].join('');
var inst_65388 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65389 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65390 = cljs.core.PersistentHashMap.fromArrays(inst_65388,inst_65389);
var inst_65391 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65387,inst_65390);
var inst_65392 = (function(){throw inst_65391})();
var state_65516__$1 = state_65516;
var statearr_65529_65617 = state_65516__$1;
(statearr_65529_65617[(2)] = inst_65392);

(statearr_65529_65617[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (55))){
var inst_65330 = (state_65516[(18)]);
var inst_65497 = (state_65516[(2)]);
var inst_65498 = fluree.db.util.async.throw_err(inst_65497);
var state_65516__$1 = (function (){var statearr_65530 = state_65516;
(statearr_65530[(19)] = inst_65498);

return statearr_65530;
})();
if(cljs.core.truth_(inst_65330)){
var statearr_65531_65618 = state_65516__$1;
(statearr_65531_65618[(1)] = (56));

} else {
var statearr_65532_65619 = state_65516__$1;
(statearr_65532_65619[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (39))){
var inst_65421 = (state_65516[(10)]);
var inst_65419 = (state_65516[(11)]);
var inst_65420 = (state_65516[(12)]);
var inst_65418 = (state_65516[(9)]);
var inst_65442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65444 = [inst_65419,inst_65418,inst_65420,inst_65421];
var inst_65445 = (new cljs.core.PersistentVector(null,4,(5),inst_65443,inst_65444,null));
var inst_65446 = [inst_65445,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_65447 = (new cljs.core.PersistentVector(null,2,(5),inst_65442,inst_65446,null));
var state_65516__$1 = state_65516;
var statearr_65533_65620 = state_65516__$1;
(statearr_65533_65620[(2)] = inst_65447);

(statearr_65533_65620[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (46))){
var inst_65452 = (state_65516[(20)]);
var state_65516__$1 = state_65516;
var statearr_65534_65621 = state_65516__$1;
(statearr_65534_65621[(2)] = inst_65452);

(statearr_65534_65621[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (4))){
var state_65516__$1 = state_65516;
var statearr_65535_65622 = state_65516__$1;
(statearr_65535_65622[(2)] = null);

(statearr_65535_65622[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (54))){
var inst_65333 = (state_65516[(21)]);
var inst_65494 = (state_65516[(15)]);
var inst_65493 = (state_65516[(2)]);
var inst_65494__$1 = fluree.db.util.async.throw_err(inst_65493);
var inst_65495 = fluree.db.api_js.format_history_resp(inst_65333,inst_65494__$1);
var state_65516__$1 = (function (){var statearr_65536 = state_65516;
(statearr_65536[(15)] = inst_65494__$1);

return statearr_65536;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65516__$1,(55),inst_65495);
} else {
if((state_val_65517 === (15))){
var inst_65333 = (state_65516[(21)]);
var inst_65374 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65333);
var state_65516__$1 = state_65516;
var statearr_65537_65623 = state_65516__$1;
(statearr_65537_65623[(2)] = inst_65374);

(statearr_65537_65623[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (48))){
var inst_65421 = (state_65516[(10)]);
var inst_65419 = (state_65516[(11)]);
var inst_65420 = (state_65516[(12)]);
var inst_65418 = (state_65516[(9)]);
var inst_65463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65465 = [inst_65419,inst_65420,inst_65418,inst_65421];
var inst_65466 = (new cljs.core.PersistentVector(null,4,(5),inst_65464,inst_65465,null));
var inst_65467 = [inst_65466,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_65468 = (new cljs.core.PersistentVector(null,2,(5),inst_65463,inst_65467,null));
var state_65516__$1 = state_65516;
var statearr_65538_65624 = state_65516__$1;
(statearr_65538_65624[(2)] = inst_65468);

(statearr_65538_65624[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (50))){
var inst_65481 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
var statearr_65539_65625 = state_65516__$1;
(statearr_65539_65625[(2)] = inst_65481);

(statearr_65539_65625[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (21))){
var inst_65329 = (state_65516[(16)]);
var inst_65385 = cljs.core.empty_QMARK_(inst_65329);
var state_65516__$1 = state_65516;
if(inst_65385){
var statearr_65540_65626 = state_65516__$1;
(statearr_65540_65626[(1)] = (24));

} else {
var statearr_65541_65627 = state_65516__$1;
(statearr_65541_65627[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (31))){
var inst_65429 = (state_65516[(22)]);
var inst_65418 = (state_65516[(9)]);
var inst_65429__$1 = (inst_65418 == null);
var state_65516__$1 = (function (){var statearr_65542 = state_65516;
(statearr_65542[(22)] = inst_65429__$1);

return statearr_65542;
})();
if(cljs.core.truth_(inst_65429__$1)){
var statearr_65543_65628 = state_65516__$1;
(statearr_65543_65628[(1)] = (33));

} else {
var statearr_65544_65629 = state_65516__$1;
(statearr_65544_65629[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (32))){
var inst_65366 = (state_65516[(23)]);
var inst_65333 = (state_65516[(21)]);
var inst_65376 = (state_65516[(24)]);
var inst_65485 = (state_65516[(2)]);
var inst_65486 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65485,(0),null);
var inst_65487 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65485,(1),null);
var inst_65488 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_65489 = [inst_65366,inst_65376];
var inst_65490 = cljs.core.PersistentHashMap.fromArrays(inst_65488,inst_65489);
var inst_65491 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_65333,inst_65487,cljs.core._EQ_,inst_65486,inst_65490);
var state_65516__$1 = state_65516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65516__$1,(54),inst_65491);
} else {
if((state_val_65517 === (40))){
var inst_65449 = (state_65516[(25)]);
var inst_65418 = (state_65516[(9)]);
var inst_65449__$1 = (inst_65418 == null);
var state_65516__$1 = (function (){var statearr_65545 = state_65516;
(statearr_65545[(25)] = inst_65449__$1);

return statearr_65545;
})();
if(cljs.core.truth_(inst_65449__$1)){
var statearr_65546_65630 = state_65516__$1;
(statearr_65546_65630[(1)] = (42));

} else {
var statearr_65547_65631 = state_65516__$1;
(statearr_65547_65631[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (56))){
var inst_65333 = (state_65516[(21)]);
var inst_65498 = (state_65516[(19)]);
var inst_65500 = fluree.db.api_js.format_block_resp_pretty(inst_65333,inst_65498);
var state_65516__$1 = state_65516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65516__$1,(59),inst_65500);
} else {
if((state_val_65517 === (33))){
var inst_65432 = (state_65516[(26)]);
var inst_65419 = (state_65516[(11)]);
var inst_65431 = (inst_65419 == null);
var inst_65432__$1 = cljs.core.not(inst_65431);
var state_65516__$1 = (function (){var statearr_65548 = state_65516;
(statearr_65548[(26)] = inst_65432__$1);

return statearr_65548;
})();
if(inst_65432__$1){
var statearr_65549_65632 = state_65516__$1;
(statearr_65549_65632[(1)] = (36));

} else {
var statearr_65550_65633 = state_65516__$1;
(statearr_65550_65633[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (13))){
var inst_65360 = (state_65516[(2)]);
var inst_65361 = fluree.db.util.async.throw_err(inst_65360);
var inst_65362 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65361);
var inst_65363 = (inst_65362 - (1));
var state_65516__$1 = state_65516;
var statearr_65551_65634 = state_65516__$1;
(statearr_65551_65634[(2)] = inst_65363);

(statearr_65551_65634[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (22))){
var state_65516__$1 = state_65516;
var statearr_65552_65635 = state_65516__$1;
(statearr_65552_65635[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (36))){
var inst_65420 = (state_65516[(12)]);
var inst_65434 = (inst_65420 == null);
var state_65516__$1 = state_65516;
var statearr_65554_65636 = state_65516__$1;
(statearr_65554_65636[(2)] = inst_65434);

(statearr_65554_65636[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (41))){
var inst_65483 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
var statearr_65555_65637 = state_65516__$1;
(statearr_65555_65637[(2)] = inst_65483);

(statearr_65555_65637[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (43))){
var inst_65449 = (state_65516[(25)]);
var state_65516__$1 = state_65516;
var statearr_65556_65638 = state_65516__$1;
(statearr_65556_65638[(2)] = inst_65449);

(statearr_65556_65638[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (61))){
var inst_65506 = (state_65516[(14)]);
var state_65516__$1 = state_65516;
var statearr_65557_65639 = state_65516__$1;
(statearr_65557_65639[(2)] = inst_65506);

(statearr_65557_65639[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (29))){
var inst_65406 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
var statearr_65558_65640 = state_65516__$1;
(statearr_65558_65640[(2)] = inst_65406);

(statearr_65558_65640[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (44))){
var inst_65461 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
if(cljs.core.truth_(inst_65461)){
var statearr_65559_65641 = state_65516__$1;
(statearr_65559_65641[(1)] = (48));

} else {
var statearr_65560_65642 = state_65516__$1;
(statearr_65560_65642[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (6))){
var inst_65337 = (state_65516[(2)]);
var inst_65338 = fluree.db.util.async.throw_err(inst_65337);
var state_65516__$1 = state_65516;
var statearr_65561_65643 = state_65516__$1;
(statearr_65561_65643[(2)] = inst_65338);

(statearr_65561_65643[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (28))){
var state_65516__$1 = state_65516;
var statearr_65562_65644 = state_65516__$1;
(statearr_65562_65644[(2)] = null);

(statearr_65562_65644[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (51))){
var inst_65329 = (state_65516[(16)]);
var inst_65471 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65329)].join('');
var inst_65472 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65473 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65474 = cljs.core.PersistentHashMap.fromArrays(inst_65472,inst_65473);
var inst_65475 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65471,inst_65474);
var inst_65476 = (function(){throw inst_65475})();
var state_65516__$1 = state_65516;
var statearr_65563_65645 = state_65516__$1;
(statearr_65563_65645[(2)] = inst_65476);

(statearr_65563_65645[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (25))){
var inst_65329 = (state_65516[(16)]);
var state_65516__$1 = state_65516;
var statearr_65564_65646 = state_65516__$1;
(statearr_65564_65646[(2)] = inst_65329);

(statearr_65564_65646[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (34))){
var inst_65429 = (state_65516[(22)]);
var state_65516__$1 = state_65516;
var statearr_65565_65647 = state_65516__$1;
(statearr_65565_65647[(2)] = inst_65429);

(statearr_65565_65647[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (17))){
var inst_65370 = (state_65516[(2)]);
var inst_65371 = fluree.db.util.async.throw_err(inst_65370);
var inst_65372 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65371);
var state_65516__$1 = state_65516;
var statearr_65566_65648 = state_65516__$1;
(statearr_65566_65648[(2)] = inst_65372);

(statearr_65566_65648[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (3))){
var inst_65333 = (state_65516[(21)]);
var inst_65335 = fluree.db.api_js.resolve_block_range(inst_65333,query_map);
var state_65516__$1 = state_65516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65516__$1,(6),inst_65335);
} else {
if((state_val_65517 === (12))){
var inst_65343 = (state_65516[(27)]);
var inst_65366 = (state_65516[(2)]);
var state_65516__$1 = (function (){var statearr_65567 = state_65516;
(statearr_65567[(23)] = inst_65366);

return statearr_65567;
})();
if(cljs.core.truth_(inst_65343)){
var statearr_65568_65649 = state_65516__$1;
(statearr_65568_65649[(1)] = (14));

} else {
var statearr_65569_65650 = state_65516__$1;
(statearr_65569_65650[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (2))){
var inst_65328 = (state_65516[(17)]);
var inst_65332 = (state_65516[(2)]);
var inst_65333 = fluree.db.util.async.throw_err(inst_65332);
var state_65516__$1 = (function (){var statearr_65570 = state_65516;
(statearr_65570[(21)] = inst_65333);

return statearr_65570;
})();
if(cljs.core.truth_(inst_65328)){
var statearr_65571_65651 = state_65516__$1;
(statearr_65571_65651[(1)] = (3));

} else {
var statearr_65572_65652 = state_65516__$1;
(statearr_65572_65652[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (23))){
var inst_65408 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
var statearr_65573_65653 = state_65516__$1;
(statearr_65573_65653[(2)] = inst_65408);

(statearr_65573_65653[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (47))){
var inst_65458 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
var statearr_65574_65654 = state_65516__$1;
(statearr_65574_65654[(2)] = inst_65458);

(statearr_65574_65654[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (35))){
var inst_65440 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
if(cljs.core.truth_(inst_65440)){
var statearr_65575_65655 = state_65516__$1;
(statearr_65575_65655[(1)] = (39));

} else {
var statearr_65576_65656 = state_65516__$1;
(statearr_65576_65656[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (19))){
var inst_65329 = (state_65516[(16)]);
var inst_65383 = cljs.core.sequential_QMARK_(inst_65329);
var state_65516__$1 = state_65516;
if(inst_65383){
var statearr_65577_65657 = state_65516__$1;
(statearr_65577_65657[(1)] = (21));

} else {
var statearr_65578_65658 = state_65516__$1;
(statearr_65578_65658[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (57))){
var inst_65498 = (state_65516[(19)]);
var state_65516__$1 = state_65516;
var statearr_65579_65659 = state_65516__$1;
(statearr_65579_65659[(2)] = inst_65498);

(statearr_65579_65659[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (11))){
var state_65516__$1 = state_65516;
var statearr_65580_65660 = state_65516__$1;
(statearr_65580_65660[(2)] = (-1));

(statearr_65580_65660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (9))){
var inst_65355 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
if(cljs.core.truth_(inst_65355)){
var statearr_65581_65661 = state_65516__$1;
(statearr_65581_65661[(1)] = (10));

} else {
var statearr_65582_65662 = state_65516__$1;
(statearr_65582_65662[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (5))){
var inst_65342 = (state_65516[(7)]);
var inst_65341 = (state_65516[(2)]);
var inst_65342__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65341,(0),null);
var inst_65343 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65341,(1),null);
var inst_65350 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65516__$1 = (function (){var statearr_65583 = state_65516;
(statearr_65583[(7)] = inst_65342__$1);

(statearr_65583[(13)] = inst_65350);

(statearr_65583[(27)] = inst_65343);

return statearr_65583;
})();
if(cljs.core.truth_(inst_65342__$1)){
var statearr_65584_65663 = state_65516__$1;
(statearr_65584_65663[(1)] = (7));

} else {
var statearr_65585_65664 = state_65516__$1;
(statearr_65585_65664[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (14))){
var inst_65333 = (state_65516[(21)]);
var inst_65343 = (state_65516[(27)]);
var inst_65368 = fluree.db.time_travel.as_of_block(inst_65333,inst_65343);
var state_65516__$1 = state_65516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65516__$1,(17),inst_65368);
} else {
if((state_val_65517 === (45))){
var inst_65420 = (state_65516[(12)]);
var inst_65454 = (inst_65420 == null);
var inst_65455 = cljs.core.not(inst_65454);
var state_65516__$1 = state_65516;
var statearr_65586_65665 = state_65516__$1;
(statearr_65586_65665[(2)] = inst_65455);

(statearr_65586_65665[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (53))){
var inst_65479 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
var statearr_65587_65666 = state_65516__$1;
(statearr_65587_65666[(2)] = inst_65479);

(statearr_65587_65666[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (26))){
var inst_65395 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
var statearr_65588_65667 = state_65516__$1;
(statearr_65588_65667[(2)] = inst_65395);

(statearr_65588_65667[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (16))){
var inst_65329 = (state_65516[(16)]);
var inst_65376 = (state_65516[(2)]);
var inst_65377 = fluree.db.util.core.subj_ident_QMARK_(inst_65329);
var state_65516__$1 = (function (){var statearr_65589 = state_65516;
(statearr_65589[(24)] = inst_65376);

return statearr_65589;
})();
if(inst_65377){
var statearr_65590_65668 = state_65516__$1;
(statearr_65590_65668[(1)] = (18));

} else {
var statearr_65591_65669 = state_65516__$1;
(statearr_65591_65669[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (38))){
var inst_65437 = (state_65516[(2)]);
var state_65516__$1 = state_65516;
var statearr_65592_65670 = state_65516__$1;
(statearr_65592_65670[(2)] = inst_65437);

(statearr_65592_65670[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (30))){
var inst_65410 = (state_65516[(8)]);
var inst_65425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65426 = [inst_65410,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_65427 = (new cljs.core.PersistentVector(null,2,(5),inst_65425,inst_65426,null));
var state_65516__$1 = state_65516;
var statearr_65593_65671 = state_65516__$1;
(statearr_65593_65671[(2)] = inst_65427);

(statearr_65593_65671[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (10))){
var inst_65342 = (state_65516[(7)]);
var inst_65333 = (state_65516[(21)]);
var inst_65357 = (inst_65342 - (1));
var inst_65358 = fluree.db.time_travel.as_of_block(inst_65333,inst_65357);
var state_65516__$1 = state_65516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65516__$1,(13),inst_65358);
} else {
if((state_val_65517 === (18))){
var inst_65329 = (state_65516[(16)]);
var inst_65379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65380 = [inst_65329];
var inst_65381 = (new cljs.core.PersistentVector(null,1,(5),inst_65379,inst_65380,null));
var state_65516__$1 = state_65516;
var statearr_65594_65672 = state_65516__$1;
(statearr_65594_65672[(2)] = inst_65381);

(statearr_65594_65672[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (52))){
var state_65516__$1 = state_65516;
var statearr_65595_65673 = state_65516__$1;
(statearr_65595_65673[(2)] = null);

(statearr_65595_65673[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (42))){
var inst_65419 = (state_65516[(11)]);
var inst_65452 = (state_65516[(20)]);
var inst_65451 = (inst_65419 == null);
var inst_65452__$1 = cljs.core.not(inst_65451);
var state_65516__$1 = (function (){var statearr_65596 = state_65516;
(statearr_65596[(20)] = inst_65452__$1);

return statearr_65596;
})();
if(inst_65452__$1){
var statearr_65597_65674 = state_65516__$1;
(statearr_65597_65674[(1)] = (45));

} else {
var statearr_65598_65675 = state_65516__$1;
(statearr_65598_65675[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (37))){
var inst_65432 = (state_65516[(26)]);
var state_65516__$1 = state_65516;
var statearr_65599_65676 = state_65516__$1;
(statearr_65599_65676[(2)] = inst_65432);

(statearr_65599_65676[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (8))){
var inst_65342 = (state_65516[(7)]);
var state_65516__$1 = state_65516;
var statearr_65600_65677 = state_65516__$1;
(statearr_65600_65677[(2)] = inst_65342);

(statearr_65600_65677[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65517 === (49))){
var state_65516__$1 = state_65516;
var statearr_65601_65678 = state_65516__$1;
(statearr_65601_65678[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_65603 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65603[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_65603[(1)] = (1));

return statearr_65603;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_65516){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65516);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65604){var ex__2730__auto__ = e65604;
var statearr_65605_65679 = state_65516;
(statearr_65605_65679[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65516[(4)]))){
var statearr_65606_65680 = state_65516;
(statearr_65606_65680[(1)] = cljs.core.first((state_65516[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65681 = state_65516;
state_65516 = G__65681;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_65516){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_65516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65607 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65607[(6)] = c__2749__auto__);

return statearr_65607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__65689 = arguments.length;
switch (G__65689) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__65682_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__65682_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65778){
var state_val_65779 = (state_65778[(1)]);
if((state_val_65779 === (7))){
var inst_65729 = (state_65778[(7)]);
var inst_65735 = (state_65778[(8)]);
var inst_65732 = (state_65778[(9)]);
var inst_65739 = (state_65778[(10)]);
var inst_65745 = (function (){var responses = inst_65729;
var responses_STAR_ = inst_65732;
var statuses = inst_65735;
var fuel = inst_65739;
return (function (p1__65685_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__65685_SHARP_);
});
})();
var inst_65746 = cljs.core.some(inst_65745,inst_65735);
var state_65778__$1 = state_65778;
if(cljs.core.truth_(inst_65746)){
var statearr_65780_65828 = state_65778__$1;
(statearr_65780_65828[(1)] = (9));

} else {
var statearr_65781_65829 = state_65778__$1;
(statearr_65781_65829[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (20))){
var inst_65773 = (state_65778[(2)]);
var state_65778__$1 = state_65778;
var statearr_65782_65830 = state_65778__$1;
(statearr_65782_65830[(2)] = inst_65773);

(statearr_65782_65830[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (1))){
var inst_65724 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_65725 = (function (){var c__2749__auto____$1 = inst_65724;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65722){
var state_val_65723 = (state_65722[(1)]);
if((state_val_65723 === (1))){
var inst_65690 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_65691 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_65692 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65691,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_65693 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_65694 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_65695 = cljs.core.PersistentHashMap.EMPTY;
var inst_65696 = inst_65690;
var inst_65697 = inst_65692;
var inst_65698 = inst_65693;
var inst_65699 = inst_65694;
var inst_65700 = inst_65695;
var state_65722__$1 = (function (){var statearr_65783 = state_65722;
(statearr_65783[(7)] = inst_65697);

(statearr_65783[(8)] = inst_65700);

(statearr_65783[(9)] = inst_65696);

(statearr_65783[(10)] = inst_65698);

(statearr_65783[(11)] = inst_65699);

return statearr_65783;
})();
var statearr_65784_65831 = state_65722__$1;
(statearr_65784_65831[(2)] = null);

(statearr_65784_65831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (2))){
var inst_65697 = (state_65722[(7)]);
var inst_65702 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_65697);
var inst_65703 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_65702], 0));
var inst_65704 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65697,new cljs.core.Keyword(null,"opts","opts",155075701),inst_65703);
var inst_65705 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_65704,db_fn);
var state_65722__$1 = state_65722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65722__$1,(4),inst_65705);
} else {
if((state_val_65723 === (3))){
var inst_65720 = (state_65722[(2)]);
var state_65722__$1 = state_65722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65722__$1,inst_65720);
} else {
if((state_val_65723 === (4))){
var inst_65700 = (state_65722[(8)]);
var inst_65696 = (state_65722[(9)]);
var inst_65698 = (state_65722[(10)]);
var inst_65707 = (state_65722[(2)]);
var inst_65708 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65700,inst_65696,inst_65707);
var inst_65709 = cljs.core.first(inst_65698);
var state_65722__$1 = (function (){var statearr_65785 = state_65722;
(statearr_65785[(12)] = inst_65708);

return statearr_65785;
})();
if(cljs.core.truth_(inst_65709)){
var statearr_65786_65832 = state_65722__$1;
(statearr_65786_65832[(1)] = (5));

} else {
var statearr_65787_65833 = state_65722__$1;
(statearr_65787_65833[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (5))){
var inst_65708 = (state_65722[(12)]);
var inst_65698 = (state_65722[(10)]);
var inst_65699 = (state_65722[(11)]);
var inst_65711 = cljs.core.first(inst_65698);
var inst_65712 = cljs.core.first(inst_65699);
var inst_65713 = cljs.core.rest(inst_65698);
var inst_65714 = cljs.core.rest(inst_65699);
var inst_65696 = inst_65711;
var inst_65697 = inst_65712;
var inst_65698__$1 = inst_65713;
var inst_65699__$1 = inst_65714;
var inst_65700 = inst_65708;
var state_65722__$1 = (function (){var statearr_65788 = state_65722;
(statearr_65788[(7)] = inst_65697);

(statearr_65788[(8)] = inst_65700);

(statearr_65788[(9)] = inst_65696);

(statearr_65788[(10)] = inst_65698__$1);

(statearr_65788[(11)] = inst_65699__$1);

return statearr_65788;
})();
var statearr_65789_65834 = state_65722__$1;
(statearr_65789_65834[(2)] = null);

(statearr_65789_65834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (6))){
var inst_65708 = (state_65722[(12)]);
var state_65722__$1 = state_65722;
var statearr_65790_65835 = state_65722__$1;
(statearr_65790_65835[(2)] = inst_65708);

(statearr_65790_65835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (7))){
var inst_65718 = (state_65722[(2)]);
var state_65722__$1 = state_65722;
var statearr_65791_65836 = state_65722__$1;
(statearr_65791_65836[(2)] = inst_65718);

(statearr_65791_65836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_65792 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65792[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_65792[(1)] = (1));

return statearr_65792;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_65722){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65722);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65793){var ex__2730__auto__ = e65793;
var statearr_65794_65837 = state_65722;
(statearr_65794_65837[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65722[(4)]))){
var statearr_65795_65838 = state_65722;
(statearr_65795_65838[(1)] = cljs.core.first((state_65722[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65839 = state_65722;
state_65722 = G__65839;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_65722){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_65722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65796 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65796[(6)] = c__2749__auto____$1);

return statearr_65796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_65726 = cljs.core.async.impl.dispatch.run(inst_65725);
var state_65778__$1 = (function (){var statearr_65797 = state_65778;
(statearr_65797[(11)] = inst_65726);

return statearr_65797;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65778__$1,(2),inst_65724);
} else {
if((state_val_65779 === (4))){
var inst_65729 = (state_65778[(7)]);
var state_65778__$1 = state_65778;
var statearr_65798_65840 = state_65778__$1;
(statearr_65798_65840[(2)] = inst_65729);

(statearr_65798_65840[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (15))){
var state_65778__$1 = state_65778;
var statearr_65799_65841 = state_65778__$1;
(statearr_65799_65841[(2)] = (400));

(statearr_65799_65841[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (13))){
var state_65778__$1 = state_65778;
var statearr_65800_65842 = state_65778__$1;
(statearr_65800_65842[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (6))){
var inst_65735 = (state_65778[(8)]);
var inst_65743 = cljs.core.first(inst_65735);
var state_65778__$1 = state_65778;
var statearr_65802_65843 = state_65778__$1;
(statearr_65802_65843[(2)] = inst_65743);

(statearr_65802_65843[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (17))){
var inst_65756 = (state_65778[(2)]);
var state_65778__$1 = state_65778;
var statearr_65803_65844 = state_65778__$1;
(statearr_65803_65844[(2)] = inst_65756);

(statearr_65803_65844[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (3))){
var inst_65729 = (state_65778[(7)]);
var inst_65735 = (state_65778[(8)]);
var inst_65732 = (state_65778[(9)]);
var inst_65739 = (state_65778[(10)]);
var inst_65734 = cljs.core.vals(inst_65729);
var inst_65735__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_65734);
var inst_65736 = (function (){var responses = inst_65729;
var responses_STAR_ = inst_65732;
var statuses = inst_65735__$1;
return (function (p1__65683_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__65683_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_65737 = cljs.core.vals(inst_65729);
var inst_65738 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_65736,inst_65737);
var inst_65739__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_65738);
var inst_65740 = (function (){var responses = inst_65729;
var responses_STAR_ = inst_65732;
var statuses = inst_65735__$1;
var fuel = inst_65739__$1;
return (function (p1__65684_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__65684_SHARP_);
});
})();
var inst_65741 = cljs.core.every_QMARK_(inst_65740,inst_65735__$1);
var state_65778__$1 = (function (){var statearr_65804 = state_65778;
(statearr_65804[(8)] = inst_65735__$1);

(statearr_65804[(10)] = inst_65739__$1);

return statearr_65804;
})();
if(inst_65741){
var statearr_65805_65845 = state_65778__$1;
(statearr_65805_65845[(1)] = (6));

} else {
var statearr_65806_65846 = state_65778__$1;
(statearr_65806_65846[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (12))){
var state_65778__$1 = state_65778;
var statearr_65807_65847 = state_65778__$1;
(statearr_65807_65847[(2)] = (500));

(statearr_65807_65847[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (2))){
var inst_65729 = (state_65778[(7)]);
var inst_65728 = (state_65778[(2)]);
var inst_65729__$1 = fluree.db.util.async.throw_err(inst_65728);
var inst_65730 = (function (){var responses = inst_65729__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_65731 = cljs.core.PersistentHashMap.EMPTY;
var inst_65732 = cljs.core.reduce_kv(inst_65730,inst_65731,inst_65729__$1);
var state_65778__$1 = (function (){var statearr_65808 = state_65778;
(statearr_65808[(7)] = inst_65729__$1);

(statearr_65808[(9)] = inst_65732);

return statearr_65808;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_65809_65848 = state_65778__$1;
(statearr_65809_65848[(1)] = (3));

} else {
var statearr_65810_65849 = state_65778__$1;
(statearr_65810_65849[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (19))){
var inst_65762 = (state_65778[(12)]);
var inst_65732 = (state_65778[(9)]);
var inst_65739 = (state_65778[(10)]);
var inst_65771 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_65732,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65762,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65739], 0));
var state_65778__$1 = state_65778;
var statearr_65811_65850 = state_65778__$1;
(statearr_65811_65850[(2)] = inst_65771);

(statearr_65811_65850[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (11))){
var inst_65760 = (state_65778[(2)]);
var state_65778__$1 = state_65778;
var statearr_65812_65851 = state_65778__$1;
(statearr_65812_65851[(2)] = inst_65760);

(statearr_65812_65851[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (9))){
var state_65778__$1 = state_65778;
var statearr_65813_65852 = state_65778__$1;
(statearr_65813_65852[(2)] = (207));

(statearr_65813_65852[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (5))){
var inst_65776 = (state_65778[(2)]);
var state_65778__$1 = state_65778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65778__$1,inst_65776);
} else {
if((state_val_65779 === (14))){
var inst_65758 = (state_65778[(2)]);
var state_65778__$1 = state_65778;
var statearr_65814_65853 = state_65778__$1;
(statearr_65814_65853[(2)] = inst_65758);

(statearr_65814_65853[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (16))){
var state_65778__$1 = state_65778;
var statearr_65815_65854 = state_65778__$1;
(statearr_65815_65854[(2)] = null);

(statearr_65815_65854[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (10))){
var inst_65729 = (state_65778[(7)]);
var inst_65735 = (state_65778[(8)]);
var inst_65732 = (state_65778[(9)]);
var inst_65739 = (state_65778[(10)]);
var inst_65749 = (function (){var responses = inst_65729;
var responses_STAR_ = inst_65732;
var statuses = inst_65735;
var fuel = inst_65739;
return (function (p1__65686_SHARP_){
return ((499) < p1__65686_SHARP_);
});
})();
var inst_65750 = cljs.core.some(inst_65749,inst_65735);
var state_65778__$1 = state_65778;
if(cljs.core.truth_(inst_65750)){
var statearr_65816_65855 = state_65778__$1;
(statearr_65816_65855[(1)] = (12));

} else {
var statearr_65817_65856 = state_65778__$1;
(statearr_65817_65856[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (18))){
var inst_65762 = (state_65778[(12)]);
var inst_65767 = (state_65778[(13)]);
var inst_65732 = (state_65778[(9)]);
var inst_65739 = (state_65778[(10)]);
var inst_65769 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_65732,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65762,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65739,new cljs.core.Keyword(null,"block","block",664686210),inst_65767], 0));
var state_65778__$1 = state_65778;
var statearr_65818_65857 = state_65778__$1;
(statearr_65818_65857[(2)] = inst_65769);

(statearr_65818_65857[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65779 === (8))){
var inst_65729 = (state_65778[(7)]);
var inst_65735 = (state_65778[(8)]);
var inst_65762 = (state_65778[(12)]);
var inst_65767 = (state_65778[(13)]);
var inst_65732 = (state_65778[(9)]);
var inst_65739 = (state_65778[(10)]);
var inst_65762__$1 = (state_65778[(2)]);
var inst_65763 = (function (){var responses = inst_65729;
var responses_STAR_ = inst_65732;
var statuses = inst_65735;
var fuel = inst_65739;
var status = inst_65762__$1;
return (function (p1__65687_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__65687_SHARP_));
});
})();
var inst_65764 = cljs.core.vals(inst_65729);
var inst_65765 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_65763,inst_65764);
var inst_65766 = cljs.core.first(inst_65765);
var inst_65767__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_65766);
var state_65778__$1 = (function (){var statearr_65819 = state_65778;
(statearr_65819[(12)] = inst_65762__$1);

(statearr_65819[(13)] = inst_65767__$1);

return statearr_65819;
})();
if(cljs.core.truth_(inst_65767__$1)){
var statearr_65820_65858 = state_65778__$1;
(statearr_65820_65858[(1)] = (18));

} else {
var statearr_65821_65859 = state_65778__$1;
(statearr_65821_65859[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_65822 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65822[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_65822[(1)] = (1));

return statearr_65822;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_65778){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65778);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65823){var ex__2730__auto__ = e65823;
var statearr_65824_65860 = state_65778;
(statearr_65824_65860[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65778[(4)]))){
var statearr_65825_65861 = state_65778;
(statearr_65825_65861[(1)] = cljs.core.first((state_65778[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65862 = state_65778;
state_65778 = G__65862;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_65778){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_65778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65826 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65826[(6)] = c__2749__auto__);

return statearr_65826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__65864 = arguments.length;
switch (G__65864) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__65865 = opts;
var map__65865__$1 = cljs.core.__destructure_map(map__65865);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65865__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65865__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65865__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65865__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__65866 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65866,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65866,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e65869){var e = e65869;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__65872 = arguments.length;
switch (G__65872) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65903){
var state_val_65904 = (state_65903[(1)]);
if((state_val_65904 === (7))){
var state_65903__$1 = state_65903;
var statearr_65905_65926 = state_65903__$1;
(statearr_65905_65926[(2)] = opts);

(statearr_65905_65926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (1))){
var state_65903__$1 = state_65903;
var statearr_65906_65927 = state_65903__$1;
(statearr_65906_65927[(2)] = null);

(statearr_65906_65927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (4))){
var inst_65873 = (state_65903[(2)]);
var inst_65874 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65873], 0));
var inst_65875 = cljs.core.ex_data(inst_65873);
var inst_65876 = cljs.core.ex_message(inst_65873);
var inst_65877 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65875,new cljs.core.Keyword(null,"message","message",-406056002),inst_65876);
var state_65903__$1 = (function (){var statearr_65907 = state_65903;
(statearr_65907[(7)] = inst_65874);

return statearr_65907;
})();
var statearr_65908_65928 = state_65903__$1;
(statearr_65908_65928[(2)] = inst_65877);

(statearr_65908_65928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (6))){
var inst_65887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65888 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_65889 = (new cljs.core.PersistentVector(null,1,(5),inst_65887,inst_65888,null));
var inst_65890 = cljs.core.assoc_in(opts,inst_65889,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65903__$1 = state_65903;
var statearr_65909_65929 = state_65903__$1;
(statearr_65909_65929[(2)] = inst_65890);

(statearr_65909_65929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (3))){
var inst_65901 = (state_65903[(2)]);
var state_65903__$1 = state_65903;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65903__$1,inst_65901);
} else {
if((state_val_65904 === (2))){
var _ = (function (){var statearr_65911 = state_65903;
(statearr_65911[(4)] = cljs.core.cons((5),(state_65903[(4)])));

return statearr_65911;
})();
var inst_65883 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65884 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65885 = (inst_65884 == null);
var state_65903__$1 = (function (){var statearr_65912 = state_65903;
(statearr_65912[(8)] = inst_65883);

return statearr_65912;
})();
if(cljs.core.truth_(inst_65885)){
var statearr_65913_65930 = state_65903__$1;
(statearr_65913_65930[(1)] = (6));

} else {
var statearr_65914_65931 = state_65903__$1;
(statearr_65914_65931[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (9))){
var inst_65897 = (state_65903[(2)]);
var inst_65898 = fluree.db.util.async.throw_err(inst_65897);
var _ = (function (){var statearr_65915 = state_65903;
(statearr_65915[(4)] = cljs.core.rest((state_65903[(4)])));

return statearr_65915;
})();
var state_65903__$1 = state_65903;
var statearr_65916_65932 = state_65903__$1;
(statearr_65916_65932[(2)] = inst_65898);

(statearr_65916_65932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (5))){
var _ = (function (){var statearr_65917 = state_65903;
(statearr_65917[(4)] = cljs.core.rest((state_65903[(4)])));

return statearr_65917;
})();
var state_65903__$1 = state_65903;
var ex65910 = (state_65903__$1[(2)]);
var statearr_65918_65933 = state_65903__$1;
(statearr_65918_65933[(5)] = ex65910);


var statearr_65919_65934 = state_65903__$1;
(statearr_65919_65934[(1)] = (4));

(statearr_65919_65934[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65904 === (8))){
var inst_65883 = (state_65903[(8)]);
var inst_65893 = (state_65903[(2)]);
var inst_65894 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_65883,inst_65893);
var inst_65895 = fluree.db.operations.command_async(conn,inst_65894);
var state_65903__$1 = state_65903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65903__$1,(9),inst_65895);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_65920 = [null,null,null,null,null,null,null,null,null];
(statearr_65920[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_65920[(1)] = (1));

return statearr_65920;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_65903){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65903);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65921){var ex__2730__auto__ = e65921;
var statearr_65922_65935 = state_65903;
(statearr_65922_65935[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65903[(4)]))){
var statearr_65923_65936 = state_65903;
(statearr_65923_65936[(1)] = cljs.core.first((state_65903[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65937 = state_65903;
state_65903 = G__65937;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_65903){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_65903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65924 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65924[(6)] = c__2749__auto__);

return statearr_65924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

