// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.response;
if(cljs.core.truth_(temp__5753__auto__)){
var resp = temp__5753__auto__;
var temp__5753__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5753__auto____$1)){
var st = temp__5753__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status >= (500));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["XHTTP Request Error:",e.request], 0));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status > (0));
} else {
return and__4251__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__19866 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19866,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__19866;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__19867 = opts;
var map__19867__$1 = cljs.core.__destructure_map(map__19867);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19867__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19867__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19867__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19868 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__19868__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19868,headers], 0)):G__19868);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19868__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19868__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__19869 = opts;
var map__19869__$1 = cljs.core.__destructure_map(map__19869);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19869__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19869__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19869__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19869__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19869__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19870 = cljs.core.PersistentArrayMap.EMPTY;
var G__19870__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19870,headers], 0)):G__19870);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19870__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19870__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__19871 = output_format;
var G__19871__$1 = (((G__19871 instanceof cljs.core.Keyword))?G__19871.fqn:null);
switch (G__19871__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__19873 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19873,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__19873;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19905){
var state_val_19906 = (state_19905[(1)]);
if((state_val_19906 === (7))){
var inst_19901 = (state_19905[(2)]);
var state_19905__$1 = state_19905;
var statearr_19907_19932 = state_19905__$1;
(statearr_19907_19932[(2)] = inst_19901);

(statearr_19907_19932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (1))){
var state_19905__$1 = state_19905;
var statearr_19908_19933 = state_19905__$1;
(statearr_19908_19933[(2)] = null);

(statearr_19908_19933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (4))){
var inst_19876 = (state_19905[(7)]);
var inst_19876__$1 = (state_19905[(2)]);
var inst_19877 = (inst_19876__$1 == null);
var state_19905__$1 = (function (){var statearr_19909 = state_19905;
(statearr_19909[(7)] = inst_19876__$1);

return statearr_19909;
})();
if(cljs.core.truth_(inst_19877)){
var statearr_19910_19934 = state_19905__$1;
(statearr_19910_19934[(1)] = (5));

} else {
var statearr_19911_19935 = state_19905__$1;
(statearr_19911_19935[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (6))){
var inst_19876 = (state_19905[(7)]);
var inst_19884 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19876,(0),null);
var inst_19885 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19876,(1),null);
var state_19905__$1 = (function (){var statearr_19912 = state_19905;
(statearr_19912[(8)] = inst_19885);

(statearr_19912[(9)] = inst_19884);

return statearr_19912;
})();
var statearr_19913_19936 = state_19905__$1;
(statearr_19913_19936[(2)] = null);

(statearr_19913_19936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (3))){
var inst_19903 = (state_19905[(2)]);
var state_19905__$1 = state_19905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19905__$1,inst_19903);
} else {
if((state_val_19906 === (2))){
var state_19905__$1 = state_19905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19905__$1,(4),pub_chan);
} else {
if((state_val_19906 === (11))){
var _ = (function (){var statearr_19915 = state_19905;
(statearr_19915[(4)] = cljs.core.rest((state_19905[(4)])));

return statearr_19915;
})();
var state_19905__$1 = state_19905;
var ex19914 = (state_19905__$1[(2)]);
var statearr_19916_19937 = state_19905__$1;
(statearr_19916_19937[(5)] = ex19914);


var statearr_19917_19938 = state_19905__$1;
(statearr_19917_19938[(1)] = (10));

(statearr_19917_19938[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (9))){
var inst_19898 = (state_19905[(2)]);
var state_19905__$1 = (function (){var statearr_19918 = state_19905;
(statearr_19918[(10)] = inst_19898);

return statearr_19918;
})();
var statearr_19919_19939 = state_19905__$1;
(statearr_19919_19939[(2)] = null);

(statearr_19919_19939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (5))){
var inst_19879 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_19905__$1 = state_19905;
var statearr_19920_19940 = state_19905__$1;
(statearr_19920_19940[(2)] = inst_19879);

(statearr_19920_19940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (10))){
var inst_19885 = (state_19905[(8)]);
var inst_19884 = (state_19905[(9)]);
var inst_19886 = (state_19905[(2)]);
var inst_19887 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_19886,"Error sending websocket message:",inst_19884], 0));
var inst_19888 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19885,false);
var state_19905__$1 = (function (){var statearr_19921 = state_19905;
(statearr_19921[(11)] = inst_19887);

return statearr_19921;
})();
var statearr_19922_19941 = state_19905__$1;
(statearr_19922_19941[(2)] = inst_19888);

(statearr_19922_19941[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19906 === (8))){
var inst_19885 = (state_19905[(8)]);
var inst_19884 = (state_19905[(9)]);
var _ = (function (){var statearr_19923 = state_19905;
(statearr_19923[(4)] = cljs.core.cons((11),(state_19905[(4)])));

return statearr_19923;
})();
var inst_19894 = ws.send(inst_19884);
var inst_19895 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19885,true);
var ___$1 = (function (){var statearr_19924 = state_19905;
(statearr_19924[(4)] = cljs.core.rest((state_19905[(4)])));

return statearr_19924;
})();
var state_19905__$1 = (function (){var statearr_19925 = state_19905;
(statearr_19925[(12)] = inst_19894);

return statearr_19925;
})();
var statearr_19926_19942 = state_19905__$1;
(statearr_19926_19942[(2)] = inst_19895);

(statearr_19926_19942[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0 = (function (){
var statearr_19927 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19927[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__);

(statearr_19927[(1)] = (1));

return statearr_19927;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1 = (function (state_19905){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19905);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19928){var ex__2730__auto__ = e19928;
var statearr_19929_19943 = state_19905;
(statearr_19929_19943[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19905[(4)]))){
var statearr_19930_19944 = state_19905;
(statearr_19930_19944[(1)] = cljs.core.first((state_19905[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19945 = state_19905;
state_19905 = G__19945;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = function(state_19905){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1.call(this,state_19905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19931 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19931[(6)] = c__2749__auto__);

return statearr_19931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2749__auto___19983 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19970){
var state_val_19971 = (state_19970[(1)]);
if((state_val_19971 === (1))){
var inst_19949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19950 = [open_QMARK_,timeout_chan];
var inst_19951 = (new cljs.core.PersistentVector(null,2,(5),inst_19949,inst_19950,null));
var state_19970__$1 = state_19970;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_19970__$1,(2),inst_19951,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_19971 === (2))){
var inst_19953 = (state_19970[(2)]);
var inst_19954 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19953,(0),null);
var inst_19955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19953,(1),null);
var inst_19956 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19955,timeout_chan);
var state_19970__$1 = (function (){var statearr_19972 = state_19970;
(statearr_19972[(7)] = inst_19954);

return statearr_19972;
})();
if(inst_19956){
var statearr_19973_19984 = state_19970__$1;
(statearr_19973_19984[(1)] = (3));

} else {
var statearr_19974_19985 = state_19970__$1;
(statearr_19974_19985[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (3))){
var inst_19958 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_19959 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19960 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_19961 = cljs.core.PersistentHashMap.fromArrays(inst_19959,inst_19960);
var inst_19962 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19958,inst_19961);
var inst_19963 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_19962);
var inst_19964 = fluree.db.util.xhttp.close_websocket(ws);
var state_19970__$1 = (function (){var statearr_19975 = state_19970;
(statearr_19975[(8)] = inst_19963);

return statearr_19975;
})();
var statearr_19976_19986 = state_19970__$1;
(statearr_19976_19986[(2)] = inst_19964);

(statearr_19976_19986[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (4))){
var inst_19966 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_19970__$1 = state_19970;
var statearr_19977_19987 = state_19970__$1;
(statearr_19977_19987[(2)] = inst_19966);

(statearr_19977_19987[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19971 === (5))){
var inst_19968 = (state_19970[(2)]);
var state_19970__$1 = state_19970;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19970__$1,inst_19968);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_19978 = [null,null,null,null,null,null,null,null,null];
(statearr_19978[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__);

(statearr_19978[(1)] = (1));

return statearr_19978;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1 = (function (state_19970){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19970);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19979){var ex__2730__auto__ = e19979;
var statearr_19980_19988 = state_19970;
(statearr_19980_19988[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19970[(4)]))){
var statearr_19981_19989 = state_19970;
(statearr_19981_19989[(1)] = cljs.core.first((state_19970[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19990 = state_19970;
state_19970 = G__19990;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = function(state_19970){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1.call(this,state_19970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19982 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19982[(6)] = c__2749__auto___19983);

return statearr_19982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
