// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k28023,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__28027 = k28023;
var G__28027__$1 = (((G__28027 instanceof cljs.core.Keyword))?G__28027.fqn:null);
switch (G__28027__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k28023,else__4505__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__28028){
var vec__28029 = p__28028;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28029,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28029,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28022){
var self__ = this;
var G__28022__$1 = this;
return (new cljs.core.RecordIter((0),G__28022__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__28032 = (function (coll__4499__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__28032(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28024,other28025){
var self__ = this;
var this28024__$1 = this;
return (((!((other28025 == null)))) && ((((this28024__$1.constructor === other28025.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.conn,other28025.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.network,other28025.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.dbid,other28025.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.db_name,other28025.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.update_chan,other28025.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.transact_chan,other28025.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.state,other28025.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.schema_cache,other28025.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.blank_db,other28025.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.close,other28025.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.id,other28025.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28024__$1.__extmap,other28025.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k28023){
var self__ = this;
var this__4509__auto____$1 = this;
var G__28033 = k28023;
var G__28033__$1 = (((G__28033 instanceof cljs.core.Keyword))?G__28033.fqn:null);
switch (G__28033__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k28023);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__28022){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__28034 = cljs.core.keyword_identical_QMARK_;
var expr__28035 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__28037 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__28038 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28037,G__28038) : pred__28034.call(null,G__28037,G__28038));
})())){
return (new fluree.db.session.DbSession(G__28022,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28039 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__28040 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28039,G__28040) : pred__28034.call(null,G__28039,G__28040));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__28022,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28041 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__28042 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28041,G__28042) : pred__28034.call(null,G__28041,G__28042));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__28022,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28043 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__28044 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28043,G__28044) : pred__28034.call(null,G__28043,G__28044));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__28022,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28045 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__28046 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28045,G__28046) : pred__28034.call(null,G__28045,G__28046));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__28022,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28047 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__28048 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28047,G__28048) : pred__28034.call(null,G__28047,G__28048));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__28022,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28049 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__28050 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28049,G__28050) : pred__28034.call(null,G__28049,G__28050));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__28022,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28051 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__28052 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28051,G__28052) : pred__28034.call(null,G__28051,G__28052));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__28022,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28053 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__28054 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28053,G__28054) : pred__28034.call(null,G__28053,G__28054));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__28022,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28055 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__28056 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28055,G__28056) : pred__28034.call(null,G__28055,G__28056));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__28022,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28057 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__28058 = expr__28035;
return (pred__28034.cljs$core$IFn$_invoke$arity$2 ? pred__28034.cljs$core$IFn$_invoke$arity$2(G__28057,G__28058) : pred__28034.call(null,G__28057,G__28058));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__28022,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__28022),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__28022){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__28022,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__28026){
var extmap__4542__auto__ = (function (){var G__28059 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__28026,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__28026)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__28059);
} else {
return G__28059;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__28026),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__28062 = session;
var map__28062__$1 = cljs.core.__destructure_map(map__28062);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28062__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28062__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___28213 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28165){
var state_val_28166 = (state_28165[(1)]);
if((state_val_28166 === (7))){
var inst_28083 = (state_28165[(7)]);
var inst_28088 = cljs.core.empty_QMARK_(inst_28083);
var state_28165__$1 = state_28165;
if(inst_28088){
var statearr_28167_28214 = state_28165__$1;
(statearr_28167_28214[(1)] = (10));

} else {
var statearr_28168_28215 = state_28165__$1;
(statearr_28168_28215[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (20))){
var inst_28074 = (state_28165[(8)]);
var inst_28076 = (state_28165[(9)]);
var inst_28075 = (state_28165[(10)]);
var inst_28114 = (state_28165[(11)]);
var inst_28119 = fluree.db.storage.core.read_block(inst_28074,inst_28075,inst_28076,inst_28114);
var state_28165__$1 = state_28165;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28165__$1,(22),inst_28119);
} else {
if((state_val_28166 === (27))){
var inst_28152 = (state_28165[(12)]);
var inst_28154 = (state_28165[(2)]);
var inst_28155 = fluree.db.util.async.throw_err(inst_28154);
var state_28165__$1 = (function (){var statearr_28169 = state_28165;
(statearr_28169[(13)] = inst_28155);

return statearr_28169;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28165__$1,(28),inst_28152);
} else {
if((state_val_28166 === (1))){
var state_28165__$1 = state_28165;
var statearr_28170_28216 = state_28165__$1;
(statearr_28170_28216[(2)] = null);

(statearr_28170_28216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (24))){
var inst_28076 = (state_28165[(9)]);
var inst_28075 = (state_28165[(10)]);
var inst_28114 = (state_28165[(11)]);
var inst_28136 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28114)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28075),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28076),"."].join('');
var inst_28137 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28138 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_28139 = cljs.core.PersistentHashMap.fromArrays(inst_28137,inst_28138);
var inst_28140 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28136,inst_28139);
var inst_28141 = (function(){throw inst_28140})();
var state_28165__$1 = state_28165;
var statearr_28171_28217 = state_28165__$1;
(statearr_28171_28217[(2)] = inst_28141);

(statearr_28171_28217[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (4))){
var inst_28063 = (state_28165[(2)]);
var inst_28064 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_28063);
var state_28165__$1 = state_28165;
var statearr_28172_28218 = state_28165__$1;
(statearr_28172_28218[(2)] = inst_28064);

(statearr_28172_28218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (15))){
var state_28165__$1 = state_28165;
var statearr_28173_28219 = state_28165__$1;
(statearr_28173_28219[(2)] = null);

(statearr_28173_28219[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (21))){
var inst_28145 = (state_28165[(2)]);
var state_28165__$1 = state_28165;
var statearr_28174_28220 = state_28165__$1;
(statearr_28174_28220[(2)] = inst_28145);

(statearr_28174_28220[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (13))){
var inst_28108 = (state_28165[(14)]);
var inst_28083 = (state_28165[(7)]);
var inst_28107 = (state_28165[(2)]);
var inst_28108__$1 = fluree.db.util.async.throw_err(inst_28107);
var inst_28109 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28083);
var state_28165__$1 = (function (){var statearr_28175 = state_28165;
(statearr_28175[(14)] = inst_28108__$1);

(statearr_28175[(15)] = inst_28109);

return statearr_28175;
})();
if(cljs.core.truth_(inst_28108__$1)){
var statearr_28176_28221 = state_28165__$1;
(statearr_28176_28221[(1)] = (14));

} else {
var statearr_28177_28222 = state_28165__$1;
(statearr_28177_28222[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (22))){
var inst_28122 = (state_28165[(16)]);
var inst_28121 = (state_28165[(2)]);
var inst_28122__$1 = fluree.db.util.async.throw_err(inst_28121);
var state_28165__$1 = (function (){var statearr_28178 = state_28165;
(statearr_28178[(16)] = inst_28122__$1);

return statearr_28178;
})();
if(cljs.core.truth_(inst_28122__$1)){
var statearr_28179_28223 = state_28165__$1;
(statearr_28179_28223[(1)] = (23));

} else {
var statearr_28180_28224 = state_28165__$1;
(statearr_28180_28224[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (6))){
var inst_28083 = (state_28165[(7)]);
var inst_28082 = (state_28165[(2)]);
var inst_28083__$1 = fluree.db.util.async.throw_err(inst_28082);
var inst_28084 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_28083__$1);
var inst_28085 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_28084);
var inst_28086 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_28085);
var state_28165__$1 = (function (){var statearr_28181 = state_28165;
(statearr_28181[(7)] = inst_28083__$1);

return statearr_28181;
})();
if(inst_28086){
var statearr_28182_28225 = state_28165__$1;
(statearr_28182_28225[(1)] = (7));

} else {
var statearr_28183_28226 = state_28165__$1;
(statearr_28183_28226[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (28))){
var inst_28150 = (state_28165[(17)]);
var inst_28155 = (state_28165[(13)]);
var inst_28157 = (state_28165[(2)]);
var inst_28158 = fluree.db.util.async.throw_err(inst_28157);
var inst_28159 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28150,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_28155,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_28158], 0));
var inst_28160 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_28159);
var _ = (function (){var statearr_28184 = state_28165;
(statearr_28184[(4)] = cljs.core.rest((state_28165[(4)])));

return statearr_28184;
})();
var state_28165__$1 = state_28165;
var statearr_28185_28227 = state_28165__$1;
(statearr_28185_28227[(2)] = inst_28160);

(statearr_28185_28227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (25))){
var inst_28143 = (state_28165[(2)]);
var state_28165__$1 = state_28165;
var statearr_28186_28228 = state_28165__$1;
(statearr_28186_28228[(2)] = inst_28143);

(statearr_28186_28228[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (17))){
var inst_28114 = (state_28165[(11)]);
var inst_28109 = (state_28165[(15)]);
var inst_28116 = (inst_28114 > inst_28109);
var state_28165__$1 = state_28165;
if(cljs.core.truth_(inst_28116)){
var statearr_28187_28229 = state_28165__$1;
(statearr_28187_28229[(1)] = (19));

} else {
var statearr_28188_28230 = state_28165__$1;
(statearr_28188_28230[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (3))){
var inst_28163 = (state_28165[(2)]);
var state_28165__$1 = state_28165;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28165__$1,inst_28163);
} else {
if((state_val_28166 === (12))){
var inst_28095 = (state_28165[(2)]);
var inst_28096 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28097 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28098 = cljs.core.PersistentHashMap.fromArrays(inst_28096,inst_28097);
var inst_28099 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28095,inst_28098);
var inst_28100 = (function(){throw inst_28099})();
var state_28165__$1 = state_28165;
var statearr_28189_28231 = state_28165__$1;
(statearr_28189_28231[(2)] = inst_28100);

(statearr_28189_28231[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (2))){
var inst_28074 = (state_28165[(8)]);
var inst_28076 = (state_28165[(9)]);
var inst_28075 = (state_28165[(10)]);
var _ = (function (){var statearr_28190 = state_28165;
(statearr_28190[(4)] = cljs.core.cons((5),(state_28165[(4)])));

return statearr_28190;
})();
var inst_28071 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_28072 = session;
var inst_28073 = cljs.core.__destructure_map(inst_28072);
var inst_28074__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28073,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_28075__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28073,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_28076__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28073,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_28077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28078 = [inst_28075__$1,inst_28076__$1];
var inst_28079 = (new cljs.core.PersistentVector(null,2,(5),inst_28077,inst_28078,null));
var inst_28080 = fluree.db.operations.ledger_info_async(inst_28074__$1,inst_28079);
var state_28165__$1 = (function (){var statearr_28191 = state_28165;
(statearr_28191[(18)] = inst_28071);

(statearr_28191[(8)] = inst_28074__$1);

(statearr_28191[(9)] = inst_28076__$1);

(statearr_28191[(10)] = inst_28075__$1);

return statearr_28191;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28165__$1,(6),inst_28080);
} else {
if((state_val_28166 === (23))){
var inst_28113 = (state_28165[(19)]);
var inst_28122 = (state_28165[(16)]);
var inst_28125 = cljs.core.__destructure_map(inst_28122);
var inst_28126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28125,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_28127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28125,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28125,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_28129 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_28113,inst_28127,inst_28126);
var state_28165__$1 = (function (){var statearr_28192 = state_28165;
(statearr_28192[(20)] = inst_28128);

return statearr_28192;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28165__$1,(26),inst_28129);
} else {
if((state_val_28166 === (19))){
var inst_28113 = (state_28165[(19)]);
var state_28165__$1 = state_28165;
var statearr_28193_28232 = state_28165__$1;
(statearr_28193_28232[(2)] = inst_28113);

(statearr_28193_28232[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (11))){
var inst_28076 = (state_28165[(9)]);
var inst_28075 = (state_28165[(10)]);
var inst_28083 = (state_28165[(7)]);
var inst_28092 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_28083);
var inst_28093 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28075),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28076)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28092),"."].join('');
var state_28165__$1 = state_28165;
var statearr_28195_28233 = state_28165__$1;
(statearr_28195_28233[(2)] = inst_28093);

(statearr_28195_28233[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (9))){
var inst_28071 = (state_28165[(18)]);
var inst_28074 = (state_28165[(8)]);
var inst_28076 = (state_28165[(9)]);
var inst_28075 = (state_28165[(10)]);
var inst_28083 = (state_28165[(7)]);
var inst_28103 = (state_28165[(2)]);
var inst_28104 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_28083);
var inst_28105 = fluree.db.storage.core.reify_db(inst_28074,inst_28075,inst_28076,inst_28071,inst_28104);
var state_28165__$1 = (function (){var statearr_28196 = state_28165;
(statearr_28196[(21)] = inst_28103);

return statearr_28196;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28165__$1,(13),inst_28105);
} else {
if((state_val_28166 === (5))){
var _ = (function (){var statearr_28197 = state_28165;
(statearr_28197[(4)] = cljs.core.rest((state_28165[(4)])));

return statearr_28197;
})();
var state_28165__$1 = state_28165;
var ex28194 = (state_28165__$1[(2)]);
var statearr_28198_28234 = state_28165__$1;
(statearr_28198_28234[(5)] = ex28194);


var statearr_28199_28235 = state_28165__$1;
(statearr_28199_28235[(1)] = (4));

(statearr_28199_28235[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (14))){
var inst_28108 = (state_28165[(14)]);
var inst_28111 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28108);
var inst_28112 = (inst_28111 + (1));
var inst_28113 = inst_28108;
var inst_28114 = inst_28112;
var state_28165__$1 = (function (){var statearr_28200 = state_28165;
(statearr_28200[(19)] = inst_28113);

(statearr_28200[(11)] = inst_28114);

return statearr_28200;
})();
var statearr_28201_28236 = state_28165__$1;
(statearr_28201_28236[(2)] = null);

(statearr_28201_28236[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (26))){
var inst_28114 = (state_28165[(11)]);
var inst_28131 = (state_28165[(2)]);
var inst_28132 = fluree.db.util.async.throw_err(inst_28131);
var inst_28133 = (inst_28114 + (1));
var inst_28113 = inst_28132;
var inst_28114__$1 = inst_28133;
var state_28165__$1 = (function (){var statearr_28202 = state_28165;
(statearr_28202[(19)] = inst_28113);

(statearr_28202[(11)] = inst_28114__$1);

return statearr_28202;
})();
var statearr_28203_28237 = state_28165__$1;
(statearr_28203_28237[(2)] = null);

(statearr_28203_28237[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (16))){
var inst_28150 = (state_28165[(17)]);
var inst_28150__$1 = (state_28165[(2)]);
var inst_28151 = fluree.db.query.schema.schema_map(inst_28150__$1);
var inst_28152 = fluree.db.query.schema.setting_map(inst_28150__$1);
var state_28165__$1 = (function (){var statearr_28204 = state_28165;
(statearr_28204[(17)] = inst_28150__$1);

(statearr_28204[(12)] = inst_28152);

return statearr_28204;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28165__$1,(27),inst_28151);
} else {
if((state_val_28166 === (10))){
var inst_28076 = (state_28165[(9)]);
var inst_28075 = (state_28165[(10)]);
var inst_28090 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28075),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28076)," is not found on this ledger group."].join('');
var state_28165__$1 = state_28165;
var statearr_28205_28238 = state_28165__$1;
(statearr_28205_28238[(2)] = inst_28090);

(statearr_28205_28238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (18))){
var inst_28147 = (state_28165[(2)]);
var state_28165__$1 = state_28165;
var statearr_28206_28239 = state_28165__$1;
(statearr_28206_28239[(2)] = inst_28147);

(statearr_28206_28239[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28166 === (8))){
var state_28165__$1 = state_28165;
var statearr_28207_28240 = state_28165__$1;
(statearr_28207_28240[(2)] = null);

(statearr_28207_28240[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____0 = (function (){
var statearr_28208 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28208[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__);

(statearr_28208[(1)] = (1));

return statearr_28208;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____1 = (function (state_28165){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28165);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28209){var ex__2730__auto__ = e28209;
var statearr_28210_28241 = state_28165;
(statearr_28210_28241[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28165[(4)]))){
var statearr_28211_28242 = state_28165;
(statearr_28211_28242[(1)] = cljs.core.first((state_28165[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28243 = state_28165;
state_28165 = G__28243;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__ = function(state_28165){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____1.call(this,state_28165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28212 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28212[(6)] = c__2749__auto___28213);

return statearr_28212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__28244 = cljs.core.get_global_hierarchy;
return (fexpr__28244.cljs$core$IFn$_invoke$arity$0 ? fexpr__28244.cljs$core$IFn$_invoke$arity$0() : fexpr__28244.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28246){
var state_val_28247 = (state_28246[(1)]);
if((state_val_28247 === (1))){
var state_28246__$1 = state_28246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28246__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_28248 = [null,null,null,null,null,null,null];
(statearr_28248[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_28248[(1)] = (1));

return statearr_28248;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_28246){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28246);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28249){var ex__2730__auto__ = e28249;
var statearr_28250_28253 = state_28246;
(statearr_28250_28253[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28246[(4)]))){
var statearr_28251_28254 = state_28246;
(statearr_28251_28254[(1)] = cljs.core.first((state_28246[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28255 = state_28246;
state_28246 = G__28255;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_28246){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_28246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28252 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28252[(6)] = c__2749__auto__);

return statearr_28252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__28257){
var map__28258 = p__28257;
var map__28258__$1 = cljs.core.__destructure_map(map__28258);
var data = map__28258__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28258__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28258__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28258__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28317){
var state_val_28318 = (state_28317[(1)]);
if((state_val_28318 === (7))){
var inst_28269 = (state_28317[(7)]);
var inst_28272 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28273 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28274 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28272),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28273),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28269),". No-op."].join('');
var inst_28275 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28274], 0));
var state_28317__$1 = state_28317;
var statearr_28319_28357 = state_28317__$1;
(statearr_28319_28357[(2)] = inst_28275);

(statearr_28319_28357[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (1))){
var state_28317__$1 = state_28317;
var statearr_28320_28358 = state_28317__$1;
(statearr_28320_28358[(2)] = null);

(statearr_28320_28358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (4))){
var inst_28259 = (state_28317[(2)]);
var state_28317__$1 = state_28317;
var statearr_28321_28359 = state_28317__$1;
(statearr_28321_28359[(2)] = inst_28259);

(statearr_28321_28359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (15))){
var inst_28298 = (state_28317[(2)]);
var state_28317__$1 = state_28317;
var statearr_28322_28360 = state_28317__$1;
(statearr_28322_28360[(2)] = inst_28298);

(statearr_28322_28360[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (13))){
var inst_28289 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_28290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28291 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28292 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28293 = [inst_28291,inst_28292];
var inst_28294 = (new cljs.core.PersistentVector(null,2,(5),inst_28290,inst_28293,null));
var inst_28295 = (function (){var G__28323 = inst_28289;
var G__28324 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__28325 = inst_28294;
var G__28326 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__28323,G__28324,G__28325,G__28326) : fluree.db.conn_events.process_event.call(null,G__28323,G__28324,G__28325,G__28326));
})();
var state_28317__$1 = state_28317;
var statearr_28327_28361 = state_28317__$1;
(statearr_28327_28361[(2)] = inst_28295);

(statearr_28327_28361[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (6))){
var inst_28268 = (state_28317[(8)]);
var inst_28269 = (state_28317[(7)]);
var inst_28267 = (state_28317[(2)]);
var inst_28268__$1 = fluree.db.util.async.throw_err(inst_28267);
var inst_28269__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28268__$1);
var inst_28270 = (block <= inst_28269__$1);
var state_28317__$1 = (function (){var statearr_28328 = state_28317;
(statearr_28328[(8)] = inst_28268__$1);

(statearr_28328[(7)] = inst_28269__$1);

return statearr_28328;
})();
if(cljs.core.truth_(inst_28270)){
var statearr_28329_28362 = state_28317__$1;
(statearr_28329_28362[(1)] = (7));

} else {
var statearr_28330_28363 = state_28317__$1;
(statearr_28330_28363[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (17))){
var state_28317__$1 = state_28317;
var statearr_28331_28364 = state_28317__$1;
(statearr_28331_28364[(2)] = null);

(statearr_28331_28364[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (3))){
var inst_28315 = (state_28317[(2)]);
var state_28317__$1 = state_28317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28317__$1,inst_28315);
} else {
if((state_val_28318 === (12))){
var inst_28310 = (state_28317[(2)]);
var state_28317__$1 = state_28317;
var statearr_28332_28365 = state_28317__$1;
(statearr_28332_28365[(2)] = inst_28310);

(statearr_28332_28365[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (2))){
var inst_28265 = (state_28317[(9)]);
var _ = (function (){var statearr_28333 = state_28317;
(statearr_28333[(4)] = cljs.core.cons((5),(state_28317[(4)])));

return statearr_28333;
})();
var inst_28265__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_28317__$1 = (function (){var statearr_28334 = state_28317;
(statearr_28334[(9)] = inst_28265__$1);

return statearr_28334;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28317__$1,(6),inst_28265__$1);
} else {
if((state_val_28318 === (11))){
var state_28317__$1 = state_28317;
var statearr_28336_28366 = state_28317__$1;
(statearr_28336_28366[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (9))){
var inst_28312 = (state_28317[(2)]);
var _ = (function (){var statearr_28338 = state_28317;
(statearr_28338[(4)] = cljs.core.rest((state_28317[(4)])));

return statearr_28338;
})();
var state_28317__$1 = state_28317;
var statearr_28339_28367 = state_28317__$1;
(statearr_28339_28367[(2)] = inst_28312);

(statearr_28339_28367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (5))){
var _ = (function (){var statearr_28340 = state_28317;
(statearr_28340[(4)] = cljs.core.rest((state_28317[(4)])));

return statearr_28340;
})();
var state_28317__$1 = state_28317;
var ex28335 = (state_28317__$1[(2)]);
var statearr_28341_28368 = state_28317__$1;
(statearr_28341_28368[(5)] = ex28335);


if((ex28335 instanceof Error)){
var statearr_28342_28369 = state_28317__$1;
(statearr_28342_28369[(1)] = (4));

(statearr_28342_28369[(5)] = null);

} else {
throw ex28335;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (14))){
var state_28317__$1 = state_28317;
var statearr_28343_28370 = state_28317__$1;
(statearr_28343_28370[(2)] = null);

(statearr_28343_28370[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (16))){
var inst_28269 = (state_28317[(7)]);
var inst_28301 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28302 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28303 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28301),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28302),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28269),". Forcing a db reload."].join('');
var inst_28304 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28303], 0));
var inst_28305 = fluree.db.session.reload_db_BANG_(session);
var state_28317__$1 = (function (){var statearr_28344 = state_28317;
(statearr_28344[(10)] = inst_28304);

return statearr_28344;
})();
var statearr_28345_28371 = state_28317__$1;
(statearr_28345_28371[(2)] = inst_28305);

(statearr_28345_28371[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (10))){
var inst_28268 = (state_28317[(8)]);
var inst_28269 = (state_28317[(7)]);
var inst_28265 = (state_28317[(9)]);
var inst_28280 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28281 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28282 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28280),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28281),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_28283 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28282], 0));
var inst_28284 = (function (){var current_db_ch = inst_28265;
var current_db = inst_28268;
var current_block = inst_28269;
return (function (p1__28256_SHARP_){
if((p1__28256_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__28256_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__28256_SHARP_);
}
});
})();
var inst_28285 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_28284,flakes);
var inst_28286 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_28268,block,inst_28285);
var inst_28287 = fluree.db.session.cas_db_BANG_(session,inst_28265,inst_28286);
var state_28317__$1 = (function (){var statearr_28346 = state_28317;
(statearr_28346[(11)] = inst_28283);

return statearr_28346;
})();
if(inst_28287){
var statearr_28347_28372 = state_28317__$1;
(statearr_28347_28372[(1)] = (13));

} else {
var statearr_28348_28373 = state_28317__$1;
(statearr_28348_28373[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (18))){
var inst_28308 = (state_28317[(2)]);
var state_28317__$1 = state_28317;
var statearr_28349_28374 = state_28317__$1;
(statearr_28349_28374[(2)] = inst_28308);

(statearr_28349_28374[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28318 === (8))){
var inst_28269 = (state_28317[(7)]);
var inst_28277 = ((1) + inst_28269);
var inst_28278 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_28277);
var state_28317__$1 = state_28317;
if(inst_28278){
var statearr_28350_28375 = state_28317__$1;
(statearr_28350_28375[(1)] = (10));

} else {
var statearr_28351_28376 = state_28317__$1;
(statearr_28351_28376[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_28352 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28352[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_28352[(1)] = (1));

return statearr_28352;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_28317){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28317);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28353){var ex__2730__auto__ = e28353;
var statearr_28354_28377 = state_28317;
(statearr_28354_28377[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28317[(4)]))){
var statearr_28355_28378 = state_28317;
(statearr_28355_28378[(1)] = cljs.core.first((state_28317[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28379 = state_28317;
state_28317 = G__28379;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_28317){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_28317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28356 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28356[(6)] = c__2749__auto__);

return statearr_28356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28386){
var state_val_28387 = (state_28386[(1)]);
if((state_val_28387 === (1))){
var inst_28380 = fluree.db.session.clear_db_BANG_(session);
var inst_28381 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28382 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28383 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28381),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28382)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_28384 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28383], 0));
var state_28386__$1 = (function (){var statearr_28388 = state_28386;
(statearr_28388[(7)] = inst_28384);

(statearr_28388[(8)] = inst_28380);

return statearr_28388;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28386__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_28389 = [null,null,null,null,null,null,null,null,null];
(statearr_28389[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_28389[(1)] = (1));

return statearr_28389;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_28386){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28386);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28390){var ex__2730__auto__ = e28390;
var statearr_28391_28394 = state_28386;
(statearr_28391_28394[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28386[(4)]))){
var statearr_28392_28395 = state_28386;
(statearr_28392_28395[(1)] = cljs.core.first((state_28386[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28396 = state_28386;
state_28386 = G__28396;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_28386){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_28386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28393 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28393[(6)] = c__2749__auto__);

return statearr_28393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__28398 = arguments.length;
switch (G__28398) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
var map__28399 = session;
var map__28399__$1 = cljs.core.__destructure_map(map__28399);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28399__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28399__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28399__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28399__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28399__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28399__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28399__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__28400_28403 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28400_28403.cljs$core$IFn$_invoke$arity$3 ? fexpr__28400_28403.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__28400_28403.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__28401_28404 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__28401_28404.cljs$core$IFn$_invoke$arity$0 ? fexpr__28401_28404.cljs$core$IFn$_invoke$arity$0() : fexpr__28401_28404.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28457){
var state_val_28458 = (state_28457[(1)]);
if((state_val_28458 === (7))){
var inst_28453 = (state_28457[(2)]);
var state_28457__$1 = state_28457;
var statearr_28459_28490 = state_28457__$1;
(statearr_28459_28490[(2)] = inst_28453);

(statearr_28459_28490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (1))){
var state_28457__$1 = state_28457;
var statearr_28460_28491 = state_28457__$1;
(statearr_28460_28491[(2)] = null);

(statearr_28460_28491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (4))){
var inst_28408 = (state_28457[(7)]);
var inst_28407 = (state_28457[(2)]);
var inst_28408__$1 = fluree.db.util.async.throw_err(inst_28407);
var inst_28409 = fluree.db.session.from_cache(network,ledger_id);
var inst_28410 = (inst_28408__$1 == null);
var state_28457__$1 = (function (){var statearr_28461 = state_28457;
(statearr_28461[(8)] = inst_28409);

(statearr_28461[(7)] = inst_28408__$1);

return statearr_28461;
})();
if(cljs.core.truth_(inst_28410)){
var statearr_28462_28492 = state_28457__$1;
(statearr_28462_28492[(1)] = (5));

} else {
var statearr_28463_28493 = state_28457__$1;
(statearr_28463_28493[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (15))){
var inst_28445 = (state_28457[(2)]);
var state_28457__$1 = (function (){var statearr_28464 = state_28457;
(statearr_28464[(9)] = inst_28445);

return statearr_28464;
})();
var statearr_28465_28494 = state_28457__$1;
(statearr_28465_28494[(2)] = null);

(statearr_28465_28494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (13))){
var inst_28449 = (state_28457[(2)]);
var state_28457__$1 = state_28457;
var statearr_28467_28495 = state_28457__$1;
(statearr_28467_28495[(2)] = inst_28449);

(statearr_28467_28495[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (6))){
var inst_28409 = (state_28457[(8)]);
var inst_28415 = (inst_28409 == null);
var state_28457__$1 = state_28457;
if(cljs.core.truth_(inst_28415)){
var statearr_28468_28496 = state_28457__$1;
(statearr_28468_28496[(1)] = (8));

} else {
var statearr_28469_28497 = state_28457__$1;
(statearr_28469_28497[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (17))){
var _ = (function (){var statearr_28470 = state_28457;
(statearr_28470[(4)] = cljs.core.rest((state_28457[(4)])));

return statearr_28470;
})();
var state_28457__$1 = state_28457;
var ex28466 = (state_28457__$1[(2)]);
var statearr_28471_28498 = state_28457__$1;
(statearr_28471_28498[(5)] = ex28466);


var statearr_28472_28499 = state_28457__$1;
(statearr_28472_28499[(1)] = (16));

(statearr_28472_28499[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (3))){
var inst_28455 = (state_28457[(2)]);
var state_28457__$1 = state_28457;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28457__$1,inst_28455);
} else {
if((state_val_28458 === (12))){
var state_28457__$1 = state_28457;
var statearr_28473_28500 = state_28457__$1;
(statearr_28473_28500[(2)] = null);

(statearr_28473_28500[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (2))){
var state_28457__$1 = state_28457;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28457__$1,(4),update_chan);
} else {
if((state_val_28458 === (11))){
var state_28457__$1 = state_28457;
var statearr_28474_28501 = state_28457__$1;
(statearr_28474_28501[(2)] = null);

(statearr_28474_28501[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (9))){
var state_28457__$1 = state_28457;
var statearr_28475_28502 = state_28457__$1;
(statearr_28475_28502[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (5))){
var inst_28412 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_28413 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28412], 0));
var state_28457__$1 = state_28457;
var statearr_28477_28503 = state_28457__$1;
(statearr_28477_28503[(2)] = inst_28413);

(statearr_28477_28503[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (14))){
var inst_28409 = (state_28457[(8)]);
var inst_28408 = (state_28457[(7)]);
var _ = (function (){var statearr_28478 = state_28457;
(statearr_28478[(4)] = cljs.core.cons((17),(state_28457[(4)])));

return statearr_28478;
})();
var inst_28433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28408,(0),null);
var inst_28434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28408,(1),null);
var inst_28435 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_28436 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28408], 0));
var inst_28437 = fluree.db.util.core.trunc(inst_28436,(200));
var inst_28438 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28435,inst_28437], 0));
var inst_28439 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_28409,inst_28433,inst_28434) : fluree.db.session.process_ledger_update.call(null,inst_28409,inst_28433,inst_28434));
var state_28457__$1 = (function (){var statearr_28479 = state_28457;
(statearr_28479[(10)] = inst_28438);

return statearr_28479;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28457__$1,(18),inst_28439);
} else {
if((state_val_28458 === (16))){
var inst_28408 = (state_28457[(7)]);
var inst_28423 = (state_28457[(2)]);
var inst_28424 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28423,"Exception processing ledger updates for message: ",inst_28408], 0));
var state_28457__$1 = state_28457;
var statearr_28480_28504 = state_28457__$1;
(statearr_28480_28504[(2)] = inst_28424);

(statearr_28480_28504[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (10))){
var inst_28451 = (state_28457[(2)]);
var state_28457__$1 = state_28457;
var statearr_28481_28505 = state_28457__$1;
(statearr_28481_28505[(2)] = inst_28451);

(statearr_28481_28505[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (18))){
var inst_28441 = (state_28457[(2)]);
var inst_28442 = fluree.db.util.async.throw_err(inst_28441);
var _ = (function (){var statearr_28482 = state_28457;
(statearr_28482[(4)] = cljs.core.rest((state_28457[(4)])));

return statearr_28482;
})();
var state_28457__$1 = state_28457;
var statearr_28483_28506 = state_28457__$1;
(statearr_28483_28506[(2)] = inst_28442);

(statearr_28483_28506[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28458 === (8))){
var inst_28408 = (state_28457[(7)]);
var inst_28417 = cljs.core.first(inst_28408);
var inst_28418 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28417], 0));
var inst_28419 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_28418].join('');
var inst_28420 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28419], 0));
var state_28457__$1 = state_28457;
var statearr_28484_28507 = state_28457__$1;
(statearr_28484_28507[(2)] = inst_28420);

(statearr_28484_28507[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0 = (function (){
var statearr_28485 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28485[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__);

(statearr_28485[(1)] = (1));

return statearr_28485;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1 = (function (state_28457){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28457);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28486){var ex__2730__auto__ = e28486;
var statearr_28487_28508 = state_28457;
(statearr_28487_28508[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28457[(4)]))){
var statearr_28488_28509 = state_28457;
(statearr_28488_28509[(1)] = cljs.core.first((state_28457[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28510 = state_28457;
state_28457 = G__28510;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__ = function(state_28457){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1.call(this,state_28457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28489 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28489[(6)] = c__2749__auto__);

return statearr_28489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__28511){
var map__28512 = p__28511;
var map__28512__$1 = cljs.core.__destructure_map(map__28512);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28512__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28512__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28512__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28512__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28512__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28512__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28512__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28512__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28512__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__28516 = block_result;
var map__28516__$1 = cljs.core.__destructure_map(map__28516);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28516__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28516__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28516__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28516__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28516__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__28517 = tx_result;
var map__28517__$1 = cljs.core.__destructure_map(map__28517);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28517__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28517__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__28513_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__28513_SHARP_.t);
}):(function (p1__28514_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28514_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__28515_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__28515_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28515_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__28518 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28518,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28518,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28518,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28518,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = message;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__28522 = arguments.length;
switch (G__28522) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__28523){
var map__28524 = p__28523;
var map__28524__$1 = cljs.core.__destructure_map(map__28524);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28524__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28524__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28524__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28524__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28525 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28525,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28525,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28525,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4253__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4253__auto____$1 = state;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__28529_28649 = network;
var G__28530_28650 = ledger_id;
var G__28531_28651 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__28532_28652 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28533 = cljs.core.seq(tids);
var chunk__28534 = null;
var count__28535 = (0);
var i__28536 = (0);
while(true){
if((i__28536 < count__28535)){
var tid = chunk__28534.cljs$core$IIndexed$_nth$arity$2(null,i__28536);
var temp__5753__auto___28654__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___28654__$1)){
var keyed_callbacks_28655 = temp__5753__auto___28654__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28656 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28577_28657 = cljs.core.seq(keyed_callbacks_28655);
var chunk__28578_28658 = null;
var count__28579_28659 = (0);
var i__28580_28660 = (0);
while(true){
if((i__28580_28660 < count__28579_28659)){
var vec__28589_28661 = chunk__28578_28658.cljs$core$IIndexed$_nth$arity$2(null,i__28580_28660);
var k_28662 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28589_28661,(0),null);
var f_28663 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28589_28661,(1),null);
try{(f_28663.cljs$core$IFn$_invoke$arity$1 ? f_28663.cljs$core$IFn$_invoke$arity$1(tx_response_28656) : f_28663.call(null,tx_response_28656));
}catch (e28592){var e_28664 = e28592;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28664,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28665 = seq__28577_28657;
var G__28666 = chunk__28578_28658;
var G__28667 = count__28579_28659;
var G__28668 = (i__28580_28660 + (1));
seq__28577_28657 = G__28665;
chunk__28578_28658 = G__28666;
count__28579_28659 = G__28667;
i__28580_28660 = G__28668;
continue;
} else {
var temp__5753__auto___28669__$2 = cljs.core.seq(seq__28577_28657);
if(temp__5753__auto___28669__$2){
var seq__28577_28670__$1 = temp__5753__auto___28669__$2;
if(cljs.core.chunked_seq_QMARK_(seq__28577_28670__$1)){
var c__4679__auto___28671 = cljs.core.chunk_first(seq__28577_28670__$1);
var G__28672 = cljs.core.chunk_rest(seq__28577_28670__$1);
var G__28673 = c__4679__auto___28671;
var G__28674 = cljs.core.count(c__4679__auto___28671);
var G__28675 = (0);
seq__28577_28657 = G__28672;
chunk__28578_28658 = G__28673;
count__28579_28659 = G__28674;
i__28580_28660 = G__28675;
continue;
} else {
var vec__28593_28676 = cljs.core.first(seq__28577_28670__$1);
var k_28677 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28593_28676,(0),null);
var f_28678 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28593_28676,(1),null);
try{(f_28678.cljs$core$IFn$_invoke$arity$1 ? f_28678.cljs$core$IFn$_invoke$arity$1(tx_response_28656) : f_28678.call(null,tx_response_28656));
}catch (e28596){var e_28679 = e28596;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28679,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28680 = cljs.core.next(seq__28577_28670__$1);
var G__28681 = null;
var G__28682 = (0);
var G__28683 = (0);
seq__28577_28657 = G__28680;
chunk__28578_28658 = G__28681;
count__28579_28659 = G__28682;
i__28580_28660 = G__28683;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28684 = seq__28533;
var G__28685 = chunk__28534;
var G__28686 = count__28535;
var G__28687 = (i__28536 + (1));
seq__28533 = G__28684;
chunk__28534 = G__28685;
count__28535 = G__28686;
i__28536 = G__28687;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__28533);
if(temp__5753__auto____$1){
var seq__28533__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__28533__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__28533__$1);
var G__28688 = cljs.core.chunk_rest(seq__28533__$1);
var G__28689 = c__4679__auto__;
var G__28690 = cljs.core.count(c__4679__auto__);
var G__28691 = (0);
seq__28533 = G__28688;
chunk__28534 = G__28689;
count__28535 = G__28690;
i__28536 = G__28691;
continue;
} else {
var tid = cljs.core.first(seq__28533__$1);
var temp__5753__auto___28692__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___28692__$2)){
var keyed_callbacks_28693 = temp__5753__auto___28692__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28694 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28597_28695 = cljs.core.seq(keyed_callbacks_28693);
var chunk__28598_28696 = null;
var count__28599_28697 = (0);
var i__28600_28698 = (0);
while(true){
if((i__28600_28698 < count__28599_28697)){
var vec__28609_28699 = chunk__28598_28696.cljs$core$IIndexed$_nth$arity$2(null,i__28600_28698);
var k_28700 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28609_28699,(0),null);
var f_28701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28609_28699,(1),null);
try{(f_28701.cljs$core$IFn$_invoke$arity$1 ? f_28701.cljs$core$IFn$_invoke$arity$1(tx_response_28694) : f_28701.call(null,tx_response_28694));
}catch (e28612){var e_28702 = e28612;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28702,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28703 = seq__28597_28695;
var G__28704 = chunk__28598_28696;
var G__28705 = count__28599_28697;
var G__28706 = (i__28600_28698 + (1));
seq__28597_28695 = G__28703;
chunk__28598_28696 = G__28704;
count__28599_28697 = G__28705;
i__28600_28698 = G__28706;
continue;
} else {
var temp__5753__auto___28707__$3 = cljs.core.seq(seq__28597_28695);
if(temp__5753__auto___28707__$3){
var seq__28597_28708__$1 = temp__5753__auto___28707__$3;
if(cljs.core.chunked_seq_QMARK_(seq__28597_28708__$1)){
var c__4679__auto___28709 = cljs.core.chunk_first(seq__28597_28708__$1);
var G__28710 = cljs.core.chunk_rest(seq__28597_28708__$1);
var G__28711 = c__4679__auto___28709;
var G__28712 = cljs.core.count(c__4679__auto___28709);
var G__28713 = (0);
seq__28597_28695 = G__28710;
chunk__28598_28696 = G__28711;
count__28599_28697 = G__28712;
i__28600_28698 = G__28713;
continue;
} else {
var vec__28613_28714 = cljs.core.first(seq__28597_28708__$1);
var k_28715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28613_28714,(0),null);
var f_28716 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28613_28714,(1),null);
try{(f_28716.cljs$core$IFn$_invoke$arity$1 ? f_28716.cljs$core$IFn$_invoke$arity$1(tx_response_28694) : f_28716.call(null,tx_response_28694));
}catch (e28616){var e_28717 = e28616;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28717,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28718 = cljs.core.next(seq__28597_28708__$1);
var G__28719 = null;
var G__28720 = (0);
var G__28721 = (0);
seq__28597_28695 = G__28718;
chunk__28598_28696 = G__28719;
count__28599_28697 = G__28720;
i__28600_28698 = G__28721;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28722 = cljs.core.next(seq__28533__$1);
var G__28723 = null;
var G__28724 = (0);
var G__28725 = (0);
seq__28533 = G__28722;
chunk__28534 = G__28723;
count__28535 = G__28724;
i__28536 = G__28725;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__28528_28653 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28528_28653.cljs$core$IFn$_invoke$arity$4 ? fexpr__28528_28653.cljs$core$IFn$_invoke$arity$4(G__28529_28649,G__28530_28650,G__28531_28651,G__28532_28652) : fexpr__28528_28653.call(null,G__28529_28649,G__28530_28650,G__28531_28651,G__28532_28652));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28726 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2749__auto___28727 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28633){
var state_val_28634 = (state_28633[(1)]);
if((state_val_28634 === (1))){
var state_28633__$1 = state_28633;
var statearr_28635_28728 = state_28633__$1;
(statearr_28635_28728[(2)] = null);

(statearr_28635_28728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28634 === (2))){
var inst_28618 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28633__$1 = state_28633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28633__$1,(4),inst_28618);
} else {
if((state_val_28634 === (3))){
var inst_28631 = (state_28633[(2)]);
var state_28633__$1 = state_28633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28633__$1,inst_28631);
} else {
if((state_val_28634 === (4))){
var inst_28620 = (state_28633[(7)]);
var inst_28620__$1 = (state_28633[(2)]);
var inst_28621 = (inst_28620__$1 == null);
var state_28633__$1 = (function (){var statearr_28636 = state_28633;
(statearr_28636[(7)] = inst_28620__$1);

return statearr_28636;
})();
if(cljs.core.truth_(inst_28621)){
var statearr_28637_28729 = state_28633__$1;
(statearr_28637_28729[(1)] = (5));

} else {
var statearr_28638_28730 = state_28633__$1;
(statearr_28638_28730[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28634 === (5))){
var inst_28623 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28624 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28623], 0));
var state_28633__$1 = state_28633;
var statearr_28639_28731 = state_28633__$1;
(statearr_28639_28731[(2)] = inst_28624);

(statearr_28639_28731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28634 === (6))){
var inst_28620 = (state_28633[(7)]);
var inst_28626 = (transact_handler_28726.cljs$core$IFn$_invoke$arity$2 ? transact_handler_28726.cljs$core$IFn$_invoke$arity$2(conn,inst_28620) : transact_handler_28726.call(null,conn,inst_28620));
var state_28633__$1 = (function (){var statearr_28640 = state_28633;
(statearr_28640[(8)] = inst_28626);

return statearr_28640;
})();
var statearr_28641_28732 = state_28633__$1;
(statearr_28641_28732[(2)] = null);

(statearr_28641_28732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28634 === (7))){
var inst_28629 = (state_28633[(2)]);
var state_28633__$1 = state_28633;
var statearr_28642_28733 = state_28633__$1;
(statearr_28642_28733[(2)] = inst_28629);

(statearr_28642_28733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_28643 = [null,null,null,null,null,null,null,null,null];
(statearr_28643[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_28643[(1)] = (1));

return statearr_28643;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_28633){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28633);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28644){var ex__2730__auto__ = e28644;
var statearr_28645_28734 = state_28633;
(statearr_28645_28734[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28633[(4)]))){
var statearr_28646_28735 = state_28633;
(statearr_28646_28735[(1)] = cljs.core.first((state_28633[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28736 = state_28633;
state_28633 = G__28736;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_28633){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_28633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28647 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28647[(6)] = c__2749__auto___28727);

return statearr_28647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(p__28738){
var map__28739 = p__28738;
var map__28739__$1 = cljs.core.__destructure_map(map__28739);
var session = map__28739__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28739__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p1__28737_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__28737_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28737_SHARP_) + (1))], 0));
}));

var or__4253__auto__ = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var _ = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (st){
if(cljs.core.truth_(new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(st))){
return st;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(st,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
}
}));
return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state);
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28742 = arguments.length;
switch (G__28742) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28743 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28740_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__28740_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28743);
} else {
return G__28743;
}
})();
var seq__28744 = cljs.core.seq(sessions);
var chunk__28745 = null;
var count__28746 = (0);
var i__28747 = (0);
while(true){
if((i__28747 < count__28746)){
var session = chunk__28745.cljs$core$IIndexed$_nth$arity$2(null,i__28747);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28749 = seq__28744;
var G__28750 = chunk__28745;
var G__28751 = count__28746;
var G__28752 = (i__28747 + (1));
seq__28744 = G__28749;
chunk__28745 = G__28750;
count__28746 = G__28751;
i__28747 = G__28752;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__28744);
if(temp__5753__auto__){
var seq__28744__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28744__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__28744__$1);
var G__28753 = cljs.core.chunk_rest(seq__28744__$1);
var G__28754 = c__4679__auto__;
var G__28755 = cljs.core.count(c__4679__auto__);
var G__28756 = (0);
seq__28744 = G__28753;
chunk__28745 = G__28754;
count__28746 = G__28755;
i__28747 = G__28756;
continue;
} else {
var session = cljs.core.first(seq__28744__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28757 = cljs.core.next(seq__28744__$1);
var G__28758 = null;
var G__28759 = (0);
var G__28760 = (0);
seq__28744 = G__28757;
chunk__28745 = G__28758;
count__28746 = G__28759;
i__28747 = G__28760;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
