// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15862){
var state_val_15863 = (state_15862[(1)]);
if((state_val_15863 === (1))){
var state_15862__$1 = state_15862;
var statearr_15864_15878 = state_15862__$1;
(statearr_15864_15878[(2)] = null);

(statearr_15864_15878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15863 === (2))){
var _ = (function (){var statearr_15865 = state_15862;
(statearr_15865[(4)] = cljs.core.cons((5),(state_15862[(4)])));

return statearr_15865;
})();
var inst_15853 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_15862__$1 = state_15862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15862__$1,(6),inst_15853);
} else {
if((state_val_15863 === (3))){
var inst_15860 = (state_15862[(2)]);
var state_15862__$1 = state_15862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15862__$1,inst_15860);
} else {
if((state_val_15863 === (4))){
var inst_15847 = (state_15862[(2)]);
var state_15862__$1 = state_15862;
var statearr_15867_15879 = state_15862__$1;
(statearr_15867_15879[(2)] = inst_15847);

(statearr_15867_15879[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15863 === (5))){
var _ = (function (){var statearr_15868 = state_15862;
(statearr_15868[(4)] = cljs.core.rest((state_15862[(4)])));

return statearr_15868;
})();
var state_15862__$1 = state_15862;
var ex15866 = (state_15862__$1[(2)]);
var statearr_15869_15880 = state_15862__$1;
(statearr_15869_15880[(5)] = ex15866);


if((ex15866 instanceof Error)){
var statearr_15870_15881 = state_15862__$1;
(statearr_15870_15881[(1)] = (4));

(statearr_15870_15881[(5)] = null);

} else {
throw ex15866;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15863 === (6))){
var inst_15855 = (state_15862[(2)]);
var inst_15856 = fluree.db.util.async.throw_err(inst_15855);
var inst_15857 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_15856);
var _ = (function (){var statearr_15871 = state_15862;
(statearr_15871[(4)] = cljs.core.rest((state_15862[(4)])));

return statearr_15871;
})();
var state_15862__$1 = state_15862;
var statearr_15872_15882 = state_15862__$1;
(statearr_15872_15882[(2)] = inst_15857);

(statearr_15872_15882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0 = (function (){
var statearr_15873 = [null,null,null,null,null,null,null];
(statearr_15873[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__);

(statearr_15873[(1)] = (1));

return statearr_15873;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1 = (function (state_15862){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15862);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15874){var ex__2730__auto__ = e15874;
var statearr_15875_15883 = state_15862;
(statearr_15875_15883[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15862[(4)]))){
var statearr_15876_15884 = state_15862;
(statearr_15876_15884[(1)] = cljs.core.first((state_15862[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15885 = state_15862;
state_15862 = G__15885;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = function(state_15862){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1.call(this,state_15862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15877 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15877[(6)] = c__2749__auto__);

return statearr_15877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15917){
var state_val_15918 = (state_15917[(1)]);
if((state_val_15918 === (7))){
var inst_15901 = (state_15917[(7)]);
var inst_15903 = cljs.core.empty_QMARK_(inst_15901);
var inst_15904 = (!(inst_15903));
var state_15917__$1 = state_15917;
var statearr_15919_15943 = state_15917__$1;
(statearr_15919_15943[(2)] = inst_15904);

(statearr_15919_15943[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (1))){
var state_15917__$1 = state_15917;
var statearr_15920_15944 = state_15917__$1;
(statearr_15920_15944[(2)] = null);

(statearr_15920_15944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (4))){
var inst_15887 = (state_15917[(2)]);
var state_15917__$1 = state_15917;
var statearr_15921_15945 = state_15917__$1;
(statearr_15921_15945[(2)] = inst_15887);

(statearr_15921_15945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (6))){
var inst_15893 = (state_15917[(8)]);
var inst_15901 = (state_15917[(7)]);
var inst_15899 = (state_15917[(2)]);
var inst_15900 = fluree.db.util.async.throw_err(inst_15899);
var inst_15901__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_15893,inst_15900);
var state_15917__$1 = (function (){var statearr_15922 = state_15917;
(statearr_15922[(7)] = inst_15901__$1);

return statearr_15922;
})();
if(cljs.core.truth_(inst_15901__$1)){
var statearr_15923_15946 = state_15917__$1;
(statearr_15923_15946[(1)] = (7));

} else {
var statearr_15924_15947 = state_15917__$1;
(statearr_15924_15947[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (3))){
var inst_15915 = (state_15917[(2)]);
var state_15917__$1 = state_15917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15917__$1,inst_15915);
} else {
if((state_val_15918 === (12))){
var inst_15912 = (state_15917[(2)]);
var _ = (function (){var statearr_15925 = state_15917;
(statearr_15925[(4)] = cljs.core.rest((state_15917[(4)])));

return statearr_15925;
})();
var state_15917__$1 = state_15917;
var statearr_15926_15948 = state_15917__$1;
(statearr_15926_15948[(2)] = inst_15912);

(statearr_15926_15948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (2))){
var _ = (function (){var statearr_15927 = state_15917;
(statearr_15927[(4)] = cljs.core.cons((5),(state_15917[(4)])));

return statearr_15927;
})();
var inst_15893 = (function (){return (function (p1__15886_SHARP_){
return p1__15886_SHARP_.o;
});
})();
var inst_15894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15895 = [pred_id];
var inst_15896 = (new cljs.core.PersistentVector(null,1,(5),inst_15894,inst_15895,null));
var inst_15897 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15896);
var state_15917__$1 = (function (){var statearr_15928 = state_15917;
(statearr_15928[(8)] = inst_15893);

return statearr_15928;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15917__$1,(6),inst_15897);
} else {
if((state_val_15918 === (11))){
var state_15917__$1 = state_15917;
var statearr_15930_15949 = state_15917__$1;
(statearr_15930_15949[(2)] = true);

(statearr_15930_15949[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (9))){
var inst_15907 = (state_15917[(2)]);
var state_15917__$1 = state_15917;
if(cljs.core.truth_(inst_15907)){
var statearr_15931_15950 = state_15917__$1;
(statearr_15931_15950[(1)] = (10));

} else {
var statearr_15932_15951 = state_15917__$1;
(statearr_15932_15951[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (5))){
var _ = (function (){var statearr_15933 = state_15917;
(statearr_15933[(4)] = cljs.core.rest((state_15917[(4)])));

return statearr_15933;
})();
var state_15917__$1 = state_15917;
var ex15929 = (state_15917__$1[(2)]);
var statearr_15934_15952 = state_15917__$1;
(statearr_15934_15952[(5)] = ex15929);


if((ex15929 instanceof Error)){
var statearr_15935_15953 = state_15917__$1;
(statearr_15935_15953[(1)] = (4));

(statearr_15935_15953[(5)] = null);

} else {
throw ex15929;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (10))){
var inst_15901 = (state_15917[(7)]);
var inst_15909 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_15901);
var state_15917__$1 = state_15917;
var statearr_15936_15954 = state_15917__$1;
(statearr_15936_15954[(2)] = inst_15909);

(statearr_15936_15954[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (8))){
var inst_15901 = (state_15917[(7)]);
var state_15917__$1 = state_15917;
var statearr_15937_15955 = state_15917__$1;
(statearr_15937_15955[(2)] = inst_15901);

(statearr_15937_15955[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_15938 = [null,null,null,null,null,null,null,null,null];
(statearr_15938[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__);

(statearr_15938[(1)] = (1));

return statearr_15938;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1 = (function (state_15917){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15917);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15939){var ex__2730__auto__ = e15939;
var statearr_15940_15956 = state_15917;
(statearr_15940_15956[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15917[(4)]))){
var statearr_15941_15957 = state_15917;
(statearr_15941_15957[(1)] = cljs.core.first((state_15917[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15958 = state_15917;
state_15917 = G__15958;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = function(state_15917){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1.call(this,state_15917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15942 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15942[(6)] = c__2749__auto__);

return statearr_15942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16039){
var state_val_16040 = (state_16039[(1)]);
if((state_val_16040 === (7))){
var state_16039__$1 = state_16039;
var statearr_16041_16079 = state_16039__$1;
(statearr_16041_16079[(2)] = flakes);

(statearr_16041_16079[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (20))){
var inst_15996 = (state_16039[(7)]);
var inst_16029 = (state_16039[(2)]);
var inst_15988 = inst_15996;
var inst_15989 = inst_16029;
var state_16039__$1 = (function (){var statearr_16042 = state_16039;
(statearr_16042[(8)] = inst_15989);

(statearr_16042[(9)] = inst_15988);

return statearr_16042;
})();
var statearr_16043_16080 = state_16039__$1;
(statearr_16043_16080[(2)] = null);

(statearr_16043_16080[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (1))){
var state_16039__$1 = state_16039;
var statearr_16044_16081 = state_16039__$1;
(statearr_16044_16081[(2)] = null);

(statearr_16044_16081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (4))){
var inst_15961 = (state_16039[(2)]);
var state_16039__$1 = state_16039;
var statearr_16045_16082 = state_16039__$1;
(statearr_16045_16082[(2)] = inst_15961);

(statearr_16045_16082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (15))){
var inst_15995 = (state_16039[(10)]);
var inst_16013 = inst_15995.o;
var state_16039__$1 = state_16039;
var statearr_16046_16083 = state_16039__$1;
(statearr_16046_16083[(2)] = inst_16013);

(statearr_16046_16083[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (13))){
var inst_16032 = (state_16039[(2)]);
var state_16039__$1 = state_16039;
var statearr_16047_16084 = state_16039__$1;
(statearr_16047_16084[(2)] = inst_16032);

(statearr_16047_16084[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (6))){
var inst_15968 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16039__$1 = state_16039;
var statearr_16048_16085 = state_16039__$1;
(statearr_16048_16085[(2)] = inst_15968);

(statearr_16048_16085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (17))){
var inst_16010 = (state_16039[(2)]);
var inst_16011 = fluree.db.util.async.throw_err(inst_16010);
var state_16039__$1 = state_16039;
var statearr_16049_16086 = state_16039__$1;
(statearr_16049_16086[(2)] = inst_16011);

(statearr_16049_16086[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (3))){
var inst_16037 = (state_16039[(2)]);
var state_16039__$1 = state_16039;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16039__$1,inst_16037);
} else {
if((state_val_16040 === (12))){
var inst_16002 = (state_16039[(11)]);
var inst_15995 = (state_16039[(10)]);
var inst_16000 = inst_15995.p;
var inst_16001 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16000);
var inst_16002__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_16001);
var inst_16003 = inst_15995.op;
var inst_16004 = inst_16003 === false;
var inst_16005 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_16002__$1);
var state_16039__$1 = (function (){var statearr_16050 = state_16039;
(statearr_16050[(11)] = inst_16002__$1);

(statearr_16050[(12)] = inst_16004);

return statearr_16050;
})();
if(inst_16005){
var statearr_16051_16087 = state_16039__$1;
(statearr_16051_16087[(1)] = (14));

} else {
var statearr_16052_16088 = state_16039__$1;
(statearr_16052_16088[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (2))){
var _ = (function (){var statearr_16053 = state_16039;
(statearr_16053[(4)] = cljs.core.cons((5),(state_16039[(4)])));

return statearr_16053;
})();
var state_16039__$1 = state_16039;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16054_16089 = state_16039__$1;
(statearr_16054_16089[(1)] = (6));

} else {
var statearr_16055_16090 = state_16039__$1;
(statearr_16055_16090[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (19))){
var inst_15989 = (state_16039[(8)]);
var inst_16002 = (state_16039[(11)]);
var inst_15995 = (state_16039[(10)]);
var inst_16015 = (state_16039[(13)]);
var inst_16023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16024 = inst_15995.s;
var inst_16025 = [inst_16024,inst_16002,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16026 = (new cljs.core.PersistentVector(null,3,(5),inst_16023,inst_16025,null));
var inst_16027 = cljs.core.assoc_in(inst_15989,inst_16026,inst_16015);
var state_16039__$1 = state_16039;
var statearr_16056_16091 = state_16039__$1;
(statearr_16056_16091[(2)] = inst_16027);

(statearr_16056_16091[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (11))){
var inst_15989 = (state_16039[(8)]);
var state_16039__$1 = state_16039;
var statearr_16058_16092 = state_16039__$1;
(statearr_16058_16092[(2)] = inst_15989);

(statearr_16058_16092[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (9))){
var inst_15988 = (state_16039[(9)]);
var inst_15995 = (state_16039[(10)]);
var inst_15994 = cljs.core.seq(inst_15988);
var inst_15995__$1 = cljs.core.first(inst_15994);
var inst_15996 = cljs.core.next(inst_15994);
var inst_15997 = cljs.core.not(inst_15995__$1);
var state_16039__$1 = (function (){var statearr_16059 = state_16039;
(statearr_16059[(7)] = inst_15996);

(statearr_16059[(10)] = inst_15995__$1);

return statearr_16059;
})();
if(inst_15997){
var statearr_16060_16093 = state_16039__$1;
(statearr_16060_16093[(1)] = (11));

} else {
var statearr_16061_16094 = state_16039__$1;
(statearr_16061_16094[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (5))){
var _ = (function (){var statearr_16062 = state_16039;
(statearr_16062[(4)] = cljs.core.rest((state_16039[(4)])));

return statearr_16062;
})();
var state_16039__$1 = state_16039;
var ex16057 = (state_16039__$1[(2)]);
var statearr_16063_16095 = state_16039__$1;
(statearr_16063_16095[(5)] = ex16057);


if((ex16057 instanceof Error)){
var statearr_16064_16096 = state_16039__$1;
(statearr_16064_16096[(1)] = (4));

(statearr_16064_16096[(5)] = null);

} else {
throw ex16057;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (14))){
var inst_15995 = (state_16039[(10)]);
var inst_16007 = inst_15995.o;
var inst_16008 = fluree.db.query.schema.convert_type_to_kw(inst_16007,db);
var state_16039__$1 = state_16039;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16039__$1,(17),inst_16008);
} else {
if((state_val_16040 === (16))){
var inst_16004 = (state_16039[(12)]);
var inst_16015 = (state_16039[(2)]);
var state_16039__$1 = (function (){var statearr_16065 = state_16039;
(statearr_16065[(13)] = inst_16015);

return statearr_16065;
})();
if(cljs.core.truth_(inst_16004)){
var statearr_16066_16097 = state_16039__$1;
(statearr_16066_16097[(1)] = (18));

} else {
var statearr_16067_16098 = state_16039__$1;
(statearr_16067_16098[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (10))){
var inst_16034 = (state_16039[(2)]);
var _ = (function (){var statearr_16068 = state_16039;
(statearr_16068[(4)] = cljs.core.rest((state_16039[(4)])));

return statearr_16068;
})();
var state_16039__$1 = state_16039;
var statearr_16069_16099 = state_16039__$1;
(statearr_16069_16099[(2)] = inst_16034);

(statearr_16069_16099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (18))){
var inst_15989 = (state_16039[(8)]);
var inst_16002 = (state_16039[(11)]);
var inst_15995 = (state_16039[(10)]);
var inst_16015 = (state_16039[(13)]);
var inst_16017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16018 = inst_15995.s;
var inst_16019 = [inst_16018,inst_16002,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16020 = (new cljs.core.PersistentVector(null,3,(5),inst_16017,inst_16019,null));
var inst_16021 = cljs.core.assoc_in(inst_15989,inst_16020,inst_16015);
var state_16039__$1 = state_16039;
var statearr_16070_16100 = state_16039__$1;
(statearr_16070_16100[(2)] = inst_16021);

(statearr_16070_16100[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16040 === (8))){
var inst_15971 = (state_16039[(2)]);
var inst_15972 = cljs.core.PersistentHashSet.EMPTY;
var inst_15973 = cljs.core.vals(tempids);
var inst_15974 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15972,inst_15973);
var inst_15975 = (function (){var pred_flakes = inst_15971;
var is_new_QMARK_ = inst_15974;
return (function (p1__15960_SHARP_,p2__15959_SHARP_){
var f = p2__15959_SHARP_;
return cljs.core.assoc_in(p1__15960_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__16071 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__16071) : is_new_QMARK_.call(null,G__16071));
})()));
});
})();
var inst_15976 = cljs.core.PersistentHashMap.EMPTY;
var inst_15977 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_15975,inst_15976,inst_15971);
var inst_15985 = cljs.core.seq(inst_15971);
var inst_15986 = cljs.core.first(inst_15985);
var inst_15987 = cljs.core.next(inst_15985);
var inst_15988 = inst_15971;
var inst_15989 = inst_15977;
var state_16039__$1 = (function (){var statearr_16072 = state_16039;
(statearr_16072[(8)] = inst_15989);

(statearr_16072[(14)] = inst_15987);

(statearr_16072[(9)] = inst_15988);

(statearr_16072[(15)] = inst_15986);

return statearr_16072;
})();
var statearr_16073_16101 = state_16039__$1;
(statearr_16073_16101[(2)] = null);

(statearr_16073_16101[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0 = (function (){
var statearr_16074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16074[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__);

(statearr_16074[(1)] = (1));

return statearr_16074;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1 = (function (state_16039){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16039);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16075){var ex__2730__auto__ = e16075;
var statearr_16076_16102 = state_16039;
(statearr_16076_16102[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16039[(4)]))){
var statearr_16077_16103 = state_16039;
(statearr_16077_16103[(1)] = cljs.core.first((state_16039[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16104 = state_16039;
state_16039 = G__16104;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = function(state_16039){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1.call(this,state_16039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16078 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16078[(6)] = c__2749__auto__);

return statearr_16078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16106 = arguments.length;
switch (G__16106) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16109 = arguments.length;
switch (G__16109) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16421){
var state_val_16422 = (state_16421[(1)]);
if((state_val_16422 === (121))){
var inst_16376 = (state_16421[(7)]);
var state_16421__$1 = state_16421;
var statearr_16423_16616 = state_16421__$1;
(statearr_16423_16616[(2)] = inst_16376);

(statearr_16423_16616[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (65))){
var inst_16275 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16275)){
var statearr_16424_16617 = state_16421__$1;
(statearr_16424_16617[(1)] = (66));

} else {
var statearr_16425_16618 = state_16421__$1;
(statearr_16425_16618[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (70))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16285 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16286 = (inst_16281.cljs$core$IFn$_invoke$arity$5 ? inst_16281.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16285,null) : inst_16281.call(null,cljs.core.PersistentArrayMap,null,3,inst_16285,null));
var inst_16287 = (inst_16281.cljs$core$IFn$_invoke$arity$4 ? inst_16281.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16286,null) : inst_16281.call(null,cljs.core.PersistentHashSet,null,inst_16286,null));
var inst_16288 = (inst_16287.cljs$core$IFn$_invoke$arity$1 ? inst_16287.cljs$core$IFn$_invoke$arity$1(inst_16280) : inst_16287.call(null,inst_16280));
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16288)){
var statearr_16426_16619 = state_16421__$1;
(statearr_16426_16619[(1)] = (72));

} else {
var statearr_16427_16620 = state_16421__$1;
(statearr_16427_16620[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (62))){
var inst_16265 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16428_16621 = state_16421__$1;
(statearr_16428_16621[(2)] = inst_16265);

(statearr_16428_16621[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (74))){
var inst_16371 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16429_16622 = state_16421__$1;
(statearr_16429_16622[(2)] = inst_16371);

(statearr_16429_16622[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (110))){
var inst_16398 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16398)){
var statearr_16430_16623 = state_16421__$1;
(statearr_16430_16623[(1)] = (117));

} else {
var statearr_16431_16624 = state_16421__$1;
(statearr_16431_16624[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (7))){
var inst_16416 = (state_16421[(2)]);
var _ = (function (){var statearr_16432 = state_16421;
(statearr_16432[(4)] = cljs.core.rest((state_16421[(4)])));

return statearr_16432;
})();
var state_16421__$1 = state_16421;
var statearr_16433_16625 = state_16421__$1;
(statearr_16433_16625[(2)] = inst_16416);

(statearr_16433_16625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (59))){
var inst_16269 = (state_16421[(10)]);
var inst_16149 = (state_16421[(11)]);
var inst_16268 = (state_16421[(2)]);
var inst_16269__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16149);
var state_16421__$1 = (function (){var statearr_16434 = state_16421;
(statearr_16434[(10)] = inst_16269__$1);

(statearr_16434[(12)] = inst_16268);

return statearr_16434;
})();
if(cljs.core.truth_(inst_16269__$1)){
var statearr_16435_16626 = state_16421__$1;
(statearr_16435_16626[(1)] = (63));

} else {
var statearr_16436_16627 = state_16421__$1;
(statearr_16436_16627[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (86))){
var inst_16311 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16437_16628 = state_16421__$1;
(statearr_16437_16628[(2)] = inst_16311);

(statearr_16437_16628[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (20))){
var inst_16149 = (state_16421[(11)]);
var inst_16175 = (state_16421[(13)]);
var inst_16175__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16149);
var state_16421__$1 = (function (){var statearr_16438 = state_16421;
(statearr_16438[(13)] = inst_16175__$1);

return statearr_16438;
})();
if(cljs.core.truth_(inst_16175__$1)){
var statearr_16439_16629 = state_16421__$1;
(statearr_16439_16629[(1)] = (23));

} else {
var statearr_16440_16630 = state_16421__$1;
(statearr_16440_16630[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (72))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16290 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16280,inst_16281,throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16441_16631 = state_16421__$1;
(statearr_16441_16631[(2)] = inst_16290);

(statearr_16441_16631[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (58))){
var inst_16230 = (state_16421[(14)]);
var state_16421__$1 = state_16421;
var statearr_16442_16632 = state_16421__$1;
(statearr_16442_16632[(2)] = inst_16230);

(statearr_16442_16632[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (60))){
var inst_16137 = (state_16421[(15)]);
var inst_16148 = (state_16421[(16)]);
var inst_16256 = fluree.db.dbproto._p_prop(inst_16137,new cljs.core.Keyword(null,"name","name",1843675177),inst_16148);
var inst_16257 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16256)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16258 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16259 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16260 = cljs.core.PersistentHashMap.fromArrays(inst_16258,inst_16259);
var inst_16261 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16257,inst_16260);
var inst_16262 = (function(){throw inst_16261})();
var state_16421__$1 = state_16421;
var statearr_16443_16633 = state_16421__$1;
(statearr_16443_16633[(2)] = inst_16262);

(statearr_16443_16633[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (27))){
var inst_16178 = (state_16421[(17)]);
var state_16421__$1 = state_16421;
var statearr_16444_16634 = state_16421__$1;
(statearr_16444_16634[(2)] = inst_16178);

(statearr_16444_16634[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (1))){
var state_16421__$1 = state_16421;
var statearr_16445_16635 = state_16421__$1;
(statearr_16445_16635[(2)] = null);

(statearr_16445_16635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (69))){
var inst_16268 = (state_16421[(12)]);
var state_16421__$1 = state_16421;
var statearr_16446_16636 = state_16421__$1;
(statearr_16446_16636[(2)] = inst_16268);

(statearr_16446_16636[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (101))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16349 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16280,inst_16281,throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16447_16637 = state_16421__$1;
(statearr_16447_16637[(2)] = inst_16349);

(statearr_16447_16637[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (24))){
var inst_16175 = (state_16421[(13)]);
var state_16421__$1 = state_16421;
var statearr_16448_16638 = state_16421__$1;
(statearr_16448_16638[(2)] = inst_16175);

(statearr_16448_16638[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (102))){
var inst_16351 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16449_16639 = state_16421__$1;
(statearr_16449_16639[(2)] = inst_16351);

(statearr_16449_16639[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (55))){
var inst_16247 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16450_16640 = state_16421__$1;
(statearr_16450_16640[(2)] = inst_16247);

(statearr_16450_16640[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (85))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16309 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16280,inst_16281,throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16451_16641 = state_16421__$1;
(statearr_16451_16641[(2)] = inst_16309);

(statearr_16451_16641[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (39))){
var inst_16212 = (state_16421[(18)]);
var state_16421__$1 = state_16421;
var statearr_16452_16642 = state_16421__$1;
(statearr_16452_16642[(2)] = inst_16212);

(statearr_16452_16642[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (88))){
var inst_16268 = (state_16421[(12)]);
var state_16421__$1 = state_16421;
var statearr_16453_16643 = state_16421__$1;
(statearr_16453_16643[(2)] = inst_16268);

(statearr_16453_16643[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (46))){
var inst_16149 = (state_16421[(11)]);
var inst_16231 = (state_16421[(19)]);
var inst_16230 = (state_16421[(2)]);
var inst_16231__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16149);
var state_16421__$1 = (function (){var statearr_16454 = state_16421;
(statearr_16454[(14)] = inst_16230);

(statearr_16454[(19)] = inst_16231__$1);

return statearr_16454;
})();
if(cljs.core.truth_(inst_16231__$1)){
var statearr_16455_16644 = state_16421__$1;
(statearr_16455_16644[(1)] = (47));

} else {
var statearr_16456_16645 = state_16421__$1;
(statearr_16456_16645[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (4))){
var inst_16110 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16457_16646 = state_16421__$1;
(statearr_16457_16646[(2)] = inst_16110);

(statearr_16457_16646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (77))){
var inst_16369 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16458_16647 = state_16421__$1;
(statearr_16458_16647[(2)] = inst_16369);

(statearr_16458_16647[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (106))){
var inst_16361 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16459_16648 = state_16421__$1;
(statearr_16459_16648[(2)] = inst_16361);

(statearr_16459_16648[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (119))){
var inst_16147 = (state_16421[(20)]);
var inst_16411 = (state_16421[(2)]);
var inst_16136 = inst_16147;
var inst_16137 = inst_16411;
var state_16421__$1 = (function (){var statearr_16460 = state_16421;
(statearr_16460[(15)] = inst_16137);

(statearr_16460[(21)] = inst_16136);

return statearr_16460;
})();
var statearr_16461_16649 = state_16421__$1;
(statearr_16461_16649[(2)] = null);

(statearr_16461_16649[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (95))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16333 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16334 = (inst_16281.cljs$core$IFn$_invoke$arity$5 ? inst_16281.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16333,null) : inst_16281.call(null,cljs.core.PersistentArrayMap,null,5,inst_16333,null));
var inst_16335 = (inst_16281.cljs$core$IFn$_invoke$arity$4 ? inst_16281.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16334,null) : inst_16281.call(null,cljs.core.PersistentHashSet,null,inst_16334,null));
var inst_16336 = (inst_16335.cljs$core$IFn$_invoke$arity$1 ? inst_16335.cljs$core$IFn$_invoke$arity$1(inst_16280) : inst_16335.call(null,inst_16280));
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16336)){
var statearr_16462_16650 = state_16421__$1;
(statearr_16462_16650[(1)] = (96));

} else {
var statearr_16463_16651 = state_16421__$1;
(statearr_16463_16651[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (54))){
var inst_16238 = (state_16421[(22)]);
var state_16421__$1 = state_16421;
var statearr_16464_16652 = state_16421__$1;
(statearr_16464_16652[(2)] = inst_16238);

(statearr_16464_16652[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (92))){
var inst_16268 = (state_16421[(12)]);
var state_16421__$1 = state_16421;
var statearr_16465_16653 = state_16421__$1;
(statearr_16465_16653[(2)] = inst_16268);

(statearr_16465_16653[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (104))){
var inst_16268 = (state_16421[(12)]);
var state_16421__$1 = state_16421;
var statearr_16466_16654 = state_16421__$1;
(statearr_16466_16654[(2)] = inst_16268);

(statearr_16466_16654[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (15))){
var inst_16157 = (state_16421[(23)]);
var state_16421__$1 = state_16421;
var statearr_16467_16655 = state_16421__$1;
(statearr_16467_16655[(2)] = inst_16157);

(statearr_16467_16655[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (48))){
var inst_16231 = (state_16421[(19)]);
var state_16421__$1 = state_16421;
var statearr_16468_16656 = state_16421__$1;
(statearr_16468_16656[(2)] = inst_16231);

(statearr_16468_16656[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (50))){
var inst_16149 = (state_16421[(11)]);
var inst_16238 = (state_16421[(22)]);
var inst_16236 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16237 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16236);
var inst_16238__$1 = inst_16237 === true;
var state_16421__$1 = (function (){var statearr_16469 = state_16421;
(statearr_16469[(22)] = inst_16238__$1);

return statearr_16469;
})();
if(cljs.core.truth_(inst_16238__$1)){
var statearr_16470_16657 = state_16421__$1;
(statearr_16470_16657[(1)] = (53));

} else {
var statearr_16471_16658 = state_16421__$1;
(statearr_16471_16658[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (116))){
var inst_16392 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16472_16659 = state_16421__$1;
(statearr_16472_16659[(2)] = inst_16392);

(statearr_16472_16659[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (75))){
var inst_16281 = (state_16421[(8)]);
var state_16421__$1 = state_16421;
var G__16473_16660 = inst_16281;
var G__16473_16661__$1 = (((G__16473_16660 instanceof cljs.core.Keyword))?G__16473_16660.fqn:null);
switch (G__16473_16661__$1) {
case "long":
var statearr_16474_16663 = state_16421__$1;
(statearr_16474_16663[(1)] = (79));


break;
case "bigint":
var statearr_16475_16664 = state_16421__$1;
(statearr_16475_16664[(1)] = (83));


break;
case "double":
var statearr_16476_16665 = state_16421__$1;
(statearr_16476_16665[(1)] = (87));


break;
case "float":
var statearr_16477_16666 = state_16421__$1;
(statearr_16477_16666[(1)] = (91));


break;
case "bigdec":
var statearr_16478_16667 = state_16421__$1;
(statearr_16478_16667[(1)] = (95));


break;
case "string":
var statearr_16479_16668 = state_16421__$1;
(statearr_16479_16668[(1)] = (99));


break;
case "instant":
var statearr_16480_16669 = state_16421__$1;
(statearr_16480_16669[(1)] = (103));


break;
default:
var statearr_16481_16670 = state_16421__$1;
(statearr_16481_16670[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (99))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16343 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16344 = (inst_16281.cljs$core$IFn$_invoke$arity$5 ? inst_16281.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16343,null) : inst_16281.call(null,cljs.core.PersistentArrayMap,null,5,inst_16343,null));
var inst_16345 = (inst_16281.cljs$core$IFn$_invoke$arity$4 ? inst_16281.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16344,null) : inst_16281.call(null,cljs.core.PersistentHashSet,null,inst_16344,null));
var inst_16346 = (inst_16345.cljs$core$IFn$_invoke$arity$1 ? inst_16345.cljs$core$IFn$_invoke$arity$1(inst_16280) : inst_16345.call(null,inst_16280));
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16346)){
var statearr_16482_16671 = state_16421__$1;
(statearr_16482_16671[(1)] = (100));

} else {
var statearr_16483_16672 = state_16421__$1;
(statearr_16483_16672[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (21))){
var inst_16173 = (state_16421[(24)]);
var state_16421__$1 = state_16421;
var statearr_16484_16673 = state_16421__$1;
(statearr_16484_16673[(2)] = inst_16173);

(statearr_16484_16673[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (31))){
var inst_16189 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16485_16674 = state_16421__$1;
(statearr_16485_16674[(2)] = inst_16189);

(statearr_16485_16674[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (113))){
var inst_16395 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16486_16675 = state_16421__$1;
(statearr_16486_16675[(2)] = inst_16395);

(statearr_16486_16675[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (32))){
var state_16421__$1 = state_16421;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16487_16676 = state_16421__$1;
(statearr_16487_16676[(1)] = (35));

} else {
var statearr_16488_16677 = state_16421__$1;
(statearr_16488_16677[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (40))){
var inst_16225 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16225)){
var statearr_16489_16678 = state_16421__$1;
(statearr_16489_16678[(1)] = (44));

} else {
var statearr_16490_16679 = state_16421__$1;
(statearr_16490_16679[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (91))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16323 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16324 = (inst_16281.cljs$core$IFn$_invoke$arity$5 ? inst_16281.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16323,null) : inst_16281.call(null,cljs.core.PersistentArrayMap,null,3,inst_16323,null));
var inst_16325 = (inst_16281.cljs$core$IFn$_invoke$arity$4 ? inst_16281.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16324,null) : inst_16281.call(null,cljs.core.PersistentHashSet,null,inst_16324,null));
var inst_16326 = (inst_16325.cljs$core$IFn$_invoke$arity$1 ? inst_16325.cljs$core$IFn$_invoke$arity$1(inst_16280) : inst_16325.call(null,inst_16280));
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16326)){
var statearr_16491_16680 = state_16421__$1;
(statearr_16491_16680[(1)] = (92));

} else {
var statearr_16492_16681 = state_16421__$1;
(statearr_16492_16681[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (117))){
var state_16421__$1 = state_16421;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16493_16682 = state_16421__$1;
(statearr_16493_16682[(1)] = (120));

} else {
var statearr_16494_16683 = state_16421__$1;
(statearr_16494_16683[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (108))){
var inst_16149 = (state_16421[(11)]);
var inst_16380 = (state_16421[(25)]);
var inst_16380__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16149);
var state_16421__$1 = (function (){var statearr_16495 = state_16421;
(statearr_16495[(25)] = inst_16380__$1);

return statearr_16495;
})();
if(cljs.core.truth_(inst_16380__$1)){
var statearr_16496_16684 = state_16421__$1;
(statearr_16496_16684[(1)] = (111));

} else {
var statearr_16497_16685 = state_16421__$1;
(statearr_16497_16685[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (56))){
var inst_16242 = (state_16421[(2)]);
var inst_16243 = fluree.db.util.async.throw_err(inst_16242);
var inst_16244 = cljs.core.not(inst_16243);
var state_16421__$1 = state_16421;
var statearr_16498_16686 = state_16421__$1;
(statearr_16498_16686[(2)] = inst_16244);

(statearr_16498_16686[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (33))){
var inst_16172 = (state_16421[(26)]);
var state_16421__$1 = state_16421;
var statearr_16499_16687 = state_16421__$1;
(statearr_16499_16687[(2)] = inst_16172);

(statearr_16499_16687[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (13))){
var inst_16167 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16167)){
var statearr_16500_16688 = state_16421__$1;
(statearr_16500_16688[(1)] = (17));

} else {
var statearr_16501_16689 = state_16421__$1;
(statearr_16501_16689[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (22))){
var inst_16198 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16198)){
var statearr_16502_16690 = state_16421__$1;
(statearr_16502_16690[(1)] = (32));

} else {
var statearr_16503_16691 = state_16421__$1;
(statearr_16503_16691[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (90))){
var inst_16321 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16504_16692 = state_16421__$1;
(statearr_16504_16692[(2)] = inst_16321);

(statearr_16504_16692[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (109))){
var inst_16378 = (state_16421[(27)]);
var state_16421__$1 = state_16421;
var statearr_16505_16693 = state_16421__$1;
(statearr_16505_16693[(2)] = inst_16378);

(statearr_16505_16693[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (36))){
var inst_16172 = (state_16421[(26)]);
var state_16421__$1 = state_16421;
var statearr_16506_16694 = state_16421__$1;
(statearr_16506_16694[(2)] = inst_16172);

(statearr_16506_16694[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (41))){
var inst_16149 = (state_16421[(11)]);
var inst_16217 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16218 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16217);
var inst_16219 = inst_16218 === true;
var state_16421__$1 = state_16421;
var statearr_16507_16695 = state_16421__$1;
(statearr_16507_16695[(2)] = inst_16219);

(statearr_16507_16695[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (118))){
var inst_16376 = (state_16421[(7)]);
var state_16421__$1 = state_16421;
var statearr_16508_16696 = state_16421__$1;
(statearr_16508_16696[(2)] = inst_16376);

(statearr_16508_16696[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (89))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16319 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16280,inst_16281,throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16509_16697 = state_16421__$1;
(statearr_16509_16697[(2)] = inst_16319);

(statearr_16509_16697[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (100))){
var inst_16268 = (state_16421[(12)]);
var state_16421__$1 = state_16421;
var statearr_16510_16698 = state_16421__$1;
(statearr_16510_16698[(2)] = inst_16268);

(statearr_16510_16698[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (122))){
var inst_16408 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16511_16699 = state_16421__$1;
(statearr_16511_16699[(2)] = inst_16408);

(statearr_16511_16699[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (43))){
var inst_16222 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16512_16700 = state_16421__$1;
(statearr_16512_16700[(2)] = inst_16222);

(statearr_16512_16700[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (61))){
var inst_16230 = (state_16421[(14)]);
var state_16421__$1 = state_16421;
var statearr_16513_16701 = state_16421__$1;
(statearr_16513_16701[(2)] = inst_16230);

(statearr_16513_16701[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (29))){
var inst_16149 = (state_16421[(11)]);
var inst_16184 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16185 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16184);
var inst_16186 = inst_16185 === true;
var state_16421__$1 = state_16421;
var statearr_16514_16702 = state_16421__$1;
(statearr_16514_16702[(2)] = inst_16186);

(statearr_16514_16702[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (44))){
var inst_16211 = (state_16421[(28)]);
var inst_16227 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16211,"a component","a non-component",throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16515_16703 = state_16421__$1;
(statearr_16515_16703[(2)] = inst_16227);

(statearr_16515_16703[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (93))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16329 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16280,inst_16281,throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16516_16704 = state_16421__$1;
(statearr_16516_16704[(2)] = inst_16329);

(statearr_16516_16704[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (6))){
var inst_16148 = (state_16421[(16)]);
var inst_16136 = (state_16421[(21)]);
var inst_16145 = cljs.core.seq(inst_16136);
var inst_16146 = cljs.core.first(inst_16145);
var inst_16147 = cljs.core.next(inst_16145);
var inst_16148__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16146,(0),null);
var inst_16149 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16146,(1),null);
var inst_16150 = cljs.core.not(inst_16148__$1);
var state_16421__$1 = (function (){var statearr_16517 = state_16421;
(statearr_16517[(11)] = inst_16149);

(statearr_16517[(16)] = inst_16148__$1);

(statearr_16517[(20)] = inst_16147);

return statearr_16517;
})();
if(inst_16150){
var statearr_16518_16705 = state_16421__$1;
(statearr_16518_16705[(1)] = (8));

} else {
var statearr_16519_16706 = state_16421__$1;
(statearr_16519_16706[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (111))){
var inst_16149 = (state_16421[(11)]);
var inst_16384 = (state_16421[(29)]);
var inst_16382 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16383 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16382);
var inst_16384__$1 = inst_16383 === true;
var state_16421__$1 = (function (){var statearr_16520 = state_16421;
(statearr_16520[(29)] = inst_16384__$1);

return statearr_16520;
})();
if(cljs.core.truth_(inst_16384__$1)){
var statearr_16521_16707 = state_16421__$1;
(statearr_16521_16707[(1)] = (114));

} else {
var statearr_16522_16708 = state_16421__$1;
(statearr_16522_16708[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (28))){
var inst_16192 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16523_16709 = state_16421__$1;
(statearr_16523_16709[(2)] = inst_16192);

(statearr_16523_16709[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (64))){
var inst_16269 = (state_16421[(10)]);
var state_16421__$1 = state_16421;
var statearr_16524_16710 = state_16421__$1;
(statearr_16524_16710[(2)] = inst_16269);

(statearr_16524_16710[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (103))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16353 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16354 = (inst_16281.cljs$core$IFn$_invoke$arity$5 ? inst_16281.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16353,null) : inst_16281.call(null,cljs.core.PersistentArrayMap,null,2,inst_16353,null));
var inst_16355 = (inst_16281.cljs$core$IFn$_invoke$arity$4 ? inst_16281.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16354,null) : inst_16281.call(null,cljs.core.PersistentHashSet,null,inst_16354,null));
var inst_16356 = (inst_16355.cljs$core$IFn$_invoke$arity$1 ? inst_16355.cljs$core$IFn$_invoke$arity$1(inst_16280) : inst_16355.call(null,inst_16280));
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16356)){
var statearr_16525_16711 = state_16421__$1;
(statearr_16525_16711[(1)] = (104));

} else {
var statearr_16526_16712 = state_16421__$1;
(statearr_16526_16712[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (51))){
var inst_16234 = (state_16421[(30)]);
var state_16421__$1 = state_16421;
var statearr_16527_16713 = state_16421__$1;
(statearr_16527_16713[(2)] = inst_16234);

(statearr_16527_16713[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (25))){
var inst_16195 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16528_16714 = state_16421__$1;
(statearr_16528_16714[(2)] = inst_16195);

(statearr_16528_16714[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (34))){
var inst_16212 = (state_16421[(18)]);
var inst_16149 = (state_16421[(11)]);
var inst_16211 = (state_16421[(2)]);
var inst_16212__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16149);
var state_16421__$1 = (function (){var statearr_16529 = state_16421;
(statearr_16529[(28)] = inst_16211);

(statearr_16529[(18)] = inst_16212__$1);

return statearr_16529;
})();
if(cljs.core.truth_(inst_16212__$1)){
var statearr_16530_16715 = state_16421__$1;
(statearr_16530_16715[(1)] = (38));

} else {
var statearr_16531_16716 = state_16421__$1;
(statearr_16531_16716[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (17))){
var inst_16137 = (state_16421[(15)]);
var inst_16169 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16137,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16532_16717 = state_16421__$1;
(statearr_16532_16717[(2)] = inst_16169);

(statearr_16532_16717[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (3))){
var inst_16419 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16421__$1,inst_16419);
} else {
if((state_val_16422 === (12))){
var inst_16153 = (state_16421[(31)]);
var state_16421__$1 = state_16421;
var statearr_16533_16718 = state_16421__$1;
(statearr_16533_16718[(2)] = inst_16153);

(statearr_16533_16718[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (2))){
var _ = (function (){var statearr_16534 = state_16421;
(statearr_16534[(4)] = cljs.core.cons((5),(state_16421[(4)])));

return statearr_16534;
})();
var inst_16129 = pred_changes;
var inst_16130 = cljs.core.seq(inst_16129);
var inst_16131 = cljs.core.first(inst_16130);
var inst_16132 = cljs.core.next(inst_16130);
var inst_16133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16131,(0),null);
var inst_16134 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16131,(1),null);
var inst_16135 = db;
var inst_16136 = inst_16129;
var inst_16137 = inst_16135;
var state_16421__$1 = (function (){var statearr_16535 = state_16421;
(statearr_16535[(32)] = inst_16134);

(statearr_16535[(15)] = inst_16137);

(statearr_16535[(21)] = inst_16136);

(statearr_16535[(33)] = inst_16133);

(statearr_16535[(34)] = inst_16132);

return statearr_16535;
})();
var statearr_16536_16719 = state_16421__$1;
(statearr_16536_16719[(2)] = null);

(statearr_16536_16719[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (66))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16149 = (state_16421[(11)]);
var inst_16278 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16279 = cljs.core.__destructure_map(inst_16278);
var inst_16280__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16279,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16281__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16279,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16282 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16281__$1,inst_16280__$1);
var state_16421__$1 = (function (){var statearr_16537 = state_16421;
(statearr_16537[(8)] = inst_16281__$1);

(statearr_16537[(9)] = inst_16280__$1);

return statearr_16537;
})();
if(inst_16282){
var statearr_16538_16720 = state_16421__$1;
(statearr_16538_16720[(1)] = (69));

} else {
var statearr_16539_16721 = state_16421__$1;
(statearr_16539_16721[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (107))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16363 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16280,inst_16281,throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16540_16722 = state_16421__$1;
(statearr_16540_16722[(2)] = inst_16363);

(statearr_16540_16722[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (23))){
var inst_16178 = (state_16421[(17)]);
var inst_16149 = (state_16421[(11)]);
var inst_16177 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16178__$1 = inst_16177 === true;
var state_16421__$1 = (function (){var statearr_16541 = state_16421;
(statearr_16541[(17)] = inst_16178__$1);

return statearr_16541;
})();
if(cljs.core.truth_(inst_16178__$1)){
var statearr_16542_16723 = state_16421__$1;
(statearr_16542_16723[(1)] = (26));

} else {
var statearr_16543_16724 = state_16421__$1;
(statearr_16543_16724[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (47))){
var inst_16234 = (state_16421[(30)]);
var inst_16149 = (state_16421[(11)]);
var inst_16233 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16234__$1 = cljs.core.not(inst_16233);
var state_16421__$1 = (function (){var statearr_16544 = state_16421;
(statearr_16544[(30)] = inst_16234__$1);

return statearr_16544;
})();
if(inst_16234__$1){
var statearr_16545_16725 = state_16421__$1;
(statearr_16545_16725[(1)] = (50));

} else {
var statearr_16546_16726 = state_16421__$1;
(statearr_16546_16726[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (35))){
var inst_16201 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16202 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16203 = cljs.core.PersistentHashMap.fromArrays(inst_16201,inst_16202);
var inst_16204 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_16203);
var inst_16205 = (function(){throw inst_16204})();
var state_16421__$1 = state_16421;
var statearr_16547_16727 = state_16421__$1;
(statearr_16547_16727[(2)] = inst_16205);

(statearr_16547_16727[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (82))){
var inst_16301 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16548_16728 = state_16421__$1;
(statearr_16548_16728[(2)] = inst_16301);

(statearr_16548_16728[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (76))){
var state_16421__$1 = state_16421;
var statearr_16549_16729 = state_16421__$1;
(statearr_16549_16729[(2)] = null);

(statearr_16549_16729[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (97))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16339 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16280,inst_16281,throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16550_16730 = state_16421__$1;
(statearr_16550_16730[(2)] = inst_16339);

(statearr_16550_16730[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (19))){
var inst_16173 = (state_16421[(24)]);
var inst_16149 = (state_16421[(11)]);
var inst_16172 = (state_16421[(2)]);
var inst_16173__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16149);
var state_16421__$1 = (function (){var statearr_16551 = state_16421;
(statearr_16551[(24)] = inst_16173__$1);

(statearr_16551[(26)] = inst_16172);

return statearr_16551;
})();
if(cljs.core.truth_(inst_16173__$1)){
var statearr_16552_16731 = state_16421__$1;
(statearr_16552_16731[(1)] = (20));

} else {
var statearr_16553_16732 = state_16421__$1;
(statearr_16553_16732[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (57))){
var state_16421__$1 = state_16421;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16554_16733 = state_16421__$1;
(statearr_16554_16733[(1)] = (60));

} else {
var statearr_16555_16734 = state_16421__$1;
(statearr_16555_16734[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (68))){
var inst_16149 = (state_16421[(11)]);
var inst_16378 = (state_16421[(27)]);
var inst_16376 = (state_16421[(2)]);
var inst_16377 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16378__$1 = inst_16377 === true;
var state_16421__$1 = (function (){var statearr_16556 = state_16421;
(statearr_16556[(7)] = inst_16376);

(statearr_16556[(27)] = inst_16378__$1);

return statearr_16556;
})();
if(cljs.core.truth_(inst_16378__$1)){
var statearr_16557_16735 = state_16421__$1;
(statearr_16557_16735[(1)] = (108));

} else {
var statearr_16558_16736 = state_16421__$1;
(statearr_16558_16736[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (11))){
var inst_16149 = (state_16421[(11)]);
var inst_16157 = (state_16421[(23)]);
var inst_16155 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16156 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16155);
var inst_16157__$1 = inst_16156 === false;
var state_16421__$1 = (function (){var statearr_16559 = state_16421;
(statearr_16559[(23)] = inst_16157__$1);

return statearr_16559;
})();
if(cljs.core.truth_(inst_16157__$1)){
var statearr_16560_16737 = state_16421__$1;
(statearr_16560_16737[(1)] = (14));

} else {
var statearr_16561_16738 = state_16421__$1;
(statearr_16561_16738[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (115))){
var inst_16384 = (state_16421[(29)]);
var state_16421__$1 = state_16421;
var statearr_16563_16739 = state_16421__$1;
(statearr_16563_16739[(2)] = inst_16384);

(statearr_16563_16739[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (9))){
var inst_16153 = (state_16421[(31)]);
var inst_16149 = (state_16421[(11)]);
var inst_16153__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16149);
var state_16421__$1 = (function (){var statearr_16564 = state_16421;
(statearr_16564[(31)] = inst_16153__$1);

return statearr_16564;
})();
if(cljs.core.truth_(inst_16153__$1)){
var statearr_16565_16740 = state_16421__$1;
(statearr_16565_16740[(1)] = (11));

} else {
var statearr_16566_16741 = state_16421__$1;
(statearr_16566_16741[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (5))){
var _ = (function (){var statearr_16567 = state_16421;
(statearr_16567[(4)] = cljs.core.rest((state_16421[(4)])));

return statearr_16567;
})();
var state_16421__$1 = state_16421;
var ex16562 = (state_16421__$1[(2)]);
var statearr_16568_16742 = state_16421__$1;
(statearr_16568_16742[(5)] = ex16562);


if((ex16562 instanceof Error)){
var statearr_16569_16743 = state_16421__$1;
(statearr_16569_16743[(1)] = (4));

(statearr_16569_16743[(5)] = null);

} else {
throw ex16562;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (112))){
var inst_16380 = (state_16421[(25)]);
var state_16421__$1 = state_16421;
var statearr_16570_16744 = state_16421__$1;
(statearr_16570_16744[(2)] = inst_16380);

(statearr_16570_16744[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (83))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16303 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16304 = (inst_16281.cljs$core$IFn$_invoke$arity$5 ? inst_16281.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16303,null) : inst_16281.call(null,cljs.core.PersistentArrayMap,null,3,inst_16303,null));
var inst_16305 = (inst_16281.cljs$core$IFn$_invoke$arity$4 ? inst_16281.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16304,null) : inst_16281.call(null,cljs.core.PersistentHashSet,null,inst_16304,null));
var inst_16306 = (inst_16305.cljs$core$IFn$_invoke$arity$1 ? inst_16305.cljs$core$IFn$_invoke$arity$1(inst_16280) : inst_16305.call(null,inst_16280));
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16306)){
var statearr_16571_16745 = state_16421__$1;
(statearr_16571_16745[(1)] = (84));

} else {
var statearr_16572_16746 = state_16421__$1;
(statearr_16572_16746[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (14))){
var inst_16149 = (state_16421[(11)]);
var inst_16159 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16160 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16159);
var inst_16161 = inst_16160 === true;
var state_16421__$1 = state_16421;
var statearr_16573_16747 = state_16421__$1;
(statearr_16573_16747[(2)] = inst_16161);

(statearr_16573_16747[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (45))){
var inst_16211 = (state_16421[(28)]);
var state_16421__$1 = state_16421;
var statearr_16574_16748 = state_16421__$1;
(statearr_16574_16748[(2)] = inst_16211);

(statearr_16574_16748[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (53))){
var inst_16137 = (state_16421[(15)]);
var inst_16148 = (state_16421[(16)]);
var inst_16240 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_16137,inst_16148);
var state_16421__$1 = state_16421;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16421__$1,(56),inst_16240);
} else {
if((state_val_16422 === (78))){
var inst_16366 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16575_16749 = state_16421__$1;
(statearr_16575_16749[(2)] = inst_16366);

(statearr_16575_16749[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (26))){
var inst_16182 = (state_16421[(35)]);
var inst_16149 = (state_16421[(11)]);
var inst_16180 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16181 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16180);
var inst_16182__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16181);
var state_16421__$1 = (function (){var statearr_16576 = state_16421;
(statearr_16576[(35)] = inst_16182__$1);

return statearr_16576;
})();
if(inst_16182__$1){
var statearr_16577_16750 = state_16421__$1;
(statearr_16577_16750[(1)] = (29));

} else {
var statearr_16578_16751 = state_16421__$1;
(statearr_16578_16751[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (16))){
var inst_16164 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16579_16752 = state_16421__$1;
(statearr_16579_16752[(2)] = inst_16164);

(statearr_16579_16752[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (81))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16299 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16280,inst_16281,throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16580_16753 = state_16421__$1;
(statearr_16580_16753[(2)] = inst_16299);

(statearr_16580_16753[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (120))){
var inst_16401 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16402 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16403 = cljs.core.PersistentHashMap.fromArrays(inst_16401,inst_16402);
var inst_16404 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_16403);
var inst_16405 = (function(){throw inst_16404})();
var state_16421__$1 = state_16421;
var statearr_16581_16754 = state_16421__$1;
(statearr_16581_16754[(2)] = inst_16405);

(statearr_16581_16754[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (79))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16293 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16294 = (inst_16281.cljs$core$IFn$_invoke$arity$5 ? inst_16281.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16293,null) : inst_16281.call(null,cljs.core.PersistentArrayMap,null,2,inst_16293,null));
var inst_16295 = (inst_16281.cljs$core$IFn$_invoke$arity$4 ? inst_16281.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16294,null) : inst_16281.call(null,cljs.core.PersistentHashSet,null,inst_16294,null));
var inst_16296 = (inst_16295.cljs$core$IFn$_invoke$arity$1 ? inst_16295.cljs$core$IFn$_invoke$arity$1(inst_16280) : inst_16295.call(null,inst_16280));
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16296)){
var statearr_16582_16755 = state_16421__$1;
(statearr_16582_16755[(1)] = (80));

} else {
var statearr_16583_16756 = state_16421__$1;
(statearr_16583_16756[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (38))){
var inst_16215 = (state_16421[(36)]);
var inst_16149 = (state_16421[(11)]);
var inst_16214 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16215__$1 = cljs.core.not(inst_16214);
var state_16421__$1 = (function (){var statearr_16584 = state_16421;
(statearr_16584[(36)] = inst_16215__$1);

return statearr_16584;
})();
if(inst_16215__$1){
var statearr_16585_16757 = state_16421__$1;
(statearr_16585_16757[(1)] = (41));

} else {
var statearr_16586_16758 = state_16421__$1;
(statearr_16586_16758[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (98))){
var inst_16341 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16587_16759 = state_16421__$1;
(statearr_16587_16759[(2)] = inst_16341);

(statearr_16587_16759[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (87))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16313 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16314 = (inst_16281.cljs$core$IFn$_invoke$arity$5 ? inst_16281.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16313,null) : inst_16281.call(null,cljs.core.PersistentArrayMap,null,3,inst_16313,null));
var inst_16315 = (inst_16281.cljs$core$IFn$_invoke$arity$4 ? inst_16281.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16314,null) : inst_16281.call(null,cljs.core.PersistentHashSet,null,inst_16314,null));
var inst_16316 = (inst_16315.cljs$core$IFn$_invoke$arity$1 ? inst_16315.cljs$core$IFn$_invoke$arity$1(inst_16280) : inst_16315.call(null,inst_16280));
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16316)){
var statearr_16588_16760 = state_16421__$1;
(statearr_16588_16760[(1)] = (88));

} else {
var statearr_16589_16761 = state_16421__$1;
(statearr_16589_16761[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (30))){
var inst_16182 = (state_16421[(35)]);
var state_16421__$1 = state_16421;
var statearr_16590_16762 = state_16421__$1;
(statearr_16590_16762[(2)] = inst_16182);

(statearr_16590_16762[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (73))){
var state_16421__$1 = state_16421;
var statearr_16591_16763 = state_16421__$1;
(statearr_16591_16763[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (96))){
var inst_16268 = (state_16421[(12)]);
var state_16421__$1 = state_16421;
var statearr_16593_16764 = state_16421__$1;
(statearr_16593_16764[(2)] = inst_16268);

(statearr_16593_16764[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (10))){
var inst_16414 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16594_16765 = state_16421__$1;
(statearr_16594_16765[(2)] = inst_16414);

(statearr_16594_16765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (18))){
var inst_16137 = (state_16421[(15)]);
var state_16421__$1 = state_16421;
var statearr_16595_16766 = state_16421__$1;
(statearr_16595_16766[(2)] = inst_16137);

(statearr_16595_16766[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (105))){
var inst_16281 = (state_16421[(8)]);
var inst_16280 = (state_16421[(9)]);
var inst_16359 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16280,inst_16281,throw_QMARK_);
var state_16421__$1 = state_16421;
var statearr_16596_16767 = state_16421__$1;
(statearr_16596_16767[(2)] = inst_16359);

(statearr_16596_16767[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (52))){
var inst_16250 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16597_16768 = state_16421__$1;
(statearr_16597_16768[(2)] = inst_16250);

(statearr_16597_16768[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (114))){
var inst_16149 = (state_16421[(11)]);
var inst_16386 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16387 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16386);
var inst_16388 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16387);
var inst_16389 = (!(inst_16388));
var state_16421__$1 = state_16421;
var statearr_16598_16769 = state_16421__$1;
(statearr_16598_16769[(2)] = inst_16389);

(statearr_16598_16769[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (67))){
var inst_16268 = (state_16421[(12)]);
var state_16421__$1 = state_16421;
var statearr_16599_16770 = state_16421__$1;
(statearr_16599_16770[(2)] = inst_16268);

(statearr_16599_16770[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (71))){
var inst_16373 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16600_16771 = state_16421__$1;
(statearr_16600_16771[(2)] = inst_16373);

(statearr_16600_16771[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (42))){
var inst_16215 = (state_16421[(36)]);
var state_16421__$1 = state_16421;
var statearr_16601_16772 = state_16421__$1;
(statearr_16601_16772[(2)] = inst_16215);

(statearr_16601_16772[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (80))){
var inst_16268 = (state_16421[(12)]);
var state_16421__$1 = state_16421;
var statearr_16602_16773 = state_16421__$1;
(statearr_16602_16773[(2)] = inst_16268);

(statearr_16602_16773[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (37))){
var inst_16208 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16603_16774 = state_16421__$1;
(statearr_16603_16774[(2)] = inst_16208);

(statearr_16603_16774[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (63))){
var inst_16149 = (state_16421[(11)]);
var inst_16271 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16149);
var inst_16272 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16271);
var state_16421__$1 = state_16421;
var statearr_16604_16775 = state_16421__$1;
(statearr_16604_16775[(2)] = inst_16272);

(statearr_16604_16775[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (94))){
var inst_16331 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
var statearr_16605_16776 = state_16421__$1;
(statearr_16605_16776[(2)] = inst_16331);

(statearr_16605_16776[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (8))){
var inst_16137 = (state_16421[(15)]);
var state_16421__$1 = state_16421;
var statearr_16606_16777 = state_16421__$1;
(statearr_16606_16777[(2)] = inst_16137);

(statearr_16606_16777[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (49))){
var inst_16253 = (state_16421[(2)]);
var state_16421__$1 = state_16421;
if(cljs.core.truth_(inst_16253)){
var statearr_16607_16778 = state_16421__$1;
(statearr_16607_16778[(1)] = (57));

} else {
var statearr_16608_16779 = state_16421__$1;
(statearr_16608_16779[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16422 === (84))){
var inst_16268 = (state_16421[(12)]);
var state_16421__$1 = state_16421;
var statearr_16609_16780 = state_16421__$1;
(statearr_16609_16780[(2)] = inst_16268);

(statearr_16609_16780[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_16610 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16610[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_16610[(1)] = (1));

return statearr_16610;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_16421){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16421);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16611){var ex__2730__auto__ = e16611;
var statearr_16612_16781 = state_16421;
(statearr_16612_16781[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16421[(4)]))){
var statearr_16613_16782 = state_16421;
(statearr_16613_16782[(1)] = cljs.core.first((state_16421[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16783 = state_16421;
state_16421 = G__16783;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_16421){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_16421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16614 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16614[(6)] = c__2749__auto__);

return statearr_16614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16785 = arguments.length;
switch (G__16785) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16809){
var state_val_16810 = (state_16809[(1)]);
if((state_val_16810 === (7))){
var state_16809__$1 = state_16809;
var statearr_16811_16831 = state_16809__$1;
(statearr_16811_16831[(2)] = db);

(statearr_16811_16831[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16810 === (1))){
var state_16809__$1 = state_16809;
var statearr_16812_16832 = state_16809__$1;
(statearr_16812_16832[(2)] = null);

(statearr_16812_16832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16810 === (4))){
var inst_16786 = (state_16809[(2)]);
var state_16809__$1 = state_16809;
var statearr_16813_16833 = state_16809__$1;
(statearr_16813_16833[(2)] = inst_16786);

(statearr_16813_16833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16810 === (6))){
var inst_16795 = (state_16809[(7)]);
var inst_16794 = (state_16809[(2)]);
var inst_16795__$1 = fluree.db.util.async.throw_err(inst_16794);
var inst_16796 = cljs.core.empty_QMARK_(inst_16795__$1);
var state_16809__$1 = (function (){var statearr_16814 = state_16809;
(statearr_16814[(7)] = inst_16795__$1);

return statearr_16814;
})();
if(inst_16796){
var statearr_16815_16834 = state_16809__$1;
(statearr_16815_16834[(1)] = (7));

} else {
var statearr_16816_16835 = state_16809__$1;
(statearr_16816_16835[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16810 === (3))){
var inst_16807 = (state_16809[(2)]);
var state_16809__$1 = state_16809;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16809__$1,inst_16807);
} else {
if((state_val_16810 === (2))){
var _ = (function (){var statearr_16818 = state_16809;
(statearr_16818[(4)] = cljs.core.cons((5),(state_16809[(4)])));

return statearr_16818;
})();
var inst_16792 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_16809__$1 = state_16809;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16809__$1,(6),inst_16792);
} else {
if((state_val_16810 === (9))){
var inst_16804 = (state_16809[(2)]);
var _ = (function (){var statearr_16819 = state_16809;
(statearr_16819[(4)] = cljs.core.rest((state_16809[(4)])));

return statearr_16819;
})();
var state_16809__$1 = state_16809;
var statearr_16820_16836 = state_16809__$1;
(statearr_16820_16836[(2)] = inst_16804);

(statearr_16820_16836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16810 === (5))){
var _ = (function (){var statearr_16821 = state_16809;
(statearr_16821[(4)] = cljs.core.rest((state_16809[(4)])));

return statearr_16821;
})();
var state_16809__$1 = state_16809;
var ex16817 = (state_16809__$1[(2)]);
var statearr_16822_16837 = state_16809__$1;
(statearr_16822_16837[(5)] = ex16817);


if((ex16817 instanceof Error)){
var statearr_16823_16838 = state_16809__$1;
(statearr_16823_16838[(1)] = (4));

(statearr_16823_16838[(5)] = null);

} else {
throw ex16817;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16810 === (10))){
var inst_16801 = (state_16809[(2)]);
var inst_16802 = fluree.db.util.async.throw_err(inst_16801);
var state_16809__$1 = state_16809;
var statearr_16824_16839 = state_16809__$1;
(statearr_16824_16839[(2)] = inst_16802);

(statearr_16824_16839[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16810 === (8))){
var inst_16795 = (state_16809[(7)]);
var inst_16799 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_16795,db,true);
var state_16809__$1 = state_16809;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16809__$1,(10),inst_16799);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_16825 = [null,null,null,null,null,null,null,null];
(statearr_16825[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_16825[(1)] = (1));

return statearr_16825;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_16809){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16809);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16826){var ex__2730__auto__ = e16826;
var statearr_16827_16840 = state_16809;
(statearr_16827_16840[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16809[(4)]))){
var statearr_16828_16841 = state_16809;
(statearr_16828_16841[(1)] = cljs.core.first((state_16809[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16842 = state_16809;
state_16809 = G__16842;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_16809){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_16809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16829 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16829[(6)] = c__2749__auto__);

return statearr_16829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16844 = arguments.length;
switch (G__16844) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16846 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16846,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16846,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16846,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4251__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4251__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__16849_SHARP_,p2__16850_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16849_SHARP_,p2__16850_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__16851_SHARP_){
var f = p1__16851_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16917){
var state_val_16918 = (state_16917[(1)]);
if((state_val_16918 === (1))){
var state_16917__$1 = state_16917;
var statearr_16919_16937 = state_16917__$1;
(statearr_16919_16937[(2)] = null);

(statearr_16919_16937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16918 === (2))){
var _ = (function (){var statearr_16920 = state_16917;
(statearr_16920[(4)] = cljs.core.cons((5),(state_16917[(4)])));

return statearr_16920;
})();
var inst_16869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16870 = fluree.db.flake.max_subject_id((1));
var inst_16871 = [inst_16870];
var inst_16872 = (new cljs.core.PersistentVector(null,1,(5),inst_16869,inst_16871,null));
var inst_16873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16874 = [(0)];
var inst_16875 = (new cljs.core.PersistentVector(null,1,(5),inst_16873,inst_16874,null));
var inst_16876 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16872,cljs.core._LT__EQ_,inst_16875);
var state_16917__$1 = state_16917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16917__$1,(6),inst_16876);
} else {
if((state_val_16918 === (3))){
var inst_16915 = (state_16917[(2)]);
var state_16917__$1 = state_16917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16917__$1,inst_16915);
} else {
if((state_val_16918 === (4))){
var inst_16857 = (state_16917[(2)]);
var state_16917__$1 = state_16917;
var statearr_16922_16938 = state_16917__$1;
(statearr_16922_16938[(2)] = inst_16857);

(statearr_16922_16938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16918 === (5))){
var _ = (function (){var statearr_16923 = state_16917;
(statearr_16923[(4)] = cljs.core.rest((state_16917[(4)])));

return statearr_16923;
})();
var state_16917__$1 = state_16917;
var ex16921 = (state_16917__$1[(2)]);
var statearr_16924_16939 = state_16917__$1;
(statearr_16924_16939[(5)] = ex16921);


if((ex16921 instanceof Error)){
var statearr_16925_16940 = state_16917__$1;
(statearr_16925_16940[(1)] = (4));

(statearr_16925_16940[(5)] = null);

} else {
throw ex16921;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16918 === (6))){
var inst_16878 = (state_16917[(2)]);
var inst_16879 = fluree.db.util.async.throw_err(inst_16878);
var inst_16880 = (function (){var schema_flakes = inst_16879;
return (function (p1__16852_SHARP_){
return (p1__16852_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16881 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16880,inst_16879);
var inst_16882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16881,(0),null);
var inst_16883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16881,(1),null);
var inst_16884 = (function (){var schema_flakes = inst_16879;
var vec__16863 = inst_16881;
var collection_flakes = inst_16882;
var predicate_flakes = inst_16883;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__16855_SHARP_,p2__16854_SHARP_){
var f = p2__16854_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16855_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_16885 = [(-1),"_tx"];
var inst_16886 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16887 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16888 = cljs.core.PersistentHashMap.fromArrays(inst_16886,inst_16887);
var inst_16889 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16890 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16891 = cljs.core.PersistentHashMap.fromArrays(inst_16889,inst_16890);
var inst_16892 = [inst_16888,inst_16891];
var inst_16893 = cljs.core.PersistentHashMap.fromArrays(inst_16885,inst_16892);
var inst_16894 = (function (){var schema_flakes = inst_16879;
var vec__16863 = inst_16881;
var collection_flakes = inst_16882;
var predicate_flakes = inst_16883;
return (function (p1__16853_SHARP_){
return p1__16853_SHARP_.s;
});
})();
var inst_16895 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16894,inst_16882);
var inst_16896 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16884,inst_16893,inst_16895);
var inst_16898 = (function (){var schema_flakes = inst_16879;
var vec__16863 = inst_16881;
var collection_flakes = inst_16882;
var predicate_flakes = inst_16883;
var coll = inst_16896;
return (function (p__16897,pred_flakes){
var vec__16926 = p__16897;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16926,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16926,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__16929 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__16929.cljs$core$IFn$_invoke$arity$1 ? fexpr__16929.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__16929.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4253__auto__ = ref_QMARK_;
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_16899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16900 = cljs.core.PersistentHashMap.EMPTY;
var inst_16901 = cljs.core.PersistentHashSet.EMPTY;
var inst_16902 = [inst_16900,inst_16901];
var inst_16903 = (new cljs.core.PersistentVector(null,2,(5),inst_16899,inst_16902,null));
var inst_16904 = (function (){var schema_flakes = inst_16879;
var vec__16863 = inst_16881;
var collection_flakes = inst_16882;
var predicate_flakes = inst_16883;
var coll = inst_16896;
return (function (p1__16856_SHARP_){
return p1__16856_SHARP_.s;
});
})();
var inst_16905 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16904,inst_16883);
var inst_16906 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16898,inst_16903,inst_16905);
var inst_16907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16906,(0),null);
var inst_16908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16906,(1),null);
var inst_16909 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_16910 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_16911 = [inst_16910,inst_16896,inst_16907,inst_16908];
var inst_16912 = cljs.core.PersistentHashMap.fromArrays(inst_16909,inst_16911);
var _ = (function (){var statearr_16930 = state_16917;
(statearr_16930[(4)] = cljs.core.rest((state_16917[(4)])));

return statearr_16930;
})();
var state_16917__$1 = state_16917;
var statearr_16931_16941 = state_16917__$1;
(statearr_16931_16941[(2)] = inst_16912);

(statearr_16931_16941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0 = (function (){
var statearr_16932 = [null,null,null,null,null,null,null];
(statearr_16932[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2727__auto__);

(statearr_16932[(1)] = (1));

return statearr_16932;
});
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1 = (function (state_16917){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16917);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16933){var ex__2730__auto__ = e16933;
var statearr_16934_16942 = state_16917;
(statearr_16934_16942[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16917[(4)]))){
var statearr_16935_16943 = state_16917;
(statearr_16935_16943[(1)] = cljs.core.first((state_16917[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16944 = state_16917;
state_16917 = G__16944;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = function(state_16917){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1.call(this,state_16917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16936 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16936[(6)] = c__2749__auto__);

return statearr_16936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16986){
var state_val_16987 = (state_16986[(1)]);
if((state_val_16987 === (7))){
var inst_16969 = (state_16986[(2)]);
var inst_16970 = fluree.db.query.schema.flake__GT_pred_map(inst_16969);
var inst_16971 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16972 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16970,(114));
var inst_16973 = cljs.core.boolean$(inst_16972);
var inst_16974 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16970,(110));
var inst_16975 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16970,(117));
var inst_16976 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_16975);
var inst_16977 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16970,(111));
var inst_16978 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16970,(115));
var inst_16979 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16970,(112));
var inst_16980 = [inst_16973,inst_16974,inst_16976,inst_16977,inst_16978,inst_16979];
var inst_16981 = cljs.core.PersistentHashMap.fromArrays(inst_16971,inst_16980);
var _ = (function (){var statearr_16988 = state_16986;
(statearr_16988[(4)] = cljs.core.rest((state_16986[(4)])));

return statearr_16988;
})();
var state_16986__$1 = state_16986;
var statearr_16989_17012 = state_16986__$1;
(statearr_16989_17012[(2)] = inst_16981);

(statearr_16989_17012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16987 === (1))){
var state_16986__$1 = state_16986;
var statearr_16990_17013 = state_16986__$1;
(statearr_16990_17013[(2)] = null);

(statearr_16990_17013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16987 === (4))){
var inst_16945 = (state_16986[(2)]);
var state_16986__$1 = state_16986;
var statearr_16991_17014 = state_16986__$1;
(statearr_16991_17014[(2)] = inst_16945);

(statearr_16991_17014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16987 === (6))){
var _ = (function (){var statearr_16992 = state_16986;
(statearr_16992[(4)] = cljs.core.cons((9),(state_16986[(4)])));

return statearr_16992;
})();
var inst_16957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16959 = ["_setting/id","root"];
var inst_16960 = (new cljs.core.PersistentVector(null,2,(5),inst_16958,inst_16959,null));
var inst_16961 = [inst_16960];
var inst_16962 = (new cljs.core.PersistentVector(null,1,(5),inst_16957,inst_16961,null));
var inst_16963 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16962);
var state_16986__$1 = state_16986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16986__$1,(10),inst_16963);
} else {
if((state_val_16987 === (3))){
var inst_16984 = (state_16986[(2)]);
var state_16986__$1 = state_16986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16986__$1,inst_16984);
} else {
if((state_val_16987 === (2))){
var _ = (function (){var statearr_16995 = state_16986;
(statearr_16995[(4)] = cljs.core.cons((5),(state_16986[(4)])));

return statearr_16995;
})();
var state_16986__$1 = state_16986;
var statearr_16996_17015 = state_16986__$1;
(statearr_16996_17015[(2)] = null);

(statearr_16996_17015[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16987 === (9))){
var _ = (function (){var statearr_16997 = state_16986;
(statearr_16997[(4)] = cljs.core.rest((state_16986[(4)])));

return statearr_16997;
})();
var state_16986__$1 = state_16986;
var ex16993 = (state_16986__$1[(2)]);
var statearr_16998_17016 = state_16986__$1;
(statearr_16998_17016[(5)] = ex16993);


var statearr_16999_17017 = state_16986__$1;
(statearr_16999_17017[(1)] = (8));

(statearr_16999_17017[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16987 === (5))){
var _ = (function (){var statearr_17000 = state_16986;
(statearr_17000[(4)] = cljs.core.rest((state_16986[(4)])));

return statearr_17000;
})();
var state_16986__$1 = state_16986;
var ex16994 = (state_16986__$1[(2)]);
var statearr_17001_17018 = state_16986__$1;
(statearr_17001_17018[(5)] = ex16994);


if((ex16994 instanceof Error)){
var statearr_17002_17019 = state_16986__$1;
(statearr_17002_17019[(1)] = (4));

(statearr_17002_17019[(5)] = null);

} else {
throw ex16994;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16987 === (10))){
var inst_16965 = (state_16986[(2)]);
var inst_16966 = fluree.db.util.async.throw_err(inst_16965);
var _ = (function (){var statearr_17003 = state_16986;
(statearr_17003[(4)] = cljs.core.rest((state_16986[(4)])));

return statearr_17003;
})();
var state_16986__$1 = state_16986;
var statearr_17004_17020 = state_16986__$1;
(statearr_17004_17020[(2)] = inst_16966);

(statearr_17004_17020[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16987 === (8))){
var inst_16951 = (state_16986[(2)]);
var state_16986__$1 = (function (){var statearr_17005 = state_16986;
(statearr_17005[(7)] = inst_16951);

return statearr_17005;
})();
var statearr_17006_17021 = state_16986__$1;
(statearr_17006_17021[(2)] = null);

(statearr_17006_17021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0 = (function (){
var statearr_17007 = [null,null,null,null,null,null,null,null];
(statearr_17007[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2727__auto__);

(statearr_17007[(1)] = (1));

return statearr_17007;
});
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1 = (function (state_16986){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16986);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17008){var ex__2730__auto__ = e17008;
var statearr_17009_17022 = state_16986;
(statearr_17009_17022[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16986[(4)]))){
var statearr_17010_17023 = state_16986;
(statearr_17010_17023[(1)] = cljs.core.first((state_16986[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17024 = state_16986;
state_16986 = G__17024;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = function(state_16986){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1.call(this,state_16986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17011 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17011[(6)] = c__2749__auto__);

return statearr_17011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
