// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4253__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13796 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13796,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13796,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13796,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13796,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13796,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13796,(5),null);
var G__13799 = idx;
var G__13799__$1 = (((G__13799 instanceof cljs.core.Keyword))?G__13799.fqn:null);
switch (G__13799__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13799__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13801 = idx;
var G__13801__$1 = (((G__13801 instanceof cljs.core.Keyword))?G__13801.fqn:null);
switch (G__13801__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13801__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13803 = idx;
var G__13803__$1 = (((G__13803 instanceof cljs.core.Keyword))?G__13803.fqn:null);
switch (G__13803__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13803__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13806 = arguments.length;
switch (G__13806) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13807 = (function (){var pred__13810 = cljs.core.identical_QMARK_;
var expr__13811 = test;
if(cljs.core.truth_((pred__13810.cljs$core$IFn$_invoke$arity$2 ? pred__13810.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__13811) : pred__13810.call(null,cljs.core._EQ_,expr__13811)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13810.cljs$core$IFn$_invoke$arity$2 ? pred__13810.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__13811) : pred__13810.call(null,cljs.core._LT_,expr__13811)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__13810.cljs$core$IFn$_invoke$arity$2 ? pred__13810.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__13811) : pred__13810.call(null,cljs.core._LT__EQ_,expr__13811)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13810.cljs$core$IFn$_invoke$arity$2 ? pred__13810.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__13811) : pred__13810.call(null,cljs.core._GT_,expr__13811)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__13810.cljs$core$IFn$_invoke$arity$2 ? pred__13810.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__13811) : pred__13810.call(null,cljs.core._GT__EQ_,expr__13811)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13811)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13807,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13807,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13807,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13807,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14050){
var state_val_14051 = (state_14050[(1)]);
if((state_val_14051 === (65))){
var inst_14021 = (state_14050[(7)]);
var inst_13965 = (state_14050[(8)]);
var inst_14021__$1 = (state_14050[(2)]);
var inst_14022 = cljs.core.count(inst_14021__$1);
var state_14050__$1 = (function (){var statearr_14052 = state_14050;
(statearr_14052[(7)] = inst_14021__$1);

(statearr_14052[(9)] = inst_14022);

return statearr_14052;
})();
if(cljs.core.truth_(inst_13965)){
var statearr_14053_14190 = state_14050__$1;
(statearr_14053_14190[(1)] = (81));

} else {
var statearr_14054_14191 = state_14050__$1;
(statearr_14054_14191[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (70))){
var inst_13996 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
if(cljs.core.truth_(inst_13996)){
var statearr_14055_14192 = state_14050__$1;
(statearr_14055_14192[(1)] = (71));

} else {
var statearr_14056_14193 = state_14050__$1;
(statearr_14056_14193[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (62))){
var inst_13935 = (state_14050[(10)]);
var inst_13949 = (state_14050[(11)]);
var inst_13964 = (state_14050[(2)]);
var inst_13965 = fluree.db.dbproto._rhs(inst_13949);
var state_14050__$1 = (function (){var statearr_14057 = state_14050;
(statearr_14057[(8)] = inst_13965);

(statearr_14057[(12)] = inst_13964);

return statearr_14057;
})();
if(cljs.core.truth_(inst_13935)){
var statearr_14058_14194 = state_14050__$1;
(statearr_14058_14194[(1)] = (63));

} else {
var statearr_14059_14195 = state_14050__$1;
(statearr_14059_14195[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (74))){
var inst_13989 = (state_14050[(13)]);
var inst_14003 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_13989);
var state_14050__$1 = state_14050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14050__$1,(77),inst_14003);
} else {
if((state_val_14051 === (7))){
var inst_13826 = (state_14050[(14)]);
var state_14050__$1 = state_14050;
var statearr_14060_14196 = state_14050__$1;
(statearr_14060_14196[(2)] = inst_13826);

(statearr_14060_14196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (59))){
var inst_13911 = (state_14050[(15)]);
var inst_13956 = (state_14050[(16)]);
var inst_13912 = (state_14050[(17)]);
var inst_13955 = (state_14050[(2)]);
var inst_13956__$1 = fluree.db.util.async.throw_err(inst_13955);
var inst_13957 = fluree.db.flake.subrange(inst_13956__$1,start_test,inst_13911,end_test,inst_13912);
var inst_13958 = fluree.db.query.range.value_with_nil_pred(idx,inst_13911,inst_13912);
var state_14050__$1 = (function (){var statearr_14061 = state_14050;
(statearr_14061[(18)] = inst_13957);

(statearr_14061[(16)] = inst_13956__$1);

return statearr_14061;
})();
if(inst_13958){
var statearr_14062_14197 = state_14050__$1;
(statearr_14062_14197[(1)] = (60));

} else {
var statearr_14063_14198 = state_14050__$1;
(statearr_14063_14198[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (86))){
var inst_14030 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
var statearr_14064_14199 = state_14050__$1;
(statearr_14064_14199[(2)] = inst_14030);

(statearr_14064_14199[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (20))){
var inst_13827 = (state_14050[(19)]);
var inst_13875 = (state_14050[(20)]);
var inst_13874 = (state_14050[(2)]);
var inst_13875__$1 = (inst_13827 == null);
var state_14050__$1 = (function (){var statearr_14065 = state_14050;
(statearr_14065[(21)] = inst_13874);

(statearr_14065[(20)] = inst_13875__$1);

return statearr_14065;
})();
if(cljs.core.truth_(inst_13875__$1)){
var statearr_14066_14200 = state_14050__$1;
(statearr_14066_14200[(1)] = (22));

} else {
var statearr_14067_14201 = state_14050__$1;
(statearr_14067_14201[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (72))){
var inst_13982 = (state_14050[(22)]);
var inst_14000 = (inst_13982 + (1));
var inst_14001 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14050__$1 = (function (){var statearr_14068 = state_14050;
(statearr_14068[(23)] = inst_14000);

return statearr_14068;
})();
if(cljs.core.truth_(inst_14001)){
var statearr_14069_14202 = state_14050__$1;
(statearr_14069_14202[(1)] = (74));

} else {
var statearr_14070_14203 = state_14050__$1;
(statearr_14070_14203[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (58))){
var inst_14045 = (state_14050[(2)]);
var _ = (function (){var statearr_14071 = state_14050;
(statearr_14071[(4)] = cljs.core.rest((state_14050[(4)])));

return statearr_14071;
})();
var state_14050__$1 = state_14050;
var statearr_14072_14204 = state_14050__$1;
(statearr_14072_14204[(2)] = inst_14045);

(statearr_14072_14204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (60))){
var inst_13883 = (state_14050[(24)]);
var inst_13911 = (state_14050[(15)]);
var inst_13837 = (state_14050[(25)]);
var inst_13935 = (state_14050[(10)]);
var inst_13832 = (state_14050[(26)]);
var inst_13922 = (state_14050[(27)]);
var inst_13917 = (state_14050[(28)]);
var inst_13957 = (state_14050[(18)]);
var inst_13825 = (state_14050[(29)]);
var inst_13830 = (state_14050[(30)]);
var inst_13944 = (state_14050[(31)]);
var inst_13956 = (state_14050[(16)]);
var inst_13892 = (state_14050[(32)]);
var inst_13949 = (state_14050[(11)]);
var inst_13901 = (state_14050[(33)]);
var inst_13836 = (state_14050[(34)]);
var inst_13910 = (state_14050[(35)]);
var inst_13918 = (state_14050[(36)]);
var inst_13929 = (state_14050[(37)]);
var inst_13856 = (state_14050[(38)]);
var inst_13950 = (state_14050[(39)]);
var inst_13928 = (state_14050[(40)]);
var inst_13874 = (state_14050[(21)]);
var inst_13865 = (state_14050[(41)]);
var inst_13912 = (state_14050[(17)]);
var inst_13847 = (state_14050[(42)]);
var inst_13939 = (state_14050[(43)]);
var inst_13951 = (state_14050[(44)]);
var inst_13829 = (state_14050[(45)]);
var inst_13960 = (function (){var no_filter_QMARK_ = inst_13935;
var next_node = inst_13949;
var flakes = inst_13956;
var s1 = inst_13847;
var o2 = inst_13874;
var t1 = inst_13829;
var i = inst_13950;
var m1 = inst_13901;
var root_node = inst_13944;
var to_t = inst_13929;
var s2 = inst_13856;
var p2 = inst_13892;
var vec__13819 = inst_13825;
var permissions = inst_13918;
var limit = inst_13917;
var start_flake = inst_13911;
var acc = inst_13951;
var t2 = inst_13836;
var op1 = inst_13830;
var o1 = inst_13865;
var end_flake = inst_13912;
var base_result = inst_13957;
var p1 = inst_13883;
var vec__13822 = inst_13832;
var idx_compare = inst_13922;
var op2 = inst_13837;
var from_t = inst_13928;
var m2 = inst_13910;
var novelty = inst_13939;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_13961 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_13960,inst_13957,inst_13957);
var state_14050__$1 = state_14050;
var statearr_14073_14205 = state_14050__$1;
(statearr_14073_14205[(2)] = inst_13961);

(statearr_14073_14205[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (27))){
var inst_13834 = (state_14050[(46)]);
var inst_13884 = (state_14050[(47)]);
var inst_13883 = (state_14050[(2)]);
var inst_13884__$1 = (inst_13834 == null);
var state_14050__$1 = (function (){var statearr_14074 = state_14050;
(statearr_14074[(24)] = inst_13883);

(statearr_14074[(47)] = inst_13884__$1);

return statearr_14074;
})();
if(cljs.core.truth_(inst_13884__$1)){
var statearr_14075_14206 = state_14050__$1;
(statearr_14075_14206[(1)] = (28));

} else {
var statearr_14076_14207 = state_14050__$1;
(statearr_14076_14207[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (1))){
var state_14050__$1 = state_14050;
var statearr_14077_14208 = state_14050__$1;
(statearr_14077_14208[(2)] = null);

(statearr_14077_14208[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (69))){
var inst_13917 = (state_14050[(28)]);
var inst_13982 = (state_14050[(22)]);
var inst_13994 = (inst_13982 > inst_13917);
var state_14050__$1 = state_14050;
var statearr_14078_14209 = state_14050__$1;
(statearr_14078_14209[(2)] = inst_13994);

(statearr_14078_14209[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (24))){
var inst_13879 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
if(cljs.core.truth_(inst_13879)){
var statearr_14079_14210 = state_14050__$1;
(statearr_14079_14210[(1)] = (25));

} else {
var statearr_14080_14211 = state_14050__$1;
(statearr_14080_14211[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (55))){
var inst_13911 = (state_14050[(15)]);
var inst_13944 = (state_14050[(31)]);
var inst_13943 = (state_14050[(2)]);
var inst_13944__$1 = fluree.db.util.async.throw_err(inst_13943);
var inst_13945 = fluree.db.dbproto._lookup_leaf(inst_13944__$1,inst_13911);
var state_14050__$1 = (function (){var statearr_14081 = state_14050;
(statearr_14081[(31)] = inst_13944__$1);

return statearr_14081;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14050__$1,(56),inst_13945);
} else {
if((state_val_14051 === (85))){
var inst_14025 = (state_14050[(48)]);
var state_14050__$1 = state_14050;
var statearr_14082_14212 = state_14050__$1;
(statearr_14082_14212[(2)] = inst_14025);

(statearr_14082_14212[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (39))){
var inst_13899 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
var statearr_14083_14213 = state_14050__$1;
(statearr_14083_14213[(2)] = inst_13899);

(statearr_14083_14213[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (88))){
var inst_13965 = (state_14050[(8)]);
var inst_13944 = (state_14050[(31)]);
var inst_14037 = fluree.db.dbproto._lookup_leaf(inst_13944,inst_13965);
var state_14050__$1 = state_14050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14050__$1,(90),inst_14037);
} else {
if((state_val_14051 === (46))){
var inst_13913 = (state_14050[(49)]);
var state_14050__$1 = state_14050;
var statearr_14084_14214 = state_14050__$1;
(statearr_14084_14214[(2)] = inst_13913);

(statearr_14084_14214[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (4))){
var inst_13813 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
var statearr_14085_14215 = state_14050__$1;
(statearr_14085_14215[(2)] = inst_13813);

(statearr_14085_14215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (77))){
var inst_14005 = (state_14050[(2)]);
var inst_14006 = fluree.db.util.async.throw_err(inst_14005);
var state_14050__$1 = state_14050;
if(cljs.core.truth_(inst_14006)){
var statearr_14086_14216 = state_14050__$1;
(statearr_14086_14216[(1)] = (78));

} else {
var statearr_14087_14217 = state_14050__$1;
(statearr_14087_14217[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (54))){
var inst_13935 = (state_14050[(2)]);
var inst_13936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13937 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13938 = (new cljs.core.PersistentVector(null,2,(5),inst_13936,inst_13937,null));
var inst_13939 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13938);
var inst_13940 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_13941 = fluree.db.dbproto._resolve(inst_13940);
var state_14050__$1 = (function (){var statearr_14088 = state_14050;
(statearr_14088[(10)] = inst_13935);

(statearr_14088[(43)] = inst_13939);

return statearr_14088;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14050__$1,(55),inst_13941);
} else {
if((state_val_14051 === (15))){
var inst_13828 = (state_14050[(50)]);
var state_14050__$1 = state_14050;
var statearr_14089_14218 = state_14050__$1;
(statearr_14089_14218[(2)] = inst_13828);

(statearr_14089_14218[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (48))){
var inst_13923 = (state_14050[(51)]);
var inst_13917 = (state_14050[(2)]);
var inst_13918 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13920 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13921 = (new cljs.core.PersistentVector(null,3,(5),inst_13919,inst_13920,null));
var inst_13922 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13921);
var inst_13923__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_14050__$1 = (function (){var statearr_14090 = state_14050;
(statearr_14090[(51)] = inst_13923__$1);

(statearr_14090[(27)] = inst_13922);

(statearr_14090[(28)] = inst_13917);

(statearr_14090[(36)] = inst_13918);

return statearr_14090;
})();
if(cljs.core.truth_(inst_13923__$1)){
var statearr_14091_14219 = state_14050__$1;
(statearr_14091_14219[(1)] = (49));

} else {
var statearr_14092_14220 = state_14050__$1;
(statearr_14092_14220[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (50))){
var inst_13926 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_14050__$1 = state_14050;
var statearr_14093_14221 = state_14050__$1;
(statearr_14093_14221[(2)] = inst_13926);

(statearr_14093_14221[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (75))){
var inst_13983 = (state_14050[(52)]);
var state_14050__$1 = state_14050;
var statearr_14094_14222 = state_14050__$1;
(statearr_14094_14222[(2)] = inst_13983);

(statearr_14094_14222[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (21))){
var inst_13870 = (state_14050[(2)]);
var inst_13871 = fluree.db.util.async.throw_err(inst_13870);
var state_14050__$1 = state_14050;
var statearr_14095_14223 = state_14050__$1;
(statearr_14095_14223[(2)] = inst_13871);

(statearr_14095_14223[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (31))){
var state_14050__$1 = state_14050;
var statearr_14096_14224 = state_14050__$1;
(statearr_14096_14224[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14096_14224[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (32))){
var inst_13834 = (state_14050[(46)]);
var state_14050__$1 = state_14050;
var statearr_14097_14225 = state_14050__$1;
(statearr_14097_14225[(2)] = inst_13834);

(statearr_14097_14225[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (40))){
var inst_13838 = (state_14050[(53)]);
var state_14050__$1 = state_14050;
var statearr_14098_14226 = state_14050__$1;
(statearr_14098_14226[(2)] = inst_13838);

(statearr_14098_14226[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (56))){
var inst_13947 = (state_14050[(2)]);
var inst_13948 = fluree.db.util.async.throw_err(inst_13947);
var inst_13949 = inst_13948;
var inst_13950 = (0);
var inst_13951 = null;
var state_14050__$1 = (function (){var statearr_14099 = state_14050;
(statearr_14099[(11)] = inst_13949);

(statearr_14099[(39)] = inst_13950);

(statearr_14099[(44)] = inst_13951);

return statearr_14099;
})();
var statearr_14100_14227 = state_14050__$1;
(statearr_14100_14227[(2)] = null);

(statearr_14100_14227[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (33))){
var inst_13831 = (state_14050[(54)]);
var inst_13892 = (state_14050[(2)]);
var state_14050__$1 = (function (){var statearr_14101 = state_14050;
(statearr_14101[(32)] = inst_13892);

return statearr_14101;
})();
if(cljs.core.truth_(inst_13831)){
var statearr_14102_14228 = state_14050__$1;
(statearr_14102_14228[(1)] = (34));

} else {
var statearr_14103_14229 = state_14050__$1;
(statearr_14103_14229[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (13))){
var inst_13852 = (state_14050[(2)]);
var inst_13853 = fluree.db.util.async.throw_err(inst_13852);
var state_14050__$1 = state_14050;
var statearr_14104_14230 = state_14050__$1;
(statearr_14104_14230[(2)] = inst_13853);

(statearr_14104_14230[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (22))){
var inst_13865 = (state_14050[(41)]);
var state_14050__$1 = state_14050;
var statearr_14105_14231 = state_14050__$1;
(statearr_14105_14231[(2)] = inst_13865);

(statearr_14105_14231[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (90))){
var inst_14021 = (state_14050[(7)]);
var inst_14022 = (state_14050[(9)]);
var inst_14039 = (state_14050[(2)]);
var inst_14040 = fluree.db.util.async.throw_err(inst_14039);
var inst_13949 = inst_14040;
var inst_13950 = inst_14022;
var inst_13951 = inst_14021;
var state_14050__$1 = (function (){var statearr_14106 = state_14050;
(statearr_14106[(11)] = inst_13949);

(statearr_14106[(39)] = inst_13950);

(statearr_14106[(44)] = inst_13951);

return statearr_14106;
})();
var statearr_14107_14232 = state_14050__$1;
(statearr_14107_14232[(2)] = null);

(statearr_14107_14232[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (36))){
var inst_13838 = (state_14050[(53)]);
var inst_13901 = (state_14050[(2)]);
var state_14050__$1 = (function (){var statearr_14108 = state_14050;
(statearr_14108[(33)] = inst_13901);

return statearr_14108;
})();
if(cljs.core.truth_(inst_13838)){
var statearr_14109_14233 = state_14050__$1;
(statearr_14109_14233[(1)] = (40));

} else {
var statearr_14110_14234 = state_14050__$1;
(statearr_14110_14234[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (41))){
var inst_13904 = (cljs.core._LT__EQ_ === end_test);
var state_14050__$1 = state_14050;
if(cljs.core.truth_(inst_13904)){
var statearr_14111_14235 = state_14050__$1;
(statearr_14111_14235[(1)] = (43));

} else {
var statearr_14112_14236 = state_14050__$1;
(statearr_14112_14236[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (89))){
var inst_14043 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
var statearr_14113_14237 = state_14050__$1;
(statearr_14113_14237[(2)] = inst_14043);

(statearr_14113_14237[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (43))){
var state_14050__$1 = state_14050;
var statearr_14114_14238 = state_14050__$1;
(statearr_14114_14238[(2)] = (2147483647));

(statearr_14114_14238[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (61))){
var inst_13957 = (state_14050[(18)]);
var state_14050__$1 = state_14050;
var statearr_14115_14239 = state_14050__$1;
(statearr_14115_14239[(2)] = inst_13957);

(statearr_14115_14239[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (29))){
var inst_13884 = (state_14050[(47)]);
var state_14050__$1 = state_14050;
var statearr_14116_14240 = state_14050__$1;
(statearr_14116_14240[(2)] = inst_13884);

(statearr_14116_14240[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (44))){
var state_14050__$1 = state_14050;
var statearr_14117_14241 = state_14050__$1;
(statearr_14117_14241[(2)] = fluree.db.util.core.min_integer);

(statearr_14117_14241[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (6))){
var inst_13826 = (state_14050[(14)]);
var inst_13841 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13826);
var state_14050__$1 = state_14050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14050__$1,(9),inst_13841);
} else {
if((state_val_14051 === (28))){
var inst_13874 = (state_14050[(21)]);
var state_14050__$1 = state_14050;
var statearr_14118_14242 = state_14050__$1;
(statearr_14118_14242[(2)] = inst_13874);

(statearr_14118_14242[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (64))){
var inst_13964 = (state_14050[(12)]);
var inst_13950 = (state_14050[(39)]);
var inst_13978 = cljs.core.seq(inst_13964);
var inst_13979 = cljs.core.first(inst_13978);
var inst_13980 = cljs.core.next(inst_13978);
var inst_13981 = inst_13964;
var inst_13982 = inst_13950;
var inst_13983 = inst_13964;
var state_14050__$1 = (function (){var statearr_14119 = state_14050;
(statearr_14119[(55)] = inst_13981);

(statearr_14119[(56)] = inst_13980);

(statearr_14119[(22)] = inst_13982);

(statearr_14119[(57)] = inst_13979);

(statearr_14119[(52)] = inst_13983);

return statearr_14119;
})();
var statearr_14120_14243 = state_14050__$1;
(statearr_14120_14243[(2)] = null);

(statearr_14120_14243[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (51))){
var inst_13928 = (state_14050[(2)]);
var inst_13929 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13930 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14050__$1 = (function (){var statearr_14121 = state_14050;
(statearr_14121[(37)] = inst_13929);

(statearr_14121[(40)] = inst_13928);

return statearr_14121;
})();
if(cljs.core.truth_(inst_13930)){
var statearr_14122_14244 = state_14050__$1;
(statearr_14122_14244[(1)] = (52));

} else {
var statearr_14123_14245 = state_14050__$1;
(statearr_14123_14245[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (25))){
var state_14050__$1 = state_14050;
var statearr_14124_14246 = state_14050__$1;
(statearr_14124_14246[(2)] = (-1));

(statearr_14124_14246[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (34))){
var inst_13831 = (state_14050[(54)]);
var state_14050__$1 = state_14050;
var statearr_14125_14247 = state_14050__$1;
(statearr_14125_14247[(2)] = inst_13831);

(statearr_14125_14247[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (17))){
var inst_13861 = (state_14050[(2)]);
var inst_13862 = fluree.db.util.async.throw_err(inst_13861);
var state_14050__$1 = state_14050;
var statearr_14126_14248 = state_14050__$1;
(statearr_14126_14248[(2)] = inst_13862);

(statearr_14126_14248[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (3))){
var inst_14048 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14050__$1,inst_14048);
} else {
if((state_val_14051 === (12))){
var inst_13828 = (state_14050[(50)]);
var inst_13856 = (state_14050[(2)]);
var inst_13857 = fluree.db.util.core.pred_ident_QMARK_(inst_13828);
var state_14050__$1 = (function (){var statearr_14127 = state_14050;
(statearr_14127[(38)] = inst_13856);

return statearr_14127;
})();
if(inst_13857){
var statearr_14128_14249 = state_14050__$1;
(statearr_14128_14249[(1)] = (14));

} else {
var statearr_14129_14250 = state_14050__$1;
(statearr_14129_14250[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (2))){
var inst_13832 = (state_14050[(26)]);
var inst_13825 = (state_14050[(29)]);
var inst_13826 = (state_14050[(14)]);
var _ = (function (){var statearr_14130 = state_14050;
(statearr_14130[(4)] = cljs.core.cons((5),(state_14050[(4)])));

return statearr_14130;
})();
var inst_13825__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_13826__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13825__$1,(0),null);
var inst_13827 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13825__$1,(1),null);
var inst_13828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13825__$1,(2),null);
var inst_13829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13825__$1,(3),null);
var inst_13830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13825__$1,(4),null);
var inst_13831 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13825__$1,(5),null);
var inst_13832__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_13833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13832__$1,(0),null);
var inst_13834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13832__$1,(1),null);
var inst_13835 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13832__$1,(2),null);
var inst_13836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13832__$1,(3),null);
var inst_13837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13832__$1,(4),null);
var inst_13838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13832__$1,(5),null);
var inst_13839 = fluree.db.util.core.pred_ident_QMARK_(inst_13826__$1);
var state_14050__$1 = (function (){var statearr_14131 = state_14050;
(statearr_14131[(58)] = inst_13833);

(statearr_14131[(25)] = inst_13837);

(statearr_14131[(26)] = inst_13832__$1);

(statearr_14131[(53)] = inst_13838);

(statearr_14131[(19)] = inst_13827);

(statearr_14131[(46)] = inst_13834);

(statearr_14131[(29)] = inst_13825__$1);

(statearr_14131[(30)] = inst_13830);

(statearr_14131[(50)] = inst_13828);

(statearr_14131[(34)] = inst_13836);

(statearr_14131[(59)] = inst_13835);

(statearr_14131[(14)] = inst_13826__$1);

(statearr_14131[(54)] = inst_13831);

(statearr_14131[(45)] = inst_13829);

return statearr_14131;
})();
if(inst_13839){
var statearr_14132_14251 = state_14050__$1;
(statearr_14132_14251[(1)] = (6));

} else {
var statearr_14133_14252 = state_14050__$1;
(statearr_14133_14252[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (66))){
var inst_13981 = (state_14050[(55)]);
var inst_13989 = (state_14050[(13)]);
var inst_13991 = (state_14050[(60)]);
var inst_13988 = cljs.core.seq(inst_13981);
var inst_13989__$1 = cljs.core.first(inst_13988);
var inst_13990 = cljs.core.next(inst_13988);
var inst_13991__$1 = (inst_13989__$1 == null);
var state_14050__$1 = (function (){var statearr_14134 = state_14050;
(statearr_14134[(61)] = inst_13990);

(statearr_14134[(13)] = inst_13989__$1);

(statearr_14134[(60)] = inst_13991__$1);

return statearr_14134;
})();
if(cljs.core.truth_(inst_13991__$1)){
var statearr_14135_14253 = state_14050__$1;
(statearr_14135_14253[(1)] = (68));

} else {
var statearr_14136_14254 = state_14050__$1;
(statearr_14136_14254[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (23))){
var inst_13875 = (state_14050[(20)]);
var state_14050__$1 = state_14050;
var statearr_14137_14255 = state_14050__$1;
(statearr_14137_14255[(2)] = inst_13875);

(statearr_14137_14255[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (47))){
var state_14050__$1 = state_14050;
var statearr_14138_14256 = state_14050__$1;
(statearr_14138_14256[(2)] = fluree.db.util.core.max_long);

(statearr_14138_14256[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (35))){
var inst_13895 = (cljs.core._GT__EQ_ === start_test);
var state_14050__$1 = state_14050;
if(cljs.core.truth_(inst_13895)){
var statearr_14139_14257 = state_14050__$1;
(statearr_14139_14257[(1)] = (37));

} else {
var statearr_14140_14258 = state_14050__$1;
(statearr_14140_14258[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (82))){
var inst_13965 = (state_14050[(8)]);
var state_14050__$1 = state_14050;
var statearr_14141_14259 = state_14050__$1;
(statearr_14141_14259[(2)] = inst_13965);

(statearr_14141_14259[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (76))){
var inst_14000 = (state_14050[(23)]);
var inst_13990 = (state_14050[(61)]);
var inst_14014 = (state_14050[(2)]);
var inst_13981 = inst_13990;
var inst_13982 = inst_14000;
var inst_13983 = inst_14014;
var state_14050__$1 = (function (){var statearr_14142 = state_14050;
(statearr_14142[(55)] = inst_13981);

(statearr_14142[(22)] = inst_13982);

(statearr_14142[(52)] = inst_13983);

return statearr_14142;
})();
var statearr_14143_14260 = state_14050__$1;
(statearr_14143_14260[(2)] = null);

(statearr_14143_14260[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (19))){
var inst_13835 = (state_14050[(59)]);
var state_14050__$1 = state_14050;
var statearr_14144_14261 = state_14050__$1;
(statearr_14144_14261[(2)] = inst_13835);

(statearr_14144_14261[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (57))){
var inst_13949 = (state_14050[(11)]);
var inst_13929 = (state_14050[(37)]);
var inst_13928 = (state_14050[(40)]);
var inst_13939 = (state_14050[(43)]);
var inst_13953 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_13949,inst_13928,inst_13929,inst_13939);
var state_14050__$1 = state_14050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14050__$1,(59),inst_13953);
} else {
if((state_val_14051 === (68))){
var inst_13991 = (state_14050[(60)]);
var state_14050__$1 = state_14050;
var statearr_14145_14262 = state_14050__$1;
(statearr_14145_14262[(2)] = inst_13991);

(statearr_14145_14262[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (11))){
var inst_13833 = (state_14050[(58)]);
var state_14050__$1 = state_14050;
var statearr_14147_14263 = state_14050__$1;
(statearr_14147_14263[(2)] = inst_13833);

(statearr_14147_14263[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (9))){
var inst_13843 = (state_14050[(2)]);
var inst_13844 = fluree.db.util.async.throw_err(inst_13843);
var state_14050__$1 = state_14050;
var statearr_14148_14264 = state_14050__$1;
(statearr_14148_14264[(2)] = inst_13844);

(statearr_14148_14264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (5))){
var _ = (function (){var statearr_14149 = state_14050;
(statearr_14149[(4)] = cljs.core.rest((state_14050[(4)])));

return statearr_14149;
})();
var state_14050__$1 = state_14050;
var ex14146 = (state_14050__$1[(2)]);
var statearr_14150_14265 = state_14050__$1;
(statearr_14150_14265[(5)] = ex14146);


if((ex14146 instanceof Error)){
var statearr_14151_14266 = state_14050__$1;
(statearr_14151_14266[(1)] = (4));

(statearr_14151_14266[(5)] = null);

} else {
throw ex14146;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (83))){
var inst_14033 = (state_14050[(2)]);
var inst_14034 = cljs.core.not(inst_14033);
var state_14050__$1 = state_14050;
if(inst_14034){
var statearr_14152_14267 = state_14050__$1;
(statearr_14152_14267[(1)] = (87));

} else {
var statearr_14153_14268 = state_14050__$1;
(statearr_14153_14268[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (14))){
var inst_13828 = (state_14050[(50)]);
var inst_13859 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13828);
var state_14050__$1 = state_14050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14050__$1,(17),inst_13859);
} else {
if((state_val_14051 === (45))){
var inst_13908 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
var statearr_14154_14269 = state_14050__$1;
(statearr_14154_14269[(2)] = inst_13908);

(statearr_14154_14269[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (53))){
var state_14050__$1 = state_14050;
var statearr_14155_14270 = state_14050__$1;
(statearr_14155_14270[(2)] = true);

(statearr_14155_14270[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (78))){
var inst_13983 = (state_14050[(52)]);
var state_14050__$1 = state_14050;
var statearr_14156_14271 = state_14050__$1;
(statearr_14156_14271[(2)] = inst_13983);

(statearr_14156_14271[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (26))){
var inst_13827 = (state_14050[(19)]);
var state_14050__$1 = state_14050;
var statearr_14157_14272 = state_14050__$1;
(statearr_14157_14272[(2)] = inst_13827);

(statearr_14157_14272[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (16))){
var inst_13835 = (state_14050[(59)]);
var inst_13865 = (state_14050[(2)]);
var inst_13866 = fluree.db.util.core.pred_ident_QMARK_(inst_13835);
var state_14050__$1 = (function (){var statearr_14158 = state_14050;
(statearr_14158[(41)] = inst_13865);

return statearr_14158;
})();
if(inst_13866){
var statearr_14159_14273 = state_14050__$1;
(statearr_14159_14273[(1)] = (18));

} else {
var statearr_14160_14274 = state_14050__$1;
(statearr_14160_14274[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (81))){
var inst_13965 = (state_14050[(8)]);
var inst_13922 = (state_14050[(27)]);
var inst_13912 = (state_14050[(17)]);
var inst_14025 = (state_14050[(48)]);
var inst_14024 = (inst_13922.cljs$core$IFn$_invoke$arity$2 ? inst_13922.cljs$core$IFn$_invoke$arity$2(inst_13965,inst_13912) : inst_13922.call(null,inst_13965,inst_13912));
var inst_14025__$1 = (inst_14024 < (0));
var state_14050__$1 = (function (){var statearr_14161 = state_14050;
(statearr_14161[(48)] = inst_14025__$1);

return statearr_14161;
})();
if(cljs.core.truth_(inst_14025__$1)){
var statearr_14162_14275 = state_14050__$1;
(statearr_14162_14275[(1)] = (84));

} else {
var statearr_14163_14276 = state_14050__$1;
(statearr_14163_14276[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (79))){
var inst_13989 = (state_14050[(13)]);
var inst_13983 = (state_14050[(52)]);
var inst_14009 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_13983,inst_13989);
var state_14050__$1 = state_14050;
var statearr_14164_14277 = state_14050__$1;
(statearr_14164_14277[(2)] = inst_14009);

(statearr_14164_14277[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (38))){
var state_14050__$1 = state_14050;
var statearr_14165_14278 = state_14050__$1;
(statearr_14165_14278[(2)] = (2147483647));

(statearr_14165_14278[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (87))){
var inst_14021 = (state_14050[(7)]);
var state_14050__$1 = state_14050;
var statearr_14166_14279 = state_14050__$1;
(statearr_14166_14279[(2)] = inst_14021);

(statearr_14166_14279[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (30))){
var inst_13888 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
if(cljs.core.truth_(inst_13888)){
var statearr_14167_14280 = state_14050__$1;
(statearr_14167_14280[(1)] = (31));

} else {
var statearr_14168_14281 = state_14050__$1;
(statearr_14168_14281[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (73))){
var inst_14017 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
var statearr_14169_14282 = state_14050__$1;
(statearr_14169_14282[(2)] = inst_14017);

(statearr_14169_14282[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (10))){
var inst_13833 = (state_14050[(58)]);
var inst_13850 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13833);
var state_14050__$1 = state_14050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14050__$1,(13),inst_13850);
} else {
if((state_val_14051 === (18))){
var inst_13835 = (state_14050[(59)]);
var inst_13868 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13835);
var state_14050__$1 = state_14050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14050__$1,(21),inst_13868);
} else {
if((state_val_14051 === (52))){
var inst_13883 = (state_14050[(24)]);
var inst_13892 = (state_14050[(32)]);
var inst_13918 = (state_14050[(36)]);
var inst_13856 = (state_14050[(38)]);
var inst_13847 = (state_14050[(42)]);
var inst_13932 = fluree.db.permissions_validate.no_filter_QMARK_(inst_13918,inst_13847,inst_13856,inst_13883,inst_13892);
var state_14050__$1 = state_14050;
var statearr_14170_14283 = state_14050__$1;
(statearr_14170_14283[(2)] = inst_13932);

(statearr_14170_14283[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (67))){
var inst_14019 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
var statearr_14171_14284 = state_14050__$1;
(statearr_14171_14284[(2)] = inst_14019);

(statearr_14171_14284[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (71))){
var inst_13983 = (state_14050[(52)]);
var inst_13951 = (state_14050[(44)]);
var inst_13998 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13983,inst_13951);
var state_14050__$1 = state_14050;
var statearr_14172_14285 = state_14050__$1;
(statearr_14172_14285[(2)] = inst_13998);

(statearr_14172_14285[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (42))){
var inst_13883 = (state_14050[(24)]);
var inst_13837 = (state_14050[(25)]);
var inst_13830 = (state_14050[(30)]);
var inst_13892 = (state_14050[(32)]);
var inst_13901 = (state_14050[(33)]);
var inst_13836 = (state_14050[(34)]);
var inst_13910 = (state_14050[(35)]);
var inst_13856 = (state_14050[(38)]);
var inst_13874 = (state_14050[(21)]);
var inst_13865 = (state_14050[(41)]);
var inst_13847 = (state_14050[(42)]);
var inst_13913 = (state_14050[(49)]);
var inst_13829 = (state_14050[(45)]);
var inst_13910__$1 = (state_14050[(2)]);
var inst_13911 = fluree.db.flake.__GT_Flake(inst_13847,inst_13883,inst_13865,inst_13829,inst_13830,inst_13901);
var inst_13912 = fluree.db.flake.__GT_Flake(inst_13856,inst_13892,inst_13874,inst_13836,inst_13837,inst_13910__$1);
var inst_13913__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_14050__$1 = (function (){var statearr_14173 = state_14050;
(statearr_14173[(15)] = inst_13911);

(statearr_14173[(35)] = inst_13910__$1);

(statearr_14173[(17)] = inst_13912);

(statearr_14173[(49)] = inst_13913__$1);

return statearr_14173;
})();
if(cljs.core.truth_(inst_13913__$1)){
var statearr_14174_14286 = state_14050__$1;
(statearr_14174_14286[(1)] = (46));

} else {
var statearr_14175_14287 = state_14050__$1;
(statearr_14175_14287[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (80))){
var inst_14011 = (state_14050[(2)]);
var state_14050__$1 = state_14050;
var statearr_14176_14288 = state_14050__$1;
(statearr_14176_14288[(2)] = inst_14011);

(statearr_14176_14288[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (37))){
var state_14050__$1 = state_14050;
var statearr_14177_14289 = state_14050__$1;
(statearr_14177_14289[(2)] = fluree.db.util.core.min_integer);

(statearr_14177_14289[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (63))){
var inst_13917 = (state_14050[(28)]);
var inst_13964 = (state_14050[(12)]);
var inst_13950 = (state_14050[(39)]);
var inst_13951 = (state_14050[(44)]);
var inst_13967 = (inst_13917 - inst_13950);
var inst_13968 = fluree.db.flake.take(inst_13967,inst_13964);
var inst_13969 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13968,inst_13951);
var state_14050__$1 = state_14050;
var statearr_14178_14290 = state_14050__$1;
(statearr_14178_14290[(2)] = inst_13969);

(statearr_14178_14290[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (8))){
var inst_13833 = (state_14050[(58)]);
var inst_13847 = (state_14050[(2)]);
var inst_13848 = fluree.db.util.core.pred_ident_QMARK_(inst_13833);
var state_14050__$1 = (function (){var statearr_14179 = state_14050;
(statearr_14179[(42)] = inst_13847);

return statearr_14179;
})();
if(inst_13848){
var statearr_14180_14291 = state_14050__$1;
(statearr_14180_14291[(1)] = (10));

} else {
var statearr_14181_14292 = state_14050__$1;
(statearr_14181_14292[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (49))){
var inst_13923 = (state_14050[(51)]);
var state_14050__$1 = state_14050;
var statearr_14182_14293 = state_14050__$1;
(statearr_14182_14293[(2)] = inst_13923);

(statearr_14182_14293[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14051 === (84))){
var inst_14022 = (state_14050[(9)]);
var inst_13917 = (state_14050[(28)]);
var inst_14027 = (inst_14022 < inst_13917);
var state_14050__$1 = state_14050;
var statearr_14183_14294 = state_14050__$1;
(statearr_14183_14294[(2)] = inst_14027);

(statearr_14183_14294[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_14184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14184[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_14184[(1)] = (1));

return statearr_14184;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14050){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14050);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14185){var ex__2730__auto__ = e14185;
var statearr_14186_14295 = state_14050;
(statearr_14186_14295[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14050[(4)]))){
var statearr_14187_14296 = state_14050;
(statearr_14187_14296[(1)] = cljs.core.first((state_14050[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14297 = state_14050;
state_14050 = G__14297;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14050){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14188 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14188[(6)] = c__2749__auto__);

return statearr_14188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14372){
var state_val_14373 = (state_14372[(1)]);
if((state_val_14373 === (7))){
var inst_14367 = (state_14372[(2)]);
var _ = (function (){var statearr_14374 = state_14372;
(statearr_14374[(4)] = cljs.core.rest((state_14372[(4)])));

return statearr_14374;
})();
var state_14372__$1 = state_14372;
var statearr_14375_14415 = state_14372__$1;
(statearr_14375_14415[(2)] = inst_14367);

(statearr_14375_14415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (20))){
var inst_14349 = (state_14372[(2)]);
var inst_14350 = fluree.db.util.async.throw_err(inst_14349);
var state_14372__$1 = state_14372;
var statearr_14376_14416 = state_14372__$1;
(statearr_14376_14416[(2)] = inst_14350);

(statearr_14376_14416[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (1))){
var state_14372__$1 = state_14372;
var statearr_14377_14417 = state_14372__$1;
(statearr_14377_14417[(2)] = null);

(statearr_14377_14417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (4))){
var inst_14298 = (state_14372[(2)]);
var state_14372__$1 = state_14372;
var statearr_14378_14418 = state_14372__$1;
(statearr_14378_14418[(2)] = inst_14298);

(statearr_14378_14418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (15))){
var inst_14345 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14372__$1 = state_14372;
if(cljs.core.truth_(inst_14345)){
var statearr_14379_14419 = state_14372__$1;
(statearr_14379_14419[(1)] = (17));

} else {
var statearr_14380_14420 = state_14372__$1;
(statearr_14380_14420[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (21))){
var state_14372__$1 = state_14372;
var statearr_14381_14421 = state_14372__$1;
(statearr_14381_14421[(2)] = (0));

(statearr_14381_14421[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (13))){
var inst_14337 = (state_14372[(2)]);
var state_14372__$1 = state_14372;
var statearr_14382_14422 = state_14372__$1;
(statearr_14382_14422[(2)] = inst_14337);

(statearr_14382_14422[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (22))){
var state_14372__$1 = state_14372;
var statearr_14383_14423 = state_14372__$1;
(statearr_14383_14423[(2)] = (1));

(statearr_14383_14423[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (6))){
var inst_14327 = (state_14372[(7)]);
var inst_14318 = (state_14372[(8)]);
var inst_14329 = (state_14372[(9)]);
var inst_14326 = cljs.core.seq(inst_14318);
var inst_14327__$1 = cljs.core.first(inst_14326);
var inst_14328 = cljs.core.next(inst_14326);
var inst_14329__$1 = (inst_14327__$1 == null);
var state_14372__$1 = (function (){var statearr_14384 = state_14372;
(statearr_14384[(10)] = inst_14328);

(statearr_14384[(7)] = inst_14327__$1);

(statearr_14384[(9)] = inst_14329__$1);

return statearr_14384;
})();
if(cljs.core.truth_(inst_14329__$1)){
var statearr_14385_14424 = state_14372__$1;
(statearr_14385_14424[(1)] = (8));

} else {
var statearr_14386_14425 = state_14372__$1;
(statearr_14386_14425[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (17))){
var inst_14327 = (state_14372[(7)]);
var inst_14347 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_14327);
var state_14372__$1 = state_14372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14372__$1,(20),inst_14347);
} else {
if((state_val_14373 === (3))){
var inst_14370 = (state_14372[(2)]);
var state_14372__$1 = state_14372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14372__$1,inst_14370);
} else {
if((state_val_14373 === (12))){
var inst_14320 = (state_14372[(11)]);
var inst_14335 = (inst_14320 >= subject_limit);
var state_14372__$1 = state_14372;
var statearr_14387_14426 = state_14372__$1;
(statearr_14387_14426[(2)] = inst_14335);

(statearr_14387_14426[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (2))){
var _ = (function (){var statearr_14388 = state_14372;
(statearr_14388[(4)] = cljs.core.cons((5),(state_14372[(4)])));

return statearr_14388;
})();
var inst_14311 = subject_groups;
var inst_14312 = cljs.core.seq(inst_14311);
var inst_14313 = cljs.core.first(inst_14312);
var inst_14314 = cljs.core.next(inst_14312);
var inst_14315 = flake_start;
var inst_14316 = subject_start;
var inst_14317 = cljs.core.PersistentVector.EMPTY;
var inst_14318 = inst_14311;
var inst_14319 = inst_14315;
var inst_14320 = inst_14316;
var inst_14321 = inst_14317;
var state_14372__$1 = (function (){var statearr_14389 = state_14372;
(statearr_14389[(11)] = inst_14320);

(statearr_14389[(12)] = inst_14319);

(statearr_14389[(13)] = inst_14321);

(statearr_14389[(14)] = inst_14314);

(statearr_14389[(15)] = inst_14313);

(statearr_14389[(8)] = inst_14318);

return statearr_14389;
})();
var statearr_14390_14427 = state_14372__$1;
(statearr_14390_14427[(2)] = null);

(statearr_14390_14427[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (23))){
var inst_14328 = (state_14372[(10)]);
var inst_14353 = (state_14372[(16)]);
var inst_14320 = (state_14372[(11)]);
var inst_14319 = (state_14372[(12)]);
var inst_14321 = (state_14372[(13)]);
var inst_14354 = (state_14372[(17)]);
var inst_14359 = (state_14372[(2)]);
var inst_14360 = (inst_14319 + inst_14354);
var inst_14361 = (inst_14320 + inst_14359);
var inst_14362 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14321,inst_14353);
var inst_14318 = inst_14328;
var inst_14319__$1 = inst_14360;
var inst_14320__$1 = inst_14361;
var inst_14321__$1 = inst_14362;
var state_14372__$1 = (function (){var statearr_14391 = state_14372;
(statearr_14391[(11)] = inst_14320__$1);

(statearr_14391[(12)] = inst_14319__$1);

(statearr_14391[(13)] = inst_14321__$1);

(statearr_14391[(8)] = inst_14318);

return statearr_14391;
})();
var statearr_14392_14428 = state_14372__$1;
(statearr_14392_14428[(2)] = null);

(statearr_14392_14428[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (19))){
var inst_14353 = (state_14372[(16)]);
var inst_14354 = (state_14372[(17)]);
var inst_14353__$1 = (state_14372[(2)]);
var inst_14354__$1 = cljs.core.count(inst_14353__$1);
var inst_14355 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14354__$1);
var state_14372__$1 = (function (){var statearr_14393 = state_14372;
(statearr_14393[(16)] = inst_14353__$1);

(statearr_14393[(17)] = inst_14354__$1);

return statearr_14393;
})();
if(inst_14355){
var statearr_14394_14429 = state_14372__$1;
(statearr_14394_14429[(1)] = (21));

} else {
var statearr_14395_14430 = state_14372__$1;
(statearr_14395_14430[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (11))){
var inst_14332 = (state_14372[(18)]);
var state_14372__$1 = state_14372;
var statearr_14397_14431 = state_14372__$1;
(statearr_14397_14431[(2)] = inst_14332);

(statearr_14397_14431[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (9))){
var inst_14332 = (state_14372[(18)]);
var inst_14319 = (state_14372[(12)]);
var inst_14332__$1 = (inst_14319 >= flake_limit);
var state_14372__$1 = (function (){var statearr_14398 = state_14372;
(statearr_14398[(18)] = inst_14332__$1);

return statearr_14398;
})();
if(cljs.core.truth_(inst_14332__$1)){
var statearr_14399_14432 = state_14372__$1;
(statearr_14399_14432[(1)] = (11));

} else {
var statearr_14400_14433 = state_14372__$1;
(statearr_14400_14433[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (5))){
var _ = (function (){var statearr_14401 = state_14372;
(statearr_14401[(4)] = cljs.core.rest((state_14372[(4)])));

return statearr_14401;
})();
var state_14372__$1 = state_14372;
var ex14396 = (state_14372__$1[(2)]);
var statearr_14402_14434 = state_14372__$1;
(statearr_14402_14434[(5)] = ex14396);


if((ex14396 instanceof Error)){
var statearr_14403_14435 = state_14372__$1;
(statearr_14403_14435[(1)] = (4));

(statearr_14403_14435[(5)] = null);

} else {
throw ex14396;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (14))){
var inst_14320 = (state_14372[(11)]);
var inst_14319 = (state_14372[(12)]);
var inst_14321 = (state_14372[(13)]);
var inst_14341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14342 = [inst_14319,inst_14320,inst_14321];
var inst_14343 = (new cljs.core.PersistentVector(null,3,(5),inst_14341,inst_14342,null));
var state_14372__$1 = state_14372;
var statearr_14404_14436 = state_14372__$1;
(statearr_14404_14436[(2)] = inst_14343);

(statearr_14404_14436[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (16))){
var inst_14365 = (state_14372[(2)]);
var state_14372__$1 = state_14372;
var statearr_14405_14437 = state_14372__$1;
(statearr_14405_14437[(2)] = inst_14365);

(statearr_14405_14437[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (10))){
var inst_14339 = (state_14372[(2)]);
var state_14372__$1 = state_14372;
if(cljs.core.truth_(inst_14339)){
var statearr_14406_14438 = state_14372__$1;
(statearr_14406_14438[(1)] = (14));

} else {
var statearr_14407_14439 = state_14372__$1;
(statearr_14407_14439[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (18))){
var inst_14327 = (state_14372[(7)]);
var state_14372__$1 = state_14372;
var statearr_14408_14440 = state_14372__$1;
(statearr_14408_14440[(2)] = inst_14327);

(statearr_14408_14440[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14373 === (8))){
var inst_14329 = (state_14372[(9)]);
var state_14372__$1 = state_14372;
var statearr_14409_14441 = state_14372__$1;
(statearr_14409_14441[(2)] = inst_14329);

(statearr_14409_14441[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_14410 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14410[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto__);

(statearr_14410[(1)] = (1));

return statearr_14410;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto____1 = (function (state_14372){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14372);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14411){var ex__2730__auto__ = e14411;
var statearr_14412_14442 = state_14372;
(statearr_14412_14442[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14372[(4)]))){
var statearr_14413_14443 = state_14372;
(statearr_14413_14443[(1)] = cljs.core.first((state_14372[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14444 = state_14372;
state_14372 = G__14444;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto__ = function(state_14372){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto____1.call(this,state_14372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14414 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14414[(6)] = c__2749__auto__);

return statearr_14414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14490){
var state_val_14491 = (state_14490[(1)]);
if((state_val_14491 === (7))){
var state_14490__$1 = state_14490;
var statearr_14492_14530 = state_14490__$1;
(statearr_14492_14530[(2)] = null);

(statearr_14492_14530[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (20))){
var inst_14476 = (state_14490[(2)]);
var inst_14477 = fluree.db.util.async.throw_err(inst_14476);
var inst_14455 = inst_14477;
var state_14490__$1 = (function (){var statearr_14493 = state_14490;
(statearr_14493[(7)] = inst_14455);

return statearr_14493;
})();
var statearr_14494_14531 = state_14490__$1;
(statearr_14494_14531[(2)] = null);

(statearr_14494_14531[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (1))){
var state_14490__$1 = state_14490;
var statearr_14495_14532 = state_14490__$1;
(statearr_14495_14532[(2)] = null);

(statearr_14495_14532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (4))){
var inst_14445 = (state_14490[(2)]);
var state_14490__$1 = state_14490;
var statearr_14496_14533 = state_14490__$1;
(statearr_14496_14533[(2)] = inst_14445);

(statearr_14496_14533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (15))){
var inst_14455 = (state_14490[(7)]);
var inst_14472 = (state_14490[(8)]);
var inst_14472__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_14455);
var state_14490__$1 = (function (){var statearr_14497 = state_14490;
(statearr_14497[(8)] = inst_14472__$1);

return statearr_14497;
})();
if(cljs.core.truth_(inst_14472__$1)){
var statearr_14498_14534 = state_14490__$1;
(statearr_14498_14534[(1)] = (17));

} else {
var statearr_14499_14535 = state_14490__$1;
(statearr_14499_14535[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (13))){
var inst_14465 = (state_14490[(2)]);
var inst_14466 = fluree.db.util.async.throw_err(inst_14465);
var _ = (function (){var statearr_14500 = state_14490;
(statearr_14500[(4)] = cljs.core.rest((state_14490[(4)])));

return statearr_14500;
})();
var state_14490__$1 = state_14490;
var statearr_14501_14536 = state_14490__$1;
(statearr_14501_14536[(2)] = inst_14466);

(statearr_14501_14536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (6))){
var inst_14453 = (state_14490[(2)]);
var inst_14454 = fluree.db.util.async.throw_err(inst_14453);
var inst_14455 = inst_14454;
var state_14490__$1 = (function (){var statearr_14502 = state_14490;
(statearr_14502[(7)] = inst_14455);

return statearr_14502;
})();
var statearr_14503_14537 = state_14490__$1;
(statearr_14503_14537[(2)] = null);

(statearr_14503_14537[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (17))){
var inst_14472 = (state_14490[(8)]);
var inst_14474 = fluree.db.dbproto._lookup_leaf(root_node,inst_14472);
var state_14490__$1 = state_14490;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14490__$1,(20),inst_14474);
} else {
if((state_val_14491 === (3))){
var inst_14488 = (state_14490[(2)]);
var state_14490__$1 = state_14490;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14490__$1,inst_14488);
} else {
if((state_val_14491 === (12))){
var _ = (function (){var statearr_14505 = state_14490;
(statearr_14505[(4)] = cljs.core.rest((state_14490[(4)])));

return statearr_14505;
})();
var state_14490__$1 = state_14490;
var ex14504 = (state_14490__$1[(2)]);
var statearr_14506_14538 = state_14490__$1;
(statearr_14506_14538[(5)] = ex14504);


var statearr_14507_14539 = state_14490__$1;
(statearr_14507_14539[(1)] = (11));

(statearr_14507_14539[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (2))){
var _ = (function (){var statearr_14508 = state_14490;
(statearr_14508[(4)] = cljs.core.cons((5),(state_14490[(4)])));

return statearr_14508;
})();
var inst_14451 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_14490__$1 = state_14490;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14490__$1,(6),inst_14451);
} else {
if((state_val_14491 === (19))){
var inst_14481 = (state_14490[(2)]);
var state_14490__$1 = state_14490;
var statearr_14509_14540 = state_14490__$1;
(statearr_14509_14540[(2)] = inst_14481);

(statearr_14509_14540[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (11))){
var inst_14457 = (state_14490[(2)]);
var state_14490__$1 = (function (){var statearr_14511 = state_14490;
(statearr_14511[(9)] = inst_14457);

return statearr_14511;
})();
var statearr_14512_14541 = state_14490__$1;
(statearr_14512_14541[(2)] = null);

(statearr_14512_14541[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (9))){
var inst_14455 = (state_14490[(7)]);
var _ = (function (){var statearr_14513 = state_14490;
(statearr_14513[(4)] = cljs.core.cons((12),(state_14490[(4)])));

return statearr_14513;
})();
var inst_14463 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_14455,t,novelty,fast_forward_db_QMARK_);
var state_14490__$1 = state_14490;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14490__$1,(13),inst_14463);
} else {
if((state_val_14491 === (5))){
var _ = (function (){var statearr_14514 = state_14490;
(statearr_14514[(4)] = cljs.core.rest((state_14490[(4)])));

return statearr_14514;
})();
var state_14490__$1 = state_14490;
var ex14510 = (state_14490__$1[(2)]);
var statearr_14515_14542 = state_14490__$1;
(statearr_14515_14542[(5)] = ex14510);


if((ex14510 instanceof Error)){
var statearr_14516_14543 = state_14490__$1;
(statearr_14516_14543[(1)] = (4));

(statearr_14516_14543[(5)] = null);

} else {
throw ex14510;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (14))){
var inst_14469 = (state_14490[(10)]);
var state_14490__$1 = state_14490;
var statearr_14517_14544 = state_14490__$1;
(statearr_14517_14544[(2)] = inst_14469);

(statearr_14517_14544[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (16))){
var inst_14483 = (state_14490[(2)]);
var state_14490__$1 = state_14490;
var statearr_14518_14545 = state_14490__$1;
(statearr_14518_14545[(2)] = inst_14483);

(statearr_14518_14545[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (10))){
var inst_14469 = (state_14490[(10)]);
var inst_14469__$1 = (state_14490[(2)]);
var state_14490__$1 = (function (){var statearr_14519 = state_14490;
(statearr_14519[(10)] = inst_14469__$1);

return statearr_14519;
})();
if(cljs.core.truth_(inst_14469__$1)){
var statearr_14520_14546 = state_14490__$1;
(statearr_14520_14546[(1)] = (14));

} else {
var statearr_14521_14547 = state_14490__$1;
(statearr_14521_14547[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (18))){
var state_14490__$1 = state_14490;
var statearr_14522_14548 = state_14490__$1;
(statearr_14522_14548[(2)] = null);

(statearr_14522_14548[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (8))){
var inst_14485 = (state_14490[(2)]);
var _ = (function (){var statearr_14523 = state_14490;
(statearr_14523[(4)] = cljs.core.rest((state_14490[(4)])));

return statearr_14523;
})();
var state_14490__$1 = state_14490;
var statearr_14524_14549 = state_14490__$1;
(statearr_14524_14549[(2)] = inst_14485);

(statearr_14524_14549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto____0 = (function (){
var statearr_14525 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14525[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto__);

(statearr_14525[(1)] = (1));

return statearr_14525;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto____1 = (function (state_14490){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14490);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14526){var ex__2730__auto__ = e14526;
var statearr_14527_14550 = state_14490;
(statearr_14527_14550[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14490[(4)]))){
var statearr_14528_14551 = state_14490;
(statearr_14528_14551[(1)] = cljs.core.first((state_14490[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14552 = state_14490;
state_14490 = G__14552;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto__ = function(state_14490){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto____1.call(this,state_14490);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14529 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14529[(6)] = c__2749__auto__);

return statearr_14529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14559 = arguments.length;
switch (G__14559) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14560 = (function (){var pred__14563 = cljs.core.identical_QMARK_;
var expr__14564 = test;
if(cljs.core.truth_((pred__14563.cljs$core$IFn$_invoke$arity$2 ? pred__14563.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__14564) : pred__14563.call(null,cljs.core._EQ_,expr__14564)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14563.cljs$core$IFn$_invoke$arity$2 ? pred__14563.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__14564) : pred__14563.call(null,cljs.core._LT_,expr__14564)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__14563.cljs$core$IFn$_invoke$arity$2 ? pred__14563.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__14564) : pred__14563.call(null,cljs.core._LT__EQ_,expr__14564)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14563.cljs$core$IFn$_invoke$arity$2 ? pred__14563.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__14564) : pred__14563.call(null,cljs.core._GT_,expr__14564)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__14563.cljs$core$IFn$_invoke$arity$2 ? pred__14563.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__14564) : pred__14563.call(null,cljs.core._GT__EQ_,expr__14564)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14564)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14560,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14560,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14560,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14560,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14936){
var state_val_14937 = (state_14936[(1)]);
if((state_val_14937 === (121))){
var inst_14892 = (state_14936[(7)]);
var state_14936__$1 = state_14936;
var statearr_14938_15134 = state_14936__$1;
(statearr_14938_15134[(2)] = inst_14892);

(statearr_14938_15134[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (65))){
var inst_14744 = (state_14936[(8)]);
var inst_14750 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14939 = state_14936;
(statearr_14939[(9)] = inst_14750);

return statearr_14939;
})();
if(cljs.core.truth_(inst_14744)){
var statearr_14940_15135 = state_14936__$1;
(statearr_14940_15135[(1)] = (66));

} else {
var statearr_14941_15136 = state_14936__$1;
(statearr_14941_15136[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (70))){
var inst_14928 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_14942_15137 = state_14936__$1;
(statearr_14942_15137[(2)] = inst_14928);

(statearr_14942_15137[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (62))){
var inst_14743 = (state_14936[(2)]);
var inst_14744 = fluree.db.util.async.throw_err(inst_14743);
var inst_14745 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14936__$1 = (function (){var statearr_14943 = state_14936;
(statearr_14943[(8)] = inst_14744);

return statearr_14943;
})();
if(cljs.core.truth_(inst_14745)){
var statearr_14944_15138 = state_14936__$1;
(statearr_14944_15138[(1)] = (63));

} else {
var statearr_14945_15139 = state_14936__$1;
(statearr_14945_15139[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (74))){
var inst_14771 = (state_14936[(10)]);
var inst_14622 = (state_14936[(11)]);
var inst_14601 = (state_14936[(12)]);
var inst_14725 = (state_14936[(13)]);
var inst_14730 = (state_14936[(14)]);
var inst_14724 = (state_14936[(15)]);
var inst_14740 = (state_14936[(16)]);
var inst_14667 = (state_14936[(17)]);
var inst_14703 = (state_14936[(18)]);
var inst_14658 = (state_14936[(19)]);
var inst_14750 = (state_14936[(9)]);
var inst_14597 = (state_14936[(20)]);
var inst_14603 = (state_14936[(21)]);
var inst_14602 = (state_14936[(22)]);
var inst_14717 = (state_14936[(23)]);
var inst_14590 = (state_14936[(24)]);
var inst_14763 = (state_14936[(25)]);
var inst_14676 = (state_14936[(26)]);
var inst_14723 = (state_14936[(27)]);
var inst_14714 = (state_14936[(28)]);
var inst_14593 = (state_14936[(29)]);
var inst_14713 = (state_14936[(30)]);
var inst_14685 = (state_14936[(31)]);
var inst_14756 = (state_14936[(32)]);
var inst_14654 = (state_14936[(33)]);
var inst_14744 = (state_14936[(8)]);
var inst_14712 = (state_14936[(34)]);
var inst_14734 = (state_14936[(35)]);
var inst_14755 = (state_14936[(36)]);
var inst_14754 = (state_14936[(37)]);
var inst_14729 = (state_14936[(38)]);
var inst_14655 = (state_14936[(39)]);
var inst_14613 = (state_14936[(40)]);
var inst_14753 = (state_14936[(41)]);
var inst_14591 = (state_14936[(42)]);
var inst_14735 = (state_14936[(43)]);
var inst_14598 = (state_14936[(44)]);
var inst_14586 = (state_14936[(45)]);
var inst_14757 = (state_14936[(46)]);
var inst_14694 = (state_14936[(47)]);
var inst_14716 = (state_14936[(48)]);
var inst_14773 = (function (){var no_filter_QMARK_ = inst_14750;
var t = inst_14730;
var max_limit_QMARK_ = inst_14724;
var next_node = inst_14753;
var fast_forward_db_QMARK_ = inst_14735;
var s1 = inst_14613;
var vec__14572 = inst_14586;
var o2 = inst_14676;
var G__14764 = inst_14771;
var t1 = inst_14590;
var predicate_fn = inst_14603;
var i = inst_14755;
var map__14578 = inst_14601;
var m1 = inst_14703;
var root_node = inst_14740;
var s2 = inst_14622;
var vec__14575 = inst_14593;
var vec__14579 = inst_14654;
var p2 = inst_14694;
var permissions = inst_14725;
var limit = inst_14723;
var vec__14582 = inst_14655;
var start_flake = inst_14713;
var flake_limit = inst_14717;
var offset = inst_14754;
var acc = inst_14757;
var t2 = inst_14597;
var op1 = inst_14591;
var o1 = inst_14667;
var end_flake = inst_14714;
var base_result = inst_14763;
var s = inst_14756;
var node_start = inst_14744;
var p1 = inst_14685;
var subject_fn = inst_14602;
var object_fn = inst_14658;
var map__14585 = inst_14716;
var idx_compare = inst_14729;
var op2 = inst_14598;
var m2 = inst_14712;
var novelty = inst_14734;
return (function (p1__14554_SHARP_){
var G__14946 = p1__14554_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__14946) : subject_fn.call(null,G__14946));
});
})();
var inst_14774 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14773,inst_14771);
var state_14936__$1 = state_14936;
var statearr_14947_15140 = state_14936__$1;
(statearr_14947_15140[(2)] = inst_14774);

(statearr_14947_15140[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (110))){
var inst_14905 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_14948_15141 = state_14936__$1;
(statearr_14948_15141[(2)] = inst_14905);

(statearr_14948_15141[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (7))){
var inst_14587 = (state_14936[(49)]);
var state_14936__$1 = state_14936;
var statearr_14949_15142 = state_14936__$1;
(statearr_14949_15142[(2)] = inst_14587);

(statearr_14949_15142[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (59))){
var state_14936__$1 = state_14936;
var statearr_14950_15143 = state_14936__$1;
(statearr_14950_15143[(2)] = fluree.db.util.core.max_long);

(statearr_14950_15143[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (86))){
var inst_14750 = (state_14936[(9)]);
var state_14936__$1 = state_14936;
var statearr_14951_15144 = state_14936__$1;
(statearr_14951_15144[(2)] = inst_14750);

(statearr_14951_15144[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (20))){
var state_14936__$1 = state_14936;
var statearr_14952_15145 = state_14936__$1;
(statearr_14952_15145[(2)] = null);

(statearr_14952_15145[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (72))){
var inst_14763 = (state_14936[(25)]);
var state_14936__$1 = state_14936;
var statearr_14953_15146 = state_14936__$1;
(statearr_14953_15146[(2)] = inst_14763);

(statearr_14953_15146[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (58))){
var inst_14718 = (state_14936[(50)]);
var state_14936__$1 = state_14936;
var statearr_14954_15147 = state_14936__$1;
(statearr_14954_15147[(2)] = inst_14718);

(statearr_14954_15147[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (60))){
var inst_14723 = (state_14936[(27)]);
var inst_14723__$1 = (state_14936[(2)]);
var inst_14724 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14723__$1,fluree.db.util.core.max_long);
var inst_14725 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14727 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14728 = (new cljs.core.PersistentVector(null,3,(5),inst_14726,inst_14727,null));
var inst_14729 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14728);
var inst_14730 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14732 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14733 = (new cljs.core.PersistentVector(null,2,(5),inst_14731,inst_14732,null));
var inst_14734 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14733);
var inst_14735 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_14737 = fluree.db.dbproto._resolve(inst_14736);
var state_14936__$1 = (function (){var statearr_14955 = state_14936;
(statearr_14955[(13)] = inst_14725);

(statearr_14955[(14)] = inst_14730);

(statearr_14955[(15)] = inst_14724);

(statearr_14955[(27)] = inst_14723__$1);

(statearr_14955[(35)] = inst_14734);

(statearr_14955[(38)] = inst_14729);

(statearr_14955[(43)] = inst_14735);

return statearr_14955;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14936__$1,(61),inst_14737);
} else {
if((state_val_14937 === (27))){
var inst_14656 = (state_14936[(51)]);
var state_14936__$1 = state_14936;
var statearr_14956_15148 = state_14936__$1;
(statearr_14956_15148[(2)] = inst_14656);

(statearr_14956_15148[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (1))){
var state_14936__$1 = state_14936;
var statearr_14957_15149 = state_14936__$1;
(statearr_14957_15149[(2)] = null);

(statearr_14957_15149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (69))){
var inst_14714 = (state_14936[(28)]);
var inst_14713 = (state_14936[(30)]);
var inst_14753 = (state_14936[(41)]);
var inst_14762 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14753);
var inst_14763 = fluree.db.flake.subrange(inst_14762,start_test,inst_14713,end_test,inst_14714);
var inst_14765 = fluree.db.query.range.value_with_nil_pred(idx,inst_14713,inst_14714);
var state_14936__$1 = (function (){var statearr_14958 = state_14936;
(statearr_14958[(25)] = inst_14763);

return statearr_14958;
})();
if(inst_14765){
var statearr_14959_15150 = state_14936__$1;
(statearr_14959_15150[(1)] = (71));

} else {
var statearr_14960_15151 = state_14936__$1;
(statearr_14960_15151[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (101))){
var inst_14717 = (state_14936[(23)]);
var inst_14851 = (state_14936[(52)]);
var inst_14850 = (state_14936[(53)]);
var inst_14849 = (state_14936[(54)]);
var inst_14854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14855 = (inst_14851 - inst_14717);
var inst_14856 = (inst_14850 - inst_14855);
var inst_14857 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14856,inst_14849);
var inst_14858 = [inst_14717,inst_14857];
var inst_14859 = (new cljs.core.PersistentVector(null,2,(5),inst_14854,inst_14858,null));
var state_14936__$1 = state_14936;
var statearr_14961_15152 = state_14936__$1;
(statearr_14961_15152[(2)] = inst_14859);

(statearr_14961_15152[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (24))){
var inst_14589 = (state_14936[(55)]);
var inst_14622 = (state_14936[(11)]);
var inst_14596 = (state_14936[(56)]);
var inst_14636 = (state_14936[(57)]);
var inst_14592 = (state_14936[(58)]);
var inst_14588 = (state_14936[(59)]);
var inst_14601 = (state_14936[(12)]);
var inst_14604 = (state_14936[(60)]);
var inst_14595 = (state_14936[(61)]);
var inst_14599 = (state_14936[(62)]);
var inst_14597 = (state_14936[(20)]);
var inst_14603 = (state_14936[(21)]);
var inst_14602 = (state_14936[(22)]);
var inst_14590 = (state_14936[(24)]);
var inst_14593 = (state_14936[(29)]);
var inst_14613 = (state_14936[(40)]);
var inst_14591 = (state_14936[(42)]);
var inst_14598 = (state_14936[(44)]);
var inst_14586 = (state_14936[(45)]);
var inst_14646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14648 = [null,null];
var inst_14649 = (new cljs.core.PersistentVector(null,2,(5),inst_14647,inst_14648,null));
var inst_14650 = (function (){var bool = inst_14636;
var s1 = inst_14613;
var vec__14572 = inst_14586;
var o2 = inst_14596;
var t1 = inst_14590;
var predicate_fn = inst_14603;
var map__14578 = inst_14601;
var m1 = inst_14592;
var s2 = inst_14622;
var vec__14575 = inst_14593;
var p2 = inst_14595;
var t2 = inst_14597;
var op1 = inst_14591;
var o1 = inst_14589;
var p1 = inst_14588;
var subject_fn = inst_14602;
var object_fn = inst_14604;
var op2 = inst_14598;
var m2 = inst_14599;
var temp__5755__auto__ = inst_14636;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_14651 = [inst_14649,inst_14650];
var inst_14652 = (new cljs.core.PersistentVector(null,2,(5),inst_14646,inst_14651,null));
var state_14936__$1 = state_14936;
var statearr_14962_15153 = state_14936__$1;
(statearr_14962_15153[(2)] = inst_14652);

(statearr_14962_15153[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (102))){
var inst_14851 = (state_14936[(52)]);
var inst_14849 = (state_14936[(54)]);
var inst_14861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14862 = [inst_14851,inst_14849];
var inst_14863 = (new cljs.core.PersistentVector(null,2,(5),inst_14861,inst_14862,null));
var state_14936__$1 = state_14936;
var statearr_14963_15154 = state_14936__$1;
(statearr_14963_15154[(2)] = inst_14863);

(statearr_14963_15154[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (55))){
var state_14936__$1 = state_14936;
var statearr_14964_15155 = state_14936__$1;
(statearr_14964_15155[(2)] = (2147483647));

(statearr_14964_15155[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (85))){
var inst_14799 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
if(cljs.core.truth_(inst_14799)){
var statearr_14965_15156 = state_14936__$1;
(statearr_14965_15156[(1)] = (89));

} else {
var statearr_14966_15157 = state_14936__$1;
(statearr_14966_15157[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (39))){
var inst_14595 = (state_14936[(61)]);
var inst_14686 = (state_14936[(63)]);
var inst_14685 = (state_14936[(2)]);
var inst_14686__$1 = (inst_14595 == null);
var state_14936__$1 = (function (){var statearr_14967 = state_14936;
(statearr_14967[(31)] = inst_14685);

(statearr_14967[(63)] = inst_14686__$1);

return statearr_14967;
})();
if(cljs.core.truth_(inst_14686__$1)){
var statearr_14968_15158 = state_14936__$1;
(statearr_14968_15158[(1)] = (40));

} else {
var statearr_14969_15159 = state_14936__$1;
(statearr_14969_15159[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (88))){
var inst_14796 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_14970_15160 = state_14936__$1;
(statearr_14970_15160[(2)] = inst_14796);

(statearr_14970_15160[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (46))){
var inst_14592 = (state_14936[(58)]);
var state_14936__$1 = state_14936;
var statearr_14971_15161 = state_14936__$1;
(statearr_14971_15161[(2)] = inst_14592);

(statearr_14971_15161[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (4))){
var inst_14566 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_14972_15162 = state_14936__$1;
(statearr_14972_15162[(2)] = inst_14566);

(statearr_14972_15162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (77))){
var inst_14622 = (state_14936[(11)]);
var inst_14777 = (state_14936[(64)]);
var inst_14601 = (state_14936[(12)]);
var inst_14725 = (state_14936[(13)]);
var inst_14730 = (state_14936[(14)]);
var inst_14724 = (state_14936[(15)]);
var inst_14740 = (state_14936[(16)]);
var inst_14667 = (state_14936[(17)]);
var inst_14703 = (state_14936[(18)]);
var inst_14658 = (state_14936[(19)]);
var inst_14750 = (state_14936[(9)]);
var inst_14597 = (state_14936[(20)]);
var inst_14603 = (state_14936[(21)]);
var inst_14602 = (state_14936[(22)]);
var inst_14717 = (state_14936[(23)]);
var inst_14590 = (state_14936[(24)]);
var inst_14763 = (state_14936[(25)]);
var inst_14676 = (state_14936[(26)]);
var inst_14723 = (state_14936[(27)]);
var inst_14714 = (state_14936[(28)]);
var inst_14593 = (state_14936[(29)]);
var inst_14713 = (state_14936[(30)]);
var inst_14685 = (state_14936[(31)]);
var inst_14756 = (state_14936[(32)]);
var inst_14654 = (state_14936[(33)]);
var inst_14744 = (state_14936[(8)]);
var inst_14712 = (state_14936[(34)]);
var inst_14734 = (state_14936[(35)]);
var inst_14755 = (state_14936[(36)]);
var inst_14754 = (state_14936[(37)]);
var inst_14729 = (state_14936[(38)]);
var inst_14655 = (state_14936[(39)]);
var inst_14613 = (state_14936[(40)]);
var inst_14753 = (state_14936[(41)]);
var inst_14591 = (state_14936[(42)]);
var inst_14735 = (state_14936[(43)]);
var inst_14598 = (state_14936[(44)]);
var inst_14586 = (state_14936[(45)]);
var inst_14757 = (state_14936[(46)]);
var inst_14694 = (state_14936[(47)]);
var inst_14716 = (state_14936[(48)]);
var inst_14779 = (function (){var no_filter_QMARK_ = inst_14750;
var t = inst_14730;
var max_limit_QMARK_ = inst_14724;
var next_node = inst_14753;
var fast_forward_db_QMARK_ = inst_14735;
var s1 = inst_14613;
var vec__14572 = inst_14586;
var o2 = inst_14676;
var G__14764 = inst_14777;
var t1 = inst_14590;
var predicate_fn = inst_14603;
var i = inst_14755;
var map__14578 = inst_14601;
var m1 = inst_14703;
var root_node = inst_14740;
var s2 = inst_14622;
var vec__14575 = inst_14593;
var vec__14579 = inst_14654;
var p2 = inst_14694;
var permissions = inst_14725;
var limit = inst_14723;
var vec__14582 = inst_14655;
var start_flake = inst_14713;
var flake_limit = inst_14717;
var offset = inst_14754;
var acc = inst_14757;
var t2 = inst_14597;
var op1 = inst_14591;
var o1 = inst_14667;
var end_flake = inst_14714;
var base_result = inst_14763;
var s = inst_14756;
var node_start = inst_14744;
var p1 = inst_14685;
var subject_fn = inst_14602;
var object_fn = inst_14658;
var map__14585 = inst_14716;
var idx_compare = inst_14729;
var op2 = inst_14598;
var m2 = inst_14712;
var novelty = inst_14734;
return (function (p1__14555_SHARP_){
var G__14973 = p1__14555_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__14973) : predicate_fn.call(null,G__14973));
});
})();
var inst_14780 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14779,inst_14777);
var state_14936__$1 = state_14936;
var statearr_14974_15163 = state_14936__$1;
(statearr_14974_15163[(2)] = inst_14780);

(statearr_14974_15163[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (106))){
var inst_14790 = (state_14936[(65)]);
var state_14936__$1 = state_14936;
var statearr_14975_15164 = state_14936__$1;
(statearr_14975_15164[(2)] = inst_14790);

(statearr_14975_15164[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (119))){
var inst_14908 = (state_14936[(66)]);
var state_14936__$1 = state_14936;
var statearr_14976_15165 = state_14936__$1;
(statearr_14976_15165[(2)] = inst_14908);

(statearr_14976_15165[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (95))){
var inst_14823 = (state_14936[(67)]);
var inst_14831 = (state_14936[(68)]);
var inst_14723 = (state_14936[(27)]);
var inst_14756 = (state_14936[(32)]);
var inst_14832 = (state_14936[(69)]);
var inst_14833 = (state_14936[(70)]);
var inst_14831__$1 = cljs.core.count(inst_14823);
var inst_14832__$1 = (inst_14756 + inst_14831__$1);
var inst_14833__$1 = (inst_14832__$1 - inst_14723);
var inst_14834 = cljs.core.pos_int_QMARK_(inst_14833__$1);
var state_14936__$1 = (function (){var statearr_14977 = state_14936;
(statearr_14977[(68)] = inst_14831__$1);

(statearr_14977[(69)] = inst_14832__$1);

(statearr_14977[(70)] = inst_14833__$1);

return statearr_14977;
})();
if(inst_14834){
var statearr_14978_15166 = state_14936__$1;
(statearr_14978_15166[(1)] = (98));

} else {
var statearr_14979_15167 = state_14936__$1;
(statearr_14979_15167[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (54))){
var inst_14622 = (state_14936[(11)]);
var inst_14667 = (state_14936[(17)]);
var inst_14703 = (state_14936[(18)]);
var inst_14597 = (state_14936[(20)]);
var inst_14590 = (state_14936[(24)]);
var inst_14718 = (state_14936[(50)]);
var inst_14676 = (state_14936[(26)]);
var inst_14685 = (state_14936[(31)]);
var inst_14712 = (state_14936[(34)]);
var inst_14613 = (state_14936[(40)]);
var inst_14591 = (state_14936[(42)]);
var inst_14598 = (state_14936[(44)]);
var inst_14694 = (state_14936[(47)]);
var inst_14716 = (state_14936[(48)]);
var inst_14712__$1 = (state_14936[(2)]);
var inst_14713 = fluree.db.flake.__GT_Flake(inst_14613,inst_14685,inst_14667,inst_14590,inst_14591,inst_14703);
var inst_14714 = fluree.db.flake.__GT_Flake(inst_14622,inst_14694,inst_14676,inst_14597,inst_14598,inst_14712__$1);
var inst_14715 = opts;
var inst_14716__$1 = cljs.core.__destructure_map(inst_14715);
var inst_14717 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14716__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_14718__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14716__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_14719 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14716__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14936__$1 = (function (){var statearr_14980 = state_14936;
(statearr_14980[(23)] = inst_14717);

(statearr_14980[(50)] = inst_14718__$1);

(statearr_14980[(28)] = inst_14714);

(statearr_14980[(30)] = inst_14713);

(statearr_14980[(34)] = inst_14712__$1);

(statearr_14980[(71)] = inst_14719);

(statearr_14980[(48)] = inst_14716__$1);

return statearr_14980;
})();
if(cljs.core.truth_(inst_14718__$1)){
var statearr_14981_15168 = state_14936__$1;
(statearr_14981_15168[(1)] = (58));

} else {
var statearr_14982_15169 = state_14936__$1;
(statearr_14982_15169[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (92))){
var inst_14812 = (state_14936[(72)]);
var inst_14756 = (state_14936[(32)]);
var inst_14755 = (state_14936[(36)]);
var inst_14754 = (state_14936[(37)]);
var inst_14757 = (state_14936[(46)]);
var inst_14815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14816 = (inst_14754 - inst_14812);
var inst_14817 = [inst_14816,inst_14755,inst_14756,inst_14757];
var inst_14818 = (new cljs.core.PersistentVector(null,4,(5),inst_14815,inst_14817,null));
var state_14936__$1 = state_14936;
var statearr_14983_15170 = state_14936__$1;
(statearr_14983_15170[(2)] = inst_14818);

(statearr_14983_15170[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (104))){
var inst_14874 = (state_14936[(2)]);
var inst_14875 = fluree.db.util.async.throw_err(inst_14874);
var state_14936__$1 = state_14936;
var statearr_14984_15171 = state_14936__$1;
(statearr_14984_15171[(2)] = inst_14875);

(statearr_14984_15171[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (15))){
var inst_14596 = (state_14936[(56)]);
var inst_14626 = cljs.core.boolean_QMARK_(inst_14596);
var state_14936__$1 = state_14936;
if(inst_14626){
var statearr_14985_15172 = state_14936__$1;
(statearr_14985_15172[(1)] = (17));

} else {
var statearr_14986_15173 = state_14936__$1;
(statearr_14986_15173[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (48))){
var inst_14599 = (state_14936[(62)]);
var inst_14703 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14987 = state_14936;
(statearr_14987[(18)] = inst_14703);

return statearr_14987;
})();
if(cljs.core.truth_(inst_14599)){
var statearr_14988_15174 = state_14936__$1;
(statearr_14988_15174[(1)] = (52));

} else {
var statearr_14989_15175 = state_14936__$1;
(statearr_14989_15175[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (50))){
var state_14936__$1 = state_14936;
var statearr_14990_15176 = state_14936__$1;
(statearr_14990_15176[(2)] = (2147483647));

(statearr_14990_15176[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (116))){
var inst_14908 = (state_14936[(66)]);
var inst_14916 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14991 = state_14936;
(statearr_14991[(73)] = inst_14916);

return statearr_14991;
})();
if(cljs.core.truth_(inst_14908)){
var statearr_14992_15177 = state_14936__$1;
(statearr_14992_15177[(1)] = (118));

} else {
var statearr_14993_15178 = state_14936__$1;
(statearr_14993_15178[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (75))){
var inst_14771 = (state_14936[(10)]);
var state_14936__$1 = state_14936;
var statearr_14994_15179 = state_14936__$1;
(statearr_14994_15179[(2)] = inst_14771);

(statearr_14994_15179[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (99))){
var inst_14832 = (state_14936[(69)]);
var inst_14841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14842 = [inst_14832,inst_14832];
var inst_14843 = (new cljs.core.PersistentVector(null,2,(5),inst_14841,inst_14842,null));
var state_14936__$1 = state_14936;
var statearr_14995_15180 = state_14936__$1;
(statearr_14995_15180[(2)] = inst_14843);

(statearr_14995_15180[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (21))){
var state_14936__$1 = state_14936;
var statearr_14996_15181 = state_14936__$1;
(statearr_14996_15181[(2)] = null);

(statearr_14996_15181[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (31))){
var inst_14657 = (state_14936[(74)]);
var state_14936__$1 = state_14936;
var statearr_14997_15182 = state_14936__$1;
(statearr_14997_15182[(2)] = inst_14657);

(statearr_14997_15182[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (113))){
var inst_14902 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_14998_15183 = state_14936__$1;
(statearr_14998_15183[(2)] = inst_14902);

(statearr_14998_15183[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (32))){
var inst_14588 = (state_14936[(59)]);
var inst_14677 = (state_14936[(75)]);
var inst_14676 = (state_14936[(2)]);
var inst_14677__$1 = (inst_14588 == null);
var state_14936__$1 = (function (){var statearr_14999 = state_14936;
(statearr_14999[(75)] = inst_14677__$1);

(statearr_14999[(26)] = inst_14676);

return statearr_14999;
})();
if(cljs.core.truth_(inst_14677__$1)){
var statearr_15000_15184 = state_14936__$1;
(statearr_15000_15184[(1)] = (34));

} else {
var statearr_15001_15185 = state_14936__$1;
(statearr_15001_15185[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (40))){
var inst_14676 = (state_14936[(26)]);
var state_14936__$1 = state_14936;
var statearr_15002_15186 = state_14936__$1;
(statearr_15002_15186[(2)] = inst_14676);

(statearr_15002_15186[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (91))){
var inst_14790 = (state_14936[(65)]);
var inst_14888 = (state_14936[(2)]);
var inst_14889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14888,(0),null);
var inst_14890 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14888,(1),null);
var inst_14891 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14888,(2),null);
var inst_14892 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14888,(3),null);
var state_14936__$1 = (function (){var statearr_15003 = state_14936;
(statearr_15003[(76)] = inst_14891);

(statearr_15003[(7)] = inst_14892);

(statearr_15003[(77)] = inst_14889);

(statearr_15003[(78)] = inst_14890);

return statearr_15003;
})();
if(cljs.core.truth_(inst_14790)){
var statearr_15004_15187 = state_14936__$1;
(statearr_15004_15187[(1)] = (105));

} else {
var statearr_15005_15188 = state_14936__$1;
(statearr_15005_15188[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (117))){
var inst_14912 = (state_14936[(2)]);
var inst_14913 = fluree.db.util.async.throw_err(inst_14912);
var state_14936__$1 = state_14936;
var statearr_15006_15189 = state_14936__$1;
(statearr_15006_15189[(2)] = inst_14913);

(statearr_15006_15189[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (108))){
var inst_14717 = (state_14936[(23)]);
var inst_14897 = (state_14936[(79)]);
var inst_14890 = (state_14936[(78)]);
var inst_14897__$1 = (inst_14890 < inst_14717);
var state_14936__$1 = (function (){var statearr_15007 = state_14936;
(statearr_15007[(79)] = inst_14897__$1);

return statearr_15007;
})();
if(cljs.core.truth_(inst_14897__$1)){
var statearr_15008_15190 = state_14936__$1;
(statearr_15008_15190[(1)] = (111));

} else {
var statearr_15009_15191 = state_14936__$1;
(statearr_15009_15191[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (56))){
var state_14936__$1 = state_14936;
var statearr_15010_15192 = state_14936__$1;
(statearr_15010_15192[(2)] = fluree.db.util.core.min_integer);

(statearr_15010_15192[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (33))){
var inst_14672 = (state_14936[(2)]);
var inst_14673 = fluree.db.util.async.throw_err(inst_14672);
var state_14936__$1 = state_14936;
var statearr_15011_15193 = state_14936__$1;
(statearr_15011_15193[(2)] = inst_14673);

(statearr_15011_15193[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (13))){
var inst_14618 = (state_14936[(2)]);
var inst_14619 = fluree.db.util.async.throw_err(inst_14618);
var state_14936__$1 = state_14936;
var statearr_15012_15194 = state_14936__$1;
(statearr_15012_15194[(2)] = inst_14619);

(statearr_15012_15194[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (22))){
var inst_14632 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_15013_15195 = state_14936__$1;
(statearr_15013_15195[(2)] = inst_14632);

(statearr_15013_15195[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (90))){
var inst_14622 = (state_14936[(11)]);
var inst_14601 = (state_14936[(12)]);
var inst_14725 = (state_14936[(13)]);
var inst_14730 = (state_14936[(14)]);
var inst_14724 = (state_14936[(15)]);
var inst_14740 = (state_14936[(16)]);
var inst_14667 = (state_14936[(17)]);
var inst_14703 = (state_14936[(18)]);
var inst_14658 = (state_14936[(19)]);
var inst_14750 = (state_14936[(9)]);
var inst_14597 = (state_14936[(20)]);
var inst_14603 = (state_14936[(21)]);
var inst_14789 = (state_14936[(80)]);
var inst_14602 = (state_14936[(22)]);
var inst_14812 = (state_14936[(72)]);
var inst_14717 = (state_14936[(23)]);
var inst_14590 = (state_14936[(24)]);
var inst_14763 = (state_14936[(25)]);
var inst_14676 = (state_14936[(26)]);
var inst_14790 = (state_14936[(65)]);
var inst_14723 = (state_14936[(27)]);
var inst_14714 = (state_14936[(28)]);
var inst_14593 = (state_14936[(29)]);
var inst_14713 = (state_14936[(30)]);
var inst_14685 = (state_14936[(31)]);
var inst_14756 = (state_14936[(32)]);
var inst_14654 = (state_14936[(33)]);
var inst_14744 = (state_14936[(8)]);
var inst_14811 = (state_14936[(81)]);
var inst_14712 = (state_14936[(34)]);
var inst_14734 = (state_14936[(35)]);
var inst_14755 = (state_14936[(36)]);
var inst_14754 = (state_14936[(37)]);
var inst_14729 = (state_14936[(38)]);
var inst_14655 = (state_14936[(39)]);
var inst_14613 = (state_14936[(40)]);
var inst_14753 = (state_14936[(41)]);
var inst_14591 = (state_14936[(42)]);
var inst_14735 = (state_14936[(43)]);
var inst_14598 = (state_14936[(44)]);
var inst_14586 = (state_14936[(45)]);
var inst_14757 = (state_14936[(46)]);
var inst_14694 = (state_14936[(47)]);
var inst_14716 = (state_14936[(48)]);
var inst_14810 = (function (){var no_filter_QMARK_ = inst_14750;
var base_result_SINGLEQUOTE_ = inst_14789;
var t = inst_14730;
var max_limit_QMARK_ = inst_14724;
var next_node = inst_14753;
var fast_forward_db_QMARK_ = inst_14735;
var s1 = inst_14613;
var vec__14572 = inst_14586;
var o2 = inst_14676;
var t1 = inst_14590;
var predicate_fn = inst_14603;
var i = inst_14755;
var rhs = inst_14790;
var map__14578 = inst_14601;
var m1 = inst_14703;
var root_node = inst_14740;
var s2 = inst_14622;
var vec__14575 = inst_14593;
var vec__14579 = inst_14654;
var p2 = inst_14694;
var permissions = inst_14725;
var limit = inst_14723;
var vec__14582 = inst_14655;
var start_flake = inst_14713;
var flake_limit = inst_14717;
var offset = inst_14754;
var acc = inst_14757;
var t2 = inst_14597;
var op1 = inst_14591;
var o1 = inst_14667;
var end_flake = inst_14714;
var base_result = inst_14763;
var s = inst_14756;
var node_start = inst_14744;
var p1 = inst_14685;
var subject_fn = inst_14602;
var object_fn = inst_14658;
var map__14585 = inst_14716;
var idx_compare = inst_14729;
var op2 = inst_14598;
var m2 = inst_14712;
var novelty = inst_14734;
return (function (p1__14557_SHARP_){
return p1__14557_SHARP_.s;
});
})();
var inst_14811__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_14810,inst_14789);
var inst_14812__$1 = cljs.core.count(inst_14811__$1);
var inst_14813 = (inst_14754 > inst_14812__$1);
var state_14936__$1 = (function (){var statearr_15014 = state_14936;
(statearr_15014[(72)] = inst_14812__$1);

(statearr_15014[(81)] = inst_14811__$1);

return statearr_15014;
})();
if(cljs.core.truth_(inst_14813)){
var statearr_15015_15196 = state_14936__$1;
(statearr_15015_15196[(1)] = (92));

} else {
var statearr_15016_15197 = state_14936__$1;
(statearr_15016_15197[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (109))){
var inst_14895 = (state_14936[(82)]);
var state_14936__$1 = state_14936;
var statearr_15017_15198 = state_14936__$1;
(statearr_15017_15198[(2)] = inst_14895);

(statearr_15017_15198[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (36))){
var inst_14681 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
if(cljs.core.truth_(inst_14681)){
var statearr_15018_15199 = state_14936__$1;
(statearr_15018_15199[(1)] = (37));

} else {
var statearr_15019_15200 = state_14936__$1;
(statearr_15019_15200[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (41))){
var inst_14686 = (state_14936[(63)]);
var state_14936__$1 = state_14936;
var statearr_15020_15201 = state_14936__$1;
(statearr_15020_15201[(2)] = inst_14686);

(statearr_15020_15201[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (118))){
var inst_14916 = (state_14936[(73)]);
var state_14936__$1 = state_14936;
var statearr_15021_15202 = state_14936__$1;
(statearr_15021_15202[(2)] = inst_14916);

(statearr_15021_15202[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (89))){
var inst_14789 = (state_14936[(80)]);
var inst_14717 = (state_14936[(23)]);
var inst_14756 = (state_14936[(32)]);
var inst_14755 = (state_14936[(36)]);
var inst_14757 = (state_14936[(46)]);
var inst_14801 = cljs.core.count(inst_14789);
var inst_14802 = (inst_14717 - inst_14755);
var inst_14803 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14802,inst_14789);
var inst_14804 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14757,inst_14803);
var inst_14805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14806 = (inst_14755 + inst_14801);
var inst_14807 = [(0),inst_14806,inst_14756,inst_14804];
var inst_14808 = (new cljs.core.PersistentVector(null,4,(5),inst_14805,inst_14807,null));
var state_14936__$1 = state_14936;
var statearr_15022_15203 = state_14936__$1;
(statearr_15022_15203[(2)] = inst_14808);

(statearr_15022_15203[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (100))){
var inst_14823 = (state_14936[(67)]);
var inst_14717 = (state_14936[(23)]);
var inst_14851 = (state_14936[(52)]);
var inst_14755 = (state_14936[(36)]);
var inst_14850 = (state_14936[(53)]);
var inst_14849 = (state_14936[(54)]);
var inst_14845 = (state_14936[(2)]);
var inst_14846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14845,(0),null);
var inst_14847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14845,(1),null);
var inst_14848 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14847,inst_14823);
var inst_14849__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_14848);
var inst_14850__$1 = cljs.core.count(inst_14849__$1);
var inst_14851__$1 = (inst_14755 + inst_14850__$1);
var inst_14852 = (inst_14851__$1 > inst_14717);
var state_14936__$1 = (function (){var statearr_15023 = state_14936;
(statearr_15023[(83)] = inst_14846);

(statearr_15023[(52)] = inst_14851__$1);

(statearr_15023[(53)] = inst_14850__$1);

(statearr_15023[(54)] = inst_14849__$1);

return statearr_15023;
})();
if(cljs.core.truth_(inst_14852)){
var statearr_15024_15204 = state_14936__$1;
(statearr_15024_15204[(1)] = (101));

} else {
var statearr_15025_15205 = state_14936__$1;
(statearr_15025_15205[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (122))){
var inst_14891 = (state_14936[(76)]);
var inst_14892 = (state_14936[(7)]);
var inst_14889 = (state_14936[(77)]);
var inst_14890 = (state_14936[(78)]);
var inst_14916 = (state_14936[(73)]);
var inst_14753 = inst_14916;
var inst_14754 = inst_14889;
var inst_14755 = inst_14890;
var inst_14756 = inst_14891;
var inst_14757 = inst_14892;
var state_14936__$1 = (function (){var statearr_15026 = state_14936;
(statearr_15026[(32)] = inst_14756);

(statearr_15026[(36)] = inst_14755);

(statearr_15026[(37)] = inst_14754);

(statearr_15026[(41)] = inst_14753);

(statearr_15026[(46)] = inst_14757);

return statearr_15026;
})();
var statearr_15027_15206 = state_14936__$1;
(statearr_15027_15206[(2)] = null);

(statearr_15027_15206[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (43))){
var state_14936__$1 = state_14936;
var statearr_15028_15207 = state_14936__$1;
(statearr_15028_15207[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_15028_15207[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (61))){
var inst_14730 = (state_14936[(14)]);
var inst_14740 = (state_14936[(16)]);
var inst_14713 = (state_14936[(30)]);
var inst_14734 = (state_14936[(35)]);
var inst_14735 = (state_14936[(43)]);
var inst_14739 = (state_14936[(2)]);
var inst_14740__$1 = fluree.db.util.async.throw_err(inst_14739);
var inst_14741 = fluree.db.query.range.find_next_valid_node(inst_14740__$1,inst_14713,inst_14730,inst_14734,inst_14735);
var state_14936__$1 = (function (){var statearr_15029 = state_14936;
(statearr_15029[(16)] = inst_14740__$1);

return statearr_15029;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14936__$1,(62),inst_14741);
} else {
if((state_val_14937 === (29))){
var inst_14663 = (state_14936[(2)]);
var inst_14664 = fluree.db.util.async.throw_err(inst_14663);
var state_14936__$1 = state_14936;
var statearr_15030_15208 = state_14936__$1;
(statearr_15030_15208[(2)] = inst_14664);

(statearr_15030_15208[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (44))){
var inst_14595 = (state_14936[(61)]);
var state_14936__$1 = state_14936;
var statearr_15031_15209 = state_14936__$1;
(statearr_15031_15209[(2)] = inst_14595);

(statearr_15031_15209[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (93))){
var inst_14750 = (state_14936[(9)]);
var inst_14811 = (state_14936[(81)]);
var inst_14754 = (state_14936[(37)]);
var inst_14823 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_14754,inst_14811);
var state_14936__$1 = (function (){var statearr_15032 = state_14936;
(statearr_15032[(67)] = inst_14823);

return statearr_15032;
})();
if(cljs.core.truth_(inst_14750)){
var statearr_15033_15210 = state_14936__$1;
(statearr_15033_15210[(1)] = (95));

} else {
var statearr_15034_15211 = state_14936__$1;
(statearr_15034_15211[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (6))){
var inst_14587 = (state_14936[(49)]);
var inst_14607 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14587);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14936__$1,(9),inst_14607);
} else {
if((state_val_14937 === (111))){
var inst_14891 = (state_14936[(76)]);
var inst_14723 = (state_14936[(27)]);
var inst_14899 = (inst_14891 < inst_14723);
var state_14936__$1 = state_14936;
var statearr_15035_15212 = state_14936__$1;
(statearr_15035_15212[(2)] = inst_14899);

(statearr_15035_15212[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (28))){
var inst_14657 = (state_14936[(74)]);
var inst_14667 = (state_14936[(2)]);
var inst_14668 = fluree.db.util.core.pred_ident_QMARK_(inst_14657);
var state_14936__$1 = (function (){var statearr_15036 = state_14936;
(statearr_15036[(17)] = inst_14667);

return statearr_15036;
})();
if(inst_14668){
var statearr_15037_15213 = state_14936__$1;
(statearr_15037_15213[(1)] = (30));

} else {
var statearr_15038_15214 = state_14936__$1;
(statearr_15038_15214[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (64))){
var state_14936__$1 = state_14936;
var statearr_15039_15215 = state_14936__$1;
(statearr_15039_15215[(2)] = true);

(statearr_15039_15215[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (103))){
var inst_14846 = (state_14936[(83)]);
var inst_14865 = (state_14936[(2)]);
var inst_14866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14865,(0),null);
var inst_14867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14865,(1),null);
var inst_14868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14869 = [inst_14866,inst_14846,inst_14867];
var inst_14870 = (new cljs.core.PersistentVector(null,3,(5),inst_14868,inst_14869,null));
var state_14936__$1 = state_14936;
var statearr_15040_15216 = state_14936__$1;
(statearr_15040_15216[(2)] = inst_14870);

(statearr_15040_15216[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (51))){
var inst_14701 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_15041_15217 = state_14936__$1;
(statearr_15041_15217[(2)] = inst_14701);

(statearr_15041_15217[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (25))){
var inst_14656 = (state_14936[(51)]);
var inst_14654 = (state_14936[(33)]);
var inst_14655 = (state_14936[(39)]);
var inst_14654__$1 = (state_14936[(2)]);
var inst_14655__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14654__$1,(0),null);
var inst_14656__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14655__$1,(0),null);
var inst_14657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14655__$1,(1),null);
var inst_14658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14654__$1,(1),null);
var inst_14659 = fluree.db.util.core.pred_ident_QMARK_(inst_14656__$1);
var state_14936__$1 = (function (){var statearr_15042 = state_14936;
(statearr_15042[(51)] = inst_14656__$1);

(statearr_15042[(19)] = inst_14658);

(statearr_15042[(33)] = inst_14654__$1);

(statearr_15042[(74)] = inst_14657);

(statearr_15042[(39)] = inst_14655__$1);

return statearr_15042;
})();
if(inst_14659){
var statearr_15043_15218 = state_14936__$1;
(statearr_15043_15218[(1)] = (26));

} else {
var statearr_15044_15219 = state_14936__$1;
(statearr_15044_15219[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (34))){
var inst_14667 = (state_14936[(17)]);
var state_14936__$1 = state_14936;
var statearr_15045_15220 = state_14936__$1;
(statearr_15045_15220[(2)] = inst_14667);

(statearr_15045_15220[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (17))){
var inst_14596 = (state_14936[(56)]);
var state_14936__$1 = state_14936;
var statearr_15046_15221 = state_14936__$1;
(statearr_15046_15221[(2)] = inst_14596);

(statearr_15046_15221[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (3))){
var inst_14934 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14936__$1,inst_14934);
} else {
if((state_val_14937 === (12))){
var inst_14589 = (state_14936[(55)]);
var inst_14622 = (state_14936[(2)]);
var inst_14623 = cljs.core.boolean_QMARK_(inst_14589);
var state_14936__$1 = (function (){var statearr_15047 = state_14936;
(statearr_15047[(11)] = inst_14622);

return statearr_15047;
})();
if(inst_14623){
var statearr_15048_15222 = state_14936__$1;
(statearr_15048_15222[(1)] = (14));

} else {
var statearr_15049_15223 = state_14936__$1;
(statearr_15049_15223[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (2))){
var inst_14601 = (state_14936[(12)]);
var inst_14587 = (state_14936[(49)]);
var inst_14593 = (state_14936[(29)]);
var inst_14586 = (state_14936[(45)]);
var _ = (function (){var statearr_15050 = state_14936;
(statearr_15050[(4)] = cljs.core.cons((5),(state_14936[(4)])));

return statearr_15050;
})();
var inst_14586__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_14587__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14586__$1,(0),null);
var inst_14588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14586__$1,(1),null);
var inst_14589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14586__$1,(2),null);
var inst_14590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14586__$1,(3),null);
var inst_14591 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14586__$1,(4),null);
var inst_14592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14586__$1,(5),null);
var inst_14593__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_14594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14593__$1,(0),null);
var inst_14595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14593__$1,(1),null);
var inst_14596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14593__$1,(2),null);
var inst_14597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14593__$1,(3),null);
var inst_14598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14593__$1,(4),null);
var inst_14599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14593__$1,(5),null);
var inst_14600 = opts;
var inst_14601__$1 = cljs.core.__destructure_map(inst_14600);
var inst_14602 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14601__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_14603 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14601__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_14604 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14601__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_14605 = fluree.db.util.core.pred_ident_QMARK_(inst_14587__$1);
var state_14936__$1 = (function (){var statearr_15051 = state_14936;
(statearr_15051[(55)] = inst_14589);

(statearr_15051[(56)] = inst_14596);

(statearr_15051[(58)] = inst_14592);

(statearr_15051[(59)] = inst_14588);

(statearr_15051[(12)] = inst_14601__$1);

(statearr_15051[(60)] = inst_14604);

(statearr_15051[(49)] = inst_14587__$1);

(statearr_15051[(61)] = inst_14595);

(statearr_15051[(62)] = inst_14599);

(statearr_15051[(20)] = inst_14597);

(statearr_15051[(21)] = inst_14603);

(statearr_15051[(22)] = inst_14602);

(statearr_15051[(24)] = inst_14590);

(statearr_15051[(84)] = inst_14594);

(statearr_15051[(29)] = inst_14593__$1);

(statearr_15051[(42)] = inst_14591);

(statearr_15051[(44)] = inst_14598);

(statearr_15051[(45)] = inst_14586__$1);

return statearr_15051;
})();
if(inst_14605){
var statearr_15052_15224 = state_14936__$1;
(statearr_15052_15224[(1)] = (6));

} else {
var statearr_15053_15225 = state_14936__$1;
(statearr_15053_15225[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (66))){
var inst_14744 = (state_14936[(8)]);
var inst_14719 = (state_14936[(71)]);
var inst_14752 = cljs.core.PersistentVector.EMPTY;
var inst_14753 = inst_14744;
var inst_14754 = inst_14719;
var inst_14755 = (0);
var inst_14756 = (0);
var inst_14757 = inst_14752;
var state_14936__$1 = (function (){var statearr_15054 = state_14936;
(statearr_15054[(32)] = inst_14756);

(statearr_15054[(36)] = inst_14755);

(statearr_15054[(37)] = inst_14754);

(statearr_15054[(41)] = inst_14753);

(statearr_15054[(46)] = inst_14757);

return statearr_15054;
})();
var statearr_15055_15226 = state_14936__$1;
(statearr_15055_15226[(2)] = null);

(statearr_15055_15226[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (107))){
var inst_14908 = (state_14936[(66)]);
var inst_14908__$1 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_15056 = state_14936;
(statearr_15056[(66)] = inst_14908__$1);

return statearr_15056;
})();
if(cljs.core.truth_(inst_14908__$1)){
var statearr_15057_15227 = state_14936__$1;
(statearr_15057_15227[(1)] = (114));

} else {
var statearr_15058_15228 = state_14936__$1;
(statearr_15058_15228[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (23))){
var inst_14589 = (state_14936[(55)]);
var inst_14596 = (state_14936[(56)]);
var inst_14604 = (state_14936[(60)]);
var inst_14639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14641 = [inst_14589,inst_14596];
var inst_14642 = (new cljs.core.PersistentVector(null,2,(5),inst_14640,inst_14641,null));
var inst_14643 = [inst_14642,inst_14604];
var inst_14644 = (new cljs.core.PersistentVector(null,2,(5),inst_14639,inst_14643,null));
var state_14936__$1 = state_14936;
var statearr_15059_15229 = state_14936__$1;
(statearr_15059_15229[(2)] = inst_14644);

(statearr_15059_15229[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (47))){
var inst_14697 = (cljs.core._GT__EQ_ === start_test);
var state_14936__$1 = state_14936;
if(cljs.core.truth_(inst_14697)){
var statearr_15060_15230 = state_14936__$1;
(statearr_15060_15230[(1)] = (49));

} else {
var statearr_15061_15231 = state_14936__$1;
(statearr_15061_15231[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (35))){
var inst_14677 = (state_14936[(75)]);
var state_14936__$1 = state_14936;
var statearr_15062_15232 = state_14936__$1;
(statearr_15062_15232[(2)] = inst_14677);

(statearr_15062_15232[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (82))){
var inst_14724 = (state_14936[(15)]);
var inst_14753 = (state_14936[(41)]);
var inst_14789 = (state_14936[(2)]);
var inst_14790 = fluree.db.dbproto._rhs(inst_14753);
var state_14936__$1 = (function (){var statearr_15063 = state_14936;
(statearr_15063[(80)] = inst_14789);

(statearr_15063[(65)] = inst_14790);

return statearr_15063;
})();
if(cljs.core.truth_(inst_14724)){
var statearr_15064_15233 = state_14936__$1;
(statearr_15064_15233[(1)] = (83));

} else {
var statearr_15065_15234 = state_14936__$1;
(statearr_15065_15234[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (76))){
var inst_14603 = (state_14936[(21)]);
var inst_14777 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_15066 = state_14936;
(statearr_15066[(64)] = inst_14777);

return statearr_15066;
})();
if(cljs.core.truth_(inst_14603)){
var statearr_15067_15235 = state_14936__$1;
(statearr_15067_15235[(1)] = (77));

} else {
var statearr_15068_15236 = state_14936__$1;
(statearr_15068_15236[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (97))){
var inst_14757 = (state_14936[(46)]);
var inst_14877 = (state_14936[(2)]);
var inst_14878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14877,(0),null);
var inst_14879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14877,(1),null);
var inst_14880 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14877,(2),null);
var inst_14881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14882 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14757,inst_14880);
var inst_14883 = [(0),inst_14878,inst_14879,inst_14882];
var inst_14884 = (new cljs.core.PersistentVector(null,4,(5),inst_14881,inst_14883,null));
var state_14936__$1 = state_14936;
var statearr_15069_15237 = state_14936__$1;
(statearr_15069_15237[(2)] = inst_14884);

(statearr_15069_15237[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (19))){
var inst_14634 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_15070_15238 = state_14936__$1;
(statearr_15070_15238[(2)] = inst_14634);

(statearr_15070_15238[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (57))){
var inst_14710 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_15071_15239 = state_14936__$1;
(statearr_15071_15239[(2)] = inst_14710);

(statearr_15071_15239[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (68))){
var inst_14931 = (state_14936[(2)]);
var _ = (function (){var statearr_15072 = state_14936;
(statearr_15072[(4)] = cljs.core.rest((state_14936[(4)])));

return statearr_15072;
})();
var state_14936__$1 = state_14936;
var statearr_15073_15240 = state_14936__$1;
(statearr_15073_15240[(2)] = inst_14931);

(statearr_15073_15240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (11))){
var inst_14594 = (state_14936[(84)]);
var state_14936__$1 = state_14936;
var statearr_15074_15241 = state_14936__$1;
(statearr_15074_15241[(2)] = inst_14594);

(statearr_15074_15241[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (115))){
var state_14936__$1 = state_14936;
var statearr_15076_15242 = state_14936__$1;
(statearr_15076_15242[(2)] = null);

(statearr_15076_15242[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (9))){
var inst_14609 = (state_14936[(2)]);
var inst_14610 = fluree.db.util.async.throw_err(inst_14609);
var state_14936__$1 = state_14936;
var statearr_15077_15243 = state_14936__$1;
(statearr_15077_15243[(2)] = inst_14610);

(statearr_15077_15243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (5))){
var _ = (function (){var statearr_15078 = state_14936;
(statearr_15078[(4)] = cljs.core.rest((state_14936[(4)])));

return statearr_15078;
})();
var state_14936__$1 = state_14936;
var ex15075 = (state_14936__$1[(2)]);
var statearr_15079_15244 = state_14936__$1;
(statearr_15079_15244[(5)] = ex15075);


if((ex15075 instanceof Error)){
var statearr_15080_15245 = state_14936__$1;
(statearr_15080_15245[(1)] = (4));

(statearr_15080_15245[(5)] = null);

} else {
throw ex15075;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (112))){
var inst_14897 = (state_14936[(79)]);
var state_14936__$1 = state_14936;
var statearr_15081_15246 = state_14936__$1;
(statearr_15081_15246[(2)] = inst_14897);

(statearr_15081_15246[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (83))){
var inst_14792 = (state_14936[(85)]);
var inst_14754 = (state_14936[(37)]);
var inst_14792__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14754);
var state_14936__$1 = (function (){var statearr_15082 = state_14936;
(statearr_15082[(85)] = inst_14792__$1);

return statearr_15082;
})();
if(inst_14792__$1){
var statearr_15083_15247 = state_14936__$1;
(statearr_15083_15247[(1)] = (86));

} else {
var statearr_15084_15248 = state_14936__$1;
(statearr_15084_15248[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (14))){
var inst_14589 = (state_14936[(55)]);
var state_14936__$1 = state_14936;
var statearr_15085_15249 = state_14936__$1;
(statearr_15085_15249[(2)] = inst_14589);

(statearr_15085_15249[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (45))){
var inst_14592 = (state_14936[(58)]);
var inst_14694 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_15086 = state_14936;
(statearr_15086[(47)] = inst_14694);

return statearr_15086;
})();
if(cljs.core.truth_(inst_14592)){
var statearr_15087_15250 = state_14936__$1;
(statearr_15087_15250[(1)] = (46));

} else {
var statearr_15088_15251 = state_14936__$1;
(statearr_15088_15251[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (53))){
var inst_14706 = (cljs.core._LT__EQ_ === end_test);
var state_14936__$1 = state_14936;
if(cljs.core.truth_(inst_14706)){
var statearr_15089_15252 = state_14936__$1;
(statearr_15089_15252[(1)] = (55));

} else {
var statearr_15090_15253 = state_14936__$1;
(statearr_15090_15253[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (78))){
var inst_14777 = (state_14936[(64)]);
var state_14936__$1 = state_14936;
var statearr_15091_15254 = state_14936__$1;
(statearr_15091_15254[(2)] = inst_14777);

(statearr_15091_15254[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (26))){
var inst_14656 = (state_14936[(51)]);
var inst_14661 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14656);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14936__$1,(29),inst_14661);
} else {
if((state_val_14937 === (123))){
var inst_14926 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_15092_15255 = state_14936__$1;
(statearr_15092_15255[(2)] = inst_14926);

(statearr_15092_15255[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (16))){
var inst_14636 = (state_14936[(57)]);
var inst_14636__$1 = (state_14936[(2)]);
var inst_14637 = (inst_14636__$1 == null);
var state_14936__$1 = (function (){var statearr_15093 = state_14936;
(statearr_15093[(57)] = inst_14636__$1);

return statearr_15093;
})();
if(cljs.core.truth_(inst_14637)){
var statearr_15094_15256 = state_14936__$1;
(statearr_15094_15256[(1)] = (23));

} else {
var statearr_15095_15257 = state_14936__$1;
(statearr_15095_15257[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (81))){
var inst_14783 = (state_14936[(86)]);
var state_14936__$1 = state_14936;
var statearr_15096_15258 = state_14936__$1;
(statearr_15096_15258[(2)] = inst_14783);

(statearr_15096_15258[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (120))){
var inst_14920 = (state_14936[(2)]);
var inst_14921 = cljs.core.not(inst_14920);
var state_14936__$1 = state_14936;
if(inst_14921){
var statearr_15097_15259 = state_14936__$1;
(statearr_15097_15259[(1)] = (121));

} else {
var statearr_15098_15260 = state_14936__$1;
(statearr_15098_15260[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (79))){
var inst_14658 = (state_14936[(19)]);
var inst_14783 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_15099 = state_14936;
(statearr_15099[(86)] = inst_14783);

return statearr_15099;
})();
if(cljs.core.truth_(inst_14658)){
var statearr_15100_15261 = state_14936__$1;
(statearr_15100_15261[(1)] = (80));

} else {
var statearr_15101_15262 = state_14936__$1;
(statearr_15101_15262[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (38))){
var inst_14588 = (state_14936[(59)]);
var state_14936__$1 = state_14936;
var statearr_15102_15263 = state_14936__$1;
(statearr_15102_15263[(2)] = inst_14588);

(statearr_15102_15263[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (98))){
var inst_14831 = (state_14936[(68)]);
var inst_14723 = (state_14936[(27)]);
var inst_14833 = (state_14936[(70)]);
var inst_14836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14837 = (inst_14831 - inst_14833);
var inst_14838 = [inst_14723,inst_14837];
var inst_14839 = (new cljs.core.PersistentVector(null,2,(5),inst_14836,inst_14838,null));
var state_14936__$1 = state_14936;
var statearr_15103_15264 = state_14936__$1;
(statearr_15103_15264[(2)] = inst_14839);

(statearr_15103_15264[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (87))){
var inst_14792 = (state_14936[(85)]);
var state_14936__$1 = state_14936;
var statearr_15104_15265 = state_14936__$1;
(statearr_15104_15265[(2)] = inst_14792);

(statearr_15104_15265[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (30))){
var inst_14657 = (state_14936[(74)]);
var inst_14670 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14657);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14936__$1,(33),inst_14670);
} else {
if((state_val_14937 === (73))){
var inst_14602 = (state_14936[(22)]);
var inst_14771 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_15105 = state_14936;
(statearr_15105[(10)] = inst_14771);

return statearr_15105;
})();
if(cljs.core.truth_(inst_14602)){
var statearr_15106_15266 = state_14936__$1;
(statearr_15106_15266[(1)] = (74));

} else {
var statearr_15107_15267 = state_14936__$1;
(statearr_15107_15267[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (96))){
var inst_14823 = (state_14936[(67)]);
var inst_14717 = (state_14936[(23)]);
var inst_14723 = (state_14936[(27)]);
var inst_14756 = (state_14936[(32)]);
var inst_14755 = (state_14936[(36)]);
var inst_14872 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_14823,inst_14755,inst_14756,inst_14717,inst_14723);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14936__$1,(104),inst_14872);
} else {
if((state_val_14937 === (10))){
var inst_14594 = (state_14936[(84)]);
var inst_14616 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14594);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14936__$1,(13),inst_14616);
} else {
if((state_val_14937 === (18))){
var state_14936__$1 = state_14936;
var statearr_15108_15268 = state_14936__$1;
(statearr_15108_15268[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (105))){
var inst_14895 = (state_14936[(82)]);
var inst_14790 = (state_14936[(65)]);
var inst_14714 = (state_14936[(28)]);
var inst_14729 = (state_14936[(38)]);
var inst_14894 = (inst_14729.cljs$core$IFn$_invoke$arity$2 ? inst_14729.cljs$core$IFn$_invoke$arity$2(inst_14790,inst_14714) : inst_14729.call(null,inst_14790,inst_14714));
var inst_14895__$1 = (inst_14894 < (0));
var state_14936__$1 = (function (){var statearr_15110 = state_14936;
(statearr_15110[(82)] = inst_14895__$1);

return statearr_15110;
})();
if(cljs.core.truth_(inst_14895__$1)){
var statearr_15111_15269 = state_14936__$1;
(statearr_15111_15269[(1)] = (108));

} else {
var statearr_15112_15270 = state_14936__$1;
(statearr_15112_15270[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (52))){
var inst_14599 = (state_14936[(62)]);
var state_14936__$1 = state_14936;
var statearr_15113_15271 = state_14936__$1;
(statearr_15113_15271[(2)] = inst_14599);

(statearr_15113_15271[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (114))){
var inst_14730 = (state_14936[(14)]);
var inst_14740 = (state_14936[(16)]);
var inst_14790 = (state_14936[(65)]);
var inst_14734 = (state_14936[(35)]);
var inst_14735 = (state_14936[(43)]);
var inst_14910 = fluree.db.query.range.find_next_valid_node(inst_14740,inst_14790,inst_14730,inst_14734,inst_14735);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14936__$1,(117),inst_14910);
} else {
if((state_val_14937 === (67))){
var state_14936__$1 = state_14936;
var statearr_15114_15272 = state_14936__$1;
(statearr_15114_15272[(2)] = null);

(statearr_15114_15272[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (71))){
var inst_14622 = (state_14936[(11)]);
var inst_14601 = (state_14936[(12)]);
var inst_14725 = (state_14936[(13)]);
var inst_14730 = (state_14936[(14)]);
var inst_14724 = (state_14936[(15)]);
var inst_14740 = (state_14936[(16)]);
var inst_14667 = (state_14936[(17)]);
var inst_14703 = (state_14936[(18)]);
var inst_14658 = (state_14936[(19)]);
var inst_14750 = (state_14936[(9)]);
var inst_14597 = (state_14936[(20)]);
var inst_14603 = (state_14936[(21)]);
var inst_14602 = (state_14936[(22)]);
var inst_14717 = (state_14936[(23)]);
var inst_14590 = (state_14936[(24)]);
var inst_14763 = (state_14936[(25)]);
var inst_14676 = (state_14936[(26)]);
var inst_14723 = (state_14936[(27)]);
var inst_14714 = (state_14936[(28)]);
var inst_14593 = (state_14936[(29)]);
var inst_14713 = (state_14936[(30)]);
var inst_14685 = (state_14936[(31)]);
var inst_14756 = (state_14936[(32)]);
var inst_14654 = (state_14936[(33)]);
var inst_14744 = (state_14936[(8)]);
var inst_14712 = (state_14936[(34)]);
var inst_14734 = (state_14936[(35)]);
var inst_14755 = (state_14936[(36)]);
var inst_14754 = (state_14936[(37)]);
var inst_14729 = (state_14936[(38)]);
var inst_14655 = (state_14936[(39)]);
var inst_14613 = (state_14936[(40)]);
var inst_14753 = (state_14936[(41)]);
var inst_14591 = (state_14936[(42)]);
var inst_14735 = (state_14936[(43)]);
var inst_14598 = (state_14936[(44)]);
var inst_14586 = (state_14936[(45)]);
var inst_14757 = (state_14936[(46)]);
var inst_14694 = (state_14936[(47)]);
var inst_14716 = (state_14936[(48)]);
var inst_14767 = (function (){var no_filter_QMARK_ = inst_14750;
var t = inst_14730;
var max_limit_QMARK_ = inst_14724;
var next_node = inst_14753;
var fast_forward_db_QMARK_ = inst_14735;
var s1 = inst_14613;
var vec__14572 = inst_14586;
var o2 = inst_14676;
var G__14764 = inst_14763;
var t1 = inst_14590;
var predicate_fn = inst_14603;
var i = inst_14755;
var map__14578 = inst_14601;
var m1 = inst_14703;
var root_node = inst_14740;
var s2 = inst_14622;
var vec__14575 = inst_14593;
var vec__14579 = inst_14654;
var p2 = inst_14694;
var permissions = inst_14725;
var limit = inst_14723;
var vec__14582 = inst_14655;
var start_flake = inst_14713;
var flake_limit = inst_14717;
var offset = inst_14754;
var acc = inst_14757;
var t2 = inst_14597;
var op1 = inst_14591;
var o1 = inst_14667;
var end_flake = inst_14714;
var base_result = inst_14763;
var s = inst_14756;
var node_start = inst_14744;
var p1 = inst_14685;
var subject_fn = inst_14602;
var object_fn = inst_14658;
var map__14585 = inst_14716;
var idx_compare = inst_14729;
var op2 = inst_14598;
var m2 = inst_14712;
var novelty = inst_14734;
return (function (p1__14553_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__14553_SHARP_.o,start_flake.o);
});
})();
var inst_14768 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14767,inst_14763);
var state_14936__$1 = state_14936;
var statearr_15115_15273 = state_14936__$1;
(statearr_15115_15273[(2)] = inst_14768);

(statearr_15115_15273[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (42))){
var inst_14690 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
if(cljs.core.truth_(inst_14690)){
var statearr_15116_15274 = state_14936__$1;
(statearr_15116_15274[(1)] = (43));

} else {
var statearr_15117_15275 = state_14936__$1;
(statearr_15117_15275[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (80))){
var inst_14622 = (state_14936[(11)]);
var inst_14783 = (state_14936[(86)]);
var inst_14601 = (state_14936[(12)]);
var inst_14725 = (state_14936[(13)]);
var inst_14730 = (state_14936[(14)]);
var inst_14724 = (state_14936[(15)]);
var inst_14740 = (state_14936[(16)]);
var inst_14667 = (state_14936[(17)]);
var inst_14703 = (state_14936[(18)]);
var inst_14658 = (state_14936[(19)]);
var inst_14750 = (state_14936[(9)]);
var inst_14597 = (state_14936[(20)]);
var inst_14603 = (state_14936[(21)]);
var inst_14602 = (state_14936[(22)]);
var inst_14717 = (state_14936[(23)]);
var inst_14590 = (state_14936[(24)]);
var inst_14763 = (state_14936[(25)]);
var inst_14676 = (state_14936[(26)]);
var inst_14723 = (state_14936[(27)]);
var inst_14714 = (state_14936[(28)]);
var inst_14593 = (state_14936[(29)]);
var inst_14713 = (state_14936[(30)]);
var inst_14685 = (state_14936[(31)]);
var inst_14756 = (state_14936[(32)]);
var inst_14654 = (state_14936[(33)]);
var inst_14744 = (state_14936[(8)]);
var inst_14712 = (state_14936[(34)]);
var inst_14734 = (state_14936[(35)]);
var inst_14755 = (state_14936[(36)]);
var inst_14754 = (state_14936[(37)]);
var inst_14729 = (state_14936[(38)]);
var inst_14655 = (state_14936[(39)]);
var inst_14613 = (state_14936[(40)]);
var inst_14753 = (state_14936[(41)]);
var inst_14591 = (state_14936[(42)]);
var inst_14735 = (state_14936[(43)]);
var inst_14598 = (state_14936[(44)]);
var inst_14586 = (state_14936[(45)]);
var inst_14757 = (state_14936[(46)]);
var inst_14694 = (state_14936[(47)]);
var inst_14716 = (state_14936[(48)]);
var inst_14785 = (function (){var no_filter_QMARK_ = inst_14750;
var t = inst_14730;
var max_limit_QMARK_ = inst_14724;
var next_node = inst_14753;
var fast_forward_db_QMARK_ = inst_14735;
var s1 = inst_14613;
var vec__14572 = inst_14586;
var o2 = inst_14676;
var G__14764 = inst_14783;
var t1 = inst_14590;
var predicate_fn = inst_14603;
var i = inst_14755;
var map__14578 = inst_14601;
var m1 = inst_14703;
var root_node = inst_14740;
var s2 = inst_14622;
var vec__14575 = inst_14593;
var vec__14579 = inst_14654;
var p2 = inst_14694;
var permissions = inst_14725;
var limit = inst_14723;
var vec__14582 = inst_14655;
var start_flake = inst_14713;
var flake_limit = inst_14717;
var offset = inst_14754;
var acc = inst_14757;
var t2 = inst_14597;
var op1 = inst_14591;
var o1 = inst_14667;
var end_flake = inst_14714;
var base_result = inst_14763;
var s = inst_14756;
var node_start = inst_14744;
var p1 = inst_14685;
var subject_fn = inst_14602;
var object_fn = inst_14658;
var map__14585 = inst_14716;
var idx_compare = inst_14729;
var op2 = inst_14598;
var m2 = inst_14712;
var novelty = inst_14734;
return (function (p1__14556_SHARP_){
var G__15118 = p1__14556_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__15118) : object_fn.call(null,G__15118));
});
})();
var inst_14786 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14785,inst_14783);
var state_14936__$1 = state_14936;
var statearr_15119_15276 = state_14936__$1;
(statearr_15119_15276[(2)] = inst_14786);

(statearr_15119_15276[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (37))){
var state_14936__$1 = state_14936;
var statearr_15120_15277 = state_14936__$1;
(statearr_15120_15277[(2)] = (-1));

(statearr_15120_15277[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (63))){
var inst_14622 = (state_14936[(11)]);
var inst_14725 = (state_14936[(13)]);
var inst_14685 = (state_14936[(31)]);
var inst_14613 = (state_14936[(40)]);
var inst_14694 = (state_14936[(47)]);
var inst_14747 = fluree.db.permissions_validate.no_filter_QMARK_(inst_14725,inst_14613,inst_14622,inst_14685,inst_14694);
var state_14936__$1 = state_14936;
var statearr_15121_15278 = state_14936__$1;
(statearr_15121_15278[(2)] = inst_14747);

(statearr_15121_15278[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (94))){
var inst_14886 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_15122_15279 = state_14936__$1;
(statearr_15122_15279[(2)] = inst_14886);

(statearr_15122_15279[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (8))){
var inst_14594 = (state_14936[(84)]);
var inst_14613 = (state_14936[(2)]);
var inst_14614 = fluree.db.util.core.pred_ident_QMARK_(inst_14594);
var state_14936__$1 = (function (){var statearr_15123 = state_14936;
(statearr_15123[(40)] = inst_14613);

return statearr_15123;
})();
if(inst_14614){
var statearr_15124_15280 = state_14936__$1;
(statearr_15124_15280[(1)] = (10));

} else {
var statearr_15125_15281 = state_14936__$1;
(statearr_15125_15281[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (49))){
var state_14936__$1 = state_14936;
var statearr_15126_15282 = state_14936__$1;
(statearr_15126_15282[(2)] = fluree.db.util.core.min_integer);

(statearr_15126_15282[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (84))){
var inst_14724 = (state_14936[(15)]);
var state_14936__$1 = state_14936;
var statearr_15127_15283 = state_14936__$1;
(statearr_15127_15283[(2)] = inst_14724);

(statearr_15127_15283[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15128 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15128[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15128[(1)] = (1));

return statearr_15128;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14936){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14936);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15129){var ex__2730__auto__ = e15129;
var statearr_15130_15284 = state_14936;
(statearr_15130_15284[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14936[(4)]))){
var statearr_15131_15285 = state_14936;
(statearr_15131_15285[(1)] = cljs.core.first((state_14936[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15286 = state_14936;
state_14936 = G__15286;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14936){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15132 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15132[(6)] = c__2749__auto__);

return statearr_15132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15342){
var state_val_15343 = (state_15342[(1)]);
if((state_val_15343 === (7))){
var inst_15316 = (state_15342[(7)]);
var inst_15306 = (state_15342[(8)]);
var inst_15314 = fluree.db.flake.Flake__GT_parts(inst_15306);
var inst_15315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15314,(0),null);
var inst_15316__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15314,(1),null);
var inst_15317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15314,(2),null);
var inst_15318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15314,(3),null);
var inst_15319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15314,(4),null);
var inst_15320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15314,(5),null);
var inst_15321 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_15317,inst_15316__$1);
var state_15342__$1 = (function (){var statearr_15344 = state_15342;
(statearr_15344[(9)] = inst_15315);

(statearr_15344[(10)] = inst_15319);

(statearr_15344[(11)] = inst_15318);

(statearr_15344[(12)] = inst_15320);

(statearr_15344[(7)] = inst_15316__$1);

return statearr_15344;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15342__$1,(10),inst_15321);
} else {
if((state_val_15343 === (1))){
var inst_15294 = flakes;
var inst_15295 = cljs.core.seq(inst_15294);
var inst_15296 = cljs.core.first(inst_15295);
var inst_15297 = cljs.core.next(inst_15295);
var inst_15298 = cljs.core.PersistentVector.EMPTY;
var inst_15299 = inst_15294;
var inst_15300 = inst_15298;
var state_15342__$1 = (function (){var statearr_15345 = state_15342;
(statearr_15345[(13)] = inst_15299);

(statearr_15345[(14)] = inst_15297);

(statearr_15345[(15)] = inst_15300);

(statearr_15345[(16)] = inst_15296);

return statearr_15345;
})();
var statearr_15346_15364 = state_15342__$1;
(statearr_15346_15364[(2)] = null);

(statearr_15346_15364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15343 === (4))){
var inst_15306 = (state_15342[(8)]);
var inst_15309 = fluree.db.query.range.is_tag_flake_QMARK_(inst_15306);
var state_15342__$1 = state_15342;
if(inst_15309){
var statearr_15347_15365 = state_15342__$1;
(statearr_15347_15365[(1)] = (7));

} else {
var statearr_15348_15366 = state_15342__$1;
(statearr_15348_15366[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15343 === (6))){
var inst_15338 = (state_15342[(2)]);
var state_15342__$1 = state_15342;
var statearr_15349_15367 = state_15342__$1;
(statearr_15349_15367[(2)] = inst_15338);

(statearr_15349_15367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15343 === (3))){
var inst_15340 = (state_15342[(2)]);
var state_15342__$1 = state_15342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15342__$1,inst_15340);
} else {
if((state_val_15343 === (2))){
var inst_15299 = (state_15342[(13)]);
var inst_15306 = (state_15342[(8)]);
var inst_15305 = cljs.core.seq(inst_15299);
var inst_15306__$1 = cljs.core.first(inst_15305);
var inst_15307 = cljs.core.next(inst_15305);
var state_15342__$1 = (function (){var statearr_15350 = state_15342;
(statearr_15350[(17)] = inst_15307);

(statearr_15350[(8)] = inst_15306__$1);

return statearr_15350;
})();
if(cljs.core.truth_(inst_15306__$1)){
var statearr_15351_15368 = state_15342__$1;
(statearr_15351_15368[(1)] = (4));

} else {
var statearr_15352_15369 = state_15342__$1;
(statearr_15352_15369[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15343 === (9))){
var inst_15335 = (state_15342[(2)]);
var state_15342__$1 = state_15342;
var statearr_15353_15370 = state_15342__$1;
(statearr_15353_15370[(2)] = inst_15335);

(statearr_15353_15370[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15343 === (5))){
var inst_15300 = (state_15342[(15)]);
var state_15342__$1 = state_15342;
var statearr_15354_15371 = state_15342__$1;
(statearr_15354_15371[(2)] = inst_15300);

(statearr_15354_15371[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15343 === (10))){
var inst_15307 = (state_15342[(17)]);
var inst_15315 = (state_15342[(9)]);
var inst_15319 = (state_15342[(10)]);
var inst_15318 = (state_15342[(11)]);
var inst_15320 = (state_15342[(12)]);
var inst_15316 = (state_15342[(7)]);
var inst_15300 = (state_15342[(15)]);
var inst_15323 = (state_15342[(2)]);
var inst_15324 = fluree.db.util.async.throw_err(inst_15323);
var inst_15325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15326 = [inst_15315,inst_15316,inst_15324,inst_15318,inst_15319,inst_15320];
var inst_15327 = (new cljs.core.PersistentVector(null,6,(5),inst_15325,inst_15326,null));
var inst_15328 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_15327);
var inst_15329 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15300,inst_15328);
var inst_15299 = inst_15307;
var inst_15300__$1 = inst_15329;
var state_15342__$1 = (function (){var statearr_15355 = state_15342;
(statearr_15355[(13)] = inst_15299);

(statearr_15355[(15)] = inst_15300__$1);

return statearr_15355;
})();
var statearr_15356_15372 = state_15342__$1;
(statearr_15356_15372[(2)] = null);

(statearr_15356_15372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15343 === (8))){
var inst_15307 = (state_15342[(17)]);
var inst_15300 = (state_15342[(15)]);
var inst_15306 = (state_15342[(8)]);
var inst_15332 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15300,inst_15306);
var inst_15299 = inst_15307;
var inst_15300__$1 = inst_15332;
var state_15342__$1 = (function (){var statearr_15357 = state_15342;
(statearr_15357[(13)] = inst_15299);

(statearr_15357[(15)] = inst_15300__$1);

return statearr_15357;
})();
var statearr_15358_15373 = state_15342__$1;
(statearr_15358_15373[(2)] = null);

(statearr_15358_15373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_15359 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15359[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__);

(statearr_15359[(1)] = (1));

return statearr_15359;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1 = (function (state_15342){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15342);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15360){var ex__2730__auto__ = e15360;
var statearr_15361_15374 = state_15342;
(statearr_15361_15374[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15342[(4)]))){
var statearr_15362_15375 = state_15342;
(statearr_15362_15375[(1)] = cljs.core.first((state_15342[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15376 = state_15342;
state_15342 = G__15376;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = function(state_15342){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1.call(this,state_15342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15363 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15363[(6)] = c__2749__auto__);

return statearr_15363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15378 = arguments.length;
switch (G__15378) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15548){
var state_val_15549 = (state_15548[(1)]);
if((state_val_15549 === (65))){
var state_15548__$1 = state_15548;
var statearr_15550_15650 = state_15548__$1;
(statearr_15550_15650[(2)] = null);

(statearr_15550_15650[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (70))){
var inst_15543 = (state_15548[(2)]);
var _ = (function (){var statearr_15551 = state_15548;
(statearr_15551[(4)] = cljs.core.rest((state_15548[(4)])));

return statearr_15551;
})();
var state_15548__$1 = state_15548;
var statearr_15552_15651 = state_15548__$1;
(statearr_15552_15651[(2)] = inst_15543);

(statearr_15552_15651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (62))){
var inst_15529 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15553_15652 = state_15548__$1;
(statearr_15553_15652[(2)] = inst_15529);

(statearr_15553_15652[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (7))){
var state_15548__$1 = state_15548;
var statearr_15554_15653 = state_15548__$1;
(statearr_15554_15653[(2)] = false);

(statearr_15554_15653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (59))){
var inst_15503 = (state_15548[(2)]);
var inst_15504 = fluree.db.util.async.throw_err(inst_15503);
var state_15548__$1 = state_15548;
var statearr_15555_15654 = state_15548__$1;
(statearr_15555_15654[(2)] = inst_15504);

(statearr_15555_15654[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (20))){
var state_15548__$1 = state_15548;
var statearr_15556_15655 = state_15548__$1;
(statearr_15556_15655[(2)] = null);

(statearr_15556_15655[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (58))){
var inst_15493 = (state_15548[(2)]);
var inst_15494 = fluree.db.util.async.throw_err(inst_15493);
var inst_15495 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_15494);
var state_15548__$1 = state_15548;
var statearr_15557_15656 = state_15548__$1;
(statearr_15557_15656[(2)] = inst_15495);

(statearr_15557_15656[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (60))){
var inst_15429 = (state_15548[(7)]);
var inst_15392 = (state_15548[(8)]);
var inst_15389 = (state_15548[(9)]);
var inst_15390 = (state_15548[(10)]);
var inst_15509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15510 = [inst_15390,inst_15389,inst_15429,inst_15392];
var inst_15511 = (new cljs.core.PersistentVector(null,4,(5),inst_15509,inst_15510,null));
var inst_15512 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15511,opts);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15548__$1,(63),inst_15512);
} else {
if((state_val_15549 === (27))){
var inst_15429 = (state_15548[(7)]);
var inst_15440 = (state_15548[(11)]);
var inst_15440__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_15429);
var state_15548__$1 = (function (){var statearr_15558 = state_15548;
(statearr_15558[(11)] = inst_15440__$1);

return statearr_15558;
})();
if(inst_15440__$1){
var statearr_15559_15657 = state_15548__$1;
(statearr_15559_15657[(1)] = (30));

} else {
var statearr_15560_15658 = state_15548__$1;
(statearr_15560_15658[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (1))){
var state_15548__$1 = state_15548;
var statearr_15561_15659 = state_15548__$1;
(statearr_15561_15659[(2)] = null);

(statearr_15561_15659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (69))){
var inst_15535 = (state_15548[(12)]);
var state_15548__$1 = state_15548;
var statearr_15562_15660 = state_15548__$1;
(statearr_15562_15660[(2)] = inst_15535);

(statearr_15562_15660[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (24))){
var inst_15390 = (state_15548[(10)]);
var state_15548__$1 = state_15548;
if(cljs.core.truth_(inst_15390)){
var statearr_15563_15661 = state_15548__$1;
(statearr_15563_15661[(1)] = (27));

} else {
var statearr_15564_15662 = state_15548__$1;
(statearr_15564_15662[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (55))){
var inst_15429 = (state_15548[(7)]);
var inst_15487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15488 = [inst_15429];
var inst_15489 = (new cljs.core.PersistentVector(null,1,(5),inst_15487,inst_15488,null));
var inst_15490 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15491 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15489,inst_15490);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15548__$1,(58),inst_15491);
} else {
if((state_val_15549 === (39))){
var inst_15460 = (state_15548[(2)]);
var inst_15461 = fluree.db.util.async.throw_err(inst_15460);
var state_15548__$1 = state_15548;
var statearr_15565_15663 = state_15548__$1;
(statearr_15565_15663[(2)] = inst_15461);

(statearr_15565_15663[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (46))){
var inst_15473 = (state_15548[(13)]);
var inst_15473__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15548__$1 = (function (){var statearr_15566 = state_15548;
(statearr_15566[(13)] = inst_15473__$1);

return statearr_15566;
})();
if(cljs.core.truth_(inst_15473__$1)){
var statearr_15567_15664 = state_15548__$1;
(statearr_15567_15664[(1)] = (49));

} else {
var statearr_15568_15665 = state_15548__$1;
(statearr_15568_15665[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (4))){
var inst_15379 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15569_15666 = state_15548__$1;
(statearr_15569_15666[(2)] = inst_15379);

(statearr_15569_15666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (54))){
var inst_15485 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
if(cljs.core.truth_(inst_15485)){
var statearr_15570_15667 = state_15548__$1;
(statearr_15570_15667[(1)] = (55));

} else {
var statearr_15571_15668 = state_15548__$1;
(statearr_15571_15668[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (15))){
var inst_15391 = (state_15548[(14)]);
var inst_15410 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15391);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15548__$1,(18),inst_15410);
} else {
if((state_val_15549 === (48))){
var inst_15531 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15572_15669 = state_15548__$1;
(statearr_15572_15669[(2)] = inst_15531);

(statearr_15572_15669[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (50))){
var inst_15473 = (state_15548[(13)]);
var inst_15429 = (state_15548[(7)]);
var inst_15388 = (state_15548[(15)]);
var inst_15404 = (state_15548[(16)]);
var inst_15392 = (state_15548[(8)]);
var inst_15389 = (state_15548[(9)]);
var inst_15390 = (state_15548[(10)]);
var inst_15399 = (state_15548[(17)]);
var inst_15393 = (state_15548[(18)]);
var inst_15477 = (function (){var t = inst_15392;
var p = inst_15390;
var idx_predicate_QMARK_ = inst_15393;
var o = inst_15429;
var tag_predicate_QMARK_ = inst_15399;
var temp__5751__auto__ = inst_15473;
var s = inst_15389;
var o_coerce_QMARK_ = inst_15404;
var vec__15385 = inst_15388;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_15548__$1 = state_15548;
var statearr_15573_15670 = state_15548__$1;
(statearr_15573_15670[(2)] = inst_15477);

(statearr_15573_15670[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (21))){
var inst_15425 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15574_15671 = state_15548__$1;
(statearr_15574_15671[(2)] = inst_15425);

(statearr_15574_15671[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (31))){
var inst_15440 = (state_15548[(11)]);
var state_15548__$1 = state_15548;
var statearr_15575_15672 = state_15548__$1;
(statearr_15575_15672[(2)] = inst_15440);

(statearr_15575_15672[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (32))){
var inst_15450 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15576_15673 = state_15548__$1;
(statearr_15576_15673[(2)] = inst_15450);

(statearr_15576_15673[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (40))){
var inst_15464 = (state_15548[(19)]);
var inst_15393 = (state_15548[(18)]);
var inst_15464__$1 = cljs.core.not(inst_15393);
var state_15548__$1 = (function (){var statearr_15577 = state_15548;
(statearr_15577[(19)] = inst_15464__$1);

return statearr_15577;
})();
if(inst_15464__$1){
var statearr_15578_15674 = state_15548__$1;
(statearr_15578_15674[(1)] = (43));

} else {
var statearr_15579_15675 = state_15548__$1;
(statearr_15579_15675[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (56))){
var inst_15392 = (state_15548[(8)]);
var inst_15389 = (state_15548[(9)]);
var inst_15479 = (state_15548[(20)]);
var inst_15390 = (state_15548[(10)]);
var inst_15497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15498 = [inst_15390,inst_15389,null,inst_15392];
var inst_15499 = (new cljs.core.PersistentVector(null,4,(5),inst_15497,inst_15498,null));
var inst_15500 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15479);
var inst_15501 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15499,inst_15500);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15548__$1,(59),inst_15501);
} else {
if((state_val_15549 === (33))){
var inst_15429 = (state_15548[(7)]);
var inst_15443 = cljs.core.fn_QMARK_(inst_15429);
var inst_15444 = (!(inst_15443));
var state_15548__$1 = state_15548;
var statearr_15580_15676 = state_15548__$1;
(statearr_15580_15676[(2)] = inst_15444);

(statearr_15580_15676[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (13))){
var inst_15391 = (state_15548[(14)]);
var inst_15408 = fluree.db.query.range.tag_string_QMARK_(inst_15391);
var state_15548__$1 = state_15548;
if(cljs.core.truth_(inst_15408)){
var statearr_15581_15677 = state_15548__$1;
(statearr_15581_15677[(1)] = (15));

} else {
var statearr_15582_15678 = state_15548__$1;
(statearr_15582_15678[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (22))){
var inst_15421 = (state_15548[(2)]);
var inst_15422 = fluree.db.util.async.throw_err(inst_15421);
var state_15548__$1 = state_15548;
var statearr_15583_15679 = state_15548__$1;
(statearr_15583_15679[(2)] = inst_15422);

(statearr_15583_15679[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (36))){
var inst_15429 = (state_15548[(7)]);
var inst_15392 = (state_15548[(8)]);
var inst_15389 = (state_15548[(9)]);
var inst_15390 = (state_15548[(10)]);
var inst_15455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15456 = [inst_15390,inst_15429,inst_15389,inst_15392];
var inst_15457 = (new cljs.core.PersistentVector(null,4,(5),inst_15455,inst_15456,null));
var inst_15458 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15457,opts);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15548__$1,(39),inst_15458);
} else {
if((state_val_15549 === (41))){
var inst_15390 = (state_15548[(10)]);
var state_15548__$1 = state_15548;
var statearr_15584_15680 = state_15548__$1;
(statearr_15584_15680[(2)] = inst_15390);

(statearr_15584_15680[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (43))){
var inst_15429 = (state_15548[(7)]);
var state_15548__$1 = state_15548;
var statearr_15585_15681 = state_15548__$1;
(statearr_15585_15681[(2)] = inst_15429);

(statearr_15585_15681[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (61))){
var inst_15429 = (state_15548[(7)]);
var state_15548__$1 = state_15548;
if(cljs.core.truth_(inst_15429)){
var statearr_15586_15682 = state_15548__$1;
(statearr_15586_15682[(1)] = (64));

} else {
var statearr_15587_15683 = state_15548__$1;
(statearr_15587_15683[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (29))){
var inst_15453 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
if(cljs.core.truth_(inst_15453)){
var statearr_15588_15684 = state_15548__$1;
(statearr_15588_15684[(1)] = (36));

} else {
var statearr_15589_15685 = state_15548__$1;
(statearr_15589_15685[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (44))){
var inst_15464 = (state_15548[(19)]);
var state_15548__$1 = state_15548;
var statearr_15590_15686 = state_15548__$1;
(statearr_15590_15686[(2)] = inst_15464);

(statearr_15590_15686[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (6))){
var inst_15390 = (state_15548[(10)]);
var inst_15395 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15390);
var inst_15396 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15395);
var state_15548__$1 = state_15548;
var statearr_15591_15687 = state_15548__$1;
(statearr_15591_15687[(2)] = inst_15396);

(statearr_15591_15687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (28))){
var inst_15390 = (state_15548[(10)]);
var state_15548__$1 = state_15548;
var statearr_15592_15688 = state_15548__$1;
(statearr_15592_15688[(2)] = inst_15390);

(statearr_15592_15688[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (64))){
var inst_15429 = (state_15548[(7)]);
var inst_15392 = (state_15548[(8)]);
var inst_15389 = (state_15548[(9)]);
var inst_15390 = (state_15548[(10)]);
var inst_15518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15519 = [inst_15429,inst_15390,inst_15389,inst_15392];
var inst_15520 = (new cljs.core.PersistentVector(null,4,(5),inst_15518,inst_15519,null));
var inst_15521 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15520,opts);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15548__$1,(67),inst_15521);
} else {
if((state_val_15549 === (51))){
var inst_15480 = (state_15548[(21)]);
var inst_15390 = (state_15548[(10)]);
var inst_15479 = (state_15548[(2)]);
var inst_15480__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15390);
var state_15548__$1 = (function (){var statearr_15593 = state_15548;
(statearr_15593[(21)] = inst_15480__$1);

(statearr_15593[(20)] = inst_15479);

return statearr_15593;
})();
if(inst_15480__$1){
var statearr_15594_15689 = state_15548__$1;
(statearr_15594_15689[(1)] = (52));

} else {
var statearr_15595_15690 = state_15548__$1;
(statearr_15595_15690[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (25))){
var inst_15399 = (state_15548[(17)]);
var inst_15535 = (state_15548[(2)]);
var state_15548__$1 = (function (){var statearr_15596 = state_15548;
(statearr_15596[(12)] = inst_15535);

return statearr_15596;
})();
if(cljs.core.truth_(inst_15399)){
var statearr_15597_15691 = state_15548__$1;
(statearr_15597_15691[(1)] = (68));

} else {
var statearr_15598_15692 = state_15548__$1;
(statearr_15598_15692[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (34))){
var inst_15393 = (state_15548[(18)]);
var state_15548__$1 = state_15548;
var statearr_15599_15693 = state_15548__$1;
(statearr_15599_15693[(2)] = inst_15393);

(statearr_15599_15693[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (17))){
var inst_15427 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15600_15694 = state_15548__$1;
(statearr_15600_15694[(2)] = inst_15427);

(statearr_15600_15694[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (3))){
var inst_15546 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15548__$1,inst_15546);
} else {
if((state_val_15549 === (12))){
var inst_15391 = (state_15548[(14)]);
var state_15548__$1 = state_15548;
var statearr_15601_15695 = state_15548__$1;
(statearr_15601_15695[(2)] = inst_15391);

(statearr_15601_15695[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (2))){
var inst_15388 = (state_15548[(15)]);
var inst_15390 = (state_15548[(10)]);
var _ = (function (){var statearr_15602 = state_15548;
(statearr_15602[(4)] = cljs.core.cons((5),(state_15548[(4)])));

return statearr_15602;
})();
var inst_15388__$1 = fparts;
var inst_15389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15388__$1,(0),null);
var inst_15390__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15388__$1,(1),null);
var inst_15391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15388__$1,(2),null);
var inst_15392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15388__$1,(3),null);
var inst_15393 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15390__$1);
var state_15548__$1 = (function (){var statearr_15603 = state_15548;
(statearr_15603[(15)] = inst_15388__$1);

(statearr_15603[(8)] = inst_15392);

(statearr_15603[(9)] = inst_15389);

(statearr_15603[(10)] = inst_15390__$1);

(statearr_15603[(14)] = inst_15391);

(statearr_15603[(18)] = inst_15393);

return statearr_15603;
})();
if(cljs.core.truth_(inst_15390__$1)){
var statearr_15604_15696 = state_15548__$1;
(statearr_15604_15696[(1)] = (6));

} else {
var statearr_15605_15697 = state_15548__$1;
(statearr_15605_15697[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (66))){
var inst_15527 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15606_15698 = state_15548__$1;
(statearr_15606_15698[(2)] = inst_15527);

(statearr_15606_15698[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (23))){
var inst_15429 = (state_15548[(7)]);
var inst_15392 = (state_15548[(8)]);
var inst_15389 = (state_15548[(9)]);
var inst_15390 = (state_15548[(10)]);
var inst_15431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15432 = [inst_15389,inst_15390,inst_15429,inst_15392];
var inst_15433 = (new cljs.core.PersistentVector(null,4,(5),inst_15431,inst_15432,null));
var inst_15434 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15433,opts);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15548__$1,(26),inst_15434);
} else {
if((state_val_15549 === (47))){
var inst_15390 = (state_15548[(10)]);
var state_15548__$1 = state_15548;
if(cljs.core.truth_(inst_15390)){
var statearr_15607_15699 = state_15548__$1;
(statearr_15607_15699[(1)] = (60));

} else {
var statearr_15608_15700 = state_15548__$1;
(statearr_15608_15700[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (35))){
var inst_15447 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15609_15701 = state_15548__$1;
(statearr_15609_15701[(2)] = inst_15447);

(statearr_15609_15701[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (19))){
var inst_15390 = (state_15548[(10)]);
var inst_15391 = (state_15548[(14)]);
var inst_15417 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15390);
var inst_15418 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15417),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15391)].join('');
var inst_15419 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15418);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15548__$1,(22),inst_15419);
} else {
if((state_val_15549 === (57))){
var inst_15506 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15610_15702 = state_15548__$1;
(statearr_15610_15702[(2)] = inst_15506);

(statearr_15610_15702[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (68))){
var inst_15535 = (state_15548[(12)]);
var inst_15537 = fluree.db.query.range.coerce_tag_flakes(db,inst_15535);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15548__$1,(71),inst_15537);
} else {
if((state_val_15549 === (11))){
var inst_15404 = (state_15548[(16)]);
var inst_15404__$1 = (state_15548[(2)]);
var inst_15405 = cljs.core.not(inst_15404__$1);
var state_15548__$1 = (function (){var statearr_15612 = state_15548;
(statearr_15612[(16)] = inst_15404__$1);

return statearr_15612;
})();
if(inst_15405){
var statearr_15613_15703 = state_15548__$1;
(statearr_15613_15703[(1)] = (12));

} else {
var statearr_15614_15704 = state_15548__$1;
(statearr_15614_15704[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (9))){
var inst_15391 = (state_15548[(14)]);
var inst_15401 = typeof inst_15391 === 'string';
var state_15548__$1 = state_15548;
var statearr_15615_15705 = state_15548__$1;
(statearr_15615_15705[(2)] = inst_15401);

(statearr_15615_15705[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (5))){
var _ = (function (){var statearr_15616 = state_15548;
(statearr_15616[(4)] = cljs.core.rest((state_15548[(4)])));

return statearr_15616;
})();
var state_15548__$1 = state_15548;
var ex15611 = (state_15548__$1[(2)]);
var statearr_15617_15706 = state_15548__$1;
(statearr_15617_15706[(5)] = ex15611);


if((ex15611 instanceof Error)){
var statearr_15618_15707 = state_15548__$1;
(statearr_15618_15707[(1)] = (4));

(statearr_15618_15707[(5)] = null);

} else {
throw ex15611;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (14))){
var inst_15389 = (state_15548[(9)]);
var inst_15429 = (state_15548[(2)]);
var state_15548__$1 = (function (){var statearr_15619 = state_15548;
(statearr_15619[(7)] = inst_15429);

return statearr_15619;
})();
if(cljs.core.truth_(inst_15389)){
var statearr_15620_15708 = state_15548__$1;
(statearr_15620_15708[(1)] = (23));

} else {
var statearr_15621_15709 = state_15548__$1;
(statearr_15621_15709[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (45))){
var inst_15468 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15622_15710 = state_15548__$1;
(statearr_15622_15710[(2)] = inst_15468);

(statearr_15622_15710[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (53))){
var inst_15480 = (state_15548[(21)]);
var state_15548__$1 = state_15548;
var statearr_15623_15711 = state_15548__$1;
(statearr_15623_15711[(2)] = inst_15480);

(statearr_15623_15711[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (26))){
var inst_15436 = (state_15548[(2)]);
var inst_15437 = fluree.db.util.async.throw_err(inst_15436);
var state_15548__$1 = state_15548;
var statearr_15624_15712 = state_15548__$1;
(statearr_15624_15712[(2)] = inst_15437);

(statearr_15624_15712[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (16))){
var inst_15391 = (state_15548[(14)]);
var inst_15415 = typeof inst_15391 === 'string';
var state_15548__$1 = state_15548;
if(cljs.core.truth_(inst_15415)){
var statearr_15625_15713 = state_15548__$1;
(statearr_15625_15713[(1)] = (19));

} else {
var statearr_15626_15714 = state_15548__$1;
(statearr_15626_15714[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (38))){
var inst_15533 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15627_15715 = state_15548__$1;
(statearr_15627_15715[(2)] = inst_15533);

(statearr_15627_15715[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (30))){
var inst_15393 = (state_15548[(18)]);
var state_15548__$1 = state_15548;
if(cljs.core.truth_(inst_15393)){
var statearr_15628_15716 = state_15548__$1;
(statearr_15628_15716[(1)] = (33));

} else {
var statearr_15629_15717 = state_15548__$1;
(statearr_15629_15717[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (10))){
var inst_15399 = (state_15548[(17)]);
var state_15548__$1 = state_15548;
var statearr_15630_15718 = state_15548__$1;
(statearr_15630_15718[(2)] = inst_15399);

(statearr_15630_15718[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (18))){
var inst_15412 = (state_15548[(2)]);
var inst_15413 = fluree.db.util.async.throw_err(inst_15412);
var state_15548__$1 = state_15548;
var statearr_15631_15719 = state_15548__$1;
(statearr_15631_15719[(2)] = inst_15413);

(statearr_15631_15719[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (52))){
var inst_15429 = (state_15548[(7)]);
var inst_15482 = cljs.core.int_QMARK_(inst_15429);
var state_15548__$1 = state_15548;
var statearr_15632_15720 = state_15548__$1;
(statearr_15632_15720[(2)] = inst_15482);

(statearr_15632_15720[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (67))){
var inst_15523 = (state_15548[(2)]);
var inst_15524 = fluree.db.util.async.throw_err(inst_15523);
var state_15548__$1 = state_15548;
var statearr_15633_15721 = state_15548__$1;
(statearr_15633_15721[(2)] = inst_15524);

(statearr_15633_15721[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (71))){
var inst_15539 = (state_15548[(2)]);
var inst_15540 = fluree.db.util.async.throw_err(inst_15539);
var state_15548__$1 = state_15548;
var statearr_15634_15722 = state_15548__$1;
(statearr_15634_15722[(2)] = inst_15540);

(statearr_15634_15722[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (42))){
var inst_15471 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
if(cljs.core.truth_(inst_15471)){
var statearr_15635_15723 = state_15548__$1;
(statearr_15635_15723[(1)] = (46));

} else {
var statearr_15636_15724 = state_15548__$1;
(statearr_15636_15724[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (37))){
var inst_15390 = (state_15548[(10)]);
var state_15548__$1 = state_15548;
if(cljs.core.truth_(inst_15390)){
var statearr_15637_15725 = state_15548__$1;
(statearr_15637_15725[(1)] = (40));

} else {
var statearr_15638_15726 = state_15548__$1;
(statearr_15638_15726[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (63))){
var inst_15514 = (state_15548[(2)]);
var inst_15515 = fluree.db.util.async.throw_err(inst_15514);
var state_15548__$1 = state_15548;
var statearr_15639_15727 = state_15548__$1;
(statearr_15639_15727[(2)] = inst_15515);

(statearr_15639_15727[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (8))){
var inst_15399 = (state_15548[(17)]);
var inst_15399__$1 = (state_15548[(2)]);
var state_15548__$1 = (function (){var statearr_15640 = state_15548;
(statearr_15640[(17)] = inst_15399__$1);

return statearr_15640;
})();
if(cljs.core.truth_(inst_15399__$1)){
var statearr_15641_15728 = state_15548__$1;
(statearr_15641_15728[(1)] = (9));

} else {
var statearr_15642_15729 = state_15548__$1;
(statearr_15642_15729[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (49))){
var inst_15473 = (state_15548[(13)]);
var inst_15429 = (state_15548[(7)]);
var inst_15388 = (state_15548[(15)]);
var inst_15404 = (state_15548[(16)]);
var inst_15392 = (state_15548[(8)]);
var inst_15389 = (state_15548[(9)]);
var inst_15390 = (state_15548[(10)]);
var inst_15399 = (state_15548[(17)]);
var inst_15393 = (state_15548[(18)]);
var inst_15475 = (function (){var obj_fn = inst_15473;
var t = inst_15392;
var p = inst_15390;
var idx_predicate_QMARK_ = inst_15393;
var o = inst_15429;
var tag_predicate_QMARK_ = inst_15399;
var temp__5751__auto__ = inst_15473;
var s = inst_15389;
var o_coerce_QMARK_ = inst_15404;
var vec__15385 = inst_15388;
return (function (x){
var and__4251__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4251__auto__;
}
});
})();
var state_15548__$1 = state_15548;
var statearr_15643_15730 = state_15548__$1;
(statearr_15643_15730[(2)] = inst_15475);

(statearr_15643_15730[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15644 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15644[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15644[(1)] = (1));

return statearr_15644;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15548){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15548);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15645){var ex__2730__auto__ = e15645;
var statearr_15646_15731 = state_15548;
(statearr_15646_15731[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15548[(4)]))){
var statearr_15647_15732 = state_15548;
(statearr_15647_15732[(1)] = cljs.core.first((state_15548[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15733 = state_15548;
state_15548 = G__15733;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15548){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15648 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15648[(6)] = c__2749__auto__);

return statearr_15648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15735 = arguments.length;
switch (G__15735) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15770){
var state_val_15771 = (state_15770[(1)]);
if((state_val_15771 === (7))){
var inst_15757 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15758 = ["Invalid collection name: ",inst_15757].join('');
var inst_15759 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15760 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15761 = cljs.core.PersistentHashMap.fromArrays(inst_15759,inst_15760);
var inst_15762 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15758,inst_15761);
var inst_15763 = (function(){throw inst_15762})();
var state_15770__$1 = state_15770;
var statearr_15772_15792 = state_15770__$1;
(statearr_15772_15792[(2)] = inst_15763);

(statearr_15772_15792[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15771 === (1))){
var state_15770__$1 = state_15770;
var statearr_15773_15793 = state_15770__$1;
(statearr_15773_15793[(2)] = null);

(statearr_15773_15793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15771 === (4))){
var inst_15736 = (state_15770[(2)]);
var state_15770__$1 = state_15770;
var statearr_15774_15794 = state_15770__$1;
(statearr_15774_15794[(2)] = inst_15736);

(statearr_15774_15794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15771 === (6))){
var inst_15742 = (state_15770[(7)]);
var inst_15744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15745 = fluree.db.flake.max_subject_id(inst_15742);
var inst_15746 = [inst_15745];
var inst_15747 = (new cljs.core.PersistentVector(null,1,(5),inst_15744,inst_15746,null));
var inst_15748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15749 = fluree.db.flake.min_subject_id(inst_15742);
var inst_15750 = [inst_15749];
var inst_15751 = (new cljs.core.PersistentVector(null,1,(5),inst_15748,inst_15750,null));
var inst_15752 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15747,cljs.core._LT__EQ_,inst_15751,opts);
var state_15770__$1 = state_15770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15770__$1,(9),inst_15752);
} else {
if((state_val_15771 === (3))){
var inst_15768 = (state_15770[(2)]);
var state_15770__$1 = state_15770;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15770__$1,inst_15768);
} else {
if((state_val_15771 === (2))){
var inst_15742 = (state_15770[(7)]);
var _ = (function (){var statearr_15776 = state_15770;
(statearr_15776[(4)] = cljs.core.cons((5),(state_15770[(4)])));

return statearr_15776;
})();
var inst_15742__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_15770__$1 = (function (){var statearr_15777 = state_15770;
(statearr_15777[(7)] = inst_15742__$1);

return statearr_15777;
})();
if(cljs.core.truth_(inst_15742__$1)){
var statearr_15778_15795 = state_15770__$1;
(statearr_15778_15795[(1)] = (6));

} else {
var statearr_15779_15796 = state_15770__$1;
(statearr_15779_15796[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15771 === (9))){
var inst_15754 = (state_15770[(2)]);
var inst_15755 = fluree.db.util.async.throw_err(inst_15754);
var state_15770__$1 = state_15770;
var statearr_15780_15797 = state_15770__$1;
(statearr_15780_15797[(2)] = inst_15755);

(statearr_15780_15797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15771 === (5))){
var _ = (function (){var statearr_15781 = state_15770;
(statearr_15781[(4)] = cljs.core.rest((state_15770[(4)])));

return statearr_15781;
})();
var state_15770__$1 = state_15770;
var ex15775 = (state_15770__$1[(2)]);
var statearr_15782_15798 = state_15770__$1;
(statearr_15782_15798[(5)] = ex15775);


var statearr_15783_15799 = state_15770__$1;
(statearr_15783_15799[(1)] = (4));

(statearr_15783_15799[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15771 === (8))){
var inst_15765 = (state_15770[(2)]);
var _ = (function (){var statearr_15784 = state_15770;
(statearr_15784[(4)] = cljs.core.rest((state_15770[(4)])));

return statearr_15784;
})();
var state_15770__$1 = state_15770;
var statearr_15785_15800 = state_15770__$1;
(statearr_15785_15800[(2)] = inst_15765);

(statearr_15785_15800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15786 = [null,null,null,null,null,null,null,null];
(statearr_15786[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15786[(1)] = (1));

return statearr_15786;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15770){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15770);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15787){var ex__2730__auto__ = e15787;
var statearr_15788_15801 = state_15770;
(statearr_15788_15801[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15770[(4)]))){
var statearr_15789_15802 = state_15770;
(statearr_15789_15802[(1)] = cljs.core.first((state_15770[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15803 = state_15770;
state_15770 = G__15803;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15770){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15790 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15790[(6)] = c__2749__auto__);

return statearr_15790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15807 = flakes;
var vec__15808 = G__15807;
var seq__15809 = cljs.core.seq(vec__15808);
var first__15810 = cljs.core.first(seq__15809);
var seq__15809__$1 = cljs.core.next(seq__15809);
var flake_SINGLEQUOTE_ = first__15810;
var r = seq__15809__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15807__$1 = G__15807;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15816 = G__15807__$1;
var seq__15817 = cljs.core.seq(vec__15816);
var first__15818 = cljs.core.first(seq__15817);
var seq__15817__$1 = cljs.core.next(seq__15817);
var flake_SINGLEQUOTE___$1 = first__15818;
var r__$1 = seq__15817__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e15820){var e = e15820;
return null;
}})();
var map__15819 = cmd_map;
var map__15819__$1 = cljs.core.__destructure_map(map__15819);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15819__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15819__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15819__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15819__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15819__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15819__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15821 = r__$1;
var G__15822 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15807__$1 = G__15821;
result_STAR___$1 = G__15822;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15831 = blocks;
var vec__15832 = G__15831;
var seq__15833 = cljs.core.seq(vec__15832);
var first__15834 = cljs.core.first(seq__15833);
var seq__15833__$1 = cljs.core.next(seq__15833);
var block_SINGLEQUOTE_ = first__15834;
var r = seq__15833__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15831__$1 = G__15831;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15839 = G__15831__$1;
var seq__15840 = cljs.core.seq(vec__15839);
var first__15841 = cljs.core.first(seq__15840);
var seq__15840__$1 = cljs.core.next(seq__15840);
var block_SINGLEQUOTE___$1 = first__15841;
var r__$1 = seq__15840__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15842 = block_SINGLEQUOTE___$1;
var map__15842__$1 = cljs.core.__destructure_map(map__15842);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15842__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15842__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15842__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__15831__$1,result_STAR___$1,map__15842,map__15842__$1,block,t,flakes,vec__15839,seq__15840,first__15841,seq__15840__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15831,vec__15832,seq__15833,first__15834,seq__15833__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15823_SHARP_){
var f = p1__15823_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__15831__$1,result_STAR___$1,map__15842,map__15842__$1,block,t,flakes,vec__15839,seq__15840,first__15841,seq__15840__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15831,vec__15832,seq__15833,first__15834,seq__15833__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__15831__$1,result_STAR___$1,map__15842,map__15842__$1,block,t,flakes,prev_hash,vec__15839,seq__15840,first__15841,seq__15840__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15831,vec__15832,seq__15833,first__15834,seq__15833__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15824_SHARP_){
var f = p1__15824_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__15831__$1,result_STAR___$1,map__15842,map__15842__$1,block,t,flakes,prev_hash,vec__15839,seq__15840,first__15841,seq__15840__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15831,vec__15832,seq__15833,first__15834,seq__15833__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__15831__$1,result_STAR___$1,map__15842,map__15842__$1,block,t,flakes,prev_hash,hash,vec__15839,seq__15840,first__15841,seq__15840__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15831,vec__15832,seq__15833,first__15834,seq__15833__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15825_SHARP_){
var f = p1__15825_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__15831__$1,result_STAR___$1,map__15842,map__15842__$1,block,t,flakes,prev_hash,hash,vec__15839,seq__15840,first__15841,seq__15840__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15831,vec__15832,seq__15833,first__15834,seq__15833__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__15831__$1,result_STAR___$1,map__15842,map__15842__$1,block,t,flakes,prev_hash,hash,instant,vec__15839,seq__15840,first__15841,seq__15840__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15831,vec__15832,seq__15833,first__15834,seq__15833__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15826_SHARP_){
var f = p1__15826_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__15831__$1,result_STAR___$1,map__15842,map__15842__$1,block,t,flakes,prev_hash,hash,instant,vec__15839,seq__15840,first__15841,seq__15840__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15831,vec__15832,seq__15833,first__15834,seq__15833__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__15831__$1,result_STAR___$1,map__15842,map__15842__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15839,seq__15840,first__15841,seq__15840__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15831,vec__15832,seq__15833,first__15834,seq__15833__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15827_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15827_SHARP_.p,(106));
});})(G__15831__$1,result_STAR___$1,map__15842,map__15842__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15839,seq__15840,first__15841,seq__15840__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15831,vec__15832,seq__15833,first__15834,seq__15833__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__15843 = r__$1;
var G__15844 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15831__$1 = G__15843;
result_STAR___$1 = G__15844;
continue;
}
break;
}
});
