// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql_parser');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.spec');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
/**
 * Checks to see if the where clause has ' = ', ' > ', ' < ', ' <= ', or ' >= ', and returns true if yes
 */
fluree.db.query.fql_parser.where_clause_valid_QMARK_ = (function fluree$db$query$fql_parser$where_clause_valid_QMARK_(where_clause){
var and__4251__auto__ = typeof where_clause === 'string';
if(and__4251__auto__){
return cljs.core.re_find(/^.* (=|>|<|>=|<=|not=) .*$/,where_clause);
} else {
return and__4251__auto__;
}
});
/**
 * Returns a where clause spec based on a string where caluse.
 *   The spec can be applied to a specific db to coerce predicate names
 *   to predicate ids, validate types, and ultimately generate a filtering function.
 */
fluree.db.query.fql_parser.parse_where_spec = (function fluree$db$query$fql_parser$parse_where_spec(var_args){
var G__22000 = arguments.length;
switch (G__22000) {
case 1:
return fluree.db.query.fql_parser.parse_where_spec.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.fql_parser.parse_where_spec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_parser.parse_where_spec.cljs$core$IFn$_invoke$arity$1 = (function (where){
return fluree.db.query.fql_parser.parse_where_spec.cljs$core$IFn$_invoke$arity$2(where,null);
}));

(fluree.db.query.fql_parser.parse_where_spec.cljs$core$IFn$_invoke$arity$2 = (function (where,default_collection){
if(cljs.core.truth_(fluree.db.query.fql_parser.where_clause_valid_QMARK_(where))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var where_type = (cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.re_matches(/.+ AND .+/,where);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(cljs.core.re_matches(/.+ OR .+/,where));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword(null,"and","and",-971899817):(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.re_matches(/.+ OR .+/,where);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(cljs.core.re_matches(/.+ AND .+/,where));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword(null,"or","or",235744169):((((cljs.core.not(cljs.core.re_matches(/.+ OR .+/,where))) && (cljs.core.not(cljs.core.re_matches(/.+ AND .+/,where)))))?new cljs.core.Keyword(null,"or","or",235744169):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Where clause can have either AND or OR operations, but not both currently: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var args = (function (){var G__22001 = where_type;
var G__22001__$1 = (((G__22001 instanceof cljs.core.Keyword))?G__22001.fqn:null);
switch (G__22001__$1) {
case "and":
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(where,/ AND /);

break;
case "or":
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(where,/ OR /);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__22001__$1)].join('')));

}
})();
var statements = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,arg){
var arg__$1 = clojure.string.trim(arg);
var vec__22002 = cljs.core.re_find(/^([^\s=><].+)[\s]+:?(=|>|<|>=|<=|not=)[\s]+:?(.+)$/,arg__$1);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22002,(0),null);
var pred_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22002,(1),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22002,(2),null);
var match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22002,(3),null);
var pred_name__$1 = ((fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(pred_name,false))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Reverse references cannot be used in a where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((clojure.string.includes_QMARK_(pred_name,"/"))?pred_name:(cljs.core.truth_(default_collection)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(default_collection),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_name)].join(''):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only full namespaced predicate\n                                         names can be used in a where clause. This can be\n                                         provided in a from clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var op_STAR_ = (function (){var G__22005 = op;
switch (G__22005) {
case "=":
return cljs.core._EQ_;

break;
case ">":
return cljs.core._GT_;

break;
case ">=":
return cljs.core._GT__EQ_;

break;
case "<":
return cljs.core._LT_;

break;
case "<=":
return cljs.core._LT__EQ_;

break;
case "not=":
return cljs.core.not_EQ_;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__22005)].join('')));

}
})();
var match_STAR_ = (function (){var temp__5751__auto__ = (function (){var or__4253__auto__ = cljs.core.re_find(/'(.*)'$/,match);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.re_find(/\"(.*)\"$/,match);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var match_str = temp__5751__auto__;
return cljs.core.second(match_str);
} else {
try{if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("true",match)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("false",match)){
return false;
} else {
if(clojure.string.includes_QMARK_(match,".")){
return parseFloat(match);
} else {
return parseInt(match);

}
}
}
}catch (e22006){var ___$1 = e22006;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause in argument: ",arg__$1].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pred_name__$1,op_STAR_,match_STAR_], null));
}),cljs.core.PersistentVector.EMPTY,args);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [where_type,statements], null);
}));

(fluree.db.query.fql_parser.parse_where_spec.cljs$lang$maxFixedArity = 2);

/**
 * Conforms a where spec, using provided db, to use predicate ids and coerces where match values.
 *   If an predicate does not exist, it drops it.
 */
fluree.db.query.fql_parser.conform_where = (function fluree$db$query$fql_parser$conform_where(db,p__22010){
var vec__22011 = p__22010;
var where_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22011,(0),null);
var statements = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22011,(1),null);
var statements_STAR_ = cljs.core.not_empty(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__22014){
var vec__22015 = p__22014;
var pred_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22015,(0),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22015,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22015,(2),null);
var pid = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),pred_name);
if(cljs.core.truth_(pid)){
var pred_type = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),pid);
var o_STAR_ = fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$2(o,pred_type);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pid,op,o_STAR_], null);
} else {
return null;
}
}),statements)));
if(cljs.core.truth_(statements_STAR_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [where_type,statements_STAR_], null);
} else {
return null;
}
});
/**
 * Parses a where clause and coerces the predicates 
 */
fluree.db.query.fql_parser.parse_where = (function fluree$db$query$fql_parser$parse_where(var_args){
var G__22019 = arguments.length;
switch (G__22019) {
case 2:
return fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$2 = (function (db,where){
return fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where,null);
}));

(fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3 = (function (db,where,default_collection){
var where_spec = fluree.db.query.fql_parser.parse_where_spec.cljs$core$IFn$_invoke$arity$2(where,default_collection);
return fluree.db.query.fql_parser.conform_where(db,where_spec);
}));

(fluree.db.query.fql_parser.parse_where.cljs$lang$maxFixedArity = 3);

/**
 * Takes a sequential select statement and turns it into a map.
 */
fluree.db.query.fql_parser.to_select_map = (function fluree$db$query$fql_parser$to_select_map(select){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
var kv = ((cljs.core.sequential_QMARK_(x))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.keyword__GT_str(cljs.core.first(x)),(function (){var v_STAR_ = cljs.core.second(x);
if(cljs.core.coll_QMARK_(v_STAR_)){
return (fluree.db.query.fql_parser.to_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.fql_parser.to_select_map.cljs$core$IFn$_invoke$arity$1(v_STAR_) : fluree.db.query.fql_parser.to_select_map.call(null,v_STAR_));
} else {
return v_STAR_;
}
})()], null):((cljs.core.map_QMARK_(x))?(function (){var values = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (x_item){
var key_x = fluree.db.util.core.keyword__GT_str(cljs.core.key(x_item));
var val_x = cljs.core.val(x_item);
var val_x_SINGLEQUOTE_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_orderBy",key_x))?((cljs.core.coll_QMARK_(val_x))?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"order","order",-1254677256),cljs.core.first(val_x),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),cljs.core.second(val_x)], null):new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"order","order",-1254677256),"ASC",new cljs.core.Keyword(null,"predicate","predicate",-1742501860),val_x], null)):((cljs.core.coll_QMARK_(val_x))?(fluree.db.query.fql_parser.to_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.fql_parser.to_select_map.cljs$core$IFn$_invoke$arity$1(val_x) : fluree.db.query.fql_parser.to_select_map.call(null,val_x)):val_x
));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_x,val_x_SINGLEQUOTE_], null);
}),x);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.flatten(values));
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,null], null)
));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,acc,kv);
}),cljs.core.PersistentArrayMap.EMPTY,select);
});
/**
 * Parses select statement into our own select format.
 *   Has no dependency on a database, or a given schema
 *   at this point.
 * 
 *   Select spec has the following keys:
 *   :name  - name of the predicate
 *   :namespace? - if the predicate 'name' has a namespace included
 *   :wildcard? - true if wildcard query
 *   :id? - true if  _id was explicitly requested
 *   :reverse? - if this predicate is a reverse lookup. 'name' will be the non-reverse named predicate
 *   :as - The result key name to use in the results map for this predicate
 *   :recur - number of recur iterations, if specified
 *   :limit - limit the number of results, if specified (100 default)
 *   :offset - offset the number of results, if specified (0 default)
 *   :select - sub-selection for this predicate - only applicable to 'ref' predicates
 *   :compact - If we are to remove namespaces (or names from reverse refs)
 *   
 */
fluree.db.query.fql_parser.parse = (function fluree$db$query$fql_parser$parse(select,opts){
var select__$1 = ((cljs.core.coll_QMARK_(select))?fluree.db.query.fql_parser.to_select_map(select):select);
var default_compact_QMARK_ = new cljs.core.Keyword(null,"compact","compact",-348732150).cljs$core$IFn$_invoke$arity$1(opts);
return cljs.core.reduce_kv((function (acc,k,v){
var pred = (((k instanceof cljs.core.Keyword))?fluree.db.util.core.keyword__GT_str(k):(((k instanceof cljs.core.Symbol))?cljs.core.str.cljs$core$IFn$_invoke$arity$1(k):k
));
var v_SINGLEQUOTE_ = ((cljs.core.sequential_QMARK_(v))?fluree.db.query.fql_parser.to_select_map(v):v);
var compact_QMARK_ = ((cljs.core.contains_QMARK_(v_SINGLEQUOTE_,"_compact"))?cljs.core.get.cljs$core$IFn$_invoke$arity$2(v_SINGLEQUOTE_,"_compact"):default_compact_QMARK_);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("*",pred)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"compact?","compact?",1216893298),compact_QMARK_], 0));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",pred)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"id?","id?",-1487101183),true);
} else {
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = v_SINGLEQUOTE_;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.map_QMARK_(v)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select spec: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
var sub_select = (function (){var G__22021 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(v_SINGLEQUOTE_,"_limit",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["_offset","_as","_recur","_component","_orderBy","_compact"], 0));
var G__22021__$1 = (((G__22021 == null))?null:cljs.core.not_empty(G__22021));
if((G__22021__$1 == null)){
return null;
} else {
return (fluree.db.query.fql_parser.parse.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql_parser.parse.cljs$core$IFn$_invoke$arity$2(G__22021__$1,opts) : fluree.db.query.fql_parser.parse.call(null,G__22021__$1,opts));
}
})();
var namespace_QMARK_ = clojure.string.includes_QMARK_(pred,"/");
var reverse_QMARK_ = clojure.string.includes_QMARK_(pred,"/_");
var pred_SINGLEQUOTE_ = ((reverse_QMARK_)?clojure.string.replace(pred,"/_","/"):pred);
var as = ((cljs.core.contains_QMARK_(v_SINGLEQUOTE_,"_as"))?cljs.core.get.cljs$core$IFn$_invoke$arity$2(v_SINGLEQUOTE_,"_as"):(cljs.core.truth_((function (){var and__4251__auto__ = default_compact_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return reverse_QMARK_;
} else {
return and__4251__auto__;
}
})())?cljs.core.re_find(/^[^\/]+/,pred):(cljs.core.truth_((function (){var and__4251__auto__ = default_compact_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return namespace_QMARK_;
} else {
return and__4251__auto__;
}
})())?cljs.core.second(cljs.core.re_find(/\/(.+)/,pred)):k
)));
var spec = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"id?","id?",-1487101183),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"namespace?","namespace?",-203321783),new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057),new cljs.core.Keyword(null,"recur","recur",-437573268),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687),new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793)],[new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(sub_select),cljs.core.get.cljs$core$IFn$_invoke$arity$2(v_SINGLEQUOTE_,"_component"),cljs.core.get.cljs$core$IFn$_invoke$arity$3(v_SINGLEQUOTE_,"_limit",(100)),reverse_QMARK_,cljs.core.get.cljs$core$IFn$_invoke$arity$3(v_SINGLEQUOTE_,"_offset",(0)),pred_SINGLEQUOTE_,as,namespace_QMARK_,(0),cljs.core.get.cljs$core$IFn$_invoke$arity$2(v_SINGLEQUOTE_,"_recur"),compact_QMARK_,cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(sub_select),new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(sub_select),cljs.core.get.cljs$core$IFn$_invoke$arity$2(v_SINGLEQUOTE_,"_orderBy")]);
if(reverse_QMARK_){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266),pred_SINGLEQUOTE_], null),spec);
} else {
if(namespace_QMARK_){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),pred_SINGLEQUOTE_], null),spec);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767),pred_SINGLEQUOTE_], null),spec);

}
}

}
}
}),cljs.core.PersistentArrayMap.EMPTY,select__$1);
});
fluree.db.query.fql_parser.p__GT_pred_config = (function fluree$db$query$fql_parser$p__GT_pred_config(db,p,compact_QMARK_){
var name = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),p);
return new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"p","p",151049309),p,new cljs.core.Keyword(null,"limit","limit",-1355822363),null,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"as","as",1148689641),(cljs.core.truth_((function (){var and__4251__auto__ = compact_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return name;
} else {
return and__4251__auto__;
}
})())?cljs.core.second(cljs.core.re_find(/\/(.+)/,name)):(function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(p);
}
})()),new cljs.core.Keyword(null,"multi?","multi?",-749311069),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"multi","multi",-190293005),p),new cljs.core.Keyword(null,"component?","component?",407783990),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"component","component",1555936782),p),new cljs.core.Keyword(null,"tag?","tag?",1714008252),cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p)),new cljs.core.Keyword(null,"ref?","ref?",1932693720),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
/**
 * For a flake selection, build out parts of the
 *   base set of predicates so we don't need to look them up
 *   each time... like multi, component, etc.
 */
fluree.db.query.fql_parser.build_predicate_map = (function fluree$db$query$fql_parser$build_predicate_map(db,pred_name){
var temp__5753__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),pred_name);
if(cljs.core.truth_(temp__5753__auto__)){
var p = temp__5753__auto__;
return fluree.db.query.fql_parser.p__GT_pred_config(db,p,false);
} else {
return null;
}
});
/**
 * Given an predicate spec produced by the parsed select statement,
 *   when an predicate does not have a namespace we will default it to
 *   utilize the namespace of the subject.
 * 
 *   This fills out the predicate spec that couldn't be done earlier because
 *   we did not know the collection.
 */
fluree.db.query.fql_parser.ns_lookup_pred_spec = (function fluree$db$query$fql_parser$ns_lookup_pred_spec(db,collection_id,ns_lookup_spec_map){
var collection_name = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),collection_id);
return cljs.core.reduce_kv((function (acc,k,v){
var pred = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(collection_name),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join('');
var temp__5751__auto__ = fluree.db.query.fql_parser.build_predicate_map(db,pred);
if(cljs.core.truth_(temp__5751__auto__)){
var p_map = temp__5751__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(p_map),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_map,v], 0)));
} else {
return acc;
}
}),null,ns_lookup_spec_map);
});
fluree.db.query.fql_parser.parse_db_STAR_ = (function fluree$db$query$fql_parser$parse_db_STAR_(db,sub_select){
var G__22028 = sub_select;
var vec__22029 = G__22028;
var seq__22030 = cljs.core.seq(vec__22029);
var first__22031 = cljs.core.first(seq__22030);
var seq__22030__$1 = cljs.core.next(seq__22030);
var vec__22032 = first__22031;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22032,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22032,(1),null);
var r = seq__22030__$1;
var acc = cljs.core.PersistentArrayMap.EMPTY;
var G__22028__$1 = G__22028;
var acc__$1 = acc;
while(true){
var vec__22096 = G__22028__$1;
var seq__22097 = cljs.core.seq(vec__22096);
var first__22098 = cljs.core.first(seq__22097);
var seq__22097__$1 = cljs.core.next(seq__22097);
var vec__22099 = first__22098;
var k__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22099,(0),null);
var v__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22099,(1),null);
var r__$1 = seq__22097__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(k__$1)){
return acc__$2;
} else {
var v_SINGLEQUOTE_ = ((cljs.core.not((function (){var fexpr__22102 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),null,new cljs.core.Keyword(null,"reverse","reverse",-888455266),null], null), null);
return (fexpr__22102.cljs$core$IFn$_invoke$arity$1 ? fexpr__22102.cljs$core$IFn$_invoke$arity$1(k__$1) : fexpr__22102.call(null,k__$1));
})()))?v__$1:(function (){var G__22109 = v__$1;
var vec__22110 = G__22109;
var seq__22111 = cljs.core.seq(vec__22110);
var first__22112 = cljs.core.first(seq__22111);
var seq__22111__$1 = cljs.core.next(seq__22111);
var vec__22113 = first__22112;
var k_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22113,(0),null);
var v_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22113,(1),null);
var r_STAR_ = seq__22111__$1;
var acc_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
var G__22109__$1 = G__22109;
var acc_STAR___$1 = acc_STAR_;
while(true){
var vec__22122 = G__22109__$1;
var seq__22123 = cljs.core.seq(vec__22122);
var first__22124 = cljs.core.first(seq__22123);
var seq__22123__$1 = cljs.core.next(seq__22123);
var vec__22125 = first__22124;
var k_STAR___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22125,(0),null);
var v_STAR___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22125,(1),null);
var r_STAR___$1 = seq__22123__$1;
var acc_STAR___$2 = acc_STAR___$1;
if(cljs.core.not(k_STAR___$1)){
return acc_STAR___$2;
} else {
var p_map = fluree.db.query.fql_parser.build_predicate_map(db,k_STAR___$1);
var acc_STAR__STAR_ = (cljs.core.truth_(p_map)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc_STAR___$2,new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(p_map),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_map,v_STAR___$1], 0))):acc_STAR___$2);
var G__22157 = r_STAR___$1;
var G__22158 = acc_STAR__STAR_;
G__22109__$1 = G__22157;
acc_STAR___$1 = G__22158;
continue;
}
break;
}
})());
var v_SINGLEQUOTE__SINGLEQUOTE_ = (function (){var G__22134 = v_SINGLEQUOTE_;
var vec__22135 = G__22134;
var seq__22136 = cljs.core.seq(vec__22135);
var first__22137 = cljs.core.first(seq__22136);
var seq__22136__$1 = cljs.core.next(seq__22136);
var vec__22138 = first__22137;
var k_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22138,(0),null);
var v_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22138,(1),null);
var r_STAR_ = seq__22136__$1;
var acc_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
var G__22134__$1 = G__22134;
var acc_STAR___$1 = acc_STAR_;
while(true){
var vec__22149 = G__22134__$1;
var seq__22150 = cljs.core.seq(vec__22149);
var first__22151 = cljs.core.first(seq__22150);
var seq__22150__$1 = cljs.core.next(seq__22150);
var vec__22152 = first__22151;
var k_STAR___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22152,(0),null);
var v_STAR___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22152,(1),null);
var r_STAR___$1 = seq__22150__$1;
var acc_STAR___$2 = acc_STAR___$1;
if(cljs.core.not(k_STAR___$1)){
return acc_STAR___$2;
} else {
var acc_STAR__STAR_ = (cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(v_STAR___$1))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc_STAR___$2,k_STAR___$1,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v_STAR___$1,new cljs.core.Keyword(null,"select","select",1147833503),(function (){var G__22155 = db;
var G__22156 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(v_STAR___$1);
return (fluree.db.query.fql_parser.parse_db_STAR_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql_parser.parse_db_STAR_.cljs$core$IFn$_invoke$arity$2(G__22155,G__22156) : fluree.db.query.fql_parser.parse_db_STAR_.call(null,G__22155,G__22156));
})())):cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc_STAR___$2,k_STAR___$1,v_STAR___$1));
var G__22159 = r_STAR___$1;
var G__22160 = acc_STAR__STAR_;
G__22134__$1 = G__22159;
acc_STAR___$1 = G__22160;
continue;
}
break;
}
})();
var acc_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc__$2,k__$1,v_SINGLEQUOTE__SINGLEQUOTE_);
var G__22161 = r__$1;
var G__22162 = acc_SINGLEQUOTE_;
G__22028__$1 = G__22161;
acc__$1 = G__22162;
continue;
}
break;
}
});
fluree.db.query.fql_parser.select_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"version","version",425292698),(0)], null));
fluree.db.query.fql_parser.reset_select_cache_BANG_ = (function fluree$db$query$fql_parser$reset_select_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.query.fql_parser.select_cache,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"version","version",425292698),(0)], null));
});
/**
 * Parses, but leverages a specific db to convert predicate
 * names that it can into more complete select statement maps.
 * 
 * Caches results based on database version.
 */
fluree.db.query.fql_parser.parse_db = (function fluree$db$query$fql_parser$parse_db(db,select,opts){
var schema_version = fluree.db.query.schema.version(db);
if((schema_version < new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(fluree.db.query.fql_parser.select_cache)))){
cljs.core.reset_BANG_(fluree.db.query.fql_parser.select_cache,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"version","version",425292698),schema_version], null));
} else {
}

var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.query.fql_parser.select_cache),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema_version,select,opts], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var select_smt = fluree.db.query.fql_parser.parse(select,opts);
var select_smt_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(select_smt,new cljs.core.Keyword(null,"select","select",1147833503),fluree.db.query.fql_parser.parse_db_STAR_(db,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select_smt)));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.query.fql_parser.select_cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema_version,select,opts], null),select_smt_STAR_);

return select_smt_STAR_;
}
});
