// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e20213){var e = e20213;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__20214_SHARP_){
var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__20214_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__20214_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__20214_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__20214_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20215_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20215_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20216_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20216_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4251__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4253__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20221 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20221,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20221,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20217_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20217_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4251__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4251__auto__;
}
})())){
var vec__20224 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20224,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20224,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4253__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20218_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20218_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20219_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20219_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20220_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20220_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20227_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__20227_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (add_amount > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fuel;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4251__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__20228 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__20228) : intersecting_vars.call(null,G__20228));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20231,optional_QMARK_,fuel,max_fuel){
var map__20232 = p__20231;
var map__20232__$1 = cljs.core.__destructure_map(map__20232);
var res = map__20232__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20232__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20298){
var state_val_20299 = (state_20298[(1)]);
if((state_val_20299 === (7))){
var inst_20287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20288 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_20289 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20288,clause);
var inst_20290 = [null,inst_20289];
var inst_20291 = (new cljs.core.PersistentVector(null,2,(5),inst_20287,inst_20290,null));
var state_20298__$1 = state_20298;
var statearr_20300_20328 = state_20298__$1;
(statearr_20300_20328[(2)] = inst_20291);

(statearr_20300_20328[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (1))){
var state_20298__$1 = state_20298;
var statearr_20301_20329 = state_20298__$1;
(statearr_20301_20329[(2)] = null);

(statearr_20301_20329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (4))){
var inst_20233 = (state_20298[(2)]);
var state_20298__$1 = state_20298;
var statearr_20302_20330 = state_20298__$1;
(statearr_20302_20330[(2)] = inst_20233);

(statearr_20302_20330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (15))){
var inst_20276 = (state_20298[(2)]);
var inst_20277 = fluree.db.util.async.throw_err(inst_20276);
var inst_20278 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20277);
var inst_20279 = cljs.core.count(inst_20278);
var inst_20280 = fluree.db.query.analytical.add_fuel(inst_20279,fuel,max_fuel);
var inst_20281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20282 = [inst_20277,r];
var inst_20283 = (new cljs.core.PersistentVector(null,2,(5),inst_20281,inst_20282,null));
var state_20298__$1 = (function (){var statearr_20303 = state_20298;
(statearr_20303[(7)] = inst_20280);

return statearr_20303;
})();
var statearr_20304_20331 = state_20298__$1;
(statearr_20304_20331[(2)] = inst_20283);

(statearr_20304_20331[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (13))){
var inst_20242 = (state_20298[(8)]);
var inst_20255 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20256 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_20255);
var inst_20257 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20242);
var inst_20258 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20257);
var inst_20259 = cljs.core.set(inst_20258);
var inst_20260 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20256);
var inst_20261 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20260);
var inst_20262 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20259,inst_20261);
var inst_20263 = (function (){var all_wd = inst_20242;
var optional = inst_20256;
var all_wd_vars = inst_20259;
var all_vars = inst_20262;
return (function (p1__20229_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__20229_SHARP_) : all_vars.call(null,p1__20229_SHARP_));
});
})();
var inst_20264 = cljs.core.keys(vars);
var inst_20265 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20263,inst_20264);
var inst_20266 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_20265);
var inst_20267 = cljs.core.set(inst_20266);
var inst_20268 = (function (){var all_wd = inst_20242;
var optional = inst_20256;
var all_wd_vars = inst_20259;
var all_vars = inst_20262;
var intersecting_vars = inst_20267;
return (function (p1__20230_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__20230_SHARP_);
});
})();
var inst_20269 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20268,inst_20242);
var inst_20270 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20269);
var inst_20271 = fluree.db.query.analytical.select_from_tuples(inst_20270,res);
var inst_20272 = fluree.db.query.analytical.replace_vars_wikidata(inst_20242,inst_20267,vars);
var inst_20273 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_20267,inst_20262);
var inst_20274 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_20272,inst_20270,inst_20271,inst_20273,inst_20256);
var state_20298__$1 = state_20298;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20298__$1,(15),inst_20274);
} else {
if((state_val_20299 === (6))){
var inst_20243 = (state_20298[(9)]);
var inst_20241 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20242 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_20241);
var inst_20243__$1 = optional_QMARK_;
var state_20298__$1 = (function (){var statearr_20305 = state_20298;
(statearr_20305[(8)] = inst_20242);

(statearr_20305[(9)] = inst_20243__$1);

return statearr_20305;
})();
if(cljs.core.truth_(inst_20243__$1)){
var statearr_20306_20332 = state_20298__$1;
(statearr_20306_20332[(1)] = (9));

} else {
var statearr_20307_20333 = state_20298__$1;
(statearr_20307_20333[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (3))){
var inst_20296 = (state_20298[(2)]);
var state_20298__$1 = state_20298;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20298__$1,inst_20296);
} else {
if((state_val_20299 === (12))){
var inst_20251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20252 = [null,r];
var inst_20253 = (new cljs.core.PersistentVector(null,2,(5),inst_20251,inst_20252,null));
var state_20298__$1 = state_20298;
var statearr_20308_20334 = state_20298__$1;
(statearr_20308_20334[(2)] = inst_20253);

(statearr_20308_20334[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (2))){
var _ = (function (){var statearr_20309 = state_20298;
(statearr_20309[(4)] = cljs.core.cons((5),(state_20298[(4)])));

return statearr_20309;
})();
var inst_20239 = (r == null);
var state_20298__$1 = state_20298;
if(cljs.core.truth_(inst_20239)){
var statearr_20310_20335 = state_20298__$1;
(statearr_20310_20335[(1)] = (6));

} else {
var statearr_20311_20336 = state_20298__$1;
(statearr_20311_20336[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (11))){
var inst_20249 = (state_20298[(2)]);
var state_20298__$1 = state_20298;
if(cljs.core.truth_(inst_20249)){
var statearr_20313_20337 = state_20298__$1;
(statearr_20313_20337[(1)] = (12));

} else {
var statearr_20314_20338 = state_20298__$1;
(statearr_20314_20338[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (9))){
var inst_20242 = (state_20298[(8)]);
var inst_20245 = cljs.core.empty_QMARK_(inst_20242);
var inst_20246 = (!(inst_20245));
var state_20298__$1 = state_20298;
var statearr_20315_20339 = state_20298__$1;
(statearr_20315_20339[(2)] = inst_20246);

(statearr_20315_20339[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (5))){
var _ = (function (){var statearr_20316 = state_20298;
(statearr_20316[(4)] = cljs.core.rest((state_20298[(4)])));

return statearr_20316;
})();
var state_20298__$1 = state_20298;
var ex20312 = (state_20298__$1[(2)]);
var statearr_20317_20340 = state_20298__$1;
(statearr_20317_20340[(5)] = ex20312);


if((ex20312 instanceof Error)){
var statearr_20318_20341 = state_20298__$1;
(statearr_20318_20341[(1)] = (4));

(statearr_20318_20341[(5)] = null);

} else {
throw ex20312;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (14))){
var inst_20285 = (state_20298[(2)]);
var state_20298__$1 = state_20298;
var statearr_20319_20342 = state_20298__$1;
(statearr_20319_20342[(2)] = inst_20285);

(statearr_20319_20342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (10))){
var inst_20243 = (state_20298[(9)]);
var state_20298__$1 = state_20298;
var statearr_20320_20343 = state_20298__$1;
(statearr_20320_20343[(2)] = inst_20243);

(statearr_20320_20343[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20299 === (8))){
var inst_20293 = (state_20298[(2)]);
var _ = (function (){var statearr_20321 = state_20298;
(statearr_20321[(4)] = cljs.core.rest((state_20298[(4)])));

return statearr_20321;
})();
var state_20298__$1 = state_20298;
var statearr_20322_20344 = state_20298__$1;
(statearr_20322_20344[(2)] = inst_20293);

(statearr_20322_20344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20323 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20323[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__);

(statearr_20323[(1)] = (1));

return statearr_20323;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1 = (function (state_20298){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20298);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20324){var ex__2730__auto__ = e20324;
var statearr_20325_20345 = state_20298;
(statearr_20325_20345[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20298[(4)]))){
var statearr_20326_20346 = state_20298;
(statearr_20326_20346[(1)] = cljs.core.first((state_20298[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20347 = state_20298;
state_20298 = G__20347;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = function(state_20298){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1.call(this,state_20298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20327 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20327[(6)] = c__2749__auto__);

return statearr_20327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20349 = arguments.length;
switch (G__20349) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20443){
var state_val_20444 = (state_20443[(1)]);
if((state_val_20444 === (7))){
var inst_20356 = (state_20443[(7)]);
var inst_20366 = clojure.string.starts_with_QMARK_(inst_20356,"$fdb");
var state_20443__$1 = state_20443;
if(inst_20366){
var statearr_20445_20494 = state_20443__$1;
(statearr_20445_20494[(1)] = (9));

} else {
var statearr_20446_20495 = state_20443__$1;
(statearr_20446_20495[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (20))){
var state_20443__$1 = state_20443;
var statearr_20447_20496 = state_20443__$1;
(statearr_20447_20496[(2)] = null);

(statearr_20447_20496[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (27))){
var inst_20406 = (state_20443[(8)]);
var state_20443__$1 = state_20443;
var statearr_20448_20497 = state_20443__$1;
(statearr_20448_20497[(2)] = inst_20406);

(statearr_20448_20497[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (1))){
var state_20443__$1 = state_20443;
var statearr_20449_20498 = state_20443__$1;
(statearr_20449_20498[(2)] = null);

(statearr_20449_20498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (24))){
var inst_20429 = (state_20443[(2)]);
var state_20443__$1 = state_20443;
var statearr_20450_20499 = state_20443__$1;
(statearr_20450_20499[(2)] = inst_20429);

(statearr_20450_20499[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (4))){
var inst_20350 = (state_20443[(2)]);
var state_20443__$1 = state_20443;
var statearr_20451_20500 = state_20443__$1;
(statearr_20451_20500[(2)] = inst_20350);

(statearr_20451_20500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (15))){
var inst_20373 = (state_20443[(9)]);
var inst_20379 = (state_20443[(2)]);
var inst_20380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20381 = cljs.core.PersistentVector.EMPTY;
var inst_20382 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20383 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20381,inst_20382);
var inst_20384 = [inst_20373,inst_20383];
var inst_20385 = (new cljs.core.PersistentVector(null,2,(5),inst_20380,inst_20384,null));
var state_20443__$1 = (function (){var statearr_20452 = state_20443;
(statearr_20452[(10)] = inst_20379);

return statearr_20452;
})();
var statearr_20453_20501 = state_20443__$1;
(statearr_20453_20501[(2)] = inst_20385);

(statearr_20453_20501[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (21))){
var inst_20432 = (state_20443[(2)]);
var state_20443__$1 = state_20443;
var statearr_20454_20502 = state_20443__$1;
(statearr_20454_20502[(2)] = inst_20432);

(statearr_20454_20502[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (13))){
var inst_20373 = (state_20443[(9)]);
var inst_20376 = (function(){throw inst_20373})();
var state_20443__$1 = state_20443;
var statearr_20455_20503 = state_20443__$1;
(statearr_20455_20503[(2)] = inst_20376);

(statearr_20455_20503[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (22))){
var inst_20397 = (state_20443[(11)]);
var inst_20395 = (state_20443[(12)]);
var inst_20399 = fluree.db.query.analytical.parse_block_from_source(inst_20395);
var inst_20400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20401 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20397];
var inst_20402 = (new cljs.core.PersistentVector(null,2,(5),inst_20400,inst_20401,null));
var inst_20403 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_20402);
var state_20443__$1 = (function (){var statearr_20456 = state_20443;
(statearr_20456[(13)] = inst_20399);

return statearr_20456;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20443__$1,(25),inst_20403);
} else {
if((state_val_20444 === (29))){
var inst_20410 = (state_20443[(2)]);
var inst_20411 = fluree.db.util.async.throw_err(inst_20410);
var state_20443__$1 = state_20443;
var statearr_20457_20504 = state_20443__$1;
(statearr_20457_20504[(2)] = inst_20411);

(statearr_20457_20504[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (6))){
var inst_20359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20360 = cljs.core.PersistentVector.EMPTY;
var inst_20361 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20362 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20360,inst_20361);
var inst_20363 = [db,inst_20362];
var inst_20364 = (new cljs.core.PersistentVector(null,2,(5),inst_20359,inst_20363,null));
var state_20443__$1 = state_20443;
var statearr_20458_20505 = state_20443__$1;
(statearr_20458_20505[(2)] = inst_20364);

(statearr_20458_20505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (28))){
var inst_20414 = (state_20443[(2)]);
var inst_20415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20416 = cljs.core.PersistentVector.EMPTY;
var inst_20417 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20418 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20416,inst_20417);
var inst_20419 = [inst_20414,inst_20418];
var inst_20420 = (new cljs.core.PersistentVector(null,2,(5),inst_20415,inst_20419,null));
var state_20443__$1 = state_20443;
var statearr_20459_20506 = state_20443__$1;
(statearr_20459_20506[(2)] = inst_20420);

(statearr_20459_20506[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (25))){
var inst_20399 = (state_20443[(13)]);
var inst_20405 = (state_20443[(2)]);
var inst_20406 = fluree.db.util.async.throw_err(inst_20405);
var state_20443__$1 = (function (){var statearr_20460 = state_20443;
(statearr_20460[(8)] = inst_20406);

return statearr_20460;
})();
if(cljs.core.truth_(inst_20399)){
var statearr_20461_20507 = state_20443__$1;
(statearr_20461_20507[(1)] = (26));

} else {
var statearr_20462_20508 = state_20443__$1;
(statearr_20462_20508[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (17))){
var state_20443__$1 = state_20443;
var statearr_20463_20509 = state_20443__$1;
(statearr_20463_20509[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (3))){
var inst_20441 = (state_20443[(2)]);
var state_20443__$1 = state_20443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20443__$1,inst_20441);
} else {
if((state_val_20444 === (12))){
var inst_20373 = (state_20443[(9)]);
var inst_20372 = (state_20443[(2)]);
var inst_20373__$1 = fluree.db.util.async.throw_err(inst_20372);
var inst_20374 = fluree.db.util.core.exception_QMARK_(inst_20373__$1);
var state_20443__$1 = (function (){var statearr_20465 = state_20443;
(statearr_20465[(9)] = inst_20373__$1);

return statearr_20465;
})();
if(inst_20374){
var statearr_20466_20510 = state_20443__$1;
(statearr_20466_20510[(1)] = (13));

} else {
var statearr_20467_20511 = state_20443__$1;
(statearr_20467_20511[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (2))){
var inst_20356 = (state_20443[(7)]);
var _ = (function (){var statearr_20468 = state_20443;
(statearr_20468[(4)] = cljs.core.cons((5),(state_20443[(4)])));

return statearr_20468;
})();
var inst_20356__$1 = cljs.core.first(clause);
var inst_20357 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_20356__$1);
var state_20443__$1 = (function (){var statearr_20469 = state_20443;
(statearr_20469[(7)] = inst_20356__$1);

return statearr_20469;
})();
if(inst_20357){
var statearr_20470_20512 = state_20443__$1;
(statearr_20470_20512[(1)] = (6));

} else {
var statearr_20471_20513 = state_20443__$1;
(statearr_20471_20513[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (23))){
var inst_20356 = (state_20443[(7)]);
var inst_20422 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20356)," is not supported in Fluree"].join('');
var inst_20423 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20424 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20425 = cljs.core.PersistentHashMap.fromArrays(inst_20423,inst_20424);
var inst_20426 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20422,inst_20425);
var inst_20427 = (function(){throw inst_20426})();
var state_20443__$1 = state_20443;
var statearr_20472_20514 = state_20443__$1;
(statearr_20472_20514[(2)] = inst_20427);

(statearr_20472_20514[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (19))){
var inst_20356 = (state_20443[(7)]);
var inst_20397 = (state_20443[(11)]);
var inst_20394 = fluree.db.query.analytical.isolate_source_name(inst_20356);
var inst_20395 = fluree.db.query.analytical.isolate_source_block(inst_20356);
var inst_20396 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_20394);
var inst_20397__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_20396);
var state_20443__$1 = (function (){var statearr_20473 = state_20443;
(statearr_20473[(11)] = inst_20397__$1);

(statearr_20473[(12)] = inst_20395);

return statearr_20473;
})();
if(cljs.core.truth_(inst_20397__$1)){
var statearr_20474_20515 = state_20443__$1;
(statearr_20474_20515[(1)] = (22));

} else {
var statearr_20475_20516 = state_20443__$1;
(statearr_20475_20516[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (11))){
var inst_20436 = (state_20443[(2)]);
var state_20443__$1 = state_20443;
var statearr_20477_20517 = state_20443__$1;
(statearr_20477_20517[(2)] = inst_20436);

(statearr_20477_20517[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (9))){
var inst_20356 = (state_20443[(7)]);
var inst_20368 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_20356,(4));
var inst_20369 = fluree.db.query.analytical.parse_block_from_source(inst_20368);
var inst_20370 = fluree.db.time_travel.as_of_block(db,inst_20369);
var state_20443__$1 = state_20443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20443__$1,(12),inst_20370);
} else {
if((state_val_20444 === (5))){
var _ = (function (){var statearr_20478 = state_20443;
(statearr_20478[(4)] = cljs.core.rest((state_20443[(4)])));

return statearr_20478;
})();
var state_20443__$1 = state_20443;
var ex20476 = (state_20443__$1[(2)]);
var statearr_20479_20518 = state_20443__$1;
(statearr_20479_20518[(5)] = ex20476);


if((ex20476 instanceof Error)){
var statearr_20480_20519 = state_20443__$1;
(statearr_20480_20519[(1)] = (4));

(statearr_20480_20519[(5)] = null);

} else {
throw ex20476;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (14))){
var state_20443__$1 = state_20443;
var statearr_20481_20520 = state_20443__$1;
(statearr_20481_20520[(2)] = null);

(statearr_20481_20520[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (26))){
var inst_20406 = (state_20443[(8)]);
var inst_20399 = (state_20443[(13)]);
var inst_20408 = fluree.db.time_travel.as_of_block(inst_20406,inst_20399);
var state_20443__$1 = state_20443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20443__$1,(29),inst_20408);
} else {
if((state_val_20444 === (16))){
var inst_20389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20390 = ["$wd",clause];
var inst_20391 = (new cljs.core.PersistentVector(null,2,(5),inst_20389,inst_20390,null));
var state_20443__$1 = state_20443;
var statearr_20482_20521 = state_20443__$1;
(statearr_20482_20521[(2)] = inst_20391);

(statearr_20482_20521[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (10))){
var inst_20356 = (state_20443[(7)]);
var inst_20387 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_20356);
var state_20443__$1 = state_20443;
if(inst_20387){
var statearr_20483_20522 = state_20443__$1;
(statearr_20483_20522[(1)] = (16));

} else {
var statearr_20484_20523 = state_20443__$1;
(statearr_20484_20523[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (18))){
var inst_20434 = (state_20443[(2)]);
var state_20443__$1 = state_20443;
var statearr_20485_20524 = state_20443__$1;
(statearr_20485_20524[(2)] = inst_20434);

(statearr_20485_20524[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20444 === (8))){
var inst_20438 = (state_20443[(2)]);
var _ = (function (){var statearr_20486 = state_20443;
(statearr_20486[(4)] = cljs.core.rest((state_20443[(4)])));

return statearr_20486;
})();
var state_20443__$1 = state_20443;
var statearr_20487_20525 = state_20443__$1;
(statearr_20487_20525[(2)] = inst_20438);

(statearr_20487_20525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_20488 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20488[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_20488[(1)] = (1));

return statearr_20488;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_20443){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20443);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20489){var ex__2730__auto__ = e20489;
var statearr_20490_20526 = state_20443;
(statearr_20490_20526[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20443[(4)]))){
var statearr_20491_20527 = state_20443;
(statearr_20491_20527[(1)] = cljs.core.first((state_20443[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20528 = state_20443;
state_20443 = G__20528;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_20443){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_20443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20492 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20492[(6)] = c__2749__auto__);

return statearr_20492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__20529){
var vec__20530 = p__20529;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20530,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20530,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20533_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__20533_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__20537 = subjects;
var vec__20538 = G__20537;
var seq__20539 = cljs.core.seq(vec__20538);
var first__20540 = cljs.core.first(seq__20539);
var seq__20539__$1 = cljs.core.next(seq__20539);
var subject = first__20540;
var r = seq__20539__$1;
var acc = expanded_map;
var G__20537__$1 = G__20537;
var acc__$1 = acc;
while(true){
var vec__20544 = G__20537__$1;
var seq__20545 = cljs.core.seq(vec__20544);
var first__20546 = cljs.core.first(seq__20545);
var seq__20545__$1 = cljs.core.next(seq__20545);
var subject__$1 = first__20546;
var r__$1 = seq__20545__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20547 = r__$1;
var G__20548 = acc__$2;
G__20537__$1 = G__20547;
acc__$1 = G__20548;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__20537__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20544,seq__20545,first__20546,seq__20545__$1,subject__$1,r__$1,acc__$2,G__20537,vec__20538,seq__20539,first__20540,seq__20539__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4253__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20537__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20544,seq__20545,first__20546,seq__20545__$1,subject__$1,r__$1,acc__$2,G__20537,vec__20538,seq__20539,first__20540,seq__20539__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20537__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20544,seq__20545,first__20546,seq__20545__$1,subject__$1,r__$1,acc__$2,G__20537,vec__20538,seq__20539,first__20540,seq__20539__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20537__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20544,seq__20545,first__20546,seq__20545__$1,subject__$1,r__$1,acc__$2,G__20537,vec__20538,seq__20539,first__20540,seq__20539__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20537__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20544,seq__20545,first__20546,seq__20545__$1,subject__$1,r__$1,acc__$2,G__20537,vec__20538,seq__20539,first__20540,seq__20539__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20537__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20544,seq__20545,first__20546,seq__20545__$1,subject__$1,r__$1,acc__$2,G__20537,vec__20538,seq__20539,first__20540,seq__20539__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20549 = r__$1;
var G__20550 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20537__$1 = G__20549;
acc__$1 = G__20550;
continue;
} else {
var G__20551 = subjects;
var G__20552 = acc_STAR_;
G__20537__$1 = G__20551;
acc__$1 = G__20552;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20553_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20553_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20644){
var state_val_20645 = (state_20644[(1)]);
if((state_val_20645 === (7))){
var state_20644__$1 = state_20644;
var statearr_20646_20692 = state_20644__$1;
(statearr_20646_20692[(2)] = (100));

(statearr_20646_20692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (20))){
var inst_20593 = (state_20644[(7)]);
var state_20644__$1 = state_20644;
var statearr_20647_20693 = state_20644__$1;
(statearr_20647_20693[(2)] = inst_20593);

(statearr_20647_20693[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (1))){
var state_20644__$1 = state_20644;
var statearr_20648_20694 = state_20644__$1;
(statearr_20648_20694[(2)] = null);

(statearr_20648_20694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (24))){
var inst_20565 = (state_20644[(8)]);
var inst_20631 = (state_20644[(9)]);
var inst_20632 = (state_20644[(10)]);
var inst_20630 = (state_20644[(11)]);
var inst_20635 = (function (){var max_depth = inst_20565;
var recur_map__$1 = inst_20631;
var subjects = inst_20630;
var tuples = inst_20632;
return (function (p1__20554_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__20554_SHARP_)],null));
});
})();
var inst_20636 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20635,inst_20632);
var inst_20637 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_20636);
var state_20644__$1 = state_20644;
var statearr_20649_20695 = state_20644__$1;
(statearr_20649_20695[(2)] = inst_20637);

(statearr_20649_20695[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (4))){
var inst_20555 = (state_20644[(2)]);
var state_20644__$1 = state_20644;
var statearr_20650_20696 = state_20644__$1;
(statearr_20650_20696[(2)] = inst_20555);

(statearr_20650_20696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (15))){
var inst_20578 = (state_20644[(12)]);
var inst_20589 = cljs.core.PersistentVector.EMPTY;
var inst_20590 = cljs.core.seq(inst_20578);
var inst_20591 = cljs.core.first(inst_20590);
var inst_20592 = cljs.core.next(inst_20590);
var inst_20593 = inst_20589;
var inst_20594 = inst_20578;
var state_20644__$1 = (function (){var statearr_20651 = state_20644;
(statearr_20651[(7)] = inst_20593);

(statearr_20651[(13)] = inst_20592);

(statearr_20651[(14)] = inst_20591);

(statearr_20651[(15)] = inst_20594);

return statearr_20651;
})();
var statearr_20652_20697 = state_20644__$1;
(statearr_20652_20697[(2)] = null);

(statearr_20652_20697[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (21))){
var inst_20614 = (state_20644[(2)]);
var state_20644__$1 = state_20644;
var statearr_20653_20698 = state_20644__$1;
(statearr_20653_20698[(2)] = inst_20614);

(statearr_20653_20698[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (13))){
var inst_20627 = (state_20644[(2)]);
var state_20644__$1 = state_20644;
var statearr_20654_20699 = state_20644__$1;
(statearr_20654_20699[(2)] = inst_20627);

(statearr_20654_20699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (22))){
var inst_20593 = (state_20644[(7)]);
var inst_20601 = (state_20644[(16)]);
var inst_20608 = (state_20644[(2)]);
var inst_20609 = fluree.db.util.async.throw_err(inst_20608);
var inst_20610 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_20593,inst_20609);
var inst_20593__$1 = inst_20610;
var inst_20594 = inst_20601;
var state_20644__$1 = (function (){var statearr_20655 = state_20644;
(statearr_20655[(7)] = inst_20593__$1);

(statearr_20655[(15)] = inst_20594);

return statearr_20655;
})();
var statearr_20656_20700 = state_20644__$1;
(statearr_20656_20700[(2)] = null);

(statearr_20656_20700[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (6))){
var inst_20561 = (state_20644[(17)]);
var state_20644__$1 = state_20644;
var statearr_20657_20701 = state_20644__$1;
(statearr_20657_20701[(2)] = inst_20561);

(statearr_20657_20701[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (25))){
var inst_20639 = (state_20644[(2)]);
var _ = (function (){var statearr_20658 = state_20644;
(statearr_20658[(4)] = cljs.core.rest((state_20644[(4)])));

return statearr_20658;
})();
var state_20644__$1 = state_20644;
var statearr_20659_20702 = state_20644__$1;
(statearr_20659_20702[(2)] = inst_20639);

(statearr_20659_20702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (17))){
var inst_20594 = (state_20644[(15)]);
var inst_20600 = (state_20644[(18)]);
var inst_20599 = cljs.core.seq(inst_20594);
var inst_20600__$1 = cljs.core.first(inst_20599);
var inst_20601 = cljs.core.next(inst_20599);
var state_20644__$1 = (function (){var statearr_20660 = state_20644;
(statearr_20660[(18)] = inst_20600__$1);

(statearr_20660[(16)] = inst_20601);

return statearr_20660;
})();
if(cljs.core.truth_(inst_20600__$1)){
var statearr_20661_20703 = state_20644__$1;
(statearr_20661_20703[(1)] = (19));

} else {
var statearr_20662_20704 = state_20644__$1;
(statearr_20662_20704[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (3))){
var inst_20642 = (state_20644[(2)]);
var state_20644__$1 = state_20644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20644__$1,inst_20642);
} else {
if((state_val_20645 === (12))){
var inst_20567 = (state_20644[(19)]);
var inst_20578 = (state_20644[(12)]);
var inst_20573 = cljs.core.vals(inst_20567);
var inst_20574 = cljs.core.flatten(inst_20573);
var inst_20575 = cljs.core.set(inst_20574);
var inst_20576 = cljs.core.keys(inst_20567);
var inst_20577 = cljs.core.set(inst_20576);
var inst_20578__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_20575,inst_20577);
var inst_20579 = cljs.core.empty_QMARK_(inst_20578__$1);
var state_20644__$1 = (function (){var statearr_20663 = state_20644;
(statearr_20663[(12)] = inst_20578__$1);

return statearr_20663;
})();
if(inst_20579){
var statearr_20664_20705 = state_20644__$1;
(statearr_20664_20705[(1)] = (14));

} else {
var statearr_20665_20706 = state_20644__$1;
(statearr_20665_20706[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (2))){
var inst_20561 = (state_20644[(17)]);
var _ = (function (){var statearr_20666 = state_20644;
(statearr_20666[(4)] = cljs.core.cons((5),(state_20644[(4)])));

return statearr_20666;
})();
var inst_20561__$1 = depth;
var state_20644__$1 = (function (){var statearr_20667 = state_20644;
(statearr_20667[(17)] = inst_20561__$1);

return statearr_20667;
})();
if(cljs.core.truth_(inst_20561__$1)){
var statearr_20668_20707 = state_20644__$1;
(statearr_20668_20707[(1)] = (6));

} else {
var statearr_20669_20708 = state_20644__$1;
(statearr_20669_20708[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (23))){
var inst_20632 = (state_20644[(10)]);
var state_20644__$1 = state_20644;
var statearr_20670_20709 = state_20644__$1;
(statearr_20670_20709[(2)] = inst_20632);

(statearr_20670_20709[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (19))){
var inst_20600 = (state_20644[(18)]);
var inst_20603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20604 = [inst_20600,predicate];
var inst_20605 = (new cljs.core.PersistentVector(null,2,(5),inst_20603,inst_20604,null));
var inst_20606 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20605);
var state_20644__$1 = state_20644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20644__$1,(22),inst_20606);
} else {
if((state_val_20645 === (11))){
var inst_20567 = (state_20644[(19)]);
var state_20644__$1 = state_20644;
var statearr_20672_20710 = state_20644__$1;
(statearr_20672_20710[(2)] = inst_20567);

(statearr_20672_20710[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (9))){
var inst_20565 = (state_20644[(8)]);
var inst_20568 = (state_20644[(20)]);
var inst_20570 = (inst_20568 >= inst_20565);
var state_20644__$1 = state_20644;
if(cljs.core.truth_(inst_20570)){
var statearr_20673_20711 = state_20644__$1;
(statearr_20673_20711[(1)] = (11));

} else {
var statearr_20674_20712 = state_20644__$1;
(statearr_20674_20712[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (5))){
var _ = (function (){var statearr_20675 = state_20644;
(statearr_20675[(4)] = cljs.core.rest((state_20644[(4)])));

return statearr_20675;
})();
var state_20644__$1 = state_20644;
var ex20671 = (state_20644__$1[(2)]);
var statearr_20676_20713 = state_20644__$1;
(statearr_20676_20713[(5)] = ex20671);


if((ex20671 instanceof Error)){
var statearr_20677_20714 = state_20644__$1;
(statearr_20677_20714[(1)] = (4));

(statearr_20677_20714[(5)] = null);

} else {
throw ex20671;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (14))){
var inst_20567 = (state_20644[(19)]);
var state_20644__$1 = state_20644;
var statearr_20678_20715 = state_20644__$1;
(statearr_20678_20715[(2)] = inst_20567);

(statearr_20678_20715[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (16))){
var inst_20625 = (state_20644[(2)]);
var state_20644__$1 = state_20644;
var statearr_20679_20716 = state_20644__$1;
(statearr_20679_20716[(2)] = inst_20625);

(statearr_20679_20716[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (10))){
var inst_20631 = (state_20644[(9)]);
var inst_20630 = (state_20644[(11)]);
var inst_20629 = (state_20644[(2)]);
var inst_20630__$1 = cljs.core.keys(inst_20629);
var inst_20631__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_20630__$1,inst_20629);
var inst_20632 = fluree.db.query.analytical.recur_map__GT_tuples(inst_20630__$1,inst_20631__$1);
var state_20644__$1 = (function (){var statearr_20680 = state_20644;
(statearr_20680[(9)] = inst_20631__$1);

(statearr_20680[(10)] = inst_20632);

(statearr_20680[(11)] = inst_20630__$1);

return statearr_20680;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20681_20717 = state_20644__$1;
(statearr_20681_20717[(1)] = (23));

} else {
var statearr_20682_20718 = state_20644__$1;
(statearr_20682_20718[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (18))){
var inst_20567 = (state_20644[(19)]);
var inst_20568 = (state_20644[(20)]);
var inst_20616 = (state_20644[(2)]);
var inst_20617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20618 = [(0),(2)];
var inst_20619 = (new cljs.core.PersistentVector(null,2,(5),inst_20617,inst_20618,null));
var inst_20620 = fluree.db.query.analytical.get_ns_arrays(inst_20619,inst_20616);
var inst_20621 = fluree.db.query.analytical.tuples__GT_map(inst_20567,inst_20620);
var inst_20622 = (inst_20568 + (1));
var inst_20567__$1 = inst_20621;
var inst_20568__$1 = inst_20622;
var state_20644__$1 = (function (){var statearr_20683 = state_20644;
(statearr_20683[(19)] = inst_20567__$1);

(statearr_20683[(20)] = inst_20568__$1);

return statearr_20683;
})();
var statearr_20684_20719 = state_20644__$1;
(statearr_20684_20719[(2)] = null);

(statearr_20684_20719[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20645 === (8))){
var inst_20565 = (state_20644[(2)]);
var inst_20566 = recur_map;
var inst_20567 = inst_20566;
var inst_20568 = (1);
var state_20644__$1 = (function (){var statearr_20685 = state_20644;
(statearr_20685[(8)] = inst_20565);

(statearr_20685[(19)] = inst_20567);

(statearr_20685[(20)] = inst_20568);

return statearr_20685;
})();
var statearr_20686_20720 = state_20644__$1;
(statearr_20686_20720[(2)] = null);

(statearr_20686_20720[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_20687 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20687[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__);

(statearr_20687[(1)] = (1));

return statearr_20687;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1 = (function (state_20644){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20644);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20688){var ex__2730__auto__ = e20688;
var statearr_20689_20721 = state_20644;
(statearr_20689_20721[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20644[(4)]))){
var statearr_20690_20722 = state_20644;
(statearr_20690_20722[(1)] = cljs.core.first((state_20644[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20723 = state_20644;
state_20644 = G__20723;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = function(state_20644){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1.call(this,state_20644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20691 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20691[(6)] = c__2749__auto__);

return statearr_20691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20724,clause,fuel,max_fuel){
var map__20725 = p__20724;
var map__20725__$1 = cljs.core.__destructure_map(map__20725);
var res = map__20725__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20725__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20725__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20725__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20836){
var state_val_20837 = (state_20836[(1)]);
if((state_val_20837 === (7))){
var inst_20742 = (state_20836[(7)]);
var state_20836__$1 = state_20836;
var statearr_20838_20891 = state_20836__$1;
(statearr_20838_20891[(2)] = inst_20742);

(statearr_20838_20891[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (20))){
var inst_20770 = (state_20836[(8)]);
var inst_20801 = typeof inst_20770 === 'number';
var state_20836__$1 = state_20836;
if(cljs.core.truth_(inst_20801)){
var statearr_20839_20892 = state_20836__$1;
(statearr_20839_20892[(1)] = (22));

} else {
var statearr_20840_20893 = state_20836__$1;
(statearr_20840_20893[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (27))){
var inst_20816 = (state_20836[(2)]);
var state_20836__$1 = state_20836;
var statearr_20841_20894 = state_20836__$1;
(statearr_20841_20894[(2)] = inst_20816);

(statearr_20841_20894[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (1))){
var state_20836__$1 = state_20836;
var statearr_20842_20895 = state_20836__$1;
(statearr_20842_20895[(2)] = null);

(statearr_20842_20895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (24))){
var inst_20818 = (state_20836[(2)]);
var state_20836__$1 = state_20836;
var statearr_20843_20896 = state_20836__$1;
(statearr_20843_20896[(2)] = inst_20818);

(statearr_20843_20896[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (4))){
var inst_20726 = (state_20836[(2)]);
var state_20836__$1 = state_20836;
var statearr_20844_20897 = state_20836__$1;
(statearr_20844_20897[(2)] = inst_20726);

(statearr_20844_20897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (15))){
var inst_20784 = (state_20836[(2)]);
var inst_20785 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_20786 = fluree.db.query.analytical.variable_QMARK_(inst_20785);
var state_20836__$1 = (function (){var statearr_20845 = state_20836;
(statearr_20845[(9)] = inst_20784);

return statearr_20845;
})();
if(cljs.core.truth_(inst_20786)){
var statearr_20846_20898 = state_20836__$1;
(statearr_20846_20898[(1)] = (16));

} else {
var statearr_20847_20899 = state_20836__$1;
(statearr_20847_20899[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (21))){
var inst_20772 = (state_20836[(10)]);
var inst_20773 = (state_20836[(11)]);
var inst_20743 = (state_20836[(12)]);
var inst_20820 = (state_20836[(2)]);
var inst_20821 = fluree.db.query.analytical.tuples__GT_recur(db,inst_20773,inst_20820,inst_20743,inst_20772);
var state_20836__$1 = state_20836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20836__$1,(28),inst_20821);
} else {
if((state_val_20837 === (13))){
var inst_20752 = (state_20836[(13)]);
var inst_20776 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20752)].join('');
var inst_20777 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20778 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20779 = cljs.core.PersistentHashMap.fromArrays(inst_20777,inst_20778);
var inst_20780 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20776,inst_20779);
var inst_20781 = (function(){throw inst_20780})();
var state_20836__$1 = state_20836;
var statearr_20848_20900 = state_20836__$1;
(statearr_20848_20900[(2)] = inst_20781);

(statearr_20848_20900[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (22))){
var inst_20768 = (state_20836[(14)]);
var inst_20770 = (state_20836[(8)]);
var inst_20803 = cljs.core.PersistentHashMap.EMPTY;
var inst_20804 = cljs.core.flatten(inst_20768);
var inst_20805 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20803,inst_20770,inst_20804);
var state_20836__$1 = state_20836;
var statearr_20849_20901 = state_20836__$1;
(statearr_20849_20901[(2)] = inst_20805);

(statearr_20849_20901[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (6))){
var inst_20754 = (state_20836[(15)]);
var state_20836__$1 = state_20836;
var statearr_20850_20902 = state_20836__$1;
(statearr_20850_20902[(2)] = inst_20754);

(statearr_20850_20902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (28))){
var inst_20823 = (state_20836[(2)]);
var inst_20824 = fluree.db.util.async.throw_err(inst_20823);
var state_20836__$1 = state_20836;
var statearr_20851_20903 = state_20836__$1;
(statearr_20851_20903[(2)] = inst_20824);

(statearr_20851_20903[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (25))){
var inst_20768 = (state_20836[(14)]);
var inst_20764 = (state_20836[(16)]);
var inst_20809 = cljs.core.PersistentHashMap.EMPTY;
var inst_20810 = cljs.core.first(inst_20764);
var inst_20811 = cljs.core.first(inst_20810);
var inst_20812 = cljs.core.flatten(inst_20768);
var inst_20813 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20809,inst_20811,inst_20812);
var state_20836__$1 = state_20836;
var statearr_20852_20904 = state_20836__$1;
(statearr_20852_20904[(2)] = inst_20813);

(statearr_20852_20904[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (17))){
var inst_20752 = (state_20836[(13)]);
var inst_20789 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20752)].join('');
var inst_20790 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20791 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20792 = cljs.core.PersistentHashMap.fromArrays(inst_20790,inst_20791);
var inst_20793 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20789,inst_20792);
var inst_20794 = (function(){throw inst_20793})();
var state_20836__$1 = state_20836;
var statearr_20853_20905 = state_20836__$1;
(statearr_20853_20905[(2)] = inst_20794);

(statearr_20853_20905[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (3))){
var inst_20834 = (state_20836[(2)]);
var state_20836__$1 = state_20836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20836__$1,inst_20834);
} else {
if((state_val_20837 === (12))){
var inst_20739 = (state_20836[(17)]);
var inst_20827 = (state_20836[(2)]);
var inst_20828 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20829 = cljs.core.keys(inst_20739);
var inst_20830 = [inst_20829,vars,inst_20827];
var inst_20831 = cljs.core.PersistentHashMap.fromArrays(inst_20828,inst_20830);
var _ = (function (){var statearr_20854 = state_20836;
(statearr_20854[(4)] = cljs.core.rest((state_20836[(4)])));

return statearr_20854;
})();
var state_20836__$1 = state_20836;
var statearr_20855_20906 = state_20836__$1;
(statearr_20855_20906[(2)] = inst_20831);

(statearr_20855_20906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (2))){
var inst_20739 = (state_20836[(17)]);
var inst_20754 = (state_20836[(15)]);
var inst_20742 = (state_20836[(7)]);
var inst_20743 = (state_20836[(12)]);
var _ = (function (){var statearr_20856 = state_20836;
(statearr_20856[(4)] = cljs.core.cons((5),(state_20836[(4)])));

return statearr_20856;
})();
var inst_20736 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_20737 = cljs.core.__destructure_map(inst_20736);
var inst_20738 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20737,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20739__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20737,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20740 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20737,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20741 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_20742__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20740);
var inst_20743__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20740);
var inst_20745 = (function (){var map__20732 = inst_20737;
var search = inst_20738;
var rel = inst_20739__$1;
var opts = inst_20740;
var common_keys = inst_20741;
var object_fn = inst_20742__$1;
var recur_depth = inst_20743__$1;
return (function (p__20744,common_key){
var vec__20857 = p__20744;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20857,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20857,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20860 = cljs.core._EQ_;
var expr__20861 = idx_of;
if(cljs.core.truth_((pred__20860.cljs$core$IFn$_invoke$arity$2 ? pred__20860.cljs$core$IFn$_invoke$arity$2((0),expr__20861) : pred__20860.call(null,(0),expr__20861)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__20860.cljs$core$IFn$_invoke$arity$2 ? pred__20860.cljs$core$IFn$_invoke$arity$2((1),expr__20861) : pred__20860.call(null,(1),expr__20861)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__20860.cljs$core$IFn$_invoke$arity$2 ? pred__20860.cljs$core$IFn$_invoke$arity$2((2),expr__20861) : pred__20860.call(null,(2),expr__20861)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20861)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4251__auto__ = (!(single_v_QMARK_));
if(and__4251__auto__){
var and__4251__auto____$1 = object_fn;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20747 = cljs.core.PersistentHashMap.EMPTY;
var inst_20748 = [inst_20747,inst_20738];
var inst_20749 = (new cljs.core.PersistentVector(null,2,(5),inst_20746,inst_20748,null));
var inst_20750 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20745,inst_20749,inst_20741);
var inst_20751 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20750,(0),null);
var inst_20752 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20750,(1),null);
var inst_20753 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20754__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20751);
var state_20836__$1 = (function (){var statearr_20863 = state_20836;
(statearr_20863[(17)] = inst_20739__$1);

(statearr_20863[(18)] = inst_20753);

(statearr_20863[(15)] = inst_20754__$1);

(statearr_20863[(13)] = inst_20752);

(statearr_20863[(7)] = inst_20742__$1);

(statearr_20863[(12)] = inst_20743__$1);

return statearr_20863;
})();
if(cljs.core.truth_(inst_20754__$1)){
var statearr_20864_20907 = state_20836__$1;
(statearr_20864_20907[(1)] = (6));

} else {
var statearr_20865_20908 = state_20836__$1;
(statearr_20865_20908[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (23))){
var inst_20770 = (state_20836[(8)]);
var inst_20807 = cljs.core.coll_QMARK_(inst_20770);
var state_20836__$1 = state_20836;
if(inst_20807){
var statearr_20866_20909 = state_20836__$1;
(statearr_20866_20909[(1)] = (25));

} else {
var statearr_20867_20910 = state_20836__$1;
(statearr_20867_20910[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (19))){
var inst_20768 = (state_20836[(14)]);
var inst_20798 = cljs.core.PersistentHashMap.EMPTY;
var inst_20799 = fluree.db.query.analytical.tuples__GT_map(inst_20798,inst_20768);
var state_20836__$1 = state_20836;
var statearr_20868_20911 = state_20836__$1;
(statearr_20868_20911[(2)] = inst_20799);

(statearr_20868_20911[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (11))){
var inst_20768 = (state_20836[(14)]);
var state_20836__$1 = state_20836;
var statearr_20870_20912 = state_20836__$1;
(statearr_20870_20912[(2)] = inst_20768);

(statearr_20870_20912[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (9))){
var inst_20739 = (state_20836[(17)]);
var inst_20764 = (state_20836[(16)]);
var inst_20743 = (state_20836[(12)]);
var inst_20763 = (state_20836[(2)]);
var inst_20764__$1 = fluree.db.util.async.throw_err(inst_20763);
var inst_20765 = cljs.core.count(inst_20764__$1);
var inst_20766 = fluree.db.query.analytical.add_fuel(inst_20765,fuel,max_fuel);
var inst_20767 = cljs.core.vals(inst_20739);
var inst_20768 = fluree.db.query.analytical.get_ns_arrays(inst_20767,inst_20764__$1);
var state_20836__$1 = (function (){var statearr_20871 = state_20836;
(statearr_20871[(19)] = inst_20766);

(statearr_20871[(14)] = inst_20768);

(statearr_20871[(16)] = inst_20764__$1);

return statearr_20871;
})();
if(cljs.core.truth_(inst_20743)){
var statearr_20872_20913 = state_20836__$1;
(statearr_20872_20913[(1)] = (10));

} else {
var statearr_20873_20914 = state_20836__$1;
(statearr_20873_20914[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (5))){
var _ = (function (){var statearr_20874 = state_20836;
(statearr_20874[(4)] = cljs.core.rest((state_20836[(4)])));

return statearr_20874;
})();
var state_20836__$1 = state_20836;
var ex20869 = (state_20836__$1[(2)]);
var statearr_20875_20915 = state_20836__$1;
(statearr_20875_20915[(5)] = ex20869);


if((ex20869 instanceof Error)){
var statearr_20876_20916 = state_20836__$1;
(statearr_20876_20916[(1)] = (4));

(statearr_20876_20916[(5)] = null);

} else {
throw ex20869;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (14))){
var state_20836__$1 = state_20836;
var statearr_20877_20917 = state_20836__$1;
(statearr_20877_20917[(2)] = null);

(statearr_20877_20917[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (26))){
var state_20836__$1 = state_20836;
var statearr_20878_20918 = state_20836__$1;
(statearr_20878_20918[(2)] = null);

(statearr_20878_20918[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (16))){
var state_20836__$1 = state_20836;
var statearr_20879_20919 = state_20836__$1;
(statearr_20879_20919[(2)] = null);

(statearr_20879_20919[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (10))){
var inst_20773 = (state_20836[(11)]);
var inst_20752 = (state_20836[(13)]);
var inst_20770 = cljs.core.first(inst_20752);
var inst_20771 = cljs.core.first(clause);
var inst_20772 = fluree.db.query.analytical.variable_QMARK_(inst_20771);
var inst_20773__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_20752,(1));
var inst_20774 = fluree.db.query.analytical.variable_QMARK_(inst_20773__$1);
var state_20836__$1 = (function (){var statearr_20880 = state_20836;
(statearr_20880[(10)] = inst_20772);

(statearr_20880[(11)] = inst_20773__$1);

(statearr_20880[(8)] = inst_20770);

return statearr_20880;
})();
if(cljs.core.truth_(inst_20774)){
var statearr_20881_20920 = state_20836__$1;
(statearr_20881_20920[(1)] = (13));

} else {
var statearr_20882_20921 = state_20836__$1;
(statearr_20882_20921[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (18))){
var inst_20772 = (state_20836[(10)]);
var inst_20796 = (state_20836[(2)]);
var state_20836__$1 = (function (){var statearr_20883 = state_20836;
(statearr_20883[(20)] = inst_20796);

return statearr_20883;
})();
if(cljs.core.truth_(inst_20772)){
var statearr_20884_20922 = state_20836__$1;
(statearr_20884_20922[(1)] = (19));

} else {
var statearr_20885_20923 = state_20836__$1;
(statearr_20885_20923[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20837 === (8))){
var inst_20753 = (state_20836[(18)]);
var inst_20752 = (state_20836[(13)]);
var inst_20758 = (state_20836[(2)]);
var inst_20759 = [inst_20758];
var inst_20760 = cljs.core.PersistentHashMap.fromArrays(inst_20753,inst_20759);
var inst_20761 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_20752,inst_20760);
var state_20836__$1 = state_20836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20836__$1,(9),inst_20761);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20886 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20886[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_20886[(1)] = (1));

return statearr_20886;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_20836){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20836);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20887){var ex__2730__auto__ = e20887;
var statearr_20888_20924 = state_20836;
(statearr_20888_20924[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20836[(4)]))){
var statearr_20889_20925 = state_20836;
(statearr_20889_20925[(1)] = cljs.core.first((state_20836[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20926 = state_20836;
state_20836 = G__20926;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = function(state_20836){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_20836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20890 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20890[(6)] = c__2749__auto__);

return statearr_20890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20927,res,clause){
var map__20928 = p__20927;
var map__20928__$1 = cljs.core.__destructure_map(map__20928);
var db = map__20928__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20928__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20928__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20928__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21037){
var state_val_21038 = (state_21037[(1)]);
if((state_val_21038 === (7))){
var inst_20937 = (state_21037[(7)]);
var state_21037__$1 = state_21037;
var statearr_21039_21080 = state_21037__$1;
(statearr_21039_21080[(2)] = inst_20937);

(statearr_21039_21080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (20))){
var state_21037__$1 = state_21037;
var statearr_21040_21081 = state_21037__$1;
(statearr_21040_21081[(2)] = null);

(statearr_21040_21081[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (1))){
var state_21037__$1 = state_21037;
var statearr_21041_21082 = state_21037__$1;
(statearr_21041_21082[(2)] = null);

(statearr_21041_21082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (24))){
var inst_20939 = (state_21037[(8)]);
var inst_21010 = (state_21037[(2)]);
var inst_21011 = fluree.db.flake.sid__GT_cid(inst_21010);
var inst_21012 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_21011);
var inst_21013 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21015 = [inst_20939];
var inst_21016 = (new cljs.core.PersistentVector(null,1,(5),inst_21014,inst_21015,null));
var inst_21017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21019 = [inst_21012];
var inst_21020 = (new cljs.core.PersistentVector(null,1,(5),inst_21018,inst_21019,null));
var inst_21021 = [inst_21020];
var inst_21022 = (new cljs.core.PersistentVector(null,1,(5),inst_21017,inst_21021,null));
var inst_21023 = cljs.core.PersistentHashMap.EMPTY;
var inst_21024 = [inst_21016,inst_21022,inst_21023];
var inst_21025 = cljs.core.PersistentHashMap.fromArrays(inst_21013,inst_21024);
var state_21037__$1 = state_21037;
var statearr_21042_21083 = state_21037__$1;
(statearr_21042_21083[(2)] = inst_21025);

(statearr_21042_21083[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (4))){
var inst_20930 = (state_21037[(2)]);
var state_21037__$1 = state_21037;
var statearr_21043_21084 = state_21037__$1;
(statearr_21043_21084[(2)] = inst_20930);

(statearr_21043_21084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (15))){
var inst_20939 = (state_21037[(8)]);
var inst_20937 = (state_21037[(7)]);
var inst_20958 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20959 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20961 = [inst_20937];
var inst_20962 = (new cljs.core.PersistentVector(null,1,(5),inst_20960,inst_20961,null));
var inst_20963 = (function (){var subject_var = inst_20937;
var object_var = inst_20939;
var min_sid = inst_20958;
var max_sid = (0);
return (function (p1__20929_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20929_SHARP_);
});
})();
var inst_20964 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20958,(0));
var inst_20965 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20963,inst_20964);
var inst_20966 = cljs.core.PersistentHashMap.EMPTY;
var inst_20967 = [inst_20962,inst_20965,inst_20966];
var inst_20968 = cljs.core.PersistentHashMap.fromArrays(inst_20959,inst_20967);
var state_21037__$1 = state_21037;
var statearr_21044_21085 = state_21037__$1;
(statearr_21044_21085[(2)] = inst_20968);

(statearr_21044_21085[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (21))){
var inst_21028 = (state_21037[(2)]);
var state_21037__$1 = state_21037;
var statearr_21045_21086 = state_21037__$1;
(statearr_21045_21086[(2)] = inst_21028);

(statearr_21045_21086[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (13))){
var inst_20939 = (state_21037[(8)]);
var state_21037__$1 = state_21037;
if(cljs.core.truth_(inst_20939)){
var statearr_21046_21087 = state_21037__$1;
(statearr_21046_21087[(1)] = (19));

} else {
var statearr_21047_21088 = state_21037__$1;
(statearr_21047_21088[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (22))){
var inst_21001 = (state_21037[(9)]);
var state_21037__$1 = state_21037;
var statearr_21048_21089 = state_21037__$1;
(statearr_21048_21089[(2)] = inst_21001);

(statearr_21048_21089[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (6))){
var inst_20939 = (state_21037[(8)]);
var state_21037__$1 = state_21037;
var statearr_21049_21090 = state_21037__$1;
(statearr_21049_21090[(2)] = inst_20939);

(statearr_21049_21090[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (25))){
var inst_21007 = (state_21037[(2)]);
var inst_21008 = fluree.db.util.async.throw_err(inst_21007);
var state_21037__$1 = state_21037;
var statearr_21050_21091 = state_21037__$1;
(statearr_21050_21091[(2)] = inst_21008);

(statearr_21050_21091[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (17))){
var inst_20998 = (state_21037[(2)]);
var state_21037__$1 = state_21037;
var statearr_21051_21092 = state_21037__$1;
(statearr_21051_21092[(2)] = inst_20998);

(statearr_21051_21092[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (3))){
var inst_21035 = (state_21037[(2)]);
var state_21037__$1 = state_21037;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21037__$1,inst_21035);
} else {
if((state_val_21038 === (12))){
var inst_20952 = ["_tx",null,"_block",null];
var inst_20953 = (new cljs.core.PersistentArrayMap(null,2,inst_20952,null));
var inst_20954 = (new cljs.core.PersistentHashSet(null,inst_20953,null));
var inst_20955 = cljs.core.last(clause);
var inst_20956 = (inst_20954.cljs$core$IFn$_invoke$arity$1 ? inst_20954.cljs$core$IFn$_invoke$arity$1(inst_20955) : inst_20954.call(null,inst_20955));
var state_21037__$1 = state_21037;
if(cljs.core.truth_(inst_20956)){
var statearr_21052_21093 = state_21037__$1;
(statearr_21052_21093[(1)] = (15));

} else {
var statearr_21053_21094 = state_21037__$1;
(statearr_21053_21094[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (2))){
var inst_20937 = (state_21037[(7)]);
var _ = (function (){var statearr_21054 = state_21037;
(statearr_21054[(4)] = cljs.core.cons((5),(state_21037[(4)])));

return statearr_21054;
})();
var inst_20936 = cljs.core.first(clause);
var inst_20937__$1 = fluree.db.query.analytical.variable_QMARK_(inst_20936);
var inst_20938 = cljs.core.last(clause);
var inst_20939 = fluree.db.query.analytical.variable_QMARK_(inst_20938);
var state_21037__$1 = (function (){var statearr_21055 = state_21037;
(statearr_21055[(8)] = inst_20939);

(statearr_21055[(7)] = inst_20937__$1);

return statearr_21055;
})();
if(cljs.core.truth_(inst_20937__$1)){
var statearr_21056_21095 = state_21037__$1;
(statearr_21056_21095[(1)] = (6));

} else {
var statearr_21057_21096 = state_21037__$1;
(statearr_21057_21096[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (23))){
var inst_21001 = (state_21037[(9)]);
var inst_21005 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_21001);
var state_21037__$1 = state_21037;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21037__$1,(25),inst_21005);
} else {
if((state_val_21038 === (19))){
var inst_21001 = (state_21037[(9)]);
var inst_21001__$1 = cljs.core.first(clause);
var inst_21002 = typeof inst_21001__$1 === 'number';
var state_21037__$1 = (function (){var statearr_21058 = state_21037;
(statearr_21058[(9)] = inst_21001__$1);

return statearr_21058;
})();
if(cljs.core.truth_(inst_21002)){
var statearr_21059_21097 = state_21037__$1;
(statearr_21059_21097[(1)] = (22));

} else {
var statearr_21060_21098 = state_21037__$1;
(statearr_21060_21098[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (11))){
var inst_21032 = (state_21037[(2)]);
var _ = (function (){var statearr_21062 = state_21037;
(statearr_21062[(4)] = cljs.core.rest((state_21037[(4)])));

return statearr_21062;
})();
var state_21037__$1 = state_21037;
var statearr_21063_21099 = state_21037__$1;
(statearr_21063_21099[(2)] = inst_21032);

(statearr_21063_21099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (9))){
var inst_20945 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20946 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20947 = cljs.core.PersistentHashMap.fromArrays(inst_20945,inst_20946);
var inst_20948 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_20947);
var inst_20949 = (function(){throw inst_20948})();
var state_21037__$1 = state_21037;
var statearr_21064_21100 = state_21037__$1;
(statearr_21064_21100[(2)] = inst_20949);

(statearr_21064_21100[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (5))){
var _ = (function (){var statearr_21065 = state_21037;
(statearr_21065[(4)] = cljs.core.rest((state_21037[(4)])));

return statearr_21065;
})();
var state_21037__$1 = state_21037;
var ex21061 = (state_21037__$1[(2)]);
var statearr_21066_21101 = state_21037__$1;
(statearr_21066_21101[(5)] = ex21061);


if((ex21061 instanceof Error)){
var statearr_21067_21102 = state_21037__$1;
(statearr_21067_21102[(1)] = (4));

(statearr_21067_21102[(5)] = null);

} else {
throw ex21061;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (14))){
var inst_21030 = (state_21037[(2)]);
var state_21037__$1 = state_21037;
var statearr_21068_21103 = state_21037__$1;
(statearr_21068_21103[(2)] = inst_21030);

(statearr_21068_21103[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (16))){
var inst_20974 = (state_21037[(10)]);
var inst_20973 = (state_21037[(11)]);
var inst_20971 = (state_21037[(12)]);
var inst_20970 = cljs.core.last(clause);
var inst_20971__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20970);
var inst_20972 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20973__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20972,inst_20971__$1);
var inst_20974__$1 = fluree.db.flake.min_subject_id(inst_20971__$1);
var inst_20975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20976 = [inst_20973__$1];
var inst_20977 = (new cljs.core.PersistentVector(null,1,(5),inst_20975,inst_20976,null));
var inst_20978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20979 = [inst_20974__$1];
var inst_20980 = (new cljs.core.PersistentVector(null,1,(5),inst_20978,inst_20979,null));
var inst_20981 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20977,cljs.core._LT__EQ_,inst_20980);
var state_21037__$1 = (function (){var statearr_21069 = state_21037;
(statearr_21069[(10)] = inst_20974__$1);

(statearr_21069[(11)] = inst_20973__$1);

(statearr_21069[(12)] = inst_20971__$1);

return statearr_21069;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21037__$1,(18),inst_20981);
} else {
if((state_val_21038 === (10))){
var inst_20937 = (state_21037[(7)]);
var state_21037__$1 = state_21037;
if(cljs.core.truth_(inst_20937)){
var statearr_21070_21104 = state_21037__$1;
(statearr_21070_21104[(1)] = (12));

} else {
var statearr_21071_21105 = state_21037__$1;
(statearr_21071_21105[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (18))){
var inst_20974 = (state_21037[(10)]);
var inst_20973 = (state_21037[(11)]);
var inst_20939 = (state_21037[(8)]);
var inst_20971 = (state_21037[(12)]);
var inst_20937 = (state_21037[(7)]);
var inst_20983 = (state_21037[(2)]);
var inst_20984 = fluree.db.util.async.throw_err(inst_20983);
var inst_20985 = (function (){var subject_var = inst_20937;
var object_var = inst_20939;
var partition = inst_20971;
var max_sid = inst_20973;
var min_sid = inst_20974;
var flakes = inst_20984;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20986 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_20985);
var inst_20987 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_20988 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_20986,inst_20987);
var inst_20989 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20991 = [inst_20937];
var inst_20992 = (new cljs.core.PersistentVector(null,1,(5),inst_20990,inst_20991,null));
var inst_20993 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_20988,inst_20984);
var inst_20994 = cljs.core.PersistentHashMap.EMPTY;
var inst_20995 = [inst_20992,inst_20993,inst_20994];
var inst_20996 = cljs.core.PersistentHashMap.fromArrays(inst_20989,inst_20995);
var state_21037__$1 = state_21037;
var statearr_21072_21106 = state_21037__$1;
(statearr_21072_21106[(2)] = inst_20996);

(statearr_21072_21106[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (8))){
var inst_20943 = (state_21037[(2)]);
var state_21037__$1 = state_21037;
if(cljs.core.truth_(inst_20943)){
var statearr_21073_21107 = state_21037__$1;
(statearr_21073_21107[(1)] = (9));

} else {
var statearr_21074_21108 = state_21037__$1;
(statearr_21074_21108[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_21075 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21075[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__);

(statearr_21075[(1)] = (1));

return statearr_21075;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1 = (function (state_21037){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21037);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21076){var ex__2730__auto__ = e21076;
var statearr_21077_21109 = state_21037;
(statearr_21077_21109[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21037[(4)]))){
var statearr_21078_21110 = state_21037;
(statearr_21078_21110[(1)] = cljs.core.first((state_21037[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21111 = state_21037;
state_21037 = G__21111;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = function(state_21037){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1.call(this,state_21037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21079 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21079[(6)] = c__2749__auto__);

return statearr_21079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__21118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__21118 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__21118;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4652__auto__ = (function fluree$db$query$analytical$variance_$_iter__21119(s__21120){
return (new cljs.core.LazySeq(null,(function (){
var s__21120__$1 = s__21120;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__21120__$1);
if(temp__5753__auto__){
var s__21120__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__21120__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__21120__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__21122 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__21121 = (0);
while(true){
if((i__21121 < size__4651__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__21121);
var delta = (x - mean);
cljs.core.chunk_append(b__21122,(delta * delta));

var G__21124 = (i__21121 + (1));
i__21121 = G__21124;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__21122),fluree$db$query$analytical$variance_$_iter__21119(cljs.core.chunk_rest(s__21120__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__21122),null);
}
} else {
var x = cljs.core.first(s__21120__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__21119(cljs.core.rest(s__21120__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__21123 = variance(coll);
return Math.sqrt(G__21123);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__21125 = null;
var G__21125__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21125__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21125 = function(n,coll){
switch(arguments.length){
case 1:
return G__21125__1.call(this,n);
case 2:
return G__21125__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21125.cljs$core$IFn$_invoke$arity$1 = G__21125__1;
G__21125.cljs$core$IFn$_invoke$arity$2 = G__21125__2;
return G__21125;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21126 = null;
var G__21126__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21126__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21126 = function(n,coll){
switch(arguments.length){
case 1:
return G__21126__1.call(this,n);
case 2:
return G__21126__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21126.cljs$core$IFn$_invoke$arity$1 = G__21126__1;
G__21126.cljs$core$IFn$_invoke$arity$2 = G__21126__2;
return G__21126;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21127 = null;
var G__21127__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__21127__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__21127 = function(n,coll){
switch(arguments.length){
case 1:
return G__21127__1.call(this,n);
case 2:
return G__21127__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21127.cljs$core$IFn$_invoke$arity$1 = G__21127__1;
G__21127.cljs$core$IFn$_invoke$arity$2 = G__21127__2;
return G__21127;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__21128 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21128,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21128,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21128,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21131 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__21134 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__21134) : agg_fn.call(null,G__21134));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21131,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21131,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__21135 = agg;
var map__21135__$1 = cljs.core.__destructure_map(map__21135);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21135__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21135__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21135__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__21137 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21137,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21137,(1),null);
var map__21140 = res__$1;
var map__21140__$1 = cljs.core.__destructure_map(map__21140);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21140__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21140__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21136_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__21136_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21141_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__21141_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21142_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21142_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__21143_SHARP_,p2__21144_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21143_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__21144_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21145_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21145_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__21148,row,b_tuple){
var vec__21149 = p__21148;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21149,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21149,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21146_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21146_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = acc;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21147_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21147_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21152_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21152_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21153_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21153_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21158 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21160 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__21159 = (function (p1__21154_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21154_SHARP_);
});
return fexpr__21159(G__21160);
})()),cljs.core.set(b_idxs));
var fexpr__21157 = (function (p1__21155_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21155_SHARP_);
});
return fexpr__21157(G__21158);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21156_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21156_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21161_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21161_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21162_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21162_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21167 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21169 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__21168 = (function (p1__21163_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21163_SHARP_);
});
return fexpr__21168(G__21169);
})()),cljs.core.set(b_idxs));
var fexpr__21166 = (function (p1__21164_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21164_SHARP_);
});
return fexpr__21166(G__21167);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21165_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21165_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__21171 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21171,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21171,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21170_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__21170_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__21176 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21176,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21176,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21174_SHARP_){
return fluree.db.util.core.index_of(headers,p1__21174_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__21175_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__21175_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21179,filters,optional_QMARK_){
var map__21180 = p__21179;
var map__21180__$1 = cljs.core.__destructure_map(map__21180);
var tuple_map = map__21180__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21180__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21180__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21180__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21181 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21181,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21181,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21184 = res;
var map__21184__$1 = cljs.core.__destructure_map(map__21184);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21184__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21184__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21240){
var state_val_21241 = (state_21240[(1)]);
if((state_val_21241 === (7))){
var inst_21214 = (state_21240[(7)]);
var inst_21212 = (state_21240[(2)]);
var inst_21213 = fluree.db.util.async.throw_err(inst_21212);
var inst_21214__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21213,(0),null);
var inst_21215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21213,(1),null);
var inst_21216 = (inst_21214__$1 == null);
var state_21240__$1 = (function (){var statearr_21242 = state_21240;
(statearr_21242[(7)] = inst_21214__$1);

(statearr_21242[(8)] = inst_21215);

return statearr_21242;
})();
if(cljs.core.truth_(inst_21216)){
var statearr_21243_21272 = state_21240__$1;
(statearr_21243_21272[(1)] = (8));

} else {
var statearr_21244_21273 = state_21240__$1;
(statearr_21244_21273[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (1))){
var inst_21192 = optional_clauses;
var inst_21193 = cljs.core.seq(inst_21192);
var inst_21194 = cljs.core.first(inst_21193);
var inst_21195 = cljs.core.next(inst_21193);
var inst_21196 = where_tuples;
var inst_21197 = inst_21192;
var inst_21198 = inst_21196;
var state_21240__$1 = (function (){var statearr_21245 = state_21240;
(statearr_21245[(9)] = inst_21195);

(statearr_21245[(10)] = inst_21198);

(statearr_21245[(11)] = inst_21197);

(statearr_21245[(12)] = inst_21194);

return statearr_21245;
})();
var statearr_21246_21274 = state_21240__$1;
(statearr_21246_21274[(2)] = null);

(statearr_21246_21274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (4))){
var inst_21205 = (state_21240[(13)]);
var inst_21198 = (state_21240[(10)]);
var inst_21204 = (state_21240[(14)]);
var inst_21210 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_21198,inst_21204,inst_21205,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21198,inst_21204,inst_21205,true,fuel,max_fuel,opts));
var state_21240__$1 = state_21240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21240__$1,(7),inst_21210);
} else {
if((state_val_21241 === (15))){
var state_21240__$1 = state_21240;
var statearr_21247_21275 = state_21240__$1;
(statearr_21247_21275[(2)] = null);

(statearr_21247_21275[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (13))){
var inst_21231 = (state_21240[(2)]);
var state_21240__$1 = state_21240;
var statearr_21248_21276 = state_21240__$1;
(statearr_21248_21276[(2)] = inst_21231);

(statearr_21248_21276[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (6))){
var inst_21236 = (state_21240[(2)]);
var state_21240__$1 = state_21240;
var statearr_21249_21277 = state_21240__$1;
(statearr_21249_21277[(2)] = inst_21236);

(statearr_21249_21277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (3))){
var inst_21238 = (state_21240[(2)]);
var state_21240__$1 = state_21240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21240__$1,inst_21238);
} else {
if((state_val_21241 === (12))){
var state_21240__$1 = state_21240;
var statearr_21250_21278 = state_21240__$1;
(statearr_21250_21278[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (2))){
var inst_21197 = (state_21240[(11)]);
var inst_21204 = (state_21240[(14)]);
var inst_21203 = cljs.core.seq(inst_21197);
var inst_21204__$1 = cljs.core.first(inst_21203);
var inst_21205 = cljs.core.next(inst_21203);
var state_21240__$1 = (function (){var statearr_21252 = state_21240;
(statearr_21252[(13)] = inst_21205);

(statearr_21252[(14)] = inst_21204__$1);

return statearr_21252;
})();
if(cljs.core.truth_(inst_21204__$1)){
var statearr_21253_21279 = state_21240__$1;
(statearr_21253_21279[(1)] = (4));

} else {
var statearr_21254_21280 = state_21240__$1;
(statearr_21254_21280[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (11))){
var inst_21214 = (state_21240[(7)]);
var inst_21215 = (state_21240[(8)]);
var inst_21197 = inst_21215;
var inst_21198 = inst_21214;
var state_21240__$1 = (function (){var statearr_21255 = state_21240;
(statearr_21255[(10)] = inst_21198);

(statearr_21255[(11)] = inst_21197);

return statearr_21255;
})();
var statearr_21256_21281 = state_21240__$1;
(statearr_21256_21281[(2)] = null);

(statearr_21256_21281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (9))){
var inst_21204 = (state_21240[(14)]);
var inst_21220 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21204);
var state_21240__$1 = state_21240;
if(cljs.core.truth_(inst_21220)){
var statearr_21257_21282 = state_21240__$1;
(statearr_21257_21282[(1)] = (11));

} else {
var statearr_21258_21283 = state_21240__$1;
(statearr_21258_21283[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (5))){
var inst_21198 = (state_21240[(10)]);
var state_21240__$1 = state_21240;
var statearr_21259_21284 = state_21240__$1;
(statearr_21259_21284[(2)] = inst_21198);

(statearr_21259_21284[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (14))){
var inst_21214 = (state_21240[(7)]);
var inst_21198 = (state_21240[(10)]);
var inst_21215 = (state_21240[(8)]);
var inst_21225 = fluree.db.query.analytical.left_outer_join(inst_21198,inst_21214);
var inst_21197 = inst_21215;
var inst_21198__$1 = inst_21225;
var state_21240__$1 = (function (){var statearr_21260 = state_21240;
(statearr_21260[(10)] = inst_21198__$1);

(statearr_21260[(11)] = inst_21197);

return statearr_21260;
})();
var statearr_21261_21285 = state_21240__$1;
(statearr_21261_21285[(2)] = null);

(statearr_21261_21285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (16))){
var inst_21229 = (state_21240[(2)]);
var state_21240__$1 = state_21240;
var statearr_21263_21286 = state_21240__$1;
(statearr_21263_21286[(2)] = inst_21229);

(statearr_21263_21286[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (10))){
var inst_21233 = (state_21240[(2)]);
var state_21240__$1 = state_21240;
var statearr_21264_21287 = state_21240__$1;
(statearr_21264_21287[(2)] = inst_21233);

(statearr_21264_21287[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21241 === (8))){
var inst_21198 = (state_21240[(10)]);
var inst_21215 = (state_21240[(8)]);
var tmp21262 = inst_21198;
var inst_21197 = inst_21215;
var inst_21198__$1 = tmp21262;
var state_21240__$1 = (function (){var statearr_21265 = state_21240;
(statearr_21265[(10)] = inst_21198__$1);

(statearr_21265[(11)] = inst_21197);

return statearr_21265;
})();
var statearr_21266_21288 = state_21240__$1;
(statearr_21266_21288[(2)] = null);

(statearr_21266_21288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0 = (function (){
var statearr_21267 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21267[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__);

(statearr_21267[(1)] = (1));

return statearr_21267;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1 = (function (state_21240){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21240);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21268){var ex__2730__auto__ = e21268;
var statearr_21269_21289 = state_21240;
(statearr_21269_21289[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21240[(4)]))){
var statearr_21270_21290 = state_21240;
(statearr_21270_21290[(1)] = cljs.core.first((state_21240[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21291 = state_21240;
state_21240 = G__21291;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = function(state_21240){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1.call(this,state_21240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21271 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21271[(6)] = c__2749__auto__);

return statearr_21271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__21293){
var vec__21294 = p__21293;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21294,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21294,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21292_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21292_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21298,p__21299,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21300 = p__21298;
var map__21300__$1 = cljs.core.__destructure_map(map__21300);
var q_map = map__21300__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21300__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21301 = p__21299;
var map__21301__$1 = cljs.core.__destructure_map(map__21301);
var res = map__21301__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21301__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21538){
var state_val_21539 = (state_21538[(1)]);
if((state_val_21539 === (65))){
var inst_21488 = (state_21538[(7)]);
var inst_21487 = (state_21538[(8)]);
var inst_21499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21500 = fluree.db.query.analytical.full_text__GT_tuples(inst_21487,res,inst_21488);
var inst_21501 = [inst_21500,r];
var inst_21502 = (new cljs.core.PersistentVector(null,2,(5),inst_21499,inst_21501,null));
var state_21538__$1 = state_21538;
var statearr_21540_21653 = state_21538__$1;
(statearr_21540_21653[(2)] = inst_21502);

(statearr_21540_21653[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (70))){
var inst_21514 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21541_21654 = state_21538__$1;
(statearr_21541_21654[(2)] = inst_21514);

(statearr_21541_21654[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (62))){
var inst_21488 = (state_21538[(7)]);
var inst_21496 = cljs.core.second(inst_21488);
var inst_21497 = clojure.string.starts_with_QMARK_(inst_21496,"fullText:");
var state_21538__$1 = state_21538;
if(inst_21497){
var statearr_21542_21655 = state_21538__$1;
(statearr_21542_21655[(1)] = (65));

} else {
var statearr_21543_21656 = state_21538__$1;
(statearr_21543_21656[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (7))){
var inst_21407 = (state_21538[(9)]);
var inst_21406 = cljs.core.count(clause);
var inst_21407__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21406);
var state_21538__$1 = (function (){var statearr_21544 = state_21538;
(statearr_21544[(9)] = inst_21407__$1);

return statearr_21544;
})();
if(inst_21407__$1){
var statearr_21545_21657 = state_21538__$1;
(statearr_21545_21657[(1)] = (31));

} else {
var statearr_21546_21658 = state_21538__$1;
(statearr_21546_21658[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (59))){
var inst_21521 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21547_21659 = state_21538__$1;
(statearr_21547_21659[(2)] = inst_21521);

(statearr_21547_21659[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (20))){
var inst_21370 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21548_21660 = state_21538__$1;
(statearr_21548_21660[(2)] = inst_21370);

(statearr_21548_21660[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (58))){
var state_21538__$1 = state_21538;
var statearr_21549_21661 = state_21538__$1;
(statearr_21549_21661[(2)] = null);

(statearr_21549_21661[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (60))){
var inst_21487 = (state_21538[(8)]);
var inst_21485 = (state_21538[(2)]);
var inst_21486 = fluree.db.util.async.throw_err(inst_21485);
var inst_21487__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21486,(0),null);
var inst_21488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21486,(1),null);
var inst_21489 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_21487__$1);
var state_21538__$1 = (function (){var statearr_21550 = state_21538;
(statearr_21550[(7)] = inst_21488);

(statearr_21550[(8)] = inst_21487__$1);

return statearr_21550;
})();
if(inst_21489){
var statearr_21551_21662 = state_21538__$1;
(statearr_21551_21662[(1)] = (61));

} else {
var statearr_21552_21663 = state_21538__$1;
(statearr_21552_21663[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (27))){
var inst_21400 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21553_21664 = state_21538__$1;
(statearr_21553_21664[(2)] = inst_21400);

(statearr_21553_21664[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (1))){
var state_21538__$1 = state_21538;
var statearr_21554_21665 = state_21538__$1;
(statearr_21554_21665[(2)] = null);

(statearr_21554_21665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (69))){
var state_21538__$1 = state_21538;
var statearr_21555_21666 = state_21538__$1;
(statearr_21555_21666[(2)] = null);

(statearr_21555_21666[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (24))){
var inst_21364 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21556_21667 = state_21538__$1;
(statearr_21556_21667[(2)] = inst_21364);

(statearr_21556_21667[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (55))){
var inst_21470 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21471 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21472 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21473 = cljs.core.PersistentHashMap.fromArrays(inst_21471,inst_21472);
var inst_21474 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21470,inst_21473);
var inst_21475 = (function(){throw inst_21474})();
var state_21538__$1 = state_21538;
var statearr_21557_21668 = state_21538__$1;
(statearr_21557_21668[(2)] = inst_21475);

(statearr_21557_21668[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (39))){
var inst_21427 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
if(cljs.core.truth_(inst_21427)){
var statearr_21558_21669 = state_21538__$1;
(statearr_21558_21669[(1)] = (40));

} else {
var statearr_21559_21670 = state_21538__$1;
(statearr_21559_21670[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (46))){
var inst_21527 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21560_21671 = state_21538__$1;
(statearr_21560_21671[(2)] = inst_21527);

(statearr_21560_21671[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (4))){
var inst_21302 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21561_21672 = state_21538__$1;
(statearr_21561_21672[(2)] = inst_21302);

(statearr_21561_21672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (54))){
var inst_21463 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21464 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21465 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21466 = cljs.core.PersistentHashMap.fromArrays(inst_21464,inst_21465);
var inst_21467 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21463,inst_21466);
var inst_21468 = (function(){throw inst_21467})();
var state_21538__$1 = state_21538;
var statearr_21562_21673 = state_21538__$1;
(statearr_21562_21673[(2)] = inst_21468);

(statearr_21562_21673[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (15))){
var inst_21402 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21563_21674 = state_21538__$1;
(statearr_21563_21674[(2)] = inst_21402);

(statearr_21563_21674[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (48))){
var inst_21451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21452 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_21453 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21452);
var inst_21454 = [inst_21453,r];
var inst_21455 = (new cljs.core.PersistentVector(null,2,(5),inst_21451,inst_21454,null));
var state_21538__$1 = state_21538;
var statearr_21564_21675 = state_21538__$1;
(statearr_21564_21675[(2)] = inst_21455);

(statearr_21564_21675[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (50))){
var inst_21525 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21565_21676 = state_21538__$1;
(statearr_21565_21676[(2)] = inst_21525);

(statearr_21565_21676[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (21))){
var inst_21315 = (state_21538[(10)]);
var inst_21348 = (state_21538[(11)]);
var inst_21339 = (state_21538[(12)]);
var inst_21338 = (state_21538[(13)]);
var inst_21336 = (state_21538[(14)]);
var inst_21340 = (state_21538[(15)]);
var inst_21311 = (state_21538[(16)]);
var inst_21347 = (state_21538[(17)]);
var inst_21341 = (state_21538[(18)]);
var inst_21352 = (state_21538[(2)]);
var inst_21353 = fluree.db.util.async.throw_err(inst_21352);
var inst_21354 = (function (){var pred__21312 = inst_21315;
var seq__21334 = inst_21339;
var new_res = inst_21353;
var rest = inst_21348;
var expr__21313 = inst_21311;
var tuples = inst_21341;
var vec__21333 = inst_21336;
var first__21345 = inst_21347;
var seq__21344 = inst_21348;
var G__21332 = inst_21340;
var vec__21343 = inst_21340;
var segment_type = inst_21311;
var clause_group = inst_21347;
var first__21335 = inst_21338;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21355 = cljs.core.keys(vars);
var inst_21356 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21354,inst_21353,inst_21355);
var inst_21357 = fluree.db.query.analytical.res_absorb_vars(inst_21356);
var state_21538__$1 = (function (){var statearr_21566 = state_21538;
(statearr_21566[(19)] = inst_21357);

return statearr_21566;
})();
if(cljs.core.truth_(inst_21341)){
var statearr_21567_21677 = state_21538__$1;
(statearr_21567_21677[(1)] = (22));

} else {
var statearr_21568_21678 = state_21538__$1;
(statearr_21568_21678[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (31))){
var inst_21409 = cljs.core.second(clause);
var inst_21410 = clojure.string.starts_with_QMARK_(inst_21409,"fullText:");
var state_21538__$1 = state_21538;
var statearr_21569_21679 = state_21538__$1;
(statearr_21569_21679[(2)] = inst_21410);

(statearr_21569_21679[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (32))){
var inst_21407 = (state_21538[(9)]);
var state_21538__$1 = state_21538;
var statearr_21570_21680 = state_21538__$1;
(statearr_21570_21680[(2)] = inst_21407);

(statearr_21570_21680[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (40))){
var inst_21429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21430 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_21538__$1 = (function (){var statearr_21571 = state_21538;
(statearr_21571[(20)] = inst_21429);

return statearr_21571;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21538__$1,(43),inst_21430);
} else {
if((state_val_21539 === (56))){
var inst_21477 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21572_21681 = state_21538__$1;
(statearr_21572_21681[(2)] = inst_21477);

(statearr_21572_21681[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (33))){
var inst_21413 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
if(cljs.core.truth_(inst_21413)){
var statearr_21573_21682 = state_21538__$1;
(statearr_21573_21682[(1)] = (34));

} else {
var statearr_21574_21683 = state_21538__$1;
(statearr_21574_21683[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (13))){
var inst_21336 = (state_21538[(14)]);
var inst_21336__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21337 = cljs.core.seq(inst_21336__$1);
var inst_21338 = cljs.core.first(inst_21337);
var inst_21339 = cljs.core.next(inst_21337);
var inst_21340 = inst_21336__$1;
var inst_21341 = null;
var state_21538__$1 = (function (){var statearr_21575 = state_21538;
(statearr_21575[(12)] = inst_21339);

(statearr_21575[(13)] = inst_21338);

(statearr_21575[(14)] = inst_21336__$1);

(statearr_21575[(15)] = inst_21340);

(statearr_21575[(18)] = inst_21341);

return statearr_21575;
})();
var statearr_21576_21684 = state_21538__$1;
(statearr_21576_21684[(2)] = null);

(statearr_21576_21684[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (22))){
var inst_21348 = (state_21538[(11)]);
var inst_21357 = (state_21538[(19)]);
var inst_21341 = (state_21538[(18)]);
var inst_21359 = fluree.db.query.union.results(inst_21341,inst_21357);
var inst_21340 = inst_21348;
var inst_21341__$1 = inst_21359;
var state_21538__$1 = (function (){var statearr_21577 = state_21538;
(statearr_21577[(15)] = inst_21340);

(statearr_21577[(18)] = inst_21341__$1);

return statearr_21577;
})();
var statearr_21578_21685 = state_21538__$1;
(statearr_21578_21685[(2)] = null);

(statearr_21578_21685[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (36))){
var inst_21531 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21579_21686 = state_21538__$1;
(statearr_21579_21686[(2)] = inst_21531);

(statearr_21579_21686[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (41))){
var inst_21437 = cljs.core.count(clause);
var inst_21438 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21437);
var state_21538__$1 = state_21538;
if(inst_21438){
var statearr_21580_21687 = state_21538__$1;
(statearr_21580_21687[(1)] = (44));

} else {
var statearr_21581_21688 = state_21538__$1;
(statearr_21581_21688[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (43))){
var inst_21429 = (state_21538[(20)]);
var inst_21432 = (state_21538[(2)]);
var inst_21433 = fluree.db.util.async.throw_err(inst_21432);
var inst_21434 = [inst_21433,r];
var inst_21435 = (new cljs.core.PersistentVector(null,2,(5),inst_21429,inst_21434,null));
var state_21538__$1 = state_21538;
var statearr_21582_21689 = state_21538__$1;
(statearr_21582_21689[(2)] = inst_21435);

(statearr_21582_21689[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (61))){
var inst_21488 = (state_21538[(7)]);
var inst_21491 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_21488,r,res,optional_QMARK_,fuel,max_fuel);
var state_21538__$1 = state_21538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21538__$1,(64),inst_21491);
} else {
if((state_val_21539 === (29))){
var inst_21311 = (state_21538[(16)]);
var inst_21394 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21311)].join('');
var inst_21395 = (new Error(inst_21394));
var inst_21396 = (function(){throw inst_21395})();
var state_21538__$1 = state_21538;
var statearr_21583_21690 = state_21538__$1;
(statearr_21583_21690[(2)] = inst_21396);

(statearr_21583_21690[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (44))){
var inst_21440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21441 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_21538__$1 = (function (){var statearr_21584 = state_21538;
(statearr_21584[(21)] = inst_21440);

return statearr_21584;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21538__$1,(47),inst_21441);
} else {
if((state_val_21539 === (6))){
var inst_21315 = (state_21538[(10)]);
var inst_21311 = (state_21538[(16)]);
var inst_21310 = cljs.core.keys(clause);
var inst_21311__$1 = cljs.core.first(inst_21310);
var inst_21315__$1 = cljs.core._EQ_;
var inst_21316 = (function (){var G__21585 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__21586 = inst_21311__$1;
return (inst_21315__$1.cljs$core$IFn$_invoke$arity$2 ? inst_21315__$1.cljs$core$IFn$_invoke$arity$2(G__21585,G__21586) : inst_21315__$1.call(null,G__21585,G__21586));
})();
var state_21538__$1 = (function (){var statearr_21587 = state_21538;
(statearr_21587[(10)] = inst_21315__$1);

(statearr_21587[(16)] = inst_21311__$1);

return statearr_21587;
})();
if(cljs.core.truth_(inst_21316)){
var statearr_21588_21691 = state_21538__$1;
(statearr_21588_21691[(1)] = (9));

} else {
var statearr_21589_21692 = state_21538__$1;
(statearr_21589_21692[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (28))){
var inst_21388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21389 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21390 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_21389,optional_QMARK_);
var inst_21391 = [inst_21390,r];
var inst_21392 = (new cljs.core.PersistentVector(null,2,(5),inst_21388,inst_21391,null));
var state_21538__$1 = state_21538;
var statearr_21590_21693 = state_21538__$1;
(statearr_21590_21693[(2)] = inst_21392);

(statearr_21590_21693[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (64))){
var inst_21493 = (state_21538[(2)]);
var inst_21494 = fluree.db.util.async.throw_err(inst_21493);
var state_21538__$1 = state_21538;
var statearr_21591_21694 = state_21538__$1;
(statearr_21591_21694[(2)] = inst_21494);

(statearr_21591_21694[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (51))){
var inst_21460 = cljs.core.first(clause);
var inst_21461 = cljs.core.sequential_QMARK_(inst_21460);
var state_21538__$1 = state_21538;
if(inst_21461){
var statearr_21592_21695 = state_21538__$1;
(statearr_21592_21695[(1)] = (54));

} else {
var statearr_21593_21696 = state_21538__$1;
(statearr_21593_21696[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (25))){
var inst_21315 = (state_21538[(10)]);
var inst_21311 = (state_21538[(16)]);
var inst_21376 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21377 = (function (){var segment_type = inst_21311;
var pred__21312 = inst_21315;
var expr__21313 = inst_21311;
var bindings = inst_21376;
return (function (p1__21297_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__21297_SHARP_);
});
})();
var inst_21378 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21377,inst_21376);
var inst_21379 = cljs.core.PersistentHashMap.EMPTY;
var inst_21380 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21379,inst_21378);
var inst_21381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21382 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21380);
var inst_21383 = [inst_21382,r];
var inst_21384 = (new cljs.core.PersistentVector(null,2,(5),inst_21381,inst_21383,null));
var state_21538__$1 = state_21538;
var statearr_21594_21697 = state_21538__$1;
(statearr_21594_21697[(2)] = inst_21384);

(statearr_21594_21697[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (34))){
var inst_21415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21416 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_21417 = [inst_21416,r];
var inst_21418 = (new cljs.core.PersistentVector(null,2,(5),inst_21415,inst_21417,null));
var state_21538__$1 = state_21538;
var statearr_21595_21698 = state_21538__$1;
(statearr_21595_21698[(2)] = inst_21418);

(statearr_21595_21698[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (17))){
var inst_21372 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21596_21699 = state_21538__$1;
(statearr_21596_21699[(2)] = inst_21372);

(statearr_21596_21699[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (3))){
var inst_21536 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21538__$1,inst_21536);
} else {
if((state_val_21539 === (12))){
var inst_21318 = (state_21538[(22)]);
var inst_21322 = (state_21538[(2)]);
var inst_21323 = fluree.db.util.async.throw_err(inst_21322);
var inst_21324 = [inst_21323,r];
var inst_21325 = (new cljs.core.PersistentVector(null,2,(5),inst_21318,inst_21324,null));
var state_21538__$1 = state_21538;
var statearr_21597_21700 = state_21538__$1;
(statearr_21597_21700[(2)] = inst_21325);

(statearr_21597_21700[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (2))){
var _ = (function (){var statearr_21598 = state_21538;
(statearr_21598[(4)] = cljs.core.cons((5),(state_21538[(4)])));

return statearr_21598;
})();
var inst_21308 = cljs.core.map_QMARK_(clause);
var state_21538__$1 = state_21538;
if(inst_21308){
var statearr_21599_21701 = state_21538__$1;
(statearr_21599_21701[(1)] = (6));

} else {
var statearr_21600_21702 = state_21538__$1;
(statearr_21600_21702[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (66))){
var state_21538__$1 = state_21538;
var statearr_21601_21703 = state_21538__$1;
(statearr_21601_21703[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (23))){
var inst_21348 = (state_21538[(11)]);
var inst_21357 = (state_21538[(19)]);
var inst_21340 = inst_21348;
var inst_21341 = inst_21357;
var state_21538__$1 = (function (){var statearr_21603 = state_21538;
(statearr_21603[(15)] = inst_21340);

(statearr_21603[(18)] = inst_21341);

return statearr_21603;
})();
var statearr_21604_21704 = state_21538__$1;
(statearr_21604_21704[(2)] = null);

(statearr_21604_21704[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (47))){
var inst_21440 = (state_21538[(21)]);
var inst_21443 = (state_21538[(2)]);
var inst_21444 = fluree.db.util.async.throw_err(inst_21443);
var inst_21445 = [inst_21444,r];
var inst_21446 = (new cljs.core.PersistentVector(null,2,(5),inst_21440,inst_21445,null));
var state_21538__$1 = state_21538;
var statearr_21605_21705 = state_21538__$1;
(statearr_21605_21705[(2)] = inst_21446);

(statearr_21605_21705[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (35))){
var inst_21421 = (state_21538[(23)]);
var inst_21420 = cljs.core.count(clause);
var inst_21421__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21420);
var state_21538__$1 = (function (){var statearr_21606 = state_21538;
(statearr_21606[(23)] = inst_21421__$1);

return statearr_21606;
})();
if(inst_21421__$1){
var statearr_21607_21706 = state_21538__$1;
(statearr_21607_21706[(1)] = (37));

} else {
var statearr_21608_21707 = state_21538__$1;
(statearr_21608_21707[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (19))){
var inst_21341 = (state_21538[(18)]);
var inst_21366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21367 = [inst_21341,r];
var inst_21368 = (new cljs.core.PersistentVector(null,2,(5),inst_21366,inst_21367,null));
var state_21538__$1 = state_21538;
var statearr_21609_21708 = state_21538__$1;
(statearr_21609_21708[(2)] = inst_21368);

(statearr_21609_21708[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (57))){
var inst_21483 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_21538__$1 = state_21538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21538__$1,(60),inst_21483);
} else {
if((state_val_21539 === (68))){
var inst_21488 = (state_21538[(7)]);
var inst_21487 = (state_21538[(8)]);
var inst_21505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21506 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_21487,res,inst_21488,fuel,max_fuel);
var state_21538__$1 = (function (){var statearr_21610 = state_21538;
(statearr_21610[(24)] = inst_21505);

return statearr_21610;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21538__$1,(71),inst_21506);
} else {
if((state_val_21539 === (11))){
var inst_21404 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21612_21709 = state_21538__$1;
(statearr_21612_21709[(2)] = inst_21404);

(statearr_21612_21709[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (9))){
var inst_21318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21319 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21320 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21319,res,fuel,max_fuel,opts);
var state_21538__$1 = (function (){var statearr_21613 = state_21538;
(statearr_21613[(22)] = inst_21318);

return statearr_21613;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21538__$1,(12),inst_21320);
} else {
if((state_val_21539 === (5))){
var _ = (function (){var statearr_21614 = state_21538;
(statearr_21614[(4)] = cljs.core.rest((state_21538[(4)])));

return statearr_21614;
})();
var state_21538__$1 = state_21538;
var ex21611 = (state_21538__$1[(2)]);
var statearr_21615_21710 = state_21538__$1;
(statearr_21615_21710[(5)] = ex21611);


if((ex21611 instanceof Error)){
var statearr_21616_21711 = state_21538__$1;
(statearr_21616_21711[(1)] = (4));

(statearr_21616_21711[(5)] = null);

} else {
throw ex21611;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (14))){
var inst_21315 = (state_21538[(10)]);
var inst_21311 = (state_21538[(16)]);
var inst_21374 = (function (){var G__21617 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__21618 = inst_21311;
return (inst_21315.cljs$core$IFn$_invoke$arity$2 ? inst_21315.cljs$core$IFn$_invoke$arity$2(G__21617,G__21618) : inst_21315.call(null,G__21617,G__21618));
})();
var state_21538__$1 = state_21538;
if(cljs.core.truth_(inst_21374)){
var statearr_21619_21712 = state_21538__$1;
(statearr_21619_21712[(1)] = (25));

} else {
var statearr_21620_21713 = state_21538__$1;
(statearr_21620_21713[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (45))){
var inst_21448 = cljs.core.count(clause);
var inst_21449 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21448);
var state_21538__$1 = state_21538;
if(inst_21449){
var statearr_21621_21714 = state_21538__$1;
(statearr_21621_21714[(1)] = (48));

} else {
var statearr_21622_21715 = state_21538__$1;
(statearr_21622_21715[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (53))){
var inst_21523 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21623_21716 = state_21538__$1;
(statearr_21623_21716[(2)] = inst_21523);

(statearr_21623_21716[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (26))){
var inst_21315 = (state_21538[(10)]);
var inst_21311 = (state_21538[(16)]);
var inst_21386 = (function (){var G__21624 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__21625 = inst_21311;
return (inst_21315.cljs$core$IFn$_invoke$arity$2 ? inst_21315.cljs$core$IFn$_invoke$arity$2(G__21624,G__21625) : inst_21315.call(null,G__21624,G__21625));
})();
var state_21538__$1 = state_21538;
if(cljs.core.truth_(inst_21386)){
var statearr_21626_21717 = state_21538__$1;
(statearr_21626_21717[(1)] = (28));

} else {
var statearr_21627_21718 = state_21538__$1;
(statearr_21627_21718[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (16))){
var inst_21340 = (state_21538[(15)]);
var inst_21347 = (state_21538[(17)]);
var inst_21346 = cljs.core.seq(inst_21340);
var inst_21347__$1 = cljs.core.first(inst_21346);
var inst_21348 = cljs.core.next(inst_21346);
var state_21538__$1 = (function (){var statearr_21628 = state_21538;
(statearr_21628[(11)] = inst_21348);

(statearr_21628[(17)] = inst_21347__$1);

return statearr_21628;
})();
if(cljs.core.truth_(inst_21347__$1)){
var statearr_21629_21719 = state_21538__$1;
(statearr_21629_21719[(1)] = (18));

} else {
var statearr_21630_21720 = state_21538__$1;
(statearr_21630_21720[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (38))){
var inst_21421 = (state_21538[(23)]);
var state_21538__$1 = state_21538;
var statearr_21631_21721 = state_21538__$1;
(statearr_21631_21721[(2)] = inst_21421);

(statearr_21631_21721[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (30))){
var inst_21398 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21632_21722 = state_21538__$1;
(statearr_21632_21722[(2)] = inst_21398);

(statearr_21632_21722[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (10))){
var inst_21315 = (state_21538[(10)]);
var inst_21311 = (state_21538[(16)]);
var inst_21327 = (function (){var G__21633 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__21634 = inst_21311;
return (inst_21315.cljs$core$IFn$_invoke$arity$2 ? inst_21315.cljs$core$IFn$_invoke$arity$2(G__21633,G__21634) : inst_21315.call(null,G__21633,G__21634));
})();
var state_21538__$1 = state_21538;
if(cljs.core.truth_(inst_21327)){
var statearr_21635_21723 = state_21538__$1;
(statearr_21635_21723[(1)] = (13));

} else {
var statearr_21636_21724 = state_21538__$1;
(statearr_21636_21724[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (18))){
var inst_21347 = (state_21538[(17)]);
var inst_21350 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21347,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21347,q_map,vars,fuel,max_fuel,opts));
var state_21538__$1 = state_21538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21538__$1,(21),inst_21350);
} else {
if((state_val_21539 === (52))){
var state_21538__$1 = state_21538;
var statearr_21637_21725 = state_21538__$1;
(statearr_21637_21725[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (67))){
var inst_21516 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21639_21726 = state_21538__$1;
(statearr_21639_21726[(2)] = inst_21516);

(statearr_21639_21726[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (71))){
var inst_21505 = (state_21538[(24)]);
var inst_21508 = (state_21538[(2)]);
var inst_21509 = fluree.db.util.async.throw_err(inst_21508);
var inst_21510 = [inst_21509,r];
var inst_21511 = (new cljs.core.PersistentVector(null,2,(5),inst_21505,inst_21510,null));
var state_21538__$1 = state_21538;
var statearr_21640_21727 = state_21538__$1;
(statearr_21640_21727[(2)] = inst_21511);

(statearr_21640_21727[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (42))){
var inst_21529 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21641_21728 = state_21538__$1;
(statearr_21641_21728[(2)] = inst_21529);

(statearr_21641_21728[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (37))){
var inst_21423 = cljs.core.second(clause);
var inst_21424 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21423,"rdf:type");
var state_21538__$1 = state_21538;
var statearr_21642_21729 = state_21538__$1;
(statearr_21642_21729[(2)] = inst_21424);

(statearr_21642_21729[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (63))){
var inst_21518 = (state_21538[(2)]);
var state_21538__$1 = state_21538;
var statearr_21643_21730 = state_21538__$1;
(statearr_21643_21730[(2)] = inst_21518);

(statearr_21643_21730[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (8))){
var inst_21533 = (state_21538[(2)]);
var _ = (function (){var statearr_21644 = state_21538;
(statearr_21644[(4)] = cljs.core.rest((state_21538[(4)])));

return statearr_21644;
})();
var state_21538__$1 = state_21538;
var statearr_21645_21731 = state_21538__$1;
(statearr_21645_21731[(2)] = inst_21533);

(statearr_21645_21731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21539 === (49))){
var inst_21457 = cljs.core.count(clause);
var inst_21458 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_21457);
var state_21538__$1 = state_21538;
if(inst_21458){
var statearr_21646_21732 = state_21538__$1;
(statearr_21646_21732[(1)] = (51));

} else {
var statearr_21647_21733 = state_21538__$1;
(statearr_21647_21733[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_21648 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21648[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_21648[(1)] = (1));

return statearr_21648;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_21538){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21538);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21649){var ex__2730__auto__ = e21649;
var statearr_21650_21734 = state_21538;
(statearr_21650_21734[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21538[(4)]))){
var statearr_21651_21735 = state_21538;
(statearr_21651_21735[(1)] = cljs.core.first((state_21538[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21736 = state_21538;
state_21538 = G__21736;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = function(state_21538){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_21538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21652 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21652[(6)] = c__2749__auto__);

return statearr_21652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21738 = arguments.length;
switch (G__21738) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21818){
var state_val_21819 = (state_21818[(1)]);
if((state_val_21819 === (7))){
var inst_21813 = (state_21818[(2)]);
var _ = (function (){var statearr_21820 = state_21818;
(statearr_21820[(4)] = cljs.core.rest((state_21818[(4)])));

return statearr_21820;
})();
var state_21818__$1 = state_21818;
var statearr_21821_21869 = state_21818__$1;
(statearr_21821_21869[(2)] = inst_21813);

(statearr_21821_21869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (20))){
var inst_21778 = (state_21818[(7)]);
var inst_21790 = (state_21818[(2)]);
var inst_21760 = inst_21778;
var inst_21761 = inst_21790;
var state_21818__$1 = (function (){var statearr_21822 = state_21818;
(statearr_21822[(8)] = inst_21760);

(statearr_21822[(9)] = inst_21761);

return statearr_21822;
})();
var statearr_21823_21870 = state_21818__$1;
(statearr_21823_21870[(2)] = null);

(statearr_21823_21870[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (1))){
var state_21818__$1 = state_21818;
var statearr_21824_21871 = state_21818__$1;
(statearr_21824_21871[(2)] = null);

(statearr_21824_21871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (24))){
var inst_21777 = (state_21818[(10)]);
var inst_21761 = (state_21818[(9)]);
var inst_21778 = (state_21818[(7)]);
var inst_21798 = fluree.db.query.analytical.inner_join(inst_21761,inst_21777);
var inst_21760 = inst_21778;
var inst_21761__$1 = inst_21798;
var state_21818__$1 = (function (){var statearr_21825 = state_21818;
(statearr_21825[(8)] = inst_21760);

(statearr_21825[(9)] = inst_21761__$1);

return statearr_21825;
})();
var statearr_21826_21872 = state_21818__$1;
(statearr_21826_21872[(2)] = null);

(statearr_21826_21872[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (4))){
var inst_21739 = (state_21818[(2)]);
var state_21818__$1 = state_21818;
var statearr_21828_21873 = state_21818__$1;
(statearr_21828_21873[(2)] = inst_21739);

(statearr_21828_21873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (15))){
var inst_21777 = (state_21818[(10)]);
var state_21818__$1 = state_21818;
if(cljs.core.truth_(inst_21777)){
var statearr_21829_21874 = state_21818__$1;
(statearr_21829_21874[(1)] = (18));

} else {
var statearr_21830_21875 = state_21818__$1;
(statearr_21830_21875[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (21))){
var inst_21761 = (state_21818[(9)]);
var inst_21778 = (state_21818[(7)]);
var tmp21827 = inst_21761;
var inst_21760 = inst_21778;
var inst_21761__$1 = tmp21827;
var state_21818__$1 = (function (){var statearr_21831 = state_21818;
(statearr_21831[(8)] = inst_21760);

(statearr_21831[(9)] = inst_21761__$1);

return statearr_21831;
})();
var statearr_21832_21876 = state_21818__$1;
(statearr_21832_21876[(2)] = null);

(statearr_21832_21876[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (13))){
var inst_21761 = (state_21818[(9)]);
var inst_21784 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_21761,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21785 = cljs.core.empty_QMARK_(inst_21784);
var state_21818__$1 = state_21818;
if(inst_21785){
var statearr_21833_21877 = state_21818__$1;
(statearr_21833_21877[(1)] = (15));

} else {
var statearr_21834_21878 = state_21818__$1;
(statearr_21834_21878[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (22))){
var state_21818__$1 = state_21818;
var statearr_21835_21879 = state_21818__$1;
(statearr_21835_21879[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (6))){
var inst_21767 = (state_21818[(11)]);
var inst_21760 = (state_21818[(8)]);
var inst_21766 = cljs.core.seq(inst_21760);
var inst_21767__$1 = cljs.core.first(inst_21766);
var inst_21768 = cljs.core.next(inst_21766);
var state_21818__$1 = (function (){var statearr_21837 = state_21818;
(statearr_21837[(11)] = inst_21767__$1);

(statearr_21837[(12)] = inst_21768);

return statearr_21837;
})();
if(cljs.core.truth_(inst_21767__$1)){
var statearr_21838_21880 = state_21818__$1;
(statearr_21838_21880[(1)] = (8));

} else {
var statearr_21839_21881 = state_21818__$1;
(statearr_21839_21881[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (25))){
var state_21818__$1 = state_21818;
var statearr_21840_21882 = state_21818__$1;
(statearr_21840_21882[(2)] = null);

(statearr_21840_21882[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (17))){
var inst_21806 = (state_21818[(2)]);
var state_21818__$1 = state_21818;
var statearr_21841_21883 = state_21818__$1;
(statearr_21841_21883[(2)] = inst_21806);

(statearr_21841_21883[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (3))){
var inst_21816 = (state_21818[(2)]);
var state_21818__$1 = state_21818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21818__$1,inst_21816);
} else {
if((state_val_21819 === (12))){
var inst_21777 = (state_21818[(10)]);
var inst_21778 = (state_21818[(7)]);
var inst_21760 = inst_21778;
var inst_21761 = inst_21777;
var state_21818__$1 = (function (){var statearr_21842 = state_21818;
(statearr_21842[(8)] = inst_21760);

(statearr_21842[(9)] = inst_21761);

return statearr_21842;
})();
var statearr_21843_21884 = state_21818__$1;
(statearr_21843_21884[(2)] = null);

(statearr_21843_21884[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (2))){
var _ = (function (){var statearr_21844 = state_21818;
(statearr_21844[(4)] = cljs.core.cons((5),(state_21818[(4)])));

return statearr_21844;
})();
var inst_21752 = where;
var inst_21753 = cljs.core.seq(inst_21752);
var inst_21754 = cljs.core.first(inst_21753);
var inst_21755 = cljs.core.next(inst_21753);
var inst_21756 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21757 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_21758 = [inst_21757];
var inst_21759 = cljs.core.PersistentHashMap.fromArrays(inst_21756,inst_21758);
var inst_21760 = inst_21752;
var inst_21761 = inst_21759;
var state_21818__$1 = (function (){var statearr_21845 = state_21818;
(statearr_21845[(8)] = inst_21760);

(statearr_21845[(9)] = inst_21761);

(statearr_21845[(13)] = inst_21755);

(statearr_21845[(14)] = inst_21754);

return statearr_21845;
})();
var statearr_21846_21885 = state_21818__$1;
(statearr_21846_21885[(2)] = null);

(statearr_21846_21885[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (23))){
var inst_21804 = (state_21818[(2)]);
var state_21818__$1 = state_21818;
var statearr_21847_21886 = state_21818__$1;
(statearr_21847_21886[(2)] = inst_21804);

(statearr_21847_21886[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (19))){
var inst_21761 = (state_21818[(9)]);
var state_21818__$1 = state_21818;
var statearr_21848_21887 = state_21818__$1;
(statearr_21848_21887[(2)] = inst_21761);

(statearr_21848_21887[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (11))){
var inst_21767 = (state_21818[(11)]);
var inst_21775 = (state_21818[(2)]);
var inst_21776 = fluree.db.util.async.throw_err(inst_21775);
var inst_21777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21776,(0),null);
var inst_21778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21776,(1),null);
var inst_21779 = cljs.core.count(inst_21767);
var inst_21780 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21779);
var state_21818__$1 = (function (){var statearr_21850 = state_21818;
(statearr_21850[(10)] = inst_21777);

(statearr_21850[(7)] = inst_21778);

return statearr_21850;
})();
if(inst_21780){
var statearr_21851_21888 = state_21818__$1;
(statearr_21851_21888[(1)] = (12));

} else {
var statearr_21852_21889 = state_21818__$1;
(statearr_21852_21889[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (9))){
var inst_21761 = (state_21818[(9)]);
var state_21818__$1 = state_21818;
var statearr_21853_21890 = state_21818__$1;
(statearr_21853_21890[(2)] = inst_21761);

(statearr_21853_21890[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (5))){
var _ = (function (){var statearr_21854 = state_21818;
(statearr_21854[(4)] = cljs.core.rest((state_21818[(4)])));

return statearr_21854;
})();
var state_21818__$1 = state_21818;
var ex21849 = (state_21818__$1[(2)]);
var statearr_21855_21891 = state_21818__$1;
(statearr_21855_21891[(5)] = ex21849);


if((ex21849 instanceof Error)){
var statearr_21856_21892 = state_21818__$1;
(statearr_21856_21892[(1)] = (4));

(statearr_21856_21892[(5)] = null);

} else {
throw ex21849;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (14))){
var inst_21808 = (state_21818[(2)]);
var state_21818__$1 = state_21818;
var statearr_21857_21893 = state_21818__$1;
(statearr_21857_21893[(2)] = inst_21808);

(statearr_21857_21893[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (26))){
var inst_21802 = (state_21818[(2)]);
var state_21818__$1 = state_21818;
var statearr_21858_21894 = state_21818__$1;
(statearr_21858_21894[(2)] = inst_21802);

(statearr_21858_21894[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (16))){
var inst_21777 = (state_21818[(10)]);
var inst_21793 = (inst_21777 == null);
var state_21818__$1 = state_21818;
if(cljs.core.truth_(inst_21793)){
var statearr_21859_21895 = state_21818__$1;
(statearr_21859_21895[(1)] = (21));

} else {
var statearr_21860_21896 = state_21818__$1;
(statearr_21860_21896[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (10))){
var inst_21811 = (state_21818[(2)]);
var state_21818__$1 = state_21818;
var statearr_21861_21897 = state_21818__$1;
(statearr_21861_21897[(2)] = inst_21811);

(statearr_21861_21897[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (18))){
var inst_21777 = (state_21818[(10)]);
var state_21818__$1 = state_21818;
var statearr_21862_21898 = state_21818__$1;
(statearr_21862_21898[(2)] = inst_21777);

(statearr_21862_21898[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21819 === (8))){
var inst_21767 = (state_21818[(11)]);
var inst_21761 = (state_21818[(9)]);
var inst_21768 = (state_21818[(12)]);
var inst_21773 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_21761,inst_21767,inst_21768,false,fuel,max_fuel,opts);
var state_21818__$1 = state_21818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21818__$1,(11),inst_21773);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_21863 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21863[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_21863[(1)] = (1));

return statearr_21863;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_21818){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21818);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21864){var ex__2730__auto__ = e21864;
var statearr_21865_21899 = state_21818;
(statearr_21865_21899[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21818[(4)]))){
var statearr_21866_21900 = state_21818;
(statearr_21866_21900[(1)] = cljs.core.first((state_21818[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21901 = state_21818;
state_21818 = G__21901;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_21818){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_21818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21867 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21867[(6)] = c__2749__auto__);

return statearr_21867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21936){
var state_val_21937 = (state_21936[(1)]);
if((state_val_21937 === (7))){
var inst_21913 = (state_21936[(7)]);
var inst_21918 = (state_21936[(8)]);
var inst_21920 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21913,inst_21918,fuel,max_fuel,opts);
var state_21936__$1 = state_21936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21936__$1,(10),inst_21920);
} else {
if((state_val_21937 === (1))){
var state_21936__$1 = state_21936;
var statearr_21938_21963 = state_21936__$1;
(statearr_21938_21963[(2)] = null);

(statearr_21938_21963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (4))){
var inst_21902 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
var statearr_21939_21964 = state_21936__$1;
(statearr_21939_21964[(2)] = inst_21902);

(statearr_21939_21964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (13))){
var inst_21931 = (state_21936[(2)]);
var _ = (function (){var statearr_21940 = state_21936;
(statearr_21940[(4)] = cljs.core.rest((state_21936[(4)])));

return statearr_21940;
})();
var state_21936__$1 = state_21936;
var statearr_21941_21965 = state_21936__$1;
(statearr_21941_21965[(2)] = inst_21931);

(statearr_21941_21965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (6))){
var inst_21913 = (state_21936[(7)]);
var inst_21917 = (state_21936[(2)]);
var inst_21918 = fluree.db.util.async.throw_err(inst_21917);
var state_21936__$1 = (function (){var statearr_21942 = state_21936;
(statearr_21942[(8)] = inst_21918);

return statearr_21942;
})();
if(cljs.core.truth_(inst_21913)){
var statearr_21943_21966 = state_21936__$1;
(statearr_21943_21966[(1)] = (7));

} else {
var statearr_21944_21967 = state_21936__$1;
(statearr_21944_21967[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (3))){
var inst_21934 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21936__$1,inst_21934);
} else {
if((state_val_21937 === (12))){
var inst_21926 = (state_21936[(9)]);
var state_21936__$1 = state_21936;
var statearr_21945_21968 = state_21936__$1;
(statearr_21945_21968[(2)] = inst_21926);

(statearr_21945_21968[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (2))){
var _ = (function (){var statearr_21946 = state_21936;
(statearr_21946[(4)] = cljs.core.cons((5),(state_21936[(4)])));

return statearr_21946;
})();
var inst_21909 = q_map;
var inst_21910 = cljs.core.__destructure_map(inst_21909);
var inst_21911 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21910,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21912 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21910,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21910,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21910,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21915 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21912,q_map,inst_21911,fuel,max_fuel,opts);
var state_21936__$1 = (function (){var statearr_21947 = state_21936;
(statearr_21947[(7)] = inst_21913);

(statearr_21947[(10)] = inst_21914);

return statearr_21947;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21936__$1,(6),inst_21915);
} else {
if((state_val_21937 === (11))){
var inst_21914 = (state_21936[(10)]);
var inst_21926 = (state_21936[(9)]);
var inst_21928 = fluree.db.query.analytical.tuples__GT_filtered(inst_21926,inst_21914,null);
var state_21936__$1 = state_21936;
var statearr_21949_21969 = state_21936__$1;
(statearr_21949_21969[(2)] = inst_21928);

(statearr_21949_21969[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (9))){
var inst_21914 = (state_21936[(10)]);
var inst_21926 = (state_21936[(2)]);
var state_21936__$1 = (function (){var statearr_21950 = state_21936;
(statearr_21950[(9)] = inst_21926);

return statearr_21950;
})();
if(cljs.core.truth_(inst_21914)){
var statearr_21951_21970 = state_21936__$1;
(statearr_21951_21970[(1)] = (11));

} else {
var statearr_21952_21971 = state_21936__$1;
(statearr_21952_21971[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (5))){
var _ = (function (){var statearr_21953 = state_21936;
(statearr_21953[(4)] = cljs.core.rest((state_21936[(4)])));

return statearr_21953;
})();
var state_21936__$1 = state_21936;
var ex21948 = (state_21936__$1[(2)]);
var statearr_21954_21972 = state_21936__$1;
(statearr_21954_21972[(5)] = ex21948);


if((ex21948 instanceof Error)){
var statearr_21955_21973 = state_21936__$1;
(statearr_21955_21973[(1)] = (4));

(statearr_21955_21973[(5)] = null);

} else {
throw ex21948;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (10))){
var inst_21922 = (state_21936[(2)]);
var inst_21923 = fluree.db.util.async.throw_err(inst_21922);
var state_21936__$1 = state_21936;
var statearr_21956_21974 = state_21936__$1;
(statearr_21956_21974[(2)] = inst_21923);

(statearr_21956_21974[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (8))){
var inst_21918 = (state_21936[(8)]);
var state_21936__$1 = state_21936;
var statearr_21957_21975 = state_21936__$1;
(statearr_21957_21975[(2)] = inst_21918);

(statearr_21957_21975[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2727__auto____0 = (function (){
var statearr_21958 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21958[(0)] = fluree$db$query$analytical$q_$_state_machine__2727__auto__);

(statearr_21958[(1)] = (1));

return statearr_21958;
});
var fluree$db$query$analytical$q_$_state_machine__2727__auto____1 = (function (state_21936){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21936);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21959){var ex__2730__auto__ = e21959;
var statearr_21960_21976 = state_21936;
(statearr_21960_21976[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21936[(4)]))){
var statearr_21961_21977 = state_21936;
(statearr_21961_21977[(1)] = cljs.core.first((state_21936[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21978 = state_21936;
state_21936 = G__21978;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2727__auto__ = function(state_21936){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____1.call(this,state_21936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2727__auto____0;
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21962 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21962[(6)] = c__2749__auto__);

return statearr_21962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
