// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28766 = arguments.length;
var i__4865__auto___28767 = (0);
while(true){
if((i__4865__auto___28767 < len__4864__auto___28766)){
args__4870__auto__.push((arguments[i__4865__auto___28767]));

var G__28768 = (i__4865__auto___28767 + (1));
i__4865__auto___28767 = G__28768;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28763){
var G__28764 = cljs.core.first(seq28763);
var seq28763__$1 = cljs.core.next(seq28763);
var G__28765 = cljs.core.first(seq28763__$1);
var seq28763__$2 = cljs.core.next(seq28763__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28764,G__28765,seq28763__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28769){var e = e28769;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28770){var e = e28770;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28771){var e = e28771;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28772){var e = e28772;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28773){var e = e28773;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28776 = arguments.length;
var i__4865__auto___28777 = (0);
while(true){
if((i__4865__auto___28777 < len__4864__auto___28776)){
args__4870__auto__.push((arguments[i__4865__auto___28777]));

var G__28778 = (i__4865__auto___28777 + (1));
i__4865__auto___28777 = G__28778;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28775){var e = e28775;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28774){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28774));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28781 = arguments.length;
var i__4865__auto___28782 = (0);
while(true){
if((i__4865__auto___28782 < len__4864__auto___28781)){
args__4870__auto__.push((arguments[i__4865__auto___28782]));

var G__28783 = (i__4865__auto___28782 + (1));
i__4865__auto___28782 = G__28783;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28780){var e = e28780;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28779){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28779));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28784){var e = e28784;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28787 = arguments.length;
var i__4865__auto___28788 = (0);
while(true){
if((i__4865__auto___28788 < len__4864__auto___28787)){
args__4870__auto__.push((arguments[i__4865__auto___28788]));

var G__28789 = (i__4865__auto___28788 + (1));
i__4865__auto___28788 = G__28789;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28786){var e = e28786;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28785){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28785));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28792 = arguments.length;
var i__4865__auto___28793 = (0);
while(true){
if((i__4865__auto___28793 < len__4864__auto___28792)){
args__4870__auto__.push((arguments[i__4865__auto___28793]));

var G__28794 = (i__4865__auto___28793 + (1));
i__4865__auto___28793 = G__28794;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e28791){var e = e28791;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28790){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28790));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28795){var e = e28795;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28796){var e = e28796;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28799 = arguments.length;
var i__4865__auto___28800 = (0);
while(true){
if((i__4865__auto___28800 < len__4864__auto___28799)){
args__4870__auto__.push((arguments[i__4865__auto___28800]));

var G__28801 = (i__4865__auto___28800 + (1));
i__4865__auto___28800 = G__28801;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28798){var e = e28798;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28797){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28797));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28804 = arguments.length;
var i__4865__auto___28805 = (0);
while(true){
if((i__4865__auto___28805 < len__4864__auto___28804)){
args__4870__auto__.push((arguments[i__4865__auto___28805]));

var G__28806 = (i__4865__auto___28805 + (1));
i__4865__auto___28805 = G__28806;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28803){var e = e28803;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28802){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28802));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28809 = arguments.length;
var i__4865__auto___28810 = (0);
while(true){
if((i__4865__auto___28810 < len__4864__auto___28809)){
args__4870__auto__.push((arguments[i__4865__auto___28810]));

var G__28811 = (i__4865__auto___28810 + (1));
i__4865__auto___28810 = G__28811;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28808){var e = e28808;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28807){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28807));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28814 = arguments.length;
var i__4865__auto___28815 = (0);
while(true){
if((i__4865__auto___28815 < len__4864__auto___28814)){
args__4870__auto__.push((arguments[i__4865__auto___28815]));

var G__28816 = (i__4865__auto___28815 + (1));
i__4865__auto___28815 = G__28816;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28813){var e = e28813;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28812){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28812));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28819 = arguments.length;
var i__4865__auto___28820 = (0);
while(true){
if((i__4865__auto___28820 < len__4864__auto___28819)){
args__4870__auto__.push((arguments[i__4865__auto___28820]));

var G__28821 = (i__4865__auto___28820 + (1));
i__4865__auto___28820 = G__28821;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28818){var e = e28818;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28817){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28817));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28824 = arguments.length;
var i__4865__auto___28825 = (0);
while(true){
if((i__4865__auto___28825 < len__4864__auto___28824)){
args__4870__auto__.push((arguments[i__4865__auto___28825]));

var G__28826 = (i__4865__auto___28825 + (1));
i__4865__auto___28825 = G__28826;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28823){var e = e28823;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28822){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28822));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28829 = arguments.length;
var i__4865__auto___28830 = (0);
while(true){
if((i__4865__auto___28830 < len__4864__auto___28829)){
args__4870__auto__.push((arguments[i__4865__auto___28830]));

var G__28831 = (i__4865__auto___28830 + (1));
i__4865__auto___28830 = G__28831;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e28828){var e = e28828;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28827){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28827));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28833 = arguments.length;
switch (G__28833) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28861){
var state_val_28862 = (state_28861[(1)]);
if((state_val_28862 === (7))){
var inst_28846 = (state_28861[(7)]);
var inst_28849 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28846,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28861__$1 = state_28861;
var statearr_28863_28949 = state_28861__$1;
(statearr_28863_28949[(2)] = inst_28849);

(statearr_28863_28949[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (1))){
var state_28861__$1 = state_28861;
var statearr_28864_28950 = state_28861__$1;
(statearr_28864_28950[(2)] = null);

(statearr_28864_28950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (4))){
var inst_28834 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
var statearr_28865_28951 = state_28861__$1;
(statearr_28865_28951[(2)] = inst_28834);

(statearr_28865_28951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (6))){
var inst_28846 = (state_28861[(7)]);
var inst_28846__$1 = (state_28861[(2)]);
var inst_28847 = fluree.db.util.core.exception_QMARK_(inst_28846__$1);
var state_28861__$1 = (function (){var statearr_28866 = state_28861;
(statearr_28866[(7)] = inst_28846__$1);

return statearr_28866;
})();
if(inst_28847){
var statearr_28867_28952 = state_28861__$1;
(statearr_28867_28952[(1)] = (7));

} else {
var statearr_28868_28953 = state_28861__$1;
(statearr_28868_28953[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (3))){
var inst_28859 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28861__$1,inst_28859);
} else {
if((state_val_28862 === (2))){
var inst_28840 = (state_28861[(8)]);
var _ = (function (){var statearr_28870 = state_28861;
(statearr_28870[(4)] = cljs.core.cons((5),(state_28861[(4)])));

return statearr_28870;
})();
var inst_28840__$1 = cljs.core.volatile_BANG_((0));
var inst_28841 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28842 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28841,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28840__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28843 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28842);
var inst_28844 = fluree.db.query.fql.query(db,inst_28843);
var state_28861__$1 = (function (){var statearr_28871 = state_28861;
(statearr_28871[(8)] = inst_28840__$1);

return statearr_28871;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28861__$1,(6),inst_28844);
} else {
if((state_val_28862 === (9))){
var inst_28856 = (state_28861[(2)]);
var _ = (function (){var statearr_28872 = state_28861;
(statearr_28872[(4)] = cljs.core.rest((state_28861[(4)])));

return statearr_28872;
})();
var state_28861__$1 = state_28861;
var statearr_28873_28954 = state_28861__$1;
(statearr_28873_28954[(2)] = inst_28856);

(statearr_28873_28954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (5))){
var _ = (function (){var statearr_28874 = state_28861;
(statearr_28874[(4)] = cljs.core.rest((state_28861[(4)])));

return statearr_28874;
})();
var state_28861__$1 = state_28861;
var ex28869 = (state_28861__$1[(2)]);
var statearr_28875_28955 = state_28861__$1;
(statearr_28875_28955[(5)] = ex28869);


if((ex28869 instanceof Error)){
var statearr_28876_28956 = state_28861__$1;
(statearr_28876_28956[(1)] = (4));

(statearr_28876_28956[(5)] = null);

} else {
throw ex28869;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (8))){
var inst_28840 = (state_28861[(8)]);
var inst_28846 = (state_28861[(7)]);
var inst_28851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28852 = cljs.core.deref(inst_28840);
var inst_28853 = [inst_28846,inst_28852];
var inst_28854 = (new cljs.core.PersistentVector(null,2,(5),inst_28851,inst_28853,null));
var state_28861__$1 = state_28861;
var statearr_28877_28957 = state_28861__$1;
(statearr_28877_28957[(2)] = inst_28854);

(statearr_28877_28957[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28878 = [null,null,null,null,null,null,null,null,null];
(statearr_28878[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28878[(1)] = (1));

return statearr_28878;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28861){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28861);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28879){var ex__2730__auto__ = e28879;
var statearr_28880_28958 = state_28861;
(statearr_28880_28958[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28861[(4)]))){
var statearr_28881_28959 = state_28861;
(statearr_28881_28959[(1)] = cljs.core.first((state_28861[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28960 = state_28861;
state_28861 = G__28960;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28861){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28882 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28882[(6)] = c__2749__auto__);

return statearr_28882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28927){
var state_val_28928 = (state_28927[(1)]);
if((state_val_28928 === (7))){
var inst_28913 = (state_28927[(2)]);
var inst_28914 = fluree.db.query.fql.query(db,inst_28913);
var state_28927__$1 = state_28927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28927__$1,(8),inst_28914);
} else {
if((state_val_28928 === (1))){
var inst_28883 = typeof select === 'string';
var state_28927__$1 = state_28927;
if(cljs.core.truth_(inst_28883)){
var statearr_28929_28961 = state_28927__$1;
(statearr_28929_28961[(1)] = (2));

} else {
var statearr_28930_28962 = state_28927__$1;
(statearr_28930_28962[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (4))){
var inst_28896 = (state_28927[(7)]);
var inst_28889 = (state_28927[(8)]);
var inst_28888 = (state_28927[(2)]);
var inst_28889__$1 = cljs.core.volatile_BANG_((0));
var inst_28890 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28891 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28892 = [inst_28889__$1,(100000)];
var inst_28893 = cljs.core.PersistentHashMap.fromArrays(inst_28891,inst_28892);
var inst_28894 = [inst_28888,from,where,block,limit,inst_28893];
var inst_28895 = cljs.core.PersistentHashMap.fromArrays(inst_28890,inst_28894);
var inst_28896__$1 = fluree.db.util.core.without_nils(inst_28895);
var inst_28897 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28896__$1);
var inst_28898 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28896__$1);
var inst_28899 = cljs.core.first(inst_28898);
var inst_28900 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28899], 0));
var inst_28901 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28900);
var inst_28902 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28896__$1);
var inst_28903 = cljs.core.last(inst_28902);
var inst_28904 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28903], 0));
var inst_28905 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28904);
var inst_28906 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28897,inst_28901,inst_28905], 0));
var state_28927__$1 = (function (){var statearr_28931 = state_28927;
(statearr_28931[(7)] = inst_28896__$1);

(statearr_28931[(8)] = inst_28889__$1);

return statearr_28931;
})();
if(cljs.core.truth_(inst_28906)){
var statearr_28932_28963 = state_28927__$1;
(statearr_28932_28963[(1)] = (5));

} else {
var statearr_28933_28964 = state_28927__$1;
(statearr_28933_28964[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (6))){
var inst_28896 = (state_28927[(7)]);
var state_28927__$1 = state_28927;
var statearr_28934_28965 = state_28927__$1;
(statearr_28934_28965[(2)] = inst_28896);

(statearr_28934_28965[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (3))){
var state_28927__$1 = state_28927;
var statearr_28935_28966 = state_28927__$1;
(statearr_28935_28966[(2)] = select);

(statearr_28935_28966[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (2))){
var inst_28885 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28927__$1 = state_28927;
var statearr_28936_28967 = state_28927__$1;
(statearr_28936_28967[(2)] = inst_28885);

(statearr_28936_28967[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (11))){
var inst_28925 = (state_28927[(2)]);
var state_28927__$1 = state_28927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28927__$1,inst_28925);
} else {
if((state_val_28928 === (9))){
var inst_28916 = (state_28927[(9)]);
var state_28927__$1 = state_28927;
var statearr_28937_28968 = state_28927__$1;
(statearr_28937_28968[(2)] = inst_28916);

(statearr_28937_28968[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (5))){
var inst_28896 = (state_28927[(7)]);
var inst_28908 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28896);
var inst_28909 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28908);
var inst_28910 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28896,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28909);
var state_28927__$1 = state_28927;
var statearr_28938_28969 = state_28927__$1;
(statearr_28938_28969[(2)] = inst_28910);

(statearr_28938_28969[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (10))){
var inst_28889 = (state_28927[(8)]);
var inst_28916 = (state_28927[(9)]);
var inst_28920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28921 = cljs.core.deref(inst_28889);
var inst_28922 = [inst_28916,inst_28921];
var inst_28923 = (new cljs.core.PersistentVector(null,2,(5),inst_28920,inst_28922,null));
var state_28927__$1 = state_28927;
var statearr_28939_28970 = state_28927__$1;
(statearr_28939_28970[(2)] = inst_28923);

(statearr_28939_28970[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (8))){
var inst_28916 = (state_28927[(9)]);
var inst_28916__$1 = (state_28927[(2)]);
var inst_28917 = fluree.db.util.core.exception_QMARK_(inst_28916__$1);
var state_28927__$1 = (function (){var statearr_28940 = state_28927;
(statearr_28940[(9)] = inst_28916__$1);

return statearr_28940;
})();
if(inst_28917){
var statearr_28941_28971 = state_28927__$1;
(statearr_28941_28971[(1)] = (9));

} else {
var statearr_28942_28972 = state_28927__$1;
(statearr_28942_28972[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28943 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28943[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28943[(1)] = (1));

return statearr_28943;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28927){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28927);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28944){var ex__2730__auto__ = e28944;
var statearr_28945_28973 = state_28927;
(statearr_28945_28973[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28927[(4)]))){
var statearr_28946_28974 = state_28927;
(statearr_28946_28974[(1)] = cljs.core.first((state_28927[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28975 = state_28927;
state_28927 = G__28975;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28927){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28947 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28947[(6)] = c__2749__auto__);

return statearr_28947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28979 = path;
var vec__28980 = G__28979;
var seq__28981 = cljs.core.seq(vec__28980);
var first__28982 = cljs.core.first(seq__28981);
var seq__28981__$1 = cljs.core.next(seq__28981);
var var$ = first__28982;
var r = seq__28981__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28979__$1 = G__28979;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28986 = G__28979__$1;
var seq__28987 = cljs.core.seq(vec__28986);
var first__28988 = cljs.core.first(seq__28987);
var seq__28987__$1 = cljs.core.next(seq__28987);
var var$__$1 = first__28988;
var r__$1 = seq__28987__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28989 = r__$1;
var G__28990 = n__$2;
var G__28991 = next_clauses;
G__28979__$1 = G__28989;
n__$1 = G__28990;
where_clauses__$1 = G__28991;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28992 = r__$1;
var G__28993 = next_n;
var G__28994 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28979__$1 = G__28992;
n__$1 = G__28993;
where_clauses__$1 = G__28994;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29031){
var state_val_29032 = (state_29031[(1)]);
if((state_val_29032 === (7))){
var inst_29004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29005 = [path];
var inst_29006 = (new cljs.core.PersistentVector(null,1,(5),inst_29004,inst_29005,null));
var state_29031__$1 = state_29031;
var statearr_29033_29061 = state_29031__$1;
(statearr_29033_29061[(2)] = inst_29006);

(statearr_29033_29061[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29032 === (1))){
var state_29031__$1 = state_29031;
var statearr_29034_29062 = state_29031__$1;
(statearr_29034_29062[(2)] = null);

(statearr_29034_29062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29032 === (4))){
var inst_28995 = (state_29031[(2)]);
var state_29031__$1 = state_29031;
var statearr_29035_29063 = state_29031__$1;
(statearr_29035_29063[(2)] = inst_28995);

(statearr_29035_29063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29032 === (13))){
var inst_29022 = (state_29031[(2)]);
var inst_29023 = fluree.db.util.async.throw_err(inst_29022);
var _ = (function (){var statearr_29036 = state_29031;
(statearr_29036[(4)] = cljs.core.rest((state_29031[(4)])));

return statearr_29036;
})();
var state_29031__$1 = state_29031;
var statearr_29037_29064 = state_29031__$1;
(statearr_29037_29064[(2)] = inst_29023);

(statearr_29037_29064[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29032 === (6))){
var state_29031__$1 = state_29031;
var statearr_29039_29065 = state_29031__$1;
(statearr_29039_29065[(2)] = path);

(statearr_29039_29065[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29032 === (3))){
var inst_29029 = (state_29031[(2)]);
var state_29031__$1 = state_29031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29031__$1,inst_29029);
} else {
if((state_val_29032 === (12))){
var _ = (function (){var statearr_29040 = state_29031;
(statearr_29040[(4)] = cljs.core.rest((state_29031[(4)])));

return statearr_29040;
})();
var state_29031__$1 = state_29031;
var ex29038 = (state_29031__$1[(2)]);
var statearr_29041_29066 = state_29031__$1;
(statearr_29041_29066[(5)] = ex29038);


var statearr_29042_29067 = state_29031__$1;
(statearr_29042_29067[(1)] = (11));

(statearr_29042_29067[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29032 === (2))){
var _ = (function (){var statearr_29043 = state_29031;
(statearr_29043[(4)] = cljs.core.cons((5),(state_29031[(4)])));

return statearr_29043;
})();
var inst_29001 = cljs.core.vector_QMARK_(path);
var state_29031__$1 = state_29031;
if(inst_29001){
var statearr_29044_29068 = state_29031__$1;
(statearr_29044_29068[(1)] = (6));

} else {
var statearr_29045_29069 = state_29031__$1;
(statearr_29045_29069[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29032 === (11))){
var inst_29008 = (state_29031[(7)]);
var inst_29013 = (state_29031[(2)]);
var inst_29014 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29013,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_29008,endSubject], 0));
var state_29031__$1 = state_29031;
var statearr_29047_29070 = state_29031__$1;
(statearr_29047_29070[(2)] = inst_29014);

(statearr_29047_29070[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29032 === (9))){
var inst_29012 = (state_29031[(8)]);
var _ = (function (){var statearr_29048 = state_29031;
(statearr_29048[(4)] = cljs.core.cons((12),(state_29031[(4)])));

return statearr_29048;
})();
var inst_29020 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_29012);
var state_29031__$1 = state_29031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29031__$1,(13),inst_29020);
} else {
if((state_val_29032 === (5))){
var _ = (function (){var statearr_29049 = state_29031;
(statearr_29049[(4)] = cljs.core.rest((state_29031[(4)])));

return statearr_29049;
})();
var state_29031__$1 = state_29031;
var ex29046 = (state_29031__$1[(2)]);
var statearr_29050_29071 = state_29031__$1;
(statearr_29050_29071[(5)] = ex29046);


if((ex29046 instanceof Error)){
var statearr_29051_29072 = state_29031__$1;
(statearr_29051_29072[(1)] = (4));

(statearr_29051_29072[(5)] = null);

} else {
throw ex29046;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29032 === (10))){
var inst_29026 = (state_29031[(2)]);
var _ = (function (){var statearr_29052 = state_29031;
(statearr_29052[(4)] = cljs.core.rest((state_29031[(4)])));

return statearr_29052;
})();
var state_29031__$1 = state_29031;
var statearr_29053_29073 = state_29031__$1;
(statearr_29053_29073[(2)] = inst_29026);

(statearr_29053_29073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29032 === (8))){
var inst_29008 = (state_29031[(7)]);
var inst_29008__$1 = (state_29031[(2)]);
var inst_29009 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_29008__$1,endSubject);
var inst_29010 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_29011 = ["?var1",inst_29009];
var inst_29012 = cljs.core.PersistentHashMap.fromArrays(inst_29010,inst_29011);
var state_29031__$1 = (function (){var statearr_29054 = state_29031;
(statearr_29054[(7)] = inst_29008__$1);

(statearr_29054[(8)] = inst_29012);

return statearr_29054;
})();
var statearr_29055_29074 = state_29031__$1;
(statearr_29055_29074[(2)] = null);

(statearr_29055_29074[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_29056 = [null,null,null,null,null,null,null,null,null];
(statearr_29056[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_29056[(1)] = (1));

return statearr_29056;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_29031){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29031);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29057){var ex__2730__auto__ = e29057;
var statearr_29058_29075 = state_29031;
(statearr_29058_29075[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29031[(4)]))){
var statearr_29059_29076 = state_29031;
(statearr_29059_29076[(1)] = cljs.core.first((state_29031[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29077 = state_29031;
state_29031 = G__29077;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = function(state_29031){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_29031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29060 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29060[(6)] = c__2749__auto__);

return statearr_29060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e29078){var e = e29078;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e29079){var e = e29079;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e29080){var e = e29080;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e29081){var e = e29081;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29084 = arguments.length;
var i__4865__auto___29085 = (0);
while(true){
if((i__4865__auto___29085 < len__4864__auto___29084)){
args__4870__auto__.push((arguments[i__4865__auto___29085]));

var G__29086 = (i__4865__auto___29085 + (1));
i__4865__auto___29085 = G__29086;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e29083){var e = e29083;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq29082){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29082));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29089 = arguments.length;
var i__4865__auto___29090 = (0);
while(true){
if((i__4865__auto___29090 < len__4864__auto___29089)){
args__4870__auto__.push((arguments[i__4865__auto___29090]));

var G__29091 = (i__4865__auto___29090 + (1));
i__4865__auto___29090 = G__29091;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e29088){var e = e29088;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq29087){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29087));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29094 = arguments.length;
var i__4865__auto___29095 = (0);
while(true){
if((i__4865__auto___29095 < len__4864__auto___29094)){
args__4870__auto__.push((arguments[i__4865__auto___29095]));

var G__29096 = (i__4865__auto___29095 + (1));
i__4865__auto___29095 = G__29096;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4253__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e29093){var e = e29093;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq29092){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29092));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29099 = arguments.length;
var i__4865__auto___29100 = (0);
while(true){
if((i__4865__auto___29100 < len__4864__auto___29099)){
args__4870__auto__.push((arguments[i__4865__auto___29100]));

var G__29101 = (i__4865__auto___29100 + (1));
i__4865__auto___29100 = G__29101;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e29098){var e = e29098;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq29097){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29097));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e29102){var e = e29102;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e29103){var e = e29103;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e29104){var e = e29104;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e29105){var e = e29105;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e29106){var e = e29106;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__29112 = path;
var vec__29113 = G__29112;
var seq__29114 = cljs.core.seq(vec__29113);
var first__29115 = cljs.core.first(seq__29114);
var seq__29114__$1 = cljs.core.next(seq__29114);
var pred = first__29115;
var r = seq__29114__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__29112__$1 = G__29112;
var subjects__$1 = subjects;
while(true){
var vec__29119 = G__29112__$1;
var seq__29120 = cljs.core.seq(vec__29119);
var first__29121 = cljs.core.first(seq__29120);
var seq__29120__$1 = cljs.core.next(seq__29120);
var pred__$1 = first__29121;
var r__$1 = seq__29120__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__29112__$1,subjects__$1,vec__29119,seq__29120,first__29121,seq__29120__$1,pred__$1,r__$1,subjects__$2,G__29112,vec__29113,seq__29114,first__29115,seq__29114__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__29112__$1,subjects__$1,vec__29119,seq__29120,first__29121,seq__29120__$1,pred__$1,r__$1,subjects__$2,G__29112,vec__29113,seq__29114,first__29115,seq__29114__$1,pred,r,subjects){
return (function (p1__29107_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__29107_SHARP_,pred__$1);
});})(G__29112__$1,subjects__$1,vec__29119,seq__29120,first__29121,seq__29120__$1,pred__$1,r__$1,subjects__$2,G__29112,vec__29113,seq__29114,first__29115,seq__29114__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__29112__$1,subjects__$1,vec__29119,seq__29120,first__29121,seq__29120__$1,pred__$1,r__$1,subjects__$2,G__29112,vec__29113,seq__29114,first__29115,seq__29114__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4251__auto__ = r__$1;
if(and__4251__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4251__auto__;
}
})())){
var G__29122 = r__$1;
var G__29123 = next_subjects;
G__29112__$1 = G__29122;
subjects__$1 = G__29123;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e29108){var e = e29108;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e29124){var e = e29124;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e29125){var e = e29125;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29128 = arguments.length;
var i__4865__auto___29129 = (0);
while(true){
if((i__4865__auto___29129 < len__4864__auto___29128)){
args__4870__auto__.push((arguments[i__4865__auto___29129]));

var G__29130 = (i__4865__auto___29129 + (1));
i__4865__auto___29129 = G__29130;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e29127){var e = e29127;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq29126){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29126));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e29131){var e = e29131;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29134 = arguments.length;
var i__4865__auto___29135 = (0);
while(true){
if((i__4865__auto___29135 < len__4864__auto___29134)){
args__4870__auto__.push((arguments[i__4865__auto___29135]));

var G__29136 = (i__4865__auto___29135 + (1));
i__4865__auto___29135 = G__29136;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e29133){var e = e29133;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq29132){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29132));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e29137){var e = e29137;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29194){
var state_val_29195 = (state_29194[(1)]);
if((state_val_29195 === (7))){
var inst_29140 = (state_29194[(2)]);
var state_29194__$1 = state_29194;
var statearr_29196_29230 = state_29194__$1;
(statearr_29196_29230[(2)] = inst_29140);

(statearr_29196_29230[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (1))){
var state_29194__$1 = state_29194;
var statearr_29197_29231 = state_29194__$1;
(statearr_29197_29231[(2)] = null);

(statearr_29197_29231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (4))){
var inst_29139 = (state_29194[(2)]);
var state_29194__$1 = (function (){var statearr_29198 = state_29194;
(statearr_29198[(7)] = inst_29139);

return statearr_29198;
})();
var statearr_29199_29232 = state_29194__$1;
(statearr_29199_29232[(2)] = null);

(statearr_29199_29232[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (15))){
var inst_29162 = (state_29194[(8)]);
var inst_29177 = (state_29194[(9)]);
var inst_29165 = (state_29194[(10)]);
var inst_29175 = (state_29194[(11)]);
var inst_29174 = (state_29194[(12)]);
var inst_29164 = (state_29194[(13)]);
var inst_29181 = (function (){var db = inst_29162;
var prevT = inst_29164;
var db_SINGLEQUOTE_ = inst_29165;
var prev_vals = inst_29174;
var fuel = inst_29175;
var G__29176 = inst_29177;
return (function (p1__29138_SHARP_){
var f = p1__29138_SHARP_;
return f.o;
});
})();
var inst_29182 = (inst_29181.cljs$core$IFn$_invoke$arity$1 ? inst_29181.cljs$core$IFn$_invoke$arity$1(inst_29177) : inst_29181.call(null,inst_29177));
var state_29194__$1 = state_29194;
var statearr_29200_29233 = state_29194__$1;
(statearr_29200_29233[(2)] = inst_29182);

(statearr_29200_29233[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (13))){
var inst_29177 = (state_29194[(9)]);
var inst_29174 = (state_29194[(12)]);
var inst_29173 = (state_29194[(2)]);
var inst_29174__$1 = fluree.db.util.async.throw_err(inst_29173);
var inst_29175 = fluree.db.dbfunctions.internal.count(inst_29174__$1);
var inst_29177__$1 = cljs.core.first(inst_29174__$1);
var inst_29178 = (inst_29177__$1 == null);
var state_29194__$1 = (function (){var statearr_29201 = state_29194;
(statearr_29201[(9)] = inst_29177__$1);

(statearr_29201[(11)] = inst_29175);

(statearr_29201[(12)] = inst_29174__$1);

return statearr_29201;
})();
if(cljs.core.truth_(inst_29178)){
var statearr_29202_29234 = state_29194__$1;
(statearr_29202_29234[(1)] = (14));

} else {
var statearr_29203_29235 = state_29194__$1;
(statearr_29203_29235[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (6))){
var inst_29149 = (state_29194[(2)]);
var state_29194__$1 = state_29194;
var statearr_29204_29236 = state_29194__$1;
(statearr_29204_29236[(2)] = inst_29149);

(statearr_29204_29236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (3))){
var inst_29192 = (state_29194[(2)]);
var state_29194__$1 = state_29194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29194__$1,inst_29192);
} else {
if((state_val_29195 === (12))){
var inst_29189 = (state_29194[(2)]);
var _ = (function (){var statearr_29205 = state_29194;
(statearr_29205[(4)] = cljs.core.rest((state_29194[(4)])));

return statearr_29205;
})();
var state_29194__$1 = state_29194;
var statearr_29206_29237 = state_29194__$1;
(statearr_29206_29237[(2)] = inst_29189);

(statearr_29206_29237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (2))){
var _ = (function (){var statearr_29208 = state_29194;
(statearr_29208[(4)] = cljs.core.cons((9),(state_29194[(4)])));

return statearr_29208;
})();
var inst_29155 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29156 = typeof inst_29155 === 'string';
var state_29194__$1 = state_29194;
if(cljs.core.truth_(inst_29156)){
var statearr_29209_29238 = state_29194__$1;
(statearr_29209_29238[(1)] = (10));

} else {
var statearr_29210_29239 = state_29194__$1;
(statearr_29210_29239[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (11))){
var inst_29162 = (state_29194[(8)]);
var inst_29165 = (state_29194[(10)]);
var inst_29164 = (state_29194[(13)]);
var inst_29162__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29163 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_29162__$1);
var inst_29164__$1 = fluree.db.dbfunctions.internal.inc(inst_29163);
var inst_29165__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29162__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_29164__$1);
var inst_29166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29167 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29168 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29169 = [inst_29167,inst_29168];
var inst_29170 = (new cljs.core.PersistentVector(null,2,(5),inst_29166,inst_29169,null));
var inst_29171 = fluree.db.dbproto._search(inst_29165__$1,inst_29170);
var state_29194__$1 = (function (){var statearr_29211 = state_29194;
(statearr_29211[(8)] = inst_29162__$1);

(statearr_29211[(10)] = inst_29165__$1);

(statearr_29211[(13)] = inst_29164__$1);

return statearr_29211;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29194__$1,(13),inst_29171);
} else {
if((state_val_29195 === (9))){
var _ = (function (){var statearr_29212 = state_29194;
(statearr_29212[(4)] = cljs.core.rest((state_29194[(4)])));

return statearr_29212;
})();
var state_29194__$1 = state_29194;
var ex29207 = (state_29194__$1[(2)]);
var statearr_29213_29240 = state_29194__$1;
(statearr_29213_29240[(5)] = ex29207);


var statearr_29214_29241 = state_29194__$1;
(statearr_29214_29241[(1)] = (4));

(statearr_29214_29241[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (5))){
var inst_29139 = (state_29194[(7)]);
var _ = (function (){var statearr_29215 = state_29194;
(statearr_29215[(4)] = cljs.core.cons((8),(state_29194[(4)])));

return statearr_29215;
})();
var inst_29146 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29139,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_29216 = state_29194;
(statearr_29216[(4)] = cljs.core.rest((state_29194[(4)])));

return statearr_29216;
})();
var state_29194__$1 = state_29194;
var statearr_29217_29242 = state_29194__$1;
(statearr_29217_29242[(2)] = inst_29146);

(statearr_29217_29242[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (14))){
var state_29194__$1 = state_29194;
var statearr_29218_29243 = state_29194__$1;
(statearr_29218_29243[(2)] = null);

(statearr_29218_29243[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (16))){
var inst_29175 = (state_29194[(11)]);
var inst_29184 = (state_29194[(2)]);
var inst_29185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29186 = [inst_29184,inst_29175];
var inst_29187 = (new cljs.core.PersistentVector(null,2,(5),inst_29185,inst_29186,null));
var state_29194__$1 = state_29194;
var statearr_29220_29244 = state_29194__$1;
(statearr_29220_29244[(2)] = inst_29187);

(statearr_29220_29244[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (10))){
var inst_29158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29159 = [null,(0)];
var inst_29160 = (new cljs.core.PersistentVector(null,2,(5),inst_29158,inst_29159,null));
var state_29194__$1 = state_29194;
var statearr_29221_29245 = state_29194__$1;
(statearr_29221_29245[(2)] = inst_29160);

(statearr_29221_29245[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (8))){
var _ = (function (){var statearr_29222 = state_29194;
(statearr_29222[(4)] = cljs.core.rest((state_29194[(4)])));

return statearr_29222;
})();
var state_29194__$1 = state_29194;
var ex29219 = (state_29194__$1[(2)]);
var statearr_29223_29246 = state_29194__$1;
(statearr_29223_29246[(5)] = ex29219);


var statearr_29224_29247 = state_29194__$1;
(statearr_29224_29247[(1)] = (7));

(statearr_29224_29247[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_29225 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29225[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_29225[(1)] = (1));

return statearr_29225;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_29194){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29194);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29226){var ex__2730__auto__ = e29226;
var statearr_29227_29248 = state_29194;
(statearr_29227_29248[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29194[(4)]))){
var statearr_29228_29249 = state_29194;
(statearr_29228_29249[(1)] = cljs.core.first((state_29194[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29250 = state_29194;
state_29194 = G__29250;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = function(state_29194){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_29194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29229 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29229[(6)] = c__2749__auto__);

return statearr_29229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29302){
var state_val_29303 = (state_29302[(1)]);
if((state_val_29303 === (7))){
var inst_29252 = (state_29302[(2)]);
var state_29302__$1 = state_29302;
var statearr_29304_29333 = state_29302__$1;
(statearr_29304_29333[(2)] = inst_29252);

(statearr_29304_29333[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (1))){
var state_29302__$1 = state_29302;
var statearr_29305_29334 = state_29302__$1;
(statearr_29305_29334[(2)] = null);

(statearr_29305_29334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (4))){
var inst_29251 = (state_29302[(2)]);
var state_29302__$1 = (function (){var statearr_29306 = state_29302;
(statearr_29306[(7)] = inst_29251);

return statearr_29306;
})();
var statearr_29307_29335 = state_29302__$1;
(statearr_29307_29335[(2)] = null);

(statearr_29307_29335[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (13))){
var inst_29297 = (state_29302[(2)]);
var _ = (function (){var statearr_29308 = state_29302;
(statearr_29308[(4)] = cljs.core.rest((state_29302[(4)])));

return statearr_29308;
})();
var state_29302__$1 = state_29302;
var statearr_29309_29336 = state_29302__$1;
(statearr_29309_29336[(2)] = inst_29297);

(statearr_29309_29336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (6))){
var inst_29261 = (state_29302[(2)]);
var state_29302__$1 = state_29302;
var statearr_29310_29337 = state_29302__$1;
(statearr_29310_29337[(2)] = inst_29261);

(statearr_29310_29337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (3))){
var inst_29300 = (state_29302[(2)]);
var state_29302__$1 = state_29302;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29302__$1,inst_29300);
} else {
if((state_val_29303 === (12))){
var inst_29284 = (state_29302[(8)]);
var inst_29293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29294 = [null,inst_29284];
var inst_29295 = (new cljs.core.PersistentVector(null,2,(5),inst_29293,inst_29294,null));
var state_29302__$1 = state_29302;
var statearr_29311_29338 = state_29302__$1;
(statearr_29311_29338[(2)] = inst_29295);

(statearr_29311_29338[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (2))){
var _ = (function (){var statearr_29313 = state_29302;
(statearr_29313[(4)] = cljs.core.cons((9),(state_29302[(4)])));

return statearr_29313;
})();
var inst_29270 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29273 = [null,pred_name,"?o"];
var inst_29274 = (new cljs.core.PersistentVector(null,3,(5),inst_29272,inst_29273,null));
var inst_29275 = [inst_29274];
var inst_29276 = (new cljs.core.PersistentVector(null,1,(5),inst_29271,inst_29275,null));
var inst_29277 = ["?o",inst_29276,opts];
var inst_29278 = cljs.core.PersistentHashMap.fromArrays(inst_29270,inst_29277);
var inst_29279 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_29278);
var state_29302__$1 = state_29302;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29302__$1,(10),inst_29279);
} else {
if((state_val_29303 === (11))){
var inst_29283 = (state_29302[(9)]);
var inst_29284 = (state_29302[(8)]);
var inst_29288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29289 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_29283);
var inst_29290 = [inst_29289,inst_29284];
var inst_29291 = (new cljs.core.PersistentVector(null,2,(5),inst_29288,inst_29290,null));
var state_29302__$1 = state_29302;
var statearr_29314_29339 = state_29302__$1;
(statearr_29314_29339[(2)] = inst_29291);

(statearr_29314_29339[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (9))){
var _ = (function (){var statearr_29315 = state_29302;
(statearr_29315[(4)] = cljs.core.rest((state_29302[(4)])));

return statearr_29315;
})();
var state_29302__$1 = state_29302;
var ex29312 = (state_29302__$1[(2)]);
var statearr_29316_29340 = state_29302__$1;
(statearr_29316_29340[(5)] = ex29312);


var statearr_29317_29341 = state_29302__$1;
(statearr_29317_29341[(1)] = (4));

(statearr_29317_29341[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (5))){
var inst_29251 = (state_29302[(7)]);
var _ = (function (){var statearr_29319 = state_29302;
(statearr_29319[(4)] = cljs.core.cons((8),(state_29302[(4)])));

return statearr_29319;
})();
var inst_29258 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29251,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_29320 = state_29302;
(statearr_29320[(4)] = cljs.core.rest((state_29302[(4)])));

return statearr_29320;
})();
var state_29302__$1 = state_29302;
var statearr_29321_29342 = state_29302__$1;
(statearr_29321_29342[(2)] = inst_29258);

(statearr_29321_29342[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (10))){
var inst_29283 = (state_29302[(9)]);
var inst_29281 = (state_29302[(2)]);
var inst_29282 = fluree.db.util.async.throw_err(inst_29281);
var inst_29283__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29282,(0),null);
var inst_29284 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29282,(1),null);
var inst_29285 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_29283__$1);
var inst_29286 = cljs.core.not(inst_29285);
var state_29302__$1 = (function (){var statearr_29322 = state_29302;
(statearr_29322[(9)] = inst_29283__$1);

(statearr_29322[(8)] = inst_29284);

return statearr_29322;
})();
if(inst_29286){
var statearr_29323_29343 = state_29302__$1;
(statearr_29323_29343[(1)] = (11));

} else {
var statearr_29324_29344 = state_29302__$1;
(statearr_29324_29344[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (8))){
var _ = (function (){var statearr_29325 = state_29302;
(statearr_29325[(4)] = cljs.core.rest((state_29302[(4)])));

return statearr_29325;
})();
var state_29302__$1 = state_29302;
var ex29318 = (state_29302__$1[(2)]);
var statearr_29326_29345 = state_29302__$1;
(statearr_29326_29345[(5)] = ex29318);


var statearr_29327_29346 = state_29302__$1;
(statearr_29327_29346[(1)] = (7));

(statearr_29327_29346[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_29328 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29328[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__);

(statearr_29328[(1)] = (1));

return statearr_29328;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1 = (function (state_29302){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29302);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29329){var ex__2730__auto__ = e29329;
var statearr_29330_29347 = state_29302;
(statearr_29330_29347[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29302[(4)]))){
var statearr_29331_29348 = state_29302;
(statearr_29331_29348[(1)] = cljs.core.first((state_29302[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29349 = state_29302;
state_29302 = G__29349;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = function(state_29302){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1.call(this,state_29302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29332 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29332[(6)] = c__2749__auto__);

return statearr_29332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4251__auto__ = typeof email === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4251__auto__;
}
})());
}catch (e29350){var e = e29350;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29352 = arguments.length;
switch (G__29352) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29422){
var state_val_29423 = (state_29422[(1)]);
if((state_val_29423 === (7))){
var inst_29354 = (state_29422[(2)]);
var state_29422__$1 = state_29422;
var statearr_29424_29468 = state_29422__$1;
(statearr_29424_29468[(2)] = inst_29354);

(statearr_29424_29468[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (20))){
var inst_29398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29399 = ["*"];
var inst_29400 = (new cljs.core.PersistentVector(null,1,(5),inst_29398,inst_29399,null));
var state_29422__$1 = state_29422;
var statearr_29425_29469 = state_29422__$1;
(statearr_29425_29469[(2)] = inst_29400);

(statearr_29425_29469[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (1))){
var state_29422__$1 = state_29422;
var statearr_29426_29470 = state_29422__$1;
(statearr_29426_29470[(2)] = null);

(statearr_29426_29470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (4))){
var inst_29353 = (state_29422[(2)]);
var state_29422__$1 = (function (){var statearr_29427 = state_29422;
(statearr_29427[(7)] = inst_29353);

return statearr_29427;
})();
var statearr_29428_29471 = state_29422__$1;
(statearr_29428_29471[(2)] = null);

(statearr_29428_29471[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (15))){
var inst_29417 = (state_29422[(2)]);
var _ = (function (){var statearr_29429 = state_29422;
(statearr_29429[(4)] = cljs.core.rest((state_29422[(4)])));

return statearr_29429;
})();
var state_29422__$1 = state_29422;
var statearr_29430_29472 = state_29422__$1;
(statearr_29430_29472[(2)] = inst_29417);

(statearr_29430_29472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (21))){
var inst_29381 = (state_29422[(8)]);
var inst_29388 = (state_29422[(9)]);
var inst_29402 = (state_29422[(2)]);
var inst_29403 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29404 = cljs.core.PersistentHashMap.EMPTY;
var inst_29405 = [inst_29402,inst_29388,inst_29404];
var inst_29406 = cljs.core.PersistentHashMap.fromArrays(inst_29403,inst_29405);
var inst_29407 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29381,inst_29406);
var state_29422__$1 = state_29422;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29422__$1,(22),inst_29407);
} else {
if((state_val_29423 === (13))){
var inst_29376 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29422__$1 = state_29422;
var statearr_29431_29473 = state_29422__$1;
(statearr_29431_29473[(2)] = inst_29376);

(statearr_29431_29473[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (22))){
var inst_29409 = (state_29422[(2)]);
var inst_29410 = fluree.db.util.async.throw_err(inst_29409);
var inst_29411 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29410,(0),null);
var inst_29412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29410,(1),null);
var inst_29413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29414 = [inst_29411,inst_29412];
var inst_29415 = (new cljs.core.PersistentVector(null,2,(5),inst_29413,inst_29414,null));
var state_29422__$1 = state_29422;
var statearr_29432_29474 = state_29422__$1;
(statearr_29432_29474[(2)] = inst_29415);

(statearr_29432_29474[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (6))){
var inst_29363 = (state_29422[(2)]);
var state_29422__$1 = state_29422;
var statearr_29433_29475 = state_29422__$1;
(statearr_29433_29475[(2)] = inst_29363);

(statearr_29433_29475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (17))){
var inst_29385 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29386 = fluree.db.dbfunctions.internal.get(inst_29385,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29422__$1 = state_29422;
var statearr_29434_29476 = state_29422__$1;
(statearr_29434_29476[(2)] = inst_29386);

(statearr_29434_29476[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (3))){
var inst_29420 = (state_29422[(2)]);
var state_29422__$1 = state_29422;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29422__$1,inst_29420);
} else {
if((state_val_29423 === (12))){
var inst_29374 = (state_29422[(2)]);
var state_29422__$1 = state_29422;
if(cljs.core.truth_(inst_29374)){
var statearr_29435_29477 = state_29422__$1;
(statearr_29435_29477[(1)] = (13));

} else {
var statearr_29436_29478 = state_29422__$1;
(statearr_29436_29478[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (2))){
var inst_29369 = (state_29422[(10)]);
var _ = (function (){var statearr_29437 = state_29422;
(statearr_29437[(4)] = cljs.core.cons((9),(state_29422[(4)])));

return statearr_29437;
})();
var inst_29369__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29422__$1 = (function (){var statearr_29438 = state_29422;
(statearr_29438[(10)] = inst_29369__$1);

return statearr_29438;
})();
if(cljs.core.truth_(inst_29369__$1)){
var statearr_29439_29479 = state_29422__$1;
(statearr_29439_29479[(1)] = (10));

} else {
var statearr_29440_29480 = state_29422__$1;
(statearr_29440_29480[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (19))){
var inst_29390 = cljs.core.PersistentVector.EMPTY;
var inst_29391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29392 = ["*"];
var inst_29393 = (new cljs.core.PersistentVector(null,1,(5),inst_29391,inst_29392,null));
var inst_29394 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29395 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29393,inst_29394);
var inst_29396 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29390,inst_29395);
var state_29422__$1 = state_29422;
var statearr_29442_29481 = state_29422__$1;
(statearr_29442_29481[(2)] = inst_29396);

(statearr_29442_29481[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (11))){
var inst_29369 = (state_29422[(10)]);
var state_29422__$1 = state_29422;
var statearr_29443_29482 = state_29422__$1;
(statearr_29443_29482[(2)] = inst_29369);

(statearr_29443_29482[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (9))){
var _ = (function (){var statearr_29444 = state_29422;
(statearr_29444[(4)] = cljs.core.rest((state_29422[(4)])));

return statearr_29444;
})();
var state_29422__$1 = state_29422;
var ex29441 = (state_29422__$1[(2)]);
var statearr_29445_29483 = state_29422__$1;
(statearr_29445_29483[(5)] = ex29441);


var statearr_29446_29484 = state_29422__$1;
(statearr_29446_29484[(1)] = (4));

(statearr_29446_29484[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (5))){
var inst_29353 = (state_29422[(7)]);
var _ = (function (){var statearr_29447 = state_29422;
(statearr_29447[(4)] = cljs.core.cons((8),(state_29422[(4)])));

return statearr_29447;
})();
var inst_29360 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29353,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_29448 = state_29422;
(statearr_29448[(4)] = cljs.core.rest((state_29422[(4)])));

return statearr_29448;
})();
var state_29422__$1 = state_29422;
var statearr_29449_29485 = state_29422__$1;
(statearr_29449_29485[(2)] = inst_29360);

(statearr_29449_29485[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (14))){
var inst_29382 = (state_29422[(11)]);
var inst_29381 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29382__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29422__$1 = (function (){var statearr_29450 = state_29422;
(statearr_29450[(8)] = inst_29381);

(statearr_29450[(11)] = inst_29382__$1);

return statearr_29450;
})();
if(cljs.core.truth_(inst_29382__$1)){
var statearr_29451_29486 = state_29422__$1;
(statearr_29451_29486[(1)] = (16));

} else {
var statearr_29452_29487 = state_29422__$1;
(statearr_29452_29487[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (16))){
var inst_29382 = (state_29422[(11)]);
var state_29422__$1 = state_29422;
var statearr_29453_29488 = state_29422__$1;
(statearr_29453_29488[(2)] = inst_29382);

(statearr_29453_29488[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (10))){
var inst_29371 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_29422__$1 = state_29422;
var statearr_29455_29489 = state_29422__$1;
(statearr_29455_29489[(2)] = inst_29371);

(statearr_29455_29489[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (18))){
var inst_29388 = (state_29422[(2)]);
var state_29422__$1 = (function (){var statearr_29456 = state_29422;
(statearr_29456[(9)] = inst_29388);

return statearr_29456;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29457_29490 = state_29422__$1;
(statearr_29457_29490[(1)] = (19));

} else {
var statearr_29458_29491 = state_29422__$1;
(statearr_29458_29491[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29423 === (8))){
var _ = (function (){var statearr_29459 = state_29422;
(statearr_29459[(4)] = cljs.core.rest((state_29422[(4)])));

return statearr_29459;
})();
var state_29422__$1 = state_29422;
var ex29454 = (state_29422__$1[(2)]);
var statearr_29460_29492 = state_29422__$1;
(statearr_29460_29492[(5)] = ex29454);


var statearr_29461_29493 = state_29422__$1;
(statearr_29461_29493[(1)] = (7));

(statearr_29461_29493[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_29462 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29462[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_29462[(1)] = (1));

return statearr_29462;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_29422){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29422);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29463){var ex__2730__auto__ = e29463;
var statearr_29464_29494 = state_29422;
(statearr_29464_29494[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29422[(4)]))){
var statearr_29465_29495 = state_29422;
(statearr_29465_29495[(1)] = cljs.core.first((state_29422[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29496 = state_29422;
state_29422 = G__29496;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_29422){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_29422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29466 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29466[(6)] = c__2749__auto__);

return statearr_29466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29498 = arguments.length;
switch (G__29498) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29542){
var state_val_29543 = (state_29542[(1)]);
if((state_val_29543 === (7))){
var inst_29520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29521 = ["*"];
var inst_29522 = (new cljs.core.PersistentVector(null,1,(5),inst_29520,inst_29521,null));
var state_29542__$1 = state_29542;
var statearr_29544_29564 = state_29542__$1;
(statearr_29544_29564[(2)] = inst_29522);

(statearr_29544_29564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29543 === (1))){
var state_29542__$1 = state_29542;
var statearr_29545_29565 = state_29542__$1;
(statearr_29545_29565[(2)] = null);

(statearr_29545_29565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29543 === (4))){
var inst_29499 = (state_29542[(2)]);
var inst_29500 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29499,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_29542__$1 = state_29542;
var statearr_29546_29566 = state_29542__$1;
(statearr_29546_29566[(2)] = inst_29500);

(statearr_29546_29566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29543 === (6))){
var inst_29512 = cljs.core.PersistentVector.EMPTY;
var inst_29513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29514 = ["*"];
var inst_29515 = (new cljs.core.PersistentVector(null,1,(5),inst_29513,inst_29514,null));
var inst_29516 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29517 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29515,inst_29516);
var inst_29518 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29512,inst_29517);
var state_29542__$1 = state_29542;
var statearr_29547_29567 = state_29542__$1;
(statearr_29547_29567[(2)] = inst_29518);

(statearr_29547_29567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29543 === (3))){
var inst_29540 = (state_29542[(2)]);
var state_29542__$1 = state_29542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29542__$1,inst_29540);
} else {
if((state_val_29543 === (2))){
var _ = (function (){var statearr_29549 = state_29542;
(statearr_29549[(4)] = cljs.core.cons((5),(state_29542[(4)])));

return statearr_29549;
})();
var inst_29509 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29510 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29542__$1 = (function (){var statearr_29550 = state_29542;
(statearr_29550[(7)] = inst_29509);

(statearr_29550[(8)] = inst_29510);

return statearr_29550;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29551_29568 = state_29542__$1;
(statearr_29551_29568[(1)] = (6));

} else {
var statearr_29552_29569 = state_29542__$1;
(statearr_29552_29569[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29543 === (9))){
var inst_29531 = (state_29542[(2)]);
var inst_29532 = fluree.db.util.async.throw_err(inst_29531);
var inst_29533 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29532,(0),null);
var inst_29534 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29532,(1),null);
var inst_29535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29536 = [inst_29533,inst_29534];
var inst_29537 = (new cljs.core.PersistentVector(null,2,(5),inst_29535,inst_29536,null));
var _ = (function (){var statearr_29553 = state_29542;
(statearr_29553[(4)] = cljs.core.rest((state_29542[(4)])));

return statearr_29553;
})();
var state_29542__$1 = state_29542;
var statearr_29554_29570 = state_29542__$1;
(statearr_29554_29570[(2)] = inst_29537);

(statearr_29554_29570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29543 === (5))){
var _ = (function (){var statearr_29555 = state_29542;
(statearr_29555[(4)] = cljs.core.rest((state_29542[(4)])));

return statearr_29555;
})();
var state_29542__$1 = state_29542;
var ex29548 = (state_29542__$1[(2)]);
var statearr_29556_29571 = state_29542__$1;
(statearr_29556_29571[(5)] = ex29548);


var statearr_29557_29572 = state_29542__$1;
(statearr_29557_29572[(1)] = (4));

(statearr_29557_29572[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29543 === (8))){
var inst_29509 = (state_29542[(7)]);
var inst_29510 = (state_29542[(8)]);
var inst_29524 = (state_29542[(2)]);
var inst_29525 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29526 = cljs.core.PersistentHashMap.EMPTY;
var inst_29527 = [inst_29524,inst_29510,inst_29526];
var inst_29528 = cljs.core.PersistentHashMap.fromArrays(inst_29525,inst_29527);
var inst_29529 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29509,inst_29528);
var state_29542__$1 = state_29542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29542__$1,(9),inst_29529);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_29558 = [null,null,null,null,null,null,null,null,null];
(statearr_29558[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_29558[(1)] = (1));

return statearr_29558;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_29542){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29542);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29559){var ex__2730__auto__ = e29559;
var statearr_29560_29573 = state_29542;
(statearr_29560_29573[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29542[(4)]))){
var statearr_29561_29574 = state_29542;
(statearr_29561_29574[(1)] = cljs.core.first((state_29542[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29575 = state_29542;
state_29542 = G__29575;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_29542){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_29542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29562 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29562[(6)] = c__2749__auto__);

return statearr_29562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29619){
var state_val_29620 = (state_29619[(1)]);
if((state_val_29620 === (1))){
var state_29619__$1 = state_29619;
var statearr_29621_29635 = state_29619__$1;
(statearr_29621_29635[(2)] = null);

(statearr_29621_29635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29620 === (2))){
var _ = (function (){var statearr_29622 = state_29619;
(statearr_29622[(4)] = cljs.core.cons((5),(state_29619[(4)])));

return statearr_29622;
})();
var inst_29586 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29588 = ["_user/_auth"];
var inst_29589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29590 = ["*"];
var inst_29591 = (new cljs.core.PersistentVector(null,1,(5),inst_29589,inst_29590,null));
var inst_29592 = [inst_29591];
var inst_29593 = cljs.core.PersistentHashMap.fromArrays(inst_29588,inst_29592);
var inst_29594 = [inst_29593];
var inst_29595 = (new cljs.core.PersistentVector(null,1,(5),inst_29587,inst_29594,null));
var inst_29596 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29597 = cljs.core.PersistentHashMap.EMPTY;
var inst_29598 = [inst_29595,inst_29596,inst_29597];
var inst_29599 = cljs.core.PersistentHashMap.fromArrays(inst_29586,inst_29598);
var inst_29600 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29601 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29600,inst_29599);
var state_29619__$1 = state_29619;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29619__$1,(6),inst_29601);
} else {
if((state_val_29620 === (3))){
var inst_29617 = (state_29619[(2)]);
var state_29619__$1 = state_29619;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29619__$1,inst_29617);
} else {
if((state_val_29620 === (4))){
var inst_29576 = (state_29619[(2)]);
var inst_29577 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29576,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29619__$1 = state_29619;
var statearr_29624_29636 = state_29619__$1;
(statearr_29624_29636[(2)] = inst_29577);

(statearr_29624_29636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29620 === (5))){
var _ = (function (){var statearr_29625 = state_29619;
(statearr_29625[(4)] = cljs.core.rest((state_29619[(4)])));

return statearr_29625;
})();
var state_29619__$1 = state_29619;
var ex29623 = (state_29619__$1[(2)]);
var statearr_29626_29637 = state_29619__$1;
(statearr_29626_29637[(5)] = ex29623);


var statearr_29627_29638 = state_29619__$1;
(statearr_29627_29638[(1)] = (4));

(statearr_29627_29638[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29620 === (6))){
var inst_29603 = (state_29619[(2)]);
var inst_29604 = fluree.db.util.async.throw_err(inst_29603);
var inst_29605 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29604,(0),null);
var inst_29606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29604,(1),null);
var inst_29607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29608 = ["_user/_auth","_id"];
var inst_29609 = (new cljs.core.PersistentVector(null,2,(5),inst_29607,inst_29608,null));
var inst_29610 = fluree.db.dbfunctions.internal.get_in(inst_29605,inst_29609);
var inst_29611 = cljs.core.first(inst_29610);
var inst_29612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29613 = [inst_29611,inst_29606];
var inst_29614 = (new cljs.core.PersistentVector(null,2,(5),inst_29612,inst_29613,null));
var _ = (function (){var statearr_29628 = state_29619;
(statearr_29628[(4)] = cljs.core.rest((state_29619[(4)])));

return statearr_29628;
})();
var state_29619__$1 = state_29619;
var statearr_29629_29639 = state_29619__$1;
(statearr_29629_29639[(2)] = inst_29614);

(statearr_29629_29639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0 = (function (){
var statearr_29630 = [null,null,null,null,null,null,null];
(statearr_29630[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__);

(statearr_29630[(1)] = (1));

return statearr_29630;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1 = (function (state_29619){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29619);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29631){var ex__2730__auto__ = e29631;
var statearr_29632_29640 = state_29619;
(statearr_29632_29640[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29619[(4)]))){
var statearr_29633_29641 = state_29619;
(statearr_29633_29641[(1)] = cljs.core.first((state_29619[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29642 = state_29619;
state_29619 = G__29642;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = function(state_29619){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1.call(this,state_29619);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29634 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29634[(6)] = c__2749__auto__);

return statearr_29634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29659){
var state_val_29660 = (state_29659[(1)]);
if((state_val_29660 === (1))){
var state_29659__$1 = state_29659;
var statearr_29661_29675 = state_29659__$1;
(statearr_29661_29675[(2)] = null);

(statearr_29661_29675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29660 === (2))){
var _ = (function (){var statearr_29662 = state_29659;
(statearr_29662[(4)] = cljs.core.cons((5),(state_29659[(4)])));

return statearr_29662;
})();
var inst_29649 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29650 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29651 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29650,inst_29649);
var state_29659__$1 = state_29659;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29659__$1,(6),inst_29651);
} else {
if((state_val_29660 === (3))){
var inst_29657 = (state_29659[(2)]);
var state_29659__$1 = state_29659;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29659__$1,inst_29657);
} else {
if((state_val_29660 === (4))){
var inst_29643 = (state_29659[(2)]);
var state_29659__$1 = state_29659;
var statearr_29664_29676 = state_29659__$1;
(statearr_29664_29676[(2)] = inst_29643);

(statearr_29664_29676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29660 === (5))){
var _ = (function (){var statearr_29665 = state_29659;
(statearr_29665[(4)] = cljs.core.rest((state_29659[(4)])));

return statearr_29665;
})();
var state_29659__$1 = state_29659;
var ex29663 = (state_29659__$1[(2)]);
var statearr_29666_29677 = state_29659__$1;
(statearr_29666_29677[(5)] = ex29663);


if((ex29663 instanceof Error)){
var statearr_29667_29678 = state_29659__$1;
(statearr_29667_29678[(1)] = (4));

(statearr_29667_29678[(5)] = null);

} else {
throw ex29663;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29660 === (6))){
var inst_29653 = (state_29659[(2)]);
var inst_29654 = fluree.db.util.async.throw_err(inst_29653);
var _ = (function (){var statearr_29668 = state_29659;
(statearr_29668[(4)] = cljs.core.rest((state_29659[(4)])));

return statearr_29668;
})();
var state_29659__$1 = state_29659;
var statearr_29669_29679 = state_29659__$1;
(statearr_29669_29679[(2)] = inst_29654);

(statearr_29669_29679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_29670 = [null,null,null,null,null,null,null];
(statearr_29670[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_29670[(1)] = (1));

return statearr_29670;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_29659){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29659);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29671){var ex__2730__auto__ = e29671;
var statearr_29672_29680 = state_29659;
(statearr_29672_29680[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29659[(4)]))){
var statearr_29673_29681 = state_29659;
(statearr_29673_29681[(1)] = cljs.core.first((state_29659[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29682 = state_29659;
state_29659 = G__29682;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_29659){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_29659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29674 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29674[(6)] = c__2749__auto__);

return statearr_29674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29683_SHARP_){
return p1__29683_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29684_SHARP_){
return p1__29684_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29685){var e = e29685;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29686_SHARP_){
return p1__29686_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29687_SHARP_){
return p1__29687_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29688){var e = e29688;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29690 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29690);
})() | (0));
return num;
}catch (e29689){var e = e29689;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29770){
var state_val_29771 = (state_29770[(1)]);
if((state_val_29771 === (7))){
var inst_29709 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29710 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29711 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29712 = cljs.core.PersistentHashMap.fromArrays(inst_29710,inst_29711);
var inst_29713 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29709,inst_29712);
var inst_29714 = (function(){throw inst_29713})();
var state_29770__$1 = state_29770;
var statearr_29772_29807 = state_29770__$1;
(statearr_29772_29807[(2)] = inst_29714);

(statearr_29772_29807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (1))){
var state_29770__$1 = state_29770;
var statearr_29773_29808 = state_29770__$1;
(statearr_29773_29808[(2)] = null);

(statearr_29773_29808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (4))){
var inst_29691 = (state_29770[(2)]);
var state_29770__$1 = state_29770;
var statearr_29774_29809 = state_29770__$1;
(statearr_29774_29809[(2)] = inst_29691);

(statearr_29774_29809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (15))){
var inst_29754 = (state_29770[(7)]);
var inst_29750 = (state_29770[(2)]);
var inst_29751 = fluree.db.util.async.throw_err(inst_29750);
var inst_29752 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29751,(0),null);
var inst_29753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29751,(1),null);
var inst_29754__$1 = cljs.core.first(inst_29752);
var inst_29755 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29754__$1,compare_val);
var state_29770__$1 = (function (){var statearr_29775 = state_29770;
(statearr_29775[(7)] = inst_29754__$1);

(statearr_29775[(8)] = inst_29753);

return statearr_29775;
})();
if(inst_29755){
var statearr_29776_29810 = state_29770__$1;
(statearr_29776_29810[(1)] = (16));

} else {
var statearr_29777_29811 = state_29770__$1;
(statearr_29777_29811[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (13))){
var state_29770__$1 = state_29770;
var statearr_29778_29812 = state_29770__$1;
(statearr_29778_29812[(2)] = null);

(statearr_29778_29812[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (6))){
var state_29770__$1 = state_29770;
var statearr_29779_29813 = state_29770__$1;
(statearr_29779_29813[(2)] = null);

(statearr_29779_29813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (17))){
var inst_29754 = (state_29770[(7)]);
var inst_29758 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29754)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29759 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29760 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29761 = cljs.core.PersistentHashMap.fromArrays(inst_29759,inst_29760);
var inst_29762 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29758,inst_29761);
var inst_29763 = (function(){throw inst_29762})();
var state_29770__$1 = state_29770;
var statearr_29780_29814 = state_29770__$1;
(statearr_29780_29814[(2)] = inst_29763);

(statearr_29780_29814[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (3))){
var inst_29768 = (state_29770[(2)]);
var state_29770__$1 = state_29770;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29770__$1,inst_29768);
} else {
if((state_val_29771 === (12))){
var inst_29706 = (state_29770[(9)]);
var inst_29729 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_29706], 0));
var inst_29730 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29731 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29732 = cljs.core.PersistentHashMap.fromArrays(inst_29730,inst_29731);
var inst_29733 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29729,inst_29732);
var inst_29734 = (function(){throw inst_29733})();
var state_29770__$1 = state_29770;
var statearr_29781_29815 = state_29770__$1;
(statearr_29781_29815[(2)] = inst_29734);

(statearr_29781_29815[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (2))){
var inst_29703 = (state_29770[(10)]);
var inst_29704 = (state_29770[(11)]);
var inst_29705 = (state_29770[(12)]);
var _ = (function (){var statearr_29782 = state_29770;
(statearr_29782[(4)] = cljs.core.cons((5),(state_29770[(4)])));

return statearr_29782;
})();
var inst_29701 = _QMARK_ctx;
var inst_29702 = cljs.core.__destructure_map(inst_29701);
var inst_29703__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29702,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29704__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29702,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29705__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29702,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29706 = fluree.db.dbproto._p_prop(inst_29705__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29704__$1);
var state_29770__$1 = (function (){var statearr_29783 = state_29770;
(statearr_29783[(9)] = inst_29706);

(statearr_29783[(10)] = inst_29703__$1);

(statearr_29783[(11)] = inst_29704__$1);

(statearr_29783[(12)] = inst_29705__$1);

return statearr_29783;
})();
if(cljs.core.truth_(inst_29703__$1)){
var statearr_29784_29816 = state_29770__$1;
(statearr_29784_29816[(1)] = (6));

} else {
var statearr_29785_29817 = state_29770__$1;
(statearr_29785_29817[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (11))){
var inst_29704 = (state_29770[(11)]);
var inst_29705 = (state_29770[(12)]);
var inst_29726 = (state_29770[(2)]);
var inst_29727 = fluree.db.dbproto._p_prop(inst_29705,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29704);
var state_29770__$1 = (function (){var statearr_29787 = state_29770;
(statearr_29787[(13)] = inst_29726);

return statearr_29787;
})();
if(cljs.core.truth_(inst_29727)){
var statearr_29788_29818 = state_29770__$1;
(statearr_29788_29818[(1)] = (12));

} else {
var statearr_29789_29819 = state_29770__$1;
(statearr_29789_29819[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (9))){
var state_29770__$1 = state_29770;
var statearr_29790_29820 = state_29770__$1;
(statearr_29790_29820[(2)] = null);

(statearr_29790_29820[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (5))){
var _ = (function (){var statearr_29791 = state_29770;
(statearr_29791[(4)] = cljs.core.rest((state_29770[(4)])));

return statearr_29791;
})();
var state_29770__$1 = state_29770;
var ex29786 = (state_29770__$1[(2)]);
var statearr_29792_29821 = state_29770__$1;
(statearr_29792_29821[(5)] = ex29786);


if((ex29786 instanceof Error)){
var statearr_29793_29822 = state_29770__$1;
(statearr_29793_29822[(1)] = (4));

(statearr_29793_29822[(5)] = null);

} else {
throw ex29786;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (14))){
var inst_29706 = (state_29770[(9)]);
var inst_29703 = (state_29770[(10)]);
var inst_29705 = (state_29770[(12)]);
var inst_29737 = (state_29770[(2)]);
var inst_29738 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29741 = [inst_29703,inst_29706,"?current-val"];
var inst_29742 = (new cljs.core.PersistentVector(null,3,(5),inst_29740,inst_29741,null));
var inst_29743 = [inst_29742];
var inst_29744 = (new cljs.core.PersistentVector(null,1,(5),inst_29739,inst_29743,null));
var inst_29745 = cljs.core.PersistentHashMap.EMPTY;
var inst_29746 = ["?current-val",inst_29744,inst_29745];
var inst_29747 = cljs.core.PersistentHashMap.fromArrays(inst_29738,inst_29746);
var inst_29748 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29705,inst_29747);
var state_29770__$1 = (function (){var statearr_29794 = state_29770;
(statearr_29794[(14)] = inst_29737);

return statearr_29794;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29770__$1,(15),inst_29748);
} else {
if((state_val_29771 === (16))){
var state_29770__$1 = state_29770;
var statearr_29795_29823 = state_29770__$1;
(statearr_29795_29823[(2)] = new_val);

(statearr_29795_29823[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (10))){
var inst_29719 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29720 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29721 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29722 = cljs.core.PersistentHashMap.fromArrays(inst_29720,inst_29721);
var inst_29723 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29719,inst_29722);
var inst_29724 = (function(){throw inst_29723})();
var state_29770__$1 = state_29770;
var statearr_29796_29824 = state_29770__$1;
(statearr_29796_29824[(2)] = inst_29724);

(statearr_29796_29824[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (18))){
var inst_29765 = (state_29770[(2)]);
var _ = (function (){var statearr_29797 = state_29770;
(statearr_29797[(4)] = cljs.core.rest((state_29770[(4)])));

return statearr_29797;
})();
var state_29770__$1 = state_29770;
var statearr_29798_29825 = state_29770__$1;
(statearr_29798_29825[(2)] = inst_29765);

(statearr_29798_29825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29771 === (8))){
var inst_29706 = (state_29770[(9)]);
var inst_29716 = (state_29770[(2)]);
var state_29770__$1 = (function (){var statearr_29799 = state_29770;
(statearr_29799[(15)] = inst_29716);

return statearr_29799;
})();
if(cljs.core.truth_(inst_29706)){
var statearr_29800_29826 = state_29770__$1;
(statearr_29800_29826[(1)] = (9));

} else {
var statearr_29801_29827 = state_29770__$1;
(statearr_29801_29827[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_29802 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29802[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__);

(statearr_29802[(1)] = (1));

return statearr_29802;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1 = (function (state_29770){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29770);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29803){var ex__2730__auto__ = e29803;
var statearr_29804_29828 = state_29770;
(statearr_29804_29828[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29770[(4)]))){
var statearr_29805_29829 = state_29770;
(statearr_29805_29829[(1)] = cljs.core.first((state_29770[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29830 = state_29770;
state_29770 = G__29830;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = function(state_29770){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1.call(this,state_29770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29806 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29806[(6)] = c__2749__auto__);

return statearr_29806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
