// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4913__auto___53208 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53259){
var state_val_53260 = (state_53259[(1)]);
if((state_val_53260 === (7))){
var inst_53254 = (state_53259[(2)]);
var _ = (function (){var statearr_53261 = state_53259;
(statearr_53261[(4)] = cljs.core.rest((state_53259[(4)])));

return statearr_53261;
})();
var state_53259__$1 = state_53259;
var statearr_53262_53289 = state_53259__$1;
(statearr_53262_53289[(2)] = inst_53254);

(statearr_53262_53289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (1))){
var state_53259__$1 = state_53259;
var statearr_53263_53290 = state_53259__$1;
(statearr_53263_53290[(2)] = null);

(statearr_53263_53290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (4))){
var inst_53209 = (state_53259[(2)]);
var state_53259__$1 = state_53259;
var statearr_53264_53291 = state_53259__$1;
(statearr_53264_53291[(2)] = inst_53209);

(statearr_53264_53291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (13))){
var inst_53250 = (state_53259[(2)]);
var state_53259__$1 = state_53259;
var statearr_53265_53292 = state_53259__$1;
(statearr_53265_53292[(2)] = inst_53250);

(statearr_53265_53292[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (6))){
var inst_53227 = (state_53259[(7)]);
var inst_53234 = (state_53259[(8)]);
var inst_53233 = cljs.core.seq(inst_53227);
var inst_53234__$1 = cljs.core.first(inst_53233);
var inst_53235 = cljs.core.next(inst_53233);
var inst_53236 = cljs.core.not(inst_53234__$1);
var state_53259__$1 = (function (){var statearr_53266 = state_53259;
(statearr_53266[(9)] = inst_53235);

(statearr_53266[(8)] = inst_53234__$1);

return statearr_53266;
})();
if(inst_53236){
var statearr_53267_53293 = state_53259__$1;
(statearr_53267_53293[(1)] = (8));

} else {
var statearr_53268_53294 = state_53259__$1;
(statearr_53268_53294[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (3))){
var inst_53257 = (state_53259[(2)]);
var state_53259__$1 = state_53259;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53259__$1,inst_53257);
} else {
if((state_val_53260 === (12))){
var inst_53228 = (state_53259[(10)]);
var inst_53235 = (state_53259[(9)]);
var inst_53234 = (state_53259[(8)]);
var inst_53247 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53228,inst_53234);
var inst_53227 = inst_53235;
var inst_53228__$1 = inst_53247;
var state_53259__$1 = (function (){var statearr_53269 = state_53259;
(statearr_53269[(10)] = inst_53228__$1);

(statearr_53269[(7)] = inst_53227);

return statearr_53269;
})();
var statearr_53270_53295 = state_53259__$1;
(statearr_53270_53295[(2)] = null);

(statearr_53270_53295[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (2))){
var _ = (function (){var statearr_53271 = state_53259;
(statearr_53271[(4)] = cljs.core.cons((5),(state_53259[(4)])));

return statearr_53271;
})();
var inst_53222 = args;
var inst_53223 = cljs.core.seq(inst_53222);
var inst_53224 = cljs.core.first(inst_53223);
var inst_53225 = cljs.core.next(inst_53223);
var inst_53226 = cljs.core.PersistentVector.EMPTY;
var inst_53227 = inst_53222;
var inst_53228 = inst_53226;
var state_53259__$1 = (function (){var statearr_53272 = state_53259;
(statearr_53272[(10)] = inst_53228);

(statearr_53272[(7)] = inst_53227);

(statearr_53272[(11)] = inst_53224);

(statearr_53272[(12)] = inst_53225);

return statearr_53272;
})();
var statearr_53273_53296 = state_53259__$1;
(statearr_53273_53296[(2)] = null);

(statearr_53273_53296[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (11))){
var inst_53234 = (state_53259[(8)]);
var state_53259__$1 = state_53259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53259__$1,(14),inst_53234);
} else {
if((state_val_53260 === (9))){
var inst_53234 = (state_53259[(8)]);
var inst_53239 = fluree.db.util.async.channel_QMARK_(inst_53234);
var state_53259__$1 = state_53259;
if(inst_53239){
var statearr_53275_53297 = state_53259__$1;
(statearr_53275_53297[(1)] = (11));

} else {
var statearr_53276_53298 = state_53259__$1;
(statearr_53276_53298[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (5))){
var _ = (function (){var statearr_53277 = state_53259;
(statearr_53277[(4)] = cljs.core.rest((state_53259[(4)])));

return statearr_53277;
})();
var state_53259__$1 = state_53259;
var ex53274 = (state_53259__$1[(2)]);
var statearr_53278_53299 = state_53259__$1;
(statearr_53278_53299[(5)] = ex53274);


if((ex53274 instanceof Error)){
var statearr_53279_53300 = state_53259__$1;
(statearr_53279_53300[(1)] = (4));

(statearr_53279_53300[(5)] = null);

} else {
throw ex53274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (14))){
var inst_53228 = (state_53259[(10)]);
var inst_53235 = (state_53259[(9)]);
var inst_53242 = (state_53259[(2)]);
var inst_53243 = fluree.db.util.async.throw_err(inst_53242);
var inst_53244 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53228,inst_53243);
var inst_53227 = inst_53235;
var inst_53228__$1 = inst_53244;
var state_53259__$1 = (function (){var statearr_53280 = state_53259;
(statearr_53280[(10)] = inst_53228__$1);

(statearr_53280[(7)] = inst_53227);

return statearr_53280;
})();
var statearr_53281_53301 = state_53259__$1;
(statearr_53281_53301[(2)] = null);

(statearr_53281_53301[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (10))){
var inst_53252 = (state_53259[(2)]);
var state_53259__$1 = state_53259;
var statearr_53282_53302 = state_53259__$1;
(statearr_53282_53302[(2)] = inst_53252);

(statearr_53282_53302[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53260 === (8))){
var inst_53228 = (state_53259[(10)]);
var state_53259__$1 = state_53259;
var statearr_53283_53303 = state_53259__$1;
(statearr_53283_53303[(2)] = inst_53228);

(statearr_53283_53303[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0 = (function (){
var statearr_53284 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53284[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__);

(statearr_53284[(1)] = (1));

return statearr_53284;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1 = (function (state_53259){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53259);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53285){var ex__2730__auto__ = e53285;
var statearr_53286_53304 = state_53259;
(statearr_53286_53304[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53259[(4)]))){
var statearr_53287_53305 = state_53259;
(statearr_53287_53305[(1)] = cljs.core.first((state_53259[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53306 = state_53259;
state_53259 = G__53306;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = function(state_53259){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1.call(this,state_53259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53288 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53288[(6)] = c__2749__auto__);

return statearr_53288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53307 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53307,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53307,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53355){
var state_val_53356 = (state_53355[(1)]);
if((state_val_53356 === (7))){
var state_53355__$1 = state_53355;
var statearr_53357_53386 = state_53355__$1;
(statearr_53357_53386[(2)] = coll);

(statearr_53357_53386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (1))){
var state_53355__$1 = state_53355;
var statearr_53358_53387 = state_53355__$1;
(statearr_53358_53387[(2)] = null);

(statearr_53358_53387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (4))){
var inst_53310 = (state_53355[(2)]);
var state_53355__$1 = state_53355;
var statearr_53359_53388 = state_53355__$1;
(statearr_53359_53388[(2)] = inst_53310);

(statearr_53359_53388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (15))){
var inst_53329 = (state_53355[(7)]);
var inst_53337 = (state_53355[(2)]);
var inst_53338 = fluree.db.dbfunctions.internal.nth(inst_53329,inst_53337);
var inst_53339 = cljs.core.count(inst_53329);
var inst_53340 = ((9) + inst_53339);
var inst_53341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53342 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53344 = [inst_53329,inst_53337];
var inst_53345 = (new cljs.core.PersistentVector(null,2,(5),inst_53343,inst_53344,null));
var inst_53346 = ["nth",inst_53345,inst_53338];
var inst_53347 = cljs.core.PersistentHashMap.fromArrays(inst_53342,inst_53346);
var inst_53348 = [inst_53347,inst_53340];
var inst_53349 = (new cljs.core.PersistentVector(null,2,(5),inst_53341,inst_53348,null));
var inst_53350 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53349);
var _ = (function (){var statearr_53360 = state_53355;
(statearr_53360[(4)] = cljs.core.rest((state_53355[(4)])));

return statearr_53360;
})();
var state_53355__$1 = (function (){var statearr_53361 = state_53355;
(statearr_53361[(8)] = inst_53350);

return statearr_53361;
})();
var statearr_53362_53389 = state_53355__$1;
(statearr_53362_53389[(2)] = inst_53338);

(statearr_53362_53389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (13))){
var state_53355__$1 = state_53355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53355__$1,(16),key);
} else {
if((state_val_53356 === (6))){
var state_53355__$1 = state_53355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53355__$1,(9),coll);
} else {
if((state_val_53356 === (3))){
var inst_53353 = (state_53355[(2)]);
var state_53355__$1 = state_53355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53355__$1,inst_53353);
} else {
if((state_val_53356 === (12))){
var inst_53329 = (state_53355[(2)]);
var inst_53330 = fluree.db.util.async.channel_QMARK_(key);
var state_53355__$1 = (function (){var statearr_53363 = state_53355;
(statearr_53363[(7)] = inst_53329);

return statearr_53363;
})();
if(inst_53330){
var statearr_53364_53390 = state_53355__$1;
(statearr_53364_53390[(1)] = (13));

} else {
var statearr_53365_53391 = state_53355__$1;
(statearr_53365_53391[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (2))){
var _ = (function (){var statearr_53366 = state_53355;
(statearr_53366[(4)] = cljs.core.cons((5),(state_53355[(4)])));

return statearr_53366;
})();
var inst_53316 = fluree.db.util.async.channel_QMARK_(coll);
var state_53355__$1 = state_53355;
if(inst_53316){
var statearr_53367_53392 = state_53355__$1;
(statearr_53367_53392[(1)] = (6));

} else {
var statearr_53368_53393 = state_53355__$1;
(statearr_53368_53393[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (11))){
var inst_53323 = (state_53355[(9)]);
var state_53355__$1 = state_53355;
var statearr_53370_53394 = state_53355__$1;
(statearr_53370_53394[(2)] = inst_53323);

(statearr_53370_53394[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (9))){
var inst_53319 = (state_53355[(2)]);
var inst_53320 = fluree.db.util.async.throw_err(inst_53319);
var state_53355__$1 = state_53355;
var statearr_53371_53395 = state_53355__$1;
(statearr_53371_53395[(2)] = inst_53320);

(statearr_53371_53395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (5))){
var _ = (function (){var statearr_53372 = state_53355;
(statearr_53372[(4)] = cljs.core.rest((state_53355[(4)])));

return statearr_53372;
})();
var state_53355__$1 = state_53355;
var ex53369 = (state_53355__$1[(2)]);
var statearr_53373_53396 = state_53355__$1;
(statearr_53373_53396[(5)] = ex53369);


if((ex53369 instanceof Error)){
var statearr_53374_53397 = state_53355__$1;
(statearr_53374_53397[(1)] = (4));

(statearr_53374_53397[(5)] = null);

} else {
throw ex53369;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (14))){
var state_53355__$1 = state_53355;
var statearr_53375_53398 = state_53355__$1;
(statearr_53375_53398[(2)] = key);

(statearr_53375_53398[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (16))){
var inst_53333 = (state_53355[(2)]);
var inst_53334 = fluree.db.util.async.throw_err(inst_53333);
var state_53355__$1 = state_53355;
var statearr_53376_53399 = state_53355__$1;
(statearr_53376_53399[(2)] = inst_53334);

(statearr_53376_53399[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (10))){
var inst_53323 = (state_53355[(9)]);
var inst_53326 = cljs.core.vec(inst_53323);
var state_53355__$1 = state_53355;
var statearr_53377_53400 = state_53355__$1;
(statearr_53377_53400[(2)] = inst_53326);

(statearr_53377_53400[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53356 === (8))){
var inst_53323 = (state_53355[(9)]);
var inst_53323__$1 = (state_53355[(2)]);
var inst_53324 = cljs.core.set_QMARK_(inst_53323__$1);
var state_53355__$1 = (function (){var statearr_53378 = state_53355;
(statearr_53378[(9)] = inst_53323__$1);

return statearr_53378;
})();
if(inst_53324){
var statearr_53379_53401 = state_53355__$1;
(statearr_53379_53401[(1)] = (10));

} else {
var statearr_53380_53402 = state_53355__$1;
(statearr_53380_53402[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0 = (function (){
var statearr_53381 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53381[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__);

(statearr_53381[(1)] = (1));

return statearr_53381;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1 = (function (state_53355){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53355);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53382){var ex__2730__auto__ = e53382;
var statearr_53383_53403 = state_53355;
(statearr_53383_53403[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53355[(4)]))){
var statearr_53384_53404 = state_53355;
(statearr_53384_53404[(1)] = cljs.core.first((state_53355[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53405 = state_53355;
state_53355 = G__53405;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = function(state_53355){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1.call(this,state_53355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53385 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53385[(6)] = c__2749__auto__);

return statearr_53385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53466){
var state_val_53467 = (state_53466[(1)]);
if((state_val_53467 === (7))){
var state_53466__$1 = state_53466;
var statearr_53468_53502 = state_53466__$1;
(statearr_53468_53502[(2)] = test);

(statearr_53468_53502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (20))){
var inst_53440 = (state_53466[(2)]);
var inst_53441 = fluree.db.util.async.throw_err(inst_53440);
var state_53466__$1 = state_53466;
var statearr_53469_53503 = state_53466__$1;
(statearr_53469_53503[(2)] = inst_53441);

(statearr_53469_53503[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (1))){
var state_53466__$1 = state_53466;
var statearr_53470_53504 = state_53466__$1;
(statearr_53470_53504[(2)] = null);

(statearr_53470_53504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (4))){
var inst_53406 = (state_53466[(2)]);
var state_53466__$1 = state_53466;
var statearr_53471_53505 = state_53466__$1;
(statearr_53471_53505[(2)] = inst_53406);

(statearr_53471_53505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (15))){
var inst_53424 = (state_53466[(7)]);
var inst_53432 = (state_53466[(2)]);
var inst_53433 = [inst_53432,f];
var inst_53434 = (new cljs.core.PersistentVector(null,2,(5),inst_53424,inst_53433,null));
var state_53466__$1 = state_53466;
var statearr_53472_53506 = state_53466__$1;
(statearr_53472_53506[(2)] = inst_53434);

(statearr_53472_53506[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (13))){
var state_53466__$1 = state_53466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53466__$1,(16),t);
} else {
if((state_val_53467 === (6))){
var state_53466__$1 = state_53466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53466__$1,(9),test);
} else {
if((state_val_53467 === (17))){
var state_53466__$1 = state_53466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53466__$1,(20),f);
} else {
if((state_val_53467 === (3))){
var inst_53464 = (state_53466[(2)]);
var state_53466__$1 = state_53466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53466__$1,inst_53464);
} else {
if((state_val_53467 === (12))){
var inst_53422 = (state_53466[(8)]);
var inst_53448 = (state_53466[(2)]);
var inst_53449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53448,(0),null);
var inst_53450 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53448,(1),null);
var inst_53451 = fluree.db.dbfunctions.internal.if_else(inst_53422,inst_53449,inst_53450);
var inst_53452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53453 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53455 = [inst_53422,inst_53449,inst_53450];
var inst_53456 = (new cljs.core.PersistentVector(null,3,(5),inst_53454,inst_53455,null));
var inst_53457 = ["if-else",inst_53456,inst_53451];
var inst_53458 = cljs.core.PersistentHashMap.fromArrays(inst_53453,inst_53457);
var inst_53459 = [inst_53458,(10)];
var inst_53460 = (new cljs.core.PersistentVector(null,2,(5),inst_53452,inst_53459,null));
var inst_53461 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53460);
var _ = (function (){var statearr_53473 = state_53466;
(statearr_53473[(4)] = cljs.core.rest((state_53466[(4)])));

return statearr_53473;
})();
var state_53466__$1 = (function (){var statearr_53474 = state_53466;
(statearr_53474[(9)] = inst_53461);

return statearr_53474;
})();
var statearr_53475_53507 = state_53466__$1;
(statearr_53475_53507[(2)] = inst_53451);

(statearr_53475_53507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (2))){
var _ = (function (){var statearr_53476 = state_53466;
(statearr_53476[(4)] = cljs.core.cons((5),(state_53466[(4)])));

return statearr_53476;
})();
var inst_53415 = fluree.db.util.async.channel_QMARK_(test);
var state_53466__$1 = state_53466;
if(inst_53415){
var statearr_53477_53508 = state_53466__$1;
(statearr_53477_53508[(1)] = (6));

} else {
var statearr_53478_53509 = state_53466__$1;
(statearr_53478_53509[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (19))){
var inst_53436 = (state_53466[(10)]);
var inst_53444 = (state_53466[(2)]);
var inst_53445 = [f,inst_53444];
var inst_53446 = (new cljs.core.PersistentVector(null,2,(5),inst_53436,inst_53445,null));
var state_53466__$1 = state_53466;
var statearr_53479_53510 = state_53466__$1;
(statearr_53479_53510[(2)] = inst_53446);

(statearr_53479_53510[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (11))){
var inst_53436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53437 = fluree.db.util.async.channel_QMARK_(f);
var state_53466__$1 = (function (){var statearr_53481 = state_53466;
(statearr_53481[(10)] = inst_53436);

return statearr_53481;
})();
if(inst_53437){
var statearr_53482_53511 = state_53466__$1;
(statearr_53482_53511[(1)] = (17));

} else {
var statearr_53483_53512 = state_53466__$1;
(statearr_53483_53512[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (9))){
var inst_53418 = (state_53466[(2)]);
var inst_53419 = fluree.db.util.async.throw_err(inst_53418);
var state_53466__$1 = state_53466;
var statearr_53484_53513 = state_53466__$1;
(statearr_53484_53513[(2)] = inst_53419);

(statearr_53484_53513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (5))){
var _ = (function (){var statearr_53485 = state_53466;
(statearr_53485[(4)] = cljs.core.rest((state_53466[(4)])));

return statearr_53485;
})();
var state_53466__$1 = state_53466;
var ex53480 = (state_53466__$1[(2)]);
var statearr_53486_53514 = state_53466__$1;
(statearr_53486_53514[(5)] = ex53480);


if((ex53480 instanceof Error)){
var statearr_53487_53515 = state_53466__$1;
(statearr_53487_53515[(1)] = (4));

(statearr_53487_53515[(5)] = null);

} else {
throw ex53480;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (14))){
var state_53466__$1 = state_53466;
var statearr_53488_53516 = state_53466__$1;
(statearr_53488_53516[(2)] = t);

(statearr_53488_53516[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (16))){
var inst_53428 = (state_53466[(2)]);
var inst_53429 = fluree.db.util.async.throw_err(inst_53428);
var state_53466__$1 = state_53466;
var statearr_53489_53517 = state_53466__$1;
(statearr_53489_53517[(2)] = inst_53429);

(statearr_53489_53517[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (10))){
var inst_53424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53425 = fluree.db.util.async.channel_QMARK_(t);
var state_53466__$1 = (function (){var statearr_53490 = state_53466;
(statearr_53490[(7)] = inst_53424);

return statearr_53490;
})();
if(inst_53425){
var statearr_53491_53518 = state_53466__$1;
(statearr_53491_53518[(1)] = (13));

} else {
var statearr_53492_53519 = state_53466__$1;
(statearr_53492_53519[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (18))){
var state_53466__$1 = state_53466;
var statearr_53493_53520 = state_53466__$1;
(statearr_53493_53520[(2)] = f);

(statearr_53493_53520[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53467 === (8))){
var inst_53422 = (state_53466[(8)]);
var inst_53422__$1 = (state_53466[(2)]);
var state_53466__$1 = (function (){var statearr_53494 = state_53466;
(statearr_53494[(8)] = inst_53422__$1);

return statearr_53494;
})();
if(cljs.core.truth_(inst_53422__$1)){
var statearr_53495_53521 = state_53466__$1;
(statearr_53495_53521[(1)] = (10));

} else {
var statearr_53496_53522 = state_53466__$1;
(statearr_53496_53522[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0 = (function (){
var statearr_53497 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53497[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__);

(statearr_53497[(1)] = (1));

return statearr_53497;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1 = (function (state_53466){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53466);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53498){var ex__2730__auto__ = e53498;
var statearr_53499_53523 = state_53466;
(statearr_53499_53523[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53466[(4)]))){
var statearr_53500_53524 = state_53466;
(statearr_53500_53524[(1)] = cljs.core.first((state_53466[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53525 = state_53466;
state_53466 = G__53525;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = function(state_53466){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1.call(this,state_53466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53501 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53501[(6)] = c__2749__auto__);

return statearr_53501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53555){
var state_val_53556 = (state_53555[(1)]);
if((state_val_53556 === (7))){
var state_53555__$1 = state_53555;
var statearr_53557_53576 = state_53555__$1;
(statearr_53557_53576[(2)] = arg);

(statearr_53557_53576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53556 === (1))){
var state_53555__$1 = state_53555;
var statearr_53558_53577 = state_53555__$1;
(statearr_53558_53577[(2)] = null);

(statearr_53558_53577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53556 === (4))){
var inst_53526 = (state_53555[(2)]);
var state_53555__$1 = state_53555;
var statearr_53559_53578 = state_53555__$1;
(statearr_53559_53578[(2)] = inst_53526);

(statearr_53559_53578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53556 === (6))){
var state_53555__$1 = state_53555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53555__$1,(9),arg);
} else {
if((state_val_53556 === (3))){
var inst_53553 = (state_53555[(2)]);
var state_53555__$1 = state_53555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53555__$1,inst_53553);
} else {
if((state_val_53556 === (2))){
var _ = (function (){var statearr_53561 = state_53555;
(statearr_53561[(4)] = cljs.core.cons((5),(state_53555[(4)])));

return statearr_53561;
})();
var inst_53532 = fluree.db.util.async.channel_QMARK_(arg);
var state_53555__$1 = state_53555;
if(inst_53532){
var statearr_53562_53579 = state_53555__$1;
(statearr_53562_53579[(1)] = (6));

} else {
var statearr_53563_53580 = state_53555__$1;
(statearr_53563_53580[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53556 === (9))){
var inst_53535 = (state_53555[(2)]);
var inst_53536 = fluree.db.util.async.throw_err(inst_53535);
var state_53555__$1 = state_53555;
var statearr_53564_53581 = state_53555__$1;
(statearr_53564_53581[(2)] = inst_53536);

(statearr_53564_53581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53556 === (5))){
var _ = (function (){var statearr_53565 = state_53555;
(statearr_53565[(4)] = cljs.core.rest((state_53555[(4)])));

return statearr_53565;
})();
var state_53555__$1 = state_53555;
var ex53560 = (state_53555__$1[(2)]);
var statearr_53566_53582 = state_53555__$1;
(statearr_53566_53582[(5)] = ex53560);


if((ex53560 instanceof Error)){
var statearr_53567_53583 = state_53555__$1;
(statearr_53567_53583[(1)] = (4));

(statearr_53567_53583[(5)] = null);

} else {
throw ex53560;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53556 === (8))){
var inst_53539 = (state_53555[(2)]);
var inst_53540 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_53539);
var inst_53541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53542 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53544 = [inst_53539];
var inst_53545 = (new cljs.core.PersistentVector(null,1,(5),inst_53543,inst_53544,null));
var inst_53546 = ["nil?",inst_53545,inst_53540];
var inst_53547 = cljs.core.PersistentHashMap.fromArrays(inst_53542,inst_53546);
var inst_53548 = [inst_53547,(10)];
var inst_53549 = (new cljs.core.PersistentVector(null,2,(5),inst_53541,inst_53548,null));
var inst_53550 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53549);
var _ = (function (){var statearr_53568 = state_53555;
(statearr_53568[(4)] = cljs.core.rest((state_53555[(4)])));

return statearr_53568;
})();
var state_53555__$1 = (function (){var statearr_53569 = state_53555;
(statearr_53569[(7)] = inst_53550);

return statearr_53569;
})();
var statearr_53570_53584 = state_53555__$1;
(statearr_53570_53584[(2)] = inst_53540);

(statearr_53570_53584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_53571 = [null,null,null,null,null,null,null,null];
(statearr_53571[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__);

(statearr_53571[(1)] = (1));

return statearr_53571;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1 = (function (state_53555){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53555);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53572){var ex__2730__auto__ = e53572;
var statearr_53573_53585 = state_53555;
(statearr_53573_53585[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53555[(4)]))){
var statearr_53574_53586 = state_53555;
(statearr_53574_53586[(1)] = cljs.core.first((state_53555[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53587 = state_53555;
state_53555 = G__53587;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = function(state_53555){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1.call(this,state_53555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53575 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53575[(6)] = c__2749__auto__);

return statearr_53575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53617){
var state_val_53618 = (state_53617[(1)]);
if((state_val_53618 === (7))){
var state_53617__$1 = state_53617;
var statearr_53619_53638 = state_53617__$1;
(statearr_53619_53638[(2)] = arg);

(statearr_53619_53638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53618 === (1))){
var state_53617__$1 = state_53617;
var statearr_53620_53639 = state_53617__$1;
(statearr_53620_53639[(2)] = null);

(statearr_53620_53639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53618 === (4))){
var inst_53588 = (state_53617[(2)]);
var state_53617__$1 = state_53617;
var statearr_53621_53640 = state_53617__$1;
(statearr_53621_53640[(2)] = inst_53588);

(statearr_53621_53640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53618 === (6))){
var state_53617__$1 = state_53617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53617__$1,(9),arg);
} else {
if((state_val_53618 === (3))){
var inst_53615 = (state_53617[(2)]);
var state_53617__$1 = state_53617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53617__$1,inst_53615);
} else {
if((state_val_53618 === (2))){
var _ = (function (){var statearr_53623 = state_53617;
(statearr_53623[(4)] = cljs.core.cons((5),(state_53617[(4)])));

return statearr_53623;
})();
var inst_53594 = fluree.db.util.async.channel_QMARK_(arg);
var state_53617__$1 = state_53617;
if(inst_53594){
var statearr_53624_53641 = state_53617__$1;
(statearr_53624_53641[(1)] = (6));

} else {
var statearr_53625_53642 = state_53617__$1;
(statearr_53625_53642[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53618 === (9))){
var inst_53597 = (state_53617[(2)]);
var inst_53598 = fluree.db.util.async.throw_err(inst_53597);
var state_53617__$1 = state_53617;
var statearr_53626_53643 = state_53617__$1;
(statearr_53626_53643[(2)] = inst_53598);

(statearr_53626_53643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53618 === (5))){
var _ = (function (){var statearr_53627 = state_53617;
(statearr_53627[(4)] = cljs.core.rest((state_53617[(4)])));

return statearr_53627;
})();
var state_53617__$1 = state_53617;
var ex53622 = (state_53617__$1[(2)]);
var statearr_53628_53644 = state_53617__$1;
(statearr_53628_53644[(5)] = ex53622);


if((ex53622 instanceof Error)){
var statearr_53629_53645 = state_53617__$1;
(statearr_53629_53645[(1)] = (4));

(statearr_53629_53645[(5)] = null);

} else {
throw ex53622;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53618 === (8))){
var inst_53601 = (state_53617[(2)]);
var inst_53602 = fluree.db.dbfunctions.internal.not(inst_53601);
var inst_53603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53604 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53606 = [inst_53601];
var inst_53607 = (new cljs.core.PersistentVector(null,1,(5),inst_53605,inst_53606,null));
var inst_53608 = ["not?",inst_53607,inst_53602];
var inst_53609 = cljs.core.PersistentHashMap.fromArrays(inst_53604,inst_53608);
var inst_53610 = [inst_53609,(10)];
var inst_53611 = (new cljs.core.PersistentVector(null,2,(5),inst_53603,inst_53610,null));
var inst_53612 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53611);
var _ = (function (){var statearr_53630 = state_53617;
(statearr_53630[(4)] = cljs.core.rest((state_53617[(4)])));

return statearr_53630;
})();
var state_53617__$1 = (function (){var statearr_53631 = state_53617;
(statearr_53631[(7)] = inst_53612);

return statearr_53631;
})();
var statearr_53632_53646 = state_53617__$1;
(statearr_53632_53646[(2)] = inst_53602);

(statearr_53632_53646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0 = (function (){
var statearr_53633 = [null,null,null,null,null,null,null,null];
(statearr_53633[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__);

(statearr_53633[(1)] = (1));

return statearr_53633;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1 = (function (state_53617){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53617);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53634){var ex__2730__auto__ = e53634;
var statearr_53635_53647 = state_53617;
(statearr_53635_53647[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53617[(4)]))){
var statearr_53636_53648 = state_53617;
(statearr_53636_53648[(1)] = cljs.core.first((state_53617[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53649 = state_53617;
state_53617 = G__53649;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = function(state_53617){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1.call(this,state_53617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53637 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53637[(6)] = c__2749__auto__);

return statearr_53637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53679){
var state_val_53680 = (state_53679[(1)]);
if((state_val_53680 === (7))){
var state_53679__$1 = state_53679;
var statearr_53681_53700 = state_53679__$1;
(statearr_53681_53700[(2)] = arg);

(statearr_53681_53700[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53680 === (1))){
var state_53679__$1 = state_53679;
var statearr_53682_53701 = state_53679__$1;
(statearr_53682_53701[(2)] = null);

(statearr_53682_53701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53680 === (4))){
var inst_53650 = (state_53679[(2)]);
var state_53679__$1 = state_53679;
var statearr_53683_53702 = state_53679__$1;
(statearr_53683_53702[(2)] = inst_53650);

(statearr_53683_53702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53680 === (6))){
var state_53679__$1 = state_53679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53679__$1,(9),arg);
} else {
if((state_val_53680 === (3))){
var inst_53677 = (state_53679[(2)]);
var state_53679__$1 = state_53679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53679__$1,inst_53677);
} else {
if((state_val_53680 === (2))){
var _ = (function (){var statearr_53685 = state_53679;
(statearr_53685[(4)] = cljs.core.cons((5),(state_53679[(4)])));

return statearr_53685;
})();
var inst_53656 = fluree.db.util.async.channel_QMARK_(arg);
var state_53679__$1 = state_53679;
if(inst_53656){
var statearr_53686_53703 = state_53679__$1;
(statearr_53686_53703[(1)] = (6));

} else {
var statearr_53687_53704 = state_53679__$1;
(statearr_53687_53704[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53680 === (9))){
var inst_53659 = (state_53679[(2)]);
var inst_53660 = fluree.db.util.async.throw_err(inst_53659);
var state_53679__$1 = state_53679;
var statearr_53688_53705 = state_53679__$1;
(statearr_53688_53705[(2)] = inst_53660);

(statearr_53688_53705[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53680 === (5))){
var _ = (function (){var statearr_53689 = state_53679;
(statearr_53689[(4)] = cljs.core.rest((state_53679[(4)])));

return statearr_53689;
})();
var state_53679__$1 = state_53679;
var ex53684 = (state_53679__$1[(2)]);
var statearr_53690_53706 = state_53679__$1;
(statearr_53690_53706[(5)] = ex53684);


if((ex53684 instanceof Error)){
var statearr_53691_53707 = state_53679__$1;
(statearr_53691_53707[(1)] = (4));

(statearr_53691_53707[(5)] = null);

} else {
throw ex53684;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53680 === (8))){
var inst_53663 = (state_53679[(2)]);
var inst_53664 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_53663);
var inst_53665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53666 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53668 = [inst_53663];
var inst_53669 = (new cljs.core.PersistentVector(null,1,(5),inst_53667,inst_53668,null));
var inst_53670 = ["empty?",inst_53669,inst_53664];
var inst_53671 = cljs.core.PersistentHashMap.fromArrays(inst_53666,inst_53670);
var inst_53672 = [inst_53671,(10)];
var inst_53673 = (new cljs.core.PersistentVector(null,2,(5),inst_53665,inst_53672,null));
var inst_53674 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53673);
var _ = (function (){var statearr_53692 = state_53679;
(statearr_53692[(4)] = cljs.core.rest((state_53679[(4)])));

return statearr_53692;
})();
var state_53679__$1 = (function (){var statearr_53693 = state_53679;
(statearr_53693[(7)] = inst_53674);

return statearr_53693;
})();
var statearr_53694_53708 = state_53679__$1;
(statearr_53694_53708[(2)] = inst_53664);

(statearr_53694_53708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_53695 = [null,null,null,null,null,null,null,null];
(statearr_53695[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__);

(statearr_53695[(1)] = (1));

return statearr_53695;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1 = (function (state_53679){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53679);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53696){var ex__2730__auto__ = e53696;
var statearr_53697_53709 = state_53679;
(statearr_53697_53709[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53679[(4)]))){
var statearr_53698_53710 = state_53679;
(statearr_53698_53710[(1)] = cljs.core.first((state_53679[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53711 = state_53679;
state_53679 = G__53711;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = function(state_53679){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1.call(this,state_53679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53699 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53699[(6)] = c__2749__auto__);

return statearr_53699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53756 = arguments.length;
var i__4865__auto___53757 = (0);
while(true){
if((i__4865__auto___53757 < len__4864__auto___53756)){
args__4870__auto__.push((arguments[i__4865__auto___53757]));

var G__53758 = (i__4865__auto___53757 + (1));
i__4865__auto___53757 = G__53758;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53739){
var state_val_53740 = (state_53739[(1)]);
if((state_val_53740 === (1))){
var state_53739__$1 = state_53739;
var statearr_53741_53759 = state_53739__$1;
(statearr_53741_53759[(2)] = null);

(statearr_53741_53759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53740 === (2))){
var _ = (function (){var statearr_53742 = state_53739;
(statearr_53742[(4)] = cljs.core.cons((5),(state_53739[(4)])));

return statearr_53742;
})();
var inst_53720 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53739__$1 = state_53739;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53739__$1,(6),inst_53720);
} else {
if((state_val_53740 === (3))){
var inst_53737 = (state_53739[(2)]);
var state_53739__$1 = state_53739;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53739__$1,inst_53737);
} else {
if((state_val_53740 === (4))){
var inst_53714 = (state_53739[(2)]);
var state_53739__$1 = state_53739;
var statearr_53744_53760 = state_53739__$1;
(statearr_53744_53760[(2)] = inst_53714);

(statearr_53744_53760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53740 === (5))){
var _ = (function (){var statearr_53745 = state_53739;
(statearr_53745[(4)] = cljs.core.rest((state_53739[(4)])));

return statearr_53745;
})();
var state_53739__$1 = state_53739;
var ex53743 = (state_53739__$1[(2)]);
var statearr_53746_53761 = state_53739__$1;
(statearr_53746_53761[(5)] = ex53743);


if((ex53743 instanceof Error)){
var statearr_53747_53762 = state_53739__$1;
(statearr_53747_53762[(1)] = (4));

(statearr_53747_53762[(5)] = null);

} else {
throw ex53743;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53740 === (6))){
var inst_53722 = (state_53739[(2)]);
var inst_53723 = fluree.db.util.async.throw_err(inst_53722);
var inst_53724 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_53723);
var inst_53725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53726 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53728 = [inst_53723];
var inst_53729 = (new cljs.core.PersistentVector(null,1,(5),inst_53727,inst_53728,null));
var inst_53730 = ["str",inst_53729,inst_53724];
var inst_53731 = cljs.core.PersistentHashMap.fromArrays(inst_53726,inst_53730);
var inst_53732 = [inst_53731,(10)];
var inst_53733 = (new cljs.core.PersistentVector(null,2,(5),inst_53725,inst_53732,null));
var inst_53734 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53733);
var _ = (function (){var statearr_53748 = state_53739;
(statearr_53748[(4)] = cljs.core.rest((state_53739[(4)])));

return statearr_53748;
})();
var state_53739__$1 = (function (){var statearr_53749 = state_53739;
(statearr_53749[(7)] = inst_53734);

return statearr_53749;
})();
var statearr_53750_53763 = state_53739__$1;
(statearr_53750_53763[(2)] = inst_53724);

(statearr_53750_53763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_53751 = [null,null,null,null,null,null,null,null];
(statearr_53751[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_53751[(1)] = (1));

return statearr_53751;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_53739){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53739);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53752){var ex__2730__auto__ = e53752;
var statearr_53753_53764 = state_53739;
(statearr_53753_53764[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53739[(4)]))){
var statearr_53754_53765 = state_53739;
(statearr_53754_53765[(1)] = cljs.core.first((state_53739[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53766 = state_53739;
state_53739 = G__53766;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_53739){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_53739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53755 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53755[(6)] = c__2749__auto__);

return statearr_53755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq53712){
var G__53713 = cljs.core.first(seq53712);
var seq53712__$1 = cljs.core.next(seq53712);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53713,seq53712__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53792){
var state_val_53793 = (state_53792[(1)]);
if((state_val_53793 === (1))){
var state_53792__$1 = state_53792;
var statearr_53794_53809 = state_53792__$1;
(statearr_53794_53809[(2)] = null);

(statearr_53794_53809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53793 === (2))){
var _ = (function (){var statearr_53795 = state_53792;
(statearr_53795[(4)] = cljs.core.cons((5),(state_53792[(4)])));

return statearr_53795;
})();
var inst_53773 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53792__$1 = state_53792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53792__$1,(6),inst_53773);
} else {
if((state_val_53793 === (3))){
var inst_53790 = (state_53792[(2)]);
var state_53792__$1 = state_53792;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53792__$1,inst_53790);
} else {
if((state_val_53793 === (4))){
var inst_53767 = (state_53792[(2)]);
var state_53792__$1 = state_53792;
var statearr_53797_53810 = state_53792__$1;
(statearr_53797_53810[(2)] = inst_53767);

(statearr_53797_53810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53793 === (5))){
var _ = (function (){var statearr_53798 = state_53792;
(statearr_53798[(4)] = cljs.core.rest((state_53792[(4)])));

return statearr_53798;
})();
var state_53792__$1 = state_53792;
var ex53796 = (state_53792__$1[(2)]);
var statearr_53799_53811 = state_53792__$1;
(statearr_53799_53811[(5)] = ex53796);


if((ex53796 instanceof Error)){
var statearr_53800_53812 = state_53792__$1;
(statearr_53800_53812[(1)] = (4));

(statearr_53800_53812[(5)] = null);

} else {
throw ex53796;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53793 === (6))){
var inst_53775 = (state_53792[(2)]);
var inst_53776 = fluree.db.util.async.throw_err(inst_53775);
var inst_53777 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_53776);
var inst_53778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53779 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53781 = [inst_53776];
var inst_53782 = (new cljs.core.PersistentVector(null,1,(5),inst_53780,inst_53781,null));
var inst_53783 = ["subs",inst_53782,inst_53777];
var inst_53784 = cljs.core.PersistentHashMap.fromArrays(inst_53779,inst_53783);
var inst_53785 = [inst_53784,(30)];
var inst_53786 = (new cljs.core.PersistentVector(null,2,(5),inst_53778,inst_53785,null));
var inst_53787 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53786);
var _ = (function (){var statearr_53801 = state_53792;
(statearr_53801[(4)] = cljs.core.rest((state_53792[(4)])));

return statearr_53801;
})();
var state_53792__$1 = (function (){var statearr_53802 = state_53792;
(statearr_53802[(7)] = inst_53787);

return statearr_53802;
})();
var statearr_53803_53813 = state_53792__$1;
(statearr_53803_53813[(2)] = inst_53777);

(statearr_53803_53813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0 = (function (){
var statearr_53804 = [null,null,null,null,null,null,null,null];
(statearr_53804[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__);

(statearr_53804[(1)] = (1));

return statearr_53804;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1 = (function (state_53792){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53792);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53805){var ex__2730__auto__ = e53805;
var statearr_53806_53814 = state_53792;
(statearr_53806_53814[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53792[(4)]))){
var statearr_53807_53815 = state_53792;
(statearr_53807_53815[(1)] = cljs.core.first((state_53792[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53816 = state_53792;
state_53792 = G__53816;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = function(state_53792){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1.call(this,state_53792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53808 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53808[(6)] = c__2749__auto__);

return statearr_53808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53846){
var state_val_53847 = (state_53846[(1)]);
if((state_val_53847 === (7))){
var state_53846__$1 = state_53846;
var statearr_53848_53867 = state_53846__$1;
(statearr_53848_53867[(2)] = str);

(statearr_53848_53867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53847 === (1))){
var state_53846__$1 = state_53846;
var statearr_53849_53868 = state_53846__$1;
(statearr_53849_53868[(2)] = null);

(statearr_53849_53868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53847 === (4))){
var inst_53817 = (state_53846[(2)]);
var state_53846__$1 = state_53846;
var statearr_53850_53869 = state_53846__$1;
(statearr_53850_53869[(2)] = inst_53817);

(statearr_53850_53869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53847 === (6))){
var state_53846__$1 = state_53846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53846__$1,(9),str);
} else {
if((state_val_53847 === (3))){
var inst_53844 = (state_53846[(2)]);
var state_53846__$1 = state_53846;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53846__$1,inst_53844);
} else {
if((state_val_53847 === (2))){
var _ = (function (){var statearr_53852 = state_53846;
(statearr_53852[(4)] = cljs.core.cons((5),(state_53846[(4)])));

return statearr_53852;
})();
var inst_53823 = fluree.db.util.async.channel_QMARK_(str);
var state_53846__$1 = state_53846;
if(inst_53823){
var statearr_53853_53870 = state_53846__$1;
(statearr_53853_53870[(1)] = (6));

} else {
var statearr_53854_53871 = state_53846__$1;
(statearr_53854_53871[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53847 === (9))){
var inst_53826 = (state_53846[(2)]);
var inst_53827 = fluree.db.util.async.throw_err(inst_53826);
var state_53846__$1 = state_53846;
var statearr_53855_53872 = state_53846__$1;
(statearr_53855_53872[(2)] = inst_53827);

(statearr_53855_53872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53847 === (5))){
var _ = (function (){var statearr_53856 = state_53846;
(statearr_53856[(4)] = cljs.core.rest((state_53846[(4)])));

return statearr_53856;
})();
var state_53846__$1 = state_53846;
var ex53851 = (state_53846__$1[(2)]);
var statearr_53857_53873 = state_53846__$1;
(statearr_53857_53873[(5)] = ex53851);


if((ex53851 instanceof Error)){
var statearr_53858_53874 = state_53846__$1;
(statearr_53858_53874[(1)] = (4));

(statearr_53858_53874[(5)] = null);

} else {
throw ex53851;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53847 === (8))){
var inst_53830 = (state_53846[(2)]);
var inst_53831 = fluree.db.dbfunctions.internal.lower_case(inst_53830);
var inst_53832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53833 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53835 = [inst_53830];
var inst_53836 = (new cljs.core.PersistentVector(null,1,(5),inst_53834,inst_53835,null));
var inst_53837 = ["lower-case",inst_53836,inst_53831];
var inst_53838 = cljs.core.PersistentHashMap.fromArrays(inst_53833,inst_53837);
var inst_53839 = [inst_53838,(10)];
var inst_53840 = (new cljs.core.PersistentVector(null,2,(5),inst_53832,inst_53839,null));
var inst_53841 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53840);
var _ = (function (){var statearr_53859 = state_53846;
(statearr_53859[(4)] = cljs.core.rest((state_53846[(4)])));

return statearr_53859;
})();
var state_53846__$1 = (function (){var statearr_53860 = state_53846;
(statearr_53860[(7)] = inst_53841);

return statearr_53860;
})();
var statearr_53861_53875 = state_53846__$1;
(statearr_53861_53875[(2)] = inst_53831);

(statearr_53861_53875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0 = (function (){
var statearr_53862 = [null,null,null,null,null,null,null,null];
(statearr_53862[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__);

(statearr_53862[(1)] = (1));

return statearr_53862;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1 = (function (state_53846){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53846);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53863){var ex__2730__auto__ = e53863;
var statearr_53864_53876 = state_53846;
(statearr_53864_53876[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53846[(4)]))){
var statearr_53865_53877 = state_53846;
(statearr_53865_53877[(1)] = cljs.core.first((state_53846[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53878 = state_53846;
state_53846 = G__53878;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = function(state_53846){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1.call(this,state_53846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53866 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53866[(6)] = c__2749__auto__);

return statearr_53866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53908){
var state_val_53909 = (state_53908[(1)]);
if((state_val_53909 === (7))){
var state_53908__$1 = state_53908;
var statearr_53910_53929 = state_53908__$1;
(statearr_53910_53929[(2)] = str);

(statearr_53910_53929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53909 === (1))){
var state_53908__$1 = state_53908;
var statearr_53911_53930 = state_53908__$1;
(statearr_53911_53930[(2)] = null);

(statearr_53911_53930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53909 === (4))){
var inst_53879 = (state_53908[(2)]);
var state_53908__$1 = state_53908;
var statearr_53912_53931 = state_53908__$1;
(statearr_53912_53931[(2)] = inst_53879);

(statearr_53912_53931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53909 === (6))){
var state_53908__$1 = state_53908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53908__$1,(9),str);
} else {
if((state_val_53909 === (3))){
var inst_53906 = (state_53908[(2)]);
var state_53908__$1 = state_53908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53908__$1,inst_53906);
} else {
if((state_val_53909 === (2))){
var _ = (function (){var statearr_53914 = state_53908;
(statearr_53914[(4)] = cljs.core.cons((5),(state_53908[(4)])));

return statearr_53914;
})();
var inst_53885 = fluree.db.util.async.channel_QMARK_(str);
var state_53908__$1 = state_53908;
if(inst_53885){
var statearr_53915_53932 = state_53908__$1;
(statearr_53915_53932[(1)] = (6));

} else {
var statearr_53916_53933 = state_53908__$1;
(statearr_53916_53933[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53909 === (9))){
var inst_53888 = (state_53908[(2)]);
var inst_53889 = fluree.db.util.async.throw_err(inst_53888);
var state_53908__$1 = state_53908;
var statearr_53917_53934 = state_53908__$1;
(statearr_53917_53934[(2)] = inst_53889);

(statearr_53917_53934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53909 === (5))){
var _ = (function (){var statearr_53918 = state_53908;
(statearr_53918[(4)] = cljs.core.rest((state_53908[(4)])));

return statearr_53918;
})();
var state_53908__$1 = state_53908;
var ex53913 = (state_53908__$1[(2)]);
var statearr_53919_53935 = state_53908__$1;
(statearr_53919_53935[(5)] = ex53913);


if((ex53913 instanceof Error)){
var statearr_53920_53936 = state_53908__$1;
(statearr_53920_53936[(1)] = (4));

(statearr_53920_53936[(5)] = null);

} else {
throw ex53913;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53909 === (8))){
var inst_53892 = (state_53908[(2)]);
var inst_53893 = fluree.db.dbfunctions.internal.upper_case(inst_53892);
var inst_53894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53895 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53897 = [inst_53892];
var inst_53898 = (new cljs.core.PersistentVector(null,1,(5),inst_53896,inst_53897,null));
var inst_53899 = ["upper-case",inst_53898,inst_53893];
var inst_53900 = cljs.core.PersistentHashMap.fromArrays(inst_53895,inst_53899);
var inst_53901 = [inst_53900,(10)];
var inst_53902 = (new cljs.core.PersistentVector(null,2,(5),inst_53894,inst_53901,null));
var inst_53903 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53902);
var _ = (function (){var statearr_53921 = state_53908;
(statearr_53921[(4)] = cljs.core.rest((state_53908[(4)])));

return statearr_53921;
})();
var state_53908__$1 = (function (){var statearr_53922 = state_53908;
(statearr_53922[(7)] = inst_53903);

return statearr_53922;
})();
var statearr_53923_53937 = state_53908__$1;
(statearr_53923_53937[(2)] = inst_53893);

(statearr_53923_53937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0 = (function (){
var statearr_53924 = [null,null,null,null,null,null,null,null];
(statearr_53924[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__);

(statearr_53924[(1)] = (1));

return statearr_53924;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1 = (function (state_53908){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53908);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53925){var ex__2730__auto__ = e53925;
var statearr_53926_53938 = state_53908;
(statearr_53926_53938[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53908[(4)]))){
var statearr_53927_53939 = state_53908;
(statearr_53927_53939[(1)] = cljs.core.first((state_53908[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53940 = state_53908;
state_53908 = G__53940;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = function(state_53908){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1.call(this,state_53908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53928 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53928[(6)] = c__2749__auto__);

return statearr_53928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4251__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4251__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__53942 = arguments.length;
switch (G__53942) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53970){
var state_val_53971 = (state_53970[(1)]);
if((state_val_53971 === (1))){
var state_53970__$1 = state_53970;
var statearr_53972_53988 = state_53970__$1;
(statearr_53972_53988[(2)] = null);

(statearr_53972_53988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53971 === (2))){
var _ = (function (){var statearr_53973 = state_53970;
(statearr_53973[(4)] = cljs.core.cons((5),(state_53970[(4)])));

return statearr_53973;
})();
var inst_53952 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_53970__$1 = state_53970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53970__$1,(6),inst_53952);
} else {
if((state_val_53971 === (3))){
var inst_53968 = (state_53970[(2)]);
var state_53970__$1 = state_53970;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53970__$1,inst_53968);
} else {
if((state_val_53971 === (4))){
var inst_53943 = (state_53970[(2)]);
var state_53970__$1 = state_53970;
var statearr_53975_53989 = state_53970__$1;
(statearr_53975_53989[(2)] = inst_53943);

(statearr_53975_53989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53971 === (5))){
var _ = (function (){var statearr_53976 = state_53970;
(statearr_53976[(4)] = cljs.core.rest((state_53970[(4)])));

return statearr_53976;
})();
var state_53970__$1 = state_53970;
var ex53974 = (state_53970__$1[(2)]);
var statearr_53977_53990 = state_53970__$1;
(statearr_53977_53990[(5)] = ex53974);


if((ex53974 instanceof Error)){
var statearr_53978_53991 = state_53970__$1;
(statearr_53978_53991[(1)] = (4));

(statearr_53978_53991[(5)] = null);

} else {
throw ex53974;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53971 === (6))){
var inst_53954 = (state_53970[(2)]);
var inst_53955 = fluree.db.util.async.throw_err(inst_53954);
var inst_53956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53955,(0),null);
var inst_53957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53955,(1),null);
var inst_53958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53959 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53960 = ["?s","?ctx",inst_53956];
var inst_53961 = cljs.core.PersistentHashMap.fromArrays(inst_53959,inst_53960);
var inst_53962 = ((10) + inst_53957);
var inst_53963 = [inst_53961,inst_53962];
var inst_53964 = (new cljs.core.PersistentVector(null,2,(5),inst_53958,inst_53963,null));
var inst_53965 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53964);
var _ = (function (){var statearr_53979 = state_53970;
(statearr_53979[(4)] = cljs.core.rest((state_53970[(4)])));

return statearr_53979;
})();
var state_53970__$1 = (function (){var statearr_53980 = state_53970;
(statearr_53980[(7)] = inst_53965);

return statearr_53980;
})();
var statearr_53981_53992 = state_53970__$1;
(statearr_53981_53992[(2)] = inst_53956);

(statearr_53981_53992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_53982 = [null,null,null,null,null,null,null,null];
(statearr_53982[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_53982[(1)] = (1));

return statearr_53982;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_53970){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53970);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53983){var ex__2730__auto__ = e53983;
var statearr_53984_53993 = state_53970;
(statearr_53984_53993[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53970[(4)]))){
var statearr_53985_53994 = state_53970;
(statearr_53985_53994[(1)] = cljs.core.first((state_53970[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53995 = state_53970;
state_53970 = G__53995;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_53970){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_53970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53986 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53986[(6)] = c__2749__auto__);

return statearr_53986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__53997 = arguments.length;
switch (G__53997) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54035){
var state_val_54036 = (state_54035[(1)]);
if((state_val_54036 === (7))){
var inst_54028 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54035__$1 = state_54035;
var statearr_54037_54057 = state_54035__$1;
(statearr_54037_54057[(2)] = inst_54028);

(statearr_54037_54057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54036 === (1))){
var state_54035__$1 = state_54035;
var statearr_54038_54058 = state_54035__$1;
(statearr_54038_54058[(2)] = null);

(statearr_54038_54058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54036 === (4))){
var inst_53998 = (state_54035[(2)]);
var state_54035__$1 = state_54035;
var statearr_54039_54059 = state_54035__$1;
(statearr_54039_54059[(2)] = inst_53998);

(statearr_54039_54059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54036 === (6))){
var inst_54009 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_54035__$1 = state_54035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54035__$1,(10),inst_54009);
} else {
if((state_val_54036 === (3))){
var inst_54033 = (state_54035[(2)]);
var state_54035__$1 = state_54035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54035__$1,inst_54033);
} else {
if((state_val_54036 === (2))){
var _ = (function (){var statearr_54041 = state_54035;
(statearr_54041[(4)] = cljs.core.cons((5),(state_54035[(4)])));

return statearr_54041;
})();
var inst_54004 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54035__$1 = state_54035;
if(cljs.core.truth_(inst_54004)){
var statearr_54042_54060 = state_54035__$1;
(statearr_54042_54060[(1)] = (6));

} else {
var statearr_54043_54061 = state_54035__$1;
(statearr_54043_54061[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54036 === (9))){
var inst_54015 = (state_54035[(2)]);
var inst_54016 = fluree.db.util.async.throw_err(inst_54015);
var inst_54017 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54016,(0),null);
var inst_54018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54016,(1),null);
var inst_54019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54020 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54021 = ["?p","?ctx",inst_54017];
var inst_54022 = cljs.core.PersistentHashMap.fromArrays(inst_54020,inst_54021);
var inst_54023 = ((10) + inst_54018);
var inst_54024 = [inst_54022,inst_54023];
var inst_54025 = (new cljs.core.PersistentVector(null,2,(5),inst_54019,inst_54024,null));
var inst_54026 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54025);
var state_54035__$1 = (function (){var statearr_54044 = state_54035;
(statearr_54044[(7)] = inst_54026);

return statearr_54044;
})();
var statearr_54045_54062 = state_54035__$1;
(statearr_54045_54062[(2)] = inst_54017);

(statearr_54045_54062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54036 === (5))){
var _ = (function (){var statearr_54046 = state_54035;
(statearr_54046[(4)] = cljs.core.rest((state_54035[(4)])));

return statearr_54046;
})();
var state_54035__$1 = state_54035;
var ex54040 = (state_54035__$1[(2)]);
var statearr_54047_54063 = state_54035__$1;
(statearr_54047_54063[(5)] = ex54040);


if((ex54040 instanceof Error)){
var statearr_54048_54064 = state_54035__$1;
(statearr_54048_54064[(1)] = (4));

(statearr_54048_54064[(5)] = null);

} else {
throw ex54040;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54036 === (10))){
var inst_54011 = (state_54035[(2)]);
var inst_54012 = fluree.db.util.async.throw_err(inst_54011);
var inst_54013 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_54012);
var state_54035__$1 = state_54035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54035__$1,(9),inst_54013);
} else {
if((state_val_54036 === (8))){
var inst_54030 = (state_54035[(2)]);
var _ = (function (){var statearr_54049 = state_54035;
(statearr_54049[(4)] = cljs.core.rest((state_54035[(4)])));

return statearr_54049;
})();
var state_54035__$1 = state_54035;
var statearr_54050_54065 = state_54035__$1;
(statearr_54050_54065[(2)] = inst_54030);

(statearr_54050_54065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54051 = [null,null,null,null,null,null,null,null];
(statearr_54051[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54051[(1)] = (1));

return statearr_54051;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54035){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54035);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54052){var ex__2730__auto__ = e54052;
var statearr_54053_54066 = state_54035;
(statearr_54053_54066[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54035[(4)]))){
var statearr_54054_54067 = state_54035;
(statearr_54054_54067[(1)] = cljs.core.first((state_54035[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54068 = state_54035;
state_54035 = G__54068;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54035){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54055 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54055[(6)] = c__2749__auto__);

return statearr_54055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54117 = arguments.length;
var i__4865__auto___54118 = (0);
while(true){
if((i__4865__auto___54118 < len__4864__auto___54117)){
args__4870__auto__.push((arguments[i__4865__auto___54118]));

var G__54119 = (i__4865__auto___54118 + (1));
i__4865__auto___54118 = G__54119;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54100){
var state_val_54101 = (state_54100[(1)]);
if((state_val_54101 === (1))){
var state_54100__$1 = state_54100;
var statearr_54102_54120 = state_54100__$1;
(statearr_54102_54120[(2)] = null);

(statearr_54102_54120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54101 === (2))){
var _ = (function (){var statearr_54103 = state_54100;
(statearr_54103[(4)] = cljs.core.cons((5),(state_54100[(4)])));

return statearr_54103;
})();
var inst_54077 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54100__$1 = state_54100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54100__$1,(6),inst_54077);
} else {
if((state_val_54101 === (3))){
var inst_54098 = (state_54100[(2)]);
var state_54100__$1 = state_54100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54100__$1,inst_54098);
} else {
if((state_val_54101 === (4))){
var inst_54071 = (state_54100[(2)]);
var state_54100__$1 = state_54100;
var statearr_54105_54121 = state_54100__$1;
(statearr_54105_54121[(2)] = inst_54071);

(statearr_54105_54121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54101 === (5))){
var _ = (function (){var statearr_54106 = state_54100;
(statearr_54106[(4)] = cljs.core.rest((state_54100[(4)])));

return statearr_54106;
})();
var state_54100__$1 = state_54100;
var ex54104 = (state_54100__$1[(2)]);
var statearr_54107_54122 = state_54100__$1;
(statearr_54107_54122[(5)] = ex54104);


if((ex54104 instanceof Error)){
var statearr_54108_54123 = state_54100__$1;
(statearr_54108_54123[(1)] = (4));

(statearr_54108_54123[(5)] = null);

} else {
throw ex54104;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54101 === (6))){
var inst_54079 = (state_54100[(2)]);
var inst_54080 = fluree.db.util.async.throw_err(inst_54079);
var inst_54081 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54080);
var inst_54082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54083 = [inst_54080];
var inst_54084 = (new cljs.core.PersistentVector(null,1,(5),inst_54082,inst_54083,null));
var inst_54085 = cljs.core.count(inst_54084);
var inst_54086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54087 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54089 = [inst_54080];
var inst_54090 = (new cljs.core.PersistentVector(null,1,(5),inst_54088,inst_54089,null));
var inst_54091 = ["and",inst_54090,inst_54081];
var inst_54092 = cljs.core.PersistentHashMap.fromArrays(inst_54087,inst_54091);
var inst_54093 = [inst_54092,inst_54085];
var inst_54094 = (new cljs.core.PersistentVector(null,2,(5),inst_54086,inst_54093,null));
var inst_54095 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54094);
var _ = (function (){var statearr_54109 = state_54100;
(statearr_54109[(4)] = cljs.core.rest((state_54100[(4)])));

return statearr_54109;
})();
var state_54100__$1 = (function (){var statearr_54110 = state_54100;
(statearr_54110[(7)] = inst_54095);

return statearr_54110;
})();
var statearr_54111_54124 = state_54100__$1;
(statearr_54111_54124[(2)] = inst_54081);

(statearr_54111_54124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54112 = [null,null,null,null,null,null,null,null];
(statearr_54112[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54112[(1)] = (1));

return statearr_54112;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54100){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54100);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54113){var ex__2730__auto__ = e54113;
var statearr_54114_54125 = state_54100;
(statearr_54114_54125[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54100[(4)]))){
var statearr_54115_54126 = state_54100;
(statearr_54115_54126[(1)] = cljs.core.first((state_54100[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54127 = state_54100;
state_54100 = G__54127;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54100){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54116 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54116[(6)] = c__2749__auto__);

return statearr_54116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54069){
var G__54070 = cljs.core.first(seq54069);
var seq54069__$1 = cljs.core.next(seq54069);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54070,seq54069__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54176 = arguments.length;
var i__4865__auto___54177 = (0);
while(true){
if((i__4865__auto___54177 < len__4864__auto___54176)){
args__4870__auto__.push((arguments[i__4865__auto___54177]));

var G__54178 = (i__4865__auto___54177 + (1));
i__4865__auto___54177 = G__54178;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54159){
var state_val_54160 = (state_54159[(1)]);
if((state_val_54160 === (1))){
var state_54159__$1 = state_54159;
var statearr_54161_54179 = state_54159__$1;
(statearr_54161_54179[(2)] = null);

(statearr_54161_54179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54160 === (2))){
var _ = (function (){var statearr_54162 = state_54159;
(statearr_54162[(4)] = cljs.core.cons((5),(state_54159[(4)])));

return statearr_54162;
})();
var inst_54136 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54159__$1 = state_54159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54159__$1,(6),inst_54136);
} else {
if((state_val_54160 === (3))){
var inst_54157 = (state_54159[(2)]);
var state_54159__$1 = state_54159;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54159__$1,inst_54157);
} else {
if((state_val_54160 === (4))){
var inst_54130 = (state_54159[(2)]);
var state_54159__$1 = state_54159;
var statearr_54164_54180 = state_54159__$1;
(statearr_54164_54180[(2)] = inst_54130);

(statearr_54164_54180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54160 === (5))){
var _ = (function (){var statearr_54165 = state_54159;
(statearr_54165[(4)] = cljs.core.rest((state_54159[(4)])));

return statearr_54165;
})();
var state_54159__$1 = state_54159;
var ex54163 = (state_54159__$1[(2)]);
var statearr_54166_54181 = state_54159__$1;
(statearr_54166_54181[(5)] = ex54163);


if((ex54163 instanceof Error)){
var statearr_54167_54182 = state_54159__$1;
(statearr_54167_54182[(1)] = (4));

(statearr_54167_54182[(5)] = null);

} else {
throw ex54163;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54160 === (6))){
var inst_54138 = (state_54159[(2)]);
var inst_54139 = fluree.db.util.async.throw_err(inst_54138);
var inst_54140 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_54139);
var inst_54141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54142 = [inst_54139];
var inst_54143 = (new cljs.core.PersistentVector(null,1,(5),inst_54141,inst_54142,null));
var inst_54144 = cljs.core.count(inst_54143);
var inst_54145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54146 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54148 = [inst_54139];
var inst_54149 = (new cljs.core.PersistentVector(null,1,(5),inst_54147,inst_54148,null));
var inst_54150 = ["or",inst_54149,inst_54140];
var inst_54151 = cljs.core.PersistentHashMap.fromArrays(inst_54146,inst_54150);
var inst_54152 = [inst_54151,inst_54144];
var inst_54153 = (new cljs.core.PersistentVector(null,2,(5),inst_54145,inst_54152,null));
var inst_54154 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54153);
var _ = (function (){var statearr_54168 = state_54159;
(statearr_54168[(4)] = cljs.core.rest((state_54159[(4)])));

return statearr_54168;
})();
var state_54159__$1 = (function (){var statearr_54169 = state_54159;
(statearr_54169[(7)] = inst_54154);

return statearr_54169;
})();
var statearr_54170_54183 = state_54159__$1;
(statearr_54170_54183[(2)] = inst_54140);

(statearr_54170_54183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54171 = [null,null,null,null,null,null,null,null];
(statearr_54171[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54171[(1)] = (1));

return statearr_54171;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54159){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54159);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54172){var ex__2730__auto__ = e54172;
var statearr_54173_54184 = state_54159;
(statearr_54173_54184[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54159[(4)]))){
var statearr_54174_54185 = state_54159;
(statearr_54174_54185[(1)] = cljs.core.first((state_54159[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54186 = state_54159;
state_54159 = G__54186;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54159){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54175 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54175[(6)] = c__2749__auto__);

return statearr_54175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54128){
var G__54129 = cljs.core.first(seq54128);
var seq54128__$1 = cljs.core.next(seq54128);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54129,seq54128__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54224){
var state_val_54225 = (state_54224[(1)]);
if((state_val_54225 === (7))){
var inst_54200 = fluree.db.util.async.channel_QMARK_(coll);
var state_54224__$1 = state_54224;
if(inst_54200){
var statearr_54226_54249 = state_54224__$1;
(statearr_54226_54249[(1)] = (10));

} else {
var statearr_54227_54250 = state_54224__$1;
(statearr_54227_54250[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (1))){
var state_54224__$1 = state_54224;
var statearr_54228_54251 = state_54224__$1;
(statearr_54228_54251[(2)] = null);

(statearr_54228_54251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (4))){
var inst_54187 = (state_54224[(2)]);
var state_54224__$1 = state_54224;
var statearr_54229_54252 = state_54224__$1;
(statearr_54229_54252[(2)] = inst_54187);

(statearr_54229_54252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (13))){
var inst_54203 = (state_54224[(2)]);
var inst_54204 = fluree.db.util.async.throw_err(inst_54203);
var state_54224__$1 = state_54224;
var statearr_54230_54253 = state_54224__$1;
(statearr_54230_54253[(2)] = inst_54204);

(statearr_54230_54253[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (6))){
var inst_54195 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_54224__$1 = state_54224;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54224__$1,(9),inst_54195);
} else {
if((state_val_54225 === (3))){
var inst_54222 = (state_54224[(2)]);
var state_54224__$1 = state_54224;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54224__$1,inst_54222);
} else {
if((state_val_54225 === (12))){
var inst_54207 = (state_54224[(2)]);
var state_54224__$1 = state_54224;
var statearr_54231_54254 = state_54224__$1;
(statearr_54231_54254[(2)] = inst_54207);

(statearr_54231_54254[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (2))){
var _ = (function (){var statearr_54232 = state_54224;
(statearr_54232[(4)] = cljs.core.cons((5),(state_54224[(4)])));

return statearr_54232;
})();
var inst_54193 = cljs.core.vector_QMARK_(coll);
var state_54224__$1 = state_54224;
if(inst_54193){
var statearr_54233_54255 = state_54224__$1;
(statearr_54233_54255[(1)] = (6));

} else {
var statearr_54234_54256 = state_54224__$1;
(statearr_54234_54256[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (11))){
var state_54224__$1 = state_54224;
var statearr_54236_54257 = state_54224__$1;
(statearr_54236_54257[(2)] = coll);

(statearr_54236_54257[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (9))){
var inst_54197 = (state_54224[(2)]);
var inst_54198 = fluree.db.util.async.throw_err(inst_54197);
var state_54224__$1 = state_54224;
var statearr_54237_54258 = state_54224__$1;
(statearr_54237_54258[(2)] = inst_54198);

(statearr_54237_54258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (5))){
var _ = (function (){var statearr_54238 = state_54224;
(statearr_54238[(4)] = cljs.core.rest((state_54224[(4)])));

return statearr_54238;
})();
var state_54224__$1 = state_54224;
var ex54235 = (state_54224__$1[(2)]);
var statearr_54239_54259 = state_54224__$1;
(statearr_54239_54259[(5)] = ex54235);


if((ex54235 instanceof Error)){
var statearr_54240_54260 = state_54224__$1;
(statearr_54240_54260[(1)] = (4));

(statearr_54240_54260[(5)] = null);

} else {
throw ex54235;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (10))){
var state_54224__$1 = state_54224;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54224__$1,(13),coll);
} else {
if((state_val_54225 === (8))){
var inst_54209 = (state_54224[(2)]);
var inst_54210 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_54209);
var inst_54211 = cljs.core.count(inst_54210);
var inst_54212 = ((9) + inst_54211);
var inst_54213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54214 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54215 = ["count",inst_54209,inst_54211];
var inst_54216 = cljs.core.PersistentHashMap.fromArrays(inst_54214,inst_54215);
var inst_54217 = [inst_54216,inst_54212];
var inst_54218 = (new cljs.core.PersistentVector(null,2,(5),inst_54213,inst_54217,null));
var inst_54219 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54218);
var _ = (function (){var statearr_54241 = state_54224;
(statearr_54241[(4)] = cljs.core.rest((state_54224[(4)])));

return statearr_54241;
})();
var state_54224__$1 = (function (){var statearr_54242 = state_54224;
(statearr_54242[(7)] = inst_54219);

return statearr_54242;
})();
var statearr_54243_54261 = state_54224__$1;
(statearr_54243_54261[(2)] = inst_54211);

(statearr_54243_54261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0 = (function (){
var statearr_54244 = [null,null,null,null,null,null,null,null];
(statearr_54244[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__);

(statearr_54244[(1)] = (1));

return statearr_54244;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1 = (function (state_54224){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54224);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54245){var ex__2730__auto__ = e54245;
var statearr_54246_54262 = state_54224;
(statearr_54246_54262[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54224[(4)]))){
var statearr_54247_54263 = state_54224;
(statearr_54247_54263[(1)] = cljs.core.first((state_54224[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54264 = state_54224;
state_54224 = G__54264;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = function(state_54224){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1.call(this,state_54224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54248 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54248[(6)] = c__2749__auto__);

return statearr_54248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54314){
var state_val_54315 = (state_54314[(1)]);
if((state_val_54315 === (7))){
var state_54314__$1 = state_54314;
var statearr_54316_54349 = state_54314__$1;
(statearr_54316_54349[(2)] = subject);

(statearr_54316_54349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (1))){
var state_54314__$1 = state_54314;
var statearr_54317_54350 = state_54314__$1;
(statearr_54317_54350[(2)] = null);

(statearr_54317_54350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (4))){
var inst_54265 = (state_54314[(2)]);
var state_54314__$1 = state_54314;
var statearr_54318_54351 = state_54314__$1;
(statearr_54318_54351[(2)] = inst_54265);

(statearr_54318_54351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (15))){
var inst_54278 = (state_54314[(7)]);
var state_54314__$1 = state_54314;
var statearr_54319_54352 = state_54314__$1;
(statearr_54319_54352[(2)] = inst_54278);

(statearr_54319_54352[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (13))){
var inst_54282 = (state_54314[(2)]);
var inst_54283 = fluree.db.util.async.throw_err(inst_54282);
var state_54314__$1 = state_54314;
var statearr_54320_54353 = state_54314__$1;
(statearr_54320_54353[(2)] = inst_54283);

(statearr_54320_54353[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (6))){
var state_54314__$1 = state_54314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54314__$1,(9),subject);
} else {
if((state_val_54315 === (17))){
var inst_54278 = (state_54314[(7)]);
var inst_54292 = cljs.core.first(inst_54278);
var state_54314__$1 = state_54314;
var statearr_54321_54354 = state_54314__$1;
(statearr_54321_54354[(2)] = inst_54292);

(statearr_54321_54354[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (3))){
var inst_54312 = (state_54314[(2)]);
var state_54314__$1 = state_54314;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54314__$1,inst_54312);
} else {
if((state_val_54315 === (12))){
var inst_54278 = (state_54314[(7)]);
var inst_54286 = (state_54314[(2)]);
var inst_54287 = cljs.core.vector_QMARK_(inst_54278);
var state_54314__$1 = (function (){var statearr_54322 = state_54314;
(statearr_54322[(8)] = inst_54286);

return statearr_54322;
})();
if(inst_54287){
var statearr_54323_54355 = state_54314__$1;
(statearr_54323_54355[(1)] = (14));

} else {
var statearr_54324_54356 = state_54314__$1;
(statearr_54324_54356[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (2))){
var _ = (function (){var statearr_54325 = state_54314;
(statearr_54325[(4)] = cljs.core.cons((5),(state_54314[(4)])));

return statearr_54325;
})();
var inst_54271 = fluree.db.util.async.channel_QMARK_(subject);
var state_54314__$1 = state_54314;
if(inst_54271){
var statearr_54326_54357 = state_54314__$1;
(statearr_54326_54357[(1)] = (6));

} else {
var statearr_54327_54358 = state_54314__$1;
(statearr_54327_54358[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (19))){
var inst_54295 = (state_54314[(2)]);
var state_54314__$1 = state_54314;
var statearr_54328_54359 = state_54314__$1;
(statearr_54328_54359[(2)] = inst_54295);

(statearr_54328_54359[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (11))){
var state_54314__$1 = state_54314;
var statearr_54330_54360 = state_54314__$1;
(statearr_54330_54360[(2)] = pred);

(statearr_54330_54360[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (9))){
var inst_54274 = (state_54314[(2)]);
var inst_54275 = fluree.db.util.async.throw_err(inst_54274);
var state_54314__$1 = state_54314;
var statearr_54331_54361 = state_54314__$1;
(statearr_54331_54361[(2)] = inst_54275);

(statearr_54331_54361[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (5))){
var _ = (function (){var statearr_54332 = state_54314;
(statearr_54332[(4)] = cljs.core.rest((state_54314[(4)])));

return statearr_54332;
})();
var state_54314__$1 = state_54314;
var ex54329 = (state_54314__$1[(2)]);
var statearr_54333_54362 = state_54314__$1;
(statearr_54333_54362[(5)] = ex54329);


if((ex54329 instanceof Error)){
var statearr_54334_54363 = state_54314__$1;
(statearr_54334_54363[(1)] = (4));

(statearr_54334_54363[(5)] = null);

} else {
throw ex54329;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (14))){
var inst_54278 = (state_54314[(7)]);
var inst_54289 = cljs.core.count(inst_54278);
var inst_54290 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54289);
var state_54314__$1 = state_54314;
if(inst_54290){
var statearr_54335_54364 = state_54314__$1;
(statearr_54335_54364[(1)] = (17));

} else {
var statearr_54336_54365 = state_54314__$1;
(statearr_54336_54365[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (16))){
var inst_54286 = (state_54314[(8)]);
var inst_54278 = (state_54314[(7)]);
var inst_54298 = (state_54314[(2)]);
var inst_54299 = fluree.db.dbfunctions.internal.get(inst_54298,inst_54286);
var inst_54300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54301 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54303 = [inst_54278,inst_54286];
var inst_54304 = (new cljs.core.PersistentVector(null,2,(5),inst_54302,inst_54303,null));
var inst_54305 = ["get",inst_54304,inst_54299];
var inst_54306 = cljs.core.PersistentHashMap.fromArrays(inst_54301,inst_54305);
var inst_54307 = [inst_54306,(10)];
var inst_54308 = (new cljs.core.PersistentVector(null,2,(5),inst_54300,inst_54307,null));
var inst_54309 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54308);
var _ = (function (){var statearr_54337 = state_54314;
(statearr_54337[(4)] = cljs.core.rest((state_54314[(4)])));

return statearr_54337;
})();
var state_54314__$1 = (function (){var statearr_54338 = state_54314;
(statearr_54338[(9)] = inst_54309);

return statearr_54338;
})();
var statearr_54339_54366 = state_54314__$1;
(statearr_54339_54366[(2)] = inst_54299);

(statearr_54339_54366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (10))){
var state_54314__$1 = state_54314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54314__$1,(13),pred);
} else {
if((state_val_54315 === (18))){
var inst_54278 = (state_54314[(7)]);
var state_54314__$1 = state_54314;
var statearr_54340_54367 = state_54314__$1;
(statearr_54340_54367[(2)] = inst_54278);

(statearr_54340_54367[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54315 === (8))){
var inst_54278 = (state_54314[(2)]);
var inst_54279 = fluree.db.util.async.channel_QMARK_(pred);
var state_54314__$1 = (function (){var statearr_54341 = state_54314;
(statearr_54341[(7)] = inst_54278);

return statearr_54341;
})();
if(inst_54279){
var statearr_54342_54368 = state_54314__$1;
(statearr_54342_54368[(1)] = (10));

} else {
var statearr_54343_54369 = state_54314__$1;
(statearr_54343_54369[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0 = (function (){
var statearr_54344 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54344[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__);

(statearr_54344[(1)] = (1));

return statearr_54344;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1 = (function (state_54314){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54314);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54345){var ex__2730__auto__ = e54345;
var statearr_54346_54370 = state_54314;
(statearr_54346_54370[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54314[(4)]))){
var statearr_54347_54371 = state_54314;
(statearr_54347_54371[(1)] = cljs.core.first((state_54314[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54372 = state_54314;
state_54314 = G__54372;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = function(state_54314){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1.call(this,state_54314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54348 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54348[(6)] = c__2749__auto__);

return statearr_54348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54411){
var state_val_54412 = (state_54411[(1)]);
if((state_val_54412 === (7))){
var inst_54379 = (state_54411[(7)]);
var state_54411__$1 = state_54411;
var statearr_54413_54437 = state_54411__$1;
(statearr_54413_54437[(2)] = inst_54379);

(statearr_54413_54437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54412 === (1))){
var state_54411__$1 = state_54411;
var statearr_54414_54438 = state_54411__$1;
(statearr_54414_54438[(2)] = null);

(statearr_54414_54438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54412 === (4))){
var inst_54373 = (state_54411[(2)]);
var state_54411__$1 = state_54411;
var statearr_54415_54439 = state_54411__$1;
(statearr_54415_54439[(2)] = inst_54373);

(statearr_54415_54439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54412 === (6))){
var inst_54381 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54411__$1 = state_54411;
var statearr_54416_54440 = state_54411__$1;
(statearr_54416_54440[(2)] = inst_54381);

(statearr_54416_54440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54412 === (3))){
var inst_54409 = (state_54411[(2)]);
var state_54411__$1 = state_54411;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54411__$1,inst_54409);
} else {
if((state_val_54412 === (12))){
var inst_54391 = (state_54411[(2)]);
var inst_54392 = fluree.db.util.async.throw_err(inst_54391);
var inst_54393 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54392,(0),null);
var inst_54394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54392,(1),null);
var inst_54395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54396 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54397 = ["?pO","?ctx",inst_54393];
var inst_54398 = cljs.core.PersistentHashMap.fromArrays(inst_54396,inst_54397);
var inst_54399 = ((10) + inst_54394);
var inst_54400 = [inst_54398,inst_54399];
var inst_54401 = (new cljs.core.PersistentVector(null,2,(5),inst_54395,inst_54400,null));
var inst_54402 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54401);
var state_54411__$1 = (function (){var statearr_54417 = state_54411;
(statearr_54417[(8)] = inst_54402);

return statearr_54417;
})();
var statearr_54418_54441 = state_54411__$1;
(statearr_54418_54441[(2)] = inst_54393);

(statearr_54418_54441[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54412 === (2))){
var inst_54379 = (state_54411[(7)]);
var _ = (function (){var statearr_54419 = state_54411;
(statearr_54419[(4)] = cljs.core.cons((5),(state_54411[(4)])));

return statearr_54419;
})();
var inst_54379__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54411__$1 = (function (){var statearr_54420 = state_54411;
(statearr_54420[(7)] = inst_54379__$1);

return statearr_54420;
})();
if(cljs.core.truth_(inst_54379__$1)){
var statearr_54421_54442 = state_54411__$1;
(statearr_54421_54442[(1)] = (6));

} else {
var statearr_54422_54443 = state_54411__$1;
(statearr_54422_54443[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54412 === (11))){
var inst_54406 = (state_54411[(2)]);
var _ = (function (){var statearr_54424 = state_54411;
(statearr_54424[(4)] = cljs.core.rest((state_54411[(4)])));

return statearr_54424;
})();
var state_54411__$1 = state_54411;
var statearr_54425_54444 = state_54411__$1;
(statearr_54425_54444[(2)] = inst_54406);

(statearr_54425_54444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54412 === (9))){
var inst_54389 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_54411__$1 = state_54411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54411__$1,(12),inst_54389);
} else {
if((state_val_54412 === (5))){
var _ = (function (){var statearr_54426 = state_54411;
(statearr_54426[(4)] = cljs.core.rest((state_54411[(4)])));

return statearr_54426;
})();
var state_54411__$1 = state_54411;
var ex54423 = (state_54411__$1[(2)]);
var statearr_54427_54445 = state_54411__$1;
(statearr_54427_54445[(5)] = ex54423);


if((ex54423 instanceof Error)){
var statearr_54428_54446 = state_54411__$1;
(statearr_54428_54446[(1)] = (4));

(statearr_54428_54446[(5)] = null);

} else {
throw ex54423;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54412 === (10))){
var inst_54404 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54411__$1 = state_54411;
var statearr_54429_54447 = state_54411__$1;
(statearr_54429_54447[(2)] = inst_54404);

(statearr_54429_54447[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54412 === (8))){
var inst_54384 = (state_54411[(2)]);
var state_54411__$1 = state_54411;
if(cljs.core.truth_(inst_54384)){
var statearr_54430_54448 = state_54411__$1;
(statearr_54430_54448[(1)] = (9));

} else {
var statearr_54431_54449 = state_54411__$1;
(statearr_54431_54449[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_54432 = [null,null,null,null,null,null,null,null,null];
(statearr_54432[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_54432[(1)] = (1));

return statearr_54432;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_54411){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54411);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54433){var ex__2730__auto__ = e54433;
var statearr_54434_54450 = state_54411;
(statearr_54434_54450[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54411[(4)]))){
var statearr_54435_54451 = state_54411;
(statearr_54435_54451[(1)] = cljs.core.first((state_54411[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54452 = state_54411;
state_54411 = G__54452;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = function(state_54411){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_54411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54436 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54436[(6)] = c__2749__auto__);

return statearr_54436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54504){
var state_val_54505 = (state_54504[(1)]);
if((state_val_54505 === (7))){
var state_54504__$1 = state_54504;
var statearr_54506_54539 = state_54504__$1;
(statearr_54506_54539[(2)] = subject);

(statearr_54506_54539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (1))){
var state_54504__$1 = state_54504;
var statearr_54507_54540 = state_54504__$1;
(statearr_54507_54540[(2)] = null);

(statearr_54507_54540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (4))){
var inst_54453 = (state_54504[(2)]);
var state_54504__$1 = state_54504;
var statearr_54508_54541 = state_54504__$1;
(statearr_54508_54541[(2)] = inst_54453);

(statearr_54508_54541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (15))){
var inst_54466 = (state_54504[(7)]);
var state_54504__$1 = state_54504;
var statearr_54509_54542 = state_54504__$1;
(statearr_54509_54542[(2)] = inst_54466);

(statearr_54509_54542[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (13))){
var inst_54470 = (state_54504[(2)]);
var inst_54471 = fluree.db.util.async.throw_err(inst_54470);
var state_54504__$1 = state_54504;
var statearr_54510_54543 = state_54504__$1;
(statearr_54510_54543[(2)] = inst_54471);

(statearr_54510_54543[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (6))){
var state_54504__$1 = state_54504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54504__$1,(9),subject);
} else {
if((state_val_54505 === (17))){
var inst_54466 = (state_54504[(7)]);
var inst_54480 = cljs.core.first(inst_54466);
var state_54504__$1 = state_54504;
var statearr_54511_54544 = state_54504__$1;
(statearr_54511_54544[(2)] = inst_54480);

(statearr_54511_54544[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (3))){
var inst_54502 = (state_54504[(2)]);
var state_54504__$1 = state_54504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54504__$1,inst_54502);
} else {
if((state_val_54505 === (12))){
var inst_54466 = (state_54504[(7)]);
var inst_54474 = (state_54504[(2)]);
var inst_54475 = cljs.core.vector_QMARK_(inst_54466);
var state_54504__$1 = (function (){var statearr_54512 = state_54504;
(statearr_54512[(8)] = inst_54474);

return statearr_54512;
})();
if(inst_54475){
var statearr_54513_54545 = state_54504__$1;
(statearr_54513_54545[(1)] = (14));

} else {
var statearr_54514_54546 = state_54504__$1;
(statearr_54514_54546[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (2))){
var _ = (function (){var statearr_54515 = state_54504;
(statearr_54515[(4)] = cljs.core.cons((5),(state_54504[(4)])));

return statearr_54515;
})();
var inst_54459 = fluree.db.util.async.channel_QMARK_(subject);
var state_54504__$1 = state_54504;
if(inst_54459){
var statearr_54516_54547 = state_54504__$1;
(statearr_54516_54547[(1)] = (6));

} else {
var statearr_54517_54548 = state_54504__$1;
(statearr_54517_54548[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (19))){
var inst_54483 = (state_54504[(2)]);
var state_54504__$1 = state_54504;
var statearr_54518_54549 = state_54504__$1;
(statearr_54518_54549[(2)] = inst_54483);

(statearr_54518_54549[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (11))){
var state_54504__$1 = state_54504;
var statearr_54520_54550 = state_54504__$1;
(statearr_54520_54550[(2)] = path);

(statearr_54520_54550[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (9))){
var inst_54462 = (state_54504[(2)]);
var inst_54463 = fluree.db.util.async.throw_err(inst_54462);
var state_54504__$1 = state_54504;
var statearr_54521_54551 = state_54504__$1;
(statearr_54521_54551[(2)] = inst_54463);

(statearr_54521_54551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (5))){
var _ = (function (){var statearr_54522 = state_54504;
(statearr_54522[(4)] = cljs.core.rest((state_54504[(4)])));

return statearr_54522;
})();
var state_54504__$1 = state_54504;
var ex54519 = (state_54504__$1[(2)]);
var statearr_54523_54552 = state_54504__$1;
(statearr_54523_54552[(5)] = ex54519);


if((ex54519 instanceof Error)){
var statearr_54524_54553 = state_54504__$1;
(statearr_54524_54553[(1)] = (4));

(statearr_54524_54553[(5)] = null);

} else {
throw ex54519;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (14))){
var inst_54466 = (state_54504[(7)]);
var inst_54477 = cljs.core.count(inst_54466);
var inst_54478 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54477);
var state_54504__$1 = state_54504;
if(inst_54478){
var statearr_54525_54554 = state_54504__$1;
(statearr_54525_54554[(1)] = (17));

} else {
var statearr_54526_54555 = state_54504__$1;
(statearr_54526_54555[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (16))){
var inst_54474 = (state_54504[(8)]);
var inst_54466 = (state_54504[(7)]);
var inst_54486 = (state_54504[(2)]);
var inst_54487 = fluree.db.dbfunctions.internal.get_all(inst_54486,inst_54474);
var inst_54488 = cljs.core.count(inst_54474);
var inst_54489 = ((9) + inst_54488);
var inst_54490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54491 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54493 = [inst_54466,inst_54474];
var inst_54494 = (new cljs.core.PersistentVector(null,2,(5),inst_54492,inst_54493,null));
var inst_54495 = ["get-all",inst_54494,inst_54487];
var inst_54496 = cljs.core.PersistentHashMap.fromArrays(inst_54491,inst_54495);
var inst_54497 = [inst_54496,inst_54489];
var inst_54498 = (new cljs.core.PersistentVector(null,2,(5),inst_54490,inst_54497,null));
var inst_54499 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54498);
var _ = (function (){var statearr_54527 = state_54504;
(statearr_54527[(4)] = cljs.core.rest((state_54504[(4)])));

return statearr_54527;
})();
var state_54504__$1 = (function (){var statearr_54528 = state_54504;
(statearr_54528[(9)] = inst_54499);

return statearr_54528;
})();
var statearr_54529_54556 = state_54504__$1;
(statearr_54529_54556[(2)] = inst_54487);

(statearr_54529_54556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (10))){
var state_54504__$1 = state_54504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54504__$1,(13),path);
} else {
if((state_val_54505 === (18))){
var inst_54466 = (state_54504[(7)]);
var state_54504__$1 = state_54504;
var statearr_54530_54557 = state_54504__$1;
(statearr_54530_54557[(2)] = inst_54466);

(statearr_54530_54557[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54505 === (8))){
var inst_54466 = (state_54504[(2)]);
var inst_54467 = fluree.db.util.async.channel_QMARK_(path);
var state_54504__$1 = (function (){var statearr_54531 = state_54504;
(statearr_54531[(7)] = inst_54466);

return statearr_54531;
})();
if(inst_54467){
var statearr_54532_54558 = state_54504__$1;
(statearr_54532_54558[(1)] = (10));

} else {
var statearr_54533_54559 = state_54504__$1;
(statearr_54533_54559[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0 = (function (){
var statearr_54534 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54534[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__);

(statearr_54534[(1)] = (1));

return statearr_54534;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1 = (function (state_54504){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54504);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54535){var ex__2730__auto__ = e54535;
var statearr_54536_54560 = state_54504;
(statearr_54536_54560[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54504[(4)]))){
var statearr_54537_54561 = state_54504;
(statearr_54537_54561[(1)] = cljs.core.first((state_54504[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54562 = state_54504;
state_54504 = G__54562;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = function(state_54504){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1.call(this,state_54504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54538 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54538[(6)] = c__2749__auto__);

return statearr_54538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54601){
var state_val_54602 = (state_54601[(1)]);
if((state_val_54602 === (7))){
var state_54601__$1 = state_54601;
var statearr_54603_54627 = state_54601__$1;
(statearr_54603_54627[(2)] = subject);

(statearr_54603_54627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54602 === (1))){
var state_54601__$1 = state_54601;
var statearr_54604_54628 = state_54601__$1;
(statearr_54604_54628[(2)] = null);

(statearr_54604_54628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54602 === (4))){
var inst_54563 = (state_54601[(2)]);
var state_54601__$1 = state_54601;
var statearr_54605_54629 = state_54601__$1;
(statearr_54605_54629[(2)] = inst_54563);

(statearr_54605_54629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54602 === (13))){
var inst_54580 = (state_54601[(2)]);
var inst_54581 = fluree.db.util.async.throw_err(inst_54580);
var state_54601__$1 = state_54601;
var statearr_54606_54630 = state_54601__$1;
(statearr_54606_54630[(2)] = inst_54581);

(statearr_54606_54630[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54602 === (6))){
var state_54601__$1 = state_54601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54601__$1,(9),subject);
} else {
if((state_val_54602 === (3))){
var inst_54599 = (state_54601[(2)]);
var state_54601__$1 = state_54601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54601__$1,inst_54599);
} else {
if((state_val_54602 === (12))){
var inst_54576 = (state_54601[(7)]);
var inst_54584 = (state_54601[(2)]);
var inst_54585 = fluree.db.dbfunctions.internal.get_in(inst_54576,inst_54584);
var inst_54586 = cljs.core.count(inst_54584);
var inst_54587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54588 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54590 = [inst_54576,inst_54584];
var inst_54591 = (new cljs.core.PersistentVector(null,2,(5),inst_54589,inst_54590,null));
var inst_54592 = ["get-in",inst_54591,inst_54585];
var inst_54593 = cljs.core.PersistentHashMap.fromArrays(inst_54588,inst_54592);
var inst_54594 = [inst_54593,inst_54586];
var inst_54595 = (new cljs.core.PersistentVector(null,2,(5),inst_54587,inst_54594,null));
var inst_54596 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54595);
var _ = (function (){var statearr_54607 = state_54601;
(statearr_54607[(4)] = cljs.core.rest((state_54601[(4)])));

return statearr_54607;
})();
var state_54601__$1 = (function (){var statearr_54608 = state_54601;
(statearr_54608[(8)] = inst_54596);

return statearr_54608;
})();
var statearr_54609_54631 = state_54601__$1;
(statearr_54609_54631[(2)] = inst_54585);

(statearr_54609_54631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54602 === (2))){
var _ = (function (){var statearr_54610 = state_54601;
(statearr_54610[(4)] = cljs.core.cons((5),(state_54601[(4)])));

return statearr_54610;
})();
var inst_54569 = fluree.db.util.async.channel_QMARK_(subject);
var state_54601__$1 = state_54601;
if(inst_54569){
var statearr_54611_54632 = state_54601__$1;
(statearr_54611_54632[(1)] = (6));

} else {
var statearr_54612_54633 = state_54601__$1;
(statearr_54612_54633[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54602 === (11))){
var state_54601__$1 = state_54601;
var statearr_54614_54634 = state_54601__$1;
(statearr_54614_54634[(2)] = path);

(statearr_54614_54634[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54602 === (9))){
var inst_54572 = (state_54601[(2)]);
var inst_54573 = fluree.db.util.async.throw_err(inst_54572);
var state_54601__$1 = state_54601;
var statearr_54615_54635 = state_54601__$1;
(statearr_54615_54635[(2)] = inst_54573);

(statearr_54615_54635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54602 === (5))){
var _ = (function (){var statearr_54616 = state_54601;
(statearr_54616[(4)] = cljs.core.rest((state_54601[(4)])));

return statearr_54616;
})();
var state_54601__$1 = state_54601;
var ex54613 = (state_54601__$1[(2)]);
var statearr_54617_54636 = state_54601__$1;
(statearr_54617_54636[(5)] = ex54613);


if((ex54613 instanceof Error)){
var statearr_54618_54637 = state_54601__$1;
(statearr_54618_54637[(1)] = (4));

(statearr_54618_54637[(5)] = null);

} else {
throw ex54613;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54602 === (10))){
var state_54601__$1 = state_54601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54601__$1,(13),path);
} else {
if((state_val_54602 === (8))){
var inst_54576 = (state_54601[(2)]);
var inst_54577 = fluree.db.util.async.channel_QMARK_(path);
var state_54601__$1 = (function (){var statearr_54619 = state_54601;
(statearr_54619[(7)] = inst_54576);

return statearr_54619;
})();
if(inst_54577){
var statearr_54620_54638 = state_54601__$1;
(statearr_54620_54638[(1)] = (10));

} else {
var statearr_54621_54639 = state_54601__$1;
(statearr_54621_54639[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0 = (function (){
var statearr_54622 = [null,null,null,null,null,null,null,null,null];
(statearr_54622[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__);

(statearr_54622[(1)] = (1));

return statearr_54622;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1 = (function (state_54601){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54601);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54623){var ex__2730__auto__ = e54623;
var statearr_54624_54640 = state_54601;
(statearr_54624_54640[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54601[(4)]))){
var statearr_54625_54641 = state_54601;
(statearr_54625_54641[(1)] = cljs.core.first((state_54601[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54642 = state_54601;
state_54601 = G__54642;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = function(state_54601){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1.call(this,state_54601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54626 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54626[(6)] = c__2749__auto__);

return statearr_54626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54687){
var state_val_54688 = (state_54687[(1)]);
if((state_val_54688 === (7))){
var state_54687__$1 = state_54687;
var statearr_54689_54718 = state_54687__$1;
(statearr_54689_54718[(2)] = coll);

(statearr_54689_54718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (1))){
var state_54687__$1 = state_54687;
var statearr_54690_54719 = state_54687__$1;
(statearr_54690_54719[(2)] = null);

(statearr_54690_54719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (4))){
var inst_54643 = (state_54687[(2)]);
var state_54687__$1 = state_54687;
var statearr_54691_54720 = state_54687__$1;
(statearr_54691_54720[(2)] = inst_54643);

(statearr_54691_54720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (15))){
var inst_54663 = (state_54687[(7)]);
var inst_54671 = (state_54687[(2)]);
var inst_54672 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_54663,inst_54671);
var inst_54673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54674 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54676 = [inst_54663,inst_54671];
var inst_54677 = (new cljs.core.PersistentVector(null,2,(5),inst_54675,inst_54676,null));
var inst_54678 = ["contains?",inst_54677,inst_54672];
var inst_54679 = cljs.core.PersistentHashMap.fromArrays(inst_54674,inst_54678);
var inst_54680 = [inst_54679,(10)];
var inst_54681 = (new cljs.core.PersistentVector(null,2,(5),inst_54673,inst_54680,null));
var inst_54682 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54681);
var _ = (function (){var statearr_54692 = state_54687;
(statearr_54692[(4)] = cljs.core.rest((state_54687[(4)])));

return statearr_54692;
})();
var state_54687__$1 = (function (){var statearr_54693 = state_54687;
(statearr_54693[(8)] = inst_54682);

return statearr_54693;
})();
var statearr_54694_54721 = state_54687__$1;
(statearr_54694_54721[(2)] = inst_54672);

(statearr_54694_54721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (13))){
var state_54687__$1 = state_54687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54687__$1,(16),key);
} else {
if((state_val_54688 === (6))){
var state_54687__$1 = state_54687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54687__$1,(9),coll);
} else {
if((state_val_54688 === (3))){
var inst_54685 = (state_54687[(2)]);
var state_54687__$1 = state_54687;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54687__$1,inst_54685);
} else {
if((state_val_54688 === (12))){
var inst_54663 = (state_54687[(2)]);
var inst_54664 = fluree.db.util.async.channel_QMARK_(key);
var state_54687__$1 = (function (){var statearr_54695 = state_54687;
(statearr_54695[(7)] = inst_54663);

return statearr_54695;
})();
if(inst_54664){
var statearr_54696_54722 = state_54687__$1;
(statearr_54696_54722[(1)] = (13));

} else {
var statearr_54697_54723 = state_54687__$1;
(statearr_54697_54723[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (2))){
var _ = (function (){var statearr_54698 = state_54687;
(statearr_54698[(4)] = cljs.core.cons((5),(state_54687[(4)])));

return statearr_54698;
})();
var inst_54649 = fluree.db.util.async.channel_QMARK_(coll);
var state_54687__$1 = state_54687;
if(inst_54649){
var statearr_54699_54724 = state_54687__$1;
(statearr_54699_54724[(1)] = (6));

} else {
var statearr_54700_54725 = state_54687__$1;
(statearr_54700_54725[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (11))){
var inst_54656 = (state_54687[(9)]);
var inst_54660 = cljs.core.flatten(inst_54656);
var inst_54661 = cljs.core.set(inst_54660);
var state_54687__$1 = state_54687;
var statearr_54702_54726 = state_54687__$1;
(statearr_54702_54726[(2)] = inst_54661);

(statearr_54702_54726[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (9))){
var inst_54652 = (state_54687[(2)]);
var inst_54653 = fluree.db.util.async.throw_err(inst_54652);
var state_54687__$1 = state_54687;
var statearr_54703_54727 = state_54687__$1;
(statearr_54703_54727[(2)] = inst_54653);

(statearr_54703_54727[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (5))){
var _ = (function (){var statearr_54704 = state_54687;
(statearr_54704[(4)] = cljs.core.rest((state_54687[(4)])));

return statearr_54704;
})();
var state_54687__$1 = state_54687;
var ex54701 = (state_54687__$1[(2)]);
var statearr_54705_54728 = state_54687__$1;
(statearr_54705_54728[(5)] = ex54701);


if((ex54701 instanceof Error)){
var statearr_54706_54729 = state_54687__$1;
(statearr_54706_54729[(1)] = (4));

(statearr_54706_54729[(5)] = null);

} else {
throw ex54701;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (14))){
var state_54687__$1 = state_54687;
var statearr_54707_54730 = state_54687__$1;
(statearr_54707_54730[(2)] = key);

(statearr_54707_54730[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (16))){
var inst_54667 = (state_54687[(2)]);
var inst_54668 = fluree.db.util.async.throw_err(inst_54667);
var state_54687__$1 = state_54687;
var statearr_54708_54731 = state_54687__$1;
(statearr_54708_54731[(2)] = inst_54668);

(statearr_54708_54731[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (10))){
var inst_54656 = (state_54687[(9)]);
var state_54687__$1 = state_54687;
var statearr_54709_54732 = state_54687__$1;
(statearr_54709_54732[(2)] = inst_54656);

(statearr_54709_54732[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (8))){
var inst_54656 = (state_54687[(9)]);
var inst_54656__$1 = (state_54687[(2)]);
var inst_54657 = cljs.core.set_QMARK_(inst_54656__$1);
var state_54687__$1 = (function (){var statearr_54710 = state_54687;
(statearr_54710[(9)] = inst_54656__$1);

return statearr_54710;
})();
if(inst_54657){
var statearr_54711_54733 = state_54687__$1;
(statearr_54711_54733[(1)] = (10));

} else {
var statearr_54712_54734 = state_54687__$1;
(statearr_54712_54734[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_54713 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54713[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__);

(statearr_54713[(1)] = (1));

return statearr_54713;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1 = (function (state_54687){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54687);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54714){var ex__2730__auto__ = e54714;
var statearr_54715_54735 = state_54687;
(statearr_54715_54735[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54687[(4)]))){
var statearr_54716_54736 = state_54687;
(statearr_54716_54736[(1)] = cljs.core.first((state_54687[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54737 = state_54687;
state_54687 = G__54737;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = function(state_54687){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1.call(this,state_54687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54717 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54717[(6)] = c__2749__auto__);

return statearr_54717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54809 = arguments.length;
var i__4865__auto___54810 = (0);
while(true){
if((i__4865__auto___54810 < len__4864__auto___54809)){
args__4870__auto__.push((arguments[i__4865__auto___54810]));

var G__54811 = (i__4865__auto___54810 + (1));
i__4865__auto___54810 = G__54811;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54783){
var state_val_54784 = (state_54783[(1)]);
if((state_val_54784 === (7))){
var inst_54749 = (state_54783[(7)]);
var inst_54753 = cljs.core.first(inst_54749);
var inst_54754 = cljs.core.coll_QMARK_(inst_54753);
var state_54783__$1 = state_54783;
var statearr_54785_54812 = state_54783__$1;
(statearr_54785_54812[(2)] = inst_54754);

(statearr_54785_54812[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54784 === (1))){
var state_54783__$1 = state_54783;
var statearr_54786_54813 = state_54783__$1;
(statearr_54786_54813[(2)] = null);

(statearr_54786_54813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54784 === (4))){
var inst_54740 = (state_54783[(2)]);
var state_54783__$1 = state_54783;
var statearr_54787_54814 = state_54783__$1;
(statearr_54787_54814[(2)] = inst_54740);

(statearr_54787_54814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54784 === (6))){
var inst_54749 = (state_54783[(7)]);
var inst_54751 = (state_54783[(8)]);
var inst_54748 = (state_54783[(2)]);
var inst_54749__$1 = fluree.db.util.async.throw_err(inst_54748);
var inst_54750 = cljs.core.count(inst_54749__$1);
var inst_54751__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54750);
var state_54783__$1 = (function (){var statearr_54788 = state_54783;
(statearr_54788[(7)] = inst_54749__$1);

(statearr_54788[(8)] = inst_54751__$1);

return statearr_54788;
})();
if(inst_54751__$1){
var statearr_54789_54815 = state_54783__$1;
(statearr_54789_54815[(1)] = (7));

} else {
var statearr_54790_54816 = state_54783__$1;
(statearr_54790_54816[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54784 === (3))){
var inst_54781 = (state_54783[(2)]);
var state_54783__$1 = state_54783;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54783__$1,inst_54781);
} else {
if((state_val_54784 === (12))){
var inst_54762 = (state_54783[(2)]);
var inst_54763 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_54762);
var inst_54764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54765 = [inst_54762];
var inst_54766 = (new cljs.core.PersistentVector(null,1,(5),inst_54764,inst_54765,null));
var inst_54767 = cljs.core.count(inst_54766);
var inst_54768 = ((9) + inst_54767);
var inst_54769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54770 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54772 = [inst_54762];
var inst_54773 = (new cljs.core.PersistentVector(null,1,(5),inst_54771,inst_54772,null));
var inst_54774 = ["hash-set",inst_54773,inst_54763];
var inst_54775 = cljs.core.PersistentHashMap.fromArrays(inst_54770,inst_54774);
var inst_54776 = [inst_54775,inst_54768];
var inst_54777 = (new cljs.core.PersistentVector(null,2,(5),inst_54769,inst_54776,null));
var inst_54778 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54777);
var _ = (function (){var statearr_54791 = state_54783;
(statearr_54791[(4)] = cljs.core.rest((state_54783[(4)])));

return statearr_54791;
})();
var state_54783__$1 = (function (){var statearr_54792 = state_54783;
(statearr_54792[(9)] = inst_54778);

return statearr_54792;
})();
var statearr_54793_54817 = state_54783__$1;
(statearr_54793_54817[(2)] = inst_54763);

(statearr_54793_54817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54784 === (2))){
var _ = (function (){var statearr_54794 = state_54783;
(statearr_54794[(4)] = cljs.core.cons((5),(state_54783[(4)])));

return statearr_54794;
})();
var inst_54746 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54783__$1 = state_54783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54783__$1,(6),inst_54746);
} else {
if((state_val_54784 === (11))){
var inst_54749 = (state_54783[(7)]);
var state_54783__$1 = state_54783;
var statearr_54796_54818 = state_54783__$1;
(statearr_54796_54818[(2)] = inst_54749);

(statearr_54796_54818[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54784 === (9))){
var inst_54757 = (state_54783[(2)]);
var state_54783__$1 = state_54783;
if(cljs.core.truth_(inst_54757)){
var statearr_54797_54819 = state_54783__$1;
(statearr_54797_54819[(1)] = (10));

} else {
var statearr_54798_54820 = state_54783__$1;
(statearr_54798_54820[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54784 === (5))){
var _ = (function (){var statearr_54799 = state_54783;
(statearr_54799[(4)] = cljs.core.rest((state_54783[(4)])));

return statearr_54799;
})();
var state_54783__$1 = state_54783;
var ex54795 = (state_54783__$1[(2)]);
var statearr_54800_54821 = state_54783__$1;
(statearr_54800_54821[(5)] = ex54795);


if((ex54795 instanceof Error)){
var statearr_54801_54822 = state_54783__$1;
(statearr_54801_54822[(1)] = (4));

(statearr_54801_54822[(5)] = null);

} else {
throw ex54795;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54784 === (10))){
var inst_54749 = (state_54783[(7)]);
var inst_54759 = cljs.core.first(inst_54749);
var state_54783__$1 = state_54783;
var statearr_54802_54823 = state_54783__$1;
(statearr_54802_54823[(2)] = inst_54759);

(statearr_54802_54823[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54784 === (8))){
var inst_54751 = (state_54783[(8)]);
var state_54783__$1 = state_54783;
var statearr_54803_54824 = state_54783__$1;
(statearr_54803_54824[(2)] = inst_54751);

(statearr_54803_54824[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54804 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54804[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54804[(1)] = (1));

return statearr_54804;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54783){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54783);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54805){var ex__2730__auto__ = e54805;
var statearr_54806_54825 = state_54783;
(statearr_54806_54825[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54783[(4)]))){
var statearr_54807_54826 = state_54783;
(statearr_54807_54826[(1)] = cljs.core.first((state_54783[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54827 = state_54783;
state_54783 = G__54827;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54783){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54808 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54808[(6)] = c__2749__auto__);

return statearr_54808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq54738){
var G__54739 = cljs.core.first(seq54738);
var seq54738__$1 = cljs.core.next(seq54738);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54739,seq54738__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54877 = arguments.length;
var i__4865__auto___54878 = (0);
while(true){
if((i__4865__auto___54878 < len__4864__auto___54877)){
args__4870__auto__.push((arguments[i__4865__auto___54878]));

var G__54879 = (i__4865__auto___54878 + (1));
i__4865__auto___54878 = G__54879;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54860){
var state_val_54861 = (state_54860[(1)]);
if((state_val_54861 === (1))){
var state_54860__$1 = state_54860;
var statearr_54862_54880 = state_54860__$1;
(statearr_54862_54880[(2)] = null);

(statearr_54862_54880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54861 === (2))){
var _ = (function (){var statearr_54863 = state_54860;
(statearr_54863[(4)] = cljs.core.cons((5),(state_54860[(4)])));

return statearr_54863;
})();
var inst_54836 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54860__$1 = state_54860;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54860__$1,(6),inst_54836);
} else {
if((state_val_54861 === (3))){
var inst_54858 = (state_54860[(2)]);
var state_54860__$1 = state_54860;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54860__$1,inst_54858);
} else {
if((state_val_54861 === (4))){
var inst_54830 = (state_54860[(2)]);
var state_54860__$1 = state_54860;
var statearr_54865_54881 = state_54860__$1;
(statearr_54865_54881[(2)] = inst_54830);

(statearr_54865_54881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54861 === (5))){
var _ = (function (){var statearr_54866 = state_54860;
(statearr_54866[(4)] = cljs.core.rest((state_54860[(4)])));

return statearr_54866;
})();
var state_54860__$1 = state_54860;
var ex54864 = (state_54860__$1[(2)]);
var statearr_54867_54882 = state_54860__$1;
(statearr_54867_54882[(5)] = ex54864);


if((ex54864 instanceof Error)){
var statearr_54868_54883 = state_54860__$1;
(statearr_54868_54883[(1)] = (4));

(statearr_54868_54883[(5)] = null);

} else {
throw ex54864;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54861 === (6))){
var inst_54838 = (state_54860[(2)]);
var inst_54839 = fluree.db.util.async.throw_err(inst_54838);
var inst_54840 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_54839);
var inst_54841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54842 = [inst_54839];
var inst_54843 = (new cljs.core.PersistentVector(null,1,(5),inst_54841,inst_54842,null));
var inst_54844 = cljs.core.count(inst_54843);
var inst_54845 = ((9) + inst_54844);
var inst_54846 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54847 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54849 = [inst_54839];
var inst_54850 = (new cljs.core.PersistentVector(null,1,(5),inst_54848,inst_54849,null));
var inst_54851 = ["==",inst_54850,inst_54840];
var inst_54852 = cljs.core.PersistentHashMap.fromArrays(inst_54847,inst_54851);
var inst_54853 = [inst_54852,inst_54845];
var inst_54854 = (new cljs.core.PersistentVector(null,2,(5),inst_54846,inst_54853,null));
var inst_54855 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54854);
var _ = (function (){var statearr_54869 = state_54860;
(statearr_54869[(4)] = cljs.core.rest((state_54860[(4)])));

return statearr_54869;
})();
var state_54860__$1 = (function (){var statearr_54870 = state_54860;
(statearr_54870[(7)] = inst_54855);

return statearr_54870;
})();
var statearr_54871_54884 = state_54860__$1;
(statearr_54871_54884[(2)] = inst_54840);

(statearr_54871_54884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54872 = [null,null,null,null,null,null,null,null];
(statearr_54872[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54872[(1)] = (1));

return statearr_54872;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54860){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54860);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54873){var ex__2730__auto__ = e54873;
var statearr_54874_54885 = state_54860;
(statearr_54874_54885[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54860[(4)]))){
var statearr_54875_54886 = state_54860;
(statearr_54875_54886[(1)] = cljs.core.first((state_54860[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54887 = state_54860;
state_54860 = G__54887;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54860){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54876 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54876[(6)] = c__2749__auto__);

return statearr_54876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq54828){
var G__54829 = cljs.core.first(seq54828);
var seq54828__$1 = cljs.core.next(seq54828);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54829,seq54828__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54937 = arguments.length;
var i__4865__auto___54938 = (0);
while(true){
if((i__4865__auto___54938 < len__4864__auto___54937)){
args__4870__auto__.push((arguments[i__4865__auto___54938]));

var G__54939 = (i__4865__auto___54938 + (1));
i__4865__auto___54938 = G__54939;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54920){
var state_val_54921 = (state_54920[(1)]);
if((state_val_54921 === (1))){
var state_54920__$1 = state_54920;
var statearr_54922_54940 = state_54920__$1;
(statearr_54922_54940[(2)] = null);

(statearr_54922_54940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54921 === (2))){
var _ = (function (){var statearr_54923 = state_54920;
(statearr_54923[(4)] = cljs.core.cons((5),(state_54920[(4)])));

return statearr_54923;
})();
var inst_54896 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54920__$1 = state_54920;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54920__$1,(6),inst_54896);
} else {
if((state_val_54921 === (3))){
var inst_54918 = (state_54920[(2)]);
var state_54920__$1 = state_54920;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54920__$1,inst_54918);
} else {
if((state_val_54921 === (4))){
var inst_54890 = (state_54920[(2)]);
var state_54920__$1 = state_54920;
var statearr_54925_54941 = state_54920__$1;
(statearr_54925_54941[(2)] = inst_54890);

(statearr_54925_54941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54921 === (5))){
var _ = (function (){var statearr_54926 = state_54920;
(statearr_54926[(4)] = cljs.core.rest((state_54920[(4)])));

return statearr_54926;
})();
var state_54920__$1 = state_54920;
var ex54924 = (state_54920__$1[(2)]);
var statearr_54927_54942 = state_54920__$1;
(statearr_54927_54942[(5)] = ex54924);


if((ex54924 instanceof Error)){
var statearr_54928_54943 = state_54920__$1;
(statearr_54928_54943[(1)] = (4));

(statearr_54928_54943[(5)] = null);

} else {
throw ex54924;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54921 === (6))){
var inst_54898 = (state_54920[(2)]);
var inst_54899 = fluree.db.util.async.throw_err(inst_54898);
var inst_54900 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_54899);
var inst_54901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54902 = [inst_54899];
var inst_54903 = (new cljs.core.PersistentVector(null,1,(5),inst_54901,inst_54902,null));
var inst_54904 = cljs.core.count(inst_54903);
var inst_54905 = ((9) + inst_54904);
var inst_54906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54907 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54909 = [inst_54899];
var inst_54910 = (new cljs.core.PersistentVector(null,1,(5),inst_54908,inst_54909,null));
var inst_54911 = [">",inst_54910,inst_54900];
var inst_54912 = cljs.core.PersistentHashMap.fromArrays(inst_54907,inst_54911);
var inst_54913 = [inst_54912,inst_54905];
var inst_54914 = (new cljs.core.PersistentVector(null,2,(5),inst_54906,inst_54913,null));
var inst_54915 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54914);
var _ = (function (){var statearr_54929 = state_54920;
(statearr_54929[(4)] = cljs.core.rest((state_54920[(4)])));

return statearr_54929;
})();
var state_54920__$1 = (function (){var statearr_54930 = state_54920;
(statearr_54930[(7)] = inst_54915);

return statearr_54930;
})();
var statearr_54931_54944 = state_54920__$1;
(statearr_54931_54944[(2)] = inst_54900);

(statearr_54931_54944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54932 = [null,null,null,null,null,null,null,null];
(statearr_54932[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54932[(1)] = (1));

return statearr_54932;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54920){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54920);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54933){var ex__2730__auto__ = e54933;
var statearr_54934_54945 = state_54920;
(statearr_54934_54945[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54920[(4)]))){
var statearr_54935_54946 = state_54920;
(statearr_54935_54946[(1)] = cljs.core.first((state_54920[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54947 = state_54920;
state_54920 = G__54947;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54920){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54936 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54936[(6)] = c__2749__auto__);

return statearr_54936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq54888){
var G__54889 = cljs.core.first(seq54888);
var seq54888__$1 = cljs.core.next(seq54888);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54889,seq54888__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54997 = arguments.length;
var i__4865__auto___54998 = (0);
while(true){
if((i__4865__auto___54998 < len__4864__auto___54997)){
args__4870__auto__.push((arguments[i__4865__auto___54998]));

var G__54999 = (i__4865__auto___54998 + (1));
i__4865__auto___54998 = G__54999;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54980){
var state_val_54981 = (state_54980[(1)]);
if((state_val_54981 === (1))){
var state_54980__$1 = state_54980;
var statearr_54982_55000 = state_54980__$1;
(statearr_54982_55000[(2)] = null);

(statearr_54982_55000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54981 === (2))){
var _ = (function (){var statearr_54983 = state_54980;
(statearr_54983[(4)] = cljs.core.cons((5),(state_54980[(4)])));

return statearr_54983;
})();
var inst_54956 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54980__$1 = state_54980;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54980__$1,(6),inst_54956);
} else {
if((state_val_54981 === (3))){
var inst_54978 = (state_54980[(2)]);
var state_54980__$1 = state_54980;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54980__$1,inst_54978);
} else {
if((state_val_54981 === (4))){
var inst_54950 = (state_54980[(2)]);
var state_54980__$1 = state_54980;
var statearr_54985_55001 = state_54980__$1;
(statearr_54985_55001[(2)] = inst_54950);

(statearr_54985_55001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54981 === (5))){
var _ = (function (){var statearr_54986 = state_54980;
(statearr_54986[(4)] = cljs.core.rest((state_54980[(4)])));

return statearr_54986;
})();
var state_54980__$1 = state_54980;
var ex54984 = (state_54980__$1[(2)]);
var statearr_54987_55002 = state_54980__$1;
(statearr_54987_55002[(5)] = ex54984);


if((ex54984 instanceof Error)){
var statearr_54988_55003 = state_54980__$1;
(statearr_54988_55003[(1)] = (4));

(statearr_54988_55003[(5)] = null);

} else {
throw ex54984;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54981 === (6))){
var inst_54958 = (state_54980[(2)]);
var inst_54959 = fluree.db.util.async.throw_err(inst_54958);
var inst_54960 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_54959);
var inst_54961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54962 = [inst_54959];
var inst_54963 = (new cljs.core.PersistentVector(null,1,(5),inst_54961,inst_54962,null));
var inst_54964 = cljs.core.count(inst_54963);
var inst_54965 = ((9) + inst_54964);
var inst_54966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54967 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54969 = [inst_54959];
var inst_54970 = (new cljs.core.PersistentVector(null,1,(5),inst_54968,inst_54969,null));
var inst_54971 = ["<",inst_54970,inst_54960];
var inst_54972 = cljs.core.PersistentHashMap.fromArrays(inst_54967,inst_54971);
var inst_54973 = [inst_54972,inst_54965];
var inst_54974 = (new cljs.core.PersistentVector(null,2,(5),inst_54966,inst_54973,null));
var inst_54975 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54974);
var _ = (function (){var statearr_54989 = state_54980;
(statearr_54989[(4)] = cljs.core.rest((state_54980[(4)])));

return statearr_54989;
})();
var state_54980__$1 = (function (){var statearr_54990 = state_54980;
(statearr_54990[(7)] = inst_54975);

return statearr_54990;
})();
var statearr_54991_55004 = state_54980__$1;
(statearr_54991_55004[(2)] = inst_54960);

(statearr_54991_55004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54992 = [null,null,null,null,null,null,null,null];
(statearr_54992[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54992[(1)] = (1));

return statearr_54992;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54980){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54980);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54993){var ex__2730__auto__ = e54993;
var statearr_54994_55005 = state_54980;
(statearr_54994_55005[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54980[(4)]))){
var statearr_54995_55006 = state_54980;
(statearr_54995_55006[(1)] = cljs.core.first((state_54980[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55007 = state_54980;
state_54980 = G__55007;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54980){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54996 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54996[(6)] = c__2749__auto__);

return statearr_54996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq54948){
var G__54949 = cljs.core.first(seq54948);
var seq54948__$1 = cljs.core.next(seq54948);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54949,seq54948__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55057 = arguments.length;
var i__4865__auto___55058 = (0);
while(true){
if((i__4865__auto___55058 < len__4864__auto___55057)){
args__4870__auto__.push((arguments[i__4865__auto___55058]));

var G__55059 = (i__4865__auto___55058 + (1));
i__4865__auto___55058 = G__55059;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55040){
var state_val_55041 = (state_55040[(1)]);
if((state_val_55041 === (1))){
var state_55040__$1 = state_55040;
var statearr_55042_55060 = state_55040__$1;
(statearr_55042_55060[(2)] = null);

(statearr_55042_55060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55041 === (2))){
var _ = (function (){var statearr_55043 = state_55040;
(statearr_55043[(4)] = cljs.core.cons((5),(state_55040[(4)])));

return statearr_55043;
})();
var inst_55016 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55040__$1 = state_55040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55040__$1,(6),inst_55016);
} else {
if((state_val_55041 === (3))){
var inst_55038 = (state_55040[(2)]);
var state_55040__$1 = state_55040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55040__$1,inst_55038);
} else {
if((state_val_55041 === (4))){
var inst_55010 = (state_55040[(2)]);
var state_55040__$1 = state_55040;
var statearr_55045_55061 = state_55040__$1;
(statearr_55045_55061[(2)] = inst_55010);

(statearr_55045_55061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55041 === (5))){
var _ = (function (){var statearr_55046 = state_55040;
(statearr_55046[(4)] = cljs.core.rest((state_55040[(4)])));

return statearr_55046;
})();
var state_55040__$1 = state_55040;
var ex55044 = (state_55040__$1[(2)]);
var statearr_55047_55062 = state_55040__$1;
(statearr_55047_55062[(5)] = ex55044);


if((ex55044 instanceof Error)){
var statearr_55048_55063 = state_55040__$1;
(statearr_55048_55063[(1)] = (4));

(statearr_55048_55063[(5)] = null);

} else {
throw ex55044;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55041 === (6))){
var inst_55018 = (state_55040[(2)]);
var inst_55019 = fluree.db.util.async.throw_err(inst_55018);
var inst_55020 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_55019);
var inst_55021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55022 = [inst_55019];
var inst_55023 = (new cljs.core.PersistentVector(null,1,(5),inst_55021,inst_55022,null));
var inst_55024 = cljs.core.count(inst_55023);
var inst_55025 = ((9) + inst_55024);
var inst_55026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55027 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55029 = [inst_55019];
var inst_55030 = (new cljs.core.PersistentVector(null,1,(5),inst_55028,inst_55029,null));
var inst_55031 = ["<=",inst_55030,inst_55020];
var inst_55032 = cljs.core.PersistentHashMap.fromArrays(inst_55027,inst_55031);
var inst_55033 = [inst_55032,inst_55025];
var inst_55034 = (new cljs.core.PersistentVector(null,2,(5),inst_55026,inst_55033,null));
var inst_55035 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55034);
var _ = (function (){var statearr_55049 = state_55040;
(statearr_55049[(4)] = cljs.core.rest((state_55040[(4)])));

return statearr_55049;
})();
var state_55040__$1 = (function (){var statearr_55050 = state_55040;
(statearr_55050[(7)] = inst_55035);

return statearr_55050;
})();
var statearr_55051_55064 = state_55040__$1;
(statearr_55051_55064[(2)] = inst_55020);

(statearr_55051_55064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55052 = [null,null,null,null,null,null,null,null];
(statearr_55052[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55052[(1)] = (1));

return statearr_55052;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55040){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55040);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55053){var ex__2730__auto__ = e55053;
var statearr_55054_55065 = state_55040;
(statearr_55054_55065[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55040[(4)]))){
var statearr_55055_55066 = state_55040;
(statearr_55055_55066[(1)] = cljs.core.first((state_55040[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55067 = state_55040;
state_55040 = G__55067;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55040){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55056 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55056[(6)] = c__2749__auto__);

return statearr_55056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55008){
var G__55009 = cljs.core.first(seq55008);
var seq55008__$1 = cljs.core.next(seq55008);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55009,seq55008__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55117 = arguments.length;
var i__4865__auto___55118 = (0);
while(true){
if((i__4865__auto___55118 < len__4864__auto___55117)){
args__4870__auto__.push((arguments[i__4865__auto___55118]));

var G__55119 = (i__4865__auto___55118 + (1));
i__4865__auto___55118 = G__55119;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55100){
var state_val_55101 = (state_55100[(1)]);
if((state_val_55101 === (1))){
var state_55100__$1 = state_55100;
var statearr_55102_55120 = state_55100__$1;
(statearr_55102_55120[(2)] = null);

(statearr_55102_55120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (2))){
var _ = (function (){var statearr_55103 = state_55100;
(statearr_55103[(4)] = cljs.core.cons((5),(state_55100[(4)])));

return statearr_55103;
})();
var inst_55076 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55100__$1 = state_55100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55100__$1,(6),inst_55076);
} else {
if((state_val_55101 === (3))){
var inst_55098 = (state_55100[(2)]);
var state_55100__$1 = state_55100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55100__$1,inst_55098);
} else {
if((state_val_55101 === (4))){
var inst_55070 = (state_55100[(2)]);
var state_55100__$1 = state_55100;
var statearr_55105_55121 = state_55100__$1;
(statearr_55105_55121[(2)] = inst_55070);

(statearr_55105_55121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (5))){
var _ = (function (){var statearr_55106 = state_55100;
(statearr_55106[(4)] = cljs.core.rest((state_55100[(4)])));

return statearr_55106;
})();
var state_55100__$1 = state_55100;
var ex55104 = (state_55100__$1[(2)]);
var statearr_55107_55122 = state_55100__$1;
(statearr_55107_55122[(5)] = ex55104);


if((ex55104 instanceof Error)){
var statearr_55108_55123 = state_55100__$1;
(statearr_55108_55123[(1)] = (4));

(statearr_55108_55123[(5)] = null);

} else {
throw ex55104;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (6))){
var inst_55078 = (state_55100[(2)]);
var inst_55079 = fluree.db.util.async.throw_err(inst_55078);
var inst_55080 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55079);
var inst_55081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55082 = [inst_55079];
var inst_55083 = (new cljs.core.PersistentVector(null,1,(5),inst_55081,inst_55082,null));
var inst_55084 = cljs.core.count(inst_55083);
var inst_55085 = ((9) + inst_55084);
var inst_55086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55087 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55089 = [inst_55079];
var inst_55090 = (new cljs.core.PersistentVector(null,1,(5),inst_55088,inst_55089,null));
var inst_55091 = [">=",inst_55090,inst_55080];
var inst_55092 = cljs.core.PersistentHashMap.fromArrays(inst_55087,inst_55091);
var inst_55093 = [inst_55092,inst_55085];
var inst_55094 = (new cljs.core.PersistentVector(null,2,(5),inst_55086,inst_55093,null));
var inst_55095 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55094);
var _ = (function (){var statearr_55109 = state_55100;
(statearr_55109[(4)] = cljs.core.rest((state_55100[(4)])));

return statearr_55109;
})();
var state_55100__$1 = (function (){var statearr_55110 = state_55100;
(statearr_55110[(7)] = inst_55095);

return statearr_55110;
})();
var statearr_55111_55124 = state_55100__$1;
(statearr_55111_55124[(2)] = inst_55080);

(statearr_55111_55124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55112 = [null,null,null,null,null,null,null,null];
(statearr_55112[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55112[(1)] = (1));

return statearr_55112;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55100){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55100);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55113){var ex__2730__auto__ = e55113;
var statearr_55114_55125 = state_55100;
(statearr_55114_55125[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55100[(4)]))){
var statearr_55115_55126 = state_55100;
(statearr_55115_55126[(1)] = cljs.core.first((state_55100[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55127 = state_55100;
state_55100 = G__55127;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55100){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55116 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55116[(6)] = c__2749__auto__);

return statearr_55116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55068){
var G__55069 = cljs.core.first(seq55068);
var seq55068__$1 = cljs.core.next(seq55068);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55069,seq55068__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55177 = arguments.length;
var i__4865__auto___55178 = (0);
while(true){
if((i__4865__auto___55178 < len__4864__auto___55177)){
args__4870__auto__.push((arguments[i__4865__auto___55178]));

var G__55179 = (i__4865__auto___55178 + (1));
i__4865__auto___55178 = G__55179;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55160){
var state_val_55161 = (state_55160[(1)]);
if((state_val_55161 === (1))){
var state_55160__$1 = state_55160;
var statearr_55162_55180 = state_55160__$1;
(statearr_55162_55180[(2)] = null);

(statearr_55162_55180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55161 === (2))){
var _ = (function (){var statearr_55163 = state_55160;
(statearr_55163[(4)] = cljs.core.cons((5),(state_55160[(4)])));

return statearr_55163;
})();
var inst_55136 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55160__$1 = state_55160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55160__$1,(6),inst_55136);
} else {
if((state_val_55161 === (3))){
var inst_55158 = (state_55160[(2)]);
var state_55160__$1 = state_55160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55160__$1,inst_55158);
} else {
if((state_val_55161 === (4))){
var inst_55130 = (state_55160[(2)]);
var state_55160__$1 = state_55160;
var statearr_55165_55181 = state_55160__$1;
(statearr_55165_55181[(2)] = inst_55130);

(statearr_55165_55181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55161 === (5))){
var _ = (function (){var statearr_55166 = state_55160;
(statearr_55166[(4)] = cljs.core.rest((state_55160[(4)])));

return statearr_55166;
})();
var state_55160__$1 = state_55160;
var ex55164 = (state_55160__$1[(2)]);
var statearr_55167_55182 = state_55160__$1;
(statearr_55167_55182[(5)] = ex55164);


if((ex55164 instanceof Error)){
var statearr_55168_55183 = state_55160__$1;
(statearr_55168_55183[(1)] = (4));

(statearr_55168_55183[(5)] = null);

} else {
throw ex55164;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55161 === (6))){
var inst_55138 = (state_55160[(2)]);
var inst_55139 = fluree.db.util.async.throw_err(inst_55138);
var inst_55140 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_55139);
var inst_55141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55142 = [inst_55139];
var inst_55143 = (new cljs.core.PersistentVector(null,1,(5),inst_55141,inst_55142,null));
var inst_55144 = cljs.core.count(inst_55143);
var inst_55145 = ((9) + inst_55144);
var inst_55146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55147 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55149 = [inst_55139];
var inst_55150 = (new cljs.core.PersistentVector(null,1,(5),inst_55148,inst_55149,null));
var inst_55151 = ["not=",inst_55150,inst_55140];
var inst_55152 = cljs.core.PersistentHashMap.fromArrays(inst_55147,inst_55151);
var inst_55153 = [inst_55152,inst_55145];
var inst_55154 = (new cljs.core.PersistentVector(null,2,(5),inst_55146,inst_55153,null));
var inst_55155 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55154);
var _ = (function (){var statearr_55169 = state_55160;
(statearr_55169[(4)] = cljs.core.rest((state_55160[(4)])));

return statearr_55169;
})();
var state_55160__$1 = (function (){var statearr_55170 = state_55160;
(statearr_55170[(7)] = inst_55155);

return statearr_55170;
})();
var statearr_55171_55184 = state_55160__$1;
(statearr_55171_55184[(2)] = inst_55140);

(statearr_55171_55184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55172 = [null,null,null,null,null,null,null,null];
(statearr_55172[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55172[(1)] = (1));

return statearr_55172;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55160){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55160);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55173){var ex__2730__auto__ = e55173;
var statearr_55174_55185 = state_55160;
(statearr_55174_55185[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55160[(4)]))){
var statearr_55175_55186 = state_55160;
(statearr_55175_55186[(1)] = cljs.core.first((state_55160[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55187 = state_55160;
state_55160 = G__55187;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55160){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55176 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55176[(6)] = c__2749__auto__);

return statearr_55176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq55128){
var G__55129 = cljs.core.first(seq55128);
var seq55128__$1 = cljs.core.next(seq55128);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55129,seq55128__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55237 = arguments.length;
var i__4865__auto___55238 = (0);
while(true){
if((i__4865__auto___55238 < len__4864__auto___55237)){
args__4870__auto__.push((arguments[i__4865__auto___55238]));

var G__55239 = (i__4865__auto___55238 + (1));
i__4865__auto___55238 = G__55239;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55220){
var state_val_55221 = (state_55220[(1)]);
if((state_val_55221 === (1))){
var state_55220__$1 = state_55220;
var statearr_55222_55240 = state_55220__$1;
(statearr_55222_55240[(2)] = null);

(statearr_55222_55240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55221 === (2))){
var _ = (function (){var statearr_55223 = state_55220;
(statearr_55223[(4)] = cljs.core.cons((5),(state_55220[(4)])));

return statearr_55223;
})();
var inst_55196 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55220__$1 = state_55220;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55220__$1,(6),inst_55196);
} else {
if((state_val_55221 === (3))){
var inst_55218 = (state_55220[(2)]);
var state_55220__$1 = state_55220;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55220__$1,inst_55218);
} else {
if((state_val_55221 === (4))){
var inst_55190 = (state_55220[(2)]);
var state_55220__$1 = state_55220;
var statearr_55225_55241 = state_55220__$1;
(statearr_55225_55241[(2)] = inst_55190);

(statearr_55225_55241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55221 === (5))){
var _ = (function (){var statearr_55226 = state_55220;
(statearr_55226[(4)] = cljs.core.rest((state_55220[(4)])));

return statearr_55226;
})();
var state_55220__$1 = state_55220;
var ex55224 = (state_55220__$1[(2)]);
var statearr_55227_55242 = state_55220__$1;
(statearr_55227_55242[(5)] = ex55224);


if((ex55224 instanceof Error)){
var statearr_55228_55243 = state_55220__$1;
(statearr_55228_55243[(1)] = (4));

(statearr_55228_55243[(5)] = null);

} else {
throw ex55224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55221 === (6))){
var inst_55198 = (state_55220[(2)]);
var inst_55199 = fluree.db.util.async.throw_err(inst_55198);
var inst_55200 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_55199);
var inst_55201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55202 = [inst_55199];
var inst_55203 = (new cljs.core.PersistentVector(null,1,(5),inst_55201,inst_55202,null));
var inst_55204 = cljs.core.count(inst_55203);
var inst_55205 = ((9) + inst_55204);
var inst_55206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55207 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55209 = [inst_55199];
var inst_55210 = (new cljs.core.PersistentVector(null,1,(5),inst_55208,inst_55209,null));
var inst_55211 = ["max",inst_55210,inst_55200];
var inst_55212 = cljs.core.PersistentHashMap.fromArrays(inst_55207,inst_55211);
var inst_55213 = [inst_55212,inst_55205];
var inst_55214 = (new cljs.core.PersistentVector(null,2,(5),inst_55206,inst_55213,null));
var inst_55215 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55214);
var _ = (function (){var statearr_55229 = state_55220;
(statearr_55229[(4)] = cljs.core.rest((state_55220[(4)])));

return statearr_55229;
})();
var state_55220__$1 = (function (){var statearr_55230 = state_55220;
(statearr_55230[(7)] = inst_55215);

return statearr_55230;
})();
var statearr_55231_55244 = state_55220__$1;
(statearr_55231_55244[(2)] = inst_55200);

(statearr_55231_55244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55232 = [null,null,null,null,null,null,null,null];
(statearr_55232[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55232[(1)] = (1));

return statearr_55232;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55220){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55220);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55233){var ex__2730__auto__ = e55233;
var statearr_55234_55245 = state_55220;
(statearr_55234_55245[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55220[(4)]))){
var statearr_55235_55246 = state_55220;
(statearr_55235_55246[(1)] = cljs.core.first((state_55220[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55247 = state_55220;
state_55220 = G__55247;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55220){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55236 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55236[(6)] = c__2749__auto__);

return statearr_55236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55188){
var G__55189 = cljs.core.first(seq55188);
var seq55188__$1 = cljs.core.next(seq55188);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55189,seq55188__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55297 = arguments.length;
var i__4865__auto___55298 = (0);
while(true){
if((i__4865__auto___55298 < len__4864__auto___55297)){
args__4870__auto__.push((arguments[i__4865__auto___55298]));

var G__55299 = (i__4865__auto___55298 + (1));
i__4865__auto___55298 = G__55299;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55280){
var state_val_55281 = (state_55280[(1)]);
if((state_val_55281 === (1))){
var state_55280__$1 = state_55280;
var statearr_55282_55300 = state_55280__$1;
(statearr_55282_55300[(2)] = null);

(statearr_55282_55300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55281 === (2))){
var _ = (function (){var statearr_55283 = state_55280;
(statearr_55283[(4)] = cljs.core.cons((5),(state_55280[(4)])));

return statearr_55283;
})();
var inst_55256 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55280__$1 = state_55280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55280__$1,(6),inst_55256);
} else {
if((state_val_55281 === (3))){
var inst_55278 = (state_55280[(2)]);
var state_55280__$1 = state_55280;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55280__$1,inst_55278);
} else {
if((state_val_55281 === (4))){
var inst_55250 = (state_55280[(2)]);
var state_55280__$1 = state_55280;
var statearr_55285_55301 = state_55280__$1;
(statearr_55285_55301[(2)] = inst_55250);

(statearr_55285_55301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55281 === (5))){
var _ = (function (){var statearr_55286 = state_55280;
(statearr_55286[(4)] = cljs.core.rest((state_55280[(4)])));

return statearr_55286;
})();
var state_55280__$1 = state_55280;
var ex55284 = (state_55280__$1[(2)]);
var statearr_55287_55302 = state_55280__$1;
(statearr_55287_55302[(5)] = ex55284);


if((ex55284 instanceof Error)){
var statearr_55288_55303 = state_55280__$1;
(statearr_55288_55303[(1)] = (4));

(statearr_55288_55303[(5)] = null);

} else {
throw ex55284;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55281 === (6))){
var inst_55258 = (state_55280[(2)]);
var inst_55259 = fluree.db.util.async.throw_err(inst_55258);
var inst_55260 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_55259);
var inst_55261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55262 = [inst_55259];
var inst_55263 = (new cljs.core.PersistentVector(null,1,(5),inst_55261,inst_55262,null));
var inst_55264 = cljs.core.count(inst_55263);
var inst_55265 = ((9) + inst_55264);
var inst_55266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55267 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55269 = [inst_55259];
var inst_55270 = (new cljs.core.PersistentVector(null,1,(5),inst_55268,inst_55269,null));
var inst_55271 = ["min",inst_55270,inst_55260];
var inst_55272 = cljs.core.PersistentHashMap.fromArrays(inst_55267,inst_55271);
var inst_55273 = [inst_55272,inst_55265];
var inst_55274 = (new cljs.core.PersistentVector(null,2,(5),inst_55266,inst_55273,null));
var inst_55275 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55274);
var _ = (function (){var statearr_55289 = state_55280;
(statearr_55289[(4)] = cljs.core.rest((state_55280[(4)])));

return statearr_55289;
})();
var state_55280__$1 = (function (){var statearr_55290 = state_55280;
(statearr_55290[(7)] = inst_55275);

return statearr_55290;
})();
var statearr_55291_55304 = state_55280__$1;
(statearr_55291_55304[(2)] = inst_55260);

(statearr_55291_55304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55292 = [null,null,null,null,null,null,null,null];
(statearr_55292[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55292[(1)] = (1));

return statearr_55292;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55280){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55280);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55293){var ex__2730__auto__ = e55293;
var statearr_55294_55305 = state_55280;
(statearr_55294_55305[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55280[(4)]))){
var statearr_55295_55306 = state_55280;
(statearr_55295_55306[(1)] = cljs.core.first((state_55280[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55307 = state_55280;
state_55280 = G__55307;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55280){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55296 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55296[(6)] = c__2749__auto__);

return statearr_55296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55248){
var G__55249 = cljs.core.first(seq55248);
var seq55248__$1 = cljs.core.next(seq55248);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55249,seq55248__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55309 = arguments.length;
switch (G__55309) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55354){
var state_val_55355 = (state_55354[(1)]);
if((state_val_55355 === (7))){
var state_55354__$1 = state_55354;
var statearr_55356_55493 = state_55354__$1;
(statearr_55356_55493[(2)] = query_map);

(statearr_55356_55493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (1))){
var state_55354__$1 = state_55354;
var statearr_55357_55494 = state_55354__$1;
(statearr_55357_55494[(2)] = null);

(statearr_55357_55494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (4))){
var inst_55310 = (state_55354[(2)]);
var state_55354__$1 = state_55354;
var statearr_55358_55495 = state_55354__$1;
(statearr_55358_55495[(2)] = inst_55310);

(statearr_55358_55495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (13))){
var inst_55332 = (state_55354[(7)]);
var inst_55336 = (state_55354[(2)]);
var inst_55337 = fluree.db.util.async.throw_err(inst_55336);
var inst_55338 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55337,(0),null);
var inst_55339 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55337,(1),null);
var inst_55340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55341 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55343 = [inst_55332];
var inst_55344 = (new cljs.core.PersistentVector(null,1,(5),inst_55342,inst_55343,null));
var inst_55345 = ["query",inst_55344,inst_55338];
var inst_55346 = cljs.core.PersistentHashMap.fromArrays(inst_55341,inst_55345);
var inst_55347 = [inst_55346,inst_55339];
var inst_55348 = (new cljs.core.PersistentVector(null,2,(5),inst_55340,inst_55347,null));
var inst_55349 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55348);
var _ = (function (){var statearr_55359 = state_55354;
(statearr_55359[(4)] = cljs.core.rest((state_55354[(4)])));

return statearr_55359;
})();
var state_55354__$1 = (function (){var statearr_55360 = state_55354;
(statearr_55360[(8)] = inst_55349);

return statearr_55360;
})();
var statearr_55361_55496 = state_55354__$1;
(statearr_55361_55496[(2)] = inst_55338);

(statearr_55361_55496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (6))){
var state_55354__$1 = state_55354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55354__$1,(9),query_map);
} else {
if((state_val_55355 === (3))){
var inst_55352 = (state_55354[(2)]);
var state_55354__$1 = state_55354;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55354__$1,inst_55352);
} else {
if((state_val_55355 === (12))){
var inst_55332 = (state_55354[(7)]);
var inst_55332__$1 = (state_55354[(2)]);
var inst_55333 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55334 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_55333,inst_55332__$1);
var state_55354__$1 = (function (){var statearr_55362 = state_55354;
(statearr_55362[(7)] = inst_55332__$1);

return statearr_55362;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55354__$1,(13),inst_55334);
} else {
if((state_val_55355 === (2))){
var _ = (function (){var statearr_55363 = state_55354;
(statearr_55363[(4)] = cljs.core.cons((5),(state_55354[(4)])));

return statearr_55363;
})();
var inst_55319 = fluree.db.util.async.channel_QMARK_(query_map);
var state_55354__$1 = state_55354;
if(inst_55319){
var statearr_55364_55497 = state_55354__$1;
(statearr_55364_55497[(1)] = (6));

} else {
var statearr_55365_55498 = state_55354__$1;
(statearr_55365_55498[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (11))){
var inst_55326 = (state_55354[(9)]);
var state_55354__$1 = state_55354;
var statearr_55367_55499 = state_55354__$1;
(statearr_55367_55499[(2)] = inst_55326);

(statearr_55367_55499[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (9))){
var inst_55322 = (state_55354[(2)]);
var inst_55323 = fluree.db.util.async.throw_err(inst_55322);
var state_55354__$1 = state_55354;
var statearr_55368_55500 = state_55354__$1;
(statearr_55368_55500[(2)] = inst_55323);

(statearr_55368_55500[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (5))){
var _ = (function (){var statearr_55369 = state_55354;
(statearr_55369[(4)] = cljs.core.rest((state_55354[(4)])));

return statearr_55369;
})();
var state_55354__$1 = state_55354;
var ex55366 = (state_55354__$1[(2)]);
var statearr_55370_55501 = state_55354__$1;
(statearr_55370_55501[(5)] = ex55366);


if((ex55366 instanceof Error)){
var statearr_55371_55502 = state_55354__$1;
(statearr_55371_55502[(1)] = (4));

(statearr_55371_55502[(5)] = null);

} else {
throw ex55366;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (10))){
var inst_55326 = (state_55354[(9)]);
var inst_55329 = fluree.db.util.json.parse(inst_55326);
var state_55354__$1 = state_55354;
var statearr_55372_55503 = state_55354__$1;
(statearr_55372_55503[(2)] = inst_55329);

(statearr_55372_55503[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (8))){
var inst_55326 = (state_55354[(9)]);
var inst_55326__$1 = (state_55354[(2)]);
var inst_55327 = typeof inst_55326__$1 === 'string';
var state_55354__$1 = (function (){var statearr_55373 = state_55354;
(statearr_55373[(9)] = inst_55326__$1);

return statearr_55373;
})();
if(cljs.core.truth_(inst_55327)){
var statearr_55374_55504 = state_55354__$1;
(statearr_55374_55504[(1)] = (10));

} else {
var statearr_55375_55505 = state_55354__$1;
(statearr_55375_55505[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55376 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55376[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55376[(1)] = (1));

return statearr_55376;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55354){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55354);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55377){var ex__2730__auto__ = e55377;
var statearr_55378_55506 = state_55354;
(statearr_55378_55506[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55354[(4)]))){
var statearr_55379_55507 = state_55354;
(statearr_55379_55507[(1)] = cljs.core.first((state_55354[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55508 = state_55354;
state_55354 = G__55508;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55354){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55380 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55380[(6)] = c__2749__auto__);

return statearr_55380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55451){
var state_val_55452 = (state_55451[(1)]);
if((state_val_55452 === (7))){
var state_55451__$1 = state_55451;
var statearr_55453_55509 = state_55451__$1;
(statearr_55453_55509[(2)] = select);

(statearr_55453_55509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (20))){
var inst_55421 = (state_55451[(2)]);
var inst_55422 = fluree.db.util.async.channel_QMARK_(limit);
var state_55451__$1 = (function (){var statearr_55454 = state_55451;
(statearr_55454[(7)] = inst_55421);

return statearr_55454;
})();
if(inst_55422){
var statearr_55455_55510 = state_55451__$1;
(statearr_55455_55510[(1)] = (22));

} else {
var statearr_55456_55511 = state_55451__$1;
(statearr_55456_55511[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (1))){
var state_55451__$1 = state_55451;
var statearr_55457_55512 = state_55451__$1;
(statearr_55457_55512[(2)] = null);

(statearr_55457_55512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (24))){
var inst_55405 = (state_55451[(8)]);
var inst_55397 = (state_55451[(9)]);
var inst_55413 = (state_55451[(10)]);
var inst_55421 = (state_55451[(7)]);
var inst_55429 = (state_55451[(2)]);
var inst_55430 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55431 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_55430,inst_55397,inst_55405,inst_55413,inst_55421,inst_55429);
var state_55451__$1 = state_55451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55451__$1,(26),inst_55431);
} else {
if((state_val_55452 === (4))){
var inst_55381 = (state_55451[(2)]);
var state_55451__$1 = state_55451;
var statearr_55458_55513 = state_55451__$1;
(statearr_55458_55513[(2)] = inst_55381);

(statearr_55458_55513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (15))){
var state_55451__$1 = state_55451;
var statearr_55459_55514 = state_55451__$1;
(statearr_55459_55514[(2)] = where);

(statearr_55459_55514[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (21))){
var inst_55417 = (state_55451[(2)]);
var inst_55418 = fluree.db.util.async.throw_err(inst_55417);
var state_55451__$1 = state_55451;
var statearr_55460_55515 = state_55451__$1;
(statearr_55460_55515[(2)] = inst_55418);

(statearr_55460_55515[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (13))){
var inst_55401 = (state_55451[(2)]);
var inst_55402 = fluree.db.util.async.throw_err(inst_55401);
var state_55451__$1 = state_55451;
var statearr_55461_55516 = state_55451__$1;
(statearr_55461_55516[(2)] = inst_55402);

(statearr_55461_55516[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (22))){
var state_55451__$1 = state_55451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55451__$1,(25),limit);
} else {
if((state_val_55452 === (6))){
var state_55451__$1 = state_55451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55451__$1,(9),select);
} else {
if((state_val_55452 === (25))){
var inst_55425 = (state_55451[(2)]);
var inst_55426 = fluree.db.util.async.throw_err(inst_55425);
var state_55451__$1 = state_55451;
var statearr_55462_55517 = state_55451__$1;
(statearr_55462_55517[(2)] = inst_55426);

(statearr_55462_55517[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (17))){
var inst_55409 = (state_55451[(2)]);
var inst_55410 = fluree.db.util.async.throw_err(inst_55409);
var state_55451__$1 = state_55451;
var statearr_55463_55518 = state_55451__$1;
(statearr_55463_55518[(2)] = inst_55410);

(statearr_55463_55518[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (3))){
var inst_55449 = (state_55451[(2)]);
var state_55451__$1 = state_55451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55451__$1,inst_55449);
} else {
if((state_val_55452 === (12))){
var inst_55405 = (state_55451[(2)]);
var inst_55406 = fluree.db.util.async.channel_QMARK_(where);
var state_55451__$1 = (function (){var statearr_55464 = state_55451;
(statearr_55464[(8)] = inst_55405);

return statearr_55464;
})();
if(inst_55406){
var statearr_55465_55519 = state_55451__$1;
(statearr_55465_55519[(1)] = (14));

} else {
var statearr_55466_55520 = state_55451__$1;
(statearr_55466_55520[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (2))){
var _ = (function (){var statearr_55467 = state_55451;
(statearr_55467[(4)] = cljs.core.cons((5),(state_55451[(4)])));

return statearr_55467;
})();
var inst_55390 = fluree.db.util.async.channel_QMARK_(select);
var state_55451__$1 = state_55451;
if(inst_55390){
var statearr_55468_55521 = state_55451__$1;
(statearr_55468_55521[(1)] = (6));

} else {
var statearr_55469_55522 = state_55451__$1;
(statearr_55469_55522[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (23))){
var state_55451__$1 = state_55451;
var statearr_55470_55523 = state_55451__$1;
(statearr_55470_55523[(2)] = limit);

(statearr_55470_55523[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (19))){
var state_55451__$1 = state_55451;
var statearr_55471_55524 = state_55451__$1;
(statearr_55471_55524[(2)] = block);

(statearr_55471_55524[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (11))){
var state_55451__$1 = state_55451;
var statearr_55473_55525 = state_55451__$1;
(statearr_55473_55525[(2)] = from);

(statearr_55473_55525[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (9))){
var inst_55393 = (state_55451[(2)]);
var inst_55394 = fluree.db.util.async.throw_err(inst_55393);
var state_55451__$1 = state_55451;
var statearr_55474_55526 = state_55451__$1;
(statearr_55474_55526[(2)] = inst_55394);

(statearr_55474_55526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (5))){
var _ = (function (){var statearr_55475 = state_55451;
(statearr_55475[(4)] = cljs.core.rest((state_55451[(4)])));

return statearr_55475;
})();
var state_55451__$1 = state_55451;
var ex55472 = (state_55451__$1[(2)]);
var statearr_55476_55527 = state_55451__$1;
(statearr_55476_55527[(5)] = ex55472);


if((ex55472 instanceof Error)){
var statearr_55477_55528 = state_55451__$1;
(statearr_55477_55528[(1)] = (4));

(statearr_55477_55528[(5)] = null);

} else {
throw ex55472;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (14))){
var state_55451__$1 = state_55451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55451__$1,(17),where);
} else {
if((state_val_55452 === (26))){
var inst_55405 = (state_55451[(8)]);
var inst_55397 = (state_55451[(9)]);
var inst_55413 = (state_55451[(10)]);
var inst_55421 = (state_55451[(7)]);
var inst_55433 = (state_55451[(2)]);
var inst_55434 = fluree.db.util.async.throw_err(inst_55433);
var inst_55435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55434,(0),null);
var inst_55436 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55434,(1),null);
var inst_55437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55438 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55440 = [inst_55397,inst_55405,inst_55413,inst_55421];
var inst_55441 = (new cljs.core.PersistentVector(null,4,(5),inst_55439,inst_55440,null));
var inst_55442 = ["query",inst_55441,inst_55435];
var inst_55443 = cljs.core.PersistentHashMap.fromArrays(inst_55438,inst_55442);
var inst_55444 = [inst_55443,inst_55436];
var inst_55445 = (new cljs.core.PersistentVector(null,2,(5),inst_55437,inst_55444,null));
var inst_55446 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55445);
var _ = (function (){var statearr_55478 = state_55451;
(statearr_55478[(4)] = cljs.core.rest((state_55451[(4)])));

return statearr_55478;
})();
var state_55451__$1 = (function (){var statearr_55479 = state_55451;
(statearr_55479[(11)] = inst_55446);

return statearr_55479;
})();
var statearr_55480_55529 = state_55451__$1;
(statearr_55480_55529[(2)] = inst_55435);

(statearr_55480_55529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (16))){
var inst_55413 = (state_55451[(2)]);
var inst_55414 = fluree.db.util.async.channel_QMARK_(block);
var state_55451__$1 = (function (){var statearr_55481 = state_55451;
(statearr_55481[(10)] = inst_55413);

return statearr_55481;
})();
if(inst_55414){
var statearr_55482_55530 = state_55451__$1;
(statearr_55482_55530[(1)] = (18));

} else {
var statearr_55483_55531 = state_55451__$1;
(statearr_55483_55531[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55452 === (10))){
var state_55451__$1 = state_55451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55451__$1,(13),from);
} else {
if((state_val_55452 === (18))){
var state_55451__$1 = state_55451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55451__$1,(21),block);
} else {
if((state_val_55452 === (8))){
var inst_55397 = (state_55451[(2)]);
var inst_55398 = fluree.db.util.async.channel_QMARK_(from);
var state_55451__$1 = (function (){var statearr_55484 = state_55451;
(statearr_55484[(9)] = inst_55397);

return statearr_55484;
})();
if(inst_55398){
var statearr_55485_55532 = state_55451__$1;
(statearr_55485_55532[(1)] = (10));

} else {
var statearr_55486_55533 = state_55451__$1;
(statearr_55486_55533[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55487 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55487[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55487[(1)] = (1));

return statearr_55487;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55451){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55451);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55488){var ex__2730__auto__ = e55488;
var statearr_55489_55534 = state_55451;
(statearr_55489_55534[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55451[(4)]))){
var statearr_55490_55535 = state_55451;
(statearr_55490_55535[(1)] = cljs.core.first((state_55451[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55536 = state_55451;
state_55451 = G__55536;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55451){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55491 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55491[(6)] = c__2749__auto__);

return statearr_55491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55592){
var state_val_55593 = (state_55592[(1)]);
if((state_val_55593 === (7))){
var state_55592__$1 = state_55592;
var statearr_55594_55625 = state_55592__$1;
(statearr_55594_55625[(2)] = startSubject);

(statearr_55594_55625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (1))){
var state_55592__$1 = state_55592;
var statearr_55595_55626 = state_55592__$1;
(statearr_55595_55626[(2)] = null);

(statearr_55595_55626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (4))){
var inst_55537 = (state_55592[(2)]);
var state_55592__$1 = state_55592;
var statearr_55596_55627 = state_55592__$1;
(statearr_55596_55627[(2)] = inst_55537);

(statearr_55596_55627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (15))){
var inst_55569 = (state_55592[(2)]);
var inst_55570 = fluree.db.util.async.throw_err(inst_55569);
var inst_55571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55570,(0),null);
var inst_55572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55570,(1),null);
var inst_55573 = cljs.core.empty_QMARK_(inst_55571);
var state_55592__$1 = (function (){var statearr_55597 = state_55592;
(statearr_55597[(7)] = inst_55572);

return statearr_55597;
})();
if(inst_55573){
var statearr_55598_55628 = state_55592__$1;
(statearr_55598_55628[(1)] = (16));

} else {
var statearr_55599_55629 = state_55592__$1;
(statearr_55599_55629[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (13))){
var inst_55553 = (state_55592[(8)]);
var inst_55557 = (state_55592[(9)]);
var inst_55565 = (state_55592[(10)]);
var inst_55565__$1 = (state_55592[(2)]);
var inst_55566 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55567 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_55566,inst_55553,inst_55557,inst_55565__$1);
var state_55592__$1 = (function (){var statearr_55600 = state_55592;
(statearr_55600[(10)] = inst_55565__$1);

return statearr_55600;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55592__$1,(15),inst_55567);
} else {
if((state_val_55593 === (6))){
var state_55592__$1 = state_55592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55592__$1,(9),startSubject);
} else {
if((state_val_55593 === (17))){
var state_55592__$1 = state_55592;
var statearr_55601_55630 = state_55592__$1;
(statearr_55601_55630[(2)] = true);

(statearr_55601_55630[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (3))){
var inst_55590 = (state_55592[(2)]);
var state_55592__$1 = state_55592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55592__$1,inst_55590);
} else {
if((state_val_55593 === (12))){
var state_55592__$1 = state_55592;
var statearr_55602_55631 = state_55592__$1;
(statearr_55602_55631[(2)] = endSubject);

(statearr_55602_55631[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (2))){
var _ = (function (){var statearr_55603 = state_55592;
(statearr_55603[(4)] = cljs.core.cons((5),(state_55592[(4)])));

return statearr_55603;
})();
var inst_55546 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_55592__$1 = state_55592;
if(inst_55546){
var statearr_55604_55632 = state_55592__$1;
(statearr_55604_55632[(1)] = (6));

} else {
var statearr_55605_55633 = state_55592__$1;
(statearr_55605_55633[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (11))){
var state_55592__$1 = state_55592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55592__$1,(14),endSubject);
} else {
if((state_val_55593 === (9))){
var inst_55549 = (state_55592[(2)]);
var inst_55550 = fluree.db.util.async.throw_err(inst_55549);
var state_55592__$1 = state_55592;
var statearr_55607_55634 = state_55592__$1;
(statearr_55607_55634[(2)] = inst_55550);

(statearr_55607_55634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (5))){
var _ = (function (){var statearr_55608 = state_55592;
(statearr_55608[(4)] = cljs.core.rest((state_55592[(4)])));

return statearr_55608;
})();
var state_55592__$1 = state_55592;
var ex55606 = (state_55592__$1[(2)]);
var statearr_55609_55635 = state_55592__$1;
(statearr_55609_55635[(5)] = ex55606);


if((ex55606 instanceof Error)){
var statearr_55610_55636 = state_55592__$1;
(statearr_55610_55636[(1)] = (4));

(statearr_55610_55636[(5)] = null);

} else {
throw ex55606;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (14))){
var inst_55561 = (state_55592[(2)]);
var inst_55562 = fluree.db.util.async.throw_err(inst_55561);
var state_55592__$1 = state_55592;
var statearr_55611_55637 = state_55592__$1;
(statearr_55611_55637[(2)] = inst_55562);

(statearr_55611_55637[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (16))){
var state_55592__$1 = state_55592;
var statearr_55612_55638 = state_55592__$1;
(statearr_55612_55638[(2)] = false);

(statearr_55612_55638[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (10))){
var inst_55556 = (state_55592[(2)]);
var inst_55557 = fluree.db.util.async.throw_err(inst_55556);
var inst_55558 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_55592__$1 = (function (){var statearr_55613 = state_55592;
(statearr_55613[(9)] = inst_55557);

return statearr_55613;
})();
if(inst_55558){
var statearr_55614_55639 = state_55592__$1;
(statearr_55614_55639[(1)] = (11));

} else {
var statearr_55615_55640 = state_55592__$1;
(statearr_55615_55640[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (18))){
var inst_55572 = (state_55592[(7)]);
var inst_55553 = (state_55592[(8)]);
var inst_55557 = (state_55592[(9)]);
var inst_55565 = (state_55592[(10)]);
var inst_55577 = (state_55592[(2)]);
var inst_55578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55579 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55581 = [inst_55553,inst_55557,inst_55565];
var inst_55582 = (new cljs.core.PersistentVector(null,3,(5),inst_55580,inst_55581,null));
var inst_55583 = ["relationship?",inst_55582,inst_55577];
var inst_55584 = cljs.core.PersistentHashMap.fromArrays(inst_55579,inst_55583);
var inst_55585 = [inst_55584,inst_55572];
var inst_55586 = (new cljs.core.PersistentVector(null,2,(5),inst_55578,inst_55585,null));
var inst_55587 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55586);
var _ = (function (){var statearr_55616 = state_55592;
(statearr_55616[(4)] = cljs.core.rest((state_55592[(4)])));

return statearr_55616;
})();
var state_55592__$1 = (function (){var statearr_55617 = state_55592;
(statearr_55617[(11)] = inst_55587);

return statearr_55617;
})();
var statearr_55618_55641 = state_55592__$1;
(statearr_55618_55641[(2)] = inst_55577);

(statearr_55618_55641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55593 === (8))){
var inst_55553 = (state_55592[(2)]);
var inst_55554 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_55592__$1 = (function (){var statearr_55619 = state_55592;
(statearr_55619[(8)] = inst_55553);

return statearr_55619;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55592__$1,(10),inst_55554);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_55620 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55620[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_55620[(1)] = (1));

return statearr_55620;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_55592){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55592);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55621){var ex__2730__auto__ = e55621;
var statearr_55622_55642 = state_55592;
(statearr_55622_55642[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55592[(4)]))){
var statearr_55623_55643 = state_55592;
(statearr_55623_55643[(1)] = cljs.core.first((state_55592[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55644 = state_55592;
state_55592 = G__55644;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = function(state_55592){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_55592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55624 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55624[(6)] = c__2749__auto__);

return statearr_55624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55681){
var state_val_55682 = (state_55681[(1)]);
if((state_val_55682 === (7))){
var state_55681__$1 = state_55681;
var statearr_55683_55703 = state_55681__$1;
(statearr_55683_55703[(2)] = pred_name);

(statearr_55683_55703[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55682 === (1))){
var state_55681__$1 = state_55681;
var statearr_55684_55704 = state_55681__$1;
(statearr_55684_55704[(2)] = null);

(statearr_55684_55704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55682 === (4))){
var inst_55645 = (state_55681[(2)]);
var state_55681__$1 = state_55681;
var statearr_55685_55705 = state_55681__$1;
(statearr_55685_55705[(2)] = inst_55645);

(statearr_55685_55705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55682 === (6))){
var state_55681__$1 = state_55681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55681__$1,(9),pred_name);
} else {
if((state_val_55682 === (3))){
var inst_55679 = (state_55681[(2)]);
var state_55681__$1 = state_55681;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55681__$1,inst_55679);
} else {
if((state_val_55682 === (2))){
var _ = (function (){var statearr_55687 = state_55681;
(statearr_55687[(4)] = cljs.core.cons((5),(state_55681[(4)])));

return statearr_55687;
})();
var inst_55654 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_55681__$1 = state_55681;
if(inst_55654){
var statearr_55688_55706 = state_55681__$1;
(statearr_55688_55706[(1)] = (6));

} else {
var statearr_55689_55707 = state_55681__$1;
(statearr_55689_55707[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55682 === (9))){
var inst_55657 = (state_55681[(2)]);
var inst_55658 = fluree.db.util.async.throw_err(inst_55657);
var state_55681__$1 = state_55681;
var statearr_55690_55708 = state_55681__$1;
(statearr_55690_55708[(2)] = inst_55658);

(statearr_55690_55708[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55682 === (5))){
var _ = (function (){var statearr_55691 = state_55681;
(statearr_55691[(4)] = cljs.core.rest((state_55681[(4)])));

return statearr_55691;
})();
var state_55681__$1 = state_55681;
var ex55686 = (state_55681__$1[(2)]);
var statearr_55692_55709 = state_55681__$1;
(statearr_55692_55709[(5)] = ex55686);


if((ex55686 instanceof Error)){
var statearr_55693_55710 = state_55681__$1;
(statearr_55693_55710[(1)] = (4));

(statearr_55693_55710[(5)] = null);

} else {
throw ex55686;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55682 === (10))){
var inst_55661 = (state_55681[(7)]);
var inst_55665 = (state_55681[(2)]);
var inst_55666 = fluree.db.util.async.throw_err(inst_55665);
var inst_55667 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55666,(0),null);
var inst_55668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55666,(1),null);
var inst_55669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55670 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55671 = ["max-pred-val",inst_55661,inst_55667];
var inst_55672 = cljs.core.PersistentHashMap.fromArrays(inst_55670,inst_55671);
var inst_55673 = (inst_55668 + (10));
var inst_55674 = [inst_55672,inst_55673];
var inst_55675 = (new cljs.core.PersistentVector(null,2,(5),inst_55669,inst_55674,null));
var inst_55676 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55675);
var _ = (function (){var statearr_55694 = state_55681;
(statearr_55694[(4)] = cljs.core.rest((state_55681[(4)])));

return statearr_55694;
})();
var state_55681__$1 = (function (){var statearr_55695 = state_55681;
(statearr_55695[(8)] = inst_55676);

return statearr_55695;
})();
var statearr_55696_55711 = state_55681__$1;
(statearr_55696_55711[(2)] = inst_55667);

(statearr_55696_55711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55682 === (8))){
var inst_55661 = (state_55681[(7)]);
var inst_55661__$1 = (state_55681[(2)]);
var inst_55662 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55663 = fluree.db.dbfunctions.internal.max_pred_val(inst_55662,inst_55661__$1,null);
var state_55681__$1 = (function (){var statearr_55697 = state_55681;
(statearr_55697[(7)] = inst_55661__$1);

return statearr_55697;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55681__$1,(10),inst_55663);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_55698 = [null,null,null,null,null,null,null,null,null];
(statearr_55698[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__);

(statearr_55698[(1)] = (1));

return statearr_55698;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1 = (function (state_55681){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55681);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55699){var ex__2730__auto__ = e55699;
var statearr_55700_55712 = state_55681;
(statearr_55700_55712[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55681[(4)]))){
var statearr_55701_55713 = state_55681;
(statearr_55701_55713[(1)] = cljs.core.first((state_55681[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55714 = state_55681;
state_55681 = G__55714;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = function(state_55681){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1.call(this,state_55681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55702 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55702[(6)] = c__2749__auto__);

return statearr_55702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55741){
var state_val_55742 = (state_55741[(1)]);
if((state_val_55742 === (7))){
var state_55741__$1 = state_55741;
var statearr_55743_55762 = state_55741__$1;
(statearr_55743_55762[(2)] = n);

(statearr_55743_55762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55742 === (1))){
var state_55741__$1 = state_55741;
var statearr_55744_55763 = state_55741__$1;
(statearr_55744_55763[(2)] = null);

(statearr_55744_55763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55742 === (4))){
var inst_55715 = (state_55741[(2)]);
var state_55741__$1 = state_55741;
var statearr_55745_55764 = state_55741__$1;
(statearr_55745_55764[(2)] = inst_55715);

(statearr_55745_55764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55742 === (6))){
var state_55741__$1 = state_55741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55741__$1,(9),n);
} else {
if((state_val_55742 === (3))){
var inst_55739 = (state_55741[(2)]);
var state_55741__$1 = state_55741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55741__$1,inst_55739);
} else {
if((state_val_55742 === (2))){
var _ = (function (){var statearr_55747 = state_55741;
(statearr_55747[(4)] = cljs.core.cons((5),(state_55741[(4)])));

return statearr_55747;
})();
var inst_55721 = fluree.db.util.async.channel_QMARK_(n);
var state_55741__$1 = state_55741;
if(inst_55721){
var statearr_55748_55765 = state_55741__$1;
(statearr_55748_55765[(1)] = (6));

} else {
var statearr_55749_55766 = state_55741__$1;
(statearr_55749_55766[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55742 === (9))){
var inst_55724 = (state_55741[(2)]);
var inst_55725 = fluree.db.util.async.throw_err(inst_55724);
var state_55741__$1 = state_55741;
var statearr_55750_55767 = state_55741__$1;
(statearr_55750_55767[(2)] = inst_55725);

(statearr_55750_55767[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55742 === (5))){
var _ = (function (){var statearr_55751 = state_55741;
(statearr_55751[(4)] = cljs.core.rest((state_55741[(4)])));

return statearr_55751;
})();
var state_55741__$1 = state_55741;
var ex55746 = (state_55741__$1[(2)]);
var statearr_55752_55768 = state_55741__$1;
(statearr_55752_55768[(5)] = ex55746);


if((ex55746 instanceof Error)){
var statearr_55753_55769 = state_55741__$1;
(statearr_55753_55769[(1)] = (4));

(statearr_55753_55769[(5)] = null);

} else {
throw ex55746;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55742 === (8))){
var inst_55728 = (state_55741[(2)]);
var inst_55729 = fluree.db.dbfunctions.internal.inc(inst_55728);
var inst_55730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55731 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55732 = ["inc",inst_55728,inst_55729];
var inst_55733 = cljs.core.PersistentHashMap.fromArrays(inst_55731,inst_55732);
var inst_55734 = [inst_55733,(10)];
var inst_55735 = (new cljs.core.PersistentVector(null,2,(5),inst_55730,inst_55734,null));
var inst_55736 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55735);
var _ = (function (){var statearr_55754 = state_55741;
(statearr_55754[(4)] = cljs.core.rest((state_55741[(4)])));

return statearr_55754;
})();
var state_55741__$1 = (function (){var statearr_55755 = state_55741;
(statearr_55755[(7)] = inst_55736);

return statearr_55755;
})();
var statearr_55756_55770 = state_55741__$1;
(statearr_55756_55770[(2)] = inst_55729);

(statearr_55756_55770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0 = (function (){
var statearr_55757 = [null,null,null,null,null,null,null,null];
(statearr_55757[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__);

(statearr_55757[(1)] = (1));

return statearr_55757;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1 = (function (state_55741){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55741);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55758){var ex__2730__auto__ = e55758;
var statearr_55759_55771 = state_55741;
(statearr_55759_55771[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55741[(4)]))){
var statearr_55760_55772 = state_55741;
(statearr_55760_55772[(1)] = cljs.core.first((state_55741[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55773 = state_55741;
state_55741 = G__55773;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = function(state_55741){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1.call(this,state_55741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55761 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55761[(6)] = c__2749__auto__);

return statearr_55761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55800){
var state_val_55801 = (state_55800[(1)]);
if((state_val_55801 === (7))){
var state_55800__$1 = state_55800;
var statearr_55802_55821 = state_55800__$1;
(statearr_55802_55821[(2)] = n);

(statearr_55802_55821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55801 === (1))){
var state_55800__$1 = state_55800;
var statearr_55803_55822 = state_55800__$1;
(statearr_55803_55822[(2)] = null);

(statearr_55803_55822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55801 === (4))){
var inst_55774 = (state_55800[(2)]);
var state_55800__$1 = state_55800;
var statearr_55804_55823 = state_55800__$1;
(statearr_55804_55823[(2)] = inst_55774);

(statearr_55804_55823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55801 === (6))){
var state_55800__$1 = state_55800;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55800__$1,(9),n);
} else {
if((state_val_55801 === (3))){
var inst_55798 = (state_55800[(2)]);
var state_55800__$1 = state_55800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55800__$1,inst_55798);
} else {
if((state_val_55801 === (2))){
var _ = (function (){var statearr_55806 = state_55800;
(statearr_55806[(4)] = cljs.core.cons((5),(state_55800[(4)])));

return statearr_55806;
})();
var inst_55780 = fluree.db.util.async.channel_QMARK_(n);
var state_55800__$1 = state_55800;
if(inst_55780){
var statearr_55807_55824 = state_55800__$1;
(statearr_55807_55824[(1)] = (6));

} else {
var statearr_55808_55825 = state_55800__$1;
(statearr_55808_55825[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55801 === (9))){
var inst_55783 = (state_55800[(2)]);
var inst_55784 = fluree.db.util.async.throw_err(inst_55783);
var state_55800__$1 = state_55800;
var statearr_55809_55826 = state_55800__$1;
(statearr_55809_55826[(2)] = inst_55784);

(statearr_55809_55826[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55801 === (5))){
var _ = (function (){var statearr_55810 = state_55800;
(statearr_55810[(4)] = cljs.core.rest((state_55800[(4)])));

return statearr_55810;
})();
var state_55800__$1 = state_55800;
var ex55805 = (state_55800__$1[(2)]);
var statearr_55811_55827 = state_55800__$1;
(statearr_55811_55827[(5)] = ex55805);


if((ex55805 instanceof Error)){
var statearr_55812_55828 = state_55800__$1;
(statearr_55812_55828[(1)] = (4));

(statearr_55812_55828[(5)] = null);

} else {
throw ex55805;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55801 === (8))){
var inst_55787 = (state_55800[(2)]);
var inst_55788 = fluree.db.dbfunctions.internal.dec(inst_55787);
var inst_55789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55790 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55791 = ["dec",inst_55787,inst_55788];
var inst_55792 = cljs.core.PersistentHashMap.fromArrays(inst_55790,inst_55791);
var inst_55793 = [inst_55792,(10)];
var inst_55794 = (new cljs.core.PersistentVector(null,2,(5),inst_55789,inst_55793,null));
var inst_55795 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55794);
var _ = (function (){var statearr_55813 = state_55800;
(statearr_55813[(4)] = cljs.core.rest((state_55800[(4)])));

return statearr_55813;
})();
var state_55800__$1 = (function (){var statearr_55814 = state_55800;
(statearr_55814[(7)] = inst_55795);

return statearr_55814;
})();
var statearr_55815_55829 = state_55800__$1;
(statearr_55815_55829[(2)] = inst_55788);

(statearr_55815_55829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0 = (function (){
var statearr_55816 = [null,null,null,null,null,null,null,null];
(statearr_55816[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__);

(statearr_55816[(1)] = (1));

return statearr_55816;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1 = (function (state_55800){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55800);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55817){var ex__2730__auto__ = e55817;
var statearr_55818_55830 = state_55800;
(statearr_55818_55830[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55800[(4)]))){
var statearr_55819_55831 = state_55800;
(statearr_55819_55831[(1)] = cljs.core.first((state_55800[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55832 = state_55800;
state_55800 = G__55832;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = function(state_55800){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1.call(this,state_55800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55820 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55820[(6)] = c__2749__auto__);

return statearr_55820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55882 = arguments.length;
var i__4865__auto___55883 = (0);
while(true){
if((i__4865__auto___55883 < len__4864__auto___55882)){
args__4870__auto__.push((arguments[i__4865__auto___55883]));

var G__55884 = (i__4865__auto___55883 + (1));
i__4865__auto___55883 = G__55884;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55865){
var state_val_55866 = (state_55865[(1)]);
if((state_val_55866 === (1))){
var state_55865__$1 = state_55865;
var statearr_55867_55885 = state_55865__$1;
(statearr_55867_55885[(2)] = null);

(statearr_55867_55885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55866 === (2))){
var _ = (function (){var statearr_55868 = state_55865;
(statearr_55868[(4)] = cljs.core.cons((5),(state_55865[(4)])));

return statearr_55868;
})();
var inst_55841 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55865__$1 = state_55865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55865__$1,(6),inst_55841);
} else {
if((state_val_55866 === (3))){
var inst_55863 = (state_55865[(2)]);
var state_55865__$1 = state_55865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55865__$1,inst_55863);
} else {
if((state_val_55866 === (4))){
var inst_55835 = (state_55865[(2)]);
var state_55865__$1 = state_55865;
var statearr_55870_55886 = state_55865__$1;
(statearr_55870_55886[(2)] = inst_55835);

(statearr_55870_55886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55866 === (5))){
var _ = (function (){var statearr_55871 = state_55865;
(statearr_55871[(4)] = cljs.core.rest((state_55865[(4)])));

return statearr_55871;
})();
var state_55865__$1 = state_55865;
var ex55869 = (state_55865__$1[(2)]);
var statearr_55872_55887 = state_55865__$1;
(statearr_55872_55887[(5)] = ex55869);


if((ex55869 instanceof Error)){
var statearr_55873_55888 = state_55865__$1;
(statearr_55873_55888[(1)] = (4));

(statearr_55873_55888[(5)] = null);

} else {
throw ex55869;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55866 === (6))){
var inst_55843 = (state_55865[(2)]);
var inst_55844 = fluree.db.util.async.throw_err(inst_55843);
var inst_55845 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_55844);
var inst_55846 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55847 = [inst_55844];
var inst_55848 = (new cljs.core.PersistentVector(null,1,(5),inst_55846,inst_55847,null));
var inst_55849 = cljs.core.count(inst_55848);
var inst_55850 = ((9) + inst_55849);
var inst_55851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55852 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55854 = [inst_55844];
var inst_55855 = (new cljs.core.PersistentVector(null,1,(5),inst_55853,inst_55854,null));
var inst_55856 = ["+",inst_55855,inst_55845];
var inst_55857 = cljs.core.PersistentHashMap.fromArrays(inst_55852,inst_55856);
var inst_55858 = [inst_55857,inst_55850];
var inst_55859 = (new cljs.core.PersistentVector(null,2,(5),inst_55851,inst_55858,null));
var inst_55860 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55859);
var _ = (function (){var statearr_55874 = state_55865;
(statearr_55874[(4)] = cljs.core.rest((state_55865[(4)])));

return statearr_55874;
})();
var state_55865__$1 = (function (){var statearr_55875 = state_55865;
(statearr_55875[(7)] = inst_55860);

return statearr_55875;
})();
var statearr_55876_55889 = state_55865__$1;
(statearr_55876_55889[(2)] = inst_55845);

(statearr_55876_55889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55877 = [null,null,null,null,null,null,null,null];
(statearr_55877[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55877[(1)] = (1));

return statearr_55877;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55865){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55865);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55878){var ex__2730__auto__ = e55878;
var statearr_55879_55890 = state_55865;
(statearr_55879_55890[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55865[(4)]))){
var statearr_55880_55891 = state_55865;
(statearr_55880_55891[(1)] = cljs.core.first((state_55865[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55892 = state_55865;
state_55865 = G__55892;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55865){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55881 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55881[(6)] = c__2749__auto__);

return statearr_55881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq55833){
var G__55834 = cljs.core.first(seq55833);
var seq55833__$1 = cljs.core.next(seq55833);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55834,seq55833__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55942 = arguments.length;
var i__4865__auto___55943 = (0);
while(true){
if((i__4865__auto___55943 < len__4864__auto___55942)){
args__4870__auto__.push((arguments[i__4865__auto___55943]));

var G__55944 = (i__4865__auto___55943 + (1));
i__4865__auto___55943 = G__55944;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55925){
var state_val_55926 = (state_55925[(1)]);
if((state_val_55926 === (1))){
var state_55925__$1 = state_55925;
var statearr_55927_55945 = state_55925__$1;
(statearr_55927_55945[(2)] = null);

(statearr_55927_55945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55926 === (2))){
var _ = (function (){var statearr_55928 = state_55925;
(statearr_55928[(4)] = cljs.core.cons((5),(state_55925[(4)])));

return statearr_55928;
})();
var inst_55901 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55925__$1 = state_55925;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55925__$1,(6),inst_55901);
} else {
if((state_val_55926 === (3))){
var inst_55923 = (state_55925[(2)]);
var state_55925__$1 = state_55925;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55925__$1,inst_55923);
} else {
if((state_val_55926 === (4))){
var inst_55895 = (state_55925[(2)]);
var state_55925__$1 = state_55925;
var statearr_55930_55946 = state_55925__$1;
(statearr_55930_55946[(2)] = inst_55895);

(statearr_55930_55946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55926 === (5))){
var _ = (function (){var statearr_55931 = state_55925;
(statearr_55931[(4)] = cljs.core.rest((state_55925[(4)])));

return statearr_55931;
})();
var state_55925__$1 = state_55925;
var ex55929 = (state_55925__$1[(2)]);
var statearr_55932_55947 = state_55925__$1;
(statearr_55932_55947[(5)] = ex55929);


if((ex55929 instanceof Error)){
var statearr_55933_55948 = state_55925__$1;
(statearr_55933_55948[(1)] = (4));

(statearr_55933_55948[(5)] = null);

} else {
throw ex55929;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55926 === (6))){
var inst_55903 = (state_55925[(2)]);
var inst_55904 = fluree.db.util.async.throw_err(inst_55903);
var inst_55905 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_55904);
var inst_55906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55907 = [inst_55904];
var inst_55908 = (new cljs.core.PersistentVector(null,1,(5),inst_55906,inst_55907,null));
var inst_55909 = cljs.core.count(inst_55908);
var inst_55910 = ((9) + inst_55909);
var inst_55911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55912 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55914 = [inst_55904];
var inst_55915 = (new cljs.core.PersistentVector(null,1,(5),inst_55913,inst_55914,null));
var inst_55916 = ["-",inst_55915,inst_55905];
var inst_55917 = cljs.core.PersistentHashMap.fromArrays(inst_55912,inst_55916);
var inst_55918 = [inst_55917,inst_55910];
var inst_55919 = (new cljs.core.PersistentVector(null,2,(5),inst_55911,inst_55918,null));
var inst_55920 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55919);
var _ = (function (){var statearr_55934 = state_55925;
(statearr_55934[(4)] = cljs.core.rest((state_55925[(4)])));

return statearr_55934;
})();
var state_55925__$1 = (function (){var statearr_55935 = state_55925;
(statearr_55935[(7)] = inst_55920);

return statearr_55935;
})();
var statearr_55936_55949 = state_55925__$1;
(statearr_55936_55949[(2)] = inst_55905);

(statearr_55936_55949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55937 = [null,null,null,null,null,null,null,null];
(statearr_55937[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55937[(1)] = (1));

return statearr_55937;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55925){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55925);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55938){var ex__2730__auto__ = e55938;
var statearr_55939_55950 = state_55925;
(statearr_55939_55950[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55925[(4)]))){
var statearr_55940_55951 = state_55925;
(statearr_55940_55951[(1)] = cljs.core.first((state_55925[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55952 = state_55925;
state_55925 = G__55952;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55925){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55941 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55941[(6)] = c__2749__auto__);

return statearr_55941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq55893){
var G__55894 = cljs.core.first(seq55893);
var seq55893__$1 = cljs.core.next(seq55893);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55894,seq55893__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___56002 = arguments.length;
var i__4865__auto___56003 = (0);
while(true){
if((i__4865__auto___56003 < len__4864__auto___56002)){
args__4870__auto__.push((arguments[i__4865__auto___56003]));

var G__56004 = (i__4865__auto___56003 + (1));
i__4865__auto___56003 = G__56004;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55985){
var state_val_55986 = (state_55985[(1)]);
if((state_val_55986 === (1))){
var state_55985__$1 = state_55985;
var statearr_55987_56005 = state_55985__$1;
(statearr_55987_56005[(2)] = null);

(statearr_55987_56005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55986 === (2))){
var _ = (function (){var statearr_55988 = state_55985;
(statearr_55988[(4)] = cljs.core.cons((5),(state_55985[(4)])));

return statearr_55988;
})();
var inst_55961 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55985__$1 = state_55985;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55985__$1,(6),inst_55961);
} else {
if((state_val_55986 === (3))){
var inst_55983 = (state_55985[(2)]);
var state_55985__$1 = state_55985;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55985__$1,inst_55983);
} else {
if((state_val_55986 === (4))){
var inst_55955 = (state_55985[(2)]);
var state_55985__$1 = state_55985;
var statearr_55990_56006 = state_55985__$1;
(statearr_55990_56006[(2)] = inst_55955);

(statearr_55990_56006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55986 === (5))){
var _ = (function (){var statearr_55991 = state_55985;
(statearr_55991[(4)] = cljs.core.rest((state_55985[(4)])));

return statearr_55991;
})();
var state_55985__$1 = state_55985;
var ex55989 = (state_55985__$1[(2)]);
var statearr_55992_56007 = state_55985__$1;
(statearr_55992_56007[(5)] = ex55989);


if((ex55989 instanceof Error)){
var statearr_55993_56008 = state_55985__$1;
(statearr_55993_56008[(1)] = (4));

(statearr_55993_56008[(5)] = null);

} else {
throw ex55989;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55986 === (6))){
var inst_55963 = (state_55985[(2)]);
var inst_55964 = fluree.db.util.async.throw_err(inst_55963);
var inst_55965 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_55964);
var inst_55966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55967 = [inst_55964];
var inst_55968 = (new cljs.core.PersistentVector(null,1,(5),inst_55966,inst_55967,null));
var inst_55969 = cljs.core.count(inst_55968);
var inst_55970 = ((9) + inst_55969);
var inst_55971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55972 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55974 = [inst_55964];
var inst_55975 = (new cljs.core.PersistentVector(null,1,(5),inst_55973,inst_55974,null));
var inst_55976 = ["*",inst_55975,inst_55965];
var inst_55977 = cljs.core.PersistentHashMap.fromArrays(inst_55972,inst_55976);
var inst_55978 = [inst_55977,inst_55970];
var inst_55979 = (new cljs.core.PersistentVector(null,2,(5),inst_55971,inst_55978,null));
var inst_55980 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55979);
var _ = (function (){var statearr_55994 = state_55985;
(statearr_55994[(4)] = cljs.core.rest((state_55985[(4)])));

return statearr_55994;
})();
var state_55985__$1 = (function (){var statearr_55995 = state_55985;
(statearr_55995[(7)] = inst_55980);

return statearr_55995;
})();
var statearr_55996_56009 = state_55985__$1;
(statearr_55996_56009[(2)] = inst_55965);

(statearr_55996_56009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55997 = [null,null,null,null,null,null,null,null];
(statearr_55997[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55997[(1)] = (1));

return statearr_55997;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55985){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55985);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55998){var ex__2730__auto__ = e55998;
var statearr_55999_56010 = state_55985;
(statearr_55999_56010[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55985[(4)]))){
var statearr_56000_56011 = state_55985;
(statearr_56000_56011[(1)] = cljs.core.first((state_55985[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56012 = state_55985;
state_55985 = G__56012;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55985){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56001 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56001[(6)] = c__2749__auto__);

return statearr_56001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq55953){
var G__55954 = cljs.core.first(seq55953);
var seq55953__$1 = cljs.core.next(seq55953);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55954,seq55953__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___56062 = arguments.length;
var i__4865__auto___56063 = (0);
while(true){
if((i__4865__auto___56063 < len__4864__auto___56062)){
args__4870__auto__.push((arguments[i__4865__auto___56063]));

var G__56064 = (i__4865__auto___56063 + (1));
i__4865__auto___56063 = G__56064;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56045){
var state_val_56046 = (state_56045[(1)]);
if((state_val_56046 === (1))){
var state_56045__$1 = state_56045;
var statearr_56047_56065 = state_56045__$1;
(statearr_56047_56065[(2)] = null);

(statearr_56047_56065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56046 === (2))){
var _ = (function (){var statearr_56048 = state_56045;
(statearr_56048[(4)] = cljs.core.cons((5),(state_56045[(4)])));

return statearr_56048;
})();
var inst_56021 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56045__$1 = state_56045;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56045__$1,(6),inst_56021);
} else {
if((state_val_56046 === (3))){
var inst_56043 = (state_56045[(2)]);
var state_56045__$1 = state_56045;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56045__$1,inst_56043);
} else {
if((state_val_56046 === (4))){
var inst_56015 = (state_56045[(2)]);
var state_56045__$1 = state_56045;
var statearr_56050_56066 = state_56045__$1;
(statearr_56050_56066[(2)] = inst_56015);

(statearr_56050_56066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56046 === (5))){
var _ = (function (){var statearr_56051 = state_56045;
(statearr_56051[(4)] = cljs.core.rest((state_56045[(4)])));

return statearr_56051;
})();
var state_56045__$1 = state_56045;
var ex56049 = (state_56045__$1[(2)]);
var statearr_56052_56067 = state_56045__$1;
(statearr_56052_56067[(5)] = ex56049);


if((ex56049 instanceof Error)){
var statearr_56053_56068 = state_56045__$1;
(statearr_56053_56068[(1)] = (4));

(statearr_56053_56068[(5)] = null);

} else {
throw ex56049;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56046 === (6))){
var inst_56023 = (state_56045[(2)]);
var inst_56024 = fluree.db.util.async.throw_err(inst_56023);
var inst_56025 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_56024);
var inst_56026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56027 = [inst_56024];
var inst_56028 = (new cljs.core.PersistentVector(null,1,(5),inst_56026,inst_56027,null));
var inst_56029 = cljs.core.count(inst_56028);
var inst_56030 = ((9) + inst_56029);
var inst_56031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56032 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56034 = [inst_56024];
var inst_56035 = (new cljs.core.PersistentVector(null,1,(5),inst_56033,inst_56034,null));
var inst_56036 = ["/",inst_56035,inst_56025];
var inst_56037 = cljs.core.PersistentHashMap.fromArrays(inst_56032,inst_56036);
var inst_56038 = [inst_56037,inst_56030];
var inst_56039 = (new cljs.core.PersistentVector(null,2,(5),inst_56031,inst_56038,null));
var inst_56040 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56039);
var _ = (function (){var statearr_56054 = state_56045;
(statearr_56054[(4)] = cljs.core.rest((state_56045[(4)])));

return statearr_56054;
})();
var state_56045__$1 = (function (){var statearr_56055 = state_56045;
(statearr_56055[(7)] = inst_56040);

return statearr_56055;
})();
var statearr_56056_56069 = state_56045__$1;
(statearr_56056_56069[(2)] = inst_56025);

(statearr_56056_56069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56057 = [null,null,null,null,null,null,null,null];
(statearr_56057[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56057[(1)] = (1));

return statearr_56057;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56045){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56045);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56058){var ex__2730__auto__ = e56058;
var statearr_56059_56070 = state_56045;
(statearr_56059_56070[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56045[(4)]))){
var statearr_56060_56071 = state_56045;
(statearr_56060_56071[(1)] = cljs.core.first((state_56045[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56072 = state_56045;
state_56045 = G__56072;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56045){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56061 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56061[(6)] = c__2749__auto__);

return statearr_56061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56013){
var G__56014 = cljs.core.first(seq56013);
var seq56013__$1 = cljs.core.next(seq56013);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56014,seq56013__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56110){
var state_val_56111 = (state_56110[(1)]);
if((state_val_56111 === (7))){
var state_56110__$1 = state_56110;
var statearr_56112_56136 = state_56110__$1;
(statearr_56112_56136[(2)] = n);

(statearr_56112_56136[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56111 === (1))){
var state_56110__$1 = state_56110;
var statearr_56113_56137 = state_56110__$1;
(statearr_56113_56137[(2)] = null);

(statearr_56113_56137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56111 === (4))){
var inst_56073 = (state_56110[(2)]);
var state_56110__$1 = state_56110;
var statearr_56114_56138 = state_56110__$1;
(statearr_56114_56138[(2)] = inst_56073);

(statearr_56114_56138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56111 === (13))){
var inst_56090 = (state_56110[(2)]);
var inst_56091 = fluree.db.util.async.throw_err(inst_56090);
var state_56110__$1 = state_56110;
var statearr_56115_56139 = state_56110__$1;
(statearr_56115_56139[(2)] = inst_56091);

(statearr_56115_56139[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56111 === (6))){
var state_56110__$1 = state_56110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56110__$1,(9),n);
} else {
if((state_val_56111 === (3))){
var inst_56108 = (state_56110[(2)]);
var state_56110__$1 = state_56110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56110__$1,inst_56108);
} else {
if((state_val_56111 === (12))){
var inst_56086 = (state_56110[(7)]);
var inst_56094 = (state_56110[(2)]);
var inst_56095 = fluree.db.dbfunctions.internal.quot(inst_56086,inst_56094);
var inst_56096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56097 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56099 = [inst_56086,inst_56094];
var inst_56100 = (new cljs.core.PersistentVector(null,2,(5),inst_56098,inst_56099,null));
var inst_56101 = ["quot",inst_56100,inst_56095];
var inst_56102 = cljs.core.PersistentHashMap.fromArrays(inst_56097,inst_56101);
var inst_56103 = [inst_56102,(2)];
var inst_56104 = (new cljs.core.PersistentVector(null,2,(5),inst_56096,inst_56103,null));
var inst_56105 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56104);
var _ = (function (){var statearr_56116 = state_56110;
(statearr_56116[(4)] = cljs.core.rest((state_56110[(4)])));

return statearr_56116;
})();
var state_56110__$1 = (function (){var statearr_56117 = state_56110;
(statearr_56117[(8)] = inst_56105);

return statearr_56117;
})();
var statearr_56118_56140 = state_56110__$1;
(statearr_56118_56140[(2)] = inst_56095);

(statearr_56118_56140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56111 === (2))){
var _ = (function (){var statearr_56119 = state_56110;
(statearr_56119[(4)] = cljs.core.cons((5),(state_56110[(4)])));

return statearr_56119;
})();
var inst_56079 = fluree.db.util.async.channel_QMARK_(n);
var state_56110__$1 = state_56110;
if(inst_56079){
var statearr_56120_56141 = state_56110__$1;
(statearr_56120_56141[(1)] = (6));

} else {
var statearr_56121_56142 = state_56110__$1;
(statearr_56121_56142[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56111 === (11))){
var state_56110__$1 = state_56110;
var statearr_56123_56143 = state_56110__$1;
(statearr_56123_56143[(2)] = d);

(statearr_56123_56143[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56111 === (9))){
var inst_56082 = (state_56110[(2)]);
var inst_56083 = fluree.db.util.async.throw_err(inst_56082);
var state_56110__$1 = state_56110;
var statearr_56124_56144 = state_56110__$1;
(statearr_56124_56144[(2)] = inst_56083);

(statearr_56124_56144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56111 === (5))){
var _ = (function (){var statearr_56125 = state_56110;
(statearr_56125[(4)] = cljs.core.rest((state_56110[(4)])));

return statearr_56125;
})();
var state_56110__$1 = state_56110;
var ex56122 = (state_56110__$1[(2)]);
var statearr_56126_56145 = state_56110__$1;
(statearr_56126_56145[(5)] = ex56122);


if((ex56122 instanceof Error)){
var statearr_56127_56146 = state_56110__$1;
(statearr_56127_56146[(1)] = (4));

(statearr_56127_56146[(5)] = null);

} else {
throw ex56122;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56111 === (10))){
var state_56110__$1 = state_56110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56110__$1,(13),d);
} else {
if((state_val_56111 === (8))){
var inst_56086 = (state_56110[(2)]);
var inst_56087 = fluree.db.util.async.channel_QMARK_(d);
var state_56110__$1 = (function (){var statearr_56128 = state_56110;
(statearr_56128[(7)] = inst_56086);

return statearr_56128;
})();
if(inst_56087){
var statearr_56129_56147 = state_56110__$1;
(statearr_56129_56147[(1)] = (10));

} else {
var statearr_56130_56148 = state_56110__$1;
(statearr_56130_56148[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0 = (function (){
var statearr_56131 = [null,null,null,null,null,null,null,null,null];
(statearr_56131[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__);

(statearr_56131[(1)] = (1));

return statearr_56131;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1 = (function (state_56110){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56110);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56132){var ex__2730__auto__ = e56132;
var statearr_56133_56149 = state_56110;
(statearr_56133_56149[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56110[(4)]))){
var statearr_56134_56150 = state_56110;
(statearr_56134_56150[(1)] = cljs.core.first((state_56110[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56151 = state_56110;
state_56110 = G__56151;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = function(state_56110){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1.call(this,state_56110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56135 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56135[(6)] = c__2749__auto__);

return statearr_56135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56189){
var state_val_56190 = (state_56189[(1)]);
if((state_val_56190 === (7))){
var state_56189__$1 = state_56189;
var statearr_56191_56215 = state_56189__$1;
(statearr_56191_56215[(2)] = n);

(statearr_56191_56215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56190 === (1))){
var state_56189__$1 = state_56189;
var statearr_56192_56216 = state_56189__$1;
(statearr_56192_56216[(2)] = null);

(statearr_56192_56216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56190 === (4))){
var inst_56152 = (state_56189[(2)]);
var state_56189__$1 = state_56189;
var statearr_56193_56217 = state_56189__$1;
(statearr_56193_56217[(2)] = inst_56152);

(statearr_56193_56217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56190 === (13))){
var inst_56169 = (state_56189[(2)]);
var inst_56170 = fluree.db.util.async.throw_err(inst_56169);
var state_56189__$1 = state_56189;
var statearr_56194_56218 = state_56189__$1;
(statearr_56194_56218[(2)] = inst_56170);

(statearr_56194_56218[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56190 === (6))){
var state_56189__$1 = state_56189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56189__$1,(9),n);
} else {
if((state_val_56190 === (3))){
var inst_56187 = (state_56189[(2)]);
var state_56189__$1 = state_56189;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56189__$1,inst_56187);
} else {
if((state_val_56190 === (12))){
var inst_56165 = (state_56189[(7)]);
var inst_56173 = (state_56189[(2)]);
var inst_56174 = fluree.db.dbfunctions.internal.mod(inst_56165,inst_56173);
var inst_56175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56176 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56178 = [inst_56165,inst_56173];
var inst_56179 = (new cljs.core.PersistentVector(null,2,(5),inst_56177,inst_56178,null));
var inst_56180 = ["mod",inst_56179,inst_56174];
var inst_56181 = cljs.core.PersistentHashMap.fromArrays(inst_56176,inst_56180);
var inst_56182 = [inst_56181,(2)];
var inst_56183 = (new cljs.core.PersistentVector(null,2,(5),inst_56175,inst_56182,null));
var inst_56184 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56183);
var _ = (function (){var statearr_56195 = state_56189;
(statearr_56195[(4)] = cljs.core.rest((state_56189[(4)])));

return statearr_56195;
})();
var state_56189__$1 = (function (){var statearr_56196 = state_56189;
(statearr_56196[(8)] = inst_56184);

return statearr_56196;
})();
var statearr_56197_56219 = state_56189__$1;
(statearr_56197_56219[(2)] = inst_56174);

(statearr_56197_56219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56190 === (2))){
var _ = (function (){var statearr_56198 = state_56189;
(statearr_56198[(4)] = cljs.core.cons((5),(state_56189[(4)])));

return statearr_56198;
})();
var inst_56158 = fluree.db.util.async.channel_QMARK_(n);
var state_56189__$1 = state_56189;
if(inst_56158){
var statearr_56199_56220 = state_56189__$1;
(statearr_56199_56220[(1)] = (6));

} else {
var statearr_56200_56221 = state_56189__$1;
(statearr_56200_56221[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56190 === (11))){
var state_56189__$1 = state_56189;
var statearr_56202_56222 = state_56189__$1;
(statearr_56202_56222[(2)] = d);

(statearr_56202_56222[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56190 === (9))){
var inst_56161 = (state_56189[(2)]);
var inst_56162 = fluree.db.util.async.throw_err(inst_56161);
var state_56189__$1 = state_56189;
var statearr_56203_56223 = state_56189__$1;
(statearr_56203_56223[(2)] = inst_56162);

(statearr_56203_56223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56190 === (5))){
var _ = (function (){var statearr_56204 = state_56189;
(statearr_56204[(4)] = cljs.core.rest((state_56189[(4)])));

return statearr_56204;
})();
var state_56189__$1 = state_56189;
var ex56201 = (state_56189__$1[(2)]);
var statearr_56205_56224 = state_56189__$1;
(statearr_56205_56224[(5)] = ex56201);


if((ex56201 instanceof Error)){
var statearr_56206_56225 = state_56189__$1;
(statearr_56206_56225[(1)] = (4));

(statearr_56206_56225[(5)] = null);

} else {
throw ex56201;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56190 === (10))){
var state_56189__$1 = state_56189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56189__$1,(13),d);
} else {
if((state_val_56190 === (8))){
var inst_56165 = (state_56189[(2)]);
var inst_56166 = fluree.db.util.async.channel_QMARK_(d);
var state_56189__$1 = (function (){var statearr_56207 = state_56189;
(statearr_56207[(7)] = inst_56165);

return statearr_56207;
})();
if(inst_56166){
var statearr_56208_56226 = state_56189__$1;
(statearr_56208_56226[(1)] = (10));

} else {
var statearr_56209_56227 = state_56189__$1;
(statearr_56209_56227[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0 = (function (){
var statearr_56210 = [null,null,null,null,null,null,null,null,null];
(statearr_56210[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__);

(statearr_56210[(1)] = (1));

return statearr_56210;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1 = (function (state_56189){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56189);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56211){var ex__2730__auto__ = e56211;
var statearr_56212_56228 = state_56189;
(statearr_56212_56228[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56189[(4)]))){
var statearr_56213_56229 = state_56189;
(statearr_56213_56229[(1)] = cljs.core.first((state_56189[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56230 = state_56189;
state_56189 = G__56230;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = function(state_56189){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1.call(this,state_56189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56214 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56214[(6)] = c__2749__auto__);

return statearr_56214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56268){
var state_val_56269 = (state_56268[(1)]);
if((state_val_56269 === (7))){
var state_56268__$1 = state_56268;
var statearr_56270_56294 = state_56268__$1;
(statearr_56270_56294[(2)] = n);

(statearr_56270_56294[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56269 === (1))){
var state_56268__$1 = state_56268;
var statearr_56271_56295 = state_56268__$1;
(statearr_56271_56295[(2)] = null);

(statearr_56271_56295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56269 === (4))){
var inst_56231 = (state_56268[(2)]);
var state_56268__$1 = state_56268;
var statearr_56272_56296 = state_56268__$1;
(statearr_56272_56296[(2)] = inst_56231);

(statearr_56272_56296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56269 === (13))){
var inst_56248 = (state_56268[(2)]);
var inst_56249 = fluree.db.util.async.throw_err(inst_56248);
var state_56268__$1 = state_56268;
var statearr_56273_56297 = state_56268__$1;
(statearr_56273_56297[(2)] = inst_56249);

(statearr_56273_56297[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56269 === (6))){
var state_56268__$1 = state_56268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56268__$1,(9),n);
} else {
if((state_val_56269 === (3))){
var inst_56266 = (state_56268[(2)]);
var state_56268__$1 = state_56268;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56268__$1,inst_56266);
} else {
if((state_val_56269 === (12))){
var inst_56244 = (state_56268[(7)]);
var inst_56252 = (state_56268[(2)]);
var inst_56253 = fluree.db.dbfunctions.internal.rem(inst_56244,inst_56252);
var inst_56254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56255 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56257 = [inst_56244,inst_56252];
var inst_56258 = (new cljs.core.PersistentVector(null,2,(5),inst_56256,inst_56257,null));
var inst_56259 = ["rem",inst_56258,inst_56253];
var inst_56260 = cljs.core.PersistentHashMap.fromArrays(inst_56255,inst_56259);
var inst_56261 = [inst_56260,(2)];
var inst_56262 = (new cljs.core.PersistentVector(null,2,(5),inst_56254,inst_56261,null));
var inst_56263 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56262);
var _ = (function (){var statearr_56274 = state_56268;
(statearr_56274[(4)] = cljs.core.rest((state_56268[(4)])));

return statearr_56274;
})();
var state_56268__$1 = (function (){var statearr_56275 = state_56268;
(statearr_56275[(8)] = inst_56263);

return statearr_56275;
})();
var statearr_56276_56298 = state_56268__$1;
(statearr_56276_56298[(2)] = inst_56253);

(statearr_56276_56298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56269 === (2))){
var _ = (function (){var statearr_56277 = state_56268;
(statearr_56277[(4)] = cljs.core.cons((5),(state_56268[(4)])));

return statearr_56277;
})();
var inst_56237 = fluree.db.util.async.channel_QMARK_(n);
var state_56268__$1 = state_56268;
if(inst_56237){
var statearr_56278_56299 = state_56268__$1;
(statearr_56278_56299[(1)] = (6));

} else {
var statearr_56279_56300 = state_56268__$1;
(statearr_56279_56300[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56269 === (11))){
var state_56268__$1 = state_56268;
var statearr_56281_56301 = state_56268__$1;
(statearr_56281_56301[(2)] = d);

(statearr_56281_56301[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56269 === (9))){
var inst_56240 = (state_56268[(2)]);
var inst_56241 = fluree.db.util.async.throw_err(inst_56240);
var state_56268__$1 = state_56268;
var statearr_56282_56302 = state_56268__$1;
(statearr_56282_56302[(2)] = inst_56241);

(statearr_56282_56302[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56269 === (5))){
var _ = (function (){var statearr_56283 = state_56268;
(statearr_56283[(4)] = cljs.core.rest((state_56268[(4)])));

return statearr_56283;
})();
var state_56268__$1 = state_56268;
var ex56280 = (state_56268__$1[(2)]);
var statearr_56284_56303 = state_56268__$1;
(statearr_56284_56303[(5)] = ex56280);


if((ex56280 instanceof Error)){
var statearr_56285_56304 = state_56268__$1;
(statearr_56285_56304[(1)] = (4));

(statearr_56285_56304[(5)] = null);

} else {
throw ex56280;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56269 === (10))){
var state_56268__$1 = state_56268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56268__$1,(13),d);
} else {
if((state_val_56269 === (8))){
var inst_56244 = (state_56268[(2)]);
var inst_56245 = fluree.db.util.async.channel_QMARK_(d);
var state_56268__$1 = (function (){var statearr_56286 = state_56268;
(statearr_56286[(7)] = inst_56244);

return statearr_56286;
})();
if(inst_56245){
var statearr_56287_56305 = state_56268__$1;
(statearr_56287_56305[(1)] = (10));

} else {
var statearr_56288_56306 = state_56268__$1;
(statearr_56288_56306[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0 = (function (){
var statearr_56289 = [null,null,null,null,null,null,null,null,null];
(statearr_56289[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__);

(statearr_56289[(1)] = (1));

return statearr_56289;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1 = (function (state_56268){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56268);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56290){var ex__2730__auto__ = e56290;
var statearr_56291_56307 = state_56268;
(statearr_56291_56307[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56268[(4)]))){
var statearr_56292_56308 = state_56268;
(statearr_56292_56308[(1)] = cljs.core.first((state_56268[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56309 = state_56268;
state_56268 = G__56309;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = function(state_56268){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1.call(this,state_56268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56293 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56293[(6)] = c__2749__auto__);

return statearr_56293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56336){
var state_val_56337 = (state_56336[(1)]);
if((state_val_56337 === (7))){
var state_56336__$1 = state_56336;
var statearr_56338_56357 = state_56336__$1;
(statearr_56338_56357[(2)] = x);

(statearr_56338_56357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (1))){
var state_56336__$1 = state_56336;
var statearr_56339_56358 = state_56336__$1;
(statearr_56339_56358[(2)] = null);

(statearr_56339_56358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (4))){
var inst_56310 = (state_56336[(2)]);
var state_56336__$1 = state_56336;
var statearr_56340_56359 = state_56336__$1;
(statearr_56340_56359[(2)] = inst_56310);

(statearr_56340_56359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (6))){
var state_56336__$1 = state_56336;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56336__$1,(9),x);
} else {
if((state_val_56337 === (3))){
var inst_56334 = (state_56336[(2)]);
var state_56336__$1 = state_56336;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56336__$1,inst_56334);
} else {
if((state_val_56337 === (2))){
var _ = (function (){var statearr_56342 = state_56336;
(statearr_56342[(4)] = cljs.core.cons((5),(state_56336[(4)])));

return statearr_56342;
})();
var inst_56316 = fluree.db.util.async.channel_QMARK_(x);
var state_56336__$1 = state_56336;
if(inst_56316){
var statearr_56343_56360 = state_56336__$1;
(statearr_56343_56360[(1)] = (6));

} else {
var statearr_56344_56361 = state_56336__$1;
(statearr_56344_56361[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (9))){
var inst_56319 = (state_56336[(2)]);
var inst_56320 = fluree.db.util.async.throw_err(inst_56319);
var state_56336__$1 = state_56336;
var statearr_56345_56362 = state_56336__$1;
(statearr_56345_56362[(2)] = inst_56320);

(statearr_56345_56362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (5))){
var _ = (function (){var statearr_56346 = state_56336;
(statearr_56346[(4)] = cljs.core.rest((state_56336[(4)])));

return statearr_56346;
})();
var state_56336__$1 = state_56336;
var ex56341 = (state_56336__$1[(2)]);
var statearr_56347_56363 = state_56336__$1;
(statearr_56347_56363[(5)] = ex56341);


if((ex56341 instanceof Error)){
var statearr_56348_56364 = state_56336__$1;
(statearr_56348_56364[(1)] = (4));

(statearr_56348_56364[(5)] = null);

} else {
throw ex56341;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56337 === (8))){
var inst_56323 = (state_56336[(2)]);
var inst_56324 = fluree.db.dbfunctions.internal.boolean$(inst_56323);
var inst_56325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56326 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56327 = ["boolean",inst_56323,inst_56324];
var inst_56328 = cljs.core.PersistentHashMap.fromArrays(inst_56326,inst_56327);
var inst_56329 = [inst_56328,(10)];
var inst_56330 = (new cljs.core.PersistentVector(null,2,(5),inst_56325,inst_56329,null));
var inst_56331 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56330);
var _ = (function (){var statearr_56349 = state_56336;
(statearr_56349[(4)] = cljs.core.rest((state_56336[(4)])));

return statearr_56349;
})();
var state_56336__$1 = (function (){var statearr_56350 = state_56336;
(statearr_56350[(7)] = inst_56331);

return statearr_56350;
})();
var statearr_56351_56365 = state_56336__$1;
(statearr_56351_56365[(2)] = inst_56324);

(statearr_56351_56365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0 = (function (){
var statearr_56352 = [null,null,null,null,null,null,null,null];
(statearr_56352[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__);

(statearr_56352[(1)] = (1));

return statearr_56352;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1 = (function (state_56336){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56336);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56353){var ex__2730__auto__ = e56353;
var statearr_56354_56366 = state_56336;
(statearr_56354_56366[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56336[(4)]))){
var statearr_56355_56367 = state_56336;
(statearr_56355_56367[(1)] = cljs.core.first((state_56336[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56368 = state_56336;
state_56336 = G__56368;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = function(state_56336){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1.call(this,state_56336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56356 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56356[(6)] = c__2749__auto__);

return statearr_56356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56406){
var state_val_56407 = (state_56406[(1)]);
if((state_val_56407 === (7))){
var state_56406__$1 = state_56406;
var statearr_56408_56432 = state_56406__$1;
(statearr_56408_56432[(2)] = pattern);

(statearr_56408_56432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56407 === (1))){
var state_56406__$1 = state_56406;
var statearr_56409_56433 = state_56406__$1;
(statearr_56409_56433[(2)] = null);

(statearr_56409_56433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56407 === (4))){
var inst_56369 = (state_56406[(2)]);
var state_56406__$1 = state_56406;
var statearr_56410_56434 = state_56406__$1;
(statearr_56410_56434[(2)] = inst_56369);

(statearr_56410_56434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56407 === (13))){
var inst_56386 = (state_56406[(2)]);
var inst_56387 = fluree.db.util.async.throw_err(inst_56386);
var state_56406__$1 = state_56406;
var statearr_56411_56435 = state_56406__$1;
(statearr_56411_56435[(2)] = inst_56387);

(statearr_56411_56435[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56407 === (6))){
var state_56406__$1 = state_56406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56406__$1,(9),pattern);
} else {
if((state_val_56407 === (3))){
var inst_56404 = (state_56406[(2)]);
var state_56406__$1 = state_56406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56406__$1,inst_56404);
} else {
if((state_val_56407 === (12))){
var inst_56382 = (state_56406[(7)]);
var inst_56390 = (state_56406[(2)]);
var inst_56391 = fluree.db.dbfunctions.internal.re_find(inst_56382,inst_56390);
var inst_56392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56393 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56395 = [inst_56382,inst_56390];
var inst_56396 = (new cljs.core.PersistentVector(null,2,(5),inst_56394,inst_56395,null));
var inst_56397 = ["re-find",inst_56396,inst_56391];
var inst_56398 = cljs.core.PersistentHashMap.fromArrays(inst_56393,inst_56397);
var inst_56399 = [inst_56398,(10)];
var inst_56400 = (new cljs.core.PersistentVector(null,2,(5),inst_56392,inst_56399,null));
var inst_56401 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56400);
var _ = (function (){var statearr_56412 = state_56406;
(statearr_56412[(4)] = cljs.core.rest((state_56406[(4)])));

return statearr_56412;
})();
var state_56406__$1 = (function (){var statearr_56413 = state_56406;
(statearr_56413[(8)] = inst_56401);

return statearr_56413;
})();
var statearr_56414_56436 = state_56406__$1;
(statearr_56414_56436[(2)] = inst_56391);

(statearr_56414_56436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56407 === (2))){
var _ = (function (){var statearr_56415 = state_56406;
(statearr_56415[(4)] = cljs.core.cons((5),(state_56406[(4)])));

return statearr_56415;
})();
var inst_56375 = fluree.db.util.async.channel_QMARK_(pattern);
var state_56406__$1 = state_56406;
if(inst_56375){
var statearr_56416_56437 = state_56406__$1;
(statearr_56416_56437[(1)] = (6));

} else {
var statearr_56417_56438 = state_56406__$1;
(statearr_56417_56438[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56407 === (11))){
var state_56406__$1 = state_56406;
var statearr_56419_56439 = state_56406__$1;
(statearr_56419_56439[(2)] = string);

(statearr_56419_56439[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56407 === (9))){
var inst_56378 = (state_56406[(2)]);
var inst_56379 = fluree.db.util.async.throw_err(inst_56378);
var state_56406__$1 = state_56406;
var statearr_56420_56440 = state_56406__$1;
(statearr_56420_56440[(2)] = inst_56379);

(statearr_56420_56440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56407 === (5))){
var _ = (function (){var statearr_56421 = state_56406;
(statearr_56421[(4)] = cljs.core.rest((state_56406[(4)])));

return statearr_56421;
})();
var state_56406__$1 = state_56406;
var ex56418 = (state_56406__$1[(2)]);
var statearr_56422_56441 = state_56406__$1;
(statearr_56422_56441[(5)] = ex56418);


if((ex56418 instanceof Error)){
var statearr_56423_56442 = state_56406__$1;
(statearr_56423_56442[(1)] = (4));

(statearr_56423_56442[(5)] = null);

} else {
throw ex56418;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56407 === (10))){
var state_56406__$1 = state_56406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56406__$1,(13),string);
} else {
if((state_val_56407 === (8))){
var inst_56382 = (state_56406[(2)]);
var inst_56383 = fluree.db.util.async.channel_QMARK_(string);
var state_56406__$1 = (function (){var statearr_56424 = state_56406;
(statearr_56424[(7)] = inst_56382);

return statearr_56424;
})();
if(inst_56383){
var statearr_56425_56443 = state_56406__$1;
(statearr_56425_56443[(1)] = (10));

} else {
var statearr_56426_56444 = state_56406__$1;
(statearr_56426_56444[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0 = (function (){
var statearr_56427 = [null,null,null,null,null,null,null,null,null];
(statearr_56427[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__);

(statearr_56427[(1)] = (1));

return statearr_56427;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1 = (function (state_56406){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56406);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56428){var ex__2730__auto__ = e56428;
var statearr_56429_56445 = state_56406;
(statearr_56429_56445[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56406[(4)]))){
var statearr_56430_56446 = state_56406;
(statearr_56430_56446[(1)] = cljs.core.first((state_56406[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56447 = state_56406;
state_56406 = G__56447;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = function(state_56406){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1.call(this,state_56406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56431 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56431[(6)] = c__2749__auto__);

return statearr_56431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56474){
var state_val_56475 = (state_56474[(1)]);
if((state_val_56475 === (7))){
var state_56474__$1 = state_56474;
var statearr_56476_56495 = state_56474__$1;
(statearr_56476_56495[(2)] = email);

(statearr_56476_56495[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (1))){
var state_56474__$1 = state_56474;
var statearr_56477_56496 = state_56474__$1;
(statearr_56477_56496[(2)] = null);

(statearr_56477_56496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (4))){
var inst_56448 = (state_56474[(2)]);
var state_56474__$1 = state_56474;
var statearr_56478_56497 = state_56474__$1;
(statearr_56478_56497[(2)] = inst_56448);

(statearr_56478_56497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (6))){
var state_56474__$1 = state_56474;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56474__$1,(9),email);
} else {
if((state_val_56475 === (3))){
var inst_56472 = (state_56474[(2)]);
var state_56474__$1 = state_56474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56474__$1,inst_56472);
} else {
if((state_val_56475 === (2))){
var _ = (function (){var statearr_56480 = state_56474;
(statearr_56480[(4)] = cljs.core.cons((5),(state_56474[(4)])));

return statearr_56480;
})();
var inst_56454 = fluree.db.util.async.channel_QMARK_(email);
var state_56474__$1 = state_56474;
if(inst_56454){
var statearr_56481_56498 = state_56474__$1;
(statearr_56481_56498[(1)] = (6));

} else {
var statearr_56482_56499 = state_56474__$1;
(statearr_56482_56499[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (9))){
var inst_56457 = (state_56474[(2)]);
var inst_56458 = fluree.db.util.async.throw_err(inst_56457);
var state_56474__$1 = state_56474;
var statearr_56483_56500 = state_56474__$1;
(statearr_56483_56500[(2)] = inst_56458);

(statearr_56483_56500[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (5))){
var _ = (function (){var statearr_56484 = state_56474;
(statearr_56484[(4)] = cljs.core.rest((state_56474[(4)])));

return statearr_56484;
})();
var state_56474__$1 = state_56474;
var ex56479 = (state_56474__$1[(2)]);
var statearr_56485_56501 = state_56474__$1;
(statearr_56485_56501[(5)] = ex56479);


if((ex56479 instanceof Error)){
var statearr_56486_56502 = state_56474__$1;
(statearr_56486_56502[(1)] = (4));

(statearr_56486_56502[(5)] = null);

} else {
throw ex56479;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (8))){
var inst_56461 = (state_56474[(2)]);
var inst_56462 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_56461);
var inst_56463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56464 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56465 = ["re-find",inst_56461,inst_56462];
var inst_56466 = cljs.core.PersistentHashMap.fromArrays(inst_56464,inst_56465);
var inst_56467 = [inst_56466,(10)];
var inst_56468 = (new cljs.core.PersistentVector(null,2,(5),inst_56463,inst_56467,null));
var inst_56469 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56468);
var _ = (function (){var statearr_56487 = state_56474;
(statearr_56487[(4)] = cljs.core.rest((state_56474[(4)])));

return statearr_56487;
})();
var state_56474__$1 = (function (){var statearr_56488 = state_56474;
(statearr_56488[(7)] = inst_56469);

return statearr_56488;
})();
var statearr_56489_56503 = state_56474__$1;
(statearr_56489_56503[(2)] = inst_56462);

(statearr_56489_56503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_56490 = [null,null,null,null,null,null,null,null];
(statearr_56490[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__);

(statearr_56490[(1)] = (1));

return statearr_56490;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1 = (function (state_56474){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56474);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56491){var ex__2730__auto__ = e56491;
var statearr_56492_56504 = state_56474;
(statearr_56492_56504[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56474[(4)]))){
var statearr_56493_56505 = state_56474;
(statearr_56493_56505[(1)] = cljs.core.first((state_56474[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56506 = state_56474;
state_56474 = G__56506;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = function(state_56474){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1.call(this,state_56474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56494 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56494[(6)] = c__2749__auto__);

return statearr_56494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56553){
var state_val_56554 = (state_56553[(1)]);
if((state_val_56554 === (7))){
var inst_56523 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56553__$1 = state_56553;
if(cljs.core.truth_(inst_56523)){
var statearr_56555_56582 = state_56553__$1;
(statearr_56555_56582[(1)] = (9));

} else {
var statearr_56556_56583 = state_56553__$1;
(statearr_56556_56583[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (1))){
var state_56553__$1 = state_56553;
var statearr_56557_56584 = state_56553__$1;
(statearr_56557_56584[(2)] = null);

(statearr_56557_56584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (4))){
var inst_56507 = (state_56553[(2)]);
var state_56553__$1 = state_56553;
var statearr_56558_56585 = state_56553__$1;
(statearr_56558_56585[(2)] = inst_56507);

(statearr_56558_56585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (15))){
var inst_56534 = (state_56553[(2)]);
var state_56553__$1 = state_56553;
var statearr_56559_56586 = state_56553__$1;
(statearr_56559_56586[(2)] = inst_56534);

(statearr_56559_56586[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (13))){
var inst_56531 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_56553__$1 = state_56553;
var statearr_56560_56587 = state_56553__$1;
(statearr_56560_56587[(2)] = inst_56531);

(statearr_56560_56587[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (6))){
var inst_56518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56519 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56520 = [inst_56519,(0)];
var inst_56521 = (new cljs.core.PersistentVector(null,2,(5),inst_56518,inst_56520,null));
var state_56553__$1 = state_56553;
var statearr_56561_56588 = state_56553__$1;
(statearr_56561_56588[(2)] = inst_56521);

(statearr_56561_56588[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (3))){
var inst_56551 = (state_56553[(2)]);
var state_56553__$1 = state_56553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56553__$1,inst_56551);
} else {
if((state_val_56554 === (12))){
var inst_56527 = (state_56553[(2)]);
var inst_56528 = fluree.db.util.async.throw_err(inst_56527);
var state_56553__$1 = state_56553;
var statearr_56562_56589 = state_56553__$1;
(statearr_56562_56589[(2)] = inst_56528);

(statearr_56562_56589[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (2))){
var _ = (function (){var statearr_56563 = state_56553;
(statearr_56563[(4)] = cljs.core.cons((5),(state_56553[(4)])));

return statearr_56563;
})();
var inst_56516 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56553__$1 = state_56553;
if(cljs.core.truth_(inst_56516)){
var statearr_56564_56590 = state_56553__$1;
(statearr_56564_56590[(1)] = (6));

} else {
var statearr_56565_56591 = state_56553__$1;
(statearr_56565_56591[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (11))){
var inst_56536 = (state_56553[(2)]);
var state_56553__$1 = state_56553;
var statearr_56567_56592 = state_56553__$1;
(statearr_56567_56592[(2)] = inst_56536);

(statearr_56567_56592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (9))){
var inst_56525 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_56553__$1 = state_56553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56553__$1,(12),inst_56525);
} else {
if((state_val_56554 === (5))){
var _ = (function (){var statearr_56568 = state_56553;
(statearr_56568[(4)] = cljs.core.rest((state_56553[(4)])));

return statearr_56568;
})();
var state_56553__$1 = state_56553;
var ex56566 = (state_56553__$1[(2)]);
var statearr_56569_56593 = state_56553__$1;
(statearr_56569_56593[(5)] = ex56566);


if((ex56566 instanceof Error)){
var statearr_56570_56594 = state_56553__$1;
(statearr_56570_56594[(1)] = (4));

(statearr_56570_56594[(5)] = null);

} else {
throw ex56566;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (14))){
var state_56553__$1 = state_56553;
var statearr_56571_56595 = state_56553__$1;
(statearr_56571_56595[(2)] = null);

(statearr_56571_56595[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (10))){
var state_56553__$1 = state_56553;
var statearr_56572_56596 = state_56553__$1;
(statearr_56572_56596[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56554 === (8))){
var inst_56538 = (state_56553[(2)]);
var inst_56539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56538,(0),null);
var inst_56540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56538,(1),null);
var inst_56541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56542 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56543 = ["?user_id","?ctx",inst_56539];
var inst_56544 = cljs.core.PersistentHashMap.fromArrays(inst_56542,inst_56543);
var inst_56545 = ((10) + inst_56540);
var inst_56546 = [inst_56544,inst_56545];
var inst_56547 = (new cljs.core.PersistentVector(null,2,(5),inst_56541,inst_56546,null));
var inst_56548 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56547);
var _ = (function (){var statearr_56574 = state_56553;
(statearr_56574[(4)] = cljs.core.rest((state_56553[(4)])));

return statearr_56574;
})();
var state_56553__$1 = (function (){var statearr_56575 = state_56553;
(statearr_56575[(7)] = inst_56548);

return statearr_56575;
})();
var statearr_56576_56597 = state_56553__$1;
(statearr_56576_56597[(2)] = inst_56539);

(statearr_56576_56597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0 = (function (){
var statearr_56577 = [null,null,null,null,null,null,null,null];
(statearr_56577[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__);

(statearr_56577[(1)] = (1));

return statearr_56577;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1 = (function (state_56553){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56553);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56578){var ex__2730__auto__ = e56578;
var statearr_56579_56598 = state_56553;
(statearr_56579_56598[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56553[(4)]))){
var statearr_56580_56599 = state_56553;
(statearr_56580_56599[(1)] = cljs.core.first((state_56553[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56600 = state_56553;
state_56553 = G__56600;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = function(state_56553){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1.call(this,state_56553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56581 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56581[(6)] = c__2749__auto__);

return statearr_56581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56628){
var state_val_56629 = (state_56628[(1)]);
if((state_val_56629 === (7))){
var inst_56621 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_56628__$1 = state_56628;
var statearr_56630_56649 = state_56628__$1;
(statearr_56630_56649[(2)] = inst_56621);

(statearr_56630_56649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56629 === (1))){
var state_56628__$1 = state_56628;
var statearr_56631_56650 = state_56628__$1;
(statearr_56631_56650[(2)] = null);

(statearr_56631_56650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56629 === (4))){
var inst_56601 = (state_56628[(2)]);
var state_56628__$1 = state_56628;
var statearr_56632_56651 = state_56628__$1;
(statearr_56632_56651[(2)] = inst_56601);

(statearr_56632_56651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56629 === (6))){
var inst_56609 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_56628__$1 = state_56628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56628__$1,(9),inst_56609);
} else {
if((state_val_56629 === (3))){
var inst_56626 = (state_56628[(2)]);
var state_56628__$1 = state_56628;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56628__$1,inst_56626);
} else {
if((state_val_56629 === (2))){
var _ = (function (){var statearr_56634 = state_56628;
(statearr_56634[(4)] = cljs.core.cons((5),(state_56628[(4)])));

return statearr_56634;
})();
var inst_56607 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56628__$1 = state_56628;
if(cljs.core.truth_(inst_56607)){
var statearr_56635_56652 = state_56628__$1;
(statearr_56635_56652[(1)] = (6));

} else {
var statearr_56636_56653 = state_56628__$1;
(statearr_56636_56653[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56629 === (9))){
var inst_56611 = (state_56628[(2)]);
var inst_56612 = fluree.db.util.async.throw_err(inst_56611);
var inst_56613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56614 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56615 = ["?auth_id","?ctx",inst_56612];
var inst_56616 = cljs.core.PersistentHashMap.fromArrays(inst_56614,inst_56615);
var inst_56617 = [inst_56616,(10)];
var inst_56618 = (new cljs.core.PersistentVector(null,2,(5),inst_56613,inst_56617,null));
var inst_56619 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56618);
var state_56628__$1 = (function (){var statearr_56637 = state_56628;
(statearr_56637[(7)] = inst_56619);

return statearr_56637;
})();
var statearr_56638_56654 = state_56628__$1;
(statearr_56638_56654[(2)] = inst_56612);

(statearr_56638_56654[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56629 === (5))){
var _ = (function (){var statearr_56639 = state_56628;
(statearr_56639[(4)] = cljs.core.rest((state_56628[(4)])));

return statearr_56639;
})();
var state_56628__$1 = state_56628;
var ex56633 = (state_56628__$1[(2)]);
var statearr_56640_56655 = state_56628__$1;
(statearr_56640_56655[(5)] = ex56633);


if((ex56633 instanceof Error)){
var statearr_56641_56656 = state_56628__$1;
(statearr_56641_56656[(1)] = (4));

(statearr_56641_56656[(5)] = null);

} else {
throw ex56633;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56629 === (8))){
var inst_56623 = (state_56628[(2)]);
var _ = (function (){var statearr_56642 = state_56628;
(statearr_56642[(4)] = cljs.core.rest((state_56628[(4)])));

return statearr_56642;
})();
var state_56628__$1 = state_56628;
var statearr_56643_56657 = state_56628__$1;
(statearr_56643_56657[(2)] = inst_56623);

(statearr_56643_56657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_56644 = [null,null,null,null,null,null,null,null];
(statearr_56644[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_56644[(1)] = (1));

return statearr_56644;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_56628){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56628);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56645){var ex__2730__auto__ = e56645;
var statearr_56646_56658 = state_56628;
(statearr_56646_56658[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56628[(4)]))){
var statearr_56647_56659 = state_56628;
(statearr_56647_56659[(1)] = cljs.core.first((state_56628[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56660 = state_56628;
state_56628 = G__56660;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_56628){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_56628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56648 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56648[(6)] = c__2749__auto__);

return statearr_56648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__56662 = arguments.length;
switch (G__56662) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56704){
var state_val_56705 = (state_56704[(1)]);
if((state_val_56705 === (7))){
var state_56704__$1 = state_56704;
var statearr_56706_56736 = state_56704__$1;
(statearr_56706_56736[(2)] = seed);

(statearr_56706_56736[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (1))){
var state_56704__$1 = state_56704;
var statearr_56707_56737 = state_56704__$1;
(statearr_56707_56737[(2)] = null);

(statearr_56707_56737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (4))){
var inst_56663 = (state_56704[(2)]);
var state_56704__$1 = state_56704;
var statearr_56708_56738 = state_56704__$1;
(statearr_56708_56738[(2)] = inst_56663);

(statearr_56708_56738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (15))){
var state_56704__$1 = state_56704;
var statearr_56709_56739 = state_56704__$1;
(statearr_56709_56739[(2)] = (10));

(statearr_56709_56739[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (13))){
var inst_56680 = (state_56704[(2)]);
var inst_56681 = fluree.db.util.async.throw_err(inst_56680);
var state_56704__$1 = state_56704;
var statearr_56710_56740 = state_56704__$1;
(statearr_56710_56740[(2)] = inst_56681);

(statearr_56710_56740[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (6))){
var state_56704__$1 = state_56704;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56704__$1,(9),seed);
} else {
if((state_val_56705 === (3))){
var inst_56702 = (state_56704[(2)]);
var state_56704__$1 = state_56704;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56704__$1,inst_56702);
} else {
if((state_val_56705 === (12))){
var inst_56684 = (state_56704[(7)]);
var inst_56684__$1 = (state_56704[(2)]);
var state_56704__$1 = (function (){var statearr_56711 = state_56704;
(statearr_56711[(7)] = inst_56684__$1);

return statearr_56711;
})();
if(cljs.core.truth_(inst_56684__$1)){
var statearr_56712_56741 = state_56704__$1;
(statearr_56712_56741[(1)] = (14));

} else {
var statearr_56713_56742 = state_56704__$1;
(statearr_56713_56742[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (2))){
var _ = (function (){var statearr_56714 = state_56704;
(statearr_56714[(4)] = cljs.core.cons((5),(state_56704[(4)])));

return statearr_56714;
})();
var inst_56669 = fluree.db.util.async.channel_QMARK_(seed);
var state_56704__$1 = state_56704;
if(inst_56669){
var statearr_56715_56743 = state_56704__$1;
(statearr_56715_56743[(1)] = (6));

} else {
var statearr_56716_56744 = state_56704__$1;
(statearr_56716_56744[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (11))){
var state_56704__$1 = state_56704;
var statearr_56718_56745 = state_56704__$1;
(statearr_56718_56745[(2)] = max);

(statearr_56718_56745[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (9))){
var inst_56672 = (state_56704[(2)]);
var inst_56673 = fluree.db.util.async.throw_err(inst_56672);
var state_56704__$1 = state_56704;
var statearr_56719_56746 = state_56704__$1;
(statearr_56719_56746[(2)] = inst_56673);

(statearr_56719_56746[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (5))){
var _ = (function (){var statearr_56720 = state_56704;
(statearr_56720[(4)] = cljs.core.rest((state_56704[(4)])));

return statearr_56720;
})();
var state_56704__$1 = state_56704;
var ex56717 = (state_56704__$1[(2)]);
var statearr_56721_56747 = state_56704__$1;
(statearr_56721_56747[(5)] = ex56717);


if((ex56717 instanceof Error)){
var statearr_56722_56748 = state_56704__$1;
(statearr_56722_56748[(1)] = (4));

(statearr_56722_56748[(5)] = null);

} else {
throw ex56717;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (14))){
var inst_56684 = (state_56704[(7)]);
var state_56704__$1 = state_56704;
var statearr_56723_56749 = state_56704__$1;
(statearr_56723_56749[(2)] = inst_56684);

(statearr_56723_56749[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (16))){
var inst_56676 = (state_56704[(8)]);
var inst_56688 = (state_56704[(2)]);
var inst_56689 = fluree.db.dbfunctions.internal.rand(inst_56676,inst_56688);
var inst_56690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56691 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56693 = [max,seed];
var inst_56694 = (new cljs.core.PersistentVector(null,2,(5),inst_56692,inst_56693,null));
var inst_56695 = ["rand",inst_56694,inst_56689];
var inst_56696 = cljs.core.PersistentHashMap.fromArrays(inst_56691,inst_56695);
var inst_56697 = [inst_56696,(10)];
var inst_56698 = (new cljs.core.PersistentVector(null,2,(5),inst_56690,inst_56697,null));
var inst_56699 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56698);
var _ = (function (){var statearr_56724 = state_56704;
(statearr_56724[(4)] = cljs.core.rest((state_56704[(4)])));

return statearr_56724;
})();
var state_56704__$1 = (function (){var statearr_56725 = state_56704;
(statearr_56725[(9)] = inst_56699);

return statearr_56725;
})();
var statearr_56726_56750 = state_56704__$1;
(statearr_56726_56750[(2)] = inst_56689);

(statearr_56726_56750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56705 === (10))){
var state_56704__$1 = state_56704;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56704__$1,(13),max);
} else {
if((state_val_56705 === (8))){
var inst_56676 = (state_56704[(2)]);
var inst_56677 = fluree.db.util.async.channel_QMARK_(max);
var state_56704__$1 = (function (){var statearr_56727 = state_56704;
(statearr_56727[(8)] = inst_56676);

return statearr_56727;
})();
if(inst_56677){
var statearr_56728_56751 = state_56704__$1;
(statearr_56728_56751[(1)] = (10));

} else {
var statearr_56729_56752 = state_56704__$1;
(statearr_56729_56752[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56730 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56730[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56730[(1)] = (1));

return statearr_56730;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56704){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56704);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56731){var ex__2730__auto__ = e56731;
var statearr_56732_56753 = state_56704;
(statearr_56732_56753[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56704[(4)]))){
var statearr_56733_56754 = state_56704;
(statearr_56733_56754[(1)] = cljs.core.first((state_56704[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56755 = state_56704;
state_56704 = G__56755;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56704){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56734 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56734[(6)] = c__2749__auto__);

return statearr_56734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56776){
var state_val_56777 = (state_56776[(1)]);
if((state_val_56777 === (1))){
var state_56776__$1 = state_56776;
var statearr_56778_56793 = state_56776__$1;
(statearr_56778_56793[(2)] = null);

(statearr_56778_56793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56777 === (2))){
var _ = (function (){var statearr_56779 = state_56776;
(statearr_56779[(4)] = cljs.core.cons((5),(state_56776[(4)])));

return statearr_56779;
})();
var inst_56762 = fluree.db.util.core.random_uuid();
var inst_56763 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56762);
var inst_56764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56765 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56766 = cljs.core.PersistentVector.EMPTY;
var inst_56767 = ["uuid",inst_56766,inst_56763];
var inst_56768 = cljs.core.PersistentHashMap.fromArrays(inst_56765,inst_56767);
var inst_56769 = [inst_56768,(10)];
var inst_56770 = (new cljs.core.PersistentVector(null,2,(5),inst_56764,inst_56769,null));
var inst_56771 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56770);
var ___$1 = (function (){var statearr_56780 = state_56776;
(statearr_56780[(4)] = cljs.core.rest((state_56776[(4)])));

return statearr_56780;
})();
var state_56776__$1 = (function (){var statearr_56781 = state_56776;
(statearr_56781[(7)] = inst_56771);

return statearr_56781;
})();
var statearr_56782_56794 = state_56776__$1;
(statearr_56782_56794[(2)] = inst_56763);

(statearr_56782_56794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56777 === (3))){
var inst_56774 = (state_56776[(2)]);
var state_56776__$1 = state_56776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56776__$1,inst_56774);
} else {
if((state_val_56777 === (4))){
var inst_56756 = (state_56776[(2)]);
var state_56776__$1 = state_56776;
var statearr_56784_56795 = state_56776__$1;
(statearr_56784_56795[(2)] = inst_56756);

(statearr_56784_56795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56777 === (5))){
var _ = (function (){var statearr_56785 = state_56776;
(statearr_56785[(4)] = cljs.core.rest((state_56776[(4)])));

return statearr_56785;
})();
var state_56776__$1 = state_56776;
var ex56783 = (state_56776__$1[(2)]);
var statearr_56786_56796 = state_56776__$1;
(statearr_56786_56796[(5)] = ex56783);


if((ex56783 instanceof Error)){
var statearr_56787_56797 = state_56776__$1;
(statearr_56787_56797[(1)] = (4));

(statearr_56787_56797[(5)] = null);

} else {
throw ex56783;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0 = (function (){
var statearr_56788 = [null,null,null,null,null,null,null,null];
(statearr_56788[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__);

(statearr_56788[(1)] = (1));

return statearr_56788;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1 = (function (state_56776){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56776);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56789){var ex__2730__auto__ = e56789;
var statearr_56790_56798 = state_56776;
(statearr_56790_56798[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56776[(4)]))){
var statearr_56791_56799 = state_56776;
(statearr_56791_56799[(1)] = cljs.core.first((state_56776[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56800 = state_56776;
state_56776 = G__56800;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = function(state_56776){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1.call(this,state_56776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56792 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56792[(6)] = c__2749__auto__);

return statearr_56792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56830){
var state_val_56831 = (state_56830[(1)]);
if((state_val_56831 === (7))){
var state_56830__$1 = state_56830;
var statearr_56832_56851 = state_56830__$1;
(statearr_56832_56851[(2)] = num);

(statearr_56832_56851[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56831 === (1))){
var state_56830__$1 = state_56830;
var statearr_56833_56852 = state_56830__$1;
(statearr_56833_56852[(2)] = null);

(statearr_56833_56852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56831 === (4))){
var inst_56801 = (state_56830[(2)]);
var state_56830__$1 = state_56830;
var statearr_56834_56853 = state_56830__$1;
(statearr_56834_56853[(2)] = inst_56801);

(statearr_56834_56853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56831 === (6))){
var state_56830__$1 = state_56830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56830__$1,(9),num);
} else {
if((state_val_56831 === (3))){
var inst_56828 = (state_56830[(2)]);
var state_56830__$1 = state_56830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56830__$1,inst_56828);
} else {
if((state_val_56831 === (2))){
var _ = (function (){var statearr_56836 = state_56830;
(statearr_56836[(4)] = cljs.core.cons((5),(state_56830[(4)])));

return statearr_56836;
})();
var inst_56807 = fluree.db.util.async.channel_QMARK_(num);
var state_56830__$1 = state_56830;
if(inst_56807){
var statearr_56837_56854 = state_56830__$1;
(statearr_56837_56854[(1)] = (6));

} else {
var statearr_56838_56855 = state_56830__$1;
(statearr_56838_56855[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56831 === (9))){
var inst_56810 = (state_56830[(2)]);
var inst_56811 = fluree.db.util.async.throw_err(inst_56810);
var state_56830__$1 = state_56830;
var statearr_56839_56856 = state_56830__$1;
(statearr_56839_56856[(2)] = inst_56811);

(statearr_56839_56856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56831 === (5))){
var _ = (function (){var statearr_56840 = state_56830;
(statearr_56840[(4)] = cljs.core.rest((state_56830[(4)])));

return statearr_56840;
})();
var state_56830__$1 = state_56830;
var ex56835 = (state_56830__$1[(2)]);
var statearr_56841_56857 = state_56830__$1;
(statearr_56841_56857[(5)] = ex56835);


if((ex56835 instanceof Error)){
var statearr_56842_56858 = state_56830__$1;
(statearr_56842_56858[(1)] = (4));

(statearr_56842_56858[(5)] = null);

} else {
throw ex56835;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56831 === (8))){
var inst_56814 = (state_56830[(2)]);
var inst_56815 = fluree.db.dbfunctions.internal.ceil(inst_56814);
var inst_56816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56817 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56819 = [fluree.db.dbfunctions.fns.ceil];
var inst_56820 = (new cljs.core.PersistentVector(null,1,(5),inst_56818,inst_56819,null));
var inst_56821 = ["",inst_56820,inst_56815];
var inst_56822 = cljs.core.PersistentHashMap.fromArrays(inst_56817,inst_56821);
var inst_56823 = [inst_56822,(10)];
var inst_56824 = (new cljs.core.PersistentVector(null,2,(5),inst_56816,inst_56823,null));
var inst_56825 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56824);
var _ = (function (){var statearr_56843 = state_56830;
(statearr_56843[(4)] = cljs.core.rest((state_56830[(4)])));

return statearr_56843;
})();
var state_56830__$1 = (function (){var statearr_56844 = state_56830;
(statearr_56844[(7)] = inst_56825);

return statearr_56844;
})();
var statearr_56845_56859 = state_56830__$1;
(statearr_56845_56859[(2)] = inst_56815);

(statearr_56845_56859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0 = (function (){
var statearr_56846 = [null,null,null,null,null,null,null,null];
(statearr_56846[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__);

(statearr_56846[(1)] = (1));

return statearr_56846;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1 = (function (state_56830){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56830);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56847){var ex__2730__auto__ = e56847;
var statearr_56848_56860 = state_56830;
(statearr_56848_56860[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56830[(4)]))){
var statearr_56849_56861 = state_56830;
(statearr_56849_56861[(1)] = cljs.core.first((state_56830[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56862 = state_56830;
state_56830 = G__56862;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = function(state_56830){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1.call(this,state_56830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56850 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56850[(6)] = c__2749__auto__);

return statearr_56850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56892){
var state_val_56893 = (state_56892[(1)]);
if((state_val_56893 === (7))){
var state_56892__$1 = state_56892;
var statearr_56894_56913 = state_56892__$1;
(statearr_56894_56913[(2)] = num);

(statearr_56894_56913[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56893 === (1))){
var state_56892__$1 = state_56892;
var statearr_56895_56914 = state_56892__$1;
(statearr_56895_56914[(2)] = null);

(statearr_56895_56914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56893 === (4))){
var inst_56863 = (state_56892[(2)]);
var state_56892__$1 = state_56892;
var statearr_56896_56915 = state_56892__$1;
(statearr_56896_56915[(2)] = inst_56863);

(statearr_56896_56915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56893 === (6))){
var state_56892__$1 = state_56892;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56892__$1,(9),num);
} else {
if((state_val_56893 === (3))){
var inst_56890 = (state_56892[(2)]);
var state_56892__$1 = state_56892;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56892__$1,inst_56890);
} else {
if((state_val_56893 === (2))){
var _ = (function (){var statearr_56898 = state_56892;
(statearr_56898[(4)] = cljs.core.cons((5),(state_56892[(4)])));

return statearr_56898;
})();
var inst_56869 = fluree.db.util.async.channel_QMARK_(num);
var state_56892__$1 = state_56892;
if(inst_56869){
var statearr_56899_56916 = state_56892__$1;
(statearr_56899_56916[(1)] = (6));

} else {
var statearr_56900_56917 = state_56892__$1;
(statearr_56900_56917[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56893 === (9))){
var inst_56872 = (state_56892[(2)]);
var inst_56873 = fluree.db.util.async.throw_err(inst_56872);
var state_56892__$1 = state_56892;
var statearr_56901_56918 = state_56892__$1;
(statearr_56901_56918[(2)] = inst_56873);

(statearr_56901_56918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56893 === (5))){
var _ = (function (){var statearr_56902 = state_56892;
(statearr_56902[(4)] = cljs.core.rest((state_56892[(4)])));

return statearr_56902;
})();
var state_56892__$1 = state_56892;
var ex56897 = (state_56892__$1[(2)]);
var statearr_56903_56919 = state_56892__$1;
(statearr_56903_56919[(5)] = ex56897);


if((ex56897 instanceof Error)){
var statearr_56904_56920 = state_56892__$1;
(statearr_56904_56920[(1)] = (4));

(statearr_56904_56920[(5)] = null);

} else {
throw ex56897;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56893 === (8))){
var inst_56876 = (state_56892[(2)]);
var inst_56877 = fluree.db.dbfunctions.internal.floor(inst_56876);
var inst_56878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56879 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56881 = [fluree.db.dbfunctions.fns.floor];
var inst_56882 = (new cljs.core.PersistentVector(null,1,(5),inst_56880,inst_56881,null));
var inst_56883 = ["",inst_56882,inst_56877];
var inst_56884 = cljs.core.PersistentHashMap.fromArrays(inst_56879,inst_56883);
var inst_56885 = [inst_56884,(10)];
var inst_56886 = (new cljs.core.PersistentVector(null,2,(5),inst_56878,inst_56885,null));
var inst_56887 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56886);
var _ = (function (){var statearr_56905 = state_56892;
(statearr_56905[(4)] = cljs.core.rest((state_56892[(4)])));

return statearr_56905;
})();
var state_56892__$1 = (function (){var statearr_56906 = state_56892;
(statearr_56906[(7)] = inst_56887);

return statearr_56906;
})();
var statearr_56907_56921 = state_56892__$1;
(statearr_56907_56921[(2)] = inst_56877);

(statearr_56907_56921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0 = (function (){
var statearr_56908 = [null,null,null,null,null,null,null,null];
(statearr_56908[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__);

(statearr_56908[(1)] = (1));

return statearr_56908;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1 = (function (state_56892){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56892);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56909){var ex__2730__auto__ = e56909;
var statearr_56910_56922 = state_56892;
(statearr_56910_56922[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56892[(4)]))){
var statearr_56911_56923 = state_56892;
(statearr_56911_56923[(1)] = cljs.core.first((state_56892[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56924 = state_56892;
state_56892 = G__56924;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = function(state_56892){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1.call(this,state_56892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56912 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56912[(6)] = c__2749__auto__);

return statearr_56912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56949){
var state_val_56950 = (state_56949[(1)]);
if((state_val_56950 === (1))){
var state_56949__$1 = state_56949;
var statearr_56951_56966 = state_56949__$1;
(statearr_56951_56966[(2)] = null);

(statearr_56951_56966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (2))){
var _ = (function (){var statearr_56952 = state_56949;
(statearr_56952[(4)] = cljs.core.cons((5),(state_56949[(4)])));

return statearr_56952;
})();
var inst_56931 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_56949__$1 = state_56949;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56949__$1,(6),inst_56931);
} else {
if((state_val_56950 === (3))){
var inst_56947 = (state_56949[(2)]);
var state_56949__$1 = state_56949;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56949__$1,inst_56947);
} else {
if((state_val_56950 === (4))){
var inst_56925 = (state_56949[(2)]);
var state_56949__$1 = state_56949;
var statearr_56954_56967 = state_56949__$1;
(statearr_56954_56967[(2)] = inst_56925);

(statearr_56954_56967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (5))){
var _ = (function (){var statearr_56955 = state_56949;
(statearr_56955[(4)] = cljs.core.rest((state_56949[(4)])));

return statearr_56955;
})();
var state_56949__$1 = state_56949;
var ex56953 = (state_56949__$1[(2)]);
var statearr_56956_56968 = state_56949__$1;
(statearr_56956_56968[(5)] = ex56953);


if((ex56953 instanceof Error)){
var statearr_56957_56969 = state_56949__$1;
(statearr_56957_56969[(1)] = (4));

(statearr_56957_56969[(5)] = null);

} else {
throw ex56953;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56950 === (6))){
var inst_56933 = (state_56949[(2)]);
var inst_56934 = fluree.db.util.async.throw_err(inst_56933);
var inst_56935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56936 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56938 = [compare_val,new_val];
var inst_56939 = (new cljs.core.PersistentVector(null,2,(5),inst_56937,inst_56938,null));
var inst_56940 = ["",inst_56939,inst_56934];
var inst_56941 = cljs.core.PersistentHashMap.fromArrays(inst_56936,inst_56940);
var inst_56942 = [inst_56941,(10)];
var inst_56943 = (new cljs.core.PersistentVector(null,2,(5),inst_56935,inst_56942,null));
var inst_56944 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56943);
var _ = (function (){var statearr_56958 = state_56949;
(statearr_56958[(4)] = cljs.core.rest((state_56949[(4)])));

return statearr_56958;
})();
var state_56949__$1 = (function (){var statearr_56959 = state_56949;
(statearr_56959[(7)] = inst_56944);

return statearr_56959;
})();
var statearr_56960_56970 = state_56949__$1;
(statearr_56960_56970[(2)] = inst_56934);

(statearr_56960_56970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_56961 = [null,null,null,null,null,null,null,null];
(statearr_56961[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__);

(statearr_56961[(1)] = (1));

return statearr_56961;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1 = (function (state_56949){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56949);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56962){var ex__2730__auto__ = e56962;
var statearr_56963_56971 = state_56949;
(statearr_56963_56971[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56949[(4)]))){
var statearr_56964_56972 = state_56949;
(statearr_56964_56972[(1)] = cljs.core.first((state_56949[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56973 = state_56949;
state_56949 = G__56973;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = function(state_56949){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1.call(this,state_56949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56965 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56965[(6)] = c__2749__auto__);

return statearr_56965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
