// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__63114 = arguments.length;
switch (G__63114) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___63153 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63135){
var state_val_63136 = (state_63135[(1)]);
if((state_val_63136 === (1))){
var state_63135__$1 = state_63135;
var statearr_63137_63154 = state_63135__$1;
(statearr_63137_63154[(2)] = null);

(statearr_63137_63154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63136 === (2))){
var _ = (function (){var statearr_63138 = state_63135;
(statearr_63138[(4)] = cljs.core.cons((5),(state_63135[(4)])));

return statearr_63138;
})();
var inst_63121 = fluree.db.session.db(conn,ledger,null);
var state_63135__$1 = state_63135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63135__$1,(7),inst_63121);
} else {
if((state_val_63136 === (3))){
var inst_63131 = (state_63135[(2)]);
var inst_63132 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63131);
var inst_63133 = cljs.core.async.close_BANG_(pc);
var state_63135__$1 = (function (){var statearr_63140 = state_63135;
(statearr_63140[(7)] = inst_63132);

return statearr_63140;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63135__$1,inst_63133);
} else {
if((state_val_63136 === (4))){
var inst_63115 = (state_63135[(2)]);
var state_63135__$1 = state_63135;
var statearr_63141_63155 = state_63135__$1;
(statearr_63141_63155[(2)] = inst_63115);

(statearr_63141_63155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63136 === (5))){
var _ = (function (){var statearr_63142 = state_63135;
(statearr_63142[(4)] = cljs.core.rest((state_63135[(4)])));

return statearr_63142;
})();
var state_63135__$1 = state_63135;
var ex63139 = (state_63135__$1[(2)]);
var statearr_63143_63156 = state_63135__$1;
(statearr_63143_63156[(5)] = ex63139);


var statearr_63144_63157 = state_63135__$1;
(statearr_63144_63157[(1)] = (4));

(statearr_63144_63157[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63136 === (6))){
var inst_63127 = (state_63135[(2)]);
var inst_63128 = fluree.db.util.async.throw_err(inst_63127);
var _ = (function (){var statearr_63145 = state_63135;
(statearr_63145[(4)] = cljs.core.rest((state_63135[(4)])));

return statearr_63145;
})();
var state_63135__$1 = state_63135;
var statearr_63146_63158 = state_63135__$1;
(statearr_63146_63158[(2)] = inst_63128);

(statearr_63146_63158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63136 === (7))){
var inst_63123 = (state_63135[(2)]);
var inst_63124 = fluree.db.util.async.throw_err(inst_63123);
var inst_63125 = fluree.db.time_travel.as_of_block(inst_63124,block);
var state_63135__$1 = state_63135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63135__$1,(6),inst_63125);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_63147 = [null,null,null,null,null,null,null,null];
(statearr_63147[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_63147[(1)] = (1));

return statearr_63147;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_63135){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63135);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63148){var ex__2730__auto__ = e63148;
var statearr_63149_63159 = state_63135;
(statearr_63149_63159[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63135[(4)]))){
var statearr_63150_63160 = state_63135;
(statearr_63150_63160[(1)] = cljs.core.first((state_63135[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63161 = state_63135;
state_63135 = G__63161;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_63135){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_63135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63151 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63151[(6)] = c__2749__auto___63153);

return statearr_63151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63202){
var state_val_63203 = (state_63202[(1)]);
if((state_val_63203 === (7))){
var inst_63171 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_63202__$1 = state_63202;
if(inst_63171){
var statearr_63204_63235 = state_63202__$1;
(statearr_63204_63235[(1)] = (9));

} else {
var statearr_63205_63236 = state_63202__$1;
(statearr_63205_63236[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (1))){
var state_63202__$1 = state_63202;
var statearr_63206_63237 = state_63202__$1;
(statearr_63206_63237[(2)] = null);

(statearr_63206_63237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (4))){
var inst_63162 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63207_63238 = state_63202__$1;
(statearr_63207_63238[(2)] = inst_63162);

(statearr_63207_63238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (15))){
var inst_63179 = (state_63202[(7)]);
var inst_63178 = (state_63202[(2)]);
var inst_63179__$1 = fluree.db.util.async.throw_err(inst_63178);
var state_63202__$1 = (function (){var statearr_63208 = state_63202;
(statearr_63208[(7)] = inst_63179__$1);

return statearr_63208;
})();
if(cljs.core.truth_(inst_63179__$1)){
var statearr_63209_63239 = state_63202__$1;
(statearr_63209_63239[(1)] = (16));

} else {
var statearr_63210_63240 = state_63202__$1;
(statearr_63210_63240[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (13))){
var state_63202__$1 = state_63202;
var statearr_63211_63241 = state_63202__$1;
(statearr_63211_63241[(2)] = null);

(statearr_63211_63241[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (6))){
var state_63202__$1 = state_63202;
var statearr_63212_63242 = state_63202__$1;
(statearr_63212_63242[(2)] = db);

(statearr_63212_63242[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (17))){
var inst_63183 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_63184 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63185 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_63186 = cljs.core.PersistentHashMap.fromArrays(inst_63184,inst_63185);
var inst_63187 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63183,inst_63186);
var inst_63188 = (function(){throw inst_63187})();
var state_63202__$1 = state_63202;
var statearr_63213_63243 = state_63202__$1;
(statearr_63213_63243[(2)] = inst_63188);

(statearr_63213_63243[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (3))){
var inst_63200 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63202__$1,inst_63200);
} else {
if((state_val_63203 === (12))){
var inst_63176 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_63202__$1 = state_63202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63202__$1,(15),inst_63176);
} else {
if((state_val_63203 === (2))){
var _ = (function (){var statearr_63214 = state_63202;
(statearr_63214[(4)] = cljs.core.cons((5),(state_63202[(4)])));

return statearr_63214;
})();
var inst_63168 = cljs.core.not(auth);
var state_63202__$1 = state_63202;
if(inst_63168){
var statearr_63215_63244 = state_63202__$1;
(statearr_63215_63244[(1)] = (6));

} else {
var statearr_63216_63245 = state_63202__$1;
(statearr_63216_63245[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (11))){
var inst_63195 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63218_63246 = state_63202__$1;
(statearr_63218_63246[(2)] = inst_63195);

(statearr_63218_63246[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (9))){
var inst_63173 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_63202__$1 = state_63202;
var statearr_63219_63247 = state_63202__$1;
(statearr_63219_63247[(2)] = inst_63173);

(statearr_63219_63247[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (5))){
var _ = (function (){var statearr_63220 = state_63202;
(statearr_63220[(4)] = cljs.core.rest((state_63202[(4)])));

return statearr_63220;
})();
var state_63202__$1 = state_63202;
var ex63217 = (state_63202__$1[(2)]);
var statearr_63221_63248 = state_63202__$1;
(statearr_63221_63248[(5)] = ex63217);


if((ex63217 instanceof Error)){
var statearr_63222_63249 = state_63202__$1;
(statearr_63222_63249[(1)] = (4));

(statearr_63222_63249[(5)] = null);

} else {
throw ex63217;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (14))){
var inst_63193 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63223_63250 = state_63202__$1;
(statearr_63223_63250[(2)] = inst_63193);

(statearr_63223_63250[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (16))){
var inst_63179 = (state_63202[(7)]);
var inst_63181 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_63179);
var state_63202__$1 = state_63202;
var statearr_63224_63251 = state_63202__$1;
(statearr_63224_63251[(2)] = inst_63181);

(statearr_63224_63251[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (10))){
var state_63202__$1 = state_63202;
var statearr_63225_63252 = state_63202__$1;
(statearr_63225_63252[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (18))){
var inst_63190 = (state_63202[(2)]);
var state_63202__$1 = state_63202;
var statearr_63227_63253 = state_63202__$1;
(statearr_63227_63253[(2)] = inst_63190);

(statearr_63227_63253[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63203 === (8))){
var inst_63197 = (state_63202[(2)]);
var _ = (function (){var statearr_63228 = state_63202;
(statearr_63228[(4)] = cljs.core.rest((state_63202[(4)])));

return statearr_63228;
})();
var state_63202__$1 = state_63202;
var statearr_63229_63254 = state_63202__$1;
(statearr_63229_63254[(2)] = inst_63197);

(statearr_63229_63254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_63230 = [null,null,null,null,null,null,null,null];
(statearr_63230[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_63230[(1)] = (1));

return statearr_63230;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_63202){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63202);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63231){var ex__2730__auto__ = e63231;
var statearr_63232_63255 = state_63202;
(statearr_63232_63255[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63202[(4)]))){
var statearr_63233_63256 = state_63202;
(statearr_63233_63256[(1)] = cljs.core.first((state_63202[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63257 = state_63202;
state_63202 = G__63257;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_63202){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_63202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63234 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63234[(6)] = c__2749__auto__);

return statearr_63234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63321){
var state_val_63322 = (state_63321[(1)]);
if((state_val_63322 === (7))){
var inst_63267 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_63321__$1 = state_63321;
if(inst_63267){
var statearr_63323_63372 = state_63321__$1;
(statearr_63323_63372[(1)] = (9));

} else {
var statearr_63324_63373 = state_63321__$1;
(statearr_63324_63373[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (20))){
var inst_63291 = (state_63321[(7)]);
var state_63321__$1 = state_63321;
if(cljs.core.truth_(inst_63291)){
var statearr_63325_63374 = state_63321__$1;
(statearr_63325_63374[(1)] = (22));

} else {
var statearr_63326_63375 = state_63321__$1;
(statearr_63326_63375[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (27))){
var state_63321__$1 = state_63321;
var statearr_63327_63376 = state_63321__$1;
(statearr_63327_63376[(2)] = null);

(statearr_63327_63376[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (1))){
var state_63321__$1 = state_63321;
var statearr_63328_63377 = state_63321__$1;
(statearr_63328_63377[(2)] = null);

(statearr_63328_63377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (24))){
var inst_63305 = (state_63321[(2)]);
var state_63321__$1 = state_63321;
var statearr_63329_63378 = state_63321__$1;
(statearr_63329_63378[(2)] = inst_63305);

(statearr_63329_63378[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (4))){
var inst_63258 = (state_63321[(2)]);
var state_63321__$1 = state_63321;
var statearr_63330_63379 = state_63321__$1;
(statearr_63330_63379[(2)] = inst_63258);

(statearr_63330_63379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (15))){
var inst_63274 = (state_63321[(8)]);
var inst_63273 = (state_63321[(2)]);
var inst_63274__$1 = fluree.db.util.async.throw_err(inst_63273);
var state_63321__$1 = (function (){var statearr_63331 = state_63321;
(statearr_63331[(8)] = inst_63274__$1);

return statearr_63331;
})();
if(cljs.core.truth_(inst_63274__$1)){
var statearr_63332_63380 = state_63321__$1;
(statearr_63332_63380[(1)] = (16));

} else {
var statearr_63333_63381 = state_63321__$1;
(statearr_63333_63381[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (21))){
var inst_63307 = (state_63321[(9)]);
var inst_63307__$1 = (state_63321[(2)]);
var state_63321__$1 = (function (){var statearr_63334 = state_63321;
(statearr_63334[(9)] = inst_63307__$1);

return statearr_63334;
})();
if(cljs.core.truth_(inst_63307__$1)){
var statearr_63335_63382 = state_63321__$1;
(statearr_63335_63382[(1)] = (29));

} else {
var statearr_63336_63383 = state_63321__$1;
(statearr_63336_63383[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (31))){
var inst_63307 = (state_63321[(9)]);
var inst_63291 = (state_63321[(7)]);
var inst_63315 = (state_63321[(2)]);
var inst_63316 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_63291,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_63307,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_63315], 0));
var _ = (function (){var statearr_63337 = state_63321;
(statearr_63337[(4)] = cljs.core.rest((state_63321[(4)])));

return statearr_63337;
})();
var state_63321__$1 = state_63321;
var statearr_63338_63384 = state_63321__$1;
(statearr_63338_63384[(2)] = inst_63316);

(statearr_63338_63384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (32))){
var inst_63311 = (state_63321[(2)]);
var inst_63312 = fluree.db.util.async.throw_err(inst_63311);
var state_63321__$1 = state_63321;
var statearr_63339_63385 = state_63321__$1;
(statearr_63339_63385[(2)] = inst_63312);

(statearr_63339_63385[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (13))){
var state_63321__$1 = state_63321;
var statearr_63340_63386 = state_63321__$1;
(statearr_63340_63386[(2)] = null);

(statearr_63340_63386[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (22))){
var inst_63291 = (state_63321[(7)]);
var inst_63295 = fluree.db.auth.roles(db,inst_63291);
var state_63321__$1 = state_63321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63321__$1,(25),inst_63295);
} else {
if((state_val_63322 === (29))){
var inst_63307 = (state_63321[(9)]);
var inst_63309 = fluree.db.permissions.permission_map(db,inst_63307,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_63321__$1 = state_63321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63321__$1,(32),inst_63309);
} else {
if((state_val_63322 === (6))){
var state_63321__$1 = state_63321;
var statearr_63341_63387 = state_63321__$1;
(statearr_63341_63387[(2)] = null);

(statearr_63341_63387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (28))){
var inst_63303 = (state_63321[(2)]);
var state_63321__$1 = state_63321;
var statearr_63342_63388 = state_63321__$1;
(statearr_63342_63388[(2)] = inst_63303);

(statearr_63342_63388[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (25))){
var inst_63297 = (state_63321[(2)]);
var inst_63298 = fluree.db.util.async.throw_err(inst_63297);
var state_63321__$1 = state_63321;
var statearr_63343_63389 = state_63321__$1;
(statearr_63343_63389[(2)] = inst_63298);

(statearr_63343_63389[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (17))){
var inst_63277 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_63278 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63279 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_63280 = cljs.core.PersistentHashMap.fromArrays(inst_63278,inst_63279);
var inst_63281 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63277,inst_63280);
var inst_63282 = (function(){throw inst_63281})();
var state_63321__$1 = state_63321;
var statearr_63344_63390 = state_63321__$1;
(statearr_63344_63390[(2)] = inst_63282);

(statearr_63344_63390[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (3))){
var inst_63319 = (state_63321[(2)]);
var state_63321__$1 = state_63321;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63321__$1,inst_63319);
} else {
if((state_val_63322 === (12))){
var inst_63271 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_63321__$1 = state_63321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63321__$1,(15),inst_63271);
} else {
if((state_val_63322 === (2))){
var _ = (function (){var statearr_63345 = state_63321;
(statearr_63345[(4)] = cljs.core.cons((5),(state_63321[(4)])));

return statearr_63345;
})();
var inst_63264 = (auth == null);
var state_63321__$1 = state_63321;
if(cljs.core.truth_(inst_63264)){
var statearr_63346_63391 = state_63321__$1;
(statearr_63346_63391[(1)] = (6));

} else {
var statearr_63347_63392 = state_63321__$1;
(statearr_63347_63392[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (23))){
var state_63321__$1 = state_63321;
var statearr_63348_63393 = state_63321__$1;
(statearr_63348_63393[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (19))){
var state_63321__$1 = state_63321;
var statearr_63350_63394 = state_63321__$1;
(statearr_63350_63394[(2)] = roles);

(statearr_63350_63394[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (11))){
var inst_63289 = (state_63321[(2)]);
var state_63321__$1 = state_63321;
var statearr_63352_63395 = state_63321__$1;
(statearr_63352_63395[(2)] = inst_63289);

(statearr_63352_63395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (9))){
var state_63321__$1 = state_63321;
var statearr_63353_63396 = state_63321__$1;
(statearr_63353_63396[(2)] = (0));

(statearr_63353_63396[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (5))){
var _ = (function (){var statearr_63354 = state_63321;
(statearr_63354[(4)] = cljs.core.rest((state_63321[(4)])));

return statearr_63354;
})();
var state_63321__$1 = state_63321;
var ex63351 = (state_63321__$1[(2)]);
var statearr_63355_63397 = state_63321__$1;
(statearr_63355_63397[(5)] = ex63351);


if((ex63351 instanceof Error)){
var statearr_63356_63398 = state_63321__$1;
(statearr_63356_63398[(1)] = (4));

(statearr_63356_63398[(5)] = null);

} else {
throw ex63351;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (14))){
var inst_63287 = (state_63321[(2)]);
var state_63321__$1 = state_63321;
var statearr_63357_63399 = state_63321__$1;
(statearr_63357_63399[(2)] = inst_63287);

(statearr_63357_63399[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (26))){
var state_63321__$1 = state_63321;
var statearr_63358_63400 = state_63321__$1;
(statearr_63358_63400[(2)] = null);

(statearr_63358_63400[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (16))){
var inst_63274 = (state_63321[(8)]);
var state_63321__$1 = state_63321;
var statearr_63359_63401 = state_63321__$1;
(statearr_63359_63401[(2)] = inst_63274);

(statearr_63359_63401[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (30))){
var state_63321__$1 = state_63321;
var statearr_63360_63402 = state_63321__$1;
(statearr_63360_63402[(2)] = null);

(statearr_63360_63402[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (10))){
var state_63321__$1 = state_63321;
if(cljs.core.truth_(auth)){
var statearr_63361_63403 = state_63321__$1;
(statearr_63361_63403[(1)] = (12));

} else {
var statearr_63362_63404 = state_63321__$1;
(statearr_63362_63404[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (18))){
var inst_63284 = (state_63321[(2)]);
var state_63321__$1 = state_63321;
var statearr_63363_63405 = state_63321__$1;
(statearr_63363_63405[(2)] = inst_63284);

(statearr_63363_63405[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63322 === (8))){
var inst_63291 = (state_63321[(2)]);
var state_63321__$1 = (function (){var statearr_63364 = state_63321;
(statearr_63364[(7)] = inst_63291);

return statearr_63364;
})();
if(cljs.core.truth_(roles)){
var statearr_63365_63406 = state_63321__$1;
(statearr_63365_63406[(1)] = (19));

} else {
var statearr_63366_63407 = state_63321__$1;
(statearr_63366_63407[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_63367 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63367[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_63367[(1)] = (1));

return statearr_63367;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_63321){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63321);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63368){var ex__2730__auto__ = e63368;
var statearr_63369_63408 = state_63321;
(statearr_63369_63408[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63321[(4)]))){
var statearr_63370_63409 = state_63321;
(statearr_63370_63409[(1)] = cljs.core.first((state_63321[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63410 = state_63321;
state_63321 = G__63410;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_63321){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_63321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63371 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63371[(6)] = c__2749__auto__);

return statearr_63371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__63411 = db;
var map__63411__$1 = cljs.core.__destructure_map(map__63411);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63411__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63411__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63411__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63418){
var state_val_63419 = (state_63418[(1)]);
if((state_val_63419 === (1))){
var inst_63412 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_63413 = fluree.db.session.db(conn,inst_63412,null);
var state_63418__$1 = state_63418;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63418__$1,(2),inst_63413);
} else {
if((state_val_63419 === (2))){
var inst_63415 = (state_63418[(2)]);
var inst_63416 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_63415);
var state_63418__$1 = state_63418;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63418__$1,inst_63416);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_63420 = [null,null,null,null,null,null,null];
(statearr_63420[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_63420[(1)] = (1));

return statearr_63420;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_63418){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63418);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63421){var ex__2730__auto__ = e63421;
var statearr_63422_63449 = state_63418;
(statearr_63422_63449[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63418[(4)]))){
var statearr_63423_63450 = state_63418;
(statearr_63423_63450[(1)] = cljs.core.first((state_63418[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63451 = state_63418;
state_63418 = G__63451;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_63418){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_63418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63424 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63424[(6)] = c__2749__auto__);

return statearr_63424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63437){
var state_val_63438 = (state_63437[(1)]);
if((state_val_63438 === (1))){
var inst_63425 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_63426 = fluree.db.session.db(conn,inst_63425,null);
var state_63437__$1 = state_63437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63437__$1,(2),inst_63426);
} else {
if((state_val_63438 === (2))){
var inst_63428 = (state_63437[(7)]);
var inst_63428__$1 = (state_63437[(2)]);
var inst_63429 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_63428__$1);
var inst_63430 = newer_block_QMARK_(inst_63429);
var state_63437__$1 = (function (){var statearr_63439 = state_63437;
(statearr_63439[(7)] = inst_63428__$1);

return statearr_63439;
})();
if(inst_63430){
var statearr_63440_63452 = state_63437__$1;
(statearr_63440_63452[(1)] = (3));

} else {
var statearr_63441_63453 = state_63437__$1;
(statearr_63441_63453[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63438 === (3))){
var inst_63428 = (state_63437[(7)]);
var inst_63432 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_63428);
var state_63437__$1 = state_63437;
var statearr_63442_63454 = state_63437__$1;
(statearr_63442_63454[(2)] = inst_63432);

(statearr_63442_63454[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63438 === (4))){
var state_63437__$1 = state_63437;
var statearr_63443_63455 = state_63437__$1;
(statearr_63443_63455[(2)] = null);

(statearr_63443_63455[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63438 === (5))){
var inst_63435 = (state_63437[(2)]);
var state_63437__$1 = state_63437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63437__$1,inst_63435);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_63444 = [null,null,null,null,null,null,null,null];
(statearr_63444[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_63444[(1)] = (1));

return statearr_63444;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_63437){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63437);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63445){var ex__2730__auto__ = e63445;
var statearr_63446_63456 = state_63437;
(statearr_63446_63456[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63437[(4)]))){
var statearr_63447_63457 = state_63437;
(statearr_63447_63457[(1)] = cljs.core.first((state_63437[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63458 = state_63437;
state_63437 = G__63458;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_63437){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_63437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63448 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63448[(6)] = c__2749__auto__);

return statearr_63448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__63459 = db;
var map__63459__$1 = cljs.core.__destructure_map(map__63459);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63459__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63459__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63459__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___63535 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63509){
var state_val_63510 = (state_63509[(1)]);
if((state_val_63510 === (7))){
var inst_63475 = (state_63509[(7)]);
var inst_63486 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63475,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_63509__$1 = state_63509;
if(inst_63486){
var statearr_63511_63536 = state_63509__$1;
(statearr_63511_63536[(1)] = (9));

} else {
var statearr_63512_63537 = state_63509__$1;
(statearr_63512_63537[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (1))){
var inst_63460 = (state_63509[(8)]);
var inst_63468 = (state_63509[(9)]);
var inst_63460__$1 = cljs.core.async.timeout(timeout);
var inst_63468__$1 = res_port;
var inst_63469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63470 = [inst_63460__$1,inst_63468__$1];
var inst_63471 = (new cljs.core.PersistentVector(null,2,(5),inst_63469,inst_63470,null));
var state_63509__$1 = (function (){var statearr_63513 = state_63509;
(statearr_63513[(8)] = inst_63460__$1);

(statearr_63513[(9)] = inst_63468__$1);

return statearr_63513;
})();
return cljs.core.async.ioc_alts_BANG_(state_63509__$1,(2),inst_63471);
} else {
if((state_val_63510 === (4))){
var inst_63468 = (state_63509[(9)]);
var inst_63475 = (state_63509[(7)]);
var inst_63479 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63475,inst_63468);
var state_63509__$1 = state_63509;
if(inst_63479){
var statearr_63514_63538 = state_63509__$1;
(statearr_63514_63538[(1)] = (6));

} else {
var statearr_63515_63539 = state_63509__$1;
(statearr_63515_63539[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (13))){
var inst_63494 = (state_63509[(10)]);
var inst_63505 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63494);
var state_63509__$1 = state_63509;
var statearr_63516_63540 = state_63509__$1;
(statearr_63516_63540[(2)] = inst_63505);

(statearr_63516_63540[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (6))){
var inst_63473 = (state_63509[(11)]);
var inst_63484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63473,(0),null);
var state_63509__$1 = state_63509;
var statearr_63517_63541 = state_63509__$1;
(statearr_63517_63541[(2)] = inst_63484);

(statearr_63517_63541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (3))){
var state_63509__$1 = state_63509;
var statearr_63518_63542 = state_63509__$1;
(statearr_63518_63542[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_63518_63542[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (12))){
var inst_63498 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_63499 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63500 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_63501 = cljs.core.PersistentHashMap.fromArrays(inst_63499,inst_63500);
var inst_63502 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63498,inst_63501);
var inst_63503 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63502);
var state_63509__$1 = state_63509;
var statearr_63519_63543 = state_63509__$1;
(statearr_63519_63543[(2)] = inst_63503);

(statearr_63519_63543[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (2))){
var inst_63460 = (state_63509[(8)]);
var inst_63475 = (state_63509[(7)]);
var inst_63473 = (state_63509[(11)]);
var inst_63473__$1 = (state_63509[(2)]);
var inst_63474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63473__$1,(0),null);
var inst_63475__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63473__$1,(1),null);
var inst_63476 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63475__$1,inst_63460);
var state_63509__$1 = (function (){var statearr_63520 = state_63509;
(statearr_63520[(7)] = inst_63475__$1);

(statearr_63520[(11)] = inst_63473__$1);

(statearr_63520[(12)] = inst_63474);

return statearr_63520;
})();
if(inst_63476){
var statearr_63521_63544 = state_63509__$1;
(statearr_63521_63544[(1)] = (3));

} else {
var statearr_63522_63545 = state_63509__$1;
(statearr_63522_63545[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (11))){
var inst_63490 = (state_63509[(2)]);
var state_63509__$1 = state_63509;
var statearr_63523_63546 = state_63509__$1;
(statearr_63523_63546[(2)] = inst_63490);

(statearr_63523_63546[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (9))){
var inst_63474 = (state_63509[(12)]);
var state_63509__$1 = state_63509;
var statearr_63524_63547 = state_63509__$1;
(statearr_63524_63547[(2)] = inst_63474);

(statearr_63524_63547[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (5))){
var inst_63494 = (state_63509[(10)]);
var inst_63494__$1 = (state_63509[(2)]);
var inst_63495 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_63496 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_63494__$1);
var state_63509__$1 = (function (){var statearr_63525 = state_63509;
(statearr_63525[(13)] = inst_63495);

(statearr_63525[(10)] = inst_63494__$1);

return statearr_63525;
})();
if(inst_63496){
var statearr_63526_63548 = state_63509__$1;
(statearr_63526_63548[(1)] = (12));

} else {
var statearr_63527_63549 = state_63509__$1;
(statearr_63527_63549[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (14))){
var inst_63507 = (state_63509[(2)]);
var state_63509__$1 = state_63509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63509__$1,inst_63507);
} else {
if((state_val_63510 === (10))){
var state_63509__$1 = state_63509;
var statearr_63528_63550 = state_63509__$1;
(statearr_63528_63550[(2)] = null);

(statearr_63528_63550[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63510 === (8))){
var inst_63492 = (state_63509[(2)]);
var state_63509__$1 = state_63509;
var statearr_63529_63551 = state_63509__$1;
(statearr_63529_63551[(2)] = inst_63492);

(statearr_63529_63551[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_63530 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63530[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_63530[(1)] = (1));

return statearr_63530;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_63509){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63509);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63531){var ex__2730__auto__ = e63531;
var statearr_63532_63552 = state_63509;
(statearr_63532_63552[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63509[(4)]))){
var statearr_63533_63553 = state_63509;
(statearr_63533_63553[(1)] = cljs.core.first((state_63509[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63554 = state_63509;
state_63509 = G__63554;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_63509){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_63509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63534 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63534[(6)] = c__2749__auto___63535);

return statearr_63534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__63556 = arguments.length;
switch (G__63556) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__63557){
var map__63558 = p__63557;
var map__63558__$1 = cljs.core.__destructure_map(map__63558);
var opts = map__63558__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63558__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63558__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63558__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63558__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63558__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___63647 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63609){
var state_val_63610 = (state_63609[(1)]);
if((state_val_63610 === (7))){
var inst_63571 = (state_63609[(7)]);
var inst_63573 = fluree.db.api.ledger.syncTo_db(inst_63571,syncTo,syncTimeout);
var state_63609__$1 = state_63609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63609__$1,(10),inst_63573);
} else {
if((state_val_63610 === (20))){
var inst_63595 = (state_63609[(8)]);
var state_63609__$1 = state_63609;
var statearr_63611_63648 = state_63609__$1;
(statearr_63611_63648[(2)] = inst_63595);

(statearr_63611_63648[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (1))){
var state_63609__$1 = state_63609;
var statearr_63612_63649 = state_63609__$1;
(statearr_63612_63649[(2)] = null);

(statearr_63612_63649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (4))){
var inst_63559 = (state_63609[(2)]);
var inst_63560 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63559);
var inst_63561 = cljs.core.async.close_BANG_(pc);
var state_63609__$1 = (function (){var statearr_63613 = state_63609;
(statearr_63613[(9)] = inst_63560);

return statearr_63613;
})();
var statearr_63614_63650 = state_63609__$1;
(statearr_63614_63650[(2)] = inst_63561);

(statearr_63614_63650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (15))){
var inst_63587 = (state_63609[(10)]);
var inst_63589 = fluree.db.api.ledger.add_db_permissions(inst_63587,auth,roles);
var state_63609__$1 = state_63609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63609__$1,(18),inst_63589);
} else {
if((state_val_63610 === (21))){
var inst_63603 = (state_63609[(2)]);
var inst_63604 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63603);
var _ = (function (){var statearr_63615 = state_63609;
(statearr_63615[(4)] = cljs.core.rest((state_63609[(4)])));

return statearr_63615;
})();
var state_63609__$1 = state_63609;
var statearr_63616_63651 = state_63609__$1;
(statearr_63616_63651[(2)] = inst_63604);

(statearr_63616_63651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (13))){
var inst_63587 = (state_63609[(2)]);
var state_63609__$1 = (function (){var statearr_63617 = state_63609;
(statearr_63617[(10)] = inst_63587);

return statearr_63617;
})();
if(cljs.core.truth_(roles)){
var statearr_63618_63652 = state_63609__$1;
(statearr_63618_63652[(1)] = (15));

} else {
var statearr_63619_63653 = state_63609__$1;
(statearr_63619_63653[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (22))){
var inst_63599 = (state_63609[(2)]);
var inst_63600 = fluree.db.util.async.throw_err(inst_63599);
var state_63609__$1 = state_63609;
var statearr_63620_63654 = state_63609__$1;
(statearr_63620_63654[(2)] = inst_63600);

(statearr_63620_63654[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (6))){
var inst_63570 = (state_63609[(2)]);
var inst_63571 = fluree.db.util.async.throw_err(inst_63570);
var state_63609__$1 = (function (){var statearr_63621 = state_63609;
(statearr_63621[(7)] = inst_63571);

return statearr_63621;
})();
if(cljs.core.truth_(syncTo)){
var statearr_63622_63655 = state_63609__$1;
(statearr_63622_63655[(1)] = (7));

} else {
var statearr_63623_63656 = state_63609__$1;
(statearr_63623_63656[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (17))){
var inst_63595 = (state_63609[(2)]);
var state_63609__$1 = (function (){var statearr_63624 = state_63609;
(statearr_63624[(8)] = inst_63595);

return statearr_63624;
})();
if(cljs.core.truth_(auth)){
var statearr_63625_63657 = state_63609__$1;
(statearr_63625_63657[(1)] = (19));

} else {
var statearr_63626_63658 = state_63609__$1;
(statearr_63626_63658[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (3))){
var inst_63607 = (state_63609[(2)]);
var state_63609__$1 = state_63609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63609__$1,inst_63607);
} else {
if((state_val_63610 === (12))){
var inst_63579 = (state_63609[(11)]);
var state_63609__$1 = state_63609;
var statearr_63627_63659 = state_63609__$1;
(statearr_63627_63659[(2)] = inst_63579);

(statearr_63627_63659[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (2))){
var _ = (function (){var statearr_63628 = state_63609;
(statearr_63628[(4)] = cljs.core.cons((5),(state_63609[(4)])));

return statearr_63628;
})();
var inst_63568 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_63609__$1 = state_63609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63609__$1,(6),inst_63568);
} else {
if((state_val_63610 === (19))){
var inst_63595 = (state_63609[(8)]);
var inst_63597 = fluree.db.api.ledger.add_db_permissions(inst_63595,auth,roles);
var state_63609__$1 = state_63609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63609__$1,(22),inst_63597);
} else {
if((state_val_63610 === (11))){
var inst_63579 = (state_63609[(11)]);
var inst_63581 = fluree.db.time_travel.as_of_block(inst_63579,block);
var state_63609__$1 = state_63609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63609__$1,(14),inst_63581);
} else {
if((state_val_63610 === (9))){
var inst_63579 = (state_63609[(2)]);
var state_63609__$1 = (function (){var statearr_63630 = state_63609;
(statearr_63630[(11)] = inst_63579);

return statearr_63630;
})();
if(cljs.core.truth_(block)){
var statearr_63631_63660 = state_63609__$1;
(statearr_63631_63660[(1)] = (11));

} else {
var statearr_63632_63661 = state_63609__$1;
(statearr_63632_63661[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (5))){
var _ = (function (){var statearr_63633 = state_63609;
(statearr_63633[(4)] = cljs.core.rest((state_63609[(4)])));

return statearr_63633;
})();
var state_63609__$1 = state_63609;
var ex63629 = (state_63609__$1[(2)]);
var statearr_63634_63662 = state_63609__$1;
(statearr_63634_63662[(5)] = ex63629);


var statearr_63635_63663 = state_63609__$1;
(statearr_63635_63663[(1)] = (4));

(statearr_63635_63663[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (14))){
var inst_63583 = (state_63609[(2)]);
var inst_63584 = fluree.db.util.async.throw_err(inst_63583);
var state_63609__$1 = state_63609;
var statearr_63636_63664 = state_63609__$1;
(statearr_63636_63664[(2)] = inst_63584);

(statearr_63636_63664[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (16))){
var inst_63587 = (state_63609[(10)]);
var state_63609__$1 = state_63609;
var statearr_63637_63665 = state_63609__$1;
(statearr_63637_63665[(2)] = inst_63587);

(statearr_63637_63665[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (10))){
var inst_63575 = (state_63609[(2)]);
var inst_63576 = fluree.db.util.async.throw_err(inst_63575);
var state_63609__$1 = state_63609;
var statearr_63638_63666 = state_63609__$1;
(statearr_63638_63666[(2)] = inst_63576);

(statearr_63638_63666[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (18))){
var inst_63591 = (state_63609[(2)]);
var inst_63592 = fluree.db.util.async.throw_err(inst_63591);
var state_63609__$1 = state_63609;
var statearr_63639_63667 = state_63609__$1;
(statearr_63639_63667[(2)] = inst_63592);

(statearr_63639_63667[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63610 === (8))){
var inst_63571 = (state_63609[(7)]);
var state_63609__$1 = state_63609;
var statearr_63640_63668 = state_63609__$1;
(statearr_63640_63668[(2)] = inst_63571);

(statearr_63640_63668[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_63641 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63641[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_63641[(1)] = (1));

return statearr_63641;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_63609){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63609);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63642){var ex__2730__auto__ = e63642;
var statearr_63643_63669 = state_63609;
(statearr_63643_63669[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63609[(4)]))){
var statearr_63644_63670 = state_63609;
(statearr_63644_63670[(1)] = cljs.core.first((state_63609[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63671 = state_63609;
state_63609 = G__63671;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_63609){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_63609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63645 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63645[(6)] = c__2749__auto___63647);

return statearr_63645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

