// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4253__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_11499){
var state_val_11500 = (state_11499[(1)]);
if((state_val_11500 === (7))){
var inst_11494 = (state_11499[(2)]);
var _ = (function (){var statearr_11501 = state_11499;
(statearr_11501[(4)] = cljs.core.rest.call(null,(state_11499[(4)])));

return statearr_11501;
})();
var state_11499__$1 = state_11499;
var statearr_11502_11524 = state_11499__$1;
(statearr_11502_11524[(2)] = inst_11494);

(statearr_11502_11524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11500 === (1))){
var state_11499__$1 = state_11499;
var statearr_11503_11525 = state_11499__$1;
(statearr_11503_11525[(2)] = null);

(statearr_11503_11525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11500 === (4))){
var inst_11456 = (state_11499[(2)]);
var state_11499__$1 = state_11499;
var statearr_11504_11526 = state_11499__$1;
(statearr_11504_11526[(2)] = inst_11456);

(statearr_11504_11526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11500 === (6))){
var inst_11474 = (state_11499[(7)]);
var inst_11481 = (state_11499[(8)]);
var inst_11480 = cljs.core.seq.call(null,inst_11474);
var inst_11481__$1 = cljs.core.first.call(null,inst_11480);
var inst_11482 = cljs.core.next.call(null,inst_11480);
var inst_11483 = cljs.core.not.call(null,inst_11481__$1);
var state_11499__$1 = (function (){var statearr_11505 = state_11499;
(statearr_11505[(9)] = inst_11482);

(statearr_11505[(8)] = inst_11481__$1);

return statearr_11505;
})();
if(inst_11483){
var statearr_11506_11527 = state_11499__$1;
(statearr_11506_11527[(1)] = (8));

} else {
var statearr_11507_11528 = state_11499__$1;
(statearr_11507_11528[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11500 === (3))){
var inst_11497 = (state_11499[(2)]);
var state_11499__$1 = state_11499;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11499__$1,inst_11497);
} else {
if((state_val_11500 === (2))){
var _ = (function (){var statearr_11508 = state_11499;
(statearr_11508[(4)] = cljs.core.cons.call(null,(5),(state_11499[(4)])));

return statearr_11508;
})();
var inst_11469 = chs;
var inst_11470 = cljs.core.seq.call(null,inst_11469);
var inst_11471 = cljs.core.first.call(null,inst_11470);
var inst_11472 = cljs.core.next.call(null,inst_11470);
var inst_11473 = coll;
var inst_11474 = inst_11469;
var inst_11475 = inst_11473;
var state_11499__$1 = (function (){var statearr_11509 = state_11499;
(statearr_11509[(10)] = inst_11475);

(statearr_11509[(7)] = inst_11474);

(statearr_11509[(11)] = inst_11472);

(statearr_11509[(12)] = inst_11471);

return statearr_11509;
})();
var statearr_11510_11529 = state_11499__$1;
(statearr_11510_11529[(2)] = null);

(statearr_11510_11529[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11500 === (11))){
var inst_11475 = (state_11499[(10)]);
var inst_11482 = (state_11499[(9)]);
var inst_11487 = (state_11499[(2)]);
var inst_11488 = fluree.db.util.async.throw_err.call(null,inst_11487);
var inst_11489 = cljs.core.conj.call(null,inst_11475,inst_11488);
var inst_11474 = inst_11482;
var inst_11475__$1 = inst_11489;
var state_11499__$1 = (function (){var statearr_11512 = state_11499;
(statearr_11512[(10)] = inst_11475__$1);

(statearr_11512[(7)] = inst_11474);

return statearr_11512;
})();
var statearr_11513_11530 = state_11499__$1;
(statearr_11513_11530[(2)] = null);

(statearr_11513_11530[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11500 === (9))){
var inst_11481 = (state_11499[(8)]);
var state_11499__$1 = state_11499;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11499__$1,(11),inst_11481);
} else {
if((state_val_11500 === (5))){
var _ = (function (){var statearr_11514 = state_11499;
(statearr_11514[(4)] = cljs.core.rest.call(null,(state_11499[(4)])));

return statearr_11514;
})();
var state_11499__$1 = state_11499;
var ex11511 = (state_11499__$1[(2)]);
var statearr_11515_11531 = state_11499__$1;
(statearr_11515_11531[(5)] = ex11511);


var statearr_11516_11532 = state_11499__$1;
(statearr_11516_11532[(1)] = (4));

(statearr_11516_11532[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11500 === (10))){
var inst_11492 = (state_11499[(2)]);
var state_11499__$1 = state_11499;
var statearr_11517_11533 = state_11499__$1;
(statearr_11517_11533[(2)] = inst_11492);

(statearr_11517_11533[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11500 === (8))){
var inst_11475 = (state_11499[(10)]);
var state_11499__$1 = state_11499;
var statearr_11518_11534 = state_11499__$1;
(statearr_11518_11534[(2)] = inst_11475);

(statearr_11518_11534[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_11519 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11519[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__);

(statearr_11519[(1)] = (1));

return statearr_11519;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1 = (function (state_11499){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_11499);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e11520){var ex__2749__auto__ = e11520;
var statearr_11521_11535 = state_11499;
(statearr_11521_11535[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_11499[(4)]))){
var statearr_11522_11536 = state_11499;
(statearr_11522_11536[(1)] = cljs.core.first.call(null,(state_11499[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11537 = state_11499;
state_11499 = G__11537;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__ = function(state_11499){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1.call(this,state_11499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_11523 = f__2769__auto__.call(null);
(statearr_11523[(6)] = c__2768__auto__);

return statearr_11523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_11563){
var state_val_11564 = (state_11563[(1)]);
if((state_val_11564 === (7))){
var inst_11558 = (state_11563[(2)]);
var _ = (function (){var statearr_11565 = state_11563;
(statearr_11565[(4)] = cljs.core.rest.call(null,(state_11563[(4)])));

return statearr_11565;
})();
var state_11563__$1 = state_11563;
var statearr_11566_11588 = state_11563__$1;
(statearr_11566_11588[(2)] = inst_11558);

(statearr_11566_11588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11564 === (1))){
var state_11563__$1 = state_11563;
var statearr_11567_11589 = state_11563__$1;
(statearr_11567_11589[(2)] = null);

(statearr_11567_11589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11564 === (4))){
var inst_11538 = (state_11563[(2)]);
var state_11563__$1 = state_11563;
var statearr_11568_11590 = state_11563__$1;
(statearr_11568_11590[(2)] = inst_11538);

(statearr_11568_11590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11564 === (6))){
var state_11563__$1 = state_11563;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11563__$1,(8),chan);
} else {
if((state_val_11564 === (3))){
var inst_11561 = (state_11563[(2)]);
var state_11563__$1 = state_11563;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11563__$1,inst_11561);
} else {
if((state_val_11564 === (2))){
var _ = (function (){var statearr_11569 = state_11563;
(statearr_11569[(4)] = cljs.core.cons.call(null,(5),(state_11563[(4)])));

return statearr_11569;
})();
var inst_11544 = coll;
var inst_11545 = inst_11544;
var state_11563__$1 = (function (){var statearr_11570 = state_11563;
(statearr_11570[(7)] = inst_11545);

return statearr_11570;
})();
var statearr_11571_11591 = state_11563__$1;
(statearr_11571_11591[(2)] = null);

(statearr_11571_11591[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11564 === (11))){
var inst_11556 = (state_11563[(2)]);
var state_11563__$1 = state_11563;
var statearr_11573_11592 = state_11563__$1;
(statearr_11573_11592[(2)] = inst_11556);

(statearr_11573_11592[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11564 === (9))){
var inst_11545 = (state_11563[(7)]);
var state_11563__$1 = state_11563;
var statearr_11574_11593 = state_11563__$1;
(statearr_11574_11593[(2)] = inst_11545);

(statearr_11574_11593[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11564 === (5))){
var _ = (function (){var statearr_11575 = state_11563;
(statearr_11575[(4)] = cljs.core.rest.call(null,(state_11563[(4)])));

return statearr_11575;
})();
var state_11563__$1 = state_11563;
var ex11572 = (state_11563__$1[(2)]);
var statearr_11576_11594 = state_11563__$1;
(statearr_11576_11594[(5)] = ex11572);


var statearr_11577_11595 = state_11563__$1;
(statearr_11577_11595[(1)] = (4));

(statearr_11577_11595[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11564 === (10))){
var inst_11549 = (state_11563[(8)]);
var inst_11545 = (state_11563[(7)]);
var inst_11553 = cljs.core.conj.call(null,inst_11545,inst_11549);
var inst_11545__$1 = inst_11553;
var state_11563__$1 = (function (){var statearr_11578 = state_11563;
(statearr_11578[(7)] = inst_11545__$1);

return statearr_11578;
})();
var statearr_11579_11596 = state_11563__$1;
(statearr_11579_11596[(2)] = null);

(statearr_11579_11596[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11564 === (8))){
var inst_11549 = (state_11563[(8)]);
var inst_11548 = (state_11563[(2)]);
var inst_11549__$1 = fluree.db.util.async.throw_err.call(null,inst_11548);
var inst_11550 = (inst_11549__$1 == null);
var state_11563__$1 = (function (){var statearr_11580 = state_11563;
(statearr_11580[(8)] = inst_11549__$1);

return statearr_11580;
})();
if(cljs.core.truth_(inst_11550)){
var statearr_11581_11597 = state_11563__$1;
(statearr_11581_11597[(1)] = (9));

} else {
var statearr_11582_11598 = state_11563__$1;
(statearr_11582_11598[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_11583 = [null,null,null,null,null,null,null,null,null];
(statearr_11583[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__);

(statearr_11583[(1)] = (1));

return statearr_11583;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1 = (function (state_11563){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_11563);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e11584){var ex__2749__auto__ = e11584;
var statearr_11585_11599 = state_11563;
(statearr_11585_11599[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_11563[(4)]))){
var statearr_11586_11600 = state_11563;
(statearr_11586_11600[(1)] = cljs.core.first.call(null,(state_11563[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11601 = state_11563;
state_11563 = G__11601;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__ = function(state_11563){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1.call(this,state_11563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_11587 = f__2769__auto__.call(null);
(statearr_11587[(6)] = c__2768__auto__);

return statearr_11587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
