// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17245){
var state_val_17246 = (state_17245[(1)]);
if((state_val_17246 === (7))){
var inst_17234 = (state_17245[(7)]);
var inst_17236 = fluree.db.storage.core.serde.call(null,conn);
var inst_17237 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17236,inst_17234);
var state_17245__$1 = state_17245;
var statearr_17247_17266 = state_17245__$1;
(statearr_17247_17266[(2)] = inst_17237);

(statearr_17247_17266[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17246 === (1))){
var state_17245__$1 = state_17245;
var statearr_17248_17267 = state_17245__$1;
(statearr_17248_17267[(2)] = null);

(statearr_17248_17267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17246 === (4))){
var inst_17224 = (state_17245[(2)]);
var state_17245__$1 = state_17245;
var statearr_17249_17268 = state_17245__$1;
(statearr_17249_17268[(2)] = inst_17224);

(statearr_17249_17268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17246 === (6))){
var inst_17234 = (state_17245[(7)]);
var inst_17233 = (state_17245[(2)]);
var inst_17234__$1 = fluree.db.util.async.throw_err.call(null,inst_17233);
var state_17245__$1 = (function (){var statearr_17250 = state_17245;
(statearr_17250[(7)] = inst_17234__$1);

return statearr_17250;
})();
if(cljs.core.truth_(inst_17234__$1)){
var statearr_17251_17269 = state_17245__$1;
(statearr_17251_17269[(1)] = (7));

} else {
var statearr_17252_17270 = state_17245__$1;
(statearr_17252_17270[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17246 === (3))){
var inst_17243 = (state_17245[(2)]);
var state_17245__$1 = state_17245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17245__$1,inst_17243);
} else {
if((state_val_17246 === (2))){
var _ = (function (){var statearr_17254 = state_17245;
(statearr_17254[(4)] = cljs.core.cons.call(null,(5),(state_17245[(4)])));

return statearr_17254;
})();
var inst_17230 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17231 = fluree.db.storage.core.storage_read.call(null,conn,inst_17230);
var state_17245__$1 = state_17245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17245__$1,(6),inst_17231);
} else {
if((state_val_17246 === (9))){
var inst_17240 = (state_17245[(2)]);
var _ = (function (){var statearr_17255 = state_17245;
(statearr_17255[(4)] = cljs.core.rest.call(null,(state_17245[(4)])));

return statearr_17255;
})();
var state_17245__$1 = state_17245;
var statearr_17256_17271 = state_17245__$1;
(statearr_17256_17271[(2)] = inst_17240);

(statearr_17256_17271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17246 === (5))){
var _ = (function (){var statearr_17257 = state_17245;
(statearr_17257[(4)] = cljs.core.rest.call(null,(state_17245[(4)])));

return statearr_17257;
})();
var state_17245__$1 = state_17245;
var ex17253 = (state_17245__$1[(2)]);
var statearr_17258_17272 = state_17245__$1;
(statearr_17258_17272[(5)] = ex17253);


if((ex17253 instanceof Error)){
var statearr_17259_17273 = state_17245__$1;
(statearr_17259_17273[(1)] = (4));

(statearr_17259_17273[(5)] = null);

} else {
throw ex17253;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17246 === (8))){
var state_17245__$1 = state_17245;
var statearr_17260_17274 = state_17245__$1;
(statearr_17260_17274[(2)] = null);

(statearr_17260_17274[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2746__auto____0 = (function (){
var statearr_17261 = [null,null,null,null,null,null,null,null];
(statearr_17261[(0)] = fluree$db$storage$core$read_block_$_state_machine__2746__auto__);

(statearr_17261[(1)] = (1));

return statearr_17261;
});
var fluree$db$storage$core$read_block_$_state_machine__2746__auto____1 = (function (state_17245){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17262){var ex__2749__auto__ = e17262;
var statearr_17263_17275 = state_17245;
(statearr_17263_17275[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17245[(4)]))){
var statearr_17264_17276 = state_17245;
(statearr_17264_17276[(1)] = cljs.core.first.call(null,(state_17245[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17277 = state_17245;
state_17245 = G__17277;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2746__auto__ = function(state_17245){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2746__auto____1.call(this,state_17245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17265 = f__2769__auto__.call(null);
(statearr_17265[(6)] = c__2768__auto__);

return statearr_17265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17300){
var state_val_17301 = (state_17300[(1)]);
if((state_val_17301 === (7))){
var inst_17289 = (state_17300[(7)]);
var inst_17291 = fluree.db.storage.core.serde.call(null,conn);
var inst_17292 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17291,inst_17289);
var state_17300__$1 = state_17300;
var statearr_17302_17321 = state_17300__$1;
(statearr_17302_17321[(2)] = inst_17292);

(statearr_17302_17321[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17301 === (1))){
var state_17300__$1 = state_17300;
var statearr_17303_17322 = state_17300__$1;
(statearr_17303_17322[(2)] = null);

(statearr_17303_17322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17301 === (4))){
var inst_17278 = (state_17300[(2)]);
var state_17300__$1 = state_17300;
var statearr_17304_17323 = state_17300__$1;
(statearr_17304_17323[(2)] = inst_17278);

(statearr_17304_17323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17301 === (6))){
var inst_17289 = (state_17300[(7)]);
var inst_17288 = (state_17300[(2)]);
var inst_17289__$1 = fluree.db.util.async.throw_err.call(null,inst_17288);
var state_17300__$1 = (function (){var statearr_17305 = state_17300;
(statearr_17305[(7)] = inst_17289__$1);

return statearr_17305;
})();
if(cljs.core.truth_(inst_17289__$1)){
var statearr_17306_17324 = state_17300__$1;
(statearr_17306_17324[(1)] = (7));

} else {
var statearr_17307_17325 = state_17300__$1;
(statearr_17307_17325[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17301 === (3))){
var inst_17298 = (state_17300[(2)]);
var state_17300__$1 = state_17300;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17300__$1,inst_17298);
} else {
if((state_val_17301 === (2))){
var _ = (function (){var statearr_17309 = state_17300;
(statearr_17309[(4)] = cljs.core.cons.call(null,(5),(state_17300[(4)])));

return statearr_17309;
})();
var inst_17284 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17285 = [inst_17284,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17286 = fluree.db.storage.core.storage_read.call(null,conn,inst_17285);
var state_17300__$1 = state_17300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17300__$1,(6),inst_17286);
} else {
if((state_val_17301 === (9))){
var inst_17295 = (state_17300[(2)]);
var _ = (function (){var statearr_17310 = state_17300;
(statearr_17310[(4)] = cljs.core.rest.call(null,(state_17300[(4)])));

return statearr_17310;
})();
var state_17300__$1 = state_17300;
var statearr_17311_17326 = state_17300__$1;
(statearr_17311_17326[(2)] = inst_17295);

(statearr_17311_17326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17301 === (5))){
var _ = (function (){var statearr_17312 = state_17300;
(statearr_17312[(4)] = cljs.core.rest.call(null,(state_17300[(4)])));

return statearr_17312;
})();
var state_17300__$1 = state_17300;
var ex17308 = (state_17300__$1[(2)]);
var statearr_17313_17327 = state_17300__$1;
(statearr_17313_17327[(5)] = ex17308);


if((ex17308 instanceof Error)){
var statearr_17314_17328 = state_17300__$1;
(statearr_17314_17328[(1)] = (4));

(statearr_17314_17328[(5)] = null);

} else {
throw ex17308;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17301 === (8))){
var state_17300__$1 = state_17300;
var statearr_17315_17329 = state_17300__$1;
(statearr_17315_17329[(2)] = null);

(statearr_17315_17329[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0 = (function (){
var statearr_17316 = [null,null,null,null,null,null,null,null];
(statearr_17316[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__);

(statearr_17316[(1)] = (1));

return statearr_17316;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1 = (function (state_17300){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17300);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17317){var ex__2749__auto__ = e17317;
var statearr_17318_17330 = state_17300;
(statearr_17318_17330[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17300[(4)]))){
var statearr_17319_17331 = state_17300;
(statearr_17319_17331[(1)] = cljs.core.first.call(null,(state_17300[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17332 = state_17300;
state_17300 = G__17332;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__ = function(state_17300){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1.call(this,state_17300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17320 = f__2769__auto__.call(null);
(statearr_17320[(6)] = c__2768__auto__);

return statearr_17320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17356){
var state_val_17357 = (state_17356[(1)]);
if((state_val_17357 === (1))){
var state_17356__$1 = state_17356;
var statearr_17358_17372 = state_17356__$1;
(statearr_17358_17372[(2)] = null);

(statearr_17358_17372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17357 === (2))){
var _ = (function (){var statearr_17359 = state_17356;
(statearr_17359[(4)] = cljs.core.cons.call(null,(5),(state_17356[(4)])));

return statearr_17359;
})();
var inst_17339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17340 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17341 = (new cljs.core.PersistentVector(null,3,(5),inst_17339,inst_17340,null));
var inst_17342 = cljs.core.select_keys.call(null,block_data,inst_17341);
var inst_17343 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17342);
var inst_17344 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_17343);
var inst_17345 = [inst_17344,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17346 = fluree.db.storage.core.serde.call(null,conn);
var inst_17347 = fluree.db.serde.protocol._serialize_block.call(null,inst_17346,inst_17342);
var inst_17348 = fluree.db.storage.core.storage_write.call(null,conn,inst_17345,inst_17347);
var state_17356__$1 = state_17356;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17356__$1,(6),inst_17348);
} else {
if((state_val_17357 === (3))){
var inst_17354 = (state_17356[(2)]);
var state_17356__$1 = state_17356;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17356__$1,inst_17354);
} else {
if((state_val_17357 === (4))){
var inst_17333 = (state_17356[(2)]);
var state_17356__$1 = state_17356;
var statearr_17361_17373 = state_17356__$1;
(statearr_17361_17373[(2)] = inst_17333);

(statearr_17361_17373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17357 === (5))){
var _ = (function (){var statearr_17362 = state_17356;
(statearr_17362[(4)] = cljs.core.rest.call(null,(state_17356[(4)])));

return statearr_17362;
})();
var state_17356__$1 = state_17356;
var ex17360 = (state_17356__$1[(2)]);
var statearr_17363_17374 = state_17356__$1;
(statearr_17363_17374[(5)] = ex17360);


if((ex17360 instanceof Error)){
var statearr_17364_17375 = state_17356__$1;
(statearr_17364_17375[(1)] = (4));

(statearr_17364_17375[(5)] = null);

} else {
throw ex17360;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17357 === (6))){
var inst_17350 = (state_17356[(2)]);
var inst_17351 = fluree.db.util.async.throw_err.call(null,inst_17350);
var _ = (function (){var statearr_17365 = state_17356;
(statearr_17365[(4)] = cljs.core.rest.call(null,(state_17356[(4)])));

return statearr_17365;
})();
var state_17356__$1 = state_17356;
var statearr_17366_17376 = state_17356__$1;
(statearr_17366_17376[(2)] = inst_17351);

(statearr_17366_17376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0 = (function (){
var statearr_17367 = [null,null,null,null,null,null,null];
(statearr_17367[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__);

(statearr_17367[(1)] = (1));

return statearr_17367;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1 = (function (state_17356){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17356);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17368){var ex__2749__auto__ = e17368;
var statearr_17369_17377 = state_17356;
(statearr_17369_17377[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17356[(4)]))){
var statearr_17370_17378 = state_17356;
(statearr_17370_17378[(1)] = cljs.core.first.call(null,(state_17356[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17379 = state_17356;
state_17356 = G__17379;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__ = function(state_17356){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1.call(this,state_17356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17371 = f__2769__auto__.call(null);
(statearr_17371[(6)] = c__2768__auto__);

return statearr_17371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17402){
var state_val_17403 = (state_17402[(1)]);
if((state_val_17403 === (1))){
var state_17402__$1 = state_17402;
var statearr_17404_17418 = state_17402__$1;
(statearr_17404_17418[(2)] = null);

(statearr_17404_17418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17403 === (2))){
var _ = (function (){var statearr_17405 = state_17402;
(statearr_17405[(4)] = cljs.core.cons.call(null,(5),(state_17402[(4)])));

return statearr_17405;
})();
var inst_17386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17387 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17388 = (new cljs.core.PersistentVector(null,3,(5),inst_17386,inst_17387,null));
var inst_17389 = cljs.core.select_keys.call(null,block_data,inst_17388);
var inst_17390 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17389);
var inst_17391 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_17390);
var inst_17392 = fluree.db.storage.core.serde.call(null,conn);
var inst_17393 = fluree.db.serde.protocol._serialize_block.call(null,inst_17392,inst_17389);
var inst_17394 = fluree.db.storage.core.storage_write.call(null,conn,inst_17391,inst_17393);
var state_17402__$1 = state_17402;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17402__$1,(6),inst_17394);
} else {
if((state_val_17403 === (3))){
var inst_17400 = (state_17402[(2)]);
var state_17402__$1 = state_17402;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17402__$1,inst_17400);
} else {
if((state_val_17403 === (4))){
var inst_17380 = (state_17402[(2)]);
var state_17402__$1 = state_17402;
var statearr_17407_17419 = state_17402__$1;
(statearr_17407_17419[(2)] = inst_17380);

(statearr_17407_17419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17403 === (5))){
var _ = (function (){var statearr_17408 = state_17402;
(statearr_17408[(4)] = cljs.core.rest.call(null,(state_17402[(4)])));

return statearr_17408;
})();
var state_17402__$1 = state_17402;
var ex17406 = (state_17402__$1[(2)]);
var statearr_17409_17420 = state_17402__$1;
(statearr_17409_17420[(5)] = ex17406);


if((ex17406 instanceof Error)){
var statearr_17410_17421 = state_17402__$1;
(statearr_17410_17421[(1)] = (4));

(statearr_17410_17421[(5)] = null);

} else {
throw ex17406;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17403 === (6))){
var inst_17396 = (state_17402[(2)]);
var inst_17397 = fluree.db.util.async.throw_err.call(null,inst_17396);
var _ = (function (){var statearr_17411 = state_17402;
(statearr_17411[(4)] = cljs.core.rest.call(null,(state_17402[(4)])));

return statearr_17411;
})();
var state_17402__$1 = state_17402;
var statearr_17412_17422 = state_17402__$1;
(statearr_17412_17422[(2)] = inst_17397);

(statearr_17412_17422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2746__auto____0 = (function (){
var statearr_17413 = [null,null,null,null,null,null,null];
(statearr_17413[(0)] = fluree$db$storage$core$write_block_$_state_machine__2746__auto__);

(statearr_17413[(1)] = (1));

return statearr_17413;
});
var fluree$db$storage$core$write_block_$_state_machine__2746__auto____1 = (function (state_17402){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17402);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17414){var ex__2749__auto__ = e17414;
var statearr_17415_17423 = state_17402;
(statearr_17415_17423[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17402[(4)]))){
var statearr_17416_17424 = state_17402;
(statearr_17416_17424[(1)] = cljs.core.first.call(null,(state_17402[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17425 = state_17402;
state_17402 = G__17425;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2746__auto__ = function(state_17402){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2746__auto____1.call(this,state_17402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17417 = f__2769__auto__.call(null);
(statearr_17417[(6)] = c__2768__auto__);

return statearr_17417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17445){
var state_val_17446 = (state_17445[(1)]);
if((state_val_17446 === (1))){
var state_17445__$1 = state_17445;
var statearr_17447_17461 = state_17445__$1;
(statearr_17447_17461[(2)] = null);

(statearr_17447_17461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17446 === (2))){
var _ = (function (){var statearr_17448 = state_17445;
(statearr_17448[(4)] = cljs.core.cons.call(null,(5),(state_17445[(4)])));

return statearr_17448;
})();
var inst_17432 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17433 = [history,next_his_key];
var inst_17434 = cljs.core.PersistentHashMap.fromArrays(inst_17432,inst_17433);
var inst_17435 = fluree.db.storage.core.serde.call(null,conn);
var inst_17436 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_17435,inst_17434);
var inst_17437 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_17436);
var state_17445__$1 = state_17445;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17445__$1,(6),inst_17437);
} else {
if((state_val_17446 === (3))){
var inst_17443 = (state_17445[(2)]);
var state_17445__$1 = state_17445;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17445__$1,inst_17443);
} else {
if((state_val_17446 === (4))){
var inst_17426 = (state_17445[(2)]);
var state_17445__$1 = state_17445;
var statearr_17450_17462 = state_17445__$1;
(statearr_17450_17462[(2)] = inst_17426);

(statearr_17450_17462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17446 === (5))){
var _ = (function (){var statearr_17451 = state_17445;
(statearr_17451[(4)] = cljs.core.rest.call(null,(state_17445[(4)])));

return statearr_17451;
})();
var state_17445__$1 = state_17445;
var ex17449 = (state_17445__$1[(2)]);
var statearr_17452_17463 = state_17445__$1;
(statearr_17452_17463[(5)] = ex17449);


if((ex17449 instanceof Error)){
var statearr_17453_17464 = state_17445__$1;
(statearr_17453_17464[(1)] = (4));

(statearr_17453_17464[(5)] = null);

} else {
throw ex17449;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17446 === (6))){
var inst_17439 = (state_17445[(2)]);
var inst_17440 = fluree.db.util.async.throw_err.call(null,inst_17439);
var _ = (function (){var statearr_17454 = state_17445;
(statearr_17454[(4)] = cljs.core.rest.call(null,(state_17445[(4)])));

return statearr_17454;
})();
var state_17445__$1 = state_17445;
var statearr_17455_17465 = state_17445__$1;
(statearr_17455_17465[(2)] = inst_17440);

(statearr_17455_17465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2746__auto____0 = (function (){
var statearr_17456 = [null,null,null,null,null,null,null];
(statearr_17456[(0)] = fluree$db$storage$core$write_history_$_state_machine__2746__auto__);

(statearr_17456[(1)] = (1));

return statearr_17456;
});
var fluree$db$storage$core$write_history_$_state_machine__2746__auto____1 = (function (state_17445){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17457){var ex__2749__auto__ = e17457;
var statearr_17458_17466 = state_17445;
(statearr_17458_17466[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17445[(4)]))){
var statearr_17459_17467 = state_17445;
(statearr_17459_17467[(1)] = cljs.core.first.call(null,(state_17445[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17468 = state_17445;
state_17445 = G__17468;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2746__auto__ = function(state_17445){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2746__auto____1.call(this,state_17445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17460 = f__2769__auto__.call(null);
(statearr_17460[(6)] = c__2768__auto__);

return statearr_17460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17494){
var state_val_17495 = (state_17494[(1)]);
if((state_val_17495 === (1))){
var state_17494__$1 = state_17494;
var statearr_17496_17513 = state_17494__$1;
(statearr_17496_17513[(2)] = null);

(statearr_17496_17513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17495 === (2))){
var inst_17475 = (state_17494[(7)]);
var _ = (function (){var statearr_17497 = state_17494;
(statearr_17497[(4)] = cljs.core.cons.call(null,(5),(state_17494[(4)])));

return statearr_17497;
})();
var inst_17475__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_17476 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17475__$1),"-his"].join('');
var inst_17477 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17478 = [flakes,inst_17476];
var inst_17479 = cljs.core.PersistentHashMap.fromArrays(inst_17477,inst_17478);
var inst_17480 = fluree.db.storage.core.serde.call(null,conn);
var inst_17481 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_17480,inst_17479);
var inst_17482 = fluree.db.storage.core.write_history.call(null,conn,history,inst_17476,null);
var inst_17483 = fluree.db.storage.core.storage_write.call(null,conn,inst_17475__$1,inst_17481);
var state_17494__$1 = (function (){var statearr_17498 = state_17494;
(statearr_17498[(8)] = inst_17483);

(statearr_17498[(7)] = inst_17475__$1);

return statearr_17498;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17494__$1,(6),inst_17482);
} else {
if((state_val_17495 === (3))){
var inst_17492 = (state_17494[(2)]);
var state_17494__$1 = state_17494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17494__$1,inst_17492);
} else {
if((state_val_17495 === (4))){
var inst_17469 = (state_17494[(2)]);
var state_17494__$1 = state_17494;
var statearr_17500_17514 = state_17494__$1;
(statearr_17500_17514[(2)] = inst_17469);

(statearr_17500_17514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17495 === (5))){
var _ = (function (){var statearr_17501 = state_17494;
(statearr_17501[(4)] = cljs.core.rest.call(null,(state_17494[(4)])));

return statearr_17501;
})();
var state_17494__$1 = state_17494;
var ex17499 = (state_17494__$1[(2)]);
var statearr_17502_17515 = state_17494__$1;
(statearr_17502_17515[(5)] = ex17499);


if((ex17499 instanceof Error)){
var statearr_17503_17516 = state_17494__$1;
(statearr_17503_17516[(1)] = (4));

(statearr_17503_17516[(5)] = null);

} else {
throw ex17499;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17495 === (6))){
var inst_17483 = (state_17494[(8)]);
var inst_17485 = (state_17494[(2)]);
var inst_17486 = fluree.db.util.async.throw_err.call(null,inst_17485);
var state_17494__$1 = (function (){var statearr_17504 = state_17494;
(statearr_17504[(9)] = inst_17486);

return statearr_17504;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17494__$1,(7),inst_17483);
} else {
if((state_val_17495 === (7))){
var inst_17475 = (state_17494[(7)]);
var inst_17488 = (state_17494[(2)]);
var inst_17489 = fluree.db.util.async.throw_err.call(null,inst_17488);
var _ = (function (){var statearr_17505 = state_17494;
(statearr_17505[(4)] = cljs.core.rest.call(null,(state_17494[(4)])));

return statearr_17505;
})();
var state_17494__$1 = (function (){var statearr_17506 = state_17494;
(statearr_17506[(10)] = inst_17489);

return statearr_17506;
})();
var statearr_17507_17517 = state_17494__$1;
(statearr_17507_17517[(2)] = inst_17475);

(statearr_17507_17517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_17508 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17508[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__);

(statearr_17508[(1)] = (1));

return statearr_17508;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____1 = (function (state_17494){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17509){var ex__2749__auto__ = e17509;
var statearr_17510_17518 = state_17494;
(statearr_17510_17518[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17494[(4)]))){
var statearr_17511_17519 = state_17494;
(statearr_17511_17519[(1)] = cljs.core.first.call(null,(state_17494[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17520 = state_17494;
state_17494 = G__17520;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__ = function(state_17494){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____1.call(this,state_17494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17512 = f__2769__auto__.call(null);
(statearr_17512[(6)] = c__2768__auto__);

return statearr_17512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17537){
var state_val_17538 = (state_17537[(1)]);
if((state_val_17538 === (1))){
var state_17537__$1 = state_17537;
var statearr_17539_17554 = state_17537__$1;
(statearr_17539_17554[(2)] = null);

(statearr_17539_17554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (2))){
var _ = (function (){var statearr_17540 = state_17537;
(statearr_17540[(4)] = cljs.core.cons.call(null,(5),(state_17537[(4)])));

return statearr_17540;
})();
var inst_17527 = fluree.db.storage.core.serde.call(null,conn);
var inst_17528 = fluree.db.serde.protocol._serialize_branch.call(null,inst_17527,data);
var inst_17529 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_17528);
var state_17537__$1 = state_17537;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17537__$1,(6),inst_17529);
} else {
if((state_val_17538 === (3))){
var inst_17535 = (state_17537[(2)]);
var state_17537__$1 = state_17537;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17537__$1,inst_17535);
} else {
if((state_val_17538 === (4))){
var inst_17521 = (state_17537[(2)]);
var state_17537__$1 = state_17537;
var statearr_17542_17555 = state_17537__$1;
(statearr_17542_17555[(2)] = inst_17521);

(statearr_17542_17555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (5))){
var _ = (function (){var statearr_17543 = state_17537;
(statearr_17543[(4)] = cljs.core.rest.call(null,(state_17537[(4)])));

return statearr_17543;
})();
var state_17537__$1 = state_17537;
var ex17541 = (state_17537__$1[(2)]);
var statearr_17544_17556 = state_17537__$1;
(statearr_17544_17556[(5)] = ex17541);


if((ex17541 instanceof Error)){
var statearr_17545_17557 = state_17537__$1;
(statearr_17545_17557[(1)] = (4));

(statearr_17545_17557[(5)] = null);

} else {
throw ex17541;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (6))){
var inst_17531 = (state_17537[(2)]);
var inst_17532 = fluree.db.util.async.throw_err.call(null,inst_17531);
var _ = (function (){var statearr_17546 = state_17537;
(statearr_17546[(4)] = cljs.core.rest.call(null,(state_17537[(4)])));

return statearr_17546;
})();
var state_17537__$1 = (function (){var statearr_17547 = state_17537;
(statearr_17547[(7)] = inst_17532);

return statearr_17547;
})();
var statearr_17548_17558 = state_17537__$1;
(statearr_17548_17558[(2)] = key);

(statearr_17548_17558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0 = (function (){
var statearr_17549 = [null,null,null,null,null,null,null,null];
(statearr_17549[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__);

(statearr_17549[(1)] = (1));

return statearr_17549;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1 = (function (state_17537){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17537);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17550){var ex__2749__auto__ = e17550;
var statearr_17551_17559 = state_17537;
(statearr_17551_17559[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17537[(4)]))){
var statearr_17552_17560 = state_17537;
(statearr_17552_17560[(1)] = cljs.core.first.call(null,(state_17537[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17561 = state_17537;
state_17537 = G__17561;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__ = function(state_17537){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1.call(this,state_17537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17553 = f__2769__auto__.call(null);
(statearr_17553[(6)] = c__2768__auto__);

return statearr_17553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__17562_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__17562_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__17563){
var map__17564 = p__17563;
var map__17564__$1 = cljs.core.__destructure_map.call(null,map__17564);
var progress = map__17564__$1;
var garbage = cljs.core.get.call(null,map__17564__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17592){
var state_val_17593 = (state_17592[(1)]);
if((state_val_17593 === (1))){
var state_17592__$1 = state_17592;
var statearr_17594_17610 = state_17592__$1;
(statearr_17594_17610[(2)] = null);

(statearr_17594_17610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17593 === (2))){
var inst_17578 = (state_17592[(7)]);
var _ = (function (){var statearr_17595 = state_17592;
(statearr_17595[(4)] = cljs.core.cons.call(null,(5),(state_17592[(4)])));

return statearr_17595;
})();
var inst_17572 = db;
var inst_17573 = cljs.core.__destructure_map.call(null,inst_17572);
var inst_17574 = cljs.core.get.call(null,inst_17573,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17575 = cljs.core.get.call(null,inst_17573,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17576 = cljs.core.get.call(null,inst_17573,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17577 = cljs.core.get.call(null,inst_17573,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17578__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_17575,inst_17576,inst_17577);
var inst_17579 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17580 = [inst_17576,inst_17577,garbage];
var inst_17581 = cljs.core.PersistentHashMap.fromArrays(inst_17579,inst_17580);
var inst_17582 = fluree.db.storage.core.serde.call(null,inst_17574);
var inst_17583 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_17582,inst_17581);
var inst_17584 = fluree.db.storage.core.storage_write.call(null,inst_17574,inst_17578__$1,inst_17583);
var state_17592__$1 = (function (){var statearr_17596 = state_17592;
(statearr_17596[(7)] = inst_17578__$1);

return statearr_17596;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17592__$1,(6),inst_17584);
} else {
if((state_val_17593 === (3))){
var inst_17590 = (state_17592[(2)]);
var state_17592__$1 = state_17592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17592__$1,inst_17590);
} else {
if((state_val_17593 === (4))){
var inst_17565 = (state_17592[(2)]);
var state_17592__$1 = state_17592;
var statearr_17598_17611 = state_17592__$1;
(statearr_17598_17611[(2)] = inst_17565);

(statearr_17598_17611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17593 === (5))){
var _ = (function (){var statearr_17599 = state_17592;
(statearr_17599[(4)] = cljs.core.rest.call(null,(state_17592[(4)])));

return statearr_17599;
})();
var state_17592__$1 = state_17592;
var ex17597 = (state_17592__$1[(2)]);
var statearr_17600_17612 = state_17592__$1;
(statearr_17600_17612[(5)] = ex17597);


if((ex17597 instanceof Error)){
var statearr_17601_17613 = state_17592__$1;
(statearr_17601_17613[(1)] = (4));

(statearr_17601_17613[(5)] = null);

} else {
throw ex17597;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17593 === (6))){
var inst_17578 = (state_17592[(7)]);
var inst_17586 = (state_17592[(2)]);
var inst_17587 = fluree.db.util.async.throw_err.call(null,inst_17586);
var _ = (function (){var statearr_17602 = state_17592;
(statearr_17602[(4)] = cljs.core.rest.call(null,(state_17592[(4)])));

return statearr_17602;
})();
var state_17592__$1 = (function (){var statearr_17603 = state_17592;
(statearr_17603[(8)] = inst_17587);

return statearr_17603;
})();
var statearr_17604_17614 = state_17592__$1;
(statearr_17604_17614[(2)] = inst_17578);

(statearr_17604_17614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0 = (function (){
var statearr_17605 = [null,null,null,null,null,null,null,null,null];
(statearr_17605[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__);

(statearr_17605[(1)] = (1));

return statearr_17605;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1 = (function (state_17592){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17606){var ex__2749__auto__ = e17606;
var statearr_17607_17615 = state_17592;
(statearr_17607_17615[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17592[(4)]))){
var statearr_17608_17616 = state_17592;
(statearr_17608_17616[(1)] = cljs.core.first.call(null,(state_17592[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17617 = state_17592;
state_17592 = G__17617;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__ = function(state_17592){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1.call(this,state_17592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17609 = f__2769__auto__.call(null);
(statearr_17609[(6)] = c__2768__auto__);

return statearr_17609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17619 = arguments.length;
switch (G__17619) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17675){
var state_val_17676 = (state_17675[(1)]);
if((state_val_17676 === (7))){
var state_17675__$1 = state_17675;
var statearr_17677_17703 = state_17675__$1;
(statearr_17677_17703[(2)] = (0));

(statearr_17677_17703[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (1))){
var state_17675__$1 = state_17675;
var statearr_17678_17704 = state_17675__$1;
(statearr_17678_17704[(2)] = null);

(statearr_17678_17704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (4))){
var inst_17620 = (state_17675[(2)]);
var state_17675__$1 = state_17675;
var statearr_17679_17705 = state_17675__$1;
(statearr_17679_17705[(2)] = inst_17620);

(statearr_17679_17705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (6))){
var inst_17645 = (state_17675[(7)]);
var state_17675__$1 = state_17675;
var statearr_17680_17706 = state_17675__$1;
(statearr_17680_17706[(2)] = inst_17645);

(statearr_17680_17706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (3))){
var inst_17673 = (state_17675[(2)]);
var state_17675__$1 = state_17675;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17675__$1,inst_17673);
} else {
if((state_val_17676 === (12))){
var inst_17642 = (state_17675[(8)]);
var inst_17669 = (state_17675[(2)]);
var inst_17670 = fluree.db.util.async.throw_err.call(null,inst_17669);
var _ = (function (){var statearr_17681 = state_17675;
(statearr_17681[(4)] = cljs.core.rest.call(null,(state_17675[(4)])));

return statearr_17681;
})();
var state_17675__$1 = (function (){var statearr_17682 = state_17675;
(statearr_17682[(9)] = inst_17670);

return statearr_17682;
})();
var statearr_17683_17707 = state_17675__$1;
(statearr_17683_17707[(2)] = inst_17642);

(statearr_17683_17707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (2))){
var inst_17645 = (state_17675[(7)]);
var inst_17633 = (state_17675[(10)]);
var inst_17637 = (state_17675[(11)]);
var inst_17635 = (state_17675[(12)]);
var _ = (function (){var statearr_17684 = state_17675;
(statearr_17684[(4)] = cljs.core.cons.call(null,(5),(state_17675[(4)])));

return statearr_17684;
})();
var inst_17627 = db;
var inst_17628 = cljs.core.__destructure_map.call(null,inst_17627);
var inst_17629 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17630 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17631 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17632 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17633__$1 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17634 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17635__$1 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17636 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17637__$1 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17638 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17639 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17640 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17641 = cljs.core.get.call(null,inst_17628,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17642 = fluree.db.storage.core.ledger_root_key.call(null,inst_17629,inst_17637__$1,inst_17635__$1);
var inst_17643 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17644 = fluree.db.storage.core.child_data.call(null,inst_17636);
var inst_17645__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17633__$1);
var state_17675__$1 = (function (){var statearr_17685 = state_17675;
(statearr_17685[(13)] = inst_17640);

(statearr_17685[(14)] = inst_17632);

(statearr_17685[(15)] = inst_17643);

(statearr_17685[(8)] = inst_17642);

(statearr_17685[(16)] = inst_17630);

(statearr_17685[(7)] = inst_17645__$1);

(statearr_17685[(17)] = inst_17631);

(statearr_17685[(10)] = inst_17633__$1);

(statearr_17685[(18)] = inst_17639);

(statearr_17685[(11)] = inst_17637__$1);

(statearr_17685[(19)] = inst_17644);

(statearr_17685[(20)] = inst_17638);

(statearr_17685[(21)] = inst_17641);

(statearr_17685[(22)] = inst_17634);

(statearr_17685[(12)] = inst_17635__$1);

return statearr_17685;
})();
if(cljs.core.truth_(inst_17645__$1)){
var statearr_17686_17708 = state_17675__$1;
(statearr_17686_17708[(1)] = (6));

} else {
var statearr_17687_17709 = state_17675__$1;
(statearr_17687_17709[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (11))){
var inst_17640 = (state_17675[(13)]);
var inst_17632 = (state_17675[(14)]);
var inst_17643 = (state_17675[(15)]);
var inst_17642 = (state_17675[(8)]);
var inst_17630 = (state_17675[(16)]);
var inst_17631 = (state_17675[(17)]);
var inst_17633 = (state_17675[(10)]);
var inst_17639 = (state_17675[(18)]);
var inst_17637 = (state_17675[(11)]);
var inst_17644 = (state_17675[(19)]);
var inst_17641 = (state_17675[(21)]);
var inst_17634 = (state_17675[(22)]);
var inst_17649 = (state_17675[(23)]);
var inst_17635 = (state_17675[(12)]);
var inst_17654 = (state_17675[(2)]);
var inst_17655 = fluree.db.storage.core.child_data.call(null,inst_17639);
var inst_17656 = fluree.db.storage.core.child_data.call(null,inst_17641);
var inst_17657 = fluree.db.util.core.current_time_millis.call(null);
var inst_17658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17659 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17660 = (new cljs.core.PersistentVector(null,2,(5),inst_17658,inst_17659,null));
var inst_17661 = cljs.core.select_keys.call(null,inst_17633,inst_17660);
var inst_17662 = fluree.db.storage.core.child_data.call(null,inst_17632);
var inst_17663 = [inst_17635,inst_17644,inst_17637,inst_17649,inst_17654,inst_17655,inst_17656,inst_17630,inst_17657,inst_17631,inst_17640,inst_17661,inst_17662];
var inst_17664 = cljs.core.PersistentHashMap.fromArrays(inst_17643,inst_17663);
var inst_17665 = fluree.db.storage.core.serde.call(null,inst_17634);
var inst_17666 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_17665,inst_17664);
var inst_17667 = fluree.db.storage.core.storage_write.call(null,inst_17634,inst_17642,inst_17666);
var state_17675__$1 = state_17675;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17675__$1,(12),inst_17667);
} else {
if((state_val_17676 === (9))){
var inst_17650 = (state_17675[(24)]);
var state_17675__$1 = state_17675;
var statearr_17689_17710 = state_17675__$1;
(statearr_17689_17710[(2)] = inst_17650);

(statearr_17689_17710[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (5))){
var _ = (function (){var statearr_17690 = state_17675;
(statearr_17690[(4)] = cljs.core.rest.call(null,(state_17675[(4)])));

return statearr_17690;
})();
var state_17675__$1 = state_17675;
var ex17688 = (state_17675__$1[(2)]);
var statearr_17691_17711 = state_17675__$1;
(statearr_17691_17711[(5)] = ex17688);


if((ex17688 instanceof Error)){
var statearr_17692_17712 = state_17675__$1;
(statearr_17692_17712[(1)] = (4));

(statearr_17692_17712[(5)] = null);

} else {
throw ex17688;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (10))){
var inst_17638 = (state_17675[(20)]);
var state_17675__$1 = state_17675;
var statearr_17693_17713 = state_17675__$1;
(statearr_17693_17713[(2)] = inst_17638);

(statearr_17693_17713[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (8))){
var inst_17650 = (state_17675[(24)]);
var inst_17649 = (state_17675[(2)]);
var inst_17650__$1 = custom_ecount;
var state_17675__$1 = (function (){var statearr_17694 = state_17675;
(statearr_17694[(24)] = inst_17650__$1);

(statearr_17694[(23)] = inst_17649);

return statearr_17694;
})();
if(cljs.core.truth_(inst_17650__$1)){
var statearr_17695_17714 = state_17675__$1;
(statearr_17695_17714[(1)] = (9));

} else {
var statearr_17696_17715 = state_17675__$1;
(statearr_17696_17715[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_17697 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17697[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_17697[(1)] = (1));

return statearr_17697;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_17675){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17675);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17698){var ex__2749__auto__ = e17698;
var statearr_17699_17716 = state_17675;
(statearr_17699_17716[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17675[(4)]))){
var statearr_17700_17717 = state_17675;
(statearr_17700_17717[(1)] = cljs.core.first.call(null,(state_17675[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17718 = state_17675;
state_17675 = G__17718;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_17675){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_17675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17701 = f__2769__auto__.call(null);
(statearr_17701[(6)] = c__2768__auto__);

return statearr_17701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___17777 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17751){
var state_val_17752 = (state_17751[(1)]);
if((state_val_17752 === (7))){
var inst_17731 = (state_17751[(7)]);
var state_17751__$1 = state_17751;
var statearr_17753_17778 = state_17751__$1;
(statearr_17753_17778[(2)] = inst_17731);

(statearr_17753_17778[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (1))){
var state_17751__$1 = state_17751;
var statearr_17754_17779 = state_17751__$1;
(statearr_17754_17779[(2)] = null);

(statearr_17754_17779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (4))){
var inst_17719 = (state_17751[(2)]);
var inst_17720 = error_fn.call(null);
var inst_17721 = cljs.core.async.put_BANG_.call(null,return_ch,inst_17719);
var inst_17722 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_17751__$1 = (function (){var statearr_17755 = state_17751;
(statearr_17755[(8)] = inst_17720);

(statearr_17755[(9)] = inst_17721);

return statearr_17755;
})();
var statearr_17756_17780 = state_17751__$1;
(statearr_17756_17780[(2)] = inst_17722);

(statearr_17756_17780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (6))){
var inst_17730 = (state_17751[(10)]);
var inst_17731 = (state_17751[(7)]);
var inst_17730__$1 = (state_17751[(2)]);
var inst_17731__$1 = (inst_17730__$1 == null);
var state_17751__$1 = (function (){var statearr_17757 = state_17751;
(statearr_17757[(10)] = inst_17730__$1);

(statearr_17757[(7)] = inst_17731__$1);

return statearr_17757;
})();
if(cljs.core.truth_(inst_17731__$1)){
var statearr_17758_17781 = state_17751__$1;
(statearr_17758_17781[(1)] = (7));

} else {
var statearr_17759_17782 = state_17751__$1;
(statearr_17759_17782[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (3))){
var inst_17749 = (state_17751[(2)]);
var state_17751__$1 = state_17751;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17751__$1,inst_17749);
} else {
if((state_val_17752 === (12))){
var inst_17746 = (state_17751[(2)]);
var _ = (function (){var statearr_17760 = state_17751;
(statearr_17760[(4)] = cljs.core.rest.call(null,(state_17751[(4)])));

return statearr_17760;
})();
var state_17751__$1 = state_17751;
var statearr_17761_17783 = state_17751__$1;
(statearr_17761_17783[(2)] = inst_17746);

(statearr_17761_17783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (2))){
var _ = (function (){var statearr_17762 = state_17751;
(statearr_17762[(4)] = cljs.core.cons.call(null,(5),(state_17751[(4)])));

return statearr_17762;
})();
var inst_17728 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_17751__$1 = state_17751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17751__$1,(6),inst_17728);
} else {
if((state_val_17752 === (11))){
var inst_17730 = (state_17751[(10)]);
var inst_17740 = fluree.db.storage.core.serde.call(null,conn);
var inst_17741 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_17740,inst_17730);
var inst_17742 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17741);
var inst_17743 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_17742);
var inst_17744 = cljs.core.async.put_BANG_.call(null,return_ch,inst_17743);
var state_17751__$1 = state_17751;
var statearr_17764_17784 = state_17751__$1;
(statearr_17764_17784[(2)] = inst_17744);

(statearr_17764_17784[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (9))){
var inst_17736 = (state_17751[(2)]);
var state_17751__$1 = state_17751;
if(cljs.core.truth_(inst_17736)){
var statearr_17765_17785 = state_17751__$1;
(statearr_17765_17785[(1)] = (10));

} else {
var statearr_17766_17786 = state_17751__$1;
(statearr_17766_17786[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (5))){
var _ = (function (){var statearr_17767 = state_17751;
(statearr_17767[(4)] = cljs.core.rest.call(null,(state_17751[(4)])));

return statearr_17767;
})();
var state_17751__$1 = state_17751;
var ex17763 = (state_17751__$1[(2)]);
var statearr_17768_17787 = state_17751__$1;
(statearr_17768_17787[(5)] = ex17763);


var statearr_17769_17788 = state_17751__$1;
(statearr_17769_17788[(1)] = (4));

(statearr_17769_17788[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (10))){
var inst_17738 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_17751__$1 = state_17751;
var statearr_17770_17789 = state_17751__$1;
(statearr_17770_17789[(2)] = inst_17738);

(statearr_17770_17789[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (8))){
var inst_17730 = (state_17751[(10)]);
var inst_17734 = (inst_17730 instanceof Error);
var state_17751__$1 = state_17751;
var statearr_17771_17790 = state_17751__$1;
(statearr_17771_17790[(2)] = inst_17734);

(statearr_17771_17790[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2746__auto____0 = (function (){
var statearr_17772 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17772[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2746__auto__);

(statearr_17772[(1)] = (1));

return statearr_17772;
});
var fluree$db$storage$core$reify_history_$_state_machine__2746__auto____1 = (function (state_17751){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17773){var ex__2749__auto__ = e17773;
var statearr_17774_17791 = state_17751;
(statearr_17774_17791[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17751[(4)]))){
var statearr_17775_17792 = state_17751;
(statearr_17775_17792[(1)] = cljs.core.first.call(null,(state_17751[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17793 = state_17751;
state_17751 = G__17793;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2746__auto__ = function(state_17751){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2746__auto____1.call(this,state_17751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17776 = f__2769__auto__.call(null);
(statearr_17776[(6)] = c__2768__auto___17777);

return statearr_17776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__17795 = arguments.length;
switch (G__17795) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4251__auto__ = (rhs == null);
if(and__4251__auto__){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___17905 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17858){
var state_val_17859 = (state_17858[(1)]);
if((state_val_17859 === (7))){
var state_17858__$1 = state_17858;
var statearr_17860_17906 = state_17858__$1;
(statearr_17860_17906[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_17860_17906[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (20))){
var inst_17837 = cljs.core.PersistentVector.EMPTY;
var state_17858__$1 = state_17858;
var statearr_17861_17907 = state_17858__$1;
(statearr_17861_17907[(2)] = inst_17837);

(statearr_17861_17907[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (1))){
var state_17858__$1 = state_17858;
var statearr_17862_17908 = state_17858__$1;
(statearr_17862_17908[(2)] = null);

(statearr_17862_17908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (24))){
var state_17858__$1 = state_17858;
var statearr_17863_17909 = state_17858__$1;
(statearr_17863_17909[(2)] = null);

(statearr_17863_17909[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (4))){
var inst_17798 = (state_17858[(2)]);
var inst_17799 = error_fn.call(null);
var inst_17800 = cljs.core.async.put_BANG_.call(null,result_ch,inst_17798);
var inst_17801 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_17858__$1 = (function (){var statearr_17864 = state_17858;
(statearr_17864[(7)] = inst_17799);

(statearr_17864[(8)] = inst_17800);

return statearr_17864;
})();
var statearr_17865_17910 = state_17858__$1;
(statearr_17865_17910[(2)] = inst_17801);

(statearr_17865_17910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (15))){
var inst_17823 = (state_17858[(2)]);
var state_17858__$1 = state_17858;
var statearr_17866_17911 = state_17858__$1;
(statearr_17866_17911[(2)] = inst_17823);

(statearr_17866_17911[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (21))){
var inst_17811 = (state_17858[(9)]);
var inst_17812 = (state_17858[(10)]);
var inst_17810 = (state_17858[(11)]);
var inst_17840 = (state_17858[(12)]);
var inst_17827 = (state_17858[(13)]);
var inst_17847 = (state_17858[(2)]);
var inst_17848 = (function (){var base_node = inst_17810;
var first_flake = inst_17811;
var node_t = inst_17812;
var source = inst_17827;
var coll = inst_17840;
var conj_QMARK_ = inst_17847;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4253__auto__ = remove_preds;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_17849 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17810);
var inst_17850 = cljs.core.reduce.call(null,inst_17848,inst_17849,inst_17840);
var inst_17851 = cljs.core.doall.call(null,inst_17850);
var inst_17852 = cljs.core.assoc.call(null,inst_17810,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_17851);
var inst_17853 = cljs.core.async.put_BANG_.call(null,result_ch,inst_17852);
var _ = (function (){var statearr_17867 = state_17858;
(statearr_17867[(4)] = cljs.core.rest.call(null,(state_17858[(4)])));

return statearr_17867;
})();
var state_17858__$1 = state_17858;
var statearr_17868_17912 = state_17858__$1;
(statearr_17868_17912[(2)] = inst_17853);

(statearr_17868_17912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (13))){
var state_17858__$1 = state_17858;
var statearr_17869_17913 = state_17858__$1;
(statearr_17869_17913[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_17869_17913[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (22))){
var inst_17811 = (state_17858[(9)]);
var inst_17812 = (state_17858[(10)]);
var inst_17810 = (state_17858[(11)]);
var inst_17840 = (state_17858[(12)]);
var inst_17827 = (state_17858[(13)]);
var inst_17841 = (function (){var base_node = inst_17810;
var first_flake = inst_17811;
var node_t = inst_17812;
var source = inst_17827;
var coll = inst_17840;
return (function (f){
return f.op === true;
});
})();
var state_17858__$1 = state_17858;
var statearr_17870_17914 = state_17858__$1;
(statearr_17870_17914[(2)] = inst_17841);

(statearr_17870_17914[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (6))){
var inst_17812 = (state_17858[(10)]);
var inst_17810 = (state_17858[(11)]);
var inst_17809 = (state_17858[(2)]);
var inst_17810__$1 = fluree.db.util.async.throw_err.call(null,inst_17809);
var inst_17811 = fluree.db.dbproto._first_flake.call(null,inst_17810__$1);
var inst_17812__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_17810__$1);
var inst_17813 = (inst_17812__$1 > t);
var state_17858__$1 = (function (){var statearr_17871 = state_17858;
(statearr_17871[(9)] = inst_17811);

(statearr_17871[(10)] = inst_17812__$1);

(statearr_17871[(11)] = inst_17810__$1);

return statearr_17871;
})();
if(cljs.core.truth_(inst_17813)){
var statearr_17872_17915 = state_17858__$1;
(statearr_17872_17915[(1)] = (7));

} else {
var statearr_17873_17916 = state_17858__$1;
(statearr_17873_17916[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (17))){
var inst_17811 = (state_17858[(9)]);
var inst_17828 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_17811,rhs,leftmost_QMARK_,t);
var state_17858__$1 = state_17858;
var statearr_17874_17917 = state_17858__$1;
(statearr_17874_17917[(2)] = inst_17828);

(statearr_17874_17917[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (3))){
var inst_17856 = (state_17858[(2)]);
var state_17858__$1 = state_17858;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17858__$1,inst_17856);
} else {
if((state_val_17859 === (12))){
var inst_17825 = (state_17858[(2)]);
var state_17858__$1 = state_17858;
var statearr_17875_17918 = state_17858__$1;
(statearr_17875_17918[(2)] = inst_17825);

(statearr_17875_17918[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (2))){
var _ = (function (){var statearr_17876 = state_17858;
(statearr_17876[(4)] = cljs.core.cons.call(null,(5),(state_17858[(4)])));

return statearr_17876;
})();
var inst_17807 = fluree.db.dbproto._resolve.call(null,node);
var state_17858__$1 = state_17858;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17858__$1,(6),inst_17807);
} else {
if((state_val_17859 === (23))){
var inst_17811 = (state_17858[(9)]);
var inst_17812 = (state_17858[(10)]);
var inst_17810 = (state_17858[(11)]);
var inst_17840 = (state_17858[(12)]);
var inst_17827 = (state_17858[(13)]);
var inst_17843 = (function (){var base_node = inst_17810;
var first_flake = inst_17811;
var node_t = inst_17812;
var source = inst_17827;
var coll = inst_17840;
return (function (f){
return f.op === false;
});
})();
var state_17858__$1 = state_17858;
var statearr_17877_17919 = state_17858__$1;
(statearr_17877_17919[(2)] = inst_17843);

(statearr_17877_17919[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (19))){
var inst_17830 = (state_17858[(14)]);
var inst_17833 = (state_17858[(2)]);
var inst_17834 = fluree.db.util.async.throw_err.call(null,inst_17833);
var inst_17835 = cljs.core.take_while.call(null,inst_17830,inst_17834);
var state_17858__$1 = state_17858;
var statearr_17878_17920 = state_17858__$1;
(statearr_17878_17920[(2)] = inst_17835);

(statearr_17878_17920[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (11))){
var inst_17812 = (state_17858[(10)]);
var inst_17819 = cljs.core._EQ_.call(null,inst_17812,t);
var state_17858__$1 = state_17858;
if(inst_17819){
var statearr_17880_17921 = state_17858__$1;
(statearr_17880_17921[(1)] = (13));

} else {
var statearr_17881_17922 = state_17858__$1;
(statearr_17881_17922[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (9))){
var inst_17827 = (state_17858[(13)]);
var inst_17827__$1 = (state_17858[(2)]);
var state_17858__$1 = (function (){var statearr_17882 = state_17858;
(statearr_17882[(13)] = inst_17827__$1);

return statearr_17882;
})();
var G__17883_17923 = inst_17827__$1;
var G__17883_17924__$1 = (((G__17883_17923 instanceof cljs.core.Keyword))?G__17883_17923.fqn:null);
switch (G__17883_17924__$1) {
case "novelty":
var statearr_17884_17926 = state_17858__$1;
(statearr_17884_17926[(1)] = (17));


break;
case "history":
var statearr_17885_17927 = state_17858__$1;
(statearr_17885_17927[(1)] = (18));


break;
case "none":
var statearr_17886_17928 = state_17858__$1;
(statearr_17886_17928[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17883_17924__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (5))){
var _ = (function (){var statearr_17887 = state_17858;
(statearr_17887[(4)] = cljs.core.rest.call(null,(state_17858[(4)])));

return statearr_17887;
})();
var state_17858__$1 = state_17858;
var ex17879 = (state_17858__$1[(2)]);
var statearr_17888_17929 = state_17858__$1;
(statearr_17888_17929[(5)] = ex17879);


var statearr_17889_17930 = state_17858__$1;
(statearr_17889_17930[(1)] = (4));

(statearr_17889_17930[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (14))){
var state_17858__$1 = state_17858;
var statearr_17890_17931 = state_17858__$1;
(statearr_17890_17931[(2)] = null);

(statearr_17890_17931[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (16))){
var inst_17827 = (state_17858[(13)]);
var inst_17840 = (state_17858[(2)]);
var state_17858__$1 = (function (){var statearr_17891 = state_17858;
(statearr_17891[(12)] = inst_17840);

return statearr_17891;
})();
var G__17892_17932 = inst_17827;
var G__17892_17933__$1 = (((G__17892_17932 instanceof cljs.core.Keyword))?G__17892_17932.fqn:null);
switch (G__17892_17933__$1) {
case "novelty":
var statearr_17893_17935 = state_17858__$1;
(statearr_17893_17935[(1)] = (22));


break;
case "history":
var statearr_17894_17936 = state_17858__$1;
(statearr_17894_17936[(1)] = (23));


break;
case "none":
var statearr_17895_17937 = state_17858__$1;
(statearr_17895_17937[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17892_17933__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (10))){
var state_17858__$1 = state_17858;
var statearr_17896_17938 = state_17858__$1;
(statearr_17896_17938[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_17896_17938[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17859 === (18))){
var inst_17811 = (state_17858[(9)]);
var inst_17812 = (state_17858[(10)]);
var inst_17810 = (state_17858[(11)]);
var inst_17827 = (state_17858[(13)]);
var inst_17830 = (function (){var base_node = inst_17810;
var first_flake = inst_17811;
var node_t = inst_17812;
var source = inst_17827;
return (function (p1__17797_SHARP_){
return (p1__17797_SHARP_.t <= t);
});
})();
var inst_17831 = fluree.db.dbproto._resolve_history.call(null,node);
var state_17858__$1 = (function (){var statearr_17897 = state_17858;
(statearr_17897[(14)] = inst_17830);

return statearr_17897;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17858__$1,(19),inst_17831);
} else {
if((state_val_17859 === (8))){
var inst_17812 = (state_17858[(10)]);
var inst_17816 = (inst_17812 < t);
var state_17858__$1 = state_17858;
if(cljs.core.truth_(inst_17816)){
var statearr_17898_17939 = state_17858__$1;
(statearr_17898_17939[(1)] = (10));

} else {
var statearr_17899_17940 = state_17858__$1;
(statearr_17899_17940[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____0 = (function (){
var statearr_17900 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17900[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__);

(statearr_17900[(1)] = (1));

return statearr_17900;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____1 = (function (state_17858){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17858);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17901){var ex__2749__auto__ = e17901;
var statearr_17902_17941 = state_17858;
(statearr_17902_17941[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17858[(4)]))){
var statearr_17903_17942 = state_17858;
(statearr_17903_17942[(1)] = cljs.core.first.call(null,(state_17858[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17943 = state_17858;
state_17858 = G__17943;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__ = function(state_17858){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____1.call(this,state_17858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2746__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17904 = f__2769__auto__.call(null);
(statearr_17904[(6)] = c__2768__auto___17905);

return statearr_17904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18003){
var state_val_18004 = (state_18003[(1)]);
if((state_val_18004 === (7))){
var inst_17954 = (state_18003[(7)]);
var inst_17958 = (inst_17954 <= from_t);
var state_18003__$1 = state_18003;
var statearr_18005_18045 = state_18003__$1;
(statearr_18005_18045[(2)] = inst_17958);

(statearr_18005_18045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (20))){
var inst_17988 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_17989 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17988)].join('');
var inst_17990 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17991 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_17992 = cljs.core.PersistentHashMap.fromArrays(inst_17990,inst_17991);
var inst_17993 = cljs.core.ex_info.call(null,inst_17989,inst_17992);
var inst_17994 = (function(){throw inst_17993})();
var state_18003__$1 = state_18003;
var statearr_18006_18046 = state_18003__$1;
(statearr_18006_18046[(2)] = inst_17994);

(statearr_18006_18046[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (1))){
var state_18003__$1 = state_18003;
var statearr_18007_18047 = state_18003__$1;
(statearr_18007_18047[(2)] = null);

(statearr_18007_18047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (4))){
var inst_17946 = (state_18003[(2)]);
var inst_17947 = fluree.db.util.log.error.call(null,inst_17946);
var inst_17948 = (function(){throw inst_17946})();
var state_18003__$1 = (function (){var statearr_18008 = state_18003;
(statearr_18008[(8)] = inst_17947);

return statearr_18008;
})();
var statearr_18009_18048 = state_18003__$1;
(statearr_18009_18048[(2)] = inst_17948);

(statearr_18009_18048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (15))){
var inst_17973 = (state_18003[(2)]);
var state_18003__$1 = (function (){var statearr_18010 = state_18003;
(statearr_18010[(9)] = inst_17973);

return statearr_18010;
})();
if(cljs.core.truth_(from_t)){
var statearr_18011_18049 = state_18003__$1;
(statearr_18011_18049[(1)] = (16));

} else {
var statearr_18012_18050 = state_18003__$1;
(statearr_18012_18050[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (21))){
var inst_17984 = (state_18003[(10)]);
var inst_17982 = (state_18003[(11)]);
var inst_17983 = (state_18003[(12)]);
var inst_17996 = (state_18003[(2)]);
var inst_17997 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_17983,inst_17984,leftmost_QMARK_,to_t);
var inst_17998 = cljs.core.into.call(null,inst_17997,inst_17982);
var _ = (function (){var statearr_18013 = state_18003;
(statearr_18013[(4)] = cljs.core.rest.call(null,(state_18003[(4)])));

return statearr_18013;
})();
var state_18003__$1 = (function (){var statearr_18014 = state_18003;
(statearr_18014[(13)] = inst_17996);

return statearr_18014;
})();
var statearr_18015_18051 = state_18003__$1;
(statearr_18015_18051[(2)] = inst_17998);

(statearr_18015_18051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (13))){
var inst_17966 = (state_18003[(14)]);
var inst_17954 = (state_18003[(7)]);
var inst_17969 = (function (){var node_t = inst_17954;
var G__17962 = inst_17966;
return (function (p1__17944_SHARP_){
return (p1__17944_SHARP_.t < to_t);
});
})();
var inst_17970 = cljs.core.drop_while.call(null,inst_17969,inst_17966);
var state_18003__$1 = state_18003;
var statearr_18016_18052 = state_18003__$1;
(statearr_18016_18052[(2)] = inst_17970);

(statearr_18016_18052[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (6))){
var inst_17955 = (state_18003[(15)]);
var state_18003__$1 = state_18003;
var statearr_18017_18053 = state_18003__$1;
(statearr_18017_18053[(2)] = inst_17955);

(statearr_18017_18053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (17))){
var inst_17973 = (state_18003[(9)]);
var state_18003__$1 = state_18003;
var statearr_18018_18054 = state_18003__$1;
(statearr_18018_18054[(2)] = inst_17973);

(statearr_18018_18054[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (3))){
var inst_18001 = (state_18003[(2)]);
var state_18003__$1 = state_18003;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18003__$1,inst_18001);
} else {
if((state_val_18004 === (12))){
var inst_17954 = (state_18003[(7)]);
var inst_17965 = (state_18003[(2)]);
var inst_17966 = fluree.db.util.async.throw_err.call(null,inst_17965);
var inst_17967 = (to_t > inst_17954);
var state_18003__$1 = (function (){var statearr_18019 = state_18003;
(statearr_18019[(14)] = inst_17966);

return statearr_18019;
})();
if(cljs.core.truth_(inst_17967)){
var statearr_18020_18055 = state_18003__$1;
(statearr_18020_18055[(1)] = (13));

} else {
var statearr_18021_18056 = state_18003__$1;
(statearr_18021_18056[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (2))){
var inst_17955 = (state_18003[(15)]);
var _ = (function (){var statearr_18022 = state_18003;
(statearr_18022[(4)] = cljs.core.cons.call(null,(5),(state_18003[(4)])));

return statearr_18022;
})();
var inst_17954 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_17955__$1 = (from_t == null);
var state_18003__$1 = (function (){var statearr_18023 = state_18003;
(statearr_18023[(7)] = inst_17954);

(statearr_18023[(15)] = inst_17955__$1);

return statearr_18023;
})();
if(cljs.core.truth_(inst_17955__$1)){
var statearr_18024_18057 = state_18003__$1;
(statearr_18024_18057[(1)] = (6));

} else {
var statearr_18025_18058 = state_18003__$1;
(statearr_18025_18058[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (19))){
var state_18003__$1 = state_18003;
var statearr_18026_18059 = state_18003__$1;
(statearr_18026_18059[(2)] = null);

(statearr_18026_18059[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (11))){
var inst_17982 = (state_18003[(2)]);
var inst_17983 = fluree.db.dbproto._first_flake.call(null,node);
var inst_17984 = fluree.db.dbproto._rhs.call(null,node);
var inst_17985 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_18003__$1 = (function (){var statearr_18028 = state_18003;
(statearr_18028[(10)] = inst_17984);

(statearr_18028[(11)] = inst_17982);

(statearr_18028[(12)] = inst_17983);

return statearr_18028;
})();
if(cljs.core.truth_(inst_17985)){
var statearr_18029_18060 = state_18003__$1;
(statearr_18029_18060[(1)] = (19));

} else {
var statearr_18030_18061 = state_18003__$1;
(statearr_18030_18061[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (9))){
var inst_17963 = fluree.db.dbproto._resolve_history.call(null,node);
var state_18003__$1 = state_18003;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18003__$1,(12),inst_17963);
} else {
if((state_val_18004 === (5))){
var _ = (function (){var statearr_18031 = state_18003;
(statearr_18031[(4)] = cljs.core.rest.call(null,(state_18003[(4)])));

return statearr_18031;
})();
var state_18003__$1 = state_18003;
var ex18027 = (state_18003__$1[(2)]);
var statearr_18032_18062 = state_18003__$1;
(statearr_18032_18062[(5)] = ex18027);


var statearr_18033_18063 = state_18003__$1;
(statearr_18033_18063[(1)] = (4));

(statearr_18033_18063[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (14))){
var inst_17966 = (state_18003[(14)]);
var state_18003__$1 = state_18003;
var statearr_18034_18064 = state_18003__$1;
(statearr_18034_18064[(2)] = inst_17966);

(statearr_18034_18064[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (16))){
var inst_17954 = (state_18003[(7)]);
var inst_17973 = (state_18003[(9)]);
var inst_17975 = (function (){var node_t = inst_17954;
var G__17962 = inst_17973;
return (function (p1__17945_SHARP_){
return (p1__17945_SHARP_.t <= from_t);
});
})();
var inst_17976 = cljs.core.take_while.call(null,inst_17975,inst_17973);
var state_18003__$1 = state_18003;
var statearr_18035_18065 = state_18003__$1;
(statearr_18035_18065[(2)] = inst_17976);

(statearr_18035_18065[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (10))){
var state_18003__$1 = state_18003;
var statearr_18036_18066 = state_18003__$1;
(statearr_18036_18066[(2)] = null);

(statearr_18036_18066[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (18))){
var inst_17979 = (state_18003[(2)]);
var state_18003__$1 = state_18003;
var statearr_18037_18067 = state_18003__$1;
(statearr_18037_18067[(2)] = inst_17979);

(statearr_18037_18067[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (8))){
var inst_17960 = (state_18003[(2)]);
var state_18003__$1 = state_18003;
if(cljs.core.truth_(inst_17960)){
var statearr_18038_18068 = state_18003__$1;
(statearr_18038_18068[(1)] = (9));

} else {
var statearr_18039_18069 = state_18003__$1;
(statearr_18039_18069[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____0 = (function (){
var statearr_18040 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18040[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__);

(statearr_18040[(1)] = (1));

return statearr_18040;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____1 = (function (state_18003){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18003);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18041){var ex__2749__auto__ = e18041;
var statearr_18042_18070 = state_18003;
(statearr_18042_18070[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18003[(4)]))){
var statearr_18043_18071 = state_18003;
(statearr_18043_18071[(1)] = cljs.core.first.call(null,(state_18003[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18072 = state_18003;
state_18003 = G__18072;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__ = function(state_18003){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____1.call(this,state_18003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18044 = f__2769__auto__.call(null);
(statearr_18044[(6)] = c__2768__auto__);

return statearr_18044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4253__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18093){
var state_val_18094 = (state_18093[(1)]);
if((state_val_18094 === (7))){
var inst_18082 = (state_18093[(7)]);
var inst_18084 = fluree.db.storage.core.serde.call(null,conn);
var inst_18085 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_18084,inst_18082);
var state_18093__$1 = state_18093;
var statearr_18095_18114 = state_18093__$1;
(statearr_18095_18114[(2)] = inst_18085);

(statearr_18095_18114[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18094 === (1))){
var state_18093__$1 = state_18093;
var statearr_18096_18115 = state_18093__$1;
(statearr_18096_18115[(2)] = null);

(statearr_18096_18115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18094 === (4))){
var inst_18073 = (state_18093[(2)]);
var state_18093__$1 = state_18093;
var statearr_18097_18116 = state_18093__$1;
(statearr_18097_18116[(2)] = inst_18073);

(statearr_18097_18116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18094 === (6))){
var inst_18082 = (state_18093[(7)]);
var inst_18081 = (state_18093[(2)]);
var inst_18082__$1 = fluree.db.util.async.throw_err.call(null,inst_18081);
var state_18093__$1 = (function (){var statearr_18098 = state_18093;
(statearr_18098[(7)] = inst_18082__$1);

return statearr_18098;
})();
if(cljs.core.truth_(inst_18082__$1)){
var statearr_18099_18117 = state_18093__$1;
(statearr_18099_18117[(1)] = (7));

} else {
var statearr_18100_18118 = state_18093__$1;
(statearr_18100_18118[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18094 === (3))){
var inst_18091 = (state_18093[(2)]);
var state_18093__$1 = state_18093;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18093__$1,inst_18091);
} else {
if((state_val_18094 === (2))){
var _ = (function (){var statearr_18102 = state_18093;
(statearr_18102[(4)] = cljs.core.cons.call(null,(5),(state_18093[(4)])));

return statearr_18102;
})();
var inst_18079 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_18093__$1 = state_18093;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18093__$1,(6),inst_18079);
} else {
if((state_val_18094 === (9))){
var inst_18088 = (state_18093[(2)]);
var _ = (function (){var statearr_18103 = state_18093;
(statearr_18103[(4)] = cljs.core.rest.call(null,(state_18093[(4)])));

return statearr_18103;
})();
var state_18093__$1 = state_18093;
var statearr_18104_18119 = state_18093__$1;
(statearr_18104_18119[(2)] = inst_18088);

(statearr_18104_18119[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18094 === (5))){
var _ = (function (){var statearr_18105 = state_18093;
(statearr_18105[(4)] = cljs.core.rest.call(null,(state_18093[(4)])));

return statearr_18105;
})();
var state_18093__$1 = state_18093;
var ex18101 = (state_18093__$1[(2)]);
var statearr_18106_18120 = state_18093__$1;
(statearr_18106_18120[(5)] = ex18101);


if((ex18101 instanceof Error)){
var statearr_18107_18121 = state_18093__$1;
(statearr_18107_18121[(1)] = (4));

(statearr_18107_18121[(5)] = null);

} else {
throw ex18101;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18094 === (8))){
var state_18093__$1 = state_18093;
var statearr_18108_18122 = state_18093__$1;
(statearr_18108_18122[(2)] = null);

(statearr_18108_18122[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0 = (function (){
var statearr_18109 = [null,null,null,null,null,null,null,null];
(statearr_18109[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2746__auto__);

(statearr_18109[(1)] = (1));

return statearr_18109;
});
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1 = (function (state_18093){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18093);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18110){var ex__2749__auto__ = e18110;
var statearr_18111_18123 = state_18093;
(statearr_18111_18123[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18093[(4)]))){
var statearr_18112_18124 = state_18093;
(statearr_18112_18124[(1)] = cljs.core.first.call(null,(state_18093[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18125 = state_18093;
state_18093 = G__18125;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__ = function(state_18093){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1.call(this,state_18093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18113 = f__2769__auto__.call(null);
(statearr_18113[(6)] = c__2768__auto__);

return statearr_18113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___18204 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18176){
var state_val_18177 = (state_18176[(1)]);
if((state_val_18177 === (7))){
var inst_18143 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18144 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18145 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18146 = cljs.core.PersistentHashMap.fromArrays(inst_18144,inst_18145);
var inst_18147 = cljs.core.ex_info.call(null,inst_18143,inst_18146);
var inst_18148 = (function(){throw inst_18147})();
var state_18176__$1 = state_18176;
var statearr_18178_18205 = state_18176__$1;
(statearr_18178_18205[(2)] = inst_18148);

(statearr_18178_18205[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (1))){
var state_18176__$1 = state_18176;
var statearr_18179_18206 = state_18176__$1;
(statearr_18179_18206[(2)] = null);

(statearr_18179_18206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (4))){
var inst_18126 = (state_18176[(2)]);
var inst_18127 = error_fn.call(null);
var inst_18128 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18126);
var inst_18129 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_18176__$1 = (function (){var statearr_18180 = state_18176;
(statearr_18180[(7)] = inst_18128);

(statearr_18180[(8)] = inst_18127);

return statearr_18180;
})();
var statearr_18181_18207 = state_18176__$1;
(statearr_18181_18207[(2)] = inst_18129);

(statearr_18181_18207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (6))){
var inst_18140 = (state_18176[(9)]);
var inst_18139 = (state_18176[(2)]);
var inst_18140__$1 = fluree.db.util.async.throw_err.call(null,inst_18139);
var inst_18141 = (inst_18140__$1 == null);
var state_18176__$1 = (function (){var statearr_18182 = state_18176;
(statearr_18182[(9)] = inst_18140__$1);

return statearr_18182;
})();
if(cljs.core.truth_(inst_18141)){
var statearr_18183_18208 = state_18176__$1;
(statearr_18183_18208[(1)] = (7));

} else {
var statearr_18184_18209 = state_18176__$1;
(statearr_18184_18209[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (3))){
var inst_18174 = (state_18176[(2)]);
var state_18176__$1 = state_18176;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18176__$1,inst_18174);
} else {
if((state_val_18177 === (12))){
var inst_18140 = (state_18176[(9)]);
var inst_18157 = (state_18176[(2)]);
var inst_18158 = cljs.core.__destructure_map.call(null,inst_18140);
var inst_18159 = cljs.core.get.call(null,inst_18158,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18160 = cljs.core.get.call(null,inst_18158,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_18161 = config;
var inst_18162 = cljs.core.__destructure_map.call(null,inst_18161);
var inst_18163 = cljs.core.get.call(null,inst_18162,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18165 = (function (){var data = inst_18140;
var _ = inst_18157;
var map__18135 = inst_18158;
var children = inst_18159;
var rhs = inst_18160;
var map__18136 = inst_18162;
var comparator = inst_18163;
return (function (idx,p__18164){
var map__18185 = p__18164;
var map__18185__$1 = cljs.core.__destructure_map.call(null,map__18185);
var child = map__18185__$1;
var id = cljs.core.get.call(null,map__18185__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__18185__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__18185__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__18185__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__18185__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4251__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (idx === (0));
} else {
return and__4251__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_18166 = cljs.core.map_indexed.call(null,inst_18165,inst_18159);
var inst_18167 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_18166);
var inst_18168 = cljs.core.interleave.call(null,inst_18167,inst_18166);
var inst_18169 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_18163,inst_18168);
var inst_18170 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_18160,inst_18169,config,leftmost_QMARK_);
var inst_18171 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18170);
var _ = (function (){var statearr_18186 = state_18176;
(statearr_18186[(4)] = cljs.core.rest.call(null,(state_18176[(4)])));

return statearr_18186;
})();
var state_18176__$1 = state_18176;
var statearr_18187_18210 = state_18176__$1;
(statearr_18187_18210[(2)] = inst_18171);

(statearr_18187_18210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (2))){
var _ = (function (){var statearr_18188 = state_18176;
(statearr_18188[(4)] = cljs.core.cons.call(null,(5),(state_18176[(4)])));

return statearr_18188;
})();
var inst_18137 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_18176__$1 = state_18176;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18176__$1,(6),inst_18137);
} else {
if((state_val_18177 === (11))){
var state_18176__$1 = state_18176;
var statearr_18190_18211 = state_18176__$1;
(statearr_18190_18211[(2)] = null);

(statearr_18190_18211[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (9))){
var inst_18140 = (state_18176[(9)]);
var inst_18151 = (state_18176[(2)]);
var inst_18152 = fluree.db.util.core.exception_QMARK_.call(null,inst_18140);
var state_18176__$1 = (function (){var statearr_18191 = state_18176;
(statearr_18191[(10)] = inst_18151);

return statearr_18191;
})();
if(inst_18152){
var statearr_18192_18212 = state_18176__$1;
(statearr_18192_18212[(1)] = (10));

} else {
var statearr_18193_18213 = state_18176__$1;
(statearr_18193_18213[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (5))){
var _ = (function (){var statearr_18194 = state_18176;
(statearr_18194[(4)] = cljs.core.rest.call(null,(state_18176[(4)])));

return statearr_18194;
})();
var state_18176__$1 = state_18176;
var ex18189 = (state_18176__$1[(2)]);
var statearr_18195_18214 = state_18176__$1;
(statearr_18195_18214[(5)] = ex18189);


var statearr_18196_18215 = state_18176__$1;
(statearr_18196_18215[(1)] = (4));

(statearr_18196_18215[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (10))){
var inst_18140 = (state_18176[(9)]);
var inst_18154 = (function(){throw inst_18140})();
var state_18176__$1 = state_18176;
var statearr_18197_18216 = state_18176__$1;
(statearr_18197_18216[(2)] = inst_18154);

(statearr_18197_18216[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (8))){
var state_18176__$1 = state_18176;
var statearr_18198_18217 = state_18176__$1;
(statearr_18198_18217[(2)] = null);

(statearr_18198_18217[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____0 = (function (){
var statearr_18199 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18199[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__);

(statearr_18199[(1)] = (1));

return statearr_18199;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____1 = (function (state_18176){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18176);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18200){var ex__2749__auto__ = e18200;
var statearr_18201_18218 = state_18176;
(statearr_18201_18218[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18176[(4)]))){
var statearr_18202_18219 = state_18176;
(statearr_18202_18219[(1)] = cljs.core.first.call(null,(state_18176[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18220 = state_18176;
state_18176 = G__18220;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__ = function(state_18176){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____1.call(this,state_18176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18203 = f__2769__auto__.call(null);
(statearr_18203[(6)] = c__2768__auto___18204);

return statearr_18203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18241){
var state_val_18242 = (state_18241[(1)]);
if((state_val_18242 === (7))){
var state_18241__$1 = state_18241;
var statearr_18243_18263 = state_18241__$1;
(statearr_18243_18263[(2)] = null);

(statearr_18243_18263[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18242 === (1))){
var state_18241__$1 = state_18241;
var statearr_18244_18264 = state_18241__$1;
(statearr_18244_18264[(2)] = null);

(statearr_18244_18264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18242 === (4))){
var inst_18221 = (state_18241[(2)]);
var state_18241__$1 = state_18241;
var statearr_18245_18265 = state_18241__$1;
(statearr_18245_18265[(2)] = inst_18221);

(statearr_18245_18265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18242 === (6))){
var inst_18227 = (state_18241[(7)]);
var inst_18229 = fluree.db.storage.core.serde.call(null,conn);
var state_18241__$1 = (function (){var statearr_18246 = state_18241;
(statearr_18246[(8)] = inst_18229);

return statearr_18246;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18241__$1,(9),inst_18227);
} else {
if((state_val_18242 === (3))){
var inst_18239 = (state_18241[(2)]);
var state_18241__$1 = state_18241;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18241__$1,inst_18239);
} else {
if((state_val_18242 === (2))){
var inst_18227 = (state_18241[(7)]);
var _ = (function (){var statearr_18248 = state_18241;
(statearr_18248[(4)] = cljs.core.cons.call(null,(5),(state_18241[(4)])));

return statearr_18248;
})();
var inst_18227__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_18241__$1 = (function (){var statearr_18249 = state_18241;
(statearr_18249[(7)] = inst_18227__$1);

return statearr_18249;
})();
if(cljs.core.truth_(inst_18227__$1)){
var statearr_18250_18266 = state_18241__$1;
(statearr_18250_18266[(1)] = (6));

} else {
var statearr_18251_18267 = state_18241__$1;
(statearr_18251_18267[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18242 === (9))){
var inst_18229 = (state_18241[(8)]);
var inst_18231 = (state_18241[(2)]);
var inst_18232 = fluree.db.util.async.throw_err.call(null,inst_18231);
var inst_18233 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_18229,inst_18232);
var state_18241__$1 = state_18241;
var statearr_18252_18268 = state_18241__$1;
(statearr_18252_18268[(2)] = inst_18233);

(statearr_18252_18268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18242 === (5))){
var _ = (function (){var statearr_18253 = state_18241;
(statearr_18253[(4)] = cljs.core.rest.call(null,(state_18241[(4)])));

return statearr_18253;
})();
var state_18241__$1 = state_18241;
var ex18247 = (state_18241__$1[(2)]);
var statearr_18254_18269 = state_18241__$1;
(statearr_18254_18269[(5)] = ex18247);


if((ex18247 instanceof Error)){
var statearr_18255_18270 = state_18241__$1;
(statearr_18255_18270[(1)] = (4));

(statearr_18255_18270[(5)] = null);

} else {
throw ex18247;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18242 === (8))){
var inst_18236 = (state_18241[(2)]);
var _ = (function (){var statearr_18256 = state_18241;
(statearr_18256[(4)] = cljs.core.rest.call(null,(state_18241[(4)])));

return statearr_18256;
})();
var state_18241__$1 = state_18241;
var statearr_18257_18271 = state_18241__$1;
(statearr_18257_18271[(2)] = inst_18236);

(statearr_18257_18271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_18258 = [null,null,null,null,null,null,null,null,null];
(statearr_18258[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__);

(statearr_18258[(1)] = (1));

return statearr_18258;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1 = (function (state_18241){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18241);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18259){var ex__2749__auto__ = e18259;
var statearr_18260_18272 = state_18241;
(statearr_18260_18272[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18241[(4)]))){
var statearr_18261_18273 = state_18241;
(statearr_18261_18273[(1)] = cljs.core.first.call(null,(state_18241[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18274 = state_18241;
state_18241 = G__18274;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__ = function(state_18241){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1.call(this,state_18241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18262 = f__2769__auto__.call(null);
(statearr_18262[(6)] = c__2768__auto__);

return statearr_18262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___18347 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18319){
var state_val_18320 = (state_18319[(1)]);
if((state_val_18320 === (7))){
var inst_18291 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18292 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18293 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18294 = cljs.core.PersistentHashMap.fromArrays(inst_18292,inst_18293);
var inst_18295 = cljs.core.ex_info.call(null,inst_18291,inst_18294);
var inst_18296 = (function(){throw inst_18295})();
var state_18319__$1 = state_18319;
var statearr_18321_18348 = state_18319__$1;
(statearr_18321_18348[(2)] = inst_18296);

(statearr_18321_18348[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18320 === (1))){
var state_18319__$1 = state_18319;
var statearr_18322_18349 = state_18319__$1;
(statearr_18322_18349[(2)] = null);

(statearr_18322_18349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18320 === (4))){
var inst_18275 = (state_18319[(2)]);
var inst_18276 = error_fn.call(null);
var inst_18277 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18275);
var inst_18278 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_18319__$1 = (function (){var statearr_18323 = state_18319;
(statearr_18323[(7)] = inst_18276);

(statearr_18323[(8)] = inst_18277);

return statearr_18323;
})();
var statearr_18324_18350 = state_18319__$1;
(statearr_18324_18350[(2)] = inst_18278);

(statearr_18324_18350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18320 === (6))){
var inst_18288 = (state_18319[(9)]);
var inst_18288__$1 = (state_18319[(2)]);
var inst_18289 = (inst_18288__$1 == null);
var state_18319__$1 = (function (){var statearr_18325 = state_18319;
(statearr_18325[(9)] = inst_18288__$1);

return statearr_18325;
})();
if(cljs.core.truth_(inst_18289)){
var statearr_18326_18351 = state_18319__$1;
(statearr_18326_18351[(1)] = (7));

} else {
var statearr_18327_18352 = state_18319__$1;
(statearr_18327_18352[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18320 === (3))){
var inst_18317 = (state_18319[(2)]);
var state_18319__$1 = state_18319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18319__$1,inst_18317);
} else {
if((state_val_18320 === (12))){
var inst_18288 = (state_18319[(9)]);
var inst_18305 = (state_18319[(2)]);
var inst_18306 = cljs.core.__destructure_map.call(null,inst_18288);
var inst_18307 = cljs.core.get.call(null,inst_18306,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18308 = cljs.core.get.call(null,inst_18306,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_18309 = config;
var inst_18310 = cljs.core.__destructure_map.call(null,inst_18309);
var inst_18311 = cljs.core.get.call(null,inst_18310,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18312 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_18311,inst_18307);
var inst_18313 = fluree.db.index.data_node.call(null,block,t,inst_18312,rhs,config);
var inst_18314 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18313);
var _ = (function (){var statearr_18328 = state_18319;
(statearr_18328[(4)] = cljs.core.rest.call(null,(state_18319[(4)])));

return statearr_18328;
})();
var state_18319__$1 = (function (){var statearr_18329 = state_18319;
(statearr_18329[(10)] = inst_18305);

(statearr_18329[(11)] = inst_18308);

return statearr_18329;
})();
var statearr_18330_18353 = state_18319__$1;
(statearr_18330_18353[(2)] = inst_18314);

(statearr_18330_18353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18320 === (2))){
var _ = (function (){var statearr_18331 = state_18319;
(statearr_18331[(4)] = cljs.core.cons.call(null,(5),(state_18319[(4)])));

return statearr_18331;
})();
var inst_18286 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_18319__$1 = state_18319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18319__$1,(6),inst_18286);
} else {
if((state_val_18320 === (11))){
var state_18319__$1 = state_18319;
var statearr_18333_18354 = state_18319__$1;
(statearr_18333_18354[(2)] = null);

(statearr_18333_18354[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18320 === (9))){
var inst_18288 = (state_18319[(9)]);
var inst_18299 = (state_18319[(2)]);
var inst_18300 = fluree.db.util.core.exception_QMARK_.call(null,inst_18288);
var state_18319__$1 = (function (){var statearr_18334 = state_18319;
(statearr_18334[(12)] = inst_18299);

return statearr_18334;
})();
if(inst_18300){
var statearr_18335_18355 = state_18319__$1;
(statearr_18335_18355[(1)] = (10));

} else {
var statearr_18336_18356 = state_18319__$1;
(statearr_18336_18356[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18320 === (5))){
var _ = (function (){var statearr_18337 = state_18319;
(statearr_18337[(4)] = cljs.core.rest.call(null,(state_18319[(4)])));

return statearr_18337;
})();
var state_18319__$1 = state_18319;
var ex18332 = (state_18319__$1[(2)]);
var statearr_18338_18357 = state_18319__$1;
(statearr_18338_18357[(5)] = ex18332);


var statearr_18339_18358 = state_18319__$1;
(statearr_18339_18358[(1)] = (4));

(statearr_18339_18358[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18320 === (10))){
var inst_18288 = (state_18319[(9)]);
var inst_18302 = (function(){throw inst_18288})();
var state_18319__$1 = state_18319;
var statearr_18340_18359 = state_18319__$1;
(statearr_18340_18359[(2)] = inst_18302);

(statearr_18340_18359[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18320 === (8))){
var state_18319__$1 = state_18319;
var statearr_18341_18360 = state_18319__$1;
(statearr_18341_18360[(2)] = null);

(statearr_18341_18360[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_18342 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18342[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__);

(statearr_18342[(1)] = (1));

return statearr_18342;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____1 = (function (state_18319){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18343){var ex__2749__auto__ = e18343;
var statearr_18344_18361 = state_18319;
(statearr_18344_18361[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18319[(4)]))){
var statearr_18345_18362 = state_18319;
(statearr_18345_18362[(1)] = cljs.core.first.call(null,(state_18319[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18363 = state_18319;
state_18319 = G__18363;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__ = function(state_18319){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____1.call(this,state_18319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18346 = f__2769__auto__.call(null);
(statearr_18346[(6)] = c__2768__auto___18347);

return statearr_18346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k18365,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__18369 = k18365;
var G__18369__$1 = (((G__18369 instanceof cljs.core.Keyword))?G__18369.fqn:null);
switch (G__18369__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k18365,else__4505__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__18370){
var vec__18371 = p__18370;
var k__4526__auto__ = cljs.core.nth.call(null,vec__18371,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__18371,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__18364){
var self__ = this;
var G__18364__$1 = this;
return (new cljs.core.RecordIter((0),G__18364__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this18366,other18367){
var self__ = this;
var this18366__$1 = this;
return (((!((other18367 == null)))) && ((((this18366__$1.constructor === other18367.constructor)) && (((cljs.core._EQ_.call(null,this18366__$1.conn,other18367.conn)) && (((cljs.core._EQ_.call(null,this18366__$1.config,other18367.config)) && (((cljs.core._EQ_.call(null,this18366__$1.network,other18367.network)) && (((cljs.core._EQ_.call(null,this18366__$1.dbid,other18367.dbid)) && (((cljs.core._EQ_.call(null,this18366__$1.id,other18367.id)) && (((cljs.core._EQ_.call(null,this18366__$1.leaf,other18367.leaf)) && (((cljs.core._EQ_.call(null,this18366__$1.first,other18367.first)) && (((cljs.core._EQ_.call(null,this18366__$1.rhs,other18367.rhs)) && (((cljs.core._EQ_.call(null,this18366__$1.size,other18367.size)) && (((cljs.core._EQ_.call(null,this18366__$1.block,other18367.block)) && (((cljs.core._EQ_.call(null,this18366__$1.t,other18367.t)) && (((cljs.core._EQ_.call(null,this18366__$1.tt_id,other18367.tt_id)) && (((cljs.core._EQ_.call(null,this18366__$1.leftmost_QMARK_,other18367.leftmost_QMARK_)) && (((cljs.core._EQ_.call(null,this18366__$1.tempid,other18367.tempid)) && (cljs.core._EQ_.call(null,this18366__$1.__extmap,other18367.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k18365){
var self__ = this;
var this__4509__auto____$1 = this;
var G__18374 = k18365;
var G__18374__$1 = (((G__18374 instanceof cljs.core.Keyword))?G__18374.fqn:null);
switch (G__18374__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k18365);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__18364){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__18375 = cljs.core.keyword_identical_QMARK_;
var expr__18376 = k__4511__auto__;
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(G__18364,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__18364,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__18364,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__18364,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__18364,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__18364,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__18364,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__18364,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__18364,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__18364,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__18364,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__18364,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__18364,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18375.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__18376))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__18364,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__18364),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__18364){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__18364,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__18368){
var extmap__4542__auto__ = (function (){var G__18378 = cljs.core.dissoc.call(null,G__18368,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__18368)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__18378);
} else {
return G__18378;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__18368),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__18368),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4253__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__18381 = blank_db;
var map__18381__$1 = cljs.core.__destructure_map.call(null,map__18381);
var network = cljs.core.get.call(null,map__18381__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__18381__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__18381__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__18382 = root_data;
var map__18382__$1 = cljs.core.__destructure_map.call(null,map__18382);
var block = cljs.core.get.call(null,map__18382__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__18382__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__18382__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__18382__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18404){
var state_val_18405 = (state_18404[(1)]);
if((state_val_18405 === (7))){
var state_18404__$1 = state_18404;
var statearr_18406_18426 = state_18404__$1;
(statearr_18406_18426[(2)] = null);

(statearr_18406_18426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18405 === (1))){
var state_18404__$1 = state_18404;
var statearr_18407_18427 = state_18404__$1;
(statearr_18407_18427[(2)] = null);

(statearr_18407_18427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18405 === (4))){
var inst_18383 = (state_18404[(2)]);
var state_18404__$1 = state_18404;
var statearr_18408_18428 = state_18404__$1;
(statearr_18408_18428[(2)] = inst_18383);

(statearr_18408_18428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18405 === (6))){
var inst_18390 = (state_18404[(7)]);
var inst_18392 = fluree.db.storage.core.serde.call(null,conn);
var state_18404__$1 = (function (){var statearr_18409 = state_18404;
(statearr_18409[(8)] = inst_18392);

return statearr_18409;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18404__$1,(9),inst_18390);
} else {
if((state_val_18405 === (3))){
var inst_18402 = (state_18404[(2)]);
var state_18404__$1 = state_18404;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18404__$1,inst_18402);
} else {
if((state_val_18405 === (2))){
var inst_18390 = (state_18404[(7)]);
var _ = (function (){var statearr_18411 = state_18404;
(statearr_18411[(4)] = cljs.core.cons.call(null,(5),(state_18404[(4)])));

return statearr_18411;
})();
var inst_18389 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_18390__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_18389);
var state_18404__$1 = (function (){var statearr_18412 = state_18404;
(statearr_18412[(7)] = inst_18390__$1);

return statearr_18412;
})();
if(cljs.core.truth_(inst_18390__$1)){
var statearr_18413_18429 = state_18404__$1;
(statearr_18413_18429[(1)] = (6));

} else {
var statearr_18414_18430 = state_18404__$1;
(statearr_18414_18430[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18405 === (9))){
var inst_18392 = (state_18404[(8)]);
var inst_18394 = (state_18404[(2)]);
var inst_18395 = fluree.db.util.async.throw_err.call(null,inst_18394);
var inst_18396 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_18392,inst_18395);
var state_18404__$1 = state_18404;
var statearr_18415_18431 = state_18404__$1;
(statearr_18415_18431[(2)] = inst_18396);

(statearr_18415_18431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18405 === (5))){
var _ = (function (){var statearr_18416 = state_18404;
(statearr_18416[(4)] = cljs.core.rest.call(null,(state_18404[(4)])));

return statearr_18416;
})();
var state_18404__$1 = state_18404;
var ex18410 = (state_18404__$1[(2)]);
var statearr_18417_18432 = state_18404__$1;
(statearr_18417_18432[(5)] = ex18410);


if((ex18410 instanceof Error)){
var statearr_18418_18433 = state_18404__$1;
(statearr_18418_18433[(1)] = (4));

(statearr_18418_18433[(5)] = null);

} else {
throw ex18410;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18405 === (8))){
var inst_18399 = (state_18404[(2)]);
var _ = (function (){var statearr_18419 = state_18404;
(statearr_18419[(4)] = cljs.core.rest.call(null,(state_18404[(4)])));

return statearr_18419;
})();
var state_18404__$1 = state_18404;
var statearr_18420_18434 = state_18404__$1;
(statearr_18420_18434[(2)] = inst_18399);

(statearr_18420_18434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0 = (function (){
var statearr_18421 = [null,null,null,null,null,null,null,null,null];
(statearr_18421[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__);

(statearr_18421[(1)] = (1));

return statearr_18421;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1 = (function (state_18404){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18404);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18422){var ex__2749__auto__ = e18422;
var statearr_18423_18435 = state_18404;
(statearr_18423_18435[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18404[(4)]))){
var statearr_18424_18436 = state_18404;
(statearr_18424_18436[(1)] = cljs.core.first.call(null,(state_18404[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18437 = state_18404;
state_18404 = G__18437;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__ = function(state_18404){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1.call(this,state_18404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18425 = f__2769__auto__.call(null);
(statearr_18425[(6)] = c__2768__auto__);

return statearr_18425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18459){
var state_val_18460 = (state_18459[(1)]);
if((state_val_18460 === (7))){
var inst_18448 = (state_18459[(7)]);
var inst_18450 = fluree.db.storage.core.serde.call(null,conn);
var inst_18451 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_18450,inst_18448);
var state_18459__$1 = state_18459;
var statearr_18461_18480 = state_18459__$1;
(statearr_18461_18480[(2)] = inst_18451);

(statearr_18461_18480[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18460 === (1))){
var state_18459__$1 = state_18459;
var statearr_18462_18481 = state_18459__$1;
(statearr_18462_18481[(2)] = null);

(statearr_18462_18481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18460 === (4))){
var inst_18438 = (state_18459[(2)]);
var state_18459__$1 = state_18459;
var statearr_18463_18482 = state_18459__$1;
(statearr_18463_18482[(2)] = inst_18438);

(statearr_18463_18482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18460 === (6))){
var inst_18448 = (state_18459[(7)]);
var inst_18447 = (state_18459[(2)]);
var inst_18448__$1 = fluree.db.util.async.throw_err.call(null,inst_18447);
var state_18459__$1 = (function (){var statearr_18464 = state_18459;
(statearr_18464[(7)] = inst_18448__$1);

return statearr_18464;
})();
if(cljs.core.truth_(inst_18448__$1)){
var statearr_18465_18483 = state_18459__$1;
(statearr_18465_18483[(1)] = (7));

} else {
var statearr_18466_18484 = state_18459__$1;
(statearr_18466_18484[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18460 === (3))){
var inst_18457 = (state_18459[(2)]);
var state_18459__$1 = state_18459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18459__$1,inst_18457);
} else {
if((state_val_18460 === (2))){
var _ = (function (){var statearr_18468 = state_18459;
(statearr_18468[(4)] = cljs.core.cons.call(null,(5),(state_18459[(4)])));

return statearr_18468;
})();
var inst_18444 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_18445 = fluree.db.storage.core.storage_read.call(null,conn,inst_18444);
var state_18459__$1 = state_18459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18459__$1,(6),inst_18445);
} else {
if((state_val_18460 === (9))){
var inst_18454 = (state_18459[(2)]);
var _ = (function (){var statearr_18469 = state_18459;
(statearr_18469[(4)] = cljs.core.rest.call(null,(state_18459[(4)])));

return statearr_18469;
})();
var state_18459__$1 = state_18459;
var statearr_18470_18485 = state_18459__$1;
(statearr_18470_18485[(2)] = inst_18454);

(statearr_18470_18485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18460 === (5))){
var _ = (function (){var statearr_18471 = state_18459;
(statearr_18471[(4)] = cljs.core.rest.call(null,(state_18459[(4)])));

return statearr_18471;
})();
var state_18459__$1 = state_18459;
var ex18467 = (state_18459__$1[(2)]);
var statearr_18472_18486 = state_18459__$1;
(statearr_18472_18486[(5)] = ex18467);


if((ex18467 instanceof Error)){
var statearr_18473_18487 = state_18459__$1;
(statearr_18473_18487[(1)] = (4));

(statearr_18473_18487[(5)] = null);

} else {
throw ex18467;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18460 === (8))){
var state_18459__$1 = state_18459;
var statearr_18474_18488 = state_18459__$1;
(statearr_18474_18488[(2)] = null);

(statearr_18474_18488[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0 = (function (){
var statearr_18475 = [null,null,null,null,null,null,null,null];
(statearr_18475[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__);

(statearr_18475[(1)] = (1));

return statearr_18475;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1 = (function (state_18459){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18476){var ex__2749__auto__ = e18476;
var statearr_18477_18489 = state_18459;
(statearr_18477_18489[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18459[(4)]))){
var statearr_18478_18490 = state_18459;
(statearr_18478_18490[(1)] = cljs.core.first.call(null,(state_18459[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18491 = state_18459;
state_18459 = G__18491;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__ = function(state_18459){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1.call(this,state_18459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18479 = f__2769__auto__.call(null);
(statearr_18479[(6)] = c__2768__auto__);

return statearr_18479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18527){
var state_val_18528 = (state_18527[(1)]);
if((state_val_18528 === (7))){
var inst_18501 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_18502 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18503 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_18504 = cljs.core.PersistentHashMap.fromArrays(inst_18502,inst_18503);
var inst_18505 = cljs.core.ex_info.call(null,inst_18501,inst_18504);
var inst_18506 = (function(){throw inst_18505})();
var state_18527__$1 = state_18527;
var statearr_18529_18551 = state_18527__$1;
(statearr_18529_18551[(2)] = inst_18506);

(statearr_18529_18551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18528 === (1))){
var state_18527__$1 = state_18527;
var statearr_18530_18552 = state_18527__$1;
(statearr_18530_18552[(2)] = null);

(statearr_18530_18552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18528 === (4))){
var inst_18492 = (state_18527[(2)]);
var state_18527__$1 = state_18527;
var statearr_18531_18553 = state_18527__$1;
(statearr_18531_18553[(2)] = inst_18492);

(statearr_18531_18553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18528 === (6))){
var state_18527__$1 = state_18527;
var statearr_18532_18554 = state_18527__$1;
(statearr_18532_18554[(2)] = null);

(statearr_18532_18554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18528 === (3))){
var inst_18525 = (state_18527[(2)]);
var state_18527__$1 = state_18527;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18527__$1,inst_18525);
} else {
if((state_val_18528 === (2))){
var inst_18498 = (state_18527[(7)]);
var _ = (function (){var statearr_18533 = state_18527;
(statearr_18533[(4)] = cljs.core.cons.call(null,(5),(state_18527[(4)])));

return statearr_18533;
})();
var inst_18498__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_18527__$1 = (function (){var statearr_18534 = state_18527;
(statearr_18534[(7)] = inst_18498__$1);

return statearr_18534;
})();
if(cljs.core.truth_(inst_18498__$1)){
var statearr_18535_18555 = state_18527__$1;
(statearr_18535_18555[(1)] = (6));

} else {
var statearr_18536_18556 = state_18527__$1;
(statearr_18536_18556[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18528 === (11))){
var inst_18517 = (state_18527[(8)]);
var inst_18520 = (state_18527[(2)]);
var inst_18521 = fluree.db.util.async.throw_err.call(null,inst_18520);
var inst_18522 = cljs.core.assoc.call(null,inst_18517,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_18521);
var _ = (function (){var statearr_18538 = state_18527;
(statearr_18538[(4)] = cljs.core.rest.call(null,(state_18527[(4)])));

return statearr_18538;
})();
var state_18527__$1 = state_18527;
var statearr_18539_18557 = state_18527__$1;
(statearr_18539_18557[(2)] = inst_18522);

(statearr_18539_18557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18528 === (9))){
var inst_18512 = (state_18527[(9)]);
var inst_18510 = (state_18527[(2)]);
var inst_18511 = fluree.db.util.async.throw_err.call(null,inst_18510);
var inst_18512__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_18511);
var inst_18513 = fluree.db.query.schema.schema_map.call(null,inst_18512__$1);
var state_18527__$1 = (function (){var statearr_18540 = state_18527;
(statearr_18540[(9)] = inst_18512__$1);

return statearr_18540;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18527__$1,(10),inst_18513);
} else {
if((state_val_18528 === (5))){
var _ = (function (){var statearr_18541 = state_18527;
(statearr_18541[(4)] = cljs.core.rest.call(null,(state_18527[(4)])));

return statearr_18541;
})();
var state_18527__$1 = state_18527;
var ex18537 = (state_18527__$1[(2)]);
var statearr_18542_18558 = state_18527__$1;
(statearr_18542_18558[(5)] = ex18537);


if((ex18537 instanceof Error)){
var statearr_18543_18559 = state_18527__$1;
(statearr_18543_18559[(1)] = (4));

(statearr_18543_18559[(5)] = null);

} else {
throw ex18537;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18528 === (10))){
var inst_18517 = (state_18527[(8)]);
var inst_18512 = (state_18527[(9)]);
var inst_18515 = (state_18527[(2)]);
var inst_18516 = fluree.db.util.async.throw_err.call(null,inst_18515);
var inst_18517__$1 = cljs.core.assoc.call(null,inst_18512,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_18516);
var inst_18518 = fluree.db.query.schema.setting_map.call(null,inst_18517__$1);
var state_18527__$1 = (function (){var statearr_18544 = state_18527;
(statearr_18544[(8)] = inst_18517__$1);

return statearr_18544;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18527__$1,(11),inst_18518);
} else {
if((state_val_18528 === (8))){
var inst_18498 = (state_18527[(7)]);
var inst_18508 = (state_18527[(2)]);
var state_18527__$1 = (function (){var statearr_18545 = state_18527;
(statearr_18545[(10)] = inst_18508);

return statearr_18545;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18527__$1,(9),inst_18498);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0 = (function (){
var statearr_18546 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18546[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2746__auto__);

(statearr_18546[(1)] = (1));

return statearr_18546;
});
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1 = (function (state_18527){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18527);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18547){var ex__2749__auto__ = e18547;
var statearr_18548_18560 = state_18527;
(statearr_18548_18560[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18527[(4)]))){
var statearr_18549_18561 = state_18527;
(statearr_18549_18561[(1)] = cljs.core.first.call(null,(state_18527[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18562 = state_18527;
state_18527 = G__18562;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__ = function(state_18527){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1.call(this,state_18527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18550 = f__2769__auto__.call(null);
(statearr_18550[(6)] = c__2768__auto__);

return statearr_18550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__18564 = arguments.length;
switch (G__18564) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18617){
var state_val_18618 = (state_18617[(1)]);
if((state_val_18618 === (7))){
var inst_18574 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_18575 = (new Error(inst_18574));
var inst_18576 = (function(){throw inst_18575})();
var state_18617__$1 = state_18617;
var statearr_18619_18659 = state_18617__$1;
(statearr_18619_18659[(2)] = inst_18576);

(statearr_18619_18659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (20))){
var inst_18608 = (state_18617[(2)]);
var state_18617__$1 = state_18617;
var statearr_18620_18660 = state_18617__$1;
(statearr_18620_18660[(2)] = inst_18608);

(statearr_18620_18660[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (1))){
var state_18617__$1 = state_18617;
var statearr_18621_18661 = state_18617__$1;
(statearr_18621_18661[(2)] = null);

(statearr_18621_18661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (4))){
var inst_18565 = (state_18617[(2)]);
var state_18617__$1 = state_18617;
var statearr_18622_18662 = state_18617__$1;
(statearr_18622_18662[(2)] = inst_18565);

(statearr_18622_18662[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (15))){
var inst_18583 = (state_18617[(7)]);
var state_18617__$1 = state_18617;
var statearr_18623_18663 = state_18617__$1;
(statearr_18623_18663[(2)] = inst_18583);

(statearr_18623_18663[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (21))){
var inst_18582 = (state_18617[(8)]);
var inst_18583 = (state_18617[(7)]);
var inst_18587 = (state_18617[(9)]);
var inst_18601 = (inst_18582 + (1));
var inst_18602 = cljs.core.conj.call(null,inst_18583,inst_18587);
var inst_18582__$1 = inst_18601;
var inst_18583__$1 = inst_18602;
var state_18617__$1 = (function (){var statearr_18624 = state_18617;
(statearr_18624[(8)] = inst_18582__$1);

(statearr_18624[(7)] = inst_18583__$1);

return statearr_18624;
})();
var statearr_18625_18664 = state_18617__$1;
(statearr_18625_18664[(2)] = null);

(statearr_18625_18664[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (13))){
var inst_18587 = (state_18617[(9)]);
var inst_18591 = (inst_18587 instanceof Error);
var state_18617__$1 = state_18617;
var statearr_18626_18665 = state_18617__$1;
(statearr_18626_18665[(2)] = inst_18591);

(statearr_18626_18665[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (22))){
var state_18617__$1 = state_18617;
var statearr_18627_18666 = state_18617__$1;
(statearr_18627_18666[(2)] = null);

(statearr_18627_18666[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (6))){
var state_18617__$1 = state_18617;
var statearr_18628_18667 = state_18617__$1;
(statearr_18628_18667[(2)] = null);

(statearr_18628_18667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (17))){
var inst_18610 = (state_18617[(2)]);
var state_18617__$1 = state_18617;
var statearr_18629_18668 = state_18617__$1;
(statearr_18629_18668[(2)] = inst_18610);

(statearr_18629_18668[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (3))){
var inst_18615 = (state_18617[(2)]);
var state_18617__$1 = state_18617;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18617__$1,inst_18615);
} else {
if((state_val_18618 === (12))){
var inst_18588 = (state_18617[(10)]);
var state_18617__$1 = state_18617;
var statearr_18630_18669 = state_18617__$1;
(statearr_18630_18669[(2)] = inst_18588);

(statearr_18630_18669[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (2))){
var _ = (function (){var statearr_18631 = state_18617;
(statearr_18631[(4)] = cljs.core.cons.call(null,(5),(state_18617[(4)])));

return statearr_18631;
})();
var inst_18571 = (end >= start);
var state_18617__$1 = state_18617;
if(cljs.core.truth_(inst_18571)){
var statearr_18632_18670 = state_18617__$1;
(statearr_18632_18670[(1)] = (6));

} else {
var statearr_18633_18671 = state_18617__$1;
(statearr_18633_18671[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (23))){
var inst_18606 = (state_18617[(2)]);
var state_18617__$1 = state_18617;
var statearr_18634_18672 = state_18617__$1;
(statearr_18634_18672[(2)] = inst_18606);

(statearr_18634_18672[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (19))){
var state_18617__$1 = state_18617;
var statearr_18635_18673 = state_18617__$1;
(statearr_18635_18673[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (11))){
var inst_18588 = (state_18617[(10)]);
var inst_18587 = (state_18617[(9)]);
var inst_18587__$1 = (state_18617[(2)]);
var inst_18588__$1 = (inst_18587__$1 == null);
var state_18617__$1 = (function (){var statearr_18638 = state_18617;
(statearr_18638[(10)] = inst_18588__$1);

(statearr_18638[(9)] = inst_18587__$1);

return statearr_18638;
})();
if(cljs.core.truth_(inst_18588__$1)){
var statearr_18639_18674 = state_18617__$1;
(statearr_18639_18674[(1)] = (12));

} else {
var statearr_18640_18675 = state_18617__$1;
(statearr_18640_18675[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (9))){
var inst_18582 = (state_18617[(8)]);
var inst_18585 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_18582);
var state_18617__$1 = state_18617;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18617__$1,(11),inst_18585);
} else {
if((state_val_18618 === (5))){
var _ = (function (){var statearr_18641 = state_18617;
(statearr_18641[(4)] = cljs.core.rest.call(null,(state_18617[(4)])));

return statearr_18641;
})();
var state_18617__$1 = state_18617;
var ex18637 = (state_18617__$1[(2)]);
var statearr_18642_18676 = state_18617__$1;
(statearr_18642_18676[(5)] = ex18637);


if((ex18637 instanceof Error)){
var statearr_18643_18677 = state_18617__$1;
(statearr_18643_18677[(1)] = (4));

(statearr_18643_18677[(5)] = null);

} else {
throw ex18637;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (14))){
var inst_18593 = (state_18617[(2)]);
var state_18617__$1 = state_18617;
if(cljs.core.truth_(inst_18593)){
var statearr_18644_18678 = state_18617__$1;
(statearr_18644_18678[(1)] = (15));

} else {
var statearr_18645_18679 = state_18617__$1;
(statearr_18645_18679[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (16))){
var inst_18582 = (state_18617[(8)]);
var inst_18596 = cljs.core._EQ_.call(null,inst_18582,end);
var state_18617__$1 = state_18617;
if(inst_18596){
var statearr_18646_18680 = state_18617__$1;
(statearr_18646_18680[(1)] = (18));

} else {
var statearr_18647_18681 = state_18617__$1;
(statearr_18647_18681[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (10))){
var inst_18612 = (state_18617[(2)]);
var _ = (function (){var statearr_18648 = state_18617;
(statearr_18648[(4)] = cljs.core.rest.call(null,(state_18617[(4)])));

return statearr_18648;
})();
var state_18617__$1 = state_18617;
var statearr_18649_18682 = state_18617__$1;
(statearr_18649_18682[(2)] = inst_18612);

(statearr_18649_18682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (18))){
var inst_18583 = (state_18617[(7)]);
var inst_18587 = (state_18617[(9)]);
var inst_18598 = cljs.core.conj.call(null,inst_18583,inst_18587);
var state_18617__$1 = state_18617;
var statearr_18650_18683 = state_18617__$1;
(statearr_18650_18683[(2)] = inst_18598);

(statearr_18650_18683[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18618 === (8))){
var inst_18578 = (state_18617[(2)]);
var inst_18579 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18580 = start;
var inst_18581 = cljs.core.PersistentVector.EMPTY;
var inst_18582 = inst_18580;
var inst_18583 = inst_18581;
var state_18617__$1 = (function (){var statearr_18651 = state_18617;
(statearr_18651[(8)] = inst_18582);

(statearr_18651[(7)] = inst_18583);

(statearr_18651[(11)] = inst_18579);

(statearr_18651[(12)] = inst_18578);

return statearr_18651;
})();
var statearr_18652_18684 = state_18617__$1;
(statearr_18652_18684[(2)] = null);

(statearr_18652_18684[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_18653 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18653[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_18653[(1)] = (1));

return statearr_18653;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_18617){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18617);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18654){var ex__2749__auto__ = e18654;
var statearr_18655_18685 = state_18617;
(statearr_18655_18685[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18617[(4)]))){
var statearr_18656_18686 = state_18617;
(statearr_18656_18686[(1)] = cljs.core.first.call(null,(state_18617[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18687 = state_18617;
state_18617 = G__18687;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_18617){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_18617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18657 = f__2769__auto__.call(null);
(statearr_18657[(6)] = c__2768__auto__);

return statearr_18657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18703){
var state_val_18704 = (state_18703[(1)]);
if((state_val_18704 === (1))){
var state_18703__$1 = state_18703;
var statearr_18705_18719 = state_18703__$1;
(statearr_18705_18719[(2)] = null);

(statearr_18705_18719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18704 === (2))){
var _ = (function (){var statearr_18706 = state_18703;
(statearr_18706[(4)] = cljs.core.cons.call(null,(5),(state_18703[(4)])));

return statearr_18706;
})();
var inst_18694 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_18703__$1 = state_18703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18703__$1,(6),inst_18694);
} else {
if((state_val_18704 === (3))){
var inst_18701 = (state_18703[(2)]);
var state_18703__$1 = state_18703;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18703__$1,inst_18701);
} else {
if((state_val_18704 === (4))){
var inst_18688 = (state_18703[(2)]);
var state_18703__$1 = state_18703;
var statearr_18708_18720 = state_18703__$1;
(statearr_18708_18720[(2)] = inst_18688);

(statearr_18708_18720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18704 === (5))){
var _ = (function (){var statearr_18709 = state_18703;
(statearr_18709[(4)] = cljs.core.rest.call(null,(state_18703[(4)])));

return statearr_18709;
})();
var state_18703__$1 = state_18703;
var ex18707 = (state_18703__$1[(2)]);
var statearr_18710_18721 = state_18703__$1;
(statearr_18710_18721[(5)] = ex18707);


if((ex18707 instanceof Error)){
var statearr_18711_18722 = state_18703__$1;
(statearr_18711_18722[(1)] = (4));

(statearr_18711_18722[(5)] = null);

} else {
throw ex18707;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18704 === (6))){
var inst_18696 = (state_18703[(2)]);
var inst_18697 = fluree.db.util.async.throw_err.call(null,inst_18696);
var inst_18698 = cljs.core.first.call(null,inst_18697);
var _ = (function (){var statearr_18712 = state_18703;
(statearr_18712[(4)] = cljs.core.rest.call(null,(state_18703[(4)])));

return statearr_18712;
})();
var state_18703__$1 = state_18703;
var statearr_18713_18723 = state_18703__$1;
(statearr_18713_18723[(2)] = inst_18698);

(statearr_18713_18723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2746__auto____0 = (function (){
var statearr_18714 = [null,null,null,null,null,null,null];
(statearr_18714[(0)] = fluree$db$storage$core$block_$_state_machine__2746__auto__);

(statearr_18714[(1)] = (1));

return statearr_18714;
});
var fluree$db$storage$core$block_$_state_machine__2746__auto____1 = (function (state_18703){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18715){var ex__2749__auto__ = e18715;
var statearr_18716_18724 = state_18703;
(statearr_18716_18724[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18703[(4)]))){
var statearr_18717_18725 = state_18703;
(statearr_18717_18725[(1)] = cljs.core.first.call(null,(state_18703[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18726 = state_18703;
state_18703 = G__18726;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2746__auto__ = function(state_18703){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2746__auto____1.call(this,state_18703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2746__auto____0;
fluree$db$storage$core$block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18718 = f__2769__auto__.call(null);
(statearr_18718[(6)] = c__2768__auto__);

return statearr_18718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
