// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15843){
var state_val_15844 = (state_15843[(1)]);
if((state_val_15844 === (1))){
var state_15843__$1 = state_15843;
var statearr_15845_15859 = state_15843__$1;
(statearr_15845_15859[(2)] = null);

(statearr_15845_15859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15844 === (2))){
var _ = (function (){var statearr_15846 = state_15843;
(statearr_15846[(4)] = cljs.core.cons.call(null,(5),(state_15843[(4)])));

return statearr_15846;
})();
var inst_15834 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_15843__$1 = state_15843;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15843__$1,(6),inst_15834);
} else {
if((state_val_15844 === (3))){
var inst_15841 = (state_15843[(2)]);
var state_15843__$1 = state_15843;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15843__$1,inst_15841);
} else {
if((state_val_15844 === (4))){
var inst_15828 = (state_15843[(2)]);
var state_15843__$1 = state_15843;
var statearr_15848_15860 = state_15843__$1;
(statearr_15848_15860[(2)] = inst_15828);

(statearr_15848_15860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15844 === (5))){
var _ = (function (){var statearr_15849 = state_15843;
(statearr_15849[(4)] = cljs.core.rest.call(null,(state_15843[(4)])));

return statearr_15849;
})();
var state_15843__$1 = state_15843;
var ex15847 = (state_15843__$1[(2)]);
var statearr_15850_15861 = state_15843__$1;
(statearr_15850_15861[(5)] = ex15847);


if((ex15847 instanceof Error)){
var statearr_15851_15862 = state_15843__$1;
(statearr_15851_15862[(1)] = (4));

(statearr_15851_15862[(5)] = null);

} else {
throw ex15847;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15844 === (6))){
var inst_15836 = (state_15843[(2)]);
var inst_15837 = fluree.db.util.async.throw_err.call(null,inst_15836);
var inst_15838 = cljs.core.keyword.call(null,inst_15837);
var _ = (function (){var statearr_15852 = state_15843;
(statearr_15852[(4)] = cljs.core.rest.call(null,(state_15843[(4)])));

return statearr_15852;
})();
var state_15843__$1 = state_15843;
var statearr_15853_15863 = state_15843__$1;
(statearr_15853_15863[(2)] = inst_15838);

(statearr_15853_15863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0 = (function (){
var statearr_15854 = [null,null,null,null,null,null,null];
(statearr_15854[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__);

(statearr_15854[(1)] = (1));

return statearr_15854;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1 = (function (state_15843){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15843);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15855){var ex__2749__auto__ = e15855;
var statearr_15856_15864 = state_15843;
(statearr_15856_15864[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15843[(4)]))){
var statearr_15857_15865 = state_15843;
(statearr_15857_15865[(1)] = cljs.core.first.call(null,(state_15843[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15866 = state_15843;
state_15843 = G__15866;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__ = function(state_15843){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1.call(this,state_15843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15858 = f__2769__auto__.call(null);
(statearr_15858[(6)] = c__2768__auto__);

return statearr_15858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15898){
var state_val_15899 = (state_15898[(1)]);
if((state_val_15899 === (7))){
var inst_15882 = (state_15898[(7)]);
var inst_15884 = cljs.core.empty_QMARK_.call(null,inst_15882);
var inst_15885 = (!(inst_15884));
var state_15898__$1 = state_15898;
var statearr_15900_15924 = state_15898__$1;
(statearr_15900_15924[(2)] = inst_15885);

(statearr_15900_15924[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15899 === (1))){
var state_15898__$1 = state_15898;
var statearr_15901_15925 = state_15898__$1;
(statearr_15901_15925[(2)] = null);

(statearr_15901_15925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15899 === (4))){
var inst_15868 = (state_15898[(2)]);
var state_15898__$1 = state_15898;
var statearr_15902_15926 = state_15898__$1;
(statearr_15902_15926[(2)] = inst_15868);

(statearr_15902_15926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15899 === (6))){
var inst_15882 = (state_15898[(7)]);
var inst_15874 = (state_15898[(8)]);
var inst_15880 = (state_15898[(2)]);
var inst_15881 = fluree.db.util.async.throw_err.call(null,inst_15880);
var inst_15882__$1 = cljs.core.map.call(null,inst_15874,inst_15881);
var state_15898__$1 = (function (){var statearr_15903 = state_15898;
(statearr_15903[(7)] = inst_15882__$1);

return statearr_15903;
})();
if(cljs.core.truth_(inst_15882__$1)){
var statearr_15904_15927 = state_15898__$1;
(statearr_15904_15927[(1)] = (7));

} else {
var statearr_15905_15928 = state_15898__$1;
(statearr_15905_15928[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15899 === (3))){
var inst_15896 = (state_15898[(2)]);
var state_15898__$1 = state_15898;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15898__$1,inst_15896);
} else {
if((state_val_15899 === (12))){
var inst_15893 = (state_15898[(2)]);
var _ = (function (){var statearr_15906 = state_15898;
(statearr_15906[(4)] = cljs.core.rest.call(null,(state_15898[(4)])));

return statearr_15906;
})();
var state_15898__$1 = state_15898;
var statearr_15907_15929 = state_15898__$1;
(statearr_15907_15929[(2)] = inst_15893);

(statearr_15907_15929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15899 === (2))){
var _ = (function (){var statearr_15908 = state_15898;
(statearr_15908[(4)] = cljs.core.cons.call(null,(5),(state_15898[(4)])));

return statearr_15908;
})();
var inst_15874 = (function (){return (function (p1__15867_SHARP_){
return p1__15867_SHARP_.o;
});
})();
var inst_15875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15876 = [pred_id];
var inst_15877 = (new cljs.core.PersistentVector(null,1,(5),inst_15875,inst_15876,null));
var inst_15878 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15877);
var state_15898__$1 = (function (){var statearr_15909 = state_15898;
(statearr_15909[(8)] = inst_15874);

return statearr_15909;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15898__$1,(6),inst_15878);
} else {
if((state_val_15899 === (11))){
var state_15898__$1 = state_15898;
var statearr_15911_15930 = state_15898__$1;
(statearr_15911_15930[(2)] = true);

(statearr_15911_15930[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15899 === (9))){
var inst_15888 = (state_15898[(2)]);
var state_15898__$1 = state_15898;
if(cljs.core.truth_(inst_15888)){
var statearr_15912_15931 = state_15898__$1;
(statearr_15912_15931[(1)] = (10));

} else {
var statearr_15913_15932 = state_15898__$1;
(statearr_15913_15932[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15899 === (5))){
var _ = (function (){var statearr_15914 = state_15898;
(statearr_15914[(4)] = cljs.core.rest.call(null,(state_15898[(4)])));

return statearr_15914;
})();
var state_15898__$1 = state_15898;
var ex15910 = (state_15898__$1[(2)]);
var statearr_15915_15933 = state_15898__$1;
(statearr_15915_15933[(5)] = ex15910);


if((ex15910 instanceof Error)){
var statearr_15916_15934 = state_15898__$1;
(statearr_15916_15934[(1)] = (4));

(statearr_15916_15934[(5)] = null);

} else {
throw ex15910;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15899 === (10))){
var inst_15882 = (state_15898[(7)]);
var inst_15890 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_15882);
var state_15898__$1 = state_15898;
var statearr_15917_15935 = state_15898__$1;
(statearr_15917_15935[(2)] = inst_15890);

(statearr_15917_15935[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15899 === (8))){
var inst_15882 = (state_15898[(7)]);
var state_15898__$1 = state_15898;
var statearr_15918_15936 = state_15898__$1;
(statearr_15918_15936[(2)] = inst_15882);

(statearr_15918_15936[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_15919 = [null,null,null,null,null,null,null,null,null];
(statearr_15919[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__);

(statearr_15919[(1)] = (1));

return statearr_15919;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1 = (function (state_15898){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15898);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15920){var ex__2749__auto__ = e15920;
var statearr_15921_15937 = state_15898;
(statearr_15921_15937[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15898[(4)]))){
var statearr_15922_15938 = state_15898;
(statearr_15922_15938[(1)] = cljs.core.first.call(null,(state_15898[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15939 = state_15898;
state_15898 = G__15939;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__ = function(state_15898){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1.call(this,state_15898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15923 = f__2769__auto__.call(null);
(statearr_15923[(6)] = c__2768__auto__);

return statearr_15923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16020){
var state_val_16021 = (state_16020[(1)]);
if((state_val_16021 === (7))){
var state_16020__$1 = state_16020;
var statearr_16022_16059 = state_16020__$1;
(statearr_16022_16059[(2)] = flakes);

(statearr_16022_16059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (20))){
var inst_15977 = (state_16020[(7)]);
var inst_16010 = (state_16020[(2)]);
var inst_15969 = inst_15977;
var inst_15970 = inst_16010;
var state_16020__$1 = (function (){var statearr_16023 = state_16020;
(statearr_16023[(8)] = inst_15970);

(statearr_16023[(9)] = inst_15969);

return statearr_16023;
})();
var statearr_16024_16060 = state_16020__$1;
(statearr_16024_16060[(2)] = null);

(statearr_16024_16060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (1))){
var state_16020__$1 = state_16020;
var statearr_16025_16061 = state_16020__$1;
(statearr_16025_16061[(2)] = null);

(statearr_16025_16061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (4))){
var inst_15942 = (state_16020[(2)]);
var state_16020__$1 = state_16020;
var statearr_16026_16062 = state_16020__$1;
(statearr_16026_16062[(2)] = inst_15942);

(statearr_16026_16062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (15))){
var inst_15976 = (state_16020[(10)]);
var inst_15994 = inst_15976.o;
var state_16020__$1 = state_16020;
var statearr_16027_16063 = state_16020__$1;
(statearr_16027_16063[(2)] = inst_15994);

(statearr_16027_16063[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (13))){
var inst_16013 = (state_16020[(2)]);
var state_16020__$1 = state_16020;
var statearr_16028_16064 = state_16020__$1;
(statearr_16028_16064[(2)] = inst_16013);

(statearr_16028_16064[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (6))){
var inst_15949 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16020__$1 = state_16020;
var statearr_16029_16065 = state_16020__$1;
(statearr_16029_16065[(2)] = inst_15949);

(statearr_16029_16065[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (17))){
var inst_15991 = (state_16020[(2)]);
var inst_15992 = fluree.db.util.async.throw_err.call(null,inst_15991);
var state_16020__$1 = state_16020;
var statearr_16030_16066 = state_16020__$1;
(statearr_16030_16066[(2)] = inst_15992);

(statearr_16030_16066[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (3))){
var inst_16018 = (state_16020[(2)]);
var state_16020__$1 = state_16020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16020__$1,inst_16018);
} else {
if((state_val_16021 === (12))){
var inst_15976 = (state_16020[(10)]);
var inst_15983 = (state_16020[(11)]);
var inst_15981 = inst_15976.p;
var inst_15982 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15981);
var inst_15983__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_15982);
var inst_15984 = inst_15976.op;
var inst_15985 = inst_15984 === false;
var inst_15986 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_15983__$1);
var state_16020__$1 = (function (){var statearr_16031 = state_16020;
(statearr_16031[(12)] = inst_15985);

(statearr_16031[(11)] = inst_15983__$1);

return statearr_16031;
})();
if(inst_15986){
var statearr_16032_16067 = state_16020__$1;
(statearr_16032_16067[(1)] = (14));

} else {
var statearr_16033_16068 = state_16020__$1;
(statearr_16033_16068[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (2))){
var _ = (function (){var statearr_16034 = state_16020;
(statearr_16034[(4)] = cljs.core.cons.call(null,(5),(state_16020[(4)])));

return statearr_16034;
})();
var state_16020__$1 = state_16020;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16035_16069 = state_16020__$1;
(statearr_16035_16069[(1)] = (6));

} else {
var statearr_16036_16070 = state_16020__$1;
(statearr_16036_16070[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (19))){
var inst_15970 = (state_16020[(8)]);
var inst_15976 = (state_16020[(10)]);
var inst_15996 = (state_16020[(13)]);
var inst_15983 = (state_16020[(11)]);
var inst_16004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16005 = inst_15976.s;
var inst_16006 = [inst_16005,inst_15983,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16007 = (new cljs.core.PersistentVector(null,3,(5),inst_16004,inst_16006,null));
var inst_16008 = cljs.core.assoc_in.call(null,inst_15970,inst_16007,inst_15996);
var state_16020__$1 = state_16020;
var statearr_16037_16071 = state_16020__$1;
(statearr_16037_16071[(2)] = inst_16008);

(statearr_16037_16071[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (11))){
var inst_15970 = (state_16020[(8)]);
var state_16020__$1 = state_16020;
var statearr_16039_16072 = state_16020__$1;
(statearr_16039_16072[(2)] = inst_15970);

(statearr_16039_16072[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (9))){
var inst_15976 = (state_16020[(10)]);
var inst_15969 = (state_16020[(9)]);
var inst_15975 = cljs.core.seq.call(null,inst_15969);
var inst_15976__$1 = cljs.core.first.call(null,inst_15975);
var inst_15977 = cljs.core.next.call(null,inst_15975);
var inst_15978 = cljs.core.not.call(null,inst_15976__$1);
var state_16020__$1 = (function (){var statearr_16040 = state_16020;
(statearr_16040[(7)] = inst_15977);

(statearr_16040[(10)] = inst_15976__$1);

return statearr_16040;
})();
if(inst_15978){
var statearr_16041_16073 = state_16020__$1;
(statearr_16041_16073[(1)] = (11));

} else {
var statearr_16042_16074 = state_16020__$1;
(statearr_16042_16074[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (5))){
var _ = (function (){var statearr_16043 = state_16020;
(statearr_16043[(4)] = cljs.core.rest.call(null,(state_16020[(4)])));

return statearr_16043;
})();
var state_16020__$1 = state_16020;
var ex16038 = (state_16020__$1[(2)]);
var statearr_16044_16075 = state_16020__$1;
(statearr_16044_16075[(5)] = ex16038);


if((ex16038 instanceof Error)){
var statearr_16045_16076 = state_16020__$1;
(statearr_16045_16076[(1)] = (4));

(statearr_16045_16076[(5)] = null);

} else {
throw ex16038;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (14))){
var inst_15976 = (state_16020[(10)]);
var inst_15988 = inst_15976.o;
var inst_15989 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_15988,db);
var state_16020__$1 = state_16020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16020__$1,(17),inst_15989);
} else {
if((state_val_16021 === (16))){
var inst_15985 = (state_16020[(12)]);
var inst_15996 = (state_16020[(2)]);
var state_16020__$1 = (function (){var statearr_16046 = state_16020;
(statearr_16046[(13)] = inst_15996);

return statearr_16046;
})();
if(cljs.core.truth_(inst_15985)){
var statearr_16047_16077 = state_16020__$1;
(statearr_16047_16077[(1)] = (18));

} else {
var statearr_16048_16078 = state_16020__$1;
(statearr_16048_16078[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (10))){
var inst_16015 = (state_16020[(2)]);
var _ = (function (){var statearr_16049 = state_16020;
(statearr_16049[(4)] = cljs.core.rest.call(null,(state_16020[(4)])));

return statearr_16049;
})();
var state_16020__$1 = state_16020;
var statearr_16050_16079 = state_16020__$1;
(statearr_16050_16079[(2)] = inst_16015);

(statearr_16050_16079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (18))){
var inst_15970 = (state_16020[(8)]);
var inst_15976 = (state_16020[(10)]);
var inst_15996 = (state_16020[(13)]);
var inst_15983 = (state_16020[(11)]);
var inst_15998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15999 = inst_15976.s;
var inst_16000 = [inst_15999,inst_15983,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16001 = (new cljs.core.PersistentVector(null,3,(5),inst_15998,inst_16000,null));
var inst_16002 = cljs.core.assoc_in.call(null,inst_15970,inst_16001,inst_15996);
var state_16020__$1 = state_16020;
var statearr_16051_16080 = state_16020__$1;
(statearr_16051_16080[(2)] = inst_16002);

(statearr_16051_16080[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16021 === (8))){
var inst_15952 = (state_16020[(2)]);
var inst_15953 = cljs.core.PersistentHashSet.EMPTY;
var inst_15954 = cljs.core.vals.call(null,tempids);
var inst_15955 = cljs.core.into.call(null,inst_15953,inst_15954);
var inst_15956 = (function (){var pred_flakes = inst_15952;
var is_new_QMARK_ = inst_15955;
return (function (p1__15941_SHARP_,p2__15940_SHARP_){
var f = p2__15940_SHARP_;
return cljs.core.assoc_in.call(null,p1__15941_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,f.s)));
});
})();
var inst_15957 = cljs.core.PersistentHashMap.EMPTY;
var inst_15958 = cljs.core.reduce.call(null,inst_15956,inst_15957,inst_15952);
var inst_15966 = cljs.core.seq.call(null,inst_15952);
var inst_15967 = cljs.core.first.call(null,inst_15966);
var inst_15968 = cljs.core.next.call(null,inst_15966);
var inst_15969 = inst_15952;
var inst_15970 = inst_15958;
var state_16020__$1 = (function (){var statearr_16052 = state_16020;
(statearr_16052[(8)] = inst_15970);

(statearr_16052[(9)] = inst_15969);

(statearr_16052[(14)] = inst_15968);

(statearr_16052[(15)] = inst_15967);

return statearr_16052;
})();
var statearr_16053_16081 = state_16020__$1;
(statearr_16053_16081[(2)] = null);

(statearr_16053_16081[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0 = (function (){
var statearr_16054 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16054[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__);

(statearr_16054[(1)] = (1));

return statearr_16054;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1 = (function (state_16020){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16055){var ex__2749__auto__ = e16055;
var statearr_16056_16082 = state_16020;
(statearr_16056_16082[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16020[(4)]))){
var statearr_16057_16083 = state_16020;
(statearr_16057_16083[(1)] = cljs.core.first.call(null,(state_16020[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16084 = state_16020;
state_16020 = G__16084;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__ = function(state_16020){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1.call(this,state_16020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16058 = f__2769__auto__.call(null);
(statearr_16058[(6)] = c__2768__auto__);

return statearr_16058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16086 = arguments.length;
switch (G__16086) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16089 = arguments.length;
switch (G__16089) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16401){
var state_val_16402 = (state_16401[(1)]);
if((state_val_16402 === (121))){
var inst_16356 = (state_16401[(7)]);
var state_16401__$1 = state_16401;
var statearr_16403_16596 = state_16401__$1;
(statearr_16403_16596[(2)] = inst_16356);

(statearr_16403_16596[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (65))){
var inst_16255 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16255)){
var statearr_16404_16597 = state_16401__$1;
(statearr_16404_16597[(1)] = (66));

} else {
var statearr_16405_16598 = state_16401__$1;
(statearr_16405_16598[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (70))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16265 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16266 = inst_16261.call(null,cljs.core.PersistentArrayMap,null,3,inst_16265,null);
var inst_16267 = inst_16261.call(null,cljs.core.PersistentHashSet,null,inst_16266,null);
var inst_16268 = inst_16267.call(null,inst_16260);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16268)){
var statearr_16406_16599 = state_16401__$1;
(statearr_16406_16599[(1)] = (72));

} else {
var statearr_16407_16600 = state_16401__$1;
(statearr_16407_16600[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (62))){
var inst_16245 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16408_16601 = state_16401__$1;
(statearr_16408_16601[(2)] = inst_16245);

(statearr_16408_16601[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (74))){
var inst_16351 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16409_16602 = state_16401__$1;
(statearr_16409_16602[(2)] = inst_16351);

(statearr_16409_16602[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (110))){
var inst_16378 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16378)){
var statearr_16410_16603 = state_16401__$1;
(statearr_16410_16603[(1)] = (117));

} else {
var statearr_16411_16604 = state_16401__$1;
(statearr_16411_16604[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (7))){
var inst_16396 = (state_16401[(2)]);
var _ = (function (){var statearr_16412 = state_16401;
(statearr_16412[(4)] = cljs.core.rest.call(null,(state_16401[(4)])));

return statearr_16412;
})();
var state_16401__$1 = state_16401;
var statearr_16413_16605 = state_16401__$1;
(statearr_16413_16605[(2)] = inst_16396);

(statearr_16413_16605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (59))){
var inst_16249 = (state_16401[(10)]);
var inst_16129 = (state_16401[(11)]);
var inst_16248 = (state_16401[(2)]);
var inst_16249__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16129);
var state_16401__$1 = (function (){var statearr_16414 = state_16401;
(statearr_16414[(12)] = inst_16248);

(statearr_16414[(10)] = inst_16249__$1);

return statearr_16414;
})();
if(cljs.core.truth_(inst_16249__$1)){
var statearr_16415_16606 = state_16401__$1;
(statearr_16415_16606[(1)] = (63));

} else {
var statearr_16416_16607 = state_16401__$1;
(statearr_16416_16607[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (86))){
var inst_16291 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16417_16608 = state_16401__$1;
(statearr_16417_16608[(2)] = inst_16291);

(statearr_16417_16608[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (20))){
var inst_16155 = (state_16401[(13)]);
var inst_16129 = (state_16401[(11)]);
var inst_16155__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16129);
var state_16401__$1 = (function (){var statearr_16418 = state_16401;
(statearr_16418[(13)] = inst_16155__$1);

return statearr_16418;
})();
if(cljs.core.truth_(inst_16155__$1)){
var statearr_16419_16609 = state_16401__$1;
(statearr_16419_16609[(1)] = (23));

} else {
var statearr_16420_16610 = state_16401__$1;
(statearr_16420_16610[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (72))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16270 = fluree.db.query.schema.type_error.call(null,inst_16260,inst_16261,throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16421_16611 = state_16401__$1;
(statearr_16421_16611[(2)] = inst_16270);

(statearr_16421_16611[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (58))){
var inst_16210 = (state_16401[(14)]);
var state_16401__$1 = state_16401;
var statearr_16422_16612 = state_16401__$1;
(statearr_16422_16612[(2)] = inst_16210);

(statearr_16422_16612[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (60))){
var inst_16117 = (state_16401[(15)]);
var inst_16128 = (state_16401[(16)]);
var inst_16236 = fluree.db.dbproto._p_prop.call(null,inst_16117,new cljs.core.Keyword(null,"name","name",1843675177),inst_16128);
var inst_16237 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16236)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16238 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16239 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16240 = cljs.core.PersistentHashMap.fromArrays(inst_16238,inst_16239);
var inst_16241 = cljs.core.ex_info.call(null,inst_16237,inst_16240);
var inst_16242 = (function(){throw inst_16241})();
var state_16401__$1 = state_16401;
var statearr_16423_16613 = state_16401__$1;
(statearr_16423_16613[(2)] = inst_16242);

(statearr_16423_16613[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (27))){
var inst_16158 = (state_16401[(17)]);
var state_16401__$1 = state_16401;
var statearr_16424_16614 = state_16401__$1;
(statearr_16424_16614[(2)] = inst_16158);

(statearr_16424_16614[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (1))){
var state_16401__$1 = state_16401;
var statearr_16425_16615 = state_16401__$1;
(statearr_16425_16615[(2)] = null);

(statearr_16425_16615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (69))){
var inst_16248 = (state_16401[(12)]);
var state_16401__$1 = state_16401;
var statearr_16426_16616 = state_16401__$1;
(statearr_16426_16616[(2)] = inst_16248);

(statearr_16426_16616[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (101))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16329 = fluree.db.query.schema.type_error.call(null,inst_16260,inst_16261,throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16427_16617 = state_16401__$1;
(statearr_16427_16617[(2)] = inst_16329);

(statearr_16427_16617[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (24))){
var inst_16155 = (state_16401[(13)]);
var state_16401__$1 = state_16401;
var statearr_16428_16618 = state_16401__$1;
(statearr_16428_16618[(2)] = inst_16155);

(statearr_16428_16618[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (102))){
var inst_16331 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16429_16619 = state_16401__$1;
(statearr_16429_16619[(2)] = inst_16331);

(statearr_16429_16619[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (55))){
var inst_16227 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16430_16620 = state_16401__$1;
(statearr_16430_16620[(2)] = inst_16227);

(statearr_16430_16620[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (85))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16289 = fluree.db.query.schema.type_error.call(null,inst_16260,inst_16261,throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16431_16621 = state_16401__$1;
(statearr_16431_16621[(2)] = inst_16289);

(statearr_16431_16621[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (39))){
var inst_16192 = (state_16401[(18)]);
var state_16401__$1 = state_16401;
var statearr_16432_16622 = state_16401__$1;
(statearr_16432_16622[(2)] = inst_16192);

(statearr_16432_16622[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (88))){
var inst_16248 = (state_16401[(12)]);
var state_16401__$1 = state_16401;
var statearr_16433_16623 = state_16401__$1;
(statearr_16433_16623[(2)] = inst_16248);

(statearr_16433_16623[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (46))){
var inst_16211 = (state_16401[(19)]);
var inst_16129 = (state_16401[(11)]);
var inst_16210 = (state_16401[(2)]);
var inst_16211__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16129);
var state_16401__$1 = (function (){var statearr_16434 = state_16401;
(statearr_16434[(19)] = inst_16211__$1);

(statearr_16434[(14)] = inst_16210);

return statearr_16434;
})();
if(cljs.core.truth_(inst_16211__$1)){
var statearr_16435_16624 = state_16401__$1;
(statearr_16435_16624[(1)] = (47));

} else {
var statearr_16436_16625 = state_16401__$1;
(statearr_16436_16625[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (4))){
var inst_16090 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16437_16626 = state_16401__$1;
(statearr_16437_16626[(2)] = inst_16090);

(statearr_16437_16626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (77))){
var inst_16349 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16438_16627 = state_16401__$1;
(statearr_16438_16627[(2)] = inst_16349);

(statearr_16438_16627[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (106))){
var inst_16341 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16439_16628 = state_16401__$1;
(statearr_16439_16628[(2)] = inst_16341);

(statearr_16439_16628[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (119))){
var inst_16127 = (state_16401[(20)]);
var inst_16391 = (state_16401[(2)]);
var inst_16116 = inst_16127;
var inst_16117 = inst_16391;
var state_16401__$1 = (function (){var statearr_16440 = state_16401;
(statearr_16440[(15)] = inst_16117);

(statearr_16440[(21)] = inst_16116);

return statearr_16440;
})();
var statearr_16441_16629 = state_16401__$1;
(statearr_16441_16629[(2)] = null);

(statearr_16441_16629[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (95))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16313 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16314 = inst_16261.call(null,cljs.core.PersistentArrayMap,null,5,inst_16313,null);
var inst_16315 = inst_16261.call(null,cljs.core.PersistentHashSet,null,inst_16314,null);
var inst_16316 = inst_16315.call(null,inst_16260);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16316)){
var statearr_16442_16630 = state_16401__$1;
(statearr_16442_16630[(1)] = (96));

} else {
var statearr_16443_16631 = state_16401__$1;
(statearr_16443_16631[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (54))){
var inst_16218 = (state_16401[(22)]);
var state_16401__$1 = state_16401;
var statearr_16444_16632 = state_16401__$1;
(statearr_16444_16632[(2)] = inst_16218);

(statearr_16444_16632[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (92))){
var inst_16248 = (state_16401[(12)]);
var state_16401__$1 = state_16401;
var statearr_16445_16633 = state_16401__$1;
(statearr_16445_16633[(2)] = inst_16248);

(statearr_16445_16633[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (104))){
var inst_16248 = (state_16401[(12)]);
var state_16401__$1 = state_16401;
var statearr_16446_16634 = state_16401__$1;
(statearr_16446_16634[(2)] = inst_16248);

(statearr_16446_16634[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (15))){
var inst_16137 = (state_16401[(23)]);
var state_16401__$1 = state_16401;
var statearr_16447_16635 = state_16401__$1;
(statearr_16447_16635[(2)] = inst_16137);

(statearr_16447_16635[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (48))){
var inst_16211 = (state_16401[(19)]);
var state_16401__$1 = state_16401;
var statearr_16448_16636 = state_16401__$1;
(statearr_16448_16636[(2)] = inst_16211);

(statearr_16448_16636[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (50))){
var inst_16218 = (state_16401[(22)]);
var inst_16129 = (state_16401[(11)]);
var inst_16216 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16217 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16216);
var inst_16218__$1 = inst_16217 === true;
var state_16401__$1 = (function (){var statearr_16449 = state_16401;
(statearr_16449[(22)] = inst_16218__$1);

return statearr_16449;
})();
if(cljs.core.truth_(inst_16218__$1)){
var statearr_16450_16637 = state_16401__$1;
(statearr_16450_16637[(1)] = (53));

} else {
var statearr_16451_16638 = state_16401__$1;
(statearr_16451_16638[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (116))){
var inst_16372 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16452_16639 = state_16401__$1;
(statearr_16452_16639[(2)] = inst_16372);

(statearr_16452_16639[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (75))){
var inst_16261 = (state_16401[(8)]);
var state_16401__$1 = state_16401;
var G__16453_16640 = inst_16261;
var G__16453_16641__$1 = (((G__16453_16640 instanceof cljs.core.Keyword))?G__16453_16640.fqn:null);
switch (G__16453_16641__$1) {
case "long":
var statearr_16454_16643 = state_16401__$1;
(statearr_16454_16643[(1)] = (79));


break;
case "bigint":
var statearr_16455_16644 = state_16401__$1;
(statearr_16455_16644[(1)] = (83));


break;
case "double":
var statearr_16456_16645 = state_16401__$1;
(statearr_16456_16645[(1)] = (87));


break;
case "float":
var statearr_16457_16646 = state_16401__$1;
(statearr_16457_16646[(1)] = (91));


break;
case "bigdec":
var statearr_16458_16647 = state_16401__$1;
(statearr_16458_16647[(1)] = (95));


break;
case "string":
var statearr_16459_16648 = state_16401__$1;
(statearr_16459_16648[(1)] = (99));


break;
case "instant":
var statearr_16460_16649 = state_16401__$1;
(statearr_16460_16649[(1)] = (103));


break;
default:
var statearr_16461_16650 = state_16401__$1;
(statearr_16461_16650[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (99))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16323 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16324 = inst_16261.call(null,cljs.core.PersistentArrayMap,null,5,inst_16323,null);
var inst_16325 = inst_16261.call(null,cljs.core.PersistentHashSet,null,inst_16324,null);
var inst_16326 = inst_16325.call(null,inst_16260);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16326)){
var statearr_16462_16651 = state_16401__$1;
(statearr_16462_16651[(1)] = (100));

} else {
var statearr_16463_16652 = state_16401__$1;
(statearr_16463_16652[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (21))){
var inst_16153 = (state_16401[(24)]);
var state_16401__$1 = state_16401;
var statearr_16464_16653 = state_16401__$1;
(statearr_16464_16653[(2)] = inst_16153);

(statearr_16464_16653[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (31))){
var inst_16169 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16465_16654 = state_16401__$1;
(statearr_16465_16654[(2)] = inst_16169);

(statearr_16465_16654[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (113))){
var inst_16375 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16466_16655 = state_16401__$1;
(statearr_16466_16655[(2)] = inst_16375);

(statearr_16466_16655[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (32))){
var state_16401__$1 = state_16401;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16467_16656 = state_16401__$1;
(statearr_16467_16656[(1)] = (35));

} else {
var statearr_16468_16657 = state_16401__$1;
(statearr_16468_16657[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (40))){
var inst_16205 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16205)){
var statearr_16469_16658 = state_16401__$1;
(statearr_16469_16658[(1)] = (44));

} else {
var statearr_16470_16659 = state_16401__$1;
(statearr_16470_16659[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (91))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16303 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16304 = inst_16261.call(null,cljs.core.PersistentArrayMap,null,3,inst_16303,null);
var inst_16305 = inst_16261.call(null,cljs.core.PersistentHashSet,null,inst_16304,null);
var inst_16306 = inst_16305.call(null,inst_16260);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16306)){
var statearr_16471_16660 = state_16401__$1;
(statearr_16471_16660[(1)] = (92));

} else {
var statearr_16472_16661 = state_16401__$1;
(statearr_16472_16661[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (117))){
var state_16401__$1 = state_16401;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16473_16662 = state_16401__$1;
(statearr_16473_16662[(1)] = (120));

} else {
var statearr_16474_16663 = state_16401__$1;
(statearr_16474_16663[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (108))){
var inst_16360 = (state_16401[(25)]);
var inst_16129 = (state_16401[(11)]);
var inst_16360__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16129);
var state_16401__$1 = (function (){var statearr_16475 = state_16401;
(statearr_16475[(25)] = inst_16360__$1);

return statearr_16475;
})();
if(cljs.core.truth_(inst_16360__$1)){
var statearr_16476_16664 = state_16401__$1;
(statearr_16476_16664[(1)] = (111));

} else {
var statearr_16477_16665 = state_16401__$1;
(statearr_16477_16665[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (56))){
var inst_16222 = (state_16401[(2)]);
var inst_16223 = fluree.db.util.async.throw_err.call(null,inst_16222);
var inst_16224 = cljs.core.not.call(null,inst_16223);
var state_16401__$1 = state_16401;
var statearr_16478_16666 = state_16401__$1;
(statearr_16478_16666[(2)] = inst_16224);

(statearr_16478_16666[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (33))){
var inst_16152 = (state_16401[(26)]);
var state_16401__$1 = state_16401;
var statearr_16479_16667 = state_16401__$1;
(statearr_16479_16667[(2)] = inst_16152);

(statearr_16479_16667[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (13))){
var inst_16147 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16147)){
var statearr_16480_16668 = state_16401__$1;
(statearr_16480_16668[(1)] = (17));

} else {
var statearr_16481_16669 = state_16401__$1;
(statearr_16481_16669[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (22))){
var inst_16178 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16178)){
var statearr_16482_16670 = state_16401__$1;
(statearr_16482_16670[(1)] = (32));

} else {
var statearr_16483_16671 = state_16401__$1;
(statearr_16483_16671[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (90))){
var inst_16301 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16484_16672 = state_16401__$1;
(statearr_16484_16672[(2)] = inst_16301);

(statearr_16484_16672[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (109))){
var inst_16358 = (state_16401[(27)]);
var state_16401__$1 = state_16401;
var statearr_16485_16673 = state_16401__$1;
(statearr_16485_16673[(2)] = inst_16358);

(statearr_16485_16673[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (36))){
var inst_16152 = (state_16401[(26)]);
var state_16401__$1 = state_16401;
var statearr_16486_16674 = state_16401__$1;
(statearr_16486_16674[(2)] = inst_16152);

(statearr_16486_16674[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (41))){
var inst_16129 = (state_16401[(11)]);
var inst_16197 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16198 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16197);
var inst_16199 = inst_16198 === true;
var state_16401__$1 = state_16401;
var statearr_16487_16675 = state_16401__$1;
(statearr_16487_16675[(2)] = inst_16199);

(statearr_16487_16675[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (118))){
var inst_16356 = (state_16401[(7)]);
var state_16401__$1 = state_16401;
var statearr_16488_16676 = state_16401__$1;
(statearr_16488_16676[(2)] = inst_16356);

(statearr_16488_16676[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (89))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16299 = fluree.db.query.schema.type_error.call(null,inst_16260,inst_16261,throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16489_16677 = state_16401__$1;
(statearr_16489_16677[(2)] = inst_16299);

(statearr_16489_16677[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (100))){
var inst_16248 = (state_16401[(12)]);
var state_16401__$1 = state_16401;
var statearr_16490_16678 = state_16401__$1;
(statearr_16490_16678[(2)] = inst_16248);

(statearr_16490_16678[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (122))){
var inst_16388 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16491_16679 = state_16401__$1;
(statearr_16491_16679[(2)] = inst_16388);

(statearr_16491_16679[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (43))){
var inst_16202 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16492_16680 = state_16401__$1;
(statearr_16492_16680[(2)] = inst_16202);

(statearr_16492_16680[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (61))){
var inst_16210 = (state_16401[(14)]);
var state_16401__$1 = state_16401;
var statearr_16493_16681 = state_16401__$1;
(statearr_16493_16681[(2)] = inst_16210);

(statearr_16493_16681[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (29))){
var inst_16129 = (state_16401[(11)]);
var inst_16164 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16165 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16164);
var inst_16166 = inst_16165 === true;
var state_16401__$1 = state_16401;
var statearr_16494_16682 = state_16401__$1;
(statearr_16494_16682[(2)] = inst_16166);

(statearr_16494_16682[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (44))){
var inst_16191 = (state_16401[(28)]);
var inst_16207 = fluree.db.query.schema.type_error.call(null,inst_16191,"a component","a non-component",throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16495_16683 = state_16401__$1;
(statearr_16495_16683[(2)] = inst_16207);

(statearr_16495_16683[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (93))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16309 = fluree.db.query.schema.type_error.call(null,inst_16260,inst_16261,throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16496_16684 = state_16401__$1;
(statearr_16496_16684[(2)] = inst_16309);

(statearr_16496_16684[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (6))){
var inst_16128 = (state_16401[(16)]);
var inst_16116 = (state_16401[(21)]);
var inst_16125 = cljs.core.seq.call(null,inst_16116);
var inst_16126 = cljs.core.first.call(null,inst_16125);
var inst_16127 = cljs.core.next.call(null,inst_16125);
var inst_16128__$1 = cljs.core.nth.call(null,inst_16126,(0),null);
var inst_16129 = cljs.core.nth.call(null,inst_16126,(1),null);
var inst_16130 = cljs.core.not.call(null,inst_16128__$1);
var state_16401__$1 = (function (){var statearr_16497 = state_16401;
(statearr_16497[(16)] = inst_16128__$1);

(statearr_16497[(20)] = inst_16127);

(statearr_16497[(11)] = inst_16129);

return statearr_16497;
})();
if(inst_16130){
var statearr_16498_16685 = state_16401__$1;
(statearr_16498_16685[(1)] = (8));

} else {
var statearr_16499_16686 = state_16401__$1;
(statearr_16499_16686[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (111))){
var inst_16364 = (state_16401[(29)]);
var inst_16129 = (state_16401[(11)]);
var inst_16362 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16363 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16362);
var inst_16364__$1 = inst_16363 === true;
var state_16401__$1 = (function (){var statearr_16500 = state_16401;
(statearr_16500[(29)] = inst_16364__$1);

return statearr_16500;
})();
if(cljs.core.truth_(inst_16364__$1)){
var statearr_16501_16687 = state_16401__$1;
(statearr_16501_16687[(1)] = (114));

} else {
var statearr_16502_16688 = state_16401__$1;
(statearr_16502_16688[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (28))){
var inst_16172 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16503_16689 = state_16401__$1;
(statearr_16503_16689[(2)] = inst_16172);

(statearr_16503_16689[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (64))){
var inst_16249 = (state_16401[(10)]);
var state_16401__$1 = state_16401;
var statearr_16504_16690 = state_16401__$1;
(statearr_16504_16690[(2)] = inst_16249);

(statearr_16504_16690[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (103))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16333 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16334 = inst_16261.call(null,cljs.core.PersistentArrayMap,null,2,inst_16333,null);
var inst_16335 = inst_16261.call(null,cljs.core.PersistentHashSet,null,inst_16334,null);
var inst_16336 = inst_16335.call(null,inst_16260);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16336)){
var statearr_16505_16691 = state_16401__$1;
(statearr_16505_16691[(1)] = (104));

} else {
var statearr_16506_16692 = state_16401__$1;
(statearr_16506_16692[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (51))){
var inst_16214 = (state_16401[(30)]);
var state_16401__$1 = state_16401;
var statearr_16507_16693 = state_16401__$1;
(statearr_16507_16693[(2)] = inst_16214);

(statearr_16507_16693[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (25))){
var inst_16175 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16508_16694 = state_16401__$1;
(statearr_16508_16694[(2)] = inst_16175);

(statearr_16508_16694[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (34))){
var inst_16192 = (state_16401[(18)]);
var inst_16129 = (state_16401[(11)]);
var inst_16191 = (state_16401[(2)]);
var inst_16192__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16129);
var state_16401__$1 = (function (){var statearr_16509 = state_16401;
(statearr_16509[(18)] = inst_16192__$1);

(statearr_16509[(28)] = inst_16191);

return statearr_16509;
})();
if(cljs.core.truth_(inst_16192__$1)){
var statearr_16510_16695 = state_16401__$1;
(statearr_16510_16695[(1)] = (38));

} else {
var statearr_16511_16696 = state_16401__$1;
(statearr_16511_16696[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (17))){
var inst_16117 = (state_16401[(15)]);
var inst_16149 = fluree.db.query.schema.type_error.call(null,inst_16117,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16512_16697 = state_16401__$1;
(statearr_16512_16697[(2)] = inst_16149);

(statearr_16512_16697[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (3))){
var inst_16399 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16401__$1,inst_16399);
} else {
if((state_val_16402 === (12))){
var inst_16133 = (state_16401[(31)]);
var state_16401__$1 = state_16401;
var statearr_16513_16698 = state_16401__$1;
(statearr_16513_16698[(2)] = inst_16133);

(statearr_16513_16698[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (2))){
var _ = (function (){var statearr_16514 = state_16401;
(statearr_16514[(4)] = cljs.core.cons.call(null,(5),(state_16401[(4)])));

return statearr_16514;
})();
var inst_16109 = pred_changes;
var inst_16110 = cljs.core.seq.call(null,inst_16109);
var inst_16111 = cljs.core.first.call(null,inst_16110);
var inst_16112 = cljs.core.next.call(null,inst_16110);
var inst_16113 = cljs.core.nth.call(null,inst_16111,(0),null);
var inst_16114 = cljs.core.nth.call(null,inst_16111,(1),null);
var inst_16115 = db;
var inst_16116 = inst_16109;
var inst_16117 = inst_16115;
var state_16401__$1 = (function (){var statearr_16515 = state_16401;
(statearr_16515[(15)] = inst_16117);

(statearr_16515[(32)] = inst_16112);

(statearr_16515[(33)] = inst_16113);

(statearr_16515[(21)] = inst_16116);

(statearr_16515[(34)] = inst_16114);

return statearr_16515;
})();
var statearr_16516_16699 = state_16401__$1;
(statearr_16516_16699[(2)] = null);

(statearr_16516_16699[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (66))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16129 = (state_16401[(11)]);
var inst_16258 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16259 = cljs.core.__destructure_map.call(null,inst_16258);
var inst_16260__$1 = cljs.core.get.call(null,inst_16259,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16261__$1 = cljs.core.get.call(null,inst_16259,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16262 = cljs.core._EQ_.call(null,inst_16261__$1,inst_16260__$1);
var state_16401__$1 = (function (){var statearr_16517 = state_16401;
(statearr_16517[(8)] = inst_16261__$1);

(statearr_16517[(9)] = inst_16260__$1);

return statearr_16517;
})();
if(inst_16262){
var statearr_16518_16700 = state_16401__$1;
(statearr_16518_16700[(1)] = (69));

} else {
var statearr_16519_16701 = state_16401__$1;
(statearr_16519_16701[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (107))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16343 = fluree.db.query.schema.type_error.call(null,inst_16260,inst_16261,throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16520_16702 = state_16401__$1;
(statearr_16520_16702[(2)] = inst_16343);

(statearr_16520_16702[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (23))){
var inst_16158 = (state_16401[(17)]);
var inst_16129 = (state_16401[(11)]);
var inst_16157 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16158__$1 = inst_16157 === true;
var state_16401__$1 = (function (){var statearr_16521 = state_16401;
(statearr_16521[(17)] = inst_16158__$1);

return statearr_16521;
})();
if(cljs.core.truth_(inst_16158__$1)){
var statearr_16522_16703 = state_16401__$1;
(statearr_16522_16703[(1)] = (26));

} else {
var statearr_16523_16704 = state_16401__$1;
(statearr_16523_16704[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (47))){
var inst_16214 = (state_16401[(30)]);
var inst_16129 = (state_16401[(11)]);
var inst_16213 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16214__$1 = cljs.core.not.call(null,inst_16213);
var state_16401__$1 = (function (){var statearr_16524 = state_16401;
(statearr_16524[(30)] = inst_16214__$1);

return statearr_16524;
})();
if(inst_16214__$1){
var statearr_16525_16705 = state_16401__$1;
(statearr_16525_16705[(1)] = (50));

} else {
var statearr_16526_16706 = state_16401__$1;
(statearr_16526_16706[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (35))){
var inst_16181 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16182 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16183 = cljs.core.PersistentHashMap.fromArrays(inst_16181,inst_16182);
var inst_16184 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_16183);
var inst_16185 = (function(){throw inst_16184})();
var state_16401__$1 = state_16401;
var statearr_16527_16707 = state_16401__$1;
(statearr_16527_16707[(2)] = inst_16185);

(statearr_16527_16707[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (82))){
var inst_16281 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16528_16708 = state_16401__$1;
(statearr_16528_16708[(2)] = inst_16281);

(statearr_16528_16708[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (76))){
var state_16401__$1 = state_16401;
var statearr_16529_16709 = state_16401__$1;
(statearr_16529_16709[(2)] = null);

(statearr_16529_16709[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (97))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16319 = fluree.db.query.schema.type_error.call(null,inst_16260,inst_16261,throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16530_16710 = state_16401__$1;
(statearr_16530_16710[(2)] = inst_16319);

(statearr_16530_16710[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (19))){
var inst_16153 = (state_16401[(24)]);
var inst_16129 = (state_16401[(11)]);
var inst_16152 = (state_16401[(2)]);
var inst_16153__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16129);
var state_16401__$1 = (function (){var statearr_16531 = state_16401;
(statearr_16531[(26)] = inst_16152);

(statearr_16531[(24)] = inst_16153__$1);

return statearr_16531;
})();
if(cljs.core.truth_(inst_16153__$1)){
var statearr_16532_16711 = state_16401__$1;
(statearr_16532_16711[(1)] = (20));

} else {
var statearr_16533_16712 = state_16401__$1;
(statearr_16533_16712[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (57))){
var state_16401__$1 = state_16401;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16534_16713 = state_16401__$1;
(statearr_16534_16713[(1)] = (60));

} else {
var statearr_16535_16714 = state_16401__$1;
(statearr_16535_16714[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (68))){
var inst_16358 = (state_16401[(27)]);
var inst_16129 = (state_16401[(11)]);
var inst_16356 = (state_16401[(2)]);
var inst_16357 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16358__$1 = inst_16357 === true;
var state_16401__$1 = (function (){var statearr_16536 = state_16401;
(statearr_16536[(27)] = inst_16358__$1);

(statearr_16536[(7)] = inst_16356);

return statearr_16536;
})();
if(cljs.core.truth_(inst_16358__$1)){
var statearr_16537_16715 = state_16401__$1;
(statearr_16537_16715[(1)] = (108));

} else {
var statearr_16538_16716 = state_16401__$1;
(statearr_16538_16716[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (11))){
var inst_16137 = (state_16401[(23)]);
var inst_16129 = (state_16401[(11)]);
var inst_16135 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16136 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16135);
var inst_16137__$1 = inst_16136 === false;
var state_16401__$1 = (function (){var statearr_16539 = state_16401;
(statearr_16539[(23)] = inst_16137__$1);

return statearr_16539;
})();
if(cljs.core.truth_(inst_16137__$1)){
var statearr_16540_16717 = state_16401__$1;
(statearr_16540_16717[(1)] = (14));

} else {
var statearr_16541_16718 = state_16401__$1;
(statearr_16541_16718[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (115))){
var inst_16364 = (state_16401[(29)]);
var state_16401__$1 = state_16401;
var statearr_16543_16719 = state_16401__$1;
(statearr_16543_16719[(2)] = inst_16364);

(statearr_16543_16719[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (9))){
var inst_16133 = (state_16401[(31)]);
var inst_16129 = (state_16401[(11)]);
var inst_16133__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16129);
var state_16401__$1 = (function (){var statearr_16544 = state_16401;
(statearr_16544[(31)] = inst_16133__$1);

return statearr_16544;
})();
if(cljs.core.truth_(inst_16133__$1)){
var statearr_16545_16720 = state_16401__$1;
(statearr_16545_16720[(1)] = (11));

} else {
var statearr_16546_16721 = state_16401__$1;
(statearr_16546_16721[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (5))){
var _ = (function (){var statearr_16547 = state_16401;
(statearr_16547[(4)] = cljs.core.rest.call(null,(state_16401[(4)])));

return statearr_16547;
})();
var state_16401__$1 = state_16401;
var ex16542 = (state_16401__$1[(2)]);
var statearr_16548_16722 = state_16401__$1;
(statearr_16548_16722[(5)] = ex16542);


if((ex16542 instanceof Error)){
var statearr_16549_16723 = state_16401__$1;
(statearr_16549_16723[(1)] = (4));

(statearr_16549_16723[(5)] = null);

} else {
throw ex16542;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (112))){
var inst_16360 = (state_16401[(25)]);
var state_16401__$1 = state_16401;
var statearr_16550_16724 = state_16401__$1;
(statearr_16550_16724[(2)] = inst_16360);

(statearr_16550_16724[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (83))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16283 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16284 = inst_16261.call(null,cljs.core.PersistentArrayMap,null,3,inst_16283,null);
var inst_16285 = inst_16261.call(null,cljs.core.PersistentHashSet,null,inst_16284,null);
var inst_16286 = inst_16285.call(null,inst_16260);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16286)){
var statearr_16551_16725 = state_16401__$1;
(statearr_16551_16725[(1)] = (84));

} else {
var statearr_16552_16726 = state_16401__$1;
(statearr_16552_16726[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (14))){
var inst_16129 = (state_16401[(11)]);
var inst_16139 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16140 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16139);
var inst_16141 = inst_16140 === true;
var state_16401__$1 = state_16401;
var statearr_16553_16727 = state_16401__$1;
(statearr_16553_16727[(2)] = inst_16141);

(statearr_16553_16727[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (45))){
var inst_16191 = (state_16401[(28)]);
var state_16401__$1 = state_16401;
var statearr_16554_16728 = state_16401__$1;
(statearr_16554_16728[(2)] = inst_16191);

(statearr_16554_16728[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (53))){
var inst_16117 = (state_16401[(15)]);
var inst_16128 = (state_16401[(16)]);
var inst_16220 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_16117,inst_16128);
var state_16401__$1 = state_16401;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16401__$1,(56),inst_16220);
} else {
if((state_val_16402 === (78))){
var inst_16346 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16555_16729 = state_16401__$1;
(statearr_16555_16729[(2)] = inst_16346);

(statearr_16555_16729[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (26))){
var inst_16162 = (state_16401[(35)]);
var inst_16129 = (state_16401[(11)]);
var inst_16160 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16161 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16160);
var inst_16162__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16161);
var state_16401__$1 = (function (){var statearr_16556 = state_16401;
(statearr_16556[(35)] = inst_16162__$1);

return statearr_16556;
})();
if(inst_16162__$1){
var statearr_16557_16730 = state_16401__$1;
(statearr_16557_16730[(1)] = (29));

} else {
var statearr_16558_16731 = state_16401__$1;
(statearr_16558_16731[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (16))){
var inst_16144 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16559_16732 = state_16401__$1;
(statearr_16559_16732[(2)] = inst_16144);

(statearr_16559_16732[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (81))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16279 = fluree.db.query.schema.type_error.call(null,inst_16260,inst_16261,throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16560_16733 = state_16401__$1;
(statearr_16560_16733[(2)] = inst_16279);

(statearr_16560_16733[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (120))){
var inst_16381 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16382 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16383 = cljs.core.PersistentHashMap.fromArrays(inst_16381,inst_16382);
var inst_16384 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_16383);
var inst_16385 = (function(){throw inst_16384})();
var state_16401__$1 = state_16401;
var statearr_16561_16734 = state_16401__$1;
(statearr_16561_16734[(2)] = inst_16385);

(statearr_16561_16734[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (79))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16273 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16274 = inst_16261.call(null,cljs.core.PersistentArrayMap,null,2,inst_16273,null);
var inst_16275 = inst_16261.call(null,cljs.core.PersistentHashSet,null,inst_16274,null);
var inst_16276 = inst_16275.call(null,inst_16260);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16276)){
var statearr_16562_16735 = state_16401__$1;
(statearr_16562_16735[(1)] = (80));

} else {
var statearr_16563_16736 = state_16401__$1;
(statearr_16563_16736[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (38))){
var inst_16195 = (state_16401[(36)]);
var inst_16129 = (state_16401[(11)]);
var inst_16194 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16195__$1 = cljs.core.not.call(null,inst_16194);
var state_16401__$1 = (function (){var statearr_16564 = state_16401;
(statearr_16564[(36)] = inst_16195__$1);

return statearr_16564;
})();
if(inst_16195__$1){
var statearr_16565_16737 = state_16401__$1;
(statearr_16565_16737[(1)] = (41));

} else {
var statearr_16566_16738 = state_16401__$1;
(statearr_16566_16738[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (98))){
var inst_16321 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16567_16739 = state_16401__$1;
(statearr_16567_16739[(2)] = inst_16321);

(statearr_16567_16739[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (87))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16293 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16294 = inst_16261.call(null,cljs.core.PersistentArrayMap,null,3,inst_16293,null);
var inst_16295 = inst_16261.call(null,cljs.core.PersistentHashSet,null,inst_16294,null);
var inst_16296 = inst_16295.call(null,inst_16260);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16296)){
var statearr_16568_16740 = state_16401__$1;
(statearr_16568_16740[(1)] = (88));

} else {
var statearr_16569_16741 = state_16401__$1;
(statearr_16569_16741[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (30))){
var inst_16162 = (state_16401[(35)]);
var state_16401__$1 = state_16401;
var statearr_16570_16742 = state_16401__$1;
(statearr_16570_16742[(2)] = inst_16162);

(statearr_16570_16742[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (73))){
var state_16401__$1 = state_16401;
var statearr_16571_16743 = state_16401__$1;
(statearr_16571_16743[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (96))){
var inst_16248 = (state_16401[(12)]);
var state_16401__$1 = state_16401;
var statearr_16573_16744 = state_16401__$1;
(statearr_16573_16744[(2)] = inst_16248);

(statearr_16573_16744[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (10))){
var inst_16394 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16574_16745 = state_16401__$1;
(statearr_16574_16745[(2)] = inst_16394);

(statearr_16574_16745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (18))){
var inst_16117 = (state_16401[(15)]);
var state_16401__$1 = state_16401;
var statearr_16575_16746 = state_16401__$1;
(statearr_16575_16746[(2)] = inst_16117);

(statearr_16575_16746[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (105))){
var inst_16261 = (state_16401[(8)]);
var inst_16260 = (state_16401[(9)]);
var inst_16339 = fluree.db.query.schema.type_error.call(null,inst_16260,inst_16261,throw_QMARK_);
var state_16401__$1 = state_16401;
var statearr_16576_16747 = state_16401__$1;
(statearr_16576_16747[(2)] = inst_16339);

(statearr_16576_16747[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (52))){
var inst_16230 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16577_16748 = state_16401__$1;
(statearr_16577_16748[(2)] = inst_16230);

(statearr_16577_16748[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (114))){
var inst_16129 = (state_16401[(11)]);
var inst_16366 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16367 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16366);
var inst_16368 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16367);
var inst_16369 = (!(inst_16368));
var state_16401__$1 = state_16401;
var statearr_16578_16749 = state_16401__$1;
(statearr_16578_16749[(2)] = inst_16369);

(statearr_16578_16749[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (67))){
var inst_16248 = (state_16401[(12)]);
var state_16401__$1 = state_16401;
var statearr_16579_16750 = state_16401__$1;
(statearr_16579_16750[(2)] = inst_16248);

(statearr_16579_16750[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (71))){
var inst_16353 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16580_16751 = state_16401__$1;
(statearr_16580_16751[(2)] = inst_16353);

(statearr_16580_16751[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (42))){
var inst_16195 = (state_16401[(36)]);
var state_16401__$1 = state_16401;
var statearr_16581_16752 = state_16401__$1;
(statearr_16581_16752[(2)] = inst_16195);

(statearr_16581_16752[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (80))){
var inst_16248 = (state_16401[(12)]);
var state_16401__$1 = state_16401;
var statearr_16582_16753 = state_16401__$1;
(statearr_16582_16753[(2)] = inst_16248);

(statearr_16582_16753[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (37))){
var inst_16188 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16583_16754 = state_16401__$1;
(statearr_16583_16754[(2)] = inst_16188);

(statearr_16583_16754[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (63))){
var inst_16129 = (state_16401[(11)]);
var inst_16251 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16129);
var inst_16252 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16251);
var state_16401__$1 = state_16401;
var statearr_16584_16755 = state_16401__$1;
(statearr_16584_16755[(2)] = inst_16252);

(statearr_16584_16755[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (94))){
var inst_16311 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
var statearr_16585_16756 = state_16401__$1;
(statearr_16585_16756[(2)] = inst_16311);

(statearr_16585_16756[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (8))){
var inst_16117 = (state_16401[(15)]);
var state_16401__$1 = state_16401;
var statearr_16586_16757 = state_16401__$1;
(statearr_16586_16757[(2)] = inst_16117);

(statearr_16586_16757[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (49))){
var inst_16233 = (state_16401[(2)]);
var state_16401__$1 = state_16401;
if(cljs.core.truth_(inst_16233)){
var statearr_16587_16758 = state_16401__$1;
(statearr_16587_16758[(1)] = (57));

} else {
var statearr_16588_16759 = state_16401__$1;
(statearr_16588_16759[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16402 === (84))){
var inst_16248 = (state_16401[(12)]);
var state_16401__$1 = state_16401;
var statearr_16589_16760 = state_16401__$1;
(statearr_16589_16760[(2)] = inst_16248);

(statearr_16589_16760[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2746__auto__ = null;
var fluree$db$query$schema$state_machine__2746__auto____0 = (function (){
var statearr_16590 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16590[(0)] = fluree$db$query$schema$state_machine__2746__auto__);

(statearr_16590[(1)] = (1));

return statearr_16590;
});
var fluree$db$query$schema$state_machine__2746__auto____1 = (function (state_16401){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16401);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16591){var ex__2749__auto__ = e16591;
var statearr_16592_16761 = state_16401;
(statearr_16592_16761[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16401[(4)]))){
var statearr_16593_16762 = state_16401;
(statearr_16593_16762[(1)] = cljs.core.first.call(null,(state_16401[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16763 = state_16401;
state_16401 = G__16763;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2746__auto__ = function(state_16401){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2746__auto____1.call(this,state_16401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2746__auto____0;
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2746__auto____1;
return fluree$db$query$schema$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16594 = f__2769__auto__.call(null);
(statearr_16594[(6)] = c__2768__auto__);

return statearr_16594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16765 = arguments.length;
switch (G__16765) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16789){
var state_val_16790 = (state_16789[(1)]);
if((state_val_16790 === (7))){
var state_16789__$1 = state_16789;
var statearr_16791_16811 = state_16789__$1;
(statearr_16791_16811[(2)] = db);

(statearr_16791_16811[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16790 === (1))){
var state_16789__$1 = state_16789;
var statearr_16792_16812 = state_16789__$1;
(statearr_16792_16812[(2)] = null);

(statearr_16792_16812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16790 === (4))){
var inst_16766 = (state_16789[(2)]);
var state_16789__$1 = state_16789;
var statearr_16793_16813 = state_16789__$1;
(statearr_16793_16813[(2)] = inst_16766);

(statearr_16793_16813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16790 === (6))){
var inst_16775 = (state_16789[(7)]);
var inst_16774 = (state_16789[(2)]);
var inst_16775__$1 = fluree.db.util.async.throw_err.call(null,inst_16774);
var inst_16776 = cljs.core.empty_QMARK_.call(null,inst_16775__$1);
var state_16789__$1 = (function (){var statearr_16794 = state_16789;
(statearr_16794[(7)] = inst_16775__$1);

return statearr_16794;
})();
if(inst_16776){
var statearr_16795_16814 = state_16789__$1;
(statearr_16795_16814[(1)] = (7));

} else {
var statearr_16796_16815 = state_16789__$1;
(statearr_16796_16815[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16790 === (3))){
var inst_16787 = (state_16789[(2)]);
var state_16789__$1 = state_16789;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16789__$1,inst_16787);
} else {
if((state_val_16790 === (2))){
var _ = (function (){var statearr_16798 = state_16789;
(statearr_16798[(4)] = cljs.core.cons.call(null,(5),(state_16789[(4)])));

return statearr_16798;
})();
var inst_16772 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_16789__$1 = state_16789;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16789__$1,(6),inst_16772);
} else {
if((state_val_16790 === (9))){
var inst_16784 = (state_16789[(2)]);
var _ = (function (){var statearr_16799 = state_16789;
(statearr_16799[(4)] = cljs.core.rest.call(null,(state_16789[(4)])));

return statearr_16799;
})();
var state_16789__$1 = state_16789;
var statearr_16800_16816 = state_16789__$1;
(statearr_16800_16816[(2)] = inst_16784);

(statearr_16800_16816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16790 === (5))){
var _ = (function (){var statearr_16801 = state_16789;
(statearr_16801[(4)] = cljs.core.rest.call(null,(state_16789[(4)])));

return statearr_16801;
})();
var state_16789__$1 = state_16789;
var ex16797 = (state_16789__$1[(2)]);
var statearr_16802_16817 = state_16789__$1;
(statearr_16802_16817[(5)] = ex16797);


if((ex16797 instanceof Error)){
var statearr_16803_16818 = state_16789__$1;
(statearr_16803_16818[(1)] = (4));

(statearr_16803_16818[(5)] = null);

} else {
throw ex16797;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16790 === (10))){
var inst_16781 = (state_16789[(2)]);
var inst_16782 = fluree.db.util.async.throw_err.call(null,inst_16781);
var state_16789__$1 = state_16789;
var statearr_16804_16819 = state_16789__$1;
(statearr_16804_16819[(2)] = inst_16782);

(statearr_16804_16819[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16790 === (8))){
var inst_16775 = (state_16789[(7)]);
var inst_16779 = fluree.db.query.schema.predicate_change_error.call(null,inst_16775,db,true);
var state_16789__$1 = state_16789;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16789__$1,(10),inst_16779);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2746__auto__ = null;
var fluree$db$query$schema$state_machine__2746__auto____0 = (function (){
var statearr_16805 = [null,null,null,null,null,null,null,null];
(statearr_16805[(0)] = fluree$db$query$schema$state_machine__2746__auto__);

(statearr_16805[(1)] = (1));

return statearr_16805;
});
var fluree$db$query$schema$state_machine__2746__auto____1 = (function (state_16789){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16789);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16806){var ex__2749__auto__ = e16806;
var statearr_16807_16820 = state_16789;
(statearr_16807_16820[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16789[(4)]))){
var statearr_16808_16821 = state_16789;
(statearr_16808_16821[(1)] = cljs.core.first.call(null,(state_16789[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16822 = state_16789;
state_16789 = G__16822;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2746__auto__ = function(state_16789){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2746__auto____1.call(this,state_16789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2746__auto____0;
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2746__auto____1;
return fluree$db$query$schema$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16809 = f__2769__auto__.call(null);
(statearr_16809[(6)] = c__2768__auto__);

return statearr_16809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16824 = arguments.length;
switch (G__16824) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16826 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__16826,(0),null);
var ns = cljs.core.nth.call(null,vec__16826,(1),null);
var name = cljs.core.nth.call(null,vec__16826,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4251__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4251__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__16829_SHARP_,p2__16830_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16829_SHARP_,p2__16830_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__16831_SHARP_){
var f = p1__16831_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16897){
var state_val_16898 = (state_16897[(1)]);
if((state_val_16898 === (1))){
var state_16897__$1 = state_16897;
var statearr_16899_16916 = state_16897__$1;
(statearr_16899_16916[(2)] = null);

(statearr_16899_16916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16898 === (2))){
var _ = (function (){var statearr_16900 = state_16897;
(statearr_16900[(4)] = cljs.core.cons.call(null,(5),(state_16897[(4)])));

return statearr_16900;
})();
var inst_16849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16850 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_16851 = [inst_16850];
var inst_16852 = (new cljs.core.PersistentVector(null,1,(5),inst_16849,inst_16851,null));
var inst_16853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16854 = [(0)];
var inst_16855 = (new cljs.core.PersistentVector(null,1,(5),inst_16853,inst_16854,null));
var inst_16856 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16852,cljs.core._LT__EQ_,inst_16855);
var state_16897__$1 = state_16897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16897__$1,(6),inst_16856);
} else {
if((state_val_16898 === (3))){
var inst_16895 = (state_16897[(2)]);
var state_16897__$1 = state_16897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16897__$1,inst_16895);
} else {
if((state_val_16898 === (4))){
var inst_16837 = (state_16897[(2)]);
var state_16897__$1 = state_16897;
var statearr_16902_16917 = state_16897__$1;
(statearr_16902_16917[(2)] = inst_16837);

(statearr_16902_16917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16898 === (5))){
var _ = (function (){var statearr_16903 = state_16897;
(statearr_16903[(4)] = cljs.core.rest.call(null,(state_16897[(4)])));

return statearr_16903;
})();
var state_16897__$1 = state_16897;
var ex16901 = (state_16897__$1[(2)]);
var statearr_16904_16918 = state_16897__$1;
(statearr_16904_16918[(5)] = ex16901);


if((ex16901 instanceof Error)){
var statearr_16905_16919 = state_16897__$1;
(statearr_16905_16919[(1)] = (4));

(statearr_16905_16919[(5)] = null);

} else {
throw ex16901;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16898 === (6))){
var inst_16858 = (state_16897[(2)]);
var inst_16859 = fluree.db.util.async.throw_err.call(null,inst_16858);
var inst_16860 = (function (){var schema_flakes = inst_16859;
return (function (p1__16832_SHARP_){
return (p1__16832_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16861 = cljs.core.partition_by.call(null,inst_16860,inst_16859);
var inst_16862 = cljs.core.nth.call(null,inst_16861,(0),null);
var inst_16863 = cljs.core.nth.call(null,inst_16861,(1),null);
var inst_16864 = (function (){var schema_flakes = inst_16859;
var vec__16843 = inst_16861;
var collection_flakes = inst_16862;
var predicate_flakes = inst_16863;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.call(null,(function (p1__16835_SHARP_,p2__16834_SHARP_){
var f = p2__16834_SHARP_;
return cljs.core.assoc.call(null,p1__16835_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4253__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_16865 = [(-1),"_tx"];
var inst_16866 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16867 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16868 = cljs.core.PersistentHashMap.fromArrays(inst_16866,inst_16867);
var inst_16869 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16870 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16871 = cljs.core.PersistentHashMap.fromArrays(inst_16869,inst_16870);
var inst_16872 = [inst_16868,inst_16871];
var inst_16873 = cljs.core.PersistentHashMap.fromArrays(inst_16865,inst_16872);
var inst_16874 = (function (){var schema_flakes = inst_16859;
var vec__16843 = inst_16861;
var collection_flakes = inst_16862;
var predicate_flakes = inst_16863;
return (function (p1__16833_SHARP_){
return p1__16833_SHARP_.s;
});
})();
var inst_16875 = cljs.core.partition_by.call(null,inst_16874,inst_16862);
var inst_16876 = cljs.core.reduce.call(null,inst_16864,inst_16873,inst_16875);
var inst_16878 = (function (){var schema_flakes = inst_16859;
var vec__16843 = inst_16861;
var collection_flakes = inst_16862;
var predicate_flakes = inst_16863;
var coll = inst_16876;
return (function (p__16877,pred_flakes){
var vec__16906 = p__16877;
var pred = cljs.core.nth.call(null,vec__16906,(0),null);
var fullText = cljs.core.nth.call(null,vec__16906,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4253__auto__ = ref_QMARK_;
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_16879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16880 = cljs.core.PersistentHashMap.EMPTY;
var inst_16881 = cljs.core.PersistentHashSet.EMPTY;
var inst_16882 = [inst_16880,inst_16881];
var inst_16883 = (new cljs.core.PersistentVector(null,2,(5),inst_16879,inst_16882,null));
var inst_16884 = (function (){var schema_flakes = inst_16859;
var vec__16843 = inst_16861;
var collection_flakes = inst_16862;
var predicate_flakes = inst_16863;
var coll = inst_16876;
return (function (p1__16836_SHARP_){
return p1__16836_SHARP_.s;
});
})();
var inst_16885 = cljs.core.partition_by.call(null,inst_16884,inst_16863);
var inst_16886 = cljs.core.reduce.call(null,inst_16878,inst_16883,inst_16885);
var inst_16887 = cljs.core.nth.call(null,inst_16886,(0),null);
var inst_16888 = cljs.core.nth.call(null,inst_16886,(1),null);
var inst_16889 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_16890 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_16891 = [inst_16890,inst_16876,inst_16887,inst_16888];
var inst_16892 = cljs.core.PersistentHashMap.fromArrays(inst_16889,inst_16891);
var _ = (function (){var statearr_16909 = state_16897;
(statearr_16909[(4)] = cljs.core.rest.call(null,(state_16897[(4)])));

return statearr_16909;
})();
var state_16897__$1 = state_16897;
var statearr_16910_16920 = state_16897__$1;
(statearr_16910_16920[(2)] = inst_16892);

(statearr_16910_16920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0 = (function (){
var statearr_16911 = [null,null,null,null,null,null,null];
(statearr_16911[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2746__auto__);

(statearr_16911[(1)] = (1));

return statearr_16911;
});
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1 = (function (state_16897){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16912){var ex__2749__auto__ = e16912;
var statearr_16913_16921 = state_16897;
(statearr_16913_16921[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16897[(4)]))){
var statearr_16914_16922 = state_16897;
(statearr_16914_16922[(1)] = cljs.core.first.call(null,(state_16897[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16923 = state_16897;
state_16897 = G__16923;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__ = function(state_16897){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1.call(this,state_16897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16915 = f__2769__auto__.call(null);
(statearr_16915[(6)] = c__2768__auto__);

return statearr_16915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16965){
var state_val_16966 = (state_16965[(1)]);
if((state_val_16966 === (7))){
var inst_16948 = (state_16965[(2)]);
var inst_16949 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_16948);
var inst_16950 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16951 = cljs.core.get.call(null,inst_16949,(114));
var inst_16952 = cljs.core.boolean$.call(null,inst_16951);
var inst_16953 = cljs.core.get.call(null,inst_16949,(110));
var inst_16954 = cljs.core.get.call(null,inst_16949,(117));
var inst_16955 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_16954);
var inst_16956 = cljs.core.get.call(null,inst_16949,(111));
var inst_16957 = cljs.core.get.call(null,inst_16949,(115));
var inst_16958 = cljs.core.get.call(null,inst_16949,(112));
var inst_16959 = [inst_16952,inst_16953,inst_16955,inst_16956,inst_16957,inst_16958];
var inst_16960 = cljs.core.PersistentHashMap.fromArrays(inst_16950,inst_16959);
var _ = (function (){var statearr_16967 = state_16965;
(statearr_16967[(4)] = cljs.core.rest.call(null,(state_16965[(4)])));

return statearr_16967;
})();
var state_16965__$1 = state_16965;
var statearr_16968_16991 = state_16965__$1;
(statearr_16968_16991[(2)] = inst_16960);

(statearr_16968_16991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16966 === (1))){
var state_16965__$1 = state_16965;
var statearr_16969_16992 = state_16965__$1;
(statearr_16969_16992[(2)] = null);

(statearr_16969_16992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16966 === (4))){
var inst_16924 = (state_16965[(2)]);
var state_16965__$1 = state_16965;
var statearr_16970_16993 = state_16965__$1;
(statearr_16970_16993[(2)] = inst_16924);

(statearr_16970_16993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16966 === (6))){
var _ = (function (){var statearr_16971 = state_16965;
(statearr_16971[(4)] = cljs.core.cons.call(null,(9),(state_16965[(4)])));

return statearr_16971;
})();
var inst_16936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16938 = ["_setting/id","root"];
var inst_16939 = (new cljs.core.PersistentVector(null,2,(5),inst_16937,inst_16938,null));
var inst_16940 = [inst_16939];
var inst_16941 = (new cljs.core.PersistentVector(null,1,(5),inst_16936,inst_16940,null));
var inst_16942 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16941);
var state_16965__$1 = state_16965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16965__$1,(10),inst_16942);
} else {
if((state_val_16966 === (3))){
var inst_16963 = (state_16965[(2)]);
var state_16965__$1 = state_16965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16965__$1,inst_16963);
} else {
if((state_val_16966 === (2))){
var _ = (function (){var statearr_16974 = state_16965;
(statearr_16974[(4)] = cljs.core.cons.call(null,(5),(state_16965[(4)])));

return statearr_16974;
})();
var state_16965__$1 = state_16965;
var statearr_16975_16994 = state_16965__$1;
(statearr_16975_16994[(2)] = null);

(statearr_16975_16994[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16966 === (9))){
var _ = (function (){var statearr_16976 = state_16965;
(statearr_16976[(4)] = cljs.core.rest.call(null,(state_16965[(4)])));

return statearr_16976;
})();
var state_16965__$1 = state_16965;
var ex16972 = (state_16965__$1[(2)]);
var statearr_16977_16995 = state_16965__$1;
(statearr_16977_16995[(5)] = ex16972);


var statearr_16978_16996 = state_16965__$1;
(statearr_16978_16996[(1)] = (8));

(statearr_16978_16996[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16966 === (5))){
var _ = (function (){var statearr_16979 = state_16965;
(statearr_16979[(4)] = cljs.core.rest.call(null,(state_16965[(4)])));

return statearr_16979;
})();
var state_16965__$1 = state_16965;
var ex16973 = (state_16965__$1[(2)]);
var statearr_16980_16997 = state_16965__$1;
(statearr_16980_16997[(5)] = ex16973);


if((ex16973 instanceof Error)){
var statearr_16981_16998 = state_16965__$1;
(statearr_16981_16998[(1)] = (4));

(statearr_16981_16998[(5)] = null);

} else {
throw ex16973;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16966 === (10))){
var inst_16944 = (state_16965[(2)]);
var inst_16945 = fluree.db.util.async.throw_err.call(null,inst_16944);
var _ = (function (){var statearr_16982 = state_16965;
(statearr_16982[(4)] = cljs.core.rest.call(null,(state_16965[(4)])));

return statearr_16982;
})();
var state_16965__$1 = state_16965;
var statearr_16983_16999 = state_16965__$1;
(statearr_16983_16999[(2)] = inst_16945);

(statearr_16983_16999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16966 === (8))){
var inst_16930 = (state_16965[(2)]);
var state_16965__$1 = (function (){var statearr_16984 = state_16965;
(statearr_16984[(7)] = inst_16930);

return statearr_16984;
})();
var statearr_16985_17000 = state_16965__$1;
(statearr_16985_17000[(2)] = null);

(statearr_16985_17000[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0 = (function (){
var statearr_16986 = [null,null,null,null,null,null,null,null];
(statearr_16986[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2746__auto__);

(statearr_16986[(1)] = (1));

return statearr_16986;
});
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1 = (function (state_16965){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16987){var ex__2749__auto__ = e16987;
var statearr_16988_17001 = state_16965;
(statearr_16988_17001[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16965[(4)]))){
var statearr_16989_17002 = state_16965;
(statearr_16989_17002[(1)] = cljs.core.first.call(null,(state_16965[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17003 = state_16965;
state_16965 = G__17003;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__ = function(state_16965){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1.call(this,state_16965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16990 = f__2769__auto__.call(null);
(statearr_16990[(6)] = c__2768__auto__);

return statearr_16990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
