// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (((cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13780 = match;
var p1 = cljs.core.nth.call(null,vec__13780,(0),null);
var p2 = cljs.core.nth.call(null,vec__13780,(1),null);
var p3 = cljs.core.nth.call(null,vec__13780,(2),null);
var t = cljs.core.nth.call(null,vec__13780,(3),null);
var op = cljs.core.nth.call(null,vec__13780,(4),null);
var m = cljs.core.nth.call(null,vec__13780,(5),null);
var G__13783 = idx;
var G__13783__$1 = (((G__13783 instanceof cljs.core.Keyword))?G__13783.fqn:null);
switch (G__13783__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13783__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13785 = idx;
var G__13785__$1 = (((G__13785 instanceof cljs.core.Keyword))?G__13785.fqn:null);
switch (G__13785__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13785__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13787 = idx;
var G__13787__$1 = (((G__13787 instanceof cljs.core.Keyword))?G__13787.fqn:null);
switch (G__13787__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13787__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13790 = arguments.length;
switch (G__13790) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13791 = (function (){var pred__13794 = cljs.core.identical_QMARK_;
var expr__13795 = test;
if(cljs.core.truth_(pred__13794.call(null,cljs.core._EQ_,expr__13795))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13794.call(null,cljs.core._LT_,expr__13795))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__13794.call(null,cljs.core._LT__EQ_,expr__13795))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13794.call(null,cljs.core._GT_,expr__13795))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__13794.call(null,cljs.core._GT__EQ_,expr__13795))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13795)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__13791,(0),null);
var start_match = cljs.core.nth.call(null,vec__13791,(1),null);
var end_test = cljs.core.nth.call(null,vec__13791,(2),null);
var end_match = cljs.core.nth.call(null,vec__13791,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14034){
var state_val_14035 = (state_14034[(1)]);
if((state_val_14035 === (65))){
var inst_13949 = (state_14034[(7)]);
var inst_14005 = (state_14034[(8)]);
var inst_14005__$1 = (state_14034[(2)]);
var inst_14006 = cljs.core.count.call(null,inst_14005__$1);
var state_14034__$1 = (function (){var statearr_14036 = state_14034;
(statearr_14036[(9)] = inst_14006);

(statearr_14036[(8)] = inst_14005__$1);

return statearr_14036;
})();
if(cljs.core.truth_(inst_13949)){
var statearr_14037_14174 = state_14034__$1;
(statearr_14037_14174[(1)] = (81));

} else {
var statearr_14038_14175 = state_14034__$1;
(statearr_14038_14175[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (70))){
var inst_13980 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
if(cljs.core.truth_(inst_13980)){
var statearr_14039_14176 = state_14034__$1;
(statearr_14039_14176[(1)] = (71));

} else {
var statearr_14040_14177 = state_14034__$1;
(statearr_14040_14177[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (62))){
var inst_13919 = (state_14034[(10)]);
var inst_13933 = (state_14034[(11)]);
var inst_13948 = (state_14034[(2)]);
var inst_13949 = fluree.db.dbproto._rhs.call(null,inst_13933);
var state_14034__$1 = (function (){var statearr_14041 = state_14034;
(statearr_14041[(7)] = inst_13949);

(statearr_14041[(12)] = inst_13948);

return statearr_14041;
})();
if(cljs.core.truth_(inst_13919)){
var statearr_14042_14178 = state_14034__$1;
(statearr_14042_14178[(1)] = (63));

} else {
var statearr_14043_14179 = state_14034__$1;
(statearr_14043_14179[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (74))){
var inst_13973 = (state_14034[(13)]);
var inst_13987 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_13973);
var state_14034__$1 = state_14034;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14034__$1,(77),inst_13987);
} else {
if((state_val_14035 === (7))){
var inst_13810 = (state_14034[(14)]);
var state_14034__$1 = state_14034;
var statearr_14044_14180 = state_14034__$1;
(statearr_14044_14180[(2)] = inst_13810);

(statearr_14044_14180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (59))){
var inst_13940 = (state_14034[(15)]);
var inst_13896 = (state_14034[(16)]);
var inst_13895 = (state_14034[(17)]);
var inst_13939 = (state_14034[(2)]);
var inst_13940__$1 = fluree.db.util.async.throw_err.call(null,inst_13939);
var inst_13941 = fluree.db.flake.subrange.call(null,inst_13940__$1,start_test,inst_13895,end_test,inst_13896);
var inst_13942 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_13895,inst_13896);
var state_14034__$1 = (function (){var statearr_14045 = state_14034;
(statearr_14045[(15)] = inst_13940__$1);

(statearr_14045[(18)] = inst_13941);

return statearr_14045;
})();
if(inst_13942){
var statearr_14046_14181 = state_14034__$1;
(statearr_14046_14181[(1)] = (60));

} else {
var statearr_14047_14182 = state_14034__$1;
(statearr_14047_14182[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (86))){
var inst_14014 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
var statearr_14048_14183 = state_14034__$1;
(statearr_14048_14183[(2)] = inst_14014);

(statearr_14048_14183[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (20))){
var inst_13859 = (state_14034[(19)]);
var inst_13811 = (state_14034[(20)]);
var inst_13858 = (state_14034[(2)]);
var inst_13859__$1 = (inst_13811 == null);
var state_14034__$1 = (function (){var statearr_14049 = state_14034;
(statearr_14049[(19)] = inst_13859__$1);

(statearr_14049[(21)] = inst_13858);

return statearr_14049;
})();
if(cljs.core.truth_(inst_13859__$1)){
var statearr_14050_14184 = state_14034__$1;
(statearr_14050_14184[(1)] = (22));

} else {
var statearr_14051_14185 = state_14034__$1;
(statearr_14051_14185[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (72))){
var inst_13966 = (state_14034[(22)]);
var inst_13984 = (inst_13966 + (1));
var inst_13985 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14034__$1 = (function (){var statearr_14052 = state_14034;
(statearr_14052[(23)] = inst_13984);

return statearr_14052;
})();
if(cljs.core.truth_(inst_13985)){
var statearr_14053_14186 = state_14034__$1;
(statearr_14053_14186[(1)] = (74));

} else {
var statearr_14054_14187 = state_14034__$1;
(statearr_14054_14187[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (58))){
var inst_14029 = (state_14034[(2)]);
var _ = (function (){var statearr_14055 = state_14034;
(statearr_14055[(4)] = cljs.core.rest.call(null,(state_14034[(4)])));

return statearr_14055;
})();
var state_14034__$1 = state_14034;
var statearr_14056_14188 = state_14034__$1;
(statearr_14056_14188[(2)] = inst_14029);

(statearr_14056_14188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (60))){
var inst_13821 = (state_14034[(24)]);
var inst_13885 = (state_14034[(25)]);
var inst_13906 = (state_14034[(26)]);
var inst_13923 = (state_14034[(27)]);
var inst_13867 = (state_14034[(28)]);
var inst_13820 = (state_14034[(29)]);
var inst_13809 = (state_14034[(30)]);
var inst_13935 = (state_14034[(31)]);
var inst_13940 = (state_14034[(15)]);
var inst_13941 = (state_14034[(18)]);
var inst_13919 = (state_14034[(10)]);
var inst_13901 = (state_14034[(32)]);
var inst_13814 = (state_14034[(33)]);
var inst_13831 = (state_14034[(34)]);
var inst_13896 = (state_14034[(16)]);
var inst_13934 = (state_14034[(35)]);
var inst_13902 = (state_14034[(36)]);
var inst_13928 = (state_14034[(37)]);
var inst_13813 = (state_14034[(38)]);
var inst_13816 = (state_14034[(39)]);
var inst_13912 = (state_14034[(40)]);
var inst_13876 = (state_14034[(41)]);
var inst_13895 = (state_14034[(17)]);
var inst_13840 = (state_14034[(42)]);
var inst_13913 = (state_14034[(43)]);
var inst_13849 = (state_14034[(44)]);
var inst_13933 = (state_14034[(11)]);
var inst_13894 = (state_14034[(45)]);
var inst_13858 = (state_14034[(21)]);
var inst_13944 = (function (){var no_filter_QMARK_ = inst_13919;
var next_node = inst_13933;
var flakes = inst_13940;
var s1 = inst_13831;
var o2 = inst_13858;
var t1 = inst_13813;
var i = inst_13934;
var m1 = inst_13885;
var root_node = inst_13928;
var to_t = inst_13913;
var s2 = inst_13840;
var p2 = inst_13876;
var permissions = inst_13902;
var limit = inst_13901;
var start_flake = inst_13895;
var acc = inst_13935;
var t2 = inst_13820;
var op1 = inst_13814;
var o1 = inst_13849;
var end_flake = inst_13896;
var base_result = inst_13941;
var p1 = inst_13867;
var vec__13803 = inst_13809;
var vec__13806 = inst_13816;
var idx_compare = inst_13906;
var op2 = inst_13821;
var from_t = inst_13912;
var m2 = inst_13894;
var novelty = inst_13923;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_13945 = cljs.core.reduce.call(null,inst_13944,inst_13941,inst_13941);
var state_14034__$1 = state_14034;
var statearr_14057_14189 = state_14034__$1;
(statearr_14057_14189[(2)] = inst_13945);

(statearr_14057_14189[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (27))){
var inst_13818 = (state_14034[(46)]);
var inst_13868 = (state_14034[(47)]);
var inst_13867 = (state_14034[(2)]);
var inst_13868__$1 = (inst_13818 == null);
var state_14034__$1 = (function (){var statearr_14058 = state_14034;
(statearr_14058[(28)] = inst_13867);

(statearr_14058[(47)] = inst_13868__$1);

return statearr_14058;
})();
if(cljs.core.truth_(inst_13868__$1)){
var statearr_14059_14190 = state_14034__$1;
(statearr_14059_14190[(1)] = (28));

} else {
var statearr_14060_14191 = state_14034__$1;
(statearr_14060_14191[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (1))){
var state_14034__$1 = state_14034;
var statearr_14061_14192 = state_14034__$1;
(statearr_14061_14192[(2)] = null);

(statearr_14061_14192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (69))){
var inst_13966 = (state_14034[(22)]);
var inst_13901 = (state_14034[(32)]);
var inst_13978 = (inst_13966 > inst_13901);
var state_14034__$1 = state_14034;
var statearr_14062_14193 = state_14034__$1;
(statearr_14062_14193[(2)] = inst_13978);

(statearr_14062_14193[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (24))){
var inst_13863 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
if(cljs.core.truth_(inst_13863)){
var statearr_14063_14194 = state_14034__$1;
(statearr_14063_14194[(1)] = (25));

} else {
var statearr_14064_14195 = state_14034__$1;
(statearr_14064_14195[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (55))){
var inst_13928 = (state_14034[(37)]);
var inst_13895 = (state_14034[(17)]);
var inst_13927 = (state_14034[(2)]);
var inst_13928__$1 = fluree.db.util.async.throw_err.call(null,inst_13927);
var inst_13929 = fluree.db.dbproto._lookup_leaf.call(null,inst_13928__$1,inst_13895);
var state_14034__$1 = (function (){var statearr_14065 = state_14034;
(statearr_14065[(37)] = inst_13928__$1);

return statearr_14065;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14034__$1,(56),inst_13929);
} else {
if((state_val_14035 === (85))){
var inst_14009 = (state_14034[(48)]);
var state_14034__$1 = state_14034;
var statearr_14066_14196 = state_14034__$1;
(statearr_14066_14196[(2)] = inst_14009);

(statearr_14066_14196[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (39))){
var inst_13883 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
var statearr_14067_14197 = state_14034__$1;
(statearr_14067_14197[(2)] = inst_13883);

(statearr_14067_14197[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (88))){
var inst_13949 = (state_14034[(7)]);
var inst_13928 = (state_14034[(37)]);
var inst_14021 = fluree.db.dbproto._lookup_leaf.call(null,inst_13928,inst_13949);
var state_14034__$1 = state_14034;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14034__$1,(90),inst_14021);
} else {
if((state_val_14035 === (46))){
var inst_13897 = (state_14034[(49)]);
var state_14034__$1 = state_14034;
var statearr_14068_14198 = state_14034__$1;
(statearr_14068_14198[(2)] = inst_13897);

(statearr_14068_14198[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (4))){
var inst_13797 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
var statearr_14069_14199 = state_14034__$1;
(statearr_14069_14199[(2)] = inst_13797);

(statearr_14069_14199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (77))){
var inst_13989 = (state_14034[(2)]);
var inst_13990 = fluree.db.util.async.throw_err.call(null,inst_13989);
var state_14034__$1 = state_14034;
if(cljs.core.truth_(inst_13990)){
var statearr_14070_14200 = state_14034__$1;
(statearr_14070_14200[(1)] = (78));

} else {
var statearr_14071_14201 = state_14034__$1;
(statearr_14071_14201[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (54))){
var inst_13919 = (state_14034[(2)]);
var inst_13920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13921 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13922 = (new cljs.core.PersistentVector(null,2,(5),inst_13920,inst_13921,null));
var inst_13923 = cljs.core.get_in.call(null,db,inst_13922);
var inst_13924 = cljs.core.get.call(null,db,idx);
var inst_13925 = fluree.db.dbproto._resolve.call(null,inst_13924);
var state_14034__$1 = (function (){var statearr_14072 = state_14034;
(statearr_14072[(27)] = inst_13923);

(statearr_14072[(10)] = inst_13919);

return statearr_14072;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14034__$1,(55),inst_13925);
} else {
if((state_val_14035 === (15))){
var inst_13812 = (state_14034[(50)]);
var state_14034__$1 = state_14034;
var statearr_14073_14202 = state_14034__$1;
(statearr_14073_14202[(2)] = inst_13812);

(statearr_14073_14202[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (48))){
var inst_13907 = (state_14034[(51)]);
var inst_13901 = (state_14034[(2)]);
var inst_13902 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13904 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13905 = (new cljs.core.PersistentVector(null,3,(5),inst_13903,inst_13904,null));
var inst_13906 = cljs.core.get_in.call(null,db,inst_13905);
var inst_13907__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_14034__$1 = (function (){var statearr_14074 = state_14034;
(statearr_14074[(26)] = inst_13906);

(statearr_14074[(32)] = inst_13901);

(statearr_14074[(36)] = inst_13902);

(statearr_14074[(51)] = inst_13907__$1);

return statearr_14074;
})();
if(cljs.core.truth_(inst_13907__$1)){
var statearr_14075_14203 = state_14034__$1;
(statearr_14075_14203[(1)] = (49));

} else {
var statearr_14076_14204 = state_14034__$1;
(statearr_14076_14204[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (50))){
var inst_13910 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_14034__$1 = state_14034;
var statearr_14077_14205 = state_14034__$1;
(statearr_14077_14205[(2)] = inst_13910);

(statearr_14077_14205[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (75))){
var inst_13967 = (state_14034[(52)]);
var state_14034__$1 = state_14034;
var statearr_14078_14206 = state_14034__$1;
(statearr_14078_14206[(2)] = inst_13967);

(statearr_14078_14206[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (21))){
var inst_13854 = (state_14034[(2)]);
var inst_13855 = fluree.db.util.async.throw_err.call(null,inst_13854);
var state_14034__$1 = state_14034;
var statearr_14079_14207 = state_14034__$1;
(statearr_14079_14207[(2)] = inst_13855);

(statearr_14079_14207[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (31))){
var state_14034__$1 = state_14034;
var statearr_14080_14208 = state_14034__$1;
(statearr_14080_14208[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14080_14208[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (32))){
var inst_13818 = (state_14034[(46)]);
var state_14034__$1 = state_14034;
var statearr_14081_14209 = state_14034__$1;
(statearr_14081_14209[(2)] = inst_13818);

(statearr_14081_14209[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (40))){
var inst_13822 = (state_14034[(53)]);
var state_14034__$1 = state_14034;
var statearr_14082_14210 = state_14034__$1;
(statearr_14082_14210[(2)] = inst_13822);

(statearr_14082_14210[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (56))){
var inst_13931 = (state_14034[(2)]);
var inst_13932 = fluree.db.util.async.throw_err.call(null,inst_13931);
var inst_13933 = inst_13932;
var inst_13934 = (0);
var inst_13935 = null;
var state_14034__$1 = (function (){var statearr_14083 = state_14034;
(statearr_14083[(31)] = inst_13935);

(statearr_14083[(35)] = inst_13934);

(statearr_14083[(11)] = inst_13933);

return statearr_14083;
})();
var statearr_14084_14211 = state_14034__$1;
(statearr_14084_14211[(2)] = null);

(statearr_14084_14211[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (33))){
var inst_13815 = (state_14034[(54)]);
var inst_13876 = (state_14034[(2)]);
var state_14034__$1 = (function (){var statearr_14085 = state_14034;
(statearr_14085[(41)] = inst_13876);

return statearr_14085;
})();
if(cljs.core.truth_(inst_13815)){
var statearr_14086_14212 = state_14034__$1;
(statearr_14086_14212[(1)] = (34));

} else {
var statearr_14087_14213 = state_14034__$1;
(statearr_14087_14213[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (13))){
var inst_13836 = (state_14034[(2)]);
var inst_13837 = fluree.db.util.async.throw_err.call(null,inst_13836);
var state_14034__$1 = state_14034;
var statearr_14088_14214 = state_14034__$1;
(statearr_14088_14214[(2)] = inst_13837);

(statearr_14088_14214[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (22))){
var inst_13849 = (state_14034[(44)]);
var state_14034__$1 = state_14034;
var statearr_14089_14215 = state_14034__$1;
(statearr_14089_14215[(2)] = inst_13849);

(statearr_14089_14215[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (90))){
var inst_14006 = (state_14034[(9)]);
var inst_14005 = (state_14034[(8)]);
var inst_14023 = (state_14034[(2)]);
var inst_14024 = fluree.db.util.async.throw_err.call(null,inst_14023);
var inst_13933 = inst_14024;
var inst_13934 = inst_14006;
var inst_13935 = inst_14005;
var state_14034__$1 = (function (){var statearr_14090 = state_14034;
(statearr_14090[(31)] = inst_13935);

(statearr_14090[(35)] = inst_13934);

(statearr_14090[(11)] = inst_13933);

return statearr_14090;
})();
var statearr_14091_14216 = state_14034__$1;
(statearr_14091_14216[(2)] = null);

(statearr_14091_14216[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (36))){
var inst_13822 = (state_14034[(53)]);
var inst_13885 = (state_14034[(2)]);
var state_14034__$1 = (function (){var statearr_14092 = state_14034;
(statearr_14092[(25)] = inst_13885);

return statearr_14092;
})();
if(cljs.core.truth_(inst_13822)){
var statearr_14093_14217 = state_14034__$1;
(statearr_14093_14217[(1)] = (40));

} else {
var statearr_14094_14218 = state_14034__$1;
(statearr_14094_14218[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (41))){
var inst_13888 = (cljs.core._LT__EQ_ === end_test);
var state_14034__$1 = state_14034;
if(cljs.core.truth_(inst_13888)){
var statearr_14095_14219 = state_14034__$1;
(statearr_14095_14219[(1)] = (43));

} else {
var statearr_14096_14220 = state_14034__$1;
(statearr_14096_14220[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (89))){
var inst_14027 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
var statearr_14097_14221 = state_14034__$1;
(statearr_14097_14221[(2)] = inst_14027);

(statearr_14097_14221[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (43))){
var state_14034__$1 = state_14034;
var statearr_14098_14222 = state_14034__$1;
(statearr_14098_14222[(2)] = (2147483647));

(statearr_14098_14222[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (61))){
var inst_13941 = (state_14034[(18)]);
var state_14034__$1 = state_14034;
var statearr_14099_14223 = state_14034__$1;
(statearr_14099_14223[(2)] = inst_13941);

(statearr_14099_14223[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (29))){
var inst_13868 = (state_14034[(47)]);
var state_14034__$1 = state_14034;
var statearr_14100_14224 = state_14034__$1;
(statearr_14100_14224[(2)] = inst_13868);

(statearr_14100_14224[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (44))){
var state_14034__$1 = state_14034;
var statearr_14101_14225 = state_14034__$1;
(statearr_14101_14225[(2)] = fluree.db.util.core.min_integer);

(statearr_14101_14225[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (6))){
var inst_13810 = (state_14034[(14)]);
var inst_13825 = fluree.db.dbproto._subid.call(null,db,inst_13810);
var state_14034__$1 = state_14034;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14034__$1,(9),inst_13825);
} else {
if((state_val_14035 === (28))){
var inst_13858 = (state_14034[(21)]);
var state_14034__$1 = state_14034;
var statearr_14102_14226 = state_14034__$1;
(statearr_14102_14226[(2)] = inst_13858);

(statearr_14102_14226[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (64))){
var inst_13948 = (state_14034[(12)]);
var inst_13934 = (state_14034[(35)]);
var inst_13962 = cljs.core.seq.call(null,inst_13948);
var inst_13963 = cljs.core.first.call(null,inst_13962);
var inst_13964 = cljs.core.next.call(null,inst_13962);
var inst_13965 = inst_13948;
var inst_13966 = inst_13934;
var inst_13967 = inst_13948;
var state_14034__$1 = (function (){var statearr_14103 = state_14034;
(statearr_14103[(22)] = inst_13966);

(statearr_14103[(55)] = inst_13965);

(statearr_14103[(52)] = inst_13967);

(statearr_14103[(56)] = inst_13963);

(statearr_14103[(57)] = inst_13964);

return statearr_14103;
})();
var statearr_14104_14227 = state_14034__$1;
(statearr_14104_14227[(2)] = null);

(statearr_14104_14227[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (51))){
var inst_13912 = (state_14034[(2)]);
var inst_13913 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13914 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14034__$1 = (function (){var statearr_14105 = state_14034;
(statearr_14105[(40)] = inst_13912);

(statearr_14105[(43)] = inst_13913);

return statearr_14105;
})();
if(cljs.core.truth_(inst_13914)){
var statearr_14106_14228 = state_14034__$1;
(statearr_14106_14228[(1)] = (52));

} else {
var statearr_14107_14229 = state_14034__$1;
(statearr_14107_14229[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (25))){
var state_14034__$1 = state_14034;
var statearr_14108_14230 = state_14034__$1;
(statearr_14108_14230[(2)] = (-1));

(statearr_14108_14230[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (34))){
var inst_13815 = (state_14034[(54)]);
var state_14034__$1 = state_14034;
var statearr_14109_14231 = state_14034__$1;
(statearr_14109_14231[(2)] = inst_13815);

(statearr_14109_14231[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (17))){
var inst_13845 = (state_14034[(2)]);
var inst_13846 = fluree.db.util.async.throw_err.call(null,inst_13845);
var state_14034__$1 = state_14034;
var statearr_14110_14232 = state_14034__$1;
(statearr_14110_14232[(2)] = inst_13846);

(statearr_14110_14232[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (3))){
var inst_14032 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14034__$1,inst_14032);
} else {
if((state_val_14035 === (12))){
var inst_13812 = (state_14034[(50)]);
var inst_13840 = (state_14034[(2)]);
var inst_13841 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13812);
var state_14034__$1 = (function (){var statearr_14111 = state_14034;
(statearr_14111[(42)] = inst_13840);

return statearr_14111;
})();
if(inst_13841){
var statearr_14112_14233 = state_14034__$1;
(statearr_14112_14233[(1)] = (14));

} else {
var statearr_14113_14234 = state_14034__$1;
(statearr_14113_14234[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (2))){
var inst_13809 = (state_14034[(30)]);
var inst_13810 = (state_14034[(14)]);
var inst_13816 = (state_14034[(39)]);
var _ = (function (){var statearr_14114 = state_14034;
(statearr_14114[(4)] = cljs.core.cons.call(null,(5),(state_14034[(4)])));

return statearr_14114;
})();
var inst_13809__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_13810__$1 = cljs.core.nth.call(null,inst_13809__$1,(0),null);
var inst_13811 = cljs.core.nth.call(null,inst_13809__$1,(1),null);
var inst_13812 = cljs.core.nth.call(null,inst_13809__$1,(2),null);
var inst_13813 = cljs.core.nth.call(null,inst_13809__$1,(3),null);
var inst_13814 = cljs.core.nth.call(null,inst_13809__$1,(4),null);
var inst_13815 = cljs.core.nth.call(null,inst_13809__$1,(5),null);
var inst_13816__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_13817 = cljs.core.nth.call(null,inst_13816__$1,(0),null);
var inst_13818 = cljs.core.nth.call(null,inst_13816__$1,(1),null);
var inst_13819 = cljs.core.nth.call(null,inst_13816__$1,(2),null);
var inst_13820 = cljs.core.nth.call(null,inst_13816__$1,(3),null);
var inst_13821 = cljs.core.nth.call(null,inst_13816__$1,(4),null);
var inst_13822 = cljs.core.nth.call(null,inst_13816__$1,(5),null);
var inst_13823 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13810__$1);
var state_14034__$1 = (function (){var statearr_14115 = state_14034;
(statearr_14115[(24)] = inst_13821);

(statearr_14115[(46)] = inst_13818);

(statearr_14115[(58)] = inst_13817);

(statearr_14115[(59)] = inst_13819);

(statearr_14115[(29)] = inst_13820);

(statearr_14115[(30)] = inst_13809__$1);

(statearr_14115[(54)] = inst_13815);

(statearr_14115[(33)] = inst_13814);

(statearr_14115[(14)] = inst_13810__$1);

(statearr_14115[(38)] = inst_13813);

(statearr_14115[(39)] = inst_13816__$1);

(statearr_14115[(53)] = inst_13822);

(statearr_14115[(20)] = inst_13811);

(statearr_14115[(50)] = inst_13812);

return statearr_14115;
})();
if(inst_13823){
var statearr_14116_14235 = state_14034__$1;
(statearr_14116_14235[(1)] = (6));

} else {
var statearr_14117_14236 = state_14034__$1;
(statearr_14117_14236[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (66))){
var inst_13965 = (state_14034[(55)]);
var inst_13973 = (state_14034[(13)]);
var inst_13975 = (state_14034[(60)]);
var inst_13972 = cljs.core.seq.call(null,inst_13965);
var inst_13973__$1 = cljs.core.first.call(null,inst_13972);
var inst_13974 = cljs.core.next.call(null,inst_13972);
var inst_13975__$1 = (inst_13973__$1 == null);
var state_14034__$1 = (function (){var statearr_14118 = state_14034;
(statearr_14118[(13)] = inst_13973__$1);

(statearr_14118[(60)] = inst_13975__$1);

(statearr_14118[(61)] = inst_13974);

return statearr_14118;
})();
if(cljs.core.truth_(inst_13975__$1)){
var statearr_14119_14237 = state_14034__$1;
(statearr_14119_14237[(1)] = (68));

} else {
var statearr_14120_14238 = state_14034__$1;
(statearr_14120_14238[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (23))){
var inst_13859 = (state_14034[(19)]);
var state_14034__$1 = state_14034;
var statearr_14121_14239 = state_14034__$1;
(statearr_14121_14239[(2)] = inst_13859);

(statearr_14121_14239[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (47))){
var state_14034__$1 = state_14034;
var statearr_14122_14240 = state_14034__$1;
(statearr_14122_14240[(2)] = fluree.db.util.core.max_long);

(statearr_14122_14240[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (35))){
var inst_13879 = (cljs.core._GT__EQ_ === start_test);
var state_14034__$1 = state_14034;
if(cljs.core.truth_(inst_13879)){
var statearr_14123_14241 = state_14034__$1;
(statearr_14123_14241[(1)] = (37));

} else {
var statearr_14124_14242 = state_14034__$1;
(statearr_14124_14242[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (82))){
var inst_13949 = (state_14034[(7)]);
var state_14034__$1 = state_14034;
var statearr_14125_14243 = state_14034__$1;
(statearr_14125_14243[(2)] = inst_13949);

(statearr_14125_14243[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (76))){
var inst_13974 = (state_14034[(61)]);
var inst_13984 = (state_14034[(23)]);
var inst_13998 = (state_14034[(2)]);
var inst_13965 = inst_13974;
var inst_13966 = inst_13984;
var inst_13967 = inst_13998;
var state_14034__$1 = (function (){var statearr_14126 = state_14034;
(statearr_14126[(22)] = inst_13966);

(statearr_14126[(55)] = inst_13965);

(statearr_14126[(52)] = inst_13967);

return statearr_14126;
})();
var statearr_14127_14244 = state_14034__$1;
(statearr_14127_14244[(2)] = null);

(statearr_14127_14244[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (19))){
var inst_13819 = (state_14034[(59)]);
var state_14034__$1 = state_14034;
var statearr_14128_14245 = state_14034__$1;
(statearr_14128_14245[(2)] = inst_13819);

(statearr_14128_14245[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (57))){
var inst_13923 = (state_14034[(27)]);
var inst_13912 = (state_14034[(40)]);
var inst_13913 = (state_14034[(43)]);
var inst_13933 = (state_14034[(11)]);
var inst_13937 = fluree.db.dbproto._resolve_history_range.call(null,inst_13933,inst_13912,inst_13913,inst_13923);
var state_14034__$1 = state_14034;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14034__$1,(59),inst_13937);
} else {
if((state_val_14035 === (68))){
var inst_13975 = (state_14034[(60)]);
var state_14034__$1 = state_14034;
var statearr_14129_14246 = state_14034__$1;
(statearr_14129_14246[(2)] = inst_13975);

(statearr_14129_14246[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (11))){
var inst_13817 = (state_14034[(58)]);
var state_14034__$1 = state_14034;
var statearr_14131_14247 = state_14034__$1;
(statearr_14131_14247[(2)] = inst_13817);

(statearr_14131_14247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (9))){
var inst_13827 = (state_14034[(2)]);
var inst_13828 = fluree.db.util.async.throw_err.call(null,inst_13827);
var state_14034__$1 = state_14034;
var statearr_14132_14248 = state_14034__$1;
(statearr_14132_14248[(2)] = inst_13828);

(statearr_14132_14248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (5))){
var _ = (function (){var statearr_14133 = state_14034;
(statearr_14133[(4)] = cljs.core.rest.call(null,(state_14034[(4)])));

return statearr_14133;
})();
var state_14034__$1 = state_14034;
var ex14130 = (state_14034__$1[(2)]);
var statearr_14134_14249 = state_14034__$1;
(statearr_14134_14249[(5)] = ex14130);


if((ex14130 instanceof Error)){
var statearr_14135_14250 = state_14034__$1;
(statearr_14135_14250[(1)] = (4));

(statearr_14135_14250[(5)] = null);

} else {
throw ex14130;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (83))){
var inst_14017 = (state_14034[(2)]);
var inst_14018 = cljs.core.not.call(null,inst_14017);
var state_14034__$1 = state_14034;
if(inst_14018){
var statearr_14136_14251 = state_14034__$1;
(statearr_14136_14251[(1)] = (87));

} else {
var statearr_14137_14252 = state_14034__$1;
(statearr_14137_14252[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (14))){
var inst_13812 = (state_14034[(50)]);
var inst_13843 = fluree.db.dbproto._subid.call(null,db,inst_13812);
var state_14034__$1 = state_14034;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14034__$1,(17),inst_13843);
} else {
if((state_val_14035 === (45))){
var inst_13892 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
var statearr_14138_14253 = state_14034__$1;
(statearr_14138_14253[(2)] = inst_13892);

(statearr_14138_14253[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (53))){
var state_14034__$1 = state_14034;
var statearr_14139_14254 = state_14034__$1;
(statearr_14139_14254[(2)] = true);

(statearr_14139_14254[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (78))){
var inst_13967 = (state_14034[(52)]);
var state_14034__$1 = state_14034;
var statearr_14140_14255 = state_14034__$1;
(statearr_14140_14255[(2)] = inst_13967);

(statearr_14140_14255[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (26))){
var inst_13811 = (state_14034[(20)]);
var state_14034__$1 = state_14034;
var statearr_14141_14256 = state_14034__$1;
(statearr_14141_14256[(2)] = inst_13811);

(statearr_14141_14256[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (16))){
var inst_13819 = (state_14034[(59)]);
var inst_13849 = (state_14034[(2)]);
var inst_13850 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13819);
var state_14034__$1 = (function (){var statearr_14142 = state_14034;
(statearr_14142[(44)] = inst_13849);

return statearr_14142;
})();
if(inst_13850){
var statearr_14143_14257 = state_14034__$1;
(statearr_14143_14257[(1)] = (18));

} else {
var statearr_14144_14258 = state_14034__$1;
(statearr_14144_14258[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (81))){
var inst_13906 = (state_14034[(26)]);
var inst_14009 = (state_14034[(48)]);
var inst_13949 = (state_14034[(7)]);
var inst_13896 = (state_14034[(16)]);
var inst_14008 = inst_13906.call(null,inst_13949,inst_13896);
var inst_14009__$1 = (inst_14008 < (0));
var state_14034__$1 = (function (){var statearr_14145 = state_14034;
(statearr_14145[(48)] = inst_14009__$1);

return statearr_14145;
})();
if(cljs.core.truth_(inst_14009__$1)){
var statearr_14146_14259 = state_14034__$1;
(statearr_14146_14259[(1)] = (84));

} else {
var statearr_14147_14260 = state_14034__$1;
(statearr_14147_14260[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (79))){
var inst_13973 = (state_14034[(13)]);
var inst_13967 = (state_14034[(52)]);
var inst_13993 = cljs.core.disj.call(null,inst_13967,inst_13973);
var state_14034__$1 = state_14034;
var statearr_14148_14261 = state_14034__$1;
(statearr_14148_14261[(2)] = inst_13993);

(statearr_14148_14261[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (38))){
var state_14034__$1 = state_14034;
var statearr_14149_14262 = state_14034__$1;
(statearr_14149_14262[(2)] = (2147483647));

(statearr_14149_14262[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (87))){
var inst_14005 = (state_14034[(8)]);
var state_14034__$1 = state_14034;
var statearr_14150_14263 = state_14034__$1;
(statearr_14150_14263[(2)] = inst_14005);

(statearr_14150_14263[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (30))){
var inst_13872 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
if(cljs.core.truth_(inst_13872)){
var statearr_14151_14264 = state_14034__$1;
(statearr_14151_14264[(1)] = (31));

} else {
var statearr_14152_14265 = state_14034__$1;
(statearr_14152_14265[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (73))){
var inst_14001 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
var statearr_14153_14266 = state_14034__$1;
(statearr_14153_14266[(2)] = inst_14001);

(statearr_14153_14266[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (10))){
var inst_13817 = (state_14034[(58)]);
var inst_13834 = fluree.db.dbproto._subid.call(null,db,inst_13817);
var state_14034__$1 = state_14034;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14034__$1,(13),inst_13834);
} else {
if((state_val_14035 === (18))){
var inst_13819 = (state_14034[(59)]);
var inst_13852 = fluree.db.dbproto._subid.call(null,db,inst_13819);
var state_14034__$1 = state_14034;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14034__$1,(21),inst_13852);
} else {
if((state_val_14035 === (52))){
var inst_13867 = (state_14034[(28)]);
var inst_13831 = (state_14034[(34)]);
var inst_13902 = (state_14034[(36)]);
var inst_13876 = (state_14034[(41)]);
var inst_13840 = (state_14034[(42)]);
var inst_13916 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_13902,inst_13831,inst_13840,inst_13867,inst_13876);
var state_14034__$1 = state_14034;
var statearr_14154_14267 = state_14034__$1;
(statearr_14154_14267[(2)] = inst_13916);

(statearr_14154_14267[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (67))){
var inst_14003 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
var statearr_14155_14268 = state_14034__$1;
(statearr_14155_14268[(2)] = inst_14003);

(statearr_14155_14268[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (71))){
var inst_13935 = (state_14034[(31)]);
var inst_13967 = (state_14034[(52)]);
var inst_13982 = cljs.core.into.call(null,inst_13967,inst_13935);
var state_14034__$1 = state_14034;
var statearr_14156_14269 = state_14034__$1;
(statearr_14156_14269[(2)] = inst_13982);

(statearr_14156_14269[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (42))){
var inst_13821 = (state_14034[(24)]);
var inst_13885 = (state_14034[(25)]);
var inst_13867 = (state_14034[(28)]);
var inst_13820 = (state_14034[(29)]);
var inst_13897 = (state_14034[(49)]);
var inst_13814 = (state_14034[(33)]);
var inst_13831 = (state_14034[(34)]);
var inst_13813 = (state_14034[(38)]);
var inst_13876 = (state_14034[(41)]);
var inst_13840 = (state_14034[(42)]);
var inst_13849 = (state_14034[(44)]);
var inst_13894 = (state_14034[(45)]);
var inst_13858 = (state_14034[(21)]);
var inst_13894__$1 = (state_14034[(2)]);
var inst_13895 = fluree.db.flake.__GT_Flake.call(null,inst_13831,inst_13867,inst_13849,inst_13813,inst_13814,inst_13885);
var inst_13896 = fluree.db.flake.__GT_Flake.call(null,inst_13840,inst_13876,inst_13858,inst_13820,inst_13821,inst_13894__$1);
var inst_13897__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_14034__$1 = (function (){var statearr_14157 = state_14034;
(statearr_14157[(49)] = inst_13897__$1);

(statearr_14157[(16)] = inst_13896);

(statearr_14157[(17)] = inst_13895);

(statearr_14157[(45)] = inst_13894__$1);

return statearr_14157;
})();
if(cljs.core.truth_(inst_13897__$1)){
var statearr_14158_14270 = state_14034__$1;
(statearr_14158_14270[(1)] = (46));

} else {
var statearr_14159_14271 = state_14034__$1;
(statearr_14159_14271[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (80))){
var inst_13995 = (state_14034[(2)]);
var state_14034__$1 = state_14034;
var statearr_14160_14272 = state_14034__$1;
(statearr_14160_14272[(2)] = inst_13995);

(statearr_14160_14272[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (37))){
var state_14034__$1 = state_14034;
var statearr_14161_14273 = state_14034__$1;
(statearr_14161_14273[(2)] = fluree.db.util.core.min_integer);

(statearr_14161_14273[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (63))){
var inst_13935 = (state_14034[(31)]);
var inst_13948 = (state_14034[(12)]);
var inst_13901 = (state_14034[(32)]);
var inst_13934 = (state_14034[(35)]);
var inst_13951 = (inst_13901 - inst_13934);
var inst_13952 = fluree.db.flake.take.call(null,inst_13951,inst_13948);
var inst_13953 = cljs.core.into.call(null,inst_13952,inst_13935);
var state_14034__$1 = state_14034;
var statearr_14162_14274 = state_14034__$1;
(statearr_14162_14274[(2)] = inst_13953);

(statearr_14162_14274[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (8))){
var inst_13817 = (state_14034[(58)]);
var inst_13831 = (state_14034[(2)]);
var inst_13832 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13817);
var state_14034__$1 = (function (){var statearr_14163 = state_14034;
(statearr_14163[(34)] = inst_13831);

return statearr_14163;
})();
if(inst_13832){
var statearr_14164_14275 = state_14034__$1;
(statearr_14164_14275[(1)] = (10));

} else {
var statearr_14165_14276 = state_14034__$1;
(statearr_14165_14276[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (49))){
var inst_13907 = (state_14034[(51)]);
var state_14034__$1 = state_14034;
var statearr_14166_14277 = state_14034__$1;
(statearr_14166_14277[(2)] = inst_13907);

(statearr_14166_14277[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14035 === (84))){
var inst_14006 = (state_14034[(9)]);
var inst_13901 = (state_14034[(32)]);
var inst_14011 = (inst_14006 < inst_13901);
var state_14034__$1 = state_14034;
var statearr_14167_14278 = state_14034__$1;
(statearr_14167_14278[(2)] = inst_14011);

(statearr_14167_14278[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_14168 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14168[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_14168[(1)] = (1));

return statearr_14168;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_14034){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14034);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14169){var ex__2749__auto__ = e14169;
var statearr_14170_14279 = state_14034;
(statearr_14170_14279[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14034[(4)]))){
var statearr_14171_14280 = state_14034;
(statearr_14171_14280[(1)] = cljs.core.first.call(null,(state_14034[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14281 = state_14034;
state_14034 = G__14281;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_14034){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_14034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14172 = f__2769__auto__.call(null);
(statearr_14172[(6)] = c__2768__auto__);

return statearr_14172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14356){
var state_val_14357 = (state_14356[(1)]);
if((state_val_14357 === (7))){
var inst_14351 = (state_14356[(2)]);
var _ = (function (){var statearr_14358 = state_14356;
(statearr_14358[(4)] = cljs.core.rest.call(null,(state_14356[(4)])));

return statearr_14358;
})();
var state_14356__$1 = state_14356;
var statearr_14359_14399 = state_14356__$1;
(statearr_14359_14399[(2)] = inst_14351);

(statearr_14359_14399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (20))){
var inst_14333 = (state_14356[(2)]);
var inst_14334 = fluree.db.util.async.throw_err.call(null,inst_14333);
var state_14356__$1 = state_14356;
var statearr_14360_14400 = state_14356__$1;
(statearr_14360_14400[(2)] = inst_14334);

(statearr_14360_14400[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (1))){
var state_14356__$1 = state_14356;
var statearr_14361_14401 = state_14356__$1;
(statearr_14361_14401[(2)] = null);

(statearr_14361_14401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (4))){
var inst_14282 = (state_14356[(2)]);
var state_14356__$1 = state_14356;
var statearr_14362_14402 = state_14356__$1;
(statearr_14362_14402[(2)] = inst_14282);

(statearr_14362_14402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (15))){
var inst_14329 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14356__$1 = state_14356;
if(cljs.core.truth_(inst_14329)){
var statearr_14363_14403 = state_14356__$1;
(statearr_14363_14403[(1)] = (17));

} else {
var statearr_14364_14404 = state_14356__$1;
(statearr_14364_14404[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (21))){
var state_14356__$1 = state_14356;
var statearr_14365_14405 = state_14356__$1;
(statearr_14365_14405[(2)] = (0));

(statearr_14365_14405[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (13))){
var inst_14321 = (state_14356[(2)]);
var state_14356__$1 = state_14356;
var statearr_14366_14406 = state_14356__$1;
(statearr_14366_14406[(2)] = inst_14321);

(statearr_14366_14406[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (22))){
var state_14356__$1 = state_14356;
var statearr_14367_14407 = state_14356__$1;
(statearr_14367_14407[(2)] = (1));

(statearr_14367_14407[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (6))){
var inst_14311 = (state_14356[(7)]);
var inst_14313 = (state_14356[(8)]);
var inst_14302 = (state_14356[(9)]);
var inst_14310 = cljs.core.seq.call(null,inst_14302);
var inst_14311__$1 = cljs.core.first.call(null,inst_14310);
var inst_14312 = cljs.core.next.call(null,inst_14310);
var inst_14313__$1 = (inst_14311__$1 == null);
var state_14356__$1 = (function (){var statearr_14368 = state_14356;
(statearr_14368[(7)] = inst_14311__$1);

(statearr_14368[(10)] = inst_14312);

(statearr_14368[(8)] = inst_14313__$1);

return statearr_14368;
})();
if(cljs.core.truth_(inst_14313__$1)){
var statearr_14369_14408 = state_14356__$1;
(statearr_14369_14408[(1)] = (8));

} else {
var statearr_14370_14409 = state_14356__$1;
(statearr_14370_14409[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (17))){
var inst_14311 = (state_14356[(7)]);
var inst_14331 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,inst_14311);
var state_14356__$1 = state_14356;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14356__$1,(20),inst_14331);
} else {
if((state_val_14357 === (3))){
var inst_14354 = (state_14356[(2)]);
var state_14356__$1 = state_14356;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14356__$1,inst_14354);
} else {
if((state_val_14357 === (12))){
var inst_14304 = (state_14356[(11)]);
var inst_14319 = (inst_14304 >= subject_limit);
var state_14356__$1 = state_14356;
var statearr_14371_14410 = state_14356__$1;
(statearr_14371_14410[(2)] = inst_14319);

(statearr_14371_14410[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (2))){
var _ = (function (){var statearr_14372 = state_14356;
(statearr_14372[(4)] = cljs.core.cons.call(null,(5),(state_14356[(4)])));

return statearr_14372;
})();
var inst_14295 = subject_groups;
var inst_14296 = cljs.core.seq.call(null,inst_14295);
var inst_14297 = cljs.core.first.call(null,inst_14296);
var inst_14298 = cljs.core.next.call(null,inst_14296);
var inst_14299 = flake_start;
var inst_14300 = subject_start;
var inst_14301 = cljs.core.PersistentVector.EMPTY;
var inst_14302 = inst_14295;
var inst_14303 = inst_14299;
var inst_14304 = inst_14300;
var inst_14305 = inst_14301;
var state_14356__$1 = (function (){var statearr_14373 = state_14356;
(statearr_14373[(12)] = inst_14298);

(statearr_14373[(13)] = inst_14303);

(statearr_14373[(14)] = inst_14297);

(statearr_14373[(15)] = inst_14305);

(statearr_14373[(11)] = inst_14304);

(statearr_14373[(9)] = inst_14302);

return statearr_14373;
})();
var statearr_14374_14411 = state_14356__$1;
(statearr_14374_14411[(2)] = null);

(statearr_14374_14411[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (23))){
var inst_14312 = (state_14356[(10)]);
var inst_14303 = (state_14356[(13)]);
var inst_14337 = (state_14356[(16)]);
var inst_14305 = (state_14356[(15)]);
var inst_14304 = (state_14356[(11)]);
var inst_14338 = (state_14356[(17)]);
var inst_14343 = (state_14356[(2)]);
var inst_14344 = (inst_14303 + inst_14338);
var inst_14345 = (inst_14304 + inst_14343);
var inst_14346 = cljs.core.into.call(null,inst_14305,inst_14337);
var inst_14302 = inst_14312;
var inst_14303__$1 = inst_14344;
var inst_14304__$1 = inst_14345;
var inst_14305__$1 = inst_14346;
var state_14356__$1 = (function (){var statearr_14375 = state_14356;
(statearr_14375[(13)] = inst_14303__$1);

(statearr_14375[(15)] = inst_14305__$1);

(statearr_14375[(11)] = inst_14304__$1);

(statearr_14375[(9)] = inst_14302);

return statearr_14375;
})();
var statearr_14376_14412 = state_14356__$1;
(statearr_14376_14412[(2)] = null);

(statearr_14376_14412[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (19))){
var inst_14337 = (state_14356[(16)]);
var inst_14338 = (state_14356[(17)]);
var inst_14337__$1 = (state_14356[(2)]);
var inst_14338__$1 = cljs.core.count.call(null,inst_14337__$1);
var inst_14339 = cljs.core._EQ_.call(null,(0),inst_14338__$1);
var state_14356__$1 = (function (){var statearr_14377 = state_14356;
(statearr_14377[(16)] = inst_14337__$1);

(statearr_14377[(17)] = inst_14338__$1);

return statearr_14377;
})();
if(inst_14339){
var statearr_14378_14413 = state_14356__$1;
(statearr_14378_14413[(1)] = (21));

} else {
var statearr_14379_14414 = state_14356__$1;
(statearr_14379_14414[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (11))){
var inst_14316 = (state_14356[(18)]);
var state_14356__$1 = state_14356;
var statearr_14381_14415 = state_14356__$1;
(statearr_14381_14415[(2)] = inst_14316);

(statearr_14381_14415[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (9))){
var inst_14303 = (state_14356[(13)]);
var inst_14316 = (state_14356[(18)]);
var inst_14316__$1 = (inst_14303 >= flake_limit);
var state_14356__$1 = (function (){var statearr_14382 = state_14356;
(statearr_14382[(18)] = inst_14316__$1);

return statearr_14382;
})();
if(cljs.core.truth_(inst_14316__$1)){
var statearr_14383_14416 = state_14356__$1;
(statearr_14383_14416[(1)] = (11));

} else {
var statearr_14384_14417 = state_14356__$1;
(statearr_14384_14417[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (5))){
var _ = (function (){var statearr_14385 = state_14356;
(statearr_14385[(4)] = cljs.core.rest.call(null,(state_14356[(4)])));

return statearr_14385;
})();
var state_14356__$1 = state_14356;
var ex14380 = (state_14356__$1[(2)]);
var statearr_14386_14418 = state_14356__$1;
(statearr_14386_14418[(5)] = ex14380);


if((ex14380 instanceof Error)){
var statearr_14387_14419 = state_14356__$1;
(statearr_14387_14419[(1)] = (4));

(statearr_14387_14419[(5)] = null);

} else {
throw ex14380;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (14))){
var inst_14303 = (state_14356[(13)]);
var inst_14305 = (state_14356[(15)]);
var inst_14304 = (state_14356[(11)]);
var inst_14325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14326 = [inst_14303,inst_14304,inst_14305];
var inst_14327 = (new cljs.core.PersistentVector(null,3,(5),inst_14325,inst_14326,null));
var state_14356__$1 = state_14356;
var statearr_14388_14420 = state_14356__$1;
(statearr_14388_14420[(2)] = inst_14327);

(statearr_14388_14420[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (16))){
var inst_14349 = (state_14356[(2)]);
var state_14356__$1 = state_14356;
var statearr_14389_14421 = state_14356__$1;
(statearr_14389_14421[(2)] = inst_14349);

(statearr_14389_14421[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (10))){
var inst_14323 = (state_14356[(2)]);
var state_14356__$1 = state_14356;
if(cljs.core.truth_(inst_14323)){
var statearr_14390_14422 = state_14356__$1;
(statearr_14390_14422[(1)] = (14));

} else {
var statearr_14391_14423 = state_14356__$1;
(statearr_14391_14423[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (18))){
var inst_14311 = (state_14356[(7)]);
var state_14356__$1 = state_14356;
var statearr_14392_14424 = state_14356__$1;
(statearr_14392_14424[(2)] = inst_14311);

(statearr_14392_14424[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14357 === (8))){
var inst_14313 = (state_14356[(8)]);
var state_14356__$1 = state_14356;
var statearr_14393_14425 = state_14356__$1;
(statearr_14393_14425[(2)] = inst_14313);

(statearr_14393_14425[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____0 = (function (){
var statearr_14394 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14394[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__);

(statearr_14394[(1)] = (1));

return statearr_14394;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____1 = (function (state_14356){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14356);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14395){var ex__2749__auto__ = e14395;
var statearr_14396_14426 = state_14356;
(statearr_14396_14426[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14356[(4)]))){
var statearr_14397_14427 = state_14356;
(statearr_14397_14427[(1)] = cljs.core.first.call(null,(state_14356[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14428 = state_14356;
state_14356 = G__14428;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__ = function(state_14356){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____1.call(this,state_14356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14398 = f__2769__auto__.call(null);
(statearr_14398[(6)] = c__2768__auto__);

return statearr_14398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14474){
var state_val_14475 = (state_14474[(1)]);
if((state_val_14475 === (7))){
var state_14474__$1 = state_14474;
var statearr_14476_14514 = state_14474__$1;
(statearr_14476_14514[(2)] = null);

(statearr_14476_14514[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (20))){
var inst_14460 = (state_14474[(2)]);
var inst_14461 = fluree.db.util.async.throw_err.call(null,inst_14460);
var inst_14439 = inst_14461;
var state_14474__$1 = (function (){var statearr_14477 = state_14474;
(statearr_14477[(7)] = inst_14439);

return statearr_14477;
})();
var statearr_14478_14515 = state_14474__$1;
(statearr_14478_14515[(2)] = null);

(statearr_14478_14515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (1))){
var state_14474__$1 = state_14474;
var statearr_14479_14516 = state_14474__$1;
(statearr_14479_14516[(2)] = null);

(statearr_14479_14516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (4))){
var inst_14429 = (state_14474[(2)]);
var state_14474__$1 = state_14474;
var statearr_14480_14517 = state_14474__$1;
(statearr_14480_14517[(2)] = inst_14429);

(statearr_14480_14517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (15))){
var inst_14439 = (state_14474[(7)]);
var inst_14456 = (state_14474[(8)]);
var inst_14456__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_14439);
var state_14474__$1 = (function (){var statearr_14481 = state_14474;
(statearr_14481[(8)] = inst_14456__$1);

return statearr_14481;
})();
if(cljs.core.truth_(inst_14456__$1)){
var statearr_14482_14518 = state_14474__$1;
(statearr_14482_14518[(1)] = (17));

} else {
var statearr_14483_14519 = state_14474__$1;
(statearr_14483_14519[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (13))){
var inst_14449 = (state_14474[(2)]);
var inst_14450 = fluree.db.util.async.throw_err.call(null,inst_14449);
var _ = (function (){var statearr_14484 = state_14474;
(statearr_14484[(4)] = cljs.core.rest.call(null,(state_14474[(4)])));

return statearr_14484;
})();
var state_14474__$1 = state_14474;
var statearr_14485_14520 = state_14474__$1;
(statearr_14485_14520[(2)] = inst_14450);

(statearr_14485_14520[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (6))){
var inst_14437 = (state_14474[(2)]);
var inst_14438 = fluree.db.util.async.throw_err.call(null,inst_14437);
var inst_14439 = inst_14438;
var state_14474__$1 = (function (){var statearr_14486 = state_14474;
(statearr_14486[(7)] = inst_14439);

return statearr_14486;
})();
var statearr_14487_14521 = state_14474__$1;
(statearr_14487_14521[(2)] = null);

(statearr_14487_14521[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (17))){
var inst_14456 = (state_14474[(8)]);
var inst_14458 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_14456);
var state_14474__$1 = state_14474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14474__$1,(20),inst_14458);
} else {
if((state_val_14475 === (3))){
var inst_14472 = (state_14474[(2)]);
var state_14474__$1 = state_14474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14474__$1,inst_14472);
} else {
if((state_val_14475 === (12))){
var _ = (function (){var statearr_14489 = state_14474;
(statearr_14489[(4)] = cljs.core.rest.call(null,(state_14474[(4)])));

return statearr_14489;
})();
var state_14474__$1 = state_14474;
var ex14488 = (state_14474__$1[(2)]);
var statearr_14490_14522 = state_14474__$1;
(statearr_14490_14522[(5)] = ex14488);


var statearr_14491_14523 = state_14474__$1;
(statearr_14491_14523[(1)] = (11));

(statearr_14491_14523[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (2))){
var _ = (function (){var statearr_14492 = state_14474;
(statearr_14492[(4)] = cljs.core.cons.call(null,(5),(state_14474[(4)])));

return statearr_14492;
})();
var inst_14435 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_14474__$1 = state_14474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14474__$1,(6),inst_14435);
} else {
if((state_val_14475 === (19))){
var inst_14465 = (state_14474[(2)]);
var state_14474__$1 = state_14474;
var statearr_14493_14524 = state_14474__$1;
(statearr_14493_14524[(2)] = inst_14465);

(statearr_14493_14524[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (11))){
var inst_14441 = (state_14474[(2)]);
var state_14474__$1 = (function (){var statearr_14495 = state_14474;
(statearr_14495[(9)] = inst_14441);

return statearr_14495;
})();
var statearr_14496_14525 = state_14474__$1;
(statearr_14496_14525[(2)] = null);

(statearr_14496_14525[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (9))){
var inst_14439 = (state_14474[(7)]);
var _ = (function (){var statearr_14497 = state_14474;
(statearr_14497[(4)] = cljs.core.cons.call(null,(12),(state_14474[(4)])));

return statearr_14497;
})();
var inst_14447 = fluree.db.dbproto._resolve_to_t.call(null,inst_14439,t,novelty,fast_forward_db_QMARK_);
var state_14474__$1 = state_14474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14474__$1,(13),inst_14447);
} else {
if((state_val_14475 === (5))){
var _ = (function (){var statearr_14498 = state_14474;
(statearr_14498[(4)] = cljs.core.rest.call(null,(state_14474[(4)])));

return statearr_14498;
})();
var state_14474__$1 = state_14474;
var ex14494 = (state_14474__$1[(2)]);
var statearr_14499_14526 = state_14474__$1;
(statearr_14499_14526[(5)] = ex14494);


if((ex14494 instanceof Error)){
var statearr_14500_14527 = state_14474__$1;
(statearr_14500_14527[(1)] = (4));

(statearr_14500_14527[(5)] = null);

} else {
throw ex14494;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (14))){
var inst_14453 = (state_14474[(10)]);
var state_14474__$1 = state_14474;
var statearr_14501_14528 = state_14474__$1;
(statearr_14501_14528[(2)] = inst_14453);

(statearr_14501_14528[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (16))){
var inst_14467 = (state_14474[(2)]);
var state_14474__$1 = state_14474;
var statearr_14502_14529 = state_14474__$1;
(statearr_14502_14529[(2)] = inst_14467);

(statearr_14502_14529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (10))){
var inst_14453 = (state_14474[(10)]);
var inst_14453__$1 = (state_14474[(2)]);
var state_14474__$1 = (function (){var statearr_14503 = state_14474;
(statearr_14503[(10)] = inst_14453__$1);

return statearr_14503;
})();
if(cljs.core.truth_(inst_14453__$1)){
var statearr_14504_14530 = state_14474__$1;
(statearr_14504_14530[(1)] = (14));

} else {
var statearr_14505_14531 = state_14474__$1;
(statearr_14505_14531[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (18))){
var state_14474__$1 = state_14474;
var statearr_14506_14532 = state_14474__$1;
(statearr_14506_14532[(2)] = null);

(statearr_14506_14532[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14475 === (8))){
var inst_14469 = (state_14474[(2)]);
var _ = (function (){var statearr_14507 = state_14474;
(statearr_14507[(4)] = cljs.core.rest.call(null,(state_14474[(4)])));

return statearr_14507;
})();
var state_14474__$1 = state_14474;
var statearr_14508_14533 = state_14474__$1;
(statearr_14508_14533[(2)] = inst_14469);

(statearr_14508_14533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____0 = (function (){
var statearr_14509 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14509[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__);

(statearr_14509[(1)] = (1));

return statearr_14509;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____1 = (function (state_14474){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14510){var ex__2749__auto__ = e14510;
var statearr_14511_14534 = state_14474;
(statearr_14511_14534[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14474[(4)]))){
var statearr_14512_14535 = state_14474;
(statearr_14512_14535[(1)] = cljs.core.first.call(null,(state_14474[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14536 = state_14474;
state_14474 = G__14536;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__ = function(state_14474){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____1.call(this,state_14474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14513 = f__2769__auto__.call(null);
(statearr_14513[(6)] = c__2768__auto__);

return statearr_14513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14543 = arguments.length;
switch (G__14543) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14544 = (function (){var pred__14547 = cljs.core.identical_QMARK_;
var expr__14548 = test;
if(cljs.core.truth_(pred__14547.call(null,cljs.core._EQ_,expr__14548))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14547.call(null,cljs.core._LT_,expr__14548))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__14547.call(null,cljs.core._LT__EQ_,expr__14548))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14547.call(null,cljs.core._GT_,expr__14548))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__14547.call(null,cljs.core._GT__EQ_,expr__14548))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14548)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__14544,(0),null);
var start_match = cljs.core.nth.call(null,vec__14544,(1),null);
var end_test = cljs.core.nth.call(null,vec__14544,(2),null);
var end_match = cljs.core.nth.call(null,vec__14544,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14920){
var state_val_14921 = (state_14920[(1)]);
if((state_val_14921 === (121))){
var inst_14876 = (state_14920[(7)]);
var state_14920__$1 = state_14920;
var statearr_14922_15115 = state_14920__$1;
(statearr_14922_15115[(2)] = inst_14876);

(statearr_14922_15115[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (65))){
var inst_14728 = (state_14920[(8)]);
var inst_14734 = (state_14920[(2)]);
var state_14920__$1 = (function (){var statearr_14923 = state_14920;
(statearr_14923[(9)] = inst_14734);

return statearr_14923;
})();
if(cljs.core.truth_(inst_14728)){
var statearr_14924_15116 = state_14920__$1;
(statearr_14924_15116[(1)] = (66));

} else {
var statearr_14925_15117 = state_14920__$1;
(statearr_14925_15117[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (70))){
var inst_14912 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_14926_15118 = state_14920__$1;
(statearr_14926_15118[(2)] = inst_14912);

(statearr_14926_15118[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (62))){
var inst_14727 = (state_14920[(2)]);
var inst_14728 = fluree.db.util.async.throw_err.call(null,inst_14727);
var inst_14729 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14920__$1 = (function (){var statearr_14927 = state_14920;
(statearr_14927[(8)] = inst_14728);

return statearr_14927;
})();
if(cljs.core.truth_(inst_14729)){
var statearr_14928_15119 = state_14920__$1;
(statearr_14928_15119[(1)] = (63));

} else {
var statearr_14929_15120 = state_14920__$1;
(statearr_14929_15120[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (74))){
var inst_14697 = (state_14920[(10)]);
var inst_14574 = (state_14920[(11)]);
var inst_14707 = (state_14920[(12)]);
var inst_14642 = (state_14920[(13)]);
var inst_14747 = (state_14920[(14)]);
var inst_14724 = (state_14920[(15)]);
var inst_14696 = (state_14920[(16)]);
var inst_14587 = (state_14920[(17)]);
var inst_14669 = (state_14920[(18)]);
var inst_14740 = (state_14920[(19)]);
var inst_14709 = (state_14920[(20)]);
var inst_14606 = (state_14920[(21)]);
var inst_14638 = (state_14920[(22)]);
var inst_14701 = (state_14920[(23)]);
var inst_14700 = (state_14920[(24)]);
var inst_14575 = (state_14920[(25)]);
var inst_14597 = (state_14920[(26)]);
var inst_14741 = (state_14920[(27)]);
var inst_14718 = (state_14920[(28)]);
var inst_14581 = (state_14920[(29)]);
var inst_14678 = (state_14920[(30)]);
var inst_14714 = (state_14920[(31)]);
var inst_14738 = (state_14920[(32)]);
var inst_14687 = (state_14920[(33)]);
var inst_14713 = (state_14920[(34)]);
var inst_14577 = (state_14920[(35)]);
var inst_14698 = (state_14920[(36)]);
var inst_14639 = (state_14920[(37)]);
var inst_14728 = (state_14920[(8)]);
var inst_14734 = (state_14920[(9)]);
var inst_14755 = (state_14920[(38)]);
var inst_14660 = (state_14920[(39)]);
var inst_14708 = (state_14920[(40)]);
var inst_14719 = (state_14920[(41)]);
var inst_14651 = (state_14920[(42)]);
var inst_14739 = (state_14920[(43)]);
var inst_14737 = (state_14920[(44)]);
var inst_14586 = (state_14920[(45)]);
var inst_14585 = (state_14920[(46)]);
var inst_14582 = (state_14920[(47)]);
var inst_14570 = (state_14920[(48)]);
var inst_14757 = (function (){var no_filter_QMARK_ = inst_14734;
var t = inst_14714;
var max_limit_QMARK_ = inst_14708;
var next_node = inst_14737;
var fast_forward_db_QMARK_ = inst_14719;
var s1 = inst_14597;
var o2 = inst_14660;
var t1 = inst_14574;
var predicate_fn = inst_14587;
var i = inst_14739;
var m1 = inst_14687;
var root_node = inst_14724;
var vec__14556 = inst_14570;
var s2 = inst_14606;
var vec__14559 = inst_14577;
var p2 = inst_14678;
var permissions = inst_14709;
var vec__14566 = inst_14639;
var vec__14563 = inst_14638;
var limit = inst_14707;
var start_flake = inst_14697;
var flake_limit = inst_14701;
var G__14748 = inst_14755;
var offset = inst_14738;
var acc = inst_14741;
var map__14569 = inst_14700;
var t2 = inst_14581;
var op1 = inst_14575;
var o1 = inst_14651;
var end_flake = inst_14698;
var base_result = inst_14747;
var s = inst_14740;
var node_start = inst_14728;
var p1 = inst_14669;
var subject_fn = inst_14586;
var object_fn = inst_14642;
var idx_compare = inst_14713;
var map__14562 = inst_14585;
var op2 = inst_14582;
var m2 = inst_14696;
var novelty = inst_14718;
return (function (p1__14538_SHARP_){
return subject_fn.call(null,p1__14538_SHARP_.s);
});
})();
var inst_14758 = cljs.core.filter.call(null,inst_14757,inst_14755);
var state_14920__$1 = state_14920;
var statearr_14930_15121 = state_14920__$1;
(statearr_14930_15121[(2)] = inst_14758);

(statearr_14930_15121[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (110))){
var inst_14889 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_14931_15122 = state_14920__$1;
(statearr_14931_15122[(2)] = inst_14889);

(statearr_14931_15122[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (7))){
var inst_14571 = (state_14920[(49)]);
var state_14920__$1 = state_14920;
var statearr_14932_15123 = state_14920__$1;
(statearr_14932_15123[(2)] = inst_14571);

(statearr_14932_15123[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (59))){
var state_14920__$1 = state_14920;
var statearr_14933_15124 = state_14920__$1;
(statearr_14933_15124[(2)] = fluree.db.util.core.max_long);

(statearr_14933_15124[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (86))){
var inst_14734 = (state_14920[(9)]);
var state_14920__$1 = state_14920;
var statearr_14934_15125 = state_14920__$1;
(statearr_14934_15125[(2)] = inst_14734);

(statearr_14934_15125[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (20))){
var state_14920__$1 = state_14920;
var statearr_14935_15126 = state_14920__$1;
(statearr_14935_15126[(2)] = null);

(statearr_14935_15126[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (72))){
var inst_14747 = (state_14920[(14)]);
var state_14920__$1 = state_14920;
var statearr_14936_15127 = state_14920__$1;
(statearr_14936_15127[(2)] = inst_14747);

(statearr_14936_15127[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (58))){
var inst_14702 = (state_14920[(50)]);
var state_14920__$1 = state_14920;
var statearr_14937_15128 = state_14920__$1;
(statearr_14937_15128[(2)] = inst_14702);

(statearr_14937_15128[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (60))){
var inst_14707 = (state_14920[(12)]);
var inst_14707__$1 = (state_14920[(2)]);
var inst_14708 = cljs.core._EQ_.call(null,inst_14707__$1,fluree.db.util.core.max_long);
var inst_14709 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14711 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14712 = (new cljs.core.PersistentVector(null,3,(5),inst_14710,inst_14711,null));
var inst_14713 = cljs.core.get_in.call(null,db,inst_14712);
var inst_14714 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14716 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14717 = (new cljs.core.PersistentVector(null,2,(5),inst_14715,inst_14716,null));
var inst_14718 = cljs.core.get_in.call(null,db,inst_14717);
var inst_14719 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14720 = cljs.core.get.call(null,db,idx);
var inst_14721 = fluree.db.dbproto._resolve.call(null,inst_14720);
var state_14920__$1 = (function (){var statearr_14938 = state_14920;
(statearr_14938[(12)] = inst_14707__$1);

(statearr_14938[(20)] = inst_14709);

(statearr_14938[(28)] = inst_14718);

(statearr_14938[(31)] = inst_14714);

(statearr_14938[(34)] = inst_14713);

(statearr_14938[(40)] = inst_14708);

(statearr_14938[(41)] = inst_14719);

return statearr_14938;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14920__$1,(61),inst_14721);
} else {
if((state_val_14921 === (27))){
var inst_14640 = (state_14920[(51)]);
var state_14920__$1 = state_14920;
var statearr_14939_15129 = state_14920__$1;
(statearr_14939_15129[(2)] = inst_14640);

(statearr_14939_15129[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (1))){
var state_14920__$1 = state_14920;
var statearr_14940_15130 = state_14920__$1;
(statearr_14940_15130[(2)] = null);

(statearr_14940_15130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (69))){
var inst_14697 = (state_14920[(10)]);
var inst_14698 = (state_14920[(36)]);
var inst_14737 = (state_14920[(44)]);
var inst_14746 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14737);
var inst_14747 = fluree.db.flake.subrange.call(null,inst_14746,start_test,inst_14697,end_test,inst_14698);
var inst_14749 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_14697,inst_14698);
var state_14920__$1 = (function (){var statearr_14941 = state_14920;
(statearr_14941[(14)] = inst_14747);

return statearr_14941;
})();
if(inst_14749){
var statearr_14942_15131 = state_14920__$1;
(statearr_14942_15131[(1)] = (71));

} else {
var statearr_14943_15132 = state_14920__$1;
(statearr_14943_15132[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (101))){
var inst_14835 = (state_14920[(52)]);
var inst_14701 = (state_14920[(23)]);
var inst_14834 = (state_14920[(53)]);
var inst_14833 = (state_14920[(54)]);
var inst_14838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14839 = (inst_14835 - inst_14701);
var inst_14840 = (inst_14834 - inst_14839);
var inst_14841 = cljs.core.take.call(null,inst_14840,inst_14833);
var inst_14842 = [inst_14701,inst_14841];
var inst_14843 = (new cljs.core.PersistentVector(null,2,(5),inst_14838,inst_14842,null));
var state_14920__$1 = state_14920;
var statearr_14944_15133 = state_14920__$1;
(statearr_14944_15133[(2)] = inst_14843);

(statearr_14944_15133[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (24))){
var inst_14583 = (state_14920[(55)]);
var inst_14574 = (state_14920[(11)]);
var inst_14588 = (state_14920[(56)]);
var inst_14587 = (state_14920[(17)]);
var inst_14606 = (state_14920[(21)]);
var inst_14575 = (state_14920[(25)]);
var inst_14597 = (state_14920[(26)]);
var inst_14581 = (state_14920[(29)]);
var inst_14579 = (state_14920[(57)]);
var inst_14577 = (state_14920[(35)]);
var inst_14572 = (state_14920[(58)]);
var inst_14576 = (state_14920[(59)]);
var inst_14580 = (state_14920[(60)]);
var inst_14586 = (state_14920[(45)]);
var inst_14585 = (state_14920[(46)]);
var inst_14582 = (state_14920[(47)]);
var inst_14570 = (state_14920[(48)]);
var inst_14573 = (state_14920[(61)]);
var inst_14620 = (state_14920[(62)]);
var inst_14630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14632 = [null,null];
var inst_14633 = (new cljs.core.PersistentVector(null,2,(5),inst_14631,inst_14632,null));
var inst_14634 = (function (){var bool = inst_14620;
var s1 = inst_14597;
var o2 = inst_14580;
var t1 = inst_14574;
var predicate_fn = inst_14587;
var m1 = inst_14576;
var vec__14556 = inst_14570;
var s2 = inst_14606;
var vec__14559 = inst_14577;
var p2 = inst_14579;
var t2 = inst_14581;
var op1 = inst_14575;
var o1 = inst_14573;
var p1 = inst_14572;
var subject_fn = inst_14586;
var object_fn = inst_14588;
var map__14562 = inst_14585;
var op2 = inst_14582;
var m2 = inst_14583;
var temp__5755__auto__ = inst_14620;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_14635 = [inst_14633,inst_14634];
var inst_14636 = (new cljs.core.PersistentVector(null,2,(5),inst_14630,inst_14635,null));
var state_14920__$1 = state_14920;
var statearr_14945_15134 = state_14920__$1;
(statearr_14945_15134[(2)] = inst_14636);

(statearr_14945_15134[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (102))){
var inst_14835 = (state_14920[(52)]);
var inst_14833 = (state_14920[(54)]);
var inst_14845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14846 = [inst_14835,inst_14833];
var inst_14847 = (new cljs.core.PersistentVector(null,2,(5),inst_14845,inst_14846,null));
var state_14920__$1 = state_14920;
var statearr_14946_15135 = state_14920__$1;
(statearr_14946_15135[(2)] = inst_14847);

(statearr_14946_15135[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (55))){
var state_14920__$1 = state_14920;
var statearr_14947_15136 = state_14920__$1;
(statearr_14947_15136[(2)] = (2147483647));

(statearr_14947_15136[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (85))){
var inst_14783 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
if(cljs.core.truth_(inst_14783)){
var statearr_14948_15137 = state_14920__$1;
(statearr_14948_15137[(1)] = (89));

} else {
var statearr_14949_15138 = state_14920__$1;
(statearr_14949_15138[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (39))){
var inst_14670 = (state_14920[(63)]);
var inst_14579 = (state_14920[(57)]);
var inst_14669 = (state_14920[(2)]);
var inst_14670__$1 = (inst_14579 == null);
var state_14920__$1 = (function (){var statearr_14950 = state_14920;
(statearr_14950[(18)] = inst_14669);

(statearr_14950[(63)] = inst_14670__$1);

return statearr_14950;
})();
if(cljs.core.truth_(inst_14670__$1)){
var statearr_14951_15139 = state_14920__$1;
(statearr_14951_15139[(1)] = (40));

} else {
var statearr_14952_15140 = state_14920__$1;
(statearr_14952_15140[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (88))){
var inst_14780 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_14953_15141 = state_14920__$1;
(statearr_14953_15141[(2)] = inst_14780);

(statearr_14953_15141[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (46))){
var inst_14576 = (state_14920[(59)]);
var state_14920__$1 = state_14920;
var statearr_14954_15142 = state_14920__$1;
(statearr_14954_15142[(2)] = inst_14576);

(statearr_14954_15142[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (4))){
var inst_14550 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_14955_15143 = state_14920__$1;
(statearr_14955_15143[(2)] = inst_14550);

(statearr_14955_15143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (77))){
var inst_14697 = (state_14920[(10)]);
var inst_14574 = (state_14920[(11)]);
var inst_14707 = (state_14920[(12)]);
var inst_14642 = (state_14920[(13)]);
var inst_14747 = (state_14920[(14)]);
var inst_14724 = (state_14920[(15)]);
var inst_14696 = (state_14920[(16)]);
var inst_14761 = (state_14920[(64)]);
var inst_14587 = (state_14920[(17)]);
var inst_14669 = (state_14920[(18)]);
var inst_14740 = (state_14920[(19)]);
var inst_14709 = (state_14920[(20)]);
var inst_14606 = (state_14920[(21)]);
var inst_14638 = (state_14920[(22)]);
var inst_14701 = (state_14920[(23)]);
var inst_14700 = (state_14920[(24)]);
var inst_14575 = (state_14920[(25)]);
var inst_14597 = (state_14920[(26)]);
var inst_14741 = (state_14920[(27)]);
var inst_14718 = (state_14920[(28)]);
var inst_14581 = (state_14920[(29)]);
var inst_14678 = (state_14920[(30)]);
var inst_14714 = (state_14920[(31)]);
var inst_14738 = (state_14920[(32)]);
var inst_14687 = (state_14920[(33)]);
var inst_14713 = (state_14920[(34)]);
var inst_14577 = (state_14920[(35)]);
var inst_14698 = (state_14920[(36)]);
var inst_14639 = (state_14920[(37)]);
var inst_14728 = (state_14920[(8)]);
var inst_14734 = (state_14920[(9)]);
var inst_14660 = (state_14920[(39)]);
var inst_14708 = (state_14920[(40)]);
var inst_14719 = (state_14920[(41)]);
var inst_14651 = (state_14920[(42)]);
var inst_14739 = (state_14920[(43)]);
var inst_14737 = (state_14920[(44)]);
var inst_14586 = (state_14920[(45)]);
var inst_14585 = (state_14920[(46)]);
var inst_14582 = (state_14920[(47)]);
var inst_14570 = (state_14920[(48)]);
var inst_14763 = (function (){var no_filter_QMARK_ = inst_14734;
var t = inst_14714;
var max_limit_QMARK_ = inst_14708;
var next_node = inst_14737;
var fast_forward_db_QMARK_ = inst_14719;
var s1 = inst_14597;
var o2 = inst_14660;
var t1 = inst_14574;
var predicate_fn = inst_14587;
var i = inst_14739;
var m1 = inst_14687;
var root_node = inst_14724;
var vec__14556 = inst_14570;
var s2 = inst_14606;
var vec__14559 = inst_14577;
var p2 = inst_14678;
var permissions = inst_14709;
var vec__14566 = inst_14639;
var vec__14563 = inst_14638;
var limit = inst_14707;
var start_flake = inst_14697;
var flake_limit = inst_14701;
var G__14748 = inst_14761;
var offset = inst_14738;
var acc = inst_14741;
var map__14569 = inst_14700;
var t2 = inst_14581;
var op1 = inst_14575;
var o1 = inst_14651;
var end_flake = inst_14698;
var base_result = inst_14747;
var s = inst_14740;
var node_start = inst_14728;
var p1 = inst_14669;
var subject_fn = inst_14586;
var object_fn = inst_14642;
var idx_compare = inst_14713;
var map__14562 = inst_14585;
var op2 = inst_14582;
var m2 = inst_14696;
var novelty = inst_14718;
return (function (p1__14539_SHARP_){
return predicate_fn.call(null,p1__14539_SHARP_.p);
});
})();
var inst_14764 = cljs.core.filter.call(null,inst_14763,inst_14761);
var state_14920__$1 = state_14920;
var statearr_14956_15144 = state_14920__$1;
(statearr_14956_15144[(2)] = inst_14764);

(statearr_14956_15144[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (106))){
var inst_14774 = (state_14920[(65)]);
var state_14920__$1 = state_14920;
var statearr_14957_15145 = state_14920__$1;
(statearr_14957_15145[(2)] = inst_14774);

(statearr_14957_15145[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (119))){
var inst_14892 = (state_14920[(66)]);
var state_14920__$1 = state_14920;
var statearr_14958_15146 = state_14920__$1;
(statearr_14958_15146[(2)] = inst_14892);

(statearr_14958_15146[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (95))){
var inst_14707 = (state_14920[(12)]);
var inst_14740 = (state_14920[(19)]);
var inst_14817 = (state_14920[(67)]);
var inst_14815 = (state_14920[(68)]);
var inst_14816 = (state_14920[(69)]);
var inst_14807 = (state_14920[(70)]);
var inst_14815__$1 = cljs.core.count.call(null,inst_14807);
var inst_14816__$1 = (inst_14740 + inst_14815__$1);
var inst_14817__$1 = (inst_14816__$1 - inst_14707);
var inst_14818 = cljs.core.pos_int_QMARK_.call(null,inst_14817__$1);
var state_14920__$1 = (function (){var statearr_14959 = state_14920;
(statearr_14959[(67)] = inst_14817__$1);

(statearr_14959[(68)] = inst_14815__$1);

(statearr_14959[(69)] = inst_14816__$1);

return statearr_14959;
})();
if(inst_14818){
var statearr_14960_15147 = state_14920__$1;
(statearr_14960_15147[(1)] = (98));

} else {
var statearr_14961_15148 = state_14920__$1;
(statearr_14961_15148[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (54))){
var inst_14574 = (state_14920[(11)]);
var inst_14696 = (state_14920[(16)]);
var inst_14669 = (state_14920[(18)]);
var inst_14606 = (state_14920[(21)]);
var inst_14700 = (state_14920[(24)]);
var inst_14575 = (state_14920[(25)]);
var inst_14597 = (state_14920[(26)]);
var inst_14581 = (state_14920[(29)]);
var inst_14678 = (state_14920[(30)]);
var inst_14687 = (state_14920[(33)]);
var inst_14702 = (state_14920[(50)]);
var inst_14660 = (state_14920[(39)]);
var inst_14651 = (state_14920[(42)]);
var inst_14582 = (state_14920[(47)]);
var inst_14696__$1 = (state_14920[(2)]);
var inst_14697 = fluree.db.flake.__GT_Flake.call(null,inst_14597,inst_14669,inst_14651,inst_14574,inst_14575,inst_14687);
var inst_14698 = fluree.db.flake.__GT_Flake.call(null,inst_14606,inst_14678,inst_14660,inst_14581,inst_14582,inst_14696__$1);
var inst_14699 = opts;
var inst_14700__$1 = cljs.core.__destructure_map.call(null,inst_14699);
var inst_14701 = cljs.core.get.call(null,inst_14700__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_14702__$1 = cljs.core.get.call(null,inst_14700__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_14703 = cljs.core.get.call(null,inst_14700__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14920__$1 = (function (){var statearr_14962 = state_14920;
(statearr_14962[(10)] = inst_14697);

(statearr_14962[(16)] = inst_14696__$1);

(statearr_14962[(71)] = inst_14703);

(statearr_14962[(23)] = inst_14701);

(statearr_14962[(24)] = inst_14700__$1);

(statearr_14962[(50)] = inst_14702__$1);

(statearr_14962[(36)] = inst_14698);

return statearr_14962;
})();
if(cljs.core.truth_(inst_14702__$1)){
var statearr_14963_15149 = state_14920__$1;
(statearr_14963_15149[(1)] = (58));

} else {
var statearr_14964_15150 = state_14920__$1;
(statearr_14964_15150[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (92))){
var inst_14740 = (state_14920[(19)]);
var inst_14741 = (state_14920[(27)]);
var inst_14796 = (state_14920[(72)]);
var inst_14738 = (state_14920[(32)]);
var inst_14739 = (state_14920[(43)]);
var inst_14799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14800 = (inst_14738 - inst_14796);
var inst_14801 = [inst_14800,inst_14739,inst_14740,inst_14741];
var inst_14802 = (new cljs.core.PersistentVector(null,4,(5),inst_14799,inst_14801,null));
var state_14920__$1 = state_14920;
var statearr_14965_15151 = state_14920__$1;
(statearr_14965_15151[(2)] = inst_14802);

(statearr_14965_15151[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (104))){
var inst_14858 = (state_14920[(2)]);
var inst_14859 = fluree.db.util.async.throw_err.call(null,inst_14858);
var state_14920__$1 = state_14920;
var statearr_14966_15152 = state_14920__$1;
(statearr_14966_15152[(2)] = inst_14859);

(statearr_14966_15152[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (15))){
var inst_14580 = (state_14920[(60)]);
var inst_14610 = cljs.core.boolean_QMARK_.call(null,inst_14580);
var state_14920__$1 = state_14920;
if(inst_14610){
var statearr_14967_15153 = state_14920__$1;
(statearr_14967_15153[(1)] = (17));

} else {
var statearr_14968_15154 = state_14920__$1;
(statearr_14968_15154[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (48))){
var inst_14583 = (state_14920[(55)]);
var inst_14687 = (state_14920[(2)]);
var state_14920__$1 = (function (){var statearr_14969 = state_14920;
(statearr_14969[(33)] = inst_14687);

return statearr_14969;
})();
if(cljs.core.truth_(inst_14583)){
var statearr_14970_15155 = state_14920__$1;
(statearr_14970_15155[(1)] = (52));

} else {
var statearr_14971_15156 = state_14920__$1;
(statearr_14971_15156[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (50))){
var state_14920__$1 = state_14920;
var statearr_14972_15157 = state_14920__$1;
(statearr_14972_15157[(2)] = (2147483647));

(statearr_14972_15157[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (116))){
var inst_14892 = (state_14920[(66)]);
var inst_14900 = (state_14920[(2)]);
var state_14920__$1 = (function (){var statearr_14973 = state_14920;
(statearr_14973[(73)] = inst_14900);

return statearr_14973;
})();
if(cljs.core.truth_(inst_14892)){
var statearr_14974_15158 = state_14920__$1;
(statearr_14974_15158[(1)] = (118));

} else {
var statearr_14975_15159 = state_14920__$1;
(statearr_14975_15159[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (75))){
var inst_14755 = (state_14920[(38)]);
var state_14920__$1 = state_14920;
var statearr_14976_15160 = state_14920__$1;
(statearr_14976_15160[(2)] = inst_14755);

(statearr_14976_15160[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (99))){
var inst_14816 = (state_14920[(69)]);
var inst_14825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14826 = [inst_14816,inst_14816];
var inst_14827 = (new cljs.core.PersistentVector(null,2,(5),inst_14825,inst_14826,null));
var state_14920__$1 = state_14920;
var statearr_14977_15161 = state_14920__$1;
(statearr_14977_15161[(2)] = inst_14827);

(statearr_14977_15161[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (21))){
var state_14920__$1 = state_14920;
var statearr_14978_15162 = state_14920__$1;
(statearr_14978_15162[(2)] = null);

(statearr_14978_15162[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (31))){
var inst_14641 = (state_14920[(74)]);
var state_14920__$1 = state_14920;
var statearr_14979_15163 = state_14920__$1;
(statearr_14979_15163[(2)] = inst_14641);

(statearr_14979_15163[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (113))){
var inst_14886 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_14980_15164 = state_14920__$1;
(statearr_14980_15164[(2)] = inst_14886);

(statearr_14980_15164[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (32))){
var inst_14661 = (state_14920[(75)]);
var inst_14572 = (state_14920[(58)]);
var inst_14660 = (state_14920[(2)]);
var inst_14661__$1 = (inst_14572 == null);
var state_14920__$1 = (function (){var statearr_14981 = state_14920;
(statearr_14981[(75)] = inst_14661__$1);

(statearr_14981[(39)] = inst_14660);

return statearr_14981;
})();
if(cljs.core.truth_(inst_14661__$1)){
var statearr_14982_15165 = state_14920__$1;
(statearr_14982_15165[(1)] = (34));

} else {
var statearr_14983_15166 = state_14920__$1;
(statearr_14983_15166[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (40))){
var inst_14660 = (state_14920[(39)]);
var state_14920__$1 = state_14920;
var statearr_14984_15167 = state_14920__$1;
(statearr_14984_15167[(2)] = inst_14660);

(statearr_14984_15167[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (91))){
var inst_14774 = (state_14920[(65)]);
var inst_14872 = (state_14920[(2)]);
var inst_14873 = cljs.core.nth.call(null,inst_14872,(0),null);
var inst_14874 = cljs.core.nth.call(null,inst_14872,(1),null);
var inst_14875 = cljs.core.nth.call(null,inst_14872,(2),null);
var inst_14876 = cljs.core.nth.call(null,inst_14872,(3),null);
var state_14920__$1 = (function (){var statearr_14985 = state_14920;
(statearr_14985[(76)] = inst_14875);

(statearr_14985[(77)] = inst_14873);

(statearr_14985[(78)] = inst_14874);

(statearr_14985[(7)] = inst_14876);

return statearr_14985;
})();
if(cljs.core.truth_(inst_14774)){
var statearr_14986_15168 = state_14920__$1;
(statearr_14986_15168[(1)] = (105));

} else {
var statearr_14987_15169 = state_14920__$1;
(statearr_14987_15169[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (117))){
var inst_14896 = (state_14920[(2)]);
var inst_14897 = fluree.db.util.async.throw_err.call(null,inst_14896);
var state_14920__$1 = state_14920;
var statearr_14988_15170 = state_14920__$1;
(statearr_14988_15170[(2)] = inst_14897);

(statearr_14988_15170[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (108))){
var inst_14701 = (state_14920[(23)]);
var inst_14881 = (state_14920[(79)]);
var inst_14874 = (state_14920[(78)]);
var inst_14881__$1 = (inst_14874 < inst_14701);
var state_14920__$1 = (function (){var statearr_14989 = state_14920;
(statearr_14989[(79)] = inst_14881__$1);

return statearr_14989;
})();
if(cljs.core.truth_(inst_14881__$1)){
var statearr_14990_15171 = state_14920__$1;
(statearr_14990_15171[(1)] = (111));

} else {
var statearr_14991_15172 = state_14920__$1;
(statearr_14991_15172[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (56))){
var state_14920__$1 = state_14920;
var statearr_14992_15173 = state_14920__$1;
(statearr_14992_15173[(2)] = fluree.db.util.core.min_integer);

(statearr_14992_15173[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (33))){
var inst_14656 = (state_14920[(2)]);
var inst_14657 = fluree.db.util.async.throw_err.call(null,inst_14656);
var state_14920__$1 = state_14920;
var statearr_14993_15174 = state_14920__$1;
(statearr_14993_15174[(2)] = inst_14657);

(statearr_14993_15174[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (13))){
var inst_14602 = (state_14920[(2)]);
var inst_14603 = fluree.db.util.async.throw_err.call(null,inst_14602);
var state_14920__$1 = state_14920;
var statearr_14994_15175 = state_14920__$1;
(statearr_14994_15175[(2)] = inst_14603);

(statearr_14994_15175[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (22))){
var inst_14616 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_14995_15176 = state_14920__$1;
(statearr_14995_15176[(2)] = inst_14616);

(statearr_14995_15176[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (90))){
var inst_14697 = (state_14920[(10)]);
var inst_14574 = (state_14920[(11)]);
var inst_14707 = (state_14920[(12)]);
var inst_14642 = (state_14920[(13)]);
var inst_14747 = (state_14920[(14)]);
var inst_14724 = (state_14920[(15)]);
var inst_14696 = (state_14920[(16)]);
var inst_14774 = (state_14920[(65)]);
var inst_14587 = (state_14920[(17)]);
var inst_14669 = (state_14920[(18)]);
var inst_14740 = (state_14920[(19)]);
var inst_14709 = (state_14920[(20)]);
var inst_14606 = (state_14920[(21)]);
var inst_14638 = (state_14920[(22)]);
var inst_14701 = (state_14920[(23)]);
var inst_14700 = (state_14920[(24)]);
var inst_14575 = (state_14920[(25)]);
var inst_14597 = (state_14920[(26)]);
var inst_14741 = (state_14920[(27)]);
var inst_14796 = (state_14920[(72)]);
var inst_14718 = (state_14920[(28)]);
var inst_14795 = (state_14920[(80)]);
var inst_14581 = (state_14920[(29)]);
var inst_14678 = (state_14920[(30)]);
var inst_14714 = (state_14920[(31)]);
var inst_14738 = (state_14920[(32)]);
var inst_14687 = (state_14920[(33)]);
var inst_14713 = (state_14920[(34)]);
var inst_14577 = (state_14920[(35)]);
var inst_14698 = (state_14920[(36)]);
var inst_14639 = (state_14920[(37)]);
var inst_14728 = (state_14920[(8)]);
var inst_14734 = (state_14920[(9)]);
var inst_14660 = (state_14920[(39)]);
var inst_14708 = (state_14920[(40)]);
var inst_14719 = (state_14920[(41)]);
var inst_14651 = (state_14920[(42)]);
var inst_14739 = (state_14920[(43)]);
var inst_14737 = (state_14920[(44)]);
var inst_14586 = (state_14920[(45)]);
var inst_14585 = (state_14920[(46)]);
var inst_14582 = (state_14920[(47)]);
var inst_14570 = (state_14920[(48)]);
var inst_14773 = (state_14920[(81)]);
var inst_14794 = (function (){var no_filter_QMARK_ = inst_14734;
var base_result_SINGLEQUOTE_ = inst_14773;
var t = inst_14714;
var max_limit_QMARK_ = inst_14708;
var next_node = inst_14737;
var fast_forward_db_QMARK_ = inst_14719;
var s1 = inst_14597;
var o2 = inst_14660;
var t1 = inst_14574;
var predicate_fn = inst_14587;
var i = inst_14739;
var rhs = inst_14774;
var m1 = inst_14687;
var root_node = inst_14724;
var vec__14556 = inst_14570;
var s2 = inst_14606;
var vec__14559 = inst_14577;
var p2 = inst_14678;
var permissions = inst_14709;
var vec__14566 = inst_14639;
var vec__14563 = inst_14638;
var limit = inst_14707;
var start_flake = inst_14697;
var flake_limit = inst_14701;
var offset = inst_14738;
var acc = inst_14741;
var map__14569 = inst_14700;
var t2 = inst_14581;
var op1 = inst_14575;
var o1 = inst_14651;
var end_flake = inst_14698;
var base_result = inst_14747;
var s = inst_14740;
var node_start = inst_14728;
var p1 = inst_14669;
var subject_fn = inst_14586;
var object_fn = inst_14642;
var idx_compare = inst_14713;
var map__14562 = inst_14585;
var op2 = inst_14582;
var m2 = inst_14696;
var novelty = inst_14718;
return (function (p1__14541_SHARP_){
return p1__14541_SHARP_.s;
});
})();
var inst_14795__$1 = cljs.core.partition_by.call(null,inst_14794,inst_14773);
var inst_14796__$1 = cljs.core.count.call(null,inst_14795__$1);
var inst_14797 = (inst_14738 > inst_14796__$1);
var state_14920__$1 = (function (){var statearr_14996 = state_14920;
(statearr_14996[(72)] = inst_14796__$1);

(statearr_14996[(80)] = inst_14795__$1);

return statearr_14996;
})();
if(cljs.core.truth_(inst_14797)){
var statearr_14997_15177 = state_14920__$1;
(statearr_14997_15177[(1)] = (92));

} else {
var statearr_14998_15178 = state_14920__$1;
(statearr_14998_15178[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (109))){
var inst_14879 = (state_14920[(82)]);
var state_14920__$1 = state_14920;
var statearr_14999_15179 = state_14920__$1;
(statearr_14999_15179[(2)] = inst_14879);

(statearr_14999_15179[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (36))){
var inst_14665 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
if(cljs.core.truth_(inst_14665)){
var statearr_15000_15180 = state_14920__$1;
(statearr_15000_15180[(1)] = (37));

} else {
var statearr_15001_15181 = state_14920__$1;
(statearr_15001_15181[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (41))){
var inst_14670 = (state_14920[(63)]);
var state_14920__$1 = state_14920;
var statearr_15002_15182 = state_14920__$1;
(statearr_15002_15182[(2)] = inst_14670);

(statearr_15002_15182[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (118))){
var inst_14900 = (state_14920[(73)]);
var state_14920__$1 = state_14920;
var statearr_15003_15183 = state_14920__$1;
(statearr_15003_15183[(2)] = inst_14900);

(statearr_15003_15183[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (89))){
var inst_14740 = (state_14920[(19)]);
var inst_14701 = (state_14920[(23)]);
var inst_14741 = (state_14920[(27)]);
var inst_14739 = (state_14920[(43)]);
var inst_14773 = (state_14920[(81)]);
var inst_14785 = cljs.core.count.call(null,inst_14773);
var inst_14786 = (inst_14701 - inst_14739);
var inst_14787 = cljs.core.take.call(null,inst_14786,inst_14773);
var inst_14788 = cljs.core.into.call(null,inst_14741,inst_14787);
var inst_14789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14790 = (inst_14739 + inst_14785);
var inst_14791 = [(0),inst_14790,inst_14740,inst_14788];
var inst_14792 = (new cljs.core.PersistentVector(null,4,(5),inst_14789,inst_14791,null));
var state_14920__$1 = state_14920;
var statearr_15004_15184 = state_14920__$1;
(statearr_15004_15184[(2)] = inst_14792);

(statearr_15004_15184[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (100))){
var inst_14835 = (state_14920[(52)]);
var inst_14701 = (state_14920[(23)]);
var inst_14834 = (state_14920[(53)]);
var inst_14833 = (state_14920[(54)]);
var inst_14807 = (state_14920[(70)]);
var inst_14739 = (state_14920[(43)]);
var inst_14829 = (state_14920[(2)]);
var inst_14830 = cljs.core.nth.call(null,inst_14829,(0),null);
var inst_14831 = cljs.core.nth.call(null,inst_14829,(1),null);
var inst_14832 = cljs.core.take.call(null,inst_14831,inst_14807);
var inst_14833__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_14832);
var inst_14834__$1 = cljs.core.count.call(null,inst_14833__$1);
var inst_14835__$1 = (inst_14739 + inst_14834__$1);
var inst_14836 = (inst_14835__$1 > inst_14701);
var state_14920__$1 = (function (){var statearr_15005 = state_14920;
(statearr_15005[(52)] = inst_14835__$1);

(statearr_15005[(83)] = inst_14830);

(statearr_15005[(53)] = inst_14834__$1);

(statearr_15005[(54)] = inst_14833__$1);

return statearr_15005;
})();
if(cljs.core.truth_(inst_14836)){
var statearr_15006_15185 = state_14920__$1;
(statearr_15006_15185[(1)] = (101));

} else {
var statearr_15007_15186 = state_14920__$1;
(statearr_15007_15186[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (122))){
var inst_14900 = (state_14920[(73)]);
var inst_14875 = (state_14920[(76)]);
var inst_14873 = (state_14920[(77)]);
var inst_14874 = (state_14920[(78)]);
var inst_14876 = (state_14920[(7)]);
var inst_14737 = inst_14900;
var inst_14738 = inst_14873;
var inst_14739 = inst_14874;
var inst_14740 = inst_14875;
var inst_14741 = inst_14876;
var state_14920__$1 = (function (){var statearr_15008 = state_14920;
(statearr_15008[(19)] = inst_14740);

(statearr_15008[(27)] = inst_14741);

(statearr_15008[(32)] = inst_14738);

(statearr_15008[(43)] = inst_14739);

(statearr_15008[(44)] = inst_14737);

return statearr_15008;
})();
var statearr_15009_15187 = state_14920__$1;
(statearr_15009_15187[(2)] = null);

(statearr_15009_15187[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (43))){
var state_14920__$1 = state_14920;
var statearr_15010_15188 = state_14920__$1;
(statearr_15010_15188[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_15010_15188[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (61))){
var inst_14697 = (state_14920[(10)]);
var inst_14724 = (state_14920[(15)]);
var inst_14718 = (state_14920[(28)]);
var inst_14714 = (state_14920[(31)]);
var inst_14719 = (state_14920[(41)]);
var inst_14723 = (state_14920[(2)]);
var inst_14724__$1 = fluree.db.util.async.throw_err.call(null,inst_14723);
var inst_14725 = fluree.db.query.range.find_next_valid_node.call(null,inst_14724__$1,inst_14697,inst_14714,inst_14718,inst_14719);
var state_14920__$1 = (function (){var statearr_15011 = state_14920;
(statearr_15011[(15)] = inst_14724__$1);

return statearr_15011;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14920__$1,(62),inst_14725);
} else {
if((state_val_14921 === (29))){
var inst_14647 = (state_14920[(2)]);
var inst_14648 = fluree.db.util.async.throw_err.call(null,inst_14647);
var state_14920__$1 = state_14920;
var statearr_15012_15189 = state_14920__$1;
(statearr_15012_15189[(2)] = inst_14648);

(statearr_15012_15189[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (44))){
var inst_14579 = (state_14920[(57)]);
var state_14920__$1 = state_14920;
var statearr_15013_15190 = state_14920__$1;
(statearr_15013_15190[(2)] = inst_14579);

(statearr_15013_15190[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (93))){
var inst_14795 = (state_14920[(80)]);
var inst_14738 = (state_14920[(32)]);
var inst_14734 = (state_14920[(9)]);
var inst_14807 = cljs.core.drop.call(null,inst_14738,inst_14795);
var state_14920__$1 = (function (){var statearr_15014 = state_14920;
(statearr_15014[(70)] = inst_14807);

return statearr_15014;
})();
if(cljs.core.truth_(inst_14734)){
var statearr_15015_15191 = state_14920__$1;
(statearr_15015_15191[(1)] = (95));

} else {
var statearr_15016_15192 = state_14920__$1;
(statearr_15016_15192[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (6))){
var inst_14571 = (state_14920[(49)]);
var inst_14591 = fluree.db.dbproto._subid.call(null,db,inst_14571);
var state_14920__$1 = state_14920;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14920__$1,(9),inst_14591);
} else {
if((state_val_14921 === (111))){
var inst_14707 = (state_14920[(12)]);
var inst_14875 = (state_14920[(76)]);
var inst_14883 = (inst_14875 < inst_14707);
var state_14920__$1 = state_14920;
var statearr_15017_15193 = state_14920__$1;
(statearr_15017_15193[(2)] = inst_14883);

(statearr_15017_15193[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (28))){
var inst_14641 = (state_14920[(74)]);
var inst_14651 = (state_14920[(2)]);
var inst_14652 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14641);
var state_14920__$1 = (function (){var statearr_15018 = state_14920;
(statearr_15018[(42)] = inst_14651);

return statearr_15018;
})();
if(inst_14652){
var statearr_15019_15194 = state_14920__$1;
(statearr_15019_15194[(1)] = (30));

} else {
var statearr_15020_15195 = state_14920__$1;
(statearr_15020_15195[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (64))){
var state_14920__$1 = state_14920;
var statearr_15021_15196 = state_14920__$1;
(statearr_15021_15196[(2)] = true);

(statearr_15021_15196[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (103))){
var inst_14830 = (state_14920[(83)]);
var inst_14849 = (state_14920[(2)]);
var inst_14850 = cljs.core.nth.call(null,inst_14849,(0),null);
var inst_14851 = cljs.core.nth.call(null,inst_14849,(1),null);
var inst_14852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14853 = [inst_14850,inst_14830,inst_14851];
var inst_14854 = (new cljs.core.PersistentVector(null,3,(5),inst_14852,inst_14853,null));
var state_14920__$1 = state_14920;
var statearr_15022_15197 = state_14920__$1;
(statearr_15022_15197[(2)] = inst_14854);

(statearr_15022_15197[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (51))){
var inst_14685 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_15023_15198 = state_14920__$1;
(statearr_15023_15198[(2)] = inst_14685);

(statearr_15023_15198[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (25))){
var inst_14638 = (state_14920[(22)]);
var inst_14640 = (state_14920[(51)]);
var inst_14639 = (state_14920[(37)]);
var inst_14638__$1 = (state_14920[(2)]);
var inst_14639__$1 = cljs.core.nth.call(null,inst_14638__$1,(0),null);
var inst_14640__$1 = cljs.core.nth.call(null,inst_14639__$1,(0),null);
var inst_14641 = cljs.core.nth.call(null,inst_14639__$1,(1),null);
var inst_14642 = cljs.core.nth.call(null,inst_14638__$1,(1),null);
var inst_14643 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14640__$1);
var state_14920__$1 = (function (){var statearr_15024 = state_14920;
(statearr_15024[(13)] = inst_14642);

(statearr_15024[(22)] = inst_14638__$1);

(statearr_15024[(74)] = inst_14641);

(statearr_15024[(51)] = inst_14640__$1);

(statearr_15024[(37)] = inst_14639__$1);

return statearr_15024;
})();
if(inst_14643){
var statearr_15025_15199 = state_14920__$1;
(statearr_15025_15199[(1)] = (26));

} else {
var statearr_15026_15200 = state_14920__$1;
(statearr_15026_15200[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (34))){
var inst_14651 = (state_14920[(42)]);
var state_14920__$1 = state_14920;
var statearr_15027_15201 = state_14920__$1;
(statearr_15027_15201[(2)] = inst_14651);

(statearr_15027_15201[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (17))){
var inst_14580 = (state_14920[(60)]);
var state_14920__$1 = state_14920;
var statearr_15028_15202 = state_14920__$1;
(statearr_15028_15202[(2)] = inst_14580);

(statearr_15028_15202[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (3))){
var inst_14918 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14920__$1,inst_14918);
} else {
if((state_val_14921 === (12))){
var inst_14573 = (state_14920[(61)]);
var inst_14606 = (state_14920[(2)]);
var inst_14607 = cljs.core.boolean_QMARK_.call(null,inst_14573);
var state_14920__$1 = (function (){var statearr_15029 = state_14920;
(statearr_15029[(21)] = inst_14606);

return statearr_15029;
})();
if(inst_14607){
var statearr_15030_15203 = state_14920__$1;
(statearr_15030_15203[(1)] = (14));

} else {
var statearr_15031_15204 = state_14920__$1;
(statearr_15031_15204[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (2))){
var inst_14571 = (state_14920[(49)]);
var inst_14577 = (state_14920[(35)]);
var inst_14585 = (state_14920[(46)]);
var inst_14570 = (state_14920[(48)]);
var _ = (function (){var statearr_15032 = state_14920;
(statearr_15032[(4)] = cljs.core.cons.call(null,(5),(state_14920[(4)])));

return statearr_15032;
})();
var inst_14570__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_14571__$1 = cljs.core.nth.call(null,inst_14570__$1,(0),null);
var inst_14572 = cljs.core.nth.call(null,inst_14570__$1,(1),null);
var inst_14573 = cljs.core.nth.call(null,inst_14570__$1,(2),null);
var inst_14574 = cljs.core.nth.call(null,inst_14570__$1,(3),null);
var inst_14575 = cljs.core.nth.call(null,inst_14570__$1,(4),null);
var inst_14576 = cljs.core.nth.call(null,inst_14570__$1,(5),null);
var inst_14577__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_14578 = cljs.core.nth.call(null,inst_14577__$1,(0),null);
var inst_14579 = cljs.core.nth.call(null,inst_14577__$1,(1),null);
var inst_14580 = cljs.core.nth.call(null,inst_14577__$1,(2),null);
var inst_14581 = cljs.core.nth.call(null,inst_14577__$1,(3),null);
var inst_14582 = cljs.core.nth.call(null,inst_14577__$1,(4),null);
var inst_14583 = cljs.core.nth.call(null,inst_14577__$1,(5),null);
var inst_14584 = opts;
var inst_14585__$1 = cljs.core.__destructure_map.call(null,inst_14584);
var inst_14586 = cljs.core.get.call(null,inst_14585__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_14587 = cljs.core.get.call(null,inst_14585__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_14588 = cljs.core.get.call(null,inst_14585__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_14589 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14571__$1);
var state_14920__$1 = (function (){var statearr_15033 = state_14920;
(statearr_15033[(55)] = inst_14583);

(statearr_15033[(11)] = inst_14574);

(statearr_15033[(56)] = inst_14588);

(statearr_15033[(17)] = inst_14587);

(statearr_15033[(25)] = inst_14575);

(statearr_15033[(29)] = inst_14581);

(statearr_15033[(49)] = inst_14571__$1);

(statearr_15033[(57)] = inst_14579);

(statearr_15033[(35)] = inst_14577__$1);

(statearr_15033[(58)] = inst_14572);

(statearr_15033[(84)] = inst_14578);

(statearr_15033[(59)] = inst_14576);

(statearr_15033[(60)] = inst_14580);

(statearr_15033[(45)] = inst_14586);

(statearr_15033[(46)] = inst_14585__$1);

(statearr_15033[(47)] = inst_14582);

(statearr_15033[(48)] = inst_14570__$1);

(statearr_15033[(61)] = inst_14573);

return statearr_15033;
})();
if(inst_14589){
var statearr_15034_15205 = state_14920__$1;
(statearr_15034_15205[(1)] = (6));

} else {
var statearr_15035_15206 = state_14920__$1;
(statearr_15035_15206[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (66))){
var inst_14703 = (state_14920[(71)]);
var inst_14728 = (state_14920[(8)]);
var inst_14736 = cljs.core.PersistentVector.EMPTY;
var inst_14737 = inst_14728;
var inst_14738 = inst_14703;
var inst_14739 = (0);
var inst_14740 = (0);
var inst_14741 = inst_14736;
var state_14920__$1 = (function (){var statearr_15036 = state_14920;
(statearr_15036[(19)] = inst_14740);

(statearr_15036[(27)] = inst_14741);

(statearr_15036[(32)] = inst_14738);

(statearr_15036[(43)] = inst_14739);

(statearr_15036[(44)] = inst_14737);

return statearr_15036;
})();
var statearr_15037_15207 = state_14920__$1;
(statearr_15037_15207[(2)] = null);

(statearr_15037_15207[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (107))){
var inst_14892 = (state_14920[(66)]);
var inst_14892__$1 = (state_14920[(2)]);
var state_14920__$1 = (function (){var statearr_15038 = state_14920;
(statearr_15038[(66)] = inst_14892__$1);

return statearr_15038;
})();
if(cljs.core.truth_(inst_14892__$1)){
var statearr_15039_15208 = state_14920__$1;
(statearr_15039_15208[(1)] = (114));

} else {
var statearr_15040_15209 = state_14920__$1;
(statearr_15040_15209[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (23))){
var inst_14588 = (state_14920[(56)]);
var inst_14580 = (state_14920[(60)]);
var inst_14573 = (state_14920[(61)]);
var inst_14623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14625 = [inst_14573,inst_14580];
var inst_14626 = (new cljs.core.PersistentVector(null,2,(5),inst_14624,inst_14625,null));
var inst_14627 = [inst_14626,inst_14588];
var inst_14628 = (new cljs.core.PersistentVector(null,2,(5),inst_14623,inst_14627,null));
var state_14920__$1 = state_14920;
var statearr_15041_15210 = state_14920__$1;
(statearr_15041_15210[(2)] = inst_14628);

(statearr_15041_15210[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (47))){
var inst_14681 = (cljs.core._GT__EQ_ === start_test);
var state_14920__$1 = state_14920;
if(cljs.core.truth_(inst_14681)){
var statearr_15042_15211 = state_14920__$1;
(statearr_15042_15211[(1)] = (49));

} else {
var statearr_15043_15212 = state_14920__$1;
(statearr_15043_15212[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (35))){
var inst_14661 = (state_14920[(75)]);
var state_14920__$1 = state_14920;
var statearr_15044_15213 = state_14920__$1;
(statearr_15044_15213[(2)] = inst_14661);

(statearr_15044_15213[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (82))){
var inst_14708 = (state_14920[(40)]);
var inst_14737 = (state_14920[(44)]);
var inst_14773 = (state_14920[(2)]);
var inst_14774 = fluree.db.dbproto._rhs.call(null,inst_14737);
var state_14920__$1 = (function (){var statearr_15045 = state_14920;
(statearr_15045[(65)] = inst_14774);

(statearr_15045[(81)] = inst_14773);

return statearr_15045;
})();
if(cljs.core.truth_(inst_14708)){
var statearr_15046_15214 = state_14920__$1;
(statearr_15046_15214[(1)] = (83));

} else {
var statearr_15047_15215 = state_14920__$1;
(statearr_15047_15215[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (76))){
var inst_14587 = (state_14920[(17)]);
var inst_14761 = (state_14920[(2)]);
var state_14920__$1 = (function (){var statearr_15048 = state_14920;
(statearr_15048[(64)] = inst_14761);

return statearr_15048;
})();
if(cljs.core.truth_(inst_14587)){
var statearr_15049_15216 = state_14920__$1;
(statearr_15049_15216[(1)] = (77));

} else {
var statearr_15050_15217 = state_14920__$1;
(statearr_15050_15217[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (97))){
var inst_14741 = (state_14920[(27)]);
var inst_14861 = (state_14920[(2)]);
var inst_14862 = cljs.core.nth.call(null,inst_14861,(0),null);
var inst_14863 = cljs.core.nth.call(null,inst_14861,(1),null);
var inst_14864 = cljs.core.nth.call(null,inst_14861,(2),null);
var inst_14865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14866 = cljs.core.into.call(null,inst_14741,inst_14864);
var inst_14867 = [(0),inst_14862,inst_14863,inst_14866];
var inst_14868 = (new cljs.core.PersistentVector(null,4,(5),inst_14865,inst_14867,null));
var state_14920__$1 = state_14920;
var statearr_15051_15218 = state_14920__$1;
(statearr_15051_15218[(2)] = inst_14868);

(statearr_15051_15218[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (19))){
var inst_14618 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_15052_15219 = state_14920__$1;
(statearr_15052_15219[(2)] = inst_14618);

(statearr_15052_15219[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (57))){
var inst_14694 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_15053_15220 = state_14920__$1;
(statearr_15053_15220[(2)] = inst_14694);

(statearr_15053_15220[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (68))){
var inst_14915 = (state_14920[(2)]);
var _ = (function (){var statearr_15054 = state_14920;
(statearr_15054[(4)] = cljs.core.rest.call(null,(state_14920[(4)])));

return statearr_15054;
})();
var state_14920__$1 = state_14920;
var statearr_15055_15221 = state_14920__$1;
(statearr_15055_15221[(2)] = inst_14915);

(statearr_15055_15221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (11))){
var inst_14578 = (state_14920[(84)]);
var state_14920__$1 = state_14920;
var statearr_15056_15222 = state_14920__$1;
(statearr_15056_15222[(2)] = inst_14578);

(statearr_15056_15222[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (115))){
var state_14920__$1 = state_14920;
var statearr_15058_15223 = state_14920__$1;
(statearr_15058_15223[(2)] = null);

(statearr_15058_15223[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (9))){
var inst_14593 = (state_14920[(2)]);
var inst_14594 = fluree.db.util.async.throw_err.call(null,inst_14593);
var state_14920__$1 = state_14920;
var statearr_15059_15224 = state_14920__$1;
(statearr_15059_15224[(2)] = inst_14594);

(statearr_15059_15224[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (5))){
var _ = (function (){var statearr_15060 = state_14920;
(statearr_15060[(4)] = cljs.core.rest.call(null,(state_14920[(4)])));

return statearr_15060;
})();
var state_14920__$1 = state_14920;
var ex15057 = (state_14920__$1[(2)]);
var statearr_15061_15225 = state_14920__$1;
(statearr_15061_15225[(5)] = ex15057);


if((ex15057 instanceof Error)){
var statearr_15062_15226 = state_14920__$1;
(statearr_15062_15226[(1)] = (4));

(statearr_15062_15226[(5)] = null);

} else {
throw ex15057;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (112))){
var inst_14881 = (state_14920[(79)]);
var state_14920__$1 = state_14920;
var statearr_15063_15227 = state_14920__$1;
(statearr_15063_15227[(2)] = inst_14881);

(statearr_15063_15227[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (83))){
var inst_14776 = (state_14920[(85)]);
var inst_14738 = (state_14920[(32)]);
var inst_14776__$1 = cljs.core._EQ_.call(null,(0),inst_14738);
var state_14920__$1 = (function (){var statearr_15064 = state_14920;
(statearr_15064[(85)] = inst_14776__$1);

return statearr_15064;
})();
if(inst_14776__$1){
var statearr_15065_15228 = state_14920__$1;
(statearr_15065_15228[(1)] = (86));

} else {
var statearr_15066_15229 = state_14920__$1;
(statearr_15066_15229[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (14))){
var inst_14573 = (state_14920[(61)]);
var state_14920__$1 = state_14920;
var statearr_15067_15230 = state_14920__$1;
(statearr_15067_15230[(2)] = inst_14573);

(statearr_15067_15230[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (45))){
var inst_14576 = (state_14920[(59)]);
var inst_14678 = (state_14920[(2)]);
var state_14920__$1 = (function (){var statearr_15068 = state_14920;
(statearr_15068[(30)] = inst_14678);

return statearr_15068;
})();
if(cljs.core.truth_(inst_14576)){
var statearr_15069_15231 = state_14920__$1;
(statearr_15069_15231[(1)] = (46));

} else {
var statearr_15070_15232 = state_14920__$1;
(statearr_15070_15232[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (53))){
var inst_14690 = (cljs.core._LT__EQ_ === end_test);
var state_14920__$1 = state_14920;
if(cljs.core.truth_(inst_14690)){
var statearr_15071_15233 = state_14920__$1;
(statearr_15071_15233[(1)] = (55));

} else {
var statearr_15072_15234 = state_14920__$1;
(statearr_15072_15234[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (78))){
var inst_14761 = (state_14920[(64)]);
var state_14920__$1 = state_14920;
var statearr_15073_15235 = state_14920__$1;
(statearr_15073_15235[(2)] = inst_14761);

(statearr_15073_15235[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (26))){
var inst_14640 = (state_14920[(51)]);
var inst_14645 = fluree.db.dbproto._subid.call(null,db,inst_14640);
var state_14920__$1 = state_14920;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14920__$1,(29),inst_14645);
} else {
if((state_val_14921 === (123))){
var inst_14910 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_15074_15236 = state_14920__$1;
(statearr_15074_15236[(2)] = inst_14910);

(statearr_15074_15236[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (16))){
var inst_14620 = (state_14920[(62)]);
var inst_14620__$1 = (state_14920[(2)]);
var inst_14621 = (inst_14620__$1 == null);
var state_14920__$1 = (function (){var statearr_15075 = state_14920;
(statearr_15075[(62)] = inst_14620__$1);

return statearr_15075;
})();
if(cljs.core.truth_(inst_14621)){
var statearr_15076_15237 = state_14920__$1;
(statearr_15076_15237[(1)] = (23));

} else {
var statearr_15077_15238 = state_14920__$1;
(statearr_15077_15238[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (81))){
var inst_14767 = (state_14920[(86)]);
var state_14920__$1 = state_14920;
var statearr_15078_15239 = state_14920__$1;
(statearr_15078_15239[(2)] = inst_14767);

(statearr_15078_15239[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (120))){
var inst_14904 = (state_14920[(2)]);
var inst_14905 = cljs.core.not.call(null,inst_14904);
var state_14920__$1 = state_14920;
if(inst_14905){
var statearr_15079_15240 = state_14920__$1;
(statearr_15079_15240[(1)] = (121));

} else {
var statearr_15080_15241 = state_14920__$1;
(statearr_15080_15241[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (79))){
var inst_14642 = (state_14920[(13)]);
var inst_14767 = (state_14920[(2)]);
var state_14920__$1 = (function (){var statearr_15081 = state_14920;
(statearr_15081[(86)] = inst_14767);

return statearr_15081;
})();
if(cljs.core.truth_(inst_14642)){
var statearr_15082_15242 = state_14920__$1;
(statearr_15082_15242[(1)] = (80));

} else {
var statearr_15083_15243 = state_14920__$1;
(statearr_15083_15243[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (38))){
var inst_14572 = (state_14920[(58)]);
var state_14920__$1 = state_14920;
var statearr_15084_15244 = state_14920__$1;
(statearr_15084_15244[(2)] = inst_14572);

(statearr_15084_15244[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (98))){
var inst_14707 = (state_14920[(12)]);
var inst_14817 = (state_14920[(67)]);
var inst_14815 = (state_14920[(68)]);
var inst_14820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14821 = (inst_14815 - inst_14817);
var inst_14822 = [inst_14707,inst_14821];
var inst_14823 = (new cljs.core.PersistentVector(null,2,(5),inst_14820,inst_14822,null));
var state_14920__$1 = state_14920;
var statearr_15085_15245 = state_14920__$1;
(statearr_15085_15245[(2)] = inst_14823);

(statearr_15085_15245[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (87))){
var inst_14776 = (state_14920[(85)]);
var state_14920__$1 = state_14920;
var statearr_15086_15246 = state_14920__$1;
(statearr_15086_15246[(2)] = inst_14776);

(statearr_15086_15246[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (30))){
var inst_14641 = (state_14920[(74)]);
var inst_14654 = fluree.db.dbproto._subid.call(null,db,inst_14641);
var state_14920__$1 = state_14920;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14920__$1,(33),inst_14654);
} else {
if((state_val_14921 === (73))){
var inst_14586 = (state_14920[(45)]);
var inst_14755 = (state_14920[(2)]);
var state_14920__$1 = (function (){var statearr_15087 = state_14920;
(statearr_15087[(38)] = inst_14755);

return statearr_15087;
})();
if(cljs.core.truth_(inst_14586)){
var statearr_15088_15247 = state_14920__$1;
(statearr_15088_15247[(1)] = (74));

} else {
var statearr_15089_15248 = state_14920__$1;
(statearr_15089_15248[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (96))){
var inst_14707 = (state_14920[(12)]);
var inst_14740 = (state_14920[(19)]);
var inst_14701 = (state_14920[(23)]);
var inst_14807 = (state_14920[(70)]);
var inst_14739 = (state_14920[(43)]);
var inst_14856 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_14807,inst_14739,inst_14740,inst_14701,inst_14707);
var state_14920__$1 = state_14920;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14920__$1,(104),inst_14856);
} else {
if((state_val_14921 === (10))){
var inst_14578 = (state_14920[(84)]);
var inst_14600 = fluree.db.dbproto._subid.call(null,db,inst_14578);
var state_14920__$1 = state_14920;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14920__$1,(13),inst_14600);
} else {
if((state_val_14921 === (18))){
var state_14920__$1 = state_14920;
var statearr_15090_15249 = state_14920__$1;
(statearr_15090_15249[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (105))){
var inst_14879 = (state_14920[(82)]);
var inst_14774 = (state_14920[(65)]);
var inst_14713 = (state_14920[(34)]);
var inst_14698 = (state_14920[(36)]);
var inst_14878 = inst_14713.call(null,inst_14774,inst_14698);
var inst_14879__$1 = (inst_14878 < (0));
var state_14920__$1 = (function (){var statearr_15092 = state_14920;
(statearr_15092[(82)] = inst_14879__$1);

return statearr_15092;
})();
if(cljs.core.truth_(inst_14879__$1)){
var statearr_15093_15250 = state_14920__$1;
(statearr_15093_15250[(1)] = (108));

} else {
var statearr_15094_15251 = state_14920__$1;
(statearr_15094_15251[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (52))){
var inst_14583 = (state_14920[(55)]);
var state_14920__$1 = state_14920;
var statearr_15095_15252 = state_14920__$1;
(statearr_15095_15252[(2)] = inst_14583);

(statearr_15095_15252[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (114))){
var inst_14724 = (state_14920[(15)]);
var inst_14774 = (state_14920[(65)]);
var inst_14718 = (state_14920[(28)]);
var inst_14714 = (state_14920[(31)]);
var inst_14719 = (state_14920[(41)]);
var inst_14894 = fluree.db.query.range.find_next_valid_node.call(null,inst_14724,inst_14774,inst_14714,inst_14718,inst_14719);
var state_14920__$1 = state_14920;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14920__$1,(117),inst_14894);
} else {
if((state_val_14921 === (67))){
var state_14920__$1 = state_14920;
var statearr_15096_15253 = state_14920__$1;
(statearr_15096_15253[(2)] = null);

(statearr_15096_15253[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (71))){
var inst_14697 = (state_14920[(10)]);
var inst_14574 = (state_14920[(11)]);
var inst_14707 = (state_14920[(12)]);
var inst_14642 = (state_14920[(13)]);
var inst_14747 = (state_14920[(14)]);
var inst_14724 = (state_14920[(15)]);
var inst_14696 = (state_14920[(16)]);
var inst_14587 = (state_14920[(17)]);
var inst_14669 = (state_14920[(18)]);
var inst_14740 = (state_14920[(19)]);
var inst_14709 = (state_14920[(20)]);
var inst_14606 = (state_14920[(21)]);
var inst_14638 = (state_14920[(22)]);
var inst_14701 = (state_14920[(23)]);
var inst_14700 = (state_14920[(24)]);
var inst_14575 = (state_14920[(25)]);
var inst_14597 = (state_14920[(26)]);
var inst_14741 = (state_14920[(27)]);
var inst_14718 = (state_14920[(28)]);
var inst_14581 = (state_14920[(29)]);
var inst_14678 = (state_14920[(30)]);
var inst_14714 = (state_14920[(31)]);
var inst_14738 = (state_14920[(32)]);
var inst_14687 = (state_14920[(33)]);
var inst_14713 = (state_14920[(34)]);
var inst_14577 = (state_14920[(35)]);
var inst_14698 = (state_14920[(36)]);
var inst_14639 = (state_14920[(37)]);
var inst_14728 = (state_14920[(8)]);
var inst_14734 = (state_14920[(9)]);
var inst_14660 = (state_14920[(39)]);
var inst_14708 = (state_14920[(40)]);
var inst_14719 = (state_14920[(41)]);
var inst_14651 = (state_14920[(42)]);
var inst_14739 = (state_14920[(43)]);
var inst_14737 = (state_14920[(44)]);
var inst_14586 = (state_14920[(45)]);
var inst_14585 = (state_14920[(46)]);
var inst_14582 = (state_14920[(47)]);
var inst_14570 = (state_14920[(48)]);
var inst_14751 = (function (){var no_filter_QMARK_ = inst_14734;
var t = inst_14714;
var max_limit_QMARK_ = inst_14708;
var next_node = inst_14737;
var fast_forward_db_QMARK_ = inst_14719;
var s1 = inst_14597;
var o2 = inst_14660;
var t1 = inst_14574;
var predicate_fn = inst_14587;
var i = inst_14739;
var m1 = inst_14687;
var root_node = inst_14724;
var vec__14556 = inst_14570;
var s2 = inst_14606;
var vec__14559 = inst_14577;
var p2 = inst_14678;
var permissions = inst_14709;
var vec__14566 = inst_14639;
var vec__14563 = inst_14638;
var limit = inst_14707;
var start_flake = inst_14697;
var flake_limit = inst_14701;
var G__14748 = inst_14747;
var offset = inst_14738;
var acc = inst_14741;
var map__14569 = inst_14700;
var t2 = inst_14581;
var op1 = inst_14575;
var o1 = inst_14651;
var end_flake = inst_14698;
var base_result = inst_14747;
var s = inst_14740;
var node_start = inst_14728;
var p1 = inst_14669;
var subject_fn = inst_14586;
var object_fn = inst_14642;
var idx_compare = inst_14713;
var map__14562 = inst_14585;
var op2 = inst_14582;
var m2 = inst_14696;
var novelty = inst_14718;
return (function (p1__14537_SHARP_){
return cljs.core._EQ_.call(null,p1__14537_SHARP_.o,start_flake.o);
});
})();
var inst_14752 = cljs.core.filter.call(null,inst_14751,inst_14747);
var state_14920__$1 = state_14920;
var statearr_15097_15254 = state_14920__$1;
(statearr_15097_15254[(2)] = inst_14752);

(statearr_15097_15254[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (42))){
var inst_14674 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
if(cljs.core.truth_(inst_14674)){
var statearr_15098_15255 = state_14920__$1;
(statearr_15098_15255[(1)] = (43));

} else {
var statearr_15099_15256 = state_14920__$1;
(statearr_15099_15256[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (80))){
var inst_14697 = (state_14920[(10)]);
var inst_14574 = (state_14920[(11)]);
var inst_14707 = (state_14920[(12)]);
var inst_14642 = (state_14920[(13)]);
var inst_14747 = (state_14920[(14)]);
var inst_14724 = (state_14920[(15)]);
var inst_14696 = (state_14920[(16)]);
var inst_14587 = (state_14920[(17)]);
var inst_14669 = (state_14920[(18)]);
var inst_14740 = (state_14920[(19)]);
var inst_14709 = (state_14920[(20)]);
var inst_14767 = (state_14920[(86)]);
var inst_14606 = (state_14920[(21)]);
var inst_14638 = (state_14920[(22)]);
var inst_14701 = (state_14920[(23)]);
var inst_14700 = (state_14920[(24)]);
var inst_14575 = (state_14920[(25)]);
var inst_14597 = (state_14920[(26)]);
var inst_14741 = (state_14920[(27)]);
var inst_14718 = (state_14920[(28)]);
var inst_14581 = (state_14920[(29)]);
var inst_14678 = (state_14920[(30)]);
var inst_14714 = (state_14920[(31)]);
var inst_14738 = (state_14920[(32)]);
var inst_14687 = (state_14920[(33)]);
var inst_14713 = (state_14920[(34)]);
var inst_14577 = (state_14920[(35)]);
var inst_14698 = (state_14920[(36)]);
var inst_14639 = (state_14920[(37)]);
var inst_14728 = (state_14920[(8)]);
var inst_14734 = (state_14920[(9)]);
var inst_14660 = (state_14920[(39)]);
var inst_14708 = (state_14920[(40)]);
var inst_14719 = (state_14920[(41)]);
var inst_14651 = (state_14920[(42)]);
var inst_14739 = (state_14920[(43)]);
var inst_14737 = (state_14920[(44)]);
var inst_14586 = (state_14920[(45)]);
var inst_14585 = (state_14920[(46)]);
var inst_14582 = (state_14920[(47)]);
var inst_14570 = (state_14920[(48)]);
var inst_14769 = (function (){var no_filter_QMARK_ = inst_14734;
var t = inst_14714;
var max_limit_QMARK_ = inst_14708;
var next_node = inst_14737;
var fast_forward_db_QMARK_ = inst_14719;
var s1 = inst_14597;
var o2 = inst_14660;
var t1 = inst_14574;
var predicate_fn = inst_14587;
var i = inst_14739;
var m1 = inst_14687;
var root_node = inst_14724;
var vec__14556 = inst_14570;
var s2 = inst_14606;
var vec__14559 = inst_14577;
var p2 = inst_14678;
var permissions = inst_14709;
var vec__14566 = inst_14639;
var vec__14563 = inst_14638;
var limit = inst_14707;
var start_flake = inst_14697;
var flake_limit = inst_14701;
var G__14748 = inst_14767;
var offset = inst_14738;
var acc = inst_14741;
var map__14569 = inst_14700;
var t2 = inst_14581;
var op1 = inst_14575;
var o1 = inst_14651;
var end_flake = inst_14698;
var base_result = inst_14747;
var s = inst_14740;
var node_start = inst_14728;
var p1 = inst_14669;
var subject_fn = inst_14586;
var object_fn = inst_14642;
var idx_compare = inst_14713;
var map__14562 = inst_14585;
var op2 = inst_14582;
var m2 = inst_14696;
var novelty = inst_14718;
return (function (p1__14540_SHARP_){
return object_fn.call(null,p1__14540_SHARP_.o);
});
})();
var inst_14770 = cljs.core.filter.call(null,inst_14769,inst_14767);
var state_14920__$1 = state_14920;
var statearr_15100_15257 = state_14920__$1;
(statearr_15100_15257[(2)] = inst_14770);

(statearr_15100_15257[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (37))){
var state_14920__$1 = state_14920;
var statearr_15101_15258 = state_14920__$1;
(statearr_15101_15258[(2)] = (-1));

(statearr_15101_15258[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (63))){
var inst_14669 = (state_14920[(18)]);
var inst_14709 = (state_14920[(20)]);
var inst_14606 = (state_14920[(21)]);
var inst_14597 = (state_14920[(26)]);
var inst_14678 = (state_14920[(30)]);
var inst_14731 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_14709,inst_14597,inst_14606,inst_14669,inst_14678);
var state_14920__$1 = state_14920;
var statearr_15102_15259 = state_14920__$1;
(statearr_15102_15259[(2)] = inst_14731);

(statearr_15102_15259[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (94))){
var inst_14870 = (state_14920[(2)]);
var state_14920__$1 = state_14920;
var statearr_15103_15260 = state_14920__$1;
(statearr_15103_15260[(2)] = inst_14870);

(statearr_15103_15260[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (8))){
var inst_14578 = (state_14920[(84)]);
var inst_14597 = (state_14920[(2)]);
var inst_14598 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14578);
var state_14920__$1 = (function (){var statearr_15104 = state_14920;
(statearr_15104[(26)] = inst_14597);

return statearr_15104;
})();
if(inst_14598){
var statearr_15105_15261 = state_14920__$1;
(statearr_15105_15261[(1)] = (10));

} else {
var statearr_15106_15262 = state_14920__$1;
(statearr_15106_15262[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (49))){
var state_14920__$1 = state_14920;
var statearr_15107_15263 = state_14920__$1;
(statearr_15107_15263[(2)] = fluree.db.util.core.min_integer);

(statearr_15107_15263[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14921 === (84))){
var inst_14708 = (state_14920[(40)]);
var state_14920__$1 = state_14920;
var statearr_15108_15264 = state_14920__$1;
(statearr_15108_15264[(2)] = inst_14708);

(statearr_15108_15264[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15109 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15109[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15109[(1)] = (1));

return statearr_15109;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_14920){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14920);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15110){var ex__2749__auto__ = e15110;
var statearr_15111_15265 = state_14920;
(statearr_15111_15265[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14920[(4)]))){
var statearr_15112_15266 = state_14920;
(statearr_15112_15266[(1)] = cljs.core.first.call(null,(state_14920[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15267 = state_14920;
state_14920 = G__15267;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_14920){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_14920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15113 = f__2769__auto__.call(null);
(statearr_15113[(6)] = c__2768__auto__);

return statearr_15113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15323){
var state_val_15324 = (state_15323[(1)]);
if((state_val_15324 === (7))){
var inst_15297 = (state_15323[(7)]);
var inst_15287 = (state_15323[(8)]);
var inst_15295 = fluree.db.flake.Flake__GT_parts.call(null,inst_15287);
var inst_15296 = cljs.core.nth.call(null,inst_15295,(0),null);
var inst_15297__$1 = cljs.core.nth.call(null,inst_15295,(1),null);
var inst_15298 = cljs.core.nth.call(null,inst_15295,(2),null);
var inst_15299 = cljs.core.nth.call(null,inst_15295,(3),null);
var inst_15300 = cljs.core.nth.call(null,inst_15295,(4),null);
var inst_15301 = cljs.core.nth.call(null,inst_15295,(5),null);
var inst_15302 = fluree.db.dbproto._tag.call(null,db,inst_15298,inst_15297__$1);
var state_15323__$1 = (function (){var statearr_15325 = state_15323;
(statearr_15325[(9)] = inst_15299);

(statearr_15325[(7)] = inst_15297__$1);

(statearr_15325[(10)] = inst_15300);

(statearr_15325[(11)] = inst_15296);

(statearr_15325[(12)] = inst_15301);

return statearr_15325;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15323__$1,(10),inst_15302);
} else {
if((state_val_15324 === (1))){
var inst_15275 = flakes;
var inst_15276 = cljs.core.seq.call(null,inst_15275);
var inst_15277 = cljs.core.first.call(null,inst_15276);
var inst_15278 = cljs.core.next.call(null,inst_15276);
var inst_15279 = cljs.core.PersistentVector.EMPTY;
var inst_15280 = inst_15275;
var inst_15281 = inst_15279;
var state_15323__$1 = (function (){var statearr_15326 = state_15323;
(statearr_15326[(13)] = inst_15277);

(statearr_15326[(14)] = inst_15280);

(statearr_15326[(15)] = inst_15281);

(statearr_15326[(16)] = inst_15278);

return statearr_15326;
})();
var statearr_15327_15345 = state_15323__$1;
(statearr_15327_15345[(2)] = null);

(statearr_15327_15345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15324 === (4))){
var inst_15287 = (state_15323[(8)]);
var inst_15290 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_15287);
var state_15323__$1 = state_15323;
if(inst_15290){
var statearr_15328_15346 = state_15323__$1;
(statearr_15328_15346[(1)] = (7));

} else {
var statearr_15329_15347 = state_15323__$1;
(statearr_15329_15347[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15324 === (6))){
var inst_15319 = (state_15323[(2)]);
var state_15323__$1 = state_15323;
var statearr_15330_15348 = state_15323__$1;
(statearr_15330_15348[(2)] = inst_15319);

(statearr_15330_15348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15324 === (3))){
var inst_15321 = (state_15323[(2)]);
var state_15323__$1 = state_15323;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15323__$1,inst_15321);
} else {
if((state_val_15324 === (2))){
var inst_15280 = (state_15323[(14)]);
var inst_15287 = (state_15323[(8)]);
var inst_15286 = cljs.core.seq.call(null,inst_15280);
var inst_15287__$1 = cljs.core.first.call(null,inst_15286);
var inst_15288 = cljs.core.next.call(null,inst_15286);
var state_15323__$1 = (function (){var statearr_15331 = state_15323;
(statearr_15331[(17)] = inst_15288);

(statearr_15331[(8)] = inst_15287__$1);

return statearr_15331;
})();
if(cljs.core.truth_(inst_15287__$1)){
var statearr_15332_15349 = state_15323__$1;
(statearr_15332_15349[(1)] = (4));

} else {
var statearr_15333_15350 = state_15323__$1;
(statearr_15333_15350[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15324 === (9))){
var inst_15316 = (state_15323[(2)]);
var state_15323__$1 = state_15323;
var statearr_15334_15351 = state_15323__$1;
(statearr_15334_15351[(2)] = inst_15316);

(statearr_15334_15351[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15324 === (5))){
var inst_15281 = (state_15323[(15)]);
var state_15323__$1 = state_15323;
var statearr_15335_15352 = state_15323__$1;
(statearr_15335_15352[(2)] = inst_15281);

(statearr_15335_15352[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15324 === (10))){
var inst_15299 = (state_15323[(9)]);
var inst_15288 = (state_15323[(17)]);
var inst_15297 = (state_15323[(7)]);
var inst_15300 = (state_15323[(10)]);
var inst_15281 = (state_15323[(15)]);
var inst_15296 = (state_15323[(11)]);
var inst_15301 = (state_15323[(12)]);
var inst_15304 = (state_15323[(2)]);
var inst_15305 = fluree.db.util.async.throw_err.call(null,inst_15304);
var inst_15306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15307 = [inst_15296,inst_15297,inst_15305,inst_15299,inst_15300,inst_15301];
var inst_15308 = (new cljs.core.PersistentVector(null,6,(5),inst_15306,inst_15307,null));
var inst_15309 = fluree.db.flake.parts__GT_Flake.call(null,inst_15308);
var inst_15310 = cljs.core.conj.call(null,inst_15281,inst_15309);
var inst_15280 = inst_15288;
var inst_15281__$1 = inst_15310;
var state_15323__$1 = (function (){var statearr_15336 = state_15323;
(statearr_15336[(14)] = inst_15280);

(statearr_15336[(15)] = inst_15281__$1);

return statearr_15336;
})();
var statearr_15337_15353 = state_15323__$1;
(statearr_15337_15353[(2)] = null);

(statearr_15337_15353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15324 === (8))){
var inst_15288 = (state_15323[(17)]);
var inst_15281 = (state_15323[(15)]);
var inst_15287 = (state_15323[(8)]);
var inst_15313 = cljs.core.conj.call(null,inst_15281,inst_15287);
var inst_15280 = inst_15288;
var inst_15281__$1 = inst_15313;
var state_15323__$1 = (function (){var statearr_15338 = state_15323;
(statearr_15338[(14)] = inst_15280);

(statearr_15338[(15)] = inst_15281__$1);

return statearr_15338;
})();
var statearr_15339_15354 = state_15323__$1;
(statearr_15339_15354[(2)] = null);

(statearr_15339_15354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0 = (function (){
var statearr_15340 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15340[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__);

(statearr_15340[(1)] = (1));

return statearr_15340;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1 = (function (state_15323){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15323);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15341){var ex__2749__auto__ = e15341;
var statearr_15342_15355 = state_15323;
(statearr_15342_15355[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15323[(4)]))){
var statearr_15343_15356 = state_15323;
(statearr_15343_15356[(1)] = cljs.core.first.call(null,(state_15323[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15357 = state_15323;
state_15323 = G__15357;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__ = function(state_15323){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1.call(this,state_15323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15344 = f__2769__auto__.call(null);
(statearr_15344[(6)] = c__2768__auto__);

return statearr_15344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15359 = arguments.length;
switch (G__15359) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15529){
var state_val_15530 = (state_15529[(1)]);
if((state_val_15530 === (65))){
var state_15529__$1 = state_15529;
var statearr_15531_15631 = state_15529__$1;
(statearr_15531_15631[(2)] = null);

(statearr_15531_15631[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (70))){
var inst_15524 = (state_15529[(2)]);
var _ = (function (){var statearr_15532 = state_15529;
(statearr_15532[(4)] = cljs.core.rest.call(null,(state_15529[(4)])));

return statearr_15532;
})();
var state_15529__$1 = state_15529;
var statearr_15533_15632 = state_15529__$1;
(statearr_15533_15632[(2)] = inst_15524);

(statearr_15533_15632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (62))){
var inst_15510 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15534_15633 = state_15529__$1;
(statearr_15534_15633[(2)] = inst_15510);

(statearr_15534_15633[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (7))){
var state_15529__$1 = state_15529;
var statearr_15535_15634 = state_15529__$1;
(statearr_15535_15634[(2)] = false);

(statearr_15535_15634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (59))){
var inst_15484 = (state_15529[(2)]);
var inst_15485 = fluree.db.util.async.throw_err.call(null,inst_15484);
var state_15529__$1 = state_15529;
var statearr_15536_15635 = state_15529__$1;
(statearr_15536_15635[(2)] = inst_15485);

(statearr_15536_15635[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (20))){
var state_15529__$1 = state_15529;
var statearr_15537_15636 = state_15529__$1;
(statearr_15537_15636[(2)] = null);

(statearr_15537_15636[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (58))){
var inst_15474 = (state_15529[(2)]);
var inst_15475 = fluree.db.util.async.throw_err.call(null,inst_15474);
var inst_15476 = cljs.core.take.call(null,(1),inst_15475);
var state_15529__$1 = state_15529;
var statearr_15538_15637 = state_15529__$1;
(statearr_15538_15637[(2)] = inst_15476);

(statearr_15538_15637[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (60))){
var inst_15371 = (state_15529[(7)]);
var inst_15373 = (state_15529[(8)]);
var inst_15370 = (state_15529[(9)]);
var inst_15410 = (state_15529[(10)]);
var inst_15490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15491 = [inst_15371,inst_15370,inst_15410,inst_15373];
var inst_15492 = (new cljs.core.PersistentVector(null,4,(5),inst_15490,inst_15491,null));
var inst_15493 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15492,opts);
var state_15529__$1 = state_15529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15529__$1,(63),inst_15493);
} else {
if((state_val_15530 === (27))){
var inst_15421 = (state_15529[(11)]);
var inst_15410 = (state_15529[(10)]);
var inst_15421__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_15410);
var state_15529__$1 = (function (){var statearr_15539 = state_15529;
(statearr_15539[(11)] = inst_15421__$1);

return statearr_15539;
})();
if(inst_15421__$1){
var statearr_15540_15638 = state_15529__$1;
(statearr_15540_15638[(1)] = (30));

} else {
var statearr_15541_15639 = state_15529__$1;
(statearr_15541_15639[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (1))){
var state_15529__$1 = state_15529;
var statearr_15542_15640 = state_15529__$1;
(statearr_15542_15640[(2)] = null);

(statearr_15542_15640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (69))){
var inst_15516 = (state_15529[(12)]);
var state_15529__$1 = state_15529;
var statearr_15543_15641 = state_15529__$1;
(statearr_15543_15641[(2)] = inst_15516);

(statearr_15543_15641[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (24))){
var inst_15371 = (state_15529[(7)]);
var state_15529__$1 = state_15529;
if(cljs.core.truth_(inst_15371)){
var statearr_15544_15642 = state_15529__$1;
(statearr_15544_15642[(1)] = (27));

} else {
var statearr_15545_15643 = state_15529__$1;
(statearr_15545_15643[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (55))){
var inst_15410 = (state_15529[(10)]);
var inst_15468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15469 = [inst_15410];
var inst_15470 = (new cljs.core.PersistentVector(null,1,(5),inst_15468,inst_15469,null));
var inst_15471 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15472 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15470,inst_15471);
var state_15529__$1 = state_15529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15529__$1,(58),inst_15472);
} else {
if((state_val_15530 === (39))){
var inst_15441 = (state_15529[(2)]);
var inst_15442 = fluree.db.util.async.throw_err.call(null,inst_15441);
var state_15529__$1 = state_15529;
var statearr_15546_15644 = state_15529__$1;
(statearr_15546_15644[(2)] = inst_15442);

(statearr_15546_15644[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (46))){
var inst_15454 = (state_15529[(13)]);
var inst_15454__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15529__$1 = (function (){var statearr_15547 = state_15529;
(statearr_15547[(13)] = inst_15454__$1);

return statearr_15547;
})();
if(cljs.core.truth_(inst_15454__$1)){
var statearr_15548_15645 = state_15529__$1;
(statearr_15548_15645[(1)] = (49));

} else {
var statearr_15549_15646 = state_15529__$1;
(statearr_15549_15646[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (4))){
var inst_15360 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15550_15647 = state_15529__$1;
(statearr_15550_15647[(2)] = inst_15360);

(statearr_15550_15647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (54))){
var inst_15466 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
if(cljs.core.truth_(inst_15466)){
var statearr_15551_15648 = state_15529__$1;
(statearr_15551_15648[(1)] = (55));

} else {
var statearr_15552_15649 = state_15529__$1;
(statearr_15552_15649[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (15))){
var inst_15372 = (state_15529[(14)]);
var inst_15391 = fluree.db.dbproto._tag_id.call(null,db,inst_15372);
var state_15529__$1 = state_15529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15529__$1,(18),inst_15391);
} else {
if((state_val_15530 === (48))){
var inst_15512 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15553_15650 = state_15529__$1;
(statearr_15553_15650[(2)] = inst_15512);

(statearr_15553_15650[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (50))){
var inst_15454 = (state_15529[(13)]);
var inst_15380 = (state_15529[(15)]);
var inst_15371 = (state_15529[(7)]);
var inst_15373 = (state_15529[(8)]);
var inst_15369 = (state_15529[(16)]);
var inst_15370 = (state_15529[(9)]);
var inst_15385 = (state_15529[(17)]);
var inst_15410 = (state_15529[(10)]);
var inst_15374 = (state_15529[(18)]);
var inst_15458 = (function (){var t = inst_15373;
var vec__15366 = inst_15369;
var p = inst_15371;
var idx_predicate_QMARK_ = inst_15374;
var o = inst_15410;
var tag_predicate_QMARK_ = inst_15380;
var temp__5751__auto__ = inst_15454;
var s = inst_15370;
var o_coerce_QMARK_ = inst_15385;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_15529__$1 = state_15529;
var statearr_15554_15651 = state_15529__$1;
(statearr_15554_15651[(2)] = inst_15458);

(statearr_15554_15651[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (21))){
var inst_15406 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15555_15652 = state_15529__$1;
(statearr_15555_15652[(2)] = inst_15406);

(statearr_15555_15652[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (31))){
var inst_15421 = (state_15529[(11)]);
var state_15529__$1 = state_15529;
var statearr_15556_15653 = state_15529__$1;
(statearr_15556_15653[(2)] = inst_15421);

(statearr_15556_15653[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (32))){
var inst_15431 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15557_15654 = state_15529__$1;
(statearr_15557_15654[(2)] = inst_15431);

(statearr_15557_15654[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (40))){
var inst_15445 = (state_15529[(19)]);
var inst_15374 = (state_15529[(18)]);
var inst_15445__$1 = cljs.core.not.call(null,inst_15374);
var state_15529__$1 = (function (){var statearr_15558 = state_15529;
(statearr_15558[(19)] = inst_15445__$1);

return statearr_15558;
})();
if(inst_15445__$1){
var statearr_15559_15655 = state_15529__$1;
(statearr_15559_15655[(1)] = (43));

} else {
var statearr_15560_15656 = state_15529__$1;
(statearr_15560_15656[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (56))){
var inst_15371 = (state_15529[(7)]);
var inst_15373 = (state_15529[(8)]);
var inst_15460 = (state_15529[(20)]);
var inst_15370 = (state_15529[(9)]);
var inst_15478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15479 = [inst_15371,inst_15370,null,inst_15373];
var inst_15480 = (new cljs.core.PersistentVector(null,4,(5),inst_15478,inst_15479,null));
var inst_15481 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15460);
var inst_15482 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15480,inst_15481);
var state_15529__$1 = state_15529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15529__$1,(59),inst_15482);
} else {
if((state_val_15530 === (33))){
var inst_15410 = (state_15529[(10)]);
var inst_15424 = cljs.core.fn_QMARK_.call(null,inst_15410);
var inst_15425 = (!(inst_15424));
var state_15529__$1 = state_15529;
var statearr_15561_15657 = state_15529__$1;
(statearr_15561_15657[(2)] = inst_15425);

(statearr_15561_15657[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (13))){
var inst_15372 = (state_15529[(14)]);
var inst_15389 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_15372);
var state_15529__$1 = state_15529;
if(cljs.core.truth_(inst_15389)){
var statearr_15562_15658 = state_15529__$1;
(statearr_15562_15658[(1)] = (15));

} else {
var statearr_15563_15659 = state_15529__$1;
(statearr_15563_15659[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (22))){
var inst_15402 = (state_15529[(2)]);
var inst_15403 = fluree.db.util.async.throw_err.call(null,inst_15402);
var state_15529__$1 = state_15529;
var statearr_15564_15660 = state_15529__$1;
(statearr_15564_15660[(2)] = inst_15403);

(statearr_15564_15660[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (36))){
var inst_15371 = (state_15529[(7)]);
var inst_15373 = (state_15529[(8)]);
var inst_15370 = (state_15529[(9)]);
var inst_15410 = (state_15529[(10)]);
var inst_15436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15437 = [inst_15371,inst_15410,inst_15370,inst_15373];
var inst_15438 = (new cljs.core.PersistentVector(null,4,(5),inst_15436,inst_15437,null));
var inst_15439 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15438,opts);
var state_15529__$1 = state_15529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15529__$1,(39),inst_15439);
} else {
if((state_val_15530 === (41))){
var inst_15371 = (state_15529[(7)]);
var state_15529__$1 = state_15529;
var statearr_15565_15661 = state_15529__$1;
(statearr_15565_15661[(2)] = inst_15371);

(statearr_15565_15661[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (43))){
var inst_15410 = (state_15529[(10)]);
var state_15529__$1 = state_15529;
var statearr_15566_15662 = state_15529__$1;
(statearr_15566_15662[(2)] = inst_15410);

(statearr_15566_15662[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (61))){
var inst_15410 = (state_15529[(10)]);
var state_15529__$1 = state_15529;
if(cljs.core.truth_(inst_15410)){
var statearr_15567_15663 = state_15529__$1;
(statearr_15567_15663[(1)] = (64));

} else {
var statearr_15568_15664 = state_15529__$1;
(statearr_15568_15664[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (29))){
var inst_15434 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
if(cljs.core.truth_(inst_15434)){
var statearr_15569_15665 = state_15529__$1;
(statearr_15569_15665[(1)] = (36));

} else {
var statearr_15570_15666 = state_15529__$1;
(statearr_15570_15666[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (44))){
var inst_15445 = (state_15529[(19)]);
var state_15529__$1 = state_15529;
var statearr_15571_15667 = state_15529__$1;
(statearr_15571_15667[(2)] = inst_15445);

(statearr_15571_15667[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (6))){
var inst_15371 = (state_15529[(7)]);
var inst_15376 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15371);
var inst_15377 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15376);
var state_15529__$1 = state_15529;
var statearr_15572_15668 = state_15529__$1;
(statearr_15572_15668[(2)] = inst_15377);

(statearr_15572_15668[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (28))){
var inst_15371 = (state_15529[(7)]);
var state_15529__$1 = state_15529;
var statearr_15573_15669 = state_15529__$1;
(statearr_15573_15669[(2)] = inst_15371);

(statearr_15573_15669[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (64))){
var inst_15371 = (state_15529[(7)]);
var inst_15373 = (state_15529[(8)]);
var inst_15370 = (state_15529[(9)]);
var inst_15410 = (state_15529[(10)]);
var inst_15499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15500 = [inst_15410,inst_15371,inst_15370,inst_15373];
var inst_15501 = (new cljs.core.PersistentVector(null,4,(5),inst_15499,inst_15500,null));
var inst_15502 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15501,opts);
var state_15529__$1 = state_15529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15529__$1,(67),inst_15502);
} else {
if((state_val_15530 === (51))){
var inst_15371 = (state_15529[(7)]);
var inst_15461 = (state_15529[(21)]);
var inst_15460 = (state_15529[(2)]);
var inst_15461__$1 = cljs.core._EQ_.call(null,"_id",inst_15371);
var state_15529__$1 = (function (){var statearr_15574 = state_15529;
(statearr_15574[(20)] = inst_15460);

(statearr_15574[(21)] = inst_15461__$1);

return statearr_15574;
})();
if(inst_15461__$1){
var statearr_15575_15670 = state_15529__$1;
(statearr_15575_15670[(1)] = (52));

} else {
var statearr_15576_15671 = state_15529__$1;
(statearr_15576_15671[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (25))){
var inst_15380 = (state_15529[(15)]);
var inst_15516 = (state_15529[(2)]);
var state_15529__$1 = (function (){var statearr_15577 = state_15529;
(statearr_15577[(12)] = inst_15516);

return statearr_15577;
})();
if(cljs.core.truth_(inst_15380)){
var statearr_15578_15672 = state_15529__$1;
(statearr_15578_15672[(1)] = (68));

} else {
var statearr_15579_15673 = state_15529__$1;
(statearr_15579_15673[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (34))){
var inst_15374 = (state_15529[(18)]);
var state_15529__$1 = state_15529;
var statearr_15580_15674 = state_15529__$1;
(statearr_15580_15674[(2)] = inst_15374);

(statearr_15580_15674[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (17))){
var inst_15408 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15581_15675 = state_15529__$1;
(statearr_15581_15675[(2)] = inst_15408);

(statearr_15581_15675[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (3))){
var inst_15527 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15529__$1,inst_15527);
} else {
if((state_val_15530 === (12))){
var inst_15372 = (state_15529[(14)]);
var state_15529__$1 = state_15529;
var statearr_15582_15676 = state_15529__$1;
(statearr_15582_15676[(2)] = inst_15372);

(statearr_15582_15676[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (2))){
var inst_15371 = (state_15529[(7)]);
var inst_15369 = (state_15529[(16)]);
var _ = (function (){var statearr_15583 = state_15529;
(statearr_15583[(4)] = cljs.core.cons.call(null,(5),(state_15529[(4)])));

return statearr_15583;
})();
var inst_15369__$1 = fparts;
var inst_15370 = cljs.core.nth.call(null,inst_15369__$1,(0),null);
var inst_15371__$1 = cljs.core.nth.call(null,inst_15369__$1,(1),null);
var inst_15372 = cljs.core.nth.call(null,inst_15369__$1,(2),null);
var inst_15373 = cljs.core.nth.call(null,inst_15369__$1,(3),null);
var inst_15374 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15371__$1);
var state_15529__$1 = (function (){var statearr_15584 = state_15529;
(statearr_15584[(7)] = inst_15371__$1);

(statearr_15584[(8)] = inst_15373);

(statearr_15584[(16)] = inst_15369__$1);

(statearr_15584[(14)] = inst_15372);

(statearr_15584[(9)] = inst_15370);

(statearr_15584[(18)] = inst_15374);

return statearr_15584;
})();
if(cljs.core.truth_(inst_15371__$1)){
var statearr_15585_15677 = state_15529__$1;
(statearr_15585_15677[(1)] = (6));

} else {
var statearr_15586_15678 = state_15529__$1;
(statearr_15586_15678[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (66))){
var inst_15508 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15587_15679 = state_15529__$1;
(statearr_15587_15679[(2)] = inst_15508);

(statearr_15587_15679[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (23))){
var inst_15371 = (state_15529[(7)]);
var inst_15373 = (state_15529[(8)]);
var inst_15370 = (state_15529[(9)]);
var inst_15410 = (state_15529[(10)]);
var inst_15412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15413 = [inst_15370,inst_15371,inst_15410,inst_15373];
var inst_15414 = (new cljs.core.PersistentVector(null,4,(5),inst_15412,inst_15413,null));
var inst_15415 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15414,opts);
var state_15529__$1 = state_15529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15529__$1,(26),inst_15415);
} else {
if((state_val_15530 === (47))){
var inst_15371 = (state_15529[(7)]);
var state_15529__$1 = state_15529;
if(cljs.core.truth_(inst_15371)){
var statearr_15588_15680 = state_15529__$1;
(statearr_15588_15680[(1)] = (60));

} else {
var statearr_15589_15681 = state_15529__$1;
(statearr_15589_15681[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (35))){
var inst_15428 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15590_15682 = state_15529__$1;
(statearr_15590_15682[(2)] = inst_15428);

(statearr_15590_15682[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (19))){
var inst_15371 = (state_15529[(7)]);
var inst_15372 = (state_15529[(14)]);
var inst_15398 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15371);
var inst_15399 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15398),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15372)].join('');
var inst_15400 = fluree.db.dbproto._tag_id.call(null,db,inst_15399);
var state_15529__$1 = state_15529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15529__$1,(22),inst_15400);
} else {
if((state_val_15530 === (57))){
var inst_15487 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15591_15683 = state_15529__$1;
(statearr_15591_15683[(2)] = inst_15487);

(statearr_15591_15683[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (68))){
var inst_15516 = (state_15529[(12)]);
var inst_15518 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_15516);
var state_15529__$1 = state_15529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15529__$1,(71),inst_15518);
} else {
if((state_val_15530 === (11))){
var inst_15385 = (state_15529[(17)]);
var inst_15385__$1 = (state_15529[(2)]);
var inst_15386 = cljs.core.not.call(null,inst_15385__$1);
var state_15529__$1 = (function (){var statearr_15593 = state_15529;
(statearr_15593[(17)] = inst_15385__$1);

return statearr_15593;
})();
if(inst_15386){
var statearr_15594_15684 = state_15529__$1;
(statearr_15594_15684[(1)] = (12));

} else {
var statearr_15595_15685 = state_15529__$1;
(statearr_15595_15685[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (9))){
var inst_15372 = (state_15529[(14)]);
var inst_15382 = typeof inst_15372 === 'string';
var state_15529__$1 = state_15529;
var statearr_15596_15686 = state_15529__$1;
(statearr_15596_15686[(2)] = inst_15382);

(statearr_15596_15686[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (5))){
var _ = (function (){var statearr_15597 = state_15529;
(statearr_15597[(4)] = cljs.core.rest.call(null,(state_15529[(4)])));

return statearr_15597;
})();
var state_15529__$1 = state_15529;
var ex15592 = (state_15529__$1[(2)]);
var statearr_15598_15687 = state_15529__$1;
(statearr_15598_15687[(5)] = ex15592);


if((ex15592 instanceof Error)){
var statearr_15599_15688 = state_15529__$1;
(statearr_15599_15688[(1)] = (4));

(statearr_15599_15688[(5)] = null);

} else {
throw ex15592;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (14))){
var inst_15370 = (state_15529[(9)]);
var inst_15410 = (state_15529[(2)]);
var state_15529__$1 = (function (){var statearr_15600 = state_15529;
(statearr_15600[(10)] = inst_15410);

return statearr_15600;
})();
if(cljs.core.truth_(inst_15370)){
var statearr_15601_15689 = state_15529__$1;
(statearr_15601_15689[(1)] = (23));

} else {
var statearr_15602_15690 = state_15529__$1;
(statearr_15602_15690[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (45))){
var inst_15449 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15603_15691 = state_15529__$1;
(statearr_15603_15691[(2)] = inst_15449);

(statearr_15603_15691[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (53))){
var inst_15461 = (state_15529[(21)]);
var state_15529__$1 = state_15529;
var statearr_15604_15692 = state_15529__$1;
(statearr_15604_15692[(2)] = inst_15461);

(statearr_15604_15692[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (26))){
var inst_15417 = (state_15529[(2)]);
var inst_15418 = fluree.db.util.async.throw_err.call(null,inst_15417);
var state_15529__$1 = state_15529;
var statearr_15605_15693 = state_15529__$1;
(statearr_15605_15693[(2)] = inst_15418);

(statearr_15605_15693[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (16))){
var inst_15372 = (state_15529[(14)]);
var inst_15396 = typeof inst_15372 === 'string';
var state_15529__$1 = state_15529;
if(cljs.core.truth_(inst_15396)){
var statearr_15606_15694 = state_15529__$1;
(statearr_15606_15694[(1)] = (19));

} else {
var statearr_15607_15695 = state_15529__$1;
(statearr_15607_15695[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (38))){
var inst_15514 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
var statearr_15608_15696 = state_15529__$1;
(statearr_15608_15696[(2)] = inst_15514);

(statearr_15608_15696[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (30))){
var inst_15374 = (state_15529[(18)]);
var state_15529__$1 = state_15529;
if(cljs.core.truth_(inst_15374)){
var statearr_15609_15697 = state_15529__$1;
(statearr_15609_15697[(1)] = (33));

} else {
var statearr_15610_15698 = state_15529__$1;
(statearr_15610_15698[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (10))){
var inst_15380 = (state_15529[(15)]);
var state_15529__$1 = state_15529;
var statearr_15611_15699 = state_15529__$1;
(statearr_15611_15699[(2)] = inst_15380);

(statearr_15611_15699[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (18))){
var inst_15393 = (state_15529[(2)]);
var inst_15394 = fluree.db.util.async.throw_err.call(null,inst_15393);
var state_15529__$1 = state_15529;
var statearr_15612_15700 = state_15529__$1;
(statearr_15612_15700[(2)] = inst_15394);

(statearr_15612_15700[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (52))){
var inst_15410 = (state_15529[(10)]);
var inst_15463 = cljs.core.int_QMARK_.call(null,inst_15410);
var state_15529__$1 = state_15529;
var statearr_15613_15701 = state_15529__$1;
(statearr_15613_15701[(2)] = inst_15463);

(statearr_15613_15701[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (67))){
var inst_15504 = (state_15529[(2)]);
var inst_15505 = fluree.db.util.async.throw_err.call(null,inst_15504);
var state_15529__$1 = state_15529;
var statearr_15614_15702 = state_15529__$1;
(statearr_15614_15702[(2)] = inst_15505);

(statearr_15614_15702[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (71))){
var inst_15520 = (state_15529[(2)]);
var inst_15521 = fluree.db.util.async.throw_err.call(null,inst_15520);
var state_15529__$1 = state_15529;
var statearr_15615_15703 = state_15529__$1;
(statearr_15615_15703[(2)] = inst_15521);

(statearr_15615_15703[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (42))){
var inst_15452 = (state_15529[(2)]);
var state_15529__$1 = state_15529;
if(cljs.core.truth_(inst_15452)){
var statearr_15616_15704 = state_15529__$1;
(statearr_15616_15704[(1)] = (46));

} else {
var statearr_15617_15705 = state_15529__$1;
(statearr_15617_15705[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (37))){
var inst_15371 = (state_15529[(7)]);
var state_15529__$1 = state_15529;
if(cljs.core.truth_(inst_15371)){
var statearr_15618_15706 = state_15529__$1;
(statearr_15618_15706[(1)] = (40));

} else {
var statearr_15619_15707 = state_15529__$1;
(statearr_15619_15707[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (63))){
var inst_15495 = (state_15529[(2)]);
var inst_15496 = fluree.db.util.async.throw_err.call(null,inst_15495);
var state_15529__$1 = state_15529;
var statearr_15620_15708 = state_15529__$1;
(statearr_15620_15708[(2)] = inst_15496);

(statearr_15620_15708[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (8))){
var inst_15380 = (state_15529[(15)]);
var inst_15380__$1 = (state_15529[(2)]);
var state_15529__$1 = (function (){var statearr_15621 = state_15529;
(statearr_15621[(15)] = inst_15380__$1);

return statearr_15621;
})();
if(cljs.core.truth_(inst_15380__$1)){
var statearr_15622_15709 = state_15529__$1;
(statearr_15622_15709[(1)] = (9));

} else {
var statearr_15623_15710 = state_15529__$1;
(statearr_15623_15710[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15530 === (49))){
var inst_15454 = (state_15529[(13)]);
var inst_15380 = (state_15529[(15)]);
var inst_15371 = (state_15529[(7)]);
var inst_15373 = (state_15529[(8)]);
var inst_15369 = (state_15529[(16)]);
var inst_15370 = (state_15529[(9)]);
var inst_15385 = (state_15529[(17)]);
var inst_15410 = (state_15529[(10)]);
var inst_15374 = (state_15529[(18)]);
var inst_15456 = (function (){var obj_fn = inst_15454;
var t = inst_15373;
var vec__15366 = inst_15369;
var p = inst_15371;
var idx_predicate_QMARK_ = inst_15374;
var o = inst_15410;
var tag_predicate_QMARK_ = inst_15380;
var temp__5751__auto__ = inst_15454;
var s = inst_15370;
var o_coerce_QMARK_ = inst_15385;
return (function (x){
var and__4251__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4251__auto__;
}
});
})();
var state_15529__$1 = state_15529;
var statearr_15624_15711 = state_15529__$1;
(statearr_15624_15711[(2)] = inst_15456);

(statearr_15624_15711[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15625 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15625[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15625[(1)] = (1));

return statearr_15625;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15529){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15529);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15626){var ex__2749__auto__ = e15626;
var statearr_15627_15712 = state_15529;
(statearr_15627_15712[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15529[(4)]))){
var statearr_15628_15713 = state_15529;
(statearr_15628_15713[(1)] = cljs.core.first.call(null,(state_15529[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15714 = state_15529;
state_15529 = G__15714;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15529){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15629 = f__2769__auto__.call(null);
(statearr_15629[(6)] = c__2768__auto__);

return statearr_15629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15716 = arguments.length;
switch (G__15716) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15751){
var state_val_15752 = (state_15751[(1)]);
if((state_val_15752 === (7))){
var inst_15738 = cljs.core.pr_str.call(null,name);
var inst_15739 = ["Invalid collection name: ",inst_15738].join('');
var inst_15740 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15741 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15742 = cljs.core.PersistentHashMap.fromArrays(inst_15740,inst_15741);
var inst_15743 = cljs.core.ex_info.call(null,inst_15739,inst_15742);
var inst_15744 = (function(){throw inst_15743})();
var state_15751__$1 = state_15751;
var statearr_15753_15773 = state_15751__$1;
(statearr_15753_15773[(2)] = inst_15744);

(statearr_15753_15773[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15752 === (1))){
var state_15751__$1 = state_15751;
var statearr_15754_15774 = state_15751__$1;
(statearr_15754_15774[(2)] = null);

(statearr_15754_15774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15752 === (4))){
var inst_15717 = (state_15751[(2)]);
var state_15751__$1 = state_15751;
var statearr_15755_15775 = state_15751__$1;
(statearr_15755_15775[(2)] = inst_15717);

(statearr_15755_15775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15752 === (6))){
var inst_15723 = (state_15751[(7)]);
var inst_15725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15726 = fluree.db.flake.max_subject_id.call(null,inst_15723);
var inst_15727 = [inst_15726];
var inst_15728 = (new cljs.core.PersistentVector(null,1,(5),inst_15725,inst_15727,null));
var inst_15729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15730 = fluree.db.flake.min_subject_id.call(null,inst_15723);
var inst_15731 = [inst_15730];
var inst_15732 = (new cljs.core.PersistentVector(null,1,(5),inst_15729,inst_15731,null));
var inst_15733 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15728,cljs.core._LT__EQ_,inst_15732,opts);
var state_15751__$1 = state_15751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15751__$1,(9),inst_15733);
} else {
if((state_val_15752 === (3))){
var inst_15749 = (state_15751[(2)]);
var state_15751__$1 = state_15751;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15751__$1,inst_15749);
} else {
if((state_val_15752 === (2))){
var inst_15723 = (state_15751[(7)]);
var _ = (function (){var statearr_15757 = state_15751;
(statearr_15757[(4)] = cljs.core.cons.call(null,(5),(state_15751[(4)])));

return statearr_15757;
})();
var inst_15723__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_15751__$1 = (function (){var statearr_15758 = state_15751;
(statearr_15758[(7)] = inst_15723__$1);

return statearr_15758;
})();
if(cljs.core.truth_(inst_15723__$1)){
var statearr_15759_15776 = state_15751__$1;
(statearr_15759_15776[(1)] = (6));

} else {
var statearr_15760_15777 = state_15751__$1;
(statearr_15760_15777[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15752 === (9))){
var inst_15735 = (state_15751[(2)]);
var inst_15736 = fluree.db.util.async.throw_err.call(null,inst_15735);
var state_15751__$1 = state_15751;
var statearr_15761_15778 = state_15751__$1;
(statearr_15761_15778[(2)] = inst_15736);

(statearr_15761_15778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15752 === (5))){
var _ = (function (){var statearr_15762 = state_15751;
(statearr_15762[(4)] = cljs.core.rest.call(null,(state_15751[(4)])));

return statearr_15762;
})();
var state_15751__$1 = state_15751;
var ex15756 = (state_15751__$1[(2)]);
var statearr_15763_15779 = state_15751__$1;
(statearr_15763_15779[(5)] = ex15756);


var statearr_15764_15780 = state_15751__$1;
(statearr_15764_15780[(1)] = (4));

(statearr_15764_15780[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15752 === (8))){
var inst_15746 = (state_15751[(2)]);
var _ = (function (){var statearr_15765 = state_15751;
(statearr_15765[(4)] = cljs.core.rest.call(null,(state_15751[(4)])));

return statearr_15765;
})();
var state_15751__$1 = state_15751;
var statearr_15766_15781 = state_15751__$1;
(statearr_15766_15781[(2)] = inst_15746);

(statearr_15766_15781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15767 = [null,null,null,null,null,null,null,null];
(statearr_15767[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15767[(1)] = (1));

return statearr_15767;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15751){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15768){var ex__2749__auto__ = e15768;
var statearr_15769_15782 = state_15751;
(statearr_15769_15782[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15751[(4)]))){
var statearr_15770_15783 = state_15751;
(statearr_15770_15783[(1)] = cljs.core.first.call(null,(state_15751[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15784 = state_15751;
state_15751 = G__15784;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15751){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15771 = f__2769__auto__.call(null);
(statearr_15771[(6)] = c__2768__auto__);

return statearr_15771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15788 = flakes;
var vec__15789 = G__15788;
var seq__15790 = cljs.core.seq.call(null,vec__15789);
var first__15791 = cljs.core.first.call(null,seq__15790);
var seq__15790__$1 = cljs.core.next.call(null,seq__15790);
var flake_SINGLEQUOTE_ = first__15791;
var r = seq__15790__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15788__$1 = G__15788;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15797 = G__15788__$1;
var seq__15798 = cljs.core.seq.call(null,vec__15797);
var first__15799 = cljs.core.first.call(null,seq__15798);
var seq__15798__$1 = cljs.core.next.call(null,seq__15798);
var flake_SINGLEQUOTE___$1 = first__15799;
var r__$1 = seq__15798__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e15801){var e = e15801;
return null;
}})();
var map__15800 = cmd_map;
var map__15800__$1 = cljs.core.__destructure_map.call(null,map__15800);
var type = cljs.core.get.call(null,map__15800__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__15800__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__15800__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__15800__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__15800__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__15800__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15802 = r__$1;
var G__15803 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15788__$1 = G__15802;
result_STAR___$1 = G__15803;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15812 = blocks;
var vec__15813 = G__15812;
var seq__15814 = cljs.core.seq.call(null,vec__15813);
var first__15815 = cljs.core.first.call(null,seq__15814);
var seq__15814__$1 = cljs.core.next.call(null,seq__15814);
var block_SINGLEQUOTE_ = first__15815;
var r = seq__15814__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15812__$1 = G__15812;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15820 = G__15812__$1;
var seq__15821 = cljs.core.seq.call(null,vec__15820);
var first__15822 = cljs.core.first.call(null,seq__15821);
var seq__15821__$1 = cljs.core.next.call(null,seq__15821);
var block_SINGLEQUOTE___$1 = first__15822;
var r__$1 = seq__15821__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15823 = block_SINGLEQUOTE___$1;
var map__15823__$1 = cljs.core.__destructure_map.call(null,map__15823);
var block = cljs.core.get.call(null,map__15823__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__15823__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__15823__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__15812__$1,result_STAR___$1,map__15823,map__15823__$1,block,t,flakes,vec__15820,seq__15821,first__15822,seq__15821__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15812,vec__15813,seq__15814,first__15815,seq__15814__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15804_SHARP_){
var f = p1__15804_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__15812__$1,result_STAR___$1,map__15823,map__15823__$1,block,t,flakes,vec__15820,seq__15821,first__15822,seq__15821__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15812,vec__15813,seq__15814,first__15815,seq__15814__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__15812__$1,result_STAR___$1,map__15823,map__15823__$1,block,t,flakes,prev_hash,vec__15820,seq__15821,first__15822,seq__15821__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15812,vec__15813,seq__15814,first__15815,seq__15814__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15805_SHARP_){
var f = p1__15805_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__15812__$1,result_STAR___$1,map__15823,map__15823__$1,block,t,flakes,prev_hash,vec__15820,seq__15821,first__15822,seq__15821__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15812,vec__15813,seq__15814,first__15815,seq__15814__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__15812__$1,result_STAR___$1,map__15823,map__15823__$1,block,t,flakes,prev_hash,hash,vec__15820,seq__15821,first__15822,seq__15821__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15812,vec__15813,seq__15814,first__15815,seq__15814__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15806_SHARP_){
var f = p1__15806_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__15812__$1,result_STAR___$1,map__15823,map__15823__$1,block,t,flakes,prev_hash,hash,vec__15820,seq__15821,first__15822,seq__15821__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15812,vec__15813,seq__15814,first__15815,seq__15814__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__15812__$1,result_STAR___$1,map__15823,map__15823__$1,block,t,flakes,prev_hash,hash,instant,vec__15820,seq__15821,first__15822,seq__15821__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15812,vec__15813,seq__15814,first__15815,seq__15814__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15807_SHARP_){
var f = p1__15807_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__15812__$1,result_STAR___$1,map__15823,map__15823__$1,block,t,flakes,prev_hash,hash,instant,vec__15820,seq__15821,first__15822,seq__15821__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15812,vec__15813,seq__15814,first__15815,seq__15814__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__15812__$1,result_STAR___$1,map__15823,map__15823__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15820,seq__15821,first__15822,seq__15821__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15812,vec__15813,seq__15814,first__15815,seq__15814__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15808_SHARP_){
return cljs.core._EQ_.call(null,p1__15808_SHARP_.p,(106));
});})(G__15812__$1,result_STAR___$1,map__15823,map__15823__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15820,seq__15821,first__15822,seq__15821__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15812,vec__15813,seq__15814,first__15815,seq__15814__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__15824 = r__$1;
var G__15825 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15812__$1 = G__15824;
result_STAR___$1 = G__15825;
continue;
}
break;
}
});
